
module ol_vamp_1_pphvv_ew_haawwx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphvv_ew_haawwx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphvv_ew_haawwx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pphvv_ew_haawwx_1_/**/DREALKIND
  use ol_tensor_sum_storage_pphvv_ew_haawwx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pphvv_ew_haawwx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pphvv_ew_haawwx_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(133)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[nML,nML,nML,nML,0],5,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(1),m3h3x12(:,1),heltab2x36(:,:,1))
  call Hloop_A_Q(ntryL,G0H12(1),16,nML,G1H12(1),n2h12(1))
  Gcoeff(:)%j = (-(c(143)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[nMT,nMT,nMT,nMT,nMB],5,0)
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(1),m3h3x12(:,2),heltab2x36(:,:,2))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMT,G1H12(2),n2h12(2))
  Gcoeff(:)%j = (-(c(119)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[nMB,nMB,nMB,nMB,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(1),m3h3x12(:,3),heltab2x36(:,:,3))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(3),n2h12(3))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(4),m3h3x12(:,4),heltab2x36(:,:,4))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(5),h0tab(:,5),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(5),m3h3x12(:,5),heltab2x36(:,:,5))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(6),h0tab(:,6),[16,4,1,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(6),m3h3x12(:,6),heltab2x36(:,:,6))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(7),h0tab(:,7),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(7),m3h3x12(:,7),heltab2x36(:,:,7))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(8),h0tab(:,8),[16,4,1,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(8),m3h3x12(:,8),heltab2x36(:,:,8))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(9),h0tab(:,9),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(9),m3h3x12(:,9),heltab2x36(:,:,9))
  Gcoeff(:)%j = (c(45)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(10),h0tab(:,10),[16,4,1,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(10),m3h3x12(:,10),heltab2x36(:,:,10))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(11),h0tab(:,11),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(11),m3h3x12(:,11),heltab2x36(:,:,11))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(12),h0tab(:,12),[16,4,1,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(1),m3h3x12(:,12),heltab2x36(:,:,12))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(13),h0tab(:,13),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(2),m3h3x12(:,13),heltab2x36(:,:,13))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(14),h0tab(:,14),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(3),m3h3x12(:,14),heltab2x36(:,:,14))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(15),h0tab(:,15),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(12),m3h3x12(:,15),heltab2x36(:,:,15))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(16),h0tab(:,16),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(13),m3h3x12(:,16),heltab2x36(:,:,16))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(17),h0tab(:,17),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(14),m3h3x12(:,17),heltab2x36(:,:,17))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(18),h0tab(:,18),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(15),m3h3x12(:,18),heltab2x36(:,:,18))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(19),h0tab(:,19),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(16),m3h3x12(:,19),heltab2x36(:,:,19))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(20),h0tab(:,20),[16,4,1,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(17),m3h3x12(:,20),heltab2x36(:,:,20))
  Gcoeff(:)%j = (c(49)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(21),h0tab(:,21),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(18),m3h3x12(:,21),heltab2x36(:,:,21))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(22),h0tab(:,22),[16,4,1,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(4),m3h3x12(:,22),heltab2x36(:,:,22))
  Gcoeff(:)%j = (c(49)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(23),h0tab(:,23),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(5),m3h3x12(:,23),heltab2x36(:,:,23))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(24),h0tab(:,24),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(6),m3h3x12(:,24),heltab2x36(:,:,24))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(25),h0tab(:,25),[16,4,1,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(7),m3h3x12(:,25),heltab2x36(:,:,25))
  Gcoeff(:)%j = (c(64)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(26),h0tab(:,26),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(8),m3h3x12(:,26),heltab2x36(:,:,26))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(27),h0tab(:,27),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(9),m3h3x12(:,27),heltab2x36(:,:,27))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(28),h0tab(:,28),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(19),m3h3x12(:,28),heltab2x36(:,:,28))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(29),h0tab(:,29),[16,4,1,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(10),m3h3x12(:,29),heltab2x36(:,:,29))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(30),h0tab(:,30),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(11),m3h3x12(:,30),heltab2x36(:,:,30))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(31),h0tab(:,31),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(12),m3h3x12(:,31),heltab2x36(:,:,31))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(32),h0tab(:,32),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(20),m3h3x12(:,32),heltab2x36(:,:,32))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(33),h0tab(:,33),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(21),m3h3x12(:,33),heltab2x36(:,:,33))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(34),h0tab(:,34),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(22),m3h3x12(:,34),heltab2x36(:,:,34))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(35),h0tab(:,35),[16,4,1,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(23),m3h3x12(:,35),heltab2x36(:,:,35))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(36),h0tab(:,36),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(24),m3h3x12(:,36),heltab2x36(:,:,36))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(37),h0tab(:,37),[16,4,1,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(25),m3h3x12(:,37),heltab2x36(:,:,37))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(38),h0tab(:,38),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(26),m3h3x12(:,38),heltab2x36(:,:,38))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(39),h0tab(:,39),[16,4,1,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(13),m3h3x12(:,39),heltab2x36(:,:,39))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(40),h0tab(:,40),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(14),m3h3x12(:,40),heltab2x36(:,:,40))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(41),h0tab(:,41),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(15),m3h3x12(:,41),heltab2x36(:,:,41))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(42),h0tab(:,42),[16,4,1,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(27),m3h3x12(:,42),heltab2x36(:,:,42))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(43),h0tab(:,43),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(28),m3h3x12(:,43),heltab2x36(:,:,43))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(44),h0tab(:,44),[16,4,1,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(16),m3h3x12(:,44),heltab2x36(:,:,44))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(45),h0tab(:,45),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(17),m3h3x12(:,45),heltab2x36(:,:,45))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(46),h0tab(:,46),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(18),m3h3x12(:,46),heltab2x36(:,:,46))
  Gcoeff(:)%j = (c(57)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(47),h0tab(:,47),[16,4,1,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(19),m3h3x12(:,47),heltab2x36(:,:,47))
  Gcoeff(:)%j = (c(69)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(48),h0tab(:,48),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(20),m3h3x12(:,48),heltab2x36(:,:,48))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(49),h0tab(:,49),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(21),m3h3x12(:,49),heltab2x36(:,:,49))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(50),h0tab(:,50),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(29),m3h3x12(:,50),heltab2x36(:,:,50))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(51),h0tab(:,51),[16,4,1,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(30),m3h3x12(:,51),heltab2x36(:,:,51))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(52),h0tab(:,52),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(31),m3h3x12(:,52),heltab2x36(:,:,52))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(53),h0tab(:,53),[16,4,1,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(32),m3h3x12(:,53),heltab2x36(:,:,53))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(54),h0tab(:,54),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(33),m3h3x12(:,54),heltab2x36(:,:,54))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(55),h0tab(:,55),[16,4,1,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(34),m3h3x12(:,55),heltab2x36(:,:,55))
  Gcoeff(:)%j = (c(52)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(56),h0tab(:,56),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(35),m3h3x12(:,56),heltab2x36(:,:,56))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(57),h0tab(:,57),[16,4,1,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(22),m3h3x12(:,57),heltab2x36(:,:,57))
  Gcoeff(:)%j = (c(52)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(58),h0tab(:,58),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(23),m3h3x12(:,58),heltab2x36(:,:,58))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(59),h0tab(:,59),[16,4,1,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(24),m3h3x12(:,59),heltab2x36(:,:,59))
  Gcoeff(:)%j = (-(c(133)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(60),h0tab(:,60),[16,2,1,4,8],[nML,nML,nML,nML,0],5,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(25),m3h3x12(:,60),heltab2x36(:,:,60))
  call Hloop_A_Q(ntryL,G0H12(25),16,nML,G1H12(36),n2h12(4))
  Gcoeff(:)%j = (-(c(143)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(61),h0tab(:,61),[16,2,1,4,8],[nMT,nMT,nMT,nMT,nMB],5,0)
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(25),m3h3x12(:,61),heltab2x36(:,:,61))
  call Hloop_Q_A(ntryL,G0H12(25),16,nMT,G1H12(37),n2h12(5))
  Gcoeff(:)%j = (-(c(119)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(62),h0tab(:,62),[16,2,1,4,8],[nMB,nMB,nMB,nMB,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(25),m3h3x12(:,62),heltab2x36(:,:,62))
  call Hloop_A_Q(ntryL,G0H12(25),16,nMB,G1H12(38),n2h12(6))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(63),h0tab(:,63),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(39),m3h3x12(:,63),heltab2x36(:,:,63))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(64),h0tab(:,64),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(40),m3h3x12(:,64),heltab2x36(:,:,64))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(65),h0tab(:,65),[16,2,1,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(41),m3h3x12(:,65),heltab2x36(:,:,65))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(66),h0tab(:,66),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(42),m3h3x12(:,66),heltab2x36(:,:,66))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(67),h0tab(:,67),[16,2,1,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(43),m3h3x12(:,67),heltab2x36(:,:,67))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(68),h0tab(:,68),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(44),m3h3x12(:,68),heltab2x36(:,:,68))
  Gcoeff(:)%j = (c(45)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(69),h0tab(:,69),[16,2,1,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(45),m3h3x12(:,69),heltab2x36(:,:,69))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(70),h0tab(:,70),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(46),m3h3x12(:,70),heltab2x36(:,:,70))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(71),h0tab(:,71),[16,2,1,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(25),m3h3x12(:,71),heltab2x36(:,:,71))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(72),h0tab(:,72),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(26),m3h3x12(:,72),heltab2x36(:,:,72))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(73),h0tab(:,73),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(47),m3h3x12(:,73),heltab2x36(:,:,73))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(74),h0tab(:,74),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(27),m3h3x12(:,74),heltab2x36(:,:,74))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(75),h0tab(:,75),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(48),m3h3x12(:,75),heltab2x36(:,:,75))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(76),h0tab(:,76),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(49),m3h3x12(:,76),heltab2x36(:,:,76))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(77),h0tab(:,77),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(50),m3h3x12(:,77),heltab2x36(:,:,77))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(78),h0tab(:,78),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(51),m3h3x12(:,78),heltab2x36(:,:,78))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(79),h0tab(:,79),[16,2,1,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(28),m3h3x12(:,79),heltab2x36(:,:,79))
  Gcoeff(:)%j = (c(49)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(80),h0tab(:,80),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(29),m3h3x12(:,80),heltab2x36(:,:,80))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(81),h0tab(:,81),[16,2,1,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(52),m3h3x12(:,81),heltab2x36(:,:,81))
  Gcoeff(:)%j = (c(49)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(82),h0tab(:,82),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(53),m3h3x12(:,82),heltab2x36(:,:,82))
  Gcoeff(:)%j = (c(39)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(83),h0tab(:,83),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(30),m3h3x12(:,83),heltab2x36(:,:,83))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(84),h0tab(:,84),[16,2,1,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(31),m3h3x12(:,84),heltab2x36(:,:,84))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(85),h0tab(:,85),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(32),m3h3x12(:,85),heltab2x36(:,:,85))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(86),h0tab(:,86),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(54),m3h3x12(:,86),heltab2x36(:,:,86))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(87),h0tab(:,87),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(33),m3h3x12(:,87),heltab2x36(:,:,87))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(88),h0tab(:,88),[16,2,1,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(34),m3h3x12(:,88),heltab2x36(:,:,88))
  Gcoeff(:)%j = (c(64)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(89),h0tab(:,89),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(35),m3h3x12(:,89),heltab2x36(:,:,89))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(90),h0tab(:,90),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(55),m3h3x12(:,90),heltab2x36(:,:,90))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(91),h0tab(:,91),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(36),m3h3x12(:,91),heltab2x36(:,:,91))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(92),h0tab(:,92),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(56),m3h3x12(:,92),heltab2x36(:,:,92))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(93),h0tab(:,93),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(57),m3h3x12(:,93),heltab2x36(:,:,93))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(94),h0tab(:,94),[16,2,1,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(58),m3h3x12(:,94),heltab2x36(:,:,94))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(95),h0tab(:,95),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(59),m3h3x12(:,95),heltab2x36(:,:,95))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(96),h0tab(:,96),[16,2,1,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(37),m3h3x12(:,96),heltab2x36(:,:,96))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(97),h0tab(:,97),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(38),m3h3x12(:,97),heltab2x36(:,:,97))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(98),h0tab(:,98),[16,2,1,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(60),m3h3x12(:,98),heltab2x36(:,:,98))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(99),h0tab(:,99),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(61),m3h3x12(:,99),heltab2x36(:,:,99))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(100),h0tab(:,100),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(39),m3h3x12(:,100),heltab2x36(:,:,100))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(101),h0tab(:,101),[16,2,1,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(40),m3h3x12(:,101),heltab2x36(:,:,101))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(102),h0tab(:,102),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(41),m3h3x12(:,102),heltab2x36(:,:,102))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(103),h0tab(:,103),[16,2,1,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(62),m3h3x12(:,103),heltab2x36(:,:,103))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(104),h0tab(:,104),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(63),m3h3x12(:,104),heltab2x36(:,:,104))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(105),h0tab(:,105),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(42),m3h3x12(:,105),heltab2x36(:,:,105))
  Gcoeff(:)%j = (c(57)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(106),h0tab(:,106),[16,2,1,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(43),m3h3x12(:,106),heltab2x36(:,:,106))
  Gcoeff(:)%j = (c(69)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(107),h0tab(:,107),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(44),m3h3x12(:,107),heltab2x36(:,:,107))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(108),h0tab(:,108),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(64),m3h3x12(:,108),heltab2x36(:,:,108))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(109),h0tab(:,109),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(45),m3h3x12(:,109),heltab2x36(:,:,109))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(110),h0tab(:,110),[16,2,1,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(65),m3h3x12(:,110),heltab2x36(:,:,110))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(111),h0tab(:,111),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(66),m3h3x12(:,111),heltab2x36(:,:,111))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(112),h0tab(:,112),[16,2,1,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(67),m3h3x12(:,112),heltab2x36(:,:,112))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(113),h0tab(:,113),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(68),m3h3x12(:,113),heltab2x36(:,:,113))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(114),h0tab(:,114),[16,2,1,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(46),m3h3x12(:,114),heltab2x36(:,:,114))
  Gcoeff(:)%j = (c(52)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(115),h0tab(:,115),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(47),m3h3x12(:,115),heltab2x36(:,:,115))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(116),h0tab(:,116),[16,2,1,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(69),m3h3x12(:,116),heltab2x36(:,:,116))
  Gcoeff(:)%j = (c(52)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(117),h0tab(:,117),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(70),m3h3x12(:,117),heltab2x36(:,:,117))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(118),h0tab(:,118),[16,2,1,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(48),m3h3x12(:,118),heltab2x36(:,:,118))
  Gcoeff(:)%j = (-(c(133)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(119),h0tab(:,119),[16,4,2,1,8],[nML,nML,nML,nML,0],5,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(49),m3h3x12(:,119),heltab2x36(:,:,119))
  call Hloop_A_Q(ntryL,G0H12(49),16,nML,G1H12(71),n2h12(7))
  Gcoeff(:)%j = (-(c(143)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(120),h0tab(:,120),[16,4,2,1,8],[nMT,nMT,nMT,nMT,nMB],5,0)
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(49),m3h3x12(:,120),heltab2x36(:,:,120))
  call Hloop_Q_A(ntryL,G0H12(49),16,nMT,G1H12(72),n2h12(8))
  Gcoeff(:)%j = (-(c(119)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(121),h0tab(:,121),[16,4,2,1,8],[nMB,nMB,nMB,nMB,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(49),m3h3x12(:,121),heltab2x36(:,:,121))
  call Hloop_A_Q(ntryL,G0H12(49),16,nMB,G1H12(73),n2h12(9))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(122),h0tab(:,122),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(74),m3h3x12(:,122),heltab2x36(:,:,122))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(123),h0tab(:,123),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(75),m3h3x12(:,123),heltab2x36(:,:,123))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(124),h0tab(:,124),[16,4,2,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(76),m3h3x12(:,124),heltab2x36(:,:,124))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(125),h0tab(:,125),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(77),m3h3x12(:,125),heltab2x36(:,:,125))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(126),h0tab(:,126),[16,4,2,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(78),m3h3x12(:,126),heltab2x36(:,:,126))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(127),h0tab(:,127),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(79),m3h3x12(:,127),heltab2x36(:,:,127))
  Gcoeff(:)%j = (c(45)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(128),h0tab(:,128),[16,4,2,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(80),m3h3x12(:,128),heltab2x36(:,:,128))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(129),h0tab(:,129),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(81),m3h3x12(:,129),heltab2x36(:,:,129))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(130),h0tab(:,130),[16,4,2,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(49),m3h3x12(:,130),heltab2x36(:,:,130))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(131),h0tab(:,131),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(50),m3h3x12(:,131),heltab2x36(:,:,131))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(132),h0tab(:,132),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(51),m3h3x12(:,132),heltab2x36(:,:,132))
  Gcoeff(:)%j = (c(22)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(133),h0tab(:,133),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(82),m3h3x12(:,133),heltab2x36(:,:,133))
  Gcoeff(:)%j = (c(22)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(134),h0tab(:,134),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(83),m3h3x12(:,134),heltab2x36(:,:,134))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(135),h0tab(:,135),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(84),m3h3x12(:,135),heltab2x36(:,:,135))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(136),h0tab(:,136),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(85),m3h3x12(:,136),heltab2x36(:,:,136))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(137),h0tab(:,137),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(86),m3h3x12(:,137),heltab2x36(:,:,137))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(138),h0tab(:,138),[16,4,2,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(87),m3h3x12(:,138),heltab2x36(:,:,138))
  Gcoeff(:)%j = (c(49)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(139),h0tab(:,139),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(88),m3h3x12(:,139),heltab2x36(:,:,139))
  Gcoeff(:)%j = (c(56)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(140),h0tab(:,140),[16,4,2,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(52),m3h3x12(:,140),heltab2x36(:,:,140))
  Gcoeff(:)%j = (c(67)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(141),h0tab(:,141),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(53),m3h3x12(:,141),heltab2x36(:,:,141))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(142),h0tab(:,142),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(54),m3h3x12(:,142),heltab2x36(:,:,142))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(143),h0tab(:,143),[16,4,2,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(55),m3h3x12(:,143),heltab2x36(:,:,143))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(144),h0tab(:,144),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(56),m3h3x12(:,144),heltab2x36(:,:,144))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(145),h0tab(:,145),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(57),m3h3x12(:,145),heltab2x36(:,:,145))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(146),h0tab(:,146),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(89),m3h3x12(:,146),heltab2x36(:,:,146))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(147),h0tab(:,147),[16,4,2,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(58),m3h3x12(:,147),heltab2x36(:,:,147))
  Gcoeff(:)%j = (c(64)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(148),h0tab(:,148),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(59),m3h3x12(:,148),heltab2x36(:,:,148))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(149),h0tab(:,149),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(60),m3h3x12(:,149),heltab2x36(:,:,149))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(150),h0tab(:,150),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(90),m3h3x12(:,150),heltab2x36(:,:,150))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(151),h0tab(:,151),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(91),m3h3x12(:,151),heltab2x36(:,:,151))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(152),h0tab(:,152),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(92),m3h3x12(:,152),heltab2x36(:,:,152))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(153),h0tab(:,153),[16,4,2,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(93),m3h3x12(:,153),heltab2x36(:,:,153))
  Gcoeff(:)%j = (c(49)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(154),h0tab(:,154),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(94),m3h3x12(:,154),heltab2x36(:,:,154))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(155),h0tab(:,155),[16,4,2,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(95),m3h3x12(:,155),heltab2x36(:,:,155))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(156),h0tab(:,156),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(96),m3h3x12(:,156),heltab2x36(:,:,156))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(157),h0tab(:,157),[16,4,2,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(61),m3h3x12(:,157),heltab2x36(:,:,157))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(158),h0tab(:,158),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(62),m3h3x12(:,158),heltab2x36(:,:,158))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(159),h0tab(:,159),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(63),m3h3x12(:,159),heltab2x36(:,:,159))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(160),h0tab(:,160),[16,4,2,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(97),m3h3x12(:,160),heltab2x36(:,:,160))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(161),h0tab(:,161),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(98),m3h3x12(:,161),heltab2x36(:,:,161))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(162),h0tab(:,162),[16,4,2,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(64),m3h3x12(:,162),heltab2x36(:,:,162))
  Gcoeff(:)%j = (c(64)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(163),h0tab(:,163),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(65),m3h3x12(:,163),heltab2x36(:,:,163))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(164),h0tab(:,164),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(66),m3h3x12(:,164),heltab2x36(:,:,164))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(165),h0tab(:,165),[16,4,2,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(67),m3h3x12(:,165),heltab2x36(:,:,165))
  Gcoeff(:)%j = (c(52)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(166),h0tab(:,166),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(68),m3h3x12(:,166),heltab2x36(:,:,166))
  Gcoeff(:)%j = (c(41)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(167),h0tab(:,167),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(69),m3h3x12(:,167),heltab2x36(:,:,167))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(168),h0tab(:,168),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(99),m3h3x12(:,168),heltab2x36(:,:,168))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(169),h0tab(:,169),[16,4,2,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(100),m3h3x12(:,169),heltab2x36(:,:,169))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(170),h0tab(:,170),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(101),m3h3x12(:,170),heltab2x36(:,:,170))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(171),h0tab(:,171),[16,4,2,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(102),m3h3x12(:,171),heltab2x36(:,:,171))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(172),h0tab(:,172),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(103),m3h3x12(:,172),heltab2x36(:,:,172))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(173),h0tab(:,173),[16,4,2,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(104),m3h3x12(:,173),heltab2x36(:,:,173))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(174),h0tab(:,174),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(105),m3h3x12(:,174),heltab2x36(:,:,174))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(175),h0tab(:,175),[16,4,2,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(70),m3h3x12(:,175),heltab2x36(:,:,175))
  Gcoeff(:)%j = (c(52)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(176),h0tab(:,176),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(71),m3h3x12(:,176),heltab2x36(:,:,176))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(177),h0tab(:,177),[16,4,2,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(72),m3h3x12(:,177),heltab2x36(:,:,177))
  Gcoeff(:)%j = (c(141)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(178),h0tab(:,178),[16,2,1,8,4],[nMT,nMT,nMT,nMB,nMB],5,0)
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(73),m3h3x12(:,178),heltab2x36(:,:,178))
  call Hloop_Q_A(ntryL,G0H12(73),16,nMT,G1H12(106),n2h12(10))
  Gcoeff(:)%j = (c(120)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(179),h0tab(:,179),[16,2,1,8,4],[nMB,nMB,nMB,nMT,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(73),m3h3x12(:,179),heltab2x36(:,:,179))
  call Hloop_A_Q(ntryL,G0H12(73),16,nMB,G1H12(107),n2h12(11))
  Gcoeff(:)%j = (-(c(133)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(180),h0tab(:,180),[16,1,2,4,8],[nML,nML,nML,nML,0],5,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(73),m3h3x12(:,180),heltab2x36(:,:,180))
  call Hloop_A_Q(ntryL,G0H12(73),16,nML,G1H12(108),n2h12(12))
  Gcoeff(:)%j = (-(c(143)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(181),h0tab(:,181),[16,1,2,4,8],[nMT,nMT,nMT,nMT,nMB],5,0)
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(73),m3h3x12(:,181),heltab2x36(:,:,181))
  call Hloop_Q_A(ntryL,G0H12(73),16,nMT,G1H12(109),n2h12(13))
  Gcoeff(:)%j = (-(c(119)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(182),h0tab(:,182),[16,1,2,4,8],[nMB,nMB,nMB,nMB,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(73),m3h3x12(:,182),heltab2x36(:,:,182))
  call Hloop_A_Q(ntryL,G0H12(73),16,nMB,G1H12(110),n2h12(14))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(183),h0tab(:,183),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(111),m3h3x12(:,183),heltab2x36(:,:,183))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(184),h0tab(:,184),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(112),m3h3x12(:,184),heltab2x36(:,:,184))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(185),h0tab(:,185),[16,1,2,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(113),m3h3x12(:,185),heltab2x36(:,:,185))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(186),h0tab(:,186),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(114),m3h3x12(:,186),heltab2x36(:,:,186))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(187),h0tab(:,187),[16,1,2,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(115),m3h3x12(:,187),heltab2x36(:,:,187))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(188),h0tab(:,188),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(116),m3h3x12(:,188),heltab2x36(:,:,188))
  Gcoeff(:)%j = (c(45)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(189),h0tab(:,189),[16,1,2,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(117),m3h3x12(:,189),heltab2x36(:,:,189))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(190),h0tab(:,190),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(118),m3h3x12(:,190),heltab2x36(:,:,190))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(191),h0tab(:,191),[16,1,2,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(73),m3h3x12(:,191),heltab2x36(:,:,191))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(192),h0tab(:,192),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(74),m3h3x12(:,192),heltab2x36(:,:,192))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(193),h0tab(:,193),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(119),m3h3x12(:,193),heltab2x36(:,:,193))
  Gcoeff(:)%j = (c(22)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(194),h0tab(:,194),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(120),m3h3x12(:,194),heltab2x36(:,:,194))
  Gcoeff(:)%j = (c(22)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(195),h0tab(:,195),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(121),m3h3x12(:,195),heltab2x36(:,:,195))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(196),h0tab(:,196),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(75),m3h3x12(:,196),heltab2x36(:,:,196))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(197),h0tab(:,197),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(122),m3h3x12(:,197),heltab2x36(:,:,197))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(198),h0tab(:,198),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(123),m3h3x12(:,198),heltab2x36(:,:,198))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(199),h0tab(:,199),[16,1,2,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(76),m3h3x12(:,199),heltab2x36(:,:,199))
  Gcoeff(:)%j = (c(49)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(200),h0tab(:,200),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(77),m3h3x12(:,200),heltab2x36(:,:,200))
  Gcoeff(:)%j = (c(56)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(201),h0tab(:,201),[16,1,2,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(78),m3h3x12(:,201),heltab2x36(:,:,201))
  Gcoeff(:)%j = (c(67)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(202),h0tab(:,202),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(79),m3h3x12(:,202),heltab2x36(:,:,202))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(203),h0tab(:,203),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(124),m3h3x12(:,203),heltab2x36(:,:,203))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(204),h0tab(:,204),[16,1,2,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(125),m3h3x12(:,204),heltab2x36(:,:,204))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(205),h0tab(:,205),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(126),m3h3x12(:,205),heltab2x36(:,:,205))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(206),h0tab(:,206),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(80),m3h3x12(:,206),heltab2x36(:,:,206))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(207),h0tab(:,207),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(81),m3h3x12(:,207),heltab2x36(:,:,207))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(208),h0tab(:,208),[16,1,2,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(82),m3h3x12(:,208),heltab2x36(:,:,208))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(209),h0tab(:,209),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(83),m3h3x12(:,209),heltab2x36(:,:,209))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(210),h0tab(:,210),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(127),m3h3x12(:,210),heltab2x36(:,:,210))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(211),h0tab(:,211),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(128),m3h3x12(:,211),heltab2x36(:,:,211))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(212),h0tab(:,212),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(129),m3h3x12(:,212),heltab2x36(:,:,212))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(213),h0tab(:,213),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(84),m3h3x12(:,213),heltab2x36(:,:,213))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(214),h0tab(:,214),[16,1,2,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(85),m3h3x12(:,214),heltab2x36(:,:,214))
  Gcoeff(:)%j = (c(49)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(215),h0tab(:,215),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(86),m3h3x12(:,215),heltab2x36(:,:,215))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(216),h0tab(:,216),[16,1,2,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(130),m3h3x12(:,216),heltab2x36(:,:,216))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(217),h0tab(:,217),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(131),m3h3x12(:,217),heltab2x36(:,:,217))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(218),h0tab(:,218),[16,1,2,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(132),m3h3x12(:,218),heltab2x36(:,:,218))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(219),h0tab(:,219),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(133),m3h3x12(:,219),heltab2x36(:,:,219))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(220),h0tab(:,220),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(87),m3h3x12(:,220),heltab2x36(:,:,220))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(221),h0tab(:,221),[16,1,2,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(88),m3h3x12(:,221),heltab2x36(:,:,221))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(222),h0tab(:,222),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(89),m3h3x12(:,222),heltab2x36(:,:,222))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(223),h0tab(:,223),[16,1,2,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(90),m3h3x12(:,223),heltab2x36(:,:,223))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(224),h0tab(:,224),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(91),m3h3x12(:,224),heltab2x36(:,:,224))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(225),h0tab(:,225),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(134),m3h3x12(:,225),heltab2x36(:,:,225))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(226),h0tab(:,226),[16,1,2,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(135),m3h3x12(:,226),heltab2x36(:,:,226))
  Gcoeff(:)%j = (c(52)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(227),h0tab(:,227),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(136),m3h3x12(:,227),heltab2x36(:,:,227))
  Gcoeff(:)%j = (c(41)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(228),h0tab(:,228),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(92),m3h3x12(:,228),heltab2x36(:,:,228))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(229),h0tab(:,229),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(93),m3h3x12(:,229),heltab2x36(:,:,229))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(230),h0tab(:,230),[16,1,2,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(137),m3h3x12(:,230),heltab2x36(:,:,230))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(231),h0tab(:,231),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(138),m3h3x12(:,231),heltab2x36(:,:,231))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(232),h0tab(:,232),[16,1,2,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(94),m3h3x12(:,232),heltab2x36(:,:,232))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(233),h0tab(:,233),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(95),m3h3x12(:,233),heltab2x36(:,:,233))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(234),h0tab(:,234),[16,1,2,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(139),m3h3x12(:,234),heltab2x36(:,:,234))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(235),h0tab(:,235),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(140),m3h3x12(:,235),heltab2x36(:,:,235))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(236),h0tab(:,236),[16,1,2,4,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(141),m3h3x12(:,236),heltab2x36(:,:,236))
  Gcoeff(:)%j = (c(52)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(237),h0tab(:,237),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(142),m3h3x12(:,237),heltab2x36(:,:,237))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(238),h0tab(:,238),[16,1,2,4,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(96),m3h3x12(:,238),heltab2x36(:,:,238))
  Gcoeff(:)%j = (c(141)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(239),h0tab(:,239),[16,1,2,8,4],[nMT,nMT,nMT,nMB,nMB],5,0)
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(97),m3h3x12(:,239),heltab2x36(:,:,239))
  call Hloop_Q_A(ntryL,G0H12(97),16,nMT,G1H12(143),n2h12(15))
  Gcoeff(:)%j = (c(120)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(240),h0tab(:,240),[16,1,2,8,4],[nMB,nMB,nMB,nMT,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(97),m3h3x12(:,240),heltab2x36(:,:,240))
  call Hloop_A_Q(ntryL,G0H12(97),16,nMB,G1H12(144),n2h12(16))
  Gcoeff(:)%j = (-(c(133)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(241),h0tab(:,241),[16,2,4,1,8],[nML,nML,nML,nML,0],5,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(97),m3h3x12(:,241),heltab2x36(:,:,241))
  call Hloop_A_Q(ntryL,G0H12(97),16,nML,G1H12(145),n2h12(17))
  Gcoeff(:)%j = (-(c(143)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(242),h0tab(:,242),[16,2,4,1,8],[nMT,nMT,nMT,nMT,nMB],5,0)
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(97),m3h3x12(:,242),heltab2x36(:,:,242))
  call Hloop_Q_A(ntryL,G0H12(97),16,nMT,G1H12(146),n2h12(18))
  Gcoeff(:)%j = (-(c(119)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(243),h0tab(:,243),[16,2,4,1,8],[nMB,nMB,nMB,nMB,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(97),m3h3x12(:,243),heltab2x36(:,:,243))
  call Hloop_A_Q(ntryL,G0H12(97),16,nMB,G1H12(147),n2h12(19))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(244),h0tab(:,244),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(148),m3h3x12(:,244),heltab2x36(:,:,244))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(245),h0tab(:,245),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(149),m3h3x12(:,245),heltab2x36(:,:,245))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(246),h0tab(:,246),[16,2,4,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(150),m3h3x12(:,246),heltab2x36(:,:,246))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(247),h0tab(:,247),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(151),m3h3x12(:,247),heltab2x36(:,:,247))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(248),h0tab(:,248),[16,2,4,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(152),m3h3x12(:,248),heltab2x36(:,:,248))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(249),h0tab(:,249),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(153),m3h3x12(:,249),heltab2x36(:,:,249))
  Gcoeff(:)%j = (c(45)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(250),h0tab(:,250),[16,2,4,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(154),m3h3x12(:,250),heltab2x36(:,:,250))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(251),h0tab(:,251),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(155),m3h3x12(:,251),heltab2x36(:,:,251))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(252),h0tab(:,252),[16,2,4,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(97),m3h3x12(:,252),heltab2x36(:,:,252))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(253),h0tab(:,253),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(98),m3h3x12(:,253),heltab2x36(:,:,253))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(254),h0tab(:,254),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(99),m3h3x12(:,254),heltab2x36(:,:,254))
  Gcoeff(:)%j = (c(22)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(255),h0tab(:,255),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(156),m3h3x12(:,255),heltab2x36(:,:,255))
  Gcoeff(:)%j = (c(22)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(256),h0tab(:,256),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(157),m3h3x12(:,256),heltab2x36(:,:,256))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(257),h0tab(:,257),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(158),m3h3x12(:,257),heltab2x36(:,:,257))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(258),h0tab(:,258),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(159),m3h3x12(:,258),heltab2x36(:,:,258))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(259),h0tab(:,259),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(160),m3h3x12(:,259),heltab2x36(:,:,259))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(260),h0tab(:,260),[16,2,4,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(161),m3h3x12(:,260),heltab2x36(:,:,260))
  Gcoeff(:)%j = (c(49)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(261),h0tab(:,261),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(162),m3h3x12(:,261),heltab2x36(:,:,261))
  Gcoeff(:)%j = (c(56)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(262),h0tab(:,262),[16,2,4,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(100),m3h3x12(:,262),heltab2x36(:,:,262))
  Gcoeff(:)%j = (c(67)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(263),h0tab(:,263),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(101),m3h3x12(:,263),heltab2x36(:,:,263))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(264),h0tab(:,264),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(102),m3h3x12(:,264),heltab2x36(:,:,264))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(265),h0tab(:,265),[16,2,4,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(103),m3h3x12(:,265),heltab2x36(:,:,265))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(266),h0tab(:,266),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(104),m3h3x12(:,266),heltab2x36(:,:,266))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(267),h0tab(:,267),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(105),m3h3x12(:,267),heltab2x36(:,:,267))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(268),h0tab(:,268),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(163),m3h3x12(:,268),heltab2x36(:,:,268))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(269),h0tab(:,269),[16,2,4,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(106),m3h3x12(:,269),heltab2x36(:,:,269))
  Gcoeff(:)%j = (c(64)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(270),h0tab(:,270),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(107),m3h3x12(:,270),heltab2x36(:,:,270))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(271),h0tab(:,271),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(108),m3h3x12(:,271),heltab2x36(:,:,271))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(272),h0tab(:,272),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(164),m3h3x12(:,272),heltab2x36(:,:,272))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(273),h0tab(:,273),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(165),m3h3x12(:,273),heltab2x36(:,:,273))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(274),h0tab(:,274),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(166),m3h3x12(:,274),heltab2x36(:,:,274))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(275),h0tab(:,275),[16,2,4,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(167),m3h3x12(:,275),heltab2x36(:,:,275))
  Gcoeff(:)%j = (c(49)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(276),h0tab(:,276),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(168),m3h3x12(:,276),heltab2x36(:,:,276))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(277),h0tab(:,277),[16,2,4,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(169),m3h3x12(:,277),heltab2x36(:,:,277))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(278),h0tab(:,278),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(170),m3h3x12(:,278),heltab2x36(:,:,278))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(279),h0tab(:,279),[16,2,4,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(109),m3h3x12(:,279),heltab2x36(:,:,279))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(280),h0tab(:,280),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(110),m3h3x12(:,280),heltab2x36(:,:,280))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(281),h0tab(:,281),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(111),m3h3x12(:,281),heltab2x36(:,:,281))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(282),h0tab(:,282),[16,2,4,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(171),m3h3x12(:,282),heltab2x36(:,:,282))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(283),h0tab(:,283),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(172),m3h3x12(:,283),heltab2x36(:,:,283))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(284),h0tab(:,284),[16,2,4,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(112),m3h3x12(:,284),heltab2x36(:,:,284))
  Gcoeff(:)%j = (c(64)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(285),h0tab(:,285),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(113),m3h3x12(:,285),heltab2x36(:,:,285))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(286),h0tab(:,286),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(114),m3h3x12(:,286),heltab2x36(:,:,286))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(287),h0tab(:,287),[16,2,4,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(115),m3h3x12(:,287),heltab2x36(:,:,287))
  Gcoeff(:)%j = (c(52)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(288),h0tab(:,288),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(116),m3h3x12(:,288),heltab2x36(:,:,288))
  Gcoeff(:)%j = (c(41)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(289),h0tab(:,289),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(117),m3h3x12(:,289),heltab2x36(:,:,289))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(290),h0tab(:,290),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(173),m3h3x12(:,290),heltab2x36(:,:,290))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(291),h0tab(:,291),[16,2,4,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(174),m3h3x12(:,291),heltab2x36(:,:,291))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(292),h0tab(:,292),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(175),m3h3x12(:,292),heltab2x36(:,:,292))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(293),h0tab(:,293),[16,2,4,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(176),m3h3x12(:,293),heltab2x36(:,:,293))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(294),h0tab(:,294),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(177),m3h3x12(:,294),heltab2x36(:,:,294))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(295),h0tab(:,295),[16,2,4,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(178),m3h3x12(:,295),heltab2x36(:,:,295))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(296),h0tab(:,296),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(179),m3h3x12(:,296),heltab2x36(:,:,296))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(297),h0tab(:,297),[16,2,4,1,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(118),m3h3x12(:,297),heltab2x36(:,:,297))
  Gcoeff(:)%j = (c(52)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(298),h0tab(:,298),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(119),m3h3x12(:,298),heltab2x36(:,:,298))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(299),h0tab(:,299),[16,2,4,1,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(120),m3h3x12(:,299),heltab2x36(:,:,299))
  Gcoeff(:)%j = (c(141)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(300),h0tab(:,300),[16,2,8,1,4],[nMB,nMB,nMT,nMT,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(121),m3h3x12(:,300),heltab2x36(:,:,300))
  call Hloop_A_Q(ntryL,G0H12(121),16,nMB,G1H12(180),n2h12(20))
  Gcoeff(:)%j = (c(120)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(301),h0tab(:,301),[16,2,8,1,4],[nMT,nMT,nMB,nMB,nMB],5,0)
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(121),m3h3x12(:,301),heltab2x36(:,:,301))
  call Hloop_Q_A(ntryL,G0H12(121),16,nMT,G1H12(181),n2h12(21))
  Gcoeff(:)%j = (-(c(133)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(302),h0tab(:,302),[16,1,4,2,8],[nML,nML,nML,nML,0],5,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(121),m3h3x12(:,302),heltab2x36(:,:,302))
  call Hloop_A_Q(ntryL,G0H12(121),16,nML,G1H12(182),n2h12(22))
  Gcoeff(:)%j = (-(c(143)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(303),h0tab(:,303),[16,1,4,2,8],[nMT,nMT,nMT,nMT,nMB],5,0)
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(121),m3h3x12(:,303),heltab2x36(:,:,303))
  call Hloop_Q_A(ntryL,G0H12(121),16,nMT,G1H12(183),n2h12(23))
  Gcoeff(:)%j = (-(c(119)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(304),h0tab(:,304),[16,1,4,2,8],[nMB,nMB,nMB,nMB,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(121),m3h3x12(:,304),heltab2x36(:,:,304))
  call Hloop_A_Q(ntryL,G0H12(121),16,nMB,G1H12(184),n2h12(24))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(305),h0tab(:,305),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(185),m3h3x12(:,305),heltab2x36(:,:,305))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(306),h0tab(:,306),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(186),m3h3x12(:,306),heltab2x36(:,:,306))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(307),h0tab(:,307),[16,1,4,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(187),m3h3x12(:,307),heltab2x36(:,:,307))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(308),h0tab(:,308),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(188),m3h3x12(:,308),heltab2x36(:,:,308))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(309),h0tab(:,309),[16,1,4,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(189),m3h3x12(:,309),heltab2x36(:,:,309))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(310),h0tab(:,310),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(190),m3h3x12(:,310),heltab2x36(:,:,310))
  Gcoeff(:)%j = (c(45)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(311),h0tab(:,311),[16,1,4,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(191),m3h3x12(:,311),heltab2x36(:,:,311))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(312),h0tab(:,312),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(192),m3h3x12(:,312),heltab2x36(:,:,312))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(313),h0tab(:,313),[16,1,4,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(121),m3h3x12(:,313),heltab2x36(:,:,313))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(314),h0tab(:,314),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(122),m3h3x12(:,314),heltab2x36(:,:,314))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(315),h0tab(:,315),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(193),m3h3x12(:,315),heltab2x36(:,:,315))
  Gcoeff(:)%j = (c(22)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(316),h0tab(:,316),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(194),m3h3x12(:,316),heltab2x36(:,:,316))
  Gcoeff(:)%j = (c(22)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(317),h0tab(:,317),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(195),m3h3x12(:,317),heltab2x36(:,:,317))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(318),h0tab(:,318),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(123),m3h3x12(:,318),heltab2x36(:,:,318))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(319),h0tab(:,319),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(196),m3h3x12(:,319),heltab2x36(:,:,319))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(320),h0tab(:,320),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(197),m3h3x12(:,320),heltab2x36(:,:,320))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(321),h0tab(:,321),[16,1,4,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(124),m3h3x12(:,321),heltab2x36(:,:,321))
  Gcoeff(:)%j = (c(49)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(322),h0tab(:,322),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(125),m3h3x12(:,322),heltab2x36(:,:,322))
  Gcoeff(:)%j = (c(56)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(323),h0tab(:,323),[16,1,4,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(126),m3h3x12(:,323),heltab2x36(:,:,323))
  Gcoeff(:)%j = (c(67)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(324),h0tab(:,324),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(127),m3h3x12(:,324),heltab2x36(:,:,324))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(325),h0tab(:,325),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(198),m3h3x12(:,325),heltab2x36(:,:,325))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(326),h0tab(:,326),[16,1,4,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(199),m3h3x12(:,326),heltab2x36(:,:,326))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(327),h0tab(:,327),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(200),m3h3x12(:,327),heltab2x36(:,:,327))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(328),h0tab(:,328),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(128),m3h3x12(:,328),heltab2x36(:,:,328))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(329),h0tab(:,329),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(129),m3h3x12(:,329),heltab2x36(:,:,329))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(330),h0tab(:,330),[16,1,4,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(130),m3h3x12(:,330),heltab2x36(:,:,330))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(331),h0tab(:,331),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(131),m3h3x12(:,331),heltab2x36(:,:,331))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(332),h0tab(:,332),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(201),m3h3x12(:,332),heltab2x36(:,:,332))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(333),h0tab(:,333),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(202),m3h3x12(:,333),heltab2x36(:,:,333))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(334),h0tab(:,334),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(203),m3h3x12(:,334),heltab2x36(:,:,334))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(335),h0tab(:,335),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(132),m3h3x12(:,335),heltab2x36(:,:,335))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(336),h0tab(:,336),[16,1,4,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(133),m3h3x12(:,336),heltab2x36(:,:,336))
  Gcoeff(:)%j = (c(49)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(337),h0tab(:,337),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(134),m3h3x12(:,337),heltab2x36(:,:,337))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(338),h0tab(:,338),[16,1,4,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(204),m3h3x12(:,338),heltab2x36(:,:,338))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(339),h0tab(:,339),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(205),m3h3x12(:,339),heltab2x36(:,:,339))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(340),h0tab(:,340),[16,1,4,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(206),m3h3x12(:,340),heltab2x36(:,:,340))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(341),h0tab(:,341),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(207),m3h3x12(:,341),heltab2x36(:,:,341))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(342),h0tab(:,342),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(135),m3h3x12(:,342),heltab2x36(:,:,342))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(343),h0tab(:,343),[16,1,4,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(136),m3h3x12(:,343),heltab2x36(:,:,343))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(344),h0tab(:,344),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(137),m3h3x12(:,344),heltab2x36(:,:,344))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(345),h0tab(:,345),[16,1,4,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(138),m3h3x12(:,345),heltab2x36(:,:,345))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(346),h0tab(:,346),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(139),m3h3x12(:,346),heltab2x36(:,:,346))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(347),h0tab(:,347),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(208),m3h3x12(:,347),heltab2x36(:,:,347))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(348),h0tab(:,348),[16,1,4,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(209),m3h3x12(:,348),heltab2x36(:,:,348))
  Gcoeff(:)%j = (c(52)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(349),h0tab(:,349),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(210),m3h3x12(:,349),heltab2x36(:,:,349))
  Gcoeff(:)%j = (c(41)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(350),h0tab(:,350),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(140),m3h3x12(:,350),heltab2x36(:,:,350))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(351),h0tab(:,351),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(141),m3h3x12(:,351),heltab2x36(:,:,351))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(352),h0tab(:,352),[16,1,4,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(211),m3h3x12(:,352),heltab2x36(:,:,352))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(353),h0tab(:,353),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(212),m3h3x12(:,353),heltab2x36(:,:,353))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(354),h0tab(:,354),[16,1,4,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(142),m3h3x12(:,354),heltab2x36(:,:,354))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(355),h0tab(:,355),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(143),m3h3x12(:,355),heltab2x36(:,:,355))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(356),h0tab(:,356),[16,1,4,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(213),m3h3x12(:,356),heltab2x36(:,:,356))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(357),h0tab(:,357),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(214),m3h3x12(:,357),heltab2x36(:,:,357))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(358),h0tab(:,358),[16,1,4,2,8],[nMW,nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(215),m3h3x12(:,358),heltab2x36(:,:,358))
  Gcoeff(:)%j = (c(52)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(359),h0tab(:,359),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(216),m3h3x12(:,359),heltab2x36(:,:,359))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(360),h0tab(:,360),[16,1,4,2,8],[nMW,nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(144),m3h3x12(:,360),heltab2x36(:,:,360))
  Gcoeff(:)%j = (c(141)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(361),h0tab(:,361),[16,1,4,8,2],[nMT,nMT,nMT,nMB,nMB],5,0)
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(145),m3h3x12(:,361),heltab2x36(:,:,361))
  call Hloop_Q_A(ntryL,G0H12(145),16,nMT,G1H12(217),n2h12(25))
  Gcoeff(:)%j = (c(120)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(362),h0tab(:,362),[16,1,4,8,2],[nMB,nMB,nMB,nMT,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(145),m3h3x12(:,362),heltab2x36(:,:,362))
  call Hloop_A_Q(ntryL,G0H12(145),16,nMB,G1H12(218),n2h12(26))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(363),h0tab(:,363),[16,1,8,2,4],[nMB,nMB,nMT,nMT,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(145),m3h3x12(:,363),heltab2x36(:,:,363))
  call Hloop_A_Q(ntryL,G0H12(145),16,nMB,G1H12(219),n2h12(27))
  Gcoeff(:)%j = (-(c(140)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(364),h0tab(:,364),[16,1,8,2,4],[nMT,nMT,nMB,nMB,nMB],5,0)
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(145),m3h3x12(:,364),heltab2x36(:,:,364))
  call Hloop_Q_A(ntryL,G0H12(145),16,nMT,G1H12(220),n2h12(28))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(365),h0tab(:,365),[16,1,8,2,4],[nMH,nMH,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(221),m3h3x12(:,365),heltab2x36(:,:,365))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(366),h0tab(:,366),[16,1,8,2,4],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(222),m3h3x12(:,366),heltab2x36(:,:,366))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(367),h0tab(:,367),[16,1,8,2,4],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(223),m3h3x12(:,367),heltab2x36(:,:,367))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(368),h0tab(:,368),[16,1,8,2,4],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(224),m3h3x12(:,368),heltab2x36(:,:,368))
  Gcoeff(:)%j = (c(19)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(369),h0tab(:,369),[16,1,8,2,4],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(225),m3h3x12(:,369),heltab2x36(:,:,369))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(370),h0tab(:,370),[16,1,8,2,4],[nMH,nMH,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(145),m3h3x12(:,370),heltab2x36(:,:,370))
  Gcoeff(:)%j = (c(28)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(371),h0tab(:,371),[16,1,8,2,4],[nMH,nMH,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(226),m3h3x12(:,371),heltab2x36(:,:,371))
  Gcoeff(:)%j = (c(27)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(372),h0tab(:,372),[16,1,8,2,4],[nMH,nMH,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(227),m3h3x12(:,372),heltab2x36(:,:,372))
  Gcoeff(:)%j = (c(22)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(373),h0tab(:,373),[16,1,8,2,4],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(228),m3h3x12(:,373),heltab2x36(:,:,373))
  Gcoeff(:)%j = (c(47)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(374),h0tab(:,374),[16,1,8,2,4],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(146),m3h3x12(:,374),heltab2x36(:,:,374))
  Gcoeff(:)%j = (c(47)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(375),h0tab(:,375),[16,1,8,2,4],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(229),m3h3x12(:,375),heltab2x36(:,:,375))
  Gcoeff(:)%j = (c(40)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(376),h0tab(:,376),[16,1,8,2,4],[nMH,nMH,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(147),m3h3x12(:,376),heltab2x36(:,:,376))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(377),h0tab(:,377),[16,1,8,2,4],[nMH,nMH,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(148),m3h3x12(:,377),heltab2x36(:,:,377))
  Gcoeff(:)%j = (c(28)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(378),h0tab(:,378),[16,1,8,2,4],[nMH,nMH,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(230),m3h3x12(:,378),heltab2x36(:,:,378))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(379),h0tab(:,379),[16,1,8,2,4],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(231),m3h3x12(:,379),heltab2x36(:,:,379))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(380),h0tab(:,380),[16,1,8,2,4],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(149),m3h3x12(:,380),heltab2x36(:,:,380))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(381),h0tab(:,381),[16,1,8,2,4],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(232),m3h3x12(:,381),heltab2x36(:,:,381))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(382),h0tab(:,382),[16,1,8,2,4],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(233),m3h3x12(:,382),heltab2x36(:,:,382))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(383),h0tab(:,383),[16,1,8,2,4],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(150),m3h3x12(:,383),heltab2x36(:,:,383))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(384),h0tab(:,384),[16,1,8,2,4],[nMH,nMH,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(151),m3h3x12(:,384),heltab2x36(:,:,384))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(385),h0tab(:,385),[16,1,8,2,4],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(234),m3h3x12(:,385),heltab2x36(:,:,385))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(386),h0tab(:,386),[16,1,8,2,4],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(235),m3h3x12(:,386),heltab2x36(:,:,386))
  Gcoeff(:)%j = (c(55)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(387),h0tab(:,387),[16,1,8,2,4],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(236),m3h3x12(:,387),heltab2x36(:,:,387))
  Gcoeff(:)%j = (c(55)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(388),h0tab(:,388),[16,1,8,2,4],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(152),m3h3x12(:,388),heltab2x36(:,:,388))
  Gcoeff(:)%j = (c(68)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(389),h0tab(:,389),[16,1,8,2,4],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(153),m3h3x12(:,389),heltab2x36(:,:,389))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(390),h0tab(:,390),[16,1,8,2,4],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(237),m3h3x12(:,390),heltab2x36(:,:,390))
  Gcoeff(:)%j = (c(55)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(391),h0tab(:,391),[16,1,8,2,4],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(238),m3h3x12(:,391),heltab2x36(:,:,391))
  Gcoeff(:)%j = (c(55)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(392),h0tab(:,392),[16,1,8,2,4],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(154),m3h3x12(:,392),heltab2x36(:,:,392))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(393),h0tab(:,393),[16,1,8,4,2],[nMB,nMB,nMT,nMT,nMT],5,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(155),m3h3x12(:,393),heltab2x36(:,:,393))
  call Hloop_A_Q(ntryL,G0H12(155),16,nMB,G1H12(239),n2h12(29))
  Gcoeff(:)%j = (-(c(140)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(394),h0tab(:,394),[16,1,8,4,2],[nMT,nMT,nMB,nMB,nMB],5,0)
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(155),m3h3x12(:,394),heltab2x36(:,:,394))
  call Hloop_Q_A(ntryL,G0H12(155),16,nMT,G1H12(240),n2h12(30))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(395),h0tab(:,395),[16,1,8,4,2],[nMH,nMH,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(241),m3h3x12(:,395),heltab2x36(:,:,395))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(396),h0tab(:,396),[16,1,8,4,2],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(242),m3h3x12(:,396),heltab2x36(:,:,396))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(397),h0tab(:,397),[16,1,8,4,2],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(243),m3h3x12(:,397),heltab2x36(:,:,397))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(398),h0tab(:,398),[16,1,8,4,2],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(244),m3h3x12(:,398),heltab2x36(:,:,398))
  Gcoeff(:)%j = (c(19)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(399),h0tab(:,399),[16,1,8,4,2],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(245),m3h3x12(:,399),heltab2x36(:,:,399))
  Gcoeff(:)%j = (c(28)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(400),h0tab(:,400),[16,1,8,4,2],[nMH,nMH,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(246),m3h3x12(:,400),heltab2x36(:,:,400))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(401),h0tab(:,401),[16,1,8,4,2],[nMH,nMH,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(155),m3h3x12(:,401),heltab2x36(:,:,401))
  Gcoeff(:)%j = (c(27)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(402),h0tab(:,402),[16,1,8,4,2],[nMH,nMH,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(247),m3h3x12(:,402),heltab2x36(:,:,402))
  Gcoeff(:)%j = (c(22)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(403),h0tab(:,403),[16,1,8,4,2],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(248),m3h3x12(:,403),heltab2x36(:,:,403))
  Gcoeff(:)%j = (c(47)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(404),h0tab(:,404),[16,1,8,4,2],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(156),m3h3x12(:,404),heltab2x36(:,:,404))
  Gcoeff(:)%j = (c(47)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(405),h0tab(:,405),[16,1,8,4,2],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(249),m3h3x12(:,405),heltab2x36(:,:,405))
  Gcoeff(:)%j = (c(40)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(406),h0tab(:,406),[16,1,8,4,2],[nMH,nMH,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(157),m3h3x12(:,406),heltab2x36(:,:,406))
  Gcoeff(:)%j = (c(28)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(407),h0tab(:,407),[16,1,8,4,2],[nMH,nMH,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(250),m3h3x12(:,407),heltab2x36(:,:,407))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(408),h0tab(:,408),[16,1,8,4,2],[nMH,nMH,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(158),m3h3x12(:,408),heltab2x36(:,:,408))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(409),h0tab(:,409),[16,1,8,4,2],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(251),m3h3x12(:,409),heltab2x36(:,:,409))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(410),h0tab(:,410),[16,1,8,4,2],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(159),m3h3x12(:,410),heltab2x36(:,:,410))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(411),h0tab(:,411),[16,1,8,4,2],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(252),m3h3x12(:,411),heltab2x36(:,:,411))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(412),h0tab(:,412),[16,1,8,4,2],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(253),m3h3x12(:,412),heltab2x36(:,:,412))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(413),h0tab(:,413),[16,1,8,4,2],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(160),m3h3x12(:,413),heltab2x36(:,:,413))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(414),h0tab(:,414),[16,1,8,4,2],[nMH,nMH,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(161),m3h3x12(:,414),heltab2x36(:,:,414))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(415),h0tab(:,415),[16,1,8,4,2],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(254),m3h3x12(:,415),heltab2x36(:,:,415))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(416),h0tab(:,416),[16,1,8,4,2],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(255),m3h3x12(:,416),heltab2x36(:,:,416))
  Gcoeff(:)%j = (c(55)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(417),h0tab(:,417),[16,1,8,4,2],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(162),m3h3x12(:,417),heltab2x36(:,:,417))
  Gcoeff(:)%j = (c(55)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(418),h0tab(:,418),[16,1,8,4,2],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(256),m3h3x12(:,418),heltab2x36(:,:,418))
  Gcoeff(:)%j = (c(68)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(419),h0tab(:,419),[16,1,8,4,2],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(163),m3h3x12(:,419),heltab2x36(:,:,419))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(420),h0tab(:,420),[16,1,8,4,2],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(257),m3h3x12(:,420),heltab2x36(:,:,420))
  Gcoeff(:)%j = (c(55)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(421),h0tab(:,421),[16,1,8,4,2],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(164),m3h3x12(:,421),heltab2x36(:,:,421))
  Gcoeff(:)%j = (c(55)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(422),h0tab(:,422),[16,1,8,4,2],[nMZ,nMZ,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(258),m3h3x12(:,422),heltab2x36(:,:,422))
  call Hloop_AV_Q(ntryL,G1H12(1),ex3(:),G1H6(1),m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_A_Q(ntryL,G1H6(1),20,nML,G2H6(1),n2h6(1))
  call Hloop_QV_A(ntryL,G1H12(2),ex3(:),G1H6(1),m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_Q_A(ntryL,G1H6(1),20,nMT,G2H6(2),n2h6(2))
  call Hloop_AV_Q(ntryL,G1H12(3),ex3(:),G1H6(1),m3h2x6(:,3),heltab2x12(:,:,3))
  call Hloop_A_Q(ntryL,G1H6(1),20,nMB,G2H6(3),n2h6(3))
  call Hloop_SV_T(ntryL,G1H12(4),16,ex3(:),4,G2H6(4),m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_SV_T(ntryL,G1H12(5),16,ex3(:),4,G2H6(5),m3h2x6(:,5),heltab2x12(:,:,5))
  call Hloop_DV_C(ntryL,G1H12(6),16,ex3(:),G2H6(6),m3h2x6(:,6),heltab2x12(:,:,6))
  call Hloop_DV_C(ntryL,G1H12(7),16,ex3(:),G2H6(7),m3h2x6(:,7),heltab2x12(:,:,7))
  call Hloop_CV_D(ntryL,G1H12(8),16,ex3(:),4,G2H6(8),m3h2x6(:,8),heltab2x12(:,:,8))
  call Hloop_CV_D(ntryL,G1H12(9),16,ex3(:),4,G2H6(9),m3h2x6(:,9),heltab2x12(:,:,9))
  call Hloop_UW_V(ntryL,G1H12(10),16,ex3(:),4,G2H6(10),m3h2x6(:,10),heltab2x12(:,:,10))
  call Hloop_UW_V(ntryL,G1H12(11),16,ex3(:),4,G2H6(11),m3h2x6(:,11),heltab2x12(:,:,11))
  call Hloop_SV_T(ntryL,G0H12(1),16,ex3(:),4,G1H6(1),m3h2x6(:,12),heltab2x12(:,:,12))
  call Hloop_SV_T(ntryL,G0H12(2),16,ex3(:),4,G1H6(2),m3h2x6(:,13),heltab2x12(:,:,13))
  call Hloop_VV_S(ntryL,G0H12(3),ex3(:),G0H6(1),m3h2x6(:,14),heltab2x12(:,:,14))
  call Hloop_SV_T(ntryL,G1H12(12),16,ex3(:),4,G2H6(12),m3h2x6(:,15),heltab2x12(:,:,15))
  call Hloop_SV_V(ntryL,G1H12(13),ex3(:),G1H6(3),m3h2x6(:,16),heltab2x12(:,:,16))
  call Hloop_SV_V(ntryL,G1H12(14),ex3(:),G1H6(4),m3h2x6(:,17),heltab2x12(:,:,17))
  call Hloop_SV_T(ntryL,G1H12(15),16,ex3(:),4,G2H6(13),m3h2x6(:,18),heltab2x12(:,:,18))
  call Hloop_SV_T(ntryL,G1H12(16),16,ex3(:),4,G2H6(14),m3h2x6(:,19),heltab2x12(:,:,19))
  call Hloop_VV_S(ntryL,G1H12(17),ex3(:),G1H6(5),m3h2x6(:,20),heltab2x12(:,:,20))
  call Hloop_VV_S(ntryL,G1H12(18),ex3(:),G1H6(6),m3h2x6(:,21),heltab2x12(:,:,21))
  call Hloop_SV_T(ntryL,G0H12(4),16,ex3(:),4,G1H6(7),m3h2x6(:,22),heltab2x12(:,:,22))
  call Hloop_SV_T(ntryL,G0H12(5),16,ex3(:),4,G1H6(8),m3h2x6(:,23),heltab2x12(:,:,23))
  call Hloop_VV_S(ntryL,G0H12(6),ex3(:),G0H6(2),m3h2x6(:,24),heltab2x12(:,:,24))
  call Hloop_SV_V(ntryL,G0H12(7),ex3(:),G0H6(3),m3h2x6(:,25),heltab2x12(:,:,25))
  call Hloop_SV_V(ntryL,G0H12(8),ex3(:),G0H6(4),m3h2x6(:,26),heltab2x12(:,:,26))
  call Hloop_UW_V(ntryL,G0H12(9),16,ex3(:),4,G1H6(9),m3h2x6(:,27),heltab2x12(:,:,27))
  call Hloop_SV_V(ntryL,G1H12(19),ex3(:),G1H6(10),m3h2x6(:,28),heltab2x12(:,:,28))
  call Hloop_SV_T(ntryL,G0H12(10),16,ex3(:),4,G1H6(11),m3h2x6(:,29),heltab2x12(:,:,29))
  call Hloop_SV_T(ntryL,G0H12(11),16,ex3(:),4,G1H6(12),m3h2x6(:,30),heltab2x12(:,:,30))
  call Hloop_VV_S(ntryL,G0H12(12),ex3(:),G0H6(5),m3h2x6(:,31),heltab2x12(:,:,31))
  call Hloop_SV_T(ntryL,G1H12(20),16,ex3(:),4,G2H6(15),m3h2x6(:,32),heltab2x12(:,:,32))
  call Hloop_SV_V(ntryL,G1H12(21),ex3(:),G1H6(13),m3h2x6(:,33),heltab2x12(:,:,33))
  call Hloop_SV_V(ntryL,G1H12(22),ex3(:),G1H6(14),m3h2x6(:,34),heltab2x12(:,:,34))
  call Hloop_VV_S(ntryL,G1H12(23),ex3(:),G1H6(15),m3h2x6(:,35),heltab2x12(:,:,35))
  call Hloop_VV_S(ntryL,G1H12(24),ex3(:),G1H6(16),m3h2x6(:,36),heltab2x12(:,:,36))
  call Hloop_UW_V(ntryL,G1H12(25),16,ex3(:),4,G2H6(16),m3h2x6(:,37),heltab2x12(:,:,37))
  call Hloop_UW_V(ntryL,G1H12(26),16,ex3(:),4,G2H6(17),m3h2x6(:,38),heltab2x12(:,:,38))
  call Hloop_SV_V(ntryL,G0H12(13),ex3(:),G0H6(6),m3h2x6(:,39),heltab2x12(:,:,39))
  call Hloop_SV_V(ntryL,G0H12(14),ex3(:),G0H6(7),m3h2x6(:,40),heltab2x12(:,:,40))
  call Hloop_UW_V(ntryL,G0H12(15),16,ex3(:),4,G1H6(17),m3h2x6(:,41),heltab2x12(:,:,41))
  call Hloop_VV_S(ntryL,G1H12(27),ex3(:),G1H6(18),m3h2x6(:,42),heltab2x12(:,:,42))
  call Hloop_VV_S(ntryL,G1H12(28),ex3(:),G1H6(19),m3h2x6(:,43),heltab2x12(:,:,43))
  call Hloop_SV_T(ntryL,G0H12(16),16,ex3(:),4,G1H6(20),m3h2x6(:,44),heltab2x12(:,:,44))
  call Hloop_SV_T(ntryL,G0H12(17),16,ex3(:),4,G1H6(21),m3h2x6(:,45),heltab2x12(:,:,45))
  call Hloop_VV_S(ntryL,G0H12(18),ex3(:),G0H6(8),m3h2x6(:,46),heltab2x12(:,:,46))
  call Hloop_SV_V(ntryL,G0H12(19),ex3(:),G0H6(9),m3h2x6(:,47),heltab2x12(:,:,47))
  call Hloop_SV_V(ntryL,G0H12(20),ex3(:),G0H6(10),m3h2x6(:,48),heltab2x12(:,:,48))
  call Hloop_UW_V(ntryL,G0H12(21),16,ex3(:),4,G1H6(22),m3h2x6(:,49),heltab2x12(:,:,49))
  call Hloop_SV_V(ntryL,G1H12(29),ex3(:),G1H6(23),m3h2x6(:,50),heltab2x12(:,:,50))
  call Hloop_UW_V(ntryL,G1H12(30),16,ex3(:),4,G2H6(18),m3h2x6(:,51),heltab2x12(:,:,51))
  call Hloop_UW_V(ntryL,G1H12(31),16,ex3(:),4,G2H6(19),m3h2x6(:,52),heltab2x12(:,:,52))
  call Hloop_VV_S(ntryL,G1H12(32),ex3(:),G1H6(24),m3h2x6(:,53),heltab2x12(:,:,53))
  call Hloop_VV_S(ntryL,G1H12(33),ex3(:),G1H6(25),m3h2x6(:,54),heltab2x12(:,:,54))
  call Hloop_UW_V(ntryL,G1H12(34),16,ex3(:),4,G2H6(20),m3h2x6(:,55),heltab2x12(:,:,55))
  call Hloop_UW_V(ntryL,G1H12(35),16,ex3(:),4,G2H6(21),m3h2x6(:,56),heltab2x12(:,:,56))
  call Hloop_SV_V(ntryL,G0H12(22),ex3(:),G0H6(11),m3h2x6(:,57),heltab2x12(:,:,57))
  call Hloop_SV_V(ntryL,G0H12(23),ex3(:),G0H6(12),m3h2x6(:,58),heltab2x12(:,:,58))
  call Hloop_UW_V(ntryL,G0H12(24),16,ex3(:),4,G1H6(26),m3h2x6(:,59),heltab2x12(:,:,59))
  call Hloop_AV_Q(ntryL,G1H12(36),ex2(:),G1H6(27),m3h2x6(:,60),heltab2x12(:,:,60))
  call Hloop_A_Q(ntryL,G1H6(27),18,nML,G2H6(22),n2h6(4))
  call Hloop_QV_A(ntryL,G1H12(37),ex2(:),G1H6(27),m3h2x6(:,61),heltab2x12(:,:,61))
  call Hloop_Q_A(ntryL,G1H6(27),18,nMT,G2H6(23),n2h6(5))
  call Hloop_AV_Q(ntryL,G1H12(38),ex2(:),G1H6(27),m3h2x6(:,62),heltab2x12(:,:,62))
  call Hloop_A_Q(ntryL,G1H6(27),18,nMB,G2H6(24),n2h6(6))
  call Hloop_SV_T(ntryL,G1H12(39),16,ex2(:),2,G2H6(25),m3h2x6(:,63),heltab2x12(:,:,63))
  call Hloop_SV_T(ntryL,G1H12(40),16,ex2(:),2,G2H6(26),m3h2x6(:,64),heltab2x12(:,:,64))
  call Hloop_DV_C(ntryL,G1H12(41),16,ex2(:),G2H6(27),m3h2x6(:,65),heltab2x12(:,:,65))
  call Hloop_DV_C(ntryL,G1H12(42),16,ex2(:),G2H6(28),m3h2x6(:,66),heltab2x12(:,:,66))
  call Hloop_CV_D(ntryL,G1H12(43),16,ex2(:),2,G2H6(29),m3h2x6(:,67),heltab2x12(:,:,67))
  call Hloop_CV_D(ntryL,G1H12(44),16,ex2(:),2,G2H6(30),m3h2x6(:,68),heltab2x12(:,:,68))
  call Hloop_UW_V(ntryL,G1H12(45),16,ex2(:),2,G2H6(31),m3h2x6(:,69),heltab2x12(:,:,69))
  call Hloop_UW_V(ntryL,G1H12(46),16,ex2(:),2,G2H6(32),m3h2x6(:,70),heltab2x12(:,:,70))
  call Hloop_SV_T(ntryL,G0H12(25),16,ex2(:),2,G1H6(27),m3h2x6(:,71),heltab2x12(:,:,71))
  call Hloop_SV_T(ntryL,G0H12(26),16,ex2(:),2,G1H6(28),m3h2x6(:,72),heltab2x12(:,:,72))
  call Hloop_SV_T(ntryL,G1H12(47),16,ex2(:),2,G2H6(33),m3h2x6(:,73),heltab2x12(:,:,73))
  call Hloop_VV_S(ntryL,G0H12(27),ex2(:),G0H6(13),m3h2x6(:,74),heltab2x12(:,:,74))
  call Hloop_SV_T(ntryL,G1H12(48),16,ex2(:),2,G2H6(34),m3h2x6(:,75),heltab2x12(:,:,75))
  call Hloop_SV_T(ntryL,G1H12(49),16,ex2(:),2,G2H6(35),m3h2x6(:,76),heltab2x12(:,:,76))
  call Hloop_SV_V(ntryL,G1H12(50),ex2(:),G1H6(29),m3h2x6(:,77),heltab2x12(:,:,77))
  call Hloop_SV_V(ntryL,G1H12(51),ex2(:),G1H6(30),m3h2x6(:,78),heltab2x12(:,:,78))
  call Hloop_SV_T(ntryL,G0H12(28),16,ex2(:),2,G1H6(31),m3h2x6(:,79),heltab2x12(:,:,79))
  call Hloop_SV_T(ntryL,G0H12(29),16,ex2(:),2,G1H6(32),m3h2x6(:,80),heltab2x12(:,:,80))
  call Hloop_VV_S(ntryL,G1H12(52),ex2(:),G1H6(33),m3h2x6(:,81),heltab2x12(:,:,81))
  call Hloop_VV_S(ntryL,G1H12(53),ex2(:),G1H6(34),m3h2x6(:,82),heltab2x12(:,:,82))
  call Hloop_VV_S(ntryL,G0H12(30),ex2(:),G0H6(14),m3h2x6(:,83),heltab2x12(:,:,83))
  call Hloop_SV_T(ntryL,G0H12(31),16,ex2(:),2,G1H6(35),m3h2x6(:,84),heltab2x12(:,:,84))
  call Hloop_SV_T(ntryL,G0H12(32),16,ex2(:),2,G1H6(36),m3h2x6(:,85),heltab2x12(:,:,85))
  call Hloop_SV_T(ntryL,G1H12(54),16,ex2(:),2,G2H6(36),m3h2x6(:,86),heltab2x12(:,:,86))
  call Hloop_VV_S(ntryL,G0H12(33),ex2(:),G0H6(15),m3h2x6(:,87),heltab2x12(:,:,87))
  call Hloop_SV_V(ntryL,G0H12(34),ex2(:),G0H6(16),m3h2x6(:,88),heltab2x12(:,:,88))
  call Hloop_SV_V(ntryL,G0H12(35),ex2(:),G0H6(17),m3h2x6(:,89),heltab2x12(:,:,89))
  call Hloop_SV_V(ntryL,G1H12(55),ex2(:),G1H6(37),m3h2x6(:,90),heltab2x12(:,:,90))
  call Hloop_UW_V(ntryL,G0H12(36),16,ex2(:),2,G1H6(38),m3h2x6(:,91),heltab2x12(:,:,91))
  call Hloop_SV_V(ntryL,G1H12(56),ex2(:),G1H6(39),m3h2x6(:,92),heltab2x12(:,:,92))
  call Hloop_SV_V(ntryL,G1H12(57),ex2(:),G1H6(40),m3h2x6(:,93),heltab2x12(:,:,93))
  call Hloop_VV_S(ntryL,G1H12(58),ex2(:),G1H6(41),m3h2x6(:,94),heltab2x12(:,:,94))
  call Hloop_VV_S(ntryL,G1H12(59),ex2(:),G1H6(42),m3h2x6(:,95),heltab2x12(:,:,95))
  call Hloop_SV_T(ntryL,G0H12(37),16,ex2(:),2,G1H6(43),m3h2x6(:,96),heltab2x12(:,:,96))
  call Hloop_SV_T(ntryL,G0H12(38),16,ex2(:),2,G1H6(44),m3h2x6(:,97),heltab2x12(:,:,97))
  call Hloop_VV_S(ntryL,G1H12(60),ex2(:),G1H6(45),m3h2x6(:,98),heltab2x12(:,:,98))
  call Hloop_VV_S(ntryL,G1H12(61),ex2(:),G1H6(46),m3h2x6(:,99),heltab2x12(:,:,99))
  call Hloop_VV_S(ntryL,G0H12(39),ex2(:),G0H6(18),m3h2x6(:,100),heltab2x12(:,:,100))
  call Hloop_SV_V(ntryL,G0H12(40),ex2(:),G0H6(19),m3h2x6(:,101),heltab2x12(:,:,101))
  call Hloop_SV_V(ntryL,G0H12(41),ex2(:),G0H6(20),m3h2x6(:,102),heltab2x12(:,:,102))
  call Hloop_UW_V(ntryL,G1H12(62),16,ex2(:),2,G2H6(37),m3h2x6(:,103),heltab2x12(:,:,103))
  call Hloop_UW_V(ntryL,G1H12(63),16,ex2(:),2,G2H6(38),m3h2x6(:,104),heltab2x12(:,:,104))
  call Hloop_UW_V(ntryL,G0H12(42),16,ex2(:),2,G1H6(47),m3h2x6(:,105),heltab2x12(:,:,105))
  call Hloop_SV_V(ntryL,G0H12(43),ex2(:),G0H6(21),m3h2x6(:,106),heltab2x12(:,:,106))
  call Hloop_SV_V(ntryL,G0H12(44),ex2(:),G0H6(22),m3h2x6(:,107),heltab2x12(:,:,107))
  call Hloop_SV_V(ntryL,G1H12(64),ex2(:),G1H6(48),m3h2x6(:,108),heltab2x12(:,:,108))
  call Hloop_UW_V(ntryL,G0H12(45),16,ex2(:),2,G1H6(49),m3h2x6(:,109),heltab2x12(:,:,109))
  call Hloop_VV_S(ntryL,G1H12(65),ex2(:),G1H6(50),m3h2x6(:,110),heltab2x12(:,:,110))
  call Hloop_VV_S(ntryL,G1H12(66),ex2(:),G1H6(51),m3h2x6(:,111),heltab2x12(:,:,111))
  call Hloop_UW_V(ntryL,G1H12(67),16,ex2(:),2,G2H6(39),m3h2x6(:,112),heltab2x12(:,:,112))
  call Hloop_UW_V(ntryL,G1H12(68),16,ex2(:),2,G2H6(40),m3h2x6(:,113),heltab2x12(:,:,113))
  call Hloop_SV_V(ntryL,G0H12(46),ex2(:),G0H6(23),m3h2x6(:,114),heltab2x12(:,:,114))
  call Hloop_SV_V(ntryL,G0H12(47),ex2(:),G0H6(24),m3h2x6(:,115),heltab2x12(:,:,115))
  call Hloop_UW_V(ntryL,G1H12(69),16,ex2(:),2,G2H6(41),m3h2x6(:,116),heltab2x12(:,:,116))
  call Hloop_UW_V(ntryL,G1H12(70),16,ex2(:),2,G2H6(42),m3h2x6(:,117),heltab2x12(:,:,117))
  call Hloop_UW_V(ntryL,G0H12(48),16,ex2(:),2,G1H6(52),m3h2x6(:,118),heltab2x12(:,:,118))
  call Hloop_AV_Q(ntryL,G1H12(71),ex3(:),G1H6(53),m3h2x6(:,119),heltab2x12(:,:,119))
  call Hloop_A_Q(ntryL,G1H6(53),20,nML,G2H6(43),n2h6(7))
  call Hloop_QV_A(ntryL,G1H12(72),ex3(:),G1H6(53),m3h2x6(:,120),heltab2x12(:,:,120))
  call Hloop_Q_A(ntryL,G1H6(53),20,nMT,G2H6(44),n2h6(8))
  call Hloop_AV_Q(ntryL,G1H12(73),ex3(:),G1H6(53),m3h2x6(:,121),heltab2x12(:,:,121))
  call Hloop_A_Q(ntryL,G1H6(53),20,nMB,G2H6(45),n2h6(9))
  call Hloop_SV_T(ntryL,G1H12(74),16,ex3(:),4,G2H6(46),m3h2x6(:,122),heltab2x12(:,:,122))
  call Hloop_SV_T(ntryL,G1H12(75),16,ex3(:),4,G2H6(47),m3h2x6(:,123),heltab2x12(:,:,123))
  call Hloop_DV_C(ntryL,G1H12(76),16,ex3(:),G2H6(48),m3h2x6(:,124),heltab2x12(:,:,124))
  call Hloop_DV_C(ntryL,G1H12(77),16,ex3(:),G2H6(49),m3h2x6(:,125),heltab2x12(:,:,125))
  call Hloop_CV_D(ntryL,G1H12(78),16,ex3(:),4,G2H6(50),m3h2x6(:,126),heltab2x12(:,:,126))
  call Hloop_CV_D(ntryL,G1H12(79),16,ex3(:),4,G2H6(51),m3h2x6(:,127),heltab2x12(:,:,127))
  call Hloop_UW_V(ntryL,G1H12(80),16,ex3(:),4,G2H6(52),m3h2x6(:,128),heltab2x12(:,:,128))
  call Hloop_UW_V(ntryL,G1H12(81),16,ex3(:),4,G2H6(53),m3h2x6(:,129),heltab2x12(:,:,129))
  call Hloop_SV_T(ntryL,G0H12(49),16,ex3(:),4,G1H6(53),m3h2x6(:,130),heltab2x12(:,:,130))
  call Hloop_SV_T(ntryL,G0H12(50),16,ex3(:),4,G1H6(54),m3h2x6(:,131),heltab2x12(:,:,131))
  call Hloop_VV_S(ntryL,G0H12(51),ex3(:),G0H6(25),m3h2x6(:,132),heltab2x12(:,:,132))
  call Hloop_SV_V(ntryL,G1H12(82),ex3(:),G1H6(55),m3h2x6(:,133),heltab2x12(:,:,133))
  call Hloop_SV_V(ntryL,G1H12(83),ex3(:),G1H6(56),m3h2x6(:,134),heltab2x12(:,:,134))
  call Hloop_SV_T(ntryL,G1H12(84),16,ex3(:),4,G2H6(54),m3h2x6(:,135),heltab2x12(:,:,135))
  call Hloop_SV_T(ntryL,G1H12(85),16,ex3(:),4,G2H6(55),m3h2x6(:,136),heltab2x12(:,:,136))
  call Hloop_SV_T(ntryL,G1H12(86),16,ex3(:),4,G2H6(56),m3h2x6(:,137),heltab2x12(:,:,137))
  call Hloop_VV_S(ntryL,G1H12(87),ex3(:),G1H6(57),m3h2x6(:,138),heltab2x12(:,:,138))
  call Hloop_VV_S(ntryL,G1H12(88),ex3(:),G1H6(58),m3h2x6(:,139),heltab2x12(:,:,139))
  call Hloop_SV_V(ntryL,G0H12(52),ex3(:),G0H6(26),m3h2x6(:,140),heltab2x12(:,:,140))
  call Hloop_SV_V(ntryL,G0H12(53),ex3(:),G0H6(27),m3h2x6(:,141),heltab2x12(:,:,141))
  call Hloop_UW_V(ntryL,G0H12(54),16,ex3(:),4,G1H6(59),m3h2x6(:,142),heltab2x12(:,:,142))
  call Hloop_SV_T(ntryL,G0H12(55),16,ex3(:),4,G1H6(60),m3h2x6(:,143),heltab2x12(:,:,143))
  call Hloop_SV_T(ntryL,G0H12(56),16,ex3(:),4,G1H6(61),m3h2x6(:,144),heltab2x12(:,:,144))
  call Hloop_VV_S(ntryL,G0H12(57),ex3(:),G0H6(28),m3h2x6(:,145),heltab2x12(:,:,145))
  call Hloop_SV_V(ntryL,G1H12(89),ex3(:),G1H6(62),m3h2x6(:,146),heltab2x12(:,:,146))
  call Hloop_SV_T(ntryL,G0H12(58),16,ex3(:),4,G1H6(63),m3h2x6(:,147),heltab2x12(:,:,147))
  call Hloop_SV_T(ntryL,G0H12(59),16,ex3(:),4,G1H6(64),m3h2x6(:,148),heltab2x12(:,:,148))
  call Hloop_VV_S(ntryL,G0H12(60),ex3(:),G0H6(29),m3h2x6(:,149),heltab2x12(:,:,149))
  call Hloop_SV_V(ntryL,G1H12(90),ex3(:),G1H6(65),m3h2x6(:,150),heltab2x12(:,:,150))
  call Hloop_SV_V(ntryL,G1H12(91),ex3(:),G1H6(66),m3h2x6(:,151),heltab2x12(:,:,151))
  call Hloop_SV_T(ntryL,G1H12(92),16,ex3(:),4,G2H6(57),m3h2x6(:,152),heltab2x12(:,:,152))
  call Hloop_UW_V(ntryL,G1H12(93),16,ex3(:),4,G2H6(58),m3h2x6(:,153),heltab2x12(:,:,153))
  call Hloop_UW_V(ntryL,G1H12(94),16,ex3(:),4,G2H6(59),m3h2x6(:,154),heltab2x12(:,:,154))
  call Hloop_VV_S(ntryL,G1H12(95),ex3(:),G1H6(67),m3h2x6(:,155),heltab2x12(:,:,155))
  call Hloop_VV_S(ntryL,G1H12(96),ex3(:),G1H6(68),m3h2x6(:,156),heltab2x12(:,:,156))
  call Hloop_SV_V(ntryL,G0H12(61),ex3(:),G0H6(30),m3h2x6(:,157),heltab2x12(:,:,157))
  call Hloop_SV_V(ntryL,G0H12(62),ex3(:),G0H6(31),m3h2x6(:,158),heltab2x12(:,:,158))
  call Hloop_UW_V(ntryL,G0H12(63),16,ex3(:),4,G1H6(69),m3h2x6(:,159),heltab2x12(:,:,159))
  call Hloop_VV_S(ntryL,G1H12(97),ex3(:),G1H6(70),m3h2x6(:,160),heltab2x12(:,:,160))
  call Hloop_VV_S(ntryL,G1H12(98),ex3(:),G1H6(71),m3h2x6(:,161),heltab2x12(:,:,161))
  call Hloop_SV_V(ntryL,G0H12(64),ex3(:),G0H6(32),m3h2x6(:,162),heltab2x12(:,:,162))
  call Hloop_SV_V(ntryL,G0H12(65),ex3(:),G0H6(33),m3h2x6(:,163),heltab2x12(:,:,163))
  call Hloop_UW_V(ntryL,G0H12(66),16,ex3(:),4,G1H6(72),m3h2x6(:,164),heltab2x12(:,:,164))
  call Hloop_SV_T(ntryL,G0H12(67),16,ex3(:),4,G1H6(73),m3h2x6(:,165),heltab2x12(:,:,165))
  call Hloop_SV_T(ntryL,G0H12(68),16,ex3(:),4,G1H6(74),m3h2x6(:,166),heltab2x12(:,:,166))
  call Hloop_VV_S(ntryL,G0H12(69),ex3(:),G0H6(34),m3h2x6(:,167),heltab2x12(:,:,167))
  call Hloop_SV_V(ntryL,G1H12(99),ex3(:),G1H6(75),m3h2x6(:,168),heltab2x12(:,:,168))
  call Hloop_UW_V(ntryL,G1H12(100),16,ex3(:),4,G2H6(60),m3h2x6(:,169),heltab2x12(:,:,169))
  call Hloop_UW_V(ntryL,G1H12(101),16,ex3(:),4,G2H6(61),m3h2x6(:,170),heltab2x12(:,:,170))
  call Hloop_UW_V(ntryL,G1H12(102),16,ex3(:),4,G2H6(62),m3h2x6(:,171),heltab2x12(:,:,171))
  call Hloop_UW_V(ntryL,G1H12(103),16,ex3(:),4,G2H6(63),m3h2x6(:,172),heltab2x12(:,:,172))
  call Hloop_VV_S(ntryL,G1H12(104),ex3(:),G1H6(76),m3h2x6(:,173),heltab2x12(:,:,173))
  call Hloop_VV_S(ntryL,G1H12(105),ex3(:),G1H6(77),m3h2x6(:,174),heltab2x12(:,:,174))
  call Hloop_SV_V(ntryL,G0H12(70),ex3(:),G0H6(35),m3h2x6(:,175),heltab2x12(:,:,175))
  call Hloop_SV_V(ntryL,G0H12(71),ex3(:),G0H6(36),m3h2x6(:,176),heltab2x12(:,:,176))
  call Hloop_UW_V(ntryL,G0H12(72),16,ex3(:),4,G1H6(78),m3h2x6(:,177),heltab2x12(:,:,177))
  call Hloop_QV_A(ntryL,G1H12(106),ex2(:),G1H6(79),m3h2x6(:,178),heltab2x12(:,:,178))
  call Hloop_Q_A(ntryL,G1H6(79),18,nMT,G2H6(64),n2h6(10))
  call Hloop_AV_Q(ntryL,G1H12(107),ex2(:),G1H6(79),m3h2x6(:,179),heltab2x12(:,:,179))
  call Hloop_A_Q(ntryL,G1H6(79),18,nMB,G2H6(65),n2h6(11))
  call Hloop_AS_Q(ntryL,G1H12(108),ex1(:),G1H12(1),ngH,m3h1x12(:,1),heltab2x12(:,:,180))
  call Hloop_A_Q(ntryL,G1H12(1),17,nML,G2H12(1),n2h12(31))
  call Hloop_QS_A(ntryL,G1H12(109),ex1(:),G1H12(2),ngH,m3h1x12(:,2),heltab2x12(:,:,181))
  call Hloop_Q_A(ntryL,G1H12(2),17,nMT,G2H12(2),n2h12(32))
  call Hloop_AS_Q(ntryL,G1H12(110),ex1(:),G1H12(3),ngH,m3h1x12(:,3),heltab2x12(:,:,182))
  call Hloop_A_Q(ntryL,G1H12(3),17,nMB,G2H12(3),n2h12(33))
  call Hloop_SS_S(ntryL,G1H12(111),ex1(:),G1H12(4),m3h1x12(:,4),heltab2x12(:,:,183))
  call Hloop_SS_S(ntryL,G1H12(112),ex1(:),G1H12(5),m3h1x12(:,5),heltab2x12(:,:,184))
  call Hloop_SS_S(ntryL,G1H12(113),ex1(:),G1H12(6),m3h1x12(:,6),heltab2x12(:,:,185))
  call Hloop_SS_S(ntryL,G1H12(114),ex1(:),G1H12(7),m3h1x12(:,7),heltab2x12(:,:,186))
  call Hloop_SS_S(ntryL,G1H12(115),ex1(:),G1H12(8),m3h1x12(:,8),heltab2x12(:,:,187))
  call Hloop_SS_S(ntryL,G1H12(116),ex1(:),G1H12(9),m3h1x12(:,9),heltab2x12(:,:,188))
  call Hloop_VS_V(ntryL,G1H12(117),ex1(:),G1H12(10),m3h1x12(:,10),heltab2x12(:,:,189))
  call Hloop_VS_V(ntryL,G1H12(118),ex1(:),G1H12(11),m3h1x12(:,11),heltab2x12(:,:,190))
  call Hloop_SS_S(ntryL,G0H12(73),ex1(:),G0H12(1),m3h1x12(:,12),heltab2x12(:,:,191))
  call Hloop_SS_S(ntryL,G0H12(74),ex1(:),G0H12(2),m3h1x12(:,13),heltab2x12(:,:,192))
  call Hloop_SS_S(ntryL,G1H12(119),ex1(:),G1H12(12),m3h1x12(:,14),heltab2x12(:,:,193))
  call Hloop_SS_S(ntryL,G1H12(120),ex1(:),G1H12(13),m3h1x12(:,15),heltab2x12(:,:,194))
  call Hloop_SS_S(ntryL,G1H12(121),ex1(:),G1H12(14),m3h1x12(:,16),heltab2x12(:,:,195))
  call Hloop_VT_S(ntryL,G0H12(75),16,ex1(:),1,G1H12(15),m3h1x12(:,17),heltab2x12(:,:,196))
  call Hloop_ST_V(ntryL,G1H12(122),16,ex1(:),1,G2H12(4),m3h1x12(:,18),heltab2x12(:,:,197))
  call Hloop_ST_V(ntryL,G1H12(123),16,ex1(:),1,G2H12(5),m3h1x12(:,19),heltab2x12(:,:,198))
  call Hloop_SS_S(ntryL,G0H12(76),ex1(:),G0H12(3),m3h1x12(:,20),heltab2x12(:,:,199))
  call Hloop_SS_S(ntryL,G0H12(77),ex1(:),G0H12(4),m3h1x12(:,21),heltab2x12(:,:,200))
  call Hloop_SS_S(ntryL,G0H12(78),ex1(:),G0H12(5),m3h1x12(:,22),heltab2x12(:,:,201))
  call Hloop_SS_S(ntryL,G0H12(79),ex1(:),G0H12(6),m3h1x12(:,23),heltab2x12(:,:,202))
  call Hloop_SS_S(ntryL,G1H12(124),ex1(:),G1H12(16),m3h1x12(:,24),heltab2x12(:,:,203))
  call Hloop_VT_S(ntryL,G1H12(125),16,ex1(:),1,G2H12(6),m3h1x12(:,25),heltab2x12(:,:,204))
  call Hloop_VT_S(ntryL,G1H12(126),16,ex1(:),1,G2H12(7),m3h1x12(:,26),heltab2x12(:,:,205))
  call Hloop_VT_S(ntryL,G0H12(80),16,ex1(:),1,G1H12(17),m3h1x12(:,27),heltab2x12(:,:,206))
  call Hloop_VT_S(ntryL,G0H12(81),16,ex1(:),1,G1H12(18),m3h1x12(:,28),heltab2x12(:,:,207))
  call Hloop_ST_V(ntryL,G0H12(82),16,ex1(:),1,G1H12(19),m3h1x12(:,29),heltab2x12(:,:,208))
  call Hloop_ST_V(ntryL,G0H12(83),16,ex1(:),1,G1H12(20),m3h1x12(:,30),heltab2x12(:,:,209))
  call Hloop_ST_V(ntryL,G1H12(127),16,ex1(:),1,G2H12(8),m3h1x12(:,31),heltab2x12(:,:,210))
  call Hloop_ST_V(ntryL,G1H12(128),16,ex1(:),1,G2H12(9),m3h1x12(:,32),heltab2x12(:,:,211))
  call Hloop_ST_V(ntryL,G1H12(129),16,ex1(:),1,G2H12(10),m3h1x12(:,33),heltab2x12(:,:,212))
  call Hloop_VS_V(ntryL,G0H12(84),ex1(:),G0H12(7),m3h1x12(:,34),heltab2x12(:,:,213))
  call Hloop_SS_S(ntryL,G0H12(85),ex1(:),G0H12(8),m3h1x12(:,35),heltab2x12(:,:,214))
  call Hloop_SS_S(ntryL,G0H12(86),ex1(:),G0H12(9),m3h1x12(:,36),heltab2x12(:,:,215))
  call Hloop_VT_S(ntryL,G1H12(130),16,ex1(:),1,G2H12(11),m3h1x12(:,37),heltab2x12(:,:,216))
  call Hloop_VT_S(ntryL,G1H12(131),16,ex1(:),1,G2H12(12),m3h1x12(:,38),heltab2x12(:,:,217))
  call Hloop_VT_S(ntryL,G1H12(132),16,ex1(:),1,G2H12(13),m3h1x12(:,39),heltab2x12(:,:,218))
  call Hloop_VT_S(ntryL,G1H12(133),16,ex1(:),1,G2H12(14),m3h1x12(:,40),heltab2x12(:,:,219))
  call Hloop_VT_S(ntryL,G0H12(87),16,ex1(:),1,G1H12(21),m3h1x12(:,41),heltab2x12(:,:,220))
  call Hloop_ST_V(ntryL,G0H12(88),16,ex1(:),1,G1H12(22),m3h1x12(:,42),heltab2x12(:,:,221))
  call Hloop_ST_V(ntryL,G0H12(89),16,ex1(:),1,G1H12(23),m3h1x12(:,43),heltab2x12(:,:,222))
  call Hloop_ST_V(ntryL,G0H12(90),16,ex1(:),1,G1H12(24),m3h1x12(:,44),heltab2x12(:,:,223))
  call Hloop_ST_V(ntryL,G0H12(91),16,ex1(:),1,G1H12(25),m3h1x12(:,45),heltab2x12(:,:,224))
  call Hloop_ST_V(ntryL,G1H12(134),16,ex1(:),1,G2H12(15),m3h1x12(:,46),heltab2x12(:,:,225))
  call Hloop_VS_V(ntryL,G1H12(135),ex1(:),G1H12(26),m3h1x12(:,47),heltab2x12(:,:,226))
  call Hloop_VS_V(ntryL,G1H12(136),ex1(:),G1H12(27),m3h1x12(:,48),heltab2x12(:,:,227))
  call Hloop_VS_V(ntryL,G0H12(92),ex1(:),G0H12(10),m3h1x12(:,49),heltab2x12(:,:,228))
  call Hloop_VS_V(ntryL,G0H12(93),ex1(:),G0H12(11),m3h1x12(:,50),heltab2x12(:,:,229))
  call Hloop_VT_S(ntryL,G1H12(137),16,ex1(:),1,G2H12(16),m3h1x12(:,51),heltab2x12(:,:,230))
  call Hloop_VT_S(ntryL,G1H12(138),16,ex1(:),1,G2H12(17),m3h1x12(:,52),heltab2x12(:,:,231))
  call Hloop_ST_V(ntryL,G0H12(94),16,ex1(:),1,G1H12(28),m3h1x12(:,53),heltab2x12(:,:,232))
  call Hloop_ST_V(ntryL,G0H12(95),16,ex1(:),1,G1H12(29),m3h1x12(:,54),heltab2x12(:,:,233))
  call Hloop_VS_V(ntryL,G1H12(139),ex1(:),G1H12(30),m3h1x12(:,55),heltab2x12(:,:,234))
  call Hloop_VS_V(ntryL,G1H12(140),ex1(:),G1H12(31),m3h1x12(:,56),heltab2x12(:,:,235))
  call Hloop_VS_V(ntryL,G1H12(141),ex1(:),G1H12(32),m3h1x12(:,57),heltab2x12(:,:,236))
  call Hloop_VS_V(ntryL,G1H12(142),ex1(:),G1H12(33),m3h1x12(:,58),heltab2x12(:,:,237))
  call Hloop_VS_V(ntryL,G0H12(96),ex1(:),G0H12(12),m3h1x12(:,59),heltab2x12(:,:,238))
  call Hloop_QS_A(ntryL,G1H12(143),ex1(:),G1H12(34),ngH,m3h1x12(:,60),heltab2x12(:,:,239))
  call Hloop_Q_A(ntryL,G1H12(34),17,nMT,G2H12(18),n2h12(34))
  call Hloop_AS_Q(ntryL,G1H12(144),ex1(:),G1H12(35),ngH,m3h1x12(:,61),heltab2x12(:,:,240))
  call Hloop_A_Q(ntryL,G1H12(35),17,nMB,G2H12(19),n2h12(35))
  call Hloop_AV_Q(ntryL,G1H12(145),ex2(:),G1H6(79),m3h2x6(:,180),heltab2x12(:,:,241))
  call Hloop_A_Q(ntryL,G1H6(79),18,nML,G2H6(66),n2h6(12))
  call Hloop_QV_A(ntryL,G1H12(146),ex2(:),G1H6(79),m3h2x6(:,181),heltab2x12(:,:,242))
  call Hloop_Q_A(ntryL,G1H6(79),18,nMT,G2H6(67),n2h6(13))
  call Hloop_AV_Q(ntryL,G1H12(147),ex2(:),G1H6(79),m3h2x6(:,182),heltab2x12(:,:,243))
  call Hloop_A_Q(ntryL,G1H6(79),18,nMB,G2H6(68),n2h6(14))
  call Hloop_SV_T(ntryL,G1H12(148),16,ex2(:),2,G2H6(69),m3h2x6(:,183),heltab2x12(:,:,244))
  call Hloop_SV_T(ntryL,G1H12(149),16,ex2(:),2,G2H6(70),m3h2x6(:,184),heltab2x12(:,:,245))
  call Hloop_DV_C(ntryL,G1H12(150),16,ex2(:),G2H6(71),m3h2x6(:,185),heltab2x12(:,:,246))
  call Hloop_DV_C(ntryL,G1H12(151),16,ex2(:),G2H6(72),m3h2x6(:,186),heltab2x12(:,:,247))
  call Hloop_CV_D(ntryL,G1H12(152),16,ex2(:),2,G2H6(73),m3h2x6(:,187),heltab2x12(:,:,248))
  call Hloop_CV_D(ntryL,G1H12(153),16,ex2(:),2,G2H6(74),m3h2x6(:,188),heltab2x12(:,:,249))
  call Hloop_UW_V(ntryL,G1H12(154),16,ex2(:),2,G2H6(75),m3h2x6(:,189),heltab2x12(:,:,250))
  call Hloop_UW_V(ntryL,G1H12(155),16,ex2(:),2,G2H6(76),m3h2x6(:,190),heltab2x12(:,:,251))
  call Hloop_SV_T(ntryL,G0H12(97),16,ex2(:),2,G1H6(79),m3h2x6(:,191),heltab2x12(:,:,252))
  call Hloop_SV_T(ntryL,G0H12(98),16,ex2(:),2,G1H6(80),m3h2x6(:,192),heltab2x12(:,:,253))
  call Hloop_VV_S(ntryL,G0H12(99),ex2(:),G0H6(37),m3h2x6(:,193),heltab2x12(:,:,254))
  call Hloop_SV_V(ntryL,G1H12(156),ex2(:),G1H6(81),m3h2x6(:,194),heltab2x12(:,:,255))
  call Hloop_SV_V(ntryL,G1H12(157),ex2(:),G1H6(82),m3h2x6(:,195),heltab2x12(:,:,256))
  call Hloop_SV_T(ntryL,G1H12(158),16,ex2(:),2,G2H6(77),m3h2x6(:,196),heltab2x12(:,:,257))
  call Hloop_SV_T(ntryL,G1H12(159),16,ex2(:),2,G2H6(78),m3h2x6(:,197),heltab2x12(:,:,258))
  call Hloop_SV_T(ntryL,G1H12(160),16,ex2(:),2,G2H6(79),m3h2x6(:,198),heltab2x12(:,:,259))
  call Hloop_VV_S(ntryL,G1H12(161),ex2(:),G1H6(83),m3h2x6(:,199),heltab2x12(:,:,260))
  call Hloop_VV_S(ntryL,G1H12(162),ex2(:),G1H6(84),m3h2x6(:,200),heltab2x12(:,:,261))
  call Hloop_SV_V(ntryL,G0H12(100),ex2(:),G0H6(38),m3h2x6(:,201),heltab2x12(:,:,262))
  call Hloop_SV_V(ntryL,G0H12(101),ex2(:),G0H6(39),m3h2x6(:,202),heltab2x12(:,:,263))
  call Hloop_UW_V(ntryL,G0H12(102),16,ex2(:),2,G1H6(85),m3h2x6(:,203),heltab2x12(:,:,264))
  call Hloop_SV_T(ntryL,G0H12(103),16,ex2(:),2,G1H6(86),m3h2x6(:,204),heltab2x12(:,:,265))
  call Hloop_SV_T(ntryL,G0H12(104),16,ex2(:),2,G1H6(87),m3h2x6(:,205),heltab2x12(:,:,266))
  call Hloop_VV_S(ntryL,G0H12(105),ex2(:),G0H6(40),m3h2x6(:,206),heltab2x12(:,:,267))
  call Hloop_SV_V(ntryL,G1H12(163),ex2(:),G1H6(88),m3h2x6(:,207),heltab2x12(:,:,268))
  call Hloop_SV_T(ntryL,G0H12(106),16,ex2(:),2,G1H6(89),m3h2x6(:,208),heltab2x12(:,:,269))
  call Hloop_SV_T(ntryL,G0H12(107),16,ex2(:),2,G1H6(90),m3h2x6(:,209),heltab2x12(:,:,270))
  call Hloop_VV_S(ntryL,G0H12(108),ex2(:),G0H6(41),m3h2x6(:,210),heltab2x12(:,:,271))
  call Hloop_SV_V(ntryL,G1H12(164),ex2(:),G1H6(91),m3h2x6(:,211),heltab2x12(:,:,272))
  call Hloop_SV_V(ntryL,G1H12(165),ex2(:),G1H6(92),m3h2x6(:,212),heltab2x12(:,:,273))
  call Hloop_SV_T(ntryL,G1H12(166),16,ex2(:),2,G2H6(80),m3h2x6(:,213),heltab2x12(:,:,274))
  call Hloop_UW_V(ntryL,G1H12(167),16,ex2(:),2,G2H6(81),m3h2x6(:,214),heltab2x12(:,:,275))
  call Hloop_UW_V(ntryL,G1H12(168),16,ex2(:),2,G2H6(82),m3h2x6(:,215),heltab2x12(:,:,276))
  call Hloop_VV_S(ntryL,G1H12(169),ex2(:),G1H6(93),m3h2x6(:,216),heltab2x12(:,:,277))
  call Hloop_VV_S(ntryL,G1H12(170),ex2(:),G1H6(94),m3h2x6(:,217),heltab2x12(:,:,278))
  call Hloop_SV_V(ntryL,G0H12(109),ex2(:),G0H6(42),m3h2x6(:,218),heltab2x12(:,:,279))
  call Hloop_SV_V(ntryL,G0H12(110),ex2(:),G0H6(43),m3h2x6(:,219),heltab2x12(:,:,280))
  call Hloop_UW_V(ntryL,G0H12(111),16,ex2(:),2,G1H6(95),m3h2x6(:,220),heltab2x12(:,:,281))
  call Hloop_VV_S(ntryL,G1H12(171),ex2(:),G1H6(96),m3h2x6(:,221),heltab2x12(:,:,282))
  call Hloop_VV_S(ntryL,G1H12(172),ex2(:),G1H6(97),m3h2x6(:,222),heltab2x12(:,:,283))
  call Hloop_SV_V(ntryL,G0H12(112),ex2(:),G0H6(44),m3h2x6(:,223),heltab2x12(:,:,284))
  call Hloop_SV_V(ntryL,G0H12(113),ex2(:),G0H6(45),m3h2x6(:,224),heltab2x12(:,:,285))
  call Hloop_UW_V(ntryL,G0H12(114),16,ex2(:),2,G1H6(98),m3h2x6(:,225),heltab2x12(:,:,286))
  call Hloop_SV_T(ntryL,G0H12(115),16,ex2(:),2,G1H6(99),m3h2x6(:,226),heltab2x12(:,:,287))
  call Hloop_SV_T(ntryL,G0H12(116),16,ex2(:),2,G1H6(100),m3h2x6(:,227),heltab2x12(:,:,288))
  call Hloop_VV_S(ntryL,G0H12(117),ex2(:),G0H6(46),m3h2x6(:,228),heltab2x12(:,:,289))
  call Hloop_SV_V(ntryL,G1H12(173),ex2(:),G1H6(101),m3h2x6(:,229),heltab2x12(:,:,290))
  call Hloop_UW_V(ntryL,G1H12(174),16,ex2(:),2,G2H6(83),m3h2x6(:,230),heltab2x12(:,:,291))
  call Hloop_UW_V(ntryL,G1H12(175),16,ex2(:),2,G2H6(84),m3h2x6(:,231),heltab2x12(:,:,292))
  call Hloop_UW_V(ntryL,G1H12(176),16,ex2(:),2,G2H6(85),m3h2x6(:,232),heltab2x12(:,:,293))
  call Hloop_UW_V(ntryL,G1H12(177),16,ex2(:),2,G2H6(86),m3h2x6(:,233),heltab2x12(:,:,294))
  call Hloop_VV_S(ntryL,G1H12(178),ex2(:),G1H6(102),m3h2x6(:,234),heltab2x12(:,:,295))
  call Hloop_VV_S(ntryL,G1H12(179),ex2(:),G1H6(103),m3h2x6(:,235),heltab2x12(:,:,296))
  call Hloop_SV_V(ntryL,G0H12(118),ex2(:),G0H6(47),m3h2x6(:,236),heltab2x12(:,:,297))
  call Hloop_SV_V(ntryL,G0H12(119),ex2(:),G0H6(48),m3h2x6(:,237),heltab2x12(:,:,298))
  call Hloop_UW_V(ntryL,G0H12(120),16,ex2(:),2,G1H6(104),m3h2x6(:,238),heltab2x12(:,:,299))
  call Hloop_AV_Q(ntryL,G1H12(180),ex2(:),G1H6(105),m3h2x6(:,239),heltab2x12(:,:,300))
  call Hloop_A_Q(ntryL,G1H6(105),18,nMB,G2H6(87),n2h6(15))
  call Hloop_QV_A(ntryL,G1H12(181),ex2(:),G1H6(105),m3h2x6(:,240),heltab2x12(:,:,301))
  call Hloop_Q_A(ntryL,G1H6(105),18,nMT,G2H6(88),n2h6(16))
  call Hloop_AS_Q(ntryL,G1H12(182),ex1(:),G1H12(36),ngH,m3h1x12(:,62),heltab2x12(:,:,302))
  call Hloop_A_Q(ntryL,G1H12(36),17,nML,G2H12(20),n2h12(36))
  call Hloop_QS_A(ntryL,G1H12(183),ex1(:),G1H12(37),ngH,m3h1x12(:,63),heltab2x12(:,:,303))
  call Hloop_Q_A(ntryL,G1H12(37),17,nMT,G2H12(21),n2h12(37))
  call Hloop_AS_Q(ntryL,G1H12(184),ex1(:),G1H12(38),ngH,m3h1x12(:,64),heltab2x12(:,:,304))
  call Hloop_A_Q(ntryL,G1H12(38),17,nMB,G2H12(22),n2h12(38))
  call Hloop_SS_S(ntryL,G1H12(185),ex1(:),G1H12(39),m3h1x12(:,65),heltab2x12(:,:,305))
  call Hloop_SS_S(ntryL,G1H12(186),ex1(:),G1H12(40),m3h1x12(:,66),heltab2x12(:,:,306))
  call Hloop_SS_S(ntryL,G1H12(187),ex1(:),G1H12(41),m3h1x12(:,67),heltab2x12(:,:,307))
  call Hloop_SS_S(ntryL,G1H12(188),ex1(:),G1H12(42),m3h1x12(:,68),heltab2x12(:,:,308))
  call Hloop_SS_S(ntryL,G1H12(189),ex1(:),G1H12(43),m3h1x12(:,69),heltab2x12(:,:,309))
  call Hloop_SS_S(ntryL,G1H12(190),ex1(:),G1H12(44),m3h1x12(:,70),heltab2x12(:,:,310))
  call Hloop_VS_V(ntryL,G1H12(191),ex1(:),G1H12(45),m3h1x12(:,71),heltab2x12(:,:,311))
  call Hloop_VS_V(ntryL,G1H12(192),ex1(:),G1H12(46),m3h1x12(:,72),heltab2x12(:,:,312))
  call Hloop_SS_S(ntryL,G0H12(121),ex1(:),G0H12(13),m3h1x12(:,73),heltab2x12(:,:,313))
  call Hloop_SS_S(ntryL,G0H12(122),ex1(:),G0H12(14),m3h1x12(:,74),heltab2x12(:,:,314))
  call Hloop_SS_S(ntryL,G1H12(193),ex1(:),G1H12(47),m3h1x12(:,75),heltab2x12(:,:,315))
  call Hloop_SS_S(ntryL,G1H12(194),ex1(:),G1H12(48),m3h1x12(:,76),heltab2x12(:,:,316))
  call Hloop_SS_S(ntryL,G1H12(195),ex1(:),G1H12(49),m3h1x12(:,77),heltab2x12(:,:,317))
  call Hloop_VT_S(ntryL,G0H12(123),16,ex1(:),1,G1H12(50),m3h1x12(:,78),heltab2x12(:,:,318))
  call Hloop_ST_V(ntryL,G1H12(196),16,ex1(:),1,G2H12(23),m3h1x12(:,79),heltab2x12(:,:,319))
  call Hloop_ST_V(ntryL,G1H12(197),16,ex1(:),1,G2H12(24),m3h1x12(:,80),heltab2x12(:,:,320))
  call Hloop_SS_S(ntryL,G0H12(124),ex1(:),G0H12(15),m3h1x12(:,81),heltab2x12(:,:,321))
  call Hloop_SS_S(ntryL,G0H12(125),ex1(:),G0H12(16),m3h1x12(:,82),heltab2x12(:,:,322))
  call Hloop_SS_S(ntryL,G0H12(126),ex1(:),G0H12(17),m3h1x12(:,83),heltab2x12(:,:,323))
  call Hloop_SS_S(ntryL,G0H12(127),ex1(:),G0H12(18),m3h1x12(:,84),heltab2x12(:,:,324))
  call Hloop_SS_S(ntryL,G1H12(198),ex1(:),G1H12(51),m3h1x12(:,85),heltab2x12(:,:,325))
  call Hloop_VT_S(ntryL,G1H12(199),16,ex1(:),1,G2H12(25),m3h1x12(:,86),heltab2x12(:,:,326))
  call Hloop_VT_S(ntryL,G1H12(200),16,ex1(:),1,G2H12(26),m3h1x12(:,87),heltab2x12(:,:,327))
  call Hloop_VT_S(ntryL,G0H12(128),16,ex1(:),1,G1H12(52),m3h1x12(:,88),heltab2x12(:,:,328))
  call Hloop_VT_S(ntryL,G0H12(129),16,ex1(:),1,G1H12(53),m3h1x12(:,89),heltab2x12(:,:,329))
  call Hloop_ST_V(ntryL,G0H12(130),16,ex1(:),1,G1H12(54),m3h1x12(:,90),heltab2x12(:,:,330))
  call Hloop_ST_V(ntryL,G0H12(131),16,ex1(:),1,G1H12(55),m3h1x12(:,91),heltab2x12(:,:,331))
  call Hloop_ST_V(ntryL,G1H12(201),16,ex1(:),1,G2H12(27),m3h1x12(:,92),heltab2x12(:,:,332))
  call Hloop_ST_V(ntryL,G1H12(202),16,ex1(:),1,G2H12(28),m3h1x12(:,93),heltab2x12(:,:,333))
  call Hloop_ST_V(ntryL,G1H12(203),16,ex1(:),1,G2H12(29),m3h1x12(:,94),heltab2x12(:,:,334))
  call Hloop_VS_V(ntryL,G0H12(132),ex1(:),G0H12(19),m3h1x12(:,95),heltab2x12(:,:,335))
  call Hloop_SS_S(ntryL,G0H12(133),ex1(:),G0H12(20),m3h1x12(:,96),heltab2x12(:,:,336))
  call Hloop_SS_S(ntryL,G0H12(134),ex1(:),G0H12(21),m3h1x12(:,97),heltab2x12(:,:,337))
  call Hloop_VT_S(ntryL,G1H12(204),16,ex1(:),1,G2H12(30),m3h1x12(:,98),heltab2x12(:,:,338))
  call Hloop_VT_S(ntryL,G1H12(205),16,ex1(:),1,G2H12(31),m3h1x12(:,99),heltab2x12(:,:,339))
  call Hloop_VT_S(ntryL,G1H12(206),16,ex1(:),1,G2H12(32),m3h1x12(:,100),heltab2x12(:,:,340))
  call Hloop_VT_S(ntryL,G1H12(207),16,ex1(:),1,G2H12(33),m3h1x12(:,101),heltab2x12(:,:,341))
  call Hloop_VT_S(ntryL,G0H12(135),16,ex1(:),1,G1H12(56),m3h1x12(:,102),heltab2x12(:,:,342))
  call Hloop_ST_V(ntryL,G0H12(136),16,ex1(:),1,G1H12(57),m3h1x12(:,103),heltab2x12(:,:,343))
  call Hloop_ST_V(ntryL,G0H12(137),16,ex1(:),1,G1H12(58),m3h1x12(:,104),heltab2x12(:,:,344))
  call Hloop_ST_V(ntryL,G0H12(138),16,ex1(:),1,G1H12(59),m3h1x12(:,105),heltab2x12(:,:,345))
  call Hloop_ST_V(ntryL,G0H12(139),16,ex1(:),1,G1H12(60),m3h1x12(:,106),heltab2x12(:,:,346))
  call Hloop_ST_V(ntryL,G1H12(208),16,ex1(:),1,G2H12(34),m3h1x12(:,107),heltab2x12(:,:,347))
  call Hloop_VS_V(ntryL,G1H12(209),ex1(:),G1H12(61),m3h1x12(:,108),heltab2x12(:,:,348))
  call Hloop_VS_V(ntryL,G1H12(210),ex1(:),G1H12(62),m3h1x12(:,109),heltab2x12(:,:,349))
  call Hloop_VS_V(ntryL,G0H12(140),ex1(:),G0H12(22),m3h1x12(:,110),heltab2x12(:,:,350))
  call Hloop_VS_V(ntryL,G0H12(141),ex1(:),G0H12(23),m3h1x12(:,111),heltab2x12(:,:,351))
  call Hloop_VT_S(ntryL,G1H12(211),16,ex1(:),1,G2H12(35),m3h1x12(:,112),heltab2x12(:,:,352))
  call Hloop_VT_S(ntryL,G1H12(212),16,ex1(:),1,G2H12(36),m3h1x12(:,113),heltab2x12(:,:,353))
  call Hloop_ST_V(ntryL,G0H12(142),16,ex1(:),1,G1H12(63),m3h1x12(:,114),heltab2x12(:,:,354))
  call Hloop_ST_V(ntryL,G0H12(143),16,ex1(:),1,G1H12(64),m3h1x12(:,115),heltab2x12(:,:,355))
  call Hloop_VS_V(ntryL,G1H12(213),ex1(:),G1H12(65),m3h1x12(:,116),heltab2x12(:,:,356))
  call Hloop_VS_V(ntryL,G1H12(214),ex1(:),G1H12(66),m3h1x12(:,117),heltab2x12(:,:,357))
  call Hloop_VS_V(ntryL,G1H12(215),ex1(:),G1H12(67),m3h1x12(:,118),heltab2x12(:,:,358))
  call Hloop_VS_V(ntryL,G1H12(216),ex1(:),G1H12(68),m3h1x12(:,119),heltab2x12(:,:,359))
  call Hloop_VS_V(ntryL,G0H12(144),ex1(:),G0H12(24),m3h1x12(:,120),heltab2x12(:,:,360))
  call Hloop_QS_A(ntryL,G1H12(217),ex1(:),G1H12(69),ngH,m3h1x12(:,121),heltab2x12(:,:,361))
  call Hloop_Q_A(ntryL,G1H12(69),17,nMT,G2H12(37),n2h12(39))
  call Hloop_AS_Q(ntryL,G1H12(218),ex1(:),G1H12(70),ngH,m3h1x12(:,122),heltab2x12(:,:,362))
  call Hloop_A_Q(ntryL,G1H12(70),17,nMB,G2H12(38),n2h12(40))
  call Hloop_AS_Q(ntryL,G1H12(219),ex1(:),G1H12(71),ngH,m3h1x12(:,123),heltab2x12(:,:,363))
  call Hloop_A_Q(ntryL,G1H12(71),17,nMB,G2H12(39),n2h12(41))
  call Hloop_QS_A(ntryL,G1H12(220),ex1(:),G1H12(72),ngH,m3h1x12(:,124),heltab2x12(:,:,364))
  call Hloop_Q_A(ntryL,G1H12(72),17,nMT,G2H12(40),n2h12(42))
  call Hloop_SS_S(ntryL,G1H12(221),ex1(:),G1H12(73),m3h1x12(:,125),heltab2x12(:,:,365))
  call Hloop_SS_S(ntryL,G1H12(222),ex1(:),G1H12(74),m3h1x12(:,126),heltab2x12(:,:,366))
  call Hloop_SS_S(ntryL,G1H12(223),ex1(:),G1H12(75),m3h1x12(:,127),heltab2x12(:,:,367))
  call Hloop_SS_S(ntryL,G1H12(224),ex1(:),G1H12(76),m3h1x12(:,128),heltab2x12(:,:,368))
  call Hloop_VS_V(ntryL,G1H12(225),ex1(:),G1H12(77),m3h1x12(:,129),heltab2x12(:,:,369))
  call Hloop_SS_S(ntryL,G0H12(145),ex1(:),G0H12(25),m3h1x12(:,130),heltab2x12(:,:,370))
  call Hloop_SS_S(ntryL,G1H12(226),ex1(:),G1H12(78),m3h1x12(:,131),heltab2x12(:,:,371))
  call Hloop_SS_S(ntryL,G1H12(227),ex1(:),G1H12(79),m3h1x12(:,132),heltab2x12(:,:,372))
  call Hloop_SS_S(ntryL,G1H12(228),ex1(:),G1H12(80),m3h1x12(:,133),heltab2x12(:,:,373))
  call Hloop_VT_S(ntryL,G0H12(146),16,ex1(:),1,G1H12(81),m3h1x12(:,134),heltab2x12(:,:,374))
  call Hloop_ST_V(ntryL,G1H12(229),16,ex1(:),1,G2H12(41),m3h1x12(:,135),heltab2x12(:,:,375))
  call Hloop_SS_S(ntryL,G0H12(147),ex1(:),G0H12(26),m3h1x12(:,136),heltab2x12(:,:,376))
  call Hloop_SS_S(ntryL,G0H12(148),ex1(:),G0H12(27),m3h1x12(:,137),heltab2x12(:,:,377))
  call Hloop_SS_S(ntryL,G1H12(230),ex1(:),G1H12(82),m3h1x12(:,138),heltab2x12(:,:,378))
  call Hloop_VT_S(ntryL,G1H12(231),16,ex1(:),1,G2H12(42),m3h1x12(:,139),heltab2x12(:,:,379))
  call Hloop_VT_S(ntryL,G0H12(149),16,ex1(:),1,G1H12(83),m3h1x12(:,140),heltab2x12(:,:,380))
  call Hloop_ST_V(ntryL,G1H12(232),16,ex1(:),1,G2H12(43),m3h1x12(:,141),heltab2x12(:,:,381))
  call Hloop_ST_V(ntryL,G1H12(233),16,ex1(:),1,G2H12(44),m3h1x12(:,142),heltab2x12(:,:,382))
  call Hloop_VS_V(ntryL,G0H12(150),ex1(:),G0H12(28),m3h1x12(:,143),heltab2x12(:,:,383))
  call Hloop_SS_S(ntryL,G0H12(151),ex1(:),G0H12(29),m3h1x12(:,144),heltab2x12(:,:,384))
  call Hloop_VT_S(ntryL,G1H12(234),16,ex1(:),1,G2H12(45),m3h1x12(:,145),heltab2x12(:,:,385))
  call Hloop_ST_V(ntryL,G1H12(235),16,ex1(:),1,G2H12(46),m3h1x12(:,146),heltab2x12(:,:,386))
  call Hloop_VS_V(ntryL,G1H12(236),ex1(:),G1H12(84),m3h1x12(:,147),heltab2x12(:,:,387))
  call Hloop_VS_V(ntryL,G0H12(152),ex1(:),G0H12(30),m3h1x12(:,148),heltab2x12(:,:,388))
  call Hloop_VS_V(ntryL,G0H12(153),ex1(:),G0H12(31),m3h1x12(:,149),heltab2x12(:,:,389))
  call Hloop_VS_V(ntryL,G1H12(237),ex1(:),G1H12(85),m3h1x12(:,150),heltab2x12(:,:,390))
  call Hloop_VS_V(ntryL,G1H12(238),ex1(:),G1H12(86),m3h1x12(:,151),heltab2x12(:,:,391))
  call Hloop_VS_V(ntryL,G0H12(154),ex1(:),G0H12(32),m3h1x12(:,152),heltab2x12(:,:,392))
  call Hloop_AS_Q(ntryL,G1H12(239),ex1(:),G1H12(87),ngH,m3h1x12(:,153),heltab2x12(:,:,393))
  call Hloop_A_Q(ntryL,G1H12(87),17,nMB,G2H12(47),n2h12(43))
  call Hloop_QS_A(ntryL,G1H12(240),ex1(:),G1H12(88),ngH,m3h1x12(:,154),heltab2x12(:,:,394))
  call Hloop_Q_A(ntryL,G1H12(88),17,nMT,G2H12(48),n2h12(44))
  call Hloop_SS_S(ntryL,G1H12(241),ex1(:),G1H12(89),m3h1x12(:,155),heltab2x12(:,:,395))
  call Hloop_SS_S(ntryL,G1H12(242),ex1(:),G1H12(90),m3h1x12(:,156),heltab2x12(:,:,396))
  call Hloop_SS_S(ntryL,G1H12(243),ex1(:),G1H12(91),m3h1x12(:,157),heltab2x12(:,:,397))
  call Hloop_SS_S(ntryL,G1H12(244),ex1(:),G1H12(92),m3h1x12(:,158),heltab2x12(:,:,398))
  call Hloop_VS_V(ntryL,G1H12(245),ex1(:),G1H12(93),m3h1x12(:,159),heltab2x12(:,:,399))
  call Hloop_SS_S(ntryL,G1H12(246),ex1(:),G1H12(94),m3h1x12(:,160),heltab2x12(:,:,400))
  call Hloop_SS_S(ntryL,G0H12(155),ex1(:),G0H12(33),m3h1x12(:,161),heltab2x12(:,:,401))
  call Hloop_SS_S(ntryL,G1H12(247),ex1(:),G1H12(95),m3h1x12(:,162),heltab2x12(:,:,402))
  call Hloop_SS_S(ntryL,G1H12(248),ex1(:),G1H12(96),m3h1x12(:,163),heltab2x12(:,:,403))
  call Hloop_VT_S(ntryL,G0H12(156),16,ex1(:),1,G1H12(97),m3h1x12(:,164),heltab2x12(:,:,404))
  call Hloop_ST_V(ntryL,G1H12(249),16,ex1(:),1,G2H12(49),m3h1x12(:,165),heltab2x12(:,:,405))
  call Hloop_SS_S(ntryL,G0H12(157),ex1(:),G0H12(34),m3h1x12(:,166),heltab2x12(:,:,406))
  call Hloop_SS_S(ntryL,G1H12(250),ex1(:),G1H12(98),m3h1x12(:,167),heltab2x12(:,:,407))
  call Hloop_SS_S(ntryL,G0H12(158),ex1(:),G0H12(35),m3h1x12(:,168),heltab2x12(:,:,408))
  call Hloop_VT_S(ntryL,G1H12(251),16,ex1(:),1,G2H12(50),m3h1x12(:,169),heltab2x12(:,:,409))
  call Hloop_VT_S(ntryL,G0H12(159),16,ex1(:),1,G1H12(99),m3h1x12(:,170),heltab2x12(:,:,410))
  call Hloop_ST_V(ntryL,G1H12(252),16,ex1(:),1,G2H12(51),m3h1x12(:,171),heltab2x12(:,:,411))
  call Hloop_ST_V(ntryL,G1H12(253),16,ex1(:),1,G2H12(52),m3h1x12(:,172),heltab2x12(:,:,412))
  call Hloop_VS_V(ntryL,G0H12(160),ex1(:),G0H12(36),m3h1x12(:,173),heltab2x12(:,:,413))
  call Hloop_SS_S(ntryL,G0H12(161),ex1(:),G0H12(37),m3h1x12(:,174),heltab2x12(:,:,414))
  call Hloop_VT_S(ntryL,G1H12(254),16,ex1(:),1,G2H12(53),m3h1x12(:,175),heltab2x12(:,:,415))
  call Hloop_ST_V(ntryL,G1H12(255),16,ex1(:),1,G2H12(54),m3h1x12(:,176),heltab2x12(:,:,416))
  call Hloop_VS_V(ntryL,G0H12(162),ex1(:),G0H12(38),m3h1x12(:,177),heltab2x12(:,:,417))
  call Hloop_VS_V(ntryL,G1H12(256),ex1(:),G1H12(100),m3h1x12(:,178),heltab2x12(:,:,418))
  call Hloop_VS_V(ntryL,G0H12(163),ex1(:),G0H12(39),m3h1x12(:,179),heltab2x12(:,:,419))
  call Hloop_VS_V(ntryL,G1H12(257),ex1(:),G1H12(101),m3h1x12(:,180),heltab2x12(:,:,420))
  call Hloop_VS_V(ntryL,G0H12(164),ex1(:),G0H12(40),m3h1x12(:,181),heltab2x12(:,:,421))
  call Hloop_VS_V(ntryL,G1H12(258),ex1(:),G1H12(102),m3h1x12(:,182),heltab2x12(:,:,422))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(4),[G0H6(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(10),[G0H6(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(11),[G0H6(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(5),[G1H6(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(6),[G1H6(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(12),[G0H6(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(9),[G1H6(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(13),[G0H6(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(15),[G1H6(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(16),[G1H6(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(16),[G0H6(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(17),[G0H6(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(17),[G1H6(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(18),[G1H6(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(19),[G1H6(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(15),[G0H6(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(22),[G1H6(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(18),[G0H6(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(19),[G0H6(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(24),[G1H6(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(25),[G1H6(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(20),[G0H6(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(21),[G0H6(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(26),[G1H6(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(25),[G0H6(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(31),[G0H6(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(32),[G0H6(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(33),[G1H6(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(34),[G1H6(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(33),[G0H6(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(34),[G0H6(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(38),[G1H6(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(41),[G1H6(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(42),[G1H6(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(45),[G1H6(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(46),[G1H6(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(36),[G0H6(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(37),[G0H6(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(38),[G0H6(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(47),[G1H6(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(49),[G1H6(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(50),[G1H6(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(51),[G1H6(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(39),[G0H6(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(40),[G0H6(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(41),[G0H6(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(42),[G0H6(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(52),[G1H6(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(46),[G0H6(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(52),[G0H6(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(53),[G0H6(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(57),[G1H6(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(58),[G1H6(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(59),[G1H6(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(54),[G0H6(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(55),[G0H6(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(58),[G0H6(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(59),[G0H6(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(67),[G1H6(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(68),[G1H6(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(69),[G1H6(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(70),[G1H6(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(71),[G1H6(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(72),[G1H6(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(57),[G0H6(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(60),[G0H6(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(61),[G0H6(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(62),[G0H6(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(63),[G0H6(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(76),[G1H6(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(77),[G1H6(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(78),[G1H6(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(15),[G1H12(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(28),[G1H12(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(29),[G1H12(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(6),[G0H12(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(7),[G0H12(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(17),[G1H12(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(18),[G1H12(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(4),[G0H12(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(11),[G0H12(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(12),[G0H12(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(13),[G0H12(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(14),[G0H12(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(21),[G1H12(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(26),[G1H12(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(27),[G1H12(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(8),[G0H12(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(9),[G0H12(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(16),[G0H12(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(17),[G0H12(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(30),[G1H12(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(31),[G1H12(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(32),[G1H12(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(33),[G1H12(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(15),[G0H12(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(69),[G0H6(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(75),[G0H6(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(76),[G0H6(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(83),[G1H6(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(84),[G1H6(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(85),[G1H6(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(77),[G0H6(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(78),[G0H6(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(81),[G0H6(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(82),[G0H6(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(93),[G1H6(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(94),[G1H6(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(95),[G1H6(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(96),[G1H6(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(97),[G1H6(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(98),[G1H6(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(80),[G0H6(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(83),[G0H6(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(84),[G0H6(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(85),[G0H6(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(86),[G0H6(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(102),[G1H6(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(103),[G1H6(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(104),[G1H6(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(50),[G1H12(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(63),[G1H12(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(64),[G1H12(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(25),[G0H12(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(26),[G0H12(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(52),[G1H12(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(53),[G1H12(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(23),[G0H12(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(30),[G0H12(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(31),[G0H12(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(32),[G0H12(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(33),[G0H12(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(56),[G1H12(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(61),[G1H12(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(62),[G1H12(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(27),[G0H12(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(28),[G0H12(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(35),[G0H12(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(36),[G0H12(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(65),[G1H12(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(66),[G1H12(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(67),[G1H12(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(68),[G1H12(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(34),[G0H12(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(81),[G1H12(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(83),[G1H12(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(41),[G0H12(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(43),[G0H12(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(44),[G0H12(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(46),[G0H12(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(97),[G1H12(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(99),[G1H12(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(49),[G0H12(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(51),[G0H12(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(52),[G0H12(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H12(54),[G0H12(40)])
  call Hotf_5pt_reduction(G2H6(1),RedSet_5(1),mass5set(:,1),  & 
G1H6(105),G1H6(1),G1H6(2),G1H6(3),G1H6(7),G1H6(8),6)
  call HG1shiftOLR(G1H6(1),8,6)
  call Hotf_5pt_reduction(G2H6(2),RedSet_5(1),mass5set(:,2),  & 
G1H6(10),G1H6(11),G1H6(12),G1H6(13),G1H6(20),G1H6(21),6)
  call HG1shiftOLR(G1H6(11),8,6)
  call Hotf_5pt_reduction(G2H6(3),RedSet_5(1),mass5set(:,3),  & 
G1H6(23),G1H6(27),G1H6(28),G1H6(29),G1H6(31),G1H6(32),6)
  call HG1shiftOLR(G1H6(27),8,6)
  call Hloop_SS_S(ntryL,G2H6(4),ex1(:),G2H6(1),m3h1x6(:,1),heltab2x6(:,:,1))
  call Hloop_SS_S(ntryL,G2H6(5),ex1(:),G2H6(2),m3h1x6(:,2),heltab2x6(:,:,2))
  call Hloop_SS_S(ntryL,G2H6(6),ex1(:),G2H6(3),m3h1x6(:,3),heltab2x6(:,:,3))
  call Hloop_SS_S(ntryL,G2H6(7),ex1(:),G2H6(4),m3h1x6(:,4),heltab2x6(:,:,4))
  call Hloop_SS_S(ntryL,G2H6(8),ex1(:),G2H6(5),m3h1x6(:,5),heltab2x6(:,:,5))
  call Hloop_SS_S(ntryL,G2H6(9),ex1(:),G2H6(6),m3h1x6(:,6),heltab2x6(:,:,6))
  call Hloop_VS_V(ntryL,G2H6(10),ex1(:),G2H6(7),m3h1x6(:,7),heltab2x6(:,:,7))
  call Hloop_VS_V(ntryL,G2H6(11),ex1(:),G2H6(8),m3h1x6(:,8),heltab2x6(:,:,8))
  call Hloop_SS_S(ntryL,G1H6(5),ex1(:),G1H6(35),m3h1x6(:,9),heltab2x6(:,:,9))
  call Hloop_SS_S(ntryL,G1H6(6),ex1(:),G1H6(36),m3h1x6(:,10),heltab2x6(:,:,10))
  call Hloop_SS_S(ntryL,G2H6(12),ex1(:),G2H6(9),m3h1x6(:,11),heltab2x6(:,:,11))
  call Hloop_VT_S(ntryL,G1H6(9),20,ex1(:),1,G2H6(10),m3h1x6(:,12),heltab2x6(:,:,12))
  call Hloop_VT_S(ntryL,G1H6(4),20,ex1(:),1,G2H6(11),m3h1x6(:,13),heltab2x6(:,:,13))
  call Hotf_5pt_reduction(G2H6(13),RedSet_5(1),mass5set(:,4),  & 
G1H6(37),G1H6(39),G1H6(43),G1H6(44),G1H6(48),G1H6(53),6)
  call HG1shiftOLR(G1H6(39),8,6)
  call Hotf_5pt_reduction(G2H6(14),RedSet_5(1),mass5set(:,5),  & 
G1H6(54),G1H6(55),G1H6(60),G1H6(61),G1H6(62),G1H6(63),6)
  call HG1shiftOLR(G1H6(55),8,6)
  call Hloop_SS_S(ntryL,G1H6(15),ex1(:),G1H6(64),m3h1x6(:,14),heltab2x6(:,:,14))
  call Hloop_SS_S(ntryL,G1H6(16),ex1(:),G1H6(65),m3h1x6(:,15),heltab2x6(:,:,15))
  call Hotf_5pt_reduction(G2H6(16),RedSet_5(1),mass5set(:,6),  & 
G1H6(73),G1H6(74),G1H6(75),G1H6(79),G1H6(80),G1H6(81),6)
  call HG1shiftOLR(G1H6(74),8,6)
  call Hotf_5pt_reduction(G2H6(17),RedSet_5(1),mass5set(:,5),  & 
G1H6(86),G1H6(87),G1H6(88),G1H6(89),G1H6(90),G1H6(91),6)
  call HG1shiftOLR(G1H6(87),8,6)
  call Hloop_VT_S(ntryL,G1H6(17),20,ex1(:),1,G2H6(12),m3h1x6(:,16),heltab2x6(:,:,16))
  call Hloop_ST_V(ntryL,G1H6(18),20,ex1(:),1,G2H6(13),m3h1x6(:,17),heltab2x6(:,:,17))
  call Hloop_ST_V(ntryL,G1H6(19),20,ex1(:),1,G2H6(14),m3h1x6(:,18),heltab2x6(:,:,18))
  call Hotf_5pt_reduction(G2H6(15),RedSet_5(1),mass5set(:,4),  & 
G1H6(99),G1H6(100),G1H6(101),G1H6(5),G1H6(6),G1H6(9),6)
  call HG1shiftOLR(G1H6(100),8,6)
  call Hloop_VS_V(ntryL,G1H6(22),ex1(:),G1H6(4),m3h1x6(:,19),heltab2x6(:,:,19))
  call Hloop_VS_V(ntryL,G1H6(14),ex1(:),G1H6(15),m3h1x6(:,20),heltab2x6(:,:,20))
  call Hotf_5pt_reduction(G2H6(18),RedSet_5(1),mass5set(:,6),  & 
G1H6(16),G1H6(17),G1H6(18),G1H6(19),G1H6(22),G1H6(14),6)
  call HG1shiftOLR(G1H6(17),8,6)
  call Hotf_5pt_reduction(G2H6(19),RedSet_5(1),mass5set(:,5),  & 
G1H6(106),G1H6(107),G1H6(108),G1H6(109),G1H6(110),G1H6(111),6)
  call HG1shiftOLR(G1H6(107),8,6)
  call Hloop_ST_V(ntryL,G1H6(24),20,ex1(:),1,G2H6(16),m3h1x6(:,21),heltab2x6(:,:,21))
  call Hloop_ST_V(ntryL,G1H6(25),20,ex1(:),1,G2H6(17),m3h1x6(:,22),heltab2x6(:,:,22))
  call Hloop_VS_V(ntryL,G2H6(20),ex1(:),G2H6(15),m3h1x6(:,23),heltab2x6(:,:,23))
  call Hloop_VS_V(ntryL,G2H6(21),ex1(:),G2H6(18),m3h1x6(:,24),heltab2x6(:,:,24))
  call Hloop_VS_V(ntryL,G1H6(26),ex1(:),G1H6(24),m3h1x6(:,25),heltab2x6(:,:,25))
  call Hotf_5pt_reduction(G2H6(22),RedSet_5(2),mass5set(:,1),  & 
G1H6(25),G1H6(26),G1H6(112),G1H6(113),G1H6(114),G1H6(115),6)
  call HG1shiftOLR(G1H6(26),8,6)
  call Hotf_5pt_reduction(G2H6(23),RedSet_5(2),mass5set(:,2),  & 
G1H6(116),G1H6(117),G1H6(118),G1H6(119),G1H6(120),G1H6(121),6)
  call HG1shiftOLR(G1H6(117),8,6)
  call Hotf_5pt_reduction(G2H6(24),RedSet_5(2),mass5set(:,3),  & 
G1H6(122),G1H6(123),G1H6(124),G1H6(125),G1H6(126),G1H6(127),6)
  call HG1shiftOLR(G1H6(123),8,6)
  call Hloop_SS_S(ntryL,G2H6(25),ex1(:),G2H6(19),m3h1x6(:,26),heltab2x6(:,:,26))
  call Hloop_SS_S(ntryL,G2H6(26),ex1(:),G2H6(20),m3h1x6(:,27),heltab2x6(:,:,27))
  call Hloop_SS_S(ntryL,G2H6(27),ex1(:),G2H6(21),m3h1x6(:,28),heltab2x6(:,:,28))
  call Hloop_SS_S(ntryL,G2H6(28),ex1(:),G2H6(22),m3h1x6(:,29),heltab2x6(:,:,29))
  call Hloop_SS_S(ntryL,G2H6(29),ex1(:),G2H6(23),m3h1x6(:,30),heltab2x6(:,:,30))
  call Hloop_SS_S(ntryL,G2H6(30),ex1(:),G2H6(24),m3h1x6(:,31),heltab2x6(:,:,31))
  call Hloop_VS_V(ntryL,G2H6(31),ex1(:),G2H6(25),m3h1x6(:,32),heltab2x6(:,:,32))
  call Hloop_VS_V(ntryL,G2H6(32),ex1(:),G2H6(26),m3h1x6(:,33),heltab2x6(:,:,33))
  call Hloop_SS_S(ntryL,G1H6(33),ex1(:),G1H6(128),m3h1x6(:,34),heltab2x6(:,:,34))
  call Hloop_SS_S(ntryL,G1H6(34),ex1(:),G1H6(33),m3h1x6(:,35),heltab2x6(:,:,35))
  call Hloop_SS_S(ntryL,G2H6(33),ex1(:),G2H6(27),m3h1x6(:,36),heltab2x6(:,:,36))
  call Hotf_5pt_reduction(G2H6(34),RedSet_5(2),mass5set(:,4),  & 
G1H6(34),G1H6(129),G1H6(130),G1H6(131),G1H6(132),G1H6(133),6)
  call HG1shiftOLR(G1H6(129),8,6)
  call Hotf_5pt_reduction(G2H6(35),RedSet_5(2),mass5set(:,5),  & 
G1H6(134),G1H6(135),G1H6(136),G1H6(137),G1H6(138),G1H6(139),6)
  call HG1shiftOLR(G1H6(135),8,6)
  call Hloop_VT_S(ntryL,G1H6(38),18,ex1(:),1,G2H6(28),m3h1x6(:,37),heltab2x6(:,:,37))
  call Hloop_VT_S(ntryL,G1H6(30),18,ex1(:),1,G2H6(29),m3h1x6(:,38),heltab2x6(:,:,38))
  call Hloop_SS_S(ntryL,G1H6(41),ex1(:),G1H6(38),m3h1x6(:,39),heltab2x6(:,:,39))
  call Hloop_SS_S(ntryL,G1H6(42),ex1(:),G1H6(30),m3h1x6(:,40),heltab2x6(:,:,40))
  call Hloop_ST_V(ntryL,G1H6(45),18,ex1(:),1,G2H6(30),m3h1x6(:,41),heltab2x6(:,:,41))
  call Hloop_ST_V(ntryL,G1H6(46),18,ex1(:),1,G2H6(31),m3h1x6(:,42),heltab2x6(:,:,42))
  call Hotf_5pt_reduction(G2H6(36),RedSet_5(2),mass5set(:,4),  & 
G1H6(41),G1H6(42),G1H6(45),G1H6(46),G1H6(140),G1H6(141),6)
  call HG1shiftOLR(G1H6(42),8,6)
  call Hotf_5pt_reduction(G2H6(37),RedSet_5(2),mass5set(:,6),  & 
G1H6(142),G1H6(143),G1H6(144),G1H6(145),G1H6(146),G1H6(147),6)
  call HG1shiftOLR(G1H6(143),8,6)
  call Hotf_5pt_reduction(G2H6(38),RedSet_5(2),mass5set(:,5),  & 
G1H6(148),G1H6(149),G1H6(150),G1H6(151),G1H6(152),G1H6(153),6)
  call HG1shiftOLR(G1H6(149),8,6)
  call Hloop_VT_S(ntryL,G1H6(47),18,ex1(:),1,G2H6(32),m3h1x6(:,43),heltab2x6(:,:,43))
  call Hloop_VS_V(ntryL,G1H6(49),ex1(:),G1H6(47),m3h1x6(:,44),heltab2x6(:,:,44))
  call Hloop_VS_V(ntryL,G1H6(40),ex1(:),G1H6(49),m3h1x6(:,45),heltab2x6(:,:,45))
  call Hloop_ST_V(ntryL,G1H6(50),18,ex1(:),1,G2H6(33),m3h1x6(:,46),heltab2x6(:,:,46))
  call Hloop_ST_V(ntryL,G1H6(51),18,ex1(:),1,G2H6(34),m3h1x6(:,47),heltab2x6(:,:,47))
  call Hotf_5pt_reduction(G2H6(39),RedSet_5(2),mass5set(:,6),  & 
G1H6(40),G1H6(50),G1H6(51),G1H6(154),G1H6(155),G1H6(156),6)
  call HG1shiftOLR(G1H6(50),8,6)
  call Hotf_5pt_reduction(G2H6(40),RedSet_5(2),mass5set(:,5),  & 
G1H6(157),G1H6(158),G1H6(159),G1H6(160),G1H6(161),G1H6(162),6)
  call HG1shiftOLR(G1H6(158),8,6)
  call Hloop_VS_V(ntryL,G2H6(41),ex1(:),G2H6(35),m3h1x6(:,48),heltab2x6(:,:,48))
  call Hloop_VS_V(ntryL,G2H6(42),ex1(:),G2H6(36),m3h1x6(:,49),heltab2x6(:,:,49))
  call Hloop_VS_V(ntryL,G1H6(52),ex1(:),G1H6(163),m3h1x6(:,50),heltab2x6(:,:,50))
  call Hotf_5pt_reduction(G2H6(43),RedSet_5(3),mass5set(:,1),  & 
G1H6(52),G1H6(164),G1H6(165),G1H6(166),G1H6(167),G1H6(168),6)
  call HG1shiftOLR(G1H6(164),8,6)
  call Hotf_5pt_reduction(G2H6(44),RedSet_5(3),mass5set(:,2),  & 
G1H6(169),G1H6(170),G1H6(171),G1H6(172),G1H6(173),G1H6(174),6)
  call HG1shiftOLR(G1H6(170),8,6)
  call Hotf_5pt_reduction(G2H6(45),RedSet_5(3),mass5set(:,3),  & 
G1H6(175),G1H6(176),G1H6(177),G1H6(178),G1H6(179),G1H6(180),6)
  call HG1shiftOLR(G1H6(176),8,6)
  call Hotf_5pt_reduction(G2H6(46),RedSet_5(3),mass5set(:,4),  & 
G1H6(181),G1H6(182),G1H6(183),G1H6(184),G1H6(185),G1H6(186),6)
  call HG1shiftOLR(G1H6(182),8,6)
  call Hotf_5pt_reduction(G2H6(47),RedSet_5(3),mass5set(:,5),  & 
G1H6(187),G1H6(188),G1H6(189),G1H6(190),G1H6(191),G1H6(192),6)
  call HG1shiftOLR(G1H6(188),8,6)
  call Hotf_5pt_reduction(G2H6(48),RedSet_5(3),mass5set(:,6),  & 
G1H6(193),G1H6(194),G1H6(195),G1H6(196),G1H6(197),G1H6(198),6)
  call HG1shiftOLR(G1H6(194),8,6)
  call Hotf_5pt_reduction(G2H6(49),RedSet_5(3),mass5set(:,5),  & 
G1H6(199),G1H6(200),G1H6(201),G1H6(202),G1H6(203),G1H6(204),6)
  call HG1shiftOLR(G1H6(200),8,6)
  call Hotf_5pt_reduction(G2H6(50),RedSet_5(3),mass5set(:,6),  & 
G1H6(205),G1H6(206),G1H6(207),G1H6(208),G1H6(209),G1H6(210),6)
  call HG1shiftOLR(G1H6(206),8,6)
  call Hotf_5pt_reduction(G2H6(51),RedSet_5(3),mass5set(:,5),  & 
G1H6(211),G1H6(212),G1H6(213),G1H6(214),G1H6(215),G1H6(216),6)
  call HG1shiftOLR(G1H6(212),8,6)
  call Hotf_5pt_reduction(G2H6(52),RedSet_5(3),mass5set(:,6),  & 
G1H6(217),G1H6(218),G1H6(219),G1H6(220),G1H6(221),G1H6(222),6)
  call HG1shiftOLR(G1H6(218),8,6)
  call Hotf_5pt_reduction(G2H6(53),RedSet_5(3),mass5set(:,5),  & 
G1H6(223),G1H6(224),G1H6(225),G1H6(226),G1H6(227),G1H6(228),6)
  call HG1shiftOLR(G1H6(224),8,6)
  call Hloop_SV_T(ntryL,G1H6(57),20,ex2(:),2,G2H3(1),m3h2x3(:,1),heltab2x6(:,:,51))
  call Hloop_SV_T(ntryL,G1H6(58),20,ex2(:),2,G2H3(2),m3h2x3(:,2),heltab2x6(:,:,52))
  call Hloop_VV_S(ntryL,G1H6(59),ex2(:),G1H3(1),m3h2x3(:,3),heltab2x6(:,:,53))
  call Hloop_VV_S(ntryL,G1H6(56),ex2(:),G1H3(2),m3h2x3(:,4),heltab2x6(:,:,54))
  call Hotf_5pt_reduction(G2H6(54),RedSet_5(3),mass5set(:,4),  & 
G1H6(57),G1H6(58),G1H6(59),G1H6(56),G1H6(229),G1H6(230),6)
  call HG1shiftOLR(G1H6(58),8,6)
  call Hloop_SV_V(ntryL,G2H6(55),ex2(:),G2H3(3),m3h2x3(:,5),heltab2x6(:,:,55))
  call Hloop_SV_V(ntryL,G2H6(56),ex2(:),G2H3(4),m3h2x3(:,6),heltab2x6(:,:,56))
  call Hloop_VV_S(ntryL,G2H6(58),ex2(:),G2H3(5),m3h2x3(:,7),heltab2x6(:,:,57))
  call Hloop_VV_S(ntryL,G2H6(59),ex2(:),G2H3(6),m3h2x3(:,8),heltab2x6(:,:,58))
  call Hloop_SV_T(ntryL,G1H6(67),20,ex2(:),2,G2H3(7),m3h2x3(:,9),heltab2x6(:,:,59))
  call Hloop_SV_T(ntryL,G1H6(68),20,ex2(:),2,G2H3(8),m3h2x3(:,10),heltab2x6(:,:,60))
  call Hloop_VV_S(ntryL,G1H6(69),ex2(:),G1H3(3),m3h2x3(:,11),heltab2x6(:,:,61))
  call Hloop_SV_V(ntryL,G1H6(70),ex2(:),G1H3(4),m3h2x3(:,12),heltab2x6(:,:,62))
  call Hloop_SV_V(ntryL,G1H6(71),ex2(:),G1H3(5),m3h2x3(:,13),heltab2x6(:,:,63))
  call Hloop_UW_V(ntryL,G1H6(72),20,ex2(:),2,G2H3(9),m3h2x3(:,14),heltab2x6(:,:,64))
  call Hloop_UW_V(ntryL,G1H6(66),20,ex2(:),2,G2H3(10),m3h2x3(:,15),heltab2x6(:,:,65))
  call Hloop_SV_V(ntryL,G2H6(57),ex2(:),G2H3(11),m3h2x3(:,16),heltab2x6(:,:,66))
  call Hloop_VV_S(ntryL,G2H6(60),ex2(:),G2H3(12),m3h2x3(:,17),heltab2x6(:,:,67))
  call Hloop_VV_S(ntryL,G2H6(61),ex2(:),G2H3(13),m3h2x3(:,18),heltab2x6(:,:,68))
  call Hotf_5pt_reduction(G2H6(62),RedSet_5(3),mass5set(:,6),  & 
G1H6(67),G1H6(68),G1H6(69),G1H6(70),G1H6(71),G1H6(72),6)
  call HG1shiftOLR(G1H6(68),8,6)
  call Hotf_5pt_reduction(G2H6(63),RedSet_5(3),mass5set(:,5),  & 
G1H6(66),G1H6(231),G1H6(232),G1H6(233),G1H6(234),G1H6(235),6)
  call HG1shiftOLR(G1H6(231),8,6)
  call Hloop_SV_V(ntryL,G1H6(76),ex2(:),G1H3(6),m3h2x3(:,19),heltab2x6(:,:,69))
  call Hloop_SV_V(ntryL,G1H6(77),ex2(:),G1H3(7),m3h2x3(:,20),heltab2x6(:,:,70))
  call Hloop_UW_V(ntryL,G1H6(78),20,ex2(:),2,G2H3(14),m3h2x3(:,21),heltab2x6(:,:,71))
  call Hotf_5pt_reduction(G2H6(64),RedSet_5(4),mass5set(:,7),  & 
G1H6(76),G1H6(77),G1H6(78),G1H6(236),G1H6(237),G1H6(238),6)
  call HG1shiftOLR(G1H6(77),4,6)
  call Hotf_5pt_reduction(G2H6(65),RedSet_5(4),mass5set(:,8),  & 
G1H6(239),G1H6(240),G1H6(241),G1H6(242),G1H6(243),G1H6(244),6)
  call HG1shiftOLR(G1H6(240),4,6)
  call Hotf_5pt_reduction(G2H12(1),RedSet_5(5),mass5set(:,1),  & 
G1H12(103),G1H12(104),G1H12(105),G1H12(106),G1H12(107),G1H12(108),12)
  call HG1shiftOLR(G1H12(104),8,12)
  call Hotf_5pt_reduction(G2H12(2),RedSet_5(5),mass5set(:,2),  & 
G1H12(1),G1H12(109),G1H12(2),G1H12(110),G1H12(3),G1H12(111),12)
  call HG1shiftOLR(G1H12(109),8,12)
  call Hotf_5pt_reduction(G2H12(3),RedSet_5(5),mass5set(:,3),  & 
G1H12(112),G1H12(113),G1H12(114),G1H12(115),G1H12(116),G1H12(117),12)
  call HG1shiftOLR(G1H12(113),8,12)
  call Hloop_SV_T(ntryL,G1H12(15),17,ex2(:),2,G2H6(37),m3h2x6(:,241),heltab2x12(:,:,423))
  call Hloop_SV_T(ntryL,G1H12(5),17,ex2(:),2,G2H6(38),m3h2x6(:,242),heltab2x12(:,:,424))
  call Hloop_DV_C(ntryL,G1H12(6),17,ex2(:),G2H6(39),m3h2x6(:,243),heltab2x12(:,:,425))
  call Hloop_DV_C(ntryL,G1H12(7),17,ex2(:),G2H6(40),m3h2x6(:,244),heltab2x12(:,:,426))
  call Hloop_CV_D(ntryL,G1H12(8),17,ex2(:),2,G2H6(41),m3h2x6(:,245),heltab2x12(:,:,427))
  call Hloop_CV_D(ntryL,G1H12(9),17,ex2(:),2,G2H6(42),m3h2x6(:,246),heltab2x12(:,:,428))
  call Hloop_UW_V(ntryL,G1H12(28),17,ex2(:),2,G2H6(43),m3h2x6(:,247),heltab2x12(:,:,429))
  call Hloop_UW_V(ntryL,G1H12(29),17,ex2(:),2,G2H6(44),m3h2x6(:,248),heltab2x12(:,:,430))
  call Hotf_5pt_reduction(G2H12(6),RedSet_5(5),mass5set(:,6),  & 
G1H12(118),G1H12(119),G1H12(120),G1H12(121),G1H12(122),G1H12(123),12)
  call HG1shiftOLR(G1H12(119),8,12)
  call Hotf_5pt_reduction(G2H12(7),RedSet_5(5),mass5set(:,5),  & 
G1H12(124),G1H12(125),G1H12(126),G1H12(127),G1H12(128),G1H12(129),12)
  call HG1shiftOLR(G1H12(125),8,12)
  call Hloop_SV_T(ntryL,G1H12(17),17,ex2(:),2,G2H6(45),m3h2x6(:,249),heltab2x12(:,:,431))
  call Hloop_SV_V(ntryL,G1H12(18),ex2(:),G1H6(245),m3h2x6(:,250),heltab2x12(:,:,432))
  call Hloop_SV_V(ntryL,G1H12(14),ex2(:),G1H6(246),m3h2x6(:,251),heltab2x12(:,:,433))
  call Hloop_VV_S(ntryL,G2H12(4),ex2(:),G2H6(46),m3h2x6(:,252),heltab2x12(:,:,434))
  call Hloop_VV_S(ntryL,G2H12(5),ex2(:),G2H6(47),m3h2x6(:,253),heltab2x12(:,:,435))
  call Hotf_5pt_reduction(G2H12(11),RedSet_5(5),mass5set(:,6),  & 
G1H12(130),G1H12(131),G1H12(132),G1H12(133),G1H12(134),G1H12(135),12)
  call HG1shiftOLR(G1H12(131),8,12)
  call Hotf_5pt_reduction(G2H12(12),RedSet_5(5),mass5set(:,5),  & 
G1H12(136),G1H12(137),G1H12(138),G1H12(139),G1H12(140),G1H12(141),12)
  call HG1shiftOLR(G1H12(137),8,12)
  call Hloop_SV_V(ntryL,G2H12(13),ex2(:),G2H6(48),m3h2x6(:,254),heltab2x12(:,:,436))
  call Hloop_SV_V(ntryL,G2H12(14),ex2(:),G2H6(49),m3h2x6(:,255),heltab2x12(:,:,437))
  call Hloop_SV_V(ntryL,G1H12(21),ex2(:),G1H6(247),m3h2x6(:,256),heltab2x12(:,:,438))
  call Hloop_VV_S(ntryL,G1H12(26),ex2(:),G1H6(248),m3h2x6(:,257),heltab2x12(:,:,439))
  call Hloop_VV_S(ntryL,G1H12(27),ex2(:),G1H6(249),m3h2x6(:,258),heltab2x12(:,:,440))
  call Hloop_VV_S(ntryL,G2H12(8),ex2(:),G2H6(50),m3h2x6(:,259),heltab2x12(:,:,441))
  call Hotf_5pt_reduction(G2H12(9),RedSet_5(5),mass5set(:,4),  & 
G1H12(142),G1H12(143),G1H12(34),G1H12(144),G1H12(35),G1H12(145),12)
  call HG1shiftOLR(G1H12(143),8,12)
  call Hotf_5pt_reduction(G2H12(10),RedSet_5(5),mass5set(:,5),  & 
G1H12(146),G1H12(147),G1H12(148),G1H12(149),G1H12(150),G1H12(151),12)
  call HG1shiftOLR(G1H12(147),8,12)
  call Hloop_SV_V(ntryL,G2H12(16),ex2(:),G2H6(51),m3h2x6(:,260),heltab2x12(:,:,442))
  call Hloop_SV_V(ntryL,G2H12(17),ex2(:),G2H6(52),m3h2x6(:,261),heltab2x12(:,:,443))
  call Hloop_VV_S(ntryL,G1H12(30),ex2(:),G1H6(250),m3h2x6(:,262),heltab2x12(:,:,444))
  call Hloop_VV_S(ntryL,G1H12(31),ex2(:),G1H6(251),m3h2x6(:,263),heltab2x12(:,:,445))
  call Hloop_UW_V(ntryL,G1H12(32),17,ex2(:),2,G2H6(53),m3h2x6(:,264),heltab2x12(:,:,446))
  call Hloop_UW_V(ntryL,G1H12(33),17,ex2(:),2,G2H6(54),m3h2x6(:,265),heltab2x12(:,:,447))
  call Hotf_5pt_reduction(G2H12(15),RedSet_5(5),mass5set(:,4),  & 
G1H12(152),G1H12(153),G1H12(154),G1H12(155),G1H12(156),G1H12(157),12)
  call HG1shiftOLR(G1H12(153),8,12)
  call Hotf_5pt_reduction(G2H12(18),RedSet_5(6),mass5set(:,7),  & 
G1H12(158),G1H12(159),G1H12(160),G1H12(161),G1H12(162),G1H12(163),12)
  call HG1shiftOLR(G1H12(159),4,12)
  call Hotf_5pt_reduction(G2H12(19),RedSet_5(6),mass5set(:,8),  & 
G1H12(164),G1H12(165),G1H12(166),G1H12(167),G1H12(168),G1H12(169),12)
  call HG1shiftOLR(G1H12(165),4,12)
  call Hotf_5pt_reduction(G2H6(66),RedSet_5(7),mass5set(:,1),  & 
G1H6(252),G1H6(253),G1H6(254),G1H6(255),G1H6(256),G1H6(257),6)
  call HG1shiftOLR(G1H6(253),8,6)
  call Hotf_5pt_reduction(G2H6(67),RedSet_5(7),mass5set(:,2),  & 
G1H6(258),G1H6(259),G1H6(260),G1H6(261),G1H6(262),G1H6(263),6)
  call HG1shiftOLR(G1H6(259),8,6)
  call Hotf_5pt_reduction(G2H6(68),RedSet_5(7),mass5set(:,3),  & 
G1H6(264),G1H6(265),G1H6(266),G1H6(267),G1H6(268),G1H6(269),6)
  call HG1shiftOLR(G1H6(265),8,6)
  call Hotf_5pt_reduction(G2H6(69),RedSet_5(7),mass5set(:,4),  & 
G1H6(270),G1H6(271),G1H6(272),G1H6(273),G1H6(274),G1H6(275),6)
  call HG1shiftOLR(G1H6(271),8,6)
  call Hotf_5pt_reduction(G2H6(70),RedSet_5(7),mass5set(:,5),  & 
G1H6(276),G1H6(277),G1H6(278),G1H6(279),G1H6(280),G1H6(281),6)
  call HG1shiftOLR(G1H6(277),8,6)
  call Hotf_5pt_reduction(G2H6(71),RedSet_5(7),mass5set(:,6),  & 
G1H6(282),G1H6(283),G1H6(284),G1H6(285),G1H6(286),G1H6(287),6)
  call HG1shiftOLR(G1H6(283),8,6)
  call Hotf_5pt_reduction(G2H6(72),RedSet_5(7),mass5set(:,5),  & 
G1H6(288),G1H6(289),G1H6(290),G1H6(291),G1H6(292),G1H6(293),6)
  call HG1shiftOLR(G1H6(289),8,6)
  call Hotf_5pt_reduction(G2H6(73),RedSet_5(7),mass5set(:,6),  & 
G1H6(294),G1H6(295),G1H6(296),G1H6(297),G1H6(298),G1H6(299),6)
  call HG1shiftOLR(G1H6(295),8,6)
  call Hotf_5pt_reduction(G2H6(74),RedSet_5(7),mass5set(:,5),  & 
G1H6(300),G1H6(301),G1H6(302),G1H6(303),G1H6(304),G1H6(305),6)
  call HG1shiftOLR(G1H6(301),8,6)
  call Hotf_5pt_reduction(G2H6(75),RedSet_5(7),mass5set(:,6),  & 
G1H6(306),G1H6(307),G1H6(308),G1H6(309),G1H6(310),G1H6(311),6)
  call HG1shiftOLR(G1H6(307),8,6)
  call Hotf_5pt_reduction(G2H6(76),RedSet_5(7),mass5set(:,5),  & 
G1H6(312),G1H6(313),G1H6(314),G1H6(315),G1H6(316),G1H6(317),6)
  call HG1shiftOLR(G1H6(313),8,6)
  call Hloop_SV_T(ntryL,G1H6(83),18,ex3(:),4,G2H3(15),m3h2x3(:,22),heltab2x6(:,:,72))
  call Hloop_SV_T(ntryL,G1H6(84),18,ex3(:),4,G2H3(16),m3h2x3(:,23),heltab2x6(:,:,73))
  call Hloop_VV_S(ntryL,G1H6(85),ex3(:),G1H3(8),m3h2x3(:,24),heltab2x6(:,:,74))
  call Hloop_VV_S(ntryL,G1H6(82),ex3(:),G1H3(9),m3h2x3(:,25),heltab2x6(:,:,75))
  call Hotf_5pt_reduction(G2H6(77),RedSet_5(7),mass5set(:,4),  & 
G1H6(83),G1H6(84),G1H6(85),G1H6(82),G1H6(318),G1H6(319),6)
  call HG1shiftOLR(G1H6(84),8,6)
  call Hloop_SV_V(ntryL,G2H6(78),ex3(:),G2H3(17),m3h2x3(:,26),heltab2x6(:,:,76))
  call Hloop_SV_V(ntryL,G2H6(79),ex3(:),G2H3(18),m3h2x3(:,27),heltab2x6(:,:,77))
  call Hloop_VV_S(ntryL,G2H6(81),ex3(:),G2H3(19),m3h2x3(:,28),heltab2x6(:,:,78))
  call Hloop_VV_S(ntryL,G2H6(82),ex3(:),G2H3(20),m3h2x3(:,29),heltab2x6(:,:,79))
  call Hloop_SV_T(ntryL,G1H6(93),18,ex3(:),4,G2H3(21),m3h2x3(:,30),heltab2x6(:,:,80))
  call Hloop_SV_T(ntryL,G1H6(94),18,ex3(:),4,G2H3(22),m3h2x3(:,31),heltab2x6(:,:,81))
  call Hloop_VV_S(ntryL,G1H6(95),ex3(:),G1H3(10),m3h2x3(:,32),heltab2x6(:,:,82))
  call Hloop_SV_V(ntryL,G1H6(96),ex3(:),G1H3(11),m3h2x3(:,33),heltab2x6(:,:,83))
  call Hloop_SV_V(ntryL,G1H6(97),ex3(:),G1H3(12),m3h2x3(:,34),heltab2x6(:,:,84))
  call Hloop_UW_V(ntryL,G1H6(98),18,ex3(:),4,G2H3(23),m3h2x3(:,35),heltab2x6(:,:,85))
  call Hloop_UW_V(ntryL,G1H6(92),18,ex3(:),4,G2H3(24),m3h2x3(:,36),heltab2x6(:,:,86))
  call Hloop_SV_V(ntryL,G2H6(80),ex3(:),G2H3(25),m3h2x3(:,37),heltab2x6(:,:,87))
  call Hloop_VV_S(ntryL,G2H6(83),ex3(:),G2H3(26),m3h2x3(:,38),heltab2x6(:,:,88))
  call Hloop_VV_S(ntryL,G2H6(84),ex3(:),G2H3(27),m3h2x3(:,39),heltab2x6(:,:,89))
  call Hotf_5pt_reduction(G2H6(85),RedSet_5(7),mass5set(:,6),  & 
G1H6(93),G1H6(94),G1H6(95),G1H6(96),G1H6(97),G1H6(98),6)
  call HG1shiftOLR(G1H6(94),8,6)
  call Hotf_5pt_reduction(G2H6(86),RedSet_5(7),mass5set(:,5),  & 
G1H6(92),G1H6(320),G1H6(321),G1H6(322),G1H6(323),G1H6(324),6)
  call HG1shiftOLR(G1H6(320),8,6)
  call Hloop_SV_V(ntryL,G1H6(102),ex3(:),G1H3(13),m3h2x3(:,40),heltab2x6(:,:,90))
  call Hloop_SV_V(ntryL,G1H6(103),ex3(:),G1H3(14),m3h2x3(:,41),heltab2x6(:,:,91))
  call Hloop_UW_V(ntryL,G1H6(104),18,ex3(:),4,G2H3(28),m3h2x3(:,42),heltab2x6(:,:,92))
  call Hotf_5pt_reduction(G2H6(87),RedSet_5(8),mass5set(:,9),  & 
G1H6(102),G1H6(103),G1H6(104),G1H6(325),G1H6(326),G1H6(327),6)
  call HG1shiftOLR(G1H6(103),4,6)
  call Hotf_5pt_reduction(G2H6(88),RedSet_5(8),mass5set(:,10),  & 
G1H6(328),G1H6(329),G1H6(330),G1H6(331),G1H6(332),G1H6(333),6)
  call HG1shiftOLR(G1H6(329),4,6)
  call Hotf_5pt_reduction(G2H12(20),RedSet_5(9),mass5set(:,1),  & 
G1H12(170),G1H12(171),G1H12(172),G1H12(173),G1H12(174),G1H12(175),12)
  call HG1shiftOLR(G1H12(171),8,12)
  call Hotf_5pt_reduction(G2H12(21),RedSet_5(9),mass5set(:,2),  & 
G1H12(176),G1H12(177),G1H12(178),G1H12(179),G1H12(180),G1H12(181),12)
  call HG1shiftOLR(G1H12(177),8,12)
  call Hotf_5pt_reduction(G2H12(22),RedSet_5(9),mass5set(:,3),  & 
G1H12(182),G1H12(36),G1H12(183),G1H12(37),G1H12(184),G1H12(38),12)
  call HG1shiftOLR(G1H12(36),8,12)
  call Hloop_SV_T(ntryL,G1H12(50),17,ex3(:),4,G2H6(55),m3h2x6(:,266),heltab2x12(:,:,448))
  call Hloop_SV_T(ntryL,G1H12(40),17,ex3(:),4,G2H6(56),m3h2x6(:,267),heltab2x12(:,:,449))
  call Hloop_DV_C(ntryL,G1H12(41),17,ex3(:),G2H6(58),m3h2x6(:,268),heltab2x12(:,:,450))
  call Hloop_DV_C(ntryL,G1H12(42),17,ex3(:),G2H6(59),m3h2x6(:,269),heltab2x12(:,:,451))
  call Hloop_CV_D(ntryL,G1H12(43),17,ex3(:),4,G2H6(57),m3h2x6(:,270),heltab2x12(:,:,452))
  call Hloop_CV_D(ntryL,G1H12(44),17,ex3(:),4,G2H6(60),m3h2x6(:,271),heltab2x12(:,:,453))
  call Hloop_UW_V(ntryL,G1H12(63),17,ex3(:),4,G2H6(61),m3h2x6(:,272),heltab2x12(:,:,454))
  call Hloop_UW_V(ntryL,G1H12(64),17,ex3(:),4,G2H6(62),m3h2x6(:,273),heltab2x12(:,:,455))
  call Hotf_5pt_reduction(G2H12(25),RedSet_5(9),mass5set(:,6),  & 
G1H12(185),G1H12(186),G1H12(187),G1H12(188),G1H12(189),G1H12(190),12)
  call HG1shiftOLR(G1H12(186),8,12)
  call Hotf_5pt_reduction(G2H12(26),RedSet_5(9),mass5set(:,5),  & 
G1H12(191),G1H12(192),G1H12(193),G1H12(194),G1H12(195),G1H12(196),12)
  call HG1shiftOLR(G1H12(192),8,12)
  call Hloop_SV_T(ntryL,G1H12(52),17,ex3(:),4,G2H6(63),m3h2x6(:,274),heltab2x12(:,:,456))
  call Hloop_SV_V(ntryL,G1H12(53),ex3(:),G1H6(334),m3h2x6(:,275),heltab2x12(:,:,457))
  call Hloop_SV_V(ntryL,G1H12(49),ex3(:),G1H6(335),m3h2x6(:,276),heltab2x12(:,:,458))
  call Hloop_VV_S(ntryL,G2H12(23),ex3(:),G2H6(64),m3h2x6(:,277),heltab2x12(:,:,459))
  call Hloop_VV_S(ntryL,G2H12(24),ex3(:),G2H6(65),m3h2x6(:,278),heltab2x12(:,:,460))
  call Hotf_5pt_reduction(G2H12(30),RedSet_5(9),mass5set(:,6),  & 
G1H12(197),G1H12(198),G1H12(199),G1H12(200),G1H12(201),G1H12(202),12)
  call HG1shiftOLR(G1H12(198),8,12)
  call Hotf_5pt_reduction(G2H12(31),RedSet_5(9),mass5set(:,5),  & 
G1H12(203),G1H12(204),G1H12(205),G1H12(206),G1H12(207),G1H12(208),12)
  call HG1shiftOLR(G1H12(204),8,12)
  call Hloop_SV_V(ntryL,G2H12(32),ex3(:),G2H6(66),m3h2x6(:,279),heltab2x12(:,:,461))
  call Hloop_SV_V(ntryL,G2H12(33),ex3(:),G2H6(67),m3h2x6(:,280),heltab2x12(:,:,462))
  call Hloop_SV_V(ntryL,G1H12(56),ex3(:),G1H6(336),m3h2x6(:,281),heltab2x12(:,:,463))
  call Hloop_VV_S(ntryL,G1H12(61),ex3(:),G1H6(337),m3h2x6(:,282),heltab2x12(:,:,464))
  call Hloop_VV_S(ntryL,G1H12(62),ex3(:),G1H6(338),m3h2x6(:,283),heltab2x12(:,:,465))
  call Hloop_VV_S(ntryL,G2H12(27),ex3(:),G2H6(68),m3h2x6(:,284),heltab2x12(:,:,466))
  call Hotf_5pt_reduction(G2H12(28),RedSet_5(9),mass5set(:,4),  & 
G1H12(209),G1H12(210),G1H12(211),G1H12(212),G1H12(213),G1H12(214),12)
  call HG1shiftOLR(G1H12(210),8,12)
  call Hotf_5pt_reduction(G2H12(29),RedSet_5(9),mass5set(:,5),  & 
G1H12(215),G1H12(216),G1H12(217),G1H12(69),G1H12(218),G1H12(70),12)
  call HG1shiftOLR(G1H12(216),8,12)
  call Hloop_SV_V(ntryL,G2H12(35),ex3(:),G2H6(69),m3h2x6(:,285),heltab2x12(:,:,467))
  call Hloop_SV_V(ntryL,G2H12(36),ex3(:),G2H6(70),m3h2x6(:,286),heltab2x12(:,:,468))
  call Hloop_VV_S(ntryL,G1H12(65),ex3(:),G1H6(339),m3h2x6(:,287),heltab2x12(:,:,469))
  call Hloop_VV_S(ntryL,G1H12(66),ex3(:),G1H6(340),m3h2x6(:,288),heltab2x12(:,:,470))
  call Hloop_UW_V(ntryL,G1H12(67),17,ex3(:),4,G2H6(71),m3h2x6(:,289),heltab2x12(:,:,471))
  call Hloop_UW_V(ntryL,G1H12(68),17,ex3(:),4,G2H6(72),m3h2x6(:,290),heltab2x12(:,:,472))
  call Hotf_5pt_reduction(G2H12(34),RedSet_5(9),mass5set(:,4),  & 
G1H12(219),G1H12(71),G1H12(220),G1H12(72),G1H12(221),G1H12(222),12)
  call HG1shiftOLR(G1H12(71),8,12)
  call Hotf_5pt_reduction(G2H12(37),RedSet_5(10),mass5set(:,7),  & 
G1H12(223),G1H12(224),G1H12(225),G1H12(226),G1H12(227),G1H12(228),12)
  call HG1shiftOLR(G1H12(224),2,12)
  call Hotf_5pt_reduction(G2H12(38),RedSet_5(10),mass5set(:,8),  & 
G1H12(229),G1H12(230),G1H12(231),G1H12(232),G1H12(233),G1H12(234),12)
  call HG1shiftOLR(G1H12(230),2,12)
  call Hotf_5pt_reduction(G2H12(39),RedSet_5(11),mass5set(:,9),  & 
G1H12(235),G1H12(236),G1H12(237),G1H12(238),G1H12(239),G1H12(87),12)
  call HG1shiftOLR(G1H12(236),4,12)
  call Hotf_5pt_reduction(G2H12(40),RedSet_5(11),mass5set(:,10),  & 
G1H12(240),G1H12(88),G1H12(241),G1H12(242),G1H12(243),G1H12(244),12)
  call HG1shiftOLR(G1H12(88),4,12)
  call Hloop_TV_S(ntryL,G1H12(73),17,ex4(:),8,G2H4(1),m3h3x4(:,1),heltab2x12(:,:,473))
  call Hloop_TV_S(ntryL,G1H12(81),17,ex4(:),8,G2H4(2),m3h3x4(:,2),heltab2x12(:,:,474))
  call Hloop_CV_D(ntryL,G1H12(75),17,ex4(:),8,G2H4(3),m3h3x4(:,3),heltab2x12(:,:,475))
  call Hloop_DV_C(ntryL,G1H12(76),17,ex4(:),G2H4(4),m3h3x4(:,4),heltab2x12(:,:,476))
  call Hloop_UW_V(ntryL,G1H12(77),17,ex4(:),8,G2H4(5),m3h3x4(:,5),heltab2x12(:,:,477))
  call Hloop_TV_S(ntryL,G0H12(25),17,ex4(:),8,G1H4(1),m3h3x4(:,6),heltab2x12(:,:,478))
  call Hloop_SV_V(ntryL,G1H12(78),ex4(:),G1H4(2),m3h3x4(:,7),heltab2x12(:,:,479))
  call Hloop_TV_S(ntryL,G1H12(79),17,ex4(:),8,G2H4(6),m3h3x4(:,8),heltab2x12(:,:,480))
  call Hloop_TV_S(ntryL,G1H12(83),17,ex4(:),8,G2H4(7),m3h3x4(:,9),heltab2x12(:,:,481))
  call Hloop_VV_S(ntryL,G2H12(41),ex4(:),G2H4(8),m3h3x4(:,10),heltab2x12(:,:,482))
  call Hloop_SV_V(ntryL,G0H12(26),ex4(:),G0H4(1),m3h3x4(:,11),heltab2x12(:,:,483))
  call Hloop_TV_S(ntryL,G0H12(27),17,ex4(:),8,G1H4(3),m3h3x4(:,12),heltab2x12(:,:,484))
  call Hloop_SV_V(ntryL,G1H12(82),ex4(:),G1H4(4),m3h3x4(:,13),heltab2x12(:,:,485))
  call Hotf_5pt_reduction(G2H12(42),RedSet_5(11),mass5set(:,11),  & 
G1H12(245),G1H12(246),G1H12(247),G1H12(248),G1H12(249),G1H12(250),12)
  call HG1shiftOLR(G1H12(246),4,12)
  call Hotf_5pt_reduction(G2H12(43),RedSet_5(11),mass5set(:,11),  & 
G1H12(251),G1H12(252),G1H12(253),G1H12(254),G1H12(255),G1H12(256),12)
  call HG1shiftOLR(G1H12(252),4,12)
  call Hloop_VV_S(ntryL,G2H12(44),ex4(:),G2H4(9),m3h3x4(:,14),heltab2x12(:,:,486))
  call Hloop_SV_V(ntryL,G0H12(29),ex4(:),G0H4(2),m3h3x4(:,15),heltab2x12(:,:,487))
  call Hotf_5pt_reduction(G2H12(45),RedSet_5(11),mass5set(:,11),  & 
G1H12(257),G1H12(258),G1H12(4),G1H12(10),G1H12(11),G1H12(12),12)
  call HG1shiftOLR(G1H12(258),4,12)
  call Hotf_5pt_reduction(G2H12(46),RedSet_5(11),mass5set(:,11),  & 
G1H12(13),G1H12(16),G1H12(19),G1H12(20),G1H12(22),G1H12(23),12)
  call HG1shiftOLR(G1H12(16),4,12)
  call Hloop_VV_S(ntryL,G1H12(84),ex4(:),G1H4(5),m3h3x4(:,16),heltab2x12(:,:,488))
  call Hloop_UW_V(ntryL,G1H12(85),17,ex4(:),8,G2H4(10),m3h3x4(:,17),heltab2x12(:,:,489))
  call Hloop_VV_S(ntryL,G1H12(86),ex4(:),G1H4(6),m3h3x4(:,18),heltab2x12(:,:,490))
  call Hotf_5pt_reduction(G2H12(47),RedSet_5(12),mass5set(:,9),  & 
G1H12(24),G1H12(25),G1H12(39),G1H12(45),G1H12(46),G1H12(47),12)
  call HG1shiftOLR(G1H12(25),2,12)
  call Hotf_5pt_reduction(G2H12(48),RedSet_5(12),mass5set(:,10),  & 
G1H12(48),G1H12(51),G1H12(54),G1H12(55),G1H12(57),G1H12(58),12)
  call HG1shiftOLR(G1H12(51),2,12)
  call Hloop_TV_S(ntryL,G1H12(89),17,ex4(:),8,G2H4(11),m3h3x4(:,19),heltab2x12(:,:,491))
  call Hloop_TV_S(ntryL,G1H12(97),17,ex4(:),8,G2H4(12),m3h3x4(:,20),heltab2x12(:,:,492))
  call Hloop_CV_D(ntryL,G1H12(91),17,ex4(:),8,G2H4(13),m3h3x4(:,21),heltab2x12(:,:,493))
  call Hloop_DV_C(ntryL,G1H12(92),17,ex4(:),G2H4(14),m3h3x4(:,22),heltab2x12(:,:,494))
  call Hloop_UW_V(ntryL,G1H12(93),17,ex4(:),8,G2H4(15),m3h3x4(:,23),heltab2x12(:,:,495))
  call Hloop_SV_V(ntryL,G1H12(94),ex4(:),G1H4(7),m3h3x4(:,24),heltab2x12(:,:,496))
  call Hloop_TV_S(ntryL,G0H12(33),17,ex4(:),8,G1H4(8),m3h3x4(:,25),heltab2x12(:,:,497))
  call Hloop_TV_S(ntryL,G1H12(95),17,ex4(:),8,G2H4(16),m3h3x4(:,26),heltab2x12(:,:,498))
  call Hloop_TV_S(ntryL,G1H12(99),17,ex4(:),8,G2H4(17),m3h3x4(:,27),heltab2x12(:,:,499))
  call Hloop_VV_S(ntryL,G2H12(49),ex4(:),G2H4(18),m3h3x4(:,28),heltab2x12(:,:,500))
  call Hloop_SV_V(ntryL,G0H12(34),ex4(:),G0H4(3),m3h3x4(:,29),heltab2x12(:,:,501))
  call Hloop_SV_V(ntryL,G1H12(98),ex4(:),G1H4(9),m3h3x4(:,30),heltab2x12(:,:,502))
  call Hloop_TV_S(ntryL,G0H12(35),17,ex4(:),8,G1H4(10),m3h3x4(:,31),heltab2x12(:,:,503))
  call Hotf_5pt_reduction(G2H12(50),RedSet_5(12),mass5set(:,11),  & 
G1H12(59),G1H12(60),G1H12(74),G1H12(80),G1H12(90),G1H12(96),12)
  call HG1shiftOLR(G1H12(60),2,12)
  call Hotf_5pt_reduction(G2H12(51),RedSet_5(12),mass5set(:,11),  & 
G1H12(15),G1H12(5),G1H12(6),G1H12(7),G1H12(8),G1H12(9),12)
  call HG1shiftOLR(G1H12(5),2,12)
  call Hloop_VV_S(ntryL,G2H12(52),ex4(:),G2H4(19),m3h3x4(:,32),heltab2x12(:,:,504))
  call Hloop_SV_V(ntryL,G0H12(37),ex4(:),G0H4(4),m3h3x4(:,33),heltab2x12(:,:,505))
  call Hotf_5pt_reduction(G2H12(53),RedSet_5(12),mass5set(:,11),  & 
G1H12(28),G1H12(29),G1H12(17),G1H12(18),G1H12(14),G1H12(21),12)
  call HG1shiftOLR(G1H12(29),2,12)
  call Hotf_5pt_reduction(G2H12(54),RedSet_5(12),mass5set(:,11),  & 
G1H12(26),G1H12(27),G1H12(30),G1H12(31),G1H12(32),G1H12(33),12)
  call HG1shiftOLR(G1H12(27),2,12)
  call Hloop_VV_S(ntryL,G1H12(100),ex4(:),G1H4(11),m3h3x4(:,34),heltab2x12(:,:,506))
  call Hloop_UW_V(ntryL,G1H12(101),17,ex4(:),8,G2H4(20),m3h3x4(:,35),heltab2x12(:,:,507))
  call Hloop_VV_S(ntryL,G1H12(102),ex4(:),G1H4(12),m3h3x4(:,36),heltab2x12(:,:,508))
  call Hloop_AS_Q(ntryL,G1H6(105),ex1(:),G1H6(341),ngH,m3h1x6(:,51),heltab2x6(:,:,93))
  call Hloop_A_Q(ntryL,G1H6(341),21,nML,G2H6(73),n2h6(17))
call HGT_OLR(G1H6(1),1,1,6)
call HGT_invQ_OLR(G1H6(1),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(1),-8,0,G2H6(74),n2h6(18))
  call Hloop_QW_A(ntryL,G2H6(74),ex4(:),G2H2(1),m3h3x2(:,1),heltab2x6(:,:,94))
  call Hloop_AS_Q(ntryL,G1H6(3),ex1(:),G1H6(105),ngH,m3h1x6(:,52),heltab2x6(:,:,95))
  call Hloop_A_Q(ntryL,G1H6(105),21,nML,G2H6(75),n2h6(19))
  call Hloop_AS_Q(ntryL,G1H6(7),ex1(:),G1H6(341),ngH,m3h1x6(:,53),heltab2x6(:,:,96))
  call Hloop_A_Q(ntryL,G1H6(341),21,nML,G2H6(76),n2h6(20))
  call Hloop_AS_Q(ntryL,G1H6(8),ex1(:),G1H6(1),ngH,m3h1x6(:,54),heltab2x6(:,:,97))
  call Hloop_A_Q(ntryL,G1H6(1),21,nML,G2H6(77),n2h6(21))
  call Hloop_QS_A(ntryL,G1H6(10),ex1(:),G1H6(3),ngH,m3h1x6(:,55),heltab2x6(:,:,98))
  call Hloop_Q_A(ntryL,G1H6(3),21,nMT,G2H6(78),n2h6(22))
call HGT_OLR(G1H6(11),1,1,6)
call HGT_invQ_OLR(G1H6(11),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(11),-8,nMB,G2H6(79),n2h6(23))
  call Hloop_AW_Q(ntryL,G2H6(79),ex4(:),G2H2(2),m3h3x2(:,2),heltab2x6(:,:,99))
  call Hloop_QS_A(ntryL,G1H6(13),ex1(:),G1H6(105),ngH,m3h1x6(:,56),heltab2x6(:,:,100))
  call Hloop_Q_A(ntryL,G1H6(105),21,nMT,G2H6(81),n2h6(24))
  call Hloop_QS_A(ntryL,G1H6(20),ex1(:),G1H6(7),ngH,m3h1x6(:,57),heltab2x6(:,:,101))
  call Hloop_Q_A(ntryL,G1H6(7),21,nMT,G2H6(82),n2h6(25))
  call Hloop_QS_A(ntryL,G1H6(21),ex1(:),G1H6(341),ngH,m3h1x6(:,58),heltab2x6(:,:,102))
  call Hloop_Q_A(ntryL,G1H6(341),21,nMT,G2H6(80),n2h6(26))
  call Hloop_AS_Q(ntryL,G1H6(23),ex1(:),G1H6(8),ngH,m3h1x6(:,59),heltab2x6(:,:,103))
  call Hloop_A_Q(ntryL,G1H6(8),21,nMB,G2H6(83),n2h6(27))
call HGT_OLR(G1H6(27),1,1,6)
call HGT_invQ_OLR(G1H6(27),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(27),-8,nMT,G2H6(84),n2h6(28))
  call Hloop_QW_A(ntryL,G2H6(84),ex4(:),G2H2(3),m3h3x2(:,3),heltab2x6(:,:,104))
  call Hloop_AS_Q(ntryL,G1H6(29),ex1(:),G1H6(1),ngH,m3h1x6(:,60),heltab2x6(:,:,105))
  call Hloop_A_Q(ntryL,G1H6(1),21,nMB,G2H6(85),n2h6(29))
  call Hloop_AS_Q(ntryL,G1H6(31),ex1(:),G1H6(10),ngH,m3h1x6(:,61),heltab2x6(:,:,106))
  call Hloop_A_Q(ntryL,G1H6(10),21,nMB,G2H6(86),n2h6(30))
  call Hloop_AS_Q(ntryL,G1H6(32),ex1(:),G1H6(3),ngH,m3h1x6(:,62),heltab2x6(:,:,107))
  call Hloop_A_Q(ntryL,G1H6(3),21,nMB,G2H6(87),n2h6(31))
  call Hloop_ST_V(ntryL,G1H6(37),20,ex1(:),1,G2H6(88),m3h1x6(:,63),heltab2x6(:,:,108))
call HGT_OLR(G1H6(39),1,1,6)
call HGT_invQ_OLR(G1H6(39),2,5,6)
  call Hloop_TV_S(ntryL,G1H6(39),-8,ex4(:),8,G2H2(4),m3h3x2(:,4),heltab2x6(:,:,109))
  call Hloop_ST_V(ntryL,G1H6(44),20,ex1(:),1,G2H6(74),m3h1x6(:,64),heltab2x6(:,:,110))
  call Hloop_ST_V(ntryL,G1H6(48),20,ex1(:),1,G2H6(79),m3h1x6(:,65),heltab2x6(:,:,111))
  call Hloop_ST_V(ntryL,G1H6(53),20,ex1(:),1,G2H6(84),m3h1x6(:,66),heltab2x6(:,:,112))
  call Hloop_ST_V(ntryL,G1H6(54),20,ex1(:),1,G2H6(89),m3h1x6(:,67),heltab2x6(:,:,113))
call HGT_OLR(G1H6(55),1,1,6)
call HGT_invQ_OLR(G1H6(55),2,5,6)
  call Hloop_TV_S(ntryL,G1H6(55),-8,ex4(:),8,G2H2(5),m3h3x2(:,5),heltab2x6(:,:,114))
  call Hloop_ST_V(ntryL,G1H6(61),20,ex1(:),1,G2H6(90),m3h1x6(:,68),heltab2x6(:,:,115))
  call Hloop_ST_V(ntryL,G1H6(62),20,ex1(:),1,G2H6(91),m3h1x6(:,69),heltab2x6(:,:,116))
  call Hloop_ST_V(ntryL,G1H6(63),20,ex1(:),1,G2H6(92),m3h1x6(:,70),heltab2x6(:,:,117))
  call Hloop_VT_S(ntryL,G1H6(73),20,ex1(:),1,G2H6(93),m3h1x6(:,71),heltab2x6(:,:,118))
call HGT_raise_alpha_OLR(G1H6(74),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(74),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(74),ex4(:),G1H2(1),m3h3x2(:,6),heltab2x6(:,:,119))
  call Hloop_VT_S(ntryL,G1H6(79),20,ex1(:),1,G2H6(94),m3h1x6(:,72),heltab2x6(:,:,120))
  call Hloop_VT_S(ntryL,G1H6(80),20,ex1(:),1,G2H6(95),m3h1x6(:,73),heltab2x6(:,:,121))
  call Hloop_VT_S(ntryL,G1H6(81),20,ex1(:),1,G2H6(96),m3h1x6(:,74),heltab2x6(:,:,122))
  call Hloop_VT_S(ntryL,G1H6(86),20,ex1(:),1,G2H6(97),m3h1x6(:,75),heltab2x6(:,:,123))
call HGT_raise_alpha_OLR(G1H6(87),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(87),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(87),ex4(:),G1H2(2),m3h3x2(:,7),heltab2x6(:,:,124))
  call Hloop_VT_S(ntryL,G1H6(89),20,ex1(:),1,G2H6(98),m3h1x6(:,76),heltab2x6(:,:,125))
  call Hloop_VT_S(ntryL,G1H6(90),20,ex1(:),1,G2H6(99),m3h1x6(:,77),heltab2x6(:,:,126))
  call Hloop_VT_S(ntryL,G1H6(91),20,ex1(:),1,G2H6(100),m3h1x6(:,78),heltab2x6(:,:,127))
  call Hloop_ST_V(ntryL,G1H6(99),20,ex1(:),1,G2H6(101),m3h1x6(:,79),heltab2x6(:,:,128))
call HGT_OLR(G1H6(100),1,1,6)
call HGT_invQ_OLR(G1H6(100),2,5,6)
  call Hloop_SV_V(ntryL,G1H6(100),ex4(:),G1H2(3),m3h3x2(:,8),heltab2x6(:,:,129))
  call Hloop_ST_V(ntryL,G1H6(5),20,ex1(:),1,G2H6(102),m3h1x6(:,80),heltab2x6(:,:,130))
  call Hloop_ST_V(ntryL,G1H6(6),20,ex1(:),1,G2H6(103),m3h1x6(:,81),heltab2x6(:,:,131))
  call Hloop_ST_V(ntryL,G1H6(9),20,ex1(:),1,G2H6(104),m3h1x6(:,82),heltab2x6(:,:,132))
  call Hloop_VT_S(ntryL,G1H6(16),20,ex1(:),1,G2H6(105),m3h1x6(:,83),heltab2x6(:,:,133))
call HGT_raise_alpha_OLR(G1H6(17),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(17),2,5,6)
  call Hloop_UW_V(ntryL,G1H6(17),-8,ex4(:),8,G2H2(6),m3h3x2(:,9),heltab2x6(:,:,134))
  call Hloop_VT_S(ntryL,G1H6(19),20,ex1(:),1,G2H6(106),m3h1x6(:,84),heltab2x6(:,:,135))
  call Hloop_VT_S(ntryL,G1H6(22),20,ex1(:),1,G2H6(107),m3h1x6(:,85),heltab2x6(:,:,136))
  call Hloop_VT_S(ntryL,G1H6(14),20,ex1(:),1,G2H6(108),m3h1x6(:,86),heltab2x6(:,:,137))
  call Hloop_VT_S(ntryL,G1H6(106),20,ex1(:),1,G2H6(109),m3h1x6(:,87),heltab2x6(:,:,138))
call HGT_raise_alpha_OLR(G1H6(107),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(107),2,5,6)
  call Hloop_UW_V(ntryL,G1H6(107),-8,ex4(:),8,G2H2(7),m3h3x2(:,10),heltab2x6(:,:,139))
  call Hloop_VT_S(ntryL,G1H6(109),20,ex1(:),1,G2H6(110),m3h1x6(:,88),heltab2x6(:,:,140))
  call Hloop_VT_S(ntryL,G1H6(110),20,ex1(:),1,G2H6(111),m3h1x6(:,89),heltab2x6(:,:,141))
  call Hloop_VT_S(ntryL,G1H6(111),20,ex1(:),1,G2H6(112),m3h1x6(:,90),heltab2x6(:,:,142))
  call Hloop_AS_Q(ntryL,G1H6(25),ex1(:),G1H6(11),ngH,m3h1x6(:,91),heltab2x6(:,:,143))
  call Hloop_A_Q(ntryL,G1H6(11),19,nML,G2H6(113),n2h6(39))
call HGT_OLR(G1H6(26),1,1,6)
call HGT_invQ_OLR(G1H6(26),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(26),-8,0,G2H6(114),n2h6(40))
  call Hloop_QW_A(ntryL,G2H6(114),ex4(:),G2H2(8),m3h3x2(:,11),heltab2x6(:,:,144))
  call Hloop_AS_Q(ntryL,G1H6(113),ex1(:),G1H6(13),ngH,m3h1x6(:,92),heltab2x6(:,:,145))
  call Hloop_A_Q(ntryL,G1H6(13),19,nML,G2H6(114),n2h6(41))
  call Hloop_AS_Q(ntryL,G1H6(114),ex1(:),G1H6(105),ngH,m3h1x6(:,93),heltab2x6(:,:,146))
  call Hloop_A_Q(ntryL,G1H6(105),19,nML,G2H6(115),n2h6(42))
  call Hloop_AS_Q(ntryL,G1H6(115),ex1(:),G1H6(20),ngH,m3h1x6(:,94),heltab2x6(:,:,147))
  call Hloop_A_Q(ntryL,G1H6(20),19,nML,G2H6(116),n2h6(43))
  call Hloop_QS_A(ntryL,G1H6(116),ex1(:),G1H6(7),ngH,m3h1x6(:,95),heltab2x6(:,:,148))
  call Hloop_Q_A(ntryL,G1H6(7),19,nMT,G2H6(117),n2h6(44))
call HGT_OLR(G1H6(117),1,1,6)
call HGT_invQ_OLR(G1H6(117),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(117),-8,nMB,G2H6(118),n2h6(45))
  call Hloop_AW_Q(ntryL,G2H6(118),ex4(:),G2H2(9),m3h3x2(:,12),heltab2x6(:,:,149))
  call Hloop_QS_A(ntryL,G1H6(119),ex1(:),G1H6(21),ngH,m3h1x6(:,96),heltab2x6(:,:,150))
  call Hloop_Q_A(ntryL,G1H6(21),19,nMT,G2H6(118),n2h6(46))
  call Hloop_QS_A(ntryL,G1H6(120),ex1(:),G1H6(341),ngH,m3h1x6(:,97),heltab2x6(:,:,151))
  call Hloop_Q_A(ntryL,G1H6(341),19,nMT,G2H6(119),n2h6(47))
  call Hloop_QS_A(ntryL,G1H6(121),ex1(:),G1H6(23),ngH,m3h1x6(:,98),heltab2x6(:,:,152))
  call Hloop_Q_A(ntryL,G1H6(23),19,nMT,G2H6(120),n2h6(48))
  call Hloop_AS_Q(ntryL,G1H6(122),ex1(:),G1H6(8),ngH,m3h1x6(:,99),heltab2x6(:,:,153))
  call Hloop_A_Q(ntryL,G1H6(8),19,nMB,G2H6(121),n2h6(49))
call HGT_OLR(G1H6(123),1,1,6)
call HGT_invQ_OLR(G1H6(123),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(123),-8,nMT,G2H6(122),n2h6(50))
  call Hloop_QW_A(ntryL,G2H6(122),ex4(:),G2H2(10),m3h3x2(:,13),heltab2x6(:,:,154))
  call Hloop_AS_Q(ntryL,G1H6(125),ex1(:),G1H6(27),ngH,m3h1x6(:,100),heltab2x6(:,:,155))
  call Hloop_A_Q(ntryL,G1H6(27),19,nMB,G2H6(122),n2h6(51))
  call Hloop_AS_Q(ntryL,G1H6(126),ex1(:),G1H6(29),ngH,m3h1x6(:,101),heltab2x6(:,:,156))
  call Hloop_A_Q(ntryL,G1H6(29),19,nMB,G2H6(123),n2h6(52))
  call Hloop_AS_Q(ntryL,G1H6(127),ex1(:),G1H6(1),ngH,m3h1x6(:,102),heltab2x6(:,:,157))
  call Hloop_A_Q(ntryL,G1H6(1),19,nMB,G2H6(124),n2h6(53))
  call Hloop_ST_V(ntryL,G1H6(34),18,ex1(:),1,G2H6(125),m3h1x6(:,103),heltab2x6(:,:,158))
call HGT_OLR(G1H6(129),1,1,6)
call HGT_invQ_OLR(G1H6(129),2,5,6)
  call Hloop_TV_S(ntryL,G1H6(129),-8,ex4(:),8,G2H2(11),m3h3x2(:,14),heltab2x6(:,:,159))
  call Hloop_ST_V(ntryL,G1H6(131),18,ex1(:),1,G2H6(126),m3h1x6(:,104),heltab2x6(:,:,160))
  call Hloop_ST_V(ntryL,G1H6(132),18,ex1(:),1,G2H6(127),m3h1x6(:,105),heltab2x6(:,:,161))
  call Hloop_ST_V(ntryL,G1H6(133),18,ex1(:),1,G2H6(128),m3h1x6(:,106),heltab2x6(:,:,162))
  call Hloop_ST_V(ntryL,G1H6(134),18,ex1(:),1,G2H6(129),m3h1x6(:,107),heltab2x6(:,:,163))
call HGT_OLR(G1H6(135),1,1,6)
call HGT_invQ_OLR(G1H6(135),2,5,6)
  call Hloop_TV_S(ntryL,G1H6(135),-8,ex4(:),8,G2H2(12),m3h3x2(:,15),heltab2x6(:,:,164))
  call Hloop_ST_V(ntryL,G1H6(137),18,ex1(:),1,G2H6(130),m3h1x6(:,108),heltab2x6(:,:,165))
  call Hloop_ST_V(ntryL,G1H6(138),18,ex1(:),1,G2H6(131),m3h1x6(:,109),heltab2x6(:,:,166))
  call Hloop_ST_V(ntryL,G1H6(139),18,ex1(:),1,G2H6(132),m3h1x6(:,110),heltab2x6(:,:,167))
  call Hloop_ST_V(ntryL,G1H6(41),18,ex1(:),1,G2H6(133),m3h1x6(:,111),heltab2x6(:,:,168))
call HGT_OLR(G1H6(42),1,1,6)
call HGT_invQ_OLR(G1H6(42),2,5,6)
  call Hloop_SV_V(ntryL,G1H6(42),ex4(:),G1H2(4),m3h3x2(:,16),heltab2x6(:,:,169))
  call Hloop_ST_V(ntryL,G1H6(46),18,ex1(:),1,G2H6(134),m3h1x6(:,112),heltab2x6(:,:,170))
  call Hloop_ST_V(ntryL,G1H6(140),18,ex1(:),1,G2H6(135),m3h1x6(:,113),heltab2x6(:,:,171))
  call Hloop_ST_V(ntryL,G1H6(141),18,ex1(:),1,G2H6(136),m3h1x6(:,114),heltab2x6(:,:,172))
  call Hloop_VT_S(ntryL,G1H6(142),18,ex1(:),1,G2H6(137),m3h1x6(:,115),heltab2x6(:,:,173))
call HGT_raise_alpha_OLR(G1H6(143),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(143),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(143),ex4(:),G1H2(5),m3h3x2(:,17),heltab2x6(:,:,174))
  call Hloop_VT_S(ntryL,G1H6(145),18,ex1(:),1,G2H6(138),m3h1x6(:,116),heltab2x6(:,:,175))
  call Hloop_VT_S(ntryL,G1H6(146),18,ex1(:),1,G2H6(139),m3h1x6(:,117),heltab2x6(:,:,176))
  call Hloop_VT_S(ntryL,G1H6(147),18,ex1(:),1,G2H6(140),m3h1x6(:,118),heltab2x6(:,:,177))
  call Hloop_VT_S(ntryL,G1H6(148),18,ex1(:),1,G2H6(141),m3h1x6(:,119),heltab2x6(:,:,178))
call HGT_raise_alpha_OLR(G1H6(149),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(149),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(149),ex4(:),G1H2(6),m3h3x2(:,18),heltab2x6(:,:,179))
  call Hloop_VT_S(ntryL,G1H6(151),18,ex1(:),1,G2H6(142),m3h1x6(:,120),heltab2x6(:,:,180))
  call Hloop_VT_S(ntryL,G1H6(152),18,ex1(:),1,G2H6(143),m3h1x6(:,121),heltab2x6(:,:,181))
  call Hloop_VT_S(ntryL,G1H6(153),18,ex1(:),1,G2H6(144),m3h1x6(:,122),heltab2x6(:,:,182))
  call Hloop_VT_S(ntryL,G1H6(40),18,ex1(:),1,G2H6(145),m3h1x6(:,123),heltab2x6(:,:,183))
call HGT_raise_alpha_OLR(G1H6(50),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(50),2,5,6)
  call Hloop_UW_V(ntryL,G1H6(50),-8,ex4(:),8,G2H2(13),m3h3x2(:,19),heltab2x6(:,:,184))
  call Hloop_VT_S(ntryL,G1H6(154),18,ex1(:),1,G2H6(146),m3h1x6(:,124),heltab2x6(:,:,185))
  call Hloop_VT_S(ntryL,G1H6(155),18,ex1(:),1,G2H6(147),m3h1x6(:,125),heltab2x6(:,:,186))
  call Hloop_VT_S(ntryL,G1H6(156),18,ex1(:),1,G2H6(148),m3h1x6(:,126),heltab2x6(:,:,187))
  call Hloop_VT_S(ntryL,G1H6(157),18,ex1(:),1,G2H6(149),m3h1x6(:,127),heltab2x6(:,:,188))
call HGT_raise_alpha_OLR(G1H6(158),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(158),2,5,6)
  call Hloop_UW_V(ntryL,G1H6(158),-8,ex4(:),8,G2H2(14),m3h3x2(:,20),heltab2x6(:,:,189))
  call Hloop_VT_S(ntryL,G1H6(160),18,ex1(:),1,G2H6(150),m3h1x6(:,128),heltab2x6(:,:,190))
  call Hloop_VT_S(ntryL,G1H6(161),18,ex1(:),1,G2H6(151),m3h1x6(:,129),heltab2x6(:,:,191))
  call Hloop_VT_S(ntryL,G1H6(162),18,ex1(:),1,G2H6(152),m3h1x6(:,130),heltab2x6(:,:,192))
  call Hloop_AV_Q(ntryL,G1H6(52),ex2(:),G1H3(15),m3h2x3(:,43),heltab2x6(:,:,193))
  call Hloop_A_Q(ntryL,G1H3(15),22,nML,G2H3(29),n2h3(1))
call HGT_OLR(G1H6(164),1,1,6)
call HGT_invQ_OLR(G1H6(164),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(164),-8,0,G2H6(153),n2h6(61))
  call Hloop_QW_A(ntryL,G2H6(153),ex4(:),G2H2(15),m3h3x2(:,21),heltab2x6(:,:,194))
  call Hloop_AV_Q(ntryL,G1H6(166),ex2(:),G1H3(15),m3h2x3(:,44),heltab2x6(:,:,195))
  call Hloop_A_Q(ntryL,G1H3(15),22,nML,G2H3(30),n2h3(2))
  call Hloop_AV_Q(ntryL,G1H6(167),ex2(:),G1H3(15),m3h2x3(:,45),heltab2x6(:,:,196))
  call Hloop_A_Q(ntryL,G1H3(15),22,nML,G2H3(31),n2h3(3))
  call Hloop_AV_Q(ntryL,G1H6(168),ex2(:),G1H3(15),m3h2x3(:,46),heltab2x6(:,:,197))
  call Hloop_A_Q(ntryL,G1H3(15),22,nML,G2H3(32),n2h3(4))
  call Hloop_QV_A(ntryL,G1H6(169),ex2(:),G1H3(15),m3h2x3(:,47),heltab2x6(:,:,198))
  call Hloop_Q_A(ntryL,G1H3(15),22,nMT,G2H3(33),n2h3(5))
call HGT_OLR(G1H6(170),1,1,6)
call HGT_invQ_OLR(G1H6(170),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(170),-8,nMB,G2H6(153),n2h6(62))
  call Hloop_AW_Q(ntryL,G2H6(153),ex4(:),G2H2(16),m3h3x2(:,22),heltab2x6(:,:,199))
  call Hloop_QV_A(ntryL,G1H6(172),ex2(:),G1H3(15),m3h2x3(:,48),heltab2x6(:,:,200))
  call Hloop_Q_A(ntryL,G1H3(15),22,nMT,G2H3(34),n2h3(6))
  call Hloop_QV_A(ntryL,G1H6(173),ex2(:),G1H3(15),m3h2x3(:,49),heltab2x6(:,:,201))
  call Hloop_Q_A(ntryL,G1H3(15),22,nMT,G2H3(35),n2h3(7))
  call Hloop_QV_A(ntryL,G1H6(174),ex2(:),G1H3(15),m3h2x3(:,50),heltab2x6(:,:,202))
  call Hloop_Q_A(ntryL,G1H3(15),22,nMT,G2H3(36),n2h3(8))
  call Hloop_AV_Q(ntryL,G1H6(175),ex2(:),G1H3(15),m3h2x3(:,51),heltab2x6(:,:,203))
  call Hloop_A_Q(ntryL,G1H3(15),22,nMB,G2H3(37),n2h3(9))
call HGT_OLR(G1H6(176),1,1,6)
call HGT_invQ_OLR(G1H6(176),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(176),-8,nMT,G2H6(153),n2h6(63))
  call Hloop_QW_A(ntryL,G2H6(153),ex4(:),G2H2(17),m3h3x2(:,23),heltab2x6(:,:,204))
  call Hloop_AV_Q(ntryL,G1H6(178),ex2(:),G1H3(15),m3h2x3(:,52),heltab2x6(:,:,205))
  call Hloop_A_Q(ntryL,G1H3(15),22,nMB,G2H3(38),n2h3(10))
  call Hloop_AV_Q(ntryL,G1H6(179),ex2(:),G1H3(15),m3h2x3(:,53),heltab2x6(:,:,206))
  call Hloop_A_Q(ntryL,G1H3(15),22,nMB,G2H3(39),n2h3(11))
  call Hloop_AV_Q(ntryL,G1H6(180),ex2(:),G1H3(15),m3h2x3(:,54),heltab2x6(:,:,207))
  call Hloop_A_Q(ntryL,G1H3(15),22,nMB,G2H3(40),n2h3(12))
  call Hloop_SV_T(ntryL,G1H6(181),20,ex2(:),2,G2H3(41),m3h2x3(:,55),heltab2x6(:,:,208))
call HGT_OLR(G1H6(182),1,1,6)
call HGT_invQ_OLR(G1H6(182),2,5,6)
  call Hloop_TV_S(ntryL,G1H6(182),-8,ex4(:),8,G2H2(18),m3h3x2(:,24),heltab2x6(:,:,209))
  call Hloop_SV_T(ntryL,G1H6(184),20,ex2(:),2,G2H3(42),m3h2x3(:,56),heltab2x6(:,:,210))
  call Hloop_SV_T(ntryL,G1H6(185),20,ex2(:),2,G2H3(43),m3h2x3(:,57),heltab2x6(:,:,211))
  call Hloop_SV_T(ntryL,G1H6(186),20,ex2(:),2,G2H3(44),m3h2x3(:,58),heltab2x6(:,:,212))
  call Hloop_SV_T(ntryL,G1H6(187),20,ex2(:),2,G2H3(45),m3h2x3(:,59),heltab2x6(:,:,213))
call HGT_OLR(G1H6(188),1,1,6)
call HGT_invQ_OLR(G1H6(188),2,5,6)
  call Hloop_TV_S(ntryL,G1H6(188),-8,ex4(:),8,G2H2(19),m3h3x2(:,25),heltab2x6(:,:,214))
  call Hloop_SV_T(ntryL,G1H6(190),20,ex2(:),2,G2H3(46),m3h2x3(:,60),heltab2x6(:,:,215))
  call Hloop_SV_T(ntryL,G1H6(191),20,ex2(:),2,G2H3(47),m3h2x3(:,61),heltab2x6(:,:,216))
  call Hloop_SV_T(ntryL,G1H6(192),20,ex2(:),2,G2H3(48),m3h2x3(:,62),heltab2x6(:,:,217))
  call Hloop_DV_C(ntryL,G1H6(193),20,ex2(:),G2H3(49),m3h2x3(:,63),heltab2x6(:,:,218))
call HGT_OLR(G1H6(194),1,1,6)
call HGT_invQ_OLR(G1H6(194),2,5,6)
  call Hloop_CV_D(ntryL,G1H6(194),-8,ex4(:),8,G2H2(20),m3h3x2(:,26),heltab2x6(:,:,219))
  call Hloop_DV_C(ntryL,G1H6(196),20,ex2(:),G2H3(50),m3h2x3(:,64),heltab2x6(:,:,220))
  call Hloop_DV_C(ntryL,G1H6(197),20,ex2(:),G2H3(51),m3h2x3(:,65),heltab2x6(:,:,221))
  call Hloop_DV_C(ntryL,G1H6(198),20,ex2(:),G2H3(52),m3h2x3(:,66),heltab2x6(:,:,222))
  call Hloop_DV_C(ntryL,G1H6(199),20,ex2(:),G2H3(53),m3h2x3(:,67),heltab2x6(:,:,223))
call HGT_OLR(G1H6(200),1,1,6)
call HGT_invQ_OLR(G1H6(200),2,5,6)
  call Hloop_CV_D(ntryL,G1H6(200),-8,ex4(:),8,G2H2(21),m3h3x2(:,27),heltab2x6(:,:,224))
  call Hloop_DV_C(ntryL,G1H6(202),20,ex2(:),G2H3(54),m3h2x3(:,68),heltab2x6(:,:,225))
  call Hloop_DV_C(ntryL,G1H6(203),20,ex2(:),G2H3(55),m3h2x3(:,69),heltab2x6(:,:,226))
  call Hloop_DV_C(ntryL,G1H6(204),20,ex2(:),G2H3(56),m3h2x3(:,70),heltab2x6(:,:,227))
  call Hloop_CV_D(ntryL,G1H6(205),20,ex2(:),2,G2H3(57),m3h2x3(:,71),heltab2x6(:,:,228))
call HGT_OLR(G1H6(206),1,1,6)
call HGT_invQ_OLR(G1H6(206),2,5,6)
  call Hloop_DV_C(ntryL,G1H6(206),-8,ex4(:),G2H2(22),m3h3x2(:,28),heltab2x6(:,:,229))
  call Hloop_CV_D(ntryL,G1H6(208),20,ex2(:),2,G2H3(58),m3h2x3(:,72),heltab2x6(:,:,230))
  call Hloop_CV_D(ntryL,G1H6(209),20,ex2(:),2,G2H3(59),m3h2x3(:,73),heltab2x6(:,:,231))
  call Hloop_CV_D(ntryL,G1H6(210),20,ex2(:),2,G2H3(60),m3h2x3(:,74),heltab2x6(:,:,232))
  call Hloop_CV_D(ntryL,G1H6(211),20,ex2(:),2,G2H3(61),m3h2x3(:,75),heltab2x6(:,:,233))
call HGT_OLR(G1H6(212),1,1,6)
call HGT_invQ_OLR(G1H6(212),2,5,6)
  call Hloop_DV_C(ntryL,G1H6(212),-8,ex4(:),G2H2(23),m3h3x2(:,29),heltab2x6(:,:,234))
  call Hloop_CV_D(ntryL,G1H6(214),20,ex2(:),2,G2H3(62),m3h2x3(:,76),heltab2x6(:,:,235))
  call Hloop_CV_D(ntryL,G1H6(215),20,ex2(:),2,G2H3(63),m3h2x3(:,77),heltab2x6(:,:,236))
  call Hloop_CV_D(ntryL,G1H6(216),20,ex2(:),2,G2H3(64),m3h2x3(:,78),heltab2x6(:,:,237))
  call Hloop_UW_V(ntryL,G1H6(217),20,ex2(:),2,G2H3(65),m3h2x3(:,79),heltab2x6(:,:,238))
call HGT_raise_alpha_OLR(G1H6(218),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(218),2,5,6)
  call Hloop_UW_V(ntryL,G1H6(218),-8,ex4(:),8,G2H2(24),m3h3x2(:,30),heltab2x6(:,:,239))
  call Hloop_UW_V(ntryL,G1H6(220),20,ex2(:),2,G2H3(66),m3h2x3(:,80),heltab2x6(:,:,240))
  call Hloop_UW_V(ntryL,G1H6(221),20,ex2(:),2,G2H3(67),m3h2x3(:,81),heltab2x6(:,:,241))
  call Hloop_UW_V(ntryL,G1H6(222),20,ex2(:),2,G2H3(68),m3h2x3(:,82),heltab2x6(:,:,242))
  call Hloop_UW_V(ntryL,G1H6(223),20,ex2(:),2,G2H3(69),m3h2x3(:,83),heltab2x6(:,:,243))
call HGT_raise_alpha_OLR(G1H6(224),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(224),2,5,6)
  call Hloop_UW_V(ntryL,G1H6(224),-8,ex4(:),8,G2H2(25),m3h3x2(:,31),heltab2x6(:,:,244))
  call Hloop_UW_V(ntryL,G1H6(226),20,ex2(:),2,G2H3(70),m3h2x3(:,84),heltab2x6(:,:,245))
  call Hloop_UW_V(ntryL,G1H6(227),20,ex2(:),2,G2H3(71),m3h2x3(:,85),heltab2x6(:,:,246))
  call Hloop_UW_V(ntryL,G1H6(228),20,ex2(:),2,G2H3(72),m3h2x3(:,86),heltab2x6(:,:,247))
  call Hloop_SV_T(ntryL,G1H6(57),20,ex2(:),2,G2H3(73),m3h2x3(:,87),heltab2x6(:,:,248))
call HGT_OLR(G1H6(58),1,1,6)
call HGT_invQ_OLR(G1H6(58),2,5,6)
  call Hloop_SV_V(ntryL,G1H6(58),ex4(:),G1H2(7),m3h3x2(:,32),heltab2x6(:,:,249))
  call Hloop_SV_T(ntryL,G1H6(56),20,ex2(:),2,G2H3(74),m3h2x3(:,88),heltab2x6(:,:,250))
  call Hloop_SV_T(ntryL,G1H6(229),20,ex2(:),2,G2H3(75),m3h2x3(:,89),heltab2x6(:,:,251))
  call Hloop_SV_T(ntryL,G1H6(230),20,ex2(:),2,G2H3(76),m3h2x3(:,90),heltab2x6(:,:,252))
  call Hloop_UW_V(ntryL,G1H6(67),20,ex2(:),2,G2H3(77),m3h2x3(:,91),heltab2x6(:,:,253))
call HGT_raise_alpha_OLR(G1H6(68),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(68),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(68),ex4(:),G1H2(8),m3h3x2(:,33),heltab2x6(:,:,254))
  call Hloop_UW_V(ntryL,G1H6(70),20,ex2(:),2,G2H3(78),m3h2x3(:,92),heltab2x6(:,:,255))
  call Hloop_UW_V(ntryL,G1H6(71),20,ex2(:),2,G2H3(79),m3h2x3(:,93),heltab2x6(:,:,256))
  call Hloop_UW_V(ntryL,G1H6(72),20,ex2(:),2,G2H3(80),m3h2x3(:,94),heltab2x6(:,:,257))
  call Hloop_UW_V(ntryL,G1H6(66),20,ex2(:),2,G2H3(81),m3h2x3(:,95),heltab2x6(:,:,258))
call HGT_raise_alpha_OLR(G1H6(231),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(231),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(231),ex4(:),G1H2(9),m3h3x2(:,34),heltab2x6(:,:,259))
  call Hloop_UW_V(ntryL,G1H6(233),20,ex2(:),2,G2H3(82),m3h2x3(:,96),heltab2x6(:,:,260))
  call Hloop_UW_V(ntryL,G1H6(234),20,ex2(:),2,G2H3(83),m3h2x3(:,97),heltab2x6(:,:,261))
  call Hloop_UW_V(ntryL,G1H6(235),20,ex2(:),2,G2H3(84),m3h2x3(:,98),heltab2x6(:,:,262))
  call Hloop_QS_A(ntryL,G1H6(76),ex1(:),G1H6(31),ngH,m3h1x6(:,131),heltab2x6(:,:,263))
  call Hloop_Q_A(ntryL,G1H6(31),19,nMT,G2H6(153),n2h6(75))
call HGT_OLR(G1H6(77),1,1,6)
call HGT_invQ_OLR(G1H6(77),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(77),-4,nMB,G2H6(154),n2h6(76))
  call Hloop_AV_Q(ntryL,G2H6(154),ex3(:),G2H3(85),m3h2x3(:,99),heltab2x6(:,:,264))
  call Hloop_QS_A(ntryL,G1H6(236),ex1(:),G1H6(10),ngH,m3h1x6(:,132),heltab2x6(:,:,265))
  call Hloop_Q_A(ntryL,G1H6(10),19,nMT,G2H6(154),n2h6(77))
  call Hloop_QS_A(ntryL,G1H6(237),ex1(:),G1H6(32),ngH,m3h1x6(:,133),heltab2x6(:,:,266))
  call Hloop_Q_A(ntryL,G1H6(32),19,nMT,G2H6(155),n2h6(78))
  call Hloop_QS_A(ntryL,G1H6(238),ex1(:),G1H6(3),ngH,m3h1x6(:,134),heltab2x6(:,:,267))
  call Hloop_Q_A(ntryL,G1H6(3),19,nMT,G2H6(156),n2h6(79))
  call Hloop_AS_Q(ntryL,G1H6(239),ex1(:),G1H6(37),ngH,m3h1x6(:,135),heltab2x6(:,:,268))
  call Hloop_A_Q(ntryL,G1H6(37),19,nMB,G2H6(157),n2h6(80))
call HGT_OLR(G1H6(240),1,1,6)
call HGT_invQ_OLR(G1H6(240),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(240),-4,nMT,G2H6(158),n2h6(81))
  call Hloop_QV_A(ntryL,G2H6(158),ex3(:),G2H3(86),m3h2x3(:,100),heltab2x6(:,:,269))
  call Hloop_AS_Q(ntryL,G1H6(242),ex1(:),G1H6(39),ngH,m3h1x6(:,136),heltab2x6(:,:,270))
  call Hloop_A_Q(ntryL,G1H6(39),19,nMB,G2H6(158),n2h6(82))
  call Hloop_AS_Q(ntryL,G1H6(243),ex1(:),G1H6(44),ngH,m3h1x6(:,137),heltab2x6(:,:,271))
  call Hloop_A_Q(ntryL,G1H6(44),19,nMB,G2H6(159),n2h6(83))
  call Hloop_AS_Q(ntryL,G1H6(244),ex1(:),G1H6(48),ngH,m3h1x6(:,138),heltab2x6(:,:,272))
  call Hloop_A_Q(ntryL,G1H6(48),19,nMB,G2H6(160),n2h6(84))
  call Hloop_AV_Q(ntryL,G1H12(103),ex2(:),G1H6(53),m3h2x6(:,291),heltab2x12(:,:,509))
  call Hloop_A_Q(ntryL,G1H6(53),19,nML,G2H6(161),n2h6(85))
call HGT_OLR(G1H12(104),1,1,12)
call HGT_invQ_OLR(G1H12(104),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(104),-8,0,G2H12(1),n2h12(45))
  call Hloop_QW_A(ntryL,G2H12(1),ex4(:),G2H4(21),m3h3x4(:,37),heltab2x12(:,:,510))
  call Hloop_AV_Q(ntryL,G1H12(106),ex2(:),G1H6(54),m3h2x6(:,292),heltab2x12(:,:,511))
  call Hloop_A_Q(ntryL,G1H6(54),19,nML,G2H6(162),n2h6(86))
  call Hloop_AV_Q(ntryL,G1H12(107),ex2(:),G1H6(55),m3h2x6(:,293),heltab2x12(:,:,512))
  call Hloop_A_Q(ntryL,G1H6(55),19,nML,G2H6(163),n2h6(87))
  call Hloop_AV_Q(ntryL,G1H12(108),ex2(:),G1H6(61),m3h2x6(:,294),heltab2x12(:,:,513))
  call Hloop_A_Q(ntryL,G1H6(61),19,nML,G2H6(164),n2h6(88))
  call Hloop_QV_A(ntryL,G1H12(1),ex2(:),G1H6(62),m3h2x6(:,295),heltab2x12(:,:,514))
  call Hloop_Q_A(ntryL,G1H6(62),19,nMT,G2H6(165),n2h6(89))
call HGT_OLR(G1H12(109),1,1,12)
call HGT_invQ_OLR(G1H12(109),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(109),-8,nMB,G2H12(2),n2h12(46))
  call Hloop_AW_Q(ntryL,G2H12(2),ex4(:),G2H4(22),m3h3x4(:,38),heltab2x12(:,:,515))
  call Hloop_QV_A(ntryL,G1H12(110),ex2(:),G1H6(63),m3h2x6(:,296),heltab2x12(:,:,516))
  call Hloop_Q_A(ntryL,G1H6(63),19,nMT,G2H6(166),n2h6(90))
  call Hloop_QV_A(ntryL,G1H12(3),ex2(:),G1H6(73),m3h2x6(:,297),heltab2x12(:,:,517))
  call Hloop_Q_A(ntryL,G1H6(73),19,nMT,G2H6(167),n2h6(91))
  call Hloop_QV_A(ntryL,G1H12(111),ex2(:),G1H6(74),m3h2x6(:,298),heltab2x12(:,:,518))
  call Hloop_Q_A(ntryL,G1H6(74),19,nMT,G2H6(168),n2h6(92))
  call Hloop_AV_Q(ntryL,G1H12(112),ex2(:),G1H6(79),m3h2x6(:,299),heltab2x12(:,:,519))
  call Hloop_A_Q(ntryL,G1H6(79),19,nMB,G2H6(169),n2h6(93))
call HGT_OLR(G1H12(113),1,1,12)
call HGT_invQ_OLR(G1H12(113),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(113),-8,nMT,G2H12(3),n2h12(47))
  call Hloop_QW_A(ntryL,G2H12(3),ex4(:),G2H4(23),m3h3x4(:,39),heltab2x12(:,:,520))
  call Hloop_AV_Q(ntryL,G1H12(115),ex2(:),G1H6(80),m3h2x6(:,300),heltab2x12(:,:,521))
  call Hloop_A_Q(ntryL,G1H6(80),19,nMB,G2H6(170),n2h6(94))
  call Hloop_AV_Q(ntryL,G1H12(116),ex2(:),G1H6(81),m3h2x6(:,301),heltab2x12(:,:,522))
  call Hloop_A_Q(ntryL,G1H6(81),19,nMB,G2H6(171),n2h6(95))
  call Hloop_AV_Q(ntryL,G1H12(117),ex2(:),G1H6(86),m3h2x6(:,302),heltab2x12(:,:,523))
  call Hloop_A_Q(ntryL,G1H6(86),19,nMB,G2H6(172),n2h6(96))
  call Hloop_SV_T(ntryL,G1H12(118),17,ex2(:),2,G2H6(173),m3h2x6(:,303),heltab2x12(:,:,524))
call HGT_raise_alpha_OLR(G1H12(119),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(119),2,5,12)
  call Hloop_VV_S(ntryL,G1H12(119),ex4(:),G1H4(13),m3h3x4(:,40),heltab2x12(:,:,525))
  call Hloop_SV_T(ntryL,G1H12(121),17,ex2(:),2,G2H6(174),m3h2x6(:,304),heltab2x12(:,:,526))
  call Hloop_SV_T(ntryL,G1H12(122),17,ex2(:),2,G2H6(175),m3h2x6(:,305),heltab2x12(:,:,527))
  call Hloop_SV_T(ntryL,G1H12(123),17,ex2(:),2,G2H6(176),m3h2x6(:,306),heltab2x12(:,:,528))
  call Hloop_SV_T(ntryL,G1H12(124),17,ex2(:),2,G2H6(177),m3h2x6(:,307),heltab2x12(:,:,529))
call HGT_raise_alpha_OLR(G1H12(125),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(125),2,5,12)
  call Hloop_VV_S(ntryL,G1H12(125),ex4(:),G1H4(14),m3h3x4(:,41),heltab2x12(:,:,530))
  call Hloop_SV_T(ntryL,G1H12(127),17,ex2(:),2,G2H6(178),m3h2x6(:,308),heltab2x12(:,:,531))
  call Hloop_SV_T(ntryL,G1H12(128),17,ex2(:),2,G2H6(179),m3h2x6(:,309),heltab2x12(:,:,532))
  call Hloop_SV_T(ntryL,G1H12(129),17,ex2(:),2,G2H6(180),m3h2x6(:,310),heltab2x12(:,:,533))
  call Hloop_SV_T(ntryL,G1H12(130),17,ex2(:),2,G2H6(181),m3h2x6(:,311),heltab2x12(:,:,534))
call HGT_raise_alpha_OLR(G1H12(131),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(131),2,5,12)
  call Hloop_UW_V(ntryL,G1H12(131),-8,ex4(:),8,G2H4(24),m3h3x4(:,42),heltab2x12(:,:,535))
  call Hloop_SV_T(ntryL,G1H12(133),17,ex2(:),2,G2H6(182),m3h2x6(:,312),heltab2x12(:,:,536))
  call Hloop_SV_T(ntryL,G1H12(134),17,ex2(:),2,G2H6(183),m3h2x6(:,313),heltab2x12(:,:,537))
  call Hloop_SV_T(ntryL,G1H12(135),17,ex2(:),2,G2H6(184),m3h2x6(:,314),heltab2x12(:,:,538))
  call Hloop_SV_T(ntryL,G1H12(136),17,ex2(:),2,G2H6(185),m3h2x6(:,315),heltab2x12(:,:,539))
call HGT_raise_alpha_OLR(G1H12(137),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(137),2,5,12)
  call Hloop_UW_V(ntryL,G1H12(137),-8,ex4(:),8,G2H4(25),m3h3x4(:,43),heltab2x12(:,:,540))
  call Hloop_SV_T(ntryL,G1H12(139),17,ex2(:),2,G2H6(186),m3h2x6(:,316),heltab2x12(:,:,541))
  call Hloop_SV_T(ntryL,G1H12(140),17,ex2(:),2,G2H6(187),m3h2x6(:,317),heltab2x12(:,:,542))
  call Hloop_SV_T(ntryL,G1H12(141),17,ex2(:),2,G2H6(188),m3h2x6(:,318),heltab2x12(:,:,543))
  call Hloop_UW_V(ntryL,G1H12(142),17,ex2(:),2,G2H6(189),m3h2x6(:,319),heltab2x12(:,:,544))
call HGT_OLR(G1H12(143),1,1,12)
call HGT_invQ_OLR(G1H12(143),2,5,12)
  call Hloop_TV_S(ntryL,G1H12(143),-8,ex4(:),8,G2H4(26),m3h3x4(:,44),heltab2x12(:,:,545))
  call Hloop_UW_V(ntryL,G1H12(144),17,ex2(:),2,G2H6(190),m3h2x6(:,320),heltab2x12(:,:,546))
  call Hloop_UW_V(ntryL,G1H12(35),17,ex2(:),2,G2H6(191),m3h2x6(:,321),heltab2x12(:,:,547))
  call Hloop_UW_V(ntryL,G1H12(145),17,ex2(:),2,G2H6(192),m3h2x6(:,322),heltab2x12(:,:,548))
  call Hloop_UW_V(ntryL,G1H12(146),17,ex2(:),2,G2H6(193),m3h2x6(:,323),heltab2x12(:,:,549))
call HGT_OLR(G1H12(147),1,1,12)
call HGT_invQ_OLR(G1H12(147),2,5,12)
  call Hloop_TV_S(ntryL,G1H12(147),-8,ex4(:),8,G2H4(27),m3h3x4(:,45),heltab2x12(:,:,550))
  call Hloop_UW_V(ntryL,G1H12(149),17,ex2(:),2,G2H6(194),m3h2x6(:,324),heltab2x12(:,:,551))
  call Hloop_UW_V(ntryL,G1H12(150),17,ex2(:),2,G2H6(195),m3h2x6(:,325),heltab2x12(:,:,552))
  call Hloop_UW_V(ntryL,G1H12(151),17,ex2(:),2,G2H6(196),m3h2x6(:,326),heltab2x12(:,:,553))
  call Hloop_UW_V(ntryL,G1H12(152),17,ex2(:),2,G2H6(197),m3h2x6(:,327),heltab2x12(:,:,554))
call HGT_OLR(G1H12(153),1,1,12)
call HGT_invQ_OLR(G1H12(153),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(153),ex4(:),G1H4(15),m3h3x4(:,46),heltab2x12(:,:,555))
  call Hloop_UW_V(ntryL,G1H12(155),17,ex2(:),2,G2H6(198),m3h2x6(:,328),heltab2x12(:,:,556))
  call Hloop_UW_V(ntryL,G1H12(156),17,ex2(:),2,G2H6(199),m3h2x6(:,329),heltab2x12(:,:,557))
  call Hloop_UW_V(ntryL,G1H12(157),17,ex2(:),2,G2H6(200),m3h2x6(:,330),heltab2x12(:,:,558))
  call Hloop_QV_A(ntryL,G1H12(158),ex2(:),G1H6(87),m3h2x6(:,331),heltab2x12(:,:,559))
  call Hloop_Q_A(ntryL,G1H6(87),19,nMT,G2H6(201),n2h6(97))
call HGT_OLR(G1H12(159),1,1,12)
call HGT_invQ_OLR(G1H12(159),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(159),-4,nMB,G2H12(6),n2h12(55))
  call Hloop_AV_Q(ntryL,G2H12(6),ex3(:),G2H6(202),m3h2x6(:,332),heltab2x12(:,:,560))
  call Hloop_QV_A(ntryL,G1H12(161),ex2(:),G1H6(89),m3h2x6(:,333),heltab2x12(:,:,561))
  call Hloop_Q_A(ntryL,G1H6(89),19,nMT,G2H6(203),n2h6(98))
  call Hloop_QV_A(ntryL,G1H12(162),ex2(:),G1H6(90),m3h2x6(:,334),heltab2x12(:,:,562))
  call Hloop_Q_A(ntryL,G1H6(90),19,nMT,G2H6(204),n2h6(99))
  call Hloop_QV_A(ntryL,G1H12(163),ex2(:),G1H6(91),m3h2x6(:,335),heltab2x12(:,:,563))
  call Hloop_Q_A(ntryL,G1H6(91),19,nMT,G2H6(205),n2h6(100))
  call Hloop_AV_Q(ntryL,G1H12(164),ex2(:),G1H6(99),m3h2x6(:,336),heltab2x12(:,:,564))
  call Hloop_A_Q(ntryL,G1H6(99),19,nMB,G2H6(206),n2h6(101))
call HGT_OLR(G1H12(165),1,1,12)
call HGT_invQ_OLR(G1H12(165),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(165),-4,nMT,G2H12(7),n2h12(56))
  call Hloop_QV_A(ntryL,G2H12(7),ex3(:),G2H6(207),m3h2x6(:,337),heltab2x12(:,:,565))
  call Hloop_AV_Q(ntryL,G1H12(167),ex2(:),G1H6(100),m3h2x6(:,338),heltab2x12(:,:,566))
  call Hloop_A_Q(ntryL,G1H6(100),19,nMB,G2H6(208),n2h6(102))
  call Hloop_AV_Q(ntryL,G1H12(168),ex2(:),G1H6(5),m3h2x6(:,339),heltab2x12(:,:,567))
  call Hloop_A_Q(ntryL,G1H6(5),19,nMB,G2H6(209),n2h6(103))
  call Hloop_AV_Q(ntryL,G1H12(169),ex2(:),G1H6(6),m3h2x6(:,340),heltab2x12(:,:,568))
  call Hloop_A_Q(ntryL,G1H6(6),19,nMB,G2H6(210),n2h6(104))
  call Hloop_AV_Q(ntryL,G1H6(252),ex3(:),G1H3(15),m3h2x3(:,101),heltab2x6(:,:,273))
  call Hloop_A_Q(ntryL,G1H3(15),22,nML,G2H3(87),n2h3(13))
call HGT_OLR(G1H6(253),1,1,6)
call HGT_invQ_OLR(G1H6(253),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(253),-8,0,G2H6(211),n2h6(105))
  call Hloop_QW_A(ntryL,G2H6(211),ex4(:),G2H2(26),m3h3x2(:,35),heltab2x6(:,:,274))
  call Hloop_AV_Q(ntryL,G1H6(255),ex3(:),G1H3(15),m3h2x3(:,102),heltab2x6(:,:,275))
  call Hloop_A_Q(ntryL,G1H3(15),22,nML,G2H3(88),n2h3(14))
  call Hloop_AV_Q(ntryL,G1H6(256),ex3(:),G1H3(15),m3h2x3(:,103),heltab2x6(:,:,276))
  call Hloop_A_Q(ntryL,G1H3(15),22,nML,G2H3(89),n2h3(15))
  call Hloop_AV_Q(ntryL,G1H6(257),ex3(:),G1H3(15),m3h2x3(:,104),heltab2x6(:,:,277))
  call Hloop_A_Q(ntryL,G1H3(15),22,nML,G2H3(90),n2h3(16))
  call Hloop_QV_A(ntryL,G1H6(258),ex3(:),G1H3(15),m3h2x3(:,105),heltab2x6(:,:,278))
  call Hloop_Q_A(ntryL,G1H3(15),22,nMT,G2H3(91),n2h3(17))
call HGT_OLR(G1H6(259),1,1,6)
call HGT_invQ_OLR(G1H6(259),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(259),-8,nMB,G2H6(211),n2h6(106))
  call Hloop_AW_Q(ntryL,G2H6(211),ex4(:),G2H2(27),m3h3x2(:,36),heltab2x6(:,:,279))
  call Hloop_QV_A(ntryL,G1H6(261),ex3(:),G1H3(15),m3h2x3(:,106),heltab2x6(:,:,280))
  call Hloop_Q_A(ntryL,G1H3(15),22,nMT,G2H3(92),n2h3(18))
  call Hloop_QV_A(ntryL,G1H6(262),ex3(:),G1H3(15),m3h2x3(:,107),heltab2x6(:,:,281))
  call Hloop_Q_A(ntryL,G1H3(15),22,nMT,G2H3(93),n2h3(19))
  call Hloop_QV_A(ntryL,G1H6(263),ex3(:),G1H3(15),m3h2x3(:,108),heltab2x6(:,:,282))
  call Hloop_Q_A(ntryL,G1H3(15),22,nMT,G2H3(94),n2h3(20))
  call Hloop_AV_Q(ntryL,G1H6(264),ex3(:),G1H3(15),m3h2x3(:,109),heltab2x6(:,:,283))
  call Hloop_A_Q(ntryL,G1H3(15),22,nMB,G2H3(95),n2h3(21))
call HGT_OLR(G1H6(265),1,1,6)
call HGT_invQ_OLR(G1H6(265),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(265),-8,nMT,G2H6(211),n2h6(107))
  call Hloop_QW_A(ntryL,G2H6(211),ex4(:),G2H2(28),m3h3x2(:,37),heltab2x6(:,:,284))
  call Hloop_AV_Q(ntryL,G1H6(267),ex3(:),G1H3(15),m3h2x3(:,110),heltab2x6(:,:,285))
  call Hloop_A_Q(ntryL,G1H3(15),22,nMB,G2H3(96),n2h3(22))
  call Hloop_AV_Q(ntryL,G1H6(268),ex3(:),G1H3(15),m3h2x3(:,111),heltab2x6(:,:,286))
  call Hloop_A_Q(ntryL,G1H3(15),22,nMB,G2H3(97),n2h3(23))
  call Hloop_AV_Q(ntryL,G1H6(269),ex3(:),G1H3(15),m3h2x3(:,112),heltab2x6(:,:,287))
  call Hloop_A_Q(ntryL,G1H3(15),22,nMB,G2H3(98),n2h3(24))
  call Hloop_SV_T(ntryL,G1H6(270),18,ex3(:),4,G2H3(99),m3h2x3(:,113),heltab2x6(:,:,288))
call HGT_OLR(G1H6(271),1,1,6)
call HGT_invQ_OLR(G1H6(271),2,5,6)
  call Hloop_TV_S(ntryL,G1H6(271),-8,ex4(:),8,G2H2(29),m3h3x2(:,38),heltab2x6(:,:,289))
  call Hloop_SV_T(ntryL,G1H6(273),18,ex3(:),4,G2H3(100),m3h2x3(:,114),heltab2x6(:,:,290))
  call Hloop_SV_T(ntryL,G1H6(274),18,ex3(:),4,G2H3(101),m3h2x3(:,115),heltab2x6(:,:,291))
  call Hloop_SV_T(ntryL,G1H6(275),18,ex3(:),4,G2H3(102),m3h2x3(:,116),heltab2x6(:,:,292))
  call Hloop_SV_T(ntryL,G1H6(276),18,ex3(:),4,G2H3(103),m3h2x3(:,117),heltab2x6(:,:,293))
call HGT_OLR(G1H6(277),1,1,6)
call HGT_invQ_OLR(G1H6(277),2,5,6)
  call Hloop_TV_S(ntryL,G1H6(277),-8,ex4(:),8,G2H2(30),m3h3x2(:,39),heltab2x6(:,:,294))
  call Hloop_SV_T(ntryL,G1H6(279),18,ex3(:),4,G2H3(104),m3h2x3(:,118),heltab2x6(:,:,295))
  call Hloop_SV_T(ntryL,G1H6(280),18,ex3(:),4,G2H3(105),m3h2x3(:,119),heltab2x6(:,:,296))
  call Hloop_SV_T(ntryL,G1H6(281),18,ex3(:),4,G2H3(106),m3h2x3(:,120),heltab2x6(:,:,297))
  call Hloop_DV_C(ntryL,G1H6(282),18,ex3(:),G2H3(107),m3h2x3(:,121),heltab2x6(:,:,298))
call HGT_OLR(G1H6(283),1,1,6)
call HGT_invQ_OLR(G1H6(283),2,5,6)
  call Hloop_CV_D(ntryL,G1H6(283),-8,ex4(:),8,G2H2(31),m3h3x2(:,40),heltab2x6(:,:,299))
  call Hloop_DV_C(ntryL,G1H6(285),18,ex3(:),G2H3(108),m3h2x3(:,122),heltab2x6(:,:,300))
  call Hloop_DV_C(ntryL,G1H6(286),18,ex3(:),G2H3(109),m3h2x3(:,123),heltab2x6(:,:,301))
  call Hloop_DV_C(ntryL,G1H6(287),18,ex3(:),G2H3(110),m3h2x3(:,124),heltab2x6(:,:,302))
  call Hloop_DV_C(ntryL,G1H6(288),18,ex3(:),G2H3(111),m3h2x3(:,125),heltab2x6(:,:,303))
call HGT_OLR(G1H6(289),1,1,6)
call HGT_invQ_OLR(G1H6(289),2,5,6)
  call Hloop_CV_D(ntryL,G1H6(289),-8,ex4(:),8,G2H2(32),m3h3x2(:,41),heltab2x6(:,:,304))
  call Hloop_DV_C(ntryL,G1H6(291),18,ex3(:),G2H3(112),m3h2x3(:,126),heltab2x6(:,:,305))
  call Hloop_DV_C(ntryL,G1H6(292),18,ex3(:),G2H3(113),m3h2x3(:,127),heltab2x6(:,:,306))
  call Hloop_DV_C(ntryL,G1H6(293),18,ex3(:),G2H3(114),m3h2x3(:,128),heltab2x6(:,:,307))
  call Hloop_CV_D(ntryL,G1H6(294),18,ex3(:),4,G2H3(115),m3h2x3(:,129),heltab2x6(:,:,308))
call HGT_OLR(G1H6(295),1,1,6)
call HGT_invQ_OLR(G1H6(295),2,5,6)
  call Hloop_DV_C(ntryL,G1H6(295),-8,ex4(:),G2H2(33),m3h3x2(:,42),heltab2x6(:,:,309))
  call Hloop_CV_D(ntryL,G1H6(297),18,ex3(:),4,G2H3(116),m3h2x3(:,130),heltab2x6(:,:,310))
  call Hloop_CV_D(ntryL,G1H6(298),18,ex3(:),4,G2H3(117),m3h2x3(:,131),heltab2x6(:,:,311))
  call Hloop_CV_D(ntryL,G1H6(299),18,ex3(:),4,G2H3(118),m3h2x3(:,132),heltab2x6(:,:,312))
  call Hloop_CV_D(ntryL,G1H6(300),18,ex3(:),4,G2H3(119),m3h2x3(:,133),heltab2x6(:,:,313))
call HGT_OLR(G1H6(301),1,1,6)
call HGT_invQ_OLR(G1H6(301),2,5,6)
  call Hloop_DV_C(ntryL,G1H6(301),-8,ex4(:),G2H2(34),m3h3x2(:,43),heltab2x6(:,:,314))
  call Hloop_CV_D(ntryL,G1H6(303),18,ex3(:),4,G2H3(120),m3h2x3(:,134),heltab2x6(:,:,315))
  call Hloop_CV_D(ntryL,G1H6(304),18,ex3(:),4,G2H3(121),m3h2x3(:,135),heltab2x6(:,:,316))
  call Hloop_CV_D(ntryL,G1H6(305),18,ex3(:),4,G2H3(122),m3h2x3(:,136),heltab2x6(:,:,317))
  call Hloop_UW_V(ntryL,G1H6(306),18,ex3(:),4,G2H3(123),m3h2x3(:,137),heltab2x6(:,:,318))
call HGT_raise_alpha_OLR(G1H6(307),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(307),2,5,6)
  call Hloop_UW_V(ntryL,G1H6(307),-8,ex4(:),8,G2H2(35),m3h3x2(:,44),heltab2x6(:,:,319))
  call Hloop_UW_V(ntryL,G1H6(309),18,ex3(:),4,G2H3(124),m3h2x3(:,138),heltab2x6(:,:,320))
  call Hloop_UW_V(ntryL,G1H6(310),18,ex3(:),4,G2H3(125),m3h2x3(:,139),heltab2x6(:,:,321))
  call Hloop_UW_V(ntryL,G1H6(311),18,ex3(:),4,G2H3(126),m3h2x3(:,140),heltab2x6(:,:,322))
  call Hloop_UW_V(ntryL,G1H6(312),18,ex3(:),4,G2H3(127),m3h2x3(:,141),heltab2x6(:,:,323))
call HGT_raise_alpha_OLR(G1H6(313),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(313),2,5,6)
  call Hloop_UW_V(ntryL,G1H6(313),-8,ex4(:),8,G2H2(36),m3h3x2(:,45),heltab2x6(:,:,324))
  call Hloop_UW_V(ntryL,G1H6(315),18,ex3(:),4,G2H3(128),m3h2x3(:,142),heltab2x6(:,:,325))
  call Hloop_UW_V(ntryL,G1H6(316),18,ex3(:),4,G2H3(129),m3h2x3(:,143),heltab2x6(:,:,326))
  call Hloop_UW_V(ntryL,G1H6(317),18,ex3(:),4,G2H3(130),m3h2x3(:,144),heltab2x6(:,:,327))
  call Hloop_SV_T(ntryL,G1H6(83),18,ex3(:),4,G2H3(131),m3h2x3(:,145),heltab2x6(:,:,328))
call HGT_OLR(G1H6(84),1,1,6)
call HGT_invQ_OLR(G1H6(84),2,5,6)
  call Hloop_SV_V(ntryL,G1H6(84),ex4(:),G1H2(10),m3h3x2(:,46),heltab2x6(:,:,329))
  call Hloop_SV_T(ntryL,G1H6(82),18,ex3(:),4,G2H3(132),m3h2x3(:,146),heltab2x6(:,:,330))
  call Hloop_SV_T(ntryL,G1H6(318),18,ex3(:),4,G2H3(133),m3h2x3(:,147),heltab2x6(:,:,331))
  call Hloop_SV_T(ntryL,G1H6(319),18,ex3(:),4,G2H3(134),m3h2x3(:,148),heltab2x6(:,:,332))
  call Hloop_UW_V(ntryL,G1H6(93),18,ex3(:),4,G2H3(135),m3h2x3(:,149),heltab2x6(:,:,333))
call HGT_raise_alpha_OLR(G1H6(94),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(94),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(94),ex4(:),G1H2(11),m3h3x2(:,47),heltab2x6(:,:,334))
  call Hloop_UW_V(ntryL,G1H6(96),18,ex3(:),4,G2H3(136),m3h2x3(:,150),heltab2x6(:,:,335))
  call Hloop_UW_V(ntryL,G1H6(97),18,ex3(:),4,G2H3(137),m3h2x3(:,151),heltab2x6(:,:,336))
  call Hloop_UW_V(ntryL,G1H6(98),18,ex3(:),4,G2H3(138),m3h2x3(:,152),heltab2x6(:,:,337))
  call Hloop_UW_V(ntryL,G1H6(92),18,ex3(:),4,G2H3(139),m3h2x3(:,153),heltab2x6(:,:,338))
call HGT_raise_alpha_OLR(G1H6(320),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(320),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(320),ex4(:),G1H2(12),m3h3x2(:,48),heltab2x6(:,:,339))
  call Hloop_UW_V(ntryL,G1H6(322),18,ex3(:),4,G2H3(140),m3h2x3(:,154),heltab2x6(:,:,340))
  call Hloop_UW_V(ntryL,G1H6(323),18,ex3(:),4,G2H3(141),m3h2x3(:,155),heltab2x6(:,:,341))
  call Hloop_UW_V(ntryL,G1H6(324),18,ex3(:),4,G2H3(142),m3h2x3(:,156),heltab2x6(:,:,342))
  call Hloop_AW_Q(ntryL,G1H6(102),ex4(:),G1H2(13),m3h3x2(:,49),heltab2x6(:,:,343))
  call Hloop_A_Q(ntryL,G1H2(13),26,nMT,G2H2(37),n2h2(1))
call HGT_OLR(G1H6(103),1,1,6)
call HGT_invQ_OLR(G1H6(103),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(103),-4,nMT,G2H6(211),n2h6(119))
  call Hloop_QV_A(ntryL,G2H6(211),ex3(:),G2H3(143),m3h2x3(:,157),heltab2x6(:,:,344))
  call Hloop_AW_Q(ntryL,G1H6(325),ex4(:),G1H2(13),m3h3x2(:,50),heltab2x6(:,:,345))
  call Hloop_A_Q(ntryL,G1H2(13),26,nMT,G2H2(38),n2h2(2))
  call Hloop_AW_Q(ntryL,G1H6(326),ex4(:),G1H2(13),m3h3x2(:,51),heltab2x6(:,:,346))
  call Hloop_A_Q(ntryL,G1H2(13),26,nMT,G2H2(39),n2h2(3))
  call Hloop_AW_Q(ntryL,G1H6(327),ex4(:),G1H2(13),m3h3x2(:,52),heltab2x6(:,:,347))
  call Hloop_A_Q(ntryL,G1H2(13),26,nMT,G2H2(40),n2h2(4))
  call Hloop_QW_A(ntryL,G1H6(328),ex4(:),G1H2(13),m3h3x2(:,53),heltab2x6(:,:,348))
  call Hloop_Q_A(ntryL,G1H2(13),26,nMB,G2H2(41),n2h2(5))
call HGT_OLR(G1H6(329),1,1,6)
call HGT_invQ_OLR(G1H6(329),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(329),-4,nMB,G2H6(211),n2h6(120))
  call Hloop_AV_Q(ntryL,G2H6(211),ex3(:),G2H3(144),m3h2x3(:,158),heltab2x6(:,:,349))
  call Hloop_QW_A(ntryL,G1H6(331),ex4(:),G1H2(13),m3h3x2(:,54),heltab2x6(:,:,350))
  call Hloop_Q_A(ntryL,G1H2(13),26,nMB,G2H2(42),n2h2(6))
  call Hloop_QW_A(ntryL,G1H6(332),ex4(:),G1H2(13),m3h3x2(:,55),heltab2x6(:,:,351))
  call Hloop_Q_A(ntryL,G1H2(13),26,nMB,G2H2(43),n2h2(7))
  call Hloop_QW_A(ntryL,G1H6(333),ex4(:),G1H2(13),m3h3x2(:,56),heltab2x6(:,:,352))
  call Hloop_Q_A(ntryL,G1H2(13),26,nMB,G2H2(44),n2h2(8))
  call Hloop_AV_Q(ntryL,G1H12(170),ex3(:),G1H6(9),m3h2x6(:,341),heltab2x12(:,:,569))
  call Hloop_A_Q(ntryL,G1H6(9),21,nML,G2H6(211),n2h6(121))
call HGT_OLR(G1H12(171),1,1,12)
call HGT_invQ_OLR(G1H12(171),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(171),-8,0,G2H12(4),n2h12(57))
  call Hloop_QW_A(ntryL,G2H12(4),ex4(:),G2H4(28),m3h3x4(:,47),heltab2x12(:,:,570))
  call Hloop_AV_Q(ntryL,G1H12(173),ex3(:),G1H6(16),m3h2x6(:,342),heltab2x12(:,:,571))
  call Hloop_A_Q(ntryL,G1H6(16),21,nML,G2H6(212),n2h6(122))
  call Hloop_AV_Q(ntryL,G1H12(174),ex3(:),G1H6(17),m3h2x6(:,343),heltab2x12(:,:,572))
  call Hloop_A_Q(ntryL,G1H6(17),21,nML,G2H6(213),n2h6(123))
  call Hloop_AV_Q(ntryL,G1H12(175),ex3(:),G1H6(19),m3h2x6(:,344),heltab2x12(:,:,573))
  call Hloop_A_Q(ntryL,G1H6(19),21,nML,G2H6(214),n2h6(124))
  call Hloop_QV_A(ntryL,G1H12(176),ex3(:),G1H6(22),m3h2x6(:,345),heltab2x12(:,:,574))
  call Hloop_Q_A(ntryL,G1H6(22),21,nMT,G2H6(215),n2h6(125))
call HGT_OLR(G1H12(177),1,1,12)
call HGT_invQ_OLR(G1H12(177),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(177),-8,nMB,G2H12(5),n2h12(58))
  call Hloop_AW_Q(ntryL,G2H12(5),ex4(:),G2H4(29),m3h3x4(:,48),heltab2x12(:,:,575))
  call Hloop_QV_A(ntryL,G1H12(179),ex3(:),G1H6(14),m3h2x6(:,346),heltab2x12(:,:,576))
  call Hloop_Q_A(ntryL,G1H6(14),21,nMT,G2H6(216),n2h6(126))
  call Hloop_QV_A(ntryL,G1H12(180),ex3(:),G1H6(106),m3h2x6(:,347),heltab2x12(:,:,577))
  call Hloop_Q_A(ntryL,G1H6(106),21,nMT,G2H6(217),n2h6(127))
  call Hloop_QV_A(ntryL,G1H12(181),ex3(:),G1H6(107),m3h2x6(:,348),heltab2x12(:,:,578))
  call Hloop_Q_A(ntryL,G1H6(107),21,nMT,G2H6(218),n2h6(128))
  call Hloop_AV_Q(ntryL,G1H12(182),ex3(:),G1H6(109),m3h2x6(:,349),heltab2x12(:,:,579))
  call Hloop_A_Q(ntryL,G1H6(109),21,nMB,G2H6(219),n2h6(129))
call HGT_OLR(G1H12(36),1,1,12)
call HGT_invQ_OLR(G1H12(36),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(36),-8,nMT,G2H12(11),n2h12(59))
  call Hloop_QW_A(ntryL,G2H12(11),ex4(:),G2H4(30),m3h3x4(:,49),heltab2x12(:,:,580))
  call Hloop_AV_Q(ntryL,G1H12(37),ex3(:),G1H6(110),m3h2x6(:,350),heltab2x12(:,:,581))
  call Hloop_A_Q(ntryL,G1H6(110),21,nMB,G2H6(220),n2h6(130))
  call Hloop_AV_Q(ntryL,G1H12(184),ex3(:),G1H6(111),m3h2x6(:,351),heltab2x12(:,:,582))
  call Hloop_A_Q(ntryL,G1H6(111),21,nMB,G2H6(221),n2h6(131))
  call Hloop_AV_Q(ntryL,G1H12(38),ex3(:),G1H6(25),m3h2x6(:,352),heltab2x12(:,:,583))
  call Hloop_A_Q(ntryL,G1H6(25),21,nMB,G2H6(222),n2h6(132))
  call Hloop_SV_T(ntryL,G1H12(185),17,ex3(:),4,G2H6(223),m3h2x6(:,353),heltab2x12(:,:,584))
call HGT_raise_alpha_OLR(G1H12(186),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(186),2,5,12)
  call Hloop_VV_S(ntryL,G1H12(186),ex4(:),G1H4(16),m3h3x4(:,50),heltab2x12(:,:,585))
  call Hloop_SV_T(ntryL,G1H12(188),17,ex3(:),4,G2H6(224),m3h2x6(:,354),heltab2x12(:,:,586))
  call Hloop_SV_T(ntryL,G1H12(189),17,ex3(:),4,G2H6(225),m3h2x6(:,355),heltab2x12(:,:,587))
  call Hloop_SV_T(ntryL,G1H12(190),17,ex3(:),4,G2H6(226),m3h2x6(:,356),heltab2x12(:,:,588))
  call Hloop_SV_T(ntryL,G1H12(191),17,ex3(:),4,G2H6(227),m3h2x6(:,357),heltab2x12(:,:,589))
call HGT_raise_alpha_OLR(G1H12(192),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(192),2,5,12)
  call Hloop_VV_S(ntryL,G1H12(192),ex4(:),G1H4(17),m3h3x4(:,51),heltab2x12(:,:,590))
  call Hloop_SV_T(ntryL,G1H12(194),17,ex3(:),4,G2H6(228),m3h2x6(:,358),heltab2x12(:,:,591))
  call Hloop_SV_T(ntryL,G1H12(195),17,ex3(:),4,G2H6(229),m3h2x6(:,359),heltab2x12(:,:,592))
  call Hloop_SV_T(ntryL,G1H12(196),17,ex3(:),4,G2H6(230),m3h2x6(:,360),heltab2x12(:,:,593))
  call Hloop_SV_T(ntryL,G1H12(197),17,ex3(:),4,G2H6(231),m3h2x6(:,361),heltab2x12(:,:,594))
call HGT_raise_alpha_OLR(G1H12(198),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(198),2,5,12)
  call Hloop_UW_V(ntryL,G1H12(198),-8,ex4(:),8,G2H4(31),m3h3x4(:,52),heltab2x12(:,:,595))
  call Hloop_SV_T(ntryL,G1H12(200),17,ex3(:),4,G2H6(232),m3h2x6(:,362),heltab2x12(:,:,596))
  call Hloop_SV_T(ntryL,G1H12(201),17,ex3(:),4,G2H6(233),m3h2x6(:,363),heltab2x12(:,:,597))
  call Hloop_SV_T(ntryL,G1H12(202),17,ex3(:),4,G2H6(234),m3h2x6(:,364),heltab2x12(:,:,598))
  call Hloop_SV_T(ntryL,G1H12(203),17,ex3(:),4,G2H6(235),m3h2x6(:,365),heltab2x12(:,:,599))
call HGT_raise_alpha_OLR(G1H12(204),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(204),2,5,12)
  call Hloop_UW_V(ntryL,G1H12(204),-8,ex4(:),8,G2H4(32),m3h3x4(:,53),heltab2x12(:,:,600))
  call Hloop_SV_T(ntryL,G1H12(206),17,ex3(:),4,G2H6(236),m3h2x6(:,366),heltab2x12(:,:,601))
  call Hloop_SV_T(ntryL,G1H12(207),17,ex3(:),4,G2H6(237),m3h2x6(:,367),heltab2x12(:,:,602))
  call Hloop_SV_T(ntryL,G1H12(208),17,ex3(:),4,G2H6(238),m3h2x6(:,368),heltab2x12(:,:,603))
  call Hloop_UW_V(ntryL,G1H12(209),17,ex3(:),4,G2H6(239),m3h2x6(:,369),heltab2x12(:,:,604))
call HGT_OLR(G1H12(210),1,1,12)
call HGT_invQ_OLR(G1H12(210),2,5,12)
  call Hloop_TV_S(ntryL,G1H12(210),-8,ex4(:),8,G2H4(33),m3h3x4(:,54),heltab2x12(:,:,605))
  call Hloop_UW_V(ntryL,G1H12(212),17,ex3(:),4,G2H6(240),m3h2x6(:,370),heltab2x12(:,:,606))
  call Hloop_UW_V(ntryL,G1H12(213),17,ex3(:),4,G2H6(241),m3h2x6(:,371),heltab2x12(:,:,607))
  call Hloop_UW_V(ntryL,G1H12(214),17,ex3(:),4,G2H6(242),m3h2x6(:,372),heltab2x12(:,:,608))
  call Hloop_UW_V(ntryL,G1H12(215),17,ex3(:),4,G2H6(243),m3h2x6(:,373),heltab2x12(:,:,609))
call HGT_OLR(G1H12(216),1,1,12)
call HGT_invQ_OLR(G1H12(216),2,5,12)
  call Hloop_TV_S(ntryL,G1H12(216),-8,ex4(:),8,G2H4(34),m3h3x4(:,55),heltab2x12(:,:,610))
  call Hloop_UW_V(ntryL,G1H12(69),17,ex3(:),4,G2H6(244),m3h2x6(:,374),heltab2x12(:,:,611))
  call Hloop_UW_V(ntryL,G1H12(218),17,ex3(:),4,G2H6(245),m3h2x6(:,375),heltab2x12(:,:,612))
  call Hloop_UW_V(ntryL,G1H12(70),17,ex3(:),4,G2H6(246),m3h2x6(:,376),heltab2x12(:,:,613))
  call Hloop_UW_V(ntryL,G1H12(219),17,ex3(:),4,G2H6(247),m3h2x6(:,377),heltab2x12(:,:,614))
call HGT_OLR(G1H12(71),1,1,12)
call HGT_invQ_OLR(G1H12(71),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(71),ex4(:),G1H4(18),m3h3x4(:,56),heltab2x12(:,:,615))
  call Hloop_UW_V(ntryL,G1H12(72),17,ex3(:),4,G2H6(248),m3h2x6(:,378),heltab2x12(:,:,616))
  call Hloop_UW_V(ntryL,G1H12(221),17,ex3(:),4,G2H6(249),m3h2x6(:,379),heltab2x12(:,:,617))
  call Hloop_UW_V(ntryL,G1H12(222),17,ex3(:),4,G2H6(250),m3h2x6(:,380),heltab2x12(:,:,618))
  call Hloop_QV_A(ntryL,G1H12(223),ex3(:),G1H6(11),m3h2x6(:,381),heltab2x12(:,:,619))
  call Hloop_Q_A(ntryL,G1H6(11),21,nMT,G2H6(251),n2h6(133))
call HGT_OLR(G1H12(224),1,1,12)
call HGT_invQ_OLR(G1H12(224),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(224),-2,nMB,G2H12(12),n2h12(67))
  call Hloop_AV_Q(ntryL,G2H12(12),ex2(:),G2H6(252),m3h2x6(:,382),heltab2x12(:,:,620))
  call Hloop_QV_A(ntryL,G1H12(226),ex3(:),G1H6(26),m3h2x6(:,383),heltab2x12(:,:,621))
  call Hloop_Q_A(ntryL,G1H6(26),21,nMT,G2H6(253),n2h6(134))
  call Hloop_QV_A(ntryL,G1H12(227),ex3(:),G1H6(113),m3h2x6(:,384),heltab2x12(:,:,622))
  call Hloop_Q_A(ntryL,G1H6(113),21,nMT,G2H6(254),n2h6(135))
  call Hloop_QV_A(ntryL,G1H12(228),ex3(:),G1H6(13),m3h2x6(:,385),heltab2x12(:,:,623))
  call Hloop_Q_A(ntryL,G1H6(13),21,nMT,G2H6(255),n2h6(136))
  call Hloop_AV_Q(ntryL,G1H12(229),ex3(:),G1H6(114),m3h2x6(:,386),heltab2x12(:,:,624))
  call Hloop_A_Q(ntryL,G1H6(114),21,nMB,G2H6(256),n2h6(137))
call HGT_OLR(G1H12(230),1,1,12)
call HGT_invQ_OLR(G1H12(230),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(230),-2,nMT,G2H12(13),n2h12(68))
  call Hloop_QV_A(ntryL,G2H12(13),ex2(:),G2H6(257),m3h2x6(:,387),heltab2x12(:,:,625))
  call Hloop_AV_Q(ntryL,G1H12(232),ex3(:),G1H6(105),m3h2x6(:,388),heltab2x12(:,:,626))
  call Hloop_A_Q(ntryL,G1H6(105),21,nMB,G2H6(258),n2h6(138))
  call Hloop_AV_Q(ntryL,G1H12(233),ex3(:),G1H6(115),m3h2x6(:,389),heltab2x12(:,:,627))
  call Hloop_A_Q(ntryL,G1H6(115),21,nMB,G2H6(259),n2h6(139))
  call Hloop_AV_Q(ntryL,G1H12(234),ex3(:),G1H6(20),m3h2x6(:,390),heltab2x12(:,:,628))
  call Hloop_A_Q(ntryL,G1H6(20),21,nMB,G2H6(260),n2h6(140))
  call Hloop_AW_Q(ntryL,G1H12(235),ex4(:),G1H4(19),m3h3x4(:,57),heltab2x12(:,:,629))
  call Hloop_A_Q(ntryL,G1H4(19),25,nMT,G2H4(35),n2h4(1))
call HGT_OLR(G1H12(236),1,1,12)
call HGT_invQ_OLR(G1H12(236),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(236),-4,nMT,G2H12(14),n2h12(69))
  call Hloop_QV_A(ntryL,G2H12(14),ex3(:),G2H6(261),m3h2x6(:,391),heltab2x12(:,:,630))
  call Hloop_AW_Q(ntryL,G1H12(238),ex4(:),G1H4(19),m3h3x4(:,58),heltab2x12(:,:,631))
  call Hloop_A_Q(ntryL,G1H4(19),25,nMT,G2H4(36),n2h4(2))
  call Hloop_AW_Q(ntryL,G1H12(239),ex4(:),G1H4(19),m3h3x4(:,59),heltab2x12(:,:,632))
  call Hloop_A_Q(ntryL,G1H4(19),25,nMT,G2H4(37),n2h4(3))
  call Hloop_AW_Q(ntryL,G1H12(87),ex4(:),G1H4(19),m3h3x4(:,60),heltab2x12(:,:,633))
  call Hloop_A_Q(ntryL,G1H4(19),25,nMT,G2H4(38),n2h4(4))
  call Hloop_QW_A(ntryL,G1H12(240),ex4(:),G1H4(19),m3h3x4(:,61),heltab2x12(:,:,634))
  call Hloop_Q_A(ntryL,G1H4(19),25,nMB,G2H4(39),n2h4(5))
call HGT_OLR(G1H12(88),1,1,12)
call HGT_invQ_OLR(G1H12(88),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(88),-4,nMB,G2H12(8),n2h12(70))
  call Hloop_AV_Q(ntryL,G2H12(8),ex3(:),G2H6(262),m3h2x6(:,392),heltab2x12(:,:,635))
  call Hloop_QW_A(ntryL,G1H12(242),ex4(:),G1H4(19),m3h3x4(:,62),heltab2x12(:,:,636))
  call Hloop_Q_A(ntryL,G1H4(19),25,nMB,G2H4(40),n2h4(6))
  call Hloop_QW_A(ntryL,G1H12(243),ex4(:),G1H4(19),m3h3x4(:,63),heltab2x12(:,:,637))
  call Hloop_Q_A(ntryL,G1H4(19),25,nMB,G2H4(41),n2h4(7))
  call Hloop_QW_A(ntryL,G1H12(244),ex4(:),G1H4(19),m3h3x4(:,64),heltab2x12(:,:,638))
  call Hloop_Q_A(ntryL,G1H4(19),25,nMB,G2H4(42),n2h4(8))
  call Hloop_TV_S(ntryL,G1H12(245),17,ex4(:),8,G2H4(43),m3h3x4(:,65),heltab2x12(:,:,639))
call HGT_raise_alpha_OLR(G1H12(246),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(246),2,5,12)
  call Hloop_VV_S(ntryL,G1H12(246),ex3(:),G1H6(116),m3h2x6(:,393),heltab2x12(:,:,640))
  call Hloop_TV_S(ntryL,G1H12(248),17,ex4(:),8,G2H4(44),m3h3x4(:,66),heltab2x12(:,:,641))
  call Hloop_TV_S(ntryL,G1H12(249),17,ex4(:),8,G2H4(45),m3h3x4(:,67),heltab2x12(:,:,642))
  call Hloop_TV_S(ntryL,G1H12(250),17,ex4(:),8,G2H4(46),m3h3x4(:,68),heltab2x12(:,:,643))
  call Hloop_UW_V(ntryL,G1H12(251),17,ex4(:),8,G2H4(47),m3h3x4(:,69),heltab2x12(:,:,644))
call HGT_OLR(G1H12(252),1,1,12)
call HGT_invQ_OLR(G1H12(252),2,5,12)
  call Hloop_SV_T(ntryL,G1H12(252),-4,ex3(:),4,G2H6(263),m3h2x6(:,394),heltab2x12(:,:,645))
  call Hloop_UW_V(ntryL,G1H12(254),17,ex4(:),8,G2H4(48),m3h3x4(:,70),heltab2x12(:,:,646))
  call Hloop_UW_V(ntryL,G1H12(255),17,ex4(:),8,G2H4(49),m3h3x4(:,71),heltab2x12(:,:,647))
  call Hloop_UW_V(ntryL,G1H12(256),17,ex4(:),8,G2H4(50),m3h3x4(:,72),heltab2x12(:,:,648))
  call Hloop_TV_S(ntryL,G1H12(257),17,ex4(:),8,G2H4(51),m3h3x4(:,73),heltab2x12(:,:,649))
call HGT_raise_alpha_OLR(G1H12(258),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(258),2,5,12)
  call Hloop_UW_V(ntryL,G1H12(258),-4,ex3(:),4,G2H6(264),m3h2x6(:,395),heltab2x12(:,:,650))
  call Hloop_TV_S(ntryL,G1H12(10),17,ex4(:),8,G2H4(52),m3h3x4(:,74),heltab2x12(:,:,651))
  call Hloop_TV_S(ntryL,G1H12(11),17,ex4(:),8,G2H4(53),m3h3x4(:,75),heltab2x12(:,:,652))
  call Hloop_TV_S(ntryL,G1H12(12),17,ex4(:),8,G2H4(54),m3h3x4(:,76),heltab2x12(:,:,653))
  call Hloop_UW_V(ntryL,G1H12(13),17,ex4(:),8,G2H4(55),m3h3x4(:,77),heltab2x12(:,:,654))
call HGT_OLR(G1H12(16),1,1,12)
call HGT_invQ_OLR(G1H12(16),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(16),ex3(:),G1H6(7),m3h2x6(:,396),heltab2x12(:,:,655))
  call Hloop_UW_V(ntryL,G1H12(20),17,ex4(:),8,G2H4(56),m3h3x4(:,78),heltab2x12(:,:,656))
  call Hloop_UW_V(ntryL,G1H12(22),17,ex4(:),8,G2H4(57),m3h3x4(:,79),heltab2x12(:,:,657))
  call Hloop_UW_V(ntryL,G1H12(23),17,ex4(:),8,G2H4(58),m3h3x4(:,80),heltab2x12(:,:,658))
  call Hloop_AW_Q(ntryL,G1H12(24),ex4(:),G1H4(19),m3h3x4(:,81),heltab2x12(:,:,659))
  call Hloop_A_Q(ntryL,G1H4(19),25,nMT,G2H4(59),n2h4(9))
call HGT_OLR(G1H12(25),1,1,12)
call HGT_invQ_OLR(G1H12(25),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(25),-2,nMT,G2H12(9),n2h12(75))
  call Hloop_QV_A(ntryL,G2H12(9),ex2(:),G2H6(265),m3h2x6(:,397),heltab2x12(:,:,660))
  call Hloop_AW_Q(ntryL,G1H12(45),ex4(:),G1H4(19),m3h3x4(:,82),heltab2x12(:,:,661))
  call Hloop_A_Q(ntryL,G1H4(19),25,nMT,G2H4(60),n2h4(10))
  call Hloop_AW_Q(ntryL,G1H12(46),ex4(:),G1H4(19),m3h3x4(:,83),heltab2x12(:,:,662))
  call Hloop_A_Q(ntryL,G1H4(19),25,nMT,G2H4(61),n2h4(11))
  call Hloop_AW_Q(ntryL,G1H12(47),ex4(:),G1H4(19),m3h3x4(:,84),heltab2x12(:,:,663))
  call Hloop_A_Q(ntryL,G1H4(19),25,nMT,G2H4(62),n2h4(12))
  call Hloop_QW_A(ntryL,G1H12(48),ex4(:),G1H4(19),m3h3x4(:,85),heltab2x12(:,:,664))
  call Hloop_Q_A(ntryL,G1H4(19),25,nMB,G2H4(63),n2h4(13))
call HGT_OLR(G1H12(51),1,1,12)
call HGT_invQ_OLR(G1H12(51),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(51),-2,nMB,G2H12(10),n2h12(76))
  call Hloop_AV_Q(ntryL,G2H12(10),ex2(:),G2H6(266),m3h2x6(:,398),heltab2x12(:,:,665))
  call Hloop_QW_A(ntryL,G1H12(55),ex4(:),G1H4(19),m3h3x4(:,86),heltab2x12(:,:,666))
  call Hloop_Q_A(ntryL,G1H4(19),25,nMB,G2H4(64),n2h4(14))
  call Hloop_QW_A(ntryL,G1H12(57),ex4(:),G1H4(19),m3h3x4(:,87),heltab2x12(:,:,667))
  call Hloop_Q_A(ntryL,G1H4(19),25,nMB,G2H4(65),n2h4(15))
  call Hloop_QW_A(ntryL,G1H12(58),ex4(:),G1H4(19),m3h3x4(:,88),heltab2x12(:,:,668))
  call Hloop_Q_A(ntryL,G1H4(19),25,nMB,G2H4(66),n2h4(16))
  call Hloop_TV_S(ntryL,G1H12(59),17,ex4(:),8,G2H4(67),m3h3x4(:,89),heltab2x12(:,:,669))
call HGT_raise_alpha_OLR(G1H12(60),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(60),2,5,12)
  call Hloop_VV_S(ntryL,G1H12(60),ex2(:),G1H6(117),m3h2x6(:,399),heltab2x12(:,:,670))
  call Hloop_TV_S(ntryL,G1H12(80),17,ex4(:),8,G2H4(68),m3h3x4(:,90),heltab2x12(:,:,671))
  call Hloop_TV_S(ntryL,G1H12(90),17,ex4(:),8,G2H4(69),m3h3x4(:,91),heltab2x12(:,:,672))
  call Hloop_TV_S(ntryL,G1H12(96),17,ex4(:),8,G2H4(70),m3h3x4(:,92),heltab2x12(:,:,673))
  call Hloop_UW_V(ntryL,G1H12(15),17,ex4(:),8,G2H4(71),m3h3x4(:,93),heltab2x12(:,:,674))
call HGT_OLR(G1H12(5),1,1,12)
call HGT_invQ_OLR(G1H12(5),2,5,12)
  call Hloop_SV_T(ntryL,G1H12(5),-2,ex2(:),2,G2H6(267),m3h2x6(:,400),heltab2x12(:,:,675))
  call Hloop_UW_V(ntryL,G1H12(7),17,ex4(:),8,G2H4(72),m3h3x4(:,94),heltab2x12(:,:,676))
  call Hloop_UW_V(ntryL,G1H12(8),17,ex4(:),8,G2H4(73),m3h3x4(:,95),heltab2x12(:,:,677))
  call Hloop_UW_V(ntryL,G1H12(9),17,ex4(:),8,G2H4(74),m3h3x4(:,96),heltab2x12(:,:,678))
  call Hloop_TV_S(ntryL,G1H12(28),17,ex4(:),8,G2H4(75),m3h3x4(:,97),heltab2x12(:,:,679))
call HGT_raise_alpha_OLR(G1H12(29),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(29),2,5,12)
  call Hloop_UW_V(ntryL,G1H12(29),-2,ex2(:),2,G2H6(268),m3h2x6(:,401),heltab2x12(:,:,680))
  call Hloop_TV_S(ntryL,G1H12(18),17,ex4(:),8,G2H4(76),m3h3x4(:,98),heltab2x12(:,:,681))
  call Hloop_TV_S(ntryL,G1H12(14),17,ex4(:),8,G2H4(77),m3h3x4(:,99),heltab2x12(:,:,682))
  call Hloop_TV_S(ntryL,G1H12(21),17,ex4(:),8,G2H4(78),m3h3x4(:,100),heltab2x12(:,:,683))
  call Hloop_UW_V(ntryL,G1H12(26),17,ex4(:),8,G2H4(79),m3h3x4(:,101),heltab2x12(:,:,684))
call HGT_OLR(G1H12(27),1,1,12)
call HGT_invQ_OLR(G1H12(27),2,5,12)
  call Hloop_SV_V(ntryL,G1H12(27),ex2(:),G1H6(119),m3h2x6(:,402),heltab2x12(:,:,685))
  call Hloop_UW_V(ntryL,G1H12(31),17,ex4(:),8,G2H4(80),m3h3x4(:,102),heltab2x12(:,:,686))
  call Hloop_UW_V(ntryL,G1H12(32),17,ex4(:),8,G2H4(81),m3h3x4(:,103),heltab2x12(:,:,687))
  call Hloop_UW_V(ntryL,G1H12(33),17,ex4(:),8,G2H4(82),m3h3x4(:,104),heltab2x12(:,:,688))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(10),[G2H6(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(11),[G2H6(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(16),[G2H6(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(17),[G2H6(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(93),[G1H6(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(97),[G1H6(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(12),[G2H6(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(105),[G1H6(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(109),[G1H6(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(15),[G2H6(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(18),[G2H6(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(88),[G1H6(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(89),[G1H6(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(101),[G1H6(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(28),[G2H6(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(29),[G2H6(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(33),[G2H6(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(34),[G2H6(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(137),[G1H6(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(141),[G1H6(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(32),[G2H6(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(145),[G1H6(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(149),[G1H6(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(35),[G2H6(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(36),[G2H6(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(125),[G1H6(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(129),[G1H6(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(133),[G1H6(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(5),[G2H3(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(6),[G2H3(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(41),[G1H3(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(45),[G1H3(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(9),[G2H3(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(10),[G2H3(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(12),[G2H3(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(13),[G2H3(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(73),[G1H3(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(77),[G1H3(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(81),[G1H3(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(14),[G2H3(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(65),[G1H3(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(69),[G1H3(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(46),[G2H6(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(47),[G2H6(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(51),[G2H6(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(52),[G2H6(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(50),[G2H6(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(189),[G1H6(245)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(193),[G1H6(246)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(53),[G2H6(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(54),[G2H6(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(197),[G1H6(247)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(173),[G1H6(248)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(177),[G1H6(249)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(181),[G1H6(250)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(185),[G1H6(251)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(19),[G2H3(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(20),[G2H3(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(99),[G1H3(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(103),[G1H3(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(23),[G2H3(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(24),[G2H3(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(26),[G2H3(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(27),[G2H3(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(131),[G1H3(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(135),[G1H3(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(139),[G1H3(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(28),[G2H3(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(123),[G1H3(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(127),[G1H3(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(64),[G2H6(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(65),[G2H6(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(69),[G2H6(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(70),[G2H6(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(68),[G2H6(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(239),[G1H6(334)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(243),[G1H6(335)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(71),[G2H6(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(72),[G2H6(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(247),[G1H6(336)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(223),[G1H6(337)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(227),[G1H6(338)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(231),[G1H6(339)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(235),[G1H6(340)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G2H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G2H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(43),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(51),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G2H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(19),[G2H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(67),[G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(75),[G1H4(12)])
  call Hotf_5pt_reduction(G2H6(10),RedSet_5(1),mass5set(:,4),  & 
G1H6(21),G1H6(120),G1H6(341),G1H6(121),G1H6(23),G1H6(122),6)
  call HG1shiftOLR(G1H6(120),8,6)
  call Hotf_5pt_reduction(G2H6(11),RedSet_5(1),mass5set(:,5),  & 
G1H6(8),G1H6(123),G1H6(125),G1H6(27),G1H6(126),G1H6(29),6)
  call HG1shiftOLR(G1H6(123),8,6)
  call Hotf_5pt_reduction(G2H6(3),RedSet_5(1),mass5set(:,6),  & 
G1H6(127),G1H6(1),G1H6(34),G1H6(129),G1H6(131),G1H6(132),6)
  call HG1shiftOLR(G1H6(1),8,6)
  call Hotf_5pt_reduction(G2H6(4),RedSet_5(1),mass5set(:,5),  & 
G1H6(133),G1H6(134),G1H6(135),G1H6(137),G1H6(138),G1H6(139),6)
  call HG1shiftOLR(G1H6(134),8,6)
  call Hotf_5pt_reduction(G2H6(5),RedSet_5(1),mass5set(:,6),  & 
G1H6(41),G1H6(42),G1H6(46),G1H6(140),G1H6(141),G1H6(142),6)
  call HG1shiftOLR(G1H6(42),8,6)
  call Hotf_5pt_reduction(G2H6(6),RedSet_5(1),mass5set(:,5),  & 
G1H6(143),G1H6(145),G1H6(146),G1H6(147),G1H6(148),G1H6(149),6)
  call HG1shiftOLR(G1H6(145),8,6)
  call Hotf_5pt_reduction(G2H6(16),RedSet_5(1),mass5set(:,6),  & 
G1H6(151),G1H6(152),G1H6(153),G1H6(40),G1H6(50),G1H6(154),6)
  call HG1shiftOLR(G1H6(152),8,6)
  call Hotf_5pt_reduction(G2H6(17),RedSet_5(1),mass5set(:,5),  & 
G1H6(155),G1H6(156),G1H6(157),G1H6(158),G1H6(160),G1H6(161),6)
  call HG1shiftOLR(G1H6(156),8,6)
  call Hotf_5pt_reduction(G2H6(93),RedSet_5(1),mass5set(:,6),  & 
G1H6(162),G1H6(52),G1H6(164),G1H6(166),G1H6(167),G1H6(168),6)
  call HG1shiftOLR(G1H6(52),8,6)
  call Hotf_5pt_reduction(G2H6(97),RedSet_5(1),mass5set(:,5),  & 
G1H6(169),G1H6(170),G1H6(172),G1H6(173),G1H6(174),G1H6(175),6)
  call HG1shiftOLR(G1H6(170),8,6)
  call Hloop_SV_V(ntryL,G2H6(12),ex2(:),G2H3(1),m3h2x3(:,159),heltab2x6(:,:,353))
  call Hloop_SV_V(ntryL,G2H6(105),ex2(:),G2H3(2),m3h2x3(:,160),heltab2x6(:,:,354))
  call Hloop_SV_V(ntryL,G2H6(109),ex2(:),G2H3(3),m3h2x3(:,161),heltab2x6(:,:,355))
  call Hloop_VV_S(ntryL,G2H6(15),ex2(:),G2H3(4),m3h2x3(:,162),heltab2x6(:,:,356))
  call Hloop_VV_S(ntryL,G2H6(18),ex2(:),G2H3(7),m3h2x3(:,163),heltab2x6(:,:,357))
  call Hloop_VV_S(ntryL,G2H6(88),ex2(:),G2H3(8),m3h2x3(:,164),heltab2x6(:,:,358))
  call Hloop_VV_S(ntryL,G2H6(89),ex2(:),G2H3(11),m3h2x3(:,165),heltab2x6(:,:,359))
  call Hotf_5pt_reduction(G2H6(101),RedSet_5(1),mass5set(:,4),  & 
G1H6(176),G1H6(178),G1H6(179),G1H6(180),G1H6(181),G1H6(182),6)
  call HG1shiftOLR(G1H6(178),8,6)
  call Hotf_5pt_reduction(G2H6(28),RedSet_5(2),mass5set(:,4),  & 
G1H6(184),G1H6(185),G1H6(186),G1H6(187),G1H6(188),G1H6(190),6)
  call HG1shiftOLR(G1H6(185),8,6)
  call Hotf_5pt_reduction(G2H6(29),RedSet_5(2),mass5set(:,5),  & 
G1H6(191),G1H6(192),G1H6(193),G1H6(194),G1H6(196),G1H6(197),6)
  call HG1shiftOLR(G1H6(192),8,6)
  call Hotf_5pt_reduction(G2H6(21),RedSet_5(2),mass5set(:,6),  & 
G1H6(198),G1H6(199),G1H6(200),G1H6(202),G1H6(203),G1H6(204),6)
  call HG1shiftOLR(G1H6(199),8,6)
  call Hotf_5pt_reduction(G2H6(22),RedSet_5(2),mass5set(:,5),  & 
G1H6(205),G1H6(206),G1H6(208),G1H6(209),G1H6(210),G1H6(211),6)
  call HG1shiftOLR(G1H6(206),8,6)
  call Hotf_5pt_reduction(G2H6(23),RedSet_5(2),mass5set(:,6),  & 
G1H6(212),G1H6(214),G1H6(215),G1H6(216),G1H6(217),G1H6(218),6)
  call HG1shiftOLR(G1H6(214),8,6)
  call Hotf_5pt_reduction(G2H6(24),RedSet_5(2),mass5set(:,5),  & 
G1H6(220),G1H6(221),G1H6(222),G1H6(223),G1H6(224),G1H6(226),6)
  call HG1shiftOLR(G1H6(221),8,6)
  call Hotf_5pt_reduction(G2H6(33),RedSet_5(2),mass5set(:,6),  & 
G1H6(227),G1H6(228),G1H6(57),G1H6(58),G1H6(56),G1H6(229),6)
  call HG1shiftOLR(G1H6(228),8,6)
  call Hotf_5pt_reduction(G2H6(34),RedSet_5(2),mass5set(:,5),  & 
G1H6(230),G1H6(67),G1H6(68),G1H6(70),G1H6(71),G1H6(72),6)
  call HG1shiftOLR(G1H6(67),8,6)
  call Hotf_5pt_reduction(G2H6(137),RedSet_5(2),mass5set(:,6),  & 
G1H6(66),G1H6(231),G1H6(233),G1H6(234),G1H6(235),G1H6(76),6)
  call HG1shiftOLR(G1H6(231),8,6)
  call Hotf_5pt_reduction(G2H6(141),RedSet_5(2),mass5set(:,5),  & 
G1H6(31),G1H6(77),G1H6(236),G1H6(10),G1H6(237),G1H6(32),6)
  call HG1shiftOLR(G1H6(77),8,6)
  call Hloop_SV_V(ntryL,G2H6(32),ex3(:),G2H3(15),m3h2x3(:,166),heltab2x6(:,:,360))
  call Hloop_SV_V(ntryL,G2H6(145),ex3(:),G2H3(16),m3h2x3(:,167),heltab2x6(:,:,361))
  call Hloop_SV_V(ntryL,G2H6(149),ex3(:),G2H3(17),m3h2x3(:,168),heltab2x6(:,:,362))
  call Hloop_VV_S(ntryL,G2H6(35),ex3(:),G2H3(18),m3h2x3(:,169),heltab2x6(:,:,363))
  call Hloop_VV_S(ntryL,G2H6(36),ex3(:),G2H3(21),m3h2x3(:,170),heltab2x6(:,:,364))
  call Hloop_VV_S(ntryL,G2H6(125),ex3(:),G2H3(22),m3h2x3(:,171),heltab2x6(:,:,365))
  call Hloop_VV_S(ntryL,G2H6(129),ex3(:),G2H3(25),m3h2x3(:,172),heltab2x6(:,:,366))
  call Hotf_5pt_reduction(G2H6(133),RedSet_5(2),mass5set(:,4),  & 
G1H6(238),G1H6(3),G1H6(239),G1H6(37),G1H6(240),G1H6(242),6)
  call HG1shiftOLR(G1H6(3),8,6)
  call Hloop_SS_S(ntryL,G2H3(5),ex1(:),G2H3(145),m3h1x3(:,1),heltab2x3(:,:,1))
  call Hloop_SS_S(ntryL,G2H3(6),ex1(:),G2H3(5),m3h1x3(:,2),heltab2x3(:,:,2))
  call Hloop_SS_S(ntryL,G2H3(41),ex1(:),G2H3(6),m3h1x3(:,3),heltab2x3(:,:,3))
  call Hloop_SS_S(ntryL,G2H3(45),ex1(:),G2H3(41),m3h1x3(:,4),heltab2x3(:,:,4))
  call Hotf_5pt_reduction(G2H3(9),RedSet_5(3),mass5set(:,4),  & 
G1H3(15),G1H3(1),G1H3(2),G1H3(3),G1H3(4),G1H3(5),3)
  call HG1shiftOLR(G1H3(1),8,3)
  call Hotf_5pt_reduction(G2H3(10),RedSet_5(3),mass5set(:,5),  & 
G1H3(6),G1H3(7),G1H3(8),G1H3(9),G1H3(10),G1H3(11),3)
  call HG1shiftOLR(G1H3(7),8,3)
  call Hotf_5pt_reduction(G2H3(12),RedSet_5(3),mass5set(:,6),  & 
G1H3(12),G1H3(13),G1H3(14),G1H3(16),G1H3(17),G1H3(18),3)
  call HG1shiftOLR(G1H3(13),8,3)
  call Hotf_5pt_reduction(G2H3(13),RedSet_5(3),mass5set(:,5),  & 
G1H3(19),G1H3(20),G1H3(21),G1H3(22),G1H3(23),G1H3(24),3)
  call HG1shiftOLR(G1H3(20),8,3)
  call Hotf_5pt_reduction(G2H3(73),RedSet_5(3),mass5set(:,4),  & 
G1H3(25),G1H3(26),G1H3(27),G1H3(28),G1H3(29),G1H3(30),3)
  call HG1shiftOLR(G1H3(26),8,3)
  call Hotf_5pt_reduction(G2H3(77),RedSet_5(3),mass5set(:,6),  & 
G1H3(31),G1H3(32),G1H3(33),G1H3(34),G1H3(35),G1H3(36),3)
  call HG1shiftOLR(G1H3(32),8,3)
  call Hotf_5pt_reduction(G2H3(81),RedSet_5(3),mass5set(:,5),  & 
G1H3(37),G1H3(38),G1H3(39),G1H3(40),G1H3(41),G1H3(42),3)
  call HG1shiftOLR(G1H3(38),8,3)
  call Hloop_VS_V(ntryL,G2H3(14),ex1(:),G2H3(45),m3h1x3(:,5),heltab2x3(:,:,5))
  call Hloop_VS_V(ntryL,G2H3(65),ex1(:),G2H3(9),m3h1x3(:,6),heltab2x3(:,:,6))
  call Hloop_VS_V(ntryL,G2H3(69),ex1(:),G2H3(10),m3h1x3(:,7),heltab2x3(:,:,7))
  call Hotf_5pt_reduction(G2H6(46),RedSet_5(5),mass5set(:,4),  & 
G1H6(39),G1H6(243),G1H6(44),G1H6(244),G1H6(48),G1H6(53),6)
  call HG1shiftOLR(G1H6(243),8,6)
  call Hotf_5pt_reduction(G2H6(47),RedSet_5(5),mass5set(:,5),  & 
G1H6(54),G1H6(55),G1H6(61),G1H6(62),G1H6(63),G1H6(73),6)
  call HG1shiftOLR(G1H6(55),8,6)
  call Hotf_5pt_reduction(G2H6(39),RedSet_5(5),mass5set(:,6),  & 
G1H6(74),G1H6(79),G1H6(80),G1H6(81),G1H6(86),G1H6(87),6)
  call HG1shiftOLR(G1H6(79),8,6)
  call Hotf_5pt_reduction(G2H6(40),RedSet_5(5),mass5set(:,5),  & 
G1H6(89),G1H6(90),G1H6(91),G1H6(99),G1H6(100),G1H6(5),6)
  call HG1shiftOLR(G1H6(90),8,6)
  call Hotf_5pt_reduction(G2H6(41),RedSet_5(5),mass5set(:,6),  & 
G1H6(6),G1H6(252),G1H6(253),G1H6(255),G1H6(256),G1H6(257),6)
  call HG1shiftOLR(G1H6(252),8,6)
  call Hotf_5pt_reduction(G2H6(42),RedSet_5(5),mass5set(:,5),  & 
G1H6(258),G1H6(259),G1H6(261),G1H6(262),G1H6(263),G1H6(264),6)
  call HG1shiftOLR(G1H6(259),8,6)
  call Hotf_5pt_reduction(G2H6(51),RedSet_5(5),mass5set(:,6),  & 
G1H6(265),G1H6(267),G1H6(268),G1H6(269),G1H6(270),G1H6(271),6)
  call HG1shiftOLR(G1H6(267),8,6)
  call Hotf_5pt_reduction(G2H6(52),RedSet_5(5),mass5set(:,5),  & 
G1H6(273),G1H6(274),G1H6(275),G1H6(276),G1H6(277),G1H6(279),6)
  call HG1shiftOLR(G1H6(274),8,6)
  call Hloop_SV_V(ntryL,G2H6(50),ex3(:),G2H3(12),m3h2x3(:,173),heltab2x6(:,:,367))
  call Hloop_VV_S(ntryL,G2H6(189),ex3(:),G2H3(13),m3h2x3(:,174),heltab2x6(:,:,368))
  call Hloop_VV_S(ntryL,G2H6(193),ex3(:),G2H3(73),m3h2x3(:,175),heltab2x6(:,:,369))
  call Hloop_VV_S(ntryL,G2H6(53),ex3(:),G2H3(77),m3h2x3(:,176),heltab2x6(:,:,370))
  call Hloop_VV_S(ntryL,G2H6(54),ex3(:),G2H3(81),m3h2x3(:,177),heltab2x6(:,:,371))
  call Hotf_5pt_reduction(G2H6(197),RedSet_5(5),mass5set(:,4),  & 
G1H6(280),G1H6(281),G1H6(282),G1H6(283),G1H6(285),G1H6(286),6)
  call HG1shiftOLR(G1H6(281),8,6)
  call Hotf_5pt_reduction(G2H6(173),RedSet_5(5),mass5set(:,6),  & 
G1H6(287),G1H6(288),G1H6(289),G1H6(291),G1H6(292),G1H6(293),6)
  call HG1shiftOLR(G1H6(288),8,6)
  call Hotf_5pt_reduction(G2H6(177),RedSet_5(5),mass5set(:,5),  & 
G1H6(294),G1H6(295),G1H6(297),G1H6(298),G1H6(299),G1H6(300),6)
  call HG1shiftOLR(G1H6(295),8,6)
  call Hloop_SV_V(ntryL,G2H6(181),ex3(:),G2H3(14),m3h2x3(:,178),heltab2x6(:,:,372))
  call Hloop_SV_V(ntryL,G2H6(185),ex3(:),G2H3(65),m3h2x3(:,179),heltab2x6(:,:,373))
  call Hloop_SS_S(ntryL,G2H3(19),ex1(:),G2H3(69),m3h1x3(:,8),heltab2x3(:,:,8))
  call Hloop_SS_S(ntryL,G2H3(20),ex1(:),G2H3(19),m3h1x3(:,9),heltab2x3(:,:,9))
  call Hloop_SS_S(ntryL,G2H3(99),ex1(:),G2H3(20),m3h1x3(:,10),heltab2x3(:,:,10))
  call Hloop_SS_S(ntryL,G2H3(103),ex1(:),G2H3(99),m3h1x3(:,11),heltab2x3(:,:,11))
  call Hotf_5pt_reduction(G2H3(23),RedSet_5(7),mass5set(:,4),  & 
G1H3(43),G1H3(44),G1H3(45),G1H3(46),G1H3(47),G1H3(48),3)
  call HG1shiftOLR(G1H3(44),8,3)
  call Hotf_5pt_reduction(G2H3(24),RedSet_5(7),mass5set(:,5),  & 
G1H3(49),G1H3(50),G1H3(51),G1H3(52),G1H3(53),G1H3(54),3)
  call HG1shiftOLR(G1H3(50),8,3)
  call Hotf_5pt_reduction(G2H3(26),RedSet_5(7),mass5set(:,6),  & 
G1H3(55),G1H3(56),G1H3(57),G1H3(58),G1H3(59),G1H3(60),3)
  call HG1shiftOLR(G1H3(56),8,3)
  call Hotf_5pt_reduction(G2H3(27),RedSet_5(7),mass5set(:,5),  & 
G1H3(61),G1H3(62),G1H3(63),G1H3(64),G1H3(65),G1H3(66),3)
  call HG1shiftOLR(G1H3(62),8,3)
  call Hotf_5pt_reduction(G2H3(131),RedSet_5(7),mass5set(:,4),  & 
G1H3(67),G1H3(68),G1H3(69),G1H3(70),G1H3(71),G1H3(72),3)
  call HG1shiftOLR(G1H3(68),8,3)
  call Hotf_5pt_reduction(G2H3(135),RedSet_5(7),mass5set(:,6),  & 
G1H3(73),G1H3(74),G1H3(75),G1H3(76),G1H3(77),G1H3(78),3)
  call HG1shiftOLR(G1H3(74),8,3)
  call Hotf_5pt_reduction(G2H3(139),RedSet_5(7),mass5set(:,5),  & 
G1H3(79),G1H3(80),G1H3(81),G1H3(82),G1H3(83),G1H3(84),3)
  call HG1shiftOLR(G1H3(80),8,3)
  call Hloop_VS_V(ntryL,G2H3(28),ex1(:),G2H3(103),m3h1x3(:,12),heltab2x3(:,:,12))
  call Hloop_VS_V(ntryL,G2H3(123),ex1(:),G2H3(23),m3h1x3(:,13),heltab2x3(:,:,13))
  call Hloop_VS_V(ntryL,G2H3(127),ex1(:),G2H3(24),m3h1x3(:,14),heltab2x3(:,:,14))
  call Hotf_5pt_reduction(G2H6(64),RedSet_5(9),mass5set(:,4),  & 
G1H6(301),G1H6(303),G1H6(304),G1H6(305),G1H6(306),G1H6(307),6)
  call HG1shiftOLR(G1H6(303),8,6)
  call Hotf_5pt_reduction(G2H6(65),RedSet_5(9),mass5set(:,5),  & 
G1H6(309),G1H6(310),G1H6(311),G1H6(312),G1H6(313),G1H6(315),6)
  call HG1shiftOLR(G1H6(310),8,6)
  call Hotf_5pt_reduction(G2H6(58),RedSet_5(9),mass5set(:,6),  & 
G1H6(316),G1H6(317),G1H6(83),G1H6(84),G1H6(82),G1H6(318),6)
  call HG1shiftOLR(G1H6(317),8,6)
  call Hotf_5pt_reduction(G2H6(59),RedSet_5(9),mass5set(:,5),  & 
G1H6(319),G1H6(93),G1H6(94),G1H6(96),G1H6(97),G1H6(98),6)
  call HG1shiftOLR(G1H6(93),8,6)
  call Hotf_5pt_reduction(G2H6(57),RedSet_5(9),mass5set(:,6),  & 
G1H6(92),G1H6(320),G1H6(322),G1H6(323),G1H6(324),G1H6(102),6)
  call HG1shiftOLR(G1H6(320),8,6)
  call Hotf_5pt_reduction(G2H6(60),RedSet_5(9),mass5set(:,5),  & 
G1H6(103),G1H6(325),G1H6(326),G1H6(327),G1H6(328),G1H6(329),6)
  call HG1shiftOLR(G1H6(325),8,6)
  call Hotf_5pt_reduction(G2H6(69),RedSet_5(9),mass5set(:,6),  & 
G1H6(331),G1H6(332),G1H6(333),G1H6(9),G1H6(16),G1H6(17),6)
  call HG1shiftOLR(G1H6(332),8,6)
  call Hotf_5pt_reduction(G2H6(70),RedSet_5(9),mass5set(:,5),  & 
G1H6(19),G1H6(22),G1H6(14),G1H6(106),G1H6(107),G1H6(109),6)
  call HG1shiftOLR(G1H6(22),8,6)
  call Hloop_SV_V(ntryL,G2H6(68),ex2(:),G2H3(26),m3h2x3(:,180),heltab2x6(:,:,374))
  call Hloop_VV_S(ntryL,G2H6(239),ex2(:),G2H3(27),m3h2x3(:,181),heltab2x6(:,:,375))
  call Hloop_VV_S(ntryL,G2H6(243),ex2(:),G2H3(131),m3h2x3(:,182),heltab2x6(:,:,376))
  call Hloop_VV_S(ntryL,G2H6(71),ex2(:),G2H3(135),m3h2x3(:,183),heltab2x6(:,:,377))
  call Hloop_VV_S(ntryL,G2H6(72),ex2(:),G2H3(139),m3h2x3(:,184),heltab2x6(:,:,378))
  call Hotf_5pt_reduction(G2H6(247),RedSet_5(9),mass5set(:,4),  & 
G1H6(110),G1H6(111),G1H6(25),G1H6(11),G1H6(26),G1H6(113),6)
  call HG1shiftOLR(G1H6(111),8,6)
  call Hotf_5pt_reduction(G2H6(223),RedSet_5(9),mass5set(:,6),  & 
G1H6(13),G1H6(114),G1H6(105),G1H6(115),G1H6(20),G1H6(35),6)
  call HG1shiftOLR(G1H6(114),8,6)
  call Hotf_5pt_reduction(G2H6(227),RedSet_5(9),mass5set(:,5),  & 
G1H6(36),G1H6(64),G1H6(65),G1H6(4),G1H6(15),G1H6(24),6)
  call HG1shiftOLR(G1H6(64),8,6)
  call Hloop_SV_V(ntryL,G2H6(231),ex2(:),G2H3(28),m3h2x3(:,185),heltab2x6(:,:,379))
  call Hloop_SV_V(ntryL,G2H6(235),ex2(:),G2H3(123),m3h2x3(:,186),heltab2x6(:,:,380))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(11),mass5set(:,12),  & 
G1H4(19),G1H4(5),G1H4(6),G1H4(11),G1H4(12),G1H4(20),4)
  call HG1shiftOLR(G1H4(5),4,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(11),mass5set(:,11),  & 
G1H4(21),G1H4(22),G1H4(23),G1H4(24),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(22),4,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(11),mass5set(:,11),  & 
G1H4(27),G1H4(28),G1H4(29),G1H4(30),G1H4(31),G1H4(32),4)
  call HG1shiftOLR(G1H4(28),4,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(11),mass5set(:,11),  & 
G1H4(33),G1H4(34),G1H4(35),G1H4(36),G1H4(37),G1H4(38),4)
  call HG1shiftOLR(G1H4(34),4,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(11),mass5set(:,11),  & 
G1H4(39),G1H4(40),G1H4(41),G1H4(42),G1H4(43),G1H4(44),4)
  call HG1shiftOLR(G1H4(40),4,4)
  call Hloop_TV_S(ntryL,G1H4(1),25,ex2(:),2,G2H2(45),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_VV_S(ntryL,G1H4(2),ex2(:),G1H2(13),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_SV_V(ntryL,G2H4(6),ex2(:),G2H2(46),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_SV_V(ntryL,G2H4(9),ex2(:),G2H2(47),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_VV_S(ntryL,G0H4(1),ex2(:),G0H2(1),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_SV_V(ntryL,G1H4(3),ex2(:),G1H2(14),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_UV_W(ntryL,G1H4(4),25,ex2(:),2,G2H2(48),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_UV_W(ntryL,G0H4(2),25,ex2(:),2,G1H2(15),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hotf_5pt_reduction(G2H4(43),RedSet_5(11),mass5set(:,11),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(45),G1H4(46),4)
  call HG1shiftOLR(G1H4(2),4,4)
  call Hloop_VV_S(ntryL,G2H4(10),ex2(:),G2H2(49),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_SV_V(ntryL,G2H4(51),ex2(:),G2H2(50),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(12),mass5set(:,12),  & 
G1H4(47),G1H4(48),G1H4(49),G1H4(50),G1H4(51),G1H4(52),4)
  call HG1shiftOLR(G1H4(48),2,4)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(12),mass5set(:,11),  & 
G1H4(53),G1H4(54),G1H4(55),G1H4(56),G1H4(57),G1H4(58),4)
  call HG1shiftOLR(G1H4(54),2,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(12),mass5set(:,11),  & 
G1H4(59),G1H4(60),G1H4(61),G1H4(62),G1H4(63),G1H4(64),4)
  call HG1shiftOLR(G1H4(60),2,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(12),mass5set(:,11),  & 
G1H4(65),G1H4(66),G1H4(67),G1H4(68),G1H4(69),G1H4(70),4)
  call HG1shiftOLR(G1H4(66),2,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(12),mass5set(:,11),  & 
G1H4(71),G1H4(72),G1H4(73),G1H4(74),G1H4(75),G1H4(76),4)
  call HG1shiftOLR(G1H4(72),2,4)
  call Hloop_VV_S(ntryL,G1H4(7),ex3(:),G1H2(16),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_TV_S(ntryL,G1H4(8),25,ex3(:),4,G2H2(51),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_SV_V(ntryL,G2H4(16),ex3(:),G2H2(52),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_SV_V(ntryL,G2H4(19),ex3(:),G2H2(53),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_VV_S(ntryL,G0H4(3),ex3(:),G0H2(2),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_UV_W(ntryL,G1H4(9),25,ex3(:),4,G2H2(54),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_SV_V(ntryL,G1H4(10),ex3(:),G1H2(17),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_UV_W(ntryL,G0H4(4),25,ex3(:),4,G1H2(18),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hotf_5pt_reduction(G2H4(67),RedSet_5(12),mass5set(:,11),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(77),G1H4(78),4)
  call HG1shiftOLR(G1H4(8),2,4)
  call Hloop_VV_S(ntryL,G2H4(20),ex3(:),G2H2(55),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_SV_V(ntryL,G2H4(75),ex3(:),G2H2(56),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hotf_5pt_reduction(G2H6(73),RedSet_5(1),mass5set(:,1),  & 
G1H6(128),G1H6(33),G1H6(38),G1H6(30),G1H6(47),G1H6(49),6)
  call HG1shiftOLR(G1H6(33),8,6)
  call Hotf_4pt_reduction(G2H6(76),RedSet_4(1),mass4set(:,1),  & 
G1H6(163),G1H6(245),G1H6(246),G1H6(247),G1H6(248),G0H6(1),6)
  call HG1shiftOLR(G1H6(245),8,6)
  call Hotf_4pt_reduction(G2H6(77),RedSet_4(2),mass4set(:,1),  & 
G1H6(249),G1H6(250),G1H6(251),G1H6(334),G1H6(335),G0H6(11),6)
  call HG1shiftOLR(G1H6(250),10,6)
  call Hotf_5pt_reduction(G2H6(78),RedSet_5(1),mass5set(:,2),  & 
G1H6(336),G1H6(337),G1H6(338),G1H6(339),G1H6(340),G1H6(342),6)
  call HG1shiftOLR(G1H6(337),8,6)
  call Hotf_4pt_reduction(G2H6(82),RedSet_4(1),mass4set(:,2),  & 
G1H6(343),G1H6(344),G1H6(345),G1H6(346),G1H6(347),G0H6(12),6)
  call HG1shiftOLR(G1H6(344),8,6)
  call Hotf_4pt_reduction(G2H6(80),RedSet_4(2),mass4set(:,2),  & 
G1H6(348),G1H6(349),G1H6(350),G1H6(351),G1H6(352),G0H6(2),6)
  call HG1shiftOLR(G1H6(349),10,6)
  call Hotf_5pt_reduction(G2H6(83),RedSet_5(1),mass5set(:,3),  & 
G1H6(353),G1H6(354),G1H6(355),G1H6(356),G1H6(357),G1H6(358),6)
  call HG1shiftOLR(G1H6(354),8,6)
  call Hotf_4pt_reduction(G2H6(86),RedSet_4(1),mass4set(:,3),  & 
G1H6(359),G1H6(360),G1H6(361),G1H6(362),G1H6(363),G0H6(5),6)
  call HG1shiftOLR(G1H6(360),8,6)
  call Hotf_4pt_reduction(G2H6(87),RedSet_4(2),mass4set(:,3),  & 
G1H6(364),G1H6(365),G1H6(366),G1H6(367),G1H6(368),G0H6(3),6)
  call HG1shiftOLR(G1H6(365),10,6)
  call Hloop_VV_S(ntryL,G2H6(79),ex2(:),G2H3(127),m3h2x3(:,187),heltab2x6(:,:,381))
  call Hloop_VV_S(ntryL,G2H6(84),ex2(:),G2H3(146),m3h2x3(:,188),heltab2x6(:,:,382))
  call Hloop_VV_S(ntryL,G2H6(91),ex2(:),G2H3(147),m3h2x3(:,189),heltab2x6(:,:,383))
  call Hloop_VV_S(ntryL,G2H6(92),ex2(:),G2H3(148),m3h2x3(:,190),heltab2x6(:,:,384))
  call Hotf_4pt_reduction(G2H6(95),RedSet_4(1),mass4set(:,4),  & 
G1H6(369),G1H6(370),G1H6(371),G1H6(372),G1H6(373),6)
  call HG1shiftOLR(G1H6(370),8,6)
  call Hotf_4pt_reduction(G2H6(96),RedSet_4(2),mass4set(:,4),  & 
G1H6(374),G1H6(375),G1H6(376),G1H6(377),G1H6(378),6)
  call HG1shiftOLR(G1H6(375),10,6)
  call Hotf_4pt_reduction(G2H6(99),RedSet_4(1),mass4set(:,5),  & 
G1H6(379),G1H6(380),G1H6(381),G1H6(382),G1H6(383),6)
  call HG1shiftOLR(G1H6(380),8,6)
  call Hotf_4pt_reduction(G2H6(100),RedSet_4(2),mass4set(:,5),  & 
G1H6(384),G1H6(385),G1H6(386),G1H6(387),G1H6(388),6)
  call HG1shiftOLR(G1H6(385),10,6)
  call Hotf_4pt_reduction(G2H6(103),RedSet_4(1),mass4set(:,6),  & 
G1H6(389),G1H6(390),G1H6(391),G1H6(392),G1H6(393),6)
  call HG1shiftOLR(G1H6(390),8,6)
  call Hotf_4pt_reduction(G2H6(104),RedSet_4(2),mass4set(:,6),  & 
G1H6(394),G1H6(395),G1H6(396),G1H6(397),G1H6(398),6)
  call HG1shiftOLR(G1H6(395),10,6)
  call Hloop_SV_V(ntryL,G2H6(107),ex2(:),G2H3(149),m3h2x3(:,191),heltab2x6(:,:,385))
  call Hloop_SV_V(ntryL,G2H6(108),ex2(:),G2H3(150),m3h2x3(:,192),heltab2x6(:,:,386))
  call Hloop_SV_V(ntryL,G2H6(111),ex2(:),G2H3(151),m3h2x3(:,193),heltab2x6(:,:,387))
  call Hloop_SV_V(ntryL,G2H6(112),ex2(:),G2H3(152),m3h2x3(:,194),heltab2x6(:,:,388))
  call Hotf_5pt_reduction(G2H6(113),RedSet_5(2),mass5set(:,1),  & 
G1H6(399),G1H6(400),G1H6(401),G1H6(402),G1H6(403),G1H6(404),6)
  call HG1shiftOLR(G1H6(400),8,6)
  call Hotf_4pt_reduction(G2H6(115),RedSet_4(3),mass4set(:,1),  & 
G1H6(405),G1H6(406),G1H6(407),G1H6(408),G1H6(409),G0H6(4),6)
  call HG1shiftOLR(G1H6(406),8,6)
  call Hotf_4pt_reduction(G2H6(116),RedSet_4(4),mass4set(:,1),  & 
G1H6(410),G1H6(411),G1H6(412),G1H6(413),G1H6(414),G0H6(8),6)
  call HG1shiftOLR(G1H6(411),12,6)
  call Hotf_5pt_reduction(G2H6(117),RedSet_5(2),mass5set(:,2),  & 
G1H6(415),G1H6(416),G1H6(417),G1H6(418),G1H6(419),G1H6(420),6)
  call HG1shiftOLR(G1H6(416),8,6)
  call Hotf_4pt_reduction(G2H6(119),RedSet_4(3),mass4set(:,2),  & 
G1H6(421),G1H6(422),G1H6(423),G1H6(424),G1H6(425),G0H6(6),6)
  call HG1shiftOLR(G1H6(422),8,6)
  call Hotf_4pt_reduction(G2H6(120),RedSet_4(4),mass4set(:,2),  & 
G1H6(426),G1H6(427),G1H6(428),G1H6(429),G1H6(430),G0H6(7),6)
  call HG1shiftOLR(G1H6(427),12,6)
  call Hotf_5pt_reduction(G2H6(121),RedSet_5(2),mass5set(:,3),  & 
G1H6(431),G1H6(432),G1H6(433),G1H6(434),G1H6(435),G1H6(436),6)
  call HG1shiftOLR(G1H6(432),8,6)
  call Hotf_4pt_reduction(G2H6(123),RedSet_4(3),mass4set(:,3),  & 
G1H6(437),G1H6(438),G1H6(439),G1H6(440),G1H6(441),G0H6(9),6)
  call HG1shiftOLR(G1H6(438),8,6)
  call Hotf_4pt_reduction(G2H6(124),RedSet_4(4),mass4set(:,3),  & 
G1H6(442),G1H6(443),G1H6(444),G1H6(445),G1H6(446),G0H6(10),6)
  call HG1shiftOLR(G1H6(443),12,6)
  call Hloop_VV_S(ntryL,G2H6(127),ex3(:),G2H3(153),m3h2x3(:,195),heltab2x6(:,:,389))
  call Hloop_VV_S(ntryL,G2H6(128),ex3(:),G2H3(154),m3h2x3(:,196),heltab2x6(:,:,390))
  call Hloop_VV_S(ntryL,G2H6(131),ex3(:),G2H3(155),m3h2x3(:,197),heltab2x6(:,:,391))
  call Hloop_VV_S(ntryL,G2H6(132),ex3(:),G2H3(156),m3h2x3(:,198),heltab2x6(:,:,392))
  call Hotf_4pt_reduction(G2H6(135),RedSet_4(3),mass4set(:,6),  & 
G1H6(447),G1H6(448),G1H6(449),G1H6(450),G1H6(451),6)
  call HG1shiftOLR(G1H6(448),8,6)
  call Hotf_4pt_reduction(G2H6(136),RedSet_4(4),mass4set(:,6),  & 
G1H6(452),G1H6(453),G1H6(454),G1H6(455),G1H6(456),6)
  call HG1shiftOLR(G1H6(453),12,6)
  call Hotf_4pt_reduction(G2H6(139),RedSet_4(3),mass4set(:,4),  & 
G1H6(457),G1H6(458),G1H6(459),G1H6(460),G1H6(461),6)
  call HG1shiftOLR(G1H6(458),8,6)
  call Hotf_4pt_reduction(G2H6(140),RedSet_4(4),mass4set(:,4),  & 
G1H6(462),G1H6(463),G1H6(464),G1H6(465),G1H6(466),6)
  call HG1shiftOLR(G1H6(463),12,6)
  call Hotf_4pt_reduction(G2H6(143),RedSet_4(3),mass4set(:,5),  & 
G1H6(467),G1H6(468),G1H6(469),G1H6(470),G1H6(471),6)
  call HG1shiftOLR(G1H6(468),8,6)
  call Hotf_4pt_reduction(G2H6(144),RedSet_4(4),mass4set(:,5),  & 
G1H6(472),G1H6(473),G1H6(474),G1H6(475),G1H6(476),6)
  call HG1shiftOLR(G1H6(473),12,6)
  call Hloop_SV_V(ntryL,G2H6(147),ex3(:),G2H3(157),m3h2x3(:,199),heltab2x6(:,:,393))
  call Hloop_SV_V(ntryL,G2H6(148),ex3(:),G2H3(158),m3h2x3(:,200),heltab2x6(:,:,394))
  call Hloop_SV_V(ntryL,G2H6(151),ex3(:),G2H3(159),m3h2x3(:,201),heltab2x6(:,:,395))
  call Hloop_SV_V(ntryL,G2H6(152),ex3(:),G2H3(160),m3h2x3(:,202),heltab2x6(:,:,396))
  call Hotf_5pt_reduction(G2H3(29),RedSet_5(3),mass5set(:,1),  & 
G1H3(85),G1H3(86),G1H3(87),G1H3(88),G1H3(89),G1H3(90),3)
  call HG1shiftOLR(G1H3(86),8,3)
  call Hotf_4pt_reduction(G2H3(31),RedSet_4(1),mass4set(:,1),  & 
G1H3(91),G1H3(92),G1H3(93),G1H3(94),G1H3(95),G0H3(1),3)
  call HG1shiftOLR(G1H3(92),8,3)
  call Hotf_4pt_reduction(G2H3(32),RedSet_4(5),mass4set(:,1),  & 
G1H3(96),G1H3(97),G1H3(98),G1H3(99),G1H3(100),G0H3(2),3)
  call HG1shiftOLR(G1H3(97),9,3)
  call Hotf_5pt_reduction(G2H3(33),RedSet_5(3),mass5set(:,2),  & 
G1H3(101),G1H3(102),G1H3(103),G1H3(104),G1H3(105),G1H3(106),3)
  call HG1shiftOLR(G1H3(102),8,3)
  call Hotf_4pt_reduction(G2H3(35),RedSet_4(1),mass4set(:,2),  & 
G1H3(107),G1H3(108),G1H3(109),G1H3(110),G1H3(111),G0H3(3),3)
  call HG1shiftOLR(G1H3(108),8,3)
  call Hotf_4pt_reduction(G2H3(36),RedSet_4(5),mass4set(:,2),  & 
G1H3(112),G1H3(113),G1H3(114),G1H3(115),G1H3(116),G0H3(4),3)
  call HG1shiftOLR(G1H3(113),9,3)
  call Hotf_5pt_reduction(G2H3(37),RedSet_5(3),mass5set(:,3),  & 
G1H3(117),G1H3(118),G1H3(119),G1H3(120),G1H3(121),G1H3(122),3)
  call HG1shiftOLR(G1H3(118),8,3)
  call Hotf_4pt_reduction(G2H3(39),RedSet_4(1),mass4set(:,3),  & 
G1H3(123),G1H3(124),G1H3(125),G1H3(126),G1H3(127),G0H3(5),3)
  call HG1shiftOLR(G1H3(124),8,3)
  call Hotf_4pt_reduction(G2H3(40),RedSet_4(5),mass4set(:,3),  & 
G1H3(128),G1H3(129),G1H3(130),G1H3(131),G1H3(132),G0H3(6),3)
  call HG1shiftOLR(G1H3(129),9,3)
  call Hloop_SS_S(ntryL,G2H3(43),ex1(:),G2H3(29),m3h1x3(:,15),heltab2x3(:,:,15))
  call Hloop_SS_S(ntryL,G2H3(44),ex1(:),G2H3(31),m3h1x3(:,16),heltab2x3(:,:,16))
  call Hloop_SS_S(ntryL,G2H3(47),ex1(:),G2H3(32),m3h1x3(:,17),heltab2x3(:,:,17))
  call Hloop_SS_S(ntryL,G2H3(48),ex1(:),G2H3(33),m3h1x3(:,18),heltab2x3(:,:,18))
  call Hloop_SS_S(ntryL,G2H3(49),ex1(:),G2H3(35),m3h1x3(:,19),heltab2x3(:,:,19))
  call Hloop_SS_S(ntryL,G2H3(51),ex1(:),G2H3(36),m3h1x3(:,20),heltab2x3(:,:,20))
  call Hloop_SS_S(ntryL,G2H3(52),ex1(:),G2H3(37),m3h1x3(:,21),heltab2x3(:,:,21))
  call Hloop_SS_S(ntryL,G2H3(53),ex1(:),G2H3(39),m3h1x3(:,22),heltab2x3(:,:,22))
  call Hloop_SS_S(ntryL,G2H3(55),ex1(:),G2H3(40),m3h1x3(:,23),heltab2x3(:,:,23))
  call Hloop_SS_S(ntryL,G2H3(56),ex1(:),G2H3(43),m3h1x3(:,24),heltab2x3(:,:,24))
  call Hloop_SS_S(ntryL,G2H3(57),ex1(:),G2H3(44),m3h1x3(:,25),heltab2x3(:,:,25))
  call Hloop_SS_S(ntryL,G2H3(59),ex1(:),G2H3(47),m3h1x3(:,26),heltab2x3(:,:,26))
  call Hloop_SS_S(ntryL,G2H3(60),ex1(:),G2H3(48),m3h1x3(:,27),heltab2x3(:,:,27))
  call Hloop_SS_S(ntryL,G2H3(61),ex1(:),G2H3(49),m3h1x3(:,28),heltab2x3(:,:,28))
  call Hloop_SS_S(ntryL,G2H3(63),ex1(:),G2H3(51),m3h1x3(:,29),heltab2x3(:,:,29))
  call Hloop_SS_S(ntryL,G2H3(64),ex1(:),G2H3(52),m3h1x3(:,30),heltab2x3(:,:,30))
  call Hloop_VS_V(ntryL,G2H3(67),ex1(:),G2H3(53),m3h1x3(:,31),heltab2x3(:,:,31))
  call Hloop_VS_V(ntryL,G2H3(68),ex1(:),G2H3(55),m3h1x3(:,32),heltab2x3(:,:,32))
  call Hloop_VS_V(ntryL,G2H3(71),ex1(:),G2H3(56),m3h1x3(:,33),heltab2x3(:,:,33))
  call Hloop_VS_V(ntryL,G2H3(72),ex1(:),G2H3(57),m3h1x3(:,34),heltab2x3(:,:,34))
  call Hotf_4pt_reduction(G2H3(75),RedSet_4(1),mass4set(:,6),  & 
G1H3(133),G1H3(134),G1H3(135),G1H3(136),G1H3(137),3)
  call HG1shiftOLR(G1H3(134),8,3)
  call Hotf_4pt_reduction(G2H3(76),RedSet_4(5),mass4set(:,6),  & 
G1H3(138),G1H3(139),G1H3(140),G1H3(141),G1H3(142),3)
  call HG1shiftOLR(G1H3(139),9,3)
  call Hotf_4pt_reduction(G2H3(79),RedSet_4(1),mass4set(:,4),  & 
G1H3(143),G1H3(144),G1H3(145),G1H3(146),G1H3(147),3)
  call HG1shiftOLR(G1H3(144),8,3)
  call Hotf_4pt_reduction(G2H3(80),RedSet_4(5),mass4set(:,4),  & 
G1H3(148),G1H3(149),G1H3(150),G1H3(151),G1H3(152),3)
  call HG1shiftOLR(G1H3(149),9,3)
  call Hotf_4pt_reduction(G2H3(83),RedSet_4(1),mass4set(:,5),  & 
G1H3(153),G1H3(154),G1H3(155),G1H3(156),G1H3(157),3)
  call HG1shiftOLR(G1H3(154),8,3)
  call Hotf_4pt_reduction(G2H3(84),RedSet_4(5),mass4set(:,5),  & 
G1H3(158),G1H3(159),G1H3(160),G1H3(161),G1H3(162),3)
  call HG1shiftOLR(G1H3(159),9,3)
  call Hotf_5pt_reduction(G2H6(153),RedSet_5(4),mass5set(:,7),  & 
G1H6(477),G1H6(478),G1H6(479),G1H6(480),G1H6(481),G1H6(482),6)
  call HG1shiftOLR(G1H6(478),4,6)
  call Hotf_4pt_reduction(G2H6(155),RedSet_4(6),mass4set(:,7),  & 
G1H6(483),G1H6(484),G1H6(485),G1H6(486),G1H6(487),G0H6(13),6)
  call HG1shiftOLR(G1H6(484),4,6)
  call Hotf_4pt_reduction(G2H6(156),RedSet_4(4),mass4set(:,2),  & 
G1H6(488),G1H6(489),G1H6(490),G1H6(491),G1H6(492),G0H6(23),6)
  call HG1shiftOLR(G1H6(489),12,6)
  call Hotf_5pt_reduction(G2H6(157),RedSet_5(4),mass5set(:,8),  & 
G1H6(493),G1H6(494),G1H6(495),G1H6(496),G1H6(497),G1H6(498),6)
  call HG1shiftOLR(G1H6(494),4,6)
  call Hotf_4pt_reduction(G2H6(159),RedSet_4(6),mass4set(:,8),  & 
G1H6(499),G1H6(500),G1H6(501),G1H6(502),G1H6(503),G0H6(24),6)
  call HG1shiftOLR(G1H6(500),4,6)
  call Hotf_4pt_reduction(G2H6(160),RedSet_4(4),mass4set(:,3),  & 
G1H6(504),G1H6(505),G1H6(506),G1H6(507),G1H6(508),G0H6(14),6)
  call HG1shiftOLR(G1H6(505),12,6)
  call Hotf_5pt_reduction(G2H6(161),RedSet_5(5),mass5set(:,1),  & 
G1H6(509),G1H6(510),G1H6(511),G1H6(512),G1H6(513),G1H6(514),6)
  call HG1shiftOLR(G1H6(510),8,6)
  call Hotf_4pt_reduction(G2H6(163),RedSet_4(7),mass4set(:,1),  & 
G1H6(515),G1H6(516),G1H6(517),G1H6(518),G1H6(519),G0H6(15),6)
  call HG1shiftOLR(G1H6(516),8,6)
  call Hotf_4pt_reduction(G2H6(164),RedSet_4(8),mass4set(:,1),  & 
G1H6(520),G1H6(521),G1H6(522),G1H6(523),G1H6(524),G0H6(18),6)
  call HG1shiftOLR(G1H6(521),12,6)
  call Hotf_5pt_reduction(G2H6(165),RedSet_5(5),mass5set(:,2),  & 
G1H6(525),G1H6(526),G1H6(527),G1H6(528),G1H6(529),G1H6(530),6)
  call HG1shiftOLR(G1H6(526),8,6)
  call Hotf_4pt_reduction(G2H6(167),RedSet_4(7),mass4set(:,2),  & 
G1H6(531),G1H6(532),G1H6(533),G1H6(534),G1H6(535),G0H6(16),6)
  call HG1shiftOLR(G1H6(532),8,6)
  call Hotf_4pt_reduction(G2H6(168),RedSet_4(8),mass4set(:,2),  & 
G1H6(536),G1H6(537),G1H6(538),G1H6(539),G1H6(540),G0H6(17),6)
  call HG1shiftOLR(G1H6(537),12,6)
  call Hotf_5pt_reduction(G2H6(169),RedSet_5(5),mass5set(:,3),  & 
G1H6(541),G1H6(542),G1H6(543),G1H6(544),G1H6(545),G1H6(546),6)
  call HG1shiftOLR(G1H6(542),8,6)
  call Hotf_4pt_reduction(G2H6(171),RedSet_4(7),mass4set(:,3),  & 
G1H6(547),G1H6(548),G1H6(549),G1H6(550),G1H6(551),G0H6(19),6)
  call HG1shiftOLR(G1H6(548),8,6)
  call Hotf_4pt_reduction(G2H6(172),RedSet_4(8),mass4set(:,3),  & 
G1H6(552),G1H6(553),G1H6(554),G1H6(555),G1H6(556),G0H6(20),6)
  call HG1shiftOLR(G1H6(553),12,6)
  call Hotf_4pt_reduction(G2H6(175),RedSet_4(7),mass4set(:,4),  & 
G1H6(557),G1H6(558),G1H6(559),G1H6(560),G1H6(561),6)
  call HG1shiftOLR(G1H6(558),8,6)
  call Hotf_4pt_reduction(G2H6(176),RedSet_4(8),mass4set(:,4),  & 
G1H6(562),G1H6(563),G1H6(564),G1H6(565),G1H6(566),6)
  call HG1shiftOLR(G1H6(563),12,6)
  call Hotf_4pt_reduction(G2H6(179),RedSet_4(7),mass4set(:,5),  & 
G1H6(567),G1H6(568),G1H6(569),G1H6(570),G1H6(571),6)
  call HG1shiftOLR(G1H6(568),8,6)
  call Hotf_4pt_reduction(G2H6(180),RedSet_4(8),mass4set(:,5),  & 
G1H6(572),G1H6(573),G1H6(574),G1H6(575),G1H6(576),6)
  call HG1shiftOLR(G1H6(573),12,6)
  call Hloop_SV_V(ntryL,G2H6(183),ex3(:),G2H3(59),m3h2x3(:,203),heltab2x6(:,:,397))
  call Hloop_SV_V(ntryL,G2H6(184),ex3(:),G2H3(60),m3h2x3(:,204),heltab2x6(:,:,398))
  call Hloop_SV_V(ntryL,G2H6(187),ex3(:),G2H3(61),m3h2x3(:,205),heltab2x6(:,:,399))
  call Hloop_SV_V(ntryL,G2H6(188),ex3(:),G2H3(63),m3h2x3(:,206),heltab2x6(:,:,400))
  call Hloop_VV_S(ntryL,G2H6(191),ex3(:),G2H3(64),m3h2x3(:,207),heltab2x6(:,:,401))
  call Hloop_VV_S(ntryL,G2H6(192),ex3(:),G2H3(67),m3h2x3(:,208),heltab2x6(:,:,402))
  call Hloop_VV_S(ntryL,G2H6(195),ex3(:),G2H3(68),m3h2x3(:,209),heltab2x6(:,:,403))
  call Hloop_VV_S(ntryL,G2H6(196),ex3(:),G2H3(71),m3h2x3(:,210),heltab2x6(:,:,404))
  call Hotf_4pt_reduction(G2H6(199),RedSet_4(7),mass4set(:,6),  & 
G1H6(577),G1H6(578),G1H6(579),G1H6(580),G1H6(581),6)
  call HG1shiftOLR(G1H6(578),8,6)
  call Hotf_4pt_reduction(G2H6(200),RedSet_4(8),mass4set(:,6),  & 
G1H6(582),G1H6(583),G1H6(584),G1H6(585),G1H6(586),6)
  call HG1shiftOLR(G1H6(583),12,6)
  call Hotf_5pt_reduction(G2H6(201),RedSet_5(6),mass5set(:,7),  & 
G1H6(587),G1H6(588),G1H6(589),G1H6(590),G1H6(591),G1H6(592),6)
  call HG1shiftOLR(G1H6(588),4,6)
  call Hotf_4pt_reduction(G2H6(204),RedSet_4(9),mass4set(:,7),  & 
G1H6(593),G1H6(594),G1H6(595),G1H6(596),G1H6(597),G0H6(21),6)
  call HG1shiftOLR(G1H6(594),4,6)
  call Hotf_4pt_reduction(G2H6(205),RedSet_4(8),mass4set(:,2),  & 
G1H6(598),G1H6(599),G1H6(600),G1H6(601),G1H6(602),G0H6(22),6)
  call HG1shiftOLR(G1H6(599),12,6)
  call Hotf_5pt_reduction(G2H6(206),RedSet_5(6),mass5set(:,8),  & 
G1H6(603),G1H6(604),G1H6(605),G1H6(606),G1H6(607),G1H6(608),6)
  call HG1shiftOLR(G1H6(604),4,6)
  call Hotf_4pt_reduction(G2H6(209),RedSet_4(9),mass4set(:,8),  & 
G1H6(609),G1H6(610),G1H6(611),G1H6(612),G1H6(613),G0H6(25),6)
  call HG1shiftOLR(G1H6(610),4,6)
  call Hotf_4pt_reduction(G2H6(210),RedSet_4(8),mass4set(:,3),  & 
G1H6(614),G1H6(615),G1H6(616),G1H6(617),G1H6(618),G0H6(35),6)
  call HG1shiftOLR(G1H6(615),12,6)
  call Hotf_5pt_reduction(G2H3(87),RedSet_5(7),mass5set(:,1),  & 
G1H3(163),G1H3(164),G1H3(165),G1H3(166),G1H3(167),G1H3(168),3)
  call HG1shiftOLR(G1H3(164),8,3)
  call Hotf_4pt_reduction(G2H3(89),RedSet_4(3),mass4set(:,1),  & 
G1H3(169),G1H3(170),G1H3(171),G1H3(172),G1H3(173),G0H3(7),3)
  call HG1shiftOLR(G1H3(170),8,3)
  call Hotf_4pt_reduction(G2H3(90),RedSet_4(10),mass4set(:,1),  & 
G1H3(174),G1H3(175),G1H3(176),G1H3(177),G1H3(178),G0H3(8),3)
  call HG1shiftOLR(G1H3(175),9,3)
  call Hotf_5pt_reduction(G2H3(91),RedSet_5(7),mass5set(:,2),  & 
G1H3(179),G1H3(180),G1H3(181),G1H3(182),G1H3(183),G1H3(184),3)
  call HG1shiftOLR(G1H3(180),8,3)
  call Hotf_4pt_reduction(G2H3(93),RedSet_4(3),mass4set(:,2),  & 
G1H3(185),G1H3(186),G1H3(187),G1H3(188),G1H3(189),G0H3(9),3)
  call HG1shiftOLR(G1H3(186),8,3)
  call Hotf_4pt_reduction(G2H3(94),RedSet_4(10),mass4set(:,2),  & 
G1H3(190),G1H3(191),G1H3(192),G1H3(193),G1H3(194),G0H3(10),3)
  call HG1shiftOLR(G1H3(191),9,3)
  call Hotf_5pt_reduction(G2H3(95),RedSet_5(7),mass5set(:,3),  & 
G1H3(195),G1H3(196),G1H3(197),G1H3(198),G1H3(199),G1H3(200),3)
  call HG1shiftOLR(G1H3(196),8,3)
  call Hotf_4pt_reduction(G2H3(97),RedSet_4(3),mass4set(:,3),  & 
G1H3(201),G1H3(202),G1H3(203),G1H3(204),G1H3(205),G0H3(11),3)
  call HG1shiftOLR(G1H3(202),8,3)
  call Hotf_4pt_reduction(G2H3(98),RedSet_4(10),mass4set(:,3),  & 
G1H3(206),G1H3(207),G1H3(208),G1H3(209),G1H3(210),G0H3(12),3)
  call HG1shiftOLR(G1H3(207),9,3)
  call Hloop_SS_S(ntryL,G2H3(101),ex1(:),G2H3(72),m3h1x3(:,35),heltab2x3(:,:,35))
  call Hloop_SS_S(ntryL,G2H3(102),ex1(:),G2H3(75),m3h1x3(:,36),heltab2x3(:,:,36))
  call Hloop_SS_S(ntryL,G2H3(105),ex1(:),G2H3(76),m3h1x3(:,37),heltab2x3(:,:,37))
  call Hloop_SS_S(ntryL,G2H3(106),ex1(:),G2H3(79),m3h1x3(:,38),heltab2x3(:,:,38))
  call Hloop_SS_S(ntryL,G2H3(107),ex1(:),G2H3(80),m3h1x3(:,39),heltab2x3(:,:,39))
  call Hloop_SS_S(ntryL,G2H3(109),ex1(:),G2H3(83),m3h1x3(:,40),heltab2x3(:,:,40))
  call Hloop_SS_S(ntryL,G2H3(110),ex1(:),G2H3(84),m3h1x3(:,41),heltab2x3(:,:,41))
  call Hloop_SS_S(ntryL,G2H3(111),ex1(:),G2H3(87),m3h1x3(:,42),heltab2x3(:,:,42))
  call Hloop_SS_S(ntryL,G2H3(113),ex1(:),G2H3(89),m3h1x3(:,43),heltab2x3(:,:,43))
  call Hloop_SS_S(ntryL,G2H3(114),ex1(:),G2H3(90),m3h1x3(:,44),heltab2x3(:,:,44))
  call Hloop_SS_S(ntryL,G2H3(115),ex1(:),G2H3(91),m3h1x3(:,45),heltab2x3(:,:,45))
  call Hloop_SS_S(ntryL,G2H3(117),ex1(:),G2H3(93),m3h1x3(:,46),heltab2x3(:,:,46))
  call Hloop_SS_S(ntryL,G2H3(118),ex1(:),G2H3(94),m3h1x3(:,47),heltab2x3(:,:,47))
  call Hloop_SS_S(ntryL,G2H3(119),ex1(:),G2H3(95),m3h1x3(:,48),heltab2x3(:,:,48))
  call Hloop_SS_S(ntryL,G2H3(121),ex1(:),G2H3(97),m3h1x3(:,49),heltab2x3(:,:,49))
  call Hloop_SS_S(ntryL,G2H3(122),ex1(:),G2H3(98),m3h1x3(:,50),heltab2x3(:,:,50))
  call Hloop_VS_V(ntryL,G2H3(125),ex1(:),G2H3(101),m3h1x3(:,51),heltab2x3(:,:,51))
  call Hloop_VS_V(ntryL,G2H3(126),ex1(:),G2H3(102),m3h1x3(:,52),heltab2x3(:,:,52))
  call Hloop_VS_V(ntryL,G2H3(129),ex1(:),G2H3(105),m3h1x3(:,53),heltab2x3(:,:,53))
  call Hloop_VS_V(ntryL,G2H3(130),ex1(:),G2H3(106),m3h1x3(:,54),heltab2x3(:,:,54))
  call Hotf_4pt_reduction(G2H3(133),RedSet_4(3),mass4set(:,6),  & 
G1H3(211),G1H3(212),G1H3(213),G1H3(214),G1H3(215),3)
  call HG1shiftOLR(G1H3(212),8,3)
  call Hotf_4pt_reduction(G2H3(134),RedSet_4(10),mass4set(:,6),  & 
G1H3(216),G1H3(217),G1H3(218),G1H3(219),G1H3(220),3)
  call HG1shiftOLR(G1H3(217),9,3)
  call Hotf_4pt_reduction(G2H3(137),RedSet_4(3),mass4set(:,4),  & 
G1H3(221),G1H3(222),G1H3(223),G1H3(224),G1H3(225),3)
  call HG1shiftOLR(G1H3(222),8,3)
  call Hotf_4pt_reduction(G2H3(138),RedSet_4(10),mass4set(:,4),  & 
G1H3(226),G1H3(227),G1H3(228),G1H3(229),G1H3(230),3)
  call HG1shiftOLR(G1H3(227),9,3)
  call Hotf_4pt_reduction(G2H3(141),RedSet_4(3),mass4set(:,5),  & 
G1H3(231),G1H3(232),G1H3(233),G1H3(234),G1H3(235),3)
  call HG1shiftOLR(G1H3(232),8,3)
  call Hotf_4pt_reduction(G2H3(142),RedSet_4(10),mass4set(:,5),  & 
G1H3(236),G1H3(237),G1H3(238),G1H3(239),G1H3(240),3)
  call HG1shiftOLR(G1H3(237),9,3)
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(8),mass5set(:,9),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),4,2)
  call Hotf_4pt_reduction(G2H2(39),RedSet_4(6),mass4set(:,8),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G0H2(3),2)
  call HG1shiftOLR(G1H2(26),4,2)
  call Hotf_4pt_reduction(G2H2(40),RedSet_4(11),mass4set(:,8),  & 
G1H2(30),G1H2(31),G1H2(32),G1H2(33),G1H2(34),G0H2(4),2)
  call HG1shiftOLR(G1H2(31),5,2)
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(8),mass5set(:,10),  & 
G1H2(35),G1H2(36),G1H2(37),G1H2(38),G1H2(39),G1H2(40),2)
  call HG1shiftOLR(G1H2(36),4,2)
  call Hotf_4pt_reduction(G2H2(43),RedSet_4(6),mass4set(:,7),  & 
G1H2(41),G1H2(42),G1H2(43),G1H2(44),G1H2(45),G0H2(5),2)
  call HG1shiftOLR(G1H2(42),4,2)
  call Hotf_4pt_reduction(G2H2(44),RedSet_4(11),mass4set(:,7),  & 
G1H2(46),G1H2(47),G1H2(48),G1H2(49),G1H2(50),G0H2(6),2)
  call HG1shiftOLR(G1H2(47),5,2)
  call Hotf_5pt_reduction(G2H6(211),RedSet_5(9),mass5set(:,1),  & 
G1H6(619),G1H6(620),G1H6(621),G1H6(622),G1H6(623),G1H6(624),6)
  call HG1shiftOLR(G1H6(620),8,6)
  call Hotf_4pt_reduction(G2H6(213),RedSet_4(7),mass4set(:,1),  & 
G1H6(625),G1H6(626),G1H6(627),G1H6(628),G1H6(629),G0H6(36),6)
  call HG1shiftOLR(G1H6(626),8,6)
  call Hotf_4pt_reduction(G2H6(214),RedSet_4(12),mass4set(:,1),  & 
G1H6(630),G1H6(631),G1H6(632),G1H6(633),G1H6(634),G0H6(28),6)
  call HG1shiftOLR(G1H6(631),10,6)
  call Hotf_5pt_reduction(G2H6(215),RedSet_5(9),mass5set(:,2),  & 
G1H6(635),G1H6(636),G1H6(637),G1H6(638),G1H6(639),G1H6(640),6)
  call HG1shiftOLR(G1H6(636),8,6)
  call Hotf_4pt_reduction(G2H6(217),RedSet_4(7),mass4set(:,2),  & 
G1H6(641),G1H6(642),G1H6(643),G1H6(644),G1H6(645),G0H6(29),6)
  call HG1shiftOLR(G1H6(642),8,6)
  call Hotf_4pt_reduction(G2H6(218),RedSet_4(12),mass4set(:,2),  & 
G1H6(646),G1H6(647),G1H6(648),G1H6(649),G1H6(650),G0H6(26),6)
  call HG1shiftOLR(G1H6(647),10,6)
  call Hotf_5pt_reduction(G2H6(219),RedSet_5(9),mass5set(:,3),  & 
G1H6(651),G1H6(652),G1H6(653),G1H6(654),G1H6(655),G1H6(656),6)
  call HG1shiftOLR(G1H6(652),8,6)
  call Hotf_4pt_reduction(G2H6(221),RedSet_4(7),mass4set(:,3),  & 
G1H6(657),G1H6(658),G1H6(659),G1H6(660),G1H6(661),G0H6(27),6)
  call HG1shiftOLR(G1H6(658),8,6)
  call Hotf_4pt_reduction(G2H6(222),RedSet_4(12),mass4set(:,3),  & 
G1H6(662),G1H6(663),G1H6(664),G1H6(665),G1H6(666),G0H6(34),6)
  call HG1shiftOLR(G1H6(663),10,6)
  call Hotf_4pt_reduction(G2H6(225),RedSet_4(7),mass4set(:,4),  & 
G1H6(667),G1H6(668),G1H6(669),G1H6(670),G1H6(671),6)
  call HG1shiftOLR(G1H6(668),8,6)
  call Hotf_4pt_reduction(G2H6(226),RedSet_4(12),mass4set(:,4),  & 
G1H6(672),G1H6(673),G1H6(674),G1H6(675),G1H6(676),6)
  call HG1shiftOLR(G1H6(673),10,6)
  call Hotf_4pt_reduction(G2H6(229),RedSet_4(7),mass4set(:,5),  & 
G1H6(677),G1H6(678),G1H6(679),G1H6(680),G1H6(681),6)
  call HG1shiftOLR(G1H6(678),8,6)
  call Hotf_4pt_reduction(G2H6(230),RedSet_4(12),mass4set(:,5),  & 
G1H6(682),G1H6(683),G1H6(684),G1H6(685),G1H6(686),6)
  call HG1shiftOLR(G1H6(683),10,6)
  call Hloop_SV_V(ntryL,G2H6(233),ex2(:),G2H3(107),m3h2x3(:,211),heltab2x6(:,:,405))
  call Hloop_SV_V(ntryL,G2H6(234),ex2(:),G2H3(109),m3h2x3(:,212),heltab2x6(:,:,406))
  call Hloop_SV_V(ntryL,G2H6(237),ex2(:),G2H3(110),m3h2x3(:,213),heltab2x6(:,:,407))
  call Hloop_SV_V(ntryL,G2H6(238),ex2(:),G2H3(111),m3h2x3(:,214),heltab2x6(:,:,408))
  call Hloop_VV_S(ntryL,G2H6(241),ex2(:),G2H3(113),m3h2x3(:,215),heltab2x6(:,:,409))
  call Hloop_VV_S(ntryL,G2H6(242),ex2(:),G2H3(114),m3h2x3(:,216),heltab2x6(:,:,410))
  call Hloop_VV_S(ntryL,G2H6(245),ex2(:),G2H3(115),m3h2x3(:,217),heltab2x6(:,:,411))
  call Hloop_VV_S(ntryL,G2H6(246),ex2(:),G2H3(117),m3h2x3(:,218),heltab2x6(:,:,412))
  call Hotf_4pt_reduction(G2H6(249),RedSet_4(7),mass4set(:,6),  & 
G1H6(687),G1H6(688),G1H6(689),G1H6(690),G1H6(691),6)
  call HG1shiftOLR(G1H6(688),8,6)
  call Hotf_4pt_reduction(G2H6(250),RedSet_4(12),mass4set(:,6),  & 
G1H6(692),G1H6(693),G1H6(694),G1H6(695),G1H6(696),6)
  call HG1shiftOLR(G1H6(693),10,6)
  call Hotf_5pt_reduction(G2H6(251),RedSet_5(10),mass5set(:,7),  & 
G1H6(697),G1H6(698),G1H6(699),G1H6(700),G1H6(701),G1H6(702),6)
  call HG1shiftOLR(G1H6(698),2,6)
  call Hotf_4pt_reduction(G2H6(254),RedSet_4(13),mass4set(:,7),  & 
G1H6(703),G1H6(704),G1H6(705),G1H6(706),G1H6(707),G0H6(30),6)
  call HG1shiftOLR(G1H6(704),2,6)
  call Hotf_4pt_reduction(G2H6(255),RedSet_4(12),mass4set(:,2),  & 
G1H6(708),G1H6(709),G1H6(710),G1H6(711),G1H6(712),G0H6(31),6)
  call HG1shiftOLR(G1H6(709),10,6)
  call Hotf_5pt_reduction(G2H6(256),RedSet_5(10),mass5set(:,8),  & 
G1H6(713),G1H6(714),G1H6(715),G1H6(716),G1H6(717),G1H6(718),6)
  call HG1shiftOLR(G1H6(714),2,6)
  call Hotf_4pt_reduction(G2H6(259),RedSet_4(13),mass4set(:,8),  & 
G1H6(719),G1H6(720),G1H6(721),G1H6(722),G1H6(723),G0H6(32),6)
  call HG1shiftOLR(G1H6(720),2,6)
  call Hotf_4pt_reduction(G2H6(260),RedSet_4(12),mass4set(:,3),  & 
G1H6(724),G1H6(725),G1H6(726),G1H6(727),G1H6(728),G0H6(33),6)
  call HG1shiftOLR(G1H6(725),10,6)
  call Hotf_5pt_reduction(G2H4(35),RedSet_5(11),mass5set(:,9),  & 
G1H4(79),G1H4(80),G1H4(81),G1H4(82),G1H4(83),G1H4(84),4)
  call HG1shiftOLR(G1H4(80),4,4)
  call Hotf_4pt_reduction(G2H4(37),RedSet_4(9),mass4set(:,8),  & 
G1H4(85),G1H4(86),G1H4(87),G1H4(88),G1H4(89),G0H4(1),4)
  call HG1shiftOLR(G1H4(86),4,4)
  call Hotf_4pt_reduction(G2H4(38),RedSet_4(14),mass4set(:,8),  & 
G1H4(90),G1H4(91),G1H4(92),G1H4(93),G1H4(94),G0H4(2),4)
  call HG1shiftOLR(G1H4(91),6,4)
  call Hotf_5pt_reduction(G2H4(39),RedSet_5(11),mass5set(:,10),  & 
G1H4(95),G1H4(96),G1H4(97),G1H4(98),G1H4(99),G1H4(100),4)
  call HG1shiftOLR(G1H4(96),4,4)
  call Hotf_4pt_reduction(G2H4(41),RedSet_4(9),mass4set(:,7),  & 
G1H4(101),G1H4(102),G1H4(103),G1H4(104),G1H4(105),G0H4(3),4)
  call HG1shiftOLR(G1H4(102),4,4)
  call Hotf_4pt_reduction(G2H4(42),RedSet_4(14),mass4set(:,7),  & 
G1H4(106),G1H4(107),G1H4(108),G1H4(109),G1H4(110),G0H4(4),4)
  call HG1shiftOLR(G1H4(107),6,4)
  call Hotf_4pt_reduction(G2H4(45),RedSet_4(9),mass4set(:,9),  & 
G1H4(111),G1H4(112),G1H4(113),G1H4(114),G1H4(115),4)
  call HG1shiftOLR(G1H4(112),4,4)
  call Hotf_4pt_reduction(G2H4(46),RedSet_4(14),mass4set(:,9),  & 
G1H4(116),G1H4(117),G1H4(118),G1H4(119),G1H4(120),4)
  call HG1shiftOLR(G1H4(117),6,4)
  call Hloop_VV_S(ntryL,G2H4(47),ex2(:),G2H2(37),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_VV_S(ntryL,G2H4(49),ex2(:),G2H2(39),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_VV_S(ntryL,G2H4(50),ex2(:),G2H2(40),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_SV_V(ntryL,G2H4(53),ex2(:),G2H2(41),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_SV_V(ntryL,G2H4(54),ex2(:),G2H2(43),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hotf_5pt_reduction(G2H4(55),RedSet_5(11),mass5set(:,11),  & 
G1H4(121),G1H4(122),G1H4(123),G1H4(124),G1H4(125),G1H4(126),4)
  call HG1shiftOLR(G1H4(122),4,4)
  call Hotf_4pt_reduction(G2H4(57),RedSet_4(9),mass4set(:,9),  & 
G1H4(127),G1H4(128),G1H4(129),G1H4(130),G1H4(131),4)
  call HG1shiftOLR(G1H4(128),4,4)
  call Hotf_4pt_reduction(G2H4(58),RedSet_4(14),mass4set(:,9),  & 
G1H4(132),G1H4(133),G1H4(134),G1H4(135),G1H4(136),4)
  call HG1shiftOLR(G1H4(133),6,4)
  call Hotf_5pt_reduction(G2H4(59),RedSet_5(12),mass5set(:,9),  & 
G1H4(137),G1H4(138),G1H4(139),G1H4(140),G1H4(141),G1H4(142),4)
  call HG1shiftOLR(G1H4(138),2,4)
  call Hotf_4pt_reduction(G2H4(61),RedSet_4(13),mass4set(:,8),  & 
G1H4(143),G1H4(144),G1H4(145),G1H4(146),G1H4(147),G0H4(5),4)
  call HG1shiftOLR(G1H4(144),2,4)
  call Hotf_4pt_reduction(G2H4(62),RedSet_4(14),mass4set(:,8),  & 
G1H4(148),G1H4(149),G1H4(150),G1H4(151),G1H4(152),G0H4(6),4)
  call HG1shiftOLR(G1H4(149),6,4)
  call Hotf_5pt_reduction(G2H4(63),RedSet_5(12),mass5set(:,10),  & 
G1H4(153),G1H4(154),G1H4(155),G1H4(156),G1H4(157),G1H4(158),4)
  call HG1shiftOLR(G1H4(154),2,4)
  call Hotf_4pt_reduction(G2H4(65),RedSet_4(13),mass4set(:,7),  & 
G1H4(159),G1H4(160),G1H4(161),G1H4(162),G1H4(163),G0H4(7),4)
  call HG1shiftOLR(G1H4(160),2,4)
  call Hotf_4pt_reduction(G2H4(66),RedSet_4(14),mass4set(:,7),  & 
G1H4(164),G1H4(165),G1H4(166),G1H4(167),G1H4(168),G0H4(8),4)
  call HG1shiftOLR(G1H4(165),6,4)
  call Hotf_4pt_reduction(G2H4(69),RedSet_4(13),mass4set(:,9),  & 
G1H4(169),G1H4(170),G1H4(171),G1H4(172),G1H4(173),4)
  call HG1shiftOLR(G1H4(170),2,4)
  call Hotf_4pt_reduction(G2H4(70),RedSet_4(14),mass4set(:,9),  & 
G1H4(174),G1H4(175),G1H4(176),G1H4(177),G1H4(178),4)
  call HG1shiftOLR(G1H4(175),6,4)
  call Hloop_VV_S(ntryL,G2H4(71),ex3(:),G2H2(44),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_VV_S(ntryL,G2H4(73),ex3(:),G2H2(57),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_VV_S(ntryL,G2H4(74),ex3(:),G2H2(58),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_SV_V(ntryL,G2H4(77),ex3(:),G2H2(59),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_SV_V(ntryL,G2H4(78),ex3(:),G2H2(60),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hotf_5pt_reduction(G2H4(79),RedSet_5(12),mass5set(:,11),  & 
G1H4(179),G1H4(180),G1H4(181),G1H4(182),G1H4(183),G1H4(184),4)
  call HG1shiftOLR(G1H4(180),2,4)
  call Hotf_4pt_reduction(G2H4(81),RedSet_4(13),mass4set(:,9),  & 
G1H4(185),G1H4(186),G1H4(187),G1H4(188),G1H4(189),4)
  call HG1shiftOLR(G1H4(186),2,4)
  call Hotf_4pt_reduction(G2H4(82),RedSet_4(14),mass4set(:,9),  & 
G1H4(190),G1H4(191),G1H4(192),G1H4(193),G1H4(194),4)
  call HG1shiftOLR(G1H4(191),6,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(369),[G1H6(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(374),[G1H6(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(379),[G1H6(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(384),[G1H6(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(389),[G1H6(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(394),[G1H6(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(457),[G1H6(235)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(462),[G1H6(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(467),[G1H6(237)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(472),[G1H6(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(447),[G1H6(240)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(452),[G1H6(242)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(133),[G1H3(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(138),[G1H3(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(143),[G1H3(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(148),[G1H3(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(153),[G1H3(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(158),[G1H3(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(577),[G1H6(285)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(582),[G1H6(286)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(557),[G1H6(292)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(562),[G1H6(293)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(567),[G1H6(299)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(572),[G1H6(300)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(211),[G1H3(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(216),[G1H3(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(221),[G1H3(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(226),[G1H3(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(231),[G1H3(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(236),[G1H3(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(687),[G1H6(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(692),[G1H6(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(667),[G1H6(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(672),[G1H6(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(677),[G1H6(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(682),[G1H6(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(111),[G1H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(116),[G1H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(169),[G1H4(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(174),[G1H4(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(163),[G1H6(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(249),[G1H6(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(343),[G1H6(340)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(348),[G1H6(342)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(359),[G1H6(357)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(364),[G1H6(358)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(405),[G1H6(403)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(410),[G1H6(404)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(421),[G1H6(419)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(426),[G1H6(420)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(437),[G1H6(435)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(442),[G1H6(436)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(91),[G1H3(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(96),[G1H3(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(107),[G1H3(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(112),[G1H3(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(123),[G1H3(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(128),[G1H3(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(483),[G1H6(481)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(488),[G1H6(482)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(499),[G1H6(497)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(504),[G1H6(498)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(515),[G1H6(513)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(520),[G1H6(514)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(531),[G1H6(529)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(536),[G1H6(530)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(547),[G1H6(545)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(552),[G1H6(546)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(593),[G1H6(591)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(598),[G1H6(592)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(609),[G1H6(607)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(614),[G1H6(608)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(169),[G1H3(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(174),[G1H3(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(185),[G1H3(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(190),[G1H3(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(201),[G1H3(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(206),[G1H3(200)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(25),[G1H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(30),[G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(41),[G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(46),[G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(625),[G1H6(623)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(630),[G1H6(624)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(641),[G1H6(639)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(646),[G1H6(640)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(657),[G1H6(655)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(662),[G1H6(656)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(703),[G1H6(701)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(708),[G1H6(702)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(719),[G1H6(717)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(724),[G1H6(718)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(85),[G1H4(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(90),[G1H4(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(101),[G1H4(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(106),[G1H4(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(127),[G1H4(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(132),[G1H4(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(143),[G1H4(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(148),[G1H4(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(159),[G1H4(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(164),[G1H4(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(185),[G1H4(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(190),[G1H4(184)])
  call Hloop_SV_T(ntryL,G1H6(21),21,ex2(:),2,G2H3(118),m3h2x3(:,219),heltab2x6(:,:,413))
call HGT_OLR(G1H6(120),1,1,6)
call HGT_invQ_OLR(G1H6(120),2,5,6)
  call Hloop_TV_S(ntryL,G1H6(120),-8,ex4(:),8,G2H2(61),m3h3x2(:,57),heltab2x6(:,:,414))
  call Hloop_SV_T(ntryL,G1H6(23),21,ex2(:),2,G2H3(119),m3h2x3(:,220),heltab2x6(:,:,415))
  call Hloop_SV_T(ntryL,G1H6(122),21,ex2(:),2,G2H3(121),m3h2x3(:,221),heltab2x6(:,:,416))
  call Hloop_SV_T(ntryL,G1H6(8),21,ex2(:),2,G2H3(122),m3h2x3(:,222),heltab2x6(:,:,417))
call HGT_OLR(G1H6(123),1,1,6)
call HGT_invQ_OLR(G1H6(123),2,5,6)
  call Hloop_TV_S(ntryL,G1H6(123),-8,ex4(:),8,G2H2(62),m3h3x2(:,58),heltab2x6(:,:,418))
  call Hloop_SV_T(ntryL,G1H6(126),21,ex2(:),2,G2H3(125),m3h2x3(:,223),heltab2x6(:,:,419))
  call Hloop_SV_T(ntryL,G1H6(29),21,ex2(:),2,G2H3(126),m3h2x3(:,224),heltab2x6(:,:,420))
  call Hloop_DV_C(ntryL,G1H6(127),21,ex2(:),G2H3(129),m3h2x3(:,225),heltab2x6(:,:,421))
call HGT_OLR(G1H6(1),1,1,6)
call HGT_invQ_OLR(G1H6(1),2,5,6)
  call Hloop_CV_D(ntryL,G1H6(1),-8,ex4(:),8,G2H2(63),m3h3x2(:,59),heltab2x6(:,:,422))
  call Hloop_DV_C(ntryL,G1H6(131),21,ex2(:),G2H3(130),m3h2x3(:,226),heltab2x6(:,:,423))
  call Hloop_DV_C(ntryL,G1H6(132),21,ex2(:),G2H3(133),m3h2x3(:,227),heltab2x6(:,:,424))
  call Hloop_DV_C(ntryL,G1H6(133),21,ex2(:),G2H3(134),m3h2x3(:,228),heltab2x6(:,:,425))
call HGT_OLR(G1H6(134),1,1,6)
call HGT_invQ_OLR(G1H6(134),2,5,6)
  call Hloop_CV_D(ntryL,G1H6(134),-8,ex4(:),8,G2H2(64),m3h3x2(:,60),heltab2x6(:,:,426))
  call Hloop_DV_C(ntryL,G1H6(138),21,ex2(:),G2H3(137),m3h2x3(:,229),heltab2x6(:,:,427))
  call Hloop_DV_C(ntryL,G1H6(139),21,ex2(:),G2H3(138),m3h2x3(:,230),heltab2x6(:,:,428))
  call Hloop_CV_D(ntryL,G1H6(41),21,ex2(:),2,G2H3(141),m3h2x3(:,231),heltab2x6(:,:,429))
call HGT_OLR(G1H6(42),1,1,6)
call HGT_invQ_OLR(G1H6(42),2,5,6)
  call Hloop_DV_C(ntryL,G1H6(42),-8,ex4(:),G2H2(65),m3h3x2(:,61),heltab2x6(:,:,430))
  call Hloop_CV_D(ntryL,G1H6(141),21,ex2(:),2,G2H3(142),m3h2x3(:,232),heltab2x6(:,:,431))
  call Hloop_CV_D(ntryL,G1H6(142),21,ex2(:),2,G2H3(161),m3h2x3(:,233),heltab2x6(:,:,432))
  call Hloop_CV_D(ntryL,G1H6(143),21,ex2(:),2,G2H3(162),m3h2x3(:,234),heltab2x6(:,:,433))
call HGT_OLR(G1H6(145),1,1,6)
call HGT_invQ_OLR(G1H6(145),2,5,6)
  call Hloop_DV_C(ntryL,G1H6(145),-8,ex4(:),G2H2(66),m3h3x2(:,62),heltab2x6(:,:,434))
  call Hloop_CV_D(ntryL,G1H6(148),21,ex2(:),2,G2H3(163),m3h2x3(:,235),heltab2x6(:,:,435))
  call Hloop_CV_D(ntryL,G1H6(149),21,ex2(:),2,G2H3(164),m3h2x3(:,236),heltab2x6(:,:,436))
  call Hloop_UW_V(ntryL,G1H6(151),21,ex2(:),2,G2H3(165),m3h2x3(:,237),heltab2x6(:,:,437))
call HGT_raise_alpha_OLR(G1H6(152),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(152),2,5,6)
  call Hloop_UW_V(ntryL,G1H6(152),-8,ex4(:),8,G2H2(67),m3h3x2(:,63),heltab2x6(:,:,438))
  call Hloop_UW_V(ntryL,G1H6(50),21,ex2(:),2,G2H3(166),m3h2x3(:,238),heltab2x6(:,:,439))
  call Hloop_UW_V(ntryL,G1H6(154),21,ex2(:),2,G2H3(167),m3h2x3(:,239),heltab2x6(:,:,440))
  call Hloop_UW_V(ntryL,G1H6(155),21,ex2(:),2,G2H3(168),m3h2x3(:,240),heltab2x6(:,:,441))
call HGT_raise_alpha_OLR(G1H6(156),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(156),2,5,6)
  call Hloop_UW_V(ntryL,G1H6(156),-8,ex4(:),8,G2H2(68),m3h3x2(:,64),heltab2x6(:,:,442))
  call Hloop_UW_V(ntryL,G1H6(160),21,ex2(:),2,G2H3(169),m3h2x3(:,241),heltab2x6(:,:,443))
  call Hloop_UW_V(ntryL,G1H6(161),21,ex2(:),2,G2H3(170),m3h2x3(:,242),heltab2x6(:,:,444))
  call Hloop_SV_T(ntryL,G1H6(162),21,ex2(:),2,G2H3(171),m3h2x3(:,243),heltab2x6(:,:,445))
call HGT_raise_alpha_OLR(G1H6(52),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(52),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(52),ex4(:),G1H2(23),m3h3x2(:,65),heltab2x6(:,:,446))
  call Hloop_SV_T(ntryL,G1H6(369),21,ex2(:),2,G2H3(172),m3h2x3(:,244),heltab2x6(:,:,447))
  call Hloop_SV_T(ntryL,G1H6(374),21,ex2(:),2,G2H3(173),m3h2x3(:,245),heltab2x6(:,:,448))
  call Hloop_SV_T(ntryL,G1H6(169),21,ex2(:),2,G2H3(174),m3h2x3(:,246),heltab2x6(:,:,449))
call HGT_raise_alpha_OLR(G1H6(170),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(170),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(170),ex4(:),G1H2(24),m3h3x2(:,66),heltab2x6(:,:,450))
  call Hloop_SV_T(ntryL,G1H6(379),21,ex2(:),2,G2H3(175),m3h2x3(:,247),heltab2x6(:,:,451))
  call Hloop_SV_T(ntryL,G1H6(384),21,ex2(:),2,G2H3(176),m3h2x3(:,248),heltab2x6(:,:,452))
  call Hloop_UW_V(ntryL,G1H6(176),21,ex2(:),2,G2H3(177),m3h2x3(:,249),heltab2x6(:,:,453))
call HGT_OLR(G1H6(178),1,1,6)
call HGT_invQ_OLR(G1H6(178),2,5,6)
  call Hloop_SV_V(ntryL,G1H6(178),ex4(:),G1H2(39),m3h3x2(:,67),heltab2x6(:,:,454))
  call Hloop_UW_V(ntryL,G1H6(389),21,ex2(:),2,G2H3(178),m3h2x3(:,250),heltab2x6(:,:,455))
  call Hloop_UW_V(ntryL,G1H6(394),21,ex2(:),2,G2H3(179),m3h2x3(:,251),heltab2x6(:,:,456))
  call Hloop_SV_T(ntryL,G1H6(184),19,ex3(:),4,G2H3(180),m3h2x3(:,252),heltab2x6(:,:,457))
call HGT_OLR(G1H6(185),1,1,6)
call HGT_invQ_OLR(G1H6(185),2,5,6)
  call Hloop_TV_S(ntryL,G1H6(185),-8,ex4(:),8,G2H2(69),m3h3x2(:,68),heltab2x6(:,:,458))
  call Hloop_SV_T(ntryL,G1H6(188),19,ex3(:),4,G2H3(181),m3h2x3(:,253),heltab2x6(:,:,459))
  call Hloop_SV_T(ntryL,G1H6(190),19,ex3(:),4,G2H3(182),m3h2x3(:,254),heltab2x6(:,:,460))
  call Hloop_SV_T(ntryL,G1H6(191),19,ex3(:),4,G2H3(183),m3h2x3(:,255),heltab2x6(:,:,461))
call HGT_OLR(G1H6(192),1,1,6)
call HGT_invQ_OLR(G1H6(192),2,5,6)
  call Hloop_TV_S(ntryL,G1H6(192),-8,ex4(:),8,G2H2(70),m3h3x2(:,69),heltab2x6(:,:,462))
  call Hloop_SV_T(ntryL,G1H6(196),19,ex3(:),4,G2H3(184),m3h2x3(:,256),heltab2x6(:,:,463))
  call Hloop_SV_T(ntryL,G1H6(197),19,ex3(:),4,G2H3(185),m3h2x3(:,257),heltab2x6(:,:,464))
  call Hloop_DV_C(ntryL,G1H6(198),19,ex3(:),G2H3(186),m3h2x3(:,258),heltab2x6(:,:,465))
call HGT_OLR(G1H6(199),1,1,6)
call HGT_invQ_OLR(G1H6(199),2,5,6)
  call Hloop_CV_D(ntryL,G1H6(199),-8,ex4(:),8,G2H2(71),m3h3x2(:,70),heltab2x6(:,:,466))
  call Hloop_DV_C(ntryL,G1H6(203),19,ex3(:),G2H3(187),m3h2x3(:,259),heltab2x6(:,:,467))
  call Hloop_DV_C(ntryL,G1H6(204),19,ex3(:),G2H3(188),m3h2x3(:,260),heltab2x6(:,:,468))
  call Hloop_DV_C(ntryL,G1H6(205),19,ex3(:),G2H3(189),m3h2x3(:,261),heltab2x6(:,:,469))
call HGT_OLR(G1H6(206),1,1,6)
call HGT_invQ_OLR(G1H6(206),2,5,6)
  call Hloop_CV_D(ntryL,G1H6(206),-8,ex4(:),8,G2H2(72),m3h3x2(:,71),heltab2x6(:,:,470))
  call Hloop_DV_C(ntryL,G1H6(210),19,ex3(:),G2H3(190),m3h2x3(:,262),heltab2x6(:,:,471))
  call Hloop_DV_C(ntryL,G1H6(211),19,ex3(:),G2H3(191),m3h2x3(:,263),heltab2x6(:,:,472))
  call Hloop_CV_D(ntryL,G1H6(212),19,ex3(:),4,G2H3(192),m3h2x3(:,264),heltab2x6(:,:,473))
call HGT_OLR(G1H6(214),1,1,6)
call HGT_invQ_OLR(G1H6(214),2,5,6)
  call Hloop_DV_C(ntryL,G1H6(214),-8,ex4(:),G2H2(73),m3h3x2(:,72),heltab2x6(:,:,474))
  call Hloop_CV_D(ntryL,G1H6(217),19,ex3(:),4,G2H3(193),m3h2x3(:,265),heltab2x6(:,:,475))
  call Hloop_CV_D(ntryL,G1H6(218),19,ex3(:),4,G2H3(194),m3h2x3(:,266),heltab2x6(:,:,476))
  call Hloop_CV_D(ntryL,G1H6(220),19,ex3(:),4,G2H3(195),m3h2x3(:,267),heltab2x6(:,:,477))
call HGT_OLR(G1H6(221),1,1,6)
call HGT_invQ_OLR(G1H6(221),2,5,6)
  call Hloop_DV_C(ntryL,G1H6(221),-8,ex4(:),G2H2(74),m3h3x2(:,73),heltab2x6(:,:,478))
  call Hloop_CV_D(ntryL,G1H6(224),19,ex3(:),4,G2H3(196),m3h2x3(:,268),heltab2x6(:,:,479))
  call Hloop_CV_D(ntryL,G1H6(226),19,ex3(:),4,G2H3(197),m3h2x3(:,269),heltab2x6(:,:,480))
  call Hloop_UW_V(ntryL,G1H6(227),19,ex3(:),4,G2H3(198),m3h2x3(:,270),heltab2x6(:,:,481))
call HGT_raise_alpha_OLR(G1H6(228),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(228),2,5,6)
  call Hloop_UW_V(ntryL,G1H6(228),-8,ex4(:),8,G2H2(75),m3h3x2(:,74),heltab2x6(:,:,482))
  call Hloop_UW_V(ntryL,G1H6(56),19,ex3(:),4,G2H3(199),m3h2x3(:,271),heltab2x6(:,:,483))
  call Hloop_UW_V(ntryL,G1H6(229),19,ex3(:),4,G2H3(200),m3h2x3(:,272),heltab2x6(:,:,484))
  call Hloop_UW_V(ntryL,G1H6(230),19,ex3(:),4,G2H3(201),m3h2x3(:,273),heltab2x6(:,:,485))
call HGT_raise_alpha_OLR(G1H6(67),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(67),2,5,6)
  call Hloop_UW_V(ntryL,G1H6(67),-8,ex4(:),8,G2H2(76),m3h3x2(:,75),heltab2x6(:,:,486))
  call Hloop_UW_V(ntryL,G1H6(71),19,ex3(:),4,G2H3(202),m3h2x3(:,274),heltab2x6(:,:,487))
  call Hloop_UW_V(ntryL,G1H6(72),19,ex3(:),4,G2H3(203),m3h2x3(:,275),heltab2x6(:,:,488))
  call Hloop_SV_T(ntryL,G1H6(66),19,ex3(:),4,G2H3(204),m3h2x3(:,276),heltab2x6(:,:,489))
call HGT_raise_alpha_OLR(G1H6(231),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(231),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(231),ex4(:),G1H2(40),m3h3x2(:,76),heltab2x6(:,:,490))
  call Hloop_SV_T(ntryL,G1H6(457),19,ex3(:),4,G2H3(205),m3h2x3(:,277),heltab2x6(:,:,491))
  call Hloop_SV_T(ntryL,G1H6(462),19,ex3(:),4,G2H3(206),m3h2x3(:,278),heltab2x6(:,:,492))
  call Hloop_SV_T(ntryL,G1H6(31),19,ex3(:),4,G2H3(207),m3h2x3(:,279),heltab2x6(:,:,493))
call HGT_raise_alpha_OLR(G1H6(77),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(77),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(77),ex4(:),G1H2(51),m3h3x2(:,77),heltab2x6(:,:,494))
  call Hloop_SV_T(ntryL,G1H6(467),19,ex3(:),4,G2H3(208),m3h2x3(:,280),heltab2x6(:,:,495))
  call Hloop_SV_T(ntryL,G1H6(472),19,ex3(:),4,G2H3(209),m3h2x3(:,281),heltab2x6(:,:,496))
  call Hloop_UW_V(ntryL,G1H6(238),19,ex3(:),4,G2H3(210),m3h2x3(:,282),heltab2x6(:,:,497))
call HGT_OLR(G1H6(3),1,1,6)
call HGT_invQ_OLR(G1H6(3),2,5,6)
  call Hloop_SV_V(ntryL,G1H6(3),ex4(:),G1H2(52),m3h3x2(:,78),heltab2x6(:,:,498))
  call Hloop_UW_V(ntryL,G1H6(447),19,ex3(:),4,G2H3(211),m3h2x3(:,283),heltab2x6(:,:,499))
  call Hloop_UW_V(ntryL,G1H6(452),19,ex3(:),4,G2H3(212),m3h2x3(:,284),heltab2x6(:,:,500))
  call Hloop_VT_S(ntryL,G1H3(15),22,ex1(:),1,G2H3(213),m3h1x3(:,55),heltab2x3(:,:,55))
call HGT_OLR(G1H3(1),1,1,3)
call HGT_invQ_OLR(G1H3(1),2,5,3)
  call Hloop_TV_S(ntryL,G1H3(1),-8,ex4(:),8,G2H1(1),m3h3x1(:,1),heltab2x3(:,:,56))
  call Hloop_VT_S(ntryL,G1H3(4),22,ex1(:),1,G2H3(214),m3h1x3(:,56),heltab2x3(:,:,57))
  call Hloop_VT_S(ntryL,G1H3(5),22,ex1(:),1,G2H3(215),m3h1x3(:,57),heltab2x3(:,:,58))
  call Hloop_VT_S(ntryL,G1H3(6),22,ex1(:),1,G2H3(216),m3h1x3(:,58),heltab2x3(:,:,59))
call HGT_OLR(G1H3(7),1,1,3)
call HGT_invQ_OLR(G1H3(7),2,5,3)
  call Hloop_TV_S(ntryL,G1H3(7),-8,ex4(:),8,G2H1(2),m3h3x1(:,2),heltab2x3(:,:,60))
  call Hloop_VT_S(ntryL,G1H3(10),22,ex1(:),1,G2H3(217),m3h1x3(:,59),heltab2x3(:,:,61))
  call Hloop_VT_S(ntryL,G1H3(11),22,ex1(:),1,G2H3(218),m3h1x3(:,60),heltab2x3(:,:,62))
  call Hloop_ST_V(ntryL,G1H3(12),22,ex1(:),1,G2H3(219),m3h1x3(:,61),heltab2x3(:,:,63))
call HGT_raise_alpha_OLR(G1H3(13),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(13),2,5,3)
  call Hloop_UW_V(ntryL,G1H3(13),-8,ex4(:),8,G2H1(3),m3h3x1(:,3),heltab2x3(:,:,64))
  call Hloop_ST_V(ntryL,G1H3(17),22,ex1(:),1,G2H3(220),m3h1x3(:,62),heltab2x3(:,:,65))
  call Hloop_ST_V(ntryL,G1H3(18),22,ex1(:),1,G2H3(221),m3h1x3(:,63),heltab2x3(:,:,66))
  call Hloop_ST_V(ntryL,G1H3(19),22,ex1(:),1,G2H3(222),m3h1x3(:,64),heltab2x3(:,:,67))
call HGT_raise_alpha_OLR(G1H3(20),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(20),2,5,3)
  call Hloop_UW_V(ntryL,G1H3(20),-8,ex4(:),8,G2H1(4),m3h3x1(:,4),heltab2x3(:,:,68))
  call Hloop_ST_V(ntryL,G1H3(23),22,ex1(:),1,G2H3(223),m3h1x3(:,65),heltab2x3(:,:,69))
  call Hloop_ST_V(ntryL,G1H3(24),22,ex1(:),1,G2H3(224),m3h1x3(:,66),heltab2x3(:,:,70))
  call Hloop_ST_V(ntryL,G1H3(25),22,ex1(:),1,G2H3(225),m3h1x3(:,67),heltab2x3(:,:,71))
call HGT_OLR(G1H3(26),1,1,3)
call HGT_invQ_OLR(G1H3(26),2,5,3)
  call Hloop_SV_V(ntryL,G1H3(26),ex4(:),G1H1(1),m3h3x1(:,5),heltab2x3(:,:,72))
  call Hloop_ST_V(ntryL,G1H3(133),22,ex1(:),1,G2H3(226),m3h1x3(:,68),heltab2x3(:,:,73))
  call Hloop_ST_V(ntryL,G1H3(138),22,ex1(:),1,G2H3(227),m3h1x3(:,69),heltab2x3(:,:,74))
  call Hloop_VT_S(ntryL,G1H3(31),22,ex1(:),1,G2H3(228),m3h1x3(:,70),heltab2x3(:,:,75))
call HGT_raise_alpha_OLR(G1H3(32),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(32),2,5,3)
  call Hloop_VV_S(ntryL,G1H3(32),ex4(:),G1H1(2),m3h3x1(:,6),heltab2x3(:,:,76))
  call Hloop_VT_S(ntryL,G1H3(143),22,ex1(:),1,G2H3(229),m3h1x3(:,71),heltab2x3(:,:,77))
  call Hloop_VT_S(ntryL,G1H3(148),22,ex1(:),1,G2H3(230),m3h1x3(:,72),heltab2x3(:,:,78))
  call Hloop_VT_S(ntryL,G1H3(37),22,ex1(:),1,G2H3(231),m3h1x3(:,73),heltab2x3(:,:,79))
call HGT_raise_alpha_OLR(G1H3(38),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(38),2,5,3)
  call Hloop_VV_S(ntryL,G1H3(38),ex4(:),G1H1(3),m3h3x1(:,7),heltab2x3(:,:,80))
  call Hloop_VT_S(ntryL,G1H3(153),22,ex1(:),1,G2H3(232),m3h1x3(:,74),heltab2x3(:,:,81))
  call Hloop_VT_S(ntryL,G1H3(158),22,ex1(:),1,G2H3(233),m3h1x3(:,75),heltab2x3(:,:,82))
  call Hloop_SV_T(ntryL,G1H6(39),19,ex3(:),4,G2H3(234),m3h2x3(:,285),heltab2x6(:,:,501))
call HGT_OLR(G1H6(243),1,1,6)
call HGT_invQ_OLR(G1H6(243),2,5,6)
  call Hloop_TV_S(ntryL,G1H6(243),-8,ex4(:),8,G2H2(77),m3h3x2(:,79),heltab2x6(:,:,502))
  call Hloop_SV_T(ntryL,G1H6(48),19,ex3(:),4,G2H3(235),m3h2x3(:,286),heltab2x6(:,:,503))
  call Hloop_SV_T(ntryL,G1H6(53),19,ex3(:),4,G2H3(236),m3h2x3(:,287),heltab2x6(:,:,504))
  call Hloop_SV_T(ntryL,G1H6(54),19,ex3(:),4,G2H3(237),m3h2x3(:,288),heltab2x6(:,:,505))
call HGT_OLR(G1H6(55),1,1,6)
call HGT_invQ_OLR(G1H6(55),2,5,6)
  call Hloop_TV_S(ntryL,G1H6(55),-8,ex4(:),8,G2H2(78),m3h3x2(:,80),heltab2x6(:,:,506))
  call Hloop_SV_T(ntryL,G1H6(63),19,ex3(:),4,G2H3(238),m3h2x3(:,289),heltab2x6(:,:,507))
  call Hloop_SV_T(ntryL,G1H6(73),19,ex3(:),4,G2H3(239),m3h2x3(:,290),heltab2x6(:,:,508))
  call Hloop_DV_C(ntryL,G1H6(74),19,ex3(:),G2H3(240),m3h2x3(:,291),heltab2x6(:,:,509))
call HGT_OLR(G1H6(79),1,1,6)
call HGT_invQ_OLR(G1H6(79),2,5,6)
  call Hloop_CV_D(ntryL,G1H6(79),-8,ex4(:),8,G2H2(79),m3h3x2(:,81),heltab2x6(:,:,510))
  call Hloop_DV_C(ntryL,G1H6(86),19,ex3(:),G2H3(241),m3h2x3(:,292),heltab2x6(:,:,511))
  call Hloop_DV_C(ntryL,G1H6(87),19,ex3(:),G2H3(242),m3h2x3(:,293),heltab2x6(:,:,512))
  call Hloop_DV_C(ntryL,G1H6(89),19,ex3(:),G2H3(243),m3h2x3(:,294),heltab2x6(:,:,513))
call HGT_OLR(G1H6(90),1,1,6)
call HGT_invQ_OLR(G1H6(90),2,5,6)
  call Hloop_CV_D(ntryL,G1H6(90),-8,ex4(:),8,G2H2(80),m3h3x2(:,82),heltab2x6(:,:,514))
  call Hloop_DV_C(ntryL,G1H6(100),19,ex3(:),G2H3(244),m3h2x3(:,295),heltab2x6(:,:,515))
  call Hloop_DV_C(ntryL,G1H6(5),19,ex3(:),G2H3(245),m3h2x3(:,296),heltab2x6(:,:,516))
  call Hloop_CV_D(ntryL,G1H6(6),19,ex3(:),4,G2H3(246),m3h2x3(:,297),heltab2x6(:,:,517))
call HGT_OLR(G1H6(252),1,1,6)
call HGT_invQ_OLR(G1H6(252),2,5,6)
  call Hloop_DV_C(ntryL,G1H6(252),-8,ex4(:),G2H2(81),m3h3x2(:,83),heltab2x6(:,:,518))
  call Hloop_CV_D(ntryL,G1H6(256),19,ex3(:),4,G2H3(247),m3h2x3(:,298),heltab2x6(:,:,519))
  call Hloop_CV_D(ntryL,G1H6(257),19,ex3(:),4,G2H3(248),m3h2x3(:,299),heltab2x6(:,:,520))
  call Hloop_CV_D(ntryL,G1H6(258),19,ex3(:),4,G2H3(249),m3h2x3(:,300),heltab2x6(:,:,521))
call HGT_OLR(G1H6(259),1,1,6)
call HGT_invQ_OLR(G1H6(259),2,5,6)
  call Hloop_DV_C(ntryL,G1H6(259),-8,ex4(:),G2H2(82),m3h3x2(:,84),heltab2x6(:,:,522))
  call Hloop_CV_D(ntryL,G1H6(263),19,ex3(:),4,G2H3(250),m3h2x3(:,301),heltab2x6(:,:,523))
  call Hloop_CV_D(ntryL,G1H6(264),19,ex3(:),4,G2H3(251),m3h2x3(:,302),heltab2x6(:,:,524))
  call Hloop_UW_V(ntryL,G1H6(265),19,ex3(:),4,G2H3(252),m3h2x3(:,303),heltab2x6(:,:,525))
call HGT_raise_alpha_OLR(G1H6(267),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(267),2,5,6)
  call Hloop_UW_V(ntryL,G1H6(267),-8,ex4(:),8,G2H2(83),m3h3x2(:,85),heltab2x6(:,:,526))
  call Hloop_UW_V(ntryL,G1H6(270),19,ex3(:),4,G2H3(253),m3h2x3(:,304),heltab2x6(:,:,527))
  call Hloop_UW_V(ntryL,G1H6(271),19,ex3(:),4,G2H3(254),m3h2x3(:,305),heltab2x6(:,:,528))
  call Hloop_UW_V(ntryL,G1H6(273),19,ex3(:),4,G2H3(255),m3h2x3(:,306),heltab2x6(:,:,529))
call HGT_raise_alpha_OLR(G1H6(274),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(274),2,5,6)
  call Hloop_UW_V(ntryL,G1H6(274),-8,ex4(:),8,G2H2(84),m3h3x2(:,86),heltab2x6(:,:,530))
  call Hloop_UW_V(ntryL,G1H6(277),19,ex3(:),4,G2H3(256),m3h2x3(:,307),heltab2x6(:,:,531))
  call Hloop_UW_V(ntryL,G1H6(279),19,ex3(:),4,G2H3(257),m3h2x3(:,308),heltab2x6(:,:,532))
  call Hloop_UW_V(ntryL,G1H6(280),19,ex3(:),4,G2H3(258),m3h2x3(:,309),heltab2x6(:,:,533))
call HGT_OLR(G1H6(281),1,1,6)
call HGT_invQ_OLR(G1H6(281),2,5,6)
  call Hloop_SV_V(ntryL,G1H6(281),ex4(:),G1H2(53),m3h3x2(:,87),heltab2x6(:,:,534))
  call Hloop_UW_V(ntryL,G1H6(577),19,ex3(:),4,G2H3(259),m3h2x3(:,310),heltab2x6(:,:,535))
  call Hloop_UW_V(ntryL,G1H6(582),19,ex3(:),4,G2H3(260),m3h2x3(:,311),heltab2x6(:,:,536))
  call Hloop_SV_T(ntryL,G1H6(287),19,ex3(:),4,G2H3(261),m3h2x3(:,312),heltab2x6(:,:,537))
call HGT_raise_alpha_OLR(G1H6(288),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(288),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(288),ex4(:),G1H2(54),m3h3x2(:,88),heltab2x6(:,:,538))
  call Hloop_SV_T(ntryL,G1H6(557),19,ex3(:),4,G2H3(262),m3h2x3(:,313),heltab2x6(:,:,539))
  call Hloop_SV_T(ntryL,G1H6(562),19,ex3(:),4,G2H3(263),m3h2x3(:,314),heltab2x6(:,:,540))
  call Hloop_SV_T(ntryL,G1H6(294),19,ex3(:),4,G2H3(264),m3h2x3(:,315),heltab2x6(:,:,541))
call HGT_raise_alpha_OLR(G1H6(295),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(295),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(295),ex4(:),G1H2(55),m3h3x2(:,89),heltab2x6(:,:,542))
  call Hloop_SV_T(ntryL,G1H6(567),19,ex3(:),4,G2H3(265),m3h2x3(:,316),heltab2x6(:,:,543))
  call Hloop_SV_T(ntryL,G1H6(572),19,ex3(:),4,G2H3(266),m3h2x3(:,317),heltab2x6(:,:,544))
  call Hloop_VT_S(ntryL,G1H3(43),22,ex1(:),1,G2H3(267),m3h1x3(:,76),heltab2x3(:,:,83))
call HGT_OLR(G1H3(44),1,1,3)
call HGT_invQ_OLR(G1H3(44),2,5,3)
  call Hloop_TV_S(ntryL,G1H3(44),-8,ex4(:),8,G2H1(5),m3h3x1(:,8),heltab2x3(:,:,84))
  call Hloop_VT_S(ntryL,G1H3(47),22,ex1(:),1,G2H3(268),m3h1x3(:,77),heltab2x3(:,:,85))
  call Hloop_VT_S(ntryL,G1H3(48),22,ex1(:),1,G2H3(269),m3h1x3(:,78),heltab2x3(:,:,86))
  call Hloop_VT_S(ntryL,G1H3(49),22,ex1(:),1,G2H3(270),m3h1x3(:,79),heltab2x3(:,:,87))
call HGT_OLR(G1H3(50),1,1,3)
call HGT_invQ_OLR(G1H3(50),2,5,3)
  call Hloop_TV_S(ntryL,G1H3(50),-8,ex4(:),8,G2H1(6),m3h3x1(:,9),heltab2x3(:,:,88))
  call Hloop_VT_S(ntryL,G1H3(53),22,ex1(:),1,G2H3(271),m3h1x3(:,80),heltab2x3(:,:,89))
  call Hloop_VT_S(ntryL,G1H3(54),22,ex1(:),1,G2H3(272),m3h1x3(:,81),heltab2x3(:,:,90))
  call Hloop_ST_V(ntryL,G1H3(55),22,ex1(:),1,G2H3(273),m3h1x3(:,82),heltab2x3(:,:,91))
call HGT_raise_alpha_OLR(G1H3(56),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(56),2,5,3)
  call Hloop_UW_V(ntryL,G1H3(56),-8,ex4(:),8,G2H1(7),m3h3x1(:,10),heltab2x3(:,:,92))
  call Hloop_ST_V(ntryL,G1H3(59),22,ex1(:),1,G2H3(274),m3h1x3(:,83),heltab2x3(:,:,93))
  call Hloop_ST_V(ntryL,G1H3(60),22,ex1(:),1,G2H3(275),m3h1x3(:,84),heltab2x3(:,:,94))
  call Hloop_ST_V(ntryL,G1H3(61),22,ex1(:),1,G2H3(276),m3h1x3(:,85),heltab2x3(:,:,95))
call HGT_raise_alpha_OLR(G1H3(62),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(62),2,5,3)
  call Hloop_UW_V(ntryL,G1H3(62),-8,ex4(:),8,G2H1(8),m3h3x1(:,11),heltab2x3(:,:,96))
  call Hloop_ST_V(ntryL,G1H3(65),22,ex1(:),1,G2H3(277),m3h1x3(:,86),heltab2x3(:,:,97))
  call Hloop_ST_V(ntryL,G1H3(66),22,ex1(:),1,G2H3(278),m3h1x3(:,87),heltab2x3(:,:,98))
  call Hloop_ST_V(ntryL,G1H3(67),22,ex1(:),1,G2H3(279),m3h1x3(:,88),heltab2x3(:,:,99))
call HGT_OLR(G1H3(68),1,1,3)
call HGT_invQ_OLR(G1H3(68),2,5,3)
  call Hloop_SV_V(ntryL,G1H3(68),ex4(:),G1H1(4),m3h3x1(:,12),heltab2x3(:,:,100))
  call Hloop_ST_V(ntryL,G1H3(211),22,ex1(:),1,G2H3(280),m3h1x3(:,89),heltab2x3(:,:,101))
  call Hloop_ST_V(ntryL,G1H3(216),22,ex1(:),1,G2H3(281),m3h1x3(:,90),heltab2x3(:,:,102))
  call Hloop_VT_S(ntryL,G1H3(73),22,ex1(:),1,G2H3(282),m3h1x3(:,91),heltab2x3(:,:,103))
call HGT_raise_alpha_OLR(G1H3(74),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(74),2,5,3)
  call Hloop_VV_S(ntryL,G1H3(74),ex4(:),G1H1(5),m3h3x1(:,13),heltab2x3(:,:,104))
  call Hloop_VT_S(ntryL,G1H3(221),22,ex1(:),1,G2H3(283),m3h1x3(:,92),heltab2x3(:,:,105))
  call Hloop_VT_S(ntryL,G1H3(226),22,ex1(:),1,G2H3(284),m3h1x3(:,93),heltab2x3(:,:,106))
  call Hloop_VT_S(ntryL,G1H3(79),22,ex1(:),1,G2H3(285),m3h1x3(:,94),heltab2x3(:,:,107))
call HGT_raise_alpha_OLR(G1H3(80),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(80),2,5,3)
  call Hloop_VV_S(ntryL,G1H3(80),ex4(:),G1H1(6),m3h3x1(:,14),heltab2x3(:,:,108))
  call Hloop_VT_S(ntryL,G1H3(231),22,ex1(:),1,G2H3(286),m3h1x3(:,95),heltab2x3(:,:,109))
  call Hloop_VT_S(ntryL,G1H3(236),22,ex1(:),1,G2H3(287),m3h1x3(:,96),heltab2x3(:,:,110))
  call Hloop_SV_T(ntryL,G1H6(301),21,ex2(:),2,G2H3(288),m3h2x3(:,318),heltab2x6(:,:,545))
call HGT_OLR(G1H6(303),1,1,6)
call HGT_invQ_OLR(G1H6(303),2,5,6)
  call Hloop_TV_S(ntryL,G1H6(303),-8,ex4(:),8,G2H2(85),m3h3x2(:,90),heltab2x6(:,:,546))
  call Hloop_SV_T(ntryL,G1H6(306),21,ex2(:),2,G2H3(289),m3h2x3(:,319),heltab2x6(:,:,547))
  call Hloop_SV_T(ntryL,G1H6(307),21,ex2(:),2,G2H3(290),m3h2x3(:,320),heltab2x6(:,:,548))
  call Hloop_SV_T(ntryL,G1H6(309),21,ex2(:),2,G2H3(291),m3h2x3(:,321),heltab2x6(:,:,549))
call HGT_OLR(G1H6(310),1,1,6)
call HGT_invQ_OLR(G1H6(310),2,5,6)
  call Hloop_TV_S(ntryL,G1H6(310),-8,ex4(:),8,G2H2(86),m3h3x2(:,91),heltab2x6(:,:,550))
  call Hloop_SV_T(ntryL,G1H6(313),21,ex2(:),2,G2H3(292),m3h2x3(:,322),heltab2x6(:,:,551))
  call Hloop_SV_T(ntryL,G1H6(315),21,ex2(:),2,G2H3(293),m3h2x3(:,323),heltab2x6(:,:,552))
  call Hloop_DV_C(ntryL,G1H6(316),21,ex2(:),G2H3(294),m3h2x3(:,324),heltab2x6(:,:,553))
call HGT_OLR(G1H6(317),1,1,6)
call HGT_invQ_OLR(G1H6(317),2,5,6)
  call Hloop_CV_D(ntryL,G1H6(317),-8,ex4(:),8,G2H2(87),m3h3x2(:,92),heltab2x6(:,:,554))
  call Hloop_DV_C(ntryL,G1H6(82),21,ex2(:),G2H3(295),m3h2x3(:,325),heltab2x6(:,:,555))
  call Hloop_DV_C(ntryL,G1H6(318),21,ex2(:),G2H3(296),m3h2x3(:,326),heltab2x6(:,:,556))
  call Hloop_DV_C(ntryL,G1H6(319),21,ex2(:),G2H3(297),m3h2x3(:,327),heltab2x6(:,:,557))
call HGT_OLR(G1H6(93),1,1,6)
call HGT_invQ_OLR(G1H6(93),2,5,6)
  call Hloop_CV_D(ntryL,G1H6(93),-8,ex4(:),8,G2H2(88),m3h3x2(:,93),heltab2x6(:,:,558))
  call Hloop_DV_C(ntryL,G1H6(97),21,ex2(:),G2H3(298),m3h2x3(:,328),heltab2x6(:,:,559))
  call Hloop_DV_C(ntryL,G1H6(98),21,ex2(:),G2H3(299),m3h2x3(:,329),heltab2x6(:,:,560))
  call Hloop_CV_D(ntryL,G1H6(92),21,ex2(:),2,G2H3(300),m3h2x3(:,330),heltab2x6(:,:,561))
call HGT_OLR(G1H6(320),1,1,6)
call HGT_invQ_OLR(G1H6(320),2,5,6)
  call Hloop_DV_C(ntryL,G1H6(320),-8,ex4(:),G2H2(89),m3h3x2(:,94),heltab2x6(:,:,562))
  call Hloop_CV_D(ntryL,G1H6(324),21,ex2(:),2,G2H3(301),m3h2x3(:,331),heltab2x6(:,:,563))
  call Hloop_CV_D(ntryL,G1H6(102),21,ex2(:),2,G2H3(302),m3h2x3(:,332),heltab2x6(:,:,564))
  call Hloop_CV_D(ntryL,G1H6(103),21,ex2(:),2,G2H3(303),m3h2x3(:,333),heltab2x6(:,:,565))
call HGT_OLR(G1H6(325),1,1,6)
call HGT_invQ_OLR(G1H6(325),2,5,6)
  call Hloop_DV_C(ntryL,G1H6(325),-8,ex4(:),G2H2(90),m3h3x2(:,95),heltab2x6(:,:,566))
  call Hloop_CV_D(ntryL,G1H6(328),21,ex2(:),2,G2H3(304),m3h2x3(:,334),heltab2x6(:,:,567))
  call Hloop_CV_D(ntryL,G1H6(329),21,ex2(:),2,G2H3(305),m3h2x3(:,335),heltab2x6(:,:,568))
  call Hloop_UW_V(ntryL,G1H6(331),21,ex2(:),2,G2H3(306),m3h2x3(:,336),heltab2x6(:,:,569))
call HGT_raise_alpha_OLR(G1H6(332),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(332),2,5,6)
  call Hloop_UW_V(ntryL,G1H6(332),-8,ex4(:),8,G2H2(91),m3h3x2(:,96),heltab2x6(:,:,570))
  call Hloop_UW_V(ntryL,G1H6(16),21,ex2(:),2,G2H3(307),m3h2x3(:,337),heltab2x6(:,:,571))
  call Hloop_UW_V(ntryL,G1H6(17),21,ex2(:),2,G2H3(308),m3h2x3(:,338),heltab2x6(:,:,572))
  call Hloop_UW_V(ntryL,G1H6(19),21,ex2(:),2,G2H3(309),m3h2x3(:,339),heltab2x6(:,:,573))
call HGT_raise_alpha_OLR(G1H6(22),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(22),2,5,6)
  call Hloop_UW_V(ntryL,G1H6(22),-8,ex4(:),8,G2H2(92),m3h3x2(:,97),heltab2x6(:,:,574))
  call Hloop_UW_V(ntryL,G1H6(107),21,ex2(:),2,G2H3(310),m3h2x3(:,340),heltab2x6(:,:,575))
  call Hloop_UW_V(ntryL,G1H6(109),21,ex2(:),2,G2H3(311),m3h2x3(:,341),heltab2x6(:,:,576))
  call Hloop_UW_V(ntryL,G1H6(110),21,ex2(:),2,G2H3(312),m3h2x3(:,342),heltab2x6(:,:,577))
call HGT_OLR(G1H6(111),1,1,6)
call HGT_invQ_OLR(G1H6(111),2,5,6)
  call Hloop_SV_V(ntryL,G1H6(111),ex4(:),G1H2(56),m3h3x2(:,98),heltab2x6(:,:,578))
  call Hloop_UW_V(ntryL,G1H6(687),21,ex2(:),2,G2H3(313),m3h2x3(:,343),heltab2x6(:,:,579))
  call Hloop_UW_V(ntryL,G1H6(692),21,ex2(:),2,G2H3(314),m3h2x3(:,344),heltab2x6(:,:,580))
  call Hloop_SV_T(ntryL,G1H6(13),21,ex2(:),2,G2H3(315),m3h2x3(:,345),heltab2x6(:,:,581))
call HGT_raise_alpha_OLR(G1H6(114),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(114),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(114),ex4(:),G1H2(57),m3h3x2(:,99),heltab2x6(:,:,582))
  call Hloop_SV_T(ntryL,G1H6(667),21,ex2(:),2,G2H3(316),m3h2x3(:,346),heltab2x6(:,:,583))
  call Hloop_SV_T(ntryL,G1H6(672),21,ex2(:),2,G2H3(317),m3h2x3(:,347),heltab2x6(:,:,584))
  call Hloop_SV_T(ntryL,G1H6(36),21,ex2(:),2,G2H3(318),m3h2x3(:,348),heltab2x6(:,:,585))
call HGT_raise_alpha_OLR(G1H6(64),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(64),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(64),ex4(:),G1H2(58),m3h3x2(:,100),heltab2x6(:,:,586))
  call Hloop_SV_T(ntryL,G1H6(677),21,ex2(:),2,G2H3(319),m3h2x3(:,349),heltab2x6(:,:,587))
  call Hloop_SV_T(ntryL,G1H6(682),21,ex2(:),2,G2H3(320),m3h2x3(:,350),heltab2x6(:,:,588))
  call Hloop_TV_S(ntryL,G1H4(19),25,ex2(:),2,G2H2(93),m3h2x2(:,31),heltab2x4(:,:,31))
call HGT_OLR(G1H4(5),1,1,4)
call HGT_invQ_OLR(G1H4(5),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(5),-4,ex3(:),4,G2H2(94),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_TV_S(ntryL,G1H4(12),25,ex2(:),2,G2H2(95),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_TV_S(ntryL,G1H4(20),25,ex2(:),2,G2H2(96),m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_TV_S(ntryL,G1H4(21),25,ex2(:),2,G2H2(97),m3h2x2(:,35),heltab2x4(:,:,35))
call HGT_OLR(G1H4(22),1,1,4)
call HGT_invQ_OLR(G1H4(22),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(22),-4,ex3(:),4,G2H2(98),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_TV_S(ntryL,G1H4(25),25,ex2(:),2,G2H2(99),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_TV_S(ntryL,G1H4(26),25,ex2(:),2,G2H2(100),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_CV_D(ntryL,G1H4(27),25,ex2(:),2,G2H2(101),m3h2x2(:,39),heltab2x4(:,:,39))
call HGT_OLR(G1H4(28),1,1,4)
call HGT_invQ_OLR(G1H4(28),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(28),-4,ex3(:),G2H2(102),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_CV_D(ntryL,G1H4(31),25,ex2(:),2,G2H2(103),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_CV_D(ntryL,G1H4(32),25,ex2(:),2,G2H2(104),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_DV_C(ntryL,G1H4(33),25,ex2(:),G2H2(105),m3h2x2(:,43),heltab2x4(:,:,43))
call HGT_OLR(G1H4(34),1,1,4)
call HGT_invQ_OLR(G1H4(34),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(34),-4,ex3(:),4,G2H2(106),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_DV_C(ntryL,G1H4(37),25,ex2(:),G2H2(107),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_DV_C(ntryL,G1H4(38),25,ex2(:),G2H2(108),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_UV_W(ntryL,G1H4(39),25,ex2(:),2,G2H2(109),m3h2x2(:,47),heltab2x4(:,:,47))
call HGT_raise_alpha_OLR(G1H4(40),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(40),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(40),-4,ex3(:),4,G2H2(110),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_UV_W(ntryL,G1H4(43),25,ex2(:),2,G2H2(111),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_UV_W(ntryL,G1H4(44),25,ex2(:),2,G2H2(112),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_TV_S(ntryL,G1H4(1),25,ex2(:),2,G2H2(113),m3h2x2(:,51),heltab2x4(:,:,51))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(2),ex3(:),G1H2(59),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_TV_S(ntryL,G1H4(111),25,ex2(:),2,G2H2(114),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_TV_S(ntryL,G1H4(116),25,ex2(:),2,G2H2(115),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_TV_S(ntryL,G1H4(47),25,ex3(:),4,G2H2(116),m3h2x2(:,55),heltab2x4(:,:,55))
call HGT_OLR(G1H4(48),1,1,4)
call HGT_invQ_OLR(G1H4(48),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(48),-2,ex2(:),2,G2H2(117),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_TV_S(ntryL,G1H4(51),25,ex3(:),4,G2H2(118),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_TV_S(ntryL,G1H4(52),25,ex3(:),4,G2H2(119),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_TV_S(ntryL,G1H4(53),25,ex3(:),4,G2H2(120),m3h2x2(:,59),heltab2x4(:,:,59))
call HGT_OLR(G1H4(54),1,1,4)
call HGT_invQ_OLR(G1H4(54),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(54),-2,ex2(:),2,G2H2(121),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_TV_S(ntryL,G1H4(57),25,ex3(:),4,G2H2(122),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_TV_S(ntryL,G1H4(58),25,ex3(:),4,G2H2(123),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_CV_D(ntryL,G1H4(59),25,ex3(:),4,G2H2(124),m3h2x2(:,63),heltab2x4(:,:,63))
call HGT_OLR(G1H4(60),1,1,4)
call HGT_invQ_OLR(G1H4(60),2,5,4)
  call Hloop_DV_C(ntryL,G1H4(60),-2,ex2(:),G2H2(125),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_CV_D(ntryL,G1H4(63),25,ex3(:),4,G2H2(126),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_CV_D(ntryL,G1H4(64),25,ex3(:),4,G2H2(127),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_DV_C(ntryL,G1H4(65),25,ex3(:),G2H2(128),m3h2x2(:,67),heltab2x4(:,:,67))
call HGT_OLR(G1H4(66),1,1,4)
call HGT_invQ_OLR(G1H4(66),2,5,4)
  call Hloop_CV_D(ntryL,G1H4(66),-2,ex2(:),2,G2H2(129),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_DV_C(ntryL,G1H4(69),25,ex3(:),G2H2(130),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_DV_C(ntryL,G1H4(70),25,ex3(:),G2H2(131),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_UV_W(ntryL,G1H4(71),25,ex3(:),4,G2H2(132),m3h2x2(:,71),heltab2x4(:,:,71))
call HGT_raise_alpha_OLR(G1H4(72),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(72),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(72),-2,ex2(:),2,G2H2(133),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_UV_W(ntryL,G1H4(75),25,ex3(:),4,G2H2(134),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_UV_W(ntryL,G1H4(76),25,ex3(:),4,G2H2(135),m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_TV_S(ntryL,G1H4(7),25,ex3(:),4,G2H2(136),m3h2x2(:,75),heltab2x4(:,:,75))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(8),ex2(:),G1H2(60),m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_TV_S(ntryL,G1H4(169),25,ex3(:),4,G2H2(137),m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_TV_S(ntryL,G1H4(174),25,ex3(:),4,G2H2(138),m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_AV_Q(ntryL,G1H6(128),ex2(:),G1H3(29),m3h2x3(:,351),heltab2x6(:,:,589))
  call Hloop_A_Q(ntryL,G1H3(29),23,nML,G2H3(321),n2h3(39))
call HGT_OLR(G1H6(33),1,1,6)
call HGT_invQ_OLR(G1H6(33),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(33),-8,0,G2H6(1),n2h6(185))
  call Hloop_QW_A(ntryL,G2H6(1),ex4(:),G2H2(139),m3h3x2(:,101),heltab2x6(:,:,590))
  call Hloop_AV_Q(ntryL,G1H6(163),ex2(:),G1H3(30),m3h2x3(:,352),heltab2x6(:,:,591))
  call Hloop_A_Q(ntryL,G1H3(30),23,nML,G2H3(322),n2h3(40))
  call Hloop_AV_Q(ntryL,G1H6(249),ex2(:),G1H3(35),m3h2x3(:,353),heltab2x6(:,:,592))
  call Hloop_A_Q(ntryL,G1H3(35),23,nML,G2H3(323),n2h3(41))
call HGT_OLR(G1H6(245),1,1,6)
call HGT_invQ_OLR(G1H6(245),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(245),-8,0,G2H6(2),n2h6(186))
  call Hloop_QW_A(ntryL,G2H6(2),ex4(:),G2H2(140),m3h3x2(:,102),heltab2x6(:,:,593))
  call Hloop_AV_Q(ntryL,G1H6(248),ex2(:),G1H3(36),m3h2x3(:,354),heltab2x6(:,:,594))
  call Hloop_A_Q(ntryL,G1H3(36),23,nML,G2H3(324),n2h3(42))
  call Hloop_AV_Q(ntryL,G0H6(1),ex2(:),G0H3(13),m3h2x3(:,355),heltab2x6(:,:,595))
  call Hloop_A_Q(ntryL,G0H3(13),23,nML,G1H3(41),n2h3(43))
call HGT_OLR(G1H6(250),1,1,6)
call HGT_invQ_OLR(G1H6(250),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(250),-10,0,G2H6(7),n2h6(187))
  call Hloop_QW_A(ntryL,G2H6(7),ex4(:),G2H2(141),m3h3x2(:,103),heltab2x6(:,:,596))
  call Hloop_AV_Q(ntryL,G1H6(335),ex2(:),G1H3(42),m3h2x3(:,356),heltab2x6(:,:,597))
  call Hloop_A_Q(ntryL,G1H3(42),23,nML,G2H3(325),n2h3(44))
  call Hloop_AV_Q(ntryL,G0H6(11),ex2(:),G0H3(13),m3h2x3(:,357),heltab2x6(:,:,598))
  call Hloop_A_Q(ntryL,G0H3(13),23,nML,G1H3(71),n2h3(45))
  call Hloop_QV_A(ntryL,G1H6(336),ex2(:),G1H3(72),m3h2x3(:,358),heltab2x6(:,:,599))
  call Hloop_Q_A(ntryL,G1H3(72),23,nMT,G2H3(326),n2h3(46))
call HGT_OLR(G1H6(337),1,1,6)
call HGT_invQ_OLR(G1H6(337),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(337),-8,nMB,G2H6(8),n2h6(188))
  call Hloop_AW_Q(ntryL,G2H6(8),ex4(:),G2H2(142),m3h3x2(:,104),heltab2x6(:,:,600))
  call Hloop_QV_A(ntryL,G1H6(343),ex2(:),G1H3(77),m3h2x3(:,359),heltab2x6(:,:,601))
  call Hloop_Q_A(ntryL,G1H3(77),23,nMT,G2H3(327),n2h3(47))
  call Hloop_QV_A(ntryL,G1H6(348),ex2(:),G1H3(78),m3h2x3(:,360),heltab2x6(:,:,602))
  call Hloop_Q_A(ntryL,G1H3(78),23,nMT,G2H3(328),n2h3(48))
call HGT_OLR(G1H6(344),1,1,6)
call HGT_invQ_OLR(G1H6(344),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(344),-8,nMB,G2H6(9),n2h6(189))
  call Hloop_AW_Q(ntryL,G2H6(9),ex4(:),G2H2(143),m3h3x2(:,105),heltab2x6(:,:,603))
  call Hloop_QV_A(ntryL,G1H6(347),ex2(:),G1H3(83),m3h2x3(:,361),heltab2x6(:,:,604))
  call Hloop_Q_A(ntryL,G1H3(83),23,nMT,G2H3(329),n2h3(49))
  call Hloop_QV_A(ntryL,G0H6(12),ex2(:),G0H3(13),m3h2x3(:,362),heltab2x6(:,:,605))
  call Hloop_Q_A(ntryL,G0H3(13),23,nMT,G1H3(84),n2h3(50))
call HGT_OLR(G1H6(349),1,1,6)
call HGT_invQ_OLR(G1H6(349),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(349),-10,nMB,G2H6(13),n2h6(190))
  call Hloop_AW_Q(ntryL,G2H6(13),ex4(:),G2H2(144),m3h3x2(:,106),heltab2x6(:,:,606))
  call Hloop_QV_A(ntryL,G1H6(352),ex2(:),G1H3(89),m3h2x3(:,363),heltab2x6(:,:,607))
  call Hloop_Q_A(ntryL,G1H3(89),23,nMT,G2H3(330),n2h3(51))
  call Hloop_QV_A(ntryL,G0H6(2),ex2(:),G0H3(13),m3h2x3(:,364),heltab2x6(:,:,608))
  call Hloop_Q_A(ntryL,G0H3(13),23,nMT,G1H3(90),n2h3(52))
  call Hloop_AV_Q(ntryL,G1H6(353),ex2(:),G1H3(105),m3h2x3(:,365),heltab2x6(:,:,609))
  call Hloop_A_Q(ntryL,G1H3(105),23,nMB,G2H3(331),n2h3(53))
call HGT_OLR(G1H6(354),1,1,6)
call HGT_invQ_OLR(G1H6(354),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(354),-8,nMT,G2H6(14),n2h6(191))
  call Hloop_QW_A(ntryL,G2H6(14),ex4(:),G2H2(145),m3h3x2(:,107),heltab2x6(:,:,610))
  call Hloop_AV_Q(ntryL,G1H6(359),ex2(:),G1H3(106),m3h2x3(:,366),heltab2x6(:,:,611))
  call Hloop_A_Q(ntryL,G1H3(106),23,nMB,G2H3(332),n2h3(54))
  call Hloop_AV_Q(ntryL,G1H6(364),ex2(:),G1H3(121),m3h2x3(:,367),heltab2x6(:,:,612))
  call Hloop_A_Q(ntryL,G1H3(121),23,nMB,G2H3(333),n2h3(55))
call HGT_OLR(G1H6(360),1,1,6)
call HGT_invQ_OLR(G1H6(360),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(360),-8,nMT,G2H6(19),n2h6(192))
  call Hloop_QW_A(ntryL,G2H6(19),ex4(:),G2H2(146),m3h3x2(:,108),heltab2x6(:,:,613))
  call Hloop_AV_Q(ntryL,G1H6(363),ex2(:),G1H3(122),m3h2x3(:,368),heltab2x6(:,:,614))
  call Hloop_A_Q(ntryL,G1H3(122),23,nMB,G2H3(334),n2h3(56))
  call Hloop_AV_Q(ntryL,G0H6(5),ex2(:),G0H3(13),m3h2x3(:,369),heltab2x6(:,:,615))
  call Hloop_A_Q(ntryL,G0H3(13),23,nMB,G1H3(167),n2h3(57))
call HGT_OLR(G1H6(365),1,1,6)
call HGT_invQ_OLR(G1H6(365),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(365),-10,nMT,G2H6(20),n2h6(193))
  call Hloop_QW_A(ntryL,G2H6(20),ex4(:),G2H2(147),m3h3x2(:,109),heltab2x6(:,:,616))
  call Hloop_AV_Q(ntryL,G1H6(368),ex2(:),G1H3(168),m3h2x3(:,370),heltab2x6(:,:,617))
  call Hloop_A_Q(ntryL,G1H3(168),23,nMB,G2H3(335),n2h3(58))
  call Hloop_AV_Q(ntryL,G0H6(3),ex2(:),G0H3(13),m3h2x3(:,371),heltab2x6(:,:,618))
  call Hloop_A_Q(ntryL,G0H3(13),23,nMB,G1H3(183),n2h3(59))
call HGT_raise_alpha_OLR(G1H6(370),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(370),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(370),ex4(:),G1H2(61),m3h3x2(:,110),heltab2x6(:,:,619))
  call Hloop_SV_T(ntryL,G1H6(373),21,ex2(:),2,G2H3(336),m3h2x3(:,372),heltab2x6(:,:,620))
call HGT_raise_alpha_OLR(G1H6(375),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(375),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(375),ex4(:),G1H2(62),m3h3x2(:,111),heltab2x6(:,:,621))
  call Hloop_SV_T(ntryL,G1H6(378),21,ex2(:),2,G2H3(337),m3h2x3(:,373),heltab2x6(:,:,622))
call HGT_raise_alpha_OLR(G1H6(380),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(380),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(380),ex4(:),G1H2(63),m3h3x2(:,112),heltab2x6(:,:,623))
  call Hloop_SV_T(ntryL,G1H6(383),21,ex2(:),2,G2H3(338),m3h2x3(:,374),heltab2x6(:,:,624))
call HGT_raise_alpha_OLR(G1H6(385),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(385),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(385),ex4(:),G1H2(64),m3h3x2(:,113),heltab2x6(:,:,625))
  call Hloop_SV_T(ntryL,G1H6(388),21,ex2(:),2,G2H3(339),m3h2x3(:,375),heltab2x6(:,:,626))
call HGT_OLR(G1H6(390),1,1,6)
call HGT_invQ_OLR(G1H6(390),2,5,6)
  call Hloop_SV_V(ntryL,G1H6(390),ex4(:),G1H2(65),m3h3x2(:,114),heltab2x6(:,:,627))
  call Hloop_UW_V(ntryL,G1H6(393),21,ex2(:),2,G2H3(340),m3h2x3(:,376),heltab2x6(:,:,628))
call HGT_OLR(G1H6(395),1,1,6)
call HGT_invQ_OLR(G1H6(395),2,5,6)
  call Hloop_SV_V(ntryL,G1H6(395),ex4(:),G1H2(66),m3h3x2(:,115),heltab2x6(:,:,629))
  call Hloop_UW_V(ntryL,G1H6(398),21,ex2(:),2,G2H3(341),m3h2x3(:,377),heltab2x6(:,:,630))
  call Hloop_AV_Q(ntryL,G1H6(399),ex3(:),G1H3(184),m3h2x3(:,378),heltab2x6(:,:,631))
  call Hloop_A_Q(ntryL,G1H3(184),23,nML,G2H3(342),n2h3(60))
call HGT_OLR(G1H6(400),1,1,6)
call HGT_invQ_OLR(G1H6(400),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(400),-8,0,G2H6(25),n2h6(200))
  call Hloop_QW_A(ntryL,G2H6(25),ex4(:),G2H2(148),m3h3x2(:,116),heltab2x6(:,:,632))
  call Hloop_AV_Q(ntryL,G1H6(405),ex3(:),G1H3(199),m3h2x3(:,379),heltab2x6(:,:,633))
  call Hloop_A_Q(ntryL,G1H3(199),23,nML,G2H3(343),n2h3(61))
  call Hloop_AV_Q(ntryL,G1H6(410),ex3(:),G1H3(200),m3h2x3(:,380),heltab2x6(:,:,634))
  call Hloop_A_Q(ntryL,G1H3(200),23,nML,G2H3(344),n2h3(62))
call HGT_OLR(G1H6(406),1,1,6)
call HGT_invQ_OLR(G1H6(406),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(406),-8,0,G2H6(26),n2h6(201))
  call Hloop_QW_A(ntryL,G2H6(26),ex4(:),G2H2(149),m3h3x2(:,117),heltab2x6(:,:,635))
  call Hloop_AV_Q(ntryL,G1H6(409),ex3(:),G1H3(15),m3h2x3(:,381),heltab2x6(:,:,636))
  call Hloop_A_Q(ntryL,G1H3(15),23,nML,G2H3(345),n2h3(63))
  call Hloop_AV_Q(ntryL,G0H6(4),ex3(:),G0H3(13),m3h2x3(:,382),heltab2x6(:,:,637))
  call Hloop_A_Q(ntryL,G0H3(13),23,nML,G1H3(1),n2h3(64))
call HGT_OLR(G1H6(411),1,1,6)
call HGT_invQ_OLR(G1H6(411),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(411),-12,0,G2H6(27),n2h6(202))
  call Hloop_QW_A(ntryL,G2H6(27),ex4(:),G2H2(150),m3h3x2(:,118),heltab2x6(:,:,638))
  call Hloop_AV_Q(ntryL,G1H6(414),ex3(:),G1H3(4),m3h2x3(:,383),heltab2x6(:,:,639))
  call Hloop_A_Q(ntryL,G1H3(4),23,nML,G2H3(346),n2h3(65))
  call Hloop_AV_Q(ntryL,G0H6(8),ex3(:),G0H3(13),m3h2x3(:,384),heltab2x6(:,:,640))
  call Hloop_A_Q(ntryL,G0H3(13),23,nML,G1H3(5),n2h3(66))
  call Hloop_QV_A(ntryL,G1H6(415),ex3(:),G1H3(6),m3h2x3(:,385),heltab2x6(:,:,641))
  call Hloop_Q_A(ntryL,G1H3(6),23,nMT,G2H3(347),n2h3(67))
call HGT_OLR(G1H6(416),1,1,6)
call HGT_invQ_OLR(G1H6(416),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(416),-8,nMB,G2H6(30),n2h6(203))
  call Hloop_AW_Q(ntryL,G2H6(30),ex4(:),G2H2(151),m3h3x2(:,119),heltab2x6(:,:,642))
  call Hloop_QV_A(ntryL,G1H6(421),ex3(:),G1H3(7),m3h2x3(:,386),heltab2x6(:,:,643))
  call Hloop_Q_A(ntryL,G1H3(7),23,nMT,G2H3(348),n2h3(68))
  call Hloop_QV_A(ntryL,G1H6(426),ex3(:),G1H3(10),m3h2x3(:,387),heltab2x6(:,:,644))
  call Hloop_Q_A(ntryL,G1H3(10),23,nMT,G2H3(349),n2h3(69))
call HGT_OLR(G1H6(422),1,1,6)
call HGT_invQ_OLR(G1H6(422),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(422),-8,nMB,G2H6(31),n2h6(204))
  call Hloop_AW_Q(ntryL,G2H6(31),ex4(:),G2H2(152),m3h3x2(:,120),heltab2x6(:,:,645))
  call Hloop_QV_A(ntryL,G1H6(425),ex3(:),G1H3(11),m3h2x3(:,388),heltab2x6(:,:,646))
  call Hloop_Q_A(ntryL,G1H3(11),23,nMT,G2H3(350),n2h3(70))
  call Hloop_QV_A(ntryL,G0H6(6),ex3(:),G0H3(13),m3h2x3(:,389),heltab2x6(:,:,647))
  call Hloop_Q_A(ntryL,G0H3(13),23,nMT,G1H3(12),n2h3(71))
call HGT_OLR(G1H6(427),1,1,6)
call HGT_invQ_OLR(G1H6(427),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(427),-12,nMB,G2H6(37),n2h6(205))
  call Hloop_AW_Q(ntryL,G2H6(37),ex4(:),G2H2(153),m3h3x2(:,121),heltab2x6(:,:,648))
  call Hloop_QV_A(ntryL,G1H6(430),ex3(:),G1H3(13),m3h2x3(:,390),heltab2x6(:,:,649))
  call Hloop_Q_A(ntryL,G1H3(13),23,nMT,G2H3(351),n2h3(72))
  call Hloop_QV_A(ntryL,G0H6(7),ex3(:),G0H3(13),m3h2x3(:,391),heltab2x6(:,:,650))
  call Hloop_Q_A(ntryL,G0H3(13),23,nMT,G1H3(17),n2h3(73))
  call Hloop_AV_Q(ntryL,G1H6(431),ex3(:),G1H3(18),m3h2x3(:,392),heltab2x6(:,:,651))
  call Hloop_A_Q(ntryL,G1H3(18),23,nMB,G2H3(352),n2h3(74))
call HGT_OLR(G1H6(432),1,1,6)
call HGT_invQ_OLR(G1H6(432),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(432),-8,nMT,G2H6(38),n2h6(206))
  call Hloop_QW_A(ntryL,G2H6(38),ex4(:),G2H2(154),m3h3x2(:,122),heltab2x6(:,:,652))
  call Hloop_AV_Q(ntryL,G1H6(437),ex3(:),G1H3(19),m3h2x3(:,393),heltab2x6(:,:,653))
  call Hloop_A_Q(ntryL,G1H3(19),23,nMB,G2H3(353),n2h3(75))
  call Hloop_AV_Q(ntryL,G1H6(442),ex3(:),G1H3(20),m3h2x3(:,394),heltab2x6(:,:,654))
  call Hloop_A_Q(ntryL,G1H3(20),23,nMB,G2H3(354),n2h3(76))
call HGT_OLR(G1H6(438),1,1,6)
call HGT_invQ_OLR(G1H6(438),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(438),-8,nMT,G2H6(43),n2h6(207))
  call Hloop_QW_A(ntryL,G2H6(43),ex4(:),G2H2(155),m3h3x2(:,123),heltab2x6(:,:,655))
  call Hloop_AV_Q(ntryL,G1H6(441),ex3(:),G1H3(23),m3h2x3(:,395),heltab2x6(:,:,656))
  call Hloop_A_Q(ntryL,G1H3(23),23,nMB,G2H3(355),n2h3(77))
  call Hloop_AV_Q(ntryL,G0H6(9),ex3(:),G0H3(13),m3h2x3(:,396),heltab2x6(:,:,657))
  call Hloop_A_Q(ntryL,G0H3(13),23,nMB,G1H3(24),n2h3(78))
call HGT_OLR(G1H6(443),1,1,6)
call HGT_invQ_OLR(G1H6(443),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(443),-12,nMT,G2H6(44),n2h6(208))
  call Hloop_QW_A(ntryL,G2H6(44),ex4(:),G2H2(156),m3h3x2(:,124),heltab2x6(:,:,658))
  call Hloop_AV_Q(ntryL,G1H6(446),ex3(:),G1H3(25),m3h2x3(:,397),heltab2x6(:,:,659))
  call Hloop_A_Q(ntryL,G1H3(25),23,nMB,G2H3(356),n2h3(79))
  call Hloop_AV_Q(ntryL,G0H6(10),ex3(:),G0H3(13),m3h2x3(:,398),heltab2x6(:,:,660))
  call Hloop_A_Q(ntryL,G0H3(13),23,nMB,G1H3(26),n2h3(80))
call HGT_OLR(G1H6(448),1,1,6)
call HGT_invQ_OLR(G1H6(448),2,5,6)
  call Hloop_SV_V(ntryL,G1H6(448),ex4(:),G1H2(67),m3h3x2(:,125),heltab2x6(:,:,661))
  call Hloop_UW_V(ntryL,G1H6(451),19,ex3(:),4,G2H3(357),m3h2x3(:,399),heltab2x6(:,:,662))
call HGT_OLR(G1H6(453),1,1,6)
call HGT_invQ_OLR(G1H6(453),2,5,6)
  call Hloop_SV_V(ntryL,G1H6(453),ex4(:),G1H2(68),m3h3x2(:,126),heltab2x6(:,:,663))
  call Hloop_UW_V(ntryL,G1H6(456),19,ex3(:),4,G2H3(358),m3h2x3(:,400),heltab2x6(:,:,664))
call HGT_raise_alpha_OLR(G1H6(458),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(458),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(458),ex4(:),G1H2(69),m3h3x2(:,127),heltab2x6(:,:,665))
  call Hloop_SV_T(ntryL,G1H6(461),19,ex3(:),4,G2H3(359),m3h2x3(:,401),heltab2x6(:,:,666))
call HGT_raise_alpha_OLR(G1H6(463),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(463),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(463),ex4(:),G1H2(70),m3h3x2(:,128),heltab2x6(:,:,667))
  call Hloop_SV_T(ntryL,G1H6(466),19,ex3(:),4,G2H3(360),m3h2x3(:,402),heltab2x6(:,:,668))
call HGT_raise_alpha_OLR(G1H6(468),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(468),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(468),ex4(:),G1H2(71),m3h3x2(:,129),heltab2x6(:,:,669))
  call Hloop_SV_T(ntryL,G1H6(471),19,ex3(:),4,G2H3(361),m3h2x3(:,403),heltab2x6(:,:,670))
call HGT_raise_alpha_OLR(G1H6(473),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(473),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(473),ex4(:),G1H2(72),m3h3x2(:,130),heltab2x6(:,:,671))
  call Hloop_SV_T(ntryL,G1H6(476),19,ex3(:),4,G2H3(362),m3h2x3(:,404),heltab2x6(:,:,672))
  call Hloop_AS_Q(ntryL,G1H3(85),ex1(:),G1H3(133),ngH,m3h1x3(:,97),heltab2x3(:,:,111))
  call Hloop_A_Q(ntryL,G1H3(133),23,nML,G2H3(363),n2h3(81))
call HGT_OLR(G1H3(86),1,1,3)
call HGT_invQ_OLR(G1H3(86),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(86),-8,0,G2H3(364),n2h3(82))
  call Hloop_QW_A(ntryL,G2H3(364),ex4(:),G2H1(9),m3h3x1(:,15),heltab2x3(:,:,112))
  call Hloop_AS_Q(ntryL,G1H3(91),ex1(:),G1H3(138),ngH,m3h1x3(:,98),heltab2x3(:,:,113))
  call Hloop_A_Q(ntryL,G1H3(138),23,nML,G2H3(364),n2h3(83))
  call Hloop_AS_Q(ntryL,G1H3(96),ex1(:),G1H3(31),ngH,m3h1x3(:,99),heltab2x3(:,:,114))
  call Hloop_A_Q(ntryL,G1H3(31),23,nML,G2H3(365),n2h3(84))
call HGT_OLR(G1H3(92),1,1,3)
call HGT_invQ_OLR(G1H3(92),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(92),-8,0,G2H3(366),n2h3(85))
  call Hloop_QW_A(ntryL,G2H3(366),ex4(:),G2H1(10),m3h3x1(:,16),heltab2x3(:,:,115))
  call Hloop_AS_Q(ntryL,G1H3(95),ex1(:),G1H3(32),ngH,m3h1x3(:,100),heltab2x3(:,:,116))
  call Hloop_A_Q(ntryL,G1H3(32),23,nML,G2H3(366),n2h3(86))
  call Hloop_AS_Q(ntryL,G0H3(1),ex1(:),G0H3(13),ngH,m3h1x3(:,101),heltab2x3(:,:,117))
  call Hloop_A_Q(ntryL,G0H3(13),23,nML,G1H3(143),n2h3(87))
call HGT_OLR(G1H3(97),1,1,3)
call HGT_invQ_OLR(G1H3(97),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(97),-9,0,G2H3(367),n2h3(88))
  call Hloop_QW_A(ntryL,G2H3(367),ex4(:),G2H1(11),m3h3x1(:,17),heltab2x3(:,:,118))
  call Hloop_AS_Q(ntryL,G1H3(100),ex1(:),G1H3(148),ngH,m3h1x3(:,102),heltab2x3(:,:,119))
  call Hloop_A_Q(ntryL,G1H3(148),23,nML,G2H3(367),n2h3(89))
  call Hloop_AS_Q(ntryL,G0H3(2),ex1(:),G0H3(1),ngH,m3h1x3(:,103),heltab2x3(:,:,120))
  call Hloop_A_Q(ntryL,G0H3(1),23,nML,G1H3(37),n2h3(90))
  call Hloop_QS_A(ntryL,G1H3(101),ex1(:),G1H3(38),ngH,m3h1x3(:,104),heltab2x3(:,:,121))
  call Hloop_Q_A(ntryL,G1H3(38),23,nMT,G2H3(368),n2h3(91))
call HGT_OLR(G1H3(102),1,1,3)
call HGT_invQ_OLR(G1H3(102),2,5,3)
  call Hloop_A_Q(ntryL,G1H3(102),-8,nMB,G2H3(369),n2h3(92))
  call Hloop_AW_Q(ntryL,G2H3(369),ex4(:),G2H1(12),m3h3x1(:,18),heltab2x3(:,:,122))
  call Hloop_QS_A(ntryL,G1H3(107),ex1(:),G1H3(153),ngH,m3h1x3(:,105),heltab2x3(:,:,123))
  call Hloop_Q_A(ntryL,G1H3(153),23,nMT,G2H3(369),n2h3(93))
  call Hloop_QS_A(ntryL,G1H3(112),ex1(:),G1H3(158),ngH,m3h1x3(:,106),heltab2x3(:,:,124))
  call Hloop_Q_A(ntryL,G1H3(158),23,nMT,G2H3(370),n2h3(94))
call HGT_OLR(G1H3(108),1,1,3)
call HGT_invQ_OLR(G1H3(108),2,5,3)
  call Hloop_A_Q(ntryL,G1H3(108),-8,nMB,G2H3(371),n2h3(95))
  call Hloop_AW_Q(ntryL,G2H3(371),ex4(:),G2H1(13),m3h3x1(:,19),heltab2x3(:,:,125))
  call Hloop_QS_A(ntryL,G1H3(111),ex1(:),G1H3(43),ngH,m3h1x3(:,107),heltab2x3(:,:,126))
  call Hloop_Q_A(ntryL,G1H3(43),23,nMT,G2H3(371),n2h3(96))
  call Hloop_QS_A(ntryL,G0H3(3),ex1(:),G0H3(13),ngH,m3h1x3(:,108),heltab2x3(:,:,127))
  call Hloop_Q_A(ntryL,G0H3(13),23,nMT,G1H3(44),n2h3(97))
call HGT_OLR(G1H3(113),1,1,3)
call HGT_invQ_OLR(G1H3(113),2,5,3)
  call Hloop_A_Q(ntryL,G1H3(113),-9,nMB,G2H3(372),n2h3(98))
  call Hloop_AW_Q(ntryL,G2H3(372),ex4(:),G2H1(14),m3h3x1(:,20),heltab2x3(:,:,128))
  call Hloop_QS_A(ntryL,G1H3(116),ex1(:),G1H3(47),ngH,m3h1x3(:,109),heltab2x3(:,:,129))
  call Hloop_Q_A(ntryL,G1H3(47),23,nMT,G2H3(372),n2h3(99))
  call Hloop_QS_A(ntryL,G0H3(4),ex1(:),G0H3(2),ngH,m3h1x3(:,110),heltab2x3(:,:,130))
  call Hloop_Q_A(ntryL,G0H3(2),23,nMT,G1H3(48),n2h3(100))
  call Hloop_AS_Q(ntryL,G1H3(117),ex1(:),G1H3(49),ngH,m3h1x3(:,111),heltab2x3(:,:,131))
  call Hloop_A_Q(ntryL,G1H3(49),23,nMB,G2H3(373),n2h3(101))
call HGT_OLR(G1H3(118),1,1,3)
call HGT_invQ_OLR(G1H3(118),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(118),-8,nMT,G2H3(374),n2h3(102))
  call Hloop_QW_A(ntryL,G2H3(374),ex4(:),G2H1(15),m3h3x1(:,21),heltab2x3(:,:,132))
  call Hloop_AS_Q(ntryL,G1H3(123),ex1(:),G1H3(50),ngH,m3h1x3(:,112),heltab2x3(:,:,133))
  call Hloop_A_Q(ntryL,G1H3(50),23,nMB,G2H3(374),n2h3(103))
  call Hloop_AS_Q(ntryL,G1H3(128),ex1(:),G1H3(53),ngH,m3h1x3(:,113),heltab2x3(:,:,134))
  call Hloop_A_Q(ntryL,G1H3(53),23,nMB,G2H3(375),n2h3(104))
call HGT_OLR(G1H3(124),1,1,3)
call HGT_invQ_OLR(G1H3(124),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(124),-8,nMT,G2H3(376),n2h3(105))
  call Hloop_QW_A(ntryL,G2H3(376),ex4(:),G2H1(16),m3h3x1(:,22),heltab2x3(:,:,135))
  call Hloop_AS_Q(ntryL,G1H3(127),ex1(:),G1H3(54),ngH,m3h1x3(:,114),heltab2x3(:,:,136))
  call Hloop_A_Q(ntryL,G1H3(54),23,nMB,G2H3(376),n2h3(106))
  call Hloop_AS_Q(ntryL,G0H3(5),ex1(:),G0H3(1),ngH,m3h1x3(:,115),heltab2x3(:,:,137))
  call Hloop_A_Q(ntryL,G0H3(1),23,nMB,G1H3(55),n2h3(107))
call HGT_OLR(G1H3(129),1,1,3)
call HGT_invQ_OLR(G1H3(129),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(129),-9,nMT,G2H3(377),n2h3(108))
  call Hloop_QW_A(ntryL,G2H3(377),ex4(:),G2H1(17),m3h3x1(:,23),heltab2x3(:,:,138))
  call Hloop_AS_Q(ntryL,G1H3(132),ex1(:),G1H3(56),ngH,m3h1x3(:,116),heltab2x3(:,:,139))
  call Hloop_A_Q(ntryL,G1H3(56),23,nMB,G2H3(377),n2h3(109))
  call Hloop_AS_Q(ntryL,G0H3(6),ex1(:),G0H3(3),ngH,m3h1x3(:,117),heltab2x3(:,:,140))
  call Hloop_A_Q(ntryL,G0H3(3),23,nMB,G1H3(59),n2h3(110))
call HGT_OLR(G1H3(134),1,1,3)
call HGT_invQ_OLR(G1H3(134),2,5,3)
  call Hloop_SV_V(ntryL,G1H3(134),ex4(:),G1H1(7),m3h3x1(:,24),heltab2x3(:,:,141))
  call Hloop_ST_V(ntryL,G1H3(137),22,ex1(:),1,G2H3(378),m3h1x3(:,118),heltab2x3(:,:,142))
call HGT_OLR(G1H3(139),1,1,3)
call HGT_invQ_OLR(G1H3(139),2,5,3)
  call Hloop_SV_V(ntryL,G1H3(139),ex4(:),G1H1(8),m3h3x1(:,25),heltab2x3(:,:,143))
  call Hloop_ST_V(ntryL,G1H3(142),22,ex1(:),1,G2H3(379),m3h1x3(:,119),heltab2x3(:,:,144))
call HGT_raise_alpha_OLR(G1H3(144),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(144),2,5,3)
  call Hloop_VV_S(ntryL,G1H3(144),ex4(:),G1H1(9),m3h3x1(:,26),heltab2x3(:,:,145))
  call Hloop_VT_S(ntryL,G1H3(147),22,ex1(:),1,G2H3(380),m3h1x3(:,120),heltab2x3(:,:,146))
call HGT_raise_alpha_OLR(G1H3(149),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(149),2,5,3)
  call Hloop_VV_S(ntryL,G1H3(149),ex4(:),G1H1(10),m3h3x1(:,27),heltab2x3(:,:,147))
  call Hloop_VT_S(ntryL,G1H3(152),22,ex1(:),1,G2H3(381),m3h1x3(:,121),heltab2x3(:,:,148))
call HGT_raise_alpha_OLR(G1H3(154),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(154),2,5,3)
  call Hloop_VV_S(ntryL,G1H3(154),ex4(:),G1H1(11),m3h3x1(:,28),heltab2x3(:,:,149))
  call Hloop_VT_S(ntryL,G1H3(157),22,ex1(:),1,G2H3(382),m3h1x3(:,122),heltab2x3(:,:,150))
call HGT_raise_alpha_OLR(G1H3(159),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(159),2,5,3)
  call Hloop_VV_S(ntryL,G1H3(159),ex4(:),G1H1(12),m3h3x1(:,29),heltab2x3(:,:,151))
  call Hloop_VT_S(ntryL,G1H3(162),22,ex1(:),1,G2H3(383),m3h1x3(:,123),heltab2x3(:,:,152))
  call Hloop_QW_A(ntryL,G1H6(477),ex4(:),G1H2(73),m3h3x2(:,131),heltab2x6(:,:,673))
  call Hloop_Q_A(ntryL,G1H2(73),27,nMB,G2H2(157),n2h2(9))
call HGT_OLR(G1H6(478),1,1,6)
call HGT_invQ_OLR(G1H6(478),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(478),-4,nMB,G2H6(45),n2h6(215))
  call Hloop_AV_Q(ntryL,G2H6(45),ex3(:),G2H3(384),m3h2x3(:,405),heltab2x6(:,:,674))
  call Hloop_QW_A(ntryL,G1H6(483),ex4(:),G1H2(73),m3h3x2(:,132),heltab2x6(:,:,675))
  call Hloop_Q_A(ntryL,G1H2(73),27,nMB,G2H2(158),n2h2(10))
  call Hloop_QW_A(ntryL,G1H6(488),ex4(:),G1H2(73),m3h3x2(:,133),heltab2x6(:,:,676))
  call Hloop_Q_A(ntryL,G1H2(73),27,nMB,G2H2(159),n2h2(11))
call HGT_OLR(G1H6(484),1,1,6)
call HGT_invQ_OLR(G1H6(484),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(484),-4,nMB,G2H6(48),n2h6(216))
  call Hloop_AV_Q(ntryL,G2H6(48),ex3(:),G2H3(385),m3h2x3(:,406),heltab2x6(:,:,677))
  call Hloop_QW_A(ntryL,G1H6(487),ex4(:),G1H2(73),m3h3x2(:,134),heltab2x6(:,:,678))
  call Hloop_Q_A(ntryL,G1H2(73),27,nMB,G2H2(160),n2h2(12))
  call Hloop_QW_A(ntryL,G0H6(13),ex4(:),G0H2(7),m3h3x2(:,135),heltab2x6(:,:,679))
  call Hloop_Q_A(ntryL,G0H2(7),27,nMB,G1H2(73),n2h2(13))
call HGT_OLR(G1H6(489),1,1,6)
call HGT_invQ_OLR(G1H6(489),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(489),-12,nMB,G2H6(49),n2h6(217))
  call Hloop_AV_Q(ntryL,G2H6(49),ex3(:),G2H3(386),m3h2x3(:,407),heltab2x6(:,:,680))
  call Hloop_QW_A(ntryL,G1H6(492),ex4(:),G1H2(74),m3h3x2(:,136),heltab2x6(:,:,681))
  call Hloop_Q_A(ntryL,G1H2(74),27,nMB,G2H2(161),n2h2(14))
  call Hloop_QW_A(ntryL,G0H6(23),ex4(:),G0H2(7),m3h3x2(:,137),heltab2x6(:,:,682))
  call Hloop_Q_A(ntryL,G0H2(7),27,nMB,G1H2(74),n2h2(15))
  call Hloop_AW_Q(ntryL,G1H6(493),ex4(:),G1H2(75),m3h3x2(:,138),heltab2x6(:,:,683))
  call Hloop_A_Q(ntryL,G1H2(75),27,nMT,G2H2(162),n2h2(16))
call HGT_OLR(G1H6(494),1,1,6)
call HGT_invQ_OLR(G1H6(494),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(494),-4,nMT,G2H6(55),n2h6(218))
  call Hloop_QV_A(ntryL,G2H6(55),ex3(:),G2H3(387),m3h2x3(:,408),heltab2x6(:,:,684))
  call Hloop_AW_Q(ntryL,G1H6(499),ex4(:),G1H2(75),m3h3x2(:,139),heltab2x6(:,:,685))
  call Hloop_A_Q(ntryL,G1H2(75),27,nMT,G2H2(163),n2h2(17))
  call Hloop_AW_Q(ntryL,G1H6(504),ex4(:),G1H2(75),m3h3x2(:,140),heltab2x6(:,:,686))
  call Hloop_A_Q(ntryL,G1H2(75),27,nMT,G2H2(164),n2h2(18))
call HGT_OLR(G1H6(500),1,1,6)
call HGT_invQ_OLR(G1H6(500),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(500),-4,nMT,G2H6(56),n2h6(219))
  call Hloop_QV_A(ntryL,G2H6(56),ex3(:),G2H3(388),m3h2x3(:,409),heltab2x6(:,:,687))
  call Hloop_AW_Q(ntryL,G1H6(503),ex4(:),G1H2(75),m3h3x2(:,141),heltab2x6(:,:,688))
  call Hloop_A_Q(ntryL,G1H2(75),27,nMT,G2H2(165),n2h2(19))
  call Hloop_AW_Q(ntryL,G0H6(24),ex4(:),G0H2(7),m3h3x2(:,142),heltab2x6(:,:,689))
  call Hloop_A_Q(ntryL,G0H2(7),27,nMT,G1H2(75),n2h2(20))
call HGT_OLR(G1H6(505),1,1,6)
call HGT_invQ_OLR(G1H6(505),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(505),-12,nMT,G2H6(61),n2h6(220))
  call Hloop_QV_A(ntryL,G2H6(61),ex3(:),G2H3(389),m3h2x3(:,410),heltab2x6(:,:,690))
  call Hloop_AW_Q(ntryL,G1H6(508),ex4(:),G1H2(76),m3h3x2(:,143),heltab2x6(:,:,691))
  call Hloop_A_Q(ntryL,G1H2(76),27,nMT,G2H2(166),n2h2(21))
  call Hloop_AW_Q(ntryL,G0H6(14),ex4(:),G0H2(7),m3h3x2(:,144),heltab2x6(:,:,692))
  call Hloop_A_Q(ntryL,G0H2(7),27,nMT,G1H2(76),n2h2(22))
  call Hloop_AV_Q(ntryL,G1H6(509),ex3(:),G1H3(60),m3h2x3(:,411),heltab2x6(:,:,693))
  call Hloop_A_Q(ntryL,G1H3(60),23,nML,G2H3(390),n2h3(117))
call HGT_OLR(G1H6(510),1,1,6)
call HGT_invQ_OLR(G1H6(510),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(510),-8,0,G2H6(62),n2h6(221))
  call Hloop_QW_A(ntryL,G2H6(62),ex4(:),G2H2(167),m3h3x2(:,145),heltab2x6(:,:,694))
  call Hloop_AV_Q(ntryL,G1H6(515),ex3(:),G1H3(61),m3h2x3(:,412),heltab2x6(:,:,695))
  call Hloop_A_Q(ntryL,G1H3(61),23,nML,G2H3(391),n2h3(118))
  call Hloop_AV_Q(ntryL,G1H6(520),ex3(:),G1H3(62),m3h2x3(:,413),heltab2x6(:,:,696))
  call Hloop_A_Q(ntryL,G1H3(62),23,nML,G2H3(392),n2h3(119))
call HGT_OLR(G1H6(516),1,1,6)
call HGT_invQ_OLR(G1H6(516),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(516),-8,0,G2H6(63),n2h6(222))
  call Hloop_QW_A(ntryL,G2H6(63),ex4(:),G2H2(168),m3h3x2(:,146),heltab2x6(:,:,697))
  call Hloop_AV_Q(ntryL,G1H6(519),ex3(:),G1H3(65),m3h2x3(:,414),heltab2x6(:,:,698))
  call Hloop_A_Q(ntryL,G1H3(65),23,nML,G2H3(393),n2h3(120))
  call Hloop_AV_Q(ntryL,G0H6(15),ex3(:),G0H3(13),m3h2x3(:,415),heltab2x6(:,:,699))
  call Hloop_A_Q(ntryL,G0H3(13),23,nML,G1H3(66),n2h3(121))
call HGT_OLR(G1H6(521),1,1,6)
call HGT_invQ_OLR(G1H6(521),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(521),-12,0,G2H6(66),n2h6(223))
  call Hloop_QW_A(ntryL,G2H6(66),ex4(:),G2H2(169),m3h3x2(:,147),heltab2x6(:,:,700))
  call Hloop_AV_Q(ntryL,G1H6(524),ex3(:),G1H3(67),m3h2x3(:,416),heltab2x6(:,:,701))
  call Hloop_A_Q(ntryL,G1H3(67),23,nML,G2H3(394),n2h3(122))
  call Hloop_AV_Q(ntryL,G0H6(18),ex3(:),G0H3(4),m3h2x3(:,417),heltab2x6(:,:,702))
  call Hloop_A_Q(ntryL,G0H3(4),23,nML,G1H3(68),n2h3(123))
  call Hloop_QV_A(ntryL,G1H6(525),ex3(:),G1H3(211),m3h2x3(:,418),heltab2x6(:,:,703))
  call Hloop_Q_A(ntryL,G1H3(211),23,nMT,G2H3(395),n2h3(124))
call HGT_OLR(G1H6(526),1,1,6)
call HGT_invQ_OLR(G1H6(526),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(526),-8,nMB,G2H6(67),n2h6(224))
  call Hloop_AW_Q(ntryL,G2H6(67),ex4(:),G2H2(170),m3h3x2(:,148),heltab2x6(:,:,704))
  call Hloop_QV_A(ntryL,G1H6(531),ex3(:),G1H3(216),m3h2x3(:,419),heltab2x6(:,:,705))
  call Hloop_Q_A(ntryL,G1H3(216),23,nMT,G2H3(396),n2h3(125))
  call Hloop_QV_A(ntryL,G1H6(536),ex3(:),G1H3(73),m3h2x3(:,420),heltab2x6(:,:,706))
  call Hloop_Q_A(ntryL,G1H3(73),23,nMT,G2H3(397),n2h3(126))
call HGT_OLR(G1H6(532),1,1,6)
call HGT_invQ_OLR(G1H6(532),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(532),-8,nMB,G2H6(10),n2h6(225))
  call Hloop_AW_Q(ntryL,G2H6(10),ex4(:),G2H2(171),m3h3x2(:,149),heltab2x6(:,:,707))
  call Hloop_QV_A(ntryL,G1H6(535),ex3(:),G1H3(74),m3h2x3(:,421),heltab2x6(:,:,708))
  call Hloop_Q_A(ntryL,G1H3(74),23,nMT,G2H3(398),n2h3(127))
  call Hloop_QV_A(ntryL,G0H6(16),ex3(:),G0H3(2),m3h2x3(:,422),heltab2x6(:,:,709))
  call Hloop_Q_A(ntryL,G0H3(2),23,nMT,G1H3(221),n2h3(128))
call HGT_OLR(G1H6(537),1,1,6)
call HGT_invQ_OLR(G1H6(537),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(537),-12,nMB,G2H6(11),n2h6(226))
  call Hloop_AW_Q(ntryL,G2H6(11),ex4(:),G2H2(172),m3h3x2(:,150),heltab2x6(:,:,710))
  call Hloop_QV_A(ntryL,G1H6(540),ex3(:),G1H3(226),m3h2x3(:,423),heltab2x6(:,:,711))
  call Hloop_Q_A(ntryL,G1H3(226),23,nMT,G2H3(399),n2h3(129))
  call Hloop_QV_A(ntryL,G0H6(17),ex3(:),G0H3(5),m3h2x3(:,424),heltab2x6(:,:,712))
  call Hloop_Q_A(ntryL,G0H3(5),23,nMT,G1H3(79),n2h3(130))
  call Hloop_AV_Q(ntryL,G1H6(541),ex3(:),G1H3(80),m3h2x3(:,425),heltab2x6(:,:,713))
  call Hloop_A_Q(ntryL,G1H3(80),23,nMB,G2H3(400),n2h3(131))
call HGT_OLR(G1H6(542),1,1,6)
call HGT_invQ_OLR(G1H6(542),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(542),-8,nMT,G2H6(3),n2h6(227))
  call Hloop_QW_A(ntryL,G2H6(3),ex4(:),G2H2(173),m3h3x2(:,151),heltab2x6(:,:,714))
  call Hloop_AV_Q(ntryL,G1H6(547),ex3(:),G1H3(231),m3h2x3(:,426),heltab2x6(:,:,715))
  call Hloop_A_Q(ntryL,G1H3(231),23,nMB,G2H3(401),n2h3(132))
  call Hloop_AV_Q(ntryL,G1H6(552),ex3(:),G1H3(236),m3h2x3(:,427),heltab2x6(:,:,716))
  call Hloop_A_Q(ntryL,G1H3(236),23,nMB,G2H3(402),n2h3(133))
call HGT_OLR(G1H6(548),1,1,6)
call HGT_invQ_OLR(G1H6(548),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(548),-8,nMT,G2H6(4),n2h6(228))
  call Hloop_QW_A(ntryL,G2H6(4),ex4(:),G2H2(174),m3h3x2(:,152),heltab2x6(:,:,717))
  call Hloop_AV_Q(ntryL,G1H6(551),ex3(:),G1H3(29),m3h2x3(:,428),heltab2x6(:,:,718))
  call Hloop_A_Q(ntryL,G1H3(29),23,nMB,G2H3(403),n2h3(134))
  call Hloop_AV_Q(ntryL,G0H6(19),ex3(:),G0H3(1),m3h2x3(:,429),heltab2x6(:,:,719))
  call Hloop_A_Q(ntryL,G0H3(1),23,nMB,G1H3(30),n2h3(135))
call HGT_OLR(G1H6(553),1,1,6)
call HGT_invQ_OLR(G1H6(553),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(553),-12,nMT,G2H6(5),n2h6(229))
  call Hloop_QW_A(ntryL,G2H6(5),ex4(:),G2H2(175),m3h3x2(:,153),heltab2x6(:,:,720))
  call Hloop_AV_Q(ntryL,G1H6(556),ex3(:),G1H3(35),m3h2x3(:,430),heltab2x6(:,:,721))
  call Hloop_A_Q(ntryL,G1H3(35),23,nMB,G2H3(404),n2h3(136))
  call Hloop_AV_Q(ntryL,G0H6(20),ex3(:),G0H3(6),m3h2x3(:,431),heltab2x6(:,:,722))
  call Hloop_A_Q(ntryL,G0H3(6),23,nMB,G1H3(36),n2h3(137))
call HGT_raise_alpha_OLR(G1H6(558),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(558),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(558),ex4(:),G1H2(77),m3h3x2(:,154),heltab2x6(:,:,723))
  call Hloop_SV_T(ntryL,G1H6(561),19,ex3(:),4,G2H3(405),m3h2x3(:,432),heltab2x6(:,:,724))
call HGT_raise_alpha_OLR(G1H6(563),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(563),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(563),ex4(:),G1H2(78),m3h3x2(:,155),heltab2x6(:,:,725))
  call Hloop_SV_T(ntryL,G1H6(566),19,ex3(:),4,G2H3(406),m3h2x3(:,433),heltab2x6(:,:,726))
call HGT_raise_alpha_OLR(G1H6(568),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(568),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(568),ex4(:),G1H2(79),m3h3x2(:,156),heltab2x6(:,:,727))
  call Hloop_SV_T(ntryL,G1H6(571),19,ex3(:),4,G2H3(407),m3h2x3(:,434),heltab2x6(:,:,728))
call HGT_raise_alpha_OLR(G1H6(573),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(573),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(573),ex4(:),G1H2(80),m3h3x2(:,157),heltab2x6(:,:,729))
  call Hloop_SV_T(ntryL,G1H6(576),19,ex3(:),4,G2H3(408),m3h2x3(:,435),heltab2x6(:,:,730))
call HGT_OLR(G1H6(578),1,1,6)
call HGT_invQ_OLR(G1H6(578),2,5,6)
  call Hloop_SV_V(ntryL,G1H6(578),ex4(:),G1H2(81),m3h3x2(:,158),heltab2x6(:,:,731))
  call Hloop_UW_V(ntryL,G1H6(581),19,ex3(:),4,G2H3(409),m3h2x3(:,436),heltab2x6(:,:,732))
call HGT_OLR(G1H6(583),1,1,6)
call HGT_invQ_OLR(G1H6(583),2,5,6)
  call Hloop_SV_V(ntryL,G1H6(583),ex4(:),G1H2(82),m3h3x2(:,159),heltab2x6(:,:,733))
  call Hloop_UW_V(ntryL,G1H6(586),19,ex3(:),4,G2H3(410),m3h2x3(:,437),heltab2x6(:,:,734))
  call Hloop_QW_A(ntryL,G1H6(587),ex4(:),G1H2(83),m3h3x2(:,160),heltab2x6(:,:,735))
  call Hloop_Q_A(ntryL,G1H2(83),27,nMB,G2H2(176),n2h2(23))
call HGT_OLR(G1H6(588),1,1,6)
call HGT_invQ_OLR(G1H6(588),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(588),-4,nMB,G2H6(6),n2h6(236))
  call Hloop_AV_Q(ntryL,G2H6(6),ex3(:),G2H3(411),m3h2x3(:,438),heltab2x6(:,:,736))
  call Hloop_QW_A(ntryL,G1H6(593),ex4(:),G1H2(83),m3h3x2(:,161),heltab2x6(:,:,737))
  call Hloop_Q_A(ntryL,G1H2(83),27,nMB,G2H2(177),n2h2(24))
  call Hloop_QW_A(ntryL,G1H6(598),ex4(:),G1H2(83),m3h3x2(:,162),heltab2x6(:,:,738))
  call Hloop_Q_A(ntryL,G1H2(83),27,nMB,G2H2(178),n2h2(25))
call HGT_OLR(G1H6(594),1,1,6)
call HGT_invQ_OLR(G1H6(594),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(594),-4,nMB,G2H6(16),n2h6(237))
  call Hloop_AV_Q(ntryL,G2H6(16),ex3(:),G2H3(412),m3h2x3(:,439),heltab2x6(:,:,739))
  call Hloop_QW_A(ntryL,G1H6(597),ex4(:),G1H2(83),m3h3x2(:,163),heltab2x6(:,:,740))
  call Hloop_Q_A(ntryL,G1H2(83),27,nMB,G2H2(179),n2h2(26))
  call Hloop_QW_A(ntryL,G0H6(21),ex4(:),G0H2(7),m3h3x2(:,164),heltab2x6(:,:,741))
  call Hloop_Q_A(ntryL,G0H2(7),27,nMB,G1H2(83),n2h2(27))
call HGT_OLR(G1H6(599),1,1,6)
call HGT_invQ_OLR(G1H6(599),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(599),-12,nMB,G2H6(17),n2h6(238))
  call Hloop_AV_Q(ntryL,G2H6(17),ex3(:),G2H3(413),m3h2x3(:,440),heltab2x6(:,:,742))
  call Hloop_QW_A(ntryL,G1H6(602),ex4(:),G1H2(84),m3h3x2(:,165),heltab2x6(:,:,743))
  call Hloop_Q_A(ntryL,G1H2(84),27,nMB,G2H2(180),n2h2(28))
  call Hloop_QW_A(ntryL,G0H6(22),ex4(:),G0H2(7),m3h3x2(:,166),heltab2x6(:,:,744))
  call Hloop_Q_A(ntryL,G0H2(7),27,nMB,G1H2(84),n2h2(29))
  call Hloop_AW_Q(ntryL,G1H6(603),ex4(:),G1H2(85),m3h3x2(:,167),heltab2x6(:,:,745))
  call Hloop_A_Q(ntryL,G1H2(85),27,nMT,G2H2(181),n2h2(30))
call HGT_OLR(G1H6(604),1,1,6)
call HGT_invQ_OLR(G1H6(604),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(604),-4,nMT,G2H6(93),n2h6(239))
  call Hloop_QV_A(ntryL,G2H6(93),ex3(:),G2H3(414),m3h2x3(:,441),heltab2x6(:,:,746))
  call Hloop_AW_Q(ntryL,G1H6(609),ex4(:),G1H2(85),m3h3x2(:,168),heltab2x6(:,:,747))
  call Hloop_A_Q(ntryL,G1H2(85),27,nMT,G2H2(182),n2h2(31))
  call Hloop_AW_Q(ntryL,G1H6(614),ex4(:),G1H2(85),m3h3x2(:,169),heltab2x6(:,:,748))
  call Hloop_A_Q(ntryL,G1H2(85),27,nMT,G2H2(183),n2h2(32))
call HGT_OLR(G1H6(610),1,1,6)
call HGT_invQ_OLR(G1H6(610),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(610),-4,nMT,G2H6(97),n2h6(240))
  call Hloop_QV_A(ntryL,G2H6(97),ex3(:),G2H3(415),m3h2x3(:,442),heltab2x6(:,:,749))
  call Hloop_AW_Q(ntryL,G1H6(613),ex4(:),G1H2(85),m3h3x2(:,170),heltab2x6(:,:,750))
  call Hloop_A_Q(ntryL,G1H2(85),27,nMT,G2H2(184),n2h2(33))
  call Hloop_AW_Q(ntryL,G0H6(25),ex4(:),G0H2(7),m3h3x2(:,171),heltab2x6(:,:,751))
  call Hloop_A_Q(ntryL,G0H2(7),27,nMT,G1H2(85),n2h2(34))
call HGT_OLR(G1H6(615),1,1,6)
call HGT_invQ_OLR(G1H6(615),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(615),-12,nMT,G2H6(12),n2h6(241))
  call Hloop_QV_A(ntryL,G2H6(12),ex3(:),G2H3(416),m3h2x3(:,443),heltab2x6(:,:,752))
  call Hloop_AW_Q(ntryL,G1H6(618),ex4(:),G1H2(86),m3h3x2(:,172),heltab2x6(:,:,753))
  call Hloop_A_Q(ntryL,G1H2(86),27,nMT,G2H2(185),n2h2(35))
  call Hloop_AW_Q(ntryL,G0H6(35),ex4(:),G0H2(7),m3h3x2(:,173),heltab2x6(:,:,754))
  call Hloop_A_Q(ntryL,G0H2(7),27,nMT,G1H2(86),n2h2(36))
  call Hloop_AS_Q(ntryL,G1H3(163),ex1(:),G1H3(42),ngH,m3h1x3(:,124),heltab2x3(:,:,153))
  call Hloop_A_Q(ntryL,G1H3(42),23,nML,G2H3(417),n2h3(138))
call HGT_OLR(G1H3(164),1,1,3)
call HGT_invQ_OLR(G1H3(164),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(164),-8,0,G2H3(418),n2h3(139))
  call Hloop_QW_A(ntryL,G2H3(418),ex4(:),G2H1(18),m3h3x1(:,30),heltab2x3(:,:,154))
  call Hloop_AS_Q(ntryL,G1H3(169),ex1(:),G1H3(72),ngH,m3h1x3(:,125),heltab2x3(:,:,155))
  call Hloop_A_Q(ntryL,G1H3(72),23,nML,G2H3(418),n2h3(140))
  call Hloop_AS_Q(ntryL,G1H3(174),ex1(:),G1H3(77),ngH,m3h1x3(:,126),heltab2x3(:,:,156))
  call Hloop_A_Q(ntryL,G1H3(77),23,nML,G2H3(419),n2h3(141))
call HGT_OLR(G1H3(170),1,1,3)
call HGT_invQ_OLR(G1H3(170),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(170),-8,0,G2H3(420),n2h3(142))
  call Hloop_QW_A(ntryL,G2H3(420),ex4(:),G2H1(19),m3h3x1(:,31),heltab2x3(:,:,157))
  call Hloop_AS_Q(ntryL,G1H3(173),ex1(:),G1H3(78),ngH,m3h1x3(:,127),heltab2x3(:,:,158))
  call Hloop_A_Q(ntryL,G1H3(78),23,nML,G2H3(420),n2h3(143))
  call Hloop_AS_Q(ntryL,G0H3(7),ex1(:),G0H3(3),ngH,m3h1x3(:,128),heltab2x3(:,:,159))
  call Hloop_A_Q(ntryL,G0H3(3),23,nML,G1H3(83),n2h3(144))
call HGT_OLR(G1H3(175),1,1,3)
call HGT_invQ_OLR(G1H3(175),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(175),-9,0,G2H3(421),n2h3(145))
  call Hloop_QW_A(ntryL,G2H3(421),ex4(:),G2H1(20),m3h3x1(:,32),heltab2x3(:,:,160))
  call Hloop_AS_Q(ntryL,G1H3(178),ex1(:),G1H3(89),ngH,m3h1x3(:,129),heltab2x3(:,:,161))
  call Hloop_A_Q(ntryL,G1H3(89),23,nML,G2H3(421),n2h3(146))
  call Hloop_AS_Q(ntryL,G0H3(8),ex1(:),G0H3(13),ngH,m3h1x3(:,130),heltab2x3(:,:,162))
  call Hloop_A_Q(ntryL,G0H3(13),23,nML,G1H3(105),n2h3(147))
  call Hloop_QS_A(ntryL,G1H3(179),ex1(:),G1H3(106),ngH,m3h1x3(:,131),heltab2x3(:,:,163))
  call Hloop_Q_A(ntryL,G1H3(106),23,nMT,G2H3(422),n2h3(148))
call HGT_OLR(G1H3(180),1,1,3)
call HGT_invQ_OLR(G1H3(180),2,5,3)
  call Hloop_A_Q(ntryL,G1H3(180),-8,nMB,G2H3(423),n2h3(149))
  call Hloop_AW_Q(ntryL,G2H3(423),ex4(:),G2H1(21),m3h3x1(:,33),heltab2x3(:,:,164))
  call Hloop_QS_A(ntryL,G1H3(185),ex1(:),G1H3(121),ngH,m3h1x3(:,132),heltab2x3(:,:,165))
  call Hloop_Q_A(ntryL,G1H3(121),23,nMT,G2H3(423),n2h3(150))
  call Hloop_QS_A(ntryL,G1H3(190),ex1(:),G1H3(122),ngH,m3h1x3(:,133),heltab2x3(:,:,166))
  call Hloop_Q_A(ntryL,G1H3(122),23,nMT,G2H3(424),n2h3(151))
call HGT_OLR(G1H3(186),1,1,3)
call HGT_invQ_OLR(G1H3(186),2,5,3)
  call Hloop_A_Q(ntryL,G1H3(186),-8,nMB,G2H3(425),n2h3(152))
  call Hloop_AW_Q(ntryL,G2H3(425),ex4(:),G2H1(22),m3h3x1(:,34),heltab2x3(:,:,167))
  call Hloop_QS_A(ntryL,G1H3(189),ex1(:),G1H3(168),ngH,m3h1x3(:,134),heltab2x3(:,:,168))
  call Hloop_Q_A(ntryL,G1H3(168),23,nMT,G2H3(425),n2h3(153))
  call Hloop_QS_A(ntryL,G0H3(9),ex1(:),G0H3(4),ngH,m3h1x3(:,135),heltab2x3(:,:,169))
  call Hloop_Q_A(ntryL,G0H3(4),23,nMT,G1H3(184),n2h3(154))
call HGT_OLR(G1H3(191),1,1,3)
call HGT_invQ_OLR(G1H3(191),2,5,3)
  call Hloop_A_Q(ntryL,G1H3(191),-9,nMB,G2H3(426),n2h3(155))
  call Hloop_AW_Q(ntryL,G2H3(426),ex4(:),G2H1(23),m3h3x1(:,35),heltab2x3(:,:,170))
  call Hloop_QS_A(ntryL,G1H3(194),ex1(:),G1H3(199),ngH,m3h1x3(:,136),heltab2x3(:,:,171))
  call Hloop_Q_A(ntryL,G1H3(199),23,nMT,G2H3(426),n2h3(156))
  call Hloop_QS_A(ntryL,G0H3(10),ex1(:),G0H3(2),ngH,m3h1x3(:,137),heltab2x3(:,:,172))
  call Hloop_Q_A(ntryL,G0H3(2),23,nMT,G1H3(200),n2h3(157))
  call Hloop_AS_Q(ntryL,G1H3(195),ex1(:),G1H3(15),ngH,m3h1x3(:,138),heltab2x3(:,:,173))
  call Hloop_A_Q(ntryL,G1H3(15),23,nMB,G2H3(427),n2h3(158))
call HGT_OLR(G1H3(196),1,1,3)
call HGT_invQ_OLR(G1H3(196),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(196),-8,nMT,G2H3(428),n2h3(159))
  call Hloop_QW_A(ntryL,G2H3(428),ex4(:),G2H1(24),m3h3x1(:,36),heltab2x3(:,:,174))
  call Hloop_AS_Q(ntryL,G1H3(201),ex1(:),G1H3(4),ngH,m3h1x3(:,139),heltab2x3(:,:,175))
  call Hloop_A_Q(ntryL,G1H3(4),23,nMB,G2H3(428),n2h3(160))
  call Hloop_AS_Q(ntryL,G1H3(206),ex1(:),G1H3(6),ngH,m3h1x3(:,140),heltab2x3(:,:,176))
  call Hloop_A_Q(ntryL,G1H3(6),23,nMB,G2H3(429),n2h3(161))
call HGT_OLR(G1H3(202),1,1,3)
call HGT_invQ_OLR(G1H3(202),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(202),-8,nMT,G2H3(430),n2h3(162))
  call Hloop_QW_A(ntryL,G2H3(430),ex4(:),G2H1(25),m3h3x1(:,37),heltab2x3(:,:,177))
  call Hloop_AS_Q(ntryL,G1H3(205),ex1(:),G1H3(7),ngH,m3h1x3(:,141),heltab2x3(:,:,178))
  call Hloop_A_Q(ntryL,G1H3(7),23,nMB,G2H3(430),n2h3(163))
  call Hloop_AS_Q(ntryL,G0H3(11),ex1(:),G0H3(5),ngH,m3h1x3(:,142),heltab2x3(:,:,179))
  call Hloop_A_Q(ntryL,G0H3(5),23,nMB,G1H3(10),n2h3(164))
call HGT_OLR(G1H3(207),1,1,3)
call HGT_invQ_OLR(G1H3(207),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(207),-9,nMT,G2H3(431),n2h3(165))
  call Hloop_QW_A(ntryL,G2H3(431),ex4(:),G2H1(26),m3h3x1(:,38),heltab2x3(:,:,180))
  call Hloop_AS_Q(ntryL,G1H3(210),ex1(:),G1H3(11),ngH,m3h1x3(:,143),heltab2x3(:,:,181))
  call Hloop_A_Q(ntryL,G1H3(11),23,nMB,G2H3(431),n2h3(166))
  call Hloop_AS_Q(ntryL,G0H3(12),ex1(:),G0H3(1),ngH,m3h1x3(:,144),heltab2x3(:,:,182))
  call Hloop_A_Q(ntryL,G0H3(1),23,nMB,G1H3(13),n2h3(167))
call HGT_OLR(G1H3(212),1,1,3)
call HGT_invQ_OLR(G1H3(212),2,5,3)
  call Hloop_SV_V(ntryL,G1H3(212),ex4(:),G1H1(13),m3h3x1(:,39),heltab2x3(:,:,183))
  call Hloop_ST_V(ntryL,G1H3(215),22,ex1(:),1,G2H3(432),m3h1x3(:,145),heltab2x3(:,:,184))
call HGT_OLR(G1H3(217),1,1,3)
call HGT_invQ_OLR(G1H3(217),2,5,3)
  call Hloop_SV_V(ntryL,G1H3(217),ex4(:),G1H1(14),m3h3x1(:,40),heltab2x3(:,:,185))
  call Hloop_ST_V(ntryL,G1H3(220),22,ex1(:),1,G2H3(433),m3h1x3(:,146),heltab2x3(:,:,186))
call HGT_raise_alpha_OLR(G1H3(222),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(222),2,5,3)
  call Hloop_VV_S(ntryL,G1H3(222),ex4(:),G1H1(15),m3h3x1(:,41),heltab2x3(:,:,187))
  call Hloop_VT_S(ntryL,G1H3(225),22,ex1(:),1,G2H3(434),m3h1x3(:,147),heltab2x3(:,:,188))
call HGT_raise_alpha_OLR(G1H3(227),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(227),2,5,3)
  call Hloop_VV_S(ntryL,G1H3(227),ex4(:),G1H1(16),m3h3x1(:,42),heltab2x3(:,:,189))
  call Hloop_VT_S(ntryL,G1H3(230),22,ex1(:),1,G2H3(435),m3h1x3(:,148),heltab2x3(:,:,190))
call HGT_raise_alpha_OLR(G1H3(232),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(232),2,5,3)
  call Hloop_VV_S(ntryL,G1H3(232),ex4(:),G1H1(17),m3h3x1(:,43),heltab2x3(:,:,191))
  call Hloop_VT_S(ntryL,G1H3(235),22,ex1(:),1,G2H3(436),m3h1x3(:,149),heltab2x3(:,:,192))
call HGT_raise_alpha_OLR(G1H3(237),1,1,3)
call HGT_raise_alpha_invQ_OLR(G1H3(237),2,5,3)
  call Hloop_VV_S(ntryL,G1H3(237),ex4(:),G1H1(18),m3h3x1(:,44),heltab2x3(:,:,193))
  call Hloop_VT_S(ntryL,G1H3(240),22,ex1(:),1,G2H3(437),m3h1x3(:,150),heltab2x3(:,:,194))
  call Hloop_AS_Q(ntryL,G1H2(19),ex1(:),G1H2(87),ngH,m3h1x2(:,1),heltab2x2(:,:,1))
  call Hloop_A_Q(ntryL,G1H2(87),27,nMT,G2H2(186),n2h2(37))
call HGT_OLR(G1H2(20),1,1,2)
call HGT_invQ_OLR(G1H2(20),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(20),-4,nMT,G2H2(187),n2h2(38))
  call Hloop_QV_A(ntryL,G2H2(187),ex3(:),G2H1(27),m3h2x1(:,1),heltab2x2(:,:,2))
  call Hloop_AS_Q(ntryL,G1H2(25),ex1(:),G1H2(19),ngH,m3h1x2(:,2),heltab2x2(:,:,3))
  call Hloop_A_Q(ntryL,G1H2(19),27,nMT,G2H2(187),n2h2(39))
  call Hloop_AS_Q(ntryL,G1H2(30),ex1(:),G1H2(87),ngH,m3h1x2(:,3),heltab2x2(:,:,4))
  call Hloop_A_Q(ntryL,G1H2(87),27,nMT,G2H2(188),n2h2(40))
call HGT_OLR(G1H2(26),1,1,2)
call HGT_invQ_OLR(G1H2(26),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(26),-4,nMT,G2H2(189),n2h2(41))
  call Hloop_QV_A(ntryL,G2H2(189),ex3(:),G2H1(28),m3h2x1(:,2),heltab2x2(:,:,5))
  call Hloop_AS_Q(ntryL,G1H2(29),ex1(:),G1H2(20),ngH,m3h1x2(:,4),heltab2x2(:,:,6))
  call Hloop_A_Q(ntryL,G1H2(20),27,nMT,G2H2(189),n2h2(42))
  call Hloop_AS_Q(ntryL,G0H2(3),ex1(:),G0H2(7),ngH,m3h1x2(:,5),heltab2x2(:,:,7))
  call Hloop_A_Q(ntryL,G0H2(7),27,nMT,G1H2(25),n2h2(43))
call HGT_OLR(G1H2(31),1,1,2)
call HGT_invQ_OLR(G1H2(31),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(31),-5,nMT,G2H2(190),n2h2(44))
  call Hloop_QV_A(ntryL,G2H2(190),ex3(:),G2H1(29),m3h2x1(:,3),heltab2x2(:,:,8))
  call Hloop_AS_Q(ntryL,G1H2(34),ex1(:),G1H2(19),ngH,m3h1x2(:,6),heltab2x2(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(19),27,nMT,G2H2(190),n2h2(45))
  call Hloop_AS_Q(ntryL,G0H2(4),ex1(:),G0H2(3),ngH,m3h1x2(:,7),heltab2x2(:,:,10))
  call Hloop_A_Q(ntryL,G0H2(3),27,nMT,G1H2(30),n2h2(46))
  call Hloop_QS_A(ntryL,G1H2(35),ex1(:),G1H2(87),ngH,m3h1x2(:,8),heltab2x2(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(87),27,nMB,G2H2(191),n2h2(47))
call HGT_OLR(G1H2(36),1,1,2)
call HGT_invQ_OLR(G1H2(36),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(36),-4,nMB,G2H2(192),n2h2(48))
  call Hloop_AV_Q(ntryL,G2H2(192),ex3(:),G2H1(30),m3h2x1(:,4),heltab2x2(:,:,12))
  call Hloop_QS_A(ntryL,G1H2(41),ex1(:),G1H2(26),ngH,m3h1x2(:,9),heltab2x2(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(26),27,nMB,G2H2(192),n2h2(49))
  call Hloop_QS_A(ntryL,G1H2(46),ex1(:),G1H2(29),ngH,m3h1x2(:,10),heltab2x2(:,:,14))
  call Hloop_Q_A(ntryL,G1H2(29),27,nMB,G2H2(193),n2h2(50))
call HGT_OLR(G1H2(42),1,1,2)
call HGT_invQ_OLR(G1H2(42),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(42),-4,nMB,G2H2(194),n2h2(51))
  call Hloop_AV_Q(ntryL,G2H2(194),ex3(:),G2H1(31),m3h2x1(:,5),heltab2x2(:,:,15))
  call Hloop_QS_A(ntryL,G1H2(45),ex1(:),G1H2(20),ngH,m3h1x2(:,11),heltab2x2(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(20),27,nMB,G2H2(194),n2h2(52))
  call Hloop_QS_A(ntryL,G0H2(5),ex1(:),G0H2(7),ngH,m3h1x2(:,12),heltab2x2(:,:,17))
  call Hloop_Q_A(ntryL,G0H2(7),27,nMB,G1H2(31),n2h2(53))
call HGT_OLR(G1H2(47),1,1,2)
call HGT_invQ_OLR(G1H2(47),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(47),-5,nMB,G2H2(195),n2h2(54))
  call Hloop_AV_Q(ntryL,G2H2(195),ex3(:),G2H1(32),m3h2x1(:,6),heltab2x2(:,:,18))
  call Hloop_QS_A(ntryL,G1H2(50),ex1(:),G1H2(34),ngH,m3h1x2(:,13),heltab2x2(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(34),27,nMB,G2H2(195),n2h2(55))
  call Hloop_QS_A(ntryL,G0H2(6),ex1(:),G0H2(4),ngH,m3h1x2(:,14),heltab2x2(:,:,20))
  call Hloop_Q_A(ntryL,G0H2(4),27,nMB,G1H2(19),n2h2(56))
  call Hloop_AV_Q(ntryL,G1H6(619),ex2(:),G1H3(18),m3h2x3(:,444),heltab2x6(:,:,755))
  call Hloop_A_Q(ntryL,G1H3(18),23,nML,G2H3(438),n2h3(174))
call HGT_OLR(G1H6(620),1,1,6)
call HGT_invQ_OLR(G1H6(620),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(620),-8,0,G2H6(105),n2h6(242))
  call Hloop_QW_A(ntryL,G2H6(105),ex4(:),G2H2(196),m3h3x2(:,174),heltab2x6(:,:,756))
  call Hloop_AV_Q(ntryL,G1H6(625),ex2(:),G1H3(19),m3h2x3(:,445),heltab2x6(:,:,757))
  call Hloop_A_Q(ntryL,G1H3(19),23,nML,G2H3(439),n2h3(175))
  call Hloop_AV_Q(ntryL,G1H6(630),ex2(:),G1H3(20),m3h2x3(:,446),heltab2x6(:,:,758))
  call Hloop_A_Q(ntryL,G1H3(20),23,nML,G2H3(440),n2h3(176))
call HGT_OLR(G1H6(626),1,1,6)
call HGT_invQ_OLR(G1H6(626),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(626),-8,0,G2H6(109),n2h6(243))
  call Hloop_QW_A(ntryL,G2H6(109),ex4(:),G2H2(197),m3h3x2(:,175),heltab2x6(:,:,759))
  call Hloop_AV_Q(ntryL,G1H6(629),ex2(:),G1H3(23),m3h2x3(:,447),heltab2x6(:,:,760))
  call Hloop_A_Q(ntryL,G1H3(23),23,nML,G2H3(441),n2h3(177))
  call Hloop_AV_Q(ntryL,G0H6(36),ex2(:),G0H3(6),m3h2x3(:,448),heltab2x6(:,:,761))
  call Hloop_A_Q(ntryL,G0H3(6),23,nML,G1H3(25),n2h3(178))
call HGT_OLR(G1H6(631),1,1,6)
call HGT_invQ_OLR(G1H6(631),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(631),-10,0,G2H6(15),n2h6(244))
  call Hloop_QW_A(ntryL,G2H6(15),ex4(:),G2H2(198),m3h3x2(:,176),heltab2x6(:,:,762))
  call Hloop_AV_Q(ntryL,G1H6(634),ex2(:),G1H3(85),m3h2x3(:,449),heltab2x6(:,:,763))
  call Hloop_A_Q(ntryL,G1H3(85),23,nML,G2H3(442),n2h3(179))
  call Hloop_AV_Q(ntryL,G0H6(28),ex2(:),G0H3(7),m3h2x3(:,450),heltab2x6(:,:,764))
  call Hloop_A_Q(ntryL,G0H3(7),23,nML,G1H3(133),n2h3(180))
  call Hloop_QV_A(ntryL,G1H6(635),ex2(:),G1H3(86),m3h2x3(:,451),heltab2x6(:,:,765))
  call Hloop_Q_A(ntryL,G1H3(86),23,nMT,G2H3(443),n2h3(181))
call HGT_OLR(G1H6(636),1,1,6)
call HGT_invQ_OLR(G1H6(636),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(636),-8,nMB,G2H6(18),n2h6(245))
  call Hloop_AW_Q(ntryL,G2H6(18),ex4(:),G2H2(199),m3h3x2(:,177),heltab2x6(:,:,766))
  call Hloop_QV_A(ntryL,G1H6(641),ex2(:),G1H3(91),m3h2x3(:,452),heltab2x6(:,:,767))
  call Hloop_Q_A(ntryL,G1H3(91),23,nMT,G2H3(444),n2h3(182))
  call Hloop_QV_A(ntryL,G1H6(646),ex2(:),G1H3(138),m3h2x3(:,453),heltab2x6(:,:,768))
  call Hloop_Q_A(ntryL,G1H3(138),23,nMT,G2H3(445),n2h3(183))
call HGT_OLR(G1H6(642),1,1,6)
call HGT_invQ_OLR(G1H6(642),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(642),-8,nMB,G2H6(88),n2h6(246))
  call Hloop_AW_Q(ntryL,G2H6(88),ex4(:),G2H2(200),m3h3x2(:,178),heltab2x6(:,:,769))
  call Hloop_QV_A(ntryL,G1H6(645),ex2(:),G1H3(96),m3h2x3(:,454),heltab2x6(:,:,770))
  call Hloop_Q_A(ntryL,G1H3(96),23,nMT,G2H3(446),n2h3(184))
  call Hloop_QV_A(ntryL,G0H6(29),ex2(:),G0H3(3),m3h2x3(:,455),heltab2x6(:,:,771))
  call Hloop_Q_A(ntryL,G0H3(3),23,nMT,G1H3(31),n2h3(185))
call HGT_OLR(G1H6(647),1,1,6)
call HGT_invQ_OLR(G1H6(647),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(647),-10,nMB,G2H6(89),n2h6(247))
  call Hloop_AW_Q(ntryL,G2H6(89),ex4(:),G2H2(201),m3h3x2(:,179),heltab2x6(:,:,772))
  call Hloop_QV_A(ntryL,G1H6(650),ex2(:),G1H3(92),m3h2x3(:,456),heltab2x6(:,:,773))
  call Hloop_Q_A(ntryL,G1H3(92),23,nMT,G2H3(447),n2h3(186))
  call Hloop_QV_A(ntryL,G0H6(26),ex2(:),G0H3(8),m3h2x3(:,457),heltab2x6(:,:,774))
  call Hloop_Q_A(ntryL,G0H3(8),23,nMT,G1H3(95),n2h3(187))
  call Hloop_AV_Q(ntryL,G1H6(651),ex2(:),G1H3(32),m3h2x3(:,458),heltab2x6(:,:,775))
  call Hloop_A_Q(ntryL,G1H3(32),23,nMB,G2H3(448),n2h3(188))
call HGT_OLR(G1H6(652),1,1,6)
call HGT_invQ_OLR(G1H6(652),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(652),-8,nMT,G2H6(101),n2h6(248))
  call Hloop_QW_A(ntryL,G2H6(101),ex4(:),G2H2(202),m3h3x2(:,180),heltab2x6(:,:,776))
  call Hloop_AV_Q(ntryL,G1H6(657),ex2(:),G1H3(97),m3h2x3(:,459),heltab2x6(:,:,777))
  call Hloop_A_Q(ntryL,G1H3(97),23,nMB,G2H3(449),n2h3(189))
  call Hloop_AV_Q(ntryL,G1H6(662),ex2(:),G1H3(100),m3h2x3(:,460),heltab2x6(:,:,778))
  call Hloop_A_Q(ntryL,G1H3(100),23,nMB,G2H3(450),n2h3(190))
call HGT_OLR(G1H6(658),1,1,6)
call HGT_invQ_OLR(G1H6(658),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(658),-8,nMT,G2H6(28),n2h6(249))
  call Hloop_QW_A(ntryL,G2H6(28),ex4(:),G2H2(203),m3h3x2(:,181),heltab2x6(:,:,779))
  call Hloop_AV_Q(ntryL,G1H6(661),ex2(:),G1H3(148),m3h2x3(:,461),heltab2x6(:,:,780))
  call Hloop_A_Q(ntryL,G1H3(148),23,nMB,G2H3(451),n2h3(191))
  call Hloop_AV_Q(ntryL,G0H6(27),ex2(:),G0H3(13),m3h2x3(:,462),heltab2x6(:,:,781))
  call Hloop_A_Q(ntryL,G0H3(13),23,nMB,G1H3(101),n2h3(192))
call HGT_OLR(G1H6(663),1,1,6)
call HGT_invQ_OLR(G1H6(663),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(663),-10,nMT,G2H6(29),n2h6(250))
  call Hloop_QW_A(ntryL,G2H6(29),ex4(:),G2H2(204),m3h3x2(:,182),heltab2x6(:,:,782))
  call Hloop_AV_Q(ntryL,G1H6(666),ex2(:),G1H3(38),m3h2x3(:,463),heltab2x6(:,:,783))
  call Hloop_A_Q(ntryL,G1H3(38),23,nMB,G2H3(452),n2h3(193))
  call Hloop_AV_Q(ntryL,G0H6(34),ex2(:),G0H3(9),m3h2x3(:,464),heltab2x6(:,:,784))
  call Hloop_A_Q(ntryL,G0H3(9),23,nMB,G1H3(102),n2h3(194))
call HGT_raise_alpha_OLR(G1H6(668),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(668),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(668),ex4(:),G1H2(35),m3h3x2(:,183),heltab2x6(:,:,785))
  call Hloop_SV_T(ntryL,G1H6(671),21,ex2(:),2,G2H3(453),m3h2x3(:,465),heltab2x6(:,:,786))
call HGT_raise_alpha_OLR(G1H6(673),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(673),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(673),ex4(:),G1H2(87),m3h3x2(:,184),heltab2x6(:,:,787))
  call Hloop_SV_T(ntryL,G1H6(676),21,ex2(:),2,G2H3(454),m3h2x3(:,466),heltab2x6(:,:,788))
call HGT_raise_alpha_OLR(G1H6(678),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(678),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(678),ex4(:),G1H2(36),m3h3x2(:,185),heltab2x6(:,:,789))
  call Hloop_SV_T(ntryL,G1H6(681),21,ex2(:),2,G2H3(455),m3h2x3(:,467),heltab2x6(:,:,790))
call HGT_raise_alpha_OLR(G1H6(683),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(683),2,5,6)
  call Hloop_VV_S(ntryL,G1H6(683),ex4(:),G1H2(41),m3h3x2(:,186),heltab2x6(:,:,791))
  call Hloop_SV_T(ntryL,G1H6(686),21,ex2(:),2,G2H3(456),m3h2x3(:,468),heltab2x6(:,:,792))
call HGT_OLR(G1H6(688),1,1,6)
call HGT_invQ_OLR(G1H6(688),2,5,6)
  call Hloop_SV_V(ntryL,G1H6(688),ex4(:),G1H2(26),m3h3x2(:,187),heltab2x6(:,:,793))
  call Hloop_UW_V(ntryL,G1H6(691),21,ex2(:),2,G2H3(457),m3h2x3(:,469),heltab2x6(:,:,794))
call HGT_OLR(G1H6(693),1,1,6)
call HGT_invQ_OLR(G1H6(693),2,5,6)
  call Hloop_SV_V(ntryL,G1H6(693),ex4(:),G1H2(46),m3h3x2(:,188),heltab2x6(:,:,795))
  call Hloop_UW_V(ntryL,G1H6(696),21,ex2(:),2,G2H3(458),m3h2x3(:,470),heltab2x6(:,:,796))
  call Hloop_QW_A(ntryL,G1H6(697),ex4(:),G1H2(29),m3h3x2(:,189),heltab2x6(:,:,797))
  call Hloop_Q_A(ntryL,G1H2(29),29,nMB,G2H2(205),n2h2(57))
call HGT_OLR(G1H6(698),1,1,6)
call HGT_invQ_OLR(G1H6(698),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(698),-2,nMB,G2H6(21),n2h6(257))
  call Hloop_AV_Q(ntryL,G2H6(21),ex2(:),G2H3(459),m3h2x3(:,471),heltab2x6(:,:,798))
  call Hloop_QW_A(ntryL,G1H6(703),ex4(:),G1H2(42),m3h3x2(:,190),heltab2x6(:,:,799))
  call Hloop_Q_A(ntryL,G1H2(42),29,nMB,G2H2(206),n2h2(58))
  call Hloop_QW_A(ntryL,G1H6(708),ex4(:),G1H2(45),m3h3x2(:,191),heltab2x6(:,:,800))
  call Hloop_Q_A(ntryL,G1H2(45),29,nMB,G2H2(207),n2h2(59))
call HGT_OLR(G1H6(704),1,1,6)
call HGT_invQ_OLR(G1H6(704),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(704),-2,nMB,G2H6(22),n2h6(258))
  call Hloop_AV_Q(ntryL,G2H6(22),ex2(:),G2H3(460),m3h2x3(:,472),heltab2x6(:,:,801))
  call Hloop_QW_A(ntryL,G1H6(707),ex4(:),G1H2(20),m3h3x2(:,192),heltab2x6(:,:,802))
  call Hloop_Q_A(ntryL,G1H2(20),29,nMB,G2H2(208),n2h2(60))
  call Hloop_QW_A(ntryL,G0H6(30),ex4(:),G0H2(3),m3h3x2(:,193),heltab2x6(:,:,803))
  call Hloop_Q_A(ntryL,G0H2(3),29,nMB,G1H2(47),n2h2(61))
call HGT_OLR(G1H6(709),1,1,6)
call HGT_invQ_OLR(G1H6(709),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(709),-10,nMB,G2H6(23),n2h6(259))
  call Hloop_AV_Q(ntryL,G2H6(23),ex2(:),G2H3(461),m3h2x3(:,473),heltab2x6(:,:,804))
  call Hloop_QW_A(ntryL,G1H6(712),ex4(:),G1H2(50),m3h3x2(:,194),heltab2x6(:,:,805))
  call Hloop_Q_A(ntryL,G1H2(50),29,nMB,G2H2(209),n2h2(62))
  call Hloop_QW_A(ntryL,G0H6(31),ex4(:),G0H2(5),m3h3x2(:,195),heltab2x6(:,:,806))
  call Hloop_Q_A(ntryL,G0H2(5),29,nMB,G1H2(34),n2h2(63))
  call Hloop_AW_Q(ntryL,G1H6(713),ex4(:),G1H2(29),m3h3x2(:,196),heltab2x6(:,:,807))
  call Hloop_A_Q(ntryL,G1H2(29),29,nMT,G2H2(210),n2h2(64))
call HGT_OLR(G1H6(714),1,1,6)
call HGT_invQ_OLR(G1H6(714),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(714),-2,nMT,G2H6(24),n2h6(260))
  call Hloop_QV_A(ntryL,G2H6(24),ex2(:),G2H3(462),m3h2x3(:,474),heltab2x6(:,:,808))
  call Hloop_AW_Q(ntryL,G1H6(719),ex4(:),G1H2(42),m3h3x2(:,197),heltab2x6(:,:,809))
  call Hloop_A_Q(ntryL,G1H2(42),29,nMT,G2H2(211),n2h2(65))
  call Hloop_AW_Q(ntryL,G1H6(724),ex4(:),G1H2(45),m3h3x2(:,198),heltab2x6(:,:,810))
  call Hloop_A_Q(ntryL,G1H2(45),29,nMT,G2H2(212),n2h2(66))
call HGT_OLR(G1H6(720),1,1,6)
call HGT_invQ_OLR(G1H6(720),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(720),-2,nMT,G2H6(33),n2h6(261))
  call Hloop_QV_A(ntryL,G2H6(33),ex2(:),G2H3(463),m3h2x3(:,475),heltab2x6(:,:,811))
  call Hloop_AW_Q(ntryL,G1H6(723),ex4(:),G1H2(20),m3h3x2(:,199),heltab2x6(:,:,812))
  call Hloop_A_Q(ntryL,G1H2(20),29,nMT,G2H2(213),n2h2(67))
  call Hloop_AW_Q(ntryL,G0H6(32),ex4(:),G0H2(7),m3h3x2(:,200),heltab2x6(:,:,813))
  call Hloop_A_Q(ntryL,G0H2(7),29,nMT,G1H2(50),n2h2(68))
call HGT_OLR(G1H6(725),1,1,6)
call HGT_invQ_OLR(G1H6(725),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(725),-10,nMT,G2H6(34),n2h6(262))
  call Hloop_QV_A(ntryL,G2H6(34),ex2(:),G2H3(464),m3h2x3(:,476),heltab2x6(:,:,814))
  call Hloop_AW_Q(ntryL,G1H6(728),ex4(:),G1H2(29),m3h3x2(:,201),heltab2x6(:,:,815))
  call Hloop_A_Q(ntryL,G1H2(29),29,nMT,G2H2(214),n2h2(69))
  call Hloop_AW_Q(ntryL,G0H6(33),ex4(:),G0H2(6),m3h3x2(:,202),heltab2x6(:,:,816))
  call Hloop_A_Q(ntryL,G0H2(6),29,nMT,G1H2(42),n2h2(70))
  call Hloop_AV_Q(ntryL,G1H4(79),ex2(:),G1H2(45),m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(45),27,nMT,G2H2(215),n2h2(71))
call HGT_OLR(G1H4(80),1,1,4)
call HGT_invQ_OLR(G1H4(80),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(80),-4,nMT,G2H4(2),n2h4(29))
  call Hloop_QV_A(ntryL,G2H4(2),ex3(:),G2H2(216),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_AV_Q(ntryL,G1H4(85),ex2(:),G1H2(20),m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(20),27,nMT,G2H2(217),n2h2(72))
  call Hloop_AV_Q(ntryL,G1H4(90),ex2(:),G1H2(29),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_A_Q(ntryL,G1H2(29),27,nMT,G2H2(218),n2h2(73))
call HGT_OLR(G1H4(86),1,1,4)
call HGT_invQ_OLR(G1H4(86),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(86),-4,nMT,G2H4(7),n2h4(30))
  call Hloop_QV_A(ntryL,G2H4(7),ex3(:),G2H2(219),m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_AV_Q(ntryL,G1H4(89),ex2(:),G1H2(45),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_A_Q(ntryL,G1H2(45),27,nMT,G2H2(220),n2h2(74))
  call Hloop_AV_Q(ntryL,G0H4(1),ex2(:),G0H2(4),m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_A_Q(ntryL,G0H2(4),27,nMT,G1H2(20),n2h2(75))
call HGT_OLR(G1H4(91),1,1,4)
call HGT_invQ_OLR(G1H4(91),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(91),-6,nMT,G2H4(12),n2h4(31))
  call Hloop_QV_A(ntryL,G2H4(12),ex3(:),G2H2(221),m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_AV_Q(ntryL,G1H4(94),ex2(:),G1H2(29),m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_A_Q(ntryL,G1H2(29),27,nMT,G2H2(222),n2h2(76))
  call Hloop_AV_Q(ntryL,G0H4(2),ex2(:),G0H2(3),m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_A_Q(ntryL,G0H2(3),27,nMT,G1H2(45),n2h2(77))
  call Hloop_QV_A(ntryL,G1H4(95),ex2(:),G1H2(29),m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_Q_A(ntryL,G1H2(29),27,nMB,G2H2(223),n2h2(78))
call HGT_OLR(G1H4(96),1,1,4)
call HGT_invQ_OLR(G1H4(96),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(96),-4,nMB,G2H4(17),n2h4(32))
  call Hloop_AV_Q(ntryL,G2H4(17),ex3(:),G2H2(224),m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_QV_A(ntryL,G1H4(101),ex2(:),G1H2(29),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_Q_A(ntryL,G1H2(29),27,nMB,G2H2(225),n2h2(79))
  call Hloop_QV_A(ntryL,G1H4(106),ex2(:),G1H2(29),m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_Q_A(ntryL,G1H2(29),27,nMB,G2H2(226),n2h2(80))
call HGT_OLR(G1H4(102),1,1,4)
call HGT_invQ_OLR(G1H4(102),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(102),-4,nMB,G2H4(1),n2h4(33))
  call Hloop_AV_Q(ntryL,G2H4(1),ex3(:),G2H2(227),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hloop_QV_A(ntryL,G1H4(105),ex2(:),G1H2(29),m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_Q_A(ntryL,G1H2(29),27,nMB,G2H2(228),n2h2(81))
  call Hloop_QV_A(ntryL,G0H4(3),ex2(:),G0H2(5),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_Q_A(ntryL,G0H2(5),27,nMB,G1H2(29),n2h2(82))
call HGT_OLR(G1H4(107),1,1,4)
call HGT_invQ_OLR(G1H4(107),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(107),-6,nMB,G2H4(8),n2h4(34))
  call Hloop_AV_Q(ntryL,G2H4(8),ex3(:),G2H2(229),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_QV_A(ntryL,G1H4(110),ex2(:),G1H2(88),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_Q_A(ntryL,G1H2(88),27,nMB,G2H2(230),n2h2(83))
  call Hloop_QV_A(ntryL,G0H4(4),ex2(:),G0H2(7),m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_Q_A(ntryL,G0H2(7),27,nMB,G1H2(88),n2h2(84))
call HGT_raise_alpha_OLR(G1H4(112),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(112),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(112),ex3(:),G1H2(89),m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_TV_S(ntryL,G1H4(115),25,ex2(:),2,G2H2(231),m3h2x2(:,100),heltab2x4(:,:,100))
call HGT_raise_alpha_OLR(G1H4(117),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(117),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(117),ex3(:),G1H2(90),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_TV_S(ntryL,G1H4(120),25,ex2(:),2,G2H2(232),m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_UV_W(ntryL,G1H4(121),25,ex2(:),2,G2H2(233),m3h2x2(:,103),heltab2x4(:,:,103))
call HGT_OLR(G1H4(122),1,1,4)
call HGT_invQ_OLR(G1H4(122),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(122),ex3(:),G1H2(91),m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_UV_W(ntryL,G1H4(127),25,ex2(:),2,G2H2(234),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_UV_W(ntryL,G1H4(132),25,ex2(:),2,G2H2(235),m3h2x2(:,106),heltab2x4(:,:,106))
call HGT_OLR(G1H4(128),1,1,4)
call HGT_invQ_OLR(G1H4(128),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(128),ex3(:),G1H2(92),m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_UV_W(ntryL,G1H4(131),25,ex2(:),2,G2H2(236),m3h2x2(:,108),heltab2x4(:,:,108))
call HGT_OLR(G1H4(133),1,1,4)
call HGT_invQ_OLR(G1H4(133),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(133),ex3(:),G1H2(93),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_UV_W(ntryL,G1H4(136),25,ex2(:),2,G2H2(237),m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_AV_Q(ntryL,G1H4(137),ex3(:),G1H2(94),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_A_Q(ntryL,G1H2(94),29,nMT,G2H2(238),n2h2(85))
call HGT_OLR(G1H4(138),1,1,4)
call HGT_invQ_OLR(G1H4(138),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(138),-2,nMT,G2H4(3),n2h4(40))
  call Hloop_QV_A(ntryL,G2H4(3),ex2(:),G2H2(239),m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_AV_Q(ntryL,G1H4(143),ex3(:),G1H2(94),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_A_Q(ntryL,G1H2(94),29,nMT,G2H2(240),n2h2(86))
  call Hloop_AV_Q(ntryL,G1H4(148),ex3(:),G1H2(94),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_A_Q(ntryL,G1H2(94),29,nMT,G2H2(241),n2h2(87))
call HGT_OLR(G1H4(144),1,1,4)
call HGT_invQ_OLR(G1H4(144),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(144),-2,nMT,G2H4(4),n2h4(41))
  call Hloop_QV_A(ntryL,G2H4(4),ex2(:),G2H2(242),m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_AV_Q(ntryL,G1H4(147),ex3(:),G1H2(94),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_A_Q(ntryL,G1H2(94),29,nMT,G2H2(243),n2h2(88))
  call Hloop_AV_Q(ntryL,G0H4(5),ex3(:),G0H2(6),m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_A_Q(ntryL,G0H2(6),29,nMT,G1H2(94),n2h2(89))
call HGT_OLR(G1H4(149),1,1,4)
call HGT_invQ_OLR(G1H4(149),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(149),-6,nMT,G2H4(5),n2h4(42))
  call Hloop_QV_A(ntryL,G2H4(5),ex2(:),G2H2(244),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_AV_Q(ntryL,G1H4(152),ex3(:),G1H2(95),m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_A_Q(ntryL,G1H2(95),29,nMT,G2H2(245),n2h2(90))
  call Hloop_AV_Q(ntryL,G0H4(6),ex3(:),G0H2(4),m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_A_Q(ntryL,G0H2(4),29,nMT,G1H2(95),n2h2(91))
  call Hloop_QV_A(ntryL,G1H4(153),ex3(:),G1H2(96),m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_Q_A(ntryL,G1H2(96),29,nMB,G2H2(246),n2h2(92))
call HGT_OLR(G1H4(154),1,1,4)
call HGT_invQ_OLR(G1H4(154),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(154),-2,nMB,G2H4(6),n2h4(43))
  call Hloop_AV_Q(ntryL,G2H4(6),ex2(:),G2H2(247),m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_QV_A(ntryL,G1H4(159),ex3(:),G1H2(96),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_Q_A(ntryL,G1H2(96),29,nMB,G2H2(248),n2h2(93))
  call Hloop_QV_A(ntryL,G1H4(164),ex3(:),G1H2(96),m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_Q_A(ntryL,G1H2(96),29,nMB,G2H2(249),n2h2(94))
call HGT_OLR(G1H4(160),1,1,4)
call HGT_invQ_OLR(G1H4(160),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(160),-2,nMB,G2H4(9),n2h4(44))
  call Hloop_AV_Q(ntryL,G2H4(9),ex2(:),G2H2(250),m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_QV_A(ntryL,G1H4(163),ex3(:),G1H2(96),m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_Q_A(ntryL,G1H2(96),29,nMB,G2H2(251),n2h2(95))
  call Hloop_QV_A(ntryL,G0H4(7),ex3(:),G0H2(3),m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_Q_A(ntryL,G0H2(3),29,nMB,G1H2(96),n2h2(96))
call HGT_OLR(G1H4(165),1,1,4)
call HGT_invQ_OLR(G1H4(165),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(165),-6,nMB,G2H4(43),n2h4(45))
  call Hloop_AV_Q(ntryL,G2H4(43),ex2(:),G2H2(252),m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_QV_A(ntryL,G1H4(168),ex3(:),G1H2(97),m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_Q_A(ntryL,G1H2(97),29,nMB,G2H2(253),n2h2(97))
  call Hloop_QV_A(ntryL,G0H4(8),ex3(:),G0H2(5),m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_Q_A(ntryL,G0H2(5),29,nMB,G1H2(97),n2h2(98))
call HGT_raise_alpha_OLR(G1H4(170),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(170),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(170),ex2(:),G1H2(98),m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_TV_S(ntryL,G1H4(173),25,ex3(:),4,G2H2(254),m3h2x2(:,132),heltab2x4(:,:,132))
call HGT_raise_alpha_OLR(G1H4(175),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(175),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(175),ex2(:),G1H2(99),m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_TV_S(ntryL,G1H4(178),25,ex3(:),4,G2H2(255),m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_UV_W(ntryL,G1H4(179),25,ex3(:),4,G2H2(256),m3h2x2(:,135),heltab2x4(:,:,135))
call HGT_OLR(G1H4(180),1,1,4)
call HGT_invQ_OLR(G1H4(180),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(180),ex2(:),G1H2(100),m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_UV_W(ntryL,G1H4(185),25,ex3(:),4,G2H2(257),m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_UV_W(ntryL,G1H4(190),25,ex3(:),4,G2H2(258),m3h2x2(:,138),heltab2x4(:,:,138))
call HGT_OLR(G1H4(186),1,1,4)
call HGT_invQ_OLR(G1H4(186),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(186),ex2(:),G1H2(101),m3h2x2(:,139),heltab2x4(:,:,139))
  call Hloop_UV_W(ntryL,G1H4(189),25,ex3(:),4,G2H2(259),m3h2x2(:,140),heltab2x4(:,:,140))
call HGT_OLR(G1H4(191),1,1,4)
call HGT_invQ_OLR(G1H4(191),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(191),ex2(:),G1H2(102),m3h2x2(:,141),heltab2x4(:,:,141))
  call Hloop_UV_W(ntryL,G1H4(194),25,ex3(:),4,G2H2(260),m3h2x2(:,142),heltab2x4(:,:,142))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(177),[G2H3(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(165),[G2H3(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(168),[G2H3(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(171),[G2H3(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(174),[G2H3(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(118),[G2H3(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(122),[G2H3(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(210),[G2H3(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(198),[G2H3(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(201),[G2H3(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(204),[G2H3(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(207),[G2H3(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(180),[G2H3(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(183),[G2H3(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(228),[G2H3(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(231),[G2H3(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(213),[G2H3(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(216),[G2H3(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(225),[G2H3(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(219),[G2H3(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(222),[G2H3(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(258),[G2H3(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(234),[G2H3(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(237),[G2H3(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(261),[G2H3(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(264),[G2H3(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(252),[G2H3(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(255),[G2H3(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(282),[G2H3(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(285),[G2H3(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(267),[G2H3(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(270),[G2H3(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(279),[G2H3(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(273),[G2H3(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(276),[G2H3(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(312),[G2H3(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(288),[G2H3(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(291),[G2H3(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(315),[G2H3(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(318),[G2H3(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(306),[G2H3(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(309),[G2H3(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(45),[G0H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(93),[G1H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G2H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(233),[G2H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(15),[G1H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(113),[G2H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(109),[G2H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(116),[G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(51),[G0H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(54),[G2H2(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(256),[G2H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(136),[G2H2(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(132),[G2H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(121),[G2H3(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(126),[G2H3(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(167),[G2H3(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(170),[G2H3(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(182),[G2H3(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(185),[G2H3(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(200),[G2H3(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(203),[G2H3(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(215),[G2H3(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(218),[G2H3(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(221),[G2H3(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(224),[G2H3(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(254),[G2H3(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(257),[G2H3(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(236),[G2H3(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(239),[G2H3(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(269),[G2H3(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(272),[G2H3(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(275),[G2H3(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(278),[G2H3(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(308),[G2H3(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(311),[G2H3(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(290),[G2H3(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(293),[G2H3(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(97),[G2H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(100),[G2H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(112),[G2H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(120),[G2H2(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(123),[G2H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(135),[G2H2(60)])
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(177),ex4(:),G2tensor(1),m3h3x1(:,45),heltab2x3(:,:,195))
  call Hotf_5pt_reduction(G2H3(165),RedSet_5(1),mass5set(:,6),  & 
G1H3(107),G1H3(153),G1H3(112),G1H3(158),G1H3(108),G1H3(111),3)
  call HG1shiftOLR(G1H3(153),8,3)
  call Hotf_5pt_reduction(G2H3(168),RedSet_5(1),mass5set(:,5),  & 
G1H3(43),G1H3(113),G1H3(116),G1H3(47),G1H3(117),G1H3(49),3)
  call HG1shiftOLR(G1H3(113),8,3)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(171),ex4(:),G2tensor(2),m3h3x1(:,46),heltab2x3(:,:,196))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(174),ex4(:),G2tensor(3),m3h3x1(:,47),heltab2x3(:,:,197))
  call Hotf_5pt_reduction(G2H3(118),RedSet_5(1),mass5set(:,4),  & 
G1H3(118),G1H3(123),G1H3(50),G1H3(128),G1H3(53),G1H3(124),3)
  call HG1shiftOLR(G1H3(123),8,3)
  call Hotf_5pt_reduction(G2H3(122),RedSet_5(1),mass5set(:,5),  & 
G1H3(127),G1H3(54),G1H3(129),G1H3(132),G1H3(56),G1H3(134),3)
  call HG1shiftOLR(G1H3(54),8,3)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(210),ex4(:),G2tensor(4),m3h3x1(:,48),heltab2x3(:,:,198))
  call Hotf_5pt_reduction(G2H3(198),RedSet_5(2),mass5set(:,6),  & 
G1H3(137),G1H3(139),G1H3(142),G1H3(144),G1H3(147),G1H3(149),3)
  call HG1shiftOLR(G1H3(139),8,3)
  call Hotf_5pt_reduction(G2H3(201),RedSet_5(2),mass5set(:,5),  & 
G1H3(152),G1H3(154),G1H3(157),G1H3(159),G1H3(162),G1H3(60),3)
  call HG1shiftOLR(G1H3(154),8,3)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(204),ex4(:),G2tensor(5),m3h3x1(:,49),heltab2x3(:,:,199))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(207),ex4(:),G2tensor(6),m3h3x1(:,50),heltab2x3(:,:,200))
  call Hotf_5pt_reduction(G2H3(180),RedSet_5(2),mass5set(:,4),  & 
G1H3(61),G1H3(62),G1H3(65),G1H3(67),G1H3(211),G1H3(216),3)
  call HG1shiftOLR(G1H3(62),8,3)
  call Hotf_5pt_reduction(G2H3(183),RedSet_5(2),mass5set(:,5),  & 
G1H3(73),G1H3(74),G1H3(226),G1H3(80),G1H3(231),G1H3(236),3)
  call HG1shiftOLR(G1H3(74),8,3)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(228),ex4(:),G2tensor(7),m3h3x1(:,51),heltab2x3(:,:,201))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(231),ex4(:),G2tensor(8),m3h3x1(:,52),heltab2x3(:,:,202))
  call Hotf_5pt_reduction(G2H3(213),RedSet_5(3),mass5set(:,4),  & 
G1H3(29),G1H3(35),G1H3(163),G1H3(42),G1H3(164),G1H3(169),3)
  call HG1shiftOLR(G1H3(35),8,3)
  call Hotf_5pt_reduction(G2H3(216),RedSet_5(3),mass5set(:,5),  & 
G1H3(72),G1H3(174),G1H3(77),G1H3(170),G1H3(173),G1H3(78),3)
  call HG1shiftOLR(G1H3(174),8,3)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(225),ex4(:),G2tensor(9),m3h3x1(:,53),heltab2x3(:,:,203))
  call Hotf_5pt_reduction(G2H3(219),RedSet_5(3),mass5set(:,6),  & 
G1H3(175),G1H3(178),G1H3(89),G1H3(179),G1H3(106),G1H3(180),3)
  call HG1shiftOLR(G1H3(178),8,3)
  call Hotf_5pt_reduction(G2H3(222),RedSet_5(3),mass5set(:,5),  & 
G1H3(185),G1H3(121),G1H3(190),G1H3(122),G1H3(186),G1H3(189),3)
  call HG1shiftOLR(G1H3(121),8,3)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(258),ex4(:),G2tensor(10),m3h3x1(:,54),heltab2x3(:,:,204))
  call Hotf_5pt_reduction(G2H3(234),RedSet_5(5),mass5set(:,4),  & 
G1H3(168),G1H3(191),G1H3(194),G1H3(199),G1H3(195),G1H3(15),3)
  call HG1shiftOLR(G1H3(191),8,3)
  call Hotf_5pt_reduction(G2H3(237),RedSet_5(5),mass5set(:,5),  & 
G1H3(196),G1H3(201),G1H3(4),G1H3(206),G1H3(6),G1H3(202),3)
  call HG1shiftOLR(G1H3(201),8,3)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(261),ex4(:),G2tensor(11),m3h3x1(:,55),heltab2x3(:,:,205))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(264),ex4(:),G2tensor(12),m3h3x1(:,56),heltab2x3(:,:,206))
  call Hotf_5pt_reduction(G2H3(252),RedSet_5(5),mass5set(:,6),  & 
G1H3(205),G1H3(7),G1H3(207),G1H3(210),G1H3(11),G1H3(212),3)
  call HG1shiftOLR(G1H3(7),8,3)
  call Hotf_5pt_reduction(G2H3(255),RedSet_5(5),mass5set(:,5),  & 
G1H3(215),G1H3(217),G1H3(220),G1H3(222),G1H3(225),G1H3(227),3)
  call HG1shiftOLR(G1H3(217),8,3)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(282),ex4(:),G2tensor(13),m3h3x1(:,57),heltab2x3(:,:,207))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(285),ex4(:),G2tensor(14),m3h3x1(:,58),heltab2x3(:,:,208))
  call Hotf_5pt_reduction(G2H3(267),RedSet_5(7),mass5set(:,4),  & 
G1H3(230),G1H3(232),G1H3(235),G1H3(237),G1H3(240),G1H3(18),3)
  call HG1shiftOLR(G1H3(232),8,3)
  call Hotf_5pt_reduction(G2H3(270),RedSet_5(7),mass5set(:,5),  & 
G1H3(19),G1H3(20),G1H3(23),G1H3(85),G1H3(86),G1H3(91),3)
  call HG1shiftOLR(G1H3(20),8,3)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(279),ex4(:),G2tensor(15),m3h3x1(:,59),heltab2x3(:,:,209))
  call Hotf_5pt_reduction(G2H3(273),RedSet_5(7),mass5set(:,6),  & 
G1H3(138),G1H3(96),G1H3(92),G1H3(32),G1H3(97),G1H3(100),3)
  call HG1shiftOLR(G1H3(96),8,3)
  call Hotf_5pt_reduction(G2H3(276),RedSet_5(7),mass5set(:,5),  & 
G1H3(148),G1H3(38),G1H3(241),G1H3(242),G1H3(243),G1H3(244),3)
  call HG1shiftOLR(G1H3(38),8,3)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(312),ex4(:),G2tensor(16),m3h3x1(:,60),heltab2x3(:,:,210))
  call Hotf_5pt_reduction(G2H3(288),RedSet_5(9),mass5set(:,4),  & 
G1H3(245),G1H3(246),G1H3(247),G1H3(248),G1H3(249),G1H3(250),3)
  call HG1shiftOLR(G1H3(246),8,3)
  call Hotf_5pt_reduction(G2H3(291),RedSet_5(9),mass5set(:,5),  & 
G1H3(251),G1H3(252),G1H3(253),G1H3(254),G1H3(255),G1H3(256),3)
  call HG1shiftOLR(G1H3(252),8,3)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(315),ex4(:),G2tensor(17),m3h3x1(:,61),heltab2x3(:,:,211))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(318),ex4(:),G2tensor(18),m3h3x1(:,62),heltab2x3(:,:,212))
  call Hotf_5pt_reduction(G2H3(306),RedSet_5(9),mass5set(:,6),  & 
G1H3(257),G1H3(258),G1H3(259),G1H3(260),G1H3(261),G1H3(262),3)
  call HG1shiftOLR(G1H3(258),8,3)
  call Hotf_5pt_reduction(G2H3(309),RedSet_5(9),mass5set(:,5),  & 
G1H3(263),G1H3(264),G1H3(265),G1H3(266),G1H3(267),G1H3(268),3)
  call HG1shiftOLR(G1H3(264),8,3)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(45),ex3(:),G2tensor(19),m3h2x1(:,7),heltab2x2(:,:,21))
  call Hotf_5pt_reduction(G2H2(93),RedSet_5(11),mass5set(:,12),  & 
G1H2(13),G1H2(14),G1H2(16),G1H2(17),G1H2(103),G1H2(104),2)
  call HG1shiftOLR(G1H2(14),4,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(48),ex3(:),G2tensor(20),m3h2x1(:,8),heltab2x2(:,:,22))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(233),ex3(:),G2tensor(21),m3h2x1(:,9),heltab2x2(:,:,23))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(15),27,ex3(:),4,G2tensor(22),m3h2x1(:,10),heltab2x2(:,:,24))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(113),ex3(:),G2tensor(23),m3h2x1(:,11),heltab2x2(:,:,25))
  call Hotf_5pt_reduction(G2H2(109),RedSet_5(11),mass5set(:,11),  & 
G1H2(15),G1H2(105),G1H2(106),G1H2(107),G1H2(108),G1H2(109),2)
  call HG1shiftOLR(G1H2(105),4,2)
  call Hotf_5pt_reduction(G2H2(116),RedSet_5(12),mass5set(:,12),  & 
G1H2(110),G1H2(111),G1H2(112),G1H2(113),G1H2(114),G1H2(115),2)
  call HG1shiftOLR(G1H2(111),2,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(51),ex2(:),G2tensor(24),m3h2x1(:,12),heltab2x2(:,:,26))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(54),ex2(:),G2tensor(25),m3h2x1(:,13),heltab2x2(:,:,27))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(256),ex2(:),G2tensor(26),m3h2x1(:,14),heltab2x2(:,:,28))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(18),29,ex2(:),2,G2tensor(27),m3h2x1(:,15),heltab2x2(:,:,29))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(136),ex2(:),G2tensor(28),m3h2x1(:,16),heltab2x2(:,:,30))
  call Hotf_5pt_reduction(G2H2(132),RedSet_5(12),mass5set(:,11),  & 
G1H2(18),G1H2(116),G1H2(117),G1H2(118),G1H2(119),G1H2(120),2)
  call HG1shiftOLR(G1H2(116),2,2)
  call Hotf_4pt_reduction(G2H3(121),RedSet_4(2),mass4set(:,6),  & 
G1H3(269),G1H3(270),G1H3(271),G1H3(272),G1H3(273),3)
  call HG1shiftOLR(G1H3(270),10,3)
  call Hotf_4pt_reduction(G2H3(126),RedSet_4(2),mass4set(:,5),  & 
G1H3(274),G1H3(275),G1H3(276),G1H3(277),G1H3(278),3)
  call HG1shiftOLR(G1H3(275),10,3)
  call Hotf_4pt_reduction(G2H3(167),RedSet_4(2),mass4set(:,4),  & 
G1H3(279),G1H3(280),G1H3(281),G1H3(282),G1H3(283),3)
  call HG1shiftOLR(G1H3(280),10,3)
  call Hotf_4pt_reduction(G2H3(170),RedSet_4(2),mass4set(:,5),  & 
G1H3(284),G1H3(285),G1H3(286),G1H3(287),G1H3(288),3)
  call HG1shiftOLR(G1H3(285),10,3)
  call Hotf_4pt_reduction(G2H3(182),RedSet_4(4),mass4set(:,6),  & 
G1H3(289),G1H3(290),G1H3(291),G1H3(292),G1H3(293),3)
  call HG1shiftOLR(G1H3(290),12,3)
  call Hotf_4pt_reduction(G2H3(185),RedSet_4(4),mass4set(:,5),  & 
G1H3(294),G1H3(295),G1H3(296),G1H3(297),G1H3(298),3)
  call HG1shiftOLR(G1H3(295),12,3)
  call Hotf_4pt_reduction(G2H3(200),RedSet_4(4),mass4set(:,4),  & 
G1H3(299),G1H3(300),G1H3(301),G1H3(302),G1H3(303),3)
  call HG1shiftOLR(G1H3(300),12,3)
  call Hotf_4pt_reduction(G2H3(203),RedSet_4(4),mass4set(:,5),  & 
G1H3(304),G1H3(305),G1H3(306),G1H3(307),G1H3(308),3)
  call HG1shiftOLR(G1H3(305),12,3)
  call Hotf_4pt_reduction(G2H3(215),RedSet_4(5),mass4set(:,6),  & 
G1H3(309),G1H3(310),G1H3(311),G1H3(312),G1H3(313),3)
  call HG1shiftOLR(G1H3(310),9,3)
  call Hotf_4pt_reduction(G2H3(218),RedSet_4(5),mass4set(:,5),  & 
G1H3(314),G1H3(315),G1H3(316),G1H3(317),G1H3(318),3)
  call HG1shiftOLR(G1H3(315),9,3)
  call Hotf_5pt_reduction(G2H3(35),RedSet_5(3),mass5set(:,6),  & 
G1H3(319),G1H3(320),G1H3(321),G1H3(322),G1H3(323),G1H3(324),3)
  call HG1shiftOLR(G1H3(320),8,3)
  call Hotf_4pt_reduction(G2H3(37),RedSet_4(5),mass4set(:,4),  & 
G1H3(325),G1H3(326),G1H3(327),G1H3(328),G1H3(329),3)
  call HG1shiftOLR(G1H3(326),9,3)
  call Hotf_5pt_reduction(G2H3(39),RedSet_5(3),mass5set(:,5),  & 
G1H3(330),G1H3(331),G1H3(332),G1H3(333),G1H3(334),G1H3(335),3)
  call HG1shiftOLR(G1H3(331),8,3)
  call Hotf_4pt_reduction(G2H3(43),RedSet_4(5),mass4set(:,5),  & 
G1H3(336),G1H3(337),G1H3(338),G1H3(339),G1H3(340),3)
  call HG1shiftOLR(G1H3(337),9,3)
  call Hotf_5pt_reduction(G2H3(44),RedSet_5(3),mass5set(:,6),  & 
G1H3(341),G1H3(342),G1H3(343),G1H3(344),G1H3(345),G1H3(346),3)
  call HG1shiftOLR(G1H3(342),8,3)
  call Hotf_4pt_reduction(G2H3(48),RedSet_4(5),mass4set(:,4),  & 
G1H3(347),G1H3(348),G1H3(349),G1H3(350),G1H3(351),3)
  call HG1shiftOLR(G1H3(348),9,3)
  call Hotf_5pt_reduction(G2H3(49),RedSet_5(3),mass5set(:,5),  & 
G1H3(352),G1H3(353),G1H3(354),G1H3(355),G1H3(356),G1H3(357),3)
  call HG1shiftOLR(G1H3(353),8,3)
  call Hotf_4pt_reduction(G2H3(52),RedSet_4(5),mass4set(:,5),  & 
G1H3(358),G1H3(359),G1H3(360),G1H3(361),G1H3(362),3)
  call HG1shiftOLR(G1H3(359),9,3)
  call Hotf_4pt_reduction(G2H3(221),RedSet_4(5),mass4set(:,4),  & 
G1H3(363),G1H3(364),G1H3(365),G1H3(366),G1H3(367),3)
  call HG1shiftOLR(G1H3(364),9,3)
  call Hotf_4pt_reduction(G2H3(224),RedSet_4(5),mass4set(:,5),  & 
G1H3(368),G1H3(369),G1H3(370),G1H3(371),G1H3(372),3)
  call HG1shiftOLR(G1H3(369),9,3)
  call Hotf_4pt_reduction(G2H3(254),RedSet_4(8),mass4set(:,4),  & 
G1H3(373),G1H3(374),G1H3(375),G1H3(376),G1H3(377),3)
  call HG1shiftOLR(G1H3(374),12,3)
  call Hotf_4pt_reduction(G2H3(257),RedSet_4(8),mass4set(:,5),  & 
G1H3(378),G1H3(379),G1H3(380),G1H3(381),G1H3(382),3)
  call HG1shiftOLR(G1H3(379),12,3)
  call Hotf_4pt_reduction(G2H3(236),RedSet_4(8),mass4set(:,6),  & 
G1H3(383),G1H3(384),G1H3(385),G1H3(386),G1H3(387),3)
  call HG1shiftOLR(G1H3(384),12,3)
  call Hotf_4pt_reduction(G2H3(239),RedSet_4(8),mass4set(:,5),  & 
G1H3(388),G1H3(389),G1H3(390),G1H3(391),G1H3(392),3)
  call HG1shiftOLR(G1H3(389),12,3)
  call Hotf_4pt_reduction(G2H3(269),RedSet_4(10),mass4set(:,6),  & 
G1H3(393),G1H3(394),G1H3(395),G1H3(396),G1H3(397),3)
  call HG1shiftOLR(G1H3(394),9,3)
  call Hotf_4pt_reduction(G2H3(272),RedSet_4(10),mass4set(:,5),  & 
G1H3(398),G1H3(399),G1H3(400),G1H3(401),G1H3(402),3)
  call HG1shiftOLR(G1H3(399),9,3)
  call Hotf_5pt_reduction(G2H3(80),RedSet_5(7),mass5set(:,6),  & 
G1H3(403),G1H3(404),G1H3(405),G1H3(406),G1H3(407),G1H3(408),3)
  call HG1shiftOLR(G1H3(404),8,3)
  call Hotf_4pt_reduction(G2H3(84),RedSet_4(10),mass4set(:,4),  & 
G1H3(409),G1H3(410),G1H3(411),G1H3(412),G1H3(413),3)
  call HG1shiftOLR(G1H3(410),9,3)
  call Hotf_5pt_reduction(G2H3(87),RedSet_5(7),mass5set(:,5),  & 
G1H3(414),G1H3(415),G1H3(416),G1H3(417),G1H3(418),G1H3(419),3)
  call HG1shiftOLR(G1H3(415),8,3)
  call Hotf_4pt_reduction(G2H3(90),RedSet_4(10),mass4set(:,5),  & 
G1H3(420),G1H3(421),G1H3(422),G1H3(423),G1H3(424),3)
  call HG1shiftOLR(G1H3(421),9,3)
  call Hotf_5pt_reduction(G2H3(91),RedSet_5(7),mass5set(:,6),  & 
G1H3(425),G1H3(426),G1H3(427),G1H3(428),G1H3(429),G1H3(430),3)
  call HG1shiftOLR(G1H3(426),8,3)
  call Hotf_4pt_reduction(G2H3(94),RedSet_4(10),mass4set(:,4),  & 
G1H3(431),G1H3(432),G1H3(433),G1H3(434),G1H3(435),3)
  call HG1shiftOLR(G1H3(432),9,3)
  call Hotf_5pt_reduction(G2H3(95),RedSet_5(7),mass5set(:,5),  & 
G1H3(436),G1H3(437),G1H3(438),G1H3(439),G1H3(440),G1H3(441),3)
  call HG1shiftOLR(G1H3(437),8,3)
  call Hotf_4pt_reduction(G2H3(98),RedSet_4(10),mass4set(:,5),  & 
G1H3(442),G1H3(443),G1H3(444),G1H3(445),G1H3(446),3)
  call HG1shiftOLR(G1H3(443),9,3)
  call Hotf_4pt_reduction(G2H3(275),RedSet_4(10),mass4set(:,4),  & 
G1H3(447),G1H3(448),G1H3(449),G1H3(450),G1H3(451),3)
  call HG1shiftOLR(G1H3(448),9,3)
  call Hotf_4pt_reduction(G2H3(278),RedSet_4(10),mass4set(:,5),  & 
G1H3(452),G1H3(453),G1H3(454),G1H3(455),G1H3(456),3)
  call HG1shiftOLR(G1H3(453),9,3)
  call Hotf_4pt_reduction(G2H3(308),RedSet_4(12),mass4set(:,4),  & 
G1H3(457),G1H3(458),G1H3(459),G1H3(460),G1H3(461),3)
  call HG1shiftOLR(G1H3(458),10,3)
  call Hotf_4pt_reduction(G2H3(311),RedSet_4(12),mass4set(:,5),  & 
G1H3(462),G1H3(463),G1H3(464),G1H3(465),G1H3(466),3)
  call HG1shiftOLR(G1H3(463),10,3)
  call Hotf_4pt_reduction(G2H3(290),RedSet_4(12),mass4set(:,6),  & 
G1H3(467),G1H3(468),G1H3(469),G1H3(470),G1H3(471),3)
  call HG1shiftOLR(G1H3(468),10,3)
  call Hotf_4pt_reduction(G2H3(293),RedSet_4(12),mass4set(:,5),  & 
G1H3(472),G1H3(473),G1H3(474),G1H3(475),G1H3(476),3)
  call HG1shiftOLR(G1H3(473),10,3)
  call Hotf_5pt_reduction(G2H2(97),RedSet_5(11),mass5set(:,11),  & 
G1H2(121),G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),2)
  call HG1shiftOLR(G1H2(122),4,2)
  call Hotf_4pt_reduction(G2H2(100),RedSet_4(14),mass4set(:,9),  & 
G1H2(127),G1H2(128),G1H2(129),G1H2(130),G1H2(131),2)
  call HG1shiftOLR(G1H2(128),6,2)
  call Hotf_4pt_reduction(G2H2(112),RedSet_4(14),mass4set(:,9),  & 
G1H2(132),G1H2(133),G1H2(134),G1H2(135),G1H2(136),2)
  call HG1shiftOLR(G1H2(133),6,2)
  call Hotf_5pt_reduction(G2H2(120),RedSet_5(12),mass5set(:,11),  & 
G1H2(137),G1H2(138),G1H2(139),G1H2(140),G1H2(141),G1H2(142),2)
  call HG1shiftOLR(G1H2(138),2,2)
  call Hotf_4pt_reduction(G2H2(123),RedSet_4(14),mass4set(:,9),  & 
G1H2(143),G1H2(144),G1H2(145),G1H2(146),G1H2(147),2)
  call HG1shiftOLR(G1H2(144),6,2)
  call Hotf_4pt_reduction(G2H2(135),RedSet_4(14),mass4set(:,9),  & 
G1H2(148),G1H2(149),G1H2(150),G1H2(151),G1H2(152),2)
  call HG1shiftOLR(G1H2(149),6,2)
  call Hotf_5pt_reduction(G2H3(129),RedSet_5(1),mass5set(:,6),  & 
G1H3(477),G1H3(478),G1H3(479),G1H3(480),G1H3(481),G1H3(482),3)
  call HG1shiftOLR(G1H3(478),8,3)
  call Hotf_4pt_reduction(G2H3(133),RedSet_4(2),mass4set(:,4),  & 
G1H3(483),G1H3(484),G1H3(485),G1H3(486),G1H3(487),3)
  call HG1shiftOLR(G1H3(484),10,3)
  call Hotf_5pt_reduction(G2H3(134),RedSet_5(1),mass5set(:,5),  & 
G1H3(488),G1H3(489),G1H3(490),G1H3(491),G1H3(492),G1H3(493),3)
  call HG1shiftOLR(G1H3(489),8,3)
  call Hotf_4pt_reduction(G2H3(138),RedSet_4(2),mass4set(:,5),  & 
G1H3(494),G1H3(495),G1H3(496),G1H3(497),G1H3(498),3)
  call HG1shiftOLR(G1H3(495),10,3)
  call Hotf_5pt_reduction(G2H3(141),RedSet_5(1),mass5set(:,6),  & 
G1H3(499),G1H3(500),G1H3(501),G1H3(502),G1H3(503),G1H3(504),3)
  call HG1shiftOLR(G1H3(500),8,3)
  call Hotf_4pt_reduction(G2H3(161),RedSet_4(2),mass4set(:,4),  & 
G1H3(505),G1H3(506),G1H3(507),G1H3(508),G1H3(509),3)
  call HG1shiftOLR(G1H3(506),10,3)
  call Hotf_5pt_reduction(G2H3(162),RedSet_5(1),mass5set(:,5),  & 
G1H3(510),G1H3(511),G1H3(512),G1H3(513),G1H3(514),G1H3(515),3)
  call HG1shiftOLR(G1H3(511),8,3)
  call Hotf_4pt_reduction(G2H3(164),RedSet_4(2),mass4set(:,5),  & 
G1H3(516),G1H3(517),G1H3(518),G1H3(519),G1H3(520),3)
  call HG1shiftOLR(G1H3(517),10,3)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(173),ex4(:),G2tensor(29),m3h3x1(:,63),heltab2x3(:,:,213))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(176),ex4(:),G2tensor(30),m3h3x1(:,64),heltab2x3(:,:,214))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(179),ex4(:),G2tensor(31),m3h3x1(:,65),heltab2x3(:,:,215))
  call Hotf_5pt_reduction(G2H3(186),RedSet_5(2),mass5set(:,6),  & 
G1H3(521),G1H3(522),G1H3(523),G1H3(524),G1H3(525),G1H3(526),3)
  call HG1shiftOLR(G1H3(522),8,3)
  call Hotf_4pt_reduction(G2H3(188),RedSet_4(4),mass4set(:,4),  & 
G1H3(527),G1H3(528),G1H3(529),G1H3(530),G1H3(531),3)
  call HG1shiftOLR(G1H3(528),12,3)
  call Hotf_5pt_reduction(G2H3(189),RedSet_5(2),mass5set(:,5),  & 
G1H3(532),G1H3(533),G1H3(534),G1H3(535),G1H3(536),G1H3(537),3)
  call HG1shiftOLR(G1H3(533),8,3)
  call Hotf_4pt_reduction(G2H3(191),RedSet_4(4),mass4set(:,5),  & 
G1H3(538),G1H3(539),G1H3(540),G1H3(541),G1H3(542),3)
  call HG1shiftOLR(G1H3(539),12,3)
  call Hotf_5pt_reduction(G2H3(192),RedSet_5(2),mass5set(:,6),  & 
G1H3(543),G1H3(544),G1H3(545),G1H3(546),G1H3(547),G1H3(548),3)
  call HG1shiftOLR(G1H3(544),8,3)
  call Hotf_4pt_reduction(G2H3(194),RedSet_4(4),mass4set(:,4),  & 
G1H3(549),G1H3(550),G1H3(551),G1H3(552),G1H3(553),3)
  call HG1shiftOLR(G1H3(550),12,3)
  call Hotf_5pt_reduction(G2H3(195),RedSet_5(2),mass5set(:,5),  & 
G1H3(554),G1H3(555),G1H3(556),G1H3(557),G1H3(558),G1H3(559),3)
  call HG1shiftOLR(G1H3(555),8,3)
  call Hotf_4pt_reduction(G2H3(197),RedSet_4(4),mass4set(:,5),  & 
G1H3(560),G1H3(561),G1H3(562),G1H3(563),G1H3(564),3)
  call HG1shiftOLR(G1H3(561),12,3)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(206),ex4(:),G2tensor(32),m3h3x1(:,66),heltab2x3(:,:,216))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(209),ex4(:),G2tensor(33),m3h3x1(:,67),heltab2x3(:,:,217))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(212),ex4(:),G2tensor(34),m3h3x1(:,68),heltab2x3(:,:,218))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(227),ex4(:),G2tensor(35),m3h3x1(:,69),heltab2x3(:,:,219))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(230),ex4(:),G2tensor(36),m3h3x1(:,70),heltab2x3(:,:,220))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(233),ex4(:),G2tensor(37),m3h3x1(:,71),heltab2x3(:,:,221))
  call Hotf_5pt_reduction(G2H3(240),RedSet_5(5),mass5set(:,6),  & 
G1H3(565),G1H3(566),G1H3(567),G1H3(568),G1H3(569),G1H3(570),3)
  call HG1shiftOLR(G1H3(566),8,3)
  call Hotf_4pt_reduction(G2H3(242),RedSet_4(8),mass4set(:,4),  & 
G1H3(571),G1H3(572),G1H3(573),G1H3(574),G1H3(575),3)
  call HG1shiftOLR(G1H3(572),12,3)
  call Hotf_5pt_reduction(G2H3(243),RedSet_5(5),mass5set(:,5),  & 
G1H3(576),G1H3(577),G1H3(578),G1H3(579),G1H3(580),G1H3(581),3)
  call HG1shiftOLR(G1H3(577),8,3)
  call Hotf_4pt_reduction(G2H3(245),RedSet_4(8),mass4set(:,5),  & 
G1H3(582),G1H3(583),G1H3(584),G1H3(585),G1H3(586),3)
  call HG1shiftOLR(G1H3(583),12,3)
  call Hotf_5pt_reduction(G2H3(246),RedSet_5(5),mass5set(:,6),  & 
G1H3(587),G1H3(588),G1H3(589),G1H3(590),G1H3(591),G1H3(592),3)
  call HG1shiftOLR(G1H3(588),8,3)
  call Hotf_4pt_reduction(G2H3(248),RedSet_4(8),mass4set(:,4),  & 
G1H3(593),G1H3(594),G1H3(595),G1H3(596),G1H3(597),3)
  call HG1shiftOLR(G1H3(594),12,3)
  call Hotf_5pt_reduction(G2H3(249),RedSet_5(5),mass5set(:,5),  & 
G1H3(598),G1H3(599),G1H3(600),G1H3(601),G1H3(602),G1H3(603),3)
  call HG1shiftOLR(G1H3(599),8,3)
  call Hotf_4pt_reduction(G2H3(251),RedSet_4(8),mass4set(:,5),  & 
G1H3(604),G1H3(605),G1H3(606),G1H3(607),G1H3(608),3)
  call HG1shiftOLR(G1H3(605),12,3)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(260),ex4(:),G2tensor(38),m3h3x1(:,72),heltab2x3(:,:,222))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(263),ex4(:),G2tensor(39),m3h3x1(:,73),heltab2x3(:,:,223))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(266),ex4(:),G2tensor(40),m3h3x1(:,74),heltab2x3(:,:,224))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(281),ex4(:),G2tensor(41),m3h3x1(:,75),heltab2x3(:,:,225))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(284),ex4(:),G2tensor(42),m3h3x1(:,76),heltab2x3(:,:,226))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(287),ex4(:),G2tensor(43),m3h3x1(:,77),heltab2x3(:,:,227))
  call Hotf_5pt_reduction(G2H3(294),RedSet_5(9),mass5set(:,6),  & 
G1H3(609),G1H3(610),G1H3(611),G1H3(612),G1H3(613),G1H3(614),3)
  call HG1shiftOLR(G1H3(610),8,3)
  call Hotf_4pt_reduction(G2H3(296),RedSet_4(12),mass4set(:,4),  & 
G1H3(615),G1H3(616),G1H3(617),G1H3(618),G1H3(619),3)
  call HG1shiftOLR(G1H3(616),10,3)
  call Hotf_5pt_reduction(G2H3(297),RedSet_5(9),mass5set(:,5),  & 
G1H3(620),G1H3(621),G1H3(622),G1H3(623),G1H3(624),G1H3(625),3)
  call HG1shiftOLR(G1H3(621),8,3)
  call Hotf_4pt_reduction(G2H3(299),RedSet_4(12),mass4set(:,5),  & 
G1H3(626),G1H3(627),G1H3(628),G1H3(629),G1H3(630),3)
  call HG1shiftOLR(G1H3(627),10,3)
  call Hotf_5pt_reduction(G2H3(300),RedSet_5(9),mass5set(:,6),  & 
G1H3(631),G1H3(632),G1H3(633),G1H3(634),G1H3(635),G1H3(636),3)
  call HG1shiftOLR(G1H3(632),8,3)
  call Hotf_4pt_reduction(G2H3(302),RedSet_4(12),mass4set(:,4),  & 
G1H3(637),G1H3(638),G1H3(639),G1H3(640),G1H3(641),3)
  call HG1shiftOLR(G1H3(638),10,3)
  call Hotf_5pt_reduction(G2H3(303),RedSet_5(9),mass5set(:,5),  & 
G1H3(642),G1H3(643),G1H3(644),G1H3(645),G1H3(646),G1H3(647),3)
  call HG1shiftOLR(G1H3(643),8,3)
  call Hotf_4pt_reduction(G2H3(305),RedSet_4(12),mass4set(:,5),  & 
G1H3(648),G1H3(649),G1H3(650),G1H3(651),G1H3(652),3)
  call HG1shiftOLR(G1H3(649),10,3)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(314),ex4(:),G2tensor(44),m3h3x1(:,78),heltab2x3(:,:,228))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(317),ex4(:),G2tensor(45),m3h3x1(:,79),heltab2x3(:,:,229))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(320),ex4(:),G2tensor(46),m3h3x1(:,80),heltab2x3(:,:,230))
  call Hotf_4pt_reduction(G2H2(96),RedSet_4(14),mass4set(:,10),  & 
G1H2(153),G1H2(154),G1H2(155),G1H2(156),G1H2(157),2)
  call HG1shiftOLR(G1H2(154),6,2)
  call Hotf_5pt_reduction(G2H2(101),RedSet_5(11),mass5set(:,11),  & 
G1H2(158),G1H2(159),G1H2(160),G1H2(161),G1H2(162),G1H2(163),2)
  call HG1shiftOLR(G1H2(159),4,2)
  call Hotf_4pt_reduction(G2H2(104),RedSet_4(14),mass4set(:,9),  & 
G1H2(164),G1H2(165),G1H2(166),G1H2(167),G1H2(168),2)
  call HG1shiftOLR(G1H2(165),6,2)
  call Hotf_5pt_reduction(G2H2(105),RedSet_5(11),mass5set(:,11),  & 
G1H2(169),G1H2(170),G1H2(171),G1H2(172),G1H2(173),G1H2(174),2)
  call HG1shiftOLR(G1H2(170),4,2)
  call Hotf_4pt_reduction(G2H2(108),RedSet_4(14),mass4set(:,9),  & 
G1H2(175),G1H2(176),G1H2(177),G1H2(178),G1H2(179),2)
  call HG1shiftOLR(G1H2(176),6,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(115),ex3(:),G2tensor(47),m3h2x1(:,17),heltab2x2(:,:,31))
  call Hotf_4pt_reduction(G2H2(119),RedSet_4(14),mass4set(:,10),  & 
G1H2(180),G1H2(181),G1H2(182),G1H2(183),G1H2(184),2)
  call HG1shiftOLR(G1H2(181),6,2)
  call Hotf_5pt_reduction(G2H2(124),RedSet_5(12),mass5set(:,11),  & 
G1H2(185),G1H2(186),G1H2(187),G1H2(188),G1H2(189),G1H2(190),2)
  call HG1shiftOLR(G1H2(186),2,2)
  call Hotf_4pt_reduction(G2H2(127),RedSet_4(14),mass4set(:,9),  & 
G1H2(191),G1H2(192),G1H2(193),G1H2(194),G1H2(195),2)
  call HG1shiftOLR(G1H2(192),6,2)
  call Hotf_5pt_reduction(G2H2(128),RedSet_5(12),mass5set(:,11),  & 
G1H2(196),G1H2(197),G1H2(198),G1H2(199),G1H2(200),G1H2(201),2)
  call HG1shiftOLR(G1H2(197),2,2)
  call Hotf_4pt_reduction(G2H2(131),RedSet_4(14),mass4set(:,9),  & 
G1H2(202),G1H2(203),G1H2(204),G1H2(205),G1H2(206),2)
  call HG1shiftOLR(G1H2(203),6,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(138),ex2(:),G2tensor(48),m3h2x1(:,18),heltab2x2(:,:,32))
  call Hotf_5pt_reduction(G2H3(321),RedSet_5(1),mass5set(:,1),  & 
G1H3(653),G1H3(654),G1H3(655),G1H3(656),G1H3(657),G1H3(658),3)
  call HG1shiftOLR(G1H3(654),8,3)
  call Hotf_4pt_reduction(G2H3(323),RedSet_4(2),mass4set(:,1),  & 
G1H3(659),G1H3(660),G1H3(661),G1H3(662),G1H3(663),3)
  call HG1shiftOLR(G1H3(660),10,3)
  call Hloop_AW_Q(ntryL,G1H3(71),ex4(:),G1H1(19),m3h3x1(:,81),heltab2x3(:,:,231))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,0,G2tensor(49),n2h1(1))
  call Hotf_5pt_reduction(G2H3(326),RedSet_5(1),mass5set(:,2),  & 
G1H3(71),G1H3(664),G1H3(665),G1H3(666),G1H3(667),G1H3(668),3)
  call HG1shiftOLR(G1H3(664),8,3)
  call Hotf_4pt_reduction(G2H3(328),RedSet_4(2),mass4set(:,2),  & 
G1H3(669),G1H3(670),G1H3(671),G1H3(672),G1H3(673),3)
  call HG1shiftOLR(G1H3(670),10,3)
  call Hloop_QW_A(ntryL,G1H3(90),ex4(:),G1H1(19),m3h3x1(:,82),heltab2x3(:,:,232))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(50),n2h1(2))
  call Hotf_5pt_reduction(G2H3(331),RedSet_5(1),mass5set(:,3),  & 
G1H3(90),G1H3(674),G1H3(675),G1H3(676),G1H3(677),G1H3(678),3)
  call HG1shiftOLR(G1H3(674),8,3)
  call Hotf_4pt_reduction(G2H3(333),RedSet_4(2),mass4set(:,3),  & 
G1H3(679),G1H3(680),G1H3(681),G1H3(682),G1H3(683),3)
  call HG1shiftOLR(G1H3(680),10,3)
  call Hloop_AW_Q(ntryL,G1H3(183),ex4(:),G1H1(19),m3h3x1(:,83),heltab2x3(:,:,233))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(51),n2h1(3))
  call Hotf_5pt_reduction(G2H3(342),RedSet_5(2),mass5set(:,1),  & 
G1H3(183),G1H3(684),G1H3(685),G1H3(686),G1H3(687),G1H3(688),3)
  call HG1shiftOLR(G1H3(684),8,3)
  call Hotf_4pt_reduction(G2H3(344),RedSet_4(4),mass4set(:,1),  & 
G1H3(689),G1H3(690),G1H3(691),G1H3(692),G1H3(693),3)
  call HG1shiftOLR(G1H3(690),12,3)
  call Hloop_AW_Q(ntryL,G1H3(5),ex4(:),G1H1(19),m3h3x1(:,84),heltab2x3(:,:,234))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,0,G2tensor(52),n2h1(4))
  call Hotf_5pt_reduction(G2H3(347),RedSet_5(2),mass5set(:,2),  & 
G1H3(5),G1H3(694),G1H3(695),G1H3(696),G1H3(697),G1H3(698),3)
  call HG1shiftOLR(G1H3(694),8,3)
  call Hotf_4pt_reduction(G2H3(349),RedSet_4(4),mass4set(:,2),  & 
G1H3(699),G1H3(700),G1H3(701),G1H3(702),G1H3(703),3)
  call HG1shiftOLR(G1H3(700),12,3)
  call Hloop_QW_A(ntryL,G1H3(17),ex4(:),G1H1(19),m3h3x1(:,85),heltab2x3(:,:,235))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(53),n2h1(5))
  call Hotf_5pt_reduction(G2H3(352),RedSet_5(2),mass5set(:,3),  & 
G1H3(17),G1H3(704),G1H3(705),G1H3(706),G1H3(707),G1H3(708),3)
  call HG1shiftOLR(G1H3(704),8,3)
  call Hotf_4pt_reduction(G2H3(354),RedSet_4(4),mass4set(:,3),  & 
G1H3(709),G1H3(710),G1H3(711),G1H3(712),G1H3(713),3)
  call HG1shiftOLR(G1H3(710),12,3)
  call Hloop_AW_Q(ntryL,G1H3(26),ex4(:),G1H1(19),m3h3x1(:,86),heltab2x3(:,:,236))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(54),n2h1(6))
  call Hotf_5pt_reduction(G2H3(363),RedSet_5(3),mass5set(:,1),  & 
G1H3(26),G1H3(714),G1H3(715),G1H3(716),G1H3(717),G1H3(718),3)
  call HG1shiftOLR(G1H3(714),8,3)
  call Hotf_4pt_reduction(G2H3(365),RedSet_4(5),mass4set(:,1),  & 
G1H3(719),G1H3(720),G1H3(721),G1H3(722),G1H3(723),3)
  call HG1shiftOLR(G1H3(720),9,3)
  call Hloop_AW_Q(ntryL,G1H3(37),ex4(:),G1H1(19),m3h3x1(:,87),heltab2x3(:,:,237))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,0,G2tensor(55),n2h1(7))
  call Hotf_5pt_reduction(G2H3(368),RedSet_5(3),mass5set(:,2),  & 
G1H3(37),G1H3(724),G1H3(725),G1H3(726),G1H3(727),G1H3(728),3)
  call HG1shiftOLR(G1H3(724),8,3)
  call Hotf_4pt_reduction(G2H3(370),RedSet_4(5),mass4set(:,2),  & 
G1H3(729),G1H3(730),G1H3(731),G1H3(732),G1H3(733),3)
  call HG1shiftOLR(G1H3(730),9,3)
  call Hloop_QW_A(ntryL,G1H3(48),ex4(:),G1H1(19),m3h3x1(:,88),heltab2x3(:,:,238))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(56),n2h1(8))
  call Hotf_5pt_reduction(G2H3(373),RedSet_5(3),mass5set(:,3),  & 
G1H3(48),G1H3(734),G1H3(735),G1H3(736),G1H3(737),G1H3(738),3)
  call HG1shiftOLR(G1H3(734),8,3)
  call Hotf_4pt_reduction(G2H3(375),RedSet_4(5),mass4set(:,3),  & 
G1H3(739),G1H3(740),G1H3(741),G1H3(742),G1H3(743),3)
  call HG1shiftOLR(G1H3(740),9,3)
  call Hloop_AW_Q(ntryL,G1H3(59),ex4(:),G1H1(19),m3h3x1(:,89),heltab2x3(:,:,239))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(57),n2h1(9))
  call Hotf_5pt_reduction(G2H2(157),RedSet_5(4),mass5set(:,7),  & 
G1H2(207),G1H2(208),G1H2(209),G1H2(210),G1H2(211),G1H2(212),2)
  call HG1shiftOLR(G1H2(208),4,2)
  call Hotf_4pt_reduction(G2H2(159),RedSet_4(4),mass4set(:,2),  & 
G1H2(213),G1H2(214),G1H2(215),G1H2(216),G1H2(217),2)
  call HG1shiftOLR(G1H2(214),12,2)
  call Hloop_QV_A(ntryL,G1H2(74),ex3(:),G1H1(19),m3h2x1(:,19),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(58),n2h1(10))
  call Hotf_5pt_reduction(G2H2(162),RedSet_5(4),mass5set(:,8),  & 
G1H2(74),G1H2(218),G1H2(219),G1H2(220),G1H2(221),G1H2(222),2)
  call HG1shiftOLR(G1H2(218),4,2)
  call Hotf_4pt_reduction(G2H2(164),RedSet_4(4),mass4set(:,3),  & 
G1H2(223),G1H2(224),G1H2(225),G1H2(226),G1H2(227),2)
  call HG1shiftOLR(G1H2(224),12,2)
  call Hloop_AV_Q(ntryL,G1H2(76),ex3(:),G1H1(19),m3h2x1(:,20),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(59),n2h1(11))
  call Hotf_5pt_reduction(G2H3(390),RedSet_5(5),mass5set(:,1),  & 
G1H3(59),G1H3(744),G1H3(745),G1H3(746),G1H3(747),G1H3(748),3)
  call HG1shiftOLR(G1H3(744),8,3)
  call Hotf_4pt_reduction(G2H3(392),RedSet_4(8),mass4set(:,1),  & 
G1H3(749),G1H3(750),G1H3(751),G1H3(752),G1H3(753),3)
  call HG1shiftOLR(G1H3(750),12,3)
  call Hloop_AW_Q(ntryL,G1H3(68),ex4(:),G1H1(19),m3h3x1(:,90),heltab2x3(:,:,240))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,0,G2tensor(60),n2h1(12))
  call Hotf_5pt_reduction(G2H3(395),RedSet_5(5),mass5set(:,2),  & 
G1H3(68),G1H3(754),G1H3(755),G1H3(756),G1H3(757),G1H3(758),3)
  call HG1shiftOLR(G1H3(754),8,3)
  call Hotf_4pt_reduction(G2H3(397),RedSet_4(8),mass4set(:,2),  & 
G1H3(759),G1H3(760),G1H3(761),G1H3(762),G1H3(763),3)
  call HG1shiftOLR(G1H3(760),12,3)
  call Hloop_QW_A(ntryL,G1H3(79),ex4(:),G1H1(19),m3h3x1(:,91),heltab2x3(:,:,241))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(61),n2h1(13))
  call Hotf_5pt_reduction(G2H3(400),RedSet_5(5),mass5set(:,3),  & 
G1H3(79),G1H3(764),G1H3(765),G1H3(766),G1H3(767),G1H3(768),3)
  call HG1shiftOLR(G1H3(764),8,3)
  call Hotf_4pt_reduction(G2H3(402),RedSet_4(8),mass4set(:,3),  & 
G1H3(769),G1H3(770),G1H3(771),G1H3(772),G1H3(773),3)
  call HG1shiftOLR(G1H3(770),12,3)
  call Hloop_AW_Q(ntryL,G1H3(36),ex4(:),G1H1(19),m3h3x1(:,92),heltab2x3(:,:,242))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(62),n2h1(14))
  call Hotf_5pt_reduction(G2H2(176),RedSet_5(6),mass5set(:,7),  & 
G1H2(76),G1H2(228),G1H2(229),G1H2(230),G1H2(231),G1H2(232),2)
  call HG1shiftOLR(G1H2(228),4,2)
  call Hotf_4pt_reduction(G2H2(178),RedSet_4(8),mass4set(:,2),  & 
G1H2(233),G1H2(234),G1H2(235),G1H2(236),G1H2(237),2)
  call HG1shiftOLR(G1H2(234),12,2)
  call Hloop_QV_A(ntryL,G1H2(84),ex3(:),G1H1(19),m3h2x1(:,21),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(63),n2h1(15))
  call Hotf_5pt_reduction(G2H2(181),RedSet_5(6),mass5set(:,8),  & 
G1H2(84),G1H2(238),G1H2(239),G1H2(240),G1H2(241),G1H2(242),2)
  call HG1shiftOLR(G1H2(238),4,2)
  call Hotf_4pt_reduction(G2H2(183),RedSet_4(8),mass4set(:,3),  & 
G1H2(243),G1H2(244),G1H2(245),G1H2(246),G1H2(247),2)
  call HG1shiftOLR(G1H2(244),12,2)
  call Hloop_AV_Q(ntryL,G1H2(86),ex3(:),G1H1(19),m3h2x1(:,22),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(64),n2h1(16))
  call Hotf_5pt_reduction(G2H3(417),RedSet_5(7),mass5set(:,1),  & 
G1H3(36),G1H3(774),G1H3(775),G1H3(776),G1H3(777),G1H3(778),3)
  call HG1shiftOLR(G1H3(774),8,3)
  call Hotf_4pt_reduction(G2H3(419),RedSet_4(10),mass4set(:,1),  & 
G1H3(779),G1H3(780),G1H3(781),G1H3(782),G1H3(783),3)
  call HG1shiftOLR(G1H3(780),9,3)
  call Hloop_AW_Q(ntryL,G1H3(105),ex4(:),G1H1(19),m3h3x1(:,93),heltab2x3(:,:,243))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,0,G2tensor(65),n2h1(17))
  call Hotf_5pt_reduction(G2H3(422),RedSet_5(7),mass5set(:,2),  & 
G1H3(105),G1H3(784),G1H3(785),G1H3(786),G1H3(787),G1H3(788),3)
  call HG1shiftOLR(G1H3(784),8,3)
  call Hotf_4pt_reduction(G2H3(424),RedSet_4(10),mass4set(:,2),  & 
G1H3(789),G1H3(790),G1H3(791),G1H3(792),G1H3(793),3)
  call HG1shiftOLR(G1H3(790),9,3)
  call Hloop_QW_A(ntryL,G1H3(200),ex4(:),G1H1(19),m3h3x1(:,94),heltab2x3(:,:,244))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(66),n2h1(18))
  call Hotf_5pt_reduction(G2H3(427),RedSet_5(7),mass5set(:,3),  & 
G1H3(200),G1H3(794),G1H3(795),G1H3(796),G1H3(797),G1H3(798),3)
  call HG1shiftOLR(G1H3(794),8,3)
  call Hotf_4pt_reduction(G2H3(429),RedSet_4(10),mass4set(:,3),  & 
G1H3(799),G1H3(800),G1H3(801),G1H3(802),G1H3(803),3)
  call HG1shiftOLR(G1H3(800),9,3)
  call Hloop_AW_Q(ntryL,G1H3(13),ex4(:),G1H1(19),m3h3x1(:,95),heltab2x3(:,:,245))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(67),n2h1(19))
  call Hotf_5pt_reduction(G2H2(186),RedSet_5(8),mass5set(:,9),  & 
G1H2(86),G1H2(248),G1H2(249),G1H2(250),G1H2(251),G1H2(252),2)
  call HG1shiftOLR(G1H2(248),4,2)
  call Hotf_4pt_reduction(G2H2(188),RedSet_4(11),mass4set(:,8),  & 
G1H2(253),G1H2(254),G1H2(255),G1H2(256),G1H2(257),2)
  call HG1shiftOLR(G1H2(254),5,2)
  call Hloop_AV_Q(ntryL,G1H2(30),ex3(:),G1H1(19),m3h2x1(:,23),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(68),n2h1(20))
  call Hotf_5pt_reduction(G2H2(191),RedSet_5(8),mass5set(:,10),  & 
G1H2(30),G1H2(258),G1H2(259),G1H2(260),G1H2(261),G1H2(262),2)
  call HG1shiftOLR(G1H2(258),4,2)
  call Hotf_4pt_reduction(G2H2(193),RedSet_4(11),mass4set(:,7),  & 
G1H2(263),G1H2(264),G1H2(265),G1H2(266),G1H2(267),2)
  call HG1shiftOLR(G1H2(264),5,2)
  call Hloop_QV_A(ntryL,G1H2(19),ex3(:),G1H1(19),m3h2x1(:,24),heltab2x2(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(69),n2h1(21))
  call Hotf_5pt_reduction(G2H3(438),RedSet_5(9),mass5set(:,1),  & 
G1H3(13),G1H3(804),G1H3(805),G1H3(806),G1H3(807),G1H3(808),3)
  call HG1shiftOLR(G1H3(804),8,3)
  call Hotf_4pt_reduction(G2H3(440),RedSet_4(12),mass4set(:,1),  & 
G1H3(809),G1H3(810),G1H3(811),G1H3(812),G1H3(813),3)
  call HG1shiftOLR(G1H3(810),10,3)
  call Hloop_AW_Q(ntryL,G1H3(133),ex4(:),G1H1(19),m3h3x1(:,96),heltab2x3(:,:,246))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,0,G2tensor(70),n2h1(22))
  call Hotf_5pt_reduction(G2H3(443),RedSet_5(9),mass5set(:,2),  & 
G1H3(133),G1H3(814),G1H3(815),G1H3(816),G1H3(817),G1H3(818),3)
  call HG1shiftOLR(G1H3(814),8,3)
  call Hotf_4pt_reduction(G2H3(445),RedSet_4(12),mass4set(:,2),  & 
G1H3(819),G1H3(820),G1H3(821),G1H3(822),G1H3(823),3)
  call HG1shiftOLR(G1H3(820),10,3)
  call Hloop_QW_A(ntryL,G1H3(95),ex4(:),G1H1(19),m3h3x1(:,97),heltab2x3(:,:,247))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(71),n2h1(23))
  call Hotf_5pt_reduction(G2H3(448),RedSet_5(9),mass5set(:,3),  & 
G1H3(95),G1H3(824),G1H3(825),G1H3(826),G1H3(827),G1H3(828),3)
  call HG1shiftOLR(G1H3(824),8,3)
  call Hotf_4pt_reduction(G2H3(450),RedSet_4(12),mass4set(:,3),  & 
G1H3(829),G1H3(830),G1H3(831),G1H3(832),G1H3(833),3)
  call HG1shiftOLR(G1H3(830),10,3)
  call Hloop_AW_Q(ntryL,G1H3(102),ex4(:),G1H1(19),m3h3x1(:,98),heltab2x3(:,:,248))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(72),n2h1(24))
  call Hotf_5pt_reduction(G2H2(205),RedSet_5(10),mass5set(:,7),  & 
G1H2(19),G1H2(268),G1H2(269),G1H2(270),G1H2(271),G1H2(272),2)
  call HG1shiftOLR(G1H2(268),2,2)
  call Hotf_4pt_reduction(G2H2(207),RedSet_4(12),mass4set(:,2),  & 
G1H2(273),G1H2(274),G1H2(275),G1H2(276),G1H2(277),2)
  call HG1shiftOLR(G1H2(274),10,2)
  call Hloop_QV_A(ntryL,G1H2(34),ex2(:),G1H1(19),m3h2x1(:,25),heltab2x2(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(73),n2h1(25))
  call Hotf_5pt_reduction(G2H2(210),RedSet_5(10),mass5set(:,8),  & 
G1H2(34),G1H2(278),G1H2(279),G1H2(280),G1H2(281),G1H2(282),2)
  call HG1shiftOLR(G1H2(278),2,2)
  call Hotf_4pt_reduction(G2H2(212),RedSet_4(12),mass4set(:,3),  & 
G1H2(283),G1H2(284),G1H2(285),G1H2(286),G1H2(287),2)
  call HG1shiftOLR(G1H2(284),10,2)
  call Hloop_AV_Q(ntryL,G1H2(42),ex2(:),G1H1(19),m3h2x1(:,26),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(74),n2h1(26))
  call Hotf_5pt_reduction(G2H2(215),RedSet_5(11),mass5set(:,9),  & 
G1H2(42),G1H2(288),G1H2(289),G1H2(290),G1H2(291),G1H2(292),2)
  call HG1shiftOLR(G1H2(288),4,2)
  call Hotf_4pt_reduction(G2H2(218),RedSet_4(14),mass4set(:,8),  & 
G1H2(293),G1H2(294),G1H2(295),G1H2(296),G1H2(297),2)
  call HG1shiftOLR(G1H2(294),6,2)
  call Hloop_AV_Q(ntryL,G1H2(45),ex3(:),G1H1(19),m3h2x1(:,27),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(75),n2h1(27))
  call Hotf_5pt_reduction(G2H2(223),RedSet_5(11),mass5set(:,10),  & 
G1H2(45),G1H2(298),G1H2(299),G1H2(300),G1H2(301),G1H2(302),2)
  call HG1shiftOLR(G1H2(298),4,2)
  call Hotf_4pt_reduction(G2H2(226),RedSet_4(14),mass4set(:,7),  & 
G1H2(303),G1H2(304),G1H2(305),G1H2(306),G1H2(307),2)
  call HG1shiftOLR(G1H2(304),6,2)
  call Hloop_QV_A(ntryL,G1H2(88),ex3(:),G1H1(19),m3h2x1(:,28),heltab2x2(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(76),n2h1(28))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(235),ex3(:),G2tensor(77),m3h2x1(:,29),heltab2x2(:,:,43))
  call Hotf_5pt_reduction(G2H2(238),RedSet_5(12),mass5set(:,9),  & 
G1H2(88),G1H2(308),G1H2(309),G1H2(310),G1H2(311),G1H2(312),2)
  call HG1shiftOLR(G1H2(308),2,2)
  call Hotf_4pt_reduction(G2H2(241),RedSet_4(14),mass4set(:,8),  & 
G1H2(313),G1H2(314),G1H2(315),G1H2(316),G1H2(317),2)
  call HG1shiftOLR(G1H2(314),6,2)
  call Hloop_AV_Q(ntryL,G1H2(95),ex2(:),G1H1(19),m3h2x1(:,30),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(78),n2h1(29))
  call Hotf_5pt_reduction(G2H2(246),RedSet_5(12),mass5set(:,10),  & 
G1H2(95),G1H2(318),G1H2(319),G1H2(320),G1H2(321),G1H2(322),2)
  call HG1shiftOLR(G1H2(318),2,2)
  call Hotf_4pt_reduction(G2H2(249),RedSet_4(14),mass4set(:,7),  & 
G1H2(323),G1H2(324),G1H2(325),G1H2(326),G1H2(327),2)
  call HG1shiftOLR(G1H2(324),6,2)
  call Hloop_QV_A(ntryL,G1H2(97),ex2(:),G1H1(19),m3h2x1(:,31),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(79),n2h1(30))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(258),ex2(:),G2tensor(80),m3h2x1(:,32),heltab2x2(:,:,46))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(279),[G1H3(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(284),[G1H3(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(269),[G1H3(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(274),[G1H3(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(299),[G1H3(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(304),[G1H3(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(289),[G1H3(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(294),[G1H3(236)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(309),[G1H3(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(314),[G1H3(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(363),[G1H3(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(368),[G1H3(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(383),[G1H3(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(388),[G1H3(202)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(373),[G1H3(212)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(378),[G1H3(227)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(393),[G1H3(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(398),[G1H3(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(447),[G1H3(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(452),[G1H3(244)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(467),[G1H3(250)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(472),[G1H3(256)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(457),[G1H3(262)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(462),[G1H3(268)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(153),[G1H2(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(132),[G1H2(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(180),[G1H2(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(148),[G1H2(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(325),[G1H3(324)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(336),[G1H3(335)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(347),[G1H3(346)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(358),[G1H3(357)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(409),[G1H3(408)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(420),[G1H3(419)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(431),[G1H3(430)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(442),[G1H3(441)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(127),[G1H2(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(143),[G1H2(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(483),[G1H3(482)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(494),[G1H3(493)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(505),[G1H3(504)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(516),[G1H3(515)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(527),[G1H3(526)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(538),[G1H3(537)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(549),[G1H3(548)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(560),[G1H3(559)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(571),[G1H3(570)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(582),[G1H3(581)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(593),[G1H3(592)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(604),[G1H3(603)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(615),[G1H3(614)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(626),[G1H3(625)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(637),[G1H3(636)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(648),[G1H3(647)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(164),[G1H2(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(175),[G1H2(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(191),[G1H2(190)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(202),[G1H2(201)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(659),[G1H3(658)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(669),[G1H3(668)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(679),[G1H3(678)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(689),[G1H3(688)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(699),[G1H3(698)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(709),[G1H3(708)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(719),[G1H3(718)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(729),[G1H3(728)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(739),[G1H3(738)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(213),[G1H2(212)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(223),[G1H2(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(749),[G1H3(748)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(759),[G1H3(758)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(769),[G1H3(768)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(233),[G1H2(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(243),[G1H2(242)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(779),[G1H3(778)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(789),[G1H3(788)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(799),[G1H3(798)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(253),[G1H2(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(263),[G1H2(262)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(809),[G1H3(808)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(819),[G1H3(818)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(829),[G1H3(828)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(273),[G1H2(272)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(283),[G1H2(282)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(293),[G1H2(292)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(303),[G1H2(302)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(313),[G1H2(312)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(323),[G1H2(322)])
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(107),23,ex4(:),8,G2tensor(81),m3h3x1(:,99),heltab2x3(:,:,249))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(153),0,ex4(:),8,G2tensor(82),m3h3x1(:,100),heltab2x3(:,:,250))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(279),23,ex4(:),8,G2tensor(83),m3h3x1(:,101),heltab2x3(:,:,251))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(43),23,ex4(:),8,G2tensor(84),m3h3x1(:,102),heltab2x3(:,:,252))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(113),0,ex4(:),8,G2tensor(85),m3h3x1(:,103),heltab2x3(:,:,253))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(284),23,ex4(:),8,G2tensor(86),m3h3x1(:,104),heltab2x3(:,:,254))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(118),23,ex4(:),8,G2tensor(87),m3h3x1(:,105),heltab2x3(:,:,255))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(123),0,ex4(:),8,G2tensor(88),m3h3x1(:,106),heltab2x3(:,:,256))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(269),23,ex4(:),8,G2tensor(89),m3h3x1(:,107),heltab2x3(:,:,257))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(127),23,ex4(:),8,G2tensor(90),m3h3x1(:,108),heltab2x3(:,:,258))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(54),0,ex4(:),8,G2tensor(91),m3h3x1(:,109),heltab2x3(:,:,259))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(274),23,ex4(:),8,G2tensor(92),m3h3x1(:,110),heltab2x3(:,:,260))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(137),23,ex4(:),8,G2tensor(93),m3h3x1(:,111),heltab2x3(:,:,261))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(139),0,ex4(:),8,G2tensor(94),m3h3x1(:,112),heltab2x3(:,:,262))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(299),23,ex4(:),8,G2tensor(95),m3h3x1(:,113),heltab2x3(:,:,263))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(152),23,ex4(:),8,G2tensor(96),m3h3x1(:,114),heltab2x3(:,:,264))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(154),0,ex4(:),8,G2tensor(97),m3h3x1(:,115),heltab2x3(:,:,265))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(304),23,ex4(:),8,G2tensor(98),m3h3x1(:,116),heltab2x3(:,:,266))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(61),23,ex4(:),8,G2tensor(99),m3h3x1(:,117),heltab2x3(:,:,267))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(62),0,ex4(:),8,G2tensor(100),m3h3x1(:,118),heltab2x3(:,:,268))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(289),23,ex4(:),8,G2tensor(101),m3h3x1(:,119),heltab2x3(:,:,269))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(73),23,ex4(:),8,G2tensor(102),m3h3x1(:,120),heltab2x3(:,:,270))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(74),0,ex4(:),8,G2tensor(103),m3h3x1(:,121),heltab2x3(:,:,271))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(294),23,ex4(:),8,G2tensor(104),m3h3x1(:,122),heltab2x3(:,:,272))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(29),23,ex4(:),8,G2tensor(105),m3h3x1(:,123),heltab2x3(:,:,273))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(35),0,ex4(:),8,G2tensor(106),m3h3x1(:,124),heltab2x3(:,:,274))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(309),23,ex4(:),8,G2tensor(107),m3h3x1(:,125),heltab2x3(:,:,275))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(72),23,ex4(:),8,G2tensor(108),m3h3x1(:,126),heltab2x3(:,:,276))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(174),0,ex4(:),8,G2tensor(109),m3h3x1(:,127),heltab2x3(:,:,277))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(314),23,ex4(:),8,G2tensor(110),m3h3x1(:,128),heltab2x3(:,:,278))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(175),23,ex4(:),8,G2tensor(111),m3h3x1(:,129),heltab2x3(:,:,279))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(178),0,ex4(:),8,G2tensor(112),m3h3x1(:,130),heltab2x3(:,:,280))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(363),23,ex4(:),8,G2tensor(113),m3h3x1(:,131),heltab2x3(:,:,281))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(185),23,ex4(:),8,G2tensor(114),m3h3x1(:,132),heltab2x3(:,:,282))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(121),0,ex4(:),8,G2tensor(115),m3h3x1(:,133),heltab2x3(:,:,283))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(368),23,ex4(:),8,G2tensor(116),m3h3x1(:,134),heltab2x3(:,:,284))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(168),23,ex4(:),8,G2tensor(117),m3h3x1(:,135),heltab2x3(:,:,285))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(191),0,ex4(:),8,G2tensor(118),m3h3x1(:,136),heltab2x3(:,:,286))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(383),23,ex4(:),8,G2tensor(119),m3h3x1(:,137),heltab2x3(:,:,287))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(196),23,ex4(:),8,G2tensor(120),m3h3x1(:,138),heltab2x3(:,:,288))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(201),0,ex4(:),8,G2tensor(121),m3h3x1(:,139),heltab2x3(:,:,289))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(388),23,ex4(:),8,G2tensor(122),m3h3x1(:,140),heltab2x3(:,:,290))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(205),23,ex4(:),8,G2tensor(123),m3h3x1(:,141),heltab2x3(:,:,291))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(7),0,ex4(:),8,G2tensor(124),m3h3x1(:,142),heltab2x3(:,:,292))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(373),23,ex4(:),8,G2tensor(125),m3h3x1(:,143),heltab2x3(:,:,293))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(215),23,ex4(:),8,G2tensor(126),m3h3x1(:,144),heltab2x3(:,:,294))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(217),0,ex4(:),8,G2tensor(127),m3h3x1(:,145),heltab2x3(:,:,295))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(378),23,ex4(:),8,G2tensor(128),m3h3x1(:,146),heltab2x3(:,:,296))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(230),23,ex4(:),8,G2tensor(129),m3h3x1(:,147),heltab2x3(:,:,297))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(232),0,ex4(:),8,G2tensor(130),m3h3x1(:,148),heltab2x3(:,:,298))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(393),23,ex4(:),8,G2tensor(131),m3h3x1(:,149),heltab2x3(:,:,299))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(19),23,ex4(:),8,G2tensor(132),m3h3x1(:,150),heltab2x3(:,:,300))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(20),0,ex4(:),8,G2tensor(133),m3h3x1(:,151),heltab2x3(:,:,301))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(398),23,ex4(:),8,G2tensor(134),m3h3x1(:,152),heltab2x3(:,:,302))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(138),23,ex4(:),8,G2tensor(135),m3h3x1(:,153),heltab2x3(:,:,303))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(96),0,ex4(:),8,G2tensor(136),m3h3x1(:,154),heltab2x3(:,:,304))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(447),23,ex4(:),8,G2tensor(137),m3h3x1(:,155),heltab2x3(:,:,305))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(148),23,ex4(:),8,G2tensor(138),m3h3x1(:,156),heltab2x3(:,:,306))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(38),0,ex4(:),8,G2tensor(139),m3h3x1(:,157),heltab2x3(:,:,307))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(452),23,ex4(:),8,G2tensor(140),m3h3x1(:,158),heltab2x3(:,:,308))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(245),23,ex4(:),8,G2tensor(141),m3h3x1(:,159),heltab2x3(:,:,309))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(246),0,ex4(:),8,G2tensor(142),m3h3x1(:,160),heltab2x3(:,:,310))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(467),23,ex4(:),8,G2tensor(143),m3h3x1(:,161),heltab2x3(:,:,311))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(251),23,ex4(:),8,G2tensor(144),m3h3x1(:,162),heltab2x3(:,:,312))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(252),0,ex4(:),8,G2tensor(145),m3h3x1(:,163),heltab2x3(:,:,313))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(472),23,ex4(:),8,G2tensor(146),m3h3x1(:,164),heltab2x3(:,:,314))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(257),23,ex4(:),8,G2tensor(147),m3h3x1(:,165),heltab2x3(:,:,315))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(258),0,ex4(:),8,G2tensor(148),m3h3x1(:,166),heltab2x3(:,:,316))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(457),23,ex4(:),8,G2tensor(149),m3h3x1(:,167),heltab2x3(:,:,317))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(263),23,ex4(:),8,G2tensor(150),m3h3x1(:,168),heltab2x3(:,:,318))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(264),0,ex4(:),8,G2tensor(151),m3h3x1(:,169),heltab2x3(:,:,319))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(462),23,ex4(:),8,G2tensor(152),m3h3x1(:,170),heltab2x3(:,:,320))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(13),27,ex3(:),4,G2tensor(153),m3h2x1(:,33),heltab2x2(:,:,47))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(14),0,ex3(:),4,G2tensor(154),m3h2x1(:,34),heltab2x2(:,:,48))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(153),27,ex3(:),4,G2tensor(155),m3h2x1(:,35),heltab2x2(:,:,49))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(15),27,ex3(:),4,G2tensor(156),m3h2x1(:,36),heltab2x2(:,:,50))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(105),0,ex3(:),4,G2tensor(157),m3h2x1(:,37),heltab2x2(:,:,51))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(132),27,ex3(:),4,G2tensor(158),m3h2x1(:,38),heltab2x2(:,:,52))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(110),29,ex2(:),2,G2tensor(159),m3h2x1(:,39),heltab2x2(:,:,53))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(111),0,ex2(:),2,G2tensor(160),m3h2x1(:,40),heltab2x2(:,:,54))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(180),29,ex2(:),2,G2tensor(161),m3h2x1(:,41),heltab2x2(:,:,55))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(18),29,ex2(:),2,G2tensor(162),m3h2x1(:,42),heltab2x2(:,:,56))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(116),0,ex2(:),2,G2tensor(163),m3h2x1(:,43),heltab2x2(:,:,57))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(148),29,ex2(:),2,G2tensor(164),m3h2x1(:,44),heltab2x2(:,:,58))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(270),2,ex4(:),8,G2tensor(165),m3h3x1(:,171),heltab2x3(:,:,321))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(275),2,ex4(:),8,G2tensor(166),m3h3x1(:,172),heltab2x3(:,:,322))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(280),2,ex4(:),8,G2tensor(167),m3h3x1(:,173),heltab2x3(:,:,323))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(285),2,ex4(:),8,G2tensor(168),m3h3x1(:,174),heltab2x3(:,:,324))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(290),4,ex4(:),8,G2tensor(169),m3h3x1(:,175),heltab2x3(:,:,325))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(295),4,ex4(:),8,G2tensor(170),m3h3x1(:,176),heltab2x3(:,:,326))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(300),4,ex4(:),8,G2tensor(171),m3h3x1(:,177),heltab2x3(:,:,327))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(305),4,ex4(:),8,G2tensor(172),m3h3x1(:,178),heltab2x3(:,:,328))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(310),1,ex4(:),8,G2tensor(173),m3h3x1(:,179),heltab2x3(:,:,329))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(315),1,ex4(:),8,G2tensor(174),m3h3x1(:,180),heltab2x3(:,:,330))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(319),23,ex4(:),G2tensor(175),m3h3x1(:,181),heltab2x3(:,:,331))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(320),0,ex4(:),G2tensor(176),m3h3x1(:,182),heltab2x3(:,:,332))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(325),23,ex4(:),G2tensor(177),m3h3x1(:,183),heltab2x3(:,:,333))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(326),1,ex4(:),G2tensor(178),m3h3x1(:,184),heltab2x3(:,:,334))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(330),23,ex4(:),G2tensor(179),m3h3x1(:,185),heltab2x3(:,:,335))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(331),0,ex4(:),G2tensor(180),m3h3x1(:,186),heltab2x3(:,:,336))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(336),23,ex4(:),G2tensor(181),m3h3x1(:,187),heltab2x3(:,:,337))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(337),1,ex4(:),G2tensor(182),m3h3x1(:,188),heltab2x3(:,:,338))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(341),23,ex4(:),8,G2tensor(183),m3h3x1(:,189),heltab2x3(:,:,339))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(342),0,ex4(:),8,G2tensor(184),m3h3x1(:,190),heltab2x3(:,:,340))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(347),23,ex4(:),8,G2tensor(185),m3h3x1(:,191),heltab2x3(:,:,341))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(348),1,ex4(:),8,G2tensor(186),m3h3x1(:,192),heltab2x3(:,:,342))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(352),23,ex4(:),8,G2tensor(187),m3h3x1(:,193),heltab2x3(:,:,343))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(353),0,ex4(:),8,G2tensor(188),m3h3x1(:,194),heltab2x3(:,:,344))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(358),23,ex4(:),8,G2tensor(189),m3h3x1(:,195),heltab2x3(:,:,345))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(359),1,ex4(:),8,G2tensor(190),m3h3x1(:,196),heltab2x3(:,:,346))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(364),1,ex4(:),8,G2tensor(191),m3h3x1(:,197),heltab2x3(:,:,347))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(369),1,ex4(:),8,G2tensor(192),m3h3x1(:,198),heltab2x3(:,:,348))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(374),4,ex4(:),8,G2tensor(193),m3h3x1(:,199),heltab2x3(:,:,349))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(379),4,ex4(:),8,G2tensor(194),m3h3x1(:,200),heltab2x3(:,:,350))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(384),4,ex4(:),8,G2tensor(195),m3h3x1(:,201),heltab2x3(:,:,351))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(389),4,ex4(:),8,G2tensor(196),m3h3x1(:,202),heltab2x3(:,:,352))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(394),1,ex4(:),8,G2tensor(197),m3h3x1(:,203),heltab2x3(:,:,353))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(399),1,ex4(:),8,G2tensor(198),m3h3x1(:,204),heltab2x3(:,:,354))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(403),23,ex4(:),G2tensor(199),m3h3x1(:,205),heltab2x3(:,:,355))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(404),0,ex4(:),G2tensor(200),m3h3x1(:,206),heltab2x3(:,:,356))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(409),23,ex4(:),G2tensor(201),m3h3x1(:,207),heltab2x3(:,:,357))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(410),1,ex4(:),G2tensor(202),m3h3x1(:,208),heltab2x3(:,:,358))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(414),23,ex4(:),G2tensor(203),m3h3x1(:,209),heltab2x3(:,:,359))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(415),0,ex4(:),G2tensor(204),m3h3x1(:,210),heltab2x3(:,:,360))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(420),23,ex4(:),G2tensor(205),m3h3x1(:,211),heltab2x3(:,:,361))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(421),1,ex4(:),G2tensor(206),m3h3x1(:,212),heltab2x3(:,:,362))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(425),23,ex4(:),8,G2tensor(207),m3h3x1(:,213),heltab2x3(:,:,363))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(426),0,ex4(:),8,G2tensor(208),m3h3x1(:,214),heltab2x3(:,:,364))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(431),23,ex4(:),8,G2tensor(209),m3h3x1(:,215),heltab2x3(:,:,365))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(432),1,ex4(:),8,G2tensor(210),m3h3x1(:,216),heltab2x3(:,:,366))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(436),23,ex4(:),8,G2tensor(211),m3h3x1(:,217),heltab2x3(:,:,367))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(437),0,ex4(:),8,G2tensor(212),m3h3x1(:,218),heltab2x3(:,:,368))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(442),23,ex4(:),8,G2tensor(213),m3h3x1(:,219),heltab2x3(:,:,369))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(443),1,ex4(:),8,G2tensor(214),m3h3x1(:,220),heltab2x3(:,:,370))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(448),1,ex4(:),8,G2tensor(215),m3h3x1(:,221),heltab2x3(:,:,371))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(453),1,ex4(:),8,G2tensor(216),m3h3x1(:,222),heltab2x3(:,:,372))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(458),2,ex4(:),8,G2tensor(217),m3h3x1(:,223),heltab2x3(:,:,373))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(463),2,ex4(:),8,G2tensor(218),m3h3x1(:,224),heltab2x3(:,:,374))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(468),2,ex4(:),8,G2tensor(219),m3h3x1(:,225),heltab2x3(:,:,375))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(473),2,ex4(:),8,G2tensor(220),m3h3x1(:,226),heltab2x3(:,:,376))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(121),27,ex3(:),4,G2tensor(221),m3h2x1(:,45),heltab2x2(:,:,59))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(122),0,ex3(:),4,G2tensor(222),m3h2x1(:,46),heltab2x2(:,:,60))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(127),27,ex3(:),4,G2tensor(223),m3h2x1(:,47),heltab2x2(:,:,61))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(128),2,ex3(:),4,G2tensor(224),m3h2x1(:,48),heltab2x2(:,:,62))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(133),2,ex3(:),4,G2tensor(225),m3h2x1(:,49),heltab2x2(:,:,63))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(137),29,ex2(:),2,G2tensor(226),m3h2x1(:,50),heltab2x2(:,:,64))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(138),0,ex2(:),2,G2tensor(227),m3h2x1(:,51),heltab2x2(:,:,65))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(143),29,ex2(:),2,G2tensor(228),m3h2x1(:,52),heltab2x2(:,:,66))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(144),4,ex2(:),2,G2tensor(229),m3h2x1(:,53),heltab2x2(:,:,67))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(149),4,ex2(:),2,G2tensor(230),m3h2x1(:,54),heltab2x2(:,:,68))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(477),23,ex4(:),G2tensor(231),m3h3x1(:,227),heltab2x3(:,:,377))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(478),0,ex4(:),G2tensor(232),m3h3x1(:,228),heltab2x3(:,:,378))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(483),23,ex4(:),G2tensor(233),m3h3x1(:,229),heltab2x3(:,:,379))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(484),2,ex4(:),G2tensor(234),m3h3x1(:,230),heltab2x3(:,:,380))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(488),23,ex4(:),G2tensor(235),m3h3x1(:,231),heltab2x3(:,:,381))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(489),0,ex4(:),G2tensor(236),m3h3x1(:,232),heltab2x3(:,:,382))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(494),23,ex4(:),G2tensor(237),m3h3x1(:,233),heltab2x3(:,:,383))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(495),2,ex4(:),G2tensor(238),m3h3x1(:,234),heltab2x3(:,:,384))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(499),23,ex4(:),8,G2tensor(239),m3h3x1(:,235),heltab2x3(:,:,385))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(500),0,ex4(:),8,G2tensor(240),m3h3x1(:,236),heltab2x3(:,:,386))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(505),23,ex4(:),8,G2tensor(241),m3h3x1(:,237),heltab2x3(:,:,387))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(506),2,ex4(:),8,G2tensor(242),m3h3x1(:,238),heltab2x3(:,:,388))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(510),23,ex4(:),8,G2tensor(243),m3h3x1(:,239),heltab2x3(:,:,389))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(511),0,ex4(:),8,G2tensor(244),m3h3x1(:,240),heltab2x3(:,:,390))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(516),23,ex4(:),8,G2tensor(245),m3h3x1(:,241),heltab2x3(:,:,391))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(517),2,ex4(:),8,G2tensor(246),m3h3x1(:,242),heltab2x3(:,:,392))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(521),23,ex4(:),G2tensor(247),m3h3x1(:,243),heltab2x3(:,:,393))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(522),0,ex4(:),G2tensor(248),m3h3x1(:,244),heltab2x3(:,:,394))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(527),23,ex4(:),G2tensor(249),m3h3x1(:,245),heltab2x3(:,:,395))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(528),4,ex4(:),G2tensor(250),m3h3x1(:,246),heltab2x3(:,:,396))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(532),23,ex4(:),G2tensor(251),m3h3x1(:,247),heltab2x3(:,:,397))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(533),0,ex4(:),G2tensor(252),m3h3x1(:,248),heltab2x3(:,:,398))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(538),23,ex4(:),G2tensor(253),m3h3x1(:,249),heltab2x3(:,:,399))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(539),4,ex4(:),G2tensor(254),m3h3x1(:,250),heltab2x3(:,:,400))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(543),23,ex4(:),8,G2tensor(255),m3h3x1(:,251),heltab2x3(:,:,401))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(544),0,ex4(:),8,G2tensor(256),m3h3x1(:,252),heltab2x3(:,:,402))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(549),23,ex4(:),8,G2tensor(257),m3h3x1(:,253),heltab2x3(:,:,403))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(550),4,ex4(:),8,G2tensor(258),m3h3x1(:,254),heltab2x3(:,:,404))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(554),23,ex4(:),8,G2tensor(259),m3h3x1(:,255),heltab2x3(:,:,405))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(555),0,ex4(:),8,G2tensor(260),m3h3x1(:,256),heltab2x3(:,:,406))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(560),23,ex4(:),8,G2tensor(261),m3h3x1(:,257),heltab2x3(:,:,407))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(561),4,ex4(:),8,G2tensor(262),m3h3x1(:,258),heltab2x3(:,:,408))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(565),23,ex4(:),G2tensor(263),m3h3x1(:,259),heltab2x3(:,:,409))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(566),0,ex4(:),G2tensor(264),m3h3x1(:,260),heltab2x3(:,:,410))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(571),23,ex4(:),G2tensor(265),m3h3x1(:,261),heltab2x3(:,:,411))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(572),4,ex4(:),G2tensor(266),m3h3x1(:,262),heltab2x3(:,:,412))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(576),23,ex4(:),G2tensor(267),m3h3x1(:,263),heltab2x3(:,:,413))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(577),0,ex4(:),G2tensor(268),m3h3x1(:,264),heltab2x3(:,:,414))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(582),23,ex4(:),G2tensor(269),m3h3x1(:,265),heltab2x3(:,:,415))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(583),4,ex4(:),G2tensor(270),m3h3x1(:,266),heltab2x3(:,:,416))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(587),23,ex4(:),8,G2tensor(271),m3h3x1(:,267),heltab2x3(:,:,417))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(588),0,ex4(:),8,G2tensor(272),m3h3x1(:,268),heltab2x3(:,:,418))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(593),23,ex4(:),8,G2tensor(273),m3h3x1(:,269),heltab2x3(:,:,419))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(594),4,ex4(:),8,G2tensor(274),m3h3x1(:,270),heltab2x3(:,:,420))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(598),23,ex4(:),8,G2tensor(275),m3h3x1(:,271),heltab2x3(:,:,421))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(599),0,ex4(:),8,G2tensor(276),m3h3x1(:,272),heltab2x3(:,:,422))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(604),23,ex4(:),8,G2tensor(277),m3h3x1(:,273),heltab2x3(:,:,423))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(605),4,ex4(:),8,G2tensor(278),m3h3x1(:,274),heltab2x3(:,:,424))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(609),23,ex4(:),G2tensor(279),m3h3x1(:,275),heltab2x3(:,:,425))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(610),0,ex4(:),G2tensor(280),m3h3x1(:,276),heltab2x3(:,:,426))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(615),23,ex4(:),G2tensor(281),m3h3x1(:,277),heltab2x3(:,:,427))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(616),2,ex4(:),G2tensor(282),m3h3x1(:,278),heltab2x3(:,:,428))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(620),23,ex4(:),G2tensor(283),m3h3x1(:,279),heltab2x3(:,:,429))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(621),0,ex4(:),G2tensor(284),m3h3x1(:,280),heltab2x3(:,:,430))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(626),23,ex4(:),G2tensor(285),m3h3x1(:,281),heltab2x3(:,:,431))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(627),2,ex4(:),G2tensor(286),m3h3x1(:,282),heltab2x3(:,:,432))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(631),23,ex4(:),8,G2tensor(287),m3h3x1(:,283),heltab2x3(:,:,433))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(632),0,ex4(:),8,G2tensor(288),m3h3x1(:,284),heltab2x3(:,:,434))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(637),23,ex4(:),8,G2tensor(289),m3h3x1(:,285),heltab2x3(:,:,435))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(638),2,ex4(:),8,G2tensor(290),m3h3x1(:,286),heltab2x3(:,:,436))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(642),23,ex4(:),8,G2tensor(291),m3h3x1(:,287),heltab2x3(:,:,437))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(643),0,ex4(:),8,G2tensor(292),m3h3x1(:,288),heltab2x3(:,:,438))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(648),23,ex4(:),8,G2tensor(293),m3h3x1(:,289),heltab2x3(:,:,439))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(649),2,ex4(:),8,G2tensor(294),m3h3x1(:,290),heltab2x3(:,:,440))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(154),2,ex3(:),4,G2tensor(295),m3h2x1(:,55),heltab2x2(:,:,69))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(158),27,ex3(:),4,G2tensor(296),m3h2x1(:,56),heltab2x2(:,:,70))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(159),0,ex3(:),4,G2tensor(297),m3h2x1(:,57),heltab2x2(:,:,71))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(164),27,ex3(:),4,G2tensor(298),m3h2x1(:,58),heltab2x2(:,:,72))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(165),2,ex3(:),4,G2tensor(299),m3h2x1(:,59),heltab2x2(:,:,73))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(169),27,ex3(:),G2tensor(300),m3h2x1(:,60),heltab2x2(:,:,74))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(170),0,ex3(:),G2tensor(301),m3h2x1(:,61),heltab2x2(:,:,75))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(175),27,ex3(:),G2tensor(302),m3h2x1(:,62),heltab2x2(:,:,76))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(176),2,ex3(:),G2tensor(303),m3h2x1(:,63),heltab2x2(:,:,77))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(181),4,ex2(:),2,G2tensor(304),m3h2x1(:,64),heltab2x2(:,:,78))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(185),29,ex2(:),2,G2tensor(305),m3h2x1(:,65),heltab2x2(:,:,79))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(186),0,ex2(:),2,G2tensor(306),m3h2x1(:,66),heltab2x2(:,:,80))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(191),29,ex2(:),2,G2tensor(307),m3h2x1(:,67),heltab2x2(:,:,81))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H2(192),4,ex2(:),2,G2tensor(308),m3h2x1(:,68),heltab2x2(:,:,82))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(196),29,ex2(:),G2tensor(309),m3h2x1(:,69),heltab2x2(:,:,83))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(197),0,ex2(:),G2tensor(310),m3h2x1(:,70),heltab2x2(:,:,84))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(202),29,ex2(:),G2tensor(311),m3h2x1(:,71),heltab2x2(:,:,85))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H2(203),4,ex2(:),G2tensor(312),m3h2x1(:,72),heltab2x2(:,:,86))
  call Hloop_AW_Q(ntryL,G1H3(653),ex4(:),G1H1(19),m3h3x1(:,291),heltab2x3(:,:,441))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,0,G2tensor(313),n2h1(147))
  call Hloop_AW_Q(ntryL,G1H3(654),ex4(:),G1H1(19),m3h3x1(:,292),heltab2x3(:,:,442))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),8,0,G2tensor(314),n2h1(148))
  call Hloop_AW_Q(ntryL,G1H3(659),ex4(:),G1H1(19),m3h3x1(:,293),heltab2x3(:,:,443))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,0,G2tensor(315),n2h1(149))
  call Hloop_AW_Q(ntryL,G1H3(660),ex4(:),G1H1(19),m3h3x1(:,294),heltab2x3(:,:,444))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),10,0,G2tensor(316),n2h1(150))
  call Hloop_QW_A(ntryL,G1H3(71),ex4(:),G1H1(19),m3h3x1(:,295),heltab2x3(:,:,445))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(317),n2h1(151))
  call Hloop_QW_A(ntryL,G1H3(664),ex4(:),G1H1(19),m3h3x1(:,296),heltab2x3(:,:,446))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),8,nMB,G2tensor(318),n2h1(152))
  call Hloop_QW_A(ntryL,G1H3(669),ex4(:),G1H1(19),m3h3x1(:,297),heltab2x3(:,:,447))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(319),n2h1(153))
  call Hloop_QW_A(ntryL,G1H3(670),ex4(:),G1H1(19),m3h3x1(:,298),heltab2x3(:,:,448))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),10,nMB,G2tensor(320),n2h1(154))
  call Hloop_AW_Q(ntryL,G1H3(90),ex4(:),G1H1(19),m3h3x1(:,299),heltab2x3(:,:,449))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(321),n2h1(155))
  call Hloop_AW_Q(ntryL,G1H3(674),ex4(:),G1H1(19),m3h3x1(:,300),heltab2x3(:,:,450))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),8,nMT,G2tensor(322),n2h1(156))
  call Hloop_AW_Q(ntryL,G1H3(679),ex4(:),G1H1(19),m3h3x1(:,301),heltab2x3(:,:,451))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(323),n2h1(157))
  call Hloop_AW_Q(ntryL,G1H3(680),ex4(:),G1H1(19),m3h3x1(:,302),heltab2x3(:,:,452))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),10,nMT,G2tensor(324),n2h1(158))
  call Hloop_AW_Q(ntryL,G1H3(183),ex4(:),G1H1(19),m3h3x1(:,303),heltab2x3(:,:,453))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,0,G2tensor(325),n2h1(159))
  call Hloop_AW_Q(ntryL,G1H3(684),ex4(:),G1H1(19),m3h3x1(:,304),heltab2x3(:,:,454))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),8,0,G2tensor(326),n2h1(160))
  call Hloop_AW_Q(ntryL,G1H3(689),ex4(:),G1H1(19),m3h3x1(:,305),heltab2x3(:,:,455))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,0,G2tensor(327),n2h1(161))
  call Hloop_AW_Q(ntryL,G1H3(690),ex4(:),G1H1(19),m3h3x1(:,306),heltab2x3(:,:,456))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),12,0,G2tensor(328),n2h1(162))
  call Hloop_QW_A(ntryL,G1H3(5),ex4(:),G1H1(19),m3h3x1(:,307),heltab2x3(:,:,457))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(329),n2h1(163))
  call Hloop_QW_A(ntryL,G1H3(694),ex4(:),G1H1(19),m3h3x1(:,308),heltab2x3(:,:,458))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),8,nMB,G2tensor(330),n2h1(164))
  call Hloop_QW_A(ntryL,G1H3(699),ex4(:),G1H1(19),m3h3x1(:,309),heltab2x3(:,:,459))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(331),n2h1(165))
  call Hloop_QW_A(ntryL,G1H3(700),ex4(:),G1H1(19),m3h3x1(:,310),heltab2x3(:,:,460))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),12,nMB,G2tensor(332),n2h1(166))
  call Hloop_AW_Q(ntryL,G1H3(17),ex4(:),G1H1(19),m3h3x1(:,311),heltab2x3(:,:,461))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(333),n2h1(167))
  call Hloop_AW_Q(ntryL,G1H3(704),ex4(:),G1H1(19),m3h3x1(:,312),heltab2x3(:,:,462))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),8,nMT,G2tensor(334),n2h1(168))
  call Hloop_AW_Q(ntryL,G1H3(709),ex4(:),G1H1(19),m3h3x1(:,313),heltab2x3(:,:,463))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(335),n2h1(169))
  call Hloop_AW_Q(ntryL,G1H3(710),ex4(:),G1H1(19),m3h3x1(:,314),heltab2x3(:,:,464))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),12,nMT,G2tensor(336),n2h1(170))
  call Hloop_AW_Q(ntryL,G1H3(26),ex4(:),G1H1(19),m3h3x1(:,315),heltab2x3(:,:,465))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,0,G2tensor(337),n2h1(171))
  call Hloop_AW_Q(ntryL,G1H3(714),ex4(:),G1H1(19),m3h3x1(:,316),heltab2x3(:,:,466))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),8,0,G2tensor(338),n2h1(172))
  call Hloop_AW_Q(ntryL,G1H3(719),ex4(:),G1H1(19),m3h3x1(:,317),heltab2x3(:,:,467))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,0,G2tensor(339),n2h1(173))
  call Hloop_AW_Q(ntryL,G1H3(720),ex4(:),G1H1(19),m3h3x1(:,318),heltab2x3(:,:,468))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),9,0,G2tensor(340),n2h1(174))
  call Hloop_QW_A(ntryL,G1H3(37),ex4(:),G1H1(19),m3h3x1(:,319),heltab2x3(:,:,469))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(341),n2h1(175))
  call Hloop_QW_A(ntryL,G1H3(724),ex4(:),G1H1(19),m3h3x1(:,320),heltab2x3(:,:,470))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),8,nMB,G2tensor(342),n2h1(176))
  call Hloop_QW_A(ntryL,G1H3(729),ex4(:),G1H1(19),m3h3x1(:,321),heltab2x3(:,:,471))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(343),n2h1(177))
  call Hloop_QW_A(ntryL,G1H3(730),ex4(:),G1H1(19),m3h3x1(:,322),heltab2x3(:,:,472))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),9,nMB,G2tensor(344),n2h1(178))
  call Hloop_AW_Q(ntryL,G1H3(48),ex4(:),G1H1(19),m3h3x1(:,323),heltab2x3(:,:,473))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(345),n2h1(179))
  call Hloop_AW_Q(ntryL,G1H3(734),ex4(:),G1H1(19),m3h3x1(:,324),heltab2x3(:,:,474))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),8,nMT,G2tensor(346),n2h1(180))
  call Hloop_AW_Q(ntryL,G1H3(739),ex4(:),G1H1(19),m3h3x1(:,325),heltab2x3(:,:,475))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(347),n2h1(181))
  call Hloop_AW_Q(ntryL,G1H3(740),ex4(:),G1H1(19),m3h3x1(:,326),heltab2x3(:,:,476))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),9,nMT,G2tensor(348),n2h1(182))
  call Hloop_QV_A(ntryL,G1H2(207),ex3(:),G1H1(19),m3h2x1(:,73),heltab2x2(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(349),n2h1(183))
  call Hloop_QV_A(ntryL,G1H2(208),ex3(:),G1H1(19),m3h2x1(:,74),heltab2x2(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),4,nMB,G2tensor(350),n2h1(184))
  call Hloop_QV_A(ntryL,G1H2(213),ex3(:),G1H1(19),m3h2x1(:,75),heltab2x2(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(351),n2h1(185))
  call Hloop_QV_A(ntryL,G1H2(214),ex3(:),G1H1(19),m3h2x1(:,76),heltab2x2(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),12,nMB,G2tensor(352),n2h1(186))
  call Hloop_AV_Q(ntryL,G1H2(74),ex3(:),G1H1(19),m3h2x1(:,77),heltab2x2(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(353),n2h1(187))
  call Hloop_AV_Q(ntryL,G1H2(218),ex3(:),G1H1(19),m3h2x1(:,78),heltab2x2(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),4,nMT,G2tensor(354),n2h1(188))
  call Hloop_AV_Q(ntryL,G1H2(223),ex3(:),G1H1(19),m3h2x1(:,79),heltab2x2(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(355),n2h1(189))
  call Hloop_AV_Q(ntryL,G1H2(224),ex3(:),G1H1(19),m3h2x1(:,80),heltab2x2(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),12,nMT,G2tensor(356),n2h1(190))
  call Hloop_AW_Q(ntryL,G1H3(59),ex4(:),G1H1(19),m3h3x1(:,327),heltab2x3(:,:,477))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,0,G2tensor(357),n2h1(191))
  call Hloop_AW_Q(ntryL,G1H3(744),ex4(:),G1H1(19),m3h3x1(:,328),heltab2x3(:,:,478))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),8,0,G2tensor(358),n2h1(192))
  call Hloop_AW_Q(ntryL,G1H3(749),ex4(:),G1H1(19),m3h3x1(:,329),heltab2x3(:,:,479))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,0,G2tensor(359),n2h1(193))
  call Hloop_AW_Q(ntryL,G1H3(750),ex4(:),G1H1(19),m3h3x1(:,330),heltab2x3(:,:,480))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),12,0,G2tensor(360),n2h1(194))
  call Hloop_QW_A(ntryL,G1H3(68),ex4(:),G1H1(19),m3h3x1(:,331),heltab2x3(:,:,481))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(361),n2h1(195))
  call Hloop_QW_A(ntryL,G1H3(754),ex4(:),G1H1(19),m3h3x1(:,332),heltab2x3(:,:,482))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),8,nMB,G2tensor(362),n2h1(196))
  call Hloop_QW_A(ntryL,G1H3(759),ex4(:),G1H1(19),m3h3x1(:,333),heltab2x3(:,:,483))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(363),n2h1(197))
  call Hloop_QW_A(ntryL,G1H3(760),ex4(:),G1H1(19),m3h3x1(:,334),heltab2x3(:,:,484))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),12,nMB,G2tensor(364),n2h1(198))
  call Hloop_AW_Q(ntryL,G1H3(79),ex4(:),G1H1(19),m3h3x1(:,335),heltab2x3(:,:,485))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(365),n2h1(199))
  call Hloop_AW_Q(ntryL,G1H3(764),ex4(:),G1H1(19),m3h3x1(:,336),heltab2x3(:,:,486))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),8,nMT,G2tensor(366),n2h1(200))
  call Hloop_AW_Q(ntryL,G1H3(769),ex4(:),G1H1(19),m3h3x1(:,337),heltab2x3(:,:,487))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(367),n2h1(201))
  call Hloop_AW_Q(ntryL,G1H3(770),ex4(:),G1H1(19),m3h3x1(:,338),heltab2x3(:,:,488))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),12,nMT,G2tensor(368),n2h1(202))
  call Hloop_QV_A(ntryL,G1H2(76),ex3(:),G1H1(19),m3h2x1(:,81),heltab2x2(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(369),n2h1(203))
  call Hloop_QV_A(ntryL,G1H2(228),ex3(:),G1H1(19),m3h2x1(:,82),heltab2x2(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),4,nMB,G2tensor(370),n2h1(204))
  call Hloop_QV_A(ntryL,G1H2(233),ex3(:),G1H1(19),m3h2x1(:,83),heltab2x2(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(371),n2h1(205))
  call Hloop_QV_A(ntryL,G1H2(234),ex3(:),G1H1(19),m3h2x1(:,84),heltab2x2(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),12,nMB,G2tensor(372),n2h1(206))
  call Hloop_AV_Q(ntryL,G1H2(84),ex3(:),G1H1(19),m3h2x1(:,85),heltab2x2(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(373),n2h1(207))
  call Hloop_AV_Q(ntryL,G1H2(238),ex3(:),G1H1(19),m3h2x1(:,86),heltab2x2(:,:,100))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),4,nMT,G2tensor(374),n2h1(208))
  call Hloop_AV_Q(ntryL,G1H2(243),ex3(:),G1H1(19),m3h2x1(:,87),heltab2x2(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(375),n2h1(209))
  call Hloop_AV_Q(ntryL,G1H2(244),ex3(:),G1H1(19),m3h2x1(:,88),heltab2x2(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),12,nMT,G2tensor(376),n2h1(210))
  call Hloop_AW_Q(ntryL,G1H3(36),ex4(:),G1H1(19),m3h3x1(:,339),heltab2x3(:,:,489))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,0,G2tensor(377),n2h1(211))
  call Hloop_AW_Q(ntryL,G1H3(774),ex4(:),G1H1(19),m3h3x1(:,340),heltab2x3(:,:,490))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),8,0,G2tensor(378),n2h1(212))
  call Hloop_AW_Q(ntryL,G1H3(779),ex4(:),G1H1(19),m3h3x1(:,341),heltab2x3(:,:,491))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,0,G2tensor(379),n2h1(213))
  call Hloop_AW_Q(ntryL,G1H3(780),ex4(:),G1H1(19),m3h3x1(:,342),heltab2x3(:,:,492))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),9,0,G2tensor(380),n2h1(214))
  call Hloop_QW_A(ntryL,G1H3(105),ex4(:),G1H1(19),m3h3x1(:,343),heltab2x3(:,:,493))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(381),n2h1(215))
  call Hloop_QW_A(ntryL,G1H3(784),ex4(:),G1H1(19),m3h3x1(:,344),heltab2x3(:,:,494))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),8,nMB,G2tensor(382),n2h1(216))
  call Hloop_QW_A(ntryL,G1H3(789),ex4(:),G1H1(19),m3h3x1(:,345),heltab2x3(:,:,495))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(383),n2h1(217))
  call Hloop_QW_A(ntryL,G1H3(790),ex4(:),G1H1(19),m3h3x1(:,346),heltab2x3(:,:,496))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),9,nMB,G2tensor(384),n2h1(218))
  call Hloop_AW_Q(ntryL,G1H3(200),ex4(:),G1H1(19),m3h3x1(:,347),heltab2x3(:,:,497))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(385),n2h1(219))
  call Hloop_AW_Q(ntryL,G1H3(794),ex4(:),G1H1(19),m3h3x1(:,348),heltab2x3(:,:,498))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),8,nMT,G2tensor(386),n2h1(220))
  call Hloop_AW_Q(ntryL,G1H3(799),ex4(:),G1H1(19),m3h3x1(:,349),heltab2x3(:,:,499))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(387),n2h1(221))
  call Hloop_AW_Q(ntryL,G1H3(800),ex4(:),G1H1(19),m3h3x1(:,350),heltab2x3(:,:,500))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),9,nMT,G2tensor(388),n2h1(222))
  call Hloop_AV_Q(ntryL,G1H2(86),ex3(:),G1H1(19),m3h2x1(:,89),heltab2x2(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(389),n2h1(223))
  call Hloop_AV_Q(ntryL,G1H2(248),ex3(:),G1H1(19),m3h2x1(:,90),heltab2x2(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),4,nMT,G2tensor(390),n2h1(224))
  call Hloop_AV_Q(ntryL,G1H2(253),ex3(:),G1H1(19),m3h2x1(:,91),heltab2x2(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(391),n2h1(225))
  call Hloop_AV_Q(ntryL,G1H2(254),ex3(:),G1H1(19),m3h2x1(:,92),heltab2x2(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),5,nMT,G2tensor(392),n2h1(226))
  call Hloop_QV_A(ntryL,G1H2(30),ex3(:),G1H1(19),m3h2x1(:,93),heltab2x2(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(393),n2h1(227))
  call Hloop_QV_A(ntryL,G1H2(258),ex3(:),G1H1(19),m3h2x1(:,94),heltab2x2(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),4,nMB,G2tensor(394),n2h1(228))
  call Hloop_QV_A(ntryL,G1H2(263),ex3(:),G1H1(19),m3h2x1(:,95),heltab2x2(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(395),n2h1(229))
  call Hloop_QV_A(ntryL,G1H2(264),ex3(:),G1H1(19),m3h2x1(:,96),heltab2x2(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),5,nMB,G2tensor(396),n2h1(230))
  call Hloop_AW_Q(ntryL,G1H3(13),ex4(:),G1H1(19),m3h3x1(:,351),heltab2x3(:,:,501))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,0,G2tensor(397),n2h1(231))
  call Hloop_AW_Q(ntryL,G1H3(804),ex4(:),G1H1(19),m3h3x1(:,352),heltab2x3(:,:,502))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),8,0,G2tensor(398),n2h1(232))
  call Hloop_AW_Q(ntryL,G1H3(809),ex4(:),G1H1(19),m3h3x1(:,353),heltab2x3(:,:,503))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,0,G2tensor(399),n2h1(233))
  call Hloop_AW_Q(ntryL,G1H3(810),ex4(:),G1H1(19),m3h3x1(:,354),heltab2x3(:,:,504))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),10,0,G2tensor(400),n2h1(234))
  call Hloop_QW_A(ntryL,G1H3(133),ex4(:),G1H1(19),m3h3x1(:,355),heltab2x3(:,:,505))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(401),n2h1(235))
  call Hloop_QW_A(ntryL,G1H3(814),ex4(:),G1H1(19),m3h3x1(:,356),heltab2x3(:,:,506))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),8,nMB,G2tensor(402),n2h1(236))
  call Hloop_QW_A(ntryL,G1H3(819),ex4(:),G1H1(19),m3h3x1(:,357),heltab2x3(:,:,507))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(403),n2h1(237))
  call Hloop_QW_A(ntryL,G1H3(820),ex4(:),G1H1(19),m3h3x1(:,358),heltab2x3(:,:,508))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),10,nMB,G2tensor(404),n2h1(238))
  call Hloop_AW_Q(ntryL,G1H3(95),ex4(:),G1H1(19),m3h3x1(:,359),heltab2x3(:,:,509))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(405),n2h1(239))
  call Hloop_AW_Q(ntryL,G1H3(824),ex4(:),G1H1(19),m3h3x1(:,360),heltab2x3(:,:,510))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),8,nMT,G2tensor(406),n2h1(240))
  call Hloop_AW_Q(ntryL,G1H3(829),ex4(:),G1H1(19),m3h3x1(:,361),heltab2x3(:,:,511))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(407),n2h1(241))
  call Hloop_AW_Q(ntryL,G1H3(830),ex4(:),G1H1(19),m3h3x1(:,362),heltab2x3(:,:,512))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),10,nMT,G2tensor(408),n2h1(242))
  call Hloop_QV_A(ntryL,G1H2(19),ex2(:),G1H1(19),m3h2x1(:,97),heltab2x2(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(409),n2h1(243))
  call Hloop_QV_A(ntryL,G1H2(268),ex2(:),G1H1(19),m3h2x1(:,98),heltab2x2(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),2,nMB,G2tensor(410),n2h1(244))
  call Hloop_QV_A(ntryL,G1H2(273),ex2(:),G1H1(19),m3h2x1(:,99),heltab2x2(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(411),n2h1(245))
  call Hloop_QV_A(ntryL,G1H2(274),ex2(:),G1H1(19),m3h2x1(:,100),heltab2x2(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),10,nMB,G2tensor(412),n2h1(246))
  call Hloop_AV_Q(ntryL,G1H2(34),ex2(:),G1H1(19),m3h2x1(:,101),heltab2x2(:,:,115))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(413),n2h1(247))
  call Hloop_AV_Q(ntryL,G1H2(278),ex2(:),G1H1(19),m3h2x1(:,102),heltab2x2(:,:,116))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),2,nMT,G2tensor(414),n2h1(248))
  call Hloop_AV_Q(ntryL,G1H2(283),ex2(:),G1H1(19),m3h2x1(:,103),heltab2x2(:,:,117))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(415),n2h1(249))
  call Hloop_AV_Q(ntryL,G1H2(284),ex2(:),G1H1(19),m3h2x1(:,104),heltab2x2(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),10,nMT,G2tensor(416),n2h1(250))
  call Hloop_AV_Q(ntryL,G1H2(42),ex3(:),G1H1(19),m3h2x1(:,105),heltab2x2(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(417),n2h1(251))
  call Hloop_AV_Q(ntryL,G1H2(288),ex3(:),G1H1(19),m3h2x1(:,106),heltab2x2(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),4,nMT,G2tensor(418),n2h1(252))
  call Hloop_AV_Q(ntryL,G1H2(293),ex3(:),G1H1(19),m3h2x1(:,107),heltab2x2(:,:,121))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(419),n2h1(253))
  call Hloop_AV_Q(ntryL,G1H2(294),ex3(:),G1H1(19),m3h2x1(:,108),heltab2x2(:,:,122))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),6,nMT,G2tensor(420),n2h1(254))
  call Hloop_QV_A(ntryL,G1H2(45),ex3(:),G1H1(19),m3h2x1(:,109),heltab2x2(:,:,123))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(421),n2h1(255))
  call Hloop_QV_A(ntryL,G1H2(298),ex3(:),G1H1(19),m3h2x1(:,110),heltab2x2(:,:,124))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),4,nMB,G2tensor(422),n2h1(256))
  call Hloop_QV_A(ntryL,G1H2(303),ex3(:),G1H1(19),m3h2x1(:,111),heltab2x2(:,:,125))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(423),n2h1(257))
  call Hloop_QV_A(ntryL,G1H2(304),ex3(:),G1H1(19),m3h2x1(:,112),heltab2x2(:,:,126))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),6,nMB,G2tensor(424),n2h1(258))
  call Hloop_AV_Q(ntryL,G1H2(88),ex2(:),G1H1(19),m3h2x1(:,113),heltab2x2(:,:,127))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(425),n2h1(259))
  call Hloop_AV_Q(ntryL,G1H2(308),ex2(:),G1H1(19),m3h2x1(:,114),heltab2x2(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),2,nMT,G2tensor(426),n2h1(260))
  call Hloop_AV_Q(ntryL,G1H2(313),ex2(:),G1H1(19),m3h2x1(:,115),heltab2x2(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(427),n2h1(261))
  call Hloop_AV_Q(ntryL,G1H2(314),ex2(:),G1H1(19),m3h2x1(:,116),heltab2x2(:,:,130))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),6,nMT,G2tensor(428),n2h1(262))
  call Hloop_QV_A(ntryL,G1H2(95),ex2(:),G1H1(19),m3h2x1(:,117),heltab2x2(:,:,131))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(429),n2h1(263))
  call Hloop_QV_A(ntryL,G1H2(318),ex2(:),G1H1(19),m3h2x1(:,118),heltab2x2(:,:,132))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),2,nMB,G2tensor(430),n2h1(264))
  call Hloop_QV_A(ntryL,G1H2(323),ex2(:),G1H1(19),m3h2x1(:,119),heltab2x2(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(431),n2h1(265))
  call Hloop_QV_A(ntryL,G1H2(324),ex2(:),G1H1(19),m3h2x1(:,120),heltab2x2(:,:,134))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),6,nMB,G2tensor(432),n2h1(266))
  call ol_merge_tensors(G2tensor(87),[G2tensor(1)])
  call ol_merge_tensors(G2tensor(239),[G2tensor(231),G2tensor(81),G2tensor(2)])
  call ol_merge_tensors(G2tensor(243),[G2tensor(235),G2tensor(90),G2tensor(84),G2tensor(3)])
  call ol_merge_tensors(G2tensor(99),[G2tensor(4)])
  call ol_merge_tensors(G2tensor(255),[G2tensor(247),G2tensor(93),G2tensor(5)])
  call ol_merge_tensors(G2tensor(259),[G2tensor(251),G2tensor(102),G2tensor(96),G2tensor(6)])
  call ol_merge_tensors(G2tensor(183),[G2tensor(175),G2tensor(111),G2tensor(7)])
  call ol_merge_tensors(G2tensor(187),[G2tensor(179),G2tensor(114),G2tensor(108),G2tensor(8)])
  call ol_merge_tensors(G2tensor(105),[G2tensor(9)])
  call ol_merge_tensors(G2tensor(117),[G2tensor(10)])
  call ol_merge_tensors(G2tensor(271),[G2tensor(263),G2tensor(123),G2tensor(11)])
  call ol_merge_tensors(G2tensor(275),[G2tensor(267),G2tensor(126),G2tensor(120),G2tensor(12)])
  call ol_merge_tensors(G2tensor(207),[G2tensor(199),G2tensor(135),G2tensor(13)])
  call ol_merge_tensors(G2tensor(211),[G2tensor(203),G2tensor(138),G2tensor(132),G2tensor(14)])
  call ol_merge_tensors(G2tensor(129),[G2tensor(15)])
  call ol_merge_tensors(G2tensor(141),[G2tensor(16)])
  call ol_merge_tensors(G2tensor(287),[G2tensor(279),G2tensor(147),G2tensor(17)])
  call ol_merge_tensors(G2tensor(291),[G2tensor(283),G2tensor(150),G2tensor(144),G2tensor(18)])
  call ol_merge_tensors(G2tensor(153),[G2tensor(22),G2tensor(20),G2tensor(19)])
  call ol_merge_tensors(G2tensor(300),[G2tensor(296),G2tensor(221),G2tensor(156),G2tensor(23),G2tensor(21)])
  call ol_merge_tensors(G2tensor(159),[G2tensor(27),G2tensor(25),G2tensor(24)])
  call ol_merge_tensors(G2tensor(309),[G2tensor(305),G2tensor(226),G2tensor(162),G2tensor(28),G2tensor(26)])
  call Hotf_5pt_reduction_last(G2tensor(87),RedSet_5(1),mass5set(:,4),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(239),RedSet_5(1),mass5set(:,6),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(243),RedSet_5(1),mass5set(:,5),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(99),RedSet_5(2),mass5set(:,4),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),8)
  call Hotf_5pt_reduction_last(G2tensor(255),RedSet_5(2),mass5set(:,6),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(259),RedSet_5(2),mass5set(:,5),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(183),RedSet_5(3),mass5set(:,6),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(187),RedSet_5(3),mass5set(:,5),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),8)
  call Hotf_5pt_reduction_last(G2tensor(105),RedSet_5(3),mass5set(:,4),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(117),RedSet_5(5),mass5set(:,4),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),8)
  call Hotf_5pt_reduction_last(G2tensor(271),RedSet_5(5),mass5set(:,6),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(275),RedSet_5(5),mass5set(:,5),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),8)
  call Hotf_5pt_reduction_last(G2tensor(207),RedSet_5(7),mass5set(:,6),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),8)
  call Hotf_5pt_reduction_last(G2tensor(211),RedSet_5(7),mass5set(:,5),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),8)
  call Hotf_5pt_reduction_last(G2tensor(129),RedSet_5(7),mass5set(:,4),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),8)
  call Hotf_5pt_reduction_last(G2tensor(141),RedSet_5(9),mass5set(:,4),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),8)
  call Hotf_5pt_reduction_last(G2tensor(287),RedSet_5(9),mass5set(:,6),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),8)
  call Hotf_5pt_reduction_last(G2tensor(291),RedSet_5(9),mass5set(:,5),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),8)
  call Hotf_5pt_reduction_last(G2tensor(153),RedSet_5(11),mass5set(:,12),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),4)
  call Hotf_5pt_reduction_last(G2tensor(300),RedSet_5(11),mass5set(:,11),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),4)
  call Hotf_5pt_reduction_last(G2tensor(159),RedSet_5(12),mass5set(:,12),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),2)
  call Hotf_5pt_reduction_last(G2tensor(309),RedSet_5(12),mass5set(:,11),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),2)
  call Hotf_5pt_reduction_last(G2tensor(313),RedSet_5(1),mass5set(:,1),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),8)
  call Hotf_5pt_reduction_last(G2tensor(317),RedSet_5(1),mass5set(:,2),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),8)
  call Hotf_5pt_reduction_last(G2tensor(321),RedSet_5(1),mass5set(:,3),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),8)
  call Hotf_5pt_reduction_last(G2tensor(325),RedSet_5(2),mass5set(:,1),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),8)
  call Hotf_5pt_reduction_last(G2tensor(329),RedSet_5(2),mass5set(:,2),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),8)
  call Hotf_5pt_reduction_last(G2tensor(333),RedSet_5(2),mass5set(:,3),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),8)
  call Hotf_5pt_reduction_last(G2tensor(337),RedSet_5(3),mass5set(:,1),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),8)
  call Hotf_5pt_reduction_last(G2tensor(341),RedSet_5(3),mass5set(:,2),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),8)
  call Hotf_5pt_reduction_last(G2tensor(345),RedSet_5(3),mass5set(:,3),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),8)
  call Hotf_5pt_reduction_last(G2tensor(349),RedSet_5(4),mass5set(:,7),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),4)
  call Hotf_5pt_reduction_last(G2tensor(353),RedSet_5(4),mass5set(:,8),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),4)
  call Hotf_5pt_reduction_last(G2tensor(357),RedSet_5(5),mass5set(:,1),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),8)
  call Hotf_5pt_reduction_last(G2tensor(361),RedSet_5(5),mass5set(:,2),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),8)
  call Hotf_5pt_reduction_last(G2tensor(365),RedSet_5(5),mass5set(:,3),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),8)
  call Hotf_5pt_reduction_last(G2tensor(369),RedSet_5(6),mass5set(:,7),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),4)
  call Hotf_5pt_reduction_last(G2tensor(373),RedSet_5(6),mass5set(:,8),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),4)
  call Hotf_5pt_reduction_last(G2tensor(377),RedSet_5(7),mass5set(:,1),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),8)
  call Hotf_5pt_reduction_last(G2tensor(381),RedSet_5(7),mass5set(:,2),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),8)
  call Hotf_5pt_reduction_last(G2tensor(385),RedSet_5(7),mass5set(:,3),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
  call G_TensorShift(G1tensor(242),8)
  call Hotf_5pt_reduction_last(G2tensor(389),RedSet_5(8),mass5set(:,9),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
  call G_TensorShift(G1tensor(248),4)
  call Hotf_5pt_reduction_last(G2tensor(393),RedSet_5(8),mass5set(:,10),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257),G1tensor(258))
  call G_TensorShift(G1tensor(254),4)
  call Hotf_5pt_reduction_last(G2tensor(397),RedSet_5(9),mass5set(:,1),  & 
G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264))
  call G_TensorShift(G1tensor(260),8)
  call Hotf_5pt_reduction_last(G2tensor(401),RedSet_5(9),mass5set(:,2),  & 
G1tensor(265),G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(266),8)
  call Hotf_5pt_reduction_last(G2tensor(405),RedSet_5(9),mass5set(:,3),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275),G1tensor(276))
  call G_TensorShift(G1tensor(272),8)
  call Hotf_5pt_reduction_last(G2tensor(409),RedSet_5(10),mass5set(:,7),  & 
G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280),G1tensor(281),G1tensor(282))
  call G_TensorShift(G1tensor(278),2)
  call Hotf_5pt_reduction_last(G2tensor(413),RedSet_5(10),mass5set(:,8),  & 
G1tensor(283),G1tensor(284),G1tensor(285),G1tensor(286),G1tensor(287),G1tensor(288))
  call G_TensorShift(G1tensor(284),2)
  call Hotf_5pt_reduction_last(G2tensor(417),RedSet_5(11),mass5set(:,9),  & 
G1tensor(289),G1tensor(290),G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294))
  call G_TensorShift(G1tensor(290),4)
  call Hotf_5pt_reduction_last(G2tensor(421),RedSet_5(11),mass5set(:,10),  & 
G1tensor(295),G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300))
  call G_TensorShift(G1tensor(296),4)
  call Hotf_5pt_reduction_last(G2tensor(425),RedSet_5(12),mass5set(:,9),  & 
G1tensor(301),G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305),G1tensor(306))
  call G_TensorShift(G1tensor(302),2)
  call Hotf_5pt_reduction_last(G2tensor(429),RedSet_5(12),mass5set(:,10),  & 
G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310),G1tensor(311),G1tensor(312))
  call G_TensorShift(G1tensor(308),2)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  call ol_merge_tensors(T1sum(25),[G1tensor(145)])
  call ol_merge_tensors(T1sum(26),[G1tensor(151)])
  call ol_merge_tensors(T1sum(27),[G1tensor(157)])
  call ol_merge_tensors(T1sum(28),[G1tensor(163)])
  call ol_merge_tensors(T1sum(29),[G1tensor(169)])
  call ol_merge_tensors(T1sum(30),[G1tensor(175)])
  call ol_merge_tensors(T1sum(31),[G1tensor(181)])
  call ol_merge_tensors(T1sum(32),[G1tensor(187)])
  call ol_merge_tensors(T1sum(33),[G1tensor(193)])
  call ol_merge_tensors(T1sum(34),[G1tensor(199)])
  call ol_merge_tensors(T1sum(35),[G1tensor(205)])
  call ol_merge_tensors(T1sum(36),[G1tensor(211)])
  call ol_merge_tensors(T1sum(37),[G1tensor(217)])
  call ol_merge_tensors(T1sum(38),[G1tensor(223)])
  call ol_merge_tensors(T1sum(39),[G1tensor(229)])
  call ol_merge_tensors(T1sum(40),[G1tensor(235)])
  call ol_merge_tensors(T1sum(41),[G1tensor(241)])
  call ol_merge_tensors(T1sum(42),[G1tensor(247)])
  call ol_merge_tensors(T1sum(43),[G1tensor(253)])
  call ol_merge_tensors(T1sum(44),[G1tensor(259)])
  call ol_merge_tensors(T1sum(45),[G1tensor(265)])
  call ol_merge_tensors(T1sum(46),[G1tensor(271)])
  call ol_merge_tensors(T1sum(47),[G1tensor(277)])
  call ol_merge_tensors(T1sum(48),[G1tensor(283)])
  call ol_merge_tensors(T1sum(49),[G1tensor(289)])
  call ol_merge_tensors(T1sum(50),[G1tensor(295)])
  call ol_merge_tensors(T1sum(51),[G1tensor(301)])
  call ol_merge_tensors(T1sum(52),[G1tensor(307)])
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(423),h0tab(:,423),[24,2,1,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(1),m4h3x3x4(:,1),heltab3x36(:,:,1))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(424),h0tab(:,424),[24,2,1,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(2),m4h3x3x4(:,2),heltab3x36(:,:,2))
  Gcoeff(:)%j = (c(19)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(425),h0tab(:,425),[24,2,1,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex4(:),ex5(:),G0H4(3),m4h3x3x4(:,3),heltab3x36(:,:,3))
  Gcoeff(:)%j = (c(19)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(426),h0tab(:,426),[24,2,1,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(4),m4h3x3x4(:,4),heltab3x36(:,:,4))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(427),h0tab(:,427),[24,2,1,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(5),m4h3x3x4(:,5),heltab3x36(:,:,5))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(428),h0tab(:,428),[24,2,1,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(6),m4h3x3x4(:,6),heltab3x36(:,:,6))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(429),h0tab(:,429),[24,2,1,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(7),m4h3x3x4(:,7),heltab3x36(:,:,7))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(430),h0tab(:,430),[24,2,1,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(8),m4h3x3x4(:,8),heltab3x36(:,:,8))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(431),h0tab(:,431),[24,2,1,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex4(:),ex5(:),G0H4(9),m4h3x3x4(:,9),heltab3x36(:,:,9))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(432),h0tab(:,432),[24,2,1,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(10),m4h3x3x4(:,10),heltab3x36(:,:,10))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(433),h0tab(:,433),[24,2,1,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(11),m4h3x3x4(:,11),heltab3x36(:,:,11))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(434),h0tab(:,434),[24,2,1,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(12),m4h3x3x4(:,12),heltab3x36(:,:,12))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(435),h0tab(:,435),[24,2,1,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex4(:),ex5(:),G0H4(13),m4h3x3x4(:,13),heltab3x36(:,:,13))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(436),h0tab(:,436),[24,2,1,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(14),m4h3x3x4(:,14),heltab3x36(:,:,14))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(437),h0tab(:,437),[24,2,1,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex4(:),ex5(:),G0H4(15),m4h3x3x4(:,15),heltab3x36(:,:,15))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(438),h0tab(:,438),[24,2,1,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(16),m4h3x3x4(:,16),heltab3x36(:,:,16))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(439),h0tab(:,439),[24,1,2,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(17),m4h3x3x4(:,17),heltab3x36(:,:,17))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(440),h0tab(:,440),[24,1,2,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(18),m4h3x3x4(:,18),heltab3x36(:,:,18))
  Gcoeff(:)%j = (c(19)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(441),h0tab(:,441),[24,1,2,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(19),m4h3x3x4(:,19),heltab3x36(:,:,19))
  Gcoeff(:)%j = (c(19)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(442),h0tab(:,442),[24,1,2,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex4(:),ex5(:),G0H4(20),m4h3x3x4(:,20),heltab3x36(:,:,20))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(443),h0tab(:,443),[24,1,2,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(21),m4h3x3x4(:,21),heltab3x36(:,:,21))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(444),h0tab(:,444),[24,1,2,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(22),m4h3x3x4(:,22),heltab3x36(:,:,22))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(445),h0tab(:,445),[24,1,2,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(23),m4h3x3x4(:,23),heltab3x36(:,:,23))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(446),h0tab(:,446),[24,1,2,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(24),m4h3x3x4(:,24),heltab3x36(:,:,24))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(447),h0tab(:,447),[24,1,2,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(25),m4h3x3x4(:,25),heltab3x36(:,:,25))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(448),h0tab(:,448),[24,1,2,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex4(:),ex5(:),G0H4(26),m4h3x3x4(:,26),heltab3x36(:,:,26))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(449),h0tab(:,449),[24,1,2,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(27),m4h3x3x4(:,27),heltab3x36(:,:,27))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(450),h0tab(:,450),[24,1,2,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(28),m4h3x3x4(:,28),heltab3x36(:,:,28))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(451),h0tab(:,451),[24,1,2,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(29),m4h3x3x4(:,29),heltab3x36(:,:,29))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(452),h0tab(:,452),[24,1,2,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex4(:),ex5(:),G0H4(30),m4h3x3x4(:,30),heltab3x36(:,:,30))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(453),h0tab(:,453),[24,1,2,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(31),m4h3x3x4(:,31),heltab3x36(:,:,31))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(454),h0tab(:,454),[24,1,2,4],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex4(:),ex5(:),G0H4(32),m4h3x3x4(:,32),heltab3x36(:,:,32))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(455),h0tab(:,455),[24,1,4,2],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(33),m4h3x3x4(:,33),heltab3x36(:,:,33))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(456),h0tab(:,456),[24,1,4,2],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(34),m4h3x3x4(:,34),heltab3x36(:,:,34))
  Gcoeff(:)%j = (c(19)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(457),h0tab(:,457),[24,1,4,2],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(35),m4h3x3x4(:,35),heltab3x36(:,:,35))
  Gcoeff(:)%j = (c(19)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(458),h0tab(:,458),[24,1,4,2],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex4(:),ex5(:),G0H4(36),m4h3x3x4(:,36),heltab3x36(:,:,36))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(459),h0tab(:,459),[24,1,4,2],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(37),m4h3x3x4(:,37),heltab3x36(:,:,37))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(460),h0tab(:,460),[24,1,4,2],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(38),m4h3x3x4(:,38),heltab3x36(:,:,38))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(461),h0tab(:,461),[24,1,4,2],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(39),m4h3x3x4(:,39),heltab3x36(:,:,39))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(462),h0tab(:,462),[24,1,4,2],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(40),m4h3x3x4(:,40),heltab3x36(:,:,40))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(463),h0tab(:,463),[24,1,4,2],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(41),m4h3x3x4(:,41),heltab3x36(:,:,41))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(464),h0tab(:,464),[24,1,4,2],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex4(:),ex5(:),G0H4(42),m4h3x3x4(:,42),heltab3x36(:,:,42))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(465),h0tab(:,465),[24,1,4,2],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(43),m4h3x3x4(:,43),heltab3x36(:,:,43))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(466),h0tab(:,466),[24,1,4,2],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(44),m4h3x3x4(:,44),heltab3x36(:,:,44))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(467),h0tab(:,467),[24,1,4,2],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(45),m4h3x3x4(:,45),heltab3x36(:,:,45))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(468),h0tab(:,468),[24,1,4,2],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex4(:),ex5(:),G0H4(46),m4h3x3x4(:,46),heltab3x36(:,:,46))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(469),h0tab(:,469),[24,1,4,2],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex4(:),G0H4(47),m4h3x3x4(:,47),heltab3x36(:,:,47))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(470),h0tab(:,470),[24,1,4,2],[nMW,nMW,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex4(:),ex5(:),G0H4(48),m4h3x3x4(:,48),heltab3x36(:,:,48))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(471),h0tab(:,471),[20,2,1,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H6(37),m4h3x2x6(:,1),heltab3x36(:,:,49))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(472),h0tab(:,472),[20,2,1,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H6(47),m4h3x2x6(:,2),heltab3x36(:,:,50))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(473),h0tab(:,473),[20,2,1,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H6(48),m4h2x3x6(:,1),heltab3x36(:,:,51))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(474),h0tab(:,474),[20,2,1,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H6(40),m4h2x3x6(:,2),heltab3x36(:,:,52))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(475),h0tab(:,475),[20,2,1,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H6(41),m4h3x2x6(:,3),heltab3x36(:,:,53))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(476),h0tab(:,476),[20,2,1,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H6(38),m4h3x2x6(:,4),heltab3x36(:,:,54))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(477),h0tab(:,477),[20,2,1,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H6(39),m4h3x2x6(:,5),heltab3x36(:,:,55))
  Gcoeff(:)%j = (c(49)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(478),h0tab(:,478),[20,2,1,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H6(46),m4h2x3x6(:,3),heltab3x36(:,:,56))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(479),h0tab(:,479),[20,2,1,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H6(42),m4h2x3x6(:,4),heltab3x36(:,:,57))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(480),h0tab(:,480),[20,2,1,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H6(43),m4h3x2x6(:,6),heltab3x36(:,:,58))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(481),h0tab(:,481),[20,2,1,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H6(44),m4h2x3x6(:,5),heltab3x36(:,:,59))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(482),h0tab(:,482),[20,2,1,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H6(45),m4h2x3x6(:,6),heltab3x36(:,:,60))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(483),h0tab(:,483),[20,2,1,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H6(1),m4h2x3x6(:,7),heltab3x36(:,:,61))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(484),h0tab(:,484),[20,2,1,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H6(11),m4h2x3x6(:,8),heltab3x36(:,:,62))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(485),h0tab(:,485),[20,1,2,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H6(12),m4h3x2x6(:,7),heltab3x36(:,:,63))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(486),h0tab(:,486),[20,1,2,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H6(2),m4h3x2x6(:,8),heltab3x36(:,:,64))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(487),h0tab(:,487),[20,1,2,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H6(5),m4h2x3x6(:,9),heltab3x36(:,:,65))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(488),h0tab(:,488),[20,1,2,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H6(3),m4h2x3x6(:,10),heltab3x36(:,:,66))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(489),h0tab(:,489),[20,1,2,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H6(4),m4h3x2x6(:,9),heltab3x36(:,:,67))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(490),h0tab(:,490),[20,1,2,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H6(8),m4h3x2x6(:,10),heltab3x36(:,:,68))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(491),h0tab(:,491),[20,1,2,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H6(6),m4h3x2x6(:,11),heltab3x36(:,:,69))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(492),h0tab(:,492),[20,1,2,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H6(7),m4h2x3x6(:,11),heltab3x36(:,:,70))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(493),h0tab(:,493),[20,1,2,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H6(9),m4h2x3x6(:,12),heltab3x36(:,:,71))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(494),h0tab(:,494),[20,1,2,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H6(10),m4h3x2x6(:,12),heltab3x36(:,:,72))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(495),h0tab(:,495),[20,1,2,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H6(13),m4h2x3x6(:,13),heltab3x36(:,:,73))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(496),h0tab(:,496),[20,1,2,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H6(23),m4h2x3x6(:,14),heltab3x36(:,:,74))
  Gcoeff(:)%j = (c(52)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(497),h0tab(:,497),[20,1,2,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H6(24),m4h2x3x6(:,15),heltab3x36(:,:,75))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(498),h0tab(:,498),[20,1,2,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex3(:),ex5(:),G0H6(14),m4h2x3x6(:,16),heltab3x36(:,:,76))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(499),h0tab(:,499),[20,1,8,2],[nMH,nMH,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H6(15),m4h3x2x6(:,13),heltab3x36(:,:,77))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(500),h0tab(:,500),[20,1,8,2],[nMZ,nMZ,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H6(18),m4h3x2x6(:,14),heltab3x36(:,:,78))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(501),h0tab(:,501),[20,1,8,2],[nMZ,nMZ,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex3(:),G0H6(16),m4h3x2x6(:,15),heltab3x36(:,:,79))
  Gcoeff(:)%j = (c(28)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(502),h0tab(:,502),[20,1,8,2],[nMH,nMH,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H6(17),m4h3x2x6(:,16),heltab3x36(:,:,80))
  Gcoeff(:)%j = (c(47)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(503),h0tab(:,503),[20,1,8,2],[nMZ,nMZ,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H6(19),m4h3x2x6(:,17),heltab3x36(:,:,81))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(504),h0tab(:,504),[20,1,8,2],[nMZ,nMZ,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex3(:),G0H6(20),m4h3x2x6(:,18),heltab3x36(:,:,82))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(505),h0tab(:,505),[20,1,8,2],[nMZ,nMZ,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex3(:),G0H6(21),m4h3x2x6(:,19),heltab3x36(:,:,83))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(506),h0tab(:,506),[20,1,8,2],[nMZ,nMZ,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex3(:),G0H6(22),m4h3x2x6(:,20),heltab3x36(:,:,84))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(507),h0tab(:,507),[16,1,2,12],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(50),m3h3x12(:,423),heltab2x36(:,:,423))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(508),h0tab(:,508),[16,1,2,12],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(40),m3h3x12(:,424),heltab2x36(:,:,424))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(509),h0tab(:,509),[16,1,2,12],[nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(41),m3h3x12(:,425),heltab2x36(:,:,425))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(510),h0tab(:,510),[16,1,2,12],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(42),m3h3x12(:,426),heltab2x36(:,:,426))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(511),h0tab(:,511),[16,1,2,12],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(41),m3h3x12(:,427),heltab2x36(:,:,427))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(512),h0tab(:,512),[16,1,2,12],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(43),m3h3x12(:,428),heltab2x36(:,:,428))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(513),h0tab(:,513),[16,1,2,12],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(44),m3h3x12(:,429),heltab2x36(:,:,429))
  Gcoeff(:)%j = (c(49)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(514),h0tab(:,514),[16,1,2,12],[nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(42),m3h3x12(:,430),heltab2x36(:,:,430))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(515),h0tab(:,515),[16,1,2,12],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(43),m3h3x12(:,431),heltab2x36(:,:,431))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(516),h0tab(:,516),[16,1,2,12],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(44),m3h3x12(:,432),heltab2x36(:,:,432))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(517),h0tab(:,517),[16,1,2,12],[nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(63),m3h3x12(:,433),heltab2x36(:,:,433))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(518),h0tab(:,518),[16,1,2,12],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(64),m3h3x12(:,434),heltab2x36(:,:,434))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(519),h0tab(:,519),[16,1,2,12],[nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(45),m3h3x12(:,435),heltab2x36(:,:,435))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(520),h0tab(:,520),[16,1,2,12],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(46),m3h3x12(:,436),heltab2x36(:,:,436))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(521),h0tab(:,521),[16,2,1,12],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(52),m3h3x12(:,437),heltab2x36(:,:,437))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(522),h0tab(:,522),[16,2,1,12],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(53),m3h3x12(:,438),heltab2x36(:,:,438))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(523),h0tab(:,523),[16,2,1,12],[nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(49),m3h3x12(:,439),heltab2x36(:,:,439))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(524),h0tab(:,524),[16,2,1,12],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(56),m3h3x12(:,440),heltab2x36(:,:,440))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(525),h0tab(:,525),[16,2,1,12],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(47),m3h3x12(:,441),heltab2x36(:,:,441))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(526),h0tab(:,526),[16,2,1,12],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(61),m3h3x12(:,442),heltab2x36(:,:,442))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(527),h0tab(:,527),[16,2,1,12],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(62),m3h3x12(:,443),heltab2x36(:,:,443))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(528),h0tab(:,528),[16,2,1,12],[nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(48),m3h3x12(:,444),heltab2x36(:,:,444))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(529),h0tab(:,529),[16,2,1,12],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(49),m3h3x12(:,445),heltab2x36(:,:,445))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(530),h0tab(:,530),[16,2,1,12],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(50),m3h3x12(:,446),heltab2x36(:,:,446))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(531),h0tab(:,531),[16,2,1,12],[nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(65),m3h3x12(:,447),heltab2x36(:,:,447))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(532),h0tab(:,532),[16,2,1,12],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(66),m3h3x12(:,448),heltab2x36(:,:,448))
  Gcoeff(:)%j = (c(52)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(533),h0tab(:,533),[16,2,1,12],[nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(51),m3h3x12(:,449),heltab2x36(:,:,449))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(534),h0tab(:,534),[16,2,1,12],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(52),m3h3x12(:,450),heltab2x36(:,:,450))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(535),h0tab(:,535),[16,1,12,2],[nMH,nMH,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(67),m3h3x12(:,451),heltab2x36(:,:,451))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(536),h0tab(:,536),[16,1,12,2],[nMZ,nMZ,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(68),m3h3x12(:,452),heltab2x36(:,:,452))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(537),h0tab(:,537),[16,1,12,2],[nMZ,nMZ,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(73),m3h3x12(:,453),heltab2x36(:,:,453))
  Gcoeff(:)%j = (c(28)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(538),h0tab(:,538),[16,1,12,2],[nMH,nMH,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(53),m3h3x12(:,454),heltab2x36(:,:,454))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(539),h0tab(:,539),[16,1,12,2],[nMZ,nMZ,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(54),m3h3x12(:,455),heltab2x36(:,:,455))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(540),h0tab(:,540),[16,1,12,2],[nMZ,nMZ,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(81),m3h3x12(:,456),heltab2x36(:,:,456))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(541),h0tab(:,541),[16,1,12,2],[nMZ,nMZ,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(75),m3h3x12(:,457),heltab2x36(:,:,457))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(542),h0tab(:,542),[16,1,12,2],[nMZ,nMZ,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(55),m3h3x12(:,458),heltab2x36(:,:,458))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(543),h0tab(:,543),[18,4,1,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex2(:),G0H6(25),m4h3x2x6(:,21),heltab3x36(:,:,85))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(544),h0tab(:,544),[18,4,1,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex2(:),G0H6(35),m4h3x2x6(:,22),heltab3x36(:,:,86))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(545),h0tab(:,545),[18,4,1,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex2(:),ex5(:),G0H6(36),m4h2x3x6(:,17),heltab3x36(:,:,87))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(546),h0tab(:,546),[18,4,1,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex2(:),ex5(:),G0H6(28),m4h2x3x6(:,18),heltab3x36(:,:,88))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(547),h0tab(:,547),[18,4,1,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex2(:),G0H6(29),m4h3x2x6(:,23),heltab3x36(:,:,89))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(548),h0tab(:,548),[18,4,1,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex2(:),G0H6(26),m4h3x2x6(:,24),heltab3x36(:,:,90))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(549),h0tab(:,549),[18,4,1,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex2(:),G0H6(27),m4h3x2x6(:,25),heltab3x36(:,:,91))
  Gcoeff(:)%j = (c(49)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(550),h0tab(:,550),[18,4,1,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex2(:),ex5(:),G0H6(34),m4h2x3x6(:,19),heltab3x36(:,:,92))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(551),h0tab(:,551),[18,4,1,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex2(:),ex5(:),G0H6(30),m4h2x3x6(:,20),heltab3x36(:,:,93))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(552),h0tab(:,552),[18,4,1,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex2(:),G0H6(31),m4h3x2x6(:,26),heltab3x36(:,:,94))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(553),h0tab(:,553),[18,4,1,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex2(:),ex5(:),G0H6(32),m4h2x3x6(:,21),heltab3x36(:,:,95))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(554),h0tab(:,554),[18,4,1,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex2(:),ex5(:),G0H6(33),m4h2x3x6(:,22),heltab3x36(:,:,96))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(555),h0tab(:,555),[18,4,1,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex2(:),ex5(:),G0H6(49),m4h2x3x6(:,23),heltab3x36(:,:,97))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(556),h0tab(:,556),[18,4,1,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex2(:),ex5(:),G0H6(50),m4h2x3x6(:,24),heltab3x36(:,:,98))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(557),h0tab(:,557),[18,1,4,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex2(:),G0H6(51),m4h3x2x6(:,27),heltab3x36(:,:,99))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(558),h0tab(:,558),[18,1,4,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex2(:),G0H6(52),m4h3x2x6(:,28),heltab3x36(:,:,100))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(559),h0tab(:,559),[18,1,4,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex2(:),ex5(:),G0H6(53),m4h2x3x6(:,25),heltab3x36(:,:,101))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(560),h0tab(:,560),[18,1,4,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex2(:),ex5(:),G0H6(54),m4h2x3x6(:,26),heltab3x36(:,:,102))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(561),h0tab(:,561),[18,1,4,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex2(:),G0H6(55),m4h3x2x6(:,29),heltab3x36(:,:,103))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(562),h0tab(:,562),[18,1,4,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex2(:),G0H6(56),m4h3x2x6(:,30),heltab3x36(:,:,104))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(563),h0tab(:,563),[18,1,4,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex2(:),G0H6(57),m4h3x2x6(:,31),heltab3x36(:,:,105))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(564),h0tab(:,564),[18,1,4,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex2(:),ex5(:),G0H6(58),m4h2x3x6(:,27),heltab3x36(:,:,106))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(565),h0tab(:,565),[18,1,4,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex2(:),ex5(:),G0H6(59),m4h2x3x6(:,28),heltab3x36(:,:,107))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(566),h0tab(:,566),[18,1,4,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex2(:),G0H6(60),m4h3x2x6(:,32),heltab3x36(:,:,108))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(567),h0tab(:,567),[18,1,4,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex2(:),ex5(:),G0H6(61),m4h2x3x6(:,29),heltab3x36(:,:,109))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(568),h0tab(:,568),[18,1,4,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex2(:),ex5(:),G0H6(62),m4h2x3x6(:,30),heltab3x36(:,:,110))
  Gcoeff(:)%j = (c(52)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(569),h0tab(:,569),[18,1,4,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex2(:),ex5(:),G0H6(63),m4h2x3x6(:,31),heltab3x36(:,:,111))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(570),h0tab(:,570),[18,1,4,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex2(:),ex5(:),G0H6(64),m4h2x3x6(:,32),heltab3x36(:,:,112))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(571),h0tab(:,571),[18,1,8,4],[nMH,nMH,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex2(:),G0H6(65),m4h3x2x6(:,33),heltab3x36(:,:,113))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(572),h0tab(:,572),[18,1,8,4],[nMZ,nMZ,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex2(:),G0H6(66),m4h3x2x6(:,34),heltab3x36(:,:,114))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(573),h0tab(:,573),[18,1,8,4],[nMZ,nMZ,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex2(:),G0H6(67),m4h3x2x6(:,35),heltab3x36(:,:,115))
  Gcoeff(:)%j = (c(28)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(574),h0tab(:,574),[18,1,8,4],[nMH,nMH,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex2(:),G0H6(68),m4h3x2x6(:,36),heltab3x36(:,:,116))
  Gcoeff(:)%j = (c(47)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(575),h0tab(:,575),[18,1,8,4],[nMZ,nMZ,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex2(:),G0H6(69),m4h3x2x6(:,37),heltab3x36(:,:,117))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(576),h0tab(:,576),[18,1,8,4],[nMZ,nMZ,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex2(:),G0H6(70),m4h3x2x6(:,38),heltab3x36(:,:,118))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(577),h0tab(:,577),[18,1,8,4],[nMZ,nMZ,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex5(:),ex2(:),G0H6(71),m4h3x2x6(:,39),heltab3x36(:,:,119))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(578),h0tab(:,578),[18,1,8,4],[nMZ,nMZ,nMW,nMW],5,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex5(:),ex2(:),G0H6(72),m4h3x2x6(:,40),heltab3x36(:,:,120))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(579),h0tab(:,579),[16,1,4,10],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(76),m3h3x12(:,459),heltab2x36(:,:,459))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(580),h0tab(:,580),[16,1,4,10],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(77),m3h3x12(:,460),heltab2x36(:,:,460))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(581),h0tab(:,581),[16,1,4,10],[nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(78),m3h3x12(:,461),heltab2x36(:,:,461))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(582),h0tab(:,582),[16,1,4,10],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(79),m3h3x12(:,462),heltab2x36(:,:,462))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(583),h0tab(:,583),[16,1,4,10],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(56),m3h3x12(:,463),heltab2x36(:,:,463))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(584),h0tab(:,584),[16,1,4,10],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(83),m3h3x12(:,464),heltab2x36(:,:,464))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(585),h0tab(:,585),[16,1,4,10],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(82),m3h3x12(:,465),heltab2x36(:,:,465))
  Gcoeff(:)%j = (c(49)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(586),h0tab(:,586),[16,1,4,10],[nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(57),m3h3x12(:,466),heltab2x36(:,:,466))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(587),h0tab(:,587),[16,1,4,10],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(58),m3h3x12(:,467),heltab2x36(:,:,467))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(588),h0tab(:,588),[16,1,4,10],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(59),m3h3x12(:,468),heltab2x36(:,:,468))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(589),h0tab(:,589),[16,1,4,10],[nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(84),m3h3x12(:,469),heltab2x36(:,:,469))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(590),h0tab(:,590),[16,1,4,10],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(85),m3h3x12(:,470),heltab2x36(:,:,470))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(591),h0tab(:,591),[16,1,4,10],[nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(60),m3h3x12(:,471),heltab2x36(:,:,471))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(592),h0tab(:,592),[16,1,4,10],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(61),m3h3x12(:,472),heltab2x36(:,:,472))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(593),h0tab(:,593),[16,4,1,10],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(86),m3h3x12(:,473),heltab2x36(:,:,473))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(594),h0tab(:,594),[16,4,1,10],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(89),m3h3x12(:,474),heltab2x36(:,:,474))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(595),h0tab(:,595),[16,4,1,10],[nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(97),m3h3x12(:,475),heltab2x36(:,:,475))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(596),h0tab(:,596),[16,4,1,10],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(91),m3h3x12(:,476),heltab2x36(:,:,476))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(597),h0tab(:,597),[16,4,1,10],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(62),m3h3x12(:,477),heltab2x36(:,:,477))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(598),h0tab(:,598),[16,4,1,10],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(92),m3h3x12(:,478),heltab2x36(:,:,478))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(599),h0tab(:,599),[16,4,1,10],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(93),m3h3x12(:,479),heltab2x36(:,:,479))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(600),h0tab(:,600),[16,4,1,10],[nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(63),m3h3x12(:,480),heltab2x36(:,:,480))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(601),h0tab(:,601),[16,4,1,10],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(64),m3h3x12(:,481),heltab2x36(:,:,481))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(602),h0tab(:,602),[16,4,1,10],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(65),m3h3x12(:,482),heltab2x36(:,:,482))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(603),h0tab(:,603),[16,4,1,10],[nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(94),m3h3x12(:,483),heltab2x36(:,:,483))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(604),h0tab(:,604),[16,4,1,10],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(95),m3h3x12(:,484),heltab2x36(:,:,484))
  Gcoeff(:)%j = (c(52)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(605),h0tab(:,605),[16,4,1,10],[nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(66),m3h3x12(:,485),heltab2x36(:,:,485))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(606),h0tab(:,606),[16,4,1,10],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(67),m3h3x12(:,486),heltab2x36(:,:,486))
  Gcoeff(:)%j = (c(4)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(607),h0tab(:,607),[16,1,10,4],[nMH,nMH,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(99),m3h3x12(:,487),heltab2x36(:,:,487))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(608),h0tab(:,608),[16,1,10,4],[nMZ,nMZ,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(98),m3h3x12(:,488),heltab2x36(:,:,488))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(609),h0tab(:,609),[16,1,10,4],[nMZ,nMZ,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(100),m3h3x12(:,489),heltab2x36(:,:,489))
  Gcoeff(:)%j = (c(28)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(610),h0tab(:,610),[16,1,10,4],[nMH,nMH,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(68),m3h3x12(:,490),heltab2x36(:,:,490))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(611),h0tab(:,611),[16,1,10,4],[nMZ,nMZ,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(69),m3h3x12(:,491),heltab2x36(:,:,491))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(612),h0tab(:,612),[16,1,10,4],[nMZ,nMZ,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(101),m3h3x12(:,492),heltab2x36(:,:,492))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(613),h0tab(:,613),[16,1,10,4],[nMZ,nMZ,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(102),m3h3x12(:,493),heltab2x36(:,:,493))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(614),h0tab(:,614),[16,1,10,4],[nMZ,nMZ,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(70),m3h3x12(:,494),heltab2x36(:,:,494))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(615),h0tab(:,615),[16,1,8,6],[nMH,nMH,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(103),m3h3x12(:,495),heltab2x36(:,:,495))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(616),h0tab(:,616),[16,1,8,6],[nMZ,nMZ,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(104),m3h3x12(:,496),heltab2x36(:,:,496))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(617),h0tab(:,617),[16,1,8,6],[nMZ,nMZ,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(106),m3h3x12(:,497),heltab2x36(:,:,497))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(618),h0tab(:,618),[16,1,8,6],[nMZ,nMZ,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(71),m3h3x12(:,498),heltab2x36(:,:,498))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(619),h0tab(:,619),[16,1,8,6],[nMZ,nMZ,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(107),m3h3x12(:,499),heltab2x36(:,:,499))
  Gcoeff(:)%j = (c(29)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(620),h0tab(:,620),[16,1,8,6],[nMH,nMH,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(72),m3h3x12(:,500),heltab2x36(:,:,500))
  Gcoeff(:)%j = (c(63)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(621),h0tab(:,621),[16,1,8,6],[nMZ,nMZ,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(73),m3h3x12(:,501),heltab2x36(:,:,501))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(622),h0tab(:,622),[16,6,1,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(108),m3h3x12(:,502),heltab2x36(:,:,502))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(623),h0tab(:,623),[16,6,1,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(1),m3h3x12(:,503),heltab2x36(:,:,503))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(624),h0tab(:,624),[16,6,1,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(109),m3h3x12(:,504),heltab2x36(:,:,504))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(625),h0tab(:,625),[16,6,1,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(110),m3h3x12(:,505),heltab2x36(:,:,505))
  Gcoeff(:)%j = (c(50)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(626),h0tab(:,626),[16,6,1,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(74),m3h3x12(:,506),heltab2x36(:,:,506))
  Gcoeff(:)%j = (c(61)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(627),h0tab(:,627),[16,6,1,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(75),m3h3x12(:,507),heltab2x36(:,:,507))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(628),h0tab(:,628),[16,6,1,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(3),m3h3x12(:,508),heltab2x36(:,:,508))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(629),h0tab(:,629),[16,6,1,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(76),m3h3x12(:,509),heltab2x36(:,:,509))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(630),h0tab(:,630),[16,6,1,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(77),m3h3x12(:,510),heltab2x36(:,:,510))
  Gcoeff(:)%j = (c(45)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(631),h0tab(:,631),[16,6,1,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(78),m3h3x12(:,511),heltab2x36(:,:,511))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(632),h0tab(:,632),[16,6,1,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(111),m3h3x12(:,512),heltab2x36(:,:,512))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(633),h0tab(:,633),[16,6,1,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(112),m3h3x12(:,513),heltab2x36(:,:,513))
  Gcoeff(:)%j = (c(35)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(634),h0tab(:,634),[16,6,1,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(79),m3h3x12(:,514),heltab2x36(:,:,514))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(635),h0tab(:,635),[16,1,6,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(113),m3h3x12(:,515),heltab2x36(:,:,515))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(636),h0tab(:,636),[16,1,6,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(115),m3h3x12(:,516),heltab2x36(:,:,516))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(637),h0tab(:,637),[16,1,6,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(116),m3h3x12(:,517),heltab2x36(:,:,517))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(638),h0tab(:,638),[16,1,6,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(117),m3h3x12(:,518),heltab2x36(:,:,518))
  Gcoeff(:)%j = (c(50)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(639),h0tab(:,639),[16,1,6,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(80),m3h3x12(:,519),heltab2x36(:,:,519))
  Gcoeff(:)%j = (c(61)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(640),h0tab(:,640),[16,1,6,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(81),m3h3x12(:,520),heltab2x36(:,:,520))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(641),h0tab(:,641),[16,1,6,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(82),m3h3x12(:,521),heltab2x36(:,:,521))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(642),h0tab(:,642),[16,1,6,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(118),m3h3x12(:,522),heltab2x36(:,:,522))
  Gcoeff(:)%j = (c(45)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(643),h0tab(:,643),[16,1,6,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(119),m3h3x12(:,523),heltab2x36(:,:,523))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(644),h0tab(:,644),[16,1,6,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(121),m3h3x12(:,524),heltab2x36(:,:,524))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(645),h0tab(:,645),[16,1,6,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(83),m3h3x12(:,525),heltab2x36(:,:,525))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(646),h0tab(:,646),[16,1,6,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(84),m3h3x12(:,526),heltab2x36(:,:,526))
  Gcoeff(:)%j = (c(35)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(647),h0tab(:,647),[16,1,6,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(85),m3h3x12(:,527),heltab2x36(:,:,527))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(648),h0tab(:,648),[17,4,2,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex1(:),G0H12(86),m4h3x1x12(:,1),heltab3x36(:,:,121))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(649),h0tab(:,649),[17,4,2,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex1(:),G0H12(87),m4h3x1x12(:,2),heltab3x36(:,:,122))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(650),h0tab(:,650),[17,4,2,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SSV_V(ntryL,G0H36(1),ex1(:),ex5(:),G0H12(88),m4h1x3x12(:,1),heltab3x36(:,:,123))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(651),h0tab(:,651),[17,4,2,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex1(:),G0H12(89),m4h3x1x12(:,3),heltab3x36(:,:,124))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(652),h0tab(:,652),[17,4,2,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex1(:),G0H12(90),m4h3x1x12(:,4),heltab3x36(:,:,125))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(653),h0tab(:,653),[17,4,2,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SSV_V(ntryL,G0H36(1),ex1(:),ex5(:),G0H12(91),m4h1x3x12(:,2),heltab3x36(:,:,126))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(654),h0tab(:,654),[17,4,2,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex1(:),G0H12(92),m4h3x1x12(:,5),heltab3x36(:,:,127))
  Gcoeff(:)%j = (c(64)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(655),h0tab(:,655),[17,4,2,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex1(:),G0H12(93),m4h3x1x12(:,6),heltab3x36(:,:,128))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(656),h0tab(:,656),[17,4,2,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SSV_V(ntryL,G0H36(1),ex1(:),ex5(:),G0H12(94),m4h1x3x12(:,3),heltab3x36(:,:,129))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(657),h0tab(:,657),[17,4,2,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex1(:),G0H12(95),m4h3x1x12(:,7),heltab3x36(:,:,130))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(658),h0tab(:,658),[17,4,2,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex1(:),G0H12(96),m4h3x1x12(:,8),heltab3x36(:,:,131))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(659),h0tab(:,659),[17,4,2,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SSV_V(ntryL,G0H36(1),ex1(:),ex5(:),G0H12(97),m4h1x3x12(:,4),heltab3x36(:,:,132))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(660),h0tab(:,660),[17,2,4,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex1(:),G0H12(98),m4h3x1x12(:,9),heltab3x36(:,:,133))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(661),h0tab(:,661),[17,2,4,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex1(:),G0H12(99),m4h3x1x12(:,10),heltab3x36(:,:,134))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(662),h0tab(:,662),[17,2,4,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SSV_V(ntryL,G0H36(1),ex1(:),ex5(:),G0H12(100),m4h1x3x12(:,5),heltab3x36(:,:,135))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(663),h0tab(:,663),[17,2,4,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex1(:),G0H12(101),m4h3x1x12(:,11),heltab3x36(:,:,136))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(664),h0tab(:,664),[17,2,4,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex1(:),G0H12(102),m4h3x1x12(:,12),heltab3x36(:,:,137))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(665),h0tab(:,665),[17,2,4,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SSV_V(ntryL,G0H36(1),ex1(:),ex5(:),G0H12(103),m4h1x3x12(:,6),heltab3x36(:,:,138))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(666),h0tab(:,666),[17,2,4,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex1(:),G0H12(104),m4h3x1x12(:,13),heltab3x36(:,:,139))
  Gcoeff(:)%j = (c(64)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(667),h0tab(:,667),[17,2,4,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex1(:),G0H12(105),m4h3x1x12(:,14),heltab3x36(:,:,140))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(668),h0tab(:,668),[17,2,4,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SSV_V(ntryL,G0H36(1),ex1(:),ex5(:),G0H12(106),m4h1x3x12(:,7),heltab3x36(:,:,141))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(669),h0tab(:,669),[17,2,4,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex1(:),G0H12(107),m4h3x1x12(:,15),heltab3x36(:,:,142))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(670),h0tab(:,670),[17,2,4,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VVS_S(ntryL,G0H36(1),ex5(:),ex1(:),G0H12(108),m4h3x1x12(:,16),heltab3x36(:,:,143))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(671),h0tab(:,671),[17,2,4,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SSV_V(ntryL,G0H36(1),ex1(:),ex5(:),G0H12(109),m4h1x3x12(:,8),heltab3x36(:,:,144))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(672),h0tab(:,672),[16,2,4,9],[nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(110),m3h3x12(:,528),heltab2x36(:,:,528))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(673),h0tab(:,673),[16,2,4,9],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(111),m3h3x12(:,529),heltab2x36(:,:,529))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(674),h0tab(:,674),[16,2,4,9],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(122),m3h3x12(:,530),heltab2x36(:,:,530))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(675),h0tab(:,675),[16,2,4,9],[nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(123),m3h3x12(:,531),heltab2x36(:,:,531))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(676),h0tab(:,676),[16,2,4,9],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(124),m3h3x12(:,532),heltab2x36(:,:,532))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(677),h0tab(:,677),[16,2,4,9],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(112),m3h3x12(:,533),heltab2x36(:,:,533))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(678),h0tab(:,678),[16,2,4,9],[nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(113),m3h3x12(:,534),heltab2x36(:,:,534))
  Gcoeff(:)%j = (c(64)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(679),h0tab(:,679),[16,2,4,9],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(114),m3h3x12(:,535),heltab2x36(:,:,535))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(680),h0tab(:,680),[16,2,4,9],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(125),m3h3x12(:,536),heltab2x36(:,:,536))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(681),h0tab(:,681),[16,2,4,9],[nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(127),m3h3x12(:,537),heltab2x36(:,:,537))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(682),h0tab(:,682),[16,2,4,9],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(128),m3h3x12(:,538),heltab2x36(:,:,538))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(683),h0tab(:,683),[16,2,4,9],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(115),m3h3x12(:,539),heltab2x36(:,:,539))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(684),h0tab(:,684),[16,4,2,9],[nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(116),m3h3x12(:,540),heltab2x36(:,:,540))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(685),h0tab(:,685),[16,4,2,9],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(117),m3h3x12(:,541),heltab2x36(:,:,541))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(686),h0tab(:,686),[16,4,2,9],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(129),m3h3x12(:,542),heltab2x36(:,:,542))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(687),h0tab(:,687),[16,4,2,9],[nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(130),m3h3x12(:,543),heltab2x36(:,:,543))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(688),h0tab(:,688),[16,4,2,9],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(131),m3h3x12(:,544),heltab2x36(:,:,544))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(689),h0tab(:,689),[16,4,2,9],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(118),m3h3x12(:,545),heltab2x36(:,:,545))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(690),h0tab(:,690),[16,4,2,9],[nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(119),m3h3x12(:,546),heltab2x36(:,:,546))
  Gcoeff(:)%j = (c(64)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(691),h0tab(:,691),[16,4,2,9],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(120),m3h3x12(:,547),heltab2x36(:,:,547))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(692),h0tab(:,692),[16,4,2,9],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(133),m3h3x12(:,548),heltab2x36(:,:,548))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(693),h0tab(:,693),[16,4,2,9],[nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(134),m3h3x12(:,549),heltab2x36(:,:,549))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(694),h0tab(:,694),[16,4,2,9],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(135),m3h3x12(:,550),heltab2x36(:,:,550))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(695),h0tab(:,695),[16,4,2,9],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(121),m3h3x12(:,551),heltab2x36(:,:,551))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(696),h0tab(:,696),[16,5,2,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(122),m3h3x12(:,552),heltab2x36(:,:,552))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(697),h0tab(:,697),[16,5,2,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(136),m3h3x12(:,553),heltab2x36(:,:,553))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(698),h0tab(:,698),[16,5,2,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(137),m3h3x12(:,554),heltab2x36(:,:,554))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(699),h0tab(:,699),[16,5,2,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(139),m3h3x12(:,555),heltab2x36(:,:,555))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(700),h0tab(:,700),[16,5,2,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(140),m3h3x12(:,556),heltab2x36(:,:,556))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(701),h0tab(:,701),[16,5,2,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(123),m3h3x12(:,557),heltab2x36(:,:,557))
  Gcoeff(:)%j = (c(64)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(702),h0tab(:,702),[16,5,2,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(124),m3h3x12(:,558),heltab2x36(:,:,558))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(703),h0tab(:,703),[16,5,2,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(125),m3h3x12(:,559),heltab2x36(:,:,559))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(704),h0tab(:,704),[16,5,2,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(141),m3h3x12(:,560),heltab2x36(:,:,560))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(705),h0tab(:,705),[16,5,2,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(142),m3h3x12(:,561),heltab2x36(:,:,561))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(706),h0tab(:,706),[16,5,2,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(143),m3h3x12(:,562),heltab2x36(:,:,562))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(707),h0tab(:,707),[16,5,2,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(126),m3h3x12(:,563),heltab2x36(:,:,563))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(708),h0tab(:,708),[16,5,2,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(127),m3h3x12(:,564),heltab2x36(:,:,564))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(709),h0tab(:,709),[16,2,5,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(144),m3h3x12(:,565),heltab2x36(:,:,565))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(710),h0tab(:,710),[16,2,5,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(35),m3h3x12(:,566),heltab2x36(:,:,566))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(711),h0tab(:,711),[16,2,5,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(145),m3h3x12(:,567),heltab2x36(:,:,567))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(712),h0tab(:,712),[16,2,5,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(128),m3h3x12(:,568),heltab2x36(:,:,568))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(713),h0tab(:,713),[16,2,5,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(129),m3h3x12(:,569),heltab2x36(:,:,569))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(714),h0tab(:,714),[16,2,5,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(130),m3h3x12(:,570),heltab2x36(:,:,570))
  Gcoeff(:)%j = (c(64)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(715),h0tab(:,715),[16,2,5,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(131),m3h3x12(:,571),heltab2x36(:,:,571))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(716),h0tab(:,716),[16,2,5,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(132),m3h3x12(:,572),heltab2x36(:,:,572))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(717),h0tab(:,717),[16,2,5,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(133),m3h3x12(:,573),heltab2x36(:,:,573))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(718),h0tab(:,718),[16,2,5,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(146),m3h3x12(:,574),heltab2x36(:,:,574))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(719),h0tab(:,719),[16,2,5,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(147),m3h3x12(:,575),heltab2x36(:,:,575))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(720),h0tab(:,720),[16,2,5,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(149),m3h3x12(:,576),heltab2x36(:,:,576))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(721),h0tab(:,721),[16,2,5,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(150),m3h3x12(:,577),heltab2x36(:,:,577))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(722),h0tab(:,722),[16,3,4,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(134),m3h3x12(:,578),heltab2x36(:,:,578))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(723),h0tab(:,723),[16,3,4,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(151),m3h3x12(:,579),heltab2x36(:,:,579))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(724),h0tab(:,724),[16,3,4,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(152),m3h3x12(:,580),heltab2x36(:,:,580))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(725),h0tab(:,725),[16,3,4,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(153),m3h3x12(:,581),heltab2x36(:,:,581))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(726),h0tab(:,726),[16,3,4,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(155),m3h3x12(:,582),heltab2x36(:,:,582))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(727),h0tab(:,727),[16,3,4,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(135),m3h3x12(:,583),heltab2x36(:,:,583))
  Gcoeff(:)%j = (c(64)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(728),h0tab(:,728),[16,3,4,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(136),m3h3x12(:,584),heltab2x36(:,:,584))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(729),h0tab(:,729),[16,3,4,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(137),m3h3x12(:,585),heltab2x36(:,:,585))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(730),h0tab(:,730),[16,3,4,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(156),m3h3x12(:,586),heltab2x36(:,:,586))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(731),h0tab(:,731),[16,3,4,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(157),m3h3x12(:,587),heltab2x36(:,:,587))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(732),h0tab(:,732),[16,3,4,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(158),m3h3x12(:,588),heltab2x36(:,:,588))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(733),h0tab(:,733),[16,3,4,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(138),m3h3x12(:,589),heltab2x36(:,:,589))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(734),h0tab(:,734),[16,3,4,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(139),m3h3x12(:,590),heltab2x36(:,:,590))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(735),h0tab(:,735),[16,4,3,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(159),m3h3x12(:,591),heltab2x36(:,:,591))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(736),h0tab(:,736),[16,4,3,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(161),m3h3x12(:,592),heltab2x36(:,:,592))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(737),h0tab(:,737),[16,4,3,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(162),m3h3x12(:,593),heltab2x36(:,:,593))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(738),h0tab(:,738),[16,4,3,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(140),m3h3x12(:,594),heltab2x36(:,:,594))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(739),h0tab(:,739),[16,4,3,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(141),m3h3x12(:,595),heltab2x36(:,:,595))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(740),h0tab(:,740),[16,4,3,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(142),m3h3x12(:,596),heltab2x36(:,:,596))
  Gcoeff(:)%j = (c(64)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(741),h0tab(:,741),[16,4,3,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(143),m3h3x12(:,597),heltab2x36(:,:,597))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(742),h0tab(:,742),[16,4,3,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(144),m3h3x12(:,598),heltab2x36(:,:,598))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(743),h0tab(:,743),[16,4,3,8],[nMW,nMW,nMW,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(145),m3h3x12(:,599),heltab2x36(:,:,599))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(744),h0tab(:,744),[16,4,3,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(163),m3h3x12(:,600),heltab2x36(:,:,600))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(745),h0tab(:,745),[16,4,3,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(164),m3h3x12(:,601),heltab2x36(:,:,601))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(746),h0tab(:,746),[16,4,3,8],[nMW,nMW,nMW,0],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(165),m3h3x12(:,602),heltab2x36(:,:,602))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(747),h0tab(:,747),[16,4,3,8],[nMW,nMW,nMW,nMZ],5,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(167),m3h3x12(:,603),heltab2x36(:,:,603))
  Gcoeff(:)%j = (-(c(133)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(748),h0tab(:,748),[16,2,4,9],[nML,nML,nML,0],4,1,wf3(:,3))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(146),m3h3x12(:,604),heltab2x36(:,:,604))
  call Hloop_A_Q(ntryL,G0H12(146),16,nML,G1H12(168),n2h12(81))
  Gcoeff(:)%j = (-(c(115)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(749),h0tab(:,749),[16,2,4,9],[nMT,nMT,nMT,nMB],4,1,wf3(:,3))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(147),m3h3x12(:,605),heltab2x36(:,:,605))
  call Hloop_Q_A(ntryL,G0H12(147),16,nMT,G1H12(169),n2h12(82))
  Gcoeff(:)%j = (-(c(112)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(750),h0tab(:,750),[16,2,4,9],[nMB,nMB,nMB,nMT],4,1,wf3(:,3))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(148),m3h3x12(:,606),heltab2x36(:,:,606))
  call Hloop_A_Q(ntryL,G0H12(148),16,nMB,G1H12(170),n2h12(83))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(751),h0tab(:,751),[16,2,4,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(171),m3h3x12(:,607),heltab2x36(:,:,607))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(752),h0tab(:,752),[16,2,4,9],[nMW,nMW,nMW,0],4,1,wf3(:,3))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(173),m3h3x12(:,608),heltab2x36(:,:,608))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(753),h0tab(:,753),[16,2,4,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,3))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(174),m3h3x12(:,609),heltab2x36(:,:,609))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(754),h0tab(:,754),[16,2,4,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,3))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(175),m3h3x12(:,610),heltab2x36(:,:,610))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(755),h0tab(:,755),[16,2,4,9],[nMW,nMW,nMW,0],4,1,wf3(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(176),m3h3x12(:,611),heltab2x36(:,:,611))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(756),h0tab(:,756),[16,2,4,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(177),m3h3x12(:,612),heltab2x36(:,:,612))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(757),h0tab(:,757),[16,2,4,9],[nMW,nMW,nMW,0],4,1,wf3(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(149),m3h3x12(:,613),heltab2x36(:,:,613))
  Gcoeff(:)%j = (c(91)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(758),h0tab(:,758),[16,2,4,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(150),m3h3x12(:,614),heltab2x36(:,:,614))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(759),h0tab(:,759),[16,2,4,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(179),m3h3x12(:,615),heltab2x36(:,:,615))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(760),h0tab(:,760),[16,2,4,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(180),m3h3x12(:,616),heltab2x36(:,:,616))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(761),h0tab(:,761),[16,2,4,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(151),m3h3x12(:,617),heltab2x36(:,:,617))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(762),h0tab(:,762),[16,2,4,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(181),m3h3x12(:,618),heltab2x36(:,:,618))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(763),h0tab(:,763),[16,2,4,9],[nMW,nMW,nMW,0],4,1,wf3(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(152),m3h3x12(:,619),heltab2x36(:,:,619))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(764),h0tab(:,764),[16,2,4,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(153),m3h3x12(:,620),heltab2x36(:,:,620))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(765),h0tab(:,765),[16,2,4,9],[nMW,nMW,nMW,0],4,1,wf3(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(182),m3h3x12(:,621),heltab2x36(:,:,621))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(766),h0tab(:,766),[16,2,4,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(36),m3h3x12(:,622),heltab2x36(:,:,622))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(767),h0tab(:,767),[16,2,4,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(154),m3h3x12(:,623),heltab2x36(:,:,623))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(768),h0tab(:,768),[16,2,4,9],[nMW,nMW,nMW,0],4,1,wf3(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(155),m3h3x12(:,624),heltab2x36(:,:,624))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(769),h0tab(:,769),[16,2,4,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(156),m3h3x12(:,625),heltab2x36(:,:,625))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(770),h0tab(:,770),[16,2,4,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(37),m3h3x12(:,626),heltab2x36(:,:,626))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(771),h0tab(:,771),[16,2,4,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(184),m3h3x12(:,627),heltab2x36(:,:,627))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(772),h0tab(:,772),[16,2,4,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(157),m3h3x12(:,628),heltab2x36(:,:,628))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(773),h0tab(:,773),[16,2,4,9],[nMW,nMW,nMW,0],4,1,wf3(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(38),m3h3x12(:,629),heltab2x36(:,:,629))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(774),h0tab(:,774),[16,2,4,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(185),m3h3x12(:,630),heltab2x36(:,:,630))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(775),h0tab(:,775),[16,2,4,9],[nMW,nMW,nMW,0],4,1,wf3(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(158),m3h3x12(:,631),heltab2x36(:,:,631))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(776),h0tab(:,776),[16,2,4,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(159),m3h3x12(:,632),heltab2x36(:,:,632))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(777),h0tab(:,777),[16,2,4,9],[nMW,nMW,nMW,0],4,1,wf3(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(186),m3h3x12(:,633),heltab2x36(:,:,633))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(778),h0tab(:,778),[16,2,4,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(188),m3h3x12(:,634),heltab2x36(:,:,634))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(779),h0tab(:,779),[16,2,4,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(160),m3h3x12(:,635),heltab2x36(:,:,635))
  Gcoeff(:)%j = (-(c(162)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(780),h0tab(:,780),[16,2,4,9],[0,0,0,0],4,1,wf3(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(161),m3h3x12(:,636),heltab2x36(:,:,636))
  call Hloop_A_Q(ntryL,G0H12(161),16,0,G1H12(189),n2h12(84))
  Gcoeff(:)%j = (-(c(159)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(781),h0tab(:,781),[16,2,4,9],[nML,nML,nML,0],4,1,wf3(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(162),m3h3x12(:,637),heltab2x36(:,:,637))
  call Hloop_A_Q(ntryL,G0H12(162),16,nML,G1H12(190),n2h12(85))
  Gcoeff(:)%j = (-(c(158)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(782),h0tab(:,782),[16,2,4,9],[0,0,0,0],4,1,wf3(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(163),m3h3x12(:,638),heltab2x36(:,:,638))
  call Hloop_Q_A(ntryL,G0H12(163),16,0,G1H12(191),n2h12(86))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(783),h0tab(:,783),[16,2,4,9],[nMT,nMT,nMT,nMB],4,1,wf3(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(164),m3h3x12(:,639),heltab2x36(:,:,639))
  call Hloop_Q_A(ntryL,G0H12(164),16,nMT,G1H12(192),n2h12(87))
  Gcoeff(:)%j = (-(c(152)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(784),h0tab(:,784),[16,2,4,9],[0,0,0,0],4,1,wf3(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(1),m3h3x12(:,640),heltab2x36(:,:,640))
  call Hloop_A_Q(ntryL,G0H12(1),16,0,G1H12(194),n2h12(88))
  Gcoeff(:)%j = (-(c(150)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(785),h0tab(:,785),[16,2,4,9],[nMB,nMB,nMB,nMT],4,1,wf3(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(2),m3h3x12(:,641),heltab2x36(:,:,641))
  call Hloop_A_Q(ntryL,G0H12(2),16,nMB,G1H12(195),n2h12(89))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(786),h0tab(:,786),[16,2,4,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(196),m3h3x12(:,642),heltab2x36(:,:,642))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(787),h0tab(:,787),[16,2,4,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(197),m3h3x12(:,643),heltab2x36(:,:,643))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(788),h0tab(:,788),[16,2,4,9],[nMW,nMW,nMW,0],4,1,wf3(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(198),m3h3x12(:,644),heltab2x36(:,:,644))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(789),h0tab(:,789),[16,2,4,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(200),m3h3x12(:,645),heltab2x36(:,:,645))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(790),h0tab(:,790),[16,2,4,9],[nMW,nMW,nMW,0],4,1,wf3(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(201),m3h3x12(:,646),heltab2x36(:,:,646))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(791),h0tab(:,791),[16,2,4,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(202),m3h3x12(:,647),heltab2x36(:,:,647))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(792),h0tab(:,792),[16,2,4,9],[nMW,nMW,nMW,0],4,1,wf3(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(203),m3h3x12(:,648),heltab2x36(:,:,648))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(793),h0tab(:,793),[16,2,4,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(204),m3h3x12(:,649),heltab2x36(:,:,649))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(794),h0tab(:,794),[16,2,4,9],[nMW,nMW,nMW,0],4,1,wf3(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(7),m3h3x12(:,650),heltab2x36(:,:,650))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(795),h0tab(:,795),[16,2,4,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(3),m3h3x12(:,651),heltab2x36(:,:,651))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(796),h0tab(:,796),[16,2,4,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(206),m3h3x12(:,652),heltab2x36(:,:,652))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(797),h0tab(:,797),[16,2,4,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(4),m3h3x12(:,653),heltab2x36(:,:,653))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(798),h0tab(:,798),[16,2,4,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(207),m3h3x12(:,654),heltab2x36(:,:,654))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(799),h0tab(:,799),[16,2,4,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(208),m3h3x12(:,655),heltab2x36(:,:,655))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(800),h0tab(:,800),[16,2,4,9],[nMW,nMW,nMW,0],4,1,wf3(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(5),m3h3x12(:,656),heltab2x36(:,:,656))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(801),h0tab(:,801),[16,2,4,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(6),m3h3x12(:,657),heltab2x36(:,:,657))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(802),h0tab(:,802),[16,2,4,9],[nMW,nMW,nMW,0],4,1,wf3(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(209),m3h3x12(:,658),heltab2x36(:,:,658))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(803),h0tab(:,803),[16,2,4,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(210),m3h3x12(:,659),heltab2x36(:,:,659))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(804),h0tab(:,804),[16,2,4,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(10),m3h3x12(:,660),heltab2x36(:,:,660))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(805),h0tab(:,805),[16,2,4,9],[nMW,nMW,nMW,0],4,1,wf3(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(11),m3h3x12(:,661),heltab2x36(:,:,661))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(806),h0tab(:,806),[16,2,4,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(8),m3h3x12(:,662),heltab2x36(:,:,662))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(807),h0tab(:,807),[16,2,4,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(212),m3h3x12(:,663),heltab2x36(:,:,663))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(808),h0tab(:,808),[16,2,4,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(9),m3h3x12(:,664),heltab2x36(:,:,664))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(809),h0tab(:,809),[16,2,4,9],[nMW,nMW,nMW,0],4,1,wf3(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(213),m3h3x12(:,665),heltab2x36(:,:,665))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(810),h0tab(:,810),[16,2,4,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(214),m3h3x12(:,666),heltab2x36(:,:,666))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(811),h0tab(:,811),[16,2,4,9],[nMW,nMW,nMW,0],4,1,wf3(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(12),m3h3x12(:,667),heltab2x36(:,:,667))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(812),h0tab(:,812),[16,2,4,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(13),m3h3x12(:,668),heltab2x36(:,:,668))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(813),h0tab(:,813),[16,2,4,9],[nMW,nMW,nMW,0],4,1,wf3(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(215),m3h3x12(:,669),heltab2x36(:,:,669))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(814),h0tab(:,814),[16,2,4,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(216),m3h3x12(:,670),heltab2x36(:,:,670))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(815),h0tab(:,815),[16,2,4,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(14),m3h3x12(:,671),heltab2x36(:,:,671))
  Gcoeff(:)%j = (-(c(133)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(816),h0tab(:,816),[16,4,2,9],[nML,nML,nML,0],4,1,wf3(:,3))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(19),m3h3x12(:,672),heltab2x36(:,:,672))
  call Hloop_A_Q(ntryL,G0H12(19),16,nML,G1H12(69),n2h12(90))
  Gcoeff(:)%j = (-(c(115)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(817),h0tab(:,817),[16,4,2,9],[nMT,nMT,nMT,nMB],4,1,wf3(:,3))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(15),m3h3x12(:,673),heltab2x36(:,:,673))
  call Hloop_Q_A(ntryL,G0H12(15),16,nMT,G1H12(218),n2h12(91))
  Gcoeff(:)%j = (-(c(112)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(818),h0tab(:,818),[16,4,2,9],[nMB,nMB,nMB,nMT],4,1,wf3(:,3))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(16),m3h3x12(:,674),heltab2x36(:,:,674))
  call Hloop_A_Q(ntryL,G0H12(16),16,nMB,G1H12(70),n2h12(92))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(819),h0tab(:,819),[16,4,2,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(219),m3h3x12(:,675),heltab2x36(:,:,675))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(820),h0tab(:,820),[16,4,2,9],[nMW,nMW,nMW,0],4,1,wf3(:,3))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(71),m3h3x12(:,676),heltab2x36(:,:,676))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(821),h0tab(:,821),[16,4,2,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,3))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(72),m3h3x12(:,677),heltab2x36(:,:,677))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(822),h0tab(:,822),[16,4,2,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,3))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(221),m3h3x12(:,678),heltab2x36(:,:,678))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(823),h0tab(:,823),[16,4,2,9],[nMW,nMW,nMW,0],4,1,wf3(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(222),m3h3x12(:,679),heltab2x36(:,:,679))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(824),h0tab(:,824),[16,4,2,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(223),m3h3x12(:,680),heltab2x36(:,:,680))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(825),h0tab(:,825),[16,4,2,9],[nMW,nMW,nMW,0],4,1,wf3(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(17),m3h3x12(:,681),heltab2x36(:,:,681))
  Gcoeff(:)%j = (c(91)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(826),h0tab(:,826),[16,4,2,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(18),m3h3x12(:,682),heltab2x36(:,:,682))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(827),h0tab(:,827),[16,4,2,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(22),m3h3x12(:,683),heltab2x36(:,:,683))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(828),h0tab(:,828),[16,4,2,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(224),m3h3x12(:,684),heltab2x36(:,:,684))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(829),h0tab(:,829),[16,4,2,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(226),m3h3x12(:,685),heltab2x36(:,:,685))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(830),h0tab(:,830),[16,4,2,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(227),m3h3x12(:,686),heltab2x36(:,:,686))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(831),h0tab(:,831),[16,4,2,9],[nMW,nMW,nMW,0],4,1,wf3(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(228),m3h3x12(:,687),heltab2x36(:,:,687))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(832),h0tab(:,832),[16,4,2,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(229),m3h3x12(:,688),heltab2x36(:,:,688))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(833),h0tab(:,833),[16,4,2,9],[nMW,nMW,nMW,0],4,1,wf3(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(23),m3h3x12(:,689),heltab2x36(:,:,689))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(834),h0tab(:,834),[16,4,2,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(20),m3h3x12(:,690),heltab2x36(:,:,690))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(835),h0tab(:,835),[16,4,2,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(21),m3h3x12(:,691),heltab2x36(:,:,691))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(836),h0tab(:,836),[16,4,2,9],[nMW,nMW,nMW,0],4,1,wf3(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(24),m3h3x12(:,692),heltab2x36(:,:,692))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(837),h0tab(:,837),[16,4,2,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(28),m3h3x12(:,693),heltab2x36(:,:,693))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(838),h0tab(:,838),[16,4,2,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(30),m3h3x12(:,694),heltab2x36(:,:,694))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(839),h0tab(:,839),[16,4,2,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(230),m3h3x12(:,695),heltab2x36(:,:,695))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(840),h0tab(:,840),[16,4,2,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(232),m3h3x12(:,696),heltab2x36(:,:,696))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(841),h0tab(:,841),[16,4,2,9],[nMW,nMW,nMW,0],4,1,wf3(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(233),m3h3x12(:,697),heltab2x36(:,:,697))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(842),h0tab(:,842),[16,4,2,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(234),m3h3x12(:,698),heltab2x36(:,:,698))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(843),h0tab(:,843),[16,4,2,9],[nMW,nMW,nMW,0],4,1,wf3(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(235),m3h3x12(:,699),heltab2x36(:,:,699))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(844),h0tab(:,844),[16,4,2,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(236),m3h3x12(:,700),heltab2x36(:,:,700))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(845),h0tab(:,845),[16,4,2,9],[nMW,nMW,nMW,0],4,1,wf3(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(31),m3h3x12(:,701),heltab2x36(:,:,701))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(846),h0tab(:,846),[16,4,2,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(32),m3h3x12(:,702),heltab2x36(:,:,702))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(847),h0tab(:,847),[16,4,2,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(36),m3h3x12(:,703),heltab2x36(:,:,703))
  Gcoeff(:)%j = (-(c(162)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(848),h0tab(:,848),[16,4,2,9],[0,0,0,0],4,1,wf3(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(38),m3h3x12(:,704),heltab2x36(:,:,704))
  call Hloop_A_Q(ntryL,G0H12(38),16,0,G1H12(238),n2h12(93))
  Gcoeff(:)%j = (-(c(159)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(849),h0tab(:,849),[16,4,2,9],[nML,nML,nML,0],4,1,wf3(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(39),m3h3x12(:,705),heltab2x36(:,:,705))
  call Hloop_A_Q(ntryL,G0H12(39),16,nML,G1H12(239),n2h12(94))
  Gcoeff(:)%j = (-(c(158)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(850),h0tab(:,850),[16,4,2,9],[0,0,0,0],4,1,wf3(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(40),m3h3x12(:,706),heltab2x36(:,:,706))
  call Hloop_Q_A(ntryL,G0H12(40),16,0,G1H12(87),n2h12(95))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(851),h0tab(:,851),[16,4,2,9],[nMT,nMT,nMT,nMB],4,1,wf3(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(25),m3h3x12(:,707),heltab2x36(:,:,707))
  call Hloop_Q_A(ntryL,G0H12(25),16,nMT,G1H12(240),n2h12(96))
  Gcoeff(:)%j = (-(c(152)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(852),h0tab(:,852),[16,4,2,9],[0,0,0,0],4,1,wf3(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(26),m3h3x12(:,708),heltab2x36(:,:,708))
  call Hloop_A_Q(ntryL,G0H12(26),16,0,G1H12(88),n2h12(97))
  Gcoeff(:)%j = (-(c(150)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(853),h0tab(:,853),[16,4,2,9],[nMB,nMB,nMB,nMT],4,1,wf3(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(27),m3h3x12(:,709),heltab2x36(:,:,709))
  call Hloop_A_Q(ntryL,G0H12(27),16,nMB,G1H12(242),n2h12(98))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(854),h0tab(:,854),[16,4,2,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(243),m3h3x12(:,710),heltab2x36(:,:,710))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(855),h0tab(:,855),[16,4,2,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(244),m3h3x12(:,711),heltab2x36(:,:,711))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(856),h0tab(:,856),[16,4,2,9],[nMW,nMW,nMW,0],4,1,wf3(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(245),m3h3x12(:,712),heltab2x36(:,:,712))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(857),h0tab(:,857),[16,4,2,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(246),m3h3x12(:,713),heltab2x36(:,:,713))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(858),h0tab(:,858),[16,4,2,9],[nMW,nMW,nMW,0],4,1,wf3(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(248),m3h3x12(:,714),heltab2x36(:,:,714))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(859),h0tab(:,859),[16,4,2,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(249),m3h3x12(:,715),heltab2x36(:,:,715))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(860),h0tab(:,860),[16,4,2,9],[nMW,nMW,nMW,0],4,1,wf3(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(250),m3h3x12(:,716),heltab2x36(:,:,716))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(861),h0tab(:,861),[16,4,2,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(251),m3h3x12(:,717),heltab2x36(:,:,717))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(862),h0tab(:,862),[16,4,2,9],[nMW,nMW,nMW,0],4,1,wf3(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(29),m3h3x12(:,718),heltab2x36(:,:,718))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(863),h0tab(:,863),[16,4,2,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(33),m3h3x12(:,719),heltab2x36(:,:,719))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(864),h0tab(:,864),[16,4,2,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(34),m3h3x12(:,720),heltab2x36(:,:,720))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(865),h0tab(:,865),[16,4,2,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(252),m3h3x12(:,721),heltab2x36(:,:,721))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(866),h0tab(:,866),[16,4,2,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(254),m3h3x12(:,722),heltab2x36(:,:,722))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(867),h0tab(:,867),[16,4,2,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(255),m3h3x12(:,723),heltab2x36(:,:,723))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(868),h0tab(:,868),[16,4,2,9],[nMW,nMW,nMW,0],4,1,wf3(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(256),m3h3x12(:,724),heltab2x36(:,:,724))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(869),h0tab(:,869),[16,4,2,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(257),m3h3x12(:,725),heltab2x36(:,:,725))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(870),h0tab(:,870),[16,4,2,9],[nMW,nMW,nMW,0],4,1,wf3(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(35),m3h3x12(:,726),heltab2x36(:,:,726))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(871),h0tab(:,871),[16,4,2,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(37),m3h3x12(:,727),heltab2x36(:,:,727))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(872),h0tab(:,872),[16,4,2,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(146),m3h3x12(:,728),heltab2x36(:,:,728))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(873),h0tab(:,873),[16,4,2,9],[nMW,nMW,nMW,0],4,1,wf3(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(147),m3h3x12(:,729),heltab2x36(:,:,729))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(874),h0tab(:,874),[16,4,2,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(148),m3h3x12(:,730),heltab2x36(:,:,730))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(875),h0tab(:,875),[16,4,2,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(161),m3h3x12(:,731),heltab2x36(:,:,731))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(876),h0tab(:,876),[16,4,2,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(258),m3h3x12(:,732),heltab2x36(:,:,732))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(877),h0tab(:,877),[16,4,2,9],[nMW,nMW,nMW,0],4,1,wf3(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(10),m3h3x12(:,733),heltab2x36(:,:,733))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(878),h0tab(:,878),[16,4,2,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(11),m3h3x12(:,734),heltab2x36(:,:,734))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(879),h0tab(:,879),[16,4,2,9],[nMW,nMW,nMW,0],4,1,wf3(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(12),m3h3x12(:,735),heltab2x36(:,:,735))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(880),h0tab(:,880),[16,4,2,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(13),m3h3x12(:,736),heltab2x36(:,:,736))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(881),h0tab(:,881),[16,4,2,9],[nMW,nMW,nMW,0],4,1,wf3(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(162),m3h3x12(:,737),heltab2x36(:,:,737))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(882),h0tab(:,882),[16,4,2,9],[nMW,nMW,nMW,nMZ],4,1,wf3(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(163),m3h3x12(:,738),heltab2x36(:,:,738))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(883),h0tab(:,883),[16,4,2,9],[nMW,nMW,nMW,nMH],4,1,wf3(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(164),m3h3x12(:,739),heltab2x36(:,:,739))
  Gcoeff(:)%j = (c(113)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(884),h0tab(:,884),[16,2,9,4],[nMT,nMT,nMB,nMB],4,1,wf3(:,3))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(1),m3h3x12(:,740),heltab2x36(:,:,740))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMT,G1H12(16),n2h12(99))
  Gcoeff(:)%j = (c(113)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(885),h0tab(:,885),[16,2,9,4],[nMB,nMB,nMT,nMT],4,1,wf3(:,3))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(2),m3h3x12(:,741),heltab2x36(:,:,741))
  call Hloop_A_Q(ntryL,G0H12(2),16,nMB,G1H12(20),n2h12(100))
  Gcoeff(:)%j = (c(154)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(886),h0tab(:,886),[16,2,9,4],[0,0,0,0],4,1,wf3(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(19),m3h3x12(:,742),heltab2x36(:,:,742))
  call Hloop_Q_A(ntryL,G0H12(19),16,0,G1H12(22),n2h12(101))
  Gcoeff(:)%j = (c(152)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(887),h0tab(:,887),[16,2,9,4],[nMT,nMT,nMB,nMB],4,1,wf3(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(15),m3h3x12(:,743),heltab2x36(:,:,743))
  call Hloop_Q_A(ntryL,G0H12(15),16,nMT,G1H12(23),n2h12(102))
  Gcoeff(:)%j = (c(154)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(888),h0tab(:,888),[16,2,9,4],[0,0,0,0],4,1,wf3(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(16),m3h3x12(:,744),heltab2x36(:,:,744))
  call Hloop_A_Q(ntryL,G0H12(16),16,0,G1H12(24),n2h12(103))
  Gcoeff(:)%j = (c(152)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(889),h0tab(:,889),[16,2,9,4],[nMB,nMB,nMT,nMT],4,1,wf3(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(38),m3h3x12(:,745),heltab2x36(:,:,745))
  call Hloop_A_Q(ntryL,G0H12(38),16,nMB,G1H12(25),n2h12(104))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(890),h0tab(:,890),[16,1,4,10],[nML,nML,nML,0],4,1,wf6(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(39),m3h3x12(:,746),heltab2x36(:,:,746))
  call Hloop_A_Q(ntryL,G0H12(39),16,nML,G1H12(45),n2h12(105))
  Gcoeff(:)%j = (c(144)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(891),h0tab(:,891),[16,1,4,10],[nMT,nMT,nMT,nMB],4,1,wf6(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(40),m3h3x12(:,747),heltab2x36(:,:,747))
  call Hloop_Q_A(ntryL,G0H12(40),16,nMT,G1H12(46),n2h12(106))
  Gcoeff(:)%j = (-(c(121)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(892),h0tab(:,892),[16,1,4,10],[nMB,nMB,nMB,nMT],4,1,wf6(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(25),m3h3x12(:,748),heltab2x36(:,:,748))
  call Hloop_A_Q(ntryL,G0H12(25),16,nMB,G1H12(47),n2h12(107))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(893),h0tab(:,893),[16,1,4,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(48),m3h3x12(:,749),heltab2x36(:,:,749))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(894),h0tab(:,894),[16,1,4,10],[nMW,nMW,nMW,0],4,1,wf6(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(51),m3h3x12(:,750),heltab2x36(:,:,750))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(895),h0tab(:,895),[16,1,4,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(55),m3h3x12(:,751),heltab2x36(:,:,751))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(896),h0tab(:,896),[16,1,4,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(57),m3h3x12(:,752),heltab2x36(:,:,752))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(897),h0tab(:,897),[16,1,4,10],[nMW,nMW,nMW,0],4,1,wf6(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(58),m3h3x12(:,753),heltab2x36(:,:,753))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(898),h0tab(:,898),[16,1,4,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(59),m3h3x12(:,754),heltab2x36(:,:,754))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(899),h0tab(:,899),[16,1,4,10],[nMW,nMW,nMW,0],4,1,wf6(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(26),m3h3x12(:,755),heltab2x36(:,:,755))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(900),h0tab(:,900),[16,1,4,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(27),m3h3x12(:,756),heltab2x36(:,:,756))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(901),h0tab(:,901),[16,1,4,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(60),m3h3x12(:,757),heltab2x36(:,:,757))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(902),h0tab(:,902),[16,1,4,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(80),m3h3x12(:,758),heltab2x36(:,:,758))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(903),h0tab(:,903),[16,1,4,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(1),m3h3x12(:,759),heltab2x36(:,:,759))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(904),h0tab(:,904),[16,1,4,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(90),m3h3x12(:,760),heltab2x36(:,:,760))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(905),h0tab(:,905),[16,1,4,10],[nMW,nMW,nMW,0],4,1,wf6(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(2),m3h3x12(:,761),heltab2x36(:,:,761))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(906),h0tab(:,906),[16,1,4,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(19),m3h3x12(:,762),heltab2x36(:,:,762))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(907),h0tab(:,907),[16,1,4,10],[nMW,nMW,nMW,0],4,1,wf6(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(96),m3h3x12(:,763),heltab2x36(:,:,763))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(908),h0tab(:,908),[16,1,4,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(15),m3h3x12(:,764),heltab2x36(:,:,764))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(909),h0tab(:,909),[16,1,4,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(15),m3h3x12(:,765),heltab2x36(:,:,765))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(910),h0tab(:,910),[16,1,4,10],[nMW,nMW,nMW,0],4,1,wf6(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(16),m3h3x12(:,766),heltab2x36(:,:,766))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(911),h0tab(:,911),[16,1,4,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(38),m3h3x12(:,767),heltab2x36(:,:,767))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(912),h0tab(:,912),[16,1,4,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(5),m3h3x12(:,768),heltab2x36(:,:,768))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(913),h0tab(:,913),[16,1,4,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(7),m3h3x12(:,769),heltab2x36(:,:,769))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(914),h0tab(:,914),[16,1,4,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(39),m3h3x12(:,770),heltab2x36(:,:,770))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(915),h0tab(:,915),[16,1,4,10],[nMW,nMW,nMW,0],4,1,wf6(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(8),m3h3x12(:,771),heltab2x36(:,:,771))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(916),h0tab(:,916),[16,1,4,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(9),m3h3x12(:,772),heltab2x36(:,:,772))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(917),h0tab(:,917),[16,1,4,10],[nMW,nMW,nMW,0],4,1,wf6(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(40),m3h3x12(:,773),heltab2x36(:,:,773))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(918),h0tab(:,918),[16,1,4,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(25),m3h3x12(:,774),heltab2x36(:,:,774))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(919),h0tab(:,919),[16,1,4,10],[nMW,nMW,nMW,0],4,1,wf6(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(28),m3h3x12(:,775),heltab2x36(:,:,775))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(920),h0tab(:,920),[16,1,4,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(29),m3h3x12(:,776),heltab2x36(:,:,776))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(921),h0tab(:,921),[16,1,4,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(165),m3h3x12(:,777),heltab2x36(:,:,777))
  Gcoeff(:)%j = (c(133)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(922),h0tab(:,922),[16,1,4,10],[nML,nML,nML,0],4,1,wf6(:,20))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(166),m3h3x12(:,778),heltab2x36(:,:,778))
  call Hloop_A_Q(ntryL,G0H12(166),16,nML,G1H12(18),n2h12(108))
  Gcoeff(:)%j = (-(c(144)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(923),h0tab(:,923),[16,1,4,10],[nMT,nMT,nMT,nMB],4,1,wf6(:,20))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(166),m3h3x12(:,779),heltab2x36(:,:,779))
  call Hloop_Q_A(ntryL,G0H12(166),16,nMT,G1H12(14),n2h12(109))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(924),h0tab(:,924),[16,1,4,10],[nMB,nMB,nMB,nMT],4,1,wf6(:,20))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(166),m3h3x12(:,780),heltab2x36(:,:,780))
  call Hloop_A_Q(ntryL,G0H12(166),16,nMB,G1H12(21),n2h12(110))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(925),h0tab(:,925),[16,1,4,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,20))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(26),m3h3x12(:,781),heltab2x36(:,:,781))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(926),h0tab(:,926),[16,1,4,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,20))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(27),m3h3x12(:,782),heltab2x36(:,:,782))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(927),h0tab(:,927),[16,1,4,10],[nMW,nMW,nMW,0],4,1,wf6(:,20))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(31),m3h3x12(:,783),heltab2x36(:,:,783))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(928),h0tab(:,928),[16,1,4,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,20))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(32),m3h3x12(:,784),heltab2x36(:,:,784))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(929),h0tab(:,929),[16,1,4,10],[nMW,nMW,nMW,0],4,1,wf6(:,20))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(33),m3h3x12(:,785),heltab2x36(:,:,785))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(930),h0tab(:,930),[16,1,4,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,20))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(259),m3h3x12(:,786),heltab2x36(:,:,786))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(931),h0tab(:,931),[16,1,4,10],[nMW,nMW,nMW,0],4,1,wf6(:,20))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(260),m3h3x12(:,787),heltab2x36(:,:,787))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(932),h0tab(:,932),[16,1,4,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,20))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(261),m3h3x12(:,788),heltab2x36(:,:,788))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(933),h0tab(:,933),[16,1,4,10],[nMW,nMW,nMW,0],4,1,wf6(:,20))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(166),m3h3x12(:,789),heltab2x36(:,:,789))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(934),h0tab(:,934),[16,1,4,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,20))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(167),m3h3x12(:,790),heltab2x36(:,:,790))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(935),h0tab(:,935),[16,1,4,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,20))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(262),m3h3x12(:,791),heltab2x36(:,:,791))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(936),h0tab(:,936),[16,1,4,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,20))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(168),m3h3x12(:,792),heltab2x36(:,:,792))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(937),h0tab(:,937),[16,1,4,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,20))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(263),m3h3x12(:,793),heltab2x36(:,:,793))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(938),h0tab(:,938),[16,1,4,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,20))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(264),m3h3x12(:,794),heltab2x36(:,:,794))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(939),h0tab(:,939),[16,1,4,10],[nMW,nMW,nMW,0],4,1,wf6(:,20))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(169),m3h3x12(:,795),heltab2x36(:,:,795))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(940),h0tab(:,940),[16,1,4,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,20))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(170),m3h3x12(:,796),heltab2x36(:,:,796))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(941),h0tab(:,941),[16,1,4,10],[nMW,nMW,nMW,0],4,1,wf6(:,20))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(265),m3h3x12(:,797),heltab2x36(:,:,797))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(942),h0tab(:,942),[16,1,4,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,20))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(266),m3h3x12(:,798),heltab2x36(:,:,798))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(943),h0tab(:,943),[16,1,4,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,20))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(171),m3h3x12(:,799),heltab2x36(:,:,799))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(944),h0tab(:,944),[16,1,4,10],[nMW,nMW,nMW,0],4,1,wf6(:,20))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(172),m3h3x12(:,800),heltab2x36(:,:,800))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(945),h0tab(:,945),[16,1,4,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,20))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(173),m3h3x12(:,801),heltab2x36(:,:,801))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(946),h0tab(:,946),[16,1,4,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,20))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(267),m3h3x12(:,802),heltab2x36(:,:,802))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(947),h0tab(:,947),[16,1,4,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,20))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(174),m3h3x12(:,803),heltab2x36(:,:,803))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(948),h0tab(:,948),[16,1,4,10],[nMW,nMW,nMW,0],4,1,wf6(:,20))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(268),m3h3x12(:,804),heltab2x36(:,:,804))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(949),h0tab(:,949),[16,1,4,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,20))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(269),m3h3x12(:,805),heltab2x36(:,:,805))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(950),h0tab(:,950),[16,1,4,10],[nMW,nMW,nMW,0],4,1,wf6(:,20))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(175),m3h3x12(:,806),heltab2x36(:,:,806))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(951),h0tab(:,951),[16,1,4,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,20))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(176),m3h3x12(:,807),heltab2x36(:,:,807))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(952),h0tab(:,952),[16,1,4,10],[nMW,nMW,nMW,0],4,1,wf6(:,20))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(270),m3h3x12(:,808),heltab2x36(:,:,808))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(953),h0tab(:,953),[16,1,4,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,20))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(271),m3h3x12(:,809),heltab2x36(:,:,809))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(954),h0tab(:,954),[16,1,4,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,20))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(177),m3h3x12(:,810),heltab2x36(:,:,810))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(955),h0tab(:,955),[16,4,1,10],[nML,nML,nML,0],4,1,wf6(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(178),m3h3x12(:,811),heltab2x36(:,:,811))
  call Hloop_A_Q(ntryL,G0H12(178),16,nML,G1H12(272),n2h12(111))
  Gcoeff(:)%j = (c(144)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(956),h0tab(:,956),[16,4,1,10],[nMT,nMT,nMT,nMB],4,1,wf6(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(178),m3h3x12(:,812),heltab2x36(:,:,812))
  call Hloop_Q_A(ntryL,G0H12(178),16,nMT,G1H12(273),n2h12(112))
  Gcoeff(:)%j = (-(c(121)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(957),h0tab(:,957),[16,4,1,10],[nMB,nMB,nMB,nMT],4,1,wf6(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(178),m3h3x12(:,813),heltab2x36(:,:,813))
  call Hloop_A_Q(ntryL,G0H12(178),16,nMB,G1H12(274),n2h12(113))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(958),h0tab(:,958),[16,4,1,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(275),m3h3x12(:,814),heltab2x36(:,:,814))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(959),h0tab(:,959),[16,4,1,10],[nMW,nMW,nMW,0],4,1,wf6(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(276),m3h3x12(:,815),heltab2x36(:,:,815))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(960),h0tab(:,960),[16,4,1,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(277),m3h3x12(:,816),heltab2x36(:,:,816))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(961),h0tab(:,961),[16,4,1,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(278),m3h3x12(:,817),heltab2x36(:,:,817))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(962),h0tab(:,962),[16,4,1,10],[nMW,nMW,nMW,0],4,1,wf6(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(279),m3h3x12(:,818),heltab2x36(:,:,818))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(963),h0tab(:,963),[16,4,1,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(280),m3h3x12(:,819),heltab2x36(:,:,819))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(964),h0tab(:,964),[16,4,1,10],[nMW,nMW,nMW,0],4,1,wf6(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(178),m3h3x12(:,820),heltab2x36(:,:,820))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(965),h0tab(:,965),[16,4,1,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(179),m3h3x12(:,821),heltab2x36(:,:,821))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(966),h0tab(:,966),[16,4,1,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(180),m3h3x12(:,822),heltab2x36(:,:,822))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(967),h0tab(:,967),[16,4,1,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(281),m3h3x12(:,823),heltab2x36(:,:,823))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(968),h0tab(:,968),[16,4,1,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(282),m3h3x12(:,824),heltab2x36(:,:,824))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(969),h0tab(:,969),[16,4,1,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(283),m3h3x12(:,825),heltab2x36(:,:,825))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(970),h0tab(:,970),[16,4,1,10],[nMW,nMW,nMW,0],4,1,wf6(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(284),m3h3x12(:,826),heltab2x36(:,:,826))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(971),h0tab(:,971),[16,4,1,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(285),m3h3x12(:,827),heltab2x36(:,:,827))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(972),h0tab(:,972),[16,4,1,10],[nMW,nMW,nMW,0],4,1,wf6(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(181),m3h3x12(:,828),heltab2x36(:,:,828))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(973),h0tab(:,973),[16,4,1,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(182),m3h3x12(:,829),heltab2x36(:,:,829))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(974),h0tab(:,974),[16,4,1,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(183),m3h3x12(:,830),heltab2x36(:,:,830))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(975),h0tab(:,975),[16,4,1,10],[nMW,nMW,nMW,0],4,1,wf6(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(184),m3h3x12(:,831),heltab2x36(:,:,831))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(976),h0tab(:,976),[16,4,1,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(185),m3h3x12(:,832),heltab2x36(:,:,832))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(977),h0tab(:,977),[16,4,1,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(186),m3h3x12(:,833),heltab2x36(:,:,833))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(978),h0tab(:,978),[16,4,1,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(286),m3h3x12(:,834),heltab2x36(:,:,834))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(979),h0tab(:,979),[16,4,1,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(287),m3h3x12(:,835),heltab2x36(:,:,835))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(980),h0tab(:,980),[16,4,1,10],[nMW,nMW,nMW,0],4,1,wf6(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(288),m3h3x12(:,836),heltab2x36(:,:,836))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(981),h0tab(:,981),[16,4,1,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(289),m3h3x12(:,837),heltab2x36(:,:,837))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(982),h0tab(:,982),[16,4,1,10],[nMW,nMW,nMW,0],4,1,wf6(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(290),m3h3x12(:,838),heltab2x36(:,:,838))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(983),h0tab(:,983),[16,4,1,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(291),m3h3x12(:,839),heltab2x36(:,:,839))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(984),h0tab(:,984),[16,4,1,10],[nMW,nMW,nMW,0],4,1,wf6(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(187),m3h3x12(:,840),heltab2x36(:,:,840))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(985),h0tab(:,985),[16,4,1,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(188),m3h3x12(:,841),heltab2x36(:,:,841))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(986),h0tab(:,986),[16,4,1,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(189),m3h3x12(:,842),heltab2x36(:,:,842))
  Gcoeff(:)%j = (c(133)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(987),h0tab(:,987),[16,4,1,10],[nML,nML,nML,0],4,1,wf6(:,20))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(190),m3h3x12(:,843),heltab2x36(:,:,843))
  call Hloop_A_Q(ntryL,G0H12(190),16,nML,G1H12(292),n2h12(114))
  Gcoeff(:)%j = (-(c(144)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(988),h0tab(:,988),[16,4,1,10],[nMT,nMT,nMT,nMB],4,1,wf6(:,20))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(190),m3h3x12(:,844),heltab2x36(:,:,844))
  call Hloop_Q_A(ntryL,G0H12(190),16,nMT,G1H12(293),n2h12(115))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(989),h0tab(:,989),[16,4,1,10],[nMB,nMB,nMB,nMT],4,1,wf6(:,20))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(190),m3h3x12(:,845),heltab2x36(:,:,845))
  call Hloop_A_Q(ntryL,G0H12(190),16,nMB,G1H12(294),n2h12(116))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(990),h0tab(:,990),[16,4,1,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,20))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(295),m3h3x12(:,846),heltab2x36(:,:,846))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(991),h0tab(:,991),[16,4,1,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,20))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(296),m3h3x12(:,847),heltab2x36(:,:,847))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(992),h0tab(:,992),[16,4,1,10],[nMW,nMW,nMW,0],4,1,wf6(:,20))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(297),m3h3x12(:,848),heltab2x36(:,:,848))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(993),h0tab(:,993),[16,4,1,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,20))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(298),m3h3x12(:,849),heltab2x36(:,:,849))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(994),h0tab(:,994),[16,4,1,10],[nMW,nMW,nMW,0],4,1,wf6(:,20))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(299),m3h3x12(:,850),heltab2x36(:,:,850))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(995),h0tab(:,995),[16,4,1,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,20))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(300),m3h3x12(:,851),heltab2x36(:,:,851))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(996),h0tab(:,996),[16,4,1,10],[nMW,nMW,nMW,0],4,1,wf6(:,20))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(301),m3h3x12(:,852),heltab2x36(:,:,852))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(997),h0tab(:,997),[16,4,1,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,20))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(302),m3h3x12(:,853),heltab2x36(:,:,853))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(998),h0tab(:,998),[16,4,1,10],[nMW,nMW,nMW,0],4,1,wf6(:,20))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(190),m3h3x12(:,854),heltab2x36(:,:,854))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(999),h0tab(:,999),[16,4,1,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,20))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(191),m3h3x12(:,855),heltab2x36(:,:,855))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1000),h0tab(:,1000),[16,4,1,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,20))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(192),m3h3x12(:,856),heltab2x36(:,:,856))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1001),h0tab(:,1001),[16,4,1,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,20))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(303),m3h3x12(:,857),heltab2x36(:,:,857))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1002),h0tab(:,1002),[16,4,1,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,20))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(304),m3h3x12(:,858),heltab2x36(:,:,858))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1003),h0tab(:,1003),[16,4,1,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,20))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(305),m3h3x12(:,859),heltab2x36(:,:,859))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1004),h0tab(:,1004),[16,4,1,10],[nMW,nMW,nMW,0],4,1,wf6(:,20))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(306),m3h3x12(:,860),heltab2x36(:,:,860))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1005),h0tab(:,1005),[16,4,1,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,20))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(307),m3h3x12(:,861),heltab2x36(:,:,861))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1006),h0tab(:,1006),[16,4,1,10],[nMW,nMW,nMW,0],4,1,wf6(:,20))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(193),m3h3x12(:,862),heltab2x36(:,:,862))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1007),h0tab(:,1007),[16,4,1,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,20))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(194),m3h3x12(:,863),heltab2x36(:,:,863))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1008),h0tab(:,1008),[16,4,1,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,20))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(195),m3h3x12(:,864),heltab2x36(:,:,864))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1009),h0tab(:,1009),[16,4,1,10],[nMW,nMW,nMW,0],4,1,wf6(:,20))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(196),m3h3x12(:,865),heltab2x36(:,:,865))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1010),h0tab(:,1010),[16,4,1,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,20))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(197),m3h3x12(:,866),heltab2x36(:,:,866))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1011),h0tab(:,1011),[16,4,1,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,20))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(198),m3h3x12(:,867),heltab2x36(:,:,867))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1012),h0tab(:,1012),[16,4,1,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,20))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(308),m3h3x12(:,868),heltab2x36(:,:,868))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1013),h0tab(:,1013),[16,4,1,10],[nMW,nMW,nMW,0],4,1,wf6(:,20))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(309),m3h3x12(:,869),heltab2x36(:,:,869))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1014),h0tab(:,1014),[16,4,1,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,20))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(310),m3h3x12(:,870),heltab2x36(:,:,870))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1015),h0tab(:,1015),[16,4,1,10],[nMW,nMW,nMW,0],4,1,wf6(:,20))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(311),m3h3x12(:,871),heltab2x36(:,:,871))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1016),h0tab(:,1016),[16,4,1,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,20))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(312),m3h3x12(:,872),heltab2x36(:,:,872))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1017),h0tab(:,1017),[16,4,1,10],[nMW,nMW,nMW,0],4,1,wf6(:,20))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(199),m3h3x12(:,873),heltab2x36(:,:,873))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1018),h0tab(:,1018),[16,4,1,10],[nMW,nMW,nMW,nMZ],4,1,wf6(:,20))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(200),m3h3x12(:,874),heltab2x36(:,:,874))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1019),h0tab(:,1019),[16,4,1,10],[nMW,nMW,nMW,nMH],4,1,wf6(:,20))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(201),m3h3x12(:,875),heltab2x36(:,:,875))
  Gcoeff(:)%j = (-(c(142)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1020),h0tab(:,1020),[16,1,10,4],[nMT,nMT,nMB,nMB],4,1,wf6(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(202),m3h3x12(:,876),heltab2x36(:,:,876))
  call Hloop_Q_A(ntryL,G0H12(202),16,nMT,G1H12(313),n2h12(117))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1021),h0tab(:,1021),[16,1,10,4],[nMB,nMB,nMT,nMT],4,1,wf6(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(202),m3h3x12(:,877),heltab2x36(:,:,877))
  call Hloop_A_Q(ntryL,G0H12(202),16,nMB,G1H12(314),n2h12(118))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1022),h0tab(:,1022),[16,1,10,4],[nMH,nMH,nMW,nMW],4,1,wf6(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(315),m3h3x12(:,878),heltab2x36(:,:,878))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1023),h0tab(:,1023),[16,1,10,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(316),m3h3x12(:,879),heltab2x36(:,:,879))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1024),h0tab(:,1024),[16,1,10,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(317),m3h3x12(:,880),heltab2x36(:,:,880))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1025),h0tab(:,1025),[16,1,10,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(318),m3h3x12(:,881),heltab2x36(:,:,881))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1026),h0tab(:,1026),[16,1,10,4],[nMH,nMH,nMW,nMW],4,1,wf6(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(319),m3h3x12(:,882),heltab2x36(:,:,882))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1027),h0tab(:,1027),[16,1,10,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(320),m3h3x12(:,883),heltab2x36(:,:,883))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1028),h0tab(:,1028),[16,1,10,4],[nMH,nMH,nMW,nMW],4,1,wf6(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(202),m3h3x12(:,884),heltab2x36(:,:,884))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1029),h0tab(:,1029),[16,1,10,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(321),m3h3x12(:,885),heltab2x36(:,:,885))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1030),h0tab(:,1030),[16,1,10,4],[nMH,nMH,nMW,nMW],4,1,wf6(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(203),m3h3x12(:,886),heltab2x36(:,:,886))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1031),h0tab(:,1031),[16,1,10,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(322),m3h3x12(:,887),heltab2x36(:,:,887))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1032),h0tab(:,1032),[16,1,10,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(204),m3h3x12(:,888),heltab2x36(:,:,888))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1033),h0tab(:,1033),[16,1,10,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(205),m3h3x12(:,889),heltab2x36(:,:,889))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1034),h0tab(:,1034),[16,1,10,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(323),m3h3x12(:,890),heltab2x36(:,:,890))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1035),h0tab(:,1035),[16,1,10,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(206),m3h3x12(:,891),heltab2x36(:,:,891))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1036),h0tab(:,1036),[16,1,10,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(324),m3h3x12(:,892),heltab2x36(:,:,892))
  Gcoeff(:)%j = (c(142)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1037),h0tab(:,1037),[16,1,10,4],[nMT,nMT,nMB,nMB],4,1,wf6(:,20))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(207),m3h3x12(:,893),heltab2x36(:,:,893))
  call Hloop_Q_A(ntryL,G0H12(207),16,nMT,G1H12(325),n2h12(119))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1038),h0tab(:,1038),[16,1,10,4],[nMB,nMB,nMT,nMT],4,1,wf6(:,20))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(207),m3h3x12(:,894),heltab2x36(:,:,894))
  call Hloop_A_Q(ntryL,G0H12(207),16,nMB,G1H12(326),n2h12(120))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1039),h0tab(:,1039),[16,1,10,4],[nMH,nMH,nMW,nMW],4,1,wf6(:,20))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(327),m3h3x12(:,895),heltab2x36(:,:,895))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1040),h0tab(:,1040),[16,1,10,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,20))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(328),m3h3x12(:,896),heltab2x36(:,:,896))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1041),h0tab(:,1041),[16,1,10,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,20))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(329),m3h3x12(:,897),heltab2x36(:,:,897))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1042),h0tab(:,1042),[16,1,10,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,20))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(330),m3h3x12(:,898),heltab2x36(:,:,898))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1043),h0tab(:,1043),[16,1,10,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,20))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(331),m3h3x12(:,899),heltab2x36(:,:,899))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1044),h0tab(:,1044),[16,1,10,4],[nMH,nMH,nMW,nMW],4,1,wf6(:,20))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(332),m3h3x12(:,900),heltab2x36(:,:,900))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1045),h0tab(:,1045),[16,1,10,4],[nMH,nMH,nMW,nMW],4,1,wf6(:,20))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(207),m3h3x12(:,901),heltab2x36(:,:,901))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1046),h0tab(:,1046),[16,1,10,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,20))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(333),m3h3x12(:,902),heltab2x36(:,:,902))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1047),h0tab(:,1047),[16,1,10,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,20))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(208),m3h3x12(:,903),heltab2x36(:,:,903))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1048),h0tab(:,1048),[16,1,10,4],[nMH,nMH,nMW,nMW],4,1,wf6(:,20))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(209),m3h3x12(:,904),heltab2x36(:,:,904))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1049),h0tab(:,1049),[16,1,10,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,20))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(334),m3h3x12(:,905),heltab2x36(:,:,905))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1050),h0tab(:,1050),[16,1,10,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,20))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(335),m3h3x12(:,906),heltab2x36(:,:,906))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1051),h0tab(:,1051),[16,1,10,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,20))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(210),m3h3x12(:,907),heltab2x36(:,:,907))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1052),h0tab(:,1052),[16,1,10,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,20))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(211),m3h3x12(:,908),heltab2x36(:,:,908))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1053),h0tab(:,1053),[16,1,10,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,20))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(336),m3h3x12(:,909),heltab2x36(:,:,909))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1054),h0tab(:,1054),[16,1,2,12],[nML,nML,nML,0],4,1,wf6(:,5))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(212),m3h3x12(:,910),heltab2x36(:,:,910))
  call Hloop_A_Q(ntryL,G0H12(212),16,nML,G1H12(337),n2h12(121))
  Gcoeff(:)%j = (c(144)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1055),h0tab(:,1055),[16,1,2,12],[nMT,nMT,nMT,nMB],4,1,wf6(:,5))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(212),m3h3x12(:,911),heltab2x36(:,:,911))
  call Hloop_Q_A(ntryL,G0H12(212),16,nMT,G1H12(338),n2h12(122))
  Gcoeff(:)%j = (-(c(121)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1056),h0tab(:,1056),[16,1,2,12],[nMB,nMB,nMB,nMT],4,1,wf6(:,5))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(212),m3h3x12(:,912),heltab2x36(:,:,912))
  call Hloop_A_Q(ntryL,G0H12(212),16,nMB,G1H12(339),n2h12(123))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1057),h0tab(:,1057),[16,1,2,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,5))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(340),m3h3x12(:,913),heltab2x36(:,:,913))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1058),h0tab(:,1058),[16,1,2,12],[nMW,nMW,nMW,0],4,1,wf6(:,5))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(341),m3h3x12(:,914),heltab2x36(:,:,914))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1059),h0tab(:,1059),[16,1,2,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,5))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(342),m3h3x12(:,915),heltab2x36(:,:,915))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1060),h0tab(:,1060),[16,1,2,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,5))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(343),m3h3x12(:,916),heltab2x36(:,:,916))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1061),h0tab(:,1061),[16,1,2,12],[nMW,nMW,nMW,0],4,1,wf6(:,5))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(344),m3h3x12(:,917),heltab2x36(:,:,917))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1062),h0tab(:,1062),[16,1,2,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,5))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(345),m3h3x12(:,918),heltab2x36(:,:,918))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1063),h0tab(:,1063),[16,1,2,12],[nMW,nMW,nMW,0],4,1,wf6(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(212),m3h3x12(:,919),heltab2x36(:,:,919))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1064),h0tab(:,1064),[16,1,2,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(213),m3h3x12(:,920),heltab2x36(:,:,920))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1065),h0tab(:,1065),[16,1,2,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,5))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(346),m3h3x12(:,921),heltab2x36(:,:,921))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1066),h0tab(:,1066),[16,1,2,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,5))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(347),m3h3x12(:,922),heltab2x36(:,:,922))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1067),h0tab(:,1067),[16,1,2,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,5))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(214),m3h3x12(:,923),heltab2x36(:,:,923))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1068),h0tab(:,1068),[16,1,2,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,5))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(348),m3h3x12(:,924),heltab2x36(:,:,924))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1069),h0tab(:,1069),[16,1,2,12],[nMW,nMW,nMW,0],4,1,wf6(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(215),m3h3x12(:,925),heltab2x36(:,:,925))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1070),h0tab(:,1070),[16,1,2,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(216),m3h3x12(:,926),heltab2x36(:,:,926))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1071),h0tab(:,1071),[16,1,2,12],[nMW,nMW,nMW,0],4,1,wf6(:,5))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(349),m3h3x12(:,927),heltab2x36(:,:,927))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1072),h0tab(:,1072),[16,1,2,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,5))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(350),m3h3x12(:,928),heltab2x36(:,:,928))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1073),h0tab(:,1073),[16,1,2,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,5))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(217),m3h3x12(:,929),heltab2x36(:,:,929))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1074),h0tab(:,1074),[16,1,2,12],[nMW,nMW,nMW,0],4,1,wf6(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(218),m3h3x12(:,930),heltab2x36(:,:,930))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1075),h0tab(:,1075),[16,1,2,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(219),m3h3x12(:,931),heltab2x36(:,:,931))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1076),h0tab(:,1076),[16,1,2,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,5))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(351),m3h3x12(:,932),heltab2x36(:,:,932))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1077),h0tab(:,1077),[16,1,2,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,5))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(352),m3h3x12(:,933),heltab2x36(:,:,933))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1078),h0tab(:,1078),[16,1,2,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,5))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(220),m3h3x12(:,934),heltab2x36(:,:,934))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1079),h0tab(:,1079),[16,1,2,12],[nMW,nMW,nMW,0],4,1,wf6(:,5))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(353),m3h3x12(:,935),heltab2x36(:,:,935))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1080),h0tab(:,1080),[16,1,2,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,5))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(354),m3h3x12(:,936),heltab2x36(:,:,936))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1081),h0tab(:,1081),[16,1,2,12],[nMW,nMW,nMW,0],4,1,wf6(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(221),m3h3x12(:,937),heltab2x36(:,:,937))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1082),h0tab(:,1082),[16,1,2,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(222),m3h3x12(:,938),heltab2x36(:,:,938))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1083),h0tab(:,1083),[16,1,2,12],[nMW,nMW,nMW,0],4,1,wf6(:,5))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(355),m3h3x12(:,939),heltab2x36(:,:,939))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1084),h0tab(:,1084),[16,1,2,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,5))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(356),m3h3x12(:,940),heltab2x36(:,:,940))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1085),h0tab(:,1085),[16,1,2,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,5))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(223),m3h3x12(:,941),heltab2x36(:,:,941))
  Gcoeff(:)%j = (c(133)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1086),h0tab(:,1086),[16,1,2,12],[nML,nML,nML,0],4,1,wf6(:,29))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(224),m3h3x12(:,942),heltab2x36(:,:,942))
  call Hloop_A_Q(ntryL,G0H12(224),16,nML,G1H12(357),n2h12(124))
  Gcoeff(:)%j = (-(c(144)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1087),h0tab(:,1087),[16,1,2,12],[nMT,nMT,nMT,nMB],4,1,wf6(:,29))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(224),m3h3x12(:,943),heltab2x36(:,:,943))
  call Hloop_Q_A(ntryL,G0H12(224),16,nMT,G1H12(358),n2h12(125))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1088),h0tab(:,1088),[16,1,2,12],[nMB,nMB,nMB,nMT],4,1,wf6(:,29))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(224),m3h3x12(:,944),heltab2x36(:,:,944))
  call Hloop_A_Q(ntryL,G0H12(224),16,nMB,G1H12(359),n2h12(126))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1089),h0tab(:,1089),[16,1,2,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,29))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(360),m3h3x12(:,945),heltab2x36(:,:,945))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1090),h0tab(:,1090),[16,1,2,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,29))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(361),m3h3x12(:,946),heltab2x36(:,:,946))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1091),h0tab(:,1091),[16,1,2,12],[nMW,nMW,nMW,0],4,1,wf6(:,29))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(362),m3h3x12(:,947),heltab2x36(:,:,947))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1092),h0tab(:,1092),[16,1,2,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,29))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(363),m3h3x12(:,948),heltab2x36(:,:,948))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1093),h0tab(:,1093),[16,1,2,12],[nMW,nMW,nMW,0],4,1,wf6(:,29))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(364),m3h3x12(:,949),heltab2x36(:,:,949))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1094),h0tab(:,1094),[16,1,2,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,29))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(365),m3h3x12(:,950),heltab2x36(:,:,950))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1095),h0tab(:,1095),[16,1,2,12],[nMW,nMW,nMW,0],4,1,wf6(:,29))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(366),m3h3x12(:,951),heltab2x36(:,:,951))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1096),h0tab(:,1096),[16,1,2,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,29))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(367),m3h3x12(:,952),heltab2x36(:,:,952))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1097),h0tab(:,1097),[16,1,2,12],[nMW,nMW,nMW,0],4,1,wf6(:,29))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(224),m3h3x12(:,953),heltab2x36(:,:,953))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1098),h0tab(:,1098),[16,1,2,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,29))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(225),m3h3x12(:,954),heltab2x36(:,:,954))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1099),h0tab(:,1099),[16,1,2,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,29))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(368),m3h3x12(:,955),heltab2x36(:,:,955))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1100),h0tab(:,1100),[16,1,2,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,29))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(226),m3h3x12(:,956),heltab2x36(:,:,956))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1101),h0tab(:,1101),[16,1,2,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,29))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(369),m3h3x12(:,957),heltab2x36(:,:,957))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1102),h0tab(:,1102),[16,1,2,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,29))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(370),m3h3x12(:,958),heltab2x36(:,:,958))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1103),h0tab(:,1103),[16,1,2,12],[nMW,nMW,nMW,0],4,1,wf6(:,29))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(227),m3h3x12(:,959),heltab2x36(:,:,959))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1104),h0tab(:,1104),[16,1,2,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,29))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(228),m3h3x12(:,960),heltab2x36(:,:,960))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1105),h0tab(:,1105),[16,1,2,12],[nMW,nMW,nMW,0],4,1,wf6(:,29))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(371),m3h3x12(:,961),heltab2x36(:,:,961))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1106),h0tab(:,1106),[16,1,2,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,29))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(372),m3h3x12(:,962),heltab2x36(:,:,962))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1107),h0tab(:,1107),[16,1,2,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,29))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(229),m3h3x12(:,963),heltab2x36(:,:,963))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1108),h0tab(:,1108),[16,1,2,12],[nMW,nMW,nMW,0],4,1,wf6(:,29))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(230),m3h3x12(:,964),heltab2x36(:,:,964))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1109),h0tab(:,1109),[16,1,2,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,29))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(231),m3h3x12(:,965),heltab2x36(:,:,965))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1110),h0tab(:,1110),[16,1,2,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,29))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(373),m3h3x12(:,966),heltab2x36(:,:,966))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1111),h0tab(:,1111),[16,1,2,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,29))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(232),m3h3x12(:,967),heltab2x36(:,:,967))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1112),h0tab(:,1112),[16,1,2,12],[nMW,nMW,nMW,0],4,1,wf6(:,29))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(374),m3h3x12(:,968),heltab2x36(:,:,968))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1113),h0tab(:,1113),[16,1,2,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,29))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(375),m3h3x12(:,969),heltab2x36(:,:,969))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1114),h0tab(:,1114),[16,1,2,12],[nMW,nMW,nMW,0],4,1,wf6(:,29))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(233),m3h3x12(:,970),heltab2x36(:,:,970))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1115),h0tab(:,1115),[16,1,2,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,29))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(234),m3h3x12(:,971),heltab2x36(:,:,971))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1116),h0tab(:,1116),[16,1,2,12],[nMW,nMW,nMW,0],4,1,wf6(:,29))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(376),m3h3x12(:,972),heltab2x36(:,:,972))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1117),h0tab(:,1117),[16,1,2,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,29))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(377),m3h3x12(:,973),heltab2x36(:,:,973))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1118),h0tab(:,1118),[16,1,2,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,29))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(235),m3h3x12(:,974),heltab2x36(:,:,974))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1119),h0tab(:,1119),[16,2,1,12],[nML,nML,nML,0],4,1,wf6(:,5))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(236),m3h3x12(:,975),heltab2x36(:,:,975))
  call Hloop_A_Q(ntryL,G0H12(236),16,nML,G1H12(378),n2h12(127))
  Gcoeff(:)%j = (c(144)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1120),h0tab(:,1120),[16,2,1,12],[nMT,nMT,nMT,nMB],4,1,wf6(:,5))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(236),m3h3x12(:,976),heltab2x36(:,:,976))
  call Hloop_Q_A(ntryL,G0H12(236),16,nMT,G1H12(379),n2h12(128))
  Gcoeff(:)%j = (-(c(121)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1121),h0tab(:,1121),[16,2,1,12],[nMB,nMB,nMB,nMT],4,1,wf6(:,5))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(236),m3h3x12(:,977),heltab2x36(:,:,977))
  call Hloop_A_Q(ntryL,G0H12(236),16,nMB,G1H12(380),n2h12(129))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1122),h0tab(:,1122),[16,2,1,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,5))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(381),m3h3x12(:,978),heltab2x36(:,:,978))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1123),h0tab(:,1123),[16,2,1,12],[nMW,nMW,nMW,0],4,1,wf6(:,5))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(382),m3h3x12(:,979),heltab2x36(:,:,979))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1124),h0tab(:,1124),[16,2,1,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,5))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(383),m3h3x12(:,980),heltab2x36(:,:,980))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1125),h0tab(:,1125),[16,2,1,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,5))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(384),m3h3x12(:,981),heltab2x36(:,:,981))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1126),h0tab(:,1126),[16,2,1,12],[nMW,nMW,nMW,0],4,1,wf6(:,5))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(385),m3h3x12(:,982),heltab2x36(:,:,982))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1127),h0tab(:,1127),[16,2,1,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,5))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(386),m3h3x12(:,983),heltab2x36(:,:,983))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1128),h0tab(:,1128),[16,2,1,12],[nMW,nMW,nMW,0],4,1,wf6(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(236),m3h3x12(:,984),heltab2x36(:,:,984))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1129),h0tab(:,1129),[16,2,1,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(237),m3h3x12(:,985),heltab2x36(:,:,985))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1130),h0tab(:,1130),[16,2,1,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,5))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(238),m3h3x12(:,986),heltab2x36(:,:,986))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1131),h0tab(:,1131),[16,2,1,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,5))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(387),m3h3x12(:,987),heltab2x36(:,:,987))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1132),h0tab(:,1132),[16,2,1,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,5))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(388),m3h3x12(:,988),heltab2x36(:,:,988))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1133),h0tab(:,1133),[16,2,1,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,5))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(389),m3h3x12(:,989),heltab2x36(:,:,989))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1134),h0tab(:,1134),[16,2,1,12],[nMW,nMW,nMW,0],4,1,wf6(:,5))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(390),m3h3x12(:,990),heltab2x36(:,:,990))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1135),h0tab(:,1135),[16,2,1,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,5))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(391),m3h3x12(:,991),heltab2x36(:,:,991))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1136),h0tab(:,1136),[16,2,1,12],[nMW,nMW,nMW,0],4,1,wf6(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(239),m3h3x12(:,992),heltab2x36(:,:,992))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1137),h0tab(:,1137),[16,2,1,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(240),m3h3x12(:,993),heltab2x36(:,:,993))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1138),h0tab(:,1138),[16,2,1,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,5))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(241),m3h3x12(:,994),heltab2x36(:,:,994))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1139),h0tab(:,1139),[16,2,1,12],[nMW,nMW,nMW,0],4,1,wf6(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(242),m3h3x12(:,995),heltab2x36(:,:,995))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1140),h0tab(:,1140),[16,2,1,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(243),m3h3x12(:,996),heltab2x36(:,:,996))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1141),h0tab(:,1141),[16,2,1,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,5))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(244),m3h3x12(:,997),heltab2x36(:,:,997))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1142),h0tab(:,1142),[16,2,1,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,5))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(392),m3h3x12(:,998),heltab2x36(:,:,998))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1143),h0tab(:,1143),[16,2,1,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,5))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(393),m3h3x12(:,999),heltab2x36(:,:,999))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1144),h0tab(:,1144),[16,2,1,12],[nMW,nMW,nMW,0],4,1,wf6(:,5))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(394),m3h3x12(:,1000),heltab2x36(:,:,1000))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1145),h0tab(:,1145),[16,2,1,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,5))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(395),m3h3x12(:,1001),heltab2x36(:,:,1001))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1146),h0tab(:,1146),[16,2,1,12],[nMW,nMW,nMW,0],4,1,wf6(:,5))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(396),m3h3x12(:,1002),heltab2x36(:,:,1002))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1147),h0tab(:,1147),[16,2,1,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,5))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(397),m3h3x12(:,1003),heltab2x36(:,:,1003))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1148),h0tab(:,1148),[16,2,1,12],[nMW,nMW,nMW,0],4,1,wf6(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(245),m3h3x12(:,1004),heltab2x36(:,:,1004))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1149),h0tab(:,1149),[16,2,1,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(246),m3h3x12(:,1005),heltab2x36(:,:,1005))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1150),h0tab(:,1150),[16,2,1,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,5))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(247),m3h3x12(:,1006),heltab2x36(:,:,1006))
  Gcoeff(:)%j = (c(133)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1151),h0tab(:,1151),[16,2,1,12],[nML,nML,nML,0],4,1,wf6(:,29))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(248),m3h3x12(:,1007),heltab2x36(:,:,1007))
  call Hloop_A_Q(ntryL,G0H12(248),16,nML,G1H12(398),n2h12(130))
  Gcoeff(:)%j = (-(c(144)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1152),h0tab(:,1152),[16,2,1,12],[nMT,nMT,nMT,nMB],4,1,wf6(:,29))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(248),m3h3x12(:,1008),heltab2x36(:,:,1008))
  call Hloop_Q_A(ntryL,G0H12(248),16,nMT,G1H12(399),n2h12(131))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1153),h0tab(:,1153),[16,2,1,12],[nMB,nMB,nMB,nMT],4,1,wf6(:,29))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(248),m3h3x12(:,1009),heltab2x36(:,:,1009))
  call Hloop_A_Q(ntryL,G0H12(248),16,nMB,G1H12(400),n2h12(132))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1154),h0tab(:,1154),[16,2,1,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,29))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(401),m3h3x12(:,1010),heltab2x36(:,:,1010))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1155),h0tab(:,1155),[16,2,1,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,29))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(402),m3h3x12(:,1011),heltab2x36(:,:,1011))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1156),h0tab(:,1156),[16,2,1,12],[nMW,nMW,nMW,0],4,1,wf6(:,29))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(403),m3h3x12(:,1012),heltab2x36(:,:,1012))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1157),h0tab(:,1157),[16,2,1,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,29))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(404),m3h3x12(:,1013),heltab2x36(:,:,1013))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1158),h0tab(:,1158),[16,2,1,12],[nMW,nMW,nMW,0],4,1,wf6(:,29))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(405),m3h3x12(:,1014),heltab2x36(:,:,1014))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1159),h0tab(:,1159),[16,2,1,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,29))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(406),m3h3x12(:,1015),heltab2x36(:,:,1015))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1160),h0tab(:,1160),[16,2,1,12],[nMW,nMW,nMW,0],4,1,wf6(:,29))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(407),m3h3x12(:,1016),heltab2x36(:,:,1016))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1161),h0tab(:,1161),[16,2,1,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,29))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(408),m3h3x12(:,1017),heltab2x36(:,:,1017))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1162),h0tab(:,1162),[16,2,1,12],[nMW,nMW,nMW,0],4,1,wf6(:,29))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(248),m3h3x12(:,1018),heltab2x36(:,:,1018))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1163),h0tab(:,1163),[16,2,1,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,29))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(249),m3h3x12(:,1019),heltab2x36(:,:,1019))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1164),h0tab(:,1164),[16,2,1,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,29))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(250),m3h3x12(:,1020),heltab2x36(:,:,1020))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1165),h0tab(:,1165),[16,2,1,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,29))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(409),m3h3x12(:,1021),heltab2x36(:,:,1021))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1166),h0tab(:,1166),[16,2,1,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,29))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(410),m3h3x12(:,1022),heltab2x36(:,:,1022))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1167),h0tab(:,1167),[16,2,1,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,29))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(411),m3h3x12(:,1023),heltab2x36(:,:,1023))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1168),h0tab(:,1168),[16,2,1,12],[nMW,nMW,nMW,0],4,1,wf6(:,29))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(412),m3h3x12(:,1024),heltab2x36(:,:,1024))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1169),h0tab(:,1169),[16,2,1,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,29))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(413),m3h3x12(:,1025),heltab2x36(:,:,1025))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1170),h0tab(:,1170),[16,2,1,12],[nMW,nMW,nMW,0],4,1,wf6(:,29))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(251),m3h3x12(:,1026),heltab2x36(:,:,1026))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1171),h0tab(:,1171),[16,2,1,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,29))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(252),m3h3x12(:,1027),heltab2x36(:,:,1027))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1172),h0tab(:,1172),[16,2,1,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,29))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(253),m3h3x12(:,1028),heltab2x36(:,:,1028))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1173),h0tab(:,1173),[16,2,1,12],[nMW,nMW,nMW,0],4,1,wf6(:,29))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(254),m3h3x12(:,1029),heltab2x36(:,:,1029))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1174),h0tab(:,1174),[16,2,1,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,29))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(255),m3h3x12(:,1030),heltab2x36(:,:,1030))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1175),h0tab(:,1175),[16,2,1,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,29))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(256),m3h3x12(:,1031),heltab2x36(:,:,1031))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1176),h0tab(:,1176),[16,2,1,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,29))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex5(:),16,G1H12(414),m3h3x12(:,1032),heltab2x36(:,:,1032))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1177),h0tab(:,1177),[16,2,1,12],[nMW,nMW,nMW,0],4,1,wf6(:,29))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(415),m3h3x12(:,1033),heltab2x36(:,:,1033))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1178),h0tab(:,1178),[16,2,1,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,29))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(416),m3h3x12(:,1034),heltab2x36(:,:,1034))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1179),h0tab(:,1179),[16,2,1,12],[nMW,nMW,nMW,0],4,1,wf6(:,29))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(417),m3h3x12(:,1035),heltab2x36(:,:,1035))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1180),h0tab(:,1180),[16,2,1,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,29))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex5(:),16,G1H12(418),m3h3x12(:,1036),heltab2x36(:,:,1036))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1181),h0tab(:,1181),[16,2,1,12],[nMW,nMW,nMW,0],4,1,wf6(:,29))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(257),m3h3x12(:,1037),heltab2x36(:,:,1037))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1182),h0tab(:,1182),[16,2,1,12],[nMW,nMW,nMW,nMZ],4,1,wf6(:,29))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(258),m3h3x12(:,1038),heltab2x36(:,:,1038))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1183),h0tab(:,1183),[16,2,1,12],[nMW,nMW,nMW,nMH],4,1,wf6(:,29))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(259),m3h3x12(:,1039),heltab2x36(:,:,1039))
  Gcoeff(:)%j = (-(c(142)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1184),h0tab(:,1184),[16,1,12,2],[nMT,nMT,nMB,nMB],4,1,wf6(:,5))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(260),m3h3x12(:,1040),heltab2x36(:,:,1040))
  call Hloop_Q_A(ntryL,G0H12(260),16,nMT,G1H12(419),n2h12(133))
  Gcoeff(:)%j = (c(123)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1185),h0tab(:,1185),[16,1,12,2],[nMB,nMB,nMT,nMT],4,1,wf6(:,5))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(260),m3h3x12(:,1041),heltab2x36(:,:,1041))
  call Hloop_A_Q(ntryL,G0H12(260),16,nMB,G1H12(420),n2h12(134))
  Gcoeff(:)%j = (c(11)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1186),h0tab(:,1186),[16,1,12,2],[nMH,nMH,nMW,nMW],4,1,wf6(:,5))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(421),m3h3x12(:,1042),heltab2x36(:,:,1042))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1187),h0tab(:,1187),[16,1,12,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,5))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(422),m3h3x12(:,1043),heltab2x36(:,:,1043))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1188),h0tab(:,1188),[16,1,12,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,5))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(423),m3h3x12(:,1044),heltab2x36(:,:,1044))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1189),h0tab(:,1189),[16,1,12,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,5))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(424),m3h3x12(:,1045),heltab2x36(:,:,1045))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1190),h0tab(:,1190),[16,1,12,2],[nMH,nMH,nMW,nMW],4,1,wf6(:,5))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(425),m3h3x12(:,1046),heltab2x36(:,:,1046))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1191),h0tab(:,1191),[16,1,12,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,5))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(426),m3h3x12(:,1047),heltab2x36(:,:,1047))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1192),h0tab(:,1192),[16,1,12,2],[nMH,nMH,nMW,nMW],4,1,wf6(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(260),m3h3x12(:,1048),heltab2x36(:,:,1048))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1193),h0tab(:,1193),[16,1,12,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,5))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(427),m3h3x12(:,1049),heltab2x36(:,:,1049))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1194),h0tab(:,1194),[16,1,12,2],[nMH,nMH,nMW,nMW],4,1,wf6(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(261),m3h3x12(:,1050),heltab2x36(:,:,1050))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1195),h0tab(:,1195),[16,1,12,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,5))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(428),m3h3x12(:,1051),heltab2x36(:,:,1051))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1196),h0tab(:,1196),[16,1,12,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,5))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(262),m3h3x12(:,1052),heltab2x36(:,:,1052))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1197),h0tab(:,1197),[16,1,12,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,5))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(263),m3h3x12(:,1053),heltab2x36(:,:,1053))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1198),h0tab(:,1198),[16,1,12,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,5))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(429),m3h3x12(:,1054),heltab2x36(:,:,1054))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1199),h0tab(:,1199),[16,1,12,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,5))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(264),m3h3x12(:,1055),heltab2x36(:,:,1055))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1200),h0tab(:,1200),[16,1,12,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,5))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(430),m3h3x12(:,1056),heltab2x36(:,:,1056))
  Gcoeff(:)%j = (c(142)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1201),h0tab(:,1201),[16,1,12,2],[nMT,nMT,nMB,nMB],4,1,wf6(:,29))
  call Hloop_QW_A(ntryL,G0H36(1),ex5(:),G0H12(265),m3h3x12(:,1057),heltab2x36(:,:,1057))
  call Hloop_Q_A(ntryL,G0H12(265),16,nMT,G1H12(431),n2h12(135))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1202),h0tab(:,1202),[16,1,12,2],[nMB,nMB,nMT,nMT],4,1,wf6(:,29))
  call Hloop_AW_Q(ntryL,G0H36(1),ex5(:),G0H12(265),m3h3x12(:,1058),heltab2x36(:,:,1058))
  call Hloop_A_Q(ntryL,G0H12(265),16,nMB,G1H12(432),n2h12(136))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1203),h0tab(:,1203),[16,1,12,2],[nMH,nMH,nMW,nMW],4,1,wf6(:,29))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(433),m3h3x12(:,1059),heltab2x36(:,:,1059))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1204),h0tab(:,1204),[16,1,12,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,29))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(434),m3h3x12(:,1060),heltab2x36(:,:,1060))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1205),h0tab(:,1205),[16,1,12,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,29))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex5(:),16,G1H12(435),m3h3x12(:,1061),heltab2x36(:,:,1061))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1206),h0tab(:,1206),[16,1,12,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,29))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex5(:),G1H12(436),m3h3x12(:,1062),heltab2x36(:,:,1062))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1207),h0tab(:,1207),[16,1,12,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,29))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(437),m3h3x12(:,1063),heltab2x36(:,:,1063))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1208),h0tab(:,1208),[16,1,12,2],[nMH,nMH,nMW,nMW],4,1,wf6(:,29))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(438),m3h3x12(:,1064),heltab2x36(:,:,1064))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1209),h0tab(:,1209),[16,1,12,2],[nMH,nMH,nMW,nMW],4,1,wf6(:,29))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(265),m3h3x12(:,1065),heltab2x36(:,:,1065))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1210),h0tab(:,1210),[16,1,12,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,29))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(439),m3h3x12(:,1066),heltab2x36(:,:,1066))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1211),h0tab(:,1211),[16,1,12,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,29))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(266),m3h3x12(:,1067),heltab2x36(:,:,1067))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1212),h0tab(:,1212),[16,1,12,2],[nMH,nMH,nMW,nMW],4,1,wf6(:,29))
  call Hloop_VV_S(ntryL,G0H36(1),ex5(:),G0H12(267),m3h3x12(:,1068),heltab2x36(:,:,1068))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1213),h0tab(:,1213),[16,1,12,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,29))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex5(:),16,G1H12(440),m3h3x12(:,1069),heltab2x36(:,:,1069))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1214),h0tab(:,1214),[16,1,12,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,29))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(441),m3h3x12(:,1070),heltab2x36(:,:,1070))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1215),h0tab(:,1215),[16,1,12,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,29))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(268),m3h3x12(:,1071),heltab2x36(:,:,1071))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1216),h0tab(:,1216),[16,1,12,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,29))
  call Hloop_SV_V(ntryL,G0H36(1),ex5(:),G0H12(269),m3h3x12(:,1072),heltab2x36(:,:,1072))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1217),h0tab(:,1217),[16,1,12,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,29))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex5(:),16,G1H12(442),m3h3x12(:,1073),heltab2x36(:,:,1073))
  Gcoeff(:)%j = (c(133)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1218),h0tab(:,1218),[17,4,2,8],[nML,nML,nML,0],4,1,wf3(:,4))
  call Hloop_AS_Q(ntryL,G0H36(1),wf3(:,4),G0H12(270),ngPnl,m3h3x12(:,1074),heltab2x36(:,:,1074))
  call Hloop_A_Q(ntryL,G0H12(270),17,nML,G1H12(443),n2h12(137))
  Gcoeff(:)%j = (-(c(115)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1219),h0tab(:,1219),[17,4,2,8],[nMT,nMT,nMT,nMB],4,1,wf3(:,4))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,4),G0H12(270),ngPtb,m3h3x12(:,1075),heltab2x36(:,:,1075))
  call Hloop_Q_A(ntryL,G0H12(270),17,nMT,G1H12(444),n2h12(138))
  Gcoeff(:)%j = (-(c(112)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1220),h0tab(:,1220),[17,4,2,8],[nMB,nMB,nMB,nMT],4,1,wf3(:,4))
  call Hloop_AS_Q(ntryL,G0H36(1),wf3(:,4),G0H12(270),ngPtb,m3h3x12(:,1076),heltab2x36(:,:,1076))
  call Hloop_A_Q(ntryL,G0H12(270),17,nMB,G1H12(445),n2h12(139))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1221),h0tab(:,1221),[17,4,2,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,4))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,4),G0H12(270),m3h3x12(:,1077),heltab2x36(:,:,1077))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1222),h0tab(:,1222),[17,4,2,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,4))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,4),G0H12(271),m3h3x12(:,1078),heltab2x36(:,:,1078))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1223),h0tab(:,1223),[17,4,2,8],[nMW,nMW,nMW,0],4,1,wf3(:,4))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,4),G0H12(272),m3h3x12(:,1079),heltab2x36(:,:,1079))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1224),h0tab(:,1224),[17,4,2,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,4))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,4),G0H12(273),m3h3x12(:,1080),heltab2x36(:,:,1080))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1225),h0tab(:,1225),[17,4,2,8],[nMW,nMW,nMW,0],4,1,wf3(:,4))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,4),G0H12(274),m3h3x12(:,1081),heltab2x36(:,:,1081))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1226),h0tab(:,1226),[17,4,2,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,4))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,4),G0H12(275),m3h3x12(:,1082),heltab2x36(:,:,1082))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1227),h0tab(:,1227),[17,4,2,8],[nMW,nMW,nMW,0],4,1,wf3(:,4))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf3(:,4),17,G1H12(446),m3h3x12(:,1083),heltab2x36(:,:,1083))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1228),h0tab(:,1228),[17,4,2,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,4))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf3(:,4),17,G1H12(447),m3h3x12(:,1084),heltab2x36(:,:,1084))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1229),h0tab(:,1229),[17,4,2,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,4))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,4),17,G1H12(448),m3h3x12(:,1085),heltab2x36(:,:,1085))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1230),h0tab(:,1230),[17,4,2,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,4))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,4),17,G1H12(449),m3h3x12(:,1086),heltab2x36(:,:,1086))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1231),h0tab(:,1231),[17,4,2,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,4))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,4),G0H12(276),m3h3x12(:,1087),heltab2x36(:,:,1087))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1232),h0tab(:,1232),[17,4,2,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,4))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,4),G0H12(277),m3h3x12(:,1088),heltab2x36(:,:,1088))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1233),h0tab(:,1233),[17,4,2,8],[nMW,nMW,nMW,0],4,1,wf3(:,4))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,4),G0H12(278),m3h3x12(:,1089),heltab2x36(:,:,1089))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1234),h0tab(:,1234),[17,4,2,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,4))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,4),G0H12(279),m3h3x12(:,1090),heltab2x36(:,:,1090))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1235),h0tab(:,1235),[17,4,2,8],[nMW,nMW,nMW,0],4,1,wf3(:,4))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf3(:,4),17,G1H12(450),m3h3x12(:,1091),heltab2x36(:,:,1091))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1236),h0tab(:,1236),[17,4,2,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,4))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf3(:,4),17,G1H12(451),m3h3x12(:,1092),heltab2x36(:,:,1092))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1237),h0tab(:,1237),[17,4,2,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,4))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,4),17,G1H12(452),m3h3x12(:,1093),heltab2x36(:,:,1093))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1238),h0tab(:,1238),[17,4,2,8],[nMW,nMW,nMW,0],4,1,wf3(:,4))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf3(:,4),17,G1H12(453),m3h3x12(:,1094),heltab2x36(:,:,1094))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1239),h0tab(:,1239),[17,4,2,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,4))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf3(:,4),17,G1H12(454),m3h3x12(:,1095),heltab2x36(:,:,1095))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1240),h0tab(:,1240),[17,4,2,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,4))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,4),17,G1H12(455),m3h3x12(:,1096),heltab2x36(:,:,1096))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1241),h0tab(:,1241),[17,4,2,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,4))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,4),17,G1H12(456),m3h3x12(:,1097),heltab2x36(:,:,1097))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1242),h0tab(:,1242),[17,4,2,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,4))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,4),G0H12(280),m3h3x12(:,1098),heltab2x36(:,:,1098))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1243),h0tab(:,1243),[17,4,2,8],[nMW,nMW,nMW,0],4,1,wf3(:,4))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,4),G0H12(281),m3h3x12(:,1099),heltab2x36(:,:,1099))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1244),h0tab(:,1244),[17,4,2,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,4))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,4),G0H12(282),m3h3x12(:,1100),heltab2x36(:,:,1100))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1245),h0tab(:,1245),[17,4,2,8],[nMW,nMW,nMW,0],4,1,wf3(:,4))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,4),G0H12(283),m3h3x12(:,1101),heltab2x36(:,:,1101))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1246),h0tab(:,1246),[17,4,2,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,4))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,4),G0H12(284),m3h3x12(:,1102),heltab2x36(:,:,1102))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1247),h0tab(:,1247),[17,4,2,8],[nMW,nMW,nMW,0],4,1,wf3(:,4))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf3(:,4),17,G1H12(457),m3h3x12(:,1103),heltab2x36(:,:,1103))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1248),h0tab(:,1248),[17,4,2,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,4))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf3(:,4),17,G1H12(458),m3h3x12(:,1104),heltab2x36(:,:,1104))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1249),h0tab(:,1249),[17,4,2,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,4))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,4),17,G1H12(459),m3h3x12(:,1105),heltab2x36(:,:,1105))
  Gcoeff(:)%j = (-(c(162)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1250),h0tab(:,1250),[17,4,2,8],[0,0,0,0],4,1,wf3(:,2))
  call Hloop_AW_Q(ntryL,G0H36(1),wf3(:,2),G0H12(285),m3h3x12(:,1106),heltab2x36(:,:,1106))
  call Hloop_A_Q(ntryL,G0H12(285),17,0,G1H12(460),n2h12(140))
  Gcoeff(:)%j = (-(c(159)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1251),h0tab(:,1251),[17,4,2,8],[nML,nML,nML,0],4,1,wf3(:,2))
  call Hloop_AW_Q(ntryL,G0H36(1),wf3(:,2),G0H12(285),m3h3x12(:,1107),heltab2x36(:,:,1107))
  call Hloop_A_Q(ntryL,G0H12(285),17,nML,G1H12(461),n2h12(141))
  Gcoeff(:)%j = (-(c(158)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1252),h0tab(:,1252),[17,4,2,8],[0,0,0,0],4,1,wf3(:,2))
  call Hloop_QW_A(ntryL,G0H36(1),wf3(:,2),G0H12(285),m3h3x12(:,1108),heltab2x36(:,:,1108))
  call Hloop_Q_A(ntryL,G0H12(285),17,0,G1H12(462),n2h12(142))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1253),h0tab(:,1253),[17,4,2,8],[nMT,nMT,nMT,nMB],4,1,wf3(:,2))
  call Hloop_QW_A(ntryL,G0H36(1),wf3(:,2),G0H12(285),m3h3x12(:,1109),heltab2x36(:,:,1109))
  call Hloop_Q_A(ntryL,G0H12(285),17,nMT,G1H12(463),n2h12(143))
  Gcoeff(:)%j = (-(c(152)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1254),h0tab(:,1254),[17,4,2,8],[0,0,0,0],4,1,wf3(:,2))
  call Hloop_AW_Q(ntryL,G0H36(1),wf3(:,2),G0H12(285),m3h3x12(:,1110),heltab2x36(:,:,1110))
  call Hloop_A_Q(ntryL,G0H12(285),17,0,G1H12(464),n2h12(144))
  Gcoeff(:)%j = (-(c(150)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1255),h0tab(:,1255),[17,4,2,8],[nMB,nMB,nMB,nMT],4,1,wf3(:,2))
  call Hloop_AW_Q(ntryL,G0H36(1),wf3(:,2),G0H12(285),m3h3x12(:,1111),heltab2x36(:,:,1111))
  call Hloop_A_Q(ntryL,G0H12(285),17,nMB,G1H12(465),n2h12(145))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1256),h0tab(:,1256),[17,4,2,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(466),m3h3x12(:,1112),heltab2x36(:,:,1112))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1257),h0tab(:,1257),[17,4,2,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(467),m3h3x12(:,1113),heltab2x36(:,:,1113))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1258),h0tab(:,1258),[17,4,2,8],[nMW,nMW,nMW,0],4,1,wf3(:,2))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf3(:,2),G1H12(468),m3h3x12(:,1114),heltab2x36(:,:,1114))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1259),h0tab(:,1259),[17,4,2,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,2))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf3(:,2),G1H12(469),m3h3x12(:,1115),heltab2x36(:,:,1115))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1260),h0tab(:,1260),[17,4,2,8],[nMW,nMW,nMW,0],4,1,wf3(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(470),m3h3x12(:,1116),heltab2x36(:,:,1116))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1261),h0tab(:,1261),[17,4,2,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(471),m3h3x12(:,1117),heltab2x36(:,:,1117))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1262),h0tab(:,1262),[17,4,2,8],[nMW,nMW,nMW,0],4,1,wf3(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(472),m3h3x12(:,1118),heltab2x36(:,:,1118))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1263),h0tab(:,1263),[17,4,2,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(473),m3h3x12(:,1119),heltab2x36(:,:,1119))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1264),h0tab(:,1264),[17,4,2,8],[nMW,nMW,nMW,0],4,1,wf3(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,2),G0H12(285),m3h3x12(:,1120),heltab2x36(:,:,1120))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1265),h0tab(:,1265),[17,4,2,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,2),G0H12(286),m3h3x12(:,1121),heltab2x36(:,:,1121))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1266),h0tab(:,1266),[17,4,2,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,2),G0H12(287),m3h3x12(:,1122),heltab2x36(:,:,1122))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1267),h0tab(:,1267),[17,4,2,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(474),m3h3x12(:,1123),heltab2x36(:,:,1123))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1268),h0tab(:,1268),[17,4,2,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(475),m3h3x12(:,1124),heltab2x36(:,:,1124))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1269),h0tab(:,1269),[17,4,2,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(476),m3h3x12(:,1125),heltab2x36(:,:,1125))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1270),h0tab(:,1270),[17,4,2,8],[nMW,nMW,nMW,0],4,1,wf3(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(477),m3h3x12(:,1126),heltab2x36(:,:,1126))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1271),h0tab(:,1271),[17,4,2,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(478),m3h3x12(:,1127),heltab2x36(:,:,1127))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1272),h0tab(:,1272),[17,4,2,8],[nMW,nMW,nMW,0],4,1,wf3(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,2),G0H12(288),m3h3x12(:,1128),heltab2x36(:,:,1128))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1273),h0tab(:,1273),[17,4,2,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,2),G0H12(289),m3h3x12(:,1129),heltab2x36(:,:,1129))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1274),h0tab(:,1274),[17,4,2,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,2),G0H12(290),m3h3x12(:,1130),heltab2x36(:,:,1130))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1275),h0tab(:,1275),[17,4,2,8],[nMW,nMW,nMW,0],4,1,wf3(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,2),G0H12(291),m3h3x12(:,1131),heltab2x36(:,:,1131))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1276),h0tab(:,1276),[17,4,2,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,2),G0H12(292),m3h3x12(:,1132),heltab2x36(:,:,1132))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1277),h0tab(:,1277),[17,4,2,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,2),G0H12(293),m3h3x12(:,1133),heltab2x36(:,:,1133))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1278),h0tab(:,1278),[17,4,2,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(479),m3h3x12(:,1134),heltab2x36(:,:,1134))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1279),h0tab(:,1279),[17,4,2,8],[nMW,nMW,nMW,0],4,1,wf3(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(480),m3h3x12(:,1135),heltab2x36(:,:,1135))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1280),h0tab(:,1280),[17,4,2,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(481),m3h3x12(:,1136),heltab2x36(:,:,1136))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1281),h0tab(:,1281),[17,4,2,8],[nMW,nMW,nMW,0],4,1,wf3(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(482),m3h3x12(:,1137),heltab2x36(:,:,1137))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1282),h0tab(:,1282),[17,4,2,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(483),m3h3x12(:,1138),heltab2x36(:,:,1138))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1283),h0tab(:,1283),[17,4,2,8],[nMW,nMW,nMW,0],4,1,wf3(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,2),G0H12(294),m3h3x12(:,1139),heltab2x36(:,:,1139))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1284),h0tab(:,1284),[17,4,2,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,2),G0H12(295),m3h3x12(:,1140),heltab2x36(:,:,1140))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1285),h0tab(:,1285),[17,4,2,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,2),G0H12(296),m3h3x12(:,1141),heltab2x36(:,:,1141))
  Gcoeff(:)%j = (c(133)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1286),h0tab(:,1286),[17,2,4,8],[nML,nML,nML,0],4,1,wf3(:,4))
  call Hloop_AS_Q(ntryL,G0H36(1),wf3(:,4),G0H12(297),ngPnl,m3h3x12(:,1142),heltab2x36(:,:,1142))
  call Hloop_A_Q(ntryL,G0H12(297),17,nML,G1H12(484),n2h12(146))
  Gcoeff(:)%j = (-(c(115)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1287),h0tab(:,1287),[17,2,4,8],[nMT,nMT,nMT,nMB],4,1,wf3(:,4))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,4),G0H12(297),ngPtb,m3h3x12(:,1143),heltab2x36(:,:,1143))
  call Hloop_Q_A(ntryL,G0H12(297),17,nMT,G1H12(485),n2h12(147))
  Gcoeff(:)%j = (-(c(112)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1288),h0tab(:,1288),[17,2,4,8],[nMB,nMB,nMB,nMT],4,1,wf3(:,4))
  call Hloop_AS_Q(ntryL,G0H36(1),wf3(:,4),G0H12(297),ngPtb,m3h3x12(:,1144),heltab2x36(:,:,1144))
  call Hloop_A_Q(ntryL,G0H12(297),17,nMB,G1H12(486),n2h12(148))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1289),h0tab(:,1289),[17,2,4,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,4))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,4),G0H12(297),m3h3x12(:,1145),heltab2x36(:,:,1145))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1290),h0tab(:,1290),[17,2,4,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,4))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,4),G0H12(298),m3h3x12(:,1146),heltab2x36(:,:,1146))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1291),h0tab(:,1291),[17,2,4,8],[nMW,nMW,nMW,0],4,1,wf3(:,4))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,4),G0H12(299),m3h3x12(:,1147),heltab2x36(:,:,1147))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1292),h0tab(:,1292),[17,2,4,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,4))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,4),G0H12(300),m3h3x12(:,1148),heltab2x36(:,:,1148))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1293),h0tab(:,1293),[17,2,4,8],[nMW,nMW,nMW,0],4,1,wf3(:,4))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,4),G0H12(301),m3h3x12(:,1149),heltab2x36(:,:,1149))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1294),h0tab(:,1294),[17,2,4,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,4))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,4),G0H12(302),m3h3x12(:,1150),heltab2x36(:,:,1150))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1295),h0tab(:,1295),[17,2,4,8],[nMW,nMW,nMW,0],4,1,wf3(:,4))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf3(:,4),17,G1H12(487),m3h3x12(:,1151),heltab2x36(:,:,1151))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1296),h0tab(:,1296),[17,2,4,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,4))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf3(:,4),17,G1H12(488),m3h3x12(:,1152),heltab2x36(:,:,1152))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1297),h0tab(:,1297),[17,2,4,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,4))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,4),G0H12(303),m3h3x12(:,1153),heltab2x36(:,:,1153))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1298),h0tab(:,1298),[17,2,4,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,4))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,4),17,G1H12(489),m3h3x12(:,1154),heltab2x36(:,:,1154))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1299),h0tab(:,1299),[17,2,4,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,4))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,4),17,G1H12(490),m3h3x12(:,1155),heltab2x36(:,:,1155))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1300),h0tab(:,1300),[17,2,4,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,4))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,4),G0H12(304),m3h3x12(:,1156),heltab2x36(:,:,1156))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1301),h0tab(:,1301),[17,2,4,8],[nMW,nMW,nMW,0],4,1,wf3(:,4))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf3(:,4),17,G1H12(491),m3h3x12(:,1157),heltab2x36(:,:,1157))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1302),h0tab(:,1302),[17,2,4,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,4))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf3(:,4),17,G1H12(492),m3h3x12(:,1158),heltab2x36(:,:,1158))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1303),h0tab(:,1303),[17,2,4,8],[nMW,nMW,nMW,0],4,1,wf3(:,4))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,4),G0H12(305),m3h3x12(:,1159),heltab2x36(:,:,1159))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1304),h0tab(:,1304),[17,2,4,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,4))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,4),G0H12(306),m3h3x12(:,1160),heltab2x36(:,:,1160))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1305),h0tab(:,1305),[17,2,4,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,4))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,4),17,G1H12(493),m3h3x12(:,1161),heltab2x36(:,:,1161))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1306),h0tab(:,1306),[17,2,4,8],[nMW,nMW,nMW,0],4,1,wf3(:,4))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf3(:,4),17,G1H12(494),m3h3x12(:,1162),heltab2x36(:,:,1162))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1307),h0tab(:,1307),[17,2,4,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,4))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf3(:,4),17,G1H12(495),m3h3x12(:,1163),heltab2x36(:,:,1163))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1308),h0tab(:,1308),[17,2,4,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,4))
  call Hloop_SS_S(ntryL,G0H36(1),wf3(:,4),G0H12(307),m3h3x12(:,1164),heltab2x36(:,:,1164))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1309),h0tab(:,1309),[17,2,4,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,4))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,4),17,G1H12(496),m3h3x12(:,1165),heltab2x36(:,:,1165))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1310),h0tab(:,1310),[17,2,4,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,4))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,4),17,G1H12(497),m3h3x12(:,1166),heltab2x36(:,:,1166))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1311),h0tab(:,1311),[17,2,4,8],[nMW,nMW,nMW,0],4,1,wf3(:,4))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,4),G0H12(308),m3h3x12(:,1167),heltab2x36(:,:,1167))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1312),h0tab(:,1312),[17,2,4,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,4))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,4),G0H12(309),m3h3x12(:,1168),heltab2x36(:,:,1168))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1313),h0tab(:,1313),[17,2,4,8],[nMW,nMW,nMW,0],4,1,wf3(:,4))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf3(:,4),17,G1H12(498),m3h3x12(:,1169),heltab2x36(:,:,1169))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1314),h0tab(:,1314),[17,2,4,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,4))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf3(:,4),17,G1H12(499),m3h3x12(:,1170),heltab2x36(:,:,1170))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1315),h0tab(:,1315),[17,2,4,8],[nMW,nMW,nMW,0],4,1,wf3(:,4))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,4),G0H12(310),m3h3x12(:,1171),heltab2x36(:,:,1171))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1316),h0tab(:,1316),[17,2,4,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,4))
  call Hloop_VS_V(ntryL,G0H36(1),wf3(:,4),G0H12(311),m3h3x12(:,1172),heltab2x36(:,:,1172))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1317),h0tab(:,1317),[17,2,4,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,4))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf3(:,4),17,G1H12(500),m3h3x12(:,1173),heltab2x36(:,:,1173))
  Gcoeff(:)%j = (-(c(162)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1318),h0tab(:,1318),[17,2,4,8],[0,0,0,0],4,1,wf3(:,2))
  call Hloop_AW_Q(ntryL,G0H36(1),wf3(:,2),G0H12(312),m3h3x12(:,1174),heltab2x36(:,:,1174))
  call Hloop_A_Q(ntryL,G0H12(312),17,0,G1H12(501),n2h12(149))
  Gcoeff(:)%j = (-(c(159)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1319),h0tab(:,1319),[17,2,4,8],[nML,nML,nML,0],4,1,wf3(:,2))
  call Hloop_AW_Q(ntryL,G0H36(1),wf3(:,2),G0H12(312),m3h3x12(:,1175),heltab2x36(:,:,1175))
  call Hloop_A_Q(ntryL,G0H12(312),17,nML,G1H12(502),n2h12(150))
  Gcoeff(:)%j = (-(c(158)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1320),h0tab(:,1320),[17,2,4,8],[0,0,0,0],4,1,wf3(:,2))
  call Hloop_QW_A(ntryL,G0H36(1),wf3(:,2),G0H12(312),m3h3x12(:,1176),heltab2x36(:,:,1176))
  call Hloop_Q_A(ntryL,G0H12(312),17,0,G1H12(503),n2h12(151))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1321),h0tab(:,1321),[17,2,4,8],[nMT,nMT,nMT,nMB],4,1,wf3(:,2))
  call Hloop_QW_A(ntryL,G0H36(1),wf3(:,2),G0H12(312),m3h3x12(:,1177),heltab2x36(:,:,1177))
  call Hloop_Q_A(ntryL,G0H12(312),17,nMT,G1H12(504),n2h12(152))
  Gcoeff(:)%j = (-(c(152)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1322),h0tab(:,1322),[17,2,4,8],[0,0,0,0],4,1,wf3(:,2))
  call Hloop_AW_Q(ntryL,G0H36(1),wf3(:,2),G0H12(312),m3h3x12(:,1178),heltab2x36(:,:,1178))
  call Hloop_A_Q(ntryL,G0H12(312),17,0,G1H12(505),n2h12(153))
  Gcoeff(:)%j = (-(c(150)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1323),h0tab(:,1323),[17,2,4,8],[nMB,nMB,nMB,nMT],4,1,wf3(:,2))
  call Hloop_AW_Q(ntryL,G0H36(1),wf3(:,2),G0H12(312),m3h3x12(:,1179),heltab2x36(:,:,1179))
  call Hloop_A_Q(ntryL,G0H12(312),17,nMB,G1H12(506),n2h12(154))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1324),h0tab(:,1324),[17,2,4,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(507),m3h3x12(:,1180),heltab2x36(:,:,1180))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1325),h0tab(:,1325),[17,2,4,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(508),m3h3x12(:,1181),heltab2x36(:,:,1181))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1326),h0tab(:,1326),[17,2,4,8],[nMW,nMW,nMW,0],4,1,wf3(:,2))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf3(:,2),G1H12(509),m3h3x12(:,1182),heltab2x36(:,:,1182))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1327),h0tab(:,1327),[17,2,4,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,2))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf3(:,2),G1H12(510),m3h3x12(:,1183),heltab2x36(:,:,1183))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1328),h0tab(:,1328),[17,2,4,8],[nMW,nMW,nMW,0],4,1,wf3(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(511),m3h3x12(:,1184),heltab2x36(:,:,1184))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1329),h0tab(:,1329),[17,2,4,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(512),m3h3x12(:,1185),heltab2x36(:,:,1185))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1330),h0tab(:,1330),[17,2,4,8],[nMW,nMW,nMW,0],4,1,wf3(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(513),m3h3x12(:,1186),heltab2x36(:,:,1186))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1331),h0tab(:,1331),[17,2,4,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(514),m3h3x12(:,1187),heltab2x36(:,:,1187))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1332),h0tab(:,1332),[17,2,4,8],[nMW,nMW,nMW,0],4,1,wf3(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,2),G0H12(312),m3h3x12(:,1188),heltab2x36(:,:,1188))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1333),h0tab(:,1333),[17,2,4,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,2),G0H12(313),m3h3x12(:,1189),heltab2x36(:,:,1189))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1334),h0tab(:,1334),[17,2,4,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(515),m3h3x12(:,1190),heltab2x36(:,:,1190))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1335),h0tab(:,1335),[17,2,4,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,2),G0H12(314),m3h3x12(:,1191),heltab2x36(:,:,1191))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1336),h0tab(:,1336),[17,2,4,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(516),m3h3x12(:,1192),heltab2x36(:,:,1192))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1337),h0tab(:,1337),[17,2,4,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(517),m3h3x12(:,1193),heltab2x36(:,:,1193))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1338),h0tab(:,1338),[17,2,4,8],[nMW,nMW,nMW,0],4,1,wf3(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,2),G0H12(315),m3h3x12(:,1194),heltab2x36(:,:,1194))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1339),h0tab(:,1339),[17,2,4,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,2),G0H12(316),m3h3x12(:,1195),heltab2x36(:,:,1195))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1340),h0tab(:,1340),[17,2,4,8],[nMW,nMW,nMW,0],4,1,wf3(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(518),m3h3x12(:,1196),heltab2x36(:,:,1196))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1341),h0tab(:,1341),[17,2,4,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(519),m3h3x12(:,1197),heltab2x36(:,:,1197))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1342),h0tab(:,1342),[17,2,4,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,2),G0H12(317),m3h3x12(:,1198),heltab2x36(:,:,1198))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1343),h0tab(:,1343),[17,2,4,8],[nMW,nMW,nMW,0],4,1,wf3(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,2),G0H12(318),m3h3x12(:,1199),heltab2x36(:,:,1199))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1344),h0tab(:,1344),[17,2,4,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,2),G0H12(319),m3h3x12(:,1200),heltab2x36(:,:,1200))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1345),h0tab(:,1345),[17,2,4,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(520),m3h3x12(:,1201),heltab2x36(:,:,1201))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1346),h0tab(:,1346),[17,2,4,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,2),G0H12(320),m3h3x12(:,1202),heltab2x36(:,:,1202))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1347),h0tab(:,1347),[17,2,4,8],[nMW,nMW,nMW,0],4,1,wf3(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(521),m3h3x12(:,1203),heltab2x36(:,:,1203))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1348),h0tab(:,1348),[17,2,4,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(522),m3h3x12(:,1204),heltab2x36(:,:,1204))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1349),h0tab(:,1349),[17,2,4,8],[nMW,nMW,nMW,0],4,1,wf3(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,2),G0H12(321),m3h3x12(:,1205),heltab2x36(:,:,1205))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1350),h0tab(:,1350),[17,2,4,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),wf3(:,2),G0H12(322),m3h3x12(:,1206),heltab2x36(:,:,1206))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1351),h0tab(:,1351),[17,2,4,8],[nMW,nMW,nMW,0],4,1,wf3(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(523),m3h3x12(:,1207),heltab2x36(:,:,1207))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1352),h0tab(:,1352),[17,2,4,8],[nMW,nMW,nMW,nMZ],4,1,wf3(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf3(:,2),17,G1H12(524),m3h3x12(:,1208),heltab2x36(:,:,1208))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1353),h0tab(:,1353),[17,2,4,8],[nMW,nMW,nMW,nMH],4,1,wf3(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf3(:,2),G0H12(323),m3h3x12(:,1209),heltab2x36(:,:,1209))
  Gcoeff(:)%j = (c(113)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1354),h0tab(:,1354),[17,2,8,4],[nMT,nMT,nMB,nMB],4,1,wf3(:,4))
  call Hloop_QS_A(ntryL,G0H36(1),wf3(:,4),G0H12(324),ngPtb,m3h3x12(:,1210),heltab2x36(:,:,1210))
  call Hloop_Q_A(ntryL,G0H12(324),17,nMT,G1H12(525),n2h12(155))
  Gcoeff(:)%j = (c(113)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1355),h0tab(:,1355),[17,2,8,4],[nMB,nMB,nMT,nMT],4,1,wf3(:,4))
  call Hloop_AS_Q(ntryL,G0H36(1),wf3(:,4),G0H12(324),ngPtb,m3h3x12(:,1211),heltab2x36(:,:,1211))
  call Hloop_A_Q(ntryL,G0H12(324),17,nMB,G1H12(526),n2h12(156))
  Gcoeff(:)%j = (c(154)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1356),h0tab(:,1356),[17,2,8,4],[0,0,0,0],4,1,wf3(:,2))
  call Hloop_QW_A(ntryL,G0H36(1),wf3(:,2),G0H12(324),m3h3x12(:,1212),heltab2x36(:,:,1212))
  call Hloop_Q_A(ntryL,G0H12(324),17,0,G1H12(527),n2h12(157))
  Gcoeff(:)%j = (c(152)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1357),h0tab(:,1357),[17,2,8,4],[nMT,nMT,nMB,nMB],4,1,wf3(:,2))
  call Hloop_QW_A(ntryL,G0H36(1),wf3(:,2),G0H12(324),m3h3x12(:,1213),heltab2x36(:,:,1213))
  call Hloop_Q_A(ntryL,G0H12(324),17,nMT,G1H12(528),n2h12(158))
  Gcoeff(:)%j = (c(154)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1358),h0tab(:,1358),[17,2,8,4],[0,0,0,0],4,1,wf3(:,2))
  call Hloop_AW_Q(ntryL,G0H36(1),wf3(:,2),G0H12(324),m3h3x12(:,1214),heltab2x36(:,:,1214))
  call Hloop_A_Q(ntryL,G0H12(324),17,0,G1H12(529),n2h12(159))
  Gcoeff(:)%j = (c(152)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1359),h0tab(:,1359),[17,2,8,4],[nMB,nMB,nMT,nMT],4,1,wf3(:,2))
  call Hloop_AW_Q(ntryL,G0H36(1),wf3(:,2),G0H12(324),m3h3x12(:,1215),heltab2x36(:,:,1215))
  call Hloop_A_Q(ntryL,G0H12(324),17,nMB,G1H12(530),n2h12(160))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1360),h0tab(:,1360),[18,4,1,8],[nML,nML,nML,0],4,1,wf6(:,3))
  call Hloop_AS_Q(ntryL,G0H36(1),wf6(:,3),G0H6(73),ngPnl,m3h6x6(:,1),heltab2x36(:,:,1216))
  call Hloop_A_Q(ntryL,G0H6(73),18,nML,G1H6(167),n2h6(263))
  Gcoeff(:)%j = (-(c(144)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1361),h0tab(:,1361),[18,4,1,8],[nMT,nMT,nMT,nMB],4,1,wf6(:,3))
  call Hloop_QS_A(ntryL,G0H36(1),wf6(:,3),G0H6(73),ngPtb,m3h6x6(:,2),heltab2x36(:,:,1217))
  call Hloop_Q_A(ntryL,G0H6(73),18,nMT,G1H6(168),n2h6(264))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1362),h0tab(:,1362),[18,4,1,8],[nMB,nMB,nMB,nMT],4,1,wf6(:,3))
  call Hloop_AS_Q(ntryL,G0H36(1),wf6(:,3),G0H6(73),ngPtb,m3h6x6(:,3),heltab2x36(:,:,1218))
  call Hloop_A_Q(ntryL,G0H6(73),18,nMB,G1H6(174),n2h6(265))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1363),h0tab(:,1363),[18,4,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,3))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,3),G0H6(73),m3h6x6(:,4),heltab2x36(:,:,1219))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1364),h0tab(:,1364),[18,4,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,3))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,3),G0H6(74),m3h6x6(:,5),heltab2x36(:,:,1220))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1365),h0tab(:,1365),[18,4,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,3))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,3),G0H6(75),m3h6x6(:,6),heltab2x36(:,:,1221))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1366),h0tab(:,1366),[18,4,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,3))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,3),G0H6(76),m3h6x6(:,7),heltab2x36(:,:,1222))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1367),h0tab(:,1367),[18,4,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,3),G0H6(77),m3h6x6(:,8),heltab2x36(:,:,1223))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1368),h0tab(:,1368),[18,4,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,3),G0H6(78),m3h6x6(:,9),heltab2x36(:,:,1224))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1369),h0tab(:,1369),[18,4,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,3))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(175),m3h6x6(:,10),heltab2x36(:,:,1225))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1370),h0tab(:,1370),[18,4,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,3))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(181),m3h6x6(:,11),heltab2x36(:,:,1226))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1371),h0tab(:,1371),[18,4,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,3))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(182),m3h6x6(:,12),heltab2x36(:,:,1227))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1372),h0tab(:,1372),[18,4,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,3))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(235),m3h6x6(:,13),heltab2x36(:,:,1228))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1373),h0tab(:,1373),[18,4,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,3))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,3),G0H6(79),m3h6x6(:,14),heltab2x36(:,:,1229))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1374),h0tab(:,1374),[18,4,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,3))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,3),G0H6(80),m3h6x6(:,15),heltab2x36(:,:,1230))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1375),h0tab(:,1375),[18,4,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,3),G0H6(81),m3h6x6(:,16),heltab2x36(:,:,1231))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1376),h0tab(:,1376),[18,4,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,3),G0H6(82),m3h6x6(:,17),heltab2x36(:,:,1232))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1377),h0tab(:,1377),[18,4,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,3))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(76),m3h6x6(:,18),heltab2x36(:,:,1233))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1378),h0tab(:,1378),[18,4,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,3))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(237),m3h6x6(:,19),heltab2x36(:,:,1234))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1379),h0tab(:,1379),[18,4,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,3))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(32),m3h6x6(:,20),heltab2x36(:,:,1235))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1380),h0tab(:,1380),[18,4,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,3))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(240),m3h6x6(:,21),heltab2x36(:,:,1236))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1381),h0tab(:,1381),[18,4,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,3))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(242),m3h6x6(:,22),heltab2x36(:,:,1237))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1382),h0tab(:,1382),[18,4,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,3))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(285),m3h6x6(:,23),heltab2x36(:,:,1238))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1383),h0tab(:,1383),[18,4,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,3))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(286),m3h6x6(:,24),heltab2x36(:,:,1239))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1384),h0tab(:,1384),[18,4,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,3))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,3),G0H6(83),m3h6x6(:,25),heltab2x36(:,:,1240))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1385),h0tab(:,1385),[18,4,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,3),G0H6(84),m3h6x6(:,26),heltab2x36(:,:,1241))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1386),h0tab(:,1386),[18,4,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,3),G0H6(85),m3h6x6(:,27),heltab2x36(:,:,1242))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1387),h0tab(:,1387),[18,4,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,3),G0H6(86),m3h6x6(:,28),heltab2x36(:,:,1243))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1388),h0tab(:,1388),[18,4,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,3),G0H6(87),m3h6x6(:,29),heltab2x36(:,:,1244))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1389),h0tab(:,1389),[18,4,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,3))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(292),m3h6x6(:,30),heltab2x36(:,:,1245))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1390),h0tab(:,1390),[18,4,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,3))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(293),m3h6x6(:,31),heltab2x36(:,:,1246))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1391),h0tab(:,1391),[18,4,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,3))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(299),m3h6x6(:,32),heltab2x36(:,:,1247))
  Gcoeff(:)%j = (c(133)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1392),h0tab(:,1392),[18,4,1,8],[nML,nML,nML,0],4,1,wf6(:,10))
  call Hloop_AW_Q(ntryL,G0H36(1),wf6(:,10),G0H6(88),m3h6x6(:,33),heltab2x36(:,:,1248))
  call Hloop_A_Q(ntryL,G0H6(88),18,nML,G1H6(300),n2h6(266))
  Gcoeff(:)%j = (-(c(144)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1393),h0tab(:,1393),[18,4,1,8],[nMT,nMT,nMT,nMB],4,1,wf6(:,10))
  call Hloop_QW_A(ntryL,G0H36(1),wf6(:,10),G0H6(88),m3h6x6(:,34),heltab2x36(:,:,1249))
  call Hloop_Q_A(ntryL,G0H6(88),18,nMT,G1H6(26),n2h6(267))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1394),h0tab(:,1394),[18,4,1,8],[nMB,nMB,nMB,nMT],4,1,wf6(:,10))
  call Hloop_AW_Q(ntryL,G0H36(1),wf6(:,10),G0H6(88),m3h6x6(:,35),heltab2x36(:,:,1250))
  call Hloop_A_Q(ntryL,G0H6(88),18,nMB,G1H6(113),n2h6(268))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1395),h0tab(:,1395),[18,4,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,10))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(20),m3h6x6(:,36),heltab2x36(:,:,1251))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1396),h0tab(:,1396),[18,4,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,10))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(35),m3h6x6(:,37),heltab2x36(:,:,1252))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1397),h0tab(:,1397),[18,4,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,10))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf6(:,10),G1H6(15),m3h6x6(:,38),heltab2x36(:,:,1253))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1398),h0tab(:,1398),[18,4,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,10))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf6(:,10),G1H6(24),m3h6x6(:,39),heltab2x36(:,:,1254))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1399),h0tab(:,1399),[18,4,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,10))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(47),m3h6x6(:,40),heltab2x36(:,:,1255))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1400),h0tab(:,1400),[18,4,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,10))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(49),m3h6x6(:,41),heltab2x36(:,:,1256))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1401),h0tab(:,1401),[18,4,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,10))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(340),m3h6x6(:,42),heltab2x36(:,:,1257))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1402),h0tab(:,1402),[18,4,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,10))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(342),m3h6x6(:,43),heltab2x36(:,:,1258))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1403),h0tab(:,1403),[18,4,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,10))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,10),G0H6(88),m3h6x6(:,44),heltab2x36(:,:,1259))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1404),h0tab(:,1404),[18,4,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,10))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,10),G0H6(89),m3h6x6(:,45),heltab2x36(:,:,1260))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1405),h0tab(:,1405),[18,4,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),wf6(:,10),G0H6(90),m3h6x6(:,46),heltab2x36(:,:,1261))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1406),h0tab(:,1406),[18,4,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,10))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(357),m3h6x6(:,47),heltab2x36(:,:,1262))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1407),h0tab(:,1407),[18,4,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,10))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(358),m3h6x6(:,48),heltab2x36(:,:,1263))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1408),h0tab(:,1408),[18,4,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,10))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(403),m3h6x6(:,49),heltab2x36(:,:,1264))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1409),h0tab(:,1409),[18,4,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,10))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(404),m3h6x6(:,50),heltab2x36(:,:,1265))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1410),h0tab(:,1410),[18,4,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,10))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(419),m3h6x6(:,51),heltab2x36(:,:,1266))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1411),h0tab(:,1411),[18,4,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,10))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,10),G0H6(91),m3h6x6(:,52),heltab2x36(:,:,1267))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1412),h0tab(:,1412),[18,4,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,10))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,10),G0H6(92),m3h6x6(:,53),heltab2x36(:,:,1268))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1413),h0tab(:,1413),[18,4,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),wf6(:,10),G0H6(93),m3h6x6(:,54),heltab2x36(:,:,1269))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1414),h0tab(:,1414),[18,4,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,10))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,10),G0H6(94),m3h6x6(:,55),heltab2x36(:,:,1270))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1415),h0tab(:,1415),[18,4,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,10))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,10),G0H6(95),m3h6x6(:,56),heltab2x36(:,:,1271))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1416),h0tab(:,1416),[18,4,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),wf6(:,10),G0H6(96),m3h6x6(:,57),heltab2x36(:,:,1272))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1417),h0tab(:,1417),[18,4,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,10))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(420),m3h6x6(:,58),heltab2x36(:,:,1273))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1418),h0tab(:,1418),[18,4,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,10))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(435),m3h6x6(:,59),heltab2x36(:,:,1274))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1419),h0tab(:,1419),[18,4,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,10))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(436),m3h6x6(:,60),heltab2x36(:,:,1275))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1420),h0tab(:,1420),[18,4,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,10))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(481),m3h6x6(:,61),heltab2x36(:,:,1276))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1421),h0tab(:,1421),[18,4,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,10))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(482),m3h6x6(:,62),heltab2x36(:,:,1277))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1422),h0tab(:,1422),[18,4,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,10))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,10),G0H6(97),m3h6x6(:,63),heltab2x36(:,:,1278))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1423),h0tab(:,1423),[18,4,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,10))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,10),G0H6(98),m3h6x6(:,64),heltab2x36(:,:,1279))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1424),h0tab(:,1424),[18,4,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),wf6(:,10),G0H6(99),m3h6x6(:,65),heltab2x36(:,:,1280))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1425),h0tab(:,1425),[18,1,4,8],[nML,nML,nML,0],4,1,wf6(:,3))
  call Hloop_AS_Q(ntryL,G0H36(1),wf6(:,3),G0H6(100),ngPnl,m3h6x6(:,66),heltab2x36(:,:,1281))
  call Hloop_A_Q(ntryL,G0H6(100),18,nML,G1H6(497),n2h6(269))
  Gcoeff(:)%j = (-(c(144)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1426),h0tab(:,1426),[18,1,4,8],[nMT,nMT,nMT,nMB],4,1,wf6(:,3))
  call Hloop_QS_A(ntryL,G0H36(1),wf6(:,3),G0H6(100),ngPtb,m3h6x6(:,67),heltab2x36(:,:,1282))
  call Hloop_Q_A(ntryL,G0H6(100),18,nMT,G1H6(498),n2h6(270))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1427),h0tab(:,1427),[18,1,4,8],[nMB,nMB,nMB,nMT],4,1,wf6(:,3))
  call Hloop_AS_Q(ntryL,G0H36(1),wf6(:,3),G0H6(100),ngPtb,m3h6x6(:,68),heltab2x36(:,:,1283))
  call Hloop_A_Q(ntryL,G0H6(100),18,nMB,G1H6(513),n2h6(271))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1428),h0tab(:,1428),[18,1,4,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,3))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,3),G0H6(100),m3h6x6(:,69),heltab2x36(:,:,1284))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1429),h0tab(:,1429),[18,1,4,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,3))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,3),G0H6(101),m3h6x6(:,70),heltab2x36(:,:,1285))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1430),h0tab(:,1430),[18,1,4,8],[nMW,nMW,nMW,0],4,1,wf6(:,3))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,3),G0H6(102),m3h6x6(:,71),heltab2x36(:,:,1286))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1431),h0tab(:,1431),[18,1,4,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,3))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,3),G0H6(103),m3h6x6(:,72),heltab2x36(:,:,1287))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1432),h0tab(:,1432),[18,1,4,8],[nMW,nMW,nMW,0],4,1,wf6(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,3),G0H6(104),m3h6x6(:,73),heltab2x36(:,:,1288))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1433),h0tab(:,1433),[18,1,4,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,3),G0H6(105),m3h6x6(:,74),heltab2x36(:,:,1289))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1434),h0tab(:,1434),[18,1,4,8],[nMW,nMW,nMW,0],4,1,wf6(:,3))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(514),m3h6x6(:,75),heltab2x36(:,:,1290))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1435),h0tab(:,1435),[18,1,4,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,3))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(529),m3h6x6(:,76),heltab2x36(:,:,1291))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1436),h0tab(:,1436),[18,1,4,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,3))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,3),G0H6(106),m3h6x6(:,77),heltab2x36(:,:,1292))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1437),h0tab(:,1437),[18,1,4,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,3))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(530),m3h6x6(:,78),heltab2x36(:,:,1293))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1438),h0tab(:,1438),[18,1,4,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,3))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(545),m3h6x6(:,79),heltab2x36(:,:,1294))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1439),h0tab(:,1439),[18,1,4,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,3))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,3),G0H6(107),m3h6x6(:,80),heltab2x36(:,:,1295))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1440),h0tab(:,1440),[18,1,4,8],[nMW,nMW,nMW,0],4,1,wf6(:,3))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(546),m3h6x6(:,81),heltab2x36(:,:,1296))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1441),h0tab(:,1441),[18,1,4,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,3))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(591),m3h6x6(:,82),heltab2x36(:,:,1297))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1442),h0tab(:,1442),[18,1,4,8],[nMW,nMW,nMW,0],4,1,wf6(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,3),G0H6(108),m3h6x6(:,83),heltab2x36(:,:,1298))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1443),h0tab(:,1443),[18,1,4,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,3),G0H6(109),m3h6x6(:,84),heltab2x36(:,:,1299))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1444),h0tab(:,1444),[18,1,4,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,3))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(592),m3h6x6(:,85),heltab2x36(:,:,1300))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1445),h0tab(:,1445),[18,1,4,8],[nMW,nMW,nMW,0],4,1,wf6(:,3))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(607),m3h6x6(:,86),heltab2x36(:,:,1301))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1446),h0tab(:,1446),[18,1,4,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,3))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(608),m3h6x6(:,87),heltab2x36(:,:,1302))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1447),h0tab(:,1447),[18,1,4,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,3))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,3),G0H6(110),m3h6x6(:,88),heltab2x36(:,:,1303))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1448),h0tab(:,1448),[18,1,4,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,3))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(623),m3h6x6(:,89),heltab2x36(:,:,1304))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1449),h0tab(:,1449),[18,1,4,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,3))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(624),m3h6x6(:,90),heltab2x36(:,:,1305))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1450),h0tab(:,1450),[18,1,4,8],[nMW,nMW,nMW,0],4,1,wf6(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,3),G0H6(111),m3h6x6(:,91),heltab2x36(:,:,1306))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1451),h0tab(:,1451),[18,1,4,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,3),G0H6(112),m3h6x6(:,92),heltab2x36(:,:,1307))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1452),h0tab(:,1452),[18,1,4,8],[nMW,nMW,nMW,0],4,1,wf6(:,3))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(639),m3h6x6(:,93),heltab2x36(:,:,1308))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1453),h0tab(:,1453),[18,1,4,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,3))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(640),m3h6x6(:,94),heltab2x36(:,:,1309))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1454),h0tab(:,1454),[18,1,4,8],[nMW,nMW,nMW,0],4,1,wf6(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,3),G0H6(113),m3h6x6(:,95),heltab2x36(:,:,1310))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1455),h0tab(:,1455),[18,1,4,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,3),G0H6(114),m3h6x6(:,96),heltab2x36(:,:,1311))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1456),h0tab(:,1456),[18,1,4,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,3))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(655),m3h6x6(:,97),heltab2x36(:,:,1312))
  Gcoeff(:)%j = (c(133)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1457),h0tab(:,1457),[18,1,4,8],[nML,nML,nML,0],4,1,wf6(:,10))
  call Hloop_AW_Q(ntryL,G0H36(1),wf6(:,10),G0H6(115),m3h6x6(:,98),heltab2x36(:,:,1313))
  call Hloop_A_Q(ntryL,G0H6(115),18,nML,G1H6(656),n2h6(272))
  Gcoeff(:)%j = (-(c(144)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1458),h0tab(:,1458),[18,1,4,8],[nMT,nMT,nMT,nMB],4,1,wf6(:,10))
  call Hloop_QW_A(ntryL,G0H36(1),wf6(:,10),G0H6(115),m3h6x6(:,99),heltab2x36(:,:,1314))
  call Hloop_Q_A(ntryL,G0H6(115),18,nMT,G1H6(701),n2h6(273))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1459),h0tab(:,1459),[18,1,4,8],[nMB,nMB,nMB,nMT],4,1,wf6(:,10))
  call Hloop_AW_Q(ntryL,G0H36(1),wf6(:,10),G0H6(115),m3h6x6(:,100),heltab2x36(:,:,1315))
  call Hloop_A_Q(ntryL,G0H6(115),18,nMB,G1H6(702),n2h6(274))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1460),h0tab(:,1460),[18,1,4,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,10))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(717),m3h6x6(:,101),heltab2x36(:,:,1316))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1461),h0tab(:,1461),[18,1,4,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,10))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(718),m3h6x6(:,102),heltab2x36(:,:,1317))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1462),h0tab(:,1462),[18,1,4,8],[nMW,nMW,nMW,0],4,1,wf6(:,10))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf6(:,10),G1H6(21),m3h6x6(:,103),heltab2x36(:,:,1318))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1463),h0tab(:,1463),[18,1,4,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,10))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf6(:,10),G1H6(120),m3h6x6(:,104),heltab2x36(:,:,1319))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1464),h0tab(:,1464),[18,1,4,8],[nMW,nMW,nMW,0],4,1,wf6(:,10))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(23),m3h6x6(:,105),heltab2x36(:,:,1320))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1465),h0tab(:,1465),[18,1,4,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,10))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(122),m3h6x6(:,106),heltab2x36(:,:,1321))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1466),h0tab(:,1466),[18,1,4,8],[nMW,nMW,nMW,0],4,1,wf6(:,10))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(8),m3h6x6(:,107),heltab2x36(:,:,1322))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1467),h0tab(:,1467),[18,1,4,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,10))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(123),m3h6x6(:,108),heltab2x36(:,:,1323))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1468),h0tab(:,1468),[18,1,4,8],[nMW,nMW,nMW,0],4,1,wf6(:,10))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,10),G0H6(115),m3h6x6(:,109),heltab2x36(:,:,1324))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1469),h0tab(:,1469),[18,1,4,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,10))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,10),G0H6(116),m3h6x6(:,110),heltab2x36(:,:,1325))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1470),h0tab(:,1470),[18,1,4,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,10))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(126),m3h6x6(:,111),heltab2x36(:,:,1326))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1471),h0tab(:,1471),[18,1,4,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),wf6(:,10),G0H6(117),m3h6x6(:,112),heltab2x36(:,:,1327))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1472),h0tab(:,1472),[18,1,4,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,10))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(29),m3h6x6(:,113),heltab2x36(:,:,1328))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1473),h0tab(:,1473),[18,1,4,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,10))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(127),m3h6x6(:,114),heltab2x36(:,:,1329))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1474),h0tab(:,1474),[18,1,4,8],[nMW,nMW,nMW,0],4,1,wf6(:,10))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,10),G0H6(118),m3h6x6(:,115),heltab2x36(:,:,1330))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1475),h0tab(:,1475),[18,1,4,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,10))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,10),G0H6(119),m3h6x6(:,116),heltab2x36(:,:,1331))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1476),h0tab(:,1476),[18,1,4,8],[nMW,nMW,nMW,0],4,1,wf6(:,10))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(1),m3h6x6(:,117),heltab2x36(:,:,1332))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1477),h0tab(:,1477),[18,1,4,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,10))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(131),m3h6x6(:,118),heltab2x36(:,:,1333))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1478),h0tab(:,1478),[18,1,4,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),wf6(:,10),G0H6(120),m3h6x6(:,119),heltab2x36(:,:,1334))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1479),h0tab(:,1479),[18,1,4,8],[nMW,nMW,nMW,0],4,1,wf6(:,10))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,10),G0H6(121),m3h6x6(:,120),heltab2x36(:,:,1335))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1480),h0tab(:,1480),[18,1,4,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,10))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,10),G0H6(122),m3h6x6(:,121),heltab2x36(:,:,1336))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1481),h0tab(:,1481),[18,1,4,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,10))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(132),m3h6x6(:,122),heltab2x36(:,:,1337))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1482),h0tab(:,1482),[18,1,4,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),wf6(:,10),G0H6(123),m3h6x6(:,123),heltab2x36(:,:,1338))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1483),h0tab(:,1483),[18,1,4,8],[nMW,nMW,nMW,0],4,1,wf6(:,10))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(133),m3h6x6(:,124),heltab2x36(:,:,1339))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1484),h0tab(:,1484),[18,1,4,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,10))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(134),m3h6x6(:,125),heltab2x36(:,:,1340))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1485),h0tab(:,1485),[18,1,4,8],[nMW,nMW,nMW,0],4,1,wf6(:,10))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,10),G0H6(124),m3h6x6(:,126),heltab2x36(:,:,1341))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1486),h0tab(:,1486),[18,1,4,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,10))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,10),G0H6(125),m3h6x6(:,127),heltab2x36(:,:,1342))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1487),h0tab(:,1487),[18,1,4,8],[nMW,nMW,nMW,0],4,1,wf6(:,10))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(138),m3h6x6(:,128),heltab2x36(:,:,1343))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1488),h0tab(:,1488),[18,1,4,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,10))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(139),m3h6x6(:,129),heltab2x36(:,:,1344))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1489),h0tab(:,1489),[18,1,4,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),wf6(:,10),G0H6(126),m3h6x6(:,130),heltab2x36(:,:,1345))
  Gcoeff(:)%j = (c(142)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1490),h0tab(:,1490),[18,1,8,4],[nMT,nMT,nMB,nMB],4,1,wf6(:,3))
  call Hloop_QS_A(ntryL,G0H36(1),wf6(:,3),G0H6(127),ngPtb,m3h6x6(:,131),heltab2x36(:,:,1346))
  call Hloop_Q_A(ntryL,G0H6(127),18,nMT,G1H6(41),n2h6(275))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1491),h0tab(:,1491),[18,1,8,4],[nMB,nMB,nMT,nMT],4,1,wf6(:,3))
  call Hloop_AS_Q(ntryL,G0H36(1),wf6(:,3),G0H6(127),ngPtb,m3h6x6(:,132),heltab2x36(:,:,1347))
  call Hloop_A_Q(ntryL,G0H6(127),18,nMB,G1H6(42),n2h6(276))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1492),h0tab(:,1492),[18,1,8,4],[nMH,nMH,nMW,nMW],4,1,wf6(:,3))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,3),G0H6(127),m3h6x6(:,133),heltab2x36(:,:,1348))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1493),h0tab(:,1493),[18,1,8,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,3))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,3),G0H6(128),m3h6x6(:,134),heltab2x36(:,:,1349))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1494),h0tab(:,1494),[18,1,8,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,3))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,3),G0H6(129),m3h6x6(:,135),heltab2x36(:,:,1350))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1495),h0tab(:,1495),[18,1,8,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,3),G0H6(130),m3h6x6(:,136),heltab2x36(:,:,1351))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1496),h0tab(:,1496),[18,1,8,4],[nMH,nMH,nMW,nMW],4,1,wf6(:,3))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(141),m3h6x6(:,137),heltab2x36(:,:,1352))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1497),h0tab(:,1497),[18,1,8,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,3))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(142),m3h6x6(:,138),heltab2x36(:,:,1353))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1498),h0tab(:,1498),[18,1,8,4],[nMH,nMH,nMW,nMW],4,1,wf6(:,3))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,3),G0H6(131),m3h6x6(:,139),heltab2x36(:,:,1354))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1499),h0tab(:,1499),[18,1,8,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,3))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(143),m3h6x6(:,140),heltab2x36(:,:,1355))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1500),h0tab(:,1500),[18,1,8,4],[nMH,nMH,nMW,nMW],4,1,wf6(:,3))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(145),m3h6x6(:,141),heltab2x36(:,:,1356))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1501),h0tab(:,1501),[18,1,8,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,3),G0H6(132),m3h6x6(:,142),heltab2x36(:,:,1357))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1502),h0tab(:,1502),[18,1,8,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,3))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(148),m3h6x6(:,143),heltab2x36(:,:,1358))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1503),h0tab(:,1503),[18,1,8,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,3))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(149),m3h6x6(:,144),heltab2x36(:,:,1359))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1504),h0tab(:,1504),[18,1,8,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,3))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(151),m3h6x6(:,145),heltab2x36(:,:,1360))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1505),h0tab(:,1505),[18,1,8,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,3),G0H6(133),m3h6x6(:,146),heltab2x36(:,:,1361))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1506),h0tab(:,1506),[18,1,8,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,3))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,3),18,G1H6(152),m3h6x6(:,147),heltab2x36(:,:,1362))
  Gcoeff(:)%j = (c(142)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1507),h0tab(:,1507),[18,1,8,4],[nMT,nMT,nMB,nMB],4,1,wf6(:,10))
  call Hloop_QW_A(ntryL,G0H36(1),wf6(:,10),G0H6(134),m3h6x6(:,148),heltab2x36(:,:,1363))
  call Hloop_Q_A(ntryL,G0H6(134),18,nMT,G1H6(50),n2h6(277))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1508),h0tab(:,1508),[18,1,8,4],[nMB,nMB,nMT,nMT],4,1,wf6(:,10))
  call Hloop_AW_Q(ntryL,G0H36(1),wf6(:,10),G0H6(134),m3h6x6(:,149),heltab2x36(:,:,1364))
  call Hloop_A_Q(ntryL,G0H6(134),18,nMB,G1H6(154),n2h6(278))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1509),h0tab(:,1509),[18,1,8,4],[nMH,nMH,nMW,nMW],4,1,wf6(:,10))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(155),m3h6x6(:,150),heltab2x36(:,:,1365))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1510),h0tab(:,1510),[18,1,8,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,10))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(156),m3h6x6(:,151),heltab2x36(:,:,1366))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1511),h0tab(:,1511),[18,1,8,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,10))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(160),m3h6x6(:,152),heltab2x36(:,:,1367))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1512),h0tab(:,1512),[18,1,8,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,10))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf6(:,10),G1H6(161),m3h6x6(:,153),heltab2x36(:,:,1368))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1513),h0tab(:,1513),[18,1,8,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,10))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(162),m3h6x6(:,154),heltab2x36(:,:,1369))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1514),h0tab(:,1514),[18,1,8,4],[nMH,nMH,nMW,nMW],4,1,wf6(:,10))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,10),G0H6(134),m3h6x6(:,155),heltab2x36(:,:,1370))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1515),h0tab(:,1515),[18,1,8,4],[nMH,nMH,nMW,nMW],4,1,wf6(:,10))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(52),m3h6x6(:,156),heltab2x36(:,:,1371))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1516),h0tab(:,1516),[18,1,8,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),wf6(:,10),G0H6(135),m3h6x6(:,157),heltab2x36(:,:,1372))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1517),h0tab(:,1517),[18,1,8,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,10))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(369),m3h6x6(:,158),heltab2x36(:,:,1373))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1518),h0tab(:,1518),[18,1,8,4],[nMH,nMH,nMW,nMW],4,1,wf6(:,10))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,10),G0H6(136),m3h6x6(:,159),heltab2x36(:,:,1374))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1519),h0tab(:,1519),[18,1,8,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,10))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(374),m3h6x6(:,160),heltab2x36(:,:,1375))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1520),h0tab(:,1520),[18,1,8,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,10))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(169),m3h6x6(:,161),heltab2x36(:,:,1376))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1521),h0tab(:,1521),[18,1,8,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),wf6(:,10),G0H6(137),m3h6x6(:,162),heltab2x36(:,:,1377))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1522),h0tab(:,1522),[18,1,8,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,10))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf6(:,10),18,G1H6(170),m3h6x6(:,163),heltab2x36(:,:,1378))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1523),h0tab(:,1523),[18,1,8,4],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,10))
  call Hloop_SV_V(ntryL,G0H36(1),wf6(:,10),G0H6(138),m3h6x6(:,164),heltab2x36(:,:,1379))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1524),h0tab(:,1524),[20,2,1,8],[nML,nML,nML,0],4,1,wf6(:,7))
  call Hloop_AS_Q(ntryL,G0H36(1),wf6(:,7),G0H6(139),ngPnl,m3h6x6(:,165),heltab2x36(:,:,1380))
  call Hloop_A_Q(ntryL,G0H6(139),20,nML,G1H6(379),n2h6(279))
  Gcoeff(:)%j = (-(c(144)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1525),h0tab(:,1525),[20,2,1,8],[nMT,nMT,nMT,nMB],4,1,wf6(:,7))
  call Hloop_QS_A(ntryL,G0H36(1),wf6(:,7),G0H6(139),ngPtb,m3h6x6(:,166),heltab2x36(:,:,1381))
  call Hloop_Q_A(ntryL,G0H6(139),20,nMT,G1H6(384),n2h6(280))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1526),h0tab(:,1526),[20,2,1,8],[nMB,nMB,nMB,nMT],4,1,wf6(:,7))
  call Hloop_AS_Q(ntryL,G0H36(1),wf6(:,7),G0H6(139),ngPtb,m3h6x6(:,167),heltab2x36(:,:,1382))
  call Hloop_A_Q(ntryL,G0H6(139),20,nMB,G1H6(176),n2h6(281))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1527),h0tab(:,1527),[20,2,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,7))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,7),G0H6(139),m3h6x6(:,168),heltab2x36(:,:,1383))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1528),h0tab(:,1528),[20,2,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,7))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,7),G0H6(140),m3h6x6(:,169),heltab2x36(:,:,1384))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1529),h0tab(:,1529),[20,2,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,7))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,7),G0H6(141),m3h6x6(:,170),heltab2x36(:,:,1385))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1530),h0tab(:,1530),[20,2,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,7))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,7),G0H6(142),m3h6x6(:,171),heltab2x36(:,:,1386))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1531),h0tab(:,1531),[20,2,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,7))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,7),G0H6(143),m3h6x6(:,172),heltab2x36(:,:,1387))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1532),h0tab(:,1532),[20,2,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,7))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,7),G0H6(144),m3h6x6(:,173),heltab2x36(:,:,1388))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1533),h0tab(:,1533),[20,2,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,7))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(178),m3h6x6(:,174),heltab2x36(:,:,1389))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1534),h0tab(:,1534),[20,2,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,7))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(389),m3h6x6(:,175),heltab2x36(:,:,1390))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1535),h0tab(:,1535),[20,2,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,7))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(394),m3h6x6(:,176),heltab2x36(:,:,1391))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1536),h0tab(:,1536),[20,2,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,7))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(184),m3h6x6(:,177),heltab2x36(:,:,1392))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1537),h0tab(:,1537),[20,2,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,7))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,7),G0H6(145),m3h6x6(:,178),heltab2x36(:,:,1393))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1538),h0tab(:,1538),[20,2,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,7))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,7),G0H6(146),m3h6x6(:,179),heltab2x36(:,:,1394))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1539),h0tab(:,1539),[20,2,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,7))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,7),G0H6(147),m3h6x6(:,180),heltab2x36(:,:,1395))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1540),h0tab(:,1540),[20,2,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,7))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,7),G0H6(148),m3h6x6(:,181),heltab2x36(:,:,1396))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1541),h0tab(:,1541),[20,2,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,7))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(185),m3h6x6(:,182),heltab2x36(:,:,1397))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1542),h0tab(:,1542),[20,2,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,7))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(188),m3h6x6(:,183),heltab2x36(:,:,1398))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1543),h0tab(:,1543),[20,2,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,7))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(190),m3h6x6(:,184),heltab2x36(:,:,1399))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1544),h0tab(:,1544),[20,2,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,7))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(191),m3h6x6(:,185),heltab2x36(:,:,1400))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1545),h0tab(:,1545),[20,2,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,7))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(192),m3h6x6(:,186),heltab2x36(:,:,1401))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1546),h0tab(:,1546),[20,2,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,7))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(196),m3h6x6(:,187),heltab2x36(:,:,1402))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1547),h0tab(:,1547),[20,2,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,7))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(197),m3h6x6(:,188),heltab2x36(:,:,1403))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1548),h0tab(:,1548),[20,2,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,7))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,7),G0H6(149),m3h6x6(:,189),heltab2x36(:,:,1404))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1549),h0tab(:,1549),[20,2,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,7))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,7),G0H6(150),m3h6x6(:,190),heltab2x36(:,:,1405))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1550),h0tab(:,1550),[20,2,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,7))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,7),G0H6(151),m3h6x6(:,191),heltab2x36(:,:,1406))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1551),h0tab(:,1551),[20,2,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,7))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,7),G0H6(152),m3h6x6(:,192),heltab2x36(:,:,1407))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1552),h0tab(:,1552),[20,2,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,7))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,7),G0H6(153),m3h6x6(:,193),heltab2x36(:,:,1408))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1553),h0tab(:,1553),[20,2,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,7))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(198),m3h6x6(:,194),heltab2x36(:,:,1409))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1554),h0tab(:,1554),[20,2,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,7))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(199),m3h6x6(:,195),heltab2x36(:,:,1410))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1555),h0tab(:,1555),[20,2,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,7))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(203),m3h6x6(:,196),heltab2x36(:,:,1411))
  Gcoeff(:)%j = (c(133)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1556),h0tab(:,1556),[20,2,1,8],[nML,nML,nML,0],4,1,wf6(:,15))
  call Hloop_AW_Q(ntryL,G0H36(1),wf6(:,15),G0H6(154),m3h6x6(:,197),heltab2x36(:,:,1412))
  call Hloop_A_Q(ntryL,G0H6(154),20,nML,G1H6(204),n2h6(282))
  Gcoeff(:)%j = (-(c(144)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1557),h0tab(:,1557),[20,2,1,8],[nMT,nMT,nMT,nMB],4,1,wf6(:,15))
  call Hloop_QW_A(ntryL,G0H36(1),wf6(:,15),G0H6(154),m3h6x6(:,198),heltab2x36(:,:,1413))
  call Hloop_Q_A(ntryL,G0H6(154),20,nMT,G1H6(205),n2h6(283))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1558),h0tab(:,1558),[20,2,1,8],[nMB,nMB,nMB,nMT],4,1,wf6(:,15))
  call Hloop_AW_Q(ntryL,G0H36(1),wf6(:,15),G0H6(154),m3h6x6(:,199),heltab2x36(:,:,1414))
  call Hloop_A_Q(ntryL,G0H6(154),20,nMB,G1H6(206),n2h6(284))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1559),h0tab(:,1559),[20,2,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,15))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(210),m3h6x6(:,200),heltab2x36(:,:,1415))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1560),h0tab(:,1560),[20,2,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,15))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(211),m3h6x6(:,201),heltab2x36(:,:,1416))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1561),h0tab(:,1561),[20,2,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,15))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf6(:,15),G1H6(212),m3h6x6(:,202),heltab2x36(:,:,1417))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1562),h0tab(:,1562),[20,2,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,15))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf6(:,15),G1H6(214),m3h6x6(:,203),heltab2x36(:,:,1418))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1563),h0tab(:,1563),[20,2,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,15))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(217),m3h6x6(:,204),heltab2x36(:,:,1419))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1564),h0tab(:,1564),[20,2,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,15))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(218),m3h6x6(:,205),heltab2x36(:,:,1420))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1565),h0tab(:,1565),[20,2,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,15))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(220),m3h6x6(:,206),heltab2x36(:,:,1421))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1566),h0tab(:,1566),[20,2,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,15))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(221),m3h6x6(:,207),heltab2x36(:,:,1422))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1567),h0tab(:,1567),[20,2,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,15))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,15),G0H6(154),m3h6x6(:,208),heltab2x36(:,:,1423))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1568),h0tab(:,1568),[20,2,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,15))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,15),G0H6(155),m3h6x6(:,209),heltab2x36(:,:,1424))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1569),h0tab(:,1569),[20,2,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,15))
  call Hloop_SV_V(ntryL,G0H36(1),wf6(:,15),G0H6(156),m3h6x6(:,210),heltab2x36(:,:,1425))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1570),h0tab(:,1570),[20,2,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,15))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(224),m3h6x6(:,211),heltab2x36(:,:,1426))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1571),h0tab(:,1571),[20,2,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,15))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(226),m3h6x6(:,212),heltab2x36(:,:,1427))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1572),h0tab(:,1572),[20,2,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,15))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(227),m3h6x6(:,213),heltab2x36(:,:,1428))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1573),h0tab(:,1573),[20,2,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,15))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(228),m3h6x6(:,214),heltab2x36(:,:,1429))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1574),h0tab(:,1574),[20,2,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,15))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(56),m3h6x6(:,215),heltab2x36(:,:,1430))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1575),h0tab(:,1575),[20,2,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,15))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,15),G0H6(157),m3h6x6(:,216),heltab2x36(:,:,1431))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1576),h0tab(:,1576),[20,2,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,15))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,15),G0H6(158),m3h6x6(:,217),heltab2x36(:,:,1432))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1577),h0tab(:,1577),[20,2,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,15))
  call Hloop_SV_V(ntryL,G0H36(1),wf6(:,15),G0H6(159),m3h6x6(:,218),heltab2x36(:,:,1433))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1578),h0tab(:,1578),[20,2,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,15))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,15),G0H6(160),m3h6x6(:,219),heltab2x36(:,:,1434))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1579),h0tab(:,1579),[20,2,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,15))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,15),G0H6(161),m3h6x6(:,220),heltab2x36(:,:,1435))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1580),h0tab(:,1580),[20,2,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,15))
  call Hloop_SV_V(ntryL,G0H36(1),wf6(:,15),G0H6(162),m3h6x6(:,221),heltab2x36(:,:,1436))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1581),h0tab(:,1581),[20,2,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,15))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(229),m3h6x6(:,222),heltab2x36(:,:,1437))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1582),h0tab(:,1582),[20,2,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,15))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(230),m3h6x6(:,223),heltab2x36(:,:,1438))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1583),h0tab(:,1583),[20,2,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,15))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(67),m3h6x6(:,224),heltab2x36(:,:,1439))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1584),h0tab(:,1584),[20,2,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,15))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(71),m3h6x6(:,225),heltab2x36(:,:,1440))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1585),h0tab(:,1585),[20,2,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,15))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(72),m3h6x6(:,226),heltab2x36(:,:,1441))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1586),h0tab(:,1586),[20,2,1,8],[nMW,nMW,nMW,0],4,1,wf6(:,15))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,15),G0H6(163),m3h6x6(:,227),heltab2x36(:,:,1442))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1587),h0tab(:,1587),[20,2,1,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,15))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,15),G0H6(164),m3h6x6(:,228),heltab2x36(:,:,1443))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1588),h0tab(:,1588),[20,2,1,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,15))
  call Hloop_SV_V(ntryL,G0H36(1),wf6(:,15),G0H6(165),m3h6x6(:,229),heltab2x36(:,:,1444))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1589),h0tab(:,1589),[20,1,2,8],[nML,nML,nML,0],4,1,wf6(:,7))
  call Hloop_AS_Q(ntryL,G0H36(1),wf6(:,7),G0H6(166),ngPnl,m3h6x6(:,230),heltab2x36(:,:,1445))
  call Hloop_A_Q(ntryL,G0H6(166),20,nML,G1H6(66),n2h6(285))
  Gcoeff(:)%j = (-(c(144)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1590),h0tab(:,1590),[20,1,2,8],[nMT,nMT,nMT,nMB],4,1,wf6(:,7))
  call Hloop_QS_A(ntryL,G0H36(1),wf6(:,7),G0H6(166),ngPtb,m3h6x6(:,231),heltab2x36(:,:,1446))
  call Hloop_Q_A(ntryL,G0H6(166),20,nMT,G1H6(231),n2h6(286))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1591),h0tab(:,1591),[20,1,2,8],[nMB,nMB,nMB,nMT],4,1,wf6(:,7))
  call Hloop_AS_Q(ntryL,G0H36(1),wf6(:,7),G0H6(166),ngPtb,m3h6x6(:,232),heltab2x36(:,:,1447))
  call Hloop_A_Q(ntryL,G0H6(166),20,nMB,G1H6(457),n2h6(287))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1592),h0tab(:,1592),[20,1,2,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,7))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,7),G0H6(166),m3h6x6(:,233),heltab2x36(:,:,1448))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1593),h0tab(:,1593),[20,1,2,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,7))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,7),G0H6(167),m3h6x6(:,234),heltab2x36(:,:,1449))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1594),h0tab(:,1594),[20,1,2,8],[nMW,nMW,nMW,0],4,1,wf6(:,7))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,7),G0H6(168),m3h6x6(:,235),heltab2x36(:,:,1450))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1595),h0tab(:,1595),[20,1,2,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,7))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,7),G0H6(169),m3h6x6(:,236),heltab2x36(:,:,1451))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1596),h0tab(:,1596),[20,1,2,8],[nMW,nMW,nMW,0],4,1,wf6(:,7))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,7),G0H6(170),m3h6x6(:,237),heltab2x36(:,:,1452))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1597),h0tab(:,1597),[20,1,2,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,7))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,7),G0H6(171),m3h6x6(:,238),heltab2x36(:,:,1453))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1598),h0tab(:,1598),[20,1,2,8],[nMW,nMW,nMW,0],4,1,wf6(:,7))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(462),m3h6x6(:,239),heltab2x36(:,:,1454))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1599),h0tab(:,1599),[20,1,2,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,7))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(31),m3h6x6(:,240),heltab2x36(:,:,1455))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1600),h0tab(:,1600),[20,1,2,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,7))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,7),G0H6(172),m3h6x6(:,241),heltab2x36(:,:,1456))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1601),h0tab(:,1601),[20,1,2,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,7))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(77),m3h6x6(:,242),heltab2x36(:,:,1457))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1602),h0tab(:,1602),[20,1,2,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,7))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(467),m3h6x6(:,243),heltab2x36(:,:,1458))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1603),h0tab(:,1603),[20,1,2,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,7))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,7),G0H6(173),m3h6x6(:,244),heltab2x36(:,:,1459))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1604),h0tab(:,1604),[20,1,2,8],[nMW,nMW,nMW,0],4,1,wf6(:,7))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(472),m3h6x6(:,245),heltab2x36(:,:,1460))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1605),h0tab(:,1605),[20,1,2,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,7))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(238),m3h6x6(:,246),heltab2x36(:,:,1461))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1606),h0tab(:,1606),[20,1,2,8],[nMW,nMW,nMW,0],4,1,wf6(:,7))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,7),G0H6(174),m3h6x6(:,247),heltab2x36(:,:,1462))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1607),h0tab(:,1607),[20,1,2,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,7))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,7),G0H6(175),m3h6x6(:,248),heltab2x36(:,:,1463))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1608),h0tab(:,1608),[20,1,2,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,7))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(3),m3h6x6(:,249),heltab2x36(:,:,1464))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1609),h0tab(:,1609),[20,1,2,8],[nMW,nMW,nMW,0],4,1,wf6(:,7))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(447),m3h6x6(:,250),heltab2x36(:,:,1465))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1610),h0tab(:,1610),[20,1,2,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,7))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(452),m3h6x6(:,251),heltab2x36(:,:,1466))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1611),h0tab(:,1611),[20,1,2,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,7))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,7),G0H6(176),m3h6x6(:,252),heltab2x36(:,:,1467))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1612),h0tab(:,1612),[20,1,2,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,7))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(39),m3h6x6(:,253),heltab2x36(:,:,1468))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1613),h0tab(:,1613),[20,1,2,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,7))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(243),m3h6x6(:,254),heltab2x36(:,:,1469))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1614),h0tab(:,1614),[20,1,2,8],[nMW,nMW,nMW,0],4,1,wf6(:,7))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,7),G0H6(177),m3h6x6(:,255),heltab2x36(:,:,1470))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1615),h0tab(:,1615),[20,1,2,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,7))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,7),G0H6(178),m3h6x6(:,256),heltab2x36(:,:,1471))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1616),h0tab(:,1616),[20,1,2,8],[nMW,nMW,nMW,0],4,1,wf6(:,7))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(48),m3h6x6(:,257),heltab2x36(:,:,1472))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1617),h0tab(:,1617),[20,1,2,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,7))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(53),m3h6x6(:,258),heltab2x36(:,:,1473))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1618),h0tab(:,1618),[20,1,2,8],[nMW,nMW,nMW,0],4,1,wf6(:,7))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,7),G0H6(179),m3h6x6(:,259),heltab2x36(:,:,1474))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1619),h0tab(:,1619),[20,1,2,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,7))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,7),G0H6(180),m3h6x6(:,260),heltab2x36(:,:,1475))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1620),h0tab(:,1620),[20,1,2,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,7))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(54),m3h6x6(:,261),heltab2x36(:,:,1476))
  Gcoeff(:)%j = (c(133)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1621),h0tab(:,1621),[20,1,2,8],[nML,nML,nML,0],4,1,wf6(:,15))
  call Hloop_AW_Q(ntryL,G0H36(1),wf6(:,15),G0H6(181),m3h6x6(:,262),heltab2x36(:,:,1477))
  call Hloop_A_Q(ntryL,G0H6(181),20,nML,G1H6(55),n2h6(288))
  Gcoeff(:)%j = (-(c(144)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1622),h0tab(:,1622),[20,1,2,8],[nMT,nMT,nMT,nMB],4,1,wf6(:,15))
  call Hloop_QW_A(ntryL,G0H36(1),wf6(:,15),G0H6(181),m3h6x6(:,263),heltab2x36(:,:,1478))
  call Hloop_Q_A(ntryL,G0H6(181),20,nMT,G1H6(63),n2h6(289))
  Gcoeff(:)%j = (c(121)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1623),h0tab(:,1623),[20,1,2,8],[nMB,nMB,nMB,nMT],4,1,wf6(:,15))
  call Hloop_AW_Q(ntryL,G0H36(1),wf6(:,15),G0H6(181),m3h6x6(:,264),heltab2x36(:,:,1479))
  call Hloop_A_Q(ntryL,G0H6(181),20,nMB,G1H6(73),n2h6(290))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1624),h0tab(:,1624),[20,1,2,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,15))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(74),m3h6x6(:,265),heltab2x36(:,:,1480))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1625),h0tab(:,1625),[20,1,2,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,15))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(79),m3h6x6(:,266),heltab2x36(:,:,1481))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1626),h0tab(:,1626),[20,1,2,8],[nMW,nMW,nMW,0],4,1,wf6(:,15))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf6(:,15),G1H6(86),m3h6x6(:,267),heltab2x36(:,:,1482))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1627),h0tab(:,1627),[20,1,2,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,15))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf6(:,15),G1H6(87),m3h6x6(:,268),heltab2x36(:,:,1483))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1628),h0tab(:,1628),[20,1,2,8],[nMW,nMW,nMW,0],4,1,wf6(:,15))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(89),m3h6x6(:,269),heltab2x36(:,:,1484))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1629),h0tab(:,1629),[20,1,2,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,15))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(90),m3h6x6(:,270),heltab2x36(:,:,1485))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1630),h0tab(:,1630),[20,1,2,8],[nMW,nMW,nMW,0],4,1,wf6(:,15))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(100),m3h6x6(:,271),heltab2x36(:,:,1486))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1631),h0tab(:,1631),[20,1,2,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,15))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(5),m3h6x6(:,272),heltab2x36(:,:,1487))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1632),h0tab(:,1632),[20,1,2,8],[nMW,nMW,nMW,0],4,1,wf6(:,15))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,15),G0H6(181),m3h6x6(:,273),heltab2x36(:,:,1488))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1633),h0tab(:,1633),[20,1,2,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,15))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,15),G0H6(182),m3h6x6(:,274),heltab2x36(:,:,1489))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1634),h0tab(:,1634),[20,1,2,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,15))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(6),m3h6x6(:,275),heltab2x36(:,:,1490))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1635),h0tab(:,1635),[20,1,2,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,15))
  call Hloop_SV_V(ntryL,G0H36(1),wf6(:,15),G0H6(183),m3h6x6(:,276),heltab2x36(:,:,1491))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1636),h0tab(:,1636),[20,1,2,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,15))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(252),m3h6x6(:,277),heltab2x36(:,:,1492))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1637),h0tab(:,1637),[20,1,2,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,15))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(256),m3h6x6(:,278),heltab2x36(:,:,1493))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1638),h0tab(:,1638),[20,1,2,8],[nMW,nMW,nMW,0],4,1,wf6(:,15))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,15),G0H6(184),m3h6x6(:,279),heltab2x36(:,:,1494))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1639),h0tab(:,1639),[20,1,2,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,15))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,15),G0H6(185),m3h6x6(:,280),heltab2x36(:,:,1495))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1640),h0tab(:,1640),[20,1,2,8],[nMW,nMW,nMW,0],4,1,wf6(:,15))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(257),m3h6x6(:,281),heltab2x36(:,:,1496))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1641),h0tab(:,1641),[20,1,2,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,15))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(258),m3h6x6(:,282),heltab2x36(:,:,1497))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1642),h0tab(:,1642),[20,1,2,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,15))
  call Hloop_SV_V(ntryL,G0H36(1),wf6(:,15),G0H6(186),m3h6x6(:,283),heltab2x36(:,:,1498))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1643),h0tab(:,1643),[20,1,2,8],[nMW,nMW,nMW,0],4,1,wf6(:,15))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,15),G0H6(187),m3h6x6(:,284),heltab2x36(:,:,1499))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1644),h0tab(:,1644),[20,1,2,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,15))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,15),G0H6(188),m3h6x6(:,285),heltab2x36(:,:,1500))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1645),h0tab(:,1645),[20,1,2,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,15))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(259),m3h6x6(:,286),heltab2x36(:,:,1501))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1646),h0tab(:,1646),[20,1,2,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,15))
  call Hloop_SV_V(ntryL,G0H36(1),wf6(:,15),G0H6(189),m3h6x6(:,287),heltab2x36(:,:,1502))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1647),h0tab(:,1647),[20,1,2,8],[nMW,nMW,nMW,0],4,1,wf6(:,15))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(263),m3h6x6(:,288),heltab2x36(:,:,1503))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1648),h0tab(:,1648),[20,1,2,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,15))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(264),m3h6x6(:,289),heltab2x36(:,:,1504))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1649),h0tab(:,1649),[20,1,2,8],[nMW,nMW,nMW,0],4,1,wf6(:,15))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,15),G0H6(190),m3h6x6(:,290),heltab2x36(:,:,1505))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1650),h0tab(:,1650),[20,1,2,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,15))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,15),G0H6(191),m3h6x6(:,291),heltab2x36(:,:,1506))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1651),h0tab(:,1651),[20,1,2,8],[nMW,nMW,nMW,0],4,1,wf6(:,15))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(265),m3h6x6(:,292),heltab2x36(:,:,1507))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1652),h0tab(:,1652),[20,1,2,8],[nMW,nMW,nMW,nMZ],4,1,wf6(:,15))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(267),m3h6x6(:,293),heltab2x36(:,:,1508))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1653),h0tab(:,1653),[20,1,2,8],[nMW,nMW,nMW,nMH],4,1,wf6(:,15))
  call Hloop_SV_V(ntryL,G0H36(1),wf6(:,15),G0H6(192),m3h6x6(:,294),heltab2x36(:,:,1509))
  Gcoeff(:)%j = (c(142)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1654),h0tab(:,1654),[20,1,8,2],[nMT,nMT,nMB,nMB],4,1,wf6(:,7))
  call Hloop_QS_A(ntryL,G0H36(1),wf6(:,7),G0H6(193),ngPtb,m3h6x6(:,295),heltab2x36(:,:,1510))
  call Hloop_Q_A(ntryL,G0H6(193),20,nMT,G1H6(270),n2h6(291))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1655),h0tab(:,1655),[20,1,8,2],[nMB,nMB,nMT,nMT],4,1,wf6(:,7))
  call Hloop_AS_Q(ntryL,G0H36(1),wf6(:,7),G0H6(193),ngPtb,m3h6x6(:,296),heltab2x36(:,:,1511))
  call Hloop_A_Q(ntryL,G0H6(193),20,nMB,G1H6(271),n2h6(292))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1656),h0tab(:,1656),[20,1,8,2],[nMH,nMH,nMW,nMW],4,1,wf6(:,7))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,7),G0H6(193),m3h6x6(:,297),heltab2x36(:,:,1512))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1657),h0tab(:,1657),[20,1,8,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,7))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,7),G0H6(194),m3h6x6(:,298),heltab2x36(:,:,1513))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1658),h0tab(:,1658),[20,1,8,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,7))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,7),G0H6(195),m3h6x6(:,299),heltab2x36(:,:,1514))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1659),h0tab(:,1659),[20,1,8,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,7))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,7),G0H6(196),m3h6x6(:,300),heltab2x36(:,:,1515))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1660),h0tab(:,1660),[20,1,8,2],[nMH,nMH,nMW,nMW],4,1,wf6(:,7))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(273),m3h6x6(:,301),heltab2x36(:,:,1516))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1661),h0tab(:,1661),[20,1,8,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,7))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(274),m3h6x6(:,302),heltab2x36(:,:,1517))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1662),h0tab(:,1662),[20,1,8,2],[nMH,nMH,nMW,nMW],4,1,wf6(:,7))
  call Hloop_SS_S(ntryL,G0H36(1),wf6(:,7),G0H6(197),m3h6x6(:,303),heltab2x36(:,:,1518))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1663),h0tab(:,1663),[20,1,8,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,7))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(277),m3h6x6(:,304),heltab2x36(:,:,1519))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1664),h0tab(:,1664),[20,1,8,2],[nMH,nMH,nMW,nMW],4,1,wf6(:,7))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(279),m3h6x6(:,305),heltab2x36(:,:,1520))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1665),h0tab(:,1665),[20,1,8,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,7))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,7),G0H6(198),m3h6x6(:,306),heltab2x36(:,:,1521))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1666),h0tab(:,1666),[20,1,8,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,7))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(280),m3h6x6(:,307),heltab2x36(:,:,1522))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1667),h0tab(:,1667),[20,1,8,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,7))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(281),m3h6x6(:,308),heltab2x36(:,:,1523))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1668),h0tab(:,1668),[20,1,8,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,7))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(577),m3h6x6(:,309),heltab2x36(:,:,1524))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1669),h0tab(:,1669),[20,1,8,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,7))
  call Hloop_VS_V(ntryL,G0H36(1),wf6(:,7),G0H6(199),m3h6x6(:,310),heltab2x36(:,:,1525))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1670),h0tab(:,1670),[20,1,8,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,7))
  call Hloop_TS_V(ntryL,G0H36(1),0,wf6(:,7),20,G1H6(582),m3h6x6(:,311),heltab2x36(:,:,1526))
  Gcoeff(:)%j = (c(142)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1671),h0tab(:,1671),[20,1,8,2],[nMT,nMT,nMB,nMB],4,1,wf6(:,15))
  call Hloop_QW_A(ntryL,G0H36(1),wf6(:,15),G0H6(200),m3h6x6(:,312),heltab2x36(:,:,1527))
  call Hloop_Q_A(ntryL,G0H6(200),20,nMT,G1H6(287),n2h6(293))
  Gcoeff(:)%j = (-(c(123)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1672),h0tab(:,1672),[20,1,8,2],[nMB,nMB,nMT,nMT],4,1,wf6(:,15))
  call Hloop_AW_Q(ntryL,G0H36(1),wf6(:,15),G0H6(200),m3h6x6(:,313),heltab2x36(:,:,1528))
  call Hloop_A_Q(ntryL,G0H6(200),20,nMB,G1H6(288),n2h6(294))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1673),h0tab(:,1673),[20,1,8,2],[nMH,nMH,nMW,nMW],4,1,wf6(:,15))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(557),m3h6x6(:,314),heltab2x36(:,:,1529))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1674),h0tab(:,1674),[20,1,8,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,15))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(562),m3h6x6(:,315),heltab2x36(:,:,1530))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1675),h0tab(:,1675),[20,1,8,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,15))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(294),m3h6x6(:,316),heltab2x36(:,:,1531))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1676),h0tab(:,1676),[20,1,8,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,15))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf6(:,15),G1H6(295),m3h6x6(:,317),heltab2x36(:,:,1532))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1677),h0tab(:,1677),[20,1,8,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,15))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(567),m3h6x6(:,318),heltab2x36(:,:,1533))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1678),h0tab(:,1678),[20,1,8,2],[nMH,nMH,nMW,nMW],4,1,wf6(:,15))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,15),G0H6(200),m3h6x6(:,319),heltab2x36(:,:,1534))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1679),h0tab(:,1679),[20,1,8,2],[nMH,nMH,nMW,nMW],4,1,wf6(:,15))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(572),m3h6x6(:,320),heltab2x36(:,:,1535))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1680),h0tab(:,1680),[20,1,8,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,15))
  call Hloop_SV_V(ntryL,G0H36(1),wf6(:,15),G0H6(201),m3h6x6(:,321),heltab2x36(:,:,1536))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1681),h0tab(:,1681),[20,1,8,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,15))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(301),m3h6x6(:,322),heltab2x36(:,:,1537))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1682),h0tab(:,1682),[20,1,8,2],[nMH,nMH,nMW,nMW],4,1,wf6(:,15))
  call Hloop_VV_S(ntryL,G0H36(1),wf6(:,15),G0H6(202),m3h6x6(:,323),heltab2x36(:,:,1538))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1683),h0tab(:,1683),[20,1,8,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,15))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(303),m3h6x6(:,324),heltab2x36(:,:,1539))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1684),h0tab(:,1684),[20,1,8,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,15))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(306),m3h6x6(:,325),heltab2x36(:,:,1540))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1685),h0tab(:,1685),[20,1,8,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,15))
  call Hloop_SV_V(ntryL,G0H36(1),wf6(:,15),G0H6(203),m3h6x6(:,326),heltab2x36(:,:,1541))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1686),h0tab(:,1686),[20,1,8,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,15))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf6(:,15),20,G1H6(307),m3h6x6(:,327),heltab2x36(:,:,1542))
  Gcoeff(:)%j = (c(55)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1687),h0tab(:,1687),[20,1,8,2],[nMZ,nMZ,nMW,nMW],4,1,wf6(:,15))
  call Hloop_SV_V(ntryL,G0H36(1),wf6(:,15),G0H6(204),m3h6x6(:,328),heltab2x36(:,:,1543))
  Gcoeff(:)%j = (c(137)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1688),h0tab(:,1688),[24,2,1,4],[nML,nML,nML,nML],4,1,wf9(:,6))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,6),G0H4(49),ngH,m3h9x4(:,1),heltab2x36(:,:,1544))
  call Hloop_Q_A(ntryL,G0H4(49),24,nML,G1H4(45),n2h4(51))
  Gcoeff(:)%j = (c(137)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1689),h0tab(:,1689),[24,2,1,4],[nML,nML,nML,nML],4,1,wf9(:,6))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,6),G0H4(49),ngH,m3h9x4(:,2),heltab2x36(:,:,1545))
  call Hloop_A_Q(ntryL,G0H4(49),24,nML,G1H4(46),n2h4(52))
  Gcoeff(:)%j = (c(148)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1690),h0tab(:,1690),[24,2,1,4],[nMT,nMT,nMT,nMT],4,1,wf9(:,6))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,6),G0H4(49),ngH,m3h9x4(:,3),heltab2x36(:,:,1546))
  call Hloop_Q_A(ntryL,G0H4(49),24,nMT,G1H4(77),n2h4(53))
  Gcoeff(:)%j = (c(148)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1691),h0tab(:,1691),[24,2,1,4],[nMT,nMT,nMT,nMT],4,1,wf9(:,6))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,6),G0H4(49),ngH,m3h9x4(:,4),heltab2x36(:,:,1547))
  call Hloop_A_Q(ntryL,G0H4(49),24,nMT,G1H4(78),n2h4(54))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1692),h0tab(:,1692),[24,2,1,4],[nMB,nMB,nMB,nMB],4,1,wf9(:,6))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,6),G0H4(49),ngH,m3h9x4(:,5),heltab2x36(:,:,1548))
  call Hloop_Q_A(ntryL,G0H4(49),24,nMB,G1H4(83),n2h4(55))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1693),h0tab(:,1693),[24,2,1,4],[nMB,nMB,nMB,nMB],4,1,wf9(:,6))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,6),G0H4(49),ngH,m3h9x4(:,6),heltab2x36(:,:,1549))
  call Hloop_A_Q(ntryL,G0H4(49),24,nMB,G1H4(84),n2h4(56))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1694),h0tab(:,1694),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(49),m3h9x4(:,7),heltab2x36(:,:,1550))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1695),h0tab(:,1695),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(50),m3h9x4(:,8),heltab2x36(:,:,1551))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1696),h0tab(:,1696),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(51),m3h9x4(:,9),heltab2x36(:,:,1552))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1697),h0tab(:,1697),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(52),m3h9x4(:,10),heltab2x36(:,:,1553))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1698),h0tab(:,1698),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(53),m3h9x4(:,11),heltab2x36(:,:,1554))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1699),h0tab(:,1699),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(54),m3h9x4(:,12),heltab2x36(:,:,1555))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1700),h0tab(:,1700),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(55),m3h9x4(:,13),heltab2x36(:,:,1556))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1701),h0tab(:,1701),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(56),m3h9x4(:,14),heltab2x36(:,:,1557))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1702),h0tab(:,1702),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(99),m3h9x4(:,15),heltab2x36(:,:,1558))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1703),h0tab(:,1703),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(100),m3h9x4(:,16),heltab2x36(:,:,1559))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1704),h0tab(:,1704),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(125),m3h9x4(:,17),heltab2x36(:,:,1560))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1705),h0tab(:,1705),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(126),m3h9x4(:,18),heltab2x36(:,:,1561))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1706),h0tab(:,1706),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(57),m3h9x4(:,19),heltab2x36(:,:,1562))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1707),h0tab(:,1707),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(58),m3h9x4(:,20),heltab2x36(:,:,1563))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1708),h0tab(:,1708),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(59),m3h9x4(:,21),heltab2x36(:,:,1564))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1709),h0tab(:,1709),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(60),m3h9x4(:,22),heltab2x36(:,:,1565))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1710),h0tab(:,1710),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(61),m3h9x4(:,23),heltab2x36(:,:,1566))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1711),h0tab(:,1711),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(62),m3h9x4(:,24),heltab2x36(:,:,1567))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1712),h0tab(:,1712),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(141),m3h9x4(:,25),heltab2x36(:,:,1568))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1713),h0tab(:,1713),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(142),m3h9x4(:,26),heltab2x36(:,:,1569))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1714),h0tab(:,1714),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(157),m3h9x4(:,27),heltab2x36(:,:,1570))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1715),h0tab(:,1715),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(158),m3h9x4(:,28),heltab2x36(:,:,1571))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1716),h0tab(:,1716),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(183),m3h9x4(:,29),heltab2x36(:,:,1572))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1717),h0tab(:,1717),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(184),m3h9x4(:,30),heltab2x36(:,:,1573))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1718),h0tab(:,1718),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(19),m3h9x4(:,31),heltab2x36(:,:,1574))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1719),h0tab(:,1719),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(5),m3h9x4(:,32),heltab2x36(:,:,1575))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1720),h0tab(:,1720),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(63),m3h9x4(:,33),heltab2x36(:,:,1576))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1721),h0tab(:,1721),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(64),m3h9x4(:,34),heltab2x36(:,:,1577))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1722),h0tab(:,1722),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(65),m3h9x4(:,35),heltab2x36(:,:,1578))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1723),h0tab(:,1723),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(66),m3h9x4(:,36),heltab2x36(:,:,1579))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1724),h0tab(:,1724),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(67),m3h9x4(:,37),heltab2x36(:,:,1580))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1725),h0tab(:,1725),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(68),m3h9x4(:,38),heltab2x36(:,:,1581))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1726),h0tab(:,1726),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(12),m3h9x4(:,39),heltab2x36(:,:,1582))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1727),h0tab(:,1727),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(20),m3h9x4(:,40),heltab2x36(:,:,1583))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1728),h0tab(:,1728),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(21),m3h9x4(:,41),heltab2x36(:,:,1584))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1729),h0tab(:,1729),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(22),m3h9x4(:,42),heltab2x36(:,:,1585))
  Gcoeff(:)%j = (c(194)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1730),h0tab(:,1730),[24,2,1,4],[nML,nML,nML,nML],4,1,wf9(:,7))
  call Hloop_QV_A(ntryL,G0H36(1),wf9(:,7),G0H4(69),m3h9x4(:,43),heltab2x36(:,:,1586))
  call Hloop_Q_A(ntryL,G0H4(69),24,nML,G1H4(25),n2h4(57))
  Gcoeff(:)%j = (c(194)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1731),h0tab(:,1731),[24,2,1,4],[nML,nML,nML,nML],4,1,wf9(:,7))
  call Hloop_AV_Q(ntryL,G0H36(1),wf9(:,7),G0H4(69),m3h9x4(:,44),heltab2x36(:,:,1587))
  call Hloop_A_Q(ntryL,G0H4(69),24,nML,G1H4(26),n2h4(58))
  Gcoeff(:)%j = (-(c(195)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1732),h0tab(:,1732),[24,2,1,4],[nMT,nMT,nMT,nMT],4,1,wf9(:,7))
  call Hloop_QV_A(ntryL,G0H36(1),wf9(:,7),G0H4(69),m3h9x4(:,45),heltab2x36(:,:,1588))
  call Hloop_Q_A(ntryL,G0H4(69),24,nMT,G1H4(27),n2h4(59))
  Gcoeff(:)%j = (-(c(195)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1733),h0tab(:,1733),[24,2,1,4],[nMT,nMT,nMT,nMT],4,1,wf9(:,7))
  call Hloop_AV_Q(ntryL,G0H36(1),wf9(:,7),G0H4(69),m3h9x4(:,46),heltab2x36(:,:,1589))
  call Hloop_A_Q(ntryL,G0H4(69),24,nMT,G1H4(28),n2h4(60))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1734),h0tab(:,1734),[24,2,1,4],[nMB,nMB,nMB,nMB],4,1,wf9(:,7))
  call Hloop_QV_A(ntryL,G0H36(1),wf9(:,7),G0H4(69),m3h9x4(:,47),heltab2x36(:,:,1590))
  call Hloop_Q_A(ntryL,G0H4(69),24,nMB,G1H4(31),n2h4(61))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1735),h0tab(:,1735),[24,2,1,4],[nMB,nMB,nMB,nMB],4,1,wf9(:,7))
  call Hloop_AV_Q(ntryL,G0H36(1),wf9(:,7),G0H4(69),m3h9x4(:,48),heltab2x36(:,:,1591))
  call Hloop_A_Q(ntryL,G0H4(69),24,nMB,G1H4(32),n2h4(62))
  Gcoeff(:)%j = (-(c(177)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1736),h0tab(:,1736),[24,2,1,4],[nML,nML,nML,nML],4,1,wf9(:,7))
  call Hloop_QZ_A(ntryL,G0H36(1),wf9(:,7),G0H4(69),ngZl,m3h9x4(:,49),heltab2x36(:,:,1592))
  call Hloop_Q_A(ntryL,G0H4(69),24,nML,G1H4(33),n2h4(63))
  Gcoeff(:)%j = (-(c(177)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1737),h0tab(:,1737),[24,2,1,4],[nML,nML,nML,nML],4,1,wf9(:,7))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf9(:,7),G0H4(69),ngZl,m3h9x4(:,50),heltab2x36(:,:,1593))
  call Hloop_A_Q(ntryL,G0H4(69),24,nML,G1H4(34),n2h4(64))
  Gcoeff(:)%j = (-(c(178)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1738),h0tab(:,1738),[24,2,1,4],[nMT,nMT,nMT,nMT],4,1,wf9(:,7))
  call Hloop_QZ_A(ntryL,G0H36(1),wf9(:,7),G0H4(69),ngZu,m3h9x4(:,51),heltab2x36(:,:,1594))
  call Hloop_Q_A(ntryL,G0H4(69),24,nMT,G1H4(37),n2h4(65))
  Gcoeff(:)%j = (-(c(178)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1739),h0tab(:,1739),[24,2,1,4],[nMT,nMT,nMT,nMT],4,1,wf9(:,7))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf9(:,7),G0H4(69),ngZu,m3h9x4(:,52),heltab2x36(:,:,1595))
  call Hloop_A_Q(ntryL,G0H4(69),24,nMT,G1H4(38),n2h4(66))
  Gcoeff(:)%j = (-(c(175)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1740),h0tab(:,1740),[24,2,1,4],[nMB,nMB,nMB,nMB],4,1,wf9(:,7))
  call Hloop_QZ_A(ntryL,G0H36(1),wf9(:,7),G0H4(69),ngZd,m3h9x4(:,53),heltab2x36(:,:,1596))
  call Hloop_Q_A(ntryL,G0H4(69),24,nMB,G1H4(39),n2h4(67))
  Gcoeff(:)%j = (-(c(175)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1741),h0tab(:,1741),[24,2,1,4],[nMB,nMB,nMB,nMB],4,1,wf9(:,7))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf9(:,7),G0H4(69),ngZd,m3h9x4(:,54),heltab2x36(:,:,1597))
  call Hloop_A_Q(ntryL,G0H4(69),24,nMB,G1H4(40),n2h4(68))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1742),h0tab(:,1742),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(43),m3h9x4(:,55),heltab2x36(:,:,1598))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1743),h0tab(:,1743),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(44),m3h9x4(:,56),heltab2x36(:,:,1599))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1744),h0tab(:,1744),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(1),m3h9x4(:,57),heltab2x36(:,:,1600))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1745),h0tab(:,1745),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(2),m3h9x4(:,58),heltab2x36(:,:,1601))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1746),h0tab(:,1746),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(111),m3h9x4(:,59),heltab2x36(:,:,1602))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1747),h0tab(:,1747),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,7),G1H4(116),m3h9x4(:,60),heltab2x36(:,:,1603))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1748),h0tab(:,1748),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(47),m3h9x4(:,61),heltab2x36(:,:,1604))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1749),h0tab(:,1749),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,7),G1H4(48),m3h9x4(:,62),heltab2x36(:,:,1605))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1750),h0tab(:,1750),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(51),m3h9x4(:,63),heltab2x36(:,:,1606))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1751),h0tab(:,1751),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,7),G1H4(52),m3h9x4(:,64),heltab2x36(:,:,1607))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1752),h0tab(:,1752),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(53),m3h9x4(:,65),heltab2x36(:,:,1608))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1753),h0tab(:,1753),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,7),G1H4(54),m3h9x4(:,66),heltab2x36(:,:,1609))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1754),h0tab(:,1754),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(57),m3h9x4(:,67),heltab2x36(:,:,1610))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1755),h0tab(:,1755),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(58),m3h9x4(:,68),heltab2x36(:,:,1611))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1756),h0tab(:,1756),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(59),m3h9x4(:,69),heltab2x36(:,:,1612))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1757),h0tab(:,1757),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(60),m3h9x4(:,70),heltab2x36(:,:,1613))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1758),h0tab(:,1758),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(69),m3h9x4(:,71),heltab2x36(:,:,1614))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1759),h0tab(:,1759),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(70),m3h9x4(:,72),heltab2x36(:,:,1615))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1760),h0tab(:,1760),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(71),m3h9x4(:,73),heltab2x36(:,:,1616))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1761),h0tab(:,1761),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(72),m3h9x4(:,74),heltab2x36(:,:,1617))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1762),h0tab(:,1762),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(73),m3h9x4(:,75),heltab2x36(:,:,1618))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1763),h0tab(:,1763),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(74),m3h9x4(:,76),heltab2x36(:,:,1619))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1764),h0tab(:,1764),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(75),m3h9x4(:,77),heltab2x36(:,:,1620))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1765),h0tab(:,1765),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(76),m3h9x4(:,78),heltab2x36(:,:,1621))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1766),h0tab(:,1766),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(63),m3h9x4(:,79),heltab2x36(:,:,1622))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1767),h0tab(:,1767),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(64),m3h9x4(:,80),heltab2x36(:,:,1623))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1768),h0tab(:,1768),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(65),m3h9x4(:,81),heltab2x36(:,:,1624))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1769),h0tab(:,1769),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(66),m3h9x4(:,82),heltab2x36(:,:,1625))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1770),h0tab(:,1770),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(69),m3h9x4(:,83),heltab2x36(:,:,1626))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1771),h0tab(:,1771),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(70),m3h9x4(:,84),heltab2x36(:,:,1627))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1772),h0tab(:,1772),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(71),m3h9x4(:,85),heltab2x36(:,:,1628))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1773),h0tab(:,1773),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(72),m3h9x4(:,86),heltab2x36(:,:,1629))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1774),h0tab(:,1774),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(75),m3h9x4(:,87),heltab2x36(:,:,1630))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1775),h0tab(:,1775),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(76),m3h9x4(:,88),heltab2x36(:,:,1631))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1776),h0tab(:,1776),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(7),m3h9x4(:,89),heltab2x36(:,:,1632))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1777),h0tab(:,1777),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(8),m3h9x4(:,90),heltab2x36(:,:,1633))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1778),h0tab(:,1778),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(77),m3h9x4(:,91),heltab2x36(:,:,1634))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1779),h0tab(:,1779),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(78),m3h9x4(:,92),heltab2x36(:,:,1635))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1780),h0tab(:,1780),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(79),m3h9x4(:,93),heltab2x36(:,:,1636))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1781),h0tab(:,1781),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(80),m3h9x4(:,94),heltab2x36(:,:,1637))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1782),h0tab(:,1782),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(81),m3h9x4(:,95),heltab2x36(:,:,1638))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1783),h0tab(:,1783),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(82),m3h9x4(:,96),heltab2x36(:,:,1639))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1784),h0tab(:,1784),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(83),m3h9x4(:,97),heltab2x36(:,:,1640))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1785),h0tab(:,1785),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(84),m3h9x4(:,98),heltab2x36(:,:,1641))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1786),h0tab(:,1786),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(85),m3h9x4(:,99),heltab2x36(:,:,1642))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1787),h0tab(:,1787),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(86),m3h9x4(:,100),heltab2x36(:,:,1643))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1788),h0tab(:,1788),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(87),m3h9x4(:,101),heltab2x36(:,:,1644))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1789),h0tab(:,1789),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(88),m3h9x4(:,102),heltab2x36(:,:,1645))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1790),h0tab(:,1790),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(89),m3h9x4(:,103),heltab2x36(:,:,1646))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1791),h0tab(:,1791),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(90),m3h9x4(:,104),heltab2x36(:,:,1647))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1792),h0tab(:,1792),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(91),m3h9x4(:,105),heltab2x36(:,:,1648))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1793),h0tab(:,1793),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(92),m3h9x4(:,106),heltab2x36(:,:,1649))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1794),h0tab(:,1794),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(169),m3h9x4(:,107),heltab2x36(:,:,1650))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1795),h0tab(:,1795),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(174),m3h9x4(:,108),heltab2x36(:,:,1651))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1796),h0tab(:,1796),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(79),m3h9x4(:,109),heltab2x36(:,:,1652))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1797),h0tab(:,1797),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(80),m3h9x4(:,110),heltab2x36(:,:,1653))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1798),h0tab(:,1798),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(85),m3h9x4(:,111),heltab2x36(:,:,1654))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1799),h0tab(:,1799),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(90),m3h9x4(:,112),heltab2x36(:,:,1655))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1800),h0tab(:,1800),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(86),m3h9x4(:,113),heltab2x36(:,:,1656))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1801),h0tab(:,1801),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(89),m3h9x4(:,114),heltab2x36(:,:,1657))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1802),h0tab(:,1802),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(91),m3h9x4(:,115),heltab2x36(:,:,1658))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1803),h0tab(:,1803),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(94),m3h9x4(:,116),heltab2x36(:,:,1659))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1804),h0tab(:,1804),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(95),m3h9x4(:,117),heltab2x36(:,:,1660))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1805),h0tab(:,1805),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(96),m3h9x4(:,118),heltab2x36(:,:,1661))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1806),h0tab(:,1806),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(93),m3h9x4(:,119),heltab2x36(:,:,1662))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1807),h0tab(:,1807),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(94),m3h9x4(:,120),heltab2x36(:,:,1663))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1808),h0tab(:,1808),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(95),m3h9x4(:,121),heltab2x36(:,:,1664))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1809),h0tab(:,1809),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(96),m3h9x4(:,122),heltab2x36(:,:,1665))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1810),h0tab(:,1810),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(97),m3h9x4(:,123),heltab2x36(:,:,1666))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1811),h0tab(:,1811),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(98),m3h9x4(:,124),heltab2x36(:,:,1667))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1812),h0tab(:,1812),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(99),m3h9x4(:,125),heltab2x36(:,:,1668))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1813),h0tab(:,1813),[24,2,1,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(100),m3h9x4(:,126),heltab2x36(:,:,1669))
  Gcoeff(:)%j = (c(137)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1814),h0tab(:,1814),[24,1,2,4],[nML,nML,nML,nML],4,1,wf9(:,6))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,6),G0H4(101),ngH,m3h9x4(:,127),heltab2x36(:,:,1670))
  call Hloop_A_Q(ntryL,G0H4(101),24,nML,G1H4(101),n2h4(69))
  Gcoeff(:)%j = (c(137)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1815),h0tab(:,1815),[24,1,2,4],[nML,nML,nML,nML],4,1,wf9(:,6))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,6),G0H4(101),ngH,m3h9x4(:,128),heltab2x36(:,:,1671))
  call Hloop_Q_A(ntryL,G0H4(101),24,nML,G1H4(106),n2h4(70))
  Gcoeff(:)%j = (c(148)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1816),h0tab(:,1816),[24,1,2,4],[nMT,nMT,nMT,nMT],4,1,wf9(:,6))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,6),G0H4(101),ngH,m3h9x4(:,129),heltab2x36(:,:,1672))
  call Hloop_A_Q(ntryL,G0H4(101),24,nMT,G1H4(102),n2h4(71))
  Gcoeff(:)%j = (c(148)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1817),h0tab(:,1817),[24,1,2,4],[nMT,nMT,nMT,nMT],4,1,wf9(:,6))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,6),G0H4(101),ngH,m3h9x4(:,130),heltab2x36(:,:,1673))
  call Hloop_Q_A(ntryL,G0H4(101),24,nMT,G1H4(105),n2h4(72))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1818),h0tab(:,1818),[24,1,2,4],[nMB,nMB,nMB,nMB],4,1,wf9(:,6))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,6),G0H4(101),ngH,m3h9x4(:,131),heltab2x36(:,:,1674))
  call Hloop_A_Q(ntryL,G0H4(101),24,nMB,G1H4(107),n2h4(73))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1819),h0tab(:,1819),[24,1,2,4],[nMB,nMB,nMB,nMB],4,1,wf9(:,6))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,6),G0H4(101),ngH,m3h9x4(:,132),heltab2x36(:,:,1675))
  call Hloop_Q_A(ntryL,G0H4(101),24,nMB,G1H4(110),n2h4(74))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1820),h0tab(:,1820),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(101),m3h9x4(:,133),heltab2x36(:,:,1676))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1821),h0tab(:,1821),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(102),m3h9x4(:,134),heltab2x36(:,:,1677))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1822),h0tab(:,1822),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(103),m3h9x4(:,135),heltab2x36(:,:,1678))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1823),h0tab(:,1823),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(104),m3h9x4(:,136),heltab2x36(:,:,1679))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1824),h0tab(:,1824),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(105),m3h9x4(:,137),heltab2x36(:,:,1680))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1825),h0tab(:,1825),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(106),m3h9x4(:,138),heltab2x36(:,:,1681))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1826),h0tab(:,1826),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(107),m3h9x4(:,139),heltab2x36(:,:,1682))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1827),h0tab(:,1827),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(108),m3h9x4(:,140),heltab2x36(:,:,1683))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1828),h0tab(:,1828),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(112),m3h9x4(:,141),heltab2x36(:,:,1684))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1829),h0tab(:,1829),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(115),m3h9x4(:,142),heltab2x36(:,:,1685))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1830),h0tab(:,1830),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(109),m3h9x4(:,143),heltab2x36(:,:,1686))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1831),h0tab(:,1831),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(110),m3h9x4(:,144),heltab2x36(:,:,1687))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1832),h0tab(:,1832),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(117),m3h9x4(:,145),heltab2x36(:,:,1688))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1833),h0tab(:,1833),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(120),m3h9x4(:,146),heltab2x36(:,:,1689))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1834),h0tab(:,1834),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(111),m3h9x4(:,147),heltab2x36(:,:,1690))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1835),h0tab(:,1835),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(112),m3h9x4(:,148),heltab2x36(:,:,1691))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1836),h0tab(:,1836),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(121),m3h9x4(:,149),heltab2x36(:,:,1692))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1837),h0tab(:,1837),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(122),m3h9x4(:,150),heltab2x36(:,:,1693))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1838),h0tab(:,1838),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(113),m3h9x4(:,151),heltab2x36(:,:,1694))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1839),h0tab(:,1839),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(114),m3h9x4(:,152),heltab2x36(:,:,1695))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1840),h0tab(:,1840),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(127),m3h9x4(:,153),heltab2x36(:,:,1696))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1841),h0tab(:,1841),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(132),m3h9x4(:,154),heltab2x36(:,:,1697))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1842),h0tab(:,1842),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(128),m3h9x4(:,155),heltab2x36(:,:,1698))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1843),h0tab(:,1843),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(131),m3h9x4(:,156),heltab2x36(:,:,1699))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1844),h0tab(:,1844),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(115),m3h9x4(:,157),heltab2x36(:,:,1700))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1845),h0tab(:,1845),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(116),m3h9x4(:,158),heltab2x36(:,:,1701))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1846),h0tab(:,1846),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(133),m3h9x4(:,159),heltab2x36(:,:,1702))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1847),h0tab(:,1847),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(136),m3h9x4(:,160),heltab2x36(:,:,1703))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1848),h0tab(:,1848),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(117),m3h9x4(:,161),heltab2x36(:,:,1704))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1849),h0tab(:,1849),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(118),m3h9x4(:,162),heltab2x36(:,:,1705))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1850),h0tab(:,1850),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(137),m3h9x4(:,163),heltab2x36(:,:,1706))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1851),h0tab(:,1851),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(138),m3h9x4(:,164),heltab2x36(:,:,1707))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1852),h0tab(:,1852),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(119),m3h9x4(:,165),heltab2x36(:,:,1708))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1853),h0tab(:,1853),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(120),m3h9x4(:,166),heltab2x36(:,:,1709))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1854),h0tab(:,1854),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(143),m3h9x4(:,167),heltab2x36(:,:,1710))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1855),h0tab(:,1855),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(148),m3h9x4(:,168),heltab2x36(:,:,1711))
  Gcoeff(:)%j = (c(194)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1856),h0tab(:,1856),[24,1,2,4],[nML,nML,nML,nML],4,1,wf9(:,7))
  call Hloop_AV_Q(ntryL,G0H36(1),wf9(:,7),G0H4(121),m3h9x4(:,169),heltab2x36(:,:,1712))
  call Hloop_A_Q(ntryL,G0H4(121),24,nML,G1H4(144),n2h4(75))
  Gcoeff(:)%j = (c(194)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1857),h0tab(:,1857),[24,1,2,4],[nML,nML,nML,nML],4,1,wf9(:,7))
  call Hloop_QV_A(ntryL,G0H36(1),wf9(:,7),G0H4(121),m3h9x4(:,170),heltab2x36(:,:,1713))
  call Hloop_Q_A(ntryL,G0H4(121),24,nML,G1H4(147),n2h4(76))
  Gcoeff(:)%j = (-(c(195)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1858),h0tab(:,1858),[24,1,2,4],[nMT,nMT,nMT,nMT],4,1,wf9(:,7))
  call Hloop_AV_Q(ntryL,G0H36(1),wf9(:,7),G0H4(121),m3h9x4(:,171),heltab2x36(:,:,1714))
  call Hloop_A_Q(ntryL,G0H4(121),24,nMT,G1H4(149),n2h4(77))
  Gcoeff(:)%j = (-(c(195)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1859),h0tab(:,1859),[24,1,2,4],[nMT,nMT,nMT,nMT],4,1,wf9(:,7))
  call Hloop_QV_A(ntryL,G0H36(1),wf9(:,7),G0H4(121),m3h9x4(:,172),heltab2x36(:,:,1715))
  call Hloop_Q_A(ntryL,G0H4(121),24,nMT,G1H4(152),n2h4(78))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1860),h0tab(:,1860),[24,1,2,4],[nMB,nMB,nMB,nMB],4,1,wf9(:,7))
  call Hloop_AV_Q(ntryL,G0H36(1),wf9(:,7),G0H4(121),m3h9x4(:,173),heltab2x36(:,:,1716))
  call Hloop_A_Q(ntryL,G0H4(121),24,nMB,G1H4(153),n2h4(79))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1861),h0tab(:,1861),[24,1,2,4],[nMB,nMB,nMB,nMB],4,1,wf9(:,7))
  call Hloop_QV_A(ntryL,G0H36(1),wf9(:,7),G0H4(121),m3h9x4(:,174),heltab2x36(:,:,1717))
  call Hloop_Q_A(ntryL,G0H4(121),24,nMB,G1H4(154),n2h4(80))
  Gcoeff(:)%j = (-(c(177)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1862),h0tab(:,1862),[24,1,2,4],[nML,nML,nML,nML],4,1,wf9(:,7))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf9(:,7),G0H4(121),ngZl,m3h9x4(:,175),heltab2x36(:,:,1718))
  call Hloop_A_Q(ntryL,G0H4(121),24,nML,G1H4(159),n2h4(81))
  Gcoeff(:)%j = (-(c(177)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1863),h0tab(:,1863),[24,1,2,4],[nML,nML,nML,nML],4,1,wf9(:,7))
  call Hloop_QZ_A(ntryL,G0H36(1),wf9(:,7),G0H4(121),ngZl,m3h9x4(:,176),heltab2x36(:,:,1719))
  call Hloop_Q_A(ntryL,G0H4(121),24,nML,G1H4(164),n2h4(82))
  Gcoeff(:)%j = (-(c(178)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1864),h0tab(:,1864),[24,1,2,4],[nMT,nMT,nMT,nMT],4,1,wf9(:,7))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf9(:,7),G0H4(121),ngZu,m3h9x4(:,177),heltab2x36(:,:,1720))
  call Hloop_A_Q(ntryL,G0H4(121),24,nMT,G1H4(160),n2h4(83))
  Gcoeff(:)%j = (-(c(178)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1865),h0tab(:,1865),[24,1,2,4],[nMT,nMT,nMT,nMT],4,1,wf9(:,7))
  call Hloop_QZ_A(ntryL,G0H36(1),wf9(:,7),G0H4(121),ngZu,m3h9x4(:,178),heltab2x36(:,:,1721))
  call Hloop_Q_A(ntryL,G0H4(121),24,nMT,G1H4(163),n2h4(84))
  Gcoeff(:)%j = (-(c(175)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1866),h0tab(:,1866),[24,1,2,4],[nMB,nMB,nMB,nMB],4,1,wf9(:,7))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf9(:,7),G0H4(121),ngZd,m3h9x4(:,179),heltab2x36(:,:,1722))
  call Hloop_A_Q(ntryL,G0H4(121),24,nMB,G1H4(165),n2h4(85))
  Gcoeff(:)%j = (-(c(175)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1867),h0tab(:,1867),[24,1,2,4],[nMB,nMB,nMB,nMB],4,1,wf9(:,7))
  call Hloop_QZ_A(ntryL,G0H36(1),wf9(:,7),G0H4(121),ngZd,m3h9x4(:,180),heltab2x36(:,:,1723))
  call Hloop_Q_A(ntryL,G0H4(121),24,nMB,G1H4(168),n2h4(86))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1868),h0tab(:,1868),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(170),m3h9x4(:,181),heltab2x36(:,:,1724))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1869),h0tab(:,1869),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(173),m3h9x4(:,182),heltab2x36(:,:,1725))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1870),h0tab(:,1870),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(175),m3h9x4(:,183),heltab2x36(:,:,1726))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1871),h0tab(:,1871),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(178),m3h9x4(:,184),heltab2x36(:,:,1727))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1872),h0tab(:,1872),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,7),G1H4(179),m3h9x4(:,185),heltab2x36(:,:,1728))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1873),h0tab(:,1873),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(180),m3h9x4(:,186),heltab2x36(:,:,1729))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1874),h0tab(:,1874),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,7),G1H4(185),m3h9x4(:,187),heltab2x36(:,:,1730))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1875),h0tab(:,1875),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(190),m3h9x4(:,188),heltab2x36(:,:,1731))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1876),h0tab(:,1876),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,7),G1H4(186),m3h9x4(:,189),heltab2x36(:,:,1732))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1877),h0tab(:,1877),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(189),m3h9x4(:,190),heltab2x36(:,:,1733))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1878),h0tab(:,1878),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,7),G1H4(191),m3h9x4(:,191),heltab2x36(:,:,1734))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1879),h0tab(:,1879),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(194),m3h9x4(:,192),heltab2x36(:,:,1735))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1880),h0tab(:,1880),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(195),m3h9x4(:,193),heltab2x36(:,:,1736))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1881),h0tab(:,1881),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(196),m3h9x4(:,194),heltab2x36(:,:,1737))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1882),h0tab(:,1882),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(197),m3h9x4(:,195),heltab2x36(:,:,1738))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1883),h0tab(:,1883),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(198),m3h9x4(:,196),heltab2x36(:,:,1739))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1884),h0tab(:,1884),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(121),m3h9x4(:,197),heltab2x36(:,:,1740))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1885),h0tab(:,1885),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(122),m3h9x4(:,198),heltab2x36(:,:,1741))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1886),h0tab(:,1886),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(123),m3h9x4(:,199),heltab2x36(:,:,1742))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1887),h0tab(:,1887),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(124),m3h9x4(:,200),heltab2x36(:,:,1743))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1888),h0tab(:,1888),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(199),m3h9x4(:,201),heltab2x36(:,:,1744))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1889),h0tab(:,1889),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(200),m3h9x4(:,202),heltab2x36(:,:,1745))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1890),h0tab(:,1890),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(201),m3h9x4(:,203),heltab2x36(:,:,1746))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1891),h0tab(:,1891),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(202),m3h9x4(:,204),heltab2x36(:,:,1747))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1892),h0tab(:,1892),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(125),m3h9x4(:,205),heltab2x36(:,:,1748))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1893),h0tab(:,1893),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(126),m3h9x4(:,206),heltab2x36(:,:,1749))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1894),h0tab(:,1894),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(127),m3h9x4(:,207),heltab2x36(:,:,1750))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1895),h0tab(:,1895),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(128),m3h9x4(:,208),heltab2x36(:,:,1751))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1896),h0tab(:,1896),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(203),m3h9x4(:,209),heltab2x36(:,:,1752))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1897),h0tab(:,1897),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(204),m3h9x4(:,210),heltab2x36(:,:,1753))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1898),h0tab(:,1898),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(205),m3h9x4(:,211),heltab2x36(:,:,1754))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1899),h0tab(:,1899),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(206),m3h9x4(:,212),heltab2x36(:,:,1755))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1900),h0tab(:,1900),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(129),m3h9x4(:,213),heltab2x36(:,:,1756))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1901),h0tab(:,1901),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(130),m3h9x4(:,214),heltab2x36(:,:,1757))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1902),h0tab(:,1902),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(131),m3h9x4(:,215),heltab2x36(:,:,1758))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1903),h0tab(:,1903),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(132),m3h9x4(:,216),heltab2x36(:,:,1759))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1904),h0tab(:,1904),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(207),m3h9x4(:,217),heltab2x36(:,:,1760))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1905),h0tab(:,1905),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(208),m3h9x4(:,218),heltab2x36(:,:,1761))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1906),h0tab(:,1906),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(209),m3h9x4(:,219),heltab2x36(:,:,1762))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1907),h0tab(:,1907),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(210),m3h9x4(:,220),heltab2x36(:,:,1763))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1908),h0tab(:,1908),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(133),m3h9x4(:,221),heltab2x36(:,:,1764))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1909),h0tab(:,1909),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(134),m3h9x4(:,222),heltab2x36(:,:,1765))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1910),h0tab(:,1910),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(135),m3h9x4(:,223),heltab2x36(:,:,1766))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1911),h0tab(:,1911),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(136),m3h9x4(:,224),heltab2x36(:,:,1767))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1912),h0tab(:,1912),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(137),m3h9x4(:,225),heltab2x36(:,:,1768))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1913),h0tab(:,1913),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(138),m3h9x4(:,226),heltab2x36(:,:,1769))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1914),h0tab(:,1914),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(139),m3h9x4(:,227),heltab2x36(:,:,1770))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1915),h0tab(:,1915),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(140),m3h9x4(:,228),heltab2x36(:,:,1771))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1916),h0tab(:,1916),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(211),m3h9x4(:,229),heltab2x36(:,:,1772))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1917),h0tab(:,1917),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(212),m3h9x4(:,230),heltab2x36(:,:,1773))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1918),h0tab(:,1918),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(213),m3h9x4(:,231),heltab2x36(:,:,1774))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1919),h0tab(:,1919),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(214),m3h9x4(:,232),heltab2x36(:,:,1775))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1920),h0tab(:,1920),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(141),m3h9x4(:,233),heltab2x36(:,:,1776))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1921),h0tab(:,1921),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(142),m3h9x4(:,234),heltab2x36(:,:,1777))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1922),h0tab(:,1922),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(143),m3h9x4(:,235),heltab2x36(:,:,1778))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1923),h0tab(:,1923),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(144),m3h9x4(:,236),heltab2x36(:,:,1779))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1924),h0tab(:,1924),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(215),m3h9x4(:,237),heltab2x36(:,:,1780))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1925),h0tab(:,1925),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(216),m3h9x4(:,238),heltab2x36(:,:,1781))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1926),h0tab(:,1926),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(217),m3h9x4(:,239),heltab2x36(:,:,1782))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1927),h0tab(:,1927),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(218),m3h9x4(:,240),heltab2x36(:,:,1783))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1928),h0tab(:,1928),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(145),m3h9x4(:,241),heltab2x36(:,:,1784))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1929),h0tab(:,1929),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(146),m3h9x4(:,242),heltab2x36(:,:,1785))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1930),h0tab(:,1930),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(147),m3h9x4(:,243),heltab2x36(:,:,1786))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1931),h0tab(:,1931),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(148),m3h9x4(:,244),heltab2x36(:,:,1787))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1932),h0tab(:,1932),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(219),m3h9x4(:,245),heltab2x36(:,:,1788))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1933),h0tab(:,1933),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(220),m3h9x4(:,246),heltab2x36(:,:,1789))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1934),h0tab(:,1934),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(221),m3h9x4(:,247),heltab2x36(:,:,1790))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1935),h0tab(:,1935),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(222),m3h9x4(:,248),heltab2x36(:,:,1791))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1936),h0tab(:,1936),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(149),m3h9x4(:,249),heltab2x36(:,:,1792))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1937),h0tab(:,1937),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(150),m3h9x4(:,250),heltab2x36(:,:,1793))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1938),h0tab(:,1938),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(151),m3h9x4(:,251),heltab2x36(:,:,1794))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1939),h0tab(:,1939),[24,1,2,4],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(152),m3h9x4(:,252),heltab2x36(:,:,1795))
  Gcoeff(:)%j = (c(137)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1940),h0tab(:,1940),[24,1,4,2],[nML,nML,nML,nML],4,1,wf9(:,6))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,6),G0H4(153),ngH,m3h9x4(:,253),heltab2x36(:,:,1796))
  call Hloop_A_Q(ntryL,G0H4(153),24,nML,G1H4(223),n2h4(87))
  Gcoeff(:)%j = (c(137)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1941),h0tab(:,1941),[24,1,4,2],[nML,nML,nML,nML],4,1,wf9(:,6))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,6),G0H4(153),ngH,m3h9x4(:,254),heltab2x36(:,:,1797))
  call Hloop_Q_A(ntryL,G0H4(153),24,nML,G1H4(224),n2h4(88))
  Gcoeff(:)%j = (c(148)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1942),h0tab(:,1942),[24,1,4,2],[nMT,nMT,nMT,nMT],4,1,wf9(:,6))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,6),G0H4(153),ngH,m3h9x4(:,255),heltab2x36(:,:,1798))
  call Hloop_A_Q(ntryL,G0H4(153),24,nMT,G1H4(225),n2h4(89))
  Gcoeff(:)%j = (c(148)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1943),h0tab(:,1943),[24,1,4,2],[nMT,nMT,nMT,nMT],4,1,wf9(:,6))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,6),G0H4(153),ngH,m3h9x4(:,256),heltab2x36(:,:,1799))
  call Hloop_Q_A(ntryL,G0H4(153),24,nMT,G1H4(226),n2h4(90))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1944),h0tab(:,1944),[24,1,4,2],[nMB,nMB,nMB,nMB],4,1,wf9(:,6))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,6),G0H4(153),ngH,m3h9x4(:,257),heltab2x36(:,:,1800))
  call Hloop_A_Q(ntryL,G0H4(153),24,nMB,G1H4(227),n2h4(91))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1945),h0tab(:,1945),[24,1,4,2],[nMB,nMB,nMB,nMB],4,1,wf9(:,6))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,6),G0H4(153),ngH,m3h9x4(:,258),heltab2x36(:,:,1801))
  call Hloop_Q_A(ntryL,G0H4(153),24,nMB,G1H4(228),n2h4(92))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1946),h0tab(:,1946),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(153),m3h9x4(:,259),heltab2x36(:,:,1802))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1947),h0tab(:,1947),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(154),m3h9x4(:,260),heltab2x36(:,:,1803))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1948),h0tab(:,1948),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(155),m3h9x4(:,261),heltab2x36(:,:,1804))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1949),h0tab(:,1949),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(156),m3h9x4(:,262),heltab2x36(:,:,1805))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1950),h0tab(:,1950),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(157),m3h9x4(:,263),heltab2x36(:,:,1806))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1951),h0tab(:,1951),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(158),m3h9x4(:,264),heltab2x36(:,:,1807))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1952),h0tab(:,1952),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(159),m3h9x4(:,265),heltab2x36(:,:,1808))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1953),h0tab(:,1953),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(160),m3h9x4(:,266),heltab2x36(:,:,1809))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1954),h0tab(:,1954),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(229),m3h9x4(:,267),heltab2x36(:,:,1810))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1955),h0tab(:,1955),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(230),m3h9x4(:,268),heltab2x36(:,:,1811))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1956),h0tab(:,1956),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(161),m3h9x4(:,269),heltab2x36(:,:,1812))
  Gcoeff(:)%j = (c(30)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1957),h0tab(:,1957),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(162),m3h9x4(:,270),heltab2x36(:,:,1813))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1958),h0tab(:,1958),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(231),m3h9x4(:,271),heltab2x36(:,:,1814))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1959),h0tab(:,1959),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(232),m3h9x4(:,272),heltab2x36(:,:,1815))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1960),h0tab(:,1960),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(163),m3h9x4(:,273),heltab2x36(:,:,1816))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1961),h0tab(:,1961),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(164),m3h9x4(:,274),heltab2x36(:,:,1817))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1962),h0tab(:,1962),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(233),m3h9x4(:,275),heltab2x36(:,:,1818))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1963),h0tab(:,1963),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(234),m3h9x4(:,276),heltab2x36(:,:,1819))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1964),h0tab(:,1964),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(165),m3h9x4(:,277),heltab2x36(:,:,1820))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1965),h0tab(:,1965),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(166),m3h9x4(:,278),heltab2x36(:,:,1821))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1966),h0tab(:,1966),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(235),m3h9x4(:,279),heltab2x36(:,:,1822))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1967),h0tab(:,1967),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(236),m3h9x4(:,280),heltab2x36(:,:,1823))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1968),h0tab(:,1968),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(237),m3h9x4(:,281),heltab2x36(:,:,1824))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1969),h0tab(:,1969),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(238),m3h9x4(:,282),heltab2x36(:,:,1825))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1970),h0tab(:,1970),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(167),m3h9x4(:,283),heltab2x36(:,:,1826))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1971),h0tab(:,1971),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,6),G0H4(168),m3h9x4(:,284),heltab2x36(:,:,1827))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1972),h0tab(:,1972),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(239),m3h9x4(:,285),heltab2x36(:,:,1828))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1973),h0tab(:,1973),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(240),m3h9x4(:,286),heltab2x36(:,:,1829))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1974),h0tab(:,1974),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(169),m3h9x4(:,287),heltab2x36(:,:,1830))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1975),h0tab(:,1975),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(170),m3h9x4(:,288),heltab2x36(:,:,1831))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1976),h0tab(:,1976),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(241),m3h9x4(:,289),heltab2x36(:,:,1832))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1977),h0tab(:,1977),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(242),m3h9x4(:,290),heltab2x36(:,:,1833))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1978),h0tab(:,1978),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(171),m3h9x4(:,291),heltab2x36(:,:,1834))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1979),h0tab(:,1979),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,6),G0H4(172),m3h9x4(:,292),heltab2x36(:,:,1835))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1980),h0tab(:,1980),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(243),m3h9x4(:,293),heltab2x36(:,:,1836))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1981),h0tab(:,1981),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,6))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,6),24,G1H4(244),m3h9x4(:,294),heltab2x36(:,:,1837))
  Gcoeff(:)%j = (c(194)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1982),h0tab(:,1982),[24,1,4,2],[nML,nML,nML,nML],4,1,wf9(:,7))
  call Hloop_AV_Q(ntryL,G0H36(1),wf9(:,7),G0H4(173),m3h9x4(:,295),heltab2x36(:,:,1838))
  call Hloop_A_Q(ntryL,G0H4(173),24,nML,G1H4(245),n2h4(93))
  Gcoeff(:)%j = (c(194)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1983),h0tab(:,1983),[24,1,4,2],[nML,nML,nML,nML],4,1,wf9(:,7))
  call Hloop_QV_A(ntryL,G0H36(1),wf9(:,7),G0H4(173),m3h9x4(:,296),heltab2x36(:,:,1839))
  call Hloop_Q_A(ntryL,G0H4(173),24,nML,G1H4(246),n2h4(94))
  Gcoeff(:)%j = (-(c(195)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1984),h0tab(:,1984),[24,1,4,2],[nMT,nMT,nMT,nMT],4,1,wf9(:,7))
  call Hloop_AV_Q(ntryL,G0H36(1),wf9(:,7),G0H4(173),m3h9x4(:,297),heltab2x36(:,:,1840))
  call Hloop_A_Q(ntryL,G0H4(173),24,nMT,G1H4(247),n2h4(95))
  Gcoeff(:)%j = (-(c(195)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1985),h0tab(:,1985),[24,1,4,2],[nMT,nMT,nMT,nMT],4,1,wf9(:,7))
  call Hloop_QV_A(ntryL,G0H36(1),wf9(:,7),G0H4(173),m3h9x4(:,298),heltab2x36(:,:,1841))
  call Hloop_Q_A(ntryL,G0H4(173),24,nMT,G1H4(248),n2h4(96))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1986),h0tab(:,1986),[24,1,4,2],[nMB,nMB,nMB,nMB],4,1,wf9(:,7))
  call Hloop_AV_Q(ntryL,G0H36(1),wf9(:,7),G0H4(173),m3h9x4(:,299),heltab2x36(:,:,1842))
  call Hloop_A_Q(ntryL,G0H4(173),24,nMB,G1H4(249),n2h4(97))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1987),h0tab(:,1987),[24,1,4,2],[nMB,nMB,nMB,nMB],4,1,wf9(:,7))
  call Hloop_QV_A(ntryL,G0H36(1),wf9(:,7),G0H4(173),m3h9x4(:,300),heltab2x36(:,:,1843))
  call Hloop_Q_A(ntryL,G0H4(173),24,nMB,G1H4(250),n2h4(98))
  Gcoeff(:)%j = (-(c(177)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1988),h0tab(:,1988),[24,1,4,2],[nML,nML,nML,nML],4,1,wf9(:,7))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf9(:,7),G0H4(173),ngZl,m3h9x4(:,301),heltab2x36(:,:,1844))
  call Hloop_A_Q(ntryL,G0H4(173),24,nML,G1H4(251),n2h4(99))
  Gcoeff(:)%j = (-(c(177)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1989),h0tab(:,1989),[24,1,4,2],[nML,nML,nML,nML],4,1,wf9(:,7))
  call Hloop_QZ_A(ntryL,G0H36(1),wf9(:,7),G0H4(173),ngZl,m3h9x4(:,302),heltab2x36(:,:,1845))
  call Hloop_Q_A(ntryL,G0H4(173),24,nML,G1H4(252),n2h4(100))
  Gcoeff(:)%j = (-(c(178)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1990),h0tab(:,1990),[24,1,4,2],[nMT,nMT,nMT,nMT],4,1,wf9(:,7))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf9(:,7),G0H4(173),ngZu,m3h9x4(:,303),heltab2x36(:,:,1846))
  call Hloop_A_Q(ntryL,G0H4(173),24,nMT,G1H4(253),n2h4(101))
  Gcoeff(:)%j = (-(c(178)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1991),h0tab(:,1991),[24,1,4,2],[nMT,nMT,nMT,nMT],4,1,wf9(:,7))
  call Hloop_QZ_A(ntryL,G0H36(1),wf9(:,7),G0H4(173),ngZu,m3h9x4(:,304),heltab2x36(:,:,1847))
  call Hloop_Q_A(ntryL,G0H4(173),24,nMT,G1H4(254),n2h4(102))
  Gcoeff(:)%j = (-(c(175)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1992),h0tab(:,1992),[24,1,4,2],[nMB,nMB,nMB,nMB],4,1,wf9(:,7))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf9(:,7),G0H4(173),ngZd,m3h9x4(:,305),heltab2x36(:,:,1848))
  call Hloop_A_Q(ntryL,G0H4(173),24,nMB,G1H4(255),n2h4(103))
  Gcoeff(:)%j = (-(c(175)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1993),h0tab(:,1993),[24,1,4,2],[nMB,nMB,nMB,nMB],4,1,wf9(:,7))
  call Hloop_QZ_A(ntryL,G0H36(1),wf9(:,7),G0H4(173),ngZd,m3h9x4(:,306),heltab2x36(:,:,1849))
  call Hloop_Q_A(ntryL,G0H4(173),24,nMB,G1H4(256),n2h4(104))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1994),h0tab(:,1994),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(257),m3h9x4(:,307),heltab2x36(:,:,1850))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1995),h0tab(:,1995),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(258),m3h9x4(:,308),heltab2x36(:,:,1851))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1996),h0tab(:,1996),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(259),m3h9x4(:,309),heltab2x36(:,:,1852))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1997),h0tab(:,1997),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(260),m3h9x4(:,310),heltab2x36(:,:,1853))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1998),h0tab(:,1998),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,7),G1H4(261),m3h9x4(:,311),heltab2x36(:,:,1854))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1999),h0tab(:,1999),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(262),m3h9x4(:,312),heltab2x36(:,:,1855))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2000),h0tab(:,2000),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,7),G1H4(263),m3h9x4(:,313),heltab2x36(:,:,1856))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2001),h0tab(:,2001),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(264),m3h9x4(:,314),heltab2x36(:,:,1857))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2002),h0tab(:,2002),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,7),G1H4(265),m3h9x4(:,315),heltab2x36(:,:,1858))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2003),h0tab(:,2003),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(266),m3h9x4(:,316),heltab2x36(:,:,1859))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2004),h0tab(:,2004),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,7),G1H4(267),m3h9x4(:,317),heltab2x36(:,:,1860))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2005),h0tab(:,2005),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(268),m3h9x4(:,318),heltab2x36(:,:,1861))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2006),h0tab(:,2006),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(269),m3h9x4(:,319),heltab2x36(:,:,1862))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2007),h0tab(:,2007),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(270),m3h9x4(:,320),heltab2x36(:,:,1863))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2008),h0tab(:,2008),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(271),m3h9x4(:,321),heltab2x36(:,:,1864))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2009),h0tab(:,2009),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(272),m3h9x4(:,322),heltab2x36(:,:,1865))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2010),h0tab(:,2010),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(173),m3h9x4(:,323),heltab2x36(:,:,1866))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2011),h0tab(:,2011),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(174),m3h9x4(:,324),heltab2x36(:,:,1867))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2012),h0tab(:,2012),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(175),m3h9x4(:,325),heltab2x36(:,:,1868))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2013),h0tab(:,2013),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(176),m3h9x4(:,326),heltab2x36(:,:,1869))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2014),h0tab(:,2014),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(273),m3h9x4(:,327),heltab2x36(:,:,1870))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2015),h0tab(:,2015),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(274),m3h9x4(:,328),heltab2x36(:,:,1871))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2016),h0tab(:,2016),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(275),m3h9x4(:,329),heltab2x36(:,:,1872))
  Gcoeff(:)%j = (c(79)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2017),h0tab(:,2017),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(276),m3h9x4(:,330),heltab2x36(:,:,1873))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2018),h0tab(:,2018),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(177),m3h9x4(:,331),heltab2x36(:,:,1874))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2019),h0tab(:,2019),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(178),m3h9x4(:,332),heltab2x36(:,:,1875))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2020),h0tab(:,2020),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(179),m3h9x4(:,333),heltab2x36(:,:,1876))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2021),h0tab(:,2021),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(180),m3h9x4(:,334),heltab2x36(:,:,1877))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2022),h0tab(:,2022),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(277),m3h9x4(:,335),heltab2x36(:,:,1878))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2023),h0tab(:,2023),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(278),m3h9x4(:,336),heltab2x36(:,:,1879))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2024),h0tab(:,2024),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(279),m3h9x4(:,337),heltab2x36(:,:,1880))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2025),h0tab(:,2025),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(280),m3h9x4(:,338),heltab2x36(:,:,1881))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2026),h0tab(:,2026),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(181),m3h9x4(:,339),heltab2x36(:,:,1882))
  Gcoeff(:)%j = (-(c(49)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2027),h0tab(:,2027),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(182),m3h9x4(:,340),heltab2x36(:,:,1883))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2028),h0tab(:,2028),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(183),m3h9x4(:,341),heltab2x36(:,:,1884))
  Gcoeff(:)%j = (c(49)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2029),h0tab(:,2029),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(184),m3h9x4(:,342),heltab2x36(:,:,1885))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2030),h0tab(:,2030),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(281),m3h9x4(:,343),heltab2x36(:,:,1886))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2031),h0tab(:,2031),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(282),m3h9x4(:,344),heltab2x36(:,:,1887))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2032),h0tab(:,2032),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(283),m3h9x4(:,345),heltab2x36(:,:,1888))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2033),h0tab(:,2033),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(284),m3h9x4(:,346),heltab2x36(:,:,1889))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2034),h0tab(:,2034),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(185),m3h9x4(:,347),heltab2x36(:,:,1890))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2035),h0tab(:,2035),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(186),m3h9x4(:,348),heltab2x36(:,:,1891))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2036),h0tab(:,2036),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(187),m3h9x4(:,349),heltab2x36(:,:,1892))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2037),h0tab(:,2037),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(188),m3h9x4(:,350),heltab2x36(:,:,1893))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2038),h0tab(:,2038),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(189),m3h9x4(:,351),heltab2x36(:,:,1894))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2039),h0tab(:,2039),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(190),m3h9x4(:,352),heltab2x36(:,:,1895))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2040),h0tab(:,2040),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(191),m3h9x4(:,353),heltab2x36(:,:,1896))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2041),h0tab(:,2041),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(192),m3h9x4(:,354),heltab2x36(:,:,1897))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2042),h0tab(:,2042),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(285),m3h9x4(:,355),heltab2x36(:,:,1898))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2043),h0tab(:,2043),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(286),m3h9x4(:,356),heltab2x36(:,:,1899))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2044),h0tab(:,2044),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(287),m3h9x4(:,357),heltab2x36(:,:,1900))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2045),h0tab(:,2045),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(288),m3h9x4(:,358),heltab2x36(:,:,1901))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2046),h0tab(:,2046),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(193),m3h9x4(:,359),heltab2x36(:,:,1902))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2047),h0tab(:,2047),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(194),m3h9x4(:,360),heltab2x36(:,:,1903))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2048),h0tab(:,2048),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(195),m3h9x4(:,361),heltab2x36(:,:,1904))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2049),h0tab(:,2049),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(196),m3h9x4(:,362),heltab2x36(:,:,1905))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2050),h0tab(:,2050),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(289),m3h9x4(:,363),heltab2x36(:,:,1906))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2051),h0tab(:,2051),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(290),m3h9x4(:,364),heltab2x36(:,:,1907))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2052),h0tab(:,2052),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(291),m3h9x4(:,365),heltab2x36(:,:,1908))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2053),h0tab(:,2053),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(292),m3h9x4(:,366),heltab2x36(:,:,1909))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2054),h0tab(:,2054),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(197),m3h9x4(:,367),heltab2x36(:,:,1910))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2055),h0tab(:,2055),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(198),m3h9x4(:,368),heltab2x36(:,:,1911))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2056),h0tab(:,2056),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(199),m3h9x4(:,369),heltab2x36(:,:,1912))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2057),h0tab(:,2057),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,7),G0H4(200),m3h9x4(:,370),heltab2x36(:,:,1913))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2058),h0tab(:,2058),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(293),m3h9x4(:,371),heltab2x36(:,:,1914))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2059),h0tab(:,2059),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(294),m3h9x4(:,372),heltab2x36(:,:,1915))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2060),h0tab(:,2060),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(295),m3h9x4(:,373),heltab2x36(:,:,1916))
  Gcoeff(:)%j = (-(c(38)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2061),h0tab(:,2061),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,7),24,G1H4(296),m3h9x4(:,374),heltab2x36(:,:,1917))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2062),h0tab(:,2062),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(201),m3h9x4(:,375),heltab2x36(:,:,1918))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2063),h0tab(:,2063),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(202),m3h9x4(:,376),heltab2x36(:,:,1919))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2064),h0tab(:,2064),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(203),m3h9x4(:,377),heltab2x36(:,:,1920))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2065),h0tab(:,2065),[24,1,4,2],[nMW,nMW,nMW,nMW],4,1,wf9(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,7),G0H4(204),m3h9x4(:,378),heltab2x36(:,:,1921))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(55),[G1H6(66),G1H6(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(63),[G1H6(231),G1H6(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(73),[G1H6(457),G1H6(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(252),[G1H6(43),G0H6(173),G0H6(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(256),[G1H6(60),G0H6(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(257),[G1H6(75),G0H6(174),G0H6(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(258),[G1H6(88),G0H6(175),G0H6(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(259),[G1H6(101),G0H6(176),G0H6(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(263),[G1H6(18),G0H6(177),G0H6(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(264),[G1H6(108),G0H6(178),G0H6(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(656),[G1H6(497),G1H6(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(701),[G1H6(498),G1H6(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(702),[G1H6(513),G1H6(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(29),[G1H6(130),G0H6(107),G0H6(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(127),[G1H6(136),G0H6(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(132),[G1H6(45),G0H6(110),G0H6(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(1),[G1H6(144),G0H6(108),G0H6(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(131),[G1H6(150),G0H6(109),G0H6(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(133),[G1H6(51),G0H6(111),G0H6(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(134),[G1H6(159),G0H6(112),G0H6(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(204),[G1H6(379),G1H6(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(205),[G1H6(384),G1H6(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(206),[G1H6(176),G1H6(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(210),[G1H6(183),G0H6(139),G0H6(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(211),[G1H6(189),G0H6(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(212),[G1H6(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(214),[G1H6(201),G0H6(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(217),[G1H6(207),G0H6(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(218),[G1H6(213),G0H6(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(220),[G1H6(219),G0H6(143),G0H6(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(221),[G1H6(225),G0H6(144),G0H6(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(224),[G1H6(59),G0H6(145),G0H6(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(71),[G1H6(69),G0H6(152),G0H6(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(72),[G1H6(232),G0H6(153),G0H6(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(50),[G1H6(41),G1H6(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(154),[G1H6(42),G1H6(241)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(502),[G1H12(484),G1H12(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(504),[G1H12(485),G1H12(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(506),[G1H12(486),G1H12(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(487),[G1H12(120),G0H12(312),G0H12(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(488),[G1H12(126),G0H12(313),G0H12(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(491),[G1H12(132),G0H12(315),G0H12(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(492),[G1H12(138),G0H12(316),G0H12(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(496),[G1H12(34),G0H12(320),G0H12(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(497),[G1H12(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(500),[G1H12(154),G0H12(323),G0H12(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(528),[G1H12(525),G1H12(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(530),[G1H12(526),G1H12(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(300),[G1H6(167),G1H6(254)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(26),[G1H6(168),G1H6(260)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(113),[G1H6(174),G1H6(266)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(20),[G1H6(272),G0H6(73),G0H6(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(35),[G1H6(278),G0H6(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(15),[G1H6(284)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(24),[G1H6(290),G0H6(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(47),[G1H6(296),G0H6(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(49),[G1H6(302),G0H6(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(340),[G1H6(308),G0H6(77),G0H6(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(342),[G1H6(314),G0H6(78),G0H6(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(357),[G1H6(85),G0H6(79),G0H6(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(481),[G1H6(95),G0H6(86),G0H6(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(482),[G1H6(321),G0H6(87),G0H6(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(461),[G1H12(443),G1H12(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(463),[G1H12(444),G1H12(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(465),[G1H12(445),G1H12(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(446),[G1H12(187),G0H12(285),G0H12(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(447),[G1H12(193),G0H12(286),G0H12(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(450),[G1H12(199),G0H12(288),G0H12(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(451),[G1H12(205),G0H12(289),G0H12(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(455),[G1H12(211),G0H12(293),G0H12(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(456),[G1H12(217)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(459),[G1H12(220),G0H12(296),G0H12(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(43),G0H4(49),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(44),G0H4(50),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(59),[G1H4(57),G0H4(55),G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(60),[G1H4(58),G0H4(56),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(65),[G1H4(63),G0H4(57),G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(66),[G1H4(64),G0H4(58),G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(71),[G1H4(69),G0H4(59),G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(72),[G1H4(70),G0H4(60),G0H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(7),G1H4(76),G1H4(75),G0H4(62),G0H4(61),G0H4(10) &
    ,G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(80),[G1H4(79),G1H4(174),G1H4(169),G0H4(64),G0H4(63) &
    ,G0H4(12),G0H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(86),[G1H4(85),G0H4(65),G0H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(89),[G1H4(90),G0H4(66),G0H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(95),[G1H4(91),G0H4(67),G0H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(96),[G1H4(94),G0H4(68),G0H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(175),[G1H4(170),G0H4(101),G0H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(178),[G1H4(173),G0H4(102),G0H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(197),[G1H4(195),G0H4(107),G0H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(198),[G1H4(196),G0H4(108),G0H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(202),[G1H4(201),G1H4(200),G1H4(199),G0H4(110),G0H4(109) &
    ,G0H4(22),G0H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(205),[G1H4(203),G0H4(111),G0H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(206),[G1H4(204),G0H4(112),G0H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(209),[G1H4(207),G0H4(113),G0H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(210),[G1H4(208),G0H4(114),G0H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(213),[G1H4(211),G0H4(115),G0H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(214),[G1H4(212),G0H4(116),G0H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(217),[G1H4(215),G0H4(117),G0H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(218),[G1H4(216),G0H4(118),G0H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(222),[G1H4(221),G1H4(220),G1H4(219),G0H4(120),G0H4(119) &
    ,G0H4(32),G0H4(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(259),[G1H4(257),G0H4(153),G0H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(260),[G1H4(258),G0H4(154),G0H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(271),[G1H4(269),G0H4(159),G0H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(272),[G1H4(270),G0H4(160),G0H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(276),[G1H4(275),G1H4(274),G1H4(273),G0H4(162),G0H4(161) &
    ,G0H4(38),G0H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(279),[G1H4(277),G0H4(163),G0H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(280),[G1H4(278),G0H4(164),G0H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(283),[G1H4(281),G0H4(165),G0H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(284),[G1H4(282),G0H4(166),G0H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(287),[G1H4(285),G0H4(167),G0H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(288),[G1H4(286),G0H4(168),G0H4(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(291),[G1H4(289),G0H4(169),G0H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(292),[G1H4(290),G0H4(170),G0H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(296),[G1H4(295),G1H4(294),G1H4(293),G0H4(172),G0H4(171) &
    ,G0H4(48),G0H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(226),[G0H6(146),G0H6(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(227),[G0H6(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(228),[G0H6(147),G0H6(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(56),[G0H6(148),G0H6(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(229),[G0H6(149),G0H6(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(230),[G0H6(150),G0H6(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(67),[G0H6(151),G0H6(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(74),[G0H6(166),G0H6(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(79),[G0H6(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(100),[G0H6(170),G0H6(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(5),[G0H6(171),G0H6(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(6),[G0H6(172),G0H6(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(265),[G0H6(179),G0H6(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(267),[G0H6(180),G0H6(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(557),[G0H6(193),G0H6(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(562),[G0H6(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(567),[G0H6(196),G0H6(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(572),[G0H6(197),G0H6(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(301),[G0H6(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(303),[G0H6(198),G0H6(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(306),[G0H6(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(307),[G0H6(199),G0H6(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(358),[G0H6(80),G0H6(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(403),[G0H6(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(404),[G0H6(81),G0H6(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(419),[G0H6(82),G0H6(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(420),[G0H6(83),G0H6(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(435),[G0H6(84),G0H6(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(436),[G0H6(85),G0H6(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(717),[G0H6(100),G0H6(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(718),[G0H6(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(8),[G0H6(104),G0H6(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(123),[G0H6(105),G0H6(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(126),[G0H6(106),G0H6(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(138),[G0H6(113),G0H6(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(139),[G0H6(114),G0H6(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(155),[G0H6(127),G0H6(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(156),[G0H6(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(162),[G0H6(130),G0H6(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(52),[G0H6(131),G0H6(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(369),[G0H6(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(374),[G0H6(132),G0H6(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(169),[G0H6(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(170),[G0H6(133),G0H6(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(448),[G0H12(287),G0H12(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(452),[G0H12(290),G0H12(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(453),[G0H12(291),G0H12(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(454),[G0H12(292),G0H12(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(457),[G0H12(294),G0H12(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(458),[G0H12(295),G0H12(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(489),[G0H12(314),G0H12(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(493),[G0H12(317),G0H12(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(494),[G0H12(318),G0H12(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(495),[G0H12(319),G0H12(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(498),[G0H12(321),G0H12(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(499),[G0H12(322),G0H12(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(194),[G1H12(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(88),[G1H12(238)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(466),[G0H12(270)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(469),[G0H12(271)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(470),[G0H12(272)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(471),[G0H12(273)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(472),[G0H12(274)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(473),[G0H12(275)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(474),[G0H12(276)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(475),[G0H12(277)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(477),[G0H12(278)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(478),[G0H12(279)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(479),[G0H12(280)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(480),[G0H12(281)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(481),[G0H12(282)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(482),[G0H12(283)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(483),[G0H12(284)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(464),[G1H12(460)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(507),[G0H12(297)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(510),[G0H12(298)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(511),[G0H12(299)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(512),[G0H12(300)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(513),[G0H12(301)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(514),[G0H12(302)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(515),[G0H12(303)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(516),[G0H12(304)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(518),[G0H12(305)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(519),[G0H12(306)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(520),[G0H12(307)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(521),[G0H12(308)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(522),[G0H12(309)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(523),[G0H12(310)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(524),[G0H12(311)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(505),[G1H12(501)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(175),[G0H6(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(181),[G0H6(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(182),[G0H6(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(76),[G0H6(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(237),[G0H6(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(32),[G0H6(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(240),[G0H6(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(242),[G0H6(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(285),[G0H6(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(292),[G0H6(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(293),[G0H6(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(299),[G0H6(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(120),[G0H6(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(23),[G0H6(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(122),[G0H6(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(514),[G0H6(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(529),[G0H6(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(530),[G0H6(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(546),[G0H6(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(591),[G0H6(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(592),[G0H6(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(607),[G0H6(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(608),[G0H6(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(623),[G0H6(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(639),[G0H6(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(640),[G0H6(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(655),[G0H6(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(160),[G0H6(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(161),[G0H6(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(141),[G0H6(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(143),[G0H6(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(145),[G0H6(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(149),[G0H6(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(152),[G0H6(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(178),[G0H6(154)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(389),[G0H6(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(394),[G0H6(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(185),[G0H6(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(188),[G0H6(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(190),[G0H6(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(191),[G0H6(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(192),[G0H6(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(196),[G0H6(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(198),[G0H6(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(199),[G0H6(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(203),[G0H6(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(87),[G0H6(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(89),[G0H6(168)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(90),[G0H6(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(462),[G0H6(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(31),[G0H6(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(77),[G0H6(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(472),[G0H6(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(238),[G0H6(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(3),[G0H6(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(447),[G0H6(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(452),[G0H6(188)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(39),[G0H6(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(48),[G0H6(190)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(53),[G0H6(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(54),[G0H6(192)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(287),[G1H6(270)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(288),[G1H6(271)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(294),[G0H6(194)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(295),[G0H6(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(273),[G0H6(200)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(277),[G0H6(201)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(279),[G0H6(202)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(281),[G0H6(203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(582),[G0H6(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(33),[G1H4(25),G1H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(34),[G1H4(26),G1H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(37),[G1H4(27),G1H4(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(38),[G1H4(28),G1H4(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(39),[G1H4(31),G1H4(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(40),[G1H4(32),G1H4(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(53),[G1H4(51),G1H4(47),G1H4(111),G0H4(53),G0H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(54),[G1H4(52),G1H4(48),G1H4(116),G0H4(54),G0H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(99),[G0H4(71),G0H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(100),[G0H4(72),G0H4(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(125),[G0H4(75),G0H4(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(126),[G0H4(76),G0H4(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(141),[G0H4(79),G0H4(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(142),[G0H4(80),G0H4(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(158),[G1H4(157),G0H4(84),G0H4(83),G0H4(82),G0H4(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(184),[G1H4(183),G0H4(88),G0H4(87),G0H4(86),G0H4(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G0H4(91),G0H4(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(5),[G0H4(92),G0H4(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G0H4(95),G0H4(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G0H4(96),G0H4(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(21),[G0H4(99),G0H4(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G0H4(100),G0H4(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(159),[G1H4(144),G1H4(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(164),[G1H4(147),G1H4(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(160),[G1H4(149),G1H4(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(163),[G1H4(152),G1H4(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(165),[G1H4(153),G1H4(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(168),[G1H4(154),G1H4(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(191),[G1H4(186),G1H4(185),G1H4(179),G0H4(105) &
    ,G0H4(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(194),[G1H4(189),G1H4(190),G1H4(180),G0H4(106) &
    ,G0H4(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(112),[G0H4(123),G0H4(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(115),[G0H4(124),G0H4(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(117),[G0H4(127),G0H4(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(120),[G0H4(128),G0H4(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(121),[G0H4(131),G0H4(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(122),[G0H4(132),G0H4(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(132),[G1H4(127),G0H4(136),G0H4(135),G0H4(134) &
    ,G0H4(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(131),[G1H4(128),G0H4(140),G0H4(139),G0H4(138) &
    ,G0H4(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(133),[G0H4(143),G0H4(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(136),[G0H4(144),G0H4(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(137),[G0H4(147),G0H4(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(138),[G0H4(148),G0H4(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(143),[G0H4(151),G0H4(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(148),[G0H4(152),G0H4(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(251),[G1H4(245),G1H4(223)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(252),[G1H4(246),G1H4(224)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(253),[G1H4(247),G1H4(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(254),[G1H4(248),G1H4(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(255),[G1H4(249),G1H4(227)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(256),[G1H4(250),G1H4(228)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(267),[G1H4(265),G1H4(263),G1H4(261),G0H4(157) &
    ,G0H4(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(268),[G1H4(266),G1H4(264),G1H4(262),G0H4(158) &
    ,G0H4(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(229),[G0H4(175),G0H4(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(230),[G0H4(176),G0H4(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(231),[G0H4(179),G0H4(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(232),[G0H4(180),G0H4(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(233),[G0H4(183),G0H4(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(234),[G0H4(184),G0H4(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(236),[G1H4(235),G0H4(188),G0H4(187),G0H4(186) &
    ,G0H4(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(238),[G1H4(237),G0H4(192),G0H4(191),G0H4(190) &
    ,G0H4(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(239),[G0H4(195),G0H4(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(240),[G0H4(196),G0H4(194)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(241),[G0H4(199),G0H4(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(242),[G0H4(200),G0H4(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(243),[G0H4(203),G0H4(201)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(244),[G0H4(204),G0H4(202)])
  call Hloop_AS_Q(ntryL,G1H6(55),ex1(:),G1H6(309),ngH,m3h1x6(:,139),heltab2x6(:,:,817))
  call Hloop_A_Q(ntryL,G1H6(309),21,nML,G2H6(137),n2h6(295))
  call Hloop_QS_A(ntryL,G1H6(63),ex1(:),G1H6(310),ngH,m3h1x6(:,140),heltab2x6(:,:,818))
  call Hloop_Q_A(ntryL,G1H6(310),21,nMT,G2H6(141),n2h6(296))
  call Hloop_AS_Q(ntryL,G1H6(73),ex1(:),G1H6(313),ngH,m3h1x6(:,141),heltab2x6(:,:,819))
  call Hloop_A_Q(ntryL,G1H6(313),21,nMB,G2H6(32),n2h6(297))
  call Hloop_ST_V(ntryL,G1H6(252),20,ex1(:),1,G2H6(145),m3h1x6(:,142),heltab2x6(:,:,820))
  call Hloop_ST_V(ntryL,G1H6(256),20,ex1(:),1,G2H6(149),m3h1x6(:,143),heltab2x6(:,:,821))
  call Hloop_VT_S(ntryL,G1H6(257),20,ex1(:),1,G2H6(35),m3h1x6(:,144),heltab2x6(:,:,822))
  call Hloop_VT_S(ntryL,G1H6(258),20,ex1(:),1,G2H6(36),m3h1x6(:,145),heltab2x6(:,:,823))
  call Hloop_ST_V(ntryL,G1H6(259),20,ex1(:),1,G2H6(125),m3h1x6(:,146),heltab2x6(:,:,824))
  call Hloop_VT_S(ntryL,G1H6(263),20,ex1(:),1,G2H6(129),m3h1x6(:,147),heltab2x6(:,:,825))
  call Hloop_VT_S(ntryL,G1H6(264),20,ex1(:),1,G2H6(133),m3h1x6(:,148),heltab2x6(:,:,826))
  call Hloop_AS_Q(ntryL,G1H6(656),ex1(:),G1H6(315),ngH,m3h1x6(:,149),heltab2x6(:,:,827))
  call Hloop_A_Q(ntryL,G1H6(315),19,nML,G2H6(46),n2h6(298))
  call Hloop_QS_A(ntryL,G1H6(701),ex1(:),G1H6(316),ngH,m3h1x6(:,150),heltab2x6(:,:,828))
  call Hloop_Q_A(ntryL,G1H6(316),19,nMT,G2H6(47),n2h6(299))
  call Hloop_AS_Q(ntryL,G1H6(702),ex1(:),G1H6(317),ngH,m3h1x6(:,151),heltab2x6(:,:,829))
  call Hloop_A_Q(ntryL,G1H6(317),19,nMB,G2H6(39),n2h6(300))
  call Hloop_ST_V(ntryL,G1H6(29),18,ex1(:),1,G2H6(40),m3h1x6(:,152),heltab2x6(:,:,830))
  call Hloop_ST_V(ntryL,G1H6(127),18,ex1(:),1,G2H6(41),m3h1x6(:,153),heltab2x6(:,:,831))
  call Hloop_ST_V(ntryL,G1H6(132),18,ex1(:),1,G2H6(42),m3h1x6(:,154),heltab2x6(:,:,832))
  call Hloop_VT_S(ntryL,G1H6(1),18,ex1(:),1,G2H6(51),m3h1x6(:,155),heltab2x6(:,:,833))
  call Hloop_VT_S(ntryL,G1H6(131),18,ex1(:),1,G2H6(52),m3h1x6(:,156),heltab2x6(:,:,834))
  call Hloop_VT_S(ntryL,G1H6(133),18,ex1(:),1,G2H6(50),m3h1x6(:,157),heltab2x6(:,:,835))
  call Hloop_VT_S(ntryL,G1H6(134),18,ex1(:),1,G2H6(189),m3h1x6(:,158),heltab2x6(:,:,836))
  call Hloop_AV_Q(ntryL,G1H6(204),ex2(:),G1H3(102),m3h2x3(:,477),heltab2x6(:,:,837))
  call Hloop_A_Q(ntryL,G1H3(102),22,nML,G2H3(1),n2h3(195))
  call Hloop_QV_A(ntryL,G1H6(205),ex2(:),G1H3(111),m3h2x3(:,478),heltab2x6(:,:,838))
  call Hloop_Q_A(ntryL,G1H3(111),22,nMT,G2H3(2),n2h3(196))
  call Hloop_AV_Q(ntryL,G1H6(206),ex2(:),G1H3(49),m3h2x3(:,479),heltab2x6(:,:,839))
  call Hloop_A_Q(ntryL,G1H3(49),22,nMB,G2H3(3),n2h3(197))
  call Hloop_SV_T(ntryL,G1H6(210),20,ex2(:),2,G2H3(4),m3h2x3(:,480),heltab2x6(:,:,840))
  call Hloop_SV_T(ntryL,G1H6(211),20,ex2(:),2,G2H3(7),m3h2x3(:,481),heltab2x6(:,:,841))
  call Hloop_DV_C(ntryL,G1H6(212),20,ex2(:),G2H3(8),m3h2x3(:,482),heltab2x6(:,:,842))
  call Hloop_DV_C(ntryL,G1H6(214),20,ex2(:),G2H3(11),m3h2x3(:,483),heltab2x6(:,:,843))
  call Hloop_CV_D(ntryL,G1H6(217),20,ex2(:),2,G2H3(15),m3h2x3(:,484),heltab2x6(:,:,844))
  call Hloop_CV_D(ntryL,G1H6(218),20,ex2(:),2,G2H3(16),m3h2x3(:,485),heltab2x6(:,:,845))
  call Hloop_UW_V(ntryL,G1H6(220),20,ex2(:),2,G2H3(17),m3h2x3(:,486),heltab2x6(:,:,846))
  call Hloop_UW_V(ntryL,G1H6(221),20,ex2(:),2,G2H3(18),m3h2x3(:,487),heltab2x6(:,:,847))
  call Hloop_SV_T(ntryL,G1H6(224),20,ex2(:),2,G2H3(21),m3h2x3(:,488),heltab2x6(:,:,848))
  call Hloop_UW_V(ntryL,G1H6(71),20,ex2(:),2,G2H3(22),m3h2x3(:,489),heltab2x6(:,:,849))
  call Hloop_UW_V(ntryL,G1H6(72),20,ex2(:),2,G2H3(25),m3h2x3(:,490),heltab2x6(:,:,850))
  call Hloop_QS_A(ntryL,G1H6(50),ex1(:),G1H6(82),ngH,m3h1x6(:,159),heltab2x6(:,:,851))
  call Hloop_Q_A(ntryL,G1H6(82),19,nMT,G2H6(193),n2h6(301))
  call Hloop_AS_Q(ntryL,G1H6(154),ex1(:),G1H6(318),ngH,m3h1x6(:,160),heltab2x6(:,:,852))
  call Hloop_A_Q(ntryL,G1H6(318),19,nMB,G2H6(53),n2h6(302))
  call Hloop_AV_Q(ntryL,G1H12(502),ex2(:),G1H6(319),m3h2x6(:,403),heltab2x12(:,:,689))
  call Hloop_A_Q(ntryL,G1H6(319),19,nML,G2H6(54),n2h6(303))
  call Hloop_QV_A(ntryL,G1H12(504),ex2(:),G1H6(93),m3h2x6(:,404),heltab2x12(:,:,690))
  call Hloop_Q_A(ntryL,G1H6(93),19,nMT,G2H6(197),n2h6(304))
  call Hloop_AV_Q(ntryL,G1H12(506),ex2(:),G1H6(97),m3h2x6(:,405),heltab2x12(:,:,691))
  call Hloop_A_Q(ntryL,G1H6(97),19,nMB,G2H6(173),n2h6(305))
  call Hloop_SV_T(ntryL,G1H12(487),17,ex2(:),2,G2H6(177),m3h2x6(:,406),heltab2x12(:,:,692))
  call Hloop_SV_T(ntryL,G1H12(488),17,ex2(:),2,G2H6(181),m3h2x6(:,407),heltab2x12(:,:,693))
  call Hloop_SV_T(ntryL,G1H12(491),17,ex2(:),2,G2H6(185),m3h2x6(:,408),heltab2x12(:,:,694))
  call Hloop_SV_T(ntryL,G1H12(492),17,ex2(:),2,G2H6(64),m3h2x6(:,409),heltab2x12(:,:,695))
  call Hloop_UW_V(ntryL,G1H12(496),17,ex2(:),2,G2H6(65),m3h2x6(:,410),heltab2x12(:,:,696))
  call Hloop_UW_V(ntryL,G1H12(497),17,ex2(:),2,G2H6(58),m3h2x6(:,411),heltab2x12(:,:,697))
  call Hloop_UW_V(ntryL,G1H12(500),17,ex2(:),2,G2H6(59),m3h2x6(:,412),heltab2x12(:,:,698))
  call Hloop_QV_A(ntryL,G1H12(528),ex2(:),G1H6(98),m3h2x6(:,413),heltab2x12(:,:,699))
  call Hloop_Q_A(ntryL,G1H6(98),19,nMT,G2H6(57),n2h6(306))
  call Hloop_AV_Q(ntryL,G1H12(530),ex2(:),G1H6(92),m3h2x6(:,414),heltab2x12(:,:,700))
  call Hloop_A_Q(ntryL,G1H6(92),19,nMB,G2H6(60),n2h6(307))
  call Hloop_AV_Q(ntryL,G1H6(300),ex3(:),G1H3(124),m3h2x3(:,491),heltab2x6(:,:,853))
  call Hloop_A_Q(ntryL,G1H3(124),22,nML,G2H3(145),n2h3(198))
  call Hloop_QV_A(ntryL,G1H6(26),ex3(:),G1H3(134),m3h2x3(:,492),heltab2x6(:,:,854))
  call Hloop_Q_A(ntryL,G1H3(134),22,nMT,G2H3(5),n2h3(199))
  call Hloop_AV_Q(ntryL,G1H6(113),ex3(:),G1H3(149),m3h2x3(:,493),heltab2x6(:,:,855))
  call Hloop_A_Q(ntryL,G1H3(149),22,nMB,G2H3(6),n2h3(200))
  call Hloop_SV_T(ntryL,G1H6(20),18,ex3(:),4,G2H3(41),m3h2x3(:,494),heltab2x6(:,:,856))
  call Hloop_SV_T(ntryL,G1H6(35),18,ex3(:),4,G2H3(45),m3h2x3(:,495),heltab2x6(:,:,857))
  call Hloop_DV_C(ntryL,G1H6(15),18,ex3(:),G2H3(9),m3h2x3(:,496),heltab2x6(:,:,858))
  call Hloop_DV_C(ntryL,G1H6(24),18,ex3(:),G2H3(10),m3h2x3(:,497),heltab2x6(:,:,859))
  call Hloop_CV_D(ntryL,G1H6(47),18,ex3(:),4,G2H3(12),m3h2x3(:,498),heltab2x6(:,:,860))
  call Hloop_CV_D(ntryL,G1H6(49),18,ex3(:),4,G2H3(13),m3h2x3(:,499),heltab2x6(:,:,861))
  call Hloop_UW_V(ntryL,G1H6(340),18,ex3(:),4,G2H3(73),m3h2x3(:,500),heltab2x6(:,:,862))
  call Hloop_UW_V(ntryL,G1H6(342),18,ex3(:),4,G2H3(77),m3h2x3(:,501),heltab2x6(:,:,863))
  call Hloop_SV_T(ntryL,G1H6(357),18,ex3(:),4,G2H3(81),m3h2x3(:,502),heltab2x6(:,:,864))
  call Hloop_UW_V(ntryL,G1H6(481),18,ex3(:),4,G2H3(14),m3h2x3(:,503),heltab2x6(:,:,865))
  call Hloop_UW_V(ntryL,G1H6(482),18,ex3(:),4,G2H3(65),m3h2x3(:,504),heltab2x6(:,:,866))
  call Hloop_AW_Q(ntryL,G1H6(104),ex4(:),G1H2(97),m3h3x2(:,203),heltab2x6(:,:,867))
  call Hloop_A_Q(ntryL,G1H2(97),26,nMT,G2H2(46),n2h2(99))
  call Hloop_QW_A(ntryL,G1H6(330),ex4(:),G1H2(104),m3h3x2(:,204),heltab2x6(:,:,868))
  call Hloop_Q_A(ntryL,G1H2(104),26,nMB,G2H2(47),n2h2(100))
  call Hloop_AV_Q(ntryL,G1H12(461),ex3(:),G1H6(320),m3h2x6(:,415),heltab2x12(:,:,701))
  call Hloop_A_Q(ntryL,G1H6(320),21,nML,G2H6(69),n2h6(308))
  call Hloop_QV_A(ntryL,G1H12(463),ex3(:),G1H6(324),m3h2x6(:,416),heltab2x12(:,:,702))
  call Hloop_Q_A(ntryL,G1H6(324),21,nMT,G2H6(70),n2h6(309))
  call Hloop_AV_Q(ntryL,G1H12(465),ex3(:),G1H6(102),m3h2x6(:,417),heltab2x12(:,:,703))
  call Hloop_A_Q(ntryL,G1H6(102),21,nMB,G2H6(68),n2h6(310))
  call Hloop_SV_T(ntryL,G1H12(446),17,ex3(:),4,G2H6(239),m3h2x6(:,418),heltab2x12(:,:,704))
  call Hloop_SV_T(ntryL,G1H12(447),17,ex3(:),4,G2H6(243),m3h2x6(:,419),heltab2x12(:,:,705))
  call Hloop_SV_T(ntryL,G1H12(450),17,ex3(:),4,G2H6(71),m3h2x6(:,420),heltab2x12(:,:,706))
  call Hloop_SV_T(ntryL,G1H12(451),17,ex3(:),4,G2H6(72),m3h2x6(:,421),heltab2x12(:,:,707))
  call Hloop_UW_V(ntryL,G1H12(455),17,ex3(:),4,G2H6(247),m3h2x6(:,422),heltab2x12(:,:,708))
  call Hloop_UW_V(ntryL,G1H12(456),17,ex3(:),4,G2H6(223),m3h2x6(:,423),heltab2x12(:,:,709))
  call Hloop_UW_V(ntryL,G1H12(459),17,ex3(:),4,G2H6(227),m3h2x6(:,424),heltab2x12(:,:,710))
  call Hloop_QV_A(ntryL,G1H12(225),ex3(:),G1H6(103),m3h2x6(:,425),heltab2x12(:,:,711))
  call Hloop_Q_A(ntryL,G1H6(103),21,nMT,G2H6(231),n2h6(311))
  call Hloop_AV_Q(ntryL,G1H12(231),ex3(:),G1H6(325),m3h2x6(:,426),heltab2x12(:,:,712))
  call Hloop_A_Q(ntryL,G1H6(325),21,nMB,G2H6(235),n2h6(312))
  call Hloop_AW_Q(ntryL,G1H12(237),ex4(:),G1H4(43),m3h3x4(:,105),heltab2x12(:,:,713))
  call Hloop_A_Q(ntryL,G1H4(43),25,nMT,G2H4(10),n2h4(105))
  call Hloop_QW_A(ntryL,G1H12(241),ex4(:),G1H4(44),m3h3x4(:,106),heltab2x12(:,:,714))
  call Hloop_Q_A(ntryL,G1H4(44),25,nMB,G2H4(51),n2h4(106))
  call Hloop_TV_S(ntryL,G1H12(247),17,ex4(:),8,G2H4(11),m3h3x4(:,107),heltab2x12(:,:,715))
  call Hloop_UW_V(ntryL,G1H12(253),17,ex4(:),8,G2H4(18),m3h3x4(:,108),heltab2x12(:,:,716))
  call Hloop_TV_S(ntryL,G1H12(4),17,ex4(:),8,G2H4(13),m3h3x4(:,109),heltab2x12(:,:,717))
  call Hloop_UW_V(ntryL,G1H12(19),17,ex4(:),8,G2H4(14),m3h3x4(:,110),heltab2x12(:,:,718))
  call Hloop_AW_Q(ntryL,G1H12(39),ex4(:),G1H4(57),m3h3x4(:,111),heltab2x12(:,:,719))
  call Hloop_A_Q(ntryL,G1H4(57),25,nMT,G2H4(15),n2h4(107))
  call Hloop_QW_A(ntryL,G1H12(54),ex4(:),G1H4(58),m3h3x4(:,112),heltab2x12(:,:,720))
  call Hloop_Q_A(ntryL,G1H4(58),25,nMB,G2H4(16),n2h4(108))
  call Hloop_TV_S(ntryL,G1H12(74),17,ex4(:),8,G2H4(19),m3h3x4(:,113),heltab2x12(:,:,721))
  call Hloop_UW_V(ntryL,G1H12(6),17,ex4(:),8,G2H4(67),m3h3x4(:,114),heltab2x12(:,:,722))
  call Hloop_TV_S(ntryL,G1H12(17),17,ex4(:),8,G2H4(20),m3h3x4(:,115),heltab2x12(:,:,723))
  call Hloop_UW_V(ntryL,G1H12(30),17,ex4(:),8,G2H4(75),m3h3x4(:,116),heltab2x12(:,:,724))
  call Hloop_TV_S(ntryL,G1H4(1),24,ex2(:),2,G2H2(49),m3h2x2(:,143),heltab2x4(:,:,143))
  call Hloop_SV_T(ntryL,G1H4(2),24,ex2(:),2,G2H2(50),m3h2x2(:,144),heltab2x4(:,:,144))
  call Hloop_UV_W(ntryL,G1H4(59),24,ex2(:),2,G2H2(52),m3h2x2(:,145),heltab2x4(:,:,145))
  call Hloop_UW_V(ntryL,G1H4(60),24,ex2(:),2,G2H2(53),m3h2x2(:,146),heltab2x4(:,:,146))
  call Hloop_TV_S(ntryL,G1H4(65),24,ex2(:),2,G2H2(55),m3h2x2(:,147),heltab2x4(:,:,147))
  call Hloop_SV_T(ntryL,G1H4(66),24,ex2(:),2,G2H2(56),m3h2x2(:,148),heltab2x4(:,:,148))
  call Hloop_SV_V(ntryL,G1H4(71),ex2(:),G1H2(109),m3h2x2(:,149),heltab2x4(:,:,149))
  call Hloop_SV_V(ntryL,G1H4(72),ex2(:),G1H2(115),m3h2x2(:,150),heltab2x4(:,:,150))
  call Hloop_VV_S(ntryL,G1H4(8),ex2(:),G1H2(120),m3h2x2(:,151),heltab2x4(:,:,151))
  call Hloop_SV_V(ntryL,G1H4(80),ex2(:),G1H2(126),m3h2x2(:,152),heltab2x4(:,:,152))
  call Hloop_VV_S(ntryL,G1H4(86),ex2(:),G1H2(142),m3h2x2(:,153),heltab2x4(:,:,153))
  call Hloop_VV_S(ntryL,G1H4(89),ex2(:),G1H2(163),m3h2x2(:,154),heltab2x4(:,:,154))
  call Hloop_UV_W(ntryL,G1H4(95),24,ex2(:),2,G2H2(37),m3h2x2(:,155),heltab2x4(:,:,155))
  call Hloop_UW_V(ntryL,G1H4(96),24,ex2(:),2,G2H2(40),m3h2x2(:,156),heltab2x4(:,:,156))
  call Hloop_SS_S(ntryL,G1H4(175),ex1(:),G1H4(63),m3h1x4(:,1),heltab2x4(:,:,157))
  call Hloop_SS_S(ntryL,G1H4(178),ex1(:),G1H4(64),m3h1x4(:,2),heltab2x4(:,:,158))
  call Hloop_VS_V(ntryL,G1H4(197),ex1(:),G1H4(69),m3h1x4(:,3),heltab2x4(:,:,159))
  call Hloop_VS_V(ntryL,G1H4(198),ex1(:),G1H4(70),m3h1x4(:,4),heltab2x4(:,:,160))
  call Hloop_SS_S(ntryL,G1H4(202),ex1(:),G1H4(7),m3h1x4(:,5),heltab2x4(:,:,161))
  call Hloop_ST_V(ntryL,G1H4(205),24,ex1(:),1,G2H4(35),m3h1x4(:,6),heltab2x4(:,:,162))
  call Hloop_ST_V(ntryL,G1H4(206),24,ex1(:),1,G2H4(37),m3h1x4(:,7),heltab2x4(:,:,163))
  call Hloop_VT_S(ntryL,G1H4(209),24,ex1(:),1,G2H4(38),m3h1x4(:,8),heltab2x4(:,:,164))
  call Hloop_VT_S(ntryL,G1H4(210),24,ex1(:),1,G2H4(39),m3h1x4(:,9),heltab2x4(:,:,165))
  call Hloop_ST_V(ntryL,G1H4(213),24,ex1(:),1,G2H4(41),m3h1x4(:,10),heltab2x4(:,:,166))
  call Hloop_ST_V(ntryL,G1H4(214),24,ex1(:),1,G2H4(42),m3h1x4(:,11),heltab2x4(:,:,167))
  call Hloop_VT_S(ntryL,G1H4(217),24,ex1(:),1,G2H4(45),m3h1x4(:,12),heltab2x4(:,:,168))
  call Hloop_VT_S(ntryL,G1H4(218),24,ex1(:),1,G2H4(46),m3h1x4(:,13),heltab2x4(:,:,169))
  call Hloop_VS_V(ntryL,G1H4(222),ex1(:),G1H4(76),m3h1x4(:,14),heltab2x4(:,:,170))
  call Hloop_SS_S(ntryL,G1H4(259),ex1(:),G1H4(75),m3h1x4(:,15),heltab2x4(:,:,171))
  call Hloop_SS_S(ntryL,G1H4(260),ex1(:),G1H4(79),m3h1x4(:,16),heltab2x4(:,:,172))
  call Hloop_VS_V(ntryL,G1H4(271),ex1(:),G1H4(174),m3h1x4(:,17),heltab2x4(:,:,173))
  call Hloop_VS_V(ntryL,G1H4(272),ex1(:),G1H4(169),m3h1x4(:,18),heltab2x4(:,:,174))
  call Hloop_SS_S(ntryL,G1H4(276),ex1(:),G1H4(85),m3h1x4(:,19),heltab2x4(:,:,175))
  call Hloop_ST_V(ntryL,G1H4(279),24,ex1(:),1,G2H4(47),m3h1x4(:,20),heltab2x4(:,:,176))
  call Hloop_ST_V(ntryL,G1H4(280),24,ex1(:),1,G2H4(49),m3h1x4(:,21),heltab2x4(:,:,177))
  call Hloop_VT_S(ntryL,G1H4(283),24,ex1(:),1,G2H4(50),m3h1x4(:,22),heltab2x4(:,:,178))
  call Hloop_VT_S(ntryL,G1H4(284),24,ex1(:),1,G2H4(53),m3h1x4(:,23),heltab2x4(:,:,179))
  call Hloop_ST_V(ntryL,G1H4(287),24,ex1(:),1,G2H4(54),m3h1x4(:,24),heltab2x4(:,:,180))
  call Hloop_ST_V(ntryL,G1H4(288),24,ex1(:),1,G2H4(55),m3h1x4(:,25),heltab2x4(:,:,181))
  call Hloop_VT_S(ntryL,G1H4(291),24,ex1(:),1,G2H4(57),m3h1x4(:,26),heltab2x4(:,:,182))
  call Hloop_VT_S(ntryL,G1H4(292),24,ex1(:),1,G2H4(58),m3h1x4(:,27),heltab2x4(:,:,183))
  call Hloop_VS_V(ntryL,G1H4(296),ex1(:),G1H4(90),m3h1x4(:,28),heltab2x4(:,:,184))
  call Hloop_SV_V(ntryL,G1H6(226),ex2(:),G1H3(60),m3h2x3(:,505),heltab2x6(:,:,869))
  call Hloop_SV_V(ntryL,G1H6(227),ex2(:),G1H3(216),m3h2x3(:,506),heltab2x6(:,:,870))
  call Hloop_VV_S(ntryL,G1H6(228),ex2(:),G1H3(236),m3h2x3(:,507),heltab2x6(:,:,871))
  call Hloop_VV_S(ntryL,G1H6(56),ex2(:),G1H3(169),m3h2x3(:,508),heltab2x6(:,:,872))
  call Hloop_SV_V(ntryL,G1H6(229),ex2(:),G1H3(78),m3h2x3(:,509),heltab2x6(:,:,873))
  call Hloop_VV_S(ntryL,G1H6(230),ex2(:),G1H3(180),m3h2x3(:,510),heltab2x6(:,:,874))
  call Hloop_VV_S(ntryL,G1H6(67),ex2(:),G1H3(189),m3h2x3(:,511),heltab2x6(:,:,875))
  call Hloop_SS_S(ntryL,G1H6(74),ex1(:),G1H6(328),m3h1x6(:,161),heltab2x6(:,:,876))
  call Hloop_SS_S(ntryL,G1H6(79),ex1(:),G1H6(329),m3h1x6(:,162),heltab2x6(:,:,877))
  call Hloop_VS_V(ntryL,G1H6(100),ex1(:),G1H6(331),m3h1x6(:,163),heltab2x6(:,:,878))



end subroutine vamp_1

end module ol_vamp_1_pphvv_ew_haawwx_1_/**/REALKIND
