
module ol_vamp_1_pphvv_ew_bbxhaz_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphvv_ew_bbxhaz_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphvv_ew_bbxhaz_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pphvv_ew_bbxhaz_1_/**/DREALKIND
  use ol_tensor_sum_storage_pphvv_ew_bbxhaz_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pphvv_ew_bbxhaz_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pphvv_ew_bbxhaz_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(88)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[nMB,nMB,nMH,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(1),ngZd,m3h3x8(:,1),heltab2x24(:,:,1))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(1),n2h8(1))
  Gcoeff(:)%j = (c(88)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[nMB,nMB,nMZ,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(1),ngZd,m3h3x8(:,2),heltab2x24(:,:,2))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(2),n2h8(2))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[nMT,nMT,nMW,nMT,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(1),ngZu,m3h3x8(:,3),heltab2x24(:,:,3))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(3),n2h8(3))
  Gcoeff(:)%j = (c(243)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(4),m3h3x8(:,4),heltab2x24(:,:,4))
  Gcoeff(:)%j = (c(208)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(5),h0tab(:,5),[16,4,1,2,8],[nMB,nMB,0,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(1),ngZd,m3h3x8(:,5),heltab2x24(:,:,5))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(5),n2h8(4))
  Gcoeff(:)%j = (c(209)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(6),h0tab(:,6),[16,4,1,2,8],[nMB,nMB,nMZ,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(1),ngZd,m3h3x8(:,6),heltab2x24(:,:,6))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(6),n2h8(5))
  Gcoeff(:)%j = (-(c(121)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(7),h0tab(:,7),[16,4,1,2,8],[nMT,nMT,nMW,nMT,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(1),ngZu,m3h3x8(:,7),heltab2x24(:,:,7))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(7),n2h8(6))
  Gcoeff(:)%j = (c(210)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(8),h0tab(:,8),[16,4,1,2,8],[nMB,nMB,0,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(1),ngZd,m3h3x8(:,8),heltab2x24(:,:,8))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(8),n2h8(7))
  Gcoeff(:)%j = (-(c(163)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(9),h0tab(:,9),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(1),m3h3x8(:,9),heltab2x24(:,:,9))
  Gcoeff(:)%j = (-(c(151)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(10),h0tab(:,10),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(2),m3h3x8(:,10),heltab2x24(:,:,10))
  Gcoeff(:)%j = (c(275)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(11),h0tab(:,11),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(9),m3h3x8(:,11),heltab2x24(:,:,11))
  Gcoeff(:)%j = (c(265)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(12),h0tab(:,12),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(10),m3h3x8(:,12),heltab2x24(:,:,12))
  Gcoeff(:)%j = (c(35)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(13),h0tab(:,13),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(11),m3h3x8(:,13),heltab2x24(:,:,13))
  Gcoeff(:)%j = (c(163)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(14),h0tab(:,14),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(3),m3h3x8(:,14),heltab2x24(:,:,14))
  Gcoeff(:)%j = (-(c(180)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(15),h0tab(:,15),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(4),m3h3x8(:,15),heltab2x24(:,:,15))
  Gcoeff(:)%j = (-(c(180)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(16),h0tab(:,16),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(5),m3h3x8(:,16),heltab2x24(:,:,16))
  Gcoeff(:)%j = (-(c(182)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(17),h0tab(:,17),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(6),m3h3x8(:,17),heltab2x24(:,:,17))
  Gcoeff(:)%j = (c(290)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(18),h0tab(:,18),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(12),m3h3x8(:,18),heltab2x24(:,:,18))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(19),h0tab(:,19),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(13),m3h3x8(:,19),heltab2x24(:,:,19))
  Gcoeff(:)%j = (c(71)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(20),h0tab(:,20),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(14),m3h3x8(:,20),heltab2x24(:,:,20))
  Gcoeff(:)%j = (c(180)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(21),h0tab(:,21),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(7),m3h3x8(:,21),heltab2x24(:,:,21))
  Gcoeff(:)%j = (-(c(204)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(22),h0tab(:,22),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(8),m3h3x8(:,22),heltab2x24(:,:,22))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(23),h0tab(:,23),[16,4,1,2,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(15),m3h3x8(:,23),heltab2x24(:,:,23))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(24),h0tab(:,24),[16,2,1,4,8],[nMB,nMH,nMB,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(9),ngZd,m3h3x8(:,24),heltab2x24(:,:,24))
  call Hloop_Q_A(ntryL,G0H8(9),16,nMB,G1H8(16),n2h8(8))
  Gcoeff(:)%j = (c(88)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(25),h0tab(:,25),[16,2,1,4,8],[nMB,nMZ,nMB,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(9),ngZd,m3h3x8(:,25),heltab2x24(:,:,25))
  call Hloop_Q_A(ntryL,G0H8(9),16,nMB,G1H8(17),n2h8(9))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(26),h0tab(:,26),[16,2,1,4,8],[nMT,nMW,nMT,nMT,nMT],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(9),ngZu,m3h3x8(:,26),heltab2x24(:,:,26))
  call Hloop_Q_A(ntryL,G0H8(9),16,nMT,G1H8(18),n2h8(10))
  Gcoeff(:)%j = (c(243)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(27),h0tab(:,27),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(19),m3h3x8(:,27),heltab2x24(:,:,27))
  Gcoeff(:)%j = (c(208)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(28),h0tab(:,28),[16,2,1,4,8],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(9),ngZd,m3h3x8(:,28),heltab2x24(:,:,28))
  call Hloop_Q_A(ntryL,G0H8(9),16,nMB,G1H8(20),n2h8(11))
  Gcoeff(:)%j = (c(209)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(29),h0tab(:,29),[16,2,1,4,8],[nMB,nMZ,nMB,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(9),ngZd,m3h3x8(:,29),heltab2x24(:,:,29))
  call Hloop_Q_A(ntryL,G0H8(9),16,nMB,G1H8(21),n2h8(12))
  Gcoeff(:)%j = (-(c(121)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(30),h0tab(:,30),[16,2,1,4,8],[nMT,nMW,nMT,nMT,nMT],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(9),ngZu,m3h3x8(:,30),heltab2x24(:,:,30))
  call Hloop_Q_A(ntryL,G0H8(9),16,nMT,G1H8(22),n2h8(13))
  Gcoeff(:)%j = (c(210)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(31),h0tab(:,31),[16,2,1,4,8],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(9),ngZd,m3h3x8(:,31),heltab2x24(:,:,31))
  call Hloop_Q_A(ntryL,G0H8(9),16,nMB,G1H8(23),n2h8(14))
  Gcoeff(:)%j = (-(c(163)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(32),h0tab(:,32),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(9),m3h3x8(:,32),heltab2x24(:,:,32))
  Gcoeff(:)%j = (-(c(265)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(33),h0tab(:,33),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(24),m3h3x8(:,33),heltab2x24(:,:,33))
  Gcoeff(:)%j = (c(163)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(34),h0tab(:,34),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(10),m3h3x8(:,34),heltab2x24(:,:,34))
  Gcoeff(:)%j = (c(265)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(35),h0tab(:,35),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(25),m3h3x8(:,35),heltab2x24(:,:,35))
  Gcoeff(:)%j = (-(c(151)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(36),h0tab(:,36),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(11),m3h3x8(:,36),heltab2x24(:,:,36))
  Gcoeff(:)%j = (-(c(51)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(37),h0tab(:,37),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(26),m3h3x8(:,37),heltab2x24(:,:,37))
  Gcoeff(:)%j = (-(c(180)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(38),h0tab(:,38),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(12),m3h3x8(:,38),heltab2x24(:,:,38))
  Gcoeff(:)%j = (-(c(180)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(39),h0tab(:,39),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(13),m3h3x8(:,39),heltab2x24(:,:,39))
  Gcoeff(:)%j = (-(c(292)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(40),h0tab(:,40),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(27),m3h3x8(:,40),heltab2x24(:,:,40))
  Gcoeff(:)%j = (c(180)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(41),h0tab(:,41),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(14),m3h3x8(:,41),heltab2x24(:,:,41))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(42),h0tab(:,42),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(28),m3h3x8(:,42),heltab2x24(:,:,42))
  Gcoeff(:)%j = (-(c(182)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(43),h0tab(:,43),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(15),m3h3x8(:,43),heltab2x24(:,:,43))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(44),h0tab(:,44),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(29),m3h3x8(:,44),heltab2x24(:,:,44))
  Gcoeff(:)%j = (-(c(204)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(45),h0tab(:,45),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(16),m3h3x8(:,45),heltab2x24(:,:,45))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(46),h0tab(:,46),[16,2,1,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(30),m3h3x8(:,46),heltab2x24(:,:,46))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(47),h0tab(:,47),[16,4,2,1,8],[nMB,nMB,nMH,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(17),ngZd,m3h3x8(:,47),heltab2x24(:,:,47))
  call Hloop_Q_A(ntryL,G0H8(17),16,nMB,G1H8(31),n2h8(15))
  Gcoeff(:)%j = (c(88)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(48),h0tab(:,48),[16,4,2,1,8],[nMB,nMB,nMZ,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(17),ngZd,m3h3x8(:,48),heltab2x24(:,:,48))
  call Hloop_Q_A(ntryL,G0H8(17),16,nMB,G1H8(32),n2h8(16))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(49),h0tab(:,49),[16,4,2,1,8],[nMT,nMT,nMW,nMT,nMT],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(17),ngZu,m3h3x8(:,49),heltab2x24(:,:,49))
  call Hloop_Q_A(ntryL,G0H8(17),16,nMT,G1H8(33),n2h8(17))
  Gcoeff(:)%j = (c(243)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(50),h0tab(:,50),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(34),m3h3x8(:,50),heltab2x24(:,:,50))
  Gcoeff(:)%j = (c(208)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(51),h0tab(:,51),[16,4,2,1,8],[nMB,nMB,0,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(17),ngZd,m3h3x8(:,51),heltab2x24(:,:,51))
  call Hloop_Q_A(ntryL,G0H8(17),16,nMB,G1H8(35),n2h8(18))
  Gcoeff(:)%j = (c(209)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(52),h0tab(:,52),[16,4,2,1,8],[nMB,nMB,nMZ,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(17),ngZd,m3h3x8(:,52),heltab2x24(:,:,52))
  call Hloop_Q_A(ntryL,G0H8(17),16,nMB,G1H8(36),n2h8(19))
  Gcoeff(:)%j = (-(c(121)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(53),h0tab(:,53),[16,4,2,1,8],[nMT,nMT,nMW,nMT,nMT],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(17),ngZu,m3h3x8(:,53),heltab2x24(:,:,53))
  call Hloop_Q_A(ntryL,G0H8(17),16,nMT,G1H8(37),n2h8(20))
  Gcoeff(:)%j = (c(210)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(54),h0tab(:,54),[16,4,2,1,8],[nMB,nMB,0,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(17),ngZd,m3h3x8(:,54),heltab2x24(:,:,54))
  call Hloop_Q_A(ntryL,G0H8(17),16,nMB,G1H8(38),n2h8(21))
  Gcoeff(:)%j = (-(c(163)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(55),h0tab(:,55),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(17),m3h3x8(:,55),heltab2x24(:,:,55))
  Gcoeff(:)%j = (c(151)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(56),h0tab(:,56),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(18),m3h3x8(:,56),heltab2x24(:,:,56))
  Gcoeff(:)%j = (c(265)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(57),h0tab(:,57),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(39),m3h3x8(:,57),heltab2x24(:,:,57))
  Gcoeff(:)%j = (-(c(275)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(58),h0tab(:,58),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(40),m3h3x8(:,58),heltab2x24(:,:,58))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(59),h0tab(:,59),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(41),m3h3x8(:,59),heltab2x24(:,:,59))
  Gcoeff(:)%j = (-(c(180)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(60),h0tab(:,60),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(19),m3h3x8(:,60),heltab2x24(:,:,60))
  Gcoeff(:)%j = (c(182)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(61),h0tab(:,61),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(20),m3h3x8(:,61),heltab2x24(:,:,61))
  Gcoeff(:)%j = (-(c(163)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(62),h0tab(:,62),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(21),m3h3x8(:,62),heltab2x24(:,:,62))
  Gcoeff(:)%j = (-(c(180)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(63),h0tab(:,63),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(22),m3h3x8(:,63),heltab2x24(:,:,63))
  Gcoeff(:)%j = (-(c(290)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(64),h0tab(:,64),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(42),m3h3x8(:,64),heltab2x24(:,:,64))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(65),h0tab(:,65),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(43),m3h3x8(:,65),heltab2x24(:,:,65))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(66),h0tab(:,66),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(44),m3h3x8(:,66),heltab2x24(:,:,66))
  Gcoeff(:)%j = (-(c(180)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(67),h0tab(:,67),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(23),m3h3x8(:,67),heltab2x24(:,:,67))
  Gcoeff(:)%j = (-(c(204)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(68),h0tab(:,68),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(24),m3h3x8(:,68),heltab2x24(:,:,68))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(69),h0tab(:,69),[16,4,2,1,8],[nMW,nMW,nMT,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(45),m3h3x8(:,69),heltab2x24(:,:,69))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(70),h0tab(:,70),[16,2,1,8,4],[nMB,nMH,nMB,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(25),ngZd,m3h3x8(:,70),heltab2x24(:,:,70))
  call Hloop_Q_A(ntryL,G0H8(25),16,nMB,G1H8(46),n2h8(22))
  Gcoeff(:)%j = (c(88)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(71),h0tab(:,71),[16,2,1,8,4],[nMB,nMZ,nMB,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(25),ngZd,m3h3x8(:,71),heltab2x24(:,:,71))
  call Hloop_Q_A(ntryL,G0H8(25),16,nMB,G1H8(47),n2h8(23))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(72),h0tab(:,72),[16,2,1,8,4],[nMT,nMW,nMT,nMT,nMT],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(25),ngZu,m3h3x8(:,72),heltab2x24(:,:,72))
  call Hloop_Q_A(ntryL,G0H8(25),16,nMT,G1H8(48),n2h8(24))
  Gcoeff(:)%j = (c(243)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(73),h0tab(:,73),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(49),m3h3x8(:,73),heltab2x24(:,:,73))
  Gcoeff(:)%j = (c(208)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(74),h0tab(:,74),[16,2,1,8,4],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(25),ngZd,m3h3x8(:,74),heltab2x24(:,:,74))
  call Hloop_Q_A(ntryL,G0H8(25),16,nMB,G1H8(50),n2h8(25))
  Gcoeff(:)%j = (c(209)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(75),h0tab(:,75),[16,2,1,8,4],[nMB,nMZ,nMB,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(25),ngZd,m3h3x8(:,75),heltab2x24(:,:,75))
  call Hloop_Q_A(ntryL,G0H8(25),16,nMB,G1H8(51),n2h8(26))
  Gcoeff(:)%j = (-(c(121)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(76),h0tab(:,76),[16,2,1,8,4],[nMT,nMW,nMT,nMT,nMT],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(25),ngZu,m3h3x8(:,76),heltab2x24(:,:,76))
  call Hloop_Q_A(ntryL,G0H8(25),16,nMT,G1H8(52),n2h8(27))
  Gcoeff(:)%j = (c(210)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(77),h0tab(:,77),[16,2,1,8,4],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(25),ngZd,m3h3x8(:,77),heltab2x24(:,:,77))
  call Hloop_Q_A(ntryL,G0H8(25),16,nMB,G1H8(53),n2h8(28))
  Gcoeff(:)%j = (-(c(151)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(78),h0tab(:,78),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(25),m3h3x8(:,78),heltab2x24(:,:,78))
  Gcoeff(:)%j = (c(265)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(79),h0tab(:,79),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(54),m3h3x8(:,79),heltab2x24(:,:,79))
  Gcoeff(:)%j = (c(163)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(80),h0tab(:,80),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(26),m3h3x8(:,80),heltab2x24(:,:,80))
  Gcoeff(:)%j = (-(c(275)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(81),h0tab(:,81),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(55),m3h3x8(:,81),heltab2x24(:,:,81))
  Gcoeff(:)%j = (-(c(182)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(82),h0tab(:,82),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(27),m3h3x8(:,82),heltab2x24(:,:,82))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(83),h0tab(:,83),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(56),m3h3x8(:,83),heltab2x24(:,:,83))
  Gcoeff(:)%j = (c(180)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(84),h0tab(:,84),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(28),m3h3x8(:,84),heltab2x24(:,:,84))
  Gcoeff(:)%j = (c(180)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(85),h0tab(:,85),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(29),m3h3x8(:,85),heltab2x24(:,:,85))
  Gcoeff(:)%j = (c(265)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(86),h0tab(:,86),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(57),m3h3x8(:,86),heltab2x24(:,:,86))
  Gcoeff(:)%j = (-(c(196)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(87),h0tab(:,87),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(30),m3h3x8(:,87),heltab2x24(:,:,87))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(88),h0tab(:,88),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(58),m3h3x8(:,88),heltab2x24(:,:,88))
  Gcoeff(:)%j = (-(c(182)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(89),h0tab(:,89),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(31),m3h3x8(:,89),heltab2x24(:,:,89))
  Gcoeff(:)%j = (c(69)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(90),h0tab(:,90),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(59),m3h3x8(:,90),heltab2x24(:,:,90))
  Gcoeff(:)%j = (c(180)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(91),h0tab(:,91),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(32),m3h3x8(:,91),heltab2x24(:,:,91))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(92),h0tab(:,92),[16,2,1,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(60),m3h3x8(:,92),heltab2x24(:,:,92))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(93),h0tab(:,93),[16,1,2,4,8],[nMB,nMH,nMB,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(33),ngZd,m3h3x8(:,93),heltab2x24(:,:,93))
  call Hloop_A_Q(ntryL,G0H8(33),16,nMB,G1H8(61),n2h8(29))
  Gcoeff(:)%j = (c(88)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(94),h0tab(:,94),[16,1,2,4,8],[nMB,nMZ,nMB,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(33),ngZd,m3h3x8(:,94),heltab2x24(:,:,94))
  call Hloop_A_Q(ntryL,G0H8(33),16,nMB,G1H8(62),n2h8(30))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(95),h0tab(:,95),[16,1,2,4,8],[nMT,nMW,nMT,nMT,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(33),ngZu,m3h3x8(:,95),heltab2x24(:,:,95))
  call Hloop_A_Q(ntryL,G0H8(33),16,nMT,G1H8(63),n2h8(31))
  Gcoeff(:)%j = (c(243)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(96),h0tab(:,96),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(64),m3h3x8(:,96),heltab2x24(:,:,96))
  Gcoeff(:)%j = (c(208)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(97),h0tab(:,97),[16,1,2,4,8],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(33),ngZd,m3h3x8(:,97),heltab2x24(:,:,97))
  call Hloop_A_Q(ntryL,G0H8(33),16,nMB,G1H8(65),n2h8(32))
  Gcoeff(:)%j = (c(209)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(98),h0tab(:,98),[16,1,2,4,8],[nMB,nMZ,nMB,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(33),ngZd,m3h3x8(:,98),heltab2x24(:,:,98))
  call Hloop_A_Q(ntryL,G0H8(33),16,nMB,G1H8(66),n2h8(33))
  Gcoeff(:)%j = (-(c(121)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(99),h0tab(:,99),[16,1,2,4,8],[nMT,nMW,nMT,nMT,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(33),ngZu,m3h3x8(:,99),heltab2x24(:,:,99))
  call Hloop_A_Q(ntryL,G0H8(33),16,nMT,G1H8(67),n2h8(34))
  Gcoeff(:)%j = (c(210)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(100),h0tab(:,100),[16,1,2,4,8],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(33),ngZd,m3h3x8(:,100),heltab2x24(:,:,100))
  call Hloop_A_Q(ntryL,G0H8(33),16,nMB,G1H8(68),n2h8(35))
  Gcoeff(:)%j = (-(c(163)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(101),h0tab(:,101),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(33),m3h3x8(:,101),heltab2x24(:,:,101))
  Gcoeff(:)%j = (c(265)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(102),h0tab(:,102),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(69),m3h3x8(:,102),heltab2x24(:,:,102))
  Gcoeff(:)%j = (c(265)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(103),h0tab(:,103),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(70),m3h3x8(:,103),heltab2x24(:,:,103))
  Gcoeff(:)%j = (-(c(163)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(104),h0tab(:,104),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(34),m3h3x8(:,104),heltab2x24(:,:,104))
  Gcoeff(:)%j = (c(151)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(105),h0tab(:,105),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(35),m3h3x8(:,105),heltab2x24(:,:,105))
  Gcoeff(:)%j = (-(c(180)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(106),h0tab(:,106),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(36),m3h3x8(:,106),heltab2x24(:,:,106))
  Gcoeff(:)%j = (c(292)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(107),h0tab(:,107),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(71),m3h3x8(:,107),heltab2x24(:,:,107))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(108),h0tab(:,108),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(72),m3h3x8(:,108),heltab2x24(:,:,108))
  Gcoeff(:)%j = (-(c(180)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(109),h0tab(:,109),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(37),m3h3x8(:,109),heltab2x24(:,:,109))
  Gcoeff(:)%j = (-(c(180)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(110),h0tab(:,110),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(38),m3h3x8(:,110),heltab2x24(:,:,110))
  Gcoeff(:)%j = (c(182)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(111),h0tab(:,111),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(39),m3h3x8(:,111),heltab2x24(:,:,111))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(112),h0tab(:,112),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(73),m3h3x8(:,112),heltab2x24(:,:,112))
  Gcoeff(:)%j = (c(69)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(113),h0tab(:,113),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(74),m3h3x8(:,113),heltab2x24(:,:,113))
  Gcoeff(:)%j = (-(c(204)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(114),h0tab(:,114),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(40),m3h3x8(:,114),heltab2x24(:,:,114))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(115),h0tab(:,115),[16,1,2,4,8],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(75),m3h3x8(:,115),heltab2x24(:,:,115))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(116),h0tab(:,116),[16,1,2,8,4],[nMB,nMH,nMB,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(41),ngZd,m3h3x8(:,116),heltab2x24(:,:,116))
  call Hloop_A_Q(ntryL,G0H8(41),16,nMB,G1H8(76),n2h8(36))
  Gcoeff(:)%j = (c(88)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(117),h0tab(:,117),[16,1,2,8,4],[nMB,nMZ,nMB,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(41),ngZd,m3h3x8(:,117),heltab2x24(:,:,117))
  call Hloop_A_Q(ntryL,G0H8(41),16,nMB,G1H8(77),n2h8(37))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(118),h0tab(:,118),[16,1,2,8,4],[nMT,nMW,nMT,nMT,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(41),ngZu,m3h3x8(:,118),heltab2x24(:,:,118))
  call Hloop_A_Q(ntryL,G0H8(41),16,nMT,G1H8(78),n2h8(38))
  Gcoeff(:)%j = (c(243)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(119),h0tab(:,119),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(79),m3h3x8(:,119),heltab2x24(:,:,119))
  Gcoeff(:)%j = (c(208)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(120),h0tab(:,120),[16,1,2,8,4],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(41),ngZd,m3h3x8(:,120),heltab2x24(:,:,120))
  call Hloop_A_Q(ntryL,G0H8(41),16,nMB,G1H8(80),n2h8(39))
  Gcoeff(:)%j = (c(209)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(121),h0tab(:,121),[16,1,2,8,4],[nMB,nMZ,nMB,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(41),ngZd,m3h3x8(:,121),heltab2x24(:,:,121))
  call Hloop_A_Q(ntryL,G0H8(41),16,nMB,G1H8(81),n2h8(40))
  Gcoeff(:)%j = (-(c(121)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(122),h0tab(:,122),[16,1,2,8,4],[nMT,nMW,nMT,nMT,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(41),ngZu,m3h3x8(:,122),heltab2x24(:,:,122))
  call Hloop_A_Q(ntryL,G0H8(41),16,nMT,G1H8(82),n2h8(41))
  Gcoeff(:)%j = (c(210)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(123),h0tab(:,123),[16,1,2,8,4],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(41),ngZd,m3h3x8(:,123),heltab2x24(:,:,123))
  call Hloop_A_Q(ntryL,G0H8(41),16,nMB,G1H8(83),n2h8(42))
  Gcoeff(:)%j = (c(151)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(124),h0tab(:,124),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(41),m3h3x8(:,124),heltab2x24(:,:,124))
  Gcoeff(:)%j = (-(c(265)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(125),h0tab(:,125),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(84),m3h3x8(:,125),heltab2x24(:,:,125))
  Gcoeff(:)%j = (c(275)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(126),h0tab(:,126),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(85),m3h3x8(:,126),heltab2x24(:,:,126))
  Gcoeff(:)%j = (-(c(163)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(127),h0tab(:,127),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(42),m3h3x8(:,127),heltab2x24(:,:,127))
  Gcoeff(:)%j = (-(c(182)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(128),h0tab(:,128),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(43),m3h3x8(:,128),heltab2x24(:,:,128))
  Gcoeff(:)%j = (c(180)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(129),h0tab(:,129),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(44),m3h3x8(:,129),heltab2x24(:,:,129))
  Gcoeff(:)%j = (c(265)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(130),h0tab(:,130),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(86),m3h3x8(:,130),heltab2x24(:,:,130))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(131),h0tab(:,131),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(87),m3h3x8(:,131),heltab2x24(:,:,131))
  Gcoeff(:)%j = (c(180)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(132),h0tab(:,132),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(45),m3h3x8(:,132),heltab2x24(:,:,132))
  Gcoeff(:)%j = (-(c(196)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(133),h0tab(:,133),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(46),m3h3x8(:,133),heltab2x24(:,:,133))
  Gcoeff(:)%j = (c(182)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(134),h0tab(:,134),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(47),m3h3x8(:,134),heltab2x24(:,:,134))
  Gcoeff(:)%j = (c(71)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(135),h0tab(:,135),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(88),m3h3x8(:,135),heltab2x24(:,:,135))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(136),h0tab(:,136),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(89),m3h3x8(:,136),heltab2x24(:,:,136))
  Gcoeff(:)%j = (-(c(180)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(137),h0tab(:,137),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(48),m3h3x8(:,137),heltab2x24(:,:,137))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(138),h0tab(:,138),[16,1,2,8,4],[nMW,nMT,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(90),m3h3x8(:,138),heltab2x24(:,:,138))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(139),h0tab(:,139),[16,2,4,1,8],[nMB,nMH,nMH,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(49),ngZd,m3h3x8(:,139),heltab2x24(:,:,139))
  call Hloop_Q_A(ntryL,G0H8(49),16,nMB,G1H8(91),n2h8(43))
  Gcoeff(:)%j = (c(93)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(140),h0tab(:,140),[16,2,4,1,8],[nMB,nMZ,nMZ,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(49),ngZd,m3h3x8(:,140),heltab2x24(:,:,140))
  call Hloop_Q_A(ntryL,G0H8(49),16,nMB,G1H8(92),n2h8(44))
  Gcoeff(:)%j = (-(c(90)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(141),h0tab(:,141),[16,2,4,1,8],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(49),ngZu,m3h3x8(:,141),heltab2x24(:,:,141))
  call Hloop_Q_A(ntryL,G0H8(49),16,nMT,G1H8(93),n2h8(45))
  Gcoeff(:)%j = (c(257)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(142),h0tab(:,142),[16,2,4,1,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(94),m3h3x8(:,142),heltab2x24(:,:,142))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(143),h0tab(:,143),[16,2,4,1,8],[nMB,nMZ,nMZ,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(49),ngZd,m3h3x8(:,143),heltab2x24(:,:,143))
  call Hloop_Q_A(ntryL,G0H8(49),16,nMB,G1H8(95),n2h8(46))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(144),h0tab(:,144),[16,2,4,1,8],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(49),ngZu,m3h3x8(:,144),heltab2x24(:,:,144))
  call Hloop_Q_A(ntryL,G0H8(49),16,nMT,G1H8(96),n2h8(47))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(145),h0tab(:,145),[16,2,4,1,8],[nMB,nMZ,nMZ,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(49),ngZd,m3h3x8(:,145),heltab2x24(:,:,145))
  call Hloop_Q_A(ntryL,G0H8(49),16,nMB,G1H8(97),n2h8(48))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(146),h0tab(:,146),[16,2,4,1,8],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(49),ngZu,m3h3x8(:,146),heltab2x24(:,:,146))
  call Hloop_Q_A(ntryL,G0H8(49),16,nMT,G1H8(98),n2h8(49))
  Gcoeff(:)%j = (-(c(172)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(147),h0tab(:,147),[16,2,4,1,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(49),m3h3x8(:,147),heltab2x24(:,:,147))
  Gcoeff(:)%j = (c(172)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(148),h0tab(:,148),[16,2,4,1,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(50),m3h3x8(:,148),heltab2x24(:,:,148))
  Gcoeff(:)%j = (-(c(287)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(149),h0tab(:,149),[16,2,4,1,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(99),m3h3x8(:,149),heltab2x24(:,:,149))
  Gcoeff(:)%j = (c(219)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(150),h0tab(:,150),[16,2,4,1,8],[nMB,nMZ,nMZ,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(51),ngZd,m3h3x8(:,150),heltab2x24(:,:,150))
  call Hloop_Q_A(ntryL,G0H8(51),16,nMB,G1H8(100),n2h8(50))
  Gcoeff(:)%j = (-(c(126)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(151),h0tab(:,151),[16,2,4,1,8],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(51),ngZu,m3h3x8(:,151),heltab2x24(:,:,151))
  call Hloop_Q_A(ntryL,G0H8(51),16,nMT,G1H8(101),n2h8(51))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(152),h0tab(:,152),[16,2,4,1,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(102),m3h3x8(:,152),heltab2x24(:,:,152))
  Gcoeff(:)%j = (-(c(172)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(153),h0tab(:,153),[16,2,4,1,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(51),m3h3x8(:,153),heltab2x24(:,:,153))
  Gcoeff(:)%j = (-(c(201)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(154),h0tab(:,154),[16,2,4,1,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(52),m3h3x8(:,154),heltab2x24(:,:,154))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(155),h0tab(:,155),[16,2,4,1,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(103),m3h3x8(:,155),heltab2x24(:,:,155))
  Gcoeff(:)%j = (-(c(98)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(156),h0tab(:,156),[16,2,8,1,4],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(53),ngZu,m3h3x8(:,156),heltab2x24(:,:,156))
  call Hloop_Q_A(ntryL,G0H8(53),16,nMT,G1H8(104),n2h8(52))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(157),h0tab(:,157),[16,2,8,1,4],[nMZ,nMB,nMB,nMH,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(105),m3h3x8(:,157),heltab2x24(:,:,157))
  Gcoeff(:)%j = (c(22)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(158),h0tab(:,158),[16,2,8,1,4],[nMH,nMB,nMB,nMZ,nMZ],5,0)
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(106),m3h3x8(:,158),heltab2x24(:,:,158))
  Gcoeff(:)%j = (c(242)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(159),h0tab(:,159),[16,2,8,1,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(107),m3h3x8(:,159),heltab2x24(:,:,159))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(160),h0tab(:,160),[16,2,8,1,4],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(53),ngZu,m3h3x8(:,160),heltab2x24(:,:,160))
  call Hloop_Q_A(ntryL,G0H8(53),16,nMT,G1H8(108),n2h8(53))
  Gcoeff(:)%j = (c(122)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(161),h0tab(:,161),[16,2,8,1,4],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(53),ngZu,m3h3x8(:,161),heltab2x24(:,:,161))
  call Hloop_Q_A(ntryL,G0H8(53),16,nMT,G1H8(109),n2h8(54))
  Gcoeff(:)%j = (c(48)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(162),h0tab(:,162),[16,2,8,1,4],[nMH,nMB,nMB,nMZ,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(53),m3h3x8(:,162),heltab2x24(:,:,162))
  Gcoeff(:)%j = (-(c(150)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(163),h0tab(:,163),[16,2,8,1,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(54),m3h3x8(:,163),heltab2x24(:,:,163))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(164),h0tab(:,164),[16,2,8,1,4],[nMZ,nMB,nMB,nMH,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(55),m3h3x8(:,164),heltab2x24(:,:,164))
  Gcoeff(:)%j = (c(162)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(165),h0tab(:,165),[16,2,8,1,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(56),m3h3x8(:,165),heltab2x24(:,:,165))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(166),h0tab(:,166),[16,2,8,1,4],[nMH,nMB,nMB,nMZ,nMZ],5,0)
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(110),m3h3x8(:,166),heltab2x24(:,:,166))
  Gcoeff(:)%j = (c(264)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(167),h0tab(:,167),[16,2,8,1,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(111),m3h3x8(:,167),heltab2x24(:,:,167))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(168),h0tab(:,168),[16,2,8,1,4],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(57),ngZu,m3h3x8(:,168),heltab2x24(:,:,168))
  call Hloop_Q_A(ntryL,G0H8(57),16,nMT,G1H8(112),n2h8(55))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(169),h0tab(:,169),[16,2,8,1,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(113),m3h3x8(:,169),heltab2x24(:,:,169))
  Gcoeff(:)%j = (-(c(142)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(170),h0tab(:,170),[16,2,8,1,4],[nMH,nMB,nMB,nMZ,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(57),m3h3x8(:,170),heltab2x24(:,:,170))
  Gcoeff(:)%j = (-(c(181)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(171),h0tab(:,171),[16,2,8,1,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(58),m3h3x8(:,171),heltab2x24(:,:,171))
  Gcoeff(:)%j = (c(179)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(172),h0tab(:,172),[16,2,8,1,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(59),m3h3x8(:,172),heltab2x24(:,:,172))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(173),h0tab(:,173),[16,2,8,1,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(114),m3h3x8(:,173),heltab2x24(:,:,173))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(174),h0tab(:,174),[16,1,4,2,8],[nMB,nMH,nMH,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(60),ngZd,m3h3x8(:,174),heltab2x24(:,:,174))
  call Hloop_A_Q(ntryL,G0H8(60),16,nMB,G1H8(115),n2h8(56))
  Gcoeff(:)%j = (c(93)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(175),h0tab(:,175),[16,1,4,2,8],[nMB,nMZ,nMZ,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(60),ngZd,m3h3x8(:,175),heltab2x24(:,:,175))
  call Hloop_A_Q(ntryL,G0H8(60),16,nMB,G1H8(116),n2h8(57))
  Gcoeff(:)%j = (-(c(90)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(176),h0tab(:,176),[16,1,4,2,8],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(60),ngZu,m3h3x8(:,176),heltab2x24(:,:,176))
  call Hloop_A_Q(ntryL,G0H8(60),16,nMT,G1H8(117),n2h8(58))
  Gcoeff(:)%j = (c(257)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(177),h0tab(:,177),[16,1,4,2,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(118),m3h3x8(:,177),heltab2x24(:,:,177))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(178),h0tab(:,178),[16,1,4,2,8],[nMB,nMZ,nMZ,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(60),ngZd,m3h3x8(:,178),heltab2x24(:,:,178))
  call Hloop_A_Q(ntryL,G0H8(60),16,nMB,G1H8(119),n2h8(59))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(179),h0tab(:,179),[16,1,4,2,8],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(60),ngZu,m3h3x8(:,179),heltab2x24(:,:,179))
  call Hloop_A_Q(ntryL,G0H8(60),16,nMT,G1H8(120),n2h8(60))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(180),h0tab(:,180),[16,1,4,2,8],[nMB,nMZ,nMZ,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(60),ngZd,m3h3x8(:,180),heltab2x24(:,:,180))
  call Hloop_A_Q(ntryL,G0H8(60),16,nMB,G1H8(121),n2h8(61))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(181),h0tab(:,181),[16,1,4,2,8],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(60),ngZu,m3h3x8(:,181),heltab2x24(:,:,181))
  call Hloop_A_Q(ntryL,G0H8(60),16,nMT,G1H8(122),n2h8(62))
  Gcoeff(:)%j = (-(c(172)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(182),h0tab(:,182),[16,1,4,2,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(60),m3h3x8(:,182),heltab2x24(:,:,182))
  Gcoeff(:)%j = (c(287)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(183),h0tab(:,183),[16,1,4,2,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(123),m3h3x8(:,183),heltab2x24(:,:,183))
  Gcoeff(:)%j = (-(c(172)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(184),h0tab(:,184),[16,1,4,2,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(61),m3h3x8(:,184),heltab2x24(:,:,184))
  Gcoeff(:)%j = (c(219)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(185),h0tab(:,185),[16,1,4,2,8],[nMB,nMZ,nMZ,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(62),ngZd,m3h3x8(:,185),heltab2x24(:,:,185))
  call Hloop_A_Q(ntryL,G0H8(62),16,nMB,G1H8(124),n2h8(63))
  Gcoeff(:)%j = (-(c(126)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(186),h0tab(:,186),[16,1,4,2,8],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(62),ngZu,m3h3x8(:,186),heltab2x24(:,:,186))
  call Hloop_A_Q(ntryL,G0H8(62),16,nMT,G1H8(125),n2h8(64))
  Gcoeff(:)%j = (c(172)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(187),h0tab(:,187),[16,1,4,2,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(62),m3h3x8(:,187),heltab2x24(:,:,187))
  Gcoeff(:)%j = (c(63)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(188),h0tab(:,188),[16,1,4,2,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(126),m3h3x8(:,188),heltab2x24(:,:,188))
  Gcoeff(:)%j = (-(c(201)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(189),h0tab(:,189),[16,1,4,2,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(63),m3h3x8(:,189),heltab2x24(:,:,189))
  Gcoeff(:)%j = (-(c(63)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(190),h0tab(:,190),[16,1,4,2,8],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(127),m3h3x8(:,190),heltab2x24(:,:,190))
  Gcoeff(:)%j = (c(19)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(191),h0tab(:,191),[16,1,4,8,2],[nMH,nMB,nMB,nMB,nMZ],5,0)
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(128),m3h3x8(:,191),heltab2x24(:,:,191))
  Gcoeff(:)%j = (c(19)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(192),h0tab(:,192),[16,1,4,8,2],[nMZ,nMB,nMB,nMB,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(129),m3h3x8(:,192),heltab2x24(:,:,192))
  Gcoeff(:)%j = (c(256)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(193),h0tab(:,193),[16,1,4,8,2],[nMW,nMT,nMT,nMT,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(130),m3h3x8(:,193),heltab2x24(:,:,193))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(194),h0tab(:,194),[16,1,4,8,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(64),ngZu,m3h3x8(:,194),heltab2x24(:,:,194))
  call Hloop_A_Q(ntryL,G0H8(64),16,nMT,G1H8(131),n2h8(65))
  Gcoeff(:)%j = (-(c(112)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(195),h0tab(:,195),[16,1,4,8,2],[nMH,nMB,nMB,nMB,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(64),m3h3x8(:,195),heltab2x24(:,:,195))
  Gcoeff(:)%j = (c(171)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(196),h0tab(:,196),[16,1,4,8,2],[nMW,nMT,nMT,nMT,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(65),m3h3x8(:,196),heltab2x24(:,:,196))
  Gcoeff(:)%j = (-(c(112)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(197),h0tab(:,197),[16,1,4,8,2],[nMZ,nMB,nMB,nMB,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(66),m3h3x8(:,197),heltab2x24(:,:,197))
  Gcoeff(:)%j = (-(c(171)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(198),h0tab(:,198),[16,1,4,8,2],[nMW,nMT,nMT,nMT,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(67),m3h3x8(:,198),heltab2x24(:,:,198))
  Gcoeff(:)%j = (c(101)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(199),h0tab(:,199),[16,1,4,8,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(68),ngZu,m3h3x8(:,199),heltab2x24(:,:,199))
  call Hloop_A_Q(ntryL,G0H8(68),16,nMT,G1H8(132),n2h8(66))
  Gcoeff(:)%j = (-(c(113)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(200),h0tab(:,200),[16,1,4,8,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(68),ngZu,m3h3x8(:,200),heltab2x24(:,:,200))
  call Hloop_A_Q(ntryL,G0H8(68),16,nMT,G1H8(133),n2h8(67))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(201),h0tab(:,201),[16,1,4,8,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(68),ngZu,m3h3x8(:,201),heltab2x24(:,:,201))
  call Hloop_A_Q(ntryL,G0H8(68),16,nMT,G1H8(134),n2h8(68))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(202),h0tab(:,202),[16,1,4,8,2],[nMW,nMT,nMT,nMT,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(135),m3h3x8(:,202),heltab2x24(:,:,202))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(203),h0tab(:,203),[16,1,4,8,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(68),ngZu,m3h3x8(:,203),heltab2x24(:,:,203))
  call Hloop_A_Q(ntryL,G0H8(68),16,nMT,G1H8(136),n2h8(69))
  Gcoeff(:)%j = (c(127)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(204),h0tab(:,204),[16,1,4,8,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(68),ngZu,m3h3x8(:,204),heltab2x24(:,:,204))
  call Hloop_A_Q(ntryL,G0H8(68),16,nMT,G1H8(137),n2h8(70))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(205),h0tab(:,205),[16,1,4,8,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(68),ngZu,m3h3x8(:,205),heltab2x24(:,:,205))
  call Hloop_A_Q(ntryL,G0H8(68),16,nMT,G1H8(138),n2h8(71))
  Gcoeff(:)%j = (-(c(127)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(206),h0tab(:,206),[16,1,4,8,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(68),ngZu,m3h3x8(:,206),heltab2x24(:,:,206))
  call Hloop_A_Q(ntryL,G0H8(68),16,nMT,G1H8(139),n2h8(72))
  Gcoeff(:)%j = (-(c(98)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(207),h0tab(:,207),[16,1,8,2,4],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(68),ngZu,m3h3x8(:,207),heltab2x24(:,:,207))
  call Hloop_A_Q(ntryL,G0H8(68),16,nMT,G1H8(140),n2h8(73))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(208),h0tab(:,208),[16,1,8,2,4],[nMZ,nMB,nMB,nMH,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(141),m3h3x8(:,208),heltab2x24(:,:,208))
  Gcoeff(:)%j = (c(22)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(209),h0tab(:,209),[16,1,8,2,4],[nMH,nMB,nMB,nMZ,nMZ],5,0)
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(142),m3h3x8(:,209),heltab2x24(:,:,209))
  Gcoeff(:)%j = (c(242)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(210),h0tab(:,210),[16,1,8,2,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(143),m3h3x8(:,210),heltab2x24(:,:,210))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(211),h0tab(:,211),[16,1,8,2,4],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(68),ngZu,m3h3x8(:,211),heltab2x24(:,:,211))
  call Hloop_A_Q(ntryL,G0H8(68),16,nMT,G1H8(144),n2h8(74))
  Gcoeff(:)%j = (c(122)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(212),h0tab(:,212),[16,1,8,2,4],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(68),ngZu,m3h3x8(:,212),heltab2x24(:,:,212))
  call Hloop_A_Q(ntryL,G0H8(68),16,nMT,G1H8(145),n2h8(75))
  Gcoeff(:)%j = (c(48)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(213),h0tab(:,213),[16,1,8,2,4],[nMH,nMB,nMB,nMZ,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(68),m3h3x8(:,213),heltab2x24(:,:,213))
  Gcoeff(:)%j = (c(150)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(214),h0tab(:,214),[16,1,8,2,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(69),m3h3x8(:,214),heltab2x24(:,:,214))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(215),h0tab(:,215),[16,1,8,2,4],[nMH,nMB,nMB,nMZ,nMZ],5,0)
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(146),m3h3x8(:,215),heltab2x24(:,:,215))
  Gcoeff(:)%j = (c(264)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(216),h0tab(:,216),[16,1,8,2,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(147),m3h3x8(:,216),heltab2x24(:,:,216))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(217),h0tab(:,217),[16,1,8,2,4],[nMZ,nMB,nMB,nMH,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(70),m3h3x8(:,217),heltab2x24(:,:,217))
  Gcoeff(:)%j = (-(c(162)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(218),h0tab(:,218),[16,1,8,2,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(71),m3h3x8(:,218),heltab2x24(:,:,218))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(219),h0tab(:,219),[16,1,8,2,4],[nMT,nMW,nMW,nMT,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(72),ngZu,m3h3x8(:,219),heltab2x24(:,:,219))
  call Hloop_A_Q(ntryL,G0H8(72),16,nMT,G1H8(148),n2h8(76))
  Gcoeff(:)%j = (-(c(142)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(220),h0tab(:,220),[16,1,8,2,4],[nMH,nMB,nMB,nMZ,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(72),m3h3x8(:,220),heltab2x24(:,:,220))
  Gcoeff(:)%j = (c(181)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(221),h0tab(:,221),[16,1,8,2,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(73),m3h3x8(:,221),heltab2x24(:,:,221))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(222),h0tab(:,222),[16,1,8,2,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(149),m3h3x8(:,222),heltab2x24(:,:,222))
  Gcoeff(:)%j = (-(c(179)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(223),h0tab(:,223),[16,1,8,2,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(74),m3h3x8(:,223),heltab2x24(:,:,223))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(224),h0tab(:,224),[16,1,8,2,4],[nMW,nMT,nMT,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(150),m3h3x8(:,224),heltab2x24(:,:,224))
  Gcoeff(:)%j = (c(19)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(225),h0tab(:,225),[16,1,8,4,2],[nMH,nMB,nMB,nMB,nMZ],5,0)
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(151),m3h3x8(:,225),heltab2x24(:,:,225))
  Gcoeff(:)%j = (c(19)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(226),h0tab(:,226),[16,1,8,4,2],[nMZ,nMB,nMB,nMB,nMH],5,0)
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(152),m3h3x8(:,226),heltab2x24(:,:,226))
  Gcoeff(:)%j = (c(256)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(227),h0tab(:,227),[16,1,8,4,2],[nMW,nMT,nMT,nMT,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(153),m3h3x8(:,227),heltab2x24(:,:,227))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(228),h0tab(:,228),[16,1,8,4,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(75),ngZu,m3h3x8(:,228),heltab2x24(:,:,228))
  call Hloop_A_Q(ntryL,G0H8(75),16,nMT,G1H8(154),n2h8(77))
  Gcoeff(:)%j = (-(c(112)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(229),h0tab(:,229),[16,1,8,4,2],[nMH,nMB,nMB,nMB,nMZ],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(75),m3h3x8(:,229),heltab2x24(:,:,229))
  Gcoeff(:)%j = (c(171)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(230),h0tab(:,230),[16,1,8,4,2],[nMW,nMT,nMT,nMT,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(76),m3h3x8(:,230),heltab2x24(:,:,230))
  Gcoeff(:)%j = (-(c(112)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(231),h0tab(:,231),[16,1,8,4,2],[nMZ,nMB,nMB,nMB,nMH],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(77),m3h3x8(:,231),heltab2x24(:,:,231))
  Gcoeff(:)%j = (-(c(171)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(232),h0tab(:,232),[16,1,8,4,2],[nMW,nMT,nMT,nMT,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(78),m3h3x8(:,232),heltab2x24(:,:,232))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(233),h0tab(:,233),[16,1,8,4,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(79),ngZu,m3h3x8(:,233),heltab2x24(:,:,233))
  call Hloop_A_Q(ntryL,G0H8(79),16,nMT,G1H8(155),n2h8(78))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(234),h0tab(:,234),[16,1,8,4,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(79),ngZu,m3h3x8(:,234),heltab2x24(:,:,234))
  call Hloop_A_Q(ntryL,G0H8(79),16,nMT,G1H8(156),n2h8(79))
  Gcoeff(:)%j = (c(113)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(235),h0tab(:,235),[16,1,8,4,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(79),ngZu,m3h3x8(:,235),heltab2x24(:,:,235))
  call Hloop_A_Q(ntryL,G0H8(79),16,nMT,G1H8(157),n2h8(80))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(236),h0tab(:,236),[16,1,8,4,2],[nMW,nMT,nMT,nMT,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(158),m3h3x8(:,236),heltab2x24(:,:,236))
  Gcoeff(:)%j = (-(c(127)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(237),h0tab(:,237),[16,1,8,4,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(79),ngZu,m3h3x8(:,237),heltab2x24(:,:,237))
  call Hloop_A_Q(ntryL,G0H8(79),16,nMT,G1H8(159),n2h8(81))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(238),h0tab(:,238),[16,1,8,4,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(79),ngZu,m3h3x8(:,238),heltab2x24(:,:,238))
  call Hloop_A_Q(ntryL,G0H8(79),16,nMT,G1H8(160),n2h8(82))
  Gcoeff(:)%j = (c(125)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(239),h0tab(:,239),[16,1,8,4,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(79),ngZu,m3h3x8(:,239),heltab2x24(:,:,239))
  call Hloop_A_Q(ntryL,G0H8(79),16,nMT,G1H8(161),n2h8(83))
  Gcoeff(:)%j = (-(c(127)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(240),h0tab(:,240),[16,1,8,4,2],[nMT,nMW,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(79),ngZu,m3h3x8(:,240),heltab2x24(:,:,240))
  call Hloop_A_Q(ntryL,G0H8(79),16,nMT,G1H8(162),n2h8(84))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(8),[G1H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(23),[G1H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(38),[G1H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(53),[G1H8(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(68),[G1H8(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(83),[G1H8(80)])
  call Hloop_AS_Q(ntryL,G1H8(1),ex3(:),G1H8(5),ngH,m3h1x8(:,1),heltab2x8(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(5),20,nMB,G2H8(1),n2h8(85))
  call Hloop_AS_Q(ntryL,G1H8(2),ex3(:),G1H8(20),ngH,m3h1x8(:,2),heltab2x8(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(20),20,nMB,G2H8(2),n2h8(86))
  call Hloop_AS_Q(ntryL,G1H8(3),ex3(:),G1H8(35),ngH,m3h1x8(:,3),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(35),20,nMT,G2H8(3),n2h8(87))
  call Hloop_SS_S(ntryL,G1H8(4),ex3(:),G1H8(50),m3h1x8(:,4),heltab2x8(:,:,4))
  call Hloop_AS_Q(ntryL,G1H8(8),ex3(:),G1H8(65),ngH,m3h1x8(:,5),heltab2x8(:,:,5))
  call Hloop_A_Q(ntryL,G1H8(65),20,nMB,G2H8(4),n2h8(88))
  call Hloop_AS_Q(ntryL,G1H8(6),ex3(:),G1H8(80),ngH,m3h1x8(:,6),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G1H8(80),20,nMB,G2H8(5),n2h8(89))
  call Hloop_AS_Q(ntryL,G1H8(7),ex3(:),G1H8(1),ngH,m3h1x8(:,7),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(6),n2h8(90))
  call Hloop_SS_S(ntryL,G0H8(1),ex3(:),G0H8(79),m3h1x8(:,8),heltab2x8(:,:,8))
  call Hloop_VT_S(ntryL,G0H8(2),16,ex3(:),4,G1H8(5),m3h1x8(:,9),heltab2x8(:,:,9))
  call Hloop_SS_S(ntryL,G1H8(9),ex3(:),G1H8(2),m3h1x8(:,10),heltab2x8(:,:,10))
  call Hloop_ST_V(ntryL,G1H8(10),16,ex3(:),4,G2H8(7),m3h1x8(:,11),heltab2x8(:,:,11))
  call Hloop_VT_S(ntryL,G1H8(11),16,ex3(:),4,G2H8(8),m3h1x8(:,12),heltab2x8(:,:,12))
  call Hloop_SS_S(ntryL,G0H8(3),ex3(:),G0H8(1),m3h1x8(:,13),heltab2x8(:,:,13))
  call Hloop_VT_S(ntryL,G0H8(4),16,ex3(:),4,G1H8(20),m3h1x8(:,14),heltab2x8(:,:,14))
  call Hloop_ST_V(ntryL,G0H8(5),16,ex3(:),4,G1H8(3),m3h1x8(:,15),heltab2x8(:,:,15))
  call Hloop_VS_V(ntryL,G0H8(6),ex3(:),G0H8(2),m3h1x8(:,16),heltab2x8(:,:,16))
  call Hloop_ST_V(ntryL,G1H8(12),16,ex3(:),4,G2H8(9),m3h1x8(:,17),heltab2x8(:,:,17))
  call Hloop_VT_S(ntryL,G1H8(13),16,ex3(:),4,G2H8(10),m3h1x8(:,18),heltab2x8(:,:,18))
  call Hloop_VS_V(ntryL,G1H8(14),ex3(:),G1H8(35),m3h1x8(:,19),heltab2x8(:,:,19))
  call Hloop_ST_V(ntryL,G0H8(7),16,ex3(:),4,G1H8(4),m3h1x8(:,20),heltab2x8(:,:,20))
  call Hloop_VS_V(ntryL,G0H8(8),ex3(:),G0H8(3),m3h1x8(:,21),heltab2x8(:,:,21))
  call Hloop_VS_V(ntryL,G1H8(15),ex3(:),G1H8(8),m3h1x8(:,22),heltab2x8(:,:,22))
  call Hloop_QA_S(ntryL,G1H8(16),ex2(:),G1H4(1),ngH,m3h2x4(:,1),heltab2x8(:,:,23))
  call Hloop_QA_S(ntryL,G1H8(17),ex2(:),G1H4(2),ngX,m3h2x4(:,2),heltab2x8(:,:,24))
  call Hloop_QA_S(ntryL,G1H8(18),ex2(:),G1H4(3),ngPbt,m3h2x4(:,3),heltab2x8(:,:,25))
  call Hloop_SA_Q(ntryL,G1H8(19),ex2(:),G1H4(4),ngPbt,m3h2x4(:,4),heltab2x8(:,:,26))
  call Hloop_A_Q(ntryL,G1H4(4),18,nMT,G2H4(1),n2h4(1))
  call Hloop_QA_V(ntryL,G1H8(23),ex2(:),G1H4(4),m3h2x4(:,5),heltab2x8(:,:,27))
  call Hloop_QA_Z(ntryL,G1H8(21),ex2(:),G1H4(5),ngZd,m3h2x4(:,6),heltab2x8(:,:,28))
  call Hloop_QA_W(ntryL,G1H8(22),ex2(:),G1H4(6),m3h2x4(:,7),heltab2x8(:,:,29))
  call Hloop_SA_Q(ntryL,G0H8(9),ex2(:),G0H4(1),ngPbt,m3h2x4(:,8),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMT,G1H4(7),n2h4(2))
  call Hloop_SA_Q(ntryL,G1H8(24),ex2(:),G1H4(8),ngPbt,m3h2x4(:,9),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G1H4(8),18,nMT,G2H4(2),n2h4(3))
  call Hloop_WA_Q(ntryL,G0H8(10),ex2(:),G0H4(1),m3h2x4(:,10),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMT,G1H4(8),n2h4(4))
  call Hloop_SA_Q(ntryL,G1H8(25),ex2(:),G1H4(9),ngPbt,m3h2x4(:,11),heltab2x8(:,:,33))
  call Hloop_A_Q(ntryL,G1H4(9),18,nMT,G2H4(3),n2h4(5))
  call Hloop_SA_Q(ntryL,G0H8(11),ex2(:),G0H4(1),ngPbt,m3h2x4(:,12),heltab2x8(:,:,34))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMT,G1H4(9),n2h4(6))
  call Hloop_WA_Q(ntryL,G1H8(26),ex2(:),G1H4(10),m3h2x4(:,13),heltab2x8(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(10),18,nMT,G2H4(4),n2h4(7))
  call Hloop_WA_Q(ntryL,G0H8(12),ex2(:),G0H4(1),m3h2x4(:,14),heltab2x8(:,:,36))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMT,G1H4(10),n2h4(8))
  call Hloop_SA_Q(ntryL,G0H8(13),ex2(:),G0H4(1),ngPbt,m3h2x4(:,15),heltab2x8(:,:,37))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMT,G1H4(11),n2h4(9))
  call Hloop_SA_Q(ntryL,G1H8(27),ex2(:),G1H4(12),ngPbt,m3h2x4(:,16),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G1H4(12),18,nMT,G2H4(5),n2h4(10))
  call Hloop_WA_Q(ntryL,G0H8(14),ex2(:),G0H4(1),m3h2x4(:,17),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMT,G1H4(12),n2h4(11))
  call Hloop_WA_Q(ntryL,G1H8(28),ex2(:),G1H4(13),m3h2x4(:,18),heltab2x8(:,:,40))
  call Hloop_A_Q(ntryL,G1H4(13),18,nMT,G2H4(6),n2h4(12))
  call Hloop_SA_Q(ntryL,G0H8(15),ex2(:),G0H4(1),ngPbt,m3h2x4(:,19),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMT,G1H4(13),n2h4(13))
  call Hloop_WA_Q(ntryL,G1H8(29),ex2(:),G1H4(14),m3h2x4(:,20),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(14),18,nMT,G2H4(7),n2h4(14))
  call Hloop_WA_Q(ntryL,G0H8(16),ex2(:),G0H4(1),m3h2x4(:,21),heltab2x8(:,:,43))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMT,G1H4(14),n2h4(15))
  call Hloop_WA_Q(ntryL,G1H8(30),ex2(:),G1H4(15),m3h2x4(:,22),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(15),18,nMT,G2H4(8),n2h4(16))
  call Hloop_QS_A(ntryL,G1H8(31),ex3(:),G1H8(65),ngH,m3h1x8(:,23),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G1H8(65),20,nMB,G2H8(11),n2h8(91))
  call Hloop_QS_A(ntryL,G1H8(32),ex3(:),G1H8(6),ngH,m3h1x8(:,24),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G1H8(6),20,nMB,G2H8(12),n2h8(92))
  call Hloop_QS_A(ntryL,G1H8(33),ex3(:),G1H8(80),ngH,m3h1x8(:,25),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H8(80),20,nMT,G2H8(13),n2h8(93))
  call Hloop_SS_S(ntryL,G1H8(34),ex3(:),G1H8(7),m3h1x8(:,26),heltab2x8(:,:,48))
  call Hloop_QS_A(ntryL,G1H8(38),ex3(:),G1H8(1),ngH,m3h1x8(:,27),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMB,G2H8(14),n2h8(94))
  call Hloop_QS_A(ntryL,G1H8(36),ex3(:),G1H8(9),ngH,m3h1x8(:,28),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H8(9),20,nMB,G2H8(15),n2h8(95))
  call Hloop_QS_A(ntryL,G1H8(37),ex3(:),G1H8(10),ngH,m3h1x8(:,29),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H8(10),20,nMT,G2H8(16),n2h8(96))
  call Hloop_SS_S(ntryL,G0H8(17),ex3(:),G0H8(4),m3h1x8(:,30),heltab2x8(:,:,52))
  call Hloop_VT_S(ntryL,G0H8(18),16,ex3(:),4,G1H8(11),m3h1x8(:,31),heltab2x8(:,:,53))
  call Hloop_ST_V(ntryL,G1H8(39),16,ex3(:),4,G2H8(17),m3h1x8(:,32),heltab2x8(:,:,54))
  call Hloop_SS_S(ntryL,G1H8(40),ex3(:),G1H8(12),m3h1x8(:,33),heltab2x8(:,:,55))
  call Hloop_VT_S(ntryL,G1H8(41),16,ex3(:),4,G2H8(18),m3h1x8(:,34),heltab2x8(:,:,56))
  call Hloop_ST_V(ntryL,G0H8(19),16,ex3(:),4,G1H8(13),m3h1x8(:,35),heltab2x8(:,:,57))
  call Hloop_VS_V(ntryL,G0H8(20),ex3(:),G0H8(5),m3h1x8(:,36),heltab2x8(:,:,58))
  call Hloop_SS_S(ntryL,G0H8(21),ex3(:),G0H8(6),m3h1x8(:,37),heltab2x8(:,:,59))
  call Hloop_VT_S(ntryL,G0H8(22),16,ex3(:),4,G1H8(14),m3h1x8(:,38),heltab2x8(:,:,60))
  call Hloop_ST_V(ntryL,G1H8(42),16,ex3(:),4,G2H8(19),m3h1x8(:,39),heltab2x8(:,:,61))
  call Hloop_VS_V(ntryL,G1H8(43),ex3(:),G1H8(15),m3h1x8(:,40),heltab2x8(:,:,62))
  call Hloop_VT_S(ntryL,G1H8(44),16,ex3(:),4,G2H8(20),m3h1x8(:,41),heltab2x8(:,:,63))
  call Hloop_ST_V(ntryL,G0H8(23),16,ex3(:),4,G1H8(16),m3h1x8(:,42),heltab2x8(:,:,64))
  call Hloop_VS_V(ntryL,G0H8(24),ex3(:),G0H8(7),m3h1x8(:,43),heltab2x8(:,:,65))
  call Hloop_VS_V(ntryL,G1H8(45),ex3(:),G1H8(17),m3h1x8(:,44),heltab2x8(:,:,66))
  call Hloop_QA_S(ntryL,G1H8(46),ex2(:),G1H4(15),ngH,m3h2x4(:,23),heltab2x8(:,:,67))
  call Hloop_QA_S(ntryL,G1H8(47),ex2(:),G1H4(16),ngX,m3h2x4(:,24),heltab2x8(:,:,68))
  call Hloop_QA_S(ntryL,G1H8(48),ex2(:),G1H4(17),ngPbt,m3h2x4(:,25),heltab2x8(:,:,69))
  call Hloop_SA_Q(ntryL,G1H8(49),ex2(:),G1H4(18),ngPbt,m3h2x4(:,26),heltab2x8(:,:,70))
  call Hloop_A_Q(ntryL,G1H4(18),18,nMT,G2H4(9),n2h4(17))
  call Hloop_QA_V(ntryL,G1H8(53),ex2(:),G1H4(18),m3h2x4(:,27),heltab2x8(:,:,71))
  call Hloop_QA_Z(ntryL,G1H8(51),ex2(:),G1H4(19),ngZd,m3h2x4(:,28),heltab2x8(:,:,72))
  call Hloop_QA_W(ntryL,G1H8(52),ex2(:),G1H4(20),m3h2x4(:,29),heltab2x8(:,:,73))
  call Hloop_SA_Q(ntryL,G0H8(25),ex2(:),G0H4(1),ngPbt,m3h2x4(:,30),heltab2x8(:,:,74))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMT,G1H4(21),n2h4(18))
  call Hloop_SA_Q(ntryL,G1H8(54),ex2(:),G1H4(22),ngPbt,m3h2x4(:,31),heltab2x8(:,:,75))
  call Hloop_A_Q(ntryL,G1H4(22),18,nMT,G2H4(10),n2h4(19))
  call Hloop_WA_Q(ntryL,G0H8(26),ex2(:),G0H4(1),m3h2x4(:,32),heltab2x8(:,:,76))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMT,G1H4(22),n2h4(20))
  call Hloop_SA_Q(ntryL,G1H8(55),ex2(:),G1H4(23),ngPbt,m3h2x4(:,33),heltab2x8(:,:,77))
  call Hloop_A_Q(ntryL,G1H4(23),18,nMT,G2H4(11),n2h4(21))
  call Hloop_SA_Q(ntryL,G0H8(27),ex2(:),G0H4(1),ngPbt,m3h2x4(:,34),heltab2x8(:,:,78))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMT,G1H4(23),n2h4(22))
  call Hloop_WA_Q(ntryL,G1H8(56),ex2(:),G1H4(24),m3h2x4(:,35),heltab2x8(:,:,79))
  call Hloop_A_Q(ntryL,G1H4(24),18,nMT,G2H4(12),n2h4(23))
  call Hloop_WA_Q(ntryL,G0H8(28),ex2(:),G0H4(1),m3h2x4(:,36),heltab2x8(:,:,80))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMT,G1H4(24),n2h4(24))
  call Hloop_SA_Q(ntryL,G0H8(29),ex2(:),G0H4(1),ngPbt,m3h2x4(:,37),heltab2x8(:,:,81))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMT,G1H4(25),n2h4(25))
  call Hloop_SA_Q(ntryL,G1H8(57),ex2(:),G1H4(26),ngPbt,m3h2x4(:,38),heltab2x8(:,:,82))
  call Hloop_A_Q(ntryL,G1H4(26),18,nMT,G2H4(13),n2h4(26))
  call Hloop_WA_Q(ntryL,G0H8(30),ex2(:),G0H4(1),m3h2x4(:,39),heltab2x8(:,:,83))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMT,G1H4(26),n2h4(27))
  call Hloop_WA_Q(ntryL,G1H8(58),ex2(:),G1H4(27),m3h2x4(:,40),heltab2x8(:,:,84))
  call Hloop_A_Q(ntryL,G1H4(27),18,nMT,G2H4(14),n2h4(28))
  call Hloop_SA_Q(ntryL,G0H8(31),ex2(:),G0H4(1),ngPbt,m3h2x4(:,41),heltab2x8(:,:,85))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMT,G1H4(27),n2h4(29))
  call Hloop_WA_Q(ntryL,G1H8(59),ex2(:),G1H4(28),m3h2x4(:,42),heltab2x8(:,:,86))
  call Hloop_A_Q(ntryL,G1H4(28),18,nMT,G2H4(15),n2h4(30))
  call Hloop_WA_Q(ntryL,G0H8(32),ex2(:),G0H4(1),m3h2x4(:,43),heltab2x8(:,:,87))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMT,G1H4(28),n2h4(31))
  call Hloop_WA_Q(ntryL,G1H8(60),ex2(:),G1H4(29),m3h2x4(:,44),heltab2x8(:,:,88))
  call Hloop_A_Q(ntryL,G1H4(29),18,nMT,G2H4(16),n2h4(32))
  call Hloop_AQ_S(ntryL,G1H8(61),ex1(:),G1H4(29),ngH,m3h2x4(:,45),heltab2x8(:,:,89))
  call Hloop_AQ_S(ntryL,G1H8(62),ex1(:),G1H4(30),ngX,m3h2x4(:,46),heltab2x8(:,:,90))
  call Hloop_AQ_S(ntryL,G1H8(63),ex1(:),G1H4(31),ngPtb,m3h2x4(:,47),heltab2x8(:,:,91))
  call Hloop_SQ_A(ntryL,G1H8(64),ex1(:),G1H4(32),ngPtb,m3h2x4(:,48),heltab2x8(:,:,92))
  call Hloop_Q_A(ntryL,G1H4(32),17,nMT,G2H4(17),n2h4(33))
  call Hloop_AQ_V(ntryL,G1H8(68),ex1(:),G1H4(32),m3h2x4(:,49),heltab2x8(:,:,93))
  call Hloop_AQ_Z(ntryL,G1H8(66),ex1(:),G1H4(33),ngZd,m3h2x4(:,50),heltab2x8(:,:,94))
  call Hloop_AQ_W(ntryL,G1H8(67),ex1(:),G1H4(34),m3h2x4(:,51),heltab2x8(:,:,95))
  call Hloop_SQ_A(ntryL,G0H8(33),ex1(:),G0H4(1),ngPtb,m3h2x4(:,52),heltab2x8(:,:,96))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMT,G1H4(35),n2h4(34))
  call Hloop_SQ_A(ntryL,G1H8(69),ex1(:),G1H4(36),ngPtb,m3h2x4(:,53),heltab2x8(:,:,97))
  call Hloop_Q_A(ntryL,G1H4(36),17,nMT,G2H4(18),n2h4(35))
  call Hloop_SQ_A(ntryL,G1H8(70),ex1(:),G1H4(36),ngPtb,m3h2x4(:,54),heltab2x8(:,:,98))
  call Hloop_Q_A(ntryL,G1H4(36),17,nMT,G2H4(19),n2h4(36))
  call Hloop_WQ_A(ntryL,G0H8(34),ex1(:),G0H4(1),m3h2x4(:,55),heltab2x8(:,:,99))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMT,G1H4(36),n2h4(37))
  call Hloop_SQ_A(ntryL,G0H8(35),ex1(:),G0H4(1),ngPtb,m3h2x4(:,56),heltab2x8(:,:,100))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMT,G1H4(37),n2h4(38))
  call Hloop_SQ_A(ntryL,G0H8(36),ex1(:),G0H4(1),ngPtb,m3h2x4(:,57),heltab2x8(:,:,101))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMT,G1H4(38),n2h4(39))
  call Hloop_SQ_A(ntryL,G1H8(71),ex1(:),G1H4(39),ngPtb,m3h2x4(:,58),heltab2x8(:,:,102))
  call Hloop_Q_A(ntryL,G1H4(39),17,nMT,G2H4(20),n2h4(40))
  call Hloop_WQ_A(ntryL,G1H8(72),ex1(:),G1H4(39),m3h2x4(:,59),heltab2x8(:,:,103))
  call Hloop_Q_A(ntryL,G1H4(39),17,nMT,G2H4(21),n2h4(41))
  call Hloop_WQ_A(ntryL,G0H8(37),ex1(:),G0H4(1),m3h2x4(:,60),heltab2x8(:,:,104))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMT,G1H4(39),n2h4(42))
  call Hloop_WQ_A(ntryL,G0H8(38),ex1(:),G0H4(1),m3h2x4(:,61),heltab2x8(:,:,105))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMT,G1H4(40),n2h4(43))
  call Hloop_SQ_A(ntryL,G0H8(39),ex1(:),G0H4(1),ngPtb,m3h2x4(:,62),heltab2x8(:,:,106))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMT,G1H4(41),n2h4(44))
  call Hloop_WQ_A(ntryL,G1H8(73),ex1(:),G1H4(42),m3h2x4(:,63),heltab2x8(:,:,107))
  call Hloop_Q_A(ntryL,G1H4(42),17,nMT,G2H4(22),n2h4(45))
  call Hloop_WQ_A(ntryL,G1H8(74),ex1(:),G1H4(42),m3h2x4(:,64),heltab2x8(:,:,108))
  call Hloop_Q_A(ntryL,G1H4(42),17,nMT,G2H4(23),n2h4(46))
  call Hloop_WQ_A(ntryL,G0H8(40),ex1(:),G0H4(1),m3h2x4(:,65),heltab2x8(:,:,109))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMT,G1H4(42),n2h4(47))
  call Hloop_WQ_A(ntryL,G1H8(75),ex1(:),G1H4(43),m3h2x4(:,66),heltab2x8(:,:,110))
  call Hloop_Q_A(ntryL,G1H4(43),17,nMT,G2H4(24),n2h4(48))
  call Hloop_AQ_S(ntryL,G1H8(76),ex1(:),G1H4(43),ngH,m3h2x4(:,67),heltab2x8(:,:,111))
  call Hloop_AQ_S(ntryL,G1H8(77),ex1(:),G1H4(44),ngX,m3h2x4(:,68),heltab2x8(:,:,112))
  call Hloop_AQ_S(ntryL,G1H8(78),ex1(:),G1H4(45),ngPtb,m3h2x4(:,69),heltab2x8(:,:,113))
  call Hloop_SQ_A(ntryL,G1H8(79),ex1(:),G1H4(46),ngPtb,m3h2x4(:,70),heltab2x8(:,:,114))
  call Hloop_Q_A(ntryL,G1H4(46),17,nMT,G2H4(25),n2h4(49))
  call Hloop_AQ_V(ntryL,G1H8(83),ex1(:),G1H4(46),m3h2x4(:,71),heltab2x8(:,:,115))
  call Hloop_AQ_Z(ntryL,G1H8(81),ex1(:),G1H4(47),ngZd,m3h2x4(:,72),heltab2x8(:,:,116))
  call Hloop_AQ_W(ntryL,G1H8(82),ex1(:),G1H4(48),m3h2x4(:,73),heltab2x8(:,:,117))
  call Hloop_SQ_A(ntryL,G0H8(41),ex1(:),G0H4(1),ngPtb,m3h2x4(:,74),heltab2x8(:,:,118))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMT,G1H4(49),n2h4(50))
  call Hloop_SQ_A(ntryL,G1H8(84),ex1(:),G1H4(50),ngPtb,m3h2x4(:,75),heltab2x8(:,:,119))
  call Hloop_Q_A(ntryL,G1H4(50),17,nMT,G2H4(26),n2h4(51))
  call Hloop_SQ_A(ntryL,G1H8(85),ex1(:),G1H4(50),ngPtb,m3h2x4(:,76),heltab2x8(:,:,120))
  call Hloop_Q_A(ntryL,G1H4(50),17,nMT,G2H4(27),n2h4(52))
  call Hloop_WQ_A(ntryL,G0H8(42),ex1(:),G0H4(1),m3h2x4(:,77),heltab2x8(:,:,121))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMT,G1H4(50),n2h4(53))
  call Hloop_SQ_A(ntryL,G0H8(43),ex1(:),G0H4(1),ngPtb,m3h2x4(:,78),heltab2x8(:,:,122))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMT,G1H4(51),n2h4(54))
  call Hloop_SQ_A(ntryL,G0H8(44),ex1(:),G0H4(1),ngPtb,m3h2x4(:,79),heltab2x8(:,:,123))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMT,G1H4(52),n2h4(55))
  call Hloop_SQ_A(ntryL,G1H8(86),ex1(:),G1H4(53),ngPtb,m3h2x4(:,80),heltab2x8(:,:,124))
  call Hloop_Q_A(ntryL,G1H4(53),17,nMT,G2H4(28),n2h4(56))
  call Hloop_WQ_A(ntryL,G1H8(87),ex1(:),G1H4(53),m3h2x4(:,81),heltab2x8(:,:,125))
  call Hloop_Q_A(ntryL,G1H4(53),17,nMT,G2H4(29),n2h4(57))
  call Hloop_WQ_A(ntryL,G0H8(45),ex1(:),G0H4(1),m3h2x4(:,82),heltab2x8(:,:,126))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMT,G1H4(53),n2h4(58))
  call Hloop_WQ_A(ntryL,G0H8(46),ex1(:),G0H4(1),m3h2x4(:,83),heltab2x8(:,:,127))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMT,G1H4(54),n2h4(59))
  call Hloop_SQ_A(ntryL,G0H8(47),ex1(:),G0H4(1),ngPtb,m3h2x4(:,84),heltab2x8(:,:,128))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMT,G1H4(55),n2h4(60))
  call Hloop_WQ_A(ntryL,G1H8(88),ex1(:),G1H4(56),m3h2x4(:,85),heltab2x8(:,:,129))
  call Hloop_Q_A(ntryL,G1H4(56),17,nMT,G2H4(30),n2h4(61))
  call Hloop_WQ_A(ntryL,G1H8(89),ex1(:),G1H4(56),m3h2x4(:,86),heltab2x8(:,:,130))
  call Hloop_Q_A(ntryL,G1H4(56),17,nMT,G2H4(31),n2h4(62))
  call Hloop_WQ_A(ntryL,G0H8(48),ex1(:),G0H4(1),m3h2x4(:,87),heltab2x8(:,:,131))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMT,G1H4(56),n2h4(63))
  call Hloop_WQ_A(ntryL,G1H8(90),ex1(:),G1H4(57),m3h2x4(:,88),heltab2x8(:,:,132))
  call Hloop_Q_A(ntryL,G1H4(57),17,nMT,G2H4(32),n2h4(64))
  call Hloop_QA_S(ntryL,G1H8(91),ex2(:),G1H4(57),ngH,m3h2x4(:,89),heltab2x8(:,:,133))
  call Hloop_QA_S(ntryL,G1H8(92),ex2(:),G1H4(58),ngX,m3h2x4(:,90),heltab2x8(:,:,134))
  call Hloop_QA_S(ntryL,G1H8(93),ex2(:),G1H4(59),ngPbt,m3h2x4(:,91),heltab2x8(:,:,135))
  call Hloop_SA_Q(ntryL,G1H8(94),ex2(:),G1H4(60),ngPbt,m3h2x4(:,92),heltab2x8(:,:,136))
  call Hloop_A_Q(ntryL,G1H4(60),18,nMT,G2H4(33),n2h4(65))
  call Hloop_QA_Z(ntryL,G1H8(95),ex2(:),G1H4(60),ngZd,m3h2x4(:,93),heltab2x8(:,:,137))
  call Hloop_QA_W(ntryL,G1H8(96),ex2(:),G1H4(61),m3h2x4(:,94),heltab2x8(:,:,138))
  call Hloop_QA_S(ntryL,G1H8(97),ex2(:),G1H4(62),ngX,m3h2x4(:,95),heltab2x8(:,:,139))
  call Hloop_QA_S(ntryL,G1H8(98),ex2(:),G1H4(63),ngPbt,m3h2x4(:,96),heltab2x8(:,:,140))
  call Hloop_SA_Q(ntryL,G0H8(49),ex2(:),G0H4(1),ngPbt,m3h2x4(:,97),heltab2x8(:,:,141))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMT,G1H4(64),n2h4(66))
  call Hloop_WA_Q(ntryL,G0H8(50),ex2(:),G0H4(1),m3h2x4(:,98),heltab2x8(:,:,142))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMT,G1H4(65),n2h4(67))
  call Hloop_SA_Q(ntryL,G1H8(99),ex2(:),G1H4(66),ngPbt,m3h2x4(:,99),heltab2x8(:,:,143))
  call Hloop_A_Q(ntryL,G1H4(66),18,nMT,G2H4(34),n2h4(68))
  call Hloop_QA_Z(ntryL,G1H8(100),ex2(:),G1H4(66),ngZd,m3h2x4(:,100),heltab2x8(:,:,144))
  call Hloop_QA_W(ntryL,G1H8(101),ex2(:),G1H4(67),m3h2x4(:,101),heltab2x8(:,:,145))
  call Hloop_WA_Q(ntryL,G1H8(102),ex2(:),G1H4(68),m3h2x4(:,102),heltab2x8(:,:,146))
  call Hloop_A_Q(ntryL,G1H4(68),18,nMT,G2H4(35),n2h4(69))
  call Hloop_SA_Q(ntryL,G0H8(51),ex2(:),G0H4(1),ngPbt,m3h2x4(:,103),heltab2x8(:,:,147))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMT,G1H4(68),n2h4(70))
  call Hloop_WA_Q(ntryL,G0H8(52),ex2(:),G0H4(1),m3h2x4(:,104),heltab2x8(:,:,148))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMT,G1H4(69),n2h4(71))
  call Hloop_WA_Q(ntryL,G1H8(103),ex2(:),G1H4(70),m3h2x4(:,105),heltab2x8(:,:,149))
  call Hloop_A_Q(ntryL,G1H4(70),18,nMT,G2H4(36),n2h4(72))
  call Hloop_QA_S(ntryL,G1H8(104),ex2(:),G1H4(70),ngPbt,m3h2x4(:,106),heltab2x8(:,:,150))
  call Hloop_SA_Q(ntryL,G1H8(105),ex2(:),G1H4(71),ngX,m3h2x4(:,107),heltab2x8(:,:,151))
  call Hloop_A_Q(ntryL,G1H4(71),18,nMB,G2H4(37),n2h4(73))
  call Hloop_SA_Q(ntryL,G1H8(106),ex2(:),G1H4(71),ngH,m3h2x4(:,108),heltab2x8(:,:,152))
  call Hloop_A_Q(ntryL,G1H4(71),18,nMB,G2H4(38),n2h4(74))
  call Hloop_SA_Q(ntryL,G1H8(107),ex2(:),G1H4(71),ngPbt,m3h2x4(:,109),heltab2x8(:,:,153))
  call Hloop_A_Q(ntryL,G1H4(71),18,nMT,G2H4(39),n2h4(75))
  call Hloop_QA_W(ntryL,G1H8(108),ex2(:),G1H4(71),m3h2x4(:,110),heltab2x8(:,:,154))
  call Hloop_QA_S(ntryL,G1H8(109),ex2(:),G1H4(72),ngPbt,m3h2x4(:,111),heltab2x8(:,:,155))
  call Hloop_SA_Q(ntryL,G0H8(53),ex2(:),G0H4(1),ngH,m3h2x4(:,112),heltab2x8(:,:,156))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMB,G1H4(73),n2h4(76))
  call Hloop_SA_Q(ntryL,G0H8(54),ex2(:),G0H4(1),ngPbt,m3h2x4(:,113),heltab2x8(:,:,157))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMT,G1H4(74),n2h4(77))
  call Hloop_ZA_Q(ntryL,G0H8(55),ex2(:),G0H4(1),ngZd,m3h2x4(:,114),heltab2x8(:,:,158))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMB,G1H4(75),n2h4(78))
  call Hloop_WA_Q(ntryL,G0H8(56),ex2(:),G0H4(1),m3h2x4(:,115),heltab2x8(:,:,159))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMT,G1H4(76),n2h4(79))
  call Hloop_SA_Q(ntryL,G1H8(110),ex2(:),G1H4(77),ngH,m3h2x4(:,116),heltab2x8(:,:,160))
  call Hloop_A_Q(ntryL,G1H4(77),18,nMB,G2H4(40),n2h4(80))
  call Hloop_SA_Q(ntryL,G1H8(111),ex2(:),G1H4(77),ngPbt,m3h2x4(:,117),heltab2x8(:,:,161))
  call Hloop_A_Q(ntryL,G1H4(77),18,nMT,G2H4(41),n2h4(81))
  call Hloop_QA_W(ntryL,G1H8(112),ex2(:),G1H4(77),m3h2x4(:,118),heltab2x8(:,:,162))
  call Hloop_WA_Q(ntryL,G1H8(113),ex2(:),G1H4(78),m3h2x4(:,119),heltab2x8(:,:,163))
  call Hloop_A_Q(ntryL,G1H4(78),18,nMT,G2H4(42),n2h4(82))
  call Hloop_SA_Q(ntryL,G0H8(57),ex2(:),G0H4(1),ngH,m3h2x4(:,120),heltab2x8(:,:,164))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMB,G1H4(78),n2h4(83))
  call Hloop_SA_Q(ntryL,G0H8(58),ex2(:),G0H4(1),ngPbt,m3h2x4(:,121),heltab2x8(:,:,165))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMT,G1H4(79),n2h4(84))
  call Hloop_WA_Q(ntryL,G0H8(59),ex2(:),G0H4(1),m3h2x4(:,122),heltab2x8(:,:,166))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMT,G1H4(80),n2h4(85))
  call Hloop_WA_Q(ntryL,G1H8(114),ex2(:),G1H4(81),m3h2x4(:,123),heltab2x8(:,:,167))
  call Hloop_A_Q(ntryL,G1H4(81),18,nMT,G2H4(43),n2h4(86))
  call Hloop_AQ_S(ntryL,G1H8(115),ex1(:),G1H4(81),ngH,m3h2x4(:,124),heltab2x8(:,:,168))
  call Hloop_AQ_S(ntryL,G1H8(116),ex1(:),G1H4(82),ngX,m3h2x4(:,125),heltab2x8(:,:,169))
  call Hloop_AQ_S(ntryL,G1H8(117),ex1(:),G1H4(83),ngPtb,m3h2x4(:,126),heltab2x8(:,:,170))
  call Hloop_SQ_A(ntryL,G1H8(118),ex1(:),G1H4(84),ngPtb,m3h2x4(:,127),heltab2x8(:,:,171))
  call Hloop_Q_A(ntryL,G1H4(84),17,nMT,G2H4(44),n2h4(87))
  call Hloop_AQ_S(ntryL,G1H8(119),ex1(:),G1H4(84),ngX,m3h2x4(:,128),heltab2x8(:,:,172))
  call Hloop_AQ_S(ntryL,G1H8(120),ex1(:),G1H4(85),ngPtb,m3h2x4(:,129),heltab2x8(:,:,173))
  call Hloop_AQ_Z(ntryL,G1H8(121),ex1(:),G1H4(86),ngZd,m3h2x4(:,130),heltab2x8(:,:,174))
  call Hloop_AQ_W(ntryL,G1H8(122),ex1(:),G1H4(87),m3h2x4(:,131),heltab2x8(:,:,175))
  call Hloop_SQ_A(ntryL,G0H8(60),ex1(:),G0H4(1),ngPtb,m3h2x4(:,132),heltab2x8(:,:,176))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMT,G1H4(88),n2h4(88))
  call Hloop_SQ_A(ntryL,G1H8(123),ex1(:),G1H4(89),ngPtb,m3h2x4(:,133),heltab2x8(:,:,177))
  call Hloop_Q_A(ntryL,G1H4(89),17,nMT,G2H4(45),n2h4(89))
  call Hloop_WQ_A(ntryL,G0H8(61),ex1(:),G0H4(1),m3h2x4(:,134),heltab2x8(:,:,178))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMT,G1H4(89),n2h4(90))
  call Hloop_AQ_Z(ntryL,G1H8(124),ex1(:),G1H4(90),ngZd,m3h2x4(:,135),heltab2x8(:,:,179))
  call Hloop_AQ_W(ntryL,G1H8(125),ex1(:),G1H4(91),m3h2x4(:,136),heltab2x8(:,:,180))
  call Hloop_SQ_A(ntryL,G0H8(62),ex1(:),G0H4(1),ngPtb,m3h2x4(:,137),heltab2x8(:,:,181))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMT,G1H4(92),n2h4(91))
  call Hloop_WQ_A(ntryL,G1H8(126),ex1(:),G1H4(93),m3h2x4(:,138),heltab2x8(:,:,182))
  call Hloop_Q_A(ntryL,G1H4(93),17,nMT,G2H4(46),n2h4(92))
  call Hloop_WQ_A(ntryL,G0H8(63),ex1(:),G0H4(1),m3h2x4(:,139),heltab2x8(:,:,183))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMT,G1H4(93),n2h4(93))
  call Hloop_WQ_A(ntryL,G1H8(127),ex1(:),G1H4(94),m3h2x4(:,140),heltab2x8(:,:,184))
  call Hloop_Q_A(ntryL,G1H4(94),17,nMT,G2H4(47),n2h4(94))
  call Hloop_SQ_A(ntryL,G1H8(128),ex1(:),G1H4(94),ngH,m3h2x4(:,141),heltab2x8(:,:,185))
  call Hloop_Q_A(ntryL,G1H4(94),17,nMB,G2H4(48),n2h4(95))
  call Hloop_SQ_A(ntryL,G1H8(129),ex1(:),G1H4(94),ngX,m3h2x4(:,142),heltab2x8(:,:,186))
  call Hloop_Q_A(ntryL,G1H4(94),17,nMB,G2H4(49),n2h4(96))
  call Hloop_SQ_A(ntryL,G1H8(130),ex1(:),G1H4(94),ngPtb,m3h2x4(:,143),heltab2x8(:,:,187))
  call Hloop_Q_A(ntryL,G1H4(94),17,nMT,G2H4(50),n2h4(97))
  call Hloop_AQ_S(ntryL,G1H8(131),ex1(:),G1H4(94),ngPtb,m3h2x4(:,144),heltab2x8(:,:,188))
  call Hloop_SQ_A(ntryL,G0H8(64),ex1(:),G0H4(1),ngH,m3h2x4(:,145),heltab2x8(:,:,189))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(95),n2h4(98))
  call Hloop_SQ_A(ntryL,G0H8(65),ex1(:),G0H4(1),ngPtb,m3h2x4(:,146),heltab2x8(:,:,190))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMT,G1H4(96),n2h4(99))
  call Hloop_ZQ_A(ntryL,G0H8(66),ex1(:),G0H4(1),ngZd,m3h2x4(:,147),heltab2x8(:,:,191))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(97),n2h4(100))
  call Hloop_WQ_A(ntryL,G0H8(67),ex1(:),G0H4(1),m3h2x4(:,148),heltab2x8(:,:,192))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMT,G1H4(98),n2h4(101))
  call Hloop_AQ_S(ntryL,G1H8(132),ex1(:),G1H4(99),ngPtb,m3h2x4(:,149),heltab2x8(:,:,193))
  call Hloop_AQ_S(ntryL,G1H8(133),ex1(:),G1H4(100),ngPtb,m3h2x4(:,150),heltab2x8(:,:,194))
  call Hloop_AQ_W(ntryL,G1H8(134),ex1(:),G1H4(101),m3h2x4(:,151),heltab2x8(:,:,195))
  call Hloop_WQ_A(ntryL,G1H8(135),ex1(:),G1H4(102),m3h2x4(:,152),heltab2x8(:,:,196))
  call Hloop_Q_A(ntryL,G1H4(102),17,nMT,G2H4(51),n2h4(102))
  call Hloop_AQ_S(ntryL,G1H8(136),ex1(:),G1H4(102),ngPtb,m3h2x4(:,153),heltab2x8(:,:,197))
  call Hloop_AQ_W(ntryL,G1H8(137),ex1(:),G1H4(103),m3h2x4(:,154),heltab2x8(:,:,198))
  call Hloop_AQ_W(ntryL,G1H8(138),ex1(:),G1H4(104),m3h2x4(:,155),heltab2x8(:,:,199))
  call Hloop_AQ_W(ntryL,G1H8(139),ex1(:),G1H4(105),m3h2x4(:,156),heltab2x8(:,:,200))
  call Hloop_AQ_S(ntryL,G1H8(140),ex1(:),G1H4(106),ngPtb,m3h2x4(:,157),heltab2x8(:,:,201))
  call Hloop_SQ_A(ntryL,G1H8(141),ex1(:),G1H4(107),ngX,m3h2x4(:,158),heltab2x8(:,:,202))
  call Hloop_Q_A(ntryL,G1H4(107),17,nMB,G2H4(52),n2h4(103))
  call Hloop_SQ_A(ntryL,G1H8(142),ex1(:),G1H4(107),ngH,m3h2x4(:,159),heltab2x8(:,:,203))
  call Hloop_Q_A(ntryL,G1H4(107),17,nMB,G2H4(53),n2h4(104))
  call Hloop_SQ_A(ntryL,G1H8(143),ex1(:),G1H4(107),ngPtb,m3h2x4(:,160),heltab2x8(:,:,204))
  call Hloop_Q_A(ntryL,G1H4(107),17,nMT,G2H4(54),n2h4(105))
  call Hloop_AQ_S(ntryL,G1H8(144),ex1(:),G1H4(107),ngPtb,m3h2x4(:,161),heltab2x8(:,:,205))
  call Hloop_AQ_W(ntryL,G1H8(145),ex1(:),G1H4(108),m3h2x4(:,162),heltab2x8(:,:,206))
  call Hloop_SQ_A(ntryL,G0H8(68),ex1(:),G0H4(1),ngH,m3h2x4(:,163),heltab2x8(:,:,207))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(109),n2h4(106))
  call Hloop_SQ_A(ntryL,G0H8(69),ex1(:),G0H4(1),ngPtb,m3h2x4(:,164),heltab2x8(:,:,208))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMT,G1H4(110),n2h4(107))
  call Hloop_SQ_A(ntryL,G1H8(146),ex1(:),G1H4(111),ngH,m3h2x4(:,165),heltab2x8(:,:,209))
  call Hloop_Q_A(ntryL,G1H4(111),17,nMB,G2H4(55),n2h4(108))
  call Hloop_SQ_A(ntryL,G1H8(147),ex1(:),G1H4(111),ngPtb,m3h2x4(:,166),heltab2x8(:,:,210))
  call Hloop_Q_A(ntryL,G1H4(111),17,nMT,G2H4(56),n2h4(109))
  call Hloop_ZQ_A(ntryL,G0H8(70),ex1(:),G0H4(1),ngZd,m3h2x4(:,167),heltab2x8(:,:,211))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(111),n2h4(110))
  call Hloop_WQ_A(ntryL,G0H8(71),ex1(:),G0H4(1),m3h2x4(:,168),heltab2x8(:,:,212))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMT,G1H4(112),n2h4(111))
  call Hloop_AQ_W(ntryL,G1H8(148),ex1(:),G1H4(113),m3h2x4(:,169),heltab2x8(:,:,213))
  call Hloop_SQ_A(ntryL,G0H8(72),ex1(:),G0H4(1),ngH,m3h2x4(:,170),heltab2x8(:,:,214))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(114),n2h4(112))
  call Hloop_SQ_A(ntryL,G0H8(73),ex1(:),G0H4(1),ngPtb,m3h2x4(:,171),heltab2x8(:,:,215))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMT,G1H4(115),n2h4(113))
  call Hloop_WQ_A(ntryL,G1H8(149),ex1(:),G1H4(116),m3h2x4(:,172),heltab2x8(:,:,216))
  call Hloop_Q_A(ntryL,G1H4(116),17,nMT,G2H4(57),n2h4(114))
  call Hloop_WQ_A(ntryL,G0H8(74),ex1(:),G0H4(1),m3h2x4(:,173),heltab2x8(:,:,217))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMT,G1H4(116),n2h4(115))
  call Hloop_WQ_A(ntryL,G1H8(150),ex1(:),G1H4(117),m3h2x4(:,174),heltab2x8(:,:,218))
  call Hloop_Q_A(ntryL,G1H4(117),17,nMT,G2H4(58),n2h4(116))
  call Hloop_SQ_A(ntryL,G1H8(151),ex1(:),G1H4(117),ngH,m3h2x4(:,175),heltab2x8(:,:,219))
  call Hloop_Q_A(ntryL,G1H4(117),17,nMB,G2H4(59),n2h4(117))
  call Hloop_SQ_A(ntryL,G1H8(152),ex1(:),G1H4(117),ngX,m3h2x4(:,176),heltab2x8(:,:,220))
  call Hloop_Q_A(ntryL,G1H4(117),17,nMB,G2H4(60),n2h4(118))
  call Hloop_SQ_A(ntryL,G1H8(153),ex1(:),G1H4(117),ngPtb,m3h2x4(:,177),heltab2x8(:,:,221))
  call Hloop_Q_A(ntryL,G1H4(117),17,nMT,G2H4(61),n2h4(119))
  call Hloop_AQ_S(ntryL,G1H8(154),ex1(:),G1H4(117),ngPtb,m3h2x4(:,178),heltab2x8(:,:,222))
  call Hloop_SQ_A(ntryL,G0H8(75),ex1(:),G0H4(1),ngH,m3h2x4(:,179),heltab2x8(:,:,223))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(118),n2h4(120))
  call Hloop_SQ_A(ntryL,G0H8(76),ex1(:),G0H4(1),ngPtb,m3h2x4(:,180),heltab2x8(:,:,224))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMT,G1H4(119),n2h4(121))
  call Hloop_ZQ_A(ntryL,G0H8(77),ex1(:),G0H4(1),ngZd,m3h2x4(:,181),heltab2x8(:,:,225))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(120),n2h4(122))
  call Hloop_WQ_A(ntryL,G0H8(78),ex1(:),G0H4(1),m3h2x4(:,182),heltab2x8(:,:,226))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMT,G1H4(121),n2h4(123))
  call Hloop_AQ_S(ntryL,G1H8(155),ex1(:),G1H4(122),ngPtb,m3h2x4(:,183),heltab2x8(:,:,227))
  call Hloop_AQ_S(ntryL,G1H8(156),ex1(:),G1H4(123),ngPtb,m3h2x4(:,184),heltab2x8(:,:,228))
  call Hloop_AQ_W(ntryL,G1H8(157),ex1(:),G1H4(124),m3h2x4(:,185),heltab2x8(:,:,229))
  call Hloop_WQ_A(ntryL,G1H8(158),ex1(:),G1H4(125),m3h2x4(:,186),heltab2x8(:,:,230))
  call Hloop_Q_A(ntryL,G1H4(125),17,nMT,G2H4(62),n2h4(124))
  call Hloop_AQ_S(ntryL,G1H8(159),ex1(:),G1H4(125),ngPtb,m3h2x4(:,187),heltab2x8(:,:,231))
  call Hloop_AQ_W(ntryL,G1H8(160),ex1(:),G1H4(126),m3h2x4(:,188),heltab2x8(:,:,232))
  call Hloop_AQ_W(ntryL,G1H8(161),ex1(:),G1H4(127),m3h2x4(:,189),heltab2x8(:,:,233))
  call Hloop_AQ_W(ntryL,G1H8(162),ex1(:),G1H4(128),m3h2x4(:,190),heltab2x8(:,:,234))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(5),[G1H8(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(8),[G0H8(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(20),[G1H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(7),[G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(10),[G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(35),[G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(9),[G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(8),[G1H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G1H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(2),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(11),[G1H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(18),[G0H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(17),[G0H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(14),[G1H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(15),[G1H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(20),[G0H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(19),[G0H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(17),[G1H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G1H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G1H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G1H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(17),[G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(21),[G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G1H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(19),[G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(22),[G1H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(23),[G1H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(20),[G1H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(24),[G1H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(25),[G1H4(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(29),[G1H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(26),[G1H4(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(27),[G1H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(30),[G1H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(31),[G1H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(28),[G1H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(32),[G1H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(33),[G1H4(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(35),[G1H4(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(34),[G1H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(36),[G1H4(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(37),[G1H4(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(39),[G1H4(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(42),[G1H4(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(41),[G1H4(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(43),[G1H4(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(44),[G1H4(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(46),[G1H4(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(45),[G1H4(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(47),[G1H4(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(49),[G1H4(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(50),[G1H4(98)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(51),[G1H4(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(52),[G1H4(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(54),[G1H4(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(57),[G1H4(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(56),[G1H4(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(58),[G1H4(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(60),[G1H4(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(61),[G1H4(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(62),[G1H4(119)])
  call Hloop_AQ_S(ntryL,G2H8(1),ex1(:),G2H4(63),ngH,m3h2x4(:,191),heltab2x8(:,:,235))
  call Hloop_AQ_S(ntryL,G2H8(2),ex1(:),G2H4(64),ngX,m3h2x4(:,192),heltab2x8(:,:,236))
  call Hloop_AQ_S(ntryL,G2H8(3),ex1(:),G2H4(65),ngPtb,m3h2x4(:,193),heltab2x8(:,:,237))
  call Hloop_SQ_A(ntryL,G1H8(5),ex1(:),G1H4(8),ngPtb,m3h2x4(:,194),heltab2x8(:,:,238))
  call Hloop_Q_A(ntryL,G1H4(8),21,nMT,G2H4(66),n2h4(125))
  call Hloop_AQ_V(ntryL,G2H8(4),ex1(:),G2H4(67),m3h2x4(:,195),heltab2x8(:,:,239))
  call Hloop_AQ_Z(ntryL,G2H8(5),ex1(:),G2H4(68),ngZd,m3h2x4(:,196),heltab2x8(:,:,240))
  call Hloop_AQ_W(ntryL,G2H8(6),ex1(:),G2H4(69),m3h2x4(:,197),heltab2x8(:,:,241))
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(1),mass5set(:,1),  & 
G1H8(18),G1H8(19),G1H8(23),G1H8(21),G1H8(22),G1H8(24),8)
  call HG1shiftOLR(G1H8(19),8,8)
  call Hloop_SQ_A(ntryL,G1H8(20),ex1(:),G1H4(7),ngPtb,m3h2x4(:,198),heltab2x8(:,:,242))
  call Hloop_Q_A(ntryL,G1H4(7),21,nMT,G2H4(70),n2h4(126))
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(1),mass5set(:,1),  & 
G1H8(25),G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
  call HG1shiftOLR(G1H8(26),8,8)
  call Hotf_5pt_reduction(G2H8(10),RedSet_5(1),mass5set(:,1),  & 
G1H8(31),G1H8(65),G1H8(32),G1H8(6),G1H8(33),G1H8(80),8)
  call HG1shiftOLR(G1H8(65),8,8)
  call Hloop_WQ_A(ntryL,G1H8(35),ex1(:),G1H4(10),m3h2x4(:,199),heltab2x8(:,:,243))
  call Hloop_Q_A(ntryL,G1H4(10),21,nMT,G2H4(71),n2h4(127))
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(1),mass5set(:,1),  & 
G1H8(34),G1H8(38),G1H8(1),G1H8(36),G1H8(9),G1H8(37),8)
  call HG1shiftOLR(G1H8(38),8,8)
  call Hloop_WQ_A(ntryL,G1H8(8),ex1(:),G1H4(12),m3h2x4(:,200),heltab2x8(:,:,244))
  call Hloop_Q_A(ntryL,G1H4(12),21,nMT,G2H4(72),n2h4(128))
  call Hloop_SQ_A(ntryL,G1H4(1),ex1(:),G1H2(1),ngH,m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMB,G2H2(1),n2h2(1))
  call Hloop_SQ_A(ntryL,G1H4(2),ex1(:),G1H2(1),ngX,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMB,G2H2(2),n2h2(2))
  call Hloop_SQ_A(ntryL,G1H4(3),ex1(:),G1H2(1),ngPtb,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMT,G2H2(3),n2h2(3))
  call Hloop_AQ_S(ntryL,G2H4(1),ex1(:),G2H2(4),ngPtb,m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_VQ_A(ntryL,G1H4(4),ex1(:),G1H2(1),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMB,G2H2(5),n2h2(4))
  call Hloop_ZQ_A(ntryL,G1H4(5),ex1(:),G1H2(1),ngZd,m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMB,G2H2(6),n2h2(5))
  call Hloop_WQ_A(ntryL,G1H4(6),ex1(:),G1H2(1),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMT,G2H2(7),n2h2(6))
  call Hloop_AQ_S(ntryL,G2H4(4),ex1(:),G2H2(8),ngPtb,m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_S(ntryL,G2H4(2),ex1(:),G2H2(9),ngPtb,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_W(ntryL,G2H4(3),ex1(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_AQ_S(ntryL,G2H4(6),ex1(:),G2H2(11),ngPtb,m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_W(ntryL,G2H4(7),ex1(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_AQ_W(ntryL,G2H4(5),ex1(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_AQ_W(ntryL,G2H4(8),ex1(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QA_S(ntryL,G2H8(11),ex2(:),G2H4(1),ngH,m3h2x4(:,201),heltab2x8(:,:,245))
  call Hloop_QA_S(ntryL,G2H8(12),ex2(:),G2H4(4),ngX,m3h2x4(:,202),heltab2x8(:,:,246))
  call Hloop_QA_S(ntryL,G2H8(13),ex2(:),G2H4(2),ngPbt,m3h2x4(:,203),heltab2x8(:,:,247))
  call Hloop_SA_Q(ntryL,G1H8(11),ex2(:),G1H4(9),ngPbt,m3h2x4(:,204),heltab2x8(:,:,248))
  call Hloop_A_Q(ntryL,G1H4(9),22,nMT,G2H4(3),n2h4(129))
  call Hloop_QA_V(ntryL,G2H8(14),ex2(:),G2H4(6),m3h2x4(:,205),heltab2x8(:,:,249))
  call Hloop_QA_Z(ntryL,G2H8(15),ex2(:),G2H4(7),ngZd,m3h2x4(:,206),heltab2x8(:,:,250))
  call Hloop_QA_W(ntryL,G2H8(16),ex2(:),G2H4(5),m3h2x4(:,207),heltab2x8(:,:,251))
  call Hotf_5pt_reduction(G2H8(18),RedSet_5(2),mass5set(:,1),  & 
G1H8(10),G1H8(39),G1H8(40),G1H8(41),G1H8(42),G1H8(43),8)
  call HG1shiftOLR(G1H8(39),8,8)
  call Hotf_5pt_reduction(G2H8(17),RedSet_5(2),mass5set(:,1),  & 
G1H8(44),G1H8(45),G1H8(46),G1H8(47),G1H8(48),G1H8(49),8)
  call HG1shiftOLR(G1H8(45),8,8)
  call Hloop_SA_Q(ntryL,G1H8(14),ex2(:),G1H4(11),ngPbt,m3h2x4(:,208),heltab2x8(:,:,252))
  call Hloop_A_Q(ntryL,G1H4(11),22,nMT,G2H4(8),n2h4(130))
  call Hloop_WA_Q(ntryL,G1H8(15),ex2(:),G1H4(14),m3h2x4(:,209),heltab2x8(:,:,253))
  call Hloop_A_Q(ntryL,G1H4(14),22,nMT,G2H4(73),n2h4(131))
  call Hotf_5pt_reduction(G2H8(20),RedSet_5(2),mass5set(:,1),  & 
G1H8(53),G1H8(51),G1H8(52),G1H8(54),G1H8(55),G1H8(56),8)
  call HG1shiftOLR(G1H8(51),8,8)
  call Hotf_5pt_reduction(G2H8(19),RedSet_5(2),mass5set(:,1),  & 
G1H8(57),G1H8(58),G1H8(59),G1H8(60),G1H8(61),G1H8(62),8)
  call HG1shiftOLR(G1H8(58),8,8)
  call Hloop_WA_Q(ntryL,G1H8(17),ex2(:),G1H4(13),m3h2x4(:,210),heltab2x8(:,:,254))
  call Hloop_A_Q(ntryL,G1H4(13),22,nMT,G2H4(74),n2h4(132))
  call Hloop_SQ_A(ntryL,G1H4(15),ex1(:),G1H2(1),ngH,m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMB,G2H2(15),n2h2(7))
  call Hloop_SQ_A(ntryL,G1H4(16),ex1(:),G1H2(1),ngX,m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMB,G2H2(16),n2h2(8))
  call Hloop_SQ_A(ntryL,G1H4(17),ex1(:),G1H2(1),ngPtb,m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMT,G2H2(17),n2h2(9))
  call Hloop_AQ_S(ntryL,G2H4(9),ex1(:),G2H2(18),ngPtb,m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_VQ_A(ntryL,G1H4(18),ex1(:),G1H2(1),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMB,G2H2(19),n2h2(10))
  call Hloop_ZQ_A(ntryL,G1H4(19),ex1(:),G1H2(1),ngZd,m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMB,G2H2(20),n2h2(11))
  call Hloop_WQ_A(ntryL,G1H4(20),ex1(:),G1H2(1),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMT,G2H2(21),n2h2(12))
  call Hloop_AQ_S(ntryL,G2H4(12),ex1(:),G2H2(22),ngPtb,m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_AQ_S(ntryL,G2H4(10),ex1(:),G2H2(23),ngPtb,m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_AQ_W(ntryL,G2H4(11),ex1(:),G2H2(24),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_AQ_S(ntryL,G2H4(14),ex1(:),G2H2(25),ngPtb,m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_AQ_W(ntryL,G2H4(15),ex1(:),G2H2(26),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_AQ_W(ntryL,G2H4(13),ex1(:),G2H2(27),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_AQ_W(ntryL,G2H4(16),ex1(:),G2H2(28),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_SA_Q(ntryL,G1H4(29),ex2(:),G1H2(1),ngH,m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMB,G2H2(29),n2h2(13))
  call Hloop_SA_Q(ntryL,G1H4(30),ex2(:),G1H2(1),ngX,m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMB,G2H2(30),n2h2(14))
  call Hloop_SA_Q(ntryL,G1H4(31),ex2(:),G1H2(1),ngPbt,m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMT,G2H2(31),n2h2(15))
  call Hloop_QA_S(ntryL,G2H4(17),ex2(:),G2H2(32),ngPbt,m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_VA_Q(ntryL,G1H4(32),ex2(:),G1H2(1),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMB,G2H2(33),n2h2(16))
  call Hloop_ZA_Q(ntryL,G1H4(33),ex2(:),G1H2(1),ngZd,m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMB,G2H2(34),n2h2(17))
  call Hloop_WA_Q(ntryL,G1H4(34),ex2(:),G1H2(1),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMT,G2H2(35),n2h2(18))
  call Hloop_QA_S(ntryL,G2H4(21),ex2(:),G2H2(36),ngPbt,m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_QA_S(ntryL,G2H4(18),ex2(:),G2H2(37),ngPbt,m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_QA_W(ntryL,G2H4(19),ex2(:),G2H2(38),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_QA_S(ntryL,G2H4(22),ex2(:),G2H2(39),ngPbt,m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_QA_W(ntryL,G2H4(23),ex2(:),G2H2(40),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_QA_W(ntryL,G2H4(20),ex2(:),G2H2(41),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_QA_W(ntryL,G2H4(24),ex2(:),G2H2(42),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_SA_Q(ntryL,G1H4(43),ex2(:),G1H2(1),ngH,m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMB,G2H2(43),n2h2(19))
  call Hloop_SA_Q(ntryL,G1H4(44),ex2(:),G1H2(1),ngX,m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMB,G2H2(44),n2h2(20))
  call Hloop_SA_Q(ntryL,G1H4(45),ex2(:),G1H2(1),ngPbt,m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMT,G2H2(45),n2h2(21))
  call Hloop_QA_S(ntryL,G2H4(25),ex2(:),G2H2(46),ngPbt,m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_VA_Q(ntryL,G1H4(46),ex2(:),G1H2(1),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMB,G2H2(47),n2h2(22))
  call Hloop_ZA_Q(ntryL,G1H4(47),ex2(:),G1H2(1),ngZd,m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMB,G2H2(48),n2h2(23))
  call Hloop_WA_Q(ntryL,G1H4(48),ex2(:),G1H2(1),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMT,G2H2(49),n2h2(24))
  call Hloop_QA_S(ntryL,G2H4(29),ex2(:),G2H2(50),ngPbt,m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_QA_S(ntryL,G2H4(26),ex2(:),G2H2(51),ngPbt,m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_QA_W(ntryL,G2H4(27),ex2(:),G2H2(52),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_QA_S(ntryL,G2H4(30),ex2(:),G2H2(53),ngPbt,m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_QA_W(ntryL,G2H4(31),ex2(:),G2H2(54),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_QA_W(ntryL,G2H4(28),ex2(:),G2H2(55),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_QA_W(ntryL,G2H4(32),ex2(:),G2H2(56),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_SS_S(ntryL,G1H4(57),ex3(:),G1H4(22),m3h1x4(:,1),heltab2x4(:,:,57))
  call Hloop_SS_S(ntryL,G1H4(58),ex3(:),G1H4(21),m3h1x4(:,2),heltab2x4(:,:,58))
  call Hloop_SS_S(ntryL,G1H4(59),ex3(:),G1H4(24),m3h1x4(:,3),heltab2x4(:,:,59))
  call Hotf_5pt_reduction(G2H4(33),RedSet_5(3),mass5set(:,2),  & 
G1H4(26),G1H4(23),G1H4(25),G1H4(28),G1H4(27),G1H4(36),4)
  call HG1shiftOLR(G1H4(23),8,4)
  call Hloop_VT_S(ntryL,G1H4(60),18,ex3(:),4,G2H4(9),m3h1x4(:,4),heltab2x4(:,:,60))
  call Hloop_VT_S(ntryL,G1H4(61),18,ex3(:),4,G2H4(12),m3h1x4(:,5),heltab2x4(:,:,61))
  call Hloop_ST_V(ntryL,G1H4(62),18,ex3(:),4,G2H4(10),m3h1x4(:,6),heltab2x4(:,:,62))
  call Hloop_ST_V(ntryL,G1H4(63),18,ex3(:),4,G2H4(11),m3h1x4(:,7),heltab2x4(:,:,63))
  call Hotf_5pt_reduction(G2H4(35),RedSet_5(3),mass5set(:,2),  & 
G1H4(35),G1H4(39),G1H4(40),G1H4(37),G1H4(38),G1H4(42),4)
  call HG1shiftOLR(G1H4(39),8,4)
  call Hotf_5pt_reduction(G2H4(34),RedSet_5(3),mass5set(:,2),  & 
G1H4(41),G1H4(50),G1H4(49),G1H4(53),G1H4(54),G1H4(51),4)
  call HG1shiftOLR(G1H4(50),8,4)
  call Hloop_VS_V(ntryL,G1H4(66),ex3(:),G1H4(52),m3h1x4(:,8),heltab2x4(:,:,64))
  call Hloop_VS_V(ntryL,G1H4(67),ex3(:),G1H4(56),m3h1x4(:,9),heltab2x4(:,:,65))
  call Hotf_5pt_reduction(G2H4(36),RedSet_5(3),mass5set(:,2),  & 
G1H4(55),G1H4(65),G1H4(64),G1H4(69),G1H4(68),G1H4(75),4)
  call HG1shiftOLR(G1H4(65),8,4)
  call Hloop_SV_T(ntryL,G1H4(70),18,ex4(:),8,G2H2(57),m3h2x2(:,57),heltab2x4(:,:,66))
  call Hotf_5pt_reduction(G2H4(37),RedSet_5(4),mass5set(:,3),  & 
G1H4(76),G1H4(74),G1H4(80),G1H4(79),G1H4(89),G1H4(88),4)
  call HG1shiftOLR(G1H4(74),4,4)
  call Hotf_5pt_reduction(G2H4(38),RedSet_5(4),mass5set(:,4),  & 
G1H4(93),G1H4(92),G1H4(97),G1H4(98),G1H4(96),G1H4(111),4)
  call HG1shiftOLR(G1H4(92),4,4)
  call Hotf_5pt_reduction(G2H4(39),RedSet_5(4),mass5set(:,2),  & 
G1H4(112),G1H4(110),G1H4(116),G1H4(115),G1H4(120),G1H4(121),4)
  call HG1shiftOLR(G1H4(110),4,4)
  call Hloop_VV_S(ntryL,G1H4(71),ex4(:),G1H2(1),m3h2x2(:,58),heltab2x4(:,:,67))
  call Hloop_SV_V(ntryL,G1H4(72),ex4(:),G1H2(2),m3h2x2(:,59),heltab2x4(:,:,68))
  call Hloop_AV_Q(ntryL,G1H4(73),ex4(:),G1H2(3),m3h2x2(:,60),heltab2x4(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(3),26,nMB,G2H2(58),n2h2(25))
  call Hotf_5pt_reduction(G2H4(42),RedSet_5(4),mass5set(:,2),  & 
G1H4(119),G1H4(8),G1H4(7),G1H4(10),G1H4(12),G1H4(1),4)
  call HG1shiftOLR(G1H4(8),4,4)
  call Hotf_5pt_reduction(G2H4(40),RedSet_5(4),mass5set(:,4),  & 
G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),G1H4(9),4)
  call HG1shiftOLR(G1H4(3),4,4)
  call Hotf_5pt_reduction(G2H4(41),RedSet_5(4),mass5set(:,2),  & 
G1H4(11),G1H4(14),G1H4(13),G1H4(15),G1H4(16),G1H4(17),4)
  call HG1shiftOLR(G1H4(14),4,4)
  call Hloop_UW_V(ntryL,G1H4(77),18,ex4(:),8,G2H2(59),m3h2x2(:,61),heltab2x4(:,:,70))
  call Hloop_AV_Q(ntryL,G1H4(78),ex4(:),G1H2(3),m3h2x2(:,62),heltab2x4(:,:,71))
  call Hloop_A_Q(ntryL,G1H2(3),26,nMB,G2H2(60),n2h2(26))
  call Hotf_5pt_reduction(G2H4(43),RedSet_5(4),mass5set(:,2),  & 
G1H4(18),G1H4(19),G1H4(20),G1H4(29),G1H4(30),G1H4(31),4)
  call HG1shiftOLR(G1H4(19),4,4)
  call Hloop_SS_S(ntryL,G1H4(81),ex3(:),G1H4(32),m3h1x4(:,10),heltab2x4(:,:,72))
  call Hloop_SS_S(ntryL,G1H4(82),ex3(:),G1H4(33),m3h1x4(:,11),heltab2x4(:,:,73))
  call Hloop_SS_S(ntryL,G1H4(83),ex3(:),G1H4(34),m3h1x4(:,12),heltab2x4(:,:,74))
  call Hotf_5pt_reduction(G2H4(44),RedSet_5(5),mass5set(:,2),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),8,4)
  call Hloop_ST_V(ntryL,G1H4(84),17,ex3(:),4,G2H4(14),m3h1x4(:,13),heltab2x4(:,:,75))
  call Hloop_ST_V(ntryL,G1H4(85),17,ex3(:),4,G2H4(15),m3h1x4(:,14),heltab2x4(:,:,76))
  call Hloop_VT_S(ntryL,G1H4(86),17,ex3(:),4,G2H4(13),m3h1x4(:,15),heltab2x4(:,:,77))
  call Hloop_VT_S(ntryL,G1H4(87),17,ex3(:),4,G2H4(16),m3h1x4(:,16),heltab2x4(:,:,78))
  call Hotf_5pt_reduction(G2H4(46),RedSet_5(5),mass5set(:,2),  & 
G1H4(57),G1H4(58),G1H4(59),G1H4(60),G1H4(61),G1H4(62),4)
  call HG1shiftOLR(G1H4(58),8,4)
  call Hotf_5pt_reduction(G2H4(45),RedSet_5(5),mass5set(:,2),  & 
G1H4(63),G1H4(66),G1H4(67),G1H4(70),G1H4(71),G1H4(72),4)
  call HG1shiftOLR(G1H4(66),8,4)
  call Hloop_VS_V(ntryL,G1H4(90),ex3(:),G1H4(73),m3h1x4(:,17),heltab2x4(:,:,79))
  call Hloop_VS_V(ntryL,G1H4(91),ex3(:),G1H4(77),m3h1x4(:,18),heltab2x4(:,:,80))
  call Hotf_5pt_reduction(G2H4(47),RedSet_5(5),mass5set(:,2),  & 
G1H4(78),G1H4(81),G1H4(82),G1H4(83),G1H4(84),G1H4(85),4)
  call HG1shiftOLR(G1H4(81),8,4)
  call Hotf_5pt_reduction(G2H4(48),RedSet_5(6),mass5set(:,5),  & 
G1H4(86),G1H4(87),G1H4(90),G1H4(91),G1H4(129),G1H4(130),4)
  call HG1shiftOLR(G1H4(87),2,4)
  call Hotf_5pt_reduction(G2H4(49),RedSet_5(6),mass5set(:,6),  & 
G1H4(131),G1H4(132),G1H4(133),G1H4(134),G1H4(135),G1H4(136),4)
  call HG1shiftOLR(G1H4(132),2,4)
  call Hotf_5pt_reduction(G2H4(50),RedSet_5(6),mass5set(:,7),  & 
G1H4(137),G1H4(138),G1H4(139),G1H4(140),G1H4(141),G1H4(142),4)
  call HG1shiftOLR(G1H4(138),2,4)
  call Hloop_SS_S(ntryL,G1H4(94),ex3(:),G1H4(143),m3h1x4(:,19),heltab2x4(:,:,81))
  call Hloop_QS_A(ntryL,G1H4(95),ex3(:),G1H4(94),ngH,m3h1x4(:,20),heltab2x4(:,:,82))
  call Hloop_Q_A(ntryL,G1H4(94),21,nMB,G2H4(17),n2h4(133))
  call Hotf_5pt_reduction(G2H4(51),RedSet_5(6),mass5set(:,7),  & 
G1H4(95),G1H4(94),G1H4(144),G1H4(145),G1H4(146),G1H4(147),4)
  call HG1shiftOLR(G1H4(94),2,4)
  call Hloop_ST_V(ntryL,G1H4(99),17,ex3(:),4,G2H4(21),m3h1x4(:,21),heltab2x4(:,:,83))
  call Hloop_SS_S(ntryL,G1H4(100),ex3(:),G1H4(99),m3h1x4(:,22),heltab2x4(:,:,84))
  call Hloop_VT_S(ntryL,G1H4(101),17,ex3(:),4,G2H4(18),m3h1x4(:,23),heltab2x4(:,:,85))
  call Hloop_ST_V(ntryL,G1H4(102),17,ex3(:),4,G2H4(19),m3h1x4(:,24),heltab2x4(:,:,86))
  call Hloop_VS_V(ntryL,G1H4(103),ex3(:),G1H4(100),m3h1x4(:,25),heltab2x4(:,:,87))
  call Hloop_VT_S(ntryL,G1H4(104),17,ex3(:),4,G2H4(22),m3h1x4(:,26),heltab2x4(:,:,88))
  call Hloop_VS_V(ntryL,G1H4(105),ex3(:),G1H4(101),m3h1x4(:,27),heltab2x4(:,:,89))
  call Hloop_TV_S(ntryL,G1H4(106),17,ex4(:),8,G2H2(61),m3h2x2(:,63),heltab2x4(:,:,90))
  call Hotf_5pt_reduction(G2H4(52),RedSet_5(7),mass5set(:,3),  & 
G1H4(102),G1H4(103),G1H4(104),G1H4(105),G1H4(106),G1H4(148),4)
  call HG1shiftOLR(G1H4(103),4,4)
  call Hotf_5pt_reduction(G2H4(53),RedSet_5(7),mass5set(:,4),  & 
G1H4(149),G1H4(150),G1H4(151),G1H4(152),G1H4(153),G1H4(154),4)
  call HG1shiftOLR(G1H4(150),4,4)
  call Hotf_5pt_reduction(G2H4(54),RedSet_5(7),mass5set(:,2),  & 
G1H4(155),G1H4(156),G1H4(157),G1H4(158),G1H4(159),G1H4(160),4)
  call HG1shiftOLR(G1H4(156),4,4)
  call Hloop_SV_V(ntryL,G1H4(107),ex4(:),G1H2(3),m3h2x2(:,64),heltab2x4(:,:,91))
  call Hloop_VV_S(ntryL,G1H4(108),ex4(:),G1H2(4),m3h2x2(:,65),heltab2x4(:,:,92))
  call Hloop_QV_A(ntryL,G1H4(109),ex4(:),G1H2(5),m3h2x2(:,66),heltab2x4(:,:,93))
  call Hloop_Q_A(ntryL,G1H2(5),25,nMB,G2H2(62),n2h2(27))
  call Hotf_5pt_reduction(G2H4(57),RedSet_5(7),mass5set(:,2),  & 
G1H4(107),G1H4(108),G1H4(109),G1H4(161),G1H4(162),G1H4(163),4)
  call HG1shiftOLR(G1H4(108),4,4)
  call Hotf_5pt_reduction(G2H4(55),RedSet_5(7),mass5set(:,4),  & 
G1H4(164),G1H4(165),G1H4(166),G1H4(167),G1H4(168),G1H4(169),4)
  call HG1shiftOLR(G1H4(165),4,4)
  call Hotf_5pt_reduction(G2H4(56),RedSet_5(7),mass5set(:,2),  & 
G1H4(170),G1H4(171),G1H4(172),G1H4(173),G1H4(174),G1H4(175),4)
  call HG1shiftOLR(G1H4(171),4,4)
  call Hloop_UV_W(ntryL,G1H4(113),17,ex4(:),8,G2H2(63),m3h2x2(:,67),heltab2x4(:,:,94))
  call Hloop_QV_A(ntryL,G1H4(114),ex4(:),G1H2(5),m3h2x2(:,68),heltab2x4(:,:,95))
  call Hloop_Q_A(ntryL,G1H2(5),25,nMB,G2H2(64),n2h2(28))
  call Hotf_5pt_reduction(G2H4(58),RedSet_5(7),mass5set(:,2),  & 
G1H4(113),G1H4(114),G1H4(176),G1H4(177),G1H4(178),G1H4(179),4)
  call HG1shiftOLR(G1H4(114),4,4)
  call Hotf_5pt_reduction(G2H4(59),RedSet_5(8),mass5set(:,5),  & 
G1H4(180),G1H4(181),G1H4(182),G1H4(183),G1H4(184),G1H4(185),4)
  call HG1shiftOLR(G1H4(181),2,4)
  call Hotf_5pt_reduction(G2H4(60),RedSet_5(8),mass5set(:,6),  & 
G1H4(186),G1H4(187),G1H4(188),G1H4(189),G1H4(190),G1H4(191),4)
  call HG1shiftOLR(G1H4(187),2,4)
  call Hotf_5pt_reduction(G2H4(61),RedSet_5(8),mass5set(:,7),  & 
G1H4(192),G1H4(193),G1H4(194),G1H4(195),G1H4(196),G1H4(197),4)
  call HG1shiftOLR(G1H4(193),2,4)
  call Hloop_TV_S(ntryL,G1H4(117),17,ex4(:),8,G2H2(65),m3h2x2(:,69),heltab2x4(:,:,96))
  call Hloop_QV_A(ntryL,G1H4(118),ex4(:),G1H2(5),m3h2x2(:,70),heltab2x4(:,:,97))
  call Hloop_Q_A(ntryL,G1H2(5),25,nMB,G2H2(66),n2h2(29))
  call Hotf_5pt_reduction(G2H4(62),RedSet_5(8),mass5set(:,7),  & 
G1H4(117),G1H4(118),G1H4(198),G1H4(199),G1H4(200),G1H4(201),4)
  call HG1shiftOLR(G1H4(118),2,4)
  call Hloop_SV_V(ntryL,G1H4(122),ex4(:),G1H2(5),m3h2x2(:,71),heltab2x4(:,:,98))
  call Hloop_TV_S(ntryL,G1H4(123),17,ex4(:),8,G2H2(67),m3h2x2(:,72),heltab2x4(:,:,99))
  call Hloop_VV_S(ntryL,G1H4(124),ex4(:),G1H2(6),m3h2x2(:,73),heltab2x4(:,:,100))
  call Hloop_SV_V(ntryL,G1H4(125),ex4(:),G1H2(7),m3h2x2(:,74),heltab2x4(:,:,101))
  call Hloop_UV_W(ntryL,G1H4(126),17,ex4(:),8,G2H2(68),m3h2x2(:,75),heltab2x4(:,:,102))
  call Hloop_VV_S(ntryL,G1H4(127),ex4(:),G1H2(8),m3h2x2(:,76),heltab2x4(:,:,103))
  call Hloop_UV_W(ntryL,G1H4(128),17,ex4(:),8,G2H2(69),m3h2x2(:,77),heltab2x4(:,:,104))
  call Hloop_SQ_A(ntryL,G1H8(18),ex1(:),G1H4(122),ngPtb,m3h2x4(:,211),heltab2x8(:,:,255))
  call Hloop_Q_A(ntryL,G1H4(122),21,nMT,G2H4(23),n2h4(134))
call HGT_raise_alpha_OLR(G1H8(19),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(19),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(19),ex4(:),G1H4(123),m3h2x4(:,212),heltab2x8(:,:,256))
  call Hloop_SQ_A(ntryL,G1H8(21),ex1(:),G1H4(124),ngPtb,m3h2x4(:,213),heltab2x8(:,:,257))
  call Hloop_Q_A(ntryL,G1H4(124),21,nMT,G2H4(20),n2h4(135))
  call Hloop_SQ_A(ntryL,G1H8(22),ex1(:),G1H4(125),ngPtb,m3h2x4(:,214),heltab2x8(:,:,258))
  call Hloop_Q_A(ntryL,G1H4(125),21,nMT,G2H4(24),n2h4(136))
  call Hloop_SQ_A(ntryL,G1H8(24),ex1(:),G1H4(126),ngPtb,m3h2x4(:,215),heltab2x8(:,:,259))
  call Hloop_Q_A(ntryL,G1H4(126),21,nMT,G2H4(25),n2h4(137))
  call Hloop_WQ_A(ntryL,G1H8(25),ex1(:),G1H4(127),m3h2x4(:,216),heltab2x8(:,:,260))
  call Hloop_Q_A(ntryL,G1H4(127),21,nMT,G2H4(29),n2h4(138))
call HGT_OLR(G1H8(26),1,1,8)
call HGT_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(26),-8,ex4(:),8,G2H4(26),m3h2x4(:,217),heltab2x8(:,:,261))
  call Hloop_WQ_A(ntryL,G1H8(28),ex1(:),G1H4(128),m3h2x4(:,218),heltab2x8(:,:,262))
  call Hloop_Q_A(ntryL,G1H4(128),21,nMT,G2H4(27),n2h4(139))
  call Hloop_WQ_A(ntryL,G1H8(29),ex1(:),G1H4(122),m3h2x4(:,219),heltab2x8(:,:,263))
  call Hloop_Q_A(ntryL,G1H4(122),21,nMT,G2H4(30),n2h4(140))
  call Hloop_WQ_A(ntryL,G1H8(30),ex1(:),G1H4(124),m3h2x4(:,220),heltab2x8(:,:,264))
  call Hloop_Q_A(ntryL,G1H4(124),21,nMT,G2H4(31),n2h4(141))
  call Hloop_SQ_A(ntryL,G1H8(31),ex1(:),G1H4(125),ngPtb,m3h2x4(:,221),heltab2x8(:,:,265))
  call Hloop_Q_A(ntryL,G1H4(125),21,nMT,G2H4(28),n2h4(142))
call HGT_raise_alpha_OLR(G1H8(65),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(65),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(65),-8,ex4(:),8,G2H4(32),m3h2x4(:,222),heltab2x8(:,:,266))
  call Hloop_SQ_A(ntryL,G1H8(6),ex1(:),G1H4(126),ngPtb,m3h2x4(:,223),heltab2x8(:,:,267))
  call Hloop_Q_A(ntryL,G1H4(126),21,nMT,G2H4(33),n2h4(143))
  call Hloop_SQ_A(ntryL,G1H8(33),ex1(:),G1H4(127),ngPtb,m3h2x4(:,224),heltab2x8(:,:,268))
  call Hloop_Q_A(ntryL,G1H4(127),21,nMT,G2H4(35),n2h4(144))
  call Hloop_SQ_A(ntryL,G1H8(80),ex1(:),G1H4(128),ngPtb,m3h2x4(:,225),heltab2x8(:,:,269))
  call Hloop_Q_A(ntryL,G1H4(128),21,nMT,G2H4(34),n2h4(145))
  call Hloop_WQ_A(ntryL,G1H8(34),ex1(:),G1H4(122),m3h2x4(:,226),heltab2x8(:,:,270))
  call Hloop_Q_A(ntryL,G1H4(122),21,nMT,G2H4(36),n2h4(146))
call HGT_OLR(G1H8(38),1,1,8)
call HGT_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(38),ex4(:),G1H4(124),m3h2x4(:,227),heltab2x8(:,:,271))
  call Hloop_WQ_A(ntryL,G1H8(36),ex1(:),G1H4(125),m3h2x4(:,228),heltab2x8(:,:,272))
  call Hloop_Q_A(ntryL,G1H4(125),21,nMT,G2H4(37),n2h4(147))
  call Hloop_WQ_A(ntryL,G1H8(9),ex1(:),G1H4(126),m3h2x4(:,229),heltab2x8(:,:,273))
  call Hloop_Q_A(ntryL,G1H4(126),21,nMT,G2H4(38),n2h4(148))
  call Hloop_WQ_A(ntryL,G1H8(37),ex1(:),G1H4(127),m3h2x4(:,230),heltab2x8(:,:,274))
  call Hloop_Q_A(ntryL,G1H4(127),21,nMT,G2H4(39),n2h4(149))
  call Hloop_SA_Q(ntryL,G1H8(10),ex2(:),G1H4(128),ngPbt,m3h2x4(:,231),heltab2x8(:,:,275))
  call Hloop_A_Q(ntryL,G1H4(128),22,nMT,G2H4(42),n2h4(150))
call HGT_raise_alpha_OLR(G1H8(39),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(39),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(39),ex4(:),G1H4(122),m3h2x4(:,232),heltab2x8(:,:,276))
  call Hloop_SA_Q(ntryL,G1H8(41),ex2(:),G1H4(125),ngPbt,m3h2x4(:,233),heltab2x8(:,:,277))
  call Hloop_A_Q(ntryL,G1H4(125),22,nMT,G2H4(40),n2h4(151))
  call Hloop_SA_Q(ntryL,G1H8(42),ex2(:),G1H4(126),ngPbt,m3h2x4(:,234),heltab2x8(:,:,278))
  call Hloop_A_Q(ntryL,G1H4(126),22,nMT,G2H4(41),n2h4(152))
  call Hloop_SA_Q(ntryL,G1H8(43),ex2(:),G1H4(127),ngPbt,m3h2x4(:,235),heltab2x8(:,:,279))
  call Hloop_A_Q(ntryL,G1H4(127),22,nMT,G2H4(43),n2h4(153))
  call Hloop_WA_Q(ntryL,G1H8(44),ex2(:),G1H4(128),m3h2x4(:,236),heltab2x8(:,:,280))
  call Hloop_A_Q(ntryL,G1H4(128),22,nMT,G2H4(44),n2h4(154))
call HGT_OLR(G1H8(45),1,1,8)
call HGT_invQ_OLR(G1H8(45),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(45),-8,ex4(:),8,G2H4(46),m3h2x4(:,237),heltab2x8(:,:,281))
  call Hloop_WA_Q(ntryL,G1H8(47),ex2(:),G1H4(125),m3h2x4(:,238),heltab2x8(:,:,282))
  call Hloop_A_Q(ntryL,G1H4(125),22,nMT,G2H4(45),n2h4(155))
  call Hloop_WA_Q(ntryL,G1H8(48),ex2(:),G1H4(126),m3h2x4(:,239),heltab2x8(:,:,283))
  call Hloop_A_Q(ntryL,G1H4(126),22,nMT,G2H4(47),n2h4(156))
  call Hloop_WA_Q(ntryL,G1H8(49),ex2(:),G1H4(127),m3h2x4(:,240),heltab2x8(:,:,284))
  call Hloop_A_Q(ntryL,G1H4(127),22,nMT,G2H4(48),n2h4(157))
  call Hloop_SA_Q(ntryL,G1H8(53),ex2(:),G1H4(128),ngPbt,m3h2x4(:,241),heltab2x8(:,:,285))
  call Hloop_A_Q(ntryL,G1H4(128),22,nMT,G2H4(49),n2h4(158))
call HGT_raise_alpha_OLR(G1H8(51),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(51),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(51),-8,ex4(:),8,G2H4(50),m3h2x4(:,242),heltab2x8(:,:,286))
  call Hloop_SA_Q(ntryL,G1H8(54),ex2(:),G1H4(125),ngPbt,m3h2x4(:,243),heltab2x8(:,:,287))
  call Hloop_A_Q(ntryL,G1H4(125),22,nMT,G2H4(51),n2h4(159))
  call Hloop_SA_Q(ntryL,G1H8(55),ex2(:),G1H4(126),ngPbt,m3h2x4(:,244),heltab2x8(:,:,288))
  call Hloop_A_Q(ntryL,G1H4(126),22,nMT,G2H4(52),n2h4(160))
  call Hloop_SA_Q(ntryL,G1H8(56),ex2(:),G1H4(127),ngPbt,m3h2x4(:,245),heltab2x8(:,:,289))
  call Hloop_A_Q(ntryL,G1H4(127),22,nMT,G2H4(53),n2h4(161))
  call Hloop_WA_Q(ntryL,G1H8(57),ex2(:),G1H4(128),m3h2x4(:,246),heltab2x8(:,:,290))
  call Hloop_A_Q(ntryL,G1H4(128),22,nMT,G2H4(54),n2h4(162))
call HGT_OLR(G1H8(58),1,1,8)
call HGT_invQ_OLR(G1H8(58),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(58),ex4(:),G1H4(125),m3h2x4(:,247),heltab2x8(:,:,291))
  call Hloop_WA_Q(ntryL,G1H8(60),ex2(:),G1H4(126),m3h2x4(:,248),heltab2x8(:,:,292))
  call Hloop_A_Q(ntryL,G1H4(126),22,nMT,G2H4(57),n2h4(163))
  call Hloop_WA_Q(ntryL,G1H8(61),ex2(:),G1H4(127),m3h2x4(:,249),heltab2x8(:,:,293))
  call Hloop_A_Q(ntryL,G1H4(127),22,nMT,G2H4(55),n2h4(164))
  call Hloop_WA_Q(ntryL,G1H8(62),ex2(:),G1H4(128),m3h2x4(:,250),heltab2x8(:,:,294))
  call Hloop_A_Q(ntryL,G1H4(128),22,nMT,G2H4(56),n2h4(165))
  call Hloop_AS_Q(ntryL,G1H4(26),ex3(:),G1H4(126),ngH,m3h1x4(:,28),heltab2x4(:,:,105))
  call Hloop_A_Q(ntryL,G1H4(126),22,nMT,G2H4(58),n2h4(166))
call HGT_OLR(G1H4(23),1,1,4)
call HGT_invQ_OLR(G1H4(23),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(23),-8,ex4(:),8,G2H2(70),m3h2x2(:,78),heltab2x4(:,:,106))
  call Hloop_AS_Q(ntryL,G1H4(28),ex3(:),G1H4(127),ngH,m3h1x4(:,29),heltab2x4(:,:,107))
  call Hloop_A_Q(ntryL,G1H4(127),22,nMT,G2H4(59),n2h4(168))
  call Hloop_AS_Q(ntryL,G1H4(27),ex3(:),G1H4(128),ngH,m3h1x4(:,30),heltab2x4(:,:,108))
  call Hloop_A_Q(ntryL,G1H4(128),22,nMT,G2H4(60),n2h4(169))
  call Hloop_AS_Q(ntryL,G1H4(36),ex3(:),G1H4(26),ngH,m3h1x4(:,31),heltab2x4(:,:,109))
  call Hloop_A_Q(ntryL,G1H4(26),22,nMT,G2H4(61),n2h4(170))
  call Hloop_AS_Q(ntryL,G1H4(35),ex3(:),G1H4(126),ngH,m3h1x4(:,32),heltab2x4(:,:,110))
  call Hloop_A_Q(ntryL,G1H4(126),22,nMT,G2H4(62),n2h4(171))
call HGT_raise_alpha_OLR(G1H4(39),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(39),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(39),ex4(:),G1H2(9),m3h2x2(:,79),heltab2x4(:,:,111))
  call Hloop_AS_Q(ntryL,G1H4(37),ex3(:),G1H4(23),ngH,m3h1x4(:,33),heltab2x4(:,:,112))
  call Hloop_A_Q(ntryL,G1H4(23),22,nMT,G2H4(75),n2h4(173))
  call Hloop_AS_Q(ntryL,G1H4(38),ex3(:),G1H4(28),ngH,m3h1x4(:,34),heltab2x4(:,:,113))
  call Hloop_A_Q(ntryL,G1H4(28),22,nMT,G2H4(76),n2h4(174))
  call Hloop_AS_Q(ntryL,G1H4(42),ex3(:),G1H4(127),ngH,m3h1x4(:,35),heltab2x4(:,:,114))
  call Hloop_A_Q(ntryL,G1H4(127),22,nMT,G2H4(77),n2h4(175))
  call Hloop_AS_Q(ntryL,G1H4(41),ex3(:),G1H4(27),ngH,m3h1x4(:,36),heltab2x4(:,:,115))
  call Hloop_A_Q(ntryL,G1H4(27),22,nMT,G2H4(78),n2h4(176))
call HGT_OLR(G1H4(50),1,1,4)
call HGT_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(50),ex4(:),G1H2(10),m3h2x2(:,80),heltab2x4(:,:,116))
  call Hloop_AS_Q(ntryL,G1H4(53),ex3(:),G1H4(128),ngH,m3h1x4(:,37),heltab2x4(:,:,117))
  call Hloop_A_Q(ntryL,G1H4(128),22,nMT,G2H4(79),n2h4(178))
  call Hloop_AS_Q(ntryL,G1H4(54),ex3(:),G1H4(36),ngH,m3h1x4(:,38),heltab2x4(:,:,118))
  call Hloop_A_Q(ntryL,G1H4(36),22,nMT,G2H4(80),n2h4(179))
  call Hloop_AS_Q(ntryL,G1H4(51),ex3(:),G1H4(26),ngH,m3h1x4(:,39),heltab2x4(:,:,119))
  call Hloop_A_Q(ntryL,G1H4(26),22,nMT,G2H4(81),n2h4(180))
  call Hloop_AS_Q(ntryL,G1H4(55),ex3(:),G1H4(35),ngH,m3h1x4(:,40),heltab2x4(:,:,120))
  call Hloop_A_Q(ntryL,G1H4(35),22,nMT,G2H4(82),n2h4(181))
call HGT_raise_alpha_OLR(G1H4(65),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(65),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(65),-8,ex4(:),8,G2H2(71),m3h2x2(:,81),heltab2x4(:,:,121))
  call Hloop_AS_Q(ntryL,G1H4(69),ex3(:),G1H4(126),ngH,m3h1x4(:,41),heltab2x4(:,:,122))
  call Hloop_A_Q(ntryL,G1H4(126),22,nMT,G2H4(83),n2h4(183))
  call Hloop_AS_Q(ntryL,G1H4(68),ex3(:),G1H4(39),ngH,m3h1x4(:,42),heltab2x4(:,:,123))
  call Hloop_A_Q(ntryL,G1H4(39),22,nMT,G2H4(84),n2h4(184))
  call Hloop_AS_Q(ntryL,G1H4(75),ex3(:),G1H4(37),ngH,m3h1x4(:,43),heltab2x4(:,:,124))
  call Hloop_A_Q(ntryL,G1H4(37),22,nMT,G2H4(85),n2h4(185))
  call Hloop_AV_Q(ntryL,G1H4(76),ex4(:),G1H2(11),m3h2x2(:,82),heltab2x4(:,:,125))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMB,G2H2(72),n2h2(30))
call HGT_OLR(G1H4(74),1,1,4)
call HGT_invQ_OLR(G1H4(74),2,5,4)
  call Hloop_SS_S(ntryL,G1H4(74),ex3(:),G1H4(23),m3h1x4(:,44),heltab2x4(:,:,126))
  call Hloop_AV_Q(ntryL,G1H4(79),ex4(:),G1H2(11),m3h2x2(:,83),heltab2x4(:,:,127))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMB,G2H2(73),n2h2(31))
  call Hloop_AV_Q(ntryL,G1H4(89),ex4(:),G1H2(11),m3h2x2(:,84),heltab2x4(:,:,128))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMB,G2H2(74),n2h2(32))
  call Hloop_AV_Q(ntryL,G1H4(88),ex4(:),G1H2(11),m3h2x2(:,85),heltab2x4(:,:,129))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMB,G2H2(75),n2h2(33))
  call Hloop_AV_Q(ntryL,G1H4(93),ex4(:),G1H2(11),m3h2x2(:,86),heltab2x4(:,:,130))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMB,G2H2(76),n2h2(34))
call HGT_OLR(G1H4(92),1,1,4)
call HGT_invQ_OLR(G1H4(92),2,5,4)
  call Hloop_SS_S(ntryL,G1H4(92),ex3(:),G1H4(38),m3h1x4(:,45),heltab2x4(:,:,131))
  call Hloop_AV_Q(ntryL,G1H4(98),ex4(:),G1H2(11),m3h2x2(:,87),heltab2x4(:,:,132))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMB,G2H2(77),n2h2(35))
  call Hloop_AV_Q(ntryL,G1H4(96),ex4(:),G1H2(11),m3h2x2(:,88),heltab2x4(:,:,133))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMB,G2H2(78),n2h2(36))
  call Hloop_AV_Q(ntryL,G1H4(111),ex4(:),G1H2(11),m3h2x2(:,89),heltab2x4(:,:,134))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMB,G2H2(79),n2h2(37))
  call Hloop_AV_Q(ntryL,G1H4(112),ex4(:),G1H2(11),m3h2x2(:,90),heltab2x4(:,:,135))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMT,G2H2(80),n2h2(38))
call HGT_OLR(G1H4(110),1,1,4)
call HGT_invQ_OLR(G1H4(110),2,5,4)
  call Hloop_SS_S(ntryL,G1H4(110),ex3(:),G1H4(28),m3h1x4(:,46),heltab2x4(:,:,136))
  call Hloop_AV_Q(ntryL,G1H4(115),ex4(:),G1H2(11),m3h2x2(:,91),heltab2x4(:,:,137))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMT,G2H2(81),n2h2(39))
  call Hloop_AV_Q(ntryL,G1H4(120),ex4(:),G1H2(11),m3h2x2(:,92),heltab2x4(:,:,138))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMT,G2H2(82),n2h2(40))
  call Hloop_AV_Q(ntryL,G1H4(121),ex4(:),G1H2(11),m3h2x2(:,93),heltab2x4(:,:,139))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMT,G2H2(83),n2h2(41))
  call Hloop_AV_Q(ntryL,G1H4(119),ex4(:),G1H2(11),m3h2x2(:,94),heltab2x4(:,:,140))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMT,G2H2(84),n2h2(42))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_VT_S(ntryL,G1H4(8),-4,ex3(:),4,G2H4(86),m3h1x4(:,47),heltab2x4(:,:,141))
  call Hloop_AV_Q(ntryL,G1H4(10),ex4(:),G1H2(11),m3h2x2(:,95),heltab2x4(:,:,142))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMT,G2H2(85),n2h2(43))
  call Hloop_AV_Q(ntryL,G1H4(12),ex4(:),G1H2(11),m3h2x2(:,96),heltab2x4(:,:,143))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMT,G2H2(86),n2h2(44))
  call Hloop_AV_Q(ntryL,G1H4(1),ex4(:),G1H2(11),m3h2x2(:,97),heltab2x4(:,:,144))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMT,G2H2(87),n2h2(45))
  call Hloop_AV_Q(ntryL,G1H4(2),ex4(:),G1H2(11),m3h2x2(:,98),heltab2x4(:,:,145))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMB,G2H2(88),n2h2(46))
call HGT_OLR(G1H4(3),1,1,4)
call HGT_invQ_OLR(G1H4(3),2,5,4)
  call Hloop_ST_V(ntryL,G1H4(3),-4,ex3(:),4,G2H4(87),m3h1x4(:,48),heltab2x4(:,:,146))
  call Hloop_AV_Q(ntryL,G1H4(5),ex4(:),G1H2(11),m3h2x2(:,99),heltab2x4(:,:,147))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMB,G2H2(89),n2h2(47))
  call Hloop_AV_Q(ntryL,G1H4(6),ex4(:),G1H2(11),m3h2x2(:,100),heltab2x4(:,:,148))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMB,G2H2(90),n2h2(48))
  call Hloop_AV_Q(ntryL,G1H4(9),ex4(:),G1H2(11),m3h2x2(:,101),heltab2x4(:,:,149))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMB,G2H2(91),n2h2(49))
  call Hloop_AV_Q(ntryL,G1H4(11),ex4(:),G1H2(11),m3h2x2(:,102),heltab2x4(:,:,150))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMT,G2H2(92),n2h2(50))
call HGT_OLR(G1H4(14),1,1,4)
call HGT_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_ST_V(ntryL,G1H4(14),-4,ex3(:),4,G2H4(88),m3h1x4(:,49),heltab2x4(:,:,151))
  call Hloop_AV_Q(ntryL,G1H4(15),ex4(:),G1H2(11),m3h2x2(:,103),heltab2x4(:,:,152))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMT,G2H2(93),n2h2(51))
  call Hloop_AV_Q(ntryL,G1H4(16),ex4(:),G1H2(11),m3h2x2(:,104),heltab2x4(:,:,153))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMT,G2H2(94),n2h2(52))
  call Hloop_AV_Q(ntryL,G1H4(17),ex4(:),G1H2(11),m3h2x2(:,105),heltab2x4(:,:,154))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMT,G2H2(95),n2h2(53))
  call Hloop_AV_Q(ntryL,G1H4(18),ex4(:),G1H2(11),m3h2x2(:,106),heltab2x4(:,:,155))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMT,G2H2(96),n2h2(54))
call HGT_raise_alpha_OLR(G1H4(19),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(19),2,5,4)
  call Hloop_VS_V(ntryL,G1H4(19),ex3(:),G1H4(42),m3h1x4(:,50),heltab2x4(:,:,156))
  call Hloop_AV_Q(ntryL,G1H4(29),ex4(:),G1H2(11),m3h2x2(:,107),heltab2x4(:,:,157))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMT,G2H2(97),n2h2(55))
  call Hloop_AV_Q(ntryL,G1H4(30),ex4(:),G1H2(11),m3h2x2(:,108),heltab2x4(:,:,158))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMT,G2H2(98),n2h2(56))
  call Hloop_AV_Q(ntryL,G1H4(31),ex4(:),G1H2(11),m3h2x2(:,109),heltab2x4(:,:,159))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMT,G2H2(99),n2h2(57))
  call Hloop_QS_A(ntryL,G1H4(43),ex3(:),G1H4(127),ngH,m3h1x4(:,51),heltab2x4(:,:,160))
  call Hloop_Q_A(ntryL,G1H4(127),21,nMT,G2H4(89),n2h4(193))
call HGT_OLR(G1H4(44),1,1,4)
call HGT_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_TV_S(ntryL,G1H4(44),-8,ex4(:),8,G2H2(100),m3h2x2(:,110),heltab2x4(:,:,161))
  call Hloop_QS_A(ntryL,G1H4(46),ex3(:),G1H4(41),ngH,m3h1x4(:,52),heltab2x4(:,:,162))
  call Hloop_Q_A(ntryL,G1H4(41),21,nMT,G2H4(90),n2h4(195))
  call Hloop_QS_A(ntryL,G1H4(47),ex3(:),G1H4(27),ngH,m3h1x4(:,53),heltab2x4(:,:,163))
  call Hloop_Q_A(ntryL,G1H4(27),21,nMT,G2H4(91),n2h4(196))
  call Hloop_QS_A(ntryL,G1H4(48),ex3(:),G1H4(50),ngH,m3h1x4(:,54),heltab2x4(:,:,164))
  call Hloop_Q_A(ntryL,G1H4(50),21,nMT,G2H4(92),n2h4(197))
  call Hloop_QS_A(ntryL,G1H4(57),ex3(:),G1H4(53),ngH,m3h1x4(:,55),heltab2x4(:,:,165))
  call Hloop_Q_A(ntryL,G1H4(53),21,nMT,G2H4(93),n2h4(198))
call HGT_raise_alpha_OLR(G1H4(58),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(58),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(58),ex4(:),G1H2(11),m3h2x2(:,111),heltab2x4(:,:,166))
  call Hloop_QS_A(ntryL,G1H4(60),ex3(:),G1H4(128),ngH,m3h1x4(:,56),heltab2x4(:,:,167))
  call Hloop_Q_A(ntryL,G1H4(128),21,nMT,G2H4(94),n2h4(200))
  call Hloop_QS_A(ntryL,G1H4(61),ex3(:),G1H4(54),ngH,m3h1x4(:,57),heltab2x4(:,:,168))
  call Hloop_Q_A(ntryL,G1H4(54),21,nMT,G2H4(95),n2h4(201))
  call Hloop_QS_A(ntryL,G1H4(62),ex3(:),G1H4(36),ngH,m3h1x4(:,58),heltab2x4(:,:,169))
  call Hloop_Q_A(ntryL,G1H4(36),21,nMT,G2H4(96),n2h4(202))
  call Hloop_QS_A(ntryL,G1H4(63),ex3(:),G1H4(51),ngH,m3h1x4(:,59),heltab2x4(:,:,170))
  call Hloop_Q_A(ntryL,G1H4(51),21,nMT,G2H4(97),n2h4(203))
call HGT_OLR(G1H4(66),1,1,4)
call HGT_invQ_OLR(G1H4(66),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(66),ex4(:),G1H2(12),m3h2x2(:,112),heltab2x4(:,:,171))
  call Hloop_QS_A(ntryL,G1H4(70),ex3(:),G1H4(26),ngH,m3h1x4(:,60),heltab2x4(:,:,172))
  call Hloop_Q_A(ntryL,G1H4(26),21,nMT,G2H4(98),n2h4(205))
  call Hloop_QS_A(ntryL,G1H4(71),ex3(:),G1H4(55),ngH,m3h1x4(:,61),heltab2x4(:,:,173))
  call Hloop_Q_A(ntryL,G1H4(55),21,nMT,G2H4(99),n2h4(206))
  call Hloop_QS_A(ntryL,G1H4(72),ex3(:),G1H4(35),ngH,m3h1x4(:,62),heltab2x4(:,:,174))
  call Hloop_Q_A(ntryL,G1H4(35),21,nMT,G2H4(100),n2h4(207))
  call Hloop_QS_A(ntryL,G1H4(78),ex3(:),G1H4(65),ngH,m3h1x4(:,63),heltab2x4(:,:,175))
  call Hloop_Q_A(ntryL,G1H4(65),21,nMT,G2H4(101),n2h4(208))
call HGT_raise_alpha_OLR(G1H4(81),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(81),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(81),-8,ex4(:),8,G2H2(101),m3h2x2(:,113),heltab2x4(:,:,176))
  call Hloop_QS_A(ntryL,G1H4(83),ex3(:),G1H4(69),ngH,m3h1x4(:,64),heltab2x4(:,:,177))
  call Hloop_Q_A(ntryL,G1H4(69),21,nMT,G2H4(102),n2h4(210))
  call Hloop_QS_A(ntryL,G1H4(84),ex3(:),G1H4(126),ngH,m3h1x4(:,65),heltab2x4(:,:,178))
  call Hloop_Q_A(ntryL,G1H4(126),21,nMT,G2H4(103),n2h4(211))
  call Hloop_QS_A(ntryL,G1H4(85),ex3(:),G1H4(68),ngH,m3h1x4(:,66),heltab2x4(:,:,179))
  call Hloop_Q_A(ntryL,G1H4(68),21,nMT,G2H4(104),n2h4(212))
  call Hloop_QS_A(ntryL,G1H4(86),ex3(:),G1H4(39),ngH,m3h1x4(:,67),heltab2x4(:,:,180))
  call Hloop_Q_A(ntryL,G1H4(39),21,nMB,G2H4(105),n2h4(213))
call HGT_OLR(G1H4(87),1,1,4)
call HGT_invQ_OLR(G1H4(87),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(87),ex2(:),G1H2(13),ngX,m3h2x2(:,114),heltab2x4(:,:,181))
  call Hloop_QS_A(ntryL,G1H4(91),ex3(:),G1H4(75),ngH,m3h1x4(:,68),heltab2x4(:,:,182))
  call Hloop_Q_A(ntryL,G1H4(75),21,nMB,G2H4(106),n2h4(215))
  call Hloop_QS_A(ntryL,G1H4(129),ex3(:),G1H4(37),ngH,m3h1x4(:,69),heltab2x4(:,:,183))
  call Hloop_Q_A(ntryL,G1H4(37),21,nMB,G2H4(107),n2h4(216))
  call Hloop_QS_A(ntryL,G1H4(130),ex3(:),G1H4(76),ngH,m3h1x4(:,70),heltab2x4(:,:,184))
  call Hloop_Q_A(ntryL,G1H4(76),21,nMB,G2H4(108),n2h4(217))
  call Hloop_QS_A(ntryL,G1H4(131),ex3(:),G1H4(74),ngH,m3h1x4(:,71),heltab2x4(:,:,185))
  call Hloop_Q_A(ntryL,G1H4(74),21,nMB,G2H4(109),n2h4(218))
call HGT_OLR(G1H4(132),1,1,4)
call HGT_invQ_OLR(G1H4(132),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(132),ex2(:),G1H2(14),ngH,m3h2x2(:,115),heltab2x4(:,:,186))
  call Hloop_QS_A(ntryL,G1H4(134),ex3(:),G1H4(79),ngH,m3h1x4(:,72),heltab2x4(:,:,187))
  call Hloop_Q_A(ntryL,G1H4(79),21,nMB,G2H4(110),n2h4(220))
  call Hloop_QS_A(ntryL,G1H4(135),ex3(:),G1H4(89),ngH,m3h1x4(:,73),heltab2x4(:,:,188))
  call Hloop_Q_A(ntryL,G1H4(89),21,nMB,G2H4(111),n2h4(221))
  call Hloop_QS_A(ntryL,G1H4(136),ex3(:),G1H4(88),ngH,m3h1x4(:,74),heltab2x4(:,:,189))
  call Hloop_Q_A(ntryL,G1H4(88),21,nMB,G2H4(112),n2h4(222))
  call Hloop_QS_A(ntryL,G1H4(137),ex3(:),G1H4(93),ngH,m3h1x4(:,75),heltab2x4(:,:,190))
  call Hloop_Q_A(ntryL,G1H4(93),21,nMT,G2H4(113),n2h4(223))
call HGT_OLR(G1H4(138),1,1,4)
call HGT_invQ_OLR(G1H4(138),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(138),ex2(:),G1H2(15),ngPbt,m3h2x2(:,116),heltab2x4(:,:,191))
  call Hloop_QS_A(ntryL,G1H4(140),ex3(:),G1H4(92),ngH,m3h1x4(:,76),heltab2x4(:,:,192))
  call Hloop_Q_A(ntryL,G1H4(92),21,nMT,G2H4(114),n2h4(225))
  call Hloop_QS_A(ntryL,G1H4(141),ex3(:),G1H4(98),ngH,m3h1x4(:,77),heltab2x4(:,:,193))
  call Hloop_Q_A(ntryL,G1H4(98),21,nMT,G2H4(115),n2h4(226))
  call Hloop_QS_A(ntryL,G1H4(142),ex3(:),G1H4(96),ngH,m3h1x4(:,78),heltab2x4(:,:,194))
  call Hloop_Q_A(ntryL,G1H4(96),21,nMT,G2H4(116),n2h4(227))
  call Hloop_QS_A(ntryL,G1H4(95),ex3(:),G1H4(111),ngH,m3h1x4(:,79),heltab2x4(:,:,195))
  call Hloop_Q_A(ntryL,G1H4(111),21,nMT,G2H4(117),n2h4(228))
call HGT_raise_alpha_OLR(G1H4(94),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(94),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(94),ex2(:),G1H2(16),m3h2x2(:,117),heltab2x4(:,:,196))
  call Hloop_QS_A(ntryL,G1H4(145),ex3(:),G1H4(112),ngH,m3h1x4(:,80),heltab2x4(:,:,197))
  call Hloop_Q_A(ntryL,G1H4(112),21,nMT,G2H4(118),n2h4(230))
  call Hloop_QS_A(ntryL,G1H4(146),ex3(:),G1H4(110),ngH,m3h1x4(:,81),heltab2x4(:,:,198))
  call Hloop_Q_A(ntryL,G1H4(110),21,nMT,G2H4(119),n2h4(231))
  call Hloop_QS_A(ntryL,G1H4(147),ex3(:),G1H4(115),ngH,m3h1x4(:,82),heltab2x4(:,:,199))
  call Hloop_Q_A(ntryL,G1H4(115),21,nMT,G2H4(120),n2h4(232))
  call Hloop_QV_A(ntryL,G1H4(102),ex4(:),G1H2(17),m3h2x2(:,118),heltab2x4(:,:,200))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMB,G2H2(102),n2h2(58))
call HGT_OLR(G1H4(103),1,1,4)
call HGT_invQ_OLR(G1H4(103),2,5,4)
  call Hloop_SS_S(ntryL,G1H4(103),ex3(:),G1H4(120),m3h1x4(:,83),heltab2x4(:,:,201))
  call Hloop_QV_A(ntryL,G1H4(105),ex4(:),G1H2(17),m3h2x2(:,119),heltab2x4(:,:,202))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMB,G2H2(103),n2h2(59))
  call Hloop_QV_A(ntryL,G1H4(106),ex4(:),G1H2(17),m3h2x2(:,120),heltab2x4(:,:,203))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMB,G2H2(104),n2h2(60))
  call Hloop_QV_A(ntryL,G1H4(148),ex4(:),G1H2(17),m3h2x2(:,121),heltab2x4(:,:,204))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMB,G2H2(105),n2h2(61))
  call Hloop_QV_A(ntryL,G1H4(149),ex4(:),G1H2(17),m3h2x2(:,122),heltab2x4(:,:,205))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMB,G2H2(106),n2h2(62))
call HGT_OLR(G1H4(150),1,1,4)
call HGT_invQ_OLR(G1H4(150),2,5,4)
  call Hloop_SS_S(ntryL,G1H4(150),ex3(:),G1H4(121),m3h1x4(:,84),heltab2x4(:,:,206))
  call Hloop_QV_A(ntryL,G1H4(152),ex4(:),G1H2(17),m3h2x2(:,123),heltab2x4(:,:,207))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMB,G2H2(107),n2h2(63))
  call Hloop_QV_A(ntryL,G1H4(153),ex4(:),G1H2(17),m3h2x2(:,124),heltab2x4(:,:,208))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMB,G2H2(108),n2h2(64))
  call Hloop_QV_A(ntryL,G1H4(154),ex4(:),G1H2(17),m3h2x2(:,125),heltab2x4(:,:,209))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMB,G2H2(109),n2h2(65))
  call Hloop_QV_A(ntryL,G1H4(155),ex4(:),G1H2(17),m3h2x2(:,126),heltab2x4(:,:,210))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMT,G2H2(110),n2h2(66))
call HGT_OLR(G1H4(156),1,1,4)
call HGT_invQ_OLR(G1H4(156),2,5,4)
  call Hloop_SS_S(ntryL,G1H4(156),ex3(:),G1H4(119),m3h1x4(:,85),heltab2x4(:,:,211))
  call Hloop_QV_A(ntryL,G1H4(158),ex4(:),G1H2(17),m3h2x2(:,127),heltab2x4(:,:,212))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMT,G2H2(111),n2h2(67))
  call Hloop_QV_A(ntryL,G1H4(159),ex4(:),G1H2(17),m3h2x2(:,128),heltab2x4(:,:,213))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMT,G2H2(112),n2h2(68))
  call Hloop_QV_A(ntryL,G1H4(160),ex4(:),G1H2(17),m3h2x2(:,129),heltab2x4(:,:,214))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMT,G2H2(113),n2h2(69))
  call Hloop_QV_A(ntryL,G1H4(107),ex4(:),G1H2(17),m3h2x2(:,130),heltab2x4(:,:,215))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMT,G2H2(114),n2h2(70))
call HGT_raise_alpha_OLR(G1H4(108),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(108),2,5,4)
  call Hloop_VT_S(ntryL,G1H4(108),-4,ex3(:),4,G2H4(121),m3h1x4(:,86),heltab2x4(:,:,216))
  call Hloop_QV_A(ntryL,G1H4(161),ex4(:),G1H2(17),m3h2x2(:,131),heltab2x4(:,:,217))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMT,G2H2(115),n2h2(71))
  call Hloop_QV_A(ntryL,G1H4(162),ex4(:),G1H2(17),m3h2x2(:,132),heltab2x4(:,:,218))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMT,G2H2(116),n2h2(72))
  call Hloop_QV_A(ntryL,G1H4(163),ex4(:),G1H2(17),m3h2x2(:,133),heltab2x4(:,:,219))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMT,G2H2(117),n2h2(73))
  call Hloop_QV_A(ntryL,G1H4(164),ex4(:),G1H2(17),m3h2x2(:,134),heltab2x4(:,:,220))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMB,G2H2(118),n2h2(74))
call HGT_OLR(G1H4(165),1,1,4)
call HGT_invQ_OLR(G1H4(165),2,5,4)
  call Hloop_ST_V(ntryL,G1H4(165),-4,ex3(:),4,G2H4(122),m3h1x4(:,87),heltab2x4(:,:,221))
  call Hloop_QV_A(ntryL,G1H4(167),ex4(:),G1H2(17),m3h2x2(:,135),heltab2x4(:,:,222))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMB,G2H2(119),n2h2(75))
  call Hloop_QV_A(ntryL,G1H4(168),ex4(:),G1H2(17),m3h2x2(:,136),heltab2x4(:,:,223))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMB,G2H2(120),n2h2(76))
  call Hloop_QV_A(ntryL,G1H4(169),ex4(:),G1H2(17),m3h2x2(:,137),heltab2x4(:,:,224))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMB,G2H2(121),n2h2(77))
  call Hloop_QV_A(ntryL,G1H4(170),ex4(:),G1H2(17),m3h2x2(:,138),heltab2x4(:,:,225))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMT,G2H2(122),n2h2(78))
call HGT_OLR(G1H4(171),1,1,4)
call HGT_invQ_OLR(G1H4(171),2,5,4)
  call Hloop_ST_V(ntryL,G1H4(171),-4,ex3(:),4,G2H4(123),m3h1x4(:,88),heltab2x4(:,:,226))
  call Hloop_QV_A(ntryL,G1H4(173),ex4(:),G1H2(17),m3h2x2(:,139),heltab2x4(:,:,227))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMT,G2H2(123),n2h2(79))
  call Hloop_QV_A(ntryL,G1H4(174),ex4(:),G1H2(17),m3h2x2(:,140),heltab2x4(:,:,228))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMT,G2H2(124),n2h2(80))
  call Hloop_QV_A(ntryL,G1H4(175),ex4(:),G1H2(17),m3h2x2(:,141),heltab2x4(:,:,229))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMT,G2H2(125),n2h2(81))
  call Hloop_QV_A(ntryL,G1H4(113),ex4(:),G1H2(17),m3h2x2(:,142),heltab2x4(:,:,230))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMT,G2H2(126),n2h2(82))
call HGT_raise_alpha_OLR(G1H4(114),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(114),2,5,4)
  call Hloop_VS_V(ntryL,G1H4(114),ex3(:),G1H4(8),m3h1x4(:,89),heltab2x4(:,:,231))
  call Hloop_QV_A(ntryL,G1H4(177),ex4(:),G1H2(17),m3h2x2(:,143),heltab2x4(:,:,232))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMT,G2H2(127),n2h2(83))
  call Hloop_QV_A(ntryL,G1H4(178),ex4(:),G1H2(17),m3h2x2(:,144),heltab2x4(:,:,233))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMT,G2H2(128),n2h2(84))
  call Hloop_QV_A(ntryL,G1H4(179),ex4(:),G1H2(17),m3h2x2(:,145),heltab2x4(:,:,234))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMT,G2H2(129),n2h2(85))
  call Hloop_QV_A(ntryL,G1H4(180),ex4(:),G1H2(17),m3h2x2(:,146),heltab2x4(:,:,235))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMB,G2H2(130),n2h2(86))
call HGT_OLR(G1H4(181),1,1,4)
call HGT_invQ_OLR(G1H4(181),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(181),ex2(:),G1H2(17),ngX,m3h2x2(:,147),heltab2x4(:,:,236))
  call Hloop_QV_A(ntryL,G1H4(183),ex4(:),G1H2(18),m3h2x2(:,148),heltab2x4(:,:,237))
  call Hloop_Q_A(ntryL,G1H2(18),25,nMB,G2H2(131),n2h2(87))
  call Hloop_QV_A(ntryL,G1H4(184),ex4(:),G1H2(18),m3h2x2(:,149),heltab2x4(:,:,238))
  call Hloop_Q_A(ntryL,G1H2(18),25,nMB,G2H2(132),n2h2(88))
  call Hloop_QV_A(ntryL,G1H4(185),ex4(:),G1H2(18),m3h2x2(:,150),heltab2x4(:,:,239))
  call Hloop_Q_A(ntryL,G1H2(18),25,nMB,G2H2(133),n2h2(89))
  call Hloop_QV_A(ntryL,G1H4(186),ex4(:),G1H2(18),m3h2x2(:,151),heltab2x4(:,:,240))
  call Hloop_Q_A(ntryL,G1H2(18),25,nMB,G2H2(134),n2h2(90))
call HGT_OLR(G1H4(187),1,1,4)
call HGT_invQ_OLR(G1H4(187),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(187),ex2(:),G1H2(18),ngH,m3h2x2(:,152),heltab2x4(:,:,241))
  call Hloop_QV_A(ntryL,G1H4(189),ex4(:),G1H2(19),m3h2x2(:,153),heltab2x4(:,:,242))
  call Hloop_Q_A(ntryL,G1H2(19),25,nMB,G2H2(135),n2h2(91))
  call Hloop_QV_A(ntryL,G1H4(190),ex4(:),G1H2(19),m3h2x2(:,154),heltab2x4(:,:,243))
  call Hloop_Q_A(ntryL,G1H2(19),25,nMB,G2H2(136),n2h2(92))
  call Hloop_QV_A(ntryL,G1H4(191),ex4(:),G1H2(19),m3h2x2(:,155),heltab2x4(:,:,244))
  call Hloop_Q_A(ntryL,G1H2(19),25,nMB,G2H2(137),n2h2(93))
  call Hloop_QV_A(ntryL,G1H4(192),ex4(:),G1H2(19),m3h2x2(:,156),heltab2x4(:,:,245))
  call Hloop_Q_A(ntryL,G1H2(19),25,nMT,G2H2(138),n2h2(94))
call HGT_OLR(G1H4(193),1,1,4)
call HGT_invQ_OLR(G1H4(193),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(193),ex2(:),G1H2(19),ngPbt,m3h2x2(:,157),heltab2x4(:,:,246))
  call Hloop_QV_A(ntryL,G1H4(195),ex4(:),G1H2(20),m3h2x2(:,158),heltab2x4(:,:,247))
  call Hloop_Q_A(ntryL,G1H2(20),25,nMT,G2H2(139),n2h2(95))
  call Hloop_QV_A(ntryL,G1H4(196),ex4(:),G1H2(20),m3h2x2(:,159),heltab2x4(:,:,248))
  call Hloop_Q_A(ntryL,G1H2(20),25,nMT,G2H2(140),n2h2(96))
  call Hloop_QV_A(ntryL,G1H4(197),ex4(:),G1H2(20),m3h2x2(:,160),heltab2x4(:,:,249))
  call Hloop_Q_A(ntryL,G1H2(20),25,nMT,G2H2(141),n2h2(97))
  call Hloop_QV_A(ntryL,G1H4(117),ex4(:),G1H2(20),m3h2x2(:,161),heltab2x4(:,:,250))
  call Hloop_Q_A(ntryL,G1H2(20),25,nMT,G2H2(142),n2h2(98))
call HGT_raise_alpha_OLR(G1H4(118),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(118),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(118),ex2(:),G1H2(20),m3h2x2(:,162),heltab2x4(:,:,251))
  call Hloop_QV_A(ntryL,G1H4(199),ex4(:),G1H2(21),m3h2x2(:,163),heltab2x4(:,:,252))
  call Hloop_Q_A(ntryL,G1H2(21),25,nMT,G2H2(143),n2h2(99))
  call Hloop_QV_A(ntryL,G1H4(200),ex4(:),G1H2(21),m3h2x2(:,164),heltab2x4(:,:,253))
  call Hloop_Q_A(ntryL,G1H2(21),25,nMT,G2H2(144),n2h2(100))
  call Hloop_QV_A(ntryL,G1H4(201),ex4(:),G1H2(21),m3h2x2(:,165),heltab2x4(:,:,254))
  call Hloop_Q_A(ntryL,G1H2(21),25,nMT,G2H2(145),n2h2(101))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(29),[G2H4(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(36),[G2H4(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(23),[G2H4(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(28),[G2H4(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G2H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G2H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(44),[G2H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(54),[G2H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(42),[G2H4(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(49),[G2H4(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G2H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G2H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(34),[G2H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(35),[G2H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G2H2(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(49),[G2H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G1H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G1H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(57),[G1H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(59),[G1H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G1H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G1H4(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G1H4(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G1H4(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(21),[G1H4(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(22),[G1H4(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(19),[G1H4(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(61),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(63),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(65),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(68),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(67),[G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(69),[G1H2(7)])
  call Hotf_5pt_reduction(G2H4(63),RedSet_5(1),mass5set(:,8),  & 
G1H4(10),G1H4(12),G1H4(1),G1H4(2),G1H4(3),G1H4(5),4)
  call HG1shiftOLR(G1H4(12),8,4)
  call Hotf_5pt_reduction(G2H4(64),RedSet_5(1),mass5set(:,9),  & 
G1H4(6),G1H4(9),G1H4(11),G1H4(14),G1H4(15),G1H4(16),4)
  call HG1shiftOLR(G1H4(9),8,4)
  call Hotf_5pt_reduction(G2H4(65),RedSet_5(1),mass5set(:,10),  & 
G1H4(17),G1H4(18),G1H4(19),G1H4(29),G1H4(30),G1H4(31),4)
  call HG1shiftOLR(G1H4(18),8,4)
  call Hloop_QA_S(ntryL,G2H4(29),ex2(:),G2H2(2),ngPbt,m3h2x2(:,166),heltab2x4(:,:,255))
  call Hotf_5pt_reduction(G2H4(67),RedSet_5(1),mass5set(:,11),  & 
G1H4(43),G1H4(127),G1H4(44),G1H4(46),G1H4(41),G1H4(47),4)
  call HG1shiftOLR(G1H4(127),8,4)
  call Hotf_5pt_reduction(G2H4(68),RedSet_5(1),mass5set(:,9),  & 
G1H4(27),G1H4(48),G1H4(50),G1H4(57),G1H4(53),G1H4(58),4)
  call HG1shiftOLR(G1H4(48),8,4)
  call Hotf_5pt_reduction(G2H4(69),RedSet_5(1),mass5set(:,10),  & 
G1H4(60),G1H4(128),G1H4(61),G1H4(54),G1H4(62),G1H4(36),4)
  call HG1shiftOLR(G1H4(128),8,4)
  call Hloop_QA_W(ntryL,G2H4(36),ex2(:),G2H2(3),m3h2x2(:,167),heltab2x4(:,:,256))
  call Hloop_QA_S(ntryL,G2H4(23),ex2(:),G2H2(16),ngPbt,m3h2x2(:,168),heltab2x4(:,:,257))
  call Hloop_QA_W(ntryL,G2H4(28),ex2(:),G2H2(17),m3h2x2(:,169),heltab2x4(:,:,258))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(9),mass5set(:,12),  & 
G1H2(21),G1H2(1),G1H2(2),G1H2(4),G1H2(3),G1H2(6),2)
  call HG1shiftOLR(G1H2(1),8,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(9),mass5set(:,13),  & 
G1H2(5),G1H2(8),G1H2(7),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(8),8,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(9),mass5set(:,14),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),8,2)
  call Hloop_SS_S(ntryL,G2H2(4),ex3(:),G2H2(30),m3h1x2(:,1),heltab2x2(:,:,1))
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(9),mass5set(:,15),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),8,2)
  call Hloop_SS_S(ntryL,G2H2(8),ex3(:),G2H2(31),m3h1x2(:,2),heltab2x2(:,:,2))
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(9),mass5set(:,16),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),8,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(9),mass5set(:,16),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(44),8,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(9),mass5set(:,16),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(50),8,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(9),mass5set(:,16),  & 
G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(56),8,2)
  call Hloop_VS_V(ntryL,G2H2(13),ex3(:),G2H2(44),m3h1x2(:,3),heltab2x2(:,:,3))
  call Hloop_VS_V(ntryL,G2H2(14),ex3(:),G2H2(45),m3h1x2(:,4),heltab2x2(:,:,4))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(2),mass5set(:,8),  & 
G1H4(63),G1H4(51),G1H4(66),G1H4(70),G1H4(26),G1H4(71),4)
  call HG1shiftOLR(G1H4(51),8,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(2),mass5set(:,9),  & 
G1H4(55),G1H4(72),G1H4(35),G1H4(78),G1H4(65),G1H4(81),4)
  call HG1shiftOLR(G1H4(72),8,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(2),mass5set(:,10),  & 
G1H4(83),G1H4(69),G1H4(84),G1H4(126),G1H4(85),G1H4(68),4)
  call HG1shiftOLR(G1H4(69),8,4)
  call Hloop_AQ_S(ntryL,G2H4(44),ex1(:),G2H2(1),ngPtb,m3h2x2(:,170),heltab2x4(:,:,259))
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(2),mass5set(:,11),  & 
G1H4(86),G1H4(39),G1H4(87),G1H4(91),G1H4(75),G1H4(129),4)
  call HG1shiftOLR(G1H4(39),8,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(2),mass5set(:,9),  & 
G1H4(37),G1H4(130),G1H4(76),G1H4(131),G1H4(74),G1H4(132),4)
  call HG1shiftOLR(G1H4(130),8,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(2),mass5set(:,10),  & 
G1H4(134),G1H4(79),G1H4(135),G1H4(89),G1H4(136),G1H4(88),4)
  call HG1shiftOLR(G1H4(79),8,4)
  call Hloop_AQ_W(ntryL,G2H4(54),ex1(:),G2H2(6),m3h2x2(:,171),heltab2x4(:,:,260))
  call Hloop_AQ_S(ntryL,G2H4(42),ex1(:),G2H2(7),ngPtb,m3h2x2(:,172),heltab2x4(:,:,261))
  call Hloop_AQ_W(ntryL,G2H4(49),ex1(:),G2H2(4),m3h2x2(:,173),heltab2x4(:,:,262))
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(10),mass5set(:,12),  & 
G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(62),4,2)
  call Hotf_5pt_reduction(G2H2(20),RedSet_5(10),mass5set(:,13),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(68),4,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(10),mass5set(:,14),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
  call HG1shiftOLR(G1H2(74),4,2)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(10),mass5set(:,16),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
  call HG1shiftOLR(G1H2(80),4,2)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(10),mass5set(:,15),  & 
G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(86),4,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(10),mass5set(:,16),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),2)
  call HG1shiftOLR(G1H2(92),4,2)
  call Hloop_SV_V(ntryL,G2H2(23),ex4(:),G2H1(1),m3h2x1(:,1),heltab2x2(:,:,5))
  call Hloop_VV_S(ntryL,G2H2(24),ex4(:),G2H1(2),m3h2x1(:,2),heltab2x2(:,:,6))
  call Hloop_SV_V(ntryL,G2H2(25),ex4(:),G2H1(3),m3h2x1(:,3),heltab2x2(:,:,7))
  call Hloop_VV_S(ntryL,G2H2(26),ex4(:),G2H1(4),m3h2x1(:,4),heltab2x2(:,:,8))
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(10),mass5set(:,16),  & 
G1H2(97),G1H2(98),G1H2(99),G1H2(100),G1H2(101),G1H2(102),2)
  call HG1shiftOLR(G1H2(98),4,2)
  call Hotf_5pt_reduction(G2H2(28),RedSet_5(10),mass5set(:,16),  & 
G1H2(103),G1H2(104),G1H2(105),G1H2(106),G1H2(107),G1H2(108),2)
  call HG1shiftOLR(G1H2(104),4,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(11),mass5set(:,12),  & 
G1H2(109),G1H2(110),G1H2(111),G1H2(112),G1H2(113),G1H2(114),2)
  call HG1shiftOLR(G1H2(110),8,2)
  call Hotf_5pt_reduction(G2H2(34),RedSet_5(11),mass5set(:,13),  & 
G1H2(115),G1H2(116),G1H2(117),G1H2(118),G1H2(119),G1H2(120),2)
  call HG1shiftOLR(G1H2(116),8,2)
  call Hotf_5pt_reduction(G2H2(35),RedSet_5(11),mass5set(:,14),  & 
G1H2(121),G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),2)
  call HG1shiftOLR(G1H2(122),8,2)
  call Hloop_SS_S(ntryL,G2H2(32),ex3(:),G2H2(5),m3h1x2(:,5),heltab2x2(:,:,9))
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(11),mass5set(:,15),  & 
G1H2(127),G1H2(128),G1H2(129),G1H2(130),G1H2(131),G1H2(132),2)
  call HG1shiftOLR(G1H2(128),8,2)
  call Hloop_SS_S(ntryL,G2H2(36),ex3(:),G2H2(8),m3h1x2(:,6),heltab2x2(:,:,10))
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(11),mass5set(:,16),  & 
G1H2(133),G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),2)
  call HG1shiftOLR(G1H2(134),8,2)
  call Hotf_5pt_reduction(G2H2(38),RedSet_5(11),mass5set(:,16),  & 
G1H2(139),G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),2)
  call HG1shiftOLR(G1H2(140),8,2)
  call Hotf_5pt_reduction(G2H2(39),RedSet_5(11),mass5set(:,16),  & 
G1H2(145),G1H2(146),G1H2(147),G1H2(148),G1H2(149),G1H2(150),2)
  call HG1shiftOLR(G1H2(146),8,2)
  call Hotf_5pt_reduction(G2H2(40),RedSet_5(11),mass5set(:,16),  & 
G1H2(151),G1H2(152),G1H2(153),G1H2(154),G1H2(155),G1H2(156),2)
  call HG1shiftOLR(G1H2(152),8,2)
  call Hloop_VS_V(ntryL,G2H2(41),ex3(:),G2H2(9),m3h1x2(:,7),heltab2x2(:,:,11))
  call Hloop_VS_V(ntryL,G2H2(42),ex3(:),G2H2(10),m3h1x2(:,8),heltab2x2(:,:,12))
  call Hotf_5pt_reduction(G2H2(43),RedSet_5(12),mass5set(:,12),  & 
G1H2(157),G1H2(158),G1H2(159),G1H2(160),G1H2(161),G1H2(162),2)
  call HG1shiftOLR(G1H2(158),4,2)
  call Hotf_5pt_reduction(G2H2(48),RedSet_5(12),mass5set(:,13),  & 
G1H2(163),G1H2(164),G1H2(165),G1H2(166),G1H2(167),G1H2(168),2)
  call HG1shiftOLR(G1H2(164),4,2)
  call Hotf_5pt_reduction(G2H2(49),RedSet_5(12),mass5set(:,14),  & 
G1H2(169),G1H2(170),G1H2(171),G1H2(172),G1H2(173),G1H2(174),2)
  call HG1shiftOLR(G1H2(170),4,2)
  call Hotf_5pt_reduction(G2H2(46),RedSet_5(12),mass5set(:,16),  & 
G1H2(175),G1H2(176),G1H2(177),G1H2(178),G1H2(179),G1H2(180),2)
  call HG1shiftOLR(G1H2(176),4,2)
  call Hotf_5pt_reduction(G2H2(47),RedSet_5(12),mass5set(:,15),  & 
G1H2(181),G1H2(182),G1H2(183),G1H2(184),G1H2(185),G1H2(186),2)
  call HG1shiftOLR(G1H2(182),4,2)
  call Hotf_5pt_reduction(G2H2(50),RedSet_5(12),mass5set(:,16),  & 
G1H2(187),G1H2(188),G1H2(189),G1H2(190),G1H2(191),G1H2(192),2)
  call HG1shiftOLR(G1H2(188),4,2)
  call Hloop_SV_V(ntryL,G2H2(51),ex4(:),G2H1(5),m3h2x1(:,5),heltab2x2(:,:,13))
  call Hloop_VV_S(ntryL,G2H2(52),ex4(:),G2H1(6),m3h2x1(:,6),heltab2x2(:,:,14))
  call Hloop_SV_V(ntryL,G2H2(53),ex4(:),G2H1(7),m3h2x1(:,7),heltab2x2(:,:,15))
  call Hloop_VV_S(ntryL,G2H2(54),ex4(:),G2H1(8),m3h2x1(:,8),heltab2x2(:,:,16))
  call Hotf_5pt_reduction(G2H2(55),RedSet_5(12),mass5set(:,16),  & 
G1H2(193),G1H2(194),G1H2(195),G1H2(196),G1H2(197),G1H2(198),2)
  call HG1shiftOLR(G1H2(194),4,2)
  call Hotf_5pt_reduction(G2H2(56),RedSet_5(12),mass5set(:,16),  & 
G1H2(199),G1H2(200),G1H2(201),G1H2(202),G1H2(203),G1H2(204),2)
  call HG1shiftOLR(G1H2(200),4,2)
  call Hloop_SQ_A(ntryL,G1H4(22),ex1(:),G1H2(205),ngH,m3h2x2(:,174),heltab2x4(:,:,263))
  call Hloop_Q_A(ntryL,G1H2(205),23,nMB,G2H2(11),n2h2(102))
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(3),mass5set(:,17),  & 
G1H4(137),G1H4(93),G1H4(138),G1H4(140),G1H4(92),G1H4(141),4)
  call HG1shiftOLR(G1H4(93),8,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(3),mass5set(:,18),  & 
G1H4(98),G1H4(142),G1H4(96),G1H4(95),G1H4(111),G1H4(94),4)
  call HG1shiftOLR(G1H4(142),8,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(3),mass5set(:,17),  & 
G1H4(145),G1H4(112),G1H4(146),G1H4(110),G1H4(147),G1H4(115),4)
  call HG1shiftOLR(G1H4(112),8,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(3),mass5set(:,18),  & 
G1H4(102),G1H4(103),G1H4(105),G1H4(106),G1H4(148),G1H4(149),4)
  call HG1shiftOLR(G1H4(103),8,4)
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(4),mass5set(:,18),  & 
G1H2(205),G1H2(206),G1H2(207),G1H2(208),G1H2(209),G1H2(210),2)
  call HG1shiftOLR(G1H2(206),4,2)
  call Hotf_5pt_reduction(G2H2(59),RedSet_5(4),mass5set(:,18),  & 
G1H2(211),G1H2(212),G1H2(213),G1H2(214),G1H2(215),G1H2(216),2)
  call HG1shiftOLR(G1H2(212),4,2)
  call Hloop_AQ_S(ntryL,G2H2(58),ex1(:),G2H1(9),ngX,m3h2x1(:,9),heltab2x2(:,:,17))
  call Hloop_AQ_Z(ntryL,G2H2(60),ex1(:),G2H1(10),ngZd,m3h2x1(:,10),heltab2x2(:,:,18))
  call Hloop_SA_Q(ntryL,G1H4(32),ex2(:),G1H2(217),ngH,m3h2x2(:,175),heltab2x4(:,:,264))
  call Hloop_A_Q(ntryL,G1H2(217),23,nMB,G2H2(12),n2h2(103))
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(5),mass5set(:,17),  & 
G1H4(150),G1H4(152),G1H4(153),G1H4(154),G1H4(155),G1H4(156),4)
  call HG1shiftOLR(G1H4(152),8,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(5),mass5set(:,18),  & 
G1H4(158),G1H4(159),G1H4(160),G1H4(107),G1H4(108),G1H4(161),4)
  call HG1shiftOLR(G1H4(159),8,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(5),mass5set(:,17),  & 
G1H4(162),G1H4(163),G1H4(164),G1H4(165),G1H4(167),G1H4(168),4)
  call HG1shiftOLR(G1H4(163),8,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(5),mass5set(:,18),  & 
G1H4(169),G1H4(170),G1H4(171),G1H4(173),G1H4(174),G1H4(175),4)
  call HG1shiftOLR(G1H4(170),8,4)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(6),mass5set(:,19),  & 
G1H4(113),G1H4(114),G1H4(177),G1H4(178),G1H4(179),G1H4(180),4)
  call HG1shiftOLR(G1H4(114),2,4)
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(6),mass5set(:,5),  & 
G1H4(181),G1H4(183),G1H4(184),G1H4(185),G1H4(186),G1H4(187),4)
  call HG1shiftOLR(G1H4(183),2,4)
  call Hloop_VV_S(ntryL,G2H4(21),ex4(:),G2H2(13),m3h2x2(:,176),heltab2x4(:,:,265))
  call Hloop_SV_V(ntryL,G2H4(22),ex4(:),G2H2(14),m3h2x2(:,177),heltab2x4(:,:,266))
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(6),mass5set(:,19),  & 
G1H4(189),G1H4(190),G1H4(191),G1H4(192),G1H4(193),G1H4(195),4)
  call HG1shiftOLR(G1H4(190),2,4)
  call Hotf_5pt_reduction(G2H2(61),RedSet_5(7),mass5set(:,18),  & 
G1H2(217),G1H2(218),G1H2(219),G1H2(220),G1H2(221),G1H2(222),2)
  call HG1shiftOLR(G1H2(218),4,2)
  call Hotf_5pt_reduction(G2H2(63),RedSet_5(7),mass5set(:,18),  & 
G1H2(223),G1H2(224),G1H2(225),G1H2(226),G1H2(227),G1H2(228),2)
  call HG1shiftOLR(G1H2(224),4,2)
  call Hloop_QA_S(ntryL,G2H2(62),ex2(:),G2H1(11),ngX,m3h2x1(:,11),heltab2x2(:,:,19))
  call Hloop_QA_Z(ntryL,G2H2(64),ex2(:),G2H1(12),ngZd,m3h2x1(:,12),heltab2x2(:,:,20))
  call Hloop_SS_S(ntryL,G2H2(65),ex3(:),G2H2(15),m3h1x2(:,9),heltab2x2(:,:,21))
  call Hotf_5pt_reduction(G2H2(66),RedSet_5(8),mass5set(:,5),  & 
G1H2(229),G1H2(230),G1H2(231),G1H2(232),G1H2(233),G1H2(234),2)
  call HG1shiftOLR(G1H2(230),2,2)
  call Hotf_5pt_reduction(G2H2(68),RedSet_5(8),mass5set(:,19),  & 
G1H2(235),G1H2(236),G1H2(237),G1H2(238),G1H2(239),G1H2(240),2)
  call HG1shiftOLR(G1H2(236),2,2)
  call Hotf_5pt_reduction(G2H2(67),RedSet_5(8),mass5set(:,19),  & 
G1H2(241),G1H2(242),G1H2(243),G1H2(244),G1H2(245),G1H2(246),2)
  call HG1shiftOLR(G1H2(242),2,2)
  call Hloop_VS_V(ntryL,G2H2(69),ex3(:),G2H2(20),m3h1x2(:,10),heltab2x2(:,:,22))
  call Hloop_QA_S(ntryL,G2H4(24),ex2(:),G2H2(21),ngPbt,m3h2x2(:,178),heltab2x4(:,:,267))
  call Hloop_QA_S(ntryL,G2H4(25),ex2(:),G2H2(18),ngPbt,m3h2x2(:,179),heltab2x4(:,:,268))
  call Hloop_QA_S(ntryL,G2H4(30),ex2(:),G2H2(19),ngPbt,m3h2x2(:,180),heltab2x4(:,:,269))
  call Hloop_QA_S(ntryL,G2H4(31),ex2(:),G2H2(22),ngPbt,m3h2x2(:,181),heltab2x4(:,:,270))
  call Hloop_QA_W(ntryL,G2H4(35),ex2(:),G2H2(23),m3h2x2(:,182),heltab2x4(:,:,271))
  call Hloop_QA_W(ntryL,G2H4(34),ex2(:),G2H2(24),m3h2x2(:,183),heltab2x4(:,:,272))
  call Hloop_QA_W(ntryL,G2H4(38),ex2(:),G2H2(25),m3h2x2(:,184),heltab2x4(:,:,273))
  call Hloop_QA_W(ntryL,G2H4(39),ex2(:),G2H2(26),m3h2x2(:,185),heltab2x4(:,:,274))
  call Hloop_AQ_S(ntryL,G2H4(41),ex1(:),G2H2(27),ngPtb,m3h2x2(:,186),heltab2x4(:,:,275))
  call Hloop_AQ_S(ntryL,G2H4(43),ex1(:),G2H2(28),ngPtb,m3h2x2(:,187),heltab2x4(:,:,276))
  call Hloop_AQ_S(ntryL,G2H4(47),ex1(:),G2H2(29),ngPtb,m3h2x2(:,188),heltab2x4(:,:,277))
  call Hloop_AQ_S(ntryL,G2H4(48),ex1(:),G2H2(34),ngPtb,m3h2x2(:,189),heltab2x4(:,:,278))
  call Hloop_AQ_W(ntryL,G2H4(52),ex1(:),G2H2(35),m3h2x2(:,190),heltab2x4(:,:,279))
  call Hloop_AQ_W(ntryL,G2H4(53),ex1(:),G2H2(32),m3h2x2(:,191),heltab2x4(:,:,280))
  call Hloop_AQ_W(ntryL,G2H4(55),ex1(:),G2H2(33),m3h2x2(:,192),heltab2x4(:,:,281))
  call Hloop_AQ_W(ntryL,G2H4(56),ex1(:),G2H2(36),m3h2x2(:,193),heltab2x4(:,:,282))
  call Hloop_AQ_S(ntryL,G2H4(58),ex1(:),G2H2(37),ngPtb,m3h2x2(:,194),heltab2x4(:,:,283))
  call Hloop_AQ_S(ntryL,G2H4(60),ex1(:),G2H2(38),ngPtb,m3h2x2(:,195),heltab2x4(:,:,284))
  call Hloop_AQ_S(ntryL,G2H4(61),ex1(:),G2H2(39),ngPtb,m3h2x2(:,196),heltab2x4(:,:,285))
  call Hloop_AQ_S(ntryL,G2H4(62),ex1(:),G2H2(40),ngPtb,m3h2x2(:,197),heltab2x4(:,:,286))
  call Hloop_AQ_S(ntryL,G2H4(76),ex1(:),G2H2(41),ngPtb,m3h2x2(:,198),heltab2x4(:,:,287))
  call Hloop_AQ_S(ntryL,G2H4(77),ex1(:),G2H2(42),ngPtb,m3h2x2(:,199),heltab2x4(:,:,288))
  call Hloop_AQ_W(ntryL,G2H4(78),ex1(:),G2H2(43),m3h2x2(:,200),heltab2x4(:,:,289))
  call Hloop_AQ_W(ntryL,G2H4(80),ex1(:),G2H2(48),m3h2x2(:,201),heltab2x4(:,:,290))
  call Hloop_AQ_W(ntryL,G2H4(81),ex1(:),G2H2(49),m3h2x2(:,202),heltab2x4(:,:,291))
  call Hloop_AQ_W(ntryL,G2H4(82),ex1(:),G2H2(46),m3h2x2(:,203),heltab2x4(:,:,292))
  call Hloop_AQ_W(ntryL,G2H4(84),ex1(:),G2H2(47),m3h2x2(:,204),heltab2x4(:,:,293))
  call Hloop_AQ_W(ntryL,G2H4(85),ex1(:),G2H2(50),m3h2x2(:,205),heltab2x4(:,:,294))
  call Hloop_AQ_S(ntryL,G2H2(72),ex1(:),G2H1(13),ngH,m3h2x1(:,13),heltab2x2(:,:,23))
  call Hloop_AQ_S(ntryL,G2H2(74),ex1(:),G2H1(14),ngH,m3h2x1(:,14),heltab2x2(:,:,24))
  call Hloop_AQ_S(ntryL,G2H2(75),ex1(:),G2H1(15),ngH,m3h2x1(:,15),heltab2x2(:,:,25))
  call Hloop_AQ_S(ntryL,G2H2(76),ex1(:),G2H1(16),ngX,m3h2x1(:,16),heltab2x2(:,:,26))
  call Hloop_AQ_S(ntryL,G2H2(78),ex1(:),G2H1(17),ngX,m3h2x1(:,17),heltab2x2(:,:,27))
  call Hloop_AQ_S(ntryL,G2H2(79),ex1(:),G2H1(18),ngX,m3h2x1(:,18),heltab2x2(:,:,28))
  call Hloop_AQ_S(ntryL,G2H2(80),ex1(:),G2H1(19),ngPtb,m3h2x1(:,19),heltab2x2(:,:,29))
  call Hloop_AQ_S(ntryL,G2H2(82),ex1(:),G2H1(20),ngPtb,m3h2x1(:,20),heltab2x2(:,:,30))
  call Hloop_AQ_S(ntryL,G2H2(83),ex1(:),G2H1(21),ngPtb,m3h2x1(:,21),heltab2x2(:,:,31))
  call Hloop_AQ_S(ntryL,G2H2(84),ex1(:),G2H1(22),ngPtb,m3h2x1(:,22),heltab2x2(:,:,32))
  call Hloop_AQ_S(ntryL,G2H2(86),ex1(:),G2H1(23),ngPtb,m3h2x1(:,23),heltab2x2(:,:,33))
  call Hloop_AQ_S(ntryL,G2H2(87),ex1(:),G2H1(24),ngPtb,m3h2x1(:,24),heltab2x2(:,:,34))
  call Hloop_AQ_Z(ntryL,G2H2(88),ex1(:),G2H1(25),ngZd,m3h2x1(:,25),heltab2x2(:,:,35))
  call Hloop_AQ_Z(ntryL,G2H2(90),ex1(:),G2H1(26),ngZd,m3h2x1(:,26),heltab2x2(:,:,36))
  call Hloop_AQ_Z(ntryL,G2H2(91),ex1(:),G2H1(27),ngZd,m3h2x1(:,27),heltab2x2(:,:,37))
  call Hloop_AQ_W(ntryL,G2H2(92),ex1(:),G2H1(28),m3h2x1(:,28),heltab2x2(:,:,38))
  call Hloop_AQ_W(ntryL,G2H2(94),ex1(:),G2H1(29),m3h2x1(:,29),heltab2x2(:,:,39))
  call Hloop_AQ_W(ntryL,G2H2(95),ex1(:),G2H1(30),m3h2x1(:,30),heltab2x2(:,:,40))
  call Hloop_AQ_W(ntryL,G2H2(96),ex1(:),G2H1(31),m3h2x1(:,31),heltab2x2(:,:,41))
  call Hloop_AQ_W(ntryL,G2H2(98),ex1(:),G2H1(32),m3h2x1(:,32),heltab2x2(:,:,42))
  call Hloop_AQ_W(ntryL,G2H2(99),ex1(:),G2H1(33),m3h2x1(:,33),heltab2x2(:,:,43))
  call Hloop_QA_S(ntryL,G2H4(89),ex2(:),G2H2(51),ngPbt,m3h2x2(:,206),heltab2x4(:,:,295))
  call Hloop_QA_S(ntryL,G2H4(91),ex2(:),G2H2(52),ngPbt,m3h2x2(:,207),heltab2x4(:,:,296))
  call Hloop_QA_S(ntryL,G2H4(92),ex2(:),G2H2(53),ngPbt,m3h2x2(:,208),heltab2x4(:,:,297))
  call Hloop_QA_S(ntryL,G2H4(93),ex2(:),G2H2(54),ngPbt,m3h2x2(:,209),heltab2x4(:,:,298))
  call Hloop_QA_S(ntryL,G2H4(95),ex2(:),G2H2(55),ngPbt,m3h2x2(:,210),heltab2x4(:,:,299))
  call Hloop_QA_S(ntryL,G2H4(96),ex2(:),G2H2(56),ngPbt,m3h2x2(:,211),heltab2x4(:,:,300))
  call Hloop_QA_W(ntryL,G2H4(97),ex2(:),G2H2(57),m3h2x2(:,212),heltab2x4(:,:,301))
  call Hloop_QA_W(ntryL,G2H4(99),ex2(:),G2H2(59),m3h2x2(:,213),heltab2x4(:,:,302))
  call Hloop_QA_W(ntryL,G2H4(100),ex2(:),G2H2(58),m3h2x2(:,214),heltab2x4(:,:,303))
  call Hloop_QA_W(ntryL,G2H4(101),ex2(:),G2H2(60),m3h2x2(:,215),heltab2x4(:,:,304))
  call Hloop_QA_W(ntryL,G2H4(103),ex2(:),G2H2(61),m3h2x2(:,216),heltab2x4(:,:,305))
  call Hloop_QA_W(ntryL,G2H4(104),ex2(:),G2H2(63),m3h2x2(:,217),heltab2x4(:,:,306))
  call Hotf_5pt_reduction(G2H4(105),RedSet_5(6),mass5set(:,5),  & 
G1H4(196),G1H4(197),G1H4(117),G1H4(118),G1H4(199),G1H4(200),4)
  call HG1shiftOLR(G1H4(197),2,4)
  call Hotf_4pt_reduction(G2H4(107),RedSet_4(1),mass4set(:,1),  & 
G1H4(201),G1H4(21),G1H4(24),G1H4(52),G1H4(56),4)
  call HG1shiftOLR(G1H4(21),2,4)
  call Hotf_4pt_reduction(G2H4(108),RedSet_4(2),mass4set(:,1),  & 
G1H4(33),G1H4(34),G1H4(73),G1H4(77),G1H4(143),4)
  call HG1shiftOLR(G1H4(34),10,4)
  call Hotf_5pt_reduction(G2H4(109),RedSet_5(6),mass5set(:,6),  & 
G1H4(100),G1H4(99),G1H4(101),G1H4(22),G1H4(32),G1H4(202),4)
  call HG1shiftOLR(G1H4(99),2,4)
  call Hotf_4pt_reduction(G2H4(111),RedSet_4(1),mass4set(:,2),  & 
G1H4(203),G1H4(204),G1H4(205),G1H4(206),G1H4(207),4)
  call HG1shiftOLR(G1H4(204),2,4)
  call Hotf_4pt_reduction(G2H4(112),RedSet_4(2),mass4set(:,2),  & 
G1H4(208),G1H4(209),G1H4(210),G1H4(211),G1H4(212),4)
  call HG1shiftOLR(G1H4(209),10,4)
  call Hotf_5pt_reduction(G2H4(113),RedSet_5(6),mass5set(:,7),  & 
G1H4(213),G1H4(214),G1H4(215),G1H4(216),G1H4(217),G1H4(218),4)
  call HG1shiftOLR(G1H4(214),2,4)
  call Hotf_4pt_reduction(G2H4(115),RedSet_4(1),mass4set(:,3),  & 
G1H4(219),G1H4(220),G1H4(221),G1H4(222),G1H4(223),4)
  call HG1shiftOLR(G1H4(220),2,4)
  call Hotf_4pt_reduction(G2H4(116),RedSet_4(2),mass4set(:,3),  & 
G1H4(224),G1H4(225),G1H4(226),G1H4(227),G1H4(228),4)
  call HG1shiftOLR(G1H4(225),10,4)
  call Hotf_5pt_reduction(G2H4(117),RedSet_5(6),mass5set(:,7),  & 
G1H4(229),G1H4(230),G1H4(231),G1H4(232),G1H4(233),G1H4(234),4)
  call HG1shiftOLR(G1H4(230),2,4)
  call Hotf_4pt_reduction(G2H4(119),RedSet_4(1),mass4set(:,3),  & 
G1H4(235),G1H4(236),G1H4(237),G1H4(238),G1H4(239),4)
  call HG1shiftOLR(G1H4(236),2,4)
  call Hotf_4pt_reduction(G2H4(120),RedSet_4(2),mass4set(:,3),  & 
G1H4(240),G1H4(241),G1H4(242),G1H4(243),G1H4(244),4)
  call HG1shiftOLR(G1H4(241),10,4)
  call Hloop_QA_S(ntryL,G2H2(102),ex2(:),G2H1(34),ngH,m3h2x1(:,34),heltab2x2(:,:,44))
  call Hloop_QA_S(ntryL,G2H2(104),ex2(:),G2H1(35),ngH,m3h2x1(:,35),heltab2x2(:,:,45))
  call Hloop_QA_S(ntryL,G2H2(105),ex2(:),G2H1(36),ngH,m3h2x1(:,36),heltab2x2(:,:,46))
  call Hloop_QA_S(ntryL,G2H2(106),ex2(:),G2H1(37),ngX,m3h2x1(:,37),heltab2x2(:,:,47))
  call Hloop_QA_S(ntryL,G2H2(108),ex2(:),G2H1(38),ngX,m3h2x1(:,38),heltab2x2(:,:,48))
  call Hloop_QA_S(ntryL,G2H2(109),ex2(:),G2H1(39),ngX,m3h2x1(:,39),heltab2x2(:,:,49))
  call Hloop_QA_S(ntryL,G2H2(110),ex2(:),G2H1(40),ngPbt,m3h2x1(:,40),heltab2x2(:,:,50))
  call Hloop_QA_S(ntryL,G2H2(112),ex2(:),G2H1(41),ngPbt,m3h2x1(:,41),heltab2x2(:,:,51))
  call Hloop_QA_S(ntryL,G2H2(113),ex2(:),G2H1(42),ngPbt,m3h2x1(:,42),heltab2x2(:,:,52))
  call Hloop_QA_S(ntryL,G2H2(114),ex2(:),G2H1(43),ngPbt,m3h2x1(:,43),heltab2x2(:,:,53))
  call Hloop_QA_S(ntryL,G2H2(116),ex2(:),G2H1(44),ngPbt,m3h2x1(:,44),heltab2x2(:,:,54))
  call Hloop_QA_S(ntryL,G2H2(117),ex2(:),G2H1(45),ngPbt,m3h2x1(:,45),heltab2x2(:,:,55))
  call Hloop_QA_Z(ntryL,G2H2(118),ex2(:),G2H1(46),ngZd,m3h2x1(:,46),heltab2x2(:,:,56))
  call Hloop_QA_Z(ntryL,G2H2(120),ex2(:),G2H1(47),ngZd,m3h2x1(:,47),heltab2x2(:,:,57))
  call Hloop_QA_Z(ntryL,G2H2(121),ex2(:),G2H1(48),ngZd,m3h2x1(:,48),heltab2x2(:,:,58))
  call Hloop_QA_W(ntryL,G2H2(122),ex2(:),G2H1(49),m3h2x1(:,49),heltab2x2(:,:,59))
  call Hloop_QA_W(ntryL,G2H2(124),ex2(:),G2H1(50),m3h2x1(:,50),heltab2x2(:,:,60))
  call Hloop_QA_W(ntryL,G2H2(125),ex2(:),G2H1(51),m3h2x1(:,51),heltab2x2(:,:,61))
  call Hloop_QA_W(ntryL,G2H2(126),ex2(:),G2H1(52),m3h2x1(:,52),heltab2x2(:,:,62))
  call Hloop_QA_W(ntryL,G2H2(128),ex2(:),G2H1(53),m3h2x1(:,53),heltab2x2(:,:,63))
  call Hloop_QA_W(ntryL,G2H2(129),ex2(:),G2H1(54),m3h2x1(:,54),heltab2x2(:,:,64))
  call Hotf_5pt_reduction(G2H2(130),RedSet_5(8),mass5set(:,5),  & 
G1H2(247),G1H2(248),G1H2(249),G1H2(250),G1H2(251),G1H2(252),2)
  call HG1shiftOLR(G1H2(248),2,2)
  call Hotf_4pt_reduction(G2H2(132),RedSet_4(1),mass4set(:,1),  & 
G1H2(253),G1H2(254),G1H2(255),G1H2(256),G1H2(257),2)
  call HG1shiftOLR(G1H2(254),2,2)
  call Hotf_4pt_reduction(G2H2(133),RedSet_4(3),mass4set(:,1),  & 
G1H2(258),G1H2(259),G1H2(260),G1H2(261),G1H2(262),2)
  call HG1shiftOLR(G1H2(259),6,2)
  call Hotf_5pt_reduction(G2H2(134),RedSet_5(8),mass5set(:,6),  & 
G1H2(263),G1H2(264),G1H2(265),G1H2(266),G1H2(267),G1H2(268),2)
  call HG1shiftOLR(G1H2(264),2,2)
  call Hotf_4pt_reduction(G2H2(136),RedSet_4(1),mass4set(:,2),  & 
G1H2(269),G1H2(270),G1H2(271),G1H2(272),G1H2(273),2)
  call HG1shiftOLR(G1H2(270),2,2)
  call Hotf_4pt_reduction(G2H2(137),RedSet_4(3),mass4set(:,2),  & 
G1H2(274),G1H2(275),G1H2(276),G1H2(277),G1H2(278),2)
  call HG1shiftOLR(G1H2(275),6,2)
  call Hotf_5pt_reduction(G2H2(138),RedSet_5(8),mass5set(:,7),  & 
G1H2(279),G1H2(280),G1H2(281),G1H2(282),G1H2(283),G1H2(284),2)
  call HG1shiftOLR(G1H2(280),2,2)
  call Hotf_4pt_reduction(G2H2(140),RedSet_4(1),mass4set(:,3),  & 
G1H2(285),G1H2(286),G1H2(287),G1H2(288),G1H2(289),2)
  call HG1shiftOLR(G1H2(286),2,2)
  call Hotf_4pt_reduction(G2H2(141),RedSet_4(3),mass4set(:,3),  & 
G1H2(290),G1H2(291),G1H2(292),G1H2(293),G1H2(294),2)
  call HG1shiftOLR(G1H2(291),6,2)
  call Hotf_5pt_reduction(G2H2(142),RedSet_5(8),mass5set(:,7),  & 
G1H2(295),G1H2(296),G1H2(297),G1H2(298),G1H2(299),G1H2(300),2)
  call HG1shiftOLR(G1H2(296),2,2)
  call Hotf_4pt_reduction(G2H2(144),RedSet_4(1),mass4set(:,3),  & 
G1H2(301),G1H2(302),G1H2(303),G1H2(304),G1H2(305),2)
  call HG1shiftOLR(G1H2(302),2,2)
  call Hotf_4pt_reduction(G2H2(145),RedSet_4(3),mass4set(:,3),  & 
G1H2(306),G1H2(307),G1H2(308),G1H2(309),G1H2(310),2)
  call HG1shiftOLR(G1H2(307),6,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(201),[G1H4(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(33),[G1H4(200)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(203),[G1H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(208),[G1H4(202)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(219),[G1H4(217)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(224),[G1H4(218)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(235),[G1H4(233)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(240),[G1H4(234)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(253),[G1H2(251)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(258),[G1H2(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(269),[G1H2(267)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(274),[G1H2(268)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(285),[G1H2(283)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(290),[G1H2(284)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(301),[G1H2(299)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(306),[G1H2(300)])
  call Hloop_SA_Q(ntryL,G1H4(10),ex2(:),G1H2(251),ngH,m3h2x2(:,218),heltab2x4(:,:,307))
  call Hloop_A_Q(ntryL,G1H2(251),23,nMB,G2H2(62),n2h2(104))
call HGT_OLR(G1H4(12),1,1,4)
call HGT_invQ_OLR(G1H4(12),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(12),-8,nMB,G2H4(66),n2h4(244))
  call Hloop_QV_A(ntryL,G2H4(66),ex4(:),G2H2(64),m3h2x2(:,219),heltab2x4(:,:,308))
  call Hloop_SA_Q(ntryL,G1H4(3),ex2(:),G1H2(252),ngH,m3h2x2(:,220),heltab2x4(:,:,309))
  call Hloop_A_Q(ntryL,G1H2(252),23,nMB,G2H2(65),n2h2(105))
  call Hloop_SA_Q(ntryL,G1H4(5),ex2(:),G1H2(267),ngH,m3h2x2(:,221),heltab2x4(:,:,310))
  call Hloop_A_Q(ntryL,G1H2(267),23,nMB,G2H2(66),n2h2(106))
  call Hloop_SA_Q(ntryL,G1H4(6),ex2(:),G1H2(268),ngX,m3h2x2(:,222),heltab2x4(:,:,311))
  call Hloop_A_Q(ntryL,G1H2(268),23,nMB,G2H2(68),n2h2(107))
call HGT_OLR(G1H4(9),1,1,4)
call HGT_invQ_OLR(G1H4(9),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(9),-8,nMB,G2H4(70),n2h4(245))
  call Hloop_QV_A(ntryL,G2H4(70),ex4(:),G2H2(67),m3h2x2(:,223),heltab2x4(:,:,312))
  call Hloop_SA_Q(ntryL,G1H4(15),ex2(:),G1H2(283),ngX,m3h2x2(:,224),heltab2x4(:,:,313))
  call Hloop_A_Q(ntryL,G1H2(283),23,nMB,G2H2(69),n2h2(108))
  call Hloop_SA_Q(ntryL,G1H4(16),ex2(:),G1H2(284),ngX,m3h2x2(:,225),heltab2x4(:,:,314))
  call Hloop_A_Q(ntryL,G1H2(284),23,nMB,G2H2(72),n2h2(109))
  call Hloop_SA_Q(ntryL,G1H4(17),ex2(:),G1H2(299),ngPbt,m3h2x2(:,226),heltab2x4(:,:,315))
  call Hloop_A_Q(ntryL,G1H2(299),23,nMT,G2H2(74),n2h2(110))
call HGT_OLR(G1H4(18),1,1,4)
call HGT_invQ_OLR(G1H4(18),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(18),-8,nMT,G2H4(71),n2h4(246))
  call Hloop_QV_A(ntryL,G2H4(71),ex4(:),G2H2(75),m3h2x2(:,227),heltab2x4(:,:,316))
  call Hloop_SA_Q(ntryL,G1H4(30),ex2(:),G1H2(300),ngPbt,m3h2x2(:,228),heltab2x4(:,:,317))
  call Hloop_A_Q(ntryL,G1H2(300),23,nMT,G2H2(76),n2h2(111))
  call Hloop_SA_Q(ntryL,G1H4(31),ex2(:),G1H2(251),ngPbt,m3h2x2(:,229),heltab2x4(:,:,318))
  call Hloop_A_Q(ntryL,G1H2(251),23,nMT,G2H2(78),n2h2(112))
  call Hloop_VA_Q(ntryL,G1H4(43),ex2(:),G1H2(252),m3h2x2(:,230),heltab2x4(:,:,319))
  call Hloop_A_Q(ntryL,G1H2(252),23,nMB,G2H2(79),n2h2(113))
call HGT_OLR(G1H4(127),1,1,4)
call HGT_invQ_OLR(G1H4(127),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(127),-8,nMB,G2H4(72),n2h4(247))
  call Hloop_QV_A(ntryL,G2H4(72),ex4(:),G2H2(80),m3h2x2(:,231),heltab2x4(:,:,320))
  call Hloop_VA_Q(ntryL,G1H4(41),ex2(:),G1H2(267),m3h2x2(:,232),heltab2x4(:,:,321))
  call Hloop_A_Q(ntryL,G1H2(267),23,nMB,G2H2(82),n2h2(114))
  call Hloop_VA_Q(ntryL,G1H4(47),ex2(:),G1H2(268),m3h2x2(:,233),heltab2x4(:,:,322))
  call Hloop_A_Q(ntryL,G1H2(268),23,nMB,G2H2(83),n2h2(115))
  call Hloop_ZA_Q(ntryL,G1H4(27),ex2(:),G1H2(283),ngZd,m3h2x2(:,234),heltab2x4(:,:,323))
  call Hloop_A_Q(ntryL,G1H2(283),23,nMB,G2H2(84),n2h2(116))
call HGT_OLR(G1H4(48),1,1,4)
call HGT_invQ_OLR(G1H4(48),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(48),-8,nMB,G2H4(3),n2h4(248))
  call Hloop_QV_A(ntryL,G2H4(3),ex4(:),G2H2(86),m3h2x2(:,235),heltab2x4(:,:,324))
  call Hloop_ZA_Q(ntryL,G1H4(53),ex2(:),G1H2(284),ngZd,m3h2x2(:,236),heltab2x4(:,:,325))
  call Hloop_A_Q(ntryL,G1H2(284),23,nMB,G2H2(87),n2h2(117))
  call Hloop_ZA_Q(ntryL,G1H4(58),ex2(:),G1H2(299),ngZd,m3h2x2(:,237),heltab2x4(:,:,326))
  call Hloop_A_Q(ntryL,G1H2(299),23,nMB,G2H2(88),n2h2(118))
  call Hloop_WA_Q(ntryL,G1H4(60),ex2(:),G1H2(300),m3h2x2(:,238),heltab2x4(:,:,327))
  call Hloop_A_Q(ntryL,G1H2(300),23,nMT,G2H2(90),n2h2(119))
call HGT_OLR(G1H4(128),1,1,4)
call HGT_invQ_OLR(G1H4(128),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(128),-8,nMT,G2H4(8),n2h4(249))
  call Hloop_QV_A(ntryL,G2H4(8),ex4(:),G2H2(91),m3h2x2(:,239),heltab2x4(:,:,328))
  call Hloop_WA_Q(ntryL,G1H4(62),ex2(:),G1H2(251),m3h2x2(:,240),heltab2x4(:,:,329))
  call Hloop_A_Q(ntryL,G1H2(251),23,nMT,G2H2(92),n2h2(120))
  call Hloop_WA_Q(ntryL,G1H4(36),ex2(:),G1H2(252),m3h2x2(:,241),heltab2x4(:,:,330))
  call Hloop_A_Q(ntryL,G1H2(252),23,nMT,G2H2(94),n2h2(121))
  call Hloop_QS_A(ntryL,G1H2(21),ex3(:),G1H2(267),ngH,m3h1x2(:,11),heltab2x2(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(267),23,nMB,G2H2(95),n2h2(122))
call HGT_OLR(G1H2(1),1,1,2)
call HGT_invQ_OLR(G1H2(1),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(1),-8,nMB,G2H2(96),n2h2(123))
  call Hloop_AV_Q(ntryL,G2H2(96),ex4(:),G2H1(55),m3h2x1(:,55),heltab2x2(:,:,66))
  call Hloop_QS_A(ntryL,G1H2(3),ex3(:),G1H2(268),ngH,m3h1x2(:,12),heltab2x2(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(268),23,nMB,G2H2(98),n2h2(124))
  call Hloop_QS_A(ntryL,G1H2(6),ex3(:),G1H2(283),ngH,m3h1x2(:,13),heltab2x2(:,:,68))
  call Hloop_Q_A(ntryL,G1H2(283),23,nMB,G2H2(99),n2h2(125))
  call Hloop_QS_A(ntryL,G1H2(5),ex3(:),G1H2(284),ngH,m3h1x2(:,14),heltab2x2(:,:,69))
  call Hloop_Q_A(ntryL,G1H2(284),23,nMB,G2H2(102),n2h2(126))
call HGT_OLR(G1H2(8),1,1,2)
call HGT_invQ_OLR(G1H2(8),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(8),-8,nMB,G2H2(104),n2h2(127))
  call Hloop_AV_Q(ntryL,G2H2(104),ex4(:),G2H1(56),m3h2x1(:,56),heltab2x2(:,:,70))
  call Hloop_QS_A(ntryL,G1H2(23),ex3(:),G1H2(299),ngH,m3h1x2(:,15),heltab2x2(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(299),23,nMB,G2H2(105),n2h2(128))
  call Hloop_QS_A(ntryL,G1H2(24),ex3(:),G1H2(300),ngH,m3h1x2(:,16),heltab2x2(:,:,72))
  call Hloop_Q_A(ntryL,G1H2(300),23,nMB,G2H2(106),n2h2(129))
  call Hloop_QS_A(ntryL,G1H2(25),ex3(:),G1H2(251),ngH,m3h1x2(:,17),heltab2x2(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(251),23,nMT,G2H2(108),n2h2(130))
call HGT_OLR(G1H2(26),1,1,2)
call HGT_invQ_OLR(G1H2(26),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(26),-8,nMT,G2H2(109),n2h2(131))
  call Hloop_AV_Q(ntryL,G2H2(109),ex4(:),G2H1(57),m3h2x1(:,57),heltab2x2(:,:,74))
  call Hloop_QS_A(ntryL,G1H2(29),ex3(:),G1H2(252),ngH,m3h1x2(:,18),heltab2x2(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(252),23,nMT,G2H2(110),n2h2(132))
  call Hloop_QS_A(ntryL,G1H2(30),ex3(:),G1H2(21),ngH,m3h1x2(:,19),heltab2x2(:,:,76))
  call Hloop_Q_A(ntryL,G1H2(21),23,nMT,G2H2(112),n2h2(133))
  call Hloop_QS_A(ntryL,G1H2(31),ex3(:),G1H2(267),ngH,m3h1x2(:,20),heltab2x2(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(267),23,nMB,G2H2(113),n2h2(134))
call HGT_OLR(G1H2(32),1,1,2)
call HGT_invQ_OLR(G1H2(32),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(32),-8,nMB,G2H2(114),n2h2(135))
  call Hloop_AV_Q(ntryL,G2H2(114),ex4(:),G2H1(58),m3h2x1(:,58),heltab2x2(:,:,78))
  call Hloop_QS_A(ntryL,G1H2(35),ex3(:),G1H2(1),ngH,m3h1x2(:,21),heltab2x2(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(116),n2h2(136))
  call Hloop_QS_A(ntryL,G1H2(36),ex3(:),G1H2(3),ngH,m3h1x2(:,22),heltab2x2(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMB,G2H2(117),n2h2(137))
  call Hloop_ST_V(ntryL,G1H2(37),19,ex3(:),4,G2H2(118),m3h1x2(:,23),heltab2x2(:,:,81))
call HGT_OLR(G1H2(38),1,1,2)
call HGT_invQ_OLR(G1H2(38),2,5,2)
  call Hloop_SV_V(ntryL,G1H2(38),ex4(:),G1H1(1),m3h2x1(:,59),heltab2x2(:,:,82))
  call Hloop_ST_V(ntryL,G1H2(41),19,ex3(:),4,G2H2(120),m3h1x2(:,24),heltab2x2(:,:,83))
  call Hloop_ST_V(ntryL,G1H2(42),19,ex3(:),4,G2H2(121),m3h1x2(:,25),heltab2x2(:,:,84))
  call Hloop_VT_S(ntryL,G1H2(43),19,ex3(:),4,G2H2(122),m3h1x2(:,26),heltab2x2(:,:,85))
call HGT_OLR(G1H2(44),1,1,2)
call HGT_invQ_OLR(G1H2(44),2,5,2)
  call Hloop_SV_T(ntryL,G1H2(44),-8,ex4(:),8,G2H1(59),m3h2x1(:,60),heltab2x2(:,:,86))
  call Hloop_VT_S(ntryL,G1H2(47),19,ex3(:),4,G2H2(124),m3h1x2(:,27),heltab2x2(:,:,87))
  call Hloop_VT_S(ntryL,G1H2(48),19,ex3(:),4,G2H2(125),m3h1x2(:,28),heltab2x2(:,:,88))
  call Hloop_ST_V(ntryL,G1H2(49),19,ex3(:),4,G2H2(126),m3h1x2(:,29),heltab2x2(:,:,89))
call HGT_raise_alpha_OLR(G1H2(50),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(50),2,5,2)
  call Hloop_UW_V(ntryL,G1H2(50),-8,ex4(:),8,G2H1(60),m3h2x1(:,61),heltab2x2(:,:,90))
  call Hloop_ST_V(ntryL,G1H2(53),19,ex3(:),4,G2H2(128),m3h1x2(:,30),heltab2x2(:,:,91))
  call Hloop_ST_V(ntryL,G1H2(54),19,ex3(:),4,G2H2(129),m3h1x2(:,31),heltab2x2(:,:,92))
  call Hloop_VT_S(ntryL,G1H2(55),19,ex3(:),4,G2H2(130),m3h1x2(:,32),heltab2x2(:,:,93))
call HGT_raise_alpha_OLR(G1H2(56),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(56),2,5,2)
  call Hloop_VV_S(ntryL,G1H2(56),ex4(:),G1H1(2),m3h2x1(:,62),heltab2x2(:,:,94))
  call Hloop_VT_S(ntryL,G1H2(59),19,ex3(:),4,G2H2(132),m3h1x2(:,33),heltab2x2(:,:,95))
  call Hloop_VT_S(ntryL,G1H2(60),19,ex3(:),4,G2H2(133),m3h1x2(:,34),heltab2x2(:,:,96))
  call Hloop_SQ_A(ntryL,G1H4(63),ex1(:),G1H2(268),ngH,m3h2x2(:,242),heltab2x4(:,:,331))
  call Hloop_Q_A(ntryL,G1H2(268),23,nMB,G2H2(134),n2h2(142))
call HGT_OLR(G1H4(51),1,1,4)
call HGT_invQ_OLR(G1H4(51),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(51),-8,nMB,G2H4(73),n2h4(250))
  call Hloop_AV_Q(ntryL,G2H4(73),ex4(:),G2H2(136),m3h2x2(:,243),heltab2x4(:,:,332))
  call Hloop_SQ_A(ntryL,G1H4(26),ex1(:),G1H2(6),ngH,m3h2x2(:,244),heltab2x4(:,:,333))
  call Hloop_Q_A(ntryL,G1H2(6),23,nMB,G2H2(137),n2h2(143))
  call Hloop_SQ_A(ntryL,G1H4(71),ex1(:),G1H2(283),ngH,m3h2x2(:,245),heltab2x4(:,:,334))
  call Hloop_Q_A(ntryL,G1H2(283),23,nMB,G2H2(138),n2h2(144))
  call Hloop_SQ_A(ntryL,G1H4(55),ex1(:),G1H2(5),ngX,m3h2x2(:,246),heltab2x4(:,:,335))
  call Hloop_Q_A(ntryL,G1H2(5),23,nMB,G2H2(140),n2h2(145))
call HGT_OLR(G1H4(72),1,1,4)
call HGT_invQ_OLR(G1H4(72),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(72),-8,nMB,G2H4(74),n2h4(251))
  call Hloop_AV_Q(ntryL,G2H4(74),ex4(:),G2H2(141),m3h2x2(:,247),heltab2x4(:,:,336))
  call Hloop_SQ_A(ntryL,G1H4(65),ex1(:),G1H2(284),ngX,m3h2x2(:,248),heltab2x4(:,:,337))
  call Hloop_Q_A(ntryL,G1H2(284),23,nMB,G2H2(142),n2h2(146))
  call Hloop_SQ_A(ntryL,G1H4(81),ex1(:),G1H2(8),ngX,m3h2x2(:,249),heltab2x4(:,:,338))
  call Hloop_Q_A(ntryL,G1H2(8),23,nMB,G2H2(144),n2h2(147))
  call Hloop_SQ_A(ntryL,G1H4(83),ex1(:),G1H2(23),ngPtb,m3h2x2(:,250),heltab2x4(:,:,339))
  call Hloop_Q_A(ntryL,G1H2(23),23,nMT,G2H2(145),n2h2(148))
call HGT_OLR(G1H4(69),1,1,4)
call HGT_invQ_OLR(G1H4(69),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(69),-8,nMT,G2H4(63),n2h4(252))
  call Hloop_AV_Q(ntryL,G2H4(63),ex4(:),G2H2(96),m3h2x2(:,251),heltab2x4(:,:,340))
  call Hloop_SQ_A(ntryL,G1H4(85),ex1(:),G1H2(299),ngPtb,m3h2x2(:,252),heltab2x4(:,:,341))
  call Hloop_Q_A(ntryL,G1H2(299),23,nMT,G2H2(104),n2h2(149))
  call Hloop_SQ_A(ntryL,G1H4(68),ex1(:),G1H2(24),ngPtb,m3h2x2(:,253),heltab2x4(:,:,342))
  call Hloop_Q_A(ntryL,G1H2(24),23,nMT,G2H2(109),n2h2(150))
  call Hloop_VQ_A(ntryL,G1H4(86),ex1(:),G1H2(300),m3h2x2(:,254),heltab2x4(:,:,343))
  call Hloop_Q_A(ntryL,G1H2(300),23,nMB,G2H2(114),n2h2(151))
call HGT_OLR(G1H4(39),1,1,4)
call HGT_invQ_OLR(G1H4(39),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(39),-8,nMB,G2H4(64),n2h4(253))
  call Hloop_AV_Q(ntryL,G2H4(64),ex4(:),G2H2(146),m3h2x2(:,255),heltab2x4(:,:,344))
  call Hloop_VQ_A(ntryL,G1H4(75),ex1(:),G1H2(25),m3h2x2(:,256),heltab2x4(:,:,345))
  call Hloop_Q_A(ntryL,G1H2(25),23,nMB,G2H2(147),n2h2(152))
  call Hloop_VQ_A(ntryL,G1H4(129),ex1(:),G1H2(251),m3h2x2(:,257),heltab2x4(:,:,346))
  call Hloop_Q_A(ntryL,G1H2(251),23,nMB,G2H2(148),n2h2(153))
  call Hloop_ZQ_A(ntryL,G1H4(37),ex1(:),G1H2(26),ngZd,m3h2x2(:,258),heltab2x4(:,:,347))
  call Hloop_Q_A(ntryL,G1H2(26),23,nMB,G2H2(149),n2h2(154))
call HGT_OLR(G1H4(130),1,1,4)
call HGT_invQ_OLR(G1H4(130),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(130),-8,nMB,G2H4(65),n2h4(254))
  call Hloop_AV_Q(ntryL,G2H4(65),ex4(:),G2H2(150),m3h2x2(:,259),heltab2x4(:,:,348))
  call Hloop_ZQ_A(ntryL,G1H4(74),ex1(:),G1H2(29),ngZd,m3h2x2(:,260),heltab2x4(:,:,349))
  call Hloop_Q_A(ntryL,G1H2(29),23,nMB,G2H2(151),n2h2(155))
  call Hloop_ZQ_A(ntryL,G1H4(132),ex1(:),G1H2(252),ngZd,m3h2x2(:,261),heltab2x4(:,:,350))
  call Hloop_Q_A(ntryL,G1H2(252),23,nMB,G2H2(152),n2h2(156))
  call Hloop_WQ_A(ntryL,G1H4(134),ex1(:),G1H2(30),m3h2x2(:,262),heltab2x4(:,:,351))
  call Hloop_Q_A(ntryL,G1H2(30),23,nMT,G2H2(153),n2h2(157))
call HGT_OLR(G1H4(79),1,1,4)
call HGT_invQ_OLR(G1H4(79),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(79),-8,nMT,G2H4(29),n2h4(255))
  call Hloop_AV_Q(ntryL,G2H4(29),ex4(:),G2H2(154),m3h2x2(:,263),heltab2x4(:,:,352))
  call Hloop_WQ_A(ntryL,G1H4(136),ex1(:),G1H2(21),m3h2x2(:,264),heltab2x4(:,:,353))
  call Hloop_Q_A(ntryL,G1H2(21),23,nMT,G2H2(155),n2h2(158))
  call Hloop_WQ_A(ntryL,G1H4(88),ex1(:),G1H2(31),m3h2x2(:,265),heltab2x4(:,:,354))
  call Hloop_Q_A(ntryL,G1H2(31),23,nMT,G2H2(156),n2h2(159))
  call Hloop_QV_A(ntryL,G1H2(61),ex4(:),G1H1(3),m3h2x1(:,63),heltab2x2(:,:,97))
  call Hloop_Q_A(ntryL,G1H1(3),27,nMB,G2H1(61),n2h1(1))
call HGT_OLR(G1H2(62),1,1,2)
call HGT_invQ_OLR(G1H2(62),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(62),-4,nMB,G2H2(157),n2h2(160))
  call Hloop_AS_Q(ntryL,G2H2(157),ex3(:),G2H2(158),ngH,m3h1x2(:,35),heltab2x2(:,:,98))
  call Hloop_QV_A(ntryL,G1H2(65),ex4(:),G1H1(3),m3h2x1(:,64),heltab2x2(:,:,99))
  call Hloop_Q_A(ntryL,G1H1(3),27,nMB,G2H1(62),n2h1(2))
  call Hloop_QV_A(ntryL,G1H2(66),ex4(:),G1H1(3),m3h2x1(:,65),heltab2x2(:,:,100))
  call Hloop_Q_A(ntryL,G1H1(3),27,nMB,G2H1(63),n2h1(3))
  call Hloop_QV_A(ntryL,G1H2(67),ex4(:),G1H1(3),m3h2x1(:,66),heltab2x2(:,:,101))
  call Hloop_Q_A(ntryL,G1H1(3),27,nMB,G2H1(64),n2h1(4))
call HGT_OLR(G1H2(68),1,1,2)
call HGT_invQ_OLR(G1H2(68),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(68),-4,nMB,G2H2(157),n2h2(161))
  call Hloop_AS_Q(ntryL,G2H2(157),ex3(:),G2H2(159),ngH,m3h1x2(:,36),heltab2x2(:,:,102))
  call Hloop_QV_A(ntryL,G1H2(71),ex4(:),G1H1(3),m3h2x1(:,67),heltab2x2(:,:,103))
  call Hloop_Q_A(ntryL,G1H1(3),27,nMB,G2H1(65),n2h1(5))
  call Hloop_QV_A(ntryL,G1H2(72),ex4(:),G1H1(3),m3h2x1(:,68),heltab2x2(:,:,104))
  call Hloop_Q_A(ntryL,G1H1(3),27,nMB,G2H1(66),n2h1(6))
  call Hloop_QV_A(ntryL,G1H2(73),ex4(:),G1H1(3),m3h2x1(:,69),heltab2x2(:,:,105))
  call Hloop_Q_A(ntryL,G1H1(3),27,nMT,G2H1(67),n2h1(7))
call HGT_OLR(G1H2(74),1,1,2)
call HGT_invQ_OLR(G1H2(74),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(74),-4,nMT,G2H2(157),n2h2(162))
  call Hloop_AS_Q(ntryL,G2H2(157),ex3(:),G2H2(160),ngH,m3h1x2(:,37),heltab2x2(:,:,106))
  call Hloop_QV_A(ntryL,G1H2(77),ex4(:),G1H1(3),m3h2x1(:,70),heltab2x2(:,:,107))
  call Hloop_Q_A(ntryL,G1H1(3),27,nMT,G2H1(68),n2h1(8))
  call Hloop_QV_A(ntryL,G1H2(78),ex4(:),G1H1(3),m3h2x1(:,71),heltab2x2(:,:,108))
  call Hloop_Q_A(ntryL,G1H1(3),27,nMT,G2H1(69),n2h1(9))
  call Hloop_TV_S(ntryL,G1H2(79),19,ex4(:),8,G2H1(70),m3h2x1(:,72),heltab2x2(:,:,109))
call HGT_OLR(G1H2(80),1,1,2)
call HGT_invQ_OLR(G1H2(80),2,5,2)
  call Hloop_SS_S(ntryL,G1H2(80),ex3(:),G1H2(267),m3h1x2(:,38),heltab2x2(:,:,110))
  call Hloop_TV_S(ntryL,G1H2(83),19,ex4(:),8,G2H1(71),m3h2x1(:,73),heltab2x2(:,:,111))
  call Hloop_TV_S(ntryL,G1H2(84),19,ex4(:),8,G2H1(72),m3h2x1(:,74),heltab2x2(:,:,112))
  call Hloop_QV_A(ntryL,G1H2(85),ex4(:),G1H1(3),m3h2x1(:,75),heltab2x2(:,:,113))
  call Hloop_Q_A(ntryL,G1H1(3),27,nMB,G2H1(73),n2h1(10))
call HGT_OLR(G1H2(86),1,1,2)
call HGT_invQ_OLR(G1H2(86),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(86),-4,nMB,G2H2(157),n2h2(164))
  call Hloop_AS_Q(ntryL,G2H2(157),ex3(:),G2H2(161),ngH,m3h1x2(:,39),heltab2x2(:,:,114))
  call Hloop_QV_A(ntryL,G1H2(89),ex4(:),G1H1(3),m3h2x1(:,76),heltab2x2(:,:,115))
  call Hloop_Q_A(ntryL,G1H1(3),27,nMB,G2H1(74),n2h1(11))
  call Hloop_QV_A(ntryL,G1H2(90),ex4(:),G1H1(3),m3h2x1(:,77),heltab2x2(:,:,116))
  call Hloop_Q_A(ntryL,G1H1(3),27,nMB,G2H1(75),n2h1(12))
  call Hloop_TV_S(ntryL,G1H2(91),19,ex4(:),8,G2H1(76),m3h2x1(:,78),heltab2x2(:,:,117))
call HGT_raise_alpha_OLR(G1H2(92),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(92),2,5,2)
  call Hloop_VT_S(ntryL,G1H2(92),-4,ex3(:),4,G2H2(157),m3h1x2(:,40),heltab2x2(:,:,118))
  call Hloop_TV_S(ntryL,G1H2(95),19,ex4(:),8,G2H1(77),m3h2x1(:,79),heltab2x2(:,:,119))
  call Hloop_TV_S(ntryL,G1H2(96),19,ex4(:),8,G2H1(78),m3h2x1(:,80),heltab2x2(:,:,120))
  call Hloop_UV_W(ntryL,G1H2(97),19,ex4(:),8,G2H1(79),m3h2x1(:,81),heltab2x2(:,:,121))
call HGT_OLR(G1H2(98),1,1,2)
call HGT_invQ_OLR(G1H2(98),2,5,2)
  call Hloop_ST_V(ntryL,G1H2(98),-4,ex3(:),4,G2H2(162),m3h1x2(:,41),heltab2x2(:,:,122))
  call Hloop_UV_W(ntryL,G1H2(101),19,ex4(:),8,G2H1(80),m3h2x1(:,82),heltab2x2(:,:,123))
  call Hloop_UV_W(ntryL,G1H2(102),19,ex4(:),8,G2H1(81),m3h2x1(:,83),heltab2x2(:,:,124))
  call Hloop_UV_W(ntryL,G1H2(103),19,ex4(:),8,G2H1(82),m3h2x1(:,84),heltab2x2(:,:,125))
call HGT_raise_alpha_OLR(G1H2(104),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(104),2,5,2)
  call Hloop_VS_V(ntryL,G1H2(104),ex3(:),G1H2(32),m3h1x2(:,42),heltab2x2(:,:,126))
  call Hloop_UV_W(ntryL,G1H2(107),19,ex4(:),8,G2H1(83),m3h2x1(:,85),heltab2x2(:,:,127))
  call Hloop_UV_W(ntryL,G1H2(108),19,ex4(:),8,G2H1(84),m3h2x1(:,86),heltab2x2(:,:,128))
  call Hloop_AS_Q(ntryL,G1H2(109),ex3(:),G1H2(35),ngH,m3h1x2(:,43),heltab2x2(:,:,129))
  call Hloop_A_Q(ntryL,G1H2(35),23,nMB,G2H2(163),n2h2(168))
call HGT_OLR(G1H2(110),1,1,2)
call HGT_invQ_OLR(G1H2(110),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(110),-8,nMB,G2H2(164),n2h2(169))
  call Hloop_QV_A(ntryL,G2H2(164),ex4(:),G2H1(85),m3h2x1(:,87),heltab2x2(:,:,130))
  call Hloop_AS_Q(ntryL,G1H2(113),ex3(:),G1H2(1),ngH,m3h1x2(:,44),heltab2x2(:,:,131))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMB,G2H2(164),n2h2(170))
  call Hloop_AS_Q(ntryL,G1H2(114),ex3(:),G1H2(36),ngH,m3h1x2(:,45),heltab2x2(:,:,132))
  call Hloop_A_Q(ntryL,G1H2(36),23,nMB,G2H2(165),n2h2(171))
  call Hloop_AS_Q(ntryL,G1H2(115),ex3(:),G1H2(3),ngH,m3h1x2(:,46),heltab2x2(:,:,133))
  call Hloop_A_Q(ntryL,G1H2(3),23,nMB,G2H2(166),n2h2(172))
call HGT_OLR(G1H2(116),1,1,2)
call HGT_invQ_OLR(G1H2(116),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(116),-8,nMB,G2H2(167),n2h2(173))
  call Hloop_QV_A(ntryL,G2H2(167),ex4(:),G2H1(86),m3h2x1(:,88),heltab2x2(:,:,134))
  call Hloop_AS_Q(ntryL,G1H2(119),ex3(:),G1H2(37),ngH,m3h1x2(:,47),heltab2x2(:,:,135))
  call Hloop_A_Q(ntryL,G1H2(37),23,nMB,G2H2(167),n2h2(174))
  call Hloop_AS_Q(ntryL,G1H2(120),ex3(:),G1H2(38),ngH,m3h1x2(:,48),heltab2x2(:,:,136))
  call Hloop_A_Q(ntryL,G1H2(38),23,nMB,G2H2(168),n2h2(175))
  call Hloop_AS_Q(ntryL,G1H2(121),ex3(:),G1H2(41),ngH,m3h1x2(:,49),heltab2x2(:,:,137))
  call Hloop_A_Q(ntryL,G1H2(41),23,nMT,G2H2(169),n2h2(176))
call HGT_OLR(G1H2(122),1,1,2)
call HGT_invQ_OLR(G1H2(122),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(122),-8,nMT,G2H2(170),n2h2(177))
  call Hloop_QV_A(ntryL,G2H2(170),ex4(:),G2H1(87),m3h2x1(:,89),heltab2x2(:,:,138))
  call Hloop_AS_Q(ntryL,G1H2(125),ex3(:),G1H2(42),ngH,m3h1x2(:,50),heltab2x2(:,:,139))
  call Hloop_A_Q(ntryL,G1H2(42),23,nMT,G2H2(170),n2h2(178))
  call Hloop_AS_Q(ntryL,G1H2(126),ex3(:),G1H2(43),ngH,m3h1x2(:,51),heltab2x2(:,:,140))
  call Hloop_A_Q(ntryL,G1H2(43),23,nMT,G2H2(171),n2h2(179))
  call Hloop_AS_Q(ntryL,G1H2(127),ex3(:),G1H2(44),ngH,m3h1x2(:,52),heltab2x2(:,:,141))
  call Hloop_A_Q(ntryL,G1H2(44),23,nMB,G2H2(172),n2h2(180))
call HGT_OLR(G1H2(128),1,1,2)
call HGT_invQ_OLR(G1H2(128),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(128),-8,nMB,G2H2(173),n2h2(181))
  call Hloop_QV_A(ntryL,G2H2(173),ex4(:),G2H1(88),m3h2x1(:,90),heltab2x2(:,:,142))
  call Hloop_AS_Q(ntryL,G1H2(131),ex3(:),G1H2(47),ngH,m3h1x2(:,53),heltab2x2(:,:,143))
  call Hloop_A_Q(ntryL,G1H2(47),23,nMB,G2H2(173),n2h2(182))
  call Hloop_AS_Q(ntryL,G1H2(132),ex3(:),G1H2(48),ngH,m3h1x2(:,54),heltab2x2(:,:,144))
  call Hloop_A_Q(ntryL,G1H2(48),23,nMB,G2H2(174),n2h2(183))
  call Hloop_ST_V(ntryL,G1H2(133),19,ex3(:),4,G2H2(175),m3h1x2(:,55),heltab2x2(:,:,145))
call HGT_OLR(G1H2(134),1,1,2)
call HGT_invQ_OLR(G1H2(134),2,5,2)
  call Hloop_SV_V(ntryL,G1H2(134),ex4(:),G1H1(3),m3h2x1(:,91),heltab2x2(:,:,146))
  call Hloop_ST_V(ntryL,G1H2(137),19,ex3(:),4,G2H2(176),m3h1x2(:,56),heltab2x2(:,:,147))
  call Hloop_ST_V(ntryL,G1H2(138),19,ex3(:),4,G2H2(177),m3h1x2(:,57),heltab2x2(:,:,148))
  call Hloop_VT_S(ntryL,G1H2(139),19,ex3(:),4,G2H2(178),m3h1x2(:,58),heltab2x2(:,:,149))
call HGT_OLR(G1H2(140),1,1,2)
call HGT_invQ_OLR(G1H2(140),2,5,2)
  call Hloop_TV_S(ntryL,G1H2(140),-8,ex4(:),8,G2H1(89),m3h2x1(:,92),heltab2x2(:,:,150))
  call Hloop_VT_S(ntryL,G1H2(143),19,ex3(:),4,G2H2(179),m3h1x2(:,59),heltab2x2(:,:,151))
  call Hloop_VT_S(ntryL,G1H2(144),19,ex3(:),4,G2H2(180),m3h1x2(:,60),heltab2x2(:,:,152))
  call Hloop_ST_V(ntryL,G1H2(145),19,ex3(:),4,G2H2(181),m3h1x2(:,61),heltab2x2(:,:,153))
call HGT_raise_alpha_OLR(G1H2(146),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(146),2,5,2)
  call Hloop_UV_W(ntryL,G1H2(146),-8,ex4(:),8,G2H1(90),m3h2x1(:,93),heltab2x2(:,:,154))
  call Hloop_ST_V(ntryL,G1H2(149),19,ex3(:),4,G2H2(182),m3h1x2(:,62),heltab2x2(:,:,155))
  call Hloop_ST_V(ntryL,G1H2(150),19,ex3(:),4,G2H2(183),m3h1x2(:,63),heltab2x2(:,:,156))
  call Hloop_VT_S(ntryL,G1H2(151),19,ex3(:),4,G2H2(184),m3h1x2(:,64),heltab2x2(:,:,157))
call HGT_raise_alpha_OLR(G1H2(152),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(152),2,5,2)
  call Hloop_VV_S(ntryL,G1H2(152),ex4(:),G1H1(4),m3h2x1(:,94),heltab2x2(:,:,158))
  call Hloop_VT_S(ntryL,G1H2(155),19,ex3(:),4,G2H2(185),m3h1x2(:,65),heltab2x2(:,:,159))
  call Hloop_VT_S(ntryL,G1H2(156),19,ex3(:),4,G2H2(186),m3h1x2(:,66),heltab2x2(:,:,160))
  call Hloop_AV_Q(ntryL,G1H2(157),ex4(:),G1H1(5),m3h2x1(:,95),heltab2x2(:,:,161))
  call Hloop_A_Q(ntryL,G1H1(5),27,nMB,G2H1(91),n2h1(13))
call HGT_OLR(G1H2(158),1,1,2)
call HGT_invQ_OLR(G1H2(158),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(158),-4,nMB,G2H2(187),n2h2(188))
  call Hloop_QS_A(ntryL,G2H2(187),ex3(:),G2H2(188),ngH,m3h1x2(:,67),heltab2x2(:,:,162))
  call Hloop_AV_Q(ntryL,G1H2(161),ex4(:),G1H1(5),m3h2x1(:,96),heltab2x2(:,:,163))
  call Hloop_A_Q(ntryL,G1H1(5),27,nMB,G2H1(92),n2h1(14))
  call Hloop_AV_Q(ntryL,G1H2(162),ex4(:),G1H1(5),m3h2x1(:,97),heltab2x2(:,:,164))
  call Hloop_A_Q(ntryL,G1H1(5),27,nMB,G2H1(93),n2h1(15))
  call Hloop_AV_Q(ntryL,G1H2(163),ex4(:),G1H1(5),m3h2x1(:,98),heltab2x2(:,:,165))
  call Hloop_A_Q(ntryL,G1H1(5),27,nMB,G2H1(94),n2h1(16))
call HGT_OLR(G1H2(164),1,1,2)
call HGT_invQ_OLR(G1H2(164),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(164),-4,nMB,G2H2(187),n2h2(189))
  call Hloop_QS_A(ntryL,G2H2(187),ex3(:),G2H2(189),ngH,m3h1x2(:,68),heltab2x2(:,:,166))
  call Hloop_AV_Q(ntryL,G1H2(167),ex4(:),G1H1(5),m3h2x1(:,99),heltab2x2(:,:,167))
  call Hloop_A_Q(ntryL,G1H1(5),27,nMB,G2H1(95),n2h1(17))
  call Hloop_AV_Q(ntryL,G1H2(168),ex4(:),G1H1(5),m3h2x1(:,100),heltab2x2(:,:,168))
  call Hloop_A_Q(ntryL,G1H1(5),27,nMB,G2H1(96),n2h1(18))
  call Hloop_AV_Q(ntryL,G1H2(169),ex4(:),G1H1(5),m3h2x1(:,101),heltab2x2(:,:,169))
  call Hloop_A_Q(ntryL,G1H1(5),27,nMT,G2H1(97),n2h1(19))
call HGT_OLR(G1H2(170),1,1,2)
call HGT_invQ_OLR(G1H2(170),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(170),-4,nMT,G2H2(187),n2h2(190))
  call Hloop_QS_A(ntryL,G2H2(187),ex3(:),G2H2(190),ngH,m3h1x2(:,69),heltab2x2(:,:,170))
  call Hloop_AV_Q(ntryL,G1H2(173),ex4(:),G1H1(5),m3h2x1(:,102),heltab2x2(:,:,171))
  call Hloop_A_Q(ntryL,G1H1(5),27,nMT,G2H1(98),n2h1(20))
  call Hloop_AV_Q(ntryL,G1H2(174),ex4(:),G1H1(5),m3h2x1(:,103),heltab2x2(:,:,172))
  call Hloop_A_Q(ntryL,G1H1(5),27,nMT,G2H1(99),n2h1(21))
  call Hloop_SV_T(ntryL,G1H2(175),19,ex4(:),8,G2H1(100),m3h2x1(:,104),heltab2x2(:,:,173))
call HGT_OLR(G1H2(176),1,1,2)
call HGT_invQ_OLR(G1H2(176),2,5,2)
  call Hloop_SS_S(ntryL,G1H2(176),ex3(:),G1H2(49),m3h1x2(:,70),heltab2x2(:,:,174))
  call Hloop_SV_T(ntryL,G1H2(179),19,ex4(:),8,G2H1(101),m3h2x1(:,105),heltab2x2(:,:,175))
  call Hloop_SV_T(ntryL,G1H2(180),19,ex4(:),8,G2H1(102),m3h2x1(:,106),heltab2x2(:,:,176))
  call Hloop_AV_Q(ntryL,G1H2(181),ex4(:),G1H1(5),m3h2x1(:,107),heltab2x2(:,:,177))
  call Hloop_A_Q(ntryL,G1H1(5),27,nMB,G2H1(103),n2h1(22))
call HGT_OLR(G1H2(182),1,1,2)
call HGT_invQ_OLR(G1H2(182),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(182),-4,nMB,G2H2(187),n2h2(192))
  call Hloop_QS_A(ntryL,G2H2(187),ex3(:),G2H2(191),ngH,m3h1x2(:,71),heltab2x2(:,:,178))
  call Hloop_AV_Q(ntryL,G1H2(185),ex4(:),G1H1(5),m3h2x1(:,108),heltab2x2(:,:,179))
  call Hloop_A_Q(ntryL,G1H1(5),27,nMB,G2H1(104),n2h1(23))
  call Hloop_AV_Q(ntryL,G1H2(186),ex4(:),G1H1(5),m3h2x1(:,109),heltab2x2(:,:,180))
  call Hloop_A_Q(ntryL,G1H1(5),27,nMB,G2H1(105),n2h1(24))
  call Hloop_SV_T(ntryL,G1H2(187),19,ex4(:),8,G2H1(106),m3h2x1(:,110),heltab2x2(:,:,181))
call HGT_raise_alpha_OLR(G1H2(188),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(188),2,5,2)
  call Hloop_VT_S(ntryL,G1H2(188),-4,ex3(:),4,G2H2(187),m3h1x2(:,72),heltab2x2(:,:,182))
  call Hloop_SV_T(ntryL,G1H2(191),19,ex4(:),8,G2H1(107),m3h2x1(:,111),heltab2x2(:,:,183))
  call Hloop_SV_T(ntryL,G1H2(192),19,ex4(:),8,G2H1(108),m3h2x1(:,112),heltab2x2(:,:,184))
  call Hloop_UW_V(ntryL,G1H2(193),19,ex4(:),8,G2H1(109),m3h2x1(:,113),heltab2x2(:,:,185))
call HGT_OLR(G1H2(194),1,1,2)
call HGT_invQ_OLR(G1H2(194),2,5,2)
  call Hloop_ST_V(ntryL,G1H2(194),-4,ex3(:),4,G2H2(192),m3h1x2(:,73),heltab2x2(:,:,186))
  call Hloop_UW_V(ntryL,G1H2(197),19,ex4(:),8,G2H1(110),m3h2x1(:,114),heltab2x2(:,:,187))
  call Hloop_UW_V(ntryL,G1H2(198),19,ex4(:),8,G2H1(111),m3h2x1(:,115),heltab2x2(:,:,188))
  call Hloop_UW_V(ntryL,G1H2(199),19,ex4(:),8,G2H1(112),m3h2x1(:,116),heltab2x2(:,:,189))
call HGT_raise_alpha_OLR(G1H2(200),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(200),2,5,2)
  call Hloop_VS_V(ntryL,G1H2(200),ex3(:),G1H2(50),m3h1x2(:,74),heltab2x2(:,:,190))
  call Hloop_UW_V(ntryL,G1H2(203),19,ex4(:),8,G2H1(113),m3h2x1(:,117),heltab2x2(:,:,191))
  call Hloop_UW_V(ntryL,G1H2(204),19,ex4(:),8,G2H1(114),m3h2x1(:,118),heltab2x2(:,:,192))
  call Hloop_SQ_A(ntryL,G1H4(137),ex1(:),G1H2(53),ngX,m3h2x2(:,266),heltab2x4(:,:,355))
  call Hloop_Q_A(ntryL,G1H2(53),23,nMB,G2H2(193),n2h2(196))
call HGT_OLR(G1H4(93),1,1,4)
call HGT_invQ_OLR(G1H4(93),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(93),-8,nMB,G2H4(67),n2h4(256))
  call Hloop_AV_Q(ntryL,G2H4(67),ex4(:),G2H2(194),m3h2x2(:,267),heltab2x4(:,:,356))
  call Hloop_SQ_A(ntryL,G1H4(92),ex1(:),G1H2(54),ngX,m3h2x2(:,268),heltab2x4(:,:,357))
  call Hloop_Q_A(ntryL,G1H2(54),23,nMB,G2H2(195),n2h2(197))
  call Hloop_SQ_A(ntryL,G1H4(141),ex1(:),G1H2(55),ngX,m3h2x2(:,269),heltab2x4(:,:,358))
  call Hloop_Q_A(ntryL,G1H2(55),23,nMB,G2H2(196),n2h2(198))
  call Hloop_SQ_A(ntryL,G1H4(98),ex1(:),G1H2(56),ngPtb,m3h2x2(:,270),heltab2x4(:,:,359))
  call Hloop_Q_A(ntryL,G1H2(56),23,nMT,G2H2(197),n2h2(199))
call HGT_OLR(G1H4(142),1,1,4)
call HGT_invQ_OLR(G1H4(142),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(142),-8,nMT,G2H4(68),n2h4(257))
  call Hloop_AV_Q(ntryL,G2H4(68),ex4(:),G2H2(198),m3h2x2(:,271),heltab2x4(:,:,360))
  call Hloop_SQ_A(ntryL,G1H4(111),ex1(:),G1H2(59),ngPtb,m3h2x2(:,272),heltab2x4(:,:,361))
  call Hloop_Q_A(ntryL,G1H2(59),23,nMT,G2H2(199),n2h2(200))
  call Hloop_SQ_A(ntryL,G1H4(94),ex1(:),G1H2(60),ngPtb,m3h2x2(:,273),heltab2x4(:,:,362))
  call Hloop_Q_A(ntryL,G1H2(60),23,nMT,G2H2(200),n2h2(201))
  call Hloop_ZQ_A(ntryL,G1H4(145),ex1(:),G1H2(268),ngZd,m3h2x2(:,274),heltab2x4(:,:,363))
  call Hloop_Q_A(ntryL,G1H2(268),23,nMB,G2H2(201),n2h2(202))
call HGT_OLR(G1H4(112),1,1,4)
call HGT_invQ_OLR(G1H4(112),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(112),-8,nMB,G2H4(69),n2h4(258))
  call Hloop_AV_Q(ntryL,G2H4(69),ex4(:),G2H2(202),m3h2x2(:,275),heltab2x4(:,:,364))
  call Hloop_ZQ_A(ntryL,G1H4(147),ex1(:),G1H2(6),ngZd,m3h2x2(:,276),heltab2x4(:,:,365))
  call Hloop_Q_A(ntryL,G1H2(6),23,nMB,G2H2(203),n2h2(203))
  call Hloop_ZQ_A(ntryL,G1H4(115),ex1(:),G1H2(283),ngZd,m3h2x2(:,277),heltab2x4(:,:,366))
  call Hloop_Q_A(ntryL,G1H2(283),23,nMB,G2H2(204),n2h2(204))
  call Hloop_WQ_A(ntryL,G1H4(102),ex1(:),G1H2(5),m3h2x2(:,278),heltab2x4(:,:,367))
  call Hloop_Q_A(ntryL,G1H2(5),23,nMT,G2H2(205),n2h2(205))
call HGT_OLR(G1H4(103),1,1,4)
call HGT_invQ_OLR(G1H4(103),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(103),-8,nMT,G2H4(36),n2h4(259))
  call Hloop_AV_Q(ntryL,G2H4(36),ex4(:),G2H2(206),m3h2x2(:,279),heltab2x4(:,:,368))
  call Hloop_WQ_A(ntryL,G1H4(148),ex1(:),G1H2(284),m3h2x2(:,280),heltab2x4(:,:,369))
  call Hloop_Q_A(ntryL,G1H2(284),23,nMT,G2H2(207),n2h2(206))
  call Hloop_WQ_A(ntryL,G1H4(149),ex1(:),G1H2(8),m3h2x2(:,281),heltab2x4(:,:,370))
  call Hloop_Q_A(ntryL,G1H2(8),23,nMT,G2H2(208),n2h2(207))
  call Hloop_SQ_A(ntryL,G1H2(205),ex1(:),G1H1(5),ngPtb,m3h2x1(:,119),heltab2x2(:,:,193))
  call Hloop_Q_A(ntryL,G1H1(5),27,nMT,G2H1(115),n2h1(25))
call HGT_OLR(G1H2(206),1,1,2)
call HGT_invQ_OLR(G1H2(206),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(206),-4,nMT,G2H2(209),n2h2(208))
  call Hloop_AS_Q(ntryL,G2H2(209),ex3(:),G2H2(210),ngH,m3h1x2(:,75),heltab2x2(:,:,194))
  call Hloop_SQ_A(ntryL,G1H2(209),ex1(:),G1H1(5),ngPtb,m3h2x1(:,120),heltab2x2(:,:,195))
  call Hloop_Q_A(ntryL,G1H1(5),27,nMT,G2H1(116),n2h1(26))
  call Hloop_SQ_A(ntryL,G1H2(210),ex1(:),G1H1(5),ngPtb,m3h2x1(:,121),heltab2x2(:,:,196))
  call Hloop_Q_A(ntryL,G1H1(5),27,nMT,G2H1(117),n2h1(27))
  call Hloop_WQ_A(ntryL,G1H2(211),ex1(:),G1H1(5),m3h2x1(:,122),heltab2x2(:,:,197))
  call Hloop_Q_A(ntryL,G1H1(5),27,nMT,G2H1(118),n2h1(28))
call HGT_OLR(G1H2(212),1,1,2)
call HGT_invQ_OLR(G1H2(212),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(212),-4,nMT,G2H2(209),n2h2(209))
  call Hloop_AS_Q(ntryL,G2H2(209),ex3(:),G2H2(211),ngH,m3h1x2(:,76),heltab2x2(:,:,198))
  call Hloop_WQ_A(ntryL,G1H2(215),ex1(:),G1H1(5),m3h2x1(:,123),heltab2x2(:,:,199))
  call Hloop_Q_A(ntryL,G1H1(5),27,nMT,G2H1(119),n2h1(29))
  call Hloop_WQ_A(ntryL,G1H2(216),ex1(:),G1H1(5),m3h2x1(:,124),heltab2x2(:,:,200))
  call Hloop_Q_A(ntryL,G1H1(5),27,nMT,G2H1(120),n2h1(30))
  call Hloop_SA_Q(ntryL,G1H4(150),ex2(:),G1H2(23),ngX,m3h2x2(:,282),heltab2x4(:,:,371))
  call Hloop_A_Q(ntryL,G1H2(23),23,nMB,G2H2(209),n2h2(210))
call HGT_OLR(G1H4(152),1,1,4)
call HGT_invQ_OLR(G1H4(152),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(152),-8,nMB,G2H4(23),n2h4(260))
  call Hloop_QV_A(ntryL,G2H4(23),ex4(:),G2H2(212),m3h2x2(:,283),heltab2x4(:,:,372))
  call Hloop_SA_Q(ntryL,G1H4(155),ex2(:),G1H2(299),ngX,m3h2x2(:,284),heltab2x4(:,:,373))
  call Hloop_A_Q(ntryL,G1H2(299),23,nMB,G2H2(213),n2h2(211))
  call Hloop_SA_Q(ntryL,G1H4(156),ex2(:),G1H2(24),ngX,m3h2x2(:,285),heltab2x4(:,:,374))
  call Hloop_A_Q(ntryL,G1H2(24),23,nMB,G2H2(214),n2h2(212))
  call Hloop_SA_Q(ntryL,G1H4(158),ex2(:),G1H2(300),ngPbt,m3h2x2(:,286),heltab2x4(:,:,375))
  call Hloop_A_Q(ntryL,G1H2(300),23,nMT,G2H2(215),n2h2(213))
call HGT_OLR(G1H4(159),1,1,4)
call HGT_invQ_OLR(G1H4(159),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(159),-8,nMT,G2H4(28),n2h4(261))
  call Hloop_QV_A(ntryL,G2H4(28),ex4(:),G2H2(216),m3h2x2(:,287),heltab2x4(:,:,376))
  call Hloop_SA_Q(ntryL,G1H4(108),ex2(:),G1H2(25),ngPbt,m3h2x2(:,288),heltab2x4(:,:,377))
  call Hloop_A_Q(ntryL,G1H2(25),23,nMT,G2H2(217),n2h2(214))
  call Hloop_SA_Q(ntryL,G1H4(161),ex2(:),G1H2(251),ngPbt,m3h2x2(:,289),heltab2x4(:,:,378))
  call Hloop_A_Q(ntryL,G1H2(251),23,nMT,G2H2(218),n2h2(215))
  call Hloop_ZA_Q(ntryL,G1H4(162),ex2(:),G1H2(26),ngZd,m3h2x2(:,290),heltab2x4(:,:,379))
  call Hloop_A_Q(ntryL,G1H2(26),23,nMB,G2H2(219),n2h2(216))
call HGT_OLR(G1H4(163),1,1,4)
call HGT_invQ_OLR(G1H4(163),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(163),-8,nMB,G2H4(1),n2h4(262))
  call Hloop_QV_A(ntryL,G2H4(1),ex4(:),G2H2(220),m3h2x2(:,291),heltab2x4(:,:,380))
  call Hloop_ZA_Q(ntryL,G1H4(167),ex2(:),G1H2(29),ngZd,m3h2x2(:,292),heltab2x4(:,:,381))
  call Hloop_A_Q(ntryL,G1H2(29),23,nMB,G2H2(221),n2h2(217))
  call Hloop_ZA_Q(ntryL,G1H4(168),ex2(:),G1H2(252),ngZd,m3h2x2(:,293),heltab2x4(:,:,382))
  call Hloop_A_Q(ntryL,G1H2(252),23,nMB,G2H2(222),n2h2(218))
  call Hloop_WA_Q(ntryL,G1H4(169),ex2(:),G1H2(30),m3h2x2(:,294),heltab2x4(:,:,383))
  call Hloop_A_Q(ntryL,G1H2(30),23,nMT,G2H2(223),n2h2(219))
call HGT_OLR(G1H4(170),1,1,4)
call HGT_invQ_OLR(G1H4(170),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(170),-8,nMT,G2H4(4),n2h4(263))
  call Hloop_QV_A(ntryL,G2H4(4),ex4(:),G2H2(224),m3h2x2(:,295),heltab2x4(:,:,384))
  call Hloop_WA_Q(ntryL,G1H4(174),ex2(:),G1H2(21),m3h2x2(:,296),heltab2x4(:,:,385))
  call Hloop_A_Q(ntryL,G1H2(21),23,nMT,G2H2(225),n2h2(220))
  call Hloop_WA_Q(ntryL,G1H4(175),ex2(:),G1H2(31),m3h2x2(:,297),heltab2x4(:,:,386))
  call Hloop_A_Q(ntryL,G1H2(31),23,nMT,G2H2(226),n2h2(221))
  call Hloop_TV_S(ntryL,G1H4(113),21,ex4(:),8,G2H2(227),m3h2x2(:,298),heltab2x4(:,:,387))
call HGT_OLR(G1H4(114),1,1,4)
call HGT_invQ_OLR(G1H4(114),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(114),-2,nMT,G2H4(2),n2h4(264))
  call Hloop_QA_S(ntryL,G2H4(2),ex2(:),G2H2(228),ngPbt,m3h2x2(:,299),heltab2x4(:,:,388))
  call Hloop_TV_S(ntryL,G1H4(179),21,ex4(:),8,G2H2(229),m3h2x2(:,300),heltab2x4(:,:,389))
  call Hloop_TV_S(ntryL,G1H4(180),21,ex4(:),8,G2H2(230),m3h2x2(:,301),heltab2x4(:,:,390))
  call Hloop_QV_A(ntryL,G1H4(181),ex4(:),G1H2(61),m3h2x2(:,302),heltab2x4(:,:,391))
  call Hloop_Q_A(ntryL,G1H2(61),29,nMB,G2H2(231),n2h2(222))
call HGT_raise_alpha_OLR(G1H4(183),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(183),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(183),ex2(:),G1H2(62),ngZd,m3h2x2(:,303),heltab2x4(:,:,392))
  call Hloop_QV_A(ntryL,G1H4(186),ex4(:),G1H2(65),m3h2x2(:,304),heltab2x4(:,:,393))
  call Hloop_Q_A(ntryL,G1H2(65),29,nMB,G2H2(232),n2h2(223))
  call Hloop_QV_A(ntryL,G1H4(187),ex4(:),G1H2(66),m3h2x2(:,305),heltab2x4(:,:,394))
  call Hloop_Q_A(ntryL,G1H2(66),29,nMB,G2H2(233),n2h2(224))
  call Hloop_UV_W(ntryL,G1H4(189),21,ex4(:),8,G2H2(234),m3h2x2(:,306),heltab2x4(:,:,395))
call HGT_OLR(G1H4(190),1,1,4)
call HGT_invQ_OLR(G1H4(190),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(190),-2,nMT,G2H4(44),n2h4(266))
  call Hloop_QA_W(ntryL,G2H4(44),ex2(:),G2H2(235),m3h2x2(:,307),heltab2x4(:,:,396))
  call Hloop_UV_W(ntryL,G1H4(193),21,ex4(:),8,G2H2(236),m3h2x2(:,308),heltab2x4(:,:,397))
  call Hloop_UV_W(ntryL,G1H4(195),21,ex4(:),8,G2H2(237),m3h2x2(:,309),heltab2x4(:,:,398))
  call Hloop_SA_Q(ntryL,G1H2(217),ex2(:),G1H1(5),ngPbt,m3h2x1(:,125),heltab2x2(:,:,201))
  call Hloop_A_Q(ntryL,G1H1(5),27,nMT,G2H1(121),n2h1(31))
call HGT_OLR(G1H2(218),1,1,2)
call HGT_invQ_OLR(G1H2(218),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(218),-4,nMT,G2H2(238),n2h2(225))
  call Hloop_QS_A(ntryL,G2H2(238),ex3(:),G2H2(239),ngH,m3h1x2(:,77),heltab2x2(:,:,202))
  call Hloop_SA_Q(ntryL,G1H2(221),ex2(:),G1H1(5),ngPbt,m3h2x1(:,126),heltab2x2(:,:,203))
  call Hloop_A_Q(ntryL,G1H1(5),27,nMT,G2H1(122),n2h1(32))
  call Hloop_SA_Q(ntryL,G1H2(222),ex2(:),G1H1(5),ngPbt,m3h2x1(:,127),heltab2x2(:,:,204))
  call Hloop_A_Q(ntryL,G1H1(5),27,nMT,G2H1(123),n2h1(33))
  call Hloop_WA_Q(ntryL,G1H2(223),ex2(:),G1H1(5),m3h2x1(:,128),heltab2x2(:,:,205))
  call Hloop_A_Q(ntryL,G1H1(5),27,nMT,G2H1(124),n2h1(34))
call HGT_OLR(G1H2(224),1,1,2)
call HGT_invQ_OLR(G1H2(224),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(224),-4,nMT,G2H2(238),n2h2(226))
  call Hloop_QS_A(ntryL,G2H2(238),ex3(:),G2H2(240),ngH,m3h1x2(:,78),heltab2x2(:,:,206))
  call Hloop_WA_Q(ntryL,G1H2(227),ex2(:),G1H1(5),m3h2x1(:,129),heltab2x2(:,:,207))
  call Hloop_A_Q(ntryL,G1H1(5),27,nMT,G2H1(125),n2h1(35))
  call Hloop_WA_Q(ntryL,G1H2(228),ex2(:),G1H1(5),m3h2x1(:,130),heltab2x2(:,:,208))
  call Hloop_A_Q(ntryL,G1H1(5),27,nMT,G2H1(126),n2h1(36))
  call Hloop_QS_A(ntryL,G1H2(229),ex3(:),G1H2(67),ngH,m3h1x2(:,79),heltab2x2(:,:,209))
  call Hloop_Q_A(ntryL,G1H2(67),29,nMB,G2H2(238),n2h2(227))
call HGT_raise_alpha_OLR(G1H2(230),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(230),2,5,2)
  call Hloop_ZA_Q(ntryL,G1H2(230),ex2(:),G1H1(5),ngZd,m3h2x1(:,131),heltab2x2(:,:,210))
  call Hloop_QS_A(ntryL,G1H2(233),ex3(:),G1H2(68),ngH,m3h1x2(:,80),heltab2x2(:,:,211))
  call Hloop_Q_A(ntryL,G1H2(68),29,nMB,G2H2(241),n2h2(229))
  call Hloop_QS_A(ntryL,G1H2(234),ex3(:),G1H2(71),ngH,m3h1x2(:,81),heltab2x2(:,:,212))
  call Hloop_Q_A(ntryL,G1H2(71),29,nMB,G2H2(242),n2h2(230))
  call Hloop_VT_S(ntryL,G1H2(235),25,ex3(:),4,G2H2(243),m3h1x2(:,82),heltab2x2(:,:,213))
call HGT_OLR(G1H2(236),1,1,2)
call HGT_invQ_OLR(G1H2(236),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(236),-2,nMT,G2H2(244),n2h2(231))
  call Hloop_QA_S(ntryL,G2H2(244),ex2(:),G2H1(127),ngPbt,m3h2x1(:,132),heltab2x2(:,:,214))
  call Hloop_VT_S(ntryL,G1H2(239),25,ex3(:),4,G2H2(244),m3h1x2(:,83),heltab2x2(:,:,215))
  call Hloop_VT_S(ntryL,G1H2(240),25,ex3(:),4,G2H2(245),m3h1x2(:,84),heltab2x2(:,:,216))
  call Hloop_ST_V(ntryL,G1H2(241),25,ex3(:),4,G2H2(246),m3h1x2(:,85),heltab2x2(:,:,217))
call HGT_OLR(G1H2(242),1,1,2)
call HGT_invQ_OLR(G1H2(242),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(242),-2,nMT,G2H2(247),n2h2(232))
  call Hloop_QA_W(ntryL,G2H2(247),ex2(:),G2H1(128),m3h2x1(:,133),heltab2x2(:,:,218))
  call Hloop_ST_V(ntryL,G1H2(245),25,ex3(:),4,G2H2(247),m3h1x2(:,86),heltab2x2(:,:,219))
  call Hloop_ST_V(ntryL,G1H2(246),25,ex3(:),4,G2H2(248),m3h1x2(:,87),heltab2x2(:,:,220))
  call Hloop_QV_A(ntryL,G1H4(196),ex4(:),G1H2(72),m3h2x2(:,310),heltab2x4(:,:,399))
  call Hloop_Q_A(ntryL,G1H2(72),29,nMB,G2H2(249),n2h2(233))
call HGT_OLR(G1H4(197),1,1,4)
call HGT_invQ_OLR(G1H4(197),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(197),ex2(:),G1H2(73),ngX,m3h2x2(:,311),heltab2x4(:,:,400))
  call Hloop_QV_A(ntryL,G1H4(201),ex4(:),G1H2(74),m3h2x2(:,312),heltab2x4(:,:,401))
  call Hloop_Q_A(ntryL,G1H2(74),29,nMB,G2H2(250),n2h2(234))
  call Hloop_QV_A(ntryL,G1H4(33),ex4(:),G1H2(77),m3h2x2(:,313),heltab2x4(:,:,402))
  call Hloop_Q_A(ntryL,G1H2(77),29,nMB,G2H2(251),n2h2(235))
call HGT_OLR(G1H4(21),1,1,4)
call HGT_invQ_OLR(G1H4(21),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(21),ex2(:),G1H2(78),ngX,m3h2x2(:,314),heltab2x4(:,:,403))
  call Hloop_QV_A(ntryL,G1H4(56),ex4(:),G1H2(79),m3h2x2(:,315),heltab2x4(:,:,404))
  call Hloop_Q_A(ntryL,G1H2(79),29,nMB,G2H2(252),n2h2(236))
call HGT_OLR(G1H4(34),1,1,4)
call HGT_invQ_OLR(G1H4(34),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(34),ex2(:),G1H2(80),ngX,m3h2x2(:,316),heltab2x4(:,:,405))
  call Hloop_QV_A(ntryL,G1H4(143),ex4(:),G1H2(83),m3h2x2(:,317),heltab2x4(:,:,406))
  call Hloop_Q_A(ntryL,G1H2(83),29,nMB,G2H2(253),n2h2(237))
  call Hloop_QV_A(ntryL,G1H4(100),ex4(:),G1H2(84),m3h2x2(:,318),heltab2x4(:,:,407))
  call Hloop_Q_A(ntryL,G1H2(84),29,nMB,G2H2(254),n2h2(238))
call HGT_OLR(G1H4(99),1,1,4)
call HGT_invQ_OLR(G1H4(99),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(99),ex2(:),G1H2(85),ngH,m3h2x2(:,319),heltab2x4(:,:,408))
  call Hloop_QV_A(ntryL,G1H4(203),ex4(:),G1H2(86),m3h2x2(:,320),heltab2x4(:,:,409))
  call Hloop_Q_A(ntryL,G1H2(86),29,nMB,G2H2(255),n2h2(239))
  call Hloop_QV_A(ntryL,G1H4(208),ex4(:),G1H2(89),m3h2x2(:,321),heltab2x4(:,:,410))
  call Hloop_Q_A(ntryL,G1H2(89),29,nMB,G2H2(256),n2h2(240))
call HGT_OLR(G1H4(204),1,1,4)
call HGT_invQ_OLR(G1H4(204),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(204),ex2(:),G1H2(90),ngH,m3h2x2(:,322),heltab2x4(:,:,411))
  call Hloop_QV_A(ntryL,G1H4(207),ex4(:),G1H2(91),m3h2x2(:,323),heltab2x4(:,:,412))
  call Hloop_Q_A(ntryL,G1H2(91),29,nMB,G2H2(257),n2h2(241))
call HGT_OLR(G1H4(209),1,1,4)
call HGT_invQ_OLR(G1H4(209),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(209),ex2(:),G1H2(92),ngH,m3h2x2(:,324),heltab2x4(:,:,413))
  call Hloop_QV_A(ntryL,G1H4(212),ex4(:),G1H2(95),m3h2x2(:,325),heltab2x4(:,:,414))
  call Hloop_Q_A(ntryL,G1H2(95),29,nMB,G2H2(258),n2h2(242))
  call Hloop_QV_A(ntryL,G1H4(213),ex4(:),G1H2(96),m3h2x2(:,326),heltab2x4(:,:,415))
  call Hloop_Q_A(ntryL,G1H2(96),29,nMT,G2H2(259),n2h2(243))
call HGT_OLR(G1H4(214),1,1,4)
call HGT_invQ_OLR(G1H4(214),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(214),ex2(:),G1H2(97),ngPbt,m3h2x2(:,327),heltab2x4(:,:,416))
  call Hloop_QV_A(ntryL,G1H4(219),ex4(:),G1H2(98),m3h2x2(:,328),heltab2x4(:,:,417))
  call Hloop_Q_A(ntryL,G1H2(98),29,nMT,G2H2(260),n2h2(244))
  call Hloop_QV_A(ntryL,G1H4(224),ex4(:),G1H2(101),m3h2x2(:,329),heltab2x4(:,:,418))
  call Hloop_Q_A(ntryL,G1H2(101),29,nMT,G2H2(261),n2h2(245))
call HGT_OLR(G1H4(220),1,1,4)
call HGT_invQ_OLR(G1H4(220),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(220),ex2(:),G1H2(102),ngPbt,m3h2x2(:,330),heltab2x4(:,:,419))
  call Hloop_QV_A(ntryL,G1H4(223),ex4(:),G1H2(103),m3h2x2(:,331),heltab2x4(:,:,420))
  call Hloop_Q_A(ntryL,G1H2(103),29,nMT,G2H2(262),n2h2(246))
call HGT_OLR(G1H4(225),1,1,4)
call HGT_invQ_OLR(G1H4(225),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(225),ex2(:),G1H2(104),ngPbt,m3h2x2(:,332),heltab2x4(:,:,421))
  call Hloop_QV_A(ntryL,G1H4(228),ex4(:),G1H2(107),m3h2x2(:,333),heltab2x4(:,:,422))
  call Hloop_Q_A(ntryL,G1H2(107),29,nMT,G2H2(263),n2h2(247))
  call Hloop_QV_A(ntryL,G1H4(229),ex4(:),G1H2(108),m3h2x2(:,334),heltab2x4(:,:,423))
  call Hloop_Q_A(ntryL,G1H2(108),29,nMT,G2H2(264),n2h2(248))
call HGT_raise_alpha_OLR(G1H4(230),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(230),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(230),ex2(:),G1H2(109),m3h2x2(:,335),heltab2x4(:,:,424))
  call Hloop_QV_A(ntryL,G1H4(235),ex4(:),G1H2(35),m3h2x2(:,336),heltab2x4(:,:,425))
  call Hloop_Q_A(ntryL,G1H2(35),29,nMT,G2H2(265),n2h2(249))
  call Hloop_QV_A(ntryL,G1H4(240),ex4(:),G1H2(110),m3h2x2(:,337),heltab2x4(:,:,426))
  call Hloop_Q_A(ntryL,G1H2(110),29,nMT,G2H2(266),n2h2(250))
call HGT_raise_alpha_OLR(G1H4(236),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(236),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(236),ex2(:),G1H2(113),m3h2x2(:,338),heltab2x4(:,:,427))
  call Hloop_QV_A(ntryL,G1H4(239),ex4(:),G1H2(1),m3h2x2(:,339),heltab2x4(:,:,428))
  call Hloop_Q_A(ntryL,G1H2(1),29,nMT,G2H2(267),n2h2(251))
call HGT_raise_alpha_OLR(G1H4(241),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(241),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(241),ex2(:),G1H2(114),m3h2x2(:,340),heltab2x4(:,:,429))
  call Hloop_QV_A(ntryL,G1H4(244),ex4(:),G1H2(36),m3h2x2(:,341),heltab2x4(:,:,430))
  call Hloop_Q_A(ntryL,G1H2(36),29,nMT,G2H2(268),n2h2(252))
  call Hloop_QS_A(ntryL,G1H2(247),ex3(:),G1H2(115),ngH,m3h1x2(:,88),heltab2x2(:,:,221))
  call Hloop_Q_A(ntryL,G1H2(115),29,nMB,G2H2(269),n2h2(253))
call HGT_OLR(G1H2(248),1,1,2)
call HGT_invQ_OLR(G1H2(248),2,5,2)
  call Hloop_SA_Q(ntryL,G1H2(248),ex2(:),G1H1(6),ngX,m3h2x1(:,134),heltab2x2(:,:,222))
  call Hloop_QS_A(ntryL,G1H2(253),ex3(:),G1H2(3),ngH,m3h1x2(:,89),heltab2x2(:,:,223))
  call Hloop_Q_A(ntryL,G1H2(3),29,nMB,G2H2(270),n2h2(255))
  call Hloop_QS_A(ntryL,G1H2(258),ex3(:),G1H2(116),ngH,m3h1x2(:,90),heltab2x2(:,:,224))
  call Hloop_Q_A(ntryL,G1H2(116),29,nMB,G2H2(271),n2h2(256))
call HGT_OLR(G1H2(254),1,1,2)
call HGT_invQ_OLR(G1H2(254),2,5,2)
  call Hloop_SA_Q(ntryL,G1H2(254),ex2(:),G1H1(7),ngX,m3h2x1(:,135),heltab2x2(:,:,225))
  call Hloop_QS_A(ntryL,G1H2(257),ex3(:),G1H2(119),ngH,m3h1x2(:,91),heltab2x2(:,:,226))
  call Hloop_Q_A(ntryL,G1H2(119),29,nMB,G2H2(272),n2h2(258))
call HGT_OLR(G1H2(259),1,1,2)
call HGT_invQ_OLR(G1H2(259),2,5,2)
  call Hloop_SA_Q(ntryL,G1H2(259),ex2(:),G1H1(8),ngX,m3h2x1(:,136),heltab2x2(:,:,227))
  call Hloop_QS_A(ntryL,G1H2(262),ex3(:),G1H2(37),ngH,m3h1x2(:,92),heltab2x2(:,:,228))
  call Hloop_Q_A(ntryL,G1H2(37),29,nMB,G2H2(273),n2h2(260))
  call Hloop_QS_A(ntryL,G1H2(263),ex3(:),G1H2(120),ngH,m3h1x2(:,93),heltab2x2(:,:,229))
  call Hloop_Q_A(ntryL,G1H2(120),29,nMB,G2H2(274),n2h2(261))
call HGT_OLR(G1H2(264),1,1,2)
call HGT_invQ_OLR(G1H2(264),2,5,2)
  call Hloop_SA_Q(ntryL,G1H2(264),ex2(:),G1H1(9),ngH,m3h2x1(:,137),heltab2x2(:,:,230))
  call Hloop_QS_A(ntryL,G1H2(269),ex3(:),G1H2(38),ngH,m3h1x2(:,94),heltab2x2(:,:,231))
  call Hloop_Q_A(ntryL,G1H2(38),29,nMB,G2H2(275),n2h2(263))
  call Hloop_QS_A(ntryL,G1H2(274),ex3(:),G1H2(121),ngH,m3h1x2(:,95),heltab2x2(:,:,232))
  call Hloop_Q_A(ntryL,G1H2(121),29,nMB,G2H2(276),n2h2(264))
call HGT_OLR(G1H2(270),1,1,2)
call HGT_invQ_OLR(G1H2(270),2,5,2)
  call Hloop_SA_Q(ntryL,G1H2(270),ex2(:),G1H1(10),ngH,m3h2x1(:,138),heltab2x2(:,:,233))
  call Hloop_QS_A(ntryL,G1H2(273),ex3(:),G1H2(41),ngH,m3h1x2(:,96),heltab2x2(:,:,234))
  call Hloop_Q_A(ntryL,G1H2(41),29,nMB,G2H2(277),n2h2(266))
call HGT_OLR(G1H2(275),1,1,2)
call HGT_invQ_OLR(G1H2(275),2,5,2)
  call Hloop_SA_Q(ntryL,G1H2(275),ex2(:),G1H1(11),ngH,m3h2x1(:,139),heltab2x2(:,:,235))
  call Hloop_QS_A(ntryL,G1H2(278),ex3(:),G1H2(122),ngH,m3h1x2(:,97),heltab2x2(:,:,236))
  call Hloop_Q_A(ntryL,G1H2(122),29,nMB,G2H2(278),n2h2(268))
  call Hloop_QS_A(ntryL,G1H2(279),ex3(:),G1H2(125),ngH,m3h1x2(:,98),heltab2x2(:,:,237))
  call Hloop_Q_A(ntryL,G1H2(125),29,nMT,G2H2(279),n2h2(269))
call HGT_OLR(G1H2(280),1,1,2)
call HGT_invQ_OLR(G1H2(280),2,5,2)
  call Hloop_SA_Q(ntryL,G1H2(280),ex2(:),G1H1(12),ngPbt,m3h2x1(:,140),heltab2x2(:,:,238))
  call Hloop_QS_A(ntryL,G1H2(285),ex3(:),G1H2(42),ngH,m3h1x2(:,99),heltab2x2(:,:,239))
  call Hloop_Q_A(ntryL,G1H2(42),29,nMT,G2H2(280),n2h2(271))
  call Hloop_QS_A(ntryL,G1H2(290),ex3(:),G1H2(126),ngH,m3h1x2(:,100),heltab2x2(:,:,240))
  call Hloop_Q_A(ntryL,G1H2(126),29,nMT,G2H2(281),n2h2(272))
call HGT_OLR(G1H2(286),1,1,2)
call HGT_invQ_OLR(G1H2(286),2,5,2)
  call Hloop_SA_Q(ntryL,G1H2(286),ex2(:),G1H1(13),ngPbt,m3h2x1(:,141),heltab2x2(:,:,241))
  call Hloop_QS_A(ntryL,G1H2(289),ex3(:),G1H2(43),ngH,m3h1x2(:,101),heltab2x2(:,:,242))
  call Hloop_Q_A(ntryL,G1H2(43),29,nMT,G2H2(282),n2h2(274))
call HGT_OLR(G1H2(291),1,1,2)
call HGT_invQ_OLR(G1H2(291),2,5,2)
  call Hloop_SA_Q(ntryL,G1H2(291),ex2(:),G1H1(14),ngPbt,m3h2x1(:,142),heltab2x2(:,:,243))
  call Hloop_QS_A(ntryL,G1H2(294),ex3(:),G1H2(127),ngH,m3h1x2(:,102),heltab2x2(:,:,244))
  call Hloop_Q_A(ntryL,G1H2(127),29,nMT,G2H2(283),n2h2(276))
  call Hloop_QS_A(ntryL,G1H2(295),ex3(:),G1H2(44),ngH,m3h1x2(:,103),heltab2x2(:,:,245))
  call Hloop_Q_A(ntryL,G1H2(44),29,nMT,G2H2(284),n2h2(277))
call HGT_raise_alpha_OLR(G1H2(296),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(296),2,5,2)
  call Hloop_WA_Q(ntryL,G1H2(296),ex2(:),G1H1(15),m3h2x1(:,143),heltab2x2(:,:,246))
  call Hloop_QS_A(ntryL,G1H2(301),ex3(:),G1H2(128),ngH,m3h1x2(:,104),heltab2x2(:,:,247))
  call Hloop_Q_A(ntryL,G1H2(128),29,nMT,G2H2(285),n2h2(279))
  call Hloop_QS_A(ntryL,G1H2(306),ex3(:),G1H2(131),ngH,m3h1x2(:,105),heltab2x2(:,:,248))
  call Hloop_Q_A(ntryL,G1H2(131),29,nMT,G2H2(286),n2h2(280))
call HGT_raise_alpha_OLR(G1H2(302),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(302),2,5,2)
  call Hloop_WA_Q(ntryL,G1H2(302),ex2(:),G1H1(16),m3h2x1(:,144),heltab2x2(:,:,249))
  call Hloop_QS_A(ntryL,G1H2(305),ex3(:),G1H2(47),ngH,m3h1x2(:,106),heltab2x2(:,:,250))
  call Hloop_Q_A(ntryL,G1H2(47),29,nMT,G2H2(287),n2h2(282))
call HGT_raise_alpha_OLR(G1H2(307),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(307),2,5,2)
  call Hloop_WA_Q(ntryL,G1H2(307),ex2(:),G1H1(17),m3h2x1(:,145),heltab2x2(:,:,251))
  call Hloop_QS_A(ntryL,G1H2(310),ex3(:),G1H2(132),ngH,m3h1x2(:,107),heltab2x2(:,:,252))
  call Hloop_Q_A(ntryL,G1H2(132),29,nMT,G2H2(288),n2h2(284))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(122),[G2H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(130),[G2H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(118),[G2H2(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(126),[G2H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(79),[G2H1(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(70),[G2H1(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(82),[G2H1(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(76),[G2H1(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(178),[G2H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(184),[G2H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(175),[G2H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(181),[G2H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(109),[G2H1(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(100),[G2H1(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(112),[G2H1(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(106),[G2H1(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(227),[G2H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(234),[G2H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(243),[G2H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(246),[G2H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(84),[G2H2(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(88),[G2H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(90),[G2H2(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(94),[G2H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(149),[G2H2(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(152),[G2H2(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(153),[G2H2(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(156),[G2H2(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(201),[G2H2(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(204),[G2H2(196)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(205),[G2H2(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(208),[G2H2(200)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(118),[G2H1(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(120),[G2H1(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(219),[G2H2(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(222),[G2H2(214)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(223),[G2H2(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(226),[G2H2(218)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(124),[G2H1(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(126),[G2H1(123)])
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(1),mass5set(:,1),  & 
G1H2(48),G1H2(133),G1H2(134),G1H2(137),G1H2(138),G1H2(139),2)
  call HG1shiftOLR(G1H2(133),8,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(3),ex4(:),G2tensor(1),m3h2x1(:,146),heltab2x2(:,:,253))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(16),ex4(:),G2tensor(2),m3h2x1(:,147),heltab2x2(:,:,254))
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(1),mass5set(:,1),  & 
G1H2(140),G1H2(143),G1H2(144),G1H2(145),G1H2(146),G1H2(149),2)
  call HG1shiftOLR(G1H2(143),8,2)
  call Hotf_5pt_reduction(G2H2(122),RedSet_5(9),mass5set(:,16),  & 
G1H2(150),G1H2(151),G1H2(152),G1H2(155),G1H2(156),G1H2(157),2)
  call HG1shiftOLR(G1H2(151),8,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(130),ex4(:),G2tensor(3),m3h2x1(:,148),heltab2x2(:,:,255))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(118),ex4(:),G2tensor(4),m3h2x1(:,149),heltab2x2(:,:,256))
  call Hotf_5pt_reduction(G2H2(126),RedSet_5(9),mass5set(:,16),  & 
G1H2(158),G1H2(161),G1H2(162),G1H2(163),G1H2(164),G1H2(167),2)
  call HG1shiftOLR(G1H2(161),8,2)
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(2),mass5set(:,1),  & 
G1H2(168),G1H2(169),G1H2(170),G1H2(173),G1H2(174),G1H2(175),2)
  call HG1shiftOLR(G1H2(169),8,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(6),ex4(:),G2tensor(5),m3h2x1(:,150),heltab2x2(:,:,257))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(7),ex4(:),G2tensor(6),m3h2x1(:,151),heltab2x2(:,:,258))
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(2),mass5set(:,1),  & 
G1H2(176),G1H2(179),G1H2(180),G1H2(181),G1H2(182),G1H2(185),2)
  call HG1shiftOLR(G1H2(179),8,2)
  call Hotf_5pt_reduction(G2H1(79),RedSet_5(10),mass5set(:,16),  & 
G1H1(18),G1H1(19),G1H1(20),G1H1(21),G1H1(22),G1H1(23),1)
  call HG1shiftOLR(G1H1(19),4,1)
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(70),ex3(:),G2tensor(7),m3h1x1(:,1),heltab2x1(:,:,1))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(82),ex3(:),G2tensor(8),m3h1x1(:,2),heltab2x1(:,:,2))
  call Hotf_5pt_reduction(G2H1(76),RedSet_5(10),mass5set(:,16),  & 
G1H1(24),G1H1(25),G1H1(26),G1H1(27),G1H1(28),G1H1(29),1)
  call HG1shiftOLR(G1H1(25),4,1)
  call Hotf_5pt_reduction(G2H2(178),RedSet_5(11),mass5set(:,16),  & 
G1H2(186),G1H2(187),G1H2(188),G1H2(191),G1H2(192),G1H2(193),2)
  call HG1shiftOLR(G1H2(187),8,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(184),ex4(:),G2tensor(9),m3h2x1(:,152),heltab2x2(:,:,259))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(175),ex4(:),G2tensor(10),m3h2x1(:,153),heltab2x2(:,:,260))
  call Hotf_5pt_reduction(G2H2(181),RedSet_5(11),mass5set(:,16),  & 
G1H2(194),G1H2(197),G1H2(198),G1H2(199),G1H2(200),G1H2(203),2)
  call HG1shiftOLR(G1H2(197),8,2)
  call Hotf_5pt_reduction(G2H1(109),RedSet_5(12),mass5set(:,16),  & 
G1H1(30),G1H1(31),G1H1(32),G1H1(33),G1H1(34),G1H1(35),1)
  call HG1shiftOLR(G1H1(31),4,1)
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(100),ex3(:),G2tensor(11),m3h1x1(:,3),heltab2x1(:,:,3))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(112),ex3(:),G2tensor(12),m3h1x1(:,4),heltab2x1(:,:,4))
  call Hotf_5pt_reduction(G2H1(106),RedSet_5(12),mass5set(:,16),  & 
G1H1(36),G1H1(37),G1H1(38),G1H1(39),G1H1(40),G1H1(41),1)
  call HG1shiftOLR(G1H1(37),4,1)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(3),mass5set(:,20),  & 
G1H2(204),G1H2(53),G1H2(54),G1H2(55),G1H2(56),G1H2(59),2)
  call HG1shiftOLR(G1H2(53),8,2)
  call Hotf_5pt_reduction(G2H1(9),RedSet_5(4),mass5set(:,4),  & 
G1H1(42),G1H1(43),G1H1(44),G1H1(45),G1H1(46),G1H1(47),1)
  call HG1shiftOLR(G1H1(43),4,1)
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(10),ex3(:),G2tensor(13),m3h1x1(:,5),heltab2x1(:,:,5))
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(5),mass5set(:,20),  & 
G1H2(60),G1H2(268),G1H2(6),G1H2(283),G1H2(5),G1H2(284),2)
  call HG1shiftOLR(G1H2(268),8,2)
  call Hotf_5pt_reduction(G2H2(227),RedSet_5(6),mass5set(:,19),  & 
G1H2(8),G1H2(205),G1H2(206),G1H2(209),G1H2(210),G1H2(211),2)
  call HG1shiftOLR(G1H2(205),2,2)
  call Hotf_5pt_reduction(G2H2(234),RedSet_5(6),mass5set(:,19),  & 
G1H2(212),G1H2(215),G1H2(216),G1H2(23),G1H2(299),G1H2(24),2)
  call HG1shiftOLR(G1H2(215),2,2)
  call Hotf_5pt_reduction(G2H1(11),RedSet_5(7),mass5set(:,4),  & 
G1H1(48),G1H1(49),G1H1(50),G1H1(51),G1H1(52),G1H1(53),1)
  call HG1shiftOLR(G1H1(49),4,1)
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(12),ex3(:),G2tensor(14),m3h1x1(:,6),heltab2x1(:,:,6))
  call Hotf_5pt_reduction(G2H2(243),RedSet_5(8),mass5set(:,19),  & 
G1H2(300),G1H2(25),G1H2(251),G1H2(26),G1H2(29),G1H2(252),2)
  call HG1shiftOLR(G1H2(25),2,2)
  call Hotf_5pt_reduction(G2H2(246),RedSet_5(8),mass5set(:,19),  & 
G1H2(30),G1H2(21),G1H2(31),G1H2(61),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(21),2,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(18),ex4(:),G2tensor(15),m3h2x1(:,154),heltab2x2(:,:,261))
  call Hotf_4pt_reduction(G2H2(22),RedSet_4(4),mass4set(:,4),  & 
G1H2(217),G1H2(218),G1H2(221),G1H2(222),G1H2(223),2)
  call HG1shiftOLR(G1H2(218),10,2)
  call Hotf_4pt_reduction(G2H2(24),RedSet_4(4),mass4set(:,4),  & 
G1H2(224),G1H2(227),G1H2(228),G1H2(229),G1H2(67),2)
  call HG1shiftOLR(G1H2(227),10,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(26),ex4(:),G2tensor(16),m3h2x1(:,155),heltab2x2(:,:,262))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(28),ex4(:),G2tensor(17),m3h2x1(:,156),heltab2x2(:,:,263))
  call Hotf_4pt_reduction(G2H2(34),RedSet_4(5),mass4set(:,4),  & 
G1H2(230),G1H2(233),G1H2(68),G1H2(234),G1H2(71),2)
  call HG1shiftOLR(G1H2(233),9,2)
  call Hotf_4pt_reduction(G2H2(32),RedSet_4(5),mass4set(:,4),  & 
G1H2(235),G1H2(236),G1H2(239),G1H2(240),G1H2(241),2)
  call HG1shiftOLR(G1H2(236),9,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(36),ex4(:),G2tensor(18),m3h2x1(:,157),heltab2x2(:,:,264))
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(3),mass5set(:,2),  & 
G1H2(242),G1H2(245),G1H2(246),G1H2(72),G1H2(74),G1H2(77),2)
  call HG1shiftOLR(G1H2(245),8,2)
  call Hotf_4pt_reduction(G2H2(39),RedSet_4(6),mass4set(:,3),  & 
G1H2(79),G1H2(83),G1H2(84),G1H2(86),G1H2(89),2)
  call HG1shiftOLR(G1H2(83),9,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(40),ex4(:),G2tensor(19),m3h2x1(:,158),heltab2x2(:,:,265))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(42),ex4(:),G2tensor(20),m3h2x1(:,159),heltab2x2(:,:,266))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(43),ex4(:),G2tensor(21),m3h2x1(:,160),heltab2x2(:,:,267))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(49),ex4(:),G2tensor(22),m3h2x1(:,161),heltab2x2(:,:,268))
  call Hotf_5pt_reduction(G2H2(46),RedSet_5(3),mass5set(:,2),  & 
G1H2(91),G1H2(95),G1H2(96),G1H2(98),G1H2(101),G1H2(103),2)
  call HG1shiftOLR(G1H2(95),8,2)
  call Hotf_4pt_reduction(G2H2(50),RedSet_4(6),mass4set(:,3),  & 
G1H2(107),G1H2(108),G1H2(35),G1H2(110),G1H2(1),2)
  call HG1shiftOLR(G1H2(108),9,2)
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(13),ex3(:),G2tensor(23),m3h1x1(:,7),heltab2x1(:,:,7))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(15),ex3(:),G2tensor(24),m3h1x1(:,8),heltab2x1(:,:,8))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(16),ex3(:),G2tensor(25),m3h1x1(:,9),heltab2x1(:,:,9))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(18),ex3(:),G2tensor(26),m3h1x1(:,10),heltab2x1(:,:,10))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(19),ex3(:),G2tensor(27),m3h1x1(:,11),heltab2x1(:,:,11))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(21),ex3(:),G2tensor(28),m3h1x1(:,12),heltab2x1(:,:,12))
  call Hotf_5pt_reduction(G2H1(22),RedSet_5(4),mass5set(:,2),  & 
G1H1(54),G1H1(55),G1H1(56),G1H1(57),G1H1(58),G1H1(59),1)
  call HG1shiftOLR(G1H1(55),4,1)
  call Hotf_4pt_reduction(G2H1(24),RedSet_4(7),mass4set(:,3),  & 
G1H1(60),G1H1(61),G1H1(62),G1H1(63),G1H1(64),1)
  call HG1shiftOLR(G1H1(61),5,1)
  call Hotf_5pt_reduction(G2H1(25),RedSet_5(4),mass5set(:,4),  & 
G1H1(65),G1H1(66),G1H1(67),G1H1(68),G1H1(69),G1H1(70),1)
  call HG1shiftOLR(G1H1(66),4,1)
  call Hotf_4pt_reduction(G2H1(27),RedSet_4(7),mass4set(:,1),  & 
G1H1(71),G1H1(72),G1H1(73),G1H1(74),G1H1(75),1)
  call HG1shiftOLR(G1H1(72),5,1)
  call Hotf_5pt_reduction(G2H1(28),RedSet_5(4),mass5set(:,2),  & 
G1H1(76),G1H1(77),G1H1(78),G1H1(79),G1H1(80),G1H1(81),1)
  call HG1shiftOLR(G1H1(77),4,1)
  call Hotf_4pt_reduction(G2H1(30),RedSet_4(7),mass4set(:,3),  & 
G1H1(82),G1H1(83),G1H1(84),G1H1(85),G1H1(86),1)
  call HG1shiftOLR(G1H1(83),5,1)
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(31),ex3(:),G2tensor(29),m3h1x1(:,13),heltab2x1(:,:,13))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(33),ex3(:),G2tensor(30),m3h1x1(:,14),heltab2x1(:,:,14))
  call Hotf_5pt_reduction(G2H2(51),RedSet_5(5),mass5set(:,2),  & 
G1H2(36),G1H2(247),G1H2(115),G1H2(248),G1H2(253),G1H2(3),2)
  call HG1shiftOLR(G1H2(247),8,2)
  call Hotf_4pt_reduction(G2H2(53),RedSet_4(2),mass4set(:,3),  & 
G1H2(258),G1H2(116),G1H2(254),G1H2(257),G1H2(119),2)
  call HG1shiftOLR(G1H2(116),10,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(54),ex4(:),G2tensor(31),m3h2x1(:,162),heltab2x2(:,:,269))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(56),ex4(:),G2tensor(32),m3h2x1(:,163),heltab2x2(:,:,270))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(57),ex4(:),G2tensor(33),m3h2x1(:,164),heltab2x2(:,:,271))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(58),ex4(:),G2tensor(34),m3h2x1(:,165),heltab2x2(:,:,272))
  call Hotf_5pt_reduction(G2H2(60),RedSet_5(5),mass5set(:,2),  & 
G1H2(259),G1H2(262),G1H2(37),G1H2(263),G1H2(120),G1H2(264),2)
  call HG1shiftOLR(G1H2(262),8,2)
  call Hotf_4pt_reduction(G2H2(63),RedSet_4(2),mass4set(:,3),  & 
G1H2(269),G1H2(38),G1H2(274),G1H2(121),G1H2(270),2)
  call HG1shiftOLR(G1H2(38),10,2)
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(34),ex3(:),G2tensor(35),m3h1x1(:,15),heltab2x1(:,:,15))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(36),ex3(:),G2tensor(36),m3h1x1(:,16),heltab2x1(:,:,16))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(37),ex3(:),G2tensor(37),m3h1x1(:,17),heltab2x1(:,:,17))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(39),ex3(:),G2tensor(38),m3h1x1(:,18),heltab2x1(:,:,18))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(40),ex3(:),G2tensor(39),m3h1x1(:,19),heltab2x1(:,:,19))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(42),ex3(:),G2tensor(40),m3h1x1(:,20),heltab2x1(:,:,20))
  call Hotf_5pt_reduction(G2H1(43),RedSet_5(7),mass5set(:,2),  & 
G1H1(87),G1H1(88),G1H1(89),G1H1(90),G1H1(91),G1H1(92),1)
  call HG1shiftOLR(G1H1(88),4,1)
  call Hotf_4pt_reduction(G2H1(45),RedSet_4(3),mass4set(:,3),  & 
G1H1(93),G1H1(94),G1H1(95),G1H1(96),G1H1(97),1)
  call HG1shiftOLR(G1H1(94),6,1)
  call Hotf_5pt_reduction(G2H1(46),RedSet_5(7),mass5set(:,4),  & 
G1H1(98),G1H1(99),G1H1(100),G1H1(101),G1H1(102),G1H1(103),1)
  call HG1shiftOLR(G1H1(99),4,1)
  call Hotf_4pt_reduction(G2H1(48),RedSet_4(3),mass4set(:,1),  & 
G1H1(104),G1H1(105),G1H1(106),G1H1(107),G1H1(108),1)
  call HG1shiftOLR(G1H1(105),6,1)
  call Hotf_5pt_reduction(G2H1(49),RedSet_5(7),mass5set(:,2),  & 
G1H1(109),G1H1(110),G1H1(111),G1H1(112),G1H1(113),G1H1(114),1)
  call HG1shiftOLR(G1H1(110),4,1)
  call Hotf_4pt_reduction(G2H1(51),RedSet_4(3),mass4set(:,3),  & 
G1H1(115),G1H1(116),G1H1(117),G1H1(118),G1H1(119),1)
  call HG1shiftOLR(G1H1(116),6,1)
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(52),ex3(:),G2tensor(41),m3h1x1(:,21),heltab2x1(:,:,21))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(54),ex3(:),G2tensor(42),m3h1x1(:,22),heltab2x1(:,:,22))
  call Hotf_5pt_reduction(G2H2(62),RedSet_5(1),mass5set(:,8),  & 
G1H2(273),G1H2(41),G1H2(275),G1H2(278),G1H2(122),G1H2(279),2)
  call HG1shiftOLR(G1H2(41),8,2)
  call Hotf_4pt_reduction(G2H2(66),RedSet_4(4),mass4set(:,5),  & 
G1H2(125),G1H2(280),G1H2(285),G1H2(42),G1H2(290),2)
  call HG1shiftOLR(G1H2(280),10,2)
  call Hotf_5pt_reduction(G2H2(84),RedSet_5(1),mass5set(:,9),  & 
G1H2(126),G1H2(286),G1H2(289),G1H2(43),G1H2(291),G1H2(294),2)
  call HG1shiftOLR(G1H2(286),8,2)
  call Hotf_4pt_reduction(G2H2(88),RedSet_4(4),mass4set(:,6),  & 
G1H2(127),G1H2(295),G1H2(44),G1H2(296),G1H2(301),2)
  call HG1shiftOLR(G1H2(295),10,2)
  call Hotf_5pt_reduction(G2H2(90),RedSet_5(1),mass5set(:,10),  & 
G1H2(128),G1H2(306),G1H2(131),G1H2(302),G1H2(305),G1H2(47),2)
  call HG1shiftOLR(G1H2(306),8,2)
  call Hotf_4pt_reduction(G2H2(94),RedSet_4(4),mass4set(:,7),  & 
G1H2(307),G1H2(310),G1H2(132),G1H2(311),G1H2(312),2)
  call HG1shiftOLR(G1H2(310),10,2)
  call Hotf_5pt_reduction(G2H2(79),RedSet_5(1),mass5set(:,11),  & 
G1H2(313),G1H2(314),G1H2(315),G1H2(316),G1H2(317),G1H2(318),2)
  call HG1shiftOLR(G1H2(314),8,2)
  call Hotf_4pt_reduction(G2H2(83),RedSet_4(4),mass4set(:,8),  & 
G1H2(319),G1H2(320),G1H2(321),G1H2(322),G1H2(323),2)
  call HG1shiftOLR(G1H2(320),10,2)
  call Hotf_5pt_reduction(G2H2(95),RedSet_5(9),mass5set(:,12),  & 
G1H2(324),G1H2(325),G1H2(326),G1H2(327),G1H2(328),G1H2(329),2)
  call HG1shiftOLR(G1H2(325),8,2)
  call Hotf_4pt_reduction(G2H2(99),RedSet_4(8),mass4set(:,9),  & 
G1H2(330),G1H2(331),G1H2(332),G1H2(333),G1H2(334),2)
  call HG1shiftOLR(G1H2(331),12,2)
  call Hotf_5pt_reduction(G2H2(102),RedSet_5(9),mass5set(:,13),  & 
G1H2(335),G1H2(336),G1H2(337),G1H2(338),G1H2(339),G1H2(340),2)
  call HG1shiftOLR(G1H2(336),8,2)
  call Hotf_4pt_reduction(G2H2(106),RedSet_4(8),mass4set(:,10),  & 
G1H2(341),G1H2(342),G1H2(343),G1H2(344),G1H2(345),2)
  call HG1shiftOLR(G1H2(342),12,2)
  call Hotf_5pt_reduction(G2H2(108),RedSet_5(9),mass5set(:,14),  & 
G1H2(346),G1H2(347),G1H2(348),G1H2(349),G1H2(350),G1H2(351),2)
  call HG1shiftOLR(G1H2(347),8,2)
  call Hotf_4pt_reduction(G2H2(112),RedSet_4(8),mass4set(:,11),  & 
G1H2(352),G1H2(353),G1H2(354),G1H2(355),G1H2(356),2)
  call HG1shiftOLR(G1H2(353),12,2)
  call Hotf_5pt_reduction(G2H2(113),RedSet_5(9),mass5set(:,15),  & 
G1H2(357),G1H2(358),G1H2(359),G1H2(360),G1H2(361),G1H2(362),2)
  call HG1shiftOLR(G1H2(358),8,2)
  call Hotf_4pt_reduction(G2H2(117),RedSet_4(8),mass4set(:,12),  & 
G1H2(363),G1H2(364),G1H2(365),G1H2(366),G1H2(367),2)
  call HG1shiftOLR(G1H2(364),12,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(121),ex4(:),G2tensor(43),m3h2x1(:,166),heltab2x2(:,:,273))
  call Hotf_4pt_reduction(G2H2(125),RedSet_4(8),mass4set(:,13),  & 
G1H2(368),G1H2(369),G1H2(370),G1H2(371),G1H2(372),2)
  call HG1shiftOLR(G1H2(369),12,2)
  call Hotf_4pt_reduction(G2H2(129),RedSet_4(8),mass4set(:,13),  & 
G1H2(373),G1H2(374),G1H2(375),G1H2(376),G1H2(377),2)
  call HG1shiftOLR(G1H2(374),12,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(133),ex4(:),G2tensor(44),m3h2x1(:,167),heltab2x2(:,:,274))
  call Hotf_5pt_reduction(G2H2(134),RedSet_5(2),mass5set(:,8),  & 
G1H2(378),G1H2(379),G1H2(380),G1H2(381),G1H2(382),G1H2(383),2)
  call HG1shiftOLR(G1H2(379),8,2)
  call Hotf_4pt_reduction(G2H2(138),RedSet_4(5),mass4set(:,5),  & 
G1H2(384),G1H2(385),G1H2(386),G1H2(387),G1H2(388),2)
  call HG1shiftOLR(G1H2(385),9,2)
  call Hotf_5pt_reduction(G2H2(149),RedSet_5(2),mass5set(:,9),  & 
G1H2(389),G1H2(390),G1H2(391),G1H2(392),G1H2(393),G1H2(394),2)
  call HG1shiftOLR(G1H2(390),8,2)
  call Hotf_4pt_reduction(G2H2(152),RedSet_4(5),mass4set(:,6),  & 
G1H2(395),G1H2(396),G1H2(397),G1H2(398),G1H2(399),2)
  call HG1shiftOLR(G1H2(396),9,2)
  call Hotf_5pt_reduction(G2H2(153),RedSet_5(2),mass5set(:,10),  & 
G1H2(400),G1H2(401),G1H2(402),G1H2(403),G1H2(404),G1H2(405),2)
  call HG1shiftOLR(G1H2(401),8,2)
  call Hotf_4pt_reduction(G2H2(156),RedSet_4(5),mass4set(:,7),  & 
G1H2(406),G1H2(407),G1H2(408),G1H2(409),G1H2(410),2)
  call HG1shiftOLR(G1H2(407),9,2)
  call Hotf_5pt_reduction(G2H2(114),RedSet_5(2),mass5set(:,11),  & 
G1H2(411),G1H2(412),G1H2(413),G1H2(414),G1H2(415),G1H2(416),2)
  call HG1shiftOLR(G1H2(412),8,2)
  call Hotf_4pt_reduction(G2H2(148),RedSet_4(5),mass4set(:,8),  & 
G1H2(417),G1H2(418),G1H2(419),G1H2(420),G1H2(421),2)
  call HG1shiftOLR(G1H2(418),9,2)
  call Hotf_5pt_reduction(G2H1(61),RedSet_5(10),mass5set(:,12),  & 
G1H1(120),G1H1(121),G1H1(122),G1H1(123),G1H1(124),G1H1(125),1)
  call HG1shiftOLR(G1H1(121),4,1)
  call Hotf_4pt_reduction(G2H1(63),RedSet_4(8),mass4set(:,9),  & 
G1H1(126),G1H1(127),G1H1(128),G1H1(129),G1H1(130),1)
  call HG1shiftOLR(G1H1(127),12,1)
  call Hotf_5pt_reduction(G2H1(64),RedSet_5(10),mass5set(:,13),  & 
G1H1(131),G1H1(132),G1H1(133),G1H1(134),G1H1(135),G1H1(136),1)
  call HG1shiftOLR(G1H1(132),4,1)
  call Hotf_4pt_reduction(G2H1(66),RedSet_4(8),mass4set(:,10),  & 
G1H1(137),G1H1(138),G1H1(139),G1H1(140),G1H1(141),1)
  call HG1shiftOLR(G1H1(138),12,1)
  call Hotf_5pt_reduction(G2H1(67),RedSet_5(10),mass5set(:,14),  & 
G1H1(142),G1H1(143),G1H1(144),G1H1(145),G1H1(146),G1H1(147),1)
  call HG1shiftOLR(G1H1(143),4,1)
  call Hotf_4pt_reduction(G2H1(69),RedSet_4(8),mass4set(:,11),  & 
G1H1(148),G1H1(149),G1H1(150),G1H1(151),G1H1(152),1)
  call HG1shiftOLR(G1H1(149),12,1)
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(72),ex3(:),G2tensor(45),m3h1x1(:,23),heltab2x1(:,:,23))
  call Hotf_5pt_reduction(G2H1(73),RedSet_5(10),mass5set(:,15),  & 
G1H1(153),G1H1(154),G1H1(155),G1H1(156),G1H1(157),G1H1(158),1)
  call HG1shiftOLR(G1H1(154),4,1)
  call Hotf_4pt_reduction(G2H1(75),RedSet_4(8),mass4set(:,12),  & 
G1H1(159),G1H1(160),G1H1(161),G1H1(162),G1H1(163),1)
  call HG1shiftOLR(G1H1(160),12,1)
  call Hotf_4pt_reduction(G2H1(78),RedSet_4(8),mass4set(:,13),  & 
G1H1(164),G1H1(165),G1H1(166),G1H1(167),G1H1(168),1)
  call HG1shiftOLR(G1H1(165),12,1)
  call Hotf_4pt_reduction(G2H1(81),RedSet_4(8),mass4set(:,13),  & 
G1H1(169),G1H1(170),G1H1(171),G1H1(172),G1H1(173),1)
  call HG1shiftOLR(G1H1(170),12,1)
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(84),ex3(:),G2tensor(46),m3h1x1(:,24),heltab2x1(:,:,24))
  call Hotf_5pt_reduction(G2H2(163),RedSet_5(11),mass5set(:,12),  & 
G1H2(422),G1H2(423),G1H2(424),G1H2(425),G1H2(426),G1H2(427),2)
  call HG1shiftOLR(G1H2(423),8,2)
  call Hotf_4pt_reduction(G2H2(165),RedSet_4(9),mass4set(:,9),  & 
G1H2(428),G1H2(429),G1H2(430),G1H2(431),G1H2(432),2)
  call HG1shiftOLR(G1H2(429),12,2)
  call Hotf_5pt_reduction(G2H2(166),RedSet_5(11),mass5set(:,13),  & 
G1H2(433),G1H2(434),G1H2(435),G1H2(436),G1H2(437),G1H2(438),2)
  call HG1shiftOLR(G1H2(434),8,2)
  call Hotf_4pt_reduction(G2H2(168),RedSet_4(9),mass4set(:,10),  & 
G1H2(439),G1H2(440),G1H2(441),G1H2(442),G1H2(443),2)
  call HG1shiftOLR(G1H2(440),12,2)
  call Hotf_5pt_reduction(G2H2(169),RedSet_5(11),mass5set(:,14),  & 
G1H2(444),G1H2(445),G1H2(446),G1H2(447),G1H2(448),G1H2(449),2)
  call HG1shiftOLR(G1H2(445),8,2)
  call Hotf_4pt_reduction(G2H2(171),RedSet_4(9),mass4set(:,11),  & 
G1H2(450),G1H2(451),G1H2(452),G1H2(453),G1H2(454),2)
  call HG1shiftOLR(G1H2(451),12,2)
  call Hotf_5pt_reduction(G2H2(172),RedSet_5(11),mass5set(:,15),  & 
G1H2(455),G1H2(456),G1H2(457),G1H2(458),G1H2(459),G1H2(460),2)
  call HG1shiftOLR(G1H2(456),8,2)
  call Hotf_4pt_reduction(G2H2(174),RedSet_4(9),mass4set(:,12),  & 
G1H2(461),G1H2(462),G1H2(463),G1H2(464),G1H2(465),2)
  call HG1shiftOLR(G1H2(462),12,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(177),ex4(:),G2tensor(47),m3h2x1(:,168),heltab2x2(:,:,275))
  call Hotf_4pt_reduction(G2H2(180),RedSet_4(9),mass4set(:,13),  & 
G1H2(466),G1H2(467),G1H2(468),G1H2(469),G1H2(470),2)
  call HG1shiftOLR(G1H2(467),12,2)
  call Hotf_4pt_reduction(G2H2(183),RedSet_4(9),mass4set(:,13),  & 
G1H2(471),G1H2(472),G1H2(473),G1H2(474),G1H2(475),2)
  call HG1shiftOLR(G1H2(472),12,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(186),ex4(:),G2tensor(48),m3h2x1(:,169),heltab2x2(:,:,276))
  call Hotf_5pt_reduction(G2H1(91),RedSet_5(12),mass5set(:,12),  & 
G1H1(174),G1H1(175),G1H1(176),G1H1(177),G1H1(178),G1H1(179),1)
  call HG1shiftOLR(G1H1(175),4,1)
  call Hotf_4pt_reduction(G2H1(93),RedSet_4(9),mass4set(:,9),  & 
G1H1(180),G1H1(181),G1H1(182),G1H1(183),G1H1(184),1)
  call HG1shiftOLR(G1H1(181),12,1)
  call Hotf_5pt_reduction(G2H1(94),RedSet_5(12),mass5set(:,13),  & 
G1H1(185),G1H1(186),G1H1(187),G1H1(188),G1H1(189),G1H1(190),1)
  call HG1shiftOLR(G1H1(186),4,1)
  call Hotf_4pt_reduction(G2H1(96),RedSet_4(9),mass4set(:,10),  & 
G1H1(191),G1H1(192),G1H1(193),G1H1(194),G1H1(195),1)
  call HG1shiftOLR(G1H1(192),12,1)
  call Hotf_5pt_reduction(G2H1(97),RedSet_5(12),mass5set(:,14),  & 
G1H1(196),G1H1(197),G1H1(198),G1H1(199),G1H1(200),G1H1(201),1)
  call HG1shiftOLR(G1H1(197),4,1)
  call Hotf_4pt_reduction(G2H1(99),RedSet_4(9),mass4set(:,11),  & 
G1H1(202),G1H1(203),G1H1(204),G1H1(205),G1H1(206),1)
  call HG1shiftOLR(G1H1(203),12,1)
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(102),ex3(:),G2tensor(49),m3h1x1(:,25),heltab2x1(:,:,25))
  call Hotf_5pt_reduction(G2H1(103),RedSet_5(12),mass5set(:,15),  & 
G1H1(207),G1H1(208),G1H1(209),G1H1(210),G1H1(211),G1H1(212),1)
  call HG1shiftOLR(G1H1(208),4,1)
  call Hotf_4pt_reduction(G2H1(105),RedSet_4(9),mass4set(:,12),  & 
G1H1(213),G1H1(214),G1H1(215),G1H1(216),G1H1(217),1)
  call HG1shiftOLR(G1H1(214),12,1)
  call Hotf_4pt_reduction(G2H1(108),RedSet_4(9),mass4set(:,13),  & 
G1H1(218),G1H1(219),G1H1(220),G1H1(221),G1H1(222),1)
  call HG1shiftOLR(G1H1(219),12,1)
  call Hotf_4pt_reduction(G2H1(111),RedSet_4(9),mass4set(:,13),  & 
G1H1(223),G1H1(224),G1H1(225),G1H1(226),G1H1(227),1)
  call HG1shiftOLR(G1H1(224),12,1)
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(114),ex3(:),G2tensor(50),m3h1x1(:,26),heltab2x1(:,:,26))
  call Hotf_5pt_reduction(G2H2(201),RedSet_5(3),mass5set(:,17),  & 
G1H2(476),G1H2(477),G1H2(478),G1H2(479),G1H2(480),G1H2(481),2)
  call HG1shiftOLR(G1H2(477),8,2)
  call Hotf_4pt_reduction(G2H2(204),RedSet_4(6),mass4set(:,14),  & 
G1H2(482),G1H2(483),G1H2(484),G1H2(485),G1H2(486),2)
  call HG1shiftOLR(G1H2(483),9,2)
  call Hotf_5pt_reduction(G2H2(205),RedSet_5(3),mass5set(:,18),  & 
G1H2(487),G1H2(488),G1H2(489),G1H2(490),G1H2(491),G1H2(492),2)
  call HG1shiftOLR(G1H2(488),8,2)
  call Hotf_4pt_reduction(G2H2(208),RedSet_4(6),mass4set(:,15),  & 
G1H2(493),G1H2(494),G1H2(495),G1H2(496),G1H2(497),2)
  call HG1shiftOLR(G1H2(494),9,2)
  call Hotf_5pt_reduction(G2H1(118),RedSet_5(4),mass5set(:,18),  & 
G1H1(228),G1H1(229),G1H1(230),G1H1(231),G1H1(232),G1H1(233),1)
  call HG1shiftOLR(G1H1(229),4,1)
  call Hotf_4pt_reduction(G2H1(120),RedSet_4(7),mass4set(:,15),  & 
G1H1(234),G1H1(235),G1H1(236),G1H1(237),G1H1(238),1)
  call HG1shiftOLR(G1H1(235),5,1)
  call Hotf_5pt_reduction(G2H2(219),RedSet_5(5),mass5set(:,17),  & 
G1H2(498),G1H2(499),G1H2(500),G1H2(501),G1H2(502),G1H2(503),2)
  call HG1shiftOLR(G1H2(499),8,2)
  call Hotf_4pt_reduction(G2H2(222),RedSet_4(2),mass4set(:,14),  & 
G1H2(504),G1H2(505),G1H2(506),G1H2(507),G1H2(508),2)
  call HG1shiftOLR(G1H2(505),10,2)
  call Hotf_5pt_reduction(G2H2(223),RedSet_5(5),mass5set(:,18),  & 
G1H2(509),G1H2(510),G1H2(511),G1H2(512),G1H2(513),G1H2(514),2)
  call HG1shiftOLR(G1H2(510),8,2)
  call Hotf_4pt_reduction(G2H2(226),RedSet_4(2),mass4set(:,15),  & 
G1H2(515),G1H2(516),G1H2(517),G1H2(518),G1H2(519),2)
  call HG1shiftOLR(G1H2(516),10,2)
  call Hotf_4pt_reduction(G2H2(230),RedSet_4(2),mass4set(:,15),  & 
G1H2(520),G1H2(521),G1H2(522),G1H2(523),G1H2(524),2)
  call HG1shiftOLR(G1H2(521),10,2)
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(231),ex2(:),G2tensor(51),ngZd,m3h2x1(:,170),heltab2x2(:,:,277))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(233),ex2(:),G2tensor(52),ngZd,m3h2x1(:,171),heltab2x2(:,:,278))
  call Hotf_4pt_reduction(G2H2(237),RedSet_4(2),mass4set(:,15),  & 
G1H2(525),G1H2(526),G1H2(527),G1H2(528),G1H2(529),2)
  call HG1shiftOLR(G1H2(526),10,2)
  call Hotf_5pt_reduction(G2H1(124),RedSet_5(7),mass5set(:,18),  & 
G1H1(239),G1H1(240),G1H1(241),G1H1(242),G1H1(243),G1H1(244),1)
  call HG1shiftOLR(G1H1(240),4,1)
  call Hotf_4pt_reduction(G2H1(126),RedSet_4(3),mass4set(:,15),  & 
G1H1(245),G1H1(246),G1H1(247),G1H1(248),G1H1(249),1)
  call HG1shiftOLR(G1H1(246),6,1)
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(238),ex2(:),G2tensor(53),ngZd,m3h2x1(:,172),heltab2x2(:,:,279))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(242),ex2(:),G2tensor(54),ngZd,m3h2x1(:,173),heltab2x2(:,:,280))
  call Hotf_4pt_reduction(G2H2(245),RedSet_4(3),mass4set(:,15),  & 
G1H2(530),G1H2(531),G1H2(532),G1H2(533),G1H2(534),2)
  call HG1shiftOLR(G1H2(531),6,2)
  call Hotf_4pt_reduction(G2H2(248),RedSet_4(3),mass4set(:,15),  & 
G1H2(535),G1H2(536),G1H2(537),G1H2(538),G1H2(539),2)
  call HG1shiftOLR(G1H2(536),6,2)
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(249),ex2(:),G2tensor(55),ngX,m3h2x1(:,174),heltab2x2(:,:,281))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(251),ex2(:),G2tensor(56),ngX,m3h2x1(:,175),heltab2x2(:,:,282))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(254),ex2(:),G2tensor(57),ngH,m3h2x1(:,176),heltab2x2(:,:,283))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(256),ex2(:),G2tensor(58),ngH,m3h2x1(:,177),heltab2x2(:,:,284))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(259),ex2(:),G2tensor(59),ngPbt,m3h2x1(:,178),heltab2x2(:,:,285))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(261),ex2(:),G2tensor(60),ngPbt,m3h2x1(:,179),heltab2x2(:,:,286))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(264),ex2(:),G2tensor(61),m3h2x1(:,180),heltab2x2(:,:,287))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(266),ex2(:),G2tensor(62),m3h2x1(:,181),heltab2x2(:,:,288))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(269),ex2(:),G2tensor(63),ngX,m3h2x1(:,182),heltab2x2(:,:,289))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(271),ex2(:),G2tensor(64),ngX,m3h2x1(:,183),heltab2x2(:,:,290))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(274),ex2(:),G2tensor(65),ngH,m3h2x1(:,184),heltab2x2(:,:,291))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(276),ex2(:),G2tensor(66),ngH,m3h2x1(:,185),heltab2x2(:,:,292))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(279),ex2(:),G2tensor(67),ngPbt,m3h2x1(:,186),heltab2x2(:,:,293))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(281),ex2(:),G2tensor(68),ngPbt,m3h2x1(:,187),heltab2x2(:,:,294))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(284),ex2(:),G2tensor(69),m3h2x1(:,188),heltab2x2(:,:,295))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(286),ex2(:),G2tensor(70),m3h2x1(:,189),heltab2x2(:,:,296))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(217),[G1H2(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(224),[G1H2(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(368),[G1H2(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(373),[G1H2(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(230),[G1H2(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(235),[G1H2(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(169),[G1H1(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(164),[G1H1(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(466),[G1H2(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(471),[G1H2(203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(223),[G1H1(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(218),[G1H1(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(520),[G1H2(211)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(525),[G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(530),[G1H2(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(535),[G1H2(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(79),[G1H2(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(107),[G1H2(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(60),[G1H1(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(71),[G1H1(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(82),[G1H1(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(258),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(269),[G1H2(264)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(93),[G1H1(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(104),[G1H1(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(115),[G1H1(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(125),[G1H2(279)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(127),[G1H2(294)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(307),[G1H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(319),[G1H2(318)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(330),[G1H2(329)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(341),[G1H2(340)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(352),[G1H2(351)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(363),[G1H2(362)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(384),[G1H2(383)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(395),[G1H2(394)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(406),[G1H2(405)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(417),[G1H2(416)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(126),[G1H1(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(137),[G1H1(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(148),[G1H1(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(159),[G1H1(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(428),[G1H2(427)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(439),[G1H2(438)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(450),[G1H2(449)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(461),[G1H2(460)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(180),[G1H1(179)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(191),[G1H1(190)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(202),[G1H1(201)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(213),[G1H1(212)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(482),[G1H2(481)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(493),[G1H2(492)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(234),[G1H1(233)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(504),[G1H2(503)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(515),[G1H2(514)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(245),[G1H1(244)])
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(48),23,ex4(:),8,G2tensor(71),m3h2x1(:,190),heltab2x2(:,:,297))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(133),0,ex4(:),8,G2tensor(72),m3h2x1(:,191),heltab2x2(:,:,298))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(217),23,ex4(:),8,G2tensor(73),m3h2x1(:,192),heltab2x2(:,:,299))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(140),23,ex4(:),8,G2tensor(74),m3h2x1(:,193),heltab2x2(:,:,300))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(143),0,ex4(:),8,G2tensor(75),m3h2x1(:,194),heltab2x2(:,:,301))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(224),23,ex4(:),8,G2tensor(76),m3h2x1(:,195),heltab2x2(:,:,302))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(150),23,ex4(:),8,G2tensor(77),m3h2x1(:,196),heltab2x2(:,:,303))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(151),0,ex4(:),8,G2tensor(78),m3h2x1(:,197),heltab2x2(:,:,304))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(368),23,ex4(:),8,G2tensor(79),m3h2x1(:,198),heltab2x2(:,:,305))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(158),23,ex4(:),8,G2tensor(80),m3h2x1(:,199),heltab2x2(:,:,306))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(161),0,ex4(:),8,G2tensor(81),m3h2x1(:,200),heltab2x2(:,:,307))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(373),23,ex4(:),8,G2tensor(82),m3h2x1(:,201),heltab2x2(:,:,308))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(168),23,ex4(:),8,G2tensor(83),m3h2x1(:,202),heltab2x2(:,:,309))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(169),0,ex4(:),8,G2tensor(84),m3h2x1(:,203),heltab2x2(:,:,310))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(230),23,ex4(:),8,G2tensor(85),m3h2x1(:,204),heltab2x2(:,:,311))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(176),23,ex4(:),8,G2tensor(86),m3h2x1(:,205),heltab2x2(:,:,312))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(179),0,ex4(:),8,G2tensor(87),m3h2x1(:,206),heltab2x2(:,:,313))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(235),23,ex4(:),8,G2tensor(88),m3h2x1(:,207),heltab2x2(:,:,314))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(18),27,ex3(:),4,G2tensor(89),m3h1x1(:,27),heltab2x1(:,:,27))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(19),0,ex3(:),4,G2tensor(90),m3h1x1(:,28),heltab2x1(:,:,28))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(169),27,ex3(:),4,G2tensor(91),m3h1x1(:,29),heltab2x1(:,:,29))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(24),27,ex3(:),4,G2tensor(92),m3h1x1(:,30),heltab2x1(:,:,30))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(25),0,ex3(:),4,G2tensor(93),m3h1x1(:,31),heltab2x1(:,:,31))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(164),27,ex3(:),4,G2tensor(94),m3h1x1(:,32),heltab2x1(:,:,32))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(186),23,ex4(:),8,G2tensor(95),m3h2x1(:,208),heltab2x2(:,:,315))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(187),0,ex4(:),8,G2tensor(96),m3h2x1(:,209),heltab2x2(:,:,316))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(466),23,ex4(:),8,G2tensor(97),m3h2x1(:,210),heltab2x2(:,:,317))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(194),23,ex4(:),8,G2tensor(98),m3h2x1(:,211),heltab2x2(:,:,318))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(197),0,ex4(:),8,G2tensor(99),m3h2x1(:,212),heltab2x2(:,:,319))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(471),23,ex4(:),8,G2tensor(100),m3h2x1(:,213),heltab2x2(:,:,320))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(30),27,ex3(:),4,G2tensor(101),m3h1x1(:,33),heltab2x1(:,:,33))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(31),0,ex3(:),4,G2tensor(102),m3h1x1(:,34),heltab2x1(:,:,34))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(223),27,ex3(:),4,G2tensor(103),m3h1x1(:,35),heltab2x1(:,:,35))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(36),27,ex3(:),4,G2tensor(104),m3h1x1(:,36),heltab2x1(:,:,36))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(37),0,ex3(:),4,G2tensor(105),m3h1x1(:,37),heltab2x1(:,:,37))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(218),27,ex3(:),4,G2tensor(106),m3h1x1(:,38),heltab2x1(:,:,38))
  call Hloop_QV_A(ntryL,G1H2(204),ex4(:),G1H1(23),m3h2x1(:,214),heltab2x2(:,:,321))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(23),31,nMB,G2tensor(107),n2h1(49))
  call Hloop_QV_A(ntryL,G1H2(53),ex4(:),G1H1(29),m3h2x1(:,215),heltab2x2(:,:,322))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(29),8,nMB,G2tensor(108),n2h1(50))
  call Hloop_QV_A(ntryL,G1H2(59),ex4(:),G1H1(35),m3h2x1(:,216),heltab2x2(:,:,323))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(35),31,nMB,G2tensor(109),n2h1(51))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(42),27,ex3(:),4,G2tensor(110),m3h1x1(:,39),heltab2x1(:,:,39))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(43),0,ex3(:),4,G2tensor(111),m3h1x1(:,40),heltab2x1(:,:,40))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(47),27,ex3(:),4,G2tensor(112),m3h1x1(:,41),heltab2x1(:,:,41))
  call Hloop_AV_Q(ntryL,G1H2(60),ex4(:),G1H1(41),m3h2x1(:,217),heltab2x2(:,:,324))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(41),31,nMB,G2tensor(113),n2h1(53))
  call Hloop_AV_Q(ntryL,G1H2(268),ex4(:),G1H1(59),m3h2x1(:,218),heltab2x2(:,:,325))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(59),8,nMB,G2tensor(114),n2h1(54))
  call Hloop_AV_Q(ntryL,G1H2(284),ex4(:),G1H1(70),m3h2x1(:,219),heltab2x2(:,:,326))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(70),31,nMB,G2tensor(115),n2h1(55))
  call Hloop_SA_Q(ntryL,G1H2(8),ex2(:),G1H1(81),ngPbt,m3h2x1(:,220),heltab2x2(:,:,327))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(81),31,nMT,G2tensor(116),n2h1(56))
  call Hloop_SA_Q(ntryL,G1H2(205),ex2(:),G1H1(92),ngPbt,m3h2x1(:,221),heltab2x2(:,:,328))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(92),2,nMT,G2tensor(117),n2h1(57))
  call Hloop_SA_Q(ntryL,G1H2(520),ex2(:),G1H1(103),ngPbt,m3h2x1(:,222),heltab2x2(:,:,329))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(103),31,nMT,G2tensor(118),n2h1(58))
  call Hloop_WA_Q(ntryL,G1H2(212),ex2(:),G1H1(114),m3h2x1(:,223),heltab2x2(:,:,330))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(114),31,nMT,G2tensor(119),n2h1(59))
  call Hloop_WA_Q(ntryL,G1H2(215),ex2(:),G1H1(125),m3h2x1(:,224),heltab2x2(:,:,331))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(125),2,nMT,G2tensor(120),n2h1(60))
  call Hloop_WA_Q(ntryL,G1H2(525),ex2(:),G1H1(136),m3h2x1(:,225),heltab2x2(:,:,332))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(136),31,nMT,G2tensor(121),n2h1(61))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(48),27,ex3(:),4,G2tensor(122),m3h1x1(:,42),heltab2x1(:,:,42))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(49),0,ex3(:),4,G2tensor(123),m3h1x1(:,43),heltab2x1(:,:,43))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(53),27,ex3(:),4,G2tensor(124),m3h1x1(:,44),heltab2x1(:,:,44))
  call Hloop_SA_Q(ntryL,G1H2(300),ex2(:),G1H1(147),ngPbt,m3h2x1(:,226),heltab2x2(:,:,333))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(147),31,nMT,G2tensor(125),n2h1(63))
  call Hloop_SA_Q(ntryL,G1H2(25),ex2(:),G1H1(158),ngPbt,m3h2x1(:,227),heltab2x2(:,:,334))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(158),2,nMT,G2tensor(126),n2h1(64))
  call Hloop_SA_Q(ntryL,G1H2(530),ex2(:),G1H1(179),ngPbt,m3h2x1(:,228),heltab2x2(:,:,335))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(179),31,nMT,G2tensor(127),n2h1(65))
  call Hloop_WA_Q(ntryL,G1H2(30),ex2(:),G1H1(190),m3h2x1(:,229),heltab2x2(:,:,336))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(190),31,nMT,G2tensor(128),n2h1(66))
  call Hloop_WA_Q(ntryL,G1H2(21),ex2(:),G1H1(201),m3h2x1(:,230),heltab2x2(:,:,337))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(201),2,nMT,G2tensor(129),n2h1(67))
  call Hloop_WA_Q(ntryL,G1H2(535),ex2(:),G1H1(212),m3h2x1(:,231),heltab2x2(:,:,338))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(212),31,nMT,G2tensor(130),n2h1(68))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(218),2,ex4(:),8,G2tensor(131),m3h2x1(:,232),heltab2x2(:,:,339))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(227),2,ex4(:),8,G2tensor(132),m3h2x1(:,233),heltab2x2(:,:,340))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(233),1,ex4(:),8,G2tensor(133),m3h2x1(:,234),heltab2x2(:,:,341))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(236),1,ex4(:),8,G2tensor(134),m3h2x1(:,235),heltab2x2(:,:,342))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(242),23,ex4(:),8,G2tensor(135),m3h2x1(:,236),heltab2x2(:,:,343))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(245),0,ex4(:),8,G2tensor(136),m3h2x1(:,237),heltab2x2(:,:,344))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(79),23,ex4(:),8,G2tensor(137),m3h2x1(:,238),heltab2x2(:,:,345))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(83),1,ex4(:),8,G2tensor(138),m3h2x1(:,239),heltab2x2(:,:,346))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(91),23,ex4(:),8,G2tensor(139),m3h2x1(:,240),heltab2x2(:,:,347))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(95),0,ex4(:),8,G2tensor(140),m3h2x1(:,241),heltab2x2(:,:,348))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(107),23,ex4(:),8,G2tensor(141),m3h2x1(:,242),heltab2x2(:,:,349))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(108),1,ex4(:),8,G2tensor(142),m3h2x1(:,243),heltab2x2(:,:,350))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(54),27,ex3(:),4,G2tensor(143),m3h1x1(:,45),heltab2x1(:,:,45))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(55),0,ex3(:),4,G2tensor(144),m3h1x1(:,46),heltab2x1(:,:,46))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(60),27,ex3(:),4,G2tensor(145),m3h1x1(:,47),heltab2x1(:,:,47))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(61),1,ex3(:),4,G2tensor(146),m3h1x1(:,48),heltab2x1(:,:,48))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(65),27,ex3(:),4,G2tensor(147),m3h1x1(:,49),heltab2x1(:,:,49))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(66),0,ex3(:),4,G2tensor(148),m3h1x1(:,50),heltab2x1(:,:,50))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(71),27,ex3(:),4,G2tensor(149),m3h1x1(:,51),heltab2x1(:,:,51))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(72),1,ex3(:),4,G2tensor(150),m3h1x1(:,52),heltab2x1(:,:,52))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(76),27,ex3(:),4,G2tensor(151),m3h1x1(:,53),heltab2x1(:,:,53))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(77),0,ex3(:),4,G2tensor(152),m3h1x1(:,54),heltab2x1(:,:,54))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(82),27,ex3(:),4,G2tensor(153),m3h1x1(:,55),heltab2x1(:,:,55))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(83),1,ex3(:),4,G2tensor(154),m3h1x1(:,56),heltab2x1(:,:,56))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(36),23,ex4(:),8,G2tensor(155),m3h2x1(:,244),heltab2x2(:,:,351))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(247),0,ex4(:),8,G2tensor(156),m3h2x1(:,245),heltab2x2(:,:,352))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(258),23,ex4(:),8,G2tensor(157),m3h2x1(:,246),heltab2x2(:,:,353))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(116),2,ex4(:),8,G2tensor(158),m3h2x1(:,247),heltab2x2(:,:,354))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(259),23,ex4(:),8,G2tensor(159),m3h2x1(:,248),heltab2x2(:,:,355))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(262),0,ex4(:),8,G2tensor(160),m3h2x1(:,249),heltab2x2(:,:,356))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(269),23,ex4(:),8,G2tensor(161),m3h2x1(:,250),heltab2x2(:,:,357))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(38),2,ex4(:),8,G2tensor(162),m3h2x1(:,251),heltab2x2(:,:,358))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(87),27,ex3(:),4,G2tensor(163),m3h1x1(:,57),heltab2x1(:,:,57))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(88),0,ex3(:),4,G2tensor(164),m3h1x1(:,58),heltab2x1(:,:,58))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(93),27,ex3(:),4,G2tensor(165),m3h1x1(:,59),heltab2x1(:,:,59))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(94),2,ex3(:),4,G2tensor(166),m3h1x1(:,60),heltab2x1(:,:,60))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(98),27,ex3(:),4,G2tensor(167),m3h1x1(:,61),heltab2x1(:,:,61))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(99),0,ex3(:),4,G2tensor(168),m3h1x1(:,62),heltab2x1(:,:,62))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(104),27,ex3(:),4,G2tensor(169),m3h1x1(:,63),heltab2x1(:,:,63))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(105),2,ex3(:),4,G2tensor(170),m3h1x1(:,64),heltab2x1(:,:,64))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(109),27,ex3(:),4,G2tensor(171),m3h1x1(:,65),heltab2x1(:,:,65))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(110),0,ex3(:),4,G2tensor(172),m3h1x1(:,66),heltab2x1(:,:,66))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(115),27,ex3(:),4,G2tensor(173),m3h1x1(:,67),heltab2x1(:,:,67))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(116),2,ex3(:),4,G2tensor(174),m3h1x1(:,68),heltab2x1(:,:,68))
  call Hloop_AV_Q(ntryL,G1H2(273),ex4(:),G1H1(233),m3h2x1(:,252),heltab2x2(:,:,359))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(233),31,nMB,G2tensor(175),n2h1(93))
  call Hloop_AV_Q(ntryL,G1H2(41),ex4(:),G1H1(244),m3h2x1(:,253),heltab2x2(:,:,360))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(244),8,nMB,G2tensor(176),n2h1(94))
  call Hloop_AV_Q(ntryL,G1H2(125),ex4(:),G1H1(18),m3h2x1(:,254),heltab2x2(:,:,361))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(18),31,nMB,G2tensor(177),n2h1(95))
  call Hloop_AV_Q(ntryL,G1H2(280),ex4(:),G1H1(19),m3h2x1(:,255),heltab2x2(:,:,362))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),10,nMB,G2tensor(178),n2h1(96))
  call Hloop_AV_Q(ntryL,G1H2(126),ex4(:),G1H1(169),m3h2x1(:,256),heltab2x2(:,:,363))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(169),31,nMB,G2tensor(179),n2h1(97))
  call Hloop_AV_Q(ntryL,G1H2(286),ex4(:),G1H1(24),m3h2x1(:,257),heltab2x2(:,:,364))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(24),8,nMB,G2tensor(180),n2h1(98))
  call Hloop_AV_Q(ntryL,G1H2(127),ex4(:),G1H1(25),m3h2x1(:,258),heltab2x2(:,:,365))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(25),31,nMB,G2tensor(181),n2h1(99))
  call Hloop_AV_Q(ntryL,G1H2(295),ex4(:),G1H1(164),m3h2x1(:,259),heltab2x2(:,:,366))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(164),10,nMB,G2tensor(182),n2h1(100))
  call Hloop_AV_Q(ntryL,G1H2(128),ex4(:),G1H1(30),m3h2x1(:,260),heltab2x2(:,:,367))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(30),31,nMT,G2tensor(183),n2h1(101))
  call Hloop_AV_Q(ntryL,G1H2(306),ex4(:),G1H1(31),m3h2x1(:,261),heltab2x2(:,:,368))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(31),8,nMT,G2tensor(184),n2h1(102))
  call Hloop_AV_Q(ntryL,G1H2(307),ex4(:),G1H1(223),m3h2x1(:,262),heltab2x2(:,:,369))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(223),31,nMT,G2tensor(185),n2h1(103))
  call Hloop_AV_Q(ntryL,G1H2(310),ex4(:),G1H1(36),m3h2x1(:,263),heltab2x2(:,:,370))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(36),10,nMT,G2tensor(186),n2h1(104))
  call Hloop_AV_Q(ntryL,G1H2(313),ex4(:),G1H1(37),m3h2x1(:,264),heltab2x2(:,:,371))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(37),31,nMB,G2tensor(187),n2h1(105))
  call Hloop_AV_Q(ntryL,G1H2(314),ex4(:),G1H1(218),m3h2x1(:,265),heltab2x2(:,:,372))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(218),8,nMB,G2tensor(188),n2h1(106))
  call Hloop_AV_Q(ntryL,G1H2(319),ex4(:),G1H1(23),m3h2x1(:,266),heltab2x2(:,:,373))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(23),31,nMB,G2tensor(189),n2h1(107))
  call Hloop_AV_Q(ntryL,G1H2(320),ex4(:),G1H1(29),m3h2x1(:,267),heltab2x2(:,:,374))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(29),10,nMB,G2tensor(190),n2h1(108))
  call Hloop_QV_A(ntryL,G1H2(324),ex4(:),G1H1(35),m3h2x1(:,268),heltab2x2(:,:,375))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(35),31,nMB,G2tensor(191),n2h1(109))
  call Hloop_QV_A(ntryL,G1H2(325),ex4(:),G1H1(42),m3h2x1(:,269),heltab2x2(:,:,376))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),8,nMB,G2tensor(192),n2h1(110))
  call Hloop_QV_A(ntryL,G1H2(330),ex4(:),G1H1(43),m3h2x1(:,270),heltab2x2(:,:,377))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(43),31,nMB,G2tensor(193),n2h1(111))
  call Hloop_QV_A(ntryL,G1H2(331),ex4(:),G1H1(47),m3h2x1(:,271),heltab2x2(:,:,378))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(47),12,nMB,G2tensor(194),n2h1(112))
  call Hloop_QV_A(ntryL,G1H2(335),ex4(:),G1H1(41),m3h2x1(:,272),heltab2x2(:,:,379))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(41),31,nMB,G2tensor(195),n2h1(113))
  call Hloop_QV_A(ntryL,G1H2(336),ex4(:),G1H1(59),m3h2x1(:,273),heltab2x2(:,:,380))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(59),8,nMB,G2tensor(196),n2h1(114))
  call Hloop_QV_A(ntryL,G1H2(341),ex4(:),G1H1(70),m3h2x1(:,274),heltab2x2(:,:,381))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(70),31,nMB,G2tensor(197),n2h1(115))
  call Hloop_QV_A(ntryL,G1H2(342),ex4(:),G1H1(81),m3h2x1(:,275),heltab2x2(:,:,382))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(81),12,nMB,G2tensor(198),n2h1(116))
  call Hloop_QV_A(ntryL,G1H2(346),ex4(:),G1H1(92),m3h2x1(:,276),heltab2x2(:,:,383))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(92),31,nMT,G2tensor(199),n2h1(117))
  call Hloop_QV_A(ntryL,G1H2(347),ex4(:),G1H1(103),m3h2x1(:,277),heltab2x2(:,:,384))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(103),8,nMT,G2tensor(200),n2h1(118))
  call Hloop_QV_A(ntryL,G1H2(352),ex4(:),G1H1(114),m3h2x1(:,278),heltab2x2(:,:,385))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(114),31,nMT,G2tensor(201),n2h1(119))
  call Hloop_QV_A(ntryL,G1H2(353),ex4(:),G1H1(125),m3h2x1(:,279),heltab2x2(:,:,386))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(125),12,nMT,G2tensor(202),n2h1(120))
  call Hloop_QV_A(ntryL,G1H2(357),ex4(:),G1H1(136),m3h2x1(:,280),heltab2x2(:,:,387))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(136),31,nMB,G2tensor(203),n2h1(121))
  call Hloop_QV_A(ntryL,G1H2(358),ex4(:),G1H1(48),m3h2x1(:,281),heltab2x2(:,:,388))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(48),8,nMB,G2tensor(204),n2h1(122))
  call Hloop_QV_A(ntryL,G1H2(363),ex4(:),G1H1(49),m3h2x1(:,282),heltab2x2(:,:,389))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(49),31,nMB,G2tensor(205),n2h1(123))
  call Hloop_QV_A(ntryL,G1H2(364),ex4(:),G1H1(53),m3h2x1(:,283),heltab2x2(:,:,390))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(53),12,nMB,G2tensor(206),n2h1(124))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(369),4,ex4(:),8,G2tensor(207),m3h2x1(:,284),heltab2x2(:,:,391))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(374),4,ex4(:),8,G2tensor(208),m3h2x1(:,285),heltab2x2(:,:,392))
  call Hloop_QV_A(ntryL,G1H2(378),ex4(:),G1H1(147),m3h2x1(:,286),heltab2x2(:,:,393))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(147),31,nMB,G2tensor(209),n2h1(127))
  call Hloop_QV_A(ntryL,G1H2(379),ex4(:),G1H1(158),m3h2x1(:,287),heltab2x2(:,:,394))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(158),8,nMB,G2tensor(210),n2h1(128))
  call Hloop_QV_A(ntryL,G1H2(384),ex4(:),G1H1(179),m3h2x1(:,288),heltab2x2(:,:,395))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(179),31,nMB,G2tensor(211),n2h1(129))
  call Hloop_QV_A(ntryL,G1H2(385),ex4(:),G1H1(190),m3h2x1(:,289),heltab2x2(:,:,396))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(190),9,nMB,G2tensor(212),n2h1(130))
  call Hloop_QV_A(ntryL,G1H2(389),ex4(:),G1H1(201),m3h2x1(:,290),heltab2x2(:,:,397))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(201),31,nMB,G2tensor(213),n2h1(131))
  call Hloop_QV_A(ntryL,G1H2(390),ex4(:),G1H1(212),m3h2x1(:,291),heltab2x2(:,:,398))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(212),8,nMB,G2tensor(214),n2h1(132))
  call Hloop_QV_A(ntryL,G1H2(395),ex4(:),G1H1(54),m3h2x1(:,292),heltab2x2(:,:,399))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(54),31,nMB,G2tensor(215),n2h1(133))
  call Hloop_QV_A(ntryL,G1H2(396),ex4(:),G1H1(55),m3h2x1(:,293),heltab2x2(:,:,400))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(55),9,nMB,G2tensor(216),n2h1(134))
  call Hloop_QV_A(ntryL,G1H2(400),ex4(:),G1H1(60),m3h2x1(:,294),heltab2x2(:,:,401))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(60),31,nMT,G2tensor(217),n2h1(135))
  call Hloop_QV_A(ntryL,G1H2(401),ex4(:),G1H1(61),m3h2x1(:,295),heltab2x2(:,:,402))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(61),8,nMT,G2tensor(218),n2h1(136))
  call Hloop_QV_A(ntryL,G1H2(406),ex4(:),G1H1(65),m3h2x1(:,296),heltab2x2(:,:,403))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(65),31,nMT,G2tensor(219),n2h1(137))
  call Hloop_QV_A(ntryL,G1H2(407),ex4(:),G1H1(66),m3h2x1(:,297),heltab2x2(:,:,404))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(66),9,nMT,G2tensor(220),n2h1(138))
  call Hloop_QV_A(ntryL,G1H2(411),ex4(:),G1H1(71),m3h2x1(:,298),heltab2x2(:,:,405))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(71),31,nMB,G2tensor(221),n2h1(139))
  call Hloop_QV_A(ntryL,G1H2(412),ex4(:),G1H1(72),m3h2x1(:,299),heltab2x2(:,:,406))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(72),8,nMB,G2tensor(222),n2h1(140))
  call Hloop_QV_A(ntryL,G1H2(417),ex4(:),G1H1(76),m3h2x1(:,300),heltab2x2(:,:,407))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(76),31,nMB,G2tensor(223),n2h1(141))
  call Hloop_QV_A(ntryL,G1H2(418),ex4(:),G1H1(77),m3h2x1(:,301),heltab2x2(:,:,408))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(77),9,nMB,G2tensor(224),n2h1(142))
  call Hloop_QS_A(ntryL,G1H1(120),ex3(:),G1H1(82),ngH,m3h1x1(:,69),heltab2x1(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(82),31,nMB,G2tensor(225),n2h1(143))
  call Hloop_QS_A(ntryL,G1H1(121),ex3(:),G1H1(83),ngH,m3h1x1(:,70),heltab2x1(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(83),4,nMB,G2tensor(226),n2h1(144))
  call Hloop_QS_A(ntryL,G1H1(126),ex3(:),G1H1(87),ngH,m3h1x1(:,71),heltab2x1(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(87),31,nMB,G2tensor(227),n2h1(145))
  call Hloop_QS_A(ntryL,G1H1(127),ex3(:),G1H1(88),ngH,m3h1x1(:,72),heltab2x1(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(88),12,nMB,G2tensor(228),n2h1(146))
  call Hloop_QS_A(ntryL,G1H1(131),ex3(:),G1H1(93),ngH,m3h1x1(:,73),heltab2x1(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(93),31,nMB,G2tensor(229),n2h1(147))
  call Hloop_QS_A(ntryL,G1H1(132),ex3(:),G1H1(94),ngH,m3h1x1(:,74),heltab2x1(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(94),4,nMB,G2tensor(230),n2h1(148))
  call Hloop_QS_A(ntryL,G1H1(137),ex3(:),G1H1(98),ngH,m3h1x1(:,75),heltab2x1(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(98),31,nMB,G2tensor(231),n2h1(149))
  call Hloop_QS_A(ntryL,G1H1(138),ex3(:),G1H1(99),ngH,m3h1x1(:,76),heltab2x1(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(99),12,nMB,G2tensor(232),n2h1(150))
  call Hloop_QS_A(ntryL,G1H1(142),ex3(:),G1H1(104),ngH,m3h1x1(:,77),heltab2x1(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(104),31,nMT,G2tensor(233),n2h1(151))
  call Hloop_QS_A(ntryL,G1H1(143),ex3(:),G1H1(105),ngH,m3h1x1(:,78),heltab2x1(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(105),4,nMT,G2tensor(234),n2h1(152))
  call Hloop_QS_A(ntryL,G1H1(148),ex3(:),G1H1(109),ngH,m3h1x1(:,79),heltab2x1(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(109),31,nMT,G2tensor(235),n2h1(153))
  call Hloop_QS_A(ntryL,G1H1(149),ex3(:),G1H1(110),ngH,m3h1x1(:,80),heltab2x1(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(110),12,nMT,G2tensor(236),n2h1(154))
  call Hloop_QS_A(ntryL,G1H1(153),ex3(:),G1H1(115),ngH,m3h1x1(:,81),heltab2x1(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(115),31,nMB,G2tensor(237),n2h1(155))
  call Hloop_QS_A(ntryL,G1H1(154),ex3(:),G1H1(116),ngH,m3h1x1(:,82),heltab2x1(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(116),4,nMB,G2tensor(238),n2h1(156))
  call Hloop_QS_A(ntryL,G1H1(159),ex3(:),G1H1(233),ngH,m3h1x1(:,83),heltab2x1(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(233),31,nMB,G2tensor(239),n2h1(157))
  call Hloop_QS_A(ntryL,G1H1(160),ex3(:),G1H1(244),ngH,m3h1x1(:,84),heltab2x1(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(244),12,nMB,G2tensor(240),n2h1(158))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(165),8,ex3(:),4,G2tensor(241),m3h1x1(:,85),heltab2x1(:,:,85))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(170),8,ex3(:),4,G2tensor(242),m3h1x1(:,86),heltab2x1(:,:,86))
  call Hloop_AV_Q(ntryL,G1H2(422),ex4(:),G1H1(18),m3h2x1(:,302),heltab2x2(:,:,409))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(18),31,nMB,G2tensor(243),n2h1(161))
  call Hloop_AV_Q(ntryL,G1H2(423),ex4(:),G1H1(19),m3h2x1(:,303),heltab2x2(:,:,410))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),8,nMB,G2tensor(244),n2h1(162))
  call Hloop_AV_Q(ntryL,G1H2(428),ex4(:),G1H1(169),m3h2x1(:,304),heltab2x2(:,:,411))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(169),31,nMB,G2tensor(245),n2h1(163))
  call Hloop_AV_Q(ntryL,G1H2(429),ex4(:),G1H1(24),m3h2x1(:,305),heltab2x2(:,:,412))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(24),12,nMB,G2tensor(246),n2h1(164))
  call Hloop_AV_Q(ntryL,G1H2(433),ex4(:),G1H1(25),m3h2x1(:,306),heltab2x2(:,:,413))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(25),31,nMB,G2tensor(247),n2h1(165))
  call Hloop_AV_Q(ntryL,G1H2(434),ex4(:),G1H1(164),m3h2x1(:,307),heltab2x2(:,:,414))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(164),8,nMB,G2tensor(248),n2h1(166))
  call Hloop_AV_Q(ntryL,G1H2(439),ex4(:),G1H1(30),m3h2x1(:,308),heltab2x2(:,:,415))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(30),31,nMB,G2tensor(249),n2h1(167))
  call Hloop_AV_Q(ntryL,G1H2(440),ex4(:),G1H1(31),m3h2x1(:,309),heltab2x2(:,:,416))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(31),12,nMB,G2tensor(250),n2h1(168))
  call Hloop_AV_Q(ntryL,G1H2(444),ex4(:),G1H1(223),m3h2x1(:,310),heltab2x2(:,:,417))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(223),31,nMT,G2tensor(251),n2h1(169))
  call Hloop_AV_Q(ntryL,G1H2(445),ex4(:),G1H1(36),m3h2x1(:,311),heltab2x2(:,:,418))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(36),8,nMT,G2tensor(252),n2h1(170))
  call Hloop_AV_Q(ntryL,G1H2(450),ex4(:),G1H1(37),m3h2x1(:,312),heltab2x2(:,:,419))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(37),31,nMT,G2tensor(253),n2h1(171))
  call Hloop_AV_Q(ntryL,G1H2(451),ex4(:),G1H1(218),m3h2x1(:,313),heltab2x2(:,:,420))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(218),12,nMT,G2tensor(254),n2h1(172))
  call Hloop_AV_Q(ntryL,G1H2(455),ex4(:),G1H1(23),m3h2x1(:,314),heltab2x2(:,:,421))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(23),31,nMB,G2tensor(255),n2h1(173))
  call Hloop_AV_Q(ntryL,G1H2(456),ex4(:),G1H1(29),m3h2x1(:,315),heltab2x2(:,:,422))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(29),8,nMB,G2tensor(256),n2h1(174))
  call Hloop_AV_Q(ntryL,G1H2(461),ex4(:),G1H1(35),m3h2x1(:,316),heltab2x2(:,:,423))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(35),31,nMB,G2tensor(257),n2h1(175))
  call Hloop_AV_Q(ntryL,G1H2(462),ex4(:),G1H1(42),m3h2x1(:,317),heltab2x2(:,:,424))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),12,nMB,G2tensor(258),n2h1(176))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(467),4,ex4(:),8,G2tensor(259),m3h2x1(:,318),heltab2x2(:,:,425))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(472),4,ex4(:),8,G2tensor(260),m3h2x1(:,319),heltab2x2(:,:,426))
  call Hloop_AS_Q(ntryL,G1H1(174),ex3(:),G1H1(43),ngH,m3h1x1(:,87),heltab2x1(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(43),31,nMB,G2tensor(261),n2h1(179))
  call Hloop_AS_Q(ntryL,G1H1(175),ex3(:),G1H1(47),ngH,m3h1x1(:,88),heltab2x1(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(47),4,nMB,G2tensor(262),n2h1(180))
  call Hloop_AS_Q(ntryL,G1H1(180),ex3(:),G1H1(41),ngH,m3h1x1(:,89),heltab2x1(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(41),31,nMB,G2tensor(263),n2h1(181))
  call Hloop_AS_Q(ntryL,G1H1(181),ex3(:),G1H1(59),ngH,m3h1x1(:,90),heltab2x1(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(59),12,nMB,G2tensor(264),n2h1(182))
  call Hloop_AS_Q(ntryL,G1H1(185),ex3(:),G1H1(70),ngH,m3h1x1(:,91),heltab2x1(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(70),31,nMB,G2tensor(265),n2h1(183))
  call Hloop_AS_Q(ntryL,G1H1(186),ex3(:),G1H1(81),ngH,m3h1x1(:,92),heltab2x1(:,:,92))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(81),4,nMB,G2tensor(266),n2h1(184))
  call Hloop_AS_Q(ntryL,G1H1(191),ex3(:),G1H1(92),ngH,m3h1x1(:,93),heltab2x1(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(92),31,nMB,G2tensor(267),n2h1(185))
  call Hloop_AS_Q(ntryL,G1H1(192),ex3(:),G1H1(103),ngH,m3h1x1(:,94),heltab2x1(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(103),12,nMB,G2tensor(268),n2h1(186))
  call Hloop_AS_Q(ntryL,G1H1(196),ex3(:),G1H1(114),ngH,m3h1x1(:,95),heltab2x1(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(114),31,nMT,G2tensor(269),n2h1(187))
  call Hloop_AS_Q(ntryL,G1H1(197),ex3(:),G1H1(125),ngH,m3h1x1(:,96),heltab2x1(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(125),4,nMT,G2tensor(270),n2h1(188))
  call Hloop_AS_Q(ntryL,G1H1(202),ex3(:),G1H1(136),ngH,m3h1x1(:,97),heltab2x1(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(136),31,nMT,G2tensor(271),n2h1(189))
  call Hloop_AS_Q(ntryL,G1H1(203),ex3(:),G1H1(48),ngH,m3h1x1(:,98),heltab2x1(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(48),12,nMT,G2tensor(272),n2h1(190))
  call Hloop_AS_Q(ntryL,G1H1(207),ex3(:),G1H1(49),ngH,m3h1x1(:,99),heltab2x1(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(49),31,nMB,G2tensor(273),n2h1(191))
  call Hloop_AS_Q(ntryL,G1H1(208),ex3(:),G1H1(53),ngH,m3h1x1(:,100),heltab2x1(:,:,100))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(53),4,nMB,G2tensor(274),n2h1(192))
  call Hloop_AS_Q(ntryL,G1H1(213),ex3(:),G1H1(147),ngH,m3h1x1(:,101),heltab2x1(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(147),31,nMB,G2tensor(275),n2h1(193))
  call Hloop_AS_Q(ntryL,G1H1(214),ex3(:),G1H1(158),ngH,m3h1x1(:,102),heltab2x1(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(158),12,nMB,G2tensor(276),n2h1(194))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(219),8,ex3(:),4,G2tensor(277),m3h1x1(:,103),heltab2x1(:,:,103))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(224),8,ex3(:),4,G2tensor(278),m3h1x1(:,104),heltab2x1(:,:,104))
  call Hloop_QV_A(ntryL,G1H2(476),ex4(:),G1H1(179),m3h2x1(:,320),heltab2x2(:,:,427))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(179),31,nMB,G2tensor(279),n2h1(197))
  call Hloop_QV_A(ntryL,G1H2(477),ex4(:),G1H1(190),m3h2x1(:,321),heltab2x2(:,:,428))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(190),8,nMB,G2tensor(280),n2h1(198))
  call Hloop_QV_A(ntryL,G1H2(482),ex4(:),G1H1(201),m3h2x1(:,322),heltab2x2(:,:,429))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(201),31,nMB,G2tensor(281),n2h1(199))
  call Hloop_QV_A(ntryL,G1H2(483),ex4(:),G1H1(212),m3h2x1(:,323),heltab2x2(:,:,430))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(212),9,nMB,G2tensor(282),n2h1(200))
  call Hloop_QV_A(ntryL,G1H2(487),ex4(:),G1H1(54),m3h2x1(:,324),heltab2x2(:,:,431))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(54),31,nMT,G2tensor(283),n2h1(201))
  call Hloop_QV_A(ntryL,G1H2(488),ex4(:),G1H1(55),m3h2x1(:,325),heltab2x2(:,:,432))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(55),8,nMT,G2tensor(284),n2h1(202))
  call Hloop_QV_A(ntryL,G1H2(493),ex4(:),G1H1(60),m3h2x1(:,326),heltab2x2(:,:,433))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(60),31,nMT,G2tensor(285),n2h1(203))
  call Hloop_QV_A(ntryL,G1H2(494),ex4(:),G1H1(61),m3h2x1(:,327),heltab2x2(:,:,434))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(61),9,nMT,G2tensor(286),n2h1(204))
  call Hloop_QS_A(ntryL,G1H1(228),ex3(:),G1H1(65),ngH,m3h1x1(:,105),heltab2x1(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(65),31,nMT,G2tensor(287),n2h1(205))
  call Hloop_QS_A(ntryL,G1H1(229),ex3(:),G1H1(66),ngH,m3h1x1(:,106),heltab2x1(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(66),4,nMT,G2tensor(288),n2h1(206))
  call Hloop_QS_A(ntryL,G1H1(234),ex3(:),G1H1(71),ngH,m3h1x1(:,107),heltab2x1(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(71),31,nMT,G2tensor(289),n2h1(207))
  call Hloop_QS_A(ntryL,G1H1(235),ex3(:),G1H1(72),ngH,m3h1x1(:,108),heltab2x1(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(72),5,nMT,G2tensor(290),n2h1(208))
  call Hloop_AV_Q(ntryL,G1H2(498),ex4(:),G1H1(76),m3h2x1(:,328),heltab2x2(:,:,435))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(76),31,nMB,G2tensor(291),n2h1(209))
  call Hloop_AV_Q(ntryL,G1H2(499),ex4(:),G1H1(77),m3h2x1(:,329),heltab2x2(:,:,436))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(77),8,nMB,G2tensor(292),n2h1(210))
  call Hloop_AV_Q(ntryL,G1H2(504),ex4(:),G1H1(120),m3h2x1(:,330),heltab2x2(:,:,437))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(120),31,nMB,G2tensor(293),n2h1(211))
  call Hloop_AV_Q(ntryL,G1H2(505),ex4(:),G1H1(82),m3h2x1(:,331),heltab2x2(:,:,438))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(82),10,nMB,G2tensor(294),n2h1(212))
  call Hloop_AV_Q(ntryL,G1H2(509),ex4(:),G1H1(121),m3h2x1(:,332),heltab2x2(:,:,439))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(121),31,nMT,G2tensor(295),n2h1(213))
  call Hloop_AV_Q(ntryL,G1H2(510),ex4(:),G1H1(83),m3h2x1(:,333),heltab2x2(:,:,440))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(83),8,nMT,G2tensor(296),n2h1(214))
  call Hloop_AV_Q(ntryL,G1H2(515),ex4(:),G1H1(126),m3h2x1(:,334),heltab2x2(:,:,441))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(126),31,nMT,G2tensor(297),n2h1(215))
  call Hloop_AV_Q(ntryL,G1H2(516),ex4(:),G1H1(87),m3h2x1(:,335),heltab2x2(:,:,442))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(87),10,nMT,G2tensor(298),n2h1(216))
  call Hloop_SA_Q(ntryL,G1H2(521),ex2(:),G1H1(127),ngPbt,m3h2x1(:,336),heltab2x2(:,:,443))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(127),10,nMT,G2tensor(299),n2h1(217))
  call Hloop_WA_Q(ntryL,G1H2(526),ex2(:),G1H1(88),m3h2x1(:,337),heltab2x2(:,:,444))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(88),10,nMT,G2tensor(300),n2h1(218))
  call Hloop_AS_Q(ntryL,G1H1(239),ex3(:),G1H1(131),ngH,m3h1x1(:,109),heltab2x1(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(131),31,nMT,G2tensor(301),n2h1(219))
  call Hloop_AS_Q(ntryL,G1H1(240),ex3(:),G1H1(93),ngH,m3h1x1(:,110),heltab2x1(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(93),4,nMT,G2tensor(302),n2h1(220))
  call Hloop_AS_Q(ntryL,G1H1(245),ex3(:),G1H1(132),ngH,m3h1x1(:,111),heltab2x1(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(132),31,nMT,G2tensor(303),n2h1(221))
  call Hloop_AS_Q(ntryL,G1H1(246),ex3(:),G1H1(94),ngH,m3h1x1(:,112),heltab2x1(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(94),6,nMT,G2tensor(304),n2h1(222))
  call Hloop_SA_Q(ntryL,G1H2(531),ex2(:),G1H1(137),ngPbt,m3h2x1(:,338),heltab2x2(:,:,445))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(137),6,nMT,G2tensor(305),n2h1(223))
  call Hloop_WA_Q(ntryL,G1H2(536),ex2(:),G1H1(98),m3h2x1(:,339),heltab2x2(:,:,446))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(98),6,nMT,G2tensor(306),n2h1(224))
  call ol_merge_tensors(G2tensor(74),[G2tensor(71),G2tensor(2),G2tensor(1)])
  call ol_merge_tensors(G2tensor(80),[G2tensor(77),G2tensor(4),G2tensor(3)])
  call ol_merge_tensors(G2tensor(86),[G2tensor(83),G2tensor(6),G2tensor(5)])
  call ol_merge_tensors(G2tensor(92),[G2tensor(89),G2tensor(8),G2tensor(7)])
  call ol_merge_tensors(G2tensor(98),[G2tensor(95),G2tensor(10),G2tensor(9)])
  call ol_merge_tensors(G2tensor(104),[G2tensor(101),G2tensor(12),G2tensor(11)])
  call ol_merge_tensors(G2tensor(147),[G2tensor(110),G2tensor(25),G2tensor(13)])
  call ol_merge_tensors(G2tensor(167),[G2tensor(122),G2tensor(37),G2tensor(14)])
  call ol_merge_tensors(G2tensor(139),[G2tensor(135),G2tensor(21),G2tensor(19)])
  call ol_merge_tensors(G2tensor(151),[G2tensor(143),G2tensor(29),G2tensor(27)])
  call ol_merge_tensors(G2tensor(159),[G2tensor(155),G2tensor(33),G2tensor(31)])
  call ol_merge_tensors(G2tensor(171),[G2tensor(163),G2tensor(41),G2tensor(39)])
  call ol_merge_tensors(G2tensor(55),[G2tensor(51)])
  call ol_merge_tensors(G2tensor(63),[G2tensor(53)])
  call ol_merge_tensors(G2tensor(61),[G2tensor(59)])
  call ol_merge_tensors(G2tensor(69),[G2tensor(67)])
  call ol_merge_tensors(G2tensor(119),[G2tensor(116)])
  call ol_merge_tensors(G2tensor(128),[G2tensor(125)])
  call Hotf_5pt_reduction_last(G2tensor(74),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(80),RedSet_5(9),mass5set(:,16),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(86),RedSet_5(2),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(92),RedSet_5(10),mass5set(:,16),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),4)
  call Hotf_5pt_reduction_last(G2tensor(98),RedSet_5(11),mass5set(:,16),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(104),RedSet_5(12),mass5set(:,16),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_5pt_reduction_last(G2tensor(147),RedSet_5(4),mass5set(:,4),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),4)
  call Hotf_5pt_reduction_last(G2tensor(167),RedSet_5(7),mass5set(:,4),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),4)
  call Hotf_5pt_reduction_last(G2tensor(139),RedSet_5(3),mass5set(:,2),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(4),mass5set(:,3),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),4)
  call Hotf_5pt_reduction_last(G2tensor(151),RedSet_5(4),mass5set(:,2),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),4)
  call Hotf_5pt_reduction_last(G2tensor(159),RedSet_5(5),mass5set(:,2),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),8)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(7),mass5set(:,3),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),4)
  call Hotf_5pt_reduction_last(G2tensor(171),RedSet_5(7),mass5set(:,2),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),4)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(6),mass5set(:,5),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),2)
  call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(8),mass5set(:,5),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),2)
  call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(6),mass5set(:,6),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),2)
  call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(6),mass5set(:,7),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),2)
  call Hotf_5pt_reduction_last(G2tensor(65),RedSet_5(8),mass5set(:,6),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),2)
  call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(8),mass5set(:,7),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),2)
  call Hotf_5pt_reduction_last(G2tensor(107),RedSet_5(3),mass5set(:,20),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),8)
  call Hotf_5pt_reduction_last(G2tensor(113),RedSet_5(5),mass5set(:,20),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),8)
  call Hotf_5pt_reduction_last(G2tensor(119),RedSet_5(6),mass5set(:,19),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),2)
  call Hotf_5pt_reduction_last(G2tensor(128),RedSet_5(8),mass5set(:,19),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),2)
  call Hotf_5pt_reduction_last(G2tensor(175),RedSet_5(1),mass5set(:,8),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),8)
  call Hotf_5pt_reduction_last(G2tensor(179),RedSet_5(1),mass5set(:,9),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),8)
  call Hotf_5pt_reduction_last(G2tensor(183),RedSet_5(1),mass5set(:,10),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),8)
  call Hotf_5pt_reduction_last(G2tensor(187),RedSet_5(1),mass5set(:,11),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),8)
  call Hotf_5pt_reduction_last(G2tensor(191),RedSet_5(9),mass5set(:,12),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),8)
  call Hotf_5pt_reduction_last(G2tensor(195),RedSet_5(9),mass5set(:,13),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),8)
  call Hotf_5pt_reduction_last(G2tensor(199),RedSet_5(9),mass5set(:,14),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),8)
  call Hotf_5pt_reduction_last(G2tensor(203),RedSet_5(9),mass5set(:,15),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),8)
  call Hotf_5pt_reduction_last(G2tensor(209),RedSet_5(2),mass5set(:,8),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),8)
  call Hotf_5pt_reduction_last(G2tensor(213),RedSet_5(2),mass5set(:,9),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),8)
  call Hotf_5pt_reduction_last(G2tensor(217),RedSet_5(2),mass5set(:,10),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),8)
  call Hotf_5pt_reduction_last(G2tensor(221),RedSet_5(2),mass5set(:,11),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),8)
  call Hotf_5pt_reduction_last(G2tensor(225),RedSet_5(10),mass5set(:,12),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),4)
  call Hotf_5pt_reduction_last(G2tensor(229),RedSet_5(10),mass5set(:,13),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),4)
  call Hotf_5pt_reduction_last(G2tensor(233),RedSet_5(10),mass5set(:,14),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),4)
  call Hotf_5pt_reduction_last(G2tensor(237),RedSet_5(10),mass5set(:,15),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),4)
  call Hotf_5pt_reduction_last(G2tensor(243),RedSet_5(11),mass5set(:,12),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
  call G_TensorShift(G1tensor(242),8)
  call Hotf_5pt_reduction_last(G2tensor(247),RedSet_5(11),mass5set(:,13),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
  call G_TensorShift(G1tensor(248),8)
  call Hotf_5pt_reduction_last(G2tensor(251),RedSet_5(11),mass5set(:,14),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257),G1tensor(258))
  call G_TensorShift(G1tensor(254),8)
  call Hotf_5pt_reduction_last(G2tensor(255),RedSet_5(11),mass5set(:,15),  & 
G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264))
  call G_TensorShift(G1tensor(260),8)
  call Hotf_5pt_reduction_last(G2tensor(261),RedSet_5(12),mass5set(:,12),  & 
G1tensor(265),G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(266),4)
  call Hotf_5pt_reduction_last(G2tensor(265),RedSet_5(12),mass5set(:,13),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275),G1tensor(276))
  call G_TensorShift(G1tensor(272),4)
  call Hotf_5pt_reduction_last(G2tensor(269),RedSet_5(12),mass5set(:,14),  & 
G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280),G1tensor(281),G1tensor(282))
  call G_TensorShift(G1tensor(278),4)
  call Hotf_5pt_reduction_last(G2tensor(273),RedSet_5(12),mass5set(:,15),  & 
G1tensor(283),G1tensor(284),G1tensor(285),G1tensor(286),G1tensor(287),G1tensor(288))
  call G_TensorShift(G1tensor(284),4)
  call Hotf_5pt_reduction_last(G2tensor(279),RedSet_5(3),mass5set(:,17),  & 
G1tensor(289),G1tensor(290),G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294))
  call G_TensorShift(G1tensor(290),8)
  call Hotf_5pt_reduction_last(G2tensor(283),RedSet_5(3),mass5set(:,18),  & 
G1tensor(295),G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300))
  call G_TensorShift(G1tensor(296),8)
  call Hotf_5pt_reduction_last(G2tensor(287),RedSet_5(4),mass5set(:,18),  & 
G1tensor(301),G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305),G1tensor(306))
  call G_TensorShift(G1tensor(302),4)
  call Hotf_5pt_reduction_last(G2tensor(291),RedSet_5(5),mass5set(:,17),  & 
G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310),G1tensor(311),G1tensor(312))
  call G_TensorShift(G1tensor(308),8)
  call Hotf_5pt_reduction_last(G2tensor(295),RedSet_5(5),mass5set(:,18),  & 
G1tensor(313),G1tensor(314),G1tensor(315),G1tensor(316),G1tensor(317),G1tensor(318))
  call G_TensorShift(G1tensor(314),8)
  call Hotf_5pt_reduction_last(G2tensor(301),RedSet_5(7),mass5set(:,18),  & 
G1tensor(319),G1tensor(320),G1tensor(321),G1tensor(322),G1tensor(323),G1tensor(324))
  call G_TensorShift(G1tensor(320),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  call ol_merge_tensors(T1sum(25),[G1tensor(145)])
  call ol_merge_tensors(T1sum(26),[G1tensor(151)])
  call ol_merge_tensors(T1sum(27),[G1tensor(157)])
  call ol_merge_tensors(T1sum(28),[G1tensor(163)])
  call ol_merge_tensors(T1sum(29),[G1tensor(169)])
  call ol_merge_tensors(T1sum(30),[G1tensor(175)])
  call ol_merge_tensors(T1sum(31),[G1tensor(181)])
  call ol_merge_tensors(T1sum(32),[G1tensor(187)])
  call ol_merge_tensors(T1sum(33),[G1tensor(193)])
  call ol_merge_tensors(T1sum(34),[G1tensor(199)])
  call ol_merge_tensors(T1sum(35),[G1tensor(205)])
  call ol_merge_tensors(T1sum(36),[G1tensor(211)])
  call ol_merge_tensors(T1sum(37),[G1tensor(217)])
  call ol_merge_tensors(T1sum(38),[G1tensor(223)])
  call ol_merge_tensors(T1sum(39),[G1tensor(229)])
  call ol_merge_tensors(T1sum(40),[G1tensor(235)])
  call ol_merge_tensors(T1sum(41),[G1tensor(241)])
  call ol_merge_tensors(T1sum(42),[G1tensor(247)])
  call ol_merge_tensors(T1sum(43),[G1tensor(253)])
  call ol_merge_tensors(T1sum(44),[G1tensor(259)])
  call ol_merge_tensors(T1sum(45),[G1tensor(265)])
  call ol_merge_tensors(T1sum(46),[G1tensor(271)])
  call ol_merge_tensors(T1sum(47),[G1tensor(277)])
  call ol_merge_tensors(T1sum(48),[G1tensor(283)])
  call ol_merge_tensors(T1sum(49),[G1tensor(289)])
  call ol_merge_tensors(T1sum(50),[G1tensor(295)])
  call ol_merge_tensors(T1sum(51),[G1tensor(301)])
  call ol_merge_tensors(T1sum(52),[G1tensor(307)])
  call ol_merge_tensors(T1sum(53),[G1tensor(313)])
  call ol_merge_tensors(T1sum(54),[G1tensor(319)])
  Gcoeff(:)%j = (-(c(244)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(241),h0tab(:,241),[24,2,1,4],[nMW,nMT,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(1),m4h3x2x4(:,1),heltab3x24(:,:,1))
  Gcoeff(:)%j = (-(c(266)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(242),h0tab(:,242),[24,2,1,4],[nMW,nMT,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(2),m4h3x2x4(:,2),heltab3x24(:,:,2))
  Gcoeff(:)%j = (c(35)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(243),h0tab(:,243),[24,2,1,4],[nMW,nMT,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(3),m4h3x2x4(:,3),heltab3x24(:,:,3))
  Gcoeff(:)%j = (c(71)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(244),h0tab(:,244),[24,2,1,4],[nMW,nMT,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(4),m4h3x2x4(:,4),heltab3x24(:,:,4))
  Gcoeff(:)%j = (-(c(244)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(245),h0tab(:,245),[24,1,2,4],[nMW,nMT,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(5),m4h3x2x4(:,5),heltab3x24(:,:,5))
  Gcoeff(:)%j = (-(c(266)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(246),h0tab(:,246),[24,1,2,4],[nMW,nMT,nMW,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(6),m4h3x2x4(:,6),heltab3x24(:,:,6))
  Gcoeff(:)%j = (c(35)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(247),h0tab(:,247),[24,1,2,4],[nMW,nMT,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(7),m4h3x2x4(:,7),heltab3x24(:,:,7))
  Gcoeff(:)%j = (c(71)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(248),h0tab(:,248),[24,1,2,4],[nMW,nMT,nMW,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(8),m4h3x2x4(:,8),heltab3x24(:,:,8))
  Gcoeff(:)%j = (-(c(258)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(249),h0tab(:,249),[24,1,4,2],[nMW,nMT,nMT,nMW],5,0)
  call Hloop_SVV_S(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(9),m4h3x2x4(:,9),heltab3x24(:,:,9))
  Gcoeff(:)%j = (c(63)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(250),h0tab(:,250),[24,1,4,2],[nMW,nMT,nMT,nMW],5,0)
  call Hloop_VWW_V(ntryL,G0H24(1),ex5(:),ex4(:),G0H4(10),m4h3x2x4(:,10),heltab3x24(:,:,10))
  Gcoeff(:)%j = (-(c(151)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(251),h0tab(:,251),[20,2,1,8],[nMW,nMT,nMW,nMW],5,0)
  call Hloop_VVS_S(ntryL,G0H24(1),ex5(:),ex3(:),G0H8(8),m4h3x1x8(:,1),heltab3x24(:,:,11))
  Gcoeff(:)%j = (c(151)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(252),h0tab(:,252),[20,2,1,8],[nMW,nMT,nMW,nMW],5,0)
  call Hloop_SSV_V(ntryL,G0H24(1),ex3(:),ex5(:),G0H8(9),m4h1x3x8(:,1),heltab3x24(:,:,12))
  Gcoeff(:)%j = (-(c(151)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(253),h0tab(:,253),[20,2,1,8],[nMW,nMT,nMW,nMW],5,0)
  call Hloop_VVS_S(ntryL,G0H24(1),ex5(:),ex3(:),G0H8(10),m4h3x1x8(:,2),heltab3x24(:,:,13))
  Gcoeff(:)%j = (-(c(180)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(254),h0tab(:,254),[20,2,1,8],[nMW,nMT,nMW,nMW],5,0)
  call Hloop_SSV_V(ntryL,G0H24(1),ex3(:),ex5(:),G0H8(11),m4h1x3x8(:,2),heltab3x24(:,:,14))
  Gcoeff(:)%j = (-(c(151)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(255),h0tab(:,255),[20,1,2,8],[nMW,nMT,nMW,nMW],5,0)
  call Hloop_VVS_S(ntryL,G0H24(1),ex5(:),ex3(:),G0H8(12),m4h3x1x8(:,3),heltab3x24(:,:,15))
  Gcoeff(:)%j = (-(c(151)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(256),h0tab(:,256),[20,1,2,8],[nMW,nMT,nMW,nMW],5,0)
  call Hloop_SSV_V(ntryL,G0H24(1),ex3(:),ex5(:),G0H8(13),m4h1x3x8(:,3),heltab3x24(:,:,16))
  Gcoeff(:)%j = (c(151)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(257),h0tab(:,257),[20,1,2,8],[nMW,nMT,nMW,nMW],5,0)
  call Hloop_VVS_S(ntryL,G0H24(1),ex5(:),ex3(:),G0H8(14),m4h3x1x8(:,4),heltab3x24(:,:,17))
  Gcoeff(:)%j = (-(c(180)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(258),h0tab(:,258),[20,1,2,8],[nMW,nMT,nMW,nMW],5,0)
  call Hloop_SSV_V(ntryL,G0H24(1),ex3(:),ex5(:),G0H8(15),m4h1x3x8(:,4),heltab3x24(:,:,18))
  Gcoeff(:)%j = (-(c(110)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(259),h0tab(:,259),[20,1,8,2],[nMH,nMB,nMB,nMZ],5,0)
  call Hloop_VVS_S(ntryL,G0H24(1),ex5(:),ex3(:),G0H8(16),m4h3x1x8(:,5),heltab3x24(:,:,19))
  Gcoeff(:)%j = (c(150)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(260),h0tab(:,260),[20,1,8,2],[nMW,nMT,nMT,nMW],5,0)
  call Hloop_VVS_S(ntryL,G0H24(1),ex5(:),ex3(:),G0H8(17),m4h3x1x8(:,6),heltab3x24(:,:,20))
  Gcoeff(:)%j = (-(c(110)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(261),h0tab(:,261),[20,1,8,2],[nMZ,nMB,nMB,nMH],5,0)
  call Hloop_SSV_V(ntryL,G0H24(1),ex3(:),ex5(:),G0H8(18),m4h1x3x8(:,5),heltab3x24(:,:,21))
  Gcoeff(:)%j = (-(c(150)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(262),h0tab(:,262),[20,1,8,2],[nMW,nMT,nMT,nMW],5,0)
  call Hloop_SSV_V(ntryL,G0H24(1),ex3(:),ex5(:),G0H8(19),m4h1x3x8(:,6),heltab3x24(:,:,22))
  Gcoeff(:)%j = (-(c(151)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(263),h0tab(:,263),[16,1,2,12],[nMW,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(20),m3h3x8(:,241),heltab2x24(:,:,241))
  Gcoeff(:)%j = (c(265)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(264),h0tab(:,264),[16,1,2,12],[nMW,nMT,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(63),m3h3x8(:,242),heltab2x24(:,:,242))
  Gcoeff(:)%j = (c(35)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(265),h0tab(:,265),[16,1,2,12],[nMW,nMT,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(64),m3h3x8(:,243),heltab2x24(:,:,243))
  Gcoeff(:)%j = (-(c(180)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(266),h0tab(:,266),[16,1,2,12],[nMW,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(21),m3h3x8(:,244),heltab2x24(:,:,244))
  Gcoeff(:)%j = (-(c(151)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(267),h0tab(:,267),[16,2,1,12],[nMW,nMT,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(22),m3h3x8(:,245),heltab2x24(:,:,245))
  Gcoeff(:)%j = (-(c(265)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(268),h0tab(:,268),[16,2,1,12],[nMW,nMT,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(68),m3h3x8(:,246),heltab2x24(:,:,246))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(269),h0tab(:,269),[16,2,1,12],[nMW,nMT,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(66),m3h3x8(:,247),heltab2x24(:,:,247))
  Gcoeff(:)%j = (-(c(180)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(270),h0tab(:,270),[16,2,1,12],[nMW,nMT,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(23),m3h3x8(:,248),heltab2x24(:,:,248))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(271),h0tab(:,271),[16,1,12,2],[nMT,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(24),ngZu,m3h3x8(:,249),heltab2x24(:,:,249))
  call Hloop_A_Q(ntryL,G0H8(24),16,nMT,G1H8(67),n2h8(105))
  Gcoeff(:)%j = (c(101)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(272),h0tab(:,272),[16,1,12,2],[nMT,nMW,nMW,nMT],5,0)
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(25),ngZu,m3h3x8(:,250),heltab2x24(:,:,250))
  call Hloop_A_Q(ntryL,G0H8(25),16,nMT,G1H8(69),n2h8(106))
  Gcoeff(:)%j = (c(337)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(273),h0tab(:,273),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(26),ngZl,m3h3x8(:,251),heltab2x24(:,:,251))
  call Hloop_Q_A(ntryL,G0H8(26),16,nML,G1H8(70),n2h8(107))
  Gcoeff(:)%j = (c(337)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(274),h0tab(:,274),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(27),ngZl,m3h3x8(:,252),heltab2x24(:,:,252))
  call Hloop_A_Q(ntryL,G0H8(27),16,nML,G1H8(71),n2h8(108))
  Gcoeff(:)%j = (-(c(342)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(275),h0tab(:,275),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(28),ngZu,m3h3x8(:,253),heltab2x24(:,:,253))
  call Hloop_Q_A(ntryL,G0H8(28),16,nMT,G1H8(72),n2h8(109))
  Gcoeff(:)%j = (-(c(342)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(276),h0tab(:,276),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(29),ngZu,m3h3x8(:,254),heltab2x24(:,:,254))
  call Hloop_A_Q(ntryL,G0H8(29),16,nMT,G1H8(73),n2h8(110))
  Gcoeff(:)%j = (c(330)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(277),h0tab(:,277),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(30),ngZd,m3h3x8(:,255),heltab2x24(:,:,255))
  call Hloop_Q_A(ntryL,G0H8(30),16,nMB,G1H8(74),n2h8(111))
  Gcoeff(:)%j = (c(330)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(278),h0tab(:,278),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(31),ngZd,m3h3x8(:,256),heltab2x24(:,:,256))
  call Hloop_A_Q(ntryL,G0H8(31),16,nMB,G1H8(75),n2h8(112))
  Gcoeff(:)%j = (-(c(337)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(279),h0tab(:,279),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,37))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(32),ngZl,m3h3x8(:,257),heltab2x24(:,:,257))
  call Hloop_Q_A(ntryL,G0H8(32),16,nML,G1H8(76),n2h8(113))
  Gcoeff(:)%j = (-(c(337)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(280),h0tab(:,280),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,37))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(33),ngZl,m3h3x8(:,258),heltab2x24(:,:,258))
  call Hloop_A_Q(ntryL,G0H8(33),16,nML,G1H8(77),n2h8(114))
  Gcoeff(:)%j = (-(c(342)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(281),h0tab(:,281),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,37))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(34),ngZu,m3h3x8(:,259),heltab2x24(:,:,259))
  call Hloop_Q_A(ntryL,G0H8(34),16,nMT,G1H8(78),n2h8(115))
  Gcoeff(:)%j = (-(c(342)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(282),h0tab(:,282),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,37))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(35),ngZu,m3h3x8(:,260),heltab2x24(:,:,260))
  call Hloop_A_Q(ntryL,G0H8(35),16,nMT,G1H8(79),n2h8(116))
  Gcoeff(:)%j = (-(c(330)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(283),h0tab(:,283),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,37))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(36),ngZd,m3h3x8(:,261),heltab2x24(:,:,261))
  call Hloop_Q_A(ntryL,G0H8(36),16,nMB,G1H8(83),n2h8(117))
  Gcoeff(:)%j = (-(c(330)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(284),h0tab(:,284),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,37))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(37),ngZd,m3h3x8(:,262),heltab2x24(:,:,262))
  call Hloop_A_Q(ntryL,G0H8(37),16,nMB,G1H8(81),n2h8(118))
  Gcoeff(:)%j = (-(c(251)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(285),h0tab(:,285),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(82),m3h3x8(:,263),heltab2x24(:,:,263))
  Gcoeff(:)%j = (-(c(251)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(286),h0tab(:,286),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(84),m3h3x8(:,264),heltab2x24(:,:,264))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(287),h0tab(:,287),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(85),m3h3x8(:,265),heltab2x24(:,:,265))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(288),h0tab(:,288),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(86),m3h3x8(:,266),heltab2x24(:,:,266))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(289),h0tab(:,289),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(87),m3h3x8(:,267),heltab2x24(:,:,267))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(290),h0tab(:,290),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(88),m3h3x8(:,268),heltab2x24(:,:,268))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(291),h0tab(:,291),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(89),m3h3x8(:,269),heltab2x24(:,:,269))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(292),h0tab(:,292),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(90),m3h3x8(:,270),heltab2x24(:,:,270))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(293),h0tab(:,293),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(91),m3h3x8(:,271),heltab2x24(:,:,271))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(294),h0tab(:,294),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(92),m3h3x8(:,272),heltab2x24(:,:,272))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(295),h0tab(:,295),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(93),m3h3x8(:,273),heltab2x24(:,:,273))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(296),h0tab(:,296),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(94),m3h3x8(:,274),heltab2x24(:,:,274))
  Gcoeff(:)%j = (-(c(165)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(297),h0tab(:,297),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(38),m3h3x8(:,275),heltab2x24(:,:,275))
  Gcoeff(:)%j = (c(165)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(298),h0tab(:,298),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(39),m3h3x8(:,276),heltab2x24(:,:,276))
  Gcoeff(:)%j = (c(165)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(299),h0tab(:,299),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(40),m3h3x8(:,277),heltab2x24(:,:,277))
  Gcoeff(:)%j = (c(165)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(300),h0tab(:,300),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(41),m3h3x8(:,278),heltab2x24(:,:,278))
  Gcoeff(:)%j = (c(285)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(301),h0tab(:,301),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(95),m3h3x8(:,279),heltab2x24(:,:,279))
  Gcoeff(:)%j = (-(c(285)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(302),h0tab(:,302),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(96),m3h3x8(:,280),heltab2x24(:,:,280))
  Gcoeff(:)%j = (c(285)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(303),h0tab(:,303),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(97),m3h3x8(:,281),heltab2x24(:,:,281))
  Gcoeff(:)%j = (c(285)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(304),h0tab(:,304),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(98),m3h3x8(:,282),heltab2x24(:,:,282))
  Gcoeff(:)%j = (c(165)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(305),h0tab(:,305),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(42),m3h3x8(:,283),heltab2x24(:,:,283))
  Gcoeff(:)%j = (-(c(165)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(306),h0tab(:,306),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(43),m3h3x8(:,284),heltab2x24(:,:,284))
  Gcoeff(:)%j = (-(c(285)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(307),h0tab(:,307),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(99),m3h3x8(:,285),heltab2x24(:,:,285))
  Gcoeff(:)%j = (c(285)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(308),h0tab(:,308),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(100),m3h3x8(:,286),heltab2x24(:,:,286))
  Gcoeff(:)%j = (c(199)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(309),h0tab(:,309),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(44),m3h3x8(:,287),heltab2x24(:,:,287))
  Gcoeff(:)%j = (c(199)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(310),h0tab(:,310),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(45),m3h3x8(:,288),heltab2x24(:,:,288))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(311),h0tab(:,311),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(101),m3h3x8(:,289),heltab2x24(:,:,289))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(312),h0tab(:,312),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(102),m3h3x8(:,290),heltab2x24(:,:,290))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(313),h0tab(:,313),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(103),m3h3x8(:,291),heltab2x24(:,:,291))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(314),h0tab(:,314),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(104),m3h3x8(:,292),heltab2x24(:,:,292))
  Gcoeff(:)%j = (-(c(192)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(315),h0tab(:,315),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(46),m3h3x8(:,293),heltab2x24(:,:,293))
  Gcoeff(:)%j = (-(c(192)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(316),h0tab(:,316),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(47),m3h3x8(:,294),heltab2x24(:,:,294))
  Gcoeff(:)%j = (-(c(192)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(317),h0tab(:,317),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(48),m3h3x8(:,295),heltab2x24(:,:,295))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(318),h0tab(:,318),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(49),m3h3x8(:,296),heltab2x24(:,:,296))
  Gcoeff(:)%j = (-(c(192)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(319),h0tab(:,319),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(50),m3h3x8(:,297),heltab2x24(:,:,297))
  Gcoeff(:)%j = (-(c(192)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(320),h0tab(:,320),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(51),m3h3x8(:,298),heltab2x24(:,:,298))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(321),h0tab(:,321),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(52),m3h3x8(:,299),heltab2x24(:,:,299))
  Gcoeff(:)%j = (-(c(192)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(322),h0tab(:,322),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(53),m3h3x8(:,300),heltab2x24(:,:,300))
  Gcoeff(:)%j = (-(c(268)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(323),h0tab(:,323),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(105),m3h3x8(:,301),heltab2x24(:,:,301))
  Gcoeff(:)%j = (-(c(268)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(324),h0tab(:,324),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(106),m3h3x8(:,302),heltab2x24(:,:,302))
  Gcoeff(:)%j = (-(c(268)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(325),h0tab(:,325),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(107),m3h3x8(:,303),heltab2x24(:,:,303))
  Gcoeff(:)%j = (c(268)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(326),h0tab(:,326),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(108),m3h3x8(:,304),heltab2x24(:,:,304))
  Gcoeff(:)%j = (c(199)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(327),h0tab(:,327),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(54),m3h3x8(:,305),heltab2x24(:,:,305))
  Gcoeff(:)%j = (c(199)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(328),h0tab(:,328),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(55),m3h3x8(:,306),heltab2x24(:,:,306))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(329),h0tab(:,329),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(109),m3h3x8(:,307),heltab2x24(:,:,307))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(330),h0tab(:,330),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(110),m3h3x8(:,308),heltab2x24(:,:,308))
  Gcoeff(:)%j = (-(c(193)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(331),h0tab(:,331),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(56),m3h3x8(:,309),heltab2x24(:,:,309))
  Gcoeff(:)%j = (c(193)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(332),h0tab(:,332),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(57),m3h3x8(:,310),heltab2x24(:,:,310))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(333),h0tab(:,333),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(111),m3h3x8(:,311),heltab2x24(:,:,311))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(334),h0tab(:,334),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(112),m3h3x8(:,312),heltab2x24(:,:,312))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(335),h0tab(:,335),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(113),m3h3x8(:,313),heltab2x24(:,:,313))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(336),h0tab(:,336),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(114),m3h3x8(:,314),heltab2x24(:,:,314))
  Gcoeff(:)%j = (c(193)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(337),h0tab(:,337),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(58),m3h3x8(:,315),heltab2x24(:,:,315))
  Gcoeff(:)%j = (-(c(193)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(338),h0tab(:,338),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(59),m3h3x8(:,316),heltab2x24(:,:,316))
  Gcoeff(:)%j = (c(193)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(339),h0tab(:,339),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(60),m3h3x8(:,317),heltab2x24(:,:,317))
  Gcoeff(:)%j = (c(193)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(340),h0tab(:,340),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(61),m3h3x8(:,318),heltab2x24(:,:,318))
  Gcoeff(:)%j = (-(c(375)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(341),h0tab(:,341),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,38))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(62),ngZl,m3h3x8(:,319),heltab2x24(:,:,319))
  call Hloop_Q_A(ntryL,G0H8(62),16,nML,G1H8(115),n2h8(119))
  Gcoeff(:)%j = (-(c(375)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(342),h0tab(:,342),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,38))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(63),ngZl,m3h3x8(:,320),heltab2x24(:,:,320))
  call Hloop_A_Q(ntryL,G0H8(63),16,nML,G1H8(116),n2h8(120))
  Gcoeff(:)%j = (-(c(378)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(343),h0tab(:,343),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,38))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(64),ngZu,m3h3x8(:,321),heltab2x24(:,:,321))
  call Hloop_Q_A(ntryL,G0H8(64),16,nMT,G1H8(117),n2h8(121))
  Gcoeff(:)%j = (-(c(378)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(344),h0tab(:,344),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,38))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(65),ngZu,m3h3x8(:,322),heltab2x24(:,:,322))
  call Hloop_A_Q(ntryL,G0H8(65),16,nMT,G1H8(118),n2h8(122))
  Gcoeff(:)%j = (-(c(363)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(345),h0tab(:,345),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,38))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(66),ngZd,m3h3x8(:,323),heltab2x24(:,:,323))
  call Hloop_Q_A(ntryL,G0H8(66),16,nMB,G1H8(119),n2h8(123))
  Gcoeff(:)%j = (-(c(363)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(346),h0tab(:,346),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,38))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(67),ngZd,m3h3x8(:,324),heltab2x24(:,:,324))
  call Hloop_A_Q(ntryL,G0H8(67),16,nMB,G1H8(120),n2h8(124))
  Gcoeff(:)%j = (-(c(376)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(347),h0tab(:,347),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,39))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(68),ngZl,m3h3x8(:,325),heltab2x24(:,:,325))
  call Hloop_Q_A(ntryL,G0H8(68),16,nML,G1H8(121),n2h8(125))
  Gcoeff(:)%j = (-(c(376)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(348),h0tab(:,348),[16,3,8,4],[nML,nML,nML,nML],4,1,wf4(:,39))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(69),ngZl,m3h3x8(:,326),heltab2x24(:,:,326))
  call Hloop_A_Q(ntryL,G0H8(69),16,nML,G1H8(122),n2h8(126))
  Gcoeff(:)%j = (c(380)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(349),h0tab(:,349),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,39))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(70),ngZu,m3h3x8(:,327),heltab2x24(:,:,327))
  call Hloop_Q_A(ntryL,G0H8(70),16,nMT,G1H8(123),n2h8(127))
  Gcoeff(:)%j = (c(380)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(350),h0tab(:,350),[16,3,8,4],[nMT,nMT,nMT,nMT],4,1,wf4(:,39))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(71),ngZu,m3h3x8(:,328),heltab2x24(:,:,328))
  call Hloop_A_Q(ntryL,G0H8(71),16,nMT,G1H8(124),n2h8(128))
  Gcoeff(:)%j = (-(c(368)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(351),h0tab(:,351),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,39))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(72),ngZd,m3h3x8(:,329),heltab2x24(:,:,329))
  call Hloop_Q_A(ntryL,G0H8(72),16,nMB,G1H8(125),n2h8(129))
  Gcoeff(:)%j = (-(c(368)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(352),h0tab(:,352),[16,3,8,4],[nMB,nMB,nMB,nMB],4,1,wf4(:,39))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(73),ngZd,m3h3x8(:,330),heltab2x24(:,:,330))
  call Hloop_A_Q(ntryL,G0H8(73),16,nMB,G1H8(126),n2h8(130))
  Gcoeff(:)%j = (c(278)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(353),h0tab(:,353),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(127),m3h3x8(:,331),heltab2x24(:,:,331))
  Gcoeff(:)%j = (c(278)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(354),h0tab(:,354),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(128),m3h3x8(:,332),heltab2x24(:,:,332))
  Gcoeff(:)%j = (-(c(311)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(355),h0tab(:,355),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(129),m3h3x8(:,333),heltab2x24(:,:,333))
  Gcoeff(:)%j = (-(c(311)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(356),h0tab(:,356),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(130),m3h3x8(:,334),heltab2x24(:,:,334))
  Gcoeff(:)%j = (c(185)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(357),h0tab(:,357),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(131),m3h3x8(:,335),heltab2x24(:,:,335))
  Gcoeff(:)%j = (c(185)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(358),h0tab(:,358),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(132),m3h3x8(:,336),heltab2x24(:,:,336))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(359),h0tab(:,359),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(133),m3h3x8(:,337),heltab2x24(:,:,337))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(360),h0tab(:,360),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(134),m3h3x8(:,338),heltab2x24(:,:,338))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(361),h0tab(:,361),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(135),m3h3x8(:,339),heltab2x24(:,:,339))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(362),h0tab(:,362),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(136),m3h3x8(:,340),heltab2x24(:,:,340))
  Gcoeff(:)%j = (c(137)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(363),h0tab(:,363),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(137),m3h3x8(:,341),heltab2x24(:,:,341))
  Gcoeff(:)%j = (c(137)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(364),h0tab(:,364),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(138),m3h3x8(:,342),heltab2x24(:,:,342))
  Gcoeff(:)%j = (c(186)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(365),h0tab(:,365),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(139),m3h3x8(:,343),heltab2x24(:,:,343))
  Gcoeff(:)%j = (c(186)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(366),h0tab(:,366),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(140),m3h3x8(:,344),heltab2x24(:,:,344))
  Gcoeff(:)%j = (-(c(138)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(367),h0tab(:,367),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(141),m3h3x8(:,345),heltab2x24(:,:,345))
  Gcoeff(:)%j = (-(c(138)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(368),h0tab(:,368),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(142),m3h3x8(:,346),heltab2x24(:,:,346))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(369),h0tab(:,369),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(74),m3h3x8(:,347),heltab2x24(:,:,347))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(370),h0tab(:,370),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(75),m3h3x8(:,348),heltab2x24(:,:,348))
  Gcoeff(:)%j = (c(231)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(371),h0tab(:,371),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(76),m3h3x8(:,349),heltab2x24(:,:,349))
  Gcoeff(:)%j = (c(231)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(372),h0tab(:,372),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(77),m3h3x8(:,350),heltab2x24(:,:,350))
  Gcoeff(:)%j = (-(c(302)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(373),h0tab(:,373),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(143),m3h3x8(:,351),heltab2x24(:,:,351))
  Gcoeff(:)%j = (-(c(302)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(374),h0tab(:,374),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(144),m3h3x8(:,352),heltab2x24(:,:,352))
  Gcoeff(:)%j = (c(322)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(375),h0tab(:,375),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(145),m3h3x8(:,353),heltab2x24(:,:,353))
  Gcoeff(:)%j = (c(322)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(376),h0tab(:,376),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(146),m3h3x8(:,354),heltab2x24(:,:,354))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(377),h0tab(:,377),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(78),m3h3x8(:,355),heltab2x24(:,:,355))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(378),h0tab(:,378),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(79),m3h3x8(:,356),heltab2x24(:,:,356))
  Gcoeff(:)%j = (c(319)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(379),h0tab(:,379),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(2),m3h3x8(:,357),heltab2x24(:,:,357))
  Gcoeff(:)%j = (-(c(319)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(380),h0tab(:,380),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(1),m3h3x8(:,358),heltab2x24(:,:,358))
  Gcoeff(:)%j = (c(295)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(381),h0tab(:,381),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(147),m3h3x8(:,359),heltab2x24(:,:,359))
  Gcoeff(:)%j = (-(c(295)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(382),h0tab(:,382),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(148),m3h3x8(:,360),heltab2x24(:,:,360))
  Gcoeff(:)%j = (-(c(317)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(383),h0tab(:,383),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(149),m3h3x8(:,361),heltab2x24(:,:,361))
  Gcoeff(:)%j = (c(317)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(384),h0tab(:,384),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(150),m3h3x8(:,362),heltab2x24(:,:,362))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(385),h0tab(:,385),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(3),m3h3x8(:,363),heltab2x24(:,:,363))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(386),h0tab(:,386),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(4),m3h3x8(:,364),heltab2x24(:,:,364))
  Gcoeff(:)%j = (-(c(223)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(387),h0tab(:,387),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(5),m3h3x8(:,365),heltab2x24(:,:,365))
  Gcoeff(:)%j = (-(c(223)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(388),h0tab(:,388),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(6),m3h3x8(:,366),heltab2x24(:,:,366))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(389),h0tab(:,389),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(151),m3h3x8(:,367),heltab2x24(:,:,367))
  Gcoeff(:)%j = (c(185)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(390),h0tab(:,390),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(152),m3h3x8(:,368),heltab2x24(:,:,368))
  Gcoeff(:)%j = (-(c(215)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(391),h0tab(:,391),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(153),m3h3x8(:,369),heltab2x24(:,:,369))
  Gcoeff(:)%j = (c(215)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(392),h0tab(:,392),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(154),m3h3x8(:,370),heltab2x24(:,:,370))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(393),h0tab(:,393),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(7),m3h3x8(:,371),heltab2x24(:,:,371))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(394),h0tab(:,394),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(24),m3h3x8(:,372),heltab2x24(:,:,372))
  Gcoeff(:)%j = (-(c(235)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(395),h0tab(:,395),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(25),m3h3x8(:,373),heltab2x24(:,:,373))
  Gcoeff(:)%j = (c(235)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(396),h0tab(:,396),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(26),m3h3x8(:,374),heltab2x24(:,:,374))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(397),h0tab(:,397),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(27),m3h3x8(:,375),heltab2x24(:,:,375))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(398),h0tab(:,398),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(28),m3h3x8(:,376),heltab2x24(:,:,376))
  Gcoeff(:)%j = (c(235)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(399),h0tab(:,399),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(29),m3h3x8(:,377),heltab2x24(:,:,377))
  Gcoeff(:)%j = (-(c(235)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(400),h0tab(:,400),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(30),m3h3x8(:,378),heltab2x24(:,:,378))
  Gcoeff(:)%j = (c(295)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(401),h0tab(:,401),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(155),m3h3x8(:,379),heltab2x24(:,:,379))
  Gcoeff(:)%j = (-(c(295)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(402),h0tab(:,402),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(156),m3h3x8(:,380),heltab2x24(:,:,380))
  Gcoeff(:)%j = (-(c(319)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(403),h0tab(:,403),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(157),m3h3x8(:,381),heltab2x24(:,:,381))
  Gcoeff(:)%j = (c(319)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(404),h0tab(:,404),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(158),m3h3x8(:,382),heltab2x24(:,:,382))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(405),h0tab(:,405),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(31),m3h3x8(:,383),heltab2x24(:,:,383))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(406),h0tab(:,406),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(32),m3h3x8(:,384),heltab2x24(:,:,384))
  Gcoeff(:)%j = (c(324)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(407),h0tab(:,407),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(33),m3h3x8(:,385),heltab2x24(:,:,385))
  Gcoeff(:)%j = (c(324)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(408),h0tab(:,408),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(34),m3h3x8(:,386),heltab2x24(:,:,386))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(409),h0tab(:,409),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(159),m3h3x8(:,387),heltab2x24(:,:,387))
  Gcoeff(:)%j = (c(185)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(410),h0tab(:,410),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(160),m3h3x8(:,388),heltab2x24(:,:,388))
  Gcoeff(:)%j = (c(137)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(411),h0tab(:,411),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(161),m3h3x8(:,389),heltab2x24(:,:,389))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(412),h0tab(:,412),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(162),m3h3x8(:,390),heltab2x24(:,:,390))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(413),h0tab(:,413),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(35),m3h3x8(:,391),heltab2x24(:,:,391))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(414),h0tab(:,414),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(36),m3h3x8(:,392),heltab2x24(:,:,392))
  Gcoeff(:)%j = (c(215)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(415),h0tab(:,415),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(37),m3h3x8(:,393),heltab2x24(:,:,393))
  Gcoeff(:)%j = (-(c(215)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(416),h0tab(:,416),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(62),m3h3x8(:,394),heltab2x24(:,:,394))
  Gcoeff(:)%j = (-(c(205)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(417),h0tab(:,417),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(50),m3h3x8(:,395),heltab2x24(:,:,395))
  Gcoeff(:)%j = (-(c(205)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(418),h0tab(:,418),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(2),m3h3x8(:,396),heltab2x24(:,:,396))
  Gcoeff(:)%j = (-(c(225)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(419),h0tab(:,419),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(3),m3h3x8(:,397),heltab2x24(:,:,397))
  Gcoeff(:)%j = (-(c(225)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(420),h0tab(:,420),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(4),m3h3x8(:,398),heltab2x24(:,:,398))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(421),h0tab(:,421),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(63),m3h3x8(:,399),heltab2x24(:,:,399))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(422),h0tab(:,422),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(64),m3h3x8(:,400),heltab2x24(:,:,400))
  Gcoeff(:)%j = (c(236)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(423),h0tab(:,423),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(65),m3h3x8(:,401),heltab2x24(:,:,401))
  Gcoeff(:)%j = (c(236)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(424),h0tab(:,424),[16,3,8,4],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(66),m3h3x8(:,402),heltab2x24(:,:,402))
  Gcoeff(:)%j = (c(337)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(425),h0tab(:,425),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(67),ngZl,m3h3x8(:,403),heltab2x24(:,:,403))
  call Hloop_A_Q(ntryL,G0H8(67),16,nML,G1H8(7),n2h8(131))
  Gcoeff(:)%j = (c(337)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(426),h0tab(:,426),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(68),ngZl,m3h3x8(:,404),heltab2x24(:,:,404))
  call Hloop_Q_A(ntryL,G0H8(68),16,nML,G1H8(12),n2h8(132))
  Gcoeff(:)%j = (-(c(342)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(427),h0tab(:,427),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(69),ngZu,m3h3x8(:,405),heltab2x24(:,:,405))
  call Hloop_A_Q(ntryL,G0H8(69),16,nMT,G1H8(13),n2h8(133))
  Gcoeff(:)%j = (-(c(342)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(428),h0tab(:,428),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(70),ngZu,m3h3x8(:,406),heltab2x24(:,:,406))
  call Hloop_Q_A(ntryL,G0H8(70),16,nMT,G1H8(16),n2h8(134))
  Gcoeff(:)%j = (c(330)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(429),h0tab(:,429),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(71),ngZd,m3h3x8(:,407),heltab2x24(:,:,407))
  call Hloop_A_Q(ntryL,G0H8(71),16,nMB,G1H8(5),n2h8(135))
  Gcoeff(:)%j = (c(330)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(430),h0tab(:,430),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(72),ngZd,m3h3x8(:,408),heltab2x24(:,:,408))
  call Hloop_Q_A(ntryL,G0H8(72),16,nMB,G1H8(20),n2h8(136))
  Gcoeff(:)%j = (-(c(337)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(431),h0tab(:,431),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,37))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(73),ngZl,m3h3x8(:,409),heltab2x24(:,:,409))
  call Hloop_A_Q(ntryL,G0H8(73),16,nML,G1H8(35),n2h8(137))
  Gcoeff(:)%j = (-(c(337)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(432),h0tab(:,432),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,37))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(67),ngZl,m3h3x8(:,410),heltab2x24(:,:,410))
  call Hloop_Q_A(ntryL,G0H8(67),16,nML,G1H8(8),n2h8(138))
  Gcoeff(:)%j = (-(c(342)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(433),h0tab(:,433),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,37))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(68),ngZu,m3h3x8(:,411),heltab2x24(:,:,411))
  call Hloop_A_Q(ntryL,G0H8(68),16,nMT,G1H8(11),n2h8(139))
  Gcoeff(:)%j = (-(c(342)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(434),h0tab(:,434),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,37))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(69),ngZu,m3h3x8(:,412),heltab2x24(:,:,412))
  call Hloop_Q_A(ntryL,G0H8(69),16,nMT,G1H8(14),n2h8(140))
  Gcoeff(:)%j = (-(c(330)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(435),h0tab(:,435),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,37))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(70),ngZd,m3h3x8(:,413),heltab2x24(:,:,413))
  call Hloop_A_Q(ntryL,G0H8(70),16,nMB,G1H8(15),n2h8(141))
  Gcoeff(:)%j = (-(c(330)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(436),h0tab(:,436),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,37))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(71),ngZd,m3h3x8(:,414),heltab2x24(:,:,414))
  call Hloop_Q_A(ntryL,G0H8(71),16,nMB,G1H8(17),n2h8(142))
  Gcoeff(:)%j = (-(c(251)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(437),h0tab(:,437),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(18),m3h3x8(:,415),heltab2x24(:,:,415))
  Gcoeff(:)%j = (-(c(251)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(438),h0tab(:,438),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(19),m3h3x8(:,416),heltab2x24(:,:,416))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(439),h0tab(:,439),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(21),m3h3x8(:,417),heltab2x24(:,:,417))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(440),h0tab(:,440),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(22),m3h3x8(:,418),heltab2x24(:,:,418))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(441),h0tab(:,441),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(24),m3h3x8(:,419),heltab2x24(:,:,419))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(442),h0tab(:,442),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(25),m3h3x8(:,420),heltab2x24(:,:,420))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(443),h0tab(:,443),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(26),m3h3x8(:,421),heltab2x24(:,:,421))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(444),h0tab(:,444),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(28),m3h3x8(:,422),heltab2x24(:,:,422))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(445),h0tab(:,445),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(29),m3h3x8(:,423),heltab2x24(:,:,423))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(446),h0tab(:,446),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(30),m3h3x8(:,424),heltab2x24(:,:,424))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(447),h0tab(:,447),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(31),m3h3x8(:,425),heltab2x24(:,:,425))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(448),h0tab(:,448),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(65),m3h3x8(:,426),heltab2x24(:,:,426))
  Gcoeff(:)%j = (c(165)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(449),h0tab(:,449),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(72),m3h3x8(:,427),heltab2x24(:,:,427))
  Gcoeff(:)%j = (-(c(165)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(450),h0tab(:,450),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(73),m3h3x8(:,428),heltab2x24(:,:,428))
  Gcoeff(:)%j = (c(165)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(451),h0tab(:,451),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(67),m3h3x8(:,429),heltab2x24(:,:,429))
  Gcoeff(:)%j = (c(165)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(452),h0tab(:,452),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(68),m3h3x8(:,430),heltab2x24(:,:,430))
  Gcoeff(:)%j = (c(168)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(453),h0tab(:,453),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(69),m3h3x8(:,431),heltab2x24(:,:,431))
  Gcoeff(:)%j = (c(168)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(454),h0tab(:,454),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(70),m3h3x8(:,432),heltab2x24(:,:,432))
  Gcoeff(:)%j = (-(c(268)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(455),h0tab(:,455),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(6),m3h3x8(:,433),heltab2x24(:,:,433))
  Gcoeff(:)%j = (-(c(268)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(456),h0tab(:,456),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(33),m3h3x8(:,434),heltab2x24(:,:,434))
  Gcoeff(:)%j = (c(268)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(457),h0tab(:,457),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(80),m3h3x8(:,435),heltab2x24(:,:,435))
  Gcoeff(:)%j = (-(c(268)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(458),h0tab(:,458),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(34),m3h3x8(:,436),heltab2x24(:,:,436))
  Gcoeff(:)%j = (-(c(285)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(459),h0tab(:,459),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(38),m3h3x8(:,437),heltab2x24(:,:,437))
  Gcoeff(:)%j = (c(285)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(460),h0tab(:,460),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(36),m3h3x8(:,438),heltab2x24(:,:,438))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(461),h0tab(:,461),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(9),m3h3x8(:,439),heltab2x24(:,:,439))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(462),h0tab(:,462),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(37),m3h3x8(:,440),heltab2x24(:,:,440))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(463),h0tab(:,463),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(10),m3h3x8(:,441),heltab2x24(:,:,441))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(464),h0tab(:,464),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(39),m3h3x8(:,442),heltab2x24(:,:,442))
  Gcoeff(:)%j = (c(193)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(465),h0tab(:,465),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(71),m3h3x8(:,443),heltab2x24(:,:,443))
  Gcoeff(:)%j = (-(c(193)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(466),h0tab(:,466),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(80),m3h3x8(:,444),heltab2x24(:,:,444))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(467),h0tab(:,467),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(81),m3h3x8(:,445),heltab2x24(:,:,445))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(468),h0tab(:,468),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(82),m3h3x8(:,446),heltab2x24(:,:,446))
  Gcoeff(:)%j = (-(c(192)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(469),h0tab(:,469),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(83),m3h3x8(:,447),heltab2x24(:,:,447))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(470),h0tab(:,470),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(84),m3h3x8(:,448),heltab2x24(:,:,448))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(471),h0tab(:,471),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(85),m3h3x8(:,449),heltab2x24(:,:,449))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(472),h0tab(:,472),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(86),m3h3x8(:,450),heltab2x24(:,:,450))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(473),h0tab(:,473),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(87),m3h3x8(:,451),heltab2x24(:,:,451))
  Gcoeff(:)%j = (-(c(192)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(474),h0tab(:,474),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(88),m3h3x8(:,452),heltab2x24(:,:,452))
  Gcoeff(:)%j = (-(c(165)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(475),h0tab(:,475),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(89),m3h3x8(:,453),heltab2x24(:,:,453))
  Gcoeff(:)%j = (c(165)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(476),h0tab(:,476),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(90),m3h3x8(:,454),heltab2x24(:,:,454))
  Gcoeff(:)%j = (-(c(300)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(477),h0tab(:,477),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(41),m3h3x8(:,455),heltab2x24(:,:,455))
  Gcoeff(:)%j = (c(300)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(478),h0tab(:,478),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(42),m3h3x8(:,456),heltab2x24(:,:,456))
  Gcoeff(:)%j = (c(300)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(479),h0tab(:,479),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(43),m3h3x8(:,457),heltab2x24(:,:,457))
  Gcoeff(:)%j = (c(300)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(480),h0tab(:,480),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(44),m3h3x8(:,458),heltab2x24(:,:,458))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(481),h0tab(:,481),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(45),m3h3x8(:,459),heltab2x24(:,:,459))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(482),h0tab(:,482),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(47),m3h3x8(:,460),heltab2x24(:,:,460))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(483),h0tab(:,483),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(48),m3h3x8(:,461),heltab2x24(:,:,461))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(484),h0tab(:,484),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(49),m3h3x8(:,462),heltab2x24(:,:,462))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(485),h0tab(:,485),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(53),m3h3x8(:,463),heltab2x24(:,:,463))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(486),h0tab(:,486),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(51),m3h3x8(:,464),heltab2x24(:,:,464))
  Gcoeff(:)%j = (c(207)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(487),h0tab(:,487),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(91),m3h3x8(:,465),heltab2x24(:,:,465))
  Gcoeff(:)%j = (c(207)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(488),h0tab(:,488),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(92),m3h3x8(:,466),heltab2x24(:,:,466))
  Gcoeff(:)%j = (-(c(193)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(489),h0tab(:,489),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(93),m3h3x8(:,467),heltab2x24(:,:,467))
  Gcoeff(:)%j = (c(193)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(490),h0tab(:,490),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(94),m3h3x8(:,468),heltab2x24(:,:,468))
  Gcoeff(:)%j = (c(193)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(491),h0tab(:,491),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(95),m3h3x8(:,469),heltab2x24(:,:,469))
  Gcoeff(:)%j = (c(193)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(492),h0tab(:,492),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(96),m3h3x8(:,470),heltab2x24(:,:,470))
  Gcoeff(:)%j = (-(c(375)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(493),h0tab(:,493),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,38))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(97),ngZl,m3h3x8(:,471),heltab2x24(:,:,471))
  call Hloop_A_Q(ntryL,G0H8(97),16,nML,G1H8(54),n2h8(143))
  Gcoeff(:)%j = (-(c(375)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(494),h0tab(:,494),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,38))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(97),ngZl,m3h3x8(:,472),heltab2x24(:,:,472))
  call Hloop_Q_A(ntryL,G0H8(97),16,nML,G1H8(55),n2h8(144))
  Gcoeff(:)%j = (-(c(378)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(495),h0tab(:,495),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,38))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(97),ngZu,m3h3x8(:,473),heltab2x24(:,:,473))
  call Hloop_A_Q(ntryL,G0H8(97),16,nMT,G1H8(56),n2h8(145))
  Gcoeff(:)%j = (-(c(378)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(496),h0tab(:,496),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,38))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(97),ngZu,m3h3x8(:,474),heltab2x24(:,:,474))
  call Hloop_Q_A(ntryL,G0H8(97),16,nMT,G1H8(57),n2h8(146))
  Gcoeff(:)%j = (-(c(363)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(497),h0tab(:,497),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,38))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(97),ngZd,m3h3x8(:,475),heltab2x24(:,:,475))
  call Hloop_A_Q(ntryL,G0H8(97),16,nMB,G1H8(58),n2h8(147))
  Gcoeff(:)%j = (-(c(363)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(498),h0tab(:,498),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,38))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(97),ngZd,m3h3x8(:,476),heltab2x24(:,:,476))
  call Hloop_Q_A(ntryL,G0H8(97),16,nMB,G1H8(60),n2h8(148))
  Gcoeff(:)%j = (-(c(376)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(499),h0tab(:,499),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,39))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(97),ngZl,m3h3x8(:,477),heltab2x24(:,:,477))
  call Hloop_A_Q(ntryL,G0H8(97),16,nML,G1H8(61),n2h8(149))
  Gcoeff(:)%j = (-(c(376)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(500),h0tab(:,500),[16,3,4,8],[nML,nML,nML,nML],4,1,wf4(:,39))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(97),ngZl,m3h3x8(:,478),heltab2x24(:,:,478))
  call Hloop_Q_A(ntryL,G0H8(97),16,nML,G1H8(62),n2h8(150))
  Gcoeff(:)%j = (c(380)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(501),h0tab(:,501),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,39))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(97),ngZu,m3h3x8(:,479),heltab2x24(:,:,479))
  call Hloop_A_Q(ntryL,G0H8(97),16,nMT,G1H8(163),n2h8(151))
  Gcoeff(:)%j = (c(380)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(502),h0tab(:,502),[16,3,4,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,39))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(97),ngZu,m3h3x8(:,480),heltab2x24(:,:,480))
  call Hloop_Q_A(ntryL,G0H8(97),16,nMT,G1H8(164),n2h8(152))
  Gcoeff(:)%j = (-(c(368)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(503),h0tab(:,503),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,39))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(97),ngZd,m3h3x8(:,481),heltab2x24(:,:,481))
  call Hloop_A_Q(ntryL,G0H8(97),16,nMB,G1H8(165),n2h8(153))
  Gcoeff(:)%j = (-(c(368)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(504),h0tab(:,504),[16,3,4,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,39))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(97),ngZd,m3h3x8(:,482),heltab2x24(:,:,482))
  call Hloop_Q_A(ntryL,G0H8(97),16,nMB,G1H8(166),n2h8(154))
  Gcoeff(:)%j = (c(278)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(505),h0tab(:,505),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(167),m3h3x8(:,483),heltab2x24(:,:,483))
  Gcoeff(:)%j = (c(278)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(506),h0tab(:,506),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(168),m3h3x8(:,484),heltab2x24(:,:,484))
  Gcoeff(:)%j = (-(c(311)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(507),h0tab(:,507),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(169),m3h3x8(:,485),heltab2x24(:,:,485))
  Gcoeff(:)%j = (-(c(311)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(508),h0tab(:,508),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(170),m3h3x8(:,486),heltab2x24(:,:,486))
  Gcoeff(:)%j = (c(185)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(509),h0tab(:,509),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(171),m3h3x8(:,487),heltab2x24(:,:,487))
  Gcoeff(:)%j = (c(185)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(510),h0tab(:,510),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(172),m3h3x8(:,488),heltab2x24(:,:,488))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(511),h0tab(:,511),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(173),m3h3x8(:,489),heltab2x24(:,:,489))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(512),h0tab(:,512),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(174),m3h3x8(:,490),heltab2x24(:,:,490))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(513),h0tab(:,513),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(175),m3h3x8(:,491),heltab2x24(:,:,491))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(514),h0tab(:,514),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(176),m3h3x8(:,492),heltab2x24(:,:,492))
  Gcoeff(:)%j = (c(137)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(515),h0tab(:,515),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(177),m3h3x8(:,493),heltab2x24(:,:,493))
  Gcoeff(:)%j = (c(137)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(516),h0tab(:,516),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(178),m3h3x8(:,494),heltab2x24(:,:,494))
  Gcoeff(:)%j = (c(186)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(517),h0tab(:,517),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(179),m3h3x8(:,495),heltab2x24(:,:,495))
  Gcoeff(:)%j = (c(186)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(518),h0tab(:,518),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(180),m3h3x8(:,496),heltab2x24(:,:,496))
  Gcoeff(:)%j = (-(c(138)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(519),h0tab(:,519),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(181),m3h3x8(:,497),heltab2x24(:,:,497))
  Gcoeff(:)%j = (-(c(138)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(520),h0tab(:,520),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(182),m3h3x8(:,498),heltab2x24(:,:,498))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(521),h0tab(:,521),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(97),m3h3x8(:,499),heltab2x24(:,:,499))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(522),h0tab(:,522),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(98),m3h3x8(:,500),heltab2x24(:,:,500))
  Gcoeff(:)%j = (c(231)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(523),h0tab(:,523),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(99),m3h3x8(:,501),heltab2x24(:,:,501))
  Gcoeff(:)%j = (c(231)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(524),h0tab(:,524),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(100),m3h3x8(:,502),heltab2x24(:,:,502))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(525),h0tab(:,525),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(101),m3h3x8(:,503),heltab2x24(:,:,503))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(526),h0tab(:,526),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(102),m3h3x8(:,504),heltab2x24(:,:,504))
  Gcoeff(:)%j = (c(322)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(527),h0tab(:,527),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(103),m3h3x8(:,505),heltab2x24(:,:,505))
  Gcoeff(:)%j = (c(322)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(528),h0tab(:,528),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(104),m3h3x8(:,506),heltab2x24(:,:,506))
  Gcoeff(:)%j = (-(c(295)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(529),h0tab(:,529),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(183),m3h3x8(:,507),heltab2x24(:,:,507))
  Gcoeff(:)%j = (c(295)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(530),h0tab(:,530),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(184),m3h3x8(:,508),heltab2x24(:,:,508))
  Gcoeff(:)%j = (c(319)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(531),h0tab(:,531),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(185),m3h3x8(:,509),heltab2x24(:,:,509))
  Gcoeff(:)%j = (-(c(319)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(532),h0tab(:,532),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(186),m3h3x8(:,510),heltab2x24(:,:,510))
  Gcoeff(:)%j = (c(295)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(533),h0tab(:,533),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(187),m3h3x8(:,511),heltab2x24(:,:,511))
  Gcoeff(:)%j = (-(c(295)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(534),h0tab(:,534),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(188),m3h3x8(:,512),heltab2x24(:,:,512))
  Gcoeff(:)%j = (-(c(317)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(535),h0tab(:,535),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(189),m3h3x8(:,513),heltab2x24(:,:,513))
  Gcoeff(:)%j = (c(317)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(536),h0tab(:,536),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(190),m3h3x8(:,514),heltab2x24(:,:,514))
  Gcoeff(:)%j = (-(c(197)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(537),h0tab(:,537),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(191),m3h3x8(:,515),heltab2x24(:,:,515))
  Gcoeff(:)%j = (-(c(197)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(538),h0tab(:,538),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(192),m3h3x8(:,516),heltab2x24(:,:,516))
  Gcoeff(:)%j = (-(c(223)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(539),h0tab(:,539),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(193),m3h3x8(:,517),heltab2x24(:,:,517))
  Gcoeff(:)%j = (-(c(223)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(540),h0tab(:,540),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(194),m3h3x8(:,518),heltab2x24(:,:,518))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(541),h0tab(:,541),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(105),m3h3x8(:,519),heltab2x24(:,:,519))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(542),h0tab(:,542),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(106),m3h3x8(:,520),heltab2x24(:,:,520))
  Gcoeff(:)%j = (-(c(215)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(543),h0tab(:,543),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(107),m3h3x8(:,521),heltab2x24(:,:,521))
  Gcoeff(:)%j = (c(215)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(544),h0tab(:,544),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(108),m3h3x8(:,522),heltab2x24(:,:,522))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(545),h0tab(:,545),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(109),m3h3x8(:,523),heltab2x24(:,:,523))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(546),h0tab(:,546),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(110),m3h3x8(:,524),heltab2x24(:,:,524))
  Gcoeff(:)%j = (-(c(235)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(547),h0tab(:,547),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(111),m3h3x8(:,525),heltab2x24(:,:,525))
  Gcoeff(:)%j = (c(235)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(548),h0tab(:,548),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(112),m3h3x8(:,526),heltab2x24(:,:,526))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(549),h0tab(:,549),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(113),m3h3x8(:,527),heltab2x24(:,:,527))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(550),h0tab(:,550),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(114),m3h3x8(:,528),heltab2x24(:,:,528))
  Gcoeff(:)%j = (c(235)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(551),h0tab(:,551),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(115),m3h3x8(:,529),heltab2x24(:,:,529))
  Gcoeff(:)%j = (-(c(235)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(552),h0tab(:,552),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(116),m3h3x8(:,530),heltab2x24(:,:,530))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(553),h0tab(:,553),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(117),m3h3x8(:,531),heltab2x24(:,:,531))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(554),h0tab(:,554),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(118),m3h3x8(:,532),heltab2x24(:,:,532))
  Gcoeff(:)%j = (-(c(319)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(555),h0tab(:,555),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(119),m3h3x8(:,533),heltab2x24(:,:,533))
  Gcoeff(:)%j = (c(319)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(556),h0tab(:,556),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(120),m3h3x8(:,534),heltab2x24(:,:,534))
  Gcoeff(:)%j = (-(c(304)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(557),h0tab(:,557),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(195),m3h3x8(:,535),heltab2x24(:,:,535))
  Gcoeff(:)%j = (-(c(304)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(558),h0tab(:,558),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(196),m3h3x8(:,536),heltab2x24(:,:,536))
  Gcoeff(:)%j = (c(324)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(559),h0tab(:,559),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(197),m3h3x8(:,537),heltab2x24(:,:,537))
  Gcoeff(:)%j = (c(324)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(560),h0tab(:,560),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(198),m3h3x8(:,538),heltab2x24(:,:,538))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(561),h0tab(:,561),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(199),m3h3x8(:,539),heltab2x24(:,:,539))
  Gcoeff(:)%j = (c(185)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(562),h0tab(:,562),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(200),m3h3x8(:,540),heltab2x24(:,:,540))
  Gcoeff(:)%j = (c(137)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(563),h0tab(:,563),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(201),m3h3x8(:,541),heltab2x24(:,:,541))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(564),h0tab(:,564),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(202),m3h3x8(:,542),heltab2x24(:,:,542))
  Gcoeff(:)%j = (c(185)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(565),h0tab(:,565),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(203),m3h3x8(:,543),heltab2x24(:,:,543))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(566),h0tab(:,566),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(204),m3h3x8(:,544),heltab2x24(:,:,544))
  Gcoeff(:)%j = (c(215)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(567),h0tab(:,567),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(205),m3h3x8(:,545),heltab2x24(:,:,545))
  Gcoeff(:)%j = (-(c(215)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(568),h0tab(:,568),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(206),m3h3x8(:,546),heltab2x24(:,:,546))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(569),h0tab(:,569),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(121),m3h3x8(:,547),heltab2x24(:,:,547))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(570),h0tab(:,570),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(122),m3h3x8(:,548),heltab2x24(:,:,548))
  Gcoeff(:)%j = (-(c(225)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(571),h0tab(:,571),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(123),m3h3x8(:,549),heltab2x24(:,:,549))
  Gcoeff(:)%j = (-(c(225)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(572),h0tab(:,572),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(124),m3h3x8(:,550),heltab2x24(:,:,550))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(573),h0tab(:,573),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(125),m3h3x8(:,551),heltab2x24(:,:,551))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(574),h0tab(:,574),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(126),m3h3x8(:,552),heltab2x24(:,:,552))
  Gcoeff(:)%j = (c(236)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(575),h0tab(:,575),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(127),m3h3x8(:,553),heltab2x24(:,:,553))
  Gcoeff(:)%j = (c(236)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(576),h0tab(:,576),[16,3,4,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(128),m3h3x8(:,554),heltab2x24(:,:,554))
  Gcoeff(:)%j = (c(337)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(577),h0tab(:,577),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(129),ngZl,m3h3x8(:,555),heltab2x24(:,:,555))
  call Hloop_Q_A(ntryL,G0H8(129),16,nML,G1H8(207),n2h8(155))
  Gcoeff(:)%j = (c(337)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(578),h0tab(:,578),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(129),ngZl,m3h3x8(:,556),heltab2x24(:,:,556))
  call Hloop_A_Q(ntryL,G0H8(129),16,nML,G1H8(208),n2h8(156))
  Gcoeff(:)%j = (-(c(342)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(579),h0tab(:,579),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(129),ngZu,m3h3x8(:,557),heltab2x24(:,:,557))
  call Hloop_Q_A(ntryL,G0H8(129),16,nMT,G1H8(209),n2h8(157))
  Gcoeff(:)%j = (-(c(342)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(580),h0tab(:,580),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(129),ngZu,m3h3x8(:,558),heltab2x24(:,:,558))
  call Hloop_A_Q(ntryL,G0H8(129),16,nMT,G1H8(210),n2h8(158))
  Gcoeff(:)%j = (c(330)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(581),h0tab(:,581),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(129),ngZd,m3h3x8(:,559),heltab2x24(:,:,559))
  call Hloop_Q_A(ntryL,G0H8(129),16,nMB,G1H8(211),n2h8(159))
  Gcoeff(:)%j = (c(330)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(582),h0tab(:,582),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(129),ngZd,m3h3x8(:,560),heltab2x24(:,:,560))
  call Hloop_A_Q(ntryL,G0H8(129),16,nMB,G1H8(212),n2h8(160))
  Gcoeff(:)%j = (-(c(337)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(583),h0tab(:,583),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,37))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(129),ngZl,m3h3x8(:,561),heltab2x24(:,:,561))
  call Hloop_Q_A(ntryL,G0H8(129),16,nML,G1H8(213),n2h8(161))
  Gcoeff(:)%j = (-(c(337)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(584),h0tab(:,584),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,37))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(129),ngZl,m3h3x8(:,562),heltab2x24(:,:,562))
  call Hloop_A_Q(ntryL,G0H8(129),16,nML,G1H8(214),n2h8(162))
  Gcoeff(:)%j = (-(c(342)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(585),h0tab(:,585),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,37))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(129),ngZu,m3h3x8(:,563),heltab2x24(:,:,563))
  call Hloop_Q_A(ntryL,G0H8(129),16,nMT,G1H8(215),n2h8(163))
  Gcoeff(:)%j = (-(c(342)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(586),h0tab(:,586),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,37))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(129),ngZu,m3h3x8(:,564),heltab2x24(:,:,564))
  call Hloop_A_Q(ntryL,G0H8(129),16,nMT,G1H8(216),n2h8(164))
  Gcoeff(:)%j = (-(c(330)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(587),h0tab(:,587),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,37))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(129),ngZd,m3h3x8(:,565),heltab2x24(:,:,565))
  call Hloop_Q_A(ntryL,G0H8(129),16,nMB,G1H8(217),n2h8(165))
  Gcoeff(:)%j = (-(c(330)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(588),h0tab(:,588),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,37))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(129),ngZd,m3h3x8(:,566),heltab2x24(:,:,566))
  call Hloop_A_Q(ntryL,G0H8(129),16,nMB,G1H8(218),n2h8(166))
  Gcoeff(:)%j = (-(c(251)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(589),h0tab(:,589),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(219),m3h3x8(:,567),heltab2x24(:,:,567))
  Gcoeff(:)%j = (-(c(251)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(590),h0tab(:,590),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(220),m3h3x8(:,568),heltab2x24(:,:,568))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(591),h0tab(:,591),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(221),m3h3x8(:,569),heltab2x24(:,:,569))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(592),h0tab(:,592),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(222),m3h3x8(:,570),heltab2x24(:,:,570))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(593),h0tab(:,593),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(223),m3h3x8(:,571),heltab2x24(:,:,571))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(594),h0tab(:,594),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(224),m3h3x8(:,572),heltab2x24(:,:,572))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(595),h0tab(:,595),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(225),m3h3x8(:,573),heltab2x24(:,:,573))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(596),h0tab(:,596),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(226),m3h3x8(:,574),heltab2x24(:,:,574))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(597),h0tab(:,597),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(227),m3h3x8(:,575),heltab2x24(:,:,575))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(598),h0tab(:,598),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(228),m3h3x8(:,576),heltab2x24(:,:,576))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(599),h0tab(:,599),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(229),m3h3x8(:,577),heltab2x24(:,:,577))
  Gcoeff(:)%j = (c(84)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(600),h0tab(:,600),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(230),m3h3x8(:,578),heltab2x24(:,:,578))
  Gcoeff(:)%j = (c(285)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(601),h0tab(:,601),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(231),m3h3x8(:,579),heltab2x24(:,:,579))
  Gcoeff(:)%j = (-(c(285)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(602),h0tab(:,602),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(232),m3h3x8(:,580),heltab2x24(:,:,580))
  Gcoeff(:)%j = (c(285)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(603),h0tab(:,603),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(233),m3h3x8(:,581),heltab2x24(:,:,581))
  Gcoeff(:)%j = (c(285)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(604),h0tab(:,604),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(234),m3h3x8(:,582),heltab2x24(:,:,582))
  Gcoeff(:)%j = (c(168)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(605),h0tab(:,605),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(129),m3h3x8(:,583),heltab2x24(:,:,583))
  Gcoeff(:)%j = (c(168)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(606),h0tab(:,606),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(130),m3h3x8(:,584),heltab2x24(:,:,584))
  Gcoeff(:)%j = (-(c(268)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(607),h0tab(:,607),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(235),m3h3x8(:,585),heltab2x24(:,:,585))
  Gcoeff(:)%j = (-(c(268)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(608),h0tab(:,608),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(236),m3h3x8(:,586),heltab2x24(:,:,586))
  Gcoeff(:)%j = (c(268)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(609),h0tab(:,609),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(237),m3h3x8(:,587),heltab2x24(:,:,587))
  Gcoeff(:)%j = (-(c(268)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(610),h0tab(:,610),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(238),m3h3x8(:,588),heltab2x24(:,:,588))
  Gcoeff(:)%j = (-(c(165)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(611),h0tab(:,611),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(131),m3h3x8(:,589),heltab2x24(:,:,589))
  Gcoeff(:)%j = (c(165)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(612),h0tab(:,612),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(132),m3h3x8(:,590),heltab2x24(:,:,590))
  Gcoeff(:)%j = (c(165)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(613),h0tab(:,613),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(133),m3h3x8(:,591),heltab2x24(:,:,591))
  Gcoeff(:)%j = (-(c(165)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(614),h0tab(:,614),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(134),m3h3x8(:,592),heltab2x24(:,:,592))
  Gcoeff(:)%j = (c(165)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(615),h0tab(:,615),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(135),m3h3x8(:,593),heltab2x24(:,:,593))
  Gcoeff(:)%j = (c(165)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(616),h0tab(:,616),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(136),m3h3x8(:,594),heltab2x24(:,:,594))
  Gcoeff(:)%j = (c(300)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(617),h0tab(:,617),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(239),m3h3x8(:,595),heltab2x24(:,:,595))
  Gcoeff(:)%j = (-(c(300)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(618),h0tab(:,618),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(240),m3h3x8(:,596),heltab2x24(:,:,596))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(619),h0tab(:,619),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(137),m3h3x8(:,597),heltab2x24(:,:,597))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(620),h0tab(:,620),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(138),m3h3x8(:,598),heltab2x24(:,:,598))
  Gcoeff(:)%j = (-(c(192)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(621),h0tab(:,621),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(139),m3h3x8(:,599),heltab2x24(:,:,599))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(622),h0tab(:,622),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(140),m3h3x8(:,600),heltab2x24(:,:,600))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(623),h0tab(:,623),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(141),m3h3x8(:,601),heltab2x24(:,:,601))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(624),h0tab(:,624),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(142),m3h3x8(:,602),heltab2x24(:,:,602))
  Gcoeff(:)%j = (c(192)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(625),h0tab(:,625),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(143),m3h3x8(:,603),heltab2x24(:,:,603))
  Gcoeff(:)%j = (-(c(192)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(626),h0tab(:,626),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(144),m3h3x8(:,604),heltab2x24(:,:,604))
  Gcoeff(:)%j = (c(54)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(627),h0tab(:,627),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(241),m3h3x8(:,605),heltab2x24(:,:,605))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(628),h0tab(:,628),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(242),m3h3x8(:,606),heltab2x24(:,:,606))
  Gcoeff(:)%j = (-(c(193)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(629),h0tab(:,629),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(145),m3h3x8(:,607),heltab2x24(:,:,607))
  Gcoeff(:)%j = (c(193)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(630),h0tab(:,630),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(146),m3h3x8(:,608),heltab2x24(:,:,608))
  Gcoeff(:)%j = (c(193)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(631),h0tab(:,631),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(147),m3h3x8(:,609),heltab2x24(:,:,609))
  Gcoeff(:)%j = (c(193)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(632),h0tab(:,632),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(148),m3h3x8(:,610),heltab2x24(:,:,610))
  Gcoeff(:)%j = (c(193)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(633),h0tab(:,633),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(149),m3h3x8(:,611),heltab2x24(:,:,611))
  Gcoeff(:)%j = (-(c(193)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(634),h0tab(:,634),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(150),m3h3x8(:,612),heltab2x24(:,:,612))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(635),h0tab(:,635),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(243),m3h3x8(:,613),heltab2x24(:,:,613))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(636),h0tab(:,636),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(244),m3h3x8(:,614),heltab2x24(:,:,614))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(637),h0tab(:,637),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(245),m3h3x8(:,615),heltab2x24(:,:,615))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(638),h0tab(:,638),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(246),m3h3x8(:,616),heltab2x24(:,:,616))
  Gcoeff(:)%j = (c(207)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(639),h0tab(:,639),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(151),m3h3x8(:,617),heltab2x24(:,:,617))
  Gcoeff(:)%j = (c(207)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(640),h0tab(:,640),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(152),m3h3x8(:,618),heltab2x24(:,:,618))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(641),h0tab(:,641),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(247),m3h3x8(:,619),heltab2x24(:,:,619))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(642),h0tab(:,642),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,7))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(248),m3h3x8(:,620),heltab2x24(:,:,620))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(643),h0tab(:,643),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(249),m3h3x8(:,621),heltab2x24(:,:,621))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(644),h0tab(:,644),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,37))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(250),m3h3x8(:,622),heltab2x24(:,:,622))
  Gcoeff(:)%j = (-(c(375)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(645),h0tab(:,645),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,38))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(153),ngZl,m3h3x8(:,623),heltab2x24(:,:,623))
  call Hloop_Q_A(ntryL,G0H8(153),16,nML,G1H8(251),n2h8(167))
  Gcoeff(:)%j = (-(c(375)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(646),h0tab(:,646),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,38))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(153),ngZl,m3h3x8(:,624),heltab2x24(:,:,624))
  call Hloop_A_Q(ntryL,G0H8(153),16,nML,G1H8(252),n2h8(168))
  Gcoeff(:)%j = (-(c(378)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(647),h0tab(:,647),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,38))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(153),ngZu,m3h3x8(:,625),heltab2x24(:,:,625))
  call Hloop_Q_A(ntryL,G0H8(153),16,nMT,G1H8(253),n2h8(169))
  Gcoeff(:)%j = (-(c(378)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(648),h0tab(:,648),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,38))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(153),ngZu,m3h3x8(:,626),heltab2x24(:,:,626))
  call Hloop_A_Q(ntryL,G0H8(153),16,nMT,G1H8(254),n2h8(170))
  Gcoeff(:)%j = (-(c(363)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(649),h0tab(:,649),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,38))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(153),ngZd,m3h3x8(:,627),heltab2x24(:,:,627))
  call Hloop_Q_A(ntryL,G0H8(153),16,nMB,G1H8(255),n2h8(171))
  Gcoeff(:)%j = (-(c(363)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(650),h0tab(:,650),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,38))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(153),ngZd,m3h3x8(:,628),heltab2x24(:,:,628))
  call Hloop_A_Q(ntryL,G0H8(153),16,nMB,G1H8(256),n2h8(172))
  Gcoeff(:)%j = (-(c(376)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(651),h0tab(:,651),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,39))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(153),ngZl,m3h3x8(:,629),heltab2x24(:,:,629))
  call Hloop_Q_A(ntryL,G0H8(153),16,nML,G1H8(257),n2h8(173))
  Gcoeff(:)%j = (-(c(376)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(652),h0tab(:,652),[16,4,3,8],[nML,nML,nML,nML],4,1,wf4(:,39))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(153),ngZl,m3h3x8(:,630),heltab2x24(:,:,630))
  call Hloop_A_Q(ntryL,G0H8(153),16,nML,G1H8(258),n2h8(174))
  Gcoeff(:)%j = (c(380)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(653),h0tab(:,653),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,39))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(153),ngZu,m3h3x8(:,631),heltab2x24(:,:,631))
  call Hloop_Q_A(ntryL,G0H8(153),16,nMT,G1H8(259),n2h8(175))
  Gcoeff(:)%j = (c(380)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(654),h0tab(:,654),[16,4,3,8],[nMT,nMT,nMT,nMT],4,1,wf4(:,39))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(153),ngZu,m3h3x8(:,632),heltab2x24(:,:,632))
  call Hloop_A_Q(ntryL,G0H8(153),16,nMT,G1H8(260),n2h8(176))
  Gcoeff(:)%j = (-(c(368)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(655),h0tab(:,655),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,39))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(153),ngZd,m3h3x8(:,633),heltab2x24(:,:,633))
  call Hloop_Q_A(ntryL,G0H8(153),16,nMB,G1H8(261),n2h8(177))
  Gcoeff(:)%j = (-(c(368)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(656),h0tab(:,656),[16,4,3,8],[nMB,nMB,nMB,nMB],4,1,wf4(:,39))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(153),ngZd,m3h3x8(:,634),heltab2x24(:,:,634))
  call Hloop_A_Q(ntryL,G0H8(153),16,nMB,G1H8(262),n2h8(178))
  Gcoeff(:)%j = (c(278)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(657),h0tab(:,657),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(263),m3h3x8(:,635),heltab2x24(:,:,635))
  Gcoeff(:)%j = (c(278)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(658),h0tab(:,658),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(264),m3h3x8(:,636),heltab2x24(:,:,636))
  Gcoeff(:)%j = (-(c(311)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(659),h0tab(:,659),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(265),m3h3x8(:,637),heltab2x24(:,:,637))
  Gcoeff(:)%j = (-(c(311)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(660),h0tab(:,660),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(266),m3h3x8(:,638),heltab2x24(:,:,638))
  Gcoeff(:)%j = (c(185)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(661),h0tab(:,661),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(267),m3h3x8(:,639),heltab2x24(:,:,639))
  Gcoeff(:)%j = (c(185)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(662),h0tab(:,662),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(268),m3h3x8(:,640),heltab2x24(:,:,640))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(663),h0tab(:,663),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(269),m3h3x8(:,641),heltab2x24(:,:,641))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(664),h0tab(:,664),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(270),m3h3x8(:,642),heltab2x24(:,:,642))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(665),h0tab(:,665),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(271),m3h3x8(:,643),heltab2x24(:,:,643))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(666),h0tab(:,666),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(272),m3h3x8(:,644),heltab2x24(:,:,644))
  Gcoeff(:)%j = (c(137)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(667),h0tab(:,667),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_CV_D(ntryL,G0H24(1),0,ex5(:),16,G1H8(273),m3h3x8(:,645),heltab2x24(:,:,645))
  Gcoeff(:)%j = (c(137)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(668),h0tab(:,668),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_DV_C(ntryL,G0H24(1),0,ex5(:),G1H8(274),m3h3x8(:,646),heltab2x24(:,:,646))
  Gcoeff(:)%j = (c(186)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(669),h0tab(:,669),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(275),m3h3x8(:,647),heltab2x24(:,:,647))
  Gcoeff(:)%j = (c(186)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(670),h0tab(:,670),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(276),m3h3x8(:,648),heltab2x24(:,:,648))
  Gcoeff(:)%j = (-(c(138)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(671),h0tab(:,671),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(277),m3h3x8(:,649),heltab2x24(:,:,649))
  Gcoeff(:)%j = (-(c(138)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(672),h0tab(:,672),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(278),m3h3x8(:,650),heltab2x24(:,:,650))
  Gcoeff(:)%j = (-(c(302)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(673),h0tab(:,673),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(279),m3h3x8(:,651),heltab2x24(:,:,651))
  Gcoeff(:)%j = (-(c(302)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(674),h0tab(:,674),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(280),m3h3x8(:,652),heltab2x24(:,:,652))
  Gcoeff(:)%j = (c(322)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(675),h0tab(:,675),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(281),m3h3x8(:,653),heltab2x24(:,:,653))
  Gcoeff(:)%j = (c(322)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(676),h0tab(:,676),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(282),m3h3x8(:,654),heltab2x24(:,:,654))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(677),h0tab(:,677),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(153),m3h3x8(:,655),heltab2x24(:,:,655))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(678),h0tab(:,678),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(154),m3h3x8(:,656),heltab2x24(:,:,656))
  Gcoeff(:)%j = (c(322)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(679),h0tab(:,679),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(155),m3h3x8(:,657),heltab2x24(:,:,657))
  Gcoeff(:)%j = (c(322)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(680),h0tab(:,680),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(156),m3h3x8(:,658),heltab2x24(:,:,658))
  Gcoeff(:)%j = (-(c(295)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(681),h0tab(:,681),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(283),m3h3x8(:,659),heltab2x24(:,:,659))
  Gcoeff(:)%j = (c(295)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(682),h0tab(:,682),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(284),m3h3x8(:,660),heltab2x24(:,:,660))
  Gcoeff(:)%j = (c(319)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(683),h0tab(:,683),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(285),m3h3x8(:,661),heltab2x24(:,:,661))
  Gcoeff(:)%j = (-(c(319)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(684),h0tab(:,684),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(286),m3h3x8(:,662),heltab2x24(:,:,662))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(685),h0tab(:,685),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(157),m3h3x8(:,663),heltab2x24(:,:,663))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(686),h0tab(:,686),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(158),m3h3x8(:,664),heltab2x24(:,:,664))
  Gcoeff(:)%j = (-(c(319)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(687),h0tab(:,687),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(159),m3h3x8(:,665),heltab2x24(:,:,665))
  Gcoeff(:)%j = (c(319)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(688),h0tab(:,688),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(160),m3h3x8(:,666),heltab2x24(:,:,666))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(689),h0tab(:,689),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(161),m3h3x8(:,667),heltab2x24(:,:,667))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(690),h0tab(:,690),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(162),m3h3x8(:,668),heltab2x24(:,:,668))
  Gcoeff(:)%j = (c(231)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(691),h0tab(:,691),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(163),m3h3x8(:,669),heltab2x24(:,:,669))
  Gcoeff(:)%j = (c(231)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(692),h0tab(:,692),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(164),m3h3x8(:,670),heltab2x24(:,:,670))
  Gcoeff(:)%j = (-(c(295)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(693),h0tab(:,693),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(287),m3h3x8(:,671),heltab2x24(:,:,671))
  Gcoeff(:)%j = (c(295)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(694),h0tab(:,694),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(288),m3h3x8(:,672),heltab2x24(:,:,672))
  Gcoeff(:)%j = (-(c(305)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(695),h0tab(:,695),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(289),m3h3x8(:,673),heltab2x24(:,:,673))
  Gcoeff(:)%j = (c(305)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(696),h0tab(:,696),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(290),m3h3x8(:,674),heltab2x24(:,:,674))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(697),h0tab(:,697),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(165),m3h3x8(:,675),heltab2x24(:,:,675))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(698),h0tab(:,698),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(166),m3h3x8(:,676),heltab2x24(:,:,676))
  Gcoeff(:)%j = (-(c(235)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(699),h0tab(:,699),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(167),m3h3x8(:,677),heltab2x24(:,:,677))
  Gcoeff(:)%j = (c(235)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(700),h0tab(:,700),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(168),m3h3x8(:,678),heltab2x24(:,:,678))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(701),h0tab(:,701),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(169),m3h3x8(:,679),heltab2x24(:,:,679))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(702),h0tab(:,702),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(170),m3h3x8(:,680),heltab2x24(:,:,680))
  Gcoeff(:)%j = (c(235)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(703),h0tab(:,703),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(171),m3h3x8(:,681),heltab2x24(:,:,681))
  Gcoeff(:)%j = (-(c(235)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(704),h0tab(:,704),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(172),m3h3x8(:,682),heltab2x24(:,:,682))
  Gcoeff(:)%j = (c(185)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(705),h0tab(:,705),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(291),m3h3x8(:,683),heltab2x24(:,:,683))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(706),h0tab(:,706),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(292),m3h3x8(:,684),heltab2x24(:,:,684))
  Gcoeff(:)%j = (c(305)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(707),h0tab(:,707),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(293),m3h3x8(:,685),heltab2x24(:,:,685))
  Gcoeff(:)%j = (-(c(305)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(708),h0tab(:,708),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(294),m3h3x8(:,686),heltab2x24(:,:,686))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(709),h0tab(:,709),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(173),m3h3x8(:,687),heltab2x24(:,:,687))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(710),h0tab(:,710),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(174),m3h3x8(:,688),heltab2x24(:,:,688))
  Gcoeff(:)%j = (c(236)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(711),h0tab(:,711),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(175),m3h3x8(:,689),heltab2x24(:,:,689))
  Gcoeff(:)%j = (c(236)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(712),h0tab(:,712),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(176),m3h3x8(:,690),heltab2x24(:,:,690))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(713),h0tab(:,713),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(177),m3h3x8(:,691),heltab2x24(:,:,691))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(714),h0tab(:,714),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(178),m3h3x8(:,692),heltab2x24(:,:,692))
  Gcoeff(:)%j = (-(c(215)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(715),h0tab(:,715),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(179),m3h3x8(:,693),heltab2x24(:,:,693))
  Gcoeff(:)%j = (c(215)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(716),h0tab(:,716),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(180),m3h3x8(:,694),heltab2x24(:,:,694))
  Gcoeff(:)%j = (c(185)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(717),h0tab(:,717),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(295),m3h3x8(:,695),heltab2x24(:,:,695))
  Gcoeff(:)%j = (-(c(185)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(718),h0tab(:,718),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(296),m3h3x8(:,696),heltab2x24(:,:,696))
  Gcoeff(:)%j = (c(215)*M(1,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(719),h0tab(:,719),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(297),m3h3x8(:,697),heltab2x24(:,:,697))
  Gcoeff(:)%j = (-(c(215)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(720),h0tab(:,720),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(298),m3h3x8(:,698),heltab2x24(:,:,698))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(721),h0tab(:,721),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(181),m3h3x8(:,699),heltab2x24(:,:,699))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(722),h0tab(:,722),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(182),m3h3x8(:,700),heltab2x24(:,:,700))
  Gcoeff(:)%j = (-(c(225)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(723),h0tab(:,723),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(183),m3h3x8(:,701),heltab2x24(:,:,701))
  Gcoeff(:)%j = (-(c(225)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(724),h0tab(:,724),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(184),m3h3x8(:,702),heltab2x24(:,:,702))
  Gcoeff(:)%j = (-(c(205)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(725),h0tab(:,725),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(299),m3h3x8(:,703),heltab2x24(:,:,703))
  Gcoeff(:)%j = (-(c(205)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(726),h0tab(:,726),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,38))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(300),m3h3x8(:,704),heltab2x24(:,:,704))
  Gcoeff(:)%j = (-(c(225)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(727),h0tab(:,727),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(301),m3h3x8(:,705),heltab2x24(:,:,705))
  Gcoeff(:)%j = (-(c(225)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(728),h0tab(:,728),[16,4,3,8],[nMW,nMW,nMW,nMW],4,1,wf4(:,39))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(302),m3h3x8(:,706),heltab2x24(:,:,706))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(729),h0tab(:,729),[16,2,8,5],[nMH,nMB,nMB,nMZ],4,1,wf2(:,2))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(303),m3h3x8(:,707),heltab2x24(:,:,707))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(730),h0tab(:,730),[16,2,8,5],[nMZ,nMB,nMB,nMH],4,1,wf2(:,2))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(304),m3h3x8(:,708),heltab2x24(:,:,708))
  Gcoeff(:)%j = (c(238)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(731),h0tab(:,731),[16,2,8,5],[nMW,nMT,nMT,nMW],4,1,wf2(:,2))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(305),m3h3x8(:,709),heltab2x24(:,:,709))
  Gcoeff(:)%j = (-(c(87)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(732),h0tab(:,732),[16,2,8,5],[nMT,nMW,nMW,nMT],4,1,wf2(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(185),ngZu,m3h3x8(:,710),heltab2x24(:,:,710))
  call Hloop_Q_A(ntryL,G0H8(185),16,nMT,G1H8(306),n2h8(179))
  Gcoeff(:)%j = (-(c(112)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(733),h0tab(:,733),[16,2,8,5],[nMH,nMB,nMB,nMZ],4,1,wf2(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(185),m3h3x8(:,711),heltab2x24(:,:,711))
  Gcoeff(:)%j = (-(c(156)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(734),h0tab(:,734),[16,2,8,5],[nMW,nMT,nMT,nMW],4,1,wf2(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(186),m3h3x8(:,712),heltab2x24(:,:,712))
  Gcoeff(:)%j = (-(c(112)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(735),h0tab(:,735),[16,2,8,5],[nMZ,nMB,nMB,nMH],4,1,wf2(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(187),m3h3x8(:,713),heltab2x24(:,:,713))
  Gcoeff(:)%j = (c(156)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(736),h0tab(:,736),[16,2,8,5],[nMW,nMT,nMT,nMW],4,1,wf2(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(188),m3h3x8(:,714),heltab2x24(:,:,714))
  Gcoeff(:)%j = (c(108)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(737),h0tab(:,737),[16,2,8,5],[nMT,nMW,nMW,nMT],4,1,wf2(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(189),ngZu,m3h3x8(:,715),heltab2x24(:,:,715))
  call Hloop_Q_A(ntryL,G0H8(189),16,nMT,G1H8(307),n2h8(180))
  Gcoeff(:)%j = (-(c(108)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(738),h0tab(:,738),[16,2,8,5],[nMT,nMW,nMW,nMT],4,1,wf2(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(189),ngZu,m3h3x8(:,716),heltab2x24(:,:,716))
  call Hloop_Q_A(ntryL,G0H8(189),16,nMT,G1H8(308),n2h8(181))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(739),h0tab(:,739),[16,2,8,5],[nMW,nMT,nMT,nMW],4,1,wf2(:,2))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(309),m3h3x8(:,717),heltab2x24(:,:,717))
  Gcoeff(:)%j = (-(c(108)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(740),h0tab(:,740),[16,2,8,5],[nMT,nMW,nMW,nMT],4,1,wf2(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(189),ngZu,m3h3x8(:,718),heltab2x24(:,:,718))
  call Hloop_Q_A(ntryL,G0H8(189),16,nMT,G1H8(310),n2h8(182))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(741),h0tab(:,741),[16,5,2,8],[nMB,nMH,nMB,nMB],4,1,wf2(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(189),ngZd,m3h3x8(:,719),heltab2x24(:,:,719))
  call Hloop_A_Q(ntryL,G0H8(189),16,nMB,G1H8(311),n2h8(183))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(742),h0tab(:,742),[16,5,2,8],[nMB,nMZ,nMB,nMB],4,1,wf2(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(189),ngZd,m3h3x8(:,720),heltab2x24(:,:,720))
  call Hloop_A_Q(ntryL,G0H8(189),16,nMB,G1H8(312),n2h8(184))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(743),h0tab(:,743),[16,5,2,8],[nMT,nMW,nMT,nMT],4,1,wf2(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(189),ngZu,m3h3x8(:,721),heltab2x24(:,:,721))
  call Hloop_A_Q(ntryL,G0H8(189),16,nMT,G1H8(313),n2h8(185))
  Gcoeff(:)%j = (c(239)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(744),h0tab(:,744),[16,5,2,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,2))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(314),m3h3x8(:,722),heltab2x24(:,:,722))
  Gcoeff(:)%j = (c(208)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(745),h0tab(:,745),[16,5,2,8],[nMB,0,nMB,nMB],4,1,wf2(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(189),ngZd,m3h3x8(:,723),heltab2x24(:,:,723))
  call Hloop_A_Q(ntryL,G0H8(189),16,nMB,G1H8(315),n2h8(186))
  Gcoeff(:)%j = (c(209)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(746),h0tab(:,746),[16,5,2,8],[nMB,nMZ,nMB,nMB],4,1,wf2(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(189),ngZd,m3h3x8(:,724),heltab2x24(:,:,724))
  call Hloop_A_Q(ntryL,G0H8(189),16,nMB,G1H8(316),n2h8(187))
  Gcoeff(:)%j = (-(c(107)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(747),h0tab(:,747),[16,5,2,8],[nMT,nMW,nMT,nMT],4,1,wf2(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(189),ngZu,m3h3x8(:,725),heltab2x24(:,:,725))
  call Hloop_A_Q(ntryL,G0H8(189),16,nMT,G1H8(317),n2h8(188))
  Gcoeff(:)%j = (c(210)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(748),h0tab(:,748),[16,5,2,8],[nMB,0,nMB,nMB],4,1,wf2(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(189),ngZd,m3h3x8(:,726),heltab2x24(:,:,726))
  call Hloop_A_Q(ntryL,G0H8(189),16,nMB,G1H8(318),n2h8(189))
  Gcoeff(:)%j = (-(c(157)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(749),h0tab(:,749),[16,5,2,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(189),m3h3x8(:,727),heltab2x24(:,:,727))
  Gcoeff(:)%j = (-(c(157)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(750),h0tab(:,750),[16,5,2,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(190),m3h3x8(:,728),heltab2x24(:,:,728))
  Gcoeff(:)%j = (c(269)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(751),h0tab(:,751),[16,5,2,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,2))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(319),m3h3x8(:,729),heltab2x24(:,:,729))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(752),h0tab(:,752),[16,5,2,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,2))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(320),m3h3x8(:,730),heltab2x24(:,:,730))
  Gcoeff(:)%j = (-(c(193)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(753),h0tab(:,753),[16,5,2,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(191),m3h3x8(:,731),heltab2x24(:,:,731))
  Gcoeff(:)%j = (c(157)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(754),h0tab(:,754),[16,5,2,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(192),m3h3x8(:,732),heltab2x24(:,:,732))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(755),h0tab(:,755),[16,5,2,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,2))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(321),m3h3x8(:,733),heltab2x24(:,:,733))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(756),h0tab(:,756),[16,2,5,8],[nMB,nMH,nMB,nMB],4,1,wf2(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(193),ngZd,m3h3x8(:,734),heltab2x24(:,:,734))
  call Hloop_Q_A(ntryL,G0H8(193),16,nMB,G1H8(322),n2h8(190))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(757),h0tab(:,757),[16,2,5,8],[nMB,nMZ,nMB,nMB],4,1,wf2(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(193),ngZd,m3h3x8(:,735),heltab2x24(:,:,735))
  call Hloop_Q_A(ntryL,G0H8(193),16,nMB,G1H8(323),n2h8(191))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(758),h0tab(:,758),[16,2,5,8],[nMT,nMW,nMT,nMT],4,1,wf2(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(193),ngZu,m3h3x8(:,736),heltab2x24(:,:,736))
  call Hloop_Q_A(ntryL,G0H8(193),16,nMT,G1H8(324),n2h8(192))
  Gcoeff(:)%j = (c(239)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(759),h0tab(:,759),[16,2,5,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,2))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(325),m3h3x8(:,737),heltab2x24(:,:,737))
  Gcoeff(:)%j = (c(208)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(760),h0tab(:,760),[16,2,5,8],[nMB,0,nMB,nMB],4,1,wf2(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(193),ngZd,m3h3x8(:,738),heltab2x24(:,:,738))
  call Hloop_Q_A(ntryL,G0H8(193),16,nMB,G1H8(326),n2h8(193))
  Gcoeff(:)%j = (c(209)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(761),h0tab(:,761),[16,2,5,8],[nMB,nMZ,nMB,nMB],4,1,wf2(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(193),ngZd,m3h3x8(:,739),heltab2x24(:,:,739))
  call Hloop_Q_A(ntryL,G0H8(193),16,nMB,G1H8(327),n2h8(194))
  Gcoeff(:)%j = (-(c(107)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(762),h0tab(:,762),[16,2,5,8],[nMT,nMW,nMT,nMT],4,1,wf2(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(193),ngZu,m3h3x8(:,740),heltab2x24(:,:,740))
  call Hloop_Q_A(ntryL,G0H8(193),16,nMT,G1H8(328),n2h8(195))
  Gcoeff(:)%j = (c(210)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(763),h0tab(:,763),[16,2,5,8],[nMB,0,nMB,nMB],4,1,wf2(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(193),ngZd,m3h3x8(:,741),heltab2x24(:,:,741))
  call Hloop_Q_A(ntryL,G0H8(193),16,nMB,G1H8(329),n2h8(196))
  Gcoeff(:)%j = (-(c(269)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(764),h0tab(:,764),[16,2,5,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,2))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(330),m3h3x8(:,742),heltab2x24(:,:,742))
  Gcoeff(:)%j = (-(c(157)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(765),h0tab(:,765),[16,2,5,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(193),m3h3x8(:,743),heltab2x24(:,:,743))
  Gcoeff(:)%j = (c(157)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(766),h0tab(:,766),[16,2,5,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(194),m3h3x8(:,744),heltab2x24(:,:,744))
  Gcoeff(:)%j = (-(c(157)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(767),h0tab(:,767),[16,2,5,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(195),m3h3x8(:,745),heltab2x24(:,:,745))
  Gcoeff(:)%j = (-(c(193)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(768),h0tab(:,768),[16,2,5,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(196),m3h3x8(:,746),heltab2x24(:,:,746))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(769),h0tab(:,769),[16,2,5,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,2))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(331),m3h3x8(:,747),heltab2x24(:,:,747))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(770),h0tab(:,770),[16,2,5,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,2))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(332),m3h3x8(:,748),heltab2x24(:,:,748))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(771),h0tab(:,771),[16,1,8,6],[nMH,nMB,nMB,nMZ],4,1,wf2(:,4))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(333),m3h3x8(:,749),heltab2x24(:,:,749))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(772),h0tab(:,772),[16,1,8,6],[nMZ,nMB,nMB,nMH],4,1,wf2(:,4))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(334),m3h3x8(:,750),heltab2x24(:,:,750))
  Gcoeff(:)%j = (c(238)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(773),h0tab(:,773),[16,1,8,6],[nMW,nMT,nMT,nMW],4,1,wf2(:,4))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(335),m3h3x8(:,751),heltab2x24(:,:,751))
  Gcoeff(:)%j = (-(c(87)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(774),h0tab(:,774),[16,1,8,6],[nMT,nMW,nMW,nMT],4,1,wf2(:,4))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(197),ngZu,m3h3x8(:,752),heltab2x24(:,:,752))
  call Hloop_A_Q(ntryL,G0H8(197),16,nMT,G1H8(336),n2h8(197))
  Gcoeff(:)%j = (-(c(112)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(775),h0tab(:,775),[16,1,8,6],[nMH,nMB,nMB,nMZ],4,1,wf2(:,4))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(197),m3h3x8(:,753),heltab2x24(:,:,753))
  Gcoeff(:)%j = (c(156)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(776),h0tab(:,776),[16,1,8,6],[nMW,nMT,nMT,nMW],4,1,wf2(:,4))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(198),m3h3x8(:,754),heltab2x24(:,:,754))
  Gcoeff(:)%j = (-(c(112)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(777),h0tab(:,777),[16,1,8,6],[nMZ,nMB,nMB,nMH],4,1,wf2(:,4))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(199),m3h3x8(:,755),heltab2x24(:,:,755))
  Gcoeff(:)%j = (-(c(156)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(778),h0tab(:,778),[16,1,8,6],[nMW,nMT,nMT,nMW],4,1,wf2(:,4))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(200),m3h3x8(:,756),heltab2x24(:,:,756))
  Gcoeff(:)%j = (-(c(108)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(779),h0tab(:,779),[16,1,8,6],[nMT,nMW,nMW,nMT],4,1,wf2(:,4))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(201),ngZu,m3h3x8(:,757),heltab2x24(:,:,757))
  call Hloop_A_Q(ntryL,G0H8(201),16,nMT,G1H8(337),n2h8(198))
  Gcoeff(:)%j = (c(108)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(780),h0tab(:,780),[16,1,8,6],[nMT,nMW,nMW,nMT],4,1,wf2(:,4))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(201),ngZu,m3h3x8(:,758),heltab2x24(:,:,758))
  call Hloop_A_Q(ntryL,G0H8(201),16,nMT,G1H8(338),n2h8(199))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(781),h0tab(:,781),[16,1,8,6],[nMW,nMT,nMT,nMW],4,1,wf2(:,4))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(339),m3h3x8(:,759),heltab2x24(:,:,759))
  Gcoeff(:)%j = (-(c(108)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(782),h0tab(:,782),[16,1,8,6],[nMT,nMW,nMW,nMT],4,1,wf2(:,4))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(201),ngZu,m3h3x8(:,760),heltab2x24(:,:,760))
  call Hloop_A_Q(ntryL,G0H8(201),16,nMT,G1H8(340),n2h8(200))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(783),h0tab(:,783),[16,6,1,8],[nMB,nMH,nMB,nMB],4,1,wf2(:,4))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(201),ngZd,m3h3x8(:,761),heltab2x24(:,:,761))
  call Hloop_Q_A(ntryL,G0H8(201),16,nMB,G1H8(341),n2h8(201))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(784),h0tab(:,784),[16,6,1,8],[nMB,nMZ,nMB,nMB],4,1,wf2(:,4))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(201),ngZd,m3h3x8(:,762),heltab2x24(:,:,762))
  call Hloop_Q_A(ntryL,G0H8(201),16,nMB,G1H8(342),n2h8(202))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(785),h0tab(:,785),[16,6,1,8],[nMT,nMW,nMT,nMT],4,1,wf2(:,4))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(201),ngZu,m3h3x8(:,763),heltab2x24(:,:,763))
  call Hloop_Q_A(ntryL,G0H8(201),16,nMT,G1H8(343),n2h8(203))
  Gcoeff(:)%j = (c(239)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(786),h0tab(:,786),[16,6,1,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,4))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(344),m3h3x8(:,764),heltab2x24(:,:,764))
  Gcoeff(:)%j = (c(208)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(787),h0tab(:,787),[16,6,1,8],[nMB,0,nMB,nMB],4,1,wf2(:,4))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(201),ngZd,m3h3x8(:,765),heltab2x24(:,:,765))
  call Hloop_Q_A(ntryL,G0H8(201),16,nMB,G1H8(345),n2h8(204))
  Gcoeff(:)%j = (c(209)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(788),h0tab(:,788),[16,6,1,8],[nMB,nMZ,nMB,nMB],4,1,wf2(:,4))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(201),ngZd,m3h3x8(:,766),heltab2x24(:,:,766))
  call Hloop_Q_A(ntryL,G0H8(201),16,nMB,G1H8(346),n2h8(205))
  Gcoeff(:)%j = (-(c(107)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(789),h0tab(:,789),[16,6,1,8],[nMT,nMW,nMT,nMT],4,1,wf2(:,4))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(201),ngZu,m3h3x8(:,767),heltab2x24(:,:,767))
  call Hloop_Q_A(ntryL,G0H8(201),16,nMT,G1H8(347),n2h8(206))
  Gcoeff(:)%j = (c(210)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(790),h0tab(:,790),[16,6,1,8],[nMB,0,nMB,nMB],4,1,wf2(:,4))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(201),ngZd,m3h3x8(:,768),heltab2x24(:,:,768))
  call Hloop_Q_A(ntryL,G0H8(201),16,nMB,G1H8(348),n2h8(207))
  Gcoeff(:)%j = (c(157)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(791),h0tab(:,791),[16,6,1,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,4))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(201),m3h3x8(:,769),heltab2x24(:,:,769))
  Gcoeff(:)%j = (-(c(157)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(792),h0tab(:,792),[16,6,1,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,4))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(202),m3h3x8(:,770),heltab2x24(:,:,770))
  Gcoeff(:)%j = (-(c(269)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(793),h0tab(:,793),[16,6,1,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,4))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(349),m3h3x8(:,771),heltab2x24(:,:,771))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(794),h0tab(:,794),[16,6,1,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,4))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(350),m3h3x8(:,772),heltab2x24(:,:,772))
  Gcoeff(:)%j = (-(c(193)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(795),h0tab(:,795),[16,6,1,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,4))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(203),m3h3x8(:,773),heltab2x24(:,:,773))
  Gcoeff(:)%j = (-(c(157)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(796),h0tab(:,796),[16,6,1,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,4))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(204),m3h3x8(:,774),heltab2x24(:,:,774))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(797),h0tab(:,797),[16,6,1,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,4))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(351),m3h3x8(:,775),heltab2x24(:,:,775))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(798),h0tab(:,798),[16,1,6,8],[nMB,nMH,nMB,nMB],4,1,wf2(:,4))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(205),ngZd,m3h3x8(:,776),heltab2x24(:,:,776))
  call Hloop_A_Q(ntryL,G0H8(205),16,nMB,G1H8(352),n2h8(208))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(799),h0tab(:,799),[16,1,6,8],[nMB,nMZ,nMB,nMB],4,1,wf2(:,4))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(205),ngZd,m3h3x8(:,777),heltab2x24(:,:,777))
  call Hloop_A_Q(ntryL,G0H8(205),16,nMB,G1H8(353),n2h8(209))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(800),h0tab(:,800),[16,1,6,8],[nMT,nMW,nMT,nMT],4,1,wf2(:,4))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(205),ngZu,m3h3x8(:,778),heltab2x24(:,:,778))
  call Hloop_A_Q(ntryL,G0H8(205),16,nMT,G1H8(354),n2h8(210))
  Gcoeff(:)%j = (c(239)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(801),h0tab(:,801),[16,1,6,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,4))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(355),m3h3x8(:,779),heltab2x24(:,:,779))
  Gcoeff(:)%j = (c(208)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(802),h0tab(:,802),[16,1,6,8],[nMB,0,nMB,nMB],4,1,wf2(:,4))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(205),ngZd,m3h3x8(:,780),heltab2x24(:,:,780))
  call Hloop_A_Q(ntryL,G0H8(205),16,nMB,G1H8(356),n2h8(211))
  Gcoeff(:)%j = (c(209)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(803),h0tab(:,803),[16,1,6,8],[nMB,nMZ,nMB,nMB],4,1,wf2(:,4))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(205),ngZd,m3h3x8(:,781),heltab2x24(:,:,781))
  call Hloop_A_Q(ntryL,G0H8(205),16,nMB,G1H8(357),n2h8(212))
  Gcoeff(:)%j = (-(c(107)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(804),h0tab(:,804),[16,1,6,8],[nMT,nMW,nMT,nMT],4,1,wf2(:,4))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(205),ngZu,m3h3x8(:,782),heltab2x24(:,:,782))
  call Hloop_A_Q(ntryL,G0H8(205),16,nMT,G1H8(358),n2h8(213))
  Gcoeff(:)%j = (c(210)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(805),h0tab(:,805),[16,1,6,8],[nMB,0,nMB,nMB],4,1,wf2(:,4))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(205),ngZd,m3h3x8(:,783),heltab2x24(:,:,783))
  call Hloop_A_Q(ntryL,G0H8(205),16,nMB,G1H8(359),n2h8(214))
  Gcoeff(:)%j = (c(269)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(806),h0tab(:,806),[16,1,6,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,4))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(360),m3h3x8(:,784),heltab2x24(:,:,784))
  Gcoeff(:)%j = (-(c(157)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(807),h0tab(:,807),[16,1,6,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,4))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(205),m3h3x8(:,785),heltab2x24(:,:,785))
  Gcoeff(:)%j = (-(c(157)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(808),h0tab(:,808),[16,1,6,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,4))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(206),m3h3x8(:,786),heltab2x24(:,:,786))
  Gcoeff(:)%j = (c(157)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(809),h0tab(:,809),[16,1,6,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,4))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(207),m3h3x8(:,787),heltab2x24(:,:,787))
  Gcoeff(:)%j = (-(c(193)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(810),h0tab(:,810),[16,1,6,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,4))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(208),m3h3x8(:,788),heltab2x24(:,:,788))
  Gcoeff(:)%j = (c(47)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(811),h0tab(:,811),[16,1,6,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,4))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(361),m3h3x8(:,789),heltab2x24(:,:,789))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(812),h0tab(:,812),[16,1,6,8],[nMW,nMT,nMW,nMW],4,1,wf2(:,4))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(362),m3h3x8(:,790),heltab2x24(:,:,790))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(813),h0tab(:,813),[16,2,4,9],[nMH,nMB,nMB,nMZ],4,1,wf4(:,5))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(363),m3h3x8(:,791),heltab2x24(:,:,791))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(814),h0tab(:,814),[16,2,4,9],[nMZ,nMB,nMB,nMH],4,1,wf4(:,5))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(364),m3h3x8(:,792),heltab2x24(:,:,792))
  Gcoeff(:)%j = (-(c(255)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(815),h0tab(:,815),[16,2,4,9],[nMW,nMT,nMT,nMW],4,1,wf4(:,5))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(365),m3h3x8(:,793),heltab2x24(:,:,793))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(816),h0tab(:,816),[16,2,4,9],[nMB,nMH,nMH,nMB],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(209),ngZd,m3h3x8(:,794),heltab2x24(:,:,794))
  call Hloop_Q_A(ntryL,G0H8(209),16,nMB,G1H8(366),n2h8(215))
  Gcoeff(:)%j = (c(93)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(817),h0tab(:,817),[16,2,4,9],[nMB,nMZ,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(209),ngZd,m3h3x8(:,795),heltab2x24(:,:,795))
  call Hloop_Q_A(ntryL,G0H8(209),16,nMB,G1H8(367),n2h8(216))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(818),h0tab(:,818),[16,2,4,9],[nMT,nMW,nMW,nMT],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(209),ngZu,m3h3x8(:,796),heltab2x24(:,:,796))
  call Hloop_Q_A(ntryL,G0H8(209),16,nMT,G1H8(368),n2h8(217))
  Gcoeff(:)%j = (-(c(112)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(819),h0tab(:,819),[16,2,4,9],[nMH,nMB,nMB,nMZ],4,1,wf4(:,5))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(209),m3h3x8(:,797),heltab2x24(:,:,797))
  Gcoeff(:)%j = (c(170)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(820),h0tab(:,820),[16,2,4,9],[nMW,nMT,nMT,nMW],4,1,wf4(:,5))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(210),m3h3x8(:,798),heltab2x24(:,:,798))
  Gcoeff(:)%j = (-(c(112)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(821),h0tab(:,821),[16,2,4,9],[nMZ,nMB,nMB,nMH],4,1,wf4(:,5))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(211),m3h3x8(:,799),heltab2x24(:,:,799))
  Gcoeff(:)%j = (-(c(170)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(822),h0tab(:,822),[16,2,4,9],[nMW,nMT,nMT,nMW],4,1,wf4(:,5))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(212),m3h3x8(:,800),heltab2x24(:,:,800))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(823),h0tab(:,823),[16,2,4,9],[nMB,nMZ,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(213),ngZd,m3h3x8(:,801),heltab2x24(:,:,801))
  call Hloop_Q_A(ntryL,G0H8(213),16,nMB,G1H8(369),n2h8(218))
  Gcoeff(:)%j = (c(99)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(824),h0tab(:,824),[16,2,4,9],[nMT,nMW,nMW,nMT],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(213),ngZu,m3h3x8(:,802),heltab2x24(:,:,802))
  call Hloop_Q_A(ntryL,G0H8(213),16,nMT,G1H8(370),n2h8(219))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(825),h0tab(:,825),[16,2,4,9],[nMB,nMZ,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(213),ngZd,m3h3x8(:,803),heltab2x24(:,:,803))
  call Hloop_Q_A(ntryL,G0H8(213),16,nMB,G1H8(371),n2h8(220))
  Gcoeff(:)%j = (c(99)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(826),h0tab(:,826),[16,2,4,9],[nMT,nMW,nMW,nMT],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(213),ngZu,m3h3x8(:,804),heltab2x24(:,:,804))
  call Hloop_Q_A(ntryL,G0H8(213),16,nMT,G1H8(372),n2h8(221))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(827),h0tab(:,827),[16,2,4,9],[nMW,nMT,nMT,nMW],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(373),m3h3x8(:,805),heltab2x24(:,:,805))
  Gcoeff(:)%j = (c(219)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(828),h0tab(:,828),[16,2,4,9],[nMB,nMZ,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(213),ngZd,m3h3x8(:,806),heltab2x24(:,:,806))
  call Hloop_Q_A(ntryL,G0H8(213),16,nMB,G1H8(374),n2h8(222))
  Gcoeff(:)%j = (c(124)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(829),h0tab(:,829),[16,2,4,9],[nMT,nMW,nMW,nMT],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(213),ngZu,m3h3x8(:,807),heltab2x24(:,:,807))
  call Hloop_Q_A(ntryL,G0H8(213),16,nMT,G1H8(375),n2h8(223))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(830),h0tab(:,830),[16,4,2,9],[nMB,nMB,nMH,nMB],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(213),ngZd,m3h3x8(:,808),heltab2x24(:,:,808))
  call Hloop_Q_A(ntryL,G0H8(213),16,nMB,G1H8(376),n2h8(224))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(831),h0tab(:,831),[16,4,2,9],[nMB,nMB,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(213),ngZd,m3h3x8(:,809),heltab2x24(:,:,809))
  call Hloop_Q_A(ntryL,G0H8(213),16,nMB,G1H8(377),n2h8(225))
  Gcoeff(:)%j = (c(96)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(832),h0tab(:,832),[16,4,2,9],[nMT,nMT,nMW,nMT],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(213),ngZu,m3h3x8(:,810),heltab2x24(:,:,810))
  call Hloop_Q_A(ntryL,G0H8(213),16,nMT,G1H8(378),n2h8(226))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(833),h0tab(:,833),[16,4,2,9],[nMH,nMH,nMB,nMZ],4,1,wf4(:,5))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(379),m3h3x8(:,811),heltab2x24(:,:,811))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(834),h0tab(:,834),[16,4,2,9],[nMZ,nMZ,nMB,nMH],4,1,wf4(:,5))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(380),m3h3x8(:,812),heltab2x24(:,:,812))
  Gcoeff(:)%j = (-(c(241)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(835),h0tab(:,835),[16,4,2,9],[nMW,nMW,nMT,nMW],4,1,wf4(:,5))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(381),m3h3x8(:,813),heltab2x24(:,:,813))
  Gcoeff(:)%j = (c(208)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(836),h0tab(:,836),[16,4,2,9],[nMB,nMB,0,nMB],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(213),ngZd,m3h3x8(:,814),heltab2x24(:,:,814))
  call Hloop_Q_A(ntryL,G0H8(213),16,nMB,G1H8(382),n2h8(227))
  Gcoeff(:)%j = (c(209)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(837),h0tab(:,837),[16,4,2,9],[nMB,nMB,nMZ,nMB],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(213),ngZd,m3h3x8(:,815),heltab2x24(:,:,815))
  call Hloop_Q_A(ntryL,G0H8(213),16,nMB,G1H8(383),n2h8(228))
  Gcoeff(:)%j = (c(120)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(838),h0tab(:,838),[16,4,2,9],[nMT,nMT,nMW,nMT],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(213),ngZu,m3h3x8(:,816),heltab2x24(:,:,816))
  call Hloop_Q_A(ntryL,G0H8(213),16,nMT,G1H8(384),n2h8(229))
  Gcoeff(:)%j = (c(210)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(839),h0tab(:,839),[16,4,2,9],[nMB,nMB,0,nMB],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(213),ngZd,m3h3x8(:,817),heltab2x24(:,:,817))
  call Hloop_Q_A(ntryL,G0H8(213),16,nMB,G1H8(385),n2h8(230))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(840),h0tab(:,840),[16,4,2,9],[nMH,nMH,nMB,nMZ],4,1,wf4(:,5))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(213),m3h3x8(:,818),heltab2x24(:,:,818))
  Gcoeff(:)%j = (c(161)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(841),h0tab(:,841),[16,4,2,9],[nMW,nMW,nMT,nMW],4,1,wf4(:,5))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(214),m3h3x8(:,819),heltab2x24(:,:,819))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(842),h0tab(:,842),[16,4,2,9],[nMZ,nMZ,nMB,nMH],4,1,wf4(:,5))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(215),m3h3x8(:,820),heltab2x24(:,:,820))
  Gcoeff(:)%j = (-(c(149)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(843),h0tab(:,843),[16,4,2,9],[nMW,nMW,nMT,nMW],4,1,wf4(:,5))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(216),m3h3x8(:,821),heltab2x24(:,:,821))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(844),h0tab(:,844),[16,4,2,9],[nMZ,nMZ,nMB,nMH],4,1,wf4(:,5))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(386),m3h3x8(:,822),heltab2x24(:,:,822))
  Gcoeff(:)%j = (-(c(263)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(845),h0tab(:,845),[16,4,2,9],[nMW,nMW,nMT,nMW],4,1,wf4(:,5))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(387),m3h3x8(:,823),heltab2x24(:,:,823))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(846),h0tab(:,846),[16,4,2,9],[nMW,nMW,nMT,nMW],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(388),m3h3x8(:,824),heltab2x24(:,:,824))
  Gcoeff(:)%j = (c(177)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(847),h0tab(:,847),[16,4,2,9],[nMW,nMW,nMT,nMW],4,1,wf4(:,5))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(217),m3h3x8(:,825),heltab2x24(:,:,825))
  Gcoeff(:)%j = (-(c(142)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(848),h0tab(:,848),[16,4,2,9],[nMZ,nMZ,nMB,nMH],4,1,wf4(:,5))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(218),m3h3x8(:,826),heltab2x24(:,:,826))
  Gcoeff(:)%j = (-(c(179)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(849),h0tab(:,849),[16,4,2,9],[nMW,nMW,nMT,nMW],4,1,wf4(:,5))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(219),m3h3x8(:,827),heltab2x24(:,:,827))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(850),h0tab(:,850),[16,4,2,9],[nMW,nMW,nMT,nMW],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(389),m3h3x8(:,828),heltab2x24(:,:,828))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(851),h0tab(:,851),[16,2,9,4],[nMB,nMH,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(220),ngZd,m3h3x8(:,829),heltab2x24(:,:,829))
  call Hloop_Q_A(ntryL,G0H8(220),16,nMB,G1H8(390),n2h8(231))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(852),h0tab(:,852),[16,2,9,4],[nMB,nMZ,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(220),ngZd,m3h3x8(:,830),heltab2x24(:,:,830))
  call Hloop_Q_A(ntryL,G0H8(220),16,nMB,G1H8(391),n2h8(232))
  Gcoeff(:)%j = (c(96)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(853),h0tab(:,853),[16,2,9,4],[nMT,nMW,nMT,nMT],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(220),ngZu,m3h3x8(:,831),heltab2x24(:,:,831))
  call Hloop_Q_A(ntryL,G0H8(220),16,nMT,G1H8(392),n2h8(233))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(854),h0tab(:,854),[16,2,9,4],[nMZ,nMB,nMH,nMH],4,1,wf4(:,5))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(393),m3h3x8(:,832),heltab2x24(:,:,832))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(855),h0tab(:,855),[16,2,9,4],[nMH,nMB,nMZ,nMZ],4,1,wf4(:,5))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(394),m3h3x8(:,833),heltab2x24(:,:,833))
  Gcoeff(:)%j = (-(c(241)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(856),h0tab(:,856),[16,2,9,4],[nMW,nMT,nMW,nMW],4,1,wf4(:,5))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(395),m3h3x8(:,834),heltab2x24(:,:,834))
  Gcoeff(:)%j = (c(208)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(857),h0tab(:,857),[16,2,9,4],[nMB,0,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(220),ngZd,m3h3x8(:,835),heltab2x24(:,:,835))
  call Hloop_Q_A(ntryL,G0H8(220),16,nMB,G1H8(396),n2h8(234))
  Gcoeff(:)%j = (c(209)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(858),h0tab(:,858),[16,2,9,4],[nMB,nMZ,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(220),ngZd,m3h3x8(:,836),heltab2x24(:,:,836))
  call Hloop_Q_A(ntryL,G0H8(220),16,nMB,G1H8(397),n2h8(235))
  Gcoeff(:)%j = (c(120)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(859),h0tab(:,859),[16,2,9,4],[nMT,nMW,nMT,nMT],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(220),ngZu,m3h3x8(:,837),heltab2x24(:,:,837))
  call Hloop_Q_A(ntryL,G0H8(220),16,nMT,G1H8(398),n2h8(236))
  Gcoeff(:)%j = (c(210)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(860),h0tab(:,860),[16,2,9,4],[nMB,0,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H24(1),ex5(:),G0H8(220),ngZd,m3h3x8(:,838),heltab2x24(:,:,838))
  call Hloop_Q_A(ntryL,G0H8(220),16,nMB,G1H8(399),n2h8(237))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(861),h0tab(:,861),[16,2,9,4],[nMH,nMB,nMZ,nMZ],4,1,wf4(:,5))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(400),m3h3x8(:,839),heltab2x24(:,:,839))
  Gcoeff(:)%j = (-(c(263)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(862),h0tab(:,862),[16,2,9,4],[nMW,nMT,nMW,nMW],4,1,wf4(:,5))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(401),m3h3x8(:,840),heltab2x24(:,:,840))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(863),h0tab(:,863),[16,2,9,4],[nMH,nMB,nMZ,nMZ],4,1,wf4(:,5))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(220),m3h3x8(:,841),heltab2x24(:,:,841))
  Gcoeff(:)%j = (c(149)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(864),h0tab(:,864),[16,2,9,4],[nMW,nMT,nMW,nMW],4,1,wf4(:,5))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(221),m3h3x8(:,842),heltab2x24(:,:,842))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(865),h0tab(:,865),[16,2,9,4],[nMZ,nMB,nMH,nMH],4,1,wf4(:,5))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(222),m3h3x8(:,843),heltab2x24(:,:,843))
  Gcoeff(:)%j = (-(c(161)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(866),h0tab(:,866),[16,2,9,4],[nMW,nMT,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(223),m3h3x8(:,844),heltab2x24(:,:,844))
  Gcoeff(:)%j = (-(c(142)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(867),h0tab(:,867),[16,2,9,4],[nMH,nMB,nMZ,nMZ],4,1,wf4(:,5))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(224),m3h3x8(:,845),heltab2x24(:,:,845))
  Gcoeff(:)%j = (c(179)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(868),h0tab(:,868),[16,2,9,4],[nMW,nMT,nMW,nMW],4,1,wf4(:,5))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(225),m3h3x8(:,846),heltab2x24(:,:,846))
  Gcoeff(:)%j = (-(c(177)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(869),h0tab(:,869),[16,2,9,4],[nMW,nMT,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(226),m3h3x8(:,847),heltab2x24(:,:,847))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(870),h0tab(:,870),[16,2,9,4],[nMW,nMT,nMW,nMW],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(402),m3h3x8(:,848),heltab2x24(:,:,848))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(871),h0tab(:,871),[16,2,9,4],[nMW,nMT,nMW,nMW],4,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex5(:),16,G1H8(403),m3h3x8(:,849),heltab2x24(:,:,849))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(872),h0tab(:,872),[16,1,4,10],[nMH,nMB,nMB,nMZ],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(404),m3h3x8(:,850),heltab2x24(:,:,850))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(873),h0tab(:,873),[16,1,4,10],[nMZ,nMB,nMB,nMH],4,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(405),m3h3x8(:,851),heltab2x24(:,:,851))
  Gcoeff(:)%j = (-(c(255)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(874),h0tab(:,874),[16,1,4,10],[nMW,nMT,nMT,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(406),m3h3x8(:,852),heltab2x24(:,:,852))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(875),h0tab(:,875),[16,1,4,10],[nMB,nMH,nMH,nMB],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(227),ngZd,m3h3x8(:,853),heltab2x24(:,:,853))
  call Hloop_A_Q(ntryL,G0H8(227),16,nMB,G1H8(407),n2h8(238))
  Gcoeff(:)%j = (c(93)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(876),h0tab(:,876),[16,1,4,10],[nMB,nMZ,nMZ,nMB],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(227),ngZd,m3h3x8(:,854),heltab2x24(:,:,854))
  call Hloop_A_Q(ntryL,G0H8(227),16,nMB,G1H8(408),n2h8(239))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(877),h0tab(:,877),[16,1,4,10],[nMT,nMW,nMW,nMT],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(227),ngZu,m3h3x8(:,855),heltab2x24(:,:,855))
  call Hloop_A_Q(ntryL,G0H8(227),16,nMT,G1H8(409),n2h8(240))
  Gcoeff(:)%j = (-(c(112)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(878),h0tab(:,878),[16,1,4,10],[nMH,nMB,nMB,nMZ],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(227),m3h3x8(:,856),heltab2x24(:,:,856))
  Gcoeff(:)%j = (-(c(170)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(879),h0tab(:,879),[16,1,4,10],[nMW,nMT,nMT,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(228),m3h3x8(:,857),heltab2x24(:,:,857))
  Gcoeff(:)%j = (-(c(112)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(880),h0tab(:,880),[16,1,4,10],[nMZ,nMB,nMB,nMH],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(229),m3h3x8(:,858),heltab2x24(:,:,858))
  Gcoeff(:)%j = (c(170)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(881),h0tab(:,881),[16,1,4,10],[nMW,nMT,nMT,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(230),m3h3x8(:,859),heltab2x24(:,:,859))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(882),h0tab(:,882),[16,1,4,10],[nMB,nMZ,nMZ,nMB],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(231),ngZd,m3h3x8(:,860),heltab2x24(:,:,860))
  call Hloop_A_Q(ntryL,G0H8(231),16,nMB,G1H8(410),n2h8(241))
  Gcoeff(:)%j = (c(99)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(883),h0tab(:,883),[16,1,4,10],[nMT,nMW,nMW,nMT],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(231),ngZu,m3h3x8(:,861),heltab2x24(:,:,861))
  call Hloop_A_Q(ntryL,G0H8(231),16,nMT,G1H8(411),n2h8(242))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(884),h0tab(:,884),[16,1,4,10],[nMB,nMZ,nMZ,nMB],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(231),ngZd,m3h3x8(:,862),heltab2x24(:,:,862))
  call Hloop_A_Q(ntryL,G0H8(231),16,nMB,G1H8(412),n2h8(243))
  Gcoeff(:)%j = (c(99)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(885),h0tab(:,885),[16,1,4,10],[nMT,nMW,nMW,nMT],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(231),ngZu,m3h3x8(:,863),heltab2x24(:,:,863))
  call Hloop_A_Q(ntryL,G0H8(231),16,nMT,G1H8(413),n2h8(244))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(886),h0tab(:,886),[16,1,4,10],[nMW,nMT,nMT,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(414),m3h3x8(:,864),heltab2x24(:,:,864))
  Gcoeff(:)%j = (c(219)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(887),h0tab(:,887),[16,1,4,10],[nMB,nMZ,nMZ,nMB],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(231),ngZd,m3h3x8(:,865),heltab2x24(:,:,865))
  call Hloop_A_Q(ntryL,G0H8(231),16,nMB,G1H8(415),n2h8(245))
  Gcoeff(:)%j = (c(124)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(888),h0tab(:,888),[16,1,4,10],[nMT,nMW,nMW,nMT],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(231),ngZu,m3h3x8(:,866),heltab2x24(:,:,866))
  call Hloop_A_Q(ntryL,G0H8(231),16,nMT,G1H8(416),n2h8(246))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(889),h0tab(:,889),[16,4,1,10],[nMB,nMB,nMH,nMB],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(231),ngZd,m3h3x8(:,867),heltab2x24(:,:,867))
  call Hloop_A_Q(ntryL,G0H8(231),16,nMB,G1H8(417),n2h8(247))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(890),h0tab(:,890),[16,4,1,10],[nMB,nMB,nMZ,nMB],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(231),ngZd,m3h3x8(:,868),heltab2x24(:,:,868))
  call Hloop_A_Q(ntryL,G0H8(231),16,nMB,G1H8(418),n2h8(248))
  Gcoeff(:)%j = (c(96)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(891),h0tab(:,891),[16,4,1,10],[nMT,nMT,nMW,nMT],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(231),ngZu,m3h3x8(:,869),heltab2x24(:,:,869))
  call Hloop_A_Q(ntryL,G0H8(231),16,nMT,G1H8(419),n2h8(249))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(892),h0tab(:,892),[16,4,1,10],[nMH,nMH,nMB,nMZ],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(420),m3h3x8(:,870),heltab2x24(:,:,870))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(893),h0tab(:,893),[16,4,1,10],[nMZ,nMZ,nMB,nMH],4,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(421),m3h3x8(:,871),heltab2x24(:,:,871))
  Gcoeff(:)%j = (-(c(241)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(894),h0tab(:,894),[16,4,1,10],[nMW,nMW,nMT,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(422),m3h3x8(:,872),heltab2x24(:,:,872))
  Gcoeff(:)%j = (c(208)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(895),h0tab(:,895),[16,4,1,10],[nMB,nMB,0,nMB],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(231),ngZd,m3h3x8(:,873),heltab2x24(:,:,873))
  call Hloop_A_Q(ntryL,G0H8(231),16,nMB,G1H8(423),n2h8(250))
  Gcoeff(:)%j = (c(209)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(896),h0tab(:,896),[16,4,1,10],[nMB,nMB,nMZ,nMB],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(231),ngZd,m3h3x8(:,874),heltab2x24(:,:,874))
  call Hloop_A_Q(ntryL,G0H8(231),16,nMB,G1H8(424),n2h8(251))
  Gcoeff(:)%j = (c(120)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(897),h0tab(:,897),[16,4,1,10],[nMT,nMT,nMW,nMT],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(231),ngZu,m3h3x8(:,875),heltab2x24(:,:,875))
  call Hloop_A_Q(ntryL,G0H8(231),16,nMT,G1H8(425),n2h8(252))
  Gcoeff(:)%j = (c(210)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(898),h0tab(:,898),[16,4,1,10],[nMB,nMB,0,nMB],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(231),ngZd,m3h3x8(:,876),heltab2x24(:,:,876))
  call Hloop_A_Q(ntryL,G0H8(231),16,nMB,G1H8(426),n2h8(253))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(899),h0tab(:,899),[16,4,1,10],[nMH,nMH,nMB,nMZ],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(231),m3h3x8(:,877),heltab2x24(:,:,877))
  Gcoeff(:)%j = (-(c(161)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(900),h0tab(:,900),[16,4,1,10],[nMW,nMW,nMT,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(232),m3h3x8(:,878),heltab2x24(:,:,878))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(901),h0tab(:,901),[16,4,1,10],[nMZ,nMZ,nMB,nMH],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(233),m3h3x8(:,879),heltab2x24(:,:,879))
  Gcoeff(:)%j = (c(149)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(902),h0tab(:,902),[16,4,1,10],[nMW,nMW,nMT,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(234),m3h3x8(:,880),heltab2x24(:,:,880))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(903),h0tab(:,903),[16,4,1,10],[nMZ,nMZ,nMB,nMH],4,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(427),m3h3x8(:,881),heltab2x24(:,:,881))
  Gcoeff(:)%j = (-(c(263)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(904),h0tab(:,904),[16,4,1,10],[nMW,nMW,nMT,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(428),m3h3x8(:,882),heltab2x24(:,:,882))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(905),h0tab(:,905),[16,4,1,10],[nMW,nMW,nMT,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(429),m3h3x8(:,883),heltab2x24(:,:,883))
  Gcoeff(:)%j = (-(c(177)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(906),h0tab(:,906),[16,4,1,10],[nMW,nMW,nMT,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(235),m3h3x8(:,884),heltab2x24(:,:,884))
  Gcoeff(:)%j = (-(c(142)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(907),h0tab(:,907),[16,4,1,10],[nMZ,nMZ,nMB,nMH],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(236),m3h3x8(:,885),heltab2x24(:,:,885))
  Gcoeff(:)%j = (c(179)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(908),h0tab(:,908),[16,4,1,10],[nMW,nMW,nMT,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(237),m3h3x8(:,886),heltab2x24(:,:,886))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(909),h0tab(:,909),[16,4,1,10],[nMW,nMW,nMT,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(430),m3h3x8(:,887),heltab2x24(:,:,887))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(910),h0tab(:,910),[16,1,10,4],[nMB,nMH,nMB,nMB],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(238),ngZd,m3h3x8(:,888),heltab2x24(:,:,888))
  call Hloop_A_Q(ntryL,G0H8(238),16,nMB,G1H8(431),n2h8(254))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(911),h0tab(:,911),[16,1,10,4],[nMB,nMZ,nMB,nMB],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(238),ngZd,m3h3x8(:,889),heltab2x24(:,:,889))
  call Hloop_A_Q(ntryL,G0H8(238),16,nMB,G1H8(432),n2h8(255))
  Gcoeff(:)%j = (c(96)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(912),h0tab(:,912),[16,1,10,4],[nMT,nMW,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(238),ngZu,m3h3x8(:,890),heltab2x24(:,:,890))
  call Hloop_A_Q(ntryL,G0H8(238),16,nMT,G1H8(433),n2h8(256))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(913),h0tab(:,913),[16,1,10,4],[nMZ,nMB,nMH,nMH],4,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H24(1),0,ex5(:),16,G1H8(434),m3h3x8(:,891),heltab2x24(:,:,891))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(914),h0tab(:,914),[16,1,10,4],[nMH,nMB,nMZ,nMZ],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(435),m3h3x8(:,892),heltab2x24(:,:,892))
  Gcoeff(:)%j = (-(c(241)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(915),h0tab(:,915),[16,1,10,4],[nMW,nMT,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(436),m3h3x8(:,893),heltab2x24(:,:,893))
  Gcoeff(:)%j = (c(208)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(916),h0tab(:,916),[16,1,10,4],[nMB,0,nMB,nMB],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(238),ngZd,m3h3x8(:,894),heltab2x24(:,:,894))
  call Hloop_A_Q(ntryL,G0H8(238),16,nMB,G1H8(437),n2h8(257))
  Gcoeff(:)%j = (c(209)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(917),h0tab(:,917),[16,1,10,4],[nMB,nMZ,nMB,nMB],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(238),ngZd,m3h3x8(:,895),heltab2x24(:,:,895))
  call Hloop_A_Q(ntryL,G0H8(238),16,nMB,G1H8(438),n2h8(258))
  Gcoeff(:)%j = (c(120)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(918),h0tab(:,918),[16,1,10,4],[nMT,nMW,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(238),ngZu,m3h3x8(:,896),heltab2x24(:,:,896))
  call Hloop_A_Q(ntryL,G0H8(238),16,nMT,G1H8(439),n2h8(259))
  Gcoeff(:)%j = (c(210)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(919),h0tab(:,919),[16,1,10,4],[nMB,0,nMB,nMB],4,1,wf4(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),ex5(:),G0H8(238),ngZd,m3h3x8(:,897),heltab2x24(:,:,897))
  call Hloop_A_Q(ntryL,G0H8(238),16,nMB,G1H8(440),n2h8(260))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(920),h0tab(:,920),[16,1,10,4],[nMH,nMB,nMZ,nMZ],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(441),m3h3x8(:,898),heltab2x24(:,:,898))
  Gcoeff(:)%j = (-(c(263)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(921),h0tab(:,921),[16,1,10,4],[nMW,nMT,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_T(ntryL,G0H24(1),0,ex5(:),16,G1H8(442),m3h3x8(:,899),heltab2x24(:,:,899))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(922),h0tab(:,922),[16,1,10,4],[nMH,nMB,nMZ,nMZ],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(238),m3h3x8(:,900),heltab2x24(:,:,900))
  Gcoeff(:)%j = (-(c(149)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(923),h0tab(:,923),[16,1,10,4],[nMW,nMT,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(239),m3h3x8(:,901),heltab2x24(:,:,901))
  Gcoeff(:)%j = (-(c(118)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(924),h0tab(:,924),[16,1,10,4],[nMZ,nMB,nMH,nMH],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(240),m3h3x8(:,902),heltab2x24(:,:,902))
  Gcoeff(:)%j = (c(161)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(925),h0tab(:,925),[16,1,10,4],[nMW,nMT,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(241),m3h3x8(:,903),heltab2x24(:,:,903))
  Gcoeff(:)%j = (-(c(142)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(926),h0tab(:,926),[16,1,10,4],[nMH,nMB,nMZ,nMZ],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(242),m3h3x8(:,904),heltab2x24(:,:,904))
  Gcoeff(:)%j = (-(c(179)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(927),h0tab(:,927),[16,1,10,4],[nMW,nMT,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),ex5(:),G0H8(243),m3h3x8(:,905),heltab2x24(:,:,905))
  Gcoeff(:)%j = (c(177)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(928),h0tab(:,928),[16,1,10,4],[nMW,nMT,nMW,nMW],4,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),ex5(:),G0H8(244),m3h3x8(:,906),heltab2x24(:,:,906))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(929),h0tab(:,929),[16,1,10,4],[nMW,nMT,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(443),m3h3x8(:,907),heltab2x24(:,:,907))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(930),h0tab(:,930),[16,1,10,4],[nMW,nMT,nMW,nMW],4,1,wf4(:,2))
  call Hloop_UW_V(ntryL,G0H24(1),0,ex5(:),16,G1H8(444),m3h3x8(:,908),heltab2x24(:,:,908))
  Gcoeff(:)%j = (-(c(98)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(931),h0tab(:,931),[17,4,2,8],[nMT,nMT,nMW,nMW],4,1,wf6(:,5))
  call Hloop_SQ_A(ntryL,G0H24(1),wf6(:,5),G0H4(11),ngPtb,m3h6x4(:,1),heltab2x24(:,:,909))
  call Hloop_Q_A(ntryL,G0H4(11),17,nMT,G1H4(199),n2h4(279))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(932),h0tab(:,932),[17,4,2,8],[nMH,nMH,nMB,nMB],4,1,wf6(:,5))
  call Hloop_AQ_S(ntryL,G0H24(1),wf6(:,5),G0H4(11),ngH,m3h6x4(:,2),heltab2x24(:,:,910))
  Gcoeff(:)%j = (c(93)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(933),h0tab(:,933),[17,4,2,8],[nMZ,nMZ,nMB,nMB],4,1,wf6(:,5))
  call Hloop_AQ_S(ntryL,G0H24(1),wf6(:,5),G0H4(12),ngX,m3h6x4(:,3),heltab2x24(:,:,911))
  Gcoeff(:)%j = (-(c(90)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(934),h0tab(:,934),[17,4,2,8],[nMW,nMW,nMT,nMT],4,1,wf6(:,5))
  call Hloop_AQ_S(ntryL,G0H24(1),wf6(:,5),G0H4(13),ngPtb,m3h6x4(:,4),heltab2x24(:,:,912))
  Gcoeff(:)%j = (c(122)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(935),h0tab(:,935),[17,4,2,8],[nMT,nMT,nMW,nMW],4,1,wf6(:,5))
  call Hloop_WQ_A(ntryL,G0H24(1),wf6(:,5),G0H4(14),m3h6x4(:,5),heltab2x24(:,:,913))
  call Hloop_Q_A(ntryL,G0H4(14),17,nMT,G1H4(200),n2h4(280))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(936),h0tab(:,936),[17,4,2,8],[nMT,nMT,nMW,nMW],4,1,wf6(:,5))
  call Hloop_SQ_A(ntryL,G0H24(1),wf6(:,5),G0H4(14),ngPtb,m3h6x4(:,6),heltab2x24(:,:,914))
  call Hloop_Q_A(ntryL,G0H4(14),17,nMT,G1H4(32),n2h4(281))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(937),h0tab(:,937),[17,4,2,8],[nMZ,nMZ,nMB,nMB],4,1,wf6(:,5))
  call Hloop_AQ_Z(ntryL,G0H24(1),wf6(:,5),G0H4(14),ngZd,m3h6x4(:,7),heltab2x24(:,:,915))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(938),h0tab(:,938),[17,4,2,8],[nMW,nMW,nMT,nMT],4,1,wf6(:,5))
  call Hloop_AQ_W(ntryL,G0H24(1),wf6(:,5),G0H4(15),m3h6x4(:,8),heltab2x24(:,:,916))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(939),h0tab(:,939),[17,4,2,8],[nMZ,nMZ,nMB,nMB],4,1,wf6(:,5))
  call Hloop_AQ_S(ntryL,G0H24(1),wf6(:,5),G0H4(16),ngX,m3h6x4(:,9),heltab2x24(:,:,917))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(940),h0tab(:,940),[17,4,2,8],[nMW,nMW,nMT,nMT],4,1,wf6(:,5))
  call Hloop_AQ_S(ntryL,G0H24(1),wf6(:,5),G0H4(17),ngPtb,m3h6x4(:,10),heltab2x24(:,:,918))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(941),h0tab(:,941),[17,4,2,8],[nMT,nMT,nMW,nMW],4,1,wf6(:,5))
  call Hloop_WQ_A(ntryL,G0H24(1),wf6(:,5),G0H4(18),m3h6x4(:,11),heltab2x24(:,:,919))
  call Hloop_Q_A(ntryL,G0H4(18),17,nMT,G1H4(202),n2h4(282))
  Gcoeff(:)%j = (c(219)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(942),h0tab(:,942),[17,4,2,8],[nMZ,nMZ,nMB,nMB],4,1,wf6(:,5))
  call Hloop_AQ_Z(ntryL,G0H24(1),wf6(:,5),G0H4(18),ngZd,m3h6x4(:,12),heltab2x24(:,:,920))
  Gcoeff(:)%j = (-(c(126)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(943),h0tab(:,943),[17,4,2,8],[nMW,nMW,nMT,nMT],4,1,wf6(:,5))
  call Hloop_AQ_W(ntryL,G0H24(1),wf6(:,5),G0H4(19),m3h6x4(:,13),heltab2x24(:,:,921))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(944),h0tab(:,944),[17,2,4,8],[nMH,nMB,nMB,nMB],4,1,wf6(:,5))
  call Hloop_AQ_S(ntryL,G0H24(1),wf6(:,5),G0H4(20),ngH,m3h6x4(:,14),heltab2x24(:,:,922))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(945),h0tab(:,945),[17,2,4,8],[nMZ,nMB,nMB,nMB],4,1,wf6(:,5))
  call Hloop_AQ_S(ntryL,G0H24(1),wf6(:,5),G0H4(21),ngX,m3h6x4(:,15),heltab2x24(:,:,923))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(946),h0tab(:,946),[17,2,4,8],[nMW,nMT,nMT,nMT],4,1,wf6(:,5))
  call Hloop_AQ_S(ntryL,G0H24(1),wf6(:,5),G0H4(22),ngPtb,m3h6x4(:,16),heltab2x24(:,:,924))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(947),h0tab(:,947),[17,2,4,8],[nMT,nMW,nMW,nMW],4,1,wf6(:,5))
  call Hloop_SQ_A(ntryL,G0H24(1),wf6(:,5),G0H4(23),ngPtb,m3h6x4(:,17),heltab2x24(:,:,925))
  call Hloop_Q_A(ntryL,G0H4(23),17,nMT,G1H4(217),n2h4(283))
  Gcoeff(:)%j = (c(208)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(948),h0tab(:,948),[17,2,4,8],[0,nMB,nMB,nMB],4,1,wf6(:,5))
  call Hloop_AQ_V(ntryL,G0H24(1),wf6(:,5),G0H4(23),m3h6x4(:,18),heltab2x24(:,:,926))
  Gcoeff(:)%j = (c(209)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(949),h0tab(:,949),[17,2,4,8],[nMZ,nMB,nMB,nMB],4,1,wf6(:,5))
  call Hloop_AQ_Z(ntryL,G0H24(1),wf6(:,5),G0H4(24),ngZd,m3h6x4(:,19),heltab2x24(:,:,927))
  Gcoeff(:)%j = (-(c(121)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(950),h0tab(:,950),[17,2,4,8],[nMW,nMT,nMT,nMT],4,1,wf6(:,5))
  call Hloop_AQ_W(ntryL,G0H24(1),wf6(:,5),G0H4(25),m3h6x4(:,20),heltab2x24(:,:,928))
  Gcoeff(:)%j = (c(210)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(951),h0tab(:,951),[17,2,4,8],[0,nMB,nMB,nMB],4,1,wf6(:,5))
  call Hloop_AQ_V(ntryL,G0H24(1),wf6(:,5),G0H4(26),m3h6x4(:,21),heltab2x24(:,:,929))
  Gcoeff(:)%j = (c(113)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(952),h0tab(:,952),[17,2,4,8],[nMT,nMW,nMW,nMW],4,1,wf6(:,5))
  call Hloop_WQ_A(ntryL,G0H24(1),wf6(:,5),G0H4(27),m3h6x4(:,22),heltab2x24(:,:,930))
  call Hloop_Q_A(ntryL,G0H4(27),17,nMT,G1H4(218),n2h4(284))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(953),h0tab(:,953),[17,2,4,8],[nMT,nMW,nMW,nMW],4,1,wf6(:,5))
  call Hloop_SQ_A(ntryL,G0H24(1),wf6(:,5),G0H4(27),ngPtb,m3h6x4(:,23),heltab2x24(:,:,931))
  call Hloop_Q_A(ntryL,G0H4(27),17,nMT,G1H4(233),n2h4(285))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(954),h0tab(:,954),[17,2,4,8],[nMT,nMW,nMW,nMW],4,1,wf6(:,5))
  call Hloop_SQ_A(ntryL,G0H24(1),wf6(:,5),G0H4(27),ngPtb,m3h6x4(:,24),heltab2x24(:,:,932))
  call Hloop_Q_A(ntryL,G0H4(27),17,nMT,G1H4(234),n2h4(286))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(955),h0tab(:,955),[17,2,4,8],[nMT,nMW,nMW,nMW],4,1,wf6(:,5))
  call Hloop_WQ_A(ntryL,G0H24(1),wf6(:,5),G0H4(27),m3h6x4(:,25),heltab2x24(:,:,933))
  call Hloop_Q_A(ntryL,G0H4(27),17,nMT,G1H4(10),n2h4(287))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(956),h0tab(:,956),[17,2,4,8],[nMT,nMW,nMW,nMW],4,1,wf6(:,5))
  call Hloop_WQ_A(ntryL,G0H24(1),wf6(:,5),G0H4(27),m3h6x4(:,26),heltab2x24(:,:,934))
  call Hloop_Q_A(ntryL,G0H4(27),17,nMT,G1H4(12),n2h4(288))
  Gcoeff(:)%j = (-(c(127)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(957),h0tab(:,957),[17,2,4,8],[nMT,nMW,nMW,nMW],4,1,wf6(:,5))
  call Hloop_SQ_A(ntryL,G0H24(1),wf6(:,5),G0H4(27),ngPtb,m3h6x4(:,27),heltab2x24(:,:,935))
  call Hloop_Q_A(ntryL,G0H4(27),17,nMT,G1H4(3),n2h4(289))
  Gcoeff(:)%j = (-(c(127)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(958),h0tab(:,958),[17,2,4,8],[nMT,nMW,nMW,nMW],4,1,wf6(:,5))
  call Hloop_WQ_A(ntryL,G0H24(1),wf6(:,5),G0H4(27),m3h6x4(:,28),heltab2x24(:,:,936))
  call Hloop_Q_A(ntryL,G0H4(27),17,nMT,G1H4(5),n2h4(290))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(959),h0tab(:,959),[17,2,8,4],[nMH,nMB,nMB,nMB],4,1,wf6(:,5))
  call Hloop_AQ_S(ntryL,G0H24(1),wf6(:,5),G0H4(27),ngH,m3h6x4(:,29),heltab2x24(:,:,937))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(960),h0tab(:,960),[17,2,8,4],[nMZ,nMB,nMB,nMB],4,1,wf6(:,5))
  call Hloop_AQ_S(ntryL,G0H24(1),wf6(:,5),G0H4(28),ngX,m3h6x4(:,30),heltab2x24(:,:,938))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(961),h0tab(:,961),[17,2,8,4],[nMW,nMT,nMT,nMT],4,1,wf6(:,5))
  call Hloop_AQ_S(ntryL,G0H24(1),wf6(:,5),G0H4(29),ngPtb,m3h6x4(:,31),heltab2x24(:,:,939))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(962),h0tab(:,962),[17,2,8,4],[nMT,nMW,nMW,nMW],4,1,wf6(:,5))
  call Hloop_SQ_A(ntryL,G0H24(1),wf6(:,5),G0H4(30),ngPtb,m3h6x4(:,32),heltab2x24(:,:,940))
  call Hloop_Q_A(ntryL,G0H4(30),17,nMT,G1H4(6),n2h4(291))
  Gcoeff(:)%j = (c(208)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(963),h0tab(:,963),[17,2,8,4],[0,nMB,nMB,nMB],4,1,wf6(:,5))
  call Hloop_AQ_V(ntryL,G0H24(1),wf6(:,5),G0H4(30),m3h6x4(:,33),heltab2x24(:,:,941))
  Gcoeff(:)%j = (c(209)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(964),h0tab(:,964),[17,2,8,4],[nMZ,nMB,nMB,nMB],4,1,wf6(:,5))
  call Hloop_AQ_Z(ntryL,G0H24(1),wf6(:,5),G0H4(31),ngZd,m3h6x4(:,34),heltab2x24(:,:,942))
  Gcoeff(:)%j = (-(c(121)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(965),h0tab(:,965),[17,2,8,4],[nMW,nMT,nMT,nMT],4,1,wf6(:,5))
  call Hloop_AQ_W(ntryL,G0H24(1),wf6(:,5),G0H4(32),m3h6x4(:,35),heltab2x24(:,:,943))
  Gcoeff(:)%j = (c(210)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(966),h0tab(:,966),[17,2,8,4],[0,nMB,nMB,nMB],4,1,wf6(:,5))
  call Hloop_AQ_V(ntryL,G0H24(1),wf6(:,5),G0H4(33),m3h6x4(:,36),heltab2x24(:,:,944))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(967),h0tab(:,967),[17,2,8,4],[nMT,nMW,nMW,nMW],4,1,wf6(:,5))
  call Hloop_WQ_A(ntryL,G0H24(1),wf6(:,5),G0H4(34),m3h6x4(:,37),heltab2x24(:,:,945))
  call Hloop_Q_A(ntryL,G0H4(34),17,nMT,G1H4(9),n2h4(292))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(968),h0tab(:,968),[17,2,8,4],[nMT,nMW,nMW,nMW],4,1,wf6(:,5))
  call Hloop_SQ_A(ntryL,G0H24(1),wf6(:,5),G0H4(34),ngPtb,m3h6x4(:,38),heltab2x24(:,:,946))
  call Hloop_Q_A(ntryL,G0H4(34),17,nMT,G1H4(15),n2h4(293))
  Gcoeff(:)%j = (-(c(113)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(969),h0tab(:,969),[17,2,8,4],[nMT,nMW,nMW,nMW],4,1,wf6(:,5))
  call Hloop_SQ_A(ntryL,G0H24(1),wf6(:,5),G0H4(34),ngPtb,m3h6x4(:,39),heltab2x24(:,:,947))
  call Hloop_Q_A(ntryL,G0H4(34),17,nMT,G1H4(16),n2h4(294))
  Gcoeff(:)%j = (c(127)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(970),h0tab(:,970),[17,2,8,4],[nMT,nMW,nMW,nMW],4,1,wf6(:,5))
  call Hloop_WQ_A(ntryL,G0H24(1),wf6(:,5),G0H4(34),m3h6x4(:,40),heltab2x24(:,:,948))
  call Hloop_Q_A(ntryL,G0H4(34),17,nMT,G1H4(17),n2h4(295))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(971),h0tab(:,971),[17,2,8,4],[nMT,nMW,nMW,nMW],4,1,wf6(:,5))
  call Hloop_WQ_A(ntryL,G0H24(1),wf6(:,5),G0H4(34),m3h6x4(:,41),heltab2x24(:,:,949))
  call Hloop_Q_A(ntryL,G0H4(34),17,nMT,G1H4(18),n2h4(296))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(972),h0tab(:,972),[17,2,8,4],[nMT,nMW,nMW,nMW],4,1,wf6(:,5))
  call Hloop_SQ_A(ntryL,G0H24(1),wf6(:,5),G0H4(34),ngPtb,m3h6x4(:,42),heltab2x24(:,:,950))
  call Hloop_Q_A(ntryL,G0H4(34),17,nMT,G1H4(30),n2h4(297))
  Gcoeff(:)%j = (-(c(127)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(973),h0tab(:,973),[17,2,8,4],[nMT,nMW,nMW,nMW],4,1,wf6(:,5))
  call Hloop_WQ_A(ntryL,G0H24(1),wf6(:,5),G0H4(34),m3h6x4(:,43),heltab2x24(:,:,951))
  call Hloop_Q_A(ntryL,G0H4(34),17,nMT,G1H4(31),n2h4(298))
  Gcoeff(:)%j = (-(c(98)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(974),h0tab(:,974),[18,4,1,8],[nMT,nMT,nMW,nMW],4,1,wf6(:,3))
  call Hloop_SA_Q(ntryL,G0H24(1),wf6(:,3),G0H4(34),ngPbt,m3h6x4(:,44),heltab2x24(:,:,952))
  call Hloop_A_Q(ntryL,G0H4(34),18,nMT,G1H4(43),n2h4(299))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(975),h0tab(:,975),[18,4,1,8],[nMH,nMH,nMB,nMB],4,1,wf6(:,3))
  call Hloop_QA_S(ntryL,G0H24(1),wf6(:,3),G0H4(34),ngH,m3h6x4(:,45),heltab2x24(:,:,953))
  Gcoeff(:)%j = (c(93)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(976),h0tab(:,976),[18,4,1,8],[nMZ,nMZ,nMB,nMB],4,1,wf6(:,3))
  call Hloop_QA_S(ntryL,G0H24(1),wf6(:,3),G0H4(35),ngX,m3h6x4(:,46),heltab2x24(:,:,954))
  Gcoeff(:)%j = (-(c(90)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(977),h0tab(:,977),[18,4,1,8],[nMW,nMW,nMT,nMT],4,1,wf6(:,3))
  call Hloop_QA_S(ntryL,G0H24(1),wf6(:,3),G0H4(36),ngPbt,m3h6x4(:,47),heltab2x24(:,:,955))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(978),h0tab(:,978),[18,4,1,8],[nMT,nMT,nMW,nMW],4,1,wf6(:,3))
  call Hloop_WA_Q(ntryL,G0H24(1),wf6(:,3),G0H4(37),m3h6x4(:,48),heltab2x24(:,:,956))
  call Hloop_A_Q(ntryL,G0H4(37),18,nMT,G1H4(127),n2h4(300))
  Gcoeff(:)%j = (c(122)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(979),h0tab(:,979),[18,4,1,8],[nMT,nMT,nMW,nMW],4,1,wf6(:,3))
  call Hloop_SA_Q(ntryL,G0H24(1),wf6(:,3),G0H4(37),ngPbt,m3h6x4(:,49),heltab2x24(:,:,957))
  call Hloop_A_Q(ntryL,G0H4(37),18,nMT,G1H4(41),n2h4(301))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(980),h0tab(:,980),[18,4,1,8],[nMZ,nMZ,nMB,nMB],4,1,wf6(:,3))
  call Hloop_QA_Z(ntryL,G0H24(1),wf6(:,3),G0H4(37),ngZd,m3h6x4(:,50),heltab2x24(:,:,958))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(981),h0tab(:,981),[18,4,1,8],[nMW,nMW,nMT,nMT],4,1,wf6(:,3))
  call Hloop_QA_W(ntryL,G0H24(1),wf6(:,3),G0H4(38),m3h6x4(:,51),heltab2x24(:,:,959))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(982),h0tab(:,982),[18,4,1,8],[nMZ,nMZ,nMB,nMB],4,1,wf6(:,3))
  call Hloop_QA_S(ntryL,G0H24(1),wf6(:,3),G0H4(39),ngX,m3h6x4(:,52),heltab2x24(:,:,960))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(983),h0tab(:,983),[18,4,1,8],[nMW,nMW,nMT,nMT],4,1,wf6(:,3))
  call Hloop_QA_S(ntryL,G0H24(1),wf6(:,3),G0H4(40),ngPbt,m3h6x4(:,53),heltab2x24(:,:,961))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(984),h0tab(:,984),[18,4,1,8],[nMT,nMT,nMW,nMW],4,1,wf6(:,3))
  call Hloop_WA_Q(ntryL,G0H24(1),wf6(:,3),G0H4(41),m3h6x4(:,54),heltab2x24(:,:,962))
  call Hloop_A_Q(ntryL,G0H4(41),18,nMT,G1H4(47),n2h4(302))
  Gcoeff(:)%j = (c(219)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(985),h0tab(:,985),[18,4,1,8],[nMZ,nMZ,nMB,nMB],4,1,wf6(:,3))
  call Hloop_QA_Z(ntryL,G0H24(1),wf6(:,3),G0H4(41),ngZd,m3h6x4(:,55),heltab2x24(:,:,963))
  Gcoeff(:)%j = (-(c(126)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(986),h0tab(:,986),[18,4,1,8],[nMW,nMW,nMT,nMT],4,1,wf6(:,3))
  call Hloop_QA_W(ntryL,G0H24(1),wf6(:,3),G0H4(42),m3h6x4(:,56),heltab2x24(:,:,964))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(987),h0tab(:,987),[18,1,4,8],[nMH,nMB,nMB,nMB],4,1,wf6(:,3))
  call Hloop_QA_S(ntryL,G0H24(1),wf6(:,3),G0H4(43),ngH,m3h6x4(:,57),heltab2x24(:,:,965))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(988),h0tab(:,988),[18,1,4,8],[nMZ,nMB,nMB,nMB],4,1,wf6(:,3))
  call Hloop_QA_S(ntryL,G0H24(1),wf6(:,3),G0H4(44),ngX,m3h6x4(:,58),heltab2x24(:,:,966))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(989),h0tab(:,989),[18,1,4,8],[nMW,nMT,nMT,nMT],4,1,wf6(:,3))
  call Hloop_QA_S(ntryL,G0H24(1),wf6(:,3),G0H4(45),ngPbt,m3h6x4(:,59),heltab2x24(:,:,967))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(990),h0tab(:,990),[18,1,4,8],[nMT,nMW,nMW,nMW],4,1,wf6(:,3))
  call Hloop_SA_Q(ntryL,G0H24(1),wf6(:,3),G0H4(46),ngPbt,m3h6x4(:,60),heltab2x24(:,:,968))
  call Hloop_A_Q(ntryL,G0H4(46),18,nMT,G1H4(27),n2h4(303))
  Gcoeff(:)%j = (c(208)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(991),h0tab(:,991),[18,1,4,8],[0,nMB,nMB,nMB],4,1,wf6(:,3))
  call Hloop_QA_V(ntryL,G0H24(1),wf6(:,3),G0H4(46),m3h6x4(:,61),heltab2x24(:,:,969))
  Gcoeff(:)%j = (c(209)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(992),h0tab(:,992),[18,1,4,8],[nMZ,nMB,nMB,nMB],4,1,wf6(:,3))
  call Hloop_QA_Z(ntryL,G0H24(1),wf6(:,3),G0H4(47),ngZd,m3h6x4(:,62),heltab2x24(:,:,970))
  Gcoeff(:)%j = (-(c(121)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(993),h0tab(:,993),[18,1,4,8],[nMW,nMT,nMT,nMT],4,1,wf6(:,3))
  call Hloop_QA_W(ntryL,G0H24(1),wf6(:,3),G0H4(48),m3h6x4(:,63),heltab2x24(:,:,971))
  Gcoeff(:)%j = (c(210)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(994),h0tab(:,994),[18,1,4,8],[0,nMB,nMB,nMB],4,1,wf6(:,3))
  call Hloop_QA_V(ntryL,G0H24(1),wf6(:,3),G0H4(49),m3h6x4(:,64),heltab2x24(:,:,972))
  Gcoeff(:)%j = (-(c(113)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(995),h0tab(:,995),[18,1,4,8],[nMT,nMW,nMW,nMW],4,1,wf6(:,3))
  call Hloop_WA_Q(ntryL,G0H24(1),wf6(:,3),G0H4(50),m3h6x4(:,65),heltab2x24(:,:,973))
  call Hloop_A_Q(ntryL,G0H4(50),18,nMT,G1H4(48),n2h4(304))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(996),h0tab(:,996),[18,1,4,8],[nMT,nMW,nMW,nMW],4,1,wf6(:,3))
  call Hloop_SA_Q(ntryL,G0H24(1),wf6(:,3),G0H4(50),ngPbt,m3h6x4(:,66),heltab2x24(:,:,974))
  call Hloop_A_Q(ntryL,G0H4(50),18,nMT,G1H4(53),n2h4(305))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(997),h0tab(:,997),[18,1,4,8],[nMT,nMW,nMW,nMW],4,1,wf6(:,3))
  call Hloop_SA_Q(ntryL,G0H24(1),wf6(:,3),G0H4(50),ngPbt,m3h6x4(:,67),heltab2x24(:,:,975))
  call Hloop_A_Q(ntryL,G0H4(50),18,nMT,G1H4(58),n2h4(306))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(998),h0tab(:,998),[18,1,4,8],[nMT,nMW,nMW,nMW],4,1,wf6(:,3))
  call Hloop_WA_Q(ntryL,G0H24(1),wf6(:,3),G0H4(50),m3h6x4(:,68),heltab2x24(:,:,976))
  call Hloop_A_Q(ntryL,G0H4(50),18,nMT,G1H4(60),n2h4(307))
  Gcoeff(:)%j = (-(c(125)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(999),h0tab(:,999),[18,1,4,8],[nMT,nMW,nMW,nMW],4,1,wf6(:,3))
  call Hloop_WA_Q(ntryL,G0H24(1),wf6(:,3),G0H4(50),m3h6x4(:,69),heltab2x24(:,:,977))
  call Hloop_A_Q(ntryL,G0H4(50),18,nMT,G1H4(128),n2h4(308))
  Gcoeff(:)%j = (c(127)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1000),h0tab(:,1000),[18,1,4,8],[nMT,nMW,nMW,nMW],4,1,wf6(:,3))
  call Hloop_SA_Q(ntryL,G0H24(1),wf6(:,3),G0H4(50),ngPbt,m3h6x4(:,70),heltab2x24(:,:,978))
  call Hloop_A_Q(ntryL,G0H4(50),18,nMT,G1H4(62),n2h4(309))
  Gcoeff(:)%j = (-(c(127)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1001),h0tab(:,1001),[18,1,4,8],[nMT,nMW,nMW,nMW],4,1,wf6(:,3))
  call Hloop_WA_Q(ntryL,G0H24(1),wf6(:,3),G0H4(50),m3h6x4(:,71),heltab2x24(:,:,979))
  call Hloop_A_Q(ntryL,G0H4(50),18,nMT,G1H4(36),n2h4(310))
  Gcoeff(:)%j = (-(c(88)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1002),h0tab(:,1002),[18,1,8,4],[nMH,nMB,nMB,nMB],4,1,wf6(:,3))
  call Hloop_QA_S(ntryL,G0H24(1),wf6(:,3),G0H4(50),ngH,m3h6x4(:,72),heltab2x24(:,:,980))
  Gcoeff(:)%j = (c(88)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1003),h0tab(:,1003),[18,1,8,4],[nMZ,nMB,nMB,nMB],4,1,wf6(:,3))
  call Hloop_QA_S(ntryL,G0H24(1),wf6(:,3),G0H4(51),ngX,m3h6x4(:,73),heltab2x24(:,:,981))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1004),h0tab(:,1004),[18,1,8,4],[nMW,nMT,nMT,nMT],4,1,wf6(:,3))
  call Hloop_QA_S(ntryL,G0H24(1),wf6(:,3),G0H4(52),ngPbt,m3h6x4(:,74),heltab2x24(:,:,982))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1005),h0tab(:,1005),[18,1,8,4],[nMT,nMW,nMW,nMW],4,1,wf6(:,3))
  call Hloop_SA_Q(ntryL,G0H24(1),wf6(:,3),G0H4(53),ngPbt,m3h6x4(:,75),heltab2x24(:,:,983))
  call Hloop_A_Q(ntryL,G0H4(53),18,nMT,G1H4(63),n2h4(311))
  Gcoeff(:)%j = (c(208)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1006),h0tab(:,1006),[18,1,8,4],[0,nMB,nMB,nMB],4,1,wf6(:,3))
  call Hloop_QA_V(ntryL,G0H24(1),wf6(:,3),G0H4(53),m3h6x4(:,76),heltab2x24(:,:,984))
  Gcoeff(:)%j = (c(209)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1007),h0tab(:,1007),[18,1,8,4],[nMZ,nMB,nMB,nMB],4,1,wf6(:,3))
  call Hloop_QA_Z(ntryL,G0H24(1),wf6(:,3),G0H4(54),ngZd,m3h6x4(:,77),heltab2x24(:,:,985))
  Gcoeff(:)%j = (-(c(121)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1008),h0tab(:,1008),[18,1,8,4],[nMW,nMT,nMT,nMT],4,1,wf6(:,3))
  call Hloop_QA_W(ntryL,G0H24(1),wf6(:,3),G0H4(55),m3h6x4(:,78),heltab2x24(:,:,986))
  Gcoeff(:)%j = (c(210)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1009),h0tab(:,1009),[18,1,8,4],[0,nMB,nMB,nMB],4,1,wf6(:,3))
  call Hloop_QA_V(ntryL,G0H24(1),wf6(:,3),G0H4(56),m3h6x4(:,79),heltab2x24(:,:,987))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1010),h0tab(:,1010),[18,1,8,4],[nMT,nMW,nMW,nMW],4,1,wf6(:,3))
  call Hloop_WA_Q(ntryL,G0H24(1),wf6(:,3),G0H4(57),m3h6x4(:,80),heltab2x24(:,:,988))
  call Hloop_A_Q(ntryL,G0H4(57),18,nMT,G1H4(51),n2h4(312))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1011),h0tab(:,1011),[18,1,8,4],[nMT,nMW,nMW,nMW],4,1,wf6(:,3))
  call Hloop_SA_Q(ntryL,G0H24(1),wf6(:,3),G0H4(57),ngPbt,m3h6x4(:,81),heltab2x24(:,:,989))
  call Hloop_A_Q(ntryL,G0H4(57),18,nMT,G1H4(26),n2h4(313))
  Gcoeff(:)%j = (c(113)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1012),h0tab(:,1012),[18,1,8,4],[nMT,nMW,nMW,nMW],4,1,wf6(:,3))
  call Hloop_SA_Q(ntryL,G0H24(1),wf6(:,3),G0H4(57),ngPbt,m3h6x4(:,82),heltab2x24(:,:,990))
  call Hloop_A_Q(ntryL,G0H4(57),18,nMT,G1H4(71),n2h4(314))
  Gcoeff(:)%j = (-(c(127)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1013),h0tab(:,1013),[18,1,8,4],[nMT,nMW,nMW,nMW],4,1,wf6(:,3))
  call Hloop_WA_Q(ntryL,G0H24(1),wf6(:,3),G0H4(57),m3h6x4(:,83),heltab2x24(:,:,991))
  call Hloop_A_Q(ntryL,G0H4(57),18,nMT,G1H4(55),n2h4(315))
  Gcoeff(:)%j = (c(125)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1014),h0tab(:,1014),[18,1,8,4],[nMT,nMW,nMW,nMW],4,1,wf6(:,3))
  call Hloop_WA_Q(ntryL,G0H24(1),wf6(:,3),G0H4(57),m3h6x4(:,84),heltab2x24(:,:,992))
  call Hloop_A_Q(ntryL,G0H4(57),18,nMT,G1H4(72),n2h4(316))
  Gcoeff(:)%j = (-(c(101)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1015),h0tab(:,1015),[18,1,8,4],[nMT,nMW,nMW,nMW],4,1,wf6(:,3))
  call Hloop_SA_Q(ntryL,G0H24(1),wf6(:,3),G0H4(57),ngPbt,m3h6x4(:,85),heltab2x24(:,:,993))
  call Hloop_A_Q(ntryL,G0H4(57),18,nMT,G1H4(65),n2h4(317))
  Gcoeff(:)%j = (-(c(127)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1016),h0tab(:,1016),[18,1,8,4],[nMT,nMW,nMW,nMW],4,1,wf6(:,3))
  call Hloop_WA_Q(ntryL,G0H24(1),wf6(:,3),G0H4(57),m3h6x4(:,86),heltab2x24(:,:,994))
  call Hloop_A_Q(ntryL,G0H4(57),18,nMT,G1H4(81),n2h4(318))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1017),h0tab(:,1017),[20,2,1,8],[nMB,nMH,nMB,nMB],4,1,wf3(:,1))
  call Hloop_QS_A(ntryL,G0H24(1),wf3(:,1),G0H8(245),ngX,m3h3x8(:,909),heltab2x24(:,:,995))
  call Hloop_Q_A(ntryL,G0H8(245),20,nMB,G1H8(445),n2h8(261))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1018),h0tab(:,1018),[20,2,1,8],[nMB,nMZ,nMB,nMB],4,1,wf3(:,1))
  call Hloop_QS_A(ntryL,G0H24(1),wf3(:,1),G0H8(245),ngX,m3h3x8(:,910),heltab2x24(:,:,996))
  call Hloop_Q_A(ntryL,G0H8(245),20,nMB,G1H8(446),n2h8(262))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1019),h0tab(:,1019),[20,2,1,8],[nMT,nMW,nMT,nMT],4,1,wf3(:,1))
  call Hloop_QS_A(ntryL,G0H24(1),wf3(:,1),G0H8(245),ngX,m3h3x8(:,911),heltab2x24(:,:,997))
  call Hloop_Q_A(ntryL,G0H8(245),20,nMT,G1H8(447),n2h8(263))
  Gcoeff(:)%j = (-(c(152)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1020),h0tab(:,1020),[20,2,1,8],[nMB,0,nMB,nMB],4,1,wf3(:,1))
  call Hloop_QS_A(ntryL,G0H24(1),wf3(:,1),G0H8(245),ngX,m3h3x8(:,912),heltab2x24(:,:,998))
  call Hloop_Q_A(ntryL,G0H8(245),20,nMB,G1H8(448),n2h8(264))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1021),h0tab(:,1021),[20,2,1,8],[nMB,nMZ,nMB,nMB],4,1,wf3(:,1))
  call Hloop_QS_A(ntryL,G0H24(1),wf3(:,1),G0H8(245),ngX,m3h3x8(:,913),heltab2x24(:,:,999))
  call Hloop_Q_A(ntryL,G0H8(245),20,nMB,G1H8(449),n2h8(265))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1022),h0tab(:,1022),[20,2,1,8],[nMT,nMW,nMT,nMT],4,1,wf3(:,1))
  call Hloop_QS_A(ntryL,G0H24(1),wf3(:,1),G0H8(245),ngX,m3h3x8(:,914),heltab2x24(:,:,1000))
  call Hloop_Q_A(ntryL,G0H8(245),20,nMT,G1H8(450),n2h8(266))
  Gcoeff(:)%j = (-(c(159)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1023),h0tab(:,1023),[20,2,1,8],[nMB,0,nMB,nMB],4,1,wf3(:,1))
  call Hloop_QS_A(ntryL,G0H24(1),wf3(:,1),G0H8(245),ngX,m3h3x8(:,915),heltab2x24(:,:,1001))
  call Hloop_Q_A(ntryL,G0H8(245),20,nMB,G1H8(451),n2h8(267))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1024),h0tab(:,1024),[20,2,1,8],[nMW,nMT,nMW,nMW],4,1,wf3(:,1))
  call Hloop_VT_S(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(452),m3h3x8(:,916),heltab2x24(:,:,1002))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1025),h0tab(:,1025),[20,2,1,8],[nMW,nMT,nMW,nMW],4,1,wf3(:,1))
  call Hloop_ST_V(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(453),m3h3x8(:,917),heltab2x24(:,:,1003))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1026),h0tab(:,1026),[20,2,1,8],[nMW,nMT,nMW,nMW],4,1,wf3(:,1))
  call Hloop_VT_S(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(454),m3h3x8(:,918),heltab2x24(:,:,1004))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1027),h0tab(:,1027),[20,2,1,8],[nMW,nMT,nMW,nMW],4,1,wf3(:,1))
  call Hloop_ST_V(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(455),m3h3x8(:,919),heltab2x24(:,:,1005))
  Gcoeff(:)%j = (-(c(112)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1028),h0tab(:,1028),[20,2,1,8],[nMB,nMH,nMB,nMB],4,1,wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,2),G0H8(245),ngZd,m3h3x8(:,920),heltab2x24(:,:,1006))
  call Hloop_Q_A(ntryL,G0H8(245),20,nMB,G1H8(456),n2h8(268))
  Gcoeff(:)%j = (c(112)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1029),h0tab(:,1029),[20,2,1,8],[nMB,nMZ,nMB,nMB],4,1,wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,2),G0H8(245),ngZd,m3h3x8(:,921),heltab2x24(:,:,1007))
  call Hloop_Q_A(ntryL,G0H8(245),20,nMB,G1H8(457),n2h8(269))
  Gcoeff(:)%j = (-(c(103)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1030),h0tab(:,1030),[20,2,1,8],[nMT,nMW,nMT,nMT],4,1,wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,2),G0H8(245),ngZu,m3h3x8(:,922),heltab2x24(:,:,1008))
  call Hloop_Q_A(ntryL,G0H8(245),20,nMT,G1H8(458),n2h8(270))
  Gcoeff(:)%j = (c(261)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1031),h0tab(:,1031),[20,2,1,8],[nMW,nMT,nMW,nMW],4,1,wf3(:,2))
  call Hloop_TV_S(ntryL,G0H24(1),0,wf3(:,2),20,G1H8(459),m3h3x8(:,923),heltab2x24(:,:,1009))
  Gcoeff(:)%j = (c(216)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1032),h0tab(:,1032),[20,2,1,8],[nMB,0,nMB,nMB],4,1,wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,2),G0H8(245),ngZd,m3h3x8(:,924),heltab2x24(:,:,1010))
  call Hloop_Q_A(ntryL,G0H8(245),20,nMB,G1H8(460),n2h8(271))
  Gcoeff(:)%j = (c(219)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1033),h0tab(:,1033),[20,2,1,8],[nMB,nMZ,nMB,nMB],4,1,wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,2),G0H8(245),ngZd,m3h3x8(:,925),heltab2x24(:,:,1011))
  call Hloop_Q_A(ntryL,G0H8(245),20,nMB,G1H8(461),n2h8(272))
  Gcoeff(:)%j = (-(c(133)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1034),h0tab(:,1034),[20,2,1,8],[nMT,nMW,nMT,nMT],4,1,wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,2),G0H8(245),ngZu,m3h3x8(:,926),heltab2x24(:,:,1012))
  call Hloop_Q_A(ntryL,G0H8(245),20,nMT,G1H8(462),n2h8(273))
  Gcoeff(:)%j = (c(220)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1035),h0tab(:,1035),[20,2,1,8],[nMB,0,nMB,nMB],4,1,wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H24(1),wf3(:,2),G0H8(245),ngZd,m3h3x8(:,927),heltab2x24(:,:,1013))
  call Hloop_Q_A(ntryL,G0H8(245),20,nMB,G1H8(463),n2h8(274))
  Gcoeff(:)%j = (-(c(175)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1036),h0tab(:,1036),[20,2,1,8],[nMW,nMT,nMW,nMW],4,1,wf3(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),wf3(:,2),G0H8(245),m3h3x8(:,928),heltab2x24(:,:,1014))
  Gcoeff(:)%j = (c(175)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1037),h0tab(:,1037),[20,2,1,8],[nMW,nMT,nMW,nMW],4,1,wf3(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),wf3(:,2),G0H8(246),m3h3x8(:,929),heltab2x24(:,:,1015))
  Gcoeff(:)%j = (-(c(288)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1038),h0tab(:,1038),[20,2,1,8],[nMW,nMT,nMW,nMW],4,1,wf3(:,2))
  call Hloop_TV_S(ntryL,G0H24(1),0,wf3(:,2),20,G1H8(464),m3h3x8(:,930),heltab2x24(:,:,1016))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1039),h0tab(:,1039),[20,2,1,8],[nMW,nMT,nMW,nMW],4,1,wf3(:,2))
  call Hloop_UV_W(ntryL,G0H24(1),0,wf3(:,2),20,G1H8(465),m3h3x8(:,931),heltab2x24(:,:,1017))
  Gcoeff(:)%j = (-(c(175)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1040),h0tab(:,1040),[20,2,1,8],[nMW,nMT,nMW,nMW],4,1,wf3(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),wf3(:,2),G0H8(247),m3h3x8(:,932),heltab2x24(:,:,1018))
  Gcoeff(:)%j = (-(c(202)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1041),h0tab(:,1041),[20,2,1,8],[nMW,nMT,nMW,nMW],4,1,wf3(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),wf3(:,2),G0H8(248),m3h3x8(:,933),heltab2x24(:,:,1019))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1042),h0tab(:,1042),[20,2,1,8],[nMW,nMT,nMW,nMW],4,1,wf3(:,2))
  call Hloop_UV_W(ntryL,G0H24(1),0,wf3(:,2),20,G1H8(466),m3h3x8(:,934),heltab2x24(:,:,1020))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1043),h0tab(:,1043),[20,1,2,8],[nMB,nMH,nMB,nMB],4,1,wf3(:,1))
  call Hloop_AS_Q(ntryL,G0H24(1),wf3(:,1),G0H8(249),ngX,m3h3x8(:,935),heltab2x24(:,:,1021))
  call Hloop_A_Q(ntryL,G0H8(249),20,nMB,G1H8(467),n2h8(275))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1044),h0tab(:,1044),[20,1,2,8],[nMB,nMZ,nMB,nMB],4,1,wf3(:,1))
  call Hloop_AS_Q(ntryL,G0H24(1),wf3(:,1),G0H8(249),ngX,m3h3x8(:,936),heltab2x24(:,:,1022))
  call Hloop_A_Q(ntryL,G0H8(249),20,nMB,G1H8(468),n2h8(276))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1045),h0tab(:,1045),[20,1,2,8],[nMT,nMW,nMT,nMT],4,1,wf3(:,1))
  call Hloop_AS_Q(ntryL,G0H24(1),wf3(:,1),G0H8(249),ngX,m3h3x8(:,937),heltab2x24(:,:,1023))
  call Hloop_A_Q(ntryL,G0H8(249),20,nMT,G1H8(469),n2h8(277))
  Gcoeff(:)%j = (-(c(152)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1046),h0tab(:,1046),[20,1,2,8],[nMB,0,nMB,nMB],4,1,wf3(:,1))
  call Hloop_AS_Q(ntryL,G0H24(1),wf3(:,1),G0H8(249),ngX,m3h3x8(:,938),heltab2x24(:,:,1024))
  call Hloop_A_Q(ntryL,G0H8(249),20,nMB,G1H8(470),n2h8(278))
  Gcoeff(:)%j = (-(c(154)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1047),h0tab(:,1047),[20,1,2,8],[nMB,nMZ,nMB,nMB],4,1,wf3(:,1))
  call Hloop_AS_Q(ntryL,G0H24(1),wf3(:,1),G0H8(249),ngX,m3h3x8(:,939),heltab2x24(:,:,1025))
  call Hloop_A_Q(ntryL,G0H8(249),20,nMB,G1H8(471),n2h8(279))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1048),h0tab(:,1048),[20,1,2,8],[nMT,nMW,nMT,nMT],4,1,wf3(:,1))
  call Hloop_AS_Q(ntryL,G0H24(1),wf3(:,1),G0H8(249),ngX,m3h3x8(:,940),heltab2x24(:,:,1026))
  call Hloop_A_Q(ntryL,G0H8(249),20,nMT,G1H8(472),n2h8(280))
  Gcoeff(:)%j = (-(c(159)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1049),h0tab(:,1049),[20,1,2,8],[nMB,0,nMB,nMB],4,1,wf3(:,1))
  call Hloop_AS_Q(ntryL,G0H24(1),wf3(:,1),G0H8(249),ngX,m3h3x8(:,941),heltab2x24(:,:,1027))
  call Hloop_A_Q(ntryL,G0H8(249),20,nMB,G1H8(473),n2h8(281))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1050),h0tab(:,1050),[20,1,2,8],[nMW,nMT,nMW,nMW],4,1,wf3(:,1))
  call Hloop_VT_S(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(474),m3h3x8(:,942),heltab2x24(:,:,1028))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1051),h0tab(:,1051),[20,1,2,8],[nMW,nMT,nMW,nMW],4,1,wf3(:,1))
  call Hloop_ST_V(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(475),m3h3x8(:,943),heltab2x24(:,:,1029))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1052),h0tab(:,1052),[20,1,2,8],[nMW,nMT,nMW,nMW],4,1,wf3(:,1))
  call Hloop_VT_S(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(476),m3h3x8(:,944),heltab2x24(:,:,1030))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1053),h0tab(:,1053),[20,1,2,8],[nMW,nMT,nMW,nMW],4,1,wf3(:,1))
  call Hloop_ST_V(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(477),m3h3x8(:,945),heltab2x24(:,:,1031))
  Gcoeff(:)%j = (-(c(112)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1054),h0tab(:,1054),[20,1,2,8],[nMB,nMH,nMB,nMB],4,1,wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,2),G0H8(249),ngZd,m3h3x8(:,946),heltab2x24(:,:,1032))
  call Hloop_A_Q(ntryL,G0H8(249),20,nMB,G1H8(478),n2h8(282))
  Gcoeff(:)%j = (c(112)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1055),h0tab(:,1055),[20,1,2,8],[nMB,nMZ,nMB,nMB],4,1,wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,2),G0H8(249),ngZd,m3h3x8(:,947),heltab2x24(:,:,1033))
  call Hloop_A_Q(ntryL,G0H8(249),20,nMB,G1H8(479),n2h8(283))
  Gcoeff(:)%j = (-(c(103)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1056),h0tab(:,1056),[20,1,2,8],[nMT,nMW,nMT,nMT],4,1,wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,2),G0H8(249),ngZu,m3h3x8(:,948),heltab2x24(:,:,1034))
  call Hloop_A_Q(ntryL,G0H8(249),20,nMT,G1H8(480),n2h8(284))
  Gcoeff(:)%j = (c(261)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1057),h0tab(:,1057),[20,1,2,8],[nMW,nMT,nMW,nMW],4,1,wf3(:,2))
  call Hloop_SV_T(ntryL,G0H24(1),0,wf3(:,2),20,G1H8(481),m3h3x8(:,949),heltab2x24(:,:,1035))
  Gcoeff(:)%j = (c(216)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1058),h0tab(:,1058),[20,1,2,8],[nMB,0,nMB,nMB],4,1,wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,2),G0H8(249),ngZd,m3h3x8(:,950),heltab2x24(:,:,1036))
  call Hloop_A_Q(ntryL,G0H8(249),20,nMB,G1H8(482),n2h8(285))
  Gcoeff(:)%j = (c(219)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1059),h0tab(:,1059),[20,1,2,8],[nMB,nMZ,nMB,nMB],4,1,wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,2),G0H8(249),ngZd,m3h3x8(:,951),heltab2x24(:,:,1037))
  call Hloop_A_Q(ntryL,G0H8(249),20,nMB,G1H8(483),n2h8(286))
  Gcoeff(:)%j = (-(c(133)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1060),h0tab(:,1060),[20,1,2,8],[nMT,nMW,nMT,nMT],4,1,wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,2),G0H8(249),ngZu,m3h3x8(:,952),heltab2x24(:,:,1038))
  call Hloop_A_Q(ntryL,G0H8(249),20,nMT,G1H8(484),n2h8(287))
  Gcoeff(:)%j = (c(220)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1061),h0tab(:,1061),[20,1,2,8],[nMB,0,nMB,nMB],4,1,wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,2),G0H8(249),ngZd,m3h3x8(:,953),heltab2x24(:,:,1039))
  call Hloop_A_Q(ntryL,G0H8(249),20,nMB,G1H8(485),n2h8(288))
  Gcoeff(:)%j = (-(c(175)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1062),h0tab(:,1062),[20,1,2,8],[nMW,nMT,nMW,nMW],4,1,wf3(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),wf3(:,2),G0H8(249),m3h3x8(:,954),heltab2x24(:,:,1040))
  Gcoeff(:)%j = (c(288)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1063),h0tab(:,1063),[20,1,2,8],[nMW,nMT,nMW,nMW],4,1,wf3(:,2))
  call Hloop_SV_T(ntryL,G0H24(1),0,wf3(:,2),20,G1H8(486),m3h3x8(:,955),heltab2x24(:,:,1041))
  Gcoeff(:)%j = (-(c(175)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1064),h0tab(:,1064),[20,1,2,8],[nMW,nMT,nMW,nMW],4,1,wf3(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),wf3(:,2),G0H8(250),m3h3x8(:,956),heltab2x24(:,:,1042))
  Gcoeff(:)%j = (c(175)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1065),h0tab(:,1065),[20,1,2,8],[nMW,nMT,nMW,nMW],4,1,wf3(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),wf3(:,2),G0H8(251),m3h3x8(:,957),heltab2x24(:,:,1043))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1066),h0tab(:,1066),[20,1,2,8],[nMW,nMT,nMW,nMW],4,1,wf3(:,2))
  call Hloop_UW_V(ntryL,G0H24(1),0,wf3(:,2),20,G1H8(487),m3h3x8(:,958),heltab2x24(:,:,1044))
  Gcoeff(:)%j = (-(c(202)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1067),h0tab(:,1067),[20,1,2,8],[nMW,nMT,nMW,nMW],4,1,wf3(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),wf3(:,2),G0H8(252),m3h3x8(:,959),heltab2x24(:,:,1045))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1068),h0tab(:,1068),[20,1,2,8],[nMW,nMT,nMW,nMW],4,1,wf3(:,2))
  call Hloop_UW_V(ntryL,G0H24(1),0,wf3(:,2),20,G1H8(488),m3h3x8(:,960),heltab2x24(:,:,1046))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1069),h0tab(:,1069),[20,1,8,2],[nMH,nMB,nMB,nMZ],4,1,wf3(:,1))
  call Hloop_SS_S(ntryL,G0H24(1),wf3(:,1),G0H8(253),m3h3x8(:,961),heltab2x24(:,:,1047))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1070),h0tab(:,1070),[20,1,8,2],[nMZ,nMB,nMB,nMH],4,1,wf3(:,1))
  call Hloop_SS_S(ntryL,G0H24(1),wf3(:,1),G0H8(254),m3h3x8(:,962),heltab2x24(:,:,1048))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1071),h0tab(:,1071),[20,1,8,2],[nMT,nMW,nMW,nMT],4,1,wf3(:,1))
  call Hloop_AS_Q(ntryL,G0H24(1),wf3(:,1),G0H8(255),ngX,m3h3x8(:,963),heltab2x24(:,:,1049))
  call Hloop_A_Q(ntryL,G0H8(255),20,nMT,G1H8(489),n2h8(289))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1072),h0tab(:,1072),[20,1,8,2],[nMH,nMB,nMB,nMZ],4,1,wf3(:,1))
  call Hloop_VS_T(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(490),m3h3x8(:,964),heltab2x24(:,:,1050))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1073),h0tab(:,1073),[20,1,8,2],[nMW,nMT,nMT,nMW],4,1,wf3(:,1))
  call Hloop_VT_S(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(491),m3h3x8(:,965),heltab2x24(:,:,1051))
  Gcoeff(:)%j = (-(c(109)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1074),h0tab(:,1074),[20,1,8,2],[nMZ,nMB,nMB,nMH],4,1,wf3(:,1))
  call Hloop_TS_V(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(492),m3h3x8(:,966),heltab2x24(:,:,1052))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1075),h0tab(:,1075),[20,1,8,2],[nMW,nMT,nMT,nMW],4,1,wf3(:,1))
  call Hloop_ST_V(ntryL,G0H24(1),0,wf3(:,1),20,G1H8(493),m3h3x8(:,967),heltab2x24(:,:,1053))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1076),h0tab(:,1076),[20,1,8,2],[nMT,nMW,nMW,nMT],4,1,wf3(:,1))
  call Hloop_AS_Q(ntryL,G0H24(1),wf3(:,1),G0H8(255),ngX,m3h3x8(:,968),heltab2x24(:,:,1054))
  call Hloop_A_Q(ntryL,G0H8(255),20,nMT,G1H8(494),n2h8(290))
  Gcoeff(:)%j = (c(60)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1077),h0tab(:,1077),[20,1,8,2],[nMT,nMW,nMW,nMT],4,1,wf3(:,1))
  call Hloop_AS_Q(ntryL,G0H24(1),wf3(:,1),G0H8(255),ngX,m3h3x8(:,969),heltab2x24(:,:,1055))
  call Hloop_A_Q(ntryL,G0H8(255),20,nMT,G1H8(495),n2h8(291))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1078),h0tab(:,1078),[20,1,8,2],[nMT,nMW,nMW,nMT],4,1,wf3(:,1))
  call Hloop_AS_Q(ntryL,G0H24(1),wf3(:,1),G0H8(255),ngX,m3h3x8(:,970),heltab2x24(:,:,1056))
  call Hloop_A_Q(ntryL,G0H8(255),20,nMT,G1H8(496),n2h8(292))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1079),h0tab(:,1079),[20,1,8,2],[nMH,nMB,nMB,nMZ],4,1,wf3(:,2))
  call Hloop_SV_T(ntryL,G0H24(1),0,wf3(:,2),20,G1H8(497),m3h3x8(:,971),heltab2x24(:,:,1057))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1080),h0tab(:,1080),[20,1,8,2],[nMZ,nMB,nMB,nMH],4,1,wf3(:,2))
  call Hloop_TV_S(ntryL,G0H24(1),0,wf3(:,2),20,G1H8(498),m3h3x8(:,972),heltab2x24(:,:,1058))
  Gcoeff(:)%j = (c(260)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1081),h0tab(:,1081),[20,1,8,2],[nMW,nMT,nMT,nMW],4,1,wf3(:,2))
  call Hloop_SV_T(ntryL,G0H24(1),0,wf3(:,2),20,G1H8(499),m3h3x8(:,973),heltab2x24(:,:,1059))
  Gcoeff(:)%j = (-(c(104)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1082),h0tab(:,1082),[20,1,8,2],[nMT,nMW,nMW,nMT],4,1,wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,2),G0H8(255),ngZu,m3h3x8(:,974),heltab2x24(:,:,1060))
  call Hloop_A_Q(ntryL,G0H8(255),20,nMT,G1H8(500),n2h8(293))
  Gcoeff(:)%j = (-(c(142)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1083),h0tab(:,1083),[20,1,8,2],[nMH,nMB,nMB,nMZ],4,1,wf3(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),wf3(:,2),G0H8(255),m3h3x8(:,975),heltab2x24(:,:,1061))
  Gcoeff(:)%j = (c(174)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1084),h0tab(:,1084),[20,1,8,2],[nMW,nMT,nMT,nMW],4,1,wf3(:,2))
  call Hloop_VV_S(ntryL,G0H24(1),wf3(:,2),G0H8(256),m3h3x8(:,976),heltab2x24(:,:,1062))
  Gcoeff(:)%j = (-(c(142)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1085),h0tab(:,1085),[20,1,8,2],[nMZ,nMB,nMB,nMH],4,1,wf3(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),wf3(:,2),G0H8(257),m3h3x8(:,977),heltab2x24(:,:,1063))
  Gcoeff(:)%j = (-(c(174)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1086),h0tab(:,1086),[20,1,8,2],[nMW,nMT,nMT,nMW],4,1,wf3(:,2))
  call Hloop_SV_V(ntryL,G0H24(1),wf3(:,2),G0H8(258),m3h3x8(:,978),heltab2x24(:,:,1064))
  Gcoeff(:)%j = (-(c(134)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1087),h0tab(:,1087),[20,1,8,2],[nMT,nMW,nMW,nMT],4,1,wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,2),G0H8(259),ngZu,m3h3x8(:,979),heltab2x24(:,:,1065))
  call Hloop_A_Q(ntryL,G0H8(259),20,nMT,G1H8(501),n2h8(294))
  Gcoeff(:)%j = (c(134)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1088),h0tab(:,1088),[20,1,8,2],[nMT,nMW,nMW,nMT],4,1,wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,2),G0H8(259),ngZu,m3h3x8(:,980),heltab2x24(:,:,1066))
  call Hloop_A_Q(ntryL,G0H8(259),20,nMT,G1H8(502),n2h8(295))
  Gcoeff(:)%j = (-(c(66)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1089),h0tab(:,1089),[20,1,8,2],[nMW,nMT,nMT,nMW],4,1,wf3(:,2))
  call Hloop_UW_V(ntryL,G0H24(1),0,wf3(:,2),20,G1H8(503),m3h3x8(:,981),heltab2x24(:,:,1067))
  Gcoeff(:)%j = (-(c(134)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1090),h0tab(:,1090),[20,1,8,2],[nMT,nMW,nMW,nMT],4,1,wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H24(1),wf3(:,2),G0H8(259),ngZu,m3h3x8(:,982),heltab2x24(:,:,1068))
  call Hloop_A_Q(ntryL,G0H8(259),20,nMT,G1H8(504),n2h8(296))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(474),[G1H8(23),G0H8(249),G0H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(475),[G1H8(27),G0H8(250),G0H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(476),[G1H8(32),G0H8(251),G0H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(477),[G1H8(1),G0H8(252),G0H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(452),[G1H8(40),G0H8(245),G0H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(453),[G1H8(46),G0H8(246),G0H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(454),[G1H8(52),G0H8(247),G0H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(455),[G1H8(59),G0H8(248),G0H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(43),[G1H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(127),[G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(41),[G1H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(47),[G1H4(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(199),[G1H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(200),[G1H4(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(32),[G1H4(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(202),[G1H4(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(490),[G0H8(255),G0H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(491),[G0H8(256),G0H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(492),[G0H8(257),G0H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(493),[G0H8(258),G0H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(87),[G1H8(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(88),[G1H8(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(91),[G1H8(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(92),[G1H8(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(96),[G1H8(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(98),[G1H8(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(100),[G1H8(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(45),[G0H8(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(47),[G0H8(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(49),[G0H8(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(51),[G0H8(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(53),[G0H8(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(55),[G0H8(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(110),[G1H8(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(112),[G1H8(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(114),[G1H8(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(133),[G1H8(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(134),[G1H8(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(137),[G1H8(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(138),[G1H8(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(144),[G1H8(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(146),[G1H8(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(24),[G0H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(26),[G0H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(28),[G0H8(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(30),[G0H8(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(2),[G1H8(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(4),[G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(24),[G1H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(25),[G1H8(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(29),[G1H8(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(30),[G1H8(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(70),[G0H8(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(36),[G1H8(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(37),[G1H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(39),[G1H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(82),[G0H8(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(84),[G0H8(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(86),[G0H8(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(88),[G0H8(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(42),[G1H8(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(44),[G1H8(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(47),[G1H8(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(92),[G0H8(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(173),[G1H8(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(174),[G1H8(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(177),[G1H8(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(178),[G1H8(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(192),[G1H8(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(194),[G1H8(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(110),[G0H8(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(112),[G0H8(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(114),[G0H8(113)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(116),[G0H8(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(196),[G1H8(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(198),[G1H8(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(223),[G1H8(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(224),[G1H8(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(227),[G1H8(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(228),[G1H8(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(232),[G1H8(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(234),[G1H8(233)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(130),[G0H8(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(240),[G1H8(239)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(138),[G0H8(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(140),[G0H8(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(142),[G0H8(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(144),[G0H8(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(242),[G1H8(241)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(152),[G0H8(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(248),[G1H8(247)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(250),[G1H8(249)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(269),[G1H8(267)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(270),[G1H8(268)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(273),[G1H8(271)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(274),[G1H8(272)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(280),[G1H8(279)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(282),[G1H8(281)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(166),[G0H8(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(168),[G0H8(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(170),[G0H8(169)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(172),[G0H8(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(300),[G1H8(299)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(302),[G1H8(301)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(318),[G1H8(315)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(329),[G1H8(326)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(348),[G1H8(345)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(359),[G1H8(356)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(385),[G1H8(382)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(399),[G1H8(396)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(426),[G1H8(423)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(440),[G1H8(437)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(26),[G0H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(33),[G0H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(49),[G0H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(56),[G0H4(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(456),[G1H8(445)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(457),[G1H8(446)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(458),[G1H8(447)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(463),[G1H8(460),G1H8(451),G1H8(448)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(461),[G1H8(449)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(462),[G1H8(450)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(478),[G1H8(467)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(479),[G1H8(468)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(480),[G1H8(469)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(485),[G1H8(482),G1H8(473),G1H8(470)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(483),[G1H8(471)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(484),[G1H8(472)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(497),[G0H8(253)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(498),[G0H8(254)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(500),[G1H8(489)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(501),[G1H8(494)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(502),[G1H8(495)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(504),[G1H8(496)])
  call Hloop_SQ_A(ntryL,G1H8(474),ex1(:),G1H4(83),ngPtb,m3h2x4(:,251),heltab2x8(:,:,295))
  call Hloop_Q_A(ntryL,G1H4(83),21,nMT,G2H4(6),n2h4(319))
  call Hloop_WQ_A(ntryL,G1H8(475),ex1(:),G1H4(69),m3h2x4(:,252),heltab2x8(:,:,296))
  call Hloop_Q_A(ntryL,G1H4(69),21,nMT,G2H4(7),n2h4(320))
  call Hloop_SQ_A(ntryL,G1H8(476),ex1(:),G1H4(85),ngPtb,m3h2x4(:,253),heltab2x8(:,:,297))
  call Hloop_Q_A(ntryL,G1H4(85),21,nMT,G2H4(5),n2h4(321))
  call Hloop_WQ_A(ntryL,G1H8(477),ex1(:),G1H4(68),m3h2x4(:,254),heltab2x8(:,:,298))
  call Hloop_Q_A(ntryL,G1H4(68),21,nMT,G2H4(54),n2h4(322))
  call Hloop_SA_Q(ntryL,G1H8(452),ex2(:),G1H4(86),ngPbt,m3h2x4(:,255),heltab2x8(:,:,299))
  call Hloop_A_Q(ntryL,G1H4(86),22,nMT,G2H4(42),n2h4(323))
  call Hloop_WA_Q(ntryL,G1H8(453),ex2(:),G1H4(39),m3h2x4(:,256),heltab2x8(:,:,300))
  call Hloop_A_Q(ntryL,G1H4(39),22,nMT,G2H4(49),n2h4(324))
  call Hloop_SA_Q(ntryL,G1H8(454),ex2(:),G1H4(75),ngPbt,m3h2x4(:,257),heltab2x8(:,:,301))
  call Hloop_A_Q(ntryL,G1H4(75),22,nMT,G2H4(9),n2h4(325))
  call Hloop_WA_Q(ntryL,G1H8(455),ex2(:),G1H4(129),m3h2x4(:,258),heltab2x8(:,:,302))
  call Hloop_A_Q(ntryL,G1H4(129),22,nMT,G2H4(12),n2h4(326))
  call Hloop_AS_Q(ntryL,G1H4(43),ex3(:),G1H4(37),ngH,m3h1x4(:,90),heltab2x4(:,:,431))
  call Hloop_A_Q(ntryL,G1H4(37),22,nMT,G2H4(10),n2h4(327))
  call Hloop_AS_Q(ntryL,G1H4(127),ex3(:),G1H4(130),ngH,m3h1x4(:,91),heltab2x4(:,:,432))
  call Hloop_A_Q(ntryL,G1H4(130),22,nMT,G2H4(11),n2h4(328))
  call Hloop_AS_Q(ntryL,G1H4(41),ex3(:),G1H4(74),ngH,m3h1x4(:,92),heltab2x4(:,:,433))
  call Hloop_A_Q(ntryL,G1H4(74),22,nMT,G2H4(13),n2h4(329))
  call Hloop_AS_Q(ntryL,G1H4(47),ex3(:),G1H4(132),ngH,m3h1x4(:,93),heltab2x4(:,:,434))
  call Hloop_A_Q(ntryL,G1H4(132),22,nMT,G2H4(16),n2h4(330))
  call Hloop_AV_Q(ntryL,G1H4(80),ex4(:),G1H2(139),m3h2x2(:,342),heltab2x4(:,:,435))
  call Hloop_A_Q(ntryL,G1H2(139),26,nMB,G2H2(30),n2h2(285))
  call Hloop_AV_Q(ntryL,G1H4(97),ex4(:),G1H2(149),m3h2x2(:,343),heltab2x4(:,:,436))
  call Hloop_A_Q(ntryL,G1H2(149),26,nMB,G2H2(31),n2h2(286))
  call Hloop_AV_Q(ntryL,G1H4(116),ex4(:),G1H2(157),m3h2x2(:,344),heltab2x4(:,:,437))
  call Hloop_A_Q(ntryL,G1H2(157),26,nMT,G2H2(44),n2h2(287))
  call Hloop_AV_Q(ntryL,G1H4(7),ex4(:),G1H2(167),m3h2x2(:,345),heltab2x4(:,:,438))
  call Hloop_A_Q(ntryL,G1H2(167),26,nMT,G2H2(45),n2h2(288))
  call Hloop_AV_Q(ntryL,G1H4(4),ex4(:),G1H2(175),m3h2x2(:,346),heltab2x4(:,:,439))
  call Hloop_A_Q(ntryL,G1H2(175),26,nMB,G2H2(5),n2h2(289))
  call Hloop_AV_Q(ntryL,G1H4(13),ex4(:),G1H2(185),m3h2x2(:,347),heltab2x4(:,:,440))
  call Hloop_A_Q(ntryL,G1H2(185),26,nMT,G2H2(8),n2h2(290))
  call Hloop_AV_Q(ntryL,G1H4(20),ex4(:),G1H2(193),m3h2x2(:,348),heltab2x4(:,:,441))
  call Hloop_A_Q(ntryL,G1H2(193),26,nMT,G2H2(9),n2h2(291))
  call Hloop_QS_A(ntryL,G1H4(199),ex3(:),G1H4(134),ngH,m3h1x4(:,94),heltab2x4(:,:,442))
  call Hloop_Q_A(ntryL,G1H4(134),21,nMT,G2H4(14),n2h4(331))
  call Hloop_QS_A(ntryL,G1H4(200),ex3(:),G1H4(79),ngH,m3h1x4(:,95),heltab2x4(:,:,443))
  call Hloop_Q_A(ntryL,G1H4(79),21,nMT,G2H4(15),n2h4(332))
  call Hloop_QS_A(ntryL,G1H4(32),ex3(:),G1H4(136),ngH,m3h1x4(:,96),heltab2x4(:,:,444))
  call Hloop_Q_A(ntryL,G1H4(136),21,nMT,G2H4(18),n2h4(333))
  call Hloop_QS_A(ntryL,G1H4(202),ex3(:),G1H4(88),ngH,m3h1x4(:,97),heltab2x4(:,:,445))
  call Hloop_Q_A(ntryL,G1H4(88),21,nMT,G2H4(17),n2h4(334))
  call Hloop_QS_A(ntryL,G1H4(90),ex3(:),G1H4(137),ngH,m3h1x4(:,98),heltab2x4(:,:,446))
  call Hloop_Q_A(ntryL,G1H4(137),21,nMB,G2H4(21),n2h4(335))
  call Hloop_QS_A(ntryL,G1H4(133),ex3(:),G1H4(93),ngH,m3h1x4(:,99),heltab2x4(:,:,447))
  call Hloop_Q_A(ntryL,G1H4(93),21,nMB,G2H4(22),n2h4(336))
  call Hloop_QS_A(ntryL,G1H4(139),ex3(:),G1H4(92),ngH,m3h1x4(:,100),heltab2x4(:,:,448))
  call Hloop_Q_A(ntryL,G1H4(92),21,nMT,G2H4(19),n2h4(337))
  call Hloop_QS_A(ntryL,G1H4(144),ex3(:),G1H4(141),ngH,m3h1x4(:,101),heltab2x4(:,:,449))
  call Hloop_Q_A(ntryL,G1H4(141),21,nMT,G2H4(24),n2h4(338))
  call Hloop_QV_A(ntryL,G1H4(104),ex4(:),G1H2(203),m3h2x2(:,349),heltab2x4(:,:,450))
  call Hloop_Q_A(ntryL,G1H2(203),25,nMB,G2H2(10),n2h2(292))
  call Hloop_QV_A(ntryL,G1H4(151),ex4(:),G1H2(211),m3h2x2(:,350),heltab2x4(:,:,451))
  call Hloop_Q_A(ntryL,G1H2(211),25,nMB,G2H2(13),n2h2(293))
  call Hloop_QV_A(ntryL,G1H4(157),ex4(:),G1H2(24),m3h2x2(:,351),heltab2x4(:,:,452))
  call Hloop_Q_A(ntryL,G1H2(24),25,nMT,G2H2(14),n2h2(294))
  call Hloop_QV_A(ntryL,G1H4(109),ex4(:),G1H2(252),m3h2x2(:,352),heltab2x4(:,:,453))
  call Hloop_Q_A(ntryL,G1H2(252),25,nMT,G2H2(15),n2h2(295))
  call Hloop_QV_A(ntryL,G1H4(166),ex4(:),G1H2(66),m3h2x2(:,353),heltab2x4(:,:,454))
  call Hloop_Q_A(ntryL,G1H2(66),25,nMB,G2H2(20),n2h2(296))
  call Hloop_QV_A(ntryL,G1H4(172),ex4(:),G1H2(77),m3h2x2(:,354),heltab2x4(:,:,455))
  call Hloop_Q_A(ntryL,G1H2(77),25,nMT,G2H2(68),n2h2(297))
  call Hloop_QV_A(ntryL,G1H4(176),ex4(:),G1H2(103),m3h2x2(:,355),heltab2x4(:,:,456))
  call Hloop_Q_A(ntryL,G1H2(103),25,nMT,G2H2(72),n2h2(298))
  call Hloop_QV_A(ntryL,G1H4(182),ex4(:),G1H2(3),m3h2x2(:,356),heltab2x4(:,:,457))
  call Hloop_Q_A(ntryL,G1H2(3),25,nMB,G2H2(74),n2h2(299))
  call Hloop_QV_A(ntryL,G1H4(188),ex4(:),G1H2(264),m3h2x2(:,357),heltab2x4(:,:,458))
  call Hloop_Q_A(ntryL,G1H2(264),25,nMB,G2H2(78),n2h2(300))
  call Hloop_QV_A(ntryL,G1H4(194),ex4(:),G1H2(279),m3h2x2(:,358),heltab2x4(:,:,459))
  call Hloop_Q_A(ntryL,G1H2(279),25,nMT,G2H2(140),n2h2(301))
  call Hloop_QV_A(ntryL,G1H4(198),ex4(:),G1H2(294),m3h2x2(:,359),heltab2x4(:,:,460))
  call Hloop_Q_A(ntryL,G1H2(294),25,nMT,G2H2(144),n2h2(302))
  call Hloop_SA_Q(ntryL,G0H4(1),ex2(:),G0H2(1),ngPbt,m3h2x2(:,360),heltab2x4(:,:,461))
  call Hloop_A_Q(ntryL,G0H2(1),26,nMT,G1H2(47),n2h2(303))
  call Hloop_SA_Q(ntryL,G0H4(2),ex2(:),G0H2(1),ngPbt,m3h2x2(:,361),heltab2x4(:,:,462))
  call Hloop_A_Q(ntryL,G0H2(1),26,nMT,G1H2(318),n2h2(304))
  call Hloop_WA_Q(ntryL,G0H4(3),ex2(:),G0H2(1),m3h2x2(:,362),heltab2x4(:,:,463))
  call Hloop_A_Q(ntryL,G0H2(1),26,nMT,G1H2(329),n2h2(305))
  call Hloop_WA_Q(ntryL,G0H4(4),ex2(:),G0H2(1),m3h2x2(:,363),heltab2x4(:,:,464))
  call Hloop_A_Q(ntryL,G0H2(1),26,nMT,G1H2(340),n2h2(306))
  call Hloop_SQ_A(ntryL,G0H4(5),ex1(:),G0H2(1),ngPtb,m3h2x2(:,364),heltab2x4(:,:,465))
  call Hloop_Q_A(ntryL,G0H2(1),25,nMT,G1H2(351),n2h2(307))
  call Hloop_SQ_A(ntryL,G0H4(6),ex1(:),G0H2(1),ngPtb,m3h2x2(:,365),heltab2x4(:,:,466))
  call Hloop_Q_A(ntryL,G0H2(1),25,nMT,G1H2(362),n2h2(308))
  call Hloop_WQ_A(ntryL,G0H4(7),ex1(:),G0H2(1),m3h2x2(:,366),heltab2x4(:,:,467))
  call Hloop_Q_A(ntryL,G0H2(1),25,nMT,G1H2(383),n2h2(309))
  call Hloop_WQ_A(ntryL,G0H4(8),ex1(:),G0H2(1),m3h2x2(:,367),heltab2x4(:,:,468))
  call Hloop_Q_A(ntryL,G0H2(1),25,nMT,G1H2(394),n2h2(310))
  call Hloop_SQ_A(ntryL,G0H4(9),ex1(:),G0H2(1),ngPtb,m3h2x2(:,368),heltab2x4(:,:,469))
  call Hloop_Q_A(ntryL,G0H2(1),25,nMT,G1H2(405),n2h2(311))
  call Hloop_WQ_A(ntryL,G0H4(10),ex1(:),G0H2(1),m3h2x2(:,369),heltab2x4(:,:,470))
  call Hloop_Q_A(ntryL,G0H2(1),25,nMT,G1H2(416),n2h2(312))
  call Hloop_SQ_A(ntryL,G1H8(490),ex1(:),G1H4(98),ngH,m3h2x4(:,259),heltab2x8(:,:,303))
  call Hloop_Q_A(ntryL,G1H4(98),21,nMB,G2H4(25),n2h4(339))
  call Hloop_SQ_A(ntryL,G1H8(491),ex1(:),G1H4(142),ngPtb,m3h2x4(:,260),heltab2x8(:,:,304))
  call Hloop_Q_A(ntryL,G1H4(142),21,nMT,G2H4(30),n2h4(340))
  call Hloop_ZQ_A(ntryL,G1H8(492),ex1(:),G1H4(111),ngZd,m3h2x4(:,261),heltab2x8(:,:,305))
  call Hloop_Q_A(ntryL,G1H4(111),21,nMB,G2H4(31),n2h4(341))
  call Hloop_WQ_A(ntryL,G1H8(493),ex1(:),G1H4(94),m3h2x4(:,262),heltab2x8(:,:,306))
  call Hloop_Q_A(ntryL,G1H4(94),21,nMT,G2H4(35),n2h4(342))
  call Hloop_SQ_A(ntryL,G0H8(20),ex1(:),G0H4(57),ngPtb,m3h2x4(:,263),heltab2x8(:,:,307))
  call Hloop_Q_A(ntryL,G0H4(57),17,nMT,G1H4(145),n2h4(343))
  call Hloop_SQ_A(ntryL,G1H8(63),ex1(:),G1H4(112),ngPtb,m3h2x4(:,264),heltab2x8(:,:,308))
  call Hloop_Q_A(ntryL,G1H4(112),17,nMT,G2H4(34),n2h4(344))
  call Hloop_WQ_A(ntryL,G1H8(64),ex1(:),G1H4(147),m3h2x4(:,265),heltab2x8(:,:,309))
  call Hloop_Q_A(ntryL,G1H4(147),17,nMT,G2H4(38),n2h4(345))
  call Hloop_WQ_A(ntryL,G0H8(21),ex1(:),G0H4(23),m3h2x4(:,266),heltab2x8(:,:,310))
  call Hloop_Q_A(ntryL,G0H4(23),17,nMT,G1H4(115),n2h4(346))
  call Hloop_SA_Q(ntryL,G0H8(22),ex2(:),G0H4(30),ngPbt,m3h2x4(:,267),heltab2x8(:,:,311))
  call Hloop_A_Q(ntryL,G0H4(30),18,nMT,G1H4(102),n2h4(347))
  call Hloop_SA_Q(ntryL,G1H8(68),ex2(:),G1H4(103),ngPbt,m3h2x4(:,268),heltab2x8(:,:,312))
  call Hloop_A_Q(ntryL,G1H4(103),18,nMT,G2H4(39),n2h4(348))
  call Hloop_WA_Q(ntryL,G1H8(66),ex2(:),G1H4(148),m3h2x4(:,269),heltab2x8(:,:,313))
  call Hloop_A_Q(ntryL,G1H4(148),18,nMT,G2H4(41),n2h4(349))
  call Hloop_WA_Q(ntryL,G0H8(23),ex2(:),G0H4(46),m3h2x4(:,270),heltab2x8(:,:,314))
  call Hloop_A_Q(ntryL,G0H4(46),18,nMT,G1H4(149),n2h4(350))
  call Hloop_AQ_S(ntryL,G1H8(67),ex1(:),G1H4(150),ngPtb,m3h2x4(:,271),heltab2x8(:,:,315))
  call Hloop_AQ_W(ntryL,G1H8(69),ex1(:),G1H4(152),m3h2x4(:,272),heltab2x8(:,:,316))
  call Hloop_QS_A(ntryL,G1H8(70),wf4(:,7),G1H2(427),ngH,m3h4x2(:,1),heltab2x8(:,:,317))
  call Hloop_Q_A(ntryL,G1H2(427),19,nML,G2H2(145),n2h2(313))
  call Hloop_AS_Q(ntryL,G1H8(71),wf4(:,7),G1H2(438),ngH,m3h4x2(:,2),heltab2x8(:,:,318))
  call Hloop_A_Q(ntryL,G1H2(438),19,nML,G2H2(109),n2h2(314))
  call Hloop_QS_A(ntryL,G1H8(72),wf4(:,7),G1H2(449),ngH,m3h4x2(:,3),heltab2x8(:,:,319))
  call Hloop_Q_A(ntryL,G1H2(449),19,nMT,G2H2(193),n2h2(315))
  call Hloop_AS_Q(ntryL,G1H8(73),wf4(:,7),G1H2(460),ngH,m3h4x2(:,4),heltab2x8(:,:,320))
  call Hloop_A_Q(ntryL,G1H2(460),19,nMT,G2H2(196),n2h2(316))
  call Hloop_QS_A(ntryL,G1H8(74),wf4(:,7),G1H2(481),ngH,m3h4x2(:,5),heltab2x8(:,:,321))
  call Hloop_Q_A(ntryL,G1H2(481),19,nMB,G2H2(197),n2h2(317))
  call Hloop_AS_Q(ntryL,G1H8(75),wf4(:,7),G1H2(492),ngH,m3h4x2(:,6),heltab2x8(:,:,322))
  call Hloop_A_Q(ntryL,G1H2(492),19,nMB,G2H2(200),n2h2(318))
  call Hloop_QS_A(ntryL,G1H8(76),wf4(:,37),G1H2(503),ngX,m3h4x2(:,7),heltab2x8(:,:,323))
  call Hloop_Q_A(ntryL,G1H2(503),19,nML,G2H2(209),n2h2(319))
  call Hloop_AS_Q(ntryL,G1H8(77),wf4(:,37),G1H2(514),ngX,m3h4x2(:,8),heltab2x8(:,:,324))
  call Hloop_A_Q(ntryL,G1H2(514),19,nML,G2H2(214),n2h2(320))
  call Hloop_QS_A(ntryL,G1H8(78),wf4(:,37),G1H2(48),ngX,m3h4x2(:,9),heltab2x8(:,:,325))
  call Hloop_Q_A(ntryL,G1H2(48),19,nMT,G2H2(215),n2h2(321))
  call Hloop_AS_Q(ntryL,G1H8(79),wf4(:,37),G1H2(133),ngX,m3h4x2(:,10),heltab2x8(:,:,326))
  call Hloop_A_Q(ntryL,G1H2(133),19,nMT,G2H2(218),n2h2(322))
  call Hloop_QS_A(ntryL,G1H8(83),wf4(:,37),G1H2(217),ngX,m3h4x2(:,11),heltab2x8(:,:,327))
  call Hloop_Q_A(ntryL,G1H2(217),19,nMB,G2H2(2),n2h2(323))
  call Hloop_AS_Q(ntryL,G1H8(81),wf4(:,37),G1H2(140),ngX,m3h4x2(:,12),heltab2x8(:,:,328))
  call Hloop_A_Q(ntryL,G1H2(140),19,nMB,G2H2(3),n2h2(324))
  call Hloop_SS_S(ntryL,G1H8(82),wf4(:,7),G1H2(143),m3h4x2(:,13),heltab2x8(:,:,329))
  call Hloop_SS_S(ntryL,G1H8(84),wf4(:,7),G1H2(224),m3h4x2(:,14),heltab2x8(:,:,330))
  call Hloop_SS_S(ntryL,G1H8(87),wf4(:,7),G1H2(150),m3h4x2(:,15),heltab2x8(:,:,331))
  call Hloop_SS_S(ntryL,G1H8(88),wf4(:,7),G1H2(151),m3h4x2(:,16),heltab2x8(:,:,332))
  call Hloop_SS_S(ntryL,G1H8(91),wf4(:,37),G1H2(368),m3h4x2(:,17),heltab2x8(:,:,333))
  call Hloop_SS_S(ntryL,G1H8(92),wf4(:,37),G1H2(158),m3h4x2(:,18),heltab2x8(:,:,334))
  call Hloop_VS_V(ntryL,G1H8(93),wf4(:,7),G1H2(161),m3h4x2(:,19),heltab2x8(:,:,335))
  call Hloop_VS_V(ntryL,G1H8(94),wf4(:,7),G1H2(373),m3h4x2(:,20),heltab2x8(:,:,336))
  call Hloop_VT_S(ntryL,G0H8(38),16,wf4(:,7),3,G1H2(168),m3h4x2(:,21),heltab2x8(:,:,337))
  call Hloop_VT_S(ntryL,G0H8(39),16,wf4(:,7),3,G1H2(169),m3h4x2(:,22),heltab2x8(:,:,338))
  call Hloop_VT_S(ntryL,G0H8(40),16,wf4(:,37),3,G1H2(230),m3h4x2(:,23),heltab2x8(:,:,339))
  call Hloop_VT_S(ntryL,G0H8(41),16,wf4(:,37),3,G1H2(176),m3h4x2(:,24),heltab2x8(:,:,340))
  call Hloop_ST_V(ntryL,G1H8(96),16,wf4(:,7),3,G2H2(16),m3h4x2(:,25),heltab2x8(:,:,341))
  call Hloop_ST_V(ntryL,G1H8(98),16,wf4(:,37),3,G2H2(17),m3h4x2(:,26),heltab2x8(:,:,342))
  call Hloop_SS_S(ntryL,G0H8(42),wf4(:,7),G0H2(1),m3h4x2(:,27),heltab2x8(:,:,343))
  call Hloop_SS_S(ntryL,G0H8(43),wf4(:,7),G0H2(2),m3h4x2(:,28),heltab2x8(:,:,344))
  call Hloop_SS_S(ntryL,G1H8(100),wf4(:,7),G1H2(179),m3h4x2(:,29),heltab2x8(:,:,345))
  call Hloop_VS_V(ntryL,G0H8(45),wf4(:,7),G0H2(3),m3h4x2(:,30),heltab2x8(:,:,346))
  call Hloop_VT_S(ntryL,G1H8(101),16,wf4(:,7),3,G2H2(122),m3h4x2(:,31),heltab2x8(:,:,347))
  call Hloop_VT_S(ntryL,G1H8(102),16,wf4(:,7),3,G2H2(130),m3h4x2(:,32),heltab2x8(:,:,348))
  call Hloop_VT_S(ntryL,G1H8(103),16,wf4(:,37),3,G2H2(118),m3h4x2(:,33),heltab2x8(:,:,349))
  call Hloop_VT_S(ntryL,G1H8(104),16,wf4(:,37),3,G2H2(126),m3h4x2(:,34),heltab2x8(:,:,350))
  call Hloop_ST_V(ntryL,G0H8(47),16,wf4(:,7),3,G1H2(235),m3h4x2(:,35),heltab2x8(:,:,351))
  call Hloop_ST_V(ntryL,G0H8(49),16,wf4(:,37),3,G1H2(186),m3h4x2(:,36),heltab2x8(:,:,352))
  call Hloop_VT_S(ntryL,G0H8(51),16,wf4(:,7),3,G1H2(187),m3h4x2(:,37),heltab2x8(:,:,353))
  call Hloop_VT_S(ntryL,G0H8(53),16,wf4(:,37),3,G1H2(466),m3h4x2(:,38),heltab2x8(:,:,354))
  call Hloop_ST_V(ntryL,G1H8(105),16,wf4(:,7),3,G2H2(1),m3h4x2(:,39),heltab2x8(:,:,355))
  call Hloop_ST_V(ntryL,G1H8(106),16,wf4(:,7),3,G2H2(6),m3h4x2(:,40),heltab2x8(:,:,356))
  call Hloop_ST_V(ntryL,G1H8(107),16,wf4(:,37),3,G2H2(7),m3h4x2(:,41),heltab2x8(:,:,357))
  call Hloop_ST_V(ntryL,G1H8(108),16,wf4(:,37),3,G2H2(4),m3h4x2(:,42),heltab2x8(:,:,358))
  call Hloop_SS_S(ntryL,G0H8(55),wf4(:,7),G0H2(4),m3h4x2(:,43),heltab2x8(:,:,359))
  call Hloop_VS_V(ntryL,G1H8(110),wf4(:,7),G1H2(194),m3h4x2(:,44),heltab2x8(:,:,360))
  call Hloop_VS_V(ntryL,G0H8(56),wf4(:,7),G0H2(5),m3h4x2(:,45),heltab2x8(:,:,361))
  call Hloop_VS_V(ntryL,G0H8(57),wf4(:,7),G0H2(6),m3h4x2(:,46),heltab2x8(:,:,362))
  call Hloop_VT_S(ntryL,G1H8(112),16,wf4(:,7),3,G2H2(178),m3h4x2(:,47),heltab2x8(:,:,363))
  call Hloop_VT_S(ntryL,G1H8(114),16,wf4(:,37),3,G2H2(184),m3h4x2(:,48),heltab2x8(:,:,364))
  call Hloop_ST_V(ntryL,G0H8(58),16,wf4(:,7),3,G1H2(197),m3h4x2(:,49),heltab2x8(:,:,365))
  call Hloop_ST_V(ntryL,G0H8(59),16,wf4(:,7),3,G1H2(471),m3h4x2(:,50),heltab2x8(:,:,366))
  call Hloop_ST_V(ntryL,G0H8(60),16,wf4(:,37),3,G1H2(204),m3h4x2(:,51),heltab2x8(:,:,367))
  call Hloop_ST_V(ntryL,G0H8(61),16,wf4(:,37),3,G1H2(53),m3h4x2(:,52),heltab2x8(:,:,368))
  call Hloop_QV_A(ntryL,G1H8(115),wf4(:,38),G1H2(59),m3h4x2(:,53),heltab2x8(:,:,369))
  call Hloop_Q_A(ntryL,G1H2(59),19,nML,G2H2(175),n2h2(325))
  call Hloop_AV_Q(ntryL,G1H8(116),wf4(:,38),G1H2(60),m3h4x2(:,54),heltab2x8(:,:,370))
  call Hloop_A_Q(ntryL,G1H2(60),19,nML,G2H2(181),n2h2(326))
  call Hloop_QV_A(ntryL,G1H8(117),wf4(:,38),G1H2(268),m3h4x2(:,55),heltab2x8(:,:,371))
  call Hloop_Q_A(ntryL,G1H2(268),19,nMT,G2H2(11),n2h2(327))
  call Hloop_AV_Q(ntryL,G1H8(118),wf4(:,38),G1H2(284),m3h4x2(:,56),heltab2x8(:,:,372))
  call Hloop_A_Q(ntryL,G1H2(284),19,nMT,G2H2(12),n2h2(328))
  call Hloop_QV_A(ntryL,G1H8(119),wf4(:,38),G1H2(8),m3h4x2(:,57),heltab2x8(:,:,373))
  call Hloop_Q_A(ntryL,G1H2(8),19,nMB,G2H2(227),n2h2(329))
  call Hloop_AV_Q(ntryL,G1H8(120),wf4(:,38),G1H2(205),m3h4x2(:,58),heltab2x8(:,:,374))
  call Hloop_A_Q(ntryL,G1H2(205),19,nMB,G2H2(234),n2h2(330))
  call Hloop_QZ_A(ntryL,G1H8(121),wf4(:,39),G1H2(520),ngZl,m3h4x2(:,59),heltab2x8(:,:,375))
  call Hloop_Q_A(ntryL,G1H2(520),19,nML,G2H2(243),n2h2(331))
  call Hloop_AZ_Q(ntryL,G1H8(122),wf4(:,39),G1H2(212),ngZl,m3h4x2(:,60),heltab2x8(:,:,376))
  call Hloop_A_Q(ntryL,G1H2(212),19,nML,G2H2(246),n2h2(332))
  call Hloop_QZ_A(ntryL,G1H8(123),wf4(:,39),G1H2(215),ngZu,m3h4x2(:,61),heltab2x8(:,:,377))
  call Hloop_Q_A(ntryL,G1H2(215),19,nMT,G2H2(18),n2h2(333))
  call Hloop_AZ_Q(ntryL,G1H8(124),wf4(:,39),G1H2(525),ngZu,m3h4x2(:,62),heltab2x8(:,:,378))
  call Hloop_A_Q(ntryL,G1H2(525),19,nMT,G2H2(22),n2h2(334))
  call Hloop_QZ_A(ntryL,G1H8(125),wf4(:,39),G1H2(300),ngZd,m3h4x2(:,63),heltab2x8(:,:,379))
  call Hloop_Q_A(ntryL,G1H2(300),19,nMB,G2H2(24),n2h2(335))
  call Hloop_AZ_Q(ntryL,G1H8(126),wf4(:,39),G1H2(25),ngZd,m3h4x2(:,64),heltab2x8(:,:,380))
  call Hloop_A_Q(ntryL,G1H2(25),19,nMB,G2H2(26),n2h2(336))
  call Hloop_TV_S(ntryL,G1H8(127),16,wf4(:,38),3,G2H2(28),m3h4x2(:,65),heltab2x8(:,:,381))
  call Hloop_SV_T(ntryL,G1H8(128),16,wf4(:,38),3,G2H2(34),m3h4x2(:,66),heltab2x8(:,:,382))
  call Hloop_TV_S(ntryL,G1H8(129),16,wf4(:,39),3,G2H2(32),m3h4x2(:,67),heltab2x8(:,:,383))
  call Hloop_SV_T(ntryL,G1H8(130),16,wf4(:,39),3,G2H2(36),m3h4x2(:,68),heltab2x8(:,:,384))
  call Hloop_CV_D(ntryL,G1H8(133),16,wf4(:,38),3,G2H2(37),m3h4x2(:,69),heltab2x8(:,:,385))
  call Hloop_DV_C(ntryL,G1H8(134),16,wf4(:,38),G2H2(39),m3h4x2(:,70),heltab2x8(:,:,386))
  call Hloop_CV_D(ntryL,G1H8(137),16,wf4(:,39),3,G2H2(40),m3h4x2(:,71),heltab2x8(:,:,387))
  call Hloop_DV_C(ntryL,G1H8(138),16,wf4(:,39),G2H2(42),m3h4x2(:,72),heltab2x8(:,:,388))
  call Hloop_UV_W(ntryL,G1H8(139),16,wf4(:,38),3,G2H2(43),m3h4x2(:,73),heltab2x8(:,:,389))
  call Hloop_UW_V(ntryL,G1H8(140),16,wf4(:,38),3,G2H2(49),m3h4x2(:,74),heltab2x8(:,:,390))
  call Hloop_UV_W(ntryL,G1H8(141),16,wf4(:,39),3,G2H2(46),m3h4x2(:,75),heltab2x8(:,:,391))
  call Hloop_UW_V(ntryL,G1H8(142),16,wf4(:,39),3,G2H2(50),m3h4x2(:,76),heltab2x8(:,:,392))
  call Hloop_VV_S(ntryL,G0H8(74),wf4(:,38),G0H2(7),m3h4x2(:,77),heltab2x8(:,:,393))
  call Hloop_VV_S(ntryL,G0H8(75),wf4(:,38),G0H2(8),m3h4x2(:,78),heltab2x8(:,:,394))
  call Hloop_VV_S(ntryL,G0H8(76),wf4(:,39),G0H2(9),m3h4x2(:,79),heltab2x8(:,:,395))
  call Hloop_VV_S(ntryL,G0H8(77),wf4(:,39),G0H2(10),m3h4x2(:,80),heltab2x8(:,:,396))
  call Hloop_SV_V(ntryL,G1H8(144),wf4(:,38),G1H2(530),m3h4x2(:,81),heltab2x8(:,:,397))
  call Hloop_SV_V(ntryL,G1H8(146),wf4(:,39),G1H2(30),m3h4x2(:,82),heltab2x8(:,:,398))
  call Hloop_TV_S(ntryL,G0H8(78),16,wf4(:,38),3,G1H2(21),m3h4x2(:,83),heltab2x8(:,:,399))
  call Hloop_SV_T(ntryL,G0H8(79),16,wf4(:,38),3,G1H2(535),m3h4x2(:,84),heltab2x8(:,:,400))
  call Hloop_TV_S(ntryL,G0H8(2),16,wf4(:,39),3,G1H2(218),m3h4x2(:,85),heltab2x8(:,:,401))
  call Hloop_SV_T(ntryL,G0H8(1),16,wf4(:,39),3,G1H2(227),m3h4x2(:,86),heltab2x8(:,:,402))
  call Hloop_TV_S(ntryL,G1H8(147),16,wf4(:,38),3,G2H2(51),m3h4x2(:,87),heltab2x8(:,:,403))
  call Hloop_SV_T(ntryL,G1H8(148),16,wf4(:,38),3,G2H2(53),m3h4x2(:,88),heltab2x8(:,:,404))
  call Hloop_TV_S(ntryL,G1H8(149),16,wf4(:,39),3,G2H2(54),m3h4x2(:,89),heltab2x8(:,:,405))
  call Hloop_SV_T(ntryL,G1H8(150),16,wf4(:,39),3,G2H2(56),m3h4x2(:,90),heltab2x8(:,:,406))
  call Hloop_UV_W(ntryL,G0H8(3),16,wf4(:,38),3,G1H2(233),m3h4x2(:,91),heltab2x8(:,:,407))
  call Hloop_UW_V(ntryL,G0H8(4),16,wf4(:,38),3,G1H2(236),m3h4x2(:,92),heltab2x8(:,:,408))
  call Hloop_UV_W(ntryL,G0H8(5),16,wf4(:,39),3,G1H2(242),m3h4x2(:,93),heltab2x8(:,:,409))
  call Hloop_UW_V(ntryL,G0H8(6),16,wf4(:,39),3,G1H2(245),m3h4x2(:,94),heltab2x8(:,:,410))
  call Hloop_VV_S(ntryL,G1H8(151),wf4(:,38),G1H2(79),m3h4x2(:,95),heltab2x8(:,:,411))
  call Hloop_VV_S(ntryL,G1H8(152),wf4(:,38),G1H2(83),m3h4x2(:,96),heltab2x8(:,:,412))
  call Hloop_VV_S(ntryL,G1H8(153),wf4(:,39),G1H2(91),m3h4x2(:,97),heltab2x8(:,:,413))
  call Hloop_VV_S(ntryL,G1H8(154),wf4(:,39),G1H2(95),m3h4x2(:,98),heltab2x8(:,:,414))
  call Hloop_SV_V(ntryL,G0H8(24),wf4(:,38),G0H2(11),m3h4x2(:,99),heltab2x8(:,:,415))
  call Hloop_SV_V(ntryL,G0H8(26),wf4(:,39),G0H2(12),m3h4x2(:,100),heltab2x8(:,:,416))
  call Hloop_VV_S(ntryL,G0H8(28),wf4(:,38),G0H2(13),m3h4x2(:,101),heltab2x8(:,:,417))
  call Hloop_VV_S(ntryL,G0H8(30),wf4(:,39),G0H2(14),m3h4x2(:,102),heltab2x8(:,:,418))
  call Hloop_SV_V(ntryL,G1H8(155),wf4(:,38),G1H2(107),m3h4x2(:,103),heltab2x8(:,:,419))
  call Hloop_SV_V(ntryL,G1H8(156),wf4(:,38),G1H2(108),m3h4x2(:,104),heltab2x8(:,:,420))
  call Hloop_SV_V(ntryL,G1H8(157),wf4(:,39),G1H2(36),m3h4x2(:,105),heltab2x8(:,:,421))
  call Hloop_SV_V(ntryL,G1H8(158),wf4(:,39),G1H2(247),m3h4x2(:,106),heltab2x8(:,:,422))
  call Hloop_TV_S(ntryL,G0H8(31),16,wf4(:,38),3,G1H2(258),m3h4x2(:,107),heltab2x8(:,:,423))
  call Hloop_SV_T(ntryL,G0H8(32),16,wf4(:,38),3,G1H2(116),m3h4x2(:,108),heltab2x8(:,:,424))
  call Hloop_TV_S(ntryL,G0H8(33),16,wf4(:,39),3,G1H2(259),m3h4x2(:,109),heltab2x8(:,:,425))
  call Hloop_SV_T(ntryL,G0H8(34),16,wf4(:,39),3,G1H2(262),m3h4x2(:,110),heltab2x8(:,:,426))
  call Hloop_UV_W(ntryL,G1H8(159),16,wf4(:,38),3,G2H2(57),m3h4x2(:,111),heltab2x8(:,:,427))
  call Hloop_UW_V(ntryL,G1H8(160),16,wf4(:,38),3,G2H2(58),m3h4x2(:,112),heltab2x8(:,:,428))
  call Hloop_UV_W(ntryL,G1H8(161),16,wf4(:,39),3,G2H2(60),m3h4x2(:,113),heltab2x8(:,:,429))
  call Hloop_UW_V(ntryL,G1H8(162),16,wf4(:,39),3,G2H2(63),m3h4x2(:,114),heltab2x8(:,:,430))
  call Hloop_UV_W(ntryL,G0H8(35),16,wf4(:,38),3,G1H2(269),m3h4x2(:,115),heltab2x8(:,:,431))
  call Hloop_UW_V(ntryL,G0H8(36),16,wf4(:,38),3,G1H2(38),m3h4x2(:,116),heltab2x8(:,:,432))
  call Hloop_UV_W(ntryL,G0H8(37),16,wf4(:,39),3,G1H2(273),m3h4x2(:,117),heltab2x8(:,:,433))
  call Hloop_UW_V(ntryL,G0H8(62),16,wf4(:,39),3,G1H2(41),m3h4x2(:,118),heltab2x8(:,:,434))
  call Hloop_VV_S(ntryL,G1H8(2),wf4(:,38),G1H2(125),m3h4x2(:,119),heltab2x8(:,:,435))
  call Hloop_VV_S(ntryL,G1H8(4),wf4(:,39),G1H2(280),m3h4x2(:,120),heltab2x8(:,:,436))
  call Hloop_SV_V(ntryL,G0H8(63),wf4(:,38),G0H2(15),m3h4x2(:,121),heltab2x8(:,:,437))
  call Hloop_SV_V(ntryL,G0H8(64),wf4(:,38),G0H2(16),m3h4x2(:,122),heltab2x8(:,:,438))
  call Hloop_SV_V(ntryL,G0H8(65),wf4(:,39),G0H2(17),m3h4x2(:,123),heltab2x8(:,:,439))
  call Hloop_SV_V(ntryL,G0H8(66),wf4(:,39),G0H2(18),m3h4x2(:,124),heltab2x8(:,:,440))
  call Hloop_AS_Q(ntryL,G1H8(7),wf4(:,7),G1H2(126),ngH,m3h4x2(:,125),heltab2x8(:,:,441))
  call Hloop_A_Q(ntryL,G1H2(126),19,nML,G2H2(62),n2h2(337))
  call Hloop_QS_A(ntryL,G1H8(12),wf4(:,7),G1H2(286),ngH,m3h4x2(:,126),heltab2x8(:,:,442))
  call Hloop_Q_A(ntryL,G1H2(286),19,nML,G2H2(66),n2h2(338))
  call Hloop_AS_Q(ntryL,G1H8(13),wf4(:,7),G1H2(127),ngH,m3h4x2(:,127),heltab2x8(:,:,443))
  call Hloop_A_Q(ntryL,G1H2(127),19,nMT,G2H2(84),n2h2(339))
  call Hloop_QS_A(ntryL,G1H8(16),wf4(:,7),G1H2(295),ngH,m3h4x2(:,128),heltab2x8(:,:,444))
  call Hloop_Q_A(ntryL,G1H2(295),19,nMT,G2H2(88),n2h2(340))
  call Hloop_AS_Q(ntryL,G1H8(5),wf4(:,7),G1H2(128),ngH,m3h4x2(:,129),heltab2x8(:,:,445))
  call Hloop_A_Q(ntryL,G1H2(128),19,nMB,G2H2(90),n2h2(341))
  call Hloop_QS_A(ntryL,G1H8(20),wf4(:,7),G1H2(306),ngH,m3h4x2(:,130),heltab2x8(:,:,446))
  call Hloop_Q_A(ntryL,G1H2(306),19,nMB,G2H2(94),n2h2(342))
  call Hloop_AS_Q(ntryL,G1H8(35),wf4(:,37),G1H2(307),ngX,m3h4x2(:,131),heltab2x8(:,:,447))
  call Hloop_A_Q(ntryL,G1H2(307),19,nML,G2H2(79),n2h2(343))
  call Hloop_QS_A(ntryL,G1H8(8),wf4(:,37),G1H2(310),ngX,m3h4x2(:,132),heltab2x8(:,:,448))
  call Hloop_Q_A(ntryL,G1H2(310),19,nML,G2H2(83),n2h2(344))
  call Hloop_AS_Q(ntryL,G1H8(11),wf4(:,37),G1H2(313),ngX,m3h4x2(:,133),heltab2x8(:,:,449))
  call Hloop_A_Q(ntryL,G1H2(313),19,nMT,G2H2(95),n2h2(345))
  call Hloop_QS_A(ntryL,G1H8(14),wf4(:,37),G1H2(314),ngX,m3h4x2(:,134),heltab2x8(:,:,450))
  call Hloop_Q_A(ntryL,G1H2(314),19,nMT,G2H2(99),n2h2(346))
  call Hloop_AS_Q(ntryL,G1H8(15),wf4(:,37),G1H2(319),ngX,m3h4x2(:,135),heltab2x8(:,:,451))
  call Hloop_A_Q(ntryL,G1H2(319),19,nMB,G2H2(102),n2h2(347))
  call Hloop_QS_A(ntryL,G1H8(17),wf4(:,37),G1H2(320),ngX,m3h4x2(:,136),heltab2x8(:,:,452))
  call Hloop_Q_A(ntryL,G1H2(320),19,nMB,G2H2(106),n2h2(348))
  call Hloop_SS_S(ntryL,G1H8(18),wf4(:,7),G1H2(324),m3h4x2(:,137),heltab2x8(:,:,453))
  call Hloop_SS_S(ntryL,G1H8(19),wf4(:,7),G1H2(325),m3h4x2(:,138),heltab2x8(:,:,454))
  call Hloop_SS_S(ntryL,G1H8(24),wf4(:,7),G1H2(330),m3h4x2(:,139),heltab2x8(:,:,455))
  call Hloop_SS_S(ntryL,G1H8(25),wf4(:,7),G1H2(331),m3h4x2(:,140),heltab2x8(:,:,456))
  call Hloop_SS_S(ntryL,G1H8(29),wf4(:,37),G1H2(335),m3h4x2(:,141),heltab2x8(:,:,457))
  call Hloop_SS_S(ntryL,G1H8(30),wf4(:,37),G1H2(336),m3h4x2(:,142),heltab2x8(:,:,458))
  call Hloop_VS_V(ntryL,G1H8(31),wf4(:,7),G1H2(341),m3h4x2(:,143),heltab2x8(:,:,459))
  call Hloop_VS_V(ntryL,G1H8(65),wf4(:,7),G1H2(342),m3h4x2(:,144),heltab2x8(:,:,460))
  call Hloop_VT_S(ntryL,G0H8(72),16,wf4(:,7),3,G1H2(346),m3h4x2(:,145),heltab2x8(:,:,461))
  call Hloop_VT_S(ntryL,G0H8(73),16,wf4(:,7),3,G1H2(347),m3h4x2(:,146),heltab2x8(:,:,462))
  call Hloop_VT_S(ntryL,G0H8(67),16,wf4(:,37),3,G1H2(352),m3h4x2(:,147),heltab2x8(:,:,463))
  call Hloop_VT_S(ntryL,G0H8(68),16,wf4(:,37),3,G1H2(353),m3h4x2(:,148),heltab2x8(:,:,464))
  call Hloop_SS_S(ntryL,G0H8(70),wf4(:,7),G0H2(19),m3h4x2(:,149),heltab2x8(:,:,465))
  call Hloop_ST_V(ntryL,G1H8(6),16,wf4(:,7),3,G2H2(108),m3h4x2(:,150),heltab2x8(:,:,466))
  call Hloop_ST_V(ntryL,G1H8(33),16,wf4(:,7),3,G2H2(112),m3h4x2(:,151),heltab2x8(:,:,467))
  call Hloop_ST_V(ntryL,G1H8(80),16,wf4(:,37),3,G2H2(113),m3h4x2(:,152),heltab2x8(:,:,468))
  call Hloop_ST_V(ntryL,G1H8(34),16,wf4(:,37),3,G2H2(117),m3h4x2(:,153),heltab2x8(:,:,469))
  call Hloop_SS_S(ntryL,G1H8(36),wf4(:,7),G1H2(357),m3h4x2(:,154),heltab2x8(:,:,470))
  call Hloop_VT_S(ntryL,G1H8(37),16,wf4(:,7),3,G2H2(121),m3h4x2(:,155),heltab2x8(:,:,471))
  call Hloop_VT_S(ntryL,G1H8(39),16,wf4(:,37),3,G2H2(125),m3h4x2(:,156),heltab2x8(:,:,472))
  call Hloop_VS_V(ntryL,G0H8(71),wf4(:,7),G0H2(20),m3h4x2(:,157),heltab2x8(:,:,473))
  call Hloop_VS_V(ntryL,G0H8(80),wf4(:,7),G0H2(21),m3h4x2(:,158),heltab2x8(:,:,474))
  call Hloop_ST_V(ntryL,G0H8(82),16,wf4(:,7),3,G1H2(358),m3h4x2(:,159),heltab2x8(:,:,475))
  call Hloop_ST_V(ntryL,G0H8(84),16,wf4(:,37),3,G1H2(363),m3h4x2(:,160),heltab2x8(:,:,476))
  call Hloop_VT_S(ntryL,G0H8(86),16,wf4(:,7),3,G1H2(364),m3h4x2(:,161),heltab2x8(:,:,477))
  call Hloop_VT_S(ntryL,G0H8(88),16,wf4(:,37),3,G1H2(369),m3h4x2(:,162),heltab2x8(:,:,478))
  call Hloop_SS_S(ntryL,G0H8(89),wf4(:,7),G0H2(22),m3h4x2(:,163),heltab2x8(:,:,479))
  call Hloop_SS_S(ntryL,G0H8(90),wf4(:,7),G0H2(23),m3h4x2(:,164),heltab2x8(:,:,480))
  call Hloop_ST_V(ntryL,G1H8(42),16,wf4(:,7),3,G2H2(129),m3h4x2(:,165),heltab2x8(:,:,481))
  call Hloop_ST_V(ntryL,G1H8(44),16,wf4(:,37),3,G2H2(133),m3h4x2(:,166),heltab2x8(:,:,482))
  call Hloop_VS_V(ntryL,G1H8(47),wf4(:,7),G1H2(374),m3h4x2(:,167),heltab2x8(:,:,483))
  call Hloop_VT_S(ntryL,G1H8(48),16,wf4(:,7),3,G2H2(134),m3h4x2(:,168),heltab2x8(:,:,484))
  call Hloop_VT_S(ntryL,G1H8(49),16,wf4(:,7),3,G2H2(138),m3h4x2(:,169),heltab2x8(:,:,485))
  call Hloop_VT_S(ntryL,G1H8(53),16,wf4(:,37),3,G2H2(149),m3h4x2(:,170),heltab2x8(:,:,486))
  call Hloop_VT_S(ntryL,G1H8(51),16,wf4(:,37),3,G2H2(152),m3h4x2(:,171),heltab2x8(:,:,487))
  call Hloop_VS_V(ntryL,G0H8(92),wf4(:,7),G0H2(24),m3h4x2(:,172),heltab2x8(:,:,488))
  call Hloop_ST_V(ntryL,G0H8(93),16,wf4(:,7),3,G1H2(378),m3h4x2(:,173),heltab2x8(:,:,489))
  call Hloop_ST_V(ntryL,G0H8(94),16,wf4(:,7),3,G1H2(379),m3h4x2(:,174),heltab2x8(:,:,490))
  call Hloop_ST_V(ntryL,G0H8(95),16,wf4(:,37),3,G1H2(384),m3h4x2(:,175),heltab2x8(:,:,491))
  call Hloop_ST_V(ntryL,G0H8(96),16,wf4(:,37),3,G1H2(385),m3h4x2(:,176),heltab2x8(:,:,492))
  call Hloop_AV_Q(ntryL,G1H8(54),wf4(:,38),G1H2(389),m3h4x2(:,177),heltab2x8(:,:,493))
  call Hloop_A_Q(ntryL,G1H2(389),19,nML,G2H2(153),n2h2(349))
  call Hloop_QV_A(ntryL,G1H8(55),wf4(:,38),G1H2(390),m3h4x2(:,178),heltab2x8(:,:,494))
  call Hloop_Q_A(ntryL,G1H2(390),19,nML,G2H2(156),n2h2(350))
  call Hloop_AV_Q(ntryL,G1H8(56),wf4(:,38),G1H2(395),m3h4x2(:,179),heltab2x8(:,:,495))
  call Hloop_A_Q(ntryL,G1H2(395),19,nMT,G2H2(114),n2h2(351))
  call Hloop_QV_A(ntryL,G1H8(57),wf4(:,38),G1H2(396),m3h4x2(:,180),heltab2x8(:,:,496))
  call Hloop_Q_A(ntryL,G1H2(396),19,nMT,G2H2(148),n2h2(352))
  call Hloop_AV_Q(ntryL,G1H8(58),wf4(:,38),G1H2(400),m3h4x2(:,181),heltab2x8(:,:,497))
  call Hloop_A_Q(ntryL,G1H2(400),19,nMB,G2H2(163),n2h2(353))
  call Hloop_QV_A(ntryL,G1H8(60),wf4(:,38),G1H2(401),m3h4x2(:,182),heltab2x8(:,:,498))
  call Hloop_Q_A(ntryL,G1H2(401),19,nMB,G2H2(165),n2h2(354))
  call Hloop_AZ_Q(ntryL,G1H8(61),wf4(:,39),G1H2(406),ngZl,m3h4x2(:,183),heltab2x8(:,:,499))
  call Hloop_A_Q(ntryL,G1H2(406),19,nML,G2H2(166),n2h2(355))
  call Hloop_QZ_A(ntryL,G1H8(62),wf4(:,39),G1H2(407),ngZl,m3h4x2(:,184),heltab2x8(:,:,500))
  call Hloop_Q_A(ntryL,G1H2(407),19,nML,G2H2(168),n2h2(356))
  call Hloop_AZ_Q(ntryL,G1H8(163),wf4(:,39),G1H2(411),ngZu,m3h4x2(:,185),heltab2x8(:,:,501))
  call Hloop_A_Q(ntryL,G1H2(411),19,nMT,G2H2(169),n2h2(357))
  call Hloop_QZ_A(ntryL,G1H8(164),wf4(:,39),G1H2(412),ngZu,m3h4x2(:,186),heltab2x8(:,:,502))
  call Hloop_Q_A(ntryL,G1H2(412),19,nMT,G2H2(171),n2h2(358))
  call Hloop_AZ_Q(ntryL,G1H8(165),wf4(:,39),G1H2(417),ngZd,m3h4x2(:,187),heltab2x8(:,:,503))
  call Hloop_A_Q(ntryL,G1H2(417),19,nMB,G2H2(172),n2h2(359))
  call Hloop_QZ_A(ntryL,G1H8(166),wf4(:,39),G1H2(418),ngZd,m3h4x2(:,188),heltab2x8(:,:,504))
  call Hloop_Q_A(ntryL,G1H2(418),19,nMB,G2H2(174),n2h2(360))
  call Hloop_SV_T(ntryL,G1H8(167),16,wf4(:,38),3,G2H2(177),m3h4x2(:,189),heltab2x8(:,:,505))
  call Hloop_TV_S(ntryL,G1H8(168),16,wf4(:,38),3,G2H2(180),m3h4x2(:,190),heltab2x8(:,:,506))
  call Hloop_SV_T(ntryL,G1H8(169),16,wf4(:,39),3,G2H2(183),m3h4x2(:,191),heltab2x8(:,:,507))
  call Hloop_TV_S(ntryL,G1H8(170),16,wf4(:,39),3,G2H2(186),m3h4x2(:,192),heltab2x8(:,:,508))
  call Hloop_DV_C(ntryL,G1H8(173),16,wf4(:,38),G2H2(201),m3h4x2(:,193),heltab2x8(:,:,509))
  call Hloop_CV_D(ntryL,G1H8(174),16,wf4(:,38),3,G2H2(204),m3h4x2(:,194),heltab2x8(:,:,510))
  call Hloop_DV_C(ntryL,G1H8(177),16,wf4(:,39),G2H2(205),m3h4x2(:,195),heltab2x8(:,:,511))
  call Hloop_CV_D(ntryL,G1H8(178),16,wf4(:,39),3,G2H2(208),m3h4x2(:,196),heltab2x8(:,:,512))
  call Hloop_UW_V(ntryL,G1H8(179),16,wf4(:,38),3,G2H2(219),m3h4x2(:,197),heltab2x8(:,:,513))
  call Hloop_UV_W(ntryL,G1H8(180),16,wf4(:,38),3,G2H2(222),m3h4x2(:,198),heltab2x8(:,:,514))
  call Hloop_UW_V(ntryL,G1H8(181),16,wf4(:,39),3,G2H2(223),m3h4x2(:,199),heltab2x8(:,:,515))
  call Hloop_UV_W(ntryL,G1H8(182),16,wf4(:,39),3,G2H2(226),m3h4x2(:,200),heltab2x8(:,:,516))
  call Hloop_VV_S(ntryL,G0H8(97),wf4(:,38),G0H2(25),m3h4x2(:,201),heltab2x8(:,:,517))
  call Hloop_VV_S(ntryL,G0H8(98),wf4(:,38),G0H2(26),m3h4x2(:,202),heltab2x8(:,:,518))
  call Hloop_VV_S(ntryL,G0H8(99),wf4(:,39),G0H2(27),m3h4x2(:,203),heltab2x8(:,:,519))
  call Hloop_VV_S(ntryL,G0H8(100),wf4(:,39),G0H2(28),m3h4x2(:,204),heltab2x8(:,:,520))
  call Hloop_SV_T(ntryL,G0H8(101),16,wf4(:,38),3,G1H2(422),m3h4x2(:,205),heltab2x8(:,:,521))
  call Hloop_TV_S(ntryL,G0H8(102),16,wf4(:,38),3,G1H2(423),m3h4x2(:,206),heltab2x8(:,:,522))
  call Hloop_SV_T(ntryL,G0H8(103),16,wf4(:,39),3,G1H2(428),m3h4x2(:,207),heltab2x8(:,:,523))
  call Hloop_TV_S(ntryL,G0H8(104),16,wf4(:,39),3,G1H2(429),m3h4x2(:,208),heltab2x8(:,:,524))
  call Hloop_SV_V(ntryL,G1H8(183),wf4(:,38),G1H2(433),m3h4x2(:,209),heltab2x8(:,:,525))
  call Hloop_SV_V(ntryL,G1H8(184),wf4(:,38),G1H2(434),m3h4x2(:,210),heltab2x8(:,:,526))
  call Hloop_SV_V(ntryL,G1H8(185),wf4(:,39),G1H2(439),m3h4x2(:,211),heltab2x8(:,:,527))
  call Hloop_SV_V(ntryL,G1H8(186),wf4(:,39),G1H2(440),m3h4x2(:,212),heltab2x8(:,:,528))
  call Hloop_SV_T(ntryL,G1H8(187),16,wf4(:,38),3,G2H2(230),m3h4x2(:,213),heltab2x8(:,:,529))
  call Hloop_TV_S(ntryL,G1H8(188),16,wf4(:,38),3,G2H2(231),m3h4x2(:,214),heltab2x8(:,:,530))
  call Hloop_SV_T(ntryL,G1H8(189),16,wf4(:,39),3,G2H2(233),m3h4x2(:,215),heltab2x8(:,:,531))
  call Hloop_TV_S(ntryL,G1H8(190),16,wf4(:,39),3,G2H2(237),m3h4x2(:,216),heltab2x8(:,:,532))
  call Hloop_VV_S(ntryL,G1H8(192),wf4(:,38),G1H2(444),m3h4x2(:,217),heltab2x8(:,:,533))
  call Hloop_VV_S(ntryL,G1H8(194),wf4(:,39),G1H2(445),m3h4x2(:,218),heltab2x8(:,:,534))
  call Hloop_UW_V(ntryL,G0H8(105),16,wf4(:,38),3,G1H2(450),m3h4x2(:,219),heltab2x8(:,:,535))
  call Hloop_UV_W(ntryL,G0H8(106),16,wf4(:,38),3,G1H2(451),m3h4x2(:,220),heltab2x8(:,:,536))
  call Hloop_UW_V(ntryL,G0H8(107),16,wf4(:,39),3,G1H2(455),m3h4x2(:,221),heltab2x8(:,:,537))
  call Hloop_UV_W(ntryL,G0H8(108),16,wf4(:,39),3,G1H2(456),m3h4x2(:,222),heltab2x8(:,:,538))
  call Hloop_SV_V(ntryL,G0H8(110),wf4(:,38),G0H2(29),m3h4x2(:,223),heltab2x8(:,:,539))
  call Hloop_SV_V(ntryL,G0H8(112),wf4(:,39),G0H2(30),m3h4x2(:,224),heltab2x8(:,:,540))
  call Hloop_VV_S(ntryL,G0H8(114),wf4(:,38),G0H2(31),m3h4x2(:,225),heltab2x8(:,:,541))
  call Hloop_VV_S(ntryL,G0H8(116),wf4(:,39),G0H2(32),m3h4x2(:,226),heltab2x8(:,:,542))
  call Hloop_SV_T(ntryL,G0H8(117),16,wf4(:,38),3,G1H2(461),m3h4x2(:,227),heltab2x8(:,:,543))
  call Hloop_TV_S(ntryL,G0H8(118),16,wf4(:,38),3,G1H2(462),m3h4x2(:,228),heltab2x8(:,:,544))
  call Hloop_SV_T(ntryL,G0H8(119),16,wf4(:,39),3,G1H2(467),m3h4x2(:,229),heltab2x8(:,:,545))
  call Hloop_TV_S(ntryL,G0H8(120),16,wf4(:,39),3,G1H2(472),m3h4x2(:,230),heltab2x8(:,:,546))
  call Hloop_SV_V(ntryL,G1H8(196),wf4(:,38),G1H2(476),m3h4x2(:,231),heltab2x8(:,:,547))
  call Hloop_SV_V(ntryL,G1H8(198),wf4(:,39),G1H2(477),m3h4x2(:,232),heltab2x8(:,:,548))
  call Hloop_UW_V(ntryL,G1H8(199),16,wf4(:,38),3,G2H2(238),m3h4x2(:,233),heltab2x8(:,:,549))
  call Hloop_UV_W(ntryL,G1H8(200),16,wf4(:,38),3,G2H2(242),m3h4x2(:,234),heltab2x8(:,:,550))
  call Hloop_UW_V(ntryL,G1H8(201),16,wf4(:,39),3,G2H2(245),m3h4x2(:,235),heltab2x8(:,:,551))
  call Hloop_UV_W(ntryL,G1H8(202),16,wf4(:,39),3,G2H2(248),m3h4x2(:,236),heltab2x8(:,:,552))
  call Hloop_VV_S(ntryL,G1H8(203),wf4(:,38),G1H2(482),m3h4x2(:,237),heltab2x8(:,:,553))
  call Hloop_VV_S(ntryL,G1H8(204),wf4(:,38),G1H2(483),m3h4x2(:,238),heltab2x8(:,:,554))
  call Hloop_VV_S(ntryL,G1H8(205),wf4(:,39),G1H2(487),m3h4x2(:,239),heltab2x8(:,:,555))
  call Hloop_VV_S(ntryL,G1H8(206),wf4(:,39),G1H2(488),m3h4x2(:,240),heltab2x8(:,:,556))
  call Hloop_UW_V(ntryL,G0H8(121),16,wf4(:,38),3,G1H2(493),m3h4x2(:,241),heltab2x8(:,:,557))
  call Hloop_UV_W(ntryL,G0H8(122),16,wf4(:,38),3,G1H2(494),m3h4x2(:,242),heltab2x8(:,:,558))
  call Hloop_UW_V(ntryL,G0H8(123),16,wf4(:,39),3,G1H2(498),m3h4x2(:,243),heltab2x8(:,:,559))
  call Hloop_UV_W(ntryL,G0H8(124),16,wf4(:,39),3,G1H2(499),m3h4x2(:,244),heltab2x8(:,:,560))
  call Hloop_SV_V(ntryL,G0H8(125),wf4(:,38),G0H2(33),m3h4x2(:,245),heltab2x8(:,:,561))
  call Hloop_SV_V(ntryL,G0H8(126),wf4(:,38),G0H2(34),m3h4x2(:,246),heltab2x8(:,:,562))
  call Hloop_SV_V(ntryL,G0H8(127),wf4(:,39),G0H2(35),m3h4x2(:,247),heltab2x8(:,:,563))
  call Hloop_SV_V(ntryL,G0H8(128),wf4(:,39),G0H2(36),m3h4x2(:,248),heltab2x8(:,:,564))
  call Hloop_QS_A(ntryL,G1H8(207),ex3(:),G1H8(23),ngH,m3h1x8(:,45),heltab2x8(:,:,565))
  call Hloop_Q_A(ntryL,G1H8(23),20,nML,G2H8(1),n2h8(297))
  call Hloop_AS_Q(ntryL,G1H8(208),ex3(:),G1H8(27),ngH,m3h1x8(:,46),heltab2x8(:,:,566))
  call Hloop_A_Q(ntryL,G1H8(27),20,nML,G2H8(2),n2h8(298))
  call Hloop_QS_A(ntryL,G1H8(209),ex3(:),G1H8(32),ngH,m3h1x8(:,47),heltab2x8(:,:,567))
  call Hloop_Q_A(ntryL,G1H8(32),20,nMT,G2H8(3),n2h8(299))
  call Hloop_AS_Q(ntryL,G1H8(210),ex3(:),G1H8(1),ngH,m3h1x8(:,48),heltab2x8(:,:,568))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(4),n2h8(300))
  call Hloop_QS_A(ntryL,G1H8(211),ex3(:),G1H8(40),ngH,m3h1x8(:,49),heltab2x8(:,:,569))
  call Hloop_Q_A(ntryL,G1H8(40),20,nMB,G2H8(5),n2h8(301))
  call Hloop_AS_Q(ntryL,G1H8(212),ex3(:),G1H8(46),ngH,m3h1x8(:,50),heltab2x8(:,:,570))
  call Hloop_A_Q(ntryL,G1H8(46),20,nMB,G2H8(6),n2h8(302))
  call Hloop_QS_A(ntryL,G1H8(213),ex3(:),G1H8(52),ngH,m3h1x8(:,51),heltab2x8(:,:,571))
  call Hloop_Q_A(ntryL,G1H8(52),20,nML,G2H8(8),n2h8(303))
  call Hloop_AS_Q(ntryL,G1H8(214),ex3(:),G1H8(59),ngH,m3h1x8(:,52),heltab2x8(:,:,572))
  call Hloop_A_Q(ntryL,G1H8(59),20,nML,G2H8(7),n2h8(304))
  call Hloop_QS_A(ntryL,G1H8(215),ex3(:),G1H8(85),ngH,m3h1x8(:,53),heltab2x8(:,:,573))
  call Hloop_Q_A(ntryL,G1H8(85),20,nMT,G2H8(10),n2h8(305))
  call Hloop_AS_Q(ntryL,G1H8(216),ex3(:),G1H8(86),ngH,m3h1x8(:,54),heltab2x8(:,:,574))
  call Hloop_A_Q(ntryL,G1H8(86),20,nMT,G2H8(9),n2h8(306))
  call Hloop_QS_A(ntryL,G1H8(217),ex3(:),G1H8(89),ngH,m3h1x8(:,55),heltab2x8(:,:,575))
  call Hloop_Q_A(ntryL,G1H8(89),20,nMB,G2H8(11),n2h8(307))
  call Hloop_AS_Q(ntryL,G1H8(218),ex3(:),G1H8(90),ngH,m3h1x8(:,56),heltab2x8(:,:,576))
  call Hloop_A_Q(ntryL,G1H8(90),20,nMB,G2H8(12),n2h8(308))
  call Hloop_SS_S(ntryL,G1H8(219),ex3(:),G1H8(95),m3h1x8(:,57),heltab2x8(:,:,577))
  call Hloop_SS_S(ntryL,G1H8(220),ex3(:),G1H8(97),m3h1x8(:,58),heltab2x8(:,:,578))
  call Hloop_SS_S(ntryL,G1H8(223),ex3(:),G1H8(99),m3h1x8(:,59),heltab2x8(:,:,579))
  call Hloop_SS_S(ntryL,G1H8(224),ex3(:),G1H8(109),m3h1x8(:,60),heltab2x8(:,:,580))
  call Hloop_SS_S(ntryL,G1H8(227),ex3(:),G1H8(111),m3h1x8(:,61),heltab2x8(:,:,581))
  call Hloop_SS_S(ntryL,G1H8(228),ex3(:),G1H8(113),m3h1x8(:,62),heltab2x8(:,:,582))
  call Hloop_VS_V(ntryL,G1H8(229),ex3(:),G1H8(131),m3h1x8(:,63),heltab2x8(:,:,583))
  call Hloop_VS_V(ntryL,G1H8(230),ex3(:),G1H8(132),m3h1x8(:,64),heltab2x8(:,:,584))
  call Hloop_SS_S(ntryL,G1H8(232),ex3(:),G1H8(135),m3h1x8(:,65),heltab2x8(:,:,585))
  call Hloop_SS_S(ntryL,G1H8(234),ex3(:),G1H8(136),m3h1x8(:,66),heltab2x8(:,:,586))
  call Hloop_SS_S(ntryL,G0H8(130),ex3(:),G0H8(259),m3h1x8(:,67),heltab2x8(:,:,587))
  call Hloop_ST_V(ntryL,G1H8(235),16,ex3(:),4,G2H8(13),m3h1x8(:,68),heltab2x8(:,:,588))
  call Hloop_ST_V(ntryL,G1H8(236),16,ex3(:),4,G2H8(14),m3h1x8(:,69),heltab2x8(:,:,589))
  call Hloop_ST_V(ntryL,G1H8(237),16,ex3(:),4,G2H8(15),m3h1x8(:,70),heltab2x8(:,:,590))
  call Hloop_ST_V(ntryL,G1H8(238),16,ex3(:),4,G2H8(16),m3h1x8(:,71),heltab2x8(:,:,591))
  call Hloop_VT_S(ntryL,G0H8(131),16,ex3(:),4,G1H8(143),m3h1x8(:,72),heltab2x8(:,:,592))
  call Hloop_VT_S(ntryL,G0H8(132),16,ex3(:),4,G1H8(145),m3h1x8(:,73),heltab2x8(:,:,593))
  call Hloop_SS_S(ntryL,G0H8(133),ex3(:),G0H8(249),m3h1x8(:,74),heltab2x8(:,:,594))
  call Hloop_SS_S(ntryL,G0H8(134),ex3(:),G0H8(12),m3h1x8(:,75),heltab2x8(:,:,595))
  call Hloop_SS_S(ntryL,G0H8(135),ex3(:),G0H8(250),m3h1x8(:,76),heltab2x8(:,:,596))
  call Hloop_SS_S(ntryL,G0H8(136),ex3(:),G0H8(13),m3h1x8(:,77),heltab2x8(:,:,597))
  call Hloop_ST_V(ntryL,G1H8(240),16,ex3(:),4,G2H8(18),m3h1x8(:,78),heltab2x8(:,:,598))
  call Hloop_ST_V(ntryL,G0H8(138),16,ex3(:),4,G1H8(50),m3h1x8(:,79),heltab2x8(:,:,599))
  call Hloop_ST_V(ntryL,G0H8(140),16,ex3(:),4,G1H8(3),m3h1x8(:,80),heltab2x8(:,:,600))
  call Hloop_VT_S(ntryL,G0H8(142),16,ex3(:),4,G1H8(21),m3h1x8(:,81),heltab2x8(:,:,601))
  call Hloop_VT_S(ntryL,G0H8(144),16,ex3(:),4,G1H8(22),m3h1x8(:,82),heltab2x8(:,:,602))
  call Hloop_VT_S(ntryL,G1H8(242),16,ex3(:),4,G2H8(17),m3h1x8(:,83),heltab2x8(:,:,603))
  call Hloop_VS_V(ntryL,G0H8(145),ex3(:),G0H8(251),m3h1x8(:,84),heltab2x8(:,:,604))
  call Hloop_VS_V(ntryL,G0H8(146),ex3(:),G0H8(14),m3h1x8(:,85),heltab2x8(:,:,605))
  call Hloop_VS_V(ntryL,G0H8(147),ex3(:),G0H8(252),m3h1x8(:,86),heltab2x8(:,:,606))
  call Hloop_VS_V(ntryL,G0H8(148),ex3(:),G0H8(15),m3h1x8(:,87),heltab2x8(:,:,607))
  call Hloop_ST_V(ntryL,G0H8(149),16,ex3(:),4,G1H8(26),m3h1x8(:,88),heltab2x8(:,:,608))
  call Hloop_ST_V(ntryL,G0H8(150),16,ex3(:),4,G1H8(28),m3h1x8(:,89),heltab2x8(:,:,609))
  call Hloop_VT_S(ntryL,G1H8(243),16,ex3(:),4,G2H8(20),m3h1x8(:,90),heltab2x8(:,:,610))
  call Hloop_VT_S(ntryL,G1H8(244),16,ex3(:),4,G2H8(19),m3h1x8(:,91),heltab2x8(:,:,611))
  call Hloop_VT_S(ntryL,G1H8(245),16,ex3(:),4,G2H8(21),m3h1x8(:,92),heltab2x8(:,:,612))
  call Hloop_VT_S(ntryL,G1H8(246),16,ex3(:),4,G2H8(22),m3h1x8(:,93),heltab2x8(:,:,613))
  call Hloop_VS_V(ntryL,G0H8(152),ex3(:),G0H8(245),m3h1x8(:,94),heltab2x8(:,:,614))
  call Hloop_VS_V(ntryL,G1H8(248),ex3(:),G1H8(38),m3h1x8(:,95),heltab2x8(:,:,615))
  call Hloop_VS_V(ntryL,G1H8(250),ex3(:),G1H8(9),m3h1x8(:,96),heltab2x8(:,:,616))
  call Hloop_QS_A(ntryL,G1H8(251),ex3(:),G1H8(10),ngH,m3h1x8(:,97),heltab2x8(:,:,617))
  call Hloop_Q_A(ntryL,G1H8(10),20,nML,G2H8(23),n2h8(309))
  call Hloop_AS_Q(ntryL,G1H8(252),ex3(:),G1H8(41),ngH,m3h1x8(:,98),heltab2x8(:,:,618))
  call Hloop_A_Q(ntryL,G1H8(41),20,nML,G2H8(24),n2h8(310))
  call Hloop_QS_A(ntryL,G1H8(253),ex3(:),G1H8(43),ngH,m3h1x8(:,99),heltab2x8(:,:,619))
  call Hloop_Q_A(ntryL,G1H8(43),20,nMT,G2H8(25),n2h8(311))
  call Hloop_AS_Q(ntryL,G1H8(254),ex3(:),G1H8(45),ngH,m3h1x8(:,100),heltab2x8(:,:,620))
  call Hloop_A_Q(ntryL,G1H8(45),20,nMT,G2H8(26),n2h8(312))
  call Hloop_QS_A(ntryL,G1H8(255),ex3(:),G1H8(171),ngH,m3h1x8(:,101),heltab2x8(:,:,621))
  call Hloop_Q_A(ntryL,G1H8(171),20,nMB,G2H8(27),n2h8(313))
  call Hloop_AS_Q(ntryL,G1H8(256),ex3(:),G1H8(172),ngH,m3h1x8(:,102),heltab2x8(:,:,622))
  call Hloop_A_Q(ntryL,G1H8(172),20,nMB,G2H8(28),n2h8(314))
  call Hloop_QS_A(ntryL,G1H8(257),ex3(:),G1H8(175),ngH,m3h1x8(:,103),heltab2x8(:,:,623))
  call Hloop_Q_A(ntryL,G1H8(175),20,nML,G2H8(29),n2h8(315))
  call Hloop_AS_Q(ntryL,G1H8(258),ex3(:),G1H8(176),ngH,m3h1x8(:,104),heltab2x8(:,:,624))
  call Hloop_A_Q(ntryL,G1H8(176),20,nML,G2H8(30),n2h8(316))
  call Hloop_QS_A(ntryL,G1H8(259),ex3(:),G1H8(191),ngH,m3h1x8(:,105),heltab2x8(:,:,625))
  call Hloop_Q_A(ntryL,G1H8(191),20,nMT,G2H8(31),n2h8(317))
  call Hloop_AS_Q(ntryL,G1H8(260),ex3(:),G1H8(193),ngH,m3h1x8(:,106),heltab2x8(:,:,626))
  call Hloop_A_Q(ntryL,G1H8(193),20,nMT,G2H8(32),n2h8(318))
  call Hloop_QS_A(ntryL,G1H8(261),ex3(:),G1H8(195),ngH,m3h1x8(:,107),heltab2x8(:,:,627))
  call Hloop_Q_A(ntryL,G1H8(195),20,nMB,G2H8(33),n2h8(319))
  call Hloop_AS_Q(ntryL,G1H8(262),ex3(:),G1H8(197),ngH,m3h1x8(:,108),heltab2x8(:,:,628))
  call Hloop_A_Q(ntryL,G1H8(197),20,nMB,G2H8(34),n2h8(320))
  call Hloop_SS_S(ntryL,G1H8(263),ex3(:),G1H8(221),m3h1x8(:,109),heltab2x8(:,:,629))
  call Hloop_SS_S(ntryL,G1H8(264),ex3(:),G1H8(222),m3h1x8(:,110),heltab2x8(:,:,630))
  call Hloop_SS_S(ntryL,G1H8(265),ex3(:),G1H8(225),m3h1x8(:,111),heltab2x8(:,:,631))
  call Hloop_SS_S(ntryL,G1H8(266),ex3(:),G1H8(226),m3h1x8(:,112),heltab2x8(:,:,632))
  call Hloop_SS_S(ntryL,G1H8(269),ex3(:),G1H8(231),m3h1x8(:,113),heltab2x8(:,:,633))
  call Hloop_SS_S(ntryL,G1H8(270),ex3(:),G1H8(233),m3h1x8(:,114),heltab2x8(:,:,634))
  call Hloop_SS_S(ntryL,G1H8(273),ex3(:),G1H8(239),m3h1x8(:,115),heltab2x8(:,:,635))
  call Hloop_SS_S(ntryL,G1H8(274),ex3(:),G1H8(241),m3h1x8(:,116),heltab2x8(:,:,636))
  call Hloop_VS_V(ntryL,G1H8(275),ex3(:),G1H8(247),m3h1x8(:,117),heltab2x8(:,:,637))
  call Hloop_VS_V(ntryL,G1H8(276),ex3(:),G1H8(249),m3h1x8(:,118),heltab2x8(:,:,638))
  call Hloop_VS_V(ntryL,G1H8(277),ex3(:),G1H8(267),m3h1x8(:,119),heltab2x8(:,:,639))
  call Hloop_VS_V(ntryL,G1H8(278),ex3(:),G1H8(268),m3h1x8(:,120),heltab2x8(:,:,640))
  call Hloop_SS_S(ntryL,G1H8(280),ex3(:),G1H8(271),m3h1x8(:,121),heltab2x8(:,:,641))
  call Hloop_SS_S(ntryL,G1H8(282),ex3(:),G1H8(272),m3h1x8(:,122),heltab2x8(:,:,642))
  call Hloop_SS_S(ntryL,G0H8(153),ex3(:),G0H8(8),m3h1x8(:,123),heltab2x8(:,:,643))
  call Hloop_SS_S(ntryL,G0H8(154),ex3(:),G0H8(246),m3h1x8(:,124),heltab2x8(:,:,644))
  call Hloop_SS_S(ntryL,G0H8(155),ex3(:),G0H8(9),m3h1x8(:,125),heltab2x8(:,:,645))
  call Hloop_SS_S(ntryL,G0H8(156),ex3(:),G0H8(247),m3h1x8(:,126),heltab2x8(:,:,646))
  call Hloop_ST_V(ntryL,G1H8(283),16,ex3(:),4,G2H8(35),m3h1x8(:,127),heltab2x8(:,:,647))
  call Hloop_ST_V(ntryL,G1H8(284),16,ex3(:),4,G2H8(36),m3h1x8(:,128),heltab2x8(:,:,648))
  call Hloop_ST_V(ntryL,G1H8(285),16,ex3(:),4,G2H8(37),m3h1x8(:,129),heltab2x8(:,:,649))
  call Hloop_ST_V(ntryL,G1H8(286),16,ex3(:),4,G2H8(38),m3h1x8(:,130),heltab2x8(:,:,650))
  call Hloop_VT_S(ntryL,G0H8(157),16,ex3(:),4,G1H8(279),m3h1x8(:,131),heltab2x8(:,:,651))
  call Hloop_VT_S(ntryL,G0H8(158),16,ex3(:),4,G1H8(281),m3h1x8(:,132),heltab2x8(:,:,652))
  call Hloop_VT_S(ntryL,G0H8(159),16,ex3(:),4,G1H8(299),m3h1x8(:,133),heltab2x8(:,:,653))
  call Hloop_VT_S(ntryL,G0H8(160),16,ex3(:),4,G1H8(301),m3h1x8(:,134),heltab2x8(:,:,654))
  call Hloop_SS_S(ntryL,G0H8(161),ex3(:),G0H8(10),m3h1x8(:,135),heltab2x8(:,:,655))
  call Hloop_SS_S(ntryL,G0H8(162),ex3(:),G0H8(248),m3h1x8(:,136),heltab2x8(:,:,656))
  call Hloop_SS_S(ntryL,G0H8(163),ex3(:),G0H8(11),m3h1x8(:,137),heltab2x8(:,:,657))
  call Hloop_SS_S(ntryL,G0H8(164),ex3(:),G0H8(255),m3h1x8(:,138),heltab2x8(:,:,658))
  call Hloop_ST_V(ntryL,G1H8(287),16,ex3(:),4,G2H8(39),m3h1x8(:,139),heltab2x8(:,:,659))
  call Hloop_ST_V(ntryL,G1H8(288),16,ex3(:),4,G2H8(40),m3h1x8(:,140),heltab2x8(:,:,660))
  call Hloop_ST_V(ntryL,G1H8(289),16,ex3(:),4,G2H8(41),m3h1x8(:,141),heltab2x8(:,:,661))
  call Hloop_ST_V(ntryL,G1H8(290),16,ex3(:),4,G2H8(42),m3h1x8(:,142),heltab2x8(:,:,662))
  call Hloop_ST_V(ntryL,G0H8(166),16,ex3(:),4,G1H8(315),m3h1x8(:,143),heltab2x8(:,:,663))
  call Hloop_ST_V(ntryL,G0H8(168),16,ex3(:),4,G1H8(326),m3h1x8(:,144),heltab2x8(:,:,664))
  call Hloop_VT_S(ntryL,G0H8(170),16,ex3(:),4,G1H8(345),m3h1x8(:,145),heltab2x8(:,:,665))
  call Hloop_VT_S(ntryL,G0H8(172),16,ex3(:),4,G1H8(356),m3h1x8(:,146),heltab2x8(:,:,666))
  call Hloop_VT_S(ntryL,G1H8(291),16,ex3(:),4,G2H8(43),m3h1x8(:,147),heltab2x8(:,:,667))
  call Hloop_VT_S(ntryL,G1H8(292),16,ex3(:),4,G2H8(44),m3h1x8(:,148),heltab2x8(:,:,668))
  call Hloop_VT_S(ntryL,G1H8(293),16,ex3(:),4,G2H8(45),m3h1x8(:,149),heltab2x8(:,:,669))
  call Hloop_VT_S(ntryL,G1H8(294),16,ex3(:),4,G2H8(46),m3h1x8(:,150),heltab2x8(:,:,670))
  call Hloop_VS_V(ntryL,G0H8(173),ex3(:),G0H8(16),m3h1x8(:,151),heltab2x8(:,:,671))
  call Hloop_VS_V(ntryL,G0H8(174),ex3(:),G0H8(256),m3h1x8(:,152),heltab2x8(:,:,672))
  call Hloop_VS_V(ntryL,G0H8(175),ex3(:),G0H8(17),m3h1x8(:,153),heltab2x8(:,:,673))
  call Hloop_VS_V(ntryL,G0H8(176),ex3(:),G0H8(257),m3h1x8(:,154),heltab2x8(:,:,674))
  call Hloop_ST_V(ntryL,G0H8(177),16,ex3(:),4,G1H8(382),m3h1x8(:,155),heltab2x8(:,:,675))
  call Hloop_ST_V(ntryL,G0H8(178),16,ex3(:),4,G1H8(396),m3h1x8(:,156),heltab2x8(:,:,676))
  call Hloop_ST_V(ntryL,G0H8(179),16,ex3(:),4,G1H8(423),m3h1x8(:,157),heltab2x8(:,:,677))
  call Hloop_ST_V(ntryL,G0H8(180),16,ex3(:),4,G1H8(437),m3h1x8(:,158),heltab2x8(:,:,678))
  call Hloop_VT_S(ntryL,G1H8(295),16,ex3(:),4,G2H8(47),m3h1x8(:,159),heltab2x8(:,:,679))
  call Hloop_VT_S(ntryL,G1H8(296),16,ex3(:),4,G2H8(48),m3h1x8(:,160),heltab2x8(:,:,680))
  call Hloop_VT_S(ntryL,G1H8(297),16,ex3(:),4,G2H8(49),m3h1x8(:,161),heltab2x8(:,:,681))
  call Hloop_VT_S(ntryL,G1H8(298),16,ex3(:),4,G2H8(50),m3h1x8(:,162),heltab2x8(:,:,682))
  call Hloop_VS_V(ntryL,G0H8(181),ex3(:),G0H8(18),m3h1x8(:,163),heltab2x8(:,:,683))
  call Hloop_VS_V(ntryL,G0H8(182),ex3(:),G0H8(258),m3h1x8(:,164),heltab2x8(:,:,684))
  call Hloop_VS_V(ntryL,G0H8(183),ex3(:),G0H8(19),m3h1x8(:,165),heltab2x8(:,:,685))
  call Hloop_VS_V(ntryL,G0H8(184),ex3(:),G0H8(44),m3h1x8(:,166),heltab2x8(:,:,686))
  call Hloop_VS_V(ntryL,G1H8(300),ex3(:),G1H8(445),m3h1x8(:,167),heltab2x8(:,:,687))
  call Hloop_VS_V(ntryL,G1H8(302),ex3(:),G1H8(446),m3h1x8(:,168),heltab2x8(:,:,688))
  call Hloop_SA_Q(ntryL,G1H8(303),ex2(:),G1H4(155),ngH,m3h2x4(:,273),heltab2x8(:,:,689))
  call Hloop_A_Q(ntryL,G1H4(155),18,nMB,G2H4(43),n2h4(351))
  call Hloop_SA_Q(ntryL,G1H8(304),ex2(:),G1H4(156),ngX,m3h2x4(:,274),heltab2x8(:,:,690))
  call Hloop_A_Q(ntryL,G1H4(156),18,nMB,G2H4(47),n2h4(352))
  call Hloop_SA_Q(ntryL,G1H8(305),ex2(:),G1H4(158),ngPbt,m3h2x4(:,275),heltab2x8(:,:,691))
  call Hloop_A_Q(ntryL,G1H4(158),18,nMT,G2H4(48),n2h4(353))
  call Hloop_QA_S(ntryL,G1H8(306),ex2(:),G1H4(159),ngPbt,m3h2x4(:,276),heltab2x8(:,:,692))
  call Hloop_SA_Q(ntryL,G0H8(185),ex2(:),G0H4(53),ngH,m3h2x4(:,277),heltab2x8(:,:,693))
  call Hloop_A_Q(ntryL,G0H4(53),18,nMB,G1H4(108),n2h4(354))
  call Hloop_SA_Q(ntryL,G0H8(186),ex2(:),G0H4(1),ngPbt,m3h2x4(:,278),heltab2x8(:,:,694))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMT,G1H4(161),n2h4(355))
  call Hloop_ZA_Q(ntryL,G0H8(187),ex2(:),G0H4(2),ngZd,m3h2x4(:,279),heltab2x8(:,:,695))
  call Hloop_A_Q(ntryL,G0H4(2),18,nMB,G1H4(162),n2h4(356))
  call Hloop_WA_Q(ntryL,G0H8(188),ex2(:),G0H4(3),m3h2x4(:,280),heltab2x8(:,:,696))
  call Hloop_A_Q(ntryL,G0H4(3),18,nMT,G1H4(163),n2h4(357))
  call Hloop_QA_S(ntryL,G1H8(307),ex2(:),G1H4(167),ngPbt,m3h2x4(:,281),heltab2x8(:,:,697))
  call Hloop_QA_W(ntryL,G1H8(308),ex2(:),G1H4(168),m3h2x4(:,282),heltab2x8(:,:,698))
  call Hloop_WA_Q(ntryL,G1H8(309),ex2(:),G1H4(169),m3h2x4(:,283),heltab2x8(:,:,699))
  call Hloop_A_Q(ntryL,G1H4(169),18,nMT,G2H4(52),n2h4(358))
  call Hloop_QA_W(ntryL,G1H8(310),ex2(:),G1H4(170),m3h2x4(:,284),heltab2x8(:,:,700))
  call Hloop_AQ_S(ntryL,G1H8(311),wf2(:,2),G1H4(174),ngH,m3h2x4(:,285),heltab2x8(:,:,701))
  call Hloop_AQ_S(ntryL,G1H8(312),wf2(:,2),G1H4(175),ngX,m3h2x4(:,286),heltab2x8(:,:,702))
  call Hloop_AQ_S(ntryL,G1H8(313),wf2(:,2),G1H4(113),ngPtb,m3h2x4(:,287),heltab2x8(:,:,703))
  call Hloop_SQ_A(ntryL,G1H8(314),wf2(:,2),G1H4(114),ngPtb,m3h2x4(:,288),heltab2x8(:,:,704))
  call Hloop_Q_A(ntryL,G1H4(114),21,nMT,G2H4(53),n2h4(359))
  call Hloop_AQ_V(ntryL,G1H8(318),wf2(:,2),G1H4(179),m3h2x4(:,289),heltab2x8(:,:,705))
  call Hloop_AQ_Z(ntryL,G1H8(316),wf2(:,2),G1H4(180),ngZd,m3h2x4(:,290),heltab2x8(:,:,706))
  call Hloop_AQ_W(ntryL,G1H8(317),wf2(:,2),G1H4(181),m3h2x4(:,291),heltab2x8(:,:,707))
  call Hloop_WQ_A(ntryL,G0H8(189),wf2(:,2),G0H4(4),m3h2x4(:,292),heltab2x8(:,:,708))
  call Hloop_Q_A(ntryL,G0H4(4),21,nMT,G1H4(183),n2h4(360))
  call Hloop_SQ_A(ntryL,G0H8(190),wf2(:,2),G0H4(5),ngPtb,m3h2x4(:,293),heltab2x8(:,:,709))
  call Hloop_Q_A(ntryL,G0H4(5),21,nMT,G1H4(186),n2h4(361))
  call Hloop_SQ_A(ntryL,G1H8(319),wf2(:,2),G1H4(187),ngPtb,m3h2x4(:,294),heltab2x8(:,:,710))
  call Hloop_Q_A(ntryL,G1H4(187),21,nMT,G2H4(55),n2h4(362))
  call Hloop_WQ_A(ntryL,G1H8(320),wf2(:,2),G1H4(189),m3h2x4(:,295),heltab2x8(:,:,711))
  call Hloop_Q_A(ntryL,G1H4(189),21,nMT,G2H4(56),n2h4(363))
  call Hloop_WQ_A(ntryL,G0H8(191),wf2(:,2),G0H4(6),m3h2x4(:,296),heltab2x8(:,:,712))
  call Hloop_Q_A(ntryL,G0H4(6),21,nMT,G1H4(190),n2h4(364))
  call Hloop_SQ_A(ntryL,G0H8(192),wf2(:,2),G0H4(7),ngPtb,m3h2x4(:,297),heltab2x8(:,:,713))
  call Hloop_Q_A(ntryL,G0H4(7),21,nMT,G1H4(193),n2h4(365))
  call Hloop_WQ_A(ntryL,G1H8(321),wf2(:,2),G1H4(195),m3h2x4(:,298),heltab2x8(:,:,714))
  call Hloop_Q_A(ntryL,G1H4(195),21,nMT,G2H4(58),n2h4(366))
  call Hloop_QA_S(ntryL,G1H8(322),ex2(:),G1H4(196),ngH,m3h2x4(:,299),heltab2x8(:,:,715))
  call Hloop_QA_S(ntryL,G1H8(323),ex2(:),G1H4(197),ngX,m3h2x4(:,300),heltab2x8(:,:,716))
  call Hloop_QA_S(ntryL,G1H8(324),ex2(:),G1H4(201),ngPbt,m3h2x4(:,301),heltab2x8(:,:,717))
  call Hloop_SA_Q(ntryL,G1H8(325),ex2(:),G1H4(33),ngPbt,m3h2x4(:,302),heltab2x8(:,:,718))
  call Hloop_A_Q(ntryL,G1H4(33),18,nMT,G2H4(60),n2h4(367))
  call Hloop_QA_V(ntryL,G1H8(329),ex2(:),G1H4(21),m3h2x4(:,303),heltab2x8(:,:,719))
  call Hloop_QA_Z(ntryL,G1H8(327),ex2(:),G1H4(56),ngZd,m3h2x4(:,304),heltab2x8(:,:,720))
  call Hloop_QA_W(ntryL,G1H8(328),ex2(:),G1H4(34),m3h2x4(:,305),heltab2x8(:,:,721))
  call Hloop_SA_Q(ntryL,G1H8(330),ex2(:),G1H4(143),ngPbt,m3h2x4(:,306),heltab2x8(:,:,722))
  call Hloop_A_Q(ntryL,G1H4(143),18,nMT,G2H4(61),n2h4(368))
  call Hloop_SA_Q(ntryL,G0H8(193),ex2(:),G0H4(8),ngPbt,m3h2x4(:,307),heltab2x8(:,:,723))
  call Hloop_A_Q(ntryL,G0H4(8),18,nMT,G1H4(100),n2h4(369))
  call Hloop_WA_Q(ntryL,G0H8(194),ex2(:),G0H4(9),m3h2x4(:,308),heltab2x8(:,:,724))
  call Hloop_A_Q(ntryL,G0H4(9),18,nMT,G1H4(99),n2h4(370))
  call Hloop_SA_Q(ntryL,G0H8(195),ex2(:),G0H4(10),ngPbt,m3h2x4(:,309),heltab2x8(:,:,725))
  call Hloop_A_Q(ntryL,G0H4(10),18,nMT,G1H4(203),n2h4(371))
  call Hloop_WA_Q(ntryL,G0H8(196),ex2(:),G0H4(57),m3h2x4(:,310),heltab2x8(:,:,726))
  call Hloop_A_Q(ntryL,G0H4(57),18,nMT,G1H4(208),n2h4(372))
  call Hloop_WA_Q(ntryL,G1H8(331),ex2(:),G1H4(204),m3h2x4(:,311),heltab2x8(:,:,727))
  call Hloop_A_Q(ntryL,G1H4(204),18,nMT,G2H4(62),n2h4(373))
  call Hloop_WA_Q(ntryL,G1H8(332),ex2(:),G1H4(207),m3h2x4(:,312),heltab2x8(:,:,728))
  call Hloop_A_Q(ntryL,G1H4(207),18,nMT,G2H4(76),n2h4(374))
  call Hloop_SQ_A(ntryL,G1H8(333),ex1(:),G1H4(209),ngH,m3h2x4(:,313),heltab2x8(:,:,729))
  call Hloop_Q_A(ntryL,G1H4(209),17,nMB,G2H4(77),n2h4(375))
  call Hloop_SQ_A(ntryL,G1H8(334),ex1(:),G1H4(212),ngX,m3h2x4(:,314),heltab2x8(:,:,730))
  call Hloop_Q_A(ntryL,G1H4(212),17,nMB,G2H4(78),n2h4(376))
  call Hloop_SQ_A(ntryL,G1H8(335),ex1(:),G1H4(213),ngPtb,m3h2x4(:,315),heltab2x8(:,:,731))
  call Hloop_Q_A(ntryL,G1H4(213),17,nMT,G2H4(80),n2h4(377))
  call Hloop_AQ_S(ntryL,G1H8(336),ex1(:),G1H4(214),ngPtb,m3h2x4(:,316),heltab2x8(:,:,732))
  call Hloop_SQ_A(ntryL,G0H8(197),ex1(:),G0H4(23),ngH,m3h2x4(:,317),heltab2x8(:,:,733))
  call Hloop_Q_A(ntryL,G0H4(23),17,nMB,G1H4(219),n2h4(378))
  call Hloop_SQ_A(ntryL,G0H8(198),ex1(:),G0H4(30),ngPtb,m3h2x4(:,318),heltab2x8(:,:,734))
  call Hloop_Q_A(ntryL,G0H4(30),17,nMT,G1H4(224),n2h4(379))
  call Hloop_ZQ_A(ntryL,G0H8(199),ex1(:),G0H4(46),ngZd,m3h2x4(:,319),heltab2x8(:,:,735))
  call Hloop_Q_A(ntryL,G0H4(46),17,nMB,G1H4(220),n2h4(380))
  call Hloop_WQ_A(ntryL,G0H8(200),ex1(:),G0H4(53),m3h2x4(:,320),heltab2x8(:,:,736))
  call Hloop_Q_A(ntryL,G0H4(53),17,nMT,G1H4(223),n2h4(381))
  call Hloop_AQ_S(ntryL,G1H8(337),ex1(:),G1H4(225),ngPtb,m3h2x4(:,321),heltab2x8(:,:,737))
  call Hloop_AQ_W(ntryL,G1H8(338),ex1(:),G1H4(228),m3h2x4(:,322),heltab2x8(:,:,738))
  call Hloop_WQ_A(ntryL,G1H8(339),ex1(:),G1H4(229),m3h2x4(:,323),heltab2x8(:,:,739))
  call Hloop_Q_A(ntryL,G1H4(229),17,nMT,G2H4(81),n2h4(382))
  call Hloop_AQ_W(ntryL,G1H8(340),ex1(:),G1H4(230),m3h2x4(:,324),heltab2x8(:,:,740))
  call Hloop_QA_S(ntryL,G1H8(341),wf2(:,4),G1H4(235),ngH,m3h2x4(:,325),heltab2x8(:,:,741))
  call Hloop_QA_S(ntryL,G1H8(342),wf2(:,4),G1H4(240),ngX,m3h2x4(:,326),heltab2x8(:,:,742))
  call Hloop_QA_S(ntryL,G1H8(343),wf2(:,4),G1H4(236),ngPbt,m3h2x4(:,327),heltab2x8(:,:,743))
  call Hloop_SA_Q(ntryL,G1H8(344),wf2(:,4),G1H4(239),ngPbt,m3h2x4(:,328),heltab2x8(:,:,744))
  call Hloop_A_Q(ntryL,G1H4(239),22,nMT,G2H4(82),n2h4(383))
  call Hloop_QA_V(ntryL,G1H8(348),wf2(:,4),G1H4(241),m3h2x4(:,329),heltab2x8(:,:,745))
  call Hloop_QA_Z(ntryL,G1H8(346),wf2(:,4),G1H4(244),ngZd,m3h2x4(:,330),heltab2x8(:,:,746))
  call Hloop_QA_W(ntryL,G1H8(347),wf2(:,4),G1H4(25),m3h2x4(:,331),heltab2x8(:,:,747))
  call Hloop_WA_Q(ntryL,G0H8(201),wf2(:,4),G0H4(1),m3h2x4(:,332),heltab2x8(:,:,748))
  call Hloop_A_Q(ntryL,G0H4(1),22,nMT,G1H4(40),n2h4(384))
  call Hloop_SA_Q(ntryL,G0H8(202),wf2(:,4),G0H4(2),ngPbt,m3h2x4(:,333),heltab2x8(:,:,749))
  call Hloop_A_Q(ntryL,G0H4(2),22,nMT,G1H4(49),n2h4(385))
  call Hloop_SA_Q(ntryL,G1H8(349),wf2(:,4),G1H4(64),ngPbt,m3h2x4(:,334),heltab2x8(:,:,750))
  call Hloop_A_Q(ntryL,G1H4(64),22,nMT,G2H4(84),n2h4(386))
  call Hloop_WA_Q(ntryL,G1H8(350),wf2(:,4),G1H4(45),m3h2x4(:,335),heltab2x8(:,:,751))
  call Hloop_A_Q(ntryL,G1H4(45),22,nMT,G2H4(85),n2h4(387))
  call Hloop_WA_Q(ntryL,G0H8(203),wf2(:,4),G0H4(3),m3h2x4(:,336),heltab2x8(:,:,752))
  call Hloop_A_Q(ntryL,G0H4(3),22,nMT,G1H4(59),n2h4(388))
  call Hloop_SA_Q(ntryL,G0H8(204),wf2(:,4),G0H4(4),ngPbt,m3h2x4(:,337),heltab2x8(:,:,753))
  call Hloop_A_Q(ntryL,G0H4(4),22,nMT,G1H4(67),n2h4(389))
  call Hloop_WA_Q(ntryL,G1H8(351),wf2(:,4),G1H4(82),m3h2x4(:,338),heltab2x8(:,:,754))
  call Hloop_A_Q(ntryL,G1H4(82),22,nMT,G2H4(89),n2h4(390))
  call Hloop_AQ_S(ntryL,G1H8(352),ex1(:),G1H4(83),ngH,m3h2x4(:,339),heltab2x8(:,:,755))
  call Hloop_AQ_S(ntryL,G1H8(353),ex1(:),G1H4(69),ngX,m3h2x4(:,340),heltab2x8(:,:,756))
  call Hloop_AQ_S(ntryL,G1H8(354),ex1(:),G1H4(85),ngPtb,m3h2x4(:,341),heltab2x8(:,:,757))
  call Hloop_SQ_A(ntryL,G1H8(355),ex1(:),G1H4(68),ngPtb,m3h2x4(:,342),heltab2x8(:,:,758))
  call Hloop_Q_A(ntryL,G1H4(68),17,nMT,G2H4(91),n2h4(391))
  call Hloop_AQ_V(ntryL,G1H8(359),ex1(:),G1H4(86),m3h2x4(:,343),heltab2x8(:,:,759))
  call Hloop_AQ_Z(ntryL,G1H8(357),ex1(:),G1H4(39),ngZd,m3h2x4(:,344),heltab2x8(:,:,760))
  call Hloop_AQ_W(ntryL,G1H8(358),ex1(:),G1H4(75),m3h2x4(:,345),heltab2x8(:,:,761))
  call Hloop_SQ_A(ntryL,G1H8(360),ex1(:),G1H4(129),ngPtb,m3h2x4(:,346),heltab2x8(:,:,762))
  call Hloop_Q_A(ntryL,G1H4(129),17,nMT,G2H4(92),n2h4(392))
  call Hloop_SQ_A(ntryL,G0H8(205),ex1(:),G0H4(5),ngPtb,m3h2x4(:,347),heltab2x8(:,:,763))
  call Hloop_Q_A(ntryL,G0H4(5),17,nMT,G1H4(43),n2h4(393))
  call Hloop_WQ_A(ntryL,G0H8(206),ex1(:),G0H4(6),m3h2x4(:,348),heltab2x8(:,:,764))
  call Hloop_Q_A(ntryL,G0H4(6),17,nMT,G1H4(37),n2h4(394))
  call Hloop_SQ_A(ntryL,G0H8(207),ex1(:),G0H4(7),ngPtb,m3h2x4(:,349),heltab2x8(:,:,765))
  call Hloop_Q_A(ntryL,G0H4(7),17,nMT,G1H4(127),n2h4(395))
  call Hloop_WQ_A(ntryL,G0H8(208),ex1(:),G0H4(8),m3h2x4(:,350),heltab2x8(:,:,766))
  call Hloop_Q_A(ntryL,G0H4(8),17,nMT,G1H4(130),n2h4(396))
  call Hloop_WQ_A(ntryL,G1H8(361),ex1(:),G1H4(41),m3h2x4(:,351),heltab2x8(:,:,767))
  call Hloop_Q_A(ntryL,G1H4(41),17,nMT,G2H4(93),n2h4(397))
  call Hloop_WQ_A(ntryL,G1H8(362),ex1(:),G1H4(74),m3h2x4(:,352),heltab2x8(:,:,768))
  call Hloop_Q_A(ntryL,G1H4(74),17,nMT,G2H4(95),n2h4(398))
  call Hloop_SA_Q(ntryL,G1H8(363),ex2(:),G1H4(47),ngH,m3h2x4(:,353),heltab2x8(:,:,769))
  call Hloop_A_Q(ntryL,G1H4(47),18,nMB,G2H4(96),n2h4(399))
  call Hloop_SA_Q(ntryL,G1H8(364),ex2(:),G1H4(132),ngX,m3h2x4(:,354),heltab2x8(:,:,770))
  call Hloop_A_Q(ntryL,G1H4(132),18,nMB,G2H4(97),n2h4(400))
  call Hloop_SA_Q(ntryL,G1H8(365),ex2(:),G1H4(80),ngPbt,m3h2x4(:,355),heltab2x8(:,:,771))
  call Hloop_A_Q(ntryL,G1H4(80),18,nMT,G2H4(99),n2h4(401))
  call Hloop_QA_S(ntryL,G1H8(366),ex2(:),G1H4(97),ngH,m3h2x4(:,356),heltab2x8(:,:,772))
  call Hloop_QA_S(ntryL,G1H8(367),ex2(:),G1H4(116),ngX,m3h2x4(:,357),heltab2x8(:,:,773))
  call Hloop_QA_S(ntryL,G1H8(368),ex2(:),G1H4(7),ngPbt,m3h2x4(:,358),heltab2x8(:,:,774))
  call Hloop_SA_Q(ntryL,G0H8(209),ex2(:),G0H4(9),ngH,m3h2x4(:,359),heltab2x8(:,:,775))
  call Hloop_A_Q(ntryL,G0H4(9),18,nMB,G1H4(4),n2h4(402))
  call Hloop_SA_Q(ntryL,G0H8(210),ex2(:),G0H4(10),ngPbt,m3h2x4(:,360),heltab2x8(:,:,776))
  call Hloop_A_Q(ntryL,G0H4(10),18,nMT,G1H4(13),n2h4(403))
  call Hloop_ZA_Q(ntryL,G0H8(211),ex2(:),G0H4(57),ngZd,m3h2x4(:,361),heltab2x8(:,:,777))
  call Hloop_A_Q(ntryL,G0H4(57),18,nMB,G1H4(20),n2h4(404))
  call Hloop_WA_Q(ntryL,G0H8(212),ex2(:),G0H4(23),m3h2x4(:,362),heltab2x8(:,:,778))
  call Hloop_A_Q(ntryL,G0H4(23),18,nMT,G1H4(199),n2h4(405))
  call Hloop_QA_S(ntryL,G1H8(369),ex2(:),G1H4(134),ngX,m3h2x4(:,363),heltab2x8(:,:,779))
  call Hloop_QA_S(ntryL,G1H8(370),ex2(:),G1H4(200),ngPbt,m3h2x4(:,364),heltab2x8(:,:,780))
  call Hloop_QA_Z(ntryL,G1H8(371),ex2(:),G1H4(79),ngZd,m3h2x4(:,365),heltab2x8(:,:,781))
  call Hloop_QA_W(ntryL,G1H8(372),ex2(:),G1H4(32),m3h2x4(:,366),heltab2x8(:,:,782))
  call Hloop_WA_Q(ntryL,G1H8(373),ex2(:),G1H4(136),m3h2x4(:,367),heltab2x8(:,:,783))
  call Hloop_A_Q(ntryL,G1H4(136),18,nMT,G2H4(100),n2h4(406))
  call Hloop_QA_Z(ntryL,G1H8(374),ex2(:),G1H4(202),ngZd,m3h2x4(:,368),heltab2x8(:,:,784))
  call Hloop_QA_W(ntryL,G1H8(375),ex2(:),G1H4(88),m3h2x4(:,369),heltab2x8(:,:,785))
  call Hloop_QS_A(ntryL,G1H8(376),ex3(:),G1H8(447),ngH,m3h1x8(:,169),heltab2x8(:,:,786))
  call Hloop_Q_A(ntryL,G1H8(447),20,nMB,G2H8(51),n2h8(321))
  call Hloop_QS_A(ntryL,G1H8(377),ex3(:),G1H8(460),ngH,m3h1x8(:,170),heltab2x8(:,:,787))
  call Hloop_Q_A(ntryL,G1H8(460),20,nMB,G2H8(52),n2h8(322))
  call Hloop_QS_A(ntryL,G1H8(378),ex3(:),G1H8(451),ngH,m3h1x8(:,171),heltab2x8(:,:,788))
  call Hloop_Q_A(ntryL,G1H8(451),20,nMT,G2H8(53),n2h8(323))
  call Hloop_SS_S(ntryL,G1H8(379),ex3(:),G1H8(448),m3h1x8(:,172),heltab2x8(:,:,789))
  call Hloop_SS_S(ntryL,G1H8(380),ex3(:),G1H8(449),m3h1x8(:,173),heltab2x8(:,:,790))
  call Hloop_SS_S(ntryL,G1H8(381),ex3(:),G1H8(450),m3h1x8(:,174),heltab2x8(:,:,791))
  call Hloop_QS_A(ntryL,G1H8(385),ex3(:),G1H8(467),ngH,m3h1x8(:,175),heltab2x8(:,:,792))
  call Hloop_Q_A(ntryL,G1H8(467),20,nMB,G2H8(54),n2h8(324))
  call Hloop_QS_A(ntryL,G1H8(383),ex3(:),G1H8(468),ngH,m3h1x8(:,176),heltab2x8(:,:,793))
  call Hloop_Q_A(ntryL,G1H8(468),20,nMB,G2H8(55),n2h8(325))
  call Hloop_QS_A(ntryL,G1H8(384),ex3(:),G1H8(469),ngH,m3h1x8(:,177),heltab2x8(:,:,794))
  call Hloop_Q_A(ntryL,G1H8(469),20,nMT,G2H8(56),n2h8(326))
  call Hloop_SS_S(ntryL,G0H8(213),ex3(:),G0H8(46),m3h1x8(:,178),heltab2x8(:,:,795))
  call Hloop_SS_S(ntryL,G0H8(214),ex3(:),G0H8(48),m3h1x8(:,179),heltab2x8(:,:,796))
  call Hloop_VT_S(ntryL,G0H8(215),16,ex3(:),4,G1H8(482),m3h1x8(:,180),heltab2x8(:,:,797))
  call Hloop_VT_S(ntryL,G0H8(216),16,ex3(:),4,G1H8(473),m3h1x8(:,181),heltab2x8(:,:,798))
  call Hloop_ST_V(ntryL,G1H8(386),16,ex3(:),4,G2H8(57),m3h1x8(:,182),heltab2x8(:,:,799))
  call Hloop_ST_V(ntryL,G1H8(387),16,ex3(:),4,G2H8(58),m3h1x8(:,183),heltab2x8(:,:,800))
  call Hloop_VT_S(ntryL,G1H8(388),16,ex3(:),4,G2H8(59),m3h1x8(:,184),heltab2x8(:,:,801))
  call Hloop_ST_V(ntryL,G0H8(217),16,ex3(:),4,G1H8(470),m3h1x8(:,185),heltab2x8(:,:,802))
  call Hloop_VS_V(ntryL,G0H8(218),ex3(:),G0H8(50),m3h1x8(:,186),heltab2x8(:,:,803))
  call Hloop_VS_V(ntryL,G0H8(219),ex3(:),G0H8(52),m3h1x8(:,187),heltab2x8(:,:,804))
  call Hloop_VS_V(ntryL,G1H8(389),ex3(:),G1H8(471),m3h1x8(:,188),heltab2x8(:,:,805))
  call Hloop_QA_S(ntryL,G1H8(390),ex2(:),G1H4(90),ngH,m3h2x4(:,370),heltab2x8(:,:,806))
  call Hloop_QA_S(ntryL,G1H8(391),ex2(:),G1H4(137),ngX,m3h2x4(:,371),heltab2x8(:,:,807))
  call Hloop_QA_S(ntryL,G1H8(392),ex2(:),G1H4(133),ngPbt,m3h2x4(:,372),heltab2x8(:,:,808))
  call Hloop_SA_Q(ntryL,G1H8(393),ex2(:),G1H4(93),ngX,m3h2x4(:,373),heltab2x8(:,:,809))
  call Hloop_A_Q(ntryL,G1H4(93),18,nMB,G2H4(101),n2h4(407))
  call Hloop_SA_Q(ntryL,G1H8(394),ex2(:),G1H4(139),ngH,m3h2x4(:,374),heltab2x8(:,:,810))
  call Hloop_A_Q(ntryL,G1H4(139),18,nMB,G2H4(103),n2h4(408))
  call Hloop_SA_Q(ntryL,G1H8(395),ex2(:),G1H4(92),ngPbt,m3h2x4(:,375),heltab2x8(:,:,811))
  call Hloop_A_Q(ntryL,G1H4(92),18,nMT,G2H4(104),n2h4(409))
  call Hloop_QA_V(ntryL,G1H8(399),ex2(:),G1H4(144),m3h2x4(:,376),heltab2x8(:,:,812))
  call Hloop_QA_Z(ntryL,G1H8(397),ex2(:),G1H4(141),ngZd,m3h2x4(:,377),heltab2x8(:,:,813))
  call Hloop_QA_W(ntryL,G1H8(398),ex2(:),G1H4(104),m3h2x4(:,378),heltab2x8(:,:,814))
  call Hloop_SA_Q(ntryL,G1H8(400),ex2(:),G1H4(151),ngH,m3h2x4(:,379),heltab2x8(:,:,815))
  call Hloop_A_Q(ntryL,G1H4(151),18,nMB,G2H4(105),n2h4(410))
  call Hloop_SA_Q(ntryL,G1H8(401),ex2(:),G1H4(157),ngPbt,m3h2x4(:,380),heltab2x8(:,:,816))
  call Hloop_A_Q(ntryL,G1H4(157),18,nMT,G2H4(107),n2h4(411))
  call Hloop_SA_Q(ntryL,G0H8(220),ex2(:),G0H4(30),ngH,m3h2x4(:,381),heltab2x8(:,:,817))
  call Hloop_A_Q(ntryL,G0H4(30),18,nMB,G1H4(109),n2h4(412))
  call Hloop_SA_Q(ntryL,G0H8(221),ex2(:),G0H4(46),ngPbt,m3h2x4(:,382),heltab2x8(:,:,818))
  call Hloop_A_Q(ntryL,G0H4(46),18,nMT,G1H4(166),n2h4(413))
  call Hloop_ZA_Q(ntryL,G0H8(222),ex2(:),G0H4(53),ngZd,m3h2x4(:,383),heltab2x8(:,:,819))
  call Hloop_A_Q(ntryL,G0H4(53),18,nMB,G1H4(172),n2h4(414))
  call Hloop_WA_Q(ntryL,G0H8(223),ex2(:),G0H4(1),m3h2x4(:,384),heltab2x8(:,:,820))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMT,G1H4(176),n2h4(415))
  call Hloop_SA_Q(ntryL,G0H8(224),ex2(:),G0H4(2),ngH,m3h2x4(:,385),heltab2x8(:,:,821))
  call Hloop_A_Q(ntryL,G0H4(2),18,nMB,G1H4(182),n2h4(416))
  call Hloop_SA_Q(ntryL,G0H8(225),ex2(:),G0H4(3),ngPbt,m3h2x4(:,386),heltab2x8(:,:,822))
  call Hloop_A_Q(ntryL,G0H4(3),18,nMT,G1H4(188),n2h4(417))
  call Hloop_WA_Q(ntryL,G0H8(226),ex2(:),G0H4(4),m3h2x4(:,387),heltab2x8(:,:,823))
  call Hloop_A_Q(ntryL,G0H4(4),18,nMT,G1H4(194),n2h4(418))
  call Hloop_WA_Q(ntryL,G1H8(402),ex2(:),G1H4(198),m3h2x4(:,388),heltab2x8(:,:,824))
  call Hloop_A_Q(ntryL,G1H4(198),18,nMT,G2H4(108),n2h4(419))
  call Hloop_WA_Q(ntryL,G1H8(403),ex2(:),G1H4(98),m3h2x4(:,389),heltab2x8(:,:,825))
  call Hloop_A_Q(ntryL,G1H4(98),18,nMT,G2H4(109),n2h4(420))
  call Hloop_SQ_A(ntryL,G1H8(404),ex1(:),G1H4(142),ngH,m3h2x4(:,390),heltab2x8(:,:,826))
  call Hloop_Q_A(ntryL,G1H4(142),17,nMB,G2H4(111),n2h4(421))
  call Hloop_SQ_A(ntryL,G1H8(405),ex1(:),G1H4(111),ngX,m3h2x4(:,391),heltab2x8(:,:,827))
  call Hloop_Q_A(ntryL,G1H4(111),17,nMB,G2H4(112),n2h4(422))
  call Hloop_SQ_A(ntryL,G1H8(406),ex1(:),G1H4(94),ngPtb,m3h2x4(:,392),heltab2x8(:,:,828))
  call Hloop_Q_A(ntryL,G1H4(94),17,nMT,G2H4(113),n2h4(423))
  call Hloop_AQ_S(ntryL,G1H8(407),ex1(:),G1H4(112),ngH,m3h2x4(:,393),heltab2x8(:,:,829))
  call Hloop_AQ_S(ntryL,G1H8(408),ex1(:),G1H4(147),ngX,m3h2x4(:,394),heltab2x8(:,:,830))
  call Hloop_AQ_S(ntryL,G1H8(409),ex1(:),G1H4(103),ngPtb,m3h2x4(:,395),heltab2x8(:,:,831))
  call Hloop_SQ_A(ntryL,G0H8(227),ex1(:),G0H4(5),ngH,m3h2x4(:,396),heltab2x8(:,:,832))
  call Hloop_Q_A(ntryL,G0H4(5),17,nMB,G1H4(148),n2h4(424))
  call Hloop_SQ_A(ntryL,G0H8(228),ex1(:),G0H4(6),ngPtb,m3h2x4(:,397),heltab2x8(:,:,833))
  call Hloop_Q_A(ntryL,G0H4(6),17,nMT,G1H4(155),n2h4(425))
  call Hloop_ZQ_A(ntryL,G0H8(229),ex1(:),G0H4(7),ngZd,m3h2x4(:,398),heltab2x8(:,:,834))
  call Hloop_Q_A(ntryL,G0H4(7),17,nMB,G1H4(156),n2h4(426))
  call Hloop_WQ_A(ntryL,G0H8(230),ex1(:),G0H4(8),m3h2x4(:,399),heltab2x8(:,:,835))
  call Hloop_Q_A(ntryL,G0H4(8),17,nMT,G1H4(158),n2h4(427))
  call Hloop_AQ_S(ntryL,G1H8(410),ex1(:),G1H4(169),ngX,m3h2x4(:,400),heltab2x8(:,:,836))
  call Hloop_AQ_S(ntryL,G1H8(411),ex1(:),G1H4(114),ngPtb,m3h2x4(:,401),heltab2x8(:,:,837))
  call Hloop_AQ_Z(ntryL,G1H8(412),ex1(:),G1H4(187),ngZd,m3h2x4(:,402),heltab2x8(:,:,838))
  call Hloop_AQ_W(ntryL,G1H8(413),ex1(:),G1H4(189),m3h2x4(:,403),heltab2x8(:,:,839))
  call Hloop_WQ_A(ntryL,G1H8(414),ex1(:),G1H4(195),m3h2x4(:,404),heltab2x8(:,:,840))
  call Hloop_Q_A(ntryL,G1H4(195),17,nMT,G2H4(115),n2h4(428))
  call Hloop_AQ_Z(ntryL,G1H8(415),ex1(:),G1H4(33),ngZd,m3h2x4(:,405),heltab2x8(:,:,841))
  call Hloop_AQ_W(ntryL,G1H8(416),ex1(:),G1H4(143),m3h2x4(:,406),heltab2x8(:,:,842))
  call Hloop_AS_Q(ntryL,G1H8(417),ex3(:),G1H8(472),ngH,m3h1x8(:,189),heltab2x8(:,:,843))
  call Hloop_A_Q(ntryL,G1H8(472),20,nMB,G2H8(60),n2h8(327))
  call Hloop_AS_Q(ntryL,G1H8(418),ex3(:),G1H8(489),ngH,m3h1x8(:,190),heltab2x8(:,:,844))
  call Hloop_A_Q(ntryL,G1H8(489),20,nMB,G2H8(61),n2h8(328))
  call Hloop_AS_Q(ntryL,G1H8(419),ex3(:),G1H8(494),ngH,m3h1x8(:,191),heltab2x8(:,:,845))
  call Hloop_A_Q(ntryL,G1H8(494),20,nMT,G2H8(62),n2h8(329))
  call Hloop_SS_S(ntryL,G1H8(420),ex3(:),G1H8(495),m3h1x8(:,192),heltab2x8(:,:,846))
  call Hloop_SS_S(ntryL,G1H8(421),ex3(:),G1H8(496),m3h1x8(:,193),heltab2x8(:,:,847))
  call Hloop_SS_S(ntryL,G1H8(422),ex3(:),G1H8(474),m3h1x8(:,194),heltab2x8(:,:,848))
  call Hloop_AS_Q(ntryL,G1H8(426),ex3(:),G1H8(475),ngH,m3h1x8(:,195),heltab2x8(:,:,849))
  call Hloop_A_Q(ntryL,G1H8(475),20,nMB,G2H8(63),n2h8(330))
  call Hloop_AS_Q(ntryL,G1H8(424),ex3(:),G1H8(476),ngH,m3h1x8(:,196),heltab2x8(:,:,850))
  call Hloop_A_Q(ntryL,G1H8(476),20,nMB,G2H8(64),n2h8(331))
  call Hloop_AS_Q(ntryL,G1H8(425),ex3(:),G1H8(477),ngH,m3h1x8(:,197),heltab2x8(:,:,851))
  call Hloop_A_Q(ntryL,G1H8(477),20,nMT,G2H8(65),n2h8(332))
  call Hloop_SS_S(ntryL,G0H8(231),ex3(:),G0H8(54),m3h1x8(:,198),heltab2x8(:,:,852))
  call Hloop_SS_S(ntryL,G0H8(232),ex3(:),G0H8(7),m3h1x8(:,199),heltab2x8(:,:,853))
  call Hloop_VT_S(ntryL,G0H8(233),16,ex3(:),4,G1H8(452),m3h1x8(:,200),heltab2x8(:,:,854))
  call Hloop_VT_S(ntryL,G0H8(234),16,ex3(:),4,G1H8(453),m3h1x8(:,201),heltab2x8(:,:,855))
  call Hloop_ST_V(ntryL,G1H8(427),16,ex3(:),4,G2H8(66),m3h1x8(:,202),heltab2x8(:,:,856))
  call Hloop_ST_V(ntryL,G1H8(428),16,ex3(:),4,G2H8(67),m3h1x8(:,203),heltab2x8(:,:,857))
  call Hloop_VT_S(ntryL,G1H8(429),16,ex3(:),4,G2H8(68),m3h1x8(:,204),heltab2x8(:,:,858))
  call Hloop_ST_V(ntryL,G0H8(235),16,ex3(:),4,G1H8(454),m3h1x8(:,205),heltab2x8(:,:,859))
  call Hloop_VS_V(ntryL,G0H8(236),ex3(:),G0H8(25),m3h1x8(:,206),heltab2x8(:,:,860))
  call Hloop_VS_V(ntryL,G0H8(237),ex3(:),G0H8(27),m3h1x8(:,207),heltab2x8(:,:,861))
  call Hloop_VS_V(ntryL,G1H8(430),ex3(:),G1H8(455),m3h1x8(:,208),heltab2x8(:,:,862))
  call Hloop_AQ_S(ntryL,G1H8(431),ex1(:),G1H4(204),ngH,m3h2x4(:,407),heltab2x8(:,:,863))
  call Hloop_AQ_S(ntryL,G1H8(432),ex1(:),G1H4(207),ngX,m3h2x4(:,408),heltab2x8(:,:,864))
  call Hloop_AQ_S(ntryL,G1H8(433),ex1(:),G1H4(209),ngPtb,m3h2x4(:,409),heltab2x8(:,:,865))
  call Hloop_SQ_A(ntryL,G1H8(434),ex1(:),G1H4(212),ngX,m3h2x4(:,410),heltab2x8(:,:,866))
  call Hloop_Q_A(ntryL,G1H4(212),17,nMB,G2H4(116),n2h4(429))
  call Hloop_SQ_A(ntryL,G1H8(435),ex1(:),G1H4(213),ngH,m3h2x4(:,411),heltab2x8(:,:,867))
  call Hloop_Q_A(ntryL,G1H4(213),17,nMB,G2H4(117),n2h4(430))
  call Hloop_SQ_A(ntryL,G1H8(436),ex1(:),G1H4(229),ngPtb,m3h2x4(:,412),heltab2x8(:,:,868))
  call Hloop_Q_A(ntryL,G1H4(229),17,nMT,G2H4(119),n2h4(431))
  call Hloop_AQ_V(ntryL,G1H8(440),ex1(:),G1H4(239),m3h2x4(:,413),heltab2x8(:,:,869))
  call Hloop_AQ_Z(ntryL,G1H8(438),ex1(:),G1H4(64),ngZd,m3h2x4(:,414),heltab2x8(:,:,870))
  call Hloop_AQ_W(ntryL,G1H8(439),ex1(:),G1H4(45),m3h2x4(:,415),heltab2x8(:,:,871))
  call Hloop_SQ_A(ntryL,G1H8(441),ex1(:),G1H4(82),ngH,m3h2x4(:,416),heltab2x8(:,:,872))
  call Hloop_Q_A(ntryL,G1H4(82),17,nMB,G2H4(120),n2h4(432))
  call Hloop_SQ_A(ntryL,G1H8(442),ex1(:),G1H4(68),ngPtb,m3h2x4(:,417),heltab2x8(:,:,873))
  call Hloop_Q_A(ntryL,G1H4(68),17,nMT,G2H4(66),n2h4(433))
  call Hloop_SQ_A(ntryL,G0H8(238),ex1(:),G0H4(9),ngH,m3h2x4(:,418),heltab2x8(:,:,874))
  call Hloop_Q_A(ntryL,G0H4(9),17,nMB,G1H4(129),n2h4(434))
  call Hloop_SQ_A(ntryL,G0H8(239),ex1(:),G0H4(10),ngPtb,m3h2x4(:,419),heltab2x8(:,:,875))
  call Hloop_Q_A(ntryL,G0H4(10),17,nMT,G1H4(41),n2h4(435))
  call Hloop_ZQ_A(ntryL,G0H8(240),ex1(:),G0H4(57),ngZd,m3h2x4(:,420),heltab2x8(:,:,876))
  call Hloop_Q_A(ntryL,G0H4(57),17,nMB,G1H4(74),n2h4(436))
  call Hloop_WQ_A(ntryL,G0H8(241),ex1(:),G0H4(23),m3h2x4(:,421),heltab2x8(:,:,877))
  call Hloop_Q_A(ntryL,G0H4(23),17,nMT,G1H4(47),n2h4(437))
  call Hloop_SQ_A(ntryL,G0H8(242),ex1(:),G0H4(30),ngH,m3h2x4(:,422),heltab2x8(:,:,878))
  call Hloop_Q_A(ntryL,G0H4(30),17,nMB,G1H4(132),n2h4(438))
  call Hloop_SQ_A(ntryL,G0H8(243),ex1(:),G0H4(46),ngPtb,m3h2x4(:,423),heltab2x8(:,:,879))
  call Hloop_Q_A(ntryL,G0H4(46),17,nMT,G1H4(80),n2h4(439))
  call Hloop_WQ_A(ntryL,G0H8(244),ex1(:),G0H4(53),m3h2x4(:,424),heltab2x8(:,:,880))
  call Hloop_Q_A(ntryL,G0H4(53),17,nMT,G1H4(136),n2h4(440))
  call Hloop_WQ_A(ntryL,G1H8(443),ex1(:),G1H4(93),m3h2x4(:,425),heltab2x8(:,:,881))
  call Hloop_Q_A(ntryL,G1H4(93),17,nMT,G2H4(70),n2h4(441))
  call Hloop_WQ_A(ntryL,G1H8(444),ex1(:),G1H4(139),m3h2x4(:,426),heltab2x8(:,:,882))
  call Hloop_Q_A(ntryL,G1H4(139),17,nMT,G2H4(71),n2h4(442))
  call Hloop_SS_S(ntryL,G0H4(11),ex3(:),G0H4(1),m3h1x4(:,102),heltab2x4(:,:,471))
  call Hloop_SS_S(ntryL,G0H4(12),ex3(:),G0H4(2),m3h1x4(:,103),heltab2x4(:,:,472))
  call Hloop_SS_S(ntryL,G0H4(13),ex3(:),G0H4(3),m3h1x4(:,104),heltab2x4(:,:,473))
  call Hloop_VT_S(ntryL,G0H4(14),17,ex3(:),4,G1H4(92),m3h1x4(:,105),heltab2x4(:,:,474))
  call Hloop_VT_S(ntryL,G0H4(15),17,ex3(:),4,G1H4(151),m3h1x4(:,106),heltab2x4(:,:,475))
  call Hloop_ST_V(ntryL,G0H4(16),17,ex3(:),4,G1H4(157),m3h1x4(:,107),heltab2x4(:,:,476))
  call Hloop_ST_V(ntryL,G0H4(17),17,ex3(:),4,G1H4(198),m3h1x4(:,108),heltab2x4(:,:,477))
  call Hloop_VS_V(ntryL,G0H4(18),ex3(:),G0H4(4),m3h1x4(:,109),heltab2x4(:,:,478))
  call Hloop_VS_V(ntryL,G0H4(19),ex3(:),G0H4(5),m3h1x4(:,110),heltab2x4(:,:,479))
  call Hloop_SA_Q(ntryL,G0H4(20),ex2(:),G0H2(37),ngH,m3h2x2(:,370),heltab2x4(:,:,480))
  call Hloop_A_Q(ntryL,G0H2(37),19,nMB,G1H2(504),n2h2(361))
  call Hloop_SA_Q(ntryL,G0H4(21),ex2(:),G0H2(37),ngX,m3h2x2(:,371),heltab2x4(:,:,481))
  call Hloop_A_Q(ntryL,G0H2(37),19,nMB,G1H2(505),n2h2(362))
  call Hloop_SA_Q(ntryL,G0H4(22),ex2(:),G0H2(37),ngPbt,m3h2x2(:,372),heltab2x4(:,:,482))
  call Hloop_A_Q(ntryL,G0H2(37),19,nMT,G1H2(509),n2h2(363))
  call Hloop_QA_S(ntryL,G1H4(217),ex2(:),G1H2(510),ngPbt,m3h2x2(:,373),heltab2x4(:,:,483))
  call Hloop_VA_Q(ntryL,G0H4(26),ex2(:),G0H2(37),m3h2x2(:,374),heltab2x4(:,:,484))
  call Hloop_A_Q(ntryL,G0H2(37),19,nMB,G1H2(515),n2h2(364))
  call Hloop_ZA_Q(ntryL,G0H4(24),ex2(:),G0H2(37),ngZd,m3h2x2(:,375),heltab2x4(:,:,485))
  call Hloop_A_Q(ntryL,G0H2(37),19,nMB,G1H2(516),n2h2(365))
  call Hloop_WA_Q(ntryL,G0H4(25),ex2(:),G0H2(37),m3h2x2(:,376),heltab2x4(:,:,486))
  call Hloop_A_Q(ntryL,G0H2(37),19,nMT,G1H2(521),n2h2(366))
  call Hloop_QA_S(ntryL,G1H4(218),ex2(:),G1H2(526),ngPbt,m3h2x2(:,377),heltab2x4(:,:,487))
  call Hloop_QA_S(ntryL,G1H4(233),ex2(:),G1H2(531),ngPbt,m3h2x2(:,378),heltab2x4(:,:,488))
  call Hloop_QA_W(ntryL,G1H4(234),ex2(:),G1H2(536),m3h2x2(:,379),heltab2x4(:,:,489))
  call Hloop_QA_S(ntryL,G1H4(10),ex2(:),G1H2(139),ngPbt,m3h2x2(:,380),heltab2x4(:,:,490))
  call Hloop_QA_W(ntryL,G1H4(12),ex2(:),G1H2(149),m3h2x2(:,381),heltab2x4(:,:,491))
  call Hloop_QA_W(ntryL,G1H4(3),ex2(:),G1H2(157),m3h2x2(:,382),heltab2x4(:,:,492))
  call Hloop_QA_W(ntryL,G1H4(5),ex2(:),G1H2(167),m3h2x2(:,383),heltab2x4(:,:,493))
  call Hloop_SA_Q(ntryL,G0H4(27),ex2(:),G0H2(37),ngH,m3h2x2(:,384),heltab2x4(:,:,494))
  call Hloop_A_Q(ntryL,G0H2(37),19,nMB,G1H2(175),n2h2(367))
  call Hloop_SA_Q(ntryL,G0H4(28),ex2(:),G0H2(37),ngX,m3h2x2(:,385),heltab2x4(:,:,495))
  call Hloop_A_Q(ntryL,G0H2(37),19,nMB,G1H2(185),n2h2(368))
  call Hloop_SA_Q(ntryL,G0H4(29),ex2(:),G0H2(37),ngPbt,m3h2x2(:,386),heltab2x4(:,:,496))
  call Hloop_A_Q(ntryL,G0H2(37),19,nMT,G1H2(193),n2h2(369))
  call Hloop_QA_S(ntryL,G1H4(6),ex2(:),G1H2(203),ngPbt,m3h2x2(:,387),heltab2x4(:,:,497))
  call Hloop_VA_Q(ntryL,G0H4(33),ex2(:),G0H2(37),m3h2x2(:,388),heltab2x4(:,:,498))
  call Hloop_A_Q(ntryL,G0H2(37),19,nMB,G1H2(211),n2h2(370))
  call Hloop_ZA_Q(ntryL,G0H4(31),ex2(:),G0H2(37),ngZd,m3h2x2(:,389),heltab2x4(:,:,499))
  call Hloop_A_Q(ntryL,G0H2(37),19,nMB,G1H2(24),n2h2(371))
  call Hloop_WA_Q(ntryL,G0H4(32),ex2(:),G0H2(37),m3h2x2(:,390),heltab2x4(:,:,500))
  call Hloop_A_Q(ntryL,G0H2(37),19,nMT,G1H2(252),n2h2(372))
  call Hloop_QA_S(ntryL,G1H4(9),ex2(:),G1H2(66),ngPbt,m3h2x2(:,391),heltab2x4(:,:,501))
  call Hloop_QA_S(ntryL,G1H4(15),ex2(:),G1H2(77),ngPbt,m3h2x2(:,392),heltab2x4(:,:,502))
  call Hloop_QA_W(ntryL,G1H4(16),ex2(:),G1H2(103),m3h2x2(:,393),heltab2x4(:,:,503))
  call Hloop_QA_S(ntryL,G1H4(17),ex2(:),G1H2(3),ngPbt,m3h2x2(:,394),heltab2x4(:,:,504))
  call Hloop_QA_W(ntryL,G1H4(18),ex2(:),G1H2(264),m3h2x2(:,395),heltab2x4(:,:,505))
  call Hloop_QA_W(ntryL,G1H4(30),ex2(:),G1H2(279),m3h2x2(:,396),heltab2x4(:,:,506))
  call Hloop_QA_W(ntryL,G1H4(31),ex2(:),G1H2(294),m3h2x2(:,397),heltab2x4(:,:,507))
  call Hloop_SS_S(ntryL,G0H4(34),ex3(:),G0H4(6),m3h1x4(:,111),heltab2x4(:,:,508))
  call Hloop_SS_S(ntryL,G0H4(35),ex3(:),G0H4(7),m3h1x4(:,112),heltab2x4(:,:,509))
  call Hloop_SS_S(ntryL,G0H4(36),ex3(:),G0H4(8),m3h1x4(:,113),heltab2x4(:,:,510))
  call Hloop_VT_S(ntryL,G0H4(37),18,ex3(:),4,G1H4(98),m3h1x4(:,114),heltab2x4(:,:,511))
  call Hloop_VT_S(ntryL,G0H4(38),18,ex3(:),4,G1H4(142),m3h1x4(:,115),heltab2x4(:,:,512))
  call Hloop_ST_V(ntryL,G0H4(39),18,ex3(:),4,G1H4(111),m3h1x4(:,116),heltab2x4(:,:,513))
  call Hloop_ST_V(ntryL,G0H4(40),18,ex3(:),4,G1H4(94),m3h1x4(:,117),heltab2x4(:,:,514))
  call Hloop_VS_V(ntryL,G0H4(41),ex3(:),G0H4(9),m3h1x4(:,118),heltab2x4(:,:,515))
  call Hloop_VS_V(ntryL,G0H4(42),ex3(:),G0H4(10),m3h1x4(:,119),heltab2x4(:,:,516))
  call Hloop_SQ_A(ntryL,G0H4(43),ex1(:),G0H2(37),ngH,m3h2x2(:,398),heltab2x4(:,:,517))
  call Hloop_Q_A(ntryL,G0H2(37),19,nMB,G1H2(427),n2h2(373))
  call Hloop_SQ_A(ntryL,G0H4(44),ex1(:),G0H2(37),ngX,m3h2x2(:,399),heltab2x4(:,:,518))
  call Hloop_Q_A(ntryL,G0H2(37),19,nMB,G1H2(438),n2h2(374))
  call Hloop_SQ_A(ntryL,G0H4(45),ex1(:),G0H2(37),ngPtb,m3h2x2(:,400),heltab2x4(:,:,519))
  call Hloop_Q_A(ntryL,G0H2(37),19,nMT,G1H2(449),n2h2(375))
  call Hloop_AQ_S(ntryL,G1H4(27),ex1(:),G1H2(460),ngPtb,m3h2x2(:,401),heltab2x4(:,:,520))
  call Hloop_VQ_A(ntryL,G0H4(49),ex1(:),G0H2(37),m3h2x2(:,402),heltab2x4(:,:,521))
  call Hloop_Q_A(ntryL,G0H2(37),19,nMB,G1H2(481),n2h2(376))
  call Hloop_ZQ_A(ntryL,G0H4(47),ex1(:),G0H2(37),ngZd,m3h2x2(:,403),heltab2x4(:,:,522))
  call Hloop_Q_A(ntryL,G0H2(37),19,nMB,G1H2(492),n2h2(377))
  call Hloop_WQ_A(ntryL,G0H4(48),ex1(:),G0H2(37),m3h2x2(:,404),heltab2x4(:,:,523))
  call Hloop_Q_A(ntryL,G0H2(37),19,nMT,G1H2(503),n2h2(378))
  call Hloop_AQ_S(ntryL,G1H4(48),ex1(:),G1H2(514),ngPtb,m3h2x2(:,405),heltab2x4(:,:,524))
  call Hloop_AQ_S(ntryL,G1H4(53),ex1(:),G1H2(48),ngPtb,m3h2x2(:,406),heltab2x4(:,:,525))
  call Hloop_AQ_W(ntryL,G1H4(58),ex1(:),G1H2(133),m3h2x2(:,407),heltab2x4(:,:,526))
  call Hloop_AQ_S(ntryL,G1H4(60),ex1(:),G1H2(217),ngPtb,m3h2x2(:,408),heltab2x4(:,:,527))
  call Hloop_AQ_W(ntryL,G1H4(128),ex1(:),G1H2(140),m3h2x2(:,409),heltab2x4(:,:,528))
  call Hloop_AQ_W(ntryL,G1H4(62),ex1(:),G1H2(59),m3h2x2(:,410),heltab2x4(:,:,529))
  call Hloop_AQ_W(ntryL,G1H4(36),ex1(:),G1H2(60),m3h2x2(:,411),heltab2x4(:,:,530))
  call Hloop_SQ_A(ntryL,G0H4(50),ex1(:),G0H2(37),ngH,m3h2x2(:,412),heltab2x4(:,:,531))
  call Hloop_Q_A(ntryL,G0H2(37),19,nMB,G1H2(268),n2h2(379))
  call Hloop_SQ_A(ntryL,G0H4(51),ex1(:),G0H2(37),ngX,m3h2x2(:,413),heltab2x4(:,:,532))
  call Hloop_Q_A(ntryL,G0H2(37),19,nMB,G1H2(284),n2h2(380))
  call Hloop_SQ_A(ntryL,G0H4(52),ex1(:),G0H2(37),ngPtb,m3h2x2(:,414),heltab2x4(:,:,533))
  call Hloop_Q_A(ntryL,G0H2(37),19,nMT,G1H2(8),n2h2(381))
  call Hloop_AQ_S(ntryL,G1H4(63),ex1(:),G1H2(205),ngPtb,m3h2x2(:,415),heltab2x4(:,:,534))
  call Hloop_VQ_A(ntryL,G0H4(56),ex1(:),G0H2(37),m3h2x2(:,416),heltab2x4(:,:,535))
  call Hloop_Q_A(ntryL,G0H2(37),19,nMB,G1H2(520),n2h2(382))
  call Hloop_ZQ_A(ntryL,G0H4(54),ex1(:),G0H2(37),ngZd,m3h2x2(:,417),heltab2x4(:,:,536))
  call Hloop_Q_A(ntryL,G0H2(37),19,nMB,G1H2(212),n2h2(383))
  call Hloop_WQ_A(ntryL,G0H4(55),ex1(:),G0H2(37),m3h2x2(:,418),heltab2x4(:,:,537))
  call Hloop_Q_A(ntryL,G0H2(37),19,nMT,G1H2(215),n2h2(384))
  call Hloop_AQ_S(ntryL,G1H4(51),ex1(:),G1H2(525),ngPtb,m3h2x2(:,419),heltab2x4(:,:,538))
  call Hloop_AQ_S(ntryL,G1H4(26),ex1(:),G1H2(300),ngPtb,m3h2x2(:,420),heltab2x4(:,:,539))
  call Hloop_AQ_W(ntryL,G1H4(71),ex1(:),G1H2(25),m3h2x2(:,421),heltab2x4(:,:,540))
  call Hloop_AQ_S(ntryL,G1H4(55),ex1(:),G1H2(126),ngPtb,m3h2x2(:,422),heltab2x4(:,:,541))
  call Hloop_AQ_W(ntryL,G1H4(72),ex1(:),G1H2(286),m3h2x2(:,423),heltab2x4(:,:,542))
  call Hloop_AQ_W(ntryL,G1H4(65),ex1(:),G1H2(127),m3h2x2(:,424),heltab2x4(:,:,543))
  call Hloop_AQ_W(ntryL,G1H4(81),ex1(:),G1H2(295),m3h2x2(:,425),heltab2x4(:,:,544))
  call Hloop_QA_S(ntryL,G1H8(456),ex2(:),G1H4(195),ngH,m3h2x4(:,427),heltab2x8(:,:,883))
  call Hloop_QA_S(ntryL,G1H8(457),ex2(:),G1H4(212),ngX,m3h2x4(:,428),heltab2x8(:,:,884))
  call Hloop_QA_S(ntryL,G1H8(458),ex2(:),G1H4(213),ngPbt,m3h2x4(:,429),heltab2x8(:,:,885))
  call Hloop_QA_V(ntryL,G1H8(463),ex2(:),G1H4(229),m3h2x4(:,430),heltab2x8(:,:,886))
  call Hloop_QA_Z(ntryL,G1H8(461),ex2(:),G1H4(82),ngZd,m3h2x4(:,431),heltab2x8(:,:,887))
  call Hloop_QA_W(ntryL,G1H8(462),ex2(:),G1H4(68),m3h2x4(:,432),heltab2x8(:,:,888))
  call Hloop_SA_Q(ntryL,G1H8(459),ex2(:),G1H4(93),ngPbt,m3h2x4(:,433),heltab2x8(:,:,889))
  call Hloop_A_Q(ntryL,G1H4(93),22,nMT,G2H4(72),n2h4(443))
  call Hloop_SA_Q(ntryL,G1H8(464),ex2(:),G1H4(139),ngPbt,m3h2x4(:,434),heltab2x8(:,:,890))
  call Hloop_A_Q(ntryL,G1H4(139),22,nMT,G2H4(3),n2h4(444))
  call Hloop_WA_Q(ntryL,G1H8(465),ex2(:),G1H4(217),m3h2x4(:,435),heltab2x8(:,:,891))
  call Hloop_A_Q(ntryL,G1H4(217),22,nMT,G2H4(8),n2h4(445))
  call Hloop_WA_Q(ntryL,G1H8(466),ex2(:),G1H4(218),m3h2x4(:,436),heltab2x8(:,:,892))
  call Hloop_A_Q(ntryL,G1H4(218),22,nMT,G2H4(73),n2h4(446))
  call Hloop_AQ_S(ntryL,G1H8(478),ex1(:),G1H4(233),ngH,m3h2x4(:,437),heltab2x8(:,:,893))
  call Hloop_AQ_S(ntryL,G1H8(479),ex1(:),G1H4(234),ngX,m3h2x4(:,438),heltab2x8(:,:,894))
  call Hloop_AQ_S(ntryL,G1H8(480),ex1(:),G1H4(10),ngPtb,m3h2x4(:,439),heltab2x8(:,:,895))
  call Hloop_AQ_V(ntryL,G1H8(485),ex1(:),G1H4(12),m3h2x4(:,440),heltab2x8(:,:,896))
  call Hloop_AQ_Z(ntryL,G1H8(483),ex1(:),G1H4(3),ngZd,m3h2x4(:,441),heltab2x8(:,:,897))
  call Hloop_AQ_W(ntryL,G1H8(484),ex1(:),G1H4(5),m3h2x4(:,442),heltab2x8(:,:,898))
  call Hloop_SQ_A(ntryL,G1H8(481),ex1(:),G1H4(6),ngPtb,m3h2x4(:,443),heltab2x8(:,:,899))
  call Hloop_Q_A(ntryL,G1H4(6),21,nMT,G2H4(74),n2h4(447))
  call Hloop_SQ_A(ntryL,G1H8(486),ex1(:),G1H4(9),ngPtb,m3h2x4(:,444),heltab2x8(:,:,900))
  call Hloop_Q_A(ntryL,G1H4(9),21,nMT,G2H4(63),n2h4(448))
  call Hloop_WQ_A(ntryL,G1H8(487),ex1(:),G1H4(15),m3h2x4(:,445),heltab2x8(:,:,901))
  call Hloop_Q_A(ntryL,G1H4(15),21,nMT,G2H4(64),n2h4(449))
  call Hloop_WQ_A(ntryL,G1H8(488),ex1(:),G1H4(16),m3h2x4(:,446),heltab2x8(:,:,902))
  call Hloop_Q_A(ntryL,G1H4(16),21,nMT,G2H4(65),n2h4(450))
  call Hloop_SQ_A(ntryL,G1H8(497),ex1(:),G1H4(17),ngH,m3h2x4(:,447),heltab2x8(:,:,903))
  call Hloop_Q_A(ntryL,G1H4(17),21,nMB,G2H4(29),n2h4(451))
  call Hloop_SQ_A(ntryL,G1H8(498),ex1(:),G1H4(18),ngX,m3h2x4(:,448),heltab2x8(:,:,904))
  call Hloop_Q_A(ntryL,G1H4(18),21,nMB,G2H4(67),n2h4(452))
  call Hloop_AQ_S(ntryL,G1H8(500),ex1(:),G1H4(30),ngPtb,m3h2x4(:,449),heltab2x8(:,:,905))
  call Hloop_AQ_S(ntryL,G1H8(501),ex1(:),G1H4(31),ngPtb,m3h2x4(:,450),heltab2x8(:,:,906))
  call Hloop_AQ_W(ntryL,G1H8(502),ex1(:),G1H4(27),m3h2x4(:,451),heltab2x8(:,:,907))
  call Hloop_AQ_W(ntryL,G1H8(504),ex1(:),G1H4(48),m3h2x4(:,452),heltab2x8(:,:,908))
  call Hloop_SQ_A(ntryL,G1H8(499),ex1(:),G1H4(53),ngPtb,m3h2x4(:,453),heltab2x8(:,:,909))
  call Hloop_Q_A(ntryL,G1H4(53),21,nMT,G2H4(68),n2h4(453))
  call Hloop_WQ_A(ntryL,G1H8(503),ex1(:),G1H4(58),m3h2x4(:,454),heltab2x8(:,:,910))
  call Hloop_Q_A(ntryL,G1H4(58),21,nMT,G2H4(69),n2h4(454))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(56),[G2H4(94),G2H4(20),G1H4(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(53),[G2H4(90),G2H4(27),G1H4(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(58),[G2H4(102),G2H4(33),G1H4(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(55),[G2H4(98),G2H4(37),G1H4(190)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(85),[G2H4(75),G2H4(40),G1H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(82),[G2H4(59),G2H4(45),G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(89),[G2H4(83),G2H4(51),G1H4(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(84),[G2H4(79),G2H4(57),G1H4(59)])
call ol_merge_last(G1H2(9), G1H2(9)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(70),[G1H2(9)])
call ol_merge_last(G2H2(71), G2H2(71)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(71),[G1H2(10)])
call ol_merge_last(G2H4(86), G2H4(86)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(86),[G1H4(28)])
call ol_merge_last(G1H4(42), G1H4(42)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(88),[G1H4(42)])
call ol_merge_last(G1H2(11), G1H2(11)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(100),[G1H2(11)])
call HGT_OLR(G2H2(100),1,1,2)
call HGT_invQ_OLR(G2H2(100),2,5,2)
call HGT_OLR(G2H2(100),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(100),[G1H2(405)])
call ol_merge_last(G2H2(101), G2H2(101)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(101),[G1H2(12)])
call HGT_lower_alpha_w2_OLR(G2H2(101),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(101),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(101),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(101),[G1H2(416)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(427),[G1H2(2)])
call HGT_OLR(G1H2(13),1,1,2)
call HGT_invQ_OLR(G1H2(13),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(13),[G1H2(427)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(106),[G1H4(118)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(492),[G1H2(438),G1H2(7)])
call HGT_OLR(G1H2(14),1,1,2)
call HGT_invQ_OLR(G1H2(14),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(14),[G1H2(492)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(110),[G1H4(22)])
call ol_merge_last(G1H2(16), G1H2(16)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(16),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(503),[G1H2(449),G1H2(27)])
call HGT_OLR(G1H2(16),1,1,2)
call HGT_invQ_OLR(G1H2(16),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(16),[G1H2(503)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(114),[G1H4(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(118),[G1H4(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(67),[G2H4(31)])
call HGT_OLR(G1H4(120),1,1,4)
call HGT_invQ_OLR(G1H4(120),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(67),[G1H4(120)])
call HGT_OLR(G1H4(121),1,1,4)
call HGT_invQ_OLR(G1H4(121),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(29),[G1H4(121)])
call ol_merge_last(G2H4(121), G2H4(121)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(121),[G1H4(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(68),[G2H4(35)])
call HGT_OLR(G2H4(121),1,1,4)
call HGT_invQ_OLR(G2H4(121),2,5,4)
call HGT_OLR(G2H4(121),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(121),[G2H4(68)])
call HGT_lower_alpha_w2_OLR(G2H4(122),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(122),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(122),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(122),[G2H4(25)])
call ol_merge_last(G1H4(8), G1H4(8)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(123),[G1H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(69),[G2H4(30)])
call HGT_lower_alpha_w2_OLR(G2H4(123),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(123),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(123),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(123),[G2H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(268),[G1H2(63)])
call HGT_OLR(G1H2(17),1,1,2)
call HGT_invQ_OLR(G1H2(17),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(17),[G1H2(268)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(131),[G1H2(250)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(212),[G1H2(284),G1H2(69)])
call HGT_OLR(G1H2(18),1,1,2)
call HGT_invQ_OLR(G1H2(18),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(18),[G1H2(212)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(135),[G1H2(266)])
call ol_merge_last(G1H2(20), G1H2(20)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(20),[G1H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(215),[G1H2(8),G1H2(75)])
call HGT_OLR(G1H2(20),1,1,2)
call HGT_invQ_OLR(G1H2(20),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(20),[G1H2(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(139),[G1H2(282)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(143),[G1H2(298)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(233),[G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(174),[G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(234),[G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(175),[G1H4(154),G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G1H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(113),[G1H4(107),G1H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(179),[G1H4(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(3),[G1H4(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(180),[G1H4(165),G1H4(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(5),[G1H4(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(181),[G1H4(173),G1H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(174),[G2H2(165),G2H2(106),G2H2(94),G1H2(34),G1H2(22) &
    ,G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(171),[G2H2(148),G2H2(99),G2H2(88),G1H2(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(481),[G1H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(48),[G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(237),[G2H2(233),G2H2(231),G2H2(230),G1H2(369),G1H2(364) &
    ,G1H2(357),G1H2(136),G1H2(40),G0H2(32),G0H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(133),[G1H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(117),[G2H2(112),G1H2(456),G1H2(451),G1H2(440),G1H2(434) &
    ,G1H2(46),G0H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(217),[G1H2(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(152),[G2H2(138),G1H2(488),G1H2(483),G1H2(472),G1H2(462) &
    ,G1H2(52),G0H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(140),[G1H2(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(248),[G2H2(245),G2H2(242),G2H2(238),G1H2(374),G1H2(363) &
    ,G1H2(358),G1H2(154),G1H2(58),G0H2(30),G0H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(195),[G1H4(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(235),[G1H4(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(212),[G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(240),[G1H4(140),G1H4(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(213),[G1H4(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(236),[G1H4(95),G1H4(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(229),[G1H4(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(241),[G1H4(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(82),[G1H4(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(244),[G1H4(110),G1H4(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(68),[G1H4(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G1H4(106),G1H4(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G2H2(227),G2H2(2),G2H2(197),G1H2(88),G1H2(70) &
    ,G1H2(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G2H2(11),G2H2(215),G2H2(193),G1H2(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(205),[G1H2(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G2H2(28),G1H2(230),G1H2(168),G1H2(143),G1H2(82) &
    ,G0H2(9),G0H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(520),[G1H2(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(525),[G1H2(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(118),[G2H2(122),G1H2(91),G1H2(79),G1H2(218),G1H2(21) &
    ,G1H2(94),G0H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(127),[G1H2(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G2H2(1),G1H2(273),G1H2(269),G1H2(36),G1H2(107) &
    ,G1H2(100),G0H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(295),[G1H2(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(46),[G2H2(43),G1H2(204),G1H2(197),G1H2(161),G1H2(106) &
    ,G0H2(17),G0H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(504),[G1H2(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(172),[G2H2(163),G2H2(102),G2H2(90),G1H2(130),G1H2(118) &
    ,G1H2(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(516),[G1H2(505),G1H2(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(521),[G1H2(509),G1H2(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(169),[G2H2(114),G2H2(95),G2H2(84),G1H2(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(515),[G1H2(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(531),[G1H2(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(536),[G1H2(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(113),[G2H2(108),G1H2(455),G1H2(450),G1H2(439),G1H2(433) &
    ,G1H2(142),G0H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(139),[G1H2(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(149),[G2H2(134),G1H2(487),G1H2(482),G1H2(467),G1H2(461) &
    ,G1H2(148),G0H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(149),[G1H2(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(175),[G1H2(159)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G2H2(234),G2H2(3),G2H2(200),G1H2(184),G1H2(166) &
    ,G1H2(160)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(24),[G1H2(185),G1H2(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(252),[G1H2(193),G1H2(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G2H2(12),G2H2(218),G2H2(196),G1H2(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(203),[G1H2(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(36),[G2H2(34),G1H2(176),G1H2(169),G1H2(224),G1H2(178) &
    ,G0H2(10),G0H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(211),[G1H2(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(66),[G1H2(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(126),[G2H2(130),G1H2(95),G1H2(83),G1H2(227),G1H2(535) &
    ,G1H2(190),G0H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(279),[G1H2(195)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G2H2(6),G1H2(41),G1H2(38),G1H2(247),G1H2(108) &
    ,G1H2(196),G0H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(294),[G1H2(201)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(50),[G2H2(49),G1H2(53),G1H2(471),G1H2(373),G1H2(202) &
    ,G0H2(18),G0H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(98),[G1H4(138),G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(142),[G1H4(96),G0H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(111),[G1H4(146),G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(94),[G1H4(105),G0H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(92),[G1H4(153),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(151),[G1H4(160),G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(157),[G1H4(164),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(198),[G1H4(171),G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(21),[G1H4(117)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(22),[G1H4(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(19),[G1H4(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(24),[G1H4(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(74),[G1H2(249)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(78),[G1H2(265)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(140),[G1H2(281)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(144),[G1H2(297)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(64),[G2H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(74),[G2H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(65),[G2H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(63),[G2H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G2H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(72),[G2H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(73),[G2H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G2H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(38),[G1H4(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(34),[G1H4(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(41),[G1H4(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(39),[G1H4(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(243),[G2H2(175),G2H2(209),G2H2(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(246),[G2H2(181),G2H2(214),G2H2(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G2H2(37),G1H2(368),G1H2(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G2H2(39),G1H2(158),G1H2(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G2H2(16),G1H2(245),G1H2(242),G1H2(236),G1H2(233) &
    ,G1H2(30),G1H2(530),G0H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(56),[G2H2(54),G2H2(53),G2H2(51),G1H2(466),G1H2(187) &
    ,G1H2(179),G0H2(14),G0H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(63),[G2H2(60),G2H2(58),G2H2(57),G1H2(194),G1H2(186) &
    ,G1H2(235),G0H2(12),G0H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(184),[G2H2(178),G1H2(280),G1H2(125),G1H2(262),G1H2(259) &
    ,G1H2(116),G1H2(258),G0H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(166),[G2H2(153),G2H2(79),G2H2(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(168),[G2H2(156),G2H2(83),G2H2(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(183),[G2H2(177),G1H2(352),G1H2(346),G1H2(324),G0H2(27) &
    ,G0H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(186),[G2H2(180),G1H2(353),G1H2(347),G1H2(325),G0H2(28) &
    ,G0H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(205),[G2H2(201),G1H2(335),G1H2(330)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(208),[G2H2(204),G1H2(336),G1H2(331)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(223),[G2H2(219),G1H2(384),G1H2(378),G1H2(341),G0H2(35) &
    ,G0H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(226),[G2H2(222),G1H2(385),G1H2(379),G1H2(342),G0H2(36) &
    ,G0H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(125),[G2H2(121),G1H2(445),G1H2(444),G1H2(429),G1H2(428) &
    ,G1H2(423),G1H2(422),G0H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(133),[G2H2(129),G1H2(499),G1H2(498),G1H2(494),G1H2(493) &
    ,G1H2(477),G1H2(476),G0H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(143),[G1H8(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(145),[G1H8(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(26),[G1H8(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(28),[G1H8(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(21),[G1H8(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(22),[G1H8(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(17),[G0H8(259)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(13),[G0H8(251)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(14),[G0H8(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(15),[G0H8(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(16),[G0H8(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(20),[G0H8(249)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(19),[G0H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(21),[G0H8(250)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(22),[G0H8(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(18),[G0H8(245)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(38),[G1H8(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(9),[G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(279),[G1H8(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(281),[G1H8(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(299),[G1H8(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(301),[G1H8(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(382),[G1H8(247)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(396),[G1H8(249)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(423),[G1H8(267)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(437),[G1H8(268)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(345),[G1H8(271)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(356),[G1H8(272)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(43),[G0H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(44),[G0H8(246)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(45),[G0H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(46),[G0H8(247)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(35),[G0H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(36),[G0H8(256)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(37),[G0H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(38),[G0H8(257)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(47),[G0H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(48),[G0H8(248)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(49),[G0H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(50),[G0H8(255)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(39),[G0H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(40),[G0H8(258)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(41),[G0H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(42),[G0H8(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(445),[G1H8(315)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(446),[G1H8(326)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(47),[G1H4(162)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(48),[G1H4(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(52),[G1H4(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(60),[G1H4(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(61),[G1H4(208)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(62),[G1H4(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(76),[G1H4(203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(78),[G1H4(220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(80),[G1H4(223)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(81),[G1H4(224)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(91),[G1H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(92),[G1H4(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(93),[G1H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(95),[G1H4(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(97),[G1H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(99),[G1H4(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(100),[G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(482),[G1H8(449)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(473),[G1H8(450)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(59),[G0H8(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(57),[G0H8(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(58),[G0H8(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(471),[G1H8(470)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(101),[G1H4(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(104),[G1H4(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(107),[G1H4(194)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(108),[G1H4(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(109),[G1H4(188)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(112),[G1H4(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(113),[G1H4(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(115),[G1H4(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(452),[G1H8(496)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(453),[G1H8(474)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(68),[G0H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(66),[G0H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(67),[G0H8(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(455),[G1H8(454)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(116),[G1H4(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(119),[G1H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(66),[G1H4(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(70),[G1H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(71),[G1H4(80)])
call HGT_w2_OLR(G1H4(123),1,1,4)
call HGT_w2_invQ_OLR(G1H4(123),2,5,4)
  call Hloop_SQ_A(ntryL,G1H4(123),ex1(:),G1H2(128),ngPtb,m3h2x2(:,426),heltab2x4(:,:,545))
  call Hloop_Q_A(ntryL,G1H2(128),29,nMT,G2H2(249),n2h2(385))
  call Hloop_QA_S(ntryL,G2H4(56),ex2(:),G2H2(251),ngPbt,m3h2x2(:,427),heltab2x4(:,:,546))
call HGT_OLR(G2H4(26),1,1,4)
call HGT_invQ_OLR(G2H4(26),2,5,4)
call HGT_OLR(G2H4(26),6,15,4)
  call Hotf_4pt_reduction(G2H4(26),RedSet_4(47),mass4set(:,4),  & 
G1H4(60),G1H4(128),G1H4(62),G1H4(36),G1H4(63),4)
  call HG1shiftOLR(G1H4(128),2,4)
  call Hloop_QA_S(ntryL,G2H4(53),ex2(:),G2H2(254),ngPbt,m3h2x2(:,428),heltab2x4(:,:,547))
call HGT_lower_alpha_OLR(G2H4(32),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(32),2,5,4)
call HGT_lower_alpha_OLR(G2H4(32),6,15,4)
  call Hotf_4pt_reduction(G2H4(32),RedSet_4(47),mass4set(:,4),  & 
G1H4(51),G1H4(26),G1H4(71),G1H4(55),G1H4(72),4)
  call HG1shiftOLR(G1H4(26),2,4)
  call Hloop_QA_W(ntryL,G2H4(58),ex2(:),G2H2(256),m3h2x2(:,429),heltab2x4(:,:,548))
call HGT_lower_alpha_w2_OLR(G1H4(124),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G1H4(124),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(124),ex1(:),G1H2(306),m3h2x2(:,430),heltab2x4(:,:,549))
  call Hloop_Q_A(ntryL,G1H2(306),29,nMT,G2H2(259),n2h2(386))
  call Hloop_QA_W(ntryL,G2H4(55),ex2(:),G2H2(261),m3h2x2(:,431),heltab2x4(:,:,550))
call HGT_w2_OLR(G1H4(122),1,1,4)
call HGT_w2_invQ_OLR(G1H4(122),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(122),ex2(:),G1H2(307),ngPbt,m3h2x2(:,432),heltab2x4(:,:,551))
  call Hloop_A_Q(ntryL,G1H2(307),30,nMT,G2H2(264),n2h2(387))
  call Hloop_AQ_S(ntryL,G2H4(85),ex1(:),G2H2(266),ngPtb,m3h2x2(:,433),heltab2x4(:,:,552))
call HGT_OLR(G2H4(46),1,1,4)
call HGT_invQ_OLR(G2H4(46),2,5,4)
call HGT_OLR(G2H4(46),6,15,4)
  call Hotf_4pt_reduction(G2H4(46),RedSet_4(48),mass4set(:,4),  & 
G1H4(65),G1H4(81),G1H4(93),G1H4(139),G1H4(217),4)
  call HG1shiftOLR(G1H4(81),1,4)
  call Hloop_AQ_S(ntryL,G2H4(82),ex1(:),G2H2(269),ngPtb,m3h2x2(:,434),heltab2x4(:,:,553))
call HGT_lower_alpha_OLR(G2H4(50),1,1,4)
call HGT_lower_alpha_invQ_OLR(G2H4(50),2,5,4)
call HGT_lower_alpha_OLR(G2H4(50),6,15,4)
  call Hotf_4pt_reduction(G2H4(50),RedSet_4(48),mass4set(:,4),  & 
G1H4(218),G1H4(6),G1H4(9),G1H4(15),G1H4(16),4)
  call HG1shiftOLR(G1H4(6),1,4)
  call Hloop_AQ_W(ntryL,G2H4(89),ex1(:),G2H2(271),m3h2x2(:,435),heltab2x4(:,:,554))
call HGT_lower_alpha_w2_OLR(G1H4(125),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G1H4(125),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(125),ex2(:),G1H2(310),m3h2x2(:,436),heltab2x4(:,:,555))
  call Hloop_A_Q(ntryL,G1H2(310),30,nMT,G2H2(274),n2h2(388))
  call Hloop_AQ_W(ntryL,G2H4(84),ex1(:),G2H2(276),m3h2x2(:,437),heltab2x4(:,:,556))
call HGT_OLR(G2H2(70),1,1,2)
call HGT_invQ_OLR(G2H2(70),2,5,2)
call HGT_OLR(G2H2(70),6,15,2)
  call Hotf_4pt_reduction(G2H2(70),RedSet_4(49),mass4set(:,3),  & 
G1H2(313),G1H2(314),G1H2(319),G1H2(320),G1H2(389),2)
  call HG1shiftOLR(G1H2(314),1,2)
call HGT_lower_alpha_w2_OLR(G2H2(71),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(71),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(71),6,15,2)
  call Hotf_4pt_reduction(G2H2(71),RedSet_4(49),mass4set(:,3),  & 
G1H2(390),G1H2(395),G1H2(396),G1H2(400),G1H2(401),2)
  call HG1shiftOLR(G1H2(395),1,2)
call HGT_OLR(G1H4(23),1,1,4)
call HGT_invQ_OLR(G1H4(23),2,5,4)
  call Hloop_AV_Q(ntryL,G1H4(23),ex4(:),G1H2(406),m3h2x2(:,438),heltab2x4(:,:,557))
  call Hloop_A_Q(ntryL,G1H2(406),30,nMB,G2H2(279),n2h2(389))
  call Hloop_AQ_S(ntryL,G2H2(73),ex1(:),G2H1(1),ngH,m3h2x1(:,340),heltab2x2(:,:,447))
call HGT_OLR(G1H4(38),1,1,4)
call HGT_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_AV_Q(ntryL,G1H4(38),ex4(:),G1H2(407),m3h2x2(:,439),heltab2x4(:,:,558))
  call Hloop_A_Q(ntryL,G1H2(407),30,nMB,G2H2(281),n2h2(390))
  call Hloop_AQ_S(ntryL,G2H2(77),ex1(:),G2H1(2),ngX,m3h2x1(:,341),heltab2x2(:,:,448))
call HGT_OLR(G2H4(86),1,1,4)
call HGT_invQ_OLR(G2H4(86),2,5,4)
call HGT_OLR(G2H4(86),6,15,4)
  call Hotf_4pt_reduction(G2H4(86),RedSet_4(50),mass4set(:,3),  & 
G1H4(17),G1H4(18),G1H4(53),G1H4(58),G1H4(186),4)
  call HG1shiftOLR(G1H4(18),1,4)
  call Hloop_AQ_S(ntryL,G2H2(81),ex1(:),G2H1(3),ngPtb,m3h2x1(:,342),heltab2x2(:,:,449))
  call Hloop_AQ_S(ntryL,G2H2(85),ex1(:),G2H1(4),ngPtb,m3h2x1(:,343),heltab2x2(:,:,450))
call HGT_lower_alpha_w2_OLR(G2H4(87),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(87),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(87),6,15,4)
  call Hotf_4pt_reduction(G2H4(87),RedSet_4(50),mass4set(:,1),  & 
G1H4(183),G1H4(193),G1H4(190),G1H4(49),G1H4(40),4)
  call HG1shiftOLR(G1H4(193),1,4)
  call Hloop_AQ_Z(ntryL,G2H2(89),ex1(:),G2H1(5),ngZd,m3h2x1(:,344),heltab2x2(:,:,451))
call HGT_lower_alpha_w2_OLR(G2H4(88),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(88),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(88),6,15,4)
  call Hotf_4pt_reduction(G2H4(88),RedSet_4(50),mass4set(:,3),  & 
G1H4(67),G1H4(59),G1H4(28),G1H4(42),G1H4(118),4)
  call HG1shiftOLR(G1H4(59),1,4)
  call Hloop_AQ_W(ntryL,G2H2(93),ex1(:),G2H1(6),m3h2x1(:,345),heltab2x2(:,:,452))
  call Hloop_AQ_W(ntryL,G2H2(97),ex1(:),G2H1(7),m3h2x1(:,346),heltab2x2(:,:,453))
  call Hotf_4pt_reduction(G2H2(100),RedSet_4(51),mass4set(:,3),  & 
G1H2(411),G1H2(412),G1H2(417),G1H2(418),G1H2(9),2)
  call HG1shiftOLR(G1H2(412),2,2)
  call Hotf_4pt_reduction(G2H2(101),RedSet_4(51),mass4set(:,3),  & 
G1H2(10),G1H2(11),G1H2(405),G1H2(12),G1H2(416),2)
  call HG1shiftOLR(G1H2(11),2,2)
  call Hloop_QS_A(ntryL,G1H2(13),ex3(:),G1H2(2),ngH,m3h1x2(:,108),heltab2x2(:,:,454))
  call Hloop_Q_A(ntryL,G1H2(2),23,nMB,G2H2(284),n2h2(391))
  call Hotf_4pt_reduction(G2H4(106),RedSet_4(42),mass4set(:,1),  & 
G1H4(22),G1H4(216),G1H4(232),G1H4(120),G1H4(121),4)
  call HG1shiftOLR(G1H4(216),2,4)
  call Hloop_QS_A(ntryL,G1H2(14),ex3(:),G1H2(427),ngH,m3h1x2(:,109),heltab2x2(:,:,455))
  call Hloop_Q_A(ntryL,G1H2(427),23,nMB,G2H2(286),n2h2(392))
  call Hotf_4pt_reduction(G2H4(110),RedSet_4(42),mass4set(:,2),  & 
G1H4(119),G1H4(8),G1H4(1),G1H4(2),G1H4(11),4)
  call HG1shiftOLR(G1H4(8),2,4)
  call Hloop_QS_A(ntryL,G1H2(16),ex3(:),G1H2(438),ngH,m3h1x2(:,110),heltab2x2(:,:,456))
  call Hloop_Q_A(ntryL,G1H2(438),23,nMT,G2H2(165),n2h2(393))
  call Hotf_4pt_reduction(G2H4(114),RedSet_4(42),mass4set(:,3),  & 
G1H4(154),G1H4(14),G1H4(19),G1H4(107),G1H4(29),4)
  call HG1shiftOLR(G1H4(14),2,4)
  call Hotf_4pt_reduction(G2H4(118),RedSet_4(42),mass4set(:,3),  & 
G1H4(44),G1H4(46),G1H4(50),G1H4(165),G1H4(57),4)
  call HG1shiftOLR(G1H4(46),2,4)
  call Hotf_4pt_reduction(G2H4(67),RedSet_4(52),mass4set(:,2),  & 
G1H4(61),G1H4(173),G1H4(54),G1H4(66),G1H4(70),4)
  call HG1shiftOLR(G1H4(173),2,4)
  call Hloop_QA_S(ntryL,G2H2(103),ex2(:),G2H1(8),ngH,m3h2x1(:,347),heltab2x2(:,:,457))
  call Hotf_4pt_reduction(G2H4(29),RedSet_4(52),mass4set(:,1),  & 
G1H4(35),G1H4(140),G1H4(78),G1H4(84),G1H4(95),4)
  call HG1shiftOLR(G1H4(140),2,4)
  call Hloop_QA_S(ntryL,G2H2(107),ex2(:),G2H1(115),ngX,m3h2x1(:,348),heltab2x2(:,:,458))
  call Hotf_4pt_reduction(G2H4(121),RedSet_4(52),mass4set(:,3),  & 
G1H4(126),G1H4(87),G1H4(91),G1H4(76),G1H4(110),4)
  call HG1shiftOLR(G1H4(87),2,4)
  call Hloop_QA_S(ntryL,G2H2(111),ex2(:),G2H1(117),ngPbt,m3h2x1(:,349),heltab2x2(:,:,459))
  call Hloop_QA_S(ntryL,G2H2(115),ex2(:),G2H1(121),ngPbt,m3h2x1(:,350),heltab2x2(:,:,460))
  call Hotf_4pt_reduction(G2H4(122),RedSet_4(52),mass4set(:,1),  & 
G1H4(131),G1H4(135),G1H4(106),G1H4(89),G1H4(138),4)
  call HG1shiftOLR(G1H4(135),2,4)
  call Hloop_QA_Z(ntryL,G2H2(119),ex2(:),G2H1(123),ngZd,m3h2x1(:,351),heltab2x2(:,:,461))
  call Hotf_4pt_reduction(G2H4(123),RedSet_4(52),mass4set(:,3),  & 
G1H4(96),G1H4(146),G1H4(105),G1H4(153),G1H4(160),4)
  call HG1shiftOLR(G1H4(146),2,4)
  call Hloop_QA_W(ntryL,G2H2(123),ex2(:),G2H1(79),m3h2x1(:,352),heltab2x2(:,:,462))
  call Hloop_QA_W(ntryL,G2H2(127),ex2(:),G2H1(70),m3h2x1(:,353),heltab2x2(:,:,463))
  call Hloop_QV_A(ntryL,G1H2(17),ex4(:),G1H1(138),m3h2x1(:,354),heltab2x2(:,:,464))
  call Hloop_Q_A(ntryL,G1H1(138),27,nMB,G2H1(82),n2h1(225))
  call Hotf_4pt_reduction(G2H2(131),RedSet_4(45),mass4set(:,1),  & 
G1H2(7),G1H2(492),G1H2(15),G1H2(449),G1H2(27),2)
  call HG1shiftOLR(G1H2(492),2,2)
  call Hloop_QV_A(ntryL,G1H2(18),ex4(:),G1H1(99),m3h2x1(:,355),heltab2x2(:,:,465))
  call Hloop_Q_A(ntryL,G1H1(99),27,nMB,G2H1(76),n2h1(226))
  call Hotf_4pt_reduction(G2H2(135),RedSet_4(45),mass4set(:,2),  & 
G1H2(503),G1H2(63),G1H2(268),G1H2(250),G1H2(284),2)
  call HG1shiftOLR(G1H2(63),2,2)
  call Hloop_QV_A(ntryL,G1H2(20),ex4(:),G1H1(142),m3h2x1(:,356),heltab2x2(:,:,466))
  call Hloop_Q_A(ntryL,G1H1(142),27,nMT,G2H1(109),n2h1(227))
  call Hotf_4pt_reduction(G2H2(139),RedSet_4(45),mass4set(:,3),  & 
G1H2(69),G1H2(212),G1H2(266),G1H2(19),G1H2(8),2)
  call HG1shiftOLR(G1H2(212),2,2)
  call Hotf_4pt_reduction(G2H2(143),RedSet_4(45),mass4set(:,3),  & 
G1H2(75),G1H2(215),G1H2(282),G1H2(298),G1H2(34),2)
  call HG1shiftOLR(G1H2(215),2,2)
  call Hloop_SA_Q(ntryL,G1H4(233),ex2(:),G1H2(22),ngH,m3h2x2(:,440),heltab2x4(:,:,559))
  call Hloop_A_Q(ntryL,G1H2(22),23,nMB,G2H2(106),n2h2(394))
  call Hloop_SA_Q(ntryL,G1H4(174),ex2(:),G1H2(4),ngH,m3h2x2(:,441),heltab2x4(:,:,560))
  call Hloop_A_Q(ntryL,G1H2(4),23,nMB,G2H2(94),n2h2(395))
  call Hloop_SA_Q(ntryL,G1H4(234),ex2(:),G1H2(28),ngX,m3h2x2(:,442),heltab2x4(:,:,561))
  call Hloop_A_Q(ntryL,G1H2(28),23,nMB,G2H2(148),n2h2(396))
  call Hloop_SA_Q(ntryL,G1H4(175),ex2(:),G1H2(33),ngX,m3h2x2(:,443),heltab2x4(:,:,562))
  call Hloop_A_Q(ntryL,G1H2(33),23,nMB,G2H2(99),n2h2(397))
  call Hloop_SA_Q(ntryL,G1H4(10),ex2(:),G1H2(39),ngPbt,m3h2x2(:,444),heltab2x4(:,:,563))
  call Hloop_A_Q(ntryL,G1H2(39),23,nMT,G2H2(88),n2h2(398))
  call Hloop_SA_Q(ntryL,G1H4(113),ex2(:),G1H2(369),ngPbt,m3h2x2(:,445),heltab2x4(:,:,564))
  call Hloop_A_Q(ntryL,G1H2(369),23,nMT,G2H2(233),n2h2(399))
  call Hloop_VA_Q(ntryL,G1H4(12),ex2(:),G1H2(364),m3h2x2(:,446),heltab2x4(:,:,565))
  call Hloop_A_Q(ntryL,G1H2(364),23,nMB,G2H2(231),n2h2(400))
  call Hloop_VA_Q(ntryL,G1H4(179),ex2(:),G1H2(357),m3h2x2(:,447),heltab2x4(:,:,566))
  call Hloop_A_Q(ntryL,G1H2(357),23,nMB,G2H2(230),n2h2(401))
  call Hloop_ZA_Q(ntryL,G1H4(3),ex2(:),G1H2(136),ngZd,m3h2x2(:,448),heltab2x4(:,:,567))
  call Hloop_A_Q(ntryL,G1H2(136),23,nMB,G2H2(112),n2h2(402))
  call Hloop_ZA_Q(ntryL,G1H4(180),ex2(:),G1H2(40),ngZd,m3h2x2(:,449),heltab2x4(:,:,568))
  call Hloop_A_Q(ntryL,G1H2(40),23,nMB,G2H2(138),n2h2(403))
  call Hloop_WA_Q(ntryL,G1H4(5),ex2(:),G1H2(45),m3h2x2(:,450),heltab2x4(:,:,569))
  call Hloop_A_Q(ntryL,G1H2(45),23,nMT,G2H2(245),n2h2(404))
  call Hloop_WA_Q(ntryL,G1H4(181),ex2(:),G1H2(456),m3h2x2(:,451),heltab2x4(:,:,570))
  call Hloop_A_Q(ntryL,G1H2(456),23,nMT,G2H2(242),n2h2(405))
  call Hotf_4pt_reduction(G2H2(174),RedSet_4(15),mass4set(:,16),  & 
G1H2(451),G1H2(440),G1H2(434),G1H2(46),G1H2(51),G0H2(37),2)
  call HG1shiftOLR(G1H2(440),8,2)
  call Hotf_4pt_reduction(G2H2(171),RedSet_4(15),mass4set(:,17),  & 
G1H2(488),G1H2(483),G1H2(472),G1H2(462),G1H2(52),G0H2(32),2)
  call HG1shiftOLR(G1H2(483),8,2)
  call Hloop_QS_A(ntryL,G1H2(481),ex3(:),G1H2(57),ngH,m3h1x2(:,111),heltab2x2(:,:,467))
  call Hloop_Q_A(ntryL,G1H2(57),23,nMB,G2H2(238),n2h2(406))
  call Hloop_ST_V(ntryL,G1H2(48),19,ex3(:),4,G2H2(227),m3h1x2(:,112),heltab2x2(:,:,468))
  call Hotf_4pt_reduction(G2H2(237),RedSet_4(15),mass4set(:,18),  & 
G1H2(374),G1H2(363),G1H2(358),G1H2(154),G1H2(58),2)
  call HG1shiftOLR(G1H2(363),8,2)
  call Hloop_VT_S(ntryL,G1H2(133),19,ex3(:),4,G2H2(2),m3h1x2(:,113),heltab2x2(:,:,469))
  call Hotf_4pt_reduction(G2H2(117),RedSet_4(15),mass4set(:,18),  & 
G1H2(88),G1H2(70),G1H2(64),G1H2(76),G1H2(81),G0H2(31),2)
  call HG1shiftOLR(G1H2(70),8,2)
  call Hloop_ST_V(ntryL,G1H2(217),19,ex3(:),4,G2H2(197),m3h1x2(:,114),heltab2x2(:,:,470))
  call Hotf_4pt_reduction(G2H2(152),RedSet_4(15),mass4set(:,18),  & 
G1H2(230),G1H2(168),G1H2(143),G1H2(82),G1H2(87),G0H2(21),2)
  call HG1shiftOLR(G1H2(168),8,2)
  call Hloop_VT_S(ntryL,G1H2(140),19,ex3(:),4,G2H2(11),m3h1x2(:,115),heltab2x2(:,:,471))
  call Hotf_4pt_reduction(G2H2(248),RedSet_4(15),mass4set(:,18),  & 
G1H2(93),G1H2(91),G1H2(79),G1H2(218),G1H2(21),2)
  call HG1shiftOLR(G1H2(91),8,2)
  call Hloop_SQ_A(ntryL,G1H4(195),ex1(:),G1H2(94),ngH,m3h2x2(:,452),heltab2x4(:,:,571))
  call Hloop_Q_A(ntryL,G1H2(94),23,nMB,G2H2(215),n2h2(407))
  call Hloop_SQ_A(ntryL,G1H4(235),ex1(:),G1H2(99),ngH,m3h2x2(:,453),heltab2x4(:,:,572))
  call Hloop_Q_A(ntryL,G1H2(99),23,nMB,G2H2(193),n2h2(408))
  call Hloop_SQ_A(ntryL,G1H4(212),ex1(:),G1H2(273),ngX,m3h2x2(:,454),heltab2x4(:,:,573))
  call Hloop_Q_A(ntryL,G1H2(273),23,nMB,G2H2(28),n2h2(409))
  call Hloop_SQ_A(ntryL,G1H4(240),ex1(:),G1H2(269),ngX,m3h2x2(:,455),heltab2x4(:,:,574))
  call Hloop_Q_A(ntryL,G1H2(269),23,nMB,G2H2(122),n2h2(410))
  call Hloop_SQ_A(ntryL,G1H4(213),ex1(:),G1H2(36),ngPtb,m3h2x2(:,456),heltab2x4(:,:,575))
  call Hloop_Q_A(ntryL,G1H2(36),23,nMT,G2H2(1),n2h2(411))
  call Hloop_SQ_A(ntryL,G1H4(236),ex1(:),G1H2(107),ngPtb,m3h2x2(:,457),heltab2x4(:,:,576))
  call Hloop_Q_A(ntryL,G1H2(107),23,nMT,G2H2(43),n2h2(412))
  call Hloop_VQ_A(ntryL,G1H4(229),ex1(:),G1H2(100),m3h2x2(:,458),heltab2x4(:,:,577))
  call Hloop_Q_A(ntryL,G1H2(100),23,nMB,G2H2(163),n2h2(413))
  call Hloop_VQ_A(ntryL,G1H4(241),ex1(:),G1H2(105),m3h2x2(:,459),heltab2x4(:,:,578))
  call Hloop_Q_A(ntryL,G1H2(105),23,nMB,G2H2(102),n2h2(414))
  call Hloop_ZQ_A(ntryL,G1H4(82),ex1(:),G1H2(204),ngZd,m3h2x2(:,460),heltab2x4(:,:,579))
  call Hloop_Q_A(ntryL,G1H2(204),23,nMB,G2H2(90),n2h2(415))
  call Hloop_ZQ_A(ntryL,G1H4(244),ex1(:),G1H2(197),ngZd,m3h2x2(:,461),heltab2x4(:,:,580))
  call Hloop_Q_A(ntryL,G1H2(197),23,nMB,G2H2(114),n2h2(416))
  call Hloop_WQ_A(ntryL,G1H4(68),ex1(:),G1H2(161),m3h2x2(:,462),heltab2x4(:,:,581))
  call Hloop_Q_A(ntryL,G1H2(161),23,nMT,G2H2(95),n2h2(417))
  call Hloop_WQ_A(ntryL,G1H4(25),ex1(:),G1H2(106),m3h2x2(:,463),heltab2x4(:,:,582))
  call Hloop_Q_A(ntryL,G1H2(106),23,nMT,G2H2(84),n2h2(418))
  call Hotf_4pt_reduction(G2H2(24),RedSet_4(22),mass4set(:,16),  & 
G1H2(111),G1H2(130),G1H2(118),G1H2(112),G1H2(505),G0H2(23),2)
  call HG1shiftOLR(G1H2(130),4,2)
  call Hotf_4pt_reduction(G2H2(18),RedSet_4(22),mass4set(:,17),  & 
G1H2(117),G1H2(509),G1H2(123),G1H2(124),G1H2(129),G0H2(30),2)
  call HG1shiftOLR(G1H2(509),4,2)
  call Hloop_TV_S(ntryL,G1H2(205),19,ex4(:),8,G2H1(100),m3h2x1(:,357),heltab2x2(:,:,472))
  call Hotf_4pt_reduction(G2H2(32),RedSet_4(22),mass4set(:,18),  & 
G1H2(135),G1H2(141),G1H2(455),G1H2(450),G1H2(439),2)
  call HG1shiftOLR(G1H2(141),4,2)
  call Hloop_QV_A(ntryL,G1H2(520),ex4(:),G1H1(104),m3h2x1(:,358),heltab2x2(:,:,473))
  call Hloop_Q_A(ntryL,G1H1(104),27,nMB,G2H1(112),n2h1(228))
  call Hloop_TV_S(ntryL,G1H2(525),19,ex4(:),8,G2H1(106),m3h2x1(:,359),heltab2x2(:,:,474))
  call Hotf_4pt_reduction(G2H2(118),RedSet_4(22),mass4set(:,18),  & 
G1H2(433),G1H2(142),G1H2(147),G1H2(487),G1H2(482),G0H2(29),2)
  call HG1shiftOLR(G1H2(142),4,2)
  call Hloop_UV_W(ntryL,G1H2(127),19,ex4(:),8,G2H1(9),m3h2x1(:,360),heltab2x2(:,:,475))
  call Hotf_4pt_reduction(G2H2(7),RedSet_4(22),mass4set(:,18),  & 
G1H2(467),G1H2(461),G1H2(148),G1H2(153),G1H2(159),G0H2(9),2)
  call HG1shiftOLR(G1H2(461),4,2)
  call Hloop_UV_W(ntryL,G1H2(295),19,ex4(:),8,G2H1(10),m3h2x1(:,361),heltab2x2(:,:,476))
  call Hotf_4pt_reduction(G2H2(46),RedSet_4(22),mass4set(:,18),  & 
G1H2(184),G1H2(166),G1H2(160),G1H2(185),G1H2(165),2)
  call HG1shiftOLR(G1H2(166),4,2)
  call Hloop_AS_Q(ntryL,G1H2(504),ex3(:),G1H2(193),ngH,m3h1x2(:,116),heltab2x2(:,:,477))
  call Hloop_A_Q(ntryL,G1H2(193),23,nMB,G2H2(108),n2h2(419))
  call Hotf_4pt_reduction(G2H2(172),RedSet_4(15),mass4set(:,16),  & 
G1H2(171),G1H2(172),G1H2(177),G1H2(176),G1H2(169),G0H2(7),2)
  call HG1shiftOLR(G1H2(172),8,2)
  call Hloop_AS_Q(ntryL,G1H2(516),ex3(:),G1H2(224),ngH,m3h1x2(:,117),heltab2x2(:,:,478))
  call Hloop_A_Q(ntryL,G1H2(224),23,nMB,G2H2(134),n2h2(420))
  call Hloop_AS_Q(ntryL,G1H2(521),ex3(:),G1H2(178),ngH,m3h1x2(:,118),heltab2x2(:,:,479))
  call Hloop_A_Q(ntryL,G1H2(178),23,nMT,G2H2(234),n2h2(421))
  call Hotf_4pt_reduction(G2H2(169),RedSet_4(15),mass4set(:,17),  & 
G1H2(183),G1H2(189),G1H2(95),G1H2(83),G1H2(227),G0H2(1),2)
  call HG1shiftOLR(G1H2(189),8,2)
  call Hloop_AS_Q(ntryL,G1H2(515),ex3(:),G1H2(535),ngH,m3h1x2(:,119),heltab2x2(:,:,480))
  call Hloop_A_Q(ntryL,G1H2(535),23,nMB,G2H2(3),n2h2(422))
  call Hloop_ST_V(ntryL,G1H2(531),19,ex3(:),4,G2H2(200),m3h1x2(:,120),heltab2x2(:,:,481))
  call Hloop_VT_S(ntryL,G1H2(536),19,ex3(:),4,G2H2(12),m3h1x2(:,121),heltab2x2(:,:,482))
  call Hotf_4pt_reduction(G2H2(113),RedSet_4(15),mass4set(:,18),  & 
G1H2(190),G1H2(195),G1H2(41),G1H2(38),G1H2(247),G0H2(5),2)
  call HG1shiftOLR(G1H2(195),8,2)
  call Hloop_ST_V(ntryL,G1H2(139),19,ex3(:),4,G2H2(218),m3h1x2(:,122),heltab2x2(:,:,483))
  call Hotf_4pt_reduction(G2H2(149),RedSet_4(15),mass4set(:,18),  & 
G1H2(108),G1H2(196),G1H2(201),G1H2(53),G1H2(471),G0H2(17),2)
  call HG1shiftOLR(G1H2(196),8,2)
  call Hloop_VT_S(ntryL,G1H2(149),19,ex3(:),4,G2H2(196),m3h1x2(:,123),heltab2x2(:,:,484))
  call Hloop_AV_Q(ntryL,G1H2(175),ex4(:),G1H1(143),m3h2x1(:,362),heltab2x2(:,:,485))
  call Hloop_A_Q(ntryL,G1H1(143),27,nMB,G2H1(11),n2h1(229))
  call Hotf_4pt_reduction(G2H2(26),RedSet_4(22),mass4set(:,16),  & 
G1H2(373),G1H2(202),G1H2(249),G1H2(265),G1H2(281),G0H2(15),2)
  call HG1shiftOLR(G1H2(202),4,2)
  call Hloop_AV_Q(ntryL,G1H2(24),ex4(:),G1H1(105),m3h2x1(:,363),heltab2x2(:,:,486))
  call Hloop_A_Q(ntryL,G1H1(105),27,nMB,G2H1(12),n2h1(230))
  call Hloop_AV_Q(ntryL,G1H2(252),ex4(:),G1H1(148),m3h2x1(:,364),heltab2x2(:,:,487))
  call Hloop_A_Q(ntryL,G1H1(148),27,nMT,G2H1(13),n2h1(231))
  call Hotf_4pt_reduction(G2H2(22),RedSet_4(22),mass4set(:,17),  & 
G1H2(297),G1H2(368),G1H2(150),G1H2(158),G1H2(151),G0H2(20),2)
  call HG1shiftOLR(G1H2(368),4,2)
  call Hloop_SV_T(ntryL,G1H2(203),19,ex4(:),8,G2H1(15),m3h2x1(:,365),heltab2x2(:,:,488))
  call Hotf_4pt_reduction(G2H2(36),RedSet_4(22),mass4set(:,18),  & 
G1H2(245),G1H2(242),G1H2(236),G1H2(233),G1H2(30),2)
  call HG1shiftOLR(G1H2(242),4,2)
  call Hloop_AV_Q(ntryL,G1H2(211),ex4(:),G1H1(109),m3h2x1(:,366),heltab2x2(:,:,489))
  call Hloop_A_Q(ntryL,G1H1(109),27,nMB,G2H1(16),n2h1(232))
  call Hloop_SV_T(ntryL,G1H2(66),19,ex4(:),8,G2H1(18),m3h2x1(:,367),heltab2x2(:,:,490))
  call Hotf_4pt_reduction(G2H2(126),RedSet_4(22),mass4set(:,18),  & 
G1H2(530),G1H2(466),G1H2(187),G1H2(179),G1H2(194),G0H2(22),2)
  call HG1shiftOLR(G1H2(466),4,2)
  call Hloop_UW_V(ntryL,G1H2(279),19,ex4(:),8,G2H1(19),m3h2x1(:,368),heltab2x2(:,:,491))
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(22),mass4set(:,18),  & 
G1H2(186),G1H2(235),G1H2(280),G1H2(125),G1H2(262),G0H2(10),2)
  call HG1shiftOLR(G1H2(235),4,2)
  call Hloop_UW_V(ntryL,G1H2(294),19,ex4(:),8,G2H1(21),m3h2x1(:,369),heltab2x2(:,:,492))
  call Hotf_4pt_reduction(G2H2(50),RedSet_4(22),mass4set(:,18),  & 
G1H2(259),G1H2(116),G1H2(258),G1H2(352),G1H2(346),2)
  call HG1shiftOLR(G1H2(116),4,2)
  call Hloop_SQ_A(ntryL,G1H4(98),ex1(:),G1H2(324),ngX,m3h2x2(:,464),heltab2x4(:,:,583))
  call Hloop_Q_A(ntryL,G1H2(324),23,nMB,G2H2(34),n2h2(423))
  call Hloop_SQ_A(ntryL,G1H4(142),ex1(:),G1H2(353),ngPtb,m3h2x2(:,465),heltab2x4(:,:,584))
  call Hloop_Q_A(ntryL,G1H2(353),23,nMT,G2H2(130),n2h2(424))
  call Hloop_ZQ_A(ntryL,G1H4(111),ex1(:),G1H2(347),ngZd,m3h2x2(:,466),heltab2x4(:,:,585))
  call Hloop_Q_A(ntryL,G1H2(347),23,nMB,G2H2(6),n2h2(425))
  call Hloop_WQ_A(ntryL,G1H4(94),ex1(:),G1H2(325),m3h2x2(:,467),heltab2x4(:,:,586))
  call Hloop_Q_A(ntryL,G1H2(325),23,nMT,G2H2(49),n2h2(426))
  call Hloop_SQ_A(ntryL,G1H2(207),ex1(:),G1H1(149),ngPtb,m3h2x1(:,370),heltab2x2(:,:,493))
  call Hloop_Q_A(ntryL,G1H1(149),27,nMT,G2H1(22),n2h1(233))
  call Hloop_SQ_A(ntryL,G1H2(208),ex1(:),G1H1(110),ngPtb,m3h2x1(:,371),heltab2x2(:,:,494))
  call Hloop_Q_A(ntryL,G1H1(110),27,nMT,G2H1(24),n2h1(234))
  call Hloop_WQ_A(ntryL,G1H2(213),ex1(:),G1H1(153),m3h2x1(:,372),heltab2x2(:,:,495))
  call Hloop_Q_A(ntryL,G1H1(153),27,nMT,G2H1(25),n2h1(235))
  call Hloop_WQ_A(ntryL,G1H2(214),ex1(:),G1H1(115),m3h2x1(:,373),heltab2x2(:,:,496))
  call Hloop_Q_A(ntryL,G1H1(115),27,nMT,G2H1(27),n2h1(236))
  call Hloop_SA_Q(ntryL,G1H4(92),ex2(:),G1H2(335),ngX,m3h2x2(:,468),heltab2x4(:,:,587))
  call Hloop_A_Q(ntryL,G1H2(335),23,nMB,G2H2(175),n2h2(427))
  call Hloop_SA_Q(ntryL,G1H4(151),ex2(:),G1H2(330),ngPbt,m3h2x2(:,469),heltab2x4(:,:,588))
  call Hloop_A_Q(ntryL,G1H2(330),23,nMT,G2H2(209),n2h2(428))
  call Hloop_ZA_Q(ntryL,G1H4(157),ex2(:),G1H2(336),ngZd,m3h2x2(:,470),heltab2x4(:,:,589))
  call Hloop_A_Q(ntryL,G1H2(336),23,nMB,G2H2(145),n2h2(429))
  call Hloop_WA_Q(ntryL,G1H4(198),ex2(:),G1H2(331),m3h2x2(:,471),heltab2x4(:,:,590))
  call Hloop_A_Q(ntryL,G1H2(331),23,nMT,G2H2(181),n2h2(430))
  call Hloop_TV_S(ntryL,G1H4(177),21,ex4(:),8,G2H2(214),m3h2x2(:,472),heltab2x4(:,:,591))
  call Hloop_TV_S(ntryL,G1H4(178),21,ex4(:),8,G2H2(109),m3h2x2(:,473),heltab2x4(:,:,592))
  call Hloop_QV_A(ntryL,G1H4(184),ex4(:),G1H2(384),m3h2x2(:,474),heltab2x4(:,:,593))
  call Hloop_Q_A(ntryL,G1H2(384),29,nMB,G2H2(37),n2h2(431))
  call Hloop_QV_A(ntryL,G1H4(185),ex4(:),G1H2(378),m3h2x2(:,475),heltab2x4(:,:,594))
  call Hloop_Q_A(ntryL,G1H2(378),29,nMB,G2H2(39),n2h2(432))
  call Hloop_UV_W(ntryL,G1H4(191),21,ex4(:),8,G2H2(16),m3h2x2(:,476),heltab2x4(:,:,595))
  call Hloop_UV_W(ntryL,G1H4(192),21,ex4(:),8,G2H2(54),m3h2x2(:,477),heltab2x4(:,:,596))
  call Hloop_SA_Q(ntryL,G1H2(219),ex2(:),G1H1(154),ngPbt,m3h2x1(:,374),heltab2x2(:,:,497))
  call Hloop_A_Q(ntryL,G1H1(154),27,nMT,G2H1(28),n2h1(237))
  call Hloop_SA_Q(ntryL,G1H2(220),ex2(:),G1H1(116),ngPbt,m3h2x1(:,375),heltab2x2(:,:,498))
  call Hloop_A_Q(ntryL,G1H1(116),27,nMT,G2H1(30),n2h1(238))
  call Hloop_WA_Q(ntryL,G1H2(225),ex2(:),G1H1(159),m3h2x1(:,376),heltab2x2(:,:,499))
  call Hloop_A_Q(ntryL,G1H1(159),27,nMT,G2H1(31),n2h1(239))
  call Hloop_WA_Q(ntryL,G1H2(226),ex2(:),G1H1(233),m3h2x1(:,377),heltab2x2(:,:,500))
  call Hloop_A_Q(ntryL,G1H1(233),27,nMT,G2H1(33),n2h1(240))
  call Hloop_QS_A(ntryL,G1H2(231),ex3(:),G1H2(341),ngH,m3h1x2(:,124),heltab2x2(:,:,501))
  call Hloop_Q_A(ntryL,G1H2(341),29,nMB,G2H2(53),n2h2(433))
  call Hloop_QS_A(ntryL,G1H2(232),ex3(:),G1H2(385),ngH,m3h1x2(:,125),heltab2x2(:,:,502))
  call Hloop_Q_A(ntryL,G1H2(385),29,nMB,G2H2(51),n2h2(434))
  call Hloop_VT_S(ntryL,G1H2(237),25,ex3(:),4,G2H2(60),m3h1x2(:,126),heltab2x2(:,:,503))
  call Hloop_VT_S(ntryL,G1H2(238),25,ex3(:),4,G2H2(58),m3h1x2(:,127),heltab2x2(:,:,504))
  call Hloop_ST_V(ntryL,G1H2(243),25,ex3(:),4,G2H2(57),m3h1x2(:,128),heltab2x2(:,:,505))
  call Hloop_ST_V(ntryL,G1H2(244),25,ex3(:),4,G2H2(178),m3h1x2(:,129),heltab2x2(:,:,506))
  call Hotf_4pt_reduction(G2H4(21),RedSet_4(41),mass4set(:,19),  & 
G1H4(164),G1H4(171),G1H4(117),G1H4(101),G1H4(215),4)
  call HG1shiftOLR(G1H4(171),2,4)
  call Hloop_QV_A(ntryL,G1H4(24),ex4(:),G1H2(379),m3h2x2(:,478),heltab2x4(:,:,597))
  call Hloop_Q_A(ntryL,G1H2(379),29,nMB,G2H2(153),n2h2(435))
  call Hloop_QV_A(ntryL,G1H4(52),ex4(:),G1H2(342),m3h2x2(:,479),heltab2x4(:,:,598))
  call Hloop_Q_A(ntryL,G1H2(342),29,nMB,G2H2(79),n2h2(436))
  call Hloop_QV_A(ntryL,G1H4(73),ex4(:),G1H2(445),m3h2x2(:,480),heltab2x4(:,:,599))
  call Hloop_Q_A(ntryL,G1H2(445),29,nMB,G2H2(62),n2h2(437))
  call Hloop_QV_A(ntryL,G1H4(77),ex4(:),G1H2(444),m3h2x2(:,481),heltab2x4(:,:,600))
  call Hloop_Q_A(ntryL,G1H2(444),29,nMB,G2H2(156),n2h2(438))
  call Hotf_4pt_reduction(G2H4(22),RedSet_4(41),mass4set(:,20),  & 
G1H4(231),G1H4(145),G1H4(115),G1H4(102),G1H4(149),4)
  call HG1shiftOLR(G1H4(145),2,4)
  call Hloop_QV_A(ntryL,G1H4(205),ex4(:),G1H2(429),m3h2x2(:,482),heltab2x4(:,:,601))
  call Hloop_Q_A(ntryL,G1H2(429),29,nMB,G2H2(83),n2h2(439))
  call Hloop_QV_A(ntryL,G1H4(206),ex4(:),G1H2(428),m3h2x2(:,483),heltab2x4(:,:,602))
  call Hloop_Q_A(ntryL,G1H2(428),29,nMB,G2H2(66),n2h2(440))
  call Hloop_QV_A(ntryL,G1H4(210),ex4(:),G1H2(423),m3h2x2(:,484),heltab2x4(:,:,603))
  call Hloop_Q_A(ntryL,G1H2(423),29,nMB,G2H2(177),n2h2(441))
  call Hloop_QV_A(ntryL,G1H4(211),ex4(:),G1H2(422),m3h2x2(:,485),heltab2x4(:,:,604))
  call Hloop_Q_A(ntryL,G1H2(422),29,nMB,G2H2(180),n2h2(442))
  call Hotf_4pt_reduction(G2H4(19),RedSet_4(41),mass4set(:,21),  & 
G1H4(162),G1H4(163),G1H4(161),G1H4(99),G1H4(208),4)
  call HG1shiftOLR(G1H4(163),2,4)
  call Hloop_QV_A(ntryL,G1H4(221),ex4(:),G1H2(499),m3h2x2(:,486),heltab2x4(:,:,605))
  call Hloop_Q_A(ntryL,G1H2(499),29,nMT,G2H2(201),n2h2(443))
  call Hloop_QV_A(ntryL,G1H4(222),ex4(:),G1H2(498),m3h2x2(:,487),heltab2x4(:,:,606))
  call Hloop_Q_A(ntryL,G1H2(498),29,nMT,G2H2(204),n2h2(444))
  call Hloop_QV_A(ntryL,G1H4(226),ex4(:),G1H2(494),m3h2x2(:,488),heltab2x4(:,:,607))
  call Hloop_Q_A(ntryL,G1H2(494),29,nMT,G2H2(219),n2h2(445))
  call Hloop_QV_A(ntryL,G1H4(227),ex4(:),G1H2(493),m3h2x2(:,489),heltab2x4(:,:,608))
  call Hloop_Q_A(ntryL,G1H2(493),29,nMT,G2H2(222),n2h2(446))
  call Hotf_4pt_reduction(G2H4(24),RedSet_4(41),mass4set(:,21),  & 
G1H4(100),G1H4(203),G1H4(220),G1H4(223),G1H4(224),4)
  call HG1shiftOLR(G1H4(203),2,4)
  call Hloop_QV_A(ntryL,G1H4(237),ex4(:),G1H2(477),m3h2x2(:,490),heltab2x4(:,:,609))
  call Hloop_Q_A(ntryL,G1H2(477),29,nMT,G2H2(121),n2h2(447))
  call Hloop_QV_A(ntryL,G1H4(238),ex4(:),G1H2(476),m3h2x2(:,491),heltab2x4(:,:,610))
  call Hloop_Q_A(ntryL,G1H2(476),29,nMT,G2H2(129),n2h2(448))
  call Hloop_QV_A(ntryL,G1H4(242),ex4(:),G1H2(128),m3h2x2(:,492),heltab2x4(:,:,611))
  call Hloop_Q_A(ntryL,G1H2(128),29,nMT,G2H2(70),n2h2(449))
  call Hloop_QV_A(ntryL,G1H4(243),ex4(:),G1H2(306),m3h2x2(:,493),heltab2x4(:,:,612))
  call Hloop_Q_A(ntryL,G1H2(306),29,nMT,G2H2(71),n2h2(450))
  call Hotf_4pt_reduction(G2H2(74),RedSet_4(44),mass4set(:,19),  & 
G1H2(307),G1H2(310),G1H2(406),G1H2(407),G1H2(13),2)
  call HG1shiftOLR(G1H2(310),2,2)
  call Hloop_QS_A(ntryL,G1H2(255),ex3(:),G1H2(2),ngH,m3h1x2(:,130),heltab2x2(:,:,507))
  call Hloop_Q_A(ntryL,G1H2(2),29,nMB,G2H2(73),n2h2(451))
  call Hloop_QS_A(ntryL,G1H2(256),ex3(:),G1H2(14),ngH,m3h1x2(:,131),heltab2x2(:,:,508))
  call Hloop_Q_A(ntryL,G1H2(14),29,nMB,G2H2(77),n2h2(452))
  call Hloop_QS_A(ntryL,G1H2(260),ex3(:),G1H2(427),ngH,m3h1x2(:,132),heltab2x2(:,:,509))
  call Hloop_Q_A(ntryL,G1H2(427),29,nMB,G2H2(81),n2h2(453))
  call Hloop_QS_A(ntryL,G1H2(261),ex3(:),G1H2(16),ngH,m3h1x2(:,133),heltab2x2(:,:,510))
  call Hloop_Q_A(ntryL,G1H2(16),29,nMB,G2H2(85),n2h2(454))
  call Hotf_4pt_reduction(G2H2(78),RedSet_4(44),mass4set(:,20),  & 
G1H2(438),G1H2(17),G1H2(18),G1H2(20),G1H2(22),2)
  call HG1shiftOLR(G1H2(17),2,2)
  call Hloop_QS_A(ntryL,G1H2(271),ex3(:),G1H2(4),ngH,m3h1x2(:,134),heltab2x2(:,:,511))
  call Hloop_Q_A(ntryL,G1H2(4),29,nMB,G2H2(89),n2h2(455))
  call Hloop_QS_A(ntryL,G1H2(272),ex3(:),G1H2(28),ngH,m3h1x2(:,135),heltab2x2(:,:,512))
  call Hloop_Q_A(ntryL,G1H2(28),29,nMB,G2H2(93),n2h2(456))
  call Hloop_QS_A(ntryL,G1H2(276),ex3(:),G1H2(33),ngH,m3h1x2(:,136),heltab2x2(:,:,513))
  call Hloop_Q_A(ntryL,G1H2(33),29,nMB,G2H2(97),n2h2(457))
  call Hloop_QS_A(ntryL,G1H2(277),ex3(:),G1H2(39),ngH,m3h1x2(:,137),heltab2x2(:,:,514))
  call Hloop_Q_A(ntryL,G1H2(39),29,nMB,G2H2(100),n2h2(458))
  call Hotf_4pt_reduction(G2H2(140),RedSet_4(44),mass4set(:,21),  & 
G1H2(369),G1H2(364),G1H2(357),G1H2(136),G1H2(40),2)
  call HG1shiftOLR(G1H2(364),2,2)
  call Hloop_QS_A(ntryL,G1H2(287),ex3(:),G1H2(45),ngH,m3h1x2(:,138),heltab2x2(:,:,515))
  call Hloop_Q_A(ntryL,G1H2(45),29,nMT,G2H2(101),n2h2(459))
  call Hloop_QS_A(ntryL,G1H2(288),ex3(:),G1H2(456),ngH,m3h1x2(:,139),heltab2x2(:,:,516))
  call Hloop_Q_A(ntryL,G1H2(456),29,nMT,G2H2(103),n2h2(460))
  call Hloop_QS_A(ntryL,G1H2(292),ex3(:),G1H2(481),ngH,m3h1x2(:,140),heltab2x2(:,:,517))
  call Hloop_Q_A(ntryL,G1H2(481),29,nMT,G2H2(107),n2h2(461))
  call Hloop_QS_A(ntryL,G1H2(293),ex3(:),G1H2(57),ngH,m3h1x2(:,141),heltab2x2(:,:,518))
  call Hloop_Q_A(ntryL,G1H2(57),29,nMT,G2H2(111),n2h2(462))
  call Hotf_4pt_reduction(G2H2(144),RedSet_4(44),mass4set(:,21),  & 
G1H2(48),G1H2(133),G1H2(217),G1H2(140),G1H2(94),2)
  call HG1shiftOLR(G1H2(133),2,2)
  call Hloop_QS_A(ntryL,G1H2(303),ex3(:),G1H2(99),ngH,m3h1x2(:,142),heltab2x2(:,:,519))
  call Hloop_Q_A(ntryL,G1H2(99),29,nMT,G2H2(115),n2h2(463))
  call Hloop_QS_A(ntryL,G1H2(304),ex3(:),G1H2(273),ngH,m3h1x2(:,143),heltab2x2(:,:,520))
  call Hloop_Q_A(ntryL,G1H2(273),29,nMT,G2H2(119),n2h2(464))
  call Hloop_QS_A(ntryL,G1H2(308),ex3(:),G1H2(269),ngH,m3h1x2(:,144),heltab2x2(:,:,521))
  call Hloop_Q_A(ntryL,G1H2(269),29,nMT,G2H2(123),n2h2(465))
  call Hloop_QS_A(ntryL,G1H2(309),ex3(:),G1H2(36),ngH,m3h1x2(:,145),heltab2x2(:,:,522))
  call Hloop_Q_A(ntryL,G1H2(36),29,nMT,G2H2(127),n2h2(466))
  call Hloop_QA_S(ntryL,G2H4(64),ex2(:),G2H2(131),ngPbt,m3h2x2(:,494),heltab2x4(:,:,613))
  call Hloop_QA_S(ntryL,G2H4(74),ex2(:),G2H2(135),ngPbt,m3h2x2(:,495),heltab2x4(:,:,614))
  call Hloop_QA_W(ntryL,G2H4(65),ex2(:),G2H2(139),m3h2x2(:,496),heltab2x4(:,:,615))
  call Hloop_QA_W(ntryL,G2H4(63),ex2(:),G2H2(143),m3h2x2(:,497),heltab2x4(:,:,616))
  call Hloop_AQ_S(ntryL,G2H4(8),ex1(:),G2H2(174),ngPtb,m3h2x2(:,498),heltab2x4(:,:,617))
  call Hloop_AQ_S(ntryL,G2H4(72),ex1(:),G2H2(171),ngPtb,m3h2x2(:,499),heltab2x4(:,:,618))
  call Hloop_AQ_W(ntryL,G2H4(73),ex1(:),G2H2(237),m3h2x2(:,500),heltab2x4(:,:,619))
  call Hloop_AQ_W(ntryL,G2H4(3),ex1(:),G2H2(117),m3h2x2(:,501),heltab2x4(:,:,620))
  call Hloop_AQ_S(ntryL,G2H4(10),ex1(:),G2H2(152),ngPtb,m3h2x2(:,502),heltab2x4(:,:,621))
  call Hloop_AQ_S(ntryL,G2H4(11),ex1(:),G2H2(248),ngPtb,m3h2x2(:,503),heltab2x4(:,:,622))
  call Hloop_AQ_W(ntryL,G2H4(13),ex1(:),G2H2(24),m3h2x2(:,504),heltab2x4(:,:,623))
  call Hloop_AQ_W(ntryL,G2H4(16),ex1(:),G2H2(18),m3h2x2(:,505),heltab2x4(:,:,624))
  call Hloop_AQ_S(ntryL,G2H2(30),ex1(:),G2H1(34),ngH,m3h2x1(:,378),heltab2x2(:,:,523))
  call Hloop_AQ_S(ntryL,G2H2(31),ex1(:),G2H1(36),ngX,m3h2x1(:,379),heltab2x2(:,:,524))
  call Hloop_AQ_S(ntryL,G2H2(44),ex1(:),G2H1(37),ngPtb,m3h2x1(:,380),heltab2x2(:,:,525))
  call Hloop_AQ_S(ntryL,G2H2(45),ex1(:),G2H1(39),ngPtb,m3h2x1(:,381),heltab2x2(:,:,526))
  call Hloop_AQ_Z(ntryL,G2H2(5),ex1(:),G2H1(40),ngZd,m3h2x1(:,382),heltab2x2(:,:,527))
  call Hloop_AQ_W(ntryL,G2H2(8),ex1(:),G2H1(42),m3h2x1(:,383),heltab2x2(:,:,528))
  call Hloop_AQ_W(ntryL,G2H2(9),ex1(:),G2H1(43),m3h2x1(:,384),heltab2x2(:,:,529))
  call Hloop_QA_S(ntryL,G2H4(14),ex2(:),G2H2(32),ngPbt,m3h2x2(:,506),heltab2x4(:,:,625))
  call Hloop_QA_S(ntryL,G2H4(15),ex2(:),G2H2(118),ngPbt,m3h2x2(:,507),heltab2x4(:,:,626))
  call Hloop_QA_W(ntryL,G2H4(18),ex2(:),G2H2(7),m3h2x2(:,508),heltab2x4(:,:,627))
  call Hloop_QA_W(ntryL,G2H4(17),ex2(:),G2H2(46),m3h2x2(:,509),heltab2x4(:,:,628))
  call Hloop_QA_S(ntryL,G2H2(10),ex2(:),G2H1(45),ngH,m3h2x1(:,385),heltab2x2(:,:,530))
  call Hloop_QA_S(ntryL,G2H2(13),ex2(:),G2H1(46),ngX,m3h2x1(:,386),heltab2x2(:,:,531))
  call Hloop_QA_S(ntryL,G2H2(14),ex2(:),G2H1(48),ngPbt,m3h2x1(:,387),heltab2x2(:,:,532))
  call Hloop_QA_S(ntryL,G2H2(15),ex2(:),G2H1(49),ngPbt,m3h2x1(:,388),heltab2x2(:,:,533))
  call Hloop_QA_Z(ntryL,G2H2(20),ex2(:),G2H1(51),ngZd,m3h2x1(:,389),heltab2x2(:,:,534))
  call Hloop_QA_W(ntryL,G2H2(68),ex2(:),G2H1(52),m3h2x1(:,390),heltab2x2(:,:,535))
  call Hloop_QA_W(ntryL,G2H2(72),ex2(:),G2H1(54),m3h2x1(:,391),heltab2x2(:,:,536))
  call Hloop_AQ_S(ntryL,G1H2(47),ex1(:),G1H1(160),ngPtb,m3h2x1(:,392),heltab2x2(:,:,537))
  call Hloop_AQ_W(ntryL,G1H2(318),ex1(:),G1H1(244),m3h2x1(:,393),heltab2x2(:,:,538))
  call Hloop_AQ_S(ntryL,G1H2(329),ex1(:),G1H1(165),ngPtb,m3h2x1(:,394),heltab2x2(:,:,539))
  call Hloop_AQ_W(ntryL,G1H2(340),ex1(:),G1H1(170),m3h2x1(:,395),heltab2x2(:,:,540))
  call Hloop_QA_S(ntryL,G1H2(351),ex2(:),G1H1(18),ngPbt,m3h2x1(:,396),heltab2x2(:,:,541))
  call Hloop_QA_W(ntryL,G1H2(362),ex2(:),G1H1(19),m3h2x1(:,397),heltab2x2(:,:,542))
  call Hloop_QA_S(ntryL,G1H2(383),ex2(:),G1H1(169),ngPbt,m3h2x1(:,398),heltab2x2(:,:,543))
  call Hloop_QA_W(ntryL,G1H2(394),ex2(:),G1H1(24),m3h2x1(:,399),heltab2x2(:,:,544))
  call Hloop_QA_S(ntryL,G2H4(38),ex2(:),G2H2(172),ngPbt,m3h2x2(:,510),heltab2x4(:,:,629))
  call Hloop_QA_W(ntryL,G2H4(34),ex2(:),G2H2(169),m3h2x2(:,511),heltab2x4(:,:,630))
  call Hloop_AQ_S(ntryL,G2H4(41),ex1(:),G2H2(113),ngPtb,m3h2x2(:,512),heltab2x4(:,:,631))
  call Hloop_AQ_W(ntryL,G2H4(39),ex1(:),G2H2(149),m3h2x2(:,513),heltab2x4(:,:,632))
  call Hloop_SSV_V(ntryL,G1H4(150),ex3(:),ex4(:),G1H2(107),m4h1x2x2(:,1),heltab3x4(:,:,1))
  call Hloop_VVS_S(ntryL,G1H4(152),ex4(:),ex3(:),G1H2(100),m4h2x1x2(:,1),heltab3x4(:,:,2))
  call Hotf_4pt_reduction(G2H2(243),RedSet_4(22),mass4set(:,22),  & 
G1H2(105),G1H2(204),G1H2(197),G1H2(161),G1H2(106),G0H2(8),2)
  call HG1shiftOLR(G1H2(204),4,2)
  call Hotf_4pt_reduction(G2H2(246),RedSet_4(22),mass4set(:,22),  & 
G1H2(205),G1H2(520),G1H2(525),G1H2(127),G1H2(295),G0H2(2),2)
  call HG1shiftOLR(G1H2(520),4,2)
  call Hotf_4pt_reduction(G2H2(40),RedSet_4(22),mass4set(:,18),  & 
G1H2(504),G1H2(193),G1H2(516),G1H2(224),G1H2(521),2)
  call HG1shiftOLR(G1H2(193),4,2)
  call Hotf_4pt_reduction(G2H2(42),RedSet_4(22),mass4set(:,18),  & 
G1H2(178),G1H2(515),G1H2(535),G1H2(531),G1H2(536),2)
  call HG1shiftOLR(G1H2(515),4,2)
  call Hloop_VV_S(ntryL,G2H2(17),ex4(:),G2H1(61),m3h2x1(:,400),heltab2x2(:,:,545))
  call Hloop_SV_V(ntryL,G2H2(56),ex4(:),G2H1(63),m3h2x1(:,401),heltab2x2(:,:,546))
  call Hloop_VV_S(ntryL,G2H2(63),ex4(:),G2H1(64),m3h2x1(:,402),heltab2x2(:,:,547))
  call Hloop_SV_V(ntryL,G2H2(184),ex4(:),G2H1(66),m3h2x1(:,403),heltab2x2(:,:,548))
  call Hotf_4pt_reduction(G2H2(166),RedSet_4(15),mass4set(:,22),  & 
G1H2(139),G1H2(149),G1H2(175),G1H2(24),G1H2(252),G0H2(6),2)
  call HG1shiftOLR(G1H2(149),8,2)
  call Hotf_4pt_reduction(G2H2(168),RedSet_4(15),mass4set(:,22),  & 
G1H2(203),G1H2(211),G1H2(66),G1H2(279),G1H2(294),G0H2(18),2)
  call HG1shiftOLR(G1H2(211),8,2)
  call Hloop_SS_S(ntryL,G2H2(183),ex3(:),G2H2(26),m3h1x2(:,146),heltab2x2(:,:,549))
  call Hloop_SS_S(ntryL,G2H2(186),ex3(:),G2H2(22),m3h1x2(:,147),heltab2x2(:,:,550))
  call Hloop_SS_S(ntryL,G2H2(205),ex3(:),G2H2(36),m3h1x2(:,148),heltab2x2(:,:,551))
  call Hloop_SS_S(ntryL,G2H2(208),ex3(:),G2H2(126),m3h1x2(:,149),heltab2x2(:,:,552))
  call Hloop_VS_V(ntryL,G2H2(223),ex3(:),G2H2(4),m3h1x2(:,150),heltab2x2(:,:,553))
  call Hloop_VS_V(ntryL,G2H2(226),ex3(:),G2H2(50),m3h1x2(:,151),heltab2x2(:,:,554))
  call Hloop_SS_S(ntryL,G2H2(125),ex3(:),G2H2(74),m3h1x2(:,152),heltab2x2(:,:,555))
  call Hloop_VS_V(ntryL,G2H2(133),ex3(:),G2H2(78),m3h1x2(:,153),heltab2x2(:,:,556))
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(12),mass4set(:,22),  & 
G1H8(490),G1H8(491),G1H8(492),G1H8(493),G1H8(63),G0H8(29),8)
  call HG1shiftOLR(G1H8(491),8,8)
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(12),mass4set(:,22),  & 
G1H8(64),G1H8(68),G1H8(66),G1H8(67),G1H8(69),G0H8(69),8)
  call HG1shiftOLR(G1H8(68),8,8)
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(12),mass4set(:,17),  & 
G1H8(70),G1H8(71),G1H8(72),G1H8(73),G1H8(74),G0H8(81),8)
  call HG1shiftOLR(G1H8(71),8,8)
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(12),mass4set(:,17),  & 
G1H8(75),G1H8(76),G1H8(77),G1H8(78),G1H8(79),G0H8(83),8)
  call HG1shiftOLR(G1H8(76),8,8)
  call Hotf_4pt_reduction(G2H8(5),RedSet_4(12),mass4set(:,16),  & 
G1H8(83),G1H8(81),G1H8(82),G1H8(84),G1H8(87),G0H8(85),8)
  call HG1shiftOLR(G1H8(81),8,8)
  call Hotf_4pt_reduction(G2H8(6),RedSet_4(12),mass4set(:,16),  & 
G1H8(88),G1H8(91),G1H8(92),G1H8(93),G1H8(94),G0H8(87),8)
  call HG1shiftOLR(G1H8(91),8,8)
  call Hotf_4pt_reduction(G2H8(8),RedSet_4(12),mass4set(:,22),  & 
G1H8(96),G1H8(98),G1H8(100),G1H8(101),G1H8(102),G0H8(91),8)
  call HG1shiftOLR(G1H8(98),8,8)
  call Hotf_4pt_reduction(G2H8(7),RedSet_4(12),mass4set(:,22),  & 
G1H8(103),G1H8(104),G1H8(105),G1H8(106),G1H8(107),G0H8(109),8)
  call HG1shiftOLR(G1H8(104),8,8)
  call Hotf_4pt_reduction(G2H8(10),RedSet_4(12),mass4set(:,17),  & 
G1H8(108),G1H8(110),G1H8(112),G1H8(114),G1H8(115),G0H8(111),8)
  call HG1shiftOLR(G1H8(110),8,8)
  call Hotf_4pt_reduction(G2H8(9),RedSet_4(12),mass4set(:,17),  & 
G1H8(116),G1H8(117),G1H8(118),G1H8(119),G1H8(120),G0H8(113),8)
  call HG1shiftOLR(G1H8(117),8,8)
  call Hotf_4pt_reduction(G2H8(11),RedSet_4(12),mass4set(:,16),  & 
G1H8(121),G1H8(122),G1H8(123),G1H8(124),G1H8(125),G0H8(115),8)
  call HG1shiftOLR(G1H8(122),8,8)
  call Hotf_4pt_reduction(G2H8(12),RedSet_4(12),mass4set(:,16),  & 
G1H8(126),G1H8(127),G1H8(128),G1H8(129),G1H8(130),G0H8(129),8)
  call HG1shiftOLR(G1H8(127),8,8)
  call Hloop_SS_S(ntryL,G1H8(143),wf4(:,7),G1H2(324),m3h4x2(:,249),heltab2x8(:,:,911))
  call Hloop_SS_S(ntryL,G1H8(145),wf4(:,7),G1H2(353),m3h4x2(:,250),heltab2x8(:,:,912))
  call Hloop_SS_S(ntryL,G1H8(99),wf4(:,7),G1H2(347),m3h4x2(:,251),heltab2x8(:,:,913))
  call Hloop_SS_S(ntryL,G1H8(109),wf4(:,7),G1H2(325),m3h4x2(:,252),heltab2x8(:,:,914))
  call Hloop_SS_S(ntryL,G1H8(111),wf4(:,37),G1H2(207),m3h4x2(:,253),heltab2x8(:,:,915))
  call Hloop_SS_S(ntryL,G1H8(113),wf4(:,37),G1H2(208),m3h4x2(:,254),heltab2x8(:,:,916))
  call Hloop_VS_V(ntryL,G1H8(26),wf4(:,7),G1H2(213),m3h4x2(:,255),heltab2x8(:,:,917))
  call Hloop_VS_V(ntryL,G1H8(28),wf4(:,7),G1H2(214),m3h4x2(:,256),heltab2x8(:,:,918))
  call Hloop_ST_V(ntryL,G1H8(21),20,wf4(:,7),3,G2H2(140),m3h4x2(:,257),heltab2x8(:,:,919))
  call Hloop_ST_V(ntryL,G1H8(22),20,wf4(:,37),3,G2H2(144),m3h4x2(:,258),heltab2x8(:,:,920))
  call Hloop_SS_S(ntryL,G2H8(17),wf4(:,7),G2H2(30),m3h4x2(:,259),heltab2x8(:,:,921))
  call Hotf_4pt_reduction(G2H8(13),RedSet_4(12),mass4set(:,18),  & 
G1H8(133),G1H8(134),G1H8(137),G1H8(138),G1H8(139),G0H8(137),8)
  call HG1shiftOLR(G1H8(134),8,8)
  call Hotf_4pt_reduction(G2H8(14),RedSet_4(12),mass4set(:,18),  & 
G1H8(140),G1H8(141),G1H8(142),G1H8(144),G1H8(146),G0H8(139),8)
  call HG1shiftOLR(G1H8(141),8,8)
  call Hotf_4pt_reduction(G2H8(15),RedSet_4(12),mass4set(:,18),  & 
G1H8(147),G1H8(148),G1H8(149),G1H8(150),G1H8(151),G0H8(141),8)
  call HG1shiftOLR(G1H8(148),8,8)
  call Hotf_4pt_reduction(G2H8(16),RedSet_4(12),mass4set(:,18),  & 
G1H8(152),G1H8(153),G1H8(154),G1H8(155),G1H8(156),G0H8(143),8)
  call HG1shiftOLR(G1H8(153),8,8)
  call Hotf_4pt_reduction(G2H8(20),RedSet_4(12),mass4set(:,18),  & 
G1H8(157),G1H8(158),G1H8(159),G1H8(160),G1H8(161),G0H8(151),8)
  call HG1shiftOLR(G1H8(158),8,8)
  call Hotf_4pt_reduction(G2H8(19),RedSet_4(12),mass4set(:,18),  & 
G1H8(162),G1H8(2),G1H8(4),G1H8(7),G1H8(12),G0H8(165),8)
  call HG1shiftOLR(G1H8(2),8,8)
  call Hotf_4pt_reduction(G2H8(21),RedSet_4(12),mass4set(:,18),  & 
G1H8(13),G1H8(16),G1H8(5),G1H8(20),G1H8(35),G0H8(167),8)
  call HG1shiftOLR(G1H8(16),8,8)
  call Hotf_4pt_reduction(G2H8(22),RedSet_4(12),mass4set(:,18),  & 
G1H8(8),G1H8(11),G1H8(14),G1H8(15),G1H8(17),G0H8(169),8)
  call HG1shiftOLR(G1H8(11),8,8)
  call Hloop_VS_V(ntryL,G2H8(18),wf4(:,7),G2H2(31),m3h4x2(:,260),heltab2x8(:,:,922))
  call Hloop_VT_S(ntryL,G1H8(38),20,wf4(:,7),3,G2H2(44),m3h4x2(:,261),heltab2x8(:,:,923))
  call Hloop_VT_S(ntryL,G1H8(9),20,wf4(:,37),3,G2H2(45),m3h4x2(:,262),heltab2x8(:,:,924))
  call Hotf_4pt_reduction(G2H8(23),RedSet_4(12),mass4set(:,22),  & 
G1H8(18),G1H8(19),G1H8(24),G1H8(25),G1H8(29),G0H8(171),8)
  call HG1shiftOLR(G1H8(19),8,8)
  call Hotf_4pt_reduction(G2H8(24),RedSet_4(12),mass4set(:,22),  & 
G1H8(30),G1H8(31),G1H8(65),G1H8(6),G1H8(33),G0H8(253),8)
  call HG1shiftOLR(G1H8(31),8,8)
  call Hotf_4pt_reduction(G2H8(25),RedSet_4(12),mass4set(:,17),  & 
G1H8(80),G1H8(34),G1H8(36),G1H8(37),G1H8(39),G0H8(254),8)
  call HG1shiftOLR(G1H8(34),8,8)
  call Hotf_4pt_reduction(G2H8(26),RedSet_4(12),mass4set(:,17),  & 
G1H8(42),G1H8(44),G1H8(47),G1H8(48),G1H8(49),G0H8(20),8)
  call HG1shiftOLR(G1H8(44),8,8)
  call Hotf_4pt_reduction(G2H8(27),RedSet_4(12),mass4set(:,16),  & 
G1H8(53),G1H8(51),G1H8(54),G1H8(55),G1H8(56),G0H8(21),8)
  call HG1shiftOLR(G1H8(51),8,8)
  call Hotf_4pt_reduction(G2H8(28),RedSet_4(12),mass4set(:,16),  & 
G1H8(57),G1H8(58),G1H8(60),G1H8(61),G1H8(62),G0H8(22),8)
  call HG1shiftOLR(G1H8(58),8,8)
  call Hotf_4pt_reduction(G2H8(29),RedSet_4(12),mass4set(:,22),  & 
G1H8(163),G1H8(164),G1H8(165),G1H8(166),G1H8(167),G0H8(23),8)
  call HG1shiftOLR(G1H8(164),8,8)
  call Hotf_4pt_reduction(G2H8(30),RedSet_4(12),mass4set(:,22),  & 
G1H8(168),G1H8(169),G1H8(170),G1H8(173),G1H8(174),G0H8(38),8)
  call HG1shiftOLR(G1H8(169),8,8)
  call Hotf_4pt_reduction(G2H8(31),RedSet_4(12),mass4set(:,17),  & 
G1H8(177),G1H8(178),G1H8(179),G1H8(180),G1H8(181),G0H8(39),8)
  call HG1shiftOLR(G1H8(178),8,8)
  call Hotf_4pt_reduction(G2H8(32),RedSet_4(12),mass4set(:,17),  & 
G1H8(182),G1H8(183),G1H8(184),G1H8(185),G1H8(186),G0H8(40),8)
  call HG1shiftOLR(G1H8(183),8,8)
  call Hotf_4pt_reduction(G2H8(33),RedSet_4(12),mass4set(:,16),  & 
G1H8(187),G1H8(188),G1H8(189),G1H8(190),G1H8(192),G0H8(41),8)
  call HG1shiftOLR(G1H8(188),8,8)
  call Hotf_4pt_reduction(G2H8(34),RedSet_4(12),mass4set(:,16),  & 
G1H8(194),G1H8(196),G1H8(198),G1H8(199),G1H8(200),G0H8(42),8)
  call HG1shiftOLR(G1H8(196),8,8)
  call Hloop_TV_S(ntryL,G1H8(279),20,wf4(:,38),3,G2H2(5),m3h4x2(:,263),heltab2x8(:,:,925))
  call Hloop_SV_T(ntryL,G1H8(281),20,wf4(:,38),3,G2H2(8),m3h4x2(:,264),heltab2x8(:,:,926))
  call Hloop_TV_S(ntryL,G1H8(299),20,wf4(:,39),3,G2H2(9),m3h4x2(:,265),heltab2x8(:,:,927))
  call Hloop_SV_T(ntryL,G1H8(301),20,wf4(:,39),3,G2H2(10),m3h4x2(:,266),heltab2x8(:,:,928))
  call Hloop_CV_D(ntryL,G1H8(231),20,wf4(:,38),3,G2H2(13),m3h4x2(:,267),heltab2x8(:,:,929))
  call Hloop_DV_C(ntryL,G1H8(233),20,wf4(:,38),G2H2(14),m3h4x2(:,268),heltab2x8(:,:,930))
  call Hloop_CV_D(ntryL,G1H8(239),20,wf4(:,39),3,G2H2(15),m3h4x2(:,269),heltab2x8(:,:,931))
  call Hloop_DV_C(ntryL,G1H8(241),20,wf4(:,39),G2H2(20),m3h4x2(:,270),heltab2x8(:,:,932))
  call Hloop_UV_W(ntryL,G1H8(382),20,wf4(:,38),3,G2H2(68),m3h4x2(:,271),heltab2x8(:,:,933))
  call Hloop_UW_V(ntryL,G1H8(396),20,wf4(:,38),3,G2H2(72),m3h4x2(:,272),heltab2x8(:,:,934))
  call Hloop_UV_W(ntryL,G1H8(423),20,wf4(:,39),3,G2H2(243),m3h4x2(:,273),heltab2x8(:,:,935))
  call Hloop_UW_V(ntryL,G1H8(437),20,wf4(:,39),3,G2H2(246),m3h4x2(:,274),heltab2x8(:,:,936))
  call Hloop_SV_V(ntryL,G1H8(345),wf4(:,38),G1H2(335),m3h4x2(:,275),heltab2x8(:,:,937))
  call Hloop_SV_V(ntryL,G1H8(356),wf4(:,39),G1H2(330),m3h4x2(:,276),heltab2x8(:,:,938))
  call Hotf_4pt_reduction(G2H8(43),RedSet_4(12),mass4set(:,18),  & 
G1H8(201),G1H8(202),G1H8(203),G1H8(204),G1H8(205),8)
  call HG1shiftOLR(G1H8(202),8,8)
  call Hotf_4pt_reduction(G2H8(44),RedSet_4(12),mass4set(:,18),  & 
G1H8(206),G1H8(207),G1H8(23),G1H8(208),G1H8(27),8)
  call HG1shiftOLR(G1H8(207),8,8)
  call Hotf_4pt_reduction(G2H8(45),RedSet_4(12),mass4set(:,18),  & 
G1H8(209),G1H8(32),G1H8(210),G1H8(1),G1H8(211),8)
  call HG1shiftOLR(G1H8(32),8,8)
  call Hotf_4pt_reduction(G2H8(46),RedSet_4(12),mass4set(:,18),  & 
G1H8(40),G1H8(212),G1H8(46),G1H8(213),G1H8(52),8)
  call HG1shiftOLR(G1H8(212),8,8)
  call Hloop_VV_S(ntryL,G2H8(35),wf4(:,38),G2H2(40),m3h4x2(:,277),heltab2x8(:,:,939))
  call Hloop_VV_S(ntryL,G2H8(36),wf4(:,38),G2H2(42),m3h4x2(:,278),heltab2x8(:,:,940))
  call Hloop_VV_S(ntryL,G2H8(37),wf4(:,39),G2H2(17),m3h4x2(:,279),heltab2x8(:,:,941))
  call Hloop_VV_S(ntryL,G2H8(38),wf4(:,39),G2H2(56),m3h4x2(:,280),heltab2x8(:,:,942))
  call Hloop_SV_V(ntryL,G2H8(47),wf4(:,38),G2H2(63),m3h4x2(:,281),heltab2x8(:,:,943))
  call Hloop_SV_V(ntryL,G2H8(48),wf4(:,38),G2H2(184),m3h4x2(:,282),heltab2x8(:,:,944))
  call Hloop_SV_V(ntryL,G2H8(49),wf4(:,39),G2H2(166),m3h4x2(:,283),heltab2x8(:,:,945))
  call Hloop_SV_V(ntryL,G2H8(50),wf4(:,39),G2H2(168),m3h4x2(:,284),heltab2x8(:,:,946))
  call Hotf_4pt_reduction(G2H8(39),RedSet_4(12),mass4set(:,18),  & 
G1H8(214),G1H8(59),G1H8(215),G1H8(85),G1H8(216),8)
  call HG1shiftOLR(G1H8(59),8,8)
  call Hotf_4pt_reduction(G2H8(40),RedSet_4(12),mass4set(:,18),  & 
G1H8(86),G1H8(217),G1H8(89),G1H8(218),G1H8(90),8)
  call HG1shiftOLR(G1H8(217),8,8)
  call Hotf_4pt_reduction(G2H8(41),RedSet_4(12),mass4set(:,18),  & 
G1H8(219),G1H8(220),G1H8(223),G1H8(224),G1H8(227),8)
  call HG1shiftOLR(G1H8(220),8,8)
  call Hotf_4pt_reduction(G2H8(42),RedSet_4(12),mass4set(:,18),  & 
G1H8(228),G1H8(229),G1H8(230),G1H8(232),G1H8(234),8)
  call HG1shiftOLR(G1H8(229),8,8)
  call Hloop_VV_S(ntryL,G1H8(445),wf4(:,38),G1H2(336),m3h4x2(:,285),heltab2x8(:,:,947))
  call Hloop_VV_S(ntryL,G1H8(446),wf4(:,39),G1H2(331),m3h4x2(:,286),heltab2x8(:,:,948))
  call Hotf_4pt_reduction(G2H4(43),RedSet_4(7),mass4set(:,1),  & 
G1H4(37),G1H4(130),G1H4(43),G1H4(127),G1H4(20),4)
  call HG1shiftOLR(G1H4(130),5,4)
  call Hotf_4pt_reduction(G2H4(47),RedSet_4(7),mass4set(:,2),  & 
G1H4(199),G1H4(13),G1H4(172),G1H4(176),G1H4(194),4)
  call HG1shiftOLR(G1H4(13),5,4)
  call Hotf_4pt_reduction(G2H4(48),RedSet_4(7),mass4set(:,3),  & 
G1H4(166),G1H4(188),G1H4(156),G1H4(158),G1H4(155),4)
  call HG1shiftOLR(G1H4(188),5,4)
  call Hloop_SV_T(ntryL,G1H4(159),18,ex4(:),8,G2H2(183),m3h2x2(:,514),heltab2x4(:,:,633))
  call Hloop_AV_Q(ntryL,G1H4(108),ex4(:),G1H2(384),m3h2x2(:,515),heltab2x4(:,:,634))
  call Hloop_A_Q(ntryL,G1H2(384),26,nMB,G2H2(186),n2h2(467))
  call Hotf_4pt_reduction(G2H4(52),RedSet_4(7),mass4set(:,3),  & 
G1H4(74),G1H4(47),G1H4(136),G1H4(41),G1H4(80),4)
  call HG1shiftOLR(G1H4(47),5,4)
  call Hloop_SV_V(ntryL,G1H4(167),ex4(:),G1H2(378),m3h2x2(:,516),heltab2x4(:,:,635))
  call Hloop_VV_S(ntryL,G1H4(168),ex4(:),G1H2(219),m3h2x2(:,517),heltab2x4(:,:,636))
  call Hloop_UW_V(ntryL,G1H4(170),18,ex4(:),8,G2H2(205),m3h2x2(:,518),heltab2x4(:,:,637))
  call Hloop_SQ_A(ntryL,G1H4(196),wf2(:,2),G1H2(220),ngH,m3h2x2(:,519),heltab2x4(:,:,638))
  call Hloop_Q_A(ntryL,G1H2(220),23,nMB,G2H2(208),n2h2(468))
  call Hloop_SQ_A(ntryL,G1H4(197),wf2(:,2),G1H2(225),ngX,m3h2x2(:,520),heltab2x4(:,:,639))
  call Hloop_Q_A(ntryL,G1H2(225),23,nMB,G2H2(223),n2h2(469))
  call Hloop_SQ_A(ntryL,G1H4(201),wf2(:,2),G1H2(226),ngPtb,m3h2x2(:,521),heltab2x4(:,:,640))
  call Hloop_Q_A(ntryL,G1H2(226),23,nMT,G2H2(226),n2h2(470))
  call Hloop_AQ_S(ntryL,G2H4(60),wf2(:,2),G2H2(125),ngPtb,m3h2x2(:,522),heltab2x4(:,:,641))
  call Hloop_VQ_A(ntryL,G1H4(21),wf2(:,2),G1H2(231),m3h2x2(:,523),heltab2x4(:,:,642))
  call Hloop_Q_A(ntryL,G1H2(231),23,nMB,G2H2(133),n2h2(471))
  call Hloop_ZQ_A(ntryL,G1H4(56),wf2(:,2),G1H2(341),ngZd,m3h2x2(:,524),heltab2x4(:,:,643))
  call Hloop_Q_A(ntryL,G1H2(341),23,nMB,G2H2(289),n2h2(472))
  call Hloop_WQ_A(ntryL,G1H4(34),wf2(:,2),G1H2(232),m3h2x2(:,525),heltab2x4(:,:,644))
  call Hloop_Q_A(ntryL,G1H2(232),23,nMT,G2H2(290),n2h2(473))
  call Hloop_AQ_W(ntryL,G2H4(61),wf2(:,2),G2H2(291),m3h2x2(:,526),heltab2x4(:,:,645))
  call Hloop_AQ_S(ntryL,G2H4(62),wf2(:,2),G2H2(292),ngPtb,m3h2x2(:,527),heltab2x4(:,:,646))
  call Hloop_AQ_W(ntryL,G2H4(76),wf2(:,2),G2H2(293),m3h2x2(:,528),heltab2x4(:,:,647))
  call Hotf_4pt_reduction(G2H4(77),RedSet_4(3),mass4set(:,1),  & 
G1H4(123),G1H4(124),G1H4(122),G1H4(125),G1H4(23),4)
  call HG1shiftOLR(G1H4(124),6,4)
  call Hotf_4pt_reduction(G2H4(78),RedSet_4(3),mass4set(:,2),  & 
G1H4(38),G1H4(233),G1H4(174),G1H4(234),G1H4(175),4)
  call HG1shiftOLR(G1H4(233),6,4)
  call Hotf_4pt_reduction(G2H4(80),RedSet_4(3),mass4set(:,3),  & 
G1H4(10),G1H4(113),G1H4(12),G1H4(179),G1H4(3),4)
  call HG1shiftOLR(G1H4(113),6,4)
  call Hloop_TV_S(ntryL,G1H4(214),17,ex4(:),8,G2H2(294),m3h2x2(:,529),heltab2x4(:,:,648))
  call Hloop_QV_A(ntryL,G1H4(219),ex4(:),G1H2(385),m3h2x2(:,530),heltab2x4(:,:,649))
  call Hloop_Q_A(ntryL,G1H2(385),25,nMB,G2H2(295),n2h2(474))
  call Hotf_4pt_reduction(G2H4(81),RedSet_4(3),mass4set(:,3),  & 
G1H4(180),G1H4(5),G1H4(181),G1H4(195),G1H4(235),4)
  call HG1shiftOLR(G1H4(5),6,4)
  call Hloop_SV_V(ntryL,G1H4(225),ex4(:),G1H2(237),m3h2x2(:,531),heltab2x4(:,:,650))
  call Hloop_VV_S(ntryL,G1H4(228),ex4(:),G1H2(238),m3h2x2(:,532),heltab2x4(:,:,651))
  call Hloop_UV_W(ntryL,G1H4(230),17,ex4(:),8,G2H2(296),m3h2x2(:,533),heltab2x4(:,:,652))
  call Hloop_SA_Q(ntryL,G1H4(83),wf2(:,4),G1H2(243),ngH,m3h2x2(:,534),heltab2x4(:,:,653))
  call Hloop_A_Q(ntryL,G1H2(243),23,nMB,G2H2(297),n2h2(475))
  call Hloop_SA_Q(ntryL,G1H4(69),wf2(:,4),G1H2(244),ngX,m3h2x2(:,535),heltab2x4(:,:,654))
  call Hloop_A_Q(ntryL,G1H2(244),23,nMB,G2H2(298),n2h2(476))
  call Hloop_SA_Q(ntryL,G1H4(85),wf2(:,4),G1H2(379),ngPbt,m3h2x2(:,536),heltab2x4(:,:,655))
  call Hloop_A_Q(ntryL,G1H2(379),23,nMT,G2H2(299),n2h2(477))
  call Hloop_QA_S(ntryL,G2H4(91),wf2(:,4),G2H2(300),ngPbt,m3h2x2(:,537),heltab2x4(:,:,656))
  call Hloop_VA_Q(ntryL,G1H4(86),wf2(:,4),G1H2(342),m3h2x2(:,538),heltab2x4(:,:,657))
  call Hloop_A_Q(ntryL,G1H2(342),23,nMB,G2H2(301),n2h2(478))
  call Hloop_ZA_Q(ntryL,G1H4(39),wf2(:,4),G1H2(445),ngZd,m3h2x2(:,539),heltab2x4(:,:,658))
  call Hloop_A_Q(ntryL,G1H2(445),23,nMB,G2H2(302),n2h2(479))
  call Hloop_WA_Q(ntryL,G1H4(75),wf2(:,4),G1H2(444),m3h2x2(:,540),heltab2x4(:,:,659))
  call Hloop_A_Q(ntryL,G1H2(444),23,nMT,G2H2(303),n2h2(480))
  call Hloop_QA_W(ntryL,G2H4(92),wf2(:,4),G2H2(304),m3h2x2(:,541),heltab2x4(:,:,660))
  call Hloop_QA_S(ntryL,G2H4(93),wf2(:,4),G2H2(305),ngPbt,m3h2x2(:,542),heltab2x4(:,:,661))
  call Hloop_QA_W(ntryL,G2H4(95),wf2(:,4),G2H2(306),m3h2x2(:,543),heltab2x4(:,:,662))
  call Hotf_4pt_reduction(G2H4(96),RedSet_4(6),mass4set(:,1),  & 
G1H4(212),G1H4(240),G1H4(213),G1H4(236),G1H4(229),4)
  call HG1shiftOLR(G1H4(240),9,4)
  call Hotf_4pt_reduction(G2H4(97),RedSet_4(6),mass4set(:,2),  & 
G1H4(241),G1H4(82),G1H4(244),G1H4(68),G1H4(25),4)
  call HG1shiftOLR(G1H4(82),9,4)
  call Hotf_4pt_reduction(G2H4(99),RedSet_4(6),mass4set(:,3),  & 
G1H4(98),G1H4(142),G1H4(111),G1H4(94),G1H4(92),4)
  call HG1shiftOLR(G1H4(142),9,4)
  call Hloop_SS_S(ntryL,G1H4(97),ex3(:),G1H4(151),m3h1x4(:,120),heltab2x4(:,:,663))
  call Hloop_SS_S(ntryL,G1H4(116),ex3(:),G1H4(157),m3h1x4(:,121),heltab2x4(:,:,664))
  call Hloop_SS_S(ntryL,G1H4(7),ex3(:),G1H4(198),m3h1x4(:,122),heltab2x4(:,:,665))
  call Hloop_AS_Q(ntryL,G1H4(4),ex3(:),G1H4(177),ngH,m3h1x4(:,123),heltab2x4(:,:,666))
  call Hloop_A_Q(ntryL,G1H4(177),22,nMB,G2H4(36),n2h4(455))
  call Hotf_4pt_reduction(G2H4(100),RedSet_4(6),mass4set(:,3),  & 
G1H4(178),G1H4(184),G1H4(185),G1H4(191),G1H4(192),4)
  call HG1shiftOLR(G1H4(184),9,4)
  call Hloop_ST_V(ntryL,G1H4(134),18,ex3(:),4,G2H4(23),m3h1x4(:,124),heltab2x4(:,:,667))
  call Hloop_ST_V(ntryL,G1H4(200),18,ex3(:),4,G2H4(28),m3h1x4(:,125),heltab2x4(:,:,668))
  call Hloop_VT_S(ntryL,G1H4(79),18,ex3(:),4,G2H4(1),m3h1x4(:,126),heltab2x4(:,:,669))
  call Hloop_VT_S(ntryL,G1H4(32),18,ex3(:),4,G2H4(4),m3h1x4(:,127),heltab2x4(:,:,670))
  call Hloop_VS_V(ntryL,G1H4(202),ex3(:),G1H4(24),m3h1x4(:,128),heltab2x4(:,:,671))
  call Hloop_VS_V(ntryL,G1H4(88),ex3(:),G1H4(52),m3h1x4(:,129),heltab2x4(:,:,672))
  call Hloop_QA_S(ntryL,G2H8(51),ex2(:),G2H4(2),ngH,m3h2x4(:,455),heltab2x8(:,:,949))
  call Hloop_QA_S(ntryL,G2H8(52),ex2(:),G2H4(44),ngX,m3h2x4(:,456),heltab2x8(:,:,950))
  call Hloop_QA_S(ntryL,G2H8(53),ex2(:),G2H4(94),ngPbt,m3h2x4(:,457),heltab2x8(:,:,951))
  call Hloop_SA_Q(ntryL,G1H8(448),ex2(:),G1H4(73),ngH,m3h2x4(:,458),heltab2x8(:,:,952))
  call Hloop_A_Q(ntryL,G1H4(73),22,nMB,G2H4(20),n2h4(456))
  call Hloop_SA_Q(ntryL,G1H8(482),ex2(:),G1H4(77),ngX,m3h2x4(:,459),heltab2x8(:,:,953))
  call Hloop_A_Q(ntryL,G1H4(77),22,nMB,G2H4(90),n2h4(457))
  call Hloop_SA_Q(ntryL,G1H8(473),ex2(:),G1H4(205),ngPbt,m3h2x4(:,460),heltab2x8(:,:,954))
  call Hloop_A_Q(ntryL,G1H4(205),22,nMT,G2H4(27),n2h4(458))
  call Hloop_QA_V(ntryL,G2H8(54),ex2(:),G2H4(102),m3h2x4(:,461),heltab2x8(:,:,955))
  call Hloop_QA_Z(ntryL,G2H8(55),ex2(:),G2H4(33),ngZd,m3h2x4(:,462),heltab2x8(:,:,956))
  call Hloop_QA_W(ntryL,G2H8(56),ex2(:),G2H4(98),m3h2x4(:,463),heltab2x8(:,:,957))
  call Hloop_SA_Q(ntryL,G0H8(46),ex2(:),G0H4(57),ngH,m3h2x4(:,464),heltab2x8(:,:,958))
  call Hloop_A_Q(ntryL,G0H4(57),22,nMB,G1H4(206),n2h4(459))
  call Hotf_4pt_reduction(G2H8(59),RedSet_4(5),mass4set(:,4),  & 
G1H8(235),G1H8(236),G1H8(237),G1H8(238),G1H8(240),8)
  call HG1shiftOLR(G1H8(236),9,8)
  call Hotf_4pt_reduction(G2H8(57),RedSet_4(5),mass4set(:,23),  & 
G1H8(242),G1H8(243),G1H8(244),G1H8(245),G1H8(246),8)
  call HG1shiftOLR(G1H8(243),9,8)
  call Hotf_4pt_reduction(G2H8(58),RedSet_4(5),mass4set(:,4),  & 
G1H8(248),G1H8(250),G1H8(251),G1H8(10),G1H8(252),8)
  call HG1shiftOLR(G1H8(250),9,8)
  call Hloop_WA_Q(ntryL,G1H8(471),ex2(:),G1H4(210),m3h2x4(:,465),heltab2x8(:,:,959))
  call Hloop_A_Q(ntryL,G1H4(210),22,nMT,G2H4(37),n2h4(460))
  call Hloop_SQ_A(ntryL,G1H4(90),wf4(:,5),G1H1(25),ngH,m3h4x1(:,1),heltab2x4(:,:,673))
  call Hloop_Q_A(ntryL,G1H1(25),27,nMB,G2H1(67),n2h1(241))
  call Hloop_SQ_A(ntryL,G1H4(137),wf4(:,5),G1H1(164),ngX,m3h4x1(:,2),heltab2x4(:,:,674))
  call Hloop_Q_A(ntryL,G1H1(164),27,nMB,G2H1(69),n2h1(242))
  call Hloop_SQ_A(ntryL,G1H4(133),wf4(:,5),G1H1(30),ngPtb,m3h4x1(:,3),heltab2x4(:,:,675))
  call Hloop_Q_A(ntryL,G1H1(30),27,nMT,G2H1(72),n2h1(243))
  call Hloop_AQ_S(ntryL,G2H4(101),wf4(:,5),G2H1(73),ngH,m3h4x1(:,4),heltab2x4(:,:,676))
  call Hloop_AQ_S(ntryL,G2H4(103),wf4(:,5),G2H1(75),ngX,m3h4x1(:,5),heltab2x4(:,:,677))
  call Hloop_AQ_S(ntryL,G2H4(104),wf4(:,5),G2H1(78),ngPtb,m3h4x1(:,6),heltab2x4(:,:,678))
  call Hloop_VQ_A(ntryL,G1H4(144),wf4(:,5),G1H1(31),m3h4x1(:,7),heltab2x4(:,:,679))
  call Hloop_Q_A(ntryL,G1H1(31),27,nMB,G2H1(81),n2h1(244))
  call Hloop_ZQ_A(ntryL,G1H4(141),wf4(:,5),G1H1(223),ngZd,m3h4x1(:,8),heltab2x4(:,:,680))
  call Hloop_Q_A(ntryL,G1H1(223),27,nMB,G2H1(84),n2h1(245))
  call Hloop_WQ_A(ntryL,G1H4(104),wf4(:,5),G1H1(36),m3h4x1(:,9),heltab2x4(:,:,681))
  call Hloop_Q_A(ntryL,G1H1(36),27,nMT,G2H1(91),n2h1(246))
  call Hloop_AQ_Z(ntryL,G2H4(105),wf4(:,5),G2H1(93),ngZd,m3h4x1(:,10),heltab2x4(:,:,682))
  call Hloop_AQ_W(ntryL,G2H4(107),wf4(:,5),G2H1(94),m3h4x1(:,11),heltab2x4(:,:,683))
  call Hloop_AQ_S(ntryL,G1H4(109),wf4(:,5),G1H1(37),ngX,m3h4x1(:,12),heltab2x4(:,:,684))
  call Hloop_AQ_S(ntryL,G2H4(108),wf4(:,5),G2H1(96),ngPtb,m3h4x1(:,13),heltab2x4(:,:,685))
  call Hloop_AQ_Z(ntryL,G1H4(182),wf4(:,5),G1H1(218),ngZd,m3h4x1(:,14),heltab2x4(:,:,686))
  call Hloop_AQ_W(ntryL,G2H4(109),wf4(:,5),G2H1(97),m3h4x1(:,15),heltab2x4(:,:,687))
  call Hotf_4pt_reduction(G2H4(111),RedSet_4(2),mass4set(:,1),  & 
G1H4(211),G1H4(221),G1H4(222),G1H4(226),G1H4(227),4)
  call HG1shiftOLR(G1H4(221),10,4)
  call Hotf_4pt_reduction(G2H4(112),RedSet_4(2),mass4set(:,2),  & 
G1H4(237),G1H4(238),G1H4(242),G1H4(243),G1H4(150),4)
  call HG1shiftOLR(G1H4(238),10,4)
  call Hotf_4pt_reduction(G2H4(113),RedSet_4(2),mass4set(:,3),  & 
G1H4(152),G1H4(159),G1H4(108),G1H4(167),G1H4(168),4)
  call HG1shiftOLR(G1H4(159),10,4)
  call Hloop_SS_S(ntryL,G1H4(112),ex3(:),G1H4(170),m3h1x4(:,130),heltab2x4(:,:,688))
  call Hloop_SS_S(ntryL,G1H4(147),ex3(:),G1H4(196),m3h1x4(:,131),heltab2x4(:,:,689))
  call Hloop_SS_S(ntryL,G1H4(103),ex3(:),G1H4(197),m3h1x4(:,132),heltab2x4(:,:,690))
  call Hloop_QS_A(ntryL,G1H4(148),ex3(:),G1H4(201),ngH,m3h1x4(:,133),heltab2x4(:,:,691))
  call Hloop_Q_A(ntryL,G1H4(201),21,nMB,G2H4(75),n2h4(461))
  call Hotf_4pt_reduction(G2H4(115),RedSet_4(2),mass4set(:,3),  & 
G1H4(21),G1H4(56),G1H4(34),G1H4(214),G1H4(219),4)
  call HG1shiftOLR(G1H4(56),10,4)
  call Hloop_ST_V(ntryL,G1H4(169),17,ex3(:),4,G2H4(40),m3h1x4(:,134),heltab2x4(:,:,692))
  call Hloop_ST_V(ntryL,G1H4(114),17,ex3(:),4,G2H4(59),m3h1x4(:,135),heltab2x4(:,:,693))
  call Hloop_VT_S(ntryL,G1H4(187),17,ex3(:),4,G2H4(45),m3h1x4(:,136),heltab2x4(:,:,694))
  call Hloop_VT_S(ntryL,G1H4(189),17,ex3(:),4,G2H4(83),m3h1x4(:,137),heltab2x4(:,:,695))
  call Hloop_VS_V(ntryL,G1H4(33),ex3(:),G1H4(225),m3h1x4(:,138),heltab2x4(:,:,696))
  call Hloop_VS_V(ntryL,G1H4(143),ex3(:),G1H4(228),m3h1x4(:,139),heltab2x4(:,:,697))
  call Hloop_AQ_S(ntryL,G2H8(60),ex1(:),G2H4(51),ngH,m3h2x4(:,466),heltab2x8(:,:,960))
  call Hloop_AQ_S(ntryL,G2H8(61),ex1(:),G2H4(79),ngX,m3h2x4(:,467),heltab2x8(:,:,961))
  call Hloop_AQ_S(ntryL,G2H8(62),ex1(:),G2H4(57),ngPtb,m3h2x4(:,468),heltab2x8(:,:,962))
  call Hloop_SQ_A(ntryL,G1H8(495),ex1(:),G1H4(230),ngH,m3h2x4(:,469),heltab2x8(:,:,963))
  call Hloop_Q_A(ntryL,G1H4(230),21,nMB,G2H4(31),n2h4(462))
  call Hloop_SQ_A(ntryL,G1H8(452),ex1(:),G1H4(83),ngX,m3h2x4(:,470),heltab2x8(:,:,964))
  call Hloop_Q_A(ntryL,G1H4(83),21,nMB,G2H4(35),n2h4(463))
  call Hloop_SQ_A(ntryL,G1H8(453),ex1(:),G1H4(69),ngPtb,m3h2x4(:,471),heltab2x8(:,:,965))
  call Hloop_Q_A(ntryL,G1H4(69),21,nMT,G2H4(68),n2h4(464))
  call Hloop_AQ_V(ntryL,G2H8(63),ex1(:),G2H4(25),m3h2x4(:,472),heltab2x8(:,:,966))
  call Hloop_AQ_Z(ntryL,G2H8(64),ex1(:),G2H4(30),ngZd,m3h2x4(:,473),heltab2x8(:,:,967))
  call Hloop_AQ_W(ntryL,G2H8(65),ex1(:),G2H4(69),m3h2x4(:,474),heltab2x8(:,:,968))
  call Hloop_SQ_A(ntryL,G0H8(54),ex1(:),G0H4(23),ngH,m3h2x4(:,475),heltab2x8(:,:,969))
  call Hloop_Q_A(ntryL,G0H4(23),21,nMB,G1H4(85),n2h4(465))
  call Hotf_4pt_reduction(G2H8(68),RedSet_4(4),mass4set(:,4),  & 
G1H8(41),G1H8(253),G1H8(43),G1H8(254),G1H8(45),8)
  call HG1shiftOLR(G1H8(253),10,8)
  call Hotf_4pt_reduction(G2H8(66),RedSet_4(4),mass4set(:,23),  & 
G1H8(255),G1H8(171),G1H8(256),G1H8(172),G1H8(257),8)
  call HG1shiftOLR(G1H8(171),10,8)
  call Hotf_4pt_reduction(G2H8(67),RedSet_4(4),mass4set(:,4),  & 
G1H8(175),G1H8(258),G1H8(176),G1H8(259),G1H8(191),8)
  call HG1shiftOLR(G1H8(258),10,8)
  call Hloop_WQ_A(ntryL,G1H8(455),ex1(:),G1H4(86),m3h2x4(:,476),heltab2x8(:,:,970))
  call Hloop_Q_A(ntryL,G1H4(86),21,nMT,G2H4(6),n2h4(466))
  call Hloop_SA_Q(ntryL,G1H4(204),wf4(:,2),G1H1(23),ngH,m3h4x1(:,16),heltab2x4(:,:,698))
  call Hloop_A_Q(ntryL,G1H1(23),27,nMB,G2H1(99),n2h1(247))
  call Hloop_SA_Q(ntryL,G1H4(207),wf4(:,2),G1H1(29),ngX,m3h4x1(:,17),heltab2x4(:,:,699))
  call Hloop_A_Q(ntryL,G1H1(29),27,nMB,G2H1(102),n2h1(248))
  call Hloop_SA_Q(ntryL,G1H4(209),wf4(:,2),G1H1(35),ngPbt,m3h4x1(:,18),heltab2x4(:,:,700))
  call Hloop_A_Q(ntryL,G1H1(35),27,nMT,G2H1(103),n2h1(249))
  call Hloop_QA_S(ntryL,G2H4(116),wf4(:,2),G2H1(105),ngH,m3h4x1(:,19),heltab2x4(:,:,701))
  call Hloop_QA_S(ntryL,G2H4(117),wf4(:,2),G2H1(108),ngX,m3h4x1(:,20),heltab2x4(:,:,702))
  call Hloop_QA_S(ntryL,G2H4(119),wf4(:,2),G2H1(111),ngPbt,m3h4x1(:,21),heltab2x4(:,:,703))
  call Hloop_VA_Q(ntryL,G1H4(239),wf4(:,2),G1H1(42),m3h4x1(:,22),heltab2x4(:,:,704))
  call Hloop_A_Q(ntryL,G1H1(42),27,nMB,G2H1(114),n2h1(250))
  call Hloop_ZA_Q(ntryL,G1H4(64),wf4(:,2),G1H1(174),ngZd,m3h4x1(:,23),heltab2x4(:,:,705))
  call Hloop_A_Q(ntryL,G1H1(174),27,nMB,G2H1(118),n2h1(251))
  call Hloop_WA_Q(ntryL,G1H4(45),wf4(:,2),G1H1(43),m3h4x1(:,24),heltab2x4(:,:,706))
  call Hloop_A_Q(ntryL,G1H1(43),27,nMT,G2H1(120),n2h1(252))
  call Hloop_QA_Z(ntryL,G2H4(120),wf4(:,2),G2H1(124),ngZd,m3h4x1(:,25),heltab2x4(:,:,707))
  call Hloop_QA_W(ntryL,G2H4(66),wf4(:,2),G2H1(126),m3h4x1(:,26),heltab2x4(:,:,708))
  call Hloop_QA_S(ntryL,G1H4(129),wf4(:,2),G1H1(175),ngX,m3h4x1(:,27),heltab2x4(:,:,709))
  call Hloop_QA_S(ntryL,G2H4(70),wf4(:,2),G2H1(129),ngPbt,m3h4x1(:,28),heltab2x4(:,:,710))
  call Hloop_QA_Z(ntryL,G1H4(132),wf4(:,2),G1H1(47),ngZd,m3h4x1(:,29),heltab2x4(:,:,711))
  call Hloop_QA_W(ntryL,G2H4(71),wf4(:,2),G2H1(130),m3h4x1(:,30),heltab2x4(:,:,712))
  call Hloop_SA_Q(ntryL,G0H4(1),ex2(:),G0H2(16),ngH,m3h2x2(:,544),heltab2x4(:,:,713))
  call Hloop_A_Q(ntryL,G0H2(16),23,nMB,G1H2(429),n2h2(481))
  call Hloop_SS_S(ntryL,G1H2(510),ex3(:),G1H2(428),m3h1x2(:,154),heltab2x2(:,:,557))
  call Hloop_SS_S(ntryL,G1H2(526),ex3(:),G1H2(423),m3h1x2(:,155),heltab2x2(:,:,558))
  call Hloop_VS_V(ntryL,G1H2(157),ex3(:),G1H2(422),m3h1x2(:,156),heltab2x2(:,:,559))
  call Hloop_VS_V(ntryL,G1H2(167),ex3(:),G1H2(499),m3h1x2(:,157),heltab2x2(:,:,560))
  call Hloop_SV_V(ntryL,G1H2(77),ex4(:),G1H1(180),m3h2x1(:,404),heltab2x2(:,:,561))
  call Hloop_VV_S(ntryL,G1H2(103),ex4(:),G1H1(41),m3h2x1(:,405),heltab2x2(:,:,562))
  call Hloop_SV_V(ntryL,G1H2(3),ex4(:),G1H1(181),m3h2x1(:,406),heltab2x2(:,:,563))
  call Hloop_VV_S(ntryL,G1H2(264),ex4(:),G1H1(59),m3h2x1(:,407),heltab2x2(:,:,564))
  call Hloop_SQ_A(ntryL,G0H4(6),ex1(:),G0H2(3),ngH,m3h2x2(:,545),heltab2x4(:,:,714))
  call Hloop_Q_A(ntryL,G0H2(3),23,nMB,G1H2(498),n2h2(482))
  call Hloop_SS_S(ntryL,G1H2(460),ex3(:),G1H2(494),m3h1x2(:,158),heltab2x2(:,:,565))
  call Hloop_SS_S(ntryL,G1H2(514),ex3(:),G1H2(493),m3h1x2(:,159),heltab2x2(:,:,566))
  call Hloop_VS_V(ntryL,G1H2(59),ex3(:),G1H2(477),m3h1x2(:,160),heltab2x2(:,:,567))
  call Hloop_VS_V(ntryL,G1H2(60),ex3(:),G1H2(476),m3h1x2(:,161),heltab2x2(:,:,568))
  call Hloop_SV_V(ntryL,G1H2(300),ex4(:),G1H1(185),m3h2x1(:,408),heltab2x2(:,:,569))
  call Hloop_VV_S(ntryL,G1H2(25),ex4(:),G1H1(70),m3h2x1(:,409),heltab2x2(:,:,570))
  call Hloop_SV_V(ntryL,G1H2(126),ex4(:),G1H1(186),m3h2x1(:,410),heltab2x2(:,:,571))
  call Hloop_VV_S(ntryL,G1H2(286),ex4(:),G1H1(81),m3h2x1(:,411),heltab2x2(:,:,572))
  call Hloop_TV_S(ntryL,G1H4(30),21,ex4(:),8,G2H2(307),m3h2x2(:,546),heltab2x4(:,:,715))
  call Hloop_SV_V(ntryL,G1H4(31),ex4(:),G1H2(128),m3h2x2(:,547),heltab2x4(:,:,716))
  call Hloop_VV_S(ntryL,G1H4(27),ex4(:),G1H2(306),m3h2x2(:,548),heltab2x4(:,:,717))
  call Hloop_UV_W(ntryL,G1H4(48),21,ex4(:),8,G2H2(308),m3h2x2(:,549),heltab2x4(:,:,718))
  call Hloop_WQ_A(ntryL,G1H4(60),ex1(:),G1H2(255),m3h2x2(:,550),heltab2x4(:,:,719))
  call Hloop_Q_A(ntryL,G1H2(255),29,nMT,G2H2(309),n2h2(483))
call HGT_OLR(G1H4(128),1,1,4)
call HGT_invQ_OLR(G1H4(128),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(128),ex2(:),G1H2(2),ngPbt,m3h2x2(:,551),heltab2x4(:,:,720))
  call Hloop_WQ_A(ntryL,G1H4(36),ex1(:),G1H2(256),m3h2x2(:,552),heltab2x4(:,:,721))
  call Hloop_Q_A(ntryL,G1H2(256),29,nMT,G2H2(310),n2h2(484))
  call Hloop_WQ_A(ntryL,G1H4(63),ex1(:),G1H2(14),m3h2x2(:,553),heltab2x4(:,:,722))
  call Hloop_Q_A(ntryL,G1H2(14),29,nMT,G2H2(311),n2h2(485))
  call Hloop_SQ_A(ntryL,G1H4(51),ex1(:),G1H2(260),ngPtb,m3h2x2(:,554),heltab2x4(:,:,723))
  call Hloop_Q_A(ntryL,G1H2(260),29,nMT,G2H2(312),n2h2(486))
call HGT_raise_alpha_OLR(G1H4(26),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(26),ex2(:),G1H2(427),m3h2x2(:,555),heltab2x4(:,:,724))
  call Hloop_SQ_A(ntryL,G1H4(55),ex1(:),G1H2(261),ngPtb,m3h2x2(:,556),heltab2x4(:,:,725))
  call Hloop_Q_A(ntryL,G1H2(261),29,nMT,G2H2(313),n2h2(487))
  call Hloop_SQ_A(ntryL,G1H4(72),ex1(:),G1H2(16),ngPtb,m3h2x2(:,557),heltab2x4(:,:,726))
  call Hloop_Q_A(ntryL,G1H2(16),29,nMT,G2H2(314),n2h2(488))
  call Hloop_WA_Q(ntryL,G1H4(65),ex2(:),G1H2(271),m3h2x2(:,558),heltab2x4(:,:,727))
  call Hloop_A_Q(ntryL,G1H2(271),30,nMT,G2H2(315),n2h2(489))
call HGT_OLR(G1H4(81),1,1,4)
call HGT_invQ_OLR(G1H4(81),2,5,4)
  call Hloop_SQ_A(ntryL,G1H4(81),ex1(:),G1H2(4),ngPtb,m3h2x2(:,559),heltab2x4(:,:,728))
  call Hloop_WA_Q(ntryL,G1H4(139),ex2(:),G1H2(272),m3h2x2(:,560),heltab2x4(:,:,729))
  call Hloop_A_Q(ntryL,G1H2(272),30,nMT,G2H2(316),n2h2(490))
  call Hloop_WA_Q(ntryL,G1H4(217),ex2(:),G1H2(28),m3h2x2(:,561),heltab2x4(:,:,730))
  call Hloop_A_Q(ntryL,G1H2(28),30,nMT,G2H2(317),n2h2(491))
  call Hloop_SA_Q(ntryL,G1H4(218),ex2(:),G1H2(276),ngPbt,m3h2x2(:,562),heltab2x4(:,:,731))
  call Hloop_A_Q(ntryL,G1H2(276),30,nMT,G2H2(318),n2h2(492))
call HGT_raise_alpha_OLR(G1H4(6),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(6),ex1(:),G1H2(33),m3h2x2(:,563),heltab2x4(:,:,732))
  call Hloop_SA_Q(ntryL,G1H4(15),ex2(:),G1H2(277),ngPbt,m3h2x2(:,564),heltab2x4(:,:,733))
  call Hloop_A_Q(ntryL,G1H2(277),30,nMT,G2H2(319),n2h2(493))
  call Hloop_SA_Q(ntryL,G1H4(16),ex2(:),G1H2(39),ngPbt,m3h2x2(:,565),heltab2x4(:,:,734))
  call Hloop_A_Q(ntryL,G1H2(39),30,nMT,G2H2(320),n2h2(494))
  call Hloop_AS_Q(ntryL,G1H2(313),ex3(:),G1H2(287),ngH,m3h1x2(:,162),heltab2x2(:,:,573))
  call Hloop_A_Q(ntryL,G1H2(287),30,nMT,G2H2(321),n2h2(495))
call HGT_OLR(G1H2(314),1,1,2)
call HGT_invQ_OLR(G1H2(314),2,5,2)
  call Hloop_SQ_A(ntryL,G1H2(314),ex1(:),G1H1(191),ngPtb,m3h2x1(:,412),heltab2x2(:,:,574))
  call Hloop_AS_Q(ntryL,G1H2(320),ex3(:),G1H2(45),ngH,m3h1x2(:,163),heltab2x2(:,:,575))
  call Hloop_A_Q(ntryL,G1H2(45),30,nMT,G2H2(322),n2h2(497))
  call Hloop_AS_Q(ntryL,G1H2(389),ex3(:),G1H2(288),ngH,m3h1x2(:,164),heltab2x2(:,:,576))
  call Hloop_A_Q(ntryL,G1H2(288),30,nMT,G2H2(323),n2h2(498))
  call Hloop_AS_Q(ntryL,G1H2(390),ex3(:),G1H2(456),ngH,m3h1x2(:,165),heltab2x2(:,:,577))
  call Hloop_A_Q(ntryL,G1H2(456),30,nMT,G2H2(324),n2h2(499))
call HGT_raise_alpha_OLR(G1H2(395),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(395),2,5,2)
  call Hloop_WQ_A(ntryL,G1H2(395),ex1(:),G1H1(92),m3h2x1(:,413),heltab2x2(:,:,578))
  call Hloop_AS_Q(ntryL,G1H2(400),ex3(:),G1H2(292),ngH,m3h1x2(:,166),heltab2x2(:,:,579))
  call Hloop_A_Q(ntryL,G1H2(292),30,nMT,G2H2(325),n2h2(501))
  call Hloop_AS_Q(ntryL,G1H2(401),ex3(:),G1H2(481),ngH,m3h1x2(:,167),heltab2x2(:,:,580))
  call Hloop_A_Q(ntryL,G1H2(481),30,nMT,G2H2(326),n2h2(502))
  call Hloop_AV_Q(ntryL,G1H4(17),ex4(:),G1H2(293),m3h2x2(:,566),heltab2x4(:,:,735))
  call Hloop_A_Q(ntryL,G1H2(293),30,nMT,G2H2(327),n2h2(503))
call HGT_OLR(G1H4(18),1,1,4)
call HGT_invQ_OLR(G1H4(18),2,5,4)
  call Hloop_SQ_A(ntryL,G1H4(18),ex1(:),G1H2(57),ngPtb,m3h2x2(:,567),heltab2x4(:,:,736))
  call Hloop_AV_Q(ntryL,G1H4(58),ex4(:),G1H2(303),m3h2x2(:,568),heltab2x4(:,:,737))
  call Hloop_A_Q(ntryL,G1H2(303),30,nMT,G2H2(328),n2h2(504))
  call Hloop_AV_Q(ntryL,G1H4(186),ex4(:),G1H2(99),m3h2x2(:,569),heltab2x4(:,:,738))
  call Hloop_A_Q(ntryL,G1H2(99),30,nMT,G2H2(329),n2h2(505))
  call Hloop_AV_Q(ntryL,G1H4(183),ex4(:),G1H2(304),m3h2x2(:,570),heltab2x4(:,:,739))
  call Hloop_A_Q(ntryL,G1H2(304),30,nMB,G2H2(330),n2h2(506))
call HGT_raise_alpha_OLR(G1H4(193),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(193),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(193),ex1(:),G1H2(273),ngZd,m3h2x2(:,571),heltab2x4(:,:,740))
  call Hloop_AV_Q(ntryL,G1H4(49),ex4(:),G1H2(308),m3h2x2(:,572),heltab2x4(:,:,741))
  call Hloop_A_Q(ntryL,G1H2(308),30,nMB,G2H2(331),n2h2(507))
  call Hloop_AV_Q(ntryL,G1H4(40),ex4(:),G1H2(269),m3h2x2(:,573),heltab2x4(:,:,742))
  call Hloop_A_Q(ntryL,G1H2(269),30,nMB,G2H2(332),n2h2(508))
  call Hloop_AV_Q(ntryL,G1H4(67),ex4(:),G1H2(309),m3h2x2(:,574),heltab2x4(:,:,743))
  call Hloop_A_Q(ntryL,G1H2(309),30,nMT,G2H2(333),n2h2(509))
call HGT_raise_alpha_OLR(G1H4(59),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(59),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(59),ex1(:),G1H2(36),m3h2x2(:,575),heltab2x4(:,:,744))
  call Hloop_AV_Q(ntryL,G1H4(42),ex4(:),G1H2(47),m3h2x2(:,576),heltab2x4(:,:,745))
  call Hloop_A_Q(ntryL,G1H2(47),30,nMT,G2H2(334),n2h2(510))
  call Hloop_AV_Q(ntryL,G1H4(118),ex4(:),G1H2(318),m3h2x2(:,577),heltab2x4(:,:,746))
  call Hloop_A_Q(ntryL,G1H2(318),30,nMT,G2H2(335),n2h2(511))
  call Hloop_QS_A(ntryL,G1H2(411),ex3(:),G1H2(329),ngH,m3h1x2(:,168),heltab2x2(:,:,581))
  call Hloop_Q_A(ntryL,G1H2(329),29,nMT,G2H2(336),n2h2(512))
call HGT_OLR(G1H2(412),1,1,2)
call HGT_invQ_OLR(G1H2(412),2,5,2)
  call Hloop_SA_Q(ntryL,G1H2(412),ex2(:),G1H1(192),ngPbt,m3h2x1(:,414),heltab2x2(:,:,582))
  call Hloop_QS_A(ntryL,G1H2(418),ex3(:),G1H2(340),ngH,m3h1x2(:,169),heltab2x2(:,:,583))
  call Hloop_Q_A(ntryL,G1H2(340),29,nMT,G2H2(337),n2h2(514))
  call Hloop_QS_A(ntryL,G1H2(9),ex3(:),G1H2(351),ngH,m3h1x2(:,170),heltab2x2(:,:,584))
  call Hloop_Q_A(ntryL,G1H2(351),29,nMT,G2H2(338),n2h2(515))
  call Hloop_QS_A(ntryL,G1H2(10),ex3(:),G1H2(362),ngH,m3h1x2(:,171),heltab2x2(:,:,585))
  call Hloop_Q_A(ntryL,G1H2(362),29,nMT,G2H2(339),n2h2(516))
call HGT_raise_alpha_OLR(G1H2(11),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(11),2,5,2)
  call Hloop_WA_Q(ntryL,G1H2(11),ex2(:),G1H1(103),m3h2x1(:,415),heltab2x2(:,:,586))
  call Hloop_QS_A(ntryL,G1H2(12),ex3(:),G1H2(383),ngH,m3h1x2(:,172),heltab2x2(:,:,587))
  call Hloop_Q_A(ntryL,G1H2(383),29,nMT,G2H2(340),n2h2(518))
  call Hloop_QS_A(ntryL,G1H2(416),ex3(:),G1H2(394),ngH,m3h1x2(:,173),heltab2x2(:,:,588))
  call Hloop_Q_A(ntryL,G1H2(394),29,nMT,G2H2(341),n2h2(519))
  call Hloop_QV_A(ntryL,G1H4(22),ex4(:),G1H2(384),m3h2x2(:,578),heltab2x4(:,:,747))
  call Hloop_Q_A(ntryL,G1H2(384),29,nMB,G2H2(342),n2h2(520))
call HGT_OLR(G1H4(216),1,1,4)
call HGT_invQ_OLR(G1H4(216),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(216),ex2(:),G1H2(220),ngX,m3h2x2(:,579),heltab2x4(:,:,748))
  call Hloop_QV_A(ntryL,G1H4(120),ex4(:),G1H2(225),m3h2x2(:,580),heltab2x4(:,:,749))
  call Hloop_Q_A(ntryL,G1H2(225),29,nMB,G2H2(343),n2h2(521))
  call Hloop_QV_A(ntryL,G1H4(121),ex4(:),G1H2(226),m3h2x2(:,581),heltab2x4(:,:,750))
  call Hloop_Q_A(ntryL,G1H2(226),29,nMB,G2H2(344),n2h2(522))
  call Hloop_QV_A(ntryL,G1H4(119),ex4(:),G1H2(231),m3h2x2(:,582),heltab2x4(:,:,751))
  call Hloop_Q_A(ntryL,G1H2(231),29,nMB,G2H2(345),n2h2(523))
call HGT_OLR(G1H4(8),1,1,4)
call HGT_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(8),ex2(:),G1H2(341),ngH,m3h2x2(:,583),heltab2x4(:,:,752))
  call Hloop_QV_A(ntryL,G1H4(2),ex4(:),G1H2(232),m3h2x2(:,584),heltab2x4(:,:,753))
  call Hloop_Q_A(ntryL,G1H2(232),29,nMB,G2H2(346),n2h2(524))
  call Hloop_QV_A(ntryL,G1H4(11),ex4(:),G1H2(385),m3h2x2(:,585),heltab2x4(:,:,754))
  call Hloop_Q_A(ntryL,G1H2(385),29,nMB,G2H2(347),n2h2(525))
  call Hloop_QV_A(ntryL,G1H4(154),ex4(:),G1H2(243),m3h2x2(:,586),heltab2x4(:,:,755))
  call Hloop_Q_A(ntryL,G1H2(243),29,nMT,G2H2(348),n2h2(526))
call HGT_OLR(G1H4(14),1,1,4)
call HGT_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(14),ex2(:),G1H2(244),ngPbt,m3h2x2(:,587),heltab2x4(:,:,756))
  call Hloop_QV_A(ntryL,G1H4(107),ex4(:),G1H2(379),m3h2x2(:,588),heltab2x4(:,:,757))
  call Hloop_Q_A(ntryL,G1H2(379),29,nMT,G2H2(349),n2h2(527))
  call Hloop_QV_A(ntryL,G1H4(29),ex4(:),G1H2(342),m3h2x2(:,589),heltab2x4(:,:,758))
  call Hloop_Q_A(ntryL,G1H2(342),29,nMT,G2H2(350),n2h2(528))
  call Hloop_QV_A(ntryL,G1H4(44),ex4(:),G1H2(445),m3h2x2(:,590),heltab2x4(:,:,759))
  call Hloop_Q_A(ntryL,G1H2(445),29,nMT,G2H2(351),n2h2(529))
call HGT_raise_alpha_OLR(G1H4(46),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(46),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(46),ex2(:),G1H2(444),m3h2x2(:,591),heltab2x4(:,:,760))
  call Hloop_QV_A(ntryL,G1H4(165),ex4(:),G1H2(510),m3h2x2(:,592),heltab2x4(:,:,761))
  call Hloop_Q_A(ntryL,G1H2(510),29,nMT,G2H2(352),n2h2(530))
  call Hloop_QV_A(ntryL,G1H4(57),ex4(:),G1H2(526),m3h2x2(:,593),heltab2x4(:,:,762))
  call Hloop_Q_A(ntryL,G1H2(526),29,nMT,G2H2(353),n2h2(531))
  call Hloop_QV_A(ntryL,G1H4(61),ex4(:),G1H2(157),m3h2x2(:,594),heltab2x4(:,:,763))
  call Hloop_Q_A(ntryL,G1H2(157),29,nMB,G2H2(354),n2h2(532))
call HGT_OLR(G1H4(173),1,1,4)
call HGT_invQ_OLR(G1H4(173),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(173),ex2(:),G1H2(167),ngH,m3h2x2(:,595),heltab2x4(:,:,764))
  call Hloop_QV_A(ntryL,G1H4(66),ex4(:),G1H2(77),m3h2x2(:,596),heltab2x4(:,:,765))
  call Hloop_Q_A(ntryL,G1H2(77),29,nMB,G2H2(355),n2h2(533))
  call Hloop_QV_A(ntryL,G1H4(70),ex4(:),G1H2(103),m3h2x2(:,597),heltab2x4(:,:,766))
  call Hloop_Q_A(ntryL,G1H2(103),29,nMB,G2H2(356),n2h2(534))
  call Hloop_QV_A(ntryL,G1H4(35),ex4(:),G1H2(3),m3h2x2(:,598),heltab2x4(:,:,767))
  call Hloop_Q_A(ntryL,G1H2(3),29,nMB,G2H2(357),n2h2(535))
call HGT_OLR(G1H4(140),1,1,4)
call HGT_invQ_OLR(G1H4(140),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(140),ex2(:),G1H2(264),ngX,m3h2x2(:,599),heltab2x4(:,:,768))
  call Hloop_QV_A(ntryL,G1H4(84),ex4(:),G1H2(460),m3h2x2(:,600),heltab2x4(:,:,769))
  call Hloop_Q_A(ntryL,G1H2(460),29,nMB,G2H2(358),n2h2(536))
  call Hloop_QV_A(ntryL,G1H4(95),ex4(:),G1H2(514),m3h2x2(:,601),heltab2x4(:,:,770))
  call Hloop_Q_A(ntryL,G1H2(514),29,nMB,G2H2(359),n2h2(537))
  call Hloop_QV_A(ntryL,G1H4(126),ex4(:),G1H2(59),m3h2x2(:,602),heltab2x4(:,:,771))
  call Hloop_Q_A(ntryL,G1H2(59),29,nMT,G2H2(360),n2h2(538))
call HGT_OLR(G1H4(87),1,1,4)
call HGT_invQ_OLR(G1H4(87),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(87),ex2(:),G1H2(60),ngPbt,m3h2x2(:,603),heltab2x4(:,:,772))
  call Hloop_QV_A(ntryL,G1H4(76),ex4(:),G1H2(300),m3h2x2(:,604),heltab2x4(:,:,773))
  call Hloop_Q_A(ntryL,G1H2(300),29,nMT,G2H2(361),n2h2(539))
  call Hloop_QV_A(ntryL,G1H4(110),ex4(:),G1H2(25),m3h2x2(:,605),heltab2x4(:,:,774))
  call Hloop_Q_A(ntryL,G1H2(25),29,nMT,G2H2(362),n2h2(540))
  call Hloop_QV_A(ntryL,G1H4(131),ex4(:),G1H2(126),m3h2x2(:,606),heltab2x4(:,:,775))
  call Hloop_Q_A(ntryL,G1H2(126),29,nMB,G2H2(363),n2h2(541))
call HGT_raise_alpha_OLR(G1H4(135),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(135),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(135),ex2(:),G1H2(286),ngZd,m3h2x2(:,607),heltab2x4(:,:,776))
  call Hloop_QV_A(ntryL,G1H4(89),ex4(:),G1H2(255),m3h2x2(:,608),heltab2x4(:,:,777))
  call Hloop_Q_A(ntryL,G1H2(255),29,nMB,G2H2(364),n2h2(542))
  call Hloop_QV_A(ntryL,G1H4(138),ex4(:),G1H2(256),m3h2x2(:,609),heltab2x4(:,:,778))
  call Hloop_Q_A(ntryL,G1H2(256),29,nMB,G2H2(365),n2h2(543))
  call Hloop_QV_A(ntryL,G1H4(96),ex4(:),G1H2(14),m3h2x2(:,610),heltab2x4(:,:,779))
  call Hloop_Q_A(ntryL,G1H2(14),29,nMT,G2H2(366),n2h2(544))
call HGT_raise_alpha_OLR(G1H4(146),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(146),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(146),ex2(:),G1H2(260),m3h2x2(:,611),heltab2x4(:,:,780))
  call Hloop_QV_A(ntryL,G1H4(153),ex4(:),G1H2(261),m3h2x2(:,612),heltab2x4(:,:,781))
  call Hloop_Q_A(ntryL,G1H2(261),29,nMT,G2H2(367),n2h2(545))
  call Hloop_QV_A(ntryL,G1H4(160),ex4(:),G1H2(16),m3h2x2(:,613),heltab2x4(:,:,782))
  call Hloop_Q_A(ntryL,G1H2(16),29,nMT,G2H2(368),n2h2(546))
  call Hloop_QS_A(ntryL,G1H2(7),ex3(:),G1H2(271),ngH,m3h1x2(:,174),heltab2x2(:,:,589))
  call Hloop_Q_A(ntryL,G1H2(271),29,nMB,G2H2(369),n2h2(547))
call HGT_OLR(G1H2(492),1,1,2)
call HGT_invQ_OLR(G1H2(492),2,5,2)
  call Hloop_SA_Q(ntryL,G1H2(492),ex2(:),G1H1(196),ngX,m3h2x1(:,416),heltab2x2(:,:,590))
  call Hloop_QS_A(ntryL,G1H2(449),ex3(:),G1H2(272),ngH,m3h1x2(:,175),heltab2x2(:,:,591))
  call Hloop_Q_A(ntryL,G1H2(272),29,nMB,G2H2(370),n2h2(549))
  call Hloop_QS_A(ntryL,G1H2(27),ex3(:),G1H2(28),ngH,m3h1x2(:,176),heltab2x2(:,:,592))
  call Hloop_Q_A(ntryL,G1H2(28),29,nMB,G2H2(371),n2h2(550))
  call Hloop_QS_A(ntryL,G1H2(503),ex3(:),G1H2(276),ngH,m3h1x2(:,177),heltab2x2(:,:,593))
  call Hloop_Q_A(ntryL,G1H2(276),29,nMB,G2H2(372),n2h2(551))
call HGT_OLR(G1H2(63),1,1,2)
call HGT_invQ_OLR(G1H2(63),2,5,2)
  call Hloop_SA_Q(ntryL,G1H2(63),ex2(:),G1H1(114),ngH,m3h2x1(:,417),heltab2x2(:,:,594))
  call Hloop_QS_A(ntryL,G1H2(250),ex3(:),G1H2(277),ngH,m3h1x2(:,178),heltab2x2(:,:,595))
  call Hloop_Q_A(ntryL,G1H2(277),29,nMB,G2H2(373),n2h2(553))
  call Hloop_QS_A(ntryL,G1H2(284),ex3(:),G1H2(39),ngH,m3h1x2(:,179),heltab2x2(:,:,596))
  call Hloop_Q_A(ntryL,G1H2(39),29,nMB,G2H2(374),n2h2(554))
  call Hloop_QS_A(ntryL,G1H2(69),ex3(:),G1H2(313),ngH,m3h1x2(:,180),heltab2x2(:,:,597))
  call Hloop_Q_A(ntryL,G1H2(313),29,nMT,G2H2(375),n2h2(555))
call HGT_OLR(G1H2(212),1,1,2)
call HGT_invQ_OLR(G1H2(212),2,5,2)
  call Hloop_SA_Q(ntryL,G1H2(212),ex2(:),G1H1(197),ngPbt,m3h2x1(:,418),heltab2x2(:,:,598))
  call Hloop_QS_A(ntryL,G1H2(19),ex3(:),G1H2(287),ngH,m3h1x2(:,181),heltab2x2(:,:,599))
  call Hloop_Q_A(ntryL,G1H2(287),29,nMT,G2H2(376),n2h2(557))
  call Hloop_QS_A(ntryL,G1H2(8),ex3(:),G1H2(314),ngH,m3h1x2(:,182),heltab2x2(:,:,600))
  call Hloop_Q_A(ntryL,G1H2(314),29,nMT,G2H2(377),n2h2(558))
  call Hloop_QS_A(ntryL,G1H2(75),ex3(:),G1H2(320),ngH,m3h1x2(:,183),heltab2x2(:,:,601))
  call Hloop_Q_A(ntryL,G1H2(320),29,nMT,G2H2(378),n2h2(559))
call HGT_raise_alpha_OLR(G1H2(215),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(215),2,5,2)
  call Hloop_WA_Q(ntryL,G1H2(215),ex2(:),G1H1(125),m3h2x1(:,419),heltab2x2(:,:,602))
  call Hloop_QS_A(ntryL,G1H2(298),ex3(:),G1H2(45),ngH,m3h1x2(:,184),heltab2x2(:,:,603))
  call Hloop_Q_A(ntryL,G1H2(45),29,nMT,G2H2(379),n2h2(561))
  call Hloop_QS_A(ntryL,G1H2(34),ex3(:),G1H2(389),ngH,m3h1x2(:,185),heltab2x2(:,:,604))
  call Hloop_Q_A(ntryL,G1H2(389),29,nMT,G2H2(380),n2h2(562))
  call Hloop_QS_A(ntryL,G1H2(451),ex3(:),G1H2(288),ngH,m3h1x2(:,186),heltab2x2(:,:,605))
  call Hloop_Q_A(ntryL,G1H2(288),23,nMB,G2H2(381),n2h2(563))
call HGT_OLR(G1H2(440),1,1,2)
call HGT_invQ_OLR(G1H2(440),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(440),-8,nMB,G2H2(382),n2h2(564))
  call Hloop_AV_Q(ntryL,G2H2(382),ex4(:),G2H1(131),m3h2x1(:,420),heltab2x2(:,:,606))
  call Hloop_QS_A(ntryL,G1H2(46),ex3(:),G1H2(390),ngH,m3h1x2(:,187),heltab2x2(:,:,607))
  call Hloop_Q_A(ntryL,G1H2(390),23,nMB,G2H2(382),n2h2(565))
  call Hloop_QS_A(ntryL,G1H2(51),ex3(:),G1H2(456),ngH,m3h1x2(:,188),heltab2x2(:,:,608))
  call Hloop_Q_A(ntryL,G1H2(456),23,nMB,G2H2(383),n2h2(566))
  call Hloop_QS_A(ntryL,G0H2(37),ex3(:),G0H2(14),ngH,m3h1x2(:,189),heltab2x2(:,:,609))
  call Hloop_Q_A(ntryL,G0H2(14),23,nMB,G1H2(395),n2h2(567))
  call Hloop_QS_A(ntryL,G1H2(488),ex3(:),G1H2(400),ngH,m3h1x2(:,190),heltab2x2(:,:,610))
  call Hloop_Q_A(ntryL,G1H2(400),23,nMT,G2H2(384),n2h2(568))
call HGT_OLR(G1H2(483),1,1,2)
call HGT_invQ_OLR(G1H2(483),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(483),-8,nMT,G2H2(385),n2h2(569))
  call Hloop_AV_Q(ntryL,G2H2(385),ex4(:),G2H1(132),m3h2x1(:,421),heltab2x2(:,:,611))
  call Hloop_QS_A(ntryL,G1H2(462),ex3(:),G1H2(292),ngH,m3h1x2(:,191),heltab2x2(:,:,612))
  call Hloop_Q_A(ntryL,G1H2(292),23,nMT,G2H2(385),n2h2(570))
  call Hloop_QS_A(ntryL,G1H2(52),ex3(:),G1H2(401),ngH,m3h1x2(:,192),heltab2x2(:,:,613))
  call Hloop_Q_A(ntryL,G1H2(401),23,nMT,G2H2(386),n2h2(571))
  call Hloop_QS_A(ntryL,G0H2(32),ex3(:),G0H2(13),ngH,m3h1x2(:,193),heltab2x2(:,:,614))
  call Hloop_Q_A(ntryL,G0H2(13),23,nMT,G1H2(481),n2h2(572))
  call Hloop_ST_V(ntryL,G1H2(374),19,ex3(:),4,G2H2(387),m3h1x2(:,194),heltab2x2(:,:,615))
call HGT_OLR(G1H2(363),1,1,2)
call HGT_invQ_OLR(G1H2(363),2,5,2)
  call Hloop_SV_V(ntryL,G1H2(363),ex4(:),G1H1(202),m3h2x1(:,422),heltab2x2(:,:,616))
  call Hloop_ST_V(ntryL,G1H2(154),19,ex3(:),4,G2H2(388),m3h1x2(:,195),heltab2x2(:,:,617))
  call Hloop_ST_V(ntryL,G1H2(58),19,ex3(:),4,G2H2(389),m3h1x2(:,196),heltab2x2(:,:,618))
  call Hloop_VT_S(ntryL,G1H2(88),19,ex3(:),4,G2H2(390),m3h1x2(:,197),heltab2x2(:,:,619))
call HGT_OLR(G1H2(70),1,1,2)
call HGT_invQ_OLR(G1H2(70),2,5,2)
  call Hloop_SV_T(ntryL,G1H2(70),-8,ex4(:),8,G2H1(133),m3h2x1(:,423),heltab2x2(:,:,620))
  call Hloop_VT_S(ntryL,G1H2(76),19,ex3(:),4,G2H2(391),m3h1x2(:,198),heltab2x2(:,:,621))
  call Hloop_VT_S(ntryL,G1H2(81),19,ex3(:),4,G2H2(392),m3h1x2(:,199),heltab2x2(:,:,622))
  call Hloop_VT_S(ntryL,G0H2(31),19,ex3(:),4,G1H2(293),m3h1x2(:,200),heltab2x2(:,:,623))
  call Hloop_ST_V(ntryL,G1H2(230),19,ex3(:),4,G2H2(393),m3h1x2(:,201),heltab2x2(:,:,624))
call HGT_raise_alpha_OLR(G1H2(168),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(168),2,5,2)
  call Hloop_UW_V(ntryL,G1H2(168),-8,ex4(:),8,G2H1(134),m3h2x1(:,424),heltab2x2(:,:,625))
  call Hloop_ST_V(ntryL,G1H2(82),19,ex3(:),4,G2H2(394),m3h1x2(:,202),heltab2x2(:,:,626))
  call Hloop_ST_V(ntryL,G1H2(87),19,ex3(:),4,G2H2(395),m3h1x2(:,203),heltab2x2(:,:,627))
  call Hloop_ST_V(ntryL,G0H2(21),19,ex3(:),4,G1H2(303),m3h1x2(:,204),heltab2x2(:,:,628))
  call Hloop_VT_S(ntryL,G1H2(93),19,ex3(:),4,G2H2(396),m3h1x2(:,205),heltab2x2(:,:,629))
call HGT_raise_alpha_OLR(G1H2(91),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(91),2,5,2)
  call Hloop_VV_S(ntryL,G1H2(91),ex4(:),G1H1(136),m3h2x1(:,425),heltab2x2(:,:,630))
  call Hloop_VT_S(ntryL,G1H2(218),19,ex3(:),4,G2H2(397),m3h1x2(:,206),heltab2x2(:,:,631))
  call Hloop_VT_S(ntryL,G1H2(21),19,ex3(:),4,G2H2(398),m3h1x2(:,207),heltab2x2(:,:,632))
  call Hloop_QV_A(ntryL,G1H2(111),ex4(:),G1H1(203),m3h2x1(:,426),heltab2x2(:,:,633))
  call Hloop_Q_A(ntryL,G1H1(203),27,nMB,G2H1(135),n2h1(253))
call HGT_OLR(G1H2(130),1,1,2)
call HGT_invQ_OLR(G1H2(130),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(130),-4,nMB,G2H2(399),n2h2(577))
  call Hloop_AS_Q(ntryL,G2H2(399),ex3(:),G2H2(400),ngH,m3h1x2(:,208),heltab2x2(:,:,634))
  call Hloop_QV_A(ntryL,G1H2(112),ex4(:),G1H1(48),m3h2x1(:,427),heltab2x2(:,:,635))
  call Hloop_Q_A(ntryL,G1H1(48),27,nMB,G2H1(136),n2h1(254))
  call Hloop_QV_A(ntryL,G1H2(505),ex4(:),G1H1(207),m3h2x1(:,428),heltab2x2(:,:,636))
  call Hloop_Q_A(ntryL,G1H1(207),27,nMB,G2H1(137),n2h1(255))
  call Hloop_QV_A(ntryL,G0H2(23),ex4(:),G0H1(1),m3h2x1(:,429),heltab2x2(:,:,637))
  call Hloop_Q_A(ntryL,G0H1(1),27,nMB,G1H1(49),n2h1(256))
  call Hloop_QV_A(ntryL,G1H2(117),ex4(:),G1H1(208),m3h2x1(:,430),heltab2x2(:,:,638))
  call Hloop_Q_A(ntryL,G1H1(208),27,nMT,G2H1(138),n2h1(257))
call HGT_OLR(G1H2(509),1,1,2)
call HGT_invQ_OLR(G1H2(509),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(509),-4,nMT,G2H2(399),n2h2(578))
  call Hloop_AS_Q(ntryL,G2H2(399),ex3(:),G2H2(401),ngH,m3h1x2(:,209),heltab2x2(:,:,639))
  call Hloop_QV_A(ntryL,G1H2(124),ex4(:),G1H1(53),m3h2x1(:,431),heltab2x2(:,:,640))
  call Hloop_Q_A(ntryL,G1H1(53),27,nMT,G2H1(139),n2h1(258))
  call Hloop_QV_A(ntryL,G1H2(129),ex4(:),G1H1(213),m3h2x1(:,432),heltab2x2(:,:,641))
  call Hloop_Q_A(ntryL,G1H1(213),27,nMT,G2H1(140),n2h1(259))
  call Hloop_QV_A(ntryL,G0H2(30),ex4(:),G0H1(1),m3h2x1(:,433),heltab2x2(:,:,642))
  call Hloop_Q_A(ntryL,G0H1(1),27,nMT,G1H1(147),n2h1(260))
  call Hloop_TV_S(ntryL,G1H2(135),19,ex4(:),8,G2H1(141),m3h2x1(:,434),heltab2x2(:,:,643))
call HGT_OLR(G1H2(141),1,1,2)
call HGT_invQ_OLR(G1H2(141),2,5,2)
  call Hloop_SS_S(ntryL,G1H2(141),ex3(:),G1H2(99),m3h1x2(:,210),heltab2x2(:,:,644))
  call Hloop_TV_S(ntryL,G1H2(450),19,ex4(:),8,G2H1(142),m3h2x1(:,435),heltab2x2(:,:,645))
  call Hloop_TV_S(ntryL,G1H2(439),19,ex4(:),8,G2H1(143),m3h2x1(:,436),heltab2x2(:,:,646))
  call Hloop_TV_S(ntryL,G1H2(433),19,ex4(:),8,G2H1(144),m3h2x1(:,437),heltab2x2(:,:,647))
call HGT_raise_alpha_OLR(G1H2(142),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(142),2,5,2)
  call Hloop_VT_S(ntryL,G1H2(142),-4,ex3(:),4,G2H2(399),m3h1x2(:,211),heltab2x2(:,:,648))
  call Hloop_TV_S(ntryL,G1H2(487),19,ex4(:),8,G2H1(145),m3h2x1(:,438),heltab2x2(:,:,649))
  call Hloop_TV_S(ntryL,G1H2(482),19,ex4(:),8,G2H1(146),m3h2x1(:,439),heltab2x2(:,:,650))
  call Hloop_TV_S(ntryL,G0H2(29),19,ex4(:),8,G1H1(214),m3h2x1(:,440),heltab2x2(:,:,651))
  call Hloop_UV_W(ntryL,G1H2(467),19,ex4(:),8,G2H1(147),m3h2x1(:,441),heltab2x2(:,:,652))
call HGT_OLR(G1H2(461),1,1,2)
call HGT_invQ_OLR(G1H2(461),2,5,2)
  call Hloop_ST_V(ntryL,G1H2(461),-4,ex3(:),4,G2H2(402),m3h1x2(:,212),heltab2x2(:,:,653))
  call Hloop_UV_W(ntryL,G1H2(153),19,ex4(:),8,G2H1(148),m3h2x1(:,442),heltab2x2(:,:,654))
  call Hloop_UV_W(ntryL,G1H2(159),19,ex4(:),8,G2H1(149),m3h2x1(:,443),heltab2x2(:,:,655))
  call Hloop_UV_W(ntryL,G0H2(9),19,ex4(:),8,G1H1(158),m3h2x1(:,444),heltab2x2(:,:,656))
  call Hloop_UV_W(ntryL,G1H2(184),19,ex4(:),8,G2H1(150),m3h2x1(:,445),heltab2x2(:,:,657))
call HGT_raise_alpha_OLR(G1H2(166),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(166),2,5,2)
  call Hloop_VS_V(ntryL,G1H2(166),ex3(:),G1H2(304),m3h1x2(:,213),heltab2x2(:,:,658))
  call Hloop_UV_W(ntryL,G1H2(185),19,ex4(:),8,G2H1(151),m3h2x1(:,446),heltab2x2(:,:,659))
  call Hloop_UV_W(ntryL,G1H2(165),19,ex4(:),8,G2H1(152),m3h2x1(:,447),heltab2x2(:,:,660))
  call Hloop_AS_Q(ntryL,G1H2(171),ex3(:),G1H2(308),ngH,m3h1x2(:,214),heltab2x2(:,:,661))
  call Hloop_A_Q(ntryL,G1H2(308),23,nMB,G2H2(403),n2h2(583))
call HGT_OLR(G1H2(172),1,1,2)
call HGT_invQ_OLR(G1H2(172),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(172),-8,nMB,G2H2(404),n2h2(584))
  call Hloop_QV_A(ntryL,G2H2(404),ex4(:),G2H1(153),m3h2x1(:,448),heltab2x2(:,:,662))
  call Hloop_AS_Q(ntryL,G1H2(176),ex3(:),G1H2(269),ngH,m3h1x2(:,215),heltab2x2(:,:,663))
  call Hloop_A_Q(ntryL,G1H2(269),23,nMB,G2H2(404),n2h2(585))
  call Hloop_AS_Q(ntryL,G1H2(169),ex3(:),G1H2(309),ngH,m3h1x2(:,216),heltab2x2(:,:,664))
  call Hloop_A_Q(ntryL,G1H2(309),23,nMB,G2H2(405),n2h2(586))
  call Hloop_AS_Q(ntryL,G0H2(7),ex3(:),G0H2(12),ngH,m3h1x2(:,217),heltab2x2(:,:,665))
  call Hloop_A_Q(ntryL,G0H2(12),23,nMB,G1H2(47),n2h2(587))
  call Hloop_AS_Q(ntryL,G1H2(183),ex3(:),G1H2(318),ngH,m3h1x2(:,218),heltab2x2(:,:,666))
  call Hloop_A_Q(ntryL,G1H2(318),23,nMT,G2H2(406),n2h2(588))
call HGT_OLR(G1H2(189),1,1,2)
call HGT_invQ_OLR(G1H2(189),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(189),-8,nMT,G2H2(407),n2h2(589))
  call Hloop_QV_A(ntryL,G2H2(407),ex4(:),G2H1(154),m3h2x1(:,449),heltab2x2(:,:,667))
  call Hloop_AS_Q(ntryL,G1H2(83),ex3(:),G1H2(411),ngH,m3h1x2(:,219),heltab2x2(:,:,668))
  call Hloop_A_Q(ntryL,G1H2(411),23,nMT,G2H2(407),n2h2(590))
  call Hloop_AS_Q(ntryL,G1H2(227),ex3(:),G1H2(329),ngH,m3h1x2(:,220),heltab2x2(:,:,669))
  call Hloop_A_Q(ntryL,G1H2(329),23,nMT,G2H2(408),n2h2(591))
  call Hloop_AS_Q(ntryL,G0H2(1),ex3(:),G0H2(11),ngH,m3h1x2(:,221),heltab2x2(:,:,670))
  call Hloop_A_Q(ntryL,G0H2(11),23,nMT,G1H2(412),n2h2(592))
  call Hloop_VT_S(ntryL,G1H2(190),19,ex3(:),4,G2H2(409),m3h1x2(:,222),heltab2x2(:,:,671))
call HGT_OLR(G1H2(195),1,1,2)
call HGT_invQ_OLR(G1H2(195),2,5,2)
  call Hloop_TV_S(ntryL,G1H2(195),-8,ex4(:),8,G2H1(155),m3h2x1(:,450),heltab2x2(:,:,672))
  call Hloop_VT_S(ntryL,G1H2(38),19,ex3(:),4,G2H2(410),m3h1x2(:,223),heltab2x2(:,:,673))
  call Hloop_VT_S(ntryL,G1H2(247),19,ex3(:),4,G2H2(411),m3h1x2(:,224),heltab2x2(:,:,674))
  call Hloop_VT_S(ntryL,G0H2(5),19,ex3(:),4,G1H2(418),m3h1x2(:,225),heltab2x2(:,:,675))
  call Hloop_ST_V(ntryL,G1H2(108),19,ex3(:),4,G2H2(412),m3h1x2(:,226),heltab2x2(:,:,676))
call HGT_raise_alpha_OLR(G1H2(196),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(196),2,5,2)
  call Hloop_UV_W(ntryL,G1H2(196),-8,ex4(:),8,G2H1(156),m3h2x1(:,451),heltab2x2(:,:,677))
  call Hloop_ST_V(ntryL,G1H2(53),19,ex3(:),4,G2H2(413),m3h1x2(:,227),heltab2x2(:,:,678))
  call Hloop_ST_V(ntryL,G1H2(471),19,ex3(:),4,G2H2(414),m3h1x2(:,228),heltab2x2(:,:,679))
  call Hloop_ST_V(ntryL,G0H2(17),19,ex3(:),4,G1H2(340),m3h1x2(:,229),heltab2x2(:,:,680))
  call Hloop_AV_Q(ntryL,G1H2(373),ex4(:),G1H1(219),m3h2x1(:,452),heltab2x2(:,:,681))
  call Hloop_A_Q(ntryL,G1H1(219),27,nMB,G2H1(157),n2h1(261))
call HGT_OLR(G1H2(202),1,1,2)
call HGT_invQ_OLR(G1H2(202),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(202),-4,nMB,G2H2(415),n2h2(595))
  call Hloop_QS_A(ntryL,G2H2(415),ex3(:),G2H2(416),ngH,m3h1x2(:,230),heltab2x2(:,:,682))
  call Hloop_AV_Q(ntryL,G1H2(265),ex4(:),G1H1(224),m3h2x1(:,453),heltab2x2(:,:,683))
  call Hloop_A_Q(ntryL,G1H1(224),27,nMB,G2H1(158),n2h1(262))
  call Hloop_AV_Q(ntryL,G1H2(281),ex4(:),G1H1(179),m3h2x1(:,454),heltab2x2(:,:,684))
  call Hloop_A_Q(ntryL,G1H1(179),27,nMB,G2H1(159),n2h1(263))
  call Hloop_AV_Q(ntryL,G0H2(15),ex4(:),G0H1(1),m3h2x1(:,455),heltab2x2(:,:,685))
  call Hloop_A_Q(ntryL,G0H1(1),27,nMB,G1H1(190),n2h1(264))
  call Hloop_AV_Q(ntryL,G1H2(297),ex4(:),G1H1(201),m3h2x1(:,456),heltab2x2(:,:,686))
  call Hloop_A_Q(ntryL,G1H1(201),27,nMT,G2H1(160),n2h1(265))
call HGT_OLR(G1H2(368),1,1,2)
call HGT_invQ_OLR(G1H2(368),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(368),-4,nMT,G2H2(415),n2h2(596))
  call Hloop_QS_A(ntryL,G2H2(415),ex3(:),G2H2(417),ngH,m3h1x2(:,231),heltab2x2(:,:,687))
  call Hloop_AV_Q(ntryL,G1H2(158),ex4(:),G1H1(212),m3h2x1(:,457),heltab2x2(:,:,688))
  call Hloop_A_Q(ntryL,G1H1(212),27,nMT,G2H1(161),n2h1(266))
  call Hloop_AV_Q(ntryL,G1H2(151),ex4(:),G1H1(54),m3h2x1(:,458),heltab2x2(:,:,689))
  call Hloop_A_Q(ntryL,G1H1(54),27,nMT,G2H1(162),n2h1(267))
  call Hloop_AV_Q(ntryL,G0H2(20),ex4(:),G0H1(1),m3h2x1(:,459),heltab2x2(:,:,690))
  call Hloop_A_Q(ntryL,G0H1(1),27,nMT,G1H1(55),n2h1(268))
  call Hloop_SV_T(ntryL,G1H2(245),19,ex4(:),8,G2H1(163),m3h2x1(:,460),heltab2x2(:,:,691))
call HGT_OLR(G1H2(242),1,1,2)
call HGT_invQ_OLR(G1H2(242),2,5,2)
  call Hloop_SS_S(ntryL,G1H2(242),ex3(:),G1H2(9),m3h1x2(:,232),heltab2x2(:,:,692))
  call Hloop_SV_T(ntryL,G1H2(233),19,ex4(:),8,G2H1(164),m3h2x1(:,461),heltab2x2(:,:,693))
  call Hloop_SV_T(ntryL,G1H2(30),19,ex4(:),8,G2H1(165),m3h2x1(:,462),heltab2x2(:,:,694))
  call Hloop_SV_T(ntryL,G1H2(530),19,ex4(:),8,G2H1(166),m3h2x1(:,463),heltab2x2(:,:,695))
call HGT_raise_alpha_OLR(G1H2(466),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(466),2,5,2)
  call Hloop_VT_S(ntryL,G1H2(466),-4,ex3(:),4,G2H2(415),m3h1x2(:,233),heltab2x2(:,:,696))
  call Hloop_SV_T(ntryL,G1H2(179),19,ex4(:),8,G2H1(167),m3h2x1(:,464),heltab2x2(:,:,697))
  call Hloop_SV_T(ntryL,G1H2(194),19,ex4(:),8,G2H1(168),m3h2x1(:,465),heltab2x2(:,:,698))
  call Hloop_SV_T(ntryL,G0H2(22),19,ex4(:),8,G1H1(60),m3h2x1(:,466),heltab2x2(:,:,699))
  call Hloop_UW_V(ntryL,G1H2(186),19,ex4(:),8,G2H1(169),m3h2x1(:,467),heltab2x2(:,:,700))
call HGT_OLR(G1H2(235),1,1,2)
call HGT_invQ_OLR(G1H2(235),2,5,2)
  call Hloop_ST_V(ntryL,G1H2(235),-4,ex3(:),4,G2H2(418),m3h1x2(:,234),heltab2x2(:,:,701))
  call Hloop_UW_V(ntryL,G1H2(125),19,ex4(:),8,G2H1(170),m3h2x1(:,468),heltab2x2(:,:,702))
  call Hloop_UW_V(ntryL,G1H2(262),19,ex4(:),8,G2H1(171),m3h2x1(:,469),heltab2x2(:,:,703))
  call Hloop_UW_V(ntryL,G0H2(10),19,ex4(:),8,G1H1(61),m3h2x1(:,470),heltab2x2(:,:,704))
  call Hloop_UW_V(ntryL,G1H2(259),19,ex4(:),8,G2H1(172),m3h2x1(:,471),heltab2x2(:,:,705))
call HGT_raise_alpha_OLR(G1H2(116),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(116),2,5,2)
  call Hloop_VS_V(ntryL,G1H2(116),ex3(:),G1H2(351),m3h1x2(:,235),heltab2x2(:,:,706))
  call Hloop_UW_V(ntryL,G1H2(352),19,ex4(:),8,G2H1(173),m3h2x1(:,472),heltab2x2(:,:,707))
  call Hloop_UW_V(ntryL,G1H2(346),19,ex4(:),8,G2H1(174),m3h2x1(:,473),heltab2x2(:,:,708))
  call Hloop_QV_A(ntryL,G1H4(164),ex4(:),G1H2(10),m3h2x2(:,614),heltab2x4(:,:,783))
  call Hloop_Q_A(ntryL,G1H2(10),29,nMB,G2H2(419),n2h2(601))
call HGT_OLR(G1H4(171),1,1,4)
call HGT_invQ_OLR(G1H4(171),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(171),ex2(:),G1H2(362),ngX,m3h2x2(:,615),heltab2x4(:,:,784))
  call Hloop_QV_A(ntryL,G1H4(101),ex4(:),G1H2(11),m3h2x2(:,616),heltab2x4(:,:,785))
  call Hloop_Q_A(ntryL,G1H2(11),29,nMB,G2H2(420),n2h2(602))
  call Hloop_QV_A(ntryL,G1H4(215),ex4(:),G1H2(12),m3h2x2(:,617),heltab2x4(:,:,786))
  call Hloop_Q_A(ntryL,G1H2(12),29,nMB,G2H2(421),n2h2(603))
  call Hloop_QV_A(ntryL,G1H4(231),ex4(:),G1H2(383),m3h2x2(:,618),heltab2x4(:,:,787))
  call Hloop_Q_A(ntryL,G1H2(383),29,nMB,G2H2(422),n2h2(604))
call HGT_OLR(G1H4(145),1,1,4)
call HGT_invQ_OLR(G1H4(145),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(145),ex2(:),G1H2(416),ngH,m3h2x2(:,619),heltab2x4(:,:,788))
  call Hloop_QV_A(ntryL,G1H4(102),ex4(:),G1H2(394),m3h2x2(:,620),heltab2x4(:,:,789))
  call Hloop_Q_A(ntryL,G1H2(394),29,nMB,G2H2(423),n2h2(605))
  call Hloop_QV_A(ntryL,G1H4(149),ex4(:),G1H2(384),m3h2x2(:,621),heltab2x4(:,:,790))
  call Hloop_Q_A(ntryL,G1H2(384),29,nMB,G2H2(424),n2h2(606))
  call Hloop_QV_A(ntryL,G1H4(162),ex4(:),G1H2(225),m3h2x2(:,622),heltab2x4(:,:,791))
  call Hloop_Q_A(ntryL,G1H2(225),29,nMT,G2H2(425),n2h2(607))
call HGT_OLR(G1H4(163),1,1,4)
call HGT_invQ_OLR(G1H4(163),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(163),ex2(:),G1H2(226),ngPbt,m3h2x2(:,623),heltab2x4(:,:,792))
  call Hloop_QV_A(ntryL,G1H4(99),ex4(:),G1H2(231),m3h2x2(:,624),heltab2x4(:,:,793))
  call Hloop_Q_A(ntryL,G1H2(231),29,nMT,G2H2(426),n2h2(608))
  call Hloop_QV_A(ntryL,G1H4(208),ex4(:),G1H2(232),m3h2x2(:,625),heltab2x4(:,:,794))
  call Hloop_Q_A(ntryL,G1H2(232),29,nMT,G2H2(427),n2h2(609))
  call Hloop_QV_A(ntryL,G1H4(100),ex4(:),G1H2(385),m3h2x2(:,626),heltab2x4(:,:,795))
  call Hloop_Q_A(ntryL,G1H2(385),29,nMT,G2H2(428),n2h2(610))
call HGT_raise_alpha_OLR(G1H4(203),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(203),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(203),ex2(:),G1H2(243),m3h2x2(:,627),heltab2x4(:,:,796))
  call Hloop_QV_A(ntryL,G1H4(223),ex4(:),G1H2(379),m3h2x2(:,628),heltab2x4(:,:,797))
  call Hloop_Q_A(ntryL,G1H2(379),29,nMT,G2H2(429),n2h2(611))
  call Hloop_QV_A(ntryL,G1H4(224),ex4(:),G1H2(342),m3h2x2(:,629),heltab2x4(:,:,798))
  call Hloop_Q_A(ntryL,G1H2(342),29,nMT,G2H2(430),n2h2(612))
  call Hloop_QS_A(ntryL,G1H2(307),ex3(:),G1H2(445),ngH,m3h1x2(:,236),heltab2x2(:,:,709))
  call Hloop_Q_A(ntryL,G1H2(445),29,nMB,G2H2(431),n2h2(613))
call HGT_OLR(G1H2(310),1,1,2)
call HGT_invQ_OLR(G1H2(310),2,5,2)
  call Hloop_SA_Q(ntryL,G1H2(310),ex2(:),G1H1(228),ngX,m3h2x1(:,474),heltab2x2(:,:,710))
  call Hloop_QS_A(ntryL,G1H2(407),ex3(:),G1H2(510),ngH,m3h1x2(:,237),heltab2x2(:,:,711))
  call Hloop_Q_A(ntryL,G1H2(510),29,nMB,G2H2(432),n2h2(615))
  call Hloop_QS_A(ntryL,G1H2(13),ex3(:),G1H2(526),ngH,m3h1x2(:,238),heltab2x2(:,:,712))
  call Hloop_Q_A(ntryL,G1H2(526),29,nMB,G2H2(433),n2h2(616))
  call Hloop_QS_A(ntryL,G1H2(438),ex3(:),G1H2(157),ngH,m3h1x2(:,239),heltab2x2(:,:,713))
  call Hloop_Q_A(ntryL,G1H2(157),29,nMB,G2H2(434),n2h2(617))
call HGT_OLR(G1H2(17),1,1,2)
call HGT_invQ_OLR(G1H2(17),2,5,2)
  call Hloop_SA_Q(ntryL,G1H2(17),ex2(:),G1H1(65),ngH,m3h2x1(:,475),heltab2x2(:,:,714))
  call Hloop_QS_A(ntryL,G1H2(20),ex3(:),G1H2(77),ngH,m3h1x2(:,240),heltab2x2(:,:,715))
  call Hloop_Q_A(ntryL,G1H2(77),29,nMB,G2H2(435),n2h2(619))
  call Hloop_QS_A(ntryL,G1H2(22),ex3(:),G1H2(103),ngH,m3h1x2(:,241),heltab2x2(:,:,716))
  call Hloop_Q_A(ntryL,G1H2(103),29,nMB,G2H2(436),n2h2(620))
  call Hloop_QS_A(ntryL,G1H2(369),ex3(:),G1H2(3),ngH,m3h1x2(:,242),heltab2x2(:,:,717))
  call Hloop_Q_A(ntryL,G1H2(3),29,nMT,G2H2(437),n2h2(621))
call HGT_OLR(G1H2(364),1,1,2)
call HGT_invQ_OLR(G1H2(364),2,5,2)
  call Hloop_SA_Q(ntryL,G1H2(364),ex2(:),G1H1(229),ngPbt,m3h2x1(:,476),heltab2x2(:,:,718))
  call Hloop_QS_A(ntryL,G1H2(136),ex3(:),G1H2(460),ngH,m3h1x2(:,243),heltab2x2(:,:,719))
  call Hloop_Q_A(ntryL,G1H2(460),29,nMT,G2H2(438),n2h2(623))
  call Hloop_QS_A(ntryL,G1H2(40),ex3(:),G1H2(514),ngH,m3h1x2(:,244),heltab2x2(:,:,720))
  call Hloop_Q_A(ntryL,G1H2(514),29,nMT,G2H2(439),n2h2(624))
  call Hloop_QS_A(ntryL,G1H2(48),ex3(:),G1H2(59),ngH,m3h1x2(:,245),heltab2x2(:,:,721))
  call Hloop_Q_A(ntryL,G1H2(59),29,nMT,G2H2(440),n2h2(625))
call HGT_raise_alpha_OLR(G1H2(133),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(133),2,5,2)
  call Hloop_WA_Q(ntryL,G1H2(133),ex2(:),G1H1(66),m3h2x1(:,477),heltab2x2(:,:,722))
  call Hloop_QS_A(ntryL,G1H2(140),ex3(:),G1H2(300),ngH,m3h1x2(:,246),heltab2x2(:,:,723))
  call Hloop_Q_A(ntryL,G1H2(300),29,nMT,G2H2(441),n2h2(627))
  call Hloop_QS_A(ntryL,G1H2(94),ex3(:),G1H2(25),ngH,m3h1x2(:,247),heltab2x2(:,:,724))
  call Hloop_Q_A(ntryL,G1H2(25),29,nMT,G2H2(442),n2h2(628))
  call Hloop_QV_A(ntryL,G1H2(105),ex4(:),G1H1(234),m3h2x1(:,478),heltab2x2(:,:,725))
  call Hloop_Q_A(ntryL,G1H1(234),27,nML,G2H1(175),n2h1(269))
call HGT_OLR(G1H2(204),1,1,2)
call HGT_invQ_OLR(G1H2(204),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(204),-4,nML,G2H2(443),n2h2(629))
  call Hloop_AS_Q(ntryL,G2H2(443),ex3(:),G2H2(444),ngH,m3h1x2(:,248),heltab2x2(:,:,726))
  call Hloop_QV_A(ntryL,G1H2(161),ex4(:),G1H1(71),m3h2x1(:,479),heltab2x2(:,:,727))
  call Hloop_Q_A(ntryL,G1H1(71),27,nML,G2H1(176),n2h1(270))
  call Hloop_QV_A(ntryL,G1H2(106),ex4(:),G1H1(235),m3h2x1(:,480),heltab2x2(:,:,728))
  call Hloop_Q_A(ntryL,G1H1(235),27,nML,G2H1(177),n2h1(271))
  call Hloop_QV_A(ntryL,G0H2(8),ex4(:),G0H1(1),m3h2x1(:,481),heltab2x2(:,:,729))
  call Hloop_Q_A(ntryL,G0H1(1),27,nML,G1H1(72),n2h1(272))
  call Hloop_AV_Q(ntryL,G1H2(205),ex4(:),G1H1(76),m3h2x1(:,482),heltab2x2(:,:,730))
  call Hloop_A_Q(ntryL,G1H1(76),27,nML,G2H1(178),n2h1(273))
call HGT_OLR(G1H2(520),1,1,2)
call HGT_invQ_OLR(G1H2(520),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(520),-4,nML,G2H2(443),n2h2(630))
  call Hloop_QS_A(ntryL,G2H2(443),ex3(:),G2H2(445),ngH,m3h1x2(:,249),heltab2x2(:,:,731))
  call Hloop_AV_Q(ntryL,G1H2(127),ex4(:),G1H1(77),m3h2x1(:,483),heltab2x2(:,:,732))
  call Hloop_A_Q(ntryL,G1H1(77),27,nML,G2H1(179),n2h1(274))
  call Hloop_AV_Q(ntryL,G1H2(295),ex4(:),G1H1(120),m3h2x1(:,484),heltab2x2(:,:,733))
  call Hloop_A_Q(ntryL,G1H1(120),27,nML,G2H1(180),n2h1(275))
  call Hloop_AV_Q(ntryL,G0H2(2),ex4(:),G0H1(1),m3h2x1(:,485),heltab2x2(:,:,734))
  call Hloop_A_Q(ntryL,G0H1(1),27,nML,G1H1(82),n2h1(276))
  call Hloop_CV_D(ntryL,G1H2(504),19,ex4(:),8,G2H1(181),m3h2x1(:,486),heltab2x2(:,:,735))
call HGT_OLR(G1H2(193),1,1,2)
call HGT_invQ_OLR(G1H2(193),2,5,2)
  call Hloop_SS_S(ntryL,G1H2(193),ex3(:),G1H2(126),m3h1x2(:,250),heltab2x2(:,:,736))
  call Hloop_CV_D(ntryL,G1H2(224),19,ex4(:),8,G2H1(182),m3h2x1(:,487),heltab2x2(:,:,737))
  call Hloop_CV_D(ntryL,G1H2(521),19,ex4(:),8,G2H1(183),m3h2x1(:,488),heltab2x2(:,:,738))
  call Hloop_DV_C(ntryL,G1H2(178),19,ex4(:),G2H1(184),m3h2x1(:,489),heltab2x2(:,:,739))
call HGT_OLR(G1H2(515),1,1,2)
call HGT_invQ_OLR(G1H2(515),2,5,2)
  call Hloop_SS_S(ntryL,G1H2(515),ex3(:),G1H2(255),m3h1x2(:,251),heltab2x2(:,:,740))
  call Hloop_DV_C(ntryL,G1H2(531),19,ex4(:),G2H1(185),m3h2x1(:,490),heltab2x2(:,:,741))
  call Hloop_DV_C(ntryL,G1H2(536),19,ex4(:),G2H1(186),m3h2x1(:,491),heltab2x2(:,:,742))
  call Hloop_AS_Q(ntryL,G1H2(139),ex3(:),G1H2(256),ngH,m3h1x2(:,252),heltab2x2(:,:,743))
  call Hloop_A_Q(ntryL,G1H2(256),23,nML,G2H2(443),n2h2(633))
call HGT_OLR(G1H2(149),1,1,2)
call HGT_invQ_OLR(G1H2(149),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(149),-8,nML,G2H2(446),n2h2(634))
  call Hloop_QV_A(ntryL,G2H2(446),ex4(:),G2H1(187),m3h2x1(:,492),heltab2x2(:,:,744))
  call Hloop_AS_Q(ntryL,G1H2(24),ex3(:),G1H2(14),ngH,m3h1x2(:,253),heltab2x2(:,:,745))
  call Hloop_A_Q(ntryL,G1H2(14),23,nML,G2H2(446),n2h2(635))
  call Hloop_AS_Q(ntryL,G1H2(252),ex3(:),G1H2(261),ngH,m3h1x2(:,254),heltab2x2(:,:,746))
  call Hloop_A_Q(ntryL,G1H2(261),23,nML,G2H2(447),n2h2(636))
  call Hloop_AS_Q(ntryL,G0H2(6),ex3(:),G0H2(4),ngH,m3h1x2(:,255),heltab2x2(:,:,747))
  call Hloop_A_Q(ntryL,G0H2(4),23,nML,G1H2(16),n2h2(637))
  call Hloop_QS_A(ntryL,G1H2(203),ex3(:),G1H2(7),ngH,m3h1x2(:,256),heltab2x2(:,:,748))
  call Hloop_Q_A(ntryL,G1H2(7),23,nML,G2H2(448),n2h2(638))
call HGT_OLR(G1H2(211),1,1,2)
call HGT_invQ_OLR(G1H2(211),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(211),-8,nML,G2H2(449),n2h2(639))
  call Hloop_AV_Q(ntryL,G2H2(449),ex4(:),G2H1(188),m3h2x1(:,493),heltab2x2(:,:,749))
  call Hloop_QS_A(ntryL,G1H2(279),ex3(:),G1H2(271),ngH,m3h1x2(:,257),heltab2x2(:,:,750))
  call Hloop_Q_A(ntryL,G1H2(271),23,nML,G2H2(449),n2h2(640))
  call Hloop_QS_A(ntryL,G1H2(294),ex3(:),G1H2(492),ngH,m3h1x2(:,258),heltab2x2(:,:,751))
  call Hloop_Q_A(ntryL,G1H2(492),23,nML,G2H2(450),n2h2(641))
  call Hloop_QS_A(ntryL,G0H2(18),ex3(:),G0H2(27),ngH,m3h1x2(:,259),heltab2x2(:,:,752))
  call Hloop_Q_A(ntryL,G0H2(27),23,nML,G1H2(449),n2h2(642))
  call Hloop_QS_A(ntryL,G1H8(490),wf4(:,7),G1H2(272),ngH,m3h4x2(:,287),heltab2x8(:,:,971))
  call Hloop_Q_A(ntryL,G1H2(272),23,nML,G2H2(451),n2h2(643))
call HGT_OLR(G1H8(491),1,1,8)
call HGT_invQ_OLR(G1H8(491),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(491),-8,nML,G2H8(1),n2h8(333))
  call Hloop_AV_Q(ntryL,G2H8(1),ex4(:),G2H4(7),m3h2x4(:,477),heltab2x8(:,:,972))
  call Hloop_QS_A(ntryL,G1H8(493),wf4(:,7),G1H2(27),ngH,m3h4x2(:,288),heltab2x8(:,:,973))
  call Hloop_Q_A(ntryL,G1H2(27),23,nML,G2H2(452),n2h2(644))
  call Hloop_QS_A(ntryL,G1H8(63),wf4(:,7),G1H2(28),ngH,m3h4x2(:,289),heltab2x8(:,:,974))
  call Hloop_Q_A(ntryL,G1H2(28),23,nML,G2H2(453),n2h2(645))
  call Hloop_QS_A(ntryL,G0H8(29),wf4(:,7),G0H2(25),ngH,m3h4x2(:,290),heltab2x8(:,:,975))
  call Hloop_Q_A(ntryL,G0H2(25),23,nML,G1H2(503),n2h2(646))
  call Hloop_AS_Q(ntryL,G1H8(64),wf4(:,7),G1H2(276),ngH,m3h4x2(:,291),heltab2x8(:,:,976))
  call Hloop_A_Q(ntryL,G1H2(276),23,nML,G2H2(454),n2h2(647))
call HGT_OLR(G1H8(68),1,1,8)
call HGT_invQ_OLR(G1H8(68),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(68),-8,nML,G2H8(2),n2h8(334))
  call Hloop_QV_A(ntryL,G2H8(2),ex4(:),G2H4(5),m3h2x4(:,478),heltab2x8(:,:,977))
  call Hloop_AS_Q(ntryL,G1H8(67),wf4(:,7),G1H2(63),ngH,m3h4x2(:,292),heltab2x8(:,:,978))
  call Hloop_A_Q(ntryL,G1H2(63),23,nML,G2H2(455),n2h2(648))
  call Hloop_AS_Q(ntryL,G1H8(69),wf4(:,7),G1H2(250),ngH,m3h4x2(:,293),heltab2x8(:,:,979))
  call Hloop_A_Q(ntryL,G1H2(250),23,nML,G2H2(456),n2h2(649))
  call Hloop_AS_Q(ntryL,G0H8(69),wf4(:,7),G0H2(28),ngH,m3h4x2(:,294),heltab2x8(:,:,980))
  call Hloop_A_Q(ntryL,G0H2(28),23,nML,G1H2(277),n2h2(650))
  call Hloop_QS_A(ntryL,G1H8(70),wf4(:,7),G1H2(284),ngH,m3h4x2(:,295),heltab2x8(:,:,981))
  call Hloop_Q_A(ntryL,G1H2(284),23,nMT,G2H2(457),n2h2(651))
call HGT_OLR(G1H8(71),1,1,8)
call HGT_invQ_OLR(G1H8(71),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(71),-8,nMT,G2H8(3),n2h8(335))
  call Hloop_AV_Q(ntryL,G2H8(3),ex4(:),G2H4(54),m3h2x4(:,479),heltab2x8(:,:,982))
  call Hloop_QS_A(ntryL,G1H8(73),wf4(:,7),G1H2(39),ngH,m3h4x2(:,296),heltab2x8(:,:,983))
  call Hloop_Q_A(ntryL,G1H2(39),23,nMT,G2H2(458),n2h2(652))
  call Hloop_QS_A(ntryL,G1H8(74),wf4(:,7),G1H2(69),ngH,m3h4x2(:,297),heltab2x8(:,:,984))
  call Hloop_Q_A(ntryL,G1H2(69),23,nMT,G2H2(459),n2h2(653))
  call Hloop_QS_A(ntryL,G0H8(81),wf4(:,7),G0H2(26),ngH,m3h4x2(:,298),heltab2x8(:,:,985))
  call Hloop_Q_A(ntryL,G0H2(26),23,nMT,G1H2(313),n2h2(654))
  call Hloop_AS_Q(ntryL,G1H8(75),wf4(:,7),G1H2(212),ngH,m3h4x2(:,299),heltab2x8(:,:,986))
  call Hloop_A_Q(ntryL,G1H2(212),23,nMT,G2H2(460),n2h2(655))
call HGT_OLR(G1H8(76),1,1,8)
call HGT_invQ_OLR(G1H8(76),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(76),-8,nMT,G2H8(4),n2h8(336))
  call Hloop_QV_A(ntryL,G2H8(4),ex4(:),G2H4(42),m3h2x4(:,480),heltab2x8(:,:,987))
  call Hloop_AS_Q(ntryL,G1H8(78),wf4(:,7),G1H2(19),ngH,m3h4x2(:,300),heltab2x8(:,:,988))
  call Hloop_A_Q(ntryL,G1H2(19),23,nMT,G2H2(461),n2h2(656))
  call Hloop_AS_Q(ntryL,G1H8(79),wf4(:,7),G1H2(287),ngH,m3h4x2(:,301),heltab2x8(:,:,989))
  call Hloop_A_Q(ntryL,G1H2(287),23,nMT,G2H2(462),n2h2(657))
  call Hloop_AS_Q(ntryL,G0H8(83),wf4(:,7),G0H2(35),ngH,m3h4x2(:,302),heltab2x8(:,:,990))
  call Hloop_A_Q(ntryL,G0H2(35),23,nMT,G1H2(8),n2h2(658))
  call Hloop_QS_A(ntryL,G1H8(83),wf4(:,7),G1H2(314),ngH,m3h4x2(:,303),heltab2x8(:,:,991))
  call Hloop_Q_A(ntryL,G1H2(314),23,nMB,G2H2(463),n2h2(659))
call HGT_OLR(G1H8(81),1,1,8)
call HGT_invQ_OLR(G1H8(81),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(81),-8,nMB,G2H8(5),n2h8(337))
  call Hloop_AV_Q(ntryL,G2H8(5),ex4(:),G2H4(49),m3h2x4(:,481),heltab2x8(:,:,992))
  call Hloop_QS_A(ntryL,G1H8(84),wf4(:,7),G1H2(75),ngH,m3h4x2(:,304),heltab2x8(:,:,993))
  call Hloop_Q_A(ntryL,G1H2(75),23,nMB,G2H2(464),n2h2(660))
  call Hloop_QS_A(ntryL,G1H8(87),wf4(:,7),G1H2(320),ngH,m3h4x2(:,305),heltab2x8(:,:,994))
  call Hloop_Q_A(ntryL,G1H2(320),23,nMB,G2H2(465),n2h2(661))
  call Hloop_QS_A(ntryL,G0H8(85),wf4(:,7),G0H2(33),ngH,m3h4x2(:,306),heltab2x8(:,:,995))
  call Hloop_Q_A(ntryL,G0H2(33),23,nMB,G1H2(215),n2h2(662))
  call Hloop_AS_Q(ntryL,G1H8(88),wf4(:,7),G1H2(298),ngH,m3h4x2(:,307),heltab2x8(:,:,996))
  call Hloop_A_Q(ntryL,G1H2(298),23,nMB,G2H2(466),n2h2(663))
call HGT_OLR(G1H8(91),1,1,8)
call HGT_invQ_OLR(G1H8(91),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(91),-8,nMB,G2H8(6),n2h8(338))
  call Hloop_QV_A(ntryL,G2H8(6),ex4(:),G2H4(9),m3h2x4(:,482),heltab2x8(:,:,997))
  call Hloop_AS_Q(ntryL,G1H8(93),wf4(:,7),G1H2(45),ngH,m3h4x2(:,308),heltab2x8(:,:,998))
  call Hloop_A_Q(ntryL,G1H2(45),23,nMB,G2H2(467),n2h2(664))
  call Hloop_AS_Q(ntryL,G1H8(94),wf4(:,7),G1H2(34),ngH,m3h4x2(:,309),heltab2x8(:,:,999))
  call Hloop_A_Q(ntryL,G1H2(34),23,nMB,G2H2(468),n2h2(665))
  call Hloop_AS_Q(ntryL,G0H8(87),wf4(:,7),G0H2(36),ngH,m3h4x2(:,310),heltab2x8(:,:,1000))
  call Hloop_A_Q(ntryL,G0H2(36),23,nMB,G1H2(389),n2h2(666))
  call Hloop_QS_A(ntryL,G1H8(96),wf4(:,37),G1H2(451),ngX,m3h4x2(:,311),heltab2x8(:,:,1001))
  call Hloop_Q_A(ntryL,G1H2(451),23,nML,G2H2(469),n2h2(667))
call HGT_OLR(G1H8(98),1,1,8)
call HGT_invQ_OLR(G1H8(98),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(98),-8,nML,G2H8(8),n2h8(339))
  call Hloop_AV_Q(ntryL,G2H8(8),ex4(:),G2H4(12),m3h2x4(:,483),heltab2x8(:,:,1002))
  call Hloop_QS_A(ntryL,G1H8(101),wf4(:,37),G1H2(288),ngX,m3h4x2(:,312),heltab2x8(:,:,1003))
  call Hloop_Q_A(ntryL,G1H2(288),23,nML,G2H2(470),n2h2(668))
  call Hloop_QS_A(ntryL,G1H8(102),wf4(:,37),G1H2(440),ngX,m3h4x2(:,313),heltab2x8(:,:,1004))
  call Hloop_Q_A(ntryL,G1H2(440),23,nML,G2H2(471),n2h2(669))
  call Hloop_QS_A(ntryL,G0H8(91),wf4(:,37),G0H2(34),ngX,m3h4x2(:,314),heltab2x8(:,:,1005))
  call Hloop_Q_A(ntryL,G0H2(34),23,nML,G1H2(46),n2h2(670))
  call Hloop_AS_Q(ntryL,G1H8(103),wf4(:,37),G1H2(390),ngX,m3h4x2(:,315),heltab2x8(:,:,1006))
  call Hloop_A_Q(ntryL,G1H2(390),23,nML,G2H2(472),n2h2(671))
call HGT_OLR(G1H8(104),1,1,8)
call HGT_invQ_OLR(G1H8(104),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(104),-8,nML,G2H8(7),n2h8(340))
  call Hloop_QV_A(ntryL,G2H8(7),ex4(:),G2H4(56),m3h2x4(:,484),heltab2x8(:,:,1007))
  call Hloop_AS_Q(ntryL,G1H8(106),wf4(:,37),G1H2(51),ngX,m3h4x2(:,316),heltab2x8(:,:,1008))
  call Hloop_A_Q(ntryL,G1H2(51),23,nML,G2H2(473),n2h2(672))
  call Hloop_AS_Q(ntryL,G1H8(107),wf4(:,37),G1H2(456),ngX,m3h4x2(:,317),heltab2x8(:,:,1009))
  call Hloop_A_Q(ntryL,G1H2(456),23,nML,G2H2(474),n2h2(673))
  call Hloop_AS_Q(ntryL,G0H8(109),wf4(:,37),G0H2(19),ngX,m3h4x2(:,318),heltab2x8(:,:,1010))
  call Hloop_A_Q(ntryL,G0H2(19),23,nML,G1H2(488),n2h2(674))
  call Hloop_QS_A(ntryL,G1H8(108),wf4(:,37),G1H2(400),ngX,m3h4x2(:,319),heltab2x8(:,:,1011))
  call Hloop_Q_A(ntryL,G1H2(400),23,nMT,G2H2(475),n2h2(675))
call HGT_OLR(G1H8(110),1,1,8)
call HGT_invQ_OLR(G1H8(110),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(110),-8,nMT,G2H8(10),n2h8(341))
  call Hloop_AV_Q(ntryL,G2H8(10),ex4(:),G2H4(26),m3h2x4(:,485),heltab2x8(:,:,1012))
  call Hloop_QS_A(ntryL,G1H8(114),wf4(:,37),G1H2(483),ngX,m3h4x2(:,320),heltab2x8(:,:,1013))
  call Hloop_Q_A(ntryL,G1H2(483),23,nMT,G2H2(476),n2h2(676))
  call Hloop_QS_A(ntryL,G1H8(115),wf4(:,37),G1H2(462),ngX,m3h4x2(:,321),heltab2x8(:,:,1014))
  call Hloop_Q_A(ntryL,G1H2(462),23,nMT,G2H2(477),n2h2(677))
  call Hloop_QS_A(ntryL,G0H8(111),wf4(:,37),G0H2(24),ngX,m3h4x2(:,322),heltab2x8(:,:,1015))
  call Hloop_Q_A(ntryL,G0H2(24),23,nMT,G1H2(292),n2h2(678))
  call Hloop_AS_Q(ntryL,G1H8(116),wf4(:,37),G1H2(52),ngX,m3h4x2(:,323),heltab2x8(:,:,1016))
  call Hloop_A_Q(ntryL,G1H2(52),23,nMT,G2H2(478),n2h2(679))
call HGT_OLR(G1H8(117),1,1,8)
call HGT_invQ_OLR(G1H8(117),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(117),-8,nMT,G2H8(9),n2h8(342))
  call Hloop_QV_A(ntryL,G2H8(9),ex4(:),G2H4(53),m3h2x4(:,486),heltab2x8(:,:,1017))
  call Hloop_AS_Q(ntryL,G1H8(119),wf4(:,37),G1H2(401),ngX,m3h4x2(:,324),heltab2x8(:,:,1018))
  call Hloop_A_Q(ntryL,G1H2(401),23,nMT,G2H2(479),n2h2(680))
  call Hloop_AS_Q(ntryL,G1H8(120),wf4(:,37),G1H2(374),ngX,m3h4x2(:,325),heltab2x8(:,:,1019))
  call Hloop_A_Q(ntryL,G1H2(374),23,nMT,G2H2(480),n2h2(681))
  call Hloop_AS_Q(ntryL,G0H8(113),wf4(:,37),G0H2(16),ngX,m3h4x2(:,326),heltab2x8(:,:,1020))
  call Hloop_A_Q(ntryL,G0H2(16),23,nMT,G1H2(363),n2h2(682))
  call Hloop_QS_A(ntryL,G1H8(121),wf4(:,37),G1H2(154),ngX,m3h4x2(:,327),heltab2x8(:,:,1021))
  call Hloop_Q_A(ntryL,G1H2(154),23,nMB,G2H2(481),n2h2(683))
call HGT_OLR(G1H8(122),1,1,8)
call HGT_invQ_OLR(G1H8(122),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(122),-8,nMB,G2H8(11),n2h8(343))
  call Hloop_AV_Q(ntryL,G2H8(11),ex4(:),G2H4(32),m3h2x4(:,487),heltab2x8(:,:,1022))
  call Hloop_QS_A(ntryL,G1H8(124),wf4(:,37),G1H2(58),ngX,m3h4x2(:,328),heltab2x8(:,:,1023))
  call Hloop_Q_A(ntryL,G1H2(58),23,nMB,G2H2(482),n2h2(684))
  call Hloop_QS_A(ntryL,G1H8(125),wf4(:,37),G1H2(88),ngX,m3h4x2(:,329),heltab2x8(:,:,1024))
  call Hloop_Q_A(ntryL,G1H2(88),23,nMB,G2H2(483),n2h2(685))
  call Hloop_QS_A(ntryL,G0H8(115),wf4(:,37),G0H2(3),ngX,m3h4x2(:,330),heltab2x8(:,:,1025))
  call Hloop_Q_A(ntryL,G0H2(3),23,nMB,G1H2(70),n2h2(686))
  call Hloop_AS_Q(ntryL,G1H8(126),wf4(:,37),G1H2(76),ngX,m3h4x2(:,331),heltab2x8(:,:,1026))
  call Hloop_A_Q(ntryL,G1H2(76),23,nMB,G2H2(484),n2h2(687))
call HGT_OLR(G1H8(127),1,1,8)
call HGT_invQ_OLR(G1H8(127),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(127),-8,nMB,G2H8(12),n2h8(344))
  call Hloop_QV_A(ntryL,G2H8(12),ex4(:),G2H4(58),m3h2x4(:,488),heltab2x8(:,:,1027))
  call Hloop_AS_Q(ntryL,G1H8(129),wf4(:,37),G1H2(81),ngX,m3h4x2(:,332),heltab2x8(:,:,1028))
  call Hloop_A_Q(ntryL,G1H2(81),23,nMB,G2H2(485),n2h2(688))
  call Hloop_AS_Q(ntryL,G1H8(130),wf4(:,37),G1H2(230),ngX,m3h4x2(:,333),heltab2x8(:,:,1029))
  call Hloop_A_Q(ntryL,G1H2(230),23,nMB,G2H2(486),n2h2(689))
  call Hloop_AS_Q(ntryL,G0H8(129),wf4(:,37),G0H2(37),ngX,m3h4x2(:,334),heltab2x8(:,:,1030))
  call Hloop_A_Q(ntryL,G0H2(37),23,nMB,G1H2(168),n2h2(690))
  call Hloop_VT_S(ntryL,G1H8(133),20,wf4(:,7),3,G2H2(487),m3h4x2(:,335),heltab2x8(:,:,1031))
call HGT_OLR(G1H8(134),1,1,8)
call HGT_invQ_OLR(G1H8(134),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(134),-8,ex4(:),8,G2H4(55),m3h2x4(:,489),heltab2x8(:,:,1032))
  call Hloop_VT_S(ntryL,G1H8(138),20,wf4(:,7),3,G2H2(488),m3h4x2(:,336),heltab2x8(:,:,1033))
  call Hloop_VT_S(ntryL,G1H8(139),20,wf4(:,7),3,G2H2(489),m3h4x2(:,337),heltab2x8(:,:,1034))
  call Hloop_VT_S(ntryL,G0H8(137),20,wf4(:,7),3,G1H2(82),m3h4x2(:,338),heltab2x8(:,:,1035))
  call Hloop_VT_S(ntryL,G1H8(140),20,wf4(:,7),3,G2H2(490),m3h4x2(:,339),heltab2x8(:,:,1036))
call HGT_OLR(G1H8(141),1,1,8)
call HGT_invQ_OLR(G1H8(141),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(141),-8,ex4(:),8,G2H4(85),m3h2x4(:,490),heltab2x8(:,:,1037))
  call Hloop_VT_S(ntryL,G1H8(144),20,wf4(:,7),3,G2H2(491),m3h4x2(:,340),heltab2x8(:,:,1038))
  call Hloop_VT_S(ntryL,G1H8(146),20,wf4(:,7),3,G2H2(492),m3h4x2(:,341),heltab2x8(:,:,1039))
  call Hloop_VT_S(ntryL,G0H8(139),20,wf4(:,7),3,G1H2(87),m3h4x2(:,342),heltab2x8(:,:,1040))
  call Hloop_VT_S(ntryL,G1H8(147),20,wf4(:,37),3,G2H2(493),m3h4x2(:,343),heltab2x8(:,:,1041))
call HGT_OLR(G1H8(148),1,1,8)
call HGT_invQ_OLR(G1H8(148),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(148),-8,ex4(:),8,G2H4(46),m3h2x4(:,491),heltab2x8(:,:,1042))
  call Hloop_VT_S(ntryL,G1H8(150),20,wf4(:,37),3,G2H2(494),m3h4x2(:,344),heltab2x8(:,:,1043))
  call Hloop_VT_S(ntryL,G1H8(151),20,wf4(:,37),3,G2H2(495),m3h4x2(:,345),heltab2x8(:,:,1044))
  call Hloop_VT_S(ntryL,G0H8(141),20,wf4(:,37),3,G1H2(93),m3h4x2(:,346),heltab2x8(:,:,1045))
  call Hloop_VT_S(ntryL,G1H8(152),20,wf4(:,37),3,G2H2(496),m3h4x2(:,347),heltab2x8(:,:,1046))
call HGT_OLR(G1H8(153),1,1,8)
call HGT_invQ_OLR(G1H8(153),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(153),-8,ex4(:),8,G2H4(82),m3h2x4(:,492),heltab2x8(:,:,1047))
  call Hloop_VT_S(ntryL,G1H8(155),20,wf4(:,37),3,G2H2(497),m3h4x2(:,348),heltab2x8(:,:,1048))
  call Hloop_VT_S(ntryL,G1H8(156),20,wf4(:,37),3,G2H2(498),m3h4x2(:,349),heltab2x8(:,:,1049))
  call Hloop_VT_S(ntryL,G0H8(143),20,wf4(:,37),3,G1H2(91),m3h4x2(:,350),heltab2x8(:,:,1050))
  call Hloop_ST_V(ntryL,G1H8(157),20,wf4(:,7),3,G2H2(499),m3h4x2(:,351),heltab2x8(:,:,1051))
call HGT_raise_alpha_OLR(G1H8(158),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(158),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(158),-8,ex4(:),8,G2H4(50),m3h2x4(:,493),heltab2x8(:,:,1052))
  call Hloop_ST_V(ntryL,G1H8(160),20,wf4(:,7),3,G2H2(500),m3h4x2(:,352),heltab2x8(:,:,1053))
  call Hloop_ST_V(ntryL,G1H8(161),20,wf4(:,7),3,G2H2(501),m3h4x2(:,353),heltab2x8(:,:,1054))
  call Hloop_ST_V(ntryL,G0H8(151),20,wf4(:,7),3,G1H2(218),m3h4x2(:,354),heltab2x8(:,:,1055))
  call Hloop_ST_V(ntryL,G1H8(162),20,wf4(:,7),3,G2H2(502),m3h4x2(:,355),heltab2x8(:,:,1056))
call HGT_raise_alpha_OLR(G1H8(2),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(2),-8,ex4(:),8,G2H4(89),m3h2x4(:,494),heltab2x8(:,:,1057))
  call Hloop_ST_V(ntryL,G1H8(7),20,wf4(:,7),3,G2H2(503),m3h4x2(:,356),heltab2x8(:,:,1058))
  call Hloop_ST_V(ntryL,G1H8(12),20,wf4(:,7),3,G2H2(504),m3h4x2(:,357),heltab2x8(:,:,1059))
  call Hloop_ST_V(ntryL,G0H8(165),20,wf4(:,7),3,G1H2(21),m3h4x2(:,358),heltab2x8(:,:,1060))
  call Hloop_ST_V(ntryL,G1H8(13),20,wf4(:,37),3,G2H2(505),m3h4x2(:,359),heltab2x8(:,:,1061))
call HGT_raise_alpha_OLR(G1H8(16),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(16),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(16),-8,ex4(:),8,G2H4(84),m3h2x4(:,495),heltab2x8(:,:,1062))
  call Hloop_ST_V(ntryL,G1H8(20),20,wf4(:,37),3,G2H2(506),m3h4x2(:,360),heltab2x8(:,:,1063))
  call Hloop_ST_V(ntryL,G1H8(35),20,wf4(:,37),3,G2H2(507),m3h4x2(:,361),heltab2x8(:,:,1064))
  call Hloop_ST_V(ntryL,G0H8(167),20,wf4(:,37),3,G1H2(111),m3h4x2(:,362),heltab2x8(:,:,1065))
  call Hloop_ST_V(ntryL,G1H8(8),20,wf4(:,37),3,G2H2(508),m3h4x2(:,363),heltab2x8(:,:,1066))
call HGT_raise_alpha_OLR(G1H8(11),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(11),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(11),-8,ex4(:),8,G2H4(86),m3h2x4(:,496),heltab2x8(:,:,1067))
  call Hloop_ST_V(ntryL,G1H8(15),20,wf4(:,37),3,G2H2(509),m3h4x2(:,364),heltab2x8(:,:,1068))
  call Hloop_ST_V(ntryL,G1H8(17),20,wf4(:,37),3,G2H2(510),m3h4x2(:,365),heltab2x8(:,:,1069))
  call Hloop_ST_V(ntryL,G0H8(169),20,wf4(:,37),3,G1H2(130),m3h4x2(:,366),heltab2x8(:,:,1070))
  call Hloop_QV_A(ntryL,G1H8(18),wf4(:,38),G1H2(112),m3h4x2(:,367),heltab2x8(:,:,1071))
  call Hloop_Q_A(ntryL,G1H2(112),23,nML,G2H2(511),n2h2(691))
call HGT_OLR(G1H8(19),1,1,8)
call HGT_invQ_OLR(G1H8(19),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(19),-8,nML,G2H8(17),n2h8(353))
  call Hloop_AV_Q(ntryL,G2H8(17),ex4(:),G2H4(87),m3h2x4(:,497),heltab2x8(:,:,1072))
  call Hloop_QV_A(ntryL,G1H8(25),wf4(:,38),G1H2(505),m3h4x2(:,368),heltab2x8(:,:,1073))
  call Hloop_Q_A(ntryL,G1H2(505),23,nML,G2H2(512),n2h2(692))
  call Hloop_QV_A(ntryL,G1H8(29),wf4(:,38),G1H2(117),m3h4x2(:,369),heltab2x8(:,:,1074))
  call Hloop_Q_A(ntryL,G1H2(117),23,nML,G2H2(513),n2h2(693))
  call Hloop_QV_A(ntryL,G0H8(171),wf4(:,38),G0H2(14),m3h4x2(:,370),heltab2x8(:,:,1075))
  call Hloop_Q_A(ntryL,G0H2(14),23,nML,G1H2(509),n2h2(694))
  call Hloop_AV_Q(ntryL,G1H8(30),wf4(:,38),G1H2(124),m3h4x2(:,371),heltab2x8(:,:,1076))
  call Hloop_A_Q(ntryL,G1H2(124),23,nML,G2H2(514),n2h2(695))
call HGT_OLR(G1H8(31),1,1,8)
call HGT_invQ_OLR(G1H8(31),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(31),-8,nML,G2H8(13),n2h8(354))
  call Hloop_QV_A(ntryL,G2H8(13),ex4(:),G2H4(88),m3h2x4(:,498),heltab2x8(:,:,1077))
  call Hloop_AV_Q(ntryL,G1H8(6),wf4(:,38),G1H2(129),m3h4x2(:,372),heltab2x8(:,:,1078))
  call Hloop_A_Q(ntryL,G1H2(129),23,nML,G2H2(515),n2h2(696))
  call Hloop_AV_Q(ntryL,G1H8(33),wf4(:,38),G1H2(135),m3h4x2(:,373),heltab2x8(:,:,1079))
  call Hloop_A_Q(ntryL,G1H2(135),23,nML,G2H2(516),n2h2(697))
  call Hloop_AV_Q(ntryL,G0H8(253),wf4(:,38),G0H2(32),m3h4x2(:,374),heltab2x8(:,:,1080))
  call Hloop_A_Q(ntryL,G0H2(32),23,nML,G1H2(141),n2h2(698))
  call Hloop_QV_A(ntryL,G1H8(80),wf4(:,38),G1H2(450),m3h4x2(:,375),heltab2x8(:,:,1081))
  call Hloop_Q_A(ntryL,G1H2(450),23,nMT,G2H2(517),n2h2(699))
call HGT_OLR(G1H8(34),1,1,8)
call HGT_invQ_OLR(G1H8(34),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(34),-8,nMT,G2H8(14),n2h8(355))
  call Hloop_AV_Q(ntryL,G2H8(14),ex4(:),G2H4(106),m3h2x4(:,499),heltab2x8(:,:,1082))
  call Hloop_QV_A(ntryL,G1H8(37),wf4(:,38),G1H2(439),m3h4x2(:,376),heltab2x8(:,:,1083))
  call Hloop_Q_A(ntryL,G1H2(439),23,nMT,G2H2(518),n2h2(700))
  call Hloop_QV_A(ntryL,G1H8(39),wf4(:,38),G1H2(433),m3h4x2(:,377),heltab2x8(:,:,1084))
  call Hloop_Q_A(ntryL,G1H2(433),23,nMT,G2H2(519),n2h2(701))
  call Hloop_QV_A(ntryL,G0H8(254),wf4(:,38),G0H2(13),m3h4x2(:,378),heltab2x8(:,:,1085))
  call Hloop_Q_A(ntryL,G0H2(13),23,nMT,G1H2(142),n2h2(702))
  call Hloop_AV_Q(ntryL,G1H8(42),wf4(:,38),G1H2(487),m3h4x2(:,379),heltab2x8(:,:,1086))
  call Hloop_A_Q(ntryL,G1H2(487),23,nMT,G2H2(520),n2h2(703))
call HGT_OLR(G1H8(44),1,1,8)
call HGT_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(44),-8,nMT,G2H8(15),n2h8(356))
  call Hloop_QV_A(ntryL,G2H8(15),ex4(:),G2H4(110),m3h2x4(:,500),heltab2x8(:,:,1087))
  call Hloop_AV_Q(ntryL,G1H8(48),wf4(:,38),G1H2(482),m3h4x2(:,380),heltab2x8(:,:,1088))
  call Hloop_A_Q(ntryL,G1H2(482),23,nMT,G2H2(521),n2h2(704))
  call Hloop_AV_Q(ntryL,G1H8(49),wf4(:,38),G1H2(467),m3h4x2(:,381),heltab2x8(:,:,1089))
  call Hloop_A_Q(ntryL,G1H2(467),23,nMT,G2H2(522),n2h2(705))
  call Hloop_AV_Q(ntryL,G0H8(20),wf4(:,38),G0H2(31),m3h4x2(:,382),heltab2x8(:,:,1090))
  call Hloop_A_Q(ntryL,G0H2(31),23,nMT,G1H2(461),n2h2(706))
  call Hloop_QV_A(ntryL,G1H8(53),wf4(:,38),G1H2(153),m3h4x2(:,383),heltab2x8(:,:,1091))
  call Hloop_Q_A(ntryL,G1H2(153),23,nMB,G2H2(523),n2h2(707))
call HGT_OLR(G1H8(51),1,1,8)
call HGT_invQ_OLR(G1H8(51),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(51),-8,nMB,G2H8(16),n2h8(357))
  call Hloop_AV_Q(ntryL,G2H8(16),ex4(:),G2H4(114),m3h2x4(:,501),heltab2x8(:,:,1092))
  call Hloop_QV_A(ntryL,G1H8(55),wf4(:,38),G1H2(159),m3h4x2(:,384),heltab2x8(:,:,1093))
  call Hloop_Q_A(ntryL,G1H2(159),23,nMB,G2H2(524),n2h2(708))
  call Hloop_QV_A(ntryL,G1H8(56),wf4(:,38),G1H2(184),m3h4x2(:,385),heltab2x8(:,:,1094))
  call Hloop_Q_A(ntryL,G1H2(184),23,nMB,G2H2(525),n2h2(709))
  call Hloop_QV_A(ntryL,G0H8(21),wf4(:,38),G0H2(21),m3h4x2(:,386),heltab2x8(:,:,1095))
  call Hloop_Q_A(ntryL,G0H2(21),23,nMB,G1H2(166),n2h2(710))
  call Hloop_AV_Q(ntryL,G1H8(57),wf4(:,38),G1H2(185),m3h4x2(:,387),heltab2x8(:,:,1096))
  call Hloop_A_Q(ntryL,G1H2(185),23,nMB,G2H2(526),n2h2(711))
call HGT_OLR(G1H8(58),1,1,8)
call HGT_invQ_OLR(G1H8(58),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(58),-8,nMB,G2H8(20),n2h8(358))
  call Hloop_QV_A(ntryL,G2H8(20),ex4(:),G2H4(118),m3h2x4(:,502),heltab2x8(:,:,1097))
  call Hloop_AV_Q(ntryL,G1H8(61),wf4(:,38),G1H2(165),m3h4x2(:,388),heltab2x8(:,:,1098))
  call Hloop_A_Q(ntryL,G1H2(165),23,nMB,G2H2(527),n2h2(712))
  call Hloop_AV_Q(ntryL,G1H8(62),wf4(:,38),G1H2(171),m3h4x2(:,389),heltab2x8(:,:,1099))
  call Hloop_A_Q(ntryL,G1H2(171),23,nMB,G2H2(528),n2h2(713))
  call Hloop_AV_Q(ntryL,G0H8(22),wf4(:,38),G0H2(23),m3h4x2(:,390),heltab2x8(:,:,1100))
  call Hloop_A_Q(ntryL,G0H2(23),23,nMB,G1H2(308),n2h2(714))
  call Hloop_QZ_A(ntryL,G1H8(163),wf4(:,39),G1H2(172),ngZl,m3h4x2(:,391),heltab2x8(:,:,1101))
  call Hloop_Q_A(ntryL,G1H2(172),23,nML,G2H2(529),n2h2(715))
call HGT_OLR(G1H8(164),1,1,8)
call HGT_invQ_OLR(G1H8(164),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(164),-8,nML,G2H8(19),n2h8(359))
  call Hloop_AV_Q(ntryL,G2H8(19),ex4(:),G2H4(67),m3h2x4(:,503),heltab2x8(:,:,1102))
  call Hloop_QZ_A(ntryL,G1H8(166),wf4(:,39),G1H2(176),ngZl,m3h4x2(:,392),heltab2x8(:,:,1103))
  call Hloop_Q_A(ntryL,G1H2(176),23,nML,G2H2(530),n2h2(716))
  call Hloop_QZ_A(ntryL,G1H8(167),wf4(:,39),G1H2(269),ngZl,m3h4x2(:,393),heltab2x8(:,:,1104))
  call Hloop_Q_A(ntryL,G1H2(269),23,nML,G2H2(531),n2h2(717))
  call Hloop_QZ_A(ntryL,G0H8(23),wf4(:,39),G0H2(30),ngZl,m3h4x2(:,394),heltab2x8(:,:,1105))
  call Hloop_Q_A(ntryL,G0H2(30),23,nML,G1H2(169),n2h2(718))
  call Hloop_AZ_Q(ntryL,G1H8(168),wf4(:,39),G1H2(309),ngZl,m3h4x2(:,395),heltab2x8(:,:,1106))
  call Hloop_A_Q(ntryL,G1H2(309),23,nML,G2H2(532),n2h2(719))
call HGT_OLR(G1H8(169),1,1,8)
call HGT_invQ_OLR(G1H8(169),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(169),-8,nML,G2H8(21),n2h8(360))
  call Hloop_QV_A(ntryL,G2H8(21),ex4(:),G2H4(29),m3h2x4(:,504),heltab2x8(:,:,1107))
  call Hloop_AZ_Q(ntryL,G1H8(173),wf4(:,39),G1H2(183),ngZl,m3h4x2(:,396),heltab2x8(:,:,1108))
  call Hloop_A_Q(ntryL,G1H2(183),23,nML,G2H2(533),n2h2(720))
  call Hloop_AZ_Q(ntryL,G1H8(174),wf4(:,39),G1H2(318),ngZl,m3h4x2(:,397),heltab2x8(:,:,1109))
  call Hloop_A_Q(ntryL,G1H2(318),23,nML,G2H2(534),n2h2(721))
  call Hloop_AZ_Q(ntryL,G0H8(38),wf4(:,39),G0H2(29),ngZl,m3h4x2(:,398),heltab2x8(:,:,1110))
  call Hloop_A_Q(ntryL,G0H2(29),23,nML,G1H2(189),n2h2(722))
  call Hloop_QZ_A(ntryL,G1H8(177),wf4(:,39),G1H2(83),ngZu,m3h4x2(:,399),heltab2x8(:,:,1111))
  call Hloop_Q_A(ntryL,G1H2(83),23,nMT,G2H2(535),n2h2(723))
call HGT_OLR(G1H8(178),1,1,8)
call HGT_invQ_OLR(G1H8(178),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(178),-8,nMT,G2H8(22),n2h8(361))
  call Hloop_AV_Q(ntryL,G2H8(22),ex4(:),G2H4(121),m3h2x4(:,505),heltab2x8(:,:,1112))
  call Hloop_QZ_A(ntryL,G1H8(180),wf4(:,39),G1H2(411),ngZu,m3h4x2(:,400),heltab2x8(:,:,1113))
  call Hloop_Q_A(ntryL,G1H2(411),23,nMT,G2H2(536),n2h2(724))
  call Hloop_QZ_A(ntryL,G1H8(181),wf4(:,39),G1H2(227),ngZu,m3h4x2(:,401),heltab2x8(:,:,1114))
  call Hloop_Q_A(ntryL,G1H2(227),23,nMT,G2H2(537),n2h2(725))
  call Hloop_QZ_A(ntryL,G0H8(39),wf4(:,39),G0H2(9),ngZu,m3h4x2(:,402),heltab2x8(:,:,1115))
  call Hloop_Q_A(ntryL,G0H2(9),23,nMT,G1H2(329),n2h2(726))
  call Hloop_AZ_Q(ntryL,G1H8(182),wf4(:,39),G1H2(190),ngZu,m3h4x2(:,403),heltab2x8(:,:,1116))
  call Hloop_A_Q(ntryL,G1H2(190),23,nMT,G2H2(538),n2h2(727))
call HGT_OLR(G1H8(183),1,1,8)
call HGT_invQ_OLR(G1H8(183),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(183),-8,nMT,G2H8(18),n2h8(362))
  call Hloop_QV_A(ntryL,G2H8(18),ex4(:),G2H4(122),m3h2x4(:,506),heltab2x8(:,:,1117))
  call Hloop_AZ_Q(ntryL,G1H8(185),wf4(:,39),G1H2(195),ngZu,m3h4x2(:,404),heltab2x8(:,:,1118))
  call Hloop_A_Q(ntryL,G1H2(195),23,nMT,G2H2(539),n2h2(728))
  call Hloop_AZ_Q(ntryL,G1H8(186),wf4(:,39),G1H2(38),ngZu,m3h4x2(:,405),heltab2x8(:,:,1119))
  call Hloop_A_Q(ntryL,G1H2(38),23,nMT,G2H2(540),n2h2(729))
  call Hloop_AZ_Q(ntryL,G0H8(40),wf4(:,39),G0H2(7),ngZu,m3h4x2(:,406),heltab2x8(:,:,1120))
  call Hloop_A_Q(ntryL,G0H2(7),23,nMT,G1H2(247),n2h2(730))
  call Hloop_QZ_A(ntryL,G1H8(187),wf4(:,39),G1H2(108),ngZd,m3h4x2(:,407),heltab2x8(:,:,1121))
  call Hloop_Q_A(ntryL,G1H2(108),23,nMB,G2H2(541),n2h2(731))
call HGT_OLR(G1H8(188),1,1,8)
call HGT_invQ_OLR(G1H8(188),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(188),-8,nMB,G2H8(23),n2h8(363))
  call Hloop_AV_Q(ntryL,G2H8(23),ex4(:),G2H4(123),m3h2x4(:,507),heltab2x8(:,:,1122))
  call Hloop_QZ_A(ntryL,G1H8(190),wf4(:,39),G1H2(196),ngZd,m3h4x2(:,408),heltab2x8(:,:,1123))
  call Hloop_Q_A(ntryL,G1H2(196),23,nMB,G2H2(542),n2h2(732))
  call Hloop_QZ_A(ntryL,G1H8(192),wf4(:,39),G1H2(53),ngZd,m3h4x2(:,409),heltab2x8(:,:,1124))
  call Hloop_Q_A(ntryL,G1H2(53),23,nMB,G2H2(543),n2h2(733))
  call Hloop_QZ_A(ntryL,G0H8(41),wf4(:,39),G0H2(12),ngZd,m3h4x2(:,410),heltab2x8(:,:,1125))
  call Hloop_Q_A(ntryL,G0H2(12),23,nMB,G1H2(471),n2h2(734))
  call Hloop_AZ_Q(ntryL,G1H8(194),wf4(:,39),G1H2(373),ngZd,m3h4x2(:,411),heltab2x8(:,:,1126))
  call Hloop_A_Q(ntryL,G1H2(373),23,nMB,G2H2(544),n2h2(735))
call HGT_OLR(G1H8(196),1,1,8)
call HGT_invQ_OLR(G1H8(196),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(196),-8,nMB,G2H8(24),n2h8(364))
  call Hloop_QV_A(ntryL,G2H8(24),ex4(:),G2H4(21),m3h2x4(:,508),heltab2x8(:,:,1127))
  call Hloop_AZ_Q(ntryL,G1H8(199),wf4(:,39),G1H2(202),ngZd,m3h4x2(:,412),heltab2x8(:,:,1128))
  call Hloop_A_Q(ntryL,G1H2(202),23,nMB,G2H2(545),n2h2(736))
  call Hloop_AZ_Q(ntryL,G1H8(200),wf4(:,39),G1H2(265),ngZd,m3h4x2(:,413),heltab2x8(:,:,1129))
  call Hloop_A_Q(ntryL,G1H2(265),23,nMB,G2H2(546),n2h2(737))
  call Hloop_AZ_Q(ntryL,G0H8(42),wf4(:,39),G0H2(1),ngZd,m3h4x2(:,414),heltab2x8(:,:,1130))
  call Hloop_A_Q(ntryL,G0H2(1),23,nMB,G1H2(281),n2h2(738))
  call Hloop_TV_S(ntryL,G1H8(201),20,wf4(:,38),3,G2H2(547),m3h4x2(:,415),heltab2x8(:,:,1131))
call HGT_raise_alpha_OLR(G1H8(202),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(202),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(202),ex4(:),G1H4(39),m3h2x4(:,509),heltab2x8(:,:,1132))
  call Hloop_TV_S(ntryL,G1H8(204),20,wf4(:,38),3,G2H2(548),m3h4x2(:,416),heltab2x8(:,:,1133))
  call Hloop_TV_S(ntryL,G1H8(205),20,wf4(:,38),3,G2H2(549),m3h4x2(:,417),heltab2x8(:,:,1134))
  call Hloop_SV_T(ntryL,G1H8(206),20,wf4(:,38),3,G2H2(550),m3h4x2(:,418),heltab2x8(:,:,1135))
call HGT_raise_alpha_OLR(G1H8(207),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(207),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(207),ex4(:),G1H4(75),m3h2x4(:,510),heltab2x8(:,:,1136))
  call Hloop_SV_T(ntryL,G1H8(208),20,wf4(:,38),3,G2H2(551),m3h4x2(:,419),heltab2x8(:,:,1137))
  call Hloop_SV_T(ntryL,G1H8(27),20,wf4(:,38),3,G2H2(552),m3h4x2(:,420),heltab2x8(:,:,1138))
  call Hloop_TV_S(ntryL,G1H8(209),20,wf4(:,39),3,G2H2(553),m3h4x2(:,421),heltab2x8(:,:,1139))
call HGT_raise_alpha_OLR(G1H8(32),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(32),ex4(:),G1H4(97),m3h2x4(:,511),heltab2x8(:,:,1140))
  call Hloop_TV_S(ntryL,G1H8(1),20,wf4(:,39),3,G2H2(554),m3h4x2(:,422),heltab2x8(:,:,1141))
  call Hloop_TV_S(ntryL,G1H8(211),20,wf4(:,39),3,G2H2(555),m3h4x2(:,423),heltab2x8(:,:,1142))
  call Hloop_SV_T(ntryL,G1H8(40),20,wf4(:,39),3,G2H2(556),m3h4x2(:,424),heltab2x8(:,:,1143))
call HGT_raise_alpha_OLR(G1H8(212),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(212),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(212),ex4(:),G1H4(116),m3h2x4(:,512),heltab2x8(:,:,1144))
  call Hloop_SV_T(ntryL,G1H8(213),20,wf4(:,39),3,G2H2(557),m3h4x2(:,425),heltab2x8(:,:,1145))
  call Hloop_SV_T(ntryL,G1H8(52),20,wf4(:,39),3,G2H2(558),m3h4x2(:,426),heltab2x8(:,:,1146))
  call Hloop_UV_W(ntryL,G1H8(214),20,wf4(:,38),3,G2H2(559),m3h4x2(:,427),heltab2x8(:,:,1147))
call HGT_OLR(G1H8(59),1,1,8)
call HGT_invQ_OLR(G1H8(59),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(59),ex4(:),G1H4(7),m3h2x4(:,513),heltab2x8(:,:,1148))
  call Hloop_UV_W(ntryL,G1H8(85),20,wf4(:,38),3,G2H2(560),m3h4x2(:,428),heltab2x8(:,:,1149))
  call Hloop_UV_W(ntryL,G1H8(216),20,wf4(:,38),3,G2H2(561),m3h4x2(:,429),heltab2x8(:,:,1150))
  call Hloop_UW_V(ntryL,G1H8(86),20,wf4(:,38),3,G2H2(562),m3h4x2(:,430),heltab2x8(:,:,1151))
call HGT_OLR(G1H8(217),1,1,8)
call HGT_invQ_OLR(G1H8(217),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(217),ex4(:),G1H4(4),m3h2x4(:,514),heltab2x8(:,:,1152))
  call Hloop_UW_V(ntryL,G1H8(218),20,wf4(:,38),3,G2H2(563),m3h4x2(:,431),heltab2x8(:,:,1153))
  call Hloop_UW_V(ntryL,G1H8(90),20,wf4(:,38),3,G2H2(564),m3h4x2(:,432),heltab2x8(:,:,1154))
  call Hloop_UV_W(ntryL,G1H8(219),20,wf4(:,39),3,G2H2(565),m3h4x2(:,433),heltab2x8(:,:,1155))
call HGT_OLR(G1H8(220),1,1,8)
call HGT_invQ_OLR(G1H8(220),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(220),ex4(:),G1H4(177),m3h2x4(:,515),heltab2x8(:,:,1156))
  call Hloop_UV_W(ntryL,G1H8(224),20,wf4(:,39),3,G2H2(566),m3h4x2(:,434),heltab2x8(:,:,1157))
  call Hloop_UV_W(ntryL,G1H8(227),20,wf4(:,39),3,G2H2(567),m3h4x2(:,435),heltab2x8(:,:,1158))
  call Hloop_UW_V(ntryL,G1H8(228),20,wf4(:,39),3,G2H2(568),m3h4x2(:,436),heltab2x8(:,:,1159))
call HGT_OLR(G1H8(229),1,1,8)
call HGT_invQ_OLR(G1H8(229),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(229),ex4(:),G1H4(134),m3h2x4(:,516),heltab2x8(:,:,1160))
  call Hloop_UW_V(ntryL,G1H8(232),20,wf4(:,39),3,G2H2(569),m3h4x2(:,437),heltab2x8(:,:,1161))
  call Hloop_UW_V(ntryL,G1H8(234),20,wf4(:,39),3,G2H2(570),m3h4x2(:,438),heltab2x8(:,:,1162))
  call Hloop_AV_Q(ntryL,G1H4(37),ex4(:),G1H2(297),m3h2x2(:,630),heltab2x4(:,:,799))
  call Hloop_A_Q(ntryL,G1H2(297),26,nMB,G2H2(571),n2h2(739))
call HGT_OLR(G1H4(130),1,1,4)
call HGT_invQ_OLR(G1H4(130),2,5,4)
  call Hloop_SQ_A(ntryL,G1H4(130),wf2(:,2),G1H2(368),ngX,m3h2x2(:,631),heltab2x4(:,:,800))
  call Hloop_AV_Q(ntryL,G1H4(127),ex4(:),G1H2(158),m3h2x2(:,632),heltab2x4(:,:,801))
  call Hloop_A_Q(ntryL,G1H2(158),26,nMB,G2H2(572),n2h2(740))
  call Hloop_AV_Q(ntryL,G1H4(20),ex4(:),G1H2(151),m3h2x2(:,633),heltab2x4(:,:,802))
  call Hloop_A_Q(ntryL,G1H2(151),26,nMB,G2H2(573),n2h2(741))
  call Hloop_AV_Q(ntryL,G1H4(199),ex4(:),G1H2(245),m3h2x2(:,634),heltab2x4(:,:,803))
  call Hloop_A_Q(ntryL,G1H2(245),26,nMB,G2H2(574),n2h2(742))
call HGT_OLR(G1H4(13),1,1,4)
call HGT_invQ_OLR(G1H4(13),2,5,4)
  call Hloop_SQ_A(ntryL,G1H4(13),wf2(:,2),G1H2(242),ngH,m3h2x2(:,635),heltab2x4(:,:,804))
  call Hloop_AV_Q(ntryL,G1H4(176),ex4(:),G1H2(233),m3h2x2(:,636),heltab2x4(:,:,805))
  call Hloop_A_Q(ntryL,G1H2(233),26,nMB,G2H2(575),n2h2(743))
  call Hloop_AV_Q(ntryL,G1H4(194),ex4(:),G1H2(30),m3h2x2(:,637),heltab2x4(:,:,806))
  call Hloop_A_Q(ntryL,G1H2(30),26,nMB,G2H2(576),n2h2(744))
  call Hloop_AV_Q(ntryL,G1H4(166),ex4(:),G1H2(530),m3h2x2(:,638),heltab2x4(:,:,807))
  call Hloop_A_Q(ntryL,G1H2(530),26,nMT,G2H2(577),n2h2(745))
call HGT_OLR(G1H4(188),1,1,4)
call HGT_invQ_OLR(G1H4(188),2,5,4)
  call Hloop_SQ_A(ntryL,G1H4(188),wf2(:,2),G1H2(466),ngPtb,m3h2x2(:,639),heltab2x4(:,:,808))
  call Hloop_AV_Q(ntryL,G1H4(158),ex4(:),G1H2(179),m3h2x2(:,640),heltab2x4(:,:,809))
  call Hloop_A_Q(ntryL,G1H2(179),26,nMT,G2H2(578),n2h2(746))
  call Hloop_AV_Q(ntryL,G1H4(155),ex4(:),G1H2(194),m3h2x2(:,641),heltab2x4(:,:,810))
  call Hloop_A_Q(ntryL,G1H2(194),26,nMT,G2H2(579),n2h2(747))
  call Hloop_AV_Q(ntryL,G1H4(74),ex4(:),G1H2(186),m3h2x2(:,642),heltab2x4(:,:,811))
  call Hloop_A_Q(ntryL,G1H2(186),26,nMT,G2H2(580),n2h2(748))
call HGT_raise_alpha_OLR(G1H4(47),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(47),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(47),wf2(:,2),G1H2(235),m3h2x2(:,643),heltab2x4(:,:,812))
  call Hloop_AV_Q(ntryL,G1H4(41),ex4(:),G1H2(125),m3h2x2(:,644),heltab2x4(:,:,813))
  call Hloop_A_Q(ntryL,G1H2(125),26,nMT,G2H2(581),n2h2(749))
  call Hloop_AV_Q(ntryL,G1H4(80),ex4(:),G1H2(262),m3h2x2(:,645),heltab2x4(:,:,814))
  call Hloop_A_Q(ntryL,G1H2(262),26,nMT,G2H2(582),n2h2(750))
  call Hloop_QV_A(ntryL,G1H4(123),ex4(:),G1H2(259),m3h2x2(:,646),heltab2x4(:,:,815))
  call Hloop_Q_A(ntryL,G1H2(259),25,nMB,G2H2(583),n2h2(751))
call HGT_OLR(G1H4(124),1,1,4)
call HGT_invQ_OLR(G1H4(124),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(124),wf2(:,4),G1H2(116),ngX,m3h2x2(:,647),heltab2x4(:,:,816))
  call Hloop_QV_A(ntryL,G1H4(125),ex4(:),G1H2(352),m3h2x2(:,648),heltab2x4(:,:,817))
  call Hloop_Q_A(ntryL,G1H2(352),25,nMB,G2H2(584),n2h2(752))
  call Hloop_QV_A(ntryL,G1H4(23),ex4(:),G1H2(346),m3h2x2(:,649),heltab2x4(:,:,818))
  call Hloop_Q_A(ntryL,G1H2(346),25,nMB,G2H2(585),n2h2(753))
  call Hloop_QV_A(ntryL,G1H4(38),ex4(:),G1H2(10),m3h2x2(:,650),heltab2x4(:,:,819))
  call Hloop_Q_A(ntryL,G1H2(10),25,nMB,G2H2(586),n2h2(754))
call HGT_OLR(G1H4(233),1,1,4)
call HGT_invQ_OLR(G1H4(233),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(233),wf2(:,4),G1H2(11),ngH,m3h2x2(:,651),heltab2x4(:,:,820))
  call Hloop_QV_A(ntryL,G1H4(234),ex4(:),G1H2(12),m3h2x2(:,652),heltab2x4(:,:,821))
  call Hloop_Q_A(ntryL,G1H2(12),25,nMB,G2H2(587),n2h2(755))
  call Hloop_QV_A(ntryL,G1H4(175),ex4(:),G1H2(383),m3h2x2(:,653),heltab2x4(:,:,822))
  call Hloop_Q_A(ntryL,G1H2(383),25,nMB,G2H2(588),n2h2(756))
  call Hloop_QV_A(ntryL,G1H4(10),ex4(:),G1H2(394),m3h2x2(:,654),heltab2x4(:,:,823))
  call Hloop_Q_A(ntryL,G1H2(394),25,nMT,G2H2(589),n2h2(757))
call HGT_OLR(G1H4(113),1,1,4)
call HGT_invQ_OLR(G1H4(113),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(113),wf2(:,4),G1H2(384),ngPbt,m3h2x2(:,655),heltab2x4(:,:,824))
  call Hloop_QV_A(ntryL,G1H4(179),ex4(:),G1H2(225),m3h2x2(:,656),heltab2x4(:,:,825))
  call Hloop_Q_A(ntryL,G1H2(225),25,nMT,G2H2(590),n2h2(758))
  call Hloop_QV_A(ntryL,G1H4(3),ex4(:),G1H2(231),m3h2x2(:,657),heltab2x4(:,:,826))
  call Hloop_Q_A(ntryL,G1H2(231),25,nMT,G2H2(591),n2h2(759))
  call Hloop_QV_A(ntryL,G1H4(180),ex4(:),G1H2(232),m3h2x2(:,658),heltab2x4(:,:,827))
  call Hloop_Q_A(ntryL,G1H2(232),25,nMT,G2H2(592),n2h2(760))
call HGT_raise_alpha_OLR(G1H4(5),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(5),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(5),wf2(:,4),G1H2(385),m3h2x2(:,659),heltab2x4(:,:,828))
  call Hloop_QV_A(ntryL,G1H4(195),ex4(:),G1H2(379),m3h2x2(:,660),heltab2x4(:,:,829))
  call Hloop_Q_A(ntryL,G1H2(379),25,nMT,G2H2(593),n2h2(761))
  call Hloop_QV_A(ntryL,G1H4(235),ex4(:),G1H2(342),m3h2x2(:,661),heltab2x4(:,:,830))
  call Hloop_Q_A(ntryL,G1H2(342),25,nMT,G2H2(594),n2h2(762))
  call Hloop_AS_Q(ntryL,G1H4(212),ex3(:),G1H4(200),ngH,m3h1x4(:,140),heltab2x4(:,:,831))
  call Hloop_A_Q(ntryL,G1H4(200),22,nMB,G2H4(22),n2h4(495))
call HGT_OLR(G1H4(240),1,1,4)
call HGT_invQ_OLR(G1H4(240),2,5,4)
  call Hloop_SQ_A(ntryL,G1H4(240),wf4(:,5),G1H1(121),ngX,m3h4x1(:,31),heltab2x4(:,:,832))
  call Hloop_AS_Q(ntryL,G1H4(236),ex3(:),G1H4(79),ngH,m3h1x4(:,141),heltab2x4(:,:,833))
  call Hloop_A_Q(ntryL,G1H4(79),22,nMB,G2H4(19),n2h4(497))
  call Hloop_AS_Q(ntryL,G1H4(229),ex3(:),G1H4(32),ngH,m3h1x4(:,142),heltab2x4(:,:,834))
  call Hloop_A_Q(ntryL,G1H4(32),22,nMB,G2H4(24),n2h4(498))
  call Hloop_AS_Q(ntryL,G1H4(241),ex3(:),G1H4(202),ngH,m3h1x4(:,143),heltab2x4(:,:,835))
  call Hloop_A_Q(ntryL,G1H4(202),22,nMB,G2H4(64),n2h4(499))
call HGT_OLR(G1H4(82),1,1,4)
call HGT_invQ_OLR(G1H4(82),2,5,4)
  call Hloop_SQ_A(ntryL,G1H4(82),wf4(:,5),G1H1(83),ngH,m3h4x1(:,32),heltab2x4(:,:,836))
  call Hloop_AS_Q(ntryL,G1H4(68),ex3(:),G1H4(88),ngH,m3h1x4(:,144),heltab2x4(:,:,837))
  call Hloop_A_Q(ntryL,G1H4(88),22,nMB,G2H4(74),n2h4(501))
  call Hloop_AS_Q(ntryL,G1H4(25),ex3(:),G1H4(73),ngH,m3h1x4(:,145),heltab2x4(:,:,838))
  call Hloop_A_Q(ntryL,G1H4(73),22,nMB,G2H4(65),n2h4(502))
  call Hloop_AS_Q(ntryL,G1H4(98),ex3(:),G1H4(77),ngH,m3h1x4(:,146),heltab2x4(:,:,839))
  call Hloop_A_Q(ntryL,G1H4(77),22,nMT,G2H4(63),n2h4(503))
call HGT_OLR(G1H4(142),1,1,4)
call HGT_invQ_OLR(G1H4(142),2,5,4)
  call Hloop_SQ_A(ntryL,G1H4(142),wf4(:,5),G1H1(126),ngPtb,m3h4x1(:,33),heltab2x4(:,:,840))
  call Hloop_AS_Q(ntryL,G1H4(94),ex3(:),G1H4(205),ngH,m3h1x4(:,147),heltab2x4(:,:,841))
  call Hloop_A_Q(ntryL,G1H4(205),22,nMT,G2H4(8),n2h4(505))
  call Hloop_AS_Q(ntryL,G1H4(92),ex3(:),G1H4(210),ngH,m3h1x4(:,148),heltab2x4(:,:,842))
  call Hloop_A_Q(ntryL,G1H4(210),22,nMT,G2H4(72),n2h4(506))
  call Hloop_AS_Q(ntryL,G1H4(178),ex3(:),G1H4(90),ngH,m3h1x4(:,149),heltab2x4(:,:,843))
  call Hloop_A_Q(ntryL,G1H4(90),22,nMT,G2H4(73),n2h4(507))
call HGT_raise_alpha_OLR(G1H4(184),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(184),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(184),wf4(:,5),G1H1(87),m3h4x1(:,34),heltab2x4(:,:,844))
  call Hloop_AS_Q(ntryL,G1H4(191),ex3(:),G1H4(137),ngH,m3h1x4(:,150),heltab2x4(:,:,845))
  call Hloop_A_Q(ntryL,G1H4(137),22,nMT,G2H4(3),n2h4(509))
  call Hloop_AS_Q(ntryL,G1H4(192),ex3(:),G1H4(133),ngH,m3h1x4(:,151),heltab2x4(:,:,846))
  call Hloop_A_Q(ntryL,G1H4(133),22,nMT,G2H4(10),n2h4(510))
  call Hloop_SA_Q(ntryL,G1H8(235),ex2(:),G1H4(144),ngPbt,m3h2x4(:,517),heltab2x8(:,:,1163))
  call Hloop_A_Q(ntryL,G1H4(144),22,nMT,G2H4(11),n2h4(511))
call HGT_raise_alpha_OLR(G1H8(236),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(236),2,5,8)
  call Hloop_WQ_A(ntryL,G1H8(236),wf4(:,5),G1H2(307),m3h4x2(:,439),heltab2x8(:,:,1164))
  call Hloop_SA_Q(ntryL,G1H8(238),ex2(:),G1H4(141),ngPbt,m3h2x4(:,518),heltab2x8(:,:,1165))
  call Hloop_A_Q(ntryL,G1H4(141),22,nMT,G2H4(13),n2h4(512))
  call Hloop_SA_Q(ntryL,G1H8(240),ex2(:),G1H4(104),ngPbt,m3h2x4(:,519),heltab2x8(:,:,1166))
  call Hloop_A_Q(ntryL,G1H4(104),22,nMT,G2H4(16),n2h4(513))
  call Hloop_ZA_Q(ntryL,G1H8(242),ex2(:),G1H4(109),ngZd,m3h2x4(:,520),heltab2x8(:,:,1167))
  call Hloop_A_Q(ntryL,G1H4(109),22,nMB,G2H4(14),n2h4(514))
call HGT_OLR(G1H8(243),1,1,8)
call HGT_invQ_OLR(G1H8(243),2,5,8)
  call Hloop_SQ_A(ntryL,G1H8(243),wf4(:,5),G1H2(445),ngH,m3h4x2(:,440),heltab2x8(:,:,1168))
  call Hloop_ZA_Q(ntryL,G1H8(245),ex2(:),G1H4(182),ngZd,m3h2x4(:,521),heltab2x8(:,:,1169))
  call Hloop_A_Q(ntryL,G1H4(182),22,nMB,G2H4(15),n2h4(515))
  call Hloop_ZA_Q(ntryL,G1H8(246),ex2(:),G1H4(112),ngZd,m3h2x4(:,522),heltab2x8(:,:,1170))
  call Hloop_A_Q(ntryL,G1H4(112),22,nMB,G2H4(18),n2h4(516))
  call Hloop_WA_Q(ntryL,G1H8(248),ex2(:),G1H4(147),m3h2x4(:,523),heltab2x8(:,:,1171))
  call Hloop_A_Q(ntryL,G1H4(147),22,nMT,G2H4(17),n2h4(517))
call HGT_OLR(G1H8(250),1,1,8)
call HGT_invQ_OLR(G1H8(250),2,5,8)
  call Hloop_SQ_A(ntryL,G1H8(250),wf4(:,5),G1H2(310),ngPtb,m3h4x2(:,441),heltab2x8(:,:,1172))
  call Hloop_WA_Q(ntryL,G1H8(10),ex2(:),G1H4(103),m3h2x4(:,524),heltab2x8(:,:,1173))
  call Hloop_A_Q(ntryL,G1H4(103),22,nMT,G2H4(38),n2h4(518))
  call Hloop_WA_Q(ntryL,G1H8(252),ex2(:),G1H4(148),m3h2x4(:,525),heltab2x8(:,:,1174))
  call Hloop_A_Q(ntryL,G1H4(148),22,nMT,G2H4(34),n2h4(519))
  call Hloop_QS_A(ntryL,G1H4(211),ex3(:),G1H4(201),ngH,m3h1x4(:,152),heltab2x4(:,:,847))
  call Hloop_Q_A(ntryL,G1H4(201),21,nMB,G2H4(41),n2h4(520))
call HGT_OLR(G1H4(221),1,1,4)
call HGT_invQ_OLR(G1H4(221),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(221),wf4(:,2),G1H1(127),ngX,m3h4x1(:,35),heltab2x4(:,:,848))
  call Hloop_QS_A(ntryL,G1H4(226),ex3(:),G1H4(169),ngH,m3h1x4(:,153),heltab2x4(:,:,849))
  call Hloop_Q_A(ntryL,G1H4(169),21,nMB,G2H4(39),n2h4(522))
  call Hloop_QS_A(ntryL,G1H4(227),ex3(:),G1H4(114),ngH,m3h1x4(:,154),heltab2x4(:,:,850))
  call Hloop_Q_A(ntryL,G1H4(114),21,nMB,G2H4(43),n2h4(523))
  call Hloop_QS_A(ntryL,G1H4(237),ex3(:),G1H4(187),ngH,m3h1x4(:,155),heltab2x4(:,:,851))
  call Hloop_Q_A(ntryL,G1H4(187),21,nMB,G2H4(47),n2h4(524))
call HGT_OLR(G1H4(238),1,1,4)
call HGT_invQ_OLR(G1H4(238),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(238),wf4(:,2),G1H1(88),ngH,m3h4x1(:,36),heltab2x4(:,:,852))
  call Hloop_QS_A(ntryL,G1H4(243),ex3(:),G1H4(189),ngH,m3h1x4(:,156),heltab2x4(:,:,853))
  call Hloop_Q_A(ntryL,G1H4(189),21,nMB,G2H4(48),n2h4(526))
  call Hloop_QS_A(ntryL,G1H4(150),ex3(:),G1H4(33),ngH,m3h1x4(:,157),heltab2x4(:,:,854))
  call Hloop_Q_A(ntryL,G1H4(33),21,nMB,G2H4(52),n2h4(527))
  call Hloop_QS_A(ntryL,G1H4(152),ex3(:),G1H4(143),ngH,m3h1x4(:,158),heltab2x4(:,:,855))
  call Hloop_Q_A(ntryL,G1H4(143),21,nMT,G2H4(60),n2h4(528))
call HGT_OLR(G1H4(159),1,1,4)
call HGT_invQ_OLR(G1H4(159),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(159),wf4(:,2),G1H1(239),ngPbt,m3h4x1(:,37),heltab2x4(:,:,856))
  call Hloop_QS_A(ntryL,G1H4(167),ex3(:),G1H4(230),ngH,m3h1x4(:,159),heltab2x4(:,:,857))
  call Hloop_Q_A(ntryL,G1H4(230),21,nMT,G2H4(61),n2h4(530))
  call Hloop_QS_A(ntryL,G1H4(168),ex3(:),G1H4(83),ngH,m3h1x4(:,160),heltab2x4(:,:,858))
  call Hloop_Q_A(ntryL,G1H4(83),21,nMT,G2H4(62),n2h4(531))
  call Hloop_QS_A(ntryL,G1H4(21),ex3(:),G1H4(69),ngH,m3h1x4(:,161),heltab2x4(:,:,859))
  call Hloop_Q_A(ntryL,G1H4(69),21,nMT,G2H4(76),n2h4(532))
call HGT_raise_alpha_OLR(G1H4(56),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(56),wf4(:,2),G1H1(131),m3h4x1(:,38),heltab2x4(:,:,860))
  call Hloop_QS_A(ntryL,G1H4(214),ex3(:),G1H4(86),ngH,m3h1x4(:,162),heltab2x4(:,:,861))
  call Hloop_Q_A(ntryL,G1H4(86),21,nMT,G2H4(77),n2h4(534))
  call Hloop_QS_A(ntryL,G1H4(219),ex3(:),G1H4(204),ngH,m3h1x4(:,163),heltab2x4(:,:,862))
  call Hloop_Q_A(ntryL,G1H4(204),21,nMT,G2H4(78),n2h4(535))
  call Hloop_SQ_A(ntryL,G1H8(41),ex1(:),G1H4(207),ngPtb,m3h2x4(:,526),heltab2x8(:,:,1175))
  call Hloop_Q_A(ntryL,G1H4(207),21,nMT,G2H4(80),n2h4(536))
call HGT_raise_alpha_OLR(G1H8(253),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(253),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(253),wf4(:,2),G1H2(407),m3h4x2(:,442),heltab2x8(:,:,1176))
  call Hloop_SQ_A(ntryL,G1H8(254),ex1(:),G1H4(209),ngPtb,m3h2x4(:,527),heltab2x8(:,:,1177))
  call Hloop_Q_A(ntryL,G1H4(209),21,nMT,G2H4(81),n2h4(537))
  call Hloop_SQ_A(ntryL,G1H8(45),ex1(:),G1H4(239),ngPtb,m3h2x4(:,528),heltab2x8(:,:,1178))
  call Hloop_Q_A(ntryL,G1H4(239),21,nMT,G2H4(91),n2h4(538))
  call Hloop_ZQ_A(ntryL,G1H8(255),ex1(:),G1H4(64),ngZd,m3h2x4(:,529),heltab2x8(:,:,1179))
  call Hloop_Q_A(ntryL,G1H4(64),21,nMB,G2H4(92),n2h4(539))
call HGT_OLR(G1H8(171),1,1,8)
call HGT_invQ_OLR(G1H8(171),2,5,8)
  call Hloop_SA_Q(ntryL,G1H8(171),wf4(:,2),G1H2(510),ngH,m3h4x2(:,443),heltab2x8(:,:,1180))
  call Hloop_ZQ_A(ntryL,G1H8(172),ex1(:),G1H4(45),ngZd,m3h2x4(:,530),heltab2x8(:,:,1181))
  call Hloop_Q_A(ntryL,G1H4(45),21,nMB,G2H4(93),n2h4(540))
  call Hloop_ZQ_A(ntryL,G1H8(257),ex1(:),G1H4(129),ngZd,m3h2x4(:,531),heltab2x8(:,:,1182))
  call Hloop_Q_A(ntryL,G1H4(129),21,nMB,G2H4(95),n2h4(541))
  call Hloop_WQ_A(ntryL,G1H8(175),ex1(:),G1H4(132),m3h2x4(:,532),heltab2x8(:,:,1183))
  call Hloop_Q_A(ntryL,G1H4(132),21,nMT,G2H4(96),n2h4(542))
call HGT_OLR(G1H8(258),1,1,8)
call HGT_invQ_OLR(G1H8(258),2,5,8)
  call Hloop_SA_Q(ntryL,G1H8(258),wf4(:,2),G1H2(13),ngPbt,m3h4x2(:,444),heltab2x8(:,:,1184))
  call Hloop_WQ_A(ntryL,G1H8(259),ex1(:),G1H4(30),m3h2x4(:,533),heltab2x8(:,:,1185))
  call Hloop_Q_A(ntryL,G1H4(30),21,nMT,G2H4(97),n2h4(543))
  call Hloop_WQ_A(ntryL,G1H8(191),ex1(:),G1H4(31),m3h2x4(:,534),heltab2x8(:,:,1186))
  call Hloop_Q_A(ntryL,G1H4(31),21,nMT,G2H4(99),n2h4(544))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(556),[G2H2(553),G2H2(550),G2H2(547),G2H2(45),G2H2(44) &
    ,G2H2(30),G2H2(27),G2H2(21),G1H2(331),G1H2(336)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(496),[G2H2(490),G2H2(56),G2H2(42),G2H2(10),G2H2(8) &
    ,G2H2(19),G1H2(353),G1H2(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(508),[G2H2(502),G2H2(168),G2H2(184),G2H2(246),G2H2(72) &
    ,G2H2(23),G1H2(214),G1H2(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(568),[G2H2(565),G2H2(562),G2H2(559),G2H2(31),G2H2(144) &
    ,G2H2(140),G2H2(33),G2H2(25),G1H2(330),G1H2(335)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(493),[G2H2(487),G2H2(17),G2H2(40),G2H2(9),G2H2(5) &
    ,G2H2(29),G1H2(324),G1H2(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(505),[G2H2(499),G2H2(166),G2H2(63),G2H2(243),G2H2(68) &
    ,G2H2(35),G1H2(213),G1H2(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(125),[G2H2(124),G2H2(38),G1H2(74),G1H2(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(292),[G2H2(132),G2H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(291),[G2H2(120),G2H2(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(293),[G2H2(128),G2H2(47),G1H2(101),G1H2(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(73),[G2H1(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(75),[G2H1(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(78),[G2H1(71),G2H1(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(96),[G2H1(77),G2H1(23),G1H1(58),G1H1(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(93),[G2H1(26),G1H1(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(94),[G2H1(80),G2H1(29),G1H1(80),G1H1(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(97),[G2H1(83),G2H1(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(300),[G2H2(179),G2H2(52),G1H2(253),G1H2(192)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(305),[G2H2(185),G2H2(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(304),[G2H2(176),G2H2(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(306),[G2H2(182),G2H2(61),G1H2(120),G1H2(200)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(105),[G2H1(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(108),[G2H1(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(111),[G2H1(101),G2H1(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(129),[G2H1(107),G2H1(44),G1H1(91),G1H1(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(124),[G2H1(47),G1H1(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(126),[G2H1(110),G2H1(50),G1H1(113),G1H1(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(130),[G2H1(113),G2H1(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(544),[G2H2(526),G2H2(484),G2H2(466),G2H2(87),G2H2(82) &
    ,G2H2(69),G2H2(65),G1H2(317),G1H2(291),G1H2(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(538),[G2H2(520),G2H2(478),G2H2(460),G2H2(92),G2H2(76) &
    ,G1H2(305)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(208),[G2H2(98),G1H2(328),G1H2(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(289),[G2H2(223),G2H2(203),G2H2(195),G2H2(105),G1H2(480) &
    ,G1H2(339)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(290),[G2H2(226),G2H2(207),G2H2(199),G2H2(110),G1H2(491) &
    ,G1H2(350)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(133),[G2H2(116),G1H2(361)])
call ol_merge_last(G2H1(60), G2H1(60)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(60),[G1H1(1)])
call HGT_lower_alpha_w2_OLR(G2H1(60),1,1,1)
call HGT_lower_alpha_w2_invQ_OLR(G2H1(60),2,5,1)
call HGT_lower_alpha_w2_OLR(G2H1(60),6,15,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(60),[G1H1(165)])
call ol_merge_last(G1H1(2), G1H1(2)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(59),[G1H1(2)])
call HGT_OLR(G2H1(59),1,1,1)
call HGT_invQ_OLR(G2H1(59),2,5,1)
call HGT_OLR(G2H1(59),6,15,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(59),[G1H1(244)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(541),[G2H2(523),G2H2(481),G2H2(463),G2H2(151),G2H2(147) &
    ,G2H2(142),G2H2(137),G1H2(415),G1H2(393),G1H2(382)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(535),[G2H2(517),G2H2(475),G2H2(457),G2H2(155),G2H2(104) &
    ,G1H2(404)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(215),[G1H2(380)])
call HGT_OLR(G2H2(158),1,1,2)
call HGT_invQ_OLR(G2H2(158),2,5,2)
call HGT_OLR(G2H2(158),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(158),[G2H2(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(67),[G2H1(62),G1H1(124)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(90),[G2H2(28),G1H2(391)])
call HGT_OLR(G2H2(159),1,1,2)
call HGT_invQ_OLR(G2H2(159),2,5,2)
call HGT_OLR(G2H2(159),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(159),[G2H2(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(84),[G2H1(69),G2H1(65),G1H1(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(95),[G2H2(1),G1H2(402)])
call HGT_OLR(G2H2(160),1,1,2)
call HGT_invQ_OLR(G2H2(160),2,5,2)
call HGT_OLR(G2H2(160),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(160),[G2H2(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(91),[G2H1(72),G2H1(119),G2H1(116),G2H1(68),G1H1(232) &
    ,G1H1(146)])
call ol_merge_last(G2H2(157), G2H2(157)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(157),[G1H2(267)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(171),[G1H2(170)])
call HGT_OLR(G2H2(157),1,1,2)
call HGT_invQ_OLR(G2H2(157),2,5,2)
call HGT_OLR(G2H2(157),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(157),[G2H2(171)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(163),[G1H2(413)])
call HGT_OLR(G2H2(161),1,1,2)
call HGT_invQ_OLR(G2H2(161),2,5,2)
call HGT_OLR(G2H2(161),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(161),[G2H2(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(81),[G2H1(74),G1H1(157)])
call ol_merge_last(G1H2(32), G1H2(32)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(162),[G1H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(237),[G1H2(180)])
call HGT_lower_alpha_w2_OLR(G2H2(162),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(162),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(162),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(162),[G2H2(237)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(297),[G2H2(164),G1H2(426),G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(302),[G2H2(298),G2H2(221),G2H2(213),G2H2(167),G1H2(502) &
    ,G1H2(437)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(303),[G2H2(299),G2H2(225),G2H2(217),G2H2(170),G1H2(513) &
    ,G1H2(448)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(301),[G2H2(173),G1H2(459)])
call ol_merge_last(G2H1(90), G2H1(90)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(90),[G1H1(3)])
call HGT_lower_alpha_w2_OLR(G2H1(90),1,1,1)
call HGT_lower_alpha_w2_invQ_OLR(G2H1(90),2,5,1)
call HGT_lower_alpha_w2_OLR(G2H1(90),6,15,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(90),[G1H1(169)])
call ol_merge_last(G1H1(4), G1H1(4)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(89),[G1H1(4)])
call HGT_OLR(G2H1(89),1,1,1)
call HGT_invQ_OLR(G2H1(89),2,5,1)
call HGT_OLR(G2H1(89),6,15,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(89),[G1H1(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(106),[G1H2(275)])
call HGT_OLR(G2H2(188),1,1,2)
call HGT_invQ_OLR(G2H2(188),2,5,2)
call HGT_OLR(G2H2(188),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(188),[G2H2(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(99),[G2H1(92),G1H1(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(112),[G2H2(148),G1H2(289)])
call HGT_OLR(G2H2(189),1,1,2)
call HGT_invQ_OLR(G2H2(189),2,5,2)
call HGT_OLR(G2H2(189),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(189),[G2H2(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(118),[G2H1(102),G2H1(95),G1H1(189)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(245),[G2H2(88),G1H2(131)])
call HGT_OLR(G2H2(190),1,1,2)
call HGT_invQ_OLR(G2H2(190),2,5,2)
call HGT_OLR(G2H2(190),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(190),[G2H2(245)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(120),[G2H1(103),G2H1(125),G2H1(122),G2H1(98),G1H1(243) &
    ,G1H1(200)])
call ol_merge_last(G2H2(187), G2H2(187)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(187),[G1H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(135),[G1H2(134)])
call HGT_OLR(G2H2(187),1,1,2)
call HGT_invQ_OLR(G2H2(187),2,5,2)
call HGT_OLR(G2H2(187),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(187),[G2H2(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(231),[G1H2(315)])
call HGT_OLR(G2H2(191),1,1,2)
call HGT_invQ_OLR(G2H2(191),2,5,2)
call HGT_OLR(G2H2(191),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(191),[G2H2(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(114),[G2H1(104),G1H1(211)])
call ol_merge_last(G1H2(50), G1H2(50)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(192),[G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(139),[G1H2(144)])
call HGT_lower_alpha_w2_OLR(G2H2(192),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(192),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(192),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(192),[G2H2(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G1H2(494),G1H2(152)])
call HGT_OLR(G2H2(228),1,1,2)
call HGT_invQ_OLR(G2H2(228),2,5,2)
call HGT_OLR(G2H2(228),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(228),[G2H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(244),[G2H2(229),G1H2(100),G1H2(29),G1H2(210)])
call ol_merge_last(G1H2(62), G1H2(62)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(73),[G1H2(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(284),[G1H2(326)])
call HGT_OLR(G1H2(73),1,1,2)
call HGT_invQ_OLR(G1H2(73),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(284),[G1H2(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(241),[G2H2(232)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(197),[G1H2(476),G1H2(162)])
call HGT_lower_alpha_w2_OLR(G2H2(235),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(235),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(235),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(235),[G2H2(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(247),[G2H2(236),G1H2(107),G1H2(65),G1H2(299)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(307),[G1H2(306)])
call HGT_OLR(G2H2(239),1,1,2)
call HGT_invQ_OLR(G2H2(239),2,5,2)
call HGT_OLR(G2H2(239),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(239),[G2H2(307)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(308),[G1H2(128)])
call HGT_OLR(G2H2(240),1,1,2)
call HGT_invQ_OLR(G2H2(240),2,5,2)
call HGT_OLR(G2H2(240),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(240),[G2H2(308)])
call ol_merge_last(G1H1(5), G1H1(5)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(6),[G1H1(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(82),[G1H1(122)])
call HGT_OLR(G1H1(6),1,1,1)
call HGT_invQ_OLR(G1H1(6),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(82),[G1H1(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(9),[G1H1(185),G1H1(20)])
call HGT_OLR(G2H1(127),1,1,1)
call HGT_invQ_OLR(G2H1(127),2,5,1)
call HGT_OLR(G2H1(127),6,15,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(127),[G2H1(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(106),[G1H1(81),G1H1(26)])
call HGT_lower_alpha_w2_OLR(G2H1(128),1,1,1)
call HGT_lower_alpha_w2_invQ_OLR(G2H1(128),2,5,1)
call HGT_lower_alpha_w2_OLR(G2H1(128),6,15,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(128),[G2H1(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(270),[G2H2(250)])
call HGT_OLR(G1H2(78),1,1,2)
call HGT_invQ_OLR(G1H2(78),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(78),[G1H2(332)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(273),[G2H2(272),G2H2(253),G2H2(252)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(286),[G1H2(337)])
call HGT_OLR(G1H2(85),1,1,2)
call HGT_invQ_OLR(G1H2(85),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(286),[G1H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(275),[G2H2(255)])
call HGT_OLR(G1H2(90),1,1,2)
call HGT_invQ_OLR(G1H2(90),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(90),[G1H2(343)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(278),[G2H2(277),G2H2(258),G2H2(257)])
call ol_merge_last(G1H2(109), G1H2(109)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(109),[G1H2(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(165),[G1H2(348)])
call HGT_OLR(G1H2(109),1,1,2)
call HGT_invQ_OLR(G1H2(109),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(165),[G1H2(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(280),[G2H2(260)])
call ol_merge_last(G1H2(113), G1H2(113)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(113),[G1H2(102)])
call HGT_OLR(G1H2(113),1,1,2)
call HGT_invQ_OLR(G1H2(113),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(113),[G1H2(354)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(283),[G2H2(282),G2H2(263),G2H2(262)])
call ol_merge_last(G1H2(114), G1H2(114)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(114),[G1H2(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(285),[G2H2(265)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(288),[G2H2(287),G2H2(268),G2H2(267)])
call HGT_OLR(G1H1(7),1,1,1)
call HGT_invQ_OLR(G1H1(7),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(7),[G1H1(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(76),[G1H1(133)])
call HGT_OLR(G1H1(9),1,1,1)
call HGT_invQ_OLR(G1H1(9),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(76),[G1H1(9)])
call HGT_OLR(G1H1(10),1,1,1)
call HGT_invQ_OLR(G1H1(10),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(10),[G1H1(139)])
call ol_merge_last(G1H1(15), G1H1(15)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(15),[G1H1(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(109),[G1H1(144)])
call HGT_OLR(G1H1(15),1,1,1)
call HGT_invQ_OLR(G1H1(15),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(109),[G1H1(15)])
call ol_merge_last(G1H1(16), G1H1(16)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(16),[G1H1(13)])
call HGT_OLR(G1H1(16),1,1,1)
call HGT_invQ_OLR(G1H1(16),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(16),[G1H1(150)])
call ol_merge_last(G1H1(17), G1H1(17)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(17),[G1H1(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(254),[G1H2(248),G1H2(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(256),[G1H2(263),G1H2(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(390),[G2H2(22),G1H2(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(393),[G2H2(50),G1H2(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(269),[G1H2(72),G1H2(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(271),[G1H2(98),G1H2(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(169),[G2H1(147),G2H1(63),G1H1(33),G1H1(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(166),[G2H1(144),G2H1(64),G1H1(39),G1H1(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G1H2(428),G1H2(188)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(409),[G2H2(26),G1H2(191)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(218),[G1H2(499),G1H2(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(412),[G2H2(4),G1H2(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(19),[G1H1(180),G1H1(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(18),[G1H1(59),G1H1(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(498),[G1H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(193),[G1H2(381),G1H2(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(37),[G1H1(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(429),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(94),[G1H2(278),G1H2(283)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(214),[G1H2(206)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(109),[G1H2(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G1H2(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(54),[G1H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(175),[G1H1(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(60),[G1H2(251)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(58),[G1H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(57),[G1H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(178),[G1H2(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(257),[G1H2(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(498),[G2H2(492),G1H2(223)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(121),[G1H2(229)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(510),[G2H2(504),G1H2(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(86),[G1H2(234)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(495),[G2H2(489),G1H2(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(110),[G1H2(240)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(507),[G2H2(501),G1H2(241)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(152),[G1H2(246)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(372),[G1H2(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G1H2(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(377),[G1H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(39),[G1H1(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(4),[G1H1(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(168),[G1H1(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(40),[G1H1(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(5),[G1H1(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(42),[G1H1(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(6),[G1H1(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(173),[G1H1(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G1H2(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(470),[G1H2(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(46),[G1H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(475),[G1H2(270)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(49),[G1H1(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(121),[G1H1(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(222),[G1H1(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(51),[G1H1(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(123),[G1H1(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(52),[G1H1(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(79),[G1H1(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(227),[G1H1(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(546),[G2H2(528),G2H2(486),G2H2(468),G1H2(323),G1H2(301) &
    ,G1H2(290)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(138),[G2H2(99),G1H2(501),G1H2(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(507),[G1H2(296)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(242),[G2H2(233),G1H2(512),G1H2(302)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(518),[G1H2(311)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(540),[G2H2(522),G2H2(480),G2H2(462),G1H2(312)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(230),[G1H2(316)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(381),[G1H2(360),G1H2(338),G1H2(327)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(383),[G1H2(366),G1H2(344),G1H2(333)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(486),[G1H2(345)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(384),[G1H2(349)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(386),[G1H2(355)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(497),[G1H2(356)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(238),[G1H2(359)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(392),[G1H2(371)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(395),[G1H2(376)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(543),[G2H2(525),G2H2(483),G2H2(465),G1H2(421),G1H2(399) &
    ,G1H2(388)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(114),[G2H2(122),G1H2(479),G1H2(392)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(485),[G1H2(398)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(84),[G2H2(43),G1H2(490),G1H2(403)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(496),[G1H2(409)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(537),[G2H2(519),G2H2(477),G2H2(459),G1H2(410)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(102),[G1H2(414)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(135),[G1H1(156),G1H1(134),G1H1(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(137),[G1H1(162),G1H1(140),G1H1(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(138),[G1H1(145)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(140),[G1H1(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(238),[G1H1(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(112),[G1H1(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(168),[G2H1(146),G1H1(221),G1H1(167)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(171),[G2H1(149),G1H1(226),G1H1(172)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(108),[G1H2(424)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(403),[G1H2(458),G1H2(436),G1H2(425)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(405),[G1H2(464),G1H2(442),G1H2(431)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(134),[G1H2(435)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(508),[G1H2(443)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(234),[G1H2(446)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(406),[G1H2(447)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(408),[G1H2(453)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(519),[G1H2(454)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(457)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(411),[G1H2(469)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(414),[G1H2(474)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(11),[G1H1(176)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(157),[G1H1(210),G1H1(188),G1H1(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(159),[G1H1(216),G1H1(194),G1H1(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(12),[G1H1(187)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(13),[G1H1(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(160),[G1H1(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(162),[G1H1(205)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(249),[G1H1(206)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(16),[G1H1(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G2H2(34),G1H2(478)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(49),[G2H2(130),G1H2(489)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(25),[G2H1(22),G1H1(230)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(27),[G2H1(24),G1H1(231)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(145),[G2H2(175),G1H2(500)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(181),[G2H2(209),G1H2(511)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(534),[G1H2(524)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(539),[G1H2(529)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(31),[G2H1(28),G1H1(241)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(33),[G2H1(30),G1H1(242)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(309),[G2H2(249)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(312),[G2H2(259)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(315),[G2H2(264)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(318),[G2H2(274)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(227),[G1H2(477)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G1H2(493)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(100),[G1H1(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(10),[G1H1(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(200),[G1H2(422)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(196),[G1H2(423)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(15),[G1H1(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(21),[G1H1(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(421),[G2H2(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(344),[G2H2(156)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(424),[G2H2(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(347),[G2H2(180)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(427),[G2H2(219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(350),[G2H2(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(430),[G2H2(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(353),[G2H2(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(433),[G2H2(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(371),[G2H2(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(436),[G2H2(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(374),[G2H2(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(439),[G2H2(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(377),[G2H2(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(442),[G2H2(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(380),[G2H2(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(163),[G2H1(141),G2H1(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(172),[G2H1(150),G2H1(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(396),[G2H2(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(387),[G2H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G2H2(13),G1H2(207),G1H2(347)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G2H2(14),G1H2(208),G1H2(325)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(183),[G1H2(219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(205),[G1H2(378)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(294),[G1H2(238)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(296),[G1H2(237)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G1H4(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G1H4(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(23),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(28),[G1H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G2H4(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(17),[G2H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G2H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(45),[G1H4(196)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(83),[G1H4(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(40),[G1H4(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(59),[G1H4(228)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(92),[G2H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(96),[G2H4(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(80),[G2H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(165),[G2H1(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(60),[G1H1(214)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(61),[G1H1(158)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(174),[G2H1(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(529),[G2H2(511),G2H2(469),G2H2(451)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(531),[G2H2(513),G2H2(471),G2H2(453)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(169),[G1H2(509),G1H2(46),G1H2(503)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(532),[G2H2(514),G2H2(472),G2H2(454)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(534),[G2H2(516),G2H2(474),G2H2(456)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(189),[G1H2(141),G1H2(488),G1H2(277)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(329),[G1H2(142),G1H2(292),G1H2(313)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(247),[G1H2(461),G1H2(363),G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(471),[G1H2(166),G1H2(70),G1H2(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(281),[G1H2(308),G1H2(168),G1H2(389)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(93),[G1H2(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(91),[G1H2(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(111),[G1H2(218)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(130),[G1H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(558),[G2H2(555),G2H2(552),G2H2(549)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(570),[G2H2(567),G2H2(564),G2H2(561)])
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(556),ex4(:),G2tensor(71),m3h2x1(:,494),heltab2x2(:,:,753))
  call Hotf_4pt_reduction(G2H2(496),RedSet_4(12),mass4set(:,18),  & 
G1H2(526),G1H2(438),G1H2(157),G1H2(17),G1H2(20),2)
  call HG1shiftOLR(G1H2(438),8,2)
  call Hotf_4pt_reduction(G2H2(508),RedSet_4(12),mass4set(:,18),  & 
G1H2(77),G1H2(22),G1H2(103),G1H2(369),G1H2(3),2)
  call HG1shiftOLR(G1H2(22),8,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(568),ex4(:),G2tensor(2),m3h2x1(:,495),heltab2x2(:,:,754))
  call Hotf_4pt_reduction(G2H2(493),RedSet_4(12),mass4set(:,18),  & 
G1H2(364),G1H2(136),G1H2(460),G1H2(40),G1H2(514),2)
  call HG1shiftOLR(G1H2(136),8,2)
  call Hotf_4pt_reduction(G2H2(505),RedSet_4(12),mass4set(:,18),  & 
G1H2(48),G1H2(59),G1H2(133),G1H2(140),G1H2(300),2)
  call HG1shiftOLR(G1H2(59),8,2)
  call Hotf_4pt_reduction(G2H2(125),RedSet_4(16),mass4set(:,13),  & 
G1H2(94),G1H2(25),G1H2(105),G1H2(204),G1H2(161),2)
  call HG1shiftOLR(G1H2(25),8,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(292),ex4(:),G2tensor(1),m3h2x1(:,496),heltab2x2(:,:,755))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(291),ex4(:),G2tensor(77),m3h2x1(:,497),heltab2x2(:,:,756))
  call Hotf_4pt_reduction(G2H2(293),RedSet_4(16),mass4set(:,13),  & 
G1H2(106),G1H2(205),G1H2(520),G1H2(127),G1H2(295),2)
  call HG1shiftOLR(G1H2(205),8,2)
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(73),ex3(:),G2tensor(4),m3h1x1(:,113),heltab2x1(:,:,113))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(75),ex3(:),G2tensor(3),m3h1x1(:,114),heltab2x1(:,:,114))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(78),ex3(:),G2tensor(83),m3h1x1(:,115),heltab2x1(:,:,115))
  call Hotf_4pt_reduction(G2H1(96),RedSet_4(23),mass4set(:,13),  & 
G1H1(240),G1H1(93),G1H1(245),G1H1(132),G1H1(246),1)
  call HG1shiftOLR(G1H1(93),4,1)
  call Hotf_4pt_reduction(G2H1(93),RedSet_4(23),mass4set(:,24),  & 
G1H1(94),G1H1(137),G1H1(98),G1H1(138),G1H1(99),1)
  call HG1shiftOLR(G1H1(137),4,1)
  call Hotf_4pt_reduction(G2H1(94),RedSet_4(23),mass4set(:,13),  & 
G1H1(142),G1H1(104),G1H1(143),G1H1(105),G1H1(148),1)
  call HG1shiftOLR(G1H1(104),4,1)
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(97),ex3(:),G2tensor(6),m3h1x1(:,116),heltab2x1(:,:,116))
  call Hotf_4pt_reduction(G2H2(300),RedSet_4(26),mass4set(:,13),  & 
G1H2(504),G1H2(193),G1H2(224),G1H2(521),G1H2(178),2)
  call HG1shiftOLR(G1H2(193),8,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(305),ex4(:),G2tensor(5),m3h2x1(:,498),heltab2x2(:,:,757))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(304),ex4(:),G2tensor(89),m3h2x1(:,499),heltab2x2(:,:,758))
  call Hotf_4pt_reduction(G2H2(306),RedSet_4(26),mass4set(:,13),  & 
G1H2(515),G1H2(531),G1H2(536),G1H2(139),G1H2(256),2)
  call HG1shiftOLR(G1H2(531),8,2)
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(105),ex3(:),G2tensor(8),m3h1x1(:,117),heltab2x1(:,:,117))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(108),ex3(:),G2tensor(7),m3h1x1(:,118),heltab2x1(:,:,118))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(111),ex3(:),G2tensor(95),m3h1x1(:,119),heltab2x1(:,:,119))
  call Hotf_4pt_reduction(G2H1(129),RedSet_4(29),mass4set(:,13),  & 
G1H1(109),G1H1(149),G1H1(110),G1H1(153),G1H1(115),1)
  call HG1shiftOLR(G1H1(149),4,1)
  call Hotf_4pt_reduction(G2H1(124),RedSet_4(29),mass4set(:,24),  & 
G1H1(154),G1H1(116),G1H1(159),G1H1(233),G1H1(25),1)
  call HG1shiftOLR(G1H1(116),4,1)
  call Hotf_4pt_reduction(G2H1(126),RedSet_4(29),mass4set(:,13),  & 
G1H1(164),G1H1(30),G1H1(31),G1H1(223),G1H1(36),1)
  call HG1shiftOLR(G1H1(30),4,1)
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(130),ex3(:),G2tensor(10),m3h1x1(:,120),heltab2x1(:,:,120))
call HGT_OLR(G2H2(64),1,1,2)
call HGT_invQ_OLR(G2H2(64),2,5,2)
call HGT_OLR(G2H2(64),6,15,2)
  call Hotf_4pt_reduction(G2H2(64),RedSet_4(47),mass4set(:,5),  & 
G1H2(149),G1H2(24),G1H2(14),G1H2(252),G1H2(261),2)
  call HG1shiftOLR(G1H2(24),2,2)
  call Hotf_4pt_reduction(G2H2(544),RedSet_4(12),mass4set(:,16),  & 
G1H2(203),G1H2(7),G1H2(211),G1H2(279),G1H2(271),2)
  call HG1shiftOLR(G1H2(7),8,2)
call HGT_OLR(G2H2(67),1,1,2)
call HGT_invQ_OLR(G2H2(67),2,5,2)
call HGT_OLR(G2H2(67),6,15,2)
  call Hotf_4pt_reduction(G2H2(67),RedSet_4(47),mass4set(:,6),  & 
G1H2(294),G1H2(492),G1H2(272),G1H2(27),G1H2(28),2)
  call HG1shiftOLR(G1H2(492),2,2)
call HGT_OLR(G2H2(75),1,1,2)
call HGT_invQ_OLR(G2H2(75),2,5,2)
call HGT_OLR(G2H2(75),6,15,2)
  call Hotf_4pt_reduction(G2H2(75),RedSet_4(47),mass4set(:,7),  & 
G1H2(276),G1H2(63),G1H2(250),G1H2(284),G1H2(39),2)
  call HG1shiftOLR(G1H2(63),2,2)
  call Hotf_4pt_reduction(G2H2(538),RedSet_4(12),mass4set(:,17),  & 
G1H2(69),G1H2(212),G1H2(19),G1H2(287),G1H2(314),2)
  call HG1shiftOLR(G1H2(212),8,2)
call HGT_OLR(G2H2(80),1,1,2)
call HGT_invQ_OLR(G2H2(80),2,5,2)
call HGT_OLR(G2H2(80),6,15,2)
  call Hotf_4pt_reduction(G2H2(80),RedSet_4(47),mass4set(:,8),  & 
G1H2(75),G1H2(320),G1H2(298),G1H2(45),G1H2(34),2)
  call HG1shiftOLR(G1H2(320),2,2)
call HGT_OLR(G2H2(86),1,1,2)
call HGT_invQ_OLR(G2H2(86),2,5,2)
call HGT_OLR(G2H2(86),6,15,2)
  call Hotf_4pt_reduction(G2H2(86),RedSet_4(47),mass4set(:,6),  & 
G1H2(451),G1H2(288),G1H2(440),G1H2(390),G1H2(51),2)
  call HG1shiftOLR(G1H2(288),2,2)
call HGT_OLR(G2H2(91),1,1,2)
call HGT_invQ_OLR(G2H2(91),2,5,2)
call HGT_OLR(G2H2(91),6,15,2)
  call Hotf_4pt_reduction(G2H2(91),RedSet_4(47),mass4set(:,7),  & 
G1H2(456),G1H2(400),G1H2(483),G1H2(462),G1H2(52),2)
  call HG1shiftOLR(G1H2(400),2,2)
call HGT_OLR(G2H1(55),1,1,1)
call HGT_invQ_OLR(G2H1(55),2,5,1)
call HGT_OLR(G2H1(55),6,15,1)
  call Hotf_4pt_reduction(G2H1(55),RedSet_4(53),mass4set(:,9),  & 
G1H1(23),G1H1(29),G1H1(35),G1H1(42),G1H1(174),1)
  call HG1shiftOLR(G1H1(29),4,1)
  call Hotf_4pt_reduction(G2H2(208),RedSet_4(16),mass4set(:,9),  & 
G1H2(401),G1H2(374),G1H2(154),G1H2(58),G1H2(88),2)
  call HG1shiftOLR(G1H2(374),8,2)
call HGT_OLR(G2H1(56),1,1,1)
call HGT_invQ_OLR(G2H1(56),2,5,1)
call HGT_OLR(G2H1(56),6,15,1)
  call Hotf_4pt_reduction(G2H1(56),RedSet_4(53),mass4set(:,10),  & 
G1H1(43),G1H1(203),G1H1(48),G1H1(207),G1H1(208),1)
  call HG1shiftOLR(G1H1(203),4,1)
  call Hotf_4pt_reduction(G2H2(289),RedSet_4(16),mass4set(:,10),  & 
G1H2(76),G1H2(81),G1H2(230),G1H2(112),G1H2(505),2)
  call HG1shiftOLR(G1H2(81),8,2)
call HGT_OLR(G2H1(57),1,1,1)
call HGT_invQ_OLR(G2H1(57),2,5,1)
call HGT_OLR(G2H1(57),6,15,1)
  call Hotf_4pt_reduction(G2H1(57),RedSet_4(53),mass4set(:,11),  & 
G1H1(53),G1H1(213),G1H1(219),G1H1(224),G1H1(179),1)
  call HG1shiftOLR(G1H1(213),4,1)
  call Hotf_4pt_reduction(G2H2(290),RedSet_4(16),mass4set(:,11),  & 
G1H2(117),G1H2(124),G1H2(129),G1H2(135),G1H2(450),2)
  call HG1shiftOLR(G1H2(124),8,2)
call HGT_OLR(G2H1(58),1,1,1)
call HGT_invQ_OLR(G2H1(58),2,5,1)
call HGT_OLR(G2H1(58),6,15,1)
  call Hotf_4pt_reduction(G2H1(58),RedSet_4(53),mass4set(:,12),  & 
G1H1(201),G1H1(212),G1H1(54),G1H1(234),G1H1(71),1)
  call HG1shiftOLR(G1H1(212),4,1)
  call Hotf_4pt_reduction(G2H2(133),RedSet_4(16),mass4set(:,12),  & 
G1H2(439),G1H2(433),G1H2(487),G1H2(482),G1H2(467),2)
  call HG1shiftOLR(G1H2(433),8,2)
  call Hotf_4pt_reduction(G2H1(60),RedSet_4(53),mass4set(:,13),  & 
G1H1(235),G1H1(76),G1H1(77),G1H1(120),G1H1(58),1)
  call HG1shiftOLR(G1H1(76),4,1)
  call Hotf_4pt_reduction(G2H1(59),RedSet_4(53),mass4set(:,13),  & 
G1H1(28),G1H1(69),G1H1(80),G1H1(22),G1H1(91),1)
  call HG1shiftOLR(G1H1(69),4,1)
call HGT_OLR(G2H2(136),1,1,2)
call HGT_invQ_OLR(G2H2(136),2,5,2)
call HGT_OLR(G2H2(136),6,15,2)
  call Hotf_4pt_reduction(G2H2(136),RedSet_4(48),mass4set(:,5),  & 
G1H2(153),G1H2(159),G1H2(184),G1H2(185),G1H2(165),2)
  call HG1shiftOLR(G1H2(159),1,2)
  call Hotf_4pt_reduction(G2H2(541),RedSet_4(12),mass4set(:,16),  & 
G1H2(171),G1H2(172),G1H2(176),G1H2(269),G1H2(309),2)
  call HG1shiftOLR(G1H2(172),8,2)
call HGT_OLR(G2H2(141),1,1,2)
call HGT_invQ_OLR(G2H2(141),2,5,2)
call HGT_OLR(G2H2(141),6,15,2)
  call Hotf_4pt_reduction(G2H2(141),RedSet_4(48),mass4set(:,6),  & 
G1H2(183),G1H2(318),G1H2(83),G1H2(411),G1H2(227),2)
  call HG1shiftOLR(G1H2(318),1,2)
call HGT_OLR(G2H2(96),1,1,2)
call HGT_invQ_OLR(G2H2(96),2,5,2)
call HGT_OLR(G2H2(96),6,15,2)
  call Hotf_4pt_reduction(G2H2(96),RedSet_4(48),mass4set(:,7),  & 
G1H2(190),G1H2(195),G1H2(38),G1H2(108),G1H2(196),2)
  call HG1shiftOLR(G1H2(195),1,2)
  call Hotf_4pt_reduction(G2H2(535),RedSet_4(12),mass4set(:,17),  & 
G1H2(53),G1H2(373),G1H2(202),G1H2(265),G1H2(297),2)
  call HG1shiftOLR(G1H2(373),8,2)
call HGT_OLR(G2H2(146),1,1,2)
call HGT_invQ_OLR(G2H2(146),2,5,2)
call HGT_OLR(G2H2(146),6,15,2)
  call Hotf_4pt_reduction(G2H2(146),RedSet_4(48),mass4set(:,8),  & 
G1H2(158),G1H2(151),G1H2(245),G1H2(233),G1H2(30),2)
  call HG1shiftOLR(G1H2(151),1,2)
call HGT_OLR(G2H2(150),1,1,2)
call HGT_invQ_OLR(G2H2(150),2,5,2)
call HGT_OLR(G2H2(150),6,15,2)
  call Hotf_4pt_reduction(G2H2(150),RedSet_4(48),mass4set(:,6),  & 
G1H2(530),G1H2(179),G1H2(194),G1H2(186),G1H2(125),2)
  call HG1shiftOLR(G1H2(179),1,2)
call HGT_OLR(G2H2(154),1,1,2)
call HGT_invQ_OLR(G2H2(154),2,5,2)
call HGT_OLR(G2H2(154),6,15,2)
  call Hotf_4pt_reduction(G2H2(154),RedSet_4(48),mass4set(:,7),  & 
G1H2(262),G1H2(259),G1H2(352),G1H2(346),G1H2(10),2)
  call HG1shiftOLR(G1H2(259),1,2)
  call Hotf_4pt_reduction(G2H2(158),RedSet_4(18),mass4set(:,9),  & 
G1H2(12),G1H2(383),G1H2(394),G1H2(225),G1H2(231),2)
  call HG1shiftOLR(G1H2(383),8,2)
  call Hotf_4pt_reduction(G2H1(67),RedSet_4(23),mass4set(:,9),  & 
G1H1(40),G1H1(102),G1H1(113),G1H1(34),G1H1(1),1)
  call HG1shiftOLR(G1H1(102),4,1)
  call Hotf_4pt_reduction(G2H2(159),RedSet_4(18),mass4set(:,10),  & 
G1H2(232),G1H2(379),G1H2(342),G1H2(331),G1H2(336),2)
  call HG1shiftOLR(G1H2(379),8,2)
  call Hotf_4pt_reduction(G2H1(84),RedSet_4(23),mass4set(:,10),  & 
G1H1(165),G1H1(2),G1H1(244),G1H1(124),G1H1(135),1)
  call HG1shiftOLR(G1H1(2),4,1)
  call Hotf_4pt_reduction(G2H2(160),RedSet_4(18),mass4set(:,11),  & 
G1H2(353),G1H2(138),G1H2(214),G1H2(146),G1H2(330),2)
  call HG1shiftOLR(G1H2(138),8,2)
  call Hotf_4pt_reduction(G2H1(91),RedSet_4(23),mass4set(:,11),  & 
G1H1(232),G1H1(146),G1H1(157),G1H1(3),G1H1(169),1)
  call HG1shiftOLR(G1H1(146),4,1)
  call Hotf_4pt_reduction(G2H2(157),RedSet_4(18),mass4set(:,13),  & 
G1H2(335),G1H2(324),G1H2(174),G1H2(213),G1H2(182),2)
  call HG1shiftOLR(G1H2(324),8,2)
  call Hotf_4pt_reduction(G2H2(161),RedSet_4(18),mass4set(:,12),  & 
G1H2(74),G1H2(156),G1H2(101),G1H2(164),G1H2(253),2)
  call HG1shiftOLR(G1H2(156),8,2)
  call Hotf_4pt_reduction(G2H1(81),RedSet_4(23),mass4set(:,12),  & 
G1H1(4),G1H1(19),G1H1(178),G1H1(189),G1H1(243),1)
  call HG1shiftOLR(G1H1(19),4,1)
  call Hotf_4pt_reduction(G2H2(162),RedSet_4(18),mass4set(:,13),  & 
G1H2(192),G1H2(120),G1H2(200),G1H2(317),G1H2(291),2)
  call HG1shiftOLR(G1H2(120),8,2)
call HGT_OLR(G2H1(85),1,1,1)
call HGT_invQ_OLR(G2H1(85),2,5,1)
call HGT_OLR(G2H1(85),6,15,1)
  call Hotf_4pt_reduction(G2H1(85),RedSet_4(54),mass4set(:,9),  & 
G1H1(200),G1H1(211),G1H1(5),G1H1(122),G1H1(6),1)
  call HG1shiftOLR(G1H1(211),4,1)
  call Hotf_4pt_reduction(G2H2(297),RedSet_4(26),mass4set(:,9),  & 
G1H2(122),G1H2(305),G1H2(328),G1H2(56),G1H2(480),2)
  call HG1shiftOLR(G1H2(305),8,2)
call HGT_OLR(G2H1(86),1,1,1)
call HGT_invQ_OLR(G2H1(86),2,5,1)
call HGT_OLR(G2H1(86),6,15,1)
  call Hotf_4pt_reduction(G2H1(86),RedSet_4(54),mass4set(:,10),  & 
G1H1(185),G1H1(20),G1H1(81),G1H1(26),G1H1(128),1)
  call HG1shiftOLR(G1H1(20),4,1)
  call Hotf_4pt_reduction(G2H2(302),RedSet_4(26),mass4set(:,10),  & 
G1H2(339),G1H2(491),G1H2(350),G1H2(361),G1H2(415),2)
  call HG1shiftOLR(G1H2(491),8,2)
call HGT_OLR(G2H1(87),1,1,1)
call HGT_invQ_OLR(G2H1(87),2,5,1)
call HGT_OLR(G2H1(87),6,15,1)
  call Hotf_4pt_reduction(G2H1(87),RedSet_4(54),mass4set(:,11),  & 
G1H1(133),G1H1(9),G1H1(139),G1H1(12),G1H1(144),1)
  call HG1shiftOLR(G1H1(9),4,1)
  call Hotf_4pt_reduction(G2H2(303),RedSet_4(26),mass4set(:,11),  & 
G1H2(393),G1H2(382),G1H2(404),G1H2(380),G1H2(391),2)
  call HG1shiftOLR(G1H2(382),8,2)
call HGT_OLR(G2H1(88),1,1,1)
call HGT_invQ_OLR(G2H1(88),2,5,1)
call HGT_OLR(G2H1(88),6,15,1)
  call Hotf_4pt_reduction(G2H1(88),RedSet_4(54),mass4set(:,12),  & 
G1H1(15),G1H1(13),G1H1(150),G1H1(14),G1H1(33),1)
  call HG1shiftOLR(G1H1(13),4,1)
  call Hotf_4pt_reduction(G2H2(301),RedSet_4(26),mass4set(:,12),  & 
G1H2(402),G1H2(267),G1H2(170),G1H2(413),G1H2(32),2)
  call HG1shiftOLR(G1H2(267),8,2)
  call Hotf_4pt_reduction(G2H1(90),RedSet_4(54),mass4set(:,13),  & 
G1H1(21),G1H1(39),G1H1(27),G1H1(180),G1H1(32),1)
  call HG1shiftOLR(G1H1(39),4,1)
  call Hotf_4pt_reduction(G2H1(89),RedSet_4(54),mass4set(:,13),  & 
G1H1(59),G1H1(38),G1H1(46),G1H1(52),G1H1(56),1)
  call HG1shiftOLR(G1H1(38),4,1)
  call Hotf_4pt_reduction(G2H2(188),RedSet_4(10),mass4set(:,9),  & 
G1H2(180),G1H2(426),G1H2(5),G1H2(502),G1H2(437),2)
  call HG1shiftOLR(G1H2(426),8,2)
  call Hotf_4pt_reduction(G2H1(99),RedSet_4(29),mass4set(:,9),  & 
G1H1(57),G1H1(64),G1H1(67),G1H1(68),G1H1(78),1)
  call HG1shiftOLR(G1H1(64),4,1)
  call Hotf_4pt_reduction(G2H2(189),RedSet_4(10),mass4set(:,10),  & 
G1H2(513),G1H2(448),G1H2(459),G1H2(275),G1H2(289),2)
  call HG1shiftOLR(G1H2(448),8,2)
  call Hotf_4pt_reduction(G2H1(118),RedSet_4(29),mass4set(:,10),  & 
G1H1(79),G1H1(86),G1H1(89),G1H1(90),G1H1(97),1)
  call HG1shiftOLR(G1H1(86),4,1)
  call Hotf_4pt_reduction(G2H2(190),RedSet_4(10),mass4set(:,11),  & 
G1H2(131),G1H2(49),G1H2(134),G1H2(315),G1H2(50),2)
  call HG1shiftOLR(G1H2(49),8,2)
  call Hotf_4pt_reduction(G2H1(120),RedSet_4(29),mass4set(:,11),  & 
G1H1(100),G1H1(101),G1H1(111),G1H1(112),G1H1(119),1)
  call HG1shiftOLR(G1H1(101),4,1)
  call Hotf_4pt_reduction(G2H2(187),RedSet_4(10),mass4set(:,13),  & 
G1H2(144),G1H2(494),G1H2(152),G1H2(100),G1H2(29),2)
  call HG1shiftOLR(G1H2(494),8,2)
  call Hotf_4pt_reduction(G2H2(191),RedSet_4(10),mass4set(:,12),  & 
G1H2(210),G1H2(62),G1H2(326),G1H2(73),G1H2(476),2)
  call HG1shiftOLR(G1H2(62),8,2)
  call Hotf_4pt_reduction(G2H1(114),RedSet_4(29),mass4set(:,12),  & 
G1H1(156),G1H1(134),G1H1(123),G1H1(162),G1H1(140),1)
  call HG1shiftOLR(G1H1(134),4,1)
  call Hotf_4pt_reduction(G2H2(192),RedSet_4(10),mass4set(:,13),  & 
G1H2(162),G1H2(107),G1H2(65),G1H2(299),G1H2(306),2)
  call HG1shiftOLR(G1H2(107),8,2)
call HGT_OLR(G2H2(194),1,1,2)
call HGT_invQ_OLR(G2H2(194),2,5,2)
call HGT_OLR(G2H2(194),6,15,2)
  call Hotf_4pt_reduction(G2H2(194),RedSet_4(49),mass4set(:,14),  & 
G1H2(128),G1H2(332),G1H2(337),G1H2(85),G1H2(343),2)
  call HG1shiftOLR(G1H2(332),1,2)
call HGT_OLR(G2H2(198),1,1,2)
call HGT_invQ_OLR(G2H2(198),2,5,2)
call HGT_OLR(G2H2(198),6,15,2)
  call Hotf_4pt_reduction(G2H2(198),RedSet_4(49),mass4set(:,15),  & 
G1H2(97),G1H2(348),G1H2(109),G1H2(102),G1H2(354),2)
  call HG1shiftOLR(G1H2(348),1,2)
call HGT_OLR(G2H2(202),1,1,2)
call HGT_invQ_OLR(G2H2(202),2,5,2)
call HGT_OLR(G2H2(202),6,15,2)
  call Hotf_4pt_reduction(G2H2(202),RedSet_4(49),mass4set(:,14),  & 
G1H2(104),G1H2(248),G1H2(137),G1H2(263),G1H2(145),2)
  call HG1shiftOLR(G1H2(248),1,2)
call HGT_OLR(G2H2(206),1,1,2)
call HGT_invQ_OLR(G2H2(206),2,5,2)
call HGT_OLR(G2H2(206),6,15,2)
  call Hotf_4pt_reduction(G2H2(206),RedSet_4(49),mass4set(:,15),  & 
G1H2(155),G1H2(163),G1H2(72),G1H2(173),G1H2(98),2)
  call HG1shiftOLR(G1H2(163),1,2)
call HGT_OLR(G2H2(210),1,1,2)
call HGT_invQ_OLR(G2H2(210),2,5,2)
call HGT_OLR(G2H2(210),6,15,2)
  call Hotf_4pt_reduction(G2H2(210),RedSet_4(50),mass4set(:,15),  & 
G1H2(181),G1H2(428),G1H2(188),G1H2(191),G1H2(499),2)
  call HG1shiftOLR(G1H2(428),1,2)
call HGT_OLR(G2H2(211),1,1,2)
call HGT_invQ_OLR(G2H2(211),2,5,2)
call HGT_OLR(G2H2(211),6,15,2)
  call Hotf_4pt_reduction(G2H2(211),RedSet_4(50),mass4set(:,15),  & 
G1H2(198),G1H2(199),G1H2(54),G1H2(381),G1H2(55),2)
  call HG1shiftOLR(G1H2(199),1,2)
call HGT_OLR(G2H2(212),1,1,2)
call HGT_invQ_OLR(G2H2(212),2,5,2)
call HGT_OLR(G2H2(212),6,15,2)
  call Hotf_4pt_reduction(G2H2(212),RedSet_4(51),mass4set(:,14),  & 
G1H2(6),G1H2(278),G1H2(283),G1H2(206),G1H2(209),2)
  call HG1shiftOLR(G1H2(278),2,2)
call HGT_OLR(G2H2(216),1,1,2)
call HGT_invQ_OLR(G2H2(216),2,5,2)
call HGT_OLR(G2H2(216),6,15,2)
  call Hotf_4pt_reduction(G2H2(216),RedSet_4(51),mass4set(:,15),  & 
G1H2(216),G1H2(23),G1H2(251),G1H2(26),G1H2(31),2)
  call HG1shiftOLR(G1H2(23),2,2)
call HGT_OLR(G2H2(220),1,1,2)
call HGT_invQ_OLR(G2H2(220),2,5,2)
call HGT_OLR(G2H2(220),6,15,2)
  call Hotf_4pt_reduction(G2H2(220),RedSet_4(51),mass4set(:,14),  & 
G1H2(61),G1H2(222),G1H2(223),G1H2(229),G1H2(67),2)
  call HG1shiftOLR(G1H2(222),2,2)
call HGT_OLR(G2H2(224),1,1,2)
call HGT_invQ_OLR(G2H2(224),2,5,2)
call HGT_OLR(G2H2(224),6,15,2)
  call Hotf_4pt_reduction(G2H2(224),RedSet_4(51),mass4set(:,15),  & 
G1H2(234),G1H2(71),G1H2(240),G1H2(241),G1H2(246),2)
  call HG1shiftOLR(G1H2(71),2,2)
  call Hotf_4pt_reduction(G2H2(228),RedSet_4(14),mass4set(:,25),  & 
G1H2(89),G1H2(96),G1H2(1),G1H2(115),G1H2(119),2)
  call HG1shiftOLR(G1H2(96),8,2)
  call Hotf_4pt_reduction(G2H2(244),RedSet_4(1),mass4set(:,15),  & 
G1H2(37),G1H2(270),G1H2(323),G1H2(301),G1H2(290),2)
  call HG1shiftOLR(G1H2(270),2,2)
  call Hotf_4pt_reduction(G2H2(284),RedSet_4(14),mass4set(:,26),  & 
G1H2(501),G1H2(43),G1H2(296),G1H2(512),G1H2(302),2)
  call HG1shiftOLR(G1H2(43),8,2)
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(241),ex2(:),G2tensor(9),ngZd,m3h2x1(:,500),heltab2x2(:,:,759))
  call Hotf_4pt_reduction(G2H2(235),RedSet_4(14),mass4set(:,25),  & 
G1H2(311),G1H2(312),G1H2(316),G1H2(360),G1H2(338),2)
  call HG1shiftOLR(G1H2(312),8,2)
  call Hotf_4pt_reduction(G2H2(247),RedSet_4(1),mass4set(:,15),  & 
G1H2(327),G1H2(366),G1H2(344),G1H2(333),G1H2(345),2)
  call HG1shiftOLR(G1H2(366),2,2)
  call Hotf_4pt_reduction(G2H2(239),RedSet_4(52),mass4set(:,15),  & 
G1H2(349),G1H2(355),G1H2(356),G1H2(359),G1H2(371),2)
  call HG1shiftOLR(G1H2(355),2,2)
  call Hotf_4pt_reduction(G2H2(240),RedSet_4(52),mass4set(:,15),  & 
G1H2(376),G1H2(421),G1H2(399),G1H2(388),G1H2(479),2)
  call HG1shiftOLR(G1H2(421),2,2)
  call Hotf_4pt_reduction(G2H1(82),RedSet_4(21),mass4set(:,26),  & 
G1H1(129),G1H1(145),G1H1(151),G1H1(152),G1H1(155),1)
  call HG1shiftOLR(G1H1(145),4,1)
  call Hotf_4pt_reduction(G2H1(127),RedSet_4(21),mass4set(:,25),  & 
G1H1(221),G1H1(167),G1H1(226),G1H1(172),G1H1(176),1)
  call HG1shiftOLR(G1H1(167),4,1)
  call Hotf_4pt_reduction(G2H1(128),RedSet_4(21),mass4set(:,25),  & 
G1H1(210),G1H1(188),G1H1(177),G1H1(216),G1H1(194),1)
  call HG1shiftOLR(G1H1(188),4,1)
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(270),ex2(:),G2tensor(101),ngX,m3h2x1(:,501),heltab2x2(:,:,760))
  call Hloop_QV_A(ntryL,G1H2(78),ex4(:),G1H1(183),m3h2x1(:,502),heltab2x2(:,:,761))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(183),31,nMB,G2tensor(12),n2h1(277))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(273),ex2(:),G2tensor(11),ngX,m3h2x1(:,503),heltab2x2(:,:,762))
call HGT_OLR(G1H2(80),1,1,2)
call HGT_invQ_OLR(G1H2(80),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(80),ex4(:),G1H1(187),m3h2x1(:,504),heltab2x2(:,:,763))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(187),8,nMB,G2tensor(110),n2h1(278))
  call Hotf_4pt_reduction(G2H2(286),RedSet_4(14),mass4set(:,27),  & 
G1H2(392),G1H2(398),G1H2(490),G1H2(403),G1H2(409),2)
  call HG1shiftOLR(G1H2(398),8,2)
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(275),ex2(:),G2tensor(25),ngH,m3h2x1(:,505),heltab2x2(:,:,764))
  call Hloop_QV_A(ntryL,G1H2(90),ex4(:),G1H1(198),m3h2x1(:,506),heltab2x2(:,:,765))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(198),31,nMB,G2tensor(13),n2h1(279))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(278),ex2(:),G2tensor(122),ngH,m3h2x1(:,507),heltab2x2(:,:,766))
call HGT_OLR(G1H2(92),1,1,2)
call HGT_invQ_OLR(G1H2(92),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(92),ex4(:),G1H1(199),m3h2x1(:,508),heltab2x2(:,:,767))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(199),8,nMB,G2tensor(37),n2h1(280))
  call Hotf_4pt_reduction(G2H2(165),RedSet_4(14),mass4set(:,28),  & 
G1H2(410),G1H2(414),G1H2(424),G1H2(458),G1H2(436),2)
  call HG1shiftOLR(G1H2(414),8,2)
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(280),ex2(:),G2tensor(14),ngPbt,m3h2x1(:,509),heltab2x2(:,:,768))
  call Hloop_QV_A(ntryL,G1H2(113),ex4(:),G1H1(205),m3h2x1(:,510),heltab2x2(:,:,769))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(205),31,nMT,G2tensor(135),n2h1(281))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(283),ex2(:),G2tensor(21),ngPbt,m3h2x1(:,511),heltab2x2(:,:,770))
call HGT_OLR(G1H2(114),1,1,2)
call HGT_invQ_OLR(G1H2(114),2,5,2)
  call Hloop_QV_A(ntryL,G1H2(114),ex4(:),G1H1(206),m3h2x1(:,512),heltab2x2(:,:,771))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(206),8,nMT,G2tensor(19),n2h1(282))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(285),ex2(:),G2tensor(143),m3h2x1(:,513),heltab2x2(:,:,772))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(288),ex2(:),G2tensor(29),m3h2x1(:,514),heltab2x2(:,:,773))
  call Hloop_QS_A(ntryL,G1H1(7),ex3(:),G1H1(209),ngH,m3h1x1(:,121),heltab2x1(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(209),31,nMB,G2tensor(27),n2h1(283))
call HGT_OLR(G1H1(8),1,1,1)
call HGT_invQ_OLR(G1H1(8),2,5,1)
  call Hloop_QS_A(ntryL,G1H1(8),ex3(:),G1H1(230),ngH,m3h1x1(:,122),heltab2x1(:,:,122))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(230),4,nMB,G2tensor(155),n2h1(284))
  call Hotf_4pt_reduction(G2H1(76),RedSet_4(21),mass4set(:,27),  & 
G1H1(231),G1H1(241),G1H1(242),G1H1(70),G1H1(186),1)
  call HG1shiftOLR(G1H1(241),4,1)
  call Hloop_QS_A(ntryL,G1H1(10),ex3(:),G1H1(41),ngH,m3h1x1(:,123),heltab2x1(:,:,123))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(41),31,nMB,G2tensor(33),n2h1(285))
call HGT_OLR(G1H1(11),1,1,1)
call HGT_invQ_OLR(G1H1(11),2,5,1)
  call Hloop_QS_A(ntryL,G1H1(11),ex3(:),G1H1(181),ngH,m3h1x1(:,124),heltab2x1(:,:,124))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(181),4,nMB,G2tensor(31),n2h1(286))
  call Hotf_4pt_reduction(G2H1(109),RedSet_4(21),mass4set(:,28),  & 
G1H1(214),G1H1(158),G1H1(183),G1H1(187),G1H1(198),1)
  call HG1shiftOLR(G1H1(158),4,1)
  call Hloop_QS_A(ntryL,G1H1(16),ex3(:),G1H1(199),ngH,m3h1x1(:,125),heltab2x1(:,:,125))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(199),31,nMT,G2tensor(163),n2h1(287))
call HGT_OLR(G1H1(17),1,1,1)
call HGT_invQ_OLR(G1H1(17),2,5,1)
  call Hloop_QS_A(ntryL,G1H1(17),ex3(:),G1H1(205),ngH,m3h1x1(:,126),heltab2x1(:,:,126))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(205),4,nMT,G2tensor(41),n2h1(288))
  call Hotf_4pt_reduction(G2H2(254),RedSet_4(11),mass4set(:,13),  & 
G1H2(425),G1H2(464),G1H2(442),G1H2(431),G1H2(435),2)
  call HG1shiftOLR(G1H2(464),8,2)
  call Hotf_4pt_reduction(G2H2(256),RedSet_4(11),mass4set(:,13),  & 
G1H2(443),G1H2(446),G1H2(447),G1H2(453),G1H2(454),2)
  call HG1shiftOLR(G1H2(446),8,2)
  call Hotf_4pt_reduction(G2H2(390),RedSet_4(15),mass4set(:,18),  & 
G1H2(457),G1H2(469),G1H2(474),G1H2(478),G1H2(489),2)
  call HG1shiftOLR(G1H2(469),8,2)
  call Hotf_4pt_reduction(G2H2(393),RedSet_4(15),mass4set(:,18),  & 
G1H2(500),G1H2(511),G1H2(524),G1H2(529),G1H2(477),2)
  call HG1shiftOLR(G1H2(511),8,2)
  call Hotf_4pt_reduction(G2H2(269),RedSet_4(19),mass4set(:,13),  & 
G1H2(493),G1H2(422),G1H2(423),G1H2(207),G1H2(347),2)
  call HG1shiftOLR(G1H2(422),8,2)
  call Hotf_4pt_reduction(G2H2(271),RedSet_4(19),mass4set(:,13),  & 
G1H2(208),G1H2(325),G1H2(219),G1H2(378),G1H2(238),2)
  call HG1shiftOLR(G1H2(325),8,2)
  call Hotf_4pt_reduction(G2H1(169),RedSet_4(22),mass4set(:,18),  & 
G1H1(206),G1H1(7),G1H1(209),G1H1(8),G1H1(230),1)
  call HG1shiftOLR(G1H1(7),4,1)
  call Hotf_4pt_reduction(G2H1(166),RedSet_4(22),mass4set(:,18),  & 
G1H1(10),G1H1(41),G1H1(11),G1H1(181),G1H1(16),1)
  call HG1shiftOLR(G1H1(41),4,1)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(25),mass4set(:,25),  & 
G1H2(237),G1H2(509),G1H2(46),G1H2(503),G1H2(141),2)
  call HG1shiftOLR(G1H2(509),8,2)
  call Hotf_4pt_reduction(G2H2(409),RedSet_4(15),mass4set(:,18),  & 
G1H2(488),G1H2(277),G1H2(142),G1H2(292),G1H2(313),2)
  call HG1shiftOLR(G1H2(277),8,2)
  call Hotf_4pt_reduction(G2H2(218),RedSet_4(25),mass4set(:,25),  & 
G1H2(461),G1H2(363),G1H2(8),G1H2(166),G1H2(70),2)
  call HG1shiftOLR(G1H2(363),8,2)
  call Hotf_4pt_reduction(G2H2(412),RedSet_4(15),mass4set(:,18),  & 
G1H2(215),G1H2(308),G1H2(168),G1H2(389),G1H2(82),2)
  call HG1shiftOLR(G1H2(308),8,2)
  call Hotf_4pt_reduction(G2H1(19),RedSet_4(28),mass4set(:,25),  & 
G1H1(199),G1H1(17),G1H1(205),G1H1(250),G1H1(251),1)
  call HG1shiftOLR(G1H1(17),4,1)
  call Hotf_4pt_reduction(G2H1(18),RedSet_4(28),mass4set(:,25),  & 
G1H1(252),G1H1(253),G1H1(254),G1H1(255),G1H1(256),1)
  call HG1shiftOLR(G1H1(253),4,1)
  call Hloop_QV_A(ntryL,G1H2(498),ex4(:),G1H1(257),m3h2x1(:,515),heltab2x2(:,:,774))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(257),31,nMB,G2tensor(39),n2h1(289))
  call Hotf_4pt_reduction(G2H2(193),RedSet_4(19),mass4set(:,9),  & 
G1H2(87),G1H2(218),G1H2(21),G1H2(78),G1H2(80),2)
  call HG1shiftOLR(G1H2(218),8,2)
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(44),27,ex3(:),4,G2tensor(51),m3h1x1(:,127),heltab2x1(:,:,127))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(45),27,ex3(:),4,G2tensor(53),m3h1x1(:,128),heltab2x1(:,:,128))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(37),27,ex3(:),4,G2tensor(59),m3h1x1(:,129),heltab2x1(:,:,129))
  call Hloop_AV_Q(ntryL,G1H2(429),ex4(:),G1H1(257),m3h2x1(:,516),heltab2x2(:,:,775))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(257),31,nMB,G2tensor(67),n2h1(290))
  call Hotf_4pt_reduction(G2H2(94),RedSet_4(11),mass4set(:,9),  & 
G1H2(90),G1H2(92),G1H2(113),G1H2(114),G1H2(498),2)
  call HG1shiftOLR(G1H2(92),8,2)
  call Hotf_4pt_reduction(G2H2(214),RedSet_4(41),mass4set(:,29),  & 
G1H2(429),G1H2(540),G1H2(541),G1H2(542),G1H2(543),2)
  call HG1shiftOLR(G1H2(540),2,2)
  call Hotf_4pt_reduction(G2H2(109),RedSet_4(42),mass4set(:,15),  & 
G1H2(544),G1H2(545),G1H2(546),G1H2(547),G1H2(548),2)
  call HG1shiftOLR(G1H2(545),2,2)
  call Hotf_4pt_reduction(G2H2(16),RedSet_4(41),mass4set(:,29),  & 
G1H2(549),G1H2(550),G1H2(551),G1H2(552),G1H2(553),2)
  call HG1shiftOLR(G1H2(550),2,2)
  call Hotf_4pt_reduction(G2H2(54),RedSet_4(42),mass4set(:,15),  & 
G1H2(554),G1H2(555),G1H2(556),G1H2(557),G1H2(558),2)
  call HG1shiftOLR(G1H2(555),2,2)
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(50),27,ex3(:),4,G2tensor(116),m3h1x1(:,130),heltab2x1(:,:,130))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(51),27,ex3(:),4,G2tensor(125),m3h1x1(:,131),heltab2x1(:,:,131))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(175),27,ex3(:),4,G2tensor(74),m3h1x1(:,132),heltab2x1(:,:,132))
  call Hotf_4pt_reduction(G2H2(60),RedSet_4(44),mass4set(:,29),  & 
G1H2(559),G1H2(560),G1H2(561),G1H2(562),G1H2(563),2)
  call HG1shiftOLR(G1H2(560),2,2)
  call Hotf_4pt_reduction(G2H2(58),RedSet_4(45),mass4set(:,15),  & 
G1H2(564),G1H2(565),G1H2(566),G1H2(567),G1H2(568),2)
  call HG1shiftOLR(G1H2(565),2,2)
  call Hotf_4pt_reduction(G2H2(57),RedSet_4(44),mass4set(:,29),  & 
G1H2(569),G1H2(570),G1H2(571),G1H2(572),G1H2(573),2)
  call HG1shiftOLR(G1H2(570),2,2)
  call Hotf_4pt_reduction(G2H2(178),RedSet_4(45),mass4set(:,15),  & 
G1H2(574),G1H2(575),G1H2(576),G1H2(577),G1H2(578),2)
  call HG1shiftOLR(G1H2(575),2,2)
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(221),23,ex4(:),8,G2tensor(80),m3h2x1(:,517),heltab2x2(:,:,776))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(257),23,ex4(:),8,G2tensor(86),m3h2x1(:,518),heltab2x2(:,:,777))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(498),23,ex4(:),8,G3tensor(1),m3h2x1(:,519),heltab2x2(:,:,778))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(228),23,ex4(:),8,G2tensor(92),m3h2x1(:,520),heltab2x2(:,:,779))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(121),23,ex4(:),8,G2tensor(98),m3h2x1(:,521),heltab2x2(:,:,780))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(510),23,ex4(:),8,G3tensor(2),m3h2x1(:,522),heltab2x2(:,:,781))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(68),23,ex4(:),8,G2tensor(104),m3h2x1(:,523),heltab2x2(:,:,782))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(86),23,ex4(:),8,G2tensor(147),m3h2x1(:,524),heltab2x2(:,:,783))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(495),23,ex4(:),8,G3tensor(3),m3h2x1(:,525),heltab2x2(:,:,784))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(239),23,ex4(:),8,G2tensor(167),m3h2x1(:,526),heltab2x2(:,:,785))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(110),23,ex4(:),8,G2tensor(139),m3h2x1(:,527),heltab2x2(:,:,786))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(507),23,ex4(:),8,G3tensor(4),m3h2x1(:,528),heltab2x2(:,:,787))
  call Hotf_4pt_reduction(G2H2(152),RedSet_4(37),mass4set(:,30),  & 
G1H2(221),G1H2(257),G1H2(228),G1H2(121),G1H2(68),2)
  call HG1shiftOLR(G1H2(257),8,2)
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(84),23,ex4(:),8,G2tensor(23),m3h2x1(:,529),heltab2x2(:,:,788))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(372),23,ex4(:),8,G2tensor(151),m3h2x1(:,530),heltab2x2(:,:,789))
  call Hotf_4pt_reduction(G2H2(18),RedSet_4(37),mass4set(:,30),  & 
G1H2(86),G1H2(239),G1H2(110),G1H2(84),G1H2(372),2)
  call HG1shiftOLR(G1H2(239),8,2)
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(35),23,ex4(:),8,G2tensor(159),m3h2x1(:,531),heltab2x2(:,:,790))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(377),23,ex4(:),8,G2tensor(35),m3h2x1(:,532),heltab2x2(:,:,791))
  call Hotf_4pt_reduction(G2H1(39),RedSet_4(31),mass4set(:,30),  & 
G1H1(44),G1H1(45),G1H1(37),G1H1(257),G1H1(50),1)
  call HG1shiftOLR(G1H1(45),4,1)
  call Hotf_4pt_reduction(G2H1(4),RedSet_4(32),mass4set(:,13),  & 
G1H1(51),G1H1(175),G1H1(258),G1H1(259),G1H1(260),1)
  call HG1shiftOLR(G1H1(175),4,1)
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(62),27,ex3(:),4,G2tensor(171),m3h1x1(:,133),heltab2x1(:,:,133))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(63),27,ex3(:),4,G2tensor(55),m3h1x1(:,134),heltab2x1(:,:,134))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(168),27,ex3(:),4,G2tensor(63),m3h1x1(:,135),heltab2x1(:,:,135))
  call Hotf_4pt_reduction(G2H1(40),RedSet_4(31),mass4set(:,31),  & 
G1H1(62),G1H1(63),G1H1(168),G1H1(261),G1H1(262),1)
  call HG1shiftOLR(G1H1(63),4,1)
  call Hotf_4pt_reduction(G2H1(5),RedSet_4(32),mass4set(:,24),  & 
G1H1(263),G1H1(264),G1H1(265),G1H1(266),G1H1(267),1)
  call HG1shiftOLR(G1H1(264),4,1)
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(73),27,ex3(:),4,G2tensor(57),m3h1x1(:,136),heltab2x1(:,:,136))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(74),27,ex3(:),4,G2tensor(61),m3h1x1(:,137),heltab2x1(:,:,137))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(75),27,ex3(:),4,G2tensor(65),m3h1x1(:,138),heltab2x1(:,:,138))
  call Hotf_4pt_reduction(G2H1(42),RedSet_4(31),mass4set(:,30),  & 
G1H1(73),G1H1(74),G1H1(75),G1H1(268),G1H1(269),1)
  call HG1shiftOLR(G1H1(74),4,1)
  call Hotf_4pt_reduction(G2H1(6),RedSet_4(32),mass4set(:,13),  & 
G1H1(270),G1H1(271),G1H1(272),G1H1(273),G1H1(274),1)
  call HG1shiftOLR(G1H1(271),4,1)
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(84),27,ex3(:),4,G2tensor(69),m3h1x1(:,139),heltab2x1(:,:,139))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(85),27,ex3(:),4,G2tensor(107),m3h1x1(:,140),heltab2x1(:,:,140))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(173),27,ex3(:),4,G2tensor(113),m3h1x1(:,141),heltab2x1(:,:,141))
  call Hotf_4pt_reduction(G2H2(32),RedSet_4(39),mass4set(:,30),  & 
G1H2(35),G1H2(377),G1H2(579),G1H2(580),G1H2(581),2)
  call HG1shiftOLR(G1H2(377),8,2)
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(254),23,ex4(:),8,G2tensor(119),m3h2x1(:,533),heltab2x2(:,:,792))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(470),23,ex4(:),8,G2tensor(128),m3h2x1(:,534),heltab2x2(:,:,793))
  call Hotf_4pt_reduction(G2H2(46),RedSet_4(39),mass4set(:,30),  & 
G1H2(254),G1H2(470),G1H2(582),G1H2(583),G1H2(584),2)
  call HG1shiftOLR(G1H2(470),8,2)
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(274),23,ex4(:),8,G2tensor(175),m3h2x1(:,535),heltab2x2(:,:,794))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(475),23,ex4(:),8,G2tensor(179),m3h2x1(:,536),heltab2x2(:,:,795))
  call Hotf_4pt_reduction(G2H1(49),RedSet_4(34),mass4set(:,30),  & 
G1H1(84),G1H1(85),G1H1(173),G1H1(275),G1H1(276),1)
  call HG1shiftOLR(G1H1(85),4,1)
  call Hotf_4pt_reduction(G2H1(121),RedSet_4(35),mass4set(:,13),  & 
G1H1(277),G1H1(278),G1H1(279),G1H1(280),G1H1(281),1)
  call HG1shiftOLR(G1H1(278),4,1)
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(95),27,ex3(:),4,G2tensor(183),m3h1x1(:,142),heltab2x1(:,:,142))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(96),27,ex3(:),4,G2tensor(187),m3h1x1(:,143),heltab2x1(:,:,143))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(222),27,ex3(:),4,G2tensor(191),m3h1x1(:,144),heltab2x1(:,:,144))
  call Hotf_4pt_reduction(G2H1(51),RedSet_4(34),mass4set(:,31),  & 
G1H1(95),G1H1(96),G1H1(222),G1H1(282),G1H1(283),1)
  call HG1shiftOLR(G1H1(96),4,1)
  call Hotf_4pt_reduction(G2H1(123),RedSet_4(35),mass4set(:,24),  & 
G1H1(284),G1H1(285),G1H1(286),G1H1(287),G1H1(288),1)
  call HG1shiftOLR(G1H1(285),4,1)
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(106),27,ex3(:),4,G2tensor(195),m3h1x1(:,145),heltab2x1(:,:,145))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(107),27,ex3(:),4,G2tensor(199),m3h1x1(:,146),heltab2x1(:,:,146))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(108),27,ex3(:),4,G2tensor(203),m3h1x1(:,147),heltab2x1(:,:,147))
  call Hotf_4pt_reduction(G2H1(52),RedSet_4(34),mass4set(:,30),  & 
G1H1(106),G1H1(107),G1H1(108),G1H1(289),G1H1(290),1)
  call HG1shiftOLR(G1H1(107),4,1)
  call Hotf_4pt_reduction(G2H1(79),RedSet_4(35),mass4set(:,13),  & 
G1H1(291),G1H1(292),G1H1(293),G1H1(294),G1H1(295),1)
  call HG1shiftOLR(G1H1(292),4,1)
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(117),27,ex3(:),4,G2tensor(209),m3h1x1(:,148),heltab2x1(:,:,148))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(118),27,ex3(:),4,G2tensor(213),m3h1x1(:,149),heltab2x1(:,:,149))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(227),27,ex3(:),4,G2tensor(217),m3h1x1(:,150),heltab2x1(:,:,150))
  call Hloop_AV_Q(ntryL,G1H2(285),ex4(:),G1H1(117),m3h2x1(:,537),heltab2x2(:,:,796))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(117),31,nMB,G2tensor(221),n2h1(291))
  call Hloop_AV_Q(ntryL,G1H2(42),ex4(:),G1H1(118),m3h2x1(:,538),heltab2x2(:,:,797))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(118),31,nMB,G2tensor(225),n2h1(292))
  call Hloop_AV_Q(ntryL,G2H2(546),ex4(:),G2H1(14),m3h2x1(:,539),heltab2x2(:,:,798))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(14),31,nMB,G3tensor(5),n2h1(293))
  call Hotf_4pt_reduction(G2H2(138),RedSet_4(11),mass4set(:,10),  & 
G1H2(274),G1H2(475),G1H2(285),G1H2(42),G1H2(585),2)
  call HG1shiftOLR(G1H2(475),8,2)
  call Hloop_AV_Q(ntryL,G1H2(44),ex4(:),G1H1(227),m3h2x1(:,540),heltab2x2(:,:,799))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(227),31,nMB,G2tensor(229),n2h1(294))
  call Hloop_AV_Q(ntryL,G1H2(507),ex4(:),G1H1(117),m3h2x1(:,541),heltab2x2(:,:,800))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(117),31,nMB,G2tensor(233),n2h1(295))
  call Hotf_4pt_reduction(G2H2(242),RedSet_4(11),mass4set(:,11),  & 
G1H2(44),G1H2(507),G1H2(586),G1H2(587),G1H2(588),2)
  call HG1shiftOLR(G1H2(507),8,2)
  call Hloop_AV_Q(ntryL,G1H2(132),ex4(:),G1H1(118),m3h2x1(:,542),heltab2x2(:,:,801))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(118),31,nMT,G2tensor(237),n2h1(296))
  call Hloop_AV_Q(ntryL,G1H2(518),ex4(:),G1H1(227),m3h2x1(:,543),heltab2x2(:,:,802))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(227),31,nMT,G2tensor(243),n2h1(297))
  call Hloop_AV_Q(ntryL,G2H2(540),ex4(:),G2H1(17),m3h2x1(:,544),heltab2x2(:,:,803))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(17),31,nMT,G3tensor(6),n2h1(298))
  call Hotf_4pt_reduction(G2H2(230),RedSet_4(11),mass4set(:,12),  & 
G1H2(132),G1H2(518),G1H2(589),G1H2(590),G1H2(591),2)
  call HG1shiftOLR(G1H2(518),8,2)
  call Hloop_AV_Q(ntryL,G1H2(321),ex4(:),G1H1(117),m3h2x1(:,545),heltab2x2(:,:,804))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(117),31,nMB,G2tensor(247),n2h1(299))
  call Hloop_AV_Q(ntryL,G1H2(322),ex4(:),G1H1(118),m3h2x1(:,546),heltab2x2(:,:,805))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(118),31,nMB,G2tensor(251),n2h1(300))
  call Hotf_4pt_reduction(G2H2(381),RedSet_4(15),mass4set(:,16),  & 
G1H2(321),G1H2(322),G1H2(592),G1H2(593),G1H2(594),2)
  call HG1shiftOLR(G1H2(322),8,2)
  call Hloop_QV_A(ntryL,G2H2(383),ex4(:),G2H1(71),m3h2x1(:,547),heltab2x2(:,:,806))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(71),31,nMB,G3tensor(7),n2h1(301))
  call Hloop_QV_A(ntryL,G1H2(334),ex4(:),G1H1(227),m3h2x1(:,548),heltab2x2(:,:,807))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(227),31,nMB,G2tensor(255),n2h1(302))
  call Hloop_QV_A(ntryL,G1H2(486),ex4(:),G1H1(117),m3h2x1(:,549),heltab2x2(:,:,808))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(117),31,nMB,G2tensor(261),n2h1(303))
  call Hotf_4pt_reduction(G2H2(384),RedSet_4(15),mass4set(:,17),  & 
G1H2(334),G1H2(486),G1H2(595),G1H2(596),G1H2(597),2)
  call HG1shiftOLR(G1H2(486),8,2)
  call Hloop_QV_A(ntryL,G2H2(386),ex4(:),G2H1(20),m3h2x1(:,550),heltab2x2(:,:,809))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(20),31,nMT,G3tensor(8),n2h1(304))
  call Hloop_QV_A(ntryL,G1H2(497),ex4(:),G1H1(118),m3h2x1(:,551),heltab2x2(:,:,810))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(118),31,nMT,G2tensor(265),n2h1(305))
  call Hotf_4pt_reduction(G2H2(238),RedSet_4(14),mass4set(:,32),  & 
G1H2(497),G1H2(598),G1H2(599),G1H2(600),G1H2(601),2)
  call HG1shiftOLR(G1H2(598),8,2)
  call Hloop_QV_A(ntryL,G1H2(365),ex4(:),G1H1(227),m3h2x1(:,552),heltab2x2(:,:,811))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(227),31,nMB,G2tensor(269),n2h1(306))
  call Hloop_QV_A(ntryL,G1H2(367),ex4(:),G1H1(117),m3h2x1(:,553),heltab2x2(:,:,812))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(117),31,nMB,G2tensor(273),n2h1(307))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H2(370),23,ex4(:),8,G2tensor(279),m3h2x1(:,554),heltab2x2(:,:,813))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(392),23,ex4(:),8,G3tensor(9),m3h2x1(:,555),heltab2x2(:,:,814))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(375),23,ex4(:),8,G2tensor(283),m3h2x1(:,556),heltab2x2(:,:,815))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(395),23,ex4(:),8,G3tensor(10),m3h2x1(:,557),heltab2x2(:,:,816))
  call Hloop_QV_A(ntryL,G1H2(386),ex4(:),G1H1(118),m3h2x1(:,558),heltab2x2(:,:,817))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(118),31,nMB,G2tensor(287),n2h1(308))
  call Hloop_QV_A(ntryL,G1H2(387),ex4(:),G1H1(227),m3h2x1(:,559),heltab2x2(:,:,818))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(227),31,nMB,G2tensor(291),n2h1(309))
  call Hloop_QV_A(ntryL,G2H2(543),ex4(:),G2H1(77),m3h2x1(:,560),heltab2x2(:,:,819))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(77),31,nMB,G3tensor(11),n2h1(310))
  call Hotf_4pt_reduction(G2H2(114),RedSet_4(19),mass4set(:,10),  & 
G1H2(365),G1H2(367),G1H2(370),G1H2(375),G1H2(386),2)
  call HG1shiftOLR(G1H2(367),8,2)
  call Hloop_QV_A(ntryL,G1H2(397),ex4(:),G1H1(117),m3h2x1(:,561),heltab2x2(:,:,820))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(117),31,nMB,G2tensor(295),n2h1(311))
  call Hloop_QV_A(ntryL,G1H2(485),ex4(:),G1H1(118),m3h2x1(:,562),heltab2x2(:,:,821))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(118),31,nMB,G2tensor(301),n2h1(312))
  call Hotf_4pt_reduction(G2H2(84),RedSet_4(19),mass4set(:,11),  & 
G1H2(387),G1H2(397),G1H2(485),G1H2(602),G1H2(603),2)
  call HG1shiftOLR(G1H2(397),8,2)
  call Hloop_QV_A(ntryL,G1H2(408),ex4(:),G1H1(227),m3h2x1(:,563),heltab2x2(:,:,822))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(227),31,nMT,G2tensor(307),n2h1(313))
  call Hloop_QV_A(ntryL,G1H2(496),ex4(:),G1H1(117),m3h2x1(:,564),heltab2x2(:,:,823))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(117),31,nMT,G2tensor(308),n2h1(314))
  call Hloop_QV_A(ntryL,G2H2(537),ex4(:),G2H1(23),m3h2x1(:,565),heltab2x2(:,:,824))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(23),31,nMT,G3tensor(12),n2h1(315))
  call Hotf_4pt_reduction(G2H2(102),RedSet_4(19),mass4set(:,12),  & 
G1H2(408),G1H2(496),G1H2(604),G1H2(605),G1H2(606),2)
  call HG1shiftOLR(G1H2(496),8,2)
  call Hloop_QV_A(ntryL,G1H2(419),ex4(:),G1H1(118),m3h2x1(:,566),heltab2x2(:,:,825))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(118),31,nMB,G2tensor(309),n2h1(316))
  call Hloop_QV_A(ntryL,G1H2(420),ex4(:),G1H1(227),m3h2x1(:,567),heltab2x2(:,:,826))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(227),31,nMB,G2tensor(310),n2h1(317))
  call Hotf_4pt_reduction(G2H1(135),RedSet_4(22),mass4set(:,16),  & 
G1H1(117),G1H1(118),G1H1(227),G1H1(296),G1H1(297),1)
  call HG1shiftOLR(G1H1(118),4,1)
  call Hloop_QS_A(ntryL,G2H1(137),ex3(:),G2H1(26),ngH,m3h1x1(:,151),heltab2x1(:,:,151))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(26),31,nMB,G3tensor(13),n2h1(318))
  call Hloop_QS_A(ntryL,G1H1(130),ex3(:),G1H1(298),ngH,m3h1x1(:,152),heltab2x1(:,:,152))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(298),31,nMB,G2tensor(311),n2h1(319))
  call Hloop_QS_A(ntryL,G1H1(141),ex3(:),G1H1(130),ngH,m3h1x1(:,153),heltab2x1(:,:,153))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(130),31,nMB,G2tensor(312),n2h1(320))
  call Hotf_4pt_reduction(G2H1(138),RedSet_4(22),mass4set(:,17),  & 
G1H1(298),G1H1(141),G1H1(130),G1H1(299),G1H1(300),1)
  call HG1shiftOLR(G1H1(141),4,1)
  call Hloop_QS_A(ntryL,G2H1(140),ex3(:),G2H1(80),ngH,m3h1x1(:,154),heltab2x1(:,:,154))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(80),31,nMT,G3tensor(14),n2h1(321))
  call Hloop_QS_A(ntryL,G1H1(238),ex3(:),G1H1(301),ngH,m3h1x1(:,155),heltab2x1(:,:,155))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(301),31,nMT,G2tensor(313),n2h1(322))
  call Hotf_4pt_reduction(G2H1(112),RedSet_4(21),mass4set(:,32),  & 
G1H1(238),G1H1(301),G1H1(302),G1H1(303),G1H1(304),1)
  call HG1shiftOLR(G1H1(301),4,1)
  call Hloop_QS_A(ntryL,G1H1(161),ex3(:),G1H1(305),ngH,m3h1x1(:,156),heltab2x1(:,:,156))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(305),31,nMB,G2tensor(314),n2h1(323))
  call Hloop_QS_A(ntryL,G1H1(163),ex3(:),G1H1(161),ngH,m3h1x1(:,157),heltab2x1(:,:,157))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(161),31,nMB,G2tensor(315),n2h1(324))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(166),27,ex3(:),4,G2tensor(316),m3h1x1(:,158),heltab2x1(:,:,158))
  call Hcheck_last_ST_V(ntryL,l_switch,G2H1(168),27,ex3(:),4,G3tensor(15),m3h1x1(:,159),heltab2x1(:,:,159))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(171),27,ex3(:),4,G2tensor(317),m3h1x1(:,160),heltab2x1(:,:,160))
  call Hcheck_last_VT_S(ntryL,l_switch,G2H1(171),27,ex3(:),4,G3tensor(16),m3h1x1(:,161),heltab2x1(:,:,161))
  call Hotf_4pt_reduction(G2H2(108),RedSet_4(25),mass4set(:,26),  & 
G1H2(419),G1H2(420),G1H2(607),G1H2(608),G1H2(609),2)
  call HG1shiftOLR(G1H2(420),8,2)
  call Hotf_4pt_reduction(G2H2(403),RedSet_4(15),mass4set(:,16),  & 
G1H2(610),G1H2(611),G1H2(612),G1H2(613),G1H2(614),2)
  call HG1shiftOLR(G1H2(611),8,2)
  call Hloop_AV_Q(ntryL,G1H2(430),ex4(:),G1H1(305),m3h2x1(:,568),heltab2x2(:,:,827))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(305),31,nMB,G2tensor(318),n2h1(325))
  call Hloop_AV_Q(ntryL,G2H2(405),ex4(:),G2H1(29),m3h2x1(:,569),heltab2x2(:,:,828))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(29),31,nMB,G3tensor(17),n2h1(326))
  call Hloop_AV_Q(ntryL,G1H2(432),ex4(:),G1H1(163),m3h2x1(:,570),heltab2x2(:,:,829))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(163),31,nMB,G2tensor(319),n2h1(327))
  call Hotf_4pt_reduction(G2H2(134),RedSet_4(25),mass4set(:,27),  & 
G1H2(430),G1H2(432),G1H2(615),G1H2(616),G1H2(617),2)
  call HG1shiftOLR(G1H2(432),8,2)
  call Hloop_AV_Q(ntryL,G1H2(441),ex4(:),G1H1(161),m3h2x1(:,571),heltab2x2(:,:,830))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(161),31,nMB,G2tensor(320),n2h1(328))
  call Hloop_AV_Q(ntryL,G1H2(508),ex4(:),G1H1(166),m3h2x1(:,572),heltab2x2(:,:,831))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(166),31,nMB,G2tensor(321),n2h1(329))
  call Hotf_4pt_reduction(G2H2(234),RedSet_4(25),mass4set(:,28),  & 
G1H2(441),G1H2(508),G1H2(618),G1H2(619),G1H2(620),2)
  call HG1shiftOLR(G1H2(508),8,2)
  call Hotf_4pt_reduction(G2H2(406),RedSet_4(15),mass4set(:,17),  & 
G1H2(621),G1H2(622),G1H2(623),G1H2(624),G1H2(625),2)
  call HG1shiftOLR(G1H2(622),8,2)
  call Hloop_AV_Q(ntryL,G1H2(452),ex4(:),G1H1(171),m3h2x1(:,573),heltab2x2(:,:,832))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(171),31,nMT,G2tensor(322),n2h1(330))
  call Hloop_AV_Q(ntryL,G2H2(408),ex4(:),G2H1(83),m3h2x1(:,574),heltab2x2(:,:,833))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(83),31,nMT,G3tensor(18),n2h1(331))
  call Hloop_AV_Q(ntryL,G1H2(519),ex4(:),G1H1(305),m3h2x1(:,575),heltab2x2(:,:,834))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(305),31,nMT,G2tensor(323),n2h1(332))
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(25),mass4set(:,32),  & 
G1H2(452),G1H2(519),G1H2(626),G1H2(627),G1H2(628),2)
  call HG1shiftOLR(G1H2(519),8,2)
  call Hloop_AV_Q(ntryL,G1H2(463),ex4(:),G1H1(163),m3h2x1(:,576),heltab2x2(:,:,835))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(163),31,nMB,G2tensor(324),n2h1(333))
  call Hloop_AV_Q(ntryL,G1H2(465),ex4(:),G1H1(161),m3h2x1(:,577),heltab2x2(:,:,836))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(161),31,nMB,G2tensor(325),n2h1(334))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H2(468),23,ex4(:),8,G2tensor(326),m3h2x1(:,578),heltab2x2(:,:,837))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(411),23,ex4(:),8,G3tensor(19),m3h2x1(:,579),heltab2x2(:,:,838))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(473),23,ex4(:),8,G2tensor(327),m3h2x1(:,580),heltab2x2(:,:,839))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(414),23,ex4(:),8,G3tensor(20),m3h2x1(:,581),heltab2x2(:,:,840))
  call Hotf_4pt_reduction(G2H1(11),RedSet_4(28),mass4set(:,26),  & 
G1H1(166),G1H1(171),G1H1(305),G1H1(163),G1H1(161),1)
  call HG1shiftOLR(G1H1(171),4,1)
  call Hotf_4pt_reduction(G2H1(157),RedSet_4(22),mass4set(:,16),  & 
G1H1(306),G1H1(307),G1H1(308),G1H1(309),G1H1(310),1)
  call HG1shiftOLR(G1H1(307),4,1)
  call Hloop_AS_Q(ntryL,G1H1(182),ex3(:),G1H1(311),ngH,m3h1x1(:,162),heltab2x1(:,:,162))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(311),31,nMB,G2tensor(328),n2h1(335))
  call Hloop_AS_Q(ntryL,G2H1(159),ex3(:),G2H1(32),ngH,m3h1x1(:,163),heltab2x1(:,:,163))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(32),31,nMB,G3tensor(21),n2h1(336))
  call Hloop_AS_Q(ntryL,G1H1(184),ex3(:),G1H1(182),ngH,m3h1x1(:,164),heltab2x1(:,:,164))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(182),31,nMB,G2tensor(329),n2h1(337))
  call Hotf_4pt_reduction(G2H1(12),RedSet_4(28),mass4set(:,27),  & 
G1H1(311),G1H1(184),G1H1(182),G1H1(312),G1H1(313),1)
  call HG1shiftOLR(G1H1(184),4,1)
  call Hloop_AS_Q(ntryL,G1H1(193),ex3(:),G1H1(314),ngH,m3h1x1(:,165),heltab2x1(:,:,165))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(314),31,nMB,G2tensor(330),n2h1(338))
  call Hloop_AS_Q(ntryL,G1H1(195),ex3(:),G1H1(193),ngH,m3h1x1(:,166),heltab2x1(:,:,166))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(193),31,nMB,G2tensor(331),n2h1(339))
  call Hotf_4pt_reduction(G2H1(13),RedSet_4(28),mass4set(:,28),  & 
G1H1(314),G1H1(195),G1H1(193),G1H1(315),G1H1(316),1)
  call HG1shiftOLR(G1H1(195),4,1)
  call Hotf_4pt_reduction(G2H1(160),RedSet_4(22),mass4set(:,17),  & 
G1H1(317),G1H1(318),G1H1(319),G1H1(320),G1H1(321),1)
  call HG1shiftOLR(G1H1(318),4,1)
  call Hloop_AS_Q(ntryL,G1H1(204),ex3(:),G1H1(322),ngH,m3h1x1(:,167),heltab2x1(:,:,167))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(322),31,nMT,G2tensor(332),n2h1(340))
  call Hloop_AS_Q(ntryL,G2H1(162),ex3(:),G2H1(35),ngH,m3h1x1(:,168),heltab2x1(:,:,168))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(35),31,nMT,G3tensor(22),n2h1(341))
  call Hloop_AS_Q(ntryL,G1H1(249),ex3(:),G1H1(204),ngH,m3h1x1(:,169),heltab2x1(:,:,169))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(204),31,nMT,G2tensor(333),n2h1(342))
  call Hotf_4pt_reduction(G2H1(16),RedSet_4(28),mass4set(:,32),  & 
G1H1(322),G1H1(249),G1H1(204),G1H1(323),G1H1(324),1)
  call HG1shiftOLR(G1H1(249),4,1)
  call Hloop_AS_Q(ntryL,G1H1(215),ex3(:),G1H1(325),ngH,m3h1x1(:,170),heltab2x1(:,:,170))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(325),31,nMB,G2tensor(334),n2h1(343))
  call Hloop_AS_Q(ntryL,G1H1(217),ex3(:),G1H1(215),ngH,m3h1x1(:,171),heltab2x1(:,:,171))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(215),31,nMB,G2tensor(335),n2h1(344))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(220),27,ex3(:),4,G2tensor(336),m3h1x1(:,172),heltab2x1(:,:,172))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(225),27,ex3(:),4,G2tensor(337),m3h1x1(:,173),heltab2x1(:,:,173))
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(37),mass4set(:,33),  & 
G1H2(463),G1H2(465),G1H2(468),G1H2(473),G1H2(629),2)
  call HG1shiftOLR(G1H2(465),8,2)
  call Hloop_QV_A(ntryL,G1H2(484),ex4(:),G1H1(325),m3h2x1(:,582),heltab2x2(:,:,841))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(325),31,nMB,G2tensor(338),n2h1(345))
  call Hotf_4pt_reduction(G2H2(49),RedSet_4(37),mass4set(:,34),  & 
G1H2(484),G1H2(630),G1H2(631),G1H2(632),G1H2(633),2)
  call HG1shiftOLR(G1H2(630),8,2)
  call Hloop_QV_A(ntryL,G1H2(495),ex4(:),G1H1(217),m3h2x1(:,583),heltab2x2(:,:,842))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(217),31,nMT,G2tensor(339),n2h1(346))
  call Hotf_4pt_reduction(G2H1(25),RedSet_4(31),mass4set(:,34),  & 
G1H1(215),G1H1(220),G1H1(225),G1H1(325),G1H1(217),1)
  call HG1shiftOLR(G1H1(220),4,1)
  call Hotf_4pt_reduction(G2H1(27),RedSet_4(32),mass4set(:,11),  & 
G1H1(326),G1H1(327),G1H1(328),G1H1(329),G1H1(330),1)
  call HG1shiftOLR(G1H1(327),4,1)
  call Hloop_QS_A(ntryL,G1H1(236),ex3(:),G1H1(331),ngH,m3h1x1(:,174),heltab2x1(:,:,174))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(331),31,nMT,G2tensor(340),n2h1(347))
  call Hloop_QS_A(ntryL,G1H1(237),ex3(:),G1H1(236),ngH,m3h1x1(:,175),heltab2x1(:,:,175))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(236),31,nMT,G2tensor(341),n2h1(348))
  call Hotf_4pt_reduction(G2H2(145),RedSet_4(39),mass4set(:,33),  & 
G1H2(495),G1H2(634),G1H2(635),G1H2(636),G1H2(637),2)
  call HG1shiftOLR(G1H2(634),8,2)
  call Hloop_AV_Q(ntryL,G1H2(506),ex4(:),G1H1(331),m3h2x1(:,584),heltab2x2(:,:,843))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(331),31,nMB,G2tensor(342),n2h1(349))
  call Hotf_4pt_reduction(G2H2(181),RedSet_4(39),mass4set(:,34),  & 
G1H2(506),G1H2(638),G1H2(639),G1H2(640),G1H2(641),2)
  call HG1shiftOLR(G1H2(638),8,2)
  call Hloop_AV_Q(ntryL,G1H2(517),ex4(:),G1H1(237),m3h2x1(:,585),heltab2x2(:,:,844))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(237),31,nMT,G2tensor(343),n2h1(350))
  call Hloop_SA_Q(ntryL,G1H2(522),ex2(:),G1H1(236),ngPbt,m3h2x1(:,586),heltab2x2(:,:,845))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(236),31,nMT,G2tensor(344),n2h1(351))
  call Hloop_SA_Q(ntryL,G1H2(523),ex2(:),G1H1(331),ngPbt,m3h2x1(:,587),heltab2x2(:,:,846))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(331),31,nMT,G2tensor(345),n2h1(352))
  call Hloop_SA_Q(ntryL,G1H2(534),ex2(:),G1H1(237),ngPbt,m3h2x1(:,588),heltab2x2(:,:,847))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(237),31,nMT,G2tensor(346),n2h1(353))
  call Hloop_WA_Q(ntryL,G1H2(527),ex2(:),G1H1(236),m3h2x1(:,589),heltab2x2(:,:,848))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(236),31,nMT,G2tensor(347),n2h1(354))
  call Hloop_WA_Q(ntryL,G1H2(528),ex2(:),G1H1(331),m3h2x1(:,590),heltab2x2(:,:,849))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(331),31,nMT,G2tensor(348),n2h1(355))
  call Hloop_WA_Q(ntryL,G1H2(539),ex2(:),G1H1(237),m3h2x1(:,591),heltab2x2(:,:,850))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(237),31,nMT,G2tensor(349),n2h1(356))
  call Hotf_4pt_reduction(G2H1(31),RedSet_4(34),mass4set(:,34),  & 
G1H1(236),G1H1(331),G1H1(237),G1H1(332),G1H1(333),1)
  call HG1shiftOLR(G1H1(331),4,1)
  call Hotf_4pt_reduction(G2H1(33),RedSet_4(35),mass4set(:,11),  & 
G1H1(334),G1H1(335),G1H1(336),G1H1(337),G1H1(338),1)
  call HG1shiftOLR(G1H1(335),4,1)
  call Hloop_AS_Q(ntryL,G1H1(247),ex3(:),G1H1(339),ngH,m3h1x1(:,176),heltab2x1(:,:,176))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(339),31,nMT,G2tensor(350),n2h1(357))
  call Hloop_AS_Q(ntryL,G1H1(248),ex3(:),G1H1(247),ngH,m3h1x1(:,177),heltab2x1(:,:,177))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(247),31,nMT,G2tensor(351),n2h1(358))
  call Hloop_SA_Q(ntryL,G1H2(532),ex2(:),G1H1(339),ngPbt,m3h2x1(:,592),heltab2x2(:,:,851))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(339),31,nMT,G2tensor(352),n2h1(359))
  call Hloop_SA_Q(ntryL,G1H2(533),ex2(:),G1H1(248),ngPbt,m3h2x1(:,593),heltab2x2(:,:,852))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(248),31,nMT,G2tensor(353),n2h1(360))
  call Hloop_WA_Q(ntryL,G1H2(537),ex2(:),G1H1(247),m3h2x1(:,594),heltab2x2(:,:,853))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(247),31,nMT,G2tensor(354),n2h1(361))
  call Hloop_WA_Q(ntryL,G1H2(538),ex2(:),G1H1(339),m3h2x1(:,595),heltab2x2(:,:,854))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(339),31,nMT,G2tensor(355),n2h1(362))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(309),ex2(:),G2tensor(356),ngPbt,m3h2x1(:,596),heltab2x2(:,:,855))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(251),ex4(:),G2tensor(357),m3h2x1(:,597),heltab2x2(:,:,856))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(312),ex2(:),G2tensor(358),m3h2x1(:,598),heltab2x2(:,:,857))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(261),ex4(:),G2tensor(359),m3h2x1(:,599),heltab2x2(:,:,858))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(315),ex1(:),G2tensor(360),ngPtb,m3h2x1(:,600),heltab2x2(:,:,859))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(266),ex4(:),G2tensor(361),m3h2x1(:,601),heltab2x2(:,:,860))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(318),ex1(:),G2tensor(362),m3h2x1(:,602),heltab2x2(:,:,861))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(276),ex4(:),G2tensor(363),m3h2x1(:,603),heltab2x2(:,:,862))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(279),ex1(:),G2tensor(364),ngH,m3h2x1(:,604),heltab2x2(:,:,863))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(1),ex3(:),G2tensor(365),m3h1x1(:,178),heltab2x1(:,:,178))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(281),ex1(:),G2tensor(366),ngX,m3h2x1(:,605),heltab2x2(:,:,864))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(2),ex3(:),G2tensor(367),m3h1x1(:,179),heltab2x1(:,:,179))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(3),ex3(:),G2tensor(368),m3h1x1(:,180),heltab2x1(:,:,180))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(7),ex3(:),G2tensor(369),m3h1x1(:,181),heltab2x1(:,:,181))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(8),ex3(:),G2tensor(370),m3h1x1(:,182),heltab2x1(:,:,182))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(115),ex3(:),G2tensor(371),m3h1x1(:,183),heltab2x1(:,:,183))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(117),ex3(:),G2tensor(372),m3h1x1(:,184),heltab2x1(:,:,184))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(70),ex3(:),G2tensor(373),m3h1x1(:,185),heltab2x1(:,:,185))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(227),ex4(:),G2tensor(374),m3h2x1(:,606),heltab2x2(:,:,865))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(11),ex4(:),G2tensor(375),m3h2x1(:,607),heltab2x2(:,:,866))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(100),ex3(:),G2tensor(376),m3h1x1(:,186),heltab2x1(:,:,186))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(10),ex3(:),G2tensor(377),m3h1x1(:,187),heltab2x1(:,:,187))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(200),ex4(:),G2tensor(378),m3h2x1(:,608),heltab2x2(:,:,867))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(196),ex4(:),G2tensor(379),m3h2x1(:,609),heltab2x2(:,:,868))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(15),ex3(:),G2tensor(380),m3h1x1(:,188),heltab2x1(:,:,188))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(21),ex3(:),G2tensor(381),m3h1x1(:,189),heltab2x1(:,:,189))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(37),ex2(:),G2tensor(382),ngZd,m3h2x1(:,610),heltab2x2(:,:,869))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(39),ex2(:),G2tensor(383),ngZd,m3h2x1(:,611),heltab2x2(:,:,870))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(53),ex2(:),G2tensor(384),ngZd,m3h2x1(:,612),heltab2x2(:,:,871))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(51),ex2(:),G2tensor(385),ngZd,m3h2x1(:,613),heltab2x2(:,:,872))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(421),ex2(:),G2tensor(386),ngX,m3h2x1(:,614),heltab2x2(:,:,873))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(344),ex2(:),G2tensor(387),ngX,m3h2x1(:,615),heltab2x2(:,:,874))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(424),ex2(:),G2tensor(388),ngH,m3h2x1(:,616),heltab2x2(:,:,875))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(347),ex2(:),G2tensor(389),ngH,m3h2x1(:,617),heltab2x2(:,:,876))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(427),ex2(:),G2tensor(390),ngPbt,m3h2x1(:,618),heltab2x2(:,:,877))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(350),ex2(:),G2tensor(391),ngPbt,m3h2x1(:,619),heltab2x2(:,:,878))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(430),ex2(:),G2tensor(392),m3h2x1(:,620),heltab2x2(:,:,879))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(353),ex2(:),G2tensor(393),m3h2x1(:,621),heltab2x2(:,:,880))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(433),ex2(:),G2tensor(394),ngX,m3h2x1(:,622),heltab2x2(:,:,881))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(371),ex2(:),G2tensor(395),ngX,m3h2x1(:,623),heltab2x2(:,:,882))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(436),ex2(:),G2tensor(396),ngH,m3h2x1(:,624),heltab2x2(:,:,883))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(374),ex2(:),G2tensor(397),ngH,m3h2x1(:,625),heltab2x2(:,:,884))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(439),ex2(:),G2tensor(398),ngPbt,m3h2x1(:,626),heltab2x2(:,:,885))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(377),ex2(:),G2tensor(399),ngPbt,m3h2x1(:,627),heltab2x2(:,:,886))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(442),ex2(:),G2tensor(400),m3h2x1(:,628),heltab2x2(:,:,887))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(380),ex2(:),G2tensor(401),m3h2x1(:,629),heltab2x2(:,:,888))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(131),ex4(:),G2tensor(402),m3h2x1(:,630),heltab2x2(:,:,889))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(143),ex4(:),G2tensor(403),m3h2x1(:,631),heltab2x2(:,:,890))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(174),ex4(:),G2tensor(404),m3h2x1(:,632),heltab2x2(:,:,891))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(117),ex4(:),G2tensor(405),m3h2x1(:,633),heltab2x2(:,:,892))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(248),ex4(:),G2tensor(406),m3h2x1(:,634),heltab2x2(:,:,893))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(24),ex4(:),G2tensor(407),m3h2x1(:,635),heltab2x2(:,:,894))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(34),ex3(:),G2tensor(408),m3h1x1(:,190),heltab2x1(:,:,190))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(36),ex3(:),G2tensor(409),m3h1x1(:,191),heltab2x1(:,:,191))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(37),ex3(:),G2tensor(410),m3h1x1(:,192),heltab2x1(:,:,192))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(43),ex3(:),G2tensor(411),m3h1x1(:,193),heltab2x1(:,:,193))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(118),ex4(:),G2tensor(412),m3h2x1(:,636),heltab2x2(:,:,895))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(7),ex4(:),G2tensor(413),m3h2x1(:,637),heltab2x2(:,:,896))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(45),ex3(:),G2tensor(414),m3h1x1(:,194),heltab2x1(:,:,194))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(46),ex3(:),G2tensor(415),m3h1x1(:,195),heltab2x1(:,:,195))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(48),ex3(:),G2tensor(416),m3h1x1(:,196),heltab2x1(:,:,196))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(54),ex3(:),G2tensor(417),m3h1x1(:,197),heltab2x1(:,:,197))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H1(160),ex3(:),G1tensor(1),m3h1x1(:,198),heltab2x1(:,:,198))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H1(170),ex3(:),G1tensor(7),m3h1x1(:,199),heltab2x1(:,:,199))
  call Hcheck_last_SS_S(ntryL,l_switch,G1H1(18),ex3(:),G1tensor(13),m3h1x1(:,200),heltab2x1(:,:,200))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H1(24),ex3(:),G1tensor(19),m3h1x1(:,201),heltab2x1(:,:,201))
  call Hcheck_last_SSV_V(ntryL,l_switch,G2H2(172),ex3(:),ex4(:),G2tensor(418),m4h1x2x1(:,1),heltab3x2(:,:,1))
  call Hcheck_last_VVS_S(ntryL,l_switch,G2H2(169),ex4(:),ex3(:),G2tensor(419),m4h2x1x1(:,1),heltab3x2(:,:,2))
  call Hcheck_last_SSV_V(ntryL,l_switch,G2H2(113),ex3(:),ex4(:),G2tensor(420),m4h1x2x1(:,2),heltab3x2(:,:,3))
  call Hcheck_last_VVS_S(ntryL,l_switch,G2H2(149),ex4(:),ex3(:),G2tensor(421),m4h2x1x1(:,2),heltab3x2(:,:,4))
  call Hcheck_last_SS_S(ntryL,l_switch,G2H1(163),ex3(:),G2tensor(422),m3h1x1(:,202),heltab2x1(:,:,202))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(172),ex3(:),G2tensor(423),m3h1x1(:,203),heltab2x1(:,:,203))
  call Hotf_4pt_reduction(G2H2(36),RedSet_4(15),mass4set(:,18),  & 
G1H2(517),G1H2(522),G1H2(523),G1H2(534),G1H2(527),2)
  call HG1shiftOLR(G1H2(522),8,2)
  call Hotf_4pt_reduction(G2H2(126),RedSet_4(15),mass4set(:,18),  & 
G1H2(528),G1H2(539),G1H2(532),G1H2(533),G1H2(537),2)
  call HG1shiftOLR(G1H2(539),8,2)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H2(396),ex4(:),G2tensor(424),m3h2x1(:,638),heltab2x2(:,:,897))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H2(387),ex4(:),G2tensor(425),m3h2x1(:,639),heltab2x2(:,:,898))
  call Hotf_4pt_reduction(G2H2(15),RedSet_4(12),mass4set(:,18),  & 
G1H2(538),G1H2(642),G1H2(643),G1H2(644),G1H2(645),2)
  call HG1shiftOLR(G1H2(642),8,2)
  call Hotf_4pt_reduction(G2H2(20),RedSet_4(12),mass4set(:,18),  & 
G1H2(646),G1H2(647),G1H2(648),G1H2(649),G1H2(650),2)
  call HG1shiftOLR(G1H2(647),8,2)
  call Hotf_4pt_reduction(G2H2(183),RedSet_4(7),mass4set(:,15),  & 
G1H2(651),G1H2(652),G1H2(653),G1H2(654),G1H2(655),2)
  call HG1shiftOLR(G1H2(652),5,2)
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(186),wf2(:,2),G2tensor(426),ngZd,m3h2x1(:,640),heltab2x2(:,:,899))
  call Hotf_4pt_reduction(G2H2(205),RedSet_4(7),mass4set(:,15),  & 
G1H2(656),G1H2(657),G1H2(658),G1H2(659),G1H2(660),2)
  call HG1shiftOLR(G1H2(657),5,2)
  call Hotf_4pt_reduction(G2H2(294),RedSet_4(3),mass4set(:,15),  & 
G1H2(661),G1H2(662),G1H2(663),G1H2(664),G1H2(665),2)
  call HG1shiftOLR(G1H2(662),6,2)
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(295),wf2(:,4),G2tensor(427),ngZd,m3h2x1(:,641),heltab2x2(:,:,900))
  call Hotf_4pt_reduction(G2H2(296),RedSet_4(3),mass4set(:,15),  & 
G1H2(666),G1H2(667),G1H2(668),G1H2(669),G1H2(670),2)
  call HG1shiftOLR(G1H2(667),6,2)
  call Hloop_SQ_A(ntryL,G1H4(151),wf4(:,5),G1H1(248),ngH,m3h4x1(:,39),heltab2x4(:,:,863))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(248),31,nMB,G2tensor(428),n2h1(363))
  call Hotf_4pt_reduction(G2H4(1),RedSet_4(6),mass4set(:,14),  & 
G1H4(27),G1H4(48),G1H4(60),G1H4(128),G1H4(36),4)
  call HG1shiftOLR(G1H4(48),9,4)
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(6),mass4set(:,15),  & 
G1H4(63),G1H4(51),G1H4(26),G1H4(55),G1H4(72),4)
  call HG1shiftOLR(G1H4(51),9,4)
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H4(36),wf4(:,5),G2tensor(429),ngZd,m3h4x1(:,40),heltab2x4(:,:,864))
  call Hotf_4pt_reduction(G2H4(23),RedSet_4(6),mass4set(:,14),  & 
G1H4(65),G1H4(81),G1H4(139),G1H4(217),G1H4(218),4)



end subroutine vamp_1

end module ol_vamp_1_pphvv_ew_bbxhaz_1_/**/REALKIND
