
module ol_colourmatrix_pphvv_ew_uuxhwwx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(17,1), K2(17,1), KL(17,1), Cas(5) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 3]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 3]

  K2( 1,:) = [ 3]
  K2( 2,:) = [ 0]
  K2( 3,:) = [ 0]
  K2( 4,:) = [ 0]
  K2( 5,:) = [ 0]
  K2( 6,:) = [ 0]
  K2( 7,:) = [ 0]
  K2( 8,:) = [ 0]
  K2( 9,:) = [ 0]
  K2(10,:) = [ 0]
  K2(11,:) = [ 0]
  K2(12,:) = [ 0]
  K2(13,:) = [ 0]
  K2(14,:) = [ 0]
  K2(15,:) = [ 0]
  K2(16,:) = [ 0]
  K2(17,:) = [ 3]

  KL( 1,:) = [ 3]
  KL( 2,:) = [ 0]
  KL( 3,:) = [ 0]
  KL( 4,:) = [ 0]
  KL( 5,:) = [ 0]
  KL( 6,:) = [ 0]
  KL( 7,:) = [ 0]
  KL( 8,:) = [ 0]
  KL( 9,:) = [ 0]
  KL(10,:) = [ 0]
  KL(11,:) = [ 0]
  KL(12,:) = [ 0]
  KL(13,:) = [ 0]
  KL(14,:) = [ 0]
  KL(15,:) = [ 0]
  KL(16,:) = [ 0]
  KL(17,:) = [ 3]

#if 1 > 0
    co = 0
    do k = 1, 5
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_pphvv_ew_uuxhwwx_1_/**/REALKIND



module ol_forced_parameters_pphvv_ew_uuxhwwx_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (MM /= 0) write(*,101) 'MM = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'
  if (wMW /= 0) write(*,101) 'wMW = 0'
  if (wMW /= 0) write(*,101) 'wMW = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pphvv_ew_uuxhwwx_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_pphvv_ew_uuxhwwx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 36 ! number of helicity configurations
  integer(intkind2), save :: nhel = 36 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 36 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(36) ! physical helicity states
  integer(intkind2), save :: nhflip = 36    ! relevant helicities for helicity-flipped interference
  integer(intkind2), save :: helflip(2,36) ! Table for the helicity-flipped interference
  integer(intkind2), save, allocatable :: hflip(:,:)
  integer(intkind2) :: tsb
  integer, save :: pi_flip_bak = -1, pj_flip_bak = -1
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(84)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(1), ex4(3), ex5(3)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf3(3,16), wf4(4,15), wf6(6,14), wf9(9,19), wf12(12,30), wf18(18,12), wf36(36,97)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(376), c(351)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_pphvv_ew_uuxhwwx_1_/**/REALKIND






! **********************************************************************
module ol_loop_pphvv_ew_uuxhwwx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_pphvv_ew_uuxhwwx_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = (2*CI*countertermnorm*eQED**5*EWctHAA)/3._/**/REALKIND
    f(  2) = (2*CI*countertermnorm*eQED**5*EWctHWW)/3._/**/REALKIND
    f(  3) = CI*countertermnorm*eQED**5*EWctHZA
    f(  4) = (CI*eQED**3*MW)/(2._/**/REALKIND*cw)
    f(  5) = (CI*countertermnorm*eQED**5*MW)/(3._/**/REALKIND*cw)
    f(  6) = (CI*countertermnorm*eQED**5*MW)/(2._/**/REALKIND*cw)
    f(  7) = (2*CI*countertermnorm*eQED**5*EWctWPH*MW)/3._/**/REALKIND
    f(  8) = (CI*countertermnorm*eQED**5*MW**2)/cw
    f(  9) = (CI*countertermnorm*eQED**5)/(4._/**/REALKIND*sw**3)
    f( 10) = (CI*eQED**3*MW)/(2._/**/REALKIND*sw**3)
    f( 11) = (CI*countertermnorm*eQED**5*MW)/(2._/**/REALKIND*sw**3)
    f( 12) = (CI*countertermnorm*eQED**5*EWctVdu*MW)/(2._/**/REALKIND*sw**3)
    f( 13) = (CI*countertermnorm*eQED**5*EWctVud*MW)/(2._/**/REALKIND*sw**3)
    f( 14) = (countertermnorm*eQED**5)/(sw**2*6._/**/REALKIND)
    f( 15) = (countertermnorm*eQED**5)/(sw**2*4._/**/REALKIND)
    f( 16) = (countertermnorm*eQED**5)/(sw**2*3._/**/REALKIND)
    f( 17) = (countertermnorm*eQED**5)/(sw**2*2._/**/REALKIND)
    f( 18) = (CI*countertermnorm*cw*eQED**5)/(2._/**/REALKIND*sw**2)
    f( 19) = (CI*countertermnorm*eQED**5*EWctHWW)/(2._/**/REALKIND*sw**2)
    f( 20) = (CI*eQED**3*MW)/(cw*sw**2)
    f( 21) = (CI*cw*eQED**3*MW)/sw**2
    f( 22) = (2*CI*countertermnorm*eQED**5*MW)/(3._/**/REALKIND*cw*sw**2)
    f( 23) = (CI*countertermnorm*eQED**5*MW)/(cw*sw**2)
    f( 24) = (2*CI*countertermnorm*cw*eQED**5*MW)/(3._/**/REALKIND*sw**2)
    f( 25) = (CI*countertermnorm*cw*eQED**5*MW)/sw**2
    f( 26) = (CI*countertermnorm*eQED**5)/(3._/**/REALKIND*sw)
    f( 27) = (countertermnorm*eQED**5)/(cw*sw*2._/**/REALKIND)
    f( 28) = (CI*countertermnorm*cw*eQED**5*EWctHWW)/sw
    f( 29) = (2*CI*countertermnorm*cw*eQED**5*EWctHZA)/(3._/**/REALKIND*sw)
    f( 30) = (CI*countertermnorm*cw*eQED**5*EWctHZZ)/sw
    f( 31) = (CI*countertermnorm*eQED**5*EWctPWA)/(3._/**/REALKIND*sw)
    f( 32) = (CI*countertermnorm*eQED**5*EWctPWZ)/(2._/**/REALKIND*sw)
    f( 33) = (CI*eQED**3*MW)/(3._/**/REALKIND*sw)
    f( 34) = (2*CI*eQED**3*MW)/(3._/**/REALKIND*sw)
    f( 35) = (CI*countertermnorm*eQED**5*MW)/(3._/**/REALKIND*sw)
    f( 36) = (CI*countertermnorm*eQED**5*MW)/(2._/**/REALKIND*sw)
    f( 37) = (2*CI*countertermnorm*eQED**5*MW)/(3._/**/REALKIND*sw)
    f( 38) = (CI*countertermnorm*eQED**5*MW)/sw
    f( 39) = (CI*countertermnorm*eQED**5*MW)/(cw**2*sw)
    f( 40) = (2*CI*countertermnorm*eQED**5*EWctAWW*MW)/(3._/**/REALKIND*sw)
    f( 41) = (CI*countertermnorm*eQED**5*EWctZWW*MW)/sw
    f( 42) = (CI*countertermnorm*eQED**5*EWctZWW*MW)/(cw**2*sw)
    f( 43) = (2*CI*countertermnorm*eQED**5*MW**2)/(3._/**/REALKIND*sw)
    f( 44) = (CI*countertermnorm*eQED**5*EWctWPH*MW*sw)/cw
    f( 45) = (eQED**5*integralnorm*MW*SwB)/(cw**3*4._/**/REALKIND)
    f( 46) = (2*eQED**5*integralnorm*MW*SwB)/(cw*9._/**/REALKIND)
    f( 47) = (eQED**5*integralnorm*MW*SwB)/(cw*3._/**/REALKIND)
    f( 48) = (eQED**5*integralnorm*MW*SwB)/(cw*2._/**/REALKIND)
    f( 49) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw*3._/**/REALKIND)
    f( 50) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw*2._/**/REALKIND)
    f( 51) = (2*eQED**5*integralnorm*MW**3*SwB)/(cw**3*3._/**/REALKIND)
    f( 52) = (eQED**5*integralnorm*MW**3*SwB)/cw**3
    f( 53) = (eQED**5*integralnorm*MW**3*SwB)/(cw*2._/**/REALKIND)
    f( 54) = (2*eQED**5*integralnorm*MW**3*SwB)/(cw*3._/**/REALKIND)
    f( 55) = (eQED**5*integralnorm*MW**3*SwB)/cw
    f( 56) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw**5*16._/**/REALKIND)
    f( 57) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw**5*8._/**/REALKIND)
    f( 58) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(MW*sw**5*16._/**/REALKIND)
    f( 59) = (eQED**5*integralnorm*MW*SwB)/(sw**5*8._/**/REALKIND)
    f( 60) = (eQED**5*integralnorm*MW*SwB)/(sw**5*4._/**/REALKIND)
    f( 61) = (eQED**5*integralnorm*MW*SwB)/(sw**5*2._/**/REALKIND)
    f( 62) = (cw**2*eQED**5*integralnorm*MW*SwB)/(sw**5*4._/**/REALKIND)
    f( 63) = (cw**2*eQED**5*integralnorm*MW*SwB)/(sw**5*2._/**/REALKIND)
    f( 64) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(sw**5*4._/**/REALKIND)
    f( 65) = (eQED**5*integralnorm*MW**3*SwB)/(sw**5*2._/**/REALKIND)
    f( 66) = (eQED**5*integralnorm*MH**2*SwB)/(cw*MW*sw**4*16._/**/REALKIND)
    f( 67) = (eQED**5*integralnorm*MH**2*SwB)/(cw*MW*sw**4*8._/**/REALKIND)
    f( 68) = (cw*eQED**5*integralnorm*MH**2*SwB)/(MW*sw**4*8._/**/REALKIND)
    f( 69) = (cw*eQED**5*integralnorm*MH**2*SwB)/(MW*sw**4*4._/**/REALKIND)
    f( 70) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(cw*MW*sw**4*16._/**/REALKIND)
    f( 71) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(cw*MW*sw**4*8._/**/REALKIND)
    f( 72) = (3*cw*eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(MW*sw**4*8._/**/REALKIND)
    f( 73) = (eQED**5*integralnorm*MW*SwB)/(cw**3*sw**4*8._/**/REALKIND)
    f( 74) = (eQED**5*integralnorm*MW*SwB)/(cw**3*sw**4*4._/**/REALKIND)
    f( 75) = (eQED**5*integralnorm*MW*SwB)/(cw**3*sw**4*2._/**/REALKIND)
    f( 76) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**4*8._/**/REALKIND)
    f( 77) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**4*4._/**/REALKIND)
    f( 78) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**4*2._/**/REALKIND)
    f( 79) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**4)
    f( 80) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**4*8._/**/REALKIND)
    f( 81) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**4*4._/**/REALKIND)
    f( 82) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**4*2._/**/REALKIND)
    f( 83) = (cw*eQED**5*integralnorm*MW*SwB)/sw**4
    f( 84) = (cw**3*eQED**5*integralnorm*MW*SwB)/(sw**4*2._/**/REALKIND)
    f( 85) = (cw**3*eQED**5*integralnorm*MW*SwB)/sw**4
    f( 86) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(cw**3*sw**4*2._/**/REALKIND)
    f( 87) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(cw*sw**4*2._/**/REALKIND)
    f( 88) = (3*cw*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(sw**4*4._/**/REALKIND)
    f( 89) = (3*cw*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(sw**4*2._/**/REALKIND)
    f( 90) = (eQED**5*integralnorm*MW**3*SwB)/(cw**5*sw**4)
    f( 91) = (eQED**5*integralnorm*MW**3*SwB)/(cw**3*sw**4)
    f( 92) = (eQED**5*integralnorm*MW**3*SwB)/(cw*sw**4*8._/**/REALKIND)
    f( 93) = (eQED**5*integralnorm*MW**3*SwB)/(cw*sw**4*2._/**/REALKIND)
    f( 94) = (eQED**5*integralnorm*MW**3*SwB)/(cw*sw**4)
    f( 95) = (cw*eQED**5*integralnorm*MW**3*SwB)/(sw**4*4._/**/REALKIND)
    f( 96) = (cw*eQED**5*integralnorm*MW**3*SwB)/(sw**4*2._/**/REALKIND)
    f( 97) = (cw*eQED**5*integralnorm*MW**3*SwB)/sw**4
    f( 98) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw**3*12._/**/REALKIND)
    f( 99) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw**3*6._/**/REALKIND)
    f(100) = (eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(101) = (eQED**5*integralnorm*MH**4*SwB)/(MW*sw**3*12._/**/REALKIND)
    f(102) = (eQED**5*integralnorm*MH**4*SwB)/(MW*sw**3*6._/**/REALKIND)
    f(103) = (eQED**5*integralnorm*lambdaHHH*MH**4*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(104) = (eQED**5*integralnorm*lambdaHHH*MH**4*SwB)/(MW*sw**3*2._/**/REALKIND)
    f(105) = (eQED**5*integralnorm*MW*SwB)/(sw**3*18._/**/REALKIND)
    f(106) = (eQED**5*integralnorm*MW*SwB)/(sw**3*12._/**/REALKIND)
    f(107) = (eQED**5*integralnorm*MW*SwB)/(sw**3*9._/**/REALKIND)
    f(108) = (eQED**5*integralnorm*MW*SwB)/(sw**3*6._/**/REALKIND)
    f(109) = (2*eQED**5*integralnorm*MW*SwB)/(sw**3*9._/**/REALKIND)
    f(110) = (eQED**5*integralnorm*MW*SwB)/(sw**3*4._/**/REALKIND)
    f(111) = (eQED**5*integralnorm*MW*SwB)/(sw**3*3._/**/REALKIND)
    f(112) = (eQED**5*integralnorm*MW*SwB)/(sw**3*2._/**/REALKIND)
    f(113) = (2*eQED**5*integralnorm*MW*SwB)/(sw**3*3._/**/REALKIND)
    f(114) = (eQED**5*integralnorm*MW*SwB)/sw**3
    f(115) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw**3*8._/**/REALKIND)
    f(116) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw**3*4._/**/REALKIND)
    f(117) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw**3*2._/**/REALKIND)
    f(118) = (cw**2*eQED**5*integralnorm*MW*SwB)/(sw**3*3._/**/REALKIND)
    f(119) = (2*cw**2*eQED**5*integralnorm*MW*SwB)/(sw**3*3._/**/REALKIND)
    f(120) = (cw**2*eQED**5*integralnorm*MW*SwB)/sw**3
    f(121) = (eQED**5*integralnorm*MH**2*MW*SwB)/(sw**3*6._/**/REALKIND)
    f(122) = (eQED**5*integralnorm*MH**2*MW*SwB)/(sw**3*4._/**/REALKIND)
    f(123) = (eQED**5*integralnorm*MH**2*MW*SwB)/(sw**3*3._/**/REALKIND)
    f(124) = (eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(sw**3*2._/**/REALKIND)
    f(125) = (eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/sw**3
    f(126) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(cw**2*sw**3*2._/**/REALKIND)
    f(127) = (eQED**5*integralnorm*MW**3*SwB)/(sw**3*6._/**/REALKIND)
    f(128) = (eQED**5*integralnorm*MW**3*SwB)/(sw**3*3._/**/REALKIND)
    f(129) = (eQED**5*integralnorm*MW**3*SwB)/(sw**3*2._/**/REALKIND)
    f(130) = (2*eQED**5*integralnorm*MW**3*SwB)/(sw**3*3._/**/REALKIND)
    f(131) = (eQED**5*integralnorm*MW**3*SwB)/(cw**4*sw**3)
    f(132) = (eQED**5*integralnorm*MW**3*SwB)/(cw**2*sw**3*6._/**/REALKIND)
    f(133) = (eQED**5*integralnorm*MW**3*SwB)/(cw**2*sw**3)
    f(134) = (eQED**5*integralnorm*MH**2*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(135) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(136) = (eQED**5*integralnorm*MH**4*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(137) = (3*eQED**5*integralnorm*lambdaHHH*MH**4*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(138) = (eQED**5*integralnorm*MW*SwB)/(cw**3*sw**2*8._/**/REALKIND)
    f(139) = (eQED**5*integralnorm*MW*SwB)/(cw**3*sw**2*4._/**/REALKIND)
    f(140) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*8._/**/REALKIND)
    f(141) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*6._/**/REALKIND)
    f(142) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(143) = (4*eQED**5*integralnorm*MW*SwB)/(cw*sw**2*9._/**/REALKIND)
    f(144) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*2._/**/REALKIND)
    f(145) = (2*eQED**5*integralnorm*MW*SwB)/(cw*sw**2*3._/**/REALKIND)
    f(146) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2)
    f(147) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**2*3._/**/REALKIND)
    f(148) = (4*cw*eQED**5*integralnorm*MW*SwB)/(sw**2*9._/**/REALKIND)
    f(149) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**2*2._/**/REALKIND)
    f(150) = (2*cw*eQED**5*integralnorm*MW*SwB)/(sw**2*3._/**/REALKIND)
    f(151) = (cw*eQED**5*integralnorm*MW*SwB)/sw**2
    f(152) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw**3*sw**2*4._/**/REALKIND)
    f(153) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(154) = (cw*eQED**5*integralnorm*MH**2*MW*SwB)/(sw**2*2._/**/REALKIND)
    f(155) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(cw**3*sw**2*4._/**/REALKIND)
    f(156) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(157) = (eQED**5*integralnorm*MW**3*SwB)/(cw**5*sw**2*2._/**/REALKIND)
    f(158) = (eQED**5*integralnorm*MW**3*SwB)/(cw**3*sw**2*4._/**/REALKIND)
    f(159) = (eQED**5*integralnorm*MW**3*SwB)/(cw**3*sw**2*2._/**/REALKIND)
    f(160) = (eQED**5*integralnorm*MW**3*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(161) = (eQED**5*integralnorm*MW**3*SwB)/(cw*sw**2*2._/**/REALKIND)
    f(162) = (cw*eQED**5*integralnorm*MW**3*SwB)/sw**2
    f(163) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw*3._/**/REALKIND)
    f(164) = (2*eQED**5*integralnorm*MH**2*SwB)/(MW*sw*3._/**/REALKIND)
    f(165) = (4*eQED**5*integralnorm*MW*SwB)/(sw*27._/**/REALKIND)
    f(166) = (2*eQED**5*integralnorm*MW*SwB)/(sw*9._/**/REALKIND)
    f(167) = (8*eQED**5*integralnorm*MW*SwB)/(sw*27._/**/REALKIND)
    f(168) = (eQED**5*integralnorm*MW*SwB)/(sw*3._/**/REALKIND)
    f(169) = (4*eQED**5*integralnorm*MW*SwB)/(sw*9._/**/REALKIND)
    f(170) = (eQED**5*integralnorm*MW*SwB)/(sw*2._/**/REALKIND)
    f(171) = (2*eQED**5*integralnorm*MW*SwB)/(sw*3._/**/REALKIND)
    f(172) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw*6._/**/REALKIND)
    f(173) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(174) = (2*eQED**5*integralnorm*MW*SwB)/(cw**2*sw*3._/**/REALKIND)
    f(175) = (2*eQED**5*integralnorm*MH**2*MW*SwB)/(sw*9._/**/REALKIND)
    f(176) = (eQED**5*integralnorm*MH**2*MW*SwB)/(sw*3._/**/REALKIND)
    f(177) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(178) = (eQED**5*integralnorm*MW**3*SwB)/(sw*3._/**/REALKIND)
    f(179) = (4*eQED**5*integralnorm*MW**3*SwB)/(sw*9._/**/REALKIND)
    f(180) = (2*eQED**5*integralnorm*MW**3*SwB)/(sw*3._/**/REALKIND)
    f(181) = (eQED**5*integralnorm*MW**3*SwB)/(cw**4*sw*2._/**/REALKIND)
    f(182) = (eQED**5*integralnorm*MW**3*SwB)/(cw**2*sw*2._/**/REALKIND)
    f(183) = (2*eQED**5*integralnorm*MW**3*SwB)/(cw**2*sw*3._/**/REALKIND)
    f(184) = (eQED**5*integralnorm*MW*sw*SwB)/(cw**2*3._/**/REALKIND)
    f(185) = (eQED**5*integralnorm*MW*sw*SwB)/(cw**2*2._/**/REALKIND)
    f(186) = (eQED**5*integralnorm*MH**2*MW*sw*SwB)/(cw**2*3._/**/REALKIND)
    f(187) = (eQED**5*integralnorm*MH**2*MW*sw*SwB)/(cw**2*2._/**/REALKIND)
    f(188) = (2*eQED**5*integralnorm*MW**3*sw*SwB)/(cw**4*3._/**/REALKIND)
    f(189) = (eQED**5*integralnorm*MW**3*sw*SwB)/cw**4
    f(190) = (eQED**5*integralnorm*MW**3*sw*SwB)/(cw**2*3._/**/REALKIND)
    f(191) = (2*eQED**5*integralnorm*MW**3*sw*SwB)/(cw**2*3._/**/REALKIND)
    f(192) = (eQED**5*integralnorm*MW**3*sw*SwB)/cw**2
    f(193) = (eQED**5*integralnorm*MW**3*sw**2*SwB)/(cw**3*2._/**/REALKIND)
    f(194) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(sw**5*8._/**/REALKIND))
    f(195) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**4*16._/**/REALKIND))
    f(196) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**4*8._/**/REALKIND))
    f(197) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(198) = -((eQED**5*integralnorm*MH**2*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw*MW*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(199) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*2._/**/REALKIND)
    f(200) = -((eQED**5*integralnorm*MH**2*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw*MW*sw**4*2._/**/REALKIND*4._/**/REALKIND))
    f(201) = (-3*eQED**5*integralnorm*lambdaHHH*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**4*16._/**/REALKIND)
    f(202) = -((eQED**5*integralnorm*MH**4*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**4*8._/**/REALKIND))
    f(203) = (-3*eQED**5*integralnorm*lambdaHHH*MH**4*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**4*8._/**/REALKIND)
    f(204) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**4*8._/**/REALKIND))
    f(205) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**4*4._/**/REALKIND))
    f(206) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**2*8._/**/REALKIND)
    f(207) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**4*8._/**/REALKIND))
    f(208) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**4*4._/**/REALKIND))
    f(209) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**2*2._/**/REALKIND)
    f(210) = -((eQED**5*integralnorm*MW*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**3*sw**4*2._/**/REALKIND*4._/**/REALKIND))
    f(211) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*6._/**/REALKIND)
    f(212) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(213) = -((cw*eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(sw**4*4._/**/REALKIND))
    f(214) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*2._/**/REALKIND)
    f(215) = -((eQED**5*integralnorm*MW*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw*sw**4*2._/**/REALKIND*4._/**/REALKIND))
    f(216) = -((eQED**5*integralnorm*MH**2*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**4*4._/**/REALKIND))
    f(217) = -((eQED**5*integralnorm*MH**2*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**4*4._/**/REALKIND))
    f(218) = (eQED**5*integralnorm*MH**2*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(219) = (eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**2*8._/**/REALKIND)
    f(220) = (eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**2*4._/**/REALKIND)
    f(221) = (eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**2*2._/**/REALKIND)
    f(222) = (eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(223) = (eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*2._/**/REALKIND)
    f(224) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(MW*sw**3*6._/**/REALKIND))
    f(225) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(MW*sw**3*3._/**/REALKIND))
    f(226) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(sw**3*6._/**/REALKIND))
    f(227) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(sw**3*3._/**/REALKIND))
    f(228) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**3*12._/**/REALKIND)
    f(229) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**3*8._/**/REALKIND)
    f(230) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**3*3._/**/REALKIND)
    f(231) = -((eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(sw**3*6._/**/REALKIND))
    f(232) = -((eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(sw**3*3._/**/REALKIND))
    f(233) = (eQED**5*integralnorm*MW**3*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**3*12._/**/REALKIND)
    f(234) = (eQED**5*integralnorm*MW**3*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**3*6._/**/REALKIND)
    f(235) = (eQED**5*integralnorm*MW*SwB*(-(cw**2*sw**2*12._/**/REALKIND) + cw**4*6._/**/REALKIND  &
      + sw**4*6._/**/REALKIND))/(cw**2*sw**3*12._/**/REALKIND*6._/**/REALKIND)
    f(236) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw*6._/**/REALKIND)
    f(237) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(238) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw*3._/**/REALKIND)
    f(239) = (eQED**5*integralnorm*MH**2*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw*6._/**/REALKIND)
    f(240) = -((eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(cw**4*sw*3._/**/REALKIND))
    f(241) = (eQED**5*integralnorm*MW**3*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw*3._/**/REALKIND)
    f(242) = (eQED**5*integralnorm*MW*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**3*sw**2*4._/**/REALKIND*8._/**/REALKIND)
    f(243) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*4._/**/REALKIND))
    f(244) = (eQED**5*integralnorm*MW*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**3*sw**2*2._/**/REALKIND*4._/**/REALKIND)
    f(245) = -((eQED**5*integralnorm*MH**2*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*4._/**/REALKIND))
    f(246) = -((eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(cw**5*2._/**/REALKIND))
    f(247) = -((eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(cw**3*2._/**/REALKIND))
    f(248) = (eQED**5*integralnorm*MW*SwF)/(cw*9._/**/REALKIND)
    f(249) = (2*eQED**5*integralnorm*MW*SwF)/(cw*9._/**/REALKIND)
    f(250) = (eQED**5*integralnorm*MW*SwF)/(cw*3._/**/REALKIND)
    f(251) = (4*eQED**5*integralnorm*MW*SwF)/(cw*9._/**/REALKIND)
    f(252) = (eQED**5*integralnorm*MW*SwF)/(cw*2._/**/REALKIND)
    f(253) = (2*eQED**5*integralnorm*MW*SwF)/(cw*3._/**/REALKIND)
    f(254) = (eQED**5*integralnorm*MW*SwF)/cw
    f(255) = (3*eQED**5*integralnorm*MW*SwF)/(cw*2._/**/REALKIND)
    f(256) = (eQED**5*integralnorm*SwF)/(MW*sw**5*8._/**/REALKIND)
    f(257) = (eQED**5*integralnorm*MB*SwF)/(MW*sw**5*8._/**/REALKIND)
    f(258) = (eQED**5*integralnorm*ML*SwF)/(MW*sw**5*8._/**/REALKIND)
    f(259) = (eQED**5*integralnorm*MT*SwF)/(MW*sw**5*8._/**/REALKIND)
    f(260) = (eQED**5*integralnorm*MW*SwF)/(sw**5*4._/**/REALKIND)
    f(261) = (eQED**5*integralnorm*MW*SwF)/(sw**5*2._/**/REALKIND)
    f(262) = (cw*eQED**5*integralnorm*SwF)/(MW*sw**4*4._/**/REALKIND)
    f(263) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**4*8._/**/REALKIND)
    f(264) = (cw*eQED**5*integralnorm*MB*SwF)/(MW*sw**4*4._/**/REALKIND)
    f(265) = (eQED**5*integralnorm*MB**2*SwF)/(cw*MW*sw**4*8._/**/REALKIND)
    f(266) = (eQED**5*integralnorm*ML*SwF)/(cw*MW*sw**4*8._/**/REALKIND)
    f(267) = (cw*eQED**5*integralnorm*ML*SwF)/(MW*sw**4*4._/**/REALKIND)
    f(268) = (eQED**5*integralnorm*ML**2*SwF)/(cw*MW*sw**4*8._/**/REALKIND)
    f(269) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**4*8._/**/REALKIND)
    f(270) = (cw*eQED**5*integralnorm*MT*SwF)/(MW*sw**4*4._/**/REALKIND)
    f(271) = (eQED**5*integralnorm*MT**2*SwF)/(cw*MW*sw**4*8._/**/REALKIND)
    f(272) = (cw*eQED**5*integralnorm*MW*SwF)/(sw**4*2._/**/REALKIND)
    f(273) = (cw*eQED**5*integralnorm*MW*SwF)/sw**4
    f(274) = (eQED**5*integralnorm*SwF)/(MW*sw**3*18._/**/REALKIND)
    f(275) = (eQED**5*integralnorm*SwF)/(MW*sw**3*9._/**/REALKIND)
    f(276) = (eQED**5*integralnorm*SwF)/(MW*sw**3*6._/**/REALKIND)
    f(277) = (eQED**5*integralnorm*SwF)/(MW*sw**3*4._/**/REALKIND)
    f(278) = (eQED**5*integralnorm*MB*SwF)/(MW*sw**3*36._/**/REALKIND)
    f(279) = (eQED**5*integralnorm*MB*SwF)/(MW*sw**3*18._/**/REALKIND)
    f(280) = (eQED**5*integralnorm*MB*SwF)/(MW*sw**3*9._/**/REALKIND)
    f(281) = (eQED**5*integralnorm*MB*SwF)/(MW*sw**3*8._/**/REALKIND)
    f(282) = (eQED**5*integralnorm*MB*SwF)/(MW*sw**3*6._/**/REALKIND)
    f(283) = (eQED**5*integralnorm*MB*SwF)/(MW*sw**3*4._/**/REALKIND)
    f(284) = (eQED**5*integralnorm*MB**2*SwF)/(MW*sw**3*18._/**/REALKIND)
    f(285) = (eQED**5*integralnorm*MB**2*SwF)/(MW*sw**3*4._/**/REALKIND)
    f(286) = (eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwF)/(MW*sw**3*6._/**/REALKIND)
    f(287) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwF)/(MW*sw**3*4._/**/REALKIND)
    f(288) = (eQED**5*integralnorm*ML*SwF)/(MW*sw**3*12._/**/REALKIND)
    f(289) = (eQED**5*integralnorm*ML*SwF)/(MW*sw**3*8._/**/REALKIND)
    f(290) = (eQED**5*integralnorm*ML*SwF)/(MW*sw**3*6._/**/REALKIND)
    f(291) = (eQED**5*integralnorm*ML*SwF)/(MW*sw**3*4._/**/REALKIND)
    f(292) = (eQED**5*integralnorm*lambdaHHH*MH**2*ML*SwF)/(MW*sw**3*2._/**/REALKIND)
    f(293) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*ML*SwF)/(MW*sw**3*4._/**/REALKIND)
    f(294) = (eQED**5*integralnorm*ML**2*SwF)/(MW*sw**3*6._/**/REALKIND)
    f(295) = (eQED**5*integralnorm*ML**2*SwF)/(MW*sw**3*4._/**/REALKIND)
    f(296) = (eQED**5*integralnorm*MT*SwF)/(MW*sw**3*18._/**/REALKIND)
    f(297) = (eQED**5*integralnorm*MT*SwF)/(MW*sw**3*9._/**/REALKIND)
    f(298) = (eQED**5*integralnorm*MT*SwF)/(MW*sw**3*8._/**/REALKIND)
    f(299) = (eQED**5*integralnorm*MT*SwF)/(MW*sw**3*6._/**/REALKIND)
    f(300) = (eQED**5*integralnorm*MT*SwF)/(MW*sw**3*4._/**/REALKIND)
    f(301) = (eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwF)/(MW*sw**3*3._/**/REALKIND)
    f(302) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwF)/(MW*sw**3*4._/**/REALKIND)
    f(303) = (eQED**5*integralnorm*MT**2*SwF)/(MW*sw**3*9._/**/REALKIND)
    f(304) = (eQED**5*integralnorm*MT**2*SwF)/(MW*sw**3*4._/**/REALKIND)
    f(305) = (eQED**5*integralnorm*MW*SwF)/(sw**3*9._/**/REALKIND)
    f(306) = (2*eQED**5*integralnorm*MW*SwF)/(sw**3*9._/**/REALKIND)
    f(307) = (eQED**5*integralnorm*MW*SwF)/(sw**3*3._/**/REALKIND)
    f(308) = (4*eQED**5*integralnorm*MW*SwF)/(sw**3*9._/**/REALKIND)
    f(309) = (eQED**5*integralnorm*MW*SwF)/(sw**3*2._/**/REALKIND)
    f(310) = (2*eQED**5*integralnorm*MW*SwF)/(sw**3*3._/**/REALKIND)
    f(311) = (eQED**5*integralnorm*MW*SwF)/sw**3
    f(312) = (eQED**5*integralnorm*MW*SwF)/(cw**2*sw**3*2._/**/REALKIND)
    f(313) = (eQED**5*integralnorm*MW*SwF)/(cw**2*sw**3)
    f(314) = (eQED**5*integralnorm*MB*MW*SwF)/(sw**3*9._/**/REALKIND)
    f(315) = (eQED**5*integralnorm*MB*MW*SwF)/(sw**3*2._/**/REALKIND)
    f(316) = (eQED**5*integralnorm*MB*MW*SwF)/(cw**2*sw**3*2._/**/REALKIND)
    f(317) = (eQED**5*integralnorm*ML*MW*SwF)/(sw**3*3._/**/REALKIND)
    f(318) = (eQED**5*integralnorm*ML*MW*SwF)/(sw**3*2._/**/REALKIND)
    f(319) = (eQED**5*integralnorm*ML*MW*SwF)/(cw**2*sw**3*2._/**/REALKIND)
    f(320) = (2*eQED**5*integralnorm*MT*MW*SwF)/(sw**3*9._/**/REALKIND)
    f(321) = (eQED**5*integralnorm*MT*MW*SwF)/(sw**3*2._/**/REALKIND)
    f(322) = (eQED**5*integralnorm*MT*MW*SwF)/(cw**2*sw**3*2._/**/REALKIND)
    f(323) = (eQED**5*integralnorm*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(324) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*12._/**/REALKIND)
    f(325) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(326) = (cw*eQED**5*integralnorm*MB*SwF)/(MW*sw**2*9._/**/REALKIND)
    f(327) = (cw*eQED**5*integralnorm*MB*SwF)/(MW*sw**2*2._/**/REALKIND)
    f(328) = (eQED**5*integralnorm*ML*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(329) = (cw*eQED**5*integralnorm*ML*SwF)/(MW*sw**2*3._/**/REALKIND)
    f(330) = (cw*eQED**5*integralnorm*ML*SwF)/(MW*sw**2*2._/**/REALKIND)
    f(331) = (eQED**5*integralnorm*ML**2*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(332) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*6._/**/REALKIND)
    f(333) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(334) = (2*cw*eQED**5*integralnorm*MT*SwF)/(MW*sw**2*9._/**/REALKIND)
    f(335) = (cw*eQED**5*integralnorm*MT*SwF)/(MW*sw**2*2._/**/REALKIND)
    f(336) = (2*eQED**5*integralnorm*MW*SwF)/(cw*sw**2*9._/**/REALKIND)
    f(337) = (4*eQED**5*integralnorm*MW*SwF)/(cw*sw**2*9._/**/REALKIND)
    f(338) = (eQED**5*integralnorm*MW*SwF)/(cw*sw**2*2._/**/REALKIND)
    f(339) = (2*eQED**5*integralnorm*MW*SwF)/(cw*sw**2*3._/**/REALKIND)
    f(340) = (8*eQED**5*integralnorm*MW*SwF)/(cw*sw**2*9._/**/REALKIND)
    f(341) = (eQED**5*integralnorm*MW*SwF)/(cw*sw**2)
    f(342) = (4*eQED**5*integralnorm*MW*SwF)/(cw*sw**2*3._/**/REALKIND)
    f(343) = (2*eQED**5*integralnorm*MW*SwF)/(cw*sw**2)
    f(344) = (3*eQED**5*integralnorm*MW*SwF)/(cw*sw**2)
    f(345) = (2*cw*eQED**5*integralnorm*MW*SwF)/(sw**2*9._/**/REALKIND)
    f(346) = (4*cw*eQED**5*integralnorm*MW*SwF)/(sw**2*9._/**/REALKIND)
    f(347) = (2*cw*eQED**5*integralnorm*MW*SwF)/(sw**2*3._/**/REALKIND)
    f(348) = (8*cw*eQED**5*integralnorm*MW*SwF)/(sw**2*9._/**/REALKIND)
    f(349) = (cw*eQED**5*integralnorm*MW*SwF)/sw**2
    f(350) = (4*cw*eQED**5*integralnorm*MW*SwF)/(sw**2*3._/**/REALKIND)
    f(351) = (2*cw*eQED**5*integralnorm*MW*SwF)/sw**2
    f(352) = (3*cw*eQED**5*integralnorm*MW*SwF)/sw**2
    f(353) = (eQED**5*integralnorm*ML*MW*SwF)/(cw*sw**2*2._/**/REALKIND)
    f(354) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*27._/**/REALKIND)
    f(355) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*6._/**/REALKIND)
    f(356) = (eQED**5*integralnorm*ML*SwF)/(MW*sw*3._/**/REALKIND)
    f(357) = (eQED**5*integralnorm*ML*SwF)/(MW*sw*2._/**/REALKIND)
    f(358) = (4*eQED**5*integralnorm*MT*SwF)/(MW*sw*27._/**/REALKIND)
    f(359) = (eQED**5*integralnorm*MT*SwF)/(MW*sw*3._/**/REALKIND)
    f(360) = (eQED**5*integralnorm*MW*SwF)/(sw*27._/**/REALKIND)
    f(361) = (2*eQED**5*integralnorm*MW*SwF)/(sw*27._/**/REALKIND)
    f(362) = (4*eQED**5*integralnorm*MW*SwF)/(sw*27._/**/REALKIND)
    f(363) = (eQED**5*integralnorm*MW*SwF)/(sw*6._/**/REALKIND)
    f(364) = (8*eQED**5*integralnorm*MW*SwF)/(sw*27._/**/REALKIND)
    f(365) = (eQED**5*integralnorm*MW*SwF)/(sw*3._/**/REALKIND)
    f(366) = (eQED**5*integralnorm*MW*SwF)/(sw*2._/**/REALKIND)
    f(367) = (16*eQED**5*integralnorm*MW*SwF)/(sw*27._/**/REALKIND)
    f(368) = (2*eQED**5*integralnorm*MW*SwF)/(sw*3._/**/REALKIND)
    f(369) = (eQED**5*integralnorm*MW*SwF)/sw
    f(370) = (4*eQED**5*integralnorm*MW*SwF)/(sw*3._/**/REALKIND)
    f(371) = (2*eQED**5*integralnorm*MW*SwF)/sw
    f(372) = (eQED**5*integralnorm*MW*SwF)/(cw**2*sw*3._/**/REALKIND)
    f(373) = (2*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*3._/**/REALKIND)
    f(374) = (eQED**5*integralnorm*MW*SwF)/(cw**2*sw)
    f(375) = (4*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*3._/**/REALKIND)
    f(376) = (2*eQED**5*integralnorm*MW*SwF)/(cw**2*sw)

  c = [ f(45), f(46), f(47), f(48), f(49), f(50), f(51), f(52), f(53), f(54), f(55), f(56), f(57), f(58), f(59), f(60), f(61) &
    , f(62), f(63), f(64), f(65), f(66), f(67), f(68), f(69), f(70), f(71), f(72), f(73), f(74), f(75), f(76), f(77), f(78), f(79) &
    , f(80), f(81), f(82), f(83), f(84), f(85), f(86), f(87), f(88), f(89), f(90), f(91), f(92), f(93), f(94), f(95), f(96), f(97) &
    , f(98), f(99), f(100), f(101), f(102), f(103), f(104), f(105), f(106), f(107), f(108), f(109), f(110), f(111), f(112), f(113) &
    , f(114), f(115), f(116), f(117), f(118), f(119), f(120), f(121), f(122), f(123), f(124), f(125), f(126), f(127), f(128) &
    , f(129), f(130), f(131), f(132), f(133), f(134), f(135), f(136), f(137), f(138), f(139), f(140), f(141), f(142), f(143) &
    , f(144), f(145), f(146), f(147), f(148), f(149), f(150), f(151), f(152), f(153), f(154), f(155), f(156), f(157), f(158) &
    , f(159), f(160), f(161), f(162), f(163), f(164), f(165), f(166), f(167), f(168), f(169), f(170), f(171), f(172), f(173) &
    , f(174), f(175), f(176), f(177), f(178), f(179), f(180), f(181), f(182), f(183), f(184), f(185), f(186), f(187), f(188) &
    , f(189), f(190), f(191), f(192), f(193), f(194), f(195), f(196), f(197), f(198), f(199), f(200), f(201), f(202), f(203) &
    , f(204), f(205), f(206), f(207), f(208), f(209), f(210), f(211), f(212), f(213), f(214), f(215), f(216), f(217), f(218) &
    , f(219), f(220), f(221), f(222), f(223), f(224), f(225), f(226), f(227), f(228), f(229), f(230), f(231), f(232), f(233) &
    , f(234), f(235), f(236), f(237), f(238), f(239), f(240), f(241), f(242), f(243), f(244), f(245), f(246), f(247), 3*f(248) &
    , 3*f(249), f(250), 3*f(251), f(252), 3*f(252), f(253), f(254), 3*f(254), f(255), 3*f(256), 3*f(257), f(258), 3*f(259), f(260) &
    , 3*f(260), f(261), 3*f(261), 3*f(262), 3*f(263), 3*f(264), 3*f(265), f(266), f(267), f(268), 3*f(269), 3*f(270), 3*f(271) &
    , f(272), 3*f(272), f(273), 3*f(273), 3*f(274), 3*f(275), 3*f(276), 3*f(277), 3*f(278), 3*f(279), 3*f(280), 3*f(281), 3*f(282) &
    , 3*f(283), 3*f(284), 3*f(285), 3*f(286), 3*f(287), f(288), f(289), f(290), f(291), f(292), f(293), f(294), f(295), 3*f(296) &
    , 3*f(297), 3*f(298), 3*f(299), 3*f(300), 3*f(301), 3*f(302), 3*f(303), 3*f(304), 3*f(305), 3*f(306), f(307), 3*f(307) &
    , 3*f(308), f(309), 3*f(309), f(310), 3*f(310), f(311), 3*f(311), f(312), 3*f(312), f(313), 3*f(313), 3*f(314), 3*f(315) &
    , 3*f(316), f(317), f(318), f(319), 3*f(320), 3*f(321), 3*f(322), 3*f(323), 3*f(324), 3*f(325), 3*f(326), 3*f(327), f(328) &
    , f(329), f(330), f(331), 3*f(332), 3*f(333), 3*f(334), 3*f(335), 3*f(336), 3*f(337), 3*f(338), f(339), 3*f(340), f(341) &
    , 3*f(341), f(342), f(343), 3*f(343), f(344), 3*f(345), 3*f(346), f(347), 3*f(348), f(349), 3*f(349), f(350), f(351), 3*f(351) &
    , f(352), f(353), 3*f(354), 3*f(355), f(356), f(357), 3*f(358), 3*f(359), 3*f(360), 3*f(361), 3*f(362), 3*f(363), 3*f(364) &
    , f(365), 3*f(365), f(366), 3*f(367), f(368), 3*f(368), f(369), f(370), 3*f(370), f(371), 3*f(372), 3*f(373), f(374), 3*f(375) &
    , f(376) ]
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3))+L(6,3))
  den(2) = 1 /((L(5,12) - MW2)+L(6,12))
  den(4) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(6) = 1 /((L(5,20) - MW2)+L(6,20))
  den(9) = 1 /((L(5,24) - MZ2)+L(6,24))
  den(11) = 1 /((L(5,9))+L(6,9))
  den(13) = 1 /((L(5,18))+L(6,18))
  den(15) = 1 /((L(5,24))+L(6,24))
  den(19) = 1 /((L(5,28) - MZ2)+L(6,28))
  den(23) = 1 /((L(5,28))+L(6,28))
  den(27) = 1 /((L(5,19) - MW2)+L(6,19))
  den(38) = 1 /((L(5,11) - MW2)+L(6,11))
  den(46) = 1 /((L(5,7) - MZ2)+L(6,7))
  den(50) = 1 /((L(5,22))+L(6,22))
  den(55) = 1 /((L(5,13))+L(6,13))
  den(60) = 1 /((L(5,24) - MH2)+L(6,24))
  den(61) = 1 /((L(5,28) - MH2)+L(6,28))
  den(62) = 1 /((L(5,25))+L(6,25))
  den(65) = 1 /((L(5,26))+L(6,26))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(2)*den(4)
  den(7) = den(1)*den(6)
  den(8) = den(4)*den(6)
  den(10) = den(4)*den(9)
  den(12) = den(6)*den(11)
  den(14) = den(2)*den(13)
  den(16) = den(1)*den(15)
  den(17) = den(1)*den(9)
  den(18) = den(4)*den(15)
  den(20) = den(2)*den(19)
  den(21) = den(1)*den(20)
  den(22) = den(4)*den(20)
  den(24) = den(2)*den(23)
  den(25) = den(1)*den(24)
  den(26) = den(4)*den(24)
  den(28) = den(1)*den(27)
  den(29) = den(2)*den(28)
  den(30) = den(4)*den(27)
  den(31) = den(2)*den(30)
  den(32) = den(6)*den(19)
  den(33) = den(1)*den(32)
  den(34) = den(4)*den(32)
  den(35) = den(6)*den(23)
  den(36) = den(1)*den(35)
  den(37) = den(4)*den(35)
  den(39) = den(1)*den(38)
  den(40) = den(6)*den(39)
  den(41) = den(4)*den(38)
  den(42) = den(6)*den(41)
  den(43) = den(9)*den(19)
  den(44) = den(1)*den(43)
  den(45) = den(4)*den(43)
  den(47) = den(4)*den(46)
  den(48) = den(15)*den(47)
  den(49) = den(9)*den(47)
  den(51) = den(6)*den(50)
  den(52) = den(11)*den(51)
  den(53) = den(11)*den(38)
  den(54) = den(6)*den(53)
  den(56) = den(2)*den(55)
  den(57) = den(13)*den(56)
  den(58) = den(13)*den(27)
  den(59) = den(2)*den(58)
  den(63) = den(11)*den(62)
  den(64) = den(2)*den(61)
  den(66) = den(13)*den(65)
  den(67) = den(6)*den(61)
  den(68) = den(15)*den(62)
  den(69) = den(9)*den(62)
  den(70) = den(15)*den(65)
  den(71) = den(9)*den(65)
  den(72) = den(60)*den(61)
  den(73) = den(1)*den(60)
  den(74) = den(4)*den(60)
  den(75) = den(11)*den(13)
  den(76) = den(1)*den(61)
  den(77) = den(4)*den(61)
  den(78) = den(1)*den(64)
  den(79) = den(4)*den(64)
  den(80) = den(1)*den(67)
  den(81) = den(4)*den(67)
  den(82) = den(47)*den(60)
  den(83) = den(1)*den(72)
  den(84) = den(4)*den(72)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_pphvv_ew_uuxhwwx_1_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,97))
  allocate(M1helarray(1,hel_states))
  allocate(M1helarray_ct(1,hel_states))
  allocate(M0_col1_helarray(1,hel_states))
  A(1:hel_states,1:97)%j = 0
  A(1:hel_states,1:97)%e = 0
  A(1:hel_states,1:97)%hf = 0
  A(1:hel_states,1:97)%s = 0
#if 1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(1,hel_states,16))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
#else
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
  use ol_loop_storage_pphvv_ew_uuxhwwx_1_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for up anti-up higgs W- W+ -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_pphvv_ew_uuxhwwx_1, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_pphvv_ew_uuxhwwx_1, only: &
    & external_perm_pphvv_ew_uuxhwwx_1, &
    & external_perm_inv_pphvv_ew_uuxhwwx_1, &
    & extcomb_perm_pphvv_ew_uuxhwwx_1, &
    & average_factor_pphvv_ew_uuxhwwx_1
  use ol_external_pphvv_ew_uuxhwwx_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_pphvv_ew_uuxhwwx_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pphvv_ew_uuxhwwx_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_pphvv_ew_uuxhwwx_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02
  logical, intent(in) :: qp_kinematics
  real(REALKIND),  intent(out), optional :: M2ct
  real(REALKIND),  intent(out), optional :: M2colint(16)
  real(REALKIND) :: iM2ct
  real(REALKIND) :: iM2colint(16)

  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(1), M2(1)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak
  logical              :: do_ct, do_colint
#if 5 > 3
  integer :: ind_cc_comb(5)
#endif
  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if (present(M2ct)) then
    do_ct = .true.
  else
    do_ct = .false.
  end if

  if (present(M2colint)) then
    do_colint = .true.
  else
    do_colint = .false.
  end if

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, qp_kinematics, M2ct=iM2ct, M2colint=iM2colint)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,97))
  end if

  if (do_ct) call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()
  if (do_ct) call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  if (do_ct) call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, nMH, nMW, nMW ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_pphvv_ew_uuxhwwx_1, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_S(P(:,3), rMH, H3, ex3, POLSEL(3),3)
  call pol_wf_V(P(:,4), rMW, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rMW, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_TV_S(ntry, ex3(:), 4, ex4(:), 8, wf3(:,1), n3(:,2), t3x3(:,:,1))
  call vert_VV_S(ntry, wf4(:,1), ex5(:), wf12(:,1), n3(:,3), t3x12(:,:,1))
  call vert_QA_Z(gZu,ntry, ex1(:), ex2(:), wf4(:,2), n3(:,4), t3x4(:,:,2))
  call vert_VV_S(ntry, wf4(:,2), ex5(:), wf12(:,2), n3(:,5), t3x12(:,:,2))
  call vert_SV_V(ntry, ex3(:), ex4(:), wf3(:,2), n3(:,6), t3x3(:,:,2))
  call vert_UV_W(ntry, wf4(:,1), 3, ex5(:), 16, wf12(:,3), n3(:,7), t3x12(:,:,3))
  call vert_UV_W(ntry, wf4(:,2), 3, ex5(:), 16, wf12(:,4), n3(:,8), t3x12(:,:,4))
  call vert_TV_S(ntry, ex3(:), 4, ex5(:), 16, wf3(:,3), n3(:,9), t3x3(:,:,3))
  call vert_VV_S(ntry, wf4(:,1), ex4(:), wf12(:,5), n3(:,10), t3x12(:,:,5))
  call vert_VV_S(ntry, wf4(:,2), ex4(:), wf12(:,6), n3(:,11), t3x12(:,:,6))
  call vert_SV_V(ntry, ex3(:), ex5(:), wf3(:,4), n3(:,12), t3x3(:,:,4))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,1), 3, wf12(:,7), n3(:,13), t3x12(:,:,7))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,2), 3, wf12(:,8), n3(:,14), t3x12(:,:,8))
  call vert_UV_W(ntry, ex5(:), 16, ex4(:), 8, wf9(:,1), n3(:,15), t3x9(:,:,1))
  call vert_SV_V(ntry, ex3(:), wf4(:,2), wf4(:,3), n3(:,16), t3x4(:,:,3))
  call vert_WQ_A(ntry, ex4(:), ex1(:), wf6(:,1), n3(:,17), t3x6(:,:,1))
  call prop_Q_A(ntry, wf6(:,1), 9, ZERO, 0_intkind1, wf6(:,2), n2(1))
  call vert_QA_W(ntry, wf6(:,2), ex2(:), wf12(:,9), n3(:,18), t3x12(:,:,9))
  call vert_AW_Q(ntry, ex2(:), ex5(:), wf6(:,3), n3(:,19), t3x6(:,:,2))
  call prop_A_Q(ntry, wf6(:,3), 18, ZERO, 0_intkind1, wf6(:,4), n2(2))
  call vert_QA_W(ntry, ex1(:), wf6(:,4), wf12(:,10), n3(:,20), t3x12(:,:,10))
  call counter_VV_S(ntry, wf4(:,1), ex5(:), wf12(:,11), n3(:,21), t3x12(:,:,11))
  call counter_VV_S(ntry, wf4(:,2), ex5(:), wf12(:,12), n3(:,22), t3x12(:,:,12))
  call counter_UV_W(ntry, wf4(:,1), 3, ex5(:), 16, wf12(:,13), n3(:,23), t3x12(:,:,13))
  call counter_UV_W(ntry, wf4(:,2), 3, ex5(:), 16, wf12(:,14), n3(:,24), t3x12(:,:,14))
  call counter_VV_S(ntry, wf4(:,1), ex4(:), wf12(:,15), n3(:,25), t3x12(:,:,15))
  call counter_VV_S(ntry, wf4(:,2), ex4(:), wf12(:,16), n3(:,26), t3x12(:,:,16))
  call counter_UV_W(ntry, ex4(:), 8, wf4(:,1), 3, wf12(:,17), n3(:,27), t3x12(:,:,17))
  call counter_UV_W(ntry, ex4(:), 8, wf4(:,2), 3, wf12(:,18), n3(:,28), t3x12(:,:,18))
  call counter_UV_W(ntry, ex5(:), 16, ex4(:), 8, wf9(:,2), n3(:,29), t3x9(:,:,2))
  call counter_SV_V(ntry, ex3(:), wf4(:,1), wf4(:,4), n3(:,30), t3x4(:,:,4))
  call counter_SV_V(ntry, ex3(:), wf4(:,2), wf4(:,5), n3(:,31), t3x4(:,:,5))
  call counter_TV_S(ntry, ex3(:), 4, ex5(:), 16, wf3(:,5), n3(:,32), t3x3(:,:,5))
  call counter_SV_V(ntry, ex3(:), ex5(:), wf3(:,6), n3(:,33), t3x3(:,:,6))
  call counter_TV_S(ntry, ex3(:), 4, ex4(:), 8, wf3(:,7), n3(:,34), t3x3(:,:,7))
  call counter_SV_V(ntry, ex3(:), ex4(:), wf3(:,8), n3(:,35), t3x3(:,:,8))
  call counter_QA_W(ntry, wf6(:,2), ex2(:), wf12(:,19), n3(:,36), t3x12(:,:,19))
  call counter_AW_Q(ntry, ex2(:), ex5(:), wf6(:,5), n3(:,37), t3x6(:,:,3))
  call prop_A_Q(ntry, wf6(:,5), 18, ZERO, 0_intkind1, wf6(:,6), n2(3))
  call vert_QA_W(ntry, ex1(:), wf6(:,6), wf12(:,20), n3(:,38), t3x12(:,:,20))
  call counter_QA_W(ntry, ex1(:), wf6(:,4), wf12(:,21), n3(:,39), t3x12(:,:,21))
  call counter_WQ_A(ntry, ex4(:), ex1(:), wf6(:,7), n3(:,40), t3x6(:,:,4))
  call prop_Q_A(ntry, wf6(:,7), 9, ZERO, 0_intkind1, wf6(:,8), n2(4))
  call vert_QA_W(ntry, wf6(:,8), ex2(:), wf12(:,22), n3(:,41), t3x12(:,:,22))
  call counter_QA_V_LR(EWctAuu,ntry, ex1(:), ex2(:), wf4(:,6), n3(:,42), t3x4(:,:,6))
  call vert_VV_S(ntry, wf4(:,6), ex5(:), wf12(:,23), n3(:,43), t3x12(:,:,23))
  call counter_QA_Z(EWctVuu,ntry, ex1(:), ex2(:), wf4(:,7), n3(:,44), t3x4(:,:,7))
  call vert_VV_S(ntry, wf4(:,7), ex5(:), wf12(:,24), n3(:,45), t3x12(:,:,24))
  call vert_UV_W(ntry, wf4(:,6), 3, ex5(:), 16, wf12(:,25), n3(:,46), t3x12(:,:,25))
  call vert_UV_W(ntry, wf4(:,7), 3, ex5(:), 16, wf12(:,26), n3(:,47), t3x12(:,:,26))
  call vert_VV_S(ntry, wf4(:,6), ex4(:), wf12(:,27), n3(:,48), t3x12(:,:,27))
  call vert_VV_S(ntry, wf4(:,7), ex4(:), wf12(:,28), n3(:,49), t3x12(:,:,28))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,6), 3, wf12(:,29), n3(:,50), t3x12(:,:,29))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,7), 3, wf12(:,30), n3(:,51), t3x12(:,:,30))
  call vert_SV_V(ntry, ex3(:), wf4(:,7), wf4(:,8), n3(:,52), t3x4(:,:,8))
  call vert_VS_T(ntry, ex5(:), 16, wf3(:,1), 12, wf9(:,3), n3(:,53), t3x9(:,:,3))
  call counter_V_S(EWctXA,ntry, wf4(:,1), 3, wf4(:,9), n2(5))
  call counter_V_S(EWctXZ,ntry, wf4(:,2), 3, wf4(:,10), n2(6))
  call vert_SV_V(ntry, wf3(:,1), ex5(:), wf9(:,4), n3(:,54), t3x9(:,:,4))
  call counter_V_V(EWctAA,ntry, wf4(:,1), 3, wf4(:,11), n2(7))
  call counter_V_V(EWctAZ,ntry, wf4(:,1), 3, wf4(:,12), n2(8))
  call counter_V_V(EWctAZ,ntry, wf4(:,2), 3, wf4(:,13), n2(9))
  call counter_V_V(EWctZZ,ntry, wf4(:,2), 3, wf4(:,14), n2(10))
  call vert_UV_W(ntry, ex5(:), 16, wf3(:,2), 12, wf9(:,5), n3(:,55), t3x9(:,:,5))
  call counter_S_S(EWctPP,ntry, wf3(:,1), 12, wf3(:,9), n2(11))
  call counter_S_V(EWctPW,ntry, wf3(:,1), 12, wf3(:,10), n2(12))
  call counter_V_S(EWctPW,ntry, wf3(:,2), 12, wf3(:,11), n2(13))
  call counter_V_V(EWctWW,ntry, wf3(:,2), 12, wf3(:,12), n2(14))
  call vert_VS_T(ntry, ex4(:), 8, wf3(:,3), 20, wf9(:,6), n3(:,56), t3x9(:,:,6))
  call vert_SV_V(ntry, wf3(:,3), ex4(:), wf9(:,7), n3(:,57), t3x9(:,:,7))
  call vert_UV_W(ntry, wf3(:,4), 20, ex4(:), 8, wf9(:,8), n3(:,58), t3x9(:,:,8))
  call counter_S_S(EWctPP,ntry, wf3(:,3), 20, wf3(:,13), n2(15))
  call counter_S_V(EWctPW,ntry, wf3(:,3), 20, wf3(:,14), n2(16))
  call counter_V_S(EWctPW,ntry, wf3(:,4), 20, wf3(:,15), n2(17))
  call counter_V_V(EWctWW,ntry, wf3(:,4), 20, wf3(:,16), n2(18))
  call vert_TV_S(ntry, ex3(:), 4, wf9(:,1), 24, wf9(:,9), n3(:,59), t3x9(:,:,9))
  call vert_SV_V(ntry, ex3(:), wf9(:,1), wf9(:,10), n3(:,60), t3x9(:,:,10))
  call vert_TV_S(ntry, ex3(:), 4, wf4(:,2), 3, wf4(:,15), n3(:,61), t3x4(:,:,9))
  call counter_V_S(EWctXA,ntry, wf9(:,1), 24, wf9(:,11), n2(19))
  call counter_V_S(EWctXZ,ntry, wf9(:,1), 24, wf9(:,12), n2(20))
  call counter_V_V(EWctAZ,ntry, wf9(:,1), 24, wf9(:,13), n2(21))
  call counter_V_V(EWctZZ,ntry, wf9(:,1), 24, wf9(:,14), n2(22))
  call vert_AW_Q(ntry, ex2(:), wf3(:,4), wf6(:,9), n3(:,62), t3x6(:,:,5))
  call counter_Q_A_LR(EWctdd,ntry, wf6(:,2), 9, wf6(:,10), n2(23))
  call prop_A_Q(ntry, wf6(:,9), 22, ZERO, 0_intkind1, wf6(:,11), n2(24))
  call vert_WQ_A(ntry, wf3(:,2), ex1(:), wf6(:,12), n3(:,63), t3x6(:,:,6))
  call counter_A_Q_LR(EWctdd,ntry, wf6(:,4), 18, wf6(:,13), n2(25))
  call prop_Q_A(ntry, wf6(:,12), 13, ZERO, 0_intkind1, wf6(:,14), n2(26))
  call vert_VV_S(ntry, ex4(:), ex5(:), wf9(:,15), n3(:,64), t3x9(:,:,11))
  call vert_VVS_S(ntry, ex4(:), ex5(:), ex3(:), wf9(:,16), n4(:,1), t4x9(:,:,1))
  call vert_WQ_A(ntry, ex5(:), wf6(:,2), wf18(:,1), n3(:,65), t3x18(:,:,1))
  call prop_Q_A(ntry, wf18(:,1), 25, ZERO, 0_intkind1, wf18(:,2), n2(27))
  call vert_VV_S(ntry, wf3(:,2), ex5(:), wf9(:,17), n3(:,66), t3x9(:,:,12))
  call vert_AW_Q(ntry, wf6(:,4), ex4(:), wf18(:,3), n3(:,67), t3x18(:,:,2))
  call prop_A_Q(ntry, wf18(:,3), 26, ZERO, 0_intkind1, wf18(:,4), n2(28))
  call vert_VV_S(ntry, ex4(:), wf3(:,4), wf9(:,18), n3(:,68), t3x9(:,:,13))
  call vert_VQ_A(ntry, wf9(:,1), ex1(:), wf18(:,5), n3(:,69), t3x18(:,:,3))
  call prop_Q_A(ntry, wf18(:,5), 25, ZERO, 0_intkind1, wf18(:,6), n2(29))
  call vert_ZQ_A(gZu,ntry, wf9(:,1), ex1(:), wf18(:,7), n3(:,70), t3x18(:,:,4))
  call prop_Q_A(ntry, wf18(:,7), 25, ZERO, 0_intkind1, wf18(:,8), n2(30))
  call vert_AV_Q(ntry, ex2(:), wf9(:,1), wf18(:,9), n3(:,71), t3x18(:,:,5))
  call prop_A_Q(ntry, wf18(:,9), 26, ZERO, 0_intkind1, wf18(:,10), n2(31))
  call vert_AZ_Q(gZu,ntry, ex2(:), wf9(:,1), wf18(:,11), n3(:,72), t3x18(:,:,6))
  call prop_A_Q(ntry, wf18(:,11), 26, ZERO, 0_intkind1, wf18(:,12), n2(32))
  call vert_SS_S(ntry, ex3(:), wf9(:,15), wf9(:,19), n3(:,73), t3x9(:,:,14))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    if (do_ct) call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  if (do_ct) M2ct = 0
  if (do_colint) M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    if (do_ct) call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      if (do_colint) call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    if (do_ct) M2ct = M2ct + M2add_ct
    if (do_colint) M2colint = M2colint + M2add_colint
  end do

#if 1 > 0 && 5 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    ind_cc_comb = [2,4,7,5,8]
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 5
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2

  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 3
do i4= 1, 3
do i3= 1, 1
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_SS(nsync, wf3(:,1), wf12(:,1), A(:,1), n3(:,74), t3x36(:,:,1), nhel, den(3))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,2), A(:,2), n3(:,75), t3x36(:,:,2), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,3), A(:,3), n3(:,76), t3x36(:,:,3), nhel, den(3))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,4), A(:,4), n3(:,77), t3x36(:,:,4), nhel, den(5))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,5), A(:,5), n3(:,78), t3x36(:,:,5), nhel, den(7))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,6), A(:,6), n3(:,79), t3x36(:,:,6), nhel, den(8))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,7), A(:,7), n3(:,80), t3x36(:,:,7), nhel, den(7))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,8), A(:,8), n3(:,81), t3x36(:,:,8), nhel, den(8))
    call Hcont_VV(nsync, wf9(:,1), wf4(:,3), A(:,9), n3(:,82), t3x36(:,:,9), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,9), A(:,10), n3(:,83), t3x36(:,:,10), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,10), A(:,11), n3(:,84), t3x36(:,:,11), nhel, den(14))

    call Hcont_SS(nsync, wf3(:,1), wf12(:,11), A(:,12), n3(:,85), t3x36(:,:,12), nhel, den(3))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,12), A(:,13), n3(:,86), t3x36(:,:,13), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,13), A(:,14), n3(:,87), t3x36(:,:,14), nhel, den(3))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,14), A(:,15), n3(:,88), t3x36(:,:,15), nhel, den(5))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,15), A(:,16), n3(:,89), t3x36(:,:,16), nhel, den(7))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,16), A(:,17), n3(:,90), t3x36(:,:,17), nhel, den(8))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,17), A(:,18), n3(:,91), t3x36(:,:,18), nhel, den(7))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,18), A(:,19), n3(:,92), t3x36(:,:,19), nhel, den(8))
    call Hcont_VV(nsync, wf4(:,3), wf9(:,2), A(:,20), n3(:,93), t3x36(:,:,20), nhel, den(10))
    call Hcont_VV(nsync, wf9(:,1), wf4(:,4), A(:,21), n3(:,94), t3x36(:,:,21), nhel, den(16))
    call Hcont_VV(nsync, wf9(:,1), wf4(:,4), A(:,22), n3(:,95), t3x36(:,:,22), nhel, den(17))
    call Hcont_VV(nsync, wf9(:,1), wf4(:,5), A(:,23), n3(:,96), t3x36(:,:,23), nhel, den(18))
    call Hcont_VV(nsync, wf9(:,1), wf4(:,5), A(:,24), n3(:,97), t3x36(:,:,24), nhel, den(10))
    call Hcont_SS(nsync, wf12(:,5), wf3(:,5), A(:,25), n3(:,98), t3x36(:,:,25), nhel, den(7))
    call Hcont_SS(nsync, wf12(:,6), wf3(:,5), A(:,26), n3(:,99), t3x36(:,:,26), nhel, den(8))
    call Hcont_VV(nsync, wf12(:,7), wf3(:,6), A(:,27), n3(:,100), t3x36(:,:,27), nhel, den(7))
    call Hcont_VV(nsync, wf12(:,8), wf3(:,6), A(:,28), n3(:,101), t3x36(:,:,28), nhel, den(8))
    call Hcont_SS(nsync, wf12(:,1), wf3(:,7), A(:,29), n3(:,102), t3x36(:,:,29), nhel, den(3))
    call Hcont_SS(nsync, wf12(:,2), wf3(:,7), A(:,30), n3(:,103), t3x36(:,:,30), nhel, den(5))
    call Hcont_VV(nsync, wf12(:,3), wf3(:,8), A(:,31), n3(:,104), t3x36(:,:,31), nhel, den(3))
    call Hcont_VV(nsync, wf12(:,4), wf3(:,8), A(:,32), n3(:,105), t3x36(:,:,32), nhel, den(5))
    call Hcont_VV(nsync, wf12(:,9), wf3(:,6), A(:,33), n3(:,106), t3x36(:,:,33), nhel, den(12))
    call Hcont_VV(nsync, wf12(:,10), wf3(:,8), A(:,34), n3(:,107), t3x36(:,:,34), nhel, den(14))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,19), A(:,35), n3(:,108), t3x36(:,:,35), nhel, den(12))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,20), A(:,36), n3(:,109), t3x36(:,:,36), nhel, den(14))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,21), A(:,37), n3(:,110), t3x36(:,:,37), nhel, den(14))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,22), A(:,38), n3(:,111), t3x36(:,:,38), nhel, den(12))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,23), A(:,39), n3(:,112), t3x36(:,:,39), nhel, den(3))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,24), A(:,40), n3(:,113), t3x36(:,:,40), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,25), A(:,41), n3(:,114), t3x36(:,:,41), nhel, den(3))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,26), A(:,42), n3(:,115), t3x36(:,:,42), nhel, den(5))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,27), A(:,43), n3(:,116), t3x36(:,:,43), nhel, den(7))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,28), A(:,44), n3(:,117), t3x36(:,:,44), nhel, den(8))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,29), A(:,45), n3(:,118), t3x36(:,:,45), nhel, den(7))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,30), A(:,46), n3(:,119), t3x36(:,:,46), nhel, den(8))
    call Hcont_VV(nsync, wf9(:,1), wf4(:,8), A(:,47), n3(:,120), t3x36(:,:,47), nhel, den(10))
    call Hcont_SS(nsync, wf9(:,3), wf4(:,9), A(:,48), n3(:,121), t3x36(:,:,48), nhel, den(21))
    call Hcont_SS(nsync, wf9(:,3), wf4(:,10), A(:,49), n3(:,122), t3x36(:,:,49), nhel, den(22))
    call Hcont_VV(nsync, wf9(:,4), wf4(:,11), A(:,50), n3(:,123), t3x36(:,:,50), nhel, den(25))
    call Hcont_VV(nsync, wf9(:,4), wf4(:,12), A(:,51), n3(:,124), t3x36(:,:,51), nhel, den(21))
    call Hcont_VV(nsync, wf9(:,4), wf4(:,13), A(:,52), n3(:,125), t3x36(:,:,52), nhel, den(26))
    call Hcont_VV(nsync, wf9(:,4), wf4(:,14), A(:,53), n3(:,126), t3x36(:,:,53), nhel, den(22))
    call Hcont_VV(nsync, wf4(:,11), wf9(:,5), A(:,54), n3(:,127), t3x36(:,:,54), nhel, den(25))
    call Hcont_VV(nsync, wf4(:,12), wf9(:,5), A(:,55), n3(:,128), t3x36(:,:,55), nhel, den(21))
    call Hcont_VV(nsync, wf4(:,13), wf9(:,5), A(:,56), n3(:,129), t3x36(:,:,56), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,14), wf9(:,5), A(:,57), n3(:,130), t3x36(:,:,57), nhel, den(22))
    call Hcont_SS(nsync, wf12(:,1), wf3(:,9), A(:,58), n3(:,131), t3x36(:,:,58), nhel, den(29))
    call Hcont_SS(nsync, wf12(:,2), wf3(:,9), A(:,59), n3(:,132), t3x36(:,:,59), nhel, den(31))
    call Hcont_VV(nsync, wf12(:,3), wf3(:,10), A(:,60), n3(:,133), t3x36(:,:,60), nhel, den(29))
    call Hcont_VV(nsync, wf12(:,4), wf3(:,10), A(:,61), n3(:,134), t3x36(:,:,61), nhel, den(31))
    call Hcont_SS(nsync, wf12(:,1), wf3(:,11), A(:,62), n3(:,135), t3x36(:,:,62), nhel, den(29))
    call Hcont_SS(nsync, wf12(:,2), wf3(:,11), A(:,63), n3(:,136), t3x36(:,:,63), nhel, den(31))
    call Hcont_VV(nsync, wf12(:,3), wf3(:,12), A(:,64), n3(:,137), t3x36(:,:,64), nhel, den(29))
    call Hcont_VV(nsync, wf12(:,4), wf3(:,12), A(:,65), n3(:,138), t3x36(:,:,65), nhel, den(31))
    call Hcont_SS(nsync, wf4(:,9), wf9(:,6), A(:,66), n3(:,139), t3x36(:,:,66), nhel, den(33))
    call Hcont_SS(nsync, wf4(:,10), wf9(:,6), A(:,67), n3(:,140), t3x36(:,:,67), nhel, den(34))
    call Hcont_VV(nsync, wf4(:,11), wf9(:,7), A(:,68), n3(:,141), t3x36(:,:,68), nhel, den(36))
    call Hcont_VV(nsync, wf4(:,12), wf9(:,7), A(:,69), n3(:,142), t3x36(:,:,69), nhel, den(33))
    call Hcont_VV(nsync, wf4(:,13), wf9(:,7), A(:,70), n3(:,143), t3x36(:,:,70), nhel, den(37))
    call Hcont_VV(nsync, wf4(:,14), wf9(:,7), A(:,71), n3(:,144), t3x36(:,:,71), nhel, den(34))
    call Hcont_VV(nsync, wf4(:,11), wf9(:,8), A(:,72), n3(:,145), t3x36(:,:,72), nhel, den(36))
    call Hcont_VV(nsync, wf4(:,12), wf9(:,8), A(:,73), n3(:,146), t3x36(:,:,73), nhel, den(33))
    call Hcont_VV(nsync, wf4(:,13), wf9(:,8), A(:,74), n3(:,147), t3x36(:,:,74), nhel, den(37))
    call Hcont_VV(nsync, wf4(:,14), wf9(:,8), A(:,75), n3(:,148), t3x36(:,:,75), nhel, den(34))
    call Hcont_SS(nsync, wf12(:,5), wf3(:,13), A(:,76), n3(:,149), t3x36(:,:,76), nhel, den(40))
    call Hcont_SS(nsync, wf12(:,6), wf3(:,13), A(:,77), n3(:,150), t3x36(:,:,77), nhel, den(42))
    call Hcont_VV(nsync, wf12(:,7), wf3(:,14), A(:,78), n3(:,151), t3x36(:,:,78), nhel, den(40))
    call Hcont_VV(nsync, wf12(:,8), wf3(:,14), A(:,79), n3(:,152), t3x36(:,:,79), nhel, den(42))
    call Hcont_SS(nsync, wf12(:,5), wf3(:,15), A(:,80), n3(:,153), t3x36(:,:,80), nhel, den(40))
    call Hcont_SS(nsync, wf12(:,6), wf3(:,15), A(:,81), n3(:,154), t3x36(:,:,81), nhel, den(42))
    call Hcont_VV(nsync, wf12(:,7), wf3(:,16), A(:,82), n3(:,155), t3x36(:,:,82), nhel, den(40))
    call Hcont_VV(nsync, wf12(:,8), wf3(:,16), A(:,83), n3(:,156), t3x36(:,:,83), nhel, den(42))
    call Hcont_SS(nsync, wf4(:,9), wf9(:,9), A(:,84), n3(:,157), t3x36(:,:,84), nhel, den(44))
    call Hcont_SS(nsync, wf4(:,10), wf9(:,9), A(:,85), n3(:,158), t3x36(:,:,85), nhel, den(45))
    call Hcont_VV(nsync, wf4(:,12), wf9(:,10), A(:,86), n3(:,159), t3x36(:,:,86), nhel, den(44))
    call Hcont_VV(nsync, wf4(:,14), wf9(:,10), A(:,87), n3(:,160), t3x36(:,:,87), nhel, den(45))
    call Hcont_SS(nsync, wf4(:,15), wf9(:,11), A(:,88), n3(:,161), t3x36(:,:,88), nhel, den(48))
    call Hcont_SS(nsync, wf4(:,15), wf9(:,12), A(:,89), n3(:,162), t3x36(:,:,89), nhel, den(49))
    call Hcont_VV(nsync, wf4(:,3), wf9(:,13), A(:,90), n3(:,163), t3x36(:,:,90), nhel, den(48))
    call Hcont_VV(nsync, wf4(:,3), wf9(:,14), A(:,91), n3(:,164), t3x36(:,:,91), nhel, den(49))
    call Hcont_QA(nsync, wf6(:,10), wf6(:,11), A(:,92), n3(:,165), t3x36(:,:,92), nhel, den(52))
    call Hcont_VV(nsync, wf12(:,9), wf3(:,14), A(:,93), n3(:,166), t3x36(:,:,93), nhel, den(54))
    call Hcont_VV(nsync, wf12(:,9), wf3(:,16), A(:,94), n3(:,167), t3x36(:,:,94), nhel, den(54))
    call Hcont_QA(nsync, wf6(:,13), wf6(:,14), A(:,95), n3(:,168), t3x36(:,:,95), nhel, den(57))
    call Hcont_VV(nsync, wf12(:,10), wf3(:,10), A(:,96), n3(:,169), t3x36(:,:,96), nhel, den(59))
    call Hcont_VV(nsync, wf12(:,10), wf3(:,12), A(:,97), n3(:,170), t3x36(:,:,97), nhel, den(59))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(1) ! M1helarray(1,nhel)
  integer :: empty(0), i

  M1(1)%j = (-A(j,2)%j+A(j,6)%j)*f(4)+(A(j,10)%j+A(j,11)%j)*f(10)+A(j,9)%j*f(20)+(A(j,4)%j+A(j,8)%j)*f(21)+(A(j,1)%j &
       -A(j,5)%j)*f(33)+(A(j,3)%j+A(j,7)%j)*f(34)

  M2(1)%j = A(j,21)%j*f(1)+(A(j,27)%j+A(j,31)%j)*f(2)-A(j,23)%j*f(3)+(-A(j,51)%j+A(j,69)%j)*f(5)+(-A(j,40)%j+A(j,44)%j+A(j,53)%j &
       +A(j,59)%j-A(j,71)%j-A(j,77)%j)*f(6)+(A(j,25)%j-A(j,29)%j)*f(7)+(-A(j,63)%j-A(j,81)%j)*f(8)+(A(j,93)%j-A(j,96)%j)*f(9)+( &
       -A(j,92)%j-A(j,94)%j-A(j,95)%j-A(j,97)%j)*f(11)+(A(j,37)%j+A(j,38)%j)*f(12)+(A(j,35)%j+A(j,36)%j)*f(13)+(A(j,48)%j &
       -A(j,66)%j)*f(14)+(-A(j,49)%j+A(j,67)%j)*f(15)+A(j,84)%j*f(16)+(-A(j,85)%j-A(j,89)%j)*f(17)+(-A(j,61)%j+A(j,79)%j)*f(18) &
       +(A(j,33)%j+A(j,34)%j)*f(19)+A(j,86)%j*f(22)+(A(j,47)%j-A(j,87)%j-A(j,91)%j)*f(23)+(A(j,55)%j+A(j,73)%j)*f(24)+(A(j,42)%j &
       +A(j,46)%j-A(j,57)%j-A(j,65)%j-A(j,75)%j-A(j,83)%j)*f(25)+(-A(j,60)%j+A(j,78)%j)*f(26)+A(j,88)%j*f(27)+(A(j,28)%j &
       +A(j,32)%j)*f(28)-A(j,22)%j*f(29)+A(j,24)%j*f(30)+(-A(j,12)%j+A(j,16)%j)*f(31)+(A(j,13)%j-A(j,17)%j)*f(32)+(-A(j,50)%j &
       -A(j,58)%j+A(j,68)%j+A(j,76)%j)*f(35)+(-A(j,39)%j+A(j,43)%j+A(j,52)%j-A(j,70)%j)*f(36)+(-A(j,54)%j-A(j,64)%j-A(j,72)%j &
       -A(j,82)%j)*f(37)+(-A(j,41)%j-A(j,45)%j+A(j,56)%j+A(j,74)%j)*f(38)+A(j,90)%j*f(39)+(A(j,14)%j+A(j,18)%j)*f(40)+(-A(j,15)%j &
       -A(j,19)%j)*f(41)-A(j,20)%j*f(42)+(A(j,62)%j+A(j,80)%j)*f(43)+(-A(j,26)%j+A(j,30)%j)*f(44)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_uuxhwwx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_uuxhwwx_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(1)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 1
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_uuxhwwx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_uuxhwwx_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu


! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_uuxhwwx_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(1)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 1 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2


! **********************************************************************
#ifdef PRECISION_dp
subroutine hsfamp2(P_scatt, M02, pind_1, pind_2, M2hsf)
#else
subroutine hsfamp2(P_scatt, M02, pind_1, pind_2, M2hsf)
  use ol_loop_storage_pphvv_ew_uuxhwwx_1_/**/DREALKIND, only: &
    & nhflip, helflip, hflip, tsb, pi_flip_bak, pj_flip_bak, nhel
#endif
! M2tree = helicity-summed squared tree matrix element for up anti-up higgs W- W+ -> 0
! M2hsf  = formula (66) of 1011.3918. Tree level
! spin-correlated hard scattering factor for up anti-up higgs W- W+ -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  implicit none
  real(DREALKIND), intent(in) :: P_scatt(0:3,5)
  integer, intent(in) :: pind_1, pind_2
  real(REALKIND), intent(out) :: M02, M2hsf
  real(REALKIND)    :: M2add, M2ct_dummy
  integer :: k

  M2add = 0
  M2hsf = 0

  call amp2(P_scatt, M02, .false., M2ct=M2ct_dummy)
  if((pi_flip_bak .ne. pind_1) .or. (pj_flip_bak .ne. pind_2)) then
    call init_flipped_heltables(pind_1,pind_2)
    pi_flip_bak = pind_1
    pj_flip_bak = pind_2
  end if

  do k = 1, nhflip
    call colintHSF(M1helarray(:,helflip(1,k))%j, M1helarray(:,helflip(2,k))%j, M2add)
    M2hsf = M2hsf + M2add
  end do

  contains

subroutine assign_helicity_flip(ext_wf_hf,ext_wf_t,m)
  use ol_debug, only: ol_fatal
  use KIND_TYPES, only: intkind2
  implicit none
  integer(intkind2), intent(in) :: ext_wf_hf(:), ext_wf_t
  integer, intent(in) :: m
  if(.not. allocated(hflip)) allocate(hflip(size(ext_wf_hf),2))
  if(size(ext_wf_hf) == size(hflip,1)) then
    hflip(:,m) = ext_wf_hf
    tsb = tsb + ext_wf_t
  else
    call ol_fatal("Spin-correlated HSF for pphvv_ew_uuxhwwx_1:" &
      & // "trying to flip particles with different number of helicity states")
  end if
end subroutine assign_helicity_flip

subroutine init_flipped_heltables(i,j)
  use KIND_TYPES, only: intkind2
  use ol_external_pphvv_ew_uuxhwwx_1, only: &
    & external_perm_inv_pphvv_ew_uuxhwwx_1
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helicity_flip_ij
  implicit none
  integer, intent(in) :: i, j
  integer :: r, k, l=0
  tsb = 0

  if(allocated(hflip)) deallocate(hflip)

  do k = 1, 5
    r = external_perm_inv_pphvv_ew_uuxhwwx_1(k)
    if(r == i .or. r == j) then
      l = l+1
      select case(k)
        case(1)
          call assign_helicity_flip(ex1(:)%hf,ex1(1)%t,l)
        case(2)
          call assign_helicity_flip(ex2(:)%hf,ex2(1)%t,l)
        case(3)
          call assign_helicity_flip(ex3(:)%hf,ex3(1)%t,l)
        case(4)
          call assign_helicity_flip(ex4(:)%hf,ex4(1)%t,l)
        case(5)
          call assign_helicity_flip(ex5(:)%hf,ex5(1)%t,l)
      end select
    end if
  end do
  call helicity_flip_ij(36,nhel, M1helarray(1,:)%hf, hflip, tsb, &
      & nhflip, helflip)

end subroutine init_flipped_heltables

! **********************************************************************
subroutine colintHSF(M, Mflip, Mhfcolint)
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_uuxhwwx_1_/**/REALKIND, only: K1
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mflip(1)
  real(REALKIND),    intent(out) :: Mhfcolint
  integer :: i, j
  MHfcolint = 0
  do i = 1, 1
    do j = 1, 1
      Mhfcolint = Mhfcolint + real(conjg(Mflip(i))*K1(i,j)*M(j))
    end do
  end do

end subroutine colintHSF

end subroutine hsfamp2

end module ol_loop_pphvv_ew_uuxhwwx_1_/**/REALKIND
