
module ol_colourmatrix_pphvv_ew_uuxhaz_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(17,1), K2(17,2), KL(17,2), Cas(5) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 3]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 3]

  K2( 1,:) = [ 0, 3]
  K2( 2,:) = [ 0, 0]
  K2( 3,:) = [ 0, 0]
  K2( 4,:) = [ 0, 0]
  K2( 5,:) = [ 0, 0]
  K2( 6,:) = [ 0, 0]
  K2( 7,:) = [ 0, 0]
  K2( 8,:) = [ 0, 0]
  K2( 9,:) = [ 0, 0]
  K2(10,:) = [ 0, 0]
  K2(11,:) = [ 0, 0]
  K2(12,:) = [ 0, 0]
  K2(13,:) = [ 0, 0]
  K2(14,:) = [ 0, 0]
  K2(15,:) = [ 0, 0]
  K2(16,:) = [ 0, 0]
  K2(17,:) = [ 0, 3]

  KL( 1,:) = [ 3, 0]
  KL( 2,:) = [ 0, 0]
  KL( 3,:) = [ 0, 0]
  KL( 4,:) = [ 0, 0]
  KL( 5,:) = [ 0, 0]
  KL( 6,:) = [ 0, 0]
  KL( 7,:) = [ 0, 0]
  KL( 8,:) = [ 0, 0]
  KL( 9,:) = [ 0, 0]
  KL(10,:) = [ 0, 0]
  KL(11,:) = [ 0, 0]
  KL(12,:) = [ 0, 0]
  KL(13,:) = [ 0, 0]
  KL(14,:) = [ 0, 0]
  KL(15,:) = [ 0, 0]
  KL(16,:) = [ 0, 0]
  KL(17,:) = [ 3, 0]

#if 1 > 0
    co = 0
    do k = 1, 5
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_pphvv_ew_uuxhaz_1_/**/REALKIND



module ol_forced_parameters_pphvv_ew_uuxhaz_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (MM /= 0) write(*,101) 'MM = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pphvv_ew_uuxhaz_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_pphvv_ew_uuxhaz_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 24 ! number of helicity configurations
  integer(intkind2), save :: nhel = 24 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 24 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(24) ! physical helicity states
  integer(intkind2), save :: nhflip = 24    ! relevant helicities for helicity-flipped interference
  integer(intkind2), save :: helflip(2,24) ! Table for the helicity-flipped interference
  integer(intkind2), save, allocatable :: hflip(:,:)
  integer(intkind2) :: tsb
  integer, save :: pi_flip_bak = -1, pj_flip_bak = -1
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(54)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(1), ex4(2), ex5(3)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf2(2,1), wf3(3,7), wf4(4,20), wf6(6,8), wf8(8,12), wf12(12,13), wf24(24,30)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(167), c(157)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_pphvv_ew_uuxhaz_1_/**/REALKIND






! **********************************************************************
module ol_loop_pphvv_ew_uuxhaz_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_pphvv_ew_uuxhaz_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = (2*CI*countertermnorm*eQED**5*EWctHAA)/3._/**/REALKIND
    f(  2) = (4*CI*countertermnorm*eQED**5*EWctHZA)/9._/**/REALKIND
    f(  3) = CI*countertermnorm*eQED**5*EWctHZA
    f(  4) = (2*CI*countertermnorm*eQED**5*EWctHZZ)/3._/**/REALKIND
    f(  5) = (2*countertermnorm*eQED**5)/(cw*sw*9._/**/REALKIND)
    f(  6) = (countertermnorm*eQED**5)/(cw*sw*3._/**/REALKIND)
    f(  7) = (2*CI*eQED**3*MW)/(3._/**/REALKIND*cw**2*sw)
    f(  8) = (4*CI*countertermnorm*eQED**5*MW)/(9._/**/REALKIND*cw**2*sw)
    f(  9) = (2*CI*countertermnorm*eQED**5*MW)/(3._/**/REALKIND*cw**2*sw)
    f( 10) = (CI*countertermnorm*eQED**5*MW)/(cw**2*sw)
    f( 11) = (2*CI*countertermnorm*eQED**3*gQCD**2*MW)/(3._/**/REALKIND*cw**2*sw)
    f( 12) = (2*CI*countertermnorm*ctVqq*eQED**3*gQCD**2*MW)/(3._/**/REALKIND*cw**2*sw)
    f( 13) = (2*eQED**5*integralnorm*MW*SwB)/(cw*9._/**/REALKIND)
    f( 14) = (eQED**5*integralnorm*MW*SwB)/(cw*3._/**/REALKIND)
    f( 15) = (eQED**5*integralnorm*MW*SwB)/(cw*2._/**/REALKIND)
    f( 16) = (2*eQED**5*integralnorm*MW*SwB)/(cw*3._/**/REALKIND)
    f( 17) = (2*eQED**5*integralnorm*MH**2*MW*SwB)/(cw*9._/**/REALKIND)
    f( 18) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw*3._/**/REALKIND)
    f( 19) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw*2._/**/REALKIND)
    f( 20) = (4*eQED**5*integralnorm*MW**3*SwB)/(cw**3*9._/**/REALKIND)
    f( 21) = (2*eQED**5*integralnorm*MW**3*SwB)/(cw**3*3._/**/REALKIND)
    f( 22) = (eQED**5*integralnorm*MW**3*SwB)/(cw*3._/**/REALKIND)
    f( 23) = (4*eQED**5*integralnorm*MW**3*SwB)/(cw*9._/**/REALKIND)
    f( 24) = (2*eQED**5*integralnorm*MW**3*SwB)/(cw*3._/**/REALKIND)
    f( 25) = (eQED**5*integralnorm*MW**3*SwB)/cw
    f( 26) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**4*8._/**/REALKIND)
    f( 27) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**4*6._/**/REALKIND)
    f( 28) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**4*3._/**/REALKIND)
    f( 29) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**4*2._/**/REALKIND)
    f( 30) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**4*6._/**/REALKIND)
    f( 31) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**4*4._/**/REALKIND)
    f( 32) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**4*3._/**/REALKIND)
    f( 33) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**4*2._/**/REALKIND)
    f( 34) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*MW*sw**3*12._/**/REALKIND)
    f( 35) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f( 36) = (eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f( 37) = (eQED**5*integralnorm*MH**4*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f( 38) = (eQED**5*integralnorm*MW*SwB)/(sw**3*6._/**/REALKIND)
    f( 39) = (eQED**5*integralnorm*MW*SwB)/(sw**3*4._/**/REALKIND)
    f( 40) = (eQED**5*integralnorm*MW*SwB)/(sw**3*3._/**/REALKIND)
    f( 41) = (eQED**5*integralnorm*MW*SwB)/(sw**3*2._/**/REALKIND)
    f( 42) = (2*eQED**5*integralnorm*MW*SwB)/(sw**3*3._/**/REALKIND)
    f( 43) = (eQED**5*integralnorm*MW*SwB)/sw**3
    f( 44) = (eQED**5*integralnorm*MW*SwB)/(cw**4*sw**3*6._/**/REALKIND)
    f( 45) = (eQED**5*integralnorm*MW*SwB)/(cw**4*sw**3*3._/**/REALKIND)
    f( 46) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw**3*6._/**/REALKIND)
    f( 47) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw**3*4._/**/REALKIND)
    f( 48) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw**3*3._/**/REALKIND)
    f( 49) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw**3*2._/**/REALKIND)
    f( 50) = (cw**2*eQED**5*integralnorm*MW*SwB)/(sw**3*3._/**/REALKIND)
    f( 51) = (cw**2*eQED**5*integralnorm*MW*SwB)/(sw**3*2._/**/REALKIND)
    f( 52) = (2*cw**2*eQED**5*integralnorm*MW*SwB)/(sw**3*3._/**/REALKIND)
    f( 53) = (cw**2*eQED**5*integralnorm*MW*SwB)/sw**3
    f( 54) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw**2*sw**3*4._/**/REALKIND)
    f( 55) = (eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(cw**4*sw**3)
    f( 56) = (2*eQED**5*integralnorm*MW**3*SwB)/(cw**6*sw**3*3._/**/REALKIND)
    f( 57) = (eQED**5*integralnorm*MW**3*SwB)/(cw**2*sw**3*4._/**/REALKIND)
    f( 58) = (eQED**5*integralnorm*MW**3*SwB)/(cw**2*sw**3*2._/**/REALKIND)
    f( 59) = (eQED**5*integralnorm*MW**3*SwB)/(cw**2*sw**3)
    f( 60) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*12._/**/REALKIND)
    f( 61) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*9._/**/REALKIND)
    f( 62) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*6._/**/REALKIND)
    f( 63) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*4._/**/REALKIND)
    f( 64) = (4*eQED**5*integralnorm*MW*SwB)/(cw*sw**2*9._/**/REALKIND)
    f( 65) = (2*eQED**5*integralnorm*MW*SwB)/(cw*sw**2*3._/**/REALKIND)
    f( 66) = (2*cw*eQED**5*integralnorm*MW*SwB)/(sw**2*9._/**/REALKIND)
    f( 67) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**2*3._/**/REALKIND)
    f( 68) = (4*cw*eQED**5*integralnorm*MW*SwB)/(sw**2*9._/**/REALKIND)
    f( 69) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**2*2._/**/REALKIND)
    f( 70) = (2*cw*eQED**5*integralnorm*MW*SwB)/(sw**2*3._/**/REALKIND)
    f( 71) = (cw*eQED**5*integralnorm*MW*SwB)/sw**2
    f( 72) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw*sw**2*4._/**/REALKIND)
    f( 73) = (cw*eQED**5*integralnorm*MH**2*MW*SwB)/(sw**2*3._/**/REALKIND)
    f( 74) = (eQED**5*integralnorm*MW**3*SwB)/(cw**3*sw**2*2._/**/REALKIND)
    f( 75) = (eQED**5*integralnorm*MW**3*SwB)/(cw*sw**2*2._/**/REALKIND)
    f( 76) = (2*eQED**5*integralnorm*MW**3*SwB)/(cw*sw**2*3._/**/REALKIND)
    f( 77) = (2*cw*eQED**5*integralnorm*MW**3*SwB)/(sw**2*3._/**/REALKIND)
    f( 78) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw*3._/**/REALKIND)
    f( 79) = (2*eQED**5*integralnorm*MH**2*SwB)/(MW*sw*3._/**/REALKIND)
    f( 80) = (eQED**5*integralnorm*MW*SwB)/(sw*3._/**/REALKIND)
    f( 81) = (eQED**5*integralnorm*MW*SwB)/(sw*2._/**/REALKIND)
    f( 82) = (2*eQED**5*integralnorm*MW*SwB)/(sw*3._/**/REALKIND)
    f( 83) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw*6._/**/REALKIND)
    f( 84) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw*4._/**/REALKIND)
    f( 85) = (8*eQED**5*integralnorm*MW*SwB)/(cw**2*sw*27._/**/REALKIND)
    f( 86) = (2*eQED**5*integralnorm*MW*SwB)/(cw**2*sw*3._/**/REALKIND)
    f( 87) = (2*eQED**3*gQCD**2*integralnorm*MW*SwB)/(cw**2*sw*3._/**/REALKIND)
    f( 88) = (eQED**5*integralnorm*MH**2*MW*SwB)/(sw*3._/**/REALKIND)
    f( 89) = (eQED**5*integralnorm*MH**2*MW*SwB)/(sw*2._/**/REALKIND)
    f( 90) = (2*eQED**5*integralnorm*MW**3*SwB)/(sw*3._/**/REALKIND)
    f( 91) = (eQED**5*integralnorm*MW**3*SwB)/sw
    f( 92) = (eQED**5*integralnorm*MW**3*SwB)/(cw**2*sw)
    f( 93) = (eQED**5*integralnorm*MW*sw*SwB)/(cw**2*3._/**/REALKIND)
    f( 94) = (eQED**5*integralnorm*MW*sw*SwB)/(cw**2*2._/**/REALKIND)
    f( 95) = (eQED**5*integralnorm*MH**2*MW*sw*SwB)/(cw**2*3._/**/REALKIND)
    f( 96) = (eQED**5*integralnorm*MH**2*MW*sw*SwB)/(cw**2*2._/**/REALKIND)
    f( 97) = (2*eQED**5*integralnorm*MW**3*sw*SwB)/(cw**4*3._/**/REALKIND)
    f( 98) = (eQED**5*integralnorm*MW**3*sw*SwB)/cw**4
    f( 99) = (eQED**5*integralnorm*MW**3*sw*SwB)/(cw**2*2._/**/REALKIND)
    f(100) = (2*eQED**5*integralnorm*MW**3*sw*SwB)/(cw**2*3._/**/REALKIND)
    f(101) = (eQED**5*integralnorm*MW**3*sw*SwB)/cw**2
    f(102) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*9._/**/REALKIND)
    f(103) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*6._/**/REALKIND)
    f(104) = (2*eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*9._/**/REALKIND)
    f(105) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(106) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*3._/**/REALKIND)
    f(107) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*2._/**/REALKIND)
    f(108) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**4*8._/**/REALKIND))
    f(109) = (2*eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**2*9._/**/REALKIND)
    f(110) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**2*3._/**/REALKIND)
    f(111) = (2*eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**2*3._/**/REALKIND)
    f(112) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*9._/**/REALKIND)
    f(113) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*6._/**/REALKIND)
    f(114) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(115) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*3._/**/REALKIND)
    f(116) = (eQED**5*integralnorm*MH**2*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*6._/**/REALKIND)
    f(117) = (eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**2*3._/**/REALKIND)
    f(118) = (eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*3._/**/REALKIND)
    f(119) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(sw**3*4._/**/REALKIND))
    f(120) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**3*8._/**/REALKIND)
    f(121) = (eQED**5*integralnorm*MH**2*SwB*(-(cw**2*sw**2*12._/**/REALKIND) + cw**4*6._/**/REALKIND  &
      + sw**4*6._/**/REALKIND))/(cw**2*MW*sw**3*12._/**/REALKIND*6._/**/REALKIND)
    f(122) = (eQED**5*integralnorm*MH**2*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW*sw**3*4._/**/REALKIND*8._/**/REALKIND)
    f(123) = (eQED**5*integralnorm*MH**2*SwB*(cw**4*3._/**/REALKIND + sw**4*3._/**/REALKIND  &
      - cw**2*sw**2*6._/**/REALKIND))/(cw**2*MW*sw**3*3._/**/REALKIND*6._/**/REALKIND)
    f(124) = (eQED**5*integralnorm*MH**2*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*MW*sw**3*2._/**/REALKIND*4._/**/REALKIND)
    f(125) = (eQED**5*integralnorm*MW*SwB*(cw**4*3._/**/REALKIND + sw**4*3._/**/REALKIND  &
      - cw**2*sw**2*6._/**/REALKIND))/(cw**4*sw**3*3._/**/REALKIND*6._/**/REALKIND)
    f(126) = (eQED**5*integralnorm*MW*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**4*sw**3*2._/**/REALKIND*4._/**/REALKIND)
    f(127) = (eQED**5*integralnorm*MW*SwB*(cw**4 + sw**4 - cw**2*sw**2*2._/**/REALKIND))/(cw**4*sw**3*2._/**/REALKIND)
    f(128) = (eQED**5*integralnorm*MW*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*sw**3*4._/**/REALKIND*8._/**/REALKIND)
    f(129) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw*6._/**/REALKIND)
    f(130) = (eQED**5*integralnorm*MW*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*sw**3*2._/**/REALKIND*4._/**/REALKIND)
    f(131) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(132) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw*2._/**/REALKIND)
    f(133) = (eQED**5*integralnorm*MH**2*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(134) = -((eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(cw**4*sw*2._/**/REALKIND))
    f(135) = (eQED**5*integralnorm*MW**3*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw*2._/**/REALKIND)
    f(136) = (eQED**5*integralnorm*MB**2*SwF)/(cw**2*MW*sw**3*12._/**/REALKIND)
    f(137) = (eQED**5*integralnorm*ML**2*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(138) = (eQED**5*integralnorm*MT**2*SwF)/(cw**2*MW*sw**3*6._/**/REALKIND)
    f(139) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*54._/**/REALKIND)
    f(140) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*27._/**/REALKIND)
    f(141) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*12._/**/REALKIND)
    f(142) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*6._/**/REALKIND)
    f(143) = (eQED**5*integralnorm*ML*SwF)/(cw*MW*sw**2*9._/**/REALKIND)
    f(144) = (eQED**5*integralnorm*ML*SwF)/(cw*MW*sw**2*6._/**/REALKIND)
    f(145) = (eQED**5*integralnorm*ML*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(146) = (2*eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*27._/**/REALKIND)
    f(147) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*6._/**/REALKIND)
    f(148) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*27._/**/REALKIND)
    f(149) = (2*eQED**5*integralnorm*MB*SwF)/(MW*sw*27._/**/REALKIND)
    f(150) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*6._/**/REALKIND)
    f(151) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*3._/**/REALKIND)
    f(152) = (2*eQED**5*integralnorm*ML*SwF)/(MW*sw*9._/**/REALKIND)
    f(153) = (eQED**5*integralnorm*ML*SwF)/(MW*sw*3._/**/REALKIND)
    f(154) = (eQED**5*integralnorm*ML*SwF)/(MW*sw*2._/**/REALKIND)
    f(155) = (4*eQED**5*integralnorm*MT*SwF)/(MW*sw*27._/**/REALKIND)
    f(156) = (eQED**5*integralnorm*MT*SwF)/(MW*sw*3._/**/REALKIND)
    f(157) = (2*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*27._/**/REALKIND)
    f(158) = (4*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*27._/**/REALKIND)
    f(159) = (8*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*27._/**/REALKIND)
    f(160) = (eQED**5*integralnorm*MW*SwF)/(cw**2*sw*3._/**/REALKIND)
    f(161) = (4*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*9._/**/REALKIND)
    f(162) = (16*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*27._/**/REALKIND)
    f(163) = (2*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*3._/**/REALKIND)
    f(164) = (8*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*9._/**/REALKIND)
    f(165) = (eQED**5*integralnorm*MW*SwF)/(cw**2*sw)
    f(166) = (4*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*3._/**/REALKIND)
    f(167) = (2*eQED**5*integralnorm*MW*SwF)/(cw**2*sw)

  c = [ 3*f(13), 3*f(14), 3*f(15), 3*f(16), 3*f(17), 3*f(18), 3*f(19), 3*f(20), 3*f(21), 3*f(22), 3*f(23), 3*f(24), 3*f(25) &
    , 3*f(26), 3*f(27), 3*f(28), 3*f(29), 3*f(30), 3*f(31), 3*f(32), 3*f(33), 3*f(34), 3*f(35), 3*f(36), 3*f(37), 3*f(38), 3*f(39) &
    , 3*f(40), 3*f(41), 3*f(42), 3*f(43), 3*f(44), 3*f(45), 3*f(46), 3*f(47), 3*f(48), 3*f(49), 3*f(50), 3*f(51), 3*f(52), 3*f(53) &
    , 3*f(54), 3*f(55), 3*f(56), 3*f(57), 3*f(58), 3*f(59), 3*f(60), 3*f(61), 3*f(62), 3*f(63), 3*f(64), 3*f(65), 3*f(66), 3*f(67) &
    , 3*f(68), 3*f(69), 3*f(70), 3*f(71), 3*f(72), 3*f(73), 3*f(74), 3*f(75), 3*f(76), 3*f(77), 3*f(78), 3*f(79), 3*f(80), 3*f(81) &
    , 3*f(82), 3*f(83), 3*f(84), 3*f(85), 3*f(86), 4*f(87), 3*f(88), 3*f(89), 3*f(90), 3*f(91), 3*f(92), 3*f(93), 3*f(94), 3*f(95) &
    , 3*f(96), 3*f(97), 3*f(98), 3*f(99), 3*f(100), 3*f(101), 3*f(102), 3*f(103), 3*f(104), 3*f(105), 3*f(106), 3*f(107), 3*f(108) &
    , 3*f(109), 3*f(110), 3*f(111), 3*f(112), 3*f(113), 3*f(114), 3*f(115), 3*f(116), 3*f(117), 3*f(118), 3*f(119), 3*f(120) &
    , 3*f(121), 3*f(122), 3*f(123), 3*f(124), 3*f(125), 3*f(126), 3*f(127), 3*f(128), 3*f(129), 3*f(130), 3*f(131), 3*f(132) &
    , 3*f(133), 3*f(134), 3*f(135), 9*f(136), 3*f(137), 9*f(138), 9*f(139), 9*f(140), 9*f(141), 9*f(142), 3*f(143), 3*f(144) &
    , 3*f(145), 9*f(146), 9*f(147), 9*f(148), 9*f(149), 9*f(150), 9*f(151), 3*f(152), 3*f(153), 3*f(154), 9*f(155), 9*f(156) &
    , 9*f(157), 9*f(158), 9*f(159), 9*f(160), 3*f(161), 9*f(162), 3*f(163), 9*f(163), 3*f(164), 3*f(165), 3*f(166), 9*f(166) &
    , 3*f(167) ]
  c = (1._/**/REALKIND / 3) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,9))+L(6,9))
  den(2) = 1 /((L(5,20) - MZ2)+L(6,20))
  den(4) = 1 /((L(5,10))+L(6,10))
  den(6) = 1 /((L(5,20))+L(6,20))
  den(9) = 1 /((L(5,17))+L(6,17))
  den(10) = 1 /((L(5,12))+L(6,12))
  den(12) = 1 /((L(5,12) - MZ2)+L(6,12))
  den(14) = 1 /((L(5,18))+L(6,18))
  den(17) = 1 /((L(5,22))+L(6,22))
  den(20) = 1 /((L(5,11))+L(6,11))
  den(23) = 1 /((L(5,11) - MZ2)+L(6,11))
  den(26) = 1 /((L(5,21))+L(6,21))
  den(33) = 1 /((L(5,3))+L(6,3))
  den(34) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(35) = 1 /((L(5,7) - MZ2)+L(6,7))
  den(37) = 1 /((L(5,19) - MH2)+L(6,19))
  den(39) = 1 /((L(5,25))+L(6,25))
  den(41) = 1 /((L(5,26))+L(6,26))
  den(43) = 1 /((L(5,19))+L(6,19))
  den(45) = 1 /((L(5,19) - MZ2)+L(6,19))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(2)*den(4)
  den(7) = den(1)*den(6)
  den(8) = den(4)*den(6)
  den(11) = den(9)*den(10)
  den(13) = den(9)*den(12)
  den(15) = den(10)*den(14)
  den(16) = den(12)*den(14)
  den(18) = den(2)*den(17)
  den(19) = den(1)*den(18)
  den(21) = den(1)*den(20)
  den(22) = den(2)*den(21)
  den(24) = den(1)*den(23)
  den(25) = den(2)*den(24)
  den(27) = den(2)*den(26)
  den(28) = den(4)*den(27)
  den(29) = den(4)*den(20)
  den(30) = den(2)*den(29)
  den(31) = den(4)*den(23)
  den(32) = den(2)*den(31)
  den(36) = den(34)*den(35)
  den(38) = den(34)*den(37)
  den(40) = den(1)*den(39)
  den(42) = den(4)*den(41)
  den(44) = den(9)*den(43)
  den(46) = den(9)*den(45)
  den(47) = den(9)*den(39)
  den(48) = den(14)*den(43)
  den(49) = den(14)*den(45)
  den(50) = den(14)*den(41)
  den(51) = den(2)*den(33)
  den(52) = den(2)*den(34)
  den(53) = den(1)*den(14)
  den(54) = den(4)*den(9)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_pphvv_ew_uuxhaz_1_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,30))
  allocate(M1helarray(1,hel_states))
  allocate(M1helarray_ct(2,hel_states))
  allocate(M0_col1_helarray(2,hel_states))
  A(1:hel_states,1:30)%j = 0
  A(1:hel_states,1:30)%e = 0
  A(1:hel_states,1:30)%hf = 0
  A(1:hel_states,1:30)%s = 0
#if 1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(2,hel_states,16))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
#else
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
  use ol_loop_storage_pphvv_ew_uuxhaz_1_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for up anti-up higgs gamma Z -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_pphvv_ew_uuxhaz_1, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_pphvv_ew_uuxhaz_1, only: &
    & external_perm_pphvv_ew_uuxhaz_1, &
    & external_perm_inv_pphvv_ew_uuxhaz_1, &
    & extcomb_perm_pphvv_ew_uuxhaz_1, &
    & average_factor_pphvv_ew_uuxhaz_1
  use ol_external_pphvv_ew_uuxhaz_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_pphvv_ew_uuxhaz_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pphvv_ew_uuxhaz_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_pphvv_ew_uuxhaz_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02
  logical, intent(in) :: qp_kinematics
  real(REALKIND),  intent(out), optional :: M2ct
  real(REALKIND),  intent(out), optional :: M2colint(16)
  real(REALKIND) :: iM2ct
  real(REALKIND) :: iM2colint(16)

  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(1), M2(2)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak
  logical              :: do_ct, do_colint
#if 5 > 3
  integer :: ind_cc_comb(5)
#endif
  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if (present(M2ct)) then
    do_ct = .true.
  else
    do_ct = .false.
  end if

  if (present(M2colint)) then
    do_colint = .true.
  else
    do_colint = .false.
  end if

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, qp_kinematics, M2ct=iM2ct, M2colint=iM2colint)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,30))
  end if

  if (do_ct) call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()
  if (do_ct) call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  if (do_ct) call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, nMH, 0, nMZ ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_pphvv_ew_uuxhaz_1, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_S(P(:,3), rMH, H3, ex3, POLSEL(3),3)
  call pol_wf_V(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rMZ, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_VQ_A(ntry, ex4(:), ex1(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_SV_V(ntry, ex3(:), ex5(:), wf3(:,1), n3(:,2), t3x3(:,:,1))
  call prop_Q_A(ntry, wf4(:,1), 9, ZERO, 0_intkind1, wf4(:,2), n2(1))
  call vert_QA_Z(gZu,ntry, wf4(:,2), ex2(:), wf8(:,1), n3(:,3), t3x8(:,:,1))
  call vert_AV_Q(ntry, ex2(:), ex4(:), wf4(:,3), n3(:,4), t3x4(:,:,2))
  call prop_A_Q(ntry, wf4(:,3), 10, ZERO, 0_intkind1, wf4(:,4), n2(2))
  call vert_QA_Z(gZu,ntry, ex1(:), wf4(:,4), wf8(:,2), n3(:,5), t3x8(:,:,2))
  call counter_SV_V(ntry, ex3(:), ex5(:), wf3(:,2), n3(:,6), t3x3(:,:,2))
  call vert_QA_V(ntry, wf4(:,2), ex2(:), wf8(:,3), n3(:,7), t3x8(:,:,3))
  call vert_QA_V(ntry, ex1(:), wf4(:,4), wf8(:,4), n3(:,8), t3x8(:,:,4))
  call vert_ZQ_A(gZu,ntry, ex5(:), ex1(:), wf6(:,1), n3(:,9), t3x6(:,:,1))
  call counter_SV_V(ntry, ex3(:), ex4(:), wf2(:,1), n3(:,10), t3x2(:,:,1))
  call prop_Q_A(ntry, wf6(:,1), 17, ZERO, 0_intkind1, wf6(:,2), n2(3))
  call vert_QA_V(ntry, wf6(:,2), ex2(:), wf12(:,1), n3(:,11), t3x12(:,:,1))
  call vert_QA_Z(gZu,ntry, wf6(:,2), ex2(:), wf12(:,2), n3(:,12), t3x12(:,:,2))
  call vert_AZ_Q(gZu,ntry, ex2(:), ex5(:), wf6(:,3), n3(:,13), t3x6(:,:,2))
  call prop_A_Q(ntry, wf6(:,3), 18, ZERO, 0_intkind1, wf6(:,4), n2(4))
  call vert_QA_V(ntry, ex1(:), wf6(:,4), wf12(:,3), n3(:,14), t3x12(:,:,3))
  call vert_QA_Z(gZu,ntry, ex1(:), wf6(:,4), wf12(:,4), n3(:,15), t3x12(:,:,4))
  call counter_QA_Z(gZu,ntry, wf4(:,2), ex2(:), wf8(:,5), n3(:,16), t3x8(:,:,5))
  call counter_QA_Z(EWctVuu,ntry, wf4(:,2), ex2(:), wf8(:,6), n3(:,17), t3x8(:,:,6))
  call counter_AV_Q(ntry, ex2(:), ex4(:), wf4(:,5), n3(:,18), t3x4(:,:,3))
  call prop_A_Q(ntry, wf4(:,5), 10, ZERO, 0_intkind1, wf4(:,6), n2(5))
  call vert_QA_Z(gZu,ntry, ex1(:), wf4(:,6), wf8(:,7), n3(:,19), t3x8(:,:,7))
  call counter_AV_Q_LR(EWctAuu,ntry, ex2(:), ex4(:), wf4(:,7), n3(:,20), t3x4(:,:,4))
  call prop_A_Q(ntry, wf4(:,7), 10, ZERO, 0_intkind1, wf4(:,8), n2(6))
  call vert_QA_Z(gZu,ntry, ex1(:), wf4(:,8), wf8(:,8), n3(:,21), t3x8(:,:,8))
  call counter_QA_Z(gZu,ntry, ex1(:), wf4(:,4), wf8(:,9), n3(:,22), t3x8(:,:,9))
  call counter_QA_Z(EWctVuu,ntry, ex1(:), wf4(:,4), wf8(:,10), n3(:,23), t3x8(:,:,10))
  call counter_VQ_A(ntry, ex4(:), ex1(:), wf4(:,9), n3(:,24), t3x4(:,:,5))
  call prop_Q_A(ntry, wf4(:,9), 9, ZERO, 0_intkind1, wf4(:,10), n2(7))
  call vert_QA_Z(gZu,ntry, wf4(:,10), ex2(:), wf8(:,11), n3(:,25), t3x8(:,:,11))
  call counter_VQ_A_LR(EWctAuu,ntry, ex4(:), ex1(:), wf4(:,11), n3(:,26), t3x4(:,:,6))
  call prop_Q_A(ntry, wf4(:,11), 9, ZERO, 0_intkind1, wf4(:,12), n2(8))
  call vert_QA_Z(gZu,ntry, wf4(:,12), ex2(:), wf8(:,12), n3(:,27), t3x8(:,:,12))
  call vert_AZ_Q(gZu,ntry, ex2(:), wf3(:,1), wf6(:,5), n3(:,28), t3x6(:,:,3))
  call counter_Q_A(ctqq,2,ntry, wf4(:,2), 9, wf4(:,13), n2(9))
  call prop_A_Q(ntry, wf6(:,5), 22, ZERO, 0_intkind1, wf6(:,6), n2(10))
  call counter_Q_A_LR(EWctuu,ntry, wf4(:,2), 9, wf4(:,14), n2(11))
  call vert_TV_S(ntry, ex3(:), 4, ex5(:), 16, wf3(:,3), n3(:,29), t3x3(:,:,3))
  call counter_S_V(EWctXA,ntry, wf3(:,3), 20, wf3(:,4), n2(12))
  call counter_S_V(EWctXZ,ntry, wf3(:,3), 20, wf3(:,5), n2(13))
  call counter_V_V(EWctAZ,ntry, wf3(:,1), 20, wf3(:,6), n2(14))
  call counter_V_V(EWctZZ,ntry, wf3(:,1), 20, wf3(:,7), n2(15))
  call vert_ZQ_A(gZu,ntry, wf3(:,1), ex1(:), wf6(:,7), n3(:,30), t3x6(:,:,4))
  call counter_A_Q(ctqq,2,ntry, wf4(:,4), 10, wf4(:,15), n2(16))
  call prop_Q_A(ntry, wf6(:,7), 21, ZERO, 0_intkind1, wf6(:,8), n2(17))
  call counter_A_Q_LR(EWctuu,ntry, wf4(:,4), 10, wf4(:,16), n2(18))
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,17), n3(:,31), t3x4(:,:,7))
  call vert_QA_Z(gZu,ntry, ex1(:), ex2(:), wf4(:,18), n3(:,32), t3x4(:,:,8))
  call vert_TV_S(ntry, ex3(:), 4, wf4(:,18), 3, wf4(:,19), n3(:,33), t3x4(:,:,9))
  call vert_SV_V(ntry, ex3(:), wf4(:,18), wf4(:,20), n3(:,34), t3x4(:,:,10))
  call vert_VV_S(ntry, wf4(:,18), ex5(:), wf12(:,5), n3(:,35), t3x12(:,:,5))
  call vert_ZQ_A(gZu,ntry, ex5(:), wf4(:,2), wf12(:,6), n3(:,36), t3x12(:,:,6))
  call prop_Q_A(ntry, wf12(:,6), 25, ZERO, 0_intkind1, wf12(:,7), n2(19))
  call vert_AZ_Q(gZu,ntry, wf4(:,4), ex5(:), wf12(:,8), n3(:,37), t3x12(:,:,7))
  call prop_A_Q(ntry, wf12(:,8), 26, ZERO, 0_intkind1, wf12(:,9), n2(20))
  call vert_VQ_A(ntry, ex4(:), wf6(:,2), wf12(:,10), n3(:,38), t3x12(:,:,8))
  call prop_Q_A(ntry, wf12(:,10), 25, ZERO, 0_intkind1, wf12(:,11), n2(21))
  call vert_AV_Q(ntry, wf6(:,4), ex4(:), wf12(:,12), n3(:,39), t3x12(:,:,9))
  call prop_A_Q(ntry, wf12(:,12), 26, ZERO, 0_intkind1, wf12(:,13), n2(22))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    if (do_ct) call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  if (do_ct) M2ct = 0
  if (do_colint) M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    if (do_ct) call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      if (do_colint) call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    if (do_ct) M2ct = M2ct + M2add_ct
    if (do_colint) M2colint = M2colint + M2add_colint
  end do

#if 1 > 0 && 5 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    ind_cc_comb = [2,4,7,5,8]
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 5
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2

  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 3
do i4= 1, 2
do i3= 1, 1
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_VV(nsync, wf3(:,1), wf8(:,1), A(:,1), n3(:,40), t3x24(:,:,1), nhel, den(3))
    call Hcont_VV(nsync, wf3(:,1), wf8(:,2), A(:,2), n3(:,41), t3x24(:,:,2), nhel, den(5))

    call Hcont_VV(nsync, wf3(:,2), wf8(:,3), A(:,3), n3(:,42), t3x24(:,:,3), nhel, den(7))
    call Hcont_VV(nsync, wf8(:,1), wf3(:,2), A(:,4), n3(:,43), t3x24(:,:,4), nhel, den(3))
    call Hcont_VV(nsync, wf3(:,2), wf8(:,4), A(:,5), n3(:,44), t3x24(:,:,5), nhel, den(8))
    call Hcont_VV(nsync, wf8(:,2), wf3(:,2), A(:,6), n3(:,45), t3x24(:,:,6), nhel, den(5))
    call Hcont_VV(nsync, wf2(:,1), wf12(:,1), A(:,7), n3(:,46), t3x24(:,:,7), nhel, den(11))
    call Hcont_VV(nsync, wf2(:,1), wf12(:,2), A(:,8), n3(:,47), t3x24(:,:,8), nhel, den(13))
    call Hcont_VV(nsync, wf2(:,1), wf12(:,3), A(:,9), n3(:,48), t3x24(:,:,9), nhel, den(15))
    call Hcont_VV(nsync, wf2(:,1), wf12(:,4), A(:,10), n3(:,49), t3x24(:,:,10), nhel, den(16))
    call Hcont_VV(nsync, wf3(:,1), wf8(:,5), A(:,11), n3(:,50), t3x24(:,:,11), nhel, den(3))
    call Hcont_VV(nsync, wf3(:,1), wf8(:,6), A(:,12), n3(:,51), t3x24(:,:,12), nhel, den(3))
    call Hcont_VV(nsync, wf3(:,1), wf8(:,7), A(:,13), n3(:,52), t3x24(:,:,13), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,1), wf8(:,8), A(:,14), n3(:,53), t3x24(:,:,14), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,1), wf8(:,9), A(:,15), n3(:,54), t3x24(:,:,15), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,1), wf8(:,10), A(:,16), n3(:,55), t3x24(:,:,16), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,1), wf8(:,11), A(:,17), n3(:,56), t3x24(:,:,17), nhel, den(3))
    call Hcont_VV(nsync, wf3(:,1), wf8(:,12), A(:,18), n3(:,57), t3x24(:,:,18), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,13), wf6(:,6), A(:,19), n3(:,58), t3x24(:,:,19), nhel, den(19))
    call Hcont_QA(nsync, wf6(:,6), wf4(:,14), A(:,20), n3(:,59), t3x24(:,:,20), nhel, den(19))
    call Hcont_VV(nsync, wf8(:,3), wf3(:,4), A(:,21), n3(:,60), t3x24(:,:,21), nhel, den(22))
    call Hcont_VV(nsync, wf8(:,1), wf3(:,5), A(:,22), n3(:,61), t3x24(:,:,22), nhel, den(25))
    call Hcont_VV(nsync, wf8(:,3), wf3(:,6), A(:,23), n3(:,62), t3x24(:,:,23), nhel, den(22))
    call Hcont_VV(nsync, wf8(:,1), wf3(:,7), A(:,24), n3(:,63), t3x24(:,:,24), nhel, den(25))
    call Hcont_QA(nsync, wf4(:,15), wf6(:,8), A(:,25), n3(:,64), t3x24(:,:,25), nhel, den(28))
    call Hcont_QA(nsync, wf6(:,8), wf4(:,16), A(:,26), n3(:,65), t3x24(:,:,26), nhel, den(28))
    call Hcont_VV(nsync, wf8(:,4), wf3(:,4), A(:,27), n3(:,66), t3x24(:,:,27), nhel, den(30))
    call Hcont_VV(nsync, wf8(:,2), wf3(:,5), A(:,28), n3(:,67), t3x24(:,:,28), nhel, den(32))
    call Hcont_VV(nsync, wf8(:,4), wf3(:,6), A(:,29), n3(:,68), t3x24(:,:,29), nhel, den(30))
    call Hcont_VV(nsync, wf8(:,2), wf3(:,7), A(:,30), n3(:,69), t3x24(:,:,30), nhel, den(32))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(2) ! M1helarray(2,nhel)
  integer :: empty(0), i

  M1(1)%j = (-A(j,1)%j-A(j,2)%j)*f(7)

  M2(1)%j = (A(j,19)%j+A(j,25)%j)*f(11)+(-A(j,11)%j-A(j,13)%j-A(j,15)%j-A(j,17)%j)*f(12)
  M2(2)%j = (-A(j,7)%j-A(j,9)%j)*f(1)+(A(j,3)%j+A(j,5)%j)*f(2)+(A(j,8)%j+A(j,10)%j)*f(3)+(-A(j,4)%j-A(j,6)%j)*f(4)+(-A(j,21)%j &
       -A(j,27)%j)*f(5)+(A(j,22)%j+A(j,28)%j)*f(6)+(-A(j,23)%j-A(j,29)%j)*f(8)+(-A(j,12)%j-A(j,16)%j+A(j,20)%j+A(j,24)%j+A(j,26)%j &
       +A(j,30)%j)*f(9)+(A(j,14)%j+A(j,18)%j)*f(10)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_uuxhaz_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_uuxhaz_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(2)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 2
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_uuxhaz_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_uuxhaz_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu


! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_uuxhaz_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(2)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 2 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2


! **********************************************************************
#ifdef PRECISION_dp
subroutine hsfamp2(P_scatt, M02, pind_1, pind_2, M2hsf)
#else
subroutine hsfamp2(P_scatt, M02, pind_1, pind_2, M2hsf)
  use ol_loop_storage_pphvv_ew_uuxhaz_1_/**/DREALKIND, only: &
    & nhflip, helflip, hflip, tsb, pi_flip_bak, pj_flip_bak, nhel
#endif
! M2tree = helicity-summed squared tree matrix element for up anti-up higgs gamma Z -> 0
! M2hsf  = formula (66) of 1011.3918. Tree level
! spin-correlated hard scattering factor for up anti-up higgs gamma Z -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  implicit none
  real(DREALKIND), intent(in) :: P_scatt(0:3,5)
  integer, intent(in) :: pind_1, pind_2
  real(REALKIND), intent(out) :: M02, M2hsf
  real(REALKIND)    :: M2add, M2ct_dummy
  integer :: k

  M2add = 0
  M2hsf = 0

  call amp2(P_scatt, M02, .false., M2ct=M2ct_dummy)
  if((pi_flip_bak .ne. pind_1) .or. (pj_flip_bak .ne. pind_2)) then
    call init_flipped_heltables(pind_1,pind_2)
    pi_flip_bak = pind_1
    pj_flip_bak = pind_2
  end if

  do k = 1, nhflip
    call colintHSF(M1helarray(:,helflip(1,k))%j, M1helarray(:,helflip(2,k))%j, M2add)
    M2hsf = M2hsf + M2add
  end do

  contains

subroutine assign_helicity_flip(ext_wf_hf,ext_wf_t,m)
  use ol_debug, only: ol_fatal
  use KIND_TYPES, only: intkind2
  implicit none
  integer(intkind2), intent(in) :: ext_wf_hf(:), ext_wf_t
  integer, intent(in) :: m
  if(.not. allocated(hflip)) allocate(hflip(size(ext_wf_hf),2))
  if(size(ext_wf_hf) == size(hflip,1)) then
    hflip(:,m) = ext_wf_hf
    tsb = tsb + ext_wf_t
  else
    call ol_fatal("Spin-correlated HSF for pphvv_ew_uuxhaz_1:" &
      & // "trying to flip particles with different number of helicity states")
  end if
end subroutine assign_helicity_flip

subroutine init_flipped_heltables(i,j)
  use KIND_TYPES, only: intkind2
  use ol_external_pphvv_ew_uuxhaz_1, only: &
    & external_perm_inv_pphvv_ew_uuxhaz_1
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helicity_flip_ij
  implicit none
  integer, intent(in) :: i, j
  integer :: r, k, l=0
  tsb = 0

  if(allocated(hflip)) deallocate(hflip)

  do k = 1, 5
    r = external_perm_inv_pphvv_ew_uuxhaz_1(k)
    if(r == i .or. r == j) then
      l = l+1
      select case(k)
        case(1)
          call assign_helicity_flip(ex1(:)%hf,ex1(1)%t,l)
        case(2)
          call assign_helicity_flip(ex2(:)%hf,ex2(1)%t,l)
        case(3)
          call assign_helicity_flip(ex3(:)%hf,ex3(1)%t,l)
        case(4)
          call assign_helicity_flip(ex4(:)%hf,ex4(1)%t,l)
        case(5)
          call assign_helicity_flip(ex5(:)%hf,ex5(1)%t,l)
      end select
    end if
  end do
  call helicity_flip_ij(24,nhel, M1helarray(1,:)%hf, hflip, tsb, &
      & nhflip, helflip)

end subroutine init_flipped_heltables

! **********************************************************************
subroutine colintHSF(M, Mflip, Mhfcolint)
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_uuxhaz_1_/**/REALKIND, only: K1
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mflip(1)
  real(REALKIND),    intent(out) :: Mhfcolint
  integer :: i, j
  MHfcolint = 0
  do i = 1, 1
    do j = 1, 1
      Mhfcolint = Mhfcolint + real(conjg(Mflip(i))*K1(i,j)*M(j))
    end do
  end do

end subroutine colintHSF

end subroutine hsfamp2

end module ol_loop_pphvv_ew_uuxhaz_1_/**/REALKIND
