
module ol_colourmatrix_pphvv_ew_udxhaw_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(17,1), K2(17,2), KL(17,2), Cas(5) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 3]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 3]

  K2( 1,:) = [ 0, 3]
  K2( 2,:) = [ 0, 0]
  K2( 3,:) = [ 0, 0]
  K2( 4,:) = [ 0, 0]
  K2( 5,:) = [ 0, 0]
  K2( 6,:) = [ 0, 0]
  K2( 7,:) = [ 0, 0]
  K2( 8,:) = [ 0, 0]
  K2( 9,:) = [ 0, 0]
  K2(10,:) = [ 0, 0]
  K2(11,:) = [ 0, 0]
  K2(12,:) = [ 0, 0]
  K2(13,:) = [ 0, 0]
  K2(14,:) = [ 0, 0]
  K2(15,:) = [ 0, 0]
  K2(16,:) = [ 0, 0]
  K2(17,:) = [ 0, 3]

  KL( 1,:) = [ 3, 0]
  KL( 2,:) = [ 0, 0]
  KL( 3,:) = [ 0, 0]
  KL( 4,:) = [ 0, 0]
  KL( 5,:) = [ 0, 0]
  KL( 6,:) = [ 0, 0]
  KL( 7,:) = [ 0, 0]
  KL( 8,:) = [ 0, 0]
  KL( 9,:) = [ 0, 0]
  KL(10,:) = [ 0, 0]
  KL(11,:) = [ 0, 0]
  KL(12,:) = [ 0, 0]
  KL(13,:) = [ 0, 0]
  KL(14,:) = [ 0, 0]
  KL(15,:) = [ 0, 0]
  KL(16,:) = [ 0, 0]
  KL(17,:) = [ 3, 0]

#if 1 > 0
    co = 0
    do k = 1, 5
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_pphvv_ew_udxhaw_1_/**/REALKIND



module ol_forced_parameters_pphvv_ew_udxhaw_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (MM /= 0) write(*,101) 'MM = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'
  if (wMW /= 0) write(*,101) 'wMW = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pphvv_ew_udxhaw_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_pphvv_ew_udxhaw_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 24 ! number of helicity configurations
  integer(intkind2), save :: nhel = 24 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 24 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(24) ! physical helicity states
  integer(intkind2), save :: nhflip = 24    ! relevant helicities for helicity-flipped interference
  integer(intkind2), save :: helflip(2,24) ! Table for the helicity-flipped interference
  integer(intkind2), save, allocatable :: hflip(:,:)
  integer(intkind2) :: tsb
  integer, save :: pi_flip_bak = -1, pj_flip_bak = -1
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(61)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(1), ex4(2), ex5(3)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf2(2,1), wf3(3,8), wf4(4,29), wf6(6,25), wf8(8,18), wf12(12,18), wf24(24,70)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(202), c(169)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_pphvv_ew_udxhaw_1_/**/REALKIND






! **********************************************************************
module ol_loop_pphvv_ew_udxhaw_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_pphvv_ew_udxhaw_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = (CI*countertermnorm*eQED**5)/(6._/**/REALKIND*sqrt2*sw**2)
    f(  2) = (CI*countertermnorm*eQED**5)/(3._/**/REALKIND*sqrt2*sw**2)
    f(  3) = (CI*countertermnorm*eQED**5)/(2._/**/REALKIND*sqrt2*sw**2)
    f(  4) = (CI*countertermnorm*cw*eQED**5*EWctHZA)/(sqrt2*sw**2)
    f(  5) = (CI*countertermnorm*eQED**5*EWctPWA)/(2._/**/REALKIND*sqrt2*sw**2)
    f(  6) = (CI*countertermnorm*eQED**5*MH**2)/(2._/**/REALKIND*sqrt2*sw**2)
    f(  7) = (CI*countertermnorm*ctSqq*eQED**3*gQCD**2)/(6._/**/REALKIND*MW*sqrt2*sw**2)
    f(  8) = (CI*countertermnorm*ctSqq*eQED**3*gQCD**2)/(3._/**/REALKIND*MW*sqrt2*sw**2)
    f(  9) = (CI*countertermnorm*ctSqq*eQED**3*gQCD**2)/(2._/**/REALKIND*MW*sqrt2*sw**2)
    f( 10) = (CI*countertermnorm*ctSqq*eQED**3*gQCD**2*MH**2)/(2._/**/REALKIND*MW*sqrt2*sw**2)
    f( 11) = (CI*eQED**3*MW)/(3._/**/REALKIND*sqrt2*sw**2)
    f( 12) = (CI*eQED**3*MW)/(2._/**/REALKIND*sqrt2*sw**2)
    f( 13) = (2*CI*eQED**3*MW)/(3._/**/REALKIND*sqrt2*sw**2)
    f( 14) = (CI*eQED**3*MW)/(sqrt2*sw**2)
    f( 15) = (CI*countertermnorm*eQED**5*MW)/(3._/**/REALKIND*sqrt2*sw**2)
    f( 16) = (CI*countertermnorm*eQED**5*MW)/(2._/**/REALKIND*sqrt2*sw**2)
    f( 17) = (2*CI*countertermnorm*eQED**5*MW)/(3._/**/REALKIND*sqrt2*sw**2)
    f( 18) = (CI*countertermnorm*eQED**5*MW)/(sqrt2*sw**2)
    f( 19) = (CI*countertermnorm*eQED**5*EWctAWW*MW)/(sqrt2*sw**2)
    f( 20) = (CI*countertermnorm*eQED**5*EWctVdu*MW)/(3._/**/REALKIND*sqrt2*sw**2)
    f( 21) = (CI*countertermnorm*eQED**5*EWctVdu*MW)/(2._/**/REALKIND*sqrt2*sw**2)
    f( 22) = (2*CI*countertermnorm*eQED**5*EWctVdu*MW)/(3._/**/REALKIND*sqrt2*sw**2)
    f( 23) = (CI*countertermnorm*eQED**5*EWctVdu*MW)/(sqrt2*sw**2)
    f( 24) = (CI*countertermnorm*eQED**3*gQCD**2*MW)/(3._/**/REALKIND*sqrt2*sw**2)
    f( 25) = (2*CI*countertermnorm*eQED**3*gQCD**2*MW)/(3._/**/REALKIND*sqrt2*sw**2)
    f( 26) = (CI*countertermnorm*ctSqq*eQED**3*gQCD**2*MW)/(sqrt2*sw**2)
    f( 27) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2*MW)/(3._/**/REALKIND*sqrt2*sw**2)
    f( 28) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2*MW)/(2._/**/REALKIND*sqrt2*sw**2)
    f( 29) = (2*CI*countertermnorm*ctVqq*eQED**3*gQCD**2*MW)/(3._/**/REALKIND*sqrt2*sw**2)
    f( 30) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2*MW)/(sqrt2*sw**2)
    f( 31) = (CI*countertermnorm*eQED**5*MW**2)/(sqrt2*sw**2)
    f( 32) = (CI*countertermnorm*eQED**5*EWctHAA)/(3._/**/REALKIND*sqrt2*sw)
    f( 33) = (2*CI*countertermnorm*eQED**5*EWctHAA)/(3._/**/REALKIND*sqrt2*sw)
    f( 34) = (CI*countertermnorm*eQED**5*EWctHAA)/(sqrt2*sw)
    f( 35) = (CI*countertermnorm*eQED**5*EWctHWW)/(3._/**/REALKIND*sqrt2*sw)
    f( 36) = (2*CI*countertermnorm*eQED**5*EWctHWW)/(3._/**/REALKIND*sqrt2*sw)
    f( 37) = (CI*countertermnorm*eQED**5*EWctHWW)/(sqrt2*sw)
    f( 38) = (CI*countertermnorm*eQED**5*EWctHZA)/(sqrt2*sw)
    f( 39) = (CI*countertermnorm*eQED**5*EWctWPH*MW)/(sqrt2*sw)
    f( 40) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sqrt2*6._/**/REALKIND)
    f( 41) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sqrt2*3._/**/REALKIND)
    f( 42) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sqrt2*2._/**/REALKIND)
    f( 43) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw**2*sqrt2*6._/**/REALKIND)
    f( 44) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw**2*sqrt2*3._/**/REALKIND)
    f( 45) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw**2*sqrt2*2._/**/REALKIND)
    f( 46) = (eQED**5*integralnorm*MW**3*SwB)/(cw**4*sqrt2*3._/**/REALKIND)
    f( 47) = (2*eQED**5*integralnorm*MW**3*SwB)/(cw**4*sqrt2*3._/**/REALKIND)
    f( 48) = (eQED**5*integralnorm*MW**3*SwB)/(cw**4*sqrt2)
    f( 49) = (eQED**5*integralnorm*MW**3*SwB)/(cw**2*sqrt2*3._/**/REALKIND)
    f( 50) = (eQED**5*integralnorm*MW**3*SwB)/(cw**2*sqrt2*2._/**/REALKIND)
    f( 51) = (2*eQED**5*integralnorm*MW**3*SwB)/(cw**2*sqrt2*3._/**/REALKIND)
    f( 52) = (eQED**5*integralnorm*MW**3*SwB)/(cw**2*sqrt2)
    f( 53) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sqrt2*sw**4*24._/**/REALKIND)
    f( 54) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sqrt2*sw**4*12._/**/REALKIND)
    f( 55) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sqrt2*sw**4*8._/**/REALKIND)
    f( 56) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sqrt2*sw**4*6._/**/REALKIND)
    f( 57) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sqrt2*sw**4*4._/**/REALKIND)
    f( 58) = (eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(MW*sqrt2*sw**4*8._/**/REALKIND)
    f( 59) = (eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(MW*sqrt2*sw**4*4._/**/REALKIND)
    f( 60) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(MW*sqrt2*sw**4*8._/**/REALKIND)
    f( 61) = (eQED**5*integralnorm*MH**4*SwB)/(MW*sqrt2*sw**4*8._/**/REALKIND)
    f( 62) = (eQED**5*integralnorm*MH**4*SwB)/(MW*sqrt2*sw**4*4._/**/REALKIND)
    f( 63) = (3*eQED**5*integralnorm*lambdaHHH*MH**4*SwB)/(MW*sqrt2*sw**4*8._/**/REALKIND)
    f( 64) = (eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**4*12._/**/REALKIND)
    f( 65) = (eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**4*8._/**/REALKIND)
    f( 66) = (eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**4*6._/**/REALKIND)
    f( 67) = (eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**4*4._/**/REALKIND)
    f( 68) = (eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**4*3._/**/REALKIND)
    f( 69) = (eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**4*2._/**/REALKIND)
    f( 70) = (2*eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**4*3._/**/REALKIND)
    f( 71) = (eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**4)
    f( 72) = (cw**2*eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**4*6._/**/REALKIND)
    f( 73) = (cw**2*eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**4*3._/**/REALKIND)
    f( 74) = (cw**2*eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**4*2._/**/REALKIND)
    f( 75) = (2*cw**2*eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**4*3._/**/REALKIND)
    f( 76) = (cw**2*eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**4)
    f( 77) = (eQED**5*integralnorm*MH**2*MW*SwB)/(sqrt2*sw**4*4._/**/REALKIND)
    f( 78) = (eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(sqrt2*sw**4*2._/**/REALKIND)
    f( 79) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(sqrt2*sw**4*4._/**/REALKIND)
    f( 80) = (eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(sqrt2*sw**4)
    f( 81) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(sqrt2*sw**4*2._/**/REALKIND)
    f( 82) = (eQED**5*integralnorm*MW**3*SwB)/(sqrt2*sw**4*4._/**/REALKIND)
    f( 83) = (eQED**5*integralnorm*MW**3*SwB)/(sqrt2*sw**4*3._/**/REALKIND)
    f( 84) = (eQED**5*integralnorm*MW**3*SwB)/(sqrt2*sw**4*2._/**/REALKIND)
    f( 85) = (2*eQED**5*integralnorm*MW**3*SwB)/(sqrt2*sw**4*3._/**/REALKIND)
    f( 86) = (eQED**5*integralnorm*MW**3*SwB)/(sqrt2*sw**4)
    f( 87) = (eQED**5*integralnorm*MW**3*SwB)/(cw**2*sqrt2*sw**4*4._/**/REALKIND)
    f( 88) = (eQED**5*integralnorm*MW*sqrt2*SwB)/(sw**4*12._/**/REALKIND)
    f( 89) = (eQED**5*integralnorm*MW*sqrt2*SwB)/(sw**4*8._/**/REALKIND)
    f( 90) = (eQED**5*integralnorm*MW*sqrt2*SwB)/(sw**4*6._/**/REALKIND)
    f( 91) = (eQED**5*integralnorm*MW*sqrt2*SwB)/(sw**4*4._/**/REALKIND)
    f( 92) = (eQED**5*integralnorm*MW*SwB)/(cw*sqrt2*sw**3*4._/**/REALKIND)
    f( 93) = (eQED**5*integralnorm*MW*SwB)/(cw*sqrt2*sw**3*3._/**/REALKIND)
    f( 94) = (2*eQED**5*integralnorm*MW*SwB)/(cw*sqrt2*sw**3*3._/**/REALKIND)
    f( 95) = (eQED**5*integralnorm*MW*SwB)/(cw*sqrt2*sw**3)
    f( 96) = (cw*eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**3*3._/**/REALKIND)
    f( 97) = (cw*eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**3*2._/**/REALKIND)
    f( 98) = (2*cw*eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**3*3._/**/REALKIND)
    f( 99) = (cw*eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**3)
    f(100) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sqrt2*sw**2*6._/**/REALKIND)
    f(101) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sqrt2*sw**2*3._/**/REALKIND)
    f(102) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sqrt2*sw**2*2._/**/REALKIND)
    f(103) = (2*eQED**5*integralnorm*MH**2*SwB)/(MW*sqrt2*sw**2*3._/**/REALKIND)
    f(104) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sqrt2*sw**2)
    f(105) = (eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**2*27._/**/REALKIND)
    f(106) = (eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**2*18._/**/REALKIND)
    f(107) = (2*eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**2*27._/**/REALKIND)
    f(108) = (eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**2*9._/**/REALKIND)
    f(109) = (4*eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**2*27._/**/REALKIND)
    f(110) = (eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**2*6._/**/REALKIND)
    f(111) = (2*eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**2*9._/**/REALKIND)
    f(112) = (8*eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**2*27._/**/REALKIND)
    f(113) = (eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**2*3._/**/REALKIND)
    f(114) = (4*eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**2*9._/**/REALKIND)
    f(115) = (eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**2*2._/**/REALKIND)
    f(116) = (2*eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**2*3._/**/REALKIND)
    f(117) = (eQED**5*integralnorm*MW*SwB)/(sqrt2*sw**2)
    f(118) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sqrt2*sw**2*12._/**/REALKIND)
    f(119) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sqrt2*sw**2*6._/**/REALKIND)
    f(120) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sqrt2*sw**2*4._/**/REALKIND)
    f(121) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sqrt2*sw**2*3._/**/REALKIND)
    f(122) = (2*eQED**5*integralnorm*MW*SwB)/(cw**2*sqrt2*sw**2*3._/**/REALKIND)
    f(123) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sqrt2*sw**2)
    f(124) = (eQED**3*gQCD**2*integralnorm*MW*SwB)/(sqrt2*sw**2*3._/**/REALKIND)
    f(125) = (eQED**3*gQCD**2*integralnorm*MW*SwB)/(sqrt2*sw**2*2._/**/REALKIND)
    f(126) = (2*eQED**3*gQCD**2*integralnorm*MW*SwB)/(sqrt2*sw**2*3._/**/REALKIND)
    f(127) = (eQED**3*gQCD**2*integralnorm*MW*SwB)/(sqrt2*sw**2)
    f(128) = (eQED**5*integralnorm*MH**2*MW*SwB)/(sqrt2*sw**2*6._/**/REALKIND)
    f(129) = (eQED**5*integralnorm*MH**2*MW*SwB)/(sqrt2*sw**2*3._/**/REALKIND)
    f(130) = (eQED**5*integralnorm*MH**2*MW*SwB)/(sqrt2*sw**2*2._/**/REALKIND)
    f(131) = (eQED**5*integralnorm*MW**3*SwB)/(sqrt2*sw**2*3._/**/REALKIND)
    f(132) = (eQED**5*integralnorm*MW**3*SwB)/(sqrt2*sw**2*2._/**/REALKIND)
    f(133) = (2*eQED**5*integralnorm*MW**3*SwB)/(sqrt2*sw**2*3._/**/REALKIND)
    f(134) = (eQED**5*integralnorm*MW**3*SwB)/(sqrt2*sw**2)
    f(135) = (eQED**5*integralnorm*MW**3*SwB)/(cw**2*sqrt2*sw**2)
    f(136) = (eQED**5*integralnorm*MW*SwB)/(cw*sqrt2*sw*6._/**/REALKIND)
    f(137) = (eQED**5*integralnorm*MW*SwB)/(cw*sqrt2*sw*3._/**/REALKIND)
    f(138) = (eQED**5*integralnorm*MW*SwB)/(cw*sqrt2*sw*2._/**/REALKIND)
    f(139) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw*sqrt2*sw*2._/**/REALKIND)
    f(140) = (eQED**5*integralnorm*MW**3*SwB)/(cw**3*sqrt2*sw)
    f(141) = (eQED**5*integralnorm*MW**3*SwB)/(cw*sqrt2*sw)
    f(142) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(MW*sqrt2*sw**4*4._/**/REALKIND))
    f(143) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(MW*sqrt2*sw**4*2._/**/REALKIND))
    f(144) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**2*sqrt2*sw**2*12._/**/REALKIND)
    f(145) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(sqrt2*sw**4*12._/**/REALKIND))
    f(146) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**2*sqrt2*sw**2*6._/**/REALKIND)
    f(147) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(sqrt2*sw**4*6._/**/REALKIND))
    f(148) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**2*sqrt2*sw**2*4._/**/REALKIND)
    f(149) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(sqrt2*sw**4*4._/**/REALKIND))
    f(150) = -((eQED**5*integralnorm*MW*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*sqrt2*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(151) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**2*sqrt2*sw**2*2._/**/REALKIND)
    f(152) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sqrt2*sw**4*8._/**/REALKIND)
    f(153) = (eQED**5*integralnorm*MH**2*MW*(cw - sw)*(cw + sw)*SwB)/(cw**2*sqrt2*sw**2*4._/**/REALKIND)
    f(154) = -((eQED**5*integralnorm*MH**2*MW*(cw - sw)*(cw + sw)*SwB)/(sqrt2*sw**4*4._/**/REALKIND))
    f(155) = -((eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(sqrt2*sw**4*4._/**/REALKIND))
    f(156) = (eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(cw**2*sqrt2*sw**2*2._/**/REALKIND)
    f(157) = -((eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(sqrt2*sw**4*2._/**/REALKIND))
    f(158) = (eQED**5*integralnorm*MW**3*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sqrt2*sw**4*8._/**/REALKIND)
    f(159) = (eQED**5*integralnorm*MW**3*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sqrt2*sw**4*4._/**/REALKIND)
    f(160) = (eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(cw**4*sqrt2*sw**2*2._/**/REALKIND)
    f(161) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sqrt2*sw**3*4._/**/REALKIND))
    f(162) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sqrt2*sw**3*2._/**/REALKIND))
    f(163) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sqrt2*sw**3*4._/**/REALKIND))
    f(164) = (eQED**5*integralnorm*MB**2*SwF)/(MW*sqrt2*sw**4*12._/**/REALKIND)
    f(165) = (eQED**5*integralnorm*ML**2*SwF)/(MW*sqrt2*sw**4*4._/**/REALKIND)
    f(166) = (eQED**5*integralnorm*MT**2*SwF)/(MW*sqrt2*sw**4*6._/**/REALKIND)
    f(167) = (eQED**5*integralnorm*sqrt2*SwF)/(MW*sw**4*24._/**/REALKIND)
    f(168) = (eQED**5*integralnorm*sqrt2*SwF)/(MW*sw**4*12._/**/REALKIND)
    f(169) = (eQED**5*integralnorm*sqrt2*SwF)/(MW*sw**4*8._/**/REALKIND)
    f(170) = (eQED**5*integralnorm*MB*sqrt2*SwF)/(MW*sw**4*24._/**/REALKIND)
    f(171) = (eQED**5*integralnorm*MB*sqrt2*SwF)/(MW*sw**4*12._/**/REALKIND)
    f(172) = (eQED**5*integralnorm*MB*sqrt2*SwF)/(MW*sw**4*8._/**/REALKIND)
    f(173) = (eQED**5*integralnorm*MH**2*sqrt2*SwF)/(MW*sw**4*8._/**/REALKIND)
    f(174) = (eQED**5*integralnorm*ML*sqrt2*SwF)/(MW*sw**4*24._/**/REALKIND)
    f(175) = (eQED**5*integralnorm*ML*sqrt2*SwF)/(MW*sw**4*12._/**/REALKIND)
    f(176) = (eQED**5*integralnorm*ML*sqrt2*SwF)/(MW*sw**4*8._/**/REALKIND)
    f(177) = (eQED**5*integralnorm*MH**2*ML*sqrt2*SwF)/(MW*sw**4*8._/**/REALKIND)
    f(178) = (eQED**5*integralnorm*ML**2*sqrt2*SwF)/(MW*sw**4*8._/**/REALKIND)
    f(179) = (eQED**5*integralnorm*MT*sqrt2*SwF)/(MW*sw**4*24._/**/REALKIND)
    f(180) = (eQED**5*integralnorm*MT*sqrt2*SwF)/(MW*sw**4*12._/**/REALKIND)
    f(181) = (eQED**5*integralnorm*MT*sqrt2*SwF)/(MW*sw**4*8._/**/REALKIND)
    f(182) = (eQED**5*integralnorm*MW*sqrt2*SwF)/(sw**4*12._/**/REALKIND)
    f(183) = (eQED**5*integralnorm*MW*sqrt2*SwF)/(sw**4*8._/**/REALKIND)
    f(184) = (eQED**5*integralnorm*MW*sqrt2*SwF)/(sw**4*6._/**/REALKIND)
    f(185) = (eQED**5*integralnorm*MW*sqrt2*SwF)/(sw**4*4._/**/REALKIND)
    f(186) = (eQED**5*integralnorm*MW*sqrt2*SwF)/(sw**4*3._/**/REALKIND)
    f(187) = (eQED**5*integralnorm*MW*sqrt2*SwF)/(sw**4*2._/**/REALKIND)
    f(188) = (eQED**5*integralnorm*ML*MW*sqrt2*SwF)/(sw**4*4._/**/REALKIND)
    f(189) = (cw*eQED**5*integralnorm*MB*SwF)/(MW*sqrt2*sw**3*6._/**/REALKIND)
    f(190) = (cw*eQED**5*integralnorm*ML*SwF)/(MW*sqrt2*sw**3*2._/**/REALKIND)
    f(191) = (cw*eQED**5*integralnorm*MT*SwF)/(MW*sqrt2*sw**3*3._/**/REALKIND)
    f(192) = (eQED**5*integralnorm*MB*SwF)/(MW*sqrt2*sw**2*54._/**/REALKIND)
    f(193) = (eQED**5*integralnorm*MB*SwF)/(MW*sqrt2*sw**2*27._/**/REALKIND)
    f(194) = (eQED**5*integralnorm*MB*SwF)/(MW*sqrt2*sw**2*18._/**/REALKIND)
    f(195) = (eQED**5*integralnorm*MB*SwF)/(MW*sqrt2*sw**2*6._/**/REALKIND)
    f(196) = (eQED**5*integralnorm*ML*SwF)/(MW*sqrt2*sw**2*6._/**/REALKIND)
    f(197) = (eQED**5*integralnorm*ML*SwF)/(MW*sqrt2*sw**2*3._/**/REALKIND)
    f(198) = (eQED**5*integralnorm*ML*SwF)/(MW*sqrt2*sw**2*2._/**/REALKIND)
    f(199) = (2*eQED**5*integralnorm*MT*SwF)/(MW*sqrt2*sw**2*27._/**/REALKIND)
    f(200) = (4*eQED**5*integralnorm*MT*SwF)/(MW*sqrt2*sw**2*27._/**/REALKIND)
    f(201) = (2*eQED**5*integralnorm*MT*SwF)/(MW*sqrt2*sw**2*9._/**/REALKIND)
    f(202) = (eQED**5*integralnorm*MT*SwF)/(MW*sqrt2*sw**2*3._/**/REALKIND)

  c = [ 3*f(40), 3*f(41), 3*f(42), 3*f(43), 3*f(44), 3*f(45), 3*f(46), 3*f(47), 3*f(48), 3*f(49), 3*f(50), 3*f(51), 3*f(52) &
    , 3*f(53), 3*f(54), 3*f(55), 3*f(56), 3*f(57), 3*f(58), 3*f(59), 3*f(60), 3*f(61), 3*f(62), 3*f(63), 3*f(64), 3*f(65), 3*f(66) &
    , 3*f(67), 3*f(68), 3*f(69), 3*f(70), 3*f(71), 3*f(72), 3*f(73), 3*f(74), 3*f(75), 3*f(76), 3*f(77), 3*f(78), 3*f(79), 3*f(80) &
    , 3*f(81), 3*f(82), 3*f(83), 3*f(84), 3*f(85), 3*f(86), 3*f(87), 3*f(88), 3*f(89), 3*f(90), 3*f(91), 3*f(92), 3*f(93), 3*f(94) &
    , 3*f(95), 3*f(96), 3*f(97), 3*f(98), 3*f(99), 3*f(100), 3*f(101), 3*f(102), 3*f(103), 3*f(104), 3*f(105), 3*f(106), 3*f(107) &
    , 3*f(108), 3*f(109), 3*f(110), 3*f(111), 3*f(112), 3*f(113), 3*f(114), 3*f(115), 3*f(116), 3*f(117), 3*f(118), 3*f(119) &
    , 3*f(120), 3*f(121), 3*f(122), 3*f(123), 4*f(124), 4*f(125), 4*f(126), 4*f(127), 3*f(128), 3*f(129), 3*f(130), 3*f(131) &
    , 3*f(132), 3*f(133), 3*f(134), 3*f(135), 3*f(136), 3*f(137), 3*f(138), 3*f(139), 3*f(140), 3*f(141), 3*f(142), 3*f(143) &
    , 3*f(144), 3*f(145), 3*f(146), 3*f(147), 3*f(148), 3*f(149), 3*f(150), 3*f(151), 3*f(152), 3*f(153), 3*f(154), 3*f(155) &
    , 3*f(156), 3*f(157), 3*f(158), 3*f(159), 3*f(160), 3*f(161), 3*f(162), 3*f(163), 9*f(164), 3*f(165), 9*f(166), 9*f(167) &
    , 9*f(168), 9*f(169), 9*f(170), 9*f(171), 9*f(172), 9*f(173), 3*f(174), 3*f(175), 3*f(176), 3*f(177), 3*f(178), 9*f(179) &
    , 9*f(180), 9*f(181), 3*f(182), 9*f(182), 3*f(183), 9*f(183), 3*f(184), 9*f(184), 3*f(185), 9*f(185), 3*f(186), 9*f(186) &
    , 3*f(187), 9*f(187), 3*f(188), 9*f(189), 3*f(190), 9*f(191), 9*f(192), 9*f(193), 9*f(194), 9*f(195), 3*f(196), 3*f(197) &
    , 3*f(198), 9*f(199), 9*f(200), 9*f(201), 9*f(202) ]
  c = (1._/**/REALKIND / 3) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3) - MW2)+L(6,3))
  den(2) = 1 /((L(5,20) - MW2)+L(6,20))
  den(4) = 1 /((L(5,24) - MW2)+L(6,24))
  den(6) = 1 /((L(5,9))+L(6,9))
  den(8) = 1 /((L(5,10))+L(6,10))
  den(10) = 1 /((L(5,28) - MW2)+L(6,28))
  den(12) = 1 /((L(5,12))+L(6,12))
  den(14) = 1 /((L(5,12) - MZ2)+L(6,12))
  den(16) = 1 /((L(5,17))+L(6,17))
  den(19) = 1 /((L(5,18))+L(6,18))
  den(24) = 1 /((L(5,11) - MW2)+L(6,11))
  den(29) = 1 /((L(5,7) - MW2)+L(6,7))
  den(32) = 1 /((L(5,22))+L(6,22))
  den(37) = 1 /((L(5,21))+L(6,21))
  den(42) = 1 /((L(5,19) - MH2)+L(6,19))
  den(44) = 1 /((L(5,19))+L(6,19))
  den(46) = 1 /((L(5,19) - MZ2)+L(6,19))
  den(48) = 1 /((L(5,25))+L(6,25))
  den(50) = 1 /((L(5,26))+L(6,26))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(1)*den(4)
  den(7) = den(2)*den(6)
  den(9) = den(2)*den(8)
  den(11) = den(1)*den(10)
  den(13) = den(1)*den(12)
  den(15) = den(1)*den(14)
  den(17) = den(12)*den(16)
  den(18) = den(14)*den(16)
  den(20) = den(12)*den(19)
  den(21) = den(14)*den(19)
  den(22) = den(2)*den(10)
  den(23) = den(1)*den(22)
  den(25) = den(1)*den(24)
  den(26) = den(2)*den(25)
  den(27) = den(4)*den(10)
  den(28) = den(1)*den(27)
  den(30) = den(1)*den(29)
  den(31) = den(4)*den(30)
  den(33) = den(2)*den(32)
  den(34) = den(6)*den(33)
  den(35) = den(6)*den(24)
  den(36) = den(2)*den(35)
  den(38) = den(2)*den(37)
  den(39) = den(8)*den(38)
  den(40) = den(8)*den(24)
  den(41) = den(2)*den(40)
  den(43) = den(1)*den(42)
  den(45) = den(1)*den(44)
  den(47) = den(1)*den(46)
  den(49) = den(6)*den(48)
  den(51) = den(8)*den(50)
  den(52) = den(16)*den(44)
  den(53) = den(16)*den(46)
  den(54) = den(16)*den(48)
  den(55) = den(19)*den(44)
  den(56) = den(19)*den(46)
  den(57) = den(19)*den(50)
  den(58) = den(4)*den(48)
  den(59) = den(4)*den(50)
  den(60) = den(6)*den(19)
  den(61) = den(8)*den(16)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_pphvv_ew_udxhaw_1_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,70))
  allocate(M1helarray(1,hel_states))
  allocate(M1helarray_ct(2,hel_states))
  allocate(M0_col1_helarray(2,hel_states))
  A(1:hel_states,1:70)%j = 0
  A(1:hel_states,1:70)%e = 0
  A(1:hel_states,1:70)%hf = 0
  A(1:hel_states,1:70)%s = 0
#if 1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(2,hel_states,16))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
#else
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
  use ol_loop_storage_pphvv_ew_udxhaw_1_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for up anti-down higgs gamma W- -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_pphvv_ew_udxhaw_1, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_pphvv_ew_udxhaw_1, only: &
    & external_perm_pphvv_ew_udxhaw_1, &
    & external_perm_inv_pphvv_ew_udxhaw_1, &
    & extcomb_perm_pphvv_ew_udxhaw_1, &
    & average_factor_pphvv_ew_udxhaw_1
  use ol_external_pphvv_ew_udxhaw_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_pphvv_ew_udxhaw_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pphvv_ew_udxhaw_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_pphvv_ew_udxhaw_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02
  logical, intent(in) :: qp_kinematics
  real(REALKIND),  intent(out), optional :: M2ct
  real(REALKIND),  intent(out), optional :: M2colint(16)
  real(REALKIND) :: iM2ct
  real(REALKIND) :: iM2colint(16)

  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(1), M2(2)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak
  logical              :: do_ct, do_colint
#if 5 > 3
  integer :: ind_cc_comb(5)
#endif
  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if (present(M2ct)) then
    do_ct = .true.
  else
    do_ct = .false.
  end if

  if (present(M2colint)) then
    do_colint = .true.
  else
    do_colint = .false.
  end if

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, qp_kinematics, M2ct=iM2ct, M2colint=iM2colint)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,70))
  end if

  if (do_ct) call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()
  if (do_ct) call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  if (do_ct) call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, nMH, 0, nMW ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_pphvv_ew_udxhaw_1, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_S(P(:,3), rMH, H3, ex3, POLSEL(3),3)
  call pol_wf_V(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rMW, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_W(ntry, ex1(:), ex2(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_TV_S(ntry, ex3(:), 4, ex5(:), 16, wf3(:,1), n3(:,2), t3x3(:,:,1))
  call vert_VV_S(ntry, wf4(:,1), ex4(:), wf8(:,1), n3(:,3), t3x8(:,:,1))
  call vert_SV_V(ntry, ex3(:), ex5(:), wf3(:,2), n3(:,4), t3x3(:,:,2))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,1), 3, wf8(:,2), n3(:,5), t3x8(:,:,2))
  call vert_VV_S(ntry, ex4(:), ex5(:), wf6(:,1), n3(:,6), t3x6(:,:,1))
  call vert_TV_S(ntry, ex3(:), 4, wf4(:,1), 3, wf4(:,2), n3(:,7), t3x4(:,:,2))
  call vert_UV_W(ntry, ex5(:), 16, ex4(:), 8, wf6(:,2), n3(:,8), t3x6(:,:,2))
  call vert_SV_V(ntry, ex3(:), wf4(:,1), wf4(:,3), n3(:,9), t3x4(:,:,3))
  call vert_VQ_A(ntry, ex4(:), ex1(:), wf4(:,4), n3(:,10), t3x4(:,:,4))
  call prop_Q_A(ntry, wf4(:,4), 9, ZERO, 0_intkind1, wf4(:,5), n2(1))
  call vert_QA_W(ntry, wf4(:,5), ex2(:), wf8(:,3), n3(:,11), t3x8(:,:,3))
  call vert_AV_Q(ntry, ex2(:), ex4(:), wf4(:,6), n3(:,12), t3x4(:,:,5))
  call prop_A_Q(ntry, wf4(:,6), 10, ZERO, 0_intkind1, wf4(:,7), n2(2))
  call vert_QA_W(ntry, ex1(:), wf4(:,7), wf8(:,4), n3(:,13), t3x8(:,:,4))
  call vert_VVS_S(ntry, ex4(:), ex5(:), ex3(:), wf6(:,3), n4(:,1), t4x6(:,:,1))
  call counter_AQ_S(gPdu,ntry, ex2(:), ex1(:), wf4(:,8), n3(:,14), t3x4(:,:,6))
  call counter_VV_S(ntry, wf4(:,1), ex4(:), wf8(:,5), n3(:,15), t3x8(:,:,5))
  call counter_UV_W(ntry, ex4(:), 8, wf4(:,1), 3, wf8(:,6), n3(:,16), t3x8(:,:,6))
  call counter_VV_S(ntry, ex4(:), ex5(:), wf6(:,4), n3(:,17), t3x6(:,:,3))
  call counter_UV_W(ntry, ex5(:), 16, ex4(:), 8, wf6(:,5), n3(:,18), t3x6(:,:,4))
  call counter_V_S(EWctPW,ntry, wf4(:,1), 3, wf4(:,9), n2(3))
  call counter_TV_S(ntry, ex3(:), 4, wf4(:,1), 3, wf4(:,10), n3(:,19), t3x4(:,:,7))
  call counter_SV_V(ntry, ex3(:), wf4(:,1), wf4(:,11), n3(:,20), t3x4(:,:,8))
  call counter_TV_S(ntry, ex3(:), 4, ex5(:), 16, wf3(:,3), n3(:,21), t3x3(:,:,3))
  call counter_SV_V(ntry, ex3(:), ex5(:), wf3(:,4), n3(:,22), t3x3(:,:,4))
  call counter_SV_V(ntry, ex3(:), ex4(:), wf2(:,1), n3(:,23), t3x2(:,:,1))
  call vert_UV_W(ntry, wf4(:,1), 3, ex5(:), 16, wf12(:,1), n3(:,24), t3x12(:,:,1))
  call vert_WQ_A(ntry, ex5(:), ex1(:), wf6(:,6), n3(:,25), t3x6(:,:,5))
  call prop_Q_A(ntry, wf6(:,6), 17, ZERO, 0_intkind1, wf6(:,7), n2(4))
  call vert_QA_V(ntry, wf6(:,7), ex2(:), wf12(:,2), n3(:,26), t3x12(:,:,2))
  call vert_QA_Z(gZd,ntry, wf6(:,7), ex2(:), wf12(:,3), n3(:,27), t3x12(:,:,3))
  call vert_AW_Q(ntry, ex2(:), ex5(:), wf6(:,8), n3(:,28), t3x6(:,:,6))
  call prop_A_Q(ntry, wf6(:,8), 18, ZERO, 0_intkind1, wf6(:,9), n2(5))
  call vert_QA_V(ntry, ex1(:), wf6(:,9), wf12(:,4), n3(:,29), t3x12(:,:,4))
  call vert_QA_Z(gZu,ntry, ex1(:), wf6(:,9), wf12(:,5), n3(:,30), t3x12(:,:,5))
  call counter_AQ_S(gPdu,ntry, ex2(:), wf4(:,5), wf8(:,7), n3(:,31), t3x8(:,:,7))
  call counter_QA_W(ntry, wf4(:,5), ex2(:), wf8(:,8), n3(:,32), t3x8(:,:,8))
  call counter_AV_Q(ntry, ex2(:), ex4(:), wf4(:,12), n3(:,33), t3x4(:,:,9))
  call prop_A_Q(ntry, wf4(:,12), 10, ZERO, 0_intkind1, wf4(:,13), n2(6))
  call vert_QA_W(ntry, ex1(:), wf4(:,13), wf8(:,9), n3(:,34), t3x8(:,:,9))
  call counter_AV_Q_LR(EWctAdd,ntry, ex2(:), ex4(:), wf4(:,14), n3(:,35), t3x4(:,:,10))
  call prop_A_Q(ntry, wf4(:,14), 10, ZERO, 0_intkind1, wf4(:,15), n2(7))
  call vert_QA_W(ntry, ex1(:), wf4(:,15), wf8(:,10), n3(:,36), t3x8(:,:,10))
  call counter_AQ_S(gPdu,ntry, wf4(:,7), ex1(:), wf8(:,11), n3(:,37), t3x8(:,:,11))
  call counter_QA_W(ntry, ex1(:), wf4(:,7), wf8(:,12), n3(:,38), t3x8(:,:,12))
  call counter_VQ_A(ntry, ex4(:), ex1(:), wf4(:,16), n3(:,39), t3x4(:,:,11))
  call prop_Q_A(ntry, wf4(:,16), 9, ZERO, 0_intkind1, wf4(:,17), n2(8))
  call vert_QA_W(ntry, wf4(:,17), ex2(:), wf8(:,13), n3(:,40), t3x8(:,:,13))
  call counter_VQ_A_LR(EWctAuu,ntry, ex4(:), ex1(:), wf4(:,18), n3(:,41), t3x4(:,:,12))
  call prop_Q_A(ntry, wf4(:,18), 9, ZERO, 0_intkind1, wf4(:,19), n2(9))
  call vert_QA_W(ntry, wf4(:,19), ex2(:), wf8(:,14), n3(:,42), t3x8(:,:,14))
  call vert_VS_T(ntry, ex4(:), 8, wf4(:,8), 3, wf8(:,15), n3(:,43), t3x8(:,:,15))
  call vert_SV_V(ntry, wf4(:,8), ex4(:), wf8(:,16), n3(:,44), t3x8(:,:,16))
  call counter_QA_W(ntry, ex1(:), ex2(:), wf4(:,20), n3(:,45), t3x4(:,:,13))
  call vert_VV_S(ntry, wf4(:,20), ex4(:), wf8(:,17), n3(:,46), t3x8(:,:,17))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,20), 3, wf8(:,18), n3(:,47), t3x8(:,:,18))
  call vert_SS_S(ntry, wf4(:,8), ex3(:), wf4(:,21), n3(:,48), t3x4(:,:,14))
  call vert_ST_V(ntry, wf4(:,8), 3, ex3(:), 4, wf4(:,22), n3(:,49), t3x4(:,:,15))
  call vert_TV_S(ntry, ex3(:), 4, wf4(:,20), 3, wf4(:,23), n3(:,50), t3x4(:,:,16))
  call vert_SV_V(ntry, ex3(:), wf4(:,20), wf4(:,24), n3(:,51), t3x4(:,:,17))
  call vert_TV_S(ntry, wf3(:,1), 20, ex4(:), 8, wf6(:,10), n3(:,52), t3x6(:,:,7))
  call vert_VV_S(ntry, ex4(:), wf3(:,2), wf6(:,11), n3(:,53), t3x6(:,:,8))
  call vert_SV_V(ntry, wf3(:,1), ex4(:), wf6(:,12), n3(:,54), t3x6(:,:,9))
  call counter_V_V(EWctWW,ntry, wf4(:,1), 3, wf4(:,25), n2(10))
  call vert_UV_W(ntry, wf3(:,2), 20, ex4(:), 8, wf6(:,13), n3(:,55), t3x6(:,:,10))
  call counter_S_S(EWctPP,ntry, wf3(:,1), 20, wf3(:,5), n2(11))
  call counter_S_V(EWctPW,ntry, wf3(:,1), 20, wf3(:,6), n2(12))
  call counter_V_S(EWctPW,ntry, wf3(:,2), 20, wf3(:,7), n2(13))
  call counter_V_V(EWctWW,ntry, wf3(:,2), 20, wf3(:,8), n2(14))
  call vert_SS_S(ntry, ex3(:), wf6(:,1), wf6(:,14), n3(:,56), t3x6(:,:,11))
  call vert_TV_S(ntry, ex3(:), 4, wf6(:,2), 24, wf6(:,15), n3(:,57), t3x6(:,:,12))
  call vert_ST_V(ntry, wf6(:,1), 24, ex3(:), 4, wf6(:,16), n3(:,58), t3x6(:,:,13))
  call vert_SV_V(ntry, ex3(:), wf6(:,2), wf6(:,17), n3(:,59), t3x6(:,:,14))
  call counter_S_S(EWctPP,ntry, wf6(:,1), 24, wf6(:,18), n2(15))
  call counter_V_S(EWctPW,ntry, wf6(:,2), 24, wf6(:,19), n2(16))
  call counter_S_V(EWctPW,ntry, wf6(:,1), 24, wf6(:,20), n2(17))
  call counter_V_V(EWctWW,ntry, wf6(:,2), 24, wf6(:,21), n2(18))
  call vert_AW_Q(ntry, ex2(:), wf3(:,2), wf6(:,22), n3(:,60), t3x6(:,:,15))
  call counter_Q_A(ctqq,2,ntry, wf4(:,5), 9, wf4(:,26), n2(19))
  call prop_A_Q(ntry, wf6(:,22), 22, ZERO, 0_intkind1, wf6(:,23), n2(20))
  call counter_Q_A_LR(EWctuu,ntry, wf4(:,5), 9, wf4(:,27), n2(21))
  call vert_WQ_A(ntry, wf3(:,2), ex1(:), wf6(:,24), n3(:,61), t3x6(:,:,16))
  call counter_A_Q(ctqq,1,ntry, wf4(:,7), 10, wf4(:,28), n2(22))
  call prop_Q_A(ntry, wf6(:,24), 21, ZERO, 0_intkind1, wf6(:,25), n2(23))
  call counter_A_Q_LR(EWctdd,ntry, wf4(:,7), 10, wf4(:,29), n2(24))
  call vert_VV_S(ntry, wf4(:,1), ex5(:), wf12(:,6), n3(:,62), t3x12(:,:,6))
  call vert_WQ_A(ntry, ex5(:), wf4(:,5), wf12(:,7), n3(:,63), t3x12(:,:,7))
  call prop_Q_A(ntry, wf12(:,7), 25, ZERO, 0_intkind1, wf12(:,8), n2(25))
  call vert_AW_Q(ntry, wf4(:,7), ex5(:), wf12(:,9), n3(:,64), t3x12(:,:,8))
  call prop_A_Q(ntry, wf12(:,9), 26, ZERO, 0_intkind1, wf12(:,10), n2(26))
  call vert_VQ_A(ntry, ex4(:), wf6(:,7), wf12(:,11), n3(:,65), t3x12(:,:,9))
  call prop_Q_A(ntry, wf12(:,11), 25, ZERO, 0_intkind1, wf12(:,12), n2(27))
  call vert_AV_Q(ntry, wf6(:,9), ex4(:), wf12(:,13), n3(:,66), t3x12(:,:,10))
  call prop_A_Q(ntry, wf12(:,13), 26, ZERO, 0_intkind1, wf12(:,14), n2(28))
  call vert_WQ_A(ntry, wf6(:,2), ex1(:), wf12(:,15), n3(:,67), t3x12(:,:,11))
  call prop_Q_A(ntry, wf12(:,15), 25, ZERO, 0_intkind1, wf12(:,16), n2(29))
  call vert_AW_Q(ntry, ex2(:), wf6(:,2), wf12(:,17), n3(:,68), t3x12(:,:,12))
  call prop_A_Q(ntry, wf12(:,17), 26, ZERO, 0_intkind1, wf12(:,18), n2(30))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    if (do_ct) call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  if (do_ct) M2ct = 0
  if (do_colint) M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    if (do_ct) call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      if (do_colint) call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    if (do_ct) M2ct = M2ct + M2add_ct
    if (do_colint) M2colint = M2colint + M2add_colint
  end do

#if 1 > 0 && 5 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    ind_cc_comb = [2,4,7,5,8]
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 5
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2

  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 3
do i4= 1, 2
do i3= 1, 1
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_SS(nsync, wf3(:,1), wf8(:,1), A(:,1), n3(:,69), t3x24(:,:,1), nhel, den(3))
    call Hcont_VV(nsync, wf3(:,2), wf8(:,2), A(:,2), n3(:,70), t3x24(:,:,2), nhel, den(3))
    call Hcont_SS(nsync, wf6(:,1), wf4(:,2), A(:,3), n3(:,71), t3x24(:,:,3), nhel, den(5))
    call Hcont_VV(nsync, wf6(:,2), wf4(:,3), A(:,4), n3(:,72), t3x24(:,:,4), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,2), wf8(:,3), A(:,5), n3(:,73), t3x24(:,:,5), nhel, den(7))
    call Hcont_VV(nsync, wf3(:,2), wf8(:,4), A(:,6), n3(:,74), t3x24(:,:,6), nhel, den(9))

    call Hcont_SS(nsync, wf6(:,3), wf4(:,8), A(:,7), n3(:,75), t3x24(:,:,7), nhel, den(10))
    call Hcont_SS(nsync, wf3(:,1), wf8(:,5), A(:,8), n3(:,76), t3x24(:,:,8), nhel, den(3))
    call Hcont_VV(nsync, wf3(:,2), wf8(:,6), A(:,9), n3(:,77), t3x24(:,:,9), nhel, den(3))
    call Hcont_SS(nsync, wf4(:,2), wf6(:,4), A(:,10), n3(:,78), t3x24(:,:,10), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,3), wf6(:,5), A(:,11), n3(:,79), t3x24(:,:,11), nhel, den(5))
    call Hcont_SS(nsync, wf6(:,3), wf4(:,9), A(:,12), n3(:,80), t3x24(:,:,12), nhel, den(11))
    call Hcont_SS(nsync, wf6(:,1), wf4(:,10), A(:,13), n3(:,81), t3x24(:,:,13), nhel, den(5))
    call Hcont_VV(nsync, wf6(:,2), wf4(:,11), A(:,14), n3(:,82), t3x24(:,:,14), nhel, den(5))
    call Hcont_SS(nsync, wf8(:,1), wf3(:,3), A(:,15), n3(:,83), t3x24(:,:,15), nhel, den(3))
    call Hcont_VV(nsync, wf8(:,2), wf3(:,4), A(:,16), n3(:,84), t3x24(:,:,16), nhel, den(3))
    call Hcont_VV(nsync, wf2(:,1), wf12(:,1), A(:,17), n3(:,85), t3x24(:,:,17), nhel, den(13))
    call Hcont_VV(nsync, wf2(:,1), wf12(:,1), A(:,18), n3(:,86), t3x24(:,:,18), nhel, den(15))
    call Hcont_VV(nsync, wf8(:,3), wf3(:,4), A(:,19), n3(:,87), t3x24(:,:,19), nhel, den(7))
    call Hcont_VV(nsync, wf8(:,4), wf3(:,4), A(:,20), n3(:,88), t3x24(:,:,20), nhel, den(9))
    call Hcont_VV(nsync, wf2(:,1), wf12(:,2), A(:,21), n3(:,89), t3x24(:,:,21), nhel, den(17))
    call Hcont_VV(nsync, wf2(:,1), wf12(:,3), A(:,22), n3(:,90), t3x24(:,:,22), nhel, den(18))
    call Hcont_VV(nsync, wf2(:,1), wf12(:,4), A(:,23), n3(:,91), t3x24(:,:,23), nhel, den(20))
    call Hcont_VV(nsync, wf2(:,1), wf12(:,5), A(:,24), n3(:,92), t3x24(:,:,24), nhel, den(21))
    call Hcont_SS(nsync, wf3(:,1), wf8(:,7), A(:,25), n3(:,93), t3x24(:,:,25), nhel, den(7))
    call Hcont_VV(nsync, wf3(:,2), wf8(:,8), A(:,26), n3(:,94), t3x24(:,:,26), nhel, den(7))
    call Hcont_VV(nsync, wf3(:,2), wf8(:,8), A(:,27), n3(:,95), t3x24(:,:,27), nhel, den(7))
    call Hcont_VV(nsync, wf3(:,2), wf8(:,9), A(:,28), n3(:,96), t3x24(:,:,28), nhel, den(9))
    call Hcont_VV(nsync, wf3(:,2), wf8(:,10), A(:,29), n3(:,97), t3x24(:,:,29), nhel, den(9))
    call Hcont_SS(nsync, wf3(:,1), wf8(:,11), A(:,30), n3(:,98), t3x24(:,:,30), nhel, den(9))
    call Hcont_VV(nsync, wf3(:,2), wf8(:,12), A(:,31), n3(:,99), t3x24(:,:,31), nhel, den(9))
    call Hcont_VV(nsync, wf3(:,2), wf8(:,12), A(:,32), n3(:,100), t3x24(:,:,32), nhel, den(9))
    call Hcont_VV(nsync, wf3(:,2), wf8(:,13), A(:,33), n3(:,101), t3x24(:,:,33), nhel, den(7))
    call Hcont_VV(nsync, wf3(:,2), wf8(:,14), A(:,34), n3(:,102), t3x24(:,:,34), nhel, den(7))
    call Hcont_SS(nsync, wf3(:,1), wf8(:,15), A(:,35), n3(:,103), t3x24(:,:,35), nhel, den(3))
    call Hcont_VV(nsync, wf3(:,2), wf8(:,16), A(:,36), n3(:,104), t3x24(:,:,36), nhel, den(3))
    call Hcont_SS(nsync, wf3(:,1), wf8(:,17), A(:,37), n3(:,105), t3x24(:,:,37), nhel, den(3))
    call Hcont_SS(nsync, wf3(:,1), wf8(:,17), A(:,38), n3(:,106), t3x24(:,:,38), nhel, den(3))
    call Hcont_VV(nsync, wf3(:,2), wf8(:,18), A(:,39), n3(:,107), t3x24(:,:,39), nhel, den(3))
    call Hcont_VV(nsync, wf3(:,2), wf8(:,18), A(:,40), n3(:,108), t3x24(:,:,40), nhel, den(3))
    call Hcont_SS(nsync, wf6(:,1), wf4(:,21), A(:,41), n3(:,109), t3x24(:,:,41), nhel, den(5))
    call Hcont_VV(nsync, wf6(:,2), wf4(:,22), A(:,42), n3(:,110), t3x24(:,:,42), nhel, den(5))
    call Hcont_SS(nsync, wf6(:,1), wf4(:,23), A(:,43), n3(:,111), t3x24(:,:,43), nhel, den(5))
    call Hcont_SS(nsync, wf6(:,1), wf4(:,23), A(:,44), n3(:,112), t3x24(:,:,44), nhel, den(5))
    call Hcont_VV(nsync, wf6(:,2), wf4(:,24), A(:,45), n3(:,113), t3x24(:,:,45), nhel, den(5))
    call Hcont_VV(nsync, wf6(:,2), wf4(:,24), A(:,46), n3(:,114), t3x24(:,:,46), nhel, den(5))
    call Hcont_SS(nsync, wf4(:,9), wf6(:,10), A(:,47), n3(:,115), t3x24(:,:,47), nhel, den(23))
    call Hcont_SS(nsync, wf4(:,9), wf6(:,11), A(:,48), n3(:,116), t3x24(:,:,48), nhel, den(23))
    call Hcont_VV(nsync, wf6(:,12), wf4(:,25), A(:,49), n3(:,117), t3x24(:,:,49), nhel, den(23))
    call Hcont_VV(nsync, wf4(:,25), wf6(:,13), A(:,50), n3(:,118), t3x24(:,:,50), nhel, den(23))
    call Hcont_SS(nsync, wf8(:,1), wf3(:,5), A(:,51), n3(:,119), t3x24(:,:,51), nhel, den(26))
    call Hcont_VV(nsync, wf8(:,2), wf3(:,6), A(:,52), n3(:,120), t3x24(:,:,52), nhel, den(26))
    call Hcont_SS(nsync, wf8(:,1), wf3(:,7), A(:,53), n3(:,121), t3x24(:,:,53), nhel, den(26))
    call Hcont_VV(nsync, wf8(:,2), wf3(:,8), A(:,54), n3(:,122), t3x24(:,:,54), nhel, den(26))
    call Hcont_SS(nsync, wf4(:,9), wf6(:,14), A(:,55), n3(:,123), t3x24(:,:,55), nhel, den(28))
    call Hcont_SS(nsync, wf4(:,9), wf6(:,15), A(:,56), n3(:,124), t3x24(:,:,56), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,25), wf6(:,16), A(:,57), n3(:,125), t3x24(:,:,57), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,25), wf6(:,17), A(:,58), n3(:,126), t3x24(:,:,58), nhel, den(28))
    call Hcont_SS(nsync, wf4(:,2), wf6(:,18), A(:,59), n3(:,127), t3x24(:,:,59), nhel, den(31))
    call Hcont_SS(nsync, wf4(:,2), wf6(:,19), A(:,60), n3(:,128), t3x24(:,:,60), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,3), wf6(:,20), A(:,61), n3(:,129), t3x24(:,:,61), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,3), wf6(:,21), A(:,62), n3(:,130), t3x24(:,:,62), nhel, den(31))
    call Hcont_QA(nsync, wf4(:,26), wf6(:,23), A(:,63), n3(:,131), t3x24(:,:,63), nhel, den(34))
    call Hcont_QA(nsync, wf6(:,23), wf4(:,27), A(:,64), n3(:,132), t3x24(:,:,64), nhel, den(34))
    call Hcont_VV(nsync, wf8(:,3), wf3(:,6), A(:,65), n3(:,133), t3x24(:,:,65), nhel, den(36))
    call Hcont_VV(nsync, wf8(:,3), wf3(:,8), A(:,66), n3(:,134), t3x24(:,:,66), nhel, den(36))
    call Hcont_QA(nsync, wf4(:,28), wf6(:,25), A(:,67), n3(:,135), t3x24(:,:,67), nhel, den(39))
    call Hcont_QA(nsync, wf6(:,25), wf4(:,29), A(:,68), n3(:,136), t3x24(:,:,68), nhel, den(39))
    call Hcont_VV(nsync, wf8(:,4), wf3(:,6), A(:,69), n3(:,137), t3x24(:,:,69), nhel, den(41))
    call Hcont_VV(nsync, wf8(:,4), wf3(:,8), A(:,70), n3(:,138), t3x24(:,:,70), nhel, den(41))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(2) ! M1helarray(2,nhel)
  integer :: empty(0), i

  M1(1)%j = A(j,6)%j*f(11)+(-A(j,1)%j+A(j,3)%j)*f(12)-A(j,5)%j*f(13)+(-A(j,2)%j-A(j,4)%j)*f(14)

  M2(1)%j = A(j,30)%j*f(7)-A(j,25)%j*f(8)+(A(j,7)%j-A(j,35)%j-A(j,42)%j)*f(9)+A(j,41)%j*f(10)-A(j,67)%j*f(24)+A(j,63)%j*f(25) &
       +A(j,36)%j*f(26)+(A(j,28)%j+A(j,31)%j)*f(27)+(-A(j,37)%j+A(j,43)%j)*f(28)+(-A(j,26)%j-A(j,33)%j)*f(29)+(-A(j,39)%j &
       -A(j,45)%j)*f(30)
  M2(2)%j = -(A(j,69)%j*f(1))+A(j,65)%j*f(2)+(-A(j,12)%j+A(j,47)%j+A(j,52)%j+A(j,56)%j-A(j,60)%j)*f(3)+A(j,18)%j*f(4)+(A(j,8)%j &
       -A(j,10)%j)*f(5)-A(j,55)%j*f(6)+(-A(j,68)%j-A(j,70)%j)*f(15)+(A(j,49)%j+A(j,51)%j-A(j,57)%j-A(j,59)%j)*f(16)+(A(j,64)%j &
       +A(j,66)%j)*f(17)+(A(j,29)%j+A(j,34)%j+A(j,50)%j+A(j,54)%j+A(j,58)%j+A(j,62)%j)*f(18)+(-A(j,9)%j-A(j,11)%j)*f(19) &
       +A(j,32)%j*f(20)+(-A(j,38)%j+A(j,44)%j)*f(21)-A(j,27)%j*f(22)+(-A(j,40)%j-A(j,46)%j)*f(23)+(-A(j,48)%j-A(j,53)%j &
       -A(j,61)%j)*f(31)+A(j,21)%j*f(32)-A(j,23)%j*f(33)-A(j,17)%j*f(34)+A(j,20)%j*f(35)-A(j,19)%j*f(36)+(-A(j,14)%j &
       -A(j,16)%j)*f(37)+(A(j,22)%j+A(j,24)%j)*f(38)+(-A(j,13)%j+A(j,15)%j)*f(39)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_udxhaw_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_udxhaw_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(2)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 2
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_udxhaw_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_udxhaw_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu


! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_udxhaw_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(2)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 2 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2


! **********************************************************************
#ifdef PRECISION_dp
subroutine hsfamp2(P_scatt, M02, pind_1, pind_2, M2hsf)
#else
subroutine hsfamp2(P_scatt, M02, pind_1, pind_2, M2hsf)
  use ol_loop_storage_pphvv_ew_udxhaw_1_/**/DREALKIND, only: &
    & nhflip, helflip, hflip, tsb, pi_flip_bak, pj_flip_bak, nhel
#endif
! M2tree = helicity-summed squared tree matrix element for up anti-down higgs gamma W- -> 0
! M2hsf  = formula (66) of 1011.3918. Tree level
! spin-correlated hard scattering factor for up anti-down higgs gamma W- -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  implicit none
  real(DREALKIND), intent(in) :: P_scatt(0:3,5)
  integer, intent(in) :: pind_1, pind_2
  real(REALKIND), intent(out) :: M02, M2hsf
  real(REALKIND)    :: M2add, M2ct_dummy
  integer :: k

  M2add = 0
  M2hsf = 0

  call amp2(P_scatt, M02, .false., M2ct=M2ct_dummy)
  if((pi_flip_bak .ne. pind_1) .or. (pj_flip_bak .ne. pind_2)) then
    call init_flipped_heltables(pind_1,pind_2)
    pi_flip_bak = pind_1
    pj_flip_bak = pind_2
  end if

  do k = 1, nhflip
    call colintHSF(M1helarray(:,helflip(1,k))%j, M1helarray(:,helflip(2,k))%j, M2add)
    M2hsf = M2hsf + M2add
  end do

  contains

subroutine assign_helicity_flip(ext_wf_hf,ext_wf_t,m)
  use ol_debug, only: ol_fatal
  use KIND_TYPES, only: intkind2
  implicit none
  integer(intkind2), intent(in) :: ext_wf_hf(:), ext_wf_t
  integer, intent(in) :: m
  if(.not. allocated(hflip)) allocate(hflip(size(ext_wf_hf),2))
  if(size(ext_wf_hf) == size(hflip,1)) then
    hflip(:,m) = ext_wf_hf
    tsb = tsb + ext_wf_t
  else
    call ol_fatal("Spin-correlated HSF for pphvv_ew_udxhaw_1:" &
      & // "trying to flip particles with different number of helicity states")
  end if
end subroutine assign_helicity_flip

subroutine init_flipped_heltables(i,j)
  use KIND_TYPES, only: intkind2
  use ol_external_pphvv_ew_udxhaw_1, only: &
    & external_perm_inv_pphvv_ew_udxhaw_1
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helicity_flip_ij
  implicit none
  integer, intent(in) :: i, j
  integer :: r, k, l=0
  tsb = 0

  if(allocated(hflip)) deallocate(hflip)

  do k = 1, 5
    r = external_perm_inv_pphvv_ew_udxhaw_1(k)
    if(r == i .or. r == j) then
      l = l+1
      select case(k)
        case(1)
          call assign_helicity_flip(ex1(:)%hf,ex1(1)%t,l)
        case(2)
          call assign_helicity_flip(ex2(:)%hf,ex2(1)%t,l)
        case(3)
          call assign_helicity_flip(ex3(:)%hf,ex3(1)%t,l)
        case(4)
          call assign_helicity_flip(ex4(:)%hf,ex4(1)%t,l)
        case(5)
          call assign_helicity_flip(ex5(:)%hf,ex5(1)%t,l)
      end select
    end if
  end do
  call helicity_flip_ij(24,nhel, M1helarray(1,:)%hf, hflip, tsb, &
      & nhflip, helflip)

end subroutine init_flipped_heltables

! **********************************************************************
subroutine colintHSF(M, Mflip, Mhfcolint)
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_udxhaw_1_/**/REALKIND, only: K1
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mflip(1)
  real(REALKIND),    intent(out) :: Mhfcolint
  integer :: i, j
  MHfcolint = 0
  do i = 1, 1
    do j = 1, 1
      Mhfcolint = Mhfcolint + real(conjg(Mflip(i))*K1(i,j)*M(j))
    end do
  end do

end subroutine colintHSF

end subroutine hsfamp2

end module ol_loop_pphvv_ew_udxhaw_1_/**/REALKIND
