
module ol_colourmatrix_pphvv_ew_bbxhzz_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(17,1), K2(17,2), KL(17,2), Cas(5) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 3]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 3]

  K2( 1,:) = [ 0, 3]
  K2( 2,:) = [ 0, 0]
  K2( 3,:) = [ 0, 0]
  K2( 4,:) = [ 0, 0]
  K2( 5,:) = [ 0, 0]
  K2( 6,:) = [ 0, 0]
  K2( 7,:) = [ 0, 0]
  K2( 8,:) = [ 0, 0]
  K2( 9,:) = [ 0, 0]
  K2(10,:) = [ 0, 0]
  K2(11,:) = [ 0, 0]
  K2(12,:) = [ 0, 0]
  K2(13,:) = [ 0, 0]
  K2(14,:) = [ 0, 0]
  K2(15,:) = [ 0, 0]
  K2(16,:) = [ 0, 0]
  K2(17,:) = [ 0, 3]

  KL( 1,:) = [ 3, 0]
  KL( 2,:) = [ 0, 0]
  KL( 3,:) = [ 0, 0]
  KL( 4,:) = [ 0, 0]
  KL( 5,:) = [ 0, 0]
  KL( 6,:) = [ 0, 0]
  KL( 7,:) = [ 0, 0]
  KL( 8,:) = [ 0, 0]
  KL( 9,:) = [ 0, 0]
  KL(10,:) = [ 0, 0]
  KL(11,:) = [ 0, 0]
  KL(12,:) = [ 0, 0]
  KL(13,:) = [ 0, 0]
  KL(14,:) = [ 0, 0]
  KL(15,:) = [ 0, 0]
  KL(16,:) = [ 0, 0]
  KL(17,:) = [ 3, 0]

#if 1 > 0
    co = 0
    do k = 1, 5
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_pphvv_ew_bbxhzz_1_/**/REALKIND



module ol_forced_parameters_pphvv_ew_bbxhzz_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (MM /= 0) write(*,101) 'MM = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pphvv_ew_bbxhzz_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_pphvv_ew_bbxhzz_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 36 ! number of helicity configurations
  integer(intkind2), save :: nhel = 36 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 36 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(36) ! physical helicity states
  integer(intkind2), save :: nhflip = 36    ! relevant helicities for helicity-flipped interference
  integer(intkind2), save :: helflip(2,36) ! Table for the helicity-flipped interference
  integer(intkind2), save, allocatable :: hflip(:,:)
  integer(intkind2) :: tsb
  integer, save :: pi_flip_bak = -1, pj_flip_bak = -1
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(154)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(1), ex4(3), ex5(3)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf2(2,16), wf3(3,20), wf4(4,31), wf6(6,80), wf9(9,10), wf12(12,68), wf18(18,20), wf36(36,220)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(594), c(551)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_pphvv_ew_bbxhzz_1_/**/REALKIND






! **********************************************************************
module ol_loop_pphvv_ew_bbxhzz_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_pphvv_ew_bbxhzz_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = (CI*countertermnorm*eQED**5*EWctHZA)/3._/**/REALKIND
    f(  2) = CI*countertermnorm*eQED**5*EWctHZZ
    f(  3) = (CI*countertermnorm*eQED**5*MB)/MW
    f(  4) = (countertermnorm*eQED**5*MB)/(cw**3*sw**3*4._/**/REALKIND)
    f(  5) = (CI*eQED**3*MB)/(8._/**/REALKIND*cw**2*MW*sw**3)
    f(  6) = (CI*eQED**3*MB)/(4._/**/REALKIND*cw**2*MW*sw**3)
    f(  7) = (CI*countertermnorm*eQED**5*MB)/(8._/**/REALKIND*cw**2*MW*sw**3)
    f(  8) = (CI*countertermnorm*eQED**5*MB)/(4._/**/REALKIND*cw**2*MW*sw**3)
    f(  9) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(8._/**/REALKIND*cw**2*MW*sw**3)
    f( 10) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(4._/**/REALKIND*cw**2*MW*sw**3)
    f( 11) = (CI*eQED**3*MB**2)/(4._/**/REALKIND*cw**2*MW*sw**3)
    f( 12) = (CI*countertermnorm*eQED**5*MB**2)/(4._/**/REALKIND*cw**2*MW*sw**3)
    f( 13) = (CI*countertermnorm*eQED**3*gQCD**2*MB**2)/(4._/**/REALKIND*cw**2*MW*sw**3)
    f( 14) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB**2)/(4._/**/REALKIND*cw**2*MW*sw**3)
    f( 15) = (3*CI*countertermnorm*eQED**5*EWctHHH*MB*MH**2)/(4._/**/REALKIND*cw**2*MW*sw**3)
    f( 16) = (3*CI*eQED**3*lambdaHHH*MB*MH**2)/(4._/**/REALKIND*cw**2*MW*sw**3)
    f( 17) = (3*CI*countertermnorm*eQED**5*lambdaHHH*MB*MH**2)/(4._/**/REALKIND*cw**2*MW*sw**3)
    f( 18) = (3*CI*countertermnorm*ctSbb*eQED**3*gQCD**2*lambdaHHH*MB*MH**2)/(4._/**/REALKIND*cw**2*MW*sw**3)
    f( 19) = (CI*eQED**3*MB*MW)/(2._/**/REALKIND*cw**4*sw**3)
    f( 20) = (CI*countertermnorm*eQED**5*MB*MW)/(2._/**/REALKIND*cw**4*sw**3)
    f( 21) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB*MW)/(2._/**/REALKIND*cw**4*sw**3)
    f( 22) = (countertermnorm*eQED**5*MB)/(cw**2*sw**2*2._/**/REALKIND)
    f( 23) = (CI*countertermnorm*eQED**5*EWctHZZ*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f( 24) = (CI*countertermnorm*eQED**5*EWctHZZ*MB**2)/(4._/**/REALKIND*MW**2*sw**2)
    f( 25) = (3*CI*countertermnorm*eQED**5*EWctHZZ*lambdaHHH*MB*MH**2)/(4._/**/REALKIND*MW**2*sw**2)
    f( 26) = (CI*eQED**3*MB)/(4._/**/REALKIND*cw*MW*sw**2)
    f( 27) = (CI*countertermnorm*eQED**5*MB)/(4._/**/REALKIND*cw**2*MW*sw**2)
    f( 28) = (CI*countertermnorm*eQED**5*MB)/(2._/**/REALKIND*cw**2*MW*sw**2)
    f( 29) = (CI*countertermnorm*eQED**5*MB)/(4._/**/REALKIND*cw*MW*sw**2)
    f( 30) = (countertermnorm*eQED**5*EWctZXH*MB)/(cw*MW*sw**2*4._/**/REALKIND)
    f( 31) = (CI*countertermnorm*eQED**3*gQCD**2*MB)/(4._/**/REALKIND*cw*MW*sw**2)
    f( 32) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(4._/**/REALKIND*cw*MW*sw**2)
    f( 33) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MB)/(4._/**/REALKIND*cw*MW*sw**2)
    f( 34) = (CI*countertermnorm*eQED**5*MB**2)/(2._/**/REALKIND*cw**2*MW*sw**2)
    f( 35) = (3*CI*countertermnorm*eQED**5*lambdaHHH*MB*MH**2)/(2._/**/REALKIND*cw**2*MW*sw**2)
    f( 36) = (CI*countertermnorm*eQED**5*MB*MW)/(cw**4*sw**2)
    f( 37) = (countertermnorm*eQED**5)/(cw*sw*6._/**/REALKIND)
    f( 38) = (countertermnorm*eQED**5)/(cw*sw*2._/**/REALKIND)
    f( 39) = (CI*eQED**3*MB)/(2._/**/REALKIND*MW*sw)
    f( 40) = (CI*countertermnorm*eQED**5*MB)/(2._/**/REALKIND*MW*sw)
    f( 41) = (countertermnorm*eQED**5*MB)/(cw*MW*sw*2._/**/REALKIND)
    f( 42) = (countertermnorm*eQED**5*EWctZXH*MB)/(MW*sw*2._/**/REALKIND)
    f( 43) = (CI*countertermnorm*eQED**5*EWctZZHH*MB)/(2._/**/REALKIND*MW*sw)
    f( 44) = (CI*countertermnorm*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*MW*sw)
    f( 45) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*MW*sw)
    f( 46) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*MW*sw)
    f( 47) = (CI*eQED**3*MW)/(cw**2*sw)
    f( 48) = (CI*countertermnorm*eQED**5*MW)/(3._/**/REALKIND*cw**2*sw)
    f( 49) = (CI*countertermnorm*eQED**5*MW)/(cw**2*sw)
    f( 50) = (CI*countertermnorm*eQED**3*gQCD**2*MW)/(cw**2*sw)
    f( 51) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MW)/(cw**2*sw)
    f( 52) = (eQED**5*integralnorm*MW*SwB)/(cw**3*4._/**/REALKIND)
    f( 53) = (eQED**5*integralnorm*MW*SwB)/(cw*6._/**/REALKIND)
    f( 54) = (eQED**5*integralnorm*MW*SwB)/(cw*2._/**/REALKIND)
    f( 55) = (eQED**5*integralnorm*MB*MW*SwB)/(cw*2._/**/REALKIND)
    f( 56) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw*6._/**/REALKIND)
    f( 57) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw*2._/**/REALKIND)
    f( 58) = (eQED**5*integralnorm*MW**3*SwB)/(cw**3*3._/**/REALKIND)
    f( 59) = (eQED**5*integralnorm*MW**3*SwB)/cw**3
    f( 60) = (eQED**5*integralnorm*MW**3*SwB)/(cw*3._/**/REALKIND)
    f( 61) = (eQED**5*integralnorm*MW**3*SwB)/cw
    f( 62) = (eQED**5*integralnorm*MB**2*SwB)/(cw**2*MW**3*sw**5*8._/**/REALKIND)
    f( 63) = (eQED**5*integralnorm*MB**3*SwB)/(cw**2*MW**3*sw**5*32._/**/REALKIND)
    f( 64) = (eQED**5*integralnorm*MB**3*SwB)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f( 65) = (eQED**5*integralnorm*MB**4*SwB)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f( 66) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f( 67) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*MW**3*sw**5*8._/**/REALKIND)
    f( 68) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**2*MW**3*sw**5*32._/**/REALKIND)
    f( 69) = (3*eQED**5*integralnorm*MB*MH**2*SwB)/(cw**2*MW**3*sw**5*32._/**/REALKIND)
    f( 70) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**2*MW**3*sw**5*8._/**/REALKIND)
    f( 71) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(cw**2*MW**3*sw**5*32._/**/REALKIND)
    f( 72) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f( 73) = (3*eQED**5*integralnorm*MB**2*MH**2*SwB)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f( 74) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(cw**2*MW**3*sw**5*32._/**/REALKIND)
    f( 75) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f( 76) = (eQED**5*integralnorm*MB**3*MH**2*SwB)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f( 77) = (3*eQED**5*integralnorm*lambdaHHH*MB**3*MH**2*SwB)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f( 78) = (eQED**5*integralnorm*MH**4*SwB)/(cw**2*MW**3*sw**5*8._/**/REALKIND)
    f( 79) = (3*eQED**5*integralnorm*lambdaHHH*MH**4*SwB)/(cw**2*MW**3*sw**5*8._/**/REALKIND)
    f( 80) = (eQED**5*integralnorm*MB*MH**4*SwB)/(cw**2*MW**3*sw**5*64._/**/REALKIND)
    f( 81) = (eQED**5*integralnorm*MB*MH**4*SwB)/(cw**2*MW**3*sw**5*32._/**/REALKIND)
    f( 82) = (eQED**5*integralnorm*MB*MH**4*SwB)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f( 83) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**4*SwB)/(cw**2*MW**3*sw**5*32._/**/REALKIND)
    f( 84) = (9*eQED**5*integralnorm*lambdaHHH*MB*MH**4*SwB)/(cw**2*MW**3*sw**5*32._/**/REALKIND)
    f( 85) = (9*eQED**5*integralnorm*lambdaHHH**2*MB*MH**4*SwB)/(cw**2*MW**3*sw**5*64._/**/REALKIND)
    f( 86) = (9*eQED**5*integralnorm*lambdaHHH**2*MB*MH**4*SwB)/(cw**2*MW**3*sw**5*32._/**/REALKIND)
    f( 87) = (9*eQED**5*integralnorm*lambdaHHH**2*MB*MH**4*SwB)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f( 88) = (eQED**5*integralnorm*MB**2*MH**4*SwB)/(cw**2*MW**3*sw**5*32._/**/REALKIND)
    f( 89) = (eQED**5*integralnorm*MB**2*MH**4*SwB)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f( 90) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**4*SwB)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f( 91) = (9*eQED**5*integralnorm*lambdaHHH**2*MB**2*MH**4*SwB)/(cw**2*MW**3*sw**5*32._/**/REALKIND)
    f( 92) = (9*eQED**5*integralnorm*lambdaHHH**2*MB**2*MH**4*SwB)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f( 93) = (eQED**5*integralnorm*MB*MH**6*SwB)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f( 94) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**6*SwB)/(cw**2*MW**3*sw**5*32._/**/REALKIND)
    f( 95) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**6*SwB)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f( 96) = (27*eQED**5*integralnorm*lambdaHHH**3*MB*MH**6*SwB)/(cw**2*MW**3*sw**5*32._/**/REALKIND)
    f( 97) = (27*eQED**5*integralnorm*lambdaHHH**3*MB*MH**6*SwB)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f( 98) = (eQED**5*integralnorm*MT*SwB)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f( 99) = (eQED**5*integralnorm*MT*SwB)/(cw**2*MW**3*sw**5*8._/**/REALKIND)
    f(100) = (eQED**5*integralnorm*MB*MT*SwB)/(cw**2*MW**3*sw**5*8._/**/REALKIND)
    f(101) = (eQED**5*integralnorm*MH**2*MT*SwB)/(cw**2*MW**3*sw**5*8._/**/REALKIND)
    f(102) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(cw**2*MW**3*sw**5*8._/**/REALKIND)
    f(103) = (eQED**5*integralnorm*MT**2*SwB)/(cw**2*MW**3*sw**5*8._/**/REALKIND)
    f(104) = (eQED**5*integralnorm*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(105) = (eQED**5*integralnorm*SwB)/(cw**2*MW*sw**5*16._/**/REALKIND)
    f(106) = (eQED**5*integralnorm*SwB)/(cw**2*MW*sw**5*8._/**/REALKIND)
    f(107) = (cw**2*eQED**5*integralnorm*SwB)/(MW*sw**5*4._/**/REALKIND)
    f(108) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**5*16._/**/REALKIND)
    f(109) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(110) = (eQED**5*integralnorm*MB*SwB)/(cw**4*MW*sw**5*32._/**/REALKIND)
    f(111) = (eQED**5*integralnorm*MB*SwB)/(cw**4*MW*sw**5*16._/**/REALKIND)
    f(112) = (eQED**5*integralnorm*MB*SwB)/(cw**4*MW*sw**5*8._/**/REALKIND)
    f(113) = (eQED**5*integralnorm*MB*SwB)/(cw**2*MW*sw**5*32._/**/REALKIND)
    f(114) = (eQED**5*integralnorm*MB*SwB)/(cw**2*MW*sw**5*16._/**/REALKIND)
    f(115) = (eQED**5*integralnorm*MB*SwB)/(cw**2*MW*sw**5*8._/**/REALKIND)
    f(116) = (cw**2*eQED**5*integralnorm*MB*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(117) = (cw**2*eQED**5*integralnorm*MB*SwB)/(MW*sw**5*4._/**/REALKIND)
    f(118) = (eQED**5*integralnorm*MB**2*SwB)/(cw**4*MW*sw**5*16._/**/REALKIND)
    f(119) = (eQED**5*integralnorm*MB**2*SwB)/(cw**4*MW*sw**5*8._/**/REALKIND)
    f(120) = (eQED**5*integralnorm*MB**2*SwB)/(cw**2*MW*sw**5*16._/**/REALKIND)
    f(121) = (eQED**5*integralnorm*MB**2*SwB)/(cw**2*MW*sw**5*8._/**/REALKIND)
    f(122) = (cw**2*eQED**5*integralnorm*MB**2*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(123) = (cw**2*eQED**5*integralnorm*MB**2*SwB)/(MW*sw**5*4._/**/REALKIND)
    f(124) = (eQED**5*integralnorm*MB**3*SwB)/(cw**4*MW*sw**5*8._/**/REALKIND)
    f(125) = (eQED**5*integralnorm*MH**2*SwB)/(cw**4*MW*sw**5*4._/**/REALKIND)
    f(126) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*MW*sw**5*8._/**/REALKIND)
    f(127) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(cw**2*MW*sw**5*8._/**/REALKIND)
    f(128) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**4*MW*sw**5*16._/**/REALKIND)
    f(129) = (3*eQED**5*integralnorm*MB*MH**2*SwB)/(cw**4*MW*sw**5*8._/**/REALKIND)
    f(130) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**2*MW*sw**5*16._/**/REALKIND)
    f(131) = (cw**2*eQED**5*integralnorm*MB*MH**2*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(132) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**4*MW*sw**5*16._/**/REALKIND)
    f(133) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**4*MW*sw**5*8._/**/REALKIND)
    f(134) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**2*MW*sw**5*16._/**/REALKIND)
    f(135) = (3*cw**2*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(136) = (3*cw**2*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW*sw**5*4._/**/REALKIND)
    f(137) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(cw**4*MW*sw**5*8._/**/REALKIND)
    f(138) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(cw**4*MW*sw**5*8._/**/REALKIND)
    f(139) = (eQED**5*integralnorm*MB*MH**4*SwB)/(cw**4*MW*sw**5*16._/**/REALKIND)
    f(140) = (eQED**5*integralnorm*MB*MH**4*SwB)/(cw**4*MW*sw**5*8._/**/REALKIND)
    f(141) = (9*eQED**5*integralnorm*lambdaHHH**2*MB*MH**4*SwB)/(cw**4*MW*sw**5*16._/**/REALKIND)
    f(142) = (9*eQED**5*integralnorm*lambdaHHH**2*MB*MH**4*SwB)/(cw**4*MW*sw**5*8._/**/REALKIND)
    f(143) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(144) = (eQED**5*integralnorm*MT*SwB)/(cw**4*MW*sw**5*4._/**/REALKIND)
    f(145) = (eQED**5*integralnorm*MT*SwB)/(cw**2*MW*sw**5*16._/**/REALKIND)
    f(146) = (eQED**5*integralnorm*MT*SwB)/(cw**2*MW*sw**5*8._/**/REALKIND)
    f(147) = (cw**2*eQED**5*integralnorm*MT*SwB)/(MW*sw**5*4._/**/REALKIND)
    f(148) = (eQED**5*integralnorm*MB*MT*SwB)/(cw**2*MW*sw**5*8._/**/REALKIND)
    f(149) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(cw**2*MW*sw**5*8._/**/REALKIND)
    f(150) = (eQED**5*integralnorm*MT**2*SwB)/(cw**2*MW*sw**5*8._/**/REALKIND)
    f(151) = (eQED**5*integralnorm*MW*SwB)/(sw**5*2._/**/REALKIND)
    f(152) = (eQED**5*integralnorm*MW*SwB)/(cw**4*sw**5*4._/**/REALKIND)
    f(153) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw**5*8._/**/REALKIND)
    f(154) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw**5*4._/**/REALKIND)
    f(155) = (cw**2*eQED**5*integralnorm*MW*SwB)/(sw**5*2._/**/REALKIND)
    f(156) = (eQED**5*integralnorm*MB*MW*SwB)/(sw**5*16._/**/REALKIND)
    f(157) = (eQED**5*integralnorm*MB*MW*SwB)/(sw**5*4._/**/REALKIND)
    f(158) = (eQED**5*integralnorm*MB*MW*SwB)/(sw**5*2._/**/REALKIND)
    f(159) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**6*sw**5*32._/**/REALKIND)
    f(160) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**6*sw**5*16._/**/REALKIND)
    f(161) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**6*sw**5*8._/**/REALKIND)
    f(162) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**6*sw**5*4._/**/REALKIND)
    f(163) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**4*sw**5*8._/**/REALKIND)
    f(164) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**2*sw**5*32._/**/REALKIND)
    f(165) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**2*sw**5*16._/**/REALKIND)
    f(166) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**2*sw**5*8._/**/REALKIND)
    f(167) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**2*sw**5*4._/**/REALKIND)
    f(168) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**2*sw**5*2._/**/REALKIND)
    f(169) = (cw**2*eQED**5*integralnorm*MB*MW*SwB)/(sw**5*8._/**/REALKIND)
    f(170) = (cw**2*eQED**5*integralnorm*MB*MW*SwB)/(sw**5*2._/**/REALKIND)
    f(171) = (eQED**5*integralnorm*MB**2*MW*SwB)/(cw**6*sw**5*16._/**/REALKIND)
    f(172) = (eQED**5*integralnorm*MB**2*MW*SwB)/(cw**6*sw**5*8._/**/REALKIND)
    f(173) = (eQED**5*integralnorm*MB**2*MW*SwB)/(cw**6*sw**5*4._/**/REALKIND)
    f(174) = (eQED**5*integralnorm*MB**2*MW*SwB)/(cw**2*sw**5*16._/**/REALKIND)
    f(175) = (eQED**5*integralnorm*MB**2*MW*SwB)/(cw**2*sw**5*4._/**/REALKIND)
    f(176) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(cw**2*sw**5*4._/**/REALKIND)
    f(177) = (eQED**5*integralnorm*MB*MH**2*MW*SwB)/(cw**2*sw**5*16._/**/REALKIND)
    f(178) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MW*SwB)/(cw**6*sw**5*16._/**/REALKIND)
    f(179) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MW*SwB)/(cw**6*sw**5*8._/**/REALKIND)
    f(180) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MW*SwB)/(cw**6*sw**5*4._/**/REALKIND)
    f(181) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MW*SwB)/(cw**2*sw**5*16._/**/REALKIND)
    f(182) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MW*SwB)/(cw**2*sw**5*4._/**/REALKIND)
    f(183) = (eQED**5*integralnorm*MT*MW*SwB)/(cw**4*sw**5*4._/**/REALKIND)
    f(184) = (eQED**5*integralnorm*MT*MW*SwB)/(cw**2*sw**5*4._/**/REALKIND)
    f(185) = (eQED**5*integralnorm*MW**3*SwB)/(cw**4*sw**5*2._/**/REALKIND)
    f(186) = (eQED**5*integralnorm*MW**3*SwB)/(cw**2*sw**5*2._/**/REALKIND)
    f(187) = (eQED**5*integralnorm*MB*MW**3*SwB)/(cw**8*sw**5*16._/**/REALKIND)
    f(188) = (eQED**5*integralnorm*MB*MW**3*SwB)/(cw**8*sw**5*8._/**/REALKIND)
    f(189) = (eQED**5*integralnorm*MB*MW**3*SwB)/(cw**8*sw**5*4._/**/REALKIND)
    f(190) = (eQED**5*integralnorm*MB*MW**3*SwB)/(cw**8*sw**5*2._/**/REALKIND)
    f(191) = (eQED**5*integralnorm*MB*MW**3*SwB)/(cw**4*sw**5*8._/**/REALKIND)
    f(192) = (eQED**5*integralnorm*MB*MW**3*SwB)/(cw**4*sw**5*2._/**/REALKIND)
    f(193) = (eQED**5*integralnorm*MB*MW**3*SwB)/(cw**2*sw**5*16._/**/REALKIND)
    f(194) = (eQED**5*integralnorm*MB*MW**3*SwB)/(cw**2*sw**5*2._/**/REALKIND)
    f(195) = (eQED**5*integralnorm*MB*SwB)/(cw*MW**3*sw**4*8._/**/REALKIND)
    f(196) = (eQED**5*integralnorm*MB**3*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(197) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(198) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(199) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(200) = (eQED**5*integralnorm*MB*MH**4*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(201) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**4*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(202) = (eQED**5*integralnorm*MT*SwB)/(cw*MW**3*sw**4*8._/**/REALKIND)
    f(203) = (eQED**5*integralnorm*SwB)/(cw*MW*sw**4*8._/**/REALKIND)
    f(204) = (cw*eQED**5*integralnorm*SwB)/(MW*sw**4*4._/**/REALKIND)
    f(205) = (eQED**5*integralnorm*MB*SwB)/(cw**3*MW*sw**4*16._/**/REALKIND)
    f(206) = (eQED**5*integralnorm*MB*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f(207) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**4*16._/**/REALKIND)
    f(208) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**4*8._/**/REALKIND)
    f(209) = (cw*eQED**5*integralnorm*MB*SwB)/(MW*sw**4*8._/**/REALKIND)
    f(210) = (cw*eQED**5*integralnorm*MB*SwB)/(MW*sw**4*4._/**/REALKIND)
    f(211) = (cw**3*eQED**5*integralnorm*MB*SwB)/(MW*sw**4*2._/**/REALKIND)
    f(212) = (eQED**5*integralnorm*MB**2*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f(213) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f(214) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f(215) = (eQED**5*integralnorm*MT*SwB)/(cw*MW*sw**4*8._/**/REALKIND)
    f(216) = (cw*eQED**5*integralnorm*MT*SwB)/(MW*sw**4*4._/**/REALKIND)
    f(217) = (eQED**5*integralnorm*MW*SwB)/(cw**3*sw**4*8._/**/REALKIND)
    f(218) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**4*8._/**/REALKIND)
    f(219) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**4*4._/**/REALKIND)
    f(220) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**4*2._/**/REALKIND)
    f(221) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**4*4._/**/REALKIND)
    f(222) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**4*2._/**/REALKIND)
    f(223) = (cw*eQED**5*integralnorm*MW*SwB)/sw**4
    f(224) = (cw**3*eQED**5*integralnorm*MW*SwB)/(sw**4*2._/**/REALKIND)
    f(225) = (cw**3*eQED**5*integralnorm*MW*SwB)/sw**4
    f(226) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**5*sw**4*4._/**/REALKIND)
    f(227) = (eQED**5*integralnorm*MB*MW*SwB)/(cw*sw**4*16._/**/REALKIND)
    f(228) = (eQED**5*integralnorm*MB*MW*SwB)/(cw*sw**4*4._/**/REALKIND)
    f(229) = (eQED**5*integralnorm*MB*MW*SwB)/(cw*sw**4*2._/**/REALKIND)
    f(230) = (cw*eQED**5*integralnorm*MB*MW*SwB)/(sw**4*8._/**/REALKIND)
    f(231) = (cw*eQED**5*integralnorm*MB*MW*SwB)/(sw**4*2._/**/REALKIND)
    f(232) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(cw*sw**4*4._/**/REALKIND)
    f(233) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(cw*sw**4*2._/**/REALKIND)
    f(234) = (eQED**5*integralnorm*MW**3*SwB)/(cw**3*sw**4*8._/**/REALKIND)
    f(235) = (eQED**5*integralnorm*MW**3*SwB)/(cw**3*sw**4*2._/**/REALKIND)
    f(236) = (eQED**5*integralnorm*MW**3*SwB)/(cw**3*sw**4)
    f(237) = (eQED**5*integralnorm*MW**3*SwB)/(cw*sw**4*4._/**/REALKIND)
    f(238) = (eQED**5*integralnorm*MW**3*SwB)/(cw*sw**4)
    f(239) = (eQED**5*integralnorm*MB*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f(240) = (eQED**5*integralnorm*MB**3*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(241) = (eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f(242) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(243) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(244) = (eQED**5*integralnorm*MT*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f(245) = (eQED**5*integralnorm*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(246) = (eQED**5*integralnorm*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(247) = (eQED**5*integralnorm*SwB)/(cw**2*MW*sw**3*2._/**/REALKIND)
    f(248) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*8._/**/REALKIND)
    f(249) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(250) = (eQED**5*integralnorm*MB*SwB)/(cw**2*MW*sw**3*72._/**/REALKIND)
    f(251) = (eQED**5*integralnorm*MB*SwB)/(cw**2*MW*sw**3*36._/**/REALKIND)
    f(252) = (eQED**5*integralnorm*MB*SwB)/(cw**2*MW*sw**3*16._/**/REALKIND)
    f(253) = (eQED**5*integralnorm*MB*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(254) = (eQED**5*integralnorm*MB*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(255) = (cw**2*eQED**5*integralnorm*MB*SwB)/(MW*sw**3*6._/**/REALKIND)
    f(256) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(257) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(258) = (eQED**5*integralnorm*MB**2*SwB)/(MW*sw**3*8._/**/REALKIND)
    f(259) = (eQED**5*integralnorm*MB**2*SwB)/(cw**2*MW*sw**3*36._/**/REALKIND)
    f(260) = (eQED**5*integralnorm*MB**2*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(261) = (eQED**3*gQCD**2*integralnorm*MB**2*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(262) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(263) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*MW*sw**3*24._/**/REALKIND)
    f(264) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*MW*sw**3*12._/**/REALKIND)
    f(265) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(266) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(267) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW*sw**3*8._/**/REALKIND)
    f(268) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**2*MW*sw**3*16._/**/REALKIND)
    f(269) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**2*MW*sw**3*12._/**/REALKIND)
    f(270) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW*sw**3*8._/**/REALKIND)
    f(271) = (eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**2*MW*sw**3*12._/**/REALKIND)
    f(272) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(273) = (3*eQED**3*gQCD**2*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(274) = (eQED**5*integralnorm*MH**4*SwB)/(cw**2*MW*sw**3*12._/**/REALKIND)
    f(275) = (eQED**5*integralnorm*lambdaHHH*MH**4*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(276) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(277) = (eQED**5*integralnorm*MT*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(278) = (eQED**5*integralnorm*MW*SwB)/(sw**3*12._/**/REALKIND)
    f(279) = (eQED**5*integralnorm*MW*SwB)/(sw**3*4._/**/REALKIND)
    f(280) = (eQED**5*integralnorm*MW*SwB)/(sw**3*3._/**/REALKIND)
    f(281) = (eQED**5*integralnorm*MW*SwB)/(sw**3*2._/**/REALKIND)
    f(282) = (eQED**5*integralnorm*MW*SwB)/sw**3
    f(283) = (eQED**5*integralnorm*MW*SwB)/(cw**4*sw**3*4._/**/REALKIND)
    f(284) = (eQED**5*integralnorm*MW*SwB)/(cw**4*sw**3*2._/**/REALKIND)
    f(285) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw**3*24._/**/REALKIND)
    f(286) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw**3*12._/**/REALKIND)
    f(287) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw**3*8._/**/REALKIND)
    f(288) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw**3*6._/**/REALKIND)
    f(289) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw**3*2._/**/REALKIND)
    f(290) = (cw**2*eQED**5*integralnorm*MW*SwB)/(sw**3*6._/**/REALKIND)
    f(291) = (cw**2*eQED**5*integralnorm*MW*SwB)/(sw**3*3._/**/REALKIND)
    f(292) = (cw**2*eQED**5*integralnorm*MW*SwB)/(sw**3*2._/**/REALKIND)
    f(293) = (cw**2*eQED**5*integralnorm*MW*SwB)/sw**3
    f(294) = (eQED**5*integralnorm*MB*MW*SwB)/(sw**3*4._/**/REALKIND)
    f(295) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**4*sw**3*18._/**/REALKIND)
    f(296) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**4*sw**3*8._/**/REALKIND)
    f(297) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**4*sw**3*2._/**/REALKIND)
    f(298) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**2*sw**3*12._/**/REALKIND)
    f(299) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**2*sw**3*8._/**/REALKIND)
    f(300) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**2*sw**3*6._/**/REALKIND)
    f(301) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**2*sw**3*4._/**/REALKIND)
    f(302) = (eQED**3*gQCD**2*integralnorm*MB*MW*SwB)/(cw**4*sw**3*2._/**/REALKIND)
    f(303) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw**4*sw**3*6._/**/REALKIND)
    f(304) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw**2*sw**3*12._/**/REALKIND)
    f(305) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(cw**4*sw**3*2._/**/REALKIND)
    f(306) = (eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(cw**2*sw**3*4._/**/REALKIND)
    f(307) = (eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(cw**2*sw**3*2._/**/REALKIND)
    f(308) = (eQED**5*integralnorm*MW**3*SwB)/(cw**6*sw**3)
    f(309) = (eQED**5*integralnorm*MW**3*SwB)/(cw**4*sw**3*6._/**/REALKIND)
    f(310) = (eQED**5*integralnorm*MW**3*SwB)/(cw**4*sw**3*3._/**/REALKIND)
    f(311) = (eQED**5*integralnorm*MW**3*SwB)/(cw**2*sw**3*12._/**/REALKIND)
    f(312) = (eQED**5*integralnorm*MW**3*SwB)/(cw**2*sw**3*6._/**/REALKIND)
    f(313) = (eQED**5*integralnorm*MW**3*SwB)/(cw**2*sw**3*3._/**/REALKIND)
    f(314) = (eQED**5*integralnorm*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(315) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**2*36._/**/REALKIND)
    f(316) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(317) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(318) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(319) = (eQED**5*integralnorm*MH**2*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(320) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(321) = (eQED**5*integralnorm*MT*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(322) = (eQED**5*integralnorm*MW*SwB)/(cw**3*sw**2*8._/**/REALKIND)
    f(323) = (eQED**5*integralnorm*MW*SwB)/(cw**3*sw**2*4._/**/REALKIND)
    f(324) = (eQED**5*integralnorm*MW*SwB)/(cw**3*sw**2*2._/**/REALKIND)
    f(325) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*12._/**/REALKIND)
    f(326) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(327) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*3._/**/REALKIND)
    f(328) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*2._/**/REALKIND)
    f(329) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**2*6._/**/REALKIND)
    f(330) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**2*3._/**/REALKIND)
    f(331) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**2*2._/**/REALKIND)
    f(332) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**3*sw**2*4._/**/REALKIND)
    f(333) = (eQED**5*integralnorm*MB*MW*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(334) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw**3*sw**2*4._/**/REALKIND)
    f(335) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(cw**3*sw**2*4._/**/REALKIND)
    f(336) = (eQED**5*integralnorm*MW**3*SwB)/(cw**5*sw**2*2._/**/REALKIND)
    f(337) = (eQED**5*integralnorm*MW**3*SwB)/(cw**3*sw**2*2._/**/REALKIND)
    f(338) = (eQED**5*integralnorm*SwB)/(cw**2*MW*sw*4._/**/REALKIND)
    f(339) = (eQED**5*integralnorm*MB*SwB)/(MW*sw*18._/**/REALKIND)
    f(340) = (eQED**5*integralnorm*MB*SwB)/(MW*sw*2._/**/REALKIND)
    f(341) = (eQED**5*integralnorm*MB*SwB)/(cw**2*MW*sw*8._/**/REALKIND)
    f(342) = (eQED**5*integralnorm*MB*SwB)/(cw**2*MW*sw*4._/**/REALKIND)
    f(343) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(MW*sw*2._/**/REALKIND)
    f(344) = (eQED**5*integralnorm*MB**2*SwB)/(cw**2*MW*sw*8._/**/REALKIND)
    f(345) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*MW*sw*4._/**/REALKIND)
    f(346) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**2*MW*sw*8._/**/REALKIND)
    f(347) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**2*MW*sw*8._/**/REALKIND)
    f(348) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(cw**2*MW*sw*8._/**/REALKIND)
    f(349) = (eQED**5*integralnorm*MB*MH**4*SwB)/(cw**2*MW*sw*8._/**/REALKIND)
    f(350) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**4*SwB)/(cw**2*MW*sw*8._/**/REALKIND)
    f(351) = (eQED**5*integralnorm*MT*SwB)/(cw**2*MW*sw*4._/**/REALKIND)
    f(352) = (eQED**5*integralnorm*MW*SwB)/(sw*6._/**/REALKIND)
    f(353) = (eQED**5*integralnorm*MW*SwB)/(sw*2._/**/REALKIND)
    f(354) = (eQED**5*integralnorm*MW*SwB)/(cw**4*sw*2._/**/REALKIND)
    f(355) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw*12._/**/REALKIND)
    f(356) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw*9._/**/REALKIND)
    f(357) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(358) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw*2._/**/REALKIND)
    f(359) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw)
    f(360) = (eQED**3*gQCD**2*integralnorm*MW*SwB)/(cw**2*sw)
    f(361) = (eQED**5*integralnorm*MB*MW*SwB)/(sw*6._/**/REALKIND)
    f(362) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**4*sw*4._/**/REALKIND)
    f(363) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**2*sw*8._/**/REALKIND)
    f(364) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(365) = (eQED**5*integralnorm*MB**2*MW*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(366) = (eQED**5*integralnorm*MH**2*MW*SwB)/(sw*6._/**/REALKIND)
    f(367) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(368) = (eQED**5*integralnorm*MB*MH**2*MW*SwB)/(cw**4*sw*4._/**/REALKIND)
    f(369) = (eQED**5*integralnorm*MB*MH**2*MW*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(370) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MW*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(371) = (eQED**5*integralnorm*MT*MW*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(372) = (eQED**5*integralnorm*MW**3*SwB)/(sw*3._/**/REALKIND)
    f(373) = (eQED**5*integralnorm*MW**3*SwB)/(cw**4*sw*2._/**/REALKIND)
    f(374) = (eQED**5*integralnorm*MW**3*SwB)/(cw**2*sw*3._/**/REALKIND)
    f(375) = (eQED**5*integralnorm*MW**3*SwB)/(cw**2*sw*2._/**/REALKIND)
    f(376) = (eQED**5*integralnorm*MB*MW**3*SwB)/(cw**6*sw*2._/**/REALKIND)
    f(377) = (eQED**5*integralnorm*MB*MW**3*SwB)/(cw**4*sw*2._/**/REALKIND)
    f(378) = (eQED**5*integralnorm*MB*MW**3*SwB)/(cw**2*sw*2._/**/REALKIND)
    f(379) = (eQED**5*integralnorm*MW*sw*SwB)/(cw**2*6._/**/REALKIND)
    f(380) = (eQED**5*integralnorm*MW*sw*SwB)/(cw**2*2._/**/REALKIND)
    f(381) = (eQED**5*integralnorm*MB*MW*sw*SwB)/(cw**2*6._/**/REALKIND)
    f(382) = (eQED**5*integralnorm*MH**2*MW*sw*SwB)/(cw**2*6._/**/REALKIND)
    f(383) = (eQED**5*integralnorm*MH**2*MW*sw*SwB)/(cw**2*2._/**/REALKIND)
    f(384) = (eQED**5*integralnorm*MW**3*sw*SwB)/(cw**4*3._/**/REALKIND)
    f(385) = (eQED**5*integralnorm*MW**3*sw*SwB)/cw**4
    f(386) = (eQED**5*integralnorm*MW**3*sw*SwB)/(cw**2*6._/**/REALKIND)
    f(387) = (eQED**5*integralnorm*MW**3*sw*SwB)/(cw**2*3._/**/REALKIND)
    f(388) = (eQED**5*integralnorm*MW**3*sw*SwB)/cw**2
    f(389) = (eQED**5*integralnorm*MW**3*sw**2*SwB)/(cw**3*2._/**/REALKIND)
    f(390) = (eQED**5*integralnorm*MB*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f(391) = (eQED**5*integralnorm*MB*MH**2*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW**3*sw**5*32._/**/REALKIND)
    f(392) = (eQED**5*integralnorm*MB*MH**4*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW**3*sw**5*32._/**/REALKIND)
    f(393) = (eQED**5*integralnorm*MT*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f(394) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(MW*sw**5*8._/**/REALKIND))
    f(395) = (eQED**5*integralnorm*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**5*16._/**/REALKIND)
    f(396) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(MW*sw**5*16._/**/REALKIND))
    f(397) = (eQED**5*integralnorm*MB*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**5*32._/**/REALKIND)
    f(398) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw**4*MW*sw**5*16._/**/REALKIND))
    f(399) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*8._/**/REALKIND))
    f(400) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*8._/**/REALKIND))
    f(401) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND))
    f(402) = -((eQED**5*integralnorm*MB*MH**4*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND))
    f(403) = -((eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*8._/**/REALKIND))
    f(404) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**3*MW*sw**4*4._/**/REALKIND))
    f(405) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**4*8._/**/REALKIND))
    f(406) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**4*16._/**/REALKIND))
    f(407) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*MW*sw**4*16._/**/REALKIND))
    f(408) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND))
    f(409) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*12._/**/REALKIND)
    f(410) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*6._/**/REALKIND)
    f(411) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND))
    f(412) = -((eQED**5*integralnorm*MH**4*(cw - sw)*(cw + sw)*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND))
    f(413) = (-3*eQED**5*integralnorm*lambdaHHH*MH**4*(cw - sw)*(cw + sw)*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f(414) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**4*8._/**/REALKIND))
    f(415) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**2*8._/**/REALKIND)
    f(416) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**2*6._/**/REALKIND)
    f(417) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*12._/**/REALKIND)
    f(418) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(419) = -((eQED**5*integralnorm*MH**2*MW*(cw - sw)*(cw + sw)*SwB)/(cw**5*sw**4*4._/**/REALKIND))
    f(420) = (eQED**5*integralnorm*MB*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**2*MW**3*sw**5*16._/**/REALKIND*8._/**/REALKIND)
    f(421) = (eQED**5*integralnorm*MB*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW**3*sw**5*4._/**/REALKIND*8._/**/REALKIND)
    f(422) = (eQED**5*integralnorm*MH**2*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**2*MW**3*sw**5*16._/**/REALKIND*8._/**/REALKIND)
    f(423) = (eQED**5*integralnorm*MH**2*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW**3*sw**5*4._/**/REALKIND*8._/**/REALKIND)
    f(424) = (eQED**5*integralnorm*MB*MH**2*SwB*(cw**4*16._/**/REALKIND + sw**4*16._/**/REALKIND  &
      - cw**2*sw**2*32._/**/REALKIND))/(cw**2*MW**3*sw**5*16._/**/REALKIND*32._/**/REALKIND)
    f(425) = (eQED**5*integralnorm*MB*MH**2*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**2*MW**3*sw**5*16._/**/REALKIND*8._/**/REALKIND)
    f(426) = (eQED**5*integralnorm*MB**2*MH**2*SwB*(cw**4*16._/**/REALKIND + sw**4*16._/**/REALKIND  &
      - cw**2*sw**2*32._/**/REALKIND))/(cw**2*MW**3*sw**5*16._/**/REALKIND*32._/**/REALKIND)
    f(427) = (eQED**5*integralnorm*MB**2*MH**2*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**2*MW**3*sw**5*16._/**/REALKIND*8._/**/REALKIND)
    f(428) = (eQED**5*integralnorm*MB*MH**4*SwB*(cw**4*16._/**/REALKIND + sw**4*16._/**/REALKIND  &
      - cw**2*sw**2*32._/**/REALKIND))/(cw**2*MW**3*sw**5*16._/**/REALKIND*32._/**/REALKIND)
    f(429) = (eQED**5*integralnorm*MB*MH**4*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**2*MW**3*sw**5*16._/**/REALKIND*8._/**/REALKIND)
    f(430) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**4*SwB*(cw**4*16._/**/REALKIND + sw**4*16._/**/REALKIND  &
      - cw**2*sw**2*32._/**/REALKIND))/(cw**2*MW**3*sw**5*16._/**/REALKIND*32._/**/REALKIND)
    f(431) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**4*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**2*MW**3*sw**5*16._/**/REALKIND*8._/**/REALKIND)
    f(432) = (eQED**5*integralnorm*MT*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**2*MW**3*sw**5*16._/**/REALKIND*8._/**/REALKIND)
    f(433) = (eQED**5*integralnorm*MT*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW**3*sw**5*4._/**/REALKIND*8._/**/REALKIND)
    f(434) = (eQED**5*integralnorm*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**4*MW*sw**5*4._/**/REALKIND*8._/**/REALKIND)
    f(435) = (eQED**5*integralnorm*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**4*MW*sw**5*2._/**/REALKIND*4._/**/REALKIND)
    f(436) = (eQED**5*integralnorm*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**2*MW*sw**5*16._/**/REALKIND*8._/**/REALKIND)
    f(437) = (eQED**5*integralnorm*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW*sw**5*4._/**/REALKIND*8._/**/REALKIND)
    f(438) = (eQED**5*integralnorm*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(439) = (eQED**5*integralnorm*MB*SwB*(cw**4*16._/**/REALKIND + sw**4*16._/**/REALKIND  &
      - cw**2*sw**2*32._/**/REALKIND))/(cw**2*MW*sw**5*16._/**/REALKIND*32._/**/REALKIND)
    f(440) = (eQED**5*integralnorm*MB*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**2*MW*sw**5*16._/**/REALKIND*8._/**/REALKIND)
    f(441) = (eQED**5*integralnorm*MB*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**3*16._/**/REALKIND)
    f(442) = (eQED**5*integralnorm*MB*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(443) = (eQED**5*integralnorm*MB**2*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**3*16._/**/REALKIND)
    f(444) = (eQED**5*integralnorm*MH**2*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(445) = (eQED**5*integralnorm*MB*MH**2*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**4*MW*sw**5*16._/**/REALKIND*8._/**/REALKIND)
    f(446) = (eQED**5*integralnorm*MB*MH**2*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**4*MW*sw**5*4._/**/REALKIND*8._/**/REALKIND)
    f(447) = (eQED**5*integralnorm*MB*MH**2*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**3*16._/**/REALKIND)
    f(448) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**3*16._/**/REALKIND)
    f(449) = (eQED**5*integralnorm*MT*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(450) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(sw**3*12._/**/REALKIND))
    f(451) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**4*sw**3*4._/**/REALKIND))
    f(452) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**3*24._/**/REALKIND)
    f(453) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**3*8._/**/REALKIND)
    f(454) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**3*4._/**/REALKIND)
    f(455) = (eQED**5*integralnorm*MB*MW*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**6*sw**5*4._/**/REALKIND*8._/**/REALKIND)
    f(456) = -((eQED**5*integralnorm*MB*MW*(cw - sw)*(cw + sw)*SwB)/(cw**4*sw**3*8._/**/REALKIND))
    f(457) = (eQED**5*integralnorm*MB*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**3*8._/**/REALKIND)
    f(458) = -((eQED**5*integralnorm*MB*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**4*MW*sw**5*32._/**/REALKIND))
    f(459) = -((eQED**5*integralnorm*MB*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**4*MW*sw**5*16._/**/REALKIND))
    f(460) = (eQED**5*integralnorm*MB*SwB*(cw**4*12._/**/REALKIND + sw**4*12._/**/REALKIND  &
      - cw**2*sw**2*24._/**/REALKIND))/(cw**2*MW*sw**3*12._/**/REALKIND*24._/**/REALKIND)
    f(461) = (eQED**5*integralnorm*MB*SwB*(-(cw**2*sw**2*12._/**/REALKIND) + cw**4*6._/**/REALKIND  &
      + sw**4*6._/**/REALKIND))/(cw**2*MW*sw**3*12._/**/REALKIND*6._/**/REALKIND)
    f(462) = (eQED**5*integralnorm*MH**2*SwB*(cw**4*12._/**/REALKIND + sw**4*12._/**/REALKIND  &
      - cw**2*sw**2*24._/**/REALKIND))/(cw**2*MW*sw**3*12._/**/REALKIND*24._/**/REALKIND)
    f(463) = (eQED**5*integralnorm*MH**2*SwB*(-(cw**2*sw**2*12._/**/REALKIND) + cw**4*6._/**/REALKIND  &
      + sw**4*6._/**/REALKIND))/(cw**2*MW*sw**3*12._/**/REALKIND*6._/**/REALKIND)
    f(464) = (eQED**5*integralnorm*MH**2*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW*sw**3*4._/**/REALKIND*8._/**/REALKIND)
    f(465) = (eQED**5*integralnorm*MH**2*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*MW*sw**3*2._/**/REALKIND*4._/**/REALKIND)
    f(466) = (eQED**5*integralnorm*MW*SwB*(-(cw**2*sw**2*12._/**/REALKIND) + cw**4*6._/**/REALKIND  &
      + sw**4*6._/**/REALKIND))/(cw**4*sw**3*12._/**/REALKIND*6._/**/REALKIND)
    f(467) = (eQED**5*integralnorm*MW*SwB*(cw**4*3._/**/REALKIND + sw**4*3._/**/REALKIND  &
      - cw**2*sw**2*6._/**/REALKIND))/(cw**4*sw**3*3._/**/REALKIND*6._/**/REALKIND)
    f(468) = (eQED**5*integralnorm*MW*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**4*sw**3*2._/**/REALKIND*4._/**/REALKIND)
    f(469) = (eQED**5*integralnorm*MW*SwB*(cw**4*12._/**/REALKIND + sw**4*12._/**/REALKIND  &
      - cw**2*sw**2*24._/**/REALKIND))/(cw**2*sw**3*12._/**/REALKIND*24._/**/REALKIND)
    f(470) = (eQED**5*integralnorm*MW*SwB*(-(cw**2*sw**2*12._/**/REALKIND) + cw**4*6._/**/REALKIND  &
      + sw**4*6._/**/REALKIND))/(cw**2*sw**3*12._/**/REALKIND*6._/**/REALKIND)
    f(471) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw*12._/**/REALKIND)
    f(472) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw*6._/**/REALKIND)
    f(473) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(474) = -((eQED**5*integralnorm*MB*MW*(cw - sw)*(cw + sw)*SwB)/(cw**4*sw*8._/**/REALKIND))
    f(475) = (eQED**5*integralnorm*MB*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw*12._/**/REALKIND)
    f(476) = (eQED**5*integralnorm*MH**2*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw*12._/**/REALKIND)
    f(477) = -((eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(cw**4*sw*6._/**/REALKIND))
    f(478) = (eQED**5*integralnorm*MW**3*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw*6._/**/REALKIND)
    f(479) = -((eQED**5*integralnorm*MB*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*MW*sw**4*16._/**/REALKIND))
    f(480) = -((eQED**5*integralnorm*MB*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND))
    f(481) = -((eQED**5*integralnorm*MH**2*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*MW*sw**4*16._/**/REALKIND))
    f(482) = -((eQED**5*integralnorm*MH**2*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND))
    f(483) = -((eQED**5*integralnorm*MW*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**5*sw**4*8._/**/REALKIND))
    f(484) = -((eQED**5*integralnorm*MW*(cw - sw)**3*(cw + sw)**3*SwB)/(cw**5*sw**4*4._/**/REALKIND))
    f(485) = (eQED**5*integralnorm*MW*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**3*sw**2*4._/**/REALKIND*8._/**/REALKIND)
    f(486) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*4._/**/REALKIND))
    f(487) = (eQED**5*integralnorm*MW*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**3*sw**2*2._/**/REALKIND*4._/**/REALKIND)
    f(488) = -((eQED**5*integralnorm*MB*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*4._/**/REALKIND))
    f(489) = -((eQED**5*integralnorm*MH**2*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*4._/**/REALKIND))
    f(490) = -((eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(cw**5*2._/**/REALKIND))
    f(491) = -((eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(cw**3*2._/**/REALKIND))
    f(492) = (eQED**5*integralnorm*MB**3*SwF)/(cw**2*MW**3*sw**5*32._/**/REALKIND)
    f(493) = (eQED**5*integralnorm*MB**3*SwF)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f(494) = (eQED**5*integralnorm*MB**4*SwF)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f(495) = (eQED**5*integralnorm*MB**3*MH**2*SwF)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f(496) = (3*eQED**5*integralnorm*lambdaHHH*MB**3*MH**2*SwF)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f(497) = (eQED**5*integralnorm*MB*ML**2*SwF)/(cw**2*MW**3*sw**5*32._/**/REALKIND)
    f(498) = (eQED**5*integralnorm*MB*ML**2*SwF)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f(499) = (eQED**5*integralnorm*MB**2*ML**2*SwF)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f(500) = (eQED**5*integralnorm*MB*MH**2*ML**2*SwF)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f(501) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*ML**2*SwF)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f(502) = (eQED**5*integralnorm*MB*ML**3*SwF)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f(503) = (eQED**5*integralnorm*MB*MT**2*SwF)/(cw**2*MW**3*sw**5*32._/**/REALKIND)
    f(504) = (eQED**5*integralnorm*MB*MT**2*SwF)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f(505) = (eQED**5*integralnorm*MB**2*MT**2*SwF)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f(506) = (eQED**5*integralnorm*MB*MH**2*MT**2*SwF)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f(507) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT**2*SwF)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f(508) = (eQED**5*integralnorm*MB*MT**3*SwF)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f(509) = (eQED**5*integralnorm*MB**3*SwF)/(cw**4*MW*sw**5*8._/**/REALKIND)
    f(510) = (eQED**5*integralnorm*MB*ML**2*SwF)/(cw**4*MW*sw**5*8._/**/REALKIND)
    f(511) = (eQED**5*integralnorm*MB*MT**2*SwF)/(cw**4*MW*sw**5*8._/**/REALKIND)
    f(512) = (eQED**5*integralnorm*MB**3*SwF)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(513) = (eQED**5*integralnorm*MB*ML**2*SwF)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(514) = (eQED**5*integralnorm*MB*MT**2*SwF)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(515) = (eQED**5*integralnorm*MB**2*SwF)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f(516) = (eQED**5*integralnorm*MB*ML*SwF)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f(517) = (eQED**5*integralnorm*ML**2*SwF)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f(518) = (eQED**5*integralnorm*MB*MT*SwF)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f(519) = (eQED**5*integralnorm*MT**2*SwF)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f(520) = (eQED**5*integralnorm*MB**3*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(521) = (eQED**5*integralnorm*MB**2*MH**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(522) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(523) = (eQED**5*integralnorm*MB**2*ML*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(524) = (eQED**5*integralnorm*MB*MH**2*ML*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(525) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*ML*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(526) = (eQED**5*integralnorm*MB*ML**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(527) = (eQED**5*integralnorm*MB**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(528) = (eQED**5*integralnorm*MB*MH**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(529) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(530) = (eQED**5*integralnorm*MB*MT**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(531) = (eQED**5*integralnorm*MB*SwF)/(cw**2*MW*sw**3*72._/**/REALKIND)
    f(532) = (eQED**5*integralnorm*MB*SwF)/(cw**2*MW*sw**3*36._/**/REALKIND)
    f(533) = (eQED**5*integralnorm*MB*SwF)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(534) = (eQED**5*integralnorm*MB*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(535) = (eQED**5*integralnorm*MB**2*SwF)/(cw**2*MW*sw**3*36._/**/REALKIND)
    f(536) = (eQED**5*integralnorm*MB**2*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(537) = (eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwF)/(cw**2*MW*sw**3*12._/**/REALKIND)
    f(538) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(539) = (eQED**5*integralnorm*ML*SwF)/(cw**2*MW*sw**3*24._/**/REALKIND)
    f(540) = (eQED**5*integralnorm*ML*SwF)/(cw**2*MW*sw**3*12._/**/REALKIND)
    f(541) = (eQED**5*integralnorm*ML*SwF)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(542) = (eQED**5*integralnorm*ML*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(543) = (eQED**5*integralnorm*MB*ML*SwF)/(cw**2*MW*sw**3*12._/**/REALKIND)
    f(544) = (eQED**5*integralnorm*MB*ML*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(545) = (eQED**5*integralnorm*lambdaHHH*MH**2*ML*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(546) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*ML*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(547) = (eQED**5*integralnorm*ML**2*SwF)/(cw**2*MW*sw**3*12._/**/REALKIND)
    f(548) = (eQED**5*integralnorm*ML**2*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(549) = (eQED**5*integralnorm*MT*SwF)/(cw**2*MW*sw**3*36._/**/REALKIND)
    f(550) = (eQED**5*integralnorm*MT*SwF)/(cw**2*MW*sw**3*18._/**/REALKIND)
    f(551) = (eQED**5*integralnorm*MT*SwF)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(552) = (eQED**5*integralnorm*MT*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(553) = (eQED**5*integralnorm*MB*MT*SwF)/(cw**2*MW*sw**3*18._/**/REALKIND)
    f(554) = (eQED**5*integralnorm*MB*MT*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(555) = (eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwF)/(cw**2*MW*sw**3*6._/**/REALKIND)
    f(556) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(557) = (eQED**5*integralnorm*MT**2*SwF)/(cw**2*MW*sw**3*18._/**/REALKIND)
    f(558) = (eQED**5*integralnorm*MT**2*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(559) = (eQED**5*integralnorm*MB*MW*SwF)/(cw**4*sw**3*18._/**/REALKIND)
    f(560) = (eQED**5*integralnorm*MB*MW*SwF)/(cw**4*sw**3*2._/**/REALKIND)
    f(561) = (eQED**5*integralnorm*MB*MW*SwF)/(cw**4*sw**3)
    f(562) = (3*eQED**5*integralnorm*MB*MW*SwF)/(cw**4*sw**3*2._/**/REALKIND)
    f(563) = (eQED**5*integralnorm*ML*MW*SwF)/(cw**4*sw**3*6._/**/REALKIND)
    f(564) = (eQED**5*integralnorm*ML*MW*SwF)/(cw**4*sw**3*2._/**/REALKIND)
    f(565) = (eQED**5*integralnorm*MT*MW*SwF)/(cw**4*sw**3*9._/**/REALKIND)
    f(566) = (eQED**5*integralnorm*MT*MW*SwF)/(cw**4*sw**3*2._/**/REALKIND)
    f(567) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*36._/**/REALKIND)
    f(568) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(569) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*2._/**/REALKIND)
    f(570) = (3*eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(571) = (eQED**5*integralnorm*ML*SwF)/(cw*MW*sw**2*12._/**/REALKIND)
    f(572) = (eQED**5*integralnorm*ML*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(573) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*18._/**/REALKIND)
    f(574) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(575) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*18._/**/REALKIND)
    f(576) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*9._/**/REALKIND)
    f(577) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*6._/**/REALKIND)
    f(578) = (2*eQED**5*integralnorm*MB*SwF)/(MW*sw*9._/**/REALKIND)
    f(579) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*3._/**/REALKIND)
    f(580) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*2._/**/REALKIND)
    f(581) = (eQED**5*integralnorm*MB*SwF)/(MW*sw)
    f(582) = (3*eQED**5*integralnorm*MB*SwF)/(MW*sw*2._/**/REALKIND)
    f(583) = (eQED**5*integralnorm*ML*SwF)/(MW*sw*6._/**/REALKIND)
    f(584) = (eQED**5*integralnorm*ML*SwF)/(MW*sw*2._/**/REALKIND)
    f(585) = (eQED**5*integralnorm*MT*SwF)/(MW*sw*9._/**/REALKIND)
    f(586) = (eQED**5*integralnorm*MT*SwF)/(MW*sw*2._/**/REALKIND)
    f(587) = (eQED**5*integralnorm*MW*SwF)/(cw**2*sw*9._/**/REALKIND)
    f(588) = (2*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*9._/**/REALKIND)
    f(589) = (eQED**5*integralnorm*MW*SwF)/(cw**2*sw*3._/**/REALKIND)
    f(590) = (4*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*9._/**/REALKIND)
    f(591) = (2*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*3._/**/REALKIND)
    f(592) = (eQED**5*integralnorm*MW*SwF)/(cw**2*sw)
    f(593) = (2*eQED**5*integralnorm*MW*SwF)/(cw**2*sw)
    f(594) = (3*eQED**5*integralnorm*MW*SwF)/(cw**2*sw)

  c = [ 3*f(52), 3*f(53), 3*f(54), 3*f(55), 3*f(56), 3*f(57), 3*f(58), 3*f(59), 3*f(60), 3*f(61), 3*f(62), 3*f(63), 3*f(64) &
    , 3*f(65), 3*f(66), 3*f(67), 3*f(68), 3*f(69), 3*f(70), 3*f(71), 3*f(72), 3*f(73), 3*f(74), 3*f(75), 3*f(76), 3*f(77), 3*f(78) &
    , 3*f(79), 3*f(80), 3*f(81), 3*f(82), 3*f(83), 3*f(84), 3*f(85), 3*f(86), 3*f(87), 3*f(88), 3*f(89), 3*f(90), 3*f(91), 3*f(92) &
    , 3*f(93), 3*f(94), 3*f(95), 3*f(96), 3*f(97), 3*f(98), 3*f(99), 3*f(100), 3*f(101), 3*f(102), 3*f(103), 3*f(104), 3*f(105) &
    , 3*f(106), 3*f(107), 3*f(108), 3*f(109), 3*f(110), 3*f(111), 3*f(112), 3*f(113), 3*f(114), 3*f(115), 3*f(116), 3*f(117) &
    , 3*f(118), 3*f(119), 3*f(120), 3*f(121), 3*f(122), 3*f(123), 3*f(124), 3*f(125), 3*f(126), 3*f(127), 3*f(128), 3*f(129) &
    , 3*f(130), 3*f(131), 3*f(132), 3*f(133), 3*f(134), 3*f(135), 3*f(136), 3*f(137), 3*f(138), 3*f(139), 3*f(140), 3*f(141) &
    , 3*f(142), 3*f(143), 3*f(144), 3*f(145), 3*f(146), 3*f(147), 3*f(148), 3*f(149), 3*f(150), 3*f(151), 3*f(152), 3*f(153) &
    , 3*f(154), 3*f(155), 3*f(156), 3*f(157), 3*f(158), 3*f(159), 3*f(160), 3*f(161), 3*f(162), 3*f(163), 3*f(164), 3*f(165) &
    , 3*f(166), 3*f(167), 3*f(168), 3*f(169), 3*f(170), 3*f(171), 3*f(172), 3*f(173), 3*f(174), 3*f(175), 3*f(176), 3*f(177) &
    , 3*f(178), 3*f(179), 3*f(180), 3*f(181), 3*f(182), 3*f(183), 3*f(184), 3*f(185), 3*f(186), 3*f(187), 3*f(188), 3*f(189) &
    , 3*f(190), 3*f(191), 3*f(192), 3*f(193), 3*f(194), 3*f(195), 3*f(196), 3*f(197), 3*f(198), 3*f(199), 3*f(200), 3*f(201) &
    , 3*f(202), 3*f(203), 3*f(204), 3*f(205), 3*f(206), 3*f(207), 3*f(208), 3*f(209), 3*f(210), 3*f(211), 3*f(212), 3*f(213) &
    , 3*f(214), 3*f(215), 3*f(216), 3*f(217), 3*f(218), 3*f(219), 3*f(220), 3*f(221), 3*f(222), 3*f(223), 3*f(224), 3*f(225) &
    , 3*f(226), 3*f(227), 3*f(228), 3*f(229), 3*f(230), 3*f(231), 3*f(232), 3*f(233), 3*f(234), 3*f(235), 3*f(236), 3*f(237) &
    , 3*f(238), 3*f(239), 3*f(240), 3*f(241), 3*f(242), 3*f(243), 3*f(244), 3*f(245), 3*f(246), 3*f(247), 3*f(248), 3*f(249) &
    , 3*f(250), 3*f(251), 3*f(252), 3*f(253), 3*f(254), 3*f(255), 4*f(256), 4*f(257), 3*f(258), 3*f(259), 3*f(260), 4*f(261) &
    , 3*f(262), 3*f(263), 3*f(264), 3*f(265), 3*f(266), 3*f(267), 3*f(268), 3*f(269), 3*f(270), 3*f(271), 3*f(272), 4*f(273) &
    , 3*f(274), 3*f(275), 3*f(276), 3*f(277), 3*f(278), 3*f(279), 3*f(280), 3*f(281), 3*f(282), 3*f(283), 3*f(284), 3*f(285) &
    , 3*f(286), 3*f(287), 3*f(288), 3*f(289), 3*f(290), 3*f(291), 3*f(292), 3*f(293), 3*f(294), 3*f(295), 3*f(296), 3*f(297) &
    , 3*f(298), 3*f(299), 3*f(300), 3*f(301), 4*f(302), 3*f(303), 3*f(304), 3*f(305), 3*f(306), 3*f(307), 3*f(308), 3*f(309) &
    , 3*f(310), 3*f(311), 3*f(312), 3*f(313), 3*f(314), 3*f(315), 3*f(316), 3*f(317), 4*f(318), 3*f(319), 3*f(320), 3*f(321) &
    , 3*f(322), 3*f(323), 3*f(324), 3*f(325), 3*f(326), 3*f(327), 3*f(328), 3*f(329), 3*f(330), 3*f(331), 3*f(332), 3*f(333) &
    , 3*f(334), 3*f(335), 3*f(336), 3*f(337), 3*f(338), 3*f(339), 3*f(340), 3*f(341), 3*f(342), 4*f(343), 3*f(344), 3*f(345) &
    , 3*f(346), 3*f(347), 3*f(348), 3*f(349), 3*f(350), 3*f(351), 3*f(352), 3*f(353), 3*f(354), 3*f(355), 3*f(356), 3*f(357) &
    , 3*f(358), 3*f(359), 4*f(360), 3*f(361), 3*f(362), 3*f(363), 3*f(364), 3*f(365), 3*f(366), 3*f(367), 3*f(368), 3*f(369) &
    , 3*f(370), 3*f(371), 3*f(372), 3*f(373), 3*f(374), 3*f(375), 3*f(376), 3*f(377), 3*f(378), 3*f(379), 3*f(380), 3*f(381) &
    , 3*f(382), 3*f(383), 3*f(384), 3*f(385), 3*f(386), 3*f(387), 3*f(388), 3*f(389), 3*f(390), 3*f(391), 3*f(392), 3*f(393) &
    , 3*f(394), 3*f(395), 3*f(396), 3*f(397), 3*f(398), 3*f(399), 3*f(400), 3*f(401), 3*f(402), 3*f(403), 3*f(404), 3*f(405) &
    , 3*f(406), 3*f(407), 3*f(408), 3*f(409), 3*f(410), 3*f(411), 3*f(412), 3*f(413), 3*f(414), 3*f(415), 3*f(416), 3*f(417) &
    , 3*f(418), 3*f(419), 3*f(420), 3*f(421), 3*f(422), 3*f(423), 3*f(424), 3*f(425), 3*f(426), 3*f(427), 3*f(428), 3*f(429) &
    , 3*f(430), 3*f(431), 3*f(432), 3*f(433), 3*f(434), 3*f(435), 3*f(436), 3*f(437), 3*f(438), 3*f(439), 3*f(440), 3*f(441) &
    , 3*f(442), 3*f(443), 3*f(444), 3*f(445), 3*f(446), 3*f(447), 3*f(448), 3*f(449), 3*f(450), 3*f(451), 3*f(452), 3*f(453) &
    , 3*f(454), 3*f(455), 3*f(456), 3*f(457), 3*f(458), 3*f(459), 3*f(460), 3*f(461), 3*f(462), 3*f(463), 3*f(464), 3*f(465) &
    , 3*f(466), 3*f(467), 3*f(468), 3*f(469), 3*f(470), 3*f(471), 3*f(472), 3*f(473), 3*f(474), 3*f(475), 3*f(476), 3*f(477) &
    , 3*f(478), 3*f(479), 3*f(480), 3*f(481), 3*f(482), 3*f(483), 3*f(484), 3*f(485), 3*f(486), 3*f(487), 3*f(488), 3*f(489) &
    , 3*f(490), 3*f(491), 9*f(492), 9*f(493), 9*f(494), 9*f(495), 9*f(496), 3*f(497), 3*f(498), 3*f(499), 3*f(500), 3*f(501) &
    , 3*f(502), 9*f(503), 9*f(504), 9*f(505), 9*f(506), 9*f(507), 9*f(508), 9*f(509), 3*f(510), 9*f(511), 9*f(512), 3*f(513) &
    , 9*f(514), 9*f(515), 3*f(516), 3*f(517), 9*f(518), 9*f(519), 9*f(520), 9*f(521), 9*f(522), 3*f(523), 3*f(524), 3*f(525) &
    , 3*f(526), 9*f(527), 9*f(528), 9*f(529), 9*f(530), 9*f(531), 9*f(532), 9*f(533), 9*f(534), 9*f(535), 9*f(536), 9*f(537) &
    , 9*f(538), 3*f(539), 3*f(540), 3*f(541), 3*f(542), 3*f(543), 3*f(544), 3*f(545), 3*f(546), 3*f(547), 3*f(548), 9*f(549) &
    , 9*f(550), 9*f(551), 9*f(552), 9*f(553), 9*f(554), 9*f(555), 9*f(556), 9*f(557), 9*f(558), 9*f(559), 3*f(560), 9*f(560) &
    , 3*f(561), 9*f(561), 3*f(562), 3*f(563), 3*f(564), 9*f(565), 9*f(566), 9*f(567), 3*f(568), 9*f(568), 3*f(569), 9*f(569) &
    , 3*f(570), 3*f(571), 3*f(572), 9*f(573), 9*f(574), 9*f(575), 9*f(576), 3*f(577), 9*f(578), 3*f(579), 3*f(580), 9*f(580) &
    , 3*f(581), 9*f(581), 3*f(582), 3*f(583), 3*f(584), 9*f(585), 9*f(586), 9*f(587), 9*f(588), 3*f(589), 9*f(590), 3*f(591) &
    , 3*f(592), 9*f(592), 3*f(593), 9*f(593), 3*f(594) ]
  c = (1._/**/REALKIND / 3) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3) - MH2)+L(6,3))
  den(2) = 1 /((L(5,12) - MZ2)+L(6,12))
  den(4) = 1 /((L(5,20) - MZ2)+L(6,20))
  den(6) = 1 /((L(5,24) - MH2)+L(6,24))
  den(8) = 1 /((L(5,5) - MB2)+L(6,5))
  den(9) = 1 /((L(5,10) - MB2)+L(6,10))
  den(11) = 1 /((L(5,18) - MB2)+L(6,18))
  den(14) = 1 /((L(5,9) - MB2)+L(6,9))
  den(15) = 1 /((L(5,6) - MB2)+L(6,6))
  den(17) = 1 /((L(5,17) - MB2)+L(6,17))
  den(26) = 1 /((L(5,28) - MH2)+L(6,28))
  den(28) = 1 /((L(5,20))+L(6,20))
  den(31) = 1 /((L(5,12))+L(6,12))
  den(36) = 1 /((L(5,19) - MZ2)+L(6,19))
  den(41) = 1 /((L(5,11) - MZ2)+L(6,11))
  den(46) = 1 /((L(5,7) - MH2)+L(6,7))
  den(49) = 1 /((L(5,26) - MB2)+L(6,26))
  den(52) = 1 /((L(5,21) - MB2)+L(6,21))
  den(57) = 1 /((L(5,13) - MB2)+L(6,13))
  den(64) = 1 /((L(5,22) - MB2)+L(6,22))
  den(67) = 1 /((L(5,25) - MB2)+L(6,25))
  den(70) = 1 /((L(5,14) - MB2)+L(6,14))
  den(87) = 1 /((L(5,11))+L(6,11))
  den(104) = 1 /((L(5,19))+L(6,19))
  den(113) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(114) = 1 /((L(5,3))+L(6,3))
  den(115) = 1 /((L(5,7) - MZ2)+L(6,7))
  den(117) = 1 /((L(5,11) - MH2)+L(6,11))
  den(119) = 1 /((L(5,19) - MH2)+L(6,19))
  den(122) = 1 /((L(5,7))+L(6,7))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(1)*den(4)
  den(7) = den(1)*den(6)
  den(10) = den(8)*den(9)
  den(12) = den(8)*den(11)
  den(13) = den(6)*den(8)
  den(16) = den(14)*den(15)
  den(18) = den(15)*den(17)
  den(19) = den(6)*den(15)
  den(20) = den(11)*den(14)
  den(21) = den(4)*den(14)
  den(22) = den(9)*den(17)
  den(23) = den(4)*den(9)
  den(24) = den(2)*den(17)
  den(25) = den(2)*den(11)
  den(27) = den(1)*den(26)
  den(29) = den(14)*den(28)
  den(30) = den(9)*den(28)
  den(32) = den(17)*den(31)
  den(33) = den(11)*den(31)
  den(34) = den(2)*den(26)
  den(35) = den(1)*den(34)
  den(37) = den(1)*den(36)
  den(38) = den(2)*den(37)
  den(39) = den(4)*den(26)
  den(40) = den(1)*den(39)
  den(42) = den(1)*den(41)
  den(43) = den(4)*den(42)
  den(44) = den(6)*den(26)
  den(45) = den(1)*den(44)
  den(47) = den(1)*den(46)
  den(48) = den(6)*den(47)
  den(50) = den(9)*den(49)
  den(51) = den(8)*den(50)
  den(53) = den(8)*den(52)
  den(54) = den(9)*den(53)
  den(55) = den(11)*den(49)
  den(56) = den(8)*den(55)
  den(58) = den(8)*den(57)
  den(59) = den(11)*den(58)
  den(60) = den(6)*den(49)
  den(61) = den(8)*den(60)
  den(62) = den(8)*den(46)
  den(63) = den(6)*den(62)
  den(65) = den(15)*den(64)
  den(66) = den(14)*den(65)
  den(68) = den(14)*den(67)
  den(69) = den(15)*den(68)
  den(71) = den(15)*den(70)
  den(72) = den(17)*den(71)
  den(73) = den(17)*den(67)
  den(74) = den(15)*den(73)
  den(75) = den(6)*den(67)
  den(76) = den(15)*den(75)
  den(77) = den(15)*den(46)
  den(78) = den(6)*den(77)
  den(79) = den(11)*den(64)
  den(80) = den(14)*den(79)
  den(81) = den(14)*den(57)
  den(82) = den(11)*den(81)
  den(83) = den(4)*den(64)
  den(84) = den(14)*den(83)
  den(85) = den(14)*den(41)
  den(86) = den(4)*den(85)
  den(88) = den(14)*den(87)
  den(89) = den(4)*den(88)
  den(90) = den(9)*den(70)
  den(91) = den(17)*den(90)
  den(92) = den(17)*den(52)
  den(93) = den(9)*den(92)
  den(94) = den(4)*den(52)
  den(95) = den(9)*den(94)
  den(96) = den(9)*den(41)
  den(97) = den(4)*den(96)
  den(98) = den(9)*den(87)
  den(99) = den(4)*den(98)
  den(100) = den(2)*den(70)
  den(101) = den(17)*den(100)
  den(102) = den(17)*den(36)
  den(103) = den(2)*den(102)
  den(105) = den(17)*den(104)
  den(106) = den(2)*den(105)
  den(107) = den(2)*den(57)
  den(108) = den(11)*den(107)
  den(109) = den(11)*den(36)
  den(110) = den(2)*den(109)
  den(111) = den(11)*den(104)
  den(112) = den(2)*den(111)
  den(116) = den(113)*den(115)
  den(118) = den(113)*den(117)
  den(120) = den(113)*den(119)
  den(121) = den(8)*den(115)
  den(123) = den(8)*den(122)
  den(124) = den(15)*den(115)
  den(125) = den(15)*den(122)
  den(126) = den(14)*den(117)
  den(127) = den(9)*den(117)
  den(128) = den(17)*den(119)
  den(129) = den(11)*den(119)
  den(130) = den(2)*den(113)
  den(131) = den(2)*den(114)
  den(132) = den(4)*den(113)
  den(133) = den(4)*den(114)
  den(134) = den(6)*den(113)
  den(135) = den(6)*den(114)
  den(136) = den(26)*den(113)
  den(137) = den(26)*den(114)
  den(138) = den(2)*den(120)
  den(139) = den(34)*den(113)
  den(140) = den(34)*den(114)
  den(141) = den(4)*den(118)
  den(142) = den(39)*den(113)
  den(143) = den(39)*den(114)
  den(144) = den(6)*den(116)
  den(145) = den(44)*den(113)
  den(146) = den(44)*den(114)
  den(147) = den(6)*den(121)
  den(148) = den(6)*den(123)
  den(149) = den(6)*den(124)
  den(150) = den(6)*den(125)
  den(151) = den(4)*den(126)
  den(152) = den(4)*den(127)
  den(153) = den(2)*den(128)
  den(154) = den(2)*den(129)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_pphvv_ew_bbxhzz_1_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,220))
  allocate(M1helarray(1,hel_states))
  allocate(M1helarray_ct(2,hel_states))
  allocate(M0_col1_helarray(2,hel_states))
  A(1:hel_states,1:220)%j = 0
  A(1:hel_states,1:220)%e = 0
  A(1:hel_states,1:220)%hf = 0
  A(1:hel_states,1:220)%s = 0
#if 1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(2,hel_states,16))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
#else
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
  use ol_loop_storage_pphvv_ew_bbxhzz_1_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for bottom anti-bottom higgs Z Z -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_pphvv_ew_bbxhzz_1, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_pphvv_ew_bbxhzz_1, only: &
    & external_perm_pphvv_ew_bbxhzz_1, &
    & external_perm_inv_pphvv_ew_bbxhzz_1, &
    & extcomb_perm_pphvv_ew_bbxhzz_1, &
    & average_factor_pphvv_ew_bbxhzz_1
  use ol_external_pphvv_ew_bbxhzz_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_pphvv_ew_bbxhzz_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pphvv_ew_bbxhzz_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_pphvv_ew_bbxhzz_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02
  logical, intent(in) :: qp_kinematics
  real(REALKIND),  intent(out), optional :: M2ct
  real(REALKIND),  intent(out), optional :: M2colint(16)
  real(REALKIND) :: iM2ct
  real(REALKIND) :: iM2colint(16)

  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(1), M2(2)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak
  logical              :: do_ct, do_colint
#if 5 > 3
  integer :: ind_cc_comb(5)
#endif
  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if (present(M2ct)) then
    do_ct = .true.
  else
    do_ct = .false.
  end if

  if (present(M2colint)) then
    do_colint = .true.
  else
    do_colint = .false.
  end if

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, qp_kinematics, M2ct=iM2ct, M2colint=iM2colint)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,220))
  end if

  if (do_ct) call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()
  if (do_ct) call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  if (do_ct) call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMB, nMB, nMH, nMZ, nMZ ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_pphvv_ew_bbxhzz_1, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMB, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rMB, H2, ex2, POLSEL(2),2)
  call pol_wf_S(P(:,3), rMH, H3, ex3, POLSEL(3),3)
  call pol_wf_V(P(:,4), rMZ, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rMZ, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_VVS_S(ntry, ex4(:), ex5(:), ex3(:), wf9(:,1), n4(:,1), t4x9(:,:,1))
  call vert_TV_S(ntry, ex3(:), 4, ex4(:), 8, wf3(:,1), n3(:,2), t3x3(:,:,1))
  call vert_TV_S(ntry, wf4(:,1), 3, ex5(:), 16, wf12(:,1), n3(:,3), t3x12(:,:,1))
  call vert_SV_V(ntry, ex3(:), ex4(:), wf3(:,2), n3(:,4), t3x3(:,:,2))
  call vert_SV_V(ntry, wf4(:,1), ex5(:), wf12(:,2), n3(:,5), t3x12(:,:,2))
  call vert_TV_S(ntry, ex3(:), 4, ex5(:), 16, wf3(:,3), n3(:,6), t3x3(:,:,3))
  call vert_TV_S(ntry, wf4(:,1), 3, ex4(:), 8, wf12(:,3), n3(:,7), t3x12(:,:,3))
  call vert_SV_V(ntry, ex3(:), ex5(:), wf3(:,4), n3(:,8), t3x3(:,:,4))
  call vert_SV_V(ntry, wf4(:,1), ex4(:), wf12(:,4), n3(:,9), t3x12(:,:,4))
  call vert_VV_S(ntry, ex4(:), ex5(:), wf9(:,2), n3(:,10), t3x9(:,:,1))
  call vert_SS_S(ntry, wf4(:,1), ex3(:), wf4(:,2), n3(:,11), t3x4(:,:,2))
  call vert_QS_A(gH,ntry, ex1(:), ex3(:), wf2(:,1), n3(:,12), t3x2(:,:,1))
  call vert_AZ_Q(gZd,ntry, ex2(:), ex4(:), wf6(:,1), n3(:,13), t3x6(:,:,1))
  call prop_Q_A(ntry, wf2(:,1), 5, MB, 1_intkind1, wf2(:,2), n2(1))
  call prop_A_Q(ntry, wf6(:,1), 10, MB, 1_intkind1, wf6(:,2), n2(2))
  call vert_ZQ_A(gZd,ntry, ex5(:), wf2(:,2), wf6(:,3), n3(:,14), t3x6(:,:,2))
  call vert_AZ_Q(gZd,ntry, ex2(:), ex5(:), wf6(:,4), n3(:,15), t3x6(:,:,3))
  call prop_A_Q(ntry, wf6(:,4), 18, MB, 1_intkind1, wf6(:,5), n2(3))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf2(:,2), wf6(:,6), n3(:,16), t3x6(:,:,4))
  call vert_AQ_S(gH,ntry, ex2(:), wf2(:,2), wf4(:,3), n3(:,17), t3x4(:,:,3))
  call vert_ZQ_A(gZd,ntry, ex4(:), ex1(:), wf6(:,7), n3(:,18), t3x6(:,:,5))
  call vert_SA_Q(gH,ntry, ex3(:), ex2(:), wf2(:,3), n3(:,19), t3x2(:,:,2))
  call prop_Q_A(ntry, wf6(:,7), 9, MB, 1_intkind1, wf6(:,8), n2(4))
  call prop_A_Q(ntry, wf2(:,3), 6, MB, 1_intkind1, wf2(:,4), n2(5))
  call vert_ZQ_A(gZd,ntry, ex5(:), wf6(:,8), wf18(:,1), n3(:,20), t3x18(:,:,1))
  call vert_ZQ_A(gZd,ntry, ex5(:), ex1(:), wf6(:,9), n3(:,21), t3x6(:,:,6))
  call prop_Q_A(ntry, wf6(:,9), 17, MB, 1_intkind1, wf6(:,10), n2(6))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf6(:,10), wf18(:,2), n3(:,22), t3x18(:,:,2))
  call vert_AQ_S(gH,ntry, wf2(:,4), ex1(:), wf4(:,4), n3(:,23), t3x4(:,:,4))
  call vert_QS_A(gH,ntry, wf6(:,8), ex3(:), wf6(:,11), n3(:,24), t3x6(:,:,7))
  call vert_AQ_S(gX,ntry, ex2(:), wf6(:,8), wf12(:,5), n3(:,25), t3x12(:,:,5))
  call vert_QA_Z(gZd,ntry, wf6(:,8), ex2(:), wf12(:,6), n3(:,26), t3x12(:,:,6))
  call vert_QS_A(gH,ntry, wf6(:,10), ex3(:), wf6(:,12), n3(:,27), t3x6(:,:,8))
  call vert_AQ_S(gX,ntry, wf6(:,2), ex1(:), wf12(:,7), n3(:,28), t3x12(:,:,7))
  call vert_QA_Z(gZd,ntry, ex1(:), wf6(:,2), wf12(:,8), n3(:,29), t3x12(:,:,8))
  call vert_AQ_S(gX,ntry, ex2(:), wf6(:,10), wf12(:,9), n3(:,30), t3x12(:,:,9))
  call vert_QA_Z(gZd,ntry, wf6(:,10), ex2(:), wf12(:,10), n3(:,31), t3x12(:,:,10))
  call vert_AQ_S(gX,ntry, wf6(:,5), ex1(:), wf12(:,11), n3(:,32), t3x12(:,:,11))
  call vert_QA_Z(gZd,ntry, ex1(:), wf6(:,5), wf12(:,12), n3(:,33), t3x12(:,:,12))
  call counter_VVS_S(ntry, ex4(:), ex5(:), ex3(:), wf9(:,3), n4(:,2), t4x9(:,:,2))
  call counter_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,5), n3(:,34), t3x4(:,:,5))
  call counter_AQ_S(EWctHbb,ntry, ex2(:), ex1(:), wf4(:,6), n3(:,35), t3x4(:,:,6))
  call counter_TV_S(ntry, wf4(:,1), 3, ex5(:), 16, wf12(:,13), n3(:,36), t3x12(:,:,13))
  call counter_SV_V(ntry, wf4(:,1), ex5(:), wf12(:,14), n3(:,37), t3x12(:,:,14))
  call counter_TV_S(ntry, wf4(:,1), 3, ex4(:), 8, wf12(:,15), n3(:,38), t3x12(:,:,15))
  call counter_SV_V(ntry, wf4(:,1), ex4(:), wf12(:,16), n3(:,39), t3x12(:,:,16))
  call counter_VV_S(ntry, ex4(:), ex5(:), wf9(:,4), n3(:,40), t3x9(:,:,2))
  call counter_S_S(EWctHH,ntry, wf4(:,1), 3, wf4(:,7), n2(7))
  call counter_SS_S(ntry, wf4(:,1), ex3(:), wf4(:,8), n3(:,41), t3x4(:,:,7))
  call counter_TV_S(ntry, ex3(:), 4, ex5(:), 16, wf3(:,5), n3(:,42), t3x3(:,:,5))
  call counter_SV_V(ntry, ex3(:), ex5(:), wf3(:,6), n3(:,43), t3x3(:,:,6))
  call counter_TV_S(ntry, ex3(:), 4, ex4(:), 8, wf3(:,7), n3(:,44), t3x3(:,:,7))
  call counter_SV_V(ntry, ex3(:), ex4(:), wf3(:,8), n3(:,45), t3x3(:,:,8))
  call counter_ZQ_A(gZd,ntry, ex5(:), wf2(:,2), wf6(:,13), n3(:,46), t3x6(:,:,9))
  call counter_ZQ_A(EWctVbb,ntry, ex5(:), wf2(:,2), wf6(:,14), n3(:,47), t3x6(:,:,10))
  call counter_ZQ_A(gZd,ntry, ex4(:), wf2(:,2), wf6(:,15), n3(:,48), t3x6(:,:,11))
  call counter_ZQ_A(EWctVbb,ntry, ex4(:), wf2(:,2), wf6(:,16), n3(:,49), t3x6(:,:,12))
  call counter_ZQ_A(gZd,ntry, ex5(:), wf6(:,8), wf18(:,3), n3(:,50), t3x18(:,:,3))
  call counter_ZQ_A(EWctVbb,ntry, ex5(:), wf6(:,8), wf18(:,4), n3(:,51), t3x18(:,:,4))
  call counter_ZQ_A(gZd,ntry, ex4(:), wf6(:,10), wf18(:,5), n3(:,52), t3x18(:,:,5))
  call counter_ZQ_A(EWctVbb,ntry, ex4(:), wf6(:,10), wf18(:,6), n3(:,53), t3x18(:,:,6))
  call counter_QS_A(gH,ntry, wf6(:,8), ex3(:), wf6(:,17), n3(:,54), t3x6(:,:,13))
  call counter_QS_A(EWctHbb,ntry, wf6(:,8), ex3(:), wf6(:,18), n3(:,55), t3x6(:,:,14))
  call vert_QA_V(ntry, wf6(:,8), ex2(:), wf12(:,17), n3(:,56), t3x12(:,:,17))
  call counter_QS_A(gH,ntry, wf6(:,10), ex3(:), wf6(:,19), n3(:,57), t3x6(:,:,15))
  call counter_QS_A(EWctHbb,ntry, wf6(:,10), ex3(:), wf6(:,20), n3(:,58), t3x6(:,:,16))
  call vert_QA_V(ntry, ex1(:), wf6(:,2), wf12(:,18), n3(:,59), t3x12(:,:,18))
  call vert_QA_V(ntry, wf6(:,10), ex2(:), wf12(:,19), n3(:,60), t3x12(:,:,19))
  call vert_QA_V(ntry, ex1(:), wf6(:,5), wf12(:,20), n3(:,61), t3x12(:,:,20))
  call counter_AQ_S(gH,ntry, ex2(:), wf2(:,2), wf4(:,9), n3(:,62), t3x4(:,:,8))
  call counter_AQ_S(EWctHbb,ntry, ex2(:), wf2(:,2), wf4(:,10), n3(:,63), t3x4(:,:,9))
  call counter_AZ_Q(gZd,ntry, ex2(:), ex5(:), wf6(:,21), n3(:,64), t3x6(:,:,17))
  call prop_A_Q(ntry, wf6(:,21), 18, MB, 1_intkind1, wf6(:,22), n2(8))
  call counter_AZ_Q(EWctVbb,ntry, ex2(:), ex5(:), wf6(:,23), n3(:,65), t3x6(:,:,18))
  call prop_A_Q(ntry, wf6(:,23), 18, MB, 1_intkind1, wf6(:,24), n2(9))
  call counter_AZ_Q(gZd,ntry, ex2(:), ex4(:), wf6(:,25), n3(:,66), t3x6(:,:,19))
  call prop_A_Q(ntry, wf6(:,25), 10, MB, 1_intkind1, wf6(:,26), n2(10))
  call counter_AZ_Q(EWctVbb,ntry, ex2(:), ex4(:), wf6(:,27), n3(:,67), t3x6(:,:,20))
  call prop_A_Q(ntry, wf6(:,27), 10, MB, 1_intkind1, wf6(:,28), n2(11))
  call counter_AQ_S(gX,ntry, ex2(:), wf6(:,8), wf12(:,21), n3(:,68), t3x12(:,:,21))
  call counter_AQ_S(EWctXbb,ntry, ex2(:), wf6(:,8), wf12(:,22), n3(:,69), t3x12(:,:,22))
  call counter_QA_Z(gZd,ntry, wf6(:,8), ex2(:), wf12(:,23), n3(:,70), t3x12(:,:,23))
  call counter_QA_Z(EWctVbb,ntry, wf6(:,8), ex2(:), wf12(:,24), n3(:,71), t3x12(:,:,24))
  call counter_AQ_S(gX,ntry, ex2(:), wf6(:,10), wf12(:,25), n3(:,72), t3x12(:,:,25))
  call counter_AQ_S(EWctXbb,ntry, ex2(:), wf6(:,10), wf12(:,26), n3(:,73), t3x12(:,:,26))
  call counter_QA_Z(gZd,ntry, wf6(:,10), ex2(:), wf12(:,27), n3(:,74), t3x12(:,:,27))
  call counter_QA_Z(EWctVbb,ntry, wf6(:,10), ex2(:), wf12(:,28), n3(:,75), t3x12(:,:,28))
  call vert_AQ_S(gX,ntry, wf6(:,22), ex1(:), wf12(:,29), n3(:,76), t3x12(:,:,29))
  call vert_AQ_S(gX,ntry, wf6(:,24), ex1(:), wf12(:,30), n3(:,77), t3x12(:,:,30))
  call vert_QA_Z(gZd,ntry, ex1(:), wf6(:,22), wf12(:,31), n3(:,78), t3x12(:,:,31))
  call vert_QA_Z(gZd,ntry, ex1(:), wf6(:,24), wf12(:,32), n3(:,79), t3x12(:,:,32))
  call vert_AQ_S(gX,ntry, wf6(:,26), ex1(:), wf12(:,33), n3(:,80), t3x12(:,:,33))
  call vert_AQ_S(gX,ntry, wf6(:,28), ex1(:), wf12(:,34), n3(:,81), t3x12(:,:,34))
  call vert_QA_Z(gZd,ntry, ex1(:), wf6(:,26), wf12(:,35), n3(:,82), t3x12(:,:,35))
  call vert_QA_Z(gZd,ntry, ex1(:), wf6(:,28), wf12(:,36), n3(:,83), t3x12(:,:,36))
  call counter_SA_Q(gH,ntry, ex3(:), ex2(:), wf2(:,5), n3(:,84), t3x2(:,:,3))
  call prop_A_Q(ntry, wf2(:,5), 6, MB, 1_intkind1, wf2(:,6), n2(12))
  call counter_SA_Q(EWctHbb,ntry, ex3(:), ex2(:), wf2(:,7), n3(:,85), t3x2(:,:,4))
  call prop_A_Q(ntry, wf2(:,7), 6, MB, 1_intkind1, wf2(:,8), n2(13))
  call vert_AQ_S(gH,ntry, wf2(:,6), ex1(:), wf4(:,11), n3(:,86), t3x4(:,:,10))
  call vert_AQ_S(gH,ntry, wf2(:,8), ex1(:), wf4(:,12), n3(:,87), t3x4(:,:,11))
  call counter_AQ_S(gH,ntry, wf2(:,4), ex1(:), wf4(:,13), n3(:,88), t3x4(:,:,12))
  call counter_AQ_S(EWctHbb,ntry, wf2(:,4), ex1(:), wf4(:,14), n3(:,89), t3x4(:,:,13))
  call counter_ZQ_A(gZd,ntry, ex5(:), ex1(:), wf6(:,29), n3(:,90), t3x6(:,:,21))
  call prop_Q_A(ntry, wf6(:,29), 17, MB, 1_intkind1, wf6(:,30), n2(14))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf6(:,30), wf18(:,7), n3(:,91), t3x18(:,:,7))
  call counter_ZQ_A(EWctVbb,ntry, ex5(:), ex1(:), wf6(:,31), n3(:,92), t3x6(:,:,22))
  call prop_Q_A(ntry, wf6(:,31), 17, MB, 1_intkind1, wf6(:,32), n2(15))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf6(:,32), wf18(:,8), n3(:,93), t3x18(:,:,8))
  call counter_ZQ_A(gZd,ntry, ex4(:), ex1(:), wf6(:,33), n3(:,94), t3x6(:,:,23))
  call prop_Q_A(ntry, wf6(:,33), 9, MB, 1_intkind1, wf6(:,34), n2(16))
  call vert_ZQ_A(gZd,ntry, ex5(:), wf6(:,34), wf18(:,9), n3(:,95), t3x18(:,:,9))
  call counter_ZQ_A(EWctVbb,ntry, ex4(:), ex1(:), wf6(:,35), n3(:,96), t3x6(:,:,24))
  call prop_Q_A(ntry, wf6(:,35), 9, MB, 1_intkind1, wf6(:,36), n2(17))
  call vert_ZQ_A(gZd,ntry, ex5(:), wf6(:,36), wf18(:,10), n3(:,97), t3x18(:,:,10))
  call counter_AQ_S(gX,ntry, wf6(:,2), ex1(:), wf12(:,37), n3(:,98), t3x12(:,:,37))
  call counter_AQ_S(EWctXbb,ntry, wf6(:,2), ex1(:), wf12(:,38), n3(:,99), t3x12(:,:,38))
  call counter_QA_Z(gZd,ntry, ex1(:), wf6(:,2), wf12(:,39), n3(:,100), t3x12(:,:,39))
  call counter_QA_Z(EWctVbb,ntry, ex1(:), wf6(:,2), wf12(:,40), n3(:,101), t3x12(:,:,40))
  call vert_QS_A(gH,ntry, wf6(:,30), ex3(:), wf6(:,37), n3(:,102), t3x6(:,:,25))
  call vert_QS_A(gH,ntry, wf6(:,32), ex3(:), wf6(:,38), n3(:,103), t3x6(:,:,26))
  call counter_AQ_S(gX,ntry, wf6(:,5), ex1(:), wf12(:,41), n3(:,104), t3x12(:,:,41))
  call counter_AQ_S(EWctXbb,ntry, wf6(:,5), ex1(:), wf12(:,42), n3(:,105), t3x12(:,:,42))
  call counter_QA_Z(gZd,ntry, ex1(:), wf6(:,5), wf12(:,43), n3(:,106), t3x12(:,:,43))
  call counter_QA_Z(EWctVbb,ntry, ex1(:), wf6(:,5), wf12(:,44), n3(:,107), t3x12(:,:,44))
  call vert_AQ_S(gX,ntry, ex2(:), wf6(:,30), wf12(:,45), n3(:,108), t3x12(:,:,45))
  call vert_AQ_S(gX,ntry, ex2(:), wf6(:,32), wf12(:,46), n3(:,109), t3x12(:,:,46))
  call vert_QA_Z(gZd,ntry, wf6(:,30), ex2(:), wf12(:,47), n3(:,110), t3x12(:,:,47))
  call vert_QA_Z(gZd,ntry, wf6(:,32), ex2(:), wf12(:,48), n3(:,111), t3x12(:,:,48))
  call vert_QS_A(gH,ntry, wf6(:,34), ex3(:), wf6(:,39), n3(:,112), t3x6(:,:,27))
  call vert_QS_A(gH,ntry, wf6(:,36), ex3(:), wf6(:,40), n3(:,113), t3x6(:,:,28))
  call vert_AQ_S(gX,ntry, ex2(:), wf6(:,34), wf12(:,49), n3(:,114), t3x12(:,:,49))
  call vert_AQ_S(gX,ntry, ex2(:), wf6(:,36), wf12(:,50), n3(:,115), t3x12(:,:,50))
  call vert_QA_Z(gZd,ntry, wf6(:,34), ex2(:), wf12(:,51), n3(:,116), t3x12(:,:,51))
  call vert_QA_Z(gZd,ntry, wf6(:,36), ex2(:), wf12(:,52), n3(:,117), t3x12(:,:,52))
  call counter_QS_A(gH,ntry, ex1(:), ex3(:), wf2(:,9), n3(:,118), t3x2(:,:,5))
  call prop_Q_A(ntry, wf2(:,9), 5, MB, 1_intkind1, wf2(:,10), n2(18))
  call vert_ZQ_A(gZd,ntry, ex5(:), wf2(:,10), wf6(:,41), n3(:,119), t3x6(:,:,29))
  call counter_QS_A(EWctHbb,ntry, ex1(:), ex3(:), wf2(:,11), n3(:,120), t3x2(:,:,6))
  call prop_Q_A(ntry, wf2(:,11), 5, MB, 1_intkind1, wf2(:,12), n2(19))
  call vert_ZQ_A(gZd,ntry, ex5(:), wf2(:,12), wf6(:,42), n3(:,121), t3x6(:,:,30))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf2(:,10), wf6(:,43), n3(:,122), t3x6(:,:,31))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf2(:,12), wf6(:,44), n3(:,123), t3x6(:,:,32))
  call vert_AQ_S(gH,ntry, ex2(:), wf2(:,10), wf4(:,15), n3(:,124), t3x4(:,:,14))
  call vert_AQ_S(gH,ntry, ex2(:), wf2(:,12), wf4(:,16), n3(:,125), t3x4(:,:,15))
  call vert_TV_S(ntry, wf4(:,5), 3, ex5(:), 16, wf12(:,53), n3(:,126), t3x12(:,:,53))
  call vert_TV_S(ntry, wf4(:,6), 3, ex5(:), 16, wf12(:,54), n3(:,127), t3x12(:,:,54))
  call vert_SV_V(ntry, wf4(:,5), ex5(:), wf12(:,55), n3(:,128), t3x12(:,:,55))
  call vert_SV_V(ntry, wf4(:,6), ex5(:), wf12(:,56), n3(:,129), t3x12(:,:,56))
  call vert_TV_S(ntry, wf4(:,5), 3, ex4(:), 8, wf12(:,57), n3(:,130), t3x12(:,:,57))
  call vert_TV_S(ntry, wf4(:,6), 3, ex4(:), 8, wf12(:,58), n3(:,131), t3x12(:,:,58))
  call vert_SV_V(ntry, wf4(:,5), ex4(:), wf12(:,59), n3(:,132), t3x12(:,:,59))
  call vert_SV_V(ntry, wf4(:,6), ex4(:), wf12(:,60), n3(:,133), t3x12(:,:,60))
  call vert_SS_S(ntry, wf4(:,5), ex3(:), wf4(:,17), n3(:,134), t3x4(:,:,16))
  call vert_SS_S(ntry, wf4(:,6), ex3(:), wf4(:,18), n3(:,135), t3x4(:,:,17))
  call vert_VS_T(ntry, ex5(:), 16, wf3(:,1), 12, wf9(:,5), n3(:,136), t3x9(:,:,3))
  call vert_VV_S(ntry, wf3(:,2), ex5(:), wf9(:,6), n3(:,137), t3x9(:,:,4))
  call counter_S_S(EWctXX,ntry, wf3(:,1), 12, wf3(:,9), n2(20))
  call counter_S_V(EWctXZ,ntry, wf3(:,1), 12, wf3(:,10), n2(21))
  call counter_V_S(EWctXZ,ntry, wf3(:,2), 12, wf3(:,11), n2(22))
  call counter_V_V(EWctZZ,ntry, wf3(:,2), 12, wf3(:,12), n2(23))
  call vert_VS_T(ntry, ex4(:), 8, wf3(:,3), 20, wf9(:,7), n3(:,138), t3x9(:,:,5))
  call vert_VV_S(ntry, ex4(:), wf3(:,4), wf9(:,8), n3(:,139), t3x9(:,:,6))
  call counter_S_S(EWctXX,ntry, wf3(:,3), 20, wf3(:,13), n2(24))
  call counter_S_V(EWctXZ,ntry, wf3(:,3), 20, wf3(:,14), n2(25))
  call counter_V_S(EWctXZ,ntry, wf3(:,4), 20, wf3(:,15), n2(26))
  call counter_V_V(EWctZZ,ntry, wf3(:,4), 20, wf3(:,16), n2(27))
  call vert_SS_S(ntry, ex3(:), wf9(:,2), wf9(:,9), n3(:,140), t3x9(:,:,7))
  call counter_S_S(EWctHH,ntry, wf9(:,2), 24, wf9(:,10), n2(28))
  call vert_AZ_Q(gZd,ntry, wf6(:,2), ex5(:), wf18(:,11), n3(:,141), t3x18(:,:,11))
  call counter_Q_A(ctbb,5,ntry, wf2(:,2), 5, wf2(:,13), n2(29))
  call prop_A_Q(ntry, wf18(:,11), 26, MB, 1_intkind1, wf18(:,12), n2(30))
  call counter_Q_A_LR(EWctbb,ntry, wf2(:,2), 5, wf2(:,14), n2(31))
  call counter_A_Q(ctbb,5,ntry, wf6(:,2), 10, wf6(:,45), n2(32))
  call prop_Q_A(ntry, wf6(:,3), 21, MB, 1_intkind1, wf6(:,46), n2(33))
  call counter_A_Q_LR(EWctbb,ntry, wf6(:,2), 10, wf6(:,47), n2(34))
  call vert_AZ_Q(gZd,ntry, wf6(:,5), ex4(:), wf18(:,13), n3(:,142), t3x18(:,:,12))
  call prop_A_Q(ntry, wf18(:,13), 26, MB, 1_intkind1, wf18(:,14), n2(35))
  call counter_A_Q(ctbb,5,ntry, wf6(:,5), 18, wf6(:,48), n2(36))
  call prop_Q_A(ntry, wf6(:,6), 13, MB, 1_intkind1, wf6(:,49), n2(37))
  call counter_A_Q_LR(EWctbb,ntry, wf6(:,5), 18, wf6(:,50), n2(38))
  call vert_SA_Q(gH,ntry, wf9(:,2), ex2(:), wf18(:,15), n3(:,143), t3x18(:,:,13))
  call prop_A_Q(ntry, wf18(:,15), 26, MB, 1_intkind1, wf18(:,16), n2(39))
  call vert_AZ_Q(gZd,ntry, wf2(:,4), ex5(:), wf6(:,51), n3(:,144), t3x6(:,:,33))
  call counter_Q_A(ctbb,5,ntry, wf6(:,8), 9, wf6(:,52), n2(40))
  call prop_A_Q(ntry, wf6(:,51), 22, MB, 1_intkind1, wf6(:,53), n2(41))
  call counter_Q_A_LR(EWctbb,ntry, wf6(:,8), 9, wf6(:,54), n2(42))
  call counter_A_Q(ctbb,5,ntry, wf2(:,4), 6, wf2(:,15), n2(43))
  call prop_Q_A(ntry, wf18(:,1), 25, MB, 1_intkind1, wf18(:,17), n2(44))
  call counter_A_Q_LR(EWctbb,ntry, wf2(:,4), 6, wf2(:,16), n2(45))
  call vert_AZ_Q(gZd,ntry, wf2(:,4), ex4(:), wf6(:,55), n3(:,145), t3x6(:,:,34))
  call counter_Q_A(ctbb,5,ntry, wf6(:,10), 17, wf6(:,56), n2(46))
  call prop_A_Q(ntry, wf6(:,55), 14, MB, 1_intkind1, wf6(:,57), n2(47))
  call counter_Q_A_LR(EWctbb,ntry, wf6(:,10), 17, wf6(:,58), n2(48))
  call prop_Q_A(ntry, wf18(:,2), 25, MB, 1_intkind1, wf18(:,18), n2(49))
  call vert_QS_A(gH,ntry, ex1(:), wf9(:,2), wf18(:,19), n3(:,146), t3x18(:,:,14))
  call prop_Q_A(ntry, wf18(:,19), 25, MB, 1_intkind1, wf18(:,20), n2(50))
  call vert_SA_Q(gH,ntry, ex3(:), wf6(:,5), wf6(:,59), n3(:,147), t3x6(:,:,35))
  call prop_A_Q(ntry, wf6(:,59), 22, MB, 1_intkind1, wf6(:,60), n2(51))
  call prop_Q_A(ntry, wf6(:,11), 13, MB, 1_intkind1, wf6(:,61), n2(52))
  call vert_SA_Q(gX,ntry, wf3(:,3), ex2(:), wf6(:,62), n3(:,148), t3x6(:,:,36))
  call prop_A_Q(ntry, wf6(:,62), 22, MB, 1_intkind1, wf6(:,63), n2(53))
  call vert_AZ_Q(gZd,ntry, ex2(:), wf3(:,4), wf6(:,64), n3(:,149), t3x6(:,:,37))
  call prop_A_Q(ntry, wf6(:,64), 22, MB, 1_intkind1, wf6(:,65), n2(54))
  call counter_S_V(EWctXA,ntry, wf3(:,3), 20, wf3(:,17), n2(55))
  call counter_V_V(EWctAZ,ntry, wf3(:,4), 20, wf3(:,18), n2(56))
  call vert_SA_Q(gH,ntry, ex3(:), wf6(:,2), wf6(:,66), n3(:,150), t3x6(:,:,38))
  call prop_A_Q(ntry, wf6(:,66), 14, MB, 1_intkind1, wf6(:,67), n2(57))
  call prop_Q_A(ntry, wf6(:,12), 21, MB, 1_intkind1, wf6(:,68), n2(58))
  call vert_QS_A(gX,ntry, ex1(:), wf3(:,3), wf6(:,69), n3(:,151), t3x6(:,:,39))
  call prop_Q_A(ntry, wf6(:,69), 21, MB, 1_intkind1, wf6(:,70), n2(59))
  call vert_ZQ_A(gZd,ntry, wf3(:,4), ex1(:), wf6(:,71), n3(:,152), t3x6(:,:,40))
  call prop_Q_A(ntry, wf6(:,71), 21, MB, 1_intkind1, wf6(:,72), n2(60))
  call vert_SA_Q(gX,ntry, wf3(:,1), ex2(:), wf6(:,73), n3(:,153), t3x6(:,:,41))
  call prop_A_Q(ntry, wf6(:,73), 14, MB, 1_intkind1, wf6(:,74), n2(61))
  call vert_AZ_Q(gZd,ntry, ex2(:), wf3(:,2), wf6(:,75), n3(:,154), t3x6(:,:,42))
  call prop_A_Q(ntry, wf6(:,75), 14, MB, 1_intkind1, wf6(:,76), n2(62))
  call counter_S_V(EWctXA,ntry, wf3(:,1), 12, wf3(:,19), n2(63))
  call counter_V_V(EWctAZ,ntry, wf3(:,2), 12, wf3(:,20), n2(64))
  call vert_QS_A(gX,ntry, ex1(:), wf3(:,1), wf6(:,77), n3(:,155), t3x6(:,:,43))
  call prop_Q_A(ntry, wf6(:,77), 13, MB, 1_intkind1, wf6(:,78), n2(65))
  call vert_ZQ_A(gZd,ntry, wf3(:,2), ex1(:), wf6(:,79), n3(:,156), t3x6(:,:,44))
  call prop_Q_A(ntry, wf6(:,79), 13, MB, 1_intkind1, wf6(:,80), n2(66))
  call vert_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,19), n3(:,157), t3x4(:,:,18))
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,20), n3(:,158), t3x4(:,:,19))
  call vert_QA_Z(gZd,ntry, ex1(:), ex2(:), wf4(:,21), n3(:,159), t3x4(:,:,20))
  call vert_SS_S(ntry, wf4(:,19), ex3(:), wf4(:,22), n3(:,160), t3x4(:,:,21))
  call vert_ST_V(ntry, wf4(:,19), 3, ex3(:), 4, wf4(:,23), n3(:,161), t3x4(:,:,22))
  call vert_TV_S(ntry, ex3(:), 4, wf4(:,21), 3, wf4(:,24), n3(:,162), t3x4(:,:,23))
  call vert_SV_V(ntry, ex3(:), wf4(:,21), wf4(:,25), n3(:,163), t3x4(:,:,24))
  call vert_VS_T(ntry, ex4(:), 8, wf4(:,19), 3, wf12(:,61), n3(:,164), t3x12(:,:,61))
  call vert_VV_S(ntry, wf4(:,21), ex4(:), wf12(:,62), n3(:,165), t3x12(:,:,62))
  call vert_VS_T(ntry, ex5(:), 16, wf4(:,19), 3, wf12(:,63), n3(:,166), t3x12(:,:,63))
  call vert_VV_S(ntry, wf4(:,21), ex5(:), wf12(:,64), n3(:,167), t3x12(:,:,64))
  call vert_AQ_S(gX,ntry, ex2(:), wf2(:,2), wf4(:,26), n3(:,168), t3x4(:,:,25))
  call vert_QA_V(ntry, wf2(:,2), ex2(:), wf4(:,27), n3(:,169), t3x4(:,:,26))
  call vert_QA_Z(gZd,ntry, wf2(:,2), ex2(:), wf4(:,28), n3(:,170), t3x4(:,:,27))
  call vert_AQ_S(gX,ntry, wf2(:,4), ex1(:), wf4(:,29), n3(:,171), t3x4(:,:,28))
  call vert_QA_V(ntry, ex1(:), wf2(:,4), wf4(:,30), n3(:,172), t3x4(:,:,29))
  call vert_QA_Z(gZd,ntry, ex1(:), wf2(:,4), wf4(:,31), n3(:,173), t3x4(:,:,30))
  call vert_AQ_S(gH,ntry, ex2(:), wf6(:,8), wf12(:,65), n3(:,174), t3x12(:,:,65))
  call vert_AQ_S(gH,ntry, wf6(:,2), ex1(:), wf12(:,66), n3(:,175), t3x12(:,:,66))
  call vert_AQ_S(gH,ntry, ex2(:), wf6(:,10), wf12(:,67), n3(:,176), t3x12(:,:,67))
  call vert_AQ_S(gH,ntry, wf6(:,5), ex1(:), wf12(:,68), n3(:,177), t3x12(:,:,68))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    if (do_ct) call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  if (do_ct) M2ct = 0
  if (do_colint) M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    if (do_ct) call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      if (do_colint) call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    if (do_ct) M2ct = M2ct + M2add_ct
    if (do_colint) M2colint = M2colint + M2add_colint
  end do

#if 1 > 0 && 5 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    ind_cc_comb = [2,4,7,5,8]
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 5
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2

  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 3
do i4= 1, 3
do i3= 1, 1
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_SS(nsync, wf4(:,1), wf9(:,1), A(:,1), n3(:,178), t3x36(:,:,1), nhel, den(1))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,1), A(:,2), n3(:,179), t3x36(:,:,2), nhel, den(3))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,2), A(:,3), n3(:,180), t3x36(:,:,3), nhel, den(3))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,3), A(:,4), n3(:,181), t3x36(:,:,4), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,4), A(:,5), n3(:,182), t3x36(:,:,5), nhel, den(5))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,2), A(:,6), n3(:,183), t3x36(:,:,6), nhel, den(7))
    call Hcont_QA(nsync, wf6(:,2), wf6(:,3), A(:,7), n3(:,184), t3x36(:,:,7), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,5), wf6(:,6), A(:,8), n3(:,185), t3x36(:,:,8), nhel, den(12))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,3), A(:,9), n3(:,186), t3x36(:,:,9), nhel, den(13))
    call Hcont_QA(nsync, wf2(:,4), wf18(:,1), A(:,10), n3(:,187), t3x36(:,:,10), nhel, den(16))
    call Hcont_QA(nsync, wf2(:,4), wf18(:,2), A(:,11), n3(:,188), t3x36(:,:,11), nhel, den(18))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,4), A(:,12), n3(:,189), t3x36(:,:,12), nhel, den(19))
    call Hcont_QA(nsync, wf6(:,5), wf6(:,11), A(:,13), n3(:,190), t3x36(:,:,13), nhel, den(20))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,5), A(:,14), n3(:,191), t3x36(:,:,14), nhel, den(21))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,6), A(:,15), n3(:,192), t3x36(:,:,15), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,2), wf6(:,12), A(:,16), n3(:,193), t3x36(:,:,16), nhel, den(22))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,7), A(:,17), n3(:,194), t3x36(:,:,17), nhel, den(23))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,8), A(:,18), n3(:,195), t3x36(:,:,18), nhel, den(23))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,9), A(:,19), n3(:,196), t3x36(:,:,19), nhel, den(24))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,10), A(:,20), n3(:,197), t3x36(:,:,20), nhel, den(24))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,11), A(:,21), n3(:,198), t3x36(:,:,21), nhel, den(25))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,12), A(:,22), n3(:,199), t3x36(:,:,22), nhel, den(25))

    call Hcont_SS(nsync, wf4(:,1), wf9(:,3), A(:,23), n3(:,200), t3x36(:,:,23), nhel, den(1))
    call Hcont_SS(nsync, wf9(:,1), wf4(:,5), A(:,24), n3(:,201), t3x36(:,:,24), nhel, den(26))
    call Hcont_SS(nsync, wf9(:,1), wf4(:,6), A(:,25), n3(:,202), t3x36(:,:,25), nhel, den(26))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,13), A(:,26), n3(:,203), t3x36(:,:,26), nhel, den(3))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,14), A(:,27), n3(:,204), t3x36(:,:,27), nhel, den(3))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,15), A(:,28), n3(:,205), t3x36(:,:,28), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,16), A(:,29), n3(:,206), t3x36(:,:,29), nhel, den(5))
    call Hcont_SS(nsync, wf4(:,2), wf9(:,4), A(:,30), n3(:,207), t3x36(:,:,30), nhel, den(7))
    call Hcont_SS(nsync, wf9(:,1), wf4(:,7), A(:,31), n3(:,208), t3x36(:,:,31), nhel, den(27))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,8), A(:,32), n3(:,209), t3x36(:,:,32), nhel, den(7))
    call Hcont_SS(nsync, wf12(:,3), wf3(:,5), A(:,33), n3(:,210), t3x36(:,:,33), nhel, den(5))
    call Hcont_VV(nsync, wf12(:,4), wf3(:,6), A(:,34), n3(:,211), t3x36(:,:,34), nhel, den(5))
    call Hcont_SS(nsync, wf12(:,1), wf3(:,7), A(:,35), n3(:,212), t3x36(:,:,35), nhel, den(3))
    call Hcont_VV(nsync, wf12(:,2), wf3(:,8), A(:,36), n3(:,213), t3x36(:,:,36), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,2), wf6(:,13), A(:,37), n3(:,214), t3x36(:,:,37), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,2), wf6(:,14), A(:,38), n3(:,215), t3x36(:,:,38), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,5), wf6(:,15), A(:,39), n3(:,216), t3x36(:,:,39), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,5), wf6(:,16), A(:,40), n3(:,217), t3x36(:,:,40), nhel, den(12))
    call Hcont_SS(nsync, wf4(:,3), wf9(:,4), A(:,41), n3(:,218), t3x36(:,:,41), nhel, den(13))
    call Hcont_QA(nsync, wf2(:,4), wf18(:,3), A(:,42), n3(:,219), t3x36(:,:,42), nhel, den(16))
    call Hcont_QA(nsync, wf2(:,4), wf18(:,4), A(:,43), n3(:,220), t3x36(:,:,43), nhel, den(16))
    call Hcont_QA(nsync, wf2(:,4), wf18(:,5), A(:,44), n3(:,221), t3x36(:,:,44), nhel, den(18))
    call Hcont_QA(nsync, wf2(:,4), wf18(:,6), A(:,45), n3(:,222), t3x36(:,:,45), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,4), wf9(:,4), A(:,46), n3(:,223), t3x36(:,:,46), nhel, den(19))
    call Hcont_QA(nsync, wf6(:,5), wf6(:,17), A(:,47), n3(:,224), t3x36(:,:,47), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,5), wf6(:,18), A(:,48), n3(:,225), t3x36(:,:,48), nhel, den(20))
    call Hcont_SS(nsync, wf12(:,5), wf3(:,5), A(:,49), n3(:,226), t3x36(:,:,49), nhel, den(21))
    call Hcont_VV(nsync, wf3(:,6), wf12(:,17), A(:,50), n3(:,227), t3x36(:,:,50), nhel, den(29))
    call Hcont_VV(nsync, wf12(:,6), wf3(:,6), A(:,51), n3(:,228), t3x36(:,:,51), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,2), wf6(:,19), A(:,52), n3(:,229), t3x36(:,:,52), nhel, den(22))
    call Hcont_QA(nsync, wf6(:,2), wf6(:,20), A(:,53), n3(:,230), t3x36(:,:,53), nhel, den(22))
    call Hcont_SS(nsync, wf12(:,7), wf3(:,5), A(:,54), n3(:,231), t3x36(:,:,54), nhel, den(23))
    call Hcont_VV(nsync, wf3(:,6), wf12(:,18), A(:,55), n3(:,232), t3x36(:,:,55), nhel, den(30))
    call Hcont_VV(nsync, wf12(:,8), wf3(:,6), A(:,56), n3(:,233), t3x36(:,:,56), nhel, den(23))
    call Hcont_SS(nsync, wf12(:,9), wf3(:,7), A(:,57), n3(:,234), t3x36(:,:,57), nhel, den(24))
    call Hcont_VV(nsync, wf3(:,8), wf12(:,19), A(:,58), n3(:,235), t3x36(:,:,58), nhel, den(32))
    call Hcont_VV(nsync, wf12(:,10), wf3(:,8), A(:,59), n3(:,236), t3x36(:,:,59), nhel, den(24))
    call Hcont_SS(nsync, wf12(:,11), wf3(:,7), A(:,60), n3(:,237), t3x36(:,:,60), nhel, den(25))
    call Hcont_VV(nsync, wf3(:,8), wf12(:,20), A(:,61), n3(:,238), t3x36(:,:,61), nhel, den(33))
    call Hcont_VV(nsync, wf12(:,12), wf3(:,8), A(:,62), n3(:,239), t3x36(:,:,62), nhel, den(25))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,9), A(:,63), n3(:,240), t3x36(:,:,63), nhel, den(13))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,10), A(:,64), n3(:,241), t3x36(:,:,64), nhel, den(13))
    call Hcont_QA(nsync, wf6(:,6), wf6(:,22), A(:,65), n3(:,242), t3x36(:,:,65), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,6), wf6(:,24), A(:,66), n3(:,243), t3x36(:,:,66), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,3), wf6(:,26), A(:,67), n3(:,244), t3x36(:,:,67), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,3), wf6(:,28), A(:,68), n3(:,245), t3x36(:,:,68), nhel, den(10))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,21), A(:,69), n3(:,246), t3x36(:,:,69), nhel, den(21))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,22), A(:,70), n3(:,247), t3x36(:,:,70), nhel, den(21))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,23), A(:,71), n3(:,248), t3x36(:,:,71), nhel, den(21))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,24), A(:,72), n3(:,249), t3x36(:,:,72), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,11), wf6(:,22), A(:,73), n3(:,250), t3x36(:,:,73), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,11), wf6(:,24), A(:,74), n3(:,251), t3x36(:,:,74), nhel, den(20))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,25), A(:,75), n3(:,252), t3x36(:,:,75), nhel, den(24))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,26), A(:,76), n3(:,253), t3x36(:,:,76), nhel, den(24))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,27), A(:,77), n3(:,254), t3x36(:,:,77), nhel, den(24))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,28), A(:,78), n3(:,255), t3x36(:,:,78), nhel, den(24))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,29), A(:,79), n3(:,256), t3x36(:,:,79), nhel, den(25))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,30), A(:,80), n3(:,257), t3x36(:,:,80), nhel, den(25))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,31), A(:,81), n3(:,258), t3x36(:,:,81), nhel, den(25))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,32), A(:,82), n3(:,259), t3x36(:,:,82), nhel, den(25))
    call Hcont_QA(nsync, wf6(:,12), wf6(:,26), A(:,83), n3(:,260), t3x36(:,:,83), nhel, den(22))
    call Hcont_QA(nsync, wf6(:,12), wf6(:,28), A(:,84), n3(:,261), t3x36(:,:,84), nhel, den(22))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,33), A(:,85), n3(:,262), t3x36(:,:,85), nhel, den(23))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,34), A(:,86), n3(:,263), t3x36(:,:,86), nhel, den(23))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,35), A(:,87), n3(:,264), t3x36(:,:,87), nhel, den(23))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,36), A(:,88), n3(:,265), t3x36(:,:,88), nhel, den(23))
    call Hcont_QA(nsync, wf18(:,1), wf2(:,6), A(:,89), n3(:,266), t3x36(:,:,89), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,1), wf2(:,8), A(:,90), n3(:,267), t3x36(:,:,90), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,2), wf2(:,6), A(:,91), n3(:,268), t3x36(:,:,91), nhel, den(18))
    call Hcont_QA(nsync, wf18(:,2), wf2(:,8), A(:,92), n3(:,269), t3x36(:,:,92), nhel, den(18))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,11), A(:,93), n3(:,270), t3x36(:,:,93), nhel, den(19))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,12), A(:,94), n3(:,271), t3x36(:,:,94), nhel, den(19))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,13), A(:,95), n3(:,272), t3x36(:,:,95), nhel, den(19))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,14), A(:,96), n3(:,273), t3x36(:,:,96), nhel, den(19))
    call Hcont_QA(nsync, wf2(:,4), wf18(:,7), A(:,97), n3(:,274), t3x36(:,:,97), nhel, den(18))
    call Hcont_QA(nsync, wf2(:,4), wf18(:,8), A(:,98), n3(:,275), t3x36(:,:,98), nhel, den(18))
    call Hcont_QA(nsync, wf2(:,4), wf18(:,9), A(:,99), n3(:,276), t3x36(:,:,99), nhel, den(16))
    call Hcont_QA(nsync, wf2(:,4), wf18(:,10), A(:,100), n3(:,277), t3x36(:,:,100), nhel, den(16))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,37), A(:,101), n3(:,278), t3x36(:,:,101), nhel, den(23))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,38), A(:,102), n3(:,279), t3x36(:,:,102), nhel, den(23))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,39), A(:,103), n3(:,280), t3x36(:,:,103), nhel, den(23))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,40), A(:,104), n3(:,281), t3x36(:,:,104), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,2), wf6(:,37), A(:,105), n3(:,282), t3x36(:,:,105), nhel, den(22))
    call Hcont_QA(nsync, wf6(:,2), wf6(:,38), A(:,106), n3(:,283), t3x36(:,:,106), nhel, den(22))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,41), A(:,107), n3(:,284), t3x36(:,:,107), nhel, den(25))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,42), A(:,108), n3(:,285), t3x36(:,:,108), nhel, den(25))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,43), A(:,109), n3(:,286), t3x36(:,:,109), nhel, den(25))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,44), A(:,110), n3(:,287), t3x36(:,:,110), nhel, den(25))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,45), A(:,111), n3(:,288), t3x36(:,:,111), nhel, den(24))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,46), A(:,112), n3(:,289), t3x36(:,:,112), nhel, den(24))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,47), A(:,113), n3(:,290), t3x36(:,:,113), nhel, den(24))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,48), A(:,114), n3(:,291), t3x36(:,:,114), nhel, den(24))
    call Hcont_QA(nsync, wf6(:,5), wf6(:,39), A(:,115), n3(:,292), t3x36(:,:,115), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,5), wf6(:,40), A(:,116), n3(:,293), t3x36(:,:,116), nhel, den(20))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,49), A(:,117), n3(:,294), t3x36(:,:,117), nhel, den(21))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,50), A(:,118), n3(:,295), t3x36(:,:,118), nhel, den(21))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,51), A(:,119), n3(:,296), t3x36(:,:,119), nhel, den(21))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,52), A(:,120), n3(:,297), t3x36(:,:,120), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,2), wf6(:,41), A(:,121), n3(:,298), t3x36(:,:,121), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,2), wf6(:,42), A(:,122), n3(:,299), t3x36(:,:,122), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,5), wf6(:,43), A(:,123), n3(:,300), t3x36(:,:,123), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,5), wf6(:,44), A(:,124), n3(:,301), t3x36(:,:,124), nhel, den(12))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,15), A(:,125), n3(:,302), t3x36(:,:,125), nhel, den(13))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,16), A(:,126), n3(:,303), t3x36(:,:,126), nhel, den(13))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,53), A(:,127), n3(:,304), t3x36(:,:,127), nhel, den(3))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,54), A(:,128), n3(:,305), t3x36(:,:,128), nhel, den(3))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,55), A(:,129), n3(:,306), t3x36(:,:,129), nhel, den(3))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,56), A(:,130), n3(:,307), t3x36(:,:,130), nhel, den(3))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,57), A(:,131), n3(:,308), t3x36(:,:,131), nhel, den(5))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,58), A(:,132), n3(:,309), t3x36(:,:,132), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,59), A(:,133), n3(:,310), t3x36(:,:,133), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,60), A(:,134), n3(:,311), t3x36(:,:,134), nhel, den(5))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,17), A(:,135), n3(:,312), t3x36(:,:,135), nhel, den(7))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,18), A(:,136), n3(:,313), t3x36(:,:,136), nhel, den(7))
    call Hcont_SS(nsync, wf4(:,7), wf9(:,5), A(:,137), n3(:,314), t3x36(:,:,137), nhel, den(35))
    call Hcont_SS(nsync, wf4(:,7), wf9(:,6), A(:,138), n3(:,315), t3x36(:,:,138), nhel, den(35))
    call Hcont_SS(nsync, wf12(:,1), wf3(:,9), A(:,139), n3(:,316), t3x36(:,:,139), nhel, den(38))
    call Hcont_VV(nsync, wf12(:,2), wf3(:,10), A(:,140), n3(:,317), t3x36(:,:,140), nhel, den(38))
    call Hcont_SS(nsync, wf12(:,1), wf3(:,11), A(:,141), n3(:,318), t3x36(:,:,141), nhel, den(38))
    call Hcont_VV(nsync, wf12(:,2), wf3(:,12), A(:,142), n3(:,319), t3x36(:,:,142), nhel, den(38))
    call Hcont_SS(nsync, wf4(:,7), wf9(:,7), A(:,143), n3(:,320), t3x36(:,:,143), nhel, den(40))
    call Hcont_SS(nsync, wf4(:,7), wf9(:,8), A(:,144), n3(:,321), t3x36(:,:,144), nhel, den(40))
    call Hcont_SS(nsync, wf12(:,3), wf3(:,13), A(:,145), n3(:,322), t3x36(:,:,145), nhel, den(43))
    call Hcont_VV(nsync, wf12(:,4), wf3(:,14), A(:,146), n3(:,323), t3x36(:,:,146), nhel, den(43))
    call Hcont_SS(nsync, wf12(:,3), wf3(:,15), A(:,147), n3(:,324), t3x36(:,:,147), nhel, den(43))
    call Hcont_VV(nsync, wf12(:,4), wf3(:,16), A(:,148), n3(:,325), t3x36(:,:,148), nhel, den(43))
    call Hcont_SS(nsync, wf4(:,7), wf9(:,9), A(:,149), n3(:,326), t3x36(:,:,149), nhel, den(45))
    call Hcont_SS(nsync, wf4(:,2), wf9(:,10), A(:,150), n3(:,327), t3x36(:,:,150), nhel, den(48))
    call Hcont_QA(nsync, wf2(:,13), wf18(:,12), A(:,151), n3(:,328), t3x36(:,:,151), nhel, den(51))
    call Hcont_QA(nsync, wf18(:,12), wf2(:,14), A(:,152), n3(:,329), t3x36(:,:,152), nhel, den(51))
    call Hcont_QA(nsync, wf6(:,45), wf6(:,46), A(:,153), n3(:,330), t3x36(:,:,153), nhel, den(54))
    call Hcont_QA(nsync, wf6(:,46), wf6(:,47), A(:,154), n3(:,331), t3x36(:,:,154), nhel, den(54))
    call Hcont_QA(nsync, wf2(:,13), wf18(:,14), A(:,155), n3(:,332), t3x36(:,:,155), nhel, den(56))
    call Hcont_QA(nsync, wf2(:,14), wf18(:,14), A(:,156), n3(:,333), t3x36(:,:,156), nhel, den(56))
    call Hcont_QA(nsync, wf6(:,48), wf6(:,49), A(:,157), n3(:,334), t3x36(:,:,157), nhel, den(59))
    call Hcont_QA(nsync, wf6(:,49), wf6(:,50), A(:,158), n3(:,335), t3x36(:,:,158), nhel, den(59))
    call Hcont_QA(nsync, wf2(:,13), wf18(:,16), A(:,159), n3(:,336), t3x36(:,:,159), nhel, den(61))
    call Hcont_QA(nsync, wf2(:,14), wf18(:,16), A(:,160), n3(:,337), t3x36(:,:,160), nhel, den(61))
    call Hcont_SS(nsync, wf4(:,3), wf9(:,10), A(:,161), n3(:,338), t3x36(:,:,161), nhel, den(63))
    call Hcont_QA(nsync, wf6(:,52), wf6(:,53), A(:,162), n3(:,339), t3x36(:,:,162), nhel, den(66))
    call Hcont_QA(nsync, wf6(:,53), wf6(:,54), A(:,163), n3(:,340), t3x36(:,:,163), nhel, den(66))
    call Hcont_QA(nsync, wf2(:,15), wf18(:,17), A(:,164), n3(:,341), t3x36(:,:,164), nhel, den(69))
    call Hcont_QA(nsync, wf18(:,17), wf2(:,16), A(:,165), n3(:,342), t3x36(:,:,165), nhel, den(69))
    call Hcont_QA(nsync, wf6(:,56), wf6(:,57), A(:,166), n3(:,343), t3x36(:,:,166), nhel, den(72))
    call Hcont_QA(nsync, wf6(:,57), wf6(:,58), A(:,167), n3(:,344), t3x36(:,:,167), nhel, den(72))
    call Hcont_QA(nsync, wf2(:,15), wf18(:,18), A(:,168), n3(:,345), t3x36(:,:,168), nhel, den(74))
    call Hcont_QA(nsync, wf2(:,16), wf18(:,18), A(:,169), n3(:,346), t3x36(:,:,169), nhel, den(74))
    call Hcont_QA(nsync, wf2(:,15), wf18(:,20), A(:,170), n3(:,347), t3x36(:,:,170), nhel, den(76))
    call Hcont_QA(nsync, wf2(:,16), wf18(:,20), A(:,171), n3(:,348), t3x36(:,:,171), nhel, den(76))
    call Hcont_SS(nsync, wf4(:,4), wf9(:,10), A(:,172), n3(:,349), t3x36(:,:,172), nhel, den(78))
    call Hcont_QA(nsync, wf6(:,52), wf6(:,60), A(:,173), n3(:,350), t3x36(:,:,173), nhel, den(80))
    call Hcont_QA(nsync, wf6(:,54), wf6(:,60), A(:,174), n3(:,351), t3x36(:,:,174), nhel, den(80))
    call Hcont_QA(nsync, wf6(:,48), wf6(:,61), A(:,175), n3(:,352), t3x36(:,:,175), nhel, den(82))
    call Hcont_QA(nsync, wf6(:,50), wf6(:,61), A(:,176), n3(:,353), t3x36(:,:,176), nhel, den(82))
    call Hcont_QA(nsync, wf6(:,52), wf6(:,63), A(:,177), n3(:,354), t3x36(:,:,177), nhel, den(84))
    call Hcont_QA(nsync, wf6(:,54), wf6(:,63), A(:,178), n3(:,355), t3x36(:,:,178), nhel, den(84))
    call Hcont_QA(nsync, wf6(:,52), wf6(:,65), A(:,179), n3(:,356), t3x36(:,:,179), nhel, den(84))
    call Hcont_QA(nsync, wf6(:,54), wf6(:,65), A(:,180), n3(:,357), t3x36(:,:,180), nhel, den(84))
    call Hcont_SS(nsync, wf12(:,5), wf3(:,13), A(:,181), n3(:,358), t3x36(:,:,181), nhel, den(86))
    call Hcont_SS(nsync, wf12(:,5), wf3(:,15), A(:,182), n3(:,359), t3x36(:,:,182), nhel, den(86))
    call Hcont_VV(nsync, wf12(:,17), wf3(:,17), A(:,183), n3(:,360), t3x36(:,:,183), nhel, den(89))
    call Hcont_VV(nsync, wf12(:,6), wf3(:,14), A(:,184), n3(:,361), t3x36(:,:,184), nhel, den(86))
    call Hcont_VV(nsync, wf12(:,17), wf3(:,18), A(:,185), n3(:,362), t3x36(:,:,185), nhel, den(89))
    call Hcont_VV(nsync, wf12(:,6), wf3(:,16), A(:,186), n3(:,363), t3x36(:,:,186), nhel, den(86))
    call Hcont_QA(nsync, wf6(:,56), wf6(:,67), A(:,187), n3(:,364), t3x36(:,:,187), nhel, den(91))
    call Hcont_QA(nsync, wf6(:,58), wf6(:,67), A(:,188), n3(:,365), t3x36(:,:,188), nhel, den(91))
    call Hcont_QA(nsync, wf6(:,45), wf6(:,68), A(:,189), n3(:,366), t3x36(:,:,189), nhel, den(93))
    call Hcont_QA(nsync, wf6(:,47), wf6(:,68), A(:,190), n3(:,367), t3x36(:,:,190), nhel, den(93))
    call Hcont_QA(nsync, wf6(:,45), wf6(:,70), A(:,191), n3(:,368), t3x36(:,:,191), nhel, den(95))
    call Hcont_QA(nsync, wf6(:,47), wf6(:,70), A(:,192), n3(:,369), t3x36(:,:,192), nhel, den(95))
    call Hcont_QA(nsync, wf6(:,45), wf6(:,72), A(:,193), n3(:,370), t3x36(:,:,193), nhel, den(95))
    call Hcont_QA(nsync, wf6(:,47), wf6(:,72), A(:,194), n3(:,371), t3x36(:,:,194), nhel, den(95))
    call Hcont_SS(nsync, wf12(:,7), wf3(:,13), A(:,195), n3(:,372), t3x36(:,:,195), nhel, den(97))
    call Hcont_SS(nsync, wf12(:,7), wf3(:,15), A(:,196), n3(:,373), t3x36(:,:,196), nhel, den(97))
    call Hcont_VV(nsync, wf12(:,18), wf3(:,17), A(:,197), n3(:,374), t3x36(:,:,197), nhel, den(99))
    call Hcont_VV(nsync, wf12(:,8), wf3(:,14), A(:,198), n3(:,375), t3x36(:,:,198), nhel, den(97))
    call Hcont_VV(nsync, wf12(:,18), wf3(:,18), A(:,199), n3(:,376), t3x36(:,:,199), nhel, den(99))
    call Hcont_VV(nsync, wf12(:,8), wf3(:,16), A(:,200), n3(:,377), t3x36(:,:,200), nhel, den(97))
    call Hcont_QA(nsync, wf6(:,56), wf6(:,74), A(:,201), n3(:,378), t3x36(:,:,201), nhel, den(101))
    call Hcont_QA(nsync, wf6(:,58), wf6(:,74), A(:,202), n3(:,379), t3x36(:,:,202), nhel, den(101))
    call Hcont_QA(nsync, wf6(:,56), wf6(:,76), A(:,203), n3(:,380), t3x36(:,:,203), nhel, den(101))
    call Hcont_QA(nsync, wf6(:,58), wf6(:,76), A(:,204), n3(:,381), t3x36(:,:,204), nhel, den(101))
    call Hcont_SS(nsync, wf12(:,9), wf3(:,9), A(:,205), n3(:,382), t3x36(:,:,205), nhel, den(103))
    call Hcont_SS(nsync, wf12(:,9), wf3(:,11), A(:,206), n3(:,383), t3x36(:,:,206), nhel, den(103))
    call Hcont_VV(nsync, wf12(:,19), wf3(:,19), A(:,207), n3(:,384), t3x36(:,:,207), nhel, den(106))
    call Hcont_VV(nsync, wf12(:,10), wf3(:,10), A(:,208), n3(:,385), t3x36(:,:,208), nhel, den(103))
    call Hcont_VV(nsync, wf12(:,19), wf3(:,20), A(:,209), n3(:,386), t3x36(:,:,209), nhel, den(106))
    call Hcont_VV(nsync, wf12(:,10), wf3(:,12), A(:,210), n3(:,387), t3x36(:,:,210), nhel, den(103))
    call Hcont_QA(nsync, wf6(:,48), wf6(:,78), A(:,211), n3(:,388), t3x36(:,:,211), nhel, den(108))
    call Hcont_QA(nsync, wf6(:,50), wf6(:,78), A(:,212), n3(:,389), t3x36(:,:,212), nhel, den(108))
    call Hcont_QA(nsync, wf6(:,48), wf6(:,80), A(:,213), n3(:,390), t3x36(:,:,213), nhel, den(108))
    call Hcont_QA(nsync, wf6(:,50), wf6(:,80), A(:,214), n3(:,391), t3x36(:,:,214), nhel, den(108))
    call Hcont_SS(nsync, wf12(:,11), wf3(:,9), A(:,215), n3(:,392), t3x36(:,:,215), nhel, den(110))
    call Hcont_SS(nsync, wf12(:,11), wf3(:,11), A(:,216), n3(:,393), t3x36(:,:,216), nhel, den(110))
    call Hcont_VV(nsync, wf12(:,20), wf3(:,19), A(:,217), n3(:,394), t3x36(:,:,217), nhel, den(112))
    call Hcont_VV(nsync, wf12(:,12), wf3(:,10), A(:,218), n3(:,395), t3x36(:,:,218), nhel, den(110))
    call Hcont_VV(nsync, wf12(:,20), wf3(:,20), A(:,219), n3(:,396), t3x36(:,:,219), nhel, den(112))
    call Hcont_VV(nsync, wf12(:,12), wf3(:,12), A(:,220), n3(:,397), t3x36(:,:,220), nhel, den(110))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(2) ! M1helarray(2,nhel)
  integer :: empty(0), i

  M1(1)%j = (-A(j,2)%j-A(j,4)%j)*f(5)-A(j,1)%j*f(6)+(-A(j,9)%j-A(j,12)%j)*f(11)-A(j,6)%j*f(16)+(-A(j,3)%j-A(j,5)%j)*f(19)+( &
       -A(j,14)%j-A(j,17)%j-A(j,19)%j-A(j,21)%j)*f(26)+(A(j,7)%j+A(j,8)%j+A(j,10)%j+A(j,11)%j+A(j,13)%j+A(j,16)%j)*f(39) &
       +(A(j,15)%j+A(j,18)%j+A(j,20)%j+A(j,22)%j)*f(47)

  M2(1)%j = (-A(j,127)%j-A(j,131)%j)*f(9)-A(j,24)%j*f(10)+(A(j,159)%j+A(j,170)%j)*f(13)+(-A(j,63)%j-A(j,93)%j-A(j,95)%j &
       -A(j,125)%j)*f(14)-A(j,135)%j*f(18)+(-A(j,129)%j-A(j,133)%j)*f(21)+(A(j,177)%j+A(j,191)%j+A(j,201)%j+A(j,211)%j)*f(31)+( &
       -A(j,69)%j-A(j,75)%j-A(j,101)%j-A(j,107)%j)*f(32)+(-A(j,79)%j-A(j,85)%j-A(j,111)%j-A(j,117)%j)*f(33)+(-A(j,151)%j &
       -A(j,153)%j-A(j,155)%j-A(j,157)%j-A(j,162)%j-A(j,164)%j-A(j,166)%j-A(j,168)%j-A(j,173)%j-A(j,175)%j-A(j,187)%j &
       -A(j,189)%j)*f(44)+(A(j,47)%j+A(j,52)%j+A(j,89)%j+A(j,91)%j+A(j,121)%j+A(j,123)%j)*f(45)+(A(j,37)%j+A(j,39)%j+A(j,42)%j &
       +A(j,44)%j+A(j,65)%j+A(j,67)%j+A(j,73)%j+A(j,83)%j+A(j,97)%j+A(j,99)%j+A(j,105)%j+A(j,115)%j)*f(46)+(-A(j,179)%j-A(j,193)%j &
       -A(j,203)%j-A(j,213)%j)*f(50)+(A(j,71)%j+A(j,77)%j+A(j,81)%j+A(j,87)%j+A(j,103)%j+A(j,109)%j+A(j,113)%j+A(j,119)%j)*f(51)
  M2(2)%j = (A(j,50)%j+A(j,55)%j+A(j,58)%j+A(j,61)%j)*f(1)+(A(j,51)%j+A(j,56)%j+A(j,59)%j+A(j,62)%j)*f(2)+(-A(j,48)%j-A(j,53)%j &
       -A(j,90)%j-A(j,92)%j-A(j,122)%j-A(j,124)%j)*f(3)+(A(j,140)%j+A(j,141)%j+A(j,146)%j+A(j,147)%j)*f(4)+(A(j,137)%j+A(j,139)%j &
       +A(j,143)%j+A(j,145)%j)*f(7)+A(j,31)%j*f(8)+(A(j,160)%j+A(j,161)%j+A(j,171)%j+A(j,172)%j)*f(12)-A(j,32)%j*f(15)+(A(j,149)%j &
       +A(j,150)%j)*f(17)+(A(j,138)%j+A(j,142)%j+A(j,144)%j+A(j,148)%j)*f(20)+(A(j,182)%j+A(j,196)%j+A(j,206)%j+A(j,216)%j)*f(22) &
       +(-A(j,27)%j-A(j,29)%j-A(j,34)%j-A(j,36)%j)*f(23)+(-A(j,41)%j-A(j,46)%j)*f(24)-A(j,30)%j*f(25)+(A(j,128)%j &
       +A(j,132)%j)*f(27)+A(j,25)%j*f(28)+(-A(j,80)%j-A(j,86)%j-A(j,112)%j-A(j,118)%j+A(j,178)%j+A(j,181)%j+A(j,192)%j+A(j,195)%j &
       +A(j,202)%j+A(j,205)%j+A(j,212)%j+A(j,215)%j)*f(29)+(A(j,26)%j+A(j,28)%j+A(j,33)%j+A(j,35)%j)*f(30)+(A(j,64)%j+A(j,94)%j &
       +A(j,96)%j+A(j,126)%j)*f(34)+A(j,136)%j*f(35)+(A(j,130)%j+A(j,134)%j)*f(36)+(-A(j,183)%j-A(j,197)%j-A(j,207)%j &
       -A(j,217)%j)*f(37)+(-A(j,184)%j-A(j,198)%j-A(j,208)%j-A(j,218)%j)*f(38)+(A(j,38)%j+A(j,40)%j+A(j,43)%j+A(j,45)%j+A(j,66)%j &
       +A(j,68)%j+A(j,74)%j+A(j,84)%j+A(j,98)%j+A(j,100)%j+A(j,106)%j+A(j,116)%j-A(j,152)%j-A(j,154)%j-A(j,156)%j-A(j,158)%j &
       -A(j,163)%j-A(j,165)%j-A(j,167)%j-A(j,169)%j-A(j,174)%j-A(j,176)%j-A(j,188)%j-A(j,190)%j)*f(40)+(-A(j,70)%j-A(j,76)%j &
       -A(j,102)%j-A(j,108)%j)*f(41)+(A(j,49)%j+A(j,54)%j+A(j,57)%j+A(j,60)%j)*f(42)-A(j,23)%j*f(43)+(-A(j,185)%j-A(j,199)%j &
       -A(j,209)%j-A(j,219)%j)*f(48)+(A(j,72)%j+A(j,78)%j+A(j,82)%j+A(j,88)%j+A(j,104)%j+A(j,110)%j+A(j,114)%j+A(j,120)%j &
       -A(j,180)%j-A(j,186)%j-A(j,194)%j-A(j,200)%j-A(j,204)%j-A(j,210)%j-A(j,214)%j-A(j,220)%j)*f(49)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_bbxhzz_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_bbxhzz_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(2)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 2
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_bbxhzz_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_bbxhzz_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu


! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_bbxhzz_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(2)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 2 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2


! **********************************************************************
#ifdef PRECISION_dp
subroutine hsfamp2(P_scatt, M02, pind_1, pind_2, M2hsf)
#else
subroutine hsfamp2(P_scatt, M02, pind_1, pind_2, M2hsf)
  use ol_loop_storage_pphvv_ew_bbxhzz_1_/**/DREALKIND, only: &
    & nhflip, helflip, hflip, tsb, pi_flip_bak, pj_flip_bak, nhel
#endif
! M2tree = helicity-summed squared tree matrix element for bottom anti-bottom higgs Z Z -> 0
! M2hsf  = formula (66) of 1011.3918. Tree level
! spin-correlated hard scattering factor for bottom anti-bottom higgs Z Z -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  implicit none
  real(DREALKIND), intent(in) :: P_scatt(0:3,5)
  integer, intent(in) :: pind_1, pind_2
  real(REALKIND), intent(out) :: M02, M2hsf
  real(REALKIND)    :: M2add, M2ct_dummy
  integer :: k

  M2add = 0
  M2hsf = 0

  call amp2(P_scatt, M02, .false., M2ct=M2ct_dummy)
  if((pi_flip_bak .ne. pind_1) .or. (pj_flip_bak .ne. pind_2)) then
    call init_flipped_heltables(pind_1,pind_2)
    pi_flip_bak = pind_1
    pj_flip_bak = pind_2
  end if

  do k = 1, nhflip
    call colintHSF(M1helarray(:,helflip(1,k))%j, M1helarray(:,helflip(2,k))%j, M2add)
    M2hsf = M2hsf + M2add
  end do

  contains

subroutine assign_helicity_flip(ext_wf_hf,ext_wf_t,m)
  use ol_debug, only: ol_fatal
  use KIND_TYPES, only: intkind2
  implicit none
  integer(intkind2), intent(in) :: ext_wf_hf(:), ext_wf_t
  integer, intent(in) :: m
  if(.not. allocated(hflip)) allocate(hflip(size(ext_wf_hf),2))
  if(size(ext_wf_hf) == size(hflip,1)) then
    hflip(:,m) = ext_wf_hf
    tsb = tsb + ext_wf_t
  else
    call ol_fatal("Spin-correlated HSF for pphvv_ew_bbxhzz_1:" &
      & // "trying to flip particles with different number of helicity states")
  end if
end subroutine assign_helicity_flip

subroutine init_flipped_heltables(i,j)
  use KIND_TYPES, only: intkind2
  use ol_external_pphvv_ew_bbxhzz_1, only: &
    & external_perm_inv_pphvv_ew_bbxhzz_1
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helicity_flip_ij
  implicit none
  integer, intent(in) :: i, j
  integer :: r, k, l=0
  tsb = 0

  if(allocated(hflip)) deallocate(hflip)

  do k = 1, 5
    r = external_perm_inv_pphvv_ew_bbxhzz_1(k)
    if(r == i .or. r == j) then
      l = l+1
      select case(k)
        case(1)
          call assign_helicity_flip(ex1(:)%hf,ex1(1)%t,l)
        case(2)
          call assign_helicity_flip(ex2(:)%hf,ex2(1)%t,l)
        case(3)
          call assign_helicity_flip(ex3(:)%hf,ex3(1)%t,l)
        case(4)
          call assign_helicity_flip(ex4(:)%hf,ex4(1)%t,l)
        case(5)
          call assign_helicity_flip(ex5(:)%hf,ex5(1)%t,l)
      end select
    end if
  end do
  call helicity_flip_ij(36,nhel, M1helarray(1,:)%hf, hflip, tsb, &
      & nhflip, helflip)

end subroutine init_flipped_heltables

! **********************************************************************
subroutine colintHSF(M, Mflip, Mhfcolint)
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_bbxhzz_1_/**/REALKIND, only: K1
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mflip(1)
  real(REALKIND),    intent(out) :: Mhfcolint
  integer :: i, j
  MHfcolint = 0
  do i = 1, 1
    do j = 1, 1
      Mhfcolint = Mhfcolint + real(conjg(Mflip(i))*K1(i,j)*M(j))
    end do
  end do

end subroutine colintHSF

end subroutine hsfamp2

end module ol_loop_pphvv_ew_bbxhzz_1_/**/REALKIND
