
module ol_colourmatrix_pphvv_ew_bbxhwwx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(17,1), K2(17,1), KL(17,1), Cas(5) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 3]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 3]

  K2( 1,:) = [ 3]
  K2( 2,:) = [ 0]
  K2( 3,:) = [ 0]
  K2( 4,:) = [ 0]
  K2( 5,:) = [ 0]
  K2( 6,:) = [ 0]
  K2( 7,:) = [ 0]
  K2( 8,:) = [ 0]
  K2( 9,:) = [ 0]
  K2(10,:) = [ 0]
  K2(11,:) = [ 0]
  K2(12,:) = [ 0]
  K2(13,:) = [ 0]
  K2(14,:) = [ 0]
  K2(15,:) = [ 0]
  K2(16,:) = [ 0]
  K2(17,:) = [ 3]

  KL( 1,:) = [ 3]
  KL( 2,:) = [ 0]
  KL( 3,:) = [ 0]
  KL( 4,:) = [ 0]
  KL( 5,:) = [ 0]
  KL( 6,:) = [ 0]
  KL( 7,:) = [ 0]
  KL( 8,:) = [ 0]
  KL( 9,:) = [ 0]
  KL(10,:) = [ 0]
  KL(11,:) = [ 0]
  KL(12,:) = [ 0]
  KL(13,:) = [ 0]
  KL(14,:) = [ 0]
  KL(15,:) = [ 0]
  KL(16,:) = [ 0]
  KL(17,:) = [ 3]

#if 1 > 0
    co = 0
    do k = 1, 5
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_pphvv_ew_bbxhwwx_1_/**/REALKIND



module ol_forced_parameters_pphvv_ew_bbxhwwx_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (MM /= 0) write(*,101) 'MM = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'
  if (wMW /= 0) write(*,101) 'wMW = 0'
  if (wMW /= 0) write(*,101) 'wMW = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pphvv_ew_bbxhwwx_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_pphvv_ew_bbxhwwx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 36 ! number of helicity configurations
  integer(intkind2), save :: nhel = 36 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 36 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(36) ! physical helicity states
  integer(intkind2), save :: nhflip = 36    ! relevant helicities for helicity-flipped interference
  integer(intkind2), save :: helflip(2,36) ! Table for the helicity-flipped interference
  integer(intkind2), save, allocatable :: hflip(:,:)
  integer(intkind2) :: tsb
  integer, save :: pi_flip_bak = -1, pj_flip_bak = -1
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(161)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(1), ex4(3), ex5(3)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf2(2,10), wf3(3,16), wf4(4,50), wf6(6,30), wf9(9,23), wf12(12,54), wf18(18,18), wf36(36,244)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(896), c(821)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_pphvv_ew_bbxhwwx_1_/**/REALKIND






! **********************************************************************
module ol_loop_pphvv_ew_bbxhwwx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_pphvv_ew_bbxhwwx_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = (CI*countertermnorm*eQED**5*EWctHAA)/3._/**/REALKIND
    f(  2) = (CI*countertermnorm*eQED**5*EWctHWW)/3._/**/REALKIND
    f(  3) = CI*countertermnorm*eQED**5*EWctHZA
    f(  4) = (CI*countertermnorm*eQED**5*MB)/(3._/**/REALKIND*MW)
    f(  5) = (CI*eQED**3*MW)/(2._/**/REALKIND*cw)
    f(  6) = (CI*countertermnorm*eQED**5*MW)/(6._/**/REALKIND*cw)
    f(  7) = (CI*countertermnorm*eQED**5*MW)/(2._/**/REALKIND*cw)
    f(  8) = (CI*countertermnorm*eQED**5*EWctWPH*MW)/3._/**/REALKIND
    f(  9) = (CI*countertermnorm*eQED**5*MW**2)/cw
    f( 10) = (CI*countertermnorm*eQED**5)/(4._/**/REALKIND*sw**3)
    f( 11) = (CI*countertermnorm*eQED**5)/(2._/**/REALKIND*sw**3)
    f( 12) = (CI*countertermnorm*eQED**5*MB)/(4._/**/REALKIND*sw**3)
    f( 13) = (countertermnorm*eQED**5*MB)/(cw*sw**3*2._/**/REALKIND)
    f( 14) = (countertermnorm*cw*eQED**5*MB)/(sw**3*2._/**/REALKIND)
    f( 15) = (countertermnorm*cw*eQED**5*MB**2)/(MW**2*sw**3*4._/**/REALKIND)
    f( 16) = (countertermnorm*cw*eQED**5*MB*MH**2)/(MW**2*sw**3*4._/**/REALKIND)
    f( 17) = (CI*eQED**3)/(4._/**/REALKIND*MW*sw**3)
    f( 18) = (CI*countertermnorm*eQED**5)/(4._/**/REALKIND*MW*sw**3)
    f( 19) = (CI*countertermnorm*eQED**5*EWctVbt)/(4._/**/REALKIND*MW*sw**3)
    f( 20) = (CI*countertermnorm*eQED**5*EWctVtb)/(4._/**/REALKIND*MW*sw**3)
    f( 21) = (CI*eQED**3*MB)/(8._/**/REALKIND*MW*sw**3)
    f( 22) = (CI*eQED**3*MB)/(4._/**/REALKIND*MW*sw**3)
    f( 23) = (CI*countertermnorm*eQED**5*MB)/(8._/**/REALKIND*MW*sw**3)
    f( 24) = (CI*countertermnorm*eQED**5*MB)/(4._/**/REALKIND*MW*sw**3)
    f( 25) = (CI*countertermnorm*eQED**5*EWctVbt*MB)/(4._/**/REALKIND*MW*sw**3)
    f( 26) = (CI*countertermnorm*eQED**5*EWctVtb*MB)/(4._/**/REALKIND*MW*sw**3)
    f( 27) = (CI*eQED**3*MB**2)/(4._/**/REALKIND*MW*sw**3)
    f( 28) = (CI*countertermnorm*eQED**5*MB**2)/(4._/**/REALKIND*MW*sw**3)
    f( 29) = (3*CI*countertermnorm*eQED**5*EWctHHH*MB*MH**2)/(4._/**/REALKIND*MW*sw**3)
    f( 30) = (3*CI*eQED**3*lambdaHHH*MB*MH**2)/(4._/**/REALKIND*MW*sw**3)
    f( 31) = (3*CI*countertermnorm*eQED**5*lambdaHHH*MB*MH**2)/(4._/**/REALKIND*MW*sw**3)
    f( 32) = (CI*eQED**3*MT)/(4._/**/REALKIND*MW*sw**3)
    f( 33) = (CI*countertermnorm*eQED**5*MT)/(4._/**/REALKIND*MW*sw**3)
    f( 34) = (CI*countertermnorm*eQED**5*EWctVbt*MT)/(4._/**/REALKIND*MW*sw**3)
    f( 35) = (CI*countertermnorm*eQED**5*EWctVtb*MT)/(4._/**/REALKIND*MW*sw**3)
    f( 36) = (CI*eQED**3*MW)/(2._/**/REALKIND*sw**3)
    f( 37) = (CI*countertermnorm*eQED**5*MW)/(2._/**/REALKIND*sw**3)
    f( 38) = (CI*countertermnorm*eQED**5*EWctVbt*MW)/(2._/**/REALKIND*sw**3)
    f( 39) = (CI*countertermnorm*eQED**5*EWctVtb*MW)/(2._/**/REALKIND*sw**3)
    f( 40) = (CI*eQED**3*MB*MW)/(2._/**/REALKIND*sw**3)
    f( 41) = (CI*countertermnorm*eQED**5*MB*MW)/(2._/**/REALKIND*sw**3)
    f( 42) = (countertermnorm*eQED**5)/(sw**2*12._/**/REALKIND)
    f( 43) = (countertermnorm*eQED**5)/(sw**2*6._/**/REALKIND)
    f( 44) = (countertermnorm*eQED**5)/(sw**2*4._/**/REALKIND)
    f( 45) = (countertermnorm*eQED**5)/(sw**2*2._/**/REALKIND)
    f( 46) = (CI*countertermnorm*cw*eQED**5)/(2._/**/REALKIND*sw**2)
    f( 47) = (CI*countertermnorm*eQED**5*EWctHWW)/(2._/**/REALKIND*sw**2)
    f( 48) = (countertermnorm*eQED**5*MB)/(sw**2*4._/**/REALKIND)
    f( 49) = (countertermnorm*eQED**5*MB)/(sw**2*2._/**/REALKIND)
    f( 50) = (CI*countertermnorm*eQED**5*EWctHWW*MB)/(2._/**/REALKIND*sw**2)
    f( 51) = (countertermnorm*eQED**5*MB**2)/(MW**2*sw**2*4._/**/REALKIND)
    f( 52) = (CI*countertermnorm*eQED**5*EWctHWW*MB**2)/(4._/**/REALKIND*MW**2*sw**2)
    f( 53) = (countertermnorm*eQED**5*MB*MH**2)/(MW**2*sw**2*4._/**/REALKIND)
    f( 54) = (3*CI*countertermnorm*eQED**5*EWctHWW*lambdaHHH*MB*MH**2)/(4._/**/REALKIND*MW**2*sw**2)
    f( 55) = (CI*countertermnorm*eQED**5*EWctWPH)/(2._/**/REALKIND*MW*sw**2)
    f( 56) = (CI*cw*eQED**3*MB)/(2._/**/REALKIND*MW*sw**2)
    f( 57) = (CI*countertermnorm*eQED**5*MB)/(4._/**/REALKIND*MW*sw**2)
    f( 58) = (CI*countertermnorm*eQED**5*MB)/(2._/**/REALKIND*MW*sw**2)
    f( 59) = (countertermnorm*eQED**5*MB)/(MW*sw**2*4._/**/REALKIND)
    f( 60) = (countertermnorm*eQED**5*MB)/(MW*sw**2*2._/**/REALKIND)
    f( 61) = (CI*countertermnorm*eQED**5*MB)/(4._/**/REALKIND*cw*MW*sw**2)
    f( 62) = (CI*countertermnorm*cw*eQED**5*MB)/(6._/**/REALKIND*MW*sw**2)
    f( 63) = (CI*countertermnorm*cw*eQED**5*MB)/(2._/**/REALKIND*MW*sw**2)
    f( 64) = (CI*countertermnorm*eQED**5*EWctWPH*MB)/(4._/**/REALKIND*MW*sw**2)
    f( 65) = (countertermnorm*eQED**5*EWctWPX*MB)/(MW*sw**2*4._/**/REALKIND)
    f( 66) = (CI*countertermnorm*eQED**5*EWctZWW*MB)/(4._/**/REALKIND*cw*MW*sw**2)
    f( 67) = (countertermnorm*cw*eQED**5*EWctZXH*MB)/(MW*sw**2*2._/**/REALKIND)
    f( 68) = (CI*countertermnorm*eQED**5*MB**2)/(2._/**/REALKIND*MW*sw**2)
    f( 69) = (3*CI*countertermnorm*eQED**5*lambdaHHH*MB*MH**2)/(2._/**/REALKIND*MW*sw**2)
    f( 70) = (CI*countertermnorm*eQED**5*MT)/(2._/**/REALKIND*MW*sw**2)
    f( 71) = (CI*eQED**3*MW)/(cw*sw**2)
    f( 72) = (CI*cw*eQED**3*MW)/sw**2
    f( 73) = (CI*countertermnorm*eQED**5*MW)/(3._/**/REALKIND*cw*sw**2)
    f( 74) = (CI*countertermnorm*eQED**5*MW)/(cw*sw**2)
    f( 75) = (CI*countertermnorm*cw*eQED**5*MW)/(3._/**/REALKIND*sw**2)
    f( 76) = (CI*countertermnorm*cw*eQED**5*MW)/sw**2
    f( 77) = (CI*countertermnorm*eQED**5*MB*MW)/sw**2
    f( 78) = (CI*countertermnorm*eQED**5)/(2._/**/REALKIND*MW*sqrt2*sw**2)
    f( 79) = (CI*countertermnorm*eQED**5)/(6._/**/REALKIND*sw)
    f( 80) = (countertermnorm*eQED**5)/(cw*sw*2._/**/REALKIND)
    f( 81) = (CI*countertermnorm*cw*eQED**5*EWctHWW)/sw
    f( 82) = (CI*countertermnorm*cw*eQED**5*EWctHZA)/(3._/**/REALKIND*sw)
    f( 83) = (CI*countertermnorm*cw*eQED**5*EWctHZZ)/sw
    f( 84) = (CI*countertermnorm*eQED**5*EWctPWA)/(6._/**/REALKIND*sw)
    f( 85) = (CI*countertermnorm*eQED**5*EWctPWZ)/(2._/**/REALKIND*sw)
    f( 86) = (countertermnorm*eQED**5*MB)/(cw*sw*4._/**/REALKIND)
    f( 87) = (CI*eQED**3*MB)/(6._/**/REALKIND*MW*sw)
    f( 88) = (CI*countertermnorm*eQED**5*MB)/(6._/**/REALKIND*MW*sw)
    f( 89) = (CI*countertermnorm*eQED**5*MB)/(2._/**/REALKIND*MW*sw)
    f( 90) = (CI*countertermnorm*cw*eQED**5*MB)/(MW*sw)
    f( 91) = (CI*countertermnorm*eQED**5*EWctAWW*MB)/(6._/**/REALKIND*MW*sw)
    f( 92) = (countertermnorm*eQED**5*EWctAXH*MB)/(MW*sw*2._/**/REALKIND)
    f( 93) = (CI*countertermnorm*eQED**5*EWctWWHH*MB)/(2._/**/REALKIND*MW*sw)
    f( 94) = (CI*countertermnorm*eQED**5*EWctZWW*MB)/(2._/**/REALKIND*MW*sw)
    f( 95) = (CI*eQED**3*MW)/(6._/**/REALKIND*sw)
    f( 96) = (CI*eQED**3*MW)/(3._/**/REALKIND*sw)
    f( 97) = (CI*countertermnorm*eQED**5*MW)/(6._/**/REALKIND*sw)
    f( 98) = (CI*countertermnorm*eQED**5*MW)/(3._/**/REALKIND*sw)
    f( 99) = (CI*countertermnorm*eQED**5*MW)/(2._/**/REALKIND*sw)
    f(100) = (CI*countertermnorm*eQED**5*MW)/sw
    f(101) = (CI*countertermnorm*eQED**5*MW)/(cw**2*sw)
    f(102) = (CI*countertermnorm*eQED**5*EWctAWW*MW)/(3._/**/REALKIND*sw)
    f(103) = (CI*countertermnorm*eQED**5*EWctZWW*MW)/sw
    f(104) = (CI*countertermnorm*eQED**5*EWctZWW*MW)/(cw**2*sw)
    f(105) = (CI*countertermnorm*eQED**5*MW**2)/(3._/**/REALKIND*sw)
    f(106) = (CI*countertermnorm*eQED**5*EWctWPH*MW*sw)/cw
    f(107) = (eQED**5*integralnorm*MW*SwB)/(cw**3*4._/**/REALKIND)
    f(108) = (eQED**5*integralnorm*MW*SwB)/(cw*18._/**/REALKIND)
    f(109) = (eQED**5*integralnorm*MW*SwB)/(cw*6._/**/REALKIND)
    f(110) = (eQED**5*integralnorm*MW*SwB)/(cw*2._/**/REALKIND)
    f(111) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**3*4._/**/REALKIND)
    f(112) = (eQED**5*integralnorm*MB*MW*SwB)/(cw*6._/**/REALKIND)
    f(113) = (eQED**5*integralnorm*MB*MW*SwB)/(cw*2._/**/REALKIND)
    f(114) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw*6._/**/REALKIND)
    f(115) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw*2._/**/REALKIND)
    f(116) = (eQED**5*integralnorm*MW**3*SwB)/(cw**3*3._/**/REALKIND)
    f(117) = (eQED**5*integralnorm*MW**3*SwB)/cw**3
    f(118) = (eQED**5*integralnorm*MW**3*SwB)/(cw*3._/**/REALKIND)
    f(119) = (eQED**5*integralnorm*MW**3*SwB)/(cw*2._/**/REALKIND)
    f(120) = (eQED**5*integralnorm*MW**3*SwB)/cw
    f(121) = (eQED**5*integralnorm*SwB)/(MW**3*sw**5*8._/**/REALKIND)
    f(122) = (eQED**5*integralnorm*MB*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(123) = (eQED**5*integralnorm*MB*SwB)/(MW**3*sw**5*8._/**/REALKIND)
    f(124) = (eQED**5*integralnorm*MB**2*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(125) = (eQED**5*integralnorm*MB**2*SwB)/(MW**3*sw**5*8._/**/REALKIND)
    f(126) = (eQED**5*integralnorm*MB**3*SwB)/(MW**3*sw**5*32._/**/REALKIND)
    f(127) = (eQED**5*integralnorm*MB**3*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(128) = (eQED**5*integralnorm*MB**4*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(129) = (eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(130) = (eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**5*8._/**/REALKIND)
    f(131) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(132) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW**3*sw**5*32._/**/REALKIND)
    f(133) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(134) = (3*eQED**5*integralnorm*MB*MH**2*SwB)/(MW**3*sw**5*32._/**/REALKIND)
    f(135) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW**3*sw**5*8._/**/REALKIND)
    f(136) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(137) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(MW**3*sw**5*32._/**/REALKIND)
    f(138) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(139) = (3*eQED**5*integralnorm*MB**2*MH**2*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(140) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(MW**3*sw**5*32._/**/REALKIND)
    f(141) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(142) = (eQED**5*integralnorm*MB**3*MH**2*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(143) = (3*eQED**5*integralnorm*lambdaHHH*MB**3*MH**2*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(144) = (eQED**5*integralnorm*MH**4*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(145) = (eQED**5*integralnorm*MH**4*SwB)/(MW**3*sw**5*8._/**/REALKIND)
    f(146) = (3*eQED**5*integralnorm*lambdaHHH*MH**4*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(147) = (3*eQED**5*integralnorm*lambdaHHH*MH**4*SwB)/(MW**3*sw**5*8._/**/REALKIND)
    f(148) = (eQED**5*integralnorm*MB*MH**4*SwB)/(MW**3*sw**5*64._/**/REALKIND)
    f(149) = (eQED**5*integralnorm*MB*MH**4*SwB)/(MW**3*sw**5*32._/**/REALKIND)
    f(150) = (eQED**5*integralnorm*MB*MH**4*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(151) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**4*SwB)/(MW**3*sw**5*32._/**/REALKIND)
    f(152) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**4*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(153) = (9*eQED**5*integralnorm*lambdaHHH*MB*MH**4*SwB)/(MW**3*sw**5*32._/**/REALKIND)
    f(154) = (9*eQED**5*integralnorm*lambdaHHH**2*MB*MH**4*SwB)/(MW**3*sw**5*64._/**/REALKIND)
    f(155) = (9*eQED**5*integralnorm*lambdaHHH**2*MB*MH**4*SwB)/(MW**3*sw**5*32._/**/REALKIND)
    f(156) = (9*eQED**5*integralnorm*lambdaHHH**2*MB*MH**4*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(157) = (eQED**5*integralnorm*MB**2*MH**4*SwB)/(MW**3*sw**5*32._/**/REALKIND)
    f(158) = (eQED**5*integralnorm*MB**2*MH**4*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(159) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**4*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(160) = (9*eQED**5*integralnorm*lambdaHHH**2*MB**2*MH**4*SwB)/(MW**3*sw**5*32._/**/REALKIND)
    f(161) = (9*eQED**5*integralnorm*lambdaHHH**2*MB**2*MH**4*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(162) = (eQED**5*integralnorm*MB*MH**6*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(163) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**6*SwB)/(MW**3*sw**5*32._/**/REALKIND)
    f(164) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**6*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(165) = (27*eQED**5*integralnorm*lambdaHHH**3*MB*MH**6*SwB)/(MW**3*sw**5*32._/**/REALKIND)
    f(166) = (27*eQED**5*integralnorm*lambdaHHH**3*MB*MH**6*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(167) = (eQED**5*integralnorm*MT*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(168) = (eQED**5*integralnorm*MT*SwB)/(MW**3*sw**5*8._/**/REALKIND)
    f(169) = (eQED**5*integralnorm*MB*MT*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(170) = (eQED**5*integralnorm*MB*MT*SwB)/(MW**3*sw**5*8._/**/REALKIND)
    f(171) = (eQED**5*integralnorm*MB**2*MT*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(172) = (eQED**5*integralnorm*MH**2*MT*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(173) = (eQED**5*integralnorm*MH**2*MT*SwB)/(MW**3*sw**5*8._/**/REALKIND)
    f(174) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(175) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(MW**3*sw**5*8._/**/REALKIND)
    f(176) = (eQED**5*integralnorm*MB*MH**2*MT*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(177) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(178) = (eQED**5*integralnorm*MT**2*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(179) = (eQED**5*integralnorm*MT**2*SwB)/(MW**3*sw**5*8._/**/REALKIND)
    f(180) = (eQED**5*integralnorm*MB*MT**2*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(181) = (eQED**5*integralnorm*MH**2*MT**2*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(182) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT**2*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(183) = (eQED**5*integralnorm*MT**3*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(184) = (eQED**5*integralnorm*SwB)/(MW*sw**5*16._/**/REALKIND)
    f(185) = (eQED**5*integralnorm*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(186) = (eQED**5*integralnorm*SwB)/(MW*sw**5*4._/**/REALKIND)
    f(187) = (cw**2*eQED**5*integralnorm*SwB)/(MW*sw**5*4._/**/REALKIND)
    f(188) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**5*32._/**/REALKIND)
    f(189) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**5*16._/**/REALKIND)
    f(190) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(191) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**5*4._/**/REALKIND)
    f(192) = (eQED**5*integralnorm*MB*SwB)/(cw**2*MW*sw**5*32._/**/REALKIND)
    f(193) = (eQED**5*integralnorm*MB*SwB)/(cw**2*MW*sw**5*16._/**/REALKIND)
    f(194) = (eQED**5*integralnorm*MB*SwB)/(cw**2*MW*sw**5*8._/**/REALKIND)
    f(195) = (cw**2*eQED**5*integralnorm*MB*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(196) = (cw**2*eQED**5*integralnorm*MB*SwB)/(MW*sw**5*4._/**/REALKIND)
    f(197) = (eQED**5*integralnorm*MB**2*SwB)/(MW*sw**5*16._/**/REALKIND)
    f(198) = (eQED**5*integralnorm*MB**2*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(199) = (eQED**5*integralnorm*MB**2*SwB)/(MW*sw**5*4._/**/REALKIND)
    f(200) = (eQED**5*integralnorm*MB**2*SwB)/(cw**2*MW*sw**5*16._/**/REALKIND)
    f(201) = (eQED**5*integralnorm*MB**2*SwB)/(cw**2*MW*sw**5*8._/**/REALKIND)
    f(202) = (cw**2*eQED**5*integralnorm*MB**2*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(203) = (cw**2*eQED**5*integralnorm*MB**2*SwB)/(MW*sw**5*4._/**/REALKIND)
    f(204) = (eQED**5*integralnorm*MB**3*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(205) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw**5*16._/**/REALKIND)
    f(206) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(207) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw**5*4._/**/REALKIND)
    f(208) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(MW*sw**5*16._/**/REALKIND)
    f(209) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(210) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW*sw**5*16._/**/REALKIND)
    f(211) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(212) = (3*eQED**5*integralnorm*MB*MH**2*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(213) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**2*MW*sw**5*16._/**/REALKIND)
    f(214) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**2*MW*sw**5*8._/**/REALKIND)
    f(215) = (cw**2*eQED**5*integralnorm*MB*MH**2*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(216) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW*sw**5*16._/**/REALKIND)
    f(217) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(218) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW*sw**5*4._/**/REALKIND)
    f(219) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**2*MW*sw**5*16._/**/REALKIND)
    f(220) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**2*MW*sw**5*8._/**/REALKIND)
    f(221) = (3*cw**2*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(222) = (3*cw**2*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW*sw**5*4._/**/REALKIND)
    f(223) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(224) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(225) = (eQED**5*integralnorm*MB*MH**4*SwB)/(MW*sw**5*16._/**/REALKIND)
    f(226) = (eQED**5*integralnorm*MB*MH**4*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(227) = (9*eQED**5*integralnorm*lambdaHHH**2*MB*MH**4*SwB)/(MW*sw**5*16._/**/REALKIND)
    f(228) = (9*eQED**5*integralnorm*lambdaHHH**2*MB*MH**4*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(229) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**5*16._/**/REALKIND)
    f(230) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(231) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**5*4._/**/REALKIND)
    f(232) = (cw**2*eQED**5*integralnorm*MT*SwB)/(MW*sw**5*4._/**/REALKIND)
    f(233) = (eQED**5*integralnorm*MB*MT*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(234) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(235) = (eQED**5*integralnorm*MT**2*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(236) = (eQED**5*integralnorm*MW*SwB)/(sw**5*8._/**/REALKIND)
    f(237) = (eQED**5*integralnorm*MW*SwB)/(sw**5*4._/**/REALKIND)
    f(238) = (eQED**5*integralnorm*MW*SwB)/(sw**5*2._/**/REALKIND)
    f(239) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw**5*8._/**/REALKIND)
    f(240) = (cw**2*eQED**5*integralnorm*MW*SwB)/(sw**5*4._/**/REALKIND)
    f(241) = (cw**2*eQED**5*integralnorm*MW*SwB)/(sw**5*2._/**/REALKIND)
    f(242) = (eQED**5*integralnorm*MB*MW*SwB)/(sw**5*32._/**/REALKIND)
    f(243) = (eQED**5*integralnorm*MB*MW*SwB)/(sw**5*16._/**/REALKIND)
    f(244) = (eQED**5*integralnorm*MB*MW*SwB)/(sw**5*8._/**/REALKIND)
    f(245) = (eQED**5*integralnorm*MB*MW*SwB)/(sw**5*4._/**/REALKIND)
    f(246) = (eQED**5*integralnorm*MB*MW*SwB)/(sw**5*2._/**/REALKIND)
    f(247) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**4*sw**5*32._/**/REALKIND)
    f(248) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**4*sw**5*16._/**/REALKIND)
    f(249) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**4*sw**5*8._/**/REALKIND)
    f(250) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**4*sw**5*4._/**/REALKIND)
    f(251) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**2*sw**5*16._/**/REALKIND)
    f(252) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**2*sw**5*8._/**/REALKIND)
    f(253) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**2*sw**5*4._/**/REALKIND)
    f(254) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**2*sw**5*2._/**/REALKIND)
    f(255) = (cw**2*eQED**5*integralnorm*MB*MW*SwB)/(sw**5*8._/**/REALKIND)
    f(256) = (cw**2*eQED**5*integralnorm*MB*MW*SwB)/(sw**5*4._/**/REALKIND)
    f(257) = (cw**2*eQED**5*integralnorm*MB*MW*SwB)/(sw**5*2._/**/REALKIND)
    f(258) = (eQED**5*integralnorm*MB**2*MW*SwB)/(sw**5*16._/**/REALKIND)
    f(259) = (eQED**5*integralnorm*MB**2*MW*SwB)/(sw**5*4._/**/REALKIND)
    f(260) = (eQED**5*integralnorm*MB**2*MW*SwB)/(cw**4*sw**5*16._/**/REALKIND)
    f(261) = (eQED**5*integralnorm*MB**2*MW*SwB)/(cw**4*sw**5*8._/**/REALKIND)
    f(262) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(sw**5*4._/**/REALKIND)
    f(263) = (eQED**5*integralnorm*MB*MH**2*MW*SwB)/(sw**5*16._/**/REALKIND)
    f(264) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MW*SwB)/(sw**5*16._/**/REALKIND)
    f(265) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MW*SwB)/(sw**5*4._/**/REALKIND)
    f(266) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MW*SwB)/(cw**4*sw**5*16._/**/REALKIND)
    f(267) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MW*SwB)/(cw**4*sw**5*8._/**/REALKIND)
    f(268) = (eQED**5*integralnorm*MT*MW*SwB)/(sw**5*4._/**/REALKIND)
    f(269) = (eQED**5*integralnorm*MW**3*SwB)/(sw**5*2._/**/REALKIND)
    f(270) = (eQED**5*integralnorm*MB*MW**3*SwB)/(sw**5*16._/**/REALKIND)
    f(271) = (eQED**5*integralnorm*MB*MW**3*SwB)/(sw**5*8._/**/REALKIND)
    f(272) = (eQED**5*integralnorm*MB*MW**3*SwB)/(sw**5*2._/**/REALKIND)
    f(273) = (eQED**5*integralnorm*MB*MW**3*SwB)/(cw**6*sw**5*16._/**/REALKIND)
    f(274) = (eQED**5*integralnorm*MB*MW**3*SwB)/(cw**6*sw**5*2._/**/REALKIND)
    f(275) = (eQED**5*integralnorm*MB*MW**3*SwB)/(cw**4*sw**5*8._/**/REALKIND)
    f(276) = (eQED**5*integralnorm*MB*MW**3*SwB)/(cw**4*sw**5*4._/**/REALKIND)
    f(277) = (cw*eQED**5*integralnorm*MB*SwB)/(MW**3*sw**4*4._/**/REALKIND)
    f(278) = (cw*eQED**5*integralnorm*MB**3*SwB)/(MW**3*sw**4*8._/**/REALKIND)
    f(279) = (cw*eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**4*4._/**/REALKIND)
    f(280) = (cw*eQED**5*integralnorm*MB**2*MH**2*SwB)/(MW**3*sw**4*8._/**/REALKIND)
    f(281) = (3*cw*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(MW**3*sw**4*8._/**/REALKIND)
    f(282) = (cw*eQED**5*integralnorm*MT*SwB)/(MW**3*sw**4*4._/**/REALKIND)
    f(283) = (eQED**5*integralnorm*SwB)/(cw*MW*sw**4*8._/**/REALKIND)
    f(284) = (eQED**5*integralnorm*SwB)/(cw*MW*sw**4*2._/**/REALKIND)
    f(285) = (cw*eQED**5*integralnorm*SwB)/(MW*sw**4*4._/**/REALKIND)
    f(286) = (cw*eQED**5*integralnorm*SwB)/(MW*sw**4*2._/**/REALKIND)
    f(287) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**4*16._/**/REALKIND)
    f(288) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**4*8._/**/REALKIND)
    f(289) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**4*4._/**/REALKIND)
    f(290) = (cw*eQED**5*integralnorm*MB*SwB)/(MW*sw**4*8._/**/REALKIND)
    f(291) = (cw*eQED**5*integralnorm*MB*SwB)/(MW*sw**4*4._/**/REALKIND)
    f(292) = (cw*eQED**5*integralnorm*MB*SwB)/(MW*sw**4*2._/**/REALKIND)
    f(293) = (cw**3*eQED**5*integralnorm*MB*SwB)/(MW*sw**4*2._/**/REALKIND)
    f(294) = (eQED**5*integralnorm*MB**2*SwB)/(cw*MW*sw**4*8._/**/REALKIND)
    f(295) = (eQED**5*integralnorm*MB**2*SwB)/(cw*MW*sw**4*4._/**/REALKIND)
    f(296) = (cw*eQED**5*integralnorm*MB**2*SwB)/(MW*sw**4*4._/**/REALKIND)
    f(297) = (eQED**5*integralnorm*MH**2*SwB)/(cw*MW*sw**4*16._/**/REALKIND)
    f(298) = (eQED**5*integralnorm*MH**2*SwB)/(cw*MW*sw**4*8._/**/REALKIND)
    f(299) = (cw*eQED**5*integralnorm*MH**2*SwB)/(MW*sw**4*8._/**/REALKIND)
    f(300) = (cw*eQED**5*integralnorm*MH**2*SwB)/(MW*sw**4*4._/**/REALKIND)
    f(301) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(cw*MW*sw**4*16._/**/REALKIND)
    f(302) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(cw*MW*sw**4*8._/**/REALKIND)
    f(303) = (3*cw*eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(MW*sw**4*8._/**/REALKIND)
    f(304) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*MW*sw**4*8._/**/REALKIND)
    f(305) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw*MW*sw**4*8._/**/REALKIND)
    f(306) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw*MW*sw**4*4._/**/REALKIND)
    f(307) = (3*cw*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW*sw**4*4._/**/REALKIND)
    f(308) = (eQED**5*integralnorm*MT*SwB)/(cw*MW*sw**4*8._/**/REALKIND)
    f(309) = (cw*eQED**5*integralnorm*MT*SwB)/(MW*sw**4*4._/**/REALKIND)
    f(310) = (eQED**5*integralnorm*MW*SwB)/(cw**3*sw**4*8._/**/REALKIND)
    f(311) = (eQED**5*integralnorm*MW*SwB)/(cw**3*sw**4*4._/**/REALKIND)
    f(312) = (eQED**5*integralnorm*MW*SwB)/(cw**3*sw**4*2._/**/REALKIND)
    f(313) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**4*8._/**/REALKIND)
    f(314) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**4*4._/**/REALKIND)
    f(315) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**4*2._/**/REALKIND)
    f(316) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**4)
    f(317) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**4*8._/**/REALKIND)
    f(318) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**4*4._/**/REALKIND)
    f(319) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**4*2._/**/REALKIND)
    f(320) = (cw*eQED**5*integralnorm*MW*SwB)/sw**4
    f(321) = (cw**3*eQED**5*integralnorm*MW*SwB)/(sw**4*2._/**/REALKIND)
    f(322) = (cw**3*eQED**5*integralnorm*MW*SwB)/sw**4
    f(323) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**3*sw**4*4._/**/REALKIND)
    f(324) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**3*sw**4*2._/**/REALKIND)
    f(325) = (eQED**5*integralnorm*MB*MW*SwB)/(cw*sw**4*4._/**/REALKIND)
    f(326) = (eQED**5*integralnorm*MB*MW*SwB)/(cw*sw**4*2._/**/REALKIND)
    f(327) = (cw*eQED**5*integralnorm*MB*MW*SwB)/(sw**4*4._/**/REALKIND)
    f(328) = (cw*eQED**5*integralnorm*MB*MW*SwB)/(sw**4*2._/**/REALKIND)
    f(329) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(cw**3*sw**4*2._/**/REALKIND)
    f(330) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(cw*sw**4*2._/**/REALKIND)
    f(331) = (3*cw*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(sw**4*4._/**/REALKIND)
    f(332) = (3*cw*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(sw**4*2._/**/REALKIND)
    f(333) = (eQED**5*integralnorm*MW**3*SwB)/(cw**5*sw**4)
    f(334) = (eQED**5*integralnorm*MW**3*SwB)/(cw**3*sw**4)
    f(335) = (eQED**5*integralnorm*MW**3*SwB)/(cw*sw**4*8._/**/REALKIND)
    f(336) = (eQED**5*integralnorm*MW**3*SwB)/(cw*sw**4*2._/**/REALKIND)
    f(337) = (eQED**5*integralnorm*MW**3*SwB)/(cw*sw**4)
    f(338) = (cw*eQED**5*integralnorm*MW**3*SwB)/(sw**4*4._/**/REALKIND)
    f(339) = (cw*eQED**5*integralnorm*MW**3*SwB)/(sw**4*2._/**/REALKIND)
    f(340) = (cw*eQED**5*integralnorm*MW**3*SwB)/sw**4
    f(341) = (eQED**5*integralnorm*MB*SwB)/(MW**3*sw**3*12._/**/REALKIND)
    f(342) = (eQED**5*integralnorm*MB*SwB)/(MW**3*sw**3*6._/**/REALKIND)
    f(343) = (eQED**5*integralnorm*MB*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f(344) = (eQED**5*integralnorm*MB**3*SwB)/(MW**3*sw**3*24._/**/REALKIND)
    f(345) = (eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**3*12._/**/REALKIND)
    f(346) = (eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**3*6._/**/REALKIND)
    f(347) = (eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f(348) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(349) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(MW**3*sw**3*24._/**/REALKIND)
    f(350) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(351) = (eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(352) = (eQED**5*integralnorm*MB*MH**4*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(353) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**4*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(354) = (eQED**5*integralnorm*MT*SwB)/(MW**3*sw**3*12._/**/REALKIND)
    f(355) = (eQED**5*integralnorm*MT*SwB)/(MW**3*sw**3*6._/**/REALKIND)
    f(356) = (eQED**5*integralnorm*MT*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f(357) = (eQED**5*integralnorm*SwB)/(MW*sw**3*36._/**/REALKIND)
    f(358) = (eQED**5*integralnorm*SwB)/(MW*sw**3*18._/**/REALKIND)
    f(359) = (eQED**5*integralnorm*SwB)/(MW*sw**3*12._/**/REALKIND)
    f(360) = (eQED**5*integralnorm*SwB)/(MW*sw**3*9._/**/REALKIND)
    f(361) = (eQED**5*integralnorm*SwB)/(MW*sw**3*6._/**/REALKIND)
    f(362) = (eQED**5*integralnorm*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(363) = (eQED**5*integralnorm*SwB)/(MW*sw**3*3._/**/REALKIND)
    f(364) = (eQED**5*integralnorm*SwB)/(MW*sw**3*2._/**/REALKIND)
    f(365) = (eQED**5*integralnorm*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(366) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*72._/**/REALKIND)
    f(367) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*36._/**/REALKIND)
    f(368) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*24._/**/REALKIND)
    f(369) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*18._/**/REALKIND)
    f(370) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*12._/**/REALKIND)
    f(371) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*9._/**/REALKIND)
    f(372) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*8._/**/REALKIND)
    f(373) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*6._/**/REALKIND)
    f(374) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(375) = (eQED**5*integralnorm*MB*SwB)/(cw**2*MW*sw**3*16._/**/REALKIND)
    f(376) = (eQED**5*integralnorm*MB*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(377) = (cw**2*eQED**5*integralnorm*MB*SwB)/(MW*sw**3*6._/**/REALKIND)
    f(378) = (cw**2*eQED**5*integralnorm*MB*SwB)/(MW*sw**3*2._/**/REALKIND)
    f(379) = (eQED**5*integralnorm*MB**2*SwB)/(MW*sw**3*36._/**/REALKIND)
    f(380) = (eQED**5*integralnorm*MB**2*SwB)/(MW*sw**3*24._/**/REALKIND)
    f(381) = (eQED**5*integralnorm*MB**2*SwB)/(MW*sw**3*12._/**/REALKIND)
    f(382) = (eQED**5*integralnorm*MB**2*SwB)/(MW*sw**3*8._/**/REALKIND)
    f(383) = (eQED**5*integralnorm*MB**2*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(384) = (eQED**5*integralnorm*MB**2*SwB)/(cw**2*MW*sw**3*16._/**/REALKIND)
    f(385) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw**3*24._/**/REALKIND)
    f(386) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw**3*12._/**/REALKIND)
    f(387) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw**3*6._/**/REALKIND)
    f(388) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(389) = (eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(MW*sw**3*8._/**/REALKIND)
    f(390) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW*sw**3*24._/**/REALKIND)
    f(391) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW*sw**3*12._/**/REALKIND)
    f(392) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW*sw**3*8._/**/REALKIND)
    f(393) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(394) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**2*MW*sw**3*16._/**/REALKIND)
    f(395) = (eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW*sw**3*12._/**/REALKIND)
    f(396) = (eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW*sw**3*8._/**/REALKIND)
    f(397) = (eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(398) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW*sw**3*8._/**/REALKIND)
    f(399) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(400) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**2*MW*sw**3*16._/**/REALKIND)
    f(401) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(MW*sw**3*8._/**/REALKIND)
    f(402) = (eQED**5*integralnorm*MH**4*SwB)/(MW*sw**3*24._/**/REALKIND)
    f(403) = (eQED**5*integralnorm*MH**4*SwB)/(MW*sw**3*12._/**/REALKIND)
    f(404) = (eQED**5*integralnorm*lambdaHHH*MH**4*SwB)/(MW*sw**3*8._/**/REALKIND)
    f(405) = (eQED**5*integralnorm*lambdaHHH*MH**4*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(406) = (eQED**5*integralnorm*MB*MH**4*SwB)/(MW*sw**3*8._/**/REALKIND)
    f(407) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**4*SwB)/(MW*sw**3*8._/**/REALKIND)
    f(408) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*36._/**/REALKIND)
    f(409) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*18._/**/REALKIND)
    f(410) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*12._/**/REALKIND)
    f(411) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*9._/**/REALKIND)
    f(412) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*6._/**/REALKIND)
    f(413) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(414) = (eQED**5*integralnorm*MT*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(415) = (eQED**5*integralnorm*MW*SwB)/(sw**3*24._/**/REALKIND)
    f(416) = (eQED**5*integralnorm*MW*SwB)/(sw**3*18._/**/REALKIND)
    f(417) = (eQED**5*integralnorm*MW*SwB)/(sw**3*12._/**/REALKIND)
    f(418) = (eQED**5*integralnorm*MW*SwB)/(sw**3*9._/**/REALKIND)
    f(419) = (eQED**5*integralnorm*MW*SwB)/(sw**3*6._/**/REALKIND)
    f(420) = (2*eQED**5*integralnorm*MW*SwB)/(sw**3*9._/**/REALKIND)
    f(421) = (eQED**5*integralnorm*MW*SwB)/(sw**3*4._/**/REALKIND)
    f(422) = (eQED**5*integralnorm*MW*SwB)/(sw**3*3._/**/REALKIND)
    f(423) = (eQED**5*integralnorm*MW*SwB)/(sw**3*2._/**/REALKIND)
    f(424) = (eQED**5*integralnorm*MW*SwB)/sw**3
    f(425) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw**3*8._/**/REALKIND)
    f(426) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw**3*4._/**/REALKIND)
    f(427) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw**3*2._/**/REALKIND)
    f(428) = (cw**2*eQED**5*integralnorm*MW*SwB)/(sw**3*6._/**/REALKIND)
    f(429) = (cw**2*eQED**5*integralnorm*MW*SwB)/(sw**3*3._/**/REALKIND)
    f(430) = (cw**2*eQED**5*integralnorm*MW*SwB)/sw**3
    f(431) = (eQED**5*integralnorm*MB*MW*SwB)/(sw**3*18._/**/REALKIND)
    f(432) = (eQED**5*integralnorm*MB*MW*SwB)/(sw**3*12._/**/REALKIND)
    f(433) = (eQED**5*integralnorm*MB*MW*SwB)/(sw**3*8._/**/REALKIND)
    f(434) = (eQED**5*integralnorm*MB*MW*SwB)/(sw**3*6._/**/REALKIND)
    f(435) = (eQED**5*integralnorm*MB*MW*SwB)/(sw**3*4._/**/REALKIND)
    f(436) = (eQED**5*integralnorm*MB*MW*SwB)/(sw**3*2._/**/REALKIND)
    f(437) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**4*sw**3*8._/**/REALKIND)
    f(438) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**2*sw**3*8._/**/REALKIND)
    f(439) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**2*sw**3*4._/**/REALKIND)
    f(440) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**2*sw**3*2._/**/REALKIND)
    f(441) = (eQED**5*integralnorm*MH**2*MW*SwB)/(sw**3*12._/**/REALKIND)
    f(442) = (eQED**5*integralnorm*MH**2*MW*SwB)/(sw**3*6._/**/REALKIND)
    f(443) = (eQED**5*integralnorm*MH**2*MW*SwB)/(sw**3*4._/**/REALKIND)
    f(444) = (eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(sw**3*4._/**/REALKIND)
    f(445) = (eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(sw**3*2._/**/REALKIND)
    f(446) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(cw**2*sw**3*2._/**/REALKIND)
    f(447) = (eQED**5*integralnorm*MB*MH**2*MW*SwB)/(sw**3*4._/**/REALKIND)
    f(448) = (eQED**5*integralnorm*MW**3*SwB)/(sw**3*12._/**/REALKIND)
    f(449) = (eQED**5*integralnorm*MW**3*SwB)/(sw**3*6._/**/REALKIND)
    f(450) = (eQED**5*integralnorm*MW**3*SwB)/(sw**3*3._/**/REALKIND)
    f(451) = (eQED**5*integralnorm*MW**3*SwB)/(sw**3*2._/**/REALKIND)
    f(452) = (eQED**5*integralnorm*MW**3*SwB)/(cw**4*sw**3)
    f(453) = (eQED**5*integralnorm*MW**3*SwB)/(cw**2*sw**3*12._/**/REALKIND)
    f(454) = (eQED**5*integralnorm*MW**3*SwB)/(cw**2*sw**3)
    f(455) = (eQED**5*integralnorm*MB*MW**3*SwB)/(sw**3*2._/**/REALKIND)
    f(456) = (eQED**5*integralnorm*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(457) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**2*12._/**/REALKIND)
    f(458) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(459) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(460) = (cw*eQED**5*integralnorm*MB*SwB)/(MW*sw**2*18._/**/REALKIND)
    f(461) = (cw*eQED**5*integralnorm*MB*SwB)/(MW*sw**2*6._/**/REALKIND)
    f(462) = (cw*eQED**5*integralnorm*MB*SwB)/(MW*sw**2*2._/**/REALKIND)
    f(463) = (eQED**5*integralnorm*MB**2*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(464) = (eQED**5*integralnorm*MH**2*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(465) = (eQED**5*integralnorm*MH**2*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(466) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(467) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(468) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(469) = (eQED**5*integralnorm*MH**4*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(470) = (3*eQED**5*integralnorm*lambdaHHH*MH**4*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(471) = (eQED**5*integralnorm*MT*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(472) = (eQED**5*integralnorm*MW*SwB)/(cw**3*sw**2*8._/**/REALKIND)
    f(473) = (eQED**5*integralnorm*MW*SwB)/(cw**3*sw**2*4._/**/REALKIND)
    f(474) = (eQED**5*integralnorm*MW*SwB)/(cw**3*sw**2*2._/**/REALKIND)
    f(475) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*12._/**/REALKIND)
    f(476) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*9._/**/REALKIND)
    f(477) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*8._/**/REALKIND)
    f(478) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(479) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*3._/**/REALKIND)
    f(480) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*2._/**/REALKIND)
    f(481) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2)
    f(482) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**2*9._/**/REALKIND)
    f(483) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**2*6._/**/REALKIND)
    f(484) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**2*3._/**/REALKIND)
    f(485) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**2*2._/**/REALKIND)
    f(486) = (cw*eQED**5*integralnorm*MW*SwB)/sw**2
    f(487) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**3*sw**2*4._/**/REALKIND)
    f(488) = (eQED**5*integralnorm*MB*MW*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(489) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw**3*sw**2*4._/**/REALKIND)
    f(490) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(491) = (cw*eQED**5*integralnorm*MH**2*MW*SwB)/(sw**2*2._/**/REALKIND)
    f(492) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(cw**3*sw**2*4._/**/REALKIND)
    f(493) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(494) = (eQED**5*integralnorm*MW**3*SwB)/(cw**5*sw**2*2._/**/REALKIND)
    f(495) = (eQED**5*integralnorm*MW**3*SwB)/(cw**3*sw**2*4._/**/REALKIND)
    f(496) = (eQED**5*integralnorm*MW**3*SwB)/(cw**3*sw**2*2._/**/REALKIND)
    f(497) = (eQED**5*integralnorm*MW**3*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(498) = (eQED**5*integralnorm*MW**3*SwB)/(cw*sw**2*2._/**/REALKIND)
    f(499) = (cw*eQED**5*integralnorm*MW**3*SwB)/sw**2
    f(500) = (eQED**5*integralnorm*SwB)/(cw**2*MW*sw*4._/**/REALKIND)
    f(501) = (eQED**5*integralnorm*MB*SwB)/(MW*sw*54._/**/REALKIND)
    f(502) = (eQED**5*integralnorm*MB*SwB)/(MW*sw*18._/**/REALKIND)
    f(503) = (eQED**5*integralnorm*MB*SwB)/(MW*sw*6._/**/REALKIND)
    f(504) = (eQED**5*integralnorm*MB*SwB)/(cw**2*MW*sw*8._/**/REALKIND)
    f(505) = (eQED**5*integralnorm*MB*SwB)/(cw**2*MW*sw*4._/**/REALKIND)
    f(506) = (eQED**5*integralnorm*MB**2*SwB)/(cw**2*MW*sw*8._/**/REALKIND)
    f(507) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw*6._/**/REALKIND)
    f(508) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw*3._/**/REALKIND)
    f(509) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*MW*sw*4._/**/REALKIND)
    f(510) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**2*MW*sw*8._/**/REALKIND)
    f(511) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**2*MW*sw*8._/**/REALKIND)
    f(512) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(cw**2*MW*sw*8._/**/REALKIND)
    f(513) = (eQED**5*integralnorm*MB*MH**4*SwB)/(cw**2*MW*sw*8._/**/REALKIND)
    f(514) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**4*SwB)/(cw**2*MW*sw*8._/**/REALKIND)
    f(515) = (eQED**5*integralnorm*MT*SwB)/(cw**2*MW*sw*4._/**/REALKIND)
    f(516) = (eQED**5*integralnorm*MW*SwB)/(sw*54._/**/REALKIND)
    f(517) = (eQED**5*integralnorm*MW*SwB)/(sw*27._/**/REALKIND)
    f(518) = (eQED**5*integralnorm*MW*SwB)/(sw*18._/**/REALKIND)
    f(519) = (eQED**5*integralnorm*MW*SwB)/(sw*9._/**/REALKIND)
    f(520) = (eQED**5*integralnorm*MW*SwB)/(sw*6._/**/REALKIND)
    f(521) = (eQED**5*integralnorm*MW*SwB)/(sw*3._/**/REALKIND)
    f(522) = (eQED**5*integralnorm*MW*SwB)/(sw*2._/**/REALKIND)
    f(523) = (eQED**5*integralnorm*MW*SwB)/(cw**4*sw*2._/**/REALKIND)
    f(524) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw*12._/**/REALKIND)
    f(525) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(526) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw*3._/**/REALKIND)
    f(527) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw*2._/**/REALKIND)
    f(528) = (eQED**5*integralnorm*MB*MW*SwB)/(sw*18._/**/REALKIND)
    f(529) = (eQED**5*integralnorm*MB*MW*SwB)/(sw*6._/**/REALKIND)
    f(530) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**4*sw*8._/**/REALKIND)
    f(531) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**4*sw*4._/**/REALKIND)
    f(532) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**2*sw*12._/**/REALKIND)
    f(533) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**2*sw*8._/**/REALKIND)
    f(534) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(535) = (eQED**5*integralnorm*MB**2*MW*SwB)/(cw**4*sw*4._/**/REALKIND)
    f(536) = (eQED**5*integralnorm*MH**2*MW*SwB)/(sw*18._/**/REALKIND)
    f(537) = (eQED**5*integralnorm*MH**2*MW*SwB)/(sw*6._/**/REALKIND)
    f(538) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(539) = (eQED**5*integralnorm*MB*MH**2*MW*SwB)/(cw**4*sw*4._/**/REALKIND)
    f(540) = (eQED**5*integralnorm*MB*MH**2*MW*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(541) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MW*SwB)/(cw**4*sw*4._/**/REALKIND)
    f(542) = (eQED**5*integralnorm*MW**3*SwB)/(sw*9._/**/REALKIND)
    f(543) = (eQED**5*integralnorm*MW**3*SwB)/(sw*6._/**/REALKIND)
    f(544) = (eQED**5*integralnorm*MW**3*SwB)/(sw*3._/**/REALKIND)
    f(545) = (eQED**5*integralnorm*MW**3*SwB)/(cw**4*sw*2._/**/REALKIND)
    f(546) = (eQED**5*integralnorm*MW**3*SwB)/(cw**2*sw*3._/**/REALKIND)
    f(547) = (eQED**5*integralnorm*MW**3*SwB)/(cw**2*sw*2._/**/REALKIND)
    f(548) = (eQED**5*integralnorm*MB*MW**3*SwB)/(cw**6*sw*2._/**/REALKIND)
    f(549) = (eQED**5*integralnorm*MB*MW**3*SwB)/(cw**4*sw*2._/**/REALKIND)
    f(550) = (eQED**5*integralnorm*MB*MW**3*SwB)/(cw**2*sw*2._/**/REALKIND)
    f(551) = (eQED**5*integralnorm*MW*sw*SwB)/(cw**2*6._/**/REALKIND)
    f(552) = (eQED**5*integralnorm*MW*sw*SwB)/(cw**2*2._/**/REALKIND)
    f(553) = (eQED**5*integralnorm*MB*MW*sw*SwB)/(cw**2*6._/**/REALKIND)
    f(554) = (eQED**5*integralnorm*MB*MW*sw*SwB)/(cw**2*2._/**/REALKIND)
    f(555) = (eQED**5*integralnorm*MH**2*MW*sw*SwB)/(cw**2*6._/**/REALKIND)
    f(556) = (eQED**5*integralnorm*MH**2*MW*sw*SwB)/(cw**2*2._/**/REALKIND)
    f(557) = (eQED**5*integralnorm*MW**3*sw*SwB)/(cw**4*3._/**/REALKIND)
    f(558) = (eQED**5*integralnorm*MW**3*sw*SwB)/cw**4
    f(559) = (eQED**5*integralnorm*MW**3*sw*SwB)/(cw**2*6._/**/REALKIND)
    f(560) = (eQED**5*integralnorm*MW**3*sw*SwB)/(cw**2*3._/**/REALKIND)
    f(561) = (eQED**5*integralnorm*MW**3*sw*SwB)/cw**2
    f(562) = (eQED**5*integralnorm*MW**3*sw**2*SwB)/(cw**3*2._/**/REALKIND)
    f(563) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(MW**3*sw**5*8._/**/REALKIND))
    f(564) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(MW**3*sw**5*8._/**/REALKIND))
    f(565) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(MW**3*sw**5*16._/**/REALKIND))
    f(566) = -((eQED**5*integralnorm*MB**2*MH**2*(cw - sw)*(cw + sw)*SwB)/(MW**3*sw**5*16._/**/REALKIND))
    f(567) = -((eQED**5*integralnorm*MB*MH**4*(cw - sw)*(cw + sw)*SwB)/(MW**3*sw**5*16._/**/REALKIND))
    f(568) = (-3*eQED**5*integralnorm*lambdaHHH*MB*MH**4*(cw - sw)*(cw + sw)*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(569) = -((eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(MW**3*sw**5*8._/**/REALKIND))
    f(570) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(MW*sw**5*8._/**/REALKIND))
    f(571) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(MW*sw**5*4._/**/REALKIND))
    f(572) = (eQED**5*integralnorm*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**5*16._/**/REALKIND)
    f(573) = (eQED**5*integralnorm*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**5*4._/**/REALKIND)
    f(574) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(MW*sw**5*16._/**/REALKIND))
    f(575) = (eQED**5*integralnorm*MB*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**5*32._/**/REALKIND)
    f(576) = (eQED**5*integralnorm*MB*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**5*16._/**/REALKIND)
    f(577) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(MW*sw**5*8._/**/REALKIND))
    f(578) = (eQED**5*integralnorm*MB*MH**2*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**5*16._/**/REALKIND)
    f(579) = (eQED**5*integralnorm*MB*MH**2*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**5*8._/**/REALKIND)
    f(580) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(sw**5*8._/**/REALKIND))
    f(581) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(sw**5*4._/**/REALKIND))
    f(582) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**5*16._/**/REALKIND)
    f(583) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**5*8._/**/REALKIND)
    f(584) = -((eQED**5*integralnorm*MB*MW*(cw - sw)*(cw + sw)*SwB)/(sw**5*16._/**/REALKIND))
    f(585) = -((eQED**5*integralnorm*MB*MW*(cw - sw)*(cw + sw)*SwB)/(sw**5*8._/**/REALKIND))
    f(586) = (eQED**5*integralnorm*MB*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**5*32._/**/REALKIND)
    f(587) = (eQED**5*integralnorm*MB*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**5*16._/**/REALKIND)
    f(588) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**4*8._/**/REALKIND))
    f(589) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**4*16._/**/REALKIND))
    f(590) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**4*8._/**/REALKIND))
    f(591) = (eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(592) = -((eQED**5*integralnorm*MB*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw*MW*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(593) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**4*16._/**/REALKIND))
    f(594) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**4*8._/**/REALKIND))
    f(595) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(596) = -((eQED**5*integralnorm*MH**2*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw*MW*sw**4*4._/**/REALKIND*8._/**/REALKIND))
    f(597) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*2._/**/REALKIND)
    f(598) = -((eQED**5*integralnorm*MH**2*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw*MW*sw**4*2._/**/REALKIND*4._/**/REALKIND))
    f(599) = (-3*eQED**5*integralnorm*lambdaHHH*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**4*16._/**/REALKIND)
    f(600) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**4*8._/**/REALKIND))
    f(601) = -((eQED**5*integralnorm*MH**4*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**4*8._/**/REALKIND))
    f(602) = (-3*eQED**5*integralnorm*lambdaHHH*MH**4*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**4*8._/**/REALKIND)
    f(603) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**4*8._/**/REALKIND))
    f(604) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**4*4._/**/REALKIND))
    f(605) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**2*8._/**/REALKIND)
    f(606) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**4*8._/**/REALKIND))
    f(607) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**4*4._/**/REALKIND))
    f(608) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**2*2._/**/REALKIND)
    f(609) = -((eQED**5*integralnorm*MW*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**3*sw**4*2._/**/REALKIND*4._/**/REALKIND))
    f(610) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*12._/**/REALKIND)
    f(611) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(612) = -((cw*eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(sw**4*4._/**/REALKIND))
    f(613) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*2._/**/REALKIND)
    f(614) = -((eQED**5*integralnorm*MW*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw*sw**4*2._/**/REALKIND*4._/**/REALKIND))
    f(615) = (eQED**5*integralnorm*MB*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(616) = -((eQED**5*integralnorm*MH**2*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**4*4._/**/REALKIND))
    f(617) = -((eQED**5*integralnorm*MH**2*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**4*4._/**/REALKIND))
    f(618) = (eQED**5*integralnorm*MH**2*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(619) = (eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**2*8._/**/REALKIND)
    f(620) = (eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**2*4._/**/REALKIND)
    f(621) = (eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**2*2._/**/REALKIND)
    f(622) = (eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(623) = (eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*2._/**/REALKIND)
    f(624) = (eQED**5*integralnorm*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**2*MW*sw**5*16._/**/REALKIND*8._/**/REALKIND)
    f(625) = (eQED**5*integralnorm*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(626) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(MW*sw**3*12._/**/REALKIND))
    f(627) = (eQED**5*integralnorm*MB*SwB*(cw**4*16._/**/REALKIND + sw**4*16._/**/REALKIND  &
      - cw**2*sw**2*32._/**/REALKIND))/(cw**2*MW*sw**5*16._/**/REALKIND*32._/**/REALKIND)
    f(628) = (eQED**5*integralnorm*MB*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**2*MW*sw**5*16._/**/REALKIND*8._/**/REALKIND)
    f(629) = (eQED**5*integralnorm*MB*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**3*16._/**/REALKIND)
    f(630) = (eQED**5*integralnorm*MB*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(631) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(MW*sw**3*12._/**/REALKIND))
    f(632) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(MW*sw**3*6._/**/REALKIND))
    f(633) = (eQED**5*integralnorm*MH**2*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(634) = (eQED**5*integralnorm*MB*MH**2*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**3*16._/**/REALKIND)
    f(635) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(sw**3*12._/**/REALKIND))
    f(636) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(sw**3*6._/**/REALKIND))
    f(637) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**4*sw**3*4._/**/REALKIND))
    f(638) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**3*24._/**/REALKIND)
    f(639) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**3*8._/**/REALKIND)
    f(640) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**3*6._/**/REALKIND)
    f(641) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**3*4._/**/REALKIND)
    f(642) = -((eQED**5*integralnorm*MB*MW*(cw - sw)*(cw + sw)*SwB)/(cw**4*sw**3*8._/**/REALKIND))
    f(643) = (eQED**5*integralnorm*MB*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**3*8._/**/REALKIND)
    f(644) = -((eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(sw**3*12._/**/REALKIND))
    f(645) = -((eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(sw**3*6._/**/REALKIND))
    f(646) = (eQED**5*integralnorm*MW**3*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**3*24._/**/REALKIND)
    f(647) = (eQED**5*integralnorm*MW**3*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**3*12._/**/REALKIND)
    f(648) = (eQED**5*integralnorm*MW*SwB*(cw**4*12._/**/REALKIND + sw**4*12._/**/REALKIND  &
      - cw**2*sw**2*24._/**/REALKIND))/(cw**2*sw**3*12._/**/REALKIND*24._/**/REALKIND)
    f(649) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw*12._/**/REALKIND)
    f(650) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw*6._/**/REALKIND)
    f(651) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(652) = -((eQED**5*integralnorm*MB*MW*(cw - sw)*(cw + sw)*SwB)/(cw**4*sw*8._/**/REALKIND))
    f(653) = (eQED**5*integralnorm*MH**2*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw*12._/**/REALKIND)
    f(654) = -((eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(cw**4*sw*6._/**/REALKIND))
    f(655) = (eQED**5*integralnorm*MW**3*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw*6._/**/REALKIND)
    f(656) = (eQED**5*integralnorm*MW*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**3*sw**2*4._/**/REALKIND*8._/**/REALKIND)
    f(657) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*4._/**/REALKIND))
    f(658) = (eQED**5*integralnorm*MW*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**3*sw**2*2._/**/REALKIND*4._/**/REALKIND)
    f(659) = -((eQED**5*integralnorm*MB*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*4._/**/REALKIND))
    f(660) = -((eQED**5*integralnorm*MH**2*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*4._/**/REALKIND))
    f(661) = -((eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(cw**5*2._/**/REALKIND))
    f(662) = -((eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(cw**3*2._/**/REALKIND))
    f(663) = (eQED**5*integralnorm*MW*SwF)/(cw*18._/**/REALKIND)
    f(664) = (eQED**5*integralnorm*MW*SwF)/(cw*9._/**/REALKIND)
    f(665) = (eQED**5*integralnorm*MW*SwF)/(cw*6._/**/REALKIND)
    f(666) = (2*eQED**5*integralnorm*MW*SwF)/(cw*9._/**/REALKIND)
    f(667) = (eQED**5*integralnorm*MW*SwF)/(cw*3._/**/REALKIND)
    f(668) = (eQED**5*integralnorm*MW*SwF)/(cw*2._/**/REALKIND)
    f(669) = (eQED**5*integralnorm*MW*SwF)/cw
    f(670) = (3*eQED**5*integralnorm*MW*SwF)/(cw*2._/**/REALKIND)
    f(671) = (eQED**5*integralnorm*SwF)/(MW**3*sw**5*8._/**/REALKIND)
    f(672) = (eQED**5*integralnorm*MB*SwF)/(MW**3*sw**5*16._/**/REALKIND)
    f(673) = (eQED**5*integralnorm*MB*SwF)/(MW**3*sw**5*8._/**/REALKIND)
    f(674) = (eQED**5*integralnorm*MB**2*SwF)/(MW**3*sw**5*16._/**/REALKIND)
    f(675) = (eQED**5*integralnorm*MB**3*SwF)/(MW**3*sw**5*32._/**/REALKIND)
    f(676) = (eQED**5*integralnorm*MB**3*SwF)/(MW**3*sw**5*16._/**/REALKIND)
    f(677) = (eQED**5*integralnorm*MB**4*SwF)/(MW**3*sw**5*16._/**/REALKIND)
    f(678) = (eQED**5*integralnorm*MB**2*MH**2*SwF)/(MW**3*sw**5*16._/**/REALKIND)
    f(679) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwF)/(MW**3*sw**5*16._/**/REALKIND)
    f(680) = (eQED**5*integralnorm*MB**3*MH**2*SwF)/(MW**3*sw**5*16._/**/REALKIND)
    f(681) = (3*eQED**5*integralnorm*lambdaHHH*MB**3*MH**2*SwF)/(MW**3*sw**5*16._/**/REALKIND)
    f(682) = (eQED**5*integralnorm*MB**2*ML*SwF)/(MW**3*sw**5*16._/**/REALKIND)
    f(683) = (eQED**5*integralnorm*MB*MH**2*ML*SwF)/(MW**3*sw**5*16._/**/REALKIND)
    f(684) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*ML*SwF)/(MW**3*sw**5*16._/**/REALKIND)
    f(685) = (eQED**5*integralnorm*ML**2*SwF)/(MW**3*sw**5*8._/**/REALKIND)
    f(686) = (eQED**5*integralnorm*MB*ML**2*SwF)/(MW**3*sw**5*32._/**/REALKIND)
    f(687) = (eQED**5*integralnorm*MB*ML**2*SwF)/(MW**3*sw**5*16._/**/REALKIND)
    f(688) = (eQED**5*integralnorm*MB**2*ML**2*SwF)/(MW**3*sw**5*16._/**/REALKIND)
    f(689) = (eQED**5*integralnorm*MB*MH**2*ML**2*SwF)/(MW**3*sw**5*16._/**/REALKIND)
    f(690) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*ML**2*SwF)/(MW**3*sw**5*16._/**/REALKIND)
    f(691) = (eQED**5*integralnorm*MB*ML**3*SwF)/(MW**3*sw**5*16._/**/REALKIND)
    f(692) = (eQED**5*integralnorm*MT*SwF)/(MW**3*sw**5*8._/**/REALKIND)
    f(693) = (eQED**5*integralnorm*MB*MT*SwF)/(MW**3*sw**5*16._/**/REALKIND)
    f(694) = (eQED**5*integralnorm*MB**2*MT*SwF)/(MW**3*sw**5*16._/**/REALKIND)
    f(695) = (eQED**5*integralnorm*MB*MH**2*MT*SwF)/(MW**3*sw**5*16._/**/REALKIND)
    f(696) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwF)/(MW**3*sw**5*16._/**/REALKIND)
    f(697) = (eQED**5*integralnorm*MB*MT**2*SwF)/(MW**3*sw**5*32._/**/REALKIND)
    f(698) = (eQED**5*integralnorm*MB*MT**2*SwF)/(MW**3*sw**5*16._/**/REALKIND)
    f(699) = (eQED**5*integralnorm*MB**2*MT**2*SwF)/(MW**3*sw**5*16._/**/REALKIND)
    f(700) = (eQED**5*integralnorm*MB*MH**2*MT**2*SwF)/(MW**3*sw**5*16._/**/REALKIND)
    f(701) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT**2*SwF)/(MW**3*sw**5*16._/**/REALKIND)
    f(702) = (eQED**5*integralnorm*MB*MT**3*SwF)/(MW**3*sw**5*16._/**/REALKIND)
    f(703) = (eQED**5*integralnorm*SwF)/(MW*sw**5*8._/**/REALKIND)
    f(704) = (eQED**5*integralnorm*SwF)/(MW*sw**5*4._/**/REALKIND)
    f(705) = (eQED**5*integralnorm*MB*SwF)/(MW*sw**5*8._/**/REALKIND)
    f(706) = (eQED**5*integralnorm*MB**2*SwF)/(MW*sw**5*8._/**/REALKIND)
    f(707) = (eQED**5*integralnorm*MB**3*SwF)/(MW*sw**5*8._/**/REALKIND)
    f(708) = (eQED**5*integralnorm*ML*SwF)/(MW*sw**5*8._/**/REALKIND)
    f(709) = (eQED**5*integralnorm*ML*SwF)/(MW*sw**5*4._/**/REALKIND)
    f(710) = (eQED**5*integralnorm*MB*ML*SwF)/(MW*sw**5*8._/**/REALKIND)
    f(711) = (eQED**5*integralnorm*MB*ML**2*SwF)/(MW*sw**5*8._/**/REALKIND)
    f(712) = (eQED**5*integralnorm*MT*SwF)/(MW*sw**5*8._/**/REALKIND)
    f(713) = (eQED**5*integralnorm*MB*MT*SwF)/(MW*sw**5*8._/**/REALKIND)
    f(714) = (eQED**5*integralnorm*MB*MT**2*SwF)/(MW*sw**5*8._/**/REALKIND)
    f(715) = (eQED**5*integralnorm*MW*SwF)/(sw**5*4._/**/REALKIND)
    f(716) = (eQED**5*integralnorm*MW*SwF)/(sw**5*2._/**/REALKIND)
    f(717) = (eQED**5*integralnorm*MB*MW*SwF)/(sw**5*4._/**/REALKIND)
    f(718) = (eQED**5*integralnorm*MB*MW*SwF)/(sw**5*2._/**/REALKIND)
    f(719) = (cw*eQED**5*integralnorm*MB**3*SwF)/(MW**3*sw**4*8._/**/REALKIND)
    f(720) = (cw*eQED**5*integralnorm*MB**2*MH**2*SwF)/(MW**3*sw**4*8._/**/REALKIND)
    f(721) = (3*cw*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwF)/(MW**3*sw**4*8._/**/REALKIND)
    f(722) = (cw*eQED**5*integralnorm*MB**2*ML*SwF)/(MW**3*sw**4*8._/**/REALKIND)
    f(723) = (cw*eQED**5*integralnorm*MB*MH**2*ML*SwF)/(MW**3*sw**4*8._/**/REALKIND)
    f(724) = (3*cw*eQED**5*integralnorm*lambdaHHH*MB*MH**2*ML*SwF)/(MW**3*sw**4*8._/**/REALKIND)
    f(725) = (cw*eQED**5*integralnorm*MB*ML**2*SwF)/(MW**3*sw**4*8._/**/REALKIND)
    f(726) = (cw*eQED**5*integralnorm*MB**2*MT*SwF)/(MW**3*sw**4*8._/**/REALKIND)
    f(727) = (cw*eQED**5*integralnorm*MB*MH**2*MT*SwF)/(MW**3*sw**4*8._/**/REALKIND)
    f(728) = (3*cw*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwF)/(MW**3*sw**4*8._/**/REALKIND)
    f(729) = (cw*eQED**5*integralnorm*MB*MT**2*SwF)/(MW**3*sw**4*8._/**/REALKIND)
    f(730) = (cw*eQED**5*integralnorm*SwF)/(MW*sw**4*4._/**/REALKIND)
    f(731) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**4*8._/**/REALKIND)
    f(732) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**4*4._/**/REALKIND)
    f(733) = (cw*eQED**5*integralnorm*MB*SwF)/(MW*sw**4*4._/**/REALKIND)
    f(734) = (eQED**5*integralnorm*MB**2*SwF)/(cw*MW*sw**4*8._/**/REALKIND)
    f(735) = (eQED**5*integralnorm*MB**2*SwF)/(cw*MW*sw**4*4._/**/REALKIND)
    f(736) = (cw*eQED**5*integralnorm*MB**2*SwF)/(MW*sw**4*4._/**/REALKIND)
    f(737) = (eQED**5*integralnorm*ML*SwF)/(cw*MW*sw**4*8._/**/REALKIND)
    f(738) = (cw*eQED**5*integralnorm*ML*SwF)/(MW*sw**4*4._/**/REALKIND)
    f(739) = (eQED**5*integralnorm*MB*ML*SwF)/(cw*MW*sw**4*8._/**/REALKIND)
    f(740) = (eQED**5*integralnorm*MB*ML*SwF)/(cw*MW*sw**4*4._/**/REALKIND)
    f(741) = (cw*eQED**5*integralnorm*MB*ML*SwF)/(MW*sw**4*4._/**/REALKIND)
    f(742) = (eQED**5*integralnorm*ML**2*SwF)/(cw*MW*sw**4*8._/**/REALKIND)
    f(743) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**4*8._/**/REALKIND)
    f(744) = (cw*eQED**5*integralnorm*MT*SwF)/(MW*sw**4*4._/**/REALKIND)
    f(745) = (eQED**5*integralnorm*MB*MT*SwF)/(cw*MW*sw**4*8._/**/REALKIND)
    f(746) = (eQED**5*integralnorm*MB*MT*SwF)/(cw*MW*sw**4*4._/**/REALKIND)
    f(747) = (cw*eQED**5*integralnorm*MB*MT*SwF)/(MW*sw**4*4._/**/REALKIND)
    f(748) = (eQED**5*integralnorm*MT**2*SwF)/(cw*MW*sw**4*8._/**/REALKIND)
    f(749) = (cw*eQED**5*integralnorm*MW*SwF)/(sw**4*2._/**/REALKIND)
    f(750) = (cw*eQED**5*integralnorm*MW*SwF)/sw**4
    f(751) = (eQED**5*integralnorm*MB**3*SwF)/(MW**3*sw**3*24._/**/REALKIND)
    f(752) = (eQED**5*integralnorm*MB**2*MH**2*SwF)/(MW**3*sw**3*24._/**/REALKIND)
    f(753) = (eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(754) = (eQED**5*integralnorm*MB**2*ML*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(755) = (eQED**5*integralnorm*MB*MH**2*ML*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(756) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*ML*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(757) = (eQED**5*integralnorm*MB*ML**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(758) = (eQED**5*integralnorm*MB**2*MT*SwF)/(MW**3*sw**3*12._/**/REALKIND)
    f(759) = (eQED**5*integralnorm*MB*MH**2*MT*SwF)/(MW**3*sw**3*12._/**/REALKIND)
    f(760) = (eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwF)/(MW**3*sw**3*4._/**/REALKIND)
    f(761) = (eQED**5*integralnorm*MB*MT**2*SwF)/(MW**3*sw**3*12._/**/REALKIND)
    f(762) = (eQED**5*integralnorm*SwF)/(MW*sw**3*36._/**/REALKIND)
    f(763) = (eQED**5*integralnorm*SwF)/(MW*sw**3*18._/**/REALKIND)
    f(764) = (eQED**5*integralnorm*SwF)/(MW*sw**3*12._/**/REALKIND)
    f(765) = (eQED**5*integralnorm*SwF)/(MW*sw**3*4._/**/REALKIND)
    f(766) = (eQED**5*integralnorm*MB*SwF)/(MW*sw**3*72._/**/REALKIND)
    f(767) = (eQED**5*integralnorm*MB*SwF)/(MW*sw**3*36._/**/REALKIND)
    f(768) = (eQED**5*integralnorm*MB*SwF)/(MW*sw**3*18._/**/REALKIND)
    f(769) = (eQED**5*integralnorm*MB*SwF)/(MW*sw**3*12._/**/REALKIND)
    f(770) = (eQED**5*integralnorm*MB*SwF)/(MW*sw**3*9._/**/REALKIND)
    f(771) = (eQED**5*integralnorm*MB*SwF)/(MW*sw**3*8._/**/REALKIND)
    f(772) = (eQED**5*integralnorm*MB*SwF)/(MW*sw**3*6._/**/REALKIND)
    f(773) = (eQED**5*integralnorm*MB*SwF)/(MW*sw**3*4._/**/REALKIND)
    f(774) = (eQED**5*integralnorm*MB*SwF)/(MW*sw**3*2._/**/REALKIND)
    f(775) = (3*eQED**5*integralnorm*MB*SwF)/(MW*sw**3*4._/**/REALKIND)
    f(776) = (eQED**5*integralnorm*MB**2*SwF)/(MW*sw**3*36._/**/REALKIND)
    f(777) = (eQED**5*integralnorm*MB**2*SwF)/(MW*sw**3*24._/**/REALKIND)
    f(778) = (eQED**5*integralnorm*MB**2*SwF)/(MW*sw**3*12._/**/REALKIND)
    f(779) = (eQED**5*integralnorm*MB**2*SwF)/(MW*sw**3*4._/**/REALKIND)
    f(780) = (eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwF)/(MW*sw**3*12._/**/REALKIND)
    f(781) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwF)/(MW*sw**3*4._/**/REALKIND)
    f(782) = (eQED**5*integralnorm*ML*SwF)/(MW*sw**3*24._/**/REALKIND)
    f(783) = (eQED**5*integralnorm*ML*SwF)/(MW*sw**3*12._/**/REALKIND)
    f(784) = (eQED**5*integralnorm*ML*SwF)/(MW*sw**3*8._/**/REALKIND)
    f(785) = (eQED**5*integralnorm*ML*SwF)/(MW*sw**3*4._/**/REALKIND)
    f(786) = (eQED**5*integralnorm*MB*ML*SwF)/(MW*sw**3*12._/**/REALKIND)
    f(787) = (eQED**5*integralnorm*MB*ML*SwF)/(MW*sw**3*8._/**/REALKIND)
    f(788) = (eQED**5*integralnorm*MB*ML*SwF)/(MW*sw**3*4._/**/REALKIND)
    f(789) = (eQED**5*integralnorm*lambdaHHH*MH**2*ML*SwF)/(MW*sw**3*4._/**/REALKIND)
    f(790) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*ML*SwF)/(MW*sw**3*4._/**/REALKIND)
    f(791) = (eQED**5*integralnorm*ML**2*SwF)/(MW*sw**3*12._/**/REALKIND)
    f(792) = (eQED**5*integralnorm*ML**2*SwF)/(MW*sw**3*4._/**/REALKIND)
    f(793) = (eQED**5*integralnorm*MT*SwF)/(MW*sw**3*36._/**/REALKIND)
    f(794) = (eQED**5*integralnorm*MT*SwF)/(MW*sw**3*18._/**/REALKIND)
    f(795) = (eQED**5*integralnorm*MT*SwF)/(MW*sw**3*12._/**/REALKIND)
    f(796) = (eQED**5*integralnorm*MT*SwF)/(MW*sw**3*8._/**/REALKIND)
    f(797) = (eQED**5*integralnorm*MT*SwF)/(MW*sw**3*4._/**/REALKIND)
    f(798) = (eQED**5*integralnorm*MB*MT*SwF)/(MW*sw**3*18._/**/REALKIND)
    f(799) = (eQED**5*integralnorm*MB*MT*SwF)/(MW*sw**3*12._/**/REALKIND)
    f(800) = (eQED**5*integralnorm*MB*MT*SwF)/(MW*sw**3*6._/**/REALKIND)
    f(801) = (eQED**5*integralnorm*MB*MT*SwF)/(MW*sw**3*4._/**/REALKIND)
    f(802) = (eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwF)/(MW*sw**3*6._/**/REALKIND)
    f(803) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwF)/(MW*sw**3*4._/**/REALKIND)
    f(804) = (eQED**5*integralnorm*MT**2*SwF)/(MW*sw**3*18._/**/REALKIND)
    f(805) = (eQED**5*integralnorm*MT**2*SwF)/(MW*sw**3*4._/**/REALKIND)
    f(806) = (eQED**5*integralnorm*MW*SwF)/(sw**3*18._/**/REALKIND)
    f(807) = (eQED**5*integralnorm*MW*SwF)/(sw**3*9._/**/REALKIND)
    f(808) = (eQED**5*integralnorm*MW*SwF)/(sw**3*6._/**/REALKIND)
    f(809) = (2*eQED**5*integralnorm*MW*SwF)/(sw**3*9._/**/REALKIND)
    f(810) = (eQED**5*integralnorm*MW*SwF)/(sw**3*3._/**/REALKIND)
    f(811) = (eQED**5*integralnorm*MW*SwF)/(sw**3*2._/**/REALKIND)
    f(812) = (eQED**5*integralnorm*MW*SwF)/sw**3
    f(813) = (eQED**5*integralnorm*MW*SwF)/(cw**2*sw**3*2._/**/REALKIND)
    f(814) = (eQED**5*integralnorm*MW*SwF)/(cw**2*sw**3)
    f(815) = (eQED**5*integralnorm*MB*MW*SwF)/(sw**3*18._/**/REALKIND)
    f(816) = (eQED**5*integralnorm*MB*MW*SwF)/(sw**3*2._/**/REALKIND)
    f(817) = (eQED**5*integralnorm*MB*MW*SwF)/(cw**2*sw**3*2._/**/REALKIND)
    f(818) = (eQED**5*integralnorm*ML*MW*SwF)/(sw**3*6._/**/REALKIND)
    f(819) = (eQED**5*integralnorm*ML*MW*SwF)/(sw**3*2._/**/REALKIND)
    f(820) = (eQED**5*integralnorm*ML*MW*SwF)/(cw**2*sw**3*2._/**/REALKIND)
    f(821) = (eQED**5*integralnorm*MT*MW*SwF)/(sw**3*9._/**/REALKIND)
    f(822) = (eQED**5*integralnorm*MT*MW*SwF)/(sw**3*2._/**/REALKIND)
    f(823) = (eQED**5*integralnorm*MT*MW*SwF)/(cw**2*sw**3*2._/**/REALKIND)
    f(824) = (eQED**5*integralnorm*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(825) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*12._/**/REALKIND)
    f(826) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*6._/**/REALKIND)
    f(827) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(828) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*3._/**/REALKIND)
    f(829) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*2._/**/REALKIND)
    f(830) = (cw*eQED**5*integralnorm*MB*SwF)/(MW*sw**2*18._/**/REALKIND)
    f(831) = (cw*eQED**5*integralnorm*MB*SwF)/(MW*sw**2*9._/**/REALKIND)
    f(832) = (cw*eQED**5*integralnorm*MB*SwF)/(MW*sw**2*6._/**/REALKIND)
    f(833) = (2*cw*eQED**5*integralnorm*MB*SwF)/(MW*sw**2*9._/**/REALKIND)
    f(834) = (cw*eQED**5*integralnorm*MB*SwF)/(MW*sw**2*3._/**/REALKIND)
    f(835) = (cw*eQED**5*integralnorm*MB*SwF)/(MW*sw**2*2._/**/REALKIND)
    f(836) = (cw*eQED**5*integralnorm*MB*SwF)/(MW*sw**2)
    f(837) = (3*cw*eQED**5*integralnorm*MB*SwF)/(MW*sw**2*2._/**/REALKIND)
    f(838) = (eQED**5*integralnorm*MB**2*SwF)/(cw*MW*sw**2*8._/**/REALKIND)
    f(839) = (eQED**5*integralnorm*ML*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(840) = (cw*eQED**5*integralnorm*ML*SwF)/(MW*sw**2*6._/**/REALKIND)
    f(841) = (cw*eQED**5*integralnorm*ML*SwF)/(MW*sw**2*2._/**/REALKIND)
    f(842) = (eQED**5*integralnorm*MB*ML*SwF)/(cw*MW*sw**2*8._/**/REALKIND)
    f(843) = (eQED**5*integralnorm*ML**2*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(844) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*6._/**/REALKIND)
    f(845) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(846) = (cw*eQED**5*integralnorm*MT*SwF)/(MW*sw**2*9._/**/REALKIND)
    f(847) = (cw*eQED**5*integralnorm*MT*SwF)/(MW*sw**2*2._/**/REALKIND)
    f(848) = (eQED**5*integralnorm*MB*MT*SwF)/(cw*MW*sw**2*8._/**/REALKIND)
    f(849) = (eQED**5*integralnorm*MW*SwF)/(cw*sw**2*9._/**/REALKIND)
    f(850) = (2*eQED**5*integralnorm*MW*SwF)/(cw*sw**2*9._/**/REALKIND)
    f(851) = (eQED**5*integralnorm*MW*SwF)/(cw*sw**2*3._/**/REALKIND)
    f(852) = (4*eQED**5*integralnorm*MW*SwF)/(cw*sw**2*9._/**/REALKIND)
    f(853) = (eQED**5*integralnorm*MW*SwF)/(cw*sw**2*2._/**/REALKIND)
    f(854) = (2*eQED**5*integralnorm*MW*SwF)/(cw*sw**2*3._/**/REALKIND)
    f(855) = (eQED**5*integralnorm*MW*SwF)/(cw*sw**2)
    f(856) = (2*eQED**5*integralnorm*MW*SwF)/(cw*sw**2)
    f(857) = (3*eQED**5*integralnorm*MW*SwF)/(cw*sw**2)
    f(858) = (cw*eQED**5*integralnorm*MW*SwF)/(sw**2*9._/**/REALKIND)
    f(859) = (2*cw*eQED**5*integralnorm*MW*SwF)/(sw**2*9._/**/REALKIND)
    f(860) = (cw*eQED**5*integralnorm*MW*SwF)/(sw**2*3._/**/REALKIND)
    f(861) = (4*cw*eQED**5*integralnorm*MW*SwF)/(sw**2*9._/**/REALKIND)
    f(862) = (2*cw*eQED**5*integralnorm*MW*SwF)/(sw**2*3._/**/REALKIND)
    f(863) = (cw*eQED**5*integralnorm*MW*SwF)/sw**2
    f(864) = (2*cw*eQED**5*integralnorm*MW*SwF)/sw**2
    f(865) = (3*cw*eQED**5*integralnorm*MW*SwF)/sw**2
    f(866) = (eQED**5*integralnorm*ML*MW*SwF)/(cw*sw**2*2._/**/REALKIND)
    f(867) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*54._/**/REALKIND)
    f(868) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*27._/**/REALKIND)
    f(869) = (2*eQED**5*integralnorm*MB*SwF)/(MW*sw*27._/**/REALKIND)
    f(870) = (4*eQED**5*integralnorm*MB*SwF)/(MW*sw*27._/**/REALKIND)
    f(871) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*6._/**/REALKIND)
    f(872) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*3._/**/REALKIND)
    f(873) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*2._/**/REALKIND)
    f(874) = (2*eQED**5*integralnorm*MB*SwF)/(MW*sw*3._/**/REALKIND)
    f(875) = (eQED**5*integralnorm*MB*SwF)/(MW*sw)
    f(876) = (eQED**5*integralnorm*ML*SwF)/(MW*sw*6._/**/REALKIND)
    f(877) = (eQED**5*integralnorm*ML*SwF)/(MW*sw*2._/**/REALKIND)
    f(878) = (2*eQED**5*integralnorm*MT*SwF)/(MW*sw*27._/**/REALKIND)
    f(879) = (eQED**5*integralnorm*MT*SwF)/(MW*sw*3._/**/REALKIND)
    f(880) = (eQED**5*integralnorm*MW*SwF)/(sw*54._/**/REALKIND)
    f(881) = (eQED**5*integralnorm*MW*SwF)/(sw*27._/**/REALKIND)
    f(882) = (2*eQED**5*integralnorm*MW*SwF)/(sw*27._/**/REALKIND)
    f(883) = (4*eQED**5*integralnorm*MW*SwF)/(sw*27._/**/REALKIND)
    f(884) = (eQED**5*integralnorm*MW*SwF)/(sw*6._/**/REALKIND)
    f(885) = (8*eQED**5*integralnorm*MW*SwF)/(sw*27._/**/REALKIND)
    f(886) = (eQED**5*integralnorm*MW*SwF)/(sw*3._/**/REALKIND)
    f(887) = (eQED**5*integralnorm*MW*SwF)/(sw*2._/**/REALKIND)
    f(888) = (2*eQED**5*integralnorm*MW*SwF)/(sw*3._/**/REALKIND)
    f(889) = (eQED**5*integralnorm*MW*SwF)/sw
    f(890) = (4*eQED**5*integralnorm*MW*SwF)/(sw*3._/**/REALKIND)
    f(891) = (2*eQED**5*integralnorm*MW*SwF)/sw
    f(892) = (eQED**5*integralnorm*MW*SwF)/(cw**2*sw*3._/**/REALKIND)
    f(893) = (2*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*3._/**/REALKIND)
    f(894) = (eQED**5*integralnorm*MW*SwF)/(cw**2*sw)
    f(895) = (4*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*3._/**/REALKIND)
    f(896) = (2*eQED**5*integralnorm*MW*SwF)/(cw**2*sw)

  c = [ f(107), f(108), f(109), f(110), f(111), f(112), f(113), f(114), f(115), f(116), f(117), f(118), f(119), f(120), f(121) &
    , f(122), f(123), f(124), f(125), f(126), f(127), f(128), f(129), f(130), f(131), f(132), f(133), f(134), f(135), f(136) &
    , f(137), f(138), f(139), f(140), f(141), f(142), f(143), f(144), f(145), f(146), f(147), f(148), f(149), f(150), f(151) &
    , f(152), f(153), f(154), f(155), f(156), f(157), f(158), f(159), f(160), f(161), f(162), f(163), f(164), f(165), f(166) &
    , f(167), f(168), f(169), f(170), f(171), f(172), f(173), f(174), f(175), f(176), f(177), f(178), f(179), f(180), f(181) &
    , f(182), f(183), f(184), f(185), f(186), f(187), f(188), f(189), f(190), f(191), f(192), f(193), f(194), f(195), f(196) &
    , f(197), f(198), f(199), f(200), f(201), f(202), f(203), f(204), f(205), f(206), f(207), f(208), f(209), f(210), f(211) &
    , f(212), f(213), f(214), f(215), f(216), f(217), f(218), f(219), f(220), f(221), f(222), f(223), f(224), f(225), f(226) &
    , f(227), f(228), f(229), f(230), f(231), f(232), f(233), f(234), f(235), f(236), f(237), f(238), f(239), f(240), f(241) &
    , f(242), f(243), f(244), f(245), f(246), f(247), f(248), f(249), f(250), f(251), f(252), f(253), f(254), f(255), f(256) &
    , f(257), f(258), f(259), f(260), f(261), f(262), f(263), f(264), f(265), f(266), f(267), f(268), f(269), f(270), f(271) &
    , f(272), f(273), f(274), f(275), f(276), f(277), f(278), f(279), f(280), f(281), f(282), f(283), f(284), f(285), f(286) &
    , f(287), f(288), f(289), f(290), f(291), f(292), f(293), f(294), f(295), f(296), f(297), f(298), f(299), f(300), f(301) &
    , f(302), f(303), f(304), f(305), f(306), f(307), f(308), f(309), f(310), f(311), f(312), f(313), f(314), f(315), f(316) &
    , f(317), f(318), f(319), f(320), f(321), f(322), f(323), f(324), f(325), f(326), f(327), f(328), f(329), f(330), f(331) &
    , f(332), f(333), f(334), f(335), f(336), f(337), f(338), f(339), f(340), f(341), f(342), f(343), f(344), f(345), f(346) &
    , f(347), f(348), f(349), f(350), f(351), f(352), f(353), f(354), f(355), f(356), f(357), f(358), f(359), f(360), f(361) &
    , f(362), f(363), f(364), f(365), f(366), f(367), f(368), f(369), f(370), f(371), f(372), f(373), f(374), f(375), f(376) &
    , f(377), f(378), f(379), f(380), f(381), f(382), f(383), f(384), f(385), f(386), f(387), f(388), f(389), f(390), f(391) &
    , f(392), f(393), f(394), f(395), f(396), f(397), f(398), f(399), f(400), f(401), f(402), f(403), f(404), f(405), f(406) &
    , f(407), f(408), f(409), f(410), f(411), f(412), f(413), f(414), f(415), f(416), f(417), f(418), f(419), f(420), f(421) &
    , f(422), f(423), f(424), f(425), f(426), f(427), f(428), f(429), f(430), f(431), f(432), f(433), f(434), f(435), f(436) &
    , f(437), f(438), f(439), f(440), f(441), f(442), f(443), f(444), f(445), f(446), f(447), f(448), f(449), f(450), f(451) &
    , f(452), f(453), f(454), f(455), f(456), f(457), f(458), f(459), f(460), f(461), f(462), f(463), f(464), f(465), f(466) &
    , f(467), f(468), f(469), f(470), f(471), f(472), f(473), f(474), f(475), f(476), f(477), f(478), f(479), f(480), f(481) &
    , f(482), f(483), f(484), f(485), f(486), f(487), f(488), f(489), f(490), f(491), f(492), f(493), f(494), f(495), f(496) &
    , f(497), f(498), f(499), f(500), f(501), f(502), f(503), f(504), f(505), f(506), f(507), f(508), f(509), f(510), f(511) &
    , f(512), f(513), f(514), f(515), f(516), f(517), f(518), f(519), f(520), f(521), f(522), f(523), f(524), f(525), f(526) &
    , f(527), f(528), f(529), f(530), f(531), f(532), f(533), f(534), f(535), f(536), f(537), f(538), f(539), f(540), f(541) &
    , f(542), f(543), f(544), f(545), f(546), f(547), f(548), f(549), f(550), f(551), f(552), f(553), f(554), f(555), f(556) &
    , f(557), f(558), f(559), f(560), f(561), f(562), f(563), f(564), f(565), f(566), f(567), f(568), f(569), f(570), f(571) &
    , f(572), f(573), f(574), f(575), f(576), f(577), f(578), f(579), f(580), f(581), f(582), f(583), f(584), f(585), f(586) &
    , f(587), f(588), f(589), f(590), f(591), f(592), f(593), f(594), f(595), f(596), f(597), f(598), f(599), f(600), f(601) &
    , f(602), f(603), f(604), f(605), f(606), f(607), f(608), f(609), f(610), f(611), f(612), f(613), f(614), f(615), f(616) &
    , f(617), f(618), f(619), f(620), f(621), f(622), f(623), f(624), f(625), f(626), f(627), f(628), f(629), f(630), f(631) &
    , f(632), f(633), f(634), f(635), f(636), f(637), f(638), f(639), f(640), f(641), f(642), f(643), f(644), f(645), f(646) &
    , f(647), f(648), f(649), f(650), f(651), f(652), f(653), f(654), f(655), f(656), f(657), f(658), f(659), f(660), f(661) &
    , f(662), 3*f(663), 3*f(664), f(665), 3*f(666), f(667), f(668), 3*f(668), f(669), 3*f(669), f(670), 3*f(671), 3*f(672) &
    , 3*f(673), 3*f(674), 3*f(675), 3*f(676), 3*f(677), 3*f(678), 3*f(679), 3*f(680), 3*f(681), f(682), f(683), f(684), f(685) &
    , f(686), f(687), f(688), f(689), f(690), f(691), 3*f(692), 3*f(693), 3*f(694), 3*f(695), 3*f(696), 3*f(697), 3*f(698) &
    , 3*f(699), 3*f(700), 3*f(701), 3*f(702), 3*f(703), 3*f(704), 3*f(705), 3*f(706), 3*f(707), f(708), f(709), f(710), f(711) &
    , 3*f(712), 3*f(713), 3*f(714), f(715), 3*f(715), f(716), 3*f(716), f(717), 3*f(717), f(718), 3*f(718), 3*f(719), 3*f(720) &
    , 3*f(721), f(722), f(723), f(724), f(725), 3*f(726), 3*f(727), 3*f(728), 3*f(729), 3*f(730), f(731), 3*f(731), f(732) &
    , 3*f(732), 3*f(733), 3*f(734), 3*f(735), 3*f(736), f(737), f(738), f(739), f(740), f(741), f(742), 3*f(743), 3*f(744) &
    , 3*f(745), 3*f(746), 3*f(747), 3*f(748), f(749), 3*f(749), f(750), 3*f(750), 3*f(751), 3*f(752), 3*f(753), f(754), f(755) &
    , f(756), f(757), 3*f(758), 3*f(759), 3*f(760), 3*f(761), 3*f(762), 3*f(763), 3*f(764), 3*f(765), 3*f(766), 3*f(767), 3*f(768) &
    , f(769), 3*f(769), 3*f(770), 3*f(771), f(772), f(773), 3*f(773), f(774), 3*f(774), f(775), 3*f(776), 3*f(777), 3*f(778) &
    , 3*f(779), 3*f(780), 3*f(781), f(782), f(783), f(784), f(785), f(786), f(787), f(788), f(789), f(790), f(791), f(792) &
    , 3*f(793), 3*f(794), 3*f(795), 3*f(796), 3*f(797), 3*f(798), 3*f(799), 3*f(800), 3*f(801), 3*f(802), 3*f(803), 3*f(804) &
    , 3*f(805), 3*f(806), 3*f(807), f(808), 3*f(808), 3*f(809), f(810), 3*f(810), f(811), 3*f(811), f(812), 3*f(812), f(813) &
    , 3*f(813), f(814), 3*f(814), 3*f(815), 3*f(816), 3*f(817), f(818), f(819), f(820), 3*f(821), 3*f(822), 3*f(823), 3*f(824) &
    , 3*f(825), 3*f(826), f(827), 3*f(827), 3*f(828), f(829), 3*f(830), 3*f(831), f(832), 3*f(833), f(834), f(835), 3*f(835) &
    , f(836), 3*f(836), f(837), 3*f(838), f(839), f(840), f(841), f(842), f(843), 3*f(844), 3*f(845), 3*f(846), 3*f(847), 3*f(848) &
    , 3*f(849), 3*f(850), f(851), 3*f(852), 3*f(853), f(854), f(855), 3*f(855), f(856), 3*f(856), f(857), 3*f(858), 3*f(859) &
    , f(860), 3*f(861), f(862), f(863), 3*f(863), f(864), 3*f(864), f(865), f(866), 3*f(867), 3*f(868), 3*f(869), 3*f(870), f(871) &
    , 3*f(871), f(872), 3*f(872), f(873), 3*f(874), f(875), f(876), f(877), 3*f(878), 3*f(879), 3*f(880), 3*f(881), 3*f(882) &
    , 3*f(883), f(884), 3*f(884), 3*f(885), f(886), 3*f(886), f(887), f(888), 3*f(888), f(889), 3*f(890), f(891), 3*f(892) &
    , 3*f(893), f(894), 3*f(895), f(896) ]
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3) - MH2)+L(6,3))
  den(2) = 1 /((L(5,12) - MW2)+L(6,12))
  den(4) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(6) = 1 /((L(5,3))+L(6,3))
  den(8) = 1 /((L(5,20) - MW2)+L(6,20))
  den(12) = 1 /((L(5,24) - MH2)+L(6,24))
  den(14) = 1 /((L(5,24) - MZ2)+L(6,24))
  den(16) = 1 /((L(5,5) - MB2)+L(6,5))
  den(17) = 1 /((L(5,10) - MT2)+L(6,10))
  den(20) = 1 /((L(5,24))+L(6,24))
  den(23) = 1 /((L(5,17) - MT2)+L(6,17))
  den(24) = 1 /((L(5,6) - MB2)+L(6,6))
  den(32) = 1 /((L(5,28) - MH2)+L(6,28))
  den(39) = 1 /((L(5,28) - MZ2)+L(6,28))
  den(42) = 1 /((L(5,28))+L(6,28))
  den(47) = 1 /((L(5,19) - MW2)+L(6,19))
  den(62) = 1 /((L(5,11) - MW2)+L(6,11))
  den(74) = 1 /((L(5,7) - MH2)+L(6,7))
  den(77) = 1 /((L(5,7) - MZ2)+L(6,7))
  den(81) = 1 /((L(5,26) - MB2)+L(6,26))
  den(84) = 1 /((L(5,21) - MT2)+L(6,21))
  den(98) = 1 /((L(5,7))+L(6,7))
  den(102) = 1 /((L(5,14) - MT2)+L(6,14))
  den(105) = 1 /((L(5,25) - MB2)+L(6,25))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(2)*den(4)
  den(7) = den(2)*den(6)
  den(9) = den(1)*den(8)
  den(10) = den(4)*den(8)
  den(11) = den(6)*den(8)
  den(13) = den(1)*den(12)
  den(15) = den(4)*den(14)
  den(18) = den(16)*den(17)
  den(19) = den(12)*den(16)
  den(21) = den(16)*den(20)
  den(22) = den(14)*den(16)
  den(25) = den(23)*den(24)
  den(26) = den(12)*den(24)
  den(27) = den(20)*den(24)
  den(28) = den(14)*den(24)
  den(29) = den(17)*den(23)
  den(30) = den(8)*den(17)
  den(31) = den(2)*den(23)
  den(33) = den(1)*den(32)
  den(34) = den(4)*den(20)
  den(35) = den(6)*den(20)
  den(36) = den(6)*den(14)
  den(37) = den(2)*den(32)
  den(38) = den(1)*den(37)
  den(40) = den(2)*den(39)
  den(41) = den(4)*den(40)
  den(43) = den(2)*den(42)
  den(44) = den(4)*den(43)
  den(45) = den(6)*den(40)
  den(46) = den(6)*den(43)
  den(48) = den(1)*den(47)
  den(49) = den(2)*den(48)
  den(50) = den(4)*den(47)
  den(51) = den(2)*den(50)
  den(52) = den(6)*den(47)
  den(53) = den(2)*den(52)
  den(54) = den(8)*den(32)
  den(55) = den(1)*den(54)
  den(56) = den(8)*den(39)
  den(57) = den(4)*den(56)
  den(58) = den(8)*den(42)
  den(59) = den(4)*den(58)
  den(60) = den(6)*den(56)
  den(61) = den(6)*den(58)
  den(63) = den(1)*den(62)
  den(64) = den(8)*den(63)
  den(65) = den(4)*den(62)
  den(66) = den(8)*den(65)
  den(67) = den(6)*den(62)
  den(68) = den(8)*den(67)
  den(69) = den(12)*den(32)
  den(70) = den(1)*den(69)
  den(71) = den(14)*den(39)
  den(72) = den(4)*den(71)
  den(73) = den(6)*den(71)
  den(75) = den(1)*den(74)
  den(76) = den(12)*den(75)
  den(78) = den(4)*den(77)
  den(79) = den(20)*den(78)
  den(80) = den(14)*den(78)
  den(82) = den(17)*den(81)
  den(83) = den(16)*den(82)
  den(85) = den(16)*den(84)
  den(86) = den(17)*den(85)
  den(87) = den(12)*den(81)
  den(88) = den(16)*den(87)
  den(89) = den(20)*den(81)
  den(90) = den(16)*den(89)
  den(91) = den(14)*den(81)
  den(92) = den(16)*den(91)
  den(93) = den(16)*den(74)
  den(94) = den(12)*den(93)
  den(95) = den(16)*den(77)
  den(96) = den(20)*den(95)
  den(97) = den(14)*den(95)
  den(99) = den(16)*den(98)
  den(100) = den(20)*den(99)
  den(101) = den(14)*den(99)
  den(103) = den(24)*den(102)
  den(104) = den(23)*den(103)
  den(106) = den(23)*den(105)
  den(107) = den(24)*den(106)
  den(108) = den(12)*den(105)
  den(109) = den(24)*den(108)
  den(110) = den(20)*den(105)
  den(111) = den(24)*den(110)
  den(112) = den(14)*den(105)
  den(113) = den(24)*den(112)
  den(114) = den(24)*den(74)
  den(115) = den(12)*den(114)
  den(116) = den(24)*den(77)
  den(117) = den(20)*den(116)
  den(118) = den(14)*den(116)
  den(119) = den(24)*den(98)
  den(120) = den(20)*den(119)
  den(121) = den(14)*den(119)
  den(122) = den(17)*den(102)
  den(123) = den(23)*den(122)
  den(124) = den(23)*den(84)
  den(125) = den(17)*den(124)
  den(126) = den(8)*den(84)
  den(127) = den(17)*den(126)
  den(128) = den(17)*den(62)
  den(129) = den(8)*den(128)
  den(130) = den(2)*den(102)
  den(131) = den(23)*den(130)
  den(132) = den(23)*den(47)
  den(133) = den(2)*den(132)
  den(134) = den(4)*den(12)
  den(135) = den(1)*den(20)
  den(136) = den(1)*den(14)
  den(137) = den(6)*den(12)
  den(138) = den(4)*den(32)
  den(139) = den(6)*den(32)
  den(140) = den(1)*den(40)
  den(141) = den(4)*den(37)
  den(142) = den(1)*den(43)
  den(143) = den(6)*den(37)
  den(144) = den(1)*den(56)
  den(145) = den(4)*den(54)
  den(146) = den(1)*den(58)
  den(147) = den(6)*den(54)
  den(148) = den(12)*den(78)
  den(149) = den(20)*den(75)
  den(150) = den(14)*den(75)
  den(151) = den(4)*den(69)
  den(152) = den(1)*den(71)
  den(153) = den(6)*den(69)
  den(154) = den(12)*den(95)
  den(155) = den(20)*den(93)
  den(156) = den(14)*den(93)
  den(157) = den(12)*den(99)
  den(158) = den(12)*den(116)
  den(159) = den(20)*den(114)
  den(160) = den(14)*den(114)
  den(161) = den(12)*den(119)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_pphvv_ew_bbxhwwx_1_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,244))
  allocate(M1helarray(1,hel_states))
  allocate(M1helarray_ct(1,hel_states))
  allocate(M0_col1_helarray(1,hel_states))
  A(1:hel_states,1:244)%j = 0
  A(1:hel_states,1:244)%e = 0
  A(1:hel_states,1:244)%hf = 0
  A(1:hel_states,1:244)%s = 0
#if 1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(1,hel_states,16))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
#else
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
  use ol_loop_storage_pphvv_ew_bbxhwwx_1_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for bottom anti-bottom higgs W- W+ -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_pphvv_ew_bbxhwwx_1, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_pphvv_ew_bbxhwwx_1, only: &
    & external_perm_pphvv_ew_bbxhwwx_1, &
    & external_perm_inv_pphvv_ew_bbxhwwx_1, &
    & extcomb_perm_pphvv_ew_bbxhwwx_1, &
    & average_factor_pphvv_ew_bbxhwwx_1
  use ol_external_pphvv_ew_bbxhwwx_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_pphvv_ew_bbxhwwx_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pphvv_ew_bbxhwwx_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_pphvv_ew_bbxhwwx_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02
  logical, intent(in) :: qp_kinematics
  real(REALKIND),  intent(out), optional :: M2ct
  real(REALKIND),  intent(out), optional :: M2colint(16)
  real(REALKIND) :: iM2ct
  real(REALKIND) :: iM2colint(16)

  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(1), M2(1)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak
  logical              :: do_ct, do_colint
#if 5 > 3
  integer :: ind_cc_comb(5)
#endif
  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if (present(M2ct)) then
    do_ct = .true.
  else
    do_ct = .false.
  end if

  if (present(M2colint)) then
    do_colint = .true.
  else
    do_colint = .false.
  end if

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, qp_kinematics, M2ct=iM2ct, M2colint=iM2colint)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,244))
  end if

  if (do_ct) call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()
  if (do_ct) call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  if (do_ct) call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMB, nMB, nMH, nMW, nMW ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_pphvv_ew_bbxhwwx_1, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMB, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rMB, H2, ex2, POLSEL(2),2)
  call pol_wf_S(P(:,3), rMH, H3, ex3, POLSEL(3),3)
  call pol_wf_V(P(:,4), rMW, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rMW, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_VVS_S(ntry, ex4(:), ex5(:), ex3(:), wf9(:,1), n4(:,1), t4x9(:,:,1))
  call vert_TV_S(ntry, ex3(:), 4, ex4(:), 8, wf3(:,1), n3(:,2), t3x3(:,:,1))
  call vert_TV_S(ntry, wf4(:,1), 3, ex5(:), 16, wf12(:,1), n3(:,3), t3x12(:,:,1))
  call vert_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,2), n3(:,4), t3x4(:,:,2))
  call vert_TV_S(ntry, wf4(:,2), 3, ex5(:), 16, wf12(:,2), n3(:,5), t3x12(:,:,2))
  call vert_SV_V(ntry, ex3(:), ex4(:), wf3(:,2), n3(:,6), t3x3(:,:,2))
  call vert_SV_V(ntry, wf4(:,1), ex5(:), wf12(:,3), n3(:,7), t3x12(:,:,3))
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,3), n3(:,8), t3x4(:,:,3))
  call vert_VV_S(ntry, wf4(:,3), ex5(:), wf12(:,4), n3(:,9), t3x12(:,:,4))
  call vert_QA_Z(gZd,ntry, ex1(:), ex2(:), wf4(:,4), n3(:,10), t3x4(:,:,4))
  call vert_VV_S(ntry, wf4(:,4), ex5(:), wf12(:,5), n3(:,11), t3x12(:,:,5))
  call vert_UV_W(ntry, wf4(:,3), 3, ex5(:), 16, wf12(:,6), n3(:,12), t3x12(:,:,6))
  call vert_UV_W(ntry, wf4(:,4), 3, ex5(:), 16, wf12(:,7), n3(:,13), t3x12(:,:,7))
  call vert_TV_S(ntry, ex3(:), 4, ex5(:), 16, wf3(:,3), n3(:,14), t3x3(:,:,3))
  call vert_TV_S(ntry, wf4(:,1), 3, ex4(:), 8, wf12(:,8), n3(:,15), t3x12(:,:,8))
  call vert_TV_S(ntry, wf4(:,2), 3, ex4(:), 8, wf12(:,9), n3(:,16), t3x12(:,:,9))
  call vert_SV_V(ntry, ex3(:), ex5(:), wf3(:,4), n3(:,17), t3x3(:,:,4))
  call vert_SV_V(ntry, wf4(:,1), ex4(:), wf12(:,10), n3(:,18), t3x12(:,:,10))
  call vert_VV_S(ntry, wf4(:,3), ex4(:), wf12(:,11), n3(:,19), t3x12(:,:,11))
  call vert_VV_S(ntry, wf4(:,4), ex4(:), wf12(:,12), n3(:,20), t3x12(:,:,12))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,3), 3, wf12(:,13), n3(:,21), t3x12(:,:,13))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,4), 3, wf12(:,14), n3(:,22), t3x12(:,:,14))
  call vert_VV_S(ntry, ex4(:), ex5(:), wf9(:,2), n3(:,23), t3x9(:,:,1))
  call vert_SS_S(ntry, wf4(:,1), ex3(:), wf4(:,5), n3(:,24), t3x4(:,:,5))
  call vert_UV_W(ntry, ex5(:), 16, ex4(:), 8, wf9(:,3), n3(:,25), t3x9(:,:,2))
  call vert_ST_V(ntry, wf4(:,2), 3, ex3(:), 4, wf4(:,6), n3(:,26), t3x4(:,:,6))
  call vert_SV_V(ntry, ex3(:), wf4(:,4), wf4(:,7), n3(:,27), t3x4(:,:,7))
  call vert_QS_A(gH,ntry, ex1(:), ex3(:), wf2(:,1), n3(:,28), t3x2(:,:,1))
  call vert_AW_Q(ntry, ex2(:), ex4(:), wf6(:,1), n3(:,29), t3x6(:,:,1))
  call prop_Q_A(ntry, wf2(:,1), 5, MB, 1_intkind1, wf2(:,2), n2(1))
  call prop_A_Q(ntry, wf6(:,1), 10, MT, 1_intkind1, wf6(:,2), n2(2))
  call vert_WQ_A(ntry, ex5(:), wf2(:,2), wf6(:,3), n3(:,30), t3x6(:,:,2))
  call vert_AQ_S(gH,ntry, ex2(:), wf2(:,2), wf4(:,8), n3(:,31), t3x4(:,:,8))
  call vert_QA_V(ntry, wf2(:,2), ex2(:), wf4(:,9), n3(:,32), t3x4(:,:,9))
  call vert_QA_Z(gZd,ntry, wf2(:,2), ex2(:), wf4(:,10), n3(:,33), t3x4(:,:,10))
  call vert_WQ_A(ntry, ex5(:), ex1(:), wf6(:,4), n3(:,34), t3x6(:,:,3))
  call vert_SA_Q(gH,ntry, ex3(:), ex2(:), wf2(:,3), n3(:,35), t3x2(:,:,2))
  call prop_Q_A(ntry, wf6(:,4), 17, MT, 1_intkind1, wf6(:,5), n2(3))
  call prop_A_Q(ntry, wf2(:,3), 6, MB, 1_intkind1, wf2(:,4), n2(4))
  call vert_WQ_A(ntry, ex4(:), wf6(:,5), wf18(:,1), n3(:,36), t3x18(:,:,1))
  call vert_AQ_S(gH,ntry, wf2(:,4), ex1(:), wf4(:,11), n3(:,37), t3x4(:,:,11))
  call vert_QA_V(ntry, ex1(:), wf2(:,4), wf4(:,12), n3(:,38), t3x4(:,:,12))
  call vert_QA_Z(gZd,ntry, ex1(:), wf2(:,4), wf4(:,13), n3(:,39), t3x4(:,:,13))
  call vert_QS_A(gH,ntry, wf6(:,5), ex3(:), wf6(:,6), n3(:,40), t3x6(:,:,4))
  call vert_AQ_S(gPtb,ntry, wf6(:,2), ex1(:), wf12(:,15), n3(:,41), t3x12(:,:,15))
  call vert_QA_W(ntry, ex1(:), wf6(:,2), wf12(:,16), n3(:,42), t3x12(:,:,16))
  call vert_AQ_S(gPbt,ntry, ex2(:), wf6(:,5), wf12(:,17), n3(:,43), t3x12(:,:,17))
  call vert_QA_W(ntry, wf6(:,5), ex2(:), wf12(:,18), n3(:,44), t3x12(:,:,18))
  call counter_VVS_S(ntry, ex4(:), ex5(:), ex3(:), wf9(:,4), n4(:,2), t4x9(:,:,2))
  call counter_AQ_S(EWctHbb,ntry, ex2(:), ex1(:), wf4(:,14), n3(:,45), t3x4(:,:,14))
  call counter_TV_S(ntry, wf4(:,1), 3, ex5(:), 16, wf12(:,19), n3(:,46), t3x12(:,:,19))
  call counter_TV_S(ntry, wf4(:,2), 3, ex5(:), 16, wf12(:,20), n3(:,47), t3x12(:,:,20))
  call counter_SV_V(ntry, wf4(:,1), ex5(:), wf12(:,21), n3(:,48), t3x12(:,:,21))
  call counter_VV_S(ntry, wf4(:,3), ex5(:), wf12(:,22), n3(:,49), t3x12(:,:,22))
  call counter_VV_S(ntry, wf4(:,4), ex5(:), wf12(:,23), n3(:,50), t3x12(:,:,23))
  call counter_UV_W(ntry, wf4(:,3), 3, ex5(:), 16, wf12(:,24), n3(:,51), t3x12(:,:,24))
  call counter_UV_W(ntry, wf4(:,4), 3, ex5(:), 16, wf12(:,25), n3(:,52), t3x12(:,:,25))
  call counter_TV_S(ntry, wf4(:,1), 3, ex4(:), 8, wf12(:,26), n3(:,53), t3x12(:,:,26))
  call counter_TV_S(ntry, wf4(:,2), 3, ex4(:), 8, wf12(:,27), n3(:,54), t3x12(:,:,27))
  call counter_SV_V(ntry, wf4(:,1), ex4(:), wf12(:,28), n3(:,55), t3x12(:,:,28))
  call counter_VV_S(ntry, wf4(:,3), ex4(:), wf12(:,29), n3(:,56), t3x12(:,:,29))
  call counter_VV_S(ntry, wf4(:,4), ex4(:), wf12(:,30), n3(:,57), t3x12(:,:,30))
  call counter_UV_W(ntry, ex4(:), 8, wf4(:,3), 3, wf12(:,31), n3(:,58), t3x12(:,:,31))
  call counter_UV_W(ntry, ex4(:), 8, wf4(:,4), 3, wf12(:,32), n3(:,59), t3x12(:,:,32))
  call counter_VV_S(ntry, ex4(:), ex5(:), wf9(:,5), n3(:,60), t3x9(:,:,3))
  call counter_UV_W(ntry, ex5(:), 16, ex4(:), 8, wf9(:,6), n3(:,61), t3x9(:,:,4))
  call counter_S_S(EWctHH,ntry, wf4(:,1), 3, wf4(:,15), n2(5))
  call counter_SS_S(ntry, wf4(:,1), ex3(:), wf4(:,16), n3(:,62), t3x4(:,:,15))
  call counter_ST_V(ntry, wf4(:,2), 3, ex3(:), 4, wf4(:,17), n3(:,63), t3x4(:,:,16))
  call counter_SV_V(ntry, ex3(:), wf4(:,3), wf4(:,18), n3(:,64), t3x4(:,:,17))
  call counter_SV_V(ntry, ex3(:), wf4(:,4), wf4(:,19), n3(:,65), t3x4(:,:,18))
  call counter_TV_S(ntry, ex3(:), 4, ex5(:), 16, wf3(:,5), n3(:,66), t3x3(:,:,5))
  call counter_SV_V(ntry, ex3(:), ex5(:), wf3(:,6), n3(:,67), t3x3(:,:,6))
  call counter_TV_S(ntry, ex3(:), 4, ex4(:), 8, wf3(:,7), n3(:,68), t3x3(:,:,7))
  call counter_SV_V(ntry, ex3(:), ex4(:), wf3(:,8), n3(:,69), t3x3(:,:,8))
  call counter_WQ_A(ntry, ex5(:), wf2(:,2), wf6(:,7), n3(:,70), t3x6(:,:,5))
  call counter_WQ_A(ntry, ex4(:), wf6(:,5), wf18(:,2), n3(:,71), t3x18(:,:,2))
  call counter_QS_A(EWctHtt,ntry, wf6(:,5), ex3(:), wf6(:,8), n3(:,72), t3x6(:,:,6))
  call counter_AQ_S(EWctHbb,ntry, ex2(:), wf2(:,2), wf4(:,20), n3(:,73), t3x4(:,:,19))
  call counter_QA_V_LR(EWctAbb,ntry, wf2(:,2), ex2(:), wf4(:,21), n3(:,74), t3x4(:,:,20))
  call counter_QA_Z(EWctVbb,ntry, wf2(:,2), ex2(:), wf4(:,22), n3(:,75), t3x4(:,:,21))
  call counter_AW_Q(ntry, ex2(:), ex4(:), wf6(:,9), n3(:,76), t3x6(:,:,7))
  call prop_A_Q(ntry, wf6(:,9), 10, MT, 1_intkind1, wf6(:,10), n2(6))
  call counter_AQ_S(EWctPbt,ntry, ex2(:), wf6(:,5), wf12(:,33), n3(:,77), t3x12(:,:,33))
  call counter_QA_W(ntry, wf6(:,5), ex2(:), wf12(:,34), n3(:,78), t3x12(:,:,34))
  call vert_AQ_S(gPtb,ntry, wf6(:,10), ex1(:), wf12(:,35), n3(:,79), t3x12(:,:,35))
  call vert_QA_W(ntry, ex1(:), wf6(:,10), wf12(:,36), n3(:,80), t3x12(:,:,36))
  call counter_SA_Q(EWctHbb,ntry, ex3(:), ex2(:), wf2(:,5), n3(:,81), t3x2(:,:,3))
  call prop_A_Q(ntry, wf2(:,5), 6, MB, 1_intkind1, wf2(:,6), n2(7))
  call vert_AQ_S(gH,ntry, wf2(:,6), ex1(:), wf4(:,23), n3(:,82), t3x4(:,:,22))
  call vert_QA_V(ntry, ex1(:), wf2(:,6), wf4(:,24), n3(:,83), t3x4(:,:,23))
  call vert_QA_Z(gZd,ntry, ex1(:), wf2(:,6), wf4(:,25), n3(:,84), t3x4(:,:,24))
  call counter_AQ_S(EWctHbb,ntry, wf2(:,4), ex1(:), wf4(:,26), n3(:,85), t3x4(:,:,25))
  call counter_QA_V_LR(EWctAbb,ntry, ex1(:), wf2(:,4), wf4(:,27), n3(:,86), t3x4(:,:,26))
  call counter_QA_Z(EWctVbb,ntry, ex1(:), wf2(:,4), wf4(:,28), n3(:,87), t3x4(:,:,27))
  call counter_WQ_A(ntry, ex5(:), ex1(:), wf6(:,11), n3(:,88), t3x6(:,:,8))
  call prop_Q_A(ntry, wf6(:,11), 17, MT, 1_intkind1, wf6(:,12), n2(8))
  call vert_WQ_A(ntry, ex4(:), wf6(:,12), wf18(:,3), n3(:,89), t3x18(:,:,3))
  call counter_AQ_S(EWctPtb,ntry, wf6(:,2), ex1(:), wf12(:,37), n3(:,90), t3x12(:,:,37))
  call counter_QA_W(ntry, ex1(:), wf6(:,2), wf12(:,38), n3(:,91), t3x12(:,:,38))
  call vert_QS_A(gH,ntry, wf6(:,12), ex3(:), wf6(:,13), n3(:,92), t3x6(:,:,9))
  call vert_AQ_S(gPbt,ntry, ex2(:), wf6(:,12), wf12(:,39), n3(:,93), t3x12(:,:,39))
  call vert_QA_W(ntry, wf6(:,12), ex2(:), wf12(:,40), n3(:,94), t3x12(:,:,40))
  call counter_QS_A(EWctHbb,ntry, ex1(:), ex3(:), wf2(:,7), n3(:,95), t3x2(:,:,4))
  call prop_Q_A(ntry, wf2(:,7), 5, MB, 1_intkind1, wf2(:,8), n2(9))
  call vert_WQ_A(ntry, ex5(:), wf2(:,8), wf6(:,14), n3(:,96), t3x6(:,:,10))
  call vert_AQ_S(gH,ntry, ex2(:), wf2(:,8), wf4(:,29), n3(:,97), t3x4(:,:,28))
  call vert_QA_V(ntry, wf2(:,8), ex2(:), wf4(:,30), n3(:,98), t3x4(:,:,29))
  call vert_QA_Z(gZd,ntry, wf2(:,8), ex2(:), wf4(:,31), n3(:,99), t3x4(:,:,30))
  call vert_TV_S(ntry, wf4(:,14), 3, ex5(:), 16, wf12(:,41), n3(:,100), t3x12(:,:,41))
  call counter_AQ_S(EWctXbb,ntry, ex2(:), ex1(:), wf4(:,32), n3(:,101), t3x4(:,:,31))
  call vert_TV_S(ntry, wf4(:,32), 3, ex5(:), 16, wf12(:,42), n3(:,102), t3x12(:,:,42))
  call vert_SV_V(ntry, wf4(:,14), ex5(:), wf12(:,43), n3(:,103), t3x12(:,:,43))
  call counter_QA_V_LR(EWctAbb,ntry, ex1(:), ex2(:), wf4(:,33), n3(:,104), t3x4(:,:,32))
  call vert_VV_S(ntry, wf4(:,33), ex5(:), wf12(:,44), n3(:,105), t3x12(:,:,44))
  call counter_QA_Z(EWctVbb,ntry, ex1(:), ex2(:), wf4(:,34), n3(:,106), t3x4(:,:,33))
  call vert_VV_S(ntry, wf4(:,34), ex5(:), wf12(:,45), n3(:,107), t3x12(:,:,45))
  call vert_UV_W(ntry, wf4(:,33), 3, ex5(:), 16, wf12(:,46), n3(:,108), t3x12(:,:,46))
  call vert_UV_W(ntry, wf4(:,34), 3, ex5(:), 16, wf12(:,47), n3(:,109), t3x12(:,:,47))
  call vert_TV_S(ntry, wf4(:,14), 3, ex4(:), 8, wf12(:,48), n3(:,110), t3x12(:,:,48))
  call vert_TV_S(ntry, wf4(:,32), 3, ex4(:), 8, wf12(:,49), n3(:,111), t3x12(:,:,49))
  call vert_SV_V(ntry, wf4(:,14), ex4(:), wf12(:,50), n3(:,112), t3x12(:,:,50))
  call vert_VV_S(ntry, wf4(:,33), ex4(:), wf12(:,51), n3(:,113), t3x12(:,:,51))
  call vert_VV_S(ntry, wf4(:,34), ex4(:), wf12(:,52), n3(:,114), t3x12(:,:,52))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,33), 3, wf12(:,53), n3(:,115), t3x12(:,:,53))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,34), 3, wf12(:,54), n3(:,116), t3x12(:,:,54))
  call vert_SS_S(ntry, wf4(:,14), ex3(:), wf4(:,35), n3(:,117), t3x4(:,:,34))
  call vert_ST_V(ntry, wf4(:,32), 3, ex3(:), 4, wf4(:,36), n3(:,118), t3x4(:,:,35))
  call vert_SV_V(ntry, ex3(:), wf4(:,34), wf4(:,37), n3(:,119), t3x4(:,:,36))
  call vert_VS_T(ntry, ex5(:), 16, wf3(:,1), 12, wf9(:,7), n3(:,120), t3x9(:,:,5))
  call counter_S_S(EWctXX,ntry, wf4(:,2), 3, wf4(:,38), n2(10))
  call vert_VV_S(ntry, wf3(:,2), ex5(:), wf9(:,8), n3(:,121), t3x9(:,:,6))
  call vert_SV_V(ntry, wf3(:,1), ex5(:), wf9(:,9), n3(:,122), t3x9(:,:,7))
  call counter_S_V(EWctXA,ntry, wf4(:,2), 3, wf4(:,39), n2(11))
  call counter_S_V(EWctXZ,ntry, wf4(:,2), 3, wf4(:,40), n2(12))
  call vert_UV_W(ntry, ex5(:), 16, wf3(:,2), 12, wf9(:,10), n3(:,123), t3x9(:,:,8))
  call counter_V_S(EWctXA,ntry, wf4(:,3), 3, wf4(:,41), n2(13))
  call counter_V_S(EWctXZ,ntry, wf4(:,4), 3, wf4(:,42), n2(14))
  call counter_V_V(EWctAA,ntry, wf4(:,3), 3, wf4(:,43), n2(15))
  call counter_V_V(EWctAZ,ntry, wf4(:,3), 3, wf4(:,44), n2(16))
  call counter_V_V(EWctAZ,ntry, wf4(:,4), 3, wf4(:,45), n2(17))
  call counter_V_V(EWctZZ,ntry, wf4(:,4), 3, wf4(:,46), n2(18))
  call counter_S_S(EWctPP,ntry, wf3(:,1), 12, wf3(:,9), n2(19))
  call counter_S_V(EWctPW,ntry, wf3(:,1), 12, wf3(:,10), n2(20))
  call counter_V_S(EWctPW,ntry, wf3(:,2), 12, wf3(:,11), n2(21))
  call counter_V_V(EWctWW,ntry, wf3(:,2), 12, wf3(:,12), n2(22))
  call vert_VS_T(ntry, ex4(:), 8, wf3(:,3), 20, wf9(:,11), n3(:,124), t3x9(:,:,9))
  call vert_VV_S(ntry, ex4(:), wf3(:,4), wf9(:,12), n3(:,125), t3x9(:,:,10))
  call vert_SV_V(ntry, wf3(:,3), ex4(:), wf9(:,13), n3(:,126), t3x9(:,:,11))
  call vert_UV_W(ntry, wf3(:,4), 20, ex4(:), 8, wf9(:,14), n3(:,127), t3x9(:,:,12))
  call counter_S_S(EWctPP,ntry, wf3(:,3), 20, wf3(:,13), n2(23))
  call counter_S_V(EWctPW,ntry, wf3(:,3), 20, wf3(:,14), n2(24))
  call counter_V_S(EWctPW,ntry, wf3(:,4), 20, wf3(:,15), n2(25))
  call counter_V_V(EWctWW,ntry, wf3(:,4), 20, wf3(:,16), n2(26))
  call vert_SS_S(ntry, ex3(:), wf9(:,2), wf9(:,15), n3(:,128), t3x9(:,:,13))
  call vert_TV_S(ntry, ex3(:), 4, wf9(:,3), 24, wf9(:,16), n3(:,129), t3x9(:,:,14))
  call vert_SV_V(ntry, ex3(:), wf9(:,3), wf9(:,17), n3(:,130), t3x9(:,:,15))
  call counter_S_S(EWctHH,ntry, wf9(:,2), 24, wf9(:,18), n2(27))
  call vert_SS_S(ntry, wf4(:,2), ex3(:), wf4(:,47), n3(:,131), t3x4(:,:,37))
  call counter_V_S(EWctXA,ntry, wf9(:,3), 24, wf9(:,19), n2(28))
  call counter_V_S(EWctXZ,ntry, wf9(:,3), 24, wf9(:,20), n2(29))
  call vert_TV_S(ntry, ex3(:), 4, wf4(:,4), 3, wf4(:,48), n3(:,132), t3x4(:,:,38))
  call counter_V_V(EWctAZ,ntry, wf9(:,3), 24, wf9(:,21), n2(30))
  call counter_V_V(EWctZZ,ntry, wf9(:,3), 24, wf9(:,22), n2(31))
  call vert_AW_Q(ntry, wf6(:,2), ex5(:), wf18(:,4), n3(:,133), t3x18(:,:,4))
  call counter_Q_A_LR(EWctbb,ntry, wf2(:,2), 5, wf2(:,9), n2(32))
  call prop_A_Q(ntry, wf18(:,4), 26, MB, 1_intkind1, wf18(:,5), n2(33))
  call counter_A_Q_LR(EWcttt,ntry, wf6(:,2), 10, wf6(:,15), n2(34))
  call prop_Q_A(ntry, wf6(:,3), 21, MT, 1_intkind1, wf6(:,16), n2(35))
  call vert_SA_Q(gH,ntry, wf9(:,2), ex2(:), wf18(:,6), n3(:,134), t3x18(:,:,5))
  call prop_A_Q(ntry, wf18(:,6), 26, MB, 1_intkind1, wf18(:,7), n2(36))
  call vert_AV_Q(ntry, ex2(:), wf9(:,3), wf18(:,8), n3(:,135), t3x18(:,:,6))
  call prop_A_Q(ntry, wf18(:,8), 26, MB, 1_intkind1, wf18(:,9), n2(37))
  call vert_AZ_Q(gZd,ntry, ex2(:), wf9(:,3), wf18(:,10), n3(:,136), t3x18(:,:,7))
  call prop_A_Q(ntry, wf18(:,10), 26, MB, 1_intkind1, wf18(:,11), n2(38))
  call vert_AQ_S(gX,ntry, ex2(:), wf2(:,2), wf4(:,49), n3(:,137), t3x4(:,:,39))
  call counter_V_V(EWctAA,ntry, wf9(:,3), 24, wf9(:,23), n2(39))
  call vert_AW_Q(ntry, wf2(:,4), ex4(:), wf6(:,17), n3(:,138), t3x6(:,:,11))
  call counter_Q_A_LR(EWcttt,ntry, wf6(:,5), 17, wf6(:,18), n2(40))
  call prop_A_Q(ntry, wf6(:,17), 14, MT, 1_intkind1, wf6(:,19), n2(41))
  call counter_A_Q_LR(EWctbb,ntry, wf2(:,4), 6, wf2(:,10), n2(42))
  call prop_Q_A(ntry, wf18(:,1), 25, MB, 1_intkind1, wf18(:,12), n2(43))
  call vert_QS_A(gH,ntry, ex1(:), wf9(:,2), wf18(:,13), n3(:,139), t3x18(:,:,8))
  call prop_Q_A(ntry, wf18(:,13), 25, MB, 1_intkind1, wf18(:,14), n2(44))
  call vert_VQ_A(ntry, wf9(:,3), ex1(:), wf18(:,15), n3(:,140), t3x18(:,:,9))
  call prop_Q_A(ntry, wf18(:,15), 25, MB, 1_intkind1, wf18(:,16), n2(45))
  call vert_ZQ_A(gZd,ntry, wf9(:,3), ex1(:), wf18(:,17), n3(:,141), t3x18(:,:,10))
  call prop_Q_A(ntry, wf18(:,17), 25, MB, 1_intkind1, wf18(:,18), n2(46))
  call vert_AQ_S(gX,ntry, wf2(:,4), ex1(:), wf4(:,50), n3(:,142), t3x4(:,:,40))
  call vert_SA_Q(gH,ntry, ex3(:), wf6(:,2), wf6(:,20), n3(:,143), t3x6(:,:,12))
  call prop_A_Q(ntry, wf6(:,20), 14, MT, 1_intkind1, wf6(:,21), n2(47))
  call prop_Q_A(ntry, wf6(:,6), 21, MT, 1_intkind1, wf6(:,22), n2(48))
  call vert_QS_A(gPtb,ntry, ex1(:), wf3(:,3), wf6(:,23), n3(:,144), t3x6(:,:,13))
  call prop_Q_A(ntry, wf6(:,23), 21, MT, 1_intkind1, wf6(:,24), n2(49))
  call vert_WQ_A(ntry, wf3(:,4), ex1(:), wf6(:,25), n3(:,145), t3x6(:,:,14))
  call prop_Q_A(ntry, wf6(:,25), 21, MT, 1_intkind1, wf6(:,26), n2(50))
  call vert_SA_Q(gPbt,ntry, wf3(:,1), ex2(:), wf6(:,27), n3(:,146), t3x6(:,:,15))
  call prop_A_Q(ntry, wf6(:,27), 14, MT, 1_intkind1, wf6(:,28), n2(51))
  call vert_AW_Q(ntry, ex2(:), wf3(:,2), wf6(:,29), n3(:,147), t3x6(:,:,16))
  call prop_A_Q(ntry, wf6(:,29), 14, MT, 1_intkind1, wf6(:,30), n2(52))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    if (do_ct) call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  if (do_ct) M2ct = 0
  if (do_colint) M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    if (do_ct) call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      if (do_colint) call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    if (do_ct) M2ct = M2ct + M2add_ct
    if (do_colint) M2colint = M2colint + M2add_colint
  end do

#if 1 > 0 && 5 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    ind_cc_comb = [2,4,7,5,8]
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 5
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2

  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 3
do i4= 1, 3
do i3= 1, 1
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_SS(nsync, wf4(:,1), wf9(:,1), A(:,1), n3(:,148), t3x36(:,:,1), nhel, den(1))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,1), A(:,2), n3(:,149), t3x36(:,:,2), nhel, den(3))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,2), A(:,3), n3(:,150), t3x36(:,:,3), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,3), A(:,4), n3(:,151), t3x36(:,:,4), nhel, den(3))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,4), A(:,5), n3(:,152), t3x36(:,:,5), nhel, den(7))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,5), A(:,6), n3(:,153), t3x36(:,:,6), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,6), A(:,7), n3(:,154), t3x36(:,:,7), nhel, den(7))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,7), A(:,8), n3(:,155), t3x36(:,:,8), nhel, den(5))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,8), A(:,9), n3(:,156), t3x36(:,:,9), nhel, den(9))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,9), A(:,10), n3(:,157), t3x36(:,:,10), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,10), A(:,11), n3(:,158), t3x36(:,:,11), nhel, den(9))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,11), A(:,12), n3(:,159), t3x36(:,:,12), nhel, den(11))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,12), A(:,13), n3(:,160), t3x36(:,:,13), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,13), A(:,14), n3(:,161), t3x36(:,:,14), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,14), A(:,15), n3(:,162), t3x36(:,:,15), nhel, den(10))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,5), A(:,16), n3(:,163), t3x36(:,:,16), nhel, den(13))
    call Hcont_VV(nsync, wf9(:,3), wf4(:,6), A(:,17), n3(:,164), t3x36(:,:,17), nhel, den(15))
    call Hcont_VV(nsync, wf9(:,3), wf4(:,7), A(:,18), n3(:,165), t3x36(:,:,18), nhel, den(15))
    call Hcont_QA(nsync, wf6(:,2), wf6(:,3), A(:,19), n3(:,166), t3x36(:,:,19), nhel, den(18))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,8), A(:,20), n3(:,167), t3x36(:,:,20), nhel, den(19))
    call Hcont_VV(nsync, wf9(:,3), wf4(:,9), A(:,21), n3(:,168), t3x36(:,:,21), nhel, den(21))
    call Hcont_VV(nsync, wf9(:,3), wf4(:,10), A(:,22), n3(:,169), t3x36(:,:,22), nhel, den(22))
    call Hcont_QA(nsync, wf2(:,4), wf18(:,1), A(:,23), n3(:,170), t3x36(:,:,23), nhel, den(25))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,11), A(:,24), n3(:,171), t3x36(:,:,24), nhel, den(26))
    call Hcont_VV(nsync, wf9(:,3), wf4(:,12), A(:,25), n3(:,172), t3x36(:,:,25), nhel, den(27))
    call Hcont_VV(nsync, wf9(:,3), wf4(:,13), A(:,26), n3(:,173), t3x36(:,:,26), nhel, den(28))
    call Hcont_QA(nsync, wf6(:,2), wf6(:,6), A(:,27), n3(:,174), t3x36(:,:,27), nhel, den(29))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,15), A(:,28), n3(:,175), t3x36(:,:,28), nhel, den(30))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,16), A(:,29), n3(:,176), t3x36(:,:,29), nhel, den(30))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,17), A(:,30), n3(:,177), t3x36(:,:,30), nhel, den(31))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,18), A(:,31), n3(:,178), t3x36(:,:,31), nhel, den(31))

    call Hcont_SS(nsync, wf4(:,1), wf9(:,4), A(:,32), n3(:,179), t3x36(:,:,32), nhel, den(1))
    call Hcont_SS(nsync, wf9(:,1), wf4(:,14), A(:,33), n3(:,180), t3x36(:,:,33), nhel, den(32))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,19), A(:,34), n3(:,181), t3x36(:,:,34), nhel, den(3))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,20), A(:,35), n3(:,182), t3x36(:,:,35), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,21), A(:,36), n3(:,183), t3x36(:,:,36), nhel, den(3))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,22), A(:,37), n3(:,184), t3x36(:,:,37), nhel, den(7))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,23), A(:,38), n3(:,185), t3x36(:,:,38), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,24), A(:,39), n3(:,186), t3x36(:,:,39), nhel, den(7))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,25), A(:,40), n3(:,187), t3x36(:,:,40), nhel, den(5))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,26), A(:,41), n3(:,188), t3x36(:,:,41), nhel, den(9))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,27), A(:,42), n3(:,189), t3x36(:,:,42), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,28), A(:,43), n3(:,190), t3x36(:,:,43), nhel, den(9))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,29), A(:,44), n3(:,191), t3x36(:,:,44), nhel, den(11))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,30), A(:,45), n3(:,192), t3x36(:,:,45), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,31), A(:,46), n3(:,193), t3x36(:,:,46), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,32), A(:,47), n3(:,194), t3x36(:,:,47), nhel, den(10))
    call Hcont_SS(nsync, wf4(:,5), wf9(:,5), A(:,48), n3(:,195), t3x36(:,:,48), nhel, den(13))
    call Hcont_VV(nsync, wf4(:,6), wf9(:,6), A(:,49), n3(:,196), t3x36(:,:,49), nhel, den(15))
    call Hcont_VV(nsync, wf4(:,7), wf9(:,6), A(:,50), n3(:,197), t3x36(:,:,50), nhel, den(15))
    call Hcont_SS(nsync, wf9(:,1), wf4(:,15), A(:,51), n3(:,198), t3x36(:,:,51), nhel, den(33))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,16), A(:,52), n3(:,199), t3x36(:,:,52), nhel, den(13))
    call Hcont_VV(nsync, wf9(:,3), wf4(:,17), A(:,53), n3(:,200), t3x36(:,:,53), nhel, den(34))
    call Hcont_VV(nsync, wf9(:,3), wf4(:,17), A(:,54), n3(:,201), t3x36(:,:,54), nhel, den(15))
    call Hcont_VV(nsync, wf9(:,3), wf4(:,18), A(:,55), n3(:,202), t3x36(:,:,55), nhel, den(35))
    call Hcont_VV(nsync, wf9(:,3), wf4(:,18), A(:,56), n3(:,203), t3x36(:,:,56), nhel, den(36))
    call Hcont_VV(nsync, wf9(:,3), wf4(:,19), A(:,57), n3(:,204), t3x36(:,:,57), nhel, den(34))
    call Hcont_VV(nsync, wf9(:,3), wf4(:,19), A(:,58), n3(:,205), t3x36(:,:,58), nhel, den(15))
    call Hcont_SS(nsync, wf12(:,8), wf3(:,5), A(:,59), n3(:,206), t3x36(:,:,59), nhel, den(9))
    call Hcont_SS(nsync, wf12(:,9), wf3(:,5), A(:,60), n3(:,207), t3x36(:,:,60), nhel, den(10))
    call Hcont_VV(nsync, wf12(:,10), wf3(:,6), A(:,61), n3(:,208), t3x36(:,:,61), nhel, den(9))
    call Hcont_SS(nsync, wf12(:,11), wf3(:,5), A(:,62), n3(:,209), t3x36(:,:,62), nhel, den(11))
    call Hcont_SS(nsync, wf12(:,12), wf3(:,5), A(:,63), n3(:,210), t3x36(:,:,63), nhel, den(10))
    call Hcont_VV(nsync, wf12(:,13), wf3(:,6), A(:,64), n3(:,211), t3x36(:,:,64), nhel, den(11))
    call Hcont_VV(nsync, wf12(:,14), wf3(:,6), A(:,65), n3(:,212), t3x36(:,:,65), nhel, den(10))
    call Hcont_SS(nsync, wf12(:,1), wf3(:,7), A(:,66), n3(:,213), t3x36(:,:,66), nhel, den(3))
    call Hcont_SS(nsync, wf12(:,2), wf3(:,7), A(:,67), n3(:,214), t3x36(:,:,67), nhel, den(5))
    call Hcont_VV(nsync, wf12(:,3), wf3(:,8), A(:,68), n3(:,215), t3x36(:,:,68), nhel, den(3))
    call Hcont_SS(nsync, wf12(:,4), wf3(:,7), A(:,69), n3(:,216), t3x36(:,:,69), nhel, den(7))
    call Hcont_SS(nsync, wf12(:,5), wf3(:,7), A(:,70), n3(:,217), t3x36(:,:,70), nhel, den(5))
    call Hcont_VV(nsync, wf12(:,6), wf3(:,8), A(:,71), n3(:,218), t3x36(:,:,71), nhel, den(7))
    call Hcont_VV(nsync, wf12(:,7), wf3(:,8), A(:,72), n3(:,219), t3x36(:,:,72), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,2), wf6(:,7), A(:,73), n3(:,220), t3x36(:,:,73), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,8), wf9(:,5), A(:,74), n3(:,221), t3x36(:,:,74), nhel, den(19))
    call Hcont_VV(nsync, wf4(:,9), wf9(:,6), A(:,75), n3(:,222), t3x36(:,:,75), nhel, den(21))
    call Hcont_VV(nsync, wf4(:,10), wf9(:,6), A(:,76), n3(:,223), t3x36(:,:,76), nhel, den(22))
    call Hcont_QA(nsync, wf2(:,4), wf18(:,2), A(:,77), n3(:,224), t3x36(:,:,77), nhel, den(25))
    call Hcont_SS(nsync, wf4(:,11), wf9(:,5), A(:,78), n3(:,225), t3x36(:,:,78), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,12), wf9(:,6), A(:,79), n3(:,226), t3x36(:,:,79), nhel, den(27))
    call Hcont_VV(nsync, wf4(:,13), wf9(:,6), A(:,80), n3(:,227), t3x36(:,:,80), nhel, den(28))
    call Hcont_QA(nsync, wf6(:,2), wf6(:,8), A(:,81), n3(:,228), t3x36(:,:,81), nhel, den(29))
    call Hcont_SS(nsync, wf12(:,15), wf3(:,5), A(:,82), n3(:,229), t3x36(:,:,82), nhel, den(30))
    call Hcont_VV(nsync, wf12(:,16), wf3(:,6), A(:,83), n3(:,230), t3x36(:,:,83), nhel, den(30))
    call Hcont_SS(nsync, wf12(:,17), wf3(:,7), A(:,84), n3(:,231), t3x36(:,:,84), nhel, den(31))
    call Hcont_VV(nsync, wf12(:,18), wf3(:,8), A(:,85), n3(:,232), t3x36(:,:,85), nhel, den(31))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,20), A(:,86), n3(:,233), t3x36(:,:,86), nhel, den(19))
    call Hcont_VV(nsync, wf9(:,3), wf4(:,21), A(:,87), n3(:,234), t3x36(:,:,87), nhel, den(21))
    call Hcont_VV(nsync, wf9(:,3), wf4(:,22), A(:,88), n3(:,235), t3x36(:,:,88), nhel, den(22))
    call Hcont_QA(nsync, wf6(:,3), wf6(:,10), A(:,89), n3(:,236), t3x36(:,:,89), nhel, den(18))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,33), A(:,90), n3(:,237), t3x36(:,:,90), nhel, den(31))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,34), A(:,91), n3(:,238), t3x36(:,:,91), nhel, den(31))
    call Hcont_QA(nsync, wf6(:,6), wf6(:,10), A(:,92), n3(:,239), t3x36(:,:,92), nhel, den(29))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,35), A(:,93), n3(:,240), t3x36(:,:,93), nhel, den(30))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,36), A(:,94), n3(:,241), t3x36(:,:,94), nhel, den(30))
    call Hcont_QA(nsync, wf18(:,1), wf2(:,6), A(:,95), n3(:,242), t3x36(:,:,95), nhel, den(25))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,23), A(:,96), n3(:,243), t3x36(:,:,96), nhel, den(26))
    call Hcont_VV(nsync, wf9(:,3), wf4(:,24), A(:,97), n3(:,244), t3x36(:,:,97), nhel, den(27))
    call Hcont_VV(nsync, wf9(:,3), wf4(:,25), A(:,98), n3(:,245), t3x36(:,:,98), nhel, den(28))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,26), A(:,99), n3(:,246), t3x36(:,:,99), nhel, den(26))
    call Hcont_VV(nsync, wf9(:,3), wf4(:,27), A(:,100), n3(:,247), t3x36(:,:,100), nhel, den(27))
    call Hcont_VV(nsync, wf9(:,3), wf4(:,28), A(:,101), n3(:,248), t3x36(:,:,101), nhel, den(28))
    call Hcont_QA(nsync, wf2(:,4), wf18(:,3), A(:,102), n3(:,249), t3x36(:,:,102), nhel, den(25))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,37), A(:,103), n3(:,250), t3x36(:,:,103), nhel, den(30))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,38), A(:,104), n3(:,251), t3x36(:,:,104), nhel, den(30))
    call Hcont_QA(nsync, wf6(:,2), wf6(:,13), A(:,105), n3(:,252), t3x36(:,:,105), nhel, den(29))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,39), A(:,106), n3(:,253), t3x36(:,:,106), nhel, den(31))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,40), A(:,107), n3(:,254), t3x36(:,:,107), nhel, den(31))
    call Hcont_QA(nsync, wf6(:,2), wf6(:,14), A(:,108), n3(:,255), t3x36(:,:,108), nhel, den(18))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,29), A(:,109), n3(:,256), t3x36(:,:,109), nhel, den(19))
    call Hcont_VV(nsync, wf9(:,3), wf4(:,30), A(:,110), n3(:,257), t3x36(:,:,110), nhel, den(21))
    call Hcont_VV(nsync, wf9(:,3), wf4(:,31), A(:,111), n3(:,258), t3x36(:,:,111), nhel, den(22))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,41), A(:,112), n3(:,259), t3x36(:,:,112), nhel, den(3))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,42), A(:,113), n3(:,260), t3x36(:,:,113), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,43), A(:,114), n3(:,261), t3x36(:,:,114), nhel, den(3))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,44), A(:,115), n3(:,262), t3x36(:,:,115), nhel, den(7))
    call Hcont_SS(nsync, wf3(:,1), wf12(:,45), A(:,116), n3(:,263), t3x36(:,:,116), nhel, den(5))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,46), A(:,117), n3(:,264), t3x36(:,:,117), nhel, den(7))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,47), A(:,118), n3(:,265), t3x36(:,:,118), nhel, den(5))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,48), A(:,119), n3(:,266), t3x36(:,:,119), nhel, den(9))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,49), A(:,120), n3(:,267), t3x36(:,:,120), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,50), A(:,121), n3(:,268), t3x36(:,:,121), nhel, den(9))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,51), A(:,122), n3(:,269), t3x36(:,:,122), nhel, den(11))
    call Hcont_SS(nsync, wf3(:,3), wf12(:,52), A(:,123), n3(:,270), t3x36(:,:,123), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,53), A(:,124), n3(:,271), t3x36(:,:,124), nhel, den(11))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,54), A(:,125), n3(:,272), t3x36(:,:,125), nhel, den(10))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,35), A(:,126), n3(:,273), t3x36(:,:,126), nhel, den(13))
    call Hcont_VV(nsync, wf9(:,3), wf4(:,36), A(:,127), n3(:,274), t3x36(:,:,127), nhel, den(15))
    call Hcont_VV(nsync, wf9(:,3), wf4(:,37), A(:,128), n3(:,275), t3x36(:,:,128), nhel, den(15))
    call Hcont_SS(nsync, wf4(:,15), wf9(:,7), A(:,129), n3(:,276), t3x36(:,:,129), nhel, den(38))
    call Hcont_SS(nsync, wf9(:,7), wf4(:,38), A(:,130), n3(:,277), t3x36(:,:,130), nhel, den(41))
    call Hcont_SS(nsync, wf4(:,15), wf9(:,8), A(:,131), n3(:,278), t3x36(:,:,131), nhel, den(38))
    call Hcont_VV(nsync, wf9(:,9), wf4(:,39), A(:,132), n3(:,279), t3x36(:,:,132), nhel, den(44))
    call Hcont_VV(nsync, wf9(:,9), wf4(:,40), A(:,133), n3(:,280), t3x36(:,:,133), nhel, den(41))
    call Hcont_VV(nsync, wf4(:,39), wf9(:,10), A(:,134), n3(:,281), t3x36(:,:,134), nhel, den(44))
    call Hcont_VV(nsync, wf4(:,40), wf9(:,10), A(:,135), n3(:,282), t3x36(:,:,135), nhel, den(41))
    call Hcont_SS(nsync, wf9(:,7), wf4(:,41), A(:,136), n3(:,283), t3x36(:,:,136), nhel, den(45))
    call Hcont_SS(nsync, wf9(:,7), wf4(:,42), A(:,137), n3(:,284), t3x36(:,:,137), nhel, den(41))
    call Hcont_VV(nsync, wf9(:,9), wf4(:,43), A(:,138), n3(:,285), t3x36(:,:,138), nhel, den(46))
    call Hcont_VV(nsync, wf9(:,9), wf4(:,44), A(:,139), n3(:,286), t3x36(:,:,139), nhel, den(45))
    call Hcont_VV(nsync, wf9(:,9), wf4(:,45), A(:,140), n3(:,287), t3x36(:,:,140), nhel, den(44))
    call Hcont_VV(nsync, wf9(:,9), wf4(:,46), A(:,141), n3(:,288), t3x36(:,:,141), nhel, den(41))
    call Hcont_VV(nsync, wf9(:,10), wf4(:,43), A(:,142), n3(:,289), t3x36(:,:,142), nhel, den(46))
    call Hcont_VV(nsync, wf9(:,10), wf4(:,44), A(:,143), n3(:,290), t3x36(:,:,143), nhel, den(45))
    call Hcont_VV(nsync, wf9(:,10), wf4(:,45), A(:,144), n3(:,291), t3x36(:,:,144), nhel, den(44))
    call Hcont_VV(nsync, wf9(:,10), wf4(:,46), A(:,145), n3(:,292), t3x36(:,:,145), nhel, den(41))
    call Hcont_SS(nsync, wf12(:,1), wf3(:,9), A(:,146), n3(:,293), t3x36(:,:,146), nhel, den(49))
    call Hcont_SS(nsync, wf12(:,2), wf3(:,9), A(:,147), n3(:,294), t3x36(:,:,147), nhel, den(51))
    call Hcont_SS(nsync, wf12(:,4), wf3(:,9), A(:,148), n3(:,295), t3x36(:,:,148), nhel, den(53))
    call Hcont_SS(nsync, wf12(:,5), wf3(:,9), A(:,149), n3(:,296), t3x36(:,:,149), nhel, den(51))
    call Hcont_VV(nsync, wf12(:,3), wf3(:,10), A(:,150), n3(:,297), t3x36(:,:,150), nhel, den(49))
    call Hcont_VV(nsync, wf12(:,6), wf3(:,10), A(:,151), n3(:,298), t3x36(:,:,151), nhel, den(53))
    call Hcont_VV(nsync, wf12(:,7), wf3(:,10), A(:,152), n3(:,299), t3x36(:,:,152), nhel, den(51))
    call Hcont_SS(nsync, wf12(:,1), wf3(:,11), A(:,153), n3(:,300), t3x36(:,:,153), nhel, den(49))
    call Hcont_SS(nsync, wf12(:,2), wf3(:,11), A(:,154), n3(:,301), t3x36(:,:,154), nhel, den(51))
    call Hcont_SS(nsync, wf12(:,4), wf3(:,11), A(:,155), n3(:,302), t3x36(:,:,155), nhel, den(53))
    call Hcont_SS(nsync, wf12(:,5), wf3(:,11), A(:,156), n3(:,303), t3x36(:,:,156), nhel, den(51))
    call Hcont_VV(nsync, wf12(:,3), wf3(:,12), A(:,157), n3(:,304), t3x36(:,:,157), nhel, den(49))
    call Hcont_VV(nsync, wf12(:,6), wf3(:,12), A(:,158), n3(:,305), t3x36(:,:,158), nhel, den(53))
    call Hcont_VV(nsync, wf12(:,7), wf3(:,12), A(:,159), n3(:,306), t3x36(:,:,159), nhel, den(51))
    call Hcont_SS(nsync, wf4(:,15), wf9(:,11), A(:,160), n3(:,307), t3x36(:,:,160), nhel, den(55))
    call Hcont_SS(nsync, wf4(:,38), wf9(:,11), A(:,161), n3(:,308), t3x36(:,:,161), nhel, den(57))
    call Hcont_SS(nsync, wf4(:,15), wf9(:,12), A(:,162), n3(:,309), t3x36(:,:,162), nhel, den(55))
    call Hcont_VV(nsync, wf4(:,39), wf9(:,13), A(:,163), n3(:,310), t3x36(:,:,163), nhel, den(59))
    call Hcont_VV(nsync, wf4(:,40), wf9(:,13), A(:,164), n3(:,311), t3x36(:,:,164), nhel, den(57))
    call Hcont_VV(nsync, wf4(:,39), wf9(:,14), A(:,165), n3(:,312), t3x36(:,:,165), nhel, den(59))
    call Hcont_VV(nsync, wf4(:,40), wf9(:,14), A(:,166), n3(:,313), t3x36(:,:,166), nhel, den(57))
    call Hcont_SS(nsync, wf4(:,41), wf9(:,11), A(:,167), n3(:,314), t3x36(:,:,167), nhel, den(60))
    call Hcont_SS(nsync, wf4(:,42), wf9(:,11), A(:,168), n3(:,315), t3x36(:,:,168), nhel, den(57))
    call Hcont_VV(nsync, wf4(:,43), wf9(:,13), A(:,169), n3(:,316), t3x36(:,:,169), nhel, den(61))
    call Hcont_VV(nsync, wf4(:,44), wf9(:,13), A(:,170), n3(:,317), t3x36(:,:,170), nhel, den(60))
    call Hcont_VV(nsync, wf4(:,45), wf9(:,13), A(:,171), n3(:,318), t3x36(:,:,171), nhel, den(59))
    call Hcont_VV(nsync, wf4(:,46), wf9(:,13), A(:,172), n3(:,319), t3x36(:,:,172), nhel, den(57))
    call Hcont_VV(nsync, wf4(:,43), wf9(:,14), A(:,173), n3(:,320), t3x36(:,:,173), nhel, den(61))
    call Hcont_VV(nsync, wf4(:,44), wf9(:,14), A(:,174), n3(:,321), t3x36(:,:,174), nhel, den(60))
    call Hcont_VV(nsync, wf4(:,45), wf9(:,14), A(:,175), n3(:,322), t3x36(:,:,175), nhel, den(59))
    call Hcont_VV(nsync, wf4(:,46), wf9(:,14), A(:,176), n3(:,323), t3x36(:,:,176), nhel, den(57))
    call Hcont_SS(nsync, wf12(:,8), wf3(:,13), A(:,177), n3(:,324), t3x36(:,:,177), nhel, den(64))
    call Hcont_SS(nsync, wf12(:,9), wf3(:,13), A(:,178), n3(:,325), t3x36(:,:,178), nhel, den(66))
    call Hcont_SS(nsync, wf12(:,11), wf3(:,13), A(:,179), n3(:,326), t3x36(:,:,179), nhel, den(68))
    call Hcont_SS(nsync, wf12(:,12), wf3(:,13), A(:,180), n3(:,327), t3x36(:,:,180), nhel, den(66))
    call Hcont_VV(nsync, wf12(:,10), wf3(:,14), A(:,181), n3(:,328), t3x36(:,:,181), nhel, den(64))
    call Hcont_VV(nsync, wf12(:,13), wf3(:,14), A(:,182), n3(:,329), t3x36(:,:,182), nhel, den(68))
    call Hcont_VV(nsync, wf12(:,14), wf3(:,14), A(:,183), n3(:,330), t3x36(:,:,183), nhel, den(66))
    call Hcont_SS(nsync, wf12(:,8), wf3(:,15), A(:,184), n3(:,331), t3x36(:,:,184), nhel, den(64))
    call Hcont_SS(nsync, wf12(:,9), wf3(:,15), A(:,185), n3(:,332), t3x36(:,:,185), nhel, den(66))
    call Hcont_SS(nsync, wf12(:,11), wf3(:,15), A(:,186), n3(:,333), t3x36(:,:,186), nhel, den(68))
    call Hcont_SS(nsync, wf12(:,12), wf3(:,15), A(:,187), n3(:,334), t3x36(:,:,187), nhel, den(66))
    call Hcont_VV(nsync, wf12(:,10), wf3(:,16), A(:,188), n3(:,335), t3x36(:,:,188), nhel, den(64))
    call Hcont_VV(nsync, wf12(:,13), wf3(:,16), A(:,189), n3(:,336), t3x36(:,:,189), nhel, den(68))
    call Hcont_VV(nsync, wf12(:,14), wf3(:,16), A(:,190), n3(:,337), t3x36(:,:,190), nhel, den(66))
    call Hcont_SS(nsync, wf4(:,15), wf9(:,15), A(:,191), n3(:,338), t3x36(:,:,191), nhel, den(70))
    call Hcont_SS(nsync, wf4(:,38), wf9(:,16), A(:,192), n3(:,339), t3x36(:,:,192), nhel, den(72))
    call Hcont_VV(nsync, wf4(:,40), wf9(:,17), A(:,193), n3(:,340), t3x36(:,:,193), nhel, den(72))
    call Hcont_SS(nsync, wf4(:,41), wf9(:,16), A(:,194), n3(:,341), t3x36(:,:,194), nhel, den(73))
    call Hcont_SS(nsync, wf4(:,42), wf9(:,16), A(:,195), n3(:,342), t3x36(:,:,195), nhel, den(72))
    call Hcont_VV(nsync, wf4(:,44), wf9(:,17), A(:,196), n3(:,343), t3x36(:,:,196), nhel, den(73))
    call Hcont_VV(nsync, wf4(:,46), wf9(:,17), A(:,197), n3(:,344), t3x36(:,:,197), nhel, den(72))
    call Hcont_SS(nsync, wf4(:,5), wf9(:,18), A(:,198), n3(:,345), t3x36(:,:,198), nhel, den(76))
    call Hcont_SS(nsync, wf4(:,47), wf9(:,19), A(:,199), n3(:,346), t3x36(:,:,199), nhel, den(79))
    call Hcont_SS(nsync, wf4(:,47), wf9(:,20), A(:,200), n3(:,347), t3x36(:,:,200), nhel, den(80))
    call Hcont_SS(nsync, wf9(:,19), wf4(:,48), A(:,201), n3(:,348), t3x36(:,:,201), nhel, den(79))
    call Hcont_SS(nsync, wf9(:,20), wf4(:,48), A(:,202), n3(:,349), t3x36(:,:,202), nhel, den(80))
    call Hcont_VV(nsync, wf4(:,6), wf9(:,21), A(:,203), n3(:,350), t3x36(:,:,203), nhel, den(79))
    call Hcont_VV(nsync, wf4(:,6), wf9(:,22), A(:,204), n3(:,351), t3x36(:,:,204), nhel, den(80))
    call Hcont_VV(nsync, wf4(:,7), wf9(:,21), A(:,205), n3(:,352), t3x36(:,:,205), nhel, den(79))
    call Hcont_VV(nsync, wf4(:,7), wf9(:,22), A(:,206), n3(:,353), t3x36(:,:,206), nhel, den(80))
    call Hcont_QA(nsync, wf2(:,9), wf18(:,5), A(:,207), n3(:,354), t3x36(:,:,207), nhel, den(83))
    call Hcont_QA(nsync, wf6(:,15), wf6(:,16), A(:,208), n3(:,355), t3x36(:,:,208), nhel, den(86))
    call Hcont_QA(nsync, wf2(:,9), wf18(:,7), A(:,209), n3(:,356), t3x36(:,:,209), nhel, den(88))
    call Hcont_QA(nsync, wf2(:,9), wf18(:,9), A(:,210), n3(:,357), t3x36(:,:,210), nhel, den(90))
    call Hcont_QA(nsync, wf2(:,9), wf18(:,11), A(:,211), n3(:,358), t3x36(:,:,211), nhel, den(92))
    call Hcont_SS(nsync, wf4(:,8), wf9(:,18), A(:,212), n3(:,359), t3x36(:,:,212), nhel, den(94))
    call Hcont_SS(nsync, wf9(:,19), wf4(:,49), A(:,213), n3(:,360), t3x36(:,:,213), nhel, den(96))
    call Hcont_SS(nsync, wf9(:,20), wf4(:,49), A(:,214), n3(:,361), t3x36(:,:,214), nhel, den(97))
    call Hcont_VV(nsync, wf4(:,9), wf9(:,23), A(:,215), n3(:,362), t3x36(:,:,215), nhel, den(100))
    call Hcont_VV(nsync, wf4(:,9), wf9(:,21), A(:,216), n3(:,363), t3x36(:,:,216), nhel, den(101))
    call Hcont_VV(nsync, wf4(:,10), wf9(:,21), A(:,217), n3(:,364), t3x36(:,:,217), nhel, den(96))
    call Hcont_VV(nsync, wf4(:,10), wf9(:,22), A(:,218), n3(:,365), t3x36(:,:,218), nhel, den(97))
    call Hcont_QA(nsync, wf6(:,18), wf6(:,19), A(:,219), n3(:,366), t3x36(:,:,219), nhel, den(104))
    call Hcont_QA(nsync, wf2(:,10), wf18(:,12), A(:,220), n3(:,367), t3x36(:,:,220), nhel, den(107))
    call Hcont_QA(nsync, wf2(:,10), wf18(:,14), A(:,221), n3(:,368), t3x36(:,:,221), nhel, den(109))
    call Hcont_QA(nsync, wf2(:,10), wf18(:,16), A(:,222), n3(:,369), t3x36(:,:,222), nhel, den(111))
    call Hcont_QA(nsync, wf2(:,10), wf18(:,18), A(:,223), n3(:,370), t3x36(:,:,223), nhel, den(113))
    call Hcont_SS(nsync, wf4(:,11), wf9(:,18), A(:,224), n3(:,371), t3x36(:,:,224), nhel, den(115))
    call Hcont_SS(nsync, wf9(:,19), wf4(:,50), A(:,225), n3(:,372), t3x36(:,:,225), nhel, den(117))
    call Hcont_SS(nsync, wf9(:,20), wf4(:,50), A(:,226), n3(:,373), t3x36(:,:,226), nhel, den(118))
    call Hcont_VV(nsync, wf4(:,12), wf9(:,23), A(:,227), n3(:,374), t3x36(:,:,227), nhel, den(120))
    call Hcont_VV(nsync, wf4(:,12), wf9(:,21), A(:,228), n3(:,375), t3x36(:,:,228), nhel, den(121))
    call Hcont_VV(nsync, wf4(:,13), wf9(:,21), A(:,229), n3(:,376), t3x36(:,:,229), nhel, den(117))
    call Hcont_VV(nsync, wf4(:,13), wf9(:,22), A(:,230), n3(:,377), t3x36(:,:,230), nhel, den(118))
    call Hcont_QA(nsync, wf6(:,18), wf6(:,21), A(:,231), n3(:,378), t3x36(:,:,231), nhel, den(123))
    call Hcont_QA(nsync, wf6(:,15), wf6(:,22), A(:,232), n3(:,379), t3x36(:,:,232), nhel, den(125))
    call Hcont_QA(nsync, wf6(:,15), wf6(:,24), A(:,233), n3(:,380), t3x36(:,:,233), nhel, den(127))
    call Hcont_QA(nsync, wf6(:,15), wf6(:,26), A(:,234), n3(:,381), t3x36(:,:,234), nhel, den(127))
    call Hcont_SS(nsync, wf12(:,15), wf3(:,13), A(:,235), n3(:,382), t3x36(:,:,235), nhel, den(129))
    call Hcont_SS(nsync, wf12(:,15), wf3(:,15), A(:,236), n3(:,383), t3x36(:,:,236), nhel, den(129))
    call Hcont_VV(nsync, wf12(:,16), wf3(:,14), A(:,237), n3(:,384), t3x36(:,:,237), nhel, den(129))
    call Hcont_VV(nsync, wf12(:,16), wf3(:,16), A(:,238), n3(:,385), t3x36(:,:,238), nhel, den(129))
    call Hcont_QA(nsync, wf6(:,18), wf6(:,28), A(:,239), n3(:,386), t3x36(:,:,239), nhel, den(131))
    call Hcont_QA(nsync, wf6(:,18), wf6(:,30), A(:,240), n3(:,387), t3x36(:,:,240), nhel, den(131))
    call Hcont_SS(nsync, wf12(:,17), wf3(:,9), A(:,241), n3(:,388), t3x36(:,:,241), nhel, den(133))
    call Hcont_SS(nsync, wf12(:,17), wf3(:,11), A(:,242), n3(:,389), t3x36(:,:,242), nhel, den(133))
    call Hcont_VV(nsync, wf12(:,18), wf3(:,10), A(:,243), n3(:,390), t3x36(:,:,243), nhel, den(133))
    call Hcont_VV(nsync, wf12(:,18), wf3(:,12), A(:,244), n3(:,391), t3x36(:,:,244), nhel, den(133))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(1) ! M1helarray(1,nhel)
  integer :: empty(0), i

  M1(1)%j = (-A(j,6)%j+A(j,13)%j)*f(5)+(A(j,28)%j+A(j,30)%j)*f(17)+(-A(j,2)%j-A(j,3)%j-A(j,9)%j+A(j,10)%j)*f(21)+(-A(j,1)%j &
       -A(j,17)%j+A(j,19)%j+A(j,23)%j)*f(22)+(-A(j,20)%j-A(j,24)%j)*f(27)-A(j,16)%j*f(30)+A(j,27)%j*f(32)+(A(j,29)%j &
       +A(j,31)%j)*f(36)+(-A(j,4)%j-A(j,11)%j)*f(40)+(A(j,22)%j+A(j,26)%j)*f(56)+A(j,18)%j*f(71)+(A(j,8)%j+A(j,15)%j)*f(72)+( &
       -A(j,21)%j-A(j,25)%j)*f(87)+(-A(j,5)%j+A(j,12)%j)*f(95)+(-A(j,7)%j-A(j,14)%j)*f(96)

  M2(1)%j = -(A(j,55)%j*f(1))+(-A(j,64)%j-A(j,71)%j)*f(2)-A(j,57)%j*f(3)+(A(j,97)%j+A(j,110)%j)*f(4)+(A(j,139)%j-A(j,170)%j)*f(6) &
       +(-A(j,116)%j+A(j,123)%j+A(j,141)%j+A(j,149)%j-A(j,172)%j-A(j,180)%j)*f(7)+(-A(j,62)%j+A(j,69)%j)*f(8)+(-A(j,156)%j &
       -A(j,187)%j)*f(9)+(A(j,237)%j-A(j,243)%j)*f(10)+(-A(j,236)%j+A(j,242)%j)*f(11)+(A(j,150)%j-A(j,153)%j-A(j,154)%j-A(j,181)%j &
       +A(j,184)%j-A(j,185)%j)*f(12)+A(j,193)%j*f(13)+(A(j,135)%j+A(j,166)%j)*f(14)+(A(j,214)%j+A(j,226)%j)*f(15)+A(j,200)%j*f(16) &
       +(-A(j,233)%j-A(j,235)%j-A(j,239)%j-A(j,241)%j)*f(18)+A(j,93)%j*f(19)+A(j,106)%j*f(20)+(A(j,129)%j+A(j,130)%j+A(j,146)%j &
       +A(j,147)%j+A(j,160)%j-A(j,161)%j+A(j,177)%j-A(j,178)%j)*f(23)+(A(j,51)%j+A(j,192)%j+A(j,204)%j-A(j,207)%j-A(j,208)%j &
       -A(j,219)%j-A(j,220)%j)*f(24)+(A(j,77)%j+A(j,89)%j)*f(25)+(A(j,73)%j+A(j,102)%j)*f(26)+(A(j,209)%j+A(j,212)%j+A(j,221)%j &
       +A(j,224)%j)*f(28)-A(j,52)%j*f(29)+(A(j,191)%j+A(j,198)%j)*f(31)+(-A(j,231)%j-A(j,232)%j)*f(33)+A(j,92)%j*f(34) &
       +A(j,105)%j*f(35)+(-A(j,234)%j-A(j,238)%j-A(j,240)%j-A(j,244)%j)*f(37)+(A(j,91)%j+A(j,94)%j)*f(38)+(A(j,104)%j &
       +A(j,107)%j)*f(39)+(A(j,131)%j+A(j,157)%j+A(j,162)%j+A(j,188)%j)*f(41)+(-A(j,136)%j+A(j,167)%j)*f(42)-A(j,194)%j*f(43)+( &
       -A(j,137)%j+A(j,168)%j)*f(44)+(-A(j,195)%j-A(j,202)%j)*f(45)+(-A(j,152)%j+A(j,183)%j)*f(46)+(A(j,83)%j+A(j,85)%j)*f(47)+( &
       -A(j,132)%j+A(j,163)%j)*f(48)+(-A(j,134)%j-A(j,165)%j)*f(49)+(-A(j,36)%j-A(j,43)%j-A(j,61)%j-A(j,68)%j)*f(50)+(-A(j,213)%j &
       -A(j,225)%j)*f(51)+(-A(j,74)%j-A(j,78)%j)*f(52)-A(j,199)%j*f(53)-A(j,48)%j*f(54)+(-A(j,82)%j-A(j,84)%j)*f(55)+(A(j,112)%j &
       +A(j,119)%j)*f(57)+(A(j,33)%j-A(j,95)%j-A(j,108)%j)*f(58)+(-A(j,113)%j+A(j,120)%j)*f(59)-A(j,127)%j*f(60)-A(j,203)%j*f(61) &
       +(-A(j,216)%j-A(j,228)%j)*f(62)+(A(j,88)%j+A(j,101)%j-A(j,211)%j-A(j,218)%j-A(j,223)%j-A(j,230)%j)*f(63)+(A(j,34)%j &
       +A(j,41)%j+A(j,59)%j-A(j,60)%j+A(j,66)%j+A(j,67)%j)*f(64)+(A(j,35)%j-A(j,42)%j)*f(65)+A(j,49)%j*f(66)+A(j,54)%j*f(67) &
       +(A(j,86)%j+A(j,96)%j+A(j,99)%j+A(j,109)%j)*f(68)+A(j,126)%j*f(69)-A(j,81)%j*f(70)-A(j,196)%j*f(73)+(A(j,128)%j-A(j,197)%j &
       -A(j,206)%j)*f(74)+(-A(j,143)%j-A(j,174)%j)*f(75)+(A(j,118)%j+A(j,125)%j-A(j,145)%j-A(j,159)%j-A(j,176)%j-A(j,190)%j)*f(76) &
       +(A(j,114)%j+A(j,121)%j)*f(77)+(-A(j,90)%j+A(j,103)%j)*f(78)+(A(j,151)%j-A(j,182)%j)*f(79)+A(j,201)%j*f(80)+(A(j,65)%j &
       +A(j,72)%j)*f(81)+A(j,56)%j*f(82)+A(j,58)%j*f(83)+(A(j,37)%j-A(j,44)%j)*f(84)+(A(j,38)%j-A(j,45)%j)*f(85)+(-A(j,133)%j &
       +A(j,164)%j)*f(86)+(A(j,210)%j+A(j,215)%j+A(j,222)%j+A(j,227)%j)*f(88)+(-A(j,87)%j-A(j,100)%j+A(j,217)%j+A(j,229)%j)*f(89) &
       +(-A(j,98)%j-A(j,111)%j)*f(90)+(-A(j,75)%j-A(j,79)%j)*f(91)-A(j,53)%j*f(92)-A(j,32)%j*f(93)+(-A(j,76)%j-A(j,80)%j)*f(94) &
       +(A(j,138)%j+A(j,148)%j-A(j,169)%j-A(j,179)%j)*f(97)+(A(j,142)%j+A(j,158)%j+A(j,173)%j+A(j,189)%j)*f(98)+(-A(j,115)%j &
       +A(j,122)%j+A(j,140)%j-A(j,171)%j)*f(99)+(-A(j,117)%j-A(j,124)%j+A(j,144)%j+A(j,175)%j)*f(100)+A(j,205)%j*f(101)+( &
       -A(j,39)%j-A(j,46)%j)*f(102)+(-A(j,40)%j-A(j,47)%j)*f(103)-A(j,50)%j*f(104)+(-A(j,155)%j-A(j,186)%j)*f(105)+(-A(j,63)%j &
       +A(j,70)%j)*f(106)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_bbxhwwx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_bbxhwwx_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(1)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 1
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_bbxhwwx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_bbxhwwx_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu


! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_bbxhwwx_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(1)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 1 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2


! **********************************************************************
#ifdef PRECISION_dp
subroutine hsfamp2(P_scatt, M02, pind_1, pind_2, M2hsf)
#else
subroutine hsfamp2(P_scatt, M02, pind_1, pind_2, M2hsf)
  use ol_loop_storage_pphvv_ew_bbxhwwx_1_/**/DREALKIND, only: &
    & nhflip, helflip, hflip, tsb, pi_flip_bak, pj_flip_bak, nhel
#endif
! M2tree = helicity-summed squared tree matrix element for bottom anti-bottom higgs W- W+ -> 0
! M2hsf  = formula (66) of 1011.3918. Tree level
! spin-correlated hard scattering factor for bottom anti-bottom higgs W- W+ -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  implicit none
  real(DREALKIND), intent(in) :: P_scatt(0:3,5)
  integer, intent(in) :: pind_1, pind_2
  real(REALKIND), intent(out) :: M02, M2hsf
  real(REALKIND)    :: M2add, M2ct_dummy
  integer :: k

  M2add = 0
  M2hsf = 0

  call amp2(P_scatt, M02, .false., M2ct=M2ct_dummy)
  if((pi_flip_bak .ne. pind_1) .or. (pj_flip_bak .ne. pind_2)) then
    call init_flipped_heltables(pind_1,pind_2)
    pi_flip_bak = pind_1
    pj_flip_bak = pind_2
  end if

  do k = 1, nhflip
    call colintHSF(M1helarray(:,helflip(1,k))%j, M1helarray(:,helflip(2,k))%j, M2add)
    M2hsf = M2hsf + M2add
  end do

  contains

subroutine assign_helicity_flip(ext_wf_hf,ext_wf_t,m)
  use ol_debug, only: ol_fatal
  use KIND_TYPES, only: intkind2
  implicit none
  integer(intkind2), intent(in) :: ext_wf_hf(:), ext_wf_t
  integer, intent(in) :: m
  if(.not. allocated(hflip)) allocate(hflip(size(ext_wf_hf),2))
  if(size(ext_wf_hf) == size(hflip,1)) then
    hflip(:,m) = ext_wf_hf
    tsb = tsb + ext_wf_t
  else
    call ol_fatal("Spin-correlated HSF for pphvv_ew_bbxhwwx_1:" &
      & // "trying to flip particles with different number of helicity states")
  end if
end subroutine assign_helicity_flip

subroutine init_flipped_heltables(i,j)
  use KIND_TYPES, only: intkind2
  use ol_external_pphvv_ew_bbxhwwx_1, only: &
    & external_perm_inv_pphvv_ew_bbxhwwx_1
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helicity_flip_ij
  implicit none
  integer, intent(in) :: i, j
  integer :: r, k, l=0
  tsb = 0

  if(allocated(hflip)) deallocate(hflip)

  do k = 1, 5
    r = external_perm_inv_pphvv_ew_bbxhwwx_1(k)
    if(r == i .or. r == j) then
      l = l+1
      select case(k)
        case(1)
          call assign_helicity_flip(ex1(:)%hf,ex1(1)%t,l)
        case(2)
          call assign_helicity_flip(ex2(:)%hf,ex2(1)%t,l)
        case(3)
          call assign_helicity_flip(ex3(:)%hf,ex3(1)%t,l)
        case(4)
          call assign_helicity_flip(ex4(:)%hf,ex4(1)%t,l)
        case(5)
          call assign_helicity_flip(ex5(:)%hf,ex5(1)%t,l)
      end select
    end if
  end do
  call helicity_flip_ij(36,nhel, M1helarray(1,:)%hf, hflip, tsb, &
      & nhflip, helflip)

end subroutine init_flipped_heltables

! **********************************************************************
subroutine colintHSF(M, Mflip, Mhfcolint)
! **********************************************************************
  use ol_colourmatrix_pphvv_ew_bbxhwwx_1_/**/REALKIND, only: K1
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mflip(1)
  real(REALKIND),    intent(out) :: Mhfcolint
  integer :: i, j
  MHfcolint = 0
  do i = 1, 1
    do j = 1, 1
      Mhfcolint = Mhfcolint + real(conjg(Mflip(i))*K1(i,j)*M(j))
    end do
  end do

end subroutine colintHSF

end subroutine hsfamp2

end module ol_loop_pphvv_ew_bbxhwwx_1_/**/REALKIND
