
! **********************************************************************
module ol_heltables_pphvv_ew_bbxhwwx_1
! **********************************************************************
  use KIND_TYPES, only: intkind2
  implicit none

  logical :: heltables_not_init = .true.

  ! helicity states of external particles
  ! integer, save :: &
  !   H1(2) = [-1,1], &
  !   H2(3) = [-1,0,1]
  !   ...
  integer, save :: &
    H1(2) = [-1,1], &
    H2(2) = [-1,1], &
    H3(1) = [0], &
    H4(3) = [-1,0,1], &
    H5(3) = [-1,0,1]

  ! number of helicity states for wave functions returned by a propagator call: n2(sz)
  ! number of helicity states for wave functions in a v-point vertex call (v >= 3)
  ! or a contraction (v = 3): n<v>(v,sz)
  integer(intkind2), save :: n2(4), n3(3,75), n4(4,1)

  ! helicity tables used in the construction of the h helicity states of a wave function (amplitude)
  ! from an v-point vertex (contraction): t<v>x<h>(v-1,h,sz)
  integer(intkind2), save :: t3x18(2,18,1), t3x9(2,9,2), t3x2(2,2,2), t3x3(2,3,4), t3x6(2,6,4), t3x4(2,4,13), t3x12(2,12,18), &
    t3x36(2,36,31), t4x9(3,9,1)

  ! change of global-helicity state resulting from flip of individual-particle helicity
  integer(intkind2), save :: eflip(36,5)
  integer,           save :: exthel(36,5)
  integer,           save :: firstpol(5)

  contains

! **********************************************************************
subroutine init_heltables
! **********************************************************************
  use ol_helicity_init, only: heltable
  implicit none

  ! I/O helicity tables for vertices, propagators and contractions;
  ! helicity table for a vertex call: n_in/n_out are the number helicity states of the incoming/outgoing wave functions
  ! call heltable([<n_in1>, <n_in2>, ..., <n_out>], n, t)
  ! propagators only need the number of helicity configurations which is equal for the incoming and outgoing wave function
  ! n = <n>
  call heltable([2,2,4], n3(:,1), t3x4(:,:,1))
  call heltable([3,3,1,9], n4(:,1), t4x9(:,:,1))
  call heltable([1,3,3], n3(:,2), t3x3(:,:,1))
  call heltable([4,3,12], n3(:,3), t3x12(:,:,1))
  call heltable([2,2,4], n3(:,4), t3x4(:,:,2))
  call heltable([4,3,12], n3(:,5), t3x12(:,:,2))
  call heltable([1,3,3], n3(:,6), t3x3(:,:,2))
  call heltable([4,3,12], n3(:,7), t3x12(:,:,3))
  call heltable([2,2,4], n3(:,8), t3x4(:,:,3))
  call heltable([4,3,12], n3(:,9), t3x12(:,:,4))
  call heltable([2,2,4], n3(:,10), t3x4(:,:,4))
  call heltable([4,3,12], n3(:,11), t3x12(:,:,5))
  call heltable([4,3,12], n3(:,12), t3x12(:,:,6))
  call heltable([4,3,12], n3(:,13), t3x12(:,:,7))
  call heltable([1,3,3], n3(:,14), t3x3(:,:,3))
  call heltable([4,3,12], n3(:,15), t3x12(:,:,8))
  call heltable([4,3,12], n3(:,16), t3x12(:,:,9))
  call heltable([1,3,3], n3(:,17), t3x3(:,:,4))
  call heltable([4,3,12], n3(:,18), t3x12(:,:,10))
  call heltable([4,3,12], n3(:,19), t3x12(:,:,11))
  call heltable([4,3,12], n3(:,20), t3x12(:,:,12))
  call heltable([3,4,12], n3(:,21), t3x12(:,:,13))
  call heltable([3,4,12], n3(:,22), t3x12(:,:,14))
  call heltable([3,3,9], n3(:,23), t3x9(:,:,1))
  call heltable([4,1,4], n3(:,24), t3x4(:,:,5))
  call heltable([3,3,9], n3(:,25), t3x9(:,:,2))
  call heltable([4,1,4], n3(:,26), t3x4(:,:,6))
  call heltable([1,4,4], n3(:,27), t3x4(:,:,7))
  call heltable([2,1,2], n3(:,28), t3x2(:,:,1))
  call heltable([2,3,6], n3(:,29), t3x6(:,:,1))
  n2(1) = 2
  n2(2) = 6
  call heltable([3,2,6], n3(:,30), t3x6(:,:,2))
  call heltable([2,2,4], n3(:,31), t3x4(:,:,8))
  call heltable([2,2,4], n3(:,32), t3x4(:,:,9))
  call heltable([2,2,4], n3(:,33), t3x4(:,:,10))
  call heltable([3,2,6], n3(:,34), t3x6(:,:,3))
  call heltable([1,2,2], n3(:,35), t3x2(:,:,2))
  n2(3) = 6
  n2(4) = 2
  call heltable([3,6,18], n3(:,36), t3x18(:,:,1))
  call heltable([2,2,4], n3(:,37), t3x4(:,:,11))
  call heltable([2,2,4], n3(:,38), t3x4(:,:,12))
  call heltable([2,2,4], n3(:,39), t3x4(:,:,13))
  call heltable([6,1,6], n3(:,40), t3x6(:,:,4))
  call heltable([6,2,12], n3(:,41), t3x12(:,:,15))
  call heltable([2,6,12], n3(:,42), t3x12(:,:,16))
  call heltable([2,6,12], n3(:,43), t3x12(:,:,17))
  call heltable([6,2,12], n3(:,44), t3x12(:,:,18))
  call heltable([4,9,36], n3(:,45), t3x36(:,:,1))
  call heltable([3,12,36], n3(:,46), t3x36(:,:,2))
  call heltable([3,12,36], n3(:,47), t3x36(:,:,3))
  call heltable([3,12,36], n3(:,48), t3x36(:,:,4))
  call heltable([3,12,36], n3(:,49), t3x36(:,:,5))
  call heltable([3,12,36], n3(:,50), t3x36(:,:,6))
  call heltable([3,12,36], n3(:,51), t3x36(:,:,7))
  call heltable([3,12,36], n3(:,52), t3x36(:,:,8))
  call heltable([3,12,36], n3(:,53), t3x36(:,:,9))
  call heltable([3,12,36], n3(:,54), t3x36(:,:,10))
  call heltable([3,12,36], n3(:,55), t3x36(:,:,11))
  call heltable([3,12,36], n3(:,56), t3x36(:,:,12))
  call heltable([3,12,36], n3(:,57), t3x36(:,:,13))
  call heltable([3,12,36], n3(:,58), t3x36(:,:,14))
  call heltable([3,12,36], n3(:,59), t3x36(:,:,15))
  call heltable([9,4,36], n3(:,60), t3x36(:,:,16))
  call heltable([9,4,36], n3(:,61), t3x36(:,:,17))
  call heltable([9,4,36], n3(:,62), t3x36(:,:,18))
  call heltable([6,6,36], n3(:,63), t3x36(:,:,19))
  call heltable([9,4,36], n3(:,64), t3x36(:,:,20))
  call heltable([9,4,36], n3(:,65), t3x36(:,:,21))
  call heltable([9,4,36], n3(:,66), t3x36(:,:,22))
  call heltable([2,18,36], n3(:,67), t3x36(:,:,23))
  call heltable([9,4,36], n3(:,68), t3x36(:,:,24))
  call heltable([9,4,36], n3(:,69), t3x36(:,:,25))
  call heltable([9,4,36], n3(:,70), t3x36(:,:,26))
  call heltable([6,6,36], n3(:,71), t3x36(:,:,27))
  call heltable([3,12,36], n3(:,72), t3x36(:,:,28))
  call heltable([3,12,36], n3(:,73), t3x36(:,:,29))
  call heltable([3,12,36], n3(:,74), t3x36(:,:,30))
  call heltable([3,12,36], n3(:,75), t3x36(:,:,31))

  heltables_not_init = .false.

end subroutine init_heltables

end module ol_heltables_pphvv_ew_bbxhwwx_1
