
module ol_vamp_1_pphvv_ddxhzz_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphvv_ddxhzz_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphvv_ddxhzz_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pphvv_ddxhzz_1_/**/DREALKIND
  use ol_tensor_sum_storage_pphvv_ddxhzz_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_pphvv_ddxhzz_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pphvv_ddxhzz_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1),h0tab(:,1),[16,1,2,12],[0,0,0,0],4,1,wf3(:,4))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(1),ngZd,m3h3x12(:,1),heltab2x36(:,:,1))
  call Hloop_A_Q(ntryL,G0H12(1),16,0,G1H12(1),n2h12(1))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2),h0tab(:,2),[16,2,1,12],[0,0,0,0],4,1,wf3(:,4))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(1),ngZd,m3h3x12(:,2),heltab2x36(:,:,2))
  call Hloop_Q_A(ntryL,G0H12(1),16,0,G1H12(2),n2h12(2))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(3),h0tab(:,3),[20,2,1,8],[0,0,0,0],4,1,wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,2),G0H12(1),ngZd,m3h3x12(:,3),heltab2x36(:,:,3))
  call Hloop_Q_A(ntryL,G0H12(1),20,0,G1H12(3),n2h12(3))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(4),h0tab(:,4),[20,1,2,8],[0,0,0,0],4,1,wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf3(:,2),G0H12(1),ngZd,m3h3x12(:,4),heltab2x36(:,:,4))
  call Hloop_A_Q(ntryL,G0H12(1),20,0,G1H12(4),n2h12(4))
  call Hloop_AQ_V(ntryL,G1H12(1),ex1(:),G1H6(1),m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_QA_V(ntryL,G1H12(2),ex2(:),G1H6(2),m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_QA_V(ntryL,G1H12(3),ex2(:),G1H6(3),m3h2x6(:,3),heltab2x12(:,:,3))
  call Hloop_AQ_V(ntryL,G1H12(4),ex1(:),G1H6(4),m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_VA_Q(ntryL,G1H6(1),ex2(:),G1H3(1),m3h2x3(:,1),heltab2x6(:,:,1))
  call Hloop_A_Q(ntryL,G1H3(1),19,0,G2H3(1),n2h3(1))
  call Hloop_VQ_A(ntryL,G1H6(2),ex1(:),G1H3(1),m3h2x3(:,2),heltab2x6(:,:,2))
  call Hloop_Q_A(ntryL,G1H3(1),19,0,G2H3(2),n2h3(2))
  call Hloop_VQ_A(ntryL,G1H6(3),ex1(:),G1H3(1),m3h2x3(:,3),heltab2x6(:,:,3))
  call Hloop_Q_A(ntryL,G1H3(1),23,0,G2H3(3),n2h3(3))
  call Hloop_VA_Q(ntryL,G1H6(4),ex2(:),G1H3(1),m3h2x3(:,4),heltab2x6(:,:,4))
  call Hloop_A_Q(ntryL,G1H3(1),23,0,G2H3(4),n2h3(4))
  call Hotf_4pt_reduction(G2H3(1),RedSet_4(1),mass4set(:,1),  & 
G1H3(1),G1H3(2),G1H3(3),G1H3(4),G1H3(5),3)
  call HG1shiftOLR(G1H3(2),12,3)
  call Hotf_4pt_reduction(G2H3(2),RedSet_4(2),mass4set(:,1),  & 
G1H3(6),G1H3(7),G1H3(8),G1H3(9),G1H3(10),3)
  call HG1shiftOLR(G1H3(7),12,3)
  call Hotf_4pt_reduction(G2H3(3),RedSet_4(3),mass4set(:,1),  & 
G1H3(11),G1H3(12),G1H3(13),G1H3(14),G1H3(15),3)
  call HG1shiftOLR(G1H3(12),8,3)
  call Hotf_4pt_reduction(G2H3(4),RedSet_4(4),mass4set(:,1),  & 
G1H3(16),G1H3(17),G1H3(18),G1H3(19),G1H3(20),3)
  call HG1shiftOLR(G1H3(17),8,3)
  call Hloop_AZ_Q(ntryL,G1H3(1),wf3(:,4),G1H1(1),ngZd,m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(1),n2h1(1))
  call Hloop_AZ_Q(ntryL,G1H3(2),wf3(:,4),G1H1(1),ngZd,m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,0,G2tensor(2),n2h1(2))
  call Hloop_AZ_Q(ntryL,G1H3(5),wf3(:,4),G1H1(1),ngZd,m3h3x1(:,3),heltab2x3(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(3),n2h1(3))
  call Hloop_QZ_A(ntryL,G1H3(6),wf3(:,4),G1H1(1),ngZd,m3h3x1(:,4),heltab2x3(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(4),n2h1(4))
  call Hloop_QZ_A(ntryL,G1H3(7),wf3(:,4),G1H1(1),ngZd,m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),12,0,G2tensor(5),n2h1(5))
  call Hloop_QZ_A(ntryL,G1H3(10),wf3(:,4),G1H1(1),ngZd,m3h3x1(:,6),heltab2x3(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(6),n2h1(6))
  call Hloop_QZ_A(ntryL,G1H3(11),ex4(:),G1H1(1),ngZd,m3h3x1(:,7),heltab2x3(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(7))
  call Hloop_QZ_A(ntryL,G1H3(12),ex4(:),G1H1(1),ngZd,m3h3x1(:,8),heltab2x3(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(8),n2h1(8))
  call Hloop_QZ_A(ntryL,G1H3(15),ex4(:),G1H1(1),ngZd,m3h3x1(:,9),heltab2x3(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(9),n2h1(9))
  call Hloop_AZ_Q(ntryL,G1H3(16),ex4(:),G1H1(1),ngZd,m3h3x1(:,10),heltab2x3(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(10),n2h1(10))
  call Hloop_AZ_Q(ntryL,G1H3(17),ex4(:),G1H1(1),ngZd,m3h3x1(:,11),heltab2x3(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,0,G2tensor(11),n2h1(11))
  call Hloop_AZ_Q(ntryL,G1H3(20),ex4(:),G1H1(1),ngZd,m3h3x1(:,12),heltab2x3(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(12),n2h1(12))
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5))
  call G_TensorShift(G1tensor(2),12)
  call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(2),mass4set(:,1),  & 
G1tensor(6),G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10))
  call G_TensorShift(G1tensor(7),12)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(3),mass4set(:,1),  & 
G1tensor(11),G1tensor(12),G1tensor(13),G1tensor(14),G1tensor(15))
  call G_TensorShift(G1tensor(12),8)
  call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(4),mass4set(:,1),  & 
G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(19),G1tensor(20))
  call G_TensorShift(G1tensor(17),8)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(1),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(2),mass4set(:,1),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(3),mass4set(:,1),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(4),mass4set(:,1),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(5),h0tab(:,5),[20,2,9],[0,0,0],3,2,wf3(:,2),wf6(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,2),G0H12(1),ngZd,m3h3x12(:,5),heltab2x36(:,:,5))
  call Hloop_Q_A(ntryL,G0H12(1),20,0,G1H12(1),n2h12(5))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(6),h0tab(:,6),[20,1,10],[0,0,0],3,2,wf3(:,2),wf6(:,4))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf3(:,2),G0H12(1),ngZd,m3h3x12(:,6),heltab2x36(:,:,6))
  call Hloop_A_Q(ntryL,G0H12(1),20,0,G1H12(2),n2h12(6))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(7),h0tab(:,7),[17,2,12],[0,0,0],3,2,wf6(:,6),wf3(:,4))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,6),G0H6(1),m3h6x6(:,1),heltab2x36(:,:,7))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(8),h0tab(:,8),[18,1,12],[0,0,0],3,2,wf6(:,8),wf3(:,4))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,8),G0H6(2),m3h6x6(:,2),heltab2x36(:,:,8))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(9),h0tab(:,9),[16,2,13],[0,0,0],3,1,wf6(:,28))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(1),ngZd,m3h3x12(:,7),heltab2x36(:,:,9))
  call Hloop_Q_A(ntryL,G0H12(1),16,0,G1H12(3),n2h12(7))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(10),h0tab(:,10),[16,1,14],[0,0,0],3,1,wf6(:,25))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(1),ngZd,m3h3x12(:,8),heltab2x36(:,:,10))
  call Hloop_A_Q(ntryL,G0H12(1),16,0,G1H12(4),n2h12(8))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(11),h0tab(:,11),[21,2,8],[0,0,0],3,1,wf6(:,22))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,22),G0H6(3),m3h6x6(:,3),heltab2x36(:,:,11))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(12),h0tab(:,12),[22,1,8],[0,0,0],3,1,wf6(:,19))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,19),G0H6(4),m3h6x6(:,4),heltab2x36(:,:,12))
  call Hloop_QA_V(ntryL,G1H12(1),ex2(:),G1H6(1),m3h2x6(:,5),heltab2x12(:,:,5))
  call Hloop_AQ_V(ntryL,G1H12(2),ex1(:),G1H6(2),m3h2x6(:,6),heltab2x12(:,:,6))
  call Hloop_VA_Q(ntryL,G0H6(1),ex2(:),G0H3(1),m3h2x3(:,5),heltab2x6(:,:,5))
  call Hloop_A_Q(ntryL,G0H3(1),19,0,G1H3(1),n2h3(5))
  call Hloop_VQ_A(ntryL,G0H6(2),ex1(:),G0H3(1),m3h2x3(:,6),heltab2x6(:,:,6))
  call Hloop_Q_A(ntryL,G0H3(1),19,0,G1H3(2),n2h3(6))
  call Hloop_QA_V(ntryL,G1H12(3),ex2(:),G1H6(3),m3h2x6(:,7),heltab2x12(:,:,7))
  call Hloop_AQ_V(ntryL,G1H12(4),ex1(:),G1H6(4),m3h2x6(:,8),heltab2x12(:,:,8))
  call Hloop_VA_Q(ntryL,G0H6(3),ex2(:),G0H3(1),m3h2x3(:,7),heltab2x6(:,:,7))
  call Hloop_A_Q(ntryL,G0H3(1),23,0,G1H3(5),n2h3(7))
  call Hloop_VQ_A(ntryL,G0H6(4),ex1(:),G0H3(1),m3h2x3(:,8),heltab2x6(:,:,8))
  call Hloop_Q_A(ntryL,G0H3(1),23,0,G1H3(6),n2h3(8))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(1),[G1H3(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(2),[G1H3(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(6),[G1H3(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(5),[G1H3(18)])
  call Hloop_AZ_Q(ntryL,G1H3(1),wf3(:,4),G1H1(1),ngZd,m3h3x1(:,13),heltab2x3(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(1),n2h1(13))
  call Hloop_AZ_Q(ntryL,G1H3(4),wf3(:,4),G1H1(1),ngZd,m3h3x1(:,14),heltab2x3(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(4),n2h1(14))
  call Hloop_QZ_A(ntryL,G1H3(2),wf3(:,4),G1H1(1),ngZd,m3h3x1(:,15),heltab2x3(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(15))
  call Hloop_QZ_A(ntryL,G1H3(9),wf3(:,4),G1H1(1),ngZd,m3h3x1(:,16),heltab2x3(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(10),n2h1(16))
  call Hloop_QZ_A(ntryL,G1H3(6),ex4(:),G1H1(1),ngZd,m3h3x1(:,17),heltab2x3(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(13),n2h1(17))
  call Hloop_QZ_A(ntryL,G1H3(14),ex4(:),G1H1(1),ngZd,m3h3x1(:,18),heltab2x3(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(14),n2h1(18))
  call Hloop_AZ_Q(ntryL,G1H3(5),ex4(:),G1H1(1),ngZd,m3h3x1(:,19),heltab2x3(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(15),n2h1(19))
  call Hloop_AZ_Q(ntryL,G1H3(19),ex4(:),G1H1(1),ngZd,m3h3x1(:,20),heltab2x3(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(16),n2h1(20))
  call Hloop_VQ_A(ntryL,G1H6(1),wf6(:,2),G1H1(1),m3h6x1(:,1),heltab2x6(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(17),n2h1(21))
  call Hloop_VA_Q(ntryL,G1H6(2),wf6(:,4),G1H1(1),m3h6x1(:,2),heltab2x6(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(18),n2h1(22))
  call Hloop_VQ_A(ntryL,G1H6(3),wf6(:,28),G1H1(1),m3h6x1(:,3),heltab2x6(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(19),n2h1(23))
  call Hloop_VA_Q(ntryL,G1H6(4),wf6(:,25),G1H1(1),m3h6x1(:,4),heltab2x6(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(20),n2h1(24))
  call ol_merge_tensors(G2tensor(11),[G2tensor(2),G1tensor(17),G1tensor(2),G0tensor(17),G0tensor(2)])
  call ol_merge_tensors(G2tensor(20),[G2tensor(3),G1tensor(5),G0tensor(5)])
  call ol_merge_tensors(G2tensor(8),[G2tensor(5),G1tensor(12),G1tensor(7),G0tensor(12),G0tensor(7)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(6),G1tensor(10),G0tensor(10)])
  call ol_merge_tensors(G2tensor(17),[G2tensor(9),G1tensor(15),G0tensor(15)])
  call ol_merge_tensors(G2tensor(18),[G2tensor(12),G1tensor(20),G0tensor(20)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(3),G0tensor(3)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(4),G1tensor(9),G1tensor(4),G0tensor(9),G0tensor(4)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(8),G0tensor(8)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(13),G0tensor(13)])
  call ol_merge_tensors(G2tensor(16),[G2tensor(14),G1tensor(19),G1tensor(14),G0tensor(19),G0tensor(14)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(18),G0tensor(18)])
  call TI_triangle_red(G2tensor(11),RedBasis(11),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1)
  call TI_triangle_red(G2tensor(20),RedBasis(1),mass3set(:,1),G0tensor(17),G0tensor(2),G0tensor(5),G0tensor(12),M2L1R1)
  call TI_triangle_red(G2tensor(8),RedBasis(12),mass3set(:,1),G0tensor(7),G0tensor(10),G0tensor(15),G0tensor(20),M2L1R1)
  call TI_triangle_red(G2tensor(19),RedBasis(4),mass3set(:,1),G0tensor(3),G0tensor(9),G0tensor(4),G0tensor(8),M2L1R1)
  call TI_triangle_red(G2tensor(17),RedBasis(6),mass3set(:,1),G0tensor(13),G0tensor(19),G0tensor(14),G0tensor(18),M2L1R1)
  call TI_triangle_red(G2tensor(18),RedBasis(9),mass3set(:,1),G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),M2L1R1)
  call TI_triangle_red(G2tensor(1),RedBasis(3),mass3set(:,1),G0tensor(25),G0tensor(26),G0tensor(27),G0tensor(28),M2L1R1)
  call TI_triangle_red(G2tensor(10),RedBasis(2),mass3set(:,1),G0tensor(29),G0tensor(30),G0tensor(31),G0tensor(32),M2L1R1)
  call TI_triangle_red(G2tensor(7),RedBasis(5),mass3set(:,1),G0tensor(33),G0tensor(34),G0tensor(35),G0tensor(36),M2L1R1)
  call TI_triangle_red(G2tensor(13),RedBasis(8),mass3set(:,1),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40),M2L1R1)
  call TI_triangle_red(G2tensor(16),RedBasis(7),mass3set(:,1),G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),M2L1R1)
  call TI_triangle_red(G2tensor(15),RedBasis(10),mass3set(:,1),G0tensor(45),G0tensor(46),G0tensor(47),G0tensor(48),M2L1R1)
  call ol_merge_tensors(T0sum(5),[G0tensor(1)])
  call ol_merge_tensors(T0sum(6),[G0tensor(17)])
  call ol_merge_tensors(T0sum(7),[G0tensor(7)])
  call ol_merge_tensors(T0sum(8),[G0tensor(3)])
  call ol_merge_tensors(T0sum(9),[G0tensor(13)])
  call ol_merge_tensors(T0sum(10),[G0tensor(21)])
  call ol_merge_tensors(T0sum(11),[G0tensor(25)])
  call ol_merge_tensors(T0sum(12),[G0tensor(29)])
  call ol_merge_tensors(T0sum(13),[G0tensor(33)])
  call ol_merge_tensors(T0sum(14),[G0tensor(37)])
  call ol_merge_tensors(T0sum(15),[G0tensor(41)])
  call ol_merge_tensors(T0sum(16),[G0tensor(45)])
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(13),h0tab(:,13),[22,9],[0,0],2,2,wf6(:,19),wf6(:,2))
  call Hloop_VA_Q(ntryL,G0H36(1),wf6(:,19),G0H6(1),m3h6x6(:,5),heltab2x36(:,:,13))
  call Hloop_A_Q(ntryL,G0H6(1),22,0,G1H6(1),n2h6(1))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(14),h0tab(:,14),[21,10],[0,0],2,2,wf6(:,22),wf6(:,4))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,22),G0H6(2),m3h6x6(:,6),heltab2x36(:,:,14))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(15),h0tab(:,15),[17,14],[0,0],2,2,wf6(:,6),wf6(:,25))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,6),G0H6(3),m3h6x6(:,7),heltab2x36(:,:,15))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(16),h0tab(:,16),[18,13],[0,0],2,2,wf6(:,8),wf6(:,28))
  call Hloop_VA_Q(ntryL,G0H36(1),wf6(:,8),G0H6(4),m3h6x6(:,8),heltab2x36(:,:,16))
  call Hloop_A_Q(ntryL,G0H6(4),18,0,G1H6(2),n2h6(2))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H6(1),wf6(:,2),G1tensor(1),m3h6x1(:,5),heltab2x6(:,:,13))
  call Hloop_VA_Q(ntryL,G0H6(2),wf6(:,4),G0H1(1),m3h6x1(:,6),heltab2x6(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(6),n2h1(25))
  call Hloop_VA_Q(ntryL,G0H6(3),wf6(:,25),G0H1(1),m3h6x1(:,7),heltab2x6(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,0,G1tensor(11),n2h1(26))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H6(2),wf6(:,28),G1tensor(16),m3h6x1(:,8),heltab2x6(:,:,16))
  call ol_merge_tensors(G0tensor(38),[G0tensor(34),G0tensor(22),G0tensor(15),G0tensor(2),G0tensor(6)])
  call ol_merge_tensors(G0tensor(46),[G0tensor(26),G0tensor(19),G0tensor(9),G0tensor(10),G0tensor(11)])
  call ol_merge_tensors(G0tensor(42),[G0tensor(30),G0tensor(20),G0tensor(16)])
  call ol_merge_tensors(G1tensor(11),[G0tensor(28),G0tensor(5)])
  call ol_merge_tensors(G0tensor(32),[G0tensor(8),G0tensor(12)])
  call ol_merge_tensors(G1tensor(16),[G0tensor(36),G0tensor(4)])
  call ol_merge_tensors(G1tensor(1),[G0tensor(40),G0tensor(14)])
  call ol_merge_tensors(G0tensor(44),[G0tensor(24),G0tensor(18)])
  call ol_merge_tensors(G1tensor(6),[G0tensor(48),G0tensor(23)])
  call ol_merge_tensors(G0tensor(35),[G0tensor(31),G0tensor(27)])
  call ol_merge_tensors(G0tensor(47),[G0tensor(43),G0tensor(39)])
call TI_bubble_red(G1tensor(11),17,mass2set(:,1),G0tensor(1),M2L1R1)
call TI_bubble_red(G1tensor(16),18,mass2set(:,1),G0tensor(17),M2L1R1)
call TI_bubble_red(G1tensor(1),22,mass2set(:,1),G0tensor(7),M2L1R1)
call TI_bubble_red(G1tensor(6),21,mass2set(:,1),G0tensor(3),M2L1R1)
  call ol_merge_tensors(T0sum(17),[G0tensor(38)])
  call ol_merge_tensors(T0sum(18),[G0tensor(46)])
  call ol_merge_tensors(T0sum(19),[G0tensor(42)])
  call ol_merge_tensors(T0sum(20),[G0tensor(1)])
  call ol_merge_tensors(T0sum(21),[G0tensor(32)])
  call ol_merge_tensors(T0sum(22),[G0tensor(17)])
  call ol_merge_tensors(T0sum(23),[G0tensor(7)])
  call ol_merge_tensors(T0sum(24),[G0tensor(44)])
  call ol_merge_tensors(T0sum(25),[G0tensor(3)])
  call ol_merge_tensors(T0sum(26),[G0tensor(35)])
  call ol_merge_tensors(T0sum(27),[G0tensor(47)])
! end of process


end subroutine vamp_1

end module ol_vamp_1_pphvv_ddxhzz_1_/**/REALKIND
