
module ol_vamp_1_pphvv_bbxhzz_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphvv_bbxhzz_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphvv_bbxhzz_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pphvv_bbxhzz_1_/**/DREALKIND
  use ol_tensor_sum_storage_pphvv_bbxhzz_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pphvv_bbxhzz_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pphvv_bbxhzz_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[nMB,nMB,0,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(1),ngZd,m3h3x12(:,1),heltab2x36(:,:,1))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(1),n2h12(1))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2),h0tab(:,2),[16,2,1,4,8],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(1),ngZd,m3h3x12(:,2),heltab2x36(:,:,2))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMB,G1H12(2),n2h12(2))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(3),h0tab(:,3),[16,4,2,1,8],[nMB,nMB,0,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(1),ngZd,m3h3x12(:,3),heltab2x36(:,:,3))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMB,G1H12(3),n2h12(3))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(4),h0tab(:,4),[16,2,1,8,4],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(1),ngZd,m3h3x12(:,4),heltab2x36(:,:,4))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMB,G1H12(4),n2h12(4))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(5),h0tab(:,5),[16,1,2,4,8],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(1),ngZd,m3h3x12(:,5),heltab2x36(:,:,5))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(5),n2h12(5))
  Gcoeff(:)%j = (c(5)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(6),h0tab(:,6),[16,1,2,8,4],[nMB,0,nMB,nMB,nMB],5,0)
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(1),ngZd,m3h3x12(:,6),heltab2x36(:,:,6))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(6),n2h12(6))
  call Hloop_AS_Q(ntryL,G1H12(1),ex3(:),G1H12(7),ngH,m3h1x12(:,1),heltab2x12(:,:,1))
  call Hloop_A_Q(ntryL,G1H12(7),20,nMB,G2H12(1),n2h12(7))
  call Hloop_QA_V(ntryL,G1H12(2),ex2(:),G1H6(1),m3h2x6(:,1),heltab2x12(:,:,2))
  call Hloop_QS_A(ntryL,G1H12(3),ex3(:),G1H12(1),ngH,m3h1x12(:,2),heltab2x12(:,:,3))
  call Hloop_Q_A(ntryL,G1H12(1),20,nMB,G2H12(2),n2h12(8))
  call Hloop_QA_V(ntryL,G1H12(4),ex2(:),G1H6(2),m3h2x6(:,2),heltab2x12(:,:,4))
  call Hloop_AQ_V(ntryL,G1H12(5),ex1(:),G1H6(3),m3h2x6(:,3),heltab2x12(:,:,5))
  call Hloop_AQ_V(ntryL,G1H12(6),ex1(:),G1H6(4),m3h2x6(:,4),heltab2x12(:,:,6))
  call Hloop_AQ_V(ntryL,G2H12(1),ex1(:),G2H6(1),m3h2x6(:,5),heltab2x12(:,:,7))
  call Hloop_VQ_A(ntryL,G1H6(1),ex1(:),G1H3(1),m3h2x3(:,1),heltab2x6(:,:,1))
  call Hloop_Q_A(ntryL,G1H3(1),19,nMB,G2H3(1),n2h3(1))
  call Hloop_QA_V(ntryL,G2H12(2),ex2(:),G2H6(2),m3h2x6(:,6),heltab2x12(:,:,8))
  call Hloop_VQ_A(ntryL,G1H6(2),ex1(:),G1H3(1),m3h2x3(:,2),heltab2x6(:,:,2))
  call Hloop_Q_A(ntryL,G1H3(1),19,nMB,G2H3(2),n2h3(2))
  call Hloop_VA_Q(ntryL,G1H6(3),ex2(:),G1H3(1),m3h2x3(:,3),heltab2x6(:,:,3))
  call Hloop_A_Q(ntryL,G1H3(1),19,nMB,G2H3(3),n2h3(3))
  call Hloop_VA_Q(ntryL,G1H6(4),ex2(:),G1H3(1),m3h2x3(:,4),heltab2x6(:,:,4))
  call Hloop_A_Q(ntryL,G1H3(1),19,nMB,G2H3(4),n2h3(4))
  call Hotf_5pt_reduction(G2H6(1),RedSet_5(1),mass5set(:,1),  & 
G1H6(1),G1H6(2),G1H6(3),G1H6(4),G1H6(5),G1H6(6),6)
  call HG1shiftOLR(G1H6(2),8,6)
  call Hotf_5pt_reduction(G2H3(1),RedSet_5(2),mass5set(:,2),  & 
G1H3(1),G1H3(2),G1H3(3),G1H3(4),G1H3(5),G1H3(6),3)
  call HG1shiftOLR(G1H3(2),8,3)
  call Hotf_5pt_reduction(G2H6(2),RedSet_5(3),mass5set(:,1),  & 
G1H6(7),G1H6(8),G1H6(9),G1H6(10),G1H6(11),G1H6(12),6)
  call HG1shiftOLR(G1H6(8),8,6)
  call Hotf_5pt_reduction(G2H3(2),RedSet_5(4),mass5set(:,2),  & 
G1H3(7),G1H3(8),G1H3(9),G1H3(10),G1H3(11),G1H3(12),3)
  call HG1shiftOLR(G1H3(8),4,3)
  call Hotf_5pt_reduction(G2H3(3),RedSet_5(5),mass5set(:,2),  & 
G1H3(13),G1H3(14),G1H3(15),G1H3(16),G1H3(17),G1H3(18),3)
  call HG1shiftOLR(G1H3(14),8,3)
  call Hotf_5pt_reduction(G2H3(4),RedSet_5(6),mass5set(:,2),  & 
G1H3(19),G1H3(20),G1H3(21),G1H3(22),G1H3(23),G1H3(24),3)
  call HG1shiftOLR(G1H3(20),4,3)
  call Hloop_VA_Q(ntryL,G1H6(1),ex2(:),G1H3(25),m3h2x3(:,5),heltab2x6(:,:,5))
  call Hloop_A_Q(ntryL,G1H3(25),23,nMB,G2H3(1),n2h3(5))
call HGT_OLR(G1H6(2),1,1,6)
call HGT_invQ_OLR(G1H6(2),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(2),-8,nMB,G2H6(1),n2h6(1))
  call Hloop_QZ_A(ntryL,G2H6(1),ex4(:),G2H2(1),ngZd,m3h3x2(:,1),heltab2x6(:,:,6))
  call Hloop_VA_Q(ntryL,G1H6(5),ex2(:),G1H3(25),m3h2x3(:,6),heltab2x6(:,:,7))
  call Hloop_A_Q(ntryL,G1H3(25),23,nMB,G2H3(2),n2h3(6))
  call Hloop_VA_Q(ntryL,G1H6(6),ex2(:),G1H3(25),m3h2x3(:,7),heltab2x6(:,:,8))
  call Hloop_A_Q(ntryL,G1H3(25),23,nMB,G2H3(3),n2h3(7))
  call Hloop_QS_A(ntryL,G1H3(1),ex3(:),G1H3(25),ngH,m3h1x3(:,1),heltab2x3(:,:,1))
  call Hloop_Q_A(ntryL,G1H3(25),23,nMB,G2H3(4),n2h3(8))
call HGT_OLR(G1H3(2),1,1,3)
call HGT_invQ_OLR(G1H3(2),2,5,3)
  call Hloop_A_Q(ntryL,G1H3(2),-8,nMB,G2H3(5),n2h3(9))
  call Hloop_AZ_Q(ntryL,G2H3(5),ex4(:),G2H1(1),ngZd,m3h3x1(:,1),heltab2x3(:,:,2))
  call Hloop_QS_A(ntryL,G1H3(5),ex3(:),G1H3(1),ngH,m3h1x3(:,2),heltab2x3(:,:,3))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(5),n2h3(10))
  call Hloop_QS_A(ntryL,G1H3(6),ex3(:),G1H3(25),ngH,m3h1x3(:,3),heltab2x3(:,:,4))
  call Hloop_Q_A(ntryL,G1H3(25),23,nMB,G2H3(6),n2h3(11))
  call Hloop_VQ_A(ntryL,G1H6(7),ex1(:),G1H3(2),m3h2x3(:,8),heltab2x6(:,:,9))
  call Hloop_Q_A(ntryL,G1H3(2),23,nMB,G2H3(7),n2h3(12))
call HGT_OLR(G1H6(8),1,1,6)
call HGT_invQ_OLR(G1H6(8),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(8),-8,nMB,G2H6(2),n2h6(2))
  call Hloop_AZ_Q(ntryL,G2H6(2),ex4(:),G2H2(2),ngZd,m3h3x2(:,2),heltab2x6(:,:,10))
  call Hloop_VQ_A(ntryL,G1H6(11),ex1(:),G1H3(5),m3h2x3(:,9),heltab2x6(:,:,11))
  call Hloop_Q_A(ntryL,G1H3(5),23,nMB,G2H3(8),n2h3(13))
  call Hloop_VQ_A(ntryL,G1H6(12),ex1(:),G1H3(1),m3h2x3(:,10),heltab2x6(:,:,12))
  call Hloop_Q_A(ntryL,G1H3(1),23,nMB,G2H3(9),n2h3(14))
  call Hloop_QZ_A(ntryL,G1H3(7),ex4(:),G1H1(1),ngZd,m3h3x1(:,2),heltab2x3(:,:,5))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMB,G2H1(2),n2h1(1))
call HGT_OLR(G1H3(8),1,1,3)
call HGT_invQ_OLR(G1H3(8),2,5,3)
  call Hloop_A_Q(ntryL,G1H3(8),-4,nMB,G2H3(10),n2h3(15))
  call Hloop_AS_Q(ntryL,G2H3(10),ex3(:),G2H3(11),ngH,m3h1x3(:,4),heltab2x3(:,:,6))
  call Hloop_QZ_A(ntryL,G1H3(11),ex4(:),G1H1(1),ngZd,m3h3x1(:,3),heltab2x3(:,:,7))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMB,G2H1(3),n2h1(2))
  call Hloop_QZ_A(ntryL,G1H3(12),ex4(:),G1H1(1),ngZd,m3h3x1(:,4),heltab2x3(:,:,8))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMB,G2H1(4),n2h1(3))
  call Hloop_AS_Q(ntryL,G1H3(13),ex3(:),G1H3(6),ngH,m3h1x3(:,5),heltab2x3(:,:,9))
  call Hloop_A_Q(ntryL,G1H3(6),23,nMB,G2H3(10),n2h3(16))
call HGT_OLR(G1H3(14),1,1,3)
call HGT_invQ_OLR(G1H3(14),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(14),-8,nMB,G2H3(12),n2h3(17))
  call Hloop_QZ_A(ntryL,G2H3(12),ex4(:),G2H1(5),ngZd,m3h3x1(:,5),heltab2x3(:,:,10))
  call Hloop_AS_Q(ntryL,G1H3(17),ex3(:),G1H3(25),ngH,m3h1x3(:,6),heltab2x3(:,:,11))
  call Hloop_A_Q(ntryL,G1H3(25),23,nMB,G2H3(12),n2h3(18))
  call Hloop_AS_Q(ntryL,G1H3(18),ex3(:),G1H3(2),ngH,m3h1x3(:,7),heltab2x3(:,:,12))
  call Hloop_A_Q(ntryL,G1H3(2),23,nMB,G2H3(13),n2h3(19))
  call Hloop_AZ_Q(ntryL,G1H3(19),ex4(:),G1H1(1),ngZd,m3h3x1(:,6),heltab2x3(:,:,13))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMB,G2H1(6),n2h1(4))
call HGT_OLR(G1H3(20),1,1,3)
call HGT_invQ_OLR(G1H3(20),2,5,3)
  call Hloop_Q_A(ntryL,G1H3(20),-4,nMB,G2H3(14),n2h3(20))
  call Hloop_QS_A(ntryL,G2H3(14),ex3(:),G2H3(15),ngH,m3h1x3(:,8),heltab2x3(:,:,14))
  call Hloop_AZ_Q(ntryL,G1H3(23),ex4(:),G1H1(1),ngZd,m3h3x1(:,7),heltab2x3(:,:,15))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMB,G2H1(7),n2h1(5))
  call Hloop_AZ_Q(ntryL,G1H3(24),ex4(:),G1H1(1),ngZd,m3h3x1(:,8),heltab2x3(:,:,16))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMB,G2H1(8),n2h1(6))
  call Hotf_5pt_reduction(G2H3(1),RedSet_5(1),mass5set(:,1),  & 
G1H3(5),G1H3(1),G1H3(7),G1H3(8),G1H3(11),G1H3(12),3)
  call HG1shiftOLR(G1H3(1),8,3)
  call Hotf_4pt_reduction(G2H3(3),RedSet_4(1),mass4set(:,1),  & 
G1H3(13),G1H3(6),G1H3(14),G1H3(17),G1H3(25),3)
  call HG1shiftOLR(G1H3(6),10,3)
  call Hotf_5pt_reduction(G2H3(4),RedSet_5(2),mass5set(:,2),  & 
G1H3(18),G1H3(2),G1H3(19),G1H3(20),G1H3(23),G1H3(24),3)
  call HG1shiftOLR(G1H3(2),8,3)
  call Hotf_4pt_reduction(G2H3(6),RedSet_4(2),mass4set(:,2),  & 
G1H3(26),G1H3(27),G1H3(28),G1H3(29),G1H3(30),3)
  call HG1shiftOLR(G1H3(27),12,3)
  call Hotf_5pt_reduction(G2H3(7),RedSet_5(3),mass5set(:,1),  & 
G1H3(31),G1H3(32),G1H3(33),G1H3(34),G1H3(35),G1H3(36),3)
  call HG1shiftOLR(G1H3(32),8,3)
  call Hotf_4pt_reduction(G2H3(9),RedSet_4(3),mass4set(:,1),  & 
G1H3(37),G1H3(38),G1H3(39),G1H3(40),G1H3(41),3)
  call HG1shiftOLR(G1H3(38),9,3)
  call Hotf_5pt_reduction(G2H1(2),RedSet_5(4),mass5set(:,2),  & 
G1H1(1),G1H1(2),G1H1(3),G1H1(4),G1H1(5),G1H1(6),1)
  call HG1shiftOLR(G1H1(2),4,1)
  call Hotf_4pt_reduction(G2H1(4),RedSet_4(2),mass4set(:,2),  & 
G1H1(7),G1H1(8),G1H1(9),G1H1(10),G1H1(11),1)
  call HG1shiftOLR(G1H1(8),12,1)
  call Hotf_5pt_reduction(G2H3(10),RedSet_5(5),mass5set(:,2),  & 
G1H3(42),G1H3(43),G1H3(44),G1H3(45),G1H3(46),G1H3(47),3)
  call HG1shiftOLR(G1H3(43),8,3)
  call Hotf_4pt_reduction(G2H3(13),RedSet_4(4),mass4set(:,2),  & 
G1H3(48),G1H3(49),G1H3(50),G1H3(51),G1H3(52),3)
  call HG1shiftOLR(G1H3(49),12,3)
  call Hotf_5pt_reduction(G2H1(6),RedSet_5(6),mass5set(:,2),  & 
G1H1(12),G1H1(13),G1H1(14),G1H1(15),G1H1(16),G1H1(17),1)
  call HG1shiftOLR(G1H1(13),4,1)
  call Hotf_4pt_reduction(G2H1(8),RedSet_4(4),mass4set(:,2),  & 
G1H1(18),G1H1(19),G1H1(20),G1H1(21),G1H1(22),1)
  call HG1shiftOLR(G1H1(19),12,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(13),[G1H3(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(26),[G1H3(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(37),[G1H3(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(7),[G1H1(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(48),[G1H3(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(18),[G1H1(17)])
  call Hloop_AZ_Q(ntryL,G1H3(5),ex4(:),G1H1(6),ngZd,m3h3x1(:,9),heltab2x3(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(6),31,nMB,G2tensor(1),n2h1(7))
  call Hloop_AZ_Q(ntryL,G1H3(1),ex4(:),G1H1(17),ngZd,m3h3x1(:,10),heltab2x3(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),8,nMB,G2tensor(2),n2h1(8))
  call Hloop_AZ_Q(ntryL,G1H3(13),ex4(:),G1H1(6),ngZd,m3h3x1(:,11),heltab2x3(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(6),31,nMB,G2tensor(3),n2h1(9))
  call Hloop_AZ_Q(ntryL,G1H3(6),ex4(:),G1H1(17),ngZd,m3h3x1(:,12),heltab2x3(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),10,nMB,G2tensor(4),n2h1(10))
  call Hloop_QZ_A(ntryL,G1H3(18),ex4(:),G1H1(6),ngZd,m3h3x1(:,13),heltab2x3(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),31,nMB,G2tensor(5),n2h1(11))
  call Hloop_QZ_A(ntryL,G1H3(2),ex4(:),G1H1(17),ngZd,m3h3x1(:,14),heltab2x3(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),8,nMB,G2tensor(6),n2h1(12))
  call Hloop_QZ_A(ntryL,G1H3(26),ex4(:),G1H1(6),ngZd,m3h3x1(:,15),heltab2x3(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),31,nMB,G2tensor(7),n2h1(13))
  call Hloop_QZ_A(ntryL,G1H3(27),ex4(:),G1H1(17),ngZd,m3h3x1(:,16),heltab2x3(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),12,nMB,G2tensor(8),n2h1(14))
  call Hloop_QZ_A(ntryL,G1H3(31),ex4(:),G1H1(6),ngZd,m3h3x1(:,17),heltab2x3(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),31,nMB,G2tensor(9),n2h1(15))
  call Hloop_QZ_A(ntryL,G1H3(32),ex4(:),G1H1(17),ngZd,m3h3x1(:,18),heltab2x3(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),8,nMB,G2tensor(10),n2h1(16))
  call Hloop_QZ_A(ntryL,G1H3(37),ex4(:),G1H1(6),ngZd,m3h3x1(:,19),heltab2x3(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),31,nMB,G2tensor(11),n2h1(17))
  call Hloop_QZ_A(ntryL,G1H3(38),ex4(:),G1H1(17),ngZd,m3h3x1(:,20),heltab2x3(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),9,nMB,G2tensor(12),n2h1(18))
  call Hloop_QS_A(ntryL,G1H1(1),ex3(:),G1H1(6),ngH,m3h1x1(:,1),heltab2x1(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),31,nMB,G2tensor(13),n2h1(19))
  call Hloop_QS_A(ntryL,G1H1(2),ex3(:),G1H1(17),ngH,m3h1x1(:,2),heltab2x1(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),4,nMB,G2tensor(14),n2h1(20))
  call Hloop_QS_A(ntryL,G1H1(7),ex3(:),G1H1(1),ngH,m3h1x1(:,3),heltab2x1(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(15),n2h1(21))
  call Hloop_QS_A(ntryL,G1H1(8),ex3(:),G1H1(6),ngH,m3h1x1(:,4),heltab2x1(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),12,nMB,G2tensor(16),n2h1(22))
  call Hloop_AZ_Q(ntryL,G1H3(42),ex4(:),G1H1(2),ngZd,m3h3x1(:,21),heltab2x3(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),31,nMB,G2tensor(17),n2h1(23))
  call Hloop_AZ_Q(ntryL,G1H3(43),ex4(:),G1H1(17),ngZd,m3h3x1(:,22),heltab2x3(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),8,nMB,G2tensor(18),n2h1(24))
  call Hloop_AZ_Q(ntryL,G1H3(48),ex4(:),G1H1(7),ngZd,m3h3x1(:,23),heltab2x3(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(7),31,nMB,G2tensor(19),n2h1(25))
  call Hloop_AZ_Q(ntryL,G1H3(49),ex4(:),G1H1(1),ngZd,m3h3x1(:,24),heltab2x3(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMB,G2tensor(20),n2h1(26))
  call Hloop_AS_Q(ntryL,G1H1(12),ex3(:),G1H1(8),ngH,m3h1x1(:,5),heltab2x1(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(8),31,nMB,G2tensor(21),n2h1(27))
  call Hloop_AS_Q(ntryL,G1H1(13),ex3(:),G1H1(6),ngH,m3h1x1(:,6),heltab2x1(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(6),4,nMB,G2tensor(22),n2h1(28))
  call Hloop_AS_Q(ntryL,G1H1(18),ex3(:),G1H1(2),ngH,m3h1x1(:,7),heltab2x1(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),31,nMB,G2tensor(23),n2h1(29))
  call Hloop_AS_Q(ntryL,G1H1(19),ex3(:),G1H1(17),ngH,m3h1x1(:,8),heltab2x1(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),12,nMB,G2tensor(24),n2h1(30))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(2),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(3),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(4),mass5set(:,2),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),4)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(5),mass5set(:,2),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(6),mass5set(:,2),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(7),h0tab(:,7),[16,5,2,8],[nMB,0,nMB,nMB],4,1,wf2(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(1),ngZd,m3h3x12(:,7),heltab2x36(:,:,7))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(7),n2h12(9))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(8),h0tab(:,8),[16,2,5,8],[nMB,0,nMB,nMB],4,1,wf2(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(1),ngZd,m3h3x12(:,8),heltab2x36(:,:,8))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMB,G1H12(2),n2h12(10))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(9),h0tab(:,9),[16,6,1,8],[nMB,0,nMB,nMB],4,1,wf2(:,4))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(1),ngZd,m3h3x12(:,9),heltab2x36(:,:,9))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMB,G1H12(3),n2h12(11))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(10),h0tab(:,10),[16,1,6,8],[nMB,0,nMB,nMB],4,1,wf2(:,4))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(1),ngZd,m3h3x12(:,10),heltab2x36(:,:,10))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(1),n2h12(12))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(11),h0tab(:,11),[16,4,2,9],[nMB,nMB,0,nMB],4,1,wf6(:,8))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(1),ngZd,m3h3x12(:,11),heltab2x36(:,:,11))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMB,G1H12(4),n2h12(13))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(12),h0tab(:,12),[16,2,9,4],[nMB,0,nMB,nMB],4,1,wf6(:,8))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(1),ngZd,m3h3x12(:,12),heltab2x36(:,:,12))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMB,G1H12(5),n2h12(14))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(13),h0tab(:,13),[16,4,1,10],[nMB,nMB,0,nMB],4,1,wf6(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(1),ngZd,m3h3x12(:,13),heltab2x36(:,:,13))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(6),n2h12(15))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(14),h0tab(:,14),[16,1,10,4],[nMB,0,nMB,nMB],4,1,wf6(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(1),ngZd,m3h3x12(:,14),heltab2x36(:,:,14))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(8),n2h12(16))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(15),h0tab(:,15),[16,1,2,12],[nMB,0,nMB,nMB],4,1,wf3(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(1),ngZd,m3h3x12(:,15),heltab2x36(:,:,15))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(9),n2h12(17))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(16),h0tab(:,16),[16,2,1,12],[nMB,0,nMB,nMB],4,1,wf3(:,2))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(1),ngZd,m3h3x12(:,16),heltab2x36(:,:,16))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMB,G1H12(10),n2h12(18))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(17),h0tab(:,17),[17,2,4,8],[0,nMB,nMB,nMB],4,1,wf6(:,10))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,10),G0H6(1),m3h6x6(:,1),heltab2x36(:,:,17))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(18),h0tab(:,18),[17,2,8,4],[0,nMB,nMB,nMB],4,1,wf6(:,10))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,10),G0H6(2),m3h6x6(:,2),heltab2x36(:,:,18))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(19),h0tab(:,19),[18,1,4,8],[0,nMB,nMB,nMB],4,1,wf6(:,5))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,5),G0H6(3),m3h6x6(:,3),heltab2x36(:,:,19))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(20),h0tab(:,20),[18,1,8,4],[0,nMB,nMB,nMB],4,1,wf6(:,5))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,5),G0H6(4),m3h6x6(:,4),heltab2x36(:,:,20))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(21),h0tab(:,21),[20,2,1,8],[nMB,0,nMB,nMB],4,1,wf3(:,4))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,4),G0H12(1),ngZd,m3h3x12(:,17),heltab2x36(:,:,21))
  call Hloop_Q_A(ntryL,G0H12(1),20,nMB,G1H12(11),n2h12(19))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(22),h0tab(:,22),[20,1,2,8],[nMB,0,nMB,nMB],4,1,wf3(:,4))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf3(:,4),G0H12(1),ngZd,m3h3x12(:,18),heltab2x36(:,:,22))
  call Hloop_A_Q(ntryL,G0H12(1),20,nMB,G1H12(12),n2h12(20))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(23),h0tab(:,23),[24,2,1,4],[nMB,0,nMB,nMB],4,1,wf9(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,2),G0H4(1),ngH,m3h9x4(:,1),heltab2x36(:,:,23))
  call Hloop_Q_A(ntryL,G0H4(1),24,nMB,G1H4(1),n2h4(1))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(24),h0tab(:,24),[24,1,2,4],[nMB,0,nMB,nMB],4,1,wf9(:,2))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,2),G0H4(1),ngH,m3h9x4(:,2),heltab2x36(:,:,24))
  call Hloop_A_Q(ntryL,G0H4(1),24,nMB,G1H4(2),n2h4(2))
  call Hloop_AQ_V(ntryL,G1H12(7),wf2(:,2),G1H6(1),m3h2x6(:,7),heltab2x12(:,:,9))
  call Hloop_QA_V(ntryL,G1H12(2),ex2(:),G1H6(2),m3h2x6(:,8),heltab2x12(:,:,10))
  call Hloop_QA_V(ntryL,G1H12(3),wf2(:,4),G1H6(5),m3h2x6(:,9),heltab2x12(:,:,11))
  call Hloop_AQ_V(ntryL,G1H12(1),ex1(:),G1H6(6),m3h2x6(:,10),heltab2x12(:,:,12))
  call Hloop_QS_A(ntryL,G1H12(4),ex3(:),G1H12(7),ngH,m3h1x12(:,3),heltab2x12(:,:,13))
  call Hloop_Q_A(ntryL,G1H12(7),20,nMB,G2H12(1),n2h12(21))
  call Hloop_QA_V(ntryL,G1H12(5),ex2(:),G1H6(7),m3h2x6(:,11),heltab2x12(:,:,14))
  call Hloop_AS_Q(ntryL,G1H12(6),ex3(:),G1H12(2),ngH,m3h1x12(:,4),heltab2x12(:,:,15))
  call Hloop_A_Q(ntryL,G1H12(2),20,nMB,G2H12(2),n2h12(22))
  call Hloop_AQ_V(ntryL,G1H12(8),ex1(:),G1H6(8),m3h2x6(:,12),heltab2x12(:,:,16))
  call Hloop_AQ_V(ntryL,G1H12(9),ex1(:),G1H6(11),m3h2x6(:,13),heltab2x12(:,:,17))
  call Hloop_QA_V(ntryL,G1H12(10),ex2(:),G1H6(12),m3h2x6(:,14),heltab2x12(:,:,18))
  call Hloop_VA_Q(ntryL,G0H6(1),ex2(:),G0H3(1),m3h2x3(:,11),heltab2x6(:,:,13))
  call Hloop_A_Q(ntryL,G0H3(1),19,nMB,G1H3(12),n2h3(21))
  call Hloop_VA_Q(ntryL,G0H6(2),ex2(:),G0H3(1),m3h2x3(:,12),heltab2x6(:,:,14))
  call Hloop_A_Q(ntryL,G0H3(1),19,nMB,G1H3(24),n2h3(22))
  call Hloop_VQ_A(ntryL,G0H6(3),ex1(:),G0H3(1),m3h2x3(:,13),heltab2x6(:,:,15))
  call Hloop_Q_A(ntryL,G0H3(1),19,nMB,G1H3(36),n2h3(23))
  call Hloop_VQ_A(ntryL,G0H6(4),ex1(:),G0H3(1),m3h2x3(:,14),heltab2x6(:,:,16))
  call Hloop_Q_A(ntryL,G0H3(1),19,nMB,G1H3(47),n2h3(24))
  call Hloop_QA_V(ntryL,G1H12(11),ex2(:),G1H6(13),m3h2x6(:,15),heltab2x12(:,:,19))
  call Hloop_AQ_V(ntryL,G1H12(12),ex1(:),G1H6(14),m3h2x6(:,16),heltab2x12(:,:,20))
  call Hloop_QA_V(ntryL,G1H4(1),ex2(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_V(ntryL,G1H4(2),ex1(:),G1H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(14),[G1H6(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(1),[G1H6(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(36),[G1H3(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(13),[G1H6(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(5),[G1H6(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(47),[G1H3(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(12),[G1H3(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(24),[G1H3(21)])
  call Hloop_VA_Q(ntryL,G1H6(14),ex2(:),G1H3(5),m3h2x3(:,15),heltab2x6(:,:,17))
  call Hloop_A_Q(ntryL,G1H3(5),23,nMB,G2H3(14),n2h3(25))
  call Hloop_VA_Q(ntryL,G1H6(1),ex2(:),G1H3(1),m3h2x3(:,16),heltab2x6(:,:,18))
  call Hloop_A_Q(ntryL,G1H3(1),23,nMB,G2H3(1),n2h3(26))
  call Hloop_QS_A(ntryL,G1H3(36),ex3(:),G1H3(13),ngH,m3h1x3(:,9),heltab2x3(:,:,33))
  call Hloop_Q_A(ntryL,G1H3(13),23,nMB,G2H3(3),n2h3(27))
  call Hloop_QS_A(ntryL,G1H3(4),ex3(:),G1H3(6),ngH,m3h1x3(:,10),heltab2x3(:,:,34))
  call Hloop_Q_A(ntryL,G1H3(6),23,nMB,G2H3(4),n2h3(28))
  call Hloop_VQ_A(ntryL,G1H6(13),ex1(:),G1H3(18),m3h2x3(:,17),heltab2x6(:,:,19))
  call Hloop_Q_A(ntryL,G1H3(18),23,nMB,G2H3(6),n2h3(29))
  call Hloop_VQ_A(ntryL,G1H6(5),ex1(:),G1H3(2),m3h2x3(:,18),heltab2x6(:,:,20))
  call Hloop_Q_A(ntryL,G1H3(2),23,nMB,G2H3(7),n2h3(30))
  call Hloop_QZ_A(ntryL,G1H3(47),ex4(:),G1H1(7),ngZd,m3h3x1(:,25),heltab2x3(:,:,35))
  call Hloop_Q_A(ntryL,G1H1(7),27,nMB,G2H1(2),n2h1(31))
  call Hloop_QZ_A(ntryL,G1H3(10),ex4(:),G1H1(1),ngZd,m3h3x1(:,26),heltab2x3(:,:,36))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMB,G2H1(4),n2h1(32))
  call Hloop_AS_Q(ntryL,G1H3(12),ex3(:),G1H3(26),ngH,m3h1x3(:,11),heltab2x3(:,:,37))
  call Hloop_A_Q(ntryL,G1H3(26),23,nMB,G2H3(9),n2h3(31))
  call Hloop_AS_Q(ntryL,G1H3(16),ex3(:),G1H3(27),ngH,m3h1x3(:,12),heltab2x3(:,:,38))
  call Hloop_A_Q(ntryL,G1H3(27),23,nMB,G2H3(10),n2h3(32))
  call Hloop_AZ_Q(ntryL,G1H3(24),ex4(:),G1H1(12),ngZd,m3h3x1(:,27),heltab2x3(:,:,39))
  call Hloop_A_Q(ntryL,G1H1(12),27,nMB,G2H1(6),n2h1(33))
  call Hloop_AZ_Q(ntryL,G1H3(22),ex4(:),G1H1(8),ngZd,m3h3x1(:,28),heltab2x3(:,:,40))
  call Hloop_A_Q(ntryL,G1H1(8),27,nMB,G2H1(8),n2h1(34))
  call Hloop_VQ_A(ntryL,G1H6(2),wf2(:,2),G1H3(31),m3h2x3(:,19),heltab2x6(:,:,21))
  call Hloop_Q_A(ntryL,G1H3(31),23,nMB,G2H3(13),n2h3(33))
  call Hloop_VA_Q(ntryL,G1H6(6),wf2(:,4),G1H3(32),m3h2x3(:,20),heltab2x6(:,:,22))
  call Hloop_A_Q(ntryL,G1H3(32),23,nMB,G2H3(16),n2h3(34))
  call Hloop_QA_V(ntryL,G2H12(1),ex2(:),G2H6(1),m3h2x6(:,17),heltab2x12(:,:,21))
  call Hloop_VQ_A(ntryL,G1H6(7),wf6(:,8),G1H1(13),m3h6x1(:,1),heltab2x6(:,:,23))
  call Hloop_Q_A(ntryL,G1H1(13),27,nMB,G2H1(9),n2h1(35))
  call Hloop_AQ_V(ntryL,G2H12(2),ex1(:),G2H6(2),m3h2x6(:,18),heltab2x12(:,:,22))
  call Hloop_VA_Q(ntryL,G1H6(8),wf6(:,2),G1H1(6),m3h6x1(:,2),heltab2x6(:,:,24))
  call Hloop_A_Q(ntryL,G1H1(6),27,nMB,G2H1(10),n2h1(36))
  call Hloop_VA_Q(ntryL,G1H6(11),ex2(:),G1H3(37),m3h2x3(:,21),heltab2x6(:,:,25))
  call Hloop_A_Q(ntryL,G1H3(37),19,nMB,G2H3(17),n2h3(35))
  call Hloop_VQ_A(ntryL,G1H6(12),ex1(:),G1H3(38),m3h2x3(:,22),heltab2x6(:,:,26))
  call Hloop_Q_A(ntryL,G1H3(38),19,nMB,G2H3(18),n2h3(36))
  call Hloop_VQ_A(ntryL,G1H2(1),ex1(:),G1H1(18),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hloop_Q_A(ntryL,G1H1(18),27,nMB,G2H1(11),n2h1(37))
  call Hloop_VA_Q(ntryL,G1H2(2),ex2(:),G1H1(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hloop_A_Q(ntryL,G1H1(2),27,nMB,G2H1(12),n2h1(38))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(2),[G1H3(11)])
call HGT_OLR(G2H1(1),1,1,1)
call HGT_invQ_OLR(G2H1(1),2,5,1)
call HGT_OLR(G2H1(1),6,15,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(1),[G2H1(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(13),[G2H3(5),G1H3(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(8),[G1H3(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(6),[G1H3(33)])
call HGT_OLR(G2H3(11),1,1,3)
call HGT_invQ_OLR(G2H3(11),2,5,3)
call HGT_OLR(G2H3(11),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(11),[G2H3(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(9),[G2H1(3),G1H1(5)])
call HGT_OLR(G2H1(5),1,1,1)
call HGT_invQ_OLR(G2H1(5),2,5,1)
call HGT_OLR(G2H1(5),6,15,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(5),[G2H1(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(16),[G2H3(12),G1H3(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(14),[G1H3(7)])
call HGT_OLR(G2H3(15),1,1,3)
call HGT_invQ_OLR(G2H3(15),2,5,3)
call HGT_OLR(G2H3(15),6,15,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(15),[G2H3(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(10),[G2H1(7),G1H1(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(1),[G1H3(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(3),[G1H3(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(4),[G1H3(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(7),[G1H3(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(2),[G1H1(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(4),[G1H1(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(9),[G1H3(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(10),[G1H3(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(6),[G1H1(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(8),[G1H1(15)])
call HGT_OLR(G2H2(1),1,1,2)
call HGT_invQ_OLR(G2H2(1),2,5,2)
call HGT_OLR(G2H2(1),6,15,2)
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(26),mass4set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),2)
  call HG1shiftOLR(G1H2(2),2,2)
  call Hotf_4pt_reduction(G2H3(2),RedSet_4(7),mass4set(:,3),  & 
G1H3(42),G1H3(43),G1H3(48),G1H3(49),G1H3(3),3)
  call HG1shiftOLR(G1H3(43),8,3)
  call Hotf_4pt_reduction(G2H1(1),RedSet_4(27),mass4set(:,2),  & 
G1H1(19),G1H1(17),G1H1(7),G1H1(1),G1H1(12),1)
  call HG1shiftOLR(G1H1(17),4,1)
  call Hotf_4pt_reduction(G2H3(13),RedSet_4(11),mass4set(:,2),  & 
G1H3(9),G1H3(15),G1H3(21),G1H3(5),G1H3(1),3)
  call HG1shiftOLR(G1H3(15),8,3)
call HGT_OLR(G2H2(2),1,1,2)
call HGT_invQ_OLR(G2H2(2),2,5,2)
call HGT_OLR(G2H2(2),6,15,2)
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(28),mass4set(:,1),  & 
G1H2(6),G1H2(7),G1H2(8),G1H2(9),G1H2(10),2)
  call HG1shiftOLR(G1H2(7),1,2)
  call Hotf_4pt_reduction(G2H3(8),RedSet_4(7),mass4set(:,3),  & 
G1H3(36),G1H3(13),G1H3(4),G1H3(6),G1H3(18),3)
  call HG1shiftOLR(G1H3(13),8,3)
  call Hotf_4pt_reduction(G2H3(11),RedSet_4(13),mass4set(:,2),  & 
G1H3(2),G1H3(47),G1H3(10),G1H3(12),G1H3(26),3)
  call HG1shiftOLR(G1H3(47),8,3)
  call Hotf_4pt_reduction(G2H1(9),RedSet_4(18),mass4set(:,2),  & 
G1H1(8),G1H1(13),G1H1(6),G1H1(18),G1H1(2),1)
  call HG1shiftOLR(G1H1(13),4,1)
  call Hotf_4pt_reduction(G2H1(5),RedSet_4(29),mass4set(:,2),  & 
G1H1(5),G1H1(16),G1H1(3),G1H1(4),G1H1(14),1)
  call HG1shiftOLR(G1H1(16),4,1)
  call Hotf_4pt_reduction(G2H3(16),RedSet_4(21),mass4set(:,2),  & 
G1H3(16),G1H3(27),G1H3(24),G1H3(22),G1H3(31),3)
  call HG1shiftOLR(G1H3(27),8,3)
  call Hotf_4pt_reduction(G2H3(15),RedSet_4(5),mass4set(:,2),  & 
G1H3(32),G1H3(37),G1H3(38),G1H3(11),G1H3(23),3)
  call HG1shiftOLR(G1H3(37),8,3)
  call Hotf_4pt_reduction(G2H1(10),RedSet_4(24),mass4set(:,2),  & 
G1H1(15),G1H1(23),G1H1(24),G1H1(25),G1H1(26),1)
  call HG1shiftOLR(G1H1(23),4,1)
  call Hotf_4pt_reduction(G2H3(1),RedSet_4(6),mass4set(:,2),  & 
G1H3(35),G1H3(33),G1H3(46),G1H3(7),G1H3(8),3)
  call HG1shiftOLR(G1H3(33),8,3)
  call Hloop_AZ_Q(ntryL,G1H3(14),ex4(:),G1H1(27),ngZd,m3h3x1(:,29),heltab2x3(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(27),31,nMB,G2tensor(1),n2h1(39))
  call Hloop_AZ_Q(ntryL,G1H3(17),ex4(:),G1H1(27),ngZd,m3h3x1(:,30),heltab2x3(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(27),31,nMB,G2tensor(5),n2h1(40))
  call Hloop_AZ_Q(ntryL,G1H3(25),ex4(:),G1H1(27),ngZd,m3h3x1(:,31),heltab2x3(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(27),31,nMB,G2tensor(9),n2h1(41))
  call Hotf_4pt_reduction(G2H3(3),RedSet_4(9),mass4set(:,4),  & 
G1H3(19),G1H3(20),G1H3(34),G1H3(44),G1H3(45),3)
  call HG1shiftOLR(G1H3(20),8,3)
  call Hotf_4pt_reduction(G2H3(4),RedSet_4(10),mass4set(:,3),  & 
G1H3(14),G1H3(17),G1H3(25),G1H3(53),G1H3(54),3)
  call HG1shiftOLR(G1H3(17),8,3)
  call Hloop_QZ_A(ntryL,G1H3(28),ex4(:),G1H1(27),ngZd,m3h3x1(:,32),heltab2x3(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(27),31,nMB,G2tensor(13),n2h1(42))
  call Hloop_QZ_A(ntryL,G1H3(29),ex4(:),G1H1(27),ngZd,m3h3x1(:,33),heltab2x3(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(27),31,nMB,G2tensor(17),n2h1(43))
  call Hloop_QZ_A(ntryL,G1H3(30),ex4(:),G1H1(27),ngZd,m3h3x1(:,34),heltab2x3(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(27),31,nMB,G2tensor(21),n2h1(44))
  call Hotf_4pt_reduction(G2H3(7),RedSet_4(14),mass4set(:,2),  & 
G1H3(28),G1H3(29),G1H3(30),G1H3(55),G1H3(56),3)
  call HG1shiftOLR(G1H3(29),8,3)
  call Hloop_QZ_A(ntryL,G1H3(39),ex4(:),G1H1(27),ngZd,m3h3x1(:,35),heltab2x3(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(27),31,nMB,G2tensor(25),n2h1(45))
  call Hloop_QZ_A(ntryL,G1H3(40),ex4(:),G1H1(27),ngZd,m3h3x1(:,36),heltab2x3(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(27),31,nMB,G2tensor(26),n2h1(46))
  call Hloop_QZ_A(ntryL,G1H3(41),ex4(:),G1H1(27),ngZd,m3h3x1(:,37),heltab2x3(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(27),31,nMB,G2tensor(27),n2h1(47))
  call Hotf_4pt_reduction(G2H1(2),RedSet_4(16),mass4set(:,4),  & 
G1H1(27),G1H1(28),G1H1(29),G1H1(30),G1H1(31),1)
  call HG1shiftOLR(G1H1(28),4,1)
  call Hotf_4pt_reduction(G2H1(4),RedSet_4(17),mass4set(:,3),  & 
G1H1(32),G1H1(33),G1H1(34),G1H1(35),G1H1(36),1)
  call HG1shiftOLR(G1H1(33),4,1)
  call Hloop_QS_A(ntryL,G1H1(9),ex3(:),G1H1(37),ngH,m3h1x1(:,9),heltab2x1(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(37),31,nMB,G2tensor(28),n2h1(48))
  call Hloop_QS_A(ntryL,G1H1(10),ex3(:),G1H1(9),ngH,m3h1x1(:,10),heltab2x1(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),31,nMB,G2tensor(29),n2h1(49))
  call Hloop_QS_A(ntryL,G1H1(11),ex3(:),G1H1(37),ngH,m3h1x1(:,11),heltab2x1(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(37),31,nMB,G2tensor(30),n2h1(50))
  call Hotf_4pt_reduction(G2H3(9),RedSet_4(20),mass4set(:,4),  & 
G1H3(39),G1H3(40),G1H3(41),G1H3(57),G1H3(58),3)
  call HG1shiftOLR(G1H3(40),8,3)
  call Hotf_4pt_reduction(G2H3(10),RedSet_4(10),mass4set(:,3),  & 
G1H3(59),G1H3(60),G1H3(61),G1H3(62),G1H3(63),3)
  call HG1shiftOLR(G1H3(60),8,3)
  call Hloop_AZ_Q(ntryL,G1H3(50),ex4(:),G1H1(10),ngZd,m3h3x1(:,38),heltab2x3(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(10),31,nMB,G2tensor(31),n2h1(51))
  call Hloop_AZ_Q(ntryL,G1H3(51),ex4(:),G1H1(9),ngZd,m3h3x1(:,39),heltab2x3(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),31,nMB,G2tensor(32),n2h1(52))
  call Hloop_AZ_Q(ntryL,G1H3(52),ex4(:),G1H1(11),ngZd,m3h3x1(:,40),heltab2x3(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(11),31,nMB,G2tensor(33),n2h1(53))
  call Hotf_4pt_reduction(G2H1(6),RedSet_4(23),mass4set(:,4),  & 
G1H1(37),G1H1(10),G1H1(9),G1H1(11),G1H1(38),1)
  call HG1shiftOLR(G1H1(10),4,1)
  call Hotf_4pt_reduction(G2H1(8),RedSet_4(17),mass4set(:,3),  & 
G1H1(39),G1H1(40),G1H1(41),G1H1(42),G1H1(43),1)
  call HG1shiftOLR(G1H1(40),4,1)
  call Hloop_AS_Q(ntryL,G1H1(20),ex3(:),G1H1(44),ngH,m3h1x1(:,12),heltab2x1(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(44),31,nMB,G2tensor(34),n2h1(54))
  call Hloop_AS_Q(ntryL,G1H1(21),ex3(:),G1H1(20),ngH,m3h1x1(:,13),heltab2x1(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(20),31,nMB,G2tensor(35),n2h1(55))
  call Hloop_AS_Q(ntryL,G1H1(22),ex3(:),G1H1(44),ngH,m3h1x1(:,14),heltab2x1(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(44),31,nMB,G2tensor(36),n2h1(56))
  call Hotf_4pt_reduction(G2H6(1),RedSet_4(3),mass4set(:,1),  & 
G1H6(3),G1H6(4),G1H6(9),G1H6(10),G1H6(14),6)
  call HG1shiftOLR(G1H6(4),9,6)
  call Hotf_4pt_reduction(G2H6(2),RedSet_4(1),mass4set(:,1),  & 
G1H6(1),G1H6(13),G1H6(5),G1H6(2),G1H6(6),6)
  call HG1shiftOLR(G1H6(13),10,6)
  call Hotf_4pt_reduction(G2H3(17),RedSet_4(4),mass4set(:,2),  & 
G1H3(50),G1H3(51),G1H3(52),G1H3(64),G1H3(65),3)
  call HG1shiftOLR(G1H3(51),12,3)
  call Hotf_4pt_reduction(G2H3(18),RedSet_4(2),mass4set(:,2),  & 
G1H3(66),G1H3(67),G1H3(68),G1H3(69),G1H3(70),3)
  call HG1shiftOLR(G1H3(67),12,3)
  call Hloop_VA_Q(ntryL,G1H2(1),ex2(:),G1H1(21),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(21),31,nMB,G2tensor(37),n2h1(57))
  call Hloop_VA_Q(ntryL,G1H2(2),ex2(:),G1H1(20),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(20),2,nMB,G2tensor(38),n2h1(58))
  call Hloop_VA_Q(ntryL,G1H2(5),ex2(:),G1H1(22),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(22),31,nMB,G2tensor(39),n2h1(59))
  call Hloop_AZ_Q(ntryL,G1H3(42),ex4(:),G1H1(44),ngZd,m3h3x1(:,41),heltab2x3(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(44),31,nMB,G2tensor(40),n2h1(60))
  call Hloop_AZ_Q(ntryL,G1H3(43),ex4(:),G1H1(21),ngZd,m3h3x1(:,42),heltab2x3(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(21),8,nMB,G2tensor(41),n2h1(61))
  call Hloop_AZ_Q(ntryL,G1H3(3),ex4(:),G1H1(20),ngZd,m3h3x1(:,43),heltab2x3(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(20),31,nMB,G2tensor(42),n2h1(62))
  call Hloop_QS_A(ntryL,G1H1(19),ex3(:),G1H1(22),ngH,m3h1x1(:,15),heltab2x1(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(22),31,nMB,G2tensor(43),n2h1(63))
  call Hloop_QS_A(ntryL,G1H1(17),ex3(:),G1H1(44),ngH,m3h1x1(:,16),heltab2x1(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(44),4,nMB,G2tensor(44),n2h1(64))
  call Hloop_QS_A(ntryL,G1H1(12),ex3(:),G1H1(21),ngH,m3h1x1(:,17),heltab2x1(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(21),31,nMB,G2tensor(45),n2h1(65))
  call Hloop_QZ_A(ntryL,G1H3(9),ex4(:),G1H1(20),ngZd,m3h3x1(:,44),heltab2x3(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(20),31,nMB,G2tensor(46),n2h1(66))
  call Hloop_QZ_A(ntryL,G1H3(15),ex4(:),G1H1(19),ngZd,m3h3x1(:,45),heltab2x3(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),8,nMB,G2tensor(47),n2h1(67))
  call Hloop_QZ_A(ntryL,G1H3(1),ex4(:),G1H1(22),ngZd,m3h3x1(:,46),heltab2x3(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(22),31,nMB,G2tensor(48),n2h1(68))
  call Hloop_VQ_A(ntryL,G1H2(6),ex1(:),G1H1(17),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),31,nMB,G2tensor(49),n2h1(69))
  call Hloop_VQ_A(ntryL,G1H2(7),ex1(:),G1H1(44),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(44),1,nMB,G2tensor(50),n2h1(70))
  call Hloop_VQ_A(ntryL,G1H2(10),ex1(:),G1H1(12),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(12),31,nMB,G2tensor(51),n2h1(71))
  call Hloop_QZ_A(ntryL,G1H3(36),ex4(:),G1H1(21),ngZd,m3h3x1(:,47),heltab2x3(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(21),31,nMB,G2tensor(52),n2h1(72))
  call Hloop_QZ_A(ntryL,G1H3(13),ex4(:),G1H1(20),ngZd,m3h3x1(:,48),heltab2x3(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(20),8,nMB,G2tensor(53),n2h1(73))
  call Hloop_QZ_A(ntryL,G1H3(18),ex4(:),G1H1(19),ngZd,m3h3x1(:,49),heltab2x3(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(54),n2h1(74))
  call Hloop_QZ_A(ntryL,G1H3(2),ex4(:),G1H1(22),ngZd,m3h3x1(:,50),heltab2x3(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(22),31,nMB,G2tensor(55),n2h1(75))
  call Hloop_QZ_A(ntryL,G1H3(47),ex4(:),G1H1(17),ngZd,m3h3x1(:,51),heltab2x3(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),8,nMB,G2tensor(56),n2h1(76))
  call Hloop_QZ_A(ntryL,G1H3(26),ex4(:),G1H1(44),ngZd,m3h3x1(:,52),heltab2x3(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(44),31,nMB,G2tensor(57),n2h1(77))
  call Hloop_QS_A(ntryL,G1H1(8),ex3(:),G1H1(12),ngH,m3h1x1(:,18),heltab2x1(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(12),31,nMB,G2tensor(58),n2h1(78))
  call Hloop_QS_A(ntryL,G1H1(13),ex3(:),G1H1(21),ngH,m3h1x1(:,19),heltab2x1(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(21),4,nMB,G2tensor(59),n2h1(79))
  call Hloop_QS_A(ntryL,G1H1(2),ex3(:),G1H1(20),ngH,m3h1x1(:,20),heltab2x1(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(20),31,nMB,G2tensor(60),n2h1(80))
  call Hloop_AS_Q(ntryL,G1H1(5),ex3(:),G1H1(19),ngH,m3h1x1(:,21),heltab2x1(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(61),n2h1(81))
  call Hloop_AS_Q(ntryL,G1H1(16),ex3(:),G1H1(22),ngH,m3h1x1(:,22),heltab2x1(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(22),4,nMB,G2tensor(62),n2h1(82))
  call Hloop_AS_Q(ntryL,G1H1(14),ex3(:),G1H1(17),ngH,m3h1x1(:,23),heltab2x1(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),31,nMB,G2tensor(63),n2h1(83))
  call Hloop_AZ_Q(ntryL,G1H3(16),ex4(:),G1H1(44),ngZd,m3h3x1(:,53),heltab2x3(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(44),31,nMB,G2tensor(64),n2h1(84))
  call Hloop_AZ_Q(ntryL,G1H3(27),ex4(:),G1H1(8),ngZd,m3h3x1(:,54),heltab2x3(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(8),8,nMB,G2tensor(65),n2h1(85))
  call Hloop_AZ_Q(ntryL,G1H3(31),ex4(:),G1H1(12),ngZd,m3h3x1(:,55),heltab2x3(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(12),31,nMB,G2tensor(66),n2h1(86))
  call Hloop_AZ_Q(ntryL,G1H3(32),ex4(:),G1H1(13),ngZd,m3h3x1(:,56),heltab2x3(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(13),31,nMB,G2tensor(67),n2h1(87))
  call Hloop_AZ_Q(ntryL,G1H3(37),ex4(:),G1H1(21),ngZd,m3h3x1(:,57),heltab2x3(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(21),8,nMB,G2tensor(68),n2h1(88))
  call Hloop_AZ_Q(ntryL,G1H3(23),ex4(:),G1H1(2),ngZd,m3h3x1(:,58),heltab2x3(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),31,nMB,G2tensor(69),n2h1(89))
  call Hloop_AS_Q(ntryL,G1H1(15),ex3(:),G1H1(20),ngH,m3h1x1(:,24),heltab2x1(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(20),31,nMB,G2tensor(70),n2h1(90))
  call Hloop_AS_Q(ntryL,G1H1(23),ex3(:),G1H1(5),ngH,m3h1x1(:,25),heltab2x1(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(5),4,nMB,G2tensor(71),n2h1(91))
  call Hloop_AS_Q(ntryL,G1H1(26),ex3(:),G1H1(19),ngH,m3h1x1(:,26),heltab2x1(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(72),n2h1(92))
  call Hloop_AZ_Q(ntryL,G1H3(35),ex4(:),G1H1(16),ngZd,m3h3x1(:,59),heltab2x3(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(16),31,nMB,G2tensor(73),n2h1(93))
  call Hloop_AZ_Q(ntryL,G1H3(33),ex4(:),G1H1(22),ngZd,m3h3x1(:,60),heltab2x3(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(22),8,nMB,G2tensor(74),n2h1(94))
  call Hloop_AZ_Q(ntryL,G1H3(8),ex4(:),G1H1(14),ngZd,m3h3x1(:,61),heltab2x3(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(14),31,nMB,G2tensor(75),n2h1(95))
  call Hloop_QZ_A(ntryL,G1H3(19),ex4(:),G1H1(17),ngZd,m3h3x1(:,62),heltab2x3(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),31,nMB,G2tensor(76),n2h1(96))
  call Hloop_QZ_A(ntryL,G1H3(20),ex4(:),G1H1(44),ngZd,m3h3x1(:,63),heltab2x3(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(44),8,nMB,G2tensor(77),n2h1(97))
  call Hloop_QZ_A(ntryL,G1H3(45),ex4(:),G1H1(8),ngZd,m3h3x1(:,64),heltab2x3(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),31,nMB,G2tensor(78),n2h1(98))
  call Hloop_QZ_A(ntryL,G1H3(14),ex4(:),G1H1(12),ngZd,m3h3x1(:,65),heltab2x3(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(12),31,nMB,G2tensor(79),n2h1(99))
  call Hloop_QZ_A(ntryL,G1H3(17),ex4(:),G1H1(13),ngZd,m3h3x1(:,66),heltab2x3(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(13),8,nMB,G2tensor(80),n2h1(100))
  call Hloop_QZ_A(ntryL,G1H3(54),ex4(:),G1H1(21),ngZd,m3h3x1(:,67),heltab2x3(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(21),31,nMB,G2tensor(81),n2h1(101))
  call Hloop_QZ_A(ntryL,G1H3(28),ex4(:),G1H1(2),ngZd,m3h3x1(:,68),heltab2x3(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(2),31,nMB,G2tensor(82),n2h1(102))
  call Hloop_QZ_A(ntryL,G1H3(29),ex4(:),G1H1(15),ngZd,m3h3x1(:,69),heltab2x3(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(15),8,nMB,G2tensor(83),n2h1(103))
  call Hloop_QZ_A(ntryL,G1H3(56),ex4(:),G1H1(20),ngZd,m3h3x1(:,70),heltab2x3(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(20),31,nMB,G2tensor(84),n2h1(104))
  call Hloop_QS_A(ntryL,G1H1(27),ex3(:),G1H1(23),ngH,m3h1x1(:,27),heltab2x1(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(23),31,nMB,G2tensor(85),n2h1(105))
  call Hloop_QS_A(ntryL,G1H1(28),ex3(:),G1H1(5),ngH,m3h1x1(:,28),heltab2x1(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(5),4,nMB,G2tensor(86),n2h1(106))
  call Hloop_QS_A(ntryL,G1H1(31),ex3(:),G1H1(26),ngH,m3h1x1(:,29),heltab2x1(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(26),31,nMB,G2tensor(87),n2h1(107))
  call Hloop_QS_A(ntryL,G1H1(32),ex3(:),G1H1(19),ngH,m3h1x1(:,30),heltab2x1(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(88),n2h1(108))
  call Hloop_QS_A(ntryL,G1H1(33),ex3(:),G1H1(16),ngH,m3h1x1(:,31),heltab2x1(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(16),4,nMB,G2tensor(89),n2h1(109))
  call Hloop_QS_A(ntryL,G1H1(36),ex3(:),G1H1(22),ngH,m3h1x1(:,32),heltab2x1(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(22),31,nMB,G2tensor(90),n2h1(110))
  call Hloop_AZ_Q(ntryL,G1H3(39),ex4(:),G1H1(14),ngZd,m3h3x1(:,71),heltab2x3(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(14),31,nMB,G2tensor(91),n2h1(111))
  call Hloop_AZ_Q(ntryL,G1H3(40),ex4(:),G1H1(17),ngZd,m3h3x1(:,72),heltab2x3(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),8,nMB,G2tensor(92),n2h1(112))
  call Hloop_AZ_Q(ntryL,G1H3(58),ex4(:),G1H1(44),ngZd,m3h3x1(:,73),heltab2x3(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(44),31,nMB,G2tensor(93),n2h1(113))
  call Hloop_AZ_Q(ntryL,G1H3(59),ex4(:),G1H1(8),ngZd,m3h3x1(:,74),heltab2x3(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(8),31,nMB,G2tensor(94),n2h1(114))
  call Hloop_AZ_Q(ntryL,G1H3(60),ex4(:),G1H1(12),ngZd,m3h3x1(:,75),heltab2x3(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(12),8,nMB,G2tensor(95),n2h1(115))
  call Hloop_AZ_Q(ntryL,G1H3(63),ex4(:),G1H1(13),ngZd,m3h3x1(:,76),heltab2x3(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(13),31,nMB,G2tensor(96),n2h1(116))
  call Hloop_AS_Q(ntryL,G1H1(37),ex3(:),G1H1(21),ngH,m3h1x1(:,33),heltab2x1(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(21),31,nMB,G2tensor(97),n2h1(117))
  call Hloop_AS_Q(ntryL,G1H1(10),ex3(:),G1H1(2),ngH,m3h1x1(:,34),heltab2x1(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),4,nMB,G2tensor(98),n2h1(118))
  call Hloop_AS_Q(ntryL,G1H1(38),ex3(:),G1H1(15),ngH,m3h1x1(:,35),heltab2x1(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(15),31,nMB,G2tensor(99),n2h1(119))
  call Hloop_AS_Q(ntryL,G1H1(39),ex3(:),G1H1(20),ngH,m3h1x1(:,36),heltab2x1(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(20),31,nMB,G2tensor(100),n2h1(120))
  call Hloop_AS_Q(ntryL,G1H1(40),ex3(:),G1H1(27),ngH,m3h1x1(:,37),heltab2x1(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(27),4,nMB,G2tensor(101),n2h1(121))
  call Hloop_AS_Q(ntryL,G1H1(43),ex3(:),G1H1(23),ngH,m3h1x1(:,38),heltab2x1(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(23),31,nMB,G2tensor(102),n2h1(122))
  call Hloop_VQ_A(ntryL,G1H6(3),wf6(:,8),G1H1(28),m3h6x1(:,3),heltab2x6(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(28),31,nMB,G2tensor(103),n2h1(123))
  call Hloop_VQ_A(ntryL,G1H6(4),wf6(:,8),G1H1(5),m3h6x1(:,4),heltab2x6(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(5),9,nMB,G2tensor(104),n2h1(124))
  call Hloop_VQ_A(ntryL,G1H6(14),wf6(:,8),G1H1(31),m3h6x1(:,5),heltab2x6(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(31),31,nMB,G2tensor(105),n2h1(125))
  call Hloop_VA_Q(ntryL,G1H6(1),wf6(:,2),G1H1(26),m3h6x1(:,6),heltab2x6(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(26),31,nMB,G2tensor(106),n2h1(126))
  call Hloop_VA_Q(ntryL,G1H6(13),wf6(:,2),G1H1(32),m3h6x1(:,7),heltab2x6(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(32),10,nMB,G2tensor(107),n2h1(127))
  call Hloop_VA_Q(ntryL,G1H6(6),wf6(:,2),G1H1(19),m3h6x1(:,8),heltab2x6(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(108),n2h1(128))
  call Hloop_AZ_Q(ntryL,G1H3(50),wf3(:,2),G1H1(33),ngZd,m3h3x1(:,77),heltab2x3(:,:,89))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(33),31,nMB,G2tensor(109),n2h1(129))
  call Hloop_AZ_Q(ntryL,G1H3(51),wf3(:,2),G1H1(16),ngZd,m3h3x1(:,78),heltab2x3(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(16),12,nMB,G2tensor(110),n2h1(130))
  call Hloop_AZ_Q(ntryL,G1H3(65),wf3(:,2),G1H1(36),ngZd,m3h3x1(:,79),heltab2x3(:,:,91))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(36),31,nMB,G2tensor(111),n2h1(131))
  call Hloop_QZ_A(ntryL,G1H3(66),wf3(:,2),G1H1(22),ngZd,m3h3x1(:,80),heltab2x3(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(22),31,nMB,G2tensor(112),n2h1(132))
  call Hloop_QZ_A(ntryL,G1H3(67),wf3(:,2),G1H1(14),ngZd,m3h3x1(:,81),heltab2x3(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(14),12,nMB,G2tensor(113),n2h1(133))
  call Hloop_QZ_A(ntryL,G1H3(70),wf3(:,2),G1H1(17),ngZd,m3h3x1(:,82),heltab2x3(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),31,nMB,G2tensor(114),n2h1(134))
  call ol_merge_tensors(G2tensor(37),[G2tensor(2),G1tensor(2)])
  call ol_merge_tensors(G2tensor(106),[G2tensor(3),G1tensor(6)])
  call ol_merge_tensors(G2tensor(43),[G2tensor(6),G1tensor(8)])
  call ol_merge_tensors(G2tensor(112),[G2tensor(15),G2tensor(7),G1tensor(24),G1tensor(12)])
  call ol_merge_tensors(G2tensor(49),[G2tensor(10),G1tensor(14)])
  call ol_merge_tensors(G2tensor(103),[G2tensor(11),G1tensor(18)])
  call ol_merge_tensors(G2tensor(55),[G2tensor(14),G1tensor(20),G1tensor(15)])
  call ol_merge_tensors(G2tensor(61),[G2tensor(18),G1tensor(26)])
  call ol_merge_tensors(G2tensor(109),[G2tensor(23),G2tensor(19),G1tensor(36),G1tensor(30)])
  call ol_merge_tensors(G2tensor(67),[G2tensor(22),G1tensor(32),G1tensor(3)])
  call ol_merge_tensors(G2tensor(73),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(52),[G2tensor(40),G1tensor(17),G1tensor(5)])
  call ol_merge_tensors(G2tensor(76),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(94),[G2tensor(79),G1tensor(28),G1tensor(10)])
  call ol_merge_tensors(G2tensor(46),[G1tensor(11)])
  call ol_merge_tensors(G2tensor(82),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(85),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(100),[G2tensor(88),G1tensor(34),G1tensor(22)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(23)])
  call ol_merge_tensors(G2tensor(91),[G1tensor(27)])
  call ol_merge_tensors(G2tensor(64),[G1tensor(29)])
  call ol_merge_tensors(G2tensor(97),[G1tensor(33)])
  call ol_merge_tensors(G2tensor(70),[G1tensor(35)])
  call Hotf_4pt_reduction_last(G2tensor(37),RedSet_4(26),mass4set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25))
  call G_TensorShift(G1tensor(7),2)
  call Hotf_4pt_reduction_last(G2tensor(106),RedSet_4(1),mass4set(:,1),  & 
G1tensor(31),G1tensor(2),G1tensor(6),G1tensor(8),G1tensor(24))
  call G_TensorShift(G1tensor(2),10)
  call Hotf_4pt_reduction_last(G2tensor(43),RedSet_4(27),mass4set(:,2),  & 
G1tensor(12),G1tensor(14),G1tensor(18),G1tensor(20),G1tensor(15))
  call G_TensorShift(G1tensor(14),4)
  call Hotf_4pt_reduction_last(G2tensor(112),RedSet_4(2),mass4set(:,2),  & 
G1tensor(26),G1tensor(36),G1tensor(30),G1tensor(32),G1tensor(3))
  call G_TensorShift(G1tensor(36),12)
  call Hotf_4pt_reduction_last(G2tensor(49),RedSet_4(28),mass4set(:,1),  & 
G1tensor(4),G1tensor(17),G1tensor(5),G1tensor(9),G1tensor(28))
  call G_TensorShift(G1tensor(17),1)
  call Hotf_4pt_reduction_last(G2tensor(103),RedSet_4(3),mass4set(:,1),  & 
G1tensor(10),G1tensor(11),G1tensor(16),G1tensor(21),G1tensor(34))
  call G_TensorShift(G1tensor(11),9)
  call Hotf_4pt_reduction_last(G2tensor(55),RedSet_4(13),mass4set(:,2),  & 
G1tensor(22),G1tensor(23),G1tensor(27),G1tensor(29),G1tensor(33))
  call G_TensorShift(G1tensor(23),8)
  call Hotf_4pt_reduction_last(G2tensor(61),RedSet_4(29),mass4set(:,2),  & 
G1tensor(35),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
  call G_TensorShift(G1tensor(37),4)
  call Hotf_4pt_reduction_last(G2tensor(109),RedSet_4(4),mass4set(:,2),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
  call G_TensorShift(G1tensor(42),12)
  call Hotf_4pt_reduction_last(G2tensor(67),RedSet_4(5),mass4set(:,2),  & 
G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
  call G_TensorShift(G1tensor(47),8)
  call Hotf_4pt_reduction_last(G2tensor(73),RedSet_4(6),mass4set(:,2),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
  call G_TensorShift(G1tensor(52),8)
  call Hotf_4pt_reduction_last(G2tensor(52),RedSet_4(7),mass4set(:,3),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(57),8)
  call Hotf_4pt_reduction_last(G2tensor(76),RedSet_4(9),mass4set(:,4),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_4pt_reduction_last(G2tensor(94),RedSet_4(10),mass4set(:,3),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
  call G_TensorShift(G1tensor(67),8)
  call Hotf_4pt_reduction_last(G2tensor(46),RedSet_4(11),mass4set(:,2),  & 
G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75))
  call G_TensorShift(G1tensor(72),8)
  call Hotf_4pt_reduction_last(G2tensor(82),RedSet_4(14),mass4set(:,2),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
  call G_TensorShift(G1tensor(77),8)
  call Hotf_4pt_reduction_last(G2tensor(85),RedSet_4(16),mass4set(:,4),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
  call G_TensorShift(G1tensor(82),4)
  call Hotf_4pt_reduction_last(G2tensor(100),RedSet_4(17),mass4set(:,3),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(87),4)
  call Hotf_4pt_reduction_last(G2tensor(58),RedSet_4(18),mass4set(:,2),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
  call G_TensorShift(G1tensor(92),4)
  call Hotf_4pt_reduction_last(G2tensor(91),RedSet_4(20),mass4set(:,4),  & 
G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
  call G_TensorShift(G1tensor(97),8)
  call Hotf_4pt_reduction_last(G2tensor(64),RedSet_4(21),mass4set(:,2),  & 
G1tensor(101),G1tensor(102),G1tensor(103),G1tensor(104),G1tensor(105))
  call G_TensorShift(G1tensor(102),8)
  call Hotf_4pt_reduction_last(G2tensor(97),RedSet_4(23),mass4set(:,4),  & 
G1tensor(106),G1tensor(107),G1tensor(108),G1tensor(109),G1tensor(110))
  call G_TensorShift(G1tensor(107),4)
  call Hotf_4pt_reduction_last(G2tensor(70),RedSet_4(24),mass4set(:,2),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115))
  call G_TensorShift(G1tensor(112),4)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(26),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(1),mass4set(:,1),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(12),RedSet_4(27),mass4set(:,2),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(2),mass4set(:,2),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(4),RedSet_4(28),mass4set(:,1),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(10),RedSet_4(3),mass4set(:,1),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(22),RedSet_4(13),mass4set(:,2),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(35),RedSet_4(29),mass4set(:,2),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(4),mass4set(:,2),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(5),mass4set(:,2),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(6),mass4set(:,2),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(7),mass4set(:,3),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(9),mass4set(:,4),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(10),mass4set(:,3),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(11),mass4set(:,2),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(14),mass4set(:,2),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(16),mass4set(:,4),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(17),mass4set(:,3),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(18),mass4set(:,2),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(20),mass4set(:,4),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(21),mass4set(:,2),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(23),mass4set(:,4),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(24),mass4set(:,2),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  call ol_merge_tensors(T0sum(21),[G0tensor(101)])
  call ol_merge_tensors(T0sum(22),[G0tensor(106)])
  call ol_merge_tensors(T0sum(23),[G0tensor(111)])
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(25),h0tab(:,25),[28,1,2],[nMB,0,nMB],3,1,wf9(:,1))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,1),G0H4(1),ngH,m3h9x4(:,3),heltab2x36(:,:,25))
  call Hloop_A_Q(ntryL,G0H4(1),28,nMB,G1H4(1),n2h4(3))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(26),h0tab(:,26),[16,5,10],[nMB,0,nMB],3,2,wf2(:,2),wf6(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(1),ngZd,m3h3x12(:,19),heltab2x36(:,:,26))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(3),n2h12(23))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(27),h0tab(:,27),[18,5,8],[0,nMB,nMB],3,2,wf6(:,5),wf2(:,2))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,5),G0H6(1),m3h6x6(:,5),heltab2x36(:,:,27))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(28),h0tab(:,28),[24,2,5],[nMB,0,nMB],3,2,wf9(:,2),wf2(:,2))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,2),G0H4(1),ngH,m3h9x4(:,4),heltab2x36(:,:,28))
  call Hloop_Q_A(ntryL,G0H4(1),24,nMB,G1H4(2),n2h4(4))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(29),h0tab(:,29),[16,2,13],[nMB,0,nMB],3,1,wf6(:,32))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(1),ngZd,m3h3x12(:,20),heltab2x36(:,:,29))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMB,G1H12(1),n2h12(24))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(30),h0tab(:,30),[21,2,8],[0,nMB,nMB],3,1,wf6(:,30))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,30),G0H6(2),m3h6x6(:,6),heltab2x36(:,:,30))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(31),h0tab(:,31),[16,6,9],[nMB,0,nMB],3,2,wf2(:,4),wf6(:,8))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(1),ngZd,m3h3x12(:,21),heltab2x36(:,:,31))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMB,G1H12(4),n2h12(25))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(32),h0tab(:,32),[17,6,8],[0,nMB,nMB],3,2,wf6(:,10),wf2(:,4))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,10),G0H6(3),m3h6x6(:,7),heltab2x36(:,:,32))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(33),h0tab(:,33),[24,1,6],[nMB,0,nMB],3,2,wf9(:,2),wf2(:,4))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,2),G0H4(1),ngH,m3h9x4(:,5),heltab2x36(:,:,33))
  call Hloop_A_Q(ntryL,G0H4(1),24,nMB,G1H4(3),n2h4(5))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(34),h0tab(:,34),[16,1,14],[nMB,0,nMB],3,1,wf6(:,38))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(1),ngZd,m3h3x12(:,22),heltab2x36(:,:,34))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(7),n2h12(26))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(35),h0tab(:,35),[22,1,8],[0,nMB,nMB],3,1,wf6(:,35))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,35),G0H6(4),m3h6x6(:,8),heltab2x36(:,:,35))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(36),h0tab(:,36),[18,4,9],[nMB,nMB,0],3,2,wf6(:,5),wf6(:,8))
  call Hloop_VA_Q(ntryL,G0H36(1),wf6(:,5),G0H6(5),m3h6x6(:,9),heltab2x36(:,:,36))
  call Hloop_A_Q(ntryL,G0H6(5),18,nMB,G1H6(7),n2h6(3))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(37),h0tab(:,37),[20,2,9],[nMB,0,nMB],3,2,wf3(:,4),wf6(:,8))
  call Hloop_QZ_A(ntryL,G0H36(1),wf3(:,4),G0H12(1),ngZd,m3h3x12(:,23),heltab2x36(:,:,37))
  call Hloop_Q_A(ntryL,G0H12(1),20,nMB,G1H12(5),n2h12(27))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(38),h0tab(:,38),[16,2,13],[nMB,0,nMB],3,1,wf6(:,41))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(1),ngZd,m3h3x12(:,24),heltab2x36(:,:,38))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMB,G1H12(6),n2h12(28))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(44)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(39),h0tab(:,39),[25,2,4],[0,nMB,nMB],3,1,wf18(:,13))
  call Hloop_AQ_V(ntryL,G0H36(1),wf18(:,13),G0H2(1),m3h18x2(:,1),heltab2x36(:,:,39))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(40),h0tab(:,40),[17,4,10],[nMB,nMB,0],3,2,wf6(:,10),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H36(1),wf6(:,10),G0H6(5),m3h6x6(:,10),heltab2x36(:,:,40))
  call Hloop_Q_A(ntryL,G0H6(5),17,nMB,G1H6(8),n2h6(4))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(41),h0tab(:,41),[20,1,10],[nMB,0,nMB],3,2,wf3(:,4),wf6(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf3(:,4),G0H12(1),ngZd,m3h3x12(:,25),heltab2x36(:,:,41))
  call Hloop_A_Q(ntryL,G0H12(1),20,nMB,G1H12(2),n2h12(29))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(42),h0tab(:,42),[16,1,14],[nMB,0,nMB],3,1,wf6(:,45))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(1),ngZd,m3h3x12(:,26),heltab2x36(:,:,42))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(8),n2h12(30))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(43),h0tab(:,43),[26,1,4],[0,nMB,nMB],3,1,wf18(:,8))
  call Hloop_QA_V(ntryL,G0H36(1),wf18(:,8),G0H2(2),m3h18x2(:,2),heltab2x36(:,:,43))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(44),h0tab(:,44),[17,2,12],[0,nMB,nMB],3,2,wf6(:,10),wf3(:,2))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,10),G0H6(5),m3h6x6(:,11),heltab2x36(:,:,44))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(45),h0tab(:,45),[18,1,12],[0,nMB,nMB],3,2,wf6(:,5),wf3(:,2))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,5),G0H6(6),m3h6x6(:,12),heltab2x36(:,:,45))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(46),h0tab(:,46),[16,2,13],[nMB,0,nMB],3,1,wf6(:,52))
  call Hloop_QZ_A(ntryL,G0H36(1),ex5(:),G0H12(1),ngZd,m3h3x12(:,27),heltab2x36(:,:,46))
  call Hloop_Q_A(ntryL,G0H12(1),16,nMB,G1H12(9),n2h12(31))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(47),h0tab(:,47),[16,1,14],[nMB,0,nMB],3,1,wf6(:,50))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex5(:),G0H12(1),ngZd,m3h3x12(:,28),heltab2x36(:,:,47))
  call Hloop_A_Q(ntryL,G0H12(1),16,nMB,G1H12(10),n2h12(32))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(48),h0tab(:,48),[28,1,2],[nMB,0,nMB],3,1,wf9(:,3))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,3),G0H4(1),ngH,m3h9x4(:,6),heltab2x36(:,:,48))
  call Hloop_A_Q(ntryL,G0H4(1),28,nMB,G1H4(4),n2h4(6))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(49),h0tab(:,49),[21,2,8],[0,nMB,nMB],3,1,wf6(:,46))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,46),G0H6(7),m3h6x6(:,13),heltab2x36(:,:,49))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(50),h0tab(:,50),[25,2,4],[0,nMB,nMB],3,1,wf18(:,14))
  call Hloop_AQ_V(ntryL,G0H36(1),wf18(:,14),G0H2(3),m3h18x2(:,3),heltab2x36(:,:,50))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(51),h0tab(:,51),[22,1,8],[0,nMB,nMB],3,1,wf6(:,40))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,40),G0H6(8),m3h6x6(:,14),heltab2x36(:,:,51))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(52),h0tab(:,52),[26,1,4],[0,nMB,nMB],3,1,wf18(:,10))
  call Hloop_QA_V(ntryL,G0H36(1),wf18(:,10),G0H2(4),m3h18x2(:,4),heltab2x36(:,:,52))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(53),h0tab(:,53),[21,2,8],[0,nMB,nMB],3,1,wf6(:,48))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,48),G0H6(9),m3h6x6(:,15),heltab2x36(:,:,53))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(54),h0tab(:,54),[22,1,8],[0,nMB,nMB],3,1,wf6(:,43))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,43),G0H6(10),m3h6x6(:,16),heltab2x36(:,:,54))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(55),h0tab(:,55),[28,1,2],[nMB,0,nMB],3,1,wf9(:,4))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,4),G0H4(1),ngH,m3h9x4(:,7),heltab2x36(:,:,55))
  call Hloop_A_Q(ntryL,G0H4(1),28,nMB,G1H4(5),n2h4(7))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(51)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(56),h0tab(:,56),[25,2,4],[0,nMB,nMB],3,1,wf18(:,16))
  call Hloop_AQ_V(ntryL,G0H36(1),wf18(:,16),G0H2(5),m3h18x2(:,5),heltab2x36(:,:,56))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(38)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(57),h0tab(:,57),[26,1,4],[0,nMB,nMB],3,1,wf18(:,12))
  call Hloop_QA_V(ntryL,G0H36(1),wf18(:,12),G0H2(6),m3h18x2(:,6),heltab2x36(:,:,57))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(58),h0tab(:,58),[28,1,2],[nMB,0,nMB],3,1,wf9(:,5))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,5),G0H4(1),ngH,m3h9x4(:,8),heltab2x36(:,:,58))
  call Hloop_A_Q(ntryL,G0H4(1),28,nMB,G1H4(6),n2h4(8))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G1H4(5),G1H4(4),G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(9),[G0H6(7),G0H6(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(10),[G0H6(8),G0H6(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(5),[G0H2(3),G0H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(6),[G0H2(4),G0H2(2)])
  call Hloop_AQ_V(ntryL,G1H4(6),ex1(:),G1H2(1),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_V(ntryL,G1H12(3),wf2(:,2),G1H6(11),m3h2x6(:,19),heltab2x12(:,:,23))
  call Hloop_VQ_A(ntryL,G0H6(1),wf2(:,2),G0H3(1),m3h2x3(:,23),heltab2x6(:,:,33))
  call Hloop_Q_A(ntryL,G0H3(1),23,nMB,G1H3(42),n2h3(37))
  call Hloop_QA_V(ntryL,G1H4(2),ex2(:),G1H2(2),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_V(ntryL,G1H12(1),ex2(:),G1H6(12),m3h2x6(:,20),heltab2x12(:,:,24))
  call Hloop_VA_Q(ntryL,G0H6(9),ex2(:),G0H3(1),m3h2x3(:,24),heltab2x6(:,:,34))
  call Hloop_A_Q(ntryL,G0H3(1),23,nMB,G1H3(43),n2h3(38))
  call Hloop_QA_V(ntryL,G1H12(4),wf2(:,4),G1H6(3),m3h2x6(:,21),heltab2x12(:,:,25))
  call Hloop_VA_Q(ntryL,G0H6(3),wf2(:,4),G0H3(1),m3h2x3(:,25),heltab2x6(:,:,35))
  call Hloop_A_Q(ntryL,G0H3(1),23,nMB,G1H3(3),n2h3(39))
  call Hloop_AQ_V(ntryL,G1H4(3),ex1(:),G1H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_V(ntryL,G1H12(7),ex1(:),G1H6(4),m3h2x6(:,22),heltab2x12(:,:,26))
  call Hloop_VQ_A(ntryL,G0H6(10),ex1(:),G0H3(1),m3h2x3(:,26),heltab2x6(:,:,36))
  call Hloop_Q_A(ntryL,G0H3(1),23,nMB,G1H3(9),n2h3(40))
  call Hloop_AS_Q(ntryL,G1H6(7),ex3(:),G1H6(14),ngH,m3h1x6(:,1),heltab2x6(:,:,37))
  call Hloop_A_Q(ntryL,G1H6(14),22,nMB,G2H6(1),n2h6(5))
  call Hloop_QA_V(ntryL,G1H12(5),ex2(:),G1H6(1),m3h2x6(:,23),heltab2x12(:,:,27))
  call Hloop_QA_V(ntryL,G1H12(6),ex2(:),G1H6(13),m3h2x6(:,24),heltab2x12(:,:,28))
  call Hloop_VA_Q(ntryL,G0H2(5),ex2(:),G0H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hloop_A_Q(ntryL,G0H1(1),27,nMB,G1H1(44),n2h1(135))
  call Hloop_QS_A(ntryL,G1H6(8),ex3(:),G1H6(6),ngH,m3h1x6(:,2),heltab2x6(:,:,38))
  call Hloop_Q_A(ntryL,G1H6(6),21,nMB,G2H6(2),n2h6(6))
  call Hloop_AQ_V(ntryL,G1H12(2),ex1(:),G1H6(7),m3h2x6(:,25),heltab2x12(:,:,29))
  call Hloop_AQ_V(ntryL,G1H12(8),ex1(:),G1H6(14),m3h2x6(:,26),heltab2x12(:,:,30))
  call Hloop_VQ_A(ntryL,G0H2(6),ex1(:),G0H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hloop_Q_A(ntryL,G0H1(1),27,nMB,G1H1(8),n2h1(136))
  call Hloop_VA_Q(ntryL,G0H6(5),ex2(:),G0H3(1),m3h2x3(:,27),heltab2x6(:,:,39))
  call Hloop_A_Q(ntryL,G0H3(1),19,nMB,G1H3(15),n2h3(41))
  call Hloop_VQ_A(ntryL,G0H6(6),ex1(:),G0H3(1),m3h2x3(:,28),heltab2x6(:,:,40))
  call Hloop_Q_A(ntryL,G0H3(1),19,nMB,G1H3(1),n2h3(42))
  call Hloop_QA_V(ntryL,G1H12(9),ex2(:),G1H6(8),m3h2x6(:,27),heltab2x12(:,:,31))
  call Hloop_AQ_V(ntryL,G1H12(10),ex1(:),G1H6(6),m3h2x6(:,28),heltab2x12(:,:,32))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(11),[G1H3(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(62),[G1H3(7),G1H3(22),G1H3(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(8),[G1H1(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(42),[G1H3(44),G1H3(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(55),[G1H3(53),G1H3(6),G1H3(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(12),[G1H3(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(9),[G1H3(30),G1H3(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(30),[G1H1(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(35),[G1H1(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(44),[G1H1(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(3),[G1H3(57),G1H3(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(43),[G1H3(46),G1H3(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(11),[G1H1(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(42),[G1H1(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(25),[G1H3(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(34),[G1H1(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(61),[G1H3(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(41),[G1H1(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(1),[G1H6(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(3),[G1H6(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(7),[G1H6(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(11),[G1H6(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(15),[G1H3(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(1),[G1H3(68)])
  call Hloop_VA_Q(ntryL,G1H2(1),ex2(:),G1H1(12),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(12),31,nMB,G2tensor(2),n2h1(137))
  call Hloop_VA_Q(ntryL,G1H2(4),ex2(:),G1H1(13),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(13),31,nMB,G2tensor(3),n2h1(138))
  call Hloop_AZ_Q(ntryL,G1H3(11),ex4(:),G1H1(37),ngZd,m3h3x1(:,83),heltab2x3(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(37),31,nMB,G2tensor(6),n2h1(139))
  call Hloop_AZ_Q(ntryL,G1H3(62),ex4(:),G1H1(21),ngZd,m3h3x1(:,84),heltab2x3(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(21),31,nMB,G2tensor(15),n2h1(140))
  call Hloop_QS_A(ntryL,G1H1(8),ex3(:),G1H1(10),ngH,m3h1x1(:,39),heltab2x1(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(10),31,nMB,G2tensor(7),n2h1(141))
  call Hloop_QS_A(ntryL,G1H1(1),ex3(:),G1H1(2),ngH,m3h1x1(:,40),heltab2x1(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(2),31,nMB,G2tensor(10),n2h1(142))
  call Hloop_QZ_A(ntryL,G1H3(42),ex4(:),G1H1(38),ngZd,m3h3x1(:,85),heltab2x3(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(38),31,nMB,G2tensor(11),n2h1(143))
  call Hloop_QZ_A(ntryL,G1H3(55),ex4(:),G1H1(15),ngZd,m3h3x1(:,86),heltab2x3(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(15),31,nMB,G2tensor(14),n2h1(144))
  call Hloop_VQ_A(ntryL,G1H2(8),ex1(:),G1H1(39),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(39),31,nMB,G2tensor(18),n2h1(145))
  call Hloop_VQ_A(ntryL,G1H2(9),ex1(:),G1H1(20),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(20),31,nMB,G2tensor(23),n2h1(146))
  call Hloop_QZ_A(ntryL,G1H3(12),ex4(:),G1H1(40),ngZd,m3h3x1(:,87),heltab2x3(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(40),31,nMB,G2tensor(19),n2h1(147))
  call Hloop_QZ_A(ntryL,G1H3(9),ex4(:),G1H1(27),ngZd,m3h3x1(:,88),heltab2x3(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(27),31,nMB,G2tensor(22),n2h1(148))
  call Hloop_QS_A(ntryL,G1H1(30),ex3(:),G1H1(43),ngH,m3h1x1(:,41),heltab2x1(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(43),31,nMB,G2tensor(40),n2h1(149))
  call Hloop_QS_A(ntryL,G1H1(35),ex3(:),G1H1(23),ngH,m3h1x1(:,42),heltab2x1(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(23),31,nMB,G2tensor(79),n2h1(150))
  call Hloop_AS_Q(ntryL,G1H1(44),ex3(:),G1H1(28),ngH,m3h1x1(:,43),heltab2x1(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(28),31,nMB,G2tensor(88),n2h1(151))
  call Hloop_AS_Q(ntryL,G1H1(4),ex3(:),G1H1(5),ngH,m3h1x1(:,44),heltab2x1(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(5),31,nMB,G2tensor(37),n2h1(152))
  call Hloop_AZ_Q(ntryL,G1H3(3),ex4(:),G1H1(31),ngZd,m3h3x1(:,89),heltab2x3(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(31),31,nMB,G2tensor(106),n2h1(153))
  call Hloop_AZ_Q(ntryL,G1H3(43),ex4(:),G1H1(26),ngZd,m3h3x1(:,90),heltab2x3(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(26),31,nMB,G2tensor(43),n2h1(154))
  call Hloop_AS_Q(ntryL,G1H1(11),ex3(:),G1H1(32),ngH,m3h1x1(:,45),heltab2x1(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(32),31,nMB,G2tensor(112),n2h1(155))
  call Hloop_AS_Q(ntryL,G1H1(42),ex3(:),G1H1(19),ngH,m3h1x1(:,46),heltab2x1(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(49),n2h1(156))
  call Hloop_QZ_A(ntryL,G1H3(25),ex4(:),G1H1(33),ngZd,m3h3x1(:,91),heltab2x3(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(33),31,nMB,G2tensor(103),n2h1(157))
  call Hloop_QS_A(ntryL,G1H1(34),ex3(:),G1H1(16),ngH,m3h1x1(:,47),heltab2x1(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(16),31,nMB,G2tensor(55),n2h1(158))
  call Hloop_AZ_Q(ntryL,G1H3(61),ex4(:),G1H1(36),ngZd,m3h3x1(:,92),heltab2x3(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(36),31,nMB,G2tensor(61),n2h1(159))
  call Hloop_AS_Q(ntryL,G1H1(41),ex3(:),G1H1(22),ngH,m3h1x1(:,48),heltab2x1(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(22),31,nMB,G2tensor(109),n2h1(160))
  call Hloop_VQ_A(ntryL,G1H6(1),wf6(:,8),G1H1(14),m3h6x1(:,9),heltab2x6(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(14),31,nMB,G2tensor(67),n2h1(161))
  call Hloop_VQ_A(ntryL,G1H6(3),wf6(:,8),G1H1(17),m3h6x1(:,10),heltab2x6(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),31,nMB,G2tensor(73),n2h1(162))
  call Hloop_VA_Q(ntryL,G1H6(7),wf6(:,2),G1H1(7),m3h6x1(:,11),heltab2x6(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(7),31,nMB,G2tensor(52),n2h1(163))
  call Hloop_VA_Q(ntryL,G1H6(11),wf6(:,2),G1H1(6),m3h6x1(:,12),heltab2x6(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(6),31,nMB,G2tensor(76),n2h1(164))
  call Hloop_AZ_Q(ntryL,G1H3(15),wf3(:,2),G1H1(18),ngZd,m3h3x1(:,93),heltab2x3(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(18),31,nMB,G2tensor(94),n2h1(165))
  call Hloop_AZ_Q(ntryL,G1H3(64),wf3(:,2),G1H1(3),ngZd,m3h3x1(:,94),heltab2x3(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(3),31,nMB,G2tensor(46),n2h1(166))
  call Hloop_QZ_A(ntryL,G1H3(1),wf3(:,2),G1H1(24),ngZd,m3h3x1(:,95),heltab2x3(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(24),31,nMB,G2tensor(82),n2h1(167))
  call Hloop_QZ_A(ntryL,G1H3(69),wf3(:,2),G1H1(25),ngZd,m3h3x1(:,96),heltab2x3(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(25),31,nMB,G2tensor(85),n2h1(168))
  call Hloop_VQ_A(ntryL,G1H2(2),wf2(:,2),G1H1(29),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(29),31,nMB,G2tensor(100),n2h1(169))
  call Hloop_VQ_A(ntryL,G1H6(12),wf6(:,32),G1H1(9),m3h6x1(:,13),heltab2x6(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),31,nMB,G2tensor(58),n2h1(170))
  call Hloop_VA_Q(ntryL,G1H2(5),wf2(:,4),G1H1(12),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(12),31,nMB,G2tensor(91),n2h1(171))
  call Hloop_VA_Q(ntryL,G1H6(4),wf6(:,38),G1H1(13),m3h6x1(:,14),heltab2x6(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(13),31,nMB,G2tensor(64),n2h1(172))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(1),wf6(:,8),G2tensor(97),m3h6x1(:,15),heltab2x6(:,:,47))
  call Hloop_VQ_A(ntryL,G1H6(13),wf6(:,41),G1H1(37),m3h6x1(:,16),heltab2x6(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(37),31,nMB,G2tensor(70),n2h1(173))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(2),wf6(:,2),G2tensor(115),m3h6x1(:,17),heltab2x6(:,:,49))
  call Hloop_VA_Q(ntryL,G1H6(14),wf6(:,45),G1H1(21),m3h6x1(:,18),heltab2x6(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(21),31,nMB,G2tensor(116),n2h1(174))
  call Hloop_VQ_A(ntryL,G1H6(8),wf6(:,52),G1H1(8),m3h6x1(:,19),heltab2x6(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),31,nMB,G2tensor(117),n2h1(175))
  call Hloop_VA_Q(ntryL,G1H6(6),wf6(:,50),G1H1(10),m3h6x1(:,20),heltab2x6(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(10),31,nMB,G2tensor(118),n2h1(176))
  call ol_merge_tensors(G2tensor(107),[G2tensor(38),G2tensor(4),G1tensor(2),G1tensor(7),G0tensor(7),G0tensor(2)])
  call ol_merge_tensors(G2tensor(18),[G2tensor(113),G2tensor(56),G2tensor(44),G2tensor(16),G2tensor(8),G1tensor(23),G1tensor(5) &
    ,G1tensor(36),G1tensor(14),G0tensor(32),G0tensor(23),G0tensor(17),G0tensor(12)])
  call ol_merge_tensors(G2tensor(104),[G2tensor(50),G2tensor(12),G1tensor(11),G1tensor(17),G0tensor(27),G0tensor(22)])
  call ol_merge_tensors(G2tensor(2),[G2tensor(110),G2tensor(68),G2tensor(62),G2tensor(24),G2tensor(20),G1tensor(47),G1tensor(42) &
    ,G1tensor(37),G1tensor(13),G0tensor(47),G0tensor(42),G0tensor(37),G0tensor(3)])
  call ol_merge_tensors(G2tensor(52),[G2tensor(71),G2tensor(69),G2tensor(1),G1tensor(112),G1tensor(50),G1tensor(6),G0tensor(112) &
    ,G0tensor(50),G0tensor(8)])
  call ol_merge_tensors(G2tensor(76),[G2tensor(75),G2tensor(5),G1tensor(55),G1tensor(8),G0tensor(55),G0tensor(9)])
  call ol_merge_tensors(G2tensor(108),[G2tensor(105),G2tensor(54),G2tensor(42),G2tensor(27),G2tensor(9),G1tensor(60),G1tensor(34) &
    ,G1tensor(24),G0tensor(60),G0tensor(30),G0tensor(10)])
  call ol_merge_tensors(G2tensor(82),[G2tensor(87),G2tensor(78),G2tensor(28),G2tensor(13),G1tensor(85),G1tensor(65),G1tensor(30) &
    ,G0tensor(85),G0tensor(65),G0tensor(18)])
  call ol_merge_tensors(G2tensor(85),[G2tensor(46),G2tensor(102),G2tensor(96),G2tensor(90),G2tensor(81),G2tensor(35),G2tensor(32) &
    ,G2tensor(29),G2tensor(17),G1tensor(90),G1tensor(70),G1tensor(44),G1tensor(32),G0tensor(90),G0tensor(70),G0tensor(44) &
    ,G0tensor(19)])
  call ol_merge_tensors(G2tensor(117),[G2tensor(70),G2tensor(58),G2tensor(114),G2tensor(60),G2tensor(48),G2tensor(30),G2tensor(21) &
    ,G1tensor(95),G1tensor(75),G1tensor(3),G0tensor(95),G0tensor(75),G0tensor(20)])
  call ol_merge_tensors(G2tensor(67),[G2tensor(59),G2tensor(57),G2tensor(25),G1tensor(92),G1tensor(33),G1tensor(16),G0tensor(92) &
    ,G0tensor(35),G0tensor(28)])
  call ol_merge_tensors(G2tensor(73),[G2tensor(84),G2tensor(26),G1tensor(80),G1tensor(21),G0tensor(80),G0tensor(29)])
  call ol_merge_tensors(G2tensor(94),[G2tensor(99),G2tensor(93),G2tensor(34),G2tensor(31),G1tensor(110),G1tensor(100),G1tensor(43) &
    ,G0tensor(110),G0tensor(100),G0tensor(43)])
  call ol_merge_tensors(G2tensor(118),[G2tensor(116),G2tensor(64),G2tensor(111),G2tensor(72),G2tensor(66),G2tensor(36) &
    ,G2tensor(33),G1tensor(115),G1tensor(105),G1tensor(45),G0tensor(115),G0tensor(105),G0tensor(45)])
  call ol_merge_tensors(G2tensor(53),[G2tensor(51),G2tensor(41),G2tensor(39),G1tensor(57),G1tensor(28),G1tensor(25),G0tensor(57) &
    ,G0tensor(25),G0tensor(5)])
  call ol_merge_tensors(G2tensor(100),[G2tensor(47),G2tensor(45),G1tensor(72),G1tensor(15),G0tensor(72),G0tensor(15)])
  call ol_merge_tensors(G2tensor(91),[G2tensor(65),G2tensor(63),G1tensor(102),G1tensor(40),G0tensor(102),G0tensor(40)])
  call ol_merge_tensors(G2tensor(3),[G2tensor(74),G1tensor(52),G1tensor(19),G0tensor(52),G0tensor(4)])
  call ol_merge_tensors(G2tensor(7),[G2tensor(77),G1tensor(62),G1tensor(18),G0tensor(62),G0tensor(13)])
  call ol_merge_tensors(G2tensor(37),[G2tensor(10),G2tensor(95),G2tensor(80),G1tensor(67),G1tensor(39),G1tensor(20),G0tensor(67) &
    ,G0tensor(39),G0tensor(14)])
  call ol_merge_tensors(G2tensor(23),[G2tensor(83),G1tensor(77),G1tensor(9),G0tensor(77),G0tensor(24)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(86),G1tensor(82),G1tensor(78),G1tensor(27),G0tensor(82),G0tensor(78) &
    ,G0tensor(33)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(6),G2tensor(101),G2tensor(89),G1tensor(87),G1tensor(58),G1tensor(49),G1tensor(29) &
    ,G0tensor(87),G0tensor(58),G0tensor(49),G0tensor(34)])
  call ol_merge_tensors(G2tensor(88),[G2tensor(92),G1tensor(97),G1tensor(38),G0tensor(97),G0tensor(38)])
  call ol_merge_tensors(G2tensor(43),[G2tensor(98),G1tensor(107),G1tensor(53),G1tensor(48),G0tensor(107),G0tensor(53) &
    ,G0tensor(48)])
  call ol_merge_tensors(G2tensor(14),[G2tensor(15),G1tensor(104),G1tensor(79),G1tensor(74),G1tensor(69),G1tensor(59),G1tensor(54) &
    ,G0tensor(104),G0tensor(79),G0tensor(74),G0tensor(69),G0tensor(59),G0tensor(54)])
  call ol_merge_tensors(G2tensor(61),[G2tensor(103),G1tensor(98),G1tensor(68),G1tensor(63),G0tensor(98),G0tensor(68) &
    ,G0tensor(63)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(73),G1tensor(64),G0tensor(73),G0tensor(64)])
  call ol_merge_tensors(G2tensor(109),[G2tensor(55),G1tensor(108),G1tensor(88),G1tensor(83),G0tensor(108),G0tensor(88) &
    ,G0tensor(83)])
  call ol_merge_tensors(G2tensor(40),[G1tensor(93),G1tensor(84),G0tensor(93),G0tensor(84)])
  call ol_merge_tensors(G2tensor(49),[G2tensor(79),G1tensor(114),G1tensor(94),G1tensor(89),G0tensor(114),G0tensor(94) &
    ,G0tensor(89)])
  call ol_merge_tensors(G2tensor(106),[G1tensor(103),G1tensor(99),G0tensor(103),G0tensor(99)])
  call ol_merge_tensors(G2tensor(112),[G1tensor(113),G1tensor(109),G0tensor(113),G0tensor(109)])
  call TI_triangle_red(G2tensor(107),RedBasis(45),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1,[nMB], &
    G0tensor(21))
  call TI_triangle_red(G2tensor(18),RedBasis(42),mass3set(:,2),G0tensor(26),G0tensor(31),G0tensor(36),G0tensor(41),M2L1R1,[nMB], &
    G0tensor(46))
  call TI_triangle_red(G2tensor(104),RedBasis(46),mass3set(:,1),G0tensor(51),G0tensor(56),G0tensor(61),G0tensor(66),M2L1R1,[nMB], &
    G0tensor(71))
  call TI_triangle_red(G2tensor(2),RedBasis(37),mass3set(:,2),G0tensor(76),G0tensor(81),G0tensor(86),G0tensor(91),M2L1R1,[nMB], &
    G0tensor(96))
  call TI_triangle_red(G2tensor(52),RedBasis(4),mass3set(:,2),G0tensor(101),G0tensor(106),G0tensor(111),G0tensor(7),M2L1R1,[nMB], &
    G0tensor(2))
  call TI_triangle_red(G2tensor(76),RedBasis(2),mass3set(:,2),G0tensor(32),G0tensor(23),G0tensor(17),G0tensor(12),M2L1R1,[nMB], &
    G0tensor(27))
  call TI_triangle_red(G2tensor(108),RedBasis(1),mass3set(:,3),G0tensor(22),G0tensor(47),G0tensor(42),G0tensor(37),M2L1R1,[nMB], &
    G0tensor(3))
  call TI_triangle_red(G2tensor(82),RedBasis(9),mass3set(:,4),G0tensor(112),G0tensor(50),G0tensor(8),G0tensor(55),M2L1R1,[nMB], &
    G0tensor(9))
  call TI_triangle_red(G2tensor(85),RedBasis(8),mass3set(:,3),G0tensor(60),G0tensor(30),G0tensor(10),G0tensor(85),M2L1R1,[nMB], &
    G0tensor(65))
  call TI_triangle_red(G2tensor(117),RedBasis(7),mass3set(:,2),G0tensor(18),G0tensor(90),G0tensor(70),G0tensor(44),M2L1R1,[nMB], &
    G0tensor(19))
  call TI_triangle_red(G2tensor(67),RedBasis(13),mass3set(:,2),G0tensor(95),G0tensor(75),G0tensor(20),G0tensor(92),M2L1R1,[nMB], &
    G0tensor(35))
  call TI_triangle_red(G2tensor(73),RedBasis(12),mass3set(:,2),G0tensor(28),G0tensor(80),G0tensor(29),G0tensor(110),M2L1R1,[nMB], &
    G0tensor(100))
  call TI_triangle_red(G2tensor(94),RedBasis(19),mass3set(:,4),G0tensor(43),G0tensor(115),G0tensor(105),G0tensor(45),M2L1R1,[nMB], &
    G0tensor(57))
  call TI_triangle_red(G2tensor(118),RedBasis(18),mass3set(:,2),G0tensor(25),G0tensor(5),G0tensor(72),G0tensor(15),M2L1R1,[nMB], &
    G0tensor(102))
  call TI_triangle_red(G2tensor(53),RedBasis(35),mass3set(:,3),G0tensor(40),G0tensor(52),G0tensor(4),G0tensor(62),M2L1R1,[nMB], &
    G0tensor(13))
  call TI_triangle_red(G2tensor(100),RedBasis(38),mass3set(:,2),G0tensor(67),G0tensor(39),G0tensor(14),G0tensor(77),M2L1R1,[nMB], &
    G0tensor(24))
  call TI_triangle_red(G2tensor(91),RedBasis(43),mass3set(:,2),G0tensor(82),G0tensor(78),G0tensor(33),G0tensor(87),M2L1R1,[nMB], &
    G0tensor(58))
  call TI_triangle_red(G2tensor(3),RedBasis(36),mass3set(:,2),G0tensor(49),G0tensor(34),G0tensor(97),G0tensor(38),M2L1R1,[nMB], &
    G0tensor(107))
  call TI_triangle_red(G2tensor(7),RedBasis(40),mass3set(:,4),G0tensor(53),G0tensor(48),G0tensor(104),G0tensor(79),M2L1R1,[nMB], &
    G0tensor(74))
  call TI_triangle_red(G2tensor(37),RedBasis(39),mass3set(:,3),G0tensor(69),G0tensor(59),G0tensor(54),G0tensor(98),M2L1R1,[nMB], &
    G0tensor(68))
  call TI_triangle_red(G2tensor(23),RedBasis(41),mass3set(:,2),G0tensor(63),G0tensor(73),G0tensor(64),G0tensor(108),M2L1R1,[nMB], &
    G0tensor(88))
  call TI_triangle_red(G2tensor(22),RedBasis(14),mass3set(:,4),G0tensor(83),G0tensor(93),G0tensor(84),G0tensor(114),M2L1R1,[nMB], &
    G0tensor(94))
  call TI_triangle_red(G2tensor(19),RedBasis(5),mass3set(:,3),G0tensor(89),G0tensor(103),G0tensor(99),G0tensor(113),M2L1R1,[nMB], &
    G0tensor(109))
  call TI_triangle_red(G2tensor(88),RedBasis(44),mass3set(:,4),G0tensor(116),G0tensor(117),G0tensor(118), &
    G0tensor(119),M2L1R1,[nMB],G0tensor(120))
  call TI_triangle_red(G2tensor(43),RedBasis(6),mass3set(:,4),G0tensor(121),G0tensor(122),G0tensor(123), &
    G0tensor(124),M2L1R1,[nMB],G0tensor(125))
  call TI_triangle_red(G2tensor(14),RedBasis(3),mass3set(:,3),G0tensor(126),G0tensor(127),G0tensor(128), &
    G0tensor(129),M2L1R1,[nMB],G0tensor(130))
  call TI_triangle_red(G2tensor(61),RedBasis(11),mass3set(:,3),G0tensor(131),G0tensor(132),G0tensor(133), &
    G0tensor(134),M2L1R1,[nMB],G0tensor(135))
  call TI_triangle_red(G2tensor(11),RedBasis(10),mass3set(:,4),G0tensor(136),G0tensor(137),G0tensor(138), &
    G0tensor(139),M2L1R1,[nMB],G0tensor(140))
  call TI_triangle_red(G2tensor(109),RedBasis(17),mass3set(:,3),G0tensor(141),G0tensor(142),G0tensor(143), &
    G0tensor(144),M2L1R1,[nMB],G0tensor(145))
  call TI_triangle_red(G2tensor(40),RedBasis(16),mass3set(:,4),G0tensor(146),G0tensor(147),G0tensor(148), &
    G0tensor(149),M2L1R1,[nMB],G0tensor(150))
  call TI_triangle_red(G2tensor(49),RedBasis(15),mass3set(:,3),G0tensor(151),G0tensor(152),G0tensor(153), &
    G0tensor(154),M2L1R1,[nMB],G0tensor(155))
  call TI_triangle_red(G2tensor(106),RedBasis(20),mass3set(:,4),G0tensor(156),G0tensor(157),G0tensor(158), &
    G0tensor(159),M2L1R1,[nMB],G0tensor(160))
  call TI_triangle_red(G2tensor(112),RedBasis(21),mass3set(:,4),G0tensor(161),G0tensor(162),G0tensor(163), &
    G0tensor(164),M2L1R1,[nMB],G0tensor(165))
  call TI_triangle_red(G2tensor(97),RedBasis(47),mass3set(:,1),G0tensor(166),G0tensor(167),G0tensor(168), &
    G0tensor(169),M2L1R1,[nMB],G0tensor(170))
  call TI_triangle_red(G2tensor(115),RedBasis(48),mass3set(:,1),G0tensor(171),G0tensor(172),G0tensor(173), &
    G0tensor(174),M2L1R1,[nMB],G0tensor(175))
  call ol_merge_tensors(T0sum(24),[G0tensor(1)])
  call ol_merge_tensors(T0sum(25),[G0tensor(26)])
  call ol_merge_tensors(T0sum(26),[G0tensor(51)])
  call ol_merge_tensors(T0sum(27),[G0tensor(76)])
  call ol_merge_tensors(T0sum(28),[G0tensor(101)])
  call ol_merge_tensors(T0sum(29),[G0tensor(32)])
  call ol_merge_tensors(T0sum(30),[G0tensor(22)])
  call ol_merge_tensors(T0sum(31),[G0tensor(112)])
  call ol_merge_tensors(T0sum(32),[G0tensor(60)])
  call ol_merge_tensors(T0sum(33),[G0tensor(18)])
  call ol_merge_tensors(T0sum(34),[G0tensor(95)])
  call ol_merge_tensors(T0sum(35),[G0tensor(28)])
  call ol_merge_tensors(T0sum(36),[G0tensor(43)])
  call ol_merge_tensors(T0sum(37),[G0tensor(25)])
  call ol_merge_tensors(T0sum(38),[G0tensor(40)])
  call ol_merge_tensors(T0sum(39),[G0tensor(67)])
  call ol_merge_tensors(T0sum(40),[G0tensor(82)])
  call ol_merge_tensors(T0sum(41),[G0tensor(49)])
  call ol_merge_tensors(T0sum(42),[G0tensor(53)])
  call ol_merge_tensors(T0sum(43),[G0tensor(69)])
  call ol_merge_tensors(T0sum(44),[G0tensor(63)])
  call ol_merge_tensors(T0sum(45),[G0tensor(83)])
  call ol_merge_tensors(T0sum(46),[G0tensor(89)])
  call ol_merge_tensors(T0sum(47),[G0tensor(116)])
  call ol_merge_tensors(T0sum(48),[G0tensor(121)])
  call ol_merge_tensors(T0sum(49),[G0tensor(126)])
  call ol_merge_tensors(T0sum(50),[G0tensor(131)])
  call ol_merge_tensors(T0sum(51),[G0tensor(136)])
  call ol_merge_tensors(T0sum(52),[G0tensor(141)])
  call ol_merge_tensors(T0sum(53),[G0tensor(146)])
  call ol_merge_tensors(T0sum(54),[G0tensor(151)])
  call ol_merge_tensors(T0sum(55),[G0tensor(156)])
  call ol_merge_tensors(T0sum(56),[G0tensor(161)])
  call ol_merge_tensors(T0sum(57),[G0tensor(166)])
  call ol_merge_tensors(T0sum(58),[G0tensor(171)])
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(59),h0tab(:,59),[21,10],[nMB,0],2,2,wf6(:,30),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H36(1),wf6(:,30),G0H6(7),m3h6x6(:,17),heltab2x36(:,:,59))
  call Hloop_Q_A(ntryL,G0H6(7),21,nMB,G1H6(9),n2h6(7))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(29)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(60),h0tab(:,60),[26,5],[nMB,0],2,2,wf18(:,8),wf2(:,2))
  call Hloop_VA_Q(ntryL,G0H36(1),wf18(:,8),G0H2(3),m3h18x2(:,7),heltab2x36(:,:,60))
  call Hloop_A_Q(ntryL,G0H2(3),26,nMB,G1H2(6),n2h2(1))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(61),h0tab(:,61),[18,13],[0,nMB],2,2,wf6(:,5),wf6(:,32))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,5),G0H6(2),m3h6x6(:,18),heltab2x36(:,:,61))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(62),h0tab(:,62),[26,5],[nMB,0],2,2,wf18(:,10),wf2(:,2))
  call Hloop_VA_Q(ntryL,G0H36(1),wf18(:,10),G0H2(1),m3h18x2(:,8),heltab2x36(:,:,62))
  call Hloop_A_Q(ntryL,G0H2(1),26,nMB,G1H2(7),n2h2(2))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(63),h0tab(:,63),[26,5],[nMB,0],2,2,wf18(:,12),wf2(:,2))
  call Hloop_VA_Q(ntryL,G0H36(1),wf18(:,12),G0H2(4),m3h18x2(:,9),heltab2x36(:,:,63))
  call Hloop_A_Q(ntryL,G0H2(4),26,nMB,G1H2(10),n2h2(3))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(45)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(64),h0tab(:,64),[25,6],[nMB,0],2,2,wf18(:,13),wf2(:,4))
  call Hloop_VQ_A(ntryL,G0H36(1),wf18(:,13),G0H2(2),m3h18x2(:,10),heltab2x36(:,:,64))
  call Hloop_Q_A(ntryL,G0H2(2),25,nMB,G1H2(3),n2h2(4))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(65),h0tab(:,65),[22,9],[nMB,0],2,2,wf6(:,35),wf6(:,8))
  call Hloop_VA_Q(ntryL,G0H36(1),wf6(:,35),G0H6(8),m3h6x6(:,19),heltab2x36(:,:,65))
  call Hloop_A_Q(ntryL,G0H6(8),22,nMB,G1H6(10),n2h6(8))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(66),h0tab(:,66),[25,6],[nMB,0],2,2,wf18(:,14),wf2(:,4))
  call Hloop_VQ_A(ntryL,G0H36(1),wf18(:,14),G0H2(5),m3h18x2(:,11),heltab2x36(:,:,66))
  call Hloop_Q_A(ntryL,G0H2(5),25,nMB,G1H2(1),n2h2(5))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(48)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(67),h0tab(:,67),[17,14],[0,nMB],2,2,wf6(:,10),wf6(:,38))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,10),G0H6(4),m3h6x6(:,20),heltab2x36(:,:,67))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(68),h0tab(:,68),[25,6],[0,nMB],2,2,wf18(:,16),wf2(:,4))
  call Hloop_AQ_V(ntryL,G0H36(1),wf18(:,16),G0H2(6),m3h18x2(:,12),heltab2x36(:,:,68))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(69),h0tab(:,69),[18,13],[0,nMB],2,2,wf6(:,5),wf6(:,41))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,5),G0H6(1),m3h6x6(:,21),heltab2x36(:,:,69))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(70),h0tab(:,70),[22,9],[nMB,0],2,2,wf6(:,40),wf6(:,8))
  call Hloop_VA_Q(ntryL,G0H36(1),wf6(:,40),G0H6(9),m3h6x6(:,22),heltab2x36(:,:,70))
  call Hloop_A_Q(ntryL,G0H6(9),22,nMB,G1H6(5),n2h6(9))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(71),h0tab(:,71),[22,9],[nMB,0],2,2,wf6(:,43),wf6(:,8))
  call Hloop_VA_Q(ntryL,G0H36(1),wf6(:,43),G0H6(3),m3h6x6(:,23),heltab2x36(:,:,71))
  call Hloop_A_Q(ntryL,G0H6(3),22,nMB,G1H6(2),n2h6(10))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(72),h0tab(:,72),[21,10],[nMB,0],2,2,wf6(:,46),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H36(1),wf6(:,46),G0H6(10),m3h6x6(:,24),heltab2x36(:,:,72))
  call Hloop_Q_A(ntryL,G0H6(10),21,nMB,G1H6(1),n2h6(11))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(73),h0tab(:,73),[17,14],[0,nMB],2,2,wf6(:,10),wf6(:,45))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,10),G0H6(5),m3h6x6(:,25),heltab2x36(:,:,73))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(74),h0tab(:,74),[21,10],[0,nMB],2,2,wf6(:,48),wf6(:,2))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,48),G0H6(6),m3h6x6(:,26),heltab2x36(:,:,74))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(75),h0tab(:,75),[17,14],[0,nMB],2,2,wf6(:,10),wf6(:,50))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,10),G0H6(7),m3h6x6(:,27),heltab2x36(:,:,75))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(76),h0tab(:,76),[18,13],[nMB,0],2,2,wf6(:,5),wf6(:,52))
  call Hloop_VA_Q(ntryL,G0H36(1),wf6(:,5),G0H6(8),m3h6x6(:,28),heltab2x36(:,:,76))
  call Hloop_A_Q(ntryL,G0H6(8),18,nMB,G1H6(3),n2h6(12))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(1),[G1H6(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(10),[G1H2(7),G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(2),[G1H6(5),G1H6(10)])
  call Hcheck_last_QA_V(ntryL,l_switch,G1H6(1),wf6(:,2),G1tensor(1),m3h6x1(:,21),heltab2x6(:,:,53))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H2(10),wf2(:,2),G1tensor(31),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hloop_VQ_A(ntryL,G0H6(2),wf6(:,32),G0H1(1),m3h6x1(:,22),heltab2x6(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(12),n2h1(177))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H2(1),wf2(:,4),G1tensor(26),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H6(2),wf6(:,8),G1tensor(4),m3h6x1(:,23),heltab2x6(:,:,55))
  call Hloop_VA_Q(ntryL,G0H6(4),wf6(:,38),G0H1(1),m3h6x1(:,24),heltab2x6(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(10),n2h1(178))
  call Hloop_VA_Q(ntryL,G0H2(6),wf2(:,4),G0H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(22),n2h1(179))
  call Hloop_VQ_A(ntryL,G0H6(1),wf6(:,41),G0H1(1),m3h6x1(:,25),heltab2x6(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(35),n2h1(180))
  call Hloop_VA_Q(ntryL,G0H6(5),wf6(:,45),G0H1(1),m3h6x1(:,26),heltab2x6(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(41),n2h1(181))
  call Hloop_VA_Q(ntryL,G0H6(6),wf6(:,2),G0H1(1),m3h6x1(:,27),heltab2x6(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(46),n2h1(182))
  call Hloop_VA_Q(ntryL,G0H6(7),wf6(:,50),G0H1(1),m3h6x1(:,28),heltab2x6(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(51),n2h1(183))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H6(3),wf6(:,52),G1tensor(56),m3h6x1(:,29),heltab2x6(:,:,61))
  call ol_merge_tensors(G0tensor(172),[G0tensor(167),G0tensor(163),G0tensor(153),G0tensor(148),G0tensor(143),G0tensor(132) &
    ,G0tensor(118),G0tensor(54),G0tensor(104),G0tensor(52),G0tensor(47),G0tensor(56),G0tensor(6)])
  call ol_merge_tensors(G0tensor(78),[G0tensor(5),G0tensor(106),G0tensor(81),G0tensor(11)])
  call ol_merge_tensors(G1tensor(31),[G0tensor(34),G0tensor(23),G0tensor(16)])
  call ol_merge_tensors(G0tensor(175),[G0tensor(170),G0tensor(165),G0tensor(160),G0tensor(155),G0tensor(150),G0tensor(145) &
    ,G0tensor(140),G0tensor(135),G0tensor(130),G0tensor(125),G0tensor(120),G0tensor(109),G0tensor(94),G0tensor(88),G0tensor(68) &
    ,G0tensor(74),G0tensor(107),G0tensor(58),G0tensor(24),G0tensor(13),G0tensor(102),G0tensor(57),G0tensor(100),G0tensor(35) &
    ,G0tensor(19),G0tensor(65),G0tensor(9),G0tensor(3),G0tensor(27),G0tensor(2),G0tensor(96),G0tensor(71),G0tensor(46) &
    ,G0tensor(21)])
  call ol_merge_tensors(G0tensor(39),[G0tensor(75),G0tensor(90),G0tensor(61),G0tensor(31)])
  call ol_merge_tensors(G0tensor(93),[G0tensor(64),G0tensor(48),G0tensor(50),G0tensor(36)])
  call ol_merge_tensors(G0tensor(103),[G0tensor(59),G0tensor(4),G0tensor(30),G0tensor(91),G0tensor(41)])
  call ol_merge_tensors(G1tensor(26),[G0tensor(73),G0tensor(80),G0tensor(66)])
  call ol_merge_tensors(G0tensor(122),[G0tensor(117),G0tensor(97),G0tensor(115),G0tensor(86)])
  call ol_merge_tensors(G1tensor(46),[G0tensor(162),G0tensor(124),G0tensor(17),G0tensor(111)])
  call ol_merge_tensors(G0tensor(152),[G0tensor(113),G0tensor(92),G0tensor(42),G0tensor(7)])
  call ol_merge_tensors(G0tensor(154),[G0tensor(129),G0tensor(15),G0tensor(110),G0tensor(44),G0tensor(85),G0tensor(37) &
    ,G0tensor(12)])
  call ol_merge_tensors(G0tensor(144),[G0tensor(134),G0tensor(105),G0tensor(10),G0tensor(8)])
  call ol_merge_tensors(G1tensor(35),[G1tensor(12),G0tensor(149),G0tensor(139),G0tensor(70),G0tensor(55)])
  call ol_merge_tensors(G0tensor(147),[G0tensor(114),G0tensor(29),G0tensor(20)])
  call ol_merge_tensors(G1tensor(51),[G1tensor(41),G1tensor(10),G0tensor(164),G0tensor(159),G0tensor(72),G0tensor(45)])
  call ol_merge_tensors(G0tensor(127),[G0tensor(108),G0tensor(98),G0tensor(38),G0tensor(87),G0tensor(77),G0tensor(62)])
  call ol_merge_tensors(G0tensor(137),[G0tensor(79),G0tensor(14)])
  call ol_merge_tensors(G1tensor(22),[G0tensor(157),G0tensor(119),G0tensor(33)])
  call ol_merge_tensors(G0tensor(158),[G0tensor(142),G0tensor(138),G0tensor(133),G0tensor(128),G0tensor(123),G0tensor(99) &
    ,G0tensor(84)])
  call ol_merge_tensors(G1tensor(4),[G0tensor(168)])
  call ol_merge_tensors(G1tensor(56),[G0tensor(169)])
  call ol_merge_tensors(G1tensor(1),[G0tensor(173)])
call TI_bubble_red(G1tensor(31),26,mass2set(:,1),G0tensor(1),M2L1R1,G0tensor(26))
call TI_bubble_red(G1tensor(26),25,mass2set(:,1),G0tensor(51),M2L1R1,G0tensor(76))
call TI_bubble_red(G1tensor(46),21,mass2set(:,2),G0tensor(101),M2L1R1,G0tensor(32))
call TI_bubble_red(G1tensor(35),18,mass2set(:,2),G0tensor(22),M2L1R1,G0tensor(112))
call TI_bubble_red(G1tensor(51),17,mass2set(:,2),G0tensor(60),M2L1R1,G0tensor(18))
call TI_bubble_red(G1tensor(22),25,mass2set(:,2),G0tensor(95),M2L1R1,G0tensor(28))
call TI_bubble_red(G1tensor(4),22,mass2set(:,1),G0tensor(43),M2L1R1,G0tensor(25))
call TI_bubble_red(G1tensor(56),18,mass2set(:,1),G0tensor(40),M2L1R1,G0tensor(67))
call TI_bubble_red(G1tensor(1),21,mass2set(:,1),G0tensor(82),M2L1R1,G0tensor(49))
  call ol_merge_tensors(G0tensor(49),[G0tensor(67),G0tensor(25),G0tensor(28),G0tensor(18),G0tensor(112),G0tensor(32),G0tensor(76) &
    ,G0tensor(175),G0tensor(26)])
  call ol_merge_tensors(T0sum(59),[G0tensor(172)])
  call ol_merge_tensors(T0sum(60),[G0tensor(78)])
  call ol_merge_tensors(T0sum(61),[G0tensor(1)])
  call ol_merge_tensors(T0sum(62),[G0tensor(49)])
  call ol_merge_tensors(T0sum(63),[G0tensor(39)])
  call ol_merge_tensors(T0sum(64),[G0tensor(93)])
  call ol_merge_tensors(T0sum(65),[G0tensor(103)])
  call ol_merge_tensors(T0sum(66),[G0tensor(51)])
  call ol_merge_tensors(T0sum(67),[G0tensor(122)])
  call ol_merge_tensors(T0sum(68),[G0tensor(101)])
  call ol_merge_tensors(T0sum(69),[G0tensor(152)])
  call ol_merge_tensors(T0sum(70),[G0tensor(154)])
  call ol_merge_tensors(T0sum(71),[G0tensor(144)])
  call ol_merge_tensors(T0sum(72),[G0tensor(22)])
  call ol_merge_tensors(T0sum(73),[G0tensor(147)])
  call ol_merge_tensors(T0sum(74),[G0tensor(60)])
  call ol_merge_tensors(T0sum(75),[G0tensor(127)])
  call ol_merge_tensors(T0sum(76),[G0tensor(137)])
  call ol_merge_tensors(T0sum(77),[G0tensor(95)])
  call ol_merge_tensors(T0sum(78),[G0tensor(158)])
  call ol_merge_tensors(T0sum(79),[G0tensor(43)])
  call ol_merge_tensors(T0sum(80),[G0tensor(40)])
  call ol_merge_tensors(T0sum(81),[G0tensor(82)])
  call ol_merge_tensors(T0sum(82),[G0tensor(174)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 20, 21, 23 ],masses2_9,RedSet_4(5),ScalarBoxes(1))
  call compute_scalar_box([ 16, 21, 23 ],masses2_9,RedSet_4(6),ScalarBoxes(2))
  call compute_scalar_box([ 16, 20, 23 ],masses2_11,RedSet_4(7),ScalarBoxes(3))
  call compute_scalar_box([ 16, 20, 21 ],masses2_10,RedSet_4(1),ScalarBoxes(4))
  call compute_scalar_box([ 4, 5, 7 ],masses2_9,RedSet_4(8),ScalarBoxes(5))
  call compute_scalar_box([ 18, 19, 23 ],masses2_8,RedSet_4(9),ScalarBoxes(6))
  call compute_scalar_box([ 16, 19, 23 ],masses2_11,RedSet_4(10),ScalarBoxes(7))
  call compute_scalar_box([ 16, 18, 23 ],masses2_9,RedSet_4(11),ScalarBoxes(8))
  call compute_scalar_box([ 16, 18, 19 ],masses2_9,RedSet_4(2),ScalarBoxes(9))
  call compute_scalar_box([ 2, 3, 7 ],masses2_8,RedSet_4(12),ScalarBoxes(10))
  call compute_scalar_box([ 20, 22, 23 ],masses2_9,RedSet_4(13),ScalarBoxes(11))
  call compute_scalar_box([ 16, 22, 23 ],masses2_9,RedSet_4(14),ScalarBoxes(12))
  call compute_scalar_box([ 16, 20, 22 ],masses2_10,RedSet_4(3),ScalarBoxes(13))
  call compute_scalar_box([ 4, 6, 7 ],masses2_9,RedSet_4(15),ScalarBoxes(14))
  call compute_scalar_box([ 18, 19, 27 ],masses2_8,RedSet_4(16),ScalarBoxes(15))
  call compute_scalar_box([ 16, 19, 27 ],masses2_11,RedSet_4(17),ScalarBoxes(16))
  call compute_scalar_box([ 16, 18, 27 ],masses2_9,RedSet_4(18),ScalarBoxes(17))
  call compute_scalar_box([ 2, 3, 11 ],masses2_8,RedSet_4(19),ScalarBoxes(18))
  call compute_scalar_box([ 17, 19, 23 ],masses2_8,RedSet_4(20),ScalarBoxes(19))
  call compute_scalar_box([ 16, 17, 23 ],masses2_9,RedSet_4(21),ScalarBoxes(20))
  call compute_scalar_box([ 16, 17, 19 ],masses2_9,RedSet_4(4),ScalarBoxes(21))
  call compute_scalar_box([ 1, 3, 7 ],masses2_8,RedSet_4(22),ScalarBoxes(22))
  call compute_scalar_box([ 17, 19, 27 ],masses2_8,RedSet_4(23),ScalarBoxes(23))
  call compute_scalar_box([ 16, 17, 27 ],masses2_9,RedSet_4(24),ScalarBoxes(24))
  call compute_scalar_box([ 1, 3, 11 ],masses2_8,RedSet_4(25),ScalarBoxes(25))
! end of process


end subroutine vamp_1

end module ol_vamp_1_pphvv_bbxhzz_1_/**/REALKIND
