
module ol_vamp_1_pphvv_bbxhwwx_2_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphvv_bbxhwwx_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphvv_bbxhwwx_2.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pphvv_bbxhwwx_2_/**/DREALKIND
  use ol_tensor_sum_storage_pphvv_bbxhwwx_2_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_pphvv_bbxhwwx_2_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pphvv_bbxhwwx_2_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1),h0tab(:,1),[28,1,2],[0,0,0],3,1,wf9(:,3))
  call Hloop_AV_Q(ntryL,G0H36(1),wf9(:,3),G0H4(1),m3h9x4(:,1),heltab2x36(:,:,1))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(1),n2h4(1))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2),h0tab(:,2),[28,1,2],[0,0,0],3,1,wf9(:,4))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf9(:,4),G0H4(1),ngZd,m3h9x4(:,2),heltab2x36(:,:,2))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(2),n2h4(2))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(3),h0tab(:,3),[28,1,2],[0,0,0],3,1,wf9(:,5))
  call Hloop_AV_Q(ntryL,G0H36(1),wf9(:,5),G0H4(1),m3h9x4(:,3),heltab2x36(:,:,3))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(3),n2h4(3))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(4),h0tab(:,4),[28,1,2],[0,0,0],3,1,wf9(:,6))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf9(:,6),G0H4(1),ngZd,m3h9x4(:,4),heltab2x36(:,:,4))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(4),n2h4(4))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(5),h0tab(:,5),[28,1,2],[0,0,0],3,1,wf9(:,7))
  call Hloop_AV_Q(ntryL,G0H36(1),wf9(:,7),G0H4(1),m3h9x4(:,5),heltab2x36(:,:,5))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(5),n2h4(5))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(6),h0tab(:,6),[28,1,2],[0,0,0],3,1,wf9(:,8))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf9(:,8),G0H4(1),ngZd,m3h9x4(:,6),heltab2x36(:,:,6))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(6),n2h4(6))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(7),h0tab(:,7),[28,1,2],[0,0,0],3,1,wf9(:,9))
  call Hloop_AV_Q(ntryL,G0H36(1),wf9(:,9),G0H4(1),m3h9x4(:,7),heltab2x36(:,:,7))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(7),n2h4(7))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(8),h0tab(:,8),[28,1,2],[0,0,0],3,1,wf9(:,10))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf9(:,10),G0H4(1),ngZd,m3h9x4(:,8),heltab2x36(:,:,8))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(8),n2h4(8))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(9),h0tab(:,9),[28,1,2],[0,0,0],3,1,wf9(:,12))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf9(:,12),G0H4(1),ngZd,m3h9x4(:,9),heltab2x36(:,:,9))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(9),n2h4(9))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(9),[G1H4(8),G1H4(7),G1H4(6),G1H4(5),G1H4(4),G1H4(3) &
    ,G1H4(2),G1H4(1)])
  call Hloop_AQ_V(ntryL,G1H4(9),ex1(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_VA_Q(ntryL,G1H2(1),ex2(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(1),n2h1(1))
  call TI_triangle_red(G2tensor(1),RedBasis(1),mass3set(:,1),G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),M2L1R1)
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(2)])
  call ol_merge_tensors(T0sum(3),[G0tensor(3)])
  call ol_merge_tensors(T0sum(4),[G0tensor(4)])
! end of process


end subroutine vamp_1

end module ol_vamp_1_pphvv_bbxhwwx_2_/**/REALKIND
