
module ol_colourmatrix_pphvv_bbxhzz_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(17,1), K2(17,1), KL(17,1), Cas(5) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  3]
  K1( 2,:) = [  4]
  K1( 3,:) = [ -4]
  K1( 4,:) = [  4]
  K1( 5,:) = [  0]
  K1( 6,:) = [  0]
  K1( 7,:) = [  0]
  K1( 8,:) = [  0]
  K1( 9,:) = [  0]
  K1(10,:) = [  0]
  K1(11,:) = [  0]
  K1(12,:) = [  0]
  K1(13,:) = [  0]
  K1(14,:) = [  0]
  K1(15,:) = [  0]
  K1(16,:) = [  0]
  K1(17,:) = [  0]

  K2( 1,:) = [  3]
  K2( 2,:) = [  4]
  K2( 3,:) = [ -4]
  K2( 4,:) = [  4]
  K2( 5,:) = [  0]
  K2( 6,:) = [  0]
  K2( 7,:) = [  0]
  K2( 8,:) = [  0]
  K2( 9,:) = [  0]
  K2(10,:) = [  0]
  K2(11,:) = [  0]
  K2(12,:) = [  0]
  K2(13,:) = [  0]
  K2(14,:) = [  0]
  K2(15,:) = [  0]
  K2(16,:) = [  0]
  K2(17,:) = [  0]

  KL( 1,:) = [  3]
  KL( 2,:) = [  4]
  KL( 3,:) = [ -4]
  KL( 4,:) = [  4]
  KL( 5,:) = [  0]
  KL( 6,:) = [  0]
  KL( 7,:) = [  0]
  KL( 8,:) = [  0]
  KL( 9,:) = [  0]
  KL(10,:) = [  0]
  KL(11,:) = [  0]
  KL(12,:) = [  0]
  KL(13,:) = [  0]
  KL(14,:) = [  0]
  KL(15,:) = [  0]
  KL(16,:) = [  0]
  KL(17,:) = [  0]

#if 1 > 0
    co = 0
    do k = 1, 5
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_pphvv_bbxhzz_1_/**/REALKIND



module ol_forced_parameters_pphvv_bbxhzz_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pphvv_bbxhzz_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_pphvv_bbxhzz_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 36 ! number of helicity configurations
  integer(intkind2), save :: nhel = 36 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 36 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(36) ! physical helicity states
  integer(intkind2), save :: nhflip = 36    ! relevant helicities for helicity-flipped interference
  integer(intkind2), save :: helflip(2,36) ! Table for the helicity-flipped interference
  integer(intkind2), save, allocatable :: hflip(:,:)
  integer(intkind2) :: tsb
  integer, save :: pi_flip_bak = -1, pj_flip_bak = -1
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(71)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(1), ex4(3), ex5(3)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf2(2,10), wf3(3,4), wf4(4,10), wf6(6,52), wf9(9,5), wf12(12,16), wf18(18,16), wf36(36,68)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(22), c(6)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_pphvv_bbxhzz_1_/**/REALKIND






! **********************************************************************
module ol_loop_pphvv_bbxhzz_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_pphvv_bbxhzz_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED**3*MB)/(4._/**/REALKIND*cw**2*MW*sw**3)
    f( 2) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(4._/**/REALKIND*cw**2*MW*sw**3)
    f( 3) = (CI*eQED**3*MB**2)/(4._/**/REALKIND*cw**2*MW*sw**3)
    f( 4) = (CI*countertermnorm*eQED**3*gQCD**2*MB**2)/(4._/**/REALKIND*cw**2*MW*sw**3)
    f( 5) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB**2)/(4._/**/REALKIND*cw**2*MW*sw**3)
    f( 6) = (3*CI*eQED**3*lambdaHHH*MB*MH**2)/(4._/**/REALKIND*cw**2*MW*sw**3)
    f( 7) = (3*CI*countertermnorm*ctSbb*eQED**3*gQCD**2*lambdaHHH*MB*MH**2)/(4._/**/REALKIND*cw**2*MW*sw**3)
    f( 8) = (CI*eQED**3*MB*MW)/(2._/**/REALKIND*cw**4*sw**3)
    f( 9) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB*MW)/(2._/**/REALKIND*cw**4*sw**3)
    f(10) = (CI*eQED**3*MB)/(2._/**/REALKIND*MW*sw)
    f(11) = (CI*countertermnorm*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*MW*sw)
    f(12) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*MW*sw)
    f(13) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*MW*sw)
    f(14) = (CI*eQED**3*MW)/(cw**2*sw)
    f(15) = (CI*countertermnorm*eQED**3*gQCD**2*MW)/(cw**2*sw)
    f(16) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MW)/(cw**2*sw)
    f(17) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(18) = (eQED**3*gQCD**2*integralnorm*MB**2*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(19) = (3*eQED**3*gQCD**2*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(20) = (eQED**3*gQCD**2*integralnorm*MB*MW*SwB)/(cw**4*sw**3*2._/**/REALKIND)
    f(21) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(MW*sw*2._/**/REALKIND)
    f(22) = (eQED**3*gQCD**2*integralnorm*MW*SwB)/(cw**2*sw)

  c = [ 4*f(17), 4*f(18), 4*f(19), 4*f(20), 4*f(21), 4*f(22) ]
  c = (1._/**/REALKIND / 3) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3) - MH2)+L(6,3))
  den(2) = 1 /((L(5,12) - MZ2)+L(6,12))
  den(4) = 1 /((L(5,20) - MZ2)+L(6,20))
  den(6) = 1 /((L(5,24) - MH2)+L(6,24))
  den(8) = 1 /((L(5,5) - MB2)+L(6,5))
  den(9) = 1 /((L(5,10) - MB2)+L(6,10))
  den(11) = 1 /((L(5,18) - MB2)+L(6,18))
  den(14) = 1 /((L(5,9) - MB2)+L(6,9))
  den(15) = 1 /((L(5,6) - MB2)+L(6,6))
  den(17) = 1 /((L(5,17) - MB2)+L(6,17))
  den(26) = 1 /((L(5,28) - MH2)+L(6,28))
  den(27) = 1 /((L(5,26) - MB2)+L(6,26))
  den(30) = 1 /((L(5,21) - MB2)+L(6,21))
  den(35) = 1 /((L(5,13) - MB2)+L(6,13))
  den(40) = 1 /((L(5,22) - MB2)+L(6,22))
  den(43) = 1 /((L(5,25) - MB2)+L(6,25))
  den(46) = 1 /((L(5,14) - MB2)+L(6,14))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(1)*den(4)
  den(7) = den(1)*den(6)
  den(10) = den(8)*den(9)
  den(12) = den(8)*den(11)
  den(13) = den(6)*den(8)
  den(16) = den(14)*den(15)
  den(18) = den(15)*den(17)
  den(19) = den(6)*den(15)
  den(20) = den(11)*den(14)
  den(21) = den(4)*den(14)
  den(22) = den(9)*den(17)
  den(23) = den(4)*den(9)
  den(24) = den(2)*den(17)
  den(25) = den(2)*den(11)
  den(28) = den(9)*den(27)
  den(29) = den(8)*den(28)
  den(31) = den(8)*den(30)
  den(32) = den(9)*den(31)
  den(33) = den(11)*den(27)
  den(34) = den(8)*den(33)
  den(36) = den(8)*den(35)
  den(37) = den(11)*den(36)
  den(38) = den(6)*den(27)
  den(39) = den(8)*den(38)
  den(41) = den(15)*den(40)
  den(42) = den(14)*den(41)
  den(44) = den(14)*den(43)
  den(45) = den(15)*den(44)
  den(47) = den(15)*den(46)
  den(48) = den(17)*den(47)
  den(49) = den(17)*den(43)
  den(50) = den(15)*den(49)
  den(51) = den(6)*den(43)
  den(52) = den(15)*den(51)
  den(53) = den(11)*den(40)
  den(54) = den(14)*den(53)
  den(55) = den(14)*den(35)
  den(56) = den(11)*den(55)
  den(57) = den(4)*den(40)
  den(58) = den(14)*den(57)
  den(59) = den(9)*den(46)
  den(60) = den(17)*den(59)
  den(61) = den(17)*den(30)
  den(62) = den(9)*den(61)
  den(63) = den(4)*den(30)
  den(64) = den(9)*den(63)
  den(65) = den(2)*den(46)
  den(66) = den(17)*den(65)
  den(67) = den(2)*den(35)
  den(68) = den(11)*den(67)
  den(69) = den(2)*den(26)
  den(70) = den(4)*den(26)
  den(71) = den(6)*den(26)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_pphvv_bbxhzz_1_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,68))
  allocate(M1helarray(1,hel_states))
  allocate(M1helarray_ct(1,hel_states))
  allocate(M0_col1_helarray(1,hel_states))
  A(1:hel_states,1:68)%j = 0
  A(1:hel_states,1:68)%e = 0
  A(1:hel_states,1:68)%hf = 0
  A(1:hel_states,1:68)%s = 0
#if 1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(1,hel_states,16))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
#else
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
  use ol_loop_storage_pphvv_bbxhzz_1_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for bottom anti-bottom higgs Z Z -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_pphvv_bbxhzz_1, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_pphvv_bbxhzz_1, only: &
    & external_perm_pphvv_bbxhzz_1, &
    & external_perm_inv_pphvv_bbxhzz_1, &
    & extcomb_perm_pphvv_bbxhzz_1, &
    & average_factor_pphvv_bbxhzz_1
  use ol_external_pphvv_bbxhzz_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_pphvv_bbxhzz_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pphvv_bbxhzz_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_pphvv_bbxhzz_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02
  logical, intent(in) :: qp_kinematics
  real(REALKIND),  intent(out), optional :: M2ct
  real(REALKIND),  intent(out), optional :: M2colint(16)
  real(REALKIND) :: iM2ct
  real(REALKIND) :: iM2colint(16)

  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(1), M2(1)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak
  logical              :: do_ct, do_colint
#if 5 > 3
  integer :: ind_cc_comb(5)
#endif
  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if (present(M2ct)) then
    do_ct = .true.
  else
    do_ct = .false.
  end if

  if (present(M2colint)) then
    do_colint = .true.
  else
    do_colint = .false.
  end if

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, qp_kinematics, M2ct=iM2ct, M2colint=iM2colint)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,68))
  end if

  if (do_ct) call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()
  if (do_ct) call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  if (do_ct) call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMB, nMB, nMH, nMZ, nMZ ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_pphvv_bbxhzz_1, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMB, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rMB, H2, ex2, POLSEL(2),2)
  call pol_wf_S(P(:,3), rMH, H3, ex3, POLSEL(3),3)
  call pol_wf_V(P(:,4), rMZ, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rMZ, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_VVS_S(ntry, ex4(:), ex5(:), ex3(:), wf9(:,1), n4(:,1), t4x9(:,:,1))
  call vert_SV_V(ntry, ex3(:), ex4(:), wf3(:,1), n3(:,2), t3x3(:,:,1))
  call prop_W_W(ntry, wf3(:,1), 12, MZ, 1_intkind1, wf3(:,2), n2(1))
  call vert_SV_V(ntry, wf4(:,1), ex5(:), wf12(:,1), n3(:,3), t3x12(:,:,1))
  call vert_SV_V(ntry, ex3(:), ex5(:), wf3(:,3), n3(:,4), t3x3(:,:,2))
  call prop_W_W(ntry, wf3(:,3), 20, MZ, 1_intkind1, wf3(:,4), n2(2))
  call vert_SV_V(ntry, wf4(:,1), ex4(:), wf12(:,2), n3(:,5), t3x12(:,:,2))
  call vert_VV_S(ntry, ex4(:), ex5(:), wf9(:,2), n3(:,6), t3x9(:,:,1))
  call vert_SS_S(ntry, wf4(:,1), ex3(:), wf4(:,2), n3(:,7), t3x4(:,:,2))
  call vert_QS_A(gH,ntry, ex1(:), ex3(:), wf2(:,1), n3(:,8), t3x2(:,:,1))
  call vert_AZ_Q(gZd,ntry, ex2(:), ex4(:), wf6(:,1), n3(:,9), t3x6(:,:,1))
  call prop_Q_A(ntry, wf2(:,1), 5, MB, 1_intkind1, wf2(:,2), n2(3))
  call prop_A_Q(ntry, wf6(:,1), 10, MB, 1_intkind1, wf6(:,2), n2(4))
  call vert_ZQ_A(gZd,ntry, ex5(:), wf2(:,2), wf6(:,3), n3(:,10), t3x6(:,:,2))
  call vert_AZ_Q(gZd,ntry, ex2(:), ex5(:), wf6(:,4), n3(:,11), t3x6(:,:,3))
  call prop_A_Q(ntry, wf6(:,4), 18, MB, 1_intkind1, wf6(:,5), n2(5))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf2(:,2), wf6(:,6), n3(:,12), t3x6(:,:,4))
  call vert_AQ_S(gH,ntry, ex2(:), wf2(:,2), wf4(:,3), n3(:,13), t3x4(:,:,3))
  call vert_ZQ_A(gZd,ntry, ex4(:), ex1(:), wf6(:,7), n3(:,14), t3x6(:,:,5))
  call vert_SA_Q(gH,ntry, ex3(:), ex2(:), wf2(:,3), n3(:,15), t3x2(:,:,2))
  call prop_Q_A(ntry, wf6(:,7), 9, MB, 1_intkind1, wf6(:,8), n2(6))
  call prop_A_Q(ntry, wf2(:,3), 6, MB, 1_intkind1, wf2(:,4), n2(7))
  call vert_ZQ_A(gZd,ntry, ex5(:), wf6(:,8), wf18(:,1), n3(:,16), t3x18(:,:,1))
  call vert_ZQ_A(gZd,ntry, ex5(:), ex1(:), wf6(:,9), n3(:,17), t3x6(:,:,6))
  call prop_Q_A(ntry, wf6(:,9), 17, MB, 1_intkind1, wf6(:,10), n2(8))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf6(:,10), wf18(:,2), n3(:,18), t3x18(:,:,2))
  call vert_AQ_S(gH,ntry, wf2(:,4), ex1(:), wf4(:,4), n3(:,19), t3x4(:,:,4))
  call vert_QS_A(gH,ntry, wf6(:,8), ex3(:), wf6(:,11), n3(:,20), t3x6(:,:,7))
  call vert_QA_Z(gZd,ntry, wf6(:,8), ex2(:), wf12(:,3), n3(:,21), t3x12(:,:,3))
  call vert_QS_A(gH,ntry, wf6(:,10), ex3(:), wf6(:,12), n3(:,22), t3x6(:,:,8))
  call vert_QA_Z(gZd,ntry, ex1(:), wf6(:,2), wf12(:,4), n3(:,23), t3x12(:,:,4))
  call vert_QA_Z(gZd,ntry, wf6(:,10), ex2(:), wf12(:,5), n3(:,24), t3x12(:,:,5))
  call vert_QA_Z(gZd,ntry, ex1(:), wf6(:,5), wf12(:,6), n3(:,25), t3x12(:,:,6))
  call counter_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,5), n3(:,26), t3x4(:,:,5))
  call counter_ZQ_A(gZd,ntry, ex5(:), wf2(:,2), wf6(:,13), n3(:,27), t3x6(:,:,9))
  call counter_ZQ_A(gZd,ntry, ex4(:), wf2(:,2), wf6(:,14), n3(:,28), t3x6(:,:,10))
  call counter_ZQ_A(gZd,ntry, ex5(:), wf6(:,8), wf18(:,3), n3(:,29), t3x18(:,:,3))
  call counter_ZQ_A(gZd,ntry, ex4(:), wf6(:,10), wf18(:,4), n3(:,30), t3x18(:,:,4))
  call counter_QS_A(gH,ntry, wf6(:,8), ex3(:), wf6(:,15), n3(:,31), t3x6(:,:,11))
  call counter_QS_A(gH,ntry, wf6(:,10), ex3(:), wf6(:,16), n3(:,32), t3x6(:,:,12))
  call counter_AQ_S(gH,ntry, ex2(:), wf2(:,2), wf4(:,6), n3(:,33), t3x4(:,:,6))
  call counter_AZ_Q(gZd,ntry, ex2(:), ex5(:), wf6(:,17), n3(:,34), t3x6(:,:,13))
  call prop_A_Q(ntry, wf6(:,17), 18, MB, 1_intkind1, wf6(:,18), n2(9))
  call counter_AZ_Q(gZd,ntry, ex2(:), ex4(:), wf6(:,19), n3(:,35), t3x6(:,:,14))
  call prop_A_Q(ntry, wf6(:,19), 10, MB, 1_intkind1, wf6(:,20), n2(10))
  call counter_QA_Z(gZd,ntry, wf6(:,8), ex2(:), wf12(:,7), n3(:,36), t3x12(:,:,7))
  call counter_QA_Z(gZd,ntry, wf6(:,10), ex2(:), wf12(:,8), n3(:,37), t3x12(:,:,8))
  call vert_QA_Z(gZd,ntry, ex1(:), wf6(:,18), wf12(:,9), n3(:,38), t3x12(:,:,9))
  call vert_QA_Z(gZd,ntry, ex1(:), wf6(:,20), wf12(:,10), n3(:,39), t3x12(:,:,10))
  call counter_SA_Q(gH,ntry, ex3(:), ex2(:), wf2(:,5), n3(:,40), t3x2(:,:,3))
  call prop_A_Q(ntry, wf2(:,5), 6, MB, 1_intkind1, wf2(:,6), n2(11))
  call vert_AQ_S(gH,ntry, wf2(:,6), ex1(:), wf4(:,7), n3(:,41), t3x4(:,:,7))
  call counter_AQ_S(gH,ntry, wf2(:,4), ex1(:), wf4(:,8), n3(:,42), t3x4(:,:,8))
  call counter_ZQ_A(gZd,ntry, ex5(:), ex1(:), wf6(:,21), n3(:,43), t3x6(:,:,15))
  call prop_Q_A(ntry, wf6(:,21), 17, MB, 1_intkind1, wf6(:,22), n2(12))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf6(:,22), wf18(:,5), n3(:,44), t3x18(:,:,5))
  call counter_ZQ_A(gZd,ntry, ex4(:), ex1(:), wf6(:,23), n3(:,45), t3x6(:,:,16))
  call prop_Q_A(ntry, wf6(:,23), 9, MB, 1_intkind1, wf6(:,24), n2(13))
  call vert_ZQ_A(gZd,ntry, ex5(:), wf6(:,24), wf18(:,6), n3(:,46), t3x18(:,:,6))
  call counter_QA_Z(gZd,ntry, ex1(:), wf6(:,2), wf12(:,11), n3(:,47), t3x12(:,:,11))
  call vert_QS_A(gH,ntry, wf6(:,22), ex3(:), wf6(:,25), n3(:,48), t3x6(:,:,17))
  call counter_QA_Z(gZd,ntry, ex1(:), wf6(:,5), wf12(:,12), n3(:,49), t3x12(:,:,12))
  call vert_QA_Z(gZd,ntry, wf6(:,22), ex2(:), wf12(:,13), n3(:,50), t3x12(:,:,13))
  call vert_QS_A(gH,ntry, wf6(:,24), ex3(:), wf6(:,26), n3(:,51), t3x6(:,:,18))
  call vert_QA_Z(gZd,ntry, wf6(:,24), ex2(:), wf12(:,14), n3(:,52), t3x12(:,:,14))
  call counter_QS_A(gH,ntry, ex1(:), ex3(:), wf2(:,7), n3(:,53), t3x2(:,:,4))
  call prop_Q_A(ntry, wf2(:,7), 5, MB, 1_intkind1, wf2(:,8), n2(14))
  call vert_ZQ_A(gZd,ntry, ex5(:), wf2(:,8), wf6(:,27), n3(:,54), t3x6(:,:,19))
  call vert_ZQ_A(gZd,ntry, ex4(:), wf2(:,8), wf6(:,28), n3(:,55), t3x6(:,:,20))
  call vert_AQ_S(gH,ntry, ex2(:), wf2(:,8), wf4(:,9), n3(:,56), t3x4(:,:,9))
  call vert_SV_V(ntry, wf4(:,5), ex5(:), wf12(:,15), n3(:,57), t3x12(:,:,15))
  call vert_SV_V(ntry, wf4(:,5), ex4(:), wf12(:,16), n3(:,58), t3x12(:,:,16))
  call vert_SS_S(ntry, wf4(:,5), ex3(:), wf4(:,10), n3(:,59), t3x4(:,:,10))
  call vert_AZ_Q(gZd,ntry, wf6(:,2), ex5(:), wf18(:,7), n3(:,60), t3x18(:,:,7))
  call counter_Q_A(ctbb,5,ntry, wf2(:,2), 5, wf2(:,9), n2(15))
  call prop_A_Q(ntry, wf18(:,7), 26, MB, 1_intkind1, wf18(:,8), n2(16))
  call counter_A_Q(ctbb,5,ntry, wf6(:,2), 10, wf6(:,29), n2(17))
  call prop_Q_A(ntry, wf6(:,3), 21, MB, 1_intkind1, wf6(:,30), n2(18))
  call vert_AZ_Q(gZd,ntry, wf6(:,5), ex4(:), wf18(:,9), n3(:,61), t3x18(:,:,8))
  call prop_A_Q(ntry, wf18(:,9), 26, MB, 1_intkind1, wf18(:,10), n2(19))
  call counter_A_Q(ctbb,5,ntry, wf6(:,5), 18, wf6(:,31), n2(20))
  call prop_Q_A(ntry, wf6(:,6), 13, MB, 1_intkind1, wf6(:,32), n2(21))
  call vert_SA_Q(gH,ntry, wf9(:,2), ex2(:), wf18(:,11), n3(:,62), t3x18(:,:,9))
  call prop_A_Q(ntry, wf18(:,11), 26, MB, 1_intkind1, wf18(:,12), n2(22))
  call vert_AZ_Q(gZd,ntry, wf2(:,4), ex5(:), wf6(:,33), n3(:,63), t3x6(:,:,21))
  call counter_Q_A(ctbb,5,ntry, wf6(:,8), 9, wf6(:,34), n2(23))
  call prop_A_Q(ntry, wf6(:,33), 22, MB, 1_intkind1, wf6(:,35), n2(24))
  call counter_A_Q(ctbb,5,ntry, wf2(:,4), 6, wf2(:,10), n2(25))
  call prop_Q_A(ntry, wf18(:,1), 25, MB, 1_intkind1, wf18(:,13), n2(26))
  call vert_AZ_Q(gZd,ntry, wf2(:,4), ex4(:), wf6(:,36), n3(:,64), t3x6(:,:,22))
  call counter_Q_A(ctbb,5,ntry, wf6(:,10), 17, wf6(:,37), n2(27))
  call prop_A_Q(ntry, wf6(:,36), 14, MB, 1_intkind1, wf6(:,38), n2(28))
  call prop_Q_A(ntry, wf18(:,2), 25, MB, 1_intkind1, wf18(:,14), n2(29))
  call vert_QS_A(gH,ntry, ex1(:), wf9(:,2), wf18(:,15), n3(:,65), t3x18(:,:,10))
  call prop_Q_A(ntry, wf18(:,15), 25, MB, 1_intkind1, wf18(:,16), n2(30))
  call vert_SA_Q(gH,ntry, ex3(:), wf6(:,5), wf6(:,39), n3(:,66), t3x6(:,:,23))
  call prop_A_Q(ntry, wf6(:,39), 22, MB, 1_intkind1, wf6(:,40), n2(31))
  call prop_Q_A(ntry, wf6(:,11), 13, MB, 1_intkind1, wf6(:,41), n2(32))
  call vert_AZ_Q(gZd,ntry, ex2(:), wf3(:,4), wf6(:,42), n3(:,67), t3x6(:,:,24))
  call prop_A_Q(ntry, wf6(:,42), 22, MB, 1_intkind1, wf6(:,43), n2(33))
  call vert_SA_Q(gH,ntry, ex3(:), wf6(:,2), wf6(:,44), n3(:,68), t3x6(:,:,25))
  call prop_A_Q(ntry, wf6(:,44), 14, MB, 1_intkind1, wf6(:,45), n2(34))
  call prop_Q_A(ntry, wf6(:,12), 21, MB, 1_intkind1, wf6(:,46), n2(35))
  call vert_ZQ_A(gZd,ntry, wf3(:,4), ex1(:), wf6(:,47), n3(:,69), t3x6(:,:,26))
  call prop_Q_A(ntry, wf6(:,47), 21, MB, 1_intkind1, wf6(:,48), n2(36))
  call vert_AZ_Q(gZd,ntry, ex2(:), wf3(:,2), wf6(:,49), n3(:,70), t3x6(:,:,27))
  call prop_A_Q(ntry, wf6(:,49), 14, MB, 1_intkind1, wf6(:,50), n2(37))
  call vert_ZQ_A(gZd,ntry, wf3(:,2), ex1(:), wf6(:,51), n3(:,71), t3x6(:,:,28))
  call prop_Q_A(ntry, wf6(:,51), 13, MB, 1_intkind1, wf6(:,52), n2(38))
  call vert_VV_S(ntry, wf3(:,2), ex5(:), wf9(:,3), n3(:,72), t3x9(:,:,2))
  call vert_VV_S(ntry, ex4(:), wf3(:,4), wf9(:,4), n3(:,73), t3x9(:,:,3))
  call vert_SS_S(ntry, ex3(:), wf9(:,2), wf9(:,5), n3(:,74), t3x9(:,:,4))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    if (do_ct) call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  if (do_ct) M2ct = 0
  if (do_colint) M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    if (do_ct) call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      if (do_colint) call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    if (do_ct) M2ct = M2ct + M2add_ct
    if (do_colint) M2colint = M2colint + M2add_colint
  end do

#if 1 > 0 && 5 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    ind_cc_comb = [2,4,7,5,8]
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 5
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2

  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 3
do i4= 1, 3
do i3= 1, 1
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_SS(nsync, wf4(:,1), wf9(:,1), A(:,1), n3(:,75), t3x36(:,:,1), nhel, den(1))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,1), A(:,2), n3(:,76), t3x36(:,:,2), nhel, den(3))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,2), A(:,3), n3(:,77), t3x36(:,:,3), nhel, den(5))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,2), A(:,4), n3(:,78), t3x36(:,:,4), nhel, den(7))
    call Hcont_QA(nsync, wf6(:,2), wf6(:,3), A(:,5), n3(:,79), t3x36(:,:,5), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,5), wf6(:,6), A(:,6), n3(:,80), t3x36(:,:,6), nhel, den(12))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,3), A(:,7), n3(:,81), t3x36(:,:,7), nhel, den(13))
    call Hcont_QA(nsync, wf2(:,4), wf18(:,1), A(:,8), n3(:,82), t3x36(:,:,8), nhel, den(16))
    call Hcont_QA(nsync, wf2(:,4), wf18(:,2), A(:,9), n3(:,83), t3x36(:,:,9), nhel, den(18))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,4), A(:,10), n3(:,84), t3x36(:,:,10), nhel, den(19))
    call Hcont_QA(nsync, wf6(:,5), wf6(:,11), A(:,11), n3(:,85), t3x36(:,:,11), nhel, den(20))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,3), A(:,12), n3(:,86), t3x36(:,:,12), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,2), wf6(:,12), A(:,13), n3(:,87), t3x36(:,:,13), nhel, den(22))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,4), A(:,14), n3(:,88), t3x36(:,:,14), nhel, den(23))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,5), A(:,15), n3(:,89), t3x36(:,:,15), nhel, den(24))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,6), A(:,16), n3(:,90), t3x36(:,:,16), nhel, den(25))

    call Hcont_SS(nsync, wf9(:,1), wf4(:,5), A(:,17), n3(:,91), t3x36(:,:,17), nhel, den(26))
    call Hcont_QA(nsync, wf6(:,2), wf6(:,13), A(:,18), n3(:,92), t3x36(:,:,18), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,5), wf6(:,14), A(:,19), n3(:,93), t3x36(:,:,19), nhel, den(12))
    call Hcont_QA(nsync, wf2(:,4), wf18(:,3), A(:,20), n3(:,94), t3x36(:,:,20), nhel, den(16))
    call Hcont_QA(nsync, wf2(:,4), wf18(:,4), A(:,21), n3(:,95), t3x36(:,:,21), nhel, den(18))
    call Hcont_QA(nsync, wf6(:,5), wf6(:,15), A(:,22), n3(:,96), t3x36(:,:,22), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,2), wf6(:,16), A(:,23), n3(:,97), t3x36(:,:,23), nhel, den(22))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,6), A(:,24), n3(:,98), t3x36(:,:,24), nhel, den(13))
    call Hcont_QA(nsync, wf6(:,6), wf6(:,18), A(:,25), n3(:,99), t3x36(:,:,25), nhel, den(12))
    call Hcont_QA(nsync, wf6(:,3), wf6(:,20), A(:,26), n3(:,100), t3x36(:,:,26), nhel, den(10))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,7), A(:,27), n3(:,101), t3x36(:,:,27), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,11), wf6(:,18), A(:,28), n3(:,102), t3x36(:,:,28), nhel, den(20))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,8), A(:,29), n3(:,103), t3x36(:,:,29), nhel, den(24))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,9), A(:,30), n3(:,104), t3x36(:,:,30), nhel, den(25))
    call Hcont_QA(nsync, wf6(:,12), wf6(:,20), A(:,31), n3(:,105), t3x36(:,:,31), nhel, den(22))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,10), A(:,32), n3(:,106), t3x36(:,:,32), nhel, den(23))
    call Hcont_QA(nsync, wf18(:,1), wf2(:,6), A(:,33), n3(:,107), t3x36(:,:,33), nhel, den(16))
    call Hcont_QA(nsync, wf18(:,2), wf2(:,6), A(:,34), n3(:,108), t3x36(:,:,34), nhel, den(18))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,7), A(:,35), n3(:,109), t3x36(:,:,35), nhel, den(19))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,8), A(:,36), n3(:,110), t3x36(:,:,36), nhel, den(19))
    call Hcont_QA(nsync, wf2(:,4), wf18(:,5), A(:,37), n3(:,111), t3x36(:,:,37), nhel, den(18))
    call Hcont_QA(nsync, wf2(:,4), wf18(:,6), A(:,38), n3(:,112), t3x36(:,:,38), nhel, den(16))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,11), A(:,39), n3(:,113), t3x36(:,:,39), nhel, den(23))
    call Hcont_QA(nsync, wf6(:,2), wf6(:,25), A(:,40), n3(:,114), t3x36(:,:,40), nhel, den(22))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,12), A(:,41), n3(:,115), t3x36(:,:,41), nhel, den(25))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,13), A(:,42), n3(:,116), t3x36(:,:,42), nhel, den(24))
    call Hcont_QA(nsync, wf6(:,5), wf6(:,26), A(:,43), n3(:,117), t3x36(:,:,43), nhel, den(20))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,14), A(:,44), n3(:,118), t3x36(:,:,44), nhel, den(21))
    call Hcont_QA(nsync, wf6(:,2), wf6(:,27), A(:,45), n3(:,119), t3x36(:,:,45), nhel, den(10))
    call Hcont_QA(nsync, wf6(:,5), wf6(:,28), A(:,46), n3(:,120), t3x36(:,:,46), nhel, den(12))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,9), A(:,47), n3(:,121), t3x36(:,:,47), nhel, den(13))
    call Hcont_VV(nsync, wf3(:,2), wf12(:,15), A(:,48), n3(:,122), t3x36(:,:,48), nhel, den(3))
    call Hcont_VV(nsync, wf3(:,4), wf12(:,16), A(:,49), n3(:,123), t3x36(:,:,49), nhel, den(5))
    call Hcont_SS(nsync, wf9(:,2), wf4(:,10), A(:,50), n3(:,124), t3x36(:,:,50), nhel, den(7))
    call Hcont_QA(nsync, wf2(:,9), wf18(:,8), A(:,51), n3(:,125), t3x36(:,:,51), nhel, den(29))
    call Hcont_QA(nsync, wf6(:,29), wf6(:,30), A(:,52), n3(:,126), t3x36(:,:,52), nhel, den(32))
    call Hcont_QA(nsync, wf2(:,9), wf18(:,10), A(:,53), n3(:,127), t3x36(:,:,53), nhel, den(34))
    call Hcont_QA(nsync, wf6(:,31), wf6(:,32), A(:,54), n3(:,128), t3x36(:,:,54), nhel, den(37))
    call Hcont_QA(nsync, wf2(:,9), wf18(:,12), A(:,55), n3(:,129), t3x36(:,:,55), nhel, den(39))
    call Hcont_QA(nsync, wf6(:,34), wf6(:,35), A(:,56), n3(:,130), t3x36(:,:,56), nhel, den(42))
    call Hcont_QA(nsync, wf2(:,10), wf18(:,13), A(:,57), n3(:,131), t3x36(:,:,57), nhel, den(45))
    call Hcont_QA(nsync, wf6(:,37), wf6(:,38), A(:,58), n3(:,132), t3x36(:,:,58), nhel, den(48))
    call Hcont_QA(nsync, wf2(:,10), wf18(:,14), A(:,59), n3(:,133), t3x36(:,:,59), nhel, den(50))
    call Hcont_QA(nsync, wf2(:,10), wf18(:,16), A(:,60), n3(:,134), t3x36(:,:,60), nhel, den(52))
    call Hcont_QA(nsync, wf6(:,34), wf6(:,40), A(:,61), n3(:,135), t3x36(:,:,61), nhel, den(54))
    call Hcont_QA(nsync, wf6(:,31), wf6(:,41), A(:,62), n3(:,136), t3x36(:,:,62), nhel, den(56))
    call Hcont_QA(nsync, wf6(:,34), wf6(:,43), A(:,63), n3(:,137), t3x36(:,:,63), nhel, den(58))
    call Hcont_QA(nsync, wf6(:,37), wf6(:,45), A(:,64), n3(:,138), t3x36(:,:,64), nhel, den(60))
    call Hcont_QA(nsync, wf6(:,29), wf6(:,46), A(:,65), n3(:,139), t3x36(:,:,65), nhel, den(62))
    call Hcont_QA(nsync, wf6(:,29), wf6(:,48), A(:,66), n3(:,140), t3x36(:,:,66), nhel, den(64))
    call Hcont_QA(nsync, wf6(:,37), wf6(:,50), A(:,67), n3(:,141), t3x36(:,:,67), nhel, den(66))
    call Hcont_QA(nsync, wf6(:,31), wf6(:,52), A(:,68), n3(:,142), t3x36(:,:,68), nhel, den(68))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(1) ! M1helarray(1,nhel)
  integer :: empty(0), i

  M1(1)%j = -(A(j,1)%j*f(1))+(-A(j,7)%j-A(j,10)%j)*f(3)-A(j,4)%j*f(6)+(-A(j,2)%j-A(j,3)%j)*f(8)+(A(j,5)%j+A(j,6)%j+A(j,8)%j &
       +A(j,9)%j+A(j,11)%j+A(j,13)%j)*f(10)+(A(j,12)%j+A(j,14)%j+A(j,15)%j+A(j,16)%j)*f(14)

  M2(1)%j = -(A(j,17)%j*f(2))+(A(j,55)%j+A(j,60)%j)*f(4)+(-A(j,24)%j-A(j,35)%j-A(j,36)%j-A(j,47)%j)*f(5)-A(j,50)%j*f(7)+( &
       -A(j,48)%j-A(j,49)%j)*f(9)+(-A(j,51)%j-A(j,52)%j-A(j,53)%j-A(j,54)%j-A(j,56)%j-A(j,57)%j-A(j,58)%j-A(j,59)%j-A(j,61)%j &
       -A(j,62)%j-A(j,64)%j-A(j,65)%j)*f(11)+(A(j,22)%j+A(j,23)%j+A(j,33)%j+A(j,34)%j+A(j,45)%j+A(j,46)%j)*f(12)+(A(j,18)%j &
       +A(j,19)%j+A(j,20)%j+A(j,21)%j+A(j,25)%j+A(j,26)%j+A(j,28)%j+A(j,31)%j+A(j,37)%j+A(j,38)%j+A(j,40)%j+A(j,43)%j)*f(13)+( &
       -A(j,63)%j-A(j,66)%j-A(j,67)%j-A(j,68)%j)*f(15)+(A(j,27)%j+A(j,29)%j+A(j,30)%j+A(j,32)%j+A(j,39)%j+A(j,41)%j+A(j,42)%j &
       +A(j,44)%j)*f(16)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphvv_bbxhzz_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphvv_bbxhzz_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(1)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 1
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_pphvv_bbxhzz_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphvv_bbxhzz_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu


! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_pphvv_bbxhzz_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(1)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 1 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2


! **********************************************************************
#ifdef PRECISION_dp
subroutine hsfamp2(P_scatt, M02, pind_1, pind_2, M2hsf)
#else
subroutine hsfamp2(P_scatt, M02, pind_1, pind_2, M2hsf)
  use ol_loop_storage_pphvv_bbxhzz_1_/**/DREALKIND, only: &
    & nhflip, helflip, hflip, tsb, pi_flip_bak, pj_flip_bak, nhel
#endif
! M2tree = helicity-summed squared tree matrix element for bottom anti-bottom higgs Z Z -> 0
! M2hsf  = formula (66) of 1011.3918. Tree level
! spin-correlated hard scattering factor for bottom anti-bottom higgs Z Z -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  implicit none
  real(DREALKIND), intent(in) :: P_scatt(0:3,5)
  integer, intent(in) :: pind_1, pind_2
  real(REALKIND), intent(out) :: M02, M2hsf
  real(REALKIND)    :: M2add, M2ct_dummy
  integer :: k

  M2add = 0
  M2hsf = 0

  call amp2(P_scatt, M02, .false., M2ct=M2ct_dummy)
  if((pi_flip_bak .ne. pind_1) .or. (pj_flip_bak .ne. pind_2)) then
    call init_flipped_heltables(pind_1,pind_2)
    pi_flip_bak = pind_1
    pj_flip_bak = pind_2
  end if

  do k = 1, nhflip
    call colintHSF(M1helarray(:,helflip(1,k))%j, M1helarray(:,helflip(2,k))%j, M2add)
    M2hsf = M2hsf + M2add
  end do

  contains

subroutine assign_helicity_flip(ext_wf_hf,ext_wf_t,m)
  use ol_debug, only: ol_fatal
  use KIND_TYPES, only: intkind2
  implicit none
  integer(intkind2), intent(in) :: ext_wf_hf(:), ext_wf_t
  integer, intent(in) :: m
  if(.not. allocated(hflip)) allocate(hflip(size(ext_wf_hf),2))
  if(size(ext_wf_hf) == size(hflip,1)) then
    hflip(:,m) = ext_wf_hf
    tsb = tsb + ext_wf_t
  else
    call ol_fatal("Spin-correlated HSF for pphvv_bbxhzz_1:" &
      & // "trying to flip particles with different number of helicity states")
  end if
end subroutine assign_helicity_flip

subroutine init_flipped_heltables(i,j)
  use KIND_TYPES, only: intkind2
  use ol_external_pphvv_bbxhzz_1, only: &
    & external_perm_inv_pphvv_bbxhzz_1
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helicity_flip_ij
  implicit none
  integer, intent(in) :: i, j
  integer :: r, k, l=0
  tsb = 0

  if(allocated(hflip)) deallocate(hflip)

  do k = 1, 5
    r = external_perm_inv_pphvv_bbxhzz_1(k)
    if(r == i .or. r == j) then
      l = l+1
      select case(k)
        case(1)
          call assign_helicity_flip(ex1(:)%hf,ex1(1)%t,l)
        case(2)
          call assign_helicity_flip(ex2(:)%hf,ex2(1)%t,l)
        case(3)
          call assign_helicity_flip(ex3(:)%hf,ex3(1)%t,l)
        case(4)
          call assign_helicity_flip(ex4(:)%hf,ex4(1)%t,l)
        case(5)
          call assign_helicity_flip(ex5(:)%hf,ex5(1)%t,l)
      end select
    end if
  end do
  call helicity_flip_ij(36,nhel, M1helarray(1,:)%hf, hflip, tsb, &
      & nhflip, helflip)

end subroutine init_flipped_heltables

! **********************************************************************
subroutine colintHSF(M, Mflip, Mhfcolint)
! **********************************************************************
  use ol_colourmatrix_pphvv_bbxhzz_1_/**/REALKIND, only: K1
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mflip(1)
  real(REALKIND),    intent(out) :: Mhfcolint
  integer :: i, j
  MHfcolint = 0
  do i = 1, 1
    do j = 1, 1
      Mhfcolint = Mhfcolint + real(conjg(Mflip(i))*K1(i,j)*M(j))
    end do
  end do

end subroutine colintHSF

end subroutine hsfamp2

end module ol_loop_pphvv_bbxhzz_1_/**/REALKIND
