
module ol_vamp_3_pphttj_ttxddxhg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_3(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphttj_ttxddxhg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphttj_ttxddxhg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pphttj_ttxddxhg_1_/**/DREALKIND
  use ol_tensor_sum_storage_pphttj_ttxddxhg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pphttj_ttxddxhg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pphttj_ttxddxhg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(32)
  type(Hpolcont), intent(in) :: M(4,32)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================
  call Hotf_4pt_reduction_last(G1tensor(631),RedSet_4(163),mass4set(:,6),  & 
G0tensor(637),G0tensor(638),G0tensor(639),G0tensor(640),G0tensor(641))
  call Hotf_4pt_reduction_last(G1tensor(636),RedSet_4(164),mass4set(:,6),  & 
G0tensor(642),G0tensor(643),G0tensor(644),G0tensor(645),G0tensor(646))
  call Hotf_4pt_reduction_last(G1tensor(641),RedSet_4(130),mass4set(:,6),  & 
G0tensor(647),G0tensor(648),G0tensor(649),G0tensor(650),G0tensor(651))
  call Hotf_4pt_reduction_last(G1tensor(646),RedSet_4(166),mass4set(:,6),  & 
G0tensor(652),G0tensor(653),G0tensor(654),G0tensor(655),G0tensor(656))
  call Hotf_4pt_reduction_last(G1tensor(651),RedSet_4(167),mass4set(:,6),  & 
G0tensor(657),G0tensor(658),G0tensor(659),G0tensor(660),G0tensor(661))
  call Hotf_4pt_reduction_last(G1tensor(656),RedSet_4(168),mass4set(:,6),  & 
G0tensor(662),G0tensor(663),G0tensor(664),G0tensor(665),G0tensor(666))
  call Hotf_4pt_reduction_last(G1tensor(661),RedSet_4(175),mass4set(:,11),  & 
G0tensor(667),G0tensor(668),G0tensor(669),G0tensor(670),G0tensor(671))
  call Hotf_4pt_reduction_last(G1tensor(666),RedSet_4(169),mass4set(:,7),  & 
G0tensor(672),G0tensor(673),G0tensor(674),G0tensor(675),G0tensor(676))
  call Hotf_4pt_reduction_last(G1tensor(671),RedSet_4(170),mass4set(:,1),  & 
G0tensor(677),G0tensor(678),G0tensor(679),G0tensor(680),G0tensor(681))
  call Hotf_4pt_reduction_last(G1tensor(676),RedSet_4(126),mass4set(:,1),  & 
G0tensor(682),G0tensor(683),G0tensor(684),G0tensor(685),G0tensor(686))
  call Hotf_4pt_reduction_last(G1tensor(681),RedSet_4(188),mass4set(:,11),  & 
G0tensor(687),G0tensor(688),G0tensor(689),G0tensor(690),G0tensor(691))
  call Hotf_4pt_reduction_last(G1tensor(686),RedSet_4(172),mass4set(:,7),  & 
G0tensor(692),G0tensor(693),G0tensor(694),G0tensor(695),G0tensor(696))
  call Hotf_4pt_reduction_last(G1tensor(691),RedSet_4(173),mass4set(:,1),  & 
G0tensor(697),G0tensor(698),G0tensor(699),G0tensor(700),G0tensor(701))
  call Hotf_4pt_reduction_last(G1tensor(696),RedSet_4(176),mass4set(:,5),  & 
G0tensor(702),G0tensor(703),G0tensor(704),G0tensor(705),G0tensor(706))
  call Hotf_4pt_reduction_last(G1tensor(701),RedSet_4(11),mass4set(:,3),  & 
G0tensor(707),G0tensor(708),G0tensor(709),G0tensor(710),G0tensor(711))
  call Hotf_4pt_reduction_last(G1tensor(706),RedSet_4(179),mass4set(:,5),  & 
G0tensor(712),G0tensor(713),G0tensor(714),G0tensor(715),G0tensor(716))
  call Hotf_4pt_reduction_last(G1tensor(711),RedSet_4(181),mass4set(:,11),  & 
G0tensor(717),G0tensor(718),G0tensor(719),G0tensor(720),G0tensor(721))
  call Hotf_4pt_reduction_last(G1tensor(716),RedSet_4(35),mass4set(:,3),  & 
G0tensor(722),G0tensor(723),G0tensor(724),G0tensor(725),G0tensor(726))
  call Hotf_4pt_reduction_last(G1tensor(721),RedSet_4(183),mass4set(:,11),  & 
G0tensor(727),G0tensor(728),G0tensor(729),G0tensor(730),G0tensor(731))
  call Hotf_4pt_reduction_last(G1tensor(726),RedSet_4(184),mass4set(:,5),  & 
G0tensor(732),G0tensor(733),G0tensor(734),G0tensor(735),G0tensor(736))
  call Hotf_4pt_reduction_last(G1tensor(731),RedSet_4(86),mass4set(:,1),  & 
G0tensor(737),G0tensor(738),G0tensor(739),G0tensor(740),G0tensor(741))
  call Hotf_4pt_reduction_last(G1tensor(760),RedSet_4(179),mass4set(:,8),  & 
G0tensor(742),G0tensor(743),G0tensor(744),G0tensor(745),G0tensor(746))
  call Hotf_4pt_reduction_last(G1tensor(765),RedSet_4(184),mass4set(:,8),  & 
G0tensor(747),G0tensor(748),G0tensor(749),G0tensor(750),G0tensor(751))
  call Hotf_4pt_reduction_last(G1tensor(770),RedSet_4(176),mass4set(:,8),  & 
G0tensor(752),G0tensor(753),G0tensor(754),G0tensor(755),G0tensor(756))
  call ol_merge_tensors(T0sum(1),[G0tensor(7)])
  call ol_merge_tensors(T0sum(2),[G0tensor(12)])
  call ol_merge_tensors(T0sum(3),[G0tensor(17)])
  call ol_merge_tensors(T0sum(4),[G0tensor(22)])
  call ol_merge_tensors(T0sum(5),[G0tensor(27)])
  call ol_merge_tensors(T0sum(6),[G0tensor(32)])
  call ol_merge_tensors(T0sum(7),[G0tensor(37)])
  call ol_merge_tensors(T0sum(8),[G0tensor(42)])
  call ol_merge_tensors(T0sum(9),[G0tensor(47)])
  call ol_merge_tensors(T0sum(10),[G0tensor(52)])
  call ol_merge_tensors(T0sum(11),[G0tensor(57)])
  call ol_merge_tensors(T0sum(12),[G0tensor(62)])
  call ol_merge_tensors(T0sum(13),[G0tensor(67)])
  call ol_merge_tensors(T0sum(14),[G0tensor(72)])
  call ol_merge_tensors(T0sum(15),[G0tensor(77)])
  call ol_merge_tensors(T0sum(16),[G0tensor(82)])
  call ol_merge_tensors(T0sum(17),[G0tensor(87)])
  call ol_merge_tensors(T0sum(18),[G0tensor(92)])
  call ol_merge_tensors(T0sum(19),[G0tensor(97)])
  call ol_merge_tensors(T0sum(20),[G0tensor(102)])
  call ol_merge_tensors(T0sum(21),[G0tensor(107)])
  call ol_merge_tensors(T0sum(22),[G0tensor(112)])
  call ol_merge_tensors(T0sum(23),[G0tensor(117)])
  call ol_merge_tensors(T0sum(24),[G0tensor(122)])
  call ol_merge_tensors(T0sum(25),[G0tensor(127)])
  call ol_merge_tensors(T0sum(26),[G0tensor(132)])
  call ol_merge_tensors(T0sum(27),[G0tensor(137)])
  call ol_merge_tensors(T0sum(28),[G0tensor(142)])
  call ol_merge_tensors(T0sum(29),[G0tensor(147)])
  call ol_merge_tensors(T0sum(30),[G0tensor(152)])
  call ol_merge_tensors(T0sum(31),[G0tensor(157)])
  call ol_merge_tensors(T0sum(32),[G0tensor(162)])
  call ol_merge_tensors(T0sum(33),[G0tensor(167)])
  call ol_merge_tensors(T0sum(34),[G0tensor(172)])
  call ol_merge_tensors(T0sum(35),[G0tensor(177)])
  call ol_merge_tensors(T0sum(36),[G0tensor(182)])
  call ol_merge_tensors(T0sum(37),[G0tensor(187)])
  call ol_merge_tensors(T0sum(38),[G0tensor(192)])
  call ol_merge_tensors(T0sum(39),[G0tensor(197)])
  call ol_merge_tensors(T0sum(40),[G0tensor(202)])
  call ol_merge_tensors(T0sum(41),[G0tensor(207)])
  call ol_merge_tensors(T0sum(42),[G0tensor(212)])
  call ol_merge_tensors(T0sum(43),[G0tensor(217)])
  call ol_merge_tensors(T0sum(44),[G0tensor(222)])
  call ol_merge_tensors(T0sum(45),[G0tensor(227)])
  call ol_merge_tensors(T0sum(46),[G0tensor(232)])
  call ol_merge_tensors(T0sum(47),[G0tensor(237)])
  call ol_merge_tensors(T0sum(48),[G0tensor(242)])
  call ol_merge_tensors(T0sum(49),[G0tensor(247)])
  call ol_merge_tensors(T0sum(50),[G0tensor(252)])
  call ol_merge_tensors(T0sum(51),[G0tensor(257)])
  call ol_merge_tensors(T0sum(52),[G0tensor(262)])
  call ol_merge_tensors(T0sum(53),[G0tensor(267)])
  call ol_merge_tensors(T0sum(54),[G0tensor(272)])
  call ol_merge_tensors(T0sum(55),[G0tensor(277)])
  call ol_merge_tensors(T0sum(56),[G0tensor(282)])
  call ol_merge_tensors(T0sum(57),[G0tensor(287)])
  call ol_merge_tensors(T0sum(58),[G0tensor(292)])
  call ol_merge_tensors(T0sum(59),[G0tensor(297)])
  call ol_merge_tensors(T0sum(60),[G0tensor(302)])
  call ol_merge_tensors(T0sum(61),[G0tensor(307)])
  call ol_merge_tensors(T0sum(62),[G0tensor(312)])
  call ol_merge_tensors(T0sum(63),[G0tensor(317)])
  call ol_merge_tensors(T0sum(64),[G0tensor(322)])
  call ol_merge_tensors(T0sum(65),[G0tensor(327)])
  call ol_merge_tensors(T0sum(66),[G0tensor(332)])
  call ol_merge_tensors(T0sum(67),[G0tensor(337)])
  call ol_merge_tensors(T0sum(68),[G0tensor(342)])
  call ol_merge_tensors(T0sum(69),[G0tensor(347)])
  call ol_merge_tensors(T0sum(70),[G0tensor(352)])
  call ol_merge_tensors(T0sum(71),[G0tensor(357)])
  call ol_merge_tensors(T0sum(72),[G0tensor(362)])
  call ol_merge_tensors(T0sum(73),[G0tensor(367)])
  call ol_merge_tensors(T0sum(74),[G0tensor(372)])
  call ol_merge_tensors(T0sum(75),[G0tensor(377)])
  call ol_merge_tensors(T0sum(76),[G0tensor(382)])
  call ol_merge_tensors(T0sum(77),[G0tensor(387)])
  call ol_merge_tensors(T0sum(78),[G0tensor(392)])
  call ol_merge_tensors(T0sum(79),[G0tensor(397)])
  call ol_merge_tensors(T0sum(80),[G0tensor(402)])
  call ol_merge_tensors(T0sum(81),[G0tensor(407)])
  call ol_merge_tensors(T0sum(82),[G0tensor(412)])
  call ol_merge_tensors(T0sum(83),[G0tensor(417)])
  call ol_merge_tensors(T0sum(84),[G0tensor(422)])
  call ol_merge_tensors(T0sum(85),[G0tensor(427)])
  call ol_merge_tensors(T0sum(86),[G0tensor(432)])
  call ol_merge_tensors(T0sum(87),[G0tensor(437)])
  call ol_merge_tensors(T0sum(88),[G0tensor(442)])
  call ol_merge_tensors(T0sum(89),[G0tensor(447)])
  call ol_merge_tensors(T0sum(90),[G0tensor(452)])
  call ol_merge_tensors(T0sum(91),[G0tensor(457)])
  call ol_merge_tensors(T0sum(92),[G0tensor(462)])
  call ol_merge_tensors(T0sum(93),[G0tensor(467)])
  call ol_merge_tensors(T0sum(94),[G0tensor(472)])
  call ol_merge_tensors(T0sum(95),[G0tensor(477)])
  call ol_merge_tensors(T0sum(96),[G0tensor(482)])
  call ol_merge_tensors(T0sum(97),[G0tensor(487)])
  call ol_merge_tensors(T0sum(98),[G0tensor(492)])
  call ol_merge_tensors(T0sum(99),[G0tensor(497)])
  call ol_merge_tensors(T0sum(100),[G0tensor(502)])
  call ol_merge_tensors(T0sum(101),[G0tensor(507)])
  call ol_merge_tensors(T0sum(102),[G0tensor(512)])
  call ol_merge_tensors(T0sum(103),[G0tensor(517)])
  call ol_merge_tensors(T0sum(104),[G0tensor(522)])
  call ol_merge_tensors(T0sum(105),[G0tensor(527)])
  call ol_merge_tensors(T0sum(106),[G0tensor(532)])
  call ol_merge_tensors(T0sum(107),[G0tensor(537)])
  call ol_merge_tensors(T0sum(108),[G0tensor(542)])
  call ol_merge_tensors(T0sum(109),[G0tensor(547)])
  call ol_merge_tensors(T0sum(110),[G0tensor(552)])
  call ol_merge_tensors(T0sum(111),[G0tensor(557)])
  call ol_merge_tensors(T0sum(112),[G0tensor(562)])
  call ol_merge_tensors(T0sum(113),[G0tensor(567)])
  call ol_merge_tensors(T0sum(114),[G0tensor(572)])
  call ol_merge_tensors(T0sum(115),[G0tensor(577)])
  call ol_merge_tensors(T0sum(116),[G0tensor(582)])
  call ol_merge_tensors(T0sum(117),[G0tensor(587)])
  call ol_merge_tensors(T0sum(118),[G0tensor(592)])
  call ol_merge_tensors(T0sum(119),[G0tensor(597)])
  call ol_merge_tensors(T0sum(120),[G0tensor(602)])
  call ol_merge_tensors(T0sum(121),[G0tensor(607)])
  call ol_merge_tensors(T0sum(122),[G0tensor(612)])
  call ol_merge_tensors(T0sum(123),[G0tensor(617)])
  call ol_merge_tensors(T0sum(124),[G0tensor(622)])
  call ol_merge_tensors(T0sum(125),[G0tensor(627)])
  call ol_merge_tensors(T0sum(126),[G0tensor(632)])
  call ol_merge_tensors(T0sum(127),[G0tensor(637)])
  call ol_merge_tensors(T0sum(128),[G0tensor(642)])
  call ol_merge_tensors(T0sum(129),[G0tensor(647)])
  call ol_merge_tensors(T0sum(130),[G0tensor(652)])
  call ol_merge_tensors(T0sum(131),[G0tensor(657)])
  call ol_merge_tensors(T0sum(132),[G0tensor(662)])
  call ol_merge_tensors(T0sum(133),[G0tensor(667)])
  call ol_merge_tensors(T0sum(134),[G0tensor(672)])
  call ol_merge_tensors(T0sum(135),[G0tensor(677)])
  call ol_merge_tensors(T0sum(136),[G0tensor(682)])
  call ol_merge_tensors(T0sum(137),[G0tensor(687)])
  call ol_merge_tensors(T0sum(138),[G0tensor(692)])
  call ol_merge_tensors(T0sum(139),[G0tensor(697)])
  call ol_merge_tensors(T0sum(140),[G0tensor(702)])
  call ol_merge_tensors(T0sum(141),[G0tensor(707)])
  call ol_merge_tensors(T0sum(142),[G0tensor(712)])
  call ol_merge_tensors(T0sum(143),[G0tensor(717)])
  call ol_merge_tensors(T0sum(144),[G0tensor(722)])
  call ol_merge_tensors(T0sum(145),[G0tensor(727)])
  call ol_merge_tensors(T0sum(146),[G0tensor(732)])
  call ol_merge_tensors(T0sum(147),[G0tensor(1)])
  call ol_merge_tensors(T0sum(148),[G0tensor(2)])
  call ol_merge_tensors(T0sum(149),[G0tensor(3)])
  call ol_merge_tensors(T0sum(150),[G0tensor(4)])
  call ol_merge_tensors(T0sum(151),[G0tensor(5)])
  call ol_merge_tensors(T0sum(152),[G0tensor(6)])
  call ol_merge_tensors(T0sum(153),[G0tensor(737)])
  call ol_merge_tensors(T0sum(154),[G0tensor(742)])
  call ol_merge_tensors(T0sum(155),[G0tensor(747)])
  call ol_merge_tensors(T0sum(156),[G0tensor(752)])
  Gcoeff(:)%j = (c(22)*M(3,:)%j+c(17)*(-M(1,:)%j+M(4,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(127),h0tab(:,127),[44,2,17],[0,nMT,0],4,2,wf4(:,2),wf2(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex6(:),wf4(:,2),G0H4(4),m4h2x4x4(:,3),heltab3x32(:,:,4))
  Gcoeff(:)%j = (c(22)*M(2,:)%j+c(17)*(-M(1,:)%j+M(4,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(128),h0tab(:,128),[44,2,17],[0,nMT,0],4,2,wf4(:,2),wf2(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,2),ex6(:),G0H4(2),m4h4x2x4(:,2),heltab3x32(:,:,5))
  Gcoeff(:)%j = (c(22)*(M(2,:)%j-M(3,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(129),h0tab(:,129),[44,2,17],[0,nMT,0],4,2,wf4(:,2),wf2(:,2))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex6(:),wf4(:,2),G0H4(1),m4h2x4x4(:,4),heltab3x32(:,:,6))
  Gcoeff(:)%j = (c(22)*M(2,:)%j+c(17)*(-M(1,:)%j+M(4,:)%j)) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(130),h0tab(:,130),[44,1,18],[0,nMT,0],4,2,wf4(:,2),wf2(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex6(:),wf4(:,2),G0H4(5),m4h2x4x4(:,5),heltab3x32(:,:,7))
  Gcoeff(:)%j = (c(22)*M(3,:)%j+c(17)*(-M(1,:)%j+M(4,:)%j)) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(131),h0tab(:,131),[44,1,18],[0,nMT,0],4,2,wf4(:,2),wf2(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,2),ex6(:),G0H4(6),m4h4x2x4(:,3),heltab3x32(:,:,8))
  Gcoeff(:)%j = (c(22)*(-M(2,:)%j+M(3,:)%j)) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(132),h0tab(:,132),[44,1,18],[0,nMT,0],4,2,wf4(:,2),wf2(:,4))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex6(:),wf4(:,2),G0H4(7),m4h2x4x4(:,6),heltab3x32(:,:,9))
  Gcoeff(:)%j = (c(22)*M(3,:)%j+c(17)*(M(1,:)%j-M(4,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(133),h0tab(:,133),[51,4,8],[0,0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex6(:),wf4(:,4),G0H4(8),m4h2x4x4(:,7),heltab3x32(:,:,10))
  Gcoeff(:)%j = (c(22)*M(2,:)%j+c(17)*(M(1,:)%j-M(4,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(134),h0tab(:,134),[51,4,8],[0,0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,4),ex6(:),G0H4(9),m4h4x2x4(:,4),heltab3x32(:,:,11))
  Gcoeff(:)%j = (c(22)*(M(2,:)%j-M(3,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(135),h0tab(:,135),[51,4,8],[0,0,0],4,1,wf4(:,4))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex6(:),wf4(:,4),G0H4(10),m4h2x4x4(:,8),heltab3x32(:,:,12))
  Gcoeff(:)%j = (c(22)*M(3,:)%j+c(17)*(M(1,:)%j-M(4,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(136),h0tab(:,136),[51,4,8],[0,0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex6(:),wf4(:,8),G0H4(11),m4h2x4x4(:,9),heltab3x32(:,:,13))
  Gcoeff(:)%j = (c(22)*M(2,:)%j+c(17)*(M(1,:)%j-M(4,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(137),h0tab(:,137),[51,4,8],[0,0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,8),ex6(:),G0H4(13),m4h4x2x4(:,5),heltab3x32(:,:,14))
  Gcoeff(:)%j = (c(22)*(M(2,:)%j-M(3,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(138),h0tab(:,138),[51,4,8],[0,0,0],4,1,wf4(:,8))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex6(:),wf4(:,8),G0H4(12),m4h2x4x4(:,10),heltab3x32(:,:,15))
  Gcoeff(:)%j = (c(24)*(M(2,:)%j-M(3,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(139),h0tab(:,139),[35,12,16],[nMT,nMT,nMT],3,2,wf8(:,10),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,10),G0H4(3),m3h8x4(:,10),heltab2x32(:,:,124))
  call Hloop_Q_A(ntryL,G0H4(3),35,nMT,G1H4(36),n2h4(147))
  Gcoeff(:)%j = (c(24)*(M(2,:)%j-M(3,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(140),h0tab(:,140),[35,12,16],[nMT,nMT,nMT],3,2,wf8(:,10),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,10),G0H4(3),m3h8x4(:,11),heltab2x32(:,:,125))
  call Hloop_A_Q(ntryL,G0H4(3),35,nMT,G1H4(20),n2h4(148))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(3,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(141),h0tab(:,141),[35,12,16],[nMB,nMB,nMB],3,2,wf8(:,10),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,10),G0H4(3),m3h8x4(:,12),heltab2x32(:,:,126))
  call Hloop_Q_A(ntryL,G0H4(3),35,nMB,G1H4(60),n2h4(149))
  Gcoeff(:)%j = (c(1)*(M(2,:)%j-M(3,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(142),h0tab(:,142),[35,12,16],[nMB,nMB,nMB],3,2,wf8(:,10),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,10),G0H4(3),m3h8x4(:,13),heltab2x32(:,:,127))
  call Hloop_A_Q(ntryL,G0H4(3),35,nMB,G1H4(25),n2h4(150))
  Gcoeff(:)%j = (c(24)*(-M(2,:)%j+M(3,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(143),h0tab(:,143),[44,3,16],[nMT,nMT,nMT],3,2,wf8(:,2),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,2),G0H4(3),m3h8x4(:,14),heltab2x32(:,:,128))
  call Hloop_Q_A(ntryL,G0H4(3),44,nMT,G1H4(59),n2h4(151))
  Gcoeff(:)%j = (c(24)*(-M(2,:)%j+M(3,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(144),h0tab(:,144),[44,3,16],[nMT,nMT,nMT],3,2,wf8(:,2),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,2),G0H4(3),m3h8x4(:,15),heltab2x32(:,:,129))
  call Hloop_A_Q(ntryL,G0H4(3),44,nMT,G1H4(64),n2h4(152))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(145),h0tab(:,145),[44,3,16],[nMB,nMB,nMB],3,2,wf8(:,2),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,2),G0H4(3),m3h8x4(:,16),heltab2x32(:,:,130))
  call Hloop_Q_A(ntryL,G0H4(3),44,nMB,G1H4(24),n2h4(153))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(35)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(146),h0tab(:,146),[44,3,16],[nMB,nMB,nMB],3,2,wf8(:,2),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,2),G0H4(3),m3h8x4(:,17),heltab2x32(:,:,131))
  call Hloop_A_Q(ntryL,G0H4(3),44,nMB,G1H4(71),n2h4(154))
  Gcoeff(:)%j = (c(24)*(-M(2,:)%j+M(3,:)%j)) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(147),h0tab(:,147),[32,15,16],[nMT,nMT,nMT],3,1,wf16(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,81),heltab2x32(:,:,132))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(1),n2h16(51))
  Gcoeff(:)%j = (c(24)*(-M(2,:)%j+M(3,:)%j)) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(148),h0tab(:,148),[32,15,16],[nMT,nMT,nMT],3,1,wf16(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,82),heltab2x32(:,:,133))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(2),n2h16(52))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(149),h0tab(:,149),[32,15,16],[nMB,nMB,nMB],3,1,wf16(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,83),heltab2x32(:,:,134))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(3),n2h16(53))
  Gcoeff(:)%j = (c(1)*(-M(2,:)%j+M(3,:)%j)) * den(131)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(150),h0tab(:,150),[32,15,16],[nMB,nMB,nMB],3,1,wf16(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,84),heltab2x32(:,:,135))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(4),n2h16(54))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*M(4,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(151),h0tab(:,151),[44,3,16],[nMT,nMT,nMT],3,2,wf8(:,8),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,8),G0H4(3),m3h8x4(:,18),heltab2x32(:,:,136))
  call Hloop_Q_A(ntryL,G0H4(3),44,nMT,G1H4(70),n2h4(155))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*M(4,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(152),h0tab(:,152),[44,3,16],[nMT,nMT,nMT],3,2,wf8(:,8),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,8),G0H4(3),m3h8x4(:,19),heltab2x32(:,:,137))
  call Hloop_A_Q(ntryL,G0H4(3),44,nMT,G1H4(110),n2h4(156))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)+c(2)*M(4,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(153),h0tab(:,153),[44,3,16],[nMB,nMB,nMB],3,2,wf8(:,8),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,8),G0H4(3),m3h8x4(:,20),heltab2x32(:,:,138))
  call Hloop_Q_A(ntryL,G0H4(3),44,nMB,G1H4(81),n2h4(157))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)+c(2)*M(4,:)%j) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(154),h0tab(:,154),[44,3,16],[nMB,nMB,nMB],3,2,wf8(:,8),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,8),G0H4(3),m3h8x4(:,21),heltab2x32(:,:,139))
  call Hloop_A_Q(ntryL,G0H4(3),44,nMB,G1H4(121),n2h4(158))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)+c(26)*M(4,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(155),h0tab(:,155),[44,3,16],[nMT,nMT,nMT],3,2,wf8(:,9),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,9),G0H4(3),m3h8x4(:,22),heltab2x32(:,:,140))
  call Hloop_Q_A(ntryL,G0H4(3),44,nMT,G1H4(2),n2h4(159))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)+c(26)*M(4,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(156),h0tab(:,156),[44,3,16],[nMT,nMT,nMT],3,2,wf8(:,9),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,9),G0H4(3),m3h8x4(:,23),heltab2x32(:,:,141))
  call Hloop_A_Q(ntryL,G0H4(3),44,nMT,G1H4(28),n2h4(160))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)+c(2)*M(4,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(157),h0tab(:,157),[44,3,16],[nMB,nMB,nMB],3,2,wf8(:,9),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,9),G0H4(3),m3h8x4(:,24),heltab2x32(:,:,142))
  call Hloop_Q_A(ntryL,G0H4(3),44,nMB,G1H4(87),n2h4(161))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)+c(2)*M(4,:)%j) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(158),h0tab(:,158),[44,3,16],[nMB,nMB,nMB],3,2,wf8(:,9),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,9),G0H4(3),m3h8x4(:,25),heltab2x32(:,:,143))
  call Hloop_A_Q(ntryL,G0H4(3),44,nMB,G1H4(93),n2h4(162))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)+c(26)*M(4,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(159),h0tab(:,159),[32,15,16],[nMT,nMT,nMT],3,1,wf16(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,85),heltab2x32(:,:,144))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(5),n2h16(55))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)+c(26)*M(4,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(160),h0tab(:,160),[32,15,16],[nMT,nMT,nMT],3,1,wf16(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,86),heltab2x32(:,:,145))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(6),n2h16(56))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)+c(2)*M(4,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(161),h0tab(:,161),[32,15,16],[nMB,nMB,nMB],3,1,wf16(:,6))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,87),heltab2x32(:,:,146))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(7),n2h16(57))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)+c(2)*M(4,:)%j) * den(132)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(162),h0tab(:,162),[32,15,16],[nMB,nMB,nMB],3,1,wf16(:,6))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,88),heltab2x32(:,:,147))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(8),n2h16(58))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*M(4,:)%j) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(163),h0tab(:,163),[32,15,16],[nMT,nMT,nMT],3,1,wf16(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,89),heltab2x32(:,:,148))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(9),n2h16(59))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*M(4,:)%j) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(164),h0tab(:,164),[32,15,16],[nMT,nMT,nMT],3,1,wf16(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,90),heltab2x32(:,:,149))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(10),n2h16(60))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)+c(2)*M(4,:)%j) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(165),h0tab(:,165),[32,15,16],[nMB,nMB,nMB],3,1,wf16(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,91),heltab2x32(:,:,150))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(11),n2h16(61))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)+c(2)*M(4,:)%j) * den(135)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(166),h0tab(:,166),[32,15,16],[nMB,nMB,nMB],3,1,wf16(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,92),heltab2x32(:,:,151))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(12),n2h16(62))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(2,:)%j) * den(160)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(167),h0tab(:,167),[34,12,17],[nMT,nMT,0],3,3,wf4(:,3),wf4(:,2),wf2(:,2))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(15),m3h4x8(:,35),heltab2x32(:,:,152))
  call Hloop_A_Q(ntryL,G0H8(15),34,nMT,G1H8(27),n2h8(101))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j) * den(160)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(168),h0tab(:,168),[34,12,17],[0,0,nMT],3,3,wf4(:,3),wf4(:,2),wf2(:,2))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,3),G0H8(1),m3h4x8(:,36),heltab2x32(:,:,153))
  Gcoeff(:)%j = (-(c(29)*M(3,:)%j)+c(28)*(M(1,:)%j+M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(169),h0tab(:,169),[32,12,19],[0,0,0],3,2,wf4(:,2),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,93),heltab2x32(:,:,154))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(13),n2h16(63))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)+c(26)*(M(1,:)%j+M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(170),h0tab(:,170),[32,12,19],[nMT,nMT,nMT],3,2,wf4(:,2),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,94),heltab2x32(:,:,155))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(14),n2h16(64))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)+c(28)*(M(1,:)%j+M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(171),h0tab(:,171),[32,12,19],[0,0,0],3,2,wf4(:,2),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,95),heltab2x32(:,:,156))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(15),n2h16(65))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*(M(1,:)%j+M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(172),h0tab(:,172),[32,12,19],[nMT,nMT,nMT],3,2,wf4(:,2),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,96),heltab2x32(:,:,157))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(16),n2h16(66))
  Gcoeff(:)%j = (-(c(29)*M(3,:)%j)+c(28)*(M(1,:)%j+M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(173),h0tab(:,173),[32,12,19],[0,0,0],3,2,wf4(:,2),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,97),heltab2x32(:,:,158))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(17),n2h16(67))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)+c(26)*(M(1,:)%j+M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(174),h0tab(:,174),[32,12,19],[nMB,nMB,nMB],3,2,wf4(:,2),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,98),heltab2x32(:,:,159))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(18),n2h16(68))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)+c(28)*(M(1,:)%j+M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(175),h0tab(:,175),[32,12,19],[0,0,0],3,2,wf4(:,2),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,99),heltab2x32(:,:,160))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(19),n2h16(69))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*(M(1,:)%j+M(4,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(176),h0tab(:,176),[32,12,19],[nMB,nMB,nMB],3,2,wf4(:,2),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,100),heltab2x32(:,:,161))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(20),n2h16(70))
  Gcoeff(:)%j = (c(9)*(-M(2,:)%j+M(3,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(177),h0tab(:,177),[32,12,19],[0,0,0],3,2,wf4(:,2),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex6(:),32,G1H16(21),m3h2x16(:,101),heltab2x32(:,:,162))
  Gcoeff(:)%j = (c(9)*(M(2,:)%j-M(3,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(178),h0tab(:,178),[32,12,19],[0,0,0],3,2,wf4(:,2),wf4(:,4))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex6(:),G1H16(22),m3h2x16(:,102),heltab2x32(:,:,163))
  Gcoeff(:)%j = (c(9)*(-M(2,:)%j+M(3,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(179),h0tab(:,179),[32,12,19],[0,0,0],3,2,wf4(:,2),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(23),m3h2x16(:,103),heltab2x32(:,:,164))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(3,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(180),h0tab(:,180),[49,2,12],[0,nMT,nMT],3,2,wf4(:,34),wf4(:,2))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,34),G0H8(2),m3h4x8(:,37),heltab2x32(:,:,165))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(3,:)%j) * den(58)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(181),h0tab(:,181),[49,2,12],[nMT,0,0],3,2,wf4(:,34),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,34),G0H8(3),m3h4x8(:,38),heltab2x32(:,:,166))
  call Hloop_Q_A(ntryL,G0H8(3),49,nMT,G1H8(4),n2h8(102))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(3,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(182),h0tab(:,182),[32,14,17],[nMT,0,nMT],3,2,wf8(:,4),wf2(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,104),heltab2x32(:,:,167))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(24),n2h16(71))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)+c(9)*M(3,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(183),h0tab(:,183),[32,14,17],[0,nMT,0],3,2,wf8(:,4),wf2(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(25),m3h2x16(:,105),heltab2x32(:,:,168))
  Gcoeff(:)%j = (c(6)*(-M(2,:)%j+M(3,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(184),h0tab(:,184),[44,2,17],[nMT,0,nMT],3,2,wf8(:,2),wf2(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,2),G0H4(3),m3h8x4(:,26),heltab2x32(:,:,169))
  call Hloop_Q_A(ntryL,G0H4(3),44,nMT,G1H4(94),n2h4(163))
  Gcoeff(:)%j = (c(22)*(M(2,:)%j-M(3,:)%j)) * den(59)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(185),h0tab(:,185),[44,2,17],[0,nMT,0],3,2,wf8(:,2),wf2(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,2),44,G1H4(97),m3h8x4(:,27),heltab2x32(:,:,170))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(186),h0tab(:,186),[32,2,29],[nMT,0,nMT],3,1,wf8(:,35))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,106),heltab2x32(:,:,171))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(26),n2h16(72))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)+c(9)*M(2,:)%j) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(187),h0tab(:,187),[32,2,29],[0,nMT,0],3,1,wf8(:,35))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(27),m3h2x16(:,107),heltab2x32(:,:,172))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(3,:)%j) * den(161)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(188),h0tab(:,188),[33,12,18],[nMT,nMT,0],3,3,wf4(:,7),wf4(:,2),wf2(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,7),G0H8(4),m3h4x8(:,39),heltab2x32(:,:,173))
  call Hloop_Q_A(ntryL,G0H8(4),33,nMT,G1H8(20),n2h8(103))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)+c(9)*M(3,:)%j) * den(161)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(189),h0tab(:,189),[33,12,18],[0,0,nMT],3,3,wf4(:,7),wf4(:,2),wf2(:,4))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,7),G0H8(5),m3h4x8(:,40),heltab2x32(:,:,174))
  Gcoeff(:)%j = (-(c(29)*M(3,:)%j)+c(28)*(M(1,:)%j+M(4,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(190),h0tab(:,190),[32,12,19],[0,0,0],3,2,wf4(:,2),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,108),heltab2x32(:,:,175))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(28),n2h16(73))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)+c(26)*(M(1,:)%j+M(4,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(191),h0tab(:,191),[32,12,19],[nMT,nMT,nMT],3,2,wf4(:,2),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,109),heltab2x32(:,:,176))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(29),n2h16(74))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)+c(28)*(M(1,:)%j+M(4,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(192),h0tab(:,192),[32,12,19],[0,0,0],3,2,wf4(:,2),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,110),heltab2x32(:,:,177))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(30),n2h16(75))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*(M(1,:)%j+M(4,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(193),h0tab(:,193),[32,12,19],[nMT,nMT,nMT],3,2,wf4(:,2),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,111),heltab2x32(:,:,178))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(31),n2h16(76))
  Gcoeff(:)%j = (-(c(29)*M(3,:)%j)+c(28)*(M(1,:)%j+M(4,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(194),h0tab(:,194),[32,12,19],[0,0,0],3,2,wf4(:,2),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,112),heltab2x32(:,:,179))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(32),n2h16(77))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)+c(26)*(M(1,:)%j+M(4,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(195),h0tab(:,195),[32,12,19],[nMB,nMB,nMB],3,2,wf4(:,2),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,113),heltab2x32(:,:,180))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(33),n2h16(78))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)+c(28)*(M(1,:)%j+M(4,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(196),h0tab(:,196),[32,12,19],[0,0,0],3,2,wf4(:,2),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,114),heltab2x32(:,:,181))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(34),n2h16(79))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*(M(1,:)%j+M(4,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(197),h0tab(:,197),[32,12,19],[nMB,nMB,nMB],3,2,wf4(:,2),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,115),heltab2x32(:,:,182))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(35),n2h16(80))
  Gcoeff(:)%j = (c(9)*(-M(2,:)%j+M(3,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(198),h0tab(:,198),[32,12,19],[0,0,0],3,2,wf4(:,2),wf4(:,8))
  call Hloop_CV_D(ntryL,G0H32(1),0,ex6(:),32,G1H16(36),m3h2x16(:,116),heltab2x32(:,:,183))
  Gcoeff(:)%j = (c(9)*(M(2,:)%j-M(3,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(199),h0tab(:,199),[32,12,19],[0,0,0],3,2,wf4(:,2),wf4(:,8))
  call Hloop_DV_C(ntryL,G0H32(1),0,ex6(:),G1H16(37),m3h2x16(:,117),heltab2x32(:,:,184))
  Gcoeff(:)%j = (c(9)*(-M(2,:)%j+M(3,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(200),h0tab(:,200),[32,12,19],[0,0,0],3,2,wf4(:,2),wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(38),m3h2x16(:,118),heltab2x32(:,:,185))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(201),h0tab(:,201),[32,13,18],[nMT,0,nMT],3,2,wf8(:,7),wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,119),heltab2x32(:,:,186))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(39),n2h16(81))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(202),h0tab(:,202),[32,13,18],[0,nMT,0],3,2,wf8(:,7),wf2(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(40),m3h2x16(:,120),heltab2x32(:,:,187))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(2,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(203),h0tab(:,203),[50,1,12],[0,nMT,nMT],3,2,wf4(:,43),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,43),G0H8(6),m3h4x8(:,41),heltab2x32(:,:,188))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)+c(9)*M(2,:)%j) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(204),h0tab(:,204),[50,1,12],[nMT,0,0],3,2,wf4(:,43),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,43),G0H8(7),m3h4x8(:,42),heltab2x32(:,:,189))
  call Hloop_A_Q(ntryL,G0H8(7),50,nMT,G1H8(9),n2h8(104))
  Gcoeff(:)%j = (c(6)*(-M(2,:)%j+M(3,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(205),h0tab(:,205),[44,1,18],[nMT,0,nMT],3,2,wf8(:,2),wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,2),G0H4(3),m3h8x4(:,28),heltab2x32(:,:,190))
  call Hloop_A_Q(ntryL,G0H4(3),44,nMT,G1H4(103),n2h4(164))
  Gcoeff(:)%j = (c(22)*(-M(2,:)%j+M(3,:)%j)) * den(64)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(206),h0tab(:,206),[44,1,18],[0,nMT,0],3,2,wf8(:,2),wf2(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,2),44,G1H4(104),m3h8x4(:,29),heltab2x32(:,:,191))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(3,:)%j) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(207),h0tab(:,207),[32,1,30],[nMT,0,nMT],3,1,wf8(:,40))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,121),heltab2x32(:,:,192))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(41),n2h16(82))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(3,:)%j) * den(93)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(208),h0tab(:,208),[32,1,30],[0,nMT,0],3,1,wf8(:,40))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(42),m3h2x16(:,122),heltab2x32(:,:,193))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(27)*M(3,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(209),h0tab(:,209),[35,12,16],[nMT,nMT,nMT],3,2,wf8(:,17),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,17),G0H4(3),m3h8x4(:,30),heltab2x32(:,:,194))
  call Hloop_A_Q(ntryL,G0H4(3),35,nMT,G1H4(106),n2h4(165))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(27)*M(3,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(210),h0tab(:,210),[35,12,16],[nMT,nMT,nMT],3,2,wf8(:,17),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,17),G0H4(3),m3h8x4(:,31),heltab2x32(:,:,195))
  call Hloop_Q_A(ntryL,G0H4(3),35,nMT,G1H4(55),n2h4(166))
  Gcoeff(:)%j = (c(2)*M(1,:)%j-c(3)*M(3,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(211),h0tab(:,211),[35,12,16],[nMB,nMB,nMB],3,2,wf8(:,17),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,17),G0H4(3),m3h8x4(:,32),heltab2x32(:,:,196))
  call Hloop_A_Q(ntryL,G0H4(3),35,nMB,G1H4(95),n2h4(167))
  Gcoeff(:)%j = (c(2)*M(1,:)%j-c(3)*M(3,:)%j) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(212),h0tab(:,212),[35,12,16],[nMB,nMB,nMB],3,2,wf8(:,17),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,17),G0H4(3),m3h8x4(:,33),heltab2x32(:,:,197))
  call Hloop_Q_A(ntryL,G0H4(3),35,nMB,G1H4(112),n2h4(168))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(3,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(213),h0tab(:,213),[49,2,12],[0,nMT,nMT],3,2,wf4(:,38),wf4(:,2))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,38),G0H8(8),m3h4x8(:,43),heltab2x32(:,:,198))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(3,:)%j) * den(61)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(214),h0tab(:,214),[49,2,12],[nMT,0,0],3,2,wf4(:,38),wf4(:,2))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,38),G0H8(9),m3h4x8(:,44),heltab2x32(:,:,199))
  call Hloop_Q_A(ntryL,G0H8(9),49,nMT,G1H8(31),n2h8(105))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)+c(21)*M(3,:)%j) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(215),h0tab(:,215),[33,14,16],[0,nMT,nMT],3,2,wf4(:,7),wf8(:,4))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,7),G0H8(10),m3h4x8(:,45),heltab2x32(:,:,200))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)+c(21)*M(3,:)%j) * den(97)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(216),h0tab(:,216),[45,2,16],[0,nMT,nMT],3,1,wf16(:,5))
  call Hloop_AQ_V(ntryL,G0H32(1),wf16(:,5),G0H2(1),m3h16x2(:,1),heltab2x32(:,:,201))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(27)*M(2,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(217),h0tab(:,217),[35,12,16],[nMT,nMT,nMT],3,2,wf8(:,18),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,18),G0H4(3),m3h8x4(:,34),heltab2x32(:,:,202))
  call Hloop_A_Q(ntryL,G0H4(3),35,nMT,G1H4(22),n2h4(169))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(27)*M(2,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(218),h0tab(:,218),[35,12,16],[nMT,nMT,nMT],3,2,wf8(:,18),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,18),G0H4(3),m3h8x4(:,35),heltab2x32(:,:,203))
  call Hloop_Q_A(ntryL,G0H4(3),35,nMT,G1H4(4),n2h4(170))
  Gcoeff(:)%j = (c(2)*M(1,:)%j-c(3)*M(2,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(219),h0tab(:,219),[35,12,16],[nMB,nMB,nMB],3,2,wf8(:,18),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,18),G0H4(3),m3h8x4(:,36),heltab2x32(:,:,204))
  call Hloop_A_Q(ntryL,G0H4(3),35,nMB,G1H4(57),n2h4(171))
  Gcoeff(:)%j = (c(2)*M(1,:)%j-c(3)*M(2,:)%j) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(220),h0tab(:,220),[35,12,16],[nMB,nMB,nMB],3,2,wf8(:,18),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,18),G0H4(3),m3h8x4(:,37),heltab2x32(:,:,205))
  call Hloop_Q_A(ntryL,G0H4(3),35,nMB,G1H4(52),n2h4(172))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)+c(21)*M(2,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(221),h0tab(:,221),[34,13,16],[0,nMT,nMT],3,2,wf4(:,3),wf8(:,7))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,3),G0H8(11),m3h4x8(:,46),heltab2x32(:,:,206))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(2,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(222),h0tab(:,222),[50,1,12],[0,nMT,nMT],3,2,wf4(:,46),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,46),G0H8(12),m3h4x8(:,47),heltab2x32(:,:,207))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)+c(9)*M(2,:)%j) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(223),h0tab(:,223),[50,1,12],[nMT,0,0],3,2,wf4(:,46),wf4(:,2))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,46),G0H8(13),m3h4x8(:,48),heltab2x32(:,:,208))
  call Hloop_A_Q(ntryL,G0H8(13),50,nMT,G1H8(32),n2h8(106))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)+c(21)*M(2,:)%j) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(224),h0tab(:,224),[46,1,16],[0,nMT,nMT],3,1,wf16(:,3))
  call Hloop_QA_V(ntryL,G0H32(1),wf16(:,3),G0H2(2),m3h16x2(:,2),heltab2x32(:,:,209))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(27)*M(2,:)%j) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(225),h0tab(:,225),[32,15,16],[nMT,nMT,nMT],3,1,wf16(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,123),heltab2x32(:,:,210))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(43),n2h16(83))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(27)*M(2,:)%j) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(226),h0tab(:,226),[32,15,16],[nMT,nMT,nMT],3,1,wf16(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,124),heltab2x32(:,:,211))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(44),n2h16(84))
  Gcoeff(:)%j = (c(2)*M(1,:)%j-c(3)*M(2,:)%j) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(227),h0tab(:,227),[32,15,16],[nMB,nMB,nMB],3,1,wf16(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,125),heltab2x32(:,:,212))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(45),n2h16(85))
  Gcoeff(:)%j = (c(2)*M(1,:)%j-c(3)*M(2,:)%j) * den(136)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(228),h0tab(:,228),[32,15,16],[nMB,nMB,nMB],3,1,wf16(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,126),heltab2x32(:,:,213))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(46),n2h16(86))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(27)*M(3,:)%j) * den(137)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(229),h0tab(:,229),[32,15,16],[nMT,nMT,nMT],3,1,wf16(:,9))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,127),heltab2x32(:,:,214))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(47),n2h16(87))
  Gcoeff(:)%j = (c(26)*M(1,:)%j-c(27)*M(3,:)%j) * den(137)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(230),h0tab(:,230),[32,15,16],[nMT,nMT,nMT],3,1,wf16(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,128),heltab2x32(:,:,215))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(48),n2h16(88))
  Gcoeff(:)%j = (c(2)*M(1,:)%j-c(3)*M(3,:)%j) * den(137)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(231),h0tab(:,231),[32,15,16],[nMB,nMB,nMB],3,1,wf16(:,9))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,129),heltab2x32(:,:,216))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(49),n2h16(89))
  Gcoeff(:)%j = (c(2)*M(1,:)%j-c(3)*M(3,:)%j) * den(137)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(232),h0tab(:,232),[32,15,16],[nMB,nMB,nMB],3,1,wf16(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,130),heltab2x32(:,:,217))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(50),n2h16(90))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(2,:)%j) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(233),h0tab(:,233),[32,2,29],[nMT,0,nMT],3,1,wf8(:,47))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,131),heltab2x32(:,:,218))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(51),n2h16(91))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)+c(9)*M(2,:)%j) * den(138)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(234),h0tab(:,234),[32,2,29],[0,nMT,0],3,1,wf8(:,47))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(52),m3h2x16(:,132),heltab2x32(:,:,219))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)+c(21)*M(2,:)%j) * den(139)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(235),h0tab(:,235),[45,2,16],[0,nMT,nMT],3,1,wf16(:,11))
  call Hloop_AQ_V(ntryL,G0H32(1),wf16(:,11),G0H2(3),m3h16x2(:,3),heltab2x32(:,:,220))
  Gcoeff(:)%j = (c(8)*(M(2,:)%j-M(3,:)%j)) * den(140)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(236),h0tab(:,236),[45,2,16],[0,nMT,nMT],3,1,wf16(:,13))
  call Hloop_AQ_V(ntryL,G0H32(1),wf16(:,13),G0H2(4),m3h16x2(:,4),heltab2x32(:,:,221))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(3,:)%j) * den(141)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(237),h0tab(:,237),[32,1,30],[nMT,0,nMT],3,1,wf8(:,49))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,133),heltab2x32(:,:,222))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(53),n2h16(92))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(3,:)%j) * den(141)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(238),h0tab(:,238),[32,1,30],[0,nMT,0],3,1,wf8(:,49))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(54),m3h2x16(:,134),heltab2x32(:,:,223))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)+c(21)*M(3,:)%j) * den(142)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(239),h0tab(:,239),[46,1,16],[0,nMT,nMT],3,1,wf16(:,15))
  call Hloop_QA_V(ntryL,G0H32(1),wf16(:,15),G0H2(5),m3h16x2(:,5),heltab2x32(:,:,224))
  Gcoeff(:)%j = (c(8)*(M(2,:)%j-M(3,:)%j)) * den(143)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(240),h0tab(:,240),[46,1,16],[0,nMT,nMT],3,1,wf16(:,17))
  call Hloop_QA_V(ntryL,G0H32(1),wf16(:,17),G0H2(6),m3h16x2(:,6),heltab2x32(:,:,225))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(2,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(241),h0tab(:,241),[51,4,8],[0,0,0],3,1,wf8(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,1),G0H4(3),m3h8x4(:,38),heltab2x32(:,:,226))
  call Hloop_A_Q(ntryL,G0H4(3),51,0,G1H4(37),n2h4(173))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j) * den(81)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(242),h0tab(:,242),[51,4,8],[0,0,0],3,1,wf8(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,1),51,G1H4(38),m3h8x4(:,39),heltab2x32(:,:,227))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)+c(13)*M(4,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(243),h0tab(:,243),[36,8,19],[0,0,0],3,2,wf4(:,13),wf4(:,4))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,13),G0H8(14),m3h4x8(:,49),heltab2x32(:,:,228))
  Gcoeff(:)%j = (-(c(9)*M(2,:)%j)+c(7)*M(4,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(244),h0tab(:,244),[36,8,19],[0,0,0],3,2,wf4(:,13),wf4(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,13),G0H8(15),m3h4x8(:,50),heltab2x32(:,:,229))
  call Hloop_Q_A(ntryL,G0H8(15),36,0,G1H8(11),n2h8(107))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)+c(13)*M(4,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(245),h0tab(:,245),[44,2,17],[nMT,0,nMT],3,2,wf8(:,8),wf2(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,8),G0H4(3),m3h8x4(:,40),heltab2x32(:,:,230))
  call Hloop_Q_A(ntryL,G0H4(3),44,nMT,G1H4(31),n2h4(174))
  Gcoeff(:)%j = (c(9)*M(2,:)%j-c(7)*M(4,:)%j) * den(62)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(246),h0tab(:,246),[44,2,17],[0,nMT,0],3,2,wf8(:,8),wf2(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,8),44,G1H4(74),m3h8x4(:,41),heltab2x32(:,:,231))
  Gcoeff(:)%j = (-(c(14)*M(3,:)%j)+c(13)*M(4,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(247),h0tab(:,247),[40,4,19],[0,0,0],3,2,wf4(:,15),wf4(:,4))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,15),G0H8(3),m3h4x8(:,51),heltab2x32(:,:,232))
  Gcoeff(:)%j = (c(9)*M(3,:)%j-c(7)*M(4,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(248),h0tab(:,248),[40,4,19],[0,0,0],3,2,wf4(:,15),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(4),m3h4x8(:,52),heltab2x32(:,:,233))
  call Hloop_A_Q(ntryL,G0H8(4),40,0,G1H8(7),n2h8(108))
  Gcoeff(:)%j = (-(c(14)*M(3,:)%j)+c(13)*M(4,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(249),h0tab(:,249),[44,2,17],[nMT,0,nMT],3,2,wf8(:,9),wf2(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,9),G0H4(3),m3h8x4(:,42),heltab2x32(:,:,234))
  call Hloop_Q_A(ntryL,G0H4(3),44,nMT,G1H4(78),n2h4(175))
  Gcoeff(:)%j = (c(9)*M(3,:)%j-c(7)*M(4,:)%j) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(250),h0tab(:,250),[44,2,17],[0,nMT,0],3,2,wf8(:,9),wf2(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,9),44,G1H4(89),m3h8x4(:,43),heltab2x32(:,:,235))
  Gcoeff(:)%j = (-(c(14)*M(3,:)%j)+c(13)*M(4,:)%j) * den(145)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(251),h0tab(:,251),[32,8,23],[0,0,0],3,1,wf8(:,51))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,135),heltab2x32(:,:,236))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(55),n2h16(93))
  Gcoeff(:)%j = (c(9)*M(3,:)%j-c(7)*M(4,:)%j) * den(145)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(252),h0tab(:,252),[32,8,23],[0,0,0],3,1,wf8(:,51))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(56),m3h2x16(:,136),heltab2x32(:,:,237))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)+c(13)*M(4,:)%j) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(253),h0tab(:,253),[32,4,27],[0,0,0],3,1,wf8(:,53))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,137),heltab2x32(:,:,238))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(57),n2h16(94))
  Gcoeff(:)%j = (-(c(9)*M(2,:)%j)+c(7)*M(4,:)%j) * den(147)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(254),h0tab(:,254),[32,4,27],[0,0,0],3,1,wf8(:,53))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(58),m3h2x16(:,138),heltab2x32(:,:,239))
  Gcoeff(:)%j = (c(6)*(M(2,:)%j-M(3,:)%j)) * den(148)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(255),h0tab(:,255),[51,4,8],[0,0,0],3,1,wf8(:,54))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,54),G0H4(3),m3h8x4(:,44),heltab2x32(:,:,240))
  call Hloop_A_Q(ntryL,G0H4(3),51,0,G1H4(96),n2h4(176))
  Gcoeff(:)%j = (c(22)*(M(2,:)%j-M(3,:)%j)) * den(148)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(256),h0tab(:,256),[51,4,8],[0,0,0],3,1,wf8(:,54))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,54),51,G1H4(101),m3h8x4(:,45),heltab2x32(:,:,241))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(3,:)%j) * den(149)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(257),h0tab(:,257),[51,4,8],[0,0,0],3,1,wf8(:,55))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,55),G0H4(3),m3h8x4(:,46),heltab2x32(:,:,242))
  call Hloop_A_Q(ntryL,G0H4(3),51,0,G1H4(102),n2h4(177))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(3,:)%j) * den(149)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(258),h0tab(:,258),[51,4,8],[0,0,0],3,1,wf8(:,55))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,55),51,G1H4(113),m3h8x4(:,47),heltab2x32(:,:,243))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(3,:)%j) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(259),h0tab(:,259),[51,4,8],[0,0,0],3,1,wf8(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,5),G0H4(3),m3h8x4(:,48),heltab2x32(:,:,244))
  call Hloop_A_Q(ntryL,G0H4(3),51,0,G1H4(50),n2h4(178))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(3,:)%j) * den(99)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(260),h0tab(:,260),[51,4,8],[0,0,0],3,1,wf8(:,5))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,5),51,G1H4(114),m3h8x4(:,49),heltab2x32(:,:,245))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)+c(13)*M(4,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(261),h0tab(:,261),[36,8,19],[0,0,0],3,2,wf4(:,13),wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,13),G0H8(7),m3h4x8(:,53),heltab2x32(:,:,246))
  Gcoeff(:)%j = (-(c(9)*M(2,:)%j)+c(7)*M(4,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(262),h0tab(:,262),[36,8,19],[0,0,0],3,2,wf4(:,13),wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,13),G0H8(9),m3h4x8(:,54),heltab2x32(:,:,247))
  call Hloop_Q_A(ntryL,G0H8(9),36,0,G1H8(6),n2h8(109))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)+c(13)*M(4,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(263),h0tab(:,263),[44,1,18],[nMT,0,nMT],3,2,wf8(:,8),wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,8),G0H4(3),m3h8x4(:,50),heltab2x32(:,:,248))
  call Hloop_A_Q(ntryL,G0H4(3),44,nMT,G1H4(116),n2h4(179))
  Gcoeff(:)%j = (-(c(9)*M(2,:)%j)+c(7)*M(4,:)%j) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(264),h0tab(:,264),[44,1,18],[0,nMT,0],3,2,wf8(:,8),wf2(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,8),44,G1H4(119),m3h8x4(:,51),heltab2x32(:,:,249))
  Gcoeff(:)%j = (-(c(14)*M(3,:)%j)+c(13)*M(4,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(265),h0tab(:,265),[40,4,19],[0,0,0],3,2,wf4(:,15),wf4(:,8))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,15),G0H8(13),m3h4x8(:,55),heltab2x32(:,:,250))
  Gcoeff(:)%j = (c(9)*M(3,:)%j-c(7)*M(4,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(266),h0tab(:,266),[40,4,19],[0,0,0],3,2,wf4(:,15),wf4(:,8))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(15),m3h4x8(:,56),heltab2x32(:,:,251))
  call Hloop_A_Q(ntryL,G0H8(15),40,0,G1H8(10),n2h8(110))
  Gcoeff(:)%j = (-(c(14)*M(3,:)%j)+c(13)*M(4,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(267),h0tab(:,267),[44,1,18],[nMT,0,nMT],3,2,wf8(:,9),wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,9),G0H4(3),m3h8x4(:,52),heltab2x32(:,:,252))
  call Hloop_A_Q(ntryL,G0H4(3),44,nMT,G1H4(21),n2h4(180))
  Gcoeff(:)%j = (-(c(9)*M(3,:)%j)+c(7)*M(4,:)%j) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(268),h0tab(:,268),[44,1,18],[0,nMT,0],3,2,wf8(:,9),wf2(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,9),44,G1H4(122),m3h8x4(:,53),heltab2x32(:,:,253))
  Gcoeff(:)%j = (-(c(14)*M(3,:)%j)+c(13)*M(4,:)%j) * den(150)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(269),h0tab(:,269),[32,8,23],[0,0,0],3,1,wf8(:,57))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,139),heltab2x32(:,:,254))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(59),n2h16(95))
  Gcoeff(:)%j = (c(9)*M(3,:)%j-c(7)*M(4,:)%j) * den(150)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(270),h0tab(:,270),[32,8,23],[0,0,0],3,1,wf8(:,57))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(60),m3h2x16(:,140),heltab2x32(:,:,255))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)+c(13)*M(4,:)%j) * den(151)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(271),h0tab(:,271),[32,4,27],[0,0,0],3,1,wf8(:,59))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,141),heltab2x32(:,:,256))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(61),n2h16(96))
  Gcoeff(:)%j = (-(c(9)*M(2,:)%j)+c(7)*M(4,:)%j) * den(151)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(272),h0tab(:,272),[32,4,27],[0,0,0],3,1,wf8(:,59))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(62),m3h2x16(:,142),heltab2x32(:,:,257))
  Gcoeff(:)%j = (c(6)*(M(2,:)%j-M(3,:)%j)) * den(152)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(273),h0tab(:,273),[51,4,8],[0,0,0],3,1,wf8(:,60))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,60),G0H4(3),m3h8x4(:,54),heltab2x32(:,:,258))
  call Hloop_A_Q(ntryL,G0H4(3),51,0,G1H4(51),n2h4(181))
  Gcoeff(:)%j = (c(22)*(M(2,:)%j-M(3,:)%j)) * den(152)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(274),h0tab(:,274),[51,4,8],[0,0,0],3,1,wf8(:,60))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,60),51,G1H4(76),m3h8x4(:,55),heltab2x32(:,:,259))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(2,:)%j) * den(153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(275),h0tab(:,275),[51,4,8],[0,0,0],3,1,wf8(:,61))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,61),G0H4(3),m3h8x4(:,56),heltab2x32(:,:,260))
  call Hloop_A_Q(ntryL,G0H4(3),51,0,G1H4(30),n2h4(182))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j) * den(153)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(276),h0tab(:,276),[51,4,8],[0,0,0],3,1,wf8(:,61))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,61),51,G1H4(8),m3h8x4(:,57),heltab2x32(:,:,261))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(3,:)%j) * den(154)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(277),h0tab(:,277),[51,4,8],[0,0,0],3,1,wf8(:,62))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,62),G0H4(3),m3h8x4(:,58),heltab2x32(:,:,262))
  call Hloop_A_Q(ntryL,G0H4(3),51,0,G1H4(46),n2h4(183))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(3,:)%j) * den(154)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(278),h0tab(:,278),[51,4,8],[0,0,0],3,1,wf8(:,62))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,62),51,G1H4(11),m3h8x4(:,59),heltab2x32(:,:,263))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(2,:)%j) * den(155)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(279),h0tab(:,279),[51,4,8],[0,0,0],3,1,wf8(:,63))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,63),G0H4(3),m3h8x4(:,60),heltab2x32(:,:,264))
  call Hloop_A_Q(ntryL,G0H4(3),51,0,G1H4(6),n2h4(184))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j) * den(155)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(280),h0tab(:,280),[51,4,8],[0,0,0],3,1,wf8(:,63))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,63),51,G1H4(72),m3h8x4(:,61),heltab2x32(:,:,265))
  Gcoeff(:)%j = (c(21)*M(2,:)%j-c(16)*M(4,:)%j) * den(156)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(281),h0tab(:,281),[45,2,16],[0,nMT,nMT],3,1,wf16(:,19))
  call Hloop_AQ_V(ntryL,G0H32(1),wf16(:,19),G0H2(7),m3h16x2(:,7),heltab2x32(:,:,266))
  Gcoeff(:)%j = (c(21)*M(2,:)%j-c(16)*M(4,:)%j) * den(157)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(282),h0tab(:,282),[46,1,16],[0,nMT,nMT],3,1,wf16(:,21))
  call Hloop_QA_V(ntryL,G0H32(1),wf16(:,21),G0H2(8),m3h16x2(:,8),heltab2x32(:,:,267))
  Gcoeff(:)%j = (c(21)*M(3,:)%j-c(16)*M(4,:)%j) * den(158)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(283),h0tab(:,283),[45,2,16],[0,nMT,nMT],3,1,wf16(:,23))
  call Hloop_AQ_V(ntryL,G0H32(1),wf16(:,23),G0H2(9),m3h16x2(:,9),heltab2x32(:,:,268))
  Gcoeff(:)%j = (c(21)*M(3,:)%j-c(16)*M(4,:)%j) * den(159)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(284),h0tab(:,284),[46,1,16],[0,nMT,nMT],3,1,wf16(:,25))
  call Hloop_QA_V(ntryL,G0H32(1),wf16(:,25),G0H2(10),m3h16x2(:,10),heltab2x32(:,:,269))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(125),[G1H2(80),G1H2(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(29),[G1H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G1H4(106),G1H4(20),G1H4(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(4),[G1H4(55),G1H4(36),G1H4(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(89),[G1H4(74),G1H4(97),G1H4(98),G0H4(1),G0H4(2) &
    ,G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(122),[G1H4(119),G1H4(104),G1H4(105),G0H4(7),G0H4(6) &
    ,G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(28),[G1H4(110),G1H4(64),G1H4(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(70),G1H4(59),G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(93),[G1H4(121),G1H4(71),G1H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(87),[G1H4(81),G1H4(24),G1H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(57),[G1H4(95),G1H4(25),G1H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(52),[G1H4(112),G1H4(60),G1H4(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(27),[G1H8(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(20),[G1H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(72),[G1H4(11),G1H4(8),G1H4(76),G1H4(114),G1H4(113) &
    ,G1H4(101),G1H4(38),G0H4(12),G0H4(13),G0H4(11),G0H4(10),G0H4(9),G0H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(17),[G1H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(19),[G1H16(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(8),[G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(31),[G1H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(78),[G1H4(31),G1H4(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(32),[G1H16(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(34),[G1H16(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(12),[G0H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(32),[G1H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(21),[G1H4(116),G1H4(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(9),[G0H2(7),G0H2(4),G0H2(3),G0H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(10),[G0H2(8),G0H2(6),G0H2(5),G0H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G1H4(46),G1H4(30),G1H4(51),G1H4(50),G1H4(102) &
    ,G1H4(96),G1H4(37)])
  call Hloop_QS_A(ntryL,G1H2(125),ex5(:),G1H2(102),ngH,m3h1x2(:,38),heltab2x2(:,:,312))
  call Hloop_Q_A(ntryL,G1H2(102),61,nMT,G2H2(4),n2h2(172))
  call Hloop_QV_A(ntryL,G1H8(29),wf4(:,2),G1H2(11),m3h4x2(:,43),heltab2x8(:,:,203))
  call Hloop_Q_A(ntryL,G1H2(11),61,nMT,G2H2(17),n2h2(173))
  call Hloop_AS_Q(ntryL,G1H2(25),ex5(:),G1H2(64),ngH,m3h1x2(:,39),heltab2x2(:,:,313))
  call Hloop_A_Q(ntryL,G1H2(64),62,nMT,G2H2(20),n2h2(174))
  call Hloop_QS_A(ntryL,G1H4(29),ex5(:),G1H4(73),ngH,m3h1x4(:,47),heltab2x4(:,:,361))
  call Hloop_Q_A(ntryL,G1H4(73),51,nMT,G2H4(5),n2h4(185))
  call Hloop_AS_Q(ntryL,G1H4(7),ex5(:),G1H4(79),ngH,m3h1x4(:,48),heltab2x4(:,:,362))
  call Hloop_A_Q(ntryL,G1H4(79),51,nMT,G2H4(14),n2h4(186))
  call Hloop_AV_Q(ntryL,G1H4(22),wf4(:,2),G1H1(26),m3h4x1(:,154),heltab2x4(:,:,363))
  call Hloop_A_Q(ntryL,G1H1(26),47,nMT,G2H1(23),n2h1(436))
  call Hloop_QV_A(ntryL,G1H4(4),wf4(:,2),G1H1(114),m3h4x1(:,155),heltab2x4(:,:,364))
  call Hloop_Q_A(ntryL,G1H1(114),47,nMT,G2H1(24),n2h1(437))
  call Hloop_VA_Q(ntryL,G1H4(89),ex2(:),G1H2(106),m3h2x2(:,162),heltab2x4(:,:,365))
  call Hloop_A_Q(ntryL,G1H2(106),46,nMT,G2H2(24),n2h2(175))
  call Hloop_VQ_A(ntryL,G1H4(122),ex1(:),G1H2(107),m3h2x2(:,163),heltab2x4(:,:,366))
  call Hloop_Q_A(ntryL,G1H2(107),45,nMT,G2H2(2),n2h2(176))
  call Hloop_AV_Q(ntryL,G1H4(28),wf4(:,16),G1H1(27),m3h4x1(:,156),heltab2x4(:,:,367))
  call Hloop_A_Q(ntryL,G1H1(27),47,nMT,G2H1(2),n2h1(438))
  call Hloop_QV_A(ntryL,G1H4(2),wf4(:,16),G1H1(133),m3h4x1(:,157),heltab2x4(:,:,368))
  call Hloop_Q_A(ntryL,G1H1(133),47,nMT,G2H1(4),n2h1(439))
  call Hloop_AV_Q(ntryL,G1H4(93),wf4(:,16),G1H1(69),m3h4x1(:,158),heltab2x4(:,:,369))
  call Hloop_A_Q(ntryL,G1H1(69),47,nMB,G2H1(6),n2h1(440))
  call Hloop_QV_A(ntryL,G1H4(87),wf4(:,16),G1H1(120),m3h4x1(:,159),heltab2x4(:,:,370))
  call Hloop_Q_A(ntryL,G1H1(120),47,nMB,G2H1(8),n2h1(441))
  call Hloop_AV_Q(ntryL,G1H4(57),wf4(:,2),G1H1(103),m3h4x1(:,160),heltab2x4(:,:,371))
  call Hloop_A_Q(ntryL,G1H1(103),47,nMB,G2H1(1),n2h1(442))
  call Hloop_QV_A(ntryL,G1H4(52),wf4(:,2),G1H1(92),m3h4x1(:,161),heltab2x4(:,:,372))
  call Hloop_Q_A(ntryL,G1H1(92),47,nMB,G2H1(31),n2h1(443))
  call Hloop_QS_A(ntryL,G1H4(107),ex5(:),G1H4(13),ngH,m3h1x4(:,49),heltab2x4(:,:,373))
  call Hloop_Q_A(ntryL,G1H4(13),51,nMB,G2H4(40),n2h4(187))
  call Hloop_AS_Q(ntryL,G1H4(9),ex5(:),G1H4(10),ngH,m3h1x4(:,50),heltab2x4(:,:,374))
  call Hloop_A_Q(ntryL,G1H4(10),51,nMB,G2H4(19),n2h4(188))
  call Hloop_AV_Q(ntryL,G1H8(27),wf4(:,2),G1H2(108),m3h4x2(:,44),heltab2x8(:,:,204))
  call Hloop_A_Q(ntryL,G1H2(108),46,nMT,G2H2(7),n2h2(177))
  call Hloop_QV_A(ntryL,G1H8(20),wf4(:,2),G1H2(112),m3h4x2(:,45),heltab2x8(:,:,205))
  call Hloop_Q_A(ntryL,G1H2(112),45,nMT,G2H2(14),n2h2(178))
  call Hloop_AS_Q(ntryL,G1H8(2),ex5(:),G1H8(15),ngH,m3h1x8(:,42),heltab2x8(:,:,206))
  call Hloop_A_Q(ntryL,G1H8(15),50,nMT,G2H8(12),n2h8(111))
  call Hloop_QS_A(ntryL,G1H8(35),ex5(:),G1H8(28),ngH,m3h1x8(:,43),heltab2x8(:,:,207))
  call Hloop_Q_A(ntryL,G1H8(28),49,nMT,G2H8(15),n2h8(112))
  call Hloop_QV_A(ntryL,G1H8(25),wf4(:,4),G1H2(113),m3h4x2(:,46),heltab2x8(:,:,208))
  call Hloop_Q_A(ntryL,G1H2(113),55,0,G2H2(27),n2h2(179))
  call Hloop_QV_A(ntryL,G1H8(14),wf4(:,8),G1H2(114),m3h4x2(:,47),heltab2x8(:,:,209))
  call Hloop_Q_A(ntryL,G1H2(114),55,0,G2H2(28),n2h2(180))
  call Hloop_VQ_A(ntryL,G1H4(72),ex3(:),G1H2(118),m3h2x2(:,164),heltab2x4(:,:,375))
  call Hloop_Q_A(ntryL,G1H2(118),55,0,G2H2(29),n2h2(181))
  call Hloop_AV_Q(ntryL,G1H16(1),wf16(:,1),G1H1(45),m3h16x1(:,1),heltab2x16(:,:,81))
  call Hloop_A_Q(ntryL,G1H1(45),47,nMT,G2H1(32),n2h1(444))
  call Hloop_QV_A(ntryL,G1H16(2),wf16(:,1),G1H1(132),m3h16x1(:,2),heltab2x16(:,:,82))
  call Hloop_Q_A(ntryL,G1H1(132),47,nMT,G2H1(14),n2h1(445))
  call Hloop_AV_Q(ntryL,G1H16(3),wf16(:,1),G1H1(39),m3h16x1(:,3),heltab2x16(:,:,83))
  call Hloop_A_Q(ntryL,G1H1(39),47,nMB,G2H1(25),n2h1(446))
  call Hloop_QV_A(ntryL,G1H16(4),wf16(:,1),G1H1(109),m3h16x1(:,4),heltab2x16(:,:,84))
  call Hloop_Q_A(ntryL,G1H1(109),47,nMB,G2H1(13),n2h1(447))
  call Hloop_AV_Q(ntryL,G1H16(5),wf16(:,6),G1H1(62),m3h16x1(:,5),heltab2x16(:,:,85))
  call Hloop_A_Q(ntryL,G1H1(62),47,nMT,G2H1(11),n2h1(448))
  call Hloop_QV_A(ntryL,G1H16(6),wf16(:,6),G1H1(77),m3h16x1(:,6),heltab2x16(:,:,86))
  call Hloop_Q_A(ntryL,G1H1(77),47,nMT,G2H1(15),n2h1(449))
  call Hloop_AV_Q(ntryL,G1H16(7),wf16(:,6),G1H1(51),m3h16x1(:,7),heltab2x16(:,:,87))
  call Hloop_A_Q(ntryL,G1H1(51),47,nMB,G2H1(17),n2h1(450))
  call Hloop_QV_A(ntryL,G1H16(8),wf16(:,6),G1H1(136),m3h16x1(:,8),heltab2x16(:,:,88))
  call Hloop_Q_A(ntryL,G1H1(136),47,nMB,G2H1(27),n2h1(451))
  call Hloop_AV_Q(ntryL,G1H16(9),wf16(:,7),G1H1(125),m3h16x1(:,9),heltab2x16(:,:,89))
  call Hloop_A_Q(ntryL,G1H1(125),47,nMT,G2H1(3),n2h1(452))
  call Hloop_QV_A(ntryL,G1H16(10),wf16(:,7),G1H1(134),m3h16x1(:,10),heltab2x16(:,:,90))
  call Hloop_Q_A(ntryL,G1H1(134),47,nMT,G2H1(18),n2h1(453))
  call Hloop_AV_Q(ntryL,G1H16(11),wf16(:,7),G1H1(57),m3h16x1(:,11),heltab2x16(:,:,91))
  call Hloop_A_Q(ntryL,G1H1(57),47,nMB,G2H1(22),n2h1(454))
  call Hloop_QV_A(ntryL,G1H16(12),wf16(:,7),G1H1(143),m3h16x1(:,12),heltab2x16(:,:,92))
  call Hloop_Q_A(ntryL,G1H1(143),47,nMB,G2H1(21),n2h1(455))
  call Hloop_UV_W(ntryL,G0H8(1),34,wf4(:,2),12,G1H2(119),m3h4x2(:,48),heltab2x8(:,:,210))
  call Hloop_QV_A(ntryL,G1H16(17),wf4(:,2),G1H4(17),m3h4x4(:,19),heltab2x16(:,:,93))
  call Hloop_Q_A(ntryL,G1H4(17),44,0,G2H4(21),n2h4(189))
  call Hloop_QV_A(ntryL,G1H16(14),wf4(:,2),G1H4(58),m3h4x4(:,20),heltab2x16(:,:,94))
  call Hloop_Q_A(ntryL,G1H4(58),44,nMT,G2H4(38),n2h4(190))
  call Hloop_AV_Q(ntryL,G1H16(19),wf4(:,2),G1H4(42),m3h4x4(:,21),heltab2x16(:,:,95))
  call Hloop_A_Q(ntryL,G1H4(42),44,0,G2H4(31),n2h4(191))
  call Hloop_AV_Q(ntryL,G1H16(16),wf4(:,2),G1H4(54),m3h4x4(:,22),heltab2x16(:,:,96))
  call Hloop_A_Q(ntryL,G1H4(54),44,nMT,G2H4(20),n2h4(192))
  call Hloop_QV_A(ntryL,G1H16(18),wf4(:,2),G1H4(124),m3h4x4(:,23),heltab2x16(:,:,97))
  call Hloop_Q_A(ntryL,G1H4(124),44,nMB,G2H4(9),n2h4(193))
  call Hloop_AV_Q(ntryL,G1H16(20),wf4(:,2),G1H4(125),m3h4x4(:,24),heltab2x16(:,:,98))
  call Hloop_A_Q(ntryL,G1H4(125),44,nMB,G2H4(12),n2h4(194))
  call Hloop_CV_D(ntryL,G1H16(21),32,wf4(:,2),12,G2H4(33),m3h4x4(:,25),heltab2x16(:,:,99))
  call Hloop_DV_C(ntryL,G1H16(22),32,wf4(:,2),G2H4(36),m3h4x4(:,26),heltab2x16(:,:,100))
  call Hloop_UV_W(ntryL,G1H16(23),32,wf4(:,2),12,G2H4(29),m3h4x4(:,27),heltab2x16(:,:,101))
  call Hloop_VA_Q(ntryL,G0H8(8),ex2(:),G0H4(3),m3h2x4(:,112),heltab2x8(:,:,211))
  call Hloop_A_Q(ntryL,G0H4(3),51,nMT,G1H4(126),n2h4(195))
  call Hloop_QA_V(ntryL,G1H8(31),ex2(:),G1H4(129),m3h2x4(:,113),heltab2x8(:,:,212))
  call Hloop_QA_V(ntryL,G1H16(24),wf8(:,4),G1H2(61),m3h8x2(:,3),heltab2x16(:,:,102))
  call Hloop_VA_Q(ntryL,G1H16(25),wf8(:,4),G1H2(131),m3h8x2(:,4),heltab2x16(:,:,103))
  call Hloop_A_Q(ntryL,G1H2(131),46,nMT,G2H2(30),n2h2(182))
  call Hloop_QA_V(ntryL,G1H4(78),ex2(:),G1H2(79),m3h2x2(:,165),heltab2x4(:,:,376))
  call Hloop_QA_V(ntryL,G1H16(26),ex2(:),G1H8(22),m3h2x8(:,61),heltab2x16(:,:,104))
  call Hloop_VA_Q(ntryL,G1H16(27),ex2(:),G1H8(24),m3h2x8(:,62),heltab2x16(:,:,105))
  call Hloop_A_Q(ntryL,G1H8(24),34,nMT,G2H8(16),n2h8(113))
  call Hloop_UV_W(ntryL,G0H8(5),33,wf4(:,2),12,G1H2(48),m3h4x2(:,49),heltab2x8(:,:,213))
  call Hloop_QV_A(ntryL,G1H16(32),wf4(:,2),G1H4(130),m3h4x4(:,28),heltab2x16(:,:,106))
  call Hloop_Q_A(ntryL,G1H4(130),44,0,G2H4(37),n2h4(196))
  call Hloop_QV_A(ntryL,G1H16(29),wf4(:,2),G1H4(131),m3h4x4(:,29),heltab2x16(:,:,107))
  call Hloop_Q_A(ntryL,G1H4(131),44,nMT,G2H4(34),n2h4(197))
  call Hloop_AV_Q(ntryL,G1H16(34),wf4(:,2),G1H4(134),m3h4x4(:,30),heltab2x16(:,:,108))
  call Hloop_A_Q(ntryL,G1H4(134),44,0,G2H4(23),n2h4(198))
  call Hloop_AV_Q(ntryL,G1H16(31),wf4(:,2),G1H4(109),m3h4x4(:,31),heltab2x16(:,:,109))
  call Hloop_A_Q(ntryL,G1H4(109),44,nMT,G2H4(13),n2h4(199))
  call Hloop_QV_A(ntryL,G1H16(33),wf4(:,2),G1H4(117),m3h4x4(:,32),heltab2x16(:,:,110))
  call Hloop_Q_A(ntryL,G1H4(117),44,nMB,G2H4(35),n2h4(200))
  call Hloop_AV_Q(ntryL,G1H16(35),wf4(:,2),G1H4(137),m3h4x4(:,33),heltab2x16(:,:,111))
  call Hloop_A_Q(ntryL,G1H4(137),44,nMB,G2H4(26),n2h4(201))
  call Hloop_CV_D(ntryL,G1H16(36),32,wf4(:,2),12,G2H4(15),m3h4x4(:,34),heltab2x16(:,:,112))
  call Hloop_DV_C(ntryL,G1H16(37),32,wf4(:,2),G2H4(2),m3h4x4(:,35),heltab2x16(:,:,113))
  call Hloop_UV_W(ntryL,G1H16(38),32,wf4(:,2),12,G2H4(8),m3h4x4(:,36),heltab2x16(:,:,114))
  call Hloop_AQ_V(ntryL,G1H16(39),wf8(:,7),G1H2(84),m3h8x2(:,5),heltab2x16(:,:,115))
  call Hloop_VQ_A(ntryL,G1H16(40),wf8(:,7),G1H2(53),m3h8x2(:,6),heltab2x16(:,:,116))
  call Hloop_Q_A(ntryL,G1H2(53),45,nMT,G2H2(31),n2h2(183))
  call Hloop_VQ_A(ntryL,G0H8(12),ex1(:),G0H4(1),m3h2x4(:,114),heltab2x8(:,:,214))
  call Hloop_Q_A(ntryL,G0H4(1),51,nMT,G1H4(115),n2h4(202))
  call Hloop_AQ_V(ntryL,G1H8(32),ex1(:),G1H4(138),m3h2x4(:,115),heltab2x8(:,:,215))
  call Hloop_AQ_V(ntryL,G1H4(21),ex1(:),G1H2(46),m3h2x2(:,166),heltab2x4(:,:,377))
  call Hloop_AQ_V(ntryL,G1H16(41),ex1(:),G1H8(21),m3h2x8(:,63),heltab2x16(:,:,117))
  call Hloop_VQ_A(ntryL,G1H16(42),ex1(:),G1H8(13),m3h2x8(:,64),heltab2x16(:,:,118))
  call Hloop_Q_A(ntryL,G1H8(13),33,nMT,G2H8(17),n2h8(114))
  call Hloop_VA_Q(ntryL,G0H8(10),wf8(:,4),G0H1(1),m3h8x1(:,9),heltab2x8(:,:,216))
  call Hloop_A_Q(ntryL,G0H1(1),47,nMT,G1H1(78),n2h1(456))
  call Hloop_VA_Q(ntryL,G0H2(9),ex2(:),G0H1(1),m3h2x1(:,275),heltab2x2(:,:,314))
  call Hloop_A_Q(ntryL,G0H1(1),47,nMT,G1H1(142),n2h1(457))
  call Hloop_VQ_A(ntryL,G0H8(11),wf8(:,7),G0H1(1),m3h8x1(:,10),heltab2x8(:,:,217))
  call Hloop_Q_A(ntryL,G0H1(1),47,nMT,G1H1(85),n2h1(458))
  call Hloop_VQ_A(ntryL,G0H2(10),ex1(:),G0H1(1),m3h2x1(:,276),heltab2x2(:,:,315))
  call Hloop_Q_A(ntryL,G0H1(1),47,nMT,G1H1(97),n2h1(459))
  call Hloop_AV_Q(ntryL,G1H16(43),wf16(:,8),G1H1(41),m3h16x1(:,13),heltab2x16(:,:,119))
  call Hloop_A_Q(ntryL,G1H1(41),47,nMT,G2H1(33),n2h1(460))
  call Hloop_QV_A(ntryL,G1H16(44),wf16(:,8),G1H1(118),m3h16x1(:,14),heltab2x16(:,:,120))
  call Hloop_Q_A(ntryL,G1H1(118),47,nMT,G2H1(35),n2h1(461))
  call Hloop_AV_Q(ntryL,G1H16(45),wf16(:,8),G1H1(116),m3h16x1(:,15),heltab2x16(:,:,121))
  call Hloop_A_Q(ntryL,G1H1(116),47,nMB,G2H1(5),n2h1(462))
  call Hloop_QV_A(ntryL,G1H16(46),wf16(:,8),G1H1(131),m3h16x1(:,16),heltab2x16(:,:,122))
  call Hloop_Q_A(ntryL,G1H1(131),47,nMB,G2H1(36),n2h1(463))
  call Hloop_AV_Q(ntryL,G1H16(47),wf16(:,9),G1H1(31),m3h16x1(:,17),heltab2x16(:,:,123))
  call Hloop_A_Q(ntryL,G1H1(31),47,nMT,G2H1(38),n2h1(464))
  call Hloop_QV_A(ntryL,G1H16(48),wf16(:,9),G1H1(121),m3h16x1(:,18),heltab2x16(:,:,124))
  call Hloop_Q_A(ntryL,G1H1(121),47,nMT,G2H1(28),n2h1(465))
  call Hloop_AV_Q(ntryL,G1H16(49),wf16(:,9),G1H1(122),m3h16x1(:,19),heltab2x16(:,:,125))
  call Hloop_A_Q(ntryL,G1H1(122),47,nMB,G2H1(39),n2h1(466))
  call Hloop_QV_A(ntryL,G1H16(50),wf16(:,9),G1H1(72),m3h16x1(:,20),heltab2x16(:,:,126))
  call Hloop_Q_A(ntryL,G1H1(72),47,nMB,G2H1(41),n2h1(467))
  call Hloop_QA_V(ntryL,G1H16(51),ex2(:),G1H8(33),m3h2x8(:,65),heltab2x16(:,:,127))
  call Hloop_VA_Q(ntryL,G1H16(52),ex2(:),G1H8(3),m3h2x8(:,66),heltab2x16(:,:,128))
  call Hloop_A_Q(ntryL,G1H8(3),34,nMT,G2H8(18),n2h8(115))
  call Hloop_AQ_V(ntryL,G1H16(53),ex1(:),G1H8(12),m3h2x8(:,67),heltab2x16(:,:,129))
  call Hloop_VQ_A(ntryL,G1H16(54),ex1(:),G1H8(34),m3h2x8(:,68),heltab2x16(:,:,130))
  call Hloop_Q_A(ntryL,G1H8(34),33,nMT,G2H8(19),n2h8(116))
  call Hloop_AQ_V(ntryL,G1H4(6),ex3(:),G1H2(89),m3h2x2(:,167),heltab2x4(:,:,378))
  call Hloop_VA_Q(ntryL,G0H8(14),ex4(:),G0H4(2),m3h2x4(:,116),heltab2x8(:,:,218))
  call Hloop_A_Q(ntryL,G0H4(2),44,0,G1H4(141),n2h4(203))
  call Hloop_QA_V(ntryL,G1H8(11),ex4(:),G1H4(106),m3h2x4(:,117),heltab2x8(:,:,219))
  call Hloop_VQ_A(ntryL,G0H8(3),ex3(:),G0H4(4),m3h2x4(:,118),heltab2x8(:,:,220))
  call Hloop_Q_A(ntryL,G0H4(4),44,0,G1H4(20),n2h4(204))
  call Hloop_AQ_V(ntryL,G1H8(7),ex3(:),G1H4(82),m3h2x4(:,119),heltab2x8(:,:,221))
  call Hloop_QA_V(ntryL,G1H16(55),ex4(:),G1H8(36),m3h2x8(:,69),heltab2x16(:,:,131))
  call Hloop_VA_Q(ntryL,G1H16(56),ex4(:),G1H8(23),m3h2x8(:,70),heltab2x16(:,:,132))
  call Hloop_A_Q(ntryL,G1H8(23),40,0,G2H8(20),n2h8(117))
  call Hloop_AQ_V(ntryL,G1H16(57),ex3(:),G1H8(37),m3h2x8(:,71),heltab2x16(:,:,133))
  call Hloop_VQ_A(ntryL,G1H16(58),ex3(:),G1H8(8),m3h2x8(:,72),heltab2x16(:,:,134))
  call Hloop_Q_A(ntryL,G1H8(8),36,0,G2H8(2),n2h8(118))
  call Hloop_VA_Q(ntryL,G0H8(7),ex4(:),G0H4(7),m3h2x4(:,120),heltab2x8(:,:,222))
  call Hloop_A_Q(ntryL,G0H4(7),44,0,G1H4(55),n2h4(205))
  call Hloop_QA_V(ntryL,G1H8(6),ex4(:),G1H4(36),m3h2x4(:,121),heltab2x8(:,:,223))
  call Hloop_VQ_A(ntryL,G0H8(13),ex3(:),G0H4(6),m3h2x4(:,122),heltab2x8(:,:,224))
  call Hloop_Q_A(ntryL,G0H4(6),44,0,G1H4(91),n2h4(206))
  call Hloop_AQ_V(ntryL,G1H8(10),ex3(:),G1H4(74),m3h2x4(:,123),heltab2x8(:,:,225))
  call Hloop_QA_V(ntryL,G1H16(59),ex4(:),G1H8(18),m3h2x8(:,73),heltab2x16(:,:,135))
  call Hloop_VA_Q(ntryL,G1H16(60),ex4(:),G1H8(19),m3h2x8(:,74),heltab2x16(:,:,136))
  call Hloop_A_Q(ntryL,G1H8(19),40,0,G2H8(10),n2h8(119))
  call Hloop_AQ_V(ntryL,G1H16(61),ex3(:),G1H8(1),m3h2x8(:,75),heltab2x16(:,:,137))
  call Hloop_VQ_A(ntryL,G1H16(62),ex3(:),G1H8(38),m3h2x8(:,76),heltab2x16(:,:,138))
  call Hloop_Q_A(ntryL,G1H8(38),36,0,G2H8(14),n2h8(120))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(85),[G2H2(81),G2H2(42),G2H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(67),[G2H2(56),G2H2(6),G2H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(71),[G1H1(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(97),[G1H1(44),G1H1(23),G1H1(89)])
call HGT_w2_OLR(G1H1(71),1,1,1)
call HGT_w2_invQ_OLR(G1H1(71),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(71),[G1H1(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(86),[G1H4(53)])
call HGT_w2_OLR(G1H4(12),1,1,4)
call HGT_w2_invQ_OLR(G1H4(12),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(117),[G1H1(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(142),[G1H1(87),G1H1(50),G1H1(96)])
call HGT_w2_OLR(G1H1(117),1,1,1)
call HGT_w2_invQ_OLR(G1H1(117),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(117),[G1H1(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(85),[G1H1(11),G1H1(38),G1H1(129)])
call HGT_w2_OLR(G1H1(43),1,1,1)
call HGT_w2_invQ_OLR(G1H1(43),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(43),[G1H1(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(4),[G1H1(5),G1H1(24)])
call HGT_OLR(G2H1(9),1,1,1)
call HGT_invQ_OLR(G2H1(9),2,5,1)
call HGT_OLR(G2H1(9),6,15,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(9),[G2H1(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G1H4(34),G1H4(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(2),[G1H1(60),G1H1(55)])
call HGT_OLR(G2H1(10),1,1,1)
call HGT_invQ_OLR(G2H1(10),2,5,1)
call HGT_OLR(G2H1(10),6,15,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(10),[G2H1(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(22),[G1H4(118),G1H4(80)])
call HGT_OLR(G2H4(7),1,1,4)
call HGT_invQ_OLR(G2H4(7),2,5,4)
call HGT_OLR(G2H4(7),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G1H4(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(38),[G2H1(33),G2H1(3),G2H1(11),G2H1(32),G2H1(26),G2H1(12) &
    ,G1H1(13),G1H1(63),G1H1(101),G1H1(139)])
call HGT_OLR(G2H4(18),1,1,4)
call HGT_invQ_OLR(G2H4(18),2,5,4)
call HGT_OLR(G2H4(18),6,15,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G1H4(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(28),[G2H1(35),G2H1(18),G2H1(15),G2H1(14),G2H1(30) &
    ,G2H1(20),G1H1(25),G1H1(33),G1H1(49),G1H1(35)])
call HGT_w2_OLR(G1H2(91),1,1,2)
call HGT_w2_invQ_OLR(G1H2(91),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(91),[G1H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(30),[G2H2(92),G2H2(72)])
call HGT_w2_OLR(G1H2(20),1,1,2)
call HGT_w2_invQ_OLR(G1H2(20),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(20),[G1H2(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(31),[G2H2(96),G2H2(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G1H4(108),G1H4(3)])
call HGT_w2_OLR(G1H4(26),1,1,4)
call HGT_w2_invQ_OLR(G1H4(26),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G1H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(24),[G1H1(111),G1H1(32)])
call HGT_w2_OLR(G1H1(1),1,1,1)
call HGT_w2_invQ_OLR(G1H1(1),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(24),[G1H1(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(39),[G2H1(5),G2H1(22),G2H1(17),G2H1(25),G2H1(40),G2H1(34) &
    ,G1H1(19),G1H1(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(41),[G2H1(36),G2H1(21),G2H1(27),G2H1(13),G2H1(43) &
    ,G2H1(37),G1H1(75),G1H1(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(8),[G1H1(104)])
call HGT_OLR(G2H1(45),1,1,1)
call HGT_invQ_OLR(G2H1(45),2,5,1)
call HGT_OLR(G2H1(45),6,15,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(45),[G2H1(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G1H4(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(6),[G1H1(64)])
call HGT_OLR(G2H1(46),1,1,1)
call HGT_invQ_OLR(G2H1(46),2,5,1)
call HGT_OLR(G2H1(46),6,15,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(46),[G2H1(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(43),[G1H4(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(126),[G1H4(88)])
call HGT_w2_OLR(G1H4(75),1,1,4)
call HGT_w2_invQ_OLR(G1H4(75),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(75),[G1H4(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(115),[G1H4(99)])
call HGT_w2_OLR(G1H4(63),1,1,4)
call HGT_w2_invQ_OLR(G1H4(63),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(63),[G1H4(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G1H4(61)])
call HGT_w2_OLR(G1H4(77),1,1,4)
call HGT_w2_invQ_OLR(G1H4(77),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(77),[G1H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(107),[G2H2(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(91),[G1H4(127)])
call HGT_w2_OLR(G1H4(44),1,1,4)
call HGT_w2_invQ_OLR(G1H4(44),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(44),[G1H4(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(49),[G1H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(84),[G1H4(39),G1H4(67),G1H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(65),[G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(50),[G1H2(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1),[G1H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(78),[G1H1(79),G1H1(81),G1H1(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(66),[G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(119),[G1H2(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(61),[G1H2(96),G1H2(81)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(48),[G1H2(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(84),[G1H2(101),G1H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(129),[G1H4(56),G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(138),[G1H4(83),G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G1H4(47),G1H4(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(23),[G1H1(84),G1H1(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(79),[G1H2(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(46),[G1H2(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(141),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(31),[G1H4(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(106),[G1H4(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(29),[G1H4(14),G1H4(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(21),[G1H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(82),[G1H4(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(55),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(23),[G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(36),[G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G1H4(133),G1H4(123)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(37),[G1H4(128)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(74),[G1H4(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(1),[G1H1(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(31),[G1H1(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(40),[G1H4(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(19),[G1H4(139)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G2H2(27)])
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(85),ex2(:),G2tensor(2),m3h2x1(:,277),heltab2x2(:,:,316))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(67),ex2(:),G2tensor(161),m3h2x1(:,278),heltab2x2(:,:,317))
  call Hloop_QS_A(ntryL,G1H1(71),ex5(:),G1H1(108),ngH,m3h1x1(:,162),heltab2x1(:,:,162))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(108),63,nMT,G2tensor(7),n2h1(468))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(52),ex2(:),G2tensor(3),m3h2x1(:,279),heltab2x2(:,:,318))
  call Hloop_QV_A(ntryL,G1H4(12),wf4(:,2),G1H1(8),m3h4x1(:,162),heltab2x4(:,:,379))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),63,nMT,G2tensor(5),n2h1(469))
  call Hloop_AS_Q(ntryL,G1H1(117),ex5(:),G1H1(90),ngH,m3h1x1(:,163),heltab2x1(:,:,163))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(90),63,nMT,G2tensor(11),n2h1(470))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(61),ex1(:),G2tensor(157),m3h2x1(:,280),heltab2x2(:,:,319))
  call Hloop_QS_A(ntryL,G1H1(43),ex5(:),G1H1(16),ngH,m3h1x1(:,164),heltab2x1(:,:,164))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(16),63,nMT,G2tensor(56),n2h1(471))
  call Hloop_QS_A(ntryL,G2H1(9),ex5(:),G2H1(7),ngH,m3h1x1(:,165),heltab2x1(:,:,165))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(7),63,nMT,G3tensor(13),n2h1(472))
  call Hloop_QV_A(ntryL,G2H4(10),wf4(:,2),G2H1(42),m3h4x1(:,163),heltab2x4(:,:,380))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(42),63,nMT,G3tensor(14),n2h1(473))
  call Hloop_AS_Q(ntryL,G2H1(10),ex5(:),G2H1(44),ngH,m3h1x1(:,166),heltab2x1(:,:,166))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(44),63,nMT,G3tensor(15),n2h1(474))
  call Hloop_AV_Q(ntryL,G2H4(22),wf4(:,2),G2H1(16),m3h4x1(:,164),heltab2x4(:,:,381))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(16),63,nMT,G3tensor(16),n2h1(475))
  call Hloop_AV_Q(ntryL,G2H4(7),wf4(:,2),G2H1(19),m3h4x1(:,165),heltab2x4(:,:,382))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(19),63,nMT,G3tensor(17),n2h1(476))
  call Hloop_AS_Q(ntryL,G2H1(38),ex5(:),G2H1(29),ngH,m3h1x1(:,167),heltab2x1(:,:,167))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(29),63,nMT,G3tensor(18),n2h1(477))
  call Hloop_QV_A(ntryL,G2H4(18),wf4(:,2),G2H1(4),m3h4x1(:,166),heltab2x4(:,:,383))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(4),63,nMT,G3tensor(19),n2h1(478))
  call Hloop_QS_A(ntryL,G2H1(28),ex5(:),G2H1(2),ngH,m3h1x1(:,168),heltab2x1(:,:,168))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(2),63,nMT,G3tensor(20),n2h1(479))
  call Hloop_VA_Q(ntryL,G1H2(91),ex2(:),G1H1(123),m3h2x1(:,281),heltab2x2(:,:,320))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(123),63,nMT,G2tensor(18),n2h1(480))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(30),wf2(:,2),G2tensor(13),m3h2x1(:,282),heltab2x2(:,:,321))
  call Hloop_VQ_A(ntryL,G1H2(20),ex1(:),G1H1(140),m3h2x1(:,283),heltab2x2(:,:,322))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(140),63,nMT,G2tensor(17),n2h1(481))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(31),wf2(:,4),G2tensor(22),m3h2x1(:,284),heltab2x2(:,:,323))
  call Hloop_QV_A(ntryL,G2H4(5),wf4(:,2),G2H1(33),m3h4x1(:,167),heltab2x4(:,:,384))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(33),63,nMT,G3tensor(21),n2h1(482))
  call Hloop_QS_A(ntryL,G2H1(24),ex5(:),G2H1(3),ngH,m3h1x1(:,169),heltab2x1(:,:,169))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(3),63,nMT,G3tensor(22),n2h1(483))
call HGT_OLR(G2H4(3),1,1,4)
call HGT_invQ_OLR(G2H4(3),2,5,4)
call HGT_OLR(G2H4(3),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(3),wf4(:,16),G2H1(11),m3h4x1(:,168),heltab2x4(:,:,385))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(11),63,nMT,G3tensor(23),n2h1(484))
call HGT_OLR(G2H4(27),1,1,4)
call HGT_invQ_OLR(G2H4(27),2,5,4)
call HGT_OLR(G2H4(27),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(27),wf4(:,16),G2H1(32),m3h4x1(:,169),heltab2x4(:,:,386))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(32),63,nMT,G3tensor(24),n2h1(485))
call HGT_OLR(G2H4(28),1,1,4)
call HGT_invQ_OLR(G2H4(28),2,5,4)
call HGT_OLR(G2H4(28),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(28),wf4(:,16),G2H1(26),m3h4x1(:,170),heltab2x4(:,:,387))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(26),63,nMB,G3tensor(25),n2h1(486))
  call Hloop_AS_Q(ntryL,G2H1(39),ex5(:),G2H1(12),ngH,m3h1x1(:,170),heltab2x1(:,:,170))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(12),63,nMB,G3tensor(26),n2h1(487))
call HGT_OLR(G2H4(16),1,1,4)
call HGT_invQ_OLR(G2H4(16),2,5,4)
call HGT_OLR(G2H4(16),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(16),wf4(:,16),G2H1(35),m3h4x1(:,171),heltab2x4(:,:,388))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(35),63,nMB,G3tensor(27),n2h1(488))
  call Hloop_QS_A(ntryL,G2H1(41),ex5(:),G2H1(18),ngH,m3h1x1(:,171),heltab2x1(:,:,171))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(18),63,nMB,G3tensor(28),n2h1(489))
call HGT_OLR(G2H4(25),1,1,4)
call HGT_invQ_OLR(G2H4(25),2,5,4)
call HGT_OLR(G2H4(25),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(25),wf4(:,2),G2H1(15),m3h4x1(:,172),heltab2x4(:,:,389))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(15),63,nMB,G3tensor(29),n2h1(490))
call HGT_OLR(G2H4(4),1,1,4)
call HGT_invQ_OLR(G2H4(4),2,5,4)
call HGT_OLR(G2H4(4),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(4),wf4(:,2),G2H1(14),m3h4x1(:,173),heltab2x4(:,:,390))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(14),63,nMB,G3tensor(30),n2h1(491))
  call Hloop_QS_A(ntryL,G2H1(45),ex5(:),G2H1(30),ngH,m3h1x1(:,172),heltab2x1(:,:,172))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(30),63,nMB,G3tensor(31),n2h1(492))
  call Hloop_QV_A(ntryL,G2H4(1),wf4(:,2),G2H1(20),m3h4x1(:,174),heltab2x4(:,:,391))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(20),63,nMB,G3tensor(32),n2h1(493))
  call Hloop_AS_Q(ntryL,G2H1(46),ex5(:),G2H1(5),ngH,m3h1x1(:,173),heltab2x1(:,:,173))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(5),63,nMB,G3tensor(33),n2h1(494))
  call Hloop_AV_Q(ntryL,G2H4(43),wf4(:,2),G2H1(22),m3h4x1(:,175),heltab2x4(:,:,392))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(22),63,nMB,G3tensor(34),n2h1(495))
  call Hloop_AV_Q(ntryL,G1H4(75),wf4(:,2),G1H1(22),m3h4x1(:,176),heltab2x4(:,:,393))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(22),63,nMT,G2tensor(20),n2h1(496))
  call Hloop_QV_A(ntryL,G1H4(63),wf4(:,2),G1H1(18),m3h4x1(:,177),heltab2x4(:,:,394))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(18),63,nMT,G2tensor(26),n2h1(497))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(11),wf8(:,7),G2tensor(24),m3h8x1(:,11),heltab2x8(:,:,226))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(8),wf8(:,4),G2tensor(60),m3h8x1(:,12),heltab2x8(:,:,227))
  call Hloop_QV_A(ntryL,G1H4(77),wf4(:,4),G1H1(2),m3h4x1(:,178),heltab2x4(:,:,395))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(2),63,0,G2tensor(28),n2h1(498))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(107),ex4(:),G2tensor(63),m3h2x1(:,285),heltab2x2(:,:,324))
  call Hloop_QV_A(ntryL,G1H4(44),wf4(:,8),G1H1(83),m3h4x1(:,179),heltab2x4(:,:,396))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(83),63,0,G2tensor(30),n2h1(499))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(49),51,wf4(:,2),12,G2tensor(36),m3h4x1(:,180),heltab2x4(:,:,397))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(84),51,wf4(:,2),12,G2tensor(32),m3h4x1(:,181),heltab2x4(:,:,398))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(65),51,wf4(:,2),12,G2tensor(38),m3h4x1(:,182),heltab2x4(:,:,399))
  call Hloop_VQ_A(ntryL,G1H2(50),ex1(:),G1H1(29),m3h2x1(:,286),heltab2x2(:,:,325))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(29),63,nMT,G2tensor(34),n2h1(500))
  call Hloop_VA_Q(ntryL,G1H2(1),ex2(:),G1H1(37),m3h2x1(:,287),heltab2x2(:,:,326))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(37),63,nMT,G2tensor(44),n2h1(501))
  call Hloop_AS_Q(ntryL,G1H1(78),ex5(:),G1H1(119),ngH,m3h1x1(:,174),heltab2x1(:,:,174))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(119),63,nMT,G2tensor(40),n2h1(502))
  call Hloop_VQ_A(ntryL,G1H2(41),ex1(:),G1H1(61),m3h2x1(:,288),heltab2x2(:,:,327))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(61),63,nMT,G2tensor(46),n2h1(503))
  call Hloop_AV_Q(ntryL,G1H4(66),wf4(:,2),G1H1(91),m3h4x1(:,183),heltab2x4(:,:,400))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(91),63,nMT,G2tensor(42),n2h1(504))
  call Hloop_VA_Q(ntryL,G1H2(49),ex2(:),G1H1(10),m3h2x1(:,289),heltab2x2(:,:,328))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(10),63,nMT,G2tensor(388),n2h1(505))
  call Hloop_VA_Q(ntryL,G1H2(85),ex4(:),G1H1(107),m3h2x1(:,290),heltab2x2(:,:,329))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(107),63,0,G2tensor(379),n2h1(506))
  call Hloop_VA_Q(ntryL,G1H2(75),ex4(:),G1H1(66),m3h2x1(:,291),heltab2x2(:,:,330))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(66),63,0,G2tensor(376),n2h1(507))
  call Hloop_VQ_A(ntryL,G1H2(119),wf2(:,2),G1H1(54),m3h2x1(:,292),heltab2x2(:,:,331))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(54),63,nMT,G2tensor(52),n2h1(508))
  call Hloop_VQ_A(ntryL,G1H2(61),wf2(:,2),G1H1(86),m3h2x1(:,293),heltab2x2(:,:,332))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(86),63,nMT,G2tensor(48),n2h1(509))
  call Hloop_VA_Q(ntryL,G1H2(48),wf2(:,4),G1H1(130),m3h2x1(:,294),heltab2x2(:,:,333))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(130),63,nMT,G2tensor(382),n2h1(510))
  call Hloop_VA_Q(ntryL,G1H2(84),wf2(:,4),G1H1(12),m3h2x1(:,295),heltab2x2(:,:,334))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(12),63,nMT,G2tensor(373),n2h1(511))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(129),51,wf4(:,2),12,G2tensor(370),m3h4x1(:,184),heltab2x4(:,:,401))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(138),51,wf4(:,2),12,G2tensor(54),m3h4x1(:,185),heltab2x4(:,:,402))
  call Hloop_AV_Q(ntryL,G2H4(14),wf4(:,2),G2H1(17),m3h4x1(:,186),heltab2x4(:,:,403))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(17),63,nMT,G3tensor(35),n2h1(512))
  call Hloop_AS_Q(ntryL,G2H1(23),ex5(:),G2H1(25),ngH,m3h1x1(:,175),heltab2x1(:,:,175))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(25),63,nMT,G3tensor(36),n2h1(513))
  call Hloop_VQ_A(ntryL,G1H2(79),wf2(:,2),G1H1(95),m3h2x1(:,296),heltab2x2(:,:,335))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(95),63,nMT,G2tensor(50),n2h1(514))
  call Hloop_VA_Q(ntryL,G1H2(46),wf2(:,4),G1H1(20),m3h2x1(:,297),heltab2x2(:,:,336))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(20),63,nMT,G2tensor(58),n2h1(515))
  call Hloop_AV_Q(ntryL,G1H4(141),wf4(:,4),G1H1(137),m3h4x1(:,187),heltab2x4(:,:,404))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(137),63,0,G2tensor(147),n2h1(516))
  call Hloop_AV_Q(ntryL,G2H4(31),wf4(:,4),G2H1(40),m3h4x1(:,188),heltab2x4(:,:,405))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(40),63,0,G3tensor(37),n2h1(517))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(106),44,wf4(:,4),19,G2tensor(66),m3h4x1(:,189),heltab2x4(:,:,406))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(29),44,wf4(:,4),19,G3tensor(38),m3h4x1(:,190),heltab2x4(:,:,407))
  call Hloop_QV_A(ntryL,G2H4(21),wf4(:,4),G2H1(34),m3h4x1(:,191),heltab2x4(:,:,408))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(34),63,0,G3tensor(39),n2h1(518))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(82),44,wf4(:,4),19,G2tensor(67),m3h4x1(:,192),heltab2x4(:,:,409))
  call Hloop_AV_Q(ntryL,G1H4(55),wf4(:,8),G1H1(48),m3h4x1(:,193),heltab2x4(:,:,410))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(48),63,0,G2tensor(70),n2h1(519))
  call Hloop_AV_Q(ntryL,G2H4(23),wf4(:,8),G2H1(36),m3h4x1(:,194),heltab2x4(:,:,411))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(36),63,0,G3tensor(40),n2h1(520))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(36),44,wf4(:,8),19,G2tensor(150),m3h4x1(:,195),heltab2x4(:,:,412))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H4(8),44,wf4(:,8),19,G3tensor(41),m3h4x1(:,196),heltab2x4(:,:,413))
  call Hloop_QV_A(ntryL,G2H4(37),wf4(:,8),G2H1(21),m3h4x1(:,197),heltab2x4(:,:,414))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(21),63,0,G3tensor(42),n2h1(521))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(74),44,wf4(:,8),19,G2tensor(72),m3h4x1(:,198),heltab2x4(:,:,415))
  call Hloop_AS_Q(ntryL,G2H1(1),ex5(:),G2H1(27),ngH,m3h1x1(:,176),heltab2x1(:,:,176))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(27),63,nMB,G3tensor(43),n2h1(522))
  call Hloop_QS_A(ntryL,G2H1(31),ex5(:),G2H1(13),ngH,m3h1x1(:,177),heltab2x1(:,:,177))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(13),63,nMB,G3tensor(44),n2h1(523))
  call Hloop_QV_A(ntryL,G2H4(40),wf4(:,2),G2H1(43),m3h4x1(:,199),heltab2x4(:,:,416))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(43),63,nMB,G3tensor(45),n2h1(524))
  call Hloop_AV_Q(ntryL,G2H4(19),wf4(:,2),G2H1(37),m3h4x1(:,200),heltab2x4(:,:,417))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(37),63,nMB,G3tensor(46),n2h1(525))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(4),ex2(:),G2tensor(73),m3h2x1(:,298),heltab2x2(:,:,337))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(17),ex2(:),G2tensor(76),m3h2x1(:,299),heltab2x2(:,:,338))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(20),ex1(:),G2tensor(144),m3h2x1(:,300),heltab2x2(:,:,339))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(24),wf2(:,2),G2tensor(78),m3h2x1(:,301),heltab2x2(:,:,340))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(2),wf2(:,4),G2tensor(79),m3h2x1(:,302),heltab2x2(:,:,341))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(7),wf2(:,2),G2tensor(82),m3h2x1(:,303),heltab2x2(:,:,342))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(14),wf2(:,4),G2tensor(153),m3h2x1(:,304),heltab2x2(:,:,343))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(12),wf8(:,7),G2tensor(84),m3h8x1(:,13),heltab2x8(:,:,228))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(15),wf8(:,4),G2tensor(85),m3h8x1(:,14),heltab2x8(:,:,229))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(28),ex4(:),G2tensor(88),m3h2x1(:,305),heltab2x2(:,:,344))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(29),ex4(:),G2tensor(160),m3h2x1(:,306),heltab2x2(:,:,345))
  call Hloop_QV_A(ntryL,G2H4(38),wf4(:,4),G2H1(8),m3h4x1(:,201),heltab2x4(:,:,418))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(8),63,nMT,G3tensor(47),n2h1(526))
  call Hloop_AV_Q(ntryL,G2H4(20),wf4(:,4),G2H1(6),m3h4x1(:,202),heltab2x4(:,:,419))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(6),63,nMT,G3tensor(48),n2h1(527))
  call Hloop_QV_A(ntryL,G2H4(9),wf4(:,4),G2H1(9),m3h4x1(:,203),heltab2x4(:,:,420))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(9),63,nMB,G3tensor(49),n2h1(528))
  call Hloop_AV_Q(ntryL,G2H4(12),wf4(:,4),G2H1(7),m3h4x1(:,204),heltab2x4(:,:,421))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(7),63,nMB,G3tensor(50),n2h1(529))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(33),44,wf4(:,4),19,G3tensor(51),m3h4x1(:,205),heltab2x4(:,:,422))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(36),44,wf4(:,4),G3tensor(52),m3h4x1(:,206),heltab2x4(:,:,423))
  call Hloop_VQ_A(ntryL,G1H8(22),wf8(:,35),G1H1(46),m3h8x1(:,15),heltab2x8(:,:,230))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(46),63,nMT,G2tensor(93),n2h1(530))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(16),wf8(:,35),G2tensor(90),m3h8x1(:,16),heltab2x8(:,:,231))
  call Hloop_QV_A(ntryL,G2H4(34),wf4(:,8),G2H1(42),m3h4x1(:,207),heltab2x4(:,:,424))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(42),63,nMT,G3tensor(53),n2h1(531))
  call Hloop_AV_Q(ntryL,G2H4(13),wf4(:,8),G2H1(10),m3h4x1(:,208),heltab2x4(:,:,425))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(10),63,nMT,G3tensor(54),n2h1(532))
  call Hloop_QV_A(ntryL,G2H4(35),wf4(:,8),G2H1(44),m3h4x1(:,209),heltab2x4(:,:,426))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(44),63,nMB,G3tensor(55),n2h1(533))
  call Hloop_AV_Q(ntryL,G2H4(26),wf4(:,8),G2H1(16),m3h4x1(:,210),heltab2x4(:,:,427))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(16),63,nMB,G3tensor(56),n2h1(534))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H4(15),44,wf4(:,8),19,G3tensor(57),m3h4x1(:,211),heltab2x4(:,:,428))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H4(2),44,wf4(:,8),G3tensor(58),m3h4x1(:,212),heltab2x4(:,:,429))
  call Hloop_VA_Q(ntryL,G1H8(21),wf8(:,40),G1H1(53),m3h8x1(:,17),heltab2x8(:,:,232))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(53),63,nMT,G2tensor(156),n2h1(535))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(17),wf8(:,40),G2tensor(99),m3h8x1(:,18),heltab2x8(:,:,233))
  call Hloop_VQ_A(ntryL,G1H8(33),wf8(:,47),G1H1(15),m3h8x1(:,19),heltab2x8(:,:,234))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(15),63,nMT,G2tensor(96),n2h1(536))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(18),wf8(:,47),G2tensor(102),m3h8x1(:,20),heltab2x8(:,:,235))
  call Hloop_VA_Q(ntryL,G1H8(12),wf8(:,49),G1H1(127),m3h8x1(:,21),heltab2x8(:,:,236))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(127),63,nMT,G2tensor(105),n2h1(537))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(19),wf8(:,49),G2tensor(108),m3h8x1(:,22),heltab2x8(:,:,237))
  call Hloop_VA_Q(ntryL,G1H2(89),ex4(:),G1H1(6),m3h2x1(:,307),heltab2x2(:,:,346))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(6),63,0,G2tensor(111),n2h1(538))
  call Hloop_VQ_A(ntryL,G1H8(36),wf8(:,51),G1H1(138),m3h8x1(:,23),heltab2x8(:,:,238))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(138),63,0,G2tensor(114),n2h1(539))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(20),wf8(:,51),G2tensor(115),m3h8x1(:,24),heltab2x8(:,:,239))
  call Hloop_VA_Q(ntryL,G1H8(37),wf8(:,53),G1H1(59),m3h8x1(:,25),heltab2x8(:,:,240))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(59),63,0,G2tensor(117),n2h1(540))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(2),wf8(:,53),G2tensor(118),m3h8x1(:,26),heltab2x8(:,:,241))
  call Hloop_VQ_A(ntryL,G1H8(18),wf8(:,57),G1H1(34),m3h8x1(:,27),heltab2x8(:,:,242))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(34),63,0,G2tensor(120),n2h1(541))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(10),wf8(:,57),G2tensor(121),m3h8x1(:,28),heltab2x8(:,:,243))
  call Hloop_VA_Q(ntryL,G1H8(1),wf8(:,59),G1H1(100),m3h8x1(:,29),heltab2x8(:,:,244))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(100),63,0,G2tensor(123),n2h1(542))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(14),wf8(:,59),G2tensor(124),m3h8x1(:,30),heltab2x8(:,:,245))
  call ol_merge_tensors(G2tensor(7),[G2tensor(308),G2tensor(116),G2tensor(158),G1tensor(662),G1tensor(598),G1tensor(553) &
    ,G1tensor(543),G1tensor(285),G1tensor(167),G1tensor(186),G1tensor(157),G1tensor(127),G1tensor(97),G0tensor(668),G0tensor(604) &
    ,G0tensor(559),G0tensor(549),G0tensor(364),G0tensor(314),G0tensor(168),G0tensor(33),G0tensor(28),G0tensor(23)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(350),G2tensor(162),G1tensor(712),G1tensor(583),G1tensor(573),G1tensor(568) &
    ,G1tensor(297),G1tensor(225),G1tensor(176),G1tensor(67),G1tensor(23),G1tensor(37),G0tensor(718),G0tensor(589),G0tensor(579) &
    ,G0tensor(574),G0tensor(369),G0tensor(334),G0tensor(163),G0tensor(18),G0tensor(13),G0tensor(8)])
  call ol_merge_tensors(G2tensor(370),[G2tensor(329),G2tensor(266),G2tensor(163),G1tensor(28),G1tensor(7),G1tensor(11) &
    ,G1tensor(108),G1tensor(96),G1tensor(373),G0tensor(238),G0tensor(233),G0tensor(136),G0tensor(106),G0tensor(74),G0tensor(69)])
  call ol_merge_tensors(G2tensor(54),[G2tensor(332),G2tensor(272),G2tensor(164),G1tensor(148),G1tensor(71),G1tensor(24) &
    ,G1tensor(212),G1tensor(343),G1tensor(313),G0tensor(268),G0tensor(263),G0tensor(151),G0tensor(121),G0tensor(64) &
    ,G0tensor(59)])
  call ol_merge_tensors(G2tensor(46),[G2tensor(305),G2tensor(278),G2tensor(188),G2tensor(168),G1tensor(263),G1tensor(358) &
    ,G1tensor(179),G1tensor(173),G0tensor(358),G0tensor(324),G0tensor(318),G0tensor(313)])
  call ol_merge_tensors(G2tensor(76),[G2tensor(365),G2tensor(284),G2tensor(172),G1tensor(673),G1tensor(668),G1tensor(214) &
    ,G1tensor(197),G0tensor(679),G0tensor(674),G0tensor(328),G0tensor(323)])
  call ol_merge_tensors(G2tensor(388),[G2tensor(296),G2tensor(290),G2tensor(180),G2tensor(176),G1tensor(239),G1tensor(232) &
    ,G1tensor(220),G1tensor(209),G0tensor(349),G0tensor(343),G0tensor(338),G0tensor(333)])
  call ol_merge_tensors(G2tensor(368),[G2tensor(299),G2tensor(184),G1tensor(255),G1tensor(275),G0tensor(353),G0tensor(348)])
  call ol_merge_tensors(G2tensor(312),[G2tensor(309),G2tensor(119),G2tensor(62),G1tensor(685),G1tensor(677),G1tensor(665) &
    ,G1tensor(244),G0tensor(691),G0tensor(683),G0tensor(671),G0tensor(319)])
  call ol_merge_tensors(G2tensor(108),[G2tensor(99),G2tensor(261),G2tensor(256),G2tensor(252),G2tensor(189),G2tensor(113) &
    ,G1tensor(680),G1tensor(515),G1tensor(480),G1tensor(120),G1tensor(235),G1tensor(145),G0tensor(686),G0tensor(521),G0tensor(486) &
    ,G0tensor(91),G0tensor(46),G0tensor(31)])
  call ol_merge_tensors(G2tensor(26),[G2tensor(311),G2tensor(68),G1tensor(682),G1tensor(274),G1tensor(60),G0tensor(688) &
    ,G0tensor(359),G0tensor(88)])
  call ol_merge_tensors(G2tensor(85),[G2tensor(336),G2tensor(221),G2tensor(181),G1tensor(670),G1tensor(505),G1tensor(470) &
    ,G1tensor(62),G1tensor(133),G0tensor(676),G0tensor(511),G0tensor(476),G0tensor(71),G0tensor(29)])
  call ol_merge_tensors(G2tensor(60),[G2tensor(339),G2tensor(222),G2tensor(185),G1tensor(675),G1tensor(510),G1tensor(475) &
    ,G1tensor(92),G1tensor(139),G0tensor(681),G0tensor(516),G0tensor(481),G0tensor(76),G0tensor(30)])
  call ol_merge_tensors(G2tensor(84),[G2tensor(342),G2tensor(190),G1tensor(430),G1tensor(390),G1tensor(325),G1tensor(35) &
    ,G0tensor(436),G0tensor(396),G0tensor(61),G0tensor(14)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(345),G2tensor(191),G1tensor(440),G1tensor(400),G1tensor(355),G1tensor(42) &
    ,G0tensor(446),G0tensor(406),G0tensor(66),G0tensor(15)])
  call ol_merge_tensors(G2tensor(102),[G2tensor(90),G2tensor(264),G2tensor(254),G2tensor(250),G2tensor(192),G1tensor(759) &
    ,G1tensor(445),G1tensor(405),G1tensor(205),G1tensor(51),G0tensor(741),G0tensor(451),G0tensor(411),G0tensor(41),G0tensor(16)])
  call ol_merge_tensors(G2tensor(52),[G2tensor(318),G2tensor(193),G1tensor(545),G1tensor(116),G1tensor(45),G1tensor(354) &
    ,G0tensor(551),G0tensor(280),G0tensor(239),G0tensor(220)])
  call ol_merge_tensors(G2tensor(48),[G2tensor(321),G2tensor(194),G1tensor(555),G1tensor(383),G1tensor(159),G1tensor(29) &
    ,G1tensor(380),G0tensor(561),G0tensor(330),G0tensor(290),G0tensor(240),G0tensor(230)])
  call ol_merge_tensors(G2tensor(96),[G2tensor(93),G2tensor(330),G2tensor(282),G2tensor(270),G2tensor(199),G2tensor(195) &
    ,G1tensor(705),G1tensor(565),G1tensor(196),G1tensor(52),G1tensor(22),G1tensor(192),G0tensor(711),G0tensor(571),G0tensor(321) &
    ,G0tensor(241),G0tensor(146),G0tensor(116)])
  call ol_merge_tensors(G2tensor(382),[G2tensor(324),G2tensor(196),G1tensor(575),G1tensor(136),G1tensor(142),G1tensor(59) &
    ,G0tensor(581),G0tensor(300),G0tensor(269),G0tensor(250)])
  call ol_merge_tensors(G2tensor(373),[G2tensor(327),G2tensor(197),G1tensor(585),G1tensor(256),G1tensor(161),G1tensor(88) &
    ,G1tensor(70),G0tensor(591),G0tensor(355),G0tensor(310),G0tensor(270),G0tensor(260)])
  call ol_merge_tensors(G2tensor(105),[G2tensor(156),G2tensor(333),G2tensor(294),G2tensor(276),G2tensor(202),G2tensor(198) &
    ,G1tensor(720),G1tensor(595),G1tensor(376),G1tensor(82),G1tensor(25),G1tensor(330),G0tensor(726),G0tensor(601),G0tensor(341) &
    ,G0tensor(271),G0tensor(161),G0tensor(131)])
  call ol_merge_tensors(G3tensor(6),[G3tensor(4),G3tensor(3),G3tensor(1),G2tensor(363),G2tensor(360),G2tensor(354),G2tensor(348) &
    ,G1tensor(730),G1tensor(700),G1tensor(221),G1tensor(207),G0tensor(736),G0tensor(706),G0tensor(340),G0tensor(320)])
  call ol_merge_tensors(G2tensor(50),[G2tensor(281),G2tensor(279),G2tensor(200),G1tensor(702),G1tensor(203),G1tensor(178) &
    ,G0tensor(708),G0tensor(329),G0tensor(316)])
  call ol_merge_tensors(G3tensor(54),[G3tensor(53),G3tensor(48),G3tensor(47),G3tensor(5),G3tensor(2),G2tensor(369),G2tensor(366) &
    ,G2tensor(303),G2tensor(288),G1tensor(710),G1tensor(251),G1tensor(257),G0tensor(716),G0tensor(356),G0tensor(331)])
  call ol_merge_tensors(G2tensor(357),[G2tensor(351),G2tensor(203),G2tensor(201),G1tensor(725),G1tensor(715),G1tensor(237) &
    ,G0tensor(731),G0tensor(721),G0tensor(339)])
  call ol_merge_tensors(G2tensor(58),[G2tensor(293),G2tensor(291),G2tensor(204),G1tensor(717),G1tensor(245),G1tensor(262) &
    ,G0tensor(723),G0tensor(354),G0tensor(336)])
  call ol_merge_tensors(G2tensor(153),[G2tensor(223),G1tensor(690),G1tensor(341),G0tensor(696),G0tensor(89)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(224),G1tensor(695),G1tensor(659),G1tensor(649),G1tensor(644),G1tensor(150) &
    ,G0tensor(701),G0tensor(665),G0tensor(655),G0tensor(650),G0tensor(90)])
  call ol_merge_tensors(G2tensor(79),[G2tensor(260),G2tensor(226),G1tensor(653),G1tensor(643),G1tensor(492),G1tensor(457) &
    ,G1tensor(50),G1tensor(253),G1tensor(217),G0tensor(659),G0tensor(649),G0tensor(498),G0tensor(463),G0tensor(171),G0tensor(49) &
    ,G0tensor(43)])
  call ol_merge_tensors(G2tensor(78),[G2tensor(263),G2tensor(229),G1tensor(633),G1tensor(623),G1tensor(417),G1tensor(353) &
    ,G1tensor(182),G1tensor(283),G1tensor(187),G0tensor(639),G0tensor(629),G0tensor(423),G0tensor(383),G0tensor(166),G0tensor(54) &
    ,G0tensor(38)])
  call ol_merge_tensors(G3tensor(58),[G3tensor(57),G3tensor(52),G3tensor(51),G3tensor(42),G3tensor(41),G3tensor(40),G3tensor(39) &
    ,G3tensor(38),G3tensor(37),G2tensor(238),G2tensor(236),G1tensor(645),G1tensor(625),G1tensor(132),G1tensor(342),G0tensor(651) &
    ,G0tensor(631),G0tensor(85),G0tensor(80)])
  call ol_merge_tensors(G3tensor(56),[G3tensor(55),G3tensor(50),G3tensor(49),G3tensor(8),G3tensor(7),G2tensor(399),G2tensor(396) &
    ,G1tensor(764),G0tensor(746)])
  call ol_merge_tensors(G3tensor(12),[G3tensor(11),G3tensor(10),G3tensor(9),G2tensor(411),G2tensor(408),G2tensor(405) &
    ,G2tensor(402),G1tensor(774),G1tensor(769),G0tensor(756),G0tensor(751)])
  call ol_merge_tensors(G2tensor(124),[G2tensor(123),G2tensor(118),G2tensor(117),G2tensor(387),G2tensor(384),G2tensor(375) &
    ,G2tensor(372),G2tensor(315),G2tensor(258),G1tensor(660),G1tensor(640),G1tensor(530),G1tensor(333),G1tensor(328),G1tensor(346) &
    ,G1tensor(188),G1tensor(347),G0tensor(666),G0tensor(646),G0tensor(536),G0tensor(211),G0tensor(191),G0tensor(101),G0tensor(96) &
    ,G0tensor(86)])
  call ol_merge_tensors(G2tensor(306),[G2tensor(269),G2tensor(267),G1tensor(562),G1tensor(286),G1tensor(43),G1tensor(332) &
    ,G1tensor(282),G0tensor(568),G0tensor(361),G0tensor(236),G0tensor(141),G0tensor(111)])
  call ol_merge_tensors(G2tensor(297),[G2tensor(275),G2tensor(273),G1tensor(592),G1tensor(227),G1tensor(93),G1tensor(13) &
    ,G1tensor(46),G0tensor(598),G0tensor(346),G0tensor(266),G0tensor(156),G0tensor(126)])
  call ol_merge_tensors(G3tensor(24),[G3tensor(23),G2tensor(302),G2tensor(300),G2tensor(287),G2tensor(285),G1tensor(707) &
    ,G1tensor(249),G1tensor(208),G0tensor(713),G0tensor(351),G0tensor(326)])
  call ol_merge_tensors(G2tensor(72),[G2tensor(67),G2tensor(30),G2tensor(28),G2tensor(314),G1tensor(527),G1tensor(316),G1tensor(6) &
    ,G1tensor(102),G1tensor(295),G1tensor(265),G0tensor(533),G0tensor(206),G0tensor(186),G0tensor(79),G0tensor(56),G0tensor(51)])
  call ol_merge_tensors(G2tensor(17),[G2tensor(317),G1tensor(642),G1tensor(542),G1tensor(89),G1tensor(267),G1tensor(334) &
    ,G0tensor(648),G0tensor(548),G0tensor(275),G0tensor(234),G0tensor(215)])
  call ol_merge_tensors(G2tensor(34),[G2tensor(320),G1tensor(552),G1tensor(250),G1tensor(107),G1tensor(261),G1tensor(372) &
    ,G0tensor(558),G0tensor(325),G0tensor(285),G0tensor(235),G0tensor(225)])
  call ol_merge_tensors(G2tensor(18),[G2tensor(323),G1tensor(622),G1tensor(572),G1tensor(130),G1tensor(87),G1tensor(63) &
    ,G0tensor(628),G0tensor(578),G0tensor(295),G0tensor(264),G0tensor(245)])
  call ol_merge_tensors(G2tensor(44),[G2tensor(326),G1tensor(582),G1tensor(233),G1tensor(155),G1tensor(76),G1tensor(177) &
    ,G0tensor(588),G0tensor(350),G0tensor(305),G0tensor(265),G0tensor(255)])
  call ol_merge_tensors(G2tensor(73),[G2tensor(335),G1tensor(693),G1tensor(688),G1tensor(482),G1tensor(447),G1tensor(200) &
    ,G1tensor(290),G1tensor(367),G0tensor(699),G0tensor(694),G0tensor(488),G0tensor(453),G0tensor(174),G0tensor(169) &
    ,G0tensor(68)])
  call ol_merge_tensors(G2tensor(3),[G2tensor(338),G1tensor(487),G1tensor(452),G1tensor(284),G1tensor(194),G1tensor(348) &
    ,G0tensor(493),G0tensor(458),G0tensor(184),G0tensor(170),G0tensor(73)])
  call ol_merge_tensors(G2tensor(144),[G2tensor(341),G1tensor(407),G1tensor(303),G1tensor(21),G1tensor(55),G1tensor(307) &
    ,G0tensor(413),G0tensor(373),G0tensor(194),G0tensor(164),G0tensor(58)])
  call ol_merge_tensors(G2tensor(157),[G2tensor(344),G1tensor(412),G1tensor(308),G1tensor(248),G1tensor(180),G1tensor(337) &
    ,G0tensor(418),G0tensor(378),G0tensor(204),G0tensor(165),G0tensor(63)])
  call ol_merge_tensors(G3tensor(15),[G3tensor(13),G2tensor(353),G2tensor(347),G1tensor(708),G1tensor(697),G1tensor(219) &
    ,G1tensor(184),G0tensor(714),G0tensor(703),G0tensor(335),G0tensor(315)])
  call ol_merge_tensors(G2tensor(20),[G2tensor(356),G1tensor(756),G1tensor(722),G1tensor(226),G0tensor(738),G0tensor(728) &
    ,G0tensor(344)])
  call ol_merge_tensors(G3tensor(19),[G3tensor(17),G2tensor(362),G2tensor(359),G1tensor(727),G1tensor(269),G1tensor(238) &
    ,G0tensor(733),G0tensor(360),G0tensor(345)])
  call ol_merge_tensors(G2tensor(111),[G2tensor(160),G2tensor(386),G2tensor(383),G2tensor(374),G2tensor(371),G1tensor(463) &
    ,G1tensor(393),G1tensor(382),G1tensor(110),G1tensor(83),G1tensor(112),G1tensor(54),G1tensor(111),G1tensor(135),G1tensor(126) &
    ,G0tensor(469),G0tensor(399),G0tensor(389),G0tensor(278),G0tensor(273),G0tensor(248),G0tensor(243),G0tensor(134),G0tensor(119) &
    ,G0tensor(83)])
  call ol_merge_tensors(G2tensor(392),[G2tensor(389),G2tensor(380),G2tensor(377),G1tensor(498),G1tensor(433),G1tensor(423) &
    ,G1tensor(131),G1tensor(165),G1tensor(350),G1tensor(266),G1tensor(344),G1tensor(339),G1tensor(122),G0tensor(504),G0tensor(439) &
    ,G0tensor(429),G0tensor(298),G0tensor(293),G0tensor(218),G0tensor(213),G0tensor(149),G0tensor(104),G0tensor(78)])
  call ol_merge_tensors(G2tensor(121),[G2tensor(120),G2tensor(115),G2tensor(114),G2tensor(393),G2tensor(390),G2tensor(381) &
    ,G2tensor(378),G1tensor(650),G1tensor(630),G1tensor(306),G0tensor(656),G0tensor(636),G0tensor(81)])
  call ol_merge_tensors(G3tensor(27),[G3tensor(25),G2tensor(398),G2tensor(395),G1tensor(761),G0tensor(743)])
  call ol_merge_tensors(G3tensor(30),[G3tensor(29),G2tensor(404),G2tensor(401),G1tensor(766),G0tensor(748)])
  call ol_merge_tensors(G3tensor(33),[G3tensor(31),G2tensor(410),G2tensor(407),G1tensor(771),G1tensor(762),G0tensor(753) &
    ,G0tensor(744)])
  call ol_merge_tensors(G1tensor(387),[G1tensor(305),G1tensor(38),G0tensor(393),G0tensor(376),G0tensor(9)])
  call ol_merge_tensors(G1tensor(397),[G1tensor(364),G1tensor(4),G0tensor(403),G0tensor(381),G0tensor(10)])
  call ol_merge_tensors(G1tensor(402),[G1tensor(363),G1tensor(10),G0tensor(408),G0tensor(386),G0tensor(11)])
  call ol_merge_tensors(G1tensor(427),[G1tensor(410),G1tensor(296),G1tensor(73),G0tensor(433),G0tensor(416),G0tensor(199) &
    ,G0tensor(19)])
  call ol_merge_tensors(G1tensor(437),[G1tensor(415),G1tensor(260),G1tensor(79),G0tensor(443),G0tensor(421),G0tensor(209) &
    ,G0tensor(20)])
  call ol_merge_tensors(G1tensor(442),[G1tensor(420),G1tensor(78),G1tensor(85),G0tensor(448),G0tensor(426),G0tensor(99) &
    ,G0tensor(21)])
  call ol_merge_tensors(G1tensor(467),[G1tensor(450),G1tensor(103),G0tensor(473),G0tensor(456),G0tensor(24)])
  call ol_merge_tensors(G1tensor(472),[G1tensor(455),G1tensor(109),G0tensor(478),G0tensor(461),G0tensor(25)])
  call ol_merge_tensors(G1tensor(477),[G1tensor(460),G1tensor(115),G0tensor(483),G0tensor(466),G0tensor(26)])
  call ol_merge_tensors(G1tensor(502),[G1tensor(485),G1tensor(15),G1tensor(163),G0tensor(508),G0tensor(491),G0tensor(179) &
    ,G0tensor(34)])
  call ol_merge_tensors(G1tensor(507),[G1tensor(490),G1tensor(224),G1tensor(169),G0tensor(513),G0tensor(496),G0tensor(189) &
    ,G0tensor(35)])
  call ol_merge_tensors(G1tensor(512),[G1tensor(495),G1tensor(31),G1tensor(175),G0tensor(518),G0tensor(501),G0tensor(94) &
    ,G0tensor(36)])
  call ol_merge_tensors(G2tensor(38),[G1tensor(425),G1tensor(385),G1tensor(319),G1tensor(193),G0tensor(431),G0tensor(391) &
    ,G0tensor(60),G0tensor(39)])
  call ol_merge_tensors(G2tensor(32),[G1tensor(435),G1tensor(395),G1tensor(66),G1tensor(349),G1tensor(229),G1tensor(199) &
    ,G0tensor(441),G0tensor(401),G0tensor(75),G0tensor(65),G0tensor(45),G0tensor(40)])
  call ol_merge_tensors(G2tensor(36),[G1tensor(500),G1tensor(465),G1tensor(379),G1tensor(223),G0tensor(506),G0tensor(471) &
    ,G0tensor(70),G0tensor(44)])
  call ol_merge_tensors(G1tensor(281),[G1tensor(362),G1tensor(20),G1tensor(170),G1tensor(247),G0tensor(363),G0tensor(224) &
    ,G0tensor(214),G0tensor(93),G0tensor(48)])
  call ol_merge_tensors(G1tensor(648),[G1tensor(522),G1tensor(322),G1tensor(259),G0tensor(654),G0tensor(528),G0tensor(176) &
    ,G0tensor(50)])
  call ol_merge_tensors(G1tensor(293),[G1tensor(143),G1tensor(140),G1tensor(345),G1tensor(277),G0tensor(368),G0tensor(304) &
    ,G0tensor(294),G0tensor(98),G0tensor(53)])
  call ol_merge_tensors(G1tensor(628),[G1tensor(537),G1tensor(335),G1tensor(289),G0tensor(634),G0tensor(543),G0tensor(196) &
    ,G0tensor(55)])
  call ol_merge_tensors(G2tensor(150),[G2tensor(70),G2tensor(66),G2tensor(147),G1tensor(655),G1tensor(635),G1tensor(152) &
    ,G0tensor(661),G0tensor(641),G0tensor(84)])
  call ol_merge_tensors(G1tensor(525),[G1tensor(323),G1tensor(279),G0tensor(531),G0tensor(181),G0tensor(95)])
  call ol_merge_tensors(G1tensor(540),[G1tensor(12),G1tensor(41),G0tensor(546),G0tensor(201),G0tensor(100)])
  call ol_merge_tensors(G1tensor(518),[G1tensor(488),G1tensor(483),G1tensor(288),G1tensor(144),G1tensor(48),G0tensor(524) &
    ,G0tensor(494),G0tensor(489),G0tensor(113),G0tensor(108),G0tensor(103)])
  call ol_merge_tensors(G1tensor(508),[G1tensor(503),G1tensor(374),G1tensor(375),G1tensor(138),G0tensor(514),G0tensor(509) &
    ,G0tensor(228),G0tensor(223),G0tensor(105)])
  call ol_merge_tensors(G1tensor(647),[G1tensor(547),G1tensor(270),G1tensor(114),G0tensor(653),G0tensor(553),G0tensor(216) &
    ,G0tensor(109)])
  call ol_merge_tensors(G1tensor(557),[G1tensor(366),G1tensor(294),G0tensor(563),G0tensor(226),G0tensor(110)])
  call ol_merge_tensors(G1tensor(550),[G1tensor(356),G1tensor(312),G0tensor(556),G0tensor(221),G0tensor(114)])
  call ol_merge_tensors(G1tensor(560),[G1tensor(201),G1tensor(174),G0tensor(566),G0tensor(231),G0tensor(115)])
  call ol_merge_tensors(G1tensor(309),[G1tensor(304),G1tensor(5),G1tensor(324),G1tensor(141),G0tensor(379),G0tensor(374) &
    ,G0tensor(128),G0tensor(123),G0tensor(118)])
  call ol_merge_tensors(G1tensor(398),[G1tensor(388),G1tensor(183),G1tensor(65),G1tensor(44),G0tensor(404),G0tensor(394) &
    ,G0tensor(258),G0tensor(253),G0tensor(120)])
  call ol_merge_tensors(G1tensor(637),[G1tensor(577),G1tensor(53),G1tensor(216),G0tensor(643),G0tensor(583),G0tensor(246) &
    ,G0tensor(124)])
  call ol_merge_tensors(G1tensor(587),[G1tensor(74),G1tensor(326),G0tensor(593),G0tensor(256),G0tensor(125)])
  call ol_merge_tensors(G1tensor(580),[G1tensor(64),G1tensor(236),G0tensor(586),G0tensor(251),G0tensor(129)])
  call ol_merge_tensors(G1tensor(590),[G1tensor(189),G1tensor(9),G0tensor(596),G0tensor(261),G0tensor(130)])
  call ol_merge_tensors(G1tensor(453),[G1tensor(448),G1tensor(75),G1tensor(16),G1tensor(314),G0tensor(459),G0tensor(454) &
    ,G0tensor(143),G0tensor(138),G0tensor(133)])
  call ol_merge_tensors(G1tensor(473),[G1tensor(468),G1tensor(125),G1tensor(106),G1tensor(105),G0tensor(479),G0tensor(474) &
    ,G0tensor(288),G0tensor(283),G0tensor(135)])
  call ol_merge_tensors(G1tensor(657),[G1tensor(602),G1tensor(104),G1tensor(318),G0tensor(663),G0tensor(608),G0tensor(276) &
    ,G0tensor(139)])
  call ol_merge_tensors(G1tensor(607),[G1tensor(124),G1tensor(258),G0tensor(613),G0tensor(286),G0tensor(140)])
  call ol_merge_tensors(G1tensor(605),[G1tensor(101),G1tensor(18),G0tensor(611),G0tensor(281),G0tensor(144)])
  call ol_merge_tensors(G1tensor(610),[G1tensor(134),G1tensor(272),G0tensor(616),G0tensor(291),G0tensor(145)])
  call ol_merge_tensors(G1tensor(533),[G1tensor(413),G1tensor(408),G1tensor(19),G1tensor(338),G1tensor(276),G0tensor(539) &
    ,G0tensor(419),G0tensor(414),G0tensor(158),G0tensor(153),G0tensor(148)])
  call ol_merge_tensors(G1tensor(438),[G1tensor(428),G1tensor(160),G1tensor(154),G1tensor(68),G0tensor(444),G0tensor(434) &
    ,G0tensor(308),G0tensor(303),G0tensor(150)])
  call ol_merge_tensors(G1tensor(627),[G1tensor(612),G1tensor(171),G1tensor(128),G0tensor(633),G0tensor(618),G0tensor(296) &
    ,G0tensor(154)])
  call ol_merge_tensors(G1tensor(617),[G1tensor(149),G1tensor(98),G0tensor(623),G0tensor(306),G0tensor(155)])
  call ol_merge_tensors(G1tensor(615),[G1tensor(153),G1tensor(162),G0tensor(621),G0tensor(301),G0tensor(159)])
  call ol_merge_tensors(G1tensor(620),[G1tensor(191),G1tensor(164),G0tensor(626),G0tensor(311),G0tensor(160)])
  call ol_merge_tensors(G1tensor(558),[G1tensor(548),G1tensor(287),G1tensor(206),G1tensor(198),G0tensor(564),G0tensor(554) &
    ,G0tensor(365),G0tensor(178),G0tensor(173)])
  call ol_merge_tensors(G1tensor(517),[G1tensor(218),G1tensor(56),G0tensor(523),G0tensor(185),G0tensor(175)])
  call ol_merge_tensors(G1tensor(520),[G1tensor(33),G1tensor(2),G0tensor(526),G0tensor(190),G0tensor(180)])
  call ol_merge_tensors(G1tensor(298),[G1tensor(378),G1tensor(384),G1tensor(222),G1tensor(210),G0tensor(366),G0tensor(229) &
    ,G0tensor(219),G0tensor(188),G0tensor(183)])
  call ol_merge_tensors(G1tensor(618),[G1tensor(613),G1tensor(299),G1tensor(234),G1tensor(230),G0tensor(624),G0tensor(619) &
    ,G0tensor(370),G0tensor(198),G0tensor(193)])
  call ol_merge_tensors(G1tensor(532),[G1tensor(14),G1tensor(8),G0tensor(538),G0tensor(205),G0tensor(195)])
  call ol_merge_tensors(G1tensor(535),[G1tensor(27),G1tensor(242),G0tensor(541),G0tensor(210),G0tensor(200)])
  call ol_merge_tensors(G1tensor(351),[G1tensor(172),G1tensor(147),G1tensor(278),G1tensor(246),G0tensor(371),G0tensor(309) &
    ,G0tensor(299),G0tensor(208),G0tensor(203)])
  call ol_merge_tensors(G1tensor(632),[G1tensor(567),G1tensor(58),G1tensor(40),G0tensor(638),G0tensor(573),G0tensor(254) &
    ,G0tensor(244)])
  call ol_merge_tensors(G1tensor(570),[G1tensor(80),G1tensor(57),G0tensor(576),G0tensor(259),G0tensor(249)])
  call ol_merge_tensors(G1tensor(652),[G1tensor(597),G1tensor(123),G1tensor(95),G0tensor(658),G0tensor(603),G0tensor(284) &
    ,G0tensor(274)])
  call ol_merge_tensors(G1tensor(600),[G1tensor(119),G1tensor(100),G0tensor(606),G0tensor(289),G0tensor(279)])
  call ol_merge_tensors(G1tensor(369),[G1tensor(377),G1tensor(311),G0tensor(388),G0tensor(384),G0tensor(375)])
  call ol_merge_tensors(G1tensor(459),[G1tensor(454),G1tensor(392),G1tensor(359),G1tensor(310),G0tensor(465),G0tensor(460) &
    ,G0tensor(398),G0tensor(385),G0tensor(380)])
  call ol_merge_tensors(G1tensor(403),[G1tensor(389),G1tensor(370),G0tensor(409),G0tensor(395),G0tensor(390)])
  call ol_merge_tensors(G2tensor(376),[G2tensor(63),G1tensor(539),G1tensor(534),G1tensor(529),G1tensor(524),G1tensor(519) &
    ,G1tensor(479),G1tensor(474),G1tensor(404),G1tensor(399),G1tensor(394),G0tensor(545),G0tensor(540),G0tensor(535),G0tensor(530) &
    ,G0tensor(525),G0tensor(485),G0tensor(480),G0tensor(410),G0tensor(405),G0tensor(400)])
  call ol_merge_tensors(G1tensor(538),[G1tensor(422),G1tensor(418),G1tensor(409),G0tensor(544),G0tensor(428),G0tensor(424) &
    ,G0tensor(415)])
  call ol_merge_tensors(G2tensor(88),[G2tensor(379),G1tensor(528),G1tensor(494),G1tensor(489),G1tensor(432),G1tensor(419) &
    ,G1tensor(414),G0tensor(534),G0tensor(500),G0tensor(495),G0tensor(438),G0tensor(425),G0tensor(420)])
  call ol_merge_tensors(G1tensor(443),[G1tensor(429),G1tensor(424),G0tensor(449),G0tensor(435),G0tensor(430)])
  call ol_merge_tensors(G1tensor(514),[G1tensor(509),G1tensor(444),G1tensor(439),G1tensor(434),G0tensor(520),G0tensor(515) &
    ,G0tensor(450),G0tensor(445),G0tensor(440)])
  call ol_merge_tensors(G1tensor(462),[G1tensor(458),G1tensor(449),G0tensor(468),G0tensor(464),G0tensor(455)])
  call ol_merge_tensors(G1tensor(478),[G1tensor(469),G1tensor(464),G0tensor(484),G0tensor(475),G0tensor(470)])
  call ol_merge_tensors(G1tensor(523),[G1tensor(497),G1tensor(493),G1tensor(484),G0tensor(529),G0tensor(503),G0tensor(499) &
    ,G0tensor(490)])
  call ol_merge_tensors(G1tensor(513),[G1tensor(504),G1tensor(499),G0tensor(519),G0tensor(510),G0tensor(505)])
  call ol_merge_tensors(G2tensor(56),[G1tensor(692),G1tensor(684),G1tensor(604),G1tensor(563),G1tensor(549),G1tensor(544) &
    ,G0tensor(698),G0tensor(690),G0tensor(610),G0tensor(569),G0tensor(555),G0tensor(550)])
  call ol_merge_tensors(G3tensor(20),[G3tensor(18),G1tensor(729),G1tensor(709),G1tensor(619),G1tensor(609),G1tensor(594) &
    ,G1tensor(589),G1tensor(584),G1tensor(564),G1tensor(559),G1tensor(554),G0tensor(735),G0tensor(715),G0tensor(625),G0tensor(615) &
    ,G0tensor(600),G0tensor(595),G0tensor(590),G0tensor(570),G0tensor(565),G0tensor(560)])
  call ol_merge_tensors(G1tensor(588),[G1tensor(578),G1tensor(569),G0tensor(594),G0tensor(584),G0tensor(575)])
  call ol_merge_tensors(G2tensor(40),[G1tensor(724),G1tensor(614),G1tensor(593),G1tensor(579),G1tensor(574),G0tensor(730) &
    ,G0tensor(620),G0tensor(599),G0tensor(585),G0tensor(580)])
  call ol_merge_tensors(G1tensor(608),[G1tensor(603),G1tensor(599),G0tensor(614),G0tensor(609),G0tensor(605)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(758),G1tensor(639),G1tensor(629),G1tensor(624),G0tensor(740),G0tensor(645) &
    ,G0tensor(635),G0tensor(630)])
  call ol_merge_tensors(G1tensor(638),[G1tensor(634),G0tensor(644),G0tensor(640)])
  call ol_merge_tensors(G1tensor(658),[G1tensor(654),G0tensor(664),G0tensor(660)])
  call ol_merge_tensors(G3tensor(35),[G3tensor(21),G1tensor(713),G1tensor(698),G1tensor(667),G1tensor(663),G0tensor(719) &
    ,G0tensor(704),G0tensor(673),G0tensor(669)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(703),G1tensor(672),G1tensor(664),G0tensor(709),G0tensor(678),G0tensor(670)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(689),G1tensor(678),G1tensor(669),G0tensor(695),G0tensor(684),G0tensor(675)])
  call ol_merge_tensors(G2tensor(161),[G1tensor(694),G1tensor(679),G1tensor(674),G0tensor(700),G0tensor(685),G0tensor(680)])
  call ol_merge_tensors(G3tensor(36),[G3tensor(22),G1tensor(728),G1tensor(723),G1tensor(687),G1tensor(683),G0tensor(734) &
    ,G0tensor(729),G0tensor(693),G0tensor(689)])
  call ol_merge_tensors(G3tensor(16),[G3tensor(14),G1tensor(719),G1tensor(704),G1tensor(699),G0tensor(725),G0tensor(710) &
    ,G0tensor(705)])
  call ol_merge_tensors(G2tensor(42),[G1tensor(718),G1tensor(714),G0tensor(724),G0tensor(720)])
  call ol_merge_tensors(G1tensor(741),[G1tensor(732)])
  call ol_merge_tensors(G1tensor(739),[G1tensor(735)])
  call ol_merge_tensors(G1tensor(742),[G1tensor(738)])
  call ol_merge_tensors(G1tensor(752),[G1tensor(745)])
  call ol_merge_tensors(G1tensor(750),[G1tensor(746)])
  call ol_merge_tensors(G1tensor(755),[G1tensor(751)])
  call ol_merge_tensors(G2tensor(82),[G1tensor(757),G0tensor(739)])
  call ol_merge_tensors(G3tensor(28),[G3tensor(26),G1tensor(768),G1tensor(763),G0tensor(750),G0tensor(745)])
  call ol_merge_tensors(G3tensor(44),[G3tensor(43),G1tensor(767),G0tensor(749)])
  call ol_merge_tensors(G3tensor(46),[G3tensor(45),G1tensor(772),G0tensor(754)])
  call ol_merge_tensors(G3tensor(34),[G3tensor(32),G1tensor(773),G0tensor(755)])
  call TI_triangle_red(G2tensor(7),RedBasis(92),mass3set(:,1),G0tensor(7),G0tensor(12),G0tensor(17),G0tensor(22),M2L1R1,[nMT], &
    G0tensor(27))
  call TI_triangle_red(G2tensor(11),RedBasis(105),mass3set(:,1),G0tensor(32),G0tensor(37),G0tensor(42),G0tensor(47),M2L1R1,[nMT], &
    G0tensor(52))
  call TI_triangle_red(G2tensor(370),RedBasis(11),mass3set(:,2),G0tensor(57),G0tensor(62),G0tensor(67),G0tensor(72),M2L1R1,[nMT], &
    G0tensor(77))
  call TI_triangle_red(G2tensor(54),RedBasis(6),mass3set(:,2),G0tensor(82),G0tensor(87),G0tensor(92),G0tensor(97),M2L1R1,[nMT], &
    G0tensor(102))
  call TI_triangle_red(G2tensor(46),RedBasis(188),mass3set(:,3),G0tensor(107),G0tensor(112),G0tensor(117), &
    G0tensor(122),M2L1R1,[nMT],G0tensor(127))
  call TI_triangle_red(G2tensor(76),RedBasis(128),mass3set(:,4),G0tensor(132),G0tensor(137),G0tensor(142), &
    G0tensor(147),M2L1R1,[nMT],G0tensor(152))
  call TI_triangle_red(G2tensor(388),RedBasis(190),mass3set(:,3),G0tensor(157),G0tensor(162),G0tensor(167), &
    G0tensor(172),M2L1R1,[nMT],G0tensor(177))
  call TI_triangle_red(G2tensor(368),RedBasis(155),mass3set(:,4),G0tensor(182),G0tensor(187),G0tensor(192), &
    G0tensor(197),M2L1R1,[nMT],G0tensor(202))
  call TI_triangle_red(G2tensor(312),RedBasis(141),mass3set(:,1),G0tensor(207),G0tensor(212),G0tensor(217), &
    G0tensor(222),M2L1R1,[nMT],G0tensor(227))
  call TI_triangle_red(G2tensor(108),RedBasis(7),mass3set(:,5),G0tensor(232),G0tensor(237),G0tensor(242), &
    G0tensor(247),M2L1R1,[nMT],G0tensor(252))
  call TI_triangle_red(G2tensor(26),RedBasis(6),mass3set(:,1),G0tensor(257),G0tensor(262),G0tensor(267), &
    G0tensor(272),M2L1R1,[nMT],G0tensor(277))
  call TI_triangle_red(G2tensor(85),RedBasis(9),mass3set(:,4),G0tensor(282),G0tensor(287),G0tensor(292), &
    G0tensor(297),M2L1R1,[nMT],G0tensor(302))
  call TI_triangle_red(G2tensor(60),RedBasis(8),mass3set(:,5),G0tensor(307),G0tensor(312),G0tensor(317), &
    G0tensor(322),M2L1R1,[nMT],G0tensor(327))
  call TI_triangle_red(G2tensor(84),RedBasis(4),mass3set(:,4),G0tensor(332),G0tensor(337),G0tensor(342), &
    G0tensor(347),M2L1R1,[nMT],G0tensor(352))
  call TI_triangle_red(G2tensor(24),RedBasis(2),mass3set(:,5),G0tensor(357),G0tensor(362),G0tensor(367), &
    G0tensor(372),M2L1R1,[nMT],G0tensor(377))
  call TI_triangle_red(G2tensor(102),RedBasis(1),mass3set(:,5),G0tensor(382),G0tensor(387),G0tensor(392), &
    G0tensor(397),M2L1R1,[nMT],G0tensor(402))
  call TI_triangle_red(G2tensor(52),RedBasis(26),mass3set(:,6),G0tensor(407),G0tensor(412),G0tensor(417), &
    G0tensor(422),M2L1R1,[nMT],G0tensor(427))
  call TI_triangle_red(G2tensor(48),RedBasis(24),mass3set(:,3),G0tensor(432),G0tensor(437),G0tensor(442), &
    G0tensor(447),M2L1R1,[nMT],G0tensor(452))
  call TI_triangle_red(G2tensor(96),RedBasis(1),mass3set(:,3),G0tensor(457),G0tensor(462),G0tensor(467), &
    G0tensor(472),M2L1R1,[nMT],G0tensor(477))
  call TI_triangle_red(G2tensor(382),RedBasis(30),mass3set(:,6),G0tensor(482),G0tensor(487),G0tensor(492), &
    G0tensor(497),M2L1R1,[nMT],G0tensor(502))
  call TI_triangle_red(G2tensor(373),RedBasis(28),mass3set(:,3),G0tensor(507),G0tensor(512),G0tensor(517), &
    G0tensor(522),M2L1R1,[nMT],G0tensor(527))
  call TI_triangle_red(G2tensor(105),RedBasis(7),mass3set(:,3),G0tensor(532),G0tensor(537),G0tensor(542), &
    G0tensor(547),M2L1R1,[nMT],G0tensor(552))
  call TI_triangle_red(G3tensor(6),RedBasis(140),mass3set(:,7),G0tensor(557),G0tensor(562),G0tensor(567), &
    G0tensor(572),M2L1R1,[nMT],G0tensor(577))
  call TI_triangle_red(G2tensor(50),RedBasis(137),mass3set(:,3),G0tensor(582),G0tensor(587),G0tensor(592), &
    G0tensor(597),M2L1R1,[nMT],G0tensor(602))
  call TI_triangle_red(G3tensor(54),RedBasis(143),mass3set(:,7),G0tensor(607),G0tensor(612),G0tensor(617), &
    G0tensor(622),M2L1R1,[nMT],G0tensor(627))
  call TI_triangle_red(G2tensor(357),RedBasis(145),mass3set(:,1),G0tensor(632),G0tensor(637),G0tensor(642), &
    G0tensor(647),M2L1R1,[nMT],G0tensor(652))
  call TI_triangle_red(G2tensor(58),RedBasis(133),mass3set(:,3),G0tensor(657),G0tensor(662),G0tensor(667), &
    G0tensor(672),M2L1R1,[nMT],G0tensor(677))
  call TI_triangle_red(G2tensor(153),RedBasis(30),mass3set(:,4),G0tensor(682),G0tensor(687),G0tensor(692), &
    G0tensor(697),M2L1R1,[nMT],G0tensor(702))
  call TI_triangle_red(G2tensor(22),RedBasis(28),mass3set(:,5),G0tensor(707),G0tensor(712),G0tensor(717), &
    G0tensor(722),M2L1R1,[nMT],G0tensor(727))
  call TI_triangle_red(G2tensor(79),RedBasis(133),mass3set(:,5),G0tensor(732),G0tensor(1),G0tensor(2),G0tensor(3),M2L1R1,[nMT], &
    G0tensor(4))
  call TI_triangle_red(G2tensor(78),RedBasis(137),mass3set(:,5),G0tensor(5),G0tensor(6),G0tensor(737),G0tensor(742),M2L1R1,[nMT], &
    G0tensor(747))
  call TI_triangle_red(G3tensor(58),RedBasis(143),mass3set(:,8),G0tensor(752),G0tensor(668),G0tensor(604),G0tensor(559),M2L1R1)
  call TI_triangle_red(G3tensor(56),RedBasis(143),mass3set(:,9),G0tensor(549),G0tensor(364),G0tensor(314), &
    G0tensor(168),M2L1R1,[nMB],G0tensor(33))
  call TI_triangle_red(G3tensor(12),RedBasis(140),mass3set(:,9),G0tensor(28),G0tensor(23),G0tensor(718), &
    G0tensor(589),M2L1R1,[nMB],G0tensor(579))
  call TI_triangle_red(G2tensor(124),RedBasis(12),mass3set(:,8),G0tensor(574),G0tensor(369),G0tensor(334),G0tensor(163),M2L1R1)
  call TI_triangle_red(G2tensor(306),RedBasis(151),mass3set(:,3),G0tensor(18),G0tensor(13),G0tensor(8),G0tensor(238),M2L1R1,[nMT], &
    G0tensor(233))
  call TI_triangle_red(G2tensor(297),RedBasis(157),mass3set(:,3),G0tensor(136),G0tensor(106),G0tensor(74), &
    G0tensor(69),M2L1R1,[nMT],G0tensor(268))
  call TI_triangle_red(G3tensor(24),RedBasis(187),mass3set(:,7),G0tensor(263),G0tensor(151),G0tensor(121), &
    G0tensor(64),M2L1R1,[nMT],G0tensor(59))
  call TI_triangle_red(G2tensor(72),RedBasis(130),mass3set(:,8),G0tensor(358),G0tensor(324),G0tensor(318),G0tensor(313),M2L1R1)
  call TI_triangle_red(G2tensor(17),RedBasis(155),mass3set(:,6),G0tensor(679),G0tensor(674),G0tensor(328), &
    G0tensor(323),M2L1R1,[nMT],G0tensor(349))
  call TI_triangle_red(G2tensor(34),RedBasis(153),mass3set(:,3),G0tensor(343),G0tensor(338),G0tensor(333), &
    G0tensor(353),M2L1R1,[nMT],G0tensor(348))
  call TI_triangle_red(G2tensor(18),RedBasis(128),mass3set(:,6),G0tensor(691),G0tensor(683),G0tensor(671), &
    G0tensor(319),M2L1R1,[nMT],G0tensor(686))
  call TI_triangle_red(G2tensor(44),RedBasis(159),mass3set(:,3),G0tensor(521),G0tensor(486),G0tensor(91), &
    G0tensor(46),M2L1R1,[nMT],G0tensor(31))
  call TI_triangle_red(G2tensor(73),RedBasis(129),mass3set(:,4),G0tensor(688),G0tensor(359),G0tensor(88), &
    G0tensor(676),M2L1R1,[nMT],G0tensor(511))
  call TI_triangle_red(G2tensor(3),RedBasis(134),mass3set(:,5),G0tensor(476),G0tensor(71),G0tensor(29),G0tensor(681),M2L1R1,[nMT], &
    G0tensor(516))
  call TI_triangle_red(G2tensor(144),RedBasis(139),mass3set(:,4),G0tensor(481),G0tensor(76),G0tensor(30), &
    G0tensor(436),M2L1R1,[nMT],G0tensor(396))
  call TI_triangle_red(G2tensor(157),RedBasis(138),mass3set(:,5),G0tensor(61),G0tensor(14),G0tensor(446), &
    G0tensor(406),M2L1R1,[nMT],G0tensor(66))
  call TI_triangle_red(G3tensor(15),RedBasis(144),mass3set(:,7),G0tensor(15),G0tensor(741),G0tensor(451), &
    G0tensor(411),M2L1R1,[nMT],G0tensor(41))
  call TI_triangle_red(G2tensor(20),RedBasis(11),mass3set(:,1),G0tensor(16),G0tensor(551),G0tensor(280), &
    G0tensor(239),M2L1R1,[nMT],G0tensor(220))
  call TI_triangle_red(G3tensor(19),RedBasis(189),mass3set(:,7),G0tensor(561),G0tensor(330),G0tensor(290), &
    G0tensor(240),M2L1R1,[nMT],G0tensor(230))
  call TI_triangle_red(G2tensor(111),RedBasis(47),mass3set(:,8),G0tensor(711),G0tensor(571),G0tensor(321),G0tensor(241),M2L1R1)
  call TI_triangle_red(G2tensor(392),RedBasis(57),mass3set(:,8),G0tensor(146),G0tensor(116),G0tensor(581),G0tensor(300),M2L1R1)
  call TI_triangle_red(G2tensor(121),RedBasis(147),mass3set(:,8),G0tensor(269),G0tensor(250),G0tensor(591),G0tensor(355),M2L1R1)
  call TI_triangle_red(G3tensor(27),RedBasis(187),mass3set(:,9),G0tensor(310),G0tensor(270),G0tensor(260), &
    G0tensor(726),M2L1R1,[nMB],G0tensor(601))
  call TI_triangle_red(G3tensor(30),RedBasis(189),mass3set(:,9),G0tensor(341),G0tensor(271),G0tensor(161), &
    G0tensor(131),M2L1R1,[nMB],G0tensor(736))
  call TI_triangle_red(G3tensor(33),RedBasis(144),mass3set(:,9),G0tensor(706),G0tensor(340),G0tensor(320), &
    G0tensor(708),M2L1R1,[nMB],G0tensor(329))
  call TI_triangle_red(G2tensor(38),RedBasis(5),mass3set(:,2),G0tensor(316),G0tensor(716),G0tensor(356), &
    G0tensor(331),M2L1R1,[nMT],G0tensor(731))
  call TI_triangle_red(G2tensor(32),RedBasis(3),mass3set(:,8),G0tensor(721),G0tensor(339),G0tensor(723),G0tensor(354),M2L1R1)
  call TI_triangle_red(G2tensor(36),RedBasis(10),mass3set(:,2),G0tensor(336),G0tensor(696),G0tensor(89), &
    G0tensor(701),M2L1R1,[nMT],G0tensor(665))
  call TI_triangle_red(G2tensor(150),RedBasis(148),mass3set(:,8),G0tensor(655),G0tensor(650),G0tensor(90),G0tensor(659),M2L1R1)
  call TI_triangle_red(G2tensor(376),RedBasis(37),mass3set(:,8),G0tensor(649),G0tensor(498),G0tensor(463),G0tensor(171),M2L1R1)
  call TI_triangle_red(G2tensor(88),RedBasis(77),mass3set(:,8),G0tensor(49),G0tensor(43),G0tensor(639),G0tensor(629),M2L1R1)
  call TI_triangle_red(G2tensor(56),RedBasis(93),mass3set(:,1),G0tensor(423),G0tensor(383),G0tensor(166), &
    G0tensor(54),M2L1R1,[nMT],G0tensor(38))
  call TI_triangle_red(G3tensor(20),RedBasis(97),mass3set(:,7),G0tensor(651),G0tensor(631),G0tensor(85),G0tensor(80),M2L1R1,[nMT], &
    G0tensor(746))
  call TI_triangle_red(G2tensor(40),RedBasis(106),mass3set(:,1),G0tensor(756),G0tensor(751),G0tensor(666), &
    G0tensor(646),M2L1R1,[nMT],G0tensor(536))
  call TI_triangle_red(G2tensor(13),RedBasis(24),mass3set(:,5),G0tensor(211),G0tensor(191),G0tensor(101), &
    G0tensor(96),M2L1R1,[nMT],G0tensor(86))
  call TI_triangle_red(G3tensor(35),RedBasis(142),mass3set(:,7),G0tensor(568),G0tensor(361),G0tensor(236), &
    G0tensor(141),M2L1R1,[nMT],G0tensor(111))
  call TI_triangle_red(G2tensor(5),RedBasis(5),mass3set(:,1),G0tensor(598),G0tensor(346),G0tensor(266),G0tensor(156),M2L1R1,[nMT], &
    G0tensor(126))
  call TI_triangle_red(G2tensor(2),RedBasis(127),mass3set(:,4),G0tensor(713),G0tensor(351),G0tensor(326), &
    G0tensor(533),M2L1R1,[nMT],G0tensor(206))
  call TI_triangle_red(G2tensor(161),RedBasis(126),mass3set(:,5),G0tensor(186),G0tensor(79),G0tensor(56), &
    G0tensor(51),M2L1R1,[nMT],G0tensor(648))
  call TI_triangle_red(G3tensor(36),RedBasis(146),mass3set(:,7),G0tensor(548),G0tensor(275),G0tensor(234), &
    G0tensor(215),M2L1R1,[nMT],G0tensor(558))
  call TI_triangle_red(G3tensor(16),RedBasis(3),mass3set(:,7),G0tensor(325),G0tensor(285),G0tensor(235), &
    G0tensor(225),M2L1R1,[nMT],G0tensor(628))
  call TI_triangle_red(G2tensor(42),RedBasis(10),mass3set(:,1),G0tensor(578),G0tensor(295),G0tensor(264), &
    G0tensor(245),M2L1R1,[nMT],G0tensor(588))
  call TI_triangle_red(G2tensor(82),RedBasis(26),mass3set(:,4),G0tensor(350),G0tensor(305),G0tensor(265), &
    G0tensor(255),M2L1R1,[nMT],G0tensor(699))
  call TI_triangle_red(G3tensor(28),RedBasis(97),mass3set(:,9),G0tensor(694),G0tensor(488),G0tensor(453), &
    G0tensor(174),M2L1R1,[nMB],G0tensor(169))
  call TI_triangle_red(G3tensor(44),RedBasis(146),mass3set(:,9),G0tensor(68),G0tensor(493),G0tensor(458), &
    G0tensor(184),M2L1R1,[nMB],G0tensor(170))
  call TI_triangle_red(G3tensor(46),RedBasis(142),mass3set(:,9),G0tensor(73),G0tensor(413),G0tensor(373), &
    G0tensor(194),M2L1R1,[nMB],G0tensor(164))
  call TI_triangle_red(G3tensor(34),RedBasis(3),mass3set(:,9),G0tensor(58),G0tensor(418),G0tensor(378),G0tensor(204),M2L1R1,[nMB], &
    G0tensor(165))
  call TI_triangle_red(G1tensor(387),RedBasis(171),mass3set(:,4),G0tensor(63),G0tensor(714),G0tensor(703), &
    G0tensor(335),M2L1R1,[nMT],G0tensor(315))
  call TI_triangle_red(G1tensor(397),RedBasis(169),mass3set(:,5),G0tensor(738),G0tensor(728),G0tensor(344), &
    G0tensor(733),M2L1R1,[nMT],G0tensor(360))
  call TI_triangle_red(G1tensor(402),RedBasis(168),mass3set(:,5),G0tensor(345),G0tensor(469),G0tensor(399), &
    G0tensor(389),M2L1R1,[nMT],G0tensor(278))
  call TI_triangle_red(G1tensor(427),RedBasis(22),mass3set(:,4),G0tensor(273),G0tensor(248),G0tensor(243), &
    G0tensor(134),M2L1R1,[nMT],G0tensor(119))
  call TI_triangle_red(G1tensor(437),RedBasis(21),mass3set(:,5),G0tensor(83),G0tensor(504),G0tensor(439), &
    G0tensor(429),M2L1R1,[nMT],G0tensor(298))
  call TI_triangle_red(G1tensor(442),RedBasis(20),mass3set(:,5),G0tensor(293),G0tensor(218),G0tensor(213), &
    G0tensor(149),M2L1R1,[nMT],G0tensor(104))
  call TI_triangle_red(G1tensor(467),RedBasis(176),mass3set(:,4),G0tensor(78),G0tensor(656),G0tensor(636), &
    G0tensor(81),M2L1R1,[nMT],G0tensor(743))
  call TI_triangle_red(G1tensor(472),RedBasis(175),mass3set(:,5),G0tensor(748),G0tensor(753),G0tensor(744), &
    G0tensor(393),M2L1R1,[nMT],G0tensor(376))
  call TI_triangle_red(G1tensor(477),RedBasis(174),mass3set(:,5),G0tensor(9),G0tensor(403),G0tensor(381), &
    G0tensor(10),M2L1R1,[nMT],G0tensor(408))
  call TI_triangle_red(G1tensor(502),RedBasis(17),mass3set(:,4),G0tensor(386),G0tensor(11),G0tensor(433), &
    G0tensor(416),M2L1R1,[nMT],G0tensor(199))
  call TI_triangle_red(G1tensor(507),RedBasis(16),mass3set(:,5),G0tensor(19),G0tensor(443),G0tensor(421), &
    G0tensor(209),M2L1R1,[nMT],G0tensor(20))
  call TI_triangle_red(G1tensor(512),RedBasis(15),mass3set(:,5),G0tensor(448),G0tensor(426),G0tensor(99), &
    G0tensor(21),M2L1R1,[nMT],G0tensor(473))
  call TI_triangle_red(G1tensor(281),RedBasis(156),mass3set(:,6),G0tensor(456),G0tensor(24),G0tensor(478), &
    G0tensor(461),M2L1R1,[nMT],G0tensor(25))
  call TI_triangle_red(G1tensor(648),RedBasis(131),mass3set(:,5),G0tensor(483),G0tensor(466),G0tensor(26), &
    G0tensor(508),M2L1R1,[nMT],G0tensor(491))
  call TI_triangle_red(G1tensor(293),RedBasis(167),mass3set(:,6),G0tensor(179),G0tensor(34),G0tensor(513), &
    G0tensor(496),M2L1R1,[nMT],G0tensor(189))
  call TI_triangle_red(G1tensor(628),RedBasis(135),mass3set(:,5),G0tensor(35),G0tensor(518),G0tensor(501), &
    G0tensor(94),M2L1R1,[nMT],G0tensor(36))
  call TI_triangle_red(G1tensor(525),RedBasis(13),mass3set(:,5),G0tensor(431),G0tensor(391),G0tensor(60), &
    G0tensor(39),M2L1R1,[nMT],G0tensor(441))
  call TI_triangle_red(G1tensor(540),RedBasis(18),mass3set(:,5),G0tensor(401),G0tensor(75),G0tensor(65),G0tensor(45),M2L1R1,[nMT], &
    G0tensor(40))
  call TI_triangle_red(G1tensor(518),RedBasis(76),mass3set(:,2),G0tensor(506),G0tensor(471),G0tensor(70), &
    G0tensor(44),M2L1R1,[nMT],G0tensor(363))
  call TI_triangle_red(G1tensor(508),RedBasis(46),mass3set(:,2),G0tensor(224),G0tensor(214),G0tensor(93), &
    G0tensor(48),M2L1R1,[nMT],G0tensor(654))
  call TI_triangle_red(G1tensor(647),RedBasis(154),mass3set(:,6),G0tensor(528),G0tensor(176),G0tensor(50), &
    G0tensor(368),M2L1R1,[nMT],G0tensor(304))
  call TI_triangle_red(G1tensor(557),RedBasis(152),mass3set(:,3),G0tensor(294),G0tensor(98),G0tensor(53), &
    G0tensor(634),M2L1R1,[nMT],G0tensor(543))
  call TI_triangle_red(G1tensor(550),RedBasis(25),mass3set(:,6),G0tensor(196),G0tensor(55),G0tensor(661), &
    G0tensor(641),M2L1R1,[nMT],G0tensor(84))
  call TI_triangle_red(G1tensor(560),RedBasis(23),mass3set(:,3),G0tensor(531),G0tensor(181),G0tensor(95), &
    G0tensor(546),M2L1R1,[nMT],G0tensor(201))
  call TI_triangle_red(G1tensor(309),RedBasis(173),mass3set(:,2),G0tensor(100),G0tensor(524),G0tensor(494), &
    G0tensor(489),M2L1R1,[nMT],G0tensor(113))
  call TI_triangle_red(G1tensor(398),RedBasis(39),mass3set(:,2),G0tensor(108),G0tensor(103),G0tensor(514), &
    G0tensor(509),M2L1R1,[nMT],G0tensor(228))
  call TI_triangle_red(G1tensor(637),RedBasis(160),mass3set(:,6),G0tensor(223),G0tensor(105),G0tensor(653), &
    G0tensor(553),M2L1R1,[nMT],G0tensor(216))
  call TI_triangle_red(G1tensor(587),RedBasis(158),mass3set(:,3),G0tensor(109),G0tensor(563),G0tensor(226), &
    G0tensor(110),M2L1R1,[nMT],G0tensor(556))
  call TI_triangle_red(G1tensor(580),RedBasis(29),mass3set(:,6),G0tensor(221),G0tensor(114),G0tensor(566), &
    G0tensor(231),M2L1R1,[nMT],G0tensor(115))
  call TI_triangle_red(G1tensor(590),RedBasis(13),mass3set(:,3),G0tensor(379),G0tensor(374),G0tensor(128), &
    G0tensor(123),M2L1R1,[nMT],G0tensor(118))
  call TI_triangle_red(G1tensor(453),RedBasis(178),mass3set(:,2),G0tensor(404),G0tensor(394),G0tensor(258), &
    G0tensor(253),M2L1R1,[nMT],G0tensor(120))
  call TI_triangle_red(G1tensor(473),RedBasis(44),mass3set(:,2),G0tensor(643),G0tensor(583),G0tensor(246), &
    G0tensor(124),M2L1R1,[nMT],G0tensor(593))
  call TI_triangle_red(G1tensor(657),RedBasis(163),mass3set(:,6),G0tensor(256),G0tensor(125),G0tensor(586), &
    G0tensor(251),M2L1R1,[nMT],G0tensor(129))
  call TI_triangle_red(G1tensor(607),RedBasis(162),mass3set(:,3),G0tensor(596),G0tensor(261),G0tensor(130), &
    G0tensor(459),M2L1R1,[nMT],G0tensor(454))
  call TI_triangle_red(G1tensor(605),RedBasis(32),mass3set(:,6),G0tensor(143),G0tensor(138),G0tensor(133), &
    G0tensor(479),M2L1R1,[nMT],G0tensor(474))
  call TI_triangle_red(G1tensor(610),RedBasis(18),mass3set(:,3),G0tensor(288),G0tensor(283),G0tensor(135), &
    G0tensor(663),M2L1R1,[nMT],G0tensor(608))
  call TI_triangle_red(G1tensor(533),RedBasis(85),mass3set(:,2),G0tensor(276),G0tensor(139),G0tensor(613), &
    G0tensor(286),M2L1R1,[nMT],G0tensor(140))
  call TI_triangle_red(G1tensor(438),RedBasis(42),mass3set(:,2),G0tensor(611),G0tensor(281),G0tensor(144), &
    G0tensor(616),M2L1R1,[nMT],G0tensor(291))
  call TI_triangle_red(G1tensor(627),RedBasis(166),mass3set(:,6),G0tensor(145),G0tensor(539),G0tensor(419), &
    G0tensor(414),M2L1R1,[nMT],G0tensor(158))
  call TI_triangle_red(G1tensor(617),RedBasis(165),mass3set(:,3),G0tensor(153),G0tensor(148),G0tensor(444), &
    G0tensor(434),M2L1R1,[nMT],G0tensor(308))
  call TI_triangle_red(G1tensor(615),RedBasis(35),mass3set(:,6),G0tensor(303),G0tensor(150),G0tensor(633), &
    G0tensor(618),M2L1R1,[nMT],G0tensor(296))
  call TI_triangle_red(G1tensor(620),RedBasis(34),mass3set(:,3),G0tensor(154),G0tensor(623),G0tensor(306), &
    G0tensor(155),M2L1R1,[nMT],G0tensor(621))
  call TI_triangle_red(G1tensor(558),RedBasis(91),mass3set(:,1),G0tensor(301),G0tensor(159),G0tensor(626), &
    G0tensor(311),M2L1R1,[nMT],G0tensor(160))
  call TI_triangle_red(G1tensor(517),RedBasis(132),mass3set(:,5),G0tensor(564),G0tensor(554),G0tensor(365), &
    G0tensor(178),M2L1R1,[nMT],G0tensor(173))
  call TI_triangle_red(G1tensor(520),RedBasis(14),mass3set(:,5),G0tensor(523),G0tensor(185),G0tensor(175), &
    G0tensor(526),M2L1R1,[nMT],G0tensor(190))
  call TI_triangle_red(G1tensor(298),RedBasis(27),mass3set(:,6),G0tensor(180),G0tensor(366),G0tensor(229), &
    G0tensor(219),M2L1R1,[nMT],G0tensor(188))
  call TI_triangle_red(G1tensor(618),RedBasis(121),mass3set(:,1),G0tensor(183),G0tensor(624),G0tensor(619), &
    G0tensor(370),M2L1R1,[nMT],G0tensor(198))
  call TI_triangle_red(G1tensor(532),RedBasis(136),mass3set(:,5),G0tensor(193),G0tensor(538),G0tensor(205), &
    G0tensor(195),M2L1R1,[nMT],G0tensor(541))
  call TI_triangle_red(G1tensor(535),RedBasis(19),mass3set(:,5),G0tensor(210),G0tensor(200),G0tensor(371), &
    G0tensor(309),M2L1R1,[nMT],G0tensor(299))
  call TI_triangle_red(G1tensor(351),RedBasis(36),mass3set(:,6),G0tensor(208),G0tensor(203),G0tensor(638), &
    G0tensor(573),M2L1R1,[nMT],G0tensor(254))
  call TI_triangle_red(G1tensor(632),RedBasis(161),mass3set(:,6),G0tensor(244),G0tensor(576),G0tensor(259), &
    G0tensor(249),M2L1R1,[nMT],G0tensor(658))
  call TI_triangle_red(G1tensor(570),RedBasis(31),mass3set(:,6),G0tensor(603),G0tensor(284),G0tensor(274), &
    G0tensor(606),M2L1R1,[nMT],G0tensor(289))
  call TI_triangle_red(G1tensor(652),RedBasis(164),mass3set(:,6),G0tensor(279),G0tensor(388),G0tensor(384), &
    G0tensor(375),M2L1R1,[nMT],G0tensor(465))
  call TI_triangle_red(G1tensor(600),RedBasis(33),mass3set(:,6),G0tensor(460),G0tensor(398),G0tensor(385), &
    G0tensor(380),M2L1R1,[nMT],G0tensor(409))
  call TI_triangle_red(G1tensor(369),RedBasis(172),mass3set(:,2),G0tensor(395),G0tensor(390),G0tensor(545), &
    G0tensor(540),M2L1R1,[nMT],G0tensor(535))
  call TI_triangle_red(G1tensor(459),RedBasis(170),mass3set(:,8),G0tensor(530),G0tensor(525),G0tensor(485),G0tensor(480),M2L1R1)
  call TI_triangle_red(G1tensor(403),RedBasis(38),mass3set(:,2),G0tensor(410),G0tensor(405),G0tensor(400), &
    G0tensor(544),M2L1R1,[nMT],G0tensor(428))
  call TI_triangle_red(G1tensor(538),RedBasis(84),mass3set(:,2),G0tensor(424),G0tensor(415),G0tensor(534), &
    G0tensor(500),M2L1R1,[nMT],G0tensor(495))
  call TI_triangle_red(G1tensor(443),RedBasis(41),mass3set(:,2),G0tensor(438),G0tensor(425),G0tensor(420), &
    G0tensor(449),M2L1R1,[nMT],G0tensor(435))
  call TI_triangle_red(G1tensor(514),RedBasis(40),mass3set(:,8),G0tensor(430),G0tensor(520),G0tensor(515),G0tensor(450),M2L1R1)
  call TI_triangle_red(G1tensor(462),RedBasis(177),mass3set(:,2),G0tensor(445),G0tensor(440),G0tensor(468), &
    G0tensor(464),M2L1R1,[nMT],G0tensor(455))
  call TI_triangle_red(G1tensor(478),RedBasis(43),mass3set(:,2),G0tensor(484),G0tensor(475),G0tensor(470), &
    G0tensor(529),M2L1R1,[nMT],G0tensor(503))
  call TI_triangle_red(G1tensor(523),RedBasis(75),mass3set(:,2),G0tensor(499),G0tensor(490),G0tensor(519), &
    G0tensor(510),M2L1R1,[nMT],G0tensor(505))
  call TI_triangle_red(G1tensor(513),RedBasis(45),mass3set(:,2),G0tensor(698),G0tensor(690),G0tensor(610), &
    G0tensor(569),M2L1R1,[nMT],G0tensor(555))
  call TI_triangle_red(G1tensor(588),RedBasis(104),mass3set(:,1),G0tensor(550),G0tensor(735),G0tensor(715), &
    G0tensor(625),M2L1R1,[nMT],G0tensor(615))
  call TI_triangle_red(G1tensor(608),RedBasis(116),mass3set(:,1),G0tensor(600),G0tensor(595),G0tensor(590), &
    G0tensor(570),M2L1R1,[nMT],G0tensor(565))
  call TI_triangle_red(G1tensor(638),RedBasis(149),mass3set(:,5),G0tensor(560),G0tensor(594),G0tensor(584), &
    G0tensor(575),M2L1R1,[nMT],G0tensor(730))
  call TI_triangle_red(G1tensor(658),RedBasis(150),mass3set(:,5),G0tensor(620),G0tensor(599),G0tensor(585), &
    G0tensor(580),M2L1R1,[nMT],G0tensor(614))
  call ol_merge_tensors(T0sum(157),[G0tensor(7)])
  call ol_merge_tensors(T0sum(158),[G0tensor(32)])
  call ol_merge_tensors(T0sum(159),[G0tensor(57)])
  call ol_merge_tensors(T0sum(160),[G0tensor(82)])
  call ol_merge_tensors(T0sum(161),[G0tensor(107)])
  call ol_merge_tensors(T0sum(162),[G0tensor(132)])
  call ol_merge_tensors(T0sum(163),[G0tensor(157)])
  call ol_merge_tensors(T0sum(164),[G0tensor(182)])
  call ol_merge_tensors(T0sum(165),[G0tensor(207)])
  call ol_merge_tensors(T0sum(166),[G0tensor(232)])
  call ol_merge_tensors(T0sum(167),[G0tensor(257)])
  call ol_merge_tensors(T0sum(168),[G0tensor(282)])
  call ol_merge_tensors(T0sum(169),[G0tensor(307)])
  call ol_merge_tensors(T0sum(170),[G0tensor(332)])
  call ol_merge_tensors(T0sum(171),[G0tensor(357)])
  call ol_merge_tensors(T0sum(172),[G0tensor(382)])
  call ol_merge_tensors(T0sum(173),[G0tensor(407)])
  call ol_merge_tensors(T0sum(174),[G0tensor(432)])
  call ol_merge_tensors(T0sum(175),[G0tensor(457)])
  call ol_merge_tensors(T0sum(176),[G0tensor(482)])
  call ol_merge_tensors(T0sum(177),[G0tensor(507)])
  call ol_merge_tensors(T0sum(178),[G0tensor(532)])
  call ol_merge_tensors(T0sum(179),[G0tensor(557)])
  call ol_merge_tensors(T0sum(180),[G0tensor(582)])
  call ol_merge_tensors(T0sum(181),[G0tensor(607)])
  call ol_merge_tensors(T0sum(182),[G0tensor(632)])
  call ol_merge_tensors(T0sum(183),[G0tensor(657)])
  call ol_merge_tensors(T0sum(184),[G0tensor(682)])
  call ol_merge_tensors(T0sum(185),[G0tensor(707)])
  call ol_merge_tensors(T0sum(186),[G0tensor(732)])
  call ol_merge_tensors(T0sum(187),[G0tensor(5)])
  call ol_merge_tensors(T0sum(188),[G0tensor(752)])
  call ol_merge_tensors(T0sum(189),[G0tensor(549)])
  call ol_merge_tensors(T0sum(190),[G0tensor(28)])
  call ol_merge_tensors(T0sum(191),[G0tensor(574)])
  call ol_merge_tensors(T0sum(192),[G0tensor(18)])
  call ol_merge_tensors(T0sum(193),[G0tensor(136)])
  call ol_merge_tensors(T0sum(194),[G0tensor(263)])
  call ol_merge_tensors(T0sum(195),[G0tensor(358)])
  call ol_merge_tensors(T0sum(196),[G0tensor(679)])
  call ol_merge_tensors(T0sum(197),[G0tensor(343)])
  call ol_merge_tensors(T0sum(198),[G0tensor(691)])
  call ol_merge_tensors(T0sum(199),[G0tensor(521)])
  call ol_merge_tensors(T0sum(200),[G0tensor(688)])
  call ol_merge_tensors(T0sum(201),[G0tensor(476)])
  call ol_merge_tensors(T0sum(202),[G0tensor(481)])
  call ol_merge_tensors(T0sum(203),[G0tensor(61)])
  call ol_merge_tensors(T0sum(204),[G0tensor(15)])
  call ol_merge_tensors(T0sum(205),[G0tensor(16)])
  call ol_merge_tensors(T0sum(206),[G0tensor(561)])
  call ol_merge_tensors(T0sum(207),[G0tensor(711)])
  call ol_merge_tensors(T0sum(208),[G0tensor(146)])
  call ol_merge_tensors(T0sum(209),[G0tensor(269)])
  call ol_merge_tensors(T0sum(210),[G0tensor(310)])
  call ol_merge_tensors(T0sum(211),[G0tensor(341)])
  call ol_merge_tensors(T0sum(212),[G0tensor(706)])
  call ol_merge_tensors(T0sum(213),[G0tensor(63)])
  call ol_merge_tensors(T0sum(214),[G0tensor(738)])
  call ol_merge_tensors(T0sum(215),[G0tensor(345)])
  call ol_merge_tensors(T0sum(216),[G0tensor(273)])
  call ol_merge_tensors(T0sum(217),[G0tensor(83)])
  call ol_merge_tensors(T0sum(218),[G0tensor(293)])
  call ol_merge_tensors(T0sum(219),[G0tensor(78)])
  call ol_merge_tensors(T0sum(220),[G0tensor(748)])
  call ol_merge_tensors(T0sum(221),[G0tensor(9)])
  call ol_merge_tensors(T0sum(222),[G0tensor(386)])
  call ol_merge_tensors(T0sum(223),[G0tensor(19)])
  call ol_merge_tensors(T0sum(224),[G0tensor(448)])
  call ol_merge_tensors(T0sum(225),[G0tensor(316)])
  call ol_merge_tensors(T0sum(226),[G0tensor(721)])
  call ol_merge_tensors(T0sum(227),[G0tensor(336)])
  call ol_merge_tensors(T0sum(228),[G0tensor(456)])
  call ol_merge_tensors(T0sum(229),[G0tensor(483)])
  call ol_merge_tensors(T0sum(230),[G0tensor(179)])
  call ol_merge_tensors(T0sum(231),[G0tensor(35)])
  call ol_merge_tensors(T0sum(232),[G0tensor(655)])
  call ol_merge_tensors(T0sum(233),[G0tensor(431)])
  call ol_merge_tensors(T0sum(234),[G0tensor(401)])
  call ol_merge_tensors(T0sum(235),[G0tensor(506)])
  call ol_merge_tensors(T0sum(236),[G0tensor(224)])
  call ol_merge_tensors(T0sum(237),[G0tensor(528)])
  call ol_merge_tensors(T0sum(238),[G0tensor(294)])
  call ol_merge_tensors(T0sum(239),[G0tensor(196)])
  call ol_merge_tensors(T0sum(240),[G0tensor(531)])
  call ol_merge_tensors(T0sum(241),[G0tensor(100)])
  call ol_merge_tensors(T0sum(242),[G0tensor(108)])
  call ol_merge_tensors(T0sum(243),[G0tensor(223)])
  call ol_merge_tensors(T0sum(244),[G0tensor(109)])
  call ol_merge_tensors(T0sum(245),[G0tensor(221)])
  call ol_merge_tensors(T0sum(246),[G0tensor(379)])
  call ol_merge_tensors(T0sum(247),[G0tensor(404)])
  call ol_merge_tensors(T0sum(248),[G0tensor(643)])
  call ol_merge_tensors(T0sum(249),[G0tensor(256)])
  call ol_merge_tensors(T0sum(250),[G0tensor(596)])
  call ol_merge_tensors(T0sum(251),[G0tensor(143)])
  call ol_merge_tensors(T0sum(252),[G0tensor(288)])
  call ol_merge_tensors(T0sum(253),[G0tensor(276)])
  call ol_merge_tensors(T0sum(254),[G0tensor(611)])
  call ol_merge_tensors(T0sum(255),[G0tensor(145)])
  call ol_merge_tensors(T0sum(256),[G0tensor(153)])
  call ol_merge_tensors(T0sum(257),[G0tensor(303)])
  call ol_merge_tensors(T0sum(258),[G0tensor(154)])
  call ol_merge_tensors(T0sum(259),[G0tensor(301)])
  call ol_merge_tensors(T0sum(260),[G0tensor(564)])
  call ol_merge_tensors(T0sum(261),[G0tensor(523)])
  call ol_merge_tensors(T0sum(262),[G0tensor(180)])
  call ol_merge_tensors(T0sum(263),[G0tensor(183)])
  call ol_merge_tensors(T0sum(264),[G0tensor(193)])
  call ol_merge_tensors(T0sum(265),[G0tensor(210)])
  call ol_merge_tensors(T0sum(266),[G0tensor(208)])
  call ol_merge_tensors(T0sum(267),[G0tensor(244)])
  call ol_merge_tensors(T0sum(268),[G0tensor(603)])
  call ol_merge_tensors(T0sum(269),[G0tensor(279)])
  call ol_merge_tensors(T0sum(270),[G0tensor(460)])
  call ol_merge_tensors(T0sum(271),[G0tensor(395)])
  call ol_merge_tensors(T0sum(272),[G0tensor(530)])
  call ol_merge_tensors(T0sum(273),[G0tensor(410)])
  call ol_merge_tensors(T0sum(274),[G0tensor(649)])
  call ol_merge_tensors(T0sum(275),[G0tensor(424)])
  call ol_merge_tensors(T0sum(276),[G0tensor(49)])
  call ol_merge_tensors(T0sum(277),[G0tensor(438)])
  call ol_merge_tensors(T0sum(278),[G0tensor(430)])
  call ol_merge_tensors(T0sum(279),[G0tensor(445)])
  call ol_merge_tensors(T0sum(280),[G0tensor(484)])
  call ol_merge_tensors(T0sum(281),[G0tensor(499)])
  call ol_merge_tensors(T0sum(282),[G0tensor(698)])
  call ol_merge_tensors(T0sum(283),[G0tensor(423)])
  call ol_merge_tensors(T0sum(284),[G0tensor(651)])
  call ol_merge_tensors(T0sum(285),[G0tensor(550)])
  call ol_merge_tensors(T0sum(286),[G0tensor(756)])
  call ol_merge_tensors(T0sum(287),[G0tensor(600)])
  call ol_merge_tensors(T0sum(288),[G0tensor(211)])
  call ol_merge_tensors(T0sum(289),[G0tensor(560)])
  call ol_merge_tensors(T0sum(290),[G0tensor(620)])
  call ol_merge_tensors(T0sum(291),[G0tensor(568)])
  call ol_merge_tensors(T0sum(292),[G0tensor(598)])
  call ol_merge_tensors(T0sum(293),[G0tensor(713)])
  call ol_merge_tensors(T0sum(294),[G0tensor(186)])
  call ol_merge_tensors(T0sum(295),[G0tensor(548)])
  call ol_merge_tensors(T0sum(296),[G0tensor(325)])
  call ol_merge_tensors(T0sum(297),[G0tensor(578)])
  call ol_merge_tensors(T1sum(75),[G1tensor(741)])
  call ol_merge_tensors(T1sum(76),[G1tensor(733)])
  call ol_merge_tensors(T1sum(77),[G1tensor(734)])
  call ol_merge_tensors(T1sum(78),[G1tensor(739)])
  call ol_merge_tensors(T1sum(79),[G1tensor(736)])
  call ol_merge_tensors(T1sum(80),[G1tensor(737)])
  call ol_merge_tensors(T1sum(81),[G1tensor(742)])
  call ol_merge_tensors(T1sum(82),[G1tensor(740)])
  call ol_merge_tensors(T1sum(83),[G1tensor(743)])
  call ol_merge_tensors(T1sum(84),[G1tensor(744)])
  call ol_merge_tensors(T1sum(85),[G1tensor(752)])
  call ol_merge_tensors(T1sum(86),[G1tensor(750)])
  call ol_merge_tensors(T1sum(87),[G1tensor(747)])
  call ol_merge_tensors(T1sum(88),[G1tensor(748)])
  call ol_merge_tensors(T1sum(89),[G1tensor(749)])
  call ol_merge_tensors(T1sum(90),[G1tensor(755)])
  call ol_merge_tensors(T1sum(91),[G1tensor(753)])
  call ol_merge_tensors(T1sum(92),[G1tensor(754)])
  call ol_merge_tensors(T0sum(298),[G0tensor(350)])
  call ol_merge_tensors(T0sum(299),[G0tensor(694)])
  call ol_merge_tensors(T0sum(300),[G0tensor(68)])
  call ol_merge_tensors(T0sum(301),[G0tensor(73)])
  call ol_merge_tensors(T0sum(302),[G0tensor(58)])
  Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(285),h0tab(:,285),[32,31],[0,0],3,2,wf4(:,2),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(13),m3h2x16(:,143),heltab2x32(:,:,270))
  Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(3,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(286),h0tab(:,286),[32,31],[0,0],3,2,wf4(:,4),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(15),m3h2x16(:,144),heltab2x32(:,:,271))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j-M(3,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(287),h0tab(:,287),[32,31],[0,0],3,2,wf4(:,2),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(28),m3h2x16(:,145),heltab2x32(:,:,272))
  Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(288),h0tab(:,288),[44,19],[0,0],3,2,wf4(:,2),wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex6(:),wf4(:,2),G0H4(5),m4h2x4x4(:,11),heltab3x32(:,:,16))
  Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(3,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(289),h0tab(:,289),[44,19],[0,0],3,2,wf4(:,2),wf4(:,4))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,2),ex6(:),G0H4(12),m4h4x2x4(:,6),heltab3x32(:,:,17))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j-M(3,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(290),h0tab(:,290),[44,19],[0,0],3,2,wf4(:,2),wf4(:,4))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex6(:),wf4(:,2),G0H4(13),m4h2x4x4(:,12),heltab3x32(:,:,18))
  Gcoeff(:)%j = (c(4)*(M(2,:)%j-M(3,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(291),h0tab(:,291),[51,12],[0,0],3,2,wf4(:,4),wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex6(:),wf4(:,4),G0H4(11),m4h2x4x4(:,13),heltab3x32(:,:,19))
  Gcoeff(:)%j = (c(4)*(-M(2,:)%j+M(3,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(292),h0tab(:,292),[51,12],[0,0],3,2,wf4(:,4),wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,4),ex6(:),G0H4(10),m4h4x2x4(:,7),heltab3x32(:,:,20))



end subroutine vamp_3

end module ol_vamp_3_pphttj_ttxddxhg_1_/**/REALKIND
