
module ol_vamp_1_pphttj_ttxddxhg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphttj_ttxddxhg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphttj_ttxddxhg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pphttj_ttxddxhg_1_/**/DREALKIND
  use ol_tensor_sum_storage_pphttj_ttxddxhg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pphttj_ttxddxhg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pphttj_ttxddxhg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(32)
  type(Hpolcont), intent(in) :: M(4,32)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(17)*M(1,:)%j+c(14)*(-M(2,:)%j-M(3,:)%j)+c(13)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[32,4,1,16,2,8],[0,0,nMT,nMT,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (c(13)*M(1,:)%j+c(14)*(-M(2,:)%j-M(3,:)%j)+c(17)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[32,2,8,4,1,16],[nMT,0,0,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (c(6)*(-M(2,:)%j+M(3,:)%j)+c(7)*(M(1,:)%j-M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[32,2,16,1,4,8],[0,nMT,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(3),m3h2x16(:,3),heltab2x32(:,:,3))
  Gcoeff(:)%j = (c(13)*M(1,:)%j+c(14)*(-M(2,:)%j-M(3,:)%j)+c(17)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[32,1,4,8,2,16],[nMT,0,0,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(4),n2h16(3))
  Gcoeff(:)%j = (c(14)*(-M(2,:)%j-M(3,:)%j)+c(13)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[32,4,2,16,1,8],[0,0,nMT,nMT,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(5),n2h16(4))
  Gcoeff(:)%j = (c(13)*M(1,:)%j+c(14)*(-M(2,:)%j-M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[32,2,4,8,1,16],[nMT,0,0,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(6),n2h16(5))
  Gcoeff(:)%j = (c(8)*M(2,:)%j+c(6)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[32,2,16,1,8,4],[0,nMT,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(7),m3h2x16(:,7),heltab2x32(:,:,7))
  Gcoeff(:)%j = (c(13)*M(1,:)%j+c(14)*(-M(2,:)%j-M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[32,1,8,4,2,16],[nMT,0,0,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(8),n2h16(6))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)-c(8)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[32,1,16,2,4,8],[0,nMT,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(9),m3h2x16(:,9),heltab2x32(:,:,9))
  Gcoeff(:)%j = (c(6)*(-M(2,:)%j+M(3,:)%j)+c(7)*(-M(1,:)%j+M(4,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[32,1,16,2,8,4],[0,nMT,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(10),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_AQ_V(ntryL,G1H16(1),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_QA_V(ntryL,G1H16(2),ex2(:),G1H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_VA_Q(ntryL,G1H16(3),ex2(:),G1H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(3),34,nMT,G2H8(1),n2h8(1))
  call Hloop_AQ_V(ntryL,G1H16(4),ex1(:),G1H8(3),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_AQ_V(ntryL,G1H16(5),ex3(:),G1H8(4),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_QA_V(ntryL,G1H16(6),ex2(:),G1H8(5),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_VA_Q(ntryL,G1H16(7),ex2(:),G1H8(6),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G1H8(6),34,nMT,G2H8(2),n2h8(2))
  call Hloop_AQ_V(ntryL,G1H16(8),ex1(:),G1H8(6),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_VQ_A(ntryL,G1H16(9),ex1(:),G1H8(7),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H8(7),33,nMT,G2H8(3),n2h8(3))
  call Hloop_VQ_A(ntryL,G1H16(10),ex1(:),G1H8(7),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_Q_A(ntryL,G1H8(7),33,nMT,G2H8(4),n2h8(4))
  call Hloop_VQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),37,nMT,G2H4(1),n2h4(1))
  call Hloop_VA_Q(ntryL,G1H8(2),ex4(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_A_Q(ntryL,G1H4(1),42,0,G2H4(2),n2h4(2))
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(1),mass5set(:,1),  & 
G1H8(7),G1H8(1),G1H8(2),G1H8(8),G1H8(9),G1H8(10),8)
  call HG1shiftOLR(G1H8(1),8,8)
  call Hloop_VQ_A(ntryL,G1H8(3),ex3(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),37,0,G2H4(3),n2h4(3))
  call Hloop_VA_Q(ntryL,G1H8(4),ex2(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G1H4(1),38,nMT,G2H4(4),n2h4(4))
  call Hloop_VQ_A(ntryL,G1H8(5),ex3(:),G1H4(1),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),38,0,G2H4(5),n2h4(5))
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(1),mass5set(:,1),  & 
G1H8(3),G1H8(4),G1H8(5),G1H8(11),G1H8(12),G1H8(13),8)
  call HG1shiftOLR(G1H8(4),4,8)
  call Hloop_VA_Q(ntryL,G1H8(6),ex4(:),G1H4(1),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G1H4(1),41,0,G2H4(6),n2h4(6))
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(2),mass5set(:,1),  & 
G1H8(6),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
  call HG1shiftOLR(G1H8(14),8,8)
  call Hotf_5pt_reduction(G2H8(4),RedSet_5(2),mass5set(:,1),  & 
G1H8(19),G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
  call HG1shiftOLR(G1H8(20),4,8)
  call Hloop_AS_Q(ntryL,G1H8(7),ex5(:),G1H8(25),ngH,m3h1x8(:,1),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G1H8(25),50,nMT,G2H8(1),n2h8(5))
call HGT_raise_alpha_OLR(G1H8(1),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(1),ex4(:),G1H4(1),m3h2x4(:,7),heltab2x8(:,:,8))
  call Hloop_AS_Q(ntryL,G1H8(8),ex5(:),G1H8(7),ngH,m3h1x8(:,2),heltab2x8(:,:,9))
  call Hloop_A_Q(ntryL,G1H8(7),50,nMT,G2H8(2),n2h8(7))
  call Hloop_AS_Q(ntryL,G1H8(9),ex5(:),G1H8(25),ngH,m3h1x8(:,3),heltab2x8(:,:,10))
  call Hloop_A_Q(ntryL,G1H8(25),50,nMT,G2H8(3),n2h8(8))
  call Hloop_AS_Q(ntryL,G1H8(10),ex5(:),G1H8(1),ngH,m3h1x8(:,4),heltab2x8(:,:,11))
  call Hloop_A_Q(ntryL,G1H8(1),50,nMT,G2H8(4),n2h8(9))
  call Hloop_AS_Q(ntryL,G1H8(3),ex5(:),G1H8(8),ngH,m3h1x8(:,5),heltab2x8(:,:,12))
  call Hloop_A_Q(ntryL,G1H8(8),50,nMT,G2H8(5),n2h8(10))
call HGT_raise_alpha_OLR(G1H8(4),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(4),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(4),ex3(:),G1H4(2),m3h2x4(:,8),heltab2x8(:,:,13))
  call Hloop_AS_Q(ntryL,G1H8(11),ex5(:),G1H8(7),ngH,m3h1x8(:,6),heltab2x8(:,:,14))
  call Hloop_A_Q(ntryL,G1H8(7),50,nMT,G2H8(6),n2h8(12))
  call Hloop_AS_Q(ntryL,G1H8(12),ex5(:),G1H8(9),ngH,m3h1x8(:,7),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G1H8(9),50,nMT,G2H8(7),n2h8(13))
  call Hloop_AS_Q(ntryL,G1H8(13),ex5(:),G1H8(25),ngH,m3h1x8(:,8),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G1H8(25),50,nMT,G2H8(8),n2h8(14))
  call Hloop_QS_A(ntryL,G1H8(6),ex5(:),G1H8(10),ngH,m3h1x8(:,9),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G1H8(10),49,nMT,G2H8(9),n2h8(15))
call HGT_raise_alpha_OLR(G1H8(14),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(14),ex4(:),G1H4(3),m3h2x4(:,9),heltab2x8(:,:,18))
  call Hloop_QS_A(ntryL,G1H8(16),ex5(:),G1H8(1),ngH,m3h1x8(:,10),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H8(1),49,nMT,G2H8(10),n2h8(17))
  call Hloop_QS_A(ntryL,G1H8(17),ex5(:),G1H8(3),ngH,m3h1x8(:,11),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G1H8(3),49,nMT,G2H8(11),n2h8(18))
  call Hloop_QS_A(ntryL,G1H8(18),ex5(:),G1H8(8),ngH,m3h1x8(:,12),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H8(8),49,nMT,G2H8(12),n2h8(19))
  call Hloop_QS_A(ntryL,G1H8(19),ex5(:),G1H8(4),ngH,m3h1x8(:,13),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G1H8(4),49,nMT,G2H8(13),n2h8(20))
call HGT_raise_alpha_OLR(G1H8(20),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(20),ex3(:),G1H4(4),m3h2x4(:,10),heltab2x8(:,:,23))
  call Hloop_QS_A(ntryL,G1H8(22),ex5(:),G1H8(11),ngH,m3h1x8(:,14),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H8(11),49,nMT,G2H8(14),n2h8(22))
  call Hloop_QS_A(ntryL,G1H8(23),ex5(:),G1H8(7),ngH,m3h1x8(:,15),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G1H8(7),49,nMT,G2H8(15),n2h8(23))
  call Hloop_QS_A(ntryL,G1H8(24),ex5(:),G1H8(12),ngH,m3h1x8(:,16),heltab2x8(:,:,26))
  call Hloop_Q_A(ntryL,G1H8(12),49,nMT,G2H8(16),n2h8(24))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(3),mass5set(:,2),  & 
G1H4(5),G1H4(6),G1H4(7),G1H4(8),G1H4(9),G1H4(10),4)
  call HG1shiftOLR(G1H4(6),8,4)
  call Hloop_AQ_V(ntryL,G2H4(2),ex3(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntryL,G2H4(3),ex4(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(4),mass5set(:,2),  & 
G1H4(11),G1H4(12),G1H4(13),G1H4(14),G1H4(15),G1H4(16),4)
  call HG1shiftOLR(G1H4(12),8,4)
  call Hloop_QA_V(ntryL,G2H4(5),ex4(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_V(ntryL,G2H4(6),ex3(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_V(ntryL,G2H8(1),ex1(:),G2H4(1),m3h2x4(:,11),heltab2x8(:,:,27))
  call Hloop_AQ_V(ntryL,G2H8(3),ex1(:),G2H4(2),m3h2x4(:,12),heltab2x8(:,:,28))
  call Hloop_AQ_V(ntryL,G2H8(4),ex1(:),G2H4(3),m3h2x4(:,13),heltab2x8(:,:,29))
  call Hloop_AQ_V(ntryL,G2H8(5),ex1(:),G2H4(4),m3h2x4(:,14),heltab2x8(:,:,30))
  call Hloop_AQ_V(ntryL,G2H8(7),ex1(:),G2H4(5),m3h2x4(:,15),heltab2x8(:,:,31))
  call Hloop_AQ_V(ntryL,G2H8(8),ex1(:),G2H4(6),m3h2x4(:,16),heltab2x8(:,:,32))
  call Hloop_QA_V(ntryL,G2H8(9),ex2(:),G2H4(7),m3h2x4(:,17),heltab2x8(:,:,33))
  call Hloop_QA_V(ntryL,G2H8(11),ex2(:),G2H4(8),m3h2x4(:,18),heltab2x8(:,:,34))
  call Hloop_QA_V(ntryL,G2H8(12),ex2(:),G2H4(9),m3h2x4(:,19),heltab2x8(:,:,35))
  call Hloop_QA_V(ntryL,G2H8(13),ex2(:),G2H4(10),m3h2x4(:,20),heltab2x8(:,:,36))
  call Hloop_QA_V(ntryL,G2H8(15),ex2(:),G2H4(11),m3h2x4(:,21),heltab2x8(:,:,37))
  call Hloop_QA_V(ntryL,G2H8(16),ex2(:),G2H4(12),m3h2x4(:,22),heltab2x8(:,:,38))
  call Hloop_QS_A(ntryL,G1H4(5),ex5(:),G1H4(17),ngH,m3h1x4(:,1),heltab2x4(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(17),53,nMT,G2H4(13),n2h4(7))
call HGT_OLR(G1H4(6),1,1,4)
call HGT_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(6),-8,0,G2H4(14),n2h4(8))
  call Hloop_QA_V(ntryL,G2H4(14),ex4(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,6))
  call Hloop_QS_A(ntryL,G1H4(9),ex5(:),G1H4(5),ngH,m3h1x4(:,2),heltab2x4(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(5),53,nMT,G2H4(14),n2h4(9))
  call Hloop_QS_A(ntryL,G1H4(10),ex5(:),G1H4(17),ngH,m3h1x4(:,3),heltab2x4(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(17),53,nMT,G2H4(15),n2h4(10))
  call Hloop_AS_Q(ntryL,G1H4(11),ex5(:),G1H4(6),ngH,m3h1x4(:,4),heltab2x4(:,:,9))
  call Hloop_A_Q(ntryL,G1H4(6),54,nMT,G2H4(16),n2h4(11))
call HGT_OLR(G1H4(12),1,1,4)
call HGT_invQ_OLR(G1H4(12),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(12),-8,0,G2H4(17),n2h4(12))
  call Hloop_QA_V(ntryL,G2H4(17),ex4(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,10))
  call Hloop_AS_Q(ntryL,G1H4(15),ex5(:),G1H4(9),ngH,m3h1x4(:,5),heltab2x4(:,:,11))
  call Hloop_A_Q(ntryL,G1H4(9),54,nMT,G2H4(17),n2h4(13))
  call Hloop_AS_Q(ntryL,G1H4(16),ex5(:),G1H4(5),ngH,m3h1x4(:,6),heltab2x4(:,:,12))
  call Hloop_A_Q(ntryL,G1H4(5),54,nMT,G2H4(18),n2h4(14))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(5),mass5set(:,3),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),16,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(6),mass5set(:,3),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),16,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(7),mass5set(:,3),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),16,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(8),mass5set(:,3),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),16,2)
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(10),G1H4(17),G1H4(11),G1H4(6),G1H4(12),G1H4(15),4)
  call HG1shiftOLR(G1H4(17),8,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(9),mass5set(:,1),  & 
G1H4(9),G1H4(16),G1H4(5),G1H4(18),G1H4(19),G1H4(20),4)
  call HG1shiftOLR(G1H4(16),8,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(1),mass5set(:,1),  & 
G1H4(21),G1H4(22),G1H4(23),G1H4(24),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(22),4,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(10),mass5set(:,1),  & 
G1H4(27),G1H4(28),G1H4(29),G1H4(30),G1H4(31),G1H4(32),4)
  call HG1shiftOLR(G1H4(28),4,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(2),mass5set(:,1),  & 
G1H4(33),G1H4(34),G1H4(35),G1H4(36),G1H4(37),G1H4(38),4)
  call HG1shiftOLR(G1H4(34),8,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(11),mass5set(:,1),  & 
G1H4(39),G1H4(40),G1H4(41),G1H4(42),G1H4(43),G1H4(44),4)
  call HG1shiftOLR(G1H4(40),8,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(2),mass5set(:,1),  & 
G1H4(45),G1H4(46),G1H4(47),G1H4(48),G1H4(49),G1H4(50),4)
  call HG1shiftOLR(G1H4(46),4,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(12),mass5set(:,1),  & 
G1H4(51),G1H4(52),G1H4(53),G1H4(54),G1H4(55),G1H4(56),4)
  call HG1shiftOLR(G1H4(52),4,4)
  call Hloop_QA_V(ntryL,G2H4(13),ex2(:),G2H2(1),m3h2x2(:,7),heltab2x4(:,:,13))
  call Hloop_QA_V(ntryL,G2H4(15),ex2(:),G2H2(2),m3h2x2(:,8),heltab2x4(:,:,14))
  call Hloop_AQ_V(ntryL,G2H4(16),ex1(:),G2H2(3),m3h2x2(:,9),heltab2x4(:,:,15))
  call Hloop_AQ_V(ntryL,G2H4(18),ex1(:),G2H2(4),m3h2x2(:,10),heltab2x4(:,:,16))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(9),[G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(27),[G1H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(39),[G1H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(51),[G1H4(50)])
  call Hloop_VQ_A(ntryL,G1H2(1),ex1(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMT,G2H1(1),n2h1(1))
call HGT_OLR(G1H2(2),1,1,2)
call HGT_invQ_OLR(G1H2(2),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(2),-16,nMT,G2H2(7),n2h2(1))
  call Hloop_AS_Q(ntryL,G2H2(7),ex5(:),G2H2(8),ngH,m3h1x2(:,1),heltab2x2(:,:,2))
  call Hloop_VQ_A(ntryL,G1H2(6),ex1(:),G1H1(1),m3h2x1(:,2),heltab2x2(:,:,3))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMT,G2H1(2),n2h1(2))
  call Hloop_VA_Q(ntryL,G1H2(7),ex2(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,4))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMT,G2H1(3),n2h1(3))
call HGT_OLR(G1H2(8),1,1,2)
call HGT_invQ_OLR(G1H2(8),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(8),-16,nMT,G2H2(7),n2h2(2))
  call Hloop_QS_A(ntryL,G2H2(7),ex5(:),G2H2(9),ngH,m3h1x2(:,2),heltab2x2(:,:,5))
  call Hloop_VA_Q(ntryL,G1H2(12),ex2(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,6))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMT,G2H1(4),n2h1(4))
  call Hloop_VQ_A(ntryL,G1H2(13),ex1(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,7))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMT,G2H1(5),n2h1(5))
call HGT_OLR(G1H2(14),1,1,2)
call HGT_invQ_OLR(G1H2(14),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(14),-16,nMT,G2H2(7),n2h2(3))
  call Hloop_AS_Q(ntryL,G2H2(7),ex5(:),G2H2(10),ngH,m3h1x2(:,3),heltab2x2(:,:,8))
  call Hloop_VQ_A(ntryL,G1H2(18),ex1(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,9))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMT,G2H1(6),n2h1(6))
  call Hloop_VA_Q(ntryL,G1H2(19),ex2(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,10))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMT,G2H1(7),n2h1(7))
call HGT_OLR(G1H2(20),1,1,2)
call HGT_invQ_OLR(G1H2(20),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(20),-16,nMT,G2H2(7),n2h2(4))
  call Hloop_QS_A(ntryL,G2H2(7),ex5(:),G2H2(11),ngH,m3h1x2(:,4),heltab2x2(:,:,11))
  call Hloop_VA_Q(ntryL,G1H2(24),ex2(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,12))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMT,G2H1(8),n2h1(8))
  call Hloop_VQ_A(ntryL,G1H4(10),ex3(:),G1H2(1),m3h2x2(:,11),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(7),n2h2(5))
call HGT_raise_alpha_OLR(G1H4(17),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(17),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(17),ex4(:),G1H2(2),m3h2x2(:,12),heltab2x4(:,:,18))
  call Hloop_VQ_A(ntryL,G1H4(9),ex3(:),G1H2(6),m3h2x2(:,13),heltab2x4(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(6),55,0,G2H2(12),n2h2(6))
call HGT_raise_alpha_OLR(G1H4(16),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(16),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(16),ex4(:),G1H2(7),m3h2x2(:,14),heltab2x4(:,:,20))
  call Hloop_VQ_A(ntryL,G1H4(20),ex3(:),G1H2(8),m3h2x2(:,15),heltab2x4(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(8),55,0,G2H2(13),n2h2(7))
  call Hloop_VA_Q(ntryL,G1H4(21),ex4(:),G1H2(12),m3h2x2(:,16),heltab2x4(:,:,22))
  call Hloop_A_Q(ntryL,G1H2(12),59,0,G2H2(14),n2h2(8))
call HGT_raise_alpha_OLR(G1H4(22),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(22),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(22),ex3(:),G1H2(13),m3h2x2(:,17),heltab2x4(:,:,23))
  call Hloop_VA_Q(ntryL,G1H4(27),ex4(:),G1H2(14),m3h2x2(:,18),heltab2x4(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(14),59,0,G2H2(15),n2h2(9))
call HGT_raise_alpha_OLR(G1H4(28),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(28),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(28),ex3(:),G1H2(18),m3h2x2(:,19),heltab2x4(:,:,25))
  call Hloop_VA_Q(ntryL,G1H4(32),ex4(:),G1H2(19),m3h2x2(:,20),heltab2x4(:,:,26))
  call Hloop_A_Q(ntryL,G1H2(19),59,0,G2H2(16),n2h2(10))
  call Hloop_VQ_A(ntryL,G1H4(33),ex3(:),G1H2(20),m3h2x2(:,21),heltab2x4(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(20),55,0,G2H2(17),n2h2(11))
call HGT_raise_alpha_OLR(G1H4(34),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(34),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(34),ex4(:),G1H2(24),m3h2x2(:,22),heltab2x4(:,:,28))
  call Hloop_VQ_A(ntryL,G1H4(39),ex3(:),G1H2(1),m3h2x2(:,23),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(18),n2h2(12))
call HGT_raise_alpha_OLR(G1H4(40),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(40),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(40),ex4(:),G1H2(6),m3h2x2(:,24),heltab2x4(:,:,30))
  call Hloop_VQ_A(ntryL,G1H4(44),ex3(:),G1H2(8),m3h2x2(:,25),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(8),55,0,G2H2(19),n2h2(13))
  call Hloop_VA_Q(ntryL,G1H4(45),ex4(:),G1H2(12),m3h2x2(:,26),heltab2x4(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(12),59,0,G2H2(20),n2h2(14))
call HGT_raise_alpha_OLR(G1H4(46),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(46),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(46),ex3(:),G1H2(14),m3h2x2(:,27),heltab2x4(:,:,33))
  call Hloop_VA_Q(ntryL,G1H4(51),ex4(:),G1H2(19),m3h2x2(:,28),heltab2x4(:,:,34))
  call Hloop_A_Q(ntryL,G1H2(19),59,0,G2H2(21),n2h2(15))
call HGT_raise_alpha_OLR(G1H4(52),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(52),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(52),ex3(:),G1H2(20),m3h2x2(:,29),heltab2x4(:,:,35))
  call Hloop_VA_Q(ntryL,G1H4(56),ex4(:),G1H2(1),m3h2x2(:,30),heltab2x4(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(1),59,0,G2H2(22),n2h2(16))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(3),mass5set(:,2),  & 
G1H2(8),G1H2(12),G1H2(19),G1H2(1),G1H2(25),G1H2(26),2)
  call HG1shiftOLR(G1H2(12),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(4),mass5set(:,2),  & 
G1H2(27),G1H2(28),G1H2(29),G1H2(30),G1H2(31),G1H2(32),2)
  call HG1shiftOLR(G1H2(28),8,2)
  call Hotf_5pt_reduction(G2H1(1),RedSet_5(5),mass5set(:,3),  & 
G1H1(1),G1H1(2),G1H1(3),G1H1(4),G1H1(5),G1H1(6),1)
  call HG1shiftOLR(G1H1(2),16,1)
  call Hotf_5pt_reduction(G2H1(3),RedSet_5(6),mass5set(:,3),  & 
G1H1(7),G1H1(8),G1H1(9),G1H1(10),G1H1(11),G1H1(12),1)
  call HG1shiftOLR(G1H1(8),16,1)
  call Hotf_5pt_reduction(G2H1(5),RedSet_5(7),mass5set(:,3),  & 
G1H1(13),G1H1(14),G1H1(15),G1H1(16),G1H1(17),G1H1(18),1)
  call HG1shiftOLR(G1H1(14),16,1)
  call Hotf_5pt_reduction(G2H1(7),RedSet_5(8),mass5set(:,3),  & 
G1H1(19),G1H1(20),G1H1(21),G1H1(22),G1H1(23),G1H1(24),1)
  call HG1shiftOLR(G1H1(20),16,1)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(7),ex4(:),G2tensor(1),m3h2x1(:,9),heltab2x2(:,:,13))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(14),ex3(:),G2tensor(2),m3h2x1(:,10),heltab2x2(:,:,14))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(17),ex4(:),G2tensor(3),m3h2x1(:,11),heltab2x2(:,:,15))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(20),ex3(:),G2tensor(4),m3h2x1(:,12),heltab2x2(:,:,16))
  call Hloop_VA_Q(ntryL,G1H2(8),ex4(:),G1H1(25),m3h2x1(:,13),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(25),63,0,G2tensor(5),n2h1(9))
  call Hloop_VA_Q(ntryL,G1H2(12),ex4(:),G1H1(25),m3h2x1(:,14),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(25),8,0,G2tensor(6),n2h1(10))
  call Hloop_VA_Q(ntryL,G1H2(27),ex4(:),G1H1(25),m3h2x1(:,15),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(25),63,0,G2tensor(7),n2h1(11))
  call Hloop_VA_Q(ntryL,G1H2(28),ex4(:),G1H1(25),m3h2x1(:,16),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(25),8,0,G2tensor(8),n2h1(12))
  call Hloop_QS_A(ntryL,G1H1(1),ex5(:),G1H1(25),ngH,m3h1x1(:,1),heltab2x1(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(25),63,nMT,G2tensor(9),n2h1(13))
  call Hloop_QS_A(ntryL,G1H1(2),ex5(:),G1H1(1),ngH,m3h1x1(:,2),heltab2x1(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(10),n2h1(14))
  call Hloop_AS_Q(ntryL,G1H1(7),ex5(:),G1H1(25),ngH,m3h1x1(:,3),heltab2x1(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(25),63,nMT,G2tensor(11),n2h1(15))
  call Hloop_AS_Q(ntryL,G1H1(8),ex5(:),G1H1(2),ngH,m3h1x1(:,4),heltab2x1(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),16,nMT,G2tensor(12),n2h1(16))
  call Hloop_QS_A(ntryL,G1H1(13),ex5(:),G1H1(1),ngH,m3h1x1(:,5),heltab2x1(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(13),n2h1(17))
  call Hloop_QS_A(ntryL,G1H1(14),ex5(:),G1H1(7),ngH,m3h1x1(:,6),heltab2x1(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(7),16,nMT,G2tensor(14),n2h1(18))
  call Hloop_AS_Q(ntryL,G1H1(19),ex5(:),G1H1(25),ngH,m3h1x1(:,7),heltab2x1(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(25),63,nMT,G2tensor(15),n2h1(19))
  call Hloop_AS_Q(ntryL,G1H1(20),ex5(:),G1H1(8),ngH,m3h1x1(:,8),heltab2x1(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(8),16,nMT,G2tensor(16),n2h1(20))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(1),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),4)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(2),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),4)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(3),mass5set(:,2),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(4),mass5set(:,2),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(5),mass5set(:,3),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),16)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(6),mass5set(:,3),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),16)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(7),mass5set(:,3),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),16)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(8),mass5set(:,3),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),16)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(2,:)%j+c(17)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[32,2,1,16,12],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(1),n2h16(7))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(3,:)%j+c(17)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[32,12,2,1,16],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(2),n2h16(8))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(3,:)%j+c(17)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[32,1,2,16,12],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(3),n2h16(9))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(3,:)%j+c(17)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[32,1,2,12,16],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(4),n2h16(10))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(2,:)%j+c(17)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[32,12,1,2,16],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(5),n2h16(11))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(2,:)%j+c(17)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[32,2,1,12,16],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(6),n2h16(12))
  Gcoeff(:)%j = (c(22)*M(3,:)%j+c(17)*(-M(1,:)%j+M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[32,1,16,2,12],[0,nMT,nMT,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(7),m3h2x16(:,17),heltab2x32(:,:,17))
  Gcoeff(:)%j = (c(7)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[32,1,16,12,2],[0,nMT,nMT,nMT,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(8),m3h2x16(:,18),heltab2x32(:,:,18))
  Gcoeff(:)%j = (c(22)*M(2,:)%j+c(17)*(-M(1,:)%j+M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[32,2,16,1,12],[0,nMT,nMT,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(9),m3h2x16(:,19),heltab2x32(:,:,19))
  Gcoeff(:)%j = (c(7)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[32,2,12,1,16],[nMT,0,0,nMT,nMT],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(10),n2h16(13))
  Gcoeff(:)%j = (c(7)*M(4,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[32,1,12,16,2],[0,nMT,nMT,nMT,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(11),m3h2x16(:,21),heltab2x32(:,:,21))
  Gcoeff(:)%j = (-(c(7)*M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[32,1,12,2,16],[nMT,0,0,nMT,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(12),n2h16(14))
  Gcoeff(:)%j = (c(13)*M(1,:)%j+c(14)*(-M(2,:)%j-M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[32,2,4,8,17],[nMT,0,0,0,nMT],5,1,wf2(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(13),n2h16(15))
  Gcoeff(:)%j = (c(6)*M(2,:)%j+c(8)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[32,8,4,2,17],[0,0,0,nMT,0],5,1,wf2(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(14),m3h2x16(:,24),heltab2x32(:,:,24))
  Gcoeff(:)%j = (c(14)*(-M(2,:)%j-M(3,:)%j)+c(13)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[32,4,2,17,8],[0,0,nMT,0,0],5,1,wf2(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(15),n2h16(16))
  Gcoeff(:)%j = (c(13)*M(1,:)%j+c(14)*(-M(2,:)%j-M(3,:)%j)+c(17)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[32,2,8,4,17],[nMT,0,0,0,nMT],5,1,wf2(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(16),n2h16(17))
  Gcoeff(:)%j = (c(6)*(M(2,:)%j-M(3,:)%j)+c(7)*(M(1,:)%j-M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[32,4,8,2,17],[0,0,0,nMT,0],5,1,wf2(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(17),m3h2x16(:,27),heltab2x32(:,:,27))
  Gcoeff(:)%j = (c(17)*M(1,:)%j+c(14)*(-M(2,:)%j-M(3,:)%j)+c(13)*M(4,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[32,4,17,2,8],[0,0,nMT,0,0],5,1,wf2(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(18),n2h16(18))
  Gcoeff(:)%j = (c(8)*M(2,:)%j+c(6)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[32,2,17,8,4],[0,nMT,0,0,0],5,1,wf2(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(19),m3h2x16(:,29),heltab2x32(:,:,29))
  Gcoeff(:)%j = (c(6)*(-M(2,:)%j+M(3,:)%j)+c(7)*(M(1,:)%j-M(4,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[32,2,17,4,8],[0,nMT,0,0,0],5,1,wf2(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(20),m3h2x16(:,30),heltab2x32(:,:,30))
  Gcoeff(:)%j = (c(13)*M(1,:)%j+c(14)*(-M(2,:)%j-M(3,:)%j)+c(17)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[32,1,4,8,18],[nMT,0,0,0,nMT],5,1,wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,31),heltab2x32(:,:,31))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(21),n2h16(19))
  Gcoeff(:)%j = (c(6)*(M(2,:)%j-M(3,:)%j)+c(7)*(-M(1,:)%j+M(4,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[32,8,4,1,18],[0,0,0,nMT,0],5,1,wf2(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(22),m3h2x16(:,32),heltab2x32(:,:,32))
  Gcoeff(:)%j = (c(17)*M(1,:)%j+c(14)*(-M(2,:)%j-M(3,:)%j)+c(13)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(33),h0tab(:,33),[32,4,1,18,8],[0,0,nMT,0,0],5,1,wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,33),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(23),n2h16(20))
  Gcoeff(:)%j = (c(13)*M(1,:)%j+c(14)*(-M(2,:)%j-M(3,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(34),h0tab(:,34),[32,1,8,4,18],[nMT,0,0,0,nMT],5,1,wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,34),heltab2x32(:,:,34))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(24),n2h16(21))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)-c(6)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(35),h0tab(:,35),[32,4,8,1,18],[0,0,0,nMT,0],5,1,wf2(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(25),m3h2x16(:,35),heltab2x32(:,:,35))
  Gcoeff(:)%j = (c(14)*(-M(2,:)%j-M(3,:)%j)+c(13)*M(4,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(36),h0tab(:,36),[32,4,18,1,8],[0,0,nMT,0,0],5,1,wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(26),n2h16(22))
  Gcoeff(:)%j = (c(6)*(-M(2,:)%j+M(3,:)%j)+c(7)*(-M(1,:)%j+M(4,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(37),h0tab(:,37),[32,1,18,8,4],[0,nMT,0,0,0],5,1,wf2(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(27),m3h2x16(:,37),heltab2x32(:,:,37))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)-c(8)*M(3,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(38),h0tab(:,38),[32,1,18,4,8],[0,nMT,0,0,0],5,1,wf2(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(28),m3h2x16(:,38),heltab2x32(:,:,38))
  Gcoeff(:)%j = (c(13)*M(1,:)%j+c(20)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(39),h0tab(:,39),[33,8,4,2,16],[0,0,0,nMT,nMT],5,1,wf4(:,7))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,7),G0H8(1),m3h4x8(:,1),heltab2x32(:,:,39))
  Gcoeff(:)%j = (c(18)*M(1,:)%j-c(15)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(40),h0tab(:,40),[33,4,8,2,16],[0,0,0,nMT,nMT],5,1,wf4(:,7))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,7),G0H8(2),m3h4x8(:,2),heltab2x32(:,:,40))
  Gcoeff(:)%j = (c(18)*M(1,:)%j-c(15)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(41),h0tab(:,41),[34,8,4,1,16],[0,0,0,nMT,nMT],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,3),G0H8(3),m3h4x8(:,3),heltab2x32(:,:,41))
  Gcoeff(:)%j = (c(13)*M(1,:)%j+c(20)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(42),h0tab(:,42),[34,4,8,1,16],[0,0,0,nMT,nMT],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,3),G0H8(4),m3h4x8(:,4),heltab2x32(:,:,42))
  Gcoeff(:)%j = (c(20)*M(2,:)%j+c(13)*M(4,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(43),h0tab(:,43),[36,2,16,1,8],[0,nMT,nMT,0,0],5,1,wf4(:,13))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,13),G0H8(5),m3h4x8(:,5),heltab2x32(:,:,43))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)+c(18)*M(4,:)%j) * den(23)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(44),h0tab(:,44),[36,1,16,2,8],[0,nMT,nMT,0,0],5,1,wf4(:,13))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,13),G0H8(6),m3h4x8(:,6),heltab2x32(:,:,44))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)+c(18)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(45),h0tab(:,45),[40,2,16,1,4],[0,nMT,nMT,0,0],5,1,wf4(:,15))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,15),G0H8(7),m3h4x8(:,7),heltab2x32(:,:,45))
  Gcoeff(:)%j = (c(20)*M(3,:)%j+c(13)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(46),h0tab(:,46),[40,1,16,2,4],[0,nMT,nMT,0,0],5,1,wf4(:,15))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,15),G0H8(8),m3h4x8(:,8),heltab2x32(:,:,46))
  call Hloop_AS_Q(ntryL,G1H8(2),ex5(:),G1H8(9),ngH,m3h1x8(:,17),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G1H8(9),50,nMT,G2H8(1),n2h8(25))
  call Hloop_AS_Q(ntryL,G1H8(5),ex5(:),G1H8(13),ngH,m3h1x8(:,18),heltab2x8(:,:,40))
  call Hloop_A_Q(ntryL,G1H8(13),50,nMT,G2H8(3),n2h8(26))
  call Hloop_QS_A(ntryL,G1H8(15),ex5(:),G1H8(25),ngH,m3h1x8(:,19),heltab2x8(:,:,41))
  call Hloop_Q_A(ntryL,G1H8(25),49,nMT,G2H8(4),n2h8(27))
  call Hloop_QS_A(ntryL,G1H8(21),ex5(:),G1H8(6),ngH,m3h1x8(:,20),heltab2x8(:,:,42))
  call Hloop_Q_A(ntryL,G1H8(6),49,nMT,G2H8(5),n2h8(28))
  call Hloop_QA_V(ntryL,G1H16(1),ex2(:),G1H8(10),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_QV_A(ntryL,G1H16(2),wf4(:,2),G1H4(15),m3h4x4(:,1),heltab2x16(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(15),44,nMT,G2H4(1),n2h4(23))
  call Hloop_AQ_V(ntryL,G1H16(3),ex1(:),G1H8(14),m3h2x8(:,12),heltab2x16(:,:,13))
  call Hloop_AQ_V(ntryL,G1H16(4),ex1(:),G1H8(16),m3h2x8(:,13),heltab2x16(:,:,14))
  call Hloop_AV_Q(ntryL,G1H16(5),wf4(:,2),G1H4(26),m3h4x4(:,2),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G1H4(26),44,nMT,G2H4(3),n2h4(24))
  call Hloop_QA_V(ntryL,G1H16(6),ex2(:),G1H8(1),m3h2x8(:,14),heltab2x16(:,:,16))
  call Hloop_VQ_A(ntryL,G1H16(7),ex1(:),G1H8(17),m3h2x8(:,15),heltab2x16(:,:,17))
  call Hloop_Q_A(ntryL,G1H8(17),33,nMT,G2H8(7),n2h8(29))
  call Hloop_VQ_A(ntryL,G1H16(8),ex1(:),G1H8(3),m3h2x8(:,16),heltab2x16(:,:,18))
  call Hloop_Q_A(ntryL,G1H8(3),33,nMT,G2H8(8),n2h8(30))
  call Hloop_VA_Q(ntryL,G1H16(9),ex2(:),G1H8(18),m3h2x8(:,17),heltab2x16(:,:,19))
  call Hloop_A_Q(ntryL,G1H8(18),34,nMT,G2H8(9),n2h8(31))
  call Hloop_QA_V(ntryL,G1H16(10),ex2(:),G1H8(8),m3h2x8(:,18),heltab2x16(:,:,20))
  call Hloop_VQ_A(ntryL,G1H16(11),ex1(:),G1H8(19),m3h2x8(:,19),heltab2x16(:,:,21))
  call Hloop_Q_A(ntryL,G1H8(19),33,nMT,G2H8(11),n2h8(32))
  call Hloop_AQ_V(ntryL,G1H16(12),ex1(:),G1H8(4),m3h2x8(:,20),heltab2x16(:,:,22))
  call Hloop_QA_V(ntryL,G1H16(13),ex2(:),G1H8(20),m3h2x8(:,21),heltab2x16(:,:,23))
  call Hloop_VA_Q(ntryL,G1H16(14),ex4(:),G1H8(22),m3h2x8(:,22),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G1H8(22),40,0,G2H8(12),n2h8(33))
  call Hloop_AQ_V(ntryL,G1H16(15),ex3(:),G1H8(11),m3h2x8(:,23),heltab2x16(:,:,25))
  call Hloop_QA_V(ntryL,G1H16(16),ex2(:),G1H8(23),m3h2x8(:,24),heltab2x16(:,:,26))
  call Hloop_VQ_A(ntryL,G1H16(17),ex3(:),G1H8(7),m3h2x8(:,25),heltab2x16(:,:,27))
  call Hloop_Q_A(ntryL,G1H8(7),36,0,G2H8(13),n2h8(34))
  call Hloop_AQ_V(ntryL,G1H16(18),ex3(:),G1H8(24),m3h2x8(:,26),heltab2x16(:,:,28))
  call Hloop_VA_Q(ntryL,G1H16(19),ex2(:),G1H8(12),m3h2x8(:,27),heltab2x16(:,:,29))
  call Hloop_A_Q(ntryL,G1H8(12),34,nMT,G2H8(15),n2h8(35))
  call Hloop_VA_Q(ntryL,G1H16(20),ex2(:),G1H8(2),m3h2x8(:,28),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G1H8(2),34,nMT,G2H8(16),n2h8(36))
  call Hloop_AQ_V(ntryL,G1H16(21),ex1(:),G1H8(9),m3h2x8(:,29),heltab2x16(:,:,31))
  call Hloop_VA_Q(ntryL,G1H16(22),ex4(:),G1H8(5),m3h2x8(:,30),heltab2x16(:,:,32))
  call Hloop_A_Q(ntryL,G1H8(5),40,0,G2H8(17),n2h8(37))
  call Hloop_AQ_V(ntryL,G1H16(23),ex3(:),G1H8(13),m3h2x8(:,31),heltab2x16(:,:,33))
  call Hloop_AQ_V(ntryL,G1H16(24),ex1(:),G1H8(15),m3h2x8(:,32),heltab2x16(:,:,34))
  call Hloop_VQ_A(ntryL,G1H16(25),ex3(:),G1H8(25),m3h2x8(:,33),heltab2x16(:,:,35))
  call Hloop_Q_A(ntryL,G1H8(25),36,0,G2H8(18),n2h8(38))
  call Hloop_AQ_V(ntryL,G1H16(26),ex3(:),G1H8(21),m3h2x8(:,34),heltab2x16(:,:,36))
  call Hloop_VQ_A(ntryL,G1H16(27),ex1(:),G1H8(6),m3h2x8(:,35),heltab2x16(:,:,37))
  call Hloop_Q_A(ntryL,G1H8(6),33,nMT,G2H8(19),n2h8(39))
  call Hloop_VQ_A(ntryL,G1H16(28),ex1(:),G1H8(17),m3h2x8(:,36),heltab2x16(:,:,38))
  call Hloop_Q_A(ntryL,G1H8(17),33,nMT,G2H8(20),n2h8(40))
  call Hloop_VA_Q(ntryL,G0H8(1),ex4(:),G0H4(1),m3h2x4(:,23),heltab2x8(:,:,43))
  call Hloop_A_Q(ntryL,G0H4(1),41,0,G1H4(38),n2h4(25))
  call Hloop_VQ_A(ntryL,G0H8(2),ex3(:),G0H4(1),m3h2x4(:,24),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G0H4(1),37,0,G1H4(50),n2h4(26))
  call Hloop_VA_Q(ntryL,G0H8(3),ex4(:),G0H4(1),m3h2x4(:,25),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G0H4(1),42,0,G1H4(10),n2h4(27))
  call Hloop_VQ_A(ntryL,G0H8(4),ex3(:),G0H4(1),m3h2x4(:,26),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G0H4(1),38,0,G1H4(17),n2h4(28))
  call Hloop_VA_Q(ntryL,G0H8(5),ex2(:),G0H4(1),m3h2x4(:,27),heltab2x8(:,:,47))
  call Hloop_A_Q(ntryL,G0H4(1),38,nMT,G1H4(9),n2h4(29))
  call Hloop_VQ_A(ntryL,G0H8(6),ex1(:),G0H4(1),m3h2x4(:,28),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G0H4(1),37,nMT,G1H4(16),n2h4(30))
  call Hloop_VA_Q(ntryL,G0H8(7),ex2(:),G0H4(1),m3h2x4(:,29),heltab2x8(:,:,49))
  call Hloop_A_Q(ntryL,G0H4(1),42,nMT,G1H4(20),n2h4(31))
  call Hloop_VQ_A(ntryL,G0H8(8),ex1(:),G0H4(1),m3h2x4(:,30),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G0H4(1),41,nMT,G1H4(21),n2h4(32))
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G1H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(9),[G1H4(13)])
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(9)])
call HGT_w2_OLR(G1H4(3),1,1,4)
call HGT_w2_invQ_OLR(G1H4(3),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(3),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(16),[G1H4(7)])
call HGT_w2_OLR(G1H4(4),1,1,4)
call HGT_w2_invQ_OLR(G1H4(4),2,5,4)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(4),[G1H4(16)])
  call Hloop_AS_Q(ntryL,G1H4(1),ex5(:),G1H4(22),ngH,m3h1x4(:,7),heltab2x4(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(22),58,nMT,G2H4(4),n2h4(33))
  call Hloop_AQ_V(ntryL,G2H8(2),ex1(:),G2H4(6),m3h2x4(:,31),heltab2x8(:,:,51))
  call Hloop_AS_Q(ntryL,G1H4(2),ex5(:),G1H4(27),ngH,m3h1x4(:,8),heltab2x4(:,:,38))
  call Hloop_A_Q(ntryL,G1H4(27),54,nMT,G2H4(7),n2h4(34))
  call Hloop_AQ_V(ntryL,G2H8(6),ex1(:),G2H4(9),m3h2x4(:,32),heltab2x8(:,:,52))
  call Hloop_QS_A(ntryL,G1H4(3),ex5(:),G1H4(28),ngH,m3h1x4(:,9),heltab2x4(:,:,39))
  call Hloop_Q_A(ntryL,G1H4(28),57,nMT,G2H4(10),n2h4(35))
  call Hloop_QA_V(ntryL,G2H8(10),ex2(:),G2H4(12),m3h2x4(:,33),heltab2x8(:,:,53))
  call Hloop_QS_A(ntryL,G1H4(4),ex5(:),G1H4(32),ngH,m3h1x4(:,10),heltab2x4(:,:,40))
  call Hloop_Q_A(ntryL,G1H4(32),53,nMT,G2H4(13),n2h4(36))
  call Hloop_QA_V(ntryL,G2H8(14),ex2(:),G2H4(15),m3h2x4(:,34),heltab2x8(:,:,54))
  call Hloop_QS_A(ntryL,G1H4(8),ex5(:),G1H4(33),ngH,m3h1x4(:,11),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H4(33),53,nMT,G2H4(16),n2h4(37))
  call Hloop_AS_Q(ntryL,G1H4(14),ex5(:),G1H4(34),ngH,m3h1x4(:,12),heltab2x4(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(34),54,nMT,G2H4(18),n2h4(38))
  call Hloop_AQ_V(ntryL,G2H8(1),ex1(:),G2H4(19),m3h2x4(:,35),heltab2x8(:,:,55))
  call Hloop_AQ_V(ntryL,G2H8(3),ex1(:),G2H4(20),m3h2x4(:,36),heltab2x8(:,:,56))
  call Hloop_QA_V(ntryL,G2H8(4),ex2(:),G2H4(21),m3h2x4(:,37),heltab2x8(:,:,57))
  call Hloop_QA_V(ntryL,G2H8(5),ex2(:),G2H4(22),m3h2x4(:,38),heltab2x8(:,:,58))
  call Hloop_VQ_A(ntryL,G1H8(10),ex1(:),G1H4(39),m3h2x4(:,39),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G1H4(39),35,nMT,G2H4(23),n2h4(39))
  call Hloop_QA_V(ntryL,G2H4(1),ex2(:),G2H2(1),m3h2x2(:,31),heltab2x4(:,:,43))
  call Hloop_VA_Q(ntryL,G1H8(14),ex2(:),G1H4(40),m3h2x4(:,40),heltab2x8(:,:,60))
  call Hloop_A_Q(ntryL,G1H4(40),35,nMT,G2H4(1),n2h4(40))
  call Hloop_VA_Q(ntryL,G1H8(16),ex2(:),G1H4(44),m3h2x4(:,41),heltab2x8(:,:,61))
  call Hloop_A_Q(ntryL,G1H4(44),35,nMT,G2H4(24),n2h4(41))
  call Hloop_AQ_V(ntryL,G2H4(3),ex1(:),G2H2(3),m3h2x2(:,32),heltab2x4(:,:,44))
  call Hloop_VQ_A(ntryL,G1H8(1),ex1(:),G1H4(45),m3h2x4(:,42),heltab2x8(:,:,62))
  call Hloop_Q_A(ntryL,G1H4(45),35,nMT,G2H4(3),n2h4(42))
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(2),mass5set(:,1),  & 
G1H8(3),G1H8(18),G1H8(19),G1H8(22),G1H8(7),G1H8(12),8)
  call HG1shiftOLR(G1H8(18),12,8)
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(13),mass5set(:,4),  & 
G1H8(2),G1H8(5),G1H8(25),G1H8(6),G1H8(17),G1H8(10),8)
  call HG1shiftOLR(G1H8(5),2,8)
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(1),mass5set(:,1),  & 
G1H8(14),G1H8(16),G1H8(1),G1H8(26),G1H8(27),G1H8(28),8)
  call HG1shiftOLR(G1H8(16),12,8)
  call Hloop_UV_W(ntryL,G1H8(8),34,wf4(:,2),12,G2H2(7),m3h4x2(:,1),heltab2x8(:,:,63))
  call Hotf_5pt_reduction(G2H8(11),RedSet_5(14),mass5set(:,4),  & 
G1H8(8),G1H8(29),G1H8(30),G1H8(31),G1H8(32),G1H8(33),8)
  call HG1shiftOLR(G1H8(29),2,8)
  call Hloop_UV_W(ntryL,G1H8(4),33,wf4(:,2),12,G2H2(14),m3h4x2(:,2),heltab2x8(:,:,64))
  call Hloop_VQ_A(ntryL,G1H8(20),ex3(:),G1H4(46),m3h2x4(:,43),heltab2x8(:,:,65))
  call Hloop_Q_A(ntryL,G1H4(46),38,0,G2H4(25),n2h4(43))
  call Hloop_AQ_V(ntryL,G2H8(12),ex3(:),G2H4(26),m3h2x4(:,44),heltab2x8(:,:,66))
  call Hloop_VA_Q(ntryL,G1H8(11),ex2(:),G1H4(51),m3h2x4(:,45),heltab2x8(:,:,67))
  call Hloop_A_Q(ntryL,G1H4(51),38,nMT,G2H4(27),n2h4(44))
  call Hloop_VA_Q(ntryL,G1H8(23),ex4(:),G1H4(52),m3h2x4(:,46),heltab2x8(:,:,68))
  call Hloop_A_Q(ntryL,G1H4(52),42,0,G2H4(28),n2h4(45))
  call Hloop_QA_V(ntryL,G2H8(13),ex4(:),G2H4(29),m3h2x4(:,47),heltab2x8(:,:,69))
  call Hloop_VQ_A(ntryL,G1H8(24),wf2(:,2),G1H4(56),m3h2x4(:,48),heltab2x8(:,:,70))
  call Hloop_Q_A(ntryL,G1H4(56),53,nMT,G2H4(30),n2h4(46))
  call Hloop_AQ_V(ntryL,G2H8(15),wf2(:,2),G2H4(31),m3h2x4(:,49),heltab2x8(:,:,71))
  call Hloop_AQ_V(ntryL,G2H8(16),wf2(:,2),G2H4(32),m3h2x4(:,50),heltab2x8(:,:,72))
  call Hloop_VQ_A(ntryL,G1H8(9),ex3(:),G1H4(15),m3h2x4(:,51),heltab2x8(:,:,73))
  call Hloop_Q_A(ntryL,G1H4(15),37,0,G2H4(33),n2h4(47))
  call Hloop_AQ_V(ntryL,G2H8(17),ex3(:),G2H4(34),m3h2x4(:,52),heltab2x8(:,:,74))
  call Hloop_VQ_A(ntryL,G1H8(13),ex1(:),G1H4(26),m3h2x4(:,53),heltab2x8(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(26),37,nMT,G2H4(35),n2h4(48))
  call Hloop_VA_Q(ntryL,G1H8(15),ex4(:),G1H4(20),m3h2x4(:,54),heltab2x8(:,:,76))
  call Hloop_A_Q(ntryL,G1H4(20),41,0,G2H4(36),n2h4(49))
  call Hloop_QA_V(ntryL,G2H8(18),ex4(:),G2H4(37),m3h2x4(:,55),heltab2x8(:,:,77))
  call Hloop_VA_Q(ntryL,G1H8(21),wf2(:,4),G1H4(13),m3h2x4(:,56),heltab2x8(:,:,78))
  call Hloop_A_Q(ntryL,G1H4(13),54,nMT,G2H4(38),n2h4(50))
  call Hloop_QA_V(ntryL,G2H8(19),wf2(:,4),G2H4(39),m3h2x4(:,57),heltab2x8(:,:,79))
  call Hloop_QA_V(ntryL,G2H8(20),wf2(:,4),G2H4(40),m3h2x4(:,58),heltab2x8(:,:,80))
  call Hloop_AQ_V(ntryL,G1H4(38),ex3(:),G1H2(8),m3h2x2(:,33),heltab2x4(:,:,45))
  call Hloop_QA_V(ntryL,G1H4(50),ex4(:),G1H2(12),m3h2x2(:,34),heltab2x4(:,:,46))
  call Hloop_AQ_V(ntryL,G1H4(10),ex3(:),G1H2(27),m3h2x2(:,35),heltab2x4(:,:,47))
  call Hloop_QA_V(ntryL,G1H4(17),ex4(:),G1H2(28),m3h2x2(:,36),heltab2x4(:,:,48))
  call Hloop_QS_A(ntryL,G1H8(3),ex5(:),G1H8(4),ngH,m3h1x8(:,21),heltab2x8(:,:,81))
  call Hloop_Q_A(ntryL,G1H8(4),49,nMT,G2H8(2),n2h8(41))
call HGT_raise_alpha_OLR(G1H8(18),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(18),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(18),-12,wf4(:,2),12,G2H2(17),m3h4x2(:,3),heltab2x8(:,:,82))
call signflip_OLR(G2H2(17))
  call Hloop_QS_A(ntryL,G1H8(22),ex5(:),G1H8(20),ngH,m3h1x8(:,22),heltab2x8(:,:,83))
  call Hloop_Q_A(ntryL,G1H8(20),49,nMT,G2H8(6),n2h8(43))
  call Hloop_QS_A(ntryL,G1H8(7),ex5(:),G1H8(11),ngH,m3h1x8(:,23),heltab2x8(:,:,84))
  call Hloop_Q_A(ntryL,G1H8(11),49,nMT,G2H8(10),n2h8(44))
  call Hloop_QS_A(ntryL,G1H8(12),ex5(:),G1H8(23),ngH,m3h1x8(:,24),heltab2x8(:,:,85))
  call Hloop_Q_A(ntryL,G1H8(23),49,nMT,G2H8(14),n2h8(45))
  call Hloop_QS_A(ntryL,G1H8(2),ex5(:),G1H8(24),ngH,m3h1x8(:,25),heltab2x8(:,:,86))
  call Hloop_Q_A(ntryL,G1H8(24),49,nMT,G2H8(1),n2h8(46))
call HGT_raise_alpha_OLR(G1H8(5),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(5),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(5),ex2(:),G1H4(9),m3h2x4(:,59),heltab2x8(:,:,87))
  call Hloop_QS_A(ntryL,G1H8(6),ex5(:),G1H8(9),ngH,m3h1x8(:,26),heltab2x8(:,:,88))
  call Hloop_Q_A(ntryL,G1H8(9),49,nMT,G2H8(3),n2h8(48))
  call Hloop_QS_A(ntryL,G1H8(17),ex5(:),G1H8(13),ngH,m3h1x8(:,27),heltab2x8(:,:,89))
  call Hloop_Q_A(ntryL,G1H8(13),49,nMT,G2H8(4),n2h8(49))
  call Hloop_QS_A(ntryL,G1H8(10),ex5(:),G1H8(15),ngH,m3h1x8(:,28),heltab2x8(:,:,90))
  call Hloop_Q_A(ntryL,G1H8(15),49,nMT,G2H8(5),n2h8(50))
  call Hloop_AS_Q(ntryL,G1H8(14),ex5(:),G1H8(21),ngH,m3h1x8(:,29),heltab2x8(:,:,91))
  call Hloop_A_Q(ntryL,G1H8(21),50,nMT,G2H8(7),n2h8(51))
call HGT_raise_alpha_OLR(G1H8(16),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(16),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(16),-12,wf4(:,2),12,G2H2(20),m3h4x2(:,4),heltab2x8(:,:,92))
call signflip_OLR(G2H2(20))
  call Hloop_AS_Q(ntryL,G1H8(26),ex5(:),G1H8(3),ngH,m3h1x8(:,30),heltab2x8(:,:,93))
  call Hloop_A_Q(ntryL,G1H8(3),50,nMT,G2H8(8),n2h8(53))
  call Hloop_AS_Q(ntryL,G1H8(27),ex5(:),G1H8(4),ngH,m3h1x8(:,31),heltab2x8(:,:,94))
  call Hloop_A_Q(ntryL,G1H8(4),50,nMT,G2H8(9),n2h8(54))
  call Hloop_AS_Q(ntryL,G1H8(28),ex5(:),G1H8(18),ngH,m3h1x8(:,32),heltab2x8(:,:,95))
  call Hloop_A_Q(ntryL,G1H8(18),50,nMT,G2H8(11),n2h8(55))
  call Hloop_QV_A(ntryL,G1H8(8),wf4(:,2),G1H2(33),m3h4x2(:,5),heltab2x8(:,:,96))
  call Hloop_Q_A(ntryL,G1H2(33),45,nMT,G2H2(23),n2h2(17))
call HGT_raise_alpha_OLR(G1H8(29),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(29),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(29),ex2(:),G1H4(21),m3h2x4(:,60),heltab2x8(:,:,97))
  call Hloop_QV_A(ntryL,G1H8(31),wf4(:,2),G1H2(33),m3h4x2(:,6),heltab2x8(:,:,98))
  call Hloop_Q_A(ntryL,G1H2(33),45,nMT,G2H2(24),n2h2(18))
  call Hloop_QV_A(ntryL,G1H8(32),wf4(:,2),G1H2(33),m3h4x2(:,7),heltab2x8(:,:,99))
  call Hloop_Q_A(ntryL,G1H2(33),45,nMT,G2H2(25),n2h2(19))
  call Hloop_QV_A(ntryL,G1H8(33),wf4(:,2),G1H2(33),m3h4x2(:,8),heltab2x8(:,:,100))
  call Hloop_Q_A(ntryL,G1H2(33),45,nMT,G2H2(26),n2h2(20))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(32),[G2H4(2),G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(31),[G2H4(5),G1H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(40),[G2H4(8),G1H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(39),[G2H4(11),G1H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(30),[G2H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(38),[G2H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(27),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G1H2(17),G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(12),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G1H2(23),G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(28),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(8),[G1H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(19),[G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(20),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(21),[G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(22),[G1H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G1H4(48)])
  call Hotf_5pt_reduction(G2H4(32),RedSet_5(15),mass5set(:,5),  & 
G1H4(7),G1H4(16),G1H4(1),G1H4(22),G1H4(2),G1H4(27),4)
  call HG1shiftOLR(G1H4(16),8,4)
  call Hotf_5pt_reduction(G2H4(31),RedSet_5(16),mass5set(:,5),  & 
G1H4(3),G1H4(28),G1H4(4),G1H4(32),G1H4(8),G1H4(33),4)
  call HG1shiftOLR(G1H4(28),4,4)
  call Hotf_5pt_reduction(G2H4(40),RedSet_5(17),mass5set(:,5),  & 
G1H4(14),G1H4(34),G1H4(39),G1H4(40),G1H4(44),G1H4(45),4)
  call HG1shiftOLR(G1H4(34),8,4)
  call Hotf_5pt_reduction(G2H4(39),RedSet_5(18),mass5set(:,5),  & 
G1H4(46),G1H4(51),G1H4(52),G1H4(56),G1H4(15),G1H4(26),4)
  call HG1shiftOLR(G1H4(51),4,4)
call HGT_lower_alpha_w2_OLR(G2H2(5),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(5),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(5),6,15,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(19),mass5set(:,2),  & 
G1H2(33),G1H2(3),G1H2(17),G1H2(5),G1H2(9),G1H2(23),2)
  call HG1shiftOLR(G1H2(3),2,2)
  call Hloop_QA_V(ntryL,G2H4(30),ex2(:),G2H2(5),m3h2x2(:,37),heltab2x4(:,:,49))
call HGT_lower_alpha_w2_OLR(G2H2(6),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(6),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(6),6,15,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(20),mass5set(:,2),  & 
G1H2(11),G1H2(15),G1H2(21),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(15),1,2)
  call Hloop_AQ_V(ntryL,G2H4(38),ex1(:),G2H2(6),m3h2x2(:,38),heltab2x4(:,:,50))
  call Hloop_VQ_A(ntryL,G1H2(27),ex1(:),G1H1(2),m3h2x1(:,17),heltab2x2(:,:,21))
  call Hloop_Q_A(ntryL,G1H1(2),47,nMT,G2H1(1),n2h1(21))
  call Hloop_VQ_A(ntryL,G1H2(4),ex1(:),G1H1(13),m3h2x1(:,18),heltab2x2(:,:,22))
  call Hloop_Q_A(ntryL,G1H1(13),47,nMT,G2H1(3),n2h1(22))
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(21),mass5set(:,6),  & 
G1H2(27),G1H2(4),G1H2(37),G1H2(38),G1H2(39),G1H2(40),2)
  call HG1shiftOLR(G1H2(4),16,2)
  call Hloop_VA_Q(ntryL,G1H2(12),ex2(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,23))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMT,G2H1(5),n2h1(23))
  call Hloop_VA_Q(ntryL,G1H2(10),ex2(:),G1H1(14),m3h2x1(:,20),heltab2x2(:,:,24))
  call Hloop_A_Q(ntryL,G1H1(14),47,nMT,G2H1(7),n2h1(24))
  call Hotf_5pt_reduction(G2H2(14),RedSet_5(22),mass5set(:,6),  & 
G1H2(12),G1H2(10),G1H2(41),G1H2(42),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(10),16,2)
  call Hloop_VQ_A(ntryL,G1H2(28),ex1(:),G1H1(7),m3h2x1(:,21),heltab2x2(:,:,25))
  call Hloop_Q_A(ntryL,G1H1(7),47,nMT,G2H1(9),n2h1(25))
  call Hloop_VQ_A(ntryL,G1H2(16),ex1(:),G1H1(19),m3h2x1(:,22),heltab2x2(:,:,26))
  call Hloop_Q_A(ntryL,G1H1(19),47,nMT,G2H1(10),n2h1(26))
  call Hloop_VA_Q(ntryL,G1H2(8),ex2(:),G1H1(25),m3h2x1(:,23),heltab2x2(:,:,27))
  call Hloop_A_Q(ntryL,G1H1(25),47,nMT,G2H1(11),n2h1(27))
  call Hloop_VA_Q(ntryL,G1H2(22),ex2(:),G1H1(20),m3h2x1(:,24),heltab2x2(:,:,28))
  call Hloop_A_Q(ntryL,G1H1(20),47,nMT,G2H1(12),n2h1(28))
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(23),mass5set(:,7),  & 
G1H4(20),G1H4(13),G1H4(38),G1H4(50),G1H4(10),G1H4(17),4)
  call HG1shiftOLR(G1H4(13),8,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(24),mass5set(:,5),  & 
G1H4(12),G1H4(25),G1H4(37),G1H4(49),G1H4(11),G1H4(6),4)
  call HG1shiftOLR(G1H4(25),8,4)
  call Hloop_VQ_A(ntryL,G1H4(5),ex3(:),G1H2(28),m3h2x2(:,39),heltab2x4(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(28),55,0,G2H2(7),n2h2(21))
  call Hloop_VQ_A(ntryL,G1H4(18),ex3(:),G1H2(16),m3h2x2(:,40),heltab2x4(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(16),55,0,G2H2(14),n2h2(22))
  call Hloop_VQ_A(ntryL,G1H4(19),ex3(:),G1H2(8),m3h2x2(:,41),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(8),55,0,G2H2(27),n2h2(23))
  call Hotf_5pt_reduction(G2H4(20),RedSet_5(25),mass5set(:,7),  & 
G1H4(23),G1H4(24),G1H4(35),G1H4(36),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(24),4,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(26),mass5set(:,5),  & 
G1H4(5),G1H4(18),G1H4(19),G1H4(57),G1H4(58),G1H4(59),4)
  call HG1shiftOLR(G1H4(18),4,4)
  call Hloop_VA_Q(ntryL,G1H4(29),ex4(:),G1H2(22),m3h2x2(:,42),heltab2x4(:,:,54))
  call Hloop_A_Q(ntryL,G1H2(22),59,0,G2H2(28),n2h2(24))
  call Hloop_VA_Q(ntryL,G1H4(30),ex4(:),G1H2(28),m3h2x2(:,43),heltab2x4(:,:,55))
  call Hloop_A_Q(ntryL,G1H2(28),59,0,G2H2(29),n2h2(25))
  call Hloop_VA_Q(ntryL,G1H4(31),ex4(:),G1H2(16),m3h2x2(:,44),heltab2x4(:,:,56))
  call Hloop_A_Q(ntryL,G1H2(16),59,0,G2H2(30),n2h2(26))
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(27),mass5set(:,7),  & 
G1H4(29),G1H4(30),G1H4(31),G1H4(60),G1H4(61),G1H4(62),4)
  call HG1shiftOLR(G1H4(30),8,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(28),mass5set(:,5),  & 
G1H4(63),G1H4(64),G1H4(65),G1H4(66),G1H4(67),G1H4(68),4)
  call HG1shiftOLR(G1H4(64),8,4)
  call Hloop_VQ_A(ntryL,G1H4(41),ex3(:),G1H2(8),m3h2x2(:,45),heltab2x4(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(8),55,0,G2H2(31),n2h2(27))
  call Hloop_VQ_A(ntryL,G1H4(42),ex3(:),G1H2(22),m3h2x2(:,46),heltab2x4(:,:,58))
  call Hloop_Q_A(ntryL,G1H2(22),55,0,G2H2(32),n2h2(28))
  call Hloop_VQ_A(ntryL,G1H4(43),ex3(:),G1H2(28),m3h2x2(:,47),heltab2x4(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(28),55,0,G2H2(33),n2h2(29))
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(29),mass5set(:,7),  & 
G1H4(41),G1H4(42),G1H4(43),G1H4(69),G1H4(70),G1H4(71),4)
  call HG1shiftOLR(G1H4(42),4,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(30),mass5set(:,5),  & 
G1H4(72),G1H4(73),G1H4(74),G1H4(75),G1H4(76),G1H4(77),4)
  call HG1shiftOLR(G1H4(73),4,4)
  call Hloop_VA_Q(ntryL,G1H4(53),ex4(:),G1H2(16),m3h2x2(:,48),heltab2x4(:,:,60))
  call Hloop_A_Q(ntryL,G1H2(16),59,0,G2H2(34),n2h2(30))
  call Hloop_VA_Q(ntryL,G1H4(54),ex4(:),G1H2(8),m3h2x2(:,49),heltab2x4(:,:,61))
  call Hloop_A_Q(ntryL,G1H2(8),59,0,G2H2(35),n2h2(31))
  call Hloop_VA_Q(ntryL,G1H4(55),ex4(:),G1H2(22),m3h2x2(:,50),heltab2x4(:,:,62))
  call Hloop_A_Q(ntryL,G1H2(22),59,0,G2H2(36),n2h2(32))
  call Hloop_AQ_V(ntryL,G2H4(4),ex1(:),G2H2(37),m3h2x2(:,51),heltab2x4(:,:,63))
  call Hloop_AQ_V(ntryL,G2H4(7),ex1(:),G2H2(38),m3h2x2(:,52),heltab2x4(:,:,64))
  call Hloop_QA_V(ntryL,G2H4(10),ex2(:),G2H2(39),m3h2x2(:,53),heltab2x4(:,:,65))
  call Hloop_QA_V(ntryL,G2H4(13),ex2(:),G2H2(40),m3h2x2(:,54),heltab2x4(:,:,66))
  call Hloop_QA_V(ntryL,G2H4(16),ex2(:),G2H2(41),m3h2x2(:,55),heltab2x4(:,:,67))
  call Hloop_AQ_V(ntryL,G2H4(18),ex1(:),G2H2(42),m3h2x2(:,56),heltab2x4(:,:,68))
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(31),mass5set(:,8),  & 
G1H4(53),G1H4(54),G1H4(55),G1H4(78),G1H4(79),G1H4(80),4)
  call HG1shiftOLR(G1H4(54),12,4)
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(32),mass5set(:,9),  & 
G1H2(28),G1H2(16),G1H2(8),G1H2(22),G1H2(45),G1H2(46),2)
  call HG1shiftOLR(G1H2(16),16,2)
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(33),mass5set(:,8),  & 
G1H4(81),G1H4(82),G1H4(83),G1H4(84),G1H4(85),G1H4(86),4)
  call HG1shiftOLR(G1H4(82),12,4)
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(34),mass5set(:,8),  & 
G1H4(87),G1H4(88),G1H4(89),G1H4(90),G1H4(91),G1H4(92),4)
  call HG1shiftOLR(G1H4(88),16,4)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(35),mass5set(:,9),  & 
G1H2(47),G1H2(48),G1H2(49),G1H2(50),G1H2(51),G1H2(52),2)
  call HG1shiftOLR(G1H2(48),16,2)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(36),mass5set(:,8),  & 
G1H4(93),G1H4(94),G1H4(95),G1H4(96),G1H4(97),G1H4(98),4)
  call HG1shiftOLR(G1H4(94),16,4)
  call Hloop_QA_V(ntryL,G2H4(25),ex4(:),G2H2(1),m3h2x2(:,57),heltab2x4(:,:,69))
  call Hotf_5pt_reduction(G2H4(26),RedSet_5(37),mass5set(:,10),  & 
G1H4(99),G1H4(100),G1H4(101),G1H4(102),G1H4(103),G1H4(104),4)
  call HG1shiftOLR(G1H4(100),17,4)
  call Hloop_AQ_V(ntryL,G2H4(27),wf2(:,2),G2H2(3),m3h2x2(:,58),heltab2x4(:,:,70))
  call Hloop_AQ_V(ntryL,G2H4(28),ex3(:),G2H2(43),m3h2x2(:,59),heltab2x4(:,:,71))
  call Hotf_5pt_reduction(G2H4(29),RedSet_5(38),mass5set(:,10),  & 
G1H4(105),G1H4(106),G1H4(107),G1H4(108),G1H4(109),G1H4(110),4)
  call HG1shiftOLR(G1H4(106),17,4)
  call Hloop_QA_V(ntryL,G2H4(33),ex4(:),G2H2(44),m3h2x2(:,60),heltab2x4(:,:,72))
  call Hotf_5pt_reduction(G2H4(34),RedSet_5(39),mass5set(:,10),  & 
G1H4(111),G1H4(112),G1H4(113),G1H4(114),G1H4(115),G1H4(116),4)
  call HG1shiftOLR(G1H4(112),18,4)
  call Hloop_QA_V(ntryL,G2H4(35),wf2(:,4),G2H2(45),m3h2x2(:,61),heltab2x4(:,:,73))
  call Hloop_AQ_V(ntryL,G2H4(36),ex3(:),G2H2(46),m3h2x2(:,62),heltab2x4(:,:,74))
  call Hotf_5pt_reduction(G2H4(37),RedSet_5(40),mass5set(:,10),  & 
G1H4(117),G1H4(118),G1H4(119),G1H4(120),G1H4(121),G1H4(122),4)
  call HG1shiftOLR(G1H4(118),18,4)
  call Hloop_QA_V(ntryL,G2H8(2),ex2(:),G2H4(2),m3h2x4(:,61),heltab2x8(:,:,101))
  call Hloop_QA_V(ntryL,G2H8(10),ex2(:),G2H4(5),m3h2x4(:,62),heltab2x8(:,:,102))
  call Hloop_QA_V(ntryL,G2H8(14),ex2(:),G2H4(8),m3h2x4(:,63),heltab2x8(:,:,103))
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(13),mass5set(:,4),  & 
G1H8(22),G1H8(20),G1H8(7),G1H8(11),G1H8(12),G1H8(23),8)
  call HG1shiftOLR(G1H8(20),2,8)
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(126),mass4set(:,1),  & 
G1H8(2),G1H8(24),G1H8(5),G1H8(6),G1H8(9),8)
  call HG1shiftOLR(G1H8(24),2,8)
  call Hotf_4pt_reduction(G2H8(5),RedSet_4(37),mass4set(:,1),  & 
G1H8(17),G1H8(13),G1H8(10),G1H8(15),G1H8(14),8)
  call HG1shiftOLR(G1H8(13),14,8)
  call Hloop_AQ_V(ntryL,G2H8(7),ex1(:),G2H4(11),m3h2x4(:,64),heltab2x8(:,:,104))
  call Hloop_AQ_V(ntryL,G2H8(9),ex1(:),G2H4(14),m3h2x4(:,65),heltab2x8(:,:,105))
  call Hloop_AQ_V(ntryL,G2H8(11),ex1(:),G2H4(17),m3h2x4(:,66),heltab2x8(:,:,106))
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(14),mass5set(:,4),  & 
G1H2(53),G1H2(54),G1H2(55),G1H2(56),G1H2(57),G1H2(58),2)
  call HG1shiftOLR(G1H2(54),2,2)
  call Hotf_4pt_reduction(G2H2(25),RedSet_4(126),mass4set(:,1),  & 
G1H2(59),G1H2(60),G1H2(61),G1H2(62),G1H2(63),2)
  call HG1shiftOLR(G1H2(60),2,2)
  call Hotf_4pt_reduction(G2H2(26),RedSet_4(101),mass4set(:,1),  & 
G1H2(64),G1H2(65),G1H2(66),G1H2(67),G1H2(68),2)
  call HG1shiftOLR(G1H2(65),18,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(2),[G1H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(17),[G1H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(59),[G1H2(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(64),[G1H2(58)])
  call Hloop_VQ_A(ntryL,G1H4(7),ex3(:),G1H2(57),m3h2x2(:,63),heltab2x4(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(57),55,0,G2H2(23),n2h2(33))
call HGT_raise_alpha_OLR(G1H4(16),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(16),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(16),ex4(:),G1H2(58),m3h2x2(:,64),heltab2x4(:,:,76))
  call Hloop_VQ_A(ntryL,G1H4(2),ex3(:),G1H2(57),m3h2x2(:,65),heltab2x4(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(57),55,0,G2H2(25),n2h2(34))
  call Hloop_VQ_A(ntryL,G1H4(27),ex3(:),G1H2(57),m3h2x2(:,66),heltab2x4(:,:,78))
  call Hloop_Q_A(ntryL,G1H2(57),55,0,G2H2(26),n2h2(35))
  call Hloop_VA_Q(ntryL,G1H4(3),ex4(:),G1H2(57),m3h2x2(:,67),heltab2x4(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(57),59,0,G2H2(47),n2h2(36))
call HGT_raise_alpha_OLR(G1H4(28),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(28),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(28),ex3(:),G1H2(57),m3h2x2(:,68),heltab2x4(:,:,80))
  call Hloop_VA_Q(ntryL,G1H4(8),ex4(:),G1H2(69),m3h2x2(:,69),heltab2x4(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(69),59,0,G2H2(48),n2h2(37))
  call Hloop_VA_Q(ntryL,G1H4(33),ex4(:),G1H2(69),m3h2x2(:,70),heltab2x4(:,:,82))
  call Hloop_A_Q(ntryL,G1H2(69),59,0,G2H2(49),n2h2(38))
  call Hloop_VQ_A(ntryL,G1H4(14),ex3(:),G1H2(69),m3h2x2(:,71),heltab2x4(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(69),55,0,G2H2(50),n2h2(39))
call HGT_raise_alpha_OLR(G1H4(34),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(34),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(34),ex4(:),G1H2(69),m3h2x2(:,72),heltab2x4(:,:,84))
  call Hloop_VQ_A(ntryL,G1H4(44),ex3(:),G1H2(70),m3h2x2(:,73),heltab2x4(:,:,85))
  call Hloop_Q_A(ntryL,G1H2(70),55,0,G2H2(51),n2h2(40))
  call Hloop_VQ_A(ntryL,G1H4(45),ex3(:),G1H2(70),m3h2x2(:,74),heltab2x4(:,:,86))
  call Hloop_Q_A(ntryL,G1H2(70),55,0,G2H2(52),n2h2(41))
  call Hloop_VA_Q(ntryL,G1H4(46),ex4(:),G1H2(70),m3h2x2(:,75),heltab2x4(:,:,87))
  call Hloop_A_Q(ntryL,G1H2(70),59,0,G2H2(53),n2h2(42))
call HGT_raise_alpha_OLR(G1H4(51),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(51),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(51),ex3(:),G1H2(70),m3h2x2(:,76),heltab2x4(:,:,88))
  call Hloop_VA_Q(ntryL,G1H4(15),ex4(:),G1H2(71),m3h2x2(:,77),heltab2x4(:,:,89))
  call Hloop_A_Q(ntryL,G1H2(71),59,0,G2H2(54),n2h2(43))
  call Hloop_VA_Q(ntryL,G1H4(26),ex4(:),G1H2(71),m3h2x2(:,78),heltab2x4(:,:,90))
  call Hloop_A_Q(ntryL,G1H2(71),59,0,G2H2(55),n2h2(44))
  call Hloop_QS_A(ntryL,G1H2(33),ex5(:),G1H2(71),ngH,m3h1x2(:,5),heltab2x2(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(71),61,nMT,G2H2(56),n2h2(45))
call HGT_raise_alpha_OLR(G1H2(3),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(3),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(3),ex2(:),G1H1(8),m3h2x1(:,25),heltab2x2(:,:,30))
  call Hloop_QS_A(ntryL,G1H2(9),ex5(:),G1H2(33),ngH,m3h1x2(:,6),heltab2x2(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(33),61,nMT,G2H2(57),n2h2(47))
  call Hloop_QS_A(ntryL,G1H2(23),ex5(:),G1H2(71),ngH,m3h1x2(:,7),heltab2x2(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(71),61,nMT,G2H2(58),n2h2(48))
  call Hloop_AS_Q(ntryL,G1H2(11),ex5(:),G1H2(3),ngH,m3h1x2(:,8),heltab2x2(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(3),62,nMT,G2H2(59),n2h2(49))
call HGT_raise_alpha_OLR(G1H2(15),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(15),2,5,2)
  call Hloop_VQ_A(ntryL,G1H2(15),ex1(:),G1H1(2),m3h2x1(:,26),heltab2x2(:,:,34))
  call Hloop_AS_Q(ntryL,G1H2(35),ex5(:),G1H2(9),ngH,m3h1x2(:,9),heltab2x2(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(9),62,nMT,G2H2(60),n2h2(51))
  call Hloop_AS_Q(ntryL,G1H2(36),ex5(:),G1H2(33),ngH,m3h1x2(:,10),heltab2x2(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(33),62,nMT,G2H2(61),n2h2(52))
  call Hloop_VQ_A(ntryL,G1H2(27),ex1(:),G1H1(13),m3h2x1(:,27),heltab2x2(:,:,37))
  call Hloop_Q_A(ntryL,G1H1(13),47,nMT,G2H1(13),n2h1(29))
call HGT_OLR(G1H2(4),1,1,2)
call HGT_invQ_OLR(G1H2(4),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(4),-16,nMT,G2H2(62),n2h2(53))
  call Hloop_AS_Q(ntryL,G2H2(62),ex5(:),G2H2(63),ngH,m3h1x2(:,11),heltab2x2(:,:,38))
  call Hloop_VQ_A(ntryL,G1H2(39),ex1(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,39))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMT,G2H1(14),n2h1(30))
  call Hloop_VQ_A(ntryL,G1H2(40),ex1(:),G1H1(14),m3h2x1(:,29),heltab2x2(:,:,40))
  call Hloop_Q_A(ntryL,G1H1(14),47,nMT,G2H1(15),n2h1(31))
  call Hloop_VA_Q(ntryL,G1H2(12),ex2(:),G1H1(7),m3h2x1(:,30),heltab2x2(:,:,41))
  call Hloop_A_Q(ntryL,G1H1(7),47,nMT,G2H1(16),n2h1(32))
call HGT_OLR(G1H2(10),1,1,2)
call HGT_invQ_OLR(G1H2(10),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(10),-16,nMT,G2H2(62),n2h2(54))
  call Hloop_QS_A(ntryL,G2H2(62),ex5(:),G2H2(64),ngH,m3h1x2(:,12),heltab2x2(:,:,42))
  call Hloop_VA_Q(ntryL,G1H2(43),ex2(:),G1H1(19),m3h2x1(:,31),heltab2x2(:,:,43))
  call Hloop_A_Q(ntryL,G1H1(19),47,nMT,G2H1(17),n2h1(33))
  call Hloop_VA_Q(ntryL,G1H2(44),ex2(:),G1H1(25),m3h2x1(:,32),heltab2x2(:,:,44))
  call Hloop_A_Q(ntryL,G1H1(25),47,nMT,G2H1(18),n2h1(34))
  call Hloop_VQ_A(ntryL,G1H4(20),ex3(:),G1H2(23),m3h2x2(:,79),heltab2x4(:,:,91))
  call Hloop_Q_A(ntryL,G1H2(23),55,0,G2H2(62),n2h2(55))
call HGT_raise_alpha_OLR(G1H4(13),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(13),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(13),ex4(:),G1H2(71),m3h2x2(:,80),heltab2x4(:,:,92))
  call Hloop_VQ_A(ntryL,G1H4(10),ex3(:),G1H2(11),m3h2x2(:,81),heltab2x4(:,:,93))
  call Hloop_Q_A(ntryL,G1H2(11),55,0,G2H2(65),n2h2(56))
  call Hloop_VQ_A(ntryL,G1H4(17),ex3(:),G1H2(3),m3h2x2(:,82),heltab2x4(:,:,94))
  call Hloop_Q_A(ntryL,G1H2(3),55,0,G2H2(66),n2h2(57))
  call Hloop_VQ_A(ntryL,G1H4(12),ex3(:),G1H2(15),m3h2x2(:,83),heltab2x4(:,:,95))
  call Hloop_Q_A(ntryL,G1H2(15),55,0,G2H2(67),n2h2(58))
call HGT_raise_alpha_OLR(G1H4(25),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(25),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(25),ex4(:),G1H2(35),m3h2x2(:,84),heltab2x4(:,:,96))
  call Hloop_VQ_A(ntryL,G1H4(11),ex3(:),G1H2(9),m3h2x2(:,85),heltab2x4(:,:,97))
  call Hloop_Q_A(ntryL,G1H2(9),55,0,G2H2(68),n2h2(59))
  call Hloop_VQ_A(ntryL,G1H4(6),ex3(:),G1H2(36),m3h2x2(:,86),heltab2x4(:,:,98))
  call Hloop_Q_A(ntryL,G1H2(36),55,0,G2H2(69),n2h2(60))
  call Hloop_VA_Q(ntryL,G1H4(23),ex4(:),G1H2(33),m3h2x2(:,87),heltab2x4(:,:,99))
  call Hloop_A_Q(ntryL,G1H2(33),59,0,G2H2(70),n2h2(61))
call HGT_raise_alpha_OLR(G1H4(24),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(24),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(24),ex3(:),G1H2(27),m3h2x2(:,88),heltab2x4(:,:,100))
  call Hloop_VA_Q(ntryL,G1H4(47),ex4(:),G1H2(4),m3h2x2(:,89),heltab2x4(:,:,101))
  call Hloop_A_Q(ntryL,G1H2(4),59,0,G2H2(71),n2h2(62))
  call Hloop_VA_Q(ntryL,G1H4(48),ex4(:),G1H2(39),m3h2x2(:,90),heltab2x4(:,:,102))
  call Hloop_A_Q(ntryL,G1H2(39),59,0,G2H2(72),n2h2(63))
  call Hloop_VA_Q(ntryL,G1H4(5),ex4(:),G1H2(40),m3h2x2(:,91),heltab2x4(:,:,103))
  call Hloop_A_Q(ntryL,G1H2(40),59,0,G2H2(73),n2h2(64))
call HGT_raise_alpha_OLR(G1H4(18),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(18),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(18),ex3(:),G1H2(12),m3h2x2(:,92),heltab2x4(:,:,104))
  call Hloop_VA_Q(ntryL,G1H4(58),ex4(:),G1H2(10),m3h2x2(:,93),heltab2x4(:,:,105))
  call Hloop_A_Q(ntryL,G1H2(10),59,0,G2H2(74),n2h2(65))
  call Hloop_VA_Q(ntryL,G1H4(59),ex4(:),G1H2(43),m3h2x2(:,94),heltab2x4(:,:,106))
  call Hloop_A_Q(ntryL,G1H2(43),59,0,G2H2(75),n2h2(66))
  call Hloop_VQ_A(ntryL,G1H4(29),ex3(:),G1H2(44),m3h2x2(:,95),heltab2x4(:,:,107))
  call Hloop_Q_A(ntryL,G1H2(44),55,0,G2H2(76),n2h2(67))
call HGT_raise_alpha_OLR(G1H4(30),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(30),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(30),ex4(:),G1H2(23),m3h2x2(:,96),heltab2x4(:,:,108))
  call Hloop_VQ_A(ntryL,G1H4(61),ex3(:),G1H2(11),m3h2x2(:,97),heltab2x4(:,:,109))
  call Hloop_Q_A(ntryL,G1H2(11),55,0,G2H2(77),n2h2(68))
  call Hloop_VQ_A(ntryL,G1H4(62),ex3(:),G1H2(3),m3h2x2(:,98),heltab2x4(:,:,110))
  call Hloop_Q_A(ntryL,G1H2(3),55,0,G2H2(78),n2h2(69))
  call Hloop_VQ_A(ntryL,G1H4(63),ex3(:),G1H2(15),m3h2x2(:,99),heltab2x4(:,:,111))
  call Hloop_Q_A(ntryL,G1H2(15),55,0,G2H2(79),n2h2(70))
call HGT_raise_alpha_OLR(G1H4(64),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(64),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(64),ex4(:),G1H2(9),m3h2x2(:,100),heltab2x4(:,:,112))
  call Hloop_VQ_A(ntryL,G1H4(67),ex3(:),G1H2(36),m3h2x2(:,101),heltab2x4(:,:,113))
  call Hloop_Q_A(ntryL,G1H2(36),55,0,G2H2(80),n2h2(71))
  call Hloop_VQ_A(ntryL,G1H4(68),ex3(:),G1H2(33),m3h2x2(:,102),heltab2x4(:,:,114))
  call Hloop_Q_A(ntryL,G1H2(33),55,0,G2H2(81),n2h2(72))
  call Hloop_VA_Q(ntryL,G1H4(41),ex4(:),G1H2(4),m3h2x2(:,103),heltab2x4(:,:,115))
  call Hloop_A_Q(ntryL,G1H2(4),59,0,G2H2(82),n2h2(73))
call HGT_raise_alpha_OLR(G1H4(42),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(42),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(42),ex3(:),G1H2(39),m3h2x2(:,104),heltab2x4(:,:,116))
  call Hloop_VA_Q(ntryL,G1H4(70),ex4(:),G1H2(40),m3h2x2(:,105),heltab2x4(:,:,117))
  call Hloop_A_Q(ntryL,G1H2(40),59,0,G2H2(83),n2h2(74))
  call Hloop_VA_Q(ntryL,G1H4(71),ex4(:),G1H2(10),m3h2x2(:,106),heltab2x4(:,:,118))
  call Hloop_A_Q(ntryL,G1H2(10),59,0,G2H2(84),n2h2(75))
  call Hloop_VA_Q(ntryL,G1H4(72),ex4(:),G1H2(43),m3h2x2(:,107),heltab2x4(:,:,119))
  call Hloop_A_Q(ntryL,G1H2(43),59,0,G2H2(85),n2h2(76))
call HGT_raise_alpha_OLR(G1H4(73),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(73),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(73),ex3(:),G1H2(44),m3h2x2(:,108),heltab2x4(:,:,120))
  call Hloop_VA_Q(ntryL,G1H4(76),ex4(:),G1H2(11),m3h2x2(:,109),heltab2x4(:,:,121))
  call Hloop_A_Q(ntryL,G1H2(11),59,0,G2H2(86),n2h2(77))
  call Hloop_VA_Q(ntryL,G1H4(77),ex4(:),G1H2(3),m3h2x2(:,110),heltab2x4(:,:,122))
  call Hloop_A_Q(ntryL,G1H2(3),59,0,G2H2(87),n2h2(78))
  call Hloop_QS_A(ntryL,G1H4(53),ex5(:),G1H4(7),ngH,m3h1x4(:,13),heltab2x4(:,:,123))
  call Hloop_Q_A(ntryL,G1H4(7),51,nMT,G2H4(32),n2h4(63))
call HGT_OLR(G1H4(54),1,1,4)
call HGT_invQ_OLR(G1H4(54),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(54),-12,nMT,G2H4(31),n2h4(64))
  call Hloop_AV_Q(ntryL,G2H4(31),wf4(:,2),G2H1(19),m3h4x1(:,1),heltab2x4(:,:,124))
  call Hloop_QS_A(ntryL,G1H4(79),ex5(:),G1H4(16),ngH,m3h1x4(:,14),heltab2x4(:,:,125))
  call Hloop_Q_A(ntryL,G1H4(16),51,nMT,G2H4(40),n2h4(65))
  call Hloop_QS_A(ntryL,G1H4(80),ex5(:),G1H4(2),ngH,m3h1x4(:,15),heltab2x4(:,:,126))
  call Hloop_Q_A(ntryL,G1H4(2),51,nMT,G2H4(39),n2h4(66))
  call Hloop_VQ_A(ntryL,G1H2(28),ex1(:),G1H1(20),m3h2x1(:,33),heltab2x2(:,:,45))
  call Hloop_Q_A(ntryL,G1H1(20),47,nMT,G2H1(20),n2h1(35))
call HGT_OLR(G1H2(16),1,1,2)
call HGT_invQ_OLR(G1H2(16),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(16),-16,nMT,G2H2(88),n2h2(79))
  call Hloop_AS_Q(ntryL,G2H2(88),ex5(:),G2H2(89),ngH,m3h1x2(:,13),heltab2x2(:,:,46))
  call Hloop_VQ_A(ntryL,G1H2(45),ex1(:),G1H1(13),m3h2x1(:,34),heltab2x2(:,:,47))
  call Hloop_Q_A(ntryL,G1H1(13),47,nMT,G2H1(21),n2h1(36))
  call Hloop_VQ_A(ntryL,G1H2(46),ex1(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,48))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMT,G2H1(22),n2h1(37))
  call Hloop_AS_Q(ntryL,G1H4(81),ex5(:),G1H4(27),ngH,m3h1x4(:,16),heltab2x4(:,:,127))
  call Hloop_A_Q(ntryL,G1H4(27),51,nMT,G2H4(30),n2h4(67))
call HGT_OLR(G1H4(82),1,1,4)
call HGT_invQ_OLR(G1H4(82),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(82),-12,nMT,G2H4(38),n2h4(68))
  call Hloop_QV_A(ntryL,G2H4(38),wf4(:,2),G2H1(23),m3h4x1(:,2),heltab2x4(:,:,128))
  call Hloop_AS_Q(ntryL,G1H4(85),ex5(:),G1H4(3),ngH,m3h1x4(:,17),heltab2x4(:,:,129))
  call Hloop_A_Q(ntryL,G1H4(3),51,nMT,G2H4(19),n2h4(69))
  call Hloop_AS_Q(ntryL,G1H4(86),ex5(:),G1H4(28),ngH,m3h1x4(:,18),heltab2x4(:,:,130))
  call Hloop_A_Q(ntryL,G1H4(28),51,nMT,G2H4(6),n2h4(70))
  call Hloop_AV_Q(ntryL,G1H4(87),wf4(:,2),G1H1(14),m3h4x1(:,3),heltab2x4(:,:,131))
  call Hloop_A_Q(ntryL,G1H1(14),47,nMT,G2H1(24),n2h1(38))
call HGT_OLR(G1H4(88),1,1,4)
call HGT_invQ_OLR(G1H4(88),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(88),-16,nMT,G2H4(20),n2h4(71))
  call Hloop_QS_A(ntryL,G2H4(20),ex5(:),G2H4(9),ngH,m3h1x4(:,19),heltab2x4(:,:,132))
  call Hloop_AV_Q(ntryL,G1H4(91),wf4(:,2),G1H1(7),m3h4x1(:,4),heltab2x4(:,:,133))
  call Hloop_A_Q(ntryL,G1H1(7),47,nMT,G2H1(25),n2h1(39))
  call Hloop_AV_Q(ntryL,G1H4(92),wf4(:,2),G1H1(19),m3h4x1(:,5),heltab2x4(:,:,134))
  call Hloop_A_Q(ntryL,G1H1(19),47,nMT,G2H1(26),n2h1(40))
  call Hloop_VA_Q(ntryL,G1H2(47),ex2(:),G1H1(25),m3h2x1(:,36),heltab2x2(:,:,49))
  call Hloop_A_Q(ntryL,G1H1(25),47,nMT,G2H1(27),n2h1(41))
call HGT_OLR(G1H2(48),1,1,2)
call HGT_invQ_OLR(G1H2(48),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(48),-16,nMT,G2H2(88),n2h2(80))
  call Hloop_QS_A(ntryL,G2H2(88),ex5(:),G2H2(90),ngH,m3h1x2(:,14),heltab2x2(:,:,50))
  call Hloop_VA_Q(ntryL,G1H2(51),ex2(:),G1H1(20),m3h2x1(:,37),heltab2x2(:,:,51))
  call Hloop_A_Q(ntryL,G1H1(20),47,nMT,G2H1(28),n2h1(42))
  call Hloop_VA_Q(ntryL,G1H2(52),ex2(:),G1H1(13),m3h2x1(:,38),heltab2x2(:,:,52))
  call Hloop_A_Q(ntryL,G1H1(13),47,nMT,G2H1(29),n2h1(43))
  call Hloop_QV_A(ntryL,G1H4(93),wf4(:,2),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,135))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMT,G2H1(30),n2h1(44))
call HGT_OLR(G1H4(94),1,1,4)
call HGT_invQ_OLR(G1H4(94),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(94),-16,nMT,G2H4(21),n2h4(72))
  call Hloop_AS_Q(ntryL,G2H4(21),ex5(:),G2H4(12),ngH,m3h1x4(:,20),heltab2x4(:,:,136))
  call Hloop_QV_A(ntryL,G1H4(97),wf4(:,2),G1H1(14),m3h4x1(:,7),heltab2x4(:,:,137))
  call Hloop_Q_A(ntryL,G1H1(14),47,nMT,G2H1(31),n2h1(45))
  call Hloop_QV_A(ntryL,G1H4(98),wf4(:,2),G1H1(7),m3h4x1(:,8),heltab2x4(:,:,138))
  call Hloop_Q_A(ntryL,G1H1(7),47,nMT,G2H1(32),n2h1(46))
  call Hloop_VA_Q(ntryL,G1H4(99),ex2(:),G1H2(15),m3h2x2(:,111),heltab2x4(:,:,139))
  call Hloop_A_Q(ntryL,G1H2(15),46,nMT,G2H2(88),n2h2(81))
call HGT_raise_alpha_OLR(G1H4(100),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(100),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(100),wf2(:,2),G1H2(36),m3h2x2(:,112),heltab2x4(:,:,140))
  call Hloop_VA_Q(ntryL,G1H4(103),ex2(:),G1H2(33),m3h2x2(:,113),heltab2x4(:,:,141))
  call Hloop_A_Q(ntryL,G1H2(33),46,nMT,G2H2(91),n2h2(82))
  call Hloop_VA_Q(ntryL,G1H4(104),ex2(:),G1H2(4),m3h2x2(:,114),heltab2x4(:,:,142))
  call Hloop_A_Q(ntryL,G1H2(4),46,nMT,G2H2(92),n2h2(83))
  call Hloop_VA_Q(ntryL,G1H4(105),ex2(:),G1H2(40),m3h2x2(:,115),heltab2x4(:,:,143))
  call Hloop_A_Q(ntryL,G1H2(40),46,nMT,G2H2(93),n2h2(84))
call HGT_raise_alpha_OLR(G1H4(106),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(106),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(106),wf2(:,2),G1H2(10),m3h2x2(:,116),heltab2x4(:,:,144))
  call Hloop_VA_Q(ntryL,G1H4(109),ex2(:),G1H2(43),m3h2x2(:,117),heltab2x4(:,:,145))
  call Hloop_A_Q(ntryL,G1H2(43),46,nMT,G2H2(94),n2h2(85))
  call Hloop_VA_Q(ntryL,G1H4(110),ex2(:),G1H2(11),m3h2x2(:,118),heltab2x4(:,:,146))
  call Hloop_A_Q(ntryL,G1H2(11),46,nMT,G2H2(95),n2h2(86))
  call Hloop_VQ_A(ntryL,G1H4(111),ex1(:),G1H2(3),m3h2x2(:,119),heltab2x4(:,:,147))
  call Hloop_Q_A(ntryL,G1H2(3),45,nMT,G2H2(96),n2h2(87))
call HGT_raise_alpha_OLR(G1H4(112),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(112),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(112),wf2(:,4),G1H2(28),m3h2x2(:,120),heltab2x4(:,:,148))
  call Hloop_VQ_A(ntryL,G1H4(115),ex1(:),G1H2(16),m3h2x2(:,121),heltab2x4(:,:,149))
  call Hloop_Q_A(ntryL,G1H2(16),45,nMT,G2H2(97),n2h2(88))
  call Hloop_VQ_A(ntryL,G1H4(116),ex1(:),G1H2(45),m3h2x2(:,122),heltab2x4(:,:,150))
  call Hloop_Q_A(ntryL,G1H2(45),45,nMT,G2H2(98),n2h2(89))
  call Hloop_VQ_A(ntryL,G1H4(117),ex1(:),G1H2(46),m3h2x2(:,123),heltab2x4(:,:,151))
  call Hloop_Q_A(ntryL,G1H2(46),45,nMT,G2H2(99),n2h2(90))
call HGT_raise_alpha_OLR(G1H4(118),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(118),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(118),wf2(:,4),G1H2(47),m3h2x2(:,124),heltab2x4(:,:,152))
  call Hloop_VQ_A(ntryL,G1H4(121),ex1(:),G1H2(48),m3h2x2(:,125),heltab2x4(:,:,153))
  call Hloop_Q_A(ntryL,G1H2(48),45,nMT,G2H2(100),n2h2(91))
  call Hloop_VQ_A(ntryL,G1H4(122),ex1(:),G1H2(51),m3h2x2(:,126),heltab2x4(:,:,154))
  call Hloop_Q_A(ntryL,G1H2(51),45,nMT,G2H2(101),n2h2(92))
  call Hloop_QV_A(ntryL,G1H8(22),wf4(:,2),G1H2(52),m3h4x2(:,9),heltab2x8(:,:,107))
  call Hloop_Q_A(ntryL,G1H2(52),61,nMT,G2H2(102),n2h2(93))
call HGT_raise_alpha_OLR(G1H8(20),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(20),ex2(:),G1H4(8),m3h2x4(:,67),heltab2x8(:,:,108))
  call Hloop_QV_A(ntryL,G1H8(2),wf4(:,2),G1H2(15),m3h4x2(:,10),heltab2x8(:,:,109))
  call Hloop_Q_A(ntryL,G1H2(15),61,nMT,G2H2(103),n2h2(94))
  call Hloop_QV_A(ntryL,G1H8(17),wf4(:,2),G1H2(33),m3h4x2(:,11),heltab2x8(:,:,110))
  call Hloop_Q_A(ntryL,G1H2(33),61,nMT,G2H2(104),n2h2(95))
call HGT_raise_alpha_OLR(G1H8(24),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(24),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(24),ex2(:),G1H4(33),m3h2x4(:,68),heltab2x8(:,:,111))
  call Hloop_QV_A(ntryL,G1H8(9),wf4(:,2),G1H2(4),m3h4x2(:,12),heltab2x8(:,:,112))
  call Hloop_Q_A(ntryL,G1H2(4),61,nMT,G2H2(105),n2h2(96))
call HGT_raise_alpha_OLR(G1H8(13),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(13),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(13),ex2(:),G1H4(14),m3h2x4(:,69),heltab2x8(:,:,113))
  call Hloop_QV_A(ntryL,G1H8(14),wf4(:,2),G1H2(40),m3h4x2(:,13),heltab2x8(:,:,114))
  call Hloop_Q_A(ntryL,G1H2(40),61,nMT,G2H2(106),n2h2(97))
  call Hloop_QS_A(ntryL,G1H2(53),ex5(:),G1H2(43),ngH,m3h1x2(:,15),heltab2x2(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(43),61,nMT,G2H2(107),n2h2(98))
call HGT_raise_alpha_OLR(G1H2(54),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(54),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(54),ex2(:),G1H1(19),m3h2x1(:,39),heltab2x2(:,:,54))
  call Hloop_QS_A(ntryL,G1H2(59),ex5(:),G1H2(11),ngH,m3h1x2(:,16),heltab2x2(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(11),61,nMT,G2H2(108),n2h2(100))
  call Hloop_QS_A(ntryL,G1H2(64),ex5(:),G1H2(3),ngH,m3h1x2(:,17),heltab2x2(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(3),61,nMT,G2H2(109),n2h2(101))
call HGT_raise_alpha_OLR(G1H2(60),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(60),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(60),ex2(:),G1H1(25),m3h2x1(:,40),heltab2x2(:,:,57))
  call Hloop_QS_A(ntryL,G1H2(63),ex5(:),G1H2(16),ngH,m3h1x2(:,18),heltab2x2(:,:,58))
  call Hloop_Q_A(ntryL,G1H2(16),61,nMT,G2H2(110),n2h2(103))
call HGT_raise_alpha_OLR(G1H2(65),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(65),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(65),ex2(:),G1H1(20),m3h2x1(:,41),heltab2x2(:,:,59))
  call Hloop_QS_A(ntryL,G1H2(68),ex5(:),G1H2(45),ngH,m3h1x2(:,19),heltab2x2(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(45),61,nMT,G2H2(111),n2h2(105))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(45),[G2H2(2),G1H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G2H2(4),G1H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(2),[G1H1(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(4),[G1H1(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(6),[G1H1(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(8),[G1H1(24)])
call HGT_w2_OLR(G1H2(2),1,1,2)
call HGT_w2_invQ_OLR(G1H2(2),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(37),[G1H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(38),[G1H2(29)])
call HGT_w2_OLR(G1H2(13),1,1,2)
call HGT_w2_invQ_OLR(G1H2(13),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(38),[G1H2(13)])
call HGT_w2_OLR(G1H2(24),1,1,2)
call HGT_w2_invQ_OLR(G1H2(24),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(39),[G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G1H2(19)])
call HGT_w2_OLR(G1H2(14),1,1,2)
call HGT_w2_invQ_OLR(G1H2(14),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G1H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(41),[G1H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(42),[G1H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G1H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(1),[G1H1(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(3),[G1H1(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(13),[G1H1(17),G1H1(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(5),[G1H1(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(7),[G1H1(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(16),[G1H1(23),G1H1(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(9),[G1H1(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(10),[G1H1(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(11),[G1H1(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(12),[G1H1(22)])
  call Hotf_5pt_reduction(G2H2(45),RedSet_5(41),mass5set(:,11),  & 
G1H2(46),G1H2(48),G1H2(51),G1H2(52),G1H2(15),G1H2(33),2)
  call HG1shiftOLR(G1H2(48),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(42),mass5set(:,11),  & 
G1H2(4),G1H2(40),G1H2(53),G1H2(43),G1H2(54),G1H2(59),2)
  call HG1shiftOLR(G1H2(40),8,2)
call HGT_OLR(G2H2(8),1,1,2)
call HGT_invQ_OLR(G2H2(8),2,5,2)
call HGT_OLR(G2H2(8),6,15,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(43),mass5set(:,3),  & 
G1H2(11),G1H2(64),G1H2(3),G1H2(60),G1H2(63),G1H2(16),2)
  call HG1shiftOLR(G1H2(64),1,2)
  call Hotf_5pt_reduction(G2H1(2),RedSet_5(44),mass5set(:,6),  & 
G1H1(13),G1H1(1),G1H1(14),G1H1(7),G1H1(6),G1H1(12),1)
  call HG1shiftOLR(G1H1(1),16,1)
call HGT_OLR(G2H2(9),1,1,2)
call HGT_invQ_OLR(G2H2(9),2,5,2)
call HGT_OLR(G2H2(9),6,15,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(45),mass5set(:,3),  & 
G1H2(65),G1H2(68),G1H2(45),G1H2(26),G1H2(32),G1H2(2),2)
  call HG1shiftOLR(G1H2(68),2,2)
  call Hotf_5pt_reduction(G2H1(4),RedSet_5(46),mass5set(:,6),  & 
G1H1(18),G1H1(24),G1H1(3),G1H1(4),G1H1(17),G1H1(5),1)
  call HG1shiftOLR(G1H1(24),16,1)
call HGT_OLR(G2H2(10),1,1,2)
call HGT_invQ_OLR(G2H2(10),2,5,2)
call HGT_OLR(G2H2(10),6,15,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(47),mass5set(:,3),  & 
G1H2(29),G1H2(13),G1H2(24),G1H2(19),G1H2(14),G1H2(1),2)
  call HG1shiftOLR(G1H2(13),1,2)
  call Hotf_5pt_reduction(G2H1(6),RedSet_5(48),mass5set(:,6),  & 
G1H1(9),G1H1(10),G1H1(23),G1H1(11),G1H1(15),G1H1(16),1)
  call HG1shiftOLR(G1H1(10),16,1)
call HGT_OLR(G2H2(11),1,1,2)
call HGT_invQ_OLR(G2H2(11),2,5,2)
call HGT_OLR(G2H2(11),6,15,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(49),mass5set(:,3),  & 
G1H2(25),G1H2(30),G1H2(31),G1H2(72),G1H2(73),G1H2(74),2)
  call HG1shiftOLR(G1H2(30),2,2)
  call Hotf_5pt_reduction(G2H1(8),RedSet_5(50),mass5set(:,6),  & 
G1H1(21),G1H1(22),G1H1(26),G1H1(27),G1H1(28),G1H1(29),1)
  call HG1shiftOLR(G1H1(22),16,1)
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(51),mass5set(:,1),  & 
G1H2(75),G1H2(76),G1H2(77),G1H2(78),G1H2(79),G1H2(80),2)
  call HG1shiftOLR(G1H2(76),4,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(12),ex4(:),G2tensor(1),m3h2x1(:,42),heltab2x2(:,:,61))
call HGT_w2_OLR(G1H2(7),1,1,2)
call HGT_w2_invQ_OLR(G1H2(7),2,5,2)
  call Hloop_VQ_A(ntryL,G1H2(7),ex3(:),G1H1(30),m3h2x1(:,43),heltab2x2(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(30),63,0,G2tensor(2),n2h1(47))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(13),ex4(:),G2tensor(3),m3h2x1(:,44),heltab2x2(:,:,63))
  call Hotf_5pt_reduction(G2H2(38),RedSet_5(52),mass5set(:,1),  & 
G1H2(7),G1H2(81),G1H2(82),G1H2(83),G1H2(84),G1H2(85),2)
  call HG1shiftOLR(G1H2(81),8,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(15),ex3(:),G2tensor(4),m3h2x1(:,45),heltab2x2(:,:,64))
call HGT_w2_OLR(G1H2(18),1,1,2)
call HGT_w2_invQ_OLR(G1H2(18),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(18),ex4(:),G1H1(30),m3h2x1(:,46),heltab2x2(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(30),63,0,G2tensor(5),n2h1(48))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(16),ex3(:),G2tensor(7),m3h2x1(:,47),heltab2x2(:,:,66))
  call Hotf_5pt_reduction(G2H2(39),RedSet_5(53),mass5set(:,1),  & 
G1H2(18),G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(86),4,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(18),ex4(:),G2tensor(9),m3h2x1(:,48),heltab2x2(:,:,67))
call HGT_w2_OLR(G1H2(6),1,1,2)
call HGT_w2_invQ_OLR(G1H2(6),2,5,2)
  call Hloop_VQ_A(ntryL,G1H2(6),ex3(:),G1H1(30),m3h2x1(:,49),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(30),63,0,G2tensor(11),n2h1(49))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(19),ex4(:),G2tensor(13),m3h2x1(:,50),heltab2x2(:,:,69))
  call Hotf_5pt_reduction(G2H2(40),RedSet_5(54),mass5set(:,1),  & 
G1H2(6),G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),2)
  call HG1shiftOLR(G1H2(91),8,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(21),ex3(:),G2tensor(15),m3h2x1(:,51),heltab2x2(:,:,70))
call HGT_w2_OLR(G1H2(20),1,1,2)
call HGT_w2_invQ_OLR(G1H2(20),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(20),ex4(:),G1H1(30),m3h2x1(:,52),heltab2x2(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(30),63,0,G2tensor(17),n2h1(50))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(22),ex3(:),G2tensor(18),m3h2x1(:,53),heltab2x2(:,:,72))
  call Hotf_5pt_reduction(G2H2(41),RedSet_5(55),mass5set(:,1),  & 
G1H2(20),G1H2(96),G1H2(97),G1H2(98),G1H2(99),G1H2(100),2)
  call HG1shiftOLR(G1H2(96),8,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(56),mass5set(:,11),  & 
G1H2(101),G1H2(102),G1H2(103),G1H2(104),G1H2(105),G1H2(106),2)
  call HG1shiftOLR(G1H2(102),8,2)
  call Hotf_5pt_reduction(G2H2(42),RedSet_5(57),mass5set(:,1),  & 
G1H2(107),G1H2(108),G1H2(109),G1H2(110),G1H2(111),G1H2(112),2)
  call HG1shiftOLR(G1H2(108),8,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(58),mass5set(:,11),  & 
G1H2(113),G1H2(114),G1H2(115),G1H2(116),G1H2(117),G1H2(118),2)
  call HG1shiftOLR(G1H2(114),8,2)
  call Hotf_5pt_reduction(G2H1(1),RedSet_5(59),mass5set(:,12),  & 
G1H1(30),G1H1(31),G1H1(32),G1H1(33),G1H1(34),G1H1(35),1)
  call HG1shiftOLR(G1H1(31),16,1)
  call Hotf_5pt_reduction(G2H1(3),RedSet_5(60),mass5set(:,6),  & 
G1H1(36),G1H1(37),G1H1(38),G1H1(39),G1H1(40),G1H1(41),1)
  call HG1shiftOLR(G1H1(37),16,1)
  call Hotf_5pt_reduction(G2H1(13),RedSet_5(21),mass5set(:,6),  & 
G1H1(42),G1H1(43),G1H1(44),G1H1(45),G1H1(46),G1H1(47),1)
  call HG1shiftOLR(G1H1(43),16,1)
  call Hotf_5pt_reduction(G2H1(5),RedSet_5(61),mass5set(:,12),  & 
G1H1(48),G1H1(49),G1H1(50),G1H1(51),G1H1(52),G1H1(53),1)
  call HG1shiftOLR(G1H1(49),16,1)
  call Hotf_5pt_reduction(G2H1(7),RedSet_5(62),mass5set(:,6),  & 
G1H1(54),G1H1(55),G1H1(56),G1H1(57),G1H1(58),G1H1(59),1)
  call HG1shiftOLR(G1H1(55),16,1)
  call Hotf_5pt_reduction(G2H1(16),RedSet_5(22),mass5set(:,6),  & 
G1H1(60),G1H1(61),G1H1(62),G1H1(63),G1H1(64),G1H1(65),1)
  call HG1shiftOLR(G1H1(61),16,1)
  call Hotf_5pt_reduction(G2H1(9),RedSet_5(63),mass5set(:,12),  & 
G1H1(66),G1H1(67),G1H1(68),G1H1(69),G1H1(70),G1H1(71),1)
  call HG1shiftOLR(G1H1(67),16,1)
  call Hotf_5pt_reduction(G2H1(10),RedSet_5(64),mass5set(:,6),  & 
G1H1(72),G1H1(73),G1H1(74),G1H1(75),G1H1(76),G1H1(77),1)
  call HG1shiftOLR(G1H1(73),16,1)
  call Hotf_5pt_reduction(G2H1(11),RedSet_5(65),mass5set(:,12),  & 
G1H1(78),G1H1(79),G1H1(80),G1H1(81),G1H1(82),G1H1(83),1)
  call HG1shiftOLR(G1H1(79),16,1)
  call Hotf_5pt_reduction(G2H1(12),RedSet_5(66),mass5set(:,6),  & 
G1H1(84),G1H1(85),G1H1(86),G1H1(87),G1H1(88),G1H1(89),1)
  call HG1shiftOLR(G1H1(85),16,1)
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(7),mass5set(:,3),  & 
G1H2(119),G1H2(120),G1H2(121),G1H2(122),G1H2(123),G1H2(124),2)
  call HG1shiftOLR(G1H2(120),17,2)
  call Hotf_5pt_reduction(G2H2(43),RedSet_5(5),mass5set(:,3),  & 
G1H2(125),G1H2(126),G1H2(127),G1H2(128),G1H2(129),G1H2(130),2)
  call HG1shiftOLR(G1H2(126),17,2)
  call Hotf_5pt_reduction(G2H2(44),RedSet_5(6),mass5set(:,3),  & 
G1H2(131),G1H2(132),G1H2(133),G1H2(134),G1H2(135),G1H2(136),2)
  call HG1shiftOLR(G1H2(132),18,2)
  call Hotf_5pt_reduction(G2H2(46),RedSet_5(8),mass5set(:,3),  & 
G1H2(137),G1H2(138),G1H2(139),G1H2(140),G1H2(141),G1H2(142),2)
  call HG1shiftOLR(G1H2(138),18,2)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(2),mass5set(:,1),  & 
G1H4(34),G1H4(44),G1H4(45),G1H4(46),G1H4(51),G1H4(15),4)
  call HG1shiftOLR(G1H4(44),12,4)
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(37),mass4set(:,1),  & 
G1H4(26),G1H4(20),G1H4(13),G1H4(10),G1H4(17),4)
  call HG1shiftOLR(G1H4(20),14,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(1),mass5set(:,1),  & 
G1H4(12),G1H4(25),G1H4(11),G1H4(6),G1H4(23),G1H4(24),4)
  call HG1shiftOLR(G1H4(25),12,4)
  call Hotf_4pt_reduction(G2H4(17),RedSet_4(13),mass4set(:,1),  & 
G1H4(47),G1H4(48),G1H4(5),G1H4(18),G1H4(58),4)
  call HG1shiftOLR(G1H4(48),13,4)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(23),ex4(:),G2tensor(19),m3h2x1(:,54),heltab2x2(:,:,73))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(26),ex4(:),G2tensor(20),m3h2x1(:,55),heltab2x2(:,:,74))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(47),ex3(:),G2tensor(21),m3h2x1(:,56),heltab2x2(:,:,75))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(49),ex3(:),G2tensor(22),m3h2x1(:,57),heltab2x2(:,:,76))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(50),ex4(:),G2tensor(23),m3h2x1(:,58),heltab2x2(:,:,77))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(52),ex4(:),G2tensor(24),m3h2x1(:,59),heltab2x2(:,:,78))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(53),ex3(:),G2tensor(25),m3h2x1(:,60),heltab2x2(:,:,79))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(55),ex3(:),G2tensor(26),m3h2x1(:,61),heltab2x2(:,:,80))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(56),ex2(:),G2tensor(27),m3h2x1(:,62),heltab2x2(:,:,81))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(58),ex2(:),G2tensor(28),m3h2x1(:,63),heltab2x2(:,:,82))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(59),ex1(:),G2tensor(29),m3h2x1(:,64),heltab2x2(:,:,83))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(61),ex1(:),G2tensor(30),m3h2x1(:,65),heltab2x2(:,:,84))
  call Hotf_4pt_reduction(G2H1(15),RedSet_4(86),mass4set(:,2),  & 
G1H1(90),G1H1(91),G1H1(92),G1H1(93),G1H1(94),1)
  call HG1shiftOLR(G1H1(91),17,1)
  call Hotf_4pt_reduction(G2H1(18),RedSet_4(101),mass4set(:,2),  & 
G1H1(95),G1H1(96),G1H1(97),G1H1(98),G1H1(99),1)
  call HG1shiftOLR(G1H1(96),18,1)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(62),ex4(:),G2tensor(31),m3h2x1(:,66),heltab2x2(:,:,85))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(66),ex4(:),G2tensor(32),m3h2x1(:,67),heltab2x2(:,:,86))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(67),ex4(:),G2tensor(33),m3h2x1(:,68),heltab2x2(:,:,87))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(69),ex4(:),G2tensor(34),m3h2x1(:,69),heltab2x2(:,:,88))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(70),ex3(:),G2tensor(35),m3h2x1(:,70),heltab2x2(:,:,89))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(72),ex3(:),G2tensor(36),m3h2x1(:,71),heltab2x2(:,:,90))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(73),ex3(:),G2tensor(37),m3h2x1(:,72),heltab2x2(:,:,91))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(75),ex3(:),G2tensor(38),m3h2x1(:,73),heltab2x2(:,:,92))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(76),ex4(:),G2tensor(39),m3h2x1(:,74),heltab2x2(:,:,93))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(78),ex4(:),G2tensor(40),m3h2x1(:,75),heltab2x2(:,:,94))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(79),ex4(:),G2tensor(41),m3h2x1(:,76),heltab2x2(:,:,95))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(81),ex4(:),G2tensor(42),m3h2x1(:,77),heltab2x2(:,:,96))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(82),ex3(:),G2tensor(43),m3h2x1(:,78),heltab2x2(:,:,97))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(84),ex3(:),G2tensor(44),m3h2x1(:,79),heltab2x2(:,:,98))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(85),ex3(:),G2tensor(45),m3h2x1(:,80),heltab2x2(:,:,99))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(87),ex3(:),G2tensor(46),m3h2x1(:,81),heltab2x2(:,:,100))
  call Hotf_5pt_reduction(G2H4(32),RedSet_5(31),mass5set(:,8),  & 
G1H4(59),G1H4(29),G1H4(30),G1H4(61),G1H4(62),G1H4(63),4)
  call HG1shiftOLR(G1H4(29),12,4)
  call Hotf_4pt_reduction(G2H4(39),RedSet_4(127),mass4set(:,3),  & 
G1H4(64),G1H4(67),G1H4(68),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(67),28,4)
  call Hotf_5pt_reduction(G2H1(20),RedSet_5(32),mass5set(:,9),  & 
G1H1(100),G1H1(101),G1H1(102),G1H1(103),G1H1(104),G1H1(105),1)
  call HG1shiftOLR(G1H1(101),16,1)
  call Hotf_4pt_reduction(G2H1(22),RedSet_4(128),mass4set(:,4),  & 
G1H1(106),G1H1(107),G1H1(108),G1H1(109),G1H1(110),1)
  call HG1shiftOLR(G1H1(107),17,1)
  call Hotf_5pt_reduction(G2H4(30),RedSet_5(33),mass5set(:,8),  & 
G1H4(70),G1H4(71),G1H4(72),G1H4(73),G1H4(76),G1H4(77),4)
  call HG1shiftOLR(G1H4(71),12,4)
  call Hotf_4pt_reduction(G2H4(6),RedSet_4(129),mass4set(:,3),  & 
G1H4(53),G1H4(7),G1H4(54),G1H4(79),G1H4(16),4)
  call HG1shiftOLR(G1H4(7),28,4)
  call Hotf_5pt_reduction(G2H1(24),RedSet_5(34),mass5set(:,8),  & 
G1H1(111),G1H1(112),G1H1(113),G1H1(114),G1H1(115),G1H1(116),1)
  call HG1shiftOLR(G1H1(112),16,1)
  call Hotf_4pt_reduction(G2H1(26),RedSet_4(129),mass4set(:,3),  & 
G1H1(117),G1H1(118),G1H1(119),G1H1(120),G1H1(121),1)
  call HG1shiftOLR(G1H1(118),28,1)
  call Hotf_5pt_reduction(G2H1(27),RedSet_5(35),mass5set(:,9),  & 
G1H1(122),G1H1(123),G1H1(124),G1H1(125),G1H1(126),G1H1(127),1)
  call HG1shiftOLR(G1H1(123),16,1)
  call Hotf_4pt_reduction(G2H1(29),RedSet_4(130),mass4set(:,4),  & 
G1H1(128),G1H1(129),G1H1(130),G1H1(131),G1H1(132),1)
  call HG1shiftOLR(G1H1(129),18,1)
  call Hotf_5pt_reduction(G2H1(30),RedSet_5(36),mass5set(:,8),  & 
G1H1(133),G1H1(134),G1H1(135),G1H1(136),G1H1(137),G1H1(138),1)
  call HG1shiftOLR(G1H1(134),16,1)
  call Hotf_4pt_reduction(G2H1(32),RedSet_4(127),mass4set(:,3),  & 
G1H1(139),G1H1(140),G1H1(141),G1H1(142),G1H1(143),1)
  call HG1shiftOLR(G1H1(140),28,1)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(88),wf2(:,2),G2tensor(47),m3h2x1(:,82),heltab2x2(:,:,101))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(92),wf2(:,2),G2tensor(48),m3h2x1(:,83),heltab2x2(:,:,102))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(93),wf2(:,2),G2tensor(49),m3h2x1(:,84),heltab2x2(:,:,103))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(95),wf2(:,2),G2tensor(50),m3h2x1(:,85),heltab2x2(:,:,104))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(96),wf2(:,4),G2tensor(51),m3h2x1(:,86),heltab2x2(:,:,105))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(98),wf2(:,4),G2tensor(52),m3h2x1(:,87),heltab2x2(:,:,106))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(99),wf2(:,4),G2tensor(53),m3h2x1(:,88),heltab2x2(:,:,107))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(101),wf2(:,4),G2tensor(54),m3h2x1(:,89),heltab2x2(:,:,108))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(102),ex2(:),G2tensor(55),m3h2x1(:,90),heltab2x2(:,:,109))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(104),ex2(:),G2tensor(56),m3h2x1(:,91),heltab2x2(:,:,110))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(107),ex2(:),G2tensor(57),m3h2x1(:,92),heltab2x2(:,:,111))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(109),ex2(:),G2tensor(58),m3h2x1(:,93),heltab2x2(:,:,112))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(90),[G1H1(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(95),[G1H1(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(26),[G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(47),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(64),[G1H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(106),[G1H1(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(53),[G1H4(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(117),[G1H1(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(128),[G1H1(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(139),[G1H1(138)])
  call Hloop_VA_Q(ntryL,G1H2(46),ex4(:),G1H1(47),m3h2x1(:,94),heltab2x2(:,:,113))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(47),63,0,G2tensor(59),n2h1(51))
  call Hloop_VA_Q(ntryL,G1H2(48),ex4(:),G1H1(65),m3h2x1(:,95),heltab2x2(:,:,114))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(65),8,0,G2tensor(60),n2h1(52))
  call Hloop_VA_Q(ntryL,G1H2(33),ex4(:),G1H1(105),m3h2x1(:,96),heltab2x2(:,:,115))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(105),63,0,G2tensor(61),n2h1(53))
  call Hloop_VA_Q(ntryL,G1H2(4),ex4(:),G1H1(116),m3h2x1(:,97),heltab2x2(:,:,116))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(116),63,0,G2tensor(62),n2h1(54))
  call Hloop_VA_Q(ntryL,G1H2(40),ex4(:),G1H1(127),m3h2x1(:,98),heltab2x2(:,:,117))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(127),8,0,G2tensor(63),n2h1(55))
  call Hloop_VA_Q(ntryL,G1H2(59),ex4(:),G1H1(138),m3h2x1(:,99),heltab2x2(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(138),63,0,G2tensor(64),n2h1(56))
  call Hloop_VQ_A(ntryL,G1H2(11),ex1(:),G1H1(47),m3h2x1(:,100),heltab2x2(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(47),63,nMT,G2tensor(65),n2h1(57))
  call Hloop_VQ_A(ntryL,G1H2(64),ex1(:),G1H1(65),m3h2x1(:,101),heltab2x2(:,:,120))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(65),1,nMT,G2tensor(66),n2h1(58))
  call Hloop_VQ_A(ntryL,G1H2(16),ex1(:),G1H1(105),m3h2x1(:,102),heltab2x2(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(105),63,nMT,G2tensor(67),n2h1(59))
  call Hloop_QS_A(ntryL,G1H1(13),ex5(:),G1H1(116),ngH,m3h1x1(:,9),heltab2x1(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(116),63,nMT,G2tensor(68),n2h1(60))
  call Hloop_QS_A(ntryL,G1H1(1),ex5(:),G1H1(127),ngH,m3h1x1(:,10),heltab2x1(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(127),16,nMT,G2tensor(69),n2h1(61))
  call Hloop_QS_A(ntryL,G1H1(12),ex5(:),G1H1(138),ngH,m3h1x1(:,11),heltab2x1(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(138),63,nMT,G2tensor(70),n2h1(62))
  call Hloop_VA_Q(ntryL,G1H2(65),ex2(:),G1H1(47),m3h2x1(:,103),heltab2x2(:,:,122))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(47),63,nMT,G2tensor(71),n2h1(63))
  call Hloop_VA_Q(ntryL,G1H2(68),ex2(:),G1H1(65),m3h2x1(:,104),heltab2x2(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(65),2,nMT,G2tensor(72),n2h1(64))
  call Hloop_VA_Q(ntryL,G1H2(2),ex2(:),G1H1(105),m3h2x1(:,105),heltab2x2(:,:,124))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(105),63,nMT,G2tensor(73),n2h1(65))
  call Hloop_AS_Q(ntryL,G1H1(18),ex5(:),G1H1(13),ngH,m3h1x1(:,12),heltab2x1(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(13),63,nMT,G2tensor(74),n2h1(66))
  call Hloop_AS_Q(ntryL,G1H1(24),ex5(:),G1H1(116),ngH,m3h1x1(:,13),heltab2x1(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(116),16,nMT,G2tensor(75),n2h1(67))
  call Hloop_AS_Q(ntryL,G1H1(5),ex5(:),G1H1(1),ngH,m3h1x1(:,14),heltab2x1(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(76),n2h1(68))
  call Hloop_VQ_A(ntryL,G1H2(29),ex1(:),G1H1(127),m3h2x1(:,106),heltab2x2(:,:,125))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(127),63,nMT,G2tensor(77),n2h1(69))
  call Hloop_VQ_A(ntryL,G1H2(13),ex1(:),G1H1(12),m3h2x1(:,107),heltab2x2(:,:,126))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(12),1,nMT,G2tensor(78),n2h1(70))
  call Hloop_VQ_A(ntryL,G1H2(1),ex1(:),G1H1(138),m3h2x1(:,108),heltab2x2(:,:,127))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(138),63,nMT,G2tensor(79),n2h1(71))
  call Hloop_QS_A(ntryL,G1H1(9),ex5(:),G1H1(47),ngH,m3h1x1(:,15),heltab2x1(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(47),63,nMT,G2tensor(80),n2h1(72))
  call Hloop_QS_A(ntryL,G1H1(10),ex5(:),G1H1(65),ngH,m3h1x1(:,16),heltab2x1(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(65),16,nMT,G2tensor(81),n2h1(73))
  call Hloop_QS_A(ntryL,G1H1(16),ex5(:),G1H1(105),ngH,m3h1x1(:,17),heltab2x1(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(105),63,nMT,G2tensor(82),n2h1(74))
  call Hloop_VA_Q(ntryL,G1H2(25),ex2(:),G1H1(18),m3h2x1(:,109),heltab2x2(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(18),63,nMT,G2tensor(83),n2h1(75))
  call Hloop_VA_Q(ntryL,G1H2(30),ex2(:),G1H1(13),m3h2x1(:,110),heltab2x2(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(13),2,nMT,G2tensor(84),n2h1(76))
  call Hloop_VA_Q(ntryL,G1H2(74),ex2(:),G1H1(24),m3h2x1(:,111),heltab2x2(:,:,130))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(24),63,nMT,G2tensor(85),n2h1(77))
  call Hloop_AS_Q(ntryL,G1H1(21),ex5(:),G1H1(116),ngH,m3h1x1(:,18),heltab2x1(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(116),63,nMT,G2tensor(86),n2h1(78))
  call Hloop_AS_Q(ntryL,G1H1(22),ex5(:),G1H1(5),ngH,m3h1x1(:,19),heltab2x1(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(5),16,nMT,G2tensor(87),n2h1(79))
  call Hloop_AS_Q(ntryL,G1H1(29),ex5(:),G1H1(1),ngH,m3h1x1(:,20),heltab2x1(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(88),n2h1(80))
  call Hloop_VQ_A(ntryL,G1H2(75),ex3(:),G1H1(127),m3h2x1(:,112),heltab2x2(:,:,131))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(127),63,0,G2tensor(89),n2h1(81))
  call Hloop_VQ_A(ntryL,G1H2(76),ex3(:),G1H1(12),m3h2x1(:,113),heltab2x2(:,:,132))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(12),4,0,G2tensor(90),n2h1(82))
  call Hloop_VQ_A(ntryL,G1H2(80),ex3(:),G1H1(138),m3h2x1(:,114),heltab2x2(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(138),63,0,G2tensor(91),n2h1(83))
  call Hloop_VA_Q(ntryL,G1H2(7),ex4(:),G1H1(9),m3h2x1(:,115),heltab2x2(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),63,0,G2tensor(92),n2h1(84))
  call Hloop_VA_Q(ntryL,G1H2(81),ex4(:),G1H1(47),m3h2x1(:,116),heltab2x2(:,:,135))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(47),8,0,G2tensor(93),n2h1(85))
  call Hloop_VA_Q(ntryL,G1H2(85),ex4(:),G1H1(10),m3h2x1(:,117),heltab2x2(:,:,136))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(10),63,0,G2tensor(94),n2h1(86))
  call Hloop_VQ_A(ntryL,G1H2(18),ex3(:),G1H1(65),m3h2x1(:,118),heltab2x2(:,:,137))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(65),63,0,G2tensor(95),n2h1(87))
  call Hloop_VQ_A(ntryL,G1H2(86),ex3(:),G1H1(16),m3h2x1(:,119),heltab2x2(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(16),4,0,G2tensor(96),n2h1(88))
  call Hloop_VQ_A(ntryL,G1H2(90),ex3(:),G1H1(105),m3h2x1(:,120),heltab2x2(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(105),63,0,G2tensor(97),n2h1(89))
  call Hloop_VA_Q(ntryL,G1H2(6),ex4(:),G1H1(18),m3h2x1(:,121),heltab2x2(:,:,140))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(18),63,0,G2tensor(98),n2h1(90))
  call Hloop_VA_Q(ntryL,G1H2(91),ex4(:),G1H1(13),m3h2x1(:,122),heltab2x2(:,:,141))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(13),8,0,G2tensor(99),n2h1(91))
  call Hloop_VA_Q(ntryL,G1H2(95),ex4(:),G1H1(24),m3h2x1(:,123),heltab2x2(:,:,142))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(24),63,0,G2tensor(100),n2h1(92))
  call Hloop_VA_Q(ntryL,G1H2(20),ex4(:),G1H1(21),m3h2x1(:,124),heltab2x2(:,:,143))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(21),63,0,G2tensor(101),n2h1(93))
  call Hloop_VA_Q(ntryL,G1H2(96),ex4(:),G1H1(116),m3h2x1(:,125),heltab2x2(:,:,144))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(116),8,0,G2tensor(102),n2h1(94))
  call Hloop_VA_Q(ntryL,G1H2(100),ex4(:),G1H1(22),m3h2x1(:,126),heltab2x2(:,:,145))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(22),63,0,G2tensor(103),n2h1(95))
  call Hloop_VA_Q(ntryL,G1H2(101),ex4(:),G1H1(5),m3h2x1(:,127),heltab2x2(:,:,146))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(5),63,0,G2tensor(104),n2h1(96))
  call Hloop_VA_Q(ntryL,G1H2(102),ex4(:),G1H1(29),m3h2x1(:,128),heltab2x2(:,:,147))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(29),8,0,G2tensor(105),n2h1(97))
  call Hloop_VA_Q(ntryL,G1H2(106),ex4(:),G1H1(1),m3h2x1(:,129),heltab2x2(:,:,148))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(106),n2h1(98))
  call Hloop_VA_Q(ntryL,G1H2(107),ex4(:),G1H1(127),m3h2x1(:,130),heltab2x2(:,:,149))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(127),63,0,G2tensor(107),n2h1(99))
  call Hloop_VA_Q(ntryL,G1H2(108),ex4(:),G1H1(12),m3h2x1(:,131),heltab2x2(:,:,150))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(12),8,0,G2tensor(108),n2h1(100))
  call Hloop_VA_Q(ntryL,G1H2(112),ex4(:),G1H1(138),m3h2x1(:,132),heltab2x2(:,:,151))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(138),63,0,G2tensor(109),n2h1(101))
  call Hloop_VA_Q(ntryL,G1H2(113),ex4(:),G1H1(9),m3h2x1(:,133),heltab2x2(:,:,152))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),63,0,G2tensor(110),n2h1(102))
  call Hloop_VA_Q(ntryL,G1H2(114),ex4(:),G1H1(47),m3h2x1(:,134),heltab2x2(:,:,153))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(47),8,0,G2tensor(111),n2h1(103))
  call Hloop_VA_Q(ntryL,G1H2(118),ex4(:),G1H1(10),m3h2x1(:,135),heltab2x2(:,:,154))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(10),63,0,G2tensor(112),n2h1(104))
  call Hloop_QS_A(ntryL,G1H1(30),ex5(:),G1H1(65),ngH,m3h1x1(:,21),heltab2x1(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(65),63,nMT,G2tensor(113),n2h1(105))
  call Hloop_QS_A(ntryL,G1H1(31),ex5(:),G1H1(16),ngH,m3h1x1(:,22),heltab2x1(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(16),16,nMT,G2tensor(114),n2h1(106))
  call Hloop_QS_A(ntryL,G1H1(35),ex5(:),G1H1(105),ngH,m3h1x1(:,23),heltab2x1(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(105),63,nMT,G2tensor(115),n2h1(107))
  call Hloop_QS_A(ntryL,G1H1(36),ex5(:),G1H1(18),ngH,m3h1x1(:,24),heltab2x1(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(18),63,nMT,G2tensor(116),n2h1(108))
  call Hloop_QS_A(ntryL,G1H1(37),ex5(:),G1H1(13),ngH,m3h1x1(:,25),heltab2x1(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(13),16,nMT,G2tensor(117),n2h1(109))
  call Hloop_QS_A(ntryL,G1H1(41),ex5(:),G1H1(24),ngH,m3h1x1(:,26),heltab2x1(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(24),63,nMT,G2tensor(118),n2h1(110))
  call Hloop_QS_A(ntryL,G1H1(42),ex5(:),G1H1(21),ngH,m3h1x1(:,27),heltab2x1(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(21),63,nMT,G2tensor(119),n2h1(111))
  call Hloop_QS_A(ntryL,G1H1(43),ex5(:),G1H1(116),ngH,m3h1x1(:,28),heltab2x1(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(116),16,nMT,G2tensor(120),n2h1(112))
  call Hloop_QS_A(ntryL,G1H1(90),ex5(:),G1H1(22),ngH,m3h1x1(:,29),heltab2x1(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(22),63,nMT,G2tensor(121),n2h1(113))
  call Hloop_AS_Q(ntryL,G1H1(48),ex5(:),G1H1(5),ngH,m3h1x1(:,30),heltab2x1(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(5),63,nMT,G2tensor(122),n2h1(114))
  call Hloop_AS_Q(ntryL,G1H1(49),ex5(:),G1H1(29),ngH,m3h1x1(:,31),heltab2x1(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(29),16,nMT,G2tensor(123),n2h1(115))
  call Hloop_AS_Q(ntryL,G1H1(53),ex5(:),G1H1(1),ngH,m3h1x1(:,32),heltab2x1(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(124),n2h1(116))
  call Hloop_AS_Q(ntryL,G1H1(54),ex5(:),G1H1(127),ngH,m3h1x1(:,33),heltab2x1(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(127),63,nMT,G2tensor(125),n2h1(117))
  call Hloop_AS_Q(ntryL,G1H1(55),ex5(:),G1H1(12),ngH,m3h1x1(:,34),heltab2x1(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(12),16,nMT,G2tensor(126),n2h1(118))
  call Hloop_AS_Q(ntryL,G1H1(59),ex5(:),G1H1(138),ngH,m3h1x1(:,35),heltab2x1(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(138),63,nMT,G2tensor(127),n2h1(119))
  call Hloop_AS_Q(ntryL,G1H1(60),ex5(:),G1H1(9),ngH,m3h1x1(:,36),heltab2x1(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),63,nMT,G2tensor(128),n2h1(120))
  call Hloop_AS_Q(ntryL,G1H1(61),ex5(:),G1H1(47),ngH,m3h1x1(:,37),heltab2x1(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(47),16,nMT,G2tensor(129),n2h1(121))
  call Hloop_AS_Q(ntryL,G1H1(95),ex5(:),G1H1(10),ngH,m3h1x1(:,38),heltab2x1(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(10),63,nMT,G2tensor(130),n2h1(122))
  call Hloop_QS_A(ntryL,G1H1(66),ex5(:),G1H1(30),ngH,m3h1x1(:,39),heltab2x1(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(30),63,nMT,G2tensor(131),n2h1(123))
  call Hloop_QS_A(ntryL,G1H1(67),ex5(:),G1H1(65),ngH,m3h1x1(:,40),heltab2x1(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(65),16,nMT,G2tensor(132),n2h1(124))
  call Hloop_QS_A(ntryL,G1H1(71),ex5(:),G1H1(31),ngH,m3h1x1(:,41),heltab2x1(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(31),63,nMT,G2tensor(133),n2h1(125))
  call Hloop_QS_A(ntryL,G1H1(72),ex5(:),G1H1(16),ngH,m3h1x1(:,42),heltab2x1(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(16),63,nMT,G2tensor(134),n2h1(126))
  call Hloop_QS_A(ntryL,G1H1(73),ex5(:),G1H1(35),ngH,m3h1x1(:,43),heltab2x1(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(35),16,nMT,G2tensor(135),n2h1(127))
  call Hloop_QS_A(ntryL,G1H1(77),ex5(:),G1H1(105),ngH,m3h1x1(:,44),heltab2x1(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(105),63,nMT,G2tensor(136),n2h1(128))
  call Hloop_AS_Q(ntryL,G1H1(78),ex5(:),G1H1(36),ngH,m3h1x1(:,45),heltab2x1(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(36),63,nMT,G2tensor(137),n2h1(129))
  call Hloop_AS_Q(ntryL,G1H1(79),ex5(:),G1H1(18),ngH,m3h1x1(:,46),heltab2x1(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(18),16,nMT,G2tensor(138),n2h1(130))
  call Hloop_AS_Q(ntryL,G1H1(83),ex5(:),G1H1(37),ngH,m3h1x1(:,47),heltab2x1(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(37),63,nMT,G2tensor(139),n2h1(131))
  call Hloop_AS_Q(ntryL,G1H1(84),ex5(:),G1H1(13),ngH,m3h1x1(:,48),heltab2x1(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(13),63,nMT,G2tensor(140),n2h1(132))
  call Hloop_AS_Q(ntryL,G1H1(85),ex5(:),G1H1(41),ngH,m3h1x1(:,49),heltab2x1(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(41),16,nMT,G2tensor(141),n2h1(133))
  call Hloop_AS_Q(ntryL,G1H1(89),ex5(:),G1H1(24),ngH,m3h1x1(:,50),heltab2x1(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(24),63,nMT,G2tensor(142),n2h1(134))
  call Hloop_VQ_A(ntryL,G1H2(119),wf2(:,2),G1H1(42),m3h2x1(:,136),heltab2x2(:,:,155))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),63,nMT,G2tensor(143),n2h1(135))
  call Hloop_VQ_A(ntryL,G1H2(120),wf2(:,2),G1H1(21),m3h2x1(:,137),heltab2x2(:,:,156))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(21),17,nMT,G2tensor(144),n2h1(136))
  call Hloop_VQ_A(ntryL,G1H2(124),wf2(:,2),G1H1(43),m3h2x1(:,138),heltab2x2(:,:,157))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(43),63,nMT,G2tensor(145),n2h1(137))
  call Hloop_VQ_A(ntryL,G1H2(125),wf2(:,2),G1H1(116),m3h2x1(:,139),heltab2x2(:,:,158))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(116),63,nMT,G2tensor(146),n2h1(138))
  call Hloop_VQ_A(ntryL,G1H2(126),wf2(:,2),G1H1(90),m3h2x1(:,140),heltab2x2(:,:,159))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(90),17,nMT,G2tensor(147),n2h1(139))
  call Hloop_VQ_A(ntryL,G1H2(130),wf2(:,2),G1H1(22),m3h2x1(:,141),heltab2x2(:,:,160))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(22),63,nMT,G2tensor(148),n2h1(140))
  call Hloop_VA_Q(ntryL,G1H2(131),wf2(:,4),G1H1(48),m3h2x1(:,142),heltab2x2(:,:,161))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(48),63,nMT,G2tensor(149),n2h1(141))
  call Hloop_VA_Q(ntryL,G1H2(132),wf2(:,4),G1H1(5),m3h2x1(:,143),heltab2x2(:,:,162))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(5),18,nMT,G2tensor(150),n2h1(142))
  call Hloop_VA_Q(ntryL,G1H2(136),wf2(:,4),G1H1(49),m3h2x1(:,144),heltab2x2(:,:,163))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(49),63,nMT,G2tensor(151),n2h1(143))
  call Hloop_VA_Q(ntryL,G1H2(137),wf2(:,4),G1H1(29),m3h2x1(:,145),heltab2x2(:,:,164))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(29),63,nMT,G2tensor(152),n2h1(144))
  call Hloop_VA_Q(ntryL,G1H2(138),wf2(:,4),G1H1(53),m3h2x1(:,146),heltab2x2(:,:,165))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(53),18,nMT,G2tensor(153),n2h1(145))
  call Hloop_VA_Q(ntryL,G1H2(142),wf2(:,4),G1H1(1),m3h2x1(:,147),heltab2x2(:,:,166))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(154),n2h1(146))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(34),51,wf4(:,2),12,G2tensor(155),m3h4x1(:,9),heltab2x4(:,:,155))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(44),0,wf4(:,2),12,G2tensor(156),m3h4x1(:,10),heltab2x4(:,:,156))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(26),51,wf4(:,2),12,G2tensor(157),m3h4x1(:,11),heltab2x4(:,:,157))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(20),2,wf4(:,2),12,G2tensor(158),m3h4x1(:,12),heltab2x4(:,:,158))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(12),51,wf4(:,2),12,G2tensor(159),m3h4x1(:,13),heltab2x4(:,:,159))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(25),0,wf4(:,2),12,G2tensor(160),m3h4x1(:,14),heltab2x4(:,:,160))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(47),51,wf4(:,2),12,G2tensor(161),m3h4x1(:,15),heltab2x4(:,:,161))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(48),1,wf4(:,2),12,G2tensor(162),m3h4x1(:,16),heltab2x4(:,:,162))
  call Hloop_QS_A(ntryL,G1H1(91),ex5(:),G1H1(54),ngH,m3h1x1(:,51),heltab2x1(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(54),17,nMT,G2tensor(163),n2h1(151))
  call Hloop_AS_Q(ntryL,G1H1(96),ex5(:),G1H1(127),ngH,m3h1x1(:,52),heltab2x1(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(127),18,nMT,G2tensor(164),n2h1(152))
  call Hloop_QV_A(ntryL,G1H4(59),wf4(:,2),G1H1(55),m3h4x1(:,17),heltab2x4(:,:,163))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(55),63,nMT,G2tensor(165),n2h1(153))
  call Hloop_QV_A(ntryL,G1H4(29),wf4(:,2),G1H1(12),m3h4x1(:,18),heltab2x4(:,:,164))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(12),12,nMT,G2tensor(166),n2h1(154))
  call Hloop_QV_A(ntryL,G1H4(64),wf4(:,2),G1H1(59),m3h4x1(:,19),heltab2x4(:,:,165))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(59),63,nMT,G2tensor(167),n2h1(155))
  call Hloop_QV_A(ntryL,G1H4(67),wf4(:,2),G1H1(138),m3h4x1(:,20),heltab2x4(:,:,166))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(138),28,nMT,G2tensor(168),n2h1(156))
  call Hloop_QS_A(ntryL,G1H1(100),ex5(:),G1H1(60),ngH,m3h1x1(:,53),heltab2x1(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(60),63,nMT,G2tensor(169),n2h1(157))
  call Hloop_QS_A(ntryL,G1H1(101),ex5(:),G1H1(9),ngH,m3h1x1(:,54),heltab2x1(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),16,nMT,G2tensor(170),n2h1(158))
  call Hloop_QS_A(ntryL,G1H1(106),ex5(:),G1H1(61),ngH,m3h1x1(:,55),heltab2x1(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(61),63,nMT,G2tensor(171),n2h1(159))
  call Hloop_QS_A(ntryL,G1H1(107),ex5(:),G1H1(47),ngH,m3h1x1(:,56),heltab2x1(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(47),17,nMT,G2tensor(172),n2h1(160))
  call Hloop_AV_Q(ntryL,G1H4(70),wf4(:,2),G1H1(95),m3h4x1(:,21),heltab2x4(:,:,167))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(95),63,nMT,G2tensor(173),n2h1(161))
  call Hloop_AV_Q(ntryL,G1H4(71),wf4(:,2),G1H1(10),m3h4x1(:,22),heltab2x4(:,:,168))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(10),12,nMT,G2tensor(174),n2h1(162))
  call Hloop_AV_Q(ntryL,G1H4(53),wf4(:,2),G1H1(66),m3h4x1(:,23),heltab2x4(:,:,169))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(66),63,nMT,G2tensor(175),n2h1(163))
  call Hloop_AV_Q(ntryL,G1H4(7),wf4(:,2),G1H1(30),m3h4x1(:,24),heltab2x4(:,:,170))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(30),28,nMT,G2tensor(176),n2h1(164))
  call Hloop_AS_Q(ntryL,G1H1(111),ex5(:),G1H1(67),ngH,m3h1x1(:,57),heltab2x1(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(67),63,nMT,G2tensor(177),n2h1(165))
  call Hloop_AS_Q(ntryL,G1H1(112),ex5(:),G1H1(65),ngH,m3h1x1(:,58),heltab2x1(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(65),16,nMT,G2tensor(178),n2h1(166))
  call Hloop_AS_Q(ntryL,G1H1(117),ex5(:),G1H1(71),ngH,m3h1x1(:,59),heltab2x1(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(71),63,nMT,G2tensor(179),n2h1(167))
  call Hloop_AS_Q(ntryL,G1H1(118),ex5(:),G1H1(31),ngH,m3h1x1(:,60),heltab2x1(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(31),28,nMT,G2tensor(180),n2h1(168))
  call Hloop_AS_Q(ntryL,G1H1(122),ex5(:),G1H1(72),ngH,m3h1x1(:,61),heltab2x1(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(72),63,nMT,G2tensor(181),n2h1(169))
  call Hloop_AS_Q(ntryL,G1H1(123),ex5(:),G1H1(16),ngH,m3h1x1(:,62),heltab2x1(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(16),16,nMT,G2tensor(182),n2h1(170))
  call Hloop_AS_Q(ntryL,G1H1(128),ex5(:),G1H1(73),ngH,m3h1x1(:,63),heltab2x1(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(73),63,nMT,G2tensor(183),n2h1(171))
  call Hloop_AS_Q(ntryL,G1H1(129),ex5(:),G1H1(35),ngH,m3h1x1(:,64),heltab2x1(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(35),18,nMT,G2tensor(184),n2h1(172))
  call Hloop_QS_A(ntryL,G1H1(133),ex5(:),G1H1(77),ngH,m3h1x1(:,65),heltab2x1(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(77),63,nMT,G2tensor(185),n2h1(173))
  call Hloop_QS_A(ntryL,G1H1(134),ex5(:),G1H1(105),ngH,m3h1x1(:,66),heltab2x1(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(105),16,nMT,G2tensor(186),n2h1(174))
  call Hloop_QS_A(ntryL,G1H1(139),ex5(:),G1H1(78),ngH,m3h1x1(:,67),heltab2x1(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(78),63,nMT,G2tensor(187),n2h1(175))
  call Hloop_QS_A(ntryL,G1H1(140),ex5(:),G1H1(36),ngH,m3h1x1(:,68),heltab2x1(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(36),28,nMT,G2tensor(188),n2h1(176))
  call ol_merge_tensors(G2tensor(27),[G2tensor(6),G1tensor(26)])
  call ol_merge_tensors(G2tensor(29),[G2tensor(8),G1tensor(32)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(10),G1tensor(38)])
  call ol_merge_tensors(G2tensor(71),[G2tensor(12),G1tensor(44)])
  call ol_merge_tensors(G2tensor(77),[G2tensor(14),G1tensor(50)])
  call ol_merge_tensors(G2tensor(83),[G2tensor(16),G1tensor(56)])
  call ol_merge_tensors(G2tensor(89),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(33),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(5)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(6)])
  call ol_merge_tensors(G2tensor(92),[G1tensor(33),G1tensor(8)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(11)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(12)])
  call ol_merge_tensors(G2tensor(95),[G1tensor(14)])
  call ol_merge_tensors(G2tensor(39),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(17)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(18)])
  call ol_merge_tensors(G2tensor(98),[G1tensor(27),G1tensor(20)])
  call ol_merge_tensors(G2tensor(43),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(45),[G1tensor(22)])
  call ol_merge_tensors(G2tensor(25),[G1tensor(23)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(24)])
  call ol_merge_tensors(G2tensor(101),[G1tensor(28)])
  call ol_merge_tensors(G2tensor(104),[G1tensor(29)])
  call ol_merge_tensors(G2tensor(59),[G1tensor(30)])
  call ol_merge_tensors(G2tensor(107),[G1tensor(34)])
  call ol_merge_tensors(G2tensor(110),[G1tensor(35)])
  call ol_merge_tensors(G2tensor(62),[G1tensor(36)])
  call ol_merge_tensors(G2tensor(113),[G1tensor(39)])
  call ol_merge_tensors(G2tensor(116),[G1tensor(40)])
  call ol_merge_tensors(G2tensor(119),[G1tensor(53),G1tensor(41)])
  call ol_merge_tensors(G2tensor(68),[G1tensor(42)])
  call ol_merge_tensors(G2tensor(122),[G1tensor(45)])
  call ol_merge_tensors(G2tensor(125),[G1tensor(46)])
  call ol_merge_tensors(G2tensor(128),[G1tensor(59),G1tensor(47)])
  call ol_merge_tensors(G2tensor(74),[G1tensor(48)])
  call ol_merge_tensors(G2tensor(131),[G1tensor(51)])
  call ol_merge_tensors(G2tensor(134),[G1tensor(52)])
  call ol_merge_tensors(G2tensor(80),[G1tensor(54)])
  call ol_merge_tensors(G2tensor(137),[G1tensor(57)])
  call ol_merge_tensors(G2tensor(140),[G1tensor(58)])
  call ol_merge_tensors(G2tensor(86),[G1tensor(60)])
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(19),mass5set(:,2),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25),G1tensor(31))
  call G_TensorShift(G1tensor(7),2)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(20),mass5set(:,2),  & 
G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55),G1tensor(26),G1tensor(32))
  call G_TensorShift(G1tensor(43),1)
  call Hotf_5pt_reduction_last(G2tensor(65),RedSet_5(43),mass5set(:,3),  & 
G1tensor(38),G1tensor(44),G1tensor(50),G1tensor(56),G1tensor(2),G1tensor(3))
  call G_TensorShift(G1tensor(44),1)
  call Hotf_5pt_reduction_last(G2tensor(71),RedSet_5(45),mass5set(:,3),  & 
G1tensor(4),G1tensor(5),G1tensor(6),G1tensor(33),G1tensor(8),G1tensor(9))
  call G_TensorShift(G1tensor(5),2)
  call Hotf_5pt_reduction_last(G2tensor(77),RedSet_5(47),mass5set(:,3),  & 
G1tensor(10),G1tensor(11),G1tensor(12),G1tensor(14),G1tensor(15),G1tensor(16))
  call G_TensorShift(G1tensor(11),1)
  call Hotf_5pt_reduction_last(G2tensor(83),RedSet_5(49),mass5set(:,3),  & 
G1tensor(17),G1tensor(18),G1tensor(27),G1tensor(20),G1tensor(21),G1tensor(22))
  call G_TensorShift(G1tensor(18),2)
  call Hotf_5pt_reduction_last(G2tensor(89),RedSet_5(51),mass5set(:,1),  & 
G1tensor(23),G1tensor(24),G1tensor(28),G1tensor(29),G1tensor(30),G1tensor(34))
  call G_TensorShift(G1tensor(24),4)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(23),mass5set(:,7),  & 
G1tensor(35),G1tensor(36),G1tensor(39),G1tensor(40),G1tensor(53),G1tensor(41))
  call G_TensorShift(G1tensor(36),8)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(24),mass5set(:,5),  & 
G1tensor(42),G1tensor(45),G1tensor(46),G1tensor(59),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(45),8)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(15),mass5set(:,5),  & 
G1tensor(51),G1tensor(52),G1tensor(54),G1tensor(57),G1tensor(58),G1tensor(60))
  call G_TensorShift(G1tensor(52),8)
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(9),mass5set(:,1),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(92),RedSet_5(52),mass5set(:,1),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),8)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(25),mass5set(:,7),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),4)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(26),mass5set(:,5),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),4)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(16),mass5set(:,5),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),4)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(10),mass5set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),4)
  call Hotf_5pt_reduction_last(G2tensor(95),RedSet_5(53),mass5set(:,1),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),4)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(27),mass5set(:,7),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),8)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(28),mass5set(:,5),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),8)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(17),mass5set(:,5),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),8)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(11),mass5set(:,1),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),8)
  call Hotf_5pt_reduction_last(G2tensor(98),RedSet_5(54),mass5set(:,1),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),8)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(29),mass5set(:,7),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),4)
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(30),mass5set(:,5),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),4)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(18),mass5set(:,5),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),4)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(12),mass5set(:,1),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),4)
  call Hotf_5pt_reduction_last(G2tensor(101),RedSet_5(55),mass5set(:,1),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),8)
  call Hotf_5pt_reduction_last(G2tensor(104),RedSet_5(56),mass5set(:,11),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),8)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(41),mass5set(:,11),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),8)
  call Hotf_5pt_reduction_last(G2tensor(107),RedSet_5(57),mass5set(:,1),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),8)
  call Hotf_5pt_reduction_last(G2tensor(110),RedSet_5(58),mass5set(:,11),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),8)
  call Hotf_5pt_reduction_last(G2tensor(62),RedSet_5(42),mass5set(:,11),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),8)
  call Hotf_5pt_reduction_last(G2tensor(113),RedSet_5(59),mass5set(:,12),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),16)
  call Hotf_5pt_reduction_last(G2tensor(116),RedSet_5(60),mass5set(:,6),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),16)
  call Hotf_5pt_reduction_last(G2tensor(119),RedSet_5(21),mass5set(:,6),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),16)
  call Hotf_5pt_reduction_last(G2tensor(68),RedSet_5(44),mass5set(:,6),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),16)
  call Hotf_5pt_reduction_last(G2tensor(122),RedSet_5(61),mass5set(:,12),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),16)
  call Hotf_5pt_reduction_last(G2tensor(125),RedSet_5(62),mass5set(:,6),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),16)
  call Hotf_5pt_reduction_last(G2tensor(128),RedSet_5(22),mass5set(:,6),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),16)
  call Hotf_5pt_reduction_last(G2tensor(74),RedSet_5(46),mass5set(:,6),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),16)
  call Hotf_5pt_reduction_last(G2tensor(131),RedSet_5(63),mass5set(:,12),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
  call G_TensorShift(G1tensor(242),16)
  call Hotf_5pt_reduction_last(G2tensor(134),RedSet_5(64),mass5set(:,6),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
  call G_TensorShift(G1tensor(248),16)
  call Hotf_5pt_reduction_last(G2tensor(80),RedSet_5(48),mass5set(:,6),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257),G1tensor(258))
  call G_TensorShift(G1tensor(254),16)
  call Hotf_5pt_reduction_last(G2tensor(137),RedSet_5(65),mass5set(:,12),  & 
G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264))
  call G_TensorShift(G1tensor(260),16)
  call Hotf_5pt_reduction_last(G2tensor(140),RedSet_5(66),mass5set(:,6),  & 
G1tensor(265),G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(266),16)
  call Hotf_5pt_reduction_last(G2tensor(86),RedSet_5(50),mass5set(:,6),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275),G1tensor(276))
  call G_TensorShift(G1tensor(272),16)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(37),mass5set(:,10),  & 
G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280),G1tensor(281),G1tensor(282))
  call G_TensorShift(G1tensor(278),17)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(38),mass5set(:,10),  & 
G1tensor(283),G1tensor(284),G1tensor(285),G1tensor(286),G1tensor(287),G1tensor(288))
  call G_TensorShift(G1tensor(284),17)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(39),mass5set(:,10),  & 
G1tensor(289),G1tensor(290),G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294))
  call G_TensorShift(G1tensor(290),18)
  call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(40),mass5set(:,10),  & 
G1tensor(295),G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300))
  call G_TensorShift(G1tensor(296),18)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(13),mass5set(:,4),  & 
G1tensor(301),G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305),G1tensor(306))
  call G_TensorShift(G1tensor(302),2)
  call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(14),mass5set(:,4),  & 
G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310),G1tensor(311),G1tensor(312))
  call G_TensorShift(G1tensor(308),2)
  call Hotf_5pt_reduction_last(G2tensor(143),RedSet_5(7),mass5set(:,3),  & 
G1tensor(313),G1tensor(314),G1tensor(315),G1tensor(316),G1tensor(317),G1tensor(318))
  call G_TensorShift(G1tensor(314),17)
  call Hotf_5pt_reduction_last(G2tensor(146),RedSet_5(5),mass5set(:,3),  & 
G1tensor(319),G1tensor(320),G1tensor(321),G1tensor(322),G1tensor(323),G1tensor(324))
  call G_TensorShift(G1tensor(320),17)
  call Hotf_5pt_reduction_last(G2tensor(149),RedSet_5(6),mass5set(:,3),  & 
G1tensor(325),G1tensor(326),G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330))
  call G_TensorShift(G1tensor(326),18)
  call Hotf_5pt_reduction_last(G2tensor(152),RedSet_5(8),mass5set(:,3),  & 
G1tensor(331),G1tensor(332),G1tensor(333),G1tensor(334),G1tensor(335),G1tensor(336))
  call G_TensorShift(G1tensor(332),18)
  call Hotf_5pt_reduction_last(G2tensor(155),RedSet_5(2),mass5set(:,1),  & 
G1tensor(337),G1tensor(338),G1tensor(339),G1tensor(340),G1tensor(341),G1tensor(342))
  call G_TensorShift(G1tensor(338),12)
  call Hotf_5pt_reduction_last(G2tensor(159),RedSet_5(1),mass5set(:,1),  & 
G1tensor(343),G1tensor(344),G1tensor(345),G1tensor(346),G1tensor(347),G1tensor(348))
  call G_TensorShift(G1tensor(344),12)
  call Hotf_5pt_reduction_last(G2tensor(165),RedSet_5(31),mass5set(:,8),  & 
G1tensor(349),G1tensor(350),G1tensor(351),G1tensor(352),G1tensor(353),G1tensor(354))
  call G_TensorShift(G1tensor(350),12)
  call Hotf_5pt_reduction_last(G2tensor(169),RedSet_5(32),mass5set(:,9),  & 
G1tensor(355),G1tensor(356),G1tensor(357),G1tensor(358),G1tensor(359),G1tensor(360))
  call G_TensorShift(G1tensor(356),16)
  call Hotf_5pt_reduction_last(G2tensor(173),RedSet_5(33),mass5set(:,8),  & 
G1tensor(361),G1tensor(362),G1tensor(363),G1tensor(364),G1tensor(365),G1tensor(366))
  call G_TensorShift(G1tensor(362),12)
  call Hotf_5pt_reduction_last(G2tensor(177),RedSet_5(34),mass5set(:,8),  & 
G1tensor(367),G1tensor(368),G1tensor(369),G1tensor(370),G1tensor(371),G1tensor(372))
  call G_TensorShift(G1tensor(368),16)
  call Hotf_5pt_reduction_last(G2tensor(181),RedSet_5(35),mass5set(:,9),  & 
G1tensor(373),G1tensor(374),G1tensor(375),G1tensor(376),G1tensor(377),G1tensor(378))
  call G_TensorShift(G1tensor(374),16)
  call Hotf_5pt_reduction_last(G2tensor(185),RedSet_5(36),mass5set(:,8),  & 
G1tensor(379),G1tensor(380),G1tensor(381),G1tensor(382),G1tensor(383),G1tensor(384))
  call G_TensorShift(G1tensor(380),16)
  call ol_merge_tensors(T1sum(11),[G1tensor(1)])
  call ol_merge_tensors(T1sum(12),[G1tensor(37)])
  call ol_merge_tensors(T1sum(13),[G1tensor(38)])
  call ol_merge_tensors(T1sum(14),[G1tensor(4)])
  call ol_merge_tensors(T1sum(15),[G1tensor(10)])
  call ol_merge_tensors(T1sum(16),[G1tensor(17)])
  call ol_merge_tensors(T1sum(17),[G1tensor(23)])
  call ol_merge_tensors(T1sum(18),[G1tensor(35)])
  call ol_merge_tensors(T1sum(19),[G1tensor(42)])
  call ol_merge_tensors(T1sum(20),[G1tensor(51)])
  call ol_merge_tensors(T1sum(21),[G1tensor(61)])
  call ol_merge_tensors(T1sum(22),[G1tensor(67)])
  call ol_merge_tensors(T1sum(23),[G1tensor(73)])
  call ol_merge_tensors(T1sum(24),[G1tensor(79)])
  call ol_merge_tensors(T1sum(25),[G1tensor(85)])
  call ol_merge_tensors(T1sum(26),[G1tensor(91)])
  call ol_merge_tensors(T1sum(27),[G1tensor(97)])
  call ol_merge_tensors(T1sum(28),[G1tensor(103)])
  call ol_merge_tensors(T1sum(29),[G1tensor(109)])
  call ol_merge_tensors(T1sum(30),[G1tensor(115)])
  call ol_merge_tensors(T1sum(31),[G1tensor(121)])
  call ol_merge_tensors(T1sum(32),[G1tensor(127)])
  call ol_merge_tensors(T1sum(33),[G1tensor(133)])
  call ol_merge_tensors(T1sum(34),[G1tensor(139)])
  call ol_merge_tensors(T1sum(35),[G1tensor(145)])
  call ol_merge_tensors(T1sum(36),[G1tensor(151)])
  call ol_merge_tensors(T1sum(37),[G1tensor(157)])
  call ol_merge_tensors(T1sum(38),[G1tensor(163)])
  call ol_merge_tensors(T1sum(39),[G1tensor(169)])
  call ol_merge_tensors(T1sum(40),[G1tensor(175)])
  call ol_merge_tensors(T1sum(41),[G1tensor(181)])
  call ol_merge_tensors(T1sum(42),[G1tensor(187)])
  call ol_merge_tensors(T1sum(43),[G1tensor(193)])
  call ol_merge_tensors(T1sum(44),[G1tensor(199)])
  call ol_merge_tensors(T1sum(45),[G1tensor(205)])
  call ol_merge_tensors(T1sum(46),[G1tensor(211)])
  call ol_merge_tensors(T1sum(47),[G1tensor(217)])
  call ol_merge_tensors(T1sum(48),[G1tensor(223)])
  call ol_merge_tensors(T1sum(49),[G1tensor(229)])
  call ol_merge_tensors(T1sum(50),[G1tensor(235)])
  call ol_merge_tensors(T1sum(51),[G1tensor(241)])
  call ol_merge_tensors(T1sum(52),[G1tensor(247)])
  call ol_merge_tensors(T1sum(53),[G1tensor(253)])
  call ol_merge_tensors(T1sum(54),[G1tensor(259)])
  call ol_merge_tensors(T1sum(55),[G1tensor(265)])
  call ol_merge_tensors(T1sum(56),[G1tensor(271)])
  call ol_merge_tensors(T1sum(57),[G1tensor(277)])
  call ol_merge_tensors(T1sum(58),[G1tensor(283)])
  call ol_merge_tensors(T1sum(59),[G1tensor(289)])
  call ol_merge_tensors(T1sum(60),[G1tensor(295)])
  call ol_merge_tensors(T1sum(61),[G1tensor(301)])
  call ol_merge_tensors(T1sum(62),[G1tensor(307)])
  call ol_merge_tensors(T1sum(63),[G1tensor(313)])
  call ol_merge_tensors(T1sum(64),[G1tensor(319)])
  call ol_merge_tensors(T1sum(65),[G1tensor(325)])
  call ol_merge_tensors(T1sum(66),[G1tensor(331)])
  call ol_merge_tensors(T1sum(67),[G1tensor(337)])
  call ol_merge_tensors(T1sum(68),[G1tensor(343)])
  call ol_merge_tensors(T1sum(69),[G1tensor(349)])
  call ol_merge_tensors(T1sum(70),[G1tensor(355)])
  call ol_merge_tensors(T1sum(71),[G1tensor(361)])
  call ol_merge_tensors(T1sum(72),[G1tensor(367)])
  call ol_merge_tensors(T1sum(73),[G1tensor(373)])
  call ol_merge_tensors(T1sum(74),[G1tensor(379)])
  Gcoeff(:)%j = (c(22)*M(2,:)%j+c(17)*(-M(1,:)%j+M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(47),h0tab(:,47),[44,1,16,2],[0,nMT,nMT,0],5,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),ex6(:),wf4(:,2),G0H4(1),m4h2x4x4(:,1),heltab3x32(:,:,1))
  Gcoeff(:)%j = (c(22)*M(3,:)%j+c(17)*(-M(1,:)%j+M(4,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(48),h0tab(:,48),[44,1,16,2],[0,nMT,nMT,0],5,1,wf4(:,2))
  call Hloop_GGG_G_12(ntryL,G0H32(1),wf4(:,2),ex6(:),G0H4(2),m4h4x2x4(:,1),heltab3x32(:,:,2))
  Gcoeff(:)%j = (c(22)*(-M(2,:)%j+M(3,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(49),h0tab(:,49),[44,1,16,2],[0,nMT,nMT,0],5,1,wf4(:,2))
  call Hloop_GGG_G_23(ntryL,G0H32(1),ex6(:),wf4(:,2),G0H4(3),m4h2x4x4(:,2),heltab3x32(:,:,3))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*(M(1,:)%j+M(4,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(50),h0tab(:,50),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,2),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,39),heltab2x32(:,:,47))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(1),n2h16(23))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)+c(26)*(M(1,:)%j+M(4,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(51),h0tab(:,51),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,2),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,40),heltab2x32(:,:,48))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(2),n2h16(24))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)+c(2)*(M(1,:)%j+M(4,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(52),h0tab(:,52),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,2),wf4(:,16))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,41),heltab2x32(:,:,49))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(3),n2h16(25))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)+c(2)*(M(1,:)%j+M(4,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(53),h0tab(:,53),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,2),wf4(:,16))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,42),heltab2x32(:,:,50))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(4),n2h16(26))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)+c(26)*(M(1,:)%j+M(4,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(54),h0tab(:,54),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,16),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,43),heltab2x32(:,:,51))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(5),n2h16(27))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*(M(1,:)%j+M(4,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(55),h0tab(:,55),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,16),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,44),heltab2x32(:,:,52))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(6),n2h16(28))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)+c(2)*(M(1,:)%j+M(4,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(56),h0tab(:,56),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,16),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,45),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(7),n2h16(29))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)+c(2)*(M(1,:)%j+M(4,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(57),h0tab(:,57),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,16),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,46),heltab2x32(:,:,54))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(8),n2h16(30))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)+c(26)*(M(1,:)%j+M(4,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(58),h0tab(:,58),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,16),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,47),heltab2x32(:,:,55))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(9),n2h16(31))
  Gcoeff(:)%j = (-(c(27)*M(3,:)%j)+c(26)*(M(1,:)%j+M(4,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(59),h0tab(:,59),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,16),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,48),heltab2x32(:,:,56))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(10),n2h16(32))
  Gcoeff(:)%j = (-(c(3)*M(2,:)%j)+c(2)*(M(1,:)%j+M(4,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(60),h0tab(:,60),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,16),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,49),heltab2x32(:,:,57))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(11),n2h16(33))
  Gcoeff(:)%j = (-(c(3)*M(3,:)%j)+c(2)*(M(1,:)%j+M(4,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(61),h0tab(:,61),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,16),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,50),heltab2x32(:,:,58))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(12),n2h16(34))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(2,:)%j+c(17)*M(4,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(62),h0tab(:,62),[32,2,17,12],[nMT,0,nMT,nMT],4,2,wf2(:,2),wf4(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,51),heltab2x32(:,:,59))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(13),n2h16(35))
  Gcoeff(:)%j = (c(22)*M(2,:)%j+c(17)*(-M(1,:)%j+M(4,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(63),h0tab(:,63),[32,2,17,12],[0,nMT,0,0],4,2,wf2(:,2),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(14),m3h2x16(:,52),heltab2x32(:,:,60))
  Gcoeff(:)%j = (c(7)*M(4,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(64),h0tab(:,64),[32,2,12,17],[nMT,0,0,nMT],4,2,wf4(:,2),wf2(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,53),heltab2x32(:,:,61))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(15),n2h16(36))
  Gcoeff(:)%j = (-(c(7)*M(4,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(65),h0tab(:,65),[32,2,12,17],[0,nMT,nMT,0],4,2,wf4(:,2),wf2(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(16),m3h2x16(:,54),heltab2x32(:,:,62))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(3,:)%j+c(17)*M(4,:)%j) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(66),h0tab(:,66),[32,12,2,17],[nMT,nMT,0,nMT],4,2,wf4(:,2),wf2(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,55),heltab2x32(:,:,63))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(17),n2h16(37))
  Gcoeff(:)%j = (c(22)*M(3,:)%j+c(17)*(-M(1,:)%j+M(4,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(67),h0tab(:,67),[32,12,2,17],[0,0,nMT,0],4,2,wf4(:,2),wf2(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(18),m3h2x16(:,56),heltab2x32(:,:,64))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(3,:)%j+c(17)*M(4,:)%j) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(68),h0tab(:,68),[32,1,18,12],[nMT,0,nMT,nMT],4,2,wf2(:,4),wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,57),heltab2x32(:,:,65))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(19),n2h16(38))
  Gcoeff(:)%j = (c(22)*M(3,:)%j+c(17)*(-M(1,:)%j+M(4,:)%j)) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(69),h0tab(:,69),[32,1,18,12],[0,nMT,0,0],4,2,wf2(:,4),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(20),m3h2x16(:,58),heltab2x32(:,:,66))
  Gcoeff(:)%j = (-(c(7)*M(4,:)%j)) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(70),h0tab(:,70),[32,1,12,18],[nMT,0,0,nMT],4,2,wf4(:,2),wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,59),heltab2x32(:,:,67))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(21),n2h16(39))
  Gcoeff(:)%j = (c(7)*M(4,:)%j) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(71),h0tab(:,71),[32,1,12,18],[0,nMT,nMT,0],4,2,wf4(:,2),wf2(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(22),m3h2x16(:,60),heltab2x32(:,:,68))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(2,:)%j+c(17)*M(4,:)%j) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(72),h0tab(:,72),[32,12,1,18],[nMT,nMT,0,nMT],4,2,wf4(:,2),wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,61),heltab2x32(:,:,69))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(23),n2h16(40))
  Gcoeff(:)%j = (c(22)*M(2,:)%j+c(17)*(-M(1,:)%j+M(4,:)%j)) * den(91)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(73),h0tab(:,73),[32,12,1,18],[0,0,nMT,0],4,2,wf4(:,2),wf2(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(24),m3h2x16(:,62),heltab2x32(:,:,70))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(3,:)%j) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(74),h0tab(:,74),[33,2,16,12],[0,nMT,nMT,nMT],4,2,wf4(:,7),wf4(:,2))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,7),G0H8(1),m3h4x8(:,9),heltab2x32(:,:,71))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)+c(9)*M(3,:)%j) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(75),h0tab(:,75),[33,12,2,16],[0,0,nMT,nMT],4,2,wf4(:,7),wf4(:,2))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,7),G0H8(2),m3h4x8(:,10),heltab2x32(:,:,72))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(3,:)%j) * den(95)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(76),h0tab(:,76),[33,2,12,16],[0,nMT,nMT,nMT],4,2,wf4(:,7),wf4(:,2))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,7),G0H8(3),m3h4x8(:,11),heltab2x32(:,:,73))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(77),h0tab(:,77),[34,1,16,12],[0,nMT,nMT,nMT],4,2,wf4(:,3),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,3),G0H8(4),m3h4x8(:,12),heltab2x32(:,:,74))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(78),h0tab(:,78),[34,12,1,16],[0,0,nMT,nMT],4,2,wf4(:,3),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,3),G0H8(5),m3h4x8(:,13),heltab2x32(:,:,75))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(2,:)%j) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(79),h0tab(:,79),[34,1,12,16],[0,nMT,nMT,nMT],4,2,wf4(:,3),wf4(:,2))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,3),G0H8(6),m3h4x8(:,14),heltab2x32(:,:,76))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)+c(9)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(80),h0tab(:,80),[32,2,16,13],[0,nMT,nMT,0],4,1,wf8(:,7))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(25),m3h2x16(:,63),heltab2x32(:,:,77))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(81),h0tab(:,81),[32,13,2,16],[nMT,0,nMT,nMT],4,1,wf8(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,64),heltab2x32(:,:,78))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(26),n2h16(41))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(82),h0tab(:,82),[32,2,13,16],[nMT,0,nMT,nMT],4,1,wf8(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,65),heltab2x32(:,:,79))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(27),n2h16(42))
  Gcoeff(:)%j = (c(7)*M(1,:)%j-c(9)*M(3,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(83),h0tab(:,83),[32,1,16,14],[0,nMT,nMT,0],4,1,wf8(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(28),m3h2x16(:,66),heltab2x32(:,:,80))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(3,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(84),h0tab(:,84),[32,14,1,16],[nMT,0,nMT,nMT],4,1,wf8(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,67),heltab2x32(:,:,81))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(29),n2h16(43))
  Gcoeff(:)%j = (c(13)*M(1,:)%j-c(14)*M(3,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(85),h0tab(:,85),[32,1,14,16],[nMT,0,nMT,nMT],4,1,wf8(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,68),heltab2x32(:,:,82))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(30),n2h16(44))
  Gcoeff(:)%j = (c(6)*(-M(2,:)%j+M(3,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(86),h0tab(:,86),[44,2,1,16],[nMT,0,nMT,nMT],4,1,wf8(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,2),G0H4(4),m3h8x4(:,1),heltab2x32(:,:,83))
  call Hloop_Q_A(ntryL,G0H4(4),44,nMT,G1H4(80),n2h4(77))
  Gcoeff(:)%j = (c(6)*(-M(2,:)%j+M(3,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(87),h0tab(:,87),[44,1,2,16],[nMT,0,nMT,nMT],4,1,wf8(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,2),G0H4(4),m3h8x4(:,2),heltab2x32(:,:,84))
  call Hloop_A_Q(ntryL,G0H4(4),44,nMT,G1H4(2),n2h4(78))
  Gcoeff(:)%j = (c(22)*(-M(2,:)%j+M(3,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(88),h0tab(:,88),[44,1,16,2],[0,nMT,nMT,0],4,1,wf8(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,2),44,G1H4(81),m3h8x4(:,3),heltab2x32(:,:,85))
  Gcoeff(:)%j = (c(18)*M(1,:)%j-c(15)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(89),h0tab(:,89),[34,8,4,17],[0,0,0,nMT],4,2,wf4(:,3),wf2(:,2))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,3),G0H8(7),m3h4x8(:,15),heltab2x32(:,:,86))
  Gcoeff(:)%j = (c(13)*M(1,:)%j+c(20)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(90),h0tab(:,90),[34,4,8,17],[0,0,0,nMT],4,2,wf4(:,3),wf2(:,2))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,3),G0H8(8),m3h4x8(:,16),heltab2x32(:,:,87))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)+c(18)*M(4,:)%j) * den(162)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(91),h0tab(:,91),[36,8,2,17],[0,0,nMT,0],4,2,wf4(:,13),wf2(:,2))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,13),G0H8(9),m3h4x8(:,17),heltab2x32(:,:,88))
  call Hloop_Q_A(ntryL,G0H8(9),36,0,G1H8(21),n2h8(60))
  Gcoeff(:)%j = (c(20)*M(2,:)%j+c(13)*M(4,:)%j) * den(162)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(92),h0tab(:,92),[36,2,17,8],[0,nMT,0,0],4,2,wf4(:,13),wf2(:,2))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,13),G0H8(9),m3h4x8(:,18),heltab2x32(:,:,89))
  Gcoeff(:)%j = (c(20)*M(3,:)%j+c(13)*M(4,:)%j) * den(163)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(93),h0tab(:,93),[40,4,2,17],[0,0,nMT,0],4,2,wf4(:,15),wf2(:,2))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(10),m3h4x8(:,19),heltab2x32(:,:,90))
  call Hloop_A_Q(ntryL,G0H8(10),40,0,G1H8(16),n2h8(61))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)+c(18)*M(4,:)%j) * den(163)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(94),h0tab(:,94),[40,2,17,4],[0,nMT,0,0],4,2,wf4(:,15),wf2(:,2))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,15),G0H8(10),m3h4x8(:,20),heltab2x32(:,:,91))
  Gcoeff(:)%j = (c(17)*M(1,:)%j-c(14)*M(2,:)%j+c(13)*M(4,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(95),h0tab(:,95),[32,4,8,19],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,69),heltab2x32(:,:,92))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(31),n2h16(45))
  Gcoeff(:)%j = (c(22)*M(2,:)%j+c(17)*(M(1,:)%j-M(4,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(96),h0tab(:,96),[32,4,8,19],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(32),m3h2x16(:,70),heltab2x32(:,:,93))
  Gcoeff(:)%j = (c(17)*M(1,:)%j-c(14)*M(3,:)%j+c(13)*M(4,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(97),h0tab(:,97),[32,8,4,19],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,71),heltab2x32(:,:,94))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(33),n2h16(46))
  Gcoeff(:)%j = (c(22)*M(3,:)%j+c(17)*(M(1,:)%j-M(4,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(98),h0tab(:,98),[32,8,4,19],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(34),m3h2x16(:,72),heltab2x32(:,:,95))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(99),h0tab(:,99),[32,4,19,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,73),heltab2x32(:,:,96))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(35),n2h16(47))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(100),h0tab(:,100),[32,4,19,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(36),m3h2x16(:,74),heltab2x32(:,:,97))
  Gcoeff(:)%j = (c(13)*M(1,:)%j+c(20)*M(3,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(101),h0tab(:,101),[49,2,4,8],[nMT,0,0,0],4,1,wf4(:,34))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,34),G0H8(11),m3h4x8(:,21),heltab2x32(:,:,98))
  call Hloop_Q_A(ntryL,G0H8(11),49,nMT,G1H8(26),n2h8(62))
  Gcoeff(:)%j = (c(18)*M(1,:)%j-c(15)*M(3,:)%j) * den(57)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(102),h0tab(:,102),[49,2,8,4],[nMT,0,0,0],4,1,wf4(:,34))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,34),G0H8(11),m3h4x8(:,22),heltab2x32(:,:,99))
  call Hloop_Q_A(ntryL,G0H8(11),49,nMT,G1H8(3),n2h8(63))
  Gcoeff(:)%j = (c(18)*M(1,:)%j-c(15)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(103),h0tab(:,103),[33,4,8,18],[0,0,0,nMT],4,2,wf4(:,7),wf2(:,4))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,7),G0H8(11),m3h4x8(:,23),heltab2x32(:,:,100))
  Gcoeff(:)%j = (c(13)*M(1,:)%j+c(20)*M(3,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(104),h0tab(:,104),[33,8,4,18],[0,0,0,nMT],4,2,wf4(:,7),wf2(:,4))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,7),G0H8(12),m3h4x8(:,24),heltab2x32(:,:,101))
  Gcoeff(:)%j = (c(20)*M(2,:)%j+c(13)*M(4,:)%j) * den(164)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(105),h0tab(:,105),[36,8,1,18],[0,0,nMT,0],4,2,wf4(:,13),wf2(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,13),G0H8(13),m3h4x8(:,25),heltab2x32(:,:,102))
  call Hloop_Q_A(ntryL,G0H8(13),36,0,G1H8(27),n2h8(64))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)+c(18)*M(4,:)%j) * den(164)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(106),h0tab(:,106),[36,1,18,8],[0,nMT,0,0],4,2,wf4(:,13),wf2(:,4))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,13),G0H8(13),m3h4x8(:,26),heltab2x32(:,:,103))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)+c(18)*M(4,:)%j) * den(165)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(107),h0tab(:,107),[40,4,1,18],[0,0,nMT,0],4,2,wf4(:,15),wf2(:,4))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,15),G0H8(14),m3h4x8(:,27),heltab2x32(:,:,104))
  call Hloop_A_Q(ntryL,G0H8(14),40,0,G1H8(4),n2h8(65))
  Gcoeff(:)%j = (c(20)*M(3,:)%j+c(13)*M(4,:)%j) * den(165)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(108),h0tab(:,108),[40,1,18,4],[0,nMT,0,0],4,2,wf4(:,15),wf2(:,4))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,15),G0H8(14),m3h4x8(:,28),heltab2x32(:,:,105))
  Gcoeff(:)%j = (c(17)*M(1,:)%j-c(14)*M(2,:)%j+c(13)*M(4,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(109),h0tab(:,109),[32,4,8,19],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,75),heltab2x32(:,:,106))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(37),n2h16(48))
  Gcoeff(:)%j = (c(22)*M(2,:)%j+c(17)*(M(1,:)%j-M(4,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(110),h0tab(:,110),[32,4,8,19],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(38),m3h2x16(:,76),heltab2x32(:,:,107))
  Gcoeff(:)%j = (c(17)*M(1,:)%j-c(14)*M(3,:)%j+c(13)*M(4,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(111),h0tab(:,111),[32,8,4,19],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,77),heltab2x32(:,:,108))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(39),n2h16(49))
  Gcoeff(:)%j = (c(22)*M(3,:)%j+c(17)*(M(1,:)%j-M(4,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(112),h0tab(:,112),[32,8,4,19],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(40),m3h2x16(:,78),heltab2x32(:,:,109))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(113),h0tab(:,113),[32,4,19,8],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,79),heltab2x32(:,:,110))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(41),n2h16(50))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(114),h0tab(:,114),[32,4,19,8],[0,0,0,0],4,1,wf4(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(42),m3h2x16(:,80),heltab2x32(:,:,111))
  Gcoeff(:)%j = (c(18)*M(1,:)%j-c(15)*M(2,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(115),h0tab(:,115),[50,1,4,8],[nMT,0,0,0],4,1,wf4(:,43))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,43),G0H8(15),m3h4x8(:,29),heltab2x32(:,:,112))
  call Hloop_A_Q(ntryL,G0H8(15),50,nMT,G1H8(28),n2h8(66))
  Gcoeff(:)%j = (c(13)*M(1,:)%j+c(20)*M(2,:)%j) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(116),h0tab(:,116),[50,1,8,4],[nMT,0,0,0],4,1,wf4(:,43))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,43),G0H8(15),m3h4x8(:,30),heltab2x32(:,:,113))
  call Hloop_A_Q(ntryL,G0H8(15),50,nMT,G1H8(18),n2h8(67))
  Gcoeff(:)%j = (c(13)*M(1,:)%j+c(20)*M(3,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(117),h0tab(:,117),[49,2,4,8],[nMT,0,0,0],4,1,wf4(:,38))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,38),G0H8(15),m3h4x8(:,31),heltab2x32(:,:,114))
  call Hloop_Q_A(ntryL,G0H8(15),49,nMT,G1H8(8),n2h8(68))
  Gcoeff(:)%j = (c(18)*M(1,:)%j-c(15)*M(3,:)%j) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(118),h0tab(:,118),[49,2,8,4],[nMT,0,0,0],4,1,wf4(:,38))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,38),G0H8(15),m3h4x8(:,32),heltab2x32(:,:,115))
  call Hloop_Q_A(ntryL,G0H8(15),49,nMT,G1H8(29),n2h8(69))
  Gcoeff(:)%j = (c(18)*M(1,:)%j-c(15)*M(2,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(119),h0tab(:,119),[50,1,4,8],[nMT,0,0,0],4,1,wf4(:,46))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,46),G0H8(15),m3h4x8(:,33),heltab2x32(:,:,116))
  call Hloop_A_Q(ntryL,G0H8(15),50,nMT,G1H8(31),n2h8(70))
  Gcoeff(:)%j = (c(13)*M(1,:)%j+c(20)*M(2,:)%j) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(120),h0tab(:,120),[50,1,8,4],[nMT,0,0,0],4,1,wf4(:,46))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,46),G0H8(15),m3h4x8(:,34),heltab2x32(:,:,117))
  call Hloop_A_Q(ntryL,G0H8(15),50,nMT,G1H8(32),n2h8(71))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)+c(13)*M(4,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(121),h0tab(:,121),[44,2,1,16],[nMT,0,nMT,nMT],4,1,wf8(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,8),G0H4(4),m3h8x4(:,4),heltab2x32(:,:,118))
  call Hloop_Q_A(ntryL,G0H4(4),44,nMT,G1H4(27),n2h4(79))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)+c(13)*M(4,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(122),h0tab(:,122),[44,1,2,16],[nMT,0,nMT,nMT],4,1,wf8(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,8),G0H4(4),m3h8x4(:,5),heltab2x32(:,:,119))
  call Hloop_A_Q(ntryL,G0H4(4),44,nMT,G1H4(82),n2h4(80))
  Gcoeff(:)%j = (-(c(9)*M(2,:)%j)+c(7)*M(4,:)%j) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(123),h0tab(:,123),[44,1,16,2],[0,nMT,nMT,0],4,1,wf8(:,8))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,8),44,G1H4(85),m3h8x4(:,6),heltab2x32(:,:,120))
  Gcoeff(:)%j = (-(c(14)*M(3,:)%j)+c(13)*M(4,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(124),h0tab(:,124),[44,2,1,16],[nMT,0,nMT,nMT],4,1,wf8(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),wf8(:,9),G0H4(4),m3h8x4(:,7),heltab2x32(:,:,121))
  call Hloop_Q_A(ntryL,G0H4(4),44,nMT,G1H4(3),n2h4(81))
  Gcoeff(:)%j = (-(c(14)*M(3,:)%j)+c(13)*M(4,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(125),h0tab(:,125),[44,1,2,16],[nMT,0,nMT,nMT],4,1,wf8(:,9))
  call Hloop_AV_Q(ntryL,G0H32(1),wf8(:,9),G0H4(4),m3h8x4(:,8),heltab2x32(:,:,122))
  call Hloop_A_Q(ntryL,G0H4(4),44,nMT,G1H4(86),n2h4(82))
  Gcoeff(:)%j = (-(c(9)*M(3,:)%j)+c(7)*M(4,:)%j) * den(41)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(126),h0tab(:,126),[44,1,16,2],[0,nMT,nMT,0],4,1,wf8(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,9),44,G1H4(28),m3h8x4(:,9),heltab2x32(:,:,123))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(28),[G1H4(85),G1H4(81),G0H4(3),G0H4(2),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(3),[G1H4(27),G1H4(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(86),[G1H4(82),G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(8),[G1H8(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(29),[G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(31),[G1H8(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(32),[G1H8(18)])
  call Hloop_QS_A(ntryL,G1H8(19),ex5(:),G1H8(33),ngH,m3h1x8(:,33),heltab2x8(:,:,115))
  call Hloop_Q_A(ntryL,G1H8(33),49,nMT,G2H8(12),n2h8(72))
  call Hloop_QS_A(ntryL,G1H8(25),ex5(:),G1H8(12),ngH,m3h1x8(:,34),heltab2x8(:,:,116))
  call Hloop_Q_A(ntryL,G1H8(12),49,nMT,G2H8(13),n2h8(73))
  call Hloop_AS_Q(ntryL,G1H8(1),ex5(:),G1H8(23),ngH,m3h1x8(:,35),heltab2x8(:,:,117))
  call Hloop_A_Q(ntryL,G1H8(23),50,nMT,G2H8(15),n2h8(74))
  call Hloop_QV_A(ntryL,G1H8(30),wf4(:,2),G1H2(46),m3h4x2(:,14),heltab2x8(:,:,118))
  call Hloop_Q_A(ntryL,G1H2(46),45,nMT,G2H2(2),n2h2(106))
  call Hloop_VQ_A(ntryL,G1H4(28),ex1(:),G1H2(48),m3h2x2(:,127),heltab2x4(:,:,171))
  call Hloop_Q_A(ntryL,G1H2(48),45,nMT,G2H2(4),n2h2(107))
  call Hloop_AV_Q(ntryL,G1H16(1),wf4(:,2),G1H4(87),m3h4x4(:,3),heltab2x16(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(87),44,nMT,G2H4(22),n2h4(83))
  call Hloop_QV_A(ntryL,G1H16(2),wf4(:,2),G1H4(88),m3h4x4(:,4),heltab2x16(:,:,40))
  call Hloop_Q_A(ntryL,G1H4(88),44,nMT,G2H4(15),n2h4(84))
  call Hloop_AV_Q(ntryL,G1H16(3),wf4(:,2),G1H4(91),m3h4x4(:,5),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(91),44,nMB,G2H4(4),n2h4(85))
  call Hloop_QV_A(ntryL,G1H16(4),wf4(:,2),G1H4(92),m3h4x4(:,6),heltab2x16(:,:,42))
  call Hloop_Q_A(ntryL,G1H4(92),44,nMB,G2H4(7),n2h4(86))
  call Hloop_AV_Q(ntryL,G1H16(5),wf4(:,16),G1H4(93),m3h4x4(:,7),heltab2x16(:,:,43))
  call Hloop_A_Q(ntryL,G1H4(93),35,nMT,G2H4(10),n2h4(87))
  call Hloop_QV_A(ntryL,G1H16(6),wf4(:,16),G1H4(94),m3h4x4(:,8),heltab2x16(:,:,44))
  call Hloop_Q_A(ntryL,G1H4(94),35,nMT,G2H4(13),n2h4(88))
  call Hloop_AV_Q(ntryL,G1H16(7),wf4(:,16),G1H4(97),m3h4x4(:,9),heltab2x16(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(97),35,nMB,G2H4(16),n2h4(89))
  call Hloop_QV_A(ntryL,G1H16(8),wf4(:,16),G1H4(98),m3h4x4(:,10),heltab2x16(:,:,46))
  call Hloop_Q_A(ntryL,G1H4(98),35,nMB,G2H4(18),n2h4(90))
  call Hloop_QV_A(ntryL,G1H16(9),wf4(:,16),G1H4(99),m3h4x4(:,11),heltab2x16(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(99),35,nMT,G2H4(23),n2h4(91))
  call Hloop_AV_Q(ntryL,G1H16(10),wf4(:,16),G1H4(100),m3h4x4(:,12),heltab2x16(:,:,48))
  call Hloop_A_Q(ntryL,G1H4(100),35,nMT,G2H4(1),n2h4(92))
  call Hloop_QV_A(ntryL,G1H16(11),wf4(:,16),G1H4(103),m3h4x4(:,13),heltab2x16(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(103),35,nMB,G2H4(24),n2h4(93))
  call Hloop_AV_Q(ntryL,G1H16(12),wf4(:,16),G1H4(104),m3h4x4(:,14),heltab2x16(:,:,50))
  call Hloop_A_Q(ntryL,G1H4(104),35,nMB,G2H4(3),n2h4(94))
  call Hloop_QA_V(ntryL,G1H16(13),ex2(:),G1H8(22),m3h2x8(:,37),heltab2x16(:,:,51))
  call Hloop_VA_Q(ntryL,G1H16(14),ex2(:),G1H8(20),m3h2x8(:,38),heltab2x16(:,:,52))
  call Hloop_A_Q(ntryL,G1H8(20),34,nMT,G2H8(16),n2h8(75))
  call Hloop_QA_V(ntryL,G1H16(15),ex2(:),G1H8(2),m3h2x8(:,39),heltab2x16(:,:,53))
  call Hloop_VA_Q(ntryL,G1H16(16),ex2(:),G1H8(17),m3h2x8(:,40),heltab2x16(:,:,54))
  call Hloop_A_Q(ntryL,G1H8(17),34,nMT,G2H8(17),n2h8(76))
  call Hloop_QV_A(ntryL,G1H16(17),wf4(:,2),G1H4(105),m3h4x4(:,15),heltab2x16(:,:,55))
  call Hloop_Q_A(ntryL,G1H4(105),44,nMT,G2H4(25),n2h4(95))
  call Hloop_UV_W(ntryL,G1H16(18),32,wf4(:,2),12,G2H4(26),m3h4x4(:,16),heltab2x16(:,:,56))
  call Hloop_AQ_V(ntryL,G1H16(19),ex1(:),G1H8(24),m3h2x8(:,41),heltab2x16(:,:,57))
  call Hloop_VQ_A(ntryL,G1H16(20),ex1(:),G1H8(9),m3h2x8(:,42),heltab2x16(:,:,58))
  call Hloop_Q_A(ntryL,G1H8(9),33,nMT,G2H8(18),n2h8(77))
  call Hloop_AQ_V(ntryL,G1H16(21),ex1(:),G1H8(13),m3h2x8(:,43),heltab2x16(:,:,59))
  call Hloop_VQ_A(ntryL,G1H16(22),ex1(:),G1H8(14),m3h2x8(:,44),heltab2x16(:,:,60))
  call Hloop_Q_A(ntryL,G1H8(14),33,nMT,G2H8(19),n2h8(78))
  call Hloop_AV_Q(ntryL,G1H16(23),wf4(:,2),G1H4(106),m3h4x4(:,17),heltab2x16(:,:,61))
  call Hloop_A_Q(ntryL,G1H4(106),44,nMT,G2H4(27),n2h4(96))
  call Hloop_UV_W(ntryL,G1H16(24),32,wf4(:,2),12,G2H4(28),m3h4x4(:,18),heltab2x16(:,:,62))
  call Hloop_VA_Q(ntryL,G0H8(1),ex2(:),G0H4(4),m3h2x4(:,70),heltab2x8(:,:,119))
  call Hloop_A_Q(ntryL,G0H4(4),35,nMT,G1H4(109),n2h4(97))
  call Hloop_UV_W(ntryL,G0H8(2),33,wf4(:,2),12,G1H2(33),m3h4x2(:,15),heltab2x8(:,:,120))
  call Hloop_VA_Q(ntryL,G0H8(3),ex2(:),G0H4(3),m3h2x4(:,71),heltab2x8(:,:,121))
  call Hloop_A_Q(ntryL,G0H4(3),35,nMT,G1H4(110),n2h4(98))
  call Hloop_VQ_A(ntryL,G0H8(4),ex1(:),G0H4(2),m3h2x4(:,72),heltab2x8(:,:,122))
  call Hloop_Q_A(ntryL,G0H4(2),35,nMT,G1H4(111),n2h4(99))
  call Hloop_UV_W(ntryL,G0H8(5),34,wf4(:,2),12,G1H2(4),m3h4x2(:,16),heltab2x8(:,:,123))
  call Hloop_VQ_A(ntryL,G0H8(6),ex1(:),G0H4(1),m3h2x4(:,73),heltab2x8(:,:,124))
  call Hloop_Q_A(ntryL,G0H4(1),35,nMT,G1H4(112),n2h4(100))
  call Hloop_VA_Q(ntryL,G1H16(25),ex2(:),G1H8(26),m3h2x8(:,45),heltab2x16(:,:,63))
  call Hloop_A_Q(ntryL,G1H8(26),34,nMT,G2H8(20),n2h8(79))
  call Hloop_AQ_V(ntryL,G1H16(26),wf8(:,7),G1H2(40),m3h8x2(:,1),heltab2x16(:,:,64))
  call Hloop_QA_V(ntryL,G1H16(27),ex2(:),G1H8(3),m3h2x8(:,46),heltab2x16(:,:,65))
  call Hloop_VQ_A(ntryL,G1H16(28),ex1(:),G1H8(28),m3h2x8(:,47),heltab2x16(:,:,66))
  call Hloop_Q_A(ntryL,G1H8(28),33,nMT,G2H8(2),n2h8(80))
  call Hloop_QA_V(ntryL,G1H16(29),wf8(:,4),G1H2(59),m3h8x2(:,2),heltab2x16(:,:,67))
  call Hloop_AQ_V(ntryL,G1H16(30),ex1(:),G1H8(18),m3h2x8(:,48),heltab2x16(:,:,68))
  call Hloop_QA_V(ntryL,G1H4(3),ex2(:),G1H2(11),m3h2x2(:,128),heltab2x4(:,:,172))



end subroutine vamp_1

end module ol_vamp_1_pphttj_ttxddxhg_1_/**/REALKIND
