
! **********************************************************************
module ol_tables_storage_pphttj_ttxddxhg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  ! helicity tables for the 1-loop recursion
integer(intkind2), save :: h0tab(32,408)
integer(intkind2), save :: heltab2x1(2,1,177)
integer(intkind2), save :: heltab2x2(2,2,349)
integer(intkind2), save :: heltab2x4(2,4,444)
integer(intkind2), save :: heltab2x8(2,8,255)
integer(intkind2), save :: heltab2x16(2,16,138)
integer(intkind2), save :: heltab3x16(3,16,6)
integer(intkind2), save :: heltab2x32(2,32,381)
integer(intkind2), save :: heltab3x32(3,32,27)


  ! number of helicity states for openloops recursion steps
integer(intkind2), save :: m0h(408)
integer(intkind2), save :: m3h1x1(3,177)
integer(intkind2), save :: m3h2x1(3,310)
integer(intkind2), save :: m3h4x1(3,227)
integer(intkind2), save :: m3h8x1(3,40)
integer(intkind2), save :: m3h16x1(3,20)
integer(intkind2), save :: m3h1x2(3,39)
integer(intkind2), save :: m3h2x2(3,167)
integer(intkind2), save :: m3h4x2(3,49)
integer(intkind2), save :: m3h8x2(3,6)
integer(intkind2), save :: m3h16x2(3,20)
integer(intkind2), save :: m3h1x4(3,50)
integer(intkind2), save :: m3h2x4(3,123)
integer(intkind2), save :: m3h4x4(3,36)
integer(intkind2), save :: m3h8x4(3,145)
integer(intkind2), save :: m3h1x8(3,43)
integer(intkind2), save :: m3h2x8(3,76)
integer(intkind2), save :: m3h4x8(3,68)
integer(intkind2), save :: m3h2x16(3,148)
integer(intkind2), save :: m4h4x4x1(4,6)
integer(intkind2), save :: m4h4x2x4(4,9)
integer(intkind2), save :: m4h2x4x4(4,18)

integer(intkind2), save :: n2h1(558)
integer(intkind2), save :: n2h2(190)
integer(intkind2), save :: n2h4(262)
integer(intkind2), save :: n2h8(126)
integer(intkind2), save :: n2h16(96)


contains

!**********************************************************************
subroutine HOL_m3_init()
!**********************************************************************
! initialize m3 arrays for helicity summation
!**********************************************************************
  use KIND_TYPES, only: REALKIND, intkind2

m3h1x1(1,:)=1
m3h1x1(2,:)=1
m3h1x1(3,:)=1
m3h2x1(1,:)=2
m3h2x1(2,:)=1
m3h2x1(3,:)=2
m3h4x1(1,:)=4
m3h4x1(2,:)=1
m3h4x1(3,:)=4
m3h8x1(1,:)=8
m3h8x1(2,:)=1
m3h8x1(3,:)=8
m3h16x1(1,:)=16
m3h16x1(2,:)=1
m3h16x1(3,:)=16
m3h1x2(1,:)=1
m3h1x2(2,:)=2
m3h1x2(3,:)=2
m3h2x2(1,:)=2
m3h2x2(2,:)=2
m3h2x2(3,:)=4
m3h4x2(1,:)=4
m3h4x2(2,:)=2
m3h4x2(3,:)=8
m3h8x2(1,:)=8
m3h8x2(2,:)=2
m3h8x2(3,:)=16
m3h16x2(1,:)=16
m3h16x2(2,:)=2
m3h16x2(3,:)=32
m3h1x4(1,:)=1
m3h1x4(2,:)=4
m3h1x4(3,:)=4
m3h2x4(1,:)=2
m3h2x4(2,:)=4
m3h2x4(3,:)=8
m3h4x4(1,:)=4
m3h4x4(2,:)=4
m3h4x4(3,:)=16
m3h8x4(1,:)=8
m3h8x4(2,:)=4
m3h8x4(3,:)=32
m3h1x8(1,:)=1
m3h1x8(2,:)=8
m3h1x8(3,:)=8
m3h2x8(1,:)=2
m3h2x8(2,:)=8
m3h2x8(3,:)=16
m3h4x8(1,:)=4
m3h4x8(2,:)=8
m3h4x8(3,:)=32
m3h2x16(1,:)=2
m3h2x16(2,:)=16
m3h2x16(3,:)=32
m4h4x4x1(1,:)=4
m4h4x4x1(2,:)=4
m4h4x4x1(3,:)=1
m4h4x4x1(4,:)=16
m4h4x2x4(1,:)=4
m4h4x2x4(2,:)=2
m4h4x2x4(3,:)=4
m4h4x2x4(4,:)=32
m4h2x4x4(1,:)=2
m4h2x4x4(2,:)=4
m4h2x4x4(3,:)=4
m4h2x4x4(4,:)=32

n2h1(:)=1
n2h2(:)=2
n2h4(:)=4
n2h8(:)=8
n2h16(:)=16


end subroutine HOL_m3_init

!**********************************************************************

end module ol_tables_storage_pphttj_ttxddxhg_1_/**/REALKIND

! **********************************************************************
module ol_tensor_sum_storage_pphttj_ttxddxhg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol, hcl, met
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  type(met), save :: M2L1R1

  ! Declarations of loop wave function tensors

  type(hol), save :: G0H1(1)
  type(hol), save :: G1H1(143)
  type(hol), save :: G2H1(46)
  type(hol), save :: G0H2(10)
  type(hol), save :: G1H2(142)
  type(hol), save :: G2H2(111)
  type(hol), save :: G0H4(13)
  type(hol), save :: G1H4(141)
  type(hol), save :: G2H4(44)
  type(hol), save :: G0H8(15)
  type(hol), save :: G1H8(40)
  type(hol), save :: G2H8(20)
  type(hol), save :: G0H16(1)
  type(hol), save :: G1H16(62)
  type(hol), save :: G0H32(1)
  type(hcl), save, dimension(756) :: G0tensor
  type(hcl), save, dimension(774) :: G1tensor
  type(hcl), save, dimension(411) :: G2tensor
  type(hcl), save, dimension(58) :: G3tensor



  ! Declarations for on-the-fly tensor reduction
type (basis),      save :: RedBasis(190)
type (redset4),    save :: RedSet_4(193)
type (redset5),    save :: RedSet_5(66)
integer, save :: mass2set(0:1,5)
integer, save :: mass3set(0:2,9)
integer, save :: mass4set(0:3,15)
integer, save :: mass5set(0:4,12)



  ! Declarations for TI calls

  integer, save :: momenta_1(2)
  integer, save :: momenta_2(2)
  integer, save :: momenta_3(2)
  integer, save :: momenta_4(2)
  integer, save :: momenta_5(2)
  integer, save :: momenta_6(2)
  integer, save :: momenta_7(2)
  integer, save :: momenta_8(2)
  integer, save :: momenta_9(2)
  integer, save :: momenta_10(2)
  integer, save :: momenta_11(2)
  integer, save :: momenta_12(2)
  integer, save :: momenta_13(2)
  integer, save :: momenta_14(2)
  integer, save :: momenta_15(2)
  integer, save :: momenta_16(2)
  integer, save :: momenta_17(2)
  integer, save :: momenta_18(2)
  integer, save :: momenta_19(2)
  integer, save :: momenta_20(2)
  integer, save :: momenta_21(2)
  integer, save :: momenta_22(2)
  integer, save :: momenta_23(2)
  integer, save :: momenta_24(2)
  integer, save :: momenta_25(2)
  integer, save :: momenta_26(2)
  integer, save :: momenta_27(2)
  integer, save :: momenta_28(2)
  integer, save :: momenta_29(3)
  integer, save :: momenta_30(3)
  integer, save :: momenta_31(3)
  integer, save :: momenta_32(3)
  integer, save :: momenta_33(3)
  integer, save :: momenta_34(3)
  integer, save :: momenta_35(3)
  integer, save :: momenta_36(3)
  integer, save :: momenta_37(3)
  integer, save :: momenta_38(3)
  integer, save :: momenta_39(3)
  integer, save :: momenta_40(3)
  integer, save :: momenta_41(3)
  integer, save :: momenta_42(3)
  integer, save :: momenta_43(3)
  integer, save :: momenta_44(3)
  integer, save :: momenta_45(3)
  integer, save :: momenta_46(3)
  integer, save :: momenta_47(3)
  integer, save :: momenta_48(3)
  integer, save :: momenta_49(3)
  integer, save :: momenta_50(3)
  integer, save :: momenta_51(3)
  integer, save :: momenta_52(3)
  integer, save :: momenta_53(3)
  integer, save :: momenta_54(3)
  integer, save :: momenta_55(3)
  integer, save :: momenta_56(3)
  integer, save :: momenta_57(3)
  integer, save :: momenta_58(3)
  integer, save :: momenta_59(3)
  integer, save :: momenta_60(3)
  integer, save :: momenta_61(3)
  integer, save :: momenta_62(3)
  integer, save :: momenta_63(3)
  integer, save :: momenta_64(3)
  integer, save :: momenta_65(3)
  integer, save :: momenta_66(3)
  integer, save :: momenta_67(3)
  integer, save :: momenta_68(3)
  integer, save :: momenta_69(3)
  integer, save :: momenta_70(3)
  integer, save :: momenta_71(3)
  integer, save :: momenta_72(3)
  integer, save :: momenta_73(3)
  integer, save :: momenta_74(3)
  integer, save :: momenta_75(3)
  integer, save :: momenta_76(3)
  integer, save :: momenta_77(3)
  integer, save :: momenta_78(3)
  integer, save :: momenta_79(3)
  integer, save :: momenta_80(3)
  integer, save :: momenta_81(3)
  integer, save :: momenta_82(3)
  integer, save :: momenta_83(3)
  integer, save :: momenta_84(3)
  integer, save :: momenta_85(3)
  integer, save :: momenta_86(3)
  integer, save :: momenta_87(3)
  integer, save :: momenta_88(3)
  integer, save :: momenta_89(3)
  integer, save :: momenta_90(3)
  integer, save :: momenta_91(3)
  integer, save :: momenta_92(3)
  integer, save :: momenta_93(3)
  integer, save :: momenta_94(3)
  integer, save :: momenta_95(3)
  integer, save :: momenta_96(3)
  integer, save :: momenta_97(3)
  integer, save :: momenta_98(3)
  integer, save :: momenta_99(3)
  integer, save :: momenta_100(3)
  integer, save :: momenta_101(3)
  integer, save :: momenta_102(3)
  integer, save :: momenta_103(3)
  integer, save :: momenta_104(3)
  integer, save :: momenta_105(3)
  integer, save :: momenta_106(3)
  integer, save :: momenta_107(3)
  integer, save :: momenta_108(3)
  integer, save :: momenta_109(3)
  integer, save :: momenta_110(3)
  integer, save :: momenta_111(3)
  integer, save :: momenta_112(3)
  integer, save :: momenta_113(3)
  integer, save :: momenta_114(3)
  integer, save :: momenta_115(3)
  integer, save :: momenta_116(3)
  integer, save :: momenta_117(3)
  integer, save :: momenta_118(3)
  integer, save :: momenta_119(3)
  integer, save :: momenta_120(3)
  integer, save :: momenta_121(3)
  integer, save :: momenta_122(3)
  integer, save :: momenta_123(3)
  integer, save :: momenta_124(3)
  integer, save :: momenta_125(3)
  integer, save :: momenta_126(3)
  integer, save :: momenta_127(3)
  integer, save :: momenta_128(3)
  integer, save :: momenta_129(3)
  integer, save :: momenta_130(3)
  integer, save :: momenta_131(3)
  integer, save :: momenta_132(3)
  integer, save :: momenta_133(3)
  integer, save :: momenta_134(3)
  integer, save :: momenta_135(3)
  integer, save :: momenta_136(3)
  integer, save :: momenta_137(3)
  integer, save :: momenta_138(3)
  integer, save :: momenta_139(3)
  integer, save :: momenta_140(3)
  integer, save :: momenta_141(3)
  integer, save :: momenta_142(3)
  integer, save :: momenta_143(3)
  integer, save :: momenta_144(3)
  integer, save :: momenta_145(3)
  integer, save :: momenta_146(3)
  integer, save :: momenta_147(3)
  integer, save :: momenta_148(4)
  integer, save :: momenta_149(4)
  integer, save :: momenta_150(4)
  integer, save :: momenta_151(4)
  integer, save :: momenta_152(4)
  integer, save :: momenta_153(4)
  integer, save :: momenta_154(4)
  integer, save :: momenta_155(4)
  integer, save :: momenta_156(4)
  integer, save :: momenta_157(4)
  integer, save :: momenta_158(4)
  integer, save :: momenta_159(4)
  integer, save :: momenta_160(4)
  integer, save :: momenta_161(4)
  integer, save :: momenta_162(4)
  integer, save :: momenta_163(4)
  integer, save :: momenta_164(4)
  integer, save :: momenta_165(4)
  integer, save :: momenta_166(4)
  integer, save :: momenta_167(4)
  integer, save :: momenta_168(4)
  integer, save :: momenta_169(4)
  integer, save :: momenta_170(4)
  integer, save :: momenta_171(4)
  integer, save :: momenta_172(4)
  integer, save :: momenta_173(4)
  integer, save :: momenta_174(4)
  integer, save :: momenta_175(4)
  integer, save :: momenta_176(4)
  integer, save :: momenta_177(4)
  integer, save :: momenta_178(4)
  integer, save :: momenta_179(4)
  integer, save :: momenta_180(4)
  integer, save :: momenta_181(4)
  integer, save :: momenta_182(4)
  integer, save :: momenta_183(4)
  integer, save :: momenta_184(4)
  integer, save :: momenta_185(4)
  integer, save :: momenta_186(4)
  integer, save :: momenta_187(4)
  integer, save :: momenta_188(4)
  integer, save :: momenta_189(4)
  integer, save :: momenta_190(4)
  integer, save :: momenta_191(4)
  integer, save :: momenta_192(4)
  integer, save :: momenta_193(4)
  integer, save :: momenta_194(4)
  integer, save :: momenta_195(4)
  integer, save :: momenta_196(4)
  integer, save :: momenta_197(4)
  integer, save :: momenta_198(4)
  integer, save :: momenta_199(4)
  integer, save :: momenta_200(4)
  integer, save :: momenta_201(4)
  integer, save :: momenta_202(4)
  integer, save :: momenta_203(4)
  integer, save :: momenta_204(4)
  integer, save :: momenta_205(4)
  integer, save :: momenta_206(4)
  integer, save :: momenta_207(4)
  integer, save :: momenta_208(4)
  integer, save :: momenta_209(4)
  integer, save :: momenta_210(4)
  integer, save :: momenta_211(4)
  integer, save :: momenta_212(4)
  integer, save :: momenta_213(4)
  integer, save :: momenta_214(4)
  integer, save :: momenta_215(4)
  integer, save :: momenta_216(4)
  integer, save :: momenta_217(4)
  integer, save :: momenta_218(4)
  integer, save :: momenta_219(4)
  integer, save :: momenta_220(4)
  integer, save :: momenta_221(4)
  integer, save :: momenta_222(4)
  integer, save :: momenta_223(4)
  integer, save :: momenta_224(4)
  integer, save :: momenta_225(4)
  integer, save :: momenta_226(4)
  integer, save :: momenta_227(4)
  integer, save :: momenta_228(4)
  integer, save :: momenta_229(4)
  integer, save :: momenta_230(4)
  integer, save :: momenta_231(4)
  integer, save :: momenta_232(4)
  integer, save :: momenta_233(4)
  integer, save :: momenta_234(4)
  integer, save :: momenta_235(4)
  integer, save :: momenta_236(4)
  integer, save :: momenta_237(4)
  integer, save :: momenta_238(4)
  integer, save :: momenta_239(4)
  integer, save :: momenta_240(4)
  integer, save :: momenta_241(4)
  integer, save :: momenta_242(4)
  integer, save :: momenta_243(4)
  integer, save :: momenta_244(4)
  integer, save :: momenta_245(4)
  integer, save :: momenta_246(4)
  integer, save :: momenta_247(4)
  integer, save :: momenta_248(4)
  integer, save :: momenta_249(4)
  integer, save :: momenta_250(4)
  integer, save :: momenta_251(4)
  integer, save :: momenta_252(4)
  integer, save :: momenta_253(4)
  integer, save :: momenta_254(4)
  integer, save :: momenta_255(4)
  integer, save :: momenta_256(4)
  integer, save :: momenta_257(4)
  integer, save :: momenta_258(4)
  integer, save :: momenta_259(4)
  integer, save :: momenta_260(4)
  integer, save :: momenta_261(4)
  integer, save :: momenta_262(4)
  integer, save :: momenta_263(4)
  integer, save :: momenta_264(4)
  integer, save :: momenta_265(4)
  integer, save :: momenta_266(4)
  integer, save :: momenta_267(4)
  integer, save :: momenta_268(4)
  integer, save :: momenta_269(4)
  integer, save :: momenta_270(4)
  integer, save :: momenta_271(4)
  integer, save :: momenta_272(4)
  integer, save :: momenta_273(4)
  integer, save :: momenta_274(4)
  integer, save :: momenta_275(4)
  integer, save :: momenta_276(4)
  integer, save :: momenta_277(4)
  integer, save :: momenta_278(4)
  integer, save :: momenta_279(4)
  integer, save :: momenta_280(4)
  integer, save :: momenta_281(4)
  integer, save :: momenta_282(4)
  integer, save :: momenta_283(4)
  integer, save :: momenta_284(4)
  integer, save :: momenta_285(4)
  integer, save :: momenta_286(4)
  integer, save :: momenta_287(4)
  integer, save :: momenta_288(4)
  integer, save :: momenta_289(5)
  integer, save :: momenta_290(5)
  integer, save :: momenta_291(5)
  integer, save :: momenta_292(5)
  integer, save :: momenta_293(5)
  integer, save :: momenta_294(5)
  integer, save :: momenta_295(5)
  integer, save :: momenta_296(5)
  integer, save :: momenta_297(5)
  integer, save :: momenta_298(5)
  integer, save :: momenta_299(5)
  integer, save :: momenta_300(5)
  integer, save :: momenta_301(5)
  integer, save :: momenta_302(5)
  integer, save :: momenta_303(5)
  integer, save :: momenta_304(5)
  integer, save :: momenta_305(5)
  integer, save :: momenta_306(5)
  integer, save :: momenta_307(5)
  integer, save :: momenta_308(5)
  integer, save :: momenta_309(5)
  integer, save :: momenta_310(5)
  integer, save :: momenta_311(5)
  integer, save :: momenta_312(5)
  integer, save :: momenta_313(5)
  integer, save :: momenta_314(5)
  integer, save :: momenta_315(5)
  integer, save :: momenta_316(5)
  integer, save :: momenta_317(5)
  integer, save :: momenta_318(5)
  integer, save :: momenta_319(5)
  integer, save :: momenta_320(5)
  integer, save :: momenta_321(5)
  integer, save :: momenta_322(5)
  integer, save :: momenta_323(5)
  integer, save :: momenta_324(5)
  integer, save :: momenta_325(5)
  integer, save :: momenta_326(5)
  integer, save :: momenta_327(5)
  integer, save :: momenta_328(5)
  integer, save :: momenta_329(5)
  integer, save :: momenta_330(5)
  integer, save :: momenta_331(5)
  integer, save :: momenta_332(5)
  integer, save :: momenta_333(5)
  integer, save :: momenta_334(5)
  integer, save :: momenta_335(5)
  integer, save :: momenta_336(5)
  integer, save :: momenta_337(5)
  integer, save :: momenta_338(5)
  integer, save :: momenta_339(5)
  integer, save :: momenta_340(5)
  integer, save :: momenta_341(5)
  integer, save :: momenta_342(5)
  integer, save :: momenta_343(5)
  integer, save :: momenta_344(5)
  integer, save :: momenta_345(5)
  integer, save :: momenta_346(5)
  integer, save :: momenta_347(5)
  integer, save :: momenta_348(5)
  integer, save :: momenta_349(5)
  integer, save :: momenta_350(5)
  integer, save :: momenta_351(5)
  integer, save :: momenta_352(5)
  integer, save :: momenta_353(6)
  integer, save :: momenta_354(6)
  integer, save :: momenta_355(6)
  integer, save :: momenta_356(6)
  integer, save :: momenta_357(6)
  integer, save :: momenta_358(6)
  integer, save :: momenta_359(6)
  integer, save :: momenta_360(6)
  integer, save :: momenta_361(6)
  integer, save :: momenta_362(6)

  integer, save :: masses2_1(2)
  integer, save :: masses2_2(2)
  integer, save :: masses2_3(2)
  integer, save :: masses2_4(2)
  integer, save :: masses2_5(2)
  integer, save :: masses2_6(2)
  integer, save :: masses2_7(3)
  integer, save :: masses2_8(3)
  integer, save :: masses2_9(3)
  integer, save :: masses2_10(3)
  integer, save :: masses2_11(3)
  integer, save :: masses2_12(3)
  integer, save :: masses2_13(3)
  integer, save :: masses2_14(3)
  integer, save :: masses2_15(3)
  integer, save :: masses2_16(4)
  integer, save :: masses2_17(4)
  integer, save :: masses2_18(4)
  integer, save :: masses2_19(4)
  integer, save :: masses2_20(4)
  integer, save :: masses2_21(4)
  integer, save :: masses2_22(4)
  integer, save :: masses2_23(4)
  integer, save :: masses2_24(4)
  integer, save :: masses2_25(4)
  integer, save :: masses2_26(4)
  integer, save :: masses2_27(4)
  integer, save :: masses2_28(4)
  integer, save :: masses2_29(4)
  integer, save :: masses2_30(4)
  integer, save :: masses2_31(5)
  integer, save :: masses2_32(5)
  integer, save :: masses2_33(5)
  integer, save :: masses2_34(5)
  integer, save :: masses2_35(5)
  integer, save :: masses2_36(5)
  integer, save :: masses2_37(5)
  integer, save :: masses2_38(5)
  integer, save :: masses2_39(5)
  integer, save :: masses2_40(5)
  integer, save :: masses2_41(5)
  integer, save :: masses2_42(5)
  integer, save :: masses2_43(6)
  integer, save :: masses2_44(6)
  integer, save :: masses2_45(6)

type(scalarbox), save :: ScalarBoxes(194)

integer, save :: sbarray_1(15)
integer, save :: sbarray_2(15)
integer, save :: sbarray_3(15)
integer, save :: sbarray_4(15)
integer, save :: sbarray_5(15)
integer, save :: sbarray_6(15)
integer, save :: sbarray_7(15)
integer, save :: sbarray_8(15)
integer, save :: sbarray_9(15)
integer, save :: sbarray_10(15)
integer, save :: sbarray_11(5)
integer, save :: sbarray_12(5)
integer, save :: sbarray_13(5)
integer, save :: sbarray_14(5)
integer, save :: sbarray_15(5)
integer, save :: sbarray_16(5)
integer, save :: sbarray_17(5)
integer, save :: sbarray_18(5)
integer, save :: sbarray_19(5)
integer, save :: sbarray_20(5)
integer, save :: sbarray_21(5)
integer, save :: sbarray_22(5)
integer, save :: sbarray_23(5)
integer, save :: sbarray_24(5)
integer, save :: sbarray_25(5)
integer, save :: sbarray_26(5)
integer, save :: sbarray_27(5)
integer, save :: sbarray_28(5)
integer, save :: sbarray_29(5)
integer, save :: sbarray_30(5)
integer, save :: sbarray_31(5)
integer, save :: sbarray_32(5)
integer, save :: sbarray_33(5)
integer, save :: sbarray_34(5)
integer, save :: sbarray_35(5)
integer, save :: sbarray_36(5)
integer, save :: sbarray_37(5)
integer, save :: sbarray_38(5)
integer, save :: sbarray_39(5)
integer, save :: sbarray_40(5)
integer, save :: sbarray_41(5)
integer, save :: sbarray_42(5)
integer, save :: sbarray_43(5)
integer, save :: sbarray_44(5)
integer, save :: sbarray_45(5)
integer, save :: sbarray_46(5)
integer, save :: sbarray_47(5)
integer, save :: sbarray_48(5)
integer, save :: sbarray_49(5)
integer, save :: sbarray_50(5)
integer, save :: sbarray_51(5)
integer, save :: sbarray_52(5)
integer, save :: sbarray_53(5)
integer, save :: sbarray_54(5)
integer, save :: sbarray_55(5)
integer, save :: sbarray_56(5)
integer, save :: sbarray_57(5)
integer, save :: sbarray_58(5)
integer, save :: sbarray_59(5)
integer, save :: sbarray_60(5)
integer, save :: sbarray_61(5)
integer, save :: sbarray_62(5)
integer, save :: sbarray_63(5)
integer, save :: sbarray_64(5)
integer, save :: sbarray_65(5)
integer, save :: sbarray_66(5)
integer, save :: sbarray_67(5)
integer, save :: sbarray_68(5)
integer, save :: sbarray_69(5)
integer, save :: sbarray_70(5)
integer, save :: sbarray_71(5)
integer, save :: sbarray_72(5)
integer, save :: sbarray_73(5)
integer, save :: sbarray_74(5)

  type(hcl), save, dimension(357) :: T0sum
  type(hcl), save, dimension(92) :: T1sum


  contains

!**********************************************************************
subroutine HOL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,1,G0H1,1)
  call hol_allocation(4,5,4,1,G1H1,143)
  call hol_allocation(4,15,4,1,G2H1,46)
  call hol_allocation(4,1,4,2,G0H2,10)
  call hol_allocation(4,5,4,2,G1H2,142)
  call hol_allocation(4,15,4,2,G2H2,111)
  call hol_allocation(4,1,4,4,G0H4,13)
  call hol_allocation(4,5,4,4,G1H4,141)
  call hol_allocation(4,15,4,4,G2H4,44)
  call hol_allocation(4,1,4,8,G0H8,15)
  call hol_allocation(4,5,4,8,G1H8,40)
  call hol_allocation(4,15,4,8,G2H8,20)
  call hol_allocation(4,1,4,16,G0H16,1)
  call hol_allocation(4,5,4,16,G1H16,62)
  call hol_allocation(4,1,4,32,G0H32,1)


end subroutine HOL_memory_allocation


!**********************************************************************
subroutine HOL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_deallocation
  implicit none
  integer,   intent(in)    :: dmode

    call hol_deallocation(G0H1,1,dmode)
  call hol_deallocation(G1H1,143,dmode)
  call hol_deallocation(G2H1,46,dmode)
  call hol_deallocation(G0H2,10,dmode)
  call hol_deallocation(G1H2,142,dmode)
  call hol_deallocation(G2H2,111,dmode)
  call hol_deallocation(G0H4,13,dmode)
  call hol_deallocation(G1H4,141,dmode)
  call hol_deallocation(G2H4,44,dmode)
  call hol_deallocation(G0H8,15,dmode)
  call hol_deallocation(G1H8,40,dmode)
  call hol_deallocation(G2H8,20,dmode)
  call hol_deallocation(G0H16,1,dmode)
  call hol_deallocation(G1H16,62,dmode)
  call hol_deallocation(G0H32,1,dmode)


end subroutine HOL_memory_deallocation_/**/REALKIND

!**********************************************************************
subroutine HCL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

  call hcl_allocation(1,G0tensor, 756)
call hcl_allocation(5,G1tensor, 774)
call hcl_allocation(15,G2tensor, 411)
call hcl_allocation(35,G3tensor, 58)


end subroutine HCL_memory_allocation


!**********************************************************************
subroutine HCL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! deallocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_deallocation
  implicit none
  integer,   intent(in)    :: dmode

  call hcl_deallocation(G0tensor, 756,dmode)
call hcl_deallocation(G1tensor, 774,dmode)
call hcl_deallocation(G2tensor, 411,dmode)
call hcl_deallocation(G3tensor, 58,dmode)

    call hcl_deallocation(T0sum,357,dmode)
  call hcl_deallocation(T1sum,92,dmode)


end subroutine HCL_memory_deallocation_/**/REALKIND


!**********************************************************************
subroutine Tsum_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

    call hcl_allocation(1,T0sum,357)
  call hcl_allocation(5,T1sum,92)


end subroutine Tsum_memory_allocation


#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_pphttj_ttxddxhg_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 6
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_pphttj_ttxddxhg_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 1
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  use ol_parameters_init_/**/REALKIND, only: init_hcl
  implicit none
  integer :: i

  do i = 1,357
    call init_hcl(T0sum(i))
  end do
  do i = 1,92
    call init_hcl(T1sum(i))
  end do

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T1sum(1)%cmp, 4)
  call scale_one_tsum(T1sum(2)%cmp, 4)
  call scale_one_tsum(T1sum(3)%cmp, 4)
  call scale_one_tsum(T1sum(4)%cmp, 4)
  call scale_one_tsum(T1sum(5)%cmp, 4)
  call scale_one_tsum(T1sum(6)%cmp, 4)
  call scale_one_tsum(T1sum(7)%cmp, 4)
  call scale_one_tsum(T1sum(8)%cmp, 4)
  call scale_one_tsum(T1sum(9)%cmp, 4)
  call scale_one_tsum(T1sum(10)%cmp, 4)
  call scale_one_tsum(T1sum(11)%cmp, 2)
  call scale_one_tsum(T1sum(12)%cmp, 2)
  call scale_one_tsum(T1sum(13)%cmp, 2)
  call scale_one_tsum(T1sum(14)%cmp, 2)
  call scale_one_tsum(T1sum(15)%cmp, 2)
  call scale_one_tsum(T1sum(16)%cmp, 2)
  call scale_one_tsum(T1sum(17)%cmp, 2)
  call scale_one_tsum(T1sum(18)%cmp, 2)
  call scale_one_tsum(T1sum(19)%cmp, 2)
  call scale_one_tsum(T1sum(20)%cmp, 2)
  call scale_one_tsum(T1sum(21)%cmp, 2)
  call scale_one_tsum(T1sum(22)%cmp, 2)
  call scale_one_tsum(T1sum(23)%cmp, 2)
  call scale_one_tsum(T1sum(24)%cmp, 2)
  call scale_one_tsum(T1sum(25)%cmp, 2)
  call scale_one_tsum(T1sum(26)%cmp, 2)
  call scale_one_tsum(T1sum(27)%cmp, 2)
  call scale_one_tsum(T1sum(28)%cmp, 2)
  call scale_one_tsum(T1sum(29)%cmp, 2)
  call scale_one_tsum(T1sum(30)%cmp, 2)
  call scale_one_tsum(T1sum(31)%cmp, 2)
  call scale_one_tsum(T1sum(32)%cmp, 2)
  call scale_one_tsum(T1sum(33)%cmp, 2)
  call scale_one_tsum(T1sum(34)%cmp, 2)
  call scale_one_tsum(T1sum(35)%cmp, 2)
  call scale_one_tsum(T1sum(36)%cmp, 2)
  call scale_one_tsum(T1sum(37)%cmp, 2)
  call scale_one_tsum(T1sum(38)%cmp, 2)
  call scale_one_tsum(T1sum(39)%cmp, 2)
  call scale_one_tsum(T1sum(40)%cmp, 2)
  call scale_one_tsum(T1sum(41)%cmp, 2)
  call scale_one_tsum(T1sum(42)%cmp, 2)
  call scale_one_tsum(T1sum(43)%cmp, 2)
  call scale_one_tsum(T1sum(44)%cmp, 2)
  call scale_one_tsum(T1sum(45)%cmp, 2)
  call scale_one_tsum(T1sum(46)%cmp, 2)
  call scale_one_tsum(T1sum(47)%cmp, 2)
  call scale_one_tsum(T1sum(48)%cmp, 2)
  call scale_one_tsum(T1sum(49)%cmp, 2)
  call scale_one_tsum(T1sum(50)%cmp, 2)
  call scale_one_tsum(T1sum(51)%cmp, 2)
  call scale_one_tsum(T1sum(52)%cmp, 2)
  call scale_one_tsum(T1sum(53)%cmp, 2)
  call scale_one_tsum(T1sum(54)%cmp, 2)
  call scale_one_tsum(T1sum(55)%cmp, 2)
  call scale_one_tsum(T1sum(56)%cmp, 2)
  call scale_one_tsum(T1sum(57)%cmp, 2)
  call scale_one_tsum(T1sum(58)%cmp, 2)
  call scale_one_tsum(T1sum(59)%cmp, 2)
  call scale_one_tsum(T1sum(60)%cmp, 2)
  call scale_one_tsum(T1sum(61)%cmp, 2)
  call scale_one_tsum(T1sum(62)%cmp, 2)
  call scale_one_tsum(T1sum(63)%cmp, 2)
  call scale_one_tsum(T1sum(64)%cmp, 2)
  call scale_one_tsum(T1sum(65)%cmp, 2)
  call scale_one_tsum(T1sum(66)%cmp, 2)
  call scale_one_tsum(T1sum(67)%cmp, 2)
  call scale_one_tsum(T1sum(68)%cmp, 2)
  call scale_one_tsum(T1sum(69)%cmp, 2)
  call scale_one_tsum(T1sum(70)%cmp, 2)
  call scale_one_tsum(T1sum(71)%cmp, 2)
  call scale_one_tsum(T1sum(72)%cmp, 2)
  call scale_one_tsum(T1sum(73)%cmp, 2)
  call scale_one_tsum(T1sum(74)%cmp, 2)
  call scale_one_tsum(T0sum(1)%cmp, 0)
  call scale_one_tsum(T0sum(2)%cmp, 0)
  call scale_one_tsum(T0sum(3)%cmp, 0)
  call scale_one_tsum(T0sum(4)%cmp, 0)
  call scale_one_tsum(T0sum(5)%cmp, 0)
  call scale_one_tsum(T0sum(6)%cmp, 0)
  call scale_one_tsum(T0sum(7)%cmp, 0)
  call scale_one_tsum(T0sum(8)%cmp, 0)
  call scale_one_tsum(T0sum(9)%cmp, 0)
  call scale_one_tsum(T0sum(10)%cmp, 0)
  call scale_one_tsum(T0sum(11)%cmp, 0)
  call scale_one_tsum(T0sum(12)%cmp, 0)
  call scale_one_tsum(T0sum(13)%cmp, 0)
  call scale_one_tsum(T0sum(14)%cmp, 0)
  call scale_one_tsum(T0sum(15)%cmp, 0)
  call scale_one_tsum(T0sum(16)%cmp, 0)
  call scale_one_tsum(T0sum(17)%cmp, 0)
  call scale_one_tsum(T0sum(18)%cmp, 0)
  call scale_one_tsum(T0sum(19)%cmp, 0)
  call scale_one_tsum(T0sum(20)%cmp, 0)
  call scale_one_tsum(T0sum(21)%cmp, 0)
  call scale_one_tsum(T0sum(22)%cmp, 0)
  call scale_one_tsum(T0sum(23)%cmp, 0)
  call scale_one_tsum(T0sum(24)%cmp, 0)
  call scale_one_tsum(T0sum(25)%cmp, 0)
  call scale_one_tsum(T0sum(26)%cmp, 0)
  call scale_one_tsum(T0sum(27)%cmp, 0)
  call scale_one_tsum(T0sum(28)%cmp, 0)
  call scale_one_tsum(T0sum(29)%cmp, 0)
  call scale_one_tsum(T0sum(30)%cmp, 0)
  call scale_one_tsum(T0sum(31)%cmp, 0)
  call scale_one_tsum(T0sum(32)%cmp, 0)
  call scale_one_tsum(T0sum(33)%cmp, 0)
  call scale_one_tsum(T0sum(34)%cmp, 0)
  call scale_one_tsum(T0sum(35)%cmp, 0)
  call scale_one_tsum(T0sum(36)%cmp, 0)
  call scale_one_tsum(T0sum(37)%cmp, 0)
  call scale_one_tsum(T0sum(38)%cmp, 0)
  call scale_one_tsum(T0sum(39)%cmp, 0)
  call scale_one_tsum(T0sum(40)%cmp, 0)
  call scale_one_tsum(T0sum(41)%cmp, 0)
  call scale_one_tsum(T0sum(42)%cmp, 0)
  call scale_one_tsum(T0sum(43)%cmp, 0)
  call scale_one_tsum(T0sum(44)%cmp, 0)
  call scale_one_tsum(T0sum(45)%cmp, 0)
  call scale_one_tsum(T0sum(46)%cmp, 0)
  call scale_one_tsum(T0sum(47)%cmp, 0)
  call scale_one_tsum(T0sum(48)%cmp, 0)
  call scale_one_tsum(T0sum(49)%cmp, 0)
  call scale_one_tsum(T0sum(50)%cmp, 0)
  call scale_one_tsum(T0sum(51)%cmp, 0)
  call scale_one_tsum(T0sum(52)%cmp, 0)
  call scale_one_tsum(T0sum(53)%cmp, 0)
  call scale_one_tsum(T0sum(54)%cmp, 0)
  call scale_one_tsum(T0sum(55)%cmp, 0)
  call scale_one_tsum(T0sum(56)%cmp, 0)
  call scale_one_tsum(T0sum(57)%cmp, 0)
  call scale_one_tsum(T0sum(58)%cmp, 0)
  call scale_one_tsum(T0sum(59)%cmp, 0)
  call scale_one_tsum(T0sum(60)%cmp, 0)
  call scale_one_tsum(T0sum(61)%cmp, 0)
  call scale_one_tsum(T0sum(62)%cmp, 0)
  call scale_one_tsum(T0sum(63)%cmp, 0)
  call scale_one_tsum(T0sum(64)%cmp, 0)
  call scale_one_tsum(T0sum(65)%cmp, 0)
  call scale_one_tsum(T0sum(66)%cmp, 0)
  call scale_one_tsum(T0sum(67)%cmp, 0)
  call scale_one_tsum(T0sum(68)%cmp, 0)
  call scale_one_tsum(T0sum(69)%cmp, 0)
  call scale_one_tsum(T0sum(70)%cmp, 0)
  call scale_one_tsum(T0sum(71)%cmp, 0)
  call scale_one_tsum(T0sum(72)%cmp, 0)
  call scale_one_tsum(T0sum(73)%cmp, 0)
  call scale_one_tsum(T0sum(74)%cmp, 0)
  call scale_one_tsum(T0sum(75)%cmp, 0)
  call scale_one_tsum(T0sum(76)%cmp, 0)
  call scale_one_tsum(T0sum(77)%cmp, 0)
  call scale_one_tsum(T0sum(78)%cmp, 0)
  call scale_one_tsum(T0sum(79)%cmp, 0)
  call scale_one_tsum(T0sum(80)%cmp, 0)
  call scale_one_tsum(T0sum(81)%cmp, 0)
  call scale_one_tsum(T0sum(82)%cmp, 0)
  call scale_one_tsum(T0sum(83)%cmp, 0)
  call scale_one_tsum(T0sum(84)%cmp, 0)
  call scale_one_tsum(T0sum(85)%cmp, 0)
  call scale_one_tsum(T0sum(86)%cmp, 0)
  call scale_one_tsum(T0sum(87)%cmp, 0)
  call scale_one_tsum(T0sum(88)%cmp, 0)
  call scale_one_tsum(T0sum(89)%cmp, 0)
  call scale_one_tsum(T0sum(90)%cmp, 0)
  call scale_one_tsum(T0sum(91)%cmp, 0)
  call scale_one_tsum(T0sum(92)%cmp, 0)
  call scale_one_tsum(T0sum(93)%cmp, 0)
  call scale_one_tsum(T0sum(94)%cmp, 0)
  call scale_one_tsum(T0sum(95)%cmp, 0)
  call scale_one_tsum(T0sum(96)%cmp, 0)
  call scale_one_tsum(T0sum(97)%cmp, 0)
  call scale_one_tsum(T0sum(98)%cmp, 0)
  call scale_one_tsum(T0sum(99)%cmp, 0)
  call scale_one_tsum(T0sum(100)%cmp, 0)
  call scale_one_tsum(T0sum(101)%cmp, 0)
  call scale_one_tsum(T0sum(102)%cmp, 0)
  call scale_one_tsum(T0sum(103)%cmp, 0)
  call scale_one_tsum(T0sum(104)%cmp, 0)
  call scale_one_tsum(T0sum(105)%cmp, 0)
  call scale_one_tsum(T0sum(106)%cmp, 0)
  call scale_one_tsum(T0sum(107)%cmp, 0)
  call scale_one_tsum(T0sum(108)%cmp, 0)
  call scale_one_tsum(T0sum(109)%cmp, 0)
  call scale_one_tsum(T0sum(110)%cmp, 0)
  call scale_one_tsum(T0sum(111)%cmp, 0)
  call scale_one_tsum(T0sum(112)%cmp, 0)
  call scale_one_tsum(T0sum(113)%cmp, 0)
  call scale_one_tsum(T0sum(114)%cmp, 0)
  call scale_one_tsum(T0sum(115)%cmp, 0)
  call scale_one_tsum(T0sum(116)%cmp, 0)
  call scale_one_tsum(T0sum(117)%cmp, 0)
  call scale_one_tsum(T0sum(118)%cmp, 0)
  call scale_one_tsum(T0sum(119)%cmp, 0)
  call scale_one_tsum(T0sum(120)%cmp, 0)
  call scale_one_tsum(T0sum(121)%cmp, 0)
  call scale_one_tsum(T0sum(122)%cmp, 0)
  call scale_one_tsum(T0sum(123)%cmp, 0)
  call scale_one_tsum(T0sum(124)%cmp, 0)
  call scale_one_tsum(T0sum(125)%cmp, 0)
  call scale_one_tsum(T0sum(126)%cmp, 0)
  call scale_one_tsum(T0sum(127)%cmp, 0)
  call scale_one_tsum(T0sum(128)%cmp, 0)
  call scale_one_tsum(T0sum(129)%cmp, 0)
  call scale_one_tsum(T0sum(130)%cmp, 0)
  call scale_one_tsum(T0sum(131)%cmp, 0)
  call scale_one_tsum(T0sum(132)%cmp, 0)
  call scale_one_tsum(T0sum(133)%cmp, 0)
  call scale_one_tsum(T0sum(134)%cmp, 0)
  call scale_one_tsum(T0sum(135)%cmp, 0)
  call scale_one_tsum(T0sum(136)%cmp, 0)
  call scale_one_tsum(T0sum(137)%cmp, 0)
  call scale_one_tsum(T0sum(138)%cmp, 0)
  call scale_one_tsum(T0sum(139)%cmp, 0)
  call scale_one_tsum(T0sum(140)%cmp, 0)
  call scale_one_tsum(T0sum(141)%cmp, 0)
  call scale_one_tsum(T0sum(142)%cmp, 0)
  call scale_one_tsum(T0sum(143)%cmp, 0)
  call scale_one_tsum(T0sum(144)%cmp, 0)
  call scale_one_tsum(T0sum(145)%cmp, 0)
  call scale_one_tsum(T0sum(146)%cmp, 0)
  call scale_one_tsum(T0sum(147)%cmp, 0)
  call scale_one_tsum(T0sum(148)%cmp, 0)
  call scale_one_tsum(T0sum(149)%cmp, 0)
  call scale_one_tsum(T0sum(150)%cmp, 0)
  call scale_one_tsum(T0sum(151)%cmp, 0)
  call scale_one_tsum(T0sum(152)%cmp, 0)
  call scale_one_tsum(T0sum(153)%cmp, 0)
  call scale_one_tsum(T0sum(154)%cmp, 0)
  call scale_one_tsum(T0sum(155)%cmp, 0)
  call scale_one_tsum(T0sum(156)%cmp, 0)
  call scale_one_tsum(T0sum(157)%cmp, -2)
  call scale_one_tsum(T0sum(158)%cmp, -2)
  call scale_one_tsum(T0sum(159)%cmp, -2)
  call scale_one_tsum(T0sum(160)%cmp, -2)
  call scale_one_tsum(T0sum(161)%cmp, -2)
  call scale_one_tsum(T0sum(162)%cmp, -2)
  call scale_one_tsum(T0sum(163)%cmp, -2)
  call scale_one_tsum(T0sum(164)%cmp, -2)
  call scale_one_tsum(T0sum(165)%cmp, -2)
  call scale_one_tsum(T0sum(166)%cmp, -2)
  call scale_one_tsum(T0sum(167)%cmp, -2)
  call scale_one_tsum(T0sum(168)%cmp, -2)
  call scale_one_tsum(T0sum(169)%cmp, -2)
  call scale_one_tsum(T0sum(170)%cmp, -2)
  call scale_one_tsum(T0sum(171)%cmp, -2)
  call scale_one_tsum(T0sum(172)%cmp, -2)
  call scale_one_tsum(T0sum(173)%cmp, -2)
  call scale_one_tsum(T0sum(174)%cmp, -2)
  call scale_one_tsum(T0sum(175)%cmp, -2)
  call scale_one_tsum(T0sum(176)%cmp, -2)
  call scale_one_tsum(T0sum(177)%cmp, -2)
  call scale_one_tsum(T0sum(178)%cmp, -2)
  call scale_one_tsum(T0sum(179)%cmp, -2)
  call scale_one_tsum(T0sum(180)%cmp, -2)
  call scale_one_tsum(T0sum(181)%cmp, -2)
  call scale_one_tsum(T0sum(182)%cmp, -2)
  call scale_one_tsum(T0sum(183)%cmp, -2)
  call scale_one_tsum(T0sum(184)%cmp, -2)
  call scale_one_tsum(T0sum(185)%cmp, -2)
  call scale_one_tsum(T0sum(186)%cmp, -2)
  call scale_one_tsum(T0sum(187)%cmp, -2)
  call scale_one_tsum(T0sum(188)%cmp, -2)
  call scale_one_tsum(T0sum(189)%cmp, -2)
  call scale_one_tsum(T0sum(190)%cmp, -2)
  call scale_one_tsum(T0sum(191)%cmp, -2)
  call scale_one_tsum(T0sum(192)%cmp, -2)
  call scale_one_tsum(T0sum(193)%cmp, -2)
  call scale_one_tsum(T0sum(194)%cmp, -2)
  call scale_one_tsum(T0sum(195)%cmp, -2)
  call scale_one_tsum(T0sum(196)%cmp, -2)
  call scale_one_tsum(T0sum(197)%cmp, -2)
  call scale_one_tsum(T0sum(198)%cmp, -2)
  call scale_one_tsum(T0sum(199)%cmp, -2)
  call scale_one_tsum(T0sum(200)%cmp, -2)
  call scale_one_tsum(T0sum(201)%cmp, -2)
  call scale_one_tsum(T0sum(202)%cmp, -2)
  call scale_one_tsum(T0sum(203)%cmp, -2)
  call scale_one_tsum(T0sum(204)%cmp, -2)
  call scale_one_tsum(T0sum(205)%cmp, -2)
  call scale_one_tsum(T0sum(206)%cmp, -2)
  call scale_one_tsum(T0sum(207)%cmp, -2)
  call scale_one_tsum(T0sum(208)%cmp, -2)
  call scale_one_tsum(T0sum(209)%cmp, -2)
  call scale_one_tsum(T0sum(210)%cmp, -2)
  call scale_one_tsum(T0sum(211)%cmp, -2)
  call scale_one_tsum(T0sum(212)%cmp, -2)
  call scale_one_tsum(T0sum(213)%cmp, -2)
  call scale_one_tsum(T0sum(214)%cmp, -2)
  call scale_one_tsum(T0sum(215)%cmp, -2)
  call scale_one_tsum(T0sum(216)%cmp, -2)
  call scale_one_tsum(T0sum(217)%cmp, -2)
  call scale_one_tsum(T0sum(218)%cmp, -2)
  call scale_one_tsum(T0sum(219)%cmp, -2)
  call scale_one_tsum(T0sum(220)%cmp, -2)
  call scale_one_tsum(T0sum(221)%cmp, -2)
  call scale_one_tsum(T0sum(222)%cmp, -2)
  call scale_one_tsum(T0sum(223)%cmp, -2)
  call scale_one_tsum(T0sum(224)%cmp, -2)
  call scale_one_tsum(T0sum(225)%cmp, -2)
  call scale_one_tsum(T0sum(226)%cmp, -2)
  call scale_one_tsum(T0sum(227)%cmp, -2)
  call scale_one_tsum(T0sum(228)%cmp, -2)
  call scale_one_tsum(T0sum(229)%cmp, -2)
  call scale_one_tsum(T0sum(230)%cmp, -2)
  call scale_one_tsum(T0sum(231)%cmp, -2)
  call scale_one_tsum(T0sum(232)%cmp, -2)
  call scale_one_tsum(T0sum(233)%cmp, -2)
  call scale_one_tsum(T0sum(234)%cmp, -2)
  call scale_one_tsum(T0sum(235)%cmp, -2)
  call scale_one_tsum(T0sum(236)%cmp, -2)
  call scale_one_tsum(T0sum(237)%cmp, -2)
  call scale_one_tsum(T0sum(238)%cmp, -2)
  call scale_one_tsum(T0sum(239)%cmp, -2)
  call scale_one_tsum(T0sum(240)%cmp, -2)
  call scale_one_tsum(T0sum(241)%cmp, -2)
  call scale_one_tsum(T0sum(242)%cmp, -2)
  call scale_one_tsum(T0sum(243)%cmp, -2)
  call scale_one_tsum(T0sum(244)%cmp, -2)
  call scale_one_tsum(T0sum(245)%cmp, -2)
  call scale_one_tsum(T0sum(246)%cmp, -2)
  call scale_one_tsum(T0sum(247)%cmp, -2)
  call scale_one_tsum(T0sum(248)%cmp, -2)
  call scale_one_tsum(T0sum(249)%cmp, -2)
  call scale_one_tsum(T0sum(250)%cmp, -2)
  call scale_one_tsum(T0sum(251)%cmp, -2)
  call scale_one_tsum(T0sum(252)%cmp, -2)
  call scale_one_tsum(T0sum(253)%cmp, -2)
  call scale_one_tsum(T0sum(254)%cmp, -2)
  call scale_one_tsum(T0sum(255)%cmp, -2)
  call scale_one_tsum(T0sum(256)%cmp, -2)
  call scale_one_tsum(T0sum(257)%cmp, -2)
  call scale_one_tsum(T0sum(258)%cmp, -2)
  call scale_one_tsum(T0sum(259)%cmp, -2)
  call scale_one_tsum(T0sum(260)%cmp, -2)
  call scale_one_tsum(T0sum(261)%cmp, -2)
  call scale_one_tsum(T0sum(262)%cmp, -2)
  call scale_one_tsum(T0sum(263)%cmp, -2)
  call scale_one_tsum(T0sum(264)%cmp, -2)
  call scale_one_tsum(T0sum(265)%cmp, -2)
  call scale_one_tsum(T0sum(266)%cmp, -2)
  call scale_one_tsum(T0sum(267)%cmp, -2)
  call scale_one_tsum(T0sum(268)%cmp, -2)
  call scale_one_tsum(T0sum(269)%cmp, -2)
  call scale_one_tsum(T0sum(270)%cmp, -2)
  call scale_one_tsum(T0sum(271)%cmp, -2)
  call scale_one_tsum(T0sum(272)%cmp, -2)
  call scale_one_tsum(T0sum(273)%cmp, -2)
  call scale_one_tsum(T0sum(274)%cmp, -2)
  call scale_one_tsum(T0sum(275)%cmp, -2)
  call scale_one_tsum(T0sum(276)%cmp, -2)
  call scale_one_tsum(T0sum(277)%cmp, -2)
  call scale_one_tsum(T0sum(278)%cmp, -2)
  call scale_one_tsum(T0sum(279)%cmp, -2)
  call scale_one_tsum(T0sum(280)%cmp, -2)
  call scale_one_tsum(T0sum(281)%cmp, -2)
  call scale_one_tsum(T0sum(282)%cmp, -2)
  call scale_one_tsum(T0sum(283)%cmp, -2)
  call scale_one_tsum(T0sum(284)%cmp, -2)
  call scale_one_tsum(T0sum(285)%cmp, -2)
  call scale_one_tsum(T0sum(286)%cmp, -2)
  call scale_one_tsum(T0sum(287)%cmp, -2)
  call scale_one_tsum(T0sum(288)%cmp, -2)
  call scale_one_tsum(T0sum(289)%cmp, -2)
  call scale_one_tsum(T0sum(290)%cmp, -2)
  call scale_one_tsum(T0sum(291)%cmp, -2)
  call scale_one_tsum(T0sum(292)%cmp, -2)
  call scale_one_tsum(T0sum(293)%cmp, -2)
  call scale_one_tsum(T0sum(294)%cmp, -2)
  call scale_one_tsum(T0sum(295)%cmp, -2)
  call scale_one_tsum(T0sum(296)%cmp, -2)
  call scale_one_tsum(T0sum(297)%cmp, -2)
  call scale_one_tsum(T1sum(75)%cmp, -2)
  call scale_one_tsum(T1sum(76)%cmp, -2)
  call scale_one_tsum(T1sum(77)%cmp, -2)
  call scale_one_tsum(T1sum(78)%cmp, -2)
  call scale_one_tsum(T1sum(79)%cmp, -2)
  call scale_one_tsum(T1sum(80)%cmp, -2)
  call scale_one_tsum(T1sum(81)%cmp, -2)
  call scale_one_tsum(T1sum(82)%cmp, -2)
  call scale_one_tsum(T1sum(83)%cmp, -2)
  call scale_one_tsum(T1sum(84)%cmp, -2)
  call scale_one_tsum(T1sum(85)%cmp, -2)
  call scale_one_tsum(T1sum(86)%cmp, -2)
  call scale_one_tsum(T1sum(87)%cmp, -2)
  call scale_one_tsum(T1sum(88)%cmp, -2)
  call scale_one_tsum(T1sum(89)%cmp, -2)
  call scale_one_tsum(T1sum(90)%cmp, -2)
  call scale_one_tsum(T1sum(91)%cmp, -2)
  call scale_one_tsum(T1sum(92)%cmp, -2)
  call scale_one_tsum(T0sum(298)%cmp, -2)
  call scale_one_tsum(T0sum(299)%cmp, -2)
  call scale_one_tsum(T0sum(300)%cmp, -2)
  call scale_one_tsum(T0sum(301)%cmp, -2)
  call scale_one_tsum(T0sum(302)%cmp, -2)
  call scale_one_tsum(T0sum(303)%cmp, -4)
  call scale_one_tsum(T0sum(304)%cmp, -4)
  call scale_one_tsum(T0sum(305)%cmp, -4)
  call scale_one_tsum(T0sum(306)%cmp, -4)
  call scale_one_tsum(T0sum(307)%cmp, -4)
  call scale_one_tsum(T0sum(308)%cmp, -4)
  call scale_one_tsum(T0sum(309)%cmp, -4)
  call scale_one_tsum(T0sum(310)%cmp, -4)
  call scale_one_tsum(T0sum(311)%cmp, -4)
  call scale_one_tsum(T0sum(312)%cmp, -4)
  call scale_one_tsum(T0sum(313)%cmp, -4)
  call scale_one_tsum(T0sum(314)%cmp, -4)
  call scale_one_tsum(T0sum(315)%cmp, -4)
  call scale_one_tsum(T0sum(316)%cmp, -4)
  call scale_one_tsum(T0sum(317)%cmp, -4)
  call scale_one_tsum(T0sum(318)%cmp, -4)
  call scale_one_tsum(T0sum(319)%cmp, -4)
  call scale_one_tsum(T0sum(320)%cmp, -4)
  call scale_one_tsum(T0sum(321)%cmp, -4)
  call scale_one_tsum(T0sum(322)%cmp, -4)
  call scale_one_tsum(T0sum(323)%cmp, -4)
  call scale_one_tsum(T0sum(324)%cmp, -4)
  call scale_one_tsum(T0sum(325)%cmp, -4)
  call scale_one_tsum(T0sum(326)%cmp, -4)
  call scale_one_tsum(T0sum(327)%cmp, -4)
  call scale_one_tsum(T0sum(328)%cmp, -4)
  call scale_one_tsum(T0sum(329)%cmp, -4)
  call scale_one_tsum(T0sum(330)%cmp, -4)
  call scale_one_tsum(T0sum(331)%cmp, -4)
  call scale_one_tsum(T0sum(332)%cmp, -4)
  call scale_one_tsum(T0sum(333)%cmp, -4)
  call scale_one_tsum(T0sum(334)%cmp, -4)
  call scale_one_tsum(T0sum(335)%cmp, -4)
  call scale_one_tsum(T0sum(336)%cmp, -4)
  call scale_one_tsum(T0sum(337)%cmp, -4)
  call scale_one_tsum(T0sum(338)%cmp, -4)
  call scale_one_tsum(T0sum(339)%cmp, -4)
  call scale_one_tsum(T0sum(340)%cmp, -4)
  call scale_one_tsum(T0sum(341)%cmp, -4)
  call scale_one_tsum(T0sum(342)%cmp, -4)
  call scale_one_tsum(T0sum(343)%cmp, -4)
  call scale_one_tsum(T0sum(344)%cmp, -4)
  call scale_one_tsum(T0sum(345)%cmp, -4)
  call scale_one_tsum(T0sum(346)%cmp, -4)
  call scale_one_tsum(T0sum(347)%cmp, -4)
  call scale_one_tsum(T0sum(348)%cmp, -4)
  call scale_one_tsum(T0sum(349)%cmp, -4)
  call scale_one_tsum(T0sum(350)%cmp, -4)
  call scale_one_tsum(T0sum(351)%cmp, -4)
  call scale_one_tsum(T0sum(352)%cmp, -4)
  call scale_one_tsum(T0sum(353)%cmp, -4)
  call scale_one_tsum(T0sum(354)%cmp, -4)
  call scale_one_tsum(T0sum(355)%cmp, -4)
  call scale_one_tsum(T0sum(356)%cmp, -4)
  call scale_one_tsum(T0sum(357)%cmp, -4)

end subroutine scale_tensor_sum

! **********************************************************************
subroutine set_integral_masses_and_momenta()
! **********************************************************************

  use ol_parameters_decl_/**/REALKIND
  momenta_1 = [ 0, 0 ]
  momenta_2 = [ 32, 31 ]
  momenta_3 = [ 33, 30 ]
  momenta_4 = [ 34, 29 ]
  momenta_5 = [ 35, 28 ]
  momenta_6 = [ 36, 27 ]
  momenta_7 = [ 37, 26 ]
  momenta_8 = [ 38, 25 ]
  momenta_9 = [ 40, 23 ]
  momenta_10 = [ 41, 22 ]
  momenta_11 = [ 42, 21 ]
  momenta_12 = [ 44, 19 ]
  momenta_13 = [ 45, 18 ]
  momenta_14 = [ 46, 17 ]
  momenta_15 = [ 47, 16 ]
  momenta_16 = [ 48, 15 ]
  momenta_17 = [ 49, 14 ]
  momenta_18 = [ 50, 13 ]
  momenta_19 = [ 51, 12 ]
  momenta_20 = [ 53, 10 ]
  momenta_21 = [ 54, 9 ]
  momenta_22 = [ 55, 8 ]
  momenta_23 = [ 57, 6 ]
  momenta_24 = [ 58, 5 ]
  momenta_25 = [ 59, 4 ]
  momenta_26 = [ 60, 3 ]
  momenta_27 = [ 61, 2 ]
  momenta_28 = [ 62, 1 ]
  momenta_29 = [ 32, 1, 30 ]
  momenta_30 = [ 32, 2, 29 ]
  momenta_31 = [ 32, 3, 28 ]
  momenta_32 = [ 32, 4, 27 ]
  momenta_33 = [ 32, 5, 26 ]
  momenta_34 = [ 32, 6, 25 ]
  momenta_35 = [ 32, 8, 23 ]
  momenta_36 = [ 32, 9, 22 ]
  momenta_37 = [ 32, 10, 21 ]
  momenta_38 = [ 32, 12, 19 ]
  momenta_39 = [ 32, 13, 18 ]
  momenta_40 = [ 32, 14, 17 ]
  momenta_41 = [ 32, 15, 16 ]
  momenta_42 = [ 32, 17, 14 ]
  momenta_43 = [ 32, 18, 13 ]
  momenta_44 = [ 32, 19, 12 ]
  momenta_45 = [ 32, 21, 10 ]
  momenta_46 = [ 32, 22, 9 ]
  momenta_47 = [ 32, 23, 8 ]
  momenta_48 = [ 32, 27, 4 ]
  momenta_49 = [ 32, 29, 2 ]
  momenta_50 = [ 33, 2, 28 ]
  momenta_51 = [ 33, 4, 26 ]
  momenta_52 = [ 33, 8, 22 ]
  momenta_53 = [ 33, 12, 18 ]
  momenta_54 = [ 33, 14, 16 ]
  momenta_55 = [ 33, 16, 14 ]
  momenta_56 = [ 33, 18, 12 ]
  momenta_57 = [ 33, 22, 8 ]
  momenta_58 = [ 33, 26, 4 ]
  momenta_59 = [ 33, 28, 2 ]
  momenta_60 = [ 34, 1, 28 ]
  momenta_61 = [ 34, 4, 25 ]
  momenta_62 = [ 34, 8, 21 ]
  momenta_63 = [ 34, 12, 17 ]
  momenta_64 = [ 34, 13, 16 ]
  momenta_65 = [ 34, 16, 13 ]
  momenta_66 = [ 34, 17, 12 ]
  momenta_67 = [ 34, 21, 8 ]
  momenta_68 = [ 34, 25, 4 ]
  momenta_69 = [ 35, 12, 16 ]
  momenta_70 = [ 35, 16, 12 ]
  momenta_71 = [ 36, 1, 26 ]
  momenta_72 = [ 36, 2, 25 ]
  momenta_73 = [ 36, 8, 19 ]
  momenta_74 = [ 36, 9, 18 ]
  momenta_75 = [ 36, 10, 17 ]
  momenta_76 = [ 36, 17, 10 ]
  momenta_77 = [ 36, 18, 9 ]
  momenta_78 = [ 36, 19, 8 ]
  momenta_79 = [ 37, 8, 18 ]
  momenta_80 = [ 37, 10, 16 ]
  momenta_81 = [ 37, 16, 10 ]
  momenta_82 = [ 37, 18, 8 ]
  momenta_83 = [ 38, 8, 17 ]
  momenta_84 = [ 38, 9, 16 ]
  momenta_85 = [ 38, 16, 9 ]
  momenta_86 = [ 38, 17, 8 ]
  momenta_87 = [ 40, 1, 22 ]
  momenta_88 = [ 40, 2, 21 ]
  momenta_89 = [ 40, 4, 19 ]
  momenta_90 = [ 40, 5, 18 ]
  momenta_91 = [ 40, 6, 17 ]
  momenta_92 = [ 40, 17, 6 ]
  momenta_93 = [ 40, 18, 5 ]
  momenta_94 = [ 40, 19, 4 ]
  momenta_95 = [ 40, 21, 2 ]
  momenta_96 = [ 40, 22, 1 ]
  momenta_97 = [ 41, 4, 18 ]
  momenta_98 = [ 41, 6, 16 ]
  momenta_99 = [ 41, 16, 6 ]
  momenta_100 = [ 41, 18, 4 ]
  momenta_101 = [ 42, 4, 17 ]
  momenta_102 = [ 42, 5, 16 ]
  momenta_103 = [ 42, 16, 5 ]
  momenta_104 = [ 42, 17, 4 ]
  momenta_105 = [ 44, 1, 18 ]
  momenta_106 = [ 44, 2, 17 ]
  momenta_107 = [ 44, 3, 16 ]
  momenta_108 = [ 44, 17, 2 ]
  momenta_109 = [ 44, 18, 1 ]
  momenta_110 = [ 45, 2, 16 ]
  momenta_111 = [ 45, 16, 2 ]
  momenta_112 = [ 46, 1, 16 ]
  momenta_113 = [ 46, 16, 1 ]
  momenta_114 = [ 48, 1, 14 ]
  momenta_115 = [ 48, 2, 13 ]
  momenta_116 = [ 48, 3, 12 ]
  momenta_117 = [ 48, 5, 10 ]
  momenta_118 = [ 48, 6, 9 ]
  momenta_119 = [ 48, 9, 6 ]
  momenta_120 = [ 48, 10, 5 ]
  momenta_121 = [ 48, 12, 3 ]
  momenta_122 = [ 48, 13, 2 ]
  momenta_123 = [ 48, 14, 1 ]
  momenta_124 = [ 49, 2, 12 ]
  momenta_125 = [ 49, 4, 10 ]
  momenta_126 = [ 49, 6, 8 ]
  momenta_127 = [ 49, 8, 6 ]
  momenta_128 = [ 49, 10, 4 ]
  momenta_129 = [ 49, 12, 2 ]
  momenta_130 = [ 50, 1, 12 ]
  momenta_131 = [ 50, 4, 9 ]
  momenta_132 = [ 50, 5, 8 ]
  momenta_133 = [ 50, 8, 5 ]
  momenta_134 = [ 50, 9, 4 ]
  momenta_135 = [ 50, 12, 1 ]
  momenta_136 = [ 51, 4, 8 ]
  momenta_137 = [ 51, 8, 4 ]
  momenta_138 = [ 53, 2, 8 ]
  momenta_139 = [ 53, 8, 2 ]
  momenta_140 = [ 54, 1, 8 ]
  momenta_141 = [ 54, 8, 1 ]
  momenta_142 = [ 57, 2, 4 ]
  momenta_143 = [ 57, 4, 2 ]
  momenta_144 = [ 58, 1, 4 ]
  momenta_145 = [ 58, 4, 1 ]
  momenta_146 = [ 60, 1, 2 ]
  momenta_147 = [ 60, 2, 1 ]
  momenta_148 = [ 32, 1, 2, 28 ]
  momenta_149 = [ 32, 1, 4, 26 ]
  momenta_150 = [ 32, 1, 8, 22 ]
  momenta_151 = [ 32, 1, 12, 18 ]
  momenta_152 = [ 32, 1, 14, 16 ]
  momenta_153 = [ 32, 1, 16, 14 ]
  momenta_154 = [ 32, 1, 18, 12 ]
  momenta_155 = [ 32, 1, 22, 8 ]
  momenta_156 = [ 32, 1, 26, 4 ]
  momenta_157 = [ 32, 1, 28, 2 ]
  momenta_158 = [ 32, 2, 1, 28 ]
  momenta_159 = [ 32, 2, 4, 25 ]
  momenta_160 = [ 32, 2, 8, 21 ]
  momenta_161 = [ 32, 2, 12, 17 ]
  momenta_162 = [ 32, 2, 13, 16 ]
  momenta_163 = [ 32, 2, 16, 13 ]
  momenta_164 = [ 32, 2, 17, 12 ]
  momenta_165 = [ 32, 2, 21, 8 ]
  momenta_166 = [ 32, 2, 25, 4 ]
  momenta_167 = [ 32, 3, 12, 16 ]
  momenta_168 = [ 32, 3, 16, 12 ]
  momenta_169 = [ 32, 4, 1, 26 ]
  momenta_170 = [ 32, 4, 2, 25 ]
  momenta_171 = [ 32, 4, 8, 19 ]
  momenta_172 = [ 32, 4, 9, 18 ]
  momenta_173 = [ 32, 4, 10, 17 ]
  momenta_174 = [ 32, 4, 17, 10 ]
  momenta_175 = [ 32, 4, 18, 9 ]
  momenta_176 = [ 32, 4, 19, 8 ]
  momenta_177 = [ 32, 5, 8, 18 ]
  momenta_178 = [ 32, 5, 10, 16 ]
  momenta_179 = [ 32, 5, 16, 10 ]
  momenta_180 = [ 32, 5, 18, 8 ]
  momenta_181 = [ 32, 6, 8, 17 ]
  momenta_182 = [ 32, 6, 9, 16 ]
  momenta_183 = [ 32, 6, 16, 9 ]
  momenta_184 = [ 32, 6, 17, 8 ]
  momenta_185 = [ 32, 8, 4, 19 ]
  momenta_186 = [ 32, 8, 5, 18 ]
  momenta_187 = [ 32, 8, 6, 17 ]
  momenta_188 = [ 32, 9, 4, 18 ]
  momenta_189 = [ 32, 9, 6, 16 ]
  momenta_190 = [ 32, 10, 4, 17 ]
  momenta_191 = [ 32, 10, 5, 16 ]
  momenta_192 = [ 32, 12, 1, 18 ]
  momenta_193 = [ 32, 12, 2, 17 ]
  momenta_194 = [ 32, 12, 3, 16 ]
  momenta_195 = [ 32, 13, 2, 16 ]
  momenta_196 = [ 32, 13, 16, 2 ]
  momenta_197 = [ 32, 14, 1, 16 ]
  momenta_198 = [ 32, 17, 2, 12 ]
  momenta_199 = [ 32, 17, 6, 8 ]
  momenta_200 = [ 32, 17, 10, 4 ]
  momenta_201 = [ 32, 17, 12, 2 ]
  momenta_202 = [ 32, 18, 1, 12 ]
  momenta_203 = [ 32, 18, 5, 8 ]
  momenta_204 = [ 32, 18, 9, 4 ]
  momenta_205 = [ 32, 19, 4, 8 ]
  momenta_206 = [ 32, 19, 8, 4 ]
  momenta_207 = [ 32, 21, 2, 8 ]
  momenta_208 = [ 32, 22, 1, 8 ]
  momenta_209 = [ 33, 2, 12, 16 ]
  momenta_210 = [ 33, 2, 16, 12 ]
  momenta_211 = [ 33, 4, 8, 18 ]
  momenta_212 = [ 33, 4, 10, 16 ]
  momenta_213 = [ 33, 8, 4, 18 ]
  momenta_214 = [ 33, 8, 6, 16 ]
  momenta_215 = [ 33, 12, 2, 16 ]
  momenta_216 = [ 33, 12, 16, 2 ]
  momenta_217 = [ 33, 16, 2, 12 ]
  momenta_218 = [ 33, 16, 6, 8 ]
  momenta_219 = [ 33, 16, 10, 4 ]
  momenta_220 = [ 33, 16, 12, 2 ]
  momenta_221 = [ 33, 18, 4, 8 ]
  momenta_222 = [ 33, 18, 8, 4 ]
  momenta_223 = [ 34, 1, 12, 16 ]
  momenta_224 = [ 34, 1, 16, 12 ]
  momenta_225 = [ 34, 4, 8, 17 ]
  momenta_226 = [ 34, 4, 9, 16 ]
  momenta_227 = [ 34, 8, 4, 17 ]
  momenta_228 = [ 34, 8, 5, 16 ]
  momenta_229 = [ 34, 12, 1, 16 ]
  momenta_230 = [ 34, 16, 1, 12 ]
  momenta_231 = [ 34, 16, 5, 8 ]
  momenta_232 = [ 34, 16, 9, 4 ]
  momenta_233 = [ 34, 17, 4, 8 ]
  momenta_234 = [ 34, 17, 8, 4 ]
  momenta_235 = [ 36, 1, 16, 10 ]
  momenta_236 = [ 36, 1, 18, 8 ]
  momenta_237 = [ 36, 2, 16, 9 ]
  momenta_238 = [ 36, 2, 17, 8 ]
  momenta_239 = [ 36, 8, 1, 18 ]
  momenta_240 = [ 36, 8, 2, 17 ]
  momenta_241 = [ 36, 17, 2, 8 ]
  momenta_242 = [ 36, 18, 1, 8 ]
  momenta_243 = [ 37, 8, 2, 16 ]
  momenta_244 = [ 37, 16, 2, 8 ]
  momenta_245 = [ 38, 8, 1, 16 ]
  momenta_246 = [ 38, 16, 1, 8 ]
  momenta_247 = [ 40, 1, 16, 6 ]
  momenta_248 = [ 40, 1, 18, 4 ]
  momenta_249 = [ 40, 2, 16, 5 ]
  momenta_250 = [ 40, 2, 17, 4 ]
  momenta_251 = [ 40, 4, 1, 18 ]
  momenta_252 = [ 40, 4, 2, 17 ]
  momenta_253 = [ 40, 4, 17, 2 ]
  momenta_254 = [ 40, 4, 18, 1 ]
  momenta_255 = [ 40, 5, 16, 2 ]
  momenta_256 = [ 40, 6, 16, 1 ]
  momenta_257 = [ 40, 17, 2, 4 ]
  momenta_258 = [ 40, 18, 1, 4 ]
  momenta_259 = [ 41, 4, 2, 16 ]
  momenta_260 = [ 41, 16, 2, 4 ]
  momenta_261 = [ 42, 4, 1, 16 ]
  momenta_262 = [ 42, 16, 1, 4 ]
  momenta_263 = [ 44, 1, 2, 16 ]
  momenta_264 = [ 44, 1, 16, 2 ]
  momenta_265 = [ 44, 2, 1, 16 ]
  momenta_266 = [ 44, 2, 16, 1 ]
  momenta_267 = [ 48, 1, 2, 12 ]
  momenta_268 = [ 48, 1, 4, 10 ]
  momenta_269 = [ 48, 1, 8, 6 ]
  momenta_270 = [ 48, 1, 12, 2 ]
  momenta_271 = [ 48, 2, 1, 12 ]
  momenta_272 = [ 48, 2, 4, 9 ]
  momenta_273 = [ 48, 2, 8, 5 ]
  momenta_274 = [ 48, 2, 12, 1 ]
  momenta_275 = [ 48, 5, 8, 2 ]
  momenta_276 = [ 48, 6, 8, 1 ]
  momenta_277 = [ 48, 9, 4, 2 ]
  momenta_278 = [ 48, 10, 4, 1 ]
  momenta_279 = [ 48, 12, 1, 2 ]
  momenta_280 = [ 48, 12, 2, 1 ]
  momenta_281 = [ 49, 2, 4, 8 ]
  momenta_282 = [ 49, 2, 8, 4 ]
  momenta_283 = [ 49, 4, 8, 2 ]
  momenta_284 = [ 49, 8, 4, 2 ]
  momenta_285 = [ 50, 1, 4, 8 ]
  momenta_286 = [ 50, 1, 8, 4 ]
  momenta_287 = [ 50, 4, 8, 1 ]
  momenta_288 = [ 50, 8, 4, 1 ]
  momenta_289 = [ 32, 1, 2, 12, 16 ]
  momenta_290 = [ 32, 1, 2, 16, 12 ]
  momenta_291 = [ 32, 1, 4, 8, 18 ]
  momenta_292 = [ 32, 1, 4, 10, 16 ]
  momenta_293 = [ 32, 1, 8, 4, 18 ]
  momenta_294 = [ 32, 1, 8, 6, 16 ]
  momenta_295 = [ 32, 1, 12, 2, 16 ]
  momenta_296 = [ 32, 1, 12, 16, 2 ]
  momenta_297 = [ 32, 1, 16, 2, 12 ]
  momenta_298 = [ 32, 1, 16, 6, 8 ]
  momenta_299 = [ 32, 1, 16, 10, 4 ]
  momenta_300 = [ 32, 1, 16, 12, 2 ]
  momenta_301 = [ 32, 1, 18, 4, 8 ]
  momenta_302 = [ 32, 1, 18, 8, 4 ]
  momenta_303 = [ 32, 2, 1, 12, 16 ]
  momenta_304 = [ 32, 2, 1, 16, 12 ]
  momenta_305 = [ 32, 2, 4, 8, 17 ]
  momenta_306 = [ 32, 2, 4, 9, 16 ]
  momenta_307 = [ 32, 2, 8, 4, 17 ]
  momenta_308 = [ 32, 2, 8, 5, 16 ]
  momenta_309 = [ 32, 2, 12, 1, 16 ]
  momenta_310 = [ 32, 2, 16, 1, 12 ]
  momenta_311 = [ 32, 2, 16, 5, 8 ]
  momenta_312 = [ 32, 2, 16, 9, 4 ]
  momenta_313 = [ 32, 2, 17, 4, 8 ]
  momenta_314 = [ 32, 2, 17, 8, 4 ]
  momenta_315 = [ 32, 4, 1, 18, 8 ]
  momenta_316 = [ 32, 4, 2, 17, 8 ]
  momenta_317 = [ 32, 4, 8, 1, 18 ]
  momenta_318 = [ 32, 4, 8, 2, 17 ]
  momenta_319 = [ 32, 4, 17, 2, 8 ]
  momenta_320 = [ 32, 4, 18, 1, 8 ]
  momenta_321 = [ 32, 5, 8, 2, 16 ]
  momenta_322 = [ 32, 5, 16, 2, 8 ]
  momenta_323 = [ 32, 6, 8, 1, 16 ]
  momenta_324 = [ 32, 6, 16, 1, 8 ]
  momenta_325 = [ 32, 8, 4, 1, 18 ]
  momenta_326 = [ 32, 8, 4, 2, 17 ]
  momenta_327 = [ 32, 9, 4, 2, 16 ]
  momenta_328 = [ 32, 10, 4, 1, 16 ]
  momenta_329 = [ 32, 12, 1, 2, 16 ]
  momenta_330 = [ 32, 12, 2, 1, 16 ]
  momenta_331 = [ 32, 17, 2, 4, 8 ]
  momenta_332 = [ 32, 17, 2, 8, 4 ]
  momenta_333 = [ 32, 18, 1, 4, 8 ]
  momenta_334 = [ 32, 18, 1, 8, 4 ]
  momenta_335 = [ 33, 4, 8, 2, 16 ]
  momenta_336 = [ 33, 8, 4, 2, 16 ]
  momenta_337 = [ 33, 16, 2, 4, 8 ]
  momenta_338 = [ 33, 16, 2, 8, 4 ]
  momenta_339 = [ 34, 4, 8, 1, 16 ]
  momenta_340 = [ 34, 8, 4, 1, 16 ]
  momenta_341 = [ 34, 16, 1, 4, 8 ]
  momenta_342 = [ 34, 16, 1, 8, 4 ]
  momenta_343 = [ 36, 1, 16, 2, 8 ]
  momenta_344 = [ 36, 2, 16, 1, 8 ]
  momenta_345 = [ 40, 1, 16, 2, 4 ]
  momenta_346 = [ 40, 2, 16, 1, 4 ]
  momenta_347 = [ 40, 4, 1, 16, 2 ]
  momenta_348 = [ 40, 4, 2, 16, 1 ]
  momenta_349 = [ 48, 1, 4, 8, 2 ]
  momenta_350 = [ 48, 1, 8, 4, 2 ]
  momenta_351 = [ 48, 2, 4, 8, 1 ]
  momenta_352 = [ 48, 2, 8, 4, 1 ]
  momenta_353 = [ 32, 1, 4, 8, 2, 16 ]
  momenta_354 = [ 32, 1, 8, 4, 2, 16 ]
  momenta_355 = [ 32, 1, 16, 2, 4, 8 ]
  momenta_356 = [ 32, 1, 16, 2, 8, 4 ]
  momenta_357 = [ 32, 2, 4, 8, 1, 16 ]
  momenta_358 = [ 32, 2, 8, 4, 1, 16 ]
  momenta_359 = [ 32, 2, 16, 1, 4, 8 ]
  momenta_360 = [ 32, 2, 16, 1, 8, 4 ]
  momenta_361 = [ 32, 4, 1, 16, 2, 8 ]
  momenta_362 = [ 32, 4, 2, 16, 1, 8 ]

  masses2_1 = [ 0, 0 ]
  masses2_2 = [ nMB, 0 ]
  masses2_3 = [ nMT, 0 ]
  masses2_4 = [ nMB, nMB ]
  masses2_5 = [ 0, nMT ]
  masses2_6 = [ nMT, nMT ]
  masses2_7 = [ 0, 0, 0 ]
  masses2_8 = [ nMT, 0, 0 ]
  masses2_9 = [ 0, 0, nMT ]
  masses2_10 = [ nMT, 0, nMT ]
  masses2_11 = [ nMB, nMB, nMB ]
  masses2_12 = [ 0, nMT, 0 ]
  masses2_13 = [ nMT, nMT, 0 ]
  masses2_14 = [ 0, nMT, nMT ]
  masses2_15 = [ nMT, nMT, nMT ]
  masses2_16 = [ 0, 0, 0, 0 ]
  masses2_17 = [ nMT, 0, 0, 0 ]
  masses2_18 = [ 0, 0, 0, nMT ]
  masses2_19 = [ nMT, 0, 0, nMT ]
  masses2_20 = [ 0, 0, nMT, 0 ]
  masses2_21 = [ 0, 0, nMT, nMT ]
  masses2_22 = [ nMT, 0, nMT, nMT ]
  masses2_23 = [ nMB, nMB, nMB, nMB ]
  masses2_24 = [ 0, nMT, 0, 0 ]
  masses2_25 = [ nMT, nMT, 0, 0 ]
  masses2_26 = [ nMT, nMT, 0, nMT ]
  masses2_27 = [ 0, nMT, nMT, 0 ]
  masses2_28 = [ nMT, nMT, nMT, 0 ]
  masses2_29 = [ 0, nMT, nMT, nMT ]
  masses2_30 = [ nMT, nMT, nMT, nMT ]
  masses2_31 = [ 0, 0, 0, 0, nMT ]
  masses2_32 = [ nMT, 0, 0, 0, nMT ]
  masses2_33 = [ 0, 0, 0, nMT, 0 ]
  masses2_34 = [ 0, 0, 0, nMT, nMT ]
  masses2_35 = [ 0, 0, nMT, 0, 0 ]
  masses2_36 = [ 0, 0, nMT, nMT, 0 ]
  masses2_37 = [ 0, 0, nMT, nMT, nMT ]
  masses2_38 = [ nMT, nMT, 0, 0, 0 ]
  masses2_39 = [ nMT, nMT, 0, 0, nMT ]
  masses2_40 = [ nMT, nMT, 0, nMT, nMT ]
  masses2_41 = [ 0, nMT, nMT, 0, 0 ]
  masses2_42 = [ nMT, nMT, nMT, 0, nMT ]
  masses2_43 = [ 0, 0, 0, nMT, nMT, 0 ]
  masses2_44 = [ 0, 0, nMT, nMT, 0, 0 ]
  masses2_45 = [ nMT, nMT, 0, 0, 0, nMT ]


end subroutine  set_integral_masses_and_momenta

! **********************************************************************
subroutine integrate_tensor_sum(M2out)
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/REALKIND, only: init_met, add_met, met_to_real
  use ol_loop_routines_/**/REALKIND, only: TI_call_OL
  implicit none
  real(REALKIND), intent(out) :: M2out
  type(met) :: M2
  call init_met(M2)

sbarray_1 = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]
sbarray_2 = [16, 17, 18, 4, 19, 20, 21, 8, 22, 23, 11, 24, 13, 25, 15]
sbarray_3 = [26, 27, 28, 29, 30, 6, 31, 32, 33, 34, 35, 36, 37, 38, 39]
sbarray_4 = [40, 41, 42, 29, 43, 20, 44, 32, 45, 46, 35, 47, 37, 48, 39]
sbarray_5 = [49, 50, 51, 52, 39, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62]
sbarray_6 = [63, 64, 65, 66, 15, 67, 68, 69, 70, 57, 71, 72, 73, 74, 75]
sbarray_7 = [76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90]
sbarray_8 = [91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105]
sbarray_9 = [106, 77, 107, 108, 109, 81, 110, 111, 112, 85, 86, 87, 113, 114, 115]
sbarray_10 = [116, 92, 117, 118, 119, 96, 120, 121, 122, 100, 101, 102, 123, 124, 125]
sbarray_11 = [126, 127, 128, 129, 62]
sbarray_12 = [130, 131, 132, 133, 75]
sbarray_13 = [134, 135, 136, 137, 90]
sbarray_14 = [138, 139, 140, 141, 105]
sbarray_15 = [142, 143, 136, 144, 115]
sbarray_16 = [145, 146, 140, 147, 125]
sbarray_17 = [148, 149, 150, 151, 15]
sbarray_18 = [1, 2, 3, 4, 5]
sbarray_19 = [1, 6, 7, 8, 9]
sbarray_20 = [2, 6, 10, 11, 12]
sbarray_21 = [3, 7, 10, 13, 14]
sbarray_22 = [63, 64, 65, 66, 15]
sbarray_23 = [16, 17, 18, 4, 19]
sbarray_24 = [16, 20, 21, 8, 22]
sbarray_25 = [17, 20, 23, 11, 24]
sbarray_26 = [18, 21, 23, 13, 25]
sbarray_27 = [152, 153, 154, 155, 39]
sbarray_28 = [26, 27, 28, 29, 30]
sbarray_29 = [26, 6, 31, 32, 33]
sbarray_30 = [27, 6, 34, 35, 36]
sbarray_31 = [28, 31, 34, 37, 38]
sbarray_32 = [49, 50, 51, 52, 39]
sbarray_33 = [40, 41, 42, 29, 43]
sbarray_34 = [40, 20, 44, 32, 45]
sbarray_35 = [41, 20, 46, 35, 47]
sbarray_36 = [42, 44, 46, 37, 48]
sbarray_37 = [49, 53, 54, 55, 56]
sbarray_38 = [50, 53, 57, 58, 59]
sbarray_39 = [51, 54, 57, 60, 61]
sbarray_40 = [63, 67, 68, 69, 70]
sbarray_41 = [64, 67, 57, 71, 72]
sbarray_42 = [65, 68, 57, 73, 74]
sbarray_43 = [76, 77, 78, 79, 80]
sbarray_44 = [76, 81, 82, 83, 84]
sbarray_45 = [77, 81, 85, 86, 87]
sbarray_46 = [78, 82, 85, 88, 89]
sbarray_47 = [91, 92, 93, 94, 95]
sbarray_48 = [91, 96, 97, 98, 99]
sbarray_49 = [92, 96, 100, 101, 102]
sbarray_50 = [93, 97, 100, 103, 104]
sbarray_51 = [106, 77, 107, 108, 109]
sbarray_52 = [106, 81, 110, 111, 112]
sbarray_53 = [107, 110, 85, 113, 114]
sbarray_54 = [116, 92, 117, 118, 119]
sbarray_55 = [116, 96, 120, 121, 122]
sbarray_56 = [117, 120, 100, 123, 124]
sbarray_57 = [133, 156, 157, 158, 119]
sbarray_58 = [159, 156, 160, 161, 95]
sbarray_59 = [129, 162, 163, 158, 80]
sbarray_60 = [164, 162, 165, 161, 109]
sbarray_61 = [166, 167, 168, 37, 169]
sbarray_62 = [170, 171, 168, 172, 173]
sbarray_63 = [108, 111, 86, 113, 115]
sbarray_64 = [79, 83, 86, 88, 90]
sbarray_65 = [94, 98, 101, 103, 105]
sbarray_66 = [118, 121, 101, 123, 125]
sbarray_67 = [29, 32, 35, 37, 39]
sbarray_68 = [4, 8, 11, 13, 15]
sbarray_69 = [174, 175, 176, 177, 178]
sbarray_70 = [179, 81, 180, 181, 182]
sbarray_71 = [183, 175, 184, 185, 186]
sbarray_72 = [187, 188, 100, 185, 189]
sbarray_73 = [190, 96, 180, 191, 192]
sbarray_74 = [193, 188, 85, 177, 194]


#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif
  call TI_call_OL(0,0, momenta_249, masses2_21, T0sum(1), M2,[151], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_163, masses2_21, T0sum(2), M2,[13], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_237, masses2_21, T0sum(3), M2,[66], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_247, masses2_21, T0sum(4), M2,[155], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_153, masses2_21, T0sum(5), M2,[37], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_235, masses2_21, T0sum(6), M2,[52], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_164, masses2_20, T0sum(7), M2,[11], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_154, masses2_20, T0sum(8), M2,[35], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_251, masses2_18, T0sum(9), M2,[129], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_252, masses2_18, T0sum(10), M2,[133], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_230, masses2_27, T0sum(11), M2,[4], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_202, masses2_20, T0sum(12), M2,[8], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_217, masses2_27, T0sum(13), M2,[29], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_198, masses2_20, T0sum(14), M2,[32], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_185, masses2_16, T0sum(15), M2,[158], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_171, masses2_16, T0sum(16), M2,[161], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_151, masses2_21, T0sum(17), M2,[172], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_169, masses2_18, T0sum(18), M2,[60], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_170, masses2_18, T0sum(19), M2,[73], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_282, masses2_24, T0sum(20), M2,[40], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_273, masses2_25, T0sum(21), M2,[137], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_160, masses2_25, T0sum(22), M2,[88], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_285, masses2_24, T0sum(23), M2,[1], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_268, masses2_25, T0sum(24), M2,[141], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_149, masses2_25, T0sum(25), M2,[103], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_281, masses2_24, T0sum(26), M2,[26], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_272, masses2_25, T0sum(27), M2,[144], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_159, masses2_25, T0sum(28), M2,[113], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_286, masses2_24, T0sum(29), M2,[16], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_269, masses2_25, T0sum(30), M2,[147], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_150, masses2_25, T0sum(31), M2,[123], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_266, masses2_21, T0sum(32), M2,[130], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_264, masses2_21, T0sum(33), M2,[126], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_255, masses2_21, T0sum(34), M2,[127], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_179, masses2_21, T0sum(35), M2,[55], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_253, masses2_18, T0sum(36), M2,[128], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_174, masses2_18, T0sum(37), M2,[58], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_256, masses2_21, T0sum(38), M2,[131], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_183, masses2_21, T0sum(39), M2,[69], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_254, masses2_18, T0sum(40), M2,[132], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_175, masses2_18, T0sum(41), M2,[71], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_288, masses2_17, T0sum(42), M2,[134], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_227, masses2_17, T0sum(43), M2,[79], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_278, masses2_25, T0sum(44), M2,[135], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_190, masses2_25, T0sum(45), M2,[83], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_274, masses2_25, T0sum(46), M2,[136], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_161, masses2_25, T0sum(47), M2,[86], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_283, masses2_17, T0sum(48), M2,[138], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_211, masses2_17, T0sum(49), M2,[94], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_275, masses2_25, T0sum(50), M2,[139], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_177, masses2_25, T0sum(51), M2,[98], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_270, masses2_25, T0sum(52), M2,[140], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_151, masses2_25, T0sum(53), M2,[101], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_287, masses2_17, T0sum(54), M2,[142], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_225, masses2_17, T0sum(55), M2,[108], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_276, masses2_25, T0sum(56), M2,[143], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_181, masses2_25, T0sum(57), M2,[111], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_284, masses2_17, T0sum(58), M2,[145], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_213, masses2_17, T0sum(59), M2,[118], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_277, masses2_25, T0sum(60), M2,[146], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_188, masses2_25, T0sum(61), M2,[121], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_265, masses2_26, T0sum(62), M2,[179], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_158, masses2_26, T0sum(63), M2,[177], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_280, masses2_28, T0sum(64), M2,[182], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_193, masses2_28, T0sum(65), M2,[181], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_263, masses2_26, T0sum(66), M2,[190], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_148, masses2_26, T0sum(67), M2,[185], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_267, masses2_26, T0sum(68), M2,[189], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_279, masses2_28, T0sum(69), M2,[192], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_192, masses2_28, T0sum(70), M2,[191], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_271, masses2_26, T0sum(71), M2,[194], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_261, masses2_19, T0sum(72), M2,[76], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_259, masses2_19, T0sum(73), M2,[116], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_262, masses2_27, T0sum(74), M2,[148], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_258, masses2_20, T0sum(75), M2,[149], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_250, masses2_20, T0sum(76), M2,[150], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_233, masses2_24, T0sum(77), M2,[2], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_231, masses2_27, T0sum(78), M2,[3], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_205, masses2_16, T0sum(79), M2,[6], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_203, masses2_20, T0sum(80), M2,[7], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_165, masses2_20, T0sum(81), M2,[10], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_246, masses2_27, T0sum(82), M2,[63], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_242, masses2_20, T0sum(83), M2,[64], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_238, masses2_20, T0sum(84), M2,[65], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_234, masses2_24, T0sum(85), M2,[17], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_232, masses2_27, T0sum(86), M2,[18], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_206, masses2_16, T0sum(87), M2,[20], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_204, masses2_20, T0sum(88), M2,[21], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_166, masses2_20, T0sum(89), M2,[23], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_260, masses2_27, T0sum(90), M2,[152], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_257, masses2_20, T0sum(91), M2,[153], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_248, masses2_20, T0sum(92), M2,[154], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_221, masses2_24, T0sum(93), M2,[27], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_218, masses2_27, T0sum(94), M2,[28], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_199, masses2_20, T0sum(95), M2,[31], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_155, masses2_20, T0sum(96), M2,[34], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_244, masses2_27, T0sum(97), M2,[49], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_241, masses2_20, T0sum(98), M2,[50], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_236, masses2_20, T0sum(99), M2,[51], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_222, masses2_24, T0sum(100), M2,[41], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_219, masses2_27, T0sum(101), M2,[42], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_200, masses2_20, T0sum(102), M2,[44], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_156, masses2_20, T0sum(103), M2,[46], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_207, masses2_20, T0sum(104), M2,[53], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_180, masses2_20, T0sum(105), M2,[54], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_176, masses2_16, T0sum(106), M2,[57], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_208, masses2_20, T0sum(107), M2,[67], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_184, masses2_20, T0sum(108), M2,[68], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_229, masses2_19, T0sum(109), M2,[77], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_228, masses2_19, T0sum(110), M2,[78], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_197, masses2_26, T0sum(111), M2,[81], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_191, masses2_26, T0sum(112), M2,[82], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_162, masses2_26, T0sum(113), M2,[85], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_243, masses2_19, T0sum(114), M2,[91], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_215, masses2_19, T0sum(115), M2,[92], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_212, masses2_19, T0sum(116), M2,[93], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_195, masses2_26, T0sum(117), M2,[96], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_178, masses2_26, T0sum(118), M2,[97], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_152, masses2_26, T0sum(119), M2,[100], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_245, masses2_19, T0sum(120), M2,[106], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_226, masses2_19, T0sum(121), M2,[107], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_182, masses2_26, T0sum(122), M2,[110], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_214, masses2_19, T0sum(123), M2,[117], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_189, masses2_26, T0sum(124), M2,[120], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_193, masses2_18, T0sum(125), M2,[156], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_187, masses2_18, T0sum(126), M2,[157], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_240, masses2_18, T0sum(127), M2,[159], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_173, masses2_18, T0sum(128), M2,[160], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_192, masses2_18, T0sum(129), M2,[162], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_186, masses2_18, T0sum(130), M2,[163], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_239, masses2_18, T0sum(131), M2,[164], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_172, masses2_18, T0sum(132), M2,[165], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_224, masses2_22, T0sum(133), M2,[174], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_220, masses2_29, T0sum(134), M2,[166], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_201, masses2_21, T0sum(135), M2,[167], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_157, masses2_21, T0sum(136), M2,[168], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_223, masses2_22, T0sum(137), M2,[193], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_216, masses2_29, T0sum(138), M2,[170], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_196, masses2_21, T0sum(139), M2,[171], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_168, masses2_30, T0sum(140), M2,[175], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_164, masses2_26, T0sum(141), M2,[176], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_194, masses2_30, T0sum(142), M2,[180], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_210, masses2_22, T0sum(143), M2,[183], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_154, masses2_26, T0sum(144), M2,[184], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_209, masses2_22, T0sum(145), M2,[187], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_167, masses2_30, T0sum(146), M2,[188], ScalarBoxes(:))
  call TI_call_OL(2,0, momenta_168, masses2_30, T0sum(147), M2,[175], ScalarBoxes(:))
  call TI_call_OL(2,0, momenta_167, masses2_30, T0sum(148), M2,[188], ScalarBoxes(:))
  call TI_call_OL(2,0, momenta_194, masses2_30, T0sum(149), M2,[180], ScalarBoxes(:))
  call TI_call_OL(2,0, momenta_194, masses2_23, T0sum(150), M2)
  call TI_call_OL(2,0, momenta_167, masses2_23, T0sum(151), M2)
  call TI_call_OL(2,0, momenta_168, masses2_23, T0sum(152), M2)
  call TI_call_OL(0,0, momenta_161, masses2_21, T0sum(153), M2,[167], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_194, masses2_23, T0sum(154), M2)
  call TI_call_OL(0,0, momenta_167, masses2_23, T0sum(155), M2)
  call TI_call_OL(0,0, momenta_168, masses2_23, T0sum(156), M2)
  call TI_call_OL(0,0, momenta_112, masses2_10, T0sum(157), M2)
  call TI_call_OL(0,0, momenta_110, masses2_10, T0sum(158), M2)
  call TI_call_OL(0,0, momenta_124, masses2_12, T0sum(159), M2)
  call TI_call_OL(0,0, momenta_130, masses2_12, T0sum(160), M2)
  call TI_call_OL(0,0, momenta_147, masses2_13, T0sum(161), M2)
  call TI_call_OL(0,0, momenta_129, masses2_14, T0sum(162), M2)
  call TI_call_OL(0,0, momenta_146, masses2_13, T0sum(163), M2)
  call TI_call_OL(0,0, momenta_135, masses2_14, T0sum(164), M2)
  call TI_call_OL(0,0, momenta_60, masses2_10, T0sum(165), M2)
  call TI_call_OL(0,0, momenta_29, masses2_9, T0sum(166), M2)
  call TI_call_OL(0,0, momenta_130, masses2_10, T0sum(167), M2)
  call TI_call_OL(0,0, momenta_55, masses2_14, T0sum(168), M2)
  call TI_call_OL(0,0, momenta_42, masses2_9, T0sum(169), M2)
  call TI_call_OL(0,0, momenta_65, masses2_14, T0sum(170), M2)
  call TI_call_OL(0,0, momenta_43, masses2_9, T0sum(171), M2)
  call TI_call_OL(0,0, momenta_30, masses2_9, T0sum(172), M2)
  call TI_call_OL(0,0, momenta_63, masses2_8, T0sum(173), M2)
  call TI_call_OL(0,0, momenta_40, masses2_13, T0sum(174), M2)
  call TI_call_OL(0,0, momenta_30, masses2_13, T0sum(175), M2)
  call TI_call_OL(0,0, momenta_53, masses2_8, T0sum(176), M2)
  call TI_call_OL(0,0, momenta_39, masses2_13, T0sum(177), M2)
  call TI_call_OL(0,0, momenta_29, masses2_13, T0sum(178), M2)
  call TI_call_OL(0,0, momenta_31, masses2_15, T0sum(179), M2)
  call TI_call_OL(0,0, momenta_106, masses2_13, T0sum(180), M2)
  call TI_call_OL(0,0, momenta_38, masses2_15, T0sum(181), M2)
  call TI_call_OL(0,0, momenta_50, masses2_10, T0sum(182), M2)
  call TI_call_OL(0,0, momenta_105, masses2_13, T0sum(183), M2)
  call TI_call_OL(0,0, momenta_53, masses2_14, T0sum(184), M2)
  call TI_call_OL(0,0, momenta_39, masses2_9, T0sum(185), M2)
  call TI_call_OL(0,0, momenta_105, masses2_9, T0sum(186), M2)
  call TI_call_OL(0,0, momenta_106, masses2_9, T0sum(187), M2)
  call TI_call_OL(0,0, momenta_38, masses2_7, T0sum(188), M2)
  call TI_call_OL(0,0, momenta_38, masses2_11, T0sum(189), M2)
  call TI_call_OL(0,0, momenta_31, masses2_11, T0sum(190), M2)
  call TI_call_OL(0,0, momenta_32, masses2_7, T0sum(191), M2)
  call TI_call_OL(0,0, momenta_115, masses2_13, T0sum(192), M2)
  call TI_call_OL(0,0, momenta_114, masses2_13, T0sum(193), M2)
  call TI_call_OL(0,0, momenta_121, masses2_15, T0sum(194), M2)
  call TI_call_OL(0,0, momenta_89, masses2_7, T0sum(195), M2)
  call TI_call_OL(0,0, momenta_135, masses2_8, T0sum(196), M2)
  call TI_call_OL(0,0, momenta_123, masses2_13, T0sum(197), M2)
  call TI_call_OL(0,0, momenta_129, masses2_8, T0sum(198), M2)
  call TI_call_OL(0,0, momenta_122, masses2_13, T0sum(199), M2)
  call TI_call_OL(0,0, momenta_111, masses2_14, T0sum(200), M2)
  call TI_call_OL(0,0, momenta_108, masses2_9, T0sum(201), M2)
  call TI_call_OL(0,0, momenta_113, masses2_14, T0sum(202), M2)
  call TI_call_OL(0,0, momenta_109, masses2_9, T0sum(203), M2)
  call TI_call_OL(0,0, momenta_107, masses2_15, T0sum(204), M2)
  call TI_call_OL(0,0, momenta_124, masses2_10, T0sum(205), M2)
  call TI_call_OL(0,0, momenta_116, masses2_15, T0sum(206), M2)
  call TI_call_OL(0,0, momenta_136, masses2_7, T0sum(207), M2)
  call TI_call_OL(0,0, momenta_137, masses2_7, T0sum(208), M2)
  call TI_call_OL(0,0, momenta_35, masses2_7, T0sum(209), M2)
  call TI_call_OL(0,0, momenta_121, masses2_11, T0sum(210), M2)
  call TI_call_OL(0,0, momenta_116, masses2_11, T0sum(211), M2)
  call TI_call_OL(0,0, momenta_107, masses2_11, T0sum(212), M2)
  call TI_call_OL(0,0, momenta_103, masses2_14, T0sum(213), M2)
  call TI_call_OL(0,0, momenta_93, masses2_9, T0sum(214), M2)
  call TI_call_OL(0,0, momenta_88, masses2_9, T0sum(215), M2)
  call TI_call_OL(0,0, momenta_85, masses2_14, T0sum(216), M2)
  call TI_call_OL(0,0, momenta_77, masses2_9, T0sum(217), M2)
  call TI_call_OL(0,0, momenta_72, masses2_9, T0sum(218), M2)
  call TI_call_OL(0,0, momenta_99, masses2_14, T0sum(219), M2)
  call TI_call_OL(0,0, momenta_92, masses2_9, T0sum(220), M2)
  call TI_call_OL(0,0, momenta_87, masses2_9, T0sum(221), M2)
  call TI_call_OL(0,0, momenta_81, masses2_14, T0sum(222), M2)
  call TI_call_OL(0,0, momenta_76, masses2_9, T0sum(223), M2)
  call TI_call_OL(0,0, momenta_71, masses2_9, T0sum(224), M2)
  call TI_call_OL(0,0, momenta_66, masses2_12, T0sum(225), M2)
  call TI_call_OL(0,0, momenta_44, masses2_7, T0sum(226), M2)
  call TI_call_OL(0,0, momenta_56, masses2_12, T0sum(227), M2)
  call TI_call_OL(0,0, momenta_145, masses2_8, T0sum(228), M2)
  call TI_call_OL(0,0, momenta_90, masses2_9, T0sum(229), M2)
  call TI_call_OL(0,0, momenta_143, masses2_8, T0sum(230), M2)
  call TI_call_OL(0,0, momenta_91, masses2_9, T0sum(231), M2)
  call TI_call_OL(0,0, momenta_73, masses2_7, T0sum(232), M2)
  call TI_call_OL(0,0, momenta_33, masses2_9, T0sum(233), M2)
  call TI_call_OL(0,0, momenta_34, masses2_9, T0sum(234), M2)
  call TI_call_OL(0,0, momenta_138, masses2_12, T0sum(235), M2)
  call TI_call_OL(0,0, momenta_128, masses2_12, T0sum(236), M2)
  call TI_call_OL(0,0, momenta_133, masses2_8, T0sum(237), M2)
  call TI_call_OL(0,0, momenta_120, masses2_13, T0sum(238), M2)
  call TI_call_OL(0,0, momenta_62, masses2_8, T0sum(239), M2)
  call TI_call_OL(0,0, momenta_37, masses2_13, T0sum(240), M2)
  call TI_call_OL(0,0, momenta_144, masses2_12, T0sum(241), M2)
  call TI_call_OL(0,0, momenta_132, masses2_12, T0sum(242), M2)
  call TI_call_OL(0,0, momenta_125, masses2_8, T0sum(243), M2)
  call TI_call_OL(0,0, momenta_117, masses2_13, T0sum(244), M2)
  call TI_call_OL(0,0, momenta_51, masses2_8, T0sum(245), M2)
  call TI_call_OL(0,0, momenta_33, masses2_13, T0sum(246), M2)
  call TI_call_OL(0,0, momenta_142, masses2_12, T0sum(247), M2)
  call TI_call_OL(0,0, momenta_126, masses2_12, T0sum(248), M2)
  call TI_call_OL(0,0, momenta_131, masses2_8, T0sum(249), M2)
  call TI_call_OL(0,0, momenta_118, masses2_13, T0sum(250), M2)
  call TI_call_OL(0,0, momenta_61, masses2_8, T0sum(251), M2)
  call TI_call_OL(0,0, momenta_34, masses2_13, T0sum(252), M2)
  call TI_call_OL(0,0, momenta_140, masses2_12, T0sum(253), M2)
  call TI_call_OL(0,0, momenta_134, masses2_12, T0sum(254), M2)
  call TI_call_OL(0,0, momenta_127, masses2_8, T0sum(255), M2)
  call TI_call_OL(0,0, momenta_119, masses2_13, T0sum(256), M2)
  call TI_call_OL(0,0, momenta_52, masses2_8, T0sum(257), M2)
  call TI_call_OL(0,0, momenta_36, masses2_13, T0sum(258), M2)
  call TI_call_OL(0,0, momenta_102, masses2_10, T0sum(259), M2)
  call TI_call_OL(0,0, momenta_95, masses2_9, T0sum(260), M2)
  call TI_call_OL(0,0, momenta_45, masses2_9, T0sum(261), M2)
  call TI_call_OL(0,0, momenta_101, masses2_8, T0sum(262), M2)
  call TI_call_OL(0,0, momenta_98, masses2_10, T0sum(263), M2)
  call TI_call_OL(0,0, momenta_96, masses2_9, T0sum(264), M2)
  call TI_call_OL(0,0, momenta_46, masses2_9, T0sum(265), M2)
  call TI_call_OL(0,0, momenta_97, masses2_8, T0sum(266), M2)
  call TI_call_OL(0,0, momenta_139, masses2_8, T0sum(267), M2)
  call TI_call_OL(0,0, momenta_79, masses2_8, T0sum(268), M2)
  call TI_call_OL(0,0, momenta_141, masses2_8, T0sum(269), M2)
  call TI_call_OL(0,0, momenta_83, masses2_8, T0sum(270), M2)
  call TI_call_OL(0,0, momenta_104, masses2_12, T0sum(271), M2)
  call TI_call_OL(0,0, momenta_94, masses2_7, T0sum(272), M2)
  call TI_call_OL(0,0, momenta_67, masses2_12, T0sum(273), M2)
  call TI_call_OL(0,0, momenta_47, masses2_7, T0sum(274), M2)
  call TI_call_OL(0,0, momenta_86, masses2_12, T0sum(275), M2)
  call TI_call_OL(0,0, momenta_78, masses2_7, T0sum(276), M2)
  call TI_call_OL(0,0, momenta_68, masses2_12, T0sum(277), M2)
  call TI_call_OL(0,0, momenta_48, masses2_7, T0sum(278), M2)
  call TI_call_OL(0,0, momenta_100, masses2_12, T0sum(279), M2)
  call TI_call_OL(0,0, momenta_57, masses2_12, T0sum(280), M2)
  call TI_call_OL(0,0, momenta_82, masses2_12, T0sum(281), M2)
  call TI_call_OL(0,0, momenta_58, masses2_12, T0sum(282), M2)
  call TI_call_OL(0,0, momenta_64, masses2_10, T0sum(283), M2)
  call TI_call_OL(0,0, momenta_41, masses2_15, T0sum(284), M2)
  call TI_call_OL(0,0, momenta_80, masses2_10, T0sum(285), M2)
  call TI_call_OL(0,0, momenta_54, masses2_10, T0sum(286), M2)
  call TI_call_OL(0,0, momenta_84, masses2_10, T0sum(287), M2)
  call TI_call_OL(0,0, momenta_40, masses2_9, T0sum(288), M2)
  call TI_call_OL(0,0, momenta_75, masses2_9, T0sum(289), M2)
  call TI_call_OL(0,0, momenta_74, masses2_9, T0sum(290), M2)
  call TI_call_OL(0,0, momenta_70, masses2_15, T0sum(291), M2)
  call TI_call_OL(0,0, momenta_66, masses2_10, T0sum(292), M2)
  call TI_call_OL(0,0, momenta_59, masses2_14, T0sum(293), M2)
  call TI_call_OL(0,0, momenta_49, masses2_9, T0sum(294), M2)
  call TI_call_OL(0,0, momenta_69, masses2_15, T0sum(295), M2)
  call TI_call_OL(0,0, momenta_44, masses2_15, T0sum(296), M2)
  call TI_call_OL(0,0, momenta_56, masses2_10, T0sum(297), M2)
  call TI_call_OL(0,0, momenta_63, masses2_14, T0sum(298), M2)
  call TI_call_OL(0,0, momenta_41, masses2_11, T0sum(299), M2)
  call TI_call_OL(0,0, momenta_69, masses2_11, T0sum(300), M2)
  call TI_call_OL(0,0, momenta_70, masses2_11, T0sum(301), M2)
  call TI_call_OL(0,0, momenta_44, masses2_11, T0sum(302), M2)
  call TI_call_OL(0,0, momenta_28, masses2_3, T0sum(303), M2)
  call TI_call_OL(0,0, momenta_15, masses2_6, T0sum(304), M2)
  call TI_call_OL(0,0, momenta_14, masses2_3, T0sum(305), M2)
  call TI_call_OL(0,0, momenta_1, masses2_3, T0sum(306), M2)
  call TI_call_OL(0,0, momenta_27, masses2_3, T0sum(307), M2)
  call TI_call_OL(0,0, momenta_13, masses2_3, T0sum(308), M2)
  call TI_call_OL(0,0, momenta_27, masses2_5, T0sum(309), M2)
  call TI_call_OL(0,0, momenta_19, masses2_1, T0sum(310), M2)
  call TI_call_OL(0,0, momenta_17, masses2_5, T0sum(311), M2)
  call TI_call_OL(0,0, momenta_28, masses2_5, T0sum(312), M2)
  call TI_call_OL(0,0, momenta_18, masses2_5, T0sum(313), M2)
  call TI_call_OL(0,0, momenta_26, masses2_6, T0sum(314), M2)
  call TI_call_OL(0,0, momenta_19, masses2_6, T0sum(315), M2)
  call TI_call_OL(0,0, momenta_5, masses2_6, T0sum(316), M2)
  call TI_call_OL(0,0, momenta_4, masses2_3, T0sum(317), M2)
  call TI_call_OL(0,0, momenta_3, masses2_5, T0sum(318), M2)
  call TI_call_OL(0,0, momenta_2, masses2_1, T0sum(319), M2)
  call TI_call_OL(0,0, momenta_18, masses2_3, T0sum(320), M2)
  call TI_call_OL(0,0, momenta_4, masses2_5, T0sum(321), M2)
  call TI_call_OL(0,0, momenta_2, masses2_6, T0sum(322), M2)
  call TI_call_OL(0,0, momenta_3, masses2_3, T0sum(323), M2)
  call TI_call_OL(0,0, momenta_12, masses2_6, T0sum(324), M2)
  call TI_call_OL(0,0, momenta_13, masses2_5, T0sum(325), M2)
  call TI_call_OL(0,0, momenta_12, masses2_1, T0sum(326), M2)
  call TI_call_OL(0,0, momenta_14, masses2_5, T0sum(327), M2)
  call TI_call_OL(0,0, momenta_19, masses2_4, T0sum(328), M2)
  call TI_call_OL(0,0, momenta_1, masses2_2, T0sum(329), M2)
  call TI_call_OL(0,0, momenta_12, masses2_4, T0sum(330), M2)
  call TI_call_OL(0,0, momenta_2, masses2_4, T0sum(331), M2)
  call TI_call_OL(0,0, momenta_26, masses2_4, T0sum(332), M2)
  call TI_call_OL(0,0, momenta_5, masses2_4, T0sum(333), M2)
  call TI_call_OL(0,0, momenta_25, masses2_1, T0sum(334), M2)
  call TI_call_OL(0,0, momenta_6, masses2_1, T0sum(335), M2)
  call TI_call_OL(0,0, momenta_16, masses2_6, T0sum(336), M2)
  call TI_call_OL(0,0, momenta_17, masses2_3, T0sum(337), M2)
  call TI_call_OL(0,0, momenta_9, masses2_1, T0sum(338), M2)
  call TI_call_OL(0,0, momenta_22, masses2_1, T0sum(339), M2)
  call TI_call_OL(0,0, momenta_16, masses2_4, T0sum(340), M2)
  call TI_call_OL(0,0, momenta_15, masses2_4, T0sum(341), M2)
  call TI_call_OL(0,0, momenta_24, masses2_5, T0sum(342), M2)
  call TI_call_OL(0,0, momenta_11, masses2_5, T0sum(343), M2)
  call TI_call_OL(0,0, momenta_21, masses2_5, T0sum(344), M2)
  call TI_call_OL(0,0, momenta_8, masses2_5, T0sum(345), M2)
  call TI_call_OL(0,0, momenta_23, masses2_5, T0sum(346), M2)
  call TI_call_OL(0,0, momenta_10, masses2_5, T0sum(347), M2)
  call TI_call_OL(0,0, momenta_20, masses2_5, T0sum(348), M2)
  call TI_call_OL(0,0, momenta_7, masses2_5, T0sum(349), M2)
  call TI_call_OL(0,0, momenta_24, masses2_3, T0sum(350), M2)
  call TI_call_OL(0,0, momenta_23, masses2_3, T0sum(351), M2)
  call TI_call_OL(0,0, momenta_11, masses2_3, T0sum(352), M2)
  call TI_call_OL(0,0, momenta_20, masses2_3, T0sum(353), M2)
  call TI_call_OL(0,0, momenta_7, masses2_3, T0sum(354), M2)
  call TI_call_OL(0,0, momenta_21, masses2_3, T0sum(355), M2)
  call TI_call_OL(0,0, momenta_8, masses2_3, T0sum(356), M2)
  call TI_call_OL(0,0, momenta_10, masses2_3, T0sum(357), M2)

  call TI_call_OL(0,1, momenta_359, masses2_44, T1sum(1), M2,sbarray_1, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_360, masses2_44, T1sum(2), M2,sbarray_2, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_355, masses2_44, T1sum(3), M2,sbarray_3, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_356, masses2_44, T1sum(4), M2,sbarray_4, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_361, masses2_43, T1sum(5), M2,sbarray_5, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_362, masses2_43, T1sum(6), M2,sbarray_6, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_358, masses2_45, T1sum(7), M2,sbarray_7, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_353, masses2_45, T1sum(8), M2,sbarray_8, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_357, masses2_45, T1sum(9), M2,sbarray_9, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_354, masses2_45, T1sum(10), M2,sbarray_10, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_347, masses2_34, T1sum(11), M2,sbarray_11, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_348, masses2_34, T1sum(12), M2,sbarray_12, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_352, masses2_38, T1sum(13), M2,sbarray_13, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_349, masses2_38, T1sum(14), M2,sbarray_14, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_351, masses2_38, T1sum(15), M2,sbarray_15, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_350, masses2_38, T1sum(16), M2,sbarray_16, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_346, masses2_36, T1sum(17), M2,sbarray_17, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_341, masses2_41, T1sum(18), M2,sbarray_18, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_333, masses2_35, T1sum(19), M2,sbarray_19, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_313, masses2_35, T1sum(20), M2,sbarray_20, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_311, masses2_36, T1sum(21), M2,sbarray_21, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_344, masses2_36, T1sum(22), M2,sbarray_22, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_342, masses2_41, T1sum(23), M2,sbarray_23, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_334, masses2_35, T1sum(24), M2,sbarray_24, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_314, masses2_35, T1sum(25), M2,sbarray_25, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_312, masses2_36, T1sum(26), M2,sbarray_26, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_345, masses2_36, T1sum(27), M2,sbarray_27, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_337, masses2_41, T1sum(28), M2,sbarray_28, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_331, masses2_35, T1sum(29), M2,sbarray_29, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_301, masses2_35, T1sum(30), M2,sbarray_30, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_298, masses2_36, T1sum(31), M2,sbarray_31, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_343, masses2_36, T1sum(32), M2,sbarray_32, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_338, masses2_41, T1sum(33), M2,sbarray_33, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_332, masses2_35, T1sum(34), M2,sbarray_34, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_302, masses2_35, T1sum(35), M2,sbarray_35, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_299, masses2_36, T1sum(36), M2,sbarray_36, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_322, masses2_36, T1sum(37), M2,sbarray_37, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_319, masses2_33, T1sum(38), M2,sbarray_38, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_315, masses2_33, T1sum(39), M2,sbarray_39, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_324, masses2_36, T1sum(40), M2,sbarray_40, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_320, masses2_33, T1sum(41), M2,sbarray_41, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_316, masses2_33, T1sum(42), M2,sbarray_42, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_340, masses2_32, T1sum(43), M2,sbarray_43, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_328, masses2_39, T1sum(44), M2,sbarray_44, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_309, masses2_39, T1sum(45), M2,sbarray_45, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_308, masses2_39, T1sum(46), M2,sbarray_46, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_335, masses2_32, T1sum(47), M2,sbarray_47, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_321, masses2_39, T1sum(48), M2,sbarray_48, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_295, masses2_39, T1sum(49), M2,sbarray_49, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_292, masses2_39, T1sum(50), M2,sbarray_50, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_339, masses2_32, T1sum(51), M2,sbarray_51, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_323, masses2_39, T1sum(52), M2,sbarray_52, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_306, masses2_39, T1sum(53), M2,sbarray_53, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_336, masses2_32, T1sum(54), M2,sbarray_54, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_327, masses2_39, T1sum(55), M2,sbarray_55, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_294, masses2_39, T1sum(56), M2,sbarray_56, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_326, masses2_31, T1sum(57), M2,sbarray_57, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_318, masses2_31, T1sum(58), M2,sbarray_58, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_325, masses2_31, T1sum(59), M2,sbarray_59, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_317, masses2_31, T1sum(60), M2,sbarray_60, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_300, masses2_37, T1sum(61), M2,sbarray_61, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_296, masses2_37, T1sum(62), M2,sbarray_62, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_305, masses2_38, T1sum(63), M2,sbarray_63, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_307, masses2_38, T1sum(64), M2,sbarray_64, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_291, masses2_38, T1sum(65), M2,sbarray_65, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_293, masses2_38, T1sum(66), M2,sbarray_66, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_297, masses2_36, T1sum(67), M2,sbarray_67, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_310, masses2_36, T1sum(68), M2,sbarray_68, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_304, masses2_40, T1sum(69), M2,sbarray_69, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_330, masses2_42, T1sum(70), M2,sbarray_70, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_290, masses2_40, T1sum(71), M2,sbarray_71, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_289, masses2_40, T1sum(72), M2,sbarray_72, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_329, masses2_42, T1sum(73), M2,sbarray_73, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_303, masses2_40, T1sum(74), M2,sbarray_74, ScalarBoxes(:))
  call TI_call_OL(1,1, momenta_107, masses2_15, T1sum(75), M2)
  call TI_call_OL(1,1, momenta_70, masses2_15, T1sum(76), M2)
  call TI_call_OL(1,1, momenta_44, masses2_15, T1sum(77), M2)
  call TI_call_OL(1,1, momenta_31, masses2_15, T1sum(78), M2)
  call TI_call_OL(1,1, momenta_116, masses2_15, T1sum(79), M2)
  call TI_call_OL(1,1, momenta_69, masses2_15, T1sum(80), M2)
  call TI_call_OL(1,1, momenta_41, masses2_15, T1sum(81), M2)
  call TI_call_OL(1,1, momenta_121, masses2_15, T1sum(82), M2)
  call TI_call_OL(1,1, momenta_38, masses2_15, T1sum(83), M2)
  call TI_call_OL(1,1, momenta_121, masses2_11, T1sum(84), M2)
  call TI_call_OL(1,1, momenta_107, masses2_11, T1sum(85), M2)
  call TI_call_OL(1,1, momenta_41, masses2_11, T1sum(86), M2)
  call TI_call_OL(1,1, momenta_38, masses2_11, T1sum(87), M2)
  call TI_call_OL(1,1, momenta_116, masses2_11, T1sum(88), M2)
  call TI_call_OL(1,1, momenta_69, masses2_11, T1sum(89), M2)
  call TI_call_OL(1,1, momenta_31, masses2_11, T1sum(90), M2)
  call TI_call_OL(1,1, momenta_70, masses2_11, T1sum(91), M2)
  call TI_call_OL(1,1, momenta_44, masses2_11, T1sum(92), M2)

  call add_met(M2,M2L1R1)

#ifdef LOOPSQUARED
  end if
#endif

  call met_to_real(M2out,M2)

#ifdef PRECISION_dp
  call HOL_memory_deallocation_/**/REALKIND(1)
  call HCL_memory_deallocation_/**/REALKIND(1)
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_pphttj_ttxddxhg_1_/**/REALKIND
