
module ol_colourmatrix_pphttj_ttxhggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(138,6), K2(6,11), KL(6,11), Cas(6) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1(  1,:) = [  384,  -48,  -48,    6,    6,   60]
  K1(  2,:) = [  -48,  384,    6,   60,  -48,    6]
  K1(  3,:) = [  -48,    6,  384,  -48,   60,    6]
  K1(  4,:) = [    6,   60,  -48,  384,    6,  -48]
  K1(  5,:) = [    6,  -48,   60,    6,  384,  -48]
  K1(  6,:) = [   60,    6,    6,  -48,  -48,  384]
  K1(  7,:) = [  512,  -64,  -64,    8,    8,   80]
  K1(  8,:) = [  -64,  512,    8,   80,  -64,    8]
  K1(  9,:) = [  -64,    8,  512,  -64,   80,    8]
  K1( 10,:) = [    8,   80,  -64,  512,    8,  -64]
  K1( 11,:) = [    8,  -64,   80,    8,  512,  -64]
  K1( 12,:) = [   80,    8,    8,  -64,  -64,  512]
  K1( 13,:) = [    1,   10,   10,  -62,  -62,   28]
  K1( 14,:) = [   10,    1,  -62,   28,   10,  -62]
  K1( 15,:) = [   10,  -62,    1,   10,   28,  -62]
  K1( 16,:) = [  -62,   28,   10,    1,  -62,   10]
  K1( 17,:) = [  -62,   10,   28,  -62,    1,   10]
  K1( 18,:) = [   28,  -62,  -62,   10,   10,    1]
  K1( 19,:) = [  512,  -64,  -64,    8,    8,   80]
  K1( 20,:) = [  -64,  512,    8,   80,  -64,    8]
  K1( 21,:) = [  -64,    8,  512,  -64,   80,    8]
  K1( 22,:) = [    8,   80,  -64,  512,    8,  -64]
  K1( 23,:) = [    8,  -64,   80,    8,  512,  -64]
  K1( 24,:) = [   80,    8,    8,  -64,  -64,  512]
  K1( 25,:) = [    0,    0,    0,    0,    0,    0]
  K1( 26,:) = [    0,    0,    0,    0,    0,    0]
  K1( 27,:) = [    0,    0,    0,    0,    0,    0]
  K1( 28,:) = [    0,    0,    0,    0,    0,    0]
  K1( 29,:) = [    0,    0,    0,    0,    0,    0]
  K1( 30,:) = [    0,    0,    0,    0,    0,    0]
  K1( 31,:) = [    0,    0,    0,    0,    0,    0]
  K1( 32,:) = [    0,    0,    0,    0,    0,    0]
  K1( 33,:) = [    0,    0,    0,    0,    0,    0]
  K1( 34,:) = [    0,    0,    0,    0,    0,    0]
  K1( 35,:) = [    0,    0,    0,    0,    0,    0]
  K1( 36,:) = [    0,    0,    0,    0,    0,    0]
  K1( 37,:) = [    0,    0,    0,    0,    0,    0]
  K1( 38,:) = [    0,    0,    0,    0,    0,    0]
  K1( 39,:) = [    0,    0,    0,    0,    0,    0]
  K1( 40,:) = [    0,    0,    0,    0,    0,    0]
  K1( 41,:) = [    0,    0,    0,    0,    0,    0]
  K1( 42,:) = [    0,    0,    0,    0,    0,    0]
  K1( 43,:) = [   -9,  -90,   -9,   -9,   72,  -90]
  K1( 44,:) = [  -90,   -9,   72,  -90,   -9,   -9]
  K1( 45,:) = [   -9,   72,   72,   72,   72,   -9]
  K1( 46,:) = [   -9,  -90,   72, -576,   -9,   72]
  K1( 47,:) = [   72,   -9,   72,   -9,   72,   72]
  K1( 48,:) = [  -90,   -9,   -9,   72,   72, -576]
  K1( 49,:) = [ -576,   72,   72,   -9,   -9,  -90]
  K1( 50,:) = [   72, -576,   -9,  -90,   72,   -9]
  K1( 51,:) = [   72,   -9,   72,   -9,   72,   72]
  K1( 52,:) = [   -9,  -90,   -9,   -9,   72,  -90]
  K1( 53,:) = [   -9,   72,   72,   72,   72,   -9]
  K1( 54,:) = [  -90,   -9,   72,  -90,   -9,   -9]
  K1( 55,:) = [    0,    0,    0,    0,    0,    0]
  K1( 56,:) = [    0,    0,    0,    0,    0,    0]
  K1( 57,:) = [    0,    0,    0,    0,    0,    0]
  K1( 58,:) = [    0,    0,    0,    0,    0,    0]
  K1( 59,:) = [    0,    0,    0,    0,    0,    0]
  K1( 60,:) = [    0,    0,    0,    0,    0,    0]
  K1( 61,:) = [ 1152, -144, -144,   18,   18,  180]
  K1( 62,:) = [ -144, 1152,   18,  180, -144,   18]
  K1( 63,:) = [ -144,   18, 1152, -144,  180,   18]
  K1( 64,:) = [   18,  180, -144, 1152,   18, -144]
  K1( 65,:) = [   18, -144,  180,   18, 1152, -144]
  K1( 66,:) = [  180,   18,   18, -144, -144, 1152]
  K1( 67,:) = [   72,   72,   -9,   72,   -9,   72]
  K1( 68,:) = [   72, -576,   -9,  -90,   72,   -9]
  K1( 69,:) = [   -9,   -9,   -9,  -90,  -90,   72]
  K1( 70,:) = [   72,  -90,  -90,   -9,   -9,   -9]
  K1( 71,:) = [   -9,   72,  -90,   -9, -576,   72]
  K1( 72,:) = [   72,   -9,   72,   -9,   72,   72]
  K1( 73,:) = [   72,   -9,   72,   -9,   72,   72]
  K1( 74,:) = [   -9,   -9,   -9,  -90,  -90,   72]
  K1( 75,:) = [   72,   -9, -576,   72,  -90,   -9]
  K1( 76,:) = [   -9,  -90,   72, -576,   -9,   72]
  K1( 77,:) = [   72,  -90,  -90,   -9,   -9,   -9]
  K1( 78,:) = [   72,   72,   -9,   72,   -9,   72]
  K1( 79,:) = [    0,    0,    0,    0,    0,    0]
  K1( 80,:) = [    0,    0,    0,    0,    0,    0]
  K1( 81,:) = [    0,    0,    0,    0,    0,    0]
  K1( 82,:) = [    0,    0,    0,    0,    0,    0]
  K1( 83,:) = [    0,    0,    0,    0,    0,    0]
  K1( 84,:) = [    0,    0,    0,    0,    0,    0]
  K1( 85,:) = [ -648,   81,    0,    0,  -81, -162]
  K1( 86,:) = [   81,   81,    0,  162,   81,    0]
  K1( 87,:) = [    0,    0, -648,   81, -162,  -81]
  K1( 88,:) = [    0,  162,   81,   81,    0,   81]
  K1( 89,:) = [  -81,   81, -162,    0, -648,    0]
  K1( 90,:) = [ -162,    0,  -81,   81,    0, -648]
  K1( 91,:) = [ 1152, -144, -144,   18,   18,  180]
  K1( 92,:) = [ -144, 1152,   18,  180, -144,   18]
  K1( 93,:) = [ -144,   18, 1152, -144,  180,   18]
  K1( 94,:) = [   18,  180, -144, 1152,   18, -144]
  K1( 95,:) = [   18, -144,  180,   18, 1152, -144]
  K1( 96,:) = [  180,   18,   18, -144, -144, 1152]
  K1( 97,:) = [ -576,   72,   72,   -9,   -9,  -90]
  K1( 98,:) = [   72,   72,   -9,   72,   -9,   72]
  K1( 99,:) = [   72,   -9, -576,   72,  -90,   -9]
  K1(100,:) = [   -9,   72,   72,   72,   72,   -9]
  K1(101,:) = [   -9,   -9,  -90,   72,   -9,  -90]
  K1(102,:) = [  -90,   72,   -9,   -9,  -90,   -9]
  K1(103,:) = [   -9,   -9,  -90,   72,   -9,  -90]
  K1(104,:) = [   -9,   72,   72,   72,   72,   -9]
  K1(105,:) = [  -90,   72,   -9,   -9,  -90,   -9]
  K1(106,:) = [   72,   72,   -9,   72,   -9,   72]
  K1(107,:) = [   -9,   72,  -90,   -9, -576,   72]
  K1(108,:) = [  -90,   -9,   -9,   72,   72, -576]
  K1(109,:) = [    0,    0,    0,    0,    0,    0]
  K1(110,:) = [    0,    0,    0,    0,    0,    0]
  K1(111,:) = [    0,    0,    0,    0,    0,    0]
  K1(112,:) = [    0,    0,    0,    0,    0,    0]
  K1(113,:) = [    0,    0,    0,    0,    0,    0]
  K1(114,:) = [    0,    0,    0,    0,    0,    0]
  K1(115,:) = [   81,   81,   81,    0,    0,  162]
  K1(116,:) = [   81, -648,  -81, -162,    0,    0]
  K1(117,:) = [   81,  -81, -648,    0, -162,    0]
  K1(118,:) = [    0, -162,    0, -648,  -81,   81]
  K1(119,:) = [    0,    0, -162,  -81, -648,   81]
  K1(120,:) = [  162,    0,    0,   81,   81,   81]
  K1(121,:) = [ -648,    0,   81,  -81,    0, -162]
  K1(122,:) = [    0, -648,    0, -162,   81,  -81]
  K1(123,:) = [   81,    0,   81,   81,  162,    0]
  K1(124,:) = [  -81, -162,   81, -648,    0,    0]
  K1(125,:) = [    0,   81,  162,    0,   81,   81]
  K1(126,:) = [ -162,  -81,    0,    0,   81, -648]
  K1(127,:) = [ 1152, -144, -144,   18,   18,  180]
  K1(128,:) = [ -144, 1152,   18,  180, -144,   18]
  K1(129,:) = [ -144,   18, 1152, -144,  180,   18]
  K1(130,:) = [   18,  180, -144, 1152,   18, -144]
  K1(131,:) = [   18, -144,  180,   18, 1152, -144]
  K1(132,:) = [  180,   18,   18, -144, -144, 1152]
  K1(133,:) = [    0,    0,    0,    0,    0,    0]
  K1(134,:) = [    0,    0,    0,    0,    0,    0]
  K1(135,:) = [    0,    0,    0,    0,    0,    0]
  K1(136,:) = [    0,    0,    0,    0,    0,    0]
  K1(137,:) = [    0,    0,    0,    0,    0,    0]
  K1(138,:) = [    0,    0,    0,    0,    0,    0]
  K1 = (1._/**/REALKIND / 54) * K1

  K2(1,:) = [ 64, -8, -8,  1,  1, 10, 24, -3, 24, 21, -6]
  K2(2,:) = [ -8, 64,  1, 10, -8,  1, -3, 24, 24, -6, 21]
  K2(3,:) = [ -8,  1, 64, -8, 10,  1, 24, 24, -3, -6, 21]
  K2(4,:) = [  1, 10, -8, 64,  1, -8, -3, 24, 24, 21, -6]
  K2(5,:) = [  1, -8, 10,  1, 64, -8, 24, 24, -3, 21, -6]
  K2(6,:) = [ 10,  1,  1, -8, -8, 64, 24, -3, 24, -6, 21]
  K2 = (1._/**/REALKIND / 9) * K2

  KL(1,:) = [ 64, -8, -8,  1,  1, 10, 24, -3, 24, 21, -6]
  KL(2,:) = [ -8, 64,  1, 10, -8,  1, -3, 24, 24, -6, 21]
  KL(3,:) = [ -8,  1, 64, -8, 10,  1, 24, 24, -3, -6, 21]
  KL(4,:) = [  1, 10, -8, 64,  1, -8, -3, 24, 24, 21, -6]
  KL(5,:) = [  1, -8, 10,  1, 64, -8, 24, 24, -3, 21, -6]
  KL(6,:) = [ 10,  1,  1, -8, -8, 64, 24, -3, 24, -6, 21]
  KL = (1._/**/REALKIND / 9) * KL

#if -1 > 0
    co = 0
    do k = 1, 6
      co = co + k
      Cas(k) = K1(1+6*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_pphttj_ttxhggg_1_/**/REALKIND



module ol_forced_parameters_pphttj_ttxhggg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (YU /= 0) write(*,101) 'YU = 0'
  if (YD /= 0) write(*,101) 'YD = 0'
  if (YS /= 0) write(*,101) 'YS = 0'
  if (YC /= 0) write(*,101) 'YC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pphttj_ttxhggg_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_pphttj_ttxhggg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 32 ! number of helicity configurations
  integer(intkind2), save :: nhel = 32 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(32) ! physical helicity states
#endif

  complex(REALKIND), save :: den(682)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(1), ex4(2), ex5(2), ex6(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf2(2,15), wf4(4,158), wf8(8,285), wf16(16,126), wf32(32,564)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(26), c(29)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(11,32), M0M1_hel_cc(11,32,22)
  complex(REALKIND), save :: M2ctcc(22)

end module ol_loop_storage_pphttj_ttxhggg_1_/**/REALKIND






! **********************************************************************
module ol_loop_pphttj_ttxhggg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_pphttj_ttxhggg_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*countertermnorm*ctHGG*eQED*gQCD**5*MB*YB)/MQ2sum
    f( 2) = (countertermnorm*ctHGG*eQED*gQCD**5*MB*YB)/MQ2sum
    f( 3) = (CI*eQED*gQCD**5*integralnorm*SwF*YB)/(2._/**/REALKIND*MW*sw)
    f( 4) = (eQED*gQCD**5*integralnorm*SwF*YB)/(MW*sw*2._/**/REALKIND)
    f( 5) = (CI*countertermnorm*ctHGG*eQED*gQCD**5*MT*YT)/MQ2sum
    f( 6) = (countertermnorm*ctHGG*eQED*gQCD**5*MT*YT)/MQ2sum
    f( 7) = (CI*eQED*gQCD**3*YT)/(2._/**/REALKIND*MW*sw)
    f( 8) = (eQED*gQCD**3*YT)/(MW*sw*2._/**/REALKIND)
    f( 9) = (CI*countertermnorm*eQED*gQCD**5*YT)/(2._/**/REALKIND*MW*sw)
    f(10) = (countertermnorm*eQED*gQCD**5*YT)/(MW*sw*2._/**/REALKIND)
    f(11) = (CI*countertermnorm*ctGtt*eQED*gQCD**5*YT)/(2._/**/REALKIND*MW*sw)
    f(12) = (countertermnorm*ctGtt*eQED*gQCD**5*YT)/(MW*sw*2._/**/REALKIND)
    f(13) = (CI*countertermnorm*ctStt*eQED*gQCD**5*YT)/(2._/**/REALKIND*MW*sw)
    f(14) = (countertermnorm*ctStt*eQED*gQCD**5*YT)/(MW*sw*2._/**/REALKIND)
    f(15) = (CI*countertermnorm*ctVVV*eQED*gQCD**5*YT)/(2._/**/REALKIND*MW*sw)
    f(16) = (countertermnorm*ctVVV*eQED*gQCD**5*YT)/(MW*sw*2._/**/REALKIND)
    f(17) = (CI*countertermnorm*ctVVVV*eQED*gQCD**5*YT)/(2._/**/REALKIND*MW*sw)
    f(18) = (CI*countertermnorm*eQED*gQCD**5*R2GGGG*YT)/(2._/**/REALKIND*MW*sw)
    f(19) = (CI*eQED*gQCD**5*integralnorm*SwB*YT)/(4._/**/REALKIND*MW*sw)
    f(20) = (CI*eQED*gQCD**5*integralnorm*SwB*YT)/(2._/**/REALKIND*MW*sw)
    f(21) = (eQED*gQCD**5*integralnorm*SwB*YT)/(MW*sw*4._/**/REALKIND)
    f(22) = (eQED*gQCD**5*integralnorm*SwB*YT)/(MW*sw*2._/**/REALKIND)
    f(23) = (CI*eQED*gQCD**5*integralnorm*SwF*YT)/(2._/**/REALKIND*MW*sw)
    f(24) = (CI*eQED*gQCD**5*integralnorm*SwF*YT)/(MW*sw)
    f(25) = (eQED*gQCD**5*integralnorm*SwF*YT)/(MW*sw*2._/**/REALKIND)
    f(26) = (eQED*gQCD**5*integralnorm*SwF*YT)/(MW*sw)

  c = [ CI*f(3), 3*CI*f(3), f(4), 3*f(4), 9*CI*f(19), 18*CI*f(19), CI*f(20), 3*CI*f(20), 8*CI*f(20), 9*CI*f(20), 18*CI*f(20) &
    , 3*f(21), 6*f(21), 9*f(21), 18*f(21), f(22), 3*f(22), 6*f(22), 8*f(22), 9*f(22), 18*f(22), CI*f(23), 3*CI*f(23), CI*f(24) &
    , 3*CI*f(24), f(25), 3*f(25), f(26), 3*f(26) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,5) - MT2)+L(6,5))
  den(2) = 1 /((L(5,56))+L(6,56))
  den(4) = 1 /((L(5,6) - MT2)+L(6,6))
  den(6) = 1 /((L(5,10) - MT2)+L(6,10))
  den(7) = 1 /((L(5,48))+L(6,48))
  den(10) = 1 /((L(5,21) - MT2)+L(6,21))
  den(13) = 1 /((L(5,26) - MT2)+L(6,26))
  den(16) = 1 /((L(5,18) - MT2)+L(6,18))
  den(17) = 1 /((L(5,40))+L(6,40))
  den(20) = 1 /((L(5,13) - MT2)+L(6,13))
  den(25) = 1 /((L(5,34) - MT2)+L(6,34))
  den(26) = 1 /((L(5,24))+L(6,24))
  den(29) = 1 /((L(5,7))+L(6,7))
  den(35) = 1 /((L(5,42) - MT2)+L(6,42))
  den(42) = 1 /((L(5,50) - MT2)+L(6,50))
  den(45) = 1 /((L(5,9) - MT2)+L(6,9))
  den(48) = 1 /((L(5,25) - MT2)+L(6,25))
  den(51) = 1 /((L(5,22) - MT2)+L(6,22))
  den(54) = 1 /((L(5,17) - MT2)+L(6,17))
  den(59) = 1 /((L(5,14) - MT2)+L(6,14))
  den(62) = 1 /((L(5,33) - MT2)+L(6,33))
  den(69) = 1 /((L(5,41) - MT2)+L(6,41))
  den(77) = 1 /((L(5,49) - MT2)+L(6,49))
  den(85) = 1 /((L(5,38) - MT2)+L(6,38))
  den(93) = 1 /((L(5,37) - MT2)+L(6,37))
  den(106) = 1 /((L(5,3))+L(6,3))
  den(108) = 1 /((L(5,36))+L(6,36))
  den(110) = 1 /((L(5,20))+L(6,20))
  den(112) = 1 /((L(5,12))+L(6,12))
  den(114) = 1 /((L(5,35))+L(6,35))
  den(120) = 1 /((L(5,19))+L(6,19))
  den(125) = 1 /((L(5,11))+L(6,11))
  den(131) = 1 /((L(5,44))+L(6,44))
  den(136) = 1 /((L(5,28))+L(6,28))
  den(147) = 1 /((L(5,58) - MT2)+L(6,58))
  den(161) = 1 /((L(5,57) - MT2)+L(6,57))
  den(265) = 1 /((L(5,53) - MT2)+L(6,53))
  den(268) = 1 /((L(5,15))+L(6,15))
  den(283) = 1 /((L(5,45) - MT2)+L(6,45))
  den(286) = 1 /((L(5,23))+L(6,23))
  den(300) = 1 /((L(5,29) - MT2)+L(6,29))
  den(303) = 1 /((L(5,39))+L(6,39))
  den(335) = 1 /((L(5,54) - MT2)+L(6,54))
  den(352) = 1 /((L(5,46) - MT2)+L(6,46))
  den(368) = 1 /((L(5,30) - MT2)+L(6,30))
  den(455) = 1 /((L(5,51))+L(6,51))
  den(457) = 1 /((L(5,43))+L(6,43))
  den(459) = 1 /((L(5,27))+L(6,27))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(2)*den(4)
  den(8) = den(1)*den(6)
  den(9) = den(7)*den(8)
  den(11) = den(1)*den(10)
  den(12) = den(6)*den(11)
  den(14) = den(6)*den(13)
  den(15) = den(1)*den(14)
  den(18) = den(1)*den(16)
  den(19) = den(17)*den(18)
  den(21) = den(1)*den(20)
  den(22) = den(16)*den(21)
  den(23) = den(13)*den(16)
  den(24) = den(1)*den(23)
  den(27) = den(1)*den(25)
  den(28) = den(26)*den(27)
  den(30) = den(1)*den(29)
  den(31) = den(26)*den(30)
  den(32) = den(13)*den(26)
  den(33) = den(1)*den(32)
  den(34) = den(21)*den(25)
  den(36) = den(25)*den(35)
  den(37) = den(1)*den(36)
  den(38) = den(17)*den(30)
  den(39) = den(17)*den(35)
  den(40) = den(1)*den(39)
  den(41) = den(7)*den(30)
  den(43) = den(7)*den(42)
  den(44) = den(1)*den(43)
  den(46) = den(4)*den(45)
  den(47) = den(7)*den(46)
  den(49) = den(45)*den(48)
  den(50) = den(4)*den(49)
  den(52) = den(4)*den(51)
  den(53) = den(45)*den(52)
  den(55) = den(4)*den(54)
  den(56) = den(17)*den(55)
  den(57) = den(48)*den(54)
  den(58) = den(4)*den(57)
  den(60) = den(4)*den(59)
  den(61) = den(54)*den(60)
  den(63) = den(4)*den(62)
  den(64) = den(26)*den(63)
  den(65) = den(4)*den(29)
  den(66) = den(26)*den(65)
  den(67) = den(26)*den(48)
  den(68) = den(4)*den(67)
  den(70) = den(62)*den(69)
  den(71) = den(4)*den(70)
  den(72) = den(60)*den(62)
  den(73) = den(17)*den(65)
  den(74) = den(17)*den(69)
  den(75) = den(4)*den(74)
  den(76) = den(7)*den(65)
  den(78) = den(7)*den(77)
  den(79) = den(4)*den(78)
  den(80) = den(20)*den(45)
  den(81) = den(16)*den(80)
  den(82) = den(16)*den(51)
  den(83) = den(45)*den(82)
  den(84) = den(25)*den(80)
  den(86) = den(25)*den(85)
  den(87) = den(45)*den(86)
  den(88) = den(43)*den(45)
  den(89) = den(10)*den(54)
  den(90) = den(6)*den(89)
  den(91) = den(6)*den(59)
  den(92) = den(54)*den(91)
  den(94) = den(62)*den(93)
  den(95) = den(6)*den(94)
  den(96) = den(62)*den(91)
  den(97) = den(6)*den(78)
  den(98) = den(25)*den(89)
  den(99) = den(54)*den(86)
  den(100) = den(39)*den(54)
  den(101) = den(16)*den(94)
  den(102) = den(62)*den(82)
  den(103) = den(16)*den(74)
  den(104) = den(32)*den(62)
  den(105) = den(25)*den(67)
  den(107) = den(2)*den(106)
  den(109) = den(106)*den(108)
  den(111) = den(106)*den(110)
  den(113) = den(106)*den(112)
  den(115) = den(106)*den(114)
  den(116) = den(26)*den(115)
  den(117) = den(2)*den(26)
  den(118) = den(106)*den(117)
  den(119) = den(26)*den(109)
  den(121) = den(106)*den(120)
  den(122) = den(17)*den(121)
  den(123) = den(2)*den(17)
  den(124) = den(106)*den(123)
  den(126) = den(106)*den(125)
  den(127) = den(7)*den(126)
  den(128) = den(2)*den(7)
  den(129) = den(106)*den(128)
  den(130) = den(108)*den(126)
  den(132) = den(108)*den(131)
  den(133) = den(106)*den(132)
  den(134) = den(17)*den(111)
  den(135) = den(110)*den(126)
  den(137) = den(110)*den(136)
  den(138) = den(106)*den(137)
  den(139) = den(7)*den(113)
  den(140) = den(112)*den(121)
  den(141) = den(112)*den(136)
  den(142) = den(106)*den(141)
  den(143) = den(1)*den(93)
  den(144) = den(6)*den(143)
  den(145) = den(6)*den(35)
  den(146) = den(1)*den(145)
  den(148) = den(2)*den(147)
  den(149) = den(1)*den(148)
  den(150) = den(2)*den(30)
  den(151) = den(16)*den(143)
  den(152) = den(16)*den(42)
  den(153) = den(1)*den(152)
  den(154) = den(11)*den(25)
  den(155) = den(25)*den(42)
  den(156) = den(1)*den(155)
  den(157) = den(45)*den(69)
  den(158) = den(4)*den(157)
  den(159) = den(4)*den(85)
  den(160) = den(45)*den(159)
  den(162) = den(2)*den(161)
  den(163) = den(4)*den(162)
  den(164) = den(2)*den(65)
  den(165) = den(54)*den(77)
  den(166) = den(4)*den(165)
  den(167) = den(54)*den(159)
  den(168) = den(62)*den(77)
  den(169) = den(4)*den(168)
  den(170) = den(52)*den(62)
  den(171) = den(16)*den(157)
  den(172) = den(45)*den(152)
  den(173) = den(16)*den(45)
  den(174) = den(108)*den(173)
  den(175) = den(25)*den(49)
  den(176) = den(45)*den(155)
  den(177) = den(45)*den(125)
  den(178) = den(7)*den(177)
  den(179) = den(108)*den(177)
  den(180) = den(85)*den(108)
  den(181) = den(45)*den(180)
  den(182) = den(25)*den(45)
  den(183) = den(110)*den(182)
  den(184) = den(110)*den(177)
  den(185) = den(51)*den(110)
  den(186) = den(45)*den(185)
  den(187) = den(6)*den(165)
  den(188) = den(54)*den(145)
  den(189) = den(6)*den(54)
  den(190) = den(108)*den(189)
  den(191) = den(6)*den(168)
  den(192) = den(14)*den(62)
  den(193) = den(6)*den(125)
  den(194) = den(7)*den(193)
  den(195) = den(108)*den(193)
  den(196) = den(93)*den(108)
  den(197) = den(6)*den(196)
  den(198) = den(6)*den(62)
  den(199) = den(110)*den(198)
  den(200) = den(110)*den(193)
  den(201) = den(10)*den(110)
  den(202) = den(6)*den(201)
  den(203) = den(25)*den(57)
  den(204) = den(36)*den(54)
  den(205) = den(54)*den(120)
  den(206) = den(17)*den(205)
  den(207) = den(108)*den(205)
  den(208) = den(54)*den(180)
  den(209) = den(16)*den(70)
  den(210) = den(23)*den(62)
  den(211) = den(16)*den(120)
  den(212) = den(17)*den(211)
  den(213) = den(108)*den(211)
  den(214) = den(16)*den(196)
  den(215) = den(62)*den(114)
  den(216) = den(26)*den(215)
  den(217) = den(25)*den(114)
  den(218) = den(26)*den(217)
  den(219) = den(67)*den(108)
  den(220) = den(26)*den(196)
  den(221) = den(110)*den(215)
  den(222) = den(62)*den(185)
  den(223) = den(110)*den(217)
  den(224) = den(25)*den(201)
  den(225) = den(74)*den(110)
  den(226) = den(17)*den(201)
  den(227) = den(25)*den(54)
  den(228) = den(112)*den(227)
  den(229) = den(112)*den(205)
  den(230) = den(59)*den(112)
  den(231) = den(54)*den(230)
  den(232) = den(16)*den(62)
  den(233) = den(112)*den(232)
  den(234) = den(112)*den(211)
  den(235) = den(20)*den(112)
  den(236) = den(16)*den(235)
  den(237) = den(112)*den(215)
  den(238) = den(62)*den(230)
  den(239) = den(112)*den(217)
  den(240) = den(25)*den(235)
  den(241) = den(78)*den(112)
  den(242) = den(7)*den(235)
  den(243) = den(26)*den(143)
  den(244) = den(1)*den(117)
  den(245) = den(11)*den(17)
  den(246) = den(1)*den(123)
  den(247) = den(7)*den(21)
  den(248) = den(1)*den(128)
  den(249) = den(7)*den(80)
  den(250) = den(17)*den(89)
  den(251) = den(26)*den(94)
  den(252) = den(4)*den(117)
  den(253) = den(26)*den(159)
  den(254) = den(4)*den(123)
  den(255) = den(17)*den(52)
  den(256) = den(4)*den(128)
  den(257) = den(7)*den(60)
  den(258) = den(7)*den(91)
  den(259) = den(17)*den(82)
  den(260) = den(26)*den(86)
  den(261) = den(6)*den(7)
  den(262) = den(147)*den(261)
  den(263) = den(1)*den(262)
  den(264) = den(1)*den(7)
  den(266) = den(264)*den(265)
  den(267) = den(6)*den(266)
  den(269) = den(8)*den(268)
  den(270) = den(7)*den(269)
  den(271) = den(1)**2
  den(272) = den(145)*den(271)
  den(273) = den(14)*den(271)
  den(274) = den(6)**2
  den(275) = den(143)*den(274)
  den(276) = den(11)*den(274)
  den(277) = den(11)*den(145)
  den(278) = den(14)*den(143)
  den(279) = den(16)*den(17)
  den(280) = den(147)*den(279)
  den(281) = den(1)*den(280)
  den(282) = den(1)*den(17)
  den(284) = den(282)*den(283)
  den(285) = den(16)*den(284)
  den(287) = den(18)*den(286)
  den(288) = den(17)*den(287)
  den(289) = den(152)*den(271)
  den(290) = den(23)*den(271)
  den(291) = den(16)**2
  den(292) = den(143)*den(291)
  den(293) = den(21)*den(291)
  den(294) = den(21)*den(152)
  den(295) = den(23)*den(143)
  den(296) = den(25)*den(26)
  den(297) = den(147)*den(296)
  den(298) = den(1)*den(297)
  den(299) = den(1)*den(26)
  den(301) = den(299)*den(300)
  den(302) = den(25)*den(301)
  den(304) = den(27)*den(303)
  den(305) = den(26)*den(304)
  den(306) = den(117)*den(271)
  den(307) = den(32)*den(271)
  den(308) = den(26)**2
  den(309) = den(143)*den(308)
  den(310) = den(30)*den(117)
  den(311) = den(32)*den(143)
  den(312) = den(30)*den(308)
  den(313) = den(155)*den(271)
  den(314) = den(36)*den(271)
  den(315) = den(25)**2
  den(316) = den(11)*den(315)
  den(317) = den(21)*den(315)
  den(318) = den(21)*den(155)
  den(319) = den(11)*den(36)
  den(320) = den(123)*den(271)
  den(321) = den(39)*den(271)
  den(322) = den(17)**2
  den(323) = den(11)*den(322)
  den(324) = den(30)*den(123)
  den(325) = den(11)*den(39)
  den(326) = den(30)*den(322)
  den(327) = den(128)*den(271)
  den(328) = den(43)*den(271)
  den(329) = den(30)*den(128)
  den(330) = den(21)*den(43)
  den(331) = den(7)**2
  den(332) = den(21)*den(331)
  den(333) = den(30)*den(331)
  den(334) = den(4)*den(7)
  den(336) = den(334)*den(335)
  den(337) = den(45)*den(336)
  den(338) = den(7)*den(45)
  den(339) = den(161)*den(338)
  den(340) = den(4)*den(339)
  den(341) = den(46)*den(268)
  den(342) = den(7)*den(341)
  den(343) = den(45)**2
  den(344) = den(159)*den(343)
  den(345) = den(52)*den(343)
  den(346) = den(4)**2
  den(347) = den(157)*den(346)
  den(348) = den(49)*den(346)
  den(349) = den(49)*den(159)
  den(350) = den(52)*den(157)
  den(351) = den(4)*den(17)
  den(353) = den(351)*den(352)
  den(354) = den(54)*den(353)
  den(355) = den(17)*den(54)
  den(356) = den(161)*den(355)
  den(357) = den(4)*den(356)
  den(358) = den(55)*den(286)
  den(359) = den(17)*den(358)
  den(360) = den(54)**2
  den(361) = den(159)*den(360)
  den(362) = den(60)*den(360)
  den(363) = den(165)*den(346)
  den(364) = den(57)*den(346)
  den(365) = den(57)*den(159)
  den(366) = den(60)*den(165)
  den(367) = den(4)*den(26)
  den(369) = den(367)*den(368)
  den(370) = den(62)*den(369)
  den(371) = den(26)*den(62)
  den(372) = den(161)*den(371)
  den(373) = den(4)*den(372)
  den(374) = den(63)*den(303)
  den(375) = den(26)*den(374)
  den(376) = den(117)*den(346)
  den(377) = den(159)*den(308)
  den(378) = den(65)*den(117)
  den(379) = den(67)*den(159)
  den(380) = den(67)*den(346)
  den(381) = den(65)*den(308)
  den(382) = den(62)**2
  den(383) = den(52)*den(382)
  den(384) = den(60)*den(382)
  den(385) = den(168)*den(346)
  den(386) = den(70)*den(346)
  den(387) = den(52)*den(70)
  den(388) = den(60)*den(168)
  den(389) = den(123)*den(346)
  den(390) = den(52)*den(322)
  den(391) = den(65)*den(123)
  den(392) = den(52)*den(74)
  den(393) = den(74)*den(346)
  den(394) = den(65)*den(322)
  den(395) = den(128)*den(346)
  den(396) = den(65)*den(128)
  den(397) = den(60)*den(78)
  den(398) = den(60)*den(331)
  den(399) = den(78)*den(346)
  den(400) = den(65)*den(331)
  den(401) = den(152)*den(343)
  den(402) = den(82)*den(343)
  den(403) = den(157)*den(291)
  den(404) = den(80)*den(291)
  den(405) = den(80)*den(152)
  den(406) = den(82)*den(157)
  den(407) = den(155)*den(343)
  den(408) = den(86)*den(343)
  den(409) = den(49)*den(315)
  den(410) = den(80)*den(315)
  den(411) = den(80)*den(155)
  den(412) = den(49)*den(86)
  den(413) = den(43)*den(343)
  den(414) = den(43)*den(80)
  den(415) = den(80)*den(331)
  den(416) = den(145)*den(360)
  den(417) = den(91)*den(360)
  den(418) = den(165)*den(274)
  den(419) = den(89)*den(274)
  den(420) = den(89)*den(145)
  den(421) = den(91)*den(165)
  den(422) = den(14)*den(382)
  den(423) = den(91)*den(382)
  den(424) = den(168)*den(274)
  den(425) = den(94)*den(274)
  den(426) = den(14)*den(94)
  den(427) = den(91)*den(168)
  den(428) = den(78)*den(91)
  den(429) = den(91)*den(331)
  den(430) = den(78)*den(274)
  den(431) = den(36)*den(360)
  den(432) = den(86)*den(360)
  den(433) = den(57)*den(315)
  den(434) = den(89)*den(315)
  den(435) = den(36)*den(89)
  den(436) = den(57)*den(86)
  den(437) = den(39)*den(360)
  den(438) = den(39)*den(89)
  den(439) = den(89)*den(322)
  den(440) = den(23)*den(382)
  den(441) = den(82)*den(382)
  den(442) = den(70)*den(291)
  den(443) = den(94)*den(291)
  den(444) = den(23)*den(94)
  den(445) = den(70)*den(82)
  den(446) = den(74)*den(82)
  den(447) = den(82)*den(322)
  den(448) = den(74)*den(291)
  den(449) = den(32)*den(382)
  den(450) = den(32)*den(94)
  den(451) = den(94)*den(308)
  den(452) = den(67)*den(86)
  den(453) = den(86)*den(308)
  den(454) = den(67)*den(315)
  den(456) = den(106)*den(455)
  den(458) = den(106)*den(457)
  den(460) = den(106)*den(459)
  den(461) = den(26)*den(106)
  den(462) = den(459)*den(461)
  den(463) = den(17)*den(106)
  den(464) = den(457)*den(463)
  den(465) = den(7)*den(106)
  den(466) = den(455)*den(465)
  den(467) = den(126)*den(459)
  den(468) = den(126)*den(457)
  den(469) = den(121)*den(459)
  den(470) = den(121)*den(455)
  den(471) = den(115)*den(457)
  den(472) = den(115)*den(455)
  den(473) = den(30)*den(268)
  den(474) = den(30)*den(286)
  den(475) = den(30)*den(303)
  den(476) = den(21)*den(268)
  den(477) = den(21)*den(300)
  den(478) = den(21)*den(283)
  den(479) = den(11)*den(286)
  den(480) = den(11)*den(300)
  den(481) = den(11)*den(265)
  den(482) = den(143)*den(303)
  den(483) = den(143)*den(283)
  den(484) = den(143)*den(265)
  den(485) = den(65)*den(268)
  den(486) = den(65)*den(286)
  den(487) = den(65)*den(303)
  den(488) = den(60)*den(268)
  den(489) = den(52)*den(286)
  den(490) = den(159)*den(303)
  den(491) = den(60)*den(368)
  den(492) = den(60)*den(352)
  den(493) = den(52)*den(368)
  den(494) = den(52)*den(335)
  den(495) = den(159)*den(352)
  den(496) = den(159)*den(335)
  den(497) = den(173)*den(459)
  den(498) = den(182)*den(457)
  den(499) = den(177)*den(459)
  den(500) = den(177)*den(457)
  den(501) = den(80)*den(268)
  den(502) = den(80)*den(300)
  den(503) = den(80)*den(283)
  den(504) = den(49)*den(459)
  den(505) = den(49)*den(300)
  den(506) = den(49)*den(161)
  den(507) = den(157)*den(457)
  den(508) = den(157)*den(283)
  den(509) = den(157)*den(161)
  den(510) = den(189)*den(459)
  den(511) = den(198)*den(457)
  den(512) = den(193)*den(459)
  den(513) = den(193)*den(457)
  den(514) = den(91)*den(268)
  den(515) = den(14)*den(459)
  den(516) = den(145)*den(457)
  den(517) = den(91)*den(368)
  den(518) = den(91)*den(352)
  den(519) = den(14)*den(368)
  den(520) = den(14)*den(147)
  den(521) = den(145)*den(352)
  den(522) = den(145)*den(147)
  den(523) = den(227)*den(455)
  den(524) = den(205)*den(459)
  den(525) = den(205)*den(455)
  den(526) = den(89)*den(286)
  den(527) = den(89)*den(300)
  den(528) = den(89)*den(265)
  den(529) = den(57)*den(459)
  den(530) = den(57)*den(300)
  den(531) = den(57)*den(161)
  den(532) = den(165)*den(455)
  den(533) = den(165)*den(265)
  den(534) = den(161)*den(165)
  den(535) = den(232)*den(455)
  den(536) = den(211)*den(459)
  den(537) = den(211)*den(455)
  den(538) = den(82)*den(286)
  den(539) = den(23)*den(459)
  den(540) = den(152)*den(455)
  den(541) = den(82)*den(368)
  den(542) = den(82)*den(335)
  den(543) = den(23)*den(368)
  den(544) = den(23)*den(147)
  den(545) = den(152)*den(335)
  den(546) = den(147)*den(152)
  den(547) = den(67)*den(459)
  den(548) = den(32)*den(459)
  den(549) = den(67)*den(300)
  den(550) = den(67)*den(161)
  den(551) = den(117)*den(161)
  den(552) = den(32)*den(368)
  den(553) = den(32)*den(147)
  den(554) = den(117)*den(147)
  den(555) = den(215)*den(457)
  den(556) = den(215)*den(455)
  den(557) = den(94)*den(303)
  den(558) = den(94)*den(283)
  den(559) = den(94)*den(265)
  den(560) = den(70)*den(457)
  den(561) = den(70)*den(283)
  den(562) = den(70)*den(161)
  den(563) = den(168)*den(455)
  den(564) = den(168)*den(265)
  den(565) = den(161)*den(168)
  den(566) = den(217)*den(457)
  den(567) = den(217)*den(455)
  den(568) = den(86)*den(303)
  den(569) = den(36)*den(457)
  den(570) = den(155)*den(455)
  den(571) = den(86)*den(352)
  den(572) = den(86)*den(335)
  den(573) = den(36)*den(352)
  den(574) = den(36)*den(147)
  den(575) = den(155)*den(335)
  den(576) = den(147)*den(155)
  den(577) = den(74)*den(457)
  den(578) = den(39)*den(457)
  den(579) = den(74)*den(283)
  den(580) = den(74)*den(161)
  den(581) = den(123)*den(161)
  den(582) = den(39)*den(352)
  den(583) = den(39)*den(147)
  den(584) = den(123)*den(147)
  den(585) = den(78)*den(455)
  den(586) = den(43)*den(455)
  den(587) = den(78)*den(265)
  den(588) = den(78)*den(161)
  den(589) = den(128)*den(161)
  den(590) = den(43)*den(335)
  den(591) = den(43)*den(147)
  den(592) = den(128)*den(147)
  den(593) = den(1)*den(6)*den(7)
  den(594) = den(1)*den(16)*den(17)
  den(595) = den(1)*den(25)*den(26)
  den(596) = den(4)*den(7)*den(45)
  den(597) = den(4)*den(17)*den(54)
  den(598) = den(4)*den(26)*den(62)
  den(599) = den(6)*den(481)
  den(600) = den(6)*den(484)
  den(601) = den(1)*den(520)
  den(602) = den(1)*den(522)
  den(603) = den(16)*den(478)
  den(604) = den(16)*den(483)
  den(605) = den(1)*den(544)
  den(606) = den(1)*den(546)
  den(607) = den(26)*den(475)
  den(608) = den(26)*den(482)
  den(609) = den(1)*den(553)
  den(610) = den(1)*den(554)
  den(611) = den(25)*den(477)
  den(612) = den(25)*den(480)
  den(613) = den(1)*den(574)
  den(614) = den(1)*den(576)
  den(615) = den(17)*den(474)
  den(616) = den(17)*den(479)
  den(617) = den(1)*den(583)
  den(618) = den(1)*den(584)
  den(619) = den(7)*den(473)
  den(620) = den(7)*den(476)
  den(621) = den(1)*den(591)
  den(622) = den(1)*den(592)
  den(623) = den(4)*den(506)
  den(624) = den(4)*den(509)
  den(625) = den(45)*den(494)
  den(626) = den(45)*den(496)
  den(627) = den(4)*den(531)
  den(628) = den(4)*den(534)
  den(629) = den(54)*den(492)
  den(630) = den(54)*den(495)
  den(631) = den(26)*den(487)
  den(632) = den(4)*den(550)
  den(633) = den(26)*den(490)
  den(634) = den(4)*den(551)
  den(635) = den(4)*den(562)
  den(636) = den(4)*den(565)
  den(637) = den(62)*den(491)
  den(638) = den(62)*den(493)
  den(639) = den(17)*den(486)
  den(640) = den(4)*den(580)
  den(641) = den(17)*den(489)
  den(642) = den(4)*den(581)
  den(643) = den(7)*den(485)
  den(644) = den(4)*den(588)
  den(645) = den(7)*den(488)
  den(646) = den(4)*den(589)
  den(647) = den(16)*den(503)
  den(648) = den(16)*den(508)
  den(649) = den(45)*den(542)
  den(650) = den(45)*den(545)
  den(651) = den(25)*den(502)
  den(652) = den(25)*den(505)
  den(653) = den(45)*den(572)
  den(654) = den(45)*den(575)
  den(655) = den(7)*den(501)
  den(656) = den(45)*den(590)
  den(657) = den(6)*den(528)
  den(658) = den(6)*den(533)
  den(659) = den(54)*den(518)
  den(660) = den(54)*den(521)
  den(661) = den(6)*den(559)
  den(662) = den(6)*den(564)
  den(663) = den(62)*den(517)
  den(664) = den(62)*den(519)
  den(665) = den(6)*den(587)
  den(666) = den(7)*den(514)
  den(667) = den(25)*den(527)
  den(668) = den(25)*den(530)
  den(669) = den(54)*den(571)
  den(670) = den(54)*den(573)
  den(671) = den(17)*den(526)
  den(672) = den(54)*den(582)
  den(673) = den(16)*den(558)
  den(674) = den(16)*den(561)
  den(675) = den(62)*den(541)
  den(676) = den(62)*den(543)
  den(677) = den(16)*den(579)
  den(678) = den(17)*den(538)
  den(679) = den(26)*den(557)
  den(680) = den(62)*den(552)
  den(681) = den(25)*den(549)
  den(682) = den(26)*den(568)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif


!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_pphttj_ttxhggg_1_/**/DREALKIND, only: nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for top anti-top higgs glue glue glue -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_pphttj_ttxhggg_1, only: &
    & external_perm_pphttj_ttxhggg_1, &
    & external_perm_inv_pphttj_ttxhggg_1, &
    & extcomb_perm_pphttj_ttxhggg_1, &
    & average_factor_pphttj_ttxhggg_1, &
    & photonid_pphttj_ttxhggg_1
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  use ol_external_pphttj_ttxhggg_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_pphttj_ttxhggg_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pphttj_ttxhggg_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_pphttj_ttxhggg_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(22)
  logical, intent(in) :: qp_kinematics
  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(6), M2(11)
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  real(REALKIND)       :: bornphotonfactor
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(6,32)
  type(Hpolcont) :: M1helarray_ct(11,32)
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(22), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak

#if 6 > 3
  integer :: ind_cc_comb(9)
#endif
  type(Hpolcont) :: A(32,564)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(564)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if


  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMT, nMT, nMH, 0, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_pphttj_ttxhggg_1, 6, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMT, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rMT, H2, ex2, POLSEL(2),2)
  call pol_wf_S(P(:,3), rMH, H3, ex3, POLSEL(3),3)
  call pol_wf_V(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rZERO, H5, ex5, POLSEL(5),5)
  call pol_wf_V(P(:,6), rZERO, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QS_A(gH,ntry, ex1(:), ex3(:), wf2(:,1), n3(:,1), t3x2(:,:,1))
  call vert_GGG_G(ntry, ex4(:), ex5(:), ex6(:), wf8(:,1), n4(:,1), t4x8(:,:,1))
  call prop_Q_A(ntry, wf2(:,1), 5, MT, 1_intkind1, wf2(:,2), n2(1))
  call vert_QA_V(ntry, wf2(:,2), ex2(:), wf4(:,1), n3(:,2), t3x4(:,:,1))
  call vert_GGG_G(ntry, ex5(:), ex6(:), ex4(:), wf8(:,2), n4(:,2), t4x8(:,:,2))
  call vert_GGG_G(ntry, ex6(:), ex4(:), ex5(:), wf8(:,3), n4(:,3), t4x8(:,:,3))
  call vert_SA_Q(gH,ntry, ex3(:), ex2(:), wf2(:,3), n3(:,3), t3x2(:,:,2))
  call prop_A_Q(ntry, wf2(:,3), 6, MT, 1_intkind1, wf2(:,4), n2(2))
  call vert_QA_V(ntry, ex1(:), wf2(:,4), wf4(:,2), n3(:,4), t3x4(:,:,2))
  call vert_AV_Q(ntry, ex2(:), ex4(:), wf4(:,3), n3(:,5), t3x4(:,:,3))
  call vert_UV_W(ntry, ex5(:), 16, ex6(:), 32, wf4(:,4), n3(:,6), t3x4(:,:,4))
  call prop_A_Q(ntry, wf4(:,3), 10, MT, 1_intkind1, wf4(:,5), n2(3))
  call vert_QA_V(ntry, wf2(:,2), wf4(:,5), wf8(:,4), n3(:,7), t3x8(:,:,1))
  call vert_VQ_A(ntry, ex5(:), wf2(:,2), wf4(:,6), n3(:,8), t3x4(:,:,5))
  call vert_AV_Q(ntry, wf4(:,5), ex6(:), wf8(:,5), n3(:,9), t3x8(:,:,2))
  call prop_Q_A(ntry, wf4(:,6), 21, MT, 1_intkind1, wf4(:,7), n2(4))
  call vert_AV_Q(ntry, wf4(:,5), ex5(:), wf8(:,6), n3(:,10), t3x8(:,:,3))
  call vert_VQ_A(ntry, ex6(:), wf2(:,2), wf4(:,8), n3(:,11), t3x4(:,:,6))
  call prop_A_Q(ntry, wf8(:,6), 26, MT, 1_intkind1, wf8(:,7), n2(5))
  call vert_AV_Q(ntry, ex2(:), ex5(:), wf4(:,9), n3(:,12), t3x4(:,:,7))
  call vert_UV_W(ntry, ex4(:), 8, ex6(:), 32, wf4(:,10), n3(:,13), t3x4(:,:,8))
  call prop_A_Q(ntry, wf4(:,9), 18, MT, 1_intkind1, wf4(:,11), n2(6))
  call vert_QA_V(ntry, wf2(:,2), wf4(:,11), wf8(:,8), n3(:,14), t3x8(:,:,4))
  call vert_VQ_A(ntry, ex4(:), wf2(:,2), wf4(:,12), n3(:,15), t3x4(:,:,9))
  call vert_AV_Q(ntry, wf4(:,11), ex6(:), wf8(:,9), n3(:,16), t3x8(:,:,5))
  call prop_Q_A(ntry, wf4(:,12), 13, MT, 1_intkind1, wf4(:,13), n2(7))
  call vert_AV_Q(ntry, wf4(:,11), ex4(:), wf8(:,10), n3(:,17), t3x8(:,:,6))
  call prop_A_Q(ntry, wf8(:,10), 26, MT, 1_intkind1, wf8(:,11), n2(8))
  call vert_AV_Q(ntry, ex2(:), ex6(:), wf4(:,14), n3(:,18), t3x4(:,:,10))
  call vert_UV_W(ntry, ex4(:), 8, ex5(:), 16, wf4(:,15), n3(:,19), t3x4(:,:,11))
  call prop_A_Q(ntry, wf4(:,14), 34, MT, 1_intkind1, wf4(:,16), n2(9))
  call vert_QA_V(ntry, wf2(:,2), wf4(:,16), wf8(:,12), n3(:,20), t3x8(:,:,7))
  call vert_UV_W(ntry, wf4(:,15), 24, ex6(:), 32, wf8(:,13), n3(:,21), t3x8(:,:,8))
  call vert_AV_Q(ntry, ex2(:), wf4(:,15), wf8(:,14), n3(:,22), t3x8(:,:,9))
  call prop_A_Q(ntry, wf8(:,14), 26, MT, 1_intkind1, wf8(:,15), n2(10))
  call vert_AV_Q(ntry, wf4(:,16), ex5(:), wf8(:,16), n3(:,23), t3x8(:,:,10))
  call vert_AV_Q(ntry, wf4(:,16), ex4(:), wf8(:,17), n3(:,24), t3x8(:,:,11))
  call prop_A_Q(ntry, wf8(:,17), 42, MT, 1_intkind1, wf8(:,18), n2(11))
  call vert_UV_W(ntry, ex5(:), 16, wf4(:,10), 40, wf8(:,19), n3(:,25), t3x8(:,:,12))
  call vert_AV_Q(ntry, ex2(:), wf4(:,10), wf8(:,20), n3(:,26), t3x8(:,:,13))
  call prop_A_Q(ntry, wf8(:,20), 42, MT, 1_intkind1, wf8(:,21), n2(12))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,4), 48, wf8(:,22), n3(:,27), t3x8(:,:,14))
  call vert_AV_Q(ntry, ex2(:), wf4(:,4), wf8(:,23), n3(:,28), t3x8(:,:,15))
  call prop_A_Q(ntry, wf8(:,23), 50, MT, 1_intkind1, wf8(:,24), n2(13))
  call vert_VQ_A(ntry, ex4(:), ex1(:), wf4(:,17), n3(:,29), t3x4(:,:,12))
  call prop_Q_A(ntry, wf4(:,17), 9, MT, 1_intkind1, wf4(:,18), n2(14))
  call vert_QA_V(ntry, wf4(:,18), wf2(:,4), wf8(:,25), n3(:,30), t3x8(:,:,16))
  call vert_VQ_A(ntry, ex5(:), wf4(:,18), wf8(:,26), n3(:,31), t3x8(:,:,17))
  call vert_AV_Q(ntry, wf2(:,4), ex6(:), wf4(:,19), n3(:,32), t3x4(:,:,13))
  call prop_Q_A(ntry, wf8(:,26), 25, MT, 1_intkind1, wf8(:,27), n2(15))
  call vert_AV_Q(ntry, wf2(:,4), ex5(:), wf4(:,20), n3(:,33), t3x4(:,:,14))
  call vert_VQ_A(ntry, ex6(:), wf4(:,18), wf8(:,28), n3(:,34), t3x8(:,:,18))
  call prop_A_Q(ntry, wf4(:,20), 22, MT, 1_intkind1, wf4(:,21), n2(16))
  call vert_VQ_A(ntry, ex5(:), ex1(:), wf4(:,22), n3(:,35), t3x4(:,:,15))
  call prop_Q_A(ntry, wf4(:,22), 17, MT, 1_intkind1, wf4(:,23), n2(17))
  call vert_QA_V(ntry, wf4(:,23), wf2(:,4), wf8(:,29), n3(:,36), t3x8(:,:,19))
  call vert_VQ_A(ntry, ex4(:), wf4(:,23), wf8(:,30), n3(:,37), t3x8(:,:,20))
  call prop_Q_A(ntry, wf8(:,30), 25, MT, 1_intkind1, wf8(:,31), n2(18))
  call vert_AV_Q(ntry, wf2(:,4), ex4(:), wf4(:,24), n3(:,38), t3x4(:,:,16))
  call vert_VQ_A(ntry, ex6(:), wf4(:,23), wf8(:,32), n3(:,39), t3x8(:,:,21))
  call prop_A_Q(ntry, wf4(:,24), 14, MT, 1_intkind1, wf4(:,25), n2(19))
  call vert_VQ_A(ntry, ex6(:), ex1(:), wf4(:,26), n3(:,40), t3x4(:,:,17))
  call prop_Q_A(ntry, wf4(:,26), 33, MT, 1_intkind1, wf4(:,27), n2(20))
  call vert_QA_V(ntry, wf4(:,27), wf2(:,4), wf8(:,33), n3(:,41), t3x8(:,:,22))
  call vert_VQ_A(ntry, wf4(:,15), ex1(:), wf8(:,34), n3(:,42), t3x8(:,:,23))
  call prop_Q_A(ntry, wf8(:,34), 25, MT, 1_intkind1, wf8(:,35), n2(21))
  call vert_VQ_A(ntry, ex4(:), wf4(:,27), wf8(:,36), n3(:,43), t3x8(:,:,24))
  call prop_Q_A(ntry, wf8(:,36), 41, MT, 1_intkind1, wf8(:,37), n2(22))
  call vert_VQ_A(ntry, ex5(:), wf4(:,27), wf8(:,38), n3(:,44), t3x8(:,:,25))
  call vert_VQ_A(ntry, wf4(:,10), ex1(:), wf8(:,39), n3(:,45), t3x8(:,:,26))
  call prop_Q_A(ntry, wf8(:,39), 41, MT, 1_intkind1, wf8(:,40), n2(23))
  call vert_VQ_A(ntry, wf4(:,4), ex1(:), wf8(:,41), n3(:,46), t3x8(:,:,27))
  call prop_Q_A(ntry, wf8(:,41), 49, MT, 1_intkind1, wf8(:,42), n2(24))
  call vert_QS_A(gH,ntry, wf4(:,18), ex3(:), wf4(:,28), n3(:,47), t3x4(:,:,18))
  call prop_Q_A(ntry, wf4(:,28), 13, MT, 1_intkind1, wf4(:,29), n2(25))
  call vert_SA_Q(gH,ntry, ex3(:), wf4(:,11), wf4(:,30), n3(:,48), t3x4(:,:,19))
  call prop_A_Q(ntry, wf4(:,30), 22, MT, 1_intkind1, wf4(:,31), n2(26))
  call vert_SA_Q(gH,ntry, ex3(:), wf4(:,16), wf4(:,32), n3(:,49), t3x4(:,:,20))
  call prop_A_Q(ntry, wf4(:,32), 38, MT, 1_intkind1, wf4(:,33), n2(27))
  call vert_QS_A(gH,ntry, wf4(:,23), ex3(:), wf4(:,34), n3(:,50), t3x4(:,:,21))
  call prop_Q_A(ntry, wf4(:,34), 21, MT, 1_intkind1, wf4(:,35), n2(28))
  call vert_SA_Q(gH,ntry, ex3(:), wf4(:,5), wf4(:,36), n3(:,51), t3x4(:,:,22))
  call prop_A_Q(ntry, wf4(:,36), 14, MT, 1_intkind1, wf4(:,37), n2(29))
  call vert_QS_A(gH,ntry, wf4(:,27), ex3(:), wf4(:,38), n3(:,52), t3x4(:,:,23))
  call prop_Q_A(ntry, wf4(:,38), 37, MT, 1_intkind1, wf4(:,39), n2(30))
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,40), n3(:,53), t3x4(:,:,24))
  call counter_SG_G(ntry, ex3(:), wf4(:,40), wf4(:,41), n3(:,54), t3x4(:,:,25))
  call counter_SG_G(ntry, ex3(:), ex6(:), wf2(:,5), n3(:,55), t3x2(:,:,3))
  call vert_GGG_G(ntry, wf4(:,40), ex4(:), ex5(:), wf16(:,1), n4(:,4), t4x16(:,:,1))
  call vert_GGG_G(ntry, ex4(:), ex5(:), wf4(:,40), wf16(:,2), n4(:,5), t4x16(:,:,2))
  call vert_GGG_G(ntry, ex5(:), wf4(:,40), ex4(:), wf16(:,3), n4(:,6), t4x16(:,:,3))
  call counter_SG_G(ntry, ex3(:), ex5(:), wf2(:,6), n3(:,56), t3x2(:,:,4))
  call vert_GGG_G(ntry, wf4(:,40), ex4(:), ex6(:), wf16(:,4), n4(:,7), t4x16(:,:,4))
  call vert_GGG_G(ntry, ex4(:), ex6(:), wf4(:,40), wf16(:,5), n4(:,8), t4x16(:,:,5))
  call vert_GGG_G(ntry, ex6(:), wf4(:,40), ex4(:), wf16(:,6), n4(:,9), t4x16(:,:,6))
  call counter_SG_G(ntry, ex3(:), ex4(:), wf2(:,7), n3(:,57), t3x2(:,:,5))
  call vert_GGG_G(ntry, wf4(:,40), ex5(:), ex6(:), wf16(:,7), n4(:,10), t4x16(:,:,7))
  call vert_GGG_G(ntry, ex5(:), ex6(:), wf4(:,40), wf16(:,8), n4(:,11), t4x16(:,:,8))
  call vert_GGG_G(ntry, ex6(:), wf4(:,40), ex5(:), wf16(:,9), n4(:,12), t4x16(:,:,9))
  call counter_GGG_G(ntry, ex4(:), ex5(:), ex6(:), wf8(:,43), n4(:,13), t4x8(:,:,4))
  call counter_GGG_G(ntry, ex5(:), ex6(:), ex4(:), wf8(:,44), n4(:,14), t4x8(:,:,5))
  call counter_GGG_G(ntry, ex6(:), ex4(:), ex5(:), wf8(:,45), n4(:,15), t4x8(:,:,6))
  call counter_QA_V(ntry, wf2(:,2), ex2(:), wf4(:,42), n3(:,58), t3x4(:,:,26))
  call counter_SA_Q(gH,ntry, ex3(:), ex2(:), wf2(:,8), n3(:,59), t3x2(:,:,6))
  call prop_A_Q(ntry, wf2(:,8), 6, MT, 1_intkind1, wf2(:,9), n2(31))
  call vert_QA_V(ntry, ex1(:), wf2(:,9), wf4(:,43), n3(:,60), t3x4(:,:,27))
  call counter_QA_V(ntry, ex1(:), wf2(:,4), wf4(:,44), n3(:,61), t3x4(:,:,28))
  call counter_QS_A(gH,ntry, ex1(:), ex3(:), wf2(:,10), n3(:,62), t3x2(:,:,7))
  call prop_Q_A(ntry, wf2(:,10), 5, MT, 1_intkind1, wf2(:,11), n2(32))
  call vert_QA_V(ntry, wf2(:,11), ex2(:), wf4(:,45), n3(:,63), t3x4(:,:,29))
  call vert_UV_W(ntry, wf4(:,40), 3, ex6(:), 32, wf8(:,46), n3(:,64), t3x8(:,:,28))
  call counter_SG_G(ntry, ex3(:), wf4(:,15), wf4(:,46), n3(:,65), t3x4(:,:,30))
  call vert_UV_W(ntry, wf4(:,40), 3, wf2(:,5), 36, wf8(:,47), n3(:,66), t3x8(:,:,29))
  call vert_UV_W(ntry, wf4(:,40), 3, ex5(:), 16, wf8(:,48), n3(:,67), t3x8(:,:,30))
  call counter_SG_G(ntry, ex3(:), wf4(:,10), wf4(:,47), n3(:,68), t3x4(:,:,31))
  call vert_UV_W(ntry, wf4(:,40), 3, ex4(:), 8, wf8(:,49), n3(:,69), t3x8(:,:,31))
  call counter_SG_G(ntry, ex3(:), wf4(:,4), wf4(:,48), n3(:,70), t3x4(:,:,32))
  call vert_UV_W(ntry, ex5(:), 16, wf2(:,5), 36, wf4(:,49), n3(:,71), t3x4(:,:,33))
  call vert_UV_W(ntry, ex4(:), 8, wf2(:,5), 36, wf4(:,50), n3(:,72), t3x4(:,:,34))
  call vert_UV_W(ntry, wf4(:,40), 3, wf2(:,6), 20, wf8(:,50), n3(:,73), t3x8(:,:,32))
  call vert_UV_W(ntry, wf2(:,6), 20, ex6(:), 32, wf4(:,51), n3(:,74), t3x4(:,:,35))
  call vert_UV_W(ntry, ex4(:), 8, wf2(:,6), 20, wf4(:,52), n3(:,75), t3x4(:,:,36))
  call vert_UV_W(ntry, wf4(:,40), 3, wf2(:,7), 12, wf8(:,51), n3(:,76), t3x8(:,:,33))
  call vert_UV_W(ntry, wf2(:,7), 12, ex6(:), 32, wf4(:,53), n3(:,77), t3x4(:,:,37))
  call vert_UV_W(ntry, wf2(:,7), 12, ex5(:), 16, wf4(:,54), n3(:,78), t3x4(:,:,38))
  call counter_QA_V(ntry, wf2(:,2), wf4(:,5), wf8(:,52), n3(:,79), t3x8(:,:,34))
  call counter_AV_Q(ntry, wf4(:,5), ex6(:), wf8(:,53), n3(:,80), t3x8(:,:,35))
  call counter_VQ_A(ntry, ex6(:), wf2(:,2), wf4(:,55), n3(:,81), t3x4(:,:,39))
  call counter_AV_Q(ntry, wf4(:,5), ex5(:), wf8(:,54), n3(:,82), t3x8(:,:,36))
  call prop_Q_A(ntry, wf4(:,8), 37, MT, 1_intkind1, wf4(:,56), n2(33))
  call counter_VQ_A(ntry, ex5(:), wf2(:,2), wf4(:,57), n3(:,83), t3x4(:,:,40))
  call prop_A_Q(ntry, wf8(:,5), 42, MT, 1_intkind1, wf8(:,55), n2(34))
  call counter_UV_W(ntry, ex5(:), 16, ex6(:), 32, wf4(:,58), n3(:,84), t3x4(:,:,41))
  call counter_QA_V(ntry, wf2(:,2), wf4(:,11), wf8(:,56), n3(:,85), t3x8(:,:,37))
  call counter_AV_Q(ntry, wf4(:,11), ex6(:), wf8(:,57), n3(:,86), t3x8(:,:,38))
  call counter_QA_V(ntry, wf2(:,2), wf4(:,16), wf8(:,58), n3(:,87), t3x8(:,:,39))
  call counter_UV_W(ntry, wf4(:,15), 24, ex6(:), 32, wf8(:,59), n3(:,88), t3x8(:,:,40))
  call counter_AV_Q(ntry, wf4(:,16), ex5(:), wf8(:,60), n3(:,89), t3x8(:,:,41))
  call counter_UV_W(ntry, ex5(:), 16, wf4(:,10), 40, wf8(:,61), n3(:,90), t3x8(:,:,42))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,58), 48, wf8(:,62), n3(:,91), t3x8(:,:,43))
  call vert_AV_Q(ntry, ex2(:), wf4(:,58), wf8(:,63), n3(:,92), t3x8(:,:,44))
  call prop_A_Q(ntry, wf8(:,63), 50, MT, 1_intkind1, wf8(:,64), n2(35))
  call vert_AV_Q(ntry, ex2(:), wf8(:,1), wf16(:,10), n3(:,93), t3x16(:,:,1))
  call counter_Q_A(cttt,6,ntry, wf2(:,2), 5, wf2(:,12), n2(36))
  call prop_A_Q(ntry, wf16(:,10), 58, MT, 1_intkind1, wf16(:,11), n2(37))
  call vert_AV_Q(ntry, ex2(:), wf8(:,2), wf16(:,12), n3(:,94), t3x16(:,:,2))
  call prop_A_Q(ntry, wf16(:,12), 58, MT, 1_intkind1, wf16(:,13), n2(38))
  call vert_AV_Q(ntry, ex2(:), wf8(:,3), wf16(:,14), n3(:,95), t3x16(:,:,3))
  call prop_A_Q(ntry, wf16(:,14), 58, MT, 1_intkind1, wf16(:,15), n2(39))
  call counter_V_V(ctGG,21,ntry, wf8(:,1), 56, wf8(:,65), n2(40))
  call counter_V_V(ctGG,21,ntry, wf8(:,2), 56, wf8(:,66), n2(41))
  call counter_V_V(ctGG,21,ntry, wf8(:,3), 56, wf8(:,67), n2(42))
  call counter_AV_Q(ntry, wf4(:,11), ex4(:), wf8(:,68), n3(:,96), t3x8(:,:,45))
  call counter_VQ_A(ntry, ex4(:), wf2(:,2), wf4(:,59), n3(:,97), t3x4(:,:,42))
  call prop_A_Q(ntry, wf8(:,9), 50, MT, 1_intkind1, wf8(:,69), n2(43))
  call counter_UV_W(ntry, ex4(:), 8, ex6(:), 32, wf4(:,60), n3(:,98), t3x4(:,:,43))
  call counter_AV_Q(ntry, wf4(:,16), ex4(:), wf8(:,70), n3(:,99), t3x8(:,:,46))
  call prop_A_Q(ntry, wf8(:,16), 50, MT, 1_intkind1, wf8(:,71), n2(44))
  call counter_UV_W(ntry, ex4(:), 8, wf4(:,4), 48, wf8(:,72), n3(:,100), t3x8(:,:,47))
  call vert_UV_W(ntry, ex5(:), 16, wf4(:,60), 40, wf8(:,73), n3(:,101), t3x8(:,:,48))
  call vert_AV_Q(ntry, ex2(:), wf4(:,60), wf8(:,74), n3(:,102), t3x8(:,:,49))
  call prop_A_Q(ntry, wf8(:,74), 42, MT, 1_intkind1, wf8(:,75), n2(45))
  call counter_UV_W(ntry, ex4(:), 8, ex5(:), 16, wf4(:,61), n3(:,103), t3x4(:,:,44))
  call vert_UV_W(ntry, wf4(:,61), 24, ex6(:), 32, wf8(:,76), n3(:,104), t3x8(:,:,50))
  call vert_AV_Q(ntry, ex2(:), wf4(:,61), wf8(:,77), n3(:,105), t3x8(:,:,51))
  call prop_A_Q(ntry, wf8(:,77), 26, MT, 1_intkind1, wf8(:,78), n2(46))
  call counter_QA_V(ntry, wf4(:,18), wf2(:,4), wf8(:,79), n3(:,106), t3x8(:,:,52))
  call counter_AV_Q(ntry, wf2(:,4), ex6(:), wf4(:,62), n3(:,107), t3x4(:,:,45))
  call counter_VQ_A(ntry, ex6(:), wf4(:,18), wf8(:,80), n3(:,108), t3x8(:,:,53))
  call counter_AV_Q(ntry, wf2(:,4), ex5(:), wf4(:,63), n3(:,109), t3x4(:,:,46))
  call prop_Q_A(ntry, wf8(:,28), 41, MT, 1_intkind1, wf8(:,81), n2(47))
  call counter_VQ_A(ntry, ex5(:), wf4(:,18), wf8(:,82), n3(:,110), t3x8(:,:,54))
  call prop_A_Q(ntry, wf4(:,19), 38, MT, 1_intkind1, wf4(:,64), n2(48))
  call counter_QA_V(ntry, wf4(:,23), wf2(:,4), wf8(:,83), n3(:,111), t3x8(:,:,55))
  call counter_VQ_A(ntry, ex6(:), wf4(:,23), wf8(:,84), n3(:,112), t3x8(:,:,56))
  call counter_QA_V(ntry, wf4(:,27), wf2(:,4), wf8(:,85), n3(:,113), t3x8(:,:,57))
  call counter_VQ_A(ntry, ex5(:), wf4(:,27), wf8(:,86), n3(:,114), t3x8(:,:,58))
  call vert_VQ_A(ntry, wf4(:,58), ex1(:), wf8(:,87), n3(:,115), t3x8(:,:,59))
  call prop_Q_A(ntry, wf8(:,87), 49, MT, 1_intkind1, wf8(:,88), n2(49))
  call vert_VQ_A(ntry, wf8(:,1), ex1(:), wf16(:,16), n3(:,116), t3x16(:,:,4))
  call counter_A_Q(cttt,6,ntry, wf2(:,4), 6, wf2(:,13), n2(50))
  call prop_Q_A(ntry, wf16(:,16), 57, MT, 1_intkind1, wf16(:,17), n2(51))
  call vert_VQ_A(ntry, wf8(:,2), ex1(:), wf16(:,18), n3(:,117), t3x16(:,:,5))
  call prop_Q_A(ntry, wf16(:,18), 57, MT, 1_intkind1, wf16(:,19), n2(52))
  call vert_VQ_A(ntry, wf8(:,3), ex1(:), wf16(:,20), n3(:,118), t3x16(:,:,6))
  call prop_Q_A(ntry, wf16(:,20), 57, MT, 1_intkind1, wf16(:,21), n2(53))
  call counter_AV_Q(ntry, wf2(:,4), ex4(:), wf4(:,65), n3(:,119), t3x4(:,:,47))
  call prop_Q_A(ntry, wf8(:,32), 49, MT, 1_intkind1, wf8(:,89), n2(54))
  call counter_VQ_A(ntry, ex4(:), wf4(:,23), wf8(:,90), n3(:,120), t3x8(:,:,60))
  call prop_Q_A(ntry, wf8(:,38), 49, MT, 1_intkind1, wf8(:,91), n2(55))
  call counter_VQ_A(ntry, ex4(:), wf4(:,27), wf8(:,92), n3(:,121), t3x8(:,:,61))
  call vert_VQ_A(ntry, wf4(:,60), ex1(:), wf8(:,93), n3(:,122), t3x8(:,:,62))
  call prop_Q_A(ntry, wf8(:,93), 41, MT, 1_intkind1, wf8(:,94), n2(56))
  call vert_VQ_A(ntry, wf4(:,61), ex1(:), wf8(:,95), n3(:,123), t3x8(:,:,63))
  call prop_Q_A(ntry, wf8(:,95), 25, MT, 1_intkind1, wf8(:,96), n2(57))
  call counter_SA_Q(gH,ntry, ex3(:), wf4(:,11), wf4(:,66), n3(:,124), t3x4(:,:,48))
  call counter_QS_A(gH,ntry, wf4(:,18), ex3(:), wf4(:,67), n3(:,125), t3x4(:,:,49))
  call vert_QA_V(ntry, wf4(:,18), wf4(:,11), wf16(:,22), n3(:,126), t3x16(:,:,7))
  call counter_SA_Q(gH,ntry, ex3(:), wf4(:,16), wf4(:,68), n3(:,127), t3x4(:,:,50))
  call vert_QA_V(ntry, wf4(:,18), ex2(:), wf8(:,97), n3(:,128), t3x8(:,:,64))
  call vert_AV_Q(ntry, ex2(:), wf2(:,5), wf4(:,69), n3(:,129), t3x4(:,:,51))
  call prop_A_Q(ntry, wf4(:,69), 38, MT, 1_intkind1, wf4(:,70), n2(58))
  call vert_QA_V(ntry, wf4(:,18), wf4(:,16), wf16(:,23), n3(:,130), t3x16(:,:,8))
  call vert_AV_Q(ntry, ex2(:), wf2(:,6), wf4(:,71), n3(:,131), t3x4(:,:,52))
  call prop_A_Q(ntry, wf4(:,71), 22, MT, 1_intkind1, wf4(:,72), n2(59))
  call counter_SA_Q(gH,ntry, ex3(:), wf4(:,5), wf4(:,73), n3(:,132), t3x4(:,:,53))
  call counter_QS_A(gH,ntry, wf4(:,23), ex3(:), wf4(:,74), n3(:,133), t3x4(:,:,54))
  call vert_QA_V(ntry, wf4(:,23), wf4(:,5), wf16(:,24), n3(:,134), t3x16(:,:,9))
  call counter_QS_A(gH,ntry, wf4(:,27), ex3(:), wf4(:,75), n3(:,135), t3x4(:,:,55))
  call vert_QA_V(ntry, ex1(:), wf4(:,5), wf8(:,98), n3(:,136), t3x8(:,:,65))
  call vert_VQ_A(ntry, wf2(:,5), ex1(:), wf4(:,76), n3(:,137), t3x4(:,:,56))
  call prop_Q_A(ntry, wf4(:,76), 37, MT, 1_intkind1, wf4(:,77), n2(60))
  call vert_QA_V(ntry, wf4(:,27), wf4(:,5), wf16(:,25), n3(:,138), t3x16(:,:,10))
  call vert_VQ_A(ntry, wf2(:,6), ex1(:), wf4(:,78), n3(:,139), t3x4(:,:,57))
  call prop_Q_A(ntry, wf4(:,78), 21, MT, 1_intkind1, wf4(:,79), n2(61))
  call vert_QA_V(ntry, wf4(:,23), ex2(:), wf8(:,99), n3(:,140), t3x8(:,:,66))
  call vert_QA_V(ntry, ex1(:), wf4(:,11), wf8(:,100), n3(:,141), t3x8(:,:,67))
  call vert_QA_V(ntry, wf4(:,27), ex2(:), wf8(:,101), n3(:,142), t3x8(:,:,68))
  call vert_QA_V(ntry, ex1(:), wf4(:,16), wf8(:,102), n3(:,143), t3x8(:,:,69))
  call vert_QA_V(ntry, wf4(:,23), wf4(:,16), wf16(:,26), n3(:,144), t3x16(:,:,11))
  call vert_AV_Q(ntry, ex2(:), wf2(:,7), wf4(:,80), n3(:,145), t3x4(:,:,58))
  call prop_A_Q(ntry, wf4(:,80), 14, MT, 1_intkind1, wf4(:,81), n2(62))
  call vert_QA_V(ntry, wf4(:,27), wf4(:,11), wf16(:,27), n3(:,146), t3x16(:,:,12))
  call vert_VQ_A(ntry, wf2(:,7), ex1(:), wf4(:,82), n3(:,147), t3x4(:,:,59))
  call prop_Q_A(ntry, wf4(:,82), 13, MT, 1_intkind1, wf4(:,83), n2(63))
  call counter_AV_Q(ntry, ex2(:), wf4(:,15), wf8(:,103), n3(:,148), t3x8(:,:,70))
  call counter_AV_Q(ntry, ex2(:), ex6(:), wf4(:,84), n3(:,149), t3x4(:,:,60))
  call prop_A_Q(ntry, wf4(:,84), 34, MT, 1_intkind1, wf4(:,85), n2(64))
  call vert_QA_V(ntry, wf2(:,2), wf4(:,85), wf8(:,104), n3(:,150), t3x8(:,:,71))
  call counter_AV_Q(ntry, ex2(:), wf4(:,10), wf8(:,105), n3(:,151), t3x8(:,:,72))
  call counter_AV_Q(ntry, ex2(:), wf4(:,4), wf8(:,106), n3(:,152), t3x8(:,:,73))
  call vert_AV_Q(ntry, wf4(:,85), ex5(:), wf8(:,107), n3(:,153), t3x8(:,:,74))
  call vert_AV_Q(ntry, wf4(:,85), ex4(:), wf8(:,108), n3(:,154), t3x8(:,:,75))
  call prop_A_Q(ntry, wf8(:,108), 42, MT, 1_intkind1, wf8(:,109), n2(65))
  call counter_AV_Q(ntry, ex2(:), ex5(:), wf4(:,86), n3(:,155), t3x4(:,:,61))
  call prop_A_Q(ntry, wf4(:,86), 18, MT, 1_intkind1, wf4(:,87), n2(66))
  call vert_QA_V(ntry, wf2(:,2), wf4(:,87), wf8(:,110), n3(:,156), t3x8(:,:,76))
  call vert_AV_Q(ntry, wf4(:,87), ex6(:), wf8(:,111), n3(:,157), t3x8(:,:,77))
  call vert_AV_Q(ntry, wf4(:,87), ex4(:), wf8(:,112), n3(:,158), t3x8(:,:,78))
  call prop_A_Q(ntry, wf8(:,112), 26, MT, 1_intkind1, wf8(:,113), n2(67))
  call counter_AV_Q(ntry, ex2(:), ex4(:), wf4(:,88), n3(:,159), t3x4(:,:,62))
  call prop_A_Q(ntry, wf4(:,88), 10, MT, 1_intkind1, wf4(:,89), n2(68))
  call vert_QA_V(ntry, wf2(:,2), wf4(:,89), wf8(:,114), n3(:,160), t3x8(:,:,79))
  call vert_AV_Q(ntry, wf4(:,89), ex6(:), wf8(:,115), n3(:,161), t3x8(:,:,80))
  call vert_AV_Q(ntry, wf4(:,89), ex5(:), wf8(:,116), n3(:,162), t3x8(:,:,81))
  call prop_A_Q(ntry, wf8(:,116), 26, MT, 1_intkind1, wf8(:,117), n2(69))
  call vert_SA_Q(gH,ntry, ex3(:), wf4(:,85), wf4(:,90), n3(:,163), t3x4(:,:,63))
  call prop_A_Q(ntry, wf4(:,90), 38, MT, 1_intkind1, wf4(:,91), n2(70))
  call vert_SA_Q(gH,ntry, ex3(:), wf4(:,87), wf4(:,92), n3(:,164), t3x4(:,:,64))
  call prop_A_Q(ntry, wf4(:,92), 22, MT, 1_intkind1, wf4(:,93), n2(71))
  call vert_SA_Q(gH,ntry, ex3(:), wf4(:,89), wf4(:,94), n3(:,165), t3x4(:,:,65))
  call prop_A_Q(ntry, wf4(:,94), 14, MT, 1_intkind1, wf4(:,95), n2(72))
  call vert_QA_V(ntry, wf4(:,18), wf2(:,9), wf8(:,118), n3(:,166), t3x8(:,:,82))
  call vert_AV_Q(ntry, wf2(:,9), ex6(:), wf4(:,96), n3(:,167), t3x4(:,:,66))
  call vert_AV_Q(ntry, wf2(:,9), ex5(:), wf4(:,97), n3(:,168), t3x4(:,:,67))
  call prop_A_Q(ntry, wf4(:,97), 22, MT, 1_intkind1, wf4(:,98), n2(73))
  call vert_QA_V(ntry, wf4(:,23), wf2(:,9), wf8(:,119), n3(:,169), t3x8(:,:,83))
  call vert_AV_Q(ntry, wf2(:,9), ex4(:), wf4(:,99), n3(:,170), t3x4(:,:,68))
  call prop_A_Q(ntry, wf4(:,99), 14, MT, 1_intkind1, wf4(:,100), n2(74))
  call vert_QA_V(ntry, wf4(:,27), wf2(:,9), wf8(:,120), n3(:,171), t3x8(:,:,84))
  call counter_VQ_A(ntry, wf4(:,15), ex1(:), wf8(:,121), n3(:,172), t3x8(:,:,85))
  call counter_VQ_A(ntry, ex6(:), ex1(:), wf4(:,101), n3(:,173), t3x4(:,:,69))
  call prop_Q_A(ntry, wf4(:,101), 33, MT, 1_intkind1, wf4(:,102), n2(75))
  call vert_QA_V(ntry, wf4(:,102), wf2(:,4), wf8(:,122), n3(:,174), t3x8(:,:,86))
  call counter_VQ_A(ntry, wf4(:,10), ex1(:), wf8(:,123), n3(:,175), t3x8(:,:,87))
  call counter_VQ_A(ntry, wf4(:,4), ex1(:), wf8(:,124), n3(:,176), t3x8(:,:,88))
  call vert_VQ_A(ntry, ex4(:), wf4(:,102), wf8(:,125), n3(:,177), t3x8(:,:,89))
  call prop_Q_A(ntry, wf8(:,125), 41, MT, 1_intkind1, wf8(:,126), n2(76))
  call vert_VQ_A(ntry, ex5(:), wf4(:,102), wf8(:,127), n3(:,178), t3x8(:,:,90))
  call counter_VQ_A(ntry, ex5(:), ex1(:), wf4(:,103), n3(:,179), t3x4(:,:,70))
  call prop_Q_A(ntry, wf4(:,103), 17, MT, 1_intkind1, wf4(:,104), n2(77))
  call vert_QA_V(ntry, wf4(:,104), wf2(:,4), wf8(:,128), n3(:,180), t3x8(:,:,91))
  call vert_VQ_A(ntry, ex4(:), wf4(:,104), wf8(:,129), n3(:,181), t3x8(:,:,92))
  call prop_Q_A(ntry, wf8(:,129), 25, MT, 1_intkind1, wf8(:,130), n2(78))
  call vert_VQ_A(ntry, ex6(:), wf4(:,104), wf8(:,131), n3(:,182), t3x8(:,:,93))
  call counter_VQ_A(ntry, ex4(:), ex1(:), wf4(:,105), n3(:,183), t3x4(:,:,71))
  call prop_Q_A(ntry, wf4(:,105), 9, MT, 1_intkind1, wf4(:,106), n2(79))
  call vert_QA_V(ntry, wf4(:,106), wf2(:,4), wf8(:,132), n3(:,184), t3x8(:,:,94))
  call vert_VQ_A(ntry, ex5(:), wf4(:,106), wf8(:,133), n3(:,185), t3x8(:,:,95))
  call prop_Q_A(ntry, wf8(:,133), 25, MT, 1_intkind1, wf8(:,134), n2(80))
  call vert_VQ_A(ntry, ex6(:), wf4(:,106), wf8(:,135), n3(:,186), t3x8(:,:,96))
  call vert_QS_A(gH,ntry, wf4(:,102), ex3(:), wf4(:,107), n3(:,187), t3x4(:,:,72))
  call prop_Q_A(ntry, wf4(:,107), 37, MT, 1_intkind1, wf4(:,108), n2(81))
  call vert_QS_A(gH,ntry, wf4(:,104), ex3(:), wf4(:,109), n3(:,188), t3x4(:,:,73))
  call prop_Q_A(ntry, wf4(:,109), 21, MT, 1_intkind1, wf4(:,110), n2(82))
  call vert_QS_A(gH,ntry, wf4(:,106), ex3(:), wf4(:,111), n3(:,189), t3x4(:,:,74))
  call prop_Q_A(ntry, wf4(:,111), 13, MT, 1_intkind1, wf4(:,112), n2(83))
  call vert_QA_V(ntry, wf2(:,11), wf4(:,5), wf8(:,136), n3(:,190), t3x8(:,:,97))
  call vert_VQ_A(ntry, ex5(:), wf2(:,11), wf4(:,113), n3(:,191), t3x4(:,:,75))
  call prop_Q_A(ntry, wf4(:,113), 21, MT, 1_intkind1, wf4(:,114), n2(84))
  call vert_VQ_A(ntry, ex6(:), wf2(:,11), wf4(:,115), n3(:,192), t3x4(:,:,76))
  call vert_QA_V(ntry, wf2(:,11), wf4(:,11), wf8(:,137), n3(:,193), t3x8(:,:,98))
  call vert_VQ_A(ntry, ex4(:), wf2(:,11), wf4(:,116), n3(:,194), t3x4(:,:,77))
  call prop_Q_A(ntry, wf4(:,116), 13, MT, 1_intkind1, wf4(:,117), n2(85))
  call vert_QA_V(ntry, wf2(:,11), wf4(:,16), wf8(:,138), n3(:,195), t3x8(:,:,99))
  call vert_AV_Q(ntry, wf4(:,5), wf4(:,4), wf16(:,28), n3(:,196), t3x16(:,:,13))
  call prop_A_Q(ntry, wf16(:,28), 58, MT, 1_intkind1, wf16(:,29), n2(86))
  call vert_VQ_A(ntry, wf4(:,4), wf2(:,2), wf8(:,139), n3(:,197), t3x8(:,:,100))
  call counter_A_Q(cttt,6,ntry, wf4(:,5), 10, wf4(:,118), n2(87))
  call prop_Q_A(ntry, wf8(:,139), 53, MT, 1_intkind1, wf8(:,140), n2(88))
  call counter_V_V(ctGG,21,ntry, wf4(:,4), 48, wf4(:,119), n2(89))
  call prop_Q_A(ntry, wf2(:,12), 5, MT, 1_intkind1, wf2(:,14), n2(90))
  call vert_VQ_A(ntry, ex5(:), wf2(:,14), wf4(:,120), n3(:,198), t3x4(:,:,78))
  call vert_VQ_A(ntry, ex6(:), wf2(:,14), wf4(:,121), n3(:,199), t3x4(:,:,79))
  call prop_A_Q(ntry, wf4(:,118), 10, MT, 1_intkind1, wf4(:,122), n2(91))
  call vert_AV_Q(ntry, wf4(:,122), ex5(:), wf8(:,141), n3(:,200), t3x8(:,:,101))
  call vert_AV_Q(ntry, wf4(:,122), ex6(:), wf8(:,142), n3(:,201), t3x8(:,:,102))
  call counter_Q_A(cttt,6,ntry, wf4(:,7), 21, wf4(:,123), n2(92))
  call counter_A_Q(cttt,6,ntry, wf8(:,7), 26, wf8(:,143), n2(93))
  call vert_AV_Q(ntry, wf4(:,11), wf4(:,10), wf16(:,30), n3(:,202), t3x16(:,:,14))
  call prop_A_Q(ntry, wf16(:,30), 58, MT, 1_intkind1, wf16(:,31), n2(94))
  call vert_VQ_A(ntry, wf4(:,10), wf2(:,2), wf8(:,144), n3(:,203), t3x8(:,:,103))
  call counter_A_Q(cttt,6,ntry, wf4(:,11), 18, wf4(:,124), n2(95))
  call prop_Q_A(ntry, wf8(:,144), 45, MT, 1_intkind1, wf8(:,145), n2(96))
  call counter_V_V(ctGG,21,ntry, wf4(:,10), 40, wf4(:,125), n2(97))
  call vert_VQ_A(ntry, ex4(:), wf2(:,14), wf4(:,126), n3(:,204), t3x4(:,:,80))
  call prop_A_Q(ntry, wf4(:,124), 18, MT, 1_intkind1, wf4(:,127), n2(98))
  call vert_AV_Q(ntry, wf4(:,127), ex4(:), wf8(:,146), n3(:,205), t3x8(:,:,104))
  call vert_AV_Q(ntry, wf4(:,127), ex6(:), wf8(:,147), n3(:,206), t3x8(:,:,105))
  call counter_Q_A(cttt,6,ntry, wf4(:,13), 13, wf4(:,128), n2(99))
  call counter_A_Q(cttt,6,ntry, wf8(:,11), 26, wf8(:,148), n2(100))
  call vert_AV_Q(ntry, wf4(:,16), wf4(:,15), wf16(:,32), n3(:,207), t3x16(:,:,15))
  call prop_A_Q(ntry, wf16(:,32), 58, MT, 1_intkind1, wf16(:,33), n2(101))
  call vert_VQ_A(ntry, wf4(:,15), wf2(:,2), wf8(:,149), n3(:,208), t3x8(:,:,106))
  call counter_A_Q(cttt,6,ntry, wf4(:,16), 34, wf4(:,129), n2(102))
  call prop_Q_A(ntry, wf8(:,149), 29, MT, 1_intkind1, wf8(:,150), n2(103))
  call counter_V_V(ctGG,21,ntry, wf4(:,15), 24, wf4(:,130), n2(104))
  call vert_QA_V(ntry, wf2(:,14), ex2(:), wf4(:,131), n3(:,209), t3x4(:,:,81))
  call vert_AV_Q(ntry, ex2(:), wf4(:,130), wf8(:,151), n3(:,210), t3x8(:,:,107))
  call counter_V_V(ctGG,21,ntry, wf4(:,1), 7, wf4(:,132), n2(105))
  call counter_A_Q(cttt,6,ntry, wf8(:,15), 26, wf8(:,152), n2(106))
  call vert_UV_W(ntry, wf4(:,130), 24, ex6(:), 32, wf8(:,153), n3(:,211), t3x8(:,:,108))
  call prop_A_Q(ntry, wf4(:,129), 34, MT, 1_intkind1, wf4(:,133), n2(107))
  call vert_AV_Q(ntry, wf4(:,133), ex4(:), wf8(:,154), n3(:,212), t3x8(:,:,109))
  call vert_AV_Q(ntry, wf4(:,133), ex5(:), wf8(:,155), n3(:,213), t3x8(:,:,110))
  call counter_A_Q(cttt,6,ntry, wf8(:,18), 42, wf8(:,156), n2(108))
  call vert_AV_Q(ntry, ex2(:), wf4(:,125), wf8(:,157), n3(:,214), t3x8(:,:,111))
  call counter_A_Q(cttt,6,ntry, wf8(:,21), 42, wf8(:,158), n2(109))
  call vert_UV_W(ntry, ex5(:), 16, wf4(:,125), 40, wf8(:,159), n3(:,215), t3x8(:,:,112))
  call counter_A_Q(cttt,6,ntry, wf8(:,24), 50, wf8(:,160), n2(110))
  call vert_AV_Q(ntry, ex2(:), wf4(:,119), wf8(:,161), n3(:,216), t3x8(:,:,113))
  call vert_UV_W(ntry, ex4(:), 8, wf4(:,119), 48, wf8(:,162), n3(:,217), t3x8(:,:,114))
  call vert_AV_Q(ntry, wf2(:,4), wf4(:,4), wf8(:,163), n3(:,218), t3x8(:,:,115))
  call counter_Q_A(cttt,6,ntry, wf4(:,18), 9, wf4(:,134), n2(111))
  call prop_A_Q(ntry, wf8(:,163), 54, MT, 1_intkind1, wf8(:,164), n2(112))
  call vert_VQ_A(ntry, wf4(:,4), wf4(:,18), wf16(:,34), n3(:,219), t3x16(:,:,16))
  call prop_Q_A(ntry, wf16(:,34), 57, MT, 1_intkind1, wf16(:,35), n2(113))
  call prop_Q_A(ntry, wf4(:,134), 9, MT, 1_intkind1, wf4(:,135), n2(114))
  call vert_VQ_A(ntry, ex5(:), wf4(:,135), wf8(:,165), n3(:,220), t3x8(:,:,116))
  call vert_VQ_A(ntry, ex6(:), wf4(:,135), wf8(:,166), n3(:,221), t3x8(:,:,117))
  call prop_A_Q(ntry, wf2(:,13), 6, MT, 1_intkind1, wf2(:,15), n2(115))
  call vert_AV_Q(ntry, wf2(:,15), ex5(:), wf4(:,136), n3(:,222), t3x4(:,:,82))
  call vert_AV_Q(ntry, wf2(:,15), ex6(:), wf4(:,137), n3(:,223), t3x4(:,:,83))
  call counter_Q_A(cttt,6,ntry, wf8(:,27), 25, wf8(:,167), n2(116))
  call counter_A_Q(cttt,6,ntry, wf4(:,21), 22, wf4(:,138), n2(117))
  call vert_AV_Q(ntry, wf2(:,4), wf4(:,10), wf8(:,168), n3(:,224), t3x8(:,:,118))
  call counter_Q_A(cttt,6,ntry, wf4(:,23), 17, wf4(:,139), n2(118))
  call prop_A_Q(ntry, wf8(:,168), 46, MT, 1_intkind1, wf8(:,169), n2(119))
  call vert_VQ_A(ntry, wf4(:,10), wf4(:,23), wf16(:,36), n3(:,225), t3x16(:,:,17))
  call prop_Q_A(ntry, wf16(:,36), 57, MT, 1_intkind1, wf16(:,37), n2(120))
  call prop_Q_A(ntry, wf4(:,139), 17, MT, 1_intkind1, wf4(:,140), n2(121))
  call vert_VQ_A(ntry, ex4(:), wf4(:,140), wf8(:,170), n3(:,226), t3x8(:,:,119))
  call vert_VQ_A(ntry, ex6(:), wf4(:,140), wf8(:,171), n3(:,227), t3x8(:,:,120))
  call vert_AV_Q(ntry, wf2(:,15), ex4(:), wf4(:,141), n3(:,228), t3x4(:,:,84))
  call counter_Q_A(cttt,6,ntry, wf8(:,31), 25, wf8(:,172), n2(122))
  call counter_A_Q(cttt,6,ntry, wf4(:,25), 14, wf4(:,142), n2(123))
  call vert_AV_Q(ntry, wf2(:,4), wf4(:,15), wf8(:,173), n3(:,229), t3x8(:,:,121))
  call counter_Q_A(cttt,6,ntry, wf4(:,27), 33, wf4(:,143), n2(124))
  call prop_A_Q(ntry, wf8(:,173), 30, MT, 1_intkind1, wf8(:,174), n2(125))
  call vert_VQ_A(ntry, wf4(:,15), wf4(:,27), wf16(:,38), n3(:,230), t3x16(:,:,18))
  call prop_Q_A(ntry, wf16(:,38), 57, MT, 1_intkind1, wf16(:,39), n2(126))
  call vert_QA_V(ntry, ex1(:), wf2(:,15), wf4(:,144), n3(:,231), t3x4(:,:,85))
  call vert_VQ_A(ntry, wf4(:,130), ex1(:), wf8(:,175), n3(:,232), t3x8(:,:,122))
  call counter_V_V(ctGG,21,ntry, wf4(:,2), 7, wf4(:,145), n2(127))
  call counter_Q_A(cttt,6,ntry, wf8(:,35), 25, wf8(:,176), n2(128))
  call prop_Q_A(ntry, wf4(:,143), 33, MT, 1_intkind1, wf4(:,146), n2(129))
  call vert_VQ_A(ntry, ex4(:), wf4(:,146), wf8(:,177), n3(:,233), t3x8(:,:,123))
  call vert_VQ_A(ntry, ex5(:), wf4(:,146), wf8(:,178), n3(:,234), t3x8(:,:,124))
  call counter_Q_A(cttt,6,ntry, wf8(:,37), 41, wf8(:,179), n2(130))
  call vert_VQ_A(ntry, wf4(:,125), ex1(:), wf8(:,180), n3(:,235), t3x8(:,:,125))
  call counter_Q_A(cttt,6,ntry, wf8(:,40), 41, wf8(:,181), n2(131))
  call counter_Q_A(cttt,6,ntry, wf8(:,42), 49, wf8(:,182), n2(132))
  call vert_VQ_A(ntry, wf4(:,119), ex1(:), wf8(:,183), n3(:,236), t3x8(:,:,126))
  call vert_QS_A(gH,ntry, wf4(:,135), ex3(:), wf4(:,147), n3(:,237), t3x4(:,:,86))
  call vert_SA_Q(gH,ntry, ex3(:), wf4(:,127), wf4(:,148), n3(:,238), t3x4(:,:,87))
  call counter_Q_A(cttt,6,ntry, wf4(:,29), 13, wf4(:,149), n2(133))
  call counter_A_Q(cttt,6,ntry, wf4(:,31), 22, wf4(:,150), n2(134))
  call vert_SA_Q(gH,ntry, ex3(:), wf4(:,133), wf4(:,151), n3(:,239), t3x4(:,:,88))
  call counter_A_Q(cttt,6,ntry, wf4(:,33), 38, wf4(:,152), n2(135))
  call vert_QS_A(gH,ntry, wf4(:,140), ex3(:), wf4(:,153), n3(:,240), t3x4(:,:,89))
  call vert_SA_Q(gH,ntry, ex3(:), wf4(:,122), wf4(:,154), n3(:,241), t3x4(:,:,90))
  call counter_Q_A(cttt,6,ntry, wf4(:,35), 21, wf4(:,155), n2(136))
  call counter_A_Q(cttt,6,ntry, wf4(:,37), 14, wf4(:,156), n2(137))
  call vert_QS_A(gH,ntry, wf4(:,146), ex3(:), wf4(:,157), n3(:,242), t3x4(:,:,91))
  call counter_Q_A(cttt,6,ntry, wf4(:,39), 37, wf4(:,158), n2(138))
  call vert_UV_W(ntry, wf4(:,40), 3, wf4(:,15), 24, wf16(:,40), n3(:,243), t3x16(:,:,19))
  call vert_UV_W(ntry, wf4(:,40), 3, wf4(:,10), 40, wf16(:,41), n3(:,244), t3x16(:,:,20))
  call vert_UV_W(ntry, wf4(:,40), 3, wf4(:,4), 48, wf16(:,42), n3(:,245), t3x16(:,:,21))
  call vert_UV_W(ntry, wf8(:,49), 11, ex5(:), 16, wf16(:,43), n3(:,246), t3x16(:,:,22))
  call vert_UV_W(ntry, wf8(:,49), 11, ex6(:), 32, wf16(:,44), n3(:,247), t3x16(:,:,23))
  call vert_UV_W(ntry, ex4(:), 8, wf8(:,48), 19, wf16(:,45), n3(:,248), t3x16(:,:,24))
  call vert_UV_W(ntry, wf8(:,48), 19, ex6(:), 32, wf16(:,46), n3(:,249), t3x16(:,:,25))
  call vert_UV_W(ntry, ex4(:), 8, wf8(:,46), 35, wf16(:,47), n3(:,250), t3x16(:,:,26))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,46), 35, wf16(:,48), n3(:,251), t3x16(:,:,27))
  call vert_UV_W(ntry, wf4(:,1), 7, ex4(:), 8, wf8(:,184), n3(:,252), t3x8(:,:,127))
  call vert_UV_W(ntry, wf4(:,1), 7, ex5(:), 16, wf8(:,185), n3(:,253), t3x8(:,:,128))
  call vert_UV_W(ntry, wf4(:,1), 7, ex6(:), 32, wf8(:,186), n3(:,254), t3x8(:,:,129))
  call vert_QA_V(ntry, wf4(:,13), ex2(:), wf8(:,187), n3(:,255), t3x8(:,:,130))
  call vert_VQ_A(ntry, ex5(:), wf4(:,13), wf8(:,188), n3(:,256), t3x8(:,:,131))
  call prop_Q_A(ntry, wf8(:,188), 29, MT, 1_intkind1, wf8(:,189), n2(139))
  call vert_VQ_A(ntry, ex6(:), wf4(:,13), wf8(:,190), n3(:,257), t3x8(:,:,132))
  call prop_Q_A(ntry, wf8(:,190), 45, MT, 1_intkind1, wf8(:,191), n2(140))
  call vert_QA_V(ntry, wf4(:,7), ex2(:), wf8(:,192), n3(:,258), t3x8(:,:,133))
  call vert_VQ_A(ntry, ex4(:), wf4(:,7), wf8(:,193), n3(:,259), t3x8(:,:,134))
  call prop_Q_A(ntry, wf8(:,193), 29, MT, 1_intkind1, wf8(:,194), n2(141))
  call vert_VQ_A(ntry, ex6(:), wf4(:,7), wf8(:,195), n3(:,260), t3x8(:,:,135))
  call prop_Q_A(ntry, wf8(:,195), 53, MT, 1_intkind1, wf8(:,196), n2(142))
  call vert_QA_V(ntry, wf4(:,56), ex2(:), wf8(:,197), n3(:,261), t3x8(:,:,136))
  call vert_VQ_A(ntry, ex4(:), wf4(:,56), wf8(:,198), n3(:,262), t3x8(:,:,137))
  call prop_Q_A(ntry, wf8(:,198), 45, MT, 1_intkind1, wf8(:,199), n2(143))
  call vert_VQ_A(ntry, ex5(:), wf4(:,56), wf8(:,200), n3(:,263), t3x8(:,:,138))
  call prop_Q_A(ntry, wf8(:,200), 53, MT, 1_intkind1, wf8(:,201), n2(144))
  call vert_UV_W(ntry, wf4(:,2), 7, ex4(:), 8, wf8(:,202), n3(:,264), t3x8(:,:,139))
  call vert_UV_W(ntry, wf4(:,2), 7, ex5(:), 16, wf8(:,203), n3(:,265), t3x8(:,:,140))
  call vert_UV_W(ntry, wf4(:,2), 7, ex6(:), 32, wf8(:,204), n3(:,266), t3x8(:,:,141))
  call vert_QA_V(ntry, ex1(:), wf4(:,25), wf8(:,205), n3(:,267), t3x8(:,:,142))
  call vert_QA_V(ntry, ex1(:), wf4(:,21), wf8(:,206), n3(:,268), t3x8(:,:,143))
  call vert_QA_V(ntry, ex1(:), wf4(:,64), wf8(:,207), n3(:,269), t3x8(:,:,144))
  call vert_AV_Q(ntry, wf4(:,25), ex5(:), wf8(:,208), n3(:,270), t3x8(:,:,145))
  call prop_A_Q(ntry, wf8(:,208), 30, MT, 1_intkind1, wf8(:,209), n2(145))
  call vert_AV_Q(ntry, wf4(:,25), ex6(:), wf8(:,210), n3(:,271), t3x8(:,:,146))
  call prop_A_Q(ntry, wf8(:,210), 46, MT, 1_intkind1, wf8(:,211), n2(146))
  call vert_AV_Q(ntry, wf4(:,21), ex4(:), wf8(:,212), n3(:,272), t3x8(:,:,147))
  call prop_A_Q(ntry, wf8(:,212), 30, MT, 1_intkind1, wf8(:,213), n2(147))
  call vert_AV_Q(ntry, wf4(:,21), ex6(:), wf8(:,214), n3(:,273), t3x8(:,:,148))
  call prop_A_Q(ntry, wf8(:,214), 54, MT, 1_intkind1, wf8(:,215), n2(148))
  call vert_AV_Q(ntry, wf4(:,64), ex4(:), wf8(:,216), n3(:,274), t3x8(:,:,149))
  call prop_A_Q(ntry, wf8(:,216), 46, MT, 1_intkind1, wf8(:,217), n2(149))
  call vert_AV_Q(ntry, wf4(:,64), ex5(:), wf8(:,218), n3(:,275), t3x8(:,:,150))
  call prop_A_Q(ntry, wf8(:,218), 54, MT, 1_intkind1, wf8(:,219), n2(150))
  call vert_UV_W(ntry, wf8(:,97), 11, ex5(:), 16, wf16(:,49), n3(:,276), t3x16(:,:,28))
  call vert_UV_W(ntry, wf8(:,97), 11, ex6(:), 32, wf16(:,50), n3(:,277), t3x16(:,:,29))
  call vert_QA_V(ntry, wf4(:,29), ex2(:), wf8(:,220), n3(:,278), t3x8(:,:,151))
  call vert_VQ_A(ntry, ex5(:), wf4(:,29), wf8(:,221), n3(:,279), t3x8(:,:,152))
  call prop_Q_A(ntry, wf8(:,221), 29, MT, 1_intkind1, wf8(:,222), n2(151))
  call vert_VQ_A(ntry, ex6(:), wf4(:,29), wf8(:,223), n3(:,280), t3x8(:,:,153))
  call prop_Q_A(ntry, wf8(:,223), 45, MT, 1_intkind1, wf8(:,224), n2(152))
  call vert_QA_V(ntry, wf8(:,27), ex2(:), wf16(:,51), n3(:,281), t3x16(:,:,30))
  call vert_QS_A(gH,ntry, wf8(:,27), ex3(:), wf8(:,225), n3(:,282), t3x8(:,:,154))
  call prop_Q_A(ntry, wf8(:,225), 29, MT, 1_intkind1, wf8(:,226), n2(153))
  call vert_VQ_A(ntry, ex6(:), wf8(:,27), wf16(:,52), n3(:,283), t3x16(:,:,31))
  call prop_Q_A(ntry, wf16(:,52), 57, MT, 1_intkind1, wf16(:,53), n2(154))
  call vert_QA_V(ntry, wf8(:,81), ex2(:), wf16(:,54), n3(:,284), t3x16(:,:,32))
  call vert_QS_A(gH,ntry, wf8(:,81), ex3(:), wf8(:,227), n3(:,285), t3x8(:,:,155))
  call prop_Q_A(ntry, wf8(:,227), 45, MT, 1_intkind1, wf8(:,228), n2(155))
  call vert_VQ_A(ntry, ex5(:), wf8(:,81), wf16(:,55), n3(:,286), t3x16(:,:,33))
  call prop_Q_A(ntry, wf16(:,55), 57, MT, 1_intkind1, wf16(:,56), n2(156))
  call vert_UV_W(ntry, wf8(:,98), 11, ex5(:), 16, wf16(:,57), n3(:,287), t3x16(:,:,34))
  call vert_UV_W(ntry, wf8(:,98), 11, ex6(:), 32, wf16(:,58), n3(:,288), t3x16(:,:,35))
  call vert_QA_V(ntry, ex1(:), wf4(:,37), wf8(:,229), n3(:,289), t3x8(:,:,156))
  call vert_QA_V(ntry, ex1(:), wf8(:,7), wf16(:,59), n3(:,290), t3x16(:,:,36))
  call vert_QA_V(ntry, ex1(:), wf8(:,55), wf16(:,60), n3(:,291), t3x16(:,:,37))
  call vert_AV_Q(ntry, wf4(:,37), ex5(:), wf8(:,230), n3(:,292), t3x8(:,:,157))
  call prop_A_Q(ntry, wf8(:,230), 30, MT, 1_intkind1, wf8(:,231), n2(157))
  call vert_AV_Q(ntry, wf4(:,37), ex6(:), wf8(:,232), n3(:,293), t3x8(:,:,158))
  call prop_A_Q(ntry, wf8(:,232), 46, MT, 1_intkind1, wf8(:,233), n2(158))
  call vert_SA_Q(gH,ntry, ex3(:), wf8(:,7), wf8(:,234), n3(:,294), t3x8(:,:,159))
  call prop_A_Q(ntry, wf8(:,234), 30, MT, 1_intkind1, wf8(:,235), n2(159))
  call vert_AV_Q(ntry, wf8(:,7), ex6(:), wf16(:,61), n3(:,295), t3x16(:,:,38))
  call prop_A_Q(ntry, wf16(:,61), 58, MT, 1_intkind1, wf16(:,62), n2(160))
  call vert_SA_Q(gH,ntry, ex3(:), wf8(:,55), wf8(:,236), n3(:,296), t3x8(:,:,160))
  call prop_A_Q(ntry, wf8(:,236), 46, MT, 1_intkind1, wf8(:,237), n2(161))
  call vert_AV_Q(ntry, wf8(:,55), ex5(:), wf16(:,63), n3(:,297), t3x16(:,:,39))
  call prop_A_Q(ntry, wf16(:,63), 58, MT, 1_intkind1, wf16(:,64), n2(162))
  call vert_UV_W(ntry, ex4(:), 8, wf8(:,99), 19, wf16(:,65), n3(:,298), t3x16(:,:,40))
  call vert_UV_W(ntry, wf8(:,99), 19, ex6(:), 32, wf16(:,66), n3(:,299), t3x16(:,:,41))
  call vert_QA_V(ntry, wf4(:,35), ex2(:), wf8(:,238), n3(:,300), t3x8(:,:,161))
  call vert_VQ_A(ntry, ex4(:), wf4(:,35), wf8(:,239), n3(:,301), t3x8(:,:,162))
  call prop_Q_A(ntry, wf8(:,239), 29, MT, 1_intkind1, wf8(:,240), n2(163))
  call vert_VQ_A(ntry, ex6(:), wf4(:,35), wf8(:,241), n3(:,302), t3x8(:,:,163))
  call prop_Q_A(ntry, wf8(:,241), 53, MT, 1_intkind1, wf8(:,242), n2(164))
  call vert_QA_V(ntry, wf8(:,31), ex2(:), wf16(:,67), n3(:,303), t3x16(:,:,42))
  call vert_QS_A(gH,ntry, wf8(:,31), ex3(:), wf8(:,243), n3(:,304), t3x8(:,:,164))
  call prop_Q_A(ntry, wf8(:,243), 29, MT, 1_intkind1, wf8(:,244), n2(165))
  call vert_VQ_A(ntry, ex6(:), wf8(:,31), wf16(:,68), n3(:,305), t3x16(:,:,43))
  call prop_Q_A(ntry, wf16(:,68), 57, MT, 1_intkind1, wf16(:,69), n2(166))
  call vert_QA_V(ntry, wf8(:,89), ex2(:), wf16(:,70), n3(:,306), t3x16(:,:,44))
  call vert_QS_A(gH,ntry, wf8(:,89), ex3(:), wf8(:,245), n3(:,307), t3x8(:,:,165))
  call prop_Q_A(ntry, wf8(:,245), 53, MT, 1_intkind1, wf8(:,246), n2(167))
  call vert_VQ_A(ntry, ex4(:), wf8(:,89), wf16(:,71), n3(:,308), t3x16(:,:,45))
  call prop_Q_A(ntry, wf16(:,71), 57, MT, 1_intkind1, wf16(:,72), n2(168))
  call vert_UV_W(ntry, ex4(:), 8, wf8(:,100), 19, wf16(:,73), n3(:,309), t3x16(:,:,46))
  call vert_UV_W(ntry, wf8(:,100), 19, ex6(:), 32, wf16(:,74), n3(:,310), t3x16(:,:,47))
  call vert_QA_V(ntry, ex1(:), wf4(:,31), wf8(:,247), n3(:,311), t3x8(:,:,166))
  call vert_QA_V(ntry, ex1(:), wf8(:,11), wf16(:,75), n3(:,312), t3x16(:,:,48))
  call vert_QA_V(ntry, ex1(:), wf8(:,69), wf16(:,76), n3(:,313), t3x16(:,:,49))
  call vert_AV_Q(ntry, wf4(:,31), ex4(:), wf8(:,248), n3(:,314), t3x8(:,:,167))
  call prop_A_Q(ntry, wf8(:,248), 30, MT, 1_intkind1, wf8(:,249), n2(169))
  call vert_AV_Q(ntry, wf4(:,31), ex6(:), wf8(:,250), n3(:,315), t3x8(:,:,168))
  call prop_A_Q(ntry, wf8(:,250), 54, MT, 1_intkind1, wf8(:,251), n2(170))
  call vert_SA_Q(gH,ntry, ex3(:), wf8(:,11), wf8(:,252), n3(:,316), t3x8(:,:,169))
  call prop_A_Q(ntry, wf8(:,252), 30, MT, 1_intkind1, wf8(:,253), n2(171))
  call vert_AV_Q(ntry, wf8(:,11), ex6(:), wf16(:,77), n3(:,317), t3x16(:,:,50))
  call prop_A_Q(ntry, wf16(:,77), 58, MT, 1_intkind1, wf16(:,78), n2(172))
  call vert_SA_Q(gH,ntry, ex3(:), wf8(:,69), wf8(:,254), n3(:,318), t3x8(:,:,170))
  call prop_A_Q(ntry, wf8(:,254), 54, MT, 1_intkind1, wf8(:,255), n2(173))
  call vert_AV_Q(ntry, wf8(:,69), ex4(:), wf16(:,79), n3(:,319), t3x16(:,:,51))
  call prop_A_Q(ntry, wf16(:,79), 58, MT, 1_intkind1, wf16(:,80), n2(174))
  call vert_QA_V(ntry, wf8(:,35), ex2(:), wf16(:,81), n3(:,320), t3x16(:,:,52))
  call vert_QA_V(ntry, ex1(:), wf8(:,15), wf16(:,82), n3(:,321), t3x16(:,:,53))
  call vert_QS_A(gH,ntry, wf8(:,35), ex3(:), wf8(:,256), n3(:,322), t3x8(:,:,171))
  call prop_Q_A(ntry, wf8(:,256), 29, MT, 1_intkind1, wf8(:,257), n2(175))
  call vert_VQ_A(ntry, ex6(:), wf8(:,35), wf16(:,83), n3(:,323), t3x16(:,:,54))
  call prop_Q_A(ntry, wf16(:,83), 57, MT, 1_intkind1, wf16(:,84), n2(176))
  call vert_VQ_A(ntry, wf8(:,13), ex1(:), wf16(:,85), n3(:,324), t3x16(:,:,55))
  call prop_Q_A(ntry, wf16(:,85), 57, MT, 1_intkind1, wf16(:,86), n2(177))
  call vert_SA_Q(gH,ntry, ex3(:), wf8(:,15), wf8(:,258), n3(:,325), t3x8(:,:,172))
  call prop_A_Q(ntry, wf8(:,258), 30, MT, 1_intkind1, wf8(:,259), n2(178))
  call vert_AV_Q(ntry, wf8(:,15), ex6(:), wf16(:,87), n3(:,326), t3x16(:,:,56))
  call prop_A_Q(ntry, wf16(:,87), 58, MT, 1_intkind1, wf16(:,88), n2(179))
  call vert_AV_Q(ntry, ex2(:), wf8(:,13), wf16(:,89), n3(:,327), t3x16(:,:,57))
  call prop_A_Q(ntry, wf16(:,89), 58, MT, 1_intkind1, wf16(:,90), n2(180))
  call vert_UV_W(ntry, ex4(:), 8, wf8(:,101), 35, wf16(:,91), n3(:,328), t3x16(:,:,58))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,101), 35, wf16(:,92), n3(:,329), t3x16(:,:,59))
  call vert_QA_V(ntry, wf4(:,39), ex2(:), wf8(:,260), n3(:,330), t3x8(:,:,173))
  call vert_VQ_A(ntry, ex4(:), wf4(:,39), wf8(:,261), n3(:,331), t3x8(:,:,174))
  call prop_Q_A(ntry, wf8(:,261), 45, MT, 1_intkind1, wf8(:,262), n2(181))
  call vert_VQ_A(ntry, ex5(:), wf4(:,39), wf8(:,263), n3(:,332), t3x8(:,:,175))
  call prop_Q_A(ntry, wf8(:,263), 53, MT, 1_intkind1, wf8(:,264), n2(182))
  call vert_QA_V(ntry, wf8(:,37), ex2(:), wf16(:,93), n3(:,333), t3x16(:,:,60))
  call vert_QS_A(gH,ntry, wf8(:,37), ex3(:), wf8(:,265), n3(:,334), t3x8(:,:,176))
  call prop_Q_A(ntry, wf8(:,265), 45, MT, 1_intkind1, wf8(:,266), n2(183))
  call vert_VQ_A(ntry, ex5(:), wf8(:,37), wf16(:,94), n3(:,335), t3x16(:,:,61))
  call prop_Q_A(ntry, wf16(:,94), 57, MT, 1_intkind1, wf16(:,95), n2(184))
  call vert_QA_V(ntry, wf8(:,91), ex2(:), wf16(:,96), n3(:,336), t3x16(:,:,62))
  call vert_QS_A(gH,ntry, wf8(:,91), ex3(:), wf8(:,267), n3(:,337), t3x8(:,:,177))
  call prop_Q_A(ntry, wf8(:,267), 53, MT, 1_intkind1, wf8(:,268), n2(185))
  call vert_VQ_A(ntry, ex4(:), wf8(:,91), wf16(:,97), n3(:,338), t3x16(:,:,63))
  call prop_Q_A(ntry, wf16(:,97), 57, MT, 1_intkind1, wf16(:,98), n2(186))
  call vert_UV_W(ntry, ex4(:), 8, wf8(:,102), 35, wf16(:,99), n3(:,339), t3x16(:,:,64))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,102), 35, wf16(:,100), n3(:,340), t3x16(:,:,65))
  call vert_QA_V(ntry, ex1(:), wf4(:,33), wf8(:,269), n3(:,341), t3x8(:,:,178))
  call vert_QA_V(ntry, ex1(:), wf8(:,18), wf16(:,101), n3(:,342), t3x16(:,:,66))
  call vert_QA_V(ntry, ex1(:), wf8(:,71), wf16(:,102), n3(:,343), t3x16(:,:,67))
  call vert_AV_Q(ntry, wf4(:,33), ex4(:), wf8(:,270), n3(:,344), t3x8(:,:,179))
  call prop_A_Q(ntry, wf8(:,270), 46, MT, 1_intkind1, wf8(:,271), n2(187))
  call vert_AV_Q(ntry, wf4(:,33), ex5(:), wf8(:,272), n3(:,345), t3x8(:,:,180))
  call prop_A_Q(ntry, wf8(:,272), 54, MT, 1_intkind1, wf8(:,273), n2(188))
  call vert_SA_Q(gH,ntry, ex3(:), wf8(:,18), wf8(:,274), n3(:,346), t3x8(:,:,181))
  call prop_A_Q(ntry, wf8(:,274), 46, MT, 1_intkind1, wf8(:,275), n2(189))
  call vert_AV_Q(ntry, wf8(:,18), ex5(:), wf16(:,103), n3(:,347), t3x16(:,:,68))
  call prop_A_Q(ntry, wf16(:,103), 58, MT, 1_intkind1, wf16(:,104), n2(190))
  call vert_SA_Q(gH,ntry, ex3(:), wf8(:,71), wf8(:,276), n3(:,348), t3x8(:,:,182))
  call prop_A_Q(ntry, wf8(:,276), 54, MT, 1_intkind1, wf8(:,277), n2(191))
  call vert_AV_Q(ntry, wf8(:,71), ex4(:), wf16(:,105), n3(:,349), t3x16(:,:,69))
  call prop_A_Q(ntry, wf16(:,105), 58, MT, 1_intkind1, wf16(:,106), n2(192))
  call vert_QA_V(ntry, wf8(:,40), ex2(:), wf16(:,107), n3(:,350), t3x16(:,:,70))
  call vert_QA_V(ntry, ex1(:), wf8(:,21), wf16(:,108), n3(:,351), t3x16(:,:,71))
  call vert_QS_A(gH,ntry, wf8(:,40), ex3(:), wf8(:,278), n3(:,352), t3x8(:,:,183))
  call prop_Q_A(ntry, wf8(:,278), 45, MT, 1_intkind1, wf8(:,279), n2(193))
  call vert_VQ_A(ntry, ex5(:), wf8(:,40), wf16(:,109), n3(:,353), t3x16(:,:,72))
  call prop_Q_A(ntry, wf16(:,109), 57, MT, 1_intkind1, wf16(:,110), n2(194))
  call vert_VQ_A(ntry, wf8(:,19), ex1(:), wf16(:,111), n3(:,354), t3x16(:,:,73))
  call prop_Q_A(ntry, wf16(:,111), 57, MT, 1_intkind1, wf16(:,112), n2(195))
  call vert_SA_Q(gH,ntry, ex3(:), wf8(:,21), wf8(:,280), n3(:,355), t3x8(:,:,184))
  call prop_A_Q(ntry, wf8(:,280), 46, MT, 1_intkind1, wf8(:,281), n2(196))
  call vert_AV_Q(ntry, wf8(:,21), ex5(:), wf16(:,113), n3(:,356), t3x16(:,:,74))
  call prop_A_Q(ntry, wf16(:,113), 58, MT, 1_intkind1, wf16(:,114), n2(197))
  call vert_AV_Q(ntry, ex2(:), wf8(:,19), wf16(:,115), n3(:,357), t3x16(:,:,75))
  call prop_A_Q(ntry, wf16(:,115), 58, MT, 1_intkind1, wf16(:,116), n2(198))
  call vert_QA_V(ntry, wf8(:,42), ex2(:), wf16(:,117), n3(:,358), t3x16(:,:,76))
  call vert_QA_V(ntry, ex1(:), wf8(:,24), wf16(:,118), n3(:,359), t3x16(:,:,77))
  call vert_QS_A(gH,ntry, wf8(:,42), ex3(:), wf8(:,282), n3(:,360), t3x8(:,:,185))
  call prop_Q_A(ntry, wf8(:,282), 53, MT, 1_intkind1, wf8(:,283), n2(199))
  call vert_VQ_A(ntry, ex4(:), wf8(:,42), wf16(:,119), n3(:,361), t3x16(:,:,78))
  call prop_Q_A(ntry, wf16(:,119), 57, MT, 1_intkind1, wf16(:,120), n2(200))
  call vert_VQ_A(ntry, wf8(:,22), ex1(:), wf16(:,121), n3(:,362), t3x16(:,:,79))
  call prop_Q_A(ntry, wf16(:,121), 57, MT, 1_intkind1, wf16(:,122), n2(201))
  call vert_SA_Q(gH,ntry, ex3(:), wf8(:,24), wf8(:,284), n3(:,363), t3x8(:,:,186))
  call prop_A_Q(ntry, wf8(:,284), 54, MT, 1_intkind1, wf8(:,285), n2(202))
  call vert_AV_Q(ntry, wf8(:,24), ex4(:), wf16(:,123), n3(:,364), t3x16(:,:,80))
  call prop_A_Q(ntry, wf16(:,123), 58, MT, 1_intkind1, wf16(:,124), n2(203))
  call vert_AV_Q(ntry, ex2(:), wf8(:,22), wf16(:,125), n3(:,365), t3x16(:,:,81))
  call prop_A_Q(ntry, wf16(:,125), 58, MT, 1_intkind1, wf16(:,126), n2(204))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_exwf(ex6)
  call init_hybrid_wf(wf2)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf16)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

  call photon_factors(photonid_pphttj_ttxhggg_1, &
                    &  0, bornphotonfactor)
  M02 = bornphotonfactor * M02
  M2ct = bornphotonfactor * M2ct
  M2colint = bornphotonfactor * M2colint

  !! used for born-loop colour-correlators
  extcombs = [(i, i = 0, 22-1)]
  nextcombs = 6*(6+1)/2 + 1
  if(nextcombs>0) then
    allocate(extcombs_permuted(nextcombs))
  end if
  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_pphttj_ttxhggg_1(extcombs(k))
  end do

#if -1 > 0 && 6 > 3
  !!Born-loop colour correlators interference

  M0M1_hel_cc(:,:,:)%j = 0
  do n = 1, 9
    M2add_ct = 0
    m = ind_cc_comb(n)
      do k = 1, nhel
        call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
        call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
        M2ctcc(m) = M2ctcc(m) + M2add_ct
      end do
  end do
  M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
  M0M1_hel_cc(:,nhel+1:,:)%j = 0
#endif

  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 1
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_VV(nsync, wf8(:,1), wf4(:,1), A(:,1), n3(:,366), t3x32(:,:,1), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,1), wf8(:,2), A(:,2), n3(:,367), t3x32(:,:,2), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,1), wf8(:,3), A(:,3), n3(:,368), t3x32(:,:,3), nhel, den(3))
    call Hcont_VV(nsync, wf8(:,1), wf4(:,2), A(:,4), n3(:,369), t3x32(:,:,4), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,2), wf4(:,2), A(:,5), n3(:,370), t3x32(:,:,5), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,3), wf4(:,2), A(:,6), n3(:,371), t3x32(:,:,6), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,4), A(:,7), n3(:,372), t3x32(:,:,7), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,5), wf4(:,7), A(:,8), n3(:,373), t3x32(:,:,8), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,7), A(:,9), n3(:,374), t3x32(:,:,9), nhel, den(15))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,8), A(:,10), n3(:,375), t3x32(:,:,10), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,9), wf4(:,13), A(:,11), n3(:,376), t3x32(:,:,11), nhel, den(22))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,11), A(:,12), n3(:,377), t3x32(:,:,12), nhel, den(24))
    call Hcont_VV(nsync, wf4(:,15), wf8(:,12), A(:,13), n3(:,378), t3x32(:,:,13), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,1), wf8(:,13), A(:,14), n3(:,379), t3x32(:,:,14), nhel, den(31))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,15), A(:,15), n3(:,380), t3x32(:,:,15), nhel, den(33))
    call Hcont_QA(nsync, wf4(:,13), wf8(:,16), A(:,16), n3(:,381), t3x32(:,:,16), nhel, den(34))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,18), A(:,17), n3(:,382), t3x32(:,:,17), nhel, den(37))
    call Hcont_VV(nsync, wf4(:,1), wf8(:,19), A(:,18), n3(:,383), t3x32(:,:,18), nhel, den(38))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,21), A(:,19), n3(:,384), t3x32(:,:,19), nhel, den(40))
    call Hcont_VV(nsync, wf4(:,1), wf8(:,22), A(:,20), n3(:,385), t3x32(:,:,20), nhel, den(41))
    call Hcont_QA(nsync, wf4(:,12), wf8(:,24), A(:,21), n3(:,386), t3x32(:,:,21), nhel, den(44))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,25), A(:,22), n3(:,387), t3x32(:,:,22), nhel, den(47))
    call Hcont_QA(nsync, wf4(:,19), wf8(:,27), A(:,23), n3(:,388), t3x32(:,:,23), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,28), wf4(:,21), A(:,24), n3(:,389), t3x32(:,:,24), nhel, den(53))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,29), A(:,25), n3(:,390), t3x32(:,:,25), nhel, den(56))
    call Hcont_QA(nsync, wf4(:,19), wf8(:,31), A(:,26), n3(:,391), t3x32(:,:,26), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,32), wf4(:,25), A(:,27), n3(:,392), t3x32(:,:,27), nhel, den(61))
    call Hcont_VV(nsync, wf4(:,15), wf8(:,33), A(:,28), n3(:,393), t3x32(:,:,28), nhel, den(64))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,13), A(:,29), n3(:,394), t3x32(:,:,29), nhel, den(66))
    call Hcont_QA(nsync, wf4(:,19), wf8(:,35), A(:,30), n3(:,395), t3x32(:,:,30), nhel, den(68))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,37), A(:,31), n3(:,396), t3x32(:,:,31), nhel, den(71))
    call Hcont_QA(nsync, wf4(:,25), wf8(:,38), A(:,32), n3(:,397), t3x32(:,:,32), nhel, den(72))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,19), A(:,33), n3(:,398), t3x32(:,:,33), nhel, den(73))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,40), A(:,34), n3(:,399), t3x32(:,:,34), nhel, den(75))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,22), A(:,35), n3(:,400), t3x32(:,:,35), nhel, den(76))
    call Hcont_QA(nsync, wf4(:,24), wf8(:,42), A(:,36), n3(:,401), t3x32(:,:,36), nhel, den(79))
    call Hcont_QA(nsync, wf8(:,9), wf4(:,29), A(:,37), n3(:,402), t3x32(:,:,37), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,28), wf4(:,31), A(:,38), n3(:,403), t3x32(:,:,38), nhel, den(83))
    call Hcont_QA(nsync, wf8(:,16), wf4(:,29), A(:,39), n3(:,404), t3x32(:,:,39), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,26), wf4(:,33), A(:,40), n3(:,405), t3x32(:,:,40), nhel, den(87))
    call Hcont_QA(nsync, wf8(:,24), wf4(:,28), A(:,41), n3(:,406), t3x32(:,:,41), nhel, den(88))
    call Hcont_QA(nsync, wf8(:,5), wf4(:,35), A(:,42), n3(:,407), t3x32(:,:,42), nhel, den(90))
    call Hcont_QA(nsync, wf8(:,32), wf4(:,37), A(:,43), n3(:,408), t3x32(:,:,43), nhel, den(92))
    call Hcont_QA(nsync, wf8(:,6), wf4(:,39), A(:,44), n3(:,409), t3x32(:,:,44), nhel, den(95))
    call Hcont_QA(nsync, wf8(:,38), wf4(:,37), A(:,45), n3(:,410), t3x32(:,:,45), nhel, den(96))
    call Hcont_QA(nsync, wf8(:,42), wf4(:,36), A(:,46), n3(:,411), t3x32(:,:,46), nhel, den(97))
    call Hcont_QA(nsync, wf8(:,17), wf4(:,35), A(:,47), n3(:,412), t3x32(:,:,47), nhel, den(98))
    call Hcont_QA(nsync, wf8(:,30), wf4(:,33), A(:,48), n3(:,413), t3x32(:,:,48), nhel, den(99))
    call Hcont_QA(nsync, wf8(:,21), wf4(:,34), A(:,49), n3(:,414), t3x32(:,:,49), nhel, den(100))
    call Hcont_QA(nsync, wf8(:,10), wf4(:,39), A(:,50), n3(:,415), t3x32(:,:,50), nhel, den(101))
    call Hcont_QA(nsync, wf8(:,36), wf4(:,31), A(:,51), n3(:,416), t3x32(:,:,51), nhel, den(102))
    call Hcont_QA(nsync, wf8(:,40), wf4(:,30), A(:,52), n3(:,417), t3x32(:,:,52), nhel, den(103))
    call Hcont_QA(nsync, wf8(:,15), wf4(:,38), A(:,53), n3(:,418), t3x32(:,:,53), nhel, den(104))
    call Hcont_QA(nsync, wf8(:,35), wf4(:,32), A(:,54), n3(:,419), t3x32(:,:,54), nhel, den(105))

    call Hcont_VV(nsync, wf8(:,1), wf4(:,41), A(:,55), n3(:,420), t3x32(:,:,55), nhel, den(107))
    call Hcont_VV(nsync, wf8(:,2), wf4(:,41), A(:,56), n3(:,421), t3x32(:,:,56), nhel, den(107))
    call Hcont_VV(nsync, wf8(:,3), wf4(:,41), A(:,57), n3(:,422), t3x32(:,:,57), nhel, den(107))
    call Hcont_VV(nsync, wf8(:,1), wf4(:,41), A(:,58), n3(:,423), t3x32(:,:,58), nhel, den(107))
    call Hcont_VV(nsync, wf8(:,2), wf4(:,41), A(:,59), n3(:,424), t3x32(:,:,59), nhel, den(107))
    call Hcont_VV(nsync, wf8(:,3), wf4(:,41), A(:,60), n3(:,425), t3x32(:,:,60), nhel, den(107))
    call Hcont_VV(nsync, wf2(:,5), wf16(:,1), A(:,61), n3(:,426), t3x32(:,:,61), nhel, den(109))
    call Hcont_VV(nsync, wf2(:,5), wf16(:,2), A(:,62), n3(:,427), t3x32(:,:,62), nhel, den(109))
    call Hcont_VV(nsync, wf2(:,5), wf16(:,3), A(:,63), n3(:,428), t3x32(:,:,63), nhel, den(109))
    call Hcont_VV(nsync, wf2(:,5), wf16(:,1), A(:,64), n3(:,429), t3x32(:,:,64), nhel, den(109))
    call Hcont_VV(nsync, wf2(:,5), wf16(:,2), A(:,65), n3(:,430), t3x32(:,:,65), nhel, den(109))
    call Hcont_VV(nsync, wf2(:,5), wf16(:,3), A(:,66), n3(:,431), t3x32(:,:,66), nhel, den(109))
    call Hcont_VV(nsync, wf2(:,6), wf16(:,4), A(:,67), n3(:,432), t3x32(:,:,67), nhel, den(111))
    call Hcont_VV(nsync, wf2(:,6), wf16(:,5), A(:,68), n3(:,433), t3x32(:,:,68), nhel, den(111))
    call Hcont_VV(nsync, wf2(:,6), wf16(:,6), A(:,69), n3(:,434), t3x32(:,:,69), nhel, den(111))
    call Hcont_VV(nsync, wf2(:,6), wf16(:,4), A(:,70), n3(:,435), t3x32(:,:,70), nhel, den(111))
    call Hcont_VV(nsync, wf2(:,6), wf16(:,5), A(:,71), n3(:,436), t3x32(:,:,71), nhel, den(111))
    call Hcont_VV(nsync, wf2(:,6), wf16(:,6), A(:,72), n3(:,437), t3x32(:,:,72), nhel, den(111))
    call Hcont_VV(nsync, wf2(:,7), wf16(:,7), A(:,73), n3(:,438), t3x32(:,:,73), nhel, den(113))
    call Hcont_VV(nsync, wf2(:,7), wf16(:,8), A(:,74), n3(:,439), t3x32(:,:,74), nhel, den(113))
    call Hcont_VV(nsync, wf2(:,7), wf16(:,9), A(:,75), n3(:,440), t3x32(:,:,75), nhel, den(113))
    call Hcont_VV(nsync, wf2(:,7), wf16(:,7), A(:,76), n3(:,441), t3x32(:,:,76), nhel, den(113))
    call Hcont_VV(nsync, wf2(:,7), wf16(:,8), A(:,77), n3(:,442), t3x32(:,:,77), nhel, den(113))
    call Hcont_VV(nsync, wf2(:,7), wf16(:,9), A(:,78), n3(:,443), t3x32(:,:,78), nhel, den(113))
    call Hcont_VV(nsync, wf4(:,1), wf8(:,43), A(:,79), n3(:,444), t3x32(:,:,79), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,1), wf8(:,44), A(:,80), n3(:,445), t3x32(:,:,80), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,1), wf8(:,45), A(:,81), n3(:,446), t3x32(:,:,81), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,1), wf8(:,43), A(:,82), n3(:,447), t3x32(:,:,82), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,1), wf8(:,44), A(:,83), n3(:,448), t3x32(:,:,83), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,1), wf8(:,45), A(:,84), n3(:,449), t3x32(:,:,84), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,43), A(:,85), n3(:,450), t3x32(:,:,85), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,44), A(:,86), n3(:,451), t3x32(:,:,86), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,45), A(:,87), n3(:,452), t3x32(:,:,87), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,43), A(:,88), n3(:,453), t3x32(:,:,88), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,44), A(:,89), n3(:,454), t3x32(:,:,89), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,45), A(:,90), n3(:,455), t3x32(:,:,90), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,1), wf4(:,42), A(:,91), n3(:,456), t3x32(:,:,91), nhel, den(3))
    call Hcont_VV(nsync, wf8(:,2), wf4(:,42), A(:,92), n3(:,457), t3x32(:,:,92), nhel, den(3))
    call Hcont_VV(nsync, wf8(:,3), wf4(:,42), A(:,93), n3(:,458), t3x32(:,:,93), nhel, den(3))
    call Hcont_VV(nsync, wf8(:,1), wf4(:,43), A(:,94), n3(:,459), t3x32(:,:,94), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,2), wf4(:,43), A(:,95), n3(:,460), t3x32(:,:,95), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,3), wf4(:,43), A(:,96), n3(:,461), t3x32(:,:,96), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,1), wf4(:,44), A(:,97), n3(:,462), t3x32(:,:,97), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,2), wf4(:,44), A(:,98), n3(:,463), t3x32(:,:,98), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,3), wf4(:,44), A(:,99), n3(:,464), t3x32(:,:,99), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,1), wf4(:,45), A(:,100), n3(:,465), t3x32(:,:,100), nhel, den(3))
    call Hcont_VV(nsync, wf8(:,2), wf4(:,45), A(:,101), n3(:,466), t3x32(:,:,101), nhel, den(3))
    call Hcont_VV(nsync, wf8(:,3), wf4(:,45), A(:,102), n3(:,467), t3x32(:,:,102), nhel, den(3))
    call Hcont_VV(nsync, wf8(:,46), wf4(:,46), A(:,103), n3(:,468), t3x32(:,:,103), nhel, den(116))
    call Hcont_VV(nsync, wf8(:,46), wf4(:,46), A(:,104), n3(:,469), t3x32(:,:,104), nhel, den(116))
    call Hcont_VV(nsync, wf8(:,13), wf4(:,41), A(:,105), n3(:,470), t3x32(:,:,105), nhel, den(118))
    call Hcont_VV(nsync, wf8(:,13), wf4(:,41), A(:,106), n3(:,471), t3x32(:,:,106), nhel, den(118))
    call Hcont_VV(nsync, wf4(:,15), wf8(:,47), A(:,107), n3(:,472), t3x32(:,:,107), nhel, den(119))
    call Hcont_VV(nsync, wf4(:,15), wf8(:,47), A(:,108), n3(:,473), t3x32(:,:,108), nhel, den(119))
    call Hcont_VV(nsync, wf8(:,48), wf4(:,47), A(:,109), n3(:,474), t3x32(:,:,109), nhel, den(122))
    call Hcont_VV(nsync, wf8(:,48), wf4(:,47), A(:,110), n3(:,475), t3x32(:,:,110), nhel, den(122))
    call Hcont_VV(nsync, wf8(:,19), wf4(:,41), A(:,111), n3(:,476), t3x32(:,:,111), nhel, den(124))
    call Hcont_VV(nsync, wf8(:,19), wf4(:,41), A(:,112), n3(:,477), t3x32(:,:,112), nhel, den(124))
    call Hcont_VV(nsync, wf8(:,49), wf4(:,48), A(:,113), n3(:,478), t3x32(:,:,113), nhel, den(127))
    call Hcont_VV(nsync, wf8(:,49), wf4(:,48), A(:,114), n3(:,479), t3x32(:,:,114), nhel, den(127))
    call Hcont_VV(nsync, wf8(:,22), wf4(:,41), A(:,115), n3(:,480), t3x32(:,:,115), nhel, den(129))
    call Hcont_VV(nsync, wf8(:,22), wf4(:,41), A(:,116), n3(:,481), t3x32(:,:,116), nhel, den(129))
    call Hcont_VV(nsync, wf8(:,49), wf4(:,49), A(:,117), n3(:,482), t3x32(:,:,117), nhel, den(130))
    call Hcont_VV(nsync, wf8(:,49), wf4(:,49), A(:,118), n3(:,483), t3x32(:,:,118), nhel, den(130))
    call Hcont_VV(nsync, wf8(:,48), wf4(:,50), A(:,119), n3(:,484), t3x32(:,:,119), nhel, den(133))
    call Hcont_VV(nsync, wf8(:,48), wf4(:,50), A(:,120), n3(:,485), t3x32(:,:,120), nhel, den(133))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,50), A(:,121), n3(:,486), t3x32(:,:,121), nhel, den(134))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,50), A(:,122), n3(:,487), t3x32(:,:,122), nhel, den(134))
    call Hcont_VV(nsync, wf8(:,49), wf4(:,51), A(:,123), n3(:,488), t3x32(:,:,123), nhel, den(135))
    call Hcont_VV(nsync, wf8(:,49), wf4(:,51), A(:,124), n3(:,489), t3x32(:,:,124), nhel, den(135))
    call Hcont_VV(nsync, wf8(:,46), wf4(:,52), A(:,125), n3(:,490), t3x32(:,:,125), nhel, den(138))
    call Hcont_VV(nsync, wf8(:,46), wf4(:,52), A(:,126), n3(:,491), t3x32(:,:,126), nhel, den(138))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,51), A(:,127), n3(:,492), t3x32(:,:,127), nhel, den(139))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,51), A(:,128), n3(:,493), t3x32(:,:,128), nhel, den(139))
    call Hcont_VV(nsync, wf8(:,48), wf4(:,53), A(:,129), n3(:,494), t3x32(:,:,129), nhel, den(140))
    call Hcont_VV(nsync, wf8(:,48), wf4(:,53), A(:,130), n3(:,495), t3x32(:,:,130), nhel, den(140))
    call Hcont_VV(nsync, wf8(:,46), wf4(:,54), A(:,131), n3(:,496), t3x32(:,:,131), nhel, den(142))
    call Hcont_VV(nsync, wf8(:,46), wf4(:,54), A(:,132), n3(:,497), t3x32(:,:,132), nhel, den(142))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,52), A(:,133), n3(:,498), t3x32(:,:,133), nhel, den(9))
    call Hcont_QA(nsync, wf4(:,7), wf8(:,53), A(:,134), n3(:,499), t3x32(:,:,134), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,7), wf4(:,55), A(:,135), n3(:,500), t3x32(:,:,135), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,54), wf4(:,56), A(:,136), n3(:,501), t3x32(:,:,136), nhel, den(144))
    call Hcont_QA(nsync, wf4(:,57), wf8(:,55), A(:,137), n3(:,502), t3x32(:,:,137), nhel, den(146))
    call Hcont_VV(nsync, wf8(:,4), wf4(:,58), A(:,138), n3(:,503), t3x32(:,:,138), nhel, den(9))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,56), A(:,139), n3(:,504), t3x32(:,:,139), nhel, den(19))
    call Hcont_QA(nsync, wf4(:,13), wf8(:,57), A(:,140), n3(:,505), t3x32(:,:,140), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,11), wf4(:,55), A(:,141), n3(:,506), t3x32(:,:,141), nhel, den(24))
    call Hcont_VV(nsync, wf4(:,15), wf8(:,58), A(:,142), n3(:,507), t3x32(:,:,142), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,1), wf8(:,59), A(:,143), n3(:,508), t3x32(:,:,143), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,15), wf4(:,55), A(:,144), n3(:,509), t3x32(:,:,144), nhel, den(33))
    call Hcont_QA(nsync, wf4(:,13), wf8(:,60), A(:,145), n3(:,510), t3x32(:,:,145), nhel, den(34))
    call Hcont_QA(nsync, wf8(:,18), wf4(:,57), A(:,146), n3(:,511), t3x32(:,:,146), nhel, den(37))
    call Hcont_VV(nsync, wf4(:,1), wf8(:,61), A(:,147), n3(:,512), t3x32(:,:,147), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,21), wf4(:,57), A(:,148), n3(:,513), t3x32(:,:,148), nhel, den(40))
    call Hcont_VV(nsync, wf4(:,1), wf8(:,62), A(:,149), n3(:,514), t3x32(:,:,149), nhel, den(41))
    call Hcont_QA(nsync, wf4(:,12), wf8(:,64), A(:,150), n3(:,515), t3x32(:,:,150), nhel, den(44))
    call Hcont_QA(nsync, wf2(:,12), wf16(:,11), A(:,151), n3(:,516), t3x32(:,:,151), nhel, den(149))
    call Hcont_QA(nsync, wf2(:,12), wf16(:,13), A(:,152), n3(:,517), t3x32(:,:,152), nhel, den(149))
    call Hcont_QA(nsync, wf2(:,12), wf16(:,15), A(:,153), n3(:,518), t3x32(:,:,153), nhel, den(149))
    call Hcont_VV(nsync, wf4(:,1), wf8(:,65), A(:,154), n3(:,519), t3x32(:,:,154), nhel, den(150))
    call Hcont_VV(nsync, wf4(:,1), wf8(:,66), A(:,155), n3(:,520), t3x32(:,:,155), nhel, den(150))
    call Hcont_VV(nsync, wf4(:,1), wf8(:,67), A(:,156), n3(:,521), t3x32(:,:,156), nhel, den(150))
    call Hcont_QA(nsync, wf4(:,56), wf8(:,68), A(:,157), n3(:,522), t3x32(:,:,157), nhel, den(151))
    call Hcont_QA(nsync, wf4(:,59), wf8(:,69), A(:,158), n3(:,523), t3x32(:,:,158), nhel, den(153))
    call Hcont_VV(nsync, wf8(:,8), wf4(:,60), A(:,159), n3(:,524), t3x32(:,:,159), nhel, den(19))
    call Hcont_QA(nsync, wf4(:,7), wf8(:,70), A(:,160), n3(:,525), t3x32(:,:,160), nhel, den(154))
    call Hcont_QA(nsync, wf4(:,59), wf8(:,71), A(:,161), n3(:,526), t3x32(:,:,161), nhel, den(156))
    call Hcont_VV(nsync, wf4(:,1), wf8(:,72), A(:,162), n3(:,527), t3x32(:,:,162), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,24), wf4(:,59), A(:,163), n3(:,528), t3x32(:,:,163), nhel, den(44))
    call Hcont_VV(nsync, wf4(:,1), wf8(:,73), A(:,164), n3(:,529), t3x32(:,:,164), nhel, den(38))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,75), A(:,165), n3(:,530), t3x32(:,:,165), nhel, den(40))
    call Hcont_VV(nsync, wf8(:,12), wf4(:,61), A(:,166), n3(:,531), t3x32(:,:,166), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,1), wf8(:,76), A(:,167), n3(:,532), t3x32(:,:,167), nhel, den(31))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,78), A(:,168), n3(:,533), t3x32(:,:,168), nhel, den(33))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,79), A(:,169), n3(:,534), t3x32(:,:,169), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,27), wf4(:,62), A(:,170), n3(:,535), t3x32(:,:,170), nhel, den(50))
    call Hcont_QA(nsync, wf4(:,21), wf8(:,80), A(:,171), n3(:,536), t3x32(:,:,171), nhel, den(53))
    call Hcont_QA(nsync, wf4(:,63), wf8(:,81), A(:,172), n3(:,537), t3x32(:,:,172), nhel, den(158))
    call Hcont_QA(nsync, wf8(:,82), wf4(:,64), A(:,173), n3(:,538), t3x32(:,:,173), nhel, den(160))
    call Hcont_VV(nsync, wf8(:,25), wf4(:,58), A(:,174), n3(:,539), t3x32(:,:,174), nhel, den(47))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,83), A(:,175), n3(:,540), t3x32(:,:,175), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,31), wf4(:,62), A(:,176), n3(:,541), t3x32(:,:,176), nhel, den(58))
    call Hcont_QA(nsync, wf4(:,25), wf8(:,84), A(:,177), n3(:,542), t3x32(:,:,177), nhel, den(61))
    call Hcont_VV(nsync, wf4(:,15), wf8(:,85), A(:,178), n3(:,543), t3x32(:,:,178), nhel, den(64))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,59), A(:,179), n3(:,544), t3x32(:,:,179), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,35), wf4(:,62), A(:,180), n3(:,545), t3x32(:,:,180), nhel, den(68))
    call Hcont_QA(nsync, wf8(:,37), wf4(:,63), A(:,181), n3(:,546), t3x32(:,:,181), nhel, den(71))
    call Hcont_QA(nsync, wf4(:,25), wf8(:,86), A(:,182), n3(:,547), t3x32(:,:,182), nhel, den(72))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,61), A(:,183), n3(:,548), t3x32(:,:,183), nhel, den(73))
    call Hcont_QA(nsync, wf8(:,40), wf4(:,63), A(:,184), n3(:,549), t3x32(:,:,184), nhel, den(75))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,62), A(:,185), n3(:,550), t3x32(:,:,185), nhel, den(76))
    call Hcont_QA(nsync, wf4(:,24), wf8(:,88), A(:,186), n3(:,551), t3x32(:,:,186), nhel, den(79))
    call Hcont_QA(nsync, wf2(:,13), wf16(:,17), A(:,187), n3(:,552), t3x32(:,:,187), nhel, den(163))
    call Hcont_QA(nsync, wf2(:,13), wf16(:,19), A(:,188), n3(:,553), t3x32(:,:,188), nhel, den(163))
    call Hcont_QA(nsync, wf2(:,13), wf16(:,21), A(:,189), n3(:,554), t3x32(:,:,189), nhel, den(163))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,65), A(:,190), n3(:,555), t3x32(:,:,190), nhel, den(164))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,66), A(:,191), n3(:,556), t3x32(:,:,191), nhel, den(164))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,67), A(:,192), n3(:,557), t3x32(:,:,192), nhel, den(164))
    call Hcont_QA(nsync, wf4(:,65), wf8(:,89), A(:,193), n3(:,558), t3x32(:,:,193), nhel, den(166))
    call Hcont_QA(nsync, wf4(:,64), wf8(:,90), A(:,194), n3(:,559), t3x32(:,:,194), nhel, den(167))
    call Hcont_VV(nsync, wf8(:,29), wf4(:,60), A(:,195), n3(:,560), t3x32(:,:,195), nhel, den(56))
    call Hcont_QA(nsync, wf4(:,65), wf8(:,91), A(:,196), n3(:,561), t3x32(:,:,196), nhel, den(169))
    call Hcont_QA(nsync, wf4(:,21), wf8(:,92), A(:,197), n3(:,562), t3x32(:,:,197), nhel, den(170))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,72), A(:,198), n3(:,563), t3x32(:,:,198), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,42), wf4(:,65), A(:,199), n3(:,564), t3x32(:,:,199), nhel, den(79))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,73), A(:,200), n3(:,565), t3x32(:,:,200), nhel, den(73))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,94), A(:,201), n3(:,566), t3x32(:,:,201), nhel, den(75))
    call Hcont_VV(nsync, wf8(:,33), wf4(:,61), A(:,202), n3(:,567), t3x32(:,:,202), nhel, den(64))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,76), A(:,203), n3(:,568), t3x32(:,:,203), nhel, den(66))
    call Hcont_QA(nsync, wf4(:,19), wf8(:,96), A(:,204), n3(:,569), t3x32(:,:,204), nhel, den(68))
    call Hcont_QA(nsync, wf4(:,29), wf8(:,57), A(:,205), n3(:,570), t3x32(:,:,205), nhel, den(81))
    call Hcont_QA(nsync, wf4(:,31), wf8(:,80), A(:,206), n3(:,571), t3x32(:,:,206), nhel, den(83))
    call Hcont_QA(nsync, wf4(:,29), wf8(:,60), A(:,207), n3(:,572), t3x32(:,:,207), nhel, den(84))
    call Hcont_QA(nsync, wf4(:,33), wf8(:,82), A(:,208), n3(:,573), t3x32(:,:,208), nhel, den(87))
    call Hcont_QA(nsync, wf4(:,28), wf8(:,64), A(:,209), n3(:,574), t3x32(:,:,209), nhel, den(88))
    call Hcont_QA(nsync, wf4(:,35), wf8(:,53), A(:,210), n3(:,575), t3x32(:,:,210), nhel, den(90))
    call Hcont_QA(nsync, wf4(:,37), wf8(:,84), A(:,211), n3(:,576), t3x32(:,:,211), nhel, den(92))
    call Hcont_QA(nsync, wf4(:,39), wf8(:,54), A(:,212), n3(:,577), t3x32(:,:,212), nhel, den(95))
    call Hcont_QA(nsync, wf4(:,37), wf8(:,86), A(:,213), n3(:,578), t3x32(:,:,213), nhel, den(96))
    call Hcont_QA(nsync, wf4(:,36), wf8(:,88), A(:,214), n3(:,579), t3x32(:,:,214), nhel, den(97))
    call Hcont_QA(nsync, wf4(:,35), wf8(:,70), A(:,215), n3(:,580), t3x32(:,:,215), nhel, den(98))
    call Hcont_QA(nsync, wf4(:,33), wf8(:,90), A(:,216), n3(:,581), t3x32(:,:,216), nhel, den(99))
    call Hcont_QA(nsync, wf4(:,34), wf8(:,75), A(:,217), n3(:,582), t3x32(:,:,217), nhel, den(100))
    call Hcont_QA(nsync, wf4(:,39), wf8(:,68), A(:,218), n3(:,583), t3x32(:,:,218), nhel, den(101))
    call Hcont_QA(nsync, wf4(:,31), wf8(:,92), A(:,219), n3(:,584), t3x32(:,:,219), nhel, den(102))
    call Hcont_QA(nsync, wf4(:,30), wf8(:,94), A(:,220), n3(:,585), t3x32(:,:,220), nhel, den(103))
    call Hcont_QA(nsync, wf4(:,38), wf8(:,78), A(:,221), n3(:,586), t3x32(:,:,221), nhel, den(104))
    call Hcont_QA(nsync, wf4(:,32), wf8(:,96), A(:,222), n3(:,587), t3x32(:,:,222), nhel, den(105))
    call Hcont_QA(nsync, wf8(:,81), wf4(:,66), A(:,223), n3(:,588), t3x32(:,:,223), nhel, den(171))
    call Hcont_QA(nsync, wf8(:,69), wf4(:,67), A(:,224), n3(:,589), t3x32(:,:,224), nhel, den(172))
    call Hcont_VV(nsync, wf2(:,5), wf16(:,22), A(:,225), n3(:,590), t3x32(:,:,225), nhel, den(174))
    call Hcont_VV(nsync, wf2(:,5), wf16(:,22), A(:,226), n3(:,591), t3x32(:,:,226), nhel, den(174))
    call Hcont_QA(nsync, wf8(:,27), wf4(:,68), A(:,227), n3(:,592), t3x32(:,:,227), nhel, den(175))
    call Hcont_QA(nsync, wf8(:,71), wf4(:,67), A(:,228), n3(:,593), t3x32(:,:,228), nhel, den(176))
    call Hcont_VV(nsync, wf4(:,48), wf8(:,97), A(:,229), n3(:,594), t3x32(:,:,229), nhel, den(178))
    call Hcont_VV(nsync, wf4(:,48), wf8(:,97), A(:,230), n3(:,595), t3x32(:,:,230), nhel, den(178))
    call Hcont_QA(nsync, wf8(:,24), wf4(:,67), A(:,231), n3(:,596), t3x32(:,:,231), nhel, den(88))
    call Hcont_VV(nsync, wf4(:,49), wf8(:,97), A(:,232), n3(:,597), t3x32(:,:,232), nhel, den(179))
    call Hcont_VV(nsync, wf4(:,49), wf8(:,97), A(:,233), n3(:,598), t3x32(:,:,233), nhel, den(179))
    call Hcont_QA(nsync, wf8(:,26), wf4(:,70), A(:,234), n3(:,599), t3x32(:,:,234), nhel, den(181))
    call Hcont_QA(nsync, wf8(:,26), wf4(:,70), A(:,235), n3(:,600), t3x32(:,:,235), nhel, den(181))
    call Hcont_VV(nsync, wf2(:,6), wf16(:,23), A(:,236), n3(:,601), t3x32(:,:,236), nhel, den(183))
    call Hcont_VV(nsync, wf2(:,6), wf16(:,23), A(:,237), n3(:,602), t3x32(:,:,237), nhel, den(183))
    call Hcont_VV(nsync, wf4(:,51), wf8(:,97), A(:,238), n3(:,603), t3x32(:,:,238), nhel, den(184))
    call Hcont_VV(nsync, wf4(:,51), wf8(:,97), A(:,239), n3(:,604), t3x32(:,:,239), nhel, den(184))
    call Hcont_QA(nsync, wf8(:,28), wf4(:,72), A(:,240), n3(:,605), t3x32(:,:,240), nhel, den(186))
    call Hcont_QA(nsync, wf8(:,28), wf4(:,72), A(:,241), n3(:,606), t3x32(:,:,241), nhel, den(186))
    call Hcont_QA(nsync, wf8(:,89), wf4(:,73), A(:,242), n3(:,607), t3x32(:,:,242), nhel, den(187))
    call Hcont_QA(nsync, wf8(:,55), wf4(:,74), A(:,243), n3(:,608), t3x32(:,:,243), nhel, den(188))
    call Hcont_VV(nsync, wf2(:,5), wf16(:,24), A(:,244), n3(:,609), t3x32(:,:,244), nhel, den(190))
    call Hcont_VV(nsync, wf2(:,5), wf16(:,24), A(:,245), n3(:,610), t3x32(:,:,245), nhel, den(190))
    call Hcont_QA(nsync, wf8(:,91), wf4(:,73), A(:,246), n3(:,611), t3x32(:,:,246), nhel, den(191))
    call Hcont_QA(nsync, wf8(:,7), wf4(:,75), A(:,247), n3(:,612), t3x32(:,:,247), nhel, den(192))
    call Hcont_VV(nsync, wf4(:,48), wf8(:,98), A(:,248), n3(:,613), t3x32(:,:,248), nhel, den(194))
    call Hcont_VV(nsync, wf4(:,48), wf8(:,98), A(:,249), n3(:,614), t3x32(:,:,249), nhel, den(194))
    call Hcont_QA(nsync, wf8(:,42), wf4(:,73), A(:,250), n3(:,615), t3x32(:,:,250), nhel, den(97))
    call Hcont_VV(nsync, wf4(:,49), wf8(:,98), A(:,251), n3(:,616), t3x32(:,:,251), nhel, den(195))
    call Hcont_VV(nsync, wf4(:,49), wf8(:,98), A(:,252), n3(:,617), t3x32(:,:,252), nhel, den(195))
    call Hcont_QA(nsync, wf8(:,6), wf4(:,77), A(:,253), n3(:,618), t3x32(:,:,253), nhel, den(197))
    call Hcont_QA(nsync, wf8(:,6), wf4(:,77), A(:,254), n3(:,619), t3x32(:,:,254), nhel, den(197))
    call Hcont_VV(nsync, wf2(:,6), wf16(:,25), A(:,255), n3(:,620), t3x32(:,:,255), nhel, den(199))
    call Hcont_VV(nsync, wf2(:,6), wf16(:,25), A(:,256), n3(:,621), t3x32(:,:,256), nhel, den(199))
    call Hcont_VV(nsync, wf4(:,51), wf8(:,98), A(:,257), n3(:,622), t3x32(:,:,257), nhel, den(200))
    call Hcont_VV(nsync, wf4(:,51), wf8(:,98), A(:,258), n3(:,623), t3x32(:,:,258), nhel, den(200))
    call Hcont_QA(nsync, wf8(:,5), wf4(:,79), A(:,259), n3(:,624), t3x32(:,:,259), nhel, den(202))
    call Hcont_QA(nsync, wf8(:,5), wf4(:,79), A(:,260), n3(:,625), t3x32(:,:,260), nhel, den(202))
    call Hcont_QA(nsync, wf8(:,31), wf4(:,68), A(:,261), n3(:,626), t3x32(:,:,261), nhel, den(203))
    call Hcont_QA(nsync, wf8(:,18), wf4(:,74), A(:,262), n3(:,627), t3x32(:,:,262), nhel, den(204))
    call Hcont_VV(nsync, wf4(:,47), wf8(:,99), A(:,263), n3(:,628), t3x32(:,:,263), nhel, den(206))
    call Hcont_VV(nsync, wf4(:,47), wf8(:,99), A(:,264), n3(:,629), t3x32(:,:,264), nhel, den(206))
    call Hcont_QA(nsync, wf8(:,21), wf4(:,74), A(:,265), n3(:,630), t3x32(:,:,265), nhel, den(100))
    call Hcont_VV(nsync, wf4(:,50), wf8(:,99), A(:,266), n3(:,631), t3x32(:,:,266), nhel, den(207))
    call Hcont_VV(nsync, wf4(:,50), wf8(:,99), A(:,267), n3(:,632), t3x32(:,:,267), nhel, den(207))
    call Hcont_QA(nsync, wf8(:,30), wf4(:,70), A(:,268), n3(:,633), t3x32(:,:,268), nhel, den(208))
    call Hcont_QA(nsync, wf8(:,30), wf4(:,70), A(:,269), n3(:,634), t3x32(:,:,269), nhel, den(208))
    call Hcont_QA(nsync, wf8(:,37), wf4(:,66), A(:,270), n3(:,635), t3x32(:,:,270), nhel, den(209))
    call Hcont_QA(nsync, wf8(:,11), wf4(:,75), A(:,271), n3(:,636), t3x32(:,:,271), nhel, den(210))
    call Hcont_VV(nsync, wf4(:,47), wf8(:,100), A(:,272), n3(:,637), t3x32(:,:,272), nhel, den(212))
    call Hcont_VV(nsync, wf4(:,47), wf8(:,100), A(:,273), n3(:,638), t3x32(:,:,273), nhel, den(212))
    call Hcont_QA(nsync, wf8(:,40), wf4(:,66), A(:,274), n3(:,639), t3x32(:,:,274), nhel, den(103))
    call Hcont_VV(nsync, wf4(:,50), wf8(:,100), A(:,275), n3(:,640), t3x32(:,:,275), nhel, den(213))
    call Hcont_VV(nsync, wf4(:,50), wf8(:,100), A(:,276), n3(:,641), t3x32(:,:,276), nhel, den(213))
    call Hcont_QA(nsync, wf8(:,10), wf4(:,77), A(:,277), n3(:,642), t3x32(:,:,277), nhel, den(214))
    call Hcont_QA(nsync, wf8(:,10), wf4(:,77), A(:,278), n3(:,643), t3x32(:,:,278), nhel, den(214))
    call Hcont_VV(nsync, wf4(:,46), wf8(:,101), A(:,279), n3(:,644), t3x32(:,:,279), nhel, den(216))
    call Hcont_VV(nsync, wf4(:,46), wf8(:,101), A(:,280), n3(:,645), t3x32(:,:,280), nhel, den(216))
    call Hcont_QA(nsync, wf8(:,15), wf4(:,75), A(:,281), n3(:,646), t3x32(:,:,281), nhel, den(104))
    call Hcont_VV(nsync, wf4(:,46), wf8(:,102), A(:,282), n3(:,647), t3x32(:,:,282), nhel, den(218))
    call Hcont_VV(nsync, wf4(:,46), wf8(:,102), A(:,283), n3(:,648), t3x32(:,:,283), nhel, den(218))
    call Hcont_QA(nsync, wf8(:,35), wf4(:,68), A(:,284), n3(:,649), t3x32(:,:,284), nhel, den(105))
    call Hcont_QA(nsync, wf8(:,35), wf4(:,69), A(:,285), n3(:,650), t3x32(:,:,285), nhel, den(219))
    call Hcont_QA(nsync, wf8(:,35), wf4(:,69), A(:,286), n3(:,651), t3x32(:,:,286), nhel, den(219))
    call Hcont_QA(nsync, wf8(:,14), wf4(:,77), A(:,287), n3(:,652), t3x32(:,:,287), nhel, den(220))
    call Hcont_QA(nsync, wf8(:,14), wf4(:,77), A(:,288), n3(:,653), t3x32(:,:,288), nhel, den(220))
    call Hcont_VV(nsync, wf4(:,52), wf8(:,101), A(:,289), n3(:,654), t3x32(:,:,289), nhel, den(221))
    call Hcont_VV(nsync, wf4(:,52), wf8(:,101), A(:,290), n3(:,655), t3x32(:,:,290), nhel, den(221))
    call Hcont_QA(nsync, wf8(:,36), wf4(:,72), A(:,291), n3(:,656), t3x32(:,:,291), nhel, den(222))
    call Hcont_QA(nsync, wf8(:,36), wf4(:,72), A(:,292), n3(:,657), t3x32(:,:,292), nhel, den(222))
    call Hcont_VV(nsync, wf4(:,52), wf8(:,102), A(:,293), n3(:,658), t3x32(:,:,293), nhel, den(223))
    call Hcont_VV(nsync, wf4(:,52), wf8(:,102), A(:,294), n3(:,659), t3x32(:,:,294), nhel, den(223))
    call Hcont_QA(nsync, wf8(:,17), wf4(:,79), A(:,295), n3(:,660), t3x32(:,:,295), nhel, den(224))
    call Hcont_QA(nsync, wf8(:,17), wf4(:,79), A(:,296), n3(:,661), t3x32(:,:,296), nhel, den(224))
    call Hcont_QA(nsync, wf8(:,40), wf4(:,71), A(:,297), n3(:,662), t3x32(:,:,297), nhel, den(225))
    call Hcont_QA(nsync, wf8(:,40), wf4(:,71), A(:,298), n3(:,663), t3x32(:,:,298), nhel, den(225))
    call Hcont_QA(nsync, wf8(:,20), wf4(:,79), A(:,299), n3(:,664), t3x32(:,:,299), nhel, den(226))
    call Hcont_QA(nsync, wf8(:,20), wf4(:,79), A(:,300), n3(:,665), t3x32(:,:,300), nhel, den(226))
    call Hcont_VV(nsync, wf2(:,7), wf16(:,26), A(:,301), n3(:,666), t3x32(:,:,301), nhel, den(228))
    call Hcont_VV(nsync, wf2(:,7), wf16(:,26), A(:,302), n3(:,667), t3x32(:,:,302), nhel, den(228))
    call Hcont_VV(nsync, wf4(:,53), wf8(:,99), A(:,303), n3(:,668), t3x32(:,:,303), nhel, den(229))
    call Hcont_VV(nsync, wf4(:,53), wf8(:,99), A(:,304), n3(:,669), t3x32(:,:,304), nhel, den(229))
    call Hcont_QA(nsync, wf8(:,32), wf4(:,81), A(:,305), n3(:,670), t3x32(:,:,305), nhel, den(231))
    call Hcont_QA(nsync, wf8(:,32), wf4(:,81), A(:,306), n3(:,671), t3x32(:,:,306), nhel, den(231))
    call Hcont_VV(nsync, wf2(:,7), wf16(:,27), A(:,307), n3(:,672), t3x32(:,:,307), nhel, den(233))
    call Hcont_VV(nsync, wf2(:,7), wf16(:,27), A(:,308), n3(:,673), t3x32(:,:,308), nhel, den(233))
    call Hcont_VV(nsync, wf4(:,53), wf8(:,100), A(:,309), n3(:,674), t3x32(:,:,309), nhel, den(234))
    call Hcont_VV(nsync, wf4(:,53), wf8(:,100), A(:,310), n3(:,675), t3x32(:,:,310), nhel, den(234))
    call Hcont_QA(nsync, wf8(:,9), wf4(:,83), A(:,311), n3(:,676), t3x32(:,:,311), nhel, den(236))
    call Hcont_QA(nsync, wf8(:,9), wf4(:,83), A(:,312), n3(:,677), t3x32(:,:,312), nhel, den(236))
    call Hcont_VV(nsync, wf4(:,54), wf8(:,101), A(:,313), n3(:,678), t3x32(:,:,313), nhel, den(237))
    call Hcont_VV(nsync, wf4(:,54), wf8(:,101), A(:,314), n3(:,679), t3x32(:,:,314), nhel, den(237))
    call Hcont_QA(nsync, wf8(:,38), wf4(:,81), A(:,315), n3(:,680), t3x32(:,:,315), nhel, den(238))
    call Hcont_QA(nsync, wf8(:,38), wf4(:,81), A(:,316), n3(:,681), t3x32(:,:,316), nhel, den(238))
    call Hcont_VV(nsync, wf4(:,54), wf8(:,102), A(:,317), n3(:,682), t3x32(:,:,317), nhel, den(239))
    call Hcont_VV(nsync, wf4(:,54), wf8(:,102), A(:,318), n3(:,683), t3x32(:,:,318), nhel, den(239))
    call Hcont_QA(nsync, wf8(:,16), wf4(:,83), A(:,319), n3(:,684), t3x32(:,:,319), nhel, den(240))
    call Hcont_QA(nsync, wf8(:,16), wf4(:,83), A(:,320), n3(:,685), t3x32(:,:,320), nhel, den(240))
    call Hcont_QA(nsync, wf8(:,42), wf4(:,80), A(:,321), n3(:,686), t3x32(:,:,321), nhel, den(241))
    call Hcont_QA(nsync, wf8(:,42), wf4(:,80), A(:,322), n3(:,687), t3x32(:,:,322), nhel, den(241))
    call Hcont_QA(nsync, wf8(:,23), wf4(:,83), A(:,323), n3(:,688), t3x32(:,:,323), nhel, den(242))
    call Hcont_QA(nsync, wf8(:,23), wf4(:,83), A(:,324), n3(:,689), t3x32(:,:,324), nhel, den(242))
    call Hcont_QA(nsync, wf4(:,56), wf8(:,103), A(:,325), n3(:,690), t3x32(:,:,325), nhel, den(243))
    call Hcont_VV(nsync, wf8(:,13), wf4(:,42), A(:,326), n3(:,691), t3x32(:,:,326), nhel, den(244))
    call Hcont_VV(nsync, wf4(:,15), wf8(:,104), A(:,327), n3(:,692), t3x32(:,:,327), nhel, den(28))
    call Hcont_QA(nsync, wf4(:,7), wf8(:,105), A(:,328), n3(:,693), t3x32(:,:,328), nhel, den(245))
    call Hcont_VV(nsync, wf8(:,19), wf4(:,42), A(:,329), n3(:,694), t3x32(:,:,329), nhel, den(246))
    call Hcont_QA(nsync, wf4(:,13), wf8(:,106), A(:,330), n3(:,695), t3x32(:,:,330), nhel, den(247))
    call Hcont_VV(nsync, wf8(:,22), wf4(:,42), A(:,331), n3(:,696), t3x32(:,:,331), nhel, den(248))
    call Hcont_QA(nsync, wf4(:,13), wf8(:,107), A(:,332), n3(:,697), t3x32(:,:,332), nhel, den(34))
    call Hcont_QA(nsync, wf4(:,6), wf8(:,109), A(:,333), n3(:,698), t3x32(:,:,333), nhel, den(37))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,110), A(:,334), n3(:,699), t3x32(:,:,334), nhel, den(19))
    call Hcont_QA(nsync, wf4(:,13), wf8(:,111), A(:,335), n3(:,700), t3x32(:,:,335), nhel, den(22))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,113), A(:,336), n3(:,701), t3x32(:,:,336), nhel, den(24))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,114), A(:,337), n3(:,702), t3x32(:,:,337), nhel, den(9))
    call Hcont_QA(nsync, wf4(:,7), wf8(:,115), A(:,338), n3(:,703), t3x32(:,:,338), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,8), wf8(:,117), A(:,339), n3(:,704), t3x32(:,:,339), nhel, den(15))
    call Hcont_QA(nsync, wf4(:,29), wf8(:,106), A(:,340), n3(:,705), t3x32(:,:,340), nhel, den(249))
    call Hcont_QA(nsync, wf4(:,29), wf8(:,107), A(:,341), n3(:,706), t3x32(:,:,341), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,26), wf4(:,91), A(:,342), n3(:,707), t3x32(:,:,342), nhel, den(87))
    call Hcont_QA(nsync, wf4(:,29), wf8(:,111), A(:,343), n3(:,708), t3x32(:,:,343), nhel, den(81))
    call Hcont_QA(nsync, wf8(:,28), wf4(:,93), A(:,344), n3(:,709), t3x32(:,:,344), nhel, den(83))
    call Hcont_QA(nsync, wf4(:,35), wf8(:,105), A(:,345), n3(:,710), t3x32(:,:,345), nhel, den(250))
    call Hcont_QA(nsync, wf4(:,35), wf8(:,108), A(:,346), n3(:,711), t3x32(:,:,346), nhel, den(98))
    call Hcont_QA(nsync, wf8(:,30), wf4(:,91), A(:,347), n3(:,712), t3x32(:,:,347), nhel, den(99))
    call Hcont_QA(nsync, wf4(:,39), wf8(:,103), A(:,348), n3(:,713), t3x32(:,:,348), nhel, den(251))
    call Hcont_QA(nsync, wf8(:,35), wf4(:,90), A(:,349), n3(:,714), t3x32(:,:,349), nhel, den(105))
    call Hcont_QA(nsync, wf4(:,39), wf8(:,112), A(:,350), n3(:,715), t3x32(:,:,350), nhel, den(101))
    call Hcont_QA(nsync, wf8(:,36), wf4(:,93), A(:,351), n3(:,716), t3x32(:,:,351), nhel, den(102))
    call Hcont_QA(nsync, wf8(:,40), wf4(:,92), A(:,352), n3(:,717), t3x32(:,:,352), nhel, den(103))
    call Hcont_QA(nsync, wf4(:,35), wf8(:,115), A(:,353), n3(:,718), t3x32(:,:,353), nhel, den(90))
    call Hcont_QA(nsync, wf8(:,32), wf4(:,95), A(:,354), n3(:,719), t3x32(:,:,354), nhel, den(92))
    call Hcont_QA(nsync, wf4(:,39), wf8(:,116), A(:,355), n3(:,720), t3x32(:,:,355), nhel, den(95))
    call Hcont_QA(nsync, wf8(:,38), wf4(:,95), A(:,356), n3(:,721), t3x32(:,:,356), nhel, den(96))
    call Hcont_QA(nsync, wf8(:,42), wf4(:,94), A(:,357), n3(:,722), t3x32(:,:,357), nhel, den(97))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,118), A(:,358), n3(:,723), t3x32(:,:,358), nhel, den(47))
    call Hcont_QA(nsync, wf8(:,27), wf4(:,96), A(:,359), n3(:,724), t3x32(:,:,359), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,28), wf4(:,98), A(:,360), n3(:,725), t3x32(:,:,360), nhel, den(53))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,119), A(:,361), n3(:,726), t3x32(:,:,361), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,31), wf4(:,96), A(:,362), n3(:,727), t3x32(:,:,362), nhel, den(58))
    call Hcont_QA(nsync, wf8(:,32), wf4(:,100), A(:,363), n3(:,728), t3x32(:,:,363), nhel, den(61))
    call Hcont_VV(nsync, wf4(:,15), wf8(:,120), A(:,364), n3(:,729), t3x32(:,:,364), nhel, den(64))
    call Hcont_QA(nsync, wf8(:,35), wf4(:,96), A(:,365), n3(:,730), t3x32(:,:,365), nhel, den(68))
    call Hcont_VV(nsync, wf8(:,13), wf4(:,43), A(:,366), n3(:,731), t3x32(:,:,366), nhel, den(66))
    call Hcont_QA(nsync, wf8(:,37), wf4(:,97), A(:,367), n3(:,732), t3x32(:,:,367), nhel, den(71))
    call Hcont_QA(nsync, wf8(:,38), wf4(:,100), A(:,368), n3(:,733), t3x32(:,:,368), nhel, den(72))
    call Hcont_QA(nsync, wf8(:,40), wf4(:,97), A(:,369), n3(:,734), t3x32(:,:,369), nhel, den(75))
    call Hcont_VV(nsync, wf8(:,19), wf4(:,43), A(:,370), n3(:,735), t3x32(:,:,370), nhel, den(73))
    call Hcont_QA(nsync, wf8(:,42), wf4(:,99), A(:,371), n3(:,736), t3x32(:,:,371), nhel, den(79))
    call Hcont_VV(nsync, wf8(:,22), wf4(:,43), A(:,372), n3(:,737), t3x32(:,:,372), nhel, den(76))
    call Hcont_VV(nsync, wf8(:,13), wf4(:,44), A(:,373), n3(:,738), t3x32(:,:,373), nhel, den(252))
    call Hcont_QA(nsync, wf4(:,64), wf8(:,121), A(:,374), n3(:,739), t3x32(:,:,374), nhel, den(253))
    call Hcont_VV(nsync, wf4(:,15), wf8(:,122), A(:,375), n3(:,740), t3x32(:,:,375), nhel, den(64))
    call Hcont_VV(nsync, wf8(:,19), wf4(:,44), A(:,376), n3(:,741), t3x32(:,:,376), nhel, den(254))
    call Hcont_QA(nsync, wf4(:,21), wf8(:,123), A(:,377), n3(:,742), t3x32(:,:,377), nhel, den(255))
    call Hcont_VV(nsync, wf8(:,22), wf4(:,44), A(:,378), n3(:,743), t3x32(:,:,378), nhel, den(256))
    call Hcont_QA(nsync, wf4(:,25), wf8(:,124), A(:,379), n3(:,744), t3x32(:,:,379), nhel, den(257))
    call Hcont_QA(nsync, wf4(:,20), wf8(:,126), A(:,380), n3(:,745), t3x32(:,:,380), nhel, den(71))
    call Hcont_QA(nsync, wf4(:,25), wf8(:,127), A(:,381), n3(:,746), t3x32(:,:,381), nhel, den(72))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,128), A(:,382), n3(:,747), t3x32(:,:,382), nhel, den(56))
    call Hcont_QA(nsync, wf4(:,19), wf8(:,130), A(:,383), n3(:,748), t3x32(:,:,383), nhel, den(58))
    call Hcont_QA(nsync, wf4(:,25), wf8(:,131), A(:,384), n3(:,749), t3x32(:,:,384), nhel, den(61))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,132), A(:,385), n3(:,750), t3x32(:,:,385), nhel, den(47))
    call Hcont_QA(nsync, wf4(:,19), wf8(:,134), A(:,386), n3(:,751), t3x32(:,:,386), nhel, den(50))
    call Hcont_QA(nsync, wf4(:,21), wf8(:,135), A(:,387), n3(:,752), t3x32(:,:,387), nhel, den(53))
    call Hcont_QA(nsync, wf4(:,37), wf8(:,124), A(:,388), n3(:,753), t3x32(:,:,388), nhel, den(258))
    call Hcont_QA(nsync, wf8(:,6), wf4(:,108), A(:,389), n3(:,754), t3x32(:,:,389), nhel, den(95))
    call Hcont_QA(nsync, wf4(:,37), wf8(:,127), A(:,390), n3(:,755), t3x32(:,:,390), nhel, den(96))
    call Hcont_QA(nsync, wf8(:,5), wf4(:,110), A(:,391), n3(:,756), t3x32(:,:,391), nhel, den(90))
    call Hcont_QA(nsync, wf4(:,37), wf8(:,131), A(:,392), n3(:,757), t3x32(:,:,392), nhel, den(92))
    call Hcont_QA(nsync, wf4(:,31), wf8(:,123), A(:,393), n3(:,758), t3x32(:,:,393), nhel, den(259))
    call Hcont_QA(nsync, wf8(:,10), wf4(:,108), A(:,394), n3(:,759), t3x32(:,:,394), nhel, den(101))
    call Hcont_QA(nsync, wf4(:,31), wf8(:,125), A(:,395), n3(:,760), t3x32(:,:,395), nhel, den(102))
    call Hcont_QA(nsync, wf4(:,33), wf8(:,121), A(:,396), n3(:,761), t3x32(:,:,396), nhel, den(260))
    call Hcont_QA(nsync, wf8(:,15), wf4(:,107), A(:,397), n3(:,762), t3x32(:,:,397), nhel, den(104))
    call Hcont_QA(nsync, wf8(:,17), wf4(:,110), A(:,398), n3(:,763), t3x32(:,:,398), nhel, den(98))
    call Hcont_QA(nsync, wf4(:,33), wf8(:,129), A(:,399), n3(:,764), t3x32(:,:,399), nhel, den(99))
    call Hcont_QA(nsync, wf8(:,21), wf4(:,109), A(:,400), n3(:,765), t3x32(:,:,400), nhel, den(100))
    call Hcont_QA(nsync, wf8(:,9), wf4(:,112), A(:,401), n3(:,766), t3x32(:,:,401), nhel, den(81))
    call Hcont_QA(nsync, wf4(:,31), wf8(:,135), A(:,402), n3(:,767), t3x32(:,:,402), nhel, den(83))
    call Hcont_QA(nsync, wf8(:,16), wf4(:,112), A(:,403), n3(:,768), t3x32(:,:,403), nhel, den(84))
    call Hcont_QA(nsync, wf4(:,33), wf8(:,133), A(:,404), n3(:,769), t3x32(:,:,404), nhel, den(87))
    call Hcont_QA(nsync, wf8(:,24), wf4(:,111), A(:,405), n3(:,770), t3x32(:,:,405), nhel, den(88))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,136), A(:,406), n3(:,771), t3x32(:,:,406), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,5), wf4(:,114), A(:,407), n3(:,772), t3x32(:,:,407), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,7), wf4(:,115), A(:,408), n3(:,773), t3x32(:,:,408), nhel, den(15))
    call Hcont_VV(nsync, wf4(:,10), wf8(:,137), A(:,409), n3(:,774), t3x32(:,:,409), nhel, den(19))
    call Hcont_QA(nsync, wf8(:,9), wf4(:,117), A(:,410), n3(:,775), t3x32(:,:,410), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,11), wf4(:,115), A(:,411), n3(:,776), t3x32(:,:,411), nhel, den(24))
    call Hcont_VV(nsync, wf4(:,15), wf8(:,138), A(:,412), n3(:,777), t3x32(:,:,412), nhel, den(28))
    call Hcont_VV(nsync, wf8(:,13), wf4(:,45), A(:,413), n3(:,778), t3x32(:,:,413), nhel, den(31))
    call Hcont_QA(nsync, wf8(:,15), wf4(:,115), A(:,414), n3(:,779), t3x32(:,:,414), nhel, den(33))
    call Hcont_QA(nsync, wf8(:,16), wf4(:,117), A(:,415), n3(:,780), t3x32(:,:,415), nhel, den(34))
    call Hcont_QA(nsync, wf8(:,18), wf4(:,113), A(:,416), n3(:,781), t3x32(:,:,416), nhel, den(37))
    call Hcont_VV(nsync, wf8(:,19), wf4(:,45), A(:,417), n3(:,782), t3x32(:,:,417), nhel, den(38))
    call Hcont_QA(nsync, wf8(:,21), wf4(:,113), A(:,418), n3(:,783), t3x32(:,:,418), nhel, den(40))
    call Hcont_VV(nsync, wf8(:,22), wf4(:,45), A(:,419), n3(:,784), t3x32(:,:,419), nhel, den(41))
    call Hcont_QA(nsync, wf8(:,24), wf4(:,116), A(:,420), n3(:,785), t3x32(:,:,420), nhel, den(44))
    call Hcont_QA(nsync, wf2(:,12), wf16(:,29), A(:,421), n3(:,786), t3x32(:,:,421), nhel, den(263))
    call Hcont_QA(nsync, wf4(:,118), wf8(:,140), A(:,422), n3(:,787), t3x32(:,:,422), nhel, den(267))
    call Hcont_VV(nsync, wf8(:,4), wf4(:,119), A(:,423), n3(:,788), t3x32(:,:,423), nhel, den(270))
    call Hcont_QA(nsync, wf8(:,55), wf4(:,120), A(:,424), n3(:,789), t3x32(:,:,424), nhel, den(272))
    call Hcont_QA(nsync, wf8(:,7), wf4(:,121), A(:,425), n3(:,790), t3x32(:,:,425), nhel, den(273))
    call Hcont_QA(nsync, wf4(:,56), wf8(:,141), A(:,426), n3(:,791), t3x32(:,:,426), nhel, den(275))
    call Hcont_QA(nsync, wf4(:,7), wf8(:,142), A(:,427), n3(:,792), t3x32(:,:,427), nhel, den(276))
    call Hcont_QA(nsync, wf8(:,55), wf4(:,123), A(:,428), n3(:,793), t3x32(:,:,428), nhel, den(277))
    call Hcont_QA(nsync, wf4(:,56), wf8(:,143), A(:,429), n3(:,794), t3x32(:,:,429), nhel, den(278))
    call Hcont_QA(nsync, wf2(:,12), wf16(:,31), A(:,430), n3(:,795), t3x32(:,:,430), nhel, den(281))
    call Hcont_QA(nsync, wf4(:,124), wf8(:,145), A(:,431), n3(:,796), t3x32(:,:,431), nhel, den(285))
    call Hcont_VV(nsync, wf8(:,8), wf4(:,125), A(:,432), n3(:,797), t3x32(:,:,432), nhel, den(288))
    call Hcont_QA(nsync, wf8(:,69), wf4(:,126), A(:,433), n3(:,798), t3x32(:,:,433), nhel, den(289))
    call Hcont_QA(nsync, wf8(:,11), wf4(:,121), A(:,434), n3(:,799), t3x32(:,:,434), nhel, den(290))
    call Hcont_QA(nsync, wf4(:,56), wf8(:,146), A(:,435), n3(:,800), t3x32(:,:,435), nhel, den(292))
    call Hcont_QA(nsync, wf4(:,13), wf8(:,147), A(:,436), n3(:,801), t3x32(:,:,436), nhel, den(293))
    call Hcont_QA(nsync, wf8(:,69), wf4(:,128), A(:,437), n3(:,802), t3x32(:,:,437), nhel, den(294))
    call Hcont_QA(nsync, wf4(:,56), wf8(:,148), A(:,438), n3(:,803), t3x32(:,:,438), nhel, den(295))
    call Hcont_QA(nsync, wf2(:,12), wf16(:,33), A(:,439), n3(:,804), t3x32(:,:,439), nhel, den(298))
    call Hcont_QA(nsync, wf4(:,129), wf8(:,150), A(:,440), n3(:,805), t3x32(:,:,440), nhel, den(302))
    call Hcont_VV(nsync, wf8(:,12), wf4(:,130), A(:,441), n3(:,806), t3x32(:,:,441), nhel, den(305))
    call Hcont_VV(nsync, wf8(:,13), wf4(:,131), A(:,442), n3(:,807), t3x32(:,:,442), nhel, den(306))
    call Hcont_QA(nsync, wf8(:,15), wf4(:,121), A(:,443), n3(:,808), t3x32(:,:,443), nhel, den(307))
    call Hcont_QA(nsync, wf4(:,56), wf8(:,151), A(:,444), n3(:,809), t3x32(:,:,444), nhel, den(309))
    call Hcont_VV(nsync, wf8(:,13), wf4(:,132), A(:,445), n3(:,810), t3x32(:,:,445), nhel, den(310))
    call Hcont_QA(nsync, wf4(:,56), wf8(:,152), A(:,446), n3(:,811), t3x32(:,:,446), nhel, den(311))
    call Hcont_VV(nsync, wf4(:,1), wf8(:,153), A(:,447), n3(:,812), t3x32(:,:,447), nhel, den(312))
    call Hcont_QA(nsync, wf8(:,71), wf4(:,126), A(:,448), n3(:,813), t3x32(:,:,448), nhel, den(313))
    call Hcont_QA(nsync, wf8(:,18), wf4(:,120), A(:,449), n3(:,814), t3x32(:,:,449), nhel, den(314))
    call Hcont_QA(nsync, wf4(:,7), wf8(:,154), A(:,450), n3(:,815), t3x32(:,:,450), nhel, den(316))
    call Hcont_QA(nsync, wf4(:,13), wf8(:,155), A(:,451), n3(:,816), t3x32(:,:,451), nhel, den(317))
    call Hcont_QA(nsync, wf8(:,71), wf4(:,128), A(:,452), n3(:,817), t3x32(:,:,452), nhel, den(318))
    call Hcont_QA(nsync, wf4(:,7), wf8(:,156), A(:,453), n3(:,818), t3x32(:,:,453), nhel, den(319))
    call Hcont_VV(nsync, wf8(:,19), wf4(:,131), A(:,454), n3(:,819), t3x32(:,:,454), nhel, den(320))
    call Hcont_QA(nsync, wf8(:,21), wf4(:,120), A(:,455), n3(:,820), t3x32(:,:,455), nhel, den(321))
    call Hcont_QA(nsync, wf4(:,7), wf8(:,157), A(:,456), n3(:,821), t3x32(:,:,456), nhel, den(323))
    call Hcont_VV(nsync, wf8(:,19), wf4(:,132), A(:,457), n3(:,822), t3x32(:,:,457), nhel, den(324))
    call Hcont_QA(nsync, wf4(:,7), wf8(:,158), A(:,458), n3(:,823), t3x32(:,:,458), nhel, den(325))
    call Hcont_VV(nsync, wf4(:,1), wf8(:,159), A(:,459), n3(:,824), t3x32(:,:,459), nhel, den(326))
    call Hcont_VV(nsync, wf8(:,22), wf4(:,131), A(:,460), n3(:,825), t3x32(:,:,460), nhel, den(327))
    call Hcont_QA(nsync, wf8(:,24), wf4(:,126), A(:,461), n3(:,826), t3x32(:,:,461), nhel, den(328))
    call Hcont_VV(nsync, wf8(:,22), wf4(:,132), A(:,462), n3(:,827), t3x32(:,:,462), nhel, den(329))
    call Hcont_QA(nsync, wf4(:,13), wf8(:,160), A(:,463), n3(:,828), t3x32(:,:,463), nhel, den(330))
    call Hcont_QA(nsync, wf4(:,13), wf8(:,161), A(:,464), n3(:,829), t3x32(:,:,464), nhel, den(332))
    call Hcont_VV(nsync, wf4(:,1), wf8(:,162), A(:,465), n3(:,830), t3x32(:,:,465), nhel, den(333))
    call Hcont_QA(nsync, wf4(:,134), wf8(:,164), A(:,466), n3(:,831), t3x32(:,:,466), nhel, den(337))
    call Hcont_QA(nsync, wf2(:,13), wf16(:,35), A(:,467), n3(:,832), t3x32(:,:,467), nhel, den(340))
    call Hcont_VV(nsync, wf8(:,25), wf4(:,119), A(:,468), n3(:,833), t3x32(:,:,468), nhel, den(342))
    call Hcont_QA(nsync, wf4(:,64), wf8(:,165), A(:,469), n3(:,834), t3x32(:,:,469), nhel, den(344))
    call Hcont_QA(nsync, wf4(:,21), wf8(:,166), A(:,470), n3(:,835), t3x32(:,:,470), nhel, den(345))
    call Hcont_QA(nsync, wf8(:,81), wf4(:,136), A(:,471), n3(:,836), t3x32(:,:,471), nhel, den(347))
    call Hcont_QA(nsync, wf8(:,27), wf4(:,137), A(:,472), n3(:,837), t3x32(:,:,472), nhel, den(348))
    call Hcont_QA(nsync, wf4(:,64), wf8(:,167), A(:,473), n3(:,838), t3x32(:,:,473), nhel, den(349))
    call Hcont_QA(nsync, wf8(:,81), wf4(:,138), A(:,474), n3(:,839), t3x32(:,:,474), nhel, den(350))
    call Hcont_QA(nsync, wf4(:,139), wf8(:,169), A(:,475), n3(:,840), t3x32(:,:,475), nhel, den(354))
    call Hcont_QA(nsync, wf2(:,13), wf16(:,37), A(:,476), n3(:,841), t3x32(:,:,476), nhel, den(357))
    call Hcont_VV(nsync, wf8(:,29), wf4(:,125), A(:,477), n3(:,842), t3x32(:,:,477), nhel, den(359))
    call Hcont_QA(nsync, wf4(:,64), wf8(:,170), A(:,478), n3(:,843), t3x32(:,:,478), nhel, den(361))
    call Hcont_QA(nsync, wf4(:,25), wf8(:,171), A(:,479), n3(:,844), t3x32(:,:,479), nhel, den(362))
    call Hcont_QA(nsync, wf8(:,89), wf4(:,141), A(:,480), n3(:,845), t3x32(:,:,480), nhel, den(363))
    call Hcont_QA(nsync, wf8(:,31), wf4(:,137), A(:,481), n3(:,846), t3x32(:,:,481), nhel, den(364))
    call Hcont_QA(nsync, wf4(:,64), wf8(:,172), A(:,482), n3(:,847), t3x32(:,:,482), nhel, den(365))
    call Hcont_QA(nsync, wf8(:,89), wf4(:,142), A(:,483), n3(:,848), t3x32(:,:,483), nhel, den(366))
    call Hcont_QA(nsync, wf4(:,143), wf8(:,174), A(:,484), n3(:,849), t3x32(:,:,484), nhel, den(370))
    call Hcont_QA(nsync, wf2(:,13), wf16(:,39), A(:,485), n3(:,850), t3x32(:,:,485), nhel, den(373))
    call Hcont_VV(nsync, wf8(:,33), wf4(:,130), A(:,486), n3(:,851), t3x32(:,:,486), nhel, den(375))
    call Hcont_VV(nsync, wf8(:,13), wf4(:,144), A(:,487), n3(:,852), t3x32(:,:,487), nhel, den(376))
    call Hcont_QA(nsync, wf4(:,64), wf8(:,175), A(:,488), n3(:,853), t3x32(:,:,488), nhel, den(377))
    call Hcont_VV(nsync, wf8(:,13), wf4(:,145), A(:,489), n3(:,854), t3x32(:,:,489), nhel, den(378))
    call Hcont_QA(nsync, wf4(:,64), wf8(:,176), A(:,490), n3(:,855), t3x32(:,:,490), nhel, den(379))
    call Hcont_QA(nsync, wf8(:,35), wf4(:,137), A(:,491), n3(:,856), t3x32(:,:,491), nhel, den(380))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,153), A(:,492), n3(:,857), t3x32(:,:,492), nhel, den(381))
    call Hcont_QA(nsync, wf4(:,21), wf8(:,177), A(:,493), n3(:,858), t3x32(:,:,493), nhel, den(383))
    call Hcont_QA(nsync, wf4(:,25), wf8(:,178), A(:,494), n3(:,859), t3x32(:,:,494), nhel, den(384))
    call Hcont_QA(nsync, wf8(:,91), wf4(:,141), A(:,495), n3(:,860), t3x32(:,:,495), nhel, den(385))
    call Hcont_QA(nsync, wf8(:,37), wf4(:,136), A(:,496), n3(:,861), t3x32(:,:,496), nhel, den(386))
    call Hcont_QA(nsync, wf4(:,21), wf8(:,179), A(:,497), n3(:,862), t3x32(:,:,497), nhel, den(387))
    call Hcont_QA(nsync, wf8(:,91), wf4(:,142), A(:,498), n3(:,863), t3x32(:,:,498), nhel, den(388))
    call Hcont_VV(nsync, wf8(:,19), wf4(:,144), A(:,499), n3(:,864), t3x32(:,:,499), nhel, den(389))
    call Hcont_QA(nsync, wf4(:,21), wf8(:,180), A(:,500), n3(:,865), t3x32(:,:,500), nhel, den(390))
    call Hcont_VV(nsync, wf8(:,19), wf4(:,145), A(:,501), n3(:,866), t3x32(:,:,501), nhel, den(391))
    call Hcont_QA(nsync, wf4(:,21), wf8(:,181), A(:,502), n3(:,867), t3x32(:,:,502), nhel, den(392))
    call Hcont_QA(nsync, wf8(:,40), wf4(:,136), A(:,503), n3(:,868), t3x32(:,:,503), nhel, den(393))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,159), A(:,504), n3(:,869), t3x32(:,:,504), nhel, den(394))
    call Hcont_VV(nsync, wf8(:,22), wf4(:,144), A(:,505), n3(:,870), t3x32(:,:,505), nhel, den(395))
    call Hcont_VV(nsync, wf8(:,22), wf4(:,145), A(:,506), n3(:,871), t3x32(:,:,506), nhel, den(396))
    call Hcont_QA(nsync, wf4(:,25), wf8(:,182), A(:,507), n3(:,872), t3x32(:,:,507), nhel, den(397))
    call Hcont_QA(nsync, wf4(:,25), wf8(:,183), A(:,508), n3(:,873), t3x32(:,:,508), nhel, den(398))
    call Hcont_QA(nsync, wf8(:,42), wf4(:,141), A(:,509), n3(:,874), t3x32(:,:,509), nhel, den(399))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,162), A(:,510), n3(:,875), t3x32(:,:,510), nhel, den(400))
    call Hcont_QA(nsync, wf8(:,69), wf4(:,147), A(:,511), n3(:,876), t3x32(:,:,511), nhel, den(401))
    call Hcont_QA(nsync, wf4(:,31), wf8(:,166), A(:,512), n3(:,877), t3x32(:,:,512), nhel, den(402))
    call Hcont_QA(nsync, wf8(:,81), wf4(:,148), A(:,513), n3(:,878), t3x32(:,:,513), nhel, den(403))
    call Hcont_QA(nsync, wf4(:,29), wf8(:,147), A(:,514), n3(:,879), t3x32(:,:,514), nhel, den(404))
    call Hcont_QA(nsync, wf8(:,69), wf4(:,149), A(:,515), n3(:,880), t3x32(:,:,515), nhel, den(405))
    call Hcont_QA(nsync, wf8(:,81), wf4(:,150), A(:,516), n3(:,881), t3x32(:,:,516), nhel, den(406))
    call Hcont_QA(nsync, wf8(:,71), wf4(:,147), A(:,517), n3(:,882), t3x32(:,:,517), nhel, den(407))
    call Hcont_QA(nsync, wf4(:,33), wf8(:,165), A(:,518), n3(:,883), t3x32(:,:,518), nhel, den(408))
    call Hcont_QA(nsync, wf8(:,27), wf4(:,151), A(:,519), n3(:,884), t3x32(:,:,519), nhel, den(409))
    call Hcont_QA(nsync, wf4(:,29), wf8(:,155), A(:,520), n3(:,885), t3x32(:,:,520), nhel, den(410))
    call Hcont_QA(nsync, wf8(:,71), wf4(:,149), A(:,521), n3(:,886), t3x32(:,:,521), nhel, den(411))
    call Hcont_QA(nsync, wf8(:,27), wf4(:,152), A(:,522), n3(:,887), t3x32(:,:,522), nhel, den(412))
    call Hcont_QA(nsync, wf8(:,24), wf4(:,147), A(:,523), n3(:,888), t3x32(:,:,523), nhel, den(413))
    call Hcont_QA(nsync, wf4(:,29), wf8(:,160), A(:,524), n3(:,889), t3x32(:,:,524), nhel, den(414))
    call Hcont_QA(nsync, wf4(:,29), wf8(:,161), A(:,525), n3(:,890), t3x32(:,:,525), nhel, den(415))
    call Hcont_QA(nsync, wf8(:,55), wf4(:,153), A(:,526), n3(:,891), t3x32(:,:,526), nhel, den(416))
    call Hcont_QA(nsync, wf4(:,37), wf8(:,171), A(:,527), n3(:,892), t3x32(:,:,527), nhel, den(417))
    call Hcont_QA(nsync, wf8(:,89), wf4(:,154), A(:,528), n3(:,893), t3x32(:,:,528), nhel, den(418))
    call Hcont_QA(nsync, wf4(:,35), wf8(:,142), A(:,529), n3(:,894), t3x32(:,:,529), nhel, den(419))
    call Hcont_QA(nsync, wf8(:,55), wf4(:,155), A(:,530), n3(:,895), t3x32(:,:,530), nhel, den(420))
    call Hcont_QA(nsync, wf8(:,89), wf4(:,156), A(:,531), n3(:,896), t3x32(:,:,531), nhel, den(421))
    call Hcont_QA(nsync, wf8(:,7), wf4(:,157), A(:,532), n3(:,897), t3x32(:,:,532), nhel, den(422))
    call Hcont_QA(nsync, wf4(:,37), wf8(:,178), A(:,533), n3(:,898), t3x32(:,:,533), nhel, den(423))
    call Hcont_QA(nsync, wf8(:,91), wf4(:,154), A(:,534), n3(:,899), t3x32(:,:,534), nhel, den(424))
    call Hcont_QA(nsync, wf4(:,39), wf8(:,141), A(:,535), n3(:,900), t3x32(:,:,535), nhel, den(425))
    call Hcont_QA(nsync, wf8(:,7), wf4(:,158), A(:,536), n3(:,901), t3x32(:,:,536), nhel, den(426))
    call Hcont_QA(nsync, wf8(:,91), wf4(:,156), A(:,537), n3(:,902), t3x32(:,:,537), nhel, den(427))
    call Hcont_QA(nsync, wf4(:,37), wf8(:,182), A(:,538), n3(:,903), t3x32(:,:,538), nhel, den(428))
    call Hcont_QA(nsync, wf4(:,37), wf8(:,183), A(:,539), n3(:,904), t3x32(:,:,539), nhel, den(429))
    call Hcont_QA(nsync, wf8(:,42), wf4(:,154), A(:,540), n3(:,905), t3x32(:,:,540), nhel, den(430))
    call Hcont_QA(nsync, wf8(:,18), wf4(:,153), A(:,541), n3(:,906), t3x32(:,:,541), nhel, den(431))
    call Hcont_QA(nsync, wf4(:,33), wf8(:,170), A(:,542), n3(:,907), t3x32(:,:,542), nhel, den(432))
    call Hcont_QA(nsync, wf8(:,31), wf4(:,151), A(:,543), n3(:,908), t3x32(:,:,543), nhel, den(433))
    call Hcont_QA(nsync, wf4(:,35), wf8(:,154), A(:,544), n3(:,909), t3x32(:,:,544), nhel, den(434))
    call Hcont_QA(nsync, wf8(:,18), wf4(:,155), A(:,545), n3(:,910), t3x32(:,:,545), nhel, den(435))
    call Hcont_QA(nsync, wf8(:,31), wf4(:,152), A(:,546), n3(:,911), t3x32(:,:,546), nhel, den(436))
    call Hcont_QA(nsync, wf8(:,21), wf4(:,153), A(:,547), n3(:,912), t3x32(:,:,547), nhel, den(437))
    call Hcont_QA(nsync, wf4(:,35), wf8(:,158), A(:,548), n3(:,913), t3x32(:,:,548), nhel, den(438))
    call Hcont_QA(nsync, wf4(:,35), wf8(:,157), A(:,549), n3(:,914), t3x32(:,:,549), nhel, den(439))
    call Hcont_QA(nsync, wf8(:,11), wf4(:,157), A(:,550), n3(:,915), t3x32(:,:,550), nhel, den(440))
    call Hcont_QA(nsync, wf4(:,31), wf8(:,177), A(:,551), n3(:,916), t3x32(:,:,551), nhel, den(441))
    call Hcont_QA(nsync, wf8(:,37), wf4(:,148), A(:,552), n3(:,917), t3x32(:,:,552), nhel, den(442))
    call Hcont_QA(nsync, wf4(:,39), wf8(:,146), A(:,553), n3(:,918), t3x32(:,:,553), nhel, den(443))
    call Hcont_QA(nsync, wf8(:,11), wf4(:,158), A(:,554), n3(:,919), t3x32(:,:,554), nhel, den(444))
    call Hcont_QA(nsync, wf8(:,37), wf4(:,150), A(:,555), n3(:,920), t3x32(:,:,555), nhel, den(445))
    call Hcont_QA(nsync, wf4(:,31), wf8(:,181), A(:,556), n3(:,921), t3x32(:,:,556), nhel, den(446))
    call Hcont_QA(nsync, wf4(:,31), wf8(:,180), A(:,557), n3(:,922), t3x32(:,:,557), nhel, den(447))
    call Hcont_QA(nsync, wf8(:,40), wf4(:,148), A(:,558), n3(:,923), t3x32(:,:,558), nhel, den(448))
    call Hcont_QA(nsync, wf8(:,15), wf4(:,157), A(:,559), n3(:,924), t3x32(:,:,559), nhel, den(449))
    call Hcont_QA(nsync, wf4(:,39), wf8(:,152), A(:,560), n3(:,925), t3x32(:,:,560), nhel, den(450))
    call Hcont_QA(nsync, wf4(:,39), wf8(:,151), A(:,561), n3(:,926), t3x32(:,:,561), nhel, den(451))
    call Hcont_QA(nsync, wf4(:,33), wf8(:,176), A(:,562), n3(:,927), t3x32(:,:,562), nhel, den(452))
    call Hcont_QA(nsync, wf4(:,33), wf8(:,175), A(:,563), n3(:,928), t3x32(:,:,563), nhel, den(453))
    call Hcont_QA(nsync, wf8(:,35), wf4(:,151), A(:,564), n3(:,929), t3x32(:,:,564), nhel, den(454))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(6), M2(11) ! M1helarray(11,32)
  integer :: empty(0), i

  M1(1)%j = (A(j,1)%j-A(j,2)%j+A(j,4)%j-A(j,5)%j+A(j,9)%j+A(j,14)%j+A(j,20)%j+A(j,29)%j+A(j,32)%j+A(j,35)%j+A(j,44)%j &
       +A(j,45)%j)*f(7)+CI*(A(j,7)%j+A(j,15)%j+A(j,28)%j+A(j,36)%j+A(j,46)%j+A(j,53)%j)*f(8)
  M1(2)%j = (A(j,2)%j-A(j,3)%j+A(j,5)%j-A(j,6)%j+A(j,8)%j-A(j,18)%j-A(j,20)%j+A(j,27)%j-A(j,33)%j-A(j,35)%j+A(j,42)%j &
       +A(j,43)%j)*f(7)+CI*(-A(j,7)%j+A(j,19)%j+A(j,25)%j-A(j,36)%j-A(j,46)%j+A(j,49)%j)*f(8)
  M1(3)%j = (-A(j,1)%j+A(j,3)%j-A(j,4)%j+A(j,6)%j+A(j,12)%j-A(j,14)%j+A(j,18)%j-A(j,29)%j+A(j,31)%j+A(j,33)%j+A(j,50)%j &
       +A(j,51)%j)*f(7)+CI*(A(j,10)%j-A(j,15)%j-A(j,28)%j+A(j,34)%j+A(j,52)%j-A(j,53)%j)*f(8)
  M1(4)%j = (A(j,2)%j-A(j,3)%j+A(j,5)%j-A(j,6)%j+A(j,11)%j-A(j,18)%j-A(j,20)%j+A(j,24)%j-A(j,33)%j-A(j,35)%j+A(j,37)%j &
       +A(j,38)%j)*f(7)+CI*(-A(j,10)%j+A(j,21)%j+A(j,22)%j-A(j,34)%j+A(j,41)%j-A(j,52)%j)*f(8)
  M1(5)%j = (-A(j,1)%j+A(j,3)%j-A(j,4)%j+A(j,6)%j-A(j,14)%j+A(j,17)%j+A(j,18)%j+A(j,26)%j-A(j,29)%j+A(j,33)%j+A(j,47)%j &
       +A(j,48)%j)*f(7)+CI*(A(j,13)%j-A(j,19)%j-A(j,25)%j+A(j,30)%j-A(j,49)%j+A(j,54)%j)*f(8)
  M1(6)%j = (A(j,1)%j-A(j,2)%j+A(j,4)%j-A(j,5)%j+A(j,14)%j+A(j,16)%j+A(j,20)%j+A(j,23)%j+A(j,29)%j+A(j,35)%j+A(j,39)%j &
       +A(j,40)%j)*f(7)+CI*(-A(j,13)%j-A(j,21)%j-A(j,22)%j-A(j,30)%j-A(j,41)%j-A(j,54)%j)*f(8)

  M2( 1)%j = (A(j,58)%j-A(j,59)%j+A(j,64)%j-A(j,65)%j-A(j,70)%j+A(j,72)%j+A(j,77)%j-A(j,78)%j-A(j,104)%j+A(j,106)%j-A(j,108)%j &
        +A(j,114)%j+A(j,116)%j+A(j,118)%j+A(j,124)%j-A(j,126)%j+A(j,128)%j-A(j,132)%j+A(j,254)%j+A(j,256)%j+A(j,316)%j)*f(1) &
        +CI*(A(j,249)%j+A(j,252)%j+A(j,258)%j+A(j,280)%j+A(j,288)%j+A(j,290)%j+A(j,314)%j+A(j,322)%j)*f(2)+(A(j,55)%j-A(j,56)%j &
        +A(j,61)%j-A(j,62)%j-A(j,67)%j+A(j,69)%j+A(j,74)%j-A(j,75)%j-A(j,103)%j+A(j,105)%j-A(j,107)%j+A(j,113)%j+A(j,115)%j &
        +A(j,117)%j+A(j,123)%j-A(j,125)%j+A(j,127)%j-A(j,131)%j+A(j,253)%j+A(j,255)%j+A(j,315)%j)*f(5)+CI*(A(j,248)%j+A(j,251)%j &
        +A(j,257)%j+A(j,279)%j+A(j,287)%j+A(j,289)%j+A(j,313)%j+A(j,321)%j)*f(6)+(-A(j,151)%j+A(j,152)%j-A(j,154)%j+A(j,155)%j &
        -A(j,187)%j+A(j,188)%j-A(j,190)%j+A(j,191)%j-A(j,425)%j-A(j,426)%j-A(j,429)%j-A(j,442)%j-A(j,445)%j-A(j,447)%j-A(j,460)%j &
        -A(j,462)%j-A(j,465)%j-A(j,487)%j-A(j,489)%j-A(j,492)%j-A(j,494)%j-A(j,495)%j-A(j,498)%j-A(j,505)%j-A(j,506)%j-A(j,510)%j &
        -A(j,532)%j-A(j,533)%j-A(j,534)%j-A(j,535)%j-A(j,536)%j-A(j,537)%j)*f(9)+CI*(-A(j,421)%j-A(j,422)%j-A(j,423)%j-A(j,443)%j &
        -A(j,444)%j-A(j,446)%j-A(j,484)%j-A(j,485)%j-A(j,486)%j-A(j,507)%j-A(j,508)%j-A(j,509)%j-A(j,538)%j-A(j,539)%j-A(j,540)%j &
        -A(j,559)%j-A(j,560)%j-A(j,561)%j)*f(10)+(A(j,91)%j-A(j,92)%j+A(j,97)%j-A(j,98)%j+A(j,135)%j+A(j,136)%j+A(j,182)%j &
        +A(j,196)%j+A(j,212)%j+A(j,213)%j+A(j,326)%j+A(j,331)%j+A(j,339)%j+A(j,355)%j+A(j,356)%j+A(j,373)%j+A(j,378)%j+A(j,381)%j &
        +A(j,389)%j+A(j,390)%j)*f(11)+CI*(A(j,133)%j+A(j,144)%j+A(j,178)%j+A(j,199)%j+A(j,325)%j+A(j,337)%j+A(j,348)%j+A(j,357)%j &
        +A(j,375)%j+A(j,379)%j+A(j,388)%j+A(j,397)%j)*f(12)+(A(j,94)%j-A(j,95)%j+A(j,100)%j-A(j,101)%j+A(j,246)%j+A(j,247)%j &
        +A(j,366)%j+A(j,368)%j+A(j,372)%j+A(j,408)%j+A(j,413)%j+A(j,419)%j)*f(13)+CI*(A(j,250)%j+A(j,281)%j+A(j,364)%j+A(j,371)%j &
        +A(j,406)%j+A(j,414)%j)*f(14)+(A(j,143)%j+A(j,149)%j+A(j,162)%j+A(j,167)%j+A(j,179)%j+A(j,185)%j+A(j,198)%j &
        +A(j,203)%j)*f(15)+CI*(A(j,138)%j+A(j,168)%j+A(j,186)%j+A(j,202)%j+A(j,214)%j+A(j,221)%j)*f(16)+(-A(j,79)%j-A(j,80)%j &
        -A(j,85)%j-A(j,86)%j)*f(17)+2*(A(j,81)%j+A(j,87)%j)*f(17)+(19*(A(j,82)%j+A(j,83)%j+A(j,88)%j &
        +A(j,89)%j)*f(18))/2._/**/REALKIND+18*(-A(j,84)%j-A(j,90)%j)*f(18)
  M2( 2)%j = (A(j,59)%j-A(j,60)%j-A(j,64)%j+A(j,66)%j+A(j,70)%j-A(j,71)%j+A(j,76)%j-A(j,77)%j-A(j,110)%j-A(j,112)%j-A(j,114)%j &
        -A(j,116)%j-A(j,118)%j-A(j,120)%j-A(j,122)%j-A(j,124)%j-A(j,128)%j-A(j,130)%j+A(j,245)%j+A(j,260)%j+A(j,306)%j)*f(1)+CI*( &
        -A(j,249)%j-A(j,252)%j-A(j,258)%j+A(j,264)%j+A(j,267)%j+A(j,300)%j+A(j,304)%j-A(j,322)%j)*f(2)+(A(j,56)%j-A(j,57)%j &
        -A(j,61)%j+A(j,63)%j+A(j,67)%j-A(j,68)%j+A(j,73)%j-A(j,74)%j-A(j,109)%j-A(j,111)%j-A(j,113)%j-A(j,115)%j-A(j,117)%j &
        -A(j,119)%j-A(j,121)%j-A(j,123)%j-A(j,127)%j-A(j,129)%j+A(j,244)%j+A(j,259)%j+A(j,305)%j)*f(5)+CI*(-A(j,248)%j-A(j,251)%j &
        -A(j,257)%j+A(j,263)%j+A(j,266)%j+A(j,299)%j+A(j,303)%j-A(j,321)%j)*f(6)+(-A(j,152)%j+A(j,153)%j-A(j,155)%j+A(j,156)%j &
        -A(j,188)%j+A(j,189)%j-A(j,191)%j+A(j,192)%j-A(j,424)%j-A(j,427)%j-A(j,428)%j+A(j,454)%j+A(j,457)%j+A(j,459)%j+A(j,460)%j &
        +A(j,462)%j+A(j,465)%j-A(j,479)%j-A(j,480)%j-A(j,483)%j+A(j,499)%j+A(j,501)%j+A(j,504)%j+A(j,505)%j+A(j,506)%j+A(j,510)%j &
        -A(j,526)%j-A(j,527)%j-A(j,528)%j-A(j,529)%j-A(j,530)%j-A(j,531)%j)*f(9)+CI*(A(j,421)%j+A(j,422)%j+A(j,423)%j-A(j,455)%j &
        -A(j,456)%j-A(j,458)%j-A(j,475)%j-A(j,476)%j-A(j,477)%j+A(j,507)%j+A(j,508)%j+A(j,509)%j+A(j,538)%j+A(j,539)%j+A(j,540)%j &
        -A(j,547)%j-A(j,548)%j-A(j,549)%j)*f(10)+(A(j,92)%j-A(j,93)%j+A(j,98)%j-A(j,99)%j+A(j,134)%j+A(j,137)%j+A(j,177)%j &
        +A(j,193)%j+A(j,210)%j+A(j,211)%j-A(j,329)%j-A(j,331)%j+A(j,338)%j+A(j,353)%j+A(j,354)%j-A(j,376)%j-A(j,378)%j+A(j,384)%j &
        +A(j,391)%j+A(j,392)%j)*f(11)+CI*(-A(j,133)%j+A(j,148)%j+A(j,175)%j-A(j,199)%j+A(j,328)%j-A(j,337)%j+A(j,345)%j-A(j,357)%j &
        -A(j,379)%j+A(j,382)%j-A(j,388)%j+A(j,400)%j)*f(12)+(A(j,95)%j-A(j,96)%j+A(j,101)%j-A(j,102)%j+A(j,242)%j+A(j,243)%j &
        +A(j,363)%j-A(j,370)%j-A(j,372)%j+A(j,407)%j-A(j,417)%j-A(j,419)%j)*f(13)+CI*(-A(j,250)%j+A(j,265)%j+A(j,361)%j-A(j,371)%j &
        -A(j,406)%j+A(j,418)%j)*f(14)+(-A(j,147)%j-A(j,149)%j-A(j,162)%j-A(j,164)%j-A(j,183)%j-A(j,185)%j-A(j,198)%j &
        -A(j,200)%j)*f(15)+CI*(-A(j,138)%j+A(j,165)%j-A(j,186)%j+A(j,195)%j-A(j,214)%j+A(j,217)%j)*f(16)+2*(A(j,79)%j &
        +A(j,85)%j)*f(17)+(-A(j,80)%j-A(j,81)%j-A(j,86)%j-A(j,87)%j)*f(17)+18*(-A(j,82)%j-A(j,88)%j)*f(18)+(19*(A(j,83)%j &
        +A(j,84)%j+A(j,89)%j+A(j,90)%j)*f(18))/2._/**/REALKIND
  M2( 3)%j = (-A(j,58)%j+A(j,60)%j+A(j,65)%j-A(j,66)%j+A(j,71)%j-A(j,72)%j-A(j,76)%j+A(j,78)%j+A(j,104)%j-A(j,106)%j+A(j,108)%j &
        +A(j,110)%j+A(j,112)%j+A(j,120)%j+A(j,122)%j+A(j,126)%j+A(j,130)%j+A(j,132)%j+A(j,278)%j+A(j,292)%j+A(j,308)%j)*f(1) &
        +CI*(A(j,273)%j+A(j,276)%j-A(j,280)%j-A(j,288)%j-A(j,290)%j+A(j,298)%j+A(j,310)%j-A(j,314)%j)*f(2)+(-A(j,55)%j+A(j,57)%j &
        +A(j,62)%j-A(j,63)%j+A(j,68)%j-A(j,69)%j-A(j,73)%j+A(j,75)%j+A(j,103)%j-A(j,105)%j+A(j,107)%j+A(j,109)%j+A(j,111)%j &
        +A(j,119)%j+A(j,121)%j+A(j,125)%j+A(j,129)%j+A(j,131)%j+A(j,277)%j+A(j,291)%j+A(j,307)%j)*f(5)+CI*(A(j,272)%j+A(j,275)%j &
        -A(j,279)%j-A(j,287)%j-A(j,289)%j+A(j,297)%j+A(j,309)%j-A(j,313)%j)*f(6)+(A(j,151)%j-A(j,153)%j+A(j,154)%j-A(j,156)%j &
        +A(j,187)%j-A(j,189)%j+A(j,190)%j-A(j,192)%j-A(j,434)%j-A(j,435)%j-A(j,438)%j+A(j,442)%j+A(j,445)%j+A(j,447)%j-A(j,454)%j &
        -A(j,457)%j-A(j,459)%j+A(j,487)%j+A(j,489)%j+A(j,492)%j-A(j,493)%j-A(j,496)%j-A(j,497)%j-A(j,499)%j-A(j,501)%j-A(j,504)%j &
        -A(j,550)%j-A(j,551)%j-A(j,552)%j-A(j,553)%j-A(j,554)%j-A(j,555)%j)*f(9)+CI*(-A(j,430)%j-A(j,431)%j-A(j,432)%j+A(j,443)%j &
        +A(j,444)%j+A(j,446)%j+A(j,484)%j+A(j,485)%j+A(j,486)%j-A(j,500)%j-A(j,502)%j-A(j,503)%j-A(j,556)%j-A(j,557)%j-A(j,558)%j &
        +A(j,559)%j+A(j,560)%j+A(j,561)%j)*f(10)+(-A(j,91)%j+A(j,93)%j-A(j,97)%j+A(j,99)%j+A(j,141)%j+A(j,157)%j+A(j,181)%j &
        +A(j,197)%j+A(j,218)%j+A(j,219)%j-A(j,326)%j+A(j,329)%j+A(j,336)%j+A(j,350)%j+A(j,351)%j-A(j,373)%j+A(j,376)%j+A(j,380)%j &
        +A(j,394)%j+A(j,395)%j)*f(11)+CI*(A(j,139)%j-A(j,144)%j-A(j,178)%j+A(j,184)%j-A(j,325)%j+A(j,334)%j-A(j,348)%j+A(j,352)%j &
        -A(j,375)%j+A(j,377)%j+A(j,393)%j-A(j,397)%j)*f(12)+(-A(j,94)%j+A(j,96)%j-A(j,100)%j+A(j,102)%j+A(j,270)%j+A(j,271)%j &
        -A(j,366)%j+A(j,367)%j+A(j,370)%j+A(j,411)%j-A(j,413)%j+A(j,417)%j)*f(13)+CI*(A(j,274)%j-A(j,281)%j-A(j,364)%j+A(j,369)%j &
        +A(j,409)%j-A(j,414)%j)*f(14)+(-A(j,143)%j+A(j,147)%j+A(j,164)%j-A(j,167)%j-A(j,179)%j+A(j,183)%j+A(j,200)%j &
        -A(j,203)%j)*f(15)+CI*(A(j,159)%j-A(j,168)%j+A(j,201)%j-A(j,202)%j+A(j,220)%j-A(j,221)%j)*f(16)+2*(A(j,80)%j &
        +A(j,86)%j)*f(17)+(-A(j,79)%j-A(j,81)%j-A(j,85)%j-A(j,87)%j)*f(17)+18*(-A(j,83)%j-A(j,89)%j)*f(18)+(19*(A(j,82)%j &
        +A(j,84)%j+A(j,88)%j+A(j,90)%j)*f(18))/2._/**/REALKIND
  M2( 4)%j = (A(j,59)%j-A(j,60)%j-A(j,64)%j+A(j,66)%j+A(j,70)%j-A(j,71)%j+A(j,76)%j-A(j,77)%j-A(j,110)%j-A(j,112)%j-A(j,114)%j &
        -A(j,116)%j-A(j,118)%j-A(j,120)%j-A(j,122)%j-A(j,124)%j-A(j,128)%j-A(j,130)%j+A(j,226)%j+A(j,241)%j+A(j,312)%j)*f(1) &
        +CI*(A(j,230)%j+A(j,233)%j+A(j,239)%j-A(j,273)%j-A(j,276)%j-A(j,298)%j-A(j,310)%j+A(j,324)%j)*f(2)+(A(j,56)%j-A(j,57)%j &
        -A(j,61)%j+A(j,63)%j+A(j,67)%j-A(j,68)%j+A(j,73)%j-A(j,74)%j-A(j,109)%j-A(j,111)%j-A(j,113)%j-A(j,115)%j-A(j,117)%j &
        -A(j,119)%j-A(j,121)%j-A(j,123)%j-A(j,127)%j-A(j,129)%j+A(j,225)%j+A(j,240)%j+A(j,311)%j)*f(5)+CI*(A(j,229)%j+A(j,232)%j &
        +A(j,238)%j-A(j,272)%j-A(j,275)%j-A(j,297)%j-A(j,309)%j+A(j,323)%j)*f(6)+(-A(j,152)%j+A(j,153)%j-A(j,155)%j+A(j,156)%j &
        -A(j,188)%j+A(j,189)%j-A(j,191)%j+A(j,192)%j-A(j,433)%j-A(j,436)%j-A(j,437)%j+A(j,454)%j+A(j,457)%j+A(j,459)%j+A(j,460)%j &
        +A(j,462)%j+A(j,465)%j-A(j,470)%j-A(j,471)%j-A(j,474)%j+A(j,499)%j+A(j,501)%j+A(j,504)%j+A(j,505)%j+A(j,506)%j+A(j,510)%j &
        -A(j,511)%j-A(j,512)%j-A(j,513)%j-A(j,514)%j-A(j,515)%j-A(j,516)%j)*f(9)+CI*(A(j,430)%j+A(j,431)%j+A(j,432)%j-A(j,461)%j &
        -A(j,463)%j-A(j,464)%j-A(j,466)%j-A(j,467)%j-A(j,468)%j+A(j,500)%j+A(j,502)%j+A(j,503)%j-A(j,523)%j-A(j,524)%j-A(j,525)%j &
        +A(j,556)%j+A(j,557)%j+A(j,558)%j)*f(10)+(A(j,92)%j-A(j,93)%j+A(j,98)%j-A(j,99)%j+A(j,140)%j+A(j,158)%j+A(j,171)%j &
        +A(j,172)%j+A(j,205)%j+A(j,206)%j-A(j,329)%j-A(j,331)%j+A(j,335)%j+A(j,343)%j+A(j,344)%j-A(j,376)%j-A(j,378)%j+A(j,387)%j &
        +A(j,401)%j+A(j,402)%j)*f(11)+CI*(-A(j,139)%j+A(j,163)%j+A(j,169)%j-A(j,184)%j+A(j,330)%j-A(j,334)%j+A(j,340)%j-A(j,352)%j &
        -A(j,377)%j+A(j,385)%j-A(j,393)%j+A(j,405)%j)*f(12)+(A(j,95)%j-A(j,96)%j+A(j,101)%j-A(j,102)%j+A(j,223)%j+A(j,224)%j &
        +A(j,360)%j-A(j,370)%j-A(j,372)%j+A(j,410)%j-A(j,417)%j-A(j,419)%j)*f(13)+CI*(A(j,231)%j-A(j,274)%j+A(j,358)%j-A(j,369)%j &
        -A(j,409)%j+A(j,420)%j)*f(14)+(-A(j,147)%j-A(j,149)%j-A(j,162)%j-A(j,164)%j-A(j,183)%j-A(j,185)%j-A(j,198)%j &
        -A(j,200)%j)*f(15)+CI*(A(j,150)%j-A(j,159)%j+A(j,174)%j-A(j,201)%j+A(j,209)%j-A(j,220)%j)*f(16)+2*(A(j,79)%j &
        +A(j,85)%j)*f(17)+(-A(j,80)%j-A(j,81)%j-A(j,86)%j-A(j,87)%j)*f(17)+18*(-A(j,82)%j-A(j,88)%j)*f(18)+(19*(A(j,83)%j &
        +A(j,84)%j+A(j,89)%j+A(j,90)%j)*f(18))/2._/**/REALKIND
  M2( 5)%j = (-A(j,58)%j+A(j,60)%j+A(j,65)%j-A(j,66)%j+A(j,71)%j-A(j,72)%j-A(j,76)%j+A(j,78)%j+A(j,104)%j-A(j,106)%j+A(j,108)%j &
        +A(j,110)%j+A(j,112)%j+A(j,120)%j+A(j,122)%j+A(j,126)%j+A(j,130)%j+A(j,132)%j+A(j,269)%j+A(j,296)%j+A(j,302)%j)*f(1)+CI*( &
        -A(j,264)%j-A(j,267)%j+A(j,283)%j+A(j,286)%j+A(j,294)%j-A(j,300)%j-A(j,304)%j+A(j,318)%j)*f(2)+(-A(j,55)%j+A(j,57)%j &
        +A(j,62)%j-A(j,63)%j+A(j,68)%j-A(j,69)%j-A(j,73)%j+A(j,75)%j+A(j,103)%j-A(j,105)%j+A(j,107)%j+A(j,109)%j+A(j,111)%j &
        +A(j,119)%j+A(j,121)%j+A(j,125)%j+A(j,129)%j+A(j,131)%j+A(j,268)%j+A(j,295)%j+A(j,301)%j)*f(5)+CI*(-A(j,263)%j-A(j,266)%j &
        +A(j,282)%j+A(j,285)%j+A(j,293)%j-A(j,299)%j-A(j,303)%j+A(j,317)%j)*f(6)+(A(j,151)%j-A(j,153)%j+A(j,154)%j-A(j,156)%j &
        +A(j,187)%j-A(j,189)%j+A(j,190)%j-A(j,192)%j+A(j,442)%j+A(j,445)%j+A(j,447)%j-A(j,449)%j-A(j,450)%j-A(j,453)%j-A(j,454)%j &
        -A(j,457)%j-A(j,459)%j-A(j,478)%j-A(j,481)%j-A(j,482)%j+A(j,487)%j+A(j,489)%j+A(j,492)%j-A(j,499)%j-A(j,501)%j-A(j,504)%j &
        -A(j,541)%j-A(j,542)%j-A(j,543)%j-A(j,544)%j-A(j,545)%j-A(j,546)%j)*f(9)+CI*(-A(j,439)%j-A(j,440)%j-A(j,441)%j+A(j,455)%j &
        +A(j,456)%j+A(j,458)%j+A(j,475)%j+A(j,476)%j+A(j,477)%j-A(j,488)%j-A(j,490)%j-A(j,491)%j+A(j,547)%j+A(j,548)%j+A(j,549)%j &
        -A(j,562)%j-A(j,563)%j-A(j,564)%j)*f(10)+(-A(j,91)%j+A(j,93)%j-A(j,97)%j+A(j,99)%j+A(j,146)%j+A(j,160)%j+A(j,176)%j &
        +A(j,194)%j+A(j,215)%j+A(j,216)%j-A(j,326)%j+A(j,329)%j+A(j,333)%j+A(j,346)%j+A(j,347)%j-A(j,373)%j+A(j,376)%j+A(j,383)%j &
        +A(j,398)%j+A(j,399)%j)*f(11)+CI*(A(j,142)%j-A(j,148)%j-A(j,175)%j+A(j,180)%j+A(j,327)%j-A(j,328)%j-A(j,345)%j+A(j,349)%j &
        +A(j,374)%j-A(j,382)%j+A(j,396)%j-A(j,400)%j)*f(12)+(-A(j,94)%j+A(j,96)%j-A(j,100)%j+A(j,102)%j+A(j,261)%j+A(j,262)%j &
        +A(j,362)%j-A(j,366)%j+A(j,370)%j-A(j,413)%j+A(j,416)%j+A(j,417)%j)*f(13)+CI*(-A(j,265)%j+A(j,284)%j-A(j,361)%j+A(j,365)%j &
        +A(j,412)%j-A(j,418)%j)*f(14)+(-A(j,143)%j+A(j,147)%j+A(j,164)%j-A(j,167)%j-A(j,179)%j+A(j,183)%j+A(j,200)%j &
        -A(j,203)%j)*f(15)+CI*(-A(j,165)%j+A(j,166)%j-A(j,195)%j+A(j,204)%j-A(j,217)%j+A(j,222)%j)*f(16)+2*(A(j,80)%j &
        +A(j,86)%j)*f(17)+(-A(j,79)%j-A(j,81)%j-A(j,85)%j-A(j,87)%j)*f(17)+18*(-A(j,83)%j-A(j,89)%j)*f(18)+(19*(A(j,82)%j &
        +A(j,84)%j+A(j,88)%j+A(j,90)%j)*f(18))/2._/**/REALKIND
  M2( 6)%j = (A(j,58)%j-A(j,59)%j+A(j,64)%j-A(j,65)%j-A(j,70)%j+A(j,72)%j+A(j,77)%j-A(j,78)%j-A(j,104)%j+A(j,106)%j-A(j,108)%j &
        +A(j,114)%j+A(j,116)%j+A(j,118)%j+A(j,124)%j-A(j,126)%j+A(j,128)%j-A(j,132)%j+A(j,235)%j+A(j,237)%j+A(j,320)%j)*f(1)+CI*( &
        -A(j,230)%j-A(j,233)%j-A(j,239)%j-A(j,283)%j-A(j,286)%j-A(j,294)%j-A(j,318)%j-A(j,324)%j)*f(2)+(A(j,55)%j-A(j,56)%j &
        +A(j,61)%j-A(j,62)%j-A(j,67)%j+A(j,69)%j+A(j,74)%j-A(j,75)%j-A(j,103)%j+A(j,105)%j-A(j,107)%j+A(j,113)%j+A(j,115)%j &
        +A(j,117)%j+A(j,123)%j-A(j,125)%j+A(j,127)%j-A(j,131)%j+A(j,234)%j+A(j,236)%j+A(j,319)%j)*f(5)+CI*(-A(j,229)%j-A(j,232)%j &
        -A(j,238)%j-A(j,282)%j-A(j,285)%j-A(j,293)%j-A(j,317)%j-A(j,323)%j)*f(6)+(-A(j,151)%j+A(j,152)%j-A(j,154)%j+A(j,155)%j &
        -A(j,187)%j+A(j,188)%j-A(j,190)%j+A(j,191)%j-A(j,442)%j-A(j,445)%j-A(j,447)%j-A(j,448)%j-A(j,451)%j-A(j,452)%j-A(j,460)%j &
        -A(j,462)%j-A(j,465)%j-A(j,469)%j-A(j,472)%j-A(j,473)%j-A(j,487)%j-A(j,489)%j-A(j,492)%j-A(j,505)%j-A(j,506)%j-A(j,510)%j &
        -A(j,517)%j-A(j,518)%j-A(j,519)%j-A(j,520)%j-A(j,521)%j-A(j,522)%j)*f(9)+CI*(A(j,439)%j+A(j,440)%j+A(j,441)%j+A(j,461)%j &
        +A(j,463)%j+A(j,464)%j+A(j,466)%j+A(j,467)%j+A(j,468)%j+A(j,488)%j+A(j,490)%j+A(j,491)%j+A(j,523)%j+A(j,524)%j+A(j,525)%j &
        +A(j,562)%j+A(j,563)%j+A(j,564)%j)*f(10)+(A(j,91)%j-A(j,92)%j+A(j,97)%j-A(j,98)%j+A(j,145)%j+A(j,161)%j+A(j,170)%j &
        +A(j,173)%j+A(j,207)%j+A(j,208)%j+A(j,326)%j+A(j,331)%j+A(j,332)%j+A(j,341)%j+A(j,342)%j+A(j,373)%j+A(j,378)%j+A(j,386)%j &
        +A(j,403)%j+A(j,404)%j)*f(11)+CI*(-A(j,142)%j-A(j,163)%j-A(j,169)%j-A(j,180)%j-A(j,327)%j-A(j,330)%j-A(j,340)%j-A(j,349)%j &
        -A(j,374)%j-A(j,385)%j-A(j,396)%j-A(j,405)%j)*f(12)+(A(j,94)%j-A(j,95)%j+A(j,100)%j-A(j,101)%j+A(j,227)%j+A(j,228)%j &
        +A(j,359)%j+A(j,366)%j+A(j,372)%j+A(j,413)%j+A(j,415)%j+A(j,419)%j)*f(13)+CI*(-A(j,231)%j-A(j,284)%j-A(j,358)%j-A(j,365)%j &
        -A(j,412)%j-A(j,420)%j)*f(14)+(A(j,143)%j+A(j,149)%j+A(j,162)%j+A(j,167)%j+A(j,179)%j+A(j,185)%j+A(j,198)%j &
        +A(j,203)%j)*f(15)+CI*(-A(j,150)%j-A(j,166)%j-A(j,174)%j-A(j,204)%j-A(j,209)%j-A(j,222)%j)*f(16)+(-A(j,79)%j-A(j,80)%j &
        -A(j,85)%j-A(j,86)%j)*f(17)+2*(A(j,81)%j+A(j,87)%j)*f(17)+(19*(A(j,82)%j+A(j,83)%j+A(j,88)%j &
        +A(j,89)%j)*f(18))/2._/**/REALKIND+18*(-A(j,84)%j-A(j,90)%j)*f(18)
  M2( 7)%j = (2*(-A(j,82)%j-A(j,83)%j-A(j,84)%j-A(j,88)%j-A(j,89)%j-A(j,90)%j)*f(18))/3._/**/REALKIND
  M2( 8)%j = (2*(-A(j,82)%j-A(j,83)%j-A(j,84)%j-A(j,88)%j-A(j,89)%j-A(j,90)%j)*f(18))/3._/**/REALKIND
  M2( 9)%j = (2*(-A(j,82)%j-A(j,83)%j-A(j,84)%j-A(j,88)%j-A(j,89)%j-A(j,90)%j)*f(18))/3._/**/REALKIND
  M2(10)%j = ((-A(j,82)%j-A(j,83)%j-A(j,84)%j-A(j,88)%j-A(j,89)%j-A(j,90)%j)*f(18))/3._/**/REALKIND
  M2(11)%j = ((-A(j,82)%j-A(j,83)%j-A(j,84)%j-A(j,88)%j-A(j,89)%j-A(j,90)%j)*f(18))/3._/**/REALKIND


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphttj_ttxhggg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(6)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 6
      do j = 1, 6
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphttj_ttxhggg_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(6), Mct(11)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 6
    do j = 1, 11
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+6*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_pphttj_ttxhggg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(6)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 23-1
    colmatpos = 6*k
    do i = 1, 6
      do j = 1, 6
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphttj_ttxhggg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(6)
  complex(REALKIND), intent(in)  :: M2(6)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 6
    do j = 1, 6
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_pphttj_ttxhggg_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(6)
  type(Hpolcont), intent(out)  :: M0_col(11)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 11 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 6 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+6*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_pphttj_ttxhggg_1_/**/REALKIND
