
module ol_vamp_1_pphttj_ttxhggg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphttj_ttxhggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphttj_ttxhggg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pphttj_ttxhggg_1_/**/DREALKIND
  use ol_tensor_sum_storage_pphttj_ttxhggg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pphttj_ttxhggg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pphttj_ttxhggg_1_/**/DREALKIND, only: ntryL, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(32)
  type(Hpolcont), intent(in) :: M(11,32)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

Gcoeff(:)%j = (-(c(16)*M(2,:)%j)+c(17)*M(11,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[32,8,2,1,4,16],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(1),n2h16(1))
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)+c(17)*M(10,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[32,4,1,2,8,16],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(2),n2h16(2))
Gcoeff(:)%j = (-(c(16)*M(4,:)%j)+c(17)*M(10,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[32,8,4,1,2,16],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(3),n2h16(3))
Gcoeff(:)%j = (-(c(16)*M(3,:)%j)+c(17)*M(11,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[32,4,1,2,16,8],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(4),n2h16(4))
Gcoeff(:)%j = (-(c(16)*M(6,:)%j)+c(17)*M(11,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[32,2,1,4,8,16],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(5),n2h16(5))
Gcoeff(:)%j = (-(c(16)*M(5,:)%j)+c(17)*M(10,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[32,2,1,4,16,8],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(6),n2h16(6))
Gcoeff(:)%j = (-(c(16)*M(4,:)%j)+c(17)*M(10,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[32,8,1,2,4,16],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(7),n2h16(7))
Gcoeff(:)%j = (-(c(16)*M(6,:)%j)+c(17)*M(11,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[32,4,2,1,8,16],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(8),n2h16(8))
Gcoeff(:)%j = (-(c(16)*M(4,:)%j)+c(17)*M(10,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[32,4,8,1,2,16],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(9),n2h16(9))
Gcoeff(:)%j = (-(c(16)*M(4,:)%j)+c(17)*M(10,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[32,4,16,2,1,8],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(10),n2h16(10))
Gcoeff(:)%j = (-(c(16)*M(6,:)%j)+c(17)*M(11,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[32,2,1,8,4,16],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(11),n2h16(11))
Gcoeff(:)%j = (-(c(16)*M(6,:)%j)+c(17)*M(11,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[32,2,1,8,16,4],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(12),n2h16(12))
Gcoeff(:)%j = (-(c(16)*M(2,:)%j)+c(17)*M(11,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[32,8,4,2,1,16],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(13),n2h16(13))
Gcoeff(:)%j = (-(c(16)*M(5,:)%j)+c(17)*M(10,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[32,4,2,1,16,8],[nMT,nMT,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(14),n2h16(14))
Gcoeff(:)%j = (-(c(16)*M(2,:)%j)+c(17)*M(11,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[32,4,8,2,1,16],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(15),n2h16(15))
Gcoeff(:)%j = (-(c(16)*M(2,:)%j)+c(17)*M(11,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[32,4,16,1,2,8],[nMT,nMT,nMT,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(16),n2h16(16))
Gcoeff(:)%j = (-(c(16)*M(5,:)%j)+c(17)*M(10,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[32,2,1,16,4,8],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(17),n2h16(17))
Gcoeff(:)%j = (-(c(16)*M(5,:)%j)+c(17)*M(10,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[32,2,1,16,8,4],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(18),n2h16(18))
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)+c(17)*M(10,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[32,1,2,4,8,16],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(19),n2h16(19))
Gcoeff(:)%j = (-(c(16)*M(3,:)%j)+c(17)*M(11,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[32,1,2,4,16,8],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(20),n2h16(20))
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)+c(17)*M(10,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[32,1,2,8,4,16],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(21),n2h16(21))
Gcoeff(:)%j = (-(c(16)*M(1,:)%j)+c(17)*M(10,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[32,1,2,8,16,4],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(22),n2h16(22))
Gcoeff(:)%j = (-(c(16)*M(3,:)%j)+c(17)*M(11,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[32,1,2,16,4,8],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(23),n2h16(23))
Gcoeff(:)%j = (-(c(16)*M(3,:)%j)+c(17)*M(11,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[32,1,2,16,8,4],[nMT,0,nMT,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(24),n2h16(24))
Gcoeff(:)%j = (-(c(10)*M(4,:)%j)+c(8)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(11,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[32,8,1,4,2,16],[0,0,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(25),m3h2x16(:,25),heltab2x32(:,:,25))
Gcoeff(:)%j = (c(10)*M(6,:)%j+c(8)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[32,2,4,1,8,16],[0,nMT,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(26),m3h2x16(:,26),heltab2x32(:,:,26))
Gcoeff(:)%j = (c(8)*(M(9,:)%j-M(10,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[32,4,1,8,2,16],[nMT,nMT,0,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(27),n2h16(25))
Gcoeff(:)%j = (c(8)*(-M(9,:)%j+M(11,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[32,2,8,1,4,16],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(28),n2h16(26))
Gcoeff(:)%j = (c(17)*(-M(7,:)%j-M(9,:)%j+M(11,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[32,2,16,4,1,8],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(29),m3h2x16(:,29),heltab2x32(:,:,29))
Gcoeff(:)%j = (c(17)*(-M(8,:)%j-M(9,:)%j+M(10,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[32,2,16,8,1,4],[nMT,0,0,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,30),heltab2x32(:,:,30))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(30),n2h16(27))
Gcoeff(:)%j = (c(10)*M(2,:)%j+c(8)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(10,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[32,8,2,4,1,16],[0,0,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(31),m3h2x16(:,31),heltab2x32(:,:,31))
Gcoeff(:)%j = (c(10)*M(5,:)%j+c(8)*(M(7,:)%j+M(8,:)%j+M(9,:)%j-M(11,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[32,2,4,1,16,8],[0,nMT,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(32),m3h2x16(:,32),heltab2x32(:,:,32))
Gcoeff(:)%j = (c(8)*(M(8,:)%j-M(11,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(33),h0tab(:,33),[32,4,1,16,2,8],[nMT,nMT,0,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,33),heltab2x32(:,:,33))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(33),n2h16(28))
Gcoeff(:)%j = (c(17)*(-M(7,:)%j-M(8,:)%j+M(10,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(34),h0tab(:,34),[32,2,8,4,1,16],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(34),m3h2x16(:,34),heltab2x32(:,:,34))
Gcoeff(:)%j = (c(17)*(-M(8,:)%j-M(9,:)%j+M(11,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(35),h0tab(:,35),[32,2,8,16,1,4],[nMT,0,0,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(35),n2h16(29))
Gcoeff(:)%j = (c(8)*(-M(8,:)%j+M(10,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(36),h0tab(:,36),[32,2,16,1,4,8],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(36),n2h16(30))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(8)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(11,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(37),h0tab(:,37),[32,1,4,2,8,16],[0,nMT,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(37),m3h2x16(:,37),heltab2x32(:,:,37))
Gcoeff(:)%j = (-(c(10)*M(3,:)%j)+c(8)*(-M(7,:)%j-M(8,:)%j-M(9,:)%j+M(10,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(38),h0tab(:,38),[32,1,4,2,16,8],[0,nMT,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(38),m3h2x16(:,38),heltab2x32(:,:,38))
Gcoeff(:)%j = (c(17)*(-M(7,:)%j-M(8,:)%j+M(11,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(39),h0tab(:,39),[32,1,4,8,2,16],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(39),m3h2x16(:,39),heltab2x32(:,:,39))
Gcoeff(:)%j = (c(17)*(-M(7,:)%j-M(9,:)%j+M(10,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(40),h0tab(:,40),[32,1,4,16,2,8],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(40),m3h2x16(:,40),heltab2x32(:,:,40))
Gcoeff(:)%j = (c(8)*(-M(7,:)%j+M(10,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(41),h0tab(:,41),[32,1,4,16,8,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(41),m3h2x16(:,41),heltab2x32(:,:,41))
Gcoeff(:)%j = (c(8)*(-M(7,:)%j+M(11,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(42),h0tab(:,42),[32,1,4,8,16,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(42),m3h2x16(:,42),heltab2x32(:,:,42))
Gcoeff(:)%j = (c(8)*(-M(9,:)%j+M(11,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(43),h0tab(:,43),[32,4,2,8,1,16],[nMT,nMT,0,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,43),heltab2x32(:,:,43))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(43),n2h16(31))
Gcoeff(:)%j = (c(8)*(-M(8,:)%j+M(10,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(44),h0tab(:,44),[32,4,2,16,1,8],[nMT,nMT,0,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,44),heltab2x32(:,:,44))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(44),n2h16(32))
Gcoeff(:)%j = (c(17)*(-M(7,:)%j-M(8,:)%j+M(10,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(45),h0tab(:,45),[32,2,4,8,1,16],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(45),m3h2x16(:,45),heltab2x32(:,:,45))
Gcoeff(:)%j = (c(17)*(-M(7,:)%j-M(9,:)%j+M(11,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(46),h0tab(:,46),[32,2,4,16,1,8],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(46),m3h2x16(:,46),heltab2x32(:,:,46))
Gcoeff(:)%j = (c(8)*(-M(9,:)%j+M(11,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(47),h0tab(:,47),[32,2,8,1,16,4],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,47),heltab2x32(:,:,47))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(47),n2h16(33))
Gcoeff(:)%j = (c(8)*(-M(8,:)%j+M(10,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(48),h0tab(:,48),[32,2,16,1,8,4],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,48),heltab2x32(:,:,48))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(48),n2h16(34))
Gcoeff(:)%j = (c(8)*(M(9,:)%j-M(10,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(49),h0tab(:,49),[32,1,8,2,4,16],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,49),heltab2x32(:,:,49))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(49),n2h16(35))
Gcoeff(:)%j = (c(17)*(-M(7,:)%j-M(8,:)%j+M(11,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(50),h0tab(:,50),[32,1,8,4,2,16],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(50),m3h2x16(:,50),heltab2x32(:,:,50))
Gcoeff(:)%j = (c(17)*(-M(8,:)%j-M(9,:)%j+M(10,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(51),h0tab(:,51),[32,1,8,16,2,4],[nMT,0,0,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,51),heltab2x32(:,:,51))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(51),n2h16(36))
Gcoeff(:)%j = (c(8)*(-M(7,:)%j+M(11,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(52),h0tab(:,52),[32,1,8,16,4,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(52),m3h2x16(:,52),heltab2x32(:,:,52))
Gcoeff(:)%j = (c(8)*(M(9,:)%j-M(10,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(53),h0tab(:,53),[32,1,8,2,16,4],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,53),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(53),n2h16(37))
Gcoeff(:)%j = (c(8)*(-M(7,:)%j+M(11,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(54),h0tab(:,54),[32,1,8,4,16,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(54),m3h2x16(:,54),heltab2x32(:,:,54))
Gcoeff(:)%j = (c(17)*(-M(7,:)%j-M(9,:)%j+M(10,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(55),h0tab(:,55),[32,1,16,4,2,8],[0,nMT,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(55),m3h2x16(:,55),heltab2x32(:,:,55))
Gcoeff(:)%j = (c(17)*(-M(8,:)%j-M(9,:)%j+M(11,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(56),h0tab(:,56),[32,1,16,8,2,4],[nMT,0,0,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,56),heltab2x32(:,:,56))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(56),n2h16(38))
Gcoeff(:)%j = (c(8)*(M(8,:)%j-M(11,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(57),h0tab(:,57),[32,1,16,2,4,8],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,57),heltab2x32(:,:,57))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(57),n2h16(39))
Gcoeff(:)%j = (c(8)*(-M(7,:)%j+M(10,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(58),h0tab(:,58),[32,1,16,8,4,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(58),m3h2x16(:,58),heltab2x32(:,:,58))
Gcoeff(:)%j = (c(8)*(M(8,:)%j-M(11,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(59),h0tab(:,59),[32,1,16,2,8,4],[nMT,0,0,nMT,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,59),heltab2x32(:,:,59))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(59),n2h16(40))
Gcoeff(:)%j = (c(8)*(-M(7,:)%j+M(10,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(60),h0tab(:,60),[32,1,16,4,8,2],[0,nMT,nMT,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(60),m3h2x16(:,60),heltab2x32(:,:,60))
  call Hloop_QV_A(ntryL,G1H16(1),ex4(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_Q_A(ntryL,G1H8(1),40,nMT,G2H8(1),n2h8(1))
  call Hloop_AS_Q(ntryL,G1H16(2),ex3(:),G1H16(1),ngH,m3h1x16(:,1),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G1H16(1),36,nMT,G2H16(1),n2h16(41))
  call Hloop_AV_Q(ntryL,G1H16(3),ex4(:),G1H8(1),m3h2x8(:,2),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(1),40,nMT,G2H8(2),n2h8(2))
  call Hloop_AS_Q(ntryL,G1H16(4),ex3(:),G1H16(2),ngH,m3h1x16(:,2),heltab2x16(:,:,4))
  call Hloop_A_Q(ntryL,G1H16(2),36,nMT,G2H16(2),n2h16(42))
  call Hloop_QA_V(ntryL,G1H16(5),ex2(:),G1H8(1),m3h2x8(:,3),heltab2x16(:,:,5))
  call Hloop_QA_V(ntryL,G1H16(6),ex2(:),G1H8(2),m3h2x8(:,4),heltab2x16(:,:,6))
  call Hloop_AV_Q(ntryL,G1H16(7),ex4(:),G1H8(3),m3h2x8(:,5),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G1H8(3),40,nMT,G2H8(3),n2h8(3))
  call Hloop_QS_A(ntryL,G1H16(8),ex3(:),G1H16(1),ngH,m3h1x16(:,3),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G1H16(1),36,nMT,G2H16(3),n2h16(43))
  call Hloop_AS_Q(ntryL,G1H16(9),ex3(:),G1H16(3),ngH,m3h1x16(:,4),heltab2x16(:,:,9))
  call Hloop_A_Q(ntryL,G1H16(3),36,nMT,G2H16(4),n2h16(44))
  call Hloop_QS_A(ntryL,G1H16(10),ex3(:),G1H16(4),ngH,m3h1x16(:,5),heltab2x16(:,:,10))
  call Hloop_Q_A(ntryL,G1H16(4),36,nMT,G2H16(5),n2h16(45))
  call Hloop_QA_V(ntryL,G1H16(11),ex2(:),G1H8(3),m3h2x8(:,6),heltab2x16(:,:,11))
  call Hloop_QA_V(ntryL,G1H16(12),ex2(:),G1H8(4),m3h2x8(:,7),heltab2x16(:,:,12))
  call Hloop_QV_A(ntryL,G1H16(13),ex4(:),G1H8(5),m3h2x8(:,8),heltab2x16(:,:,13))
  call Hloop_Q_A(ntryL,G1H8(5),40,nMT,G2H8(4),n2h8(4))
  call Hloop_QS_A(ntryL,G1H16(14),ex3(:),G1H16(2),ngH,m3h1x16(:,6),heltab2x16(:,:,14))
  call Hloop_Q_A(ntryL,G1H16(2),36,nMT,G2H16(6),n2h16(46))
  call Hloop_QS_A(ntryL,G1H16(15),ex3(:),G1H16(5),ngH,m3h1x16(:,7),heltab2x16(:,:,15))
  call Hloop_Q_A(ntryL,G1H16(5),36,nMT,G2H16(7),n2h16(47))
  call Hloop_AS_Q(ntryL,G1H16(16),ex3(:),G1H16(6),ngH,m3h1x16(:,8),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G1H16(6),36,nMT,G2H16(8),n2h16(48))
  call Hloop_QA_V(ntryL,G1H16(17),ex2(:),G1H8(5),m3h2x8(:,9),heltab2x16(:,:,17))
  call Hloop_QA_V(ntryL,G1H16(18),ex2(:),G1H8(6),m3h2x8(:,10),heltab2x16(:,:,18))
  call Hloop_AQ_V(ntryL,G1H16(19),ex1(:),G1H8(7),m3h2x8(:,11),heltab2x16(:,:,19))
  call Hloop_AQ_V(ntryL,G1H16(20),ex1(:),G1H8(8),m3h2x8(:,12),heltab2x16(:,:,20))
  call Hloop_AQ_V(ntryL,G1H16(21),ex1(:),G1H8(9),m3h2x8(:,13),heltab2x16(:,:,21))
  call Hloop_AQ_V(ntryL,G1H16(22),ex1(:),G1H8(10),m3h2x8(:,14),heltab2x16(:,:,22))
  call Hloop_AQ_V(ntryL,G1H16(23),ex1(:),G1H8(11),m3h2x8(:,15),heltab2x16(:,:,23))
  call Hloop_AQ_V(ntryL,G1H16(24),ex1(:),G1H8(12),m3h2x8(:,16),heltab2x16(:,:,24))
  call Hloop_UV_W(ntryL,G1H16(25),32,ex4(:),8,G2H8(5),m3h2x8(:,17),heltab2x16(:,:,25))
  call Hloop_VA_Q(ntryL,G1H16(26),ex2(:),G1H8(13),m3h2x8(:,18),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G1H8(13),34,nMT,G2H8(6),n2h8(5))
  call Hloop_AS_Q(ntryL,G1H16(27),ex3(:),G1H16(7),ngH,m3h1x16(:,9),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G1H16(7),36,nMT,G2H16(9),n2h16(49))
  call Hloop_QA_V(ntryL,G1H16(28),ex2(:),G1H8(13),m3h2x8(:,19),heltab2x16(:,:,28))
  call Hloop_VA_Q(ntryL,G1H16(29),ex2(:),G1H8(14),m3h2x8(:,20),heltab2x16(:,:,29))
  call Hloop_A_Q(ntryL,G1H8(14),34,nMT,G2H8(7),n2h8(6))
  call Hloop_QA_V(ntryL,G1H16(30),ex2(:),G1H8(14),m3h2x8(:,21),heltab2x16(:,:,30))
  call Hloop_UV_W(ntryL,G1H16(31),32,ex4(:),8,G2H8(8),m3h2x8(:,22),heltab2x16(:,:,31))
  call Hloop_VA_Q(ntryL,G1H16(32),ex2(:),G1H8(15),m3h2x8(:,23),heltab2x16(:,:,32))
  call Hloop_A_Q(ntryL,G1H8(15),34,nMT,G2H8(9),n2h8(7))
  call Hloop_AS_Q(ntryL,G1H16(33),ex3(:),G1H16(8),ngH,m3h1x16(:,10),heltab2x16(:,:,33))
  call Hloop_A_Q(ntryL,G1H16(8),36,nMT,G2H16(10),n2h16(50))
  call Hloop_VA_Q(ntryL,G1H16(34),ex2(:),G1H8(15),m3h2x8(:,24),heltab2x16(:,:,34))
  call Hloop_A_Q(ntryL,G1H8(15),34,nMT,G2H8(10),n2h8(8))
  call Hloop_QA_V(ntryL,G1H16(35),ex2(:),G1H8(15),m3h2x8(:,25),heltab2x16(:,:,35))
  call Hloop_QA_V(ntryL,G1H16(36),ex2(:),G1H8(16),m3h2x8(:,26),heltab2x16(:,:,36))
  call Hloop_VQ_A(ntryL,G1H16(37),ex1(:),G1H8(17),m3h2x8(:,27),heltab2x16(:,:,37))
  call Hloop_Q_A(ntryL,G1H8(17),33,nMT,G2H8(11),n2h8(9))
  call Hloop_VQ_A(ntryL,G1H16(38),ex1(:),G1H8(17),m3h2x8(:,28),heltab2x16(:,:,38))
  call Hloop_Q_A(ntryL,G1H8(17),33,nMT,G2H8(12),n2h8(10))
  call Hloop_VQ_A(ntryL,G1H16(39),ex1(:),G1H8(17),m3h2x8(:,29),heltab2x16(:,:,39))
  call Hloop_Q_A(ntryL,G1H8(17),33,nMT,G2H8(13),n2h8(11))
  call Hloop_VQ_A(ntryL,G1H16(40),ex1(:),G1H8(17),m3h2x8(:,30),heltab2x16(:,:,40))
  call Hloop_Q_A(ntryL,G1H8(17),33,nMT,G2H8(14),n2h8(12))
  call Hloop_VQ_A(ntryL,G1H16(41),ex1(:),G1H8(17),m3h2x8(:,31),heltab2x16(:,:,41))
  call Hloop_Q_A(ntryL,G1H8(17),33,nMT,G2H8(15),n2h8(13))
  call Hloop_VQ_A(ntryL,G1H16(42),ex1(:),G1H8(17),m3h2x8(:,32),heltab2x16(:,:,42))
  call Hloop_Q_A(ntryL,G1H8(17),33,nMT,G2H8(16),n2h8(14))
  call Hloop_QS_A(ntryL,G1H16(43),ex3(:),G1H16(1),ngH,m3h1x16(:,11),heltab2x16(:,:,43))
  call Hloop_Q_A(ntryL,G1H16(1),36,nMT,G2H16(11),n2h16(51))
  call Hloop_QS_A(ntryL,G1H16(44),ex3(:),G1H16(9),ngH,m3h1x16(:,12),heltab2x16(:,:,44))
  call Hloop_Q_A(ntryL,G1H16(9),36,nMT,G2H16(12),n2h16(52))
  call Hloop_VA_Q(ntryL,G1H16(45),ex2(:),G1H8(17),m3h2x8(:,33),heltab2x16(:,:,45))
  call Hloop_A_Q(ntryL,G1H8(17),34,nMT,G2H8(17),n2h8(15))
  call Hloop_VA_Q(ntryL,G1H16(46),ex2(:),G1H8(17),m3h2x8(:,34),heltab2x16(:,:,46))
  call Hloop_A_Q(ntryL,G1H8(17),34,nMT,G2H8(18),n2h8(16))
  call Hloop_QA_V(ntryL,G1H16(47),ex2(:),G1H8(17),m3h2x8(:,35),heltab2x16(:,:,47))
  call Hloop_QA_V(ntryL,G1H16(48),ex2(:),G1H8(18),m3h2x8(:,36),heltab2x16(:,:,48))
  call Hloop_AQ_V(ntryL,G1H16(49),ex1(:),G1H8(19),m3h2x8(:,37),heltab2x16(:,:,49))
  call Hloop_VQ_A(ntryL,G1H16(50),ex1(:),G1H8(20),m3h2x8(:,38),heltab2x16(:,:,50))
  call Hloop_Q_A(ntryL,G1H8(20),33,nMT,G2H8(19),n2h8(17))
  call Hloop_AQ_V(ntryL,G1H16(51),ex1(:),G1H8(20),m3h2x8(:,39),heltab2x16(:,:,51))
  call Hloop_VQ_A(ntryL,G1H16(52),ex1(:),G1H8(21),m3h2x8(:,40),heltab2x16(:,:,52))
  call Hloop_Q_A(ntryL,G1H8(21),33,nMT,G2H8(20),n2h8(18))
  call Hloop_AQ_V(ntryL,G1H16(53),ex1(:),G1H8(21),m3h2x8(:,41),heltab2x16(:,:,53))
  call Hloop_VQ_A(ntryL,G1H16(54),ex1(:),G1H8(22),m3h2x8(:,42),heltab2x16(:,:,54))
  call Hloop_Q_A(ntryL,G1H8(22),33,nMT,G2H8(21),n2h8(19))
  call Hloop_VQ_A(ntryL,G1H16(55),ex1(:),G1H8(22),m3h2x8(:,43),heltab2x16(:,:,55))
  call Hloop_Q_A(ntryL,G1H8(22),33,nMT,G2H8(22),n2h8(20))
  call Hloop_AQ_V(ntryL,G1H16(56),ex1(:),G1H8(22),m3h2x8(:,44),heltab2x16(:,:,56))
  call Hloop_AQ_V(ntryL,G1H16(57),ex1(:),G1H8(23),m3h2x8(:,45),heltab2x16(:,:,57))
  call Hloop_VQ_A(ntryL,G1H16(58),ex1(:),G1H8(24),m3h2x8(:,46),heltab2x16(:,:,58))
  call Hloop_Q_A(ntryL,G1H8(24),33,nMT,G2H8(23),n2h8(21))
  call Hloop_AQ_V(ntryL,G1H16(59),ex1(:),G1H8(24),m3h2x8(:,47),heltab2x16(:,:,59))
  call Hloop_VQ_A(ntryL,G1H16(60),ex1(:),G1H8(25),m3h2x8(:,48),heltab2x16(:,:,60))
  call Hloop_Q_A(ntryL,G1H8(25),33,nMT,G2H8(24),n2h8(22))
  call Hloop_QA_V(ntryL,G2H8(1),ex2(:),G2H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_V(ntryL,G2H16(1),ex1(:),G2H8(1),m3h2x8(:,49),heltab2x16(:,:,61))
call Hotf_5pt_reduction(G2H8(2),RedSet_5(1),mass5set(:,1),  & 
G1H8(25),G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
call HG1shiftOLR(G1H8(26),16,8)
  call Hloop_AQ_V(ntryL,G2H16(2),ex1(:),G2H8(2),m3h2x8(:,50),heltab2x16(:,:,62))
  call Hloop_VQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMT,G2H4(2),n2h4(1))
  call Hloop_VQ_A(ntryL,G1H8(2),ex1(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMT,G2H4(3),n2h4(2))
  call Hloop_AQ_V(ntryL,G2H8(3),ex1(:),G2H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_QA_V(ntryL,G2H16(3),ex2(:),G2H8(3),m3h2x8(:,51),heltab2x16(:,:,63))
call Hotf_5pt_reduction(G2H16(4),RedSet_5(2),mass5set(:,1),  & 
G1H16(3),G1H16(10),G1H16(4),G1H16(11),G1H16(12),G1H16(13),16)
call HG1shiftOLR(G1H16(10),16,16)
call Hotf_5pt_reduction(G2H16(5),RedSet_5(3),mass5set(:,1),  & 
G1H16(14),G1H16(2),G1H16(15),G1H16(5),G1H16(16),G1H16(6),16)
call HG1shiftOLR(G1H16(2),8,16)
  call Hloop_VQ_A(ntryL,G1H8(3),ex1(:),G1H4(1),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMT,G2H4(5),n2h4(3))
  call Hloop_VQ_A(ntryL,G1H8(4),ex1(:),G1H4(1),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMT,G2H4(6),n2h4(4))
call Hotf_5pt_reduction(G2H8(4),RedSet_5(4),mass5set(:,1),  & 
G1H8(1),G1H8(2),G1H8(3),G1H8(4),G1H8(31),G1H8(32),8)
call HG1shiftOLR(G1H8(2),16,8)
  call Hloop_QA_V(ntryL,G2H16(6),ex2(:),G2H8(4),m3h2x8(:,52),heltab2x16(:,:,64))
call Hotf_5pt_reduction(G2H16(7),RedSet_5(5),mass5set(:,1),  & 
G1H16(17),G1H16(18),G1H16(19),G1H16(20),G1H16(21),G1H16(22),16)
call HG1shiftOLR(G1H16(18),16,16)
call Hotf_5pt_reduction(G2H16(8),RedSet_5(6),mass5set(:,1),  & 
G1H16(23),G1H16(24),G1H16(25),G1H16(26),G1H16(27),G1H16(7),16)
call HG1shiftOLR(G1H16(24),8,16)
  call Hloop_VQ_A(ntryL,G1H8(5),ex1(:),G1H4(1),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMT,G2H4(7),n2h4(5))
  call Hloop_VQ_A(ntryL,G1H8(6),ex1(:),G1H4(1),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMT,G2H4(8),n2h4(6))
  call Hloop_VA_Q(ntryL,G1H8(7),ex2(:),G1H4(1),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMT,G2H4(9),n2h4(7))
  call Hloop_VA_Q(ntryL,G1H8(8),ex2(:),G1H4(1),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMT,G2H4(10),n2h4(8))
  call Hloop_VA_Q(ntryL,G1H8(9),ex2(:),G1H4(1),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMT,G2H4(11),n2h4(9))
  call Hloop_VA_Q(ntryL,G1H8(10),ex2(:),G1H4(1),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMT,G2H4(12),n2h4(10))
  call Hloop_VA_Q(ntryL,G1H8(11),ex2(:),G1H4(1),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMT,G2H4(13),n2h4(11))
  call Hloop_VA_Q(ntryL,G1H8(12),ex2(:),G1H4(1),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMT,G2H4(14),n2h4(12))
call Hotf_5pt_reduction(G2H8(5),RedSet_5(7),mass5set(:,2),  & 
G1H8(5),G1H8(6),G1H8(7),G1H8(8),G1H8(9),G1H8(10),8)
call HG1shiftOLR(G1H8(6),16,8)
call Hotf_5pt_reduction(G2H8(6),RedSet_5(8),mass5set(:,3),  & 
G1H8(11),G1H8(12),G1H8(33),G1H8(34),G1H8(35),G1H8(36),8)
call HG1shiftOLR(G1H8(12),16,8)
  call Hloop_AQ_V(ntryL,G2H16(9),ex1(:),G2H8(5),m3h2x8(:,53),heltab2x16(:,:,65))
  call Hloop_UV_W(ntryL,G1H8(13),34,ex4(:),8,G2H4(15),m3h2x4(:,15),heltab2x8(:,:,15))
call Hotf_5pt_reduction(G2H8(7),RedSet_5(9),mass5set(:,4),  & 
G1H8(13),G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),8)
call HG1shiftOLR(G1H8(37),8,8)
  call Hloop_UV_W(ntryL,G1H8(14),34,ex5(:),16,G2H4(16),m3h2x4(:,16),heltab2x8(:,:,16))
call Hotf_5pt_reduction(G2H8(8),RedSet_5(10),mass5set(:,2),  & 
G1H8(14),G1H8(42),G1H8(43),G1H8(44),G1H8(45),G1H8(46),8)
call HG1shiftOLR(G1H8(42),16,8)
call Hotf_5pt_reduction(G2H8(9),RedSet_5(8),mass5set(:,3),  & 
G1H8(47),G1H8(48),G1H8(49),G1H8(50),G1H8(51),G1H8(52),8)
call HG1shiftOLR(G1H8(48),8,8)
  call Hloop_AQ_V(ntryL,G2H16(10),ex1(:),G2H8(6),m3h2x8(:,54),heltab2x16(:,:,66))
call Hotf_5pt_reduction(G2H8(10),RedSet_5(11),mass5set(:,4),  & 
G1H8(53),G1H8(54),G1H8(55),G1H8(56),G1H8(57),G1H8(58),8)
call HG1shiftOLR(G1H8(54),16,8)
  call Hloop_UV_W(ntryL,G1H8(15),34,ex4(:),8,G2H4(17),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_UV_W(ntryL,G1H8(16),34,ex5(:),16,G2H4(18),m3h2x4(:,18),heltab2x8(:,:,18))
call Hotf_5pt_reduction(G2H8(11),RedSet_5(12),mass5set(:,3),  & 
G1H8(15),G1H8(16),G1H8(59),G1H8(60),G1H8(61),G1H8(62),8)
call HG1shiftOLR(G1H8(16),16,8)
call Hotf_5pt_reduction(G2H8(12),RedSet_5(12),mass5set(:,3),  & 
G1H8(63),G1H8(64),G1H8(65),G1H8(66),G1H8(67),G1H8(68),8)
call HG1shiftOLR(G1H8(64),8,8)
call Hotf_5pt_reduction(G2H8(13),RedSet_5(13),mass5set(:,4),  & 
G1H8(69),G1H8(70),G1H8(71),G1H8(72),G1H8(73),G1H8(74),8)
call HG1shiftOLR(G1H8(70),16,8)
call Hotf_5pt_reduction(G2H8(14),RedSet_5(14),mass5set(:,4),  & 
G1H8(75),G1H8(76),G1H8(77),G1H8(78),G1H8(79),G1H8(80),8)
call HG1shiftOLR(G1H8(76),8,8)
call Hotf_5pt_reduction(G2H8(15),RedSet_5(14),mass5set(:,4),  & 
G1H8(81),G1H8(82),G1H8(83),G1H8(84),G1H8(85),G1H8(86),8)
call HG1shiftOLR(G1H8(82),2,8)
call Hotf_5pt_reduction(G2H8(16),RedSet_5(13),mass5set(:,4),  & 
G1H8(87),G1H8(88),G1H8(89),G1H8(90),G1H8(91),G1H8(92),8)
call HG1shiftOLR(G1H8(88),2,8)
  call Hloop_QA_V(ntryL,G2H16(11),ex2(:),G2H8(7),m3h2x8(:,55),heltab2x16(:,:,67))
  call Hloop_QA_V(ntryL,G2H16(12),ex2(:),G2H8(8),m3h2x8(:,56),heltab2x16(:,:,68))
call Hotf_5pt_reduction(G2H8(17),RedSet_5(15),mass5set(:,4),  & 
G1H8(93),G1H8(94),G1H8(95),G1H8(96),G1H8(97),G1H8(98),8)
call HG1shiftOLR(G1H8(94),16,8)
call Hotf_5pt_reduction(G2H8(18),RedSet_5(16),mass5set(:,4),  & 
G1H8(99),G1H8(100),G1H8(101),G1H8(102),G1H8(103),G1H8(104),8)
call HG1shiftOLR(G1H8(100),8,8)
  call Hloop_UV_W(ntryL,G1H8(17),34,ex4(:),8,G2H4(19),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_UV_W(ntryL,G1H8(18),34,ex5(:),16,G2H4(20),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_UV_W(ntryL,G1H8(19),33,ex4(:),8,G2H4(21),m3h2x4(:,21),heltab2x8(:,:,21))
call Hotf_5pt_reduction(G2H8(19),RedSet_5(17),mass5set(:,4),  & 
G1H8(17),G1H8(18),G1H8(19),G1H8(105),G1H8(106),G1H8(107),8)
call HG1shiftOLR(G1H8(18),16,8)
  call Hloop_UV_W(ntryL,G1H8(20),33,ex4(:),8,G2H4(22),m3h2x4(:,22),heltab2x8(:,:,22))
call Hotf_5pt_reduction(G2H8(20),RedSet_5(18),mass5set(:,4),  & 
G1H8(20),G1H8(108),G1H8(109),G1H8(110),G1H8(111),G1H8(112),8)
call HG1shiftOLR(G1H8(108),2,8)
  call Hloop_UV_W(ntryL,G1H8(21),33,ex4(:),8,G2H4(23),m3h2x4(:,23),heltab2x8(:,:,23))
call Hotf_5pt_reduction(G2H8(21),RedSet_5(17),mass5set(:,4),  & 
G1H8(21),G1H8(113),G1H8(114),G1H8(115),G1H8(116),G1H8(117),8)
call HG1shiftOLR(G1H8(113),2,8)
call Hotf_5pt_reduction(G2H8(22),RedSet_5(19),mass5set(:,4),  & 
G1H8(118),G1H8(119),G1H8(120),G1H8(121),G1H8(122),G1H8(123),8)
call HG1shiftOLR(G1H8(119),8,8)
  call Hloop_UV_W(ntryL,G1H8(22),33,ex5(:),16,G2H4(24),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_UV_W(ntryL,G1H8(23),33,ex5(:),16,G2H4(25),m3h2x4(:,25),heltab2x8(:,:,25))
call Hotf_5pt_reduction(G2H8(23),RedSet_5(20),mass5set(:,4),  & 
G1H8(22),G1H8(23),G1H8(124),G1H8(125),G1H8(126),G1H8(127),8)
call HG1shiftOLR(G1H8(23),2,8)
  call Hloop_UV_W(ntryL,G1H8(24),33,ex5(:),16,G2H4(26),m3h2x4(:,26),heltab2x8(:,:,26))
call Hotf_5pt_reduction(G2H8(24),RedSet_5(19),mass5set(:,4),  & 
G1H8(24),G1H8(128),G1H8(129),G1H8(130),G1H8(131),G1H8(132),8)
call HG1shiftOLR(G1H8(128),2,8)
  call Hloop_AS_Q(ntryL,G1H8(25),ex3(:),G1H8(133),ngH,m3h1x8(:,1),heltab2x8(:,:,27))
  call Hloop_A_Q(ntryL,G1H8(133),44,nMT,G2H8(9),n2h8(23))
call HGT_OLR(G1H8(26),1,1,8)
call HGT_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(26),-16,nMT,G2H8(10),n2h8(24))
  call Hloop_QV_A(ntryL,G2H8(10),ex5(:),G2H4(27),m3h2x4(:,27),heltab2x8(:,:,28))
  call Hloop_AS_Q(ntryL,G1H8(28),ex3(:),G1H8(25),ngH,m3h1x8(:,2),heltab2x8(:,:,29))
  call Hloop_A_Q(ntryL,G1H8(25),44,nMT,G2H8(11),n2h8(25))
  call Hloop_AS_Q(ntryL,G1H8(29),ex3(:),G1H8(133),ngH,m3h1x8(:,3),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G1H8(133),44,nMT,G2H8(12),n2h8(26))
  call Hloop_AS_Q(ntryL,G1H8(30),ex3(:),G1H8(26),ngH,m3h1x8(:,4),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G1H8(26),44,nMT,G2H8(13),n2h8(27))
  call Hloop_AV_Q(ntryL,G1H16(3),ex4(:),G1H8(28),m3h2x8(:,57),heltab2x16(:,:,69))
  call Hloop_A_Q(ntryL,G1H8(28),44,nMT,G2H8(14),n2h8(28))
call HGT_OLR(G1H16(10),1,1,16)
call HGT_invQ_OLR(G1H16(10),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(10),-16,nMT,G2H16(1),n2h16(53))
  call Hloop_QV_A(ntryL,G2H16(1),ex5(:),G2H8(15),m3h2x8(:,58),heltab2x16(:,:,70))
  call Hloop_AV_Q(ntryL,G1H16(11),ex4(:),G1H8(25),m3h2x8(:,59),heltab2x16(:,:,71))
  call Hloop_A_Q(ntryL,G1H8(25),44,nMT,G2H8(16),n2h8(29))
  call Hloop_AV_Q(ntryL,G1H16(12),ex4(:),G1H8(29),m3h2x8(:,60),heltab2x16(:,:,72))
  call Hloop_A_Q(ntryL,G1H8(29),44,nMT,G2H8(17),n2h8(30))
  call Hloop_AV_Q(ntryL,G1H16(13),ex4(:),G1H8(133),m3h2x8(:,61),heltab2x16(:,:,73))
  call Hloop_A_Q(ntryL,G1H8(133),44,nMT,G2H8(18),n2h8(31))
  call Hloop_QV_A(ntryL,G1H16(14),ex5(:),G1H8(30),m3h2x8(:,62),heltab2x16(:,:,74))
  call Hloop_Q_A(ntryL,G1H8(30),52,nMT,G2H8(19),n2h8(32))
call HGT_OLR(G1H16(2),1,1,16)
call HGT_invQ_OLR(G1H16(2),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(2),-8,nMT,G2H16(2),n2h16(54))
  call Hloop_AV_Q(ntryL,G2H16(2),ex4(:),G2H8(20),m3h2x8(:,63),heltab2x16(:,:,75))
  call Hloop_QV_A(ntryL,G1H16(5),ex5(:),G1H8(26),m3h2x8(:,64),heltab2x16(:,:,76))
  call Hloop_Q_A(ntryL,G1H8(26),52,nMT,G2H8(21),n2h8(33))
  call Hloop_QV_A(ntryL,G1H16(16),ex5(:),G1H8(28),m3h2x8(:,65),heltab2x16(:,:,77))
  call Hloop_Q_A(ntryL,G1H8(28),52,nMT,G2H8(22),n2h8(34))
  call Hloop_QV_A(ntryL,G1H16(6),ex5(:),G1H8(25),m3h2x8(:,66),heltab2x16(:,:,78))
  call Hloop_Q_A(ntryL,G1H8(25),52,nMT,G2H8(23),n2h8(35))
  call Hloop_QS_A(ntryL,G1H8(1),ex3(:),G1H8(29),ngH,m3h1x8(:,5),heltab2x8(:,:,32))
  call Hloop_Q_A(ntryL,G1H8(29),44,nMT,G2H8(24),n2h8(36))
call HGT_OLR(G1H8(2),1,1,8)
call HGT_invQ_OLR(G1H8(2),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(2),-16,nMT,G2H8(10),n2h8(37))
  call Hloop_AV_Q(ntryL,G2H8(10),ex5(:),G2H4(28),m3h2x4(:,28),heltab2x8(:,:,33))
  call Hloop_QS_A(ntryL,G1H8(4),ex3(:),G1H8(133),ngH,m3h1x8(:,6),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G1H8(133),44,nMT,G2H8(10),n2h8(38))
  call Hloop_QS_A(ntryL,G1H8(31),ex3(:),G1H8(30),ngH,m3h1x8(:,7),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G1H8(30),44,nMT,G2H8(25),n2h8(39))
  call Hloop_QS_A(ntryL,G1H8(32),ex3(:),G1H8(26),ngH,m3h1x8(:,8),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G1H8(26),44,nMT,G2H8(26),n2h8(40))
  call Hloop_QV_A(ntryL,G1H16(17),ex4(:),G1H8(28),m3h2x8(:,67),heltab2x16(:,:,79))
  call Hloop_Q_A(ntryL,G1H8(28),44,nMT,G2H8(27),n2h8(41))
call HGT_OLR(G1H16(18),1,1,16)
call HGT_invQ_OLR(G1H16(18),2,5,16)
  call Hloop_A_Q(ntryL,G1H16(18),-16,nMT,G2H16(3),n2h16(55))
  call Hloop_AV_Q(ntryL,G2H16(3),ex5(:),G2H8(28),m3h2x8(:,68),heltab2x16(:,:,80))
  call Hloop_QV_A(ntryL,G1H16(20),ex4(:),G1H8(25),m3h2x8(:,69),heltab2x16(:,:,81))
  call Hloop_Q_A(ntryL,G1H8(25),44,nMT,G2H8(29),n2h8(42))
  call Hloop_QV_A(ntryL,G1H16(21),ex4(:),G1H8(1),m3h2x8(:,70),heltab2x16(:,:,82))
  call Hloop_Q_A(ntryL,G1H8(1),44,nMT,G2H8(30),n2h8(43))
  call Hloop_QV_A(ntryL,G1H16(22),ex4(:),G1H8(29),m3h2x8(:,71),heltab2x16(:,:,83))
  call Hloop_Q_A(ntryL,G1H8(29),44,nMT,G2H8(31),n2h8(44))
  call Hloop_AV_Q(ntryL,G1H16(23),ex5(:),G1H8(2),m3h2x8(:,72),heltab2x16(:,:,84))
  call Hloop_A_Q(ntryL,G1H8(2),52,nMT,G2H8(32),n2h8(45))
call HGT_OLR(G1H16(24),1,1,16)
call HGT_invQ_OLR(G1H16(24),2,5,16)
  call Hloop_Q_A(ntryL,G1H16(24),-8,nMT,G2H16(4),n2h16(56))
  call Hloop_QV_A(ntryL,G2H16(4),ex4(:),G2H8(33),m3h2x8(:,73),heltab2x16(:,:,85))
  call Hloop_AV_Q(ntryL,G1H16(26),ex5(:),G1H8(4),m3h2x8(:,74),heltab2x16(:,:,86))
  call Hloop_A_Q(ntryL,G1H8(4),52,nMT,G2H8(34),n2h8(46))
  call Hloop_AV_Q(ntryL,G1H16(27),ex5(:),G1H8(133),m3h2x8(:,75),heltab2x16(:,:,87))
  call Hloop_A_Q(ntryL,G1H8(133),52,nMT,G2H8(35),n2h8(47))
  call Hloop_AV_Q(ntryL,G1H16(7),ex5(:),G1H8(31),m3h2x8(:,76),heltab2x16(:,:,88))
  call Hloop_A_Q(ntryL,G1H8(31),52,nMT,G2H8(36),n2h8(48))
  call Hloop_VQ_A(ntryL,G1H8(5),ex1(:),G1H4(1),m3h2x4(:,29),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G1H4(1),41,nMT,G2H4(29),n2h4(13))
call HGT_raise_alpha_OLR(G1H8(6),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(6),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(6),-16,ex5(:),16,G2H4(30),m3h2x4(:,30),heltab2x8(:,:,38))
call signflip_OLR(G2H4(30))
  call Hloop_VQ_A(ntryL,G1H8(8),ex1(:),G1H4(1),m3h2x4(:,31),heltab2x8(:,:,39))
  call Hloop_Q_A(ntryL,G1H4(1),41,nMT,G2H4(31),n2h4(14))
  call Hloop_VQ_A(ntryL,G1H8(9),ex1(:),G1H4(1),m3h2x4(:,32),heltab2x8(:,:,40))
  call Hloop_Q_A(ntryL,G1H4(1),41,nMT,G2H4(32),n2h4(15))
  call Hloop_VQ_A(ntryL,G1H8(10),ex1(:),G1H4(1),m3h2x4(:,33),heltab2x8(:,:,41))
  call Hloop_Q_A(ntryL,G1H4(1),41,nMT,G2H4(33),n2h4(16))
  call Hloop_AS_Q(ntryL,G1H8(11),ex3(:),G1H8(30),ngH,m3h1x8(:,9),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G1H8(30),38,nMT,G2H8(37),n2h8(50))
call HGT_raise_alpha_OLR(G1H8(12),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(12),-16,ex5(:),16,G2H4(34),m3h2x4(:,34),heltab2x8(:,:,43))
call signflip_OLR(G2H4(34))
  call Hloop_AS_Q(ntryL,G1H8(34),ex3(:),G1H8(32),ngH,m3h1x8(:,10),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G1H8(32),38,nMT,G2H8(38),n2h8(52))
  call Hloop_AS_Q(ntryL,G1H8(35),ex3(:),G1H8(26),ngH,m3h1x8(:,11),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G1H8(26),38,nMT,G2H8(39),n2h8(53))
  call Hloop_AS_Q(ntryL,G1H8(36),ex3(:),G1H8(28),ngH,m3h1x8(:,12),heltab2x8(:,:,46))
  call Hloop_A_Q(ntryL,G1H8(28),38,nMT,G2H8(40),n2h8(54))
  call Hloop_AV_Q(ntryL,G1H8(13),ex5(:),G1H4(1),m3h2x4(:,35),heltab2x8(:,:,47))
  call Hloop_A_Q(ntryL,G1H4(1),50,nMT,G2H4(35),n2h4(17))
call HGT_raise_alpha_OLR(G1H8(37),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(37),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(37),-8,ex4(:),8,G2H4(36),m3h2x4(:,36),heltab2x8(:,:,48))
call signflip_OLR(G2H4(36))
  call Hloop_AV_Q(ntryL,G1H8(39),ex5(:),G1H4(1),m3h2x4(:,37),heltab2x8(:,:,49))
  call Hloop_A_Q(ntryL,G1H4(1),50,nMT,G2H4(37),n2h4(18))
  call Hloop_AV_Q(ntryL,G1H8(40),ex5(:),G1H4(1),m3h2x4(:,38),heltab2x8(:,:,50))
  call Hloop_A_Q(ntryL,G1H4(1),50,nMT,G2H4(38),n2h4(19))
  call Hloop_AV_Q(ntryL,G1H8(41),ex5(:),G1H4(1),m3h2x4(:,39),heltab2x8(:,:,51))
  call Hloop_A_Q(ntryL,G1H4(1),50,nMT,G2H4(39),n2h4(20))
  call Hloop_VA_Q(ntryL,G1H8(14),ex2(:),G1H4(1),m3h2x4(:,40),heltab2x8(:,:,52))
  call Hloop_A_Q(ntryL,G1H4(1),42,nMT,G2H4(40),n2h4(21))
call HGT_raise_alpha_OLR(G1H8(42),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(42),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(42),-16,ex5(:),16,G2H4(41),m3h2x4(:,41),heltab2x8(:,:,53))
call signflip_OLR(G2H4(41))
  call Hloop_VA_Q(ntryL,G1H8(44),ex2(:),G1H4(1),m3h2x4(:,42),heltab2x8(:,:,54))
  call Hloop_A_Q(ntryL,G1H4(1),42,nMT,G2H4(42),n2h4(22))
  call Hloop_VA_Q(ntryL,G1H8(45),ex2(:),G1H4(1),m3h2x4(:,43),heltab2x8(:,:,55))
  call Hloop_A_Q(ntryL,G1H4(1),42,nMT,G2H4(43),n2h4(23))
  call Hloop_VA_Q(ntryL,G1H8(46),ex2(:),G1H4(1),m3h2x4(:,44),heltab2x8(:,:,56))
  call Hloop_A_Q(ntryL,G1H4(1),42,nMT,G2H4(44),n2h4(24))
  call Hloop_AS_Q(ntryL,G1H8(47),ex3(:),G1H8(25),ngH,m3h1x8(:,13),heltab2x8(:,:,57))
  call Hloop_A_Q(ntryL,G1H8(25),38,nMT,G2H8(41),n2h8(57))
call HGT_raise_alpha_OLR(G1H8(48),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(48),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(48),-8,ex4(:),8,G2H4(45),m3h2x4(:,45),heltab2x8(:,:,58))
call signflip_OLR(G2H4(45))
  call Hloop_AS_Q(ntryL,G1H8(50),ex3(:),G1H8(1),ngH,m3h1x8(:,14),heltab2x8(:,:,59))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(42),n2h8(59))
  call Hloop_AS_Q(ntryL,G1H8(51),ex3(:),G1H8(29),ngH,m3h1x8(:,15),heltab2x8(:,:,60))
  call Hloop_A_Q(ntryL,G1H8(29),38,nMT,G2H8(43),n2h8(60))
  call Hloop_AS_Q(ntryL,G1H8(52),ex3(:),G1H8(2),ngH,m3h1x8(:,16),heltab2x8(:,:,61))
  call Hloop_A_Q(ntryL,G1H8(2),38,nMT,G2H8(44),n2h8(61))
  call Hloop_AV_Q(ntryL,G1H8(53),ex4(:),G1H4(1),m3h2x4(:,46),heltab2x8(:,:,62))
  call Hloop_A_Q(ntryL,G1H4(1),42,nMT,G2H4(46),n2h4(25))
call HGT_raise_alpha_OLR(G1H8(54),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(54),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(54),-16,ex5(:),16,G2H4(47),m3h2x4(:,47),heltab2x8(:,:,63))
call signflip_OLR(G2H4(47))
  call Hloop_AV_Q(ntryL,G1H8(56),ex4(:),G1H4(1),m3h2x4(:,48),heltab2x8(:,:,64))
  call Hloop_A_Q(ntryL,G1H4(1),42,nMT,G2H4(48),n2h4(26))
  call Hloop_AV_Q(ntryL,G1H8(57),ex4(:),G1H4(1),m3h2x4(:,49),heltab2x8(:,:,65))
  call Hloop_A_Q(ntryL,G1H4(1),42,nMT,G2H4(49),n2h4(27))
  call Hloop_AV_Q(ntryL,G1H8(58),ex4(:),G1H4(1),m3h2x4(:,50),heltab2x8(:,:,66))
  call Hloop_A_Q(ntryL,G1H4(1),42,nMT,G2H4(50),n2h4(28))
  call Hloop_QS_A(ntryL,G1H8(15),ex3(:),G1H8(4),ngH,m3h1x8(:,17),heltab2x8(:,:,67))
  call Hloop_Q_A(ntryL,G1H8(4),37,nMT,G2H8(45),n2h8(63))
call HGT_raise_alpha_OLR(G1H8(16),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(16),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(16),-16,ex5(:),16,G2H4(51),m3h2x4(:,51),heltab2x8(:,:,68))
call signflip_OLR(G2H4(51))
  call Hloop_QS_A(ntryL,G1H8(60),ex3(:),G1H8(133),ngH,m3h1x8(:,18),heltab2x8(:,:,69))
  call Hloop_Q_A(ntryL,G1H8(133),37,nMT,G2H8(46),n2h8(65))
  call Hloop_QS_A(ntryL,G1H8(61),ex3(:),G1H8(31),ngH,m3h1x8(:,19),heltab2x8(:,:,70))
  call Hloop_Q_A(ntryL,G1H8(31),37,nMT,G2H8(47),n2h8(66))
  call Hloop_QS_A(ntryL,G1H8(62),ex3(:),G1H8(5),ngH,m3h1x8(:,20),heltab2x8(:,:,71))
  call Hloop_Q_A(ntryL,G1H8(5),37,nMT,G2H8(48),n2h8(67))
  call Hloop_QS_A(ntryL,G1H8(63),ex3(:),G1H8(6),ngH,m3h1x8(:,21),heltab2x8(:,:,72))
  call Hloop_Q_A(ntryL,G1H8(6),37,nMT,G2H8(49),n2h8(68))
call HGT_raise_alpha_OLR(G1H8(64),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(64),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(64),-8,ex4(:),8,G2H4(52),m3h2x4(:,52),heltab2x8(:,:,73))
call signflip_OLR(G2H4(52))
  call Hloop_QS_A(ntryL,G1H8(66),ex3(:),G1H8(8),ngH,m3h1x8(:,22),heltab2x8(:,:,74))
  call Hloop_Q_A(ntryL,G1H8(8),37,nMT,G2H8(50),n2h8(70))
  call Hloop_QS_A(ntryL,G1H8(67),ex3(:),G1H8(9),ngH,m3h1x8(:,23),heltab2x8(:,:,75))
  call Hloop_Q_A(ntryL,G1H8(9),37,nMT,G2H8(51),n2h8(71))
  call Hloop_QS_A(ntryL,G1H8(68),ex3(:),G1H8(10),ngH,m3h1x8(:,24),heltab2x8(:,:,76))
  call Hloop_Q_A(ntryL,G1H8(10),37,nMT,G2H8(52),n2h8(72))
  call Hloop_QS_A(ntryL,G1H8(69),ex3(:),G1H8(11),ngH,m3h1x8(:,25),heltab2x8(:,:,77))
  call Hloop_Q_A(ntryL,G1H8(11),37,nMT,G2H8(53),n2h8(73))
call HGT_raise_alpha_OLR(G1H8(70),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(70),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(70),-16,ex5(:),16,G2H4(53),m3h2x4(:,53),heltab2x8(:,:,78))
call signflip_OLR(G2H4(53))
  call Hloop_QS_A(ntryL,G1H8(72),ex3(:),G1H8(30),ngH,m3h1x8(:,26),heltab2x8(:,:,79))
  call Hloop_Q_A(ntryL,G1H8(30),37,nMT,G2H8(54),n2h8(75))
  call Hloop_QS_A(ntryL,G1H8(73),ex3(:),G1H8(12),ngH,m3h1x8(:,27),heltab2x8(:,:,80))
  call Hloop_Q_A(ntryL,G1H8(12),37,nMT,G2H8(55),n2h8(76))
  call Hloop_QS_A(ntryL,G1H8(74),ex3(:),G1H8(34),ngH,m3h1x8(:,28),heltab2x8(:,:,81))
  call Hloop_Q_A(ntryL,G1H8(34),37,nMT,G2H8(56),n2h8(77))
  call Hloop_QS_A(ntryL,G1H8(75),ex3(:),G1H8(32),ngH,m3h1x8(:,29),heltab2x8(:,:,82))
  call Hloop_Q_A(ntryL,G1H8(32),37,nMT,G2H8(57),n2h8(78))
call HGT_raise_alpha_OLR(G1H8(76),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(76),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(76),-8,ex4(:),8,G2H4(54),m3h2x4(:,54),heltab2x8(:,:,83))
call signflip_OLR(G2H4(54))
  call Hloop_QS_A(ntryL,G1H8(78),ex3(:),G1H8(35),ngH,m3h1x8(:,30),heltab2x8(:,:,84))
  call Hloop_Q_A(ntryL,G1H8(35),37,nMT,G2H8(58),n2h8(80))
  call Hloop_QS_A(ntryL,G1H8(79),ex3(:),G1H8(26),ngH,m3h1x8(:,31),heltab2x8(:,:,85))
  call Hloop_Q_A(ntryL,G1H8(26),37,nMT,G2H8(59),n2h8(81))
  call Hloop_QS_A(ntryL,G1H8(80),ex3(:),G1H8(36),ngH,m3h1x8(:,32),heltab2x8(:,:,86))
  call Hloop_Q_A(ntryL,G1H8(36),37,nMT,G2H8(60),n2h8(82))
  call Hloop_QS_A(ntryL,G1H8(81),ex3(:),G1H8(28),ngH,m3h1x8(:,33),heltab2x8(:,:,87))
  call Hloop_Q_A(ntryL,G1H8(28),37,nMT,G2H8(61),n2h8(83))
call HGT_raise_alpha_OLR(G1H8(82),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(82),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(82),ex2(:),G1H4(1),m3h2x4(:,55),heltab2x8(:,:,88))
  call Hloop_QS_A(ntryL,G1H8(84),ex3(:),G1H8(13),ngH,m3h1x8(:,34),heltab2x8(:,:,89))
  call Hloop_Q_A(ntryL,G1H8(13),37,nMT,G2H8(62),n2h8(85))
  call Hloop_QS_A(ntryL,G1H8(85),ex3(:),G1H8(37),ngH,m3h1x8(:,35),heltab2x8(:,:,90))
  call Hloop_Q_A(ntryL,G1H8(37),37,nMT,G2H8(63),n2h8(86))
  call Hloop_QS_A(ntryL,G1H8(86),ex3(:),G1H8(39),ngH,m3h1x8(:,36),heltab2x8(:,:,91))
  call Hloop_Q_A(ntryL,G1H8(39),37,nMT,G2H8(64),n2h8(87))
  call Hloop_QS_A(ntryL,G1H8(87),ex3(:),G1H8(40),ngH,m3h1x8(:,37),heltab2x8(:,:,92))
  call Hloop_Q_A(ntryL,G1H8(40),37,nMT,G2H8(65),n2h8(88))
call HGT_raise_alpha_OLR(G1H8(88),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(88),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(88),ex2(:),G1H4(2),m3h2x4(:,56),heltab2x8(:,:,93))
  call Hloop_QS_A(ntryL,G1H8(90),ex3(:),G1H8(41),ngH,m3h1x8(:,38),heltab2x8(:,:,94))
  call Hloop_Q_A(ntryL,G1H8(41),37,nMT,G2H8(66),n2h8(90))
  call Hloop_QS_A(ntryL,G1H8(91),ex3(:),G1H8(14),ngH,m3h1x8(:,39),heltab2x8(:,:,95))
  call Hloop_Q_A(ntryL,G1H8(14),37,nMT,G2H8(67),n2h8(91))
  call Hloop_QS_A(ntryL,G1H8(92),ex3(:),G1H8(42),ngH,m3h1x8(:,40),heltab2x8(:,:,96))
  call Hloop_Q_A(ntryL,G1H8(42),37,nMT,G2H8(68),n2h8(92))
  call Hloop_AS_Q(ntryL,G1H8(93),ex3(:),G1H8(44),ngH,m3h1x8(:,41),heltab2x8(:,:,97))
  call Hloop_A_Q(ntryL,G1H8(44),38,nMT,G2H8(69),n2h8(93))
call HGT_raise_alpha_OLR(G1H8(94),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(94),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(94),-16,ex5(:),16,G2H4(55),m3h2x4(:,57),heltab2x8(:,:,98))
call signflip_OLR(G2H4(55))
  call Hloop_AS_Q(ntryL,G1H8(96),ex3(:),G1H8(45),ngH,m3h1x8(:,42),heltab2x8(:,:,99))
  call Hloop_A_Q(ntryL,G1H8(45),38,nMT,G2H8(70),n2h8(95))
  call Hloop_AS_Q(ntryL,G1H8(97),ex3(:),G1H8(46),ngH,m3h1x8(:,43),heltab2x8(:,:,100))
  call Hloop_A_Q(ntryL,G1H8(46),38,nMT,G2H8(71),n2h8(96))
  call Hloop_AS_Q(ntryL,G1H8(98),ex3(:),G1H8(47),ngH,m3h1x8(:,44),heltab2x8(:,:,101))
  call Hloop_A_Q(ntryL,G1H8(47),38,nMT,G2H8(72),n2h8(97))
  call Hloop_AS_Q(ntryL,G1H8(99),ex3(:),G1H8(25),ngH,m3h1x8(:,45),heltab2x8(:,:,102))
  call Hloop_A_Q(ntryL,G1H8(25),38,nMT,G2H8(73),n2h8(98))
call HGT_raise_alpha_OLR(G1H8(100),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(100),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(100),-8,ex4(:),8,G2H4(56),m3h2x4(:,58),heltab2x8(:,:,103))
call signflip_OLR(G2H4(56))
  call Hloop_AS_Q(ntryL,G1H8(102),ex3(:),G1H8(48),ngH,m3h1x8(:,46),heltab2x8(:,:,104))
  call Hloop_A_Q(ntryL,G1H8(48),38,nMT,G2H8(74),n2h8(100))
  call Hloop_AS_Q(ntryL,G1H8(103),ex3(:),G1H8(50),ngH,m3h1x8(:,47),heltab2x8(:,:,105))
  call Hloop_A_Q(ntryL,G1H8(50),38,nMT,G2H8(75),n2h8(101))
  call Hloop_AS_Q(ntryL,G1H8(104),ex3(:),G1H8(1),ngH,m3h1x8(:,48),heltab2x8(:,:,106))
  call Hloop_A_Q(ntryL,G1H8(1),38,nMT,G2H8(76),n2h8(102))
  call Hloop_QV_A(ntryL,G1H8(17),ex4(:),G1H4(3),m3h2x4(:,59),heltab2x8(:,:,107))
  call Hloop_Q_A(ntryL,G1H4(3),41,nMT,G2H4(57),n2h4(29))
call HGT_raise_alpha_OLR(G1H8(18),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(18),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(18),-16,ex5(:),16,G2H4(58),m3h2x4(:,60),heltab2x8(:,:,108))
call signflip_OLR(G2H4(58))
  call Hloop_QV_A(ntryL,G1H8(105),ex4(:),G1H4(3),m3h2x4(:,61),heltab2x8(:,:,109))
  call Hloop_Q_A(ntryL,G1H4(3),41,nMT,G2H4(59),n2h4(30))
  call Hloop_QV_A(ntryL,G1H8(106),ex4(:),G1H4(3),m3h2x4(:,62),heltab2x8(:,:,110))
  call Hloop_Q_A(ntryL,G1H4(3),41,nMT,G2H4(60),n2h4(31))
  call Hloop_QV_A(ntryL,G1H8(107),ex4(:),G1H4(3),m3h2x4(:,63),heltab2x8(:,:,111))
  call Hloop_Q_A(ntryL,G1H4(3),41,nMT,G2H4(61),n2h4(32))
  call Hloop_QV_A(ntryL,G1H8(20),ex4(:),G1H4(3),m3h2x4(:,64),heltab2x8(:,:,112))
  call Hloop_Q_A(ntryL,G1H4(3),41,nMT,G2H4(62),n2h4(33))
call HGT_raise_alpha_OLR(G1H8(108),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(108),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(108),ex2(:),G1H4(3),m3h2x4(:,65),heltab2x8(:,:,113))
  call Hloop_QV_A(ntryL,G1H8(110),ex4(:),G1H4(4),m3h2x4(:,66),heltab2x8(:,:,114))
  call Hloop_Q_A(ntryL,G1H4(4),41,nMT,G2H4(63),n2h4(34))
  call Hloop_QV_A(ntryL,G1H8(111),ex4(:),G1H4(4),m3h2x4(:,67),heltab2x8(:,:,115))
  call Hloop_Q_A(ntryL,G1H4(4),41,nMT,G2H4(64),n2h4(35))
  call Hloop_QV_A(ntryL,G1H8(112),ex4(:),G1H4(4),m3h2x4(:,68),heltab2x8(:,:,116))
  call Hloop_Q_A(ntryL,G1H4(4),41,nMT,G2H4(65),n2h4(36))
  call Hloop_QV_A(ntryL,G1H8(21),ex4(:),G1H4(4),m3h2x4(:,69),heltab2x8(:,:,117))
  call Hloop_Q_A(ntryL,G1H4(4),41,nMT,G2H4(66),n2h4(37))
call HGT_raise_alpha_OLR(G1H8(113),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(113),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(113),ex2(:),G1H4(4),m3h2x4(:,70),heltab2x8(:,:,118))
  call Hloop_QV_A(ntryL,G1H8(115),ex4(:),G1H4(5),m3h2x4(:,71),heltab2x8(:,:,119))
  call Hloop_Q_A(ntryL,G1H4(5),41,nMT,G2H4(67),n2h4(38))
  call Hloop_QV_A(ntryL,G1H8(116),ex4(:),G1H4(5),m3h2x4(:,72),heltab2x8(:,:,120))
  call Hloop_Q_A(ntryL,G1H4(5),41,nMT,G2H4(68),n2h4(39))
  call Hloop_QV_A(ntryL,G1H8(117),ex4(:),G1H4(5),m3h2x4(:,73),heltab2x8(:,:,121))
  call Hloop_Q_A(ntryL,G1H4(5),41,nMT,G2H4(69),n2h4(40))
  call Hloop_QV_A(ntryL,G1H8(118),ex5(:),G1H4(5),m3h2x4(:,74),heltab2x8(:,:,122))
  call Hloop_Q_A(ntryL,G1H4(5),49,nMT,G2H4(70),n2h4(41))
call HGT_raise_alpha_OLR(G1H8(119),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(119),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(119),-8,ex4(:),8,G2H4(71),m3h2x4(:,75),heltab2x8(:,:,123))
call signflip_OLR(G2H4(71))
  call Hloop_QV_A(ntryL,G1H8(121),ex5(:),G1H4(5),m3h2x4(:,76),heltab2x8(:,:,124))
  call Hloop_Q_A(ntryL,G1H4(5),49,nMT,G2H4(72),n2h4(42))
  call Hloop_QV_A(ntryL,G1H8(122),ex5(:),G1H4(5),m3h2x4(:,77),heltab2x8(:,:,125))
  call Hloop_Q_A(ntryL,G1H4(5),49,nMT,G2H4(73),n2h4(43))
  call Hloop_QV_A(ntryL,G1H8(123),ex5(:),G1H4(5),m3h2x4(:,78),heltab2x8(:,:,126))
  call Hloop_Q_A(ntryL,G1H4(5),49,nMT,G2H4(74),n2h4(44))
  call Hloop_QV_A(ntryL,G1H8(22),ex5(:),G1H4(5),m3h2x4(:,79),heltab2x8(:,:,127))
  call Hloop_Q_A(ntryL,G1H4(5),49,nMT,G2H4(75),n2h4(45))
call HGT_raise_alpha_OLR(G1H8(23),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(23),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(23),ex2(:),G1H4(5),m3h2x4(:,80),heltab2x8(:,:,128))
  call Hloop_QV_A(ntryL,G1H8(125),ex5(:),G1H4(6),m3h2x4(:,81),heltab2x8(:,:,129))
  call Hloop_Q_A(ntryL,G1H4(6),49,nMT,G2H4(76),n2h4(46))
  call Hloop_QV_A(ntryL,G1H8(126),ex5(:),G1H4(6),m3h2x4(:,82),heltab2x8(:,:,130))
  call Hloop_Q_A(ntryL,G1H4(6),49,nMT,G2H4(77),n2h4(47))
  call Hloop_QV_A(ntryL,G1H8(127),ex5(:),G1H4(6),m3h2x4(:,83),heltab2x8(:,:,131))
  call Hloop_Q_A(ntryL,G1H4(6),49,nMT,G2H4(78),n2h4(48))
  call Hloop_QV_A(ntryL,G1H8(24),ex5(:),G1H4(6),m3h2x4(:,84),heltab2x8(:,:,132))
  call Hloop_Q_A(ntryL,G1H4(6),49,nMT,G2H4(79),n2h4(49))
call HGT_raise_alpha_OLR(G1H8(128),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(128),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(128),ex2(:),G1H4(6),m3h2x4(:,85),heltab2x8(:,:,133))
  call Hloop_QV_A(ntryL,G1H8(130),ex5(:),G1H4(7),m3h2x4(:,86),heltab2x8(:,:,134))
  call Hloop_Q_A(ntryL,G1H4(7),49,nMT,G2H4(80),n2h4(50))
  call Hloop_QV_A(ntryL,G1H8(131),ex5(:),G1H4(7),m3h2x4(:,87),heltab2x8(:,:,135))
  call Hloop_Q_A(ntryL,G1H4(7),49,nMT,G2H4(81),n2h4(51))
  call Hloop_QV_A(ntryL,G1H8(132),ex5(:),G1H4(7),m3h2x4(:,88),heltab2x8(:,:,136))
  call Hloop_Q_A(ntryL,G1H4(7),49,nMT,G2H4(82),n2h4(52))
call Hotf_5pt_reduction(G2H4(1),RedSet_5(21),mass5set(:,5),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
call HG1shiftOLR(G1H4(8),16,4)
call Hotf_5pt_reduction(G2H8(1),RedSet_5(22),mass5set(:,5),  & 
G1H8(51),G1H8(29),G1H8(52),G1H8(2),G1H8(53),G1H8(54),8)
call HG1shiftOLR(G1H8(29),16,8)
call Hotf_5pt_reduction(G2H8(2),RedSet_5(22),mass5set(:,5),  & 
G1H8(56),G1H8(57),G1H8(58),G1H8(15),G1H8(4),G1H8(16),8)
call HG1shiftOLR(G1H8(57),8,8)
call Hotf_5pt_reduction(G2H4(2),RedSet_5(23),mass5set(:,6),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
call HG1shiftOLR(G1H4(14),16,4)
call Hotf_5pt_reduction(G2H4(3),RedSet_5(23),mass5set(:,6),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
call HG1shiftOLR(G1H4(20),8,4)
call Hotf_5pt_reduction(G2H4(4),RedSet_5(24),mass5set(:,5),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
call HG1shiftOLR(G1H4(26),16,4)
call Hotf_5pt_reduction(G2H8(3),RedSet_5(25),mass5set(:,5),  & 
G1H8(60),G1H8(133),G1H8(61),G1H8(31),G1H8(62),G1H8(5),8)
call HG1shiftOLR(G1H8(133),16,8)
call Hotf_5pt_reduction(G2H4(5),RedSet_5(26),mass5set(:,6),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
call HG1shiftOLR(G1H4(32),16,4)
call Hotf_5pt_reduction(G2H4(6),RedSet_5(26),mass5set(:,6),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
call HG1shiftOLR(G1H4(38),4,4)
call Hotf_5pt_reduction(G2H8(4),RedSet_5(25),mass5set(:,5),  & 
G1H8(63),G1H8(6),G1H8(64),G1H8(66),G1H8(8),G1H8(67),8)
call HG1shiftOLR(G1H8(6),8,8)
call Hotf_5pt_reduction(G2H4(7),RedSet_5(27),mass5set(:,6),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
call HG1shiftOLR(G1H4(44),8,4)
call Hotf_5pt_reduction(G2H4(8),RedSet_5(27),mass5set(:,6),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
call HG1shiftOLR(G1H4(50),4,4)
call Hotf_5pt_reduction(G2H4(9),RedSet_5(28),mass5set(:,6),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
call HG1shiftOLR(G1H4(56),16,4)
call Hotf_5pt_reduction(G2H4(10),RedSet_5(28),mass5set(:,6),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
call HG1shiftOLR(G1H4(62),8,4)
call Hotf_5pt_reduction(G2H4(11),RedSet_5(29),mass5set(:,6),  & 
G1H4(67),G1H4(68),G1H4(69),G1H4(70),G1H4(71),G1H4(72),4)
call HG1shiftOLR(G1H4(68),16,4)
call Hotf_5pt_reduction(G2H4(12),RedSet_5(29),mass5set(:,6),  & 
G1H4(73),G1H4(74),G1H4(75),G1H4(76),G1H4(77),G1H4(78),4)
call HG1shiftOLR(G1H4(74),4,4)
call Hotf_5pt_reduction(G2H4(13),RedSet_5(30),mass5set(:,6),  & 
G1H4(79),G1H4(80),G1H4(81),G1H4(82),G1H4(83),G1H4(84),4)
call HG1shiftOLR(G1H4(80),8,4)
call Hotf_5pt_reduction(G2H4(14),RedSet_5(30),mass5set(:,6),  & 
G1H4(85),G1H4(86),G1H4(87),G1H4(88),G1H4(89),G1H4(90),4)
call HG1shiftOLR(G1H4(86),4,4)
call Hotf_5pt_reduction(G2H8(5),RedSet_5(31),mass5set(:,7),  & 
G1H8(9),G1H8(68),G1H8(10),G1H8(69),G1H8(11),G1H8(70),8)
call HG1shiftOLR(G1H8(68),16,8)
call Hotf_5pt_reduction(G2H4(15),RedSet_5(32),mass5set(:,8),  & 
G1H4(91),G1H4(92),G1H4(93),G1H4(94),G1H4(95),G1H4(96),4)
call HG1shiftOLR(G1H4(92),16,4)
call Hotf_5pt_reduction(G2H4(16),RedSet_5(33),mass5set(:,9),  & 
G1H4(97),G1H4(98),G1H4(99),G1H4(100),G1H4(101),G1H4(102),4)
call HG1shiftOLR(G1H4(98),4,4)
call Hotf_5pt_reduction(G2H8(6),RedSet_5(34),mass5set(:,7),  & 
G1H8(72),G1H8(30),G1H8(73),G1H8(12),G1H8(74),G1H8(34),8)
call HG1shiftOLR(G1H8(30),8,8)
call Hotf_5pt_reduction(G2H4(17),RedSet_5(35),mass5set(:,9),  & 
G1H4(103),G1H4(104),G1H4(105),G1H4(106),G1H4(107),G1H4(108),4)
call HG1shiftOLR(G1H4(104),4,4)
call Hotf_5pt_reduction(G2H4(18),RedSet_5(36),mass5set(:,8),  & 
G1H4(109),G1H4(110),G1H4(111),G1H4(112),G1H4(113),G1H4(114),4)
call HG1shiftOLR(G1H4(110),8,4)
call Hotf_5pt_reduction(G2H8(7),RedSet_5(37),mass5set(:,7),  & 
G1H8(75),G1H8(32),G1H8(76),G1H8(78),G1H8(35),G1H8(79),8)
call HG1shiftOLR(G1H8(32),16,8)
call Hotf_5pt_reduction(G2H8(8),RedSet_5(38),mass5set(:,7),  & 
G1H8(26),G1H8(80),G1H8(36),G1H8(81),G1H8(28),G1H8(82),8)
call HG1shiftOLR(G1H8(80),8,8)
call Hotf_5pt_reduction(G2H4(19),RedSet_5(32),mass5set(:,8),  & 
G1H4(115),G1H4(116),G1H4(117),G1H4(118),G1H4(119),G1H4(120),4)
call HG1shiftOLR(G1H4(116),4,4)
call Hotf_5pt_reduction(G2H4(20),RedSet_5(36),mass5set(:,8),  & 
G1H4(121),G1H4(122),G1H4(123),G1H4(124),G1H4(125),G1H4(126),4)
call HG1shiftOLR(G1H4(122),4,4)
call Hotf_5pt_reduction(G2H4(21),RedSet_5(39),mass5set(:,8),  & 
G1H4(127),G1H4(128),G1H4(129),G1H4(130),G1H4(131),G1H4(132),4)
call HG1shiftOLR(G1H4(128),16,4)
call Hotf_5pt_reduction(G2H4(22),RedSet_5(18),mass5set(:,9),  & 
G1H4(133),G1H4(134),G1H4(135),G1H4(136),G1H4(137),G1H4(138),4)
call HG1shiftOLR(G1H4(134),4,4)
call Hotf_5pt_reduction(G2H4(23),RedSet_5(39),mass5set(:,8),  & 
G1H4(139),G1H4(140),G1H4(141),G1H4(142),G1H4(143),G1H4(144),4)
call HG1shiftOLR(G1H4(140),4,4)
call Hotf_5pt_reduction(G2H4(24),RedSet_5(20),mass5set(:,9),  & 
G1H4(145),G1H4(146),G1H4(147),G1H4(148),G1H4(149),G1H4(150),4)
call HG1shiftOLR(G1H4(146),4,4)
call Hotf_5pt_reduction(G2H4(25),RedSet_5(40),mass5set(:,8),  & 
G1H4(151),G1H4(152),G1H4(153),G1H4(154),G1H4(155),G1H4(156),4)
call HG1shiftOLR(G1H4(152),8,4)
call Hotf_5pt_reduction(G2H4(26),RedSet_5(40),mass5set(:,8),  & 
G1H4(157),G1H4(158),G1H4(159),G1H4(160),G1H4(161),G1H4(162),4)
call HG1shiftOLR(G1H4(158),4,4)
  call Hloop_AQ_V(ntryL,G2H8(9),ex1(:),G2H4(1),m3h2x4(:,89),heltab2x8(:,:,137))
  call Hloop_AQ_V(ntryL,G2H8(12),ex1(:),G2H4(2),m3h2x4(:,90),heltab2x8(:,:,138))
  call Hloop_AQ_V(ntryL,G2H8(13),ex1(:),G2H4(3),m3h2x4(:,91),heltab2x8(:,:,139))
  call Hloop_AQ_V(ntryL,G2H8(14),ex1(:),G2H4(4),m3h2x4(:,92),heltab2x8(:,:,140))
  call Hloop_AQ_V(ntryL,G2H8(17),ex1(:),G2H4(5),m3h2x4(:,93),heltab2x8(:,:,141))
  call Hloop_AQ_V(ntryL,G2H8(18),ex1(:),G2H4(6),m3h2x4(:,94),heltab2x8(:,:,142))
  call Hloop_QA_V(ntryL,G2H8(19),ex2(:),G2H4(7),m3h2x4(:,95),heltab2x8(:,:,143))
  call Hloop_QA_V(ntryL,G2H8(22),ex2(:),G2H4(8),m3h2x4(:,96),heltab2x8(:,:,144))
  call Hloop_QA_V(ntryL,G2H8(23),ex2(:),G2H4(9),m3h2x4(:,97),heltab2x8(:,:,145))
  call Hloop_QA_V(ntryL,G2H8(24),ex2(:),G2H4(10),m3h2x4(:,98),heltab2x8(:,:,146))
  call Hloop_QA_V(ntryL,G2H8(25),ex2(:),G2H4(11),m3h2x4(:,99),heltab2x8(:,:,147))
  call Hloop_QA_V(ntryL,G2H8(26),ex2(:),G2H4(12),m3h2x4(:,100),heltab2x8(:,:,148))
  call Hloop_QA_V(ntryL,G2H8(27),ex2(:),G2H4(13),m3h2x4(:,101),heltab2x8(:,:,149))
  call Hloop_QA_V(ntryL,G2H8(30),ex2(:),G2H4(14),m3h2x4(:,102),heltab2x8(:,:,150))
  call Hloop_QA_V(ntryL,G2H8(31),ex2(:),G2H4(15),m3h2x4(:,103),heltab2x8(:,:,151))
  call Hloop_AQ_V(ntryL,G2H8(32),ex1(:),G2H4(16),m3h2x4(:,104),heltab2x8(:,:,152))
  call Hloop_AQ_V(ntryL,G2H8(35),ex1(:),G2H4(17),m3h2x4(:,105),heltab2x8(:,:,153))
  call Hloop_AQ_V(ntryL,G2H8(36),ex1(:),G2H4(18),m3h2x4(:,106),heltab2x8(:,:,154))
call Hotf_5pt_reduction(G2H4(29),RedSet_5(7),mass5set(:,2),  & 
G1H4(163),G1H4(164),G1H4(165),G1H4(166),G1H4(167),G1H4(168),4)
call HG1shiftOLR(G1H4(164),16,4)
call Hotf_5pt_reduction(G2H4(32),RedSet_5(41),mass5set(:,10),  & 
G1H4(169),G1H4(170),G1H4(171),G1H4(172),G1H4(173),G1H4(174),4)
call HG1shiftOLR(G1H4(170),16,4)
call Hotf_5pt_reduction(G2H4(33),RedSet_5(42),mass5set(:,10),  & 
G1H4(175),G1H4(176),G1H4(177),G1H4(178),G1H4(179),G1H4(180),4)
call HG1shiftOLR(G1H4(176),16,4)
  call Hloop_AQ_V(ntryL,G2H8(37),ex1(:),G2H4(19),m3h2x4(:,107),heltab2x8(:,:,155))
  call Hloop_AQ_V(ntryL,G2H8(39),ex1(:),G2H4(20),m3h2x4(:,108),heltab2x8(:,:,156))
  call Hloop_AQ_V(ntryL,G2H8(40),ex1(:),G2H4(21),m3h2x4(:,109),heltab2x8(:,:,157))
call Hotf_5pt_reduction(G2H4(35),RedSet_5(9),mass5set(:,4),  & 
G1H4(181),G1H4(182),G1H4(183),G1H4(184),G1H4(185),G1H4(186),4)
call HG1shiftOLR(G1H4(182),8,4)
call Hotf_5pt_reduction(G2H4(38),RedSet_5(43),mass5set(:,3),  & 
G1H4(187),G1H4(188),G1H4(189),G1H4(190),G1H4(191),G1H4(192),4)
call HG1shiftOLR(G1H4(188),8,4)
call Hotf_5pt_reduction(G2H4(39),RedSet_5(44),mass5set(:,3),  & 
G1H4(193),G1H4(194),G1H4(195),G1H4(196),G1H4(197),G1H4(198),4)
call HG1shiftOLR(G1H4(194),8,4)
call Hotf_5pt_reduction(G2H4(40),RedSet_5(10),mass5set(:,2),  & 
G1H4(199),G1H4(200),G1H4(201),G1H4(202),G1H4(203),G1H4(204),4)
call HG1shiftOLR(G1H4(200),16,4)
call Hotf_5pt_reduction(G2H4(43),RedSet_5(45),mass5set(:,10),  & 
G1H4(205),G1H4(206),G1H4(207),G1H4(208),G1H4(209),G1H4(210),4)
call HG1shiftOLR(G1H4(206),16,4)
call Hotf_5pt_reduction(G2H4(44),RedSet_5(46),mass5set(:,10),  & 
G1H4(211),G1H4(212),G1H4(213),G1H4(214),G1H4(215),G1H4(216),4)
call HG1shiftOLR(G1H4(212),16,4)
  call Hloop_AQ_V(ntryL,G2H8(41),ex1(:),G2H4(22),m3h2x4(:,110),heltab2x8(:,:,158))
  call Hloop_AQ_V(ntryL,G2H8(43),ex1(:),G2H4(23),m3h2x4(:,111),heltab2x8(:,:,159))
  call Hloop_AQ_V(ntryL,G2H8(44),ex1(:),G2H4(24),m3h2x4(:,112),heltab2x8(:,:,160))
call Hotf_5pt_reduction(G2H4(46),RedSet_5(11),mass5set(:,4),  & 
G1H4(217),G1H4(218),G1H4(219),G1H4(220),G1H4(221),G1H4(222),4)
call HG1shiftOLR(G1H4(218),16,4)
call Hotf_5pt_reduction(G2H4(49),RedSet_5(47),mass5set(:,3),  & 
G1H4(223),G1H4(224),G1H4(225),G1H4(226),G1H4(227),G1H4(228),4)
call HG1shiftOLR(G1H4(224),16,4)
call Hotf_5pt_reduction(G2H4(50),RedSet_5(48),mass5set(:,3),  & 
G1H4(229),G1H4(230),G1H4(231),G1H4(232),G1H4(233),G1H4(234),4)
call HG1shiftOLR(G1H4(230),16,4)
  call Hloop_QA_V(ntryL,G2H8(45),ex2(:),G2H4(25),m3h2x4(:,113),heltab2x8(:,:,161))
  call Hloop_QA_V(ntryL,G2H8(47),ex2(:),G2H4(26),m3h2x4(:,114),heltab2x8(:,:,162))
  call Hloop_QA_V(ntryL,G2H8(48),ex2(:),G2H4(29),m3h2x4(:,115),heltab2x8(:,:,163))
  call Hloop_QA_V(ntryL,G2H8(49),ex2(:),G2H4(32),m3h2x4(:,116),heltab2x8(:,:,164))
  call Hloop_QA_V(ntryL,G2H8(51),ex2(:),G2H4(33),m3h2x4(:,117),heltab2x8(:,:,165))
  call Hloop_QA_V(ntryL,G2H8(52),ex2(:),G2H4(35),m3h2x4(:,118),heltab2x8(:,:,166))
call Hotf_5pt_reduction(G2H8(53),RedSet_5(13),mass5set(:,4),  & 
G1H8(84),G1H8(13),G1H8(85),G1H8(37),G1H8(86),G1H8(39),8)
call HG1shiftOLR(G1H8(13),16,8)
call Hotf_5pt_reduction(G2H8(55),RedSet_5(49),mass5set(:,3),  & 
G1H8(87),G1H8(40),G1H8(88),G1H8(90),G1H8(41),G1H8(91),8)
call HG1shiftOLR(G1H8(40),16,8)
call Hotf_5pt_reduction(G2H8(56),RedSet_5(50),mass5set(:,3),  & 
G1H8(14),G1H8(92),G1H8(42),G1H8(93),G1H8(44),G1H8(94),8)
call HG1shiftOLR(G1H8(92),16,8)
call Hotf_5pt_reduction(G2H8(57),RedSet_5(14),mass5set(:,4),  & 
G1H8(96),G1H8(45),G1H8(97),G1H8(46),G1H8(98),G1H8(47),8)
call HG1shiftOLR(G1H8(45),8,8)
call Hotf_5pt_reduction(G2H8(59),RedSet_5(51),mass5set(:,3),  & 
G1H8(99),G1H8(25),G1H8(100),G1H8(102),G1H8(48),G1H8(103),8)
call HG1shiftOLR(G1H8(25),8,8)
call Hotf_5pt_reduction(G2H8(60),RedSet_5(52),mass5set(:,3),  & 
G1H8(50),G1H8(104),G1H8(1),G1H8(17),G1H8(18),G1H8(105),8)
call HG1shiftOLR(G1H8(104),8,8)
call Hotf_5pt_reduction(G2H8(61),RedSet_5(14),mass5set(:,4),  & 
G1H8(106),G1H8(107),G1H8(20),G1H8(108),G1H8(110),G1H8(111),8)
call HG1shiftOLR(G1H8(107),2,8)
call Hotf_5pt_reduction(G2H8(63),RedSet_5(53),mass5set(:,4),  & 
G1H8(112),G1H8(21),G1H8(113),G1H8(115),G1H8(116),G1H8(117),8)
call HG1shiftOLR(G1H8(21),2,8)
call Hotf_5pt_reduction(G2H8(64),RedSet_5(54),mass5set(:,4),  & 
G1H8(118),G1H8(119),G1H8(121),G1H8(122),G1H8(123),G1H8(22),8)
call HG1shiftOLR(G1H8(119),2,8)
call Hotf_5pt_reduction(G2H8(65),RedSet_5(13),mass5set(:,4),  & 
G1H8(23),G1H8(125),G1H8(126),G1H8(127),G1H8(24),G1H8(128),8)
call HG1shiftOLR(G1H8(125),2,8)
call Hotf_5pt_reduction(G2H8(67),RedSet_5(55),mass5set(:,4),  & 
G1H8(130),G1H8(131),G1H8(132),G1H8(134),G1H8(135),G1H8(136),8)
call HG1shiftOLR(G1H8(131),2,8)
call Hotf_5pt_reduction(G2H8(68),RedSet_5(54),mass5set(:,4),  & 
G1H8(137),G1H8(138),G1H8(139),G1H8(140),G1H8(141),G1H8(142),8)
call HG1shiftOLR(G1H8(138),2,8)
call Hotf_5pt_reduction(G2H8(69),RedSet_5(15),mass5set(:,4),  & 
G1H8(143),G1H8(144),G1H8(145),G1H8(146),G1H8(147),G1H8(148),8)
call HG1shiftOLR(G1H8(144),16,8)
call Hotf_5pt_reduction(G2H8(71),RedSet_5(47),mass5set(:,3),  & 
G1H8(149),G1H8(150),G1H8(151),G1H8(152),G1H8(153),G1H8(154),8)
call HG1shiftOLR(G1H8(150),16,8)
call Hotf_5pt_reduction(G2H8(72),RedSet_5(56),mass5set(:,3),  & 
G1H8(155),G1H8(156),G1H8(157),G1H8(158),G1H8(159),G1H8(160),8)
call HG1shiftOLR(G1H8(156),16,8)
call Hotf_5pt_reduction(G2H8(73),RedSet_5(16),mass5set(:,4),  & 
G1H8(161),G1H8(162),G1H8(163),G1H8(164),G1H8(165),G1H8(166),8)
call HG1shiftOLR(G1H8(162),8,8)
call Hotf_5pt_reduction(G2H8(75),RedSet_5(43),mass5set(:,3),  & 
G1H8(167),G1H8(168),G1H8(169),G1H8(170),G1H8(171),G1H8(172),8)
call HG1shiftOLR(G1H8(168),8,8)
call Hotf_5pt_reduction(G2H8(76),RedSet_5(57),mass5set(:,3),  & 
G1H8(173),G1H8(174),G1H8(175),G1H8(176),G1H8(177),G1H8(178),8)
call HG1shiftOLR(G1H8(174),8,8)
call Hotf_5pt_reduction(G2H4(57),RedSet_5(17),mass5set(:,4),  & 
G1H4(235),G1H4(236),G1H4(237),G1H4(238),G1H4(239),G1H4(240),4)
call HG1shiftOLR(G1H4(236),16,4)
call Hotf_5pt_reduction(G2H4(60),RedSet_5(49),mass5set(:,3),  & 
G1H4(241),G1H4(242),G1H4(243),G1H4(244),G1H4(245),G1H4(246),4)
call HG1shiftOLR(G1H4(242),16,4)
call Hotf_5pt_reduction(G2H4(61),RedSet_5(58),mass5set(:,3),  & 
G1H4(247),G1H4(248),G1H4(249),G1H4(250),G1H4(251),G1H4(252),4)
call HG1shiftOLR(G1H4(248),16,4)
call Hotf_5pt_reduction(G2H4(62),RedSet_5(18),mass5set(:,4),  & 
G1H4(253),G1H4(254),G1H4(255),G1H4(256),G1H4(257),G1H4(258),4)
call HG1shiftOLR(G1H4(254),2,4)
call Hotf_5pt_reduction(G2H4(64),RedSet_5(59),mass5set(:,4),  & 
G1H4(259),G1H4(260),G1H4(261),G1H4(262),G1H4(263),G1H4(264),4)
call HG1shiftOLR(G1H4(260),2,4)
call Hotf_5pt_reduction(G2H4(65),RedSet_5(60),mass5set(:,4),  & 
G1H4(265),G1H4(266),G1H4(267),G1H4(268),G1H4(269),G1H4(270),4)
call HG1shiftOLR(G1H4(266),2,4)
call Hotf_5pt_reduction(G2H4(66),RedSet_5(17),mass5set(:,4),  & 
G1H4(271),G1H4(272),G1H4(273),G1H4(274),G1H4(275),G1H4(276),4)
call HG1shiftOLR(G1H4(272),2,4)
call Hotf_5pt_reduction(G2H4(68),RedSet_5(55),mass5set(:,4),  & 
G1H4(277),G1H4(278),G1H4(279),G1H4(280),G1H4(281),G1H4(282),4)
call HG1shiftOLR(G1H4(278),2,4)
call Hotf_5pt_reduction(G2H4(69),RedSet_5(60),mass5set(:,4),  & 
G1H4(283),G1H4(284),G1H4(285),G1H4(286),G1H4(287),G1H4(288),4)
call HG1shiftOLR(G1H4(284),2,4)
call Hotf_5pt_reduction(G2H4(70),RedSet_5(19),mass5set(:,4),  & 
G1H4(289),G1H4(290),G1H4(291),G1H4(292),G1H4(293),G1H4(294),4)
call HG1shiftOLR(G1H4(290),8,4)
call Hotf_5pt_reduction(G2H4(73),RedSet_5(51),mass5set(:,3),  & 
G1H4(295),G1H4(296),G1H4(297),G1H4(298),G1H4(299),G1H4(300),4)
call HG1shiftOLR(G1H4(296),8,4)
call Hotf_5pt_reduction(G2H4(74),RedSet_5(61),mass5set(:,3),  & 
G1H4(301),G1H4(302),G1H4(303),G1H4(304),G1H4(305),G1H4(306),4)
call HG1shiftOLR(G1H4(302),8,4)
call Hotf_5pt_reduction(G2H4(75),RedSet_5(20),mass5set(:,4),  & 
G1H4(307),G1H4(308),G1H4(309),G1H4(310),G1H4(311),G1H4(312),4)
call HG1shiftOLR(G1H4(308),2,4)
call Hotf_5pt_reduction(G2H4(77),RedSet_5(59),mass5set(:,4),  & 
G1H4(313),G1H4(314),G1H4(315),G1H4(316),G1H4(317),G1H4(318),4)
call HG1shiftOLR(G1H4(314),2,4)
call Hotf_5pt_reduction(G2H4(78),RedSet_5(62),mass5set(:,4),  & 
G1H4(319),G1H4(320),G1H4(321),G1H4(322),G1H4(323),G1H4(324),4)
call HG1shiftOLR(G1H4(320),2,4)
call Hotf_5pt_reduction(G2H4(79),RedSet_5(19),mass5set(:,4),  & 
G1H4(325),G1H4(326),G1H4(327),G1H4(328),G1H4(329),G1H4(330),4)
call HG1shiftOLR(G1H4(326),2,4)
call Hotf_5pt_reduction(G2H4(81),RedSet_5(53),mass5set(:,4),  & 
G1H4(331),G1H4(332),G1H4(333),G1H4(334),G1H4(335),G1H4(336),4)
call HG1shiftOLR(G1H4(332),2,4)
call Hotf_5pt_reduction(G2H4(82),RedSet_5(62),mass5set(:,4),  & 
G1H4(337),G1H4(338),G1H4(339),G1H4(340),G1H4(341),G1H4(342),4)
call HG1shiftOLR(G1H4(338),2,4)
  call ol_merge(ntryL,G1H4(169),[G1H4(167)])
  call ol_merge(ntryL,G1H4(175),[G1H4(168)])
  call ol_merge(ntryL,G1H4(187),[G1H4(185)])
  call ol_merge(ntryL,G1H4(193),[G1H4(186)])
  call ol_merge(ntryL,G1H4(205),[G1H4(203)])
  call ol_merge(ntryL,G1H4(211),[G1H4(204)])
  call ol_merge(ntryL,G1H4(223),[G1H4(221)])
  call ol_merge(ntryL,G1H4(229),[G1H4(222)])
  call ol_merge(ntryL,G1H8(87),[G1H8(86)])
  call ol_merge(ntryL,G1H8(14),[G1H8(39)])
  call ol_merge(ntryL,G1H8(99),[G1H8(98)])
  call ol_merge(ntryL,G1H8(50),[G1H8(47)])
  call ol_merge(ntryL,G1H8(112),[G1H8(110)])
  call ol_merge(ntryL,G1H8(118),[G1H8(111)])
  call ol_merge(ntryL,G1H8(130),[G1H8(24)])
  call ol_merge(ntryL,G1H8(137),[G1H8(128)])
  call ol_merge(ntryL,G1H8(149),[G1H8(147)])
  call ol_merge(ntryL,G1H8(155),[G1H8(148)])
  call ol_merge(ntryL,G1H8(167),[G1H8(165)])
  call ol_merge(ntryL,G1H8(173),[G1H8(166)])
  call ol_merge(ntryL,G1H4(241),[G1H4(239)])
  call ol_merge(ntryL,G1H4(247),[G1H4(240)])
  call ol_merge(ntryL,G1H4(259),[G1H4(257)])
  call ol_merge(ntryL,G1H4(265),[G1H4(258)])
  call ol_merge(ntryL,G1H4(277),[G1H4(275)])
  call ol_merge(ntryL,G1H4(283),[G1H4(276)])
  call ol_merge(ntryL,G1H4(295),[G1H4(293)])
  call ol_merge(ntryL,G1H4(301),[G1H4(294)])
  call ol_merge(ntryL,G1H4(313),[G1H4(311)])
  call ol_merge(ntryL,G1H4(319),[G1H4(312)])
  call ol_merge(ntryL,G1H4(331),[G1H4(329)])
  call ol_merge(ntryL,G1H4(337),[G1H4(330)])
  call Hloop_VQ_A(ntryL,G1H4(7),ex1(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),43,nMT,G2H2(1),n2h2(1))
call HGT_OLR(G1H4(8),1,1,4)
call HGT_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(8),-16,nMT,G2H4(38),n2h4(53))
  call Hloop_AV_Q(ntryL,G2H4(38),ex5(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_VQ_A(ntryL,G1H4(11),ex1(:),G1H2(1),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(1),43,nMT,G2H2(3),n2h2(2))
  call Hloop_VQ_A(ntryL,G1H4(12),ex1(:),G1H2(1),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_Q_A(ntryL,G1H2(1),43,nMT,G2H2(4),n2h2(3))
  call Hloop_VA_Q(ntryL,G1H8(51),ex2(:),G1H4(167),m3h2x4(:,119),heltab2x8(:,:,167))
  call Hloop_A_Q(ntryL,G1H4(167),39,nMT,G2H4(39),n2h4(54))
call HGT_OLR(G1H8(29),1,1,8)
call HGT_invQ_OLR(G1H8(29),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(29),-16,nMT,G2H8(1),n2h8(109))
  call Hloop_QV_A(ntryL,G2H8(1),ex5(:),G2H4(40),m3h2x4(:,120),heltab2x8(:,:,168))
  call Hloop_VA_Q(ntryL,G1H8(53),ex2(:),G1H4(168),m3h2x4(:,121),heltab2x8(:,:,169))
  call Hloop_A_Q(ntryL,G1H4(168),39,nMT,G2H4(43),n2h4(55))
  call Hloop_VA_Q(ntryL,G1H8(54),ex2(:),G1H4(185),m3h2x4(:,122),heltab2x8(:,:,170))
  call Hloop_A_Q(ntryL,G1H4(185),39,nMT,G2H4(44),n2h4(56))
  call Hloop_VA_Q(ntryL,G1H8(56),ex2(:),G1H4(186),m3h2x4(:,123),heltab2x8(:,:,171))
  call Hloop_A_Q(ntryL,G1H4(186),39,nMT,G2H4(46),n2h4(57))
call HGT_OLR(G1H8(57),1,1,8)
call HGT_invQ_OLR(G1H8(57),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(57),-8,nMT,G2H8(2),n2h8(110))
  call Hloop_QV_A(ntryL,G2H8(2),ex4(:),G2H4(49),m3h2x4(:,124),heltab2x8(:,:,172))
  call Hloop_VA_Q(ntryL,G1H8(4),ex2(:),G1H4(203),m3h2x4(:,125),heltab2x8(:,:,173))
  call Hloop_A_Q(ntryL,G1H4(203),39,nMT,G2H4(50),n2h4(58))
  call Hloop_VA_Q(ntryL,G1H8(16),ex2(:),G1H4(204),m3h2x4(:,126),heltab2x8(:,:,174))
  call Hloop_A_Q(ntryL,G1H4(204),39,nMT,G2H4(57),n2h4(59))
  call Hloop_QS_A(ntryL,G1H4(13),ex3(:),G1H4(221),ngH,m3h1x4(:,1),heltab2x4(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(221),39,nMT,G2H4(60),n2h4(60))
call HGT_OLR(G1H4(14),1,1,4)
call HGT_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(14),-16,nMT,G2H4(61),n2h4(61))
  call Hloop_AV_Q(ntryL,G2H4(61),ex5(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,6))
  call Hloop_QS_A(ntryL,G1H4(17),ex3(:),G1H4(222),ngH,m3h1x4(:,2),heltab2x4(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(222),39,nMT,G2H4(62),n2h4(62))
  call Hloop_QS_A(ntryL,G1H4(18),ex3(:),G1H4(239),ngH,m3h1x4(:,3),heltab2x4(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(239),39,nMT,G2H4(64),n2h4(63))
  call Hloop_QS_A(ntryL,G1H4(19),ex3(:),G1H4(240),ngH,m3h1x4(:,4),heltab2x4(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(240),39,nMT,G2H4(65),n2h4(64))
call HGT_OLR(G1H4(20),1,1,4)
call HGT_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(20),-8,nMT,G2H4(66),n2h4(65))
  call Hloop_AV_Q(ntryL,G2H4(66),ex4(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,10))
  call Hloop_QS_A(ntryL,G1H4(23),ex3(:),G1H4(257),ngH,m3h1x4(:,5),heltab2x4(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(257),39,nMT,G2H4(68),n2h4(66))
  call Hloop_QS_A(ntryL,G1H4(24),ex3(:),G1H4(258),ngH,m3h1x4(:,6),heltab2x4(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(258),39,nMT,G2H4(69),n2h4(67))
  call Hloop_VA_Q(ntryL,G1H4(25),ex2(:),G1H2(1),m3h2x2(:,7),heltab2x4(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(1),43,nMT,G2H2(7),n2h2(4))
call HGT_OLR(G1H4(26),1,1,4)
call HGT_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(26),-16,nMT,G2H4(70),n2h4(68))
  call Hloop_QV_A(ntryL,G2H4(70),ex5(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,14))
  call Hloop_VA_Q(ntryL,G1H4(29),ex2(:),G1H2(1),m3h2x2(:,9),heltab2x4(:,:,15))
  call Hloop_A_Q(ntryL,G1H2(1),43,nMT,G2H2(9),n2h2(5))
  call Hloop_VA_Q(ntryL,G1H4(30),ex2(:),G1H2(1),m3h2x2(:,10),heltab2x4(:,:,16))
  call Hloop_A_Q(ntryL,G1H2(1),43,nMT,G2H2(10),n2h2(6))
  call Hloop_VQ_A(ntryL,G1H8(60),ex1(:),G1H4(275),m3h2x4(:,127),heltab2x8(:,:,175))
  call Hloop_Q_A(ntryL,G1H4(275),39,nMT,G2H4(73),n2h4(69))
call HGT_OLR(G1H8(133),1,1,8)
call HGT_invQ_OLR(G1H8(133),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(133),-16,nMT,G2H8(3),n2h8(111))
  call Hloop_AV_Q(ntryL,G2H8(3),ex5(:),G2H4(74),m3h2x4(:,128),heltab2x8(:,:,176))
  call Hloop_VQ_A(ntryL,G1H8(62),ex1(:),G1H4(276),m3h2x4(:,129),heltab2x8(:,:,177))
  call Hloop_Q_A(ntryL,G1H4(276),39,nMT,G2H4(75),n2h4(70))
  call Hloop_VQ_A(ntryL,G1H8(5),ex1(:),G1H4(293),m3h2x4(:,130),heltab2x8(:,:,178))
  call Hloop_Q_A(ntryL,G1H4(293),39,nMT,G2H4(77),n2h4(71))
  call Hloop_QV_A(ntryL,G1H4(31),ex4(:),G1H2(1),m3h2x2(:,11),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(1),43,nMT,G2H2(11),n2h2(7))
call HGT_OLR(G1H4(32),1,1,4)
call HGT_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(32),-16,nMT,G2H4(78),n2h4(72))
  call Hloop_AV_Q(ntryL,G2H4(78),ex5(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,18))
  call Hloop_QV_A(ntryL,G1H4(35),ex4(:),G1H2(1),m3h2x2(:,13),heltab2x4(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(1),43,nMT,G2H2(13),n2h2(8))
  call Hloop_QV_A(ntryL,G1H4(36),ex4(:),G1H2(1),m3h2x2(:,14),heltab2x4(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(1),43,nMT,G2H2(14),n2h2(9))
  call Hloop_QV_A(ntryL,G1H4(37),ex4(:),G1H2(1),m3h2x2(:,15),heltab2x4(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(1),43,nMT,G2H2(15),n2h2(10))
call HGT_OLR(G1H4(38),1,1,4)
call HGT_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(38),-4,nMT,G2H4(79),n2h4(73))
  call Hloop_AS_Q(ntryL,G2H4(79),ex3(:),G2H4(81),ngH,m3h1x4(:,7),heltab2x4(:,:,22))
  call Hloop_QV_A(ntryL,G1H4(41),ex4(:),G1H2(1),m3h2x2(:,16),heltab2x4(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(1),43,nMT,G2H2(16),n2h2(11))
  call Hloop_QV_A(ntryL,G1H4(42),ex4(:),G1H2(1),m3h2x2(:,17),heltab2x4(:,:,24))
  call Hloop_Q_A(ntryL,G1H2(1),43,nMT,G2H2(17),n2h2(12))
  call Hloop_VQ_A(ntryL,G1H8(63),ex1(:),G1H4(294),m3h2x4(:,131),heltab2x8(:,:,179))
  call Hloop_Q_A(ntryL,G1H4(294),39,nMT,G2H4(82),n2h4(74))
call HGT_OLR(G1H8(6),1,1,8)
call HGT_invQ_OLR(G1H8(6),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(6),-8,nMT,G2H8(4),n2h8(112))
  call Hloop_AV_Q(ntryL,G2H8(4),ex4(:),G2H4(38),m3h2x4(:,132),heltab2x8(:,:,180))
  call Hloop_VQ_A(ntryL,G1H8(8),ex1(:),G1H4(311),m3h2x4(:,133),heltab2x8(:,:,181))
  call Hloop_Q_A(ntryL,G1H4(311),39,nMT,G2H4(61),n2h4(75))
  call Hloop_VQ_A(ntryL,G1H8(67),ex1(:),G1H4(312),m3h2x4(:,134),heltab2x8(:,:,182))
  call Hloop_Q_A(ntryL,G1H4(312),39,nMT,G2H4(66),n2h4(76))
  call Hloop_QV_A(ntryL,G1H4(43),ex5(:),G1H2(1),m3h2x2(:,18),heltab2x4(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(1),51,nMT,G2H2(18),n2h2(13))
call HGT_OLR(G1H4(44),1,1,4)
call HGT_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(44),-8,nMT,G2H4(70),n2h4(77))
  call Hloop_AV_Q(ntryL,G2H4(70),ex4(:),G2H2(19),m3h2x2(:,19),heltab2x4(:,:,26))
  call Hloop_QV_A(ntryL,G1H4(47),ex5(:),G1H2(1),m3h2x2(:,20),heltab2x4(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(1),51,nMT,G2H2(20),n2h2(14))
  call Hloop_QV_A(ntryL,G1H4(48),ex5(:),G1H2(1),m3h2x2(:,21),heltab2x4(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(1),51,nMT,G2H2(21),n2h2(15))
  call Hloop_QV_A(ntryL,G1H4(49),ex5(:),G1H2(1),m3h2x2(:,22),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(1),51,nMT,G2H2(22),n2h2(16))
call HGT_OLR(G1H4(50),1,1,4)
call HGT_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(50),-4,nMT,G2H4(78),n2h4(78))
  call Hloop_AS_Q(ntryL,G2H4(78),ex3(:),G2H4(79),ngH,m3h1x4(:,8),heltab2x4(:,:,30))
  call Hloop_QV_A(ntryL,G1H4(53),ex5(:),G1H2(1),m3h2x2(:,23),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(1),51,nMT,G2H2(23),n2h2(17))
  call Hloop_QV_A(ntryL,G1H4(54),ex5(:),G1H2(1),m3h2x2(:,24),heltab2x4(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(1),51,nMT,G2H2(24),n2h2(18))
  call Hloop_AS_Q(ntryL,G1H4(55),ex3(:),G1H4(329),ngH,m3h1x4(:,9),heltab2x4(:,:,33))
  call Hloop_A_Q(ntryL,G1H4(329),39,nMT,G2H4(70),n2h4(79))
call HGT_OLR(G1H4(56),1,1,4)
call HGT_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(56),-16,nMT,G2H4(78),n2h4(80))
  call Hloop_QV_A(ntryL,G2H4(78),ex5(:),G2H2(25),m3h2x2(:,25),heltab2x4(:,:,34))
  call Hloop_AS_Q(ntryL,G1H4(59),ex3(:),G1H4(330),ngH,m3h1x4(:,10),heltab2x4(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(330),39,nMT,G2H4(78),n2h4(81))
  call Hloop_AS_Q(ntryL,G1H4(60),ex3(:),G1H4(7),ngH,m3h1x4(:,11),heltab2x4(:,:,36))
  call Hloop_A_Q(ntryL,G1H4(7),39,nMT,G2H4(83),n2h4(82))
  call Hloop_AS_Q(ntryL,G1H4(61),ex3(:),G1H4(8),ngH,m3h1x4(:,12),heltab2x4(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(8),39,nMT,G2H4(84),n2h4(83))
call HGT_OLR(G1H4(62),1,1,4)
call HGT_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(62),-8,nMT,G2H4(85),n2h4(84))
  call Hloop_QV_A(ntryL,G2H4(85),ex4(:),G2H2(26),m3h2x2(:,26),heltab2x4(:,:,38))
  call Hloop_AS_Q(ntryL,G1H4(65),ex3(:),G1H4(11),ngH,m3h1x4(:,13),heltab2x4(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(11),39,nMT,G2H4(85),n2h4(85))
  call Hloop_AS_Q(ntryL,G1H4(66),ex3(:),G1H4(12),ngH,m3h1x4(:,14),heltab2x4(:,:,40))
  call Hloop_A_Q(ntryL,G1H4(12),39,nMT,G2H4(86),n2h4(86))
  call Hloop_AV_Q(ntryL,G1H4(67),ex4(:),G1H2(1),m3h2x2(:,27),heltab2x4(:,:,41))
  call Hloop_A_Q(ntryL,G1H2(1),43,nMT,G2H2(27),n2h2(19))
call HGT_OLR(G1H4(68),1,1,4)
call HGT_invQ_OLR(G1H4(68),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(68),-16,nMT,G2H4(87),n2h4(87))
  call Hloop_QV_A(ntryL,G2H4(87),ex5(:),G2H2(28),m3h2x2(:,28),heltab2x4(:,:,42))
  call Hloop_AV_Q(ntryL,G1H4(71),ex4(:),G1H2(1),m3h2x2(:,29),heltab2x4(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(1),43,nMT,G2H2(29),n2h2(20))
  call Hloop_AV_Q(ntryL,G1H4(72),ex4(:),G1H2(1),m3h2x2(:,30),heltab2x4(:,:,44))
  call Hloop_A_Q(ntryL,G1H2(1),43,nMT,G2H2(30),n2h2(21))
  call Hloop_AV_Q(ntryL,G1H4(73),ex4(:),G1H2(1),m3h2x2(:,31),heltab2x4(:,:,45))
  call Hloop_A_Q(ntryL,G1H2(1),43,nMT,G2H2(31),n2h2(22))
call HGT_OLR(G1H4(74),1,1,4)
call HGT_invQ_OLR(G1H4(74),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(74),-4,nMT,G2H4(87),n2h4(88))
  call Hloop_QS_A(ntryL,G2H4(87),ex3(:),G2H4(88),ngH,m3h1x4(:,15),heltab2x4(:,:,46))
  call Hloop_AV_Q(ntryL,G1H4(77),ex4(:),G1H2(1),m3h2x2(:,32),heltab2x4(:,:,47))
  call Hloop_A_Q(ntryL,G1H2(1),43,nMT,G2H2(32),n2h2(23))
  call Hloop_AV_Q(ntryL,G1H4(78),ex4(:),G1H2(1),m3h2x2(:,33),heltab2x4(:,:,48))
  call Hloop_A_Q(ntryL,G1H2(1),43,nMT,G2H2(33),n2h2(24))
  call Hloop_AV_Q(ntryL,G1H4(79),ex5(:),G1H2(1),m3h2x2(:,34),heltab2x4(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(1),51,nMT,G2H2(34),n2h2(25))
call HGT_OLR(G1H4(80),1,1,4)
call HGT_invQ_OLR(G1H4(80),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(80),-8,nMT,G2H4(87),n2h4(89))
  call Hloop_QV_A(ntryL,G2H4(87),ex4(:),G2H2(35),m3h2x2(:,35),heltab2x4(:,:,50))
  call Hloop_AV_Q(ntryL,G1H4(83),ex5(:),G1H2(1),m3h2x2(:,36),heltab2x4(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(1),51,nMT,G2H2(36),n2h2(26))
  call Hloop_AV_Q(ntryL,G1H4(84),ex5(:),G1H2(1),m3h2x2(:,37),heltab2x4(:,:,52))
  call Hloop_A_Q(ntryL,G1H2(1),51,nMT,G2H2(37),n2h2(27))
  call Hloop_AV_Q(ntryL,G1H4(85),ex5(:),G1H2(1),m3h2x2(:,38),heltab2x4(:,:,53))
  call Hloop_A_Q(ntryL,G1H2(1),51,nMT,G2H2(38),n2h2(28))
call HGT_OLR(G1H4(86),1,1,4)
call HGT_invQ_OLR(G1H4(86),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(86),-4,nMT,G2H4(87),n2h4(90))
  call Hloop_QS_A(ntryL,G2H4(87),ex3(:),G2H4(89),ngH,m3h1x4(:,16),heltab2x4(:,:,54))
  call Hloop_AV_Q(ntryL,G1H4(89),ex5(:),G1H2(1),m3h2x2(:,39),heltab2x4(:,:,55))
  call Hloop_A_Q(ntryL,G1H2(1),51,nMT,G2H2(39),n2h2(29))
  call Hloop_AV_Q(ntryL,G1H4(90),ex5(:),G1H2(1),m3h2x2(:,40),heltab2x4(:,:,56))
  call Hloop_A_Q(ntryL,G1H2(1),51,nMT,G2H2(40),n2h2(30))
  call Hloop_UV_W(ntryL,G1H8(9),37,ex4(:),8,G2H4(87),m3h2x4(:,135),heltab2x8(:,:,183))
call HGT_OLR(G1H8(68),1,1,8)
call HGT_invQ_OLR(G1H8(68),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(68),-16,nMT,G2H8(5),n2h8(113))
  call Hloop_QV_A(ntryL,G2H8(5),ex5(:),G2H4(90),m3h2x4(:,136),heltab2x8(:,:,184))
  call Hloop_UV_W(ntryL,G1H8(11),37,ex4(:),8,G2H4(91),m3h2x4(:,137),heltab2x8(:,:,185))
  call Hloop_UV_W(ntryL,G1H8(70),37,ex4(:),8,G2H4(92),m3h2x4(:,138),heltab2x8(:,:,186))
  call Hloop_VQ_A(ntryL,G1H4(91),ex1(:),G1H2(1),m3h2x2(:,41),heltab2x4(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(1),43,nMT,G2H2(41),n2h2(31))
call HGT_OLR(G1H4(92),1,1,4)
call HGT_invQ_OLR(G1H4(92),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(92),-16,nMT,G2H4(93),n2h4(91))
  call Hloop_AV_Q(ntryL,G2H4(93),ex5(:),G2H2(42),m3h2x2(:,42),heltab2x4(:,:,58))
  call Hloop_VQ_A(ntryL,G1H4(95),ex1(:),G1H2(1),m3h2x2(:,43),heltab2x4(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(1),43,nMT,G2H2(43),n2h2(32))
  call Hloop_VQ_A(ntryL,G1H4(96),ex1(:),G1H2(1),m3h2x2(:,44),heltab2x4(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(1),43,nMT,G2H2(44),n2h2(33))
  call Hloop_UV_W(ntryL,G1H4(97),50,ex4(:),8,G2H2(45),m3h2x2(:,45),heltab2x4(:,:,61))
call HGT_OLR(G1H4(98),1,1,4)
call HGT_invQ_OLR(G1H4(98),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(98),-4,nMT,G2H4(93),n2h4(92))
  call Hloop_AS_Q(ntryL,G2H4(93),ex3(:),G2H4(94),ngH,m3h1x4(:,17),heltab2x4(:,:,62))
  call Hloop_UV_W(ntryL,G1H4(101),50,ex4(:),8,G2H2(46),m3h2x2(:,46),heltab2x4(:,:,63))
  call Hloop_UV_W(ntryL,G1H4(102),50,ex4(:),8,G2H2(47),m3h2x2(:,47),heltab2x4(:,:,64))
  call Hloop_UV_W(ntryL,G1H8(72),37,ex5(:),16,G2H4(93),m3h2x4(:,139),heltab2x8(:,:,187))
call HGT_OLR(G1H8(30),1,1,8)
call HGT_invQ_OLR(G1H8(30),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(30),-8,nMT,G2H8(6),n2h8(114))
  call Hloop_QV_A(ntryL,G2H8(6),ex4(:),G2H4(95),m3h2x4(:,140),heltab2x8(:,:,188))
  call Hloop_UV_W(ntryL,G1H8(74),37,ex5(:),16,G2H4(96),m3h2x4(:,141),heltab2x8(:,:,189))
  call Hloop_UV_W(ntryL,G1H8(34),37,ex5(:),16,G2H4(97),m3h2x4(:,142),heltab2x8(:,:,190))
  call Hloop_UV_W(ntryL,G1H4(103),42,ex5(:),16,G2H2(48),m3h2x2(:,48),heltab2x4(:,:,65))
call HGT_OLR(G1H4(104),1,1,4)
call HGT_invQ_OLR(G1H4(104),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(104),-4,nMT,G2H4(98),n2h4(93))
  call Hloop_AS_Q(ntryL,G2H4(98),ex3(:),G2H4(99),ngH,m3h1x4(:,18),heltab2x4(:,:,66))
  call Hloop_UV_W(ntryL,G1H4(107),42,ex5(:),16,G2H2(49),m3h2x2(:,49),heltab2x4(:,:,67))
  call Hloop_UV_W(ntryL,G1H4(108),42,ex5(:),16,G2H2(50),m3h2x2(:,50),heltab2x4(:,:,68))
  call Hloop_VQ_A(ntryL,G1H4(109),ex1(:),G1H2(1),m3h2x2(:,51),heltab2x4(:,:,69))
  call Hloop_Q_A(ntryL,G1H2(1),51,nMT,G2H2(51),n2h2(34))
call HGT_OLR(G1H4(110),1,1,4)
call HGT_invQ_OLR(G1H4(110),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(110),-8,nMT,G2H4(98),n2h4(94))
  call Hloop_AV_Q(ntryL,G2H4(98),ex4(:),G2H2(52),m3h2x2(:,52),heltab2x4(:,:,70))
  call Hloop_VQ_A(ntryL,G1H4(113),ex1(:),G1H2(1),m3h2x2(:,53),heltab2x4(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(1),51,nMT,G2H2(53),n2h2(35))
  call Hloop_VQ_A(ntryL,G1H4(114),ex1(:),G1H2(1),m3h2x2(:,54),heltab2x4(:,:,72))
  call Hloop_Q_A(ntryL,G1H2(1),51,nMT,G2H2(54),n2h2(36))
  call Hloop_UV_W(ntryL,G1H8(75),38,ex4(:),8,G2H4(98),m3h2x4(:,143),heltab2x8(:,:,191))
call HGT_OLR(G1H8(32),1,1,8)
call HGT_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(32),-16,nMT,G2H8(7),n2h8(115))
  call Hloop_AV_Q(ntryL,G2H8(7),ex5(:),G2H4(100),m3h2x4(:,144),heltab2x8(:,:,192))
  call Hloop_UV_W(ntryL,G1H8(35),38,ex4(:),8,G2H4(101),m3h2x4(:,145),heltab2x8(:,:,193))
  call Hloop_UV_W(ntryL,G1H8(79),38,ex4(:),8,G2H4(102),m3h2x4(:,146),heltab2x8(:,:,194))
  call Hloop_UV_W(ntryL,G1H8(26),38,ex5(:),16,G2H4(103),m3h2x4(:,147),heltab2x8(:,:,195))
call HGT_OLR(G1H8(80),1,1,8)
call HGT_invQ_OLR(G1H8(80),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(80),-8,nMT,G2H8(8),n2h8(116))
  call Hloop_AV_Q(ntryL,G2H8(8),ex4(:),G2H4(104),m3h2x4(:,148),heltab2x8(:,:,196))
  call Hloop_UV_W(ntryL,G1H8(28),38,ex5(:),16,G2H4(105),m3h2x4(:,149),heltab2x8(:,:,197))
  call Hloop_UV_W(ntryL,G1H8(82),38,ex5(:),16,G2H4(106),m3h2x4(:,150),heltab2x8(:,:,198))
  call Hloop_VQ_A(ntryL,G1H4(115),ex1(:),G1H2(1),m3h2x2(:,55),heltab2x4(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(1),43,nMT,G2H2(55),n2h2(37))
call HGT_OLR(G1H4(116),1,1,4)
call HGT_invQ_OLR(G1H4(116),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(116),-4,nMT,G2H4(107),n2h4(95))
  call Hloop_AS_Q(ntryL,G2H4(107),ex3(:),G2H4(108),ngH,m3h1x4(:,19),heltab2x4(:,:,74))
  call Hloop_VQ_A(ntryL,G1H4(119),ex1(:),G1H2(1),m3h2x2(:,56),heltab2x4(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(1),43,nMT,G2H2(56),n2h2(38))
  call Hloop_VQ_A(ntryL,G1H4(120),ex1(:),G1H2(1),m3h2x2(:,57),heltab2x4(:,:,76))
  call Hloop_Q_A(ntryL,G1H2(1),43,nMT,G2H2(57),n2h2(39))
  call Hloop_VQ_A(ntryL,G1H4(121),ex1(:),G1H2(1),m3h2x2(:,58),heltab2x4(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(1),51,nMT,G2H2(58),n2h2(40))
call HGT_OLR(G1H4(122),1,1,4)
call HGT_invQ_OLR(G1H4(122),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(122),-4,nMT,G2H4(107),n2h4(96))
  call Hloop_AS_Q(ntryL,G2H4(107),ex3(:),G2H4(109),ngH,m3h1x4(:,20),heltab2x4(:,:,78))
  call Hloop_VQ_A(ntryL,G1H4(125),ex1(:),G1H2(1),m3h2x2(:,59),heltab2x4(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(1),51,nMT,G2H2(59),n2h2(41))
  call Hloop_VQ_A(ntryL,G1H4(126),ex1(:),G1H2(1),m3h2x2(:,60),heltab2x4(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(1),51,nMT,G2H2(60),n2h2(42))
  call Hloop_VA_Q(ntryL,G1H4(127),ex2(:),G1H2(1),m3h2x2(:,61),heltab2x4(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(1),43,nMT,G2H2(61),n2h2(43))
call HGT_OLR(G1H4(128),1,1,4)
call HGT_invQ_OLR(G1H4(128),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(128),-16,nMT,G2H4(107),n2h4(97))
  call Hloop_QV_A(ntryL,G2H4(107),ex5(:),G2H2(62),m3h2x2(:,62),heltab2x4(:,:,82))
  call Hloop_VA_Q(ntryL,G1H4(131),ex2(:),G1H2(1),m3h2x2(:,63),heltab2x4(:,:,83))
  call Hloop_A_Q(ntryL,G1H2(1),43,nMT,G2H2(63),n2h2(44))
  call Hloop_VA_Q(ntryL,G1H4(132),ex2(:),G1H2(1),m3h2x2(:,64),heltab2x4(:,:,84))
  call Hloop_A_Q(ntryL,G1H2(1),43,nMT,G2H2(64),n2h2(45))
  call Hloop_UV_W(ntryL,G1H4(133),41,ex5(:),16,G2H2(65),m3h2x2(:,65),heltab2x4(:,:,85))
call HGT_OLR(G1H4(134),1,1,4)
call HGT_invQ_OLR(G1H4(134),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(134),-4,nMT,G2H4(107),n2h4(98))
  call Hloop_QS_A(ntryL,G2H4(107),ex3(:),G2H4(110),ngH,m3h1x4(:,21),heltab2x4(:,:,86))
  call Hloop_UV_W(ntryL,G1H4(137),41,ex5(:),16,G2H2(66),m3h2x2(:,66),heltab2x4(:,:,87))
  call Hloop_UV_W(ntryL,G1H4(138),41,ex5(:),16,G2H2(67),m3h2x2(:,67),heltab2x4(:,:,88))
  call Hloop_VA_Q(ntryL,G1H4(139),ex2(:),G1H2(1),m3h2x2(:,68),heltab2x4(:,:,89))
  call Hloop_A_Q(ntryL,G1H2(1),43,nMT,G2H2(68),n2h2(46))
call HGT_OLR(G1H4(140),1,1,4)
call HGT_invQ_OLR(G1H4(140),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(140),-4,nMT,G2H4(107),n2h4(99))
  call Hloop_QS_A(ntryL,G2H4(107),ex3(:),G2H4(111),ngH,m3h1x4(:,22),heltab2x4(:,:,90))
  call Hloop_VA_Q(ntryL,G1H4(143),ex2(:),G1H2(1),m3h2x2(:,69),heltab2x4(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(1),43,nMT,G2H2(69),n2h2(47))
  call Hloop_VA_Q(ntryL,G1H4(144),ex2(:),G1H2(1),m3h2x2(:,70),heltab2x4(:,:,92))
  call Hloop_A_Q(ntryL,G1H2(1),43,nMT,G2H2(70),n2h2(48))
  call Hloop_UV_W(ntryL,G1H4(145),49,ex4(:),8,G2H2(71),m3h2x2(:,71),heltab2x4(:,:,93))
call HGT_OLR(G1H4(146),1,1,4)
call HGT_invQ_OLR(G1H4(146),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(146),-4,nMT,G2H4(107),n2h4(100))
  call Hloop_QS_A(ntryL,G2H4(107),ex3(:),G2H4(112),ngH,m3h1x4(:,23),heltab2x4(:,:,94))
  call Hloop_UV_W(ntryL,G1H4(149),49,ex4(:),8,G2H2(72),m3h2x2(:,72),heltab2x4(:,:,95))
  call Hloop_UV_W(ntryL,G1H4(150),49,ex4(:),8,G2H2(73),m3h2x2(:,73),heltab2x4(:,:,96))
  call Hloop_VA_Q(ntryL,G1H4(151),ex2(:),G1H2(1),m3h2x2(:,74),heltab2x4(:,:,97))
  call Hloop_A_Q(ntryL,G1H2(1),51,nMT,G2H2(74),n2h2(49))
call HGT_OLR(G1H4(152),1,1,4)
call HGT_invQ_OLR(G1H4(152),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(152),-8,nMT,G2H4(107),n2h4(101))
  call Hloop_QV_A(ntryL,G2H4(107),ex4(:),G2H2(75),m3h2x2(:,75),heltab2x4(:,:,98))
  call Hloop_VA_Q(ntryL,G1H4(155),ex2(:),G1H2(1),m3h2x2(:,76),heltab2x4(:,:,99))
  call Hloop_A_Q(ntryL,G1H2(1),51,nMT,G2H2(76),n2h2(50))
  call Hloop_VA_Q(ntryL,G1H4(156),ex2(:),G1H2(1),m3h2x2(:,77),heltab2x4(:,:,100))
  call Hloop_A_Q(ntryL,G1H2(1),51,nMT,G2H2(77),n2h2(51))
  call Hloop_VA_Q(ntryL,G1H4(157),ex2(:),G1H2(1),m3h2x2(:,78),heltab2x4(:,:,101))
  call Hloop_A_Q(ntryL,G1H2(1),51,nMT,G2H2(78),n2h2(52))
call HGT_OLR(G1H4(158),1,1,4)
call HGT_invQ_OLR(G1H4(158),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(158),-4,nMT,G2H4(107),n2h4(102))
  call Hloop_QS_A(ntryL,G2H4(107),ex3(:),G2H4(113),ngH,m3h1x4(:,24),heltab2x4(:,:,102))
  call Hloop_VA_Q(ntryL,G1H4(161),ex2(:),G1H2(1),m3h2x2(:,79),heltab2x4(:,:,103))
  call Hloop_A_Q(ntryL,G1H2(1),51,nMT,G2H2(79),n2h2(53))
  call Hloop_VA_Q(ntryL,G1H4(162),ex2(:),G1H2(1),m3h2x2(:,80),heltab2x4(:,:,104))
  call Hloop_A_Q(ntryL,G1H2(1),51,nMT,G2H2(80),n2h2(54))
  call Hloop_QS_A(ntryL,G1H4(163),ex3(:),G1H4(167),ngH,m3h1x4(:,25),heltab2x4(:,:,105))
  call Hloop_Q_A(ntryL,G1H4(167),45,nMT,G2H4(107),n2h4(103))
call HGT_raise_alpha_OLR(G1H4(164),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(164),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(164),-16,ex5(:),16,G2H2(81),m3h2x2(:,81),heltab2x4(:,:,106))
call signflip_OLR(G2H2(81))
  call Hloop_QS_A(ntryL,G1H4(169),ex3(:),G1H4(168),ngH,m3h1x4(:,26),heltab2x4(:,:,107))
  call Hloop_Q_A(ntryL,G1H4(168),45,nMT,G2H4(114),n2h4(105))
  call Hloop_QS_A(ntryL,G1H4(175),ex3(:),G1H4(185),ngH,m3h1x4(:,27),heltab2x4(:,:,108))
  call Hloop_Q_A(ntryL,G1H4(185),45,nMT,G2H4(115),n2h4(106))
call HGT_raise_alpha_OLR(G1H4(170),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(170),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(170),-16,ex5(:),16,G2H2(82),m3h2x2(:,82),heltab2x4(:,:,109))
call signflip_OLR(G2H2(82))
  call Hloop_QS_A(ntryL,G1H4(173),ex3(:),G1H4(186),ngH,m3h1x4(:,28),heltab2x4(:,:,110))
  call Hloop_Q_A(ntryL,G1H4(186),45,nMT,G2H4(116),n2h4(108))
  call Hloop_QS_A(ntryL,G1H4(174),ex3(:),G1H4(203),ngH,m3h1x4(:,29),heltab2x4(:,:,111))
  call Hloop_Q_A(ntryL,G1H4(203),45,nMT,G2H4(117),n2h4(109))
call HGT_raise_alpha_OLR(G1H4(176),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(176),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(176),-16,ex5(:),16,G2H2(83),m3h2x2(:,83),heltab2x4(:,:,112))
call signflip_OLR(G2H2(83))
  call Hloop_QS_A(ntryL,G1H4(179),ex3(:),G1H4(204),ngH,m3h1x4(:,30),heltab2x4(:,:,113))
  call Hloop_Q_A(ntryL,G1H4(204),45,nMT,G2H4(118),n2h4(111))
  call Hloop_QS_A(ntryL,G1H4(180),ex3(:),G1H4(13),ngH,m3h1x4(:,31),heltab2x4(:,:,114))
  call Hloop_Q_A(ntryL,G1H4(13),45,nMT,G2H4(119),n2h4(112))
  call Hloop_AS_Q(ntryL,G1H4(181),ex3(:),G1H4(221),ngH,m3h1x4(:,32),heltab2x4(:,:,115))
  call Hloop_A_Q(ntryL,G1H4(221),54,nMT,G2H4(120),n2h4(113))
call HGT_raise_alpha_OLR(G1H4(182),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(182),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(182),-8,ex4(:),8,G2H2(84),m3h2x2(:,84),heltab2x4(:,:,116))
call signflip_OLR(G2H2(84))
  call Hloop_AS_Q(ntryL,G1H4(187),ex3(:),G1H4(14),ngH,m3h1x4(:,33),heltab2x4(:,:,117))
  call Hloop_A_Q(ntryL,G1H4(14),54,nMT,G2H4(121),n2h4(115))
  call Hloop_AS_Q(ntryL,G1H4(193),ex3(:),G1H4(17),ngH,m3h1x4(:,34),heltab2x4(:,:,118))
  call Hloop_A_Q(ntryL,G1H4(17),54,nMT,G2H4(122),n2h4(116))
call HGT_raise_alpha_OLR(G1H4(188),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(188),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(188),-8,ex4(:),8,G2H2(85),m3h2x2(:,85),heltab2x4(:,:,119))
call signflip_OLR(G2H2(85))
  call Hloop_AS_Q(ntryL,G1H4(191),ex3(:),G1H4(222),ngH,m3h1x4(:,35),heltab2x4(:,:,120))
  call Hloop_A_Q(ntryL,G1H4(222),54,nMT,G2H4(123),n2h4(118))
  call Hloop_AS_Q(ntryL,G1H4(192),ex3(:),G1H4(18),ngH,m3h1x4(:,36),heltab2x4(:,:,121))
  call Hloop_A_Q(ntryL,G1H4(18),54,nMT,G2H4(124),n2h4(119))
call HGT_raise_alpha_OLR(G1H4(194),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(194),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(194),-8,ex4(:),8,G2H2(86),m3h2x2(:,86),heltab2x4(:,:,122))
call signflip_OLR(G2H2(86))
  call Hloop_AS_Q(ntryL,G1H4(197),ex3(:),G1H4(239),ngH,m3h1x4(:,37),heltab2x4(:,:,123))
  call Hloop_A_Q(ntryL,G1H4(239),54,nMT,G2H4(125),n2h4(121))
  call Hloop_AS_Q(ntryL,G1H4(198),ex3(:),G1H4(19),ngH,m3h1x4(:,38),heltab2x4(:,:,124))
  call Hloop_A_Q(ntryL,G1H4(19),54,nMT,G2H4(126),n2h4(122))
  call Hloop_AS_Q(ntryL,G1H4(199),ex3(:),G1H4(240),ngH,m3h1x4(:,39),heltab2x4(:,:,125))
  call Hloop_A_Q(ntryL,G1H4(240),46,nMT,G2H4(127),n2h4(123))
call HGT_raise_alpha_OLR(G1H4(200),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(200),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(200),-16,ex5(:),16,G2H2(87),m3h2x2(:,87),heltab2x4(:,:,126))
call signflip_OLR(G2H2(87))
  call Hloop_AS_Q(ntryL,G1H4(205),ex3(:),G1H4(20),ngH,m3h1x4(:,40),heltab2x4(:,:,127))
  call Hloop_A_Q(ntryL,G1H4(20),46,nMT,G2H4(128),n2h4(125))
  call Hloop_AS_Q(ntryL,G1H4(211),ex3(:),G1H4(23),ngH,m3h1x4(:,41),heltab2x4(:,:,128))
  call Hloop_A_Q(ntryL,G1H4(23),46,nMT,G2H4(129),n2h4(126))
call HGT_raise_alpha_OLR(G1H4(206),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(206),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(206),-16,ex5(:),16,G2H2(88),m3h2x2(:,88),heltab2x4(:,:,129))
call signflip_OLR(G2H2(88))
  call Hloop_AS_Q(ntryL,G1H4(209),ex3(:),G1H4(257),ngH,m3h1x4(:,42),heltab2x4(:,:,130))
  call Hloop_A_Q(ntryL,G1H4(257),46,nMT,G2H4(130),n2h4(128))
  call Hloop_AS_Q(ntryL,G1H4(210),ex3(:),G1H4(24),ngH,m3h1x4(:,43),heltab2x4(:,:,131))
  call Hloop_A_Q(ntryL,G1H4(24),46,nMT,G2H4(131),n2h4(129))
call HGT_raise_alpha_OLR(G1H4(212),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(212),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(212),-16,ex5(:),16,G2H2(89),m3h2x2(:,89),heltab2x4(:,:,132))
call signflip_OLR(G2H2(89))
  call Hloop_AS_Q(ntryL,G1H4(215),ex3(:),G1H4(258),ngH,m3h1x4(:,44),heltab2x4(:,:,133))
  call Hloop_A_Q(ntryL,G1H4(258),46,nMT,G2H4(132),n2h4(131))
  call Hloop_AS_Q(ntryL,G1H4(216),ex3(:),G1H4(25),ngH,m3h1x4(:,45),heltab2x4(:,:,134))
  call Hloop_A_Q(ntryL,G1H4(25),46,nMT,G2H4(133),n2h4(132))
  call Hloop_AS_Q(ntryL,G1H4(217),ex3(:),G1H4(26),ngH,m3h1x4(:,46),heltab2x4(:,:,135))
  call Hloop_A_Q(ntryL,G1H4(26),46,nMT,G2H4(134),n2h4(133))
call HGT_raise_alpha_OLR(G1H4(218),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(218),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(218),-16,ex5(:),16,G2H2(90),m3h2x2(:,90),heltab2x4(:,:,136))
call signflip_OLR(G2H2(90))
  call Hloop_AS_Q(ntryL,G1H4(223),ex3(:),G1H4(29),ngH,m3h1x4(:,47),heltab2x4(:,:,137))
  call Hloop_A_Q(ntryL,G1H4(29),46,nMT,G2H4(135),n2h4(135))
  call Hloop_AS_Q(ntryL,G1H4(229),ex3(:),G1H4(30),ngH,m3h1x4(:,48),heltab2x4(:,:,138))
  call Hloop_A_Q(ntryL,G1H4(30),46,nMT,G2H4(136),n2h4(136))
call HGT_raise_alpha_OLR(G1H4(224),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(224),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(224),-16,ex5(:),16,G2H2(91),m3h2x2(:,91),heltab2x4(:,:,139))
call signflip_OLR(G2H2(91))
  call Hloop_AS_Q(ntryL,G1H4(227),ex3(:),G1H4(275),ngH,m3h1x4(:,49),heltab2x4(:,:,140))
  call Hloop_A_Q(ntryL,G1H4(275),46,nMT,G2H4(137),n2h4(138))
  call Hloop_AS_Q(ntryL,G1H4(228),ex3(:),G1H4(276),ngH,m3h1x4(:,50),heltab2x4(:,:,141))
  call Hloop_A_Q(ntryL,G1H4(276),46,nMT,G2H4(138),n2h4(139))
call HGT_raise_alpha_OLR(G1H4(230),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(230),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(230),-16,ex5(:),16,G2H2(92),m3h2x2(:,92),heltab2x4(:,:,142))
call signflip_OLR(G2H2(92))
  call Hloop_AS_Q(ntryL,G1H4(233),ex3(:),G1H4(293),ngH,m3h1x4(:,51),heltab2x4(:,:,143))
  call Hloop_A_Q(ntryL,G1H4(293),46,nMT,G2H4(139),n2h4(141))
  call Hloop_AS_Q(ntryL,G1H4(234),ex3(:),G1H4(31),ngH,m3h1x4(:,52),heltab2x4(:,:,144))
  call Hloop_A_Q(ntryL,G1H4(31),46,nMT,G2H4(140),n2h4(142))
  call Hloop_QV_A(ntryL,G1H8(84),ex4(:),G1H4(32),m3h2x4(:,151),heltab2x8(:,:,199))
  call Hloop_Q_A(ntryL,G1H4(32),45,nMT,G2H4(141),n2h4(143))
call HGT_raise_alpha_OLR(G1H8(13),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(13),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(13),-16,ex5(:),16,G2H4(142),m3h2x4(:,152),heltab2x8(:,:,200))
call signflip_OLR(G2H4(142))
  call Hloop_QV_A(ntryL,G1H8(87),ex4(:),G1H4(35),m3h2x4(:,153),heltab2x8(:,:,201))
  call Hloop_Q_A(ntryL,G1H4(35),45,nMT,G2H4(143),n2h4(144))
  call Hloop_QV_A(ntryL,G1H8(14),ex4(:),G1H4(36),m3h2x4(:,154),heltab2x8(:,:,202))
  call Hloop_Q_A(ntryL,G1H4(36),45,nMT,G2H4(144),n2h4(145))
call HGT_raise_alpha_OLR(G1H8(40),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(40),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(40),-16,ex5(:),16,G2H4(145),m3h2x4(:,155),heltab2x8(:,:,203))
call signflip_OLR(G2H4(145))
  call Hloop_QV_A(ntryL,G1H8(41),ex4(:),G1H4(37),m3h2x4(:,156),heltab2x8(:,:,204))
  call Hloop_Q_A(ntryL,G1H4(37),45,nMT,G2H4(146),n2h4(146))
  call Hloop_QV_A(ntryL,G1H8(91),ex4(:),G1H4(38),m3h2x4(:,157),heltab2x8(:,:,205))
  call Hloop_Q_A(ntryL,G1H4(38),45,nMT,G2H4(147),n2h4(147))
call HGT_raise_alpha_OLR(G1H8(92),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(92),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(92),-16,ex5(:),16,G2H4(148),m3h2x4(:,158),heltab2x8(:,:,206))
call signflip_OLR(G2H4(148))
  call Hloop_QV_A(ntryL,G1H8(44),ex4(:),G1H4(41),m3h2x4(:,159),heltab2x8(:,:,207))
  call Hloop_Q_A(ntryL,G1H4(41),45,nMT,G2H4(149),n2h4(148))
  call Hloop_QV_A(ntryL,G1H8(94),ex4(:),G1H4(42),m3h2x4(:,160),heltab2x8(:,:,208))
  call Hloop_Q_A(ntryL,G1H4(42),45,nMT,G2H4(150),n2h4(149))
  call Hloop_QV_A(ntryL,G1H8(96),ex5(:),G1H4(294),m3h2x4(:,161),heltab2x8(:,:,209))
  call Hloop_Q_A(ntryL,G1H4(294),53,nMT,G2H4(151),n2h4(150))
call HGT_raise_alpha_OLR(G1H8(45),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(45),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(45),-8,ex4(:),8,G2H4(152),m3h2x4(:,162),heltab2x8(:,:,210))
call signflip_OLR(G2H4(152))
  call Hloop_QV_A(ntryL,G1H8(99),ex5(:),G1H4(311),m3h2x4(:,163),heltab2x8(:,:,211))
  call Hloop_Q_A(ntryL,G1H4(311),53,nMT,G2H4(153),n2h4(151))
  call Hloop_QV_A(ntryL,G1H8(50),ex5(:),G1H4(312),m3h2x4(:,164),heltab2x8(:,:,212))
  call Hloop_Q_A(ntryL,G1H4(312),53,nMT,G2H4(154),n2h4(152))
call HGT_raise_alpha_OLR(G1H8(25),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(25),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(25),-8,ex4(:),8,G2H4(155),m3h2x4(:,165),heltab2x8(:,:,213))
call signflip_OLR(G2H4(155))
  call Hloop_QV_A(ntryL,G1H8(48),ex5(:),G1H4(43),m3h2x4(:,166),heltab2x8(:,:,214))
  call Hloop_Q_A(ntryL,G1H4(43),53,nMT,G2H4(156),n2h4(153))
  call Hloop_QV_A(ntryL,G1H8(103),ex5(:),G1H4(44),m3h2x4(:,167),heltab2x8(:,:,215))
  call Hloop_Q_A(ntryL,G1H4(44),53,nMT,G2H4(157),n2h4(154))
call HGT_raise_alpha_OLR(G1H8(104),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(104),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(104),-8,ex4(:),8,G2H4(158),m3h2x4(:,168),heltab2x8(:,:,216))
call signflip_OLR(G2H4(158))
  call Hloop_QV_A(ntryL,G1H8(18),ex5(:),G1H4(47),m3h2x4(:,169),heltab2x8(:,:,217))
  call Hloop_Q_A(ntryL,G1H4(47),53,nMT,G2H4(159),n2h4(155))
  call Hloop_QV_A(ntryL,G1H8(105),ex5(:),G1H4(48),m3h2x4(:,170),heltab2x8(:,:,218))
  call Hloop_Q_A(ntryL,G1H4(48),53,nMT,G2H4(160),n2h4(156))
  call Hloop_QV_A(ntryL,G1H8(106),ex5(:),G1H4(49),m3h2x4(:,171),heltab2x8(:,:,219))
  call Hloop_Q_A(ntryL,G1H4(49),53,nMT,G2H4(161),n2h4(157))
call HGT_raise_alpha_OLR(G1H8(107),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(107),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(107),ex2(:),G1H4(50),m3h2x4(:,172),heltab2x8(:,:,220))
  call Hloop_QV_A(ntryL,G1H8(112),ex5(:),G1H4(53),m3h2x4(:,173),heltab2x8(:,:,221))
  call Hloop_Q_A(ntryL,G1H4(53),53,nMT,G2H4(162),n2h4(158))
  call Hloop_QV_A(ntryL,G1H8(118),ex5(:),G1H4(54),m3h2x4(:,174),heltab2x8(:,:,222))
  call Hloop_Q_A(ntryL,G1H4(54),53,nMT,G2H4(163),n2h4(159))
call HGT_raise_alpha_OLR(G1H8(21),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(21),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(21),ex2(:),G1H4(55),m3h2x4(:,175),heltab2x8(:,:,223))
  call Hloop_QV_A(ntryL,G1H8(116),ex5(:),G1H4(329),m3h2x4(:,176),heltab2x8(:,:,224))
  call Hloop_Q_A(ntryL,G1H4(329),53,nMT,G2H4(164),n2h4(160))
  call Hloop_QV_A(ntryL,G1H8(117),ex5(:),G1H4(56),m3h2x4(:,177),heltab2x8(:,:,225))
  call Hloop_Q_A(ntryL,G1H4(56),53,nMT,G2H4(165),n2h4(161))
call HGT_raise_alpha_OLR(G1H8(119),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(119),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(119),ex2(:),G1H4(59),m3h2x4(:,178),heltab2x8(:,:,226))
  call Hloop_QV_A(ntryL,G1H8(123),ex5(:),G1H4(330),m3h2x4(:,179),heltab2x8(:,:,227))
  call Hloop_Q_A(ntryL,G1H4(330),53,nMT,G2H4(166),n2h4(162))
  call Hloop_QV_A(ntryL,G1H8(22),ex5(:),G1H4(60),m3h2x4(:,180),heltab2x8(:,:,228))
  call Hloop_Q_A(ntryL,G1H4(60),53,nMT,G2H4(167),n2h4(163))
  call Hloop_QV_A(ntryL,G1H8(23),ex4(:),G1H4(7),m3h2x4(:,181),heltab2x8(:,:,229))
  call Hloop_Q_A(ntryL,G1H4(7),45,nMT,G2H4(168),n2h4(164))
call HGT_raise_alpha_OLR(G1H8(125),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(125),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(125),ex2(:),G1H4(61),m3h2x4(:,182),heltab2x8(:,:,230))
  call Hloop_QV_A(ntryL,G1H8(130),ex4(:),G1H4(8),m3h2x4(:,183),heltab2x8(:,:,231))
  call Hloop_Q_A(ntryL,G1H4(8),45,nMT,G2H4(169),n2h4(165))
  call Hloop_QV_A(ntryL,G1H8(137),ex4(:),G1H4(62),m3h2x4(:,184),heltab2x8(:,:,232))
  call Hloop_Q_A(ntryL,G1H4(62),45,nMT,G2H4(170),n2h4(166))
call HGT_raise_alpha_OLR(G1H8(131),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(131),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(131),ex2(:),G1H4(65),m3h2x4(:,185),heltab2x8(:,:,233))
  call Hloop_QV_A(ntryL,G1H8(135),ex4(:),G1H4(11),m3h2x4(:,186),heltab2x8(:,:,234))
  call Hloop_Q_A(ntryL,G1H4(11),45,nMT,G2H4(171),n2h4(167))
  call Hloop_QV_A(ntryL,G1H8(136),ex4(:),G1H4(66),m3h2x4(:,187),heltab2x8(:,:,235))
  call Hloop_Q_A(ntryL,G1H4(66),45,nMT,G2H4(172),n2h4(168))
call HGT_raise_alpha_OLR(G1H8(138),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(138),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(138),ex2(:),G1H4(12),m3h2x4(:,188),heltab2x8(:,:,236))
  call Hloop_QV_A(ntryL,G1H8(141),ex4(:),G1H4(67),m3h2x4(:,189),heltab2x8(:,:,237))
  call Hloop_Q_A(ntryL,G1H4(67),45,nMT,G2H4(173),n2h4(169))
  call Hloop_QV_A(ntryL,G1H8(142),ex4(:),G1H4(68),m3h2x4(:,190),heltab2x8(:,:,238))
  call Hloop_Q_A(ntryL,G1H4(68),45,nMT,G2H4(174),n2h4(170))
  call Hloop_AV_Q(ntryL,G1H8(143),ex4(:),G1H4(71),m3h2x4(:,191),heltab2x8(:,:,239))
  call Hloop_A_Q(ntryL,G1H4(71),46,nMT,G2H4(175),n2h4(171))
call HGT_raise_alpha_OLR(G1H8(144),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(144),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(144),-16,ex5(:),16,G2H4(176),m3h2x4(:,192),heltab2x8(:,:,240))
call signflip_OLR(G2H4(176))
  call Hloop_AV_Q(ntryL,G1H8(149),ex4(:),G1H4(72),m3h2x4(:,193),heltab2x8(:,:,241))
  call Hloop_A_Q(ntryL,G1H4(72),46,nMT,G2H4(177),n2h4(172))
  call Hloop_AV_Q(ntryL,G1H8(155),ex4(:),G1H4(73),m3h2x4(:,194),heltab2x8(:,:,242))
  call Hloop_A_Q(ntryL,G1H4(73),46,nMT,G2H4(178),n2h4(173))
call HGT_raise_alpha_OLR(G1H8(150),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(150),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(150),-16,ex5(:),16,G2H4(179),m3h2x4(:,195),heltab2x8(:,:,243))
call signflip_OLR(G2H4(179))
  call Hloop_AV_Q(ntryL,G1H8(153),ex4(:),G1H4(74),m3h2x4(:,196),heltab2x8(:,:,244))
  call Hloop_A_Q(ntryL,G1H4(74),46,nMT,G2H4(180),n2h4(174))
  call Hloop_AV_Q(ntryL,G1H8(154),ex4(:),G1H4(77),m3h2x4(:,197),heltab2x8(:,:,245))
  call Hloop_A_Q(ntryL,G1H4(77),46,nMT,G2H4(181),n2h4(175))
call HGT_raise_alpha_OLR(G1H8(156),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(156),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(156),-16,ex5(:),16,G2H4(182),m3h2x4(:,198),heltab2x8(:,:,246))
call signflip_OLR(G2H4(182))
  call Hloop_AV_Q(ntryL,G1H8(159),ex4(:),G1H4(78),m3h2x4(:,199),heltab2x8(:,:,247))
  call Hloop_A_Q(ntryL,G1H4(78),46,nMT,G2H4(183),n2h4(176))
  call Hloop_AV_Q(ntryL,G1H8(160),ex4(:),G1H4(79),m3h2x4(:,200),heltab2x8(:,:,248))
  call Hloop_A_Q(ntryL,G1H4(79),46,nMT,G2H4(184),n2h4(177))
  call Hloop_AV_Q(ntryL,G1H8(161),ex5(:),G1H4(80),m3h2x4(:,201),heltab2x8(:,:,249))
  call Hloop_A_Q(ntryL,G1H4(80),54,nMT,G2H4(185),n2h4(178))
call HGT_raise_alpha_OLR(G1H8(162),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(162),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(162),-8,ex4(:),8,G2H4(186),m3h2x4(:,202),heltab2x8(:,:,250))
call signflip_OLR(G2H4(186))
  call Hloop_AV_Q(ntryL,G1H8(167),ex5(:),G1H4(83),m3h2x4(:,203),heltab2x8(:,:,251))
  call Hloop_A_Q(ntryL,G1H4(83),54,nMT,G2H4(187),n2h4(179))
  call Hloop_AV_Q(ntryL,G1H8(173),ex5(:),G1H4(84),m3h2x4(:,204),heltab2x8(:,:,252))
  call Hloop_A_Q(ntryL,G1H4(84),54,nMT,G2H4(188),n2h4(180))
call HGT_raise_alpha_OLR(G1H8(168),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(168),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(168),-8,ex4(:),8,G2H4(189),m3h2x4(:,205),heltab2x8(:,:,253))
call signflip_OLR(G2H4(189))
  call Hloop_AV_Q(ntryL,G1H8(171),ex5(:),G1H4(85),m3h2x4(:,206),heltab2x8(:,:,254))
  call Hloop_A_Q(ntryL,G1H4(85),54,nMT,G2H4(190),n2h4(181))
  call Hloop_AV_Q(ntryL,G1H8(172),ex5(:),G1H4(86),m3h2x4(:,207),heltab2x8(:,:,255))
  call Hloop_A_Q(ntryL,G1H4(86),54,nMT,G2H4(191),n2h4(182))
call HGT_raise_alpha_OLR(G1H8(174),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(174),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(174),-8,ex4(:),8,G2H4(192),m3h2x4(:,208),heltab2x8(:,:,256))
call signflip_OLR(G2H4(192))
  call Hloop_AV_Q(ntryL,G1H8(177),ex5(:),G1H4(89),m3h2x4(:,209),heltab2x8(:,:,257))
  call Hloop_A_Q(ntryL,G1H4(89),54,nMT,G2H4(193),n2h4(183))
  call Hloop_AV_Q(ntryL,G1H8(178),ex5(:),G1H4(90),m3h2x4(:,210),heltab2x8(:,:,258))
  call Hloop_A_Q(ntryL,G1H4(90),54,nMT,G2H4(194),n2h4(184))
  call Hloop_QS_A(ntryL,G1H4(235),ex3(:),G1H4(91),ngH,m3h1x4(:,53),heltab2x4(:,:,145))
  call Hloop_Q_A(ntryL,G1H4(91),45,nMT,G2H4(195),n2h4(185))
call HGT_raise_alpha_OLR(G1H4(236),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(236),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(236),-16,ex5(:),16,G2H2(93),m3h2x2(:,93),heltab2x4(:,:,146))
call signflip_OLR(G2H2(93))
  call Hloop_QS_A(ntryL,G1H4(241),ex3(:),G1H4(92),ngH,m3h1x4(:,54),heltab2x4(:,:,147))
  call Hloop_Q_A(ntryL,G1H4(92),45,nMT,G2H4(196),n2h4(187))
  call Hloop_QS_A(ntryL,G1H4(247),ex3(:),G1H4(95),ngH,m3h1x4(:,55),heltab2x4(:,:,148))
  call Hloop_Q_A(ntryL,G1H4(95),45,nMT,G2H4(197),n2h4(188))
call HGT_raise_alpha_OLR(G1H4(242),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(242),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(242),-16,ex5(:),16,G2H2(94),m3h2x2(:,94),heltab2x4(:,:,149))
call signflip_OLR(G2H2(94))
  call Hloop_QS_A(ntryL,G1H4(245),ex3(:),G1H4(96),ngH,m3h1x4(:,56),heltab2x4(:,:,150))
  call Hloop_Q_A(ntryL,G1H4(96),45,nMT,G2H4(198),n2h4(190))
  call Hloop_QS_A(ntryL,G1H4(246),ex3(:),G1H4(97),ngH,m3h1x4(:,57),heltab2x4(:,:,151))
  call Hloop_Q_A(ntryL,G1H4(97),45,nMT,G2H4(199),n2h4(191))
call HGT_raise_alpha_OLR(G1H4(248),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(248),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(248),-16,ex5(:),16,G2H2(95),m3h2x2(:,95),heltab2x4(:,:,152))
call signflip_OLR(G2H2(95))
  call Hloop_QS_A(ntryL,G1H4(251),ex3(:),G1H4(98),ngH,m3h1x4(:,58),heltab2x4(:,:,153))
  call Hloop_Q_A(ntryL,G1H4(98),45,nMT,G2H4(200),n2h4(193))
  call Hloop_QS_A(ntryL,G1H4(252),ex3(:),G1H4(101),ngH,m3h1x4(:,59),heltab2x4(:,:,154))
  call Hloop_Q_A(ntryL,G1H4(101),45,nMT,G2H4(201),n2h4(194))
  call Hloop_QV_A(ntryL,G1H4(253),ex5(:),G1H2(1),m3h2x2(:,96),heltab2x4(:,:,155))
  call Hloop_Q_A(ntryL,G1H2(1),57,nMT,G2H2(96),n2h2(55))
call HGT_raise_alpha_OLR(G1H4(254),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(254),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(254),ex2(:),G1H2(1),m3h2x2(:,97),heltab2x4(:,:,156))
  call Hloop_QV_A(ntryL,G1H4(259),ex5(:),G1H2(2),m3h2x2(:,98),heltab2x4(:,:,157))
  call Hloop_Q_A(ntryL,G1H2(2),57,nMT,G2H2(97),n2h2(56))
  call Hloop_QV_A(ntryL,G1H4(265),ex5(:),G1H2(2),m3h2x2(:,99),heltab2x4(:,:,158))
  call Hloop_Q_A(ntryL,G1H2(2),57,nMT,G2H2(98),n2h2(57))
call HGT_raise_alpha_OLR(G1H4(260),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(260),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(260),ex2(:),G1H2(2),m3h2x2(:,100),heltab2x4(:,:,159))
  call Hloop_QV_A(ntryL,G1H4(263),ex5(:),G1H2(3),m3h2x2(:,101),heltab2x4(:,:,160))
  call Hloop_Q_A(ntryL,G1H2(3),57,nMT,G2H2(99),n2h2(58))
  call Hloop_QV_A(ntryL,G1H4(264),ex5(:),G1H2(3),m3h2x2(:,102),heltab2x4(:,:,161))
  call Hloop_Q_A(ntryL,G1H2(3),57,nMT,G2H2(100),n2h2(59))
call HGT_raise_alpha_OLR(G1H4(266),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(266),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(266),ex2(:),G1H2(3),m3h2x2(:,103),heltab2x4(:,:,162))
  call Hloop_QV_A(ntryL,G1H4(269),ex5(:),G1H2(4),m3h2x2(:,104),heltab2x4(:,:,163))
  call Hloop_Q_A(ntryL,G1H2(4),57,nMT,G2H2(101),n2h2(60))
  call Hloop_QV_A(ntryL,G1H4(270),ex5(:),G1H2(4),m3h2x2(:,105),heltab2x4(:,:,164))
  call Hloop_Q_A(ntryL,G1H2(4),57,nMT,G2H2(102),n2h2(61))
  call Hloop_QS_A(ntryL,G1H4(271),ex3(:),G1H4(102),ngH,m3h1x4(:,60),heltab2x4(:,:,165))
  call Hloop_Q_A(ntryL,G1H4(102),45,nMT,G2H4(202),n2h4(198))
call HGT_raise_alpha_OLR(G1H4(272),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(272),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(272),ex2(:),G1H2(4),m3h2x2(:,106),heltab2x4(:,:,166))
  call Hloop_QS_A(ntryL,G1H4(277),ex3(:),G1H4(103),ngH,m3h1x4(:,61),heltab2x4(:,:,167))
  call Hloop_Q_A(ntryL,G1H4(103),45,nMT,G2H4(203),n2h4(200))
  call Hloop_QS_A(ntryL,G1H4(283),ex3(:),G1H4(104),ngH,m3h1x4(:,62),heltab2x4(:,:,168))
  call Hloop_Q_A(ntryL,G1H4(104),45,nMT,G2H4(204),n2h4(201))
call HGT_raise_alpha_OLR(G1H4(278),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(278),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(278),ex2(:),G1H2(5),m3h2x2(:,107),heltab2x4(:,:,169))
  call Hloop_QS_A(ntryL,G1H4(281),ex3(:),G1H4(107),ngH,m3h1x4(:,63),heltab2x4(:,:,170))
  call Hloop_Q_A(ntryL,G1H4(107),45,nMT,G2H4(205),n2h4(203))
  call Hloop_QS_A(ntryL,G1H4(282),ex3(:),G1H4(108),ngH,m3h1x4(:,64),heltab2x4(:,:,171))
  call Hloop_Q_A(ntryL,G1H4(108),45,nMT,G2H4(206),n2h4(204))
call HGT_raise_alpha_OLR(G1H4(284),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(284),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(284),ex2(:),G1H2(6),m3h2x2(:,108),heltab2x4(:,:,172))
  call Hloop_QS_A(ntryL,G1H4(287),ex3(:),G1H4(109),ngH,m3h1x4(:,65),heltab2x4(:,:,173))
  call Hloop_Q_A(ntryL,G1H4(109),45,nMT,G2H4(207),n2h4(206))
  call Hloop_QS_A(ntryL,G1H4(288),ex3(:),G1H4(110),ngH,m3h1x4(:,66),heltab2x4(:,:,174))
  call Hloop_Q_A(ntryL,G1H4(110),45,nMT,G2H4(208),n2h4(207))
  call Hloop_QS_A(ntryL,G1H4(289),ex3(:),G1H4(113),ngH,m3h1x4(:,67),heltab2x4(:,:,175))
  call Hloop_Q_A(ntryL,G1H4(113),53,nMT,G2H4(209),n2h4(208))
call HGT_raise_alpha_OLR(G1H4(290),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(290),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(290),-8,ex4(:),8,G2H2(103),m3h2x2(:,109),heltab2x4(:,:,176))
call signflip_OLR(G2H2(103))
  call Hloop_QS_A(ntryL,G1H4(295),ex3(:),G1H4(114),ngH,m3h1x4(:,68),heltab2x4(:,:,177))
  call Hloop_Q_A(ntryL,G1H4(114),53,nMT,G2H4(210),n2h4(210))
  call Hloop_QS_A(ntryL,G1H4(301),ex3(:),G1H4(115),ngH,m3h1x4(:,69),heltab2x4(:,:,178))
  call Hloop_Q_A(ntryL,G1H4(115),53,nMT,G2H4(211),n2h4(211))
call HGT_raise_alpha_OLR(G1H4(296),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(296),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(296),-8,ex4(:),8,G2H2(104),m3h2x2(:,110),heltab2x4(:,:,179))
call signflip_OLR(G2H2(104))
  call Hloop_QS_A(ntryL,G1H4(299),ex3(:),G1H4(116),ngH,m3h1x4(:,70),heltab2x4(:,:,180))
  call Hloop_Q_A(ntryL,G1H4(116),53,nMT,G2H4(212),n2h4(213))
  call Hloop_QS_A(ntryL,G1H4(300),ex3(:),G1H4(119),ngH,m3h1x4(:,71),heltab2x4(:,:,181))
  call Hloop_Q_A(ntryL,G1H4(119),53,nMT,G2H4(213),n2h4(214))
call HGT_raise_alpha_OLR(G1H4(302),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(302),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(302),-8,ex4(:),8,G2H2(105),m3h2x2(:,111),heltab2x4(:,:,182))
call signflip_OLR(G2H2(105))
  call Hloop_QS_A(ntryL,G1H4(305),ex3(:),G1H4(120),ngH,m3h1x4(:,72),heltab2x4(:,:,183))
  call Hloop_Q_A(ntryL,G1H4(120),53,nMT,G2H4(214),n2h4(216))
  call Hloop_QS_A(ntryL,G1H4(306),ex3(:),G1H4(121),ngH,m3h1x4(:,73),heltab2x4(:,:,184))
  call Hloop_Q_A(ntryL,G1H4(121),53,nMT,G2H4(215),n2h4(217))
  call Hloop_QV_A(ntryL,G1H4(307),ex4(:),G1H2(7),m3h2x2(:,112),heltab2x4(:,:,185))
  call Hloop_Q_A(ntryL,G1H2(7),57,nMT,G2H2(106),n2h2(62))
call HGT_raise_alpha_OLR(G1H4(308),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(308),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(308),ex2(:),G1H2(7),m3h2x2(:,113),heltab2x4(:,:,186))
  call Hloop_QV_A(ntryL,G1H4(313),ex4(:),G1H2(8),m3h2x2(:,114),heltab2x4(:,:,187))
  call Hloop_Q_A(ntryL,G1H2(8),57,nMT,G2H2(107),n2h2(63))
  call Hloop_QV_A(ntryL,G1H4(319),ex4(:),G1H2(8),m3h2x2(:,115),heltab2x4(:,:,188))
  call Hloop_Q_A(ntryL,G1H2(8),57,nMT,G2H2(108),n2h2(64))
call HGT_raise_alpha_OLR(G1H4(314),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(314),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(314),ex2(:),G1H2(8),m3h2x2(:,116),heltab2x4(:,:,189))
  call Hloop_QV_A(ntryL,G1H4(317),ex4(:),G1H2(9),m3h2x2(:,117),heltab2x4(:,:,190))
  call Hloop_Q_A(ntryL,G1H2(9),57,nMT,G2H2(109),n2h2(65))
  call Hloop_QV_A(ntryL,G1H4(318),ex4(:),G1H2(9),m3h2x2(:,118),heltab2x4(:,:,191))
  call Hloop_Q_A(ntryL,G1H2(9),57,nMT,G2H2(110),n2h2(66))
call HGT_raise_alpha_OLR(G1H4(320),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(320),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(320),ex2(:),G1H2(9),m3h2x2(:,119),heltab2x4(:,:,192))
  call Hloop_QV_A(ntryL,G1H4(323),ex4(:),G1H2(10),m3h2x2(:,120),heltab2x4(:,:,193))
  call Hloop_Q_A(ntryL,G1H2(10),57,nMT,G2H2(111),n2h2(67))
  call Hloop_QV_A(ntryL,G1H4(324),ex4(:),G1H2(10),m3h2x2(:,121),heltab2x4(:,:,194))
  call Hloop_Q_A(ntryL,G1H2(10),57,nMT,G2H2(112),n2h2(68))
  call Hloop_QS_A(ntryL,G1H4(325),ex3(:),G1H4(122),ngH,m3h1x4(:,74),heltab2x4(:,:,195))
  call Hloop_Q_A(ntryL,G1H4(122),53,nMT,G2H4(216),n2h4(221))
call HGT_raise_alpha_OLR(G1H4(326),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(326),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(326),ex2(:),G1H2(10),m3h2x2(:,122),heltab2x4(:,:,196))
  call Hloop_QS_A(ntryL,G1H4(331),ex3(:),G1H4(125),ngH,m3h1x4(:,75),heltab2x4(:,:,197))
  call Hloop_Q_A(ntryL,G1H4(125),53,nMT,G2H4(217),n2h4(223))
  call Hloop_QS_A(ntryL,G1H4(337),ex3(:),G1H4(126),ngH,m3h1x4(:,76),heltab2x4(:,:,198))
  call Hloop_Q_A(ntryL,G1H4(126),53,nMT,G2H4(218),n2h4(224))
call HGT_raise_alpha_OLR(G1H4(332),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(332),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(332),ex2(:),G1H2(11),m3h2x2(:,123),heltab2x4(:,:,199))
  call Hloop_QS_A(ntryL,G1H4(335),ex3(:),G1H4(127),ngH,m3h1x4(:,77),heltab2x4(:,:,200))
  call Hloop_Q_A(ntryL,G1H4(127),53,nMT,G2H4(219),n2h4(226))
  call Hloop_QS_A(ntryL,G1H4(336),ex3(:),G1H4(128),ngH,m3h1x4(:,78),heltab2x4(:,:,201))
  call Hloop_Q_A(ntryL,G1H4(128),53,nMT,G2H4(220),n2h4(227))
call HGT_raise_alpha_OLR(G1H4(338),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(338),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(338),ex2(:),G1H2(12),m3h2x2(:,124),heltab2x4(:,:,202))
  call Hloop_QS_A(ntryL,G1H4(341),ex3(:),G1H4(131),ngH,m3h1x4(:,79),heltab2x4(:,:,203))
  call Hloop_Q_A(ntryL,G1H4(131),53,nMT,G2H4(221),n2h4(229))
  call Hloop_QS_A(ntryL,G1H4(342),ex3(:),G1H4(132),ngH,m3h1x4(:,80),heltab2x4(:,:,204))
  call Hloop_Q_A(ntryL,G1H4(132),53,nMT,G2H4(222),n2h4(230))
call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(133),G1H4(134),G1H4(137),G1H4(138),G1H4(139),G1H4(140),4)
call HG1shiftOLR(G1H4(134),16,4)
call Hotf_5pt_reduction(G2H4(3),RedSet_5(63),mass5set(:,11),  & 
G1H4(143),G1H4(144),G1H4(145),G1H4(146),G1H4(149),G1H4(150),4)
call HG1shiftOLR(G1H4(144),16,4)
call Hotf_5pt_reduction(G2H4(4),RedSet_5(2),mass5set(:,1),  & 
G1H4(151),G1H4(152),G1H4(155),G1H4(156),G1H4(157),G1H4(158),4)
call HG1shiftOLR(G1H4(152),16,4)
call Hotf_5pt_reduction(G2H4(6),RedSet_5(64),mass5set(:,11),  & 
G1H4(161),G1H4(162),G1H4(163),G1H4(167),G1H4(164),G1H4(169),4)
call HG1shiftOLR(G1H4(162),16,4)
call Hotf_5pt_reduction(G2H4(7),RedSet_5(3),mass5set(:,1),  & 
G1H4(168),G1H4(175),G1H4(185),G1H4(170),G1H4(173),G1H4(186),4)
call HG1shiftOLR(G1H4(175),8,4)
call Hotf_5pt_reduction(G2H4(9),RedSet_5(65),mass5set(:,11),  & 
G1H4(174),G1H4(203),G1H4(176),G1H4(179),G1H4(204),G1H4(180),4)
call HG1shiftOLR(G1H4(203),8,4)
call Hotf_5pt_reduction(G2H4(10),RedSet_5(4),mass5set(:,1),  & 
G1H4(13),G1H4(181),G1H4(221),G1H4(182),G1H4(187),G1H4(14),4)
call HG1shiftOLR(G1H4(181),16,4)
call Hotf_5pt_reduction(G2H4(12),RedSet_5(63),mass5set(:,11),  & 
G1H4(193),G1H4(17),G1H4(188),G1H4(191),G1H4(222),G1H4(192),4)
call HG1shiftOLR(G1H4(17),16,4)
call Hotf_5pt_reduction(G2H4(13),RedSet_5(5),mass5set(:,1),  & 
G1H4(18),G1H4(194),G1H4(197),G1H4(239),G1H4(198),G1H4(19),4)
call HG1shiftOLR(G1H4(194),16,4)
call Hotf_5pt_reduction(G2H4(15),RedSet_5(64),mass5set(:,11),  & 
G1H4(199),G1H4(240),G1H4(200),G1H4(205),G1H4(20),G1H4(211),4)
call HG1shiftOLR(G1H4(240),16,4)
call Hotf_5pt_reduction(G2H4(16),RedSet_5(6),mass5set(:,1),  & 
G1H4(23),G1H4(206),G1H4(209),G1H4(257),G1H4(210),G1H4(24),4)
call HG1shiftOLR(G1H4(206),8,4)
call Hotf_5pt_reduction(G2H4(18),RedSet_5(65),mass5set(:,11),  & 
G1H4(212),G1H4(215),G1H4(258),G1H4(216),G1H4(25),G1H4(217),4)
call HG1shiftOLR(G1H4(215),8,4)
call Hotf_5pt_reduction(G2H4(19),RedSet_5(8),mass5set(:,3),  & 
G1H4(26),G1H4(218),G1H4(223),G1H4(29),G1H4(229),G1H4(30),4)
call HG1shiftOLR(G1H4(218),16,4)
call Hotf_5pt_reduction(G2H4(21),RedSet_5(56),mass5set(:,3),  & 
G1H4(224),G1H4(227),G1H4(275),G1H4(228),G1H4(276),G1H4(230),4)
call HG1shiftOLR(G1H4(227),16,4)
call Hotf_5pt_reduction(G2H4(22),RedSet_5(8),mass5set(:,3),  & 
G1H4(233),G1H4(293),G1H4(234),G1H4(31),G1H4(32),G1H4(35),4)
call HG1shiftOLR(G1H4(293),8,4)
call Hotf_5pt_reduction(G2H4(24),RedSet_5(57),mass5set(:,3),  & 
G1H4(36),G1H4(37),G1H4(38),G1H4(41),G1H4(42),G1H4(294),4)
call HG1shiftOLR(G1H4(37),8,4)
call Hotf_5pt_reduction(G2H4(25),RedSet_5(12),mass5set(:,3),  & 
G1H4(311),G1H4(312),G1H4(43),G1H4(44),G1H4(47),G1H4(48),4)
call HG1shiftOLR(G1H4(312),16,4)
call Hotf_5pt_reduction(G2H4(29),RedSet_5(50),mass5set(:,3),  & 
G1H4(49),G1H4(53),G1H4(54),G1H4(329),G1H4(56),G1H4(330),4)
call HG1shiftOLR(G1H4(53),16,4)
call Hotf_5pt_reduction(G2H4(32),RedSet_5(12),mass5set(:,3),  & 
G1H4(60),G1H4(7),G1H4(8),G1H4(62),G1H4(11),G1H4(66),4)
call HG1shiftOLR(G1H4(7),8,4)
call Hotf_5pt_reduction(G2H4(35),RedSet_5(52),mass5set(:,3),  & 
G1H4(67),G1H4(68),G1H4(71),G1H4(72),G1H4(73),G1H4(74),4)
call HG1shiftOLR(G1H4(68),8,4)
call Hotf_5pt_reduction(G2H2(1),RedSet_5(21),mass5set(:,5),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
call HG1shiftOLR(G1H2(14),16,2)
call Hotf_5pt_reduction(G2H2(4),RedSet_5(46),mass5set(:,5),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
call HG1shiftOLR(G1H2(20),16,2)
call Hotf_5pt_reduction(G2H4(39),RedSet_5(22),mass5set(:,5),  & 
G1H4(77),G1H4(78),G1H4(79),G1H4(80),G1H4(83),G1H4(84),4)
call HG1shiftOLR(G1H4(78),16,4)
call Hotf_5pt_reduction(G2H4(44),RedSet_5(66),mass5set(:,5),  & 
G1H4(85),G1H4(86),G1H4(89),G1H4(90),G1H4(235),G1H4(91),4)
call HG1shiftOLR(G1H4(86),16,4)
call Hotf_5pt_reduction(G2H4(46),RedSet_5(22),mass5set(:,5),  & 
G1H4(236),G1H4(241),G1H4(92),G1H4(247),G1H4(95),G1H4(242),4)
call HG1shiftOLR(G1H4(241),8,4)
call Hotf_5pt_reduction(G2H4(57),RedSet_5(67),mass5set(:,5),  & 
G1H4(245),G1H4(96),G1H4(246),G1H4(97),G1H4(248),G1H4(251),4)
call HG1shiftOLR(G1H4(96),8,4)
call Hotf_5pt_reduction(G2H4(60),RedSet_5(23),mass5set(:,6),  & 
G1H4(98),G1H4(252),G1H4(101),G1H4(253),G1H4(254),G1H4(259),4)
call HG1shiftOLR(G1H4(252),16,4)
call Hotf_5pt_reduction(G2H4(64),RedSet_5(68),mass5set(:,6),  & 
G1H4(265),G1H4(260),G1H4(263),G1H4(264),G1H4(266),G1H4(269),4)
call HG1shiftOLR(G1H4(260),16,4)
call Hotf_5pt_reduction(G2H4(65),RedSet_5(23),mass5set(:,6),  & 
G1H4(270),G1H4(271),G1H4(102),G1H4(272),G1H4(277),G1H4(103),4)
call HG1shiftOLR(G1H4(271),8,4)
call Hotf_5pt_reduction(G2H4(69),RedSet_5(69),mass5set(:,6),  & 
G1H4(283),G1H4(104),G1H4(278),G1H4(281),G1H4(107),G1H4(282),4)
call HG1shiftOLR(G1H4(104),8,4)
call Hotf_5pt_reduction(G2H2(7),RedSet_5(24),mass5set(:,5),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
call HG1shiftOLR(G1H2(26),16,2)
call Hotf_5pt_reduction(G2H2(10),RedSet_5(42),mass5set(:,5),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
call HG1shiftOLR(G1H2(32),16,2)
call Hotf_5pt_reduction(G2H4(73),RedSet_5(25),mass5set(:,5),  & 
G1H4(108),G1H4(284),G1H4(287),G1H4(109),G1H4(288),G1H4(110),4)
call HG1shiftOLR(G1H4(284),16,4)
call Hotf_5pt_reduction(G2H4(77),RedSet_5(70),mass5set(:,5),  & 
G1H4(289),G1H4(113),G1H4(290),G1H4(295),G1H4(114),G1H4(301),4)
call HG1shiftOLR(G1H4(113),16,4)
call Hotf_5pt_reduction(G2H2(11),RedSet_5(26),mass5set(:,6),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
call HG1shiftOLR(G1H2(38),16,2)
call Hotf_5pt_reduction(G2H2(14),RedSet_5(68),mass5set(:,6),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
call HG1shiftOLR(G1H2(44),16,2)
call Hotf_5pt_reduction(G2H2(15),RedSet_5(26),mass5set(:,6),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
call HG1shiftOLR(G1H2(50),4,2)
call Hotf_5pt_reduction(G2H2(17),RedSet_5(71),mass5set(:,6),  & 
G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
call HG1shiftOLR(G1H2(56),4,2)
call Hotf_5pt_reduction(G2H4(82),RedSet_5(25),mass5set(:,5),  & 
G1H4(115),G1H4(296),G1H4(299),G1H4(116),G1H4(300),G1H4(119),4)
call HG1shiftOLR(G1H4(296),8,4)
call Hotf_5pt_reduction(G2H4(66),RedSet_5(72),mass5set(:,5),  & 
G1H4(302),G1H4(305),G1H4(120),G1H4(306),G1H4(121),G1H4(307),4)
call HG1shiftOLR(G1H4(305),8,4)
call Hotf_5pt_reduction(G2H2(18),RedSet_5(27),mass5set(:,6),  & 
G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
call HG1shiftOLR(G1H2(62),8,2)
call Hotf_5pt_reduction(G2H2(21),RedSet_5(69),mass5set(:,6),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
call HG1shiftOLR(G1H2(68),8,2)
call Hotf_5pt_reduction(G2H2(22),RedSet_5(27),mass5set(:,6),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
call HG1shiftOLR(G1H2(74),4,2)
call Hotf_5pt_reduction(G2H2(24),RedSet_5(71),mass5set(:,6),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
call HG1shiftOLR(G1H2(80),4,2)
call Hotf_5pt_reduction(G2H4(70),RedSet_5(28),mass5set(:,6),  & 
G1H4(308),G1H4(313),G1H4(319),G1H4(314),G1H4(317),G1H4(318),4)
call HG1shiftOLR(G1H4(313),16,4)
call Hotf_5pt_reduction(G2H4(83),RedSet_5(73),mass5set(:,6),  & 
G1H4(320),G1H4(323),G1H4(324),G1H4(325),G1H4(122),G1H4(326),4)
call HG1shiftOLR(G1H4(323),16,4)
call Hotf_5pt_reduction(G2H4(84),RedSet_5(28),mass5set(:,6),  & 
G1H4(331),G1H4(125),G1H4(337),G1H4(126),G1H4(332),G1H4(335),4)
call HG1shiftOLR(G1H4(125),8,4)
call Hotf_5pt_reduction(G2H4(86),RedSet_5(74),mass5set(:,6),  & 
G1H4(127),G1H4(336),G1H4(128),G1H4(338),G1H4(341),G1H4(131),4)
call HG1shiftOLR(G1H4(336),8,4)
call Hotf_5pt_reduction(G2H2(27),RedSet_5(29),mass5set(:,6),  & 
G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
call HG1shiftOLR(G1H2(86),16,2)
call Hotf_5pt_reduction(G2H2(30),RedSet_5(73),mass5set(:,6),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),2)
call HG1shiftOLR(G1H2(92),16,2)
call Hotf_5pt_reduction(G2H2(31),RedSet_5(29),mass5set(:,6),  & 
G1H2(97),G1H2(98),G1H2(99),G1H2(100),G1H2(101),G1H2(102),2)
call HG1shiftOLR(G1H2(98),4,2)
call Hotf_5pt_reduction(G2H2(33),RedSet_5(75),mass5set(:,6),  & 
G1H2(103),G1H2(104),G1H2(105),G1H2(106),G1H2(107),G1H2(108),2)
call HG1shiftOLR(G1H2(104),4,2)
call Hotf_5pt_reduction(G2H2(34),RedSet_5(30),mass5set(:,6),  & 
G1H2(109),G1H2(110),G1H2(111),G1H2(112),G1H2(113),G1H2(114),2)
call HG1shiftOLR(G1H2(110),8,2)
call Hotf_5pt_reduction(G2H2(37),RedSet_5(74),mass5set(:,6),  & 
G1H2(115),G1H2(116),G1H2(117),G1H2(118),G1H2(119),G1H2(120),2)
call HG1shiftOLR(G1H2(116),8,2)
call Hotf_5pt_reduction(G2H2(38),RedSet_5(30),mass5set(:,6),  & 
G1H2(121),G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),2)
call HG1shiftOLR(G1H2(122),4,2)
call Hotf_5pt_reduction(G2H2(40),RedSet_5(75),mass5set(:,6),  & 
G1H2(127),G1H2(128),G1H2(129),G1H2(130),G1H2(131),G1H2(132),2)
call HG1shiftOLR(G1H2(128),4,2)
call Hotf_5pt_reduction(G2H4(87),RedSet_5(31),mass5set(:,7),  & 
G1H4(342),G1H4(132),G1H4(343),G1H4(344),G1H4(345),G1H4(346),4)
call HG1shiftOLR(G1H4(132),16,4)
call Hotf_5pt_reduction(G2H4(92),RedSet_5(66),mass5set(:,5),  & 
G1H4(347),G1H4(348),G1H4(349),G1H4(350),G1H4(351),G1H4(352),4)
call HG1shiftOLR(G1H4(348),16,4)
call Hotf_5pt_reduction(G2H2(41),RedSet_5(32),mass5set(:,8),  & 
G1H2(133),G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),2)
call HG1shiftOLR(G1H2(134),16,2)
call Hotf_5pt_reduction(G2H2(44),RedSet_5(48),mass5set(:,8),  & 
G1H2(139),G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),2)
call HG1shiftOLR(G1H2(140),16,2)
call Hotf_5pt_reduction(G2H2(45),RedSet_5(33),mass5set(:,9),  & 
G1H2(145),G1H2(146),G1H2(147),G1H2(148),G1H2(149),G1H2(150),2)
call HG1shiftOLR(G1H2(146),4,2)
call Hotf_5pt_reduction(G2H2(47),RedSet_5(76),mass5set(:,8),  & 
G1H2(151),G1H2(152),G1H2(153),G1H2(154),G1H2(155),G1H2(156),2)
call HG1shiftOLR(G1H2(152),4,2)
call Hotf_5pt_reduction(G2H4(93),RedSet_5(34),mass5set(:,7),  & 
G1H4(353),G1H4(354),G1H4(355),G1H4(356),G1H4(357),G1H4(358),4)
call HG1shiftOLR(G1H4(354),8,4)
call Hotf_5pt_reduction(G2H4(97),RedSet_5(67),mass5set(:,5),  & 
G1H4(359),G1H4(360),G1H4(361),G1H4(362),G1H4(363),G1H4(364),4)
call HG1shiftOLR(G1H4(360),8,4)
call Hotf_5pt_reduction(G2H2(48),RedSet_5(35),mass5set(:,9),  & 
G1H2(157),G1H2(158),G1H2(159),G1H2(160),G1H2(161),G1H2(162),2)
call HG1shiftOLR(G1H2(158),4,2)
call Hotf_5pt_reduction(G2H2(50),RedSet_5(77),mass5set(:,8),  & 
G1H2(163),G1H2(164),G1H2(165),G1H2(166),G1H2(167),G1H2(168),2)
call HG1shiftOLR(G1H2(164),4,2)
call Hotf_5pt_reduction(G2H2(51),RedSet_5(36),mass5set(:,8),  & 
G1H2(169),G1H2(170),G1H2(171),G1H2(172),G1H2(173),G1H2(174),2)
call HG1shiftOLR(G1H2(170),8,2)
call Hotf_5pt_reduction(G2H2(54),RedSet_5(44),mass5set(:,8),  & 
G1H2(175),G1H2(176),G1H2(177),G1H2(178),G1H2(179),G1H2(180),2)
call HG1shiftOLR(G1H2(176),8,2)
call Hotf_5pt_reduction(G2H4(98),RedSet_5(37),mass5set(:,7),  & 
G1H4(365),G1H4(366),G1H4(367),G1H4(368),G1H4(369),G1H4(370),4)
call HG1shiftOLR(G1H4(366),16,4)
call Hotf_5pt_reduction(G2H4(102),RedSet_5(70),mass5set(:,5),  & 
G1H4(371),G1H4(372),G1H4(373),G1H4(374),G1H4(375),G1H4(376),4)
call HG1shiftOLR(G1H4(372),16,4)
call Hotf_5pt_reduction(G2H4(103),RedSet_5(38),mass5set(:,7),  & 
G1H4(377),G1H4(378),G1H4(379),G1H4(380),G1H4(381),G1H4(382),4)
call HG1shiftOLR(G1H4(378),8,4)
call Hotf_5pt_reduction(G2H4(106),RedSet_5(72),mass5set(:,5),  & 
G1H4(383),G1H4(384),G1H4(385),G1H4(386),G1H4(387),G1H4(388),4)
call HG1shiftOLR(G1H4(384),8,4)
call Hotf_5pt_reduction(G2H2(55),RedSet_5(32),mass5set(:,8),  & 
G1H2(181),G1H2(182),G1H2(183),G1H2(184),G1H2(185),G1H2(186),2)
call HG1shiftOLR(G1H2(182),4,2)
call Hotf_5pt_reduction(G2H2(57),RedSet_5(77),mass5set(:,8),  & 
G1H2(187),G1H2(188),G1H2(189),G1H2(190),G1H2(191),G1H2(192),2)
call HG1shiftOLR(G1H2(188),4,2)
call Hotf_5pt_reduction(G2H2(58),RedSet_5(36),mass5set(:,8),  & 
G1H2(193),G1H2(194),G1H2(195),G1H2(196),G1H2(197),G1H2(198),2)
call HG1shiftOLR(G1H2(194),4,2)
call Hotf_5pt_reduction(G2H2(60),RedSet_5(76),mass5set(:,8),  & 
G1H2(199),G1H2(200),G1H2(201),G1H2(202),G1H2(203),G1H2(204),2)
call HG1shiftOLR(G1H2(200),4,2)
call Hotf_5pt_reduction(G2H2(61),RedSet_5(39),mass5set(:,8),  & 
G1H2(205),G1H2(206),G1H2(207),G1H2(208),G1H2(209),G1H2(210),2)
call HG1shiftOLR(G1H2(206),16,2)
call Hotf_5pt_reduction(G2H2(64),RedSet_5(58),mass5set(:,8),  & 
G1H2(211),G1H2(212),G1H2(213),G1H2(214),G1H2(215),G1H2(216),2)
call HG1shiftOLR(G1H2(212),16,2)
call Hotf_5pt_reduction(G2H2(65),RedSet_5(18),mass5set(:,9),  & 
G1H2(217),G1H2(218),G1H2(219),G1H2(220),G1H2(221),G1H2(222),2)
call HG1shiftOLR(G1H2(218),4,2)
call Hotf_5pt_reduction(G2H2(67),RedSet_5(78),mass5set(:,8),  & 
G1H2(223),G1H2(224),G1H2(225),G1H2(226),G1H2(227),G1H2(228),2)
call HG1shiftOLR(G1H2(224),4,2)
call Hotf_5pt_reduction(G2H2(68),RedSet_5(39),mass5set(:,8),  & 
G1H2(229),G1H2(230),G1H2(231),G1H2(232),G1H2(233),G1H2(234),2)
call HG1shiftOLR(G1H2(230),4,2)
call Hotf_5pt_reduction(G2H2(70),RedSet_5(78),mass5set(:,8),  & 
G1H2(235),G1H2(236),G1H2(237),G1H2(238),G1H2(239),G1H2(240),2)
call HG1shiftOLR(G1H2(236),4,2)
call Hotf_5pt_reduction(G2H2(71),RedSet_5(20),mass5set(:,9),  & 
G1H2(241),G1H2(242),G1H2(243),G1H2(244),G1H2(245),G1H2(246),2)
call HG1shiftOLR(G1H2(242),4,2)
call Hotf_5pt_reduction(G2H2(73),RedSet_5(79),mass5set(:,8),  & 
G1H2(247),G1H2(248),G1H2(249),G1H2(250),G1H2(251),G1H2(252),2)
call HG1shiftOLR(G1H2(248),4,2)
call Hotf_5pt_reduction(G2H2(74),RedSet_5(40),mass5set(:,8),  & 
G1H2(253),G1H2(254),G1H2(255),G1H2(256),G1H2(257),G1H2(258),2)
call HG1shiftOLR(G1H2(254),8,2)
call Hotf_5pt_reduction(G2H2(77),RedSet_5(61),mass5set(:,8),  & 
G1H2(259),G1H2(260),G1H2(261),G1H2(262),G1H2(263),G1H2(264),2)
call HG1shiftOLR(G1H2(260),8,2)
call Hotf_5pt_reduction(G2H2(78),RedSet_5(40),mass5set(:,8),  & 
G1H2(265),G1H2(266),G1H2(267),G1H2(268),G1H2(269),G1H2(270),2)
call HG1shiftOLR(G1H2(266),4,2)
call Hotf_5pt_reduction(G2H2(80),RedSet_5(79),mass5set(:,8),  & 
G1H2(271),G1H2(272),G1H2(273),G1H2(274),G1H2(275),G1H2(276),2)
call HG1shiftOLR(G1H2(272),4,2)
  call Hloop_QA_V(ntryL,G2H4(107),ex2(:),G2H2(1),m3h2x2(:,125),heltab2x4(:,:,205))
  call Hloop_QA_V(ntryL,G2H4(115),ex2(:),G2H2(4),m3h2x2(:,126),heltab2x4(:,:,206))
  call Hloop_QA_V(ntryL,G2H4(119),ex2(:),G2H2(7),m3h2x2(:,127),heltab2x4(:,:,207))
  call Hloop_AQ_V(ntryL,G2H4(120),ex1(:),G2H2(10),m3h2x2(:,128),heltab2x4(:,:,208))
  call Hloop_AQ_V(ntryL,G2H4(122),ex1(:),G2H2(11),m3h2x2(:,129),heltab2x4(:,:,209))
  call Hloop_AQ_V(ntryL,G2H4(126),ex1(:),G2H2(14),m3h2x2(:,130),heltab2x4(:,:,210))
  call Hloop_AQ_V(ntryL,G2H4(127),ex1(:),G2H2(15),m3h2x2(:,131),heltab2x4(:,:,211))
  call Hloop_AQ_V(ntryL,G2H4(129),ex1(:),G2H2(17),m3h2x2(:,132),heltab2x4(:,:,212))
  call Hloop_AQ_V(ntryL,G2H4(133),ex1(:),G2H2(18),m3h2x2(:,133),heltab2x4(:,:,213))
  call Hloop_AQ_V(ntryL,G2H4(134),ex1(:),G2H2(21),m3h2x2(:,134),heltab2x4(:,:,214))
  call Hloop_AQ_V(ntryL,G2H4(136),ex1(:),G2H2(22),m3h2x2(:,135),heltab2x4(:,:,215))
  call Hloop_AQ_V(ntryL,G2H4(140),ex1(:),G2H2(24),m3h2x2(:,136),heltab2x4(:,:,216))
  call Hloop_QA_V(ntryL,G2H4(141),ex2(:),G2H2(27),m3h2x2(:,137),heltab2x4(:,:,217))
  call Hloop_QA_V(ntryL,G2H4(144),ex2(:),G2H2(30),m3h2x2(:,138),heltab2x4(:,:,218))
  call Hloop_QA_V(ntryL,G2H4(150),ex2(:),G2H2(31),m3h2x2(:,139),heltab2x4(:,:,219))
  call Hloop_QA_V(ntryL,G2H4(151),ex2(:),G2H2(33),m3h2x2(:,140),heltab2x4(:,:,220))
  call Hloop_QA_V(ntryL,G2H4(154),ex2(:),G2H2(34),m3h2x2(:,141),heltab2x4(:,:,221))
  call Hloop_QA_V(ntryL,G2H4(160),ex2(:),G2H2(37),m3h2x2(:,142),heltab2x4(:,:,222))
call Hotf_5pt_reduction(G2H4(161),RedSet_5(14),mass5set(:,4),  & 
G1H4(389),G1H4(390),G1H4(391),G1H4(392),G1H4(393),G1H4(394),4)
call HG1shiftOLR(G1H4(390),2,4)
call Hotf_5pt_reduction(G2H4(163),RedSet_5(54),mass5set(:,4),  & 
G1H4(395),G1H4(396),G1H4(397),G1H4(398),G1H4(399),G1H4(400),4)
call HG1shiftOLR(G1H4(396),2,4)
call Hotf_4pt_reduction(G2H4(167),RedSet_4(1),mass4set(:,1),  & 
G1H4(401),G1H4(402),G1H4(403),G1H4(404),G1H4(405),4)
call HG1shiftOLR(G1H4(402),26,4)
call Hotf_5pt_reduction(G2H4(168),RedSet_5(13),mass5set(:,4),  & 
G1H4(406),G1H4(407),G1H4(408),G1H4(409),G1H4(410),G1H4(411),4)
call HG1shiftOLR(G1H4(407),2,4)
call Hotf_5pt_reduction(G2H4(170),RedSet_5(54),mass5set(:,4),  & 
G1H4(412),G1H4(413),G1H4(414),G1H4(415),G1H4(416),G1H4(417),4)
call HG1shiftOLR(G1H4(413),2,4)
call Hotf_4pt_reduction(G2H4(174),RedSet_4(1),mass4set(:,1),  & 
G1H4(418),G1H4(419),G1H4(420),G1H4(421),G1H4(422),4)
call HG1shiftOLR(G1H4(419),26,4)
  call Hloop_AQ_V(ntryL,G2H4(175),ex1(:),G2H2(38),m3h2x2(:,143),heltab2x4(:,:,223))
  call Hloop_AQ_V(ntryL,G2H4(178),ex1(:),G2H2(40),m3h2x2(:,144),heltab2x4(:,:,224))
  call Hloop_AQ_V(ntryL,G2H4(184),ex1(:),G2H2(41),m3h2x2(:,145),heltab2x4(:,:,225))
  call Hloop_AQ_V(ntryL,G2H4(185),ex1(:),G2H2(44),m3h2x2(:,146),heltab2x4(:,:,226))
  call Hloop_AQ_V(ntryL,G2H4(188),ex1(:),G2H2(45),m3h2x2(:,147),heltab2x4(:,:,227))
  call Hloop_AQ_V(ntryL,G2H4(194),ex1(:),G2H2(47),m3h2x2(:,148),heltab2x4(:,:,228))
  call Hloop_QA_V(ntryL,G2H4(195),ex2(:),G2H2(48),m3h2x2(:,149),heltab2x4(:,:,229))
  call Hloop_QA_V(ntryL,G2H4(197),ex2(:),G2H2(50),m3h2x2(:,150),heltab2x4(:,:,230))
  call Hloop_QA_V(ntryL,G2H4(201),ex2(:),G2H2(51),m3h2x2(:,151),heltab2x4(:,:,231))
call Hotf_5pt_reduction(G2H2(96),RedSet_5(18),mass5set(:,4),  & 
G1H2(277),G1H2(278),G1H2(279),G1H2(280),G1H2(281),G1H2(282),2)
call HG1shiftOLR(G1H2(278),2,2)
call Hotf_5pt_reduction(G2H2(98),RedSet_5(60),mass5set(:,4),  & 
G1H2(283),G1H2(284),G1H2(285),G1H2(286),G1H2(287),G1H2(288),2)
call HG1shiftOLR(G1H2(284),2,2)
call Hotf_4pt_reduction(G2H2(102),RedSet_4(2),mass4set(:,1),  & 
G1H2(289),G1H2(290),G1H2(291),G1H2(292),G1H2(293),2)
call HG1shiftOLR(G1H2(290),22,2)
call Hotf_5pt_reduction(G2H4(202),RedSet_5(17),mass5set(:,4),  & 
G1H4(423),G1H4(424),G1H4(425),G1H4(426),G1H4(427),G1H4(428),4)
call HG1shiftOLR(G1H4(424),2,4)
call Hotf_5pt_reduction(G2H4(204),RedSet_5(60),mass5set(:,4),  & 
G1H4(429),G1H4(430),G1H4(431),G1H4(432),G1H4(433),G1H4(434),4)
call HG1shiftOLR(G1H4(430),2,4)
call Hotf_4pt_reduction(G2H4(208),RedSet_4(2),mass4set(:,1),  & 
G1H4(435),G1H4(436),G1H4(437),G1H4(438),G1H4(439),4)
call HG1shiftOLR(G1H4(436),22,4)
  call Hloop_QA_V(ntryL,G2H4(209),ex2(:),G2H2(54),m3h2x2(:,152),heltab2x4(:,:,232))
  call Hloop_QA_V(ntryL,G2H4(211),ex2(:),G2H2(55),m3h2x2(:,153),heltab2x4(:,:,233))
  call Hloop_QA_V(ntryL,G2H4(215),ex2(:),G2H2(57),m3h2x2(:,154),heltab2x4(:,:,234))
call Hotf_5pt_reduction(G2H2(106),RedSet_5(20),mass5set(:,4),  & 
G1H2(294),G1H2(295),G1H2(296),G1H2(297),G1H2(298),G1H2(299),2)
call HG1shiftOLR(G1H2(295),2,2)
call Hotf_5pt_reduction(G2H2(108),RedSet_5(62),mass5set(:,4),  & 
G1H2(300),G1H2(301),G1H2(302),G1H2(303),G1H2(304),G1H2(305),2)
call HG1shiftOLR(G1H2(301),2,2)
call Hotf_4pt_reduction(G2H2(112),RedSet_4(3),mass4set(:,1),  & 
G1H2(306),G1H2(307),G1H2(308),G1H2(309),G1H2(310),2)
call HG1shiftOLR(G1H2(307),14,2)
call Hotf_5pt_reduction(G2H4(216),RedSet_5(19),mass5set(:,4),  & 
G1H4(440),G1H4(441),G1H4(442),G1H4(443),G1H4(444),G1H4(445),4)
call HG1shiftOLR(G1H4(441),2,4)
call Hotf_5pt_reduction(G2H4(218),RedSet_5(62),mass5set(:,4),  & 
G1H4(446),G1H4(447),G1H4(448),G1H4(449),G1H4(450),G1H4(451),4)
call HG1shiftOLR(G1H4(447),2,4)
call Hotf_4pt_reduction(G2H4(222),RedSet_4(3),mass4set(:,1),  & 
G1H4(452),G1H4(453),G1H4(454),G1H4(455),G1H4(456),4)
call HG1shiftOLR(G1H4(453),14,4)
  call ol_merge(ntryL,G1H4(143),[G1H4(140)])
  call ol_merge(ntryL,G1H4(161),[G1H4(158)])
  call ol_merge(ntryL,G1H4(174),[G1H4(186)])
  call ol_merge(ntryL,G1H4(193),[G1H4(14)])
  call ol_merge(ntryL,G1H4(199),[G1H4(19)])
  call ol_merge(ntryL,G1H4(212),[G1H4(24)])
  call ol_merge(ntryL,G1H4(224),[G1H4(30)])
  call ol_merge(ntryL,G1H4(36),[G1H4(35)])
  call ol_merge(ntryL,G1H4(49),[G1H4(48)])
  call ol_merge(ntryL,G1H4(67),[G1H4(66)])
  call ol_merge(ntryL,G1H2(19),[G1H2(18)])
  call ol_merge(ntryL,G1H4(85),[G1H4(84)])
  call ol_merge(ntryL,G1H4(245),[G1H4(242)])
  call ol_merge(ntryL,G1H4(265),[G1H4(259)])
  call ol_merge(ntryL,G1H4(283),[G1H4(103)])
  call ol_merge(ntryL,G1H2(31),[G1H2(30)])
  call ol_merge(ntryL,G1H4(289),[G1H4(110)])
  call ol_merge(ntryL,G1H2(43),[G1H2(42)])
  call ol_merge(ntryL,G1H2(55),[G1H2(54)])
  call ol_merge(ntryL,G1H4(302),[G1H4(119)])
  call ol_merge(ntryL,G1H2(67),[G1H2(66)])
  call ol_merge(ntryL,G1H2(79),[G1H2(78)])
  call ol_merge(ntryL,G1H4(320),[G1H4(318)])
  call ol_merge(ntryL,G1H4(127),[G1H4(335)])
  call ol_merge(ntryL,G1H2(91),[G1H2(90)])
  call ol_merge(ntryL,G1H2(103),[G1H2(102)])
  call ol_merge(ntryL,G1H2(115),[G1H2(114)])
  call ol_merge(ntryL,G1H2(127),[G1H2(126)])
  call ol_merge(ntryL,G1H4(347),[G1H4(346)])
  call ol_merge(ntryL,G1H2(139),[G1H2(138)])
  call ol_merge(ntryL,G1H2(151),[G1H2(150)])
  call ol_merge(ntryL,G1H4(359),[G1H4(358)])
  call ol_merge(ntryL,G1H2(163),[G1H2(162)])
  call ol_merge(ntryL,G1H2(175),[G1H2(174)])
  call ol_merge(ntryL,G1H4(371),[G1H4(370)])
  call ol_merge(ntryL,G1H4(383),[G1H4(382)])
  call ol_merge(ntryL,G1H2(187),[G1H2(186)])
  call ol_merge(ntryL,G1H2(199),[G1H2(198)])
  call ol_merge(ntryL,G1H2(211),[G1H2(210)])
  call ol_merge(ntryL,G1H2(223),[G1H2(222)])
  call ol_merge(ntryL,G1H2(235),[G1H2(234)])
  call ol_merge(ntryL,G1H2(247),[G1H2(246)])
  call ol_merge(ntryL,G1H2(259),[G1H2(258)])
  call ol_merge(ntryL,G1H2(271),[G1H2(270)])
  call ol_merge(ntryL,G1H4(395),[G1H4(394)])
  call ol_merge(ntryL,G1H4(401),[G1H4(400)])
  call ol_merge(ntryL,G1H4(412),[G1H4(411)])
  call ol_merge(ntryL,G1H4(418),[G1H4(417)])
  call ol_merge(ntryL,G1H2(283),[G1H2(282)])
  call ol_merge(ntryL,G1H2(289),[G1H2(288)])
  call ol_merge(ntryL,G1H4(429),[G1H4(428)])
  call ol_merge(ntryL,G1H4(435),[G1H4(434)])
  call ol_merge(ntryL,G1H2(300),[G1H2(299)])
  call ol_merge(ntryL,G1H2(306),[G1H2(305)])
  call ol_merge(ntryL,G1H4(446),[G1H4(445)])
  call ol_merge(ntryL,G1H4(452),[G1H4(451)])
  call Hloop_VA_Q(ntryL,G1H4(133),ex2(:),G1H2(18),m3h2x2(:,155),heltab2x4(:,:,235))
  call Hloop_A_Q(ntryL,G1H2(18),47,nMT,G2H2(58),n2h2(69))
call HGT_OLR(G1H4(134),1,1,4)
call HGT_invQ_OLR(G1H4(134),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(134),-16,nMT,G2H4(1),n2h4(231))
  call Hloop_QV_A(ntryL,G2H4(1),ex5(:),G2H2(60),m3h2x2(:,156),heltab2x4(:,:,236))
  call Hloop_VA_Q(ntryL,G1H4(143),ex2(:),G1H2(30),m3h2x2(:,157),heltab2x4(:,:,237))
  call Hloop_A_Q(ntryL,G1H2(30),47,nMT,G2H2(61),n2h2(70))
call HGT_OLR(G1H4(144),1,1,4)
call HGT_invQ_OLR(G1H4(144),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(144),-16,nMT,G2H4(3),n2h4(232))
  call Hloop_QV_A(ntryL,G2H4(3),ex5(:),G2H2(64),m3h2x2(:,158),heltab2x4(:,:,238))
  call Hloop_VA_Q(ntryL,G1H4(150),ex2(:),G1H2(42),m3h2x2(:,159),heltab2x4(:,:,239))
  call Hloop_A_Q(ntryL,G1H2(42),47,nMT,G2H2(65),n2h2(71))
  call Hloop_VA_Q(ntryL,G1H4(151),ex2(:),G1H2(54),m3h2x2(:,160),heltab2x4(:,:,240))
  call Hloop_A_Q(ntryL,G1H2(54),47,nMT,G2H2(67),n2h2(72))
call HGT_OLR(G1H4(152),1,1,4)
call HGT_invQ_OLR(G1H4(152),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(152),-16,nMT,G2H4(4),n2h4(233))
  call Hloop_QV_A(ntryL,G2H4(4),ex5(:),G2H2(68),m3h2x2(:,161),heltab2x4(:,:,241))
  call Hloop_VA_Q(ntryL,G1H4(161),ex2(:),G1H2(66),m3h2x2(:,162),heltab2x4(:,:,242))
  call Hloop_A_Q(ntryL,G1H2(66),47,nMT,G2H2(70),n2h2(73))
call HGT_OLR(G1H4(162),1,1,4)
call HGT_invQ_OLR(G1H4(162),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(162),-16,nMT,G2H4(6),n2h4(234))
  call Hloop_QV_A(ntryL,G2H4(6),ex5(:),G2H2(71),m3h2x2(:,163),heltab2x4(:,:,243))
  call Hloop_VA_Q(ntryL,G1H4(169),ex2(:),G1H2(78),m3h2x2(:,164),heltab2x4(:,:,244))
  call Hloop_A_Q(ntryL,G1H2(78),47,nMT,G2H2(73),n2h2(74))
  call Hloop_VQ_A(ntryL,G1H4(168),ex1(:),G1H2(90),m3h2x2(:,165),heltab2x4(:,:,245))
  call Hloop_Q_A(ntryL,G1H2(90),55,nMT,G2H2(74),n2h2(75))
call HGT_OLR(G1H4(175),1,1,4)
call HGT_invQ_OLR(G1H4(175),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(175),-8,nMT,G2H4(7),n2h4(235))
  call Hloop_AV_Q(ntryL,G2H4(7),ex4(:),G2H2(77),m3h2x2(:,166),heltab2x4(:,:,246))
  call Hloop_VQ_A(ntryL,G1H4(174),ex1(:),G1H2(102),m3h2x2(:,167),heltab2x4(:,:,247))
  call Hloop_Q_A(ntryL,G1H2(102),55,nMT,G2H2(78),n2h2(76))
call HGT_OLR(G1H4(203),1,1,4)
call HGT_invQ_OLR(G1H4(203),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(203),-8,nMT,G2H4(9),n2h4(236))
  call Hloop_AV_Q(ntryL,G2H4(9),ex4(:),G2H2(80),m3h2x2(:,168),heltab2x4(:,:,248))
  call Hloop_VQ_A(ntryL,G1H4(180),ex1(:),G1H2(114),m3h2x2(:,169),heltab2x4(:,:,249))
  call Hloop_Q_A(ntryL,G1H2(114),55,nMT,G2H2(96),n2h2(77))
  call Hloop_VQ_A(ntryL,G1H4(13),ex1(:),G1H2(126),m3h2x2(:,170),heltab2x4(:,:,250))
  call Hloop_Q_A(ntryL,G1H2(126),47,nMT,G2H2(98),n2h2(78))
call HGT_OLR(G1H4(181),1,1,4)
call HGT_invQ_OLR(G1H4(181),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(181),-16,nMT,G2H4(10),n2h4(237))
  call Hloop_AV_Q(ntryL,G2H4(10),ex5(:),G2H2(102),m3h2x2(:,171),heltab2x4(:,:,251))
  call Hloop_VQ_A(ntryL,G1H4(193),ex1(:),G1H2(138),m3h2x2(:,172),heltab2x4(:,:,252))
  call Hloop_Q_A(ntryL,G1H2(138),47,nMT,G2H2(106),n2h2(79))
call HGT_OLR(G1H4(17),1,1,4)
call HGT_invQ_OLR(G1H4(17),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(17),-16,nMT,G2H4(12),n2h4(238))
  call Hloop_AV_Q(ntryL,G2H4(12),ex5(:),G2H2(108),m3h2x2(:,173),heltab2x4(:,:,253))
  call Hloop_VQ_A(ntryL,G1H4(192),ex1(:),G1H2(150),m3h2x2(:,174),heltab2x4(:,:,254))
  call Hloop_Q_A(ntryL,G1H2(150),47,nMT,G2H2(112),n2h2(80))
  call Hloop_VQ_A(ntryL,G1H4(18),ex1(:),G1H2(162),m3h2x2(:,175),heltab2x4(:,:,255))
  call Hloop_Q_A(ntryL,G1H2(162),47,nMT,G2H2(113),n2h2(81))
call HGT_OLR(G1H4(194),1,1,4)
call HGT_invQ_OLR(G1H4(194),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(194),-16,nMT,G2H4(13),n2h4(239))
  call Hloop_AV_Q(ntryL,G2H4(13),ex5(:),G2H2(114),m3h2x2(:,176),heltab2x4(:,:,256))
  call Hloop_VQ_A(ntryL,G1H4(199),ex1(:),G1H2(174),m3h2x2(:,177),heltab2x4(:,:,257))
  call Hloop_Q_A(ntryL,G1H2(174),47,nMT,G2H2(115),n2h2(82))
call HGT_OLR(G1H4(240),1,1,4)
call HGT_invQ_OLR(G1H4(240),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(240),-16,nMT,G2H4(15),n2h4(240))
  call Hloop_AV_Q(ntryL,G2H4(15),ex5(:),G2H2(116),m3h2x2(:,178),heltab2x4(:,:,258))
  call Hloop_VQ_A(ntryL,G1H4(211),ex1(:),G1H2(186),m3h2x2(:,179),heltab2x4(:,:,259))
  call Hloop_Q_A(ntryL,G1H2(186),47,nMT,G2H2(117),n2h2(83))
  call Hloop_VA_Q(ntryL,G1H4(23),ex2(:),G1H2(198),m3h2x2(:,180),heltab2x4(:,:,260))
  call Hloop_A_Q(ntryL,G1H2(198),55,nMT,G2H2(118),n2h2(84))
call HGT_OLR(G1H4(206),1,1,4)
call HGT_invQ_OLR(G1H4(206),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(206),-8,nMT,G2H4(16),n2h4(241))
  call Hloop_QV_A(ntryL,G2H4(16),ex4(:),G2H2(119),m3h2x2(:,181),heltab2x4(:,:,261))
  call Hloop_VA_Q(ntryL,G1H4(212),ex2(:),G1H2(210),m3h2x2(:,182),heltab2x4(:,:,262))
  call Hloop_A_Q(ntryL,G1H2(210),55,nMT,G2H2(120),n2h2(85))
call HGT_OLR(G1H4(215),1,1,4)
call HGT_invQ_OLR(G1H4(215),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(215),-8,nMT,G2H4(18),n2h4(242))
  call Hloop_QV_A(ntryL,G2H4(18),ex4(:),G2H2(121),m3h2x2(:,183),heltab2x4(:,:,263))
  call Hloop_VA_Q(ntryL,G1H4(217),ex2(:),G1H2(222),m3h2x2(:,184),heltab2x4(:,:,264))
  call Hloop_A_Q(ntryL,G1H2(222),55,nMT,G2H2(122),n2h2(86))
  call Hloop_UV_W(ntryL,G1H4(26),39,ex4(:),8,G2H2(123),m3h2x2(:,185),heltab2x4(:,:,265))
call HGT_raise_alpha_OLR(G1H4(218),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(218),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(218),-16,ex5(:),16,G2H2(124),m3h2x2(:,186),heltab2x4(:,:,266))
call signflip_OLR(G2H2(124))
  call Hloop_UV_W(ntryL,G1H4(224),39,ex4(:),8,G2H2(125),m3h2x2(:,187),heltab2x4(:,:,267))
call HGT_raise_alpha_OLR(G1H4(227),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(227),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(227),-16,ex5(:),16,G2H2(126),m3h2x2(:,188),heltab2x4(:,:,268))
call signflip_OLR(G2H2(126))
  call Hloop_UV_W(ntryL,G1H4(230),39,ex4(:),8,G2H2(127),m3h2x2(:,189),heltab2x4(:,:,269))
  call Hloop_UV_W(ntryL,G1H4(233),39,ex5(:),16,G2H2(128),m3h2x2(:,190),heltab2x4(:,:,270))
call HGT_raise_alpha_OLR(G1H4(293),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(293),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(293),-8,ex4(:),8,G2H2(129),m3h2x2(:,191),heltab2x4(:,:,271))
call signflip_OLR(G2H2(129))
  call Hloop_UV_W(ntryL,G1H4(36),39,ex5(:),16,G2H2(130),m3h2x2(:,192),heltab2x4(:,:,272))
call HGT_raise_alpha_OLR(G1H4(37),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(37),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(37),-8,ex4(:),8,G2H2(131),m3h2x2(:,193),heltab2x4(:,:,273))
call signflip_OLR(G2H2(131))
  call Hloop_UV_W(ntryL,G1H4(294),39,ex5(:),16,G2H2(132),m3h2x2(:,194),heltab2x4(:,:,274))
  call Hloop_UV_W(ntryL,G1H4(311),39,ex4(:),8,G2H2(133),m3h2x2(:,195),heltab2x4(:,:,275))
call HGT_raise_alpha_OLR(G1H4(312),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(312),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(312),-16,ex5(:),16,G2H2(134),m3h2x2(:,196),heltab2x4(:,:,276))
call signflip_OLR(G2H2(134))
  call Hloop_UV_W(ntryL,G1H4(49),39,ex4(:),8,G2H2(135),m3h2x2(:,197),heltab2x4(:,:,277))
call HGT_raise_alpha_OLR(G1H4(53),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(53),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(53),-16,ex5(:),16,G2H2(136),m3h2x2(:,198),heltab2x4(:,:,278))
call signflip_OLR(G2H2(136))
  call Hloop_UV_W(ntryL,G1H4(330),39,ex4(:),8,G2H2(137),m3h2x2(:,199),heltab2x4(:,:,279))
  call Hloop_UV_W(ntryL,G1H4(60),39,ex5(:),16,G2H2(138),m3h2x2(:,200),heltab2x4(:,:,280))
call HGT_raise_alpha_OLR(G1H4(7),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(7),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(7),-8,ex4(:),8,G2H2(139),m3h2x2(:,201),heltab2x4(:,:,281))
call signflip_OLR(G2H2(139))
  call Hloop_UV_W(ntryL,G1H4(67),39,ex5(:),16,G2H2(140),m3h2x2(:,202),heltab2x4(:,:,282))
call HGT_raise_alpha_OLR(G1H4(68),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(68),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(68),-8,ex4(:),8,G2H2(141),m3h2x2(:,203),heltab2x4(:,:,283))
call signflip_OLR(G2H2(141))
  call Hloop_UV_W(ntryL,G1H4(74),39,ex5(:),16,G2H2(142),m3h2x2(:,204),heltab2x4(:,:,284))
  call Hloop_QS_A(ntryL,G1H2(13),ex3(:),G1H2(234),ngH,m3h1x2(:,1),heltab2x2(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(234),47,nMT,G2H2(143),n2h2(87))
call HGT_OLR(G1H2(14),1,1,2)
call HGT_invQ_OLR(G1H2(14),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(14),-16,nMT,G2H2(144),n2h2(88))
  call Hloop_AV_Q(ntryL,G2H2(144),ex5(:),G2H1(1),m3h2x1(:,1),heltab2x2(:,:,2))
  call Hloop_QS_A(ntryL,G1H2(19),ex3(:),G1H2(246),ngH,m3h1x2(:,2),heltab2x2(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(246),47,nMT,G2H2(144),n2h2(89))
call HGT_OLR(G1H2(20),1,1,2)
call HGT_invQ_OLR(G1H2(20),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(20),-16,nMT,G2H2(145),n2h2(90))
  call Hloop_AV_Q(ntryL,G2H2(145),ex5(:),G2H1(2),m3h2x1(:,2),heltab2x2(:,:,4))
  call Hloop_QS_A(ntryL,G1H2(24),ex3(:),G1H2(258),ngH,m3h1x2(:,3),heltab2x2(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(258),47,nMT,G2H2(145),n2h2(91))
  call Hloop_AV_Q(ntryL,G1H4(77),ex4(:),G1H2(270),m3h2x2(:,205),heltab2x4(:,:,285))
  call Hloop_A_Q(ntryL,G1H2(270),47,nMT,G2H2(146),n2h2(92))
call HGT_OLR(G1H4(78),1,1,4)
call HGT_invQ_OLR(G1H4(78),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(78),-16,nMT,G2H4(19),n2h4(251))
  call Hloop_QV_A(ntryL,G2H4(19),ex5(:),G2H2(147),m3h2x2(:,206),heltab2x4(:,:,286))
  call Hloop_AV_Q(ntryL,G1H4(85),ex4(:),G1H2(282),m3h2x2(:,207),heltab2x4(:,:,287))
  call Hloop_A_Q(ntryL,G1H2(282),47,nMT,G2H2(148),n2h2(93))
call HGT_OLR(G1H4(86),1,1,4)
call HGT_invQ_OLR(G1H4(86),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(86),-16,nMT,G2H4(21),n2h4(252))
  call Hloop_QV_A(ntryL,G2H4(21),ex5(:),G2H2(149),m3h2x2(:,208),heltab2x4(:,:,288))
  call Hloop_AV_Q(ntryL,G1H4(91),ex4(:),G1H2(288),m3h2x2(:,209),heltab2x4(:,:,289))
  call Hloop_A_Q(ntryL,G1H2(288),47,nMT,G2H2(150),n2h2(94))
  call Hloop_AV_Q(ntryL,G1H4(236),ex5(:),G1H2(299),m3h2x2(:,210),heltab2x4(:,:,290))
  call Hloop_A_Q(ntryL,G1H2(299),55,nMT,G2H2(151),n2h2(95))
call HGT_OLR(G1H4(241),1,1,4)
call HGT_invQ_OLR(G1H4(241),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(241),-8,nMT,G2H4(22),n2h4(253))
  call Hloop_QV_A(ntryL,G2H4(22),ex4(:),G2H2(152),m3h2x2(:,211),heltab2x4(:,:,291))
  call Hloop_AV_Q(ntryL,G1H4(245),ex5(:),G1H2(305),m3h2x2(:,212),heltab2x4(:,:,292))
  call Hloop_A_Q(ntryL,G1H2(305),55,nMT,G2H2(153),n2h2(96))
call HGT_OLR(G1H4(96),1,1,4)
call HGT_invQ_OLR(G1H4(96),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(96),-8,nMT,G2H4(24),n2h4(254))
  call Hloop_QV_A(ntryL,G2H4(24),ex4(:),G2H2(154),m3h2x2(:,213),heltab2x4(:,:,293))
  call Hloop_AV_Q(ntryL,G1H4(251),ex5(:),G1H2(18),m3h2x2(:,214),heltab2x4(:,:,294))
  call Hloop_A_Q(ntryL,G1H2(18),55,nMT,G2H2(155),n2h2(97))
  call Hloop_QV_A(ntryL,G1H4(98),ex4(:),G1H2(30),m3h2x2(:,215),heltab2x4(:,:,295))
  call Hloop_Q_A(ntryL,G1H2(30),47,nMT,G2H2(156),n2h2(98))
call HGT_OLR(G1H4(252),1,1,4)
call HGT_invQ_OLR(G1H4(252),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(252),-16,nMT,G2H4(25),n2h4(255))
  call Hloop_AV_Q(ntryL,G2H4(25),ex5(:),G2H2(157),m3h2x2(:,216),heltab2x4(:,:,296))
  call Hloop_QV_A(ntryL,G1H4(265),ex4(:),G1H2(42),m3h2x2(:,217),heltab2x4(:,:,297))
  call Hloop_Q_A(ntryL,G1H2(42),47,nMT,G2H2(158),n2h2(99))
call HGT_OLR(G1H4(260),1,1,4)
call HGT_invQ_OLR(G1H4(260),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(260),-16,nMT,G2H4(29),n2h4(256))
  call Hloop_AV_Q(ntryL,G2H4(29),ex5(:),G2H2(159),m3h2x2(:,218),heltab2x4(:,:,298))
  call Hloop_QV_A(ntryL,G1H4(269),ex4(:),G1H2(54),m3h2x2(:,219),heltab2x4(:,:,299))
  call Hloop_Q_A(ntryL,G1H2(54),47,nMT,G2H2(160),n2h2(100))
  call Hloop_QV_A(ntryL,G1H4(270),ex5(:),G1H2(66),m3h2x2(:,220),heltab2x4(:,:,300))
  call Hloop_Q_A(ntryL,G1H2(66),55,nMT,G2H2(161),n2h2(101))
call HGT_OLR(G1H4(271),1,1,4)
call HGT_invQ_OLR(G1H4(271),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(271),-8,nMT,G2H4(32),n2h4(257))
  call Hloop_AV_Q(ntryL,G2H4(32),ex4(:),G2H2(162),m3h2x2(:,221),heltab2x4(:,:,301))
  call Hloop_QV_A(ntryL,G1H4(283),ex5(:),G1H2(78),m3h2x2(:,222),heltab2x4(:,:,302))
  call Hloop_Q_A(ntryL,G1H2(78),55,nMT,G2H2(163),n2h2(102))
call HGT_OLR(G1H4(104),1,1,4)
call HGT_invQ_OLR(G1H4(104),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(104),-8,nMT,G2H4(35),n2h4(258))
  call Hloop_AV_Q(ntryL,G2H4(35),ex4(:),G2H2(164),m3h2x2(:,223),heltab2x4(:,:,303))
  call Hloop_QV_A(ntryL,G1H4(282),ex5(:),G1H2(90),m3h2x2(:,224),heltab2x4(:,:,304))
  call Hloop_Q_A(ntryL,G1H2(90),55,nMT,G2H2(165),n2h2(103))
  call Hloop_AS_Q(ntryL,G1H2(25),ex3(:),G1H2(102),ngH,m3h1x2(:,4),heltab2x2(:,:,6))
  call Hloop_A_Q(ntryL,G1H2(102),47,nMT,G2H2(166),n2h2(104))
call HGT_OLR(G1H2(26),1,1,2)
call HGT_invQ_OLR(G1H2(26),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(26),-16,nMT,G2H2(167),n2h2(105))
  call Hloop_QV_A(ntryL,G2H2(167),ex5(:),G2H1(3),m3h2x1(:,3),heltab2x2(:,:,7))
  call Hloop_AS_Q(ntryL,G1H2(31),ex3(:),G1H2(114),ngH,m3h1x2(:,5),heltab2x2(:,:,8))
  call Hloop_A_Q(ntryL,G1H2(114),47,nMT,G2H2(167),n2h2(106))
call HGT_OLR(G1H2(32),1,1,2)
call HGT_invQ_OLR(G1H2(32),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(32),-16,nMT,G2H2(168),n2h2(107))
  call Hloop_QV_A(ntryL,G2H2(168),ex5(:),G2H1(4),m3h2x1(:,4),heltab2x2(:,:,9))
  call Hloop_AS_Q(ntryL,G1H2(36),ex3(:),G1H2(126),ngH,m3h1x2(:,6),heltab2x2(:,:,10))
  call Hloop_A_Q(ntryL,G1H2(126),47,nMT,G2H2(168),n2h2(108))
  call Hloop_QV_A(ntryL,G1H4(108),ex4(:),G1H2(138),m3h2x2(:,225),heltab2x4(:,:,305))
  call Hloop_Q_A(ntryL,G1H2(138),47,nMT,G2H2(169),n2h2(109))
call HGT_OLR(G1H4(284),1,1,4)
call HGT_invQ_OLR(G1H4(284),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(284),-16,nMT,G2H4(39),n2h4(259))
  call Hloop_AV_Q(ntryL,G2H4(39),ex5(:),G2H2(170),m3h2x2(:,226),heltab2x4(:,:,306))
  call Hloop_QV_A(ntryL,G1H4(289),ex4(:),G1H2(150),m3h2x2(:,227),heltab2x4(:,:,307))
  call Hloop_Q_A(ntryL,G1H2(150),47,nMT,G2H2(171),n2h2(110))
call HGT_OLR(G1H4(113),1,1,4)
call HGT_invQ_OLR(G1H4(113),2,5,4)



end subroutine vamp_1

end module ol_vamp_1_pphttj_ttxhggg_1_/**/REALKIND
