
module ol_colourmatrix_pphttj_ttxddxhg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(92,4), K2(4,4), KL(4,4)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  36,  12,  12,   0]
  K1( 2,:) = [  12,  36,   0,  12]
  K1( 3,:) = [  12,   0,  36,  12]
  K1( 4,:) = [   0,  12,  12,  36]
  K1( 5,:) = [  48,  16,  16,   0]
  K1( 6,:) = [  16,  48,   0,  16]
  K1( 7,:) = [  16,   0,  48,  16]
  K1( 8,:) = [   0,  16,  16,  48]
  K1( 9,:) = [   6,   2,   2,   0]
  K1(10,:) = [   2,   0,  -6, -16]
  K1(11,:) = [   2,  -6,   0, -16]
  K1(12,:) = [   0, -16, -16, -48]
  K1(13,:) = [  48,  16,  16,   0]
  K1(14,:) = [  16,  48,   0,  16]
  K1(15,:) = [  16,   0,  48,  16]
  K1(16,:) = [   0,  16,  16,  48]
  K1(17,:) = [   0,  16,  -2,   6]
  K1(18,:) = [  16,   0,   6,  -2]
  K1(19,:) = [  -2,   6,   0,  16]
  K1(20,:) = [   6,  -2,  16,   0]
  K1(21,:) = [   0,   2, -16,  -6]
  K1(22,:) = [   2,   6,   0,   2]
  K1(23,:) = [ -16,   0, -48, -16]
  K1(24,:) = [  -6,   2, -16,   0]
  K1(25,:) = [  48,  16,  16,   0]
  K1(26,:) = [  16,  48,   0,  16]
  K1(27,:) = [  16,   0,  48,  16]
  K1(28,:) = [   0,  16,  16,  48]
  K1(29,:) = [   0, -16,   2,  -6]
  K1(30,:) = [ -16, -48,   0, -16]
  K1(31,:) = [   2,   0,   6,   2]
  K1(32,:) = [  -6, -16,   2,   0]
  K1(33,:) = [   0,  -2,  16,   6]
  K1(34,:) = [  -2,   0,   6,  16]
  K1(35,:) = [  16,   6,   0,  -2]
  K1(36,:) = [   6,  16,  -2,   0]
  K1(37,:) = [ -48, -16, -16,   0]
  K1(38,:) = [ -16,   0,  -6,   2]
  K1(39,:) = [ -16,  -6,   0,   2]
  K1(40,:) = [   0,   2,   2,   6]
  K1(41,:) = [  48,  16,  16,   0]
  K1(42,:) = [  16,  48,   0,  16]
  K1(43,:) = [  16,   0,  48,  16]
  K1(44,:) = [   0,  16,  16,  48]
  K1(45,:) = [   0,   0,   0,   0]
  K1(46,:) = [   0,   0,   0,   0]
  K1(47,:) = [   0,   0,   0,   0]
  K1(48,:) = [   0,   0,   0,   0]
  K1(49,:) = [   0,   0,   0,   0]
  K1(50,:) = [   0,   0,   0,   0]
  K1(51,:) = [   0,   0,   0,   0]
  K1(52,:) = [   0,   0,   0,   0]
  K1(53,:) = [   0,   0,   0,   0]
  K1(54,:) = [   0,   0,   0,   0]
  K1(55,:) = [   0,   0,   0,   0]
  K1(56,:) = [   0,   0,   0,   0]
  K1(57,:) = [   0,   0,   0,   0]
  K1(58,:) = [   0,   0,   0,   0]
  K1(59,:) = [   0,   0,   0,   0]
  K1(60,:) = [   0,   0,   0,   0]
  K1(61,:) = [   0,   0,   0,   0]
  K1(62,:) = [   0,   0,   0,   0]
  K1(63,:) = [   0,   0,   0,   0]
  K1(64,:) = [   0,   0,   0,   0]
  K1(65,:) = [ -54, -18, -18,   0]
  K1(66,:) = [ -18,   0,   0,  18]
  K1(67,:) = [ -18,   0, -54, -18]
  K1(68,:) = [   0,  18, -18,   0]
  K1(69,:) = [ -54, -18, -18,   0]
  K1(70,:) = [ -18, -54,   0, -18]
  K1(71,:) = [ -18,   0,   0,  18]
  K1(72,:) = [   0, -18,  18,   0]
  K1(73,:) = [   0, -18,  18,   0]
  K1(74,:) = [ -18, -54,   0, -18]
  K1(75,:) = [  18,   0,   0, -18]
  K1(76,:) = [   0, -18, -18, -54]
  K1(77,:) = [   0,  18, -18,   0]
  K1(78,:) = [  18,   0,   0, -18]
  K1(79,:) = [ -18,   0, -54, -18]
  K1(80,:) = [   0, -18, -18, -54]
  K1(81,:) = [   0,   0,   0,   0]
  K1(82,:) = [   0,   0,   0,   0]
  K1(83,:) = [   0,   0,   0,   0]
  K1(84,:) = [   0,   0,   0,   0]
  K1(85,:) = [ 108,  36,  36,   0]
  K1(86,:) = [  36, 108,   0,  36]
  K1(87,:) = [  36,   0, 108,  36]
  K1(88,:) = [   0,  36,  36, 108]
  K1(89,:) = [   0,   0,   0,   0]
  K1(90,:) = [   0,   0,   0,   0]
  K1(91,:) = [   0,   0,   0,   0]
  K1(92,:) = [   0,   0,   0,   0]
  K1 = (1._/**/REALKIND / 3) * K1

  K2(1,:) = [ 12,  4,  4,  0]
  K2(2,:) = [  4, 12,  0,  4]
  K2(3,:) = [  4,  0, 12,  4]
  K2(4,:) = [  0,  4,  4, 12]

  KL(1,:) = [ 12,  4,  4,  0]
  KL(2,:) = [  4, 12,  0,  4]
  KL(3,:) = [  4,  0, 12,  4]
  KL(4,:) = [  0,  4,  4, 12]

  end subroutine colourmatrix_init
end module ol_colourmatrix_pphttj_ttxddxhg_1_/**/REALKIND



module ol_forced_parameters_pphttj_ttxddxhg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (YU /= 0) write(*,101) 'YU = 0'
  if (YD /= 0) write(*,101) 'YD = 0'
  if (YS /= 0) write(*,101) 'YS = 0'
  if (YC /= 0) write(*,101) 'YC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pphttj_ttxddxhg_1_/**/REALKIND
! **********************************************************************
module ol_loop_storage_pphttj_ttxddxhg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  
#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1, ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types 
  ! the following are flags for memory allocation of the hol coefficients in dp or qp 
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer(intkind2), parameter :: nheltot = 32 ! number of helicity configurations
  integer(intkind2), save :: nhel = 32 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(32) ! physical helicity states
#endif

  complex(REALKIND), save :: den(185)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(1), ex6(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf2(2,13), wf4(4,66), wf8(8,63), wf16(16,25), wf32(32,118)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(25), c(29)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(4,32)

end module ol_loop_storage_pphttj_ttxddxhg_1_/**/REALKIND






! **********************************************************************
module ol_loop_pphttj_ttxddxhg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2  
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_pphttj_ttxddxhg_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*countertermnorm*ctHGG*eQED*gQCD**5*MB*YB)/MQ2sum
    f( 2) = (countertermnorm*ctHGG*eQED*gQCD**5*MB*YB)/MQ2sum
    f( 3) = (CI*eQED*gQCD**5*integralnorm*SwF*YB)/(2._/**/REALKIND*MW*sw)
    f( 4) = (eQED*gQCD**5*integralnorm*SwF*YB)/(MW*sw*2._/**/REALKIND)
    f( 5) = (CI*countertermnorm*ctHGG*eQED*gQCD**5*MT*YT)/MQ2sum
    f( 6) = (countertermnorm*ctHGG*eQED*gQCD**5*MT*YT)/MQ2sum
    f( 7) = (CI*eQED*gQCD**3*YT)/(2._/**/REALKIND*MW*sw)
    f( 8) = (eQED*gQCD**3*YT)/(MW*sw*2._/**/REALKIND)
    f( 9) = (CI*countertermnorm*eQED*gQCD**5*YT)/(2._/**/REALKIND*MW*sw)
    f(10) = (countertermnorm*eQED*gQCD**5*YT)/(MW*sw*2._/**/REALKIND)
    f(11) = (CI*countertermnorm*ctGqq*eQED*gQCD**5*YT)/(2._/**/REALKIND*MW*sw)
    f(12) = (countertermnorm*ctGqq*eQED*gQCD**5*YT)/(MW*sw*2._/**/REALKIND)
    f(13) = (CI*countertermnorm*ctGtt*eQED*gQCD**5*YT)/(2._/**/REALKIND*MW*sw)
    f(14) = (countertermnorm*ctGtt*eQED*gQCD**5*YT)/(MW*sw*2._/**/REALKIND)
    f(15) = (CI*countertermnorm*ctStt*eQED*gQCD**5*YT)/(2._/**/REALKIND*MW*sw)
    f(16) = (countertermnorm*ctStt*eQED*gQCD**5*YT)/(MW*sw*2._/**/REALKIND)
    f(17) = (countertermnorm*ctVVV*eQED*gQCD**5*YT)/(MW*sw*2._/**/REALKIND)
    f(18) = (CI*eQED*gQCD**5*integralnorm*SwB*YT)/(4._/**/REALKIND*MW*sw)
    f(19) = (CI*eQED*gQCD**5*integralnorm*SwB*YT)/(2._/**/REALKIND*MW*sw)
    f(20) = (eQED*gQCD**5*integralnorm*SwB*YT)/(MW*sw*4._/**/REALKIND)
    f(21) = (eQED*gQCD**5*integralnorm*SwB*YT)/(MW*sw*2._/**/REALKIND)
    f(22) = (CI*eQED*gQCD**5*integralnorm*SwF*YT)/(2._/**/REALKIND*MW*sw)
    f(23) = (CI*eQED*gQCD**5*integralnorm*SwF*YT)/(MW*sw)
    f(24) = (eQED*gQCD**5*integralnorm*SwF*YT)/(MW*sw*2._/**/REALKIND)
    f(25) = (eQED*gQCD**5*integralnorm*SwF*YT)/(MW*sw)

  c = [ 9*CI*f(3), 3*f(4), 9*f(4), 27*CI*f(18), 54*CI*f(18), 3*CI*f(19), 9*CI*f(19), 24*CI*f(19), 27*CI*f(19), 54*CI*f(19) &
    , 18*f(20), 54*f(20), f(21), 3*f(21), 6*f(21), 8*f(21), 9*f(21), 10*f(21), 18*f(21), 21*f(21), 24*f(21), 27*f(21), 54*f(21) &
    , 9*CI*f(22), 9*CI*f(23), 3*f(24), 9*f(24), 3*f(25), 9*f(25) ]
  c = (1._/**/REALKIND / 36) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,17) - MT2)+L(6,17))
  den(2) = 1 /((L(5,34) - MT2)+L(6,34))
  den(3) = 1 /((L(5,12))+L(6,12))
  den(6) = 1 /((L(5,19))+L(6,19))
  den(9) = 1 /((L(5,14) - MT2)+L(6,14))
  den(12) = 1 /((L(5,33) - MT2)+L(6,33))
  den(13) = 1 /((L(5,18) - MT2)+L(6,18))
  den(18) = 1 /((L(5,13) - MT2)+L(6,13))
  den(23) = 1 /((L(5,36))+L(6,36))
  den(25) = 1 /((L(5,40))+L(6,40))
  den(29) = 1 /((L(5,3))+L(6,3))
  den(30) = 1 /((L(5,35))+L(6,35))
  den(33) = 1 /((L(5,44))+L(6,44))
  den(36) = 1 /((L(5,48))+L(6,48))
  den(43) = 1 /((L(5,7))+L(6,7))
  den(46) = 1 /((L(5,52))+L(6,52))
  den(54) = 1 /((L(5,49) - MT2)+L(6,49))
  den(65) = 1 /((L(5,50) - MT2)+L(6,50))
  den(73) = 1 /((L(5,46) - MT2)+L(6,46))
  den(77) = 1 /((L(5,29) - MT2)+L(6,29))
  den(80) = 1 /((L(5,51))+L(6,51))
  den(92) = 1 /((L(5,30) - MT2)+L(6,30))
  den(96) = 1 /((L(5,45) - MT2)+L(6,45))
  den(130) = 1 /((L(5,15))+L(6,15))
  den(133) = 1 /((L(5,11))+L(6,11))
  den(144) = 1 /((L(5,23))+L(6,23))
  den(146) = 1 /((L(5,27))+L(6,27))

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(1)*den(6)
  den(8) = den(3)*den(7)
  den(10) = den(3)*den(9)
  den(11) = den(1)*den(10)
  den(14) = den(12)*den(13)
  den(15) = den(3)*den(14)
  den(16) = den(6)*den(13)
  den(17) = den(3)*den(16)
  den(19) = den(3)*den(18)
  den(20) = den(13)*den(19)
  den(21) = den(10)*den(12)
  den(22) = den(2)*den(19)
  den(24) = den(7)*den(23)
  den(26) = den(7)*den(25)
  den(27) = den(16)*den(23)
  den(28) = den(16)*den(25)
  den(31) = den(29)*den(30)
  den(32) = den(3)*den(31)
  den(34) = den(3)*den(33)
  den(35) = den(29)*den(34)
  den(37) = den(3)*den(29)
  den(38) = den(36)*den(37)
  den(39) = den(23)*den(33)
  den(40) = den(29)*den(39)
  den(41) = den(25)*den(33)
  den(42) = den(29)*den(41)
  den(44) = den(29)*den(43)
  den(45) = den(36)*den(44)
  den(47) = den(36)*den(46)
  den(48) = den(29)*den(47)
  den(49) = den(12)*den(30)
  den(50) = den(3)*den(49)
  den(51) = den(2)*den(30)
  den(52) = den(3)*den(51)
  den(53) = den(19)*den(36)
  den(55) = den(36)*den(54)
  den(56) = den(3)*den(55)
  den(57) = den(1)*den(54)
  den(58) = den(3)*den(57)
  den(59) = den(1)*den(34)
  den(60) = den(12)*den(54)
  den(61) = den(3)*den(60)
  den(62) = den(1)*den(39)
  den(63) = den(1)*den(41)
  den(64) = den(13)*den(34)
  den(66) = den(13)*den(65)
  den(67) = den(3)*den(66)
  den(68) = den(2)*den(65)
  den(69) = den(3)*den(68)
  den(70) = den(13)*den(39)
  den(71) = den(13)*den(41)
  den(72) = den(2)*den(3)
  den(74) = den(72)*den(73)
  den(75) = den(1)*den(74)
  den(76) = den(1)*den(3)
  den(78) = den(76)*den(77)
  den(79) = den(2)*den(78)
  den(81) = den(4)*den(80)
  den(82) = den(3)*den(81)
  den(83) = den(1)**2
  den(84) = den(34)*den(83)
  den(85) = den(10)*den(83)
  den(86) = den(3)**2
  den(87) = den(57)*den(86)
  den(88) = den(7)*den(34)
  den(89) = den(10)*den(57)
  den(90) = den(7)*den(86)
  den(91) = den(3)*den(13)
  den(93) = den(91)*den(92)
  den(94) = den(12)*den(93)
  den(95) = den(3)*den(12)
  den(97) = den(95)*den(96)
  den(98) = den(13)*den(97)
  den(99) = den(14)*den(80)
  den(100) = den(3)*den(99)
  den(101) = den(13)**2
  den(102) = den(34)*den(101)
  den(103) = den(66)*den(86)
  den(104) = den(16)*den(34)
  den(105) = den(19)*den(66)
  den(106) = den(19)*den(101)
  den(107) = den(16)*den(86)
  den(108) = den(12)**2
  den(109) = den(10)*den(108)
  den(110) = den(60)*den(86)
  den(111) = den(10)*den(60)
  den(112) = den(68)*den(86)
  den(113) = den(19)*den(68)
  den(114) = den(2)**2
  den(115) = den(19)*den(114)
  den(116) = den(39)*den(83)
  den(117) = den(7)*den(39)
  den(118) = den(23)**2
  den(119) = den(7)*den(118)
  den(120) = den(41)*den(83)
  den(121) = den(7)*den(41)
  den(122) = den(25)**2
  den(123) = den(7)*den(122)
  den(124) = den(39)*den(101)
  den(125) = den(16)*den(39)
  den(126) = den(16)*den(118)
  den(127) = den(41)*den(101)
  den(128) = den(16)*den(41)
  den(129) = den(16)*den(122)
  den(131) = den(37)*den(130)
  den(132) = den(44)*den(130)
  den(134) = den(29)*den(133)
  den(135) = den(130)*den(134)
  den(136) = den(19)*den(130)
  den(137) = den(10)*den(130)
  den(138) = den(19)*den(77)
  den(139) = den(19)*den(96)
  den(140) = den(34)*den(96)
  den(141) = den(10)*den(92)
  den(142) = den(10)*den(73)
  den(143) = den(34)*den(73)
  den(145) = den(7)*den(144)
  den(147) = den(7)*den(146)
  den(148) = den(7)*den(80)
  den(149) = den(57)*den(80)
  den(150) = den(16)*den(144)
  den(151) = den(16)*den(146)
  den(152) = den(16)*den(80)
  den(153) = den(66)*den(80)
  den(154) = den(60)*den(80)
  den(155) = den(68)*den(80)
  den(156) = den(39)*den(96)
  den(157) = den(39)*den(73)
  den(158) = den(41)*den(96)
  den(159) = den(41)*den(73)
  den(160) = den(1)*den(2)*den(3)
  den(161) = den(3)*den(12)*den(13)
  den(162) = den(1)*den(23)
  den(163) = den(1)*den(25)
  den(164) = den(13)*den(23)
  den(165) = den(13)*den(25)
  den(166) = den(3)*den(148)
  den(167) = den(3)*den(149)
  den(168) = den(1)*den(142)
  den(169) = den(1)*den(143)
  den(170) = den(3)*den(152)
  den(171) = den(13)*den(139)
  den(172) = den(3)*den(153)
  den(173) = den(13)*den(140)
  den(174) = den(3)*den(154)
  den(175) = den(12)*den(141)
  den(176) = den(2)*den(138)
  den(177) = den(3)*den(155)
  den(178) = den(23)*den(147)
  den(179) = den(1)*den(157)
  den(180) = den(25)*den(145)
  den(181) = den(1)*den(159)
  den(182) = den(23)*den(151)
  den(183) = den(13)*den(156)
  den(184) = den(25)*den(150)
  den(185) = den(13)*den(158)

end subroutine denominators

!
!
!
!
!
! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_pphttj_ttxddxhg_1_/**/DREALKIND, only: ntry, nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for top anti-top down anti-down higgs glue -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_pphttj_ttxddxhg_1, only: external_perm_pphttj_ttxddxhg_1, &
    & external_perm_inv_pphttj_ttxddxhg_1, extcomb_perm_pphttj_ttxddxhg_1, &
    & average_factor_pphttj_ttxddxhg_1
  use ol_external_pphttj_ttxddxhg_1, only: H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_pphttj_ttxddxhg_1_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pphttj_ttxddxhg_1_/**/REALKIND, only: check_forced_parameters
  use ol_heltables_OLR_pphttj_ttxddxhg_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(22)
  logical, intent(in) :: qp_kinematics

  integer           :: shift, k, r, m, n
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(4), M2(4) 
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(4,32)
  type(Hpolcont) :: M1helarray_ct(4,32)

  type(Hpolcont) :: A(32,118)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(118)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMT, nMT, 0, 0, nMH, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_pphttj_ttxddxhg_1, 6, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMT, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rMT, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_S(P(:,5), rMH, H5, ex5, POLSEL(5),5)
  call pol_wf_V(P(:,6), rZERO, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QS_A(gH,ntry, ex1(:), ex5(:), wf2(:,1), n3(:,1), t3x2(:,:,1))
  call vert_AV_Q(ntry, ex2(:), ex6(:), wf4(:,1), n3(:,2), t3x4(:,:,1))
  call vert_QA_V(ntry, ex3(:), ex4(:), wf4(:,2), n3(:,3), t3x4(:,:,2))
  call prop_Q_A(ntry, wf2(:,1), 17, MT, 1_intkind1, wf2(:,2), n2(1))
  call prop_A_Q(ntry, wf4(:,1), 34, MT, 1_intkind1, wf4(:,3), n2(2))
  call vert_QA_V(ntry, wf2(:,2), wf4(:,3), wf8(:,1), n3(:,4), t3x8(:,:,1))
  call vert_QA_V(ntry, wf2(:,2), ex2(:), wf4(:,4), n3(:,5), t3x4(:,:,3))
  call vert_UV_W(ntry, wf4(:,2), 12, ex6(:), 32, wf8(:,2), n3(:,6), t3x8(:,:,2))
  call vert_AV_Q(ntry, ex2(:), wf4(:,2), wf8(:,3), n3(:,7), t3x8(:,:,3))
  call vert_VQ_A(ntry, ex6(:), wf2(:,2), wf4(:,5), n3(:,8), t3x4(:,:,4))
  call prop_A_Q(ntry, wf8(:,3), 14, MT, 1_intkind1, wf8(:,4), n2(3))
  call vert_VQ_A(ntry, ex6(:), ex1(:), wf4(:,6), n3(:,9), t3x4(:,:,5))
  call vert_SA_Q(gH,ntry, ex5(:), ex2(:), wf2(:,3), n3(:,10), t3x2(:,:,2))
  call prop_Q_A(ntry, wf4(:,6), 33, MT, 1_intkind1, wf4(:,7), n2(4))
  call prop_A_Q(ntry, wf2(:,3), 18, MT, 1_intkind1, wf2(:,4), n2(5))
  call vert_QA_V(ntry, wf4(:,7), wf2(:,4), wf8(:,5), n3(:,11), t3x8(:,:,4))
  call vert_QA_V(ntry, ex1(:), wf2(:,4), wf4(:,8), n3(:,12), t3x4(:,:,6))
  call vert_VQ_A(ntry, wf4(:,2), ex1(:), wf8(:,6), n3(:,13), t3x8(:,:,5))
  call vert_AV_Q(ntry, wf2(:,4), ex6(:), wf4(:,9), n3(:,14), t3x4(:,:,7))
  call prop_Q_A(ntry, wf8(:,6), 13, MT, 1_intkind1, wf8(:,7), n2(6))
  call vert_QS_A(gH,ntry, wf4(:,7), ex5(:), wf4(:,10), n3(:,15), t3x4(:,:,8))
  call vert_SA_Q(gH,ntry, ex5(:), wf4(:,3), wf4(:,11), n3(:,16), t3x4(:,:,9))
  call vert_VQ_A(ntry, ex6(:), ex3(:), wf4(:,12), n3(:,17), t3x4(:,:,10))
  call prop_Q_A(ntry, wf4(:,12), 36, ZERO, 0_intkind1, wf4(:,13), n2(7))
  call vert_QA_V(ntry, wf4(:,13), ex4(:), wf8(:,8), n3(:,18), t3x8(:,:,6))
  call vert_AV_Q(ntry, ex4(:), ex6(:), wf4(:,14), n3(:,19), t3x4(:,:,11))
  call prop_A_Q(ntry, wf4(:,14), 40, ZERO, 0_intkind1, wf4(:,15), n2(8))
  call vert_QA_V(ntry, ex3(:), wf4(:,15), wf8(:,9), n3(:,20), t3x8(:,:,7))
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,16), n3(:,21), t3x4(:,:,12))
  call vert_UV_W(ntry, wf4(:,16), 3, ex6(:), 32, wf8(:,10), n3(:,22), t3x8(:,:,8))
  call counter_SG_G(ntry, ex5(:), wf4(:,2), wf4(:,17), n3(:,23), t3x4(:,:,13))
  call counter_SG_G(ntry, ex5(:), wf4(:,16), wf4(:,18), n3(:,24), t3x4(:,:,14))
  call counter_SG_G(ntry, ex5(:), ex6(:), wf2(:,5), n3(:,25), t3x2(:,:,3))
  call vert_UV_W(ntry, wf4(:,16), 3, wf4(:,2), 12, wf16(:,1), n3(:,26), t3x16(:,:,1))
  call vert_VQ_A(ntry, wf4(:,16), ex3(:), wf8(:,11), n3(:,27), t3x8(:,:,9))
  call vert_AV_Q(ntry, ex4(:), wf2(:,5), wf4(:,19), n3(:,28), t3x4(:,:,15))
  call prop_Q_A(ntry, wf8(:,11), 7, ZERO, 0_intkind1, wf8(:,12), n2(9))
  call vert_VQ_A(ntry, wf2(:,5), ex3(:), wf4(:,20), n3(:,29), t3x4(:,:,16))
  call vert_AV_Q(ntry, ex4(:), wf4(:,16), wf8(:,13), n3(:,30), t3x8(:,:,10))
  call prop_Q_A(ntry, wf4(:,20), 52, ZERO, 0_intkind1, wf4(:,21), n2(10))
  call counter_QA_V(ntry, wf2(:,2), wf4(:,3), wf8(:,14), n3(:,31), t3x8(:,:,11))
  call counter_UV_W(ntry, wf4(:,2), 12, ex6(:), 32, wf8(:,15), n3(:,32), t3x8(:,:,12))
  call counter_VQ_A(ntry, ex6(:), wf2(:,2), wf4(:,22), n3(:,33), t3x4(:,:,17))
  call counter_QA_V(ntry, wf4(:,7), wf2(:,4), wf8(:,16), n3(:,34), t3x8(:,:,13))
  call counter_AV_Q(ntry, wf2(:,4), ex6(:), wf4(:,23), n3(:,35), t3x4(:,:,18))
  call vert_QA_V(ntry, wf4(:,7), ex2(:), wf8(:,17), n3(:,36), t3x8(:,:,14))
  call counter_QS_A(gH,ntry, wf4(:,7), ex5(:), wf4(:,24), n3(:,37), t3x4(:,:,19))
  call vert_QA_V(ntry, ex1(:), wf4(:,3), wf8(:,18), n3(:,38), t3x8(:,:,15))
  call counter_SA_Q(gH,ntry, ex5(:), wf4(:,3), wf4(:,25), n3(:,39), t3x4(:,:,20))
  call vert_AV_Q(ntry, ex2(:), wf2(:,5), wf4(:,26), n3(:,40), t3x4(:,:,21))
  call vert_VQ_A(ntry, wf2(:,5), ex1(:), wf4(:,27), n3(:,41), t3x4(:,:,22))
  call prop_Q_A(ntry, wf4(:,27), 49, MT, 1_intkind1, wf4(:,28), n2(11))
  call counter_QA_V(ntry, wf4(:,13), ex4(:), wf8(:,19), n3(:,42), t3x8(:,:,16))
  call counter_AV_Q(ntry, ex4(:), ex6(:), wf4(:,29), n3(:,43), t3x4(:,:,23))
  call prop_A_Q(ntry, wf4(:,29), 40, ZERO, 0_intkind1, wf4(:,30), n2(12))
  call vert_QA_V(ntry, ex3(:), wf4(:,30), wf8(:,20), n3(:,44), t3x8(:,:,17))
  call counter_QA_V(ntry, ex3(:), wf4(:,15), wf8(:,21), n3(:,45), t3x8(:,:,18))
  call counter_VQ_A(ntry, ex6(:), ex3(:), wf4(:,31), n3(:,46), t3x4(:,:,24))
  call prop_Q_A(ntry, wf4(:,31), 36, ZERO, 0_intkind1, wf4(:,32), n2(13))
  call vert_QA_V(ntry, wf4(:,32), ex4(:), wf8(:,22), n3(:,47), t3x8(:,:,19))
  call counter_QA_V(ntry, ex3(:), ex4(:), wf4(:,33), n3(:,48), t3x4(:,:,25))
  call vert_UV_W(ntry, wf4(:,33), 12, ex6(:), 32, wf8(:,23), n3(:,49), t3x8(:,:,20))
  call vert_AV_Q(ntry, ex2(:), wf4(:,33), wf8(:,24), n3(:,50), t3x8(:,:,21))
  call prop_A_Q(ntry, wf8(:,24), 14, MT, 1_intkind1, wf8(:,25), n2(14))
  call vert_VQ_A(ntry, wf4(:,33), ex1(:), wf8(:,26), n3(:,51), t3x8(:,:,22))
  call prop_Q_A(ntry, wf8(:,26), 13, MT, 1_intkind1, wf8(:,27), n2(15))
  call counter_AV_Q(ntry, ex2(:), wf4(:,2), wf8(:,28), n3(:,52), t3x8(:,:,23))
  call prop_Q_A(ntry, wf4(:,5), 49, MT, 1_intkind1, wf4(:,34), n2(16))
  call counter_QA_V(ntry, wf2(:,2), ex2(:), wf4(:,35), n3(:,53), t3x4(:,:,26))
  call counter_AV_Q(ntry, ex2(:), ex6(:), wf4(:,36), n3(:,54), t3x4(:,:,27))
  call prop_A_Q(ntry, wf4(:,36), 34, MT, 1_intkind1, wf4(:,37), n2(17))
  call vert_QA_V(ntry, wf2(:,2), wf4(:,37), wf8(:,29), n3(:,55), t3x8(:,:,24))
  call prop_Q_A(ntry, wf4(:,10), 49, MT, 1_intkind1, wf4(:,38), n2(18))
  call vert_SA_Q(gH,ntry, ex5(:), wf4(:,37), wf4(:,39), n3(:,56), t3x4(:,:,28))
  call counter_SA_Q(gH,ntry, ex5(:), ex2(:), wf2(:,6), n3(:,57), t3x2(:,:,4))
  call prop_A_Q(ntry, wf2(:,6), 18, MT, 1_intkind1, wf2(:,7), n2(19))
  call vert_QA_V(ntry, wf4(:,7), wf2(:,7), wf8(:,30), n3(:,58), t3x8(:,:,25))
  call vert_AV_Q(ntry, wf2(:,7), ex6(:), wf4(:,40), n3(:,59), t3x4(:,:,29))
  call vert_QA_V(ntry, ex1(:), wf2(:,7), wf4(:,41), n3(:,60), t3x4(:,:,30))
  call counter_QA_V(ntry, ex1(:), wf2(:,4), wf4(:,42), n3(:,61), t3x4(:,:,31))
  call counter_VQ_A(ntry, wf4(:,2), ex1(:), wf8(:,31), n3(:,62), t3x8(:,:,26))
  call prop_A_Q(ntry, wf4(:,9), 50, MT, 1_intkind1, wf4(:,43), n2(20))
  call counter_VQ_A(ntry, ex6(:), ex1(:), wf4(:,44), n3(:,63), t3x4(:,:,32))
  call prop_Q_A(ntry, wf4(:,44), 33, MT, 1_intkind1, wf4(:,45), n2(21))
  call vert_QA_V(ntry, wf4(:,45), wf2(:,4), wf8(:,32), n3(:,64), t3x8(:,:,27))
  call prop_A_Q(ntry, wf4(:,11), 50, MT, 1_intkind1, wf4(:,46), n2(22))
  call vert_QS_A(gH,ntry, wf4(:,45), ex5(:), wf4(:,47), n3(:,65), t3x4(:,:,33))
  call counter_QS_A(gH,ntry, ex1(:), ex5(:), wf2(:,8), n3(:,66), t3x2(:,:,5))
  call prop_Q_A(ntry, wf2(:,8), 17, MT, 1_intkind1, wf2(:,9), n2(23))
  call vert_QA_V(ntry, wf2(:,9), wf4(:,3), wf8(:,33), n3(:,67), t3x8(:,:,28))
  call vert_QA_V(ntry, wf2(:,9), ex2(:), wf4(:,48), n3(:,68), t3x4(:,:,34))
  call vert_VQ_A(ntry, ex6(:), wf2(:,9), wf4(:,49), n3(:,69), t3x4(:,:,35))
  call vert_AV_Q(ntry, wf4(:,3), wf4(:,2), wf16(:,2), n3(:,70), t3x16(:,:,2))
  call counter_Q_A(cttt,6,ntry, wf2(:,2), 17, wf2(:,10), n2(24))
  call prop_A_Q(ntry, wf16(:,2), 46, MT, 1_intkind1, wf16(:,3), n2(25))
  call vert_VQ_A(ntry, wf4(:,2), wf2(:,2), wf8(:,34), n3(:,71), t3x8(:,:,29))
  call counter_A_Q(cttt,6,ntry, wf4(:,3), 34, wf4(:,50), n2(26))
  call prop_Q_A(ntry, wf8(:,34), 29, MT, 1_intkind1, wf8(:,35), n2(27))
  call counter_V_V(ctGG,21,ntry, wf4(:,2), 12, wf4(:,51), n2(28))
  call prop_Q_A(ntry, wf2(:,10), 17, MT, 1_intkind1, wf2(:,11), n2(29))
  call vert_QA_V(ntry, wf2(:,11), ex2(:), wf4(:,52), n3(:,72), t3x4(:,:,36))
  call vert_VQ_A(ntry, ex6(:), wf2(:,11), wf4(:,53), n3(:,73), t3x4(:,:,37))
  call vert_AV_Q(ntry, ex2(:), wf4(:,51), wf8(:,36), n3(:,74), t3x8(:,:,30))
  call counter_V_V(ctGG,21,ntry, wf4(:,4), 19, wf4(:,54), n2(30))
  call counter_A_Q(cttt,6,ntry, wf8(:,4), 14, wf8(:,37), n2(31))
  call vert_UV_W(ntry, wf4(:,51), 12, ex6(:), 32, wf8(:,38), n3(:,75), t3x8(:,:,31))
  call vert_AV_Q(ntry, wf2(:,4), wf4(:,2), wf8(:,39), n3(:,76), t3x8(:,:,32))
  call counter_Q_A(cttt,6,ntry, wf4(:,7), 33, wf4(:,55), n2(32))
  call prop_A_Q(ntry, wf8(:,39), 30, MT, 1_intkind1, wf8(:,40), n2(33))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,7), wf16(:,4), n3(:,77), t3x16(:,:,3))
  call counter_A_Q(cttt,6,ntry, wf2(:,4), 18, wf2(:,12), n2(34))
  call prop_Q_A(ntry, wf16(:,4), 45, MT, 1_intkind1, wf16(:,5), n2(35))
  call prop_A_Q(ntry, wf2(:,12), 18, MT, 1_intkind1, wf2(:,13), n2(36))
  call vert_QA_V(ntry, ex1(:), wf2(:,13), wf4(:,56), n3(:,78), t3x4(:,:,38))
  call vert_VQ_A(ntry, wf4(:,51), ex1(:), wf8(:,41), n3(:,79), t3x8(:,:,33))
  call counter_V_V(ctGG,21,ntry, wf4(:,8), 19, wf4(:,57), n2(37))
  call counter_Q_A(cttt,6,ntry, wf8(:,7), 13, wf8(:,42), n2(38))
  call vert_AV_Q(ntry, wf2(:,13), ex6(:), wf4(:,58), n3(:,80), t3x4(:,:,39))
  call prop_Q_A(ntry, wf4(:,55), 33, MT, 1_intkind1, wf4(:,59), n2(39))
  call vert_QS_A(gH,ntry, wf4(:,59), ex5(:), wf4(:,60), n3(:,81), t3x4(:,:,40))
  call prop_A_Q(ntry, wf4(:,50), 34, MT, 1_intkind1, wf4(:,61), n2(40))
  call vert_SA_Q(gH,ntry, ex5(:), wf4(:,61), wf4(:,62), n3(:,82), t3x4(:,:,41))
  call counter_Q_A(ctqq,1,ntry, wf4(:,13), 36, wf4(:,63), n2(41))
  call prop_Q_A(ntry, wf4(:,63), 36, ZERO, 0_intkind1, wf4(:,64), n2(42))
  call vert_QA_V(ntry, wf4(:,64), ex4(:), wf8(:,43), n3(:,83), t3x8(:,:,34))
  call counter_A_Q(ctqq,1,ntry, wf4(:,15), 40, wf4(:,65), n2(43))
  call prop_A_Q(ntry, wf4(:,65), 40, ZERO, 0_intkind1, wf4(:,66), n2(44))
  call vert_QA_V(ntry, ex3(:), wf4(:,66), wf8(:,44), n3(:,84), t3x8(:,:,35))
  call vert_QA_V(ntry, wf8(:,12), ex4(:), wf16(:,6), n3(:,85), t3x16(:,:,4))
  call prop_A_Q(ntry, wf8(:,13), 11, ZERO, 0_intkind1, wf8(:,45), n2(45))
  call vert_QA_V(ntry, ex3(:), wf8(:,45), wf16(:,7), n3(:,86), t3x16(:,:,5))
  call vert_QA_V(ntry, wf8(:,7), ex2(:), wf16(:,8), n3(:,87), t3x16(:,:,6))
  call vert_QA_V(ntry, ex1(:), wf8(:,4), wf16(:,9), n3(:,88), t3x16(:,:,7))
  call vert_QS_A(gH,ntry, wf8(:,7), ex5(:), wf8(:,46), n3(:,89), t3x8(:,:,36))
  call prop_Q_A(ntry, wf8(:,46), 29, MT, 1_intkind1, wf8(:,47), n2(46))
  call vert_VQ_A(ntry, ex6(:), wf8(:,7), wf16(:,10), n3(:,90), t3x16(:,:,8))
  call prop_Q_A(ntry, wf16(:,10), 45, MT, 1_intkind1, wf16(:,11), n2(47))
  call vert_VQ_A(ntry, wf8(:,2), ex1(:), wf16(:,12), n3(:,91), t3x16(:,:,9))
  call prop_Q_A(ntry, wf16(:,12), 45, MT, 1_intkind1, wf16(:,13), n2(48))
  call vert_SA_Q(gH,ntry, ex5(:), wf8(:,4), wf8(:,48), n3(:,92), t3x8(:,:,37))
  call prop_A_Q(ntry, wf8(:,48), 30, MT, 1_intkind1, wf8(:,49), n2(49))
  call vert_AV_Q(ntry, wf8(:,4), ex6(:), wf16(:,14), n3(:,93), t3x16(:,:,10))
  call prop_A_Q(ntry, wf16(:,14), 46, MT, 1_intkind1, wf16(:,15), n2(50))
  call vert_AV_Q(ntry, ex2(:), wf8(:,2), wf16(:,16), n3(:,94), t3x16(:,:,11))
  call prop_A_Q(ntry, wf16(:,16), 46, MT, 1_intkind1, wf16(:,17), n2(51))
  call vert_VQ_A(ntry, wf4(:,4), ex3(:), wf8(:,50), n3(:,95), t3x8(:,:,38))
  call prop_Q_A(ntry, wf8(:,50), 23, ZERO, 0_intkind1, wf8(:,51), n2(52))
  call vert_AV_Q(ntry, ex4(:), wf4(:,4), wf8(:,52), n3(:,96), t3x8(:,:,39))
  call prop_A_Q(ntry, wf8(:,52), 27, ZERO, 0_intkind1, wf8(:,53), n2(53))
  call vert_UV_W(ntry, wf4(:,4), 19, ex6(:), 32, wf8(:,54), n3(:,97), t3x8(:,:,40))
  call vert_QA_V(ntry, wf4(:,34), ex2(:), wf8(:,55), n3(:,98), t3x8(:,:,41))
  call vert_VQ_A(ntry, wf4(:,8), ex3(:), wf8(:,56), n3(:,99), t3x8(:,:,42))
  call prop_Q_A(ntry, wf8(:,56), 23, ZERO, 0_intkind1, wf8(:,57), n2(54))
  call vert_AV_Q(ntry, ex4(:), wf4(:,8), wf8(:,58), n3(:,100), t3x8(:,:,43))
  call prop_A_Q(ntry, wf8(:,58), 27, ZERO, 0_intkind1, wf8(:,59), n2(55))
  call vert_UV_W(ntry, wf4(:,8), 19, ex6(:), 32, wf8(:,60), n3(:,101), t3x8(:,:,44))
  call vert_QA_V(ntry, ex1(:), wf4(:,43), wf8(:,61), n3(:,102), t3x8(:,:,45))
  call vert_QA_V(ntry, wf4(:,38), ex2(:), wf8(:,62), n3(:,103), t3x8(:,:,46))
  call vert_QA_V(ntry, ex1(:), wf4(:,46), wf8(:,63), n3(:,104), t3x8(:,:,47))
  call vert_VQ_A(ntry, wf8(:,8), ex1(:), wf16(:,18), n3(:,105), t3x16(:,:,12))
  call prop_Q_A(ntry, wf16(:,18), 45, MT, 1_intkind1, wf16(:,19), n2(56))
  call vert_AV_Q(ntry, ex2(:), wf8(:,8), wf16(:,20), n3(:,106), t3x16(:,:,13))
  call prop_A_Q(ntry, wf16(:,20), 46, MT, 1_intkind1, wf16(:,21), n2(57))
  call vert_VQ_A(ntry, wf8(:,9), ex1(:), wf16(:,22), n3(:,107), t3x16(:,:,14))
  call prop_Q_A(ntry, wf16(:,22), 45, MT, 1_intkind1, wf16(:,23), n2(58))
  call vert_AV_Q(ntry, ex2(:), wf8(:,9), wf16(:,24), n3(:,108), t3x16(:,:,15))
  call prop_A_Q(ntry, wf16(:,24), 46, MT, 1_intkind1, wf16(:,25), n2(59))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_exwf(ex6)
  call init_hybrid_wf(wf2)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf16)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k))
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0
  
  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do



  contains

subroutine physical_helicities()
  implicit none 

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 2
do i5= 1, 1
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_VV(nsync, wf4(:,2), wf8(:,1), A(:,1), n3(:,109), t3x32(:,:,1), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,2), A(:,2), n3(:,110), t3x32(:,:,2), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,4), A(:,3), n3(:,111), t3x32(:,:,3), nhel, den(11))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,5), A(:,4), n3(:,112), t3x32(:,:,4), nhel, den(15))
    call Hcont_VV(nsync, wf8(:,2), wf4(:,8), A(:,5), n3(:,113), t3x32(:,:,5), nhel, den(17))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,7), A(:,6), n3(:,114), t3x32(:,:,6), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,10), A(:,7), n3(:,115), t3x32(:,:,7), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,7), wf4(:,11), A(:,8), n3(:,116), t3x32(:,:,8), nhel, den(22))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,8), A(:,9), n3(:,117), t3x32(:,:,9), nhel, den(24))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,9), A(:,10), n3(:,118), t3x32(:,:,10), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,8), wf8(:,8), A(:,11), n3(:,119), t3x32(:,:,11), nhel, den(27))
    call Hcont_VV(nsync, wf4(:,8), wf8(:,9), A(:,12), n3(:,120), t3x32(:,:,12), nhel, den(28))

    call Hcont_VV(nsync, wf8(:,10), wf4(:,17), A(:,13), n3(:,121), t3x32(:,:,13), nhel, den(32))
    call Hcont_VV(nsync, wf8(:,10), wf4(:,17), A(:,14), n3(:,122), t3x32(:,:,14), nhel, den(32))
    call Hcont_VV(nsync, wf8(:,2), wf4(:,18), A(:,15), n3(:,123), t3x32(:,:,15), nhel, den(35))
    call Hcont_VV(nsync, wf8(:,2), wf4(:,18), A(:,16), n3(:,124), t3x32(:,:,16), nhel, den(35))
    call Hcont_VV(nsync, wf2(:,5), wf16(:,1), A(:,17), n3(:,125), t3x32(:,:,17), nhel, den(38))
    call Hcont_VV(nsync, wf2(:,5), wf16(:,1), A(:,18), n3(:,126), t3x32(:,:,18), nhel, den(38))
    call Hcont_VV(nsync, wf8(:,8), wf4(:,18), A(:,19), n3(:,127), t3x32(:,:,19), nhel, den(40))
    call Hcont_VV(nsync, wf8(:,8), wf4(:,18), A(:,20), n3(:,128), t3x32(:,:,20), nhel, den(40))
    call Hcont_VV(nsync, wf8(:,9), wf4(:,18), A(:,21), n3(:,129), t3x32(:,:,21), nhel, den(42))
    call Hcont_VV(nsync, wf8(:,9), wf4(:,18), A(:,22), n3(:,130), t3x32(:,:,22), nhel, den(42))
    call Hcont_QA(nsync, wf4(:,19), wf8(:,12), A(:,23), n3(:,131), t3x32(:,:,23), nhel, den(45))
    call Hcont_QA(nsync, wf4(:,19), wf8(:,12), A(:,24), n3(:,132), t3x32(:,:,24), nhel, den(45))
    call Hcont_QA(nsync, wf8(:,13), wf4(:,21), A(:,25), n3(:,133), t3x32(:,:,25), nhel, den(48))
    call Hcont_QA(nsync, wf8(:,13), wf4(:,21), A(:,26), n3(:,134), t3x32(:,:,26), nhel, den(48))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,14), A(:,27), n3(:,135), t3x32(:,:,27), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,15), A(:,28), n3(:,136), t3x32(:,:,28), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,22), A(:,29), n3(:,137), t3x32(:,:,29), nhel, den(11))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,16), A(:,30), n3(:,138), t3x32(:,:,30), nhel, den(15))
    call Hcont_VV(nsync, wf4(:,8), wf8(:,15), A(:,31), n3(:,139), t3x32(:,:,31), nhel, den(17))
    call Hcont_QA(nsync, wf8(:,7), wf4(:,23), A(:,32), n3(:,140), t3x32(:,:,32), nhel, den(20))
    call Hcont_VV(nsync, wf4(:,17), wf8(:,17), A(:,33), n3(:,141), t3x32(:,:,33), nhel, den(50))
    call Hcont_VV(nsync, wf4(:,17), wf8(:,17), A(:,34), n3(:,142), t3x32(:,:,34), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,24), A(:,35), n3(:,143), t3x32(:,:,35), nhel, den(21))
    call Hcont_VV(nsync, wf4(:,17), wf8(:,18), A(:,36), n3(:,144), t3x32(:,:,36), nhel, den(52))
    call Hcont_VV(nsync, wf4(:,17), wf8(:,18), A(:,37), n3(:,145), t3x32(:,:,37), nhel, den(52))
    call Hcont_QA(nsync, wf8(:,7), wf4(:,25), A(:,38), n3(:,146), t3x32(:,:,38), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,7), wf4(:,26), A(:,39), n3(:,147), t3x32(:,:,39), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,7), wf4(:,26), A(:,40), n3(:,148), t3x32(:,:,40), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,3), wf4(:,28), A(:,41), n3(:,149), t3x32(:,:,41), nhel, den(56))
    call Hcont_QA(nsync, wf8(:,3), wf4(:,28), A(:,42), n3(:,150), t3x32(:,:,42), nhel, den(56))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,19), A(:,43), n3(:,151), t3x32(:,:,43), nhel, den(24))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,20), A(:,44), n3(:,152), t3x32(:,:,44), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,8), wf8(:,19), A(:,45), n3(:,153), t3x32(:,:,45), nhel, den(27))
    call Hcont_VV(nsync, wf4(:,8), wf8(:,20), A(:,46), n3(:,154), t3x32(:,:,46), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,21), A(:,47), n3(:,155), t3x32(:,:,47), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,22), A(:,48), n3(:,156), t3x32(:,:,48), nhel, den(24))
    call Hcont_VV(nsync, wf4(:,8), wf8(:,21), A(:,49), n3(:,157), t3x32(:,:,49), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,8), wf8(:,22), A(:,50), n3(:,158), t3x32(:,:,50), nhel, den(27))
    call Hcont_VV(nsync, wf8(:,1), wf4(:,33), A(:,51), n3(:,159), t3x32(:,:,51), nhel, den(5))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,23), A(:,52), n3(:,160), t3x32(:,:,52), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,5), wf8(:,25), A(:,53), n3(:,161), t3x32(:,:,53), nhel, den(11))
    call Hcont_VV(nsync, wf8(:,5), wf4(:,33), A(:,54), n3(:,162), t3x32(:,:,54), nhel, den(15))
    call Hcont_VV(nsync, wf4(:,8), wf8(:,23), A(:,55), n3(:,163), t3x32(:,:,55), nhel, den(17))
    call Hcont_QA(nsync, wf4(:,9), wf8(:,27), A(:,56), n3(:,164), t3x32(:,:,56), nhel, den(20))
    call Hcont_QA(nsync, wf4(:,10), wf8(:,25), A(:,57), n3(:,165), t3x32(:,:,57), nhel, den(21))
    call Hcont_QA(nsync, wf4(:,11), wf8(:,27), A(:,58), n3(:,166), t3x32(:,:,58), nhel, den(22))
    call Hcont_QA(nsync, wf8(:,28), wf4(:,34), A(:,59), n3(:,167), t3x32(:,:,59), nhel, den(58))
    call Hcont_VV(nsync, wf8(:,2), wf4(:,35), A(:,60), n3(:,168), t3x32(:,:,60), nhel, den(59))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,29), A(:,61), n3(:,169), t3x32(:,:,61), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,28), wf4(:,38), A(:,62), n3(:,170), t3x32(:,:,62), nhel, den(61))
    call Hcont_QA(nsync, wf8(:,7), wf4(:,39), A(:,63), n3(:,171), t3x32(:,:,63), nhel, den(22))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,30), A(:,64), n3(:,172), t3x32(:,:,64), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,7), wf4(:,40), A(:,65), n3(:,173), t3x32(:,:,65), nhel, den(20))
    call Hcont_VV(nsync, wf8(:,2), wf4(:,41), A(:,66), n3(:,174), t3x32(:,:,66), nhel, den(17))
    call Hcont_VV(nsync, wf8(:,8), wf4(:,35), A(:,67), n3(:,175), t3x32(:,:,67), nhel, den(62))
    call Hcont_VV(nsync, wf8(:,9), wf4(:,35), A(:,68), n3(:,176), t3x32(:,:,68), nhel, den(63))
    call Hcont_VV(nsync, wf8(:,8), wf4(:,41), A(:,69), n3(:,177), t3x32(:,:,69), nhel, den(27))
    call Hcont_VV(nsync, wf8(:,9), wf4(:,41), A(:,70), n3(:,178), t3x32(:,:,70), nhel, den(28))
    call Hcont_VV(nsync, wf8(:,2), wf4(:,42), A(:,71), n3(:,179), t3x32(:,:,71), nhel, den(64))
    call Hcont_QA(nsync, wf8(:,31), wf4(:,43), A(:,72), n3(:,180), t3x32(:,:,72), nhel, den(67))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,32), A(:,73), n3(:,181), t3x32(:,:,73), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,31), wf4(:,46), A(:,74), n3(:,182), t3x32(:,:,74), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,47), A(:,75), n3(:,183), t3x32(:,:,75), nhel, den(21))
    call Hcont_VV(nsync, wf4(:,2), wf8(:,33), A(:,76), n3(:,184), t3x32(:,:,76), nhel, den(5))
    call Hcont_VV(nsync, wf8(:,2), wf4(:,48), A(:,77), n3(:,185), t3x32(:,:,77), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,49), A(:,78), n3(:,186), t3x32(:,:,78), nhel, den(11))
    call Hcont_VV(nsync, wf8(:,8), wf4(:,42), A(:,79), n3(:,187), t3x32(:,:,79), nhel, den(70))
    call Hcont_VV(nsync, wf8(:,9), wf4(:,42), A(:,80), n3(:,188), t3x32(:,:,80), nhel, den(71))
    call Hcont_VV(nsync, wf8(:,8), wf4(:,48), A(:,81), n3(:,189), t3x32(:,:,81), nhel, den(24))
    call Hcont_VV(nsync, wf8(:,9), wf4(:,48), A(:,82), n3(:,190), t3x32(:,:,82), nhel, den(26))
    call Hcont_QA(nsync, wf2(:,10), wf16(:,3), A(:,83), n3(:,191), t3x32(:,:,83), nhel, den(75))
    call Hcont_QA(nsync, wf4(:,50), wf8(:,35), A(:,84), n3(:,192), t3x32(:,:,84), nhel, den(79))
    call Hcont_VV(nsync, wf8(:,1), wf4(:,51), A(:,85), n3(:,193), t3x32(:,:,85), nhel, den(82))
    call Hcont_VV(nsync, wf8(:,2), wf4(:,52), A(:,86), n3(:,194), t3x32(:,:,86), nhel, den(84))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,53), A(:,87), n3(:,195), t3x32(:,:,87), nhel, den(85))
    call Hcont_QA(nsync, wf4(:,34), wf8(:,36), A(:,88), n3(:,196), t3x32(:,:,88), nhel, den(87))
    call Hcont_VV(nsync, wf8(:,2), wf4(:,54), A(:,89), n3(:,197), t3x32(:,:,89), nhel, den(88))
    call Hcont_QA(nsync, wf4(:,34), wf8(:,37), A(:,90), n3(:,198), t3x32(:,:,90), nhel, den(89))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,38), A(:,91), n3(:,199), t3x32(:,:,91), nhel, den(90))
    call Hcont_QA(nsync, wf4(:,55), wf8(:,40), A(:,92), n3(:,200), t3x32(:,:,92), nhel, den(94))
    call Hcont_QA(nsync, wf2(:,12), wf16(:,5), A(:,93), n3(:,201), t3x32(:,:,93), nhel, den(98))
    call Hcont_VV(nsync, wf8(:,5), wf4(:,51), A(:,94), n3(:,202), t3x32(:,:,94), nhel, den(100))
    call Hcont_VV(nsync, wf8(:,2), wf4(:,56), A(:,95), n3(:,203), t3x32(:,:,95), nhel, den(102))
    call Hcont_QA(nsync, wf4(:,43), wf8(:,41), A(:,96), n3(:,204), t3x32(:,:,96), nhel, den(103))
    call Hcont_VV(nsync, wf8(:,2), wf4(:,57), A(:,97), n3(:,205), t3x32(:,:,97), nhel, den(104))
    call Hcont_QA(nsync, wf4(:,43), wf8(:,42), A(:,98), n3(:,206), t3x32(:,:,98), nhel, den(105))
    call Hcont_QA(nsync, wf8(:,7), wf4(:,58), A(:,99), n3(:,207), t3x32(:,:,99), nhel, den(106))
    call Hcont_VV(nsync, wf4(:,8), wf8(:,38), A(:,100), n3(:,208), t3x32(:,:,100), nhel, den(107))
    call Hcont_QA(nsync, wf8(:,4), wf4(:,60), A(:,101), n3(:,209), t3x32(:,:,101), nhel, den(109))
    call Hcont_QA(nsync, wf4(:,38), wf8(:,36), A(:,102), n3(:,210), t3x32(:,:,102), nhel, den(110))
    call Hcont_QA(nsync, wf4(:,38), wf8(:,37), A(:,103), n3(:,211), t3x32(:,:,103), nhel, den(111))
    call Hcont_QA(nsync, wf4(:,46), wf8(:,41), A(:,104), n3(:,212), t3x32(:,:,104), nhel, den(112))
    call Hcont_QA(nsync, wf4(:,46), wf8(:,42), A(:,105), n3(:,213), t3x32(:,:,105), nhel, den(113))
    call Hcont_QA(nsync, wf8(:,7), wf4(:,62), A(:,106), n3(:,214), t3x32(:,:,106), nhel, den(115))
    call Hcont_VV(nsync, wf8(:,8), wf4(:,52), A(:,107), n3(:,215), t3x32(:,:,107), nhel, den(116))
    call Hcont_VV(nsync, wf8(:,8), wf4(:,54), A(:,108), n3(:,216), t3x32(:,:,108), nhel, den(117))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,43), A(:,109), n3(:,217), t3x32(:,:,109), nhel, den(119))
    call Hcont_VV(nsync, wf8(:,9), wf4(:,52), A(:,110), n3(:,218), t3x32(:,:,110), nhel, den(120))
    call Hcont_VV(nsync, wf8(:,9), wf4(:,54), A(:,111), n3(:,219), t3x32(:,:,111), nhel, den(121))
    call Hcont_VV(nsync, wf4(:,4), wf8(:,44), A(:,112), n3(:,220), t3x32(:,:,112), nhel, den(123))
    call Hcont_VV(nsync, wf8(:,8), wf4(:,56), A(:,113), n3(:,221), t3x32(:,:,113), nhel, den(124))
    call Hcont_VV(nsync, wf8(:,8), wf4(:,57), A(:,114), n3(:,222), t3x32(:,:,114), nhel, den(125))
    call Hcont_VV(nsync, wf4(:,8), wf8(:,43), A(:,115), n3(:,223), t3x32(:,:,115), nhel, den(126))
    call Hcont_VV(nsync, wf8(:,9), wf4(:,56), A(:,116), n3(:,224), t3x32(:,:,116), nhel, den(127))
    call Hcont_VV(nsync, wf8(:,9), wf4(:,57), A(:,117), n3(:,225), t3x32(:,:,117), nhel, den(128))
    call Hcont_VV(nsync, wf4(:,8), wf8(:,44), A(:,118), n3(:,226), t3x32(:,:,118), nhel, den(129))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(4), M2(4) ! M1helarray(4,32)
  integer :: empty(0), i

  M1(1)%j = ((-A(j,1)%j-A(j,3)%j-A(j,4)%j-A(j,6)%j-A(j,7)%j-A(j,8)%j)*f(7))/6._/**/REALKIND
  M1(2)%j = ((A(j,1)%j+A(j,6)%j+A(j,8)%j+A(j,9)%j+A(j,11)%j)*f(7))/2._/**/REALKIND+(CI*(-A(j,2)%j-A(j,5)%j)*f(8))/2._/**/REALKIND
  M1(3)%j = ((A(j,3)%j+A(j,4)%j+A(j,7)%j+A(j,10)%j+A(j,12)%j)*f(7))/2._/**/REALKIND+(CI*(A(j,2)%j+A(j,5)%j)*f(8))/2._/**/REALKIND
  M1(4)%j = ((-A(j,9)%j-A(j,10)%j-A(j,11)%j-A(j,12)%j)*f(7))/6._/**/REALKIND

  M2(1)%j = ((-A(j,34)%j-A(j,37)%j-A(j,40)%j-A(j,42)%j)*f(1))/6._/**/REALKIND+((-A(j,33)%j-A(j,36)%j-A(j,39)%j &
       -A(j,41)%j)*f(5))/6._/**/REALKIND+((A(j,83)%j+A(j,84)%j+A(j,85)%j+A(j,87)%j+A(j,88)%j+A(j,90)%j+A(j,92)%j+A(j,93)%j &
       +A(j,94)%j+A(j,96)%j+A(j,98)%j+A(j,99)%j+A(j,101)%j+A(j,102)%j+A(j,103)%j+A(j,104)%j+A(j,105)%j &
       +A(j,106)%j)*f(9))/6._/**/REALKIND+((-A(j,51)%j-A(j,53)%j-A(j,54)%j-A(j,56)%j-A(j,57)%j-A(j,58)%j)*f(11))/6._/**/REALKIND &
       +((-A(j,27)%j-A(j,29)%j-A(j,30)%j-A(j,32)%j-A(j,59)%j-A(j,61)%j-A(j,62)%j-A(j,63)%j-A(j,72)%j-A(j,73)%j-A(j,74)%j &
       -A(j,75)%j)*f(13))/6._/**/REALKIND+((-A(j,35)%j-A(j,38)%j-A(j,64)%j-A(j,65)%j-A(j,76)%j-A(j,78)%j)*f(15))/6._/**/REALKIND
  M2(2)%j = ((A(j,20)%j+A(j,26)%j+A(j,37)%j+A(j,40)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,14)%j-A(j,16)%j &
       -A(j,18)%j)*f(2))/2._/**/REALKIND+((A(j,19)%j+A(j,25)%j+A(j,36)%j+A(j,39)%j)*f(5))/2._/**/REALKIND+(CI*(A(j,13)%j-A(j,15)%j &
       -A(j,17)%j)*f(6))/2._/**/REALKIND+((-A(j,83)%j-A(j,84)%j-A(j,85)%j-A(j,96)%j-A(j,98)%j-A(j,99)%j-A(j,104)%j-A(j,105)%j &
       -A(j,106)%j-A(j,107)%j-A(j,108)%j-A(j,109)%j-A(j,113)%j-A(j,114)%j-A(j,115)%j)*f(9))/2._/**/REALKIND+(CI*(A(j,86)%j &
       +A(j,89)%j+A(j,91)%j+A(j,95)%j+A(j,97)%j+A(j,100)%j)*f(10))/2._/**/REALKIND+((A(j,43)%j+A(j,45)%j+A(j,48)%j+A(j,50)%j &
       +A(j,51)%j+A(j,56)%j+A(j,58)%j)*f(11))/2._/**/REALKIND+(CI*(-A(j,52)%j-A(j,55)%j)*f(12))/2._/**/REALKIND+((A(j,27)%j &
       +A(j,32)%j+A(j,61)%j+A(j,63)%j+A(j,67)%j+A(j,72)%j+A(j,74)%j+A(j,79)%j)*f(13))/2._/**/REALKIND+(CI*(-A(j,60)%j &
       -A(j,71)%j)*f(14))/2._/**/REALKIND+((A(j,38)%j+A(j,65)%j+A(j,69)%j+A(j,76)%j+A(j,81)%j)*f(15))/2._/**/REALKIND+(CI*( &
       -A(j,66)%j-A(j,77)%j)*f(16))/2._/**/REALKIND+(CI*(-A(j,28)%j-A(j,31)%j)*f(17))/2._/**/REALKIND
  M2(3)%j = ((A(j,22)%j+A(j,24)%j+A(j,34)%j+A(j,42)%j)*f(1))/2._/**/REALKIND+(CI*(-A(j,14)%j+A(j,16)%j &
       +A(j,18)%j)*f(2))/2._/**/REALKIND+((A(j,21)%j+A(j,23)%j+A(j,33)%j+A(j,41)%j)*f(5))/2._/**/REALKIND+(CI*(-A(j,13)%j &
       +A(j,15)%j+A(j,17)%j)*f(6))/2._/**/REALKIND+((-A(j,87)%j-A(j,88)%j-A(j,90)%j-A(j,92)%j-A(j,93)%j-A(j,94)%j-A(j,101)%j &
       -A(j,102)%j-A(j,103)%j-A(j,110)%j-A(j,111)%j-A(j,112)%j-A(j,116)%j-A(j,117)%j-A(j,118)%j)*f(9))/2._/**/REALKIND+(CI*( &
       -A(j,86)%j-A(j,89)%j-A(j,91)%j-A(j,95)%j-A(j,97)%j-A(j,100)%j)*f(10))/2._/**/REALKIND+((A(j,44)%j+A(j,46)%j+A(j,47)%j &
       +A(j,49)%j+A(j,53)%j+A(j,54)%j+A(j,57)%j)*f(11))/2._/**/REALKIND+(CI*(A(j,52)%j+A(j,55)%j)*f(12))/2._/**/REALKIND &
       +((A(j,29)%j+A(j,30)%j+A(j,59)%j+A(j,62)%j+A(j,68)%j+A(j,73)%j+A(j,75)%j+A(j,80)%j)*f(13))/2._/**/REALKIND+(CI*(A(j,60)%j &
       +A(j,71)%j)*f(14))/2._/**/REALKIND+((A(j,35)%j+A(j,64)%j+A(j,70)%j+A(j,78)%j+A(j,82)%j)*f(15))/2._/**/REALKIND &
       +(CI*(A(j,66)%j+A(j,77)%j)*f(16))/2._/**/REALKIND+(CI*(A(j,28)%j+A(j,31)%j)*f(17))/2._/**/REALKIND
  M2(4)%j = ((-A(j,20)%j-A(j,22)%j-A(j,24)%j-A(j,26)%j)*f(1))/6._/**/REALKIND+((-A(j,19)%j-A(j,21)%j-A(j,23)%j &
       -A(j,25)%j)*f(5))/6._/**/REALKIND+((A(j,107)%j+A(j,108)%j+A(j,109)%j+A(j,110)%j+A(j,111)%j+A(j,112)%j+A(j,113)%j+A(j,114)%j &
       +A(j,115)%j+A(j,116)%j+A(j,117)%j+A(j,118)%j)*f(9))/6._/**/REALKIND+((-A(j,43)%j-A(j,44)%j-A(j,45)%j-A(j,46)%j-A(j,47)%j &
       -A(j,48)%j-A(j,49)%j-A(j,50)%j)*f(11))/6._/**/REALKIND+((-A(j,67)%j-A(j,68)%j-A(j,79)%j-A(j,80)%j)*f(13))/6._/**/REALKIND &
       +((-A(j,69)%j-A(j,70)%j-A(j,81)%j-A(j,82)%j)*f(15))/6._/**/REALKIND


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)  

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphttj_ttxddxhg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(4)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 4
      do j = 1, 4
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphttj_ttxddxhg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M(4), Mct(4)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer ::  i, j

  M2colint_ct = 0

    do i = 1, 4
      do j = 1, 4
        M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i,j)*Mct(j))
      end do
    end do


end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_pphttj_ttxddxhg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(4)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 23-1
    colmatpos = 4*k
    do i = 1, 4
      do j = 1, 4
	M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do
  
end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphttj_ttxddxhg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(4)
  complex(REALKIND), intent(in)  :: M2(4)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 4
    do j = 1, 4
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_pphttj_ttxddxhg_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(4)
  type(Hpolcont), intent(out)  :: M0_col(4)
  integer :: i, j


  do j = 1, 4 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 4 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i,j)
    end do    
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_pphttj_ttxddxhg_1_/**/REALKIND
