
module ol_vamp_1_pphtt_ew_uuxttxh_3_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphtt_ew_uuxttxh_3.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphtt_ew_uuxttxh_3.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pphtt_ew_uuxttxh_3_/**/DREALKIND
  use ol_tensor_sum_storage_pphtt_ew_uuxttxh_3_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pphtt_ew_uuxttxh_3_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pphtt_ew_uuxttxh_3_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(3,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(159)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[nMT,0,0,0,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMT,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (c(160)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[nMT,0,0,nMZ,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMT,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (c(160)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[nMT,nMZ,0,0,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMT,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (c(161)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[nMT,nMZ,0,nMZ,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,4),heltab2x16(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMT,G1H16(4),n2h16(4))
  Gcoeff(:)%j = (c(163)*M(1,:)%j-c(162)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(5),h0tab(:,5),[16,4,1,2,8],[nMT,0,0,0,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,5),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMT,G1H16(5),n2h16(5))
  Gcoeff(:)%j = (c(163)*M(1,:)%j-c(162)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(6),h0tab(:,6),[16,4,1,2,8],[nMT,0,0,0,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,6),heltab2x16(:,:,6))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMT,G1H16(6),n2h16(6))
  Gcoeff(:)%j = (c(166)*M(1,:)%j-c(165)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(7),h0tab(:,7),[16,4,1,2,8],[nMT,nMZ,0,0,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,7),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMT,G1H16(7),n2h16(7))
  Gcoeff(:)%j = (c(166)*M(1,:)%j-c(165)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(8),h0tab(:,8),[16,4,1,2,8],[nMT,0,0,nMZ,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,8),heltab2x16(:,:,8))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMT,G1H16(8),n2h16(8))
  Gcoeff(:)%j = (c(138)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(9),h0tab(:,9),[16,2,1,4,8],[nMZ,0,0,nMT,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(1),0,ex5(:),16,G1H16(9),m3h1x16(:,9),heltab2x16(:,:,9))
  Gcoeff(:)%j = (c(140)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(10),h0tab(:,10),[16,2,1,4,8],[nMZ,0,nMZ,nMT,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(2),0,ex5(:),16,G1H16(10),m3h1x16(:,10),heltab2x16(:,:,10))
  Gcoeff(:)%j = (c(143)*M(1,:)%j-c(142)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(11),h0tab(:,11),[16,2,1,4,8],[nMZ,0,0,nMT,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(1),0,ex5(:),16,G1H16(11),m3h1x16(:,11),heltab2x16(:,:,11))
  Gcoeff(:)%j = (c(172)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(12),h0tab(:,12),[16,2,1,4,8],[nMZ,0,0,nMT,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(2),ex5(:),G0H16(1),m3h1x16(:,12),heltab2x16(:,:,12))
  Gcoeff(:)%j = (c(173)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(13),h0tab(:,13),[16,2,1,4,8],[nMZ,0,nMZ,nMT,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(2),ex5(:),G0H16(3),m3h1x16(:,13),heltab2x16(:,:,13))
  Gcoeff(:)%j = (c(175)*M(1,:)%j-c(174)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(14),h0tab(:,14),[16,2,1,4,8],[nMZ,0,0,nMT,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(2),ex5(:),G0H16(4),m3h1x16(:,14),heltab2x16(:,:,14))
  Gcoeff(:)%j = (c(159)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(15),h0tab(:,15),[16,4,2,1,8],[nMT,0,0,0,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(2),ex5(:),G0H16(5),ngH,m3h1x16(:,15),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMT,G1H16(12),n2h16(9))
  Gcoeff(:)%j = (c(160)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(16),h0tab(:,16),[16,4,2,1,8],[nMT,nMZ,0,0,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(2),ex5(:),G0H16(5),ngH,m3h1x16(:,16),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMT,G1H16(13),n2h16(10))
  Gcoeff(:)%j = (c(160)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(17),h0tab(:,17),[16,4,2,1,8],[nMT,0,0,nMZ,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(2),ex5(:),G0H16(5),ngH,m3h1x16(:,17),heltab2x16(:,:,17))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMT,G1H16(14),n2h16(11))
  Gcoeff(:)%j = (c(161)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(18),h0tab(:,18),[16,4,2,1,8],[nMT,nMZ,0,nMZ,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(2),ex5(:),G0H16(5),ngH,m3h1x16(:,18),heltab2x16(:,:,18))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMT,G1H16(15),n2h16(12))
  Gcoeff(:)%j = (c(8)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(19),h0tab(:,19),[16,4,2,1,8],[nMB,nMW,0,nMW,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(2),ex5(:),G0H16(5),ngH,m3h1x16(:,19),heltab2x16(:,:,19))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMB,G1H16(16),n2h16(13))
  Gcoeff(:)%j = (c(163)*M(1,:)%j-c(162)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(20),h0tab(:,20),[16,4,2,1,8],[nMT,0,0,0,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(2),ex5(:),G0H16(5),ngH,m3h1x16(:,20),heltab2x16(:,:,20))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMT,G1H16(17),n2h16(14))
  Gcoeff(:)%j = (c(163)*M(1,:)%j-c(162)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(21),h0tab(:,21),[16,4,2,1,8],[nMT,0,0,0,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(2),ex5(:),G0H16(5),ngH,m3h1x16(:,21),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMT,G1H16(18),n2h16(15))
  Gcoeff(:)%j = (c(166)*M(1,:)%j-c(165)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(22),h0tab(:,22),[16,4,2,1,8],[nMT,0,0,nMZ,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(2),ex5(:),G0H16(5),ngH,m3h1x16(:,22),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMT,G1H16(19),n2h16(16))
  Gcoeff(:)%j = (c(166)*M(1,:)%j-c(165)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(23),h0tab(:,23),[16,4,2,1,8],[nMT,nMZ,0,0,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(2),ex5(:),G0H16(5),ngH,m3h1x16(:,23),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMT,G1H16(20),n2h16(17))
  Gcoeff(:)%j = (c(138)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(24),h0tab(:,24),[16,2,1,8,4],[nMZ,0,0,nMT,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(2),0,ex5(:),16,G1H16(21),m3h1x16(:,24),heltab2x16(:,:,24))
  Gcoeff(:)%j = (c(140)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(5),m0h(25),h0tab(:,25),[16,2,1,8,4],[nMZ,0,nMZ,nMT,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(5),0,ex5(:),16,G1H16(22),m3h1x16(:,25),heltab2x16(:,:,25))
  Gcoeff(:)%j = (c(7)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(26),h0tab(:,26),[16,2,1,8,4],[nMW,0,nMW,nMB,nMW],5,0)
  call Hloop_ST_V(ntryL,G0H16(2),0,ex5(:),16,G1H16(23),m3h1x16(:,26),heltab2x16(:,:,26))
  Gcoeff(:)%j = (c(143)*M(1,:)%j-c(142)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(5),m0h(27),h0tab(:,27),[16,2,1,8,4],[nMZ,0,0,nMT,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(5),0,ex5(:),16,G1H16(24),m3h1x16(:,27),heltab2x16(:,:,27))
  Gcoeff(:)%j = (c(172)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(28),h0tab(:,28),[16,2,1,8,4],[nMZ,0,0,nMT,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(2),ex5(:),G0H16(5),m3h1x16(:,28),heltab2x16(:,:,28))
  Gcoeff(:)%j = (c(173)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(29),h0tab(:,29),[16,2,1,8,4],[nMZ,0,nMZ,nMT,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(2),ex5(:),G0H16(6),m3h1x16(:,29),heltab2x16(:,:,29))
  Gcoeff(:)%j = (c(13)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(30),h0tab(:,30),[16,2,1,8,4],[nMW,0,nMW,nMB,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(2),ex5(:),G0H16(7),m3h1x16(:,30),heltab2x16(:,:,30))
  Gcoeff(:)%j = (c(175)*M(1,:)%j-c(174)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(31),h0tab(:,31),[16,2,1,8,4],[nMZ,0,0,nMT,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(2),ex5(:),G0H16(8),m3h1x16(:,31),heltab2x16(:,:,31))
  Gcoeff(:)%j = (c(138)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(32),h0tab(:,32),[16,1,2,4,8],[nMZ,0,0,nMT,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(2),0,ex5(:),16,G1H16(25),m3h1x16(:,32),heltab2x16(:,:,32))
  Gcoeff(:)%j = (c(140)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(33),h0tab(:,33),[16,1,2,4,8],[nMZ,0,nMZ,nMT,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(2),0,ex5(:),16,G1H16(26),m3h1x16(:,33),heltab2x16(:,:,33))
  Gcoeff(:)%j = (c(7)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(34),h0tab(:,34),[16,1,2,4,8],[nMW,0,nMW,nMB,nMW],5,0)
  call Hloop_ST_V(ntryL,G0H16(2),0,ex5(:),16,G1H16(27),m3h1x16(:,34),heltab2x16(:,:,34))
  Gcoeff(:)%j = (c(143)*M(1,:)%j-c(142)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(35),h0tab(:,35),[16,1,2,4,8],[nMZ,0,0,nMT,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(2),0,ex5(:),16,G1H16(28),m3h1x16(:,35),heltab2x16(:,:,35))
  Gcoeff(:)%j = (c(172)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(36),h0tab(:,36),[16,1,2,4,8],[nMZ,0,0,nMT,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(2),ex5(:),G0H16(9),m3h1x16(:,36),heltab2x16(:,:,36))
  Gcoeff(:)%j = (c(173)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(37),h0tab(:,37),[16,1,2,4,8],[nMZ,0,nMZ,nMT,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(2),ex5(:),G0H16(10),m3h1x16(:,37),heltab2x16(:,:,37))
  Gcoeff(:)%j = (c(13)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(38),h0tab(:,38),[16,1,2,4,8],[nMW,0,nMW,nMB,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(2),ex5(:),G0H16(11),m3h1x16(:,38),heltab2x16(:,:,38))
  Gcoeff(:)%j = (c(175)*M(1,:)%j-c(174)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(39),h0tab(:,39),[16,1,2,4,8],[nMZ,0,0,nMT,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(2),ex5(:),G0H16(12),m3h1x16(:,39),heltab2x16(:,:,39))
  Gcoeff(:)%j = (c(138)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(40),h0tab(:,40),[16,1,2,8,4],[nMZ,0,0,nMT,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(2),0,ex5(:),16,G1H16(29),m3h1x16(:,40),heltab2x16(:,:,40))
  Gcoeff(:)%j = (c(140)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(41),h0tab(:,41),[16,1,2,8,4],[nMZ,0,nMZ,nMT,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(2),0,ex5(:),16,G1H16(30),m3h1x16(:,41),heltab2x16(:,:,41))
  Gcoeff(:)%j = (c(143)*M(1,:)%j-c(142)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(42),h0tab(:,42),[16,1,2,8,4],[nMZ,0,0,nMT,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(2),0,ex5(:),16,G1H16(31),m3h1x16(:,42),heltab2x16(:,:,42))
  Gcoeff(:)%j = (c(172)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(43),h0tab(:,43),[16,1,2,8,4],[nMZ,0,0,nMT,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(2),ex5(:),G0H16(13),m3h1x16(:,43),heltab2x16(:,:,43))
  Gcoeff(:)%j = (c(173)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(44),h0tab(:,44),[16,1,2,8,4],[nMZ,0,nMZ,nMT,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(2),ex5(:),G0H16(14),m3h1x16(:,44),heltab2x16(:,:,44))
  Gcoeff(:)%j = (c(175)*M(1,:)%j-c(174)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(45),h0tab(:,45),[16,1,2,8,4],[nMZ,0,0,nMT,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(2),ex5(:),G0H16(15),m3h1x16(:,45),heltab2x16(:,:,45))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(6),[G1H16(5),G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(8),[G1H16(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(7),[G1H16(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(11),[G1H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(4),[G0H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(18),[G1H16(17),G1H16(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(20),[G1H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(19),[G1H16(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(24),[G1H16(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(8),[G0H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(28),[G1H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(12),[G0H16(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(31),[G1H16(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(15),[G0H16(13)])
  call Hloop_AQ_V(ntryL,G1H16(6),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,46))
  call Hloop_AQ_V(ntryL,G1H16(8),ex3(:),G1H8(2),m3h2x8(:,2),heltab2x16(:,:,47))
  call Hloop_AQ_Z(ntryL,G1H16(7),ex3(:),G1H8(3),ngZu,m3h2x8(:,3),heltab2x16(:,:,48))
  call Hloop_AQ_Z(ntryL,G1H16(4),ex3(:),G1H8(4),ngZu,m3h2x8(:,4),heltab2x16(:,:,49))
  call Hloop_ZA_Q(ntryL,G1H16(11),ex2(:),G1H8(5),ngZu,m3h2x8(:,5),heltab2x16(:,:,50))
  call Hloop_A_Q(ntryL,G1H8(5),18,0,G2H8(1),n2h8(1))
  call Hloop_ZA_Q(ntryL,G1H16(10),ex2(:),G1H8(5),ngZu,m3h2x8(:,6),heltab2x16(:,:,51))
  call Hloop_A_Q(ntryL,G1H8(5),18,0,G2H8(2),n2h8(2))
  call Hloop_ZA_Q(ntryL,G0H16(4),ex2(:),G0H8(1),ngZu,m3h2x8(:,7),heltab2x16(:,:,52))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(5),n2h8(3))
  call Hloop_ZA_Q(ntryL,G0H16(3),ex2(:),G0H8(1),ngZu,m3h2x8(:,8),heltab2x16(:,:,53))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(6),n2h8(4))
  call Hloop_AQ_V(ntryL,G1H16(18),ex3(:),G1H8(7),m3h2x8(:,9),heltab2x16(:,:,54))
  call Hloop_AQ_Z(ntryL,G1H16(20),ex3(:),G1H8(8),ngZu,m3h2x8(:,10),heltab2x16(:,:,55))
  call Hloop_AQ_V(ntryL,G1H16(19),ex3(:),G1H8(9),m3h2x8(:,11),heltab2x16(:,:,56))
  call Hloop_AQ_Z(ntryL,G1H16(15),ex3(:),G1H8(10),ngZu,m3h2x8(:,12),heltab2x16(:,:,57))
  call Hloop_AQ_W(ntryL,G1H16(16),ex3(:),G1H8(11),m3h2x8(:,13),heltab2x16(:,:,58))
  call Hloop_ZA_Q(ntryL,G1H16(24),ex2(:),G1H8(12),ngZu,m3h2x8(:,14),heltab2x16(:,:,59))
  call Hloop_A_Q(ntryL,G1H8(12),18,0,G2H8(3),n2h8(5))
  call Hloop_ZA_Q(ntryL,G1H16(22),ex2(:),G1H8(12),ngZu,m3h2x8(:,15),heltab2x16(:,:,60))
  call Hloop_A_Q(ntryL,G1H8(12),18,0,G2H8(4),n2h8(6))
  call Hloop_WA_Q(ntryL,G1H16(23),ex2(:),G1H8(12),m3h2x8(:,16),heltab2x16(:,:,61))
  call Hloop_A_Q(ntryL,G1H8(12),18,0,G2H8(5),n2h8(7))
  call Hloop_ZA_Q(ntryL,G0H16(8),ex2(:),G0H8(1),ngZu,m3h2x8(:,17),heltab2x16(:,:,62))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(12),n2h8(8))
  call Hloop_ZA_Q(ntryL,G0H16(6),ex2(:),G0H8(1),ngZu,m3h2x8(:,18),heltab2x16(:,:,63))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(13),n2h8(9))
  call Hloop_WA_Q(ntryL,G0H16(7),ex2(:),G0H8(1),m3h2x8(:,19),heltab2x16(:,:,64))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(14),n2h8(10))
  call Hloop_ZQ_A(ntryL,G1H16(28),ex1(:),G1H8(15),ngZu,m3h2x8(:,20),heltab2x16(:,:,65))
  call Hloop_Q_A(ntryL,G1H8(15),17,0,G2H8(6),n2h8(11))
  call Hloop_ZQ_A(ntryL,G1H16(26),ex1(:),G1H8(15),ngZu,m3h2x8(:,21),heltab2x16(:,:,66))
  call Hloop_Q_A(ntryL,G1H8(15),17,0,G2H8(7),n2h8(12))
  call Hloop_WQ_A(ntryL,G1H16(27),ex1(:),G1H8(15),m3h2x8(:,22),heltab2x16(:,:,67))
  call Hloop_Q_A(ntryL,G1H8(15),17,0,G2H8(8),n2h8(13))
  call Hloop_ZQ_A(ntryL,G0H16(12),ex1(:),G0H8(1),ngZu,m3h2x8(:,23),heltab2x16(:,:,68))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(15),n2h8(14))
  call Hloop_ZQ_A(ntryL,G0H16(10),ex1(:),G0H8(1),ngZu,m3h2x8(:,24),heltab2x16(:,:,69))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(16),n2h8(15))
  call Hloop_WQ_A(ntryL,G0H16(11),ex1(:),G0H8(1),m3h2x8(:,25),heltab2x16(:,:,70))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(17),n2h8(16))
  call Hloop_ZQ_A(ntryL,G1H16(31),ex1(:),G1H8(18),ngZu,m3h2x8(:,26),heltab2x16(:,:,71))
  call Hloop_Q_A(ntryL,G1H8(18),17,0,G2H8(9),n2h8(17))
  call Hloop_ZQ_A(ntryL,G1H16(30),ex1(:),G1H8(18),ngZu,m3h2x8(:,27),heltab2x16(:,:,72))
  call Hloop_Q_A(ntryL,G1H8(18),17,0,G2H8(10),n2h8(18))
  call Hloop_ZQ_A(ntryL,G0H16(15),ex1(:),G0H8(1),ngZu,m3h2x8(:,28),heltab2x16(:,:,73))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(18),n2h8(19))
  call Hloop_ZQ_A(ntryL,G0H16(14),ex1(:),G0H8(1),ngZu,m3h2x8(:,29),heltab2x16(:,:,74))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(19),n2h8(20))
  call Hloop_VQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(1),n2h4(1))
  call Hloop_VQ_A(ntryL,G1H8(2),ex1(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(2),n2h4(2))
  call Hloop_ZQ_A(ntryL,G1H8(3),ex1(:),G1H4(1),ngZu,m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(3),n2h4(3))
  call Hloop_ZQ_A(ntryL,G1H8(4),ex1(:),G1H4(1),ngZu,m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),21,0,G2H4(4),n2h4(4))
  call Hloop_AQ_V(ntryL,G2H8(1),ex1(:),G2H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_Z(ntryL,G2H8(2),ex1(:),G2H4(6),ngZu,m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_AQ_V(ntryL,G1H8(5),ex1(:),G1H4(1),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_AQ_Z(ntryL,G1H8(6),ex1(:),G1H4(2),ngZu,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_VA_Q(ntryL,G1H8(7),ex2(:),G1H4(3),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_A_Q(ntryL,G1H4(3),22,0,G2H4(7),n2h4(5))
  call Hloop_ZA_Q(ntryL,G1H8(8),ex2(:),G1H4(3),ngZu,m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_A_Q(ntryL,G1H4(3),22,0,G2H4(8),n2h4(6))
  call Hloop_VA_Q(ntryL,G1H8(9),ex2(:),G1H4(3),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_A_Q(ntryL,G1H4(3),22,0,G2H4(9),n2h4(7))
  call Hloop_ZA_Q(ntryL,G1H8(10),ex2(:),G1H4(3),ngZu,m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_A_Q(ntryL,G1H4(3),22,0,G2H4(10),n2h4(8))
  call Hloop_WA_Q(ntryL,G1H8(11),ex2(:),G1H4(3),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G1H4(3),22,0,G2H4(11),n2h4(9))
  call Hloop_AQ_V(ntryL,G2H8(3),ex1(:),G2H4(12),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_AQ_Z(ntryL,G2H8(4),ex1(:),G2H4(13),ngZu,m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_AQ_W(ntryL,G2H8(5),ex1(:),G2H4(14),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_AQ_V(ntryL,G1H8(12),ex1(:),G1H4(3),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_AQ_Z(ntryL,G1H8(13),ex1(:),G1H4(4),ngZu,m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_AQ_W(ntryL,G1H8(14),ex1(:),G1H4(5),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_QA_V(ntryL,G2H8(6),ex2(:),G2H4(15),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_QA_Z(ntryL,G2H8(7),ex2(:),G2H4(16),ngZu,m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_QA_W(ntryL,G2H8(8),ex2(:),G2H4(17),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_QA_V(ntryL,G1H8(15),ex2(:),G1H4(6),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_QA_Z(ntryL,G1H8(16),ex2(:),G1H4(7),ngZu,m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_QA_W(ntryL,G1H8(17),ex2(:),G1H4(8),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_QA_V(ntryL,G2H8(9),ex2(:),G2H4(18),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_QA_Z(ntryL,G2H8(10),ex2(:),G2H4(19),ngZu,m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_QA_V(ntryL,G1H8(18),ex2(:),G1H4(9),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_QA_Z(ntryL,G1H8(19),ex2(:),G1H4(10),ngZu,m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_QA_V(ntryL,G2H4(1),ex2(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_Z(ntryL,G2H4(2),ex2(:),G2H2(2),ngZu,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_V(ntryL,G2H4(3),ex2(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_Z(ntryL,G2H4(4),ex2(:),G2H2(4),ngZu,m3h2x2(:,4),heltab2x4(:,:,4))
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(1),mass5set(:,1),  & 
G1H4(11),G1H4(12),G1H4(13),G1H4(14),G1H4(15),G1H4(16),4)
  call HG1shiftOLR(G1H4(12),8,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(1),mass5set(:,2),  & 
G1H4(17),G1H4(18),G1H4(19),G1H4(20),G1H4(21),G1H4(22),4)
  call HG1shiftOLR(G1H4(18),8,4)
  call Hloop_VQ_A(ntryL,G1H4(1),ex3(:),G1H2(1),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(5),n2h2(1))
  call Hloop_ZQ_A(ntryL,G1H4(2),ex3(:),G1H2(1),ngZu,m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(6),n2h2(2))
  call Hloop_AQ_V(ntryL,G2H4(7),ex1(:),G2H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_V(ntryL,G2H4(8),ex1(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_Z(ntryL,G2H4(9),ex1(:),G2H2(9),ngZu,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_Z(ntryL,G2H4(10),ex1(:),G2H2(10),ngZu,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_AQ_W(ntryL,G2H4(11),ex1(:),G2H2(11),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(2),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(23),G1H4(24),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(2),4,4)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(2),mass5set(:,2),  & 
G1H4(27),G1H4(28),G1H4(29),G1H4(30),G1H4(31),G1H4(32),4)
  call HG1shiftOLR(G1H4(28),4,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(2),mass5set(:,3),  & 
G1H4(33),G1H4(34),G1H4(35),G1H4(36),G1H4(37),G1H4(38),4)
  call HG1shiftOLR(G1H4(34),4,4)
  call Hloop_VA_Q(ntryL,G1H4(3),ex4(:),G1H2(1),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(12),n2h2(3))
  call Hloop_ZA_Q(ntryL,G1H4(4),ex4(:),G1H2(1),ngZu,m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(13),n2h2(4))
  call Hloop_WA_Q(ntryL,G1H4(5),ex4(:),G1H2(1),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMB,G2H2(14),n2h2(5))
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(3),mass5set(:,1),  & 
G1H4(3),G1H4(4),G1H4(5),G1H4(39),G1H4(40),G1H4(41),4)
  call HG1shiftOLR(G1H4(4),8,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(3),mass5set(:,2),  & 
G1H4(42),G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),4)
  call HG1shiftOLR(G1H4(43),8,4)
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(3),mass5set(:,3),  & 
G1H4(48),G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),4)
  call HG1shiftOLR(G1H4(49),8,4)
  call Hloop_VQ_A(ntryL,G1H4(6),ex3(:),G1H2(1),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(15),n2h2(6))
  call Hloop_ZQ_A(ntryL,G1H4(7),ex3(:),G1H2(1),ngZu,m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(16),n2h2(7))
  call Hloop_WQ_A(ntryL,G1H4(8),ex3(:),G1H2(1),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(17),n2h2(8))
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(4),mass5set(:,1),  & 
G1H4(6),G1H4(7),G1H4(8),G1H4(54),G1H4(55),G1H4(56),4)
  call HG1shiftOLR(G1H4(7),4,4)
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(4),mass5set(:,2),  & 
G1H4(57),G1H4(58),G1H4(59),G1H4(60),G1H4(61),G1H4(62),4)
  call HG1shiftOLR(G1H4(58),4,4)
  call Hloop_VA_Q(ntryL,G1H4(9),ex4(:),G1H2(1),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(18),n2h2(9))
  call Hloop_ZA_Q(ntryL,G1H4(10),ex4(:),G1H2(1),ngZu,m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(1),27,nMT,G2H2(19),n2h2(10))
  call Hloop_VQ_A(ntryL,G1H4(11),ex3(:),G1H2(1),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(20),n2h2(11))
call HGT_OLR(G1H4(12),1,1,4)
call HGT_invQ_OLR(G1H4(12),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(12),ex4(:),G1H2(1),ngX,m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_VQ_A(ntryL,G1H4(15),ex3(:),G1H2(2),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_Q_A(ntryL,G1H2(2),23,nMT,G2H2(21),n2h2(12))
  call Hloop_VQ_A(ntryL,G1H4(16),ex3(:),G1H2(2),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(2),23,nMT,G2H2(22),n2h2(13))
  call Hloop_ZQ_A(ntryL,G1H4(17),ex3(:),G1H2(2),ngZu,m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_Q_A(ntryL,G1H2(2),23,nMT,G2H2(23),n2h2(14))
call HGT_OLR(G1H4(18),1,1,4)
call HGT_invQ_OLR(G1H4(18),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(18),ex4(:),G1H2(2),ngX,m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_ZQ_A(ntryL,G1H4(21),ex3(:),G1H2(3),ngZu,m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMT,G2H2(24),n2h2(15))
  call Hloop_ZQ_A(ntryL,G1H4(22),ex3(:),G1H2(3),ngZu,m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMT,G2H2(25),n2h2(16))
  call Hloop_VA_Q(ntryL,G1H4(1),ex4(:),G1H2(3),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_A_Q(ntryL,G1H2(3),27,nMT,G2H2(26),n2h2(17))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_SQ_A(ntryL,G1H4(2),ex3(:),G1H2(3),ngX,m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_VA_Q(ntryL,G1H4(25),ex4(:),G1H2(4),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(4),27,nMT,G2H2(27),n2h2(18))
  call Hloop_VA_Q(ntryL,G1H4(26),ex4(:),G1H2(4),m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(4),27,nMT,G2H2(28),n2h2(19))
  call Hloop_ZA_Q(ntryL,G1H4(27),ex4(:),G1H2(4),ngZu,m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(4),27,nMT,G2H2(29),n2h2(20))
call HGT_OLR(G1H4(28),1,1,4)
call HGT_invQ_OLR(G1H4(28),2,5,4)
  call Hloop_SQ_A(ntryL,G1H4(28),ex3(:),G1H2(4),ngX,m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_ZA_Q(ntryL,G1H4(31),ex4(:),G1H2(5),ngZu,m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_A_Q(ntryL,G1H2(5),27,nMT,G2H2(30),n2h2(21))
  call Hloop_ZA_Q(ntryL,G1H4(32),ex4(:),G1H2(5),ngZu,m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(5),27,nMT,G2H2(31),n2h2(22))
  call Hloop_WA_Q(ntryL,G1H4(33),ex4(:),G1H2(5),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(5),27,nMB,G2H2(32),n2h2(23))
call HGT_OLR(G1H4(34),1,1,4)
call HGT_invQ_OLR(G1H4(34),2,5,4)
  call Hloop_SQ_A(ntryL,G1H4(34),ex3(:),G1H2(5),ngPbt,m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_WA_Q(ntryL,G1H4(37),ex4(:),G1H2(6),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(6),27,nMB,G2H2(33),n2h2(24))
  call Hloop_WA_Q(ntryL,G1H4(38),ex4(:),G1H2(6),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_A_Q(ntryL,G1H2(6),27,nMB,G2H2(34),n2h2(25))
  call Hloop_VQ_A(ntryL,G1H4(3),ex3(:),G1H2(6),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(6),23,nMT,G2H2(35),n2h2(26))
call HGT_OLR(G1H4(4),1,1,4)
call HGT_invQ_OLR(G1H4(4),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(4),ex4(:),G1H2(6),ngX,m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_VQ_A(ntryL,G1H4(40),ex3(:),G1H2(7),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_Q_A(ntryL,G1H2(7),23,nMT,G2H2(36),n2h2(27))
  call Hloop_VQ_A(ntryL,G1H4(41),ex3(:),G1H2(7),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(7),23,nMT,G2H2(37),n2h2(28))
  call Hloop_ZQ_A(ntryL,G1H4(42),ex3(:),G1H2(7),ngZu,m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_Q_A(ntryL,G1H2(7),23,nMT,G2H2(38),n2h2(29))
call HGT_OLR(G1H4(43),1,1,4)
call HGT_invQ_OLR(G1H4(43),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(43),ex4(:),G1H2(7),ngX,m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_ZQ_A(ntryL,G1H4(46),ex3(:),G1H2(8),ngZu,m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(8),23,nMT,G2H2(39),n2h2(30))
  call Hloop_ZQ_A(ntryL,G1H4(47),ex3(:),G1H2(8),ngZu,m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(8),23,nMT,G2H2(40),n2h2(31))
  call Hloop_WQ_A(ntryL,G1H4(48),ex3(:),G1H2(8),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(8),23,nMB,G2H2(41),n2h2(32))
call HGT_OLR(G1H4(49),1,1,4)
call HGT_invQ_OLR(G1H4(49),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(49),ex4(:),G1H2(8),ngPtb,m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_WQ_A(ntryL,G1H4(52),ex3(:),G1H2(9),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(9),23,nMB,G2H2(42),n2h2(33))
  call Hloop_WQ_A(ntryL,G1H4(53),ex3(:),G1H2(9),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(9),23,nMB,G2H2(43),n2h2(34))
  call Hloop_VA_Q(ntryL,G1H4(6),ex4(:),G1H2(9),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_A_Q(ntryL,G1H2(9),27,nMT,G2H2(44),n2h2(35))
call HGT_OLR(G1H4(7),1,1,4)
call HGT_invQ_OLR(G1H4(7),2,5,4)
  call Hloop_SQ_A(ntryL,G1H4(7),ex3(:),G1H2(9),ngX,m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_VA_Q(ntryL,G1H4(55),ex4(:),G1H2(10),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_A_Q(ntryL,G1H2(10),27,nMT,G2H2(45),n2h2(36))
  call Hloop_VA_Q(ntryL,G1H4(56),ex4(:),G1H2(10),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_A_Q(ntryL,G1H2(10),27,nMT,G2H2(46),n2h2(37))
  call Hloop_ZA_Q(ntryL,G1H4(57),ex4(:),G1H2(10),ngZu,m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_A_Q(ntryL,G1H2(10),27,nMT,G2H2(47),n2h2(38))
call HGT_OLR(G1H4(58),1,1,4)
call HGT_invQ_OLR(G1H4(58),2,5,4)
  call Hloop_SQ_A(ntryL,G1H4(58),ex3(:),G1H2(10),ngX,m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_ZA_Q(ntryL,G1H4(61),ex4(:),G1H2(11),ngZu,m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_A_Q(ntryL,G1H2(11),27,nMT,G2H2(48),n2h2(39))
  call Hloop_ZA_Q(ntryL,G1H4(62),ex4(:),G1H2(11),ngZu,m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_A_Q(ntryL,G1H2(11),27,nMT,G2H2(49),n2h2(40))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(5),mass5set(:,4),  & 
G1H2(11),G1H2(12),G1H2(13),G1H2(14),G1H2(15),G1H2(16),2)
  call HG1shiftOLR(G1H2(12),8,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(5),mass5set(:,5),  & 
G1H2(17),G1H2(18),G1H2(19),G1H2(20),G1H2(21),G1H2(22),2)
  call HG1shiftOLR(G1H2(18),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(5),mass5set(:,6),  & 
G1H2(23),G1H2(24),G1H2(25),G1H2(26),G1H2(27),G1H2(28),2)
  call HG1shiftOLR(G1H2(24),8,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(5),mass5set(:,7),  & 
G1H2(29),G1H2(30),G1H2(31),G1H2(32),G1H2(33),G1H2(34),2)
  call HG1shiftOLR(G1H2(30),8,2)
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(5),ex4(:),G2tensor(1),ngZu,m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(6),ex4(:),G2tensor(2),ngZu,m3h2x1(:,2),heltab2x2(:,:,2))
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(6),mass5set(:,4),  & 
G1H2(35),G1H2(36),G1H2(37),G1H2(38),G1H2(39),G1H2(40),2)
  call HG1shiftOLR(G1H2(36),8,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(6),mass5set(:,6),  & 
G1H2(41),G1H2(42),G1H2(43),G1H2(44),G1H2(45),G1H2(46),2)
  call HG1shiftOLR(G1H2(42),8,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(6),mass5set(:,5),  & 
G1H2(47),G1H2(48),G1H2(49),G1H2(50),G1H2(51),G1H2(52),2)
  call HG1shiftOLR(G1H2(48),8,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(6),mass5set(:,7),  & 
G1H2(53),G1H2(54),G1H2(55),G1H2(56),G1H2(57),G1H2(58),2)
  call HG1shiftOLR(G1H2(54),8,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(6),mass5set(:,8),  & 
G1H2(59),G1H2(60),G1H2(61),G1H2(62),G1H2(63),G1H2(64),2)
  call HG1shiftOLR(G1H2(60),8,2)
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(12),ex3(:),G2tensor(3),ngZu,m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(13),ex3(:),G2tensor(4),ngZu,m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(14),ex3(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(15),ex4(:),G2tensor(6),ngZu,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(16),ex4(:),G2tensor(7),ngZu,m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(17),ex4(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(18),ex3(:),G2tensor(9),ngZu,m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(19),ex3(:),G2tensor(10),ngZu,m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(20),ex4(:),G2tensor(11),ngX,m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(22),ex4(:),G2tensor(12),ngX,m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(23),ex4(:),G2tensor(13),ngX,m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(25),ex4(:),G2tensor(14),ngX,m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(26),ex3(:),G2tensor(15),ngX,m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(28),ex3(:),G2tensor(16),ngX,m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(29),ex3(:),G2tensor(17),ngX,m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(31),ex3(:),G2tensor(18),ngX,m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(32),ex3(:),G2tensor(19),ngPbt,m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(34),ex3(:),G2tensor(20),ngPbt,m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(35),ex4(:),G2tensor(21),ngX,m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(37),ex4(:),G2tensor(22),ngX,m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(38),ex4(:),G2tensor(23),ngX,m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(40),ex4(:),G2tensor(24),ngX,m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(41),ex4(:),G2tensor(25),ngPtb,m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(43),ex4(:),G2tensor(26),ngPtb,m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(44),ex3(:),G2tensor(27),ngX,m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(46),ex3(:),G2tensor(28),ngX,m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(47),ex3(:),G2tensor(29),ngX,m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(49),ex3(:),G2tensor(30),ngX,m3h2x1(:,30),heltab2x2(:,:,30))
  call Hloop_VA_Q(ntryL,G1H2(11),ex4(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(31),n2h1(1))
  call Hloop_VA_Q(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(32),n2h1(2))
  call Hloop_VA_Q(ntryL,G1H2(16),ex4(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(33),n2h1(3))
  call Hloop_ZA_Q(ntryL,G1H2(17),ex4(:),G1H1(1),ngZu,m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(34),n2h1(4))
  call Hloop_ZA_Q(ntryL,G1H2(18),ex4(:),G1H1(1),ngZu,m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(35),n2h1(5))
  call Hloop_ZA_Q(ntryL,G1H2(22),ex4(:),G1H1(1),ngZu,m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(36),n2h1(6))
  call Hloop_VA_Q(ntryL,G1H2(23),ex4(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(37),n2h1(7))
  call Hloop_VA_Q(ntryL,G1H2(24),ex4(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(38),n2h1(8))
  call Hloop_VA_Q(ntryL,G1H2(28),ex4(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(39),n2h1(9))
  call Hloop_ZA_Q(ntryL,G1H2(29),ex4(:),G1H1(1),ngZu,m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(40),n2h1(10))
  call Hloop_ZA_Q(ntryL,G1H2(30),ex4(:),G1H1(1),ngZu,m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(41),n2h1(11))
  call Hloop_ZA_Q(ntryL,G1H2(34),ex4(:),G1H1(1),ngZu,m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(42),n2h1(12))
  call Hloop_VA_Q(ntryL,G1H2(35),ex4(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(43),n2h1(13))
  call Hloop_VA_Q(ntryL,G1H2(36),ex4(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(44),n2h1(14))
  call Hloop_VA_Q(ntryL,G1H2(40),ex4(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(45),n2h1(15))
  call Hloop_VA_Q(ntryL,G1H2(41),ex4(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(46),n2h1(16))
  call Hloop_VA_Q(ntryL,G1H2(42),ex4(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(47),n2h1(17))
  call Hloop_VA_Q(ntryL,G1H2(46),ex4(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(48),n2h1(18))
  call Hloop_ZA_Q(ntryL,G1H2(47),ex4(:),G1H1(1),ngZu,m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(49),n2h1(19))
  call Hloop_ZA_Q(ntryL,G1H2(48),ex4(:),G1H1(1),ngZu,m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(50),n2h1(20))
  call Hloop_ZA_Q(ntryL,G1H2(52),ex4(:),G1H1(1),ngZu,m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(51),n2h1(21))
  call Hloop_ZA_Q(ntryL,G1H2(53),ex4(:),G1H1(1),ngZu,m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(52),n2h1(22))
  call Hloop_ZA_Q(ntryL,G1H2(54),ex4(:),G1H1(1),ngZu,m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(53),n2h1(23))
  call Hloop_ZA_Q(ntryL,G1H2(58),ex4(:),G1H1(1),ngZu,m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(54),n2h1(24))
  call Hloop_WA_Q(ntryL,G1H2(59),ex4(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(55),n2h1(25))
  call Hloop_WA_Q(ntryL,G1H2(60),ex4(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(56),n2h1(26))
  call Hloop_WA_Q(ntryL,G1H2(64),ex4(:),G1H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(57),n2h1(27))
  call ol_merge_tensors(G2tensor(11),[G2tensor(1)])
  call ol_merge_tensors(G2tensor(13),[G2tensor(2)])
  call ol_merge_tensors(G2tensor(15),[G2tensor(3)])
  call ol_merge_tensors(G2tensor(17),[G2tensor(4)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(5)])
  call ol_merge_tensors(G2tensor(21),[G2tensor(6)])
  call ol_merge_tensors(G2tensor(23),[G2tensor(7)])
  call ol_merge_tensors(G2tensor(25),[G2tensor(8)])
  call ol_merge_tensors(G2tensor(27),[G2tensor(9)])
  call ol_merge_tensors(G2tensor(29),[G2tensor(10)])
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(1),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(2),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),4)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(2),mass5set(:,2),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),4)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(2),mass5set(:,3),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),4)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(3),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(3),mass5set(:,2),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(3),mass5set(:,3),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),8)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(4),mass5set(:,1),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),4)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(4),mass5set(:,2),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),4)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(5),mass5set(:,4),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(34),RedSet_5(5),mass5set(:,5),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),8)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(5),mass5set(:,6),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),8)
  call Hotf_5pt_reduction_last(G2tensor(40),RedSet_5(5),mass5set(:,7),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),8)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(6),mass5set(:,4),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),8)
  call Hotf_5pt_reduction_last(G2tensor(46),RedSet_5(6),mass5set(:,6),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),8)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(6),mass5set(:,5),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),8)
  call Hotf_5pt_reduction_last(G2tensor(52),RedSet_5(6),mass5set(:,7),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),8)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(6),mass5set(:,8),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),8)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  Gcoeff(:)%j = (-(c(78)*M(3,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(46),h0tab(:,46),[16,3,8,4],[nMT,nMT,nMH,nMT],4,1,wf4(:,6))
  call Hloop_QS_A(ntryL,G0H16(2),ex5(:),G0H16(1),ngH,m3h1x16(:,46),heltab2x16(:,:,75))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMT,G1H16(5),n2h16(18))
  Gcoeff(:)%j = (c(78)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(5),m0h(47),h0tab(:,47),[16,3,8,4],[nMT,nMT,nMZ,nMT],4,1,wf4(:,6))
  call Hloop_QS_A(ntryL,G0H16(5),ex5(:),G0H16(9),ngH,m3h1x16(:,47),heltab2x16(:,:,76))
  call Hloop_Q_A(ntryL,G0H16(9),16,nMT,G1H16(1),n2h16(19))
  Gcoeff(:)%j = (-(c(48)*M(3,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(13),m0h(48),h0tab(:,48),[16,3,8,4],[nMB,nMB,nMW,nMB],4,1,wf4(:,6))
  call Hloop_QS_A(ntryL,G0H16(13),ex5(:),G0H16(4),ngH,m3h1x16(:,48),heltab2x16(:,:,77))
  call Hloop_Q_A(ntryL,G0H16(4),16,nMB,G1H16(2),n2h16(20))
  Gcoeff(:)%j = (-(c(79)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(3),m0h(49),h0tab(:,49),[16,3,8,4],[nMT,nMT,nMH,nMT],4,1,wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(3),ex5(:),G0H16(8),ngH,m3h1x16(:,49),heltab2x16(:,:,78))
  call Hloop_Q_A(ntryL,G0H16(8),16,nMT,G1H16(3),n2h16(21))
  Gcoeff(:)%j = (c(79)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(6),m0h(50),h0tab(:,50),[16,3,8,4],[nMT,nMT,nMZ,nMT],4,1,wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(6),ex5(:),G0H16(7),ngH,m3h1x16(:,50),heltab2x16(:,:,79))
  call Hloop_Q_A(ntryL,G0H16(7),16,nMT,G1H16(9),n2h16(22))
  Gcoeff(:)%j = (c(51)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(12),m0h(51),h0tab(:,51),[16,3,8,4],[nMB,nMB,nMW,nMB],4,1,wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(12),ex5(:),G0H16(10),ngH,m3h1x16(:,51),heltab2x16(:,:,80))
  call Hloop_Q_A(ntryL,G0H16(10),16,nMB,G1H16(17),n2h16(23))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)+c(80)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(11),m0h(52),h0tab(:,52),[16,3,8,4],[nMT,nMT,nMH,nMT],4,1,wf4(:,6))
  call Hloop_QS_A(ntryL,G0H16(11),ex5(:),G0H16(15),ngH,m3h1x16(:,52),heltab2x16(:,:,81))
  call Hloop_Q_A(ntryL,G0H16(15),16,nMT,G1H16(12),n2h16(24))
  Gcoeff(:)%j = (c(81)*M(1,:)%j-c(80)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(14),m0h(53),h0tab(:,53),[16,3,8,4],[nMT,nMT,nMZ,nMT],4,1,wf4(:,6))
  call Hloop_QS_A(ntryL,G0H16(14),ex5(:),G0H16(2),ngH,m3h1x16(:,53),heltab2x16(:,:,82))
  call Hloop_Q_A(ntryL,G0H16(2),16,nMT,G1H16(13),n2h16(25))
  Gcoeff(:)%j = (c(53)*M(1,:)%j-c(52)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(54),h0tab(:,54),[16,3,8,4],[nMB,nMB,nMW,nMB],4,1,wf4(:,6))
  call Hloop_QS_A(ntryL,G0H16(1),ex5(:),G0H16(5),ngH,m3h1x16(:,54),heltab2x16(:,:,83))
  call Hloop_Q_A(ntryL,G0H16(5),16,nMB,G1H16(14),n2h16(26))
  Gcoeff(:)%j = (c(56)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(9),m0h(55),h0tab(:,55),[16,3,8,4],[nMW,nMW,nMB,nMW],4,1,wf4(:,6))
  call Hloop_SS_S(ntryL,G0H16(9),ex5(:),G0H16(13),m3h1x16(:,55),heltab2x16(:,:,84))
  Gcoeff(:)%j = (-(c(20)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(4),m0h(56),h0tab(:,56),[16,3,8,4],[nMH,nMZ,nMT,nMH],4,1,wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(4),ex5(:),G0H16(3),m3h1x16(:,56),heltab2x16(:,:,85))
  Gcoeff(:)%j = (-(c(19)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(57),h0tab(:,57),[16,3,8,4],[nMZ,nMH,nMT,nMZ],4,1,wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(8),ex5(:),G0H16(6),m3h1x16(:,57),heltab2x16(:,:,86))
  Gcoeff(:)%j = (-(c(187)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(58),h0tab(:,58),[16,3,8,4],[nMW,nMW,nMB,nMW],4,1,wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(7),ex5(:),G0H16(12),m3h1x16(:,58),heltab2x16(:,:,87))
  Gcoeff(:)%j = (c(159)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(10),m0h(59),h0tab(:,59),[16,3,8,4],[nMT,nMT,0,nMT],4,1,wf4(:,6))
  call Hloop_QS_A(ntryL,G0H16(10),ex5(:),G0H16(11),ngH,m3h1x16(:,59),heltab2x16(:,:,88))
  call Hloop_Q_A(ntryL,G0H16(11),16,nMT,G1H16(21),n2h16(27))
  Gcoeff(:)%j = (c(160)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(60),h0tab(:,60),[16,3,8,4],[nMT,nMT,nMZ,nMT],4,1,wf4(:,6))
  call Hloop_QS_A(ntryL,G0H16(15),ex5(:),G0H16(14),ngH,m3h1x16(:,60),heltab2x16(:,:,89))
  call Hloop_Q_A(ntryL,G0H16(14),16,nMT,G1H16(25),n2h16(28))
  Gcoeff(:)%j = (-(c(89)*M(3,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(61),h0tab(:,61),[16,3,8,4],[nMB,nMB,nMW,nMB],4,1,wf4(:,6))
  call Hloop_QS_A(ntryL,G0H16(2),ex5(:),G0H16(1),ngH,m3h1x16(:,61),heltab2x16(:,:,90))
  call Hloop_Q_A(ntryL,G0H16(1),16,nMB,G1H16(29),n2h16(29))
  Gcoeff(:)%j = (c(164)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(5),m0h(62),h0tab(:,62),[16,3,8,4],[nMT,nMT,0,nMT],4,1,wf4(:,6))
  call Hloop_QS_A(ntryL,G0H16(5),ex5(:),G0H16(9),ngH,m3h1x16(:,62),heltab2x16(:,:,91))
  call Hloop_Q_A(ntryL,G0H16(9),16,nMT,G1H16(6),n2h16(30))
  Gcoeff(:)%j = (c(160)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(4),m0h(63),h0tab(:,63),[16,3,8,4],[nMT,nMT,0,nMT],4,1,wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(4),ex5(:),G0H16(8),ngH,m3h1x16(:,63),heltab2x16(:,:,92))
  call Hloop_Q_A(ntryL,G0H16(8),16,nMT,G1H16(8),n2h16(31))
  Gcoeff(:)%j = (c(161)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(64),h0tab(:,64),[16,3,8,4],[nMT,nMT,nMZ,nMT],4,1,wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(7),ex5(:),G0H16(10),ngH,m3h1x16(:,64),heltab2x16(:,:,93))
  call Hloop_Q_A(ntryL,G0H16(10),16,nMT,G1H16(7),n2h16(32))
  Gcoeff(:)%j = (c(92)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(11),m0h(65),h0tab(:,65),[16,3,8,4],[nMB,nMB,nMW,nMB],4,1,wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(11),ex5(:),G0H16(15),ngH,m3h1x16(:,65),heltab2x16(:,:,94))
  call Hloop_Q_A(ntryL,G0H16(15),16,nMB,G1H16(4),n2h16(33))
  Gcoeff(:)%j = (c(167)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(14),m0h(66),h0tab(:,66),[16,3,8,4],[nMT,nMT,0,nMT],4,1,wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(14),ex5(:),G0H16(2),ngH,m3h1x16(:,66),heltab2x16(:,:,95))
  call Hloop_Q_A(ntryL,G0H16(2),16,nMT,G1H16(11),n2h16(34))
  Gcoeff(:)%j = (c(163)*M(1,:)%j-c(162)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(67),h0tab(:,67),[16,3,8,4],[nMT,nMT,0,nMT],4,1,wf4(:,6))
  call Hloop_QS_A(ntryL,G0H16(1),ex5(:),G0H16(5),ngH,m3h1x16(:,67),heltab2x16(:,:,96))
  call Hloop_Q_A(ntryL,G0H16(5),16,nMT,G1H16(10),n2h16(35))
  Gcoeff(:)%j = (c(166)*M(1,:)%j-c(165)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(9),m0h(68),h0tab(:,68),[16,3,8,4],[nMT,nMT,nMZ,nMT],4,1,wf4(:,6))
  call Hloop_QS_A(ntryL,G0H16(9),ex5(:),G0H16(4),ngH,m3h1x16(:,68),heltab2x16(:,:,97))
  call Hloop_Q_A(ntryL,G0H16(4),16,nMT,G1H16(18),n2h16(36))
  Gcoeff(:)%j = (c(94)*M(1,:)%j-c(93)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(69),h0tab(:,69),[16,3,8,4],[nMB,nMB,nMW,nMB],4,1,wf4(:,6))
  call Hloop_QS_A(ntryL,G0H16(8),ex5(:),G0H16(7),ngH,m3h1x16(:,69),heltab2x16(:,:,98))
  call Hloop_Q_A(ntryL,G0H16(7),16,nMB,G1H16(20),n2h16(37))
  Gcoeff(:)%j = (c(84)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(10),m0h(70),h0tab(:,70),[16,3,8,4],[nMW,nMW,nMB,nMW],4,1,wf4(:,6))
  call Hloop_ST_V(ntryL,G0H16(10),0,ex5(:),16,G1H16(19),m3h1x16(:,70),heltab2x16(:,:,99))
  Gcoeff(:)%j = (-(c(37)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(11),m0h(71),h0tab(:,71),[16,3,8,4],[nMZ,nMH,nMT,nMZ],4,1,wf4(:,1))
  call Hloop_ST_V(ntryL,G0H16(11),0,ex5(:),16,G1H16(15),m3h1x16(:,71),heltab2x16(:,:,100))
  Gcoeff(:)%j = (-(c(135)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(72),h0tab(:,72),[16,3,8,4],[nMW,nMW,nMB,nMW],4,1,wf4(:,1))
  call Hloop_ST_V(ntryL,G0H16(15),0,ex5(:),16,G1H16(16),m3h1x16(:,72),heltab2x16(:,:,101))
  Gcoeff(:)%j = (-(c(95)*M(3,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(14),m0h(73),h0tab(:,73),[16,3,8,4],[nMW,nMW,nMB,nMW],4,1,wf4(:,6))
  call Hloop_SS_S(ntryL,G0H16(14),ex5(:),G0H16(2),m3h1x16(:,73),heltab2x16(:,:,102))
  Gcoeff(:)%j = (-(c(111)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(74),h0tab(:,74),[16,3,8,4],[nMH,nMZ,nMT,nMH],4,1,wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(5),m3h1x16(:,74),heltab2x16(:,:,103))
  Gcoeff(:)%j = (c(137)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(9),m0h(75),h0tab(:,75),[16,3,8,4],[nMW,nMW,nMB,nMW],4,1,wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(9),ex5(:),G0H16(4),m3h1x16(:,75),heltab2x16(:,:,104))
  Gcoeff(:)%j = (c(84)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(76),h0tab(:,76),[16,3,8,4],[nMW,nMW,nMB,nMW],4,1,wf4(:,6))
  call Hloop_VT_S(ntryL,G0H16(8),0,ex5(:),16,G1H16(24),m3h1x16(:,76),heltab2x16(:,:,105))
  Gcoeff(:)%j = (-(c(103)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(77),h0tab(:,77),[16,3,8,4],[nMZ,nMH,nMT,nMZ],4,1,wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(7),0,ex5(:),16,G1H16(22),m3h1x16(:,77),heltab2x16(:,:,106))
  Gcoeff(:)%j = (-(c(194)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(10),m0h(78),h0tab(:,78),[16,3,8,4],[nMW,nMW,nMB,nMW],4,1,wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(10),0,ex5(:),16,G1H16(23),m3h1x16(:,78),heltab2x16(:,:,107))
  Gcoeff(:)%j = (c(84)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(11),m0h(79),h0tab(:,79),[16,3,8,4],[nMW,nMW,nMB,nMW],4,1,wf4(:,6))
  call Hloop_ST_V(ntryL,G0H16(11),0,ex5(:),16,G1H16(28),m3h1x16(:,79),heltab2x16(:,:,108))
  Gcoeff(:)%j = (c(23)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(80),h0tab(:,80),[16,3,8,4],[nMW,nMW,nMB,nMW],4,1,wf4(:,1))
  call Hloop_ST_V(ntryL,G0H16(15),0,ex5(:),16,G1H16(26),m3h1x16(:,80),heltab2x16(:,:,109))
  Gcoeff(:)%j = (c(119)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(14),m0h(81),h0tab(:,81),[16,3,8,4],[nMW,nMW,nMB,nMW],4,1,wf4(:,6))
  call Hloop_VS_V(ntryL,G0H16(14),ex5(:),G0H16(1),m3h1x16(:,81),heltab2x16(:,:,110))
  Gcoeff(:)%j = (-(c(133)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(9),m0h(82),h0tab(:,82),[16,3,8,4],[nMZ,nMH,nMT,nMZ],4,1,wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(9),ex5(:),G0H16(8),m3h1x16(:,82),heltab2x16(:,:,111))
  Gcoeff(:)%j = (-(c(151)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(83),h0tab(:,83),[16,3,8,4],[nMW,nMW,nMB,nMW],4,1,wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(10),m3h1x16(:,83),heltab2x16(:,:,112))
  Gcoeff(:)%j = (-(c(116)*M(3,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(11),m0h(84),h0tab(:,84),[16,3,8,4],[nMW,nMW,nMB,nMW],4,1,wf4(:,6))
  call Hloop_VT_S(ntryL,G0H16(11),0,ex5(:),16,G1H16(27),m3h1x16(:,84),heltab2x16(:,:,113))
  Gcoeff(:)%j = (c(150)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(85),h0tab(:,85),[16,3,8,4],[nMW,nMW,nMB,nMW],4,1,wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(15),0,ex5(:),16,G1H16(31),m3h1x16(:,85),heltab2x16(:,:,114))
  Gcoeff(:)%j = (c(119)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(14),m0h(86),h0tab(:,86),[16,3,8,4],[nMW,nMW,nMB,nMW],4,1,wf4(:,6))
  call Hloop_VS_V(ntryL,G0H16(14),ex5(:),G0H16(9),m3h1x16(:,86),heltab2x16(:,:,115))
  Gcoeff(:)%j = (c(41)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(87),h0tab(:,87),[16,3,8,4],[nMW,nMW,nMB,nMW],4,1,wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(11),m3h1x16(:,87),heltab2x16(:,:,116))
  Gcoeff(:)%j = (-(c(78)*M(3,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(88),h0tab(:,88),[16,3,4,8],[nMT,nMT,nMH,nMT],4,1,wf4(:,6))
  call Hloop_AS_Q(ntryL,G0H16(15),ex5(:),G0H16(14),ngH,m3h1x16(:,88),heltab2x16(:,:,117))
  call Hloop_A_Q(ntryL,G0H16(14),16,nMT,G1H16(30),n2h16(38))
  Gcoeff(:)%j = (c(78)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(89),h0tab(:,89),[16,3,4,8],[nMT,nMT,nMZ,nMT],4,1,wf4(:,6))
  call Hloop_AS_Q(ntryL,G0H16(7),ex5(:),G0H16(15),ngH,m3h1x16(:,89),heltab2x16(:,:,118))
  call Hloop_A_Q(ntryL,G0H16(15),16,nMT,G1H16(32),n2h16(39))
  Gcoeff(:)%j = (-(c(48)*M(3,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(14),m0h(90),h0tab(:,90),[16,3,4,8],[nMB,nMB,nMW,nMB],4,1,wf4(:,6))
  call Hloop_AS_Q(ntryL,G0H16(14),ex5(:),G0H16(7),ngH,m3h1x16(:,90),heltab2x16(:,:,119))
  call Hloop_A_Q(ntryL,G0H16(7),16,nMB,G1H16(33),n2h16(40))
  Gcoeff(:)%j = (-(c(79)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(91),h0tab(:,91),[16,3,4,8],[nMT,nMT,nMH,nMT],4,1,wf4(:,1))
  call Hloop_AS_Q(ntryL,G0H16(15),ex5(:),G0H16(14),ngH,m3h1x16(:,91),heltab2x16(:,:,120))
  call Hloop_A_Q(ntryL,G0H16(14),16,nMT,G1H16(34),n2h16(41))
  Gcoeff(:)%j = (c(79)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(92),h0tab(:,92),[16,3,4,8],[nMT,nMT,nMZ,nMT],4,1,wf4(:,1))
  call Hloop_AS_Q(ntryL,G0H16(7),ex5(:),G0H16(15),ngH,m3h1x16(:,92),heltab2x16(:,:,121))
  call Hloop_A_Q(ntryL,G0H16(15),16,nMT,G1H16(35),n2h16(42))
  Gcoeff(:)%j = (c(51)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(14),m0h(93),h0tab(:,93),[16,3,4,8],[nMB,nMB,nMW,nMB],4,1,wf4(:,1))
  call Hloop_AS_Q(ntryL,G0H16(14),ex5(:),G0H16(7),ngH,m3h1x16(:,93),heltab2x16(:,:,122))
  call Hloop_A_Q(ntryL,G0H16(7),16,nMB,G1H16(36),n2h16(43))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)+c(80)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(94),h0tab(:,94),[16,3,4,8],[nMT,nMT,nMH,nMT],4,1,wf4(:,6))
  call Hloop_AS_Q(ntryL,G0H16(15),ex5(:),G0H16(14),ngH,m3h1x16(:,94),heltab2x16(:,:,123))
  call Hloop_A_Q(ntryL,G0H16(14),16,nMT,G1H16(37),n2h16(44))
  Gcoeff(:)%j = (c(81)*M(1,:)%j-c(80)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(95),h0tab(:,95),[16,3,4,8],[nMT,nMT,nMZ,nMT],4,1,wf4(:,6))
  call Hloop_AS_Q(ntryL,G0H16(7),ex5(:),G0H16(15),ngH,m3h1x16(:,95),heltab2x16(:,:,124))
  call Hloop_A_Q(ntryL,G0H16(15),16,nMT,G1H16(38),n2h16(45))
  Gcoeff(:)%j = (c(53)*M(1,:)%j-c(52)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(14),m0h(96),h0tab(:,96),[16,3,4,8],[nMB,nMB,nMW,nMB],4,1,wf4(:,6))
  call Hloop_AS_Q(ntryL,G0H16(14),ex5(:),G0H16(7),ngH,m3h1x16(:,96),heltab2x16(:,:,125))
  call Hloop_A_Q(ntryL,G0H16(7),16,nMB,G1H16(39),n2h16(46))
  Gcoeff(:)%j = (c(56)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(97),h0tab(:,97),[16,3,4,8],[nMW,nMW,nMB,nMW],4,1,wf4(:,6))
  call Hloop_SS_S(ntryL,G0H16(15),ex5(:),G0H16(14),m3h1x16(:,97),heltab2x16(:,:,126))
  Gcoeff(:)%j = (-(c(20)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(98),h0tab(:,98),[16,3,4,8],[nMH,nMZ,nMT,nMH],4,1,wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(7),ex5(:),G0H16(15),m3h1x16(:,98),heltab2x16(:,:,127))
  Gcoeff(:)%j = (-(c(19)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(99),h0tab(:,99),[16,3,4,8],[nMZ,nMH,nMT,nMZ],4,1,wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(7),ex5(:),G0H16(16),m3h1x16(:,99),heltab2x16(:,:,128))
  Gcoeff(:)%j = (-(c(187)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(100),h0tab(:,100),[16,3,4,8],[nMW,nMW,nMB,nMW],4,1,wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(7),ex5(:),G0H16(17),m3h1x16(:,100),heltab2x16(:,:,129))
  Gcoeff(:)%j = (c(159)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(101),h0tab(:,101),[16,3,4,8],[nMT,nMT,0,nMT],4,1,wf4(:,6))
  call Hloop_AS_Q(ntryL,G0H16(7),ex5(:),G0H16(18),ngH,m3h1x16(:,101),heltab2x16(:,:,130))
  call Hloop_A_Q(ntryL,G0H16(18),16,nMT,G1H16(40),n2h16(47))
  Gcoeff(:)%j = (c(160)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(102),h0tab(:,102),[16,3,4,8],[nMT,nMT,nMZ,nMT],4,1,wf4(:,6))
  call Hloop_AS_Q(ntryL,G0H16(7),ex5(:),G0H16(18),ngH,m3h1x16(:,102),heltab2x16(:,:,131))
  call Hloop_A_Q(ntryL,G0H16(18),16,nMT,G1H16(41),n2h16(48))
  Gcoeff(:)%j = (-(c(89)*M(3,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(103),h0tab(:,103),[16,3,4,8],[nMB,nMB,nMW,nMB],4,1,wf4(:,6))
  call Hloop_AS_Q(ntryL,G0H16(7),ex5(:),G0H16(18),ngH,m3h1x16(:,103),heltab2x16(:,:,132))
  call Hloop_A_Q(ntryL,G0H16(18),16,nMB,G1H16(42),n2h16(49))
  Gcoeff(:)%j = (c(164)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(104),h0tab(:,104),[16,3,4,8],[nMT,nMT,0,nMT],4,1,wf4(:,6))
  call Hloop_AS_Q(ntryL,G0H16(7),ex5(:),G0H16(18),ngH,m3h1x16(:,104),heltab2x16(:,:,133))
  call Hloop_A_Q(ntryL,G0H16(18),16,nMT,G1H16(43),n2h16(50))
  Gcoeff(:)%j = (c(160)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(105),h0tab(:,105),[16,3,4,8],[nMT,nMT,0,nMT],4,1,wf4(:,1))
  call Hloop_AS_Q(ntryL,G0H16(7),ex5(:),G0H16(18),ngH,m3h1x16(:,105),heltab2x16(:,:,134))
  call Hloop_A_Q(ntryL,G0H16(18),16,nMT,G1H16(44),n2h16(51))
  Gcoeff(:)%j = (c(161)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(106),h0tab(:,106),[16,3,4,8],[nMT,nMT,nMZ,nMT],4,1,wf4(:,1))
  call Hloop_AS_Q(ntryL,G0H16(7),ex5(:),G0H16(18),ngH,m3h1x16(:,106),heltab2x16(:,:,135))
  call Hloop_A_Q(ntryL,G0H16(18),16,nMT,G1H16(45),n2h16(52))
  Gcoeff(:)%j = (c(92)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(107),h0tab(:,107),[16,3,4,8],[nMB,nMB,nMW,nMB],4,1,wf4(:,1))
  call Hloop_AS_Q(ntryL,G0H16(7),ex5(:),G0H16(18),ngH,m3h1x16(:,107),heltab2x16(:,:,136))
  call Hloop_A_Q(ntryL,G0H16(18),16,nMB,G1H16(46),n2h16(53))
  Gcoeff(:)%j = (c(167)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(108),h0tab(:,108),[16,3,4,8],[nMT,nMT,0,nMT],4,1,wf4(:,1))
  call Hloop_AS_Q(ntryL,G0H16(7),ex5(:),G0H16(18),ngH,m3h1x16(:,108),heltab2x16(:,:,137))
  call Hloop_A_Q(ntryL,G0H16(18),16,nMT,G1H16(47),n2h16(54))
  Gcoeff(:)%j = (c(163)*M(1,:)%j-c(162)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(109),h0tab(:,109),[16,3,4,8],[nMT,nMT,0,nMT],4,1,wf4(:,6))
  call Hloop_AS_Q(ntryL,G0H16(7),ex5(:),G0H16(18),ngH,m3h1x16(:,109),heltab2x16(:,:,138))
  call Hloop_A_Q(ntryL,G0H16(18),16,nMT,G1H16(48),n2h16(55))
  Gcoeff(:)%j = (c(166)*M(1,:)%j-c(165)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(110),h0tab(:,110),[16,3,4,8],[nMT,nMT,nMZ,nMT],4,1,wf4(:,6))
  call Hloop_AS_Q(ntryL,G0H16(7),ex5(:),G0H16(18),ngH,m3h1x16(:,110),heltab2x16(:,:,139))
  call Hloop_A_Q(ntryL,G0H16(18),16,nMT,G1H16(49),n2h16(56))
  Gcoeff(:)%j = (c(94)*M(1,:)%j-c(93)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(111),h0tab(:,111),[16,3,4,8],[nMB,nMB,nMW,nMB],4,1,wf4(:,6))
  call Hloop_AS_Q(ntryL,G0H16(7),ex5(:),G0H16(18),ngH,m3h1x16(:,111),heltab2x16(:,:,140))
  call Hloop_A_Q(ntryL,G0H16(18),16,nMB,G1H16(50),n2h16(57))
  Gcoeff(:)%j = (-(c(84)*M(3,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(112),h0tab(:,112),[16,3,4,8],[nMW,nMW,nMB,nMW],4,1,wf4(:,6))
  call Hloop_ST_V(ntryL,G0H16(7),0,ex5(:),16,G1H16(51),m3h1x16(:,112),heltab2x16(:,:,141))
  Gcoeff(:)%j = (-(c(37)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(18),m0h(113),h0tab(:,113),[16,3,4,8],[nMZ,nMH,nMT,nMZ],4,1,wf4(:,1))
  call Hloop_ST_V(ntryL,G0H16(18),0,ex5(:),16,G1H16(52),m3h1x16(:,113),heltab2x16(:,:,142))
  Gcoeff(:)%j = (c(135)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(114),h0tab(:,114),[16,3,4,8],[nMW,nMW,nMB,nMW],4,1,wf4(:,1))
  call Hloop_ST_V(ntryL,G0H16(7),0,ex5(:),16,G1H16(53),m3h1x16(:,114),heltab2x16(:,:,143))
  Gcoeff(:)%j = (c(84)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(18),m0h(115),h0tab(:,115),[16,3,4,8],[nMW,nMW,nMB,nMW],4,1,wf4(:,6))
  call Hloop_VT_S(ntryL,G0H16(18),0,ex5(:),16,G1H16(54),m3h1x16(:,115),heltab2x16(:,:,144))
  Gcoeff(:)%j = (-(c(103)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(116),h0tab(:,116),[16,3,4,8],[nMZ,nMH,nMT,nMZ],4,1,wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(7),0,ex5(:),16,G1H16(55),m3h1x16(:,116),heltab2x16(:,:,145))
  Gcoeff(:)%j = (-(c(194)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(18),m0h(117),h0tab(:,117),[16,3,4,8],[nMW,nMW,nMB,nMW],4,1,wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(18),0,ex5(:),16,G1H16(56),m3h1x16(:,117),heltab2x16(:,:,146))
  Gcoeff(:)%j = (c(95)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(118),h0tab(:,118),[16,3,4,8],[nMW,nMW,nMB,nMW],4,1,wf4(:,6))
  call Hloop_SS_S(ntryL,G0H16(7),ex5(:),G0H16(18),m3h1x16(:,118),heltab2x16(:,:,147))
  Gcoeff(:)%j = (-(c(111)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(119),h0tab(:,119),[16,3,4,8],[nMH,nMZ,nMT,nMH],4,1,wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(7),ex5(:),G0H16(19),m3h1x16(:,119),heltab2x16(:,:,148))
  Gcoeff(:)%j = (-(c(137)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(120),h0tab(:,120),[16,3,4,8],[nMW,nMW,nMB,nMW],4,1,wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(7),ex5(:),G0H16(20),m3h1x16(:,120),heltab2x16(:,:,149))
  Gcoeff(:)%j = (-(c(119)*M(3,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(121),h0tab(:,121),[16,3,4,8],[nMW,nMW,nMB,nMW],4,1,wf4(:,6))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(21),m3h1x16(:,121),heltab2x16(:,:,150))
  Gcoeff(:)%j = (-(c(133)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(122),h0tab(:,122),[16,3,4,8],[nMZ,nMH,nMT,nMZ],4,1,wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(22),m3h1x16(:,122),heltab2x16(:,:,151))
  Gcoeff(:)%j = (c(151)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(123),h0tab(:,123),[16,3,4,8],[nMW,nMW,nMB,nMW],4,1,wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(23),m3h1x16(:,123),heltab2x16(:,:,152))
  Gcoeff(:)%j = (c(84)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(124),h0tab(:,124),[16,3,4,8],[nMW,nMW,nMB,nMW],4,1,wf4(:,6))
  call Hloop_ST_V(ntryL,G0H16(7),0,ex5(:),16,G1H16(57),m3h1x16(:,124),heltab2x16(:,:,153))
  Gcoeff(:)%j = (c(23)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(125),h0tab(:,125),[16,3,4,8],[nMW,nMW,nMB,nMW],4,1,wf4(:,1))
  call Hloop_ST_V(ntryL,G0H16(7),0,ex5(:),16,G1H16(58),m3h1x16(:,125),heltab2x16(:,:,154))
  Gcoeff(:)%j = (c(116)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(126),h0tab(:,126),[16,3,4,8],[nMW,nMW,nMB,nMW],4,1,wf4(:,6))
  call Hloop_VT_S(ntryL,G0H16(7),0,ex5(:),16,G1H16(59),m3h1x16(:,126),heltab2x16(:,:,155))
  Gcoeff(:)%j = (-(c(150)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(127),h0tab(:,127),[16,3,4,8],[nMW,nMW,nMB,nMW],4,1,wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(7),0,ex5(:),16,G1H16(60),m3h1x16(:,127),heltab2x16(:,:,156))
  Gcoeff(:)%j = (c(119)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(128),h0tab(:,128),[16,3,4,8],[nMW,nMW,nMB,nMW],4,1,wf4(:,6))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(24),m3h1x16(:,128),heltab2x16(:,:,157))
  Gcoeff(:)%j = (c(41)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(129),h0tab(:,129),[16,3,4,8],[nMW,nMW,nMB,nMW],4,1,wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(25),m3h1x16(:,129),heltab2x16(:,:,158))
  Gcoeff(:)%j = (c(50)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(130),h0tab(:,130),[16,4,3,8],[nMB,nMW,nMW,nMB],4,1,wf4(:,6))
  call Hloop_AS_Q(ntryL,G0H16(7),ex5(:),G0H16(26),ngH,m3h1x16(:,130),heltab2x16(:,:,159))
  call Hloop_A_Q(ntryL,G0H16(26),16,nMB,G1H16(61),n2h16(58))
  Gcoeff(:)%j = (-(c(21)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(131),h0tab(:,131),[16,4,3,8],[nMT,nMH,nMZ,nMT],4,1,wf4(:,1))
  call Hloop_AS_Q(ntryL,G0H16(7),ex5(:),G0H16(26),ngH,m3h1x16(:,131),heltab2x16(:,:,160))
  call Hloop_A_Q(ntryL,G0H16(26),16,nMT,G1H16(62),n2h16(59))
  Gcoeff(:)%j = (-(c(21)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(132),h0tab(:,132),[16,4,3,8],[nMT,nMZ,nMH,nMT],4,1,wf4(:,1))
  call Hloop_AS_Q(ntryL,G0H16(7),ex5(:),G0H16(26),ngH,m3h1x16(:,132),heltab2x16(:,:,161))
  call Hloop_A_Q(ntryL,G0H16(26),16,nMT,G1H16(63),n2h16(60))
  Gcoeff(:)%j = (-(c(186)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(133),h0tab(:,133),[16,4,3,8],[nMB,nMW,nMW,nMB],4,1,wf4(:,1))
  call Hloop_AS_Q(ntryL,G0H16(7),ex5(:),G0H16(26),ngH,m3h1x16(:,133),heltab2x16(:,:,162))
  call Hloop_A_Q(ntryL,G0H16(26),16,nMB,G1H16(64),n2h16(61))
  Gcoeff(:)%j = (-(c(74)*M(3,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(134),h0tab(:,134),[16,4,3,8],[nMH,nMT,nMT,nMH],4,1,wf4(:,6))
  call Hloop_SS_S(ntryL,G0H16(7),ex5(:),G0H16(26),m3h1x16(:,134),heltab2x16(:,:,163))
  Gcoeff(:)%j = (c(69)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(135),h0tab(:,135),[16,4,3,8],[nMZ,nMT,nMT,nMZ],4,1,wf4(:,6))
  call Hloop_SS_S(ntryL,G0H16(7),ex5(:),G0H16(27),m3h1x16(:,135),heltab2x16(:,:,164))
  Gcoeff(:)%j = (-(c(54)*M(3,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(136),h0tab(:,136),[16,4,3,8],[nMW,nMB,nMB,nMW],4,1,wf4(:,6))
  call Hloop_SS_S(ntryL,G0H16(7),ex5(:),G0H16(28),m3h1x16(:,136),heltab2x16(:,:,165))
  Gcoeff(:)%j = (-(c(75)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(137),h0tab(:,137),[16,4,3,8],[nMH,nMT,nMT,nMH],4,1,wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(7),ex5(:),G0H16(29),m3h1x16(:,137),heltab2x16(:,:,166))
  Gcoeff(:)%j = (c(71)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(138),h0tab(:,138),[16,4,3,8],[nMZ,nMT,nMT,nMZ],4,1,wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(7),ex5(:),G0H16(30),m3h1x16(:,138),heltab2x16(:,:,167))
  Gcoeff(:)%j = (c(57)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(139),h0tab(:,139),[16,4,3,8],[nMW,nMB,nMB,nMW],4,1,wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(7),ex5(:),G0H16(31),m3h1x16(:,139),heltab2x16(:,:,168))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)+c(76)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(140),h0tab(:,140),[16,4,3,8],[nMH,nMT,nMT,nMH],4,1,wf4(:,6))
  call Hloop_SS_S(ntryL,G0H16(7),ex5(:),G0H16(32),m3h1x16(:,140),heltab2x16(:,:,169))
  Gcoeff(:)%j = (c(73)*M(1,:)%j-c(72)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(141),h0tab(:,141),[16,4,3,8],[nMZ,nMT,nMT,nMZ],4,1,wf4(:,6))
  call Hloop_SS_S(ntryL,G0H16(7),ex5(:),G0H16(33),m3h1x16(:,141),heltab2x16(:,:,170))
  Gcoeff(:)%j = (c(59)*M(1,:)%j-c(58)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(142),h0tab(:,142),[16,4,3,8],[nMW,nMB,nMB,nMW],4,1,wf4(:,6))
  call Hloop_SS_S(ntryL,G0H16(7),ex5(:),G0H16(34),m3h1x16(:,142),heltab2x16(:,:,171))
  Gcoeff(:)%j = (-(c(91)*M(3,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(143),h0tab(:,143),[16,4,3,8],[nMB,nMW,nMW,nMB],4,1,wf4(:,6))
  call Hloop_AS_Q(ntryL,G0H16(7),ex5(:),G0H16(35),ngH,m3h1x16(:,143),heltab2x16(:,:,172))
  call Hloop_A_Q(ntryL,G0H16(35),16,nMB,G1H16(65),n2h16(62))
  Gcoeff(:)%j = (-(c(114)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(144),h0tab(:,144),[16,4,3,8],[nMT,nMH,nMZ,nMT],4,1,wf4(:,1))
  call Hloop_AS_Q(ntryL,G0H16(7),ex5(:),G0H16(35),ngH,m3h1x16(:,144),heltab2x16(:,:,173))
  call Hloop_A_Q(ntryL,G0H16(35),16,nMT,G1H16(66),n2h16(63))
  Gcoeff(:)%j = (c(136)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(145),h0tab(:,145),[16,4,3,8],[nMB,nMW,nMW,nMB],4,1,wf4(:,1))
  call Hloop_AS_Q(ntryL,G0H16(7),ex5(:),G0H16(35),ngH,m3h1x16(:,145),heltab2x16(:,:,174))
  call Hloop_A_Q(ntryL,G0H16(35),16,nMB,G1H16(67),n2h16(64))
  Gcoeff(:)%j = (c(91)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(146),h0tab(:,146),[16,4,3,8],[nMB,nMW,nMW,nMB],4,1,wf4(:,6))
  call Hloop_AS_Q(ntryL,G0H16(7),ex5(:),G0H16(35),ngH,m3h1x16(:,146),heltab2x16(:,:,175))
  call Hloop_A_Q(ntryL,G0H16(35),16,nMB,G1H16(68),n2h16(65))
  Gcoeff(:)%j = (-(c(114)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(147),h0tab(:,147),[16,4,3,8],[nMT,nMZ,nMH,nMT],4,1,wf4(:,1))
  call Hloop_AS_Q(ntryL,G0H16(7),ex5(:),G0H16(35),ngH,m3h1x16(:,147),heltab2x16(:,:,176))
  call Hloop_A_Q(ntryL,G0H16(35),16,nMT,G1H16(69),n2h16(66))
  Gcoeff(:)%j = (-(c(136)*M(3,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(148),h0tab(:,148),[16,4,3,8],[nMB,nMW,nMW,nMB],4,1,wf4(:,1))
  call Hloop_AS_Q(ntryL,G0H16(7),ex5(:),G0H16(35),ngH,m3h1x16(:,148),heltab2x16(:,:,177))
  call Hloop_A_Q(ntryL,G0H16(35),16,nMB,G1H16(70),n2h16(67))
  Gcoeff(:)%j = (c(138)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(149),h0tab(:,149),[16,4,3,8],[nMZ,nMT,nMT,nMZ],4,1,wf4(:,6))
  call Hloop_VT_S(ntryL,G0H16(7),0,ex5(:),16,G1H16(71),m3h1x16(:,149),heltab2x16(:,:,178))
  Gcoeff(:)%j = (-(c(82)*M(3,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(35),m0h(150),h0tab(:,150),[16,4,3,8],[nMW,nMB,nMB,nMW],4,1,wf4(:,6))
  call Hloop_VT_S(ntryL,G0H16(35),0,ex5(:),16,G1H16(72),m3h1x16(:,150),heltab2x16(:,:,179))
  Gcoeff(:)%j = (c(140)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(151),h0tab(:,151),[16,4,3,8],[nMZ,nMT,nMT,nMZ],4,1,wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(7),0,ex5(:),16,G1H16(73),m3h1x16(:,151),heltab2x16(:,:,180))
  Gcoeff(:)%j = (c(85)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(35),m0h(152),h0tab(:,152),[16,4,3,8],[nMW,nMB,nMB,nMW],4,1,wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(35),0,ex5(:),16,G1H16(74),m3h1x16(:,152),heltab2x16(:,:,181))
  Gcoeff(:)%j = (c(143)*M(1,:)%j-c(142)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(153),h0tab(:,153),[16,4,3,8],[nMZ,nMT,nMT,nMZ],4,1,wf4(:,6))
  call Hloop_VT_S(ntryL,G0H16(7),0,ex5(:),16,G1H16(75),m3h1x16(:,153),heltab2x16(:,:,182))
  Gcoeff(:)%j = (c(88)*M(1,:)%j-c(87)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(35),m0h(154),h0tab(:,154),[16,4,3,8],[nMW,nMB,nMB,nMW],4,1,wf4(:,6))
  call Hloop_VT_S(ntryL,G0H16(35),0,ex5(:),16,G1H16(76),m3h1x16(:,154),heltab2x16(:,:,183))
  Gcoeff(:)%j = (c(138)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(155),h0tab(:,155),[16,4,3,8],[nMZ,nMT,nMT,nMZ],4,1,wf4(:,6))
  call Hloop_ST_V(ntryL,G0H16(7),0,ex5(:),16,G1H16(77),m3h1x16(:,155),heltab2x16(:,:,184))
  Gcoeff(:)%j = (-(c(82)*M(3,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(35),m0h(156),h0tab(:,156),[16,4,3,8],[nMW,nMB,nMB,nMW],4,1,wf4(:,6))
  call Hloop_ST_V(ntryL,G0H16(35),0,ex5(:),16,G1H16(78),m3h1x16(:,156),heltab2x16(:,:,185))
  Gcoeff(:)%j = (c(140)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(157),h0tab(:,157),[16,4,3,8],[nMZ,nMT,nMT,nMZ],4,1,wf4(:,1))
  call Hloop_ST_V(ntryL,G0H16(7),0,ex5(:),16,G1H16(79),m3h1x16(:,157),heltab2x16(:,:,186))
  Gcoeff(:)%j = (c(85)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(35),m0h(158),h0tab(:,158),[16,4,3,8],[nMW,nMB,nMB,nMW],4,1,wf4(:,1))
  call Hloop_ST_V(ntryL,G0H16(35),0,ex5(:),16,G1H16(80),m3h1x16(:,158),heltab2x16(:,:,187))
  Gcoeff(:)%j = (c(143)*M(1,:)%j-c(142)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(159),h0tab(:,159),[16,4,3,8],[nMZ,nMT,nMT,nMZ],4,1,wf4(:,6))
  call Hloop_ST_V(ntryL,G0H16(7),0,ex5(:),16,G1H16(81),m3h1x16(:,159),heltab2x16(:,:,188))
  Gcoeff(:)%j = (c(88)*M(1,:)%j-c(87)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(35),m0h(160),h0tab(:,160),[16,4,3,8],[nMW,nMB,nMB,nMW],4,1,wf4(:,6))
  call Hloop_ST_V(ntryL,G0H16(35),0,ex5(:),16,G1H16(82),m3h1x16(:,160),heltab2x16(:,:,189))
  Gcoeff(:)%j = (c(91)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(161),h0tab(:,161),[16,4,3,8],[nMB,nMW,nMW,nMB],4,1,wf4(:,6))
  call Hloop_AS_Q(ntryL,G0H16(7),ex5(:),G0H16(35),ngH,m3h1x16(:,161),heltab2x16(:,:,190))
  call Hloop_A_Q(ntryL,G0H16(35),16,nMB,G1H16(83),n2h16(68))
  Gcoeff(:)%j = (c(25)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(162),h0tab(:,162),[16,4,3,8],[nMB,nMW,nMW,nMB],4,1,wf4(:,1))
  call Hloop_AS_Q(ntryL,G0H16(7),ex5(:),G0H16(35),ngH,m3h1x16(:,162),heltab2x16(:,:,191))
  call Hloop_A_Q(ntryL,G0H16(35),16,nMB,G1H16(84),n2h16(69))
  Gcoeff(:)%j = (c(172)*M(3,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(163),h0tab(:,163),[16,4,3,8],[nMZ,nMT,nMT,nMZ],4,1,wf4(:,6))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(35),m3h1x16(:,163),heltab2x16(:,:,192))
  Gcoeff(:)%j = (-(c(115)*M(3,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(164),h0tab(:,164),[16,4,3,8],[nMW,nMB,nMB,nMW],4,1,wf4(:,6))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(36),m3h1x16(:,164),heltab2x16(:,:,193))
  Gcoeff(:)%j = (c(173)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(165),h0tab(:,165),[16,4,3,8],[nMZ,nMT,nMT,nMZ],4,1,wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(37),m3h1x16(:,165),heltab2x16(:,:,194))
  Gcoeff(:)%j = (c(120)*M(3,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(166),h0tab(:,166),[16,4,3,8],[nMW,nMB,nMB,nMW],4,1,wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(38),m3h1x16(:,166),heltab2x16(:,:,195))
  Gcoeff(:)%j = (c(175)*M(1,:)%j-c(174)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(167),h0tab(:,167),[16,4,3,8],[nMZ,nMT,nMT,nMZ],4,1,wf4(:,6))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(39),m3h1x16(:,167),heltab2x16(:,:,196))
  Gcoeff(:)%j = (c(128)*M(1,:)%j-c(127)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(168),h0tab(:,168),[16,4,3,8],[nMW,nMB,nMB,nMW],4,1,wf4(:,6))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(40),m3h1x16(:,168),heltab2x16(:,:,197))
  Gcoeff(:)%j = (-(c(103)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(169),h0tab(:,169),[16,1,2,12],[nMZ,0,nMZ,nMZ],4,1,wf4(:,47))
  call Hloop_ST_V(ntryL,G0H16(7),0,ex5(:),16,G1H16(85),m3h1x16(:,169),heltab2x16(:,:,198))
  Gcoeff(:)%j = (-(c(9)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(170),h0tab(:,170),[16,1,2,12],[nMW,0,nMW,nMW],4,1,wf4(:,47))
  call Hloop_ST_V(ntryL,G0H16(7),0,ex5(:),16,G1H16(86),m3h1x16(:,170),heltab2x16(:,:,199))
  Gcoeff(:)%j = (-(c(9)*M(3,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(171),h0tab(:,171),[16,1,2,12],[nMW,0,nMW,nMW],4,1,wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(7),0,ex5(:),16,G1H16(87),m3h1x16(:,171),heltab2x16(:,:,200))
  Gcoeff(:)%j = (-(c(133)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(172),h0tab(:,172),[16,1,2,12],[nMZ,0,nMZ,nMZ],4,1,wf4(:,47))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(41),m3h1x16(:,172),heltab2x16(:,:,201))
  Gcoeff(:)%j = (-(c(14)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(173),h0tab(:,173),[16,1,2,12],[nMW,0,nMW,nMW],4,1,wf4(:,47))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(42),m3h1x16(:,173),heltab2x16(:,:,202))
  Gcoeff(:)%j = (-(c(116)*M(3,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(174),h0tab(:,174),[16,1,2,12],[nMW,0,nMW,nMW],4,1,wf4(:,9))
  call Hloop_ST_V(ntryL,G0H16(7),0,ex5(:),16,G1H16(88),m3h1x16(:,174),heltab2x16(:,:,203))
  Gcoeff(:)%j = (c(150)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(175),h0tab(:,175),[16,1,2,12],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_ST_V(ntryL,G0H16(7),0,ex5(:),16,G1H16(89),m3h1x16(:,175),heltab2x16(:,:,204))
  Gcoeff(:)%j = (c(119)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(176),h0tab(:,176),[16,1,2,12],[nMW,0,nMW,nMW],4,1,wf4(:,9))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(43),m3h1x16(:,176),heltab2x16(:,:,205))
  Gcoeff(:)%j = (c(41)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(177),h0tab(:,177),[16,1,2,12],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(44),m3h1x16(:,177),heltab2x16(:,:,206))
  Gcoeff(:)%j = (-(c(103)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(178),h0tab(:,178),[16,2,1,12],[nMZ,0,nMZ,nMZ],4,1,wf4(:,47))
  call Hloop_ST_V(ntryL,G0H16(7),0,ex5(:),16,G1H16(90),m3h1x16(:,178),heltab2x16(:,:,207))
  Gcoeff(:)%j = (-(c(9)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(179),h0tab(:,179),[16,2,1,12],[nMW,0,nMW,nMW],4,1,wf4(:,47))
  call Hloop_ST_V(ntryL,G0H16(7),0,ex5(:),16,G1H16(91),m3h1x16(:,179),heltab2x16(:,:,208))
  Gcoeff(:)%j = (c(9)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(180),h0tab(:,180),[16,2,1,12],[nMW,0,nMW,nMW],4,1,wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(7),0,ex5(:),16,G1H16(92),m3h1x16(:,180),heltab2x16(:,:,209))
  Gcoeff(:)%j = (-(c(133)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(181),h0tab(:,181),[16,2,1,12],[nMZ,0,nMZ,nMZ],4,1,wf4(:,47))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(45),m3h1x16(:,181),heltab2x16(:,:,210))
  Gcoeff(:)%j = (-(c(14)*M(3,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(182),h0tab(:,182),[16,2,1,12],[nMW,0,nMW,nMW],4,1,wf4(:,47))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(46),m3h1x16(:,182),heltab2x16(:,:,211))
  Gcoeff(:)%j = (c(116)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(183),h0tab(:,183),[16,2,1,12],[nMW,0,nMW,nMW],4,1,wf4(:,9))
  call Hloop_ST_V(ntryL,G0H16(7),0,ex5(:),16,G1H16(93),m3h1x16(:,183),heltab2x16(:,:,212))
  Gcoeff(:)%j = (-(c(150)*M(3,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(184),h0tab(:,184),[16,2,1,12],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_ST_V(ntryL,G0H16(7),0,ex5(:),16,G1H16(94),m3h1x16(:,184),heltab2x16(:,:,213))
  Gcoeff(:)%j = (c(119)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(185),h0tab(:,185),[16,2,1,12],[nMW,0,nMW,nMW],4,1,wf4(:,9))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(47),m3h1x16(:,185),heltab2x16(:,:,214))
  Gcoeff(:)%j = (c(41)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(186),h0tab(:,186),[16,2,1,12],[nMW,0,nMW,nMW],4,1,wf4(:,4))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(48),m3h1x16(:,186),heltab2x16(:,:,215))
  Gcoeff(:)%j = (c(172)*M(3,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(187),h0tab(:,187),[16,1,12,2],[nMZ,0,0,nMZ],4,1,wf4(:,9))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(49),m3h1x16(:,187),heltab2x16(:,:,216))
  Gcoeff(:)%j = (-(c(115)*M(3,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(188),h0tab(:,188),[16,1,12,2],[nMW,0,0,nMW],4,1,wf4(:,9))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(50),m3h1x16(:,188),heltab2x16(:,:,217))
  Gcoeff(:)%j = (c(173)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(189),h0tab(:,189),[16,1,12,2],[nMZ,0,0,nMZ],4,1,wf4(:,4))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(51),m3h1x16(:,189),heltab2x16(:,:,218))
  Gcoeff(:)%j = (c(120)*M(3,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(190),h0tab(:,190),[16,1,12,2],[nMW,0,0,nMW],4,1,wf4(:,4))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(52),m3h1x16(:,190),heltab2x16(:,:,219))
  Gcoeff(:)%j = (c(175)*M(1,:)%j-c(174)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(191),h0tab(:,191),[16,1,12,2],[nMZ,0,0,nMZ],4,1,wf4(:,9))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(53),m3h1x16(:,191),heltab2x16(:,:,220))
  Gcoeff(:)%j = (c(128)*M(1,:)%j-c(127)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(192),h0tab(:,192),[16,1,12,2],[nMW,0,0,nMW],4,1,wf4(:,9))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(54),m3h1x16(:,192),heltab2x16(:,:,221))
  Gcoeff(:)%j = (c(159)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(193),h0tab(:,193),[20,2,1,8],[0,0,0,nMT],4,1,wf2(:,2))
  call Hloop_AQ_V(ntryL,G0H16(7),wf2(:,2),G0H8(1),m3h2x8(:,30),heltab2x16(:,:,222))
  Gcoeff(:)%j = (c(160)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(194),h0tab(:,194),[20,2,1,8],[nMZ,0,0,nMT],4,1,wf2(:,2))
  call Hloop_AQ_Z(ntryL,G0H16(7),wf2(:,2),G0H8(2),ngZu,m3h2x8(:,31),heltab2x16(:,:,223))
  Gcoeff(:)%j = (c(160)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(195),h0tab(:,195),[20,2,1,8],[0,0,nMZ,nMT],4,1,wf2(:,2))
  call Hloop_AQ_V(ntryL,G0H16(7),wf2(:,2),G0H8(3),m3h2x8(:,32),heltab2x16(:,:,224))
  Gcoeff(:)%j = (c(161)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(196),h0tab(:,196),[20,2,1,8],[nMZ,0,nMZ,nMT],4,1,wf2(:,2))
  call Hloop_AQ_Z(ntryL,G0H16(7),wf2(:,2),G0H8(4),ngZu,m3h2x8(:,33),heltab2x16(:,:,225))
  Gcoeff(:)%j = (c(10)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(197),h0tab(:,197),[20,2,1,8],[nMW,0,nMW,nMB],4,1,wf2(:,2))
  call Hloop_AQ_W(ntryL,G0H16(7),wf2(:,2),G0H8(5),m3h2x8(:,34),heltab2x16(:,:,226))
  Gcoeff(:)%j = (c(163)*M(1,:)%j-c(162)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(198),h0tab(:,198),[20,2,1,8],[0,0,0,nMT],4,1,wf2(:,2))
  call Hloop_AQ_V(ntryL,G0H16(7),wf2(:,2),G0H8(6),m3h2x8(:,35),heltab2x16(:,:,227))
  Gcoeff(:)%j = (c(163)*M(1,:)%j-c(162)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(199),h0tab(:,199),[20,2,1,8],[0,0,0,nMT],4,1,wf2(:,2))
  call Hloop_AQ_V(ntryL,G0H16(7),wf2(:,2),G0H8(7),m3h2x8(:,36),heltab2x16(:,:,228))
  Gcoeff(:)%j = (c(166)*M(1,:)%j-c(165)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(200),h0tab(:,200),[20,2,1,8],[0,0,nMZ,nMT],4,1,wf2(:,2))
  call Hloop_AQ_V(ntryL,G0H16(7),wf2(:,2),G0H8(8),m3h2x8(:,37),heltab2x16(:,:,229))
  Gcoeff(:)%j = (c(166)*M(1,:)%j-c(165)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(201),h0tab(:,201),[20,2,1,8],[nMZ,0,0,nMT],4,1,wf2(:,2))
  call Hloop_AQ_Z(ntryL,G0H16(7),wf2(:,2),G0H8(9),ngZu,m3h2x8(:,38),heltab2x16(:,:,230))
  Gcoeff(:)%j = (c(159)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(202),h0tab(:,202),[20,1,2,8],[0,0,0,nMT],4,1,wf2(:,2))
  call Hloop_AQ_V(ntryL,G0H16(7),wf2(:,2),G0H8(10),m3h2x8(:,39),heltab2x16(:,:,231))
  Gcoeff(:)%j = (c(160)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(203),h0tab(:,203),[20,1,2,8],[0,0,nMZ,nMT],4,1,wf2(:,2))
  call Hloop_AQ_V(ntryL,G0H16(7),wf2(:,2),G0H8(11),m3h2x8(:,40),heltab2x16(:,:,232))
  Gcoeff(:)%j = (c(160)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(204),h0tab(:,204),[20,1,2,8],[nMZ,0,0,nMT],4,1,wf2(:,2))
  call Hloop_AQ_Z(ntryL,G0H16(7),wf2(:,2),G0H8(12),ngZu,m3h2x8(:,41),heltab2x16(:,:,233))
  Gcoeff(:)%j = (c(161)*M(3,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(205),h0tab(:,205),[20,1,2,8],[nMZ,0,nMZ,nMT],4,1,wf2(:,2))
  call Hloop_AQ_Z(ntryL,G0H16(7),wf2(:,2),G0H8(13),ngZu,m3h2x8(:,42),heltab2x16(:,:,234))
  Gcoeff(:)%j = (c(163)*M(1,:)%j-c(162)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(206),h0tab(:,206),[20,1,2,8],[0,0,0,nMT],4,1,wf2(:,2))
  call Hloop_AQ_V(ntryL,G0H16(7),wf2(:,2),G0H8(14),m3h2x8(:,43),heltab2x16(:,:,235))
  Gcoeff(:)%j = (c(163)*M(1,:)%j-c(162)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(207),h0tab(:,207),[20,1,2,8],[0,0,0,nMT],4,1,wf2(:,2))
  call Hloop_AQ_V(ntryL,G0H16(7),wf2(:,2),G0H8(15),m3h2x8(:,44),heltab2x16(:,:,236))
  Gcoeff(:)%j = (c(166)*M(1,:)%j-c(165)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(208),h0tab(:,208),[20,1,2,8],[nMZ,0,0,nMT],4,1,wf2(:,2))
  call Hloop_AQ_Z(ntryL,G0H16(7),wf2(:,2),G0H8(16),ngZu,m3h2x8(:,45),heltab2x16(:,:,237))
  Gcoeff(:)%j = (c(166)*M(1,:)%j-c(165)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(209),h0tab(:,209),[20,1,2,8],[0,0,nMZ,nMT],4,1,wf2(:,2))
  call Hloop_AQ_V(ntryL,G0H16(7),wf2(:,2),G0H8(17),m3h2x8(:,46),heltab2x16(:,:,238))
  Gcoeff(:)%j = (c(159)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(210),h0tab(:,210),[24,2,1,4],[0,0,0,nMT],4,1,wf2(:,4))
  call Hloop_QA_V(ntryL,G0H16(7),wf2(:,4),G0H8(18),m3h2x8(:,47),heltab2x16(:,:,239))
  Gcoeff(:)%j = (c(160)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(211),h0tab(:,211),[24,2,1,4],[nMZ,0,0,nMT],4,1,wf2(:,4))
  call Hloop_QA_Z(ntryL,G0H16(7),wf2(:,4),G0H8(19),ngZu,m3h2x8(:,48),heltab2x16(:,:,240))
  Gcoeff(:)%j = (c(160)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(212),h0tab(:,212),[24,2,1,4],[0,0,nMZ,nMT],4,1,wf2(:,4))
  call Hloop_QA_V(ntryL,G0H16(7),wf2(:,4),G0H8(20),m3h2x8(:,49),heltab2x16(:,:,241))
  Gcoeff(:)%j = (c(161)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(213),h0tab(:,213),[24,2,1,4],[nMZ,0,nMZ,nMT],4,1,wf2(:,4))
  call Hloop_QA_Z(ntryL,G0H16(7),wf2(:,4),G0H8(21),ngZu,m3h2x8(:,50),heltab2x16(:,:,242))
  Gcoeff(:)%j = (c(163)*M(1,:)%j-c(162)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(214),h0tab(:,214),[24,2,1,4],[0,0,0,nMT],4,1,wf2(:,4))
  call Hloop_QA_V(ntryL,G0H16(7),wf2(:,4),G0H8(22),m3h2x8(:,51),heltab2x16(:,:,243))
  Gcoeff(:)%j = (c(163)*M(1,:)%j-c(162)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(215),h0tab(:,215),[24,2,1,4],[0,0,0,nMT],4,1,wf2(:,4))
  call Hloop_QA_V(ntryL,G0H16(7),wf2(:,4),G0H8(23),m3h2x8(:,52),heltab2x16(:,:,244))
  Gcoeff(:)%j = (c(166)*M(1,:)%j-c(165)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(216),h0tab(:,216),[24,2,1,4],[0,0,nMZ,nMT],4,1,wf2(:,4))
  call Hloop_QA_V(ntryL,G0H16(7),wf2(:,4),G0H8(24),m3h2x8(:,53),heltab2x16(:,:,245))
  Gcoeff(:)%j = (c(166)*M(1,:)%j-c(165)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(217),h0tab(:,217),[24,2,1,4],[nMZ,0,0,nMT],4,1,wf2(:,4))
  call Hloop_QA_Z(ntryL,G0H16(7),wf2(:,4),G0H8(25),ngZu,m3h2x8(:,54),heltab2x16(:,:,246))
  Gcoeff(:)%j = (c(159)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(218),h0tab(:,218),[24,1,2,4],[0,0,0,nMT],4,1,wf2(:,4))
  call Hloop_QA_V(ntryL,G0H16(7),wf2(:,4),G0H8(26),m3h2x8(:,55),heltab2x16(:,:,247))
  Gcoeff(:)%j = (c(160)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(219),h0tab(:,219),[24,1,2,4],[0,0,nMZ,nMT],4,1,wf2(:,4))
  call Hloop_QA_V(ntryL,G0H16(7),wf2(:,4),G0H8(27),m3h2x8(:,56),heltab2x16(:,:,248))
  Gcoeff(:)%j = (c(160)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(220),h0tab(:,220),[24,1,2,4],[nMZ,0,0,nMT],4,1,wf2(:,4))
  call Hloop_QA_Z(ntryL,G0H16(7),wf2(:,4),G0H8(28),ngZu,m3h2x8(:,57),heltab2x16(:,:,249))
  Gcoeff(:)%j = (c(161)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(221),h0tab(:,221),[24,1,2,4],[nMZ,0,nMZ,nMT],4,1,wf2(:,4))
  call Hloop_QA_Z(ntryL,G0H16(7),wf2(:,4),G0H8(29),ngZu,m3h2x8(:,58),heltab2x16(:,:,250))
  Gcoeff(:)%j = (c(10)*M(3,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(222),h0tab(:,222),[24,1,2,4],[nMW,0,nMW,nMB],4,1,wf2(:,4))
  call Hloop_QA_W(ntryL,G0H16(7),wf2(:,4),G0H8(30),m3h2x8(:,59),heltab2x16(:,:,251))
  Gcoeff(:)%j = (c(163)*M(1,:)%j-c(162)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(223),h0tab(:,223),[24,1,2,4],[0,0,0,nMT],4,1,wf2(:,4))
  call Hloop_QA_V(ntryL,G0H16(7),wf2(:,4),G0H8(31),m3h2x8(:,60),heltab2x16(:,:,252))
  Gcoeff(:)%j = (c(163)*M(1,:)%j-c(162)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(224),h0tab(:,224),[24,1,2,4],[0,0,0,nMT],4,1,wf2(:,4))
  call Hloop_QA_V(ntryL,G0H16(7),wf2(:,4),G0H8(32),m3h2x8(:,61),heltab2x16(:,:,253))
  Gcoeff(:)%j = (c(166)*M(1,:)%j-c(165)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(225),h0tab(:,225),[24,1,2,4],[nMZ,0,0,nMT],4,1,wf2(:,4))
  call Hloop_QA_Z(ntryL,G0H16(7),wf2(:,4),G0H8(33),ngZu,m3h2x8(:,62),heltab2x16(:,:,254))
  Gcoeff(:)%j = (c(166)*M(1,:)%j-c(165)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(226),h0tab(:,226),[24,1,2,4],[0,0,nMZ,nMT],4,1,wf2(:,4))
  call Hloop_QA_V(ntryL,G0H16(7),wf2(:,4),G0H8(34),m3h2x8(:,63),heltab2x16(:,:,255))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(12),[G1H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(13),[G1H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(14),[G1H16(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(10),[G1H16(6),G1H16(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(18),[G1H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(20),[G1H16(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(11),[G1H16(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(37),[G1H16(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(38),[G1H16(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(39),[G1H16(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(48),[G1H16(43),G1H16(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(49),[G1H16(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(50),[G1H16(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(47),[G1H16(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(32),[G0H16(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(33),[G0H16(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(34),[G0H16(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(75),[G1H16(71)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(76),[G1H16(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(81),[G1H16(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(82),[G1H16(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(39),[G0H16(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(40),[G0H16(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(53),[G0H16(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(54),[G0H16(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(7),[G0H8(6),G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(9),[G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(8),[G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(15),[G0H8(14),G0H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(17),[G0H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(16),[G0H8(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(23),[G0H8(22),G0H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(25),[G0H8(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(24),[G0H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(32),[G0H8(31),G0H8(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(34),[G0H8(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(33),[G0H8(28)])
  call Hloop_QV_A(ntryL,G1H16(12),wf4(:,6),G1H4(9),m3h4x4(:,1),heltab2x16(:,:,256))
  call Hloop_Q_A(ntryL,G1H4(9),19,nMT,G2H4(1),n2h4(20))
  call Hloop_QV_A(ntryL,G1H16(13),wf4(:,6),G1H4(10),m3h4x4(:,2),heltab2x16(:,:,257))
  call Hloop_Q_A(ntryL,G1H4(10),19,nMT,G2H4(2),n2h4(21))
  call Hloop_QV_A(ntryL,G1H16(14),wf4(:,6),G1H4(11),m3h4x4(:,3),heltab2x16(:,:,258))
  call Hloop_Q_A(ntryL,G1H4(11),19,nMB,G2H4(3),n2h4(22))
  call Hloop_QZ_A(ntryL,G1H16(3),wf4(:,1),G1H4(12),ngZu,m3h4x4(:,4),heltab2x16(:,:,259))
  call Hloop_Q_A(ntryL,G1H4(12),19,nMT,G2H4(4),n2h4(23))
  call Hloop_QZ_A(ntryL,G1H16(9),wf4(:,1),G1H4(15),ngZu,m3h4x4(:,5),heltab2x16(:,:,260))
  call Hloop_Q_A(ntryL,G1H4(15),19,nMT,G2H4(5),n2h4(24))
  call Hloop_QZ_A(ntryL,G1H16(17),wf4(:,1),G1H4(16),ngZd,m3h4x4(:,6),heltab2x16(:,:,261))
  call Hloop_Q_A(ntryL,G1H4(16),19,nMB,G2H4(6),n2h4(25))
  call Hloop_SV_T(ntryL,G0H16(13),16,wf4(:,6),3,G1H4(17),m3h4x4(:,7),heltab2x16(:,:,262))
  call Hloop_TV_S(ntryL,G0H16(3),16,wf4(:,1),3,G1H4(18),m3h4x4(:,8),heltab2x16(:,:,263))
  call Hloop_SV_T(ntryL,G0H16(6),16,wf4(:,1),3,G1H4(21),m3h4x4(:,9),heltab2x16(:,:,264))
  call Hloop_SV_T(ntryL,G0H16(12),16,wf4(:,1),3,G1H4(22),m3h4x4(:,10),heltab2x16(:,:,265))
  call Hloop_QV_A(ntryL,G1H16(10),wf4(:,6),G1H4(1),m3h4x4(:,11),heltab2x16(:,:,266))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(7),n2h4(26))
  call Hloop_QV_A(ntryL,G1H16(18),wf4(:,6),G1H4(2),m3h4x4(:,12),heltab2x16(:,:,267))
  call Hloop_Q_A(ntryL,G1H4(2),19,nMT,G2H4(8),n2h4(27))
  call Hloop_QV_A(ntryL,G1H16(20),wf4(:,6),G1H4(25),m3h4x4(:,13),heltab2x16(:,:,268))
  call Hloop_Q_A(ntryL,G1H4(25),19,nMB,G2H4(9),n2h4(28))
  call Hloop_QZ_A(ntryL,G1H16(11),wf4(:,1),G1H4(26),ngZu,m3h4x4(:,14),heltab2x16(:,:,269))
  call Hloop_Q_A(ntryL,G1H4(26),19,nMT,G2H4(10),n2h4(29))
  call Hloop_QZ_A(ntryL,G1H16(7),wf4(:,1),G1H4(27),ngZu,m3h4x4(:,15),heltab2x16(:,:,270))
  call Hloop_Q_A(ntryL,G1H4(27),19,nMT,G2H4(11),n2h4(30))
  call Hloop_QZ_A(ntryL,G1H16(4),wf4(:,1),G1H4(28),ngZd,m3h4x4(:,16),heltab2x16(:,:,271))
  call Hloop_Q_A(ntryL,G1H4(28),19,nMB,G2H4(12),n2h4(31))
  call Hloop_VV_S(ntryL,G1H16(19),wf4(:,6),G1H4(31),m3h4x4(:,17),heltab2x16(:,:,272))
  call Hloop_VV_S(ntryL,G1H16(15),wf4(:,1),G1H4(32),m3h4x4(:,18),heltab2x16(:,:,273))
  call Hloop_VV_S(ntryL,G1H16(16),wf4(:,1),G1H4(33),m3h4x4(:,19),heltab2x16(:,:,274))
  call Hloop_SV_V(ntryL,G0H16(2),wf4(:,6),G0H4(1),m3h4x4(:,20),heltab2x16(:,:,275))
  call Hloop_SV_V(ntryL,G0H16(5),wf4(:,1),G0H4(2),m3h4x4(:,21),heltab2x16(:,:,276))
  call Hloop_SV_V(ntryL,G0H16(4),wf4(:,1),G0H4(3),m3h4x4(:,22),heltab2x16(:,:,277))
  call Hloop_SV_T(ntryL,G1H16(24),16,wf4(:,6),3,G2H4(13),m3h4x4(:,23),heltab2x16(:,:,278))
  call Hloop_SV_T(ntryL,G1H16(22),16,wf4(:,1),3,G2H4(14),m3h4x4(:,24),heltab2x16(:,:,279))
  call Hloop_SV_T(ntryL,G1H16(23),16,wf4(:,1),3,G2H4(15),m3h4x4(:,25),heltab2x16(:,:,280))
  call Hloop_UW_V(ntryL,G1H16(28),16,wf4(:,6),3,G2H4(16),m3h4x4(:,26),heltab2x16(:,:,281))
  call Hloop_UW_V(ntryL,G1H16(26),16,wf4(:,1),3,G2H4(17),m3h4x4(:,27),heltab2x16(:,:,282))
  call Hloop_VV_S(ntryL,G0H16(1),wf4(:,6),G0H4(4),m3h4x4(:,28),heltab2x16(:,:,283))
  call Hloop_VV_S(ntryL,G0H16(8),wf4(:,1),G0H4(5),m3h4x4(:,29),heltab2x16(:,:,284))
  call Hloop_VV_S(ntryL,G0H16(10),wf4(:,1),G0H4(6),m3h4x4(:,30),heltab2x16(:,:,285))
  call Hloop_SV_V(ntryL,G1H16(27),wf4(:,6),G1H4(34),m3h4x4(:,31),heltab2x16(:,:,286))
  call Hloop_SV_V(ntryL,G1H16(31),wf4(:,1),G1H4(37),m3h4x4(:,32),heltab2x16(:,:,287))
  call Hloop_UW_V(ntryL,G0H16(9),16,wf4(:,6),3,G1H4(38),m3h4x4(:,33),heltab2x16(:,:,288))
  call Hloop_UW_V(ntryL,G0H16(11),16,wf4(:,1),3,G1H4(3),m3h4x4(:,34),heltab2x16(:,:,289))
  call Hloop_AV_Q(ntryL,G1H16(37),wf4(:,6),G1H4(4),m3h4x4(:,35),heltab2x16(:,:,290))
  call Hloop_A_Q(ntryL,G1H4(4),19,nMT,G2H4(18),n2h4(32))
  call Hloop_AV_Q(ntryL,G1H16(38),wf4(:,6),G1H4(40),m3h4x4(:,36),heltab2x16(:,:,291))
  call Hloop_A_Q(ntryL,G1H4(40),19,nMT,G2H4(19),n2h4(33))
  call Hloop_AV_Q(ntryL,G1H16(39),wf4(:,6),G1H4(41),m3h4x4(:,37),heltab2x16(:,:,292))
  call Hloop_A_Q(ntryL,G1H4(41),19,nMB,G2H4(20),n2h4(34))
  call Hloop_AZ_Q(ntryL,G1H16(34),wf4(:,1),G1H4(42),ngZu,m3h4x4(:,38),heltab2x16(:,:,293))
  call Hloop_A_Q(ntryL,G1H4(42),19,nMT,G2H4(21),n2h4(35))
  call Hloop_AZ_Q(ntryL,G1H16(35),wf4(:,1),G1H4(43),ngZu,m3h4x4(:,39),heltab2x16(:,:,294))
  call Hloop_A_Q(ntryL,G1H4(43),19,nMT,G2H4(22),n2h4(36))
  call Hloop_AZ_Q(ntryL,G1H16(36),wf4(:,1),G1H4(46),ngZd,m3h4x4(:,40),heltab2x16(:,:,295))
  call Hloop_A_Q(ntryL,G1H4(46),19,nMB,G2H4(23),n2h4(37))
  call Hloop_TV_S(ntryL,G0H16(14),16,wf4(:,6),3,G1H4(47),m3h4x4(:,41),heltab2x16(:,:,296))
  call Hloop_TV_S(ntryL,G0H16(15),16,wf4(:,1),3,G1H4(48),m3h4x4(:,42),heltab2x16(:,:,297))
  call Hloop_SV_T(ntryL,G0H16(16),16,wf4(:,1),3,G1H4(49),m3h4x4(:,43),heltab2x16(:,:,298))
  call Hloop_TV_S(ntryL,G0H16(17),16,wf4(:,1),3,G1H4(52),m3h4x4(:,44),heltab2x16(:,:,299))
  call Hloop_AV_Q(ntryL,G1H16(48),wf4(:,6),G1H4(53),m3h4x4(:,45),heltab2x16(:,:,300))
  call Hloop_A_Q(ntryL,G1H4(53),19,nMT,G2H4(24),n2h4(38))
  call Hloop_AV_Q(ntryL,G1H16(49),wf4(:,6),G1H4(6),m3h4x4(:,46),heltab2x16(:,:,301))
  call Hloop_A_Q(ntryL,G1H4(6),19,nMT,G2H4(25),n2h4(39))
  call Hloop_AV_Q(ntryL,G1H16(50),wf4(:,6),G1H4(7),m3h4x4(:,47),heltab2x16(:,:,302))
  call Hloop_A_Q(ntryL,G1H4(7),19,nMB,G2H4(26),n2h4(40))
  call Hloop_AZ_Q(ntryL,G1H16(47),wf4(:,1),G1H4(55),ngZu,m3h4x4(:,48),heltab2x16(:,:,303))
  call Hloop_A_Q(ntryL,G1H4(55),19,nMT,G2H4(27),n2h4(41))
  call Hloop_AZ_Q(ntryL,G1H16(45),wf4(:,1),G1H4(56),ngZu,m3h4x4(:,49),heltab2x16(:,:,304))
  call Hloop_A_Q(ntryL,G1H4(56),19,nMT,G2H4(28),n2h4(42))
  call Hloop_AZ_Q(ntryL,G1H16(46),wf4(:,1),G1H4(57),ngZd,m3h4x4(:,50),heltab2x16(:,:,305))
  call Hloop_A_Q(ntryL,G1H4(57),19,nMB,G2H4(29),n2h4(43))
  call Hloop_VV_S(ntryL,G1H16(51),wf4(:,6),G1H4(58),m3h4x4(:,51),heltab2x16(:,:,306))
  call Hloop_VV_S(ntryL,G1H16(52),wf4(:,1),G1H4(61),m3h4x4(:,52),heltab2x16(:,:,307))
  call Hloop_VV_S(ntryL,G1H16(53),wf4(:,1),G1H4(62),m3h4x4(:,53),heltab2x16(:,:,308))
  call Hloop_TV_S(ntryL,G1H16(54),16,wf4(:,6),3,G2H4(30),m3h4x4(:,54),heltab2x16(:,:,309))
  call Hloop_SV_T(ntryL,G1H16(55),16,wf4(:,1),3,G2H4(31),m3h4x4(:,55),heltab2x16(:,:,310))
  call Hloop_TV_S(ntryL,G1H16(56),16,wf4(:,1),3,G2H4(32),m3h4x4(:,56),heltab2x16(:,:,311))
  call Hloop_SV_V(ntryL,G0H16(18),wf4(:,6),G0H4(7),m3h4x4(:,57),heltab2x16(:,:,312))
  call Hloop_SV_V(ntryL,G0H16(19),wf4(:,1),G0H4(8),m3h4x4(:,58),heltab2x16(:,:,313))
  call Hloop_SV_V(ntryL,G0H16(20),wf4(:,1),G0H4(9),m3h4x4(:,59),heltab2x16(:,:,314))
  call Hloop_VV_S(ntryL,G0H16(21),wf4(:,6),G0H4(10),m3h4x4(:,60),heltab2x16(:,:,315))
  call Hloop_VV_S(ntryL,G0H16(22),wf4(:,1),G0H4(11),m3h4x4(:,61),heltab2x16(:,:,316))
  call Hloop_VV_S(ntryL,G0H16(23),wf4(:,1),G0H4(12),m3h4x4(:,62),heltab2x16(:,:,317))
  call Hloop_UV_W(ntryL,G1H16(57),16,wf4(:,6),3,G2H4(33),m3h4x4(:,63),heltab2x16(:,:,318))
  call Hloop_UV_W(ntryL,G1H16(58),16,wf4(:,1),3,G2H4(34),m3h4x4(:,64),heltab2x16(:,:,319))
  call Hloop_SV_V(ntryL,G1H16(59),wf4(:,6),G1H4(9),m3h4x4(:,65),heltab2x16(:,:,320))
  call Hloop_SV_V(ntryL,G1H16(60),wf4(:,1),G1H4(10),m3h4x4(:,66),heltab2x16(:,:,321))
  call Hloop_UV_W(ntryL,G0H16(24),16,wf4(:,6),3,G1H4(11),m3h4x4(:,67),heltab2x16(:,:,322))
  call Hloop_UV_W(ntryL,G0H16(25),16,wf4(:,1),3,G1H4(12),m3h4x4(:,68),heltab2x16(:,:,323))
  call Hloop_AQ_S(ntryL,G1H16(61),ex3(:),G1H8(1),ngPbt,m3h2x8(:,64),heltab2x16(:,:,324))
  call Hloop_AQ_S(ntryL,G1H16(62),ex3(:),G1H8(2),ngH,m3h2x8(:,65),heltab2x16(:,:,325))
  call Hloop_AQ_S(ntryL,G1H16(63),ex3(:),G1H8(3),ngX,m3h2x8(:,66),heltab2x16(:,:,326))
  call Hloop_AQ_S(ntryL,G1H16(64),ex3(:),G1H8(4),ngPbt,m3h2x8(:,67),heltab2x16(:,:,327))
  call Hloop_SQ_A(ntryL,G0H16(32),ex3(:),G0H8(6),ngH,m3h2x8(:,68),heltab2x16(:,:,328))
  call Hloop_Q_A(ntryL,G0H8(6),20,nMT,G1H8(5),n2h8(21))
  call Hloop_SQ_A(ntryL,G0H16(33),ex3(:),G0H8(1),ngX,m3h2x8(:,69),heltab2x16(:,:,329))
  call Hloop_Q_A(ntryL,G0H8(1),20,nMT,G1H8(6),n2h8(22))
  call Hloop_SQ_A(ntryL,G0H16(34),ex3(:),G0H8(2),ngPbt,m3h2x8(:,70),heltab2x16(:,:,330))
  call Hloop_Q_A(ntryL,G0H8(2),20,nMB,G1H8(7),n2h8(23))
  call Hloop_SQ_A(ntryL,G0H16(29),ex3(:),G0H8(3),ngH,m3h2x8(:,71),heltab2x16(:,:,331))
  call Hloop_Q_A(ntryL,G0H8(3),20,nMT,G1H8(8),n2h8(24))
  call Hloop_SQ_A(ntryL,G0H16(30),ex3(:),G0H8(14),ngX,m3h2x8(:,72),heltab2x16(:,:,332))
  call Hloop_Q_A(ntryL,G0H8(14),20,nMT,G1H8(9),n2h8(25))
  call Hloop_SQ_A(ntryL,G0H16(31),ex3(:),G0H8(10),ngPbt,m3h2x8(:,73),heltab2x16(:,:,333))
  call Hloop_Q_A(ntryL,G0H8(10),20,nMB,G1H8(10),n2h8(26))
  call Hloop_AQ_S(ntryL,G1H16(65),ex3(:),G1H8(11),ngPbt,m3h2x8(:,74),heltab2x16(:,:,334))
  call Hloop_AQ_S(ntryL,G1H16(66),ex3(:),G1H8(12),ngH,m3h2x8(:,75),heltab2x16(:,:,335))
  call Hloop_AQ_S(ntryL,G1H16(67),ex3(:),G1H8(13),ngPbt,m3h2x8(:,76),heltab2x16(:,:,336))
  call Hloop_AQ_W(ntryL,G1H16(68),ex3(:),G1H8(14),m3h2x8(:,77),heltab2x16(:,:,337))
  call Hloop_AQ_Z(ntryL,G1H16(69),ex3(:),G1H8(15),ngZu,m3h2x8(:,78),heltab2x16(:,:,338))
  call Hloop_AQ_W(ntryL,G1H16(70),ex3(:),G1H8(16),m3h2x8(:,79),heltab2x16(:,:,339))
  call Hloop_SQ_A(ntryL,G1H16(75),ex3(:),G1H8(17),ngX,m3h2x8(:,80),heltab2x16(:,:,340))
  call Hloop_Q_A(ntryL,G1H8(17),20,nMT,G2H8(1),n2h8(27))
  call Hloop_SQ_A(ntryL,G1H16(76),ex3(:),G1H8(18),ngPbt,m3h2x8(:,81),heltab2x16(:,:,341))
  call Hloop_Q_A(ntryL,G1H8(18),20,nMB,G2H8(2),n2h8(28))
  call Hloop_SQ_A(ntryL,G1H16(73),ex3(:),G1H8(19),ngX,m3h2x8(:,82),heltab2x16(:,:,342))
  call Hloop_Q_A(ntryL,G1H8(19),20,nMT,G2H8(3),n2h8(29))
  call Hloop_SQ_A(ntryL,G1H16(74),ex3(:),G1H8(17),ngPbt,m3h2x8(:,83),heltab2x16(:,:,343))
  call Hloop_Q_A(ntryL,G1H8(17),20,nMB,G2H8(4),n2h8(30))
  call Hloop_ZQ_A(ntryL,G1H16(81),ex3(:),G1H8(18),ngZu,m3h2x8(:,84),heltab2x16(:,:,344))
  call Hloop_Q_A(ntryL,G1H8(18),20,nMT,G2H8(5),n2h8(31))
  call Hloop_WQ_A(ntryL,G1H16(82),ex3(:),G1H8(19),m3h2x8(:,85),heltab2x16(:,:,345))
  call Hloop_Q_A(ntryL,G1H8(19),20,nMB,G2H8(6),n2h8(32))
  call Hloop_ZQ_A(ntryL,G1H16(79),ex3(:),G1H8(17),ngZu,m3h2x8(:,86),heltab2x16(:,:,346))
  call Hloop_Q_A(ntryL,G1H8(17),20,nMT,G2H8(7),n2h8(33))
  call Hloop_WQ_A(ntryL,G1H16(80),ex3(:),G1H8(18),m3h2x8(:,87),heltab2x16(:,:,347))
  call Hloop_Q_A(ntryL,G1H8(18),20,nMB,G2H8(8),n2h8(34))
  call Hloop_AQ_W(ntryL,G1H16(83),ex3(:),G1H8(19),m3h2x8(:,88),heltab2x16(:,:,348))
  call Hloop_AQ_W(ntryL,G1H16(84),ex3(:),G1H8(17),m3h2x8(:,89),heltab2x16(:,:,349))
  call Hloop_ZQ_A(ntryL,G0H16(39),ex3(:),G0H8(11),ngZu,m3h2x8(:,90),heltab2x16(:,:,350))
  call Hloop_Q_A(ntryL,G0H8(11),20,nMT,G1H8(18),n2h8(35))
  call Hloop_WQ_A(ntryL,G0H16(40),ex3(:),G0H8(12),m3h2x8(:,91),heltab2x16(:,:,351))
  call Hloop_Q_A(ntryL,G0H8(12),20,nMB,G1H8(20),n2h8(36))
  call Hloop_ZQ_A(ntryL,G0H16(37),ex3(:),G0H8(22),ngZu,m3h2x8(:,92),heltab2x16(:,:,352))
  call Hloop_Q_A(ntryL,G0H8(22),20,nMT,G1H8(21),n2h8(37))
  call Hloop_WQ_A(ntryL,G0H16(38),ex3(:),G0H8(18),m3h2x8(:,93),heltab2x16(:,:,353))
  call Hloop_Q_A(ntryL,G0H8(18),20,nMB,G1H8(22),n2h8(38))
  call Hloop_ZQ_A(ntryL,G1H16(85),ex1(:),G1H8(23),ngZu,m3h2x8(:,94),heltab2x16(:,:,354))
  call Hloop_Q_A(ntryL,G1H8(23),17,0,G2H8(9),n2h8(39))
  call Hloop_WQ_A(ntryL,G1H16(86),ex1(:),G1H8(23),m3h2x8(:,95),heltab2x16(:,:,355))
  call Hloop_Q_A(ntryL,G1H8(23),17,0,G2H8(10),n2h8(40))
  call Hloop_WQ_A(ntryL,G1H16(87),ex1(:),G1H8(23),m3h2x8(:,96),heltab2x16(:,:,356))
  call Hloop_Q_A(ntryL,G1H8(23),17,0,G2H8(11),n2h8(41))
  call Hloop_ZQ_A(ntryL,G0H16(41),ex1(:),G0H8(19),ngZu,m3h2x8(:,97),heltab2x16(:,:,357))
  call Hloop_Q_A(ntryL,G0H8(19),17,0,G1H8(23),n2h8(42))
  call Hloop_WQ_A(ntryL,G0H16(42),ex1(:),G0H8(20),m3h2x8(:,98),heltab2x16(:,:,358))
  call Hloop_Q_A(ntryL,G0H8(20),17,0,G1H8(24),n2h8(43))
  call Hloop_WQ_A(ntryL,G1H16(88),ex1(:),G1H8(25),m3h2x8(:,99),heltab2x16(:,:,359))
  call Hloop_Q_A(ntryL,G1H8(25),17,0,G2H8(12),n2h8(44))
  call Hloop_WQ_A(ntryL,G1H16(89),ex1(:),G1H8(25),m3h2x8(:,100),heltab2x16(:,:,360))
  call Hloop_Q_A(ntryL,G1H8(25),17,0,G2H8(13),n2h8(45))
  call Hloop_WQ_A(ntryL,G0H16(43),ex1(:),G0H8(31),m3h2x8(:,101),heltab2x16(:,:,361))
  call Hloop_Q_A(ntryL,G0H8(31),17,0,G1H8(25),n2h8(46))
  call Hloop_WQ_A(ntryL,G0H16(44),ex1(:),G0H8(26),m3h2x8(:,102),heltab2x16(:,:,362))
  call Hloop_Q_A(ntryL,G0H8(26),17,0,G1H8(26),n2h8(47))
  call Hloop_ZA_Q(ntryL,G1H16(90),ex2(:),G1H8(27),ngZu,m3h2x8(:,103),heltab2x16(:,:,363))
  call Hloop_A_Q(ntryL,G1H8(27),18,0,G2H8(14),n2h8(48))
  call Hloop_WA_Q(ntryL,G1H16(91),ex2(:),G1H8(27),m3h2x8(:,104),heltab2x16(:,:,364))
  call Hloop_A_Q(ntryL,G1H8(27),18,0,G2H8(15),n2h8(49))
  call Hloop_WA_Q(ntryL,G1H16(92),ex2(:),G1H8(27),m3h2x8(:,105),heltab2x16(:,:,365))
  call Hloop_A_Q(ntryL,G1H8(27),18,0,G2H8(16),n2h8(50))
  call Hloop_ZA_Q(ntryL,G0H16(45),ex2(:),G0H8(27),ngZu,m3h2x8(:,106),heltab2x16(:,:,366))
  call Hloop_A_Q(ntryL,G0H8(27),18,0,G1H8(27),n2h8(51))
  call Hloop_WA_Q(ntryL,G0H16(46),ex2(:),G0H8(28),m3h2x8(:,107),heltab2x16(:,:,367))
  call Hloop_A_Q(ntryL,G0H8(28),18,0,G1H8(28),n2h8(52))
  call Hloop_WA_Q(ntryL,G1H16(93),ex2(:),G1H8(29),m3h2x8(:,108),heltab2x16(:,:,368))
  call Hloop_A_Q(ntryL,G1H8(29),18,0,G2H8(17),n2h8(53))
  call Hloop_WA_Q(ntryL,G1H16(94),ex2(:),G1H8(29),m3h2x8(:,109),heltab2x16(:,:,369))
  call Hloop_A_Q(ntryL,G1H8(29),18,0,G2H8(18),n2h8(54))
  call Hloop_WA_Q(ntryL,G0H16(47),ex2(:),G0H8(6),m3h2x8(:,110),heltab2x16(:,:,370))
  call Hloop_A_Q(ntryL,G0H8(6),18,0,G1H8(29),n2h8(55))
  call Hloop_WA_Q(ntryL,G0H16(48),ex2(:),G0H8(1),m3h2x8(:,111),heltab2x16(:,:,371))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(30),n2h8(56))
  call Hloop_ZQ_A(ntryL,G0H16(53),ex1(:),G0H8(2),ngZu,m3h2x8(:,112),heltab2x16(:,:,372))
  call Hloop_Q_A(ntryL,G0H8(2),17,0,G1H8(31),n2h8(57))
  call Hloop_WQ_A(ntryL,G0H16(54),ex1(:),G0H8(3),m3h2x8(:,113),heltab2x16(:,:,373))
  call Hloop_Q_A(ntryL,G0H8(3),17,0,G1H8(32),n2h8(58))
  call Hloop_ZQ_A(ntryL,G0H16(51),ex1(:),G0H8(14),ngZu,m3h2x8(:,114),heltab2x16(:,:,374))
  call Hloop_Q_A(ntryL,G0H8(14),17,0,G1H8(33),n2h8(59))
  call Hloop_WQ_A(ntryL,G0H16(52),ex1(:),G0H8(10),m3h2x8(:,115),heltab2x16(:,:,375))
  call Hloop_Q_A(ntryL,G0H8(10),17,0,G1H8(34),n2h8(60))
  call Hloop_VA_Q(ntryL,G0H8(7),ex2(:),G0H4(13),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G0H4(13),22,0,G1H4(15),n2h4(44))
  call Hloop_ZA_Q(ntryL,G0H8(9),ex2(:),G0H4(13),ngZu,m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G0H4(13),22,0,G1H4(16),n2h4(45))
  call Hloop_VA_Q(ntryL,G0H8(8),ex2(:),G0H4(13),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G0H4(13),22,0,G1H4(1),n2h4(46))
  call Hloop_ZA_Q(ntryL,G0H8(4),ex2(:),G0H4(13),ngZu,m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_A_Q(ntryL,G0H4(13),22,0,G1H4(2),n2h4(47))
  call Hloop_WA_Q(ntryL,G0H8(5),ex2(:),G0H4(13),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_A_Q(ntryL,G0H4(13),22,0,G1H4(25),n2h4(48))
  call Hloop_VQ_A(ntryL,G0H8(15),ex1(:),G0H4(13),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G0H4(13),21,0,G1H4(26),n2h4(49))
  call Hloop_VQ_A(ntryL,G0H8(17),ex1(:),G0H4(13),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G0H4(13),21,0,G1H4(27),n2h4(50))
  call Hloop_ZQ_A(ntryL,G0H8(16),ex1(:),G0H4(13),ngZu,m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G0H4(13),21,0,G1H4(28),n2h4(51))
  call Hloop_ZQ_A(ntryL,G0H8(13),ex1(:),G0H4(13),ngZu,m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_Q_A(ntryL,G0H4(13),21,0,G1H4(4),n2h4(52))
  call Hloop_VA_Q(ntryL,G0H8(23),ex2(:),G0H4(13),m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G0H4(13),26,0,G1H4(40),n2h4(53))
  call Hloop_ZA_Q(ntryL,G0H8(25),ex2(:),G0H4(13),ngZu,m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_A_Q(ntryL,G0H4(13),26,0,G1H4(41),n2h4(54))
  call Hloop_VA_Q(ntryL,G0H8(24),ex2(:),G0H4(13),m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G0H4(13),26,0,G1H4(42),n2h4(55))
  call Hloop_ZA_Q(ntryL,G0H8(21),ex2(:),G0H4(13),ngZu,m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G0H4(13),26,0,G1H4(43),n2h4(56))
  call Hloop_VQ_A(ntryL,G0H8(32),ex1(:),G0H4(13),m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G0H4(13),25,0,G1H4(46),n2h4(57))
  call Hloop_VQ_A(ntryL,G0H8(34),ex1(:),G0H4(13),m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G0H4(13),25,0,G1H4(53),n2h4(58))
  call Hloop_ZQ_A(ntryL,G0H8(33),ex1(:),G0H4(13),ngZu,m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G0H4(13),25,0,G1H4(6),n2h4(59))
  call Hloop_ZQ_A(ntryL,G0H8(29),ex1(:),G0H4(13),ngZu,m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G0H4(13),25,0,G1H4(7),n2h4(60))
  call Hloop_WQ_A(ntryL,G0H8(30),ex1(:),G0H4(13),m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G0H4(13),25,0,G1H4(55),n2h4(61))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(39),[G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(45),[G1H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(54),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(60),[G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(17),[G2H4(16),G1H4(36),G0H4(3),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(34),[G2H4(33),G1H4(51),G0H4(9),G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G2H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G2H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G2H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(33),[G1H4(31),G1H4(22),G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(32),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G2H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G2H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G2H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G2H4(13),G0H4(6),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(3),[G1H4(38),G1H4(37),G1H4(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(21),[G2H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(22),[G2H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(23),[G2H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(62),[G1H4(58),G1H4(52),G1H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(61),[G1H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(27),[G2H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(28),[G2H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(29),[G2H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(32),[G2H4(30),G0H4(12),G0H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(31),[G0H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(11),G1H4(10),G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(5),[G1H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(6),[G1H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(7),[G1H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(8),[G1H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(1),[G1H8(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(2),[G1H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(3),[G1H8(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(4),[G1H8(22)])
  call Hloop_VQ_A(ntryL,G1H4(13),ex3(:),G1H2(11),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(11),23,nMT,G2H2(1),n2h2(41))
  call Hloop_VQ_A(ntryL,G1H4(39),ex3(:),G1H2(12),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(12),23,nMT,G2H2(2),n2h2(42))
  call Hloop_ZQ_A(ntryL,G1H4(19),ex3(:),G1H2(16),ngZu,m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_Q_A(ntryL,G1H2(16),23,nMT,G2H2(3),n2h2(43))
  call Hloop_ZQ_A(ntryL,G1H4(45),ex3(:),G1H2(17),ngZu,m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(17),23,nMT,G2H2(4),n2h2(44))
  call Hloop_VA_Q(ntryL,G1H4(23),ex4(:),G1H2(18),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_A_Q(ntryL,G1H2(18),27,nMT,G2H2(5),n2h2(45))
  call Hloop_VA_Q(ntryL,G1H4(54),ex4(:),G1H2(22),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(22),27,nMT,G2H2(6),n2h2(46))
  call Hloop_ZA_Q(ntryL,G1H4(29),ex4(:),G1H2(23),ngZu,m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_A_Q(ntryL,G1H2(23),27,nMT,G2H2(7),n2h2(47))
  call Hloop_ZA_Q(ntryL,G1H4(60),ex4(:),G1H2(24),ngZu,m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_A_Q(ntryL,G1H2(24),27,nMT,G2H2(8),n2h2(48))
  call Hloop_WA_Q(ntryL,G1H4(35),ex4(:),G1H2(28),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(28),27,nMB,G2H2(9),n2h2(49))
  call Hotf_4pt_reduction(G2H4(17),RedSet_4(7),mass4set(:,1),  & 
G1H4(56),G1H4(57),G1H4(14),G1H4(20),G1H4(24),4)
  call HG1shiftOLR(G1H4(57),4,4)
  call Hloop_VQ_A(ntryL,G1H4(5),ex3(:),G1H2(29),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_Q_A(ntryL,G1H2(29),23,nMT,G2H2(10),n2h2(50))
  call Hloop_ZQ_A(ntryL,G1H4(44),ex3(:),G1H2(30),ngZu,m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_Q_A(ntryL,G1H2(30),23,nMT,G2H2(11),n2h2(51))
  call Hloop_WQ_A(ntryL,G1H4(50),ex3(:),G1H2(34),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(34),23,nMB,G2H2(12),n2h2(52))
  call Hotf_4pt_reduction(G2H4(34),RedSet_4(2),mass4set(:,1),  & 
G1H4(30),G1H4(36),G1H4(51),G1H4(31),G1H4(22),4)
  call HG1shiftOLR(G1H4(36),8,4)
  call Hloop_VA_Q(ntryL,G1H4(8),ex4(:),G1H2(35),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_A_Q(ntryL,G1H2(35),27,nMT,G2H2(13),n2h2(53))
  call Hloop_ZA_Q(ntryL,G1H4(59),ex4(:),G1H2(36),ngZu,m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(36),27,nMT,G2H2(14),n2h2(54))
  call Hloop_QA_S(ntryL,G2H4(4),ex4(:),G2H2(15),ngH,m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_QA_S(ntryL,G2H4(5),ex4(:),G2H2(16),ngX,m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_QA_S(ntryL,G2H4(6),ex4(:),G2H2(17),ngPtb,m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_SA_Q(ntryL,G1H4(33),ex4(:),G1H2(40),ngPtb,m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_A_Q(ntryL,G1H2(40),27,nMB,G2H2(18),n2h2(55))
  call Hloop_SA_Q(ntryL,G1H4(18),ex4(:),G1H2(41),ngX,m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_A_Q(ntryL,G1H2(41),27,nMT,G2H2(19),n2h2(56))
  call Hloop_SA_Q(ntryL,G1H4(32),ex4(:),G1H2(42),ngH,m3h2x2(:,79),heltab2x4(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(42),27,nMT,G2H2(20),n2h2(57))
  call Hloop_QA_V(ntryL,G2H4(10),ex4(:),G2H2(22),m3h2x2(:,80),heltab2x4(:,:,80))
  call Hloop_QA_Z(ntryL,G2H4(11),ex4(:),G2H2(23),ngZu,m3h2x2(:,81),heltab2x4(:,:,81))
  call Hloop_QA_W(ntryL,G2H4(12),ex4(:),G2H2(25),m3h2x2(:,82),heltab2x4(:,:,82))
  call Hloop_ZA_Q(ntryL,G0H4(2),ex4(:),G0H2(1),ngZu,m3h2x2(:,83),heltab2x4(:,:,83))
  call Hloop_A_Q(ntryL,G0H2(1),27,nMT,G1H2(46),n2h2(58))
  call Hotf_4pt_reduction(G2H4(15),RedSet_4(7),mass4set(:,1),  & 
G1H4(17),G1H4(21),G1H4(38),G1H4(37),G1H4(34),4)
  call HG1shiftOLR(G1H4(21),4,4)
  call Hotf_4pt_reduction(G2H4(14),RedSet_4(7),mass4set(:,2),  & 
G1H4(58),G1H4(52),G1H4(47),G1H4(49),G1H4(11),4)
  call HG1shiftOLR(G1H4(52),4,4)
  call Hloop_WA_Q(ntryL,G1H4(3),ex4(:),G1H2(47),m3h2x2(:,84),heltab2x4(:,:,84))
  call Hloop_A_Q(ntryL,G1H2(47),27,nMB,G2H2(26),n2h2(59))
  call Hloop_AQ_S(ntryL,G2H4(21),ex3(:),G2H2(28),ngH,m3h2x2(:,85),heltab2x4(:,:,85))
  call Hloop_AQ_S(ntryL,G2H4(22),ex3(:),G2H2(29),ngX,m3h2x2(:,86),heltab2x4(:,:,86))
  call Hloop_AQ_S(ntryL,G2H4(23),ex3(:),G2H2(31),ngPbt,m3h2x2(:,87),heltab2x4(:,:,87))
  call Hloop_SQ_A(ntryL,G1H4(62),ex3(:),G1H2(48),ngPbt,m3h2x2(:,88),heltab2x4(:,:,88))
  call Hloop_Q_A(ntryL,G1H2(48),23,nMB,G2H2(32),n2h2(60))
  call Hloop_SQ_A(ntryL,G1H4(48),ex3(:),G1H2(52),ngX,m3h2x2(:,89),heltab2x4(:,:,89))
  call Hloop_Q_A(ntryL,G1H2(52),23,nMT,G2H2(34),n2h2(61))
  call Hloop_SQ_A(ntryL,G1H4(61),ex3(:),G1H2(53),ngH,m3h2x2(:,90),heltab2x4(:,:,90))
  call Hloop_Q_A(ntryL,G1H2(53),23,nMT,G2H2(35),n2h2(62))
  call Hloop_AQ_V(ntryL,G2H4(27),ex3(:),G2H2(37),m3h2x2(:,91),heltab2x4(:,:,91))
  call Hloop_AQ_Z(ntryL,G2H4(28),ex3(:),G2H2(38),ngZu,m3h2x2(:,92),heltab2x4(:,:,92))
  call Hloop_AQ_W(ntryL,G2H4(29),ex3(:),G2H2(40),m3h2x2(:,93),heltab2x4(:,:,93))
  call Hotf_4pt_reduction(G2H4(32),RedSet_4(2),mass4set(:,1),  & 
G1H4(10),G1H4(9),G1H4(13),G1H4(39),G1H4(19),4)
  call HG1shiftOLR(G1H4(9),8,4)
  call Hotf_4pt_reduction(G2H4(31),RedSet_4(2),mass4set(:,2),  & 
G1H4(45),G1H4(23),G1H4(54),G1H4(29),G1H4(60),4)
  call HG1shiftOLR(G1H4(23),8,4)
  call Hloop_ZQ_A(ntryL,G0H4(8),ex3(:),G0H2(1),ngZu,m3h2x2(:,94),heltab2x4(:,:,94))
  call Hloop_Q_A(ntryL,G0H2(1),23,nMT,G1H2(54),n2h2(63))
  call Hloop_WQ_A(ntryL,G1H4(12),ex3(:),G1H2(58),m3h2x2(:,95),heltab2x4(:,:,95))
  call Hloop_Q_A(ntryL,G1H2(58),23,nMB,G2H2(41),n2h2(64))
  call Hloop_SV_T(ntryL,G1H8(1),20,wf4(:,6),3,G2H2(43),m3h4x2(:,1),heltab2x8(:,:,48))
  call Hloop_TV_S(ntryL,G1H8(2),20,wf4(:,1),3,G2H2(44),m3h4x2(:,2),heltab2x8(:,:,49))
  call Hloop_SV_T(ntryL,G1H8(3),20,wf4(:,1),3,G2H2(46),m3h4x2(:,3),heltab2x8(:,:,50))
  call Hloop_SV_T(ntryL,G1H8(4),20,wf4(:,1),3,G2H2(47),m3h4x2(:,4),heltab2x8(:,:,51))
  call Hloop_QV_A(ntryL,G1H8(5),wf4(:,6),G1H2(59),m3h4x2(:,5),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(59),23,nMT,G2H2(49),n2h2(65))
  call Hotf_4pt_reduction(G2H8(5),RedSet_4(19),mass4set(:,3),  & 
G1H8(6),G1H8(7),G1H8(9),G1H8(10),G1H8(18),8)
  call HG1shiftOLR(G1H8(7),8,8)
  call Hotf_4pt_reduction(G2H8(6),RedSet_4(19),mass4set(:,4),  & 
G1H8(20),G1H8(21),G1H8(22),G1H8(1),G1H8(2),8)
  call HG1shiftOLR(G1H8(21),8,8)
  call Hloop_QZ_A(ntryL,G1H8(8),wf4(:,1),G1H2(60),ngZu,m3h4x2(:,6),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(60),23,nMT,G2H2(50),n2h2(66))
  call Hotf_4pt_reduction(G2H8(7),RedSet_4(19),mass4set(:,3),  & 
G1H8(3),G1H8(4),G1H8(5),G1H8(8),G1H8(35),8)
  call HG1shiftOLR(G1H8(4),8,8)
  call Hotf_4pt_reduction(G2H8(8),RedSet_4(19),mass4set(:,4),  & 
G1H8(36),G1H8(37),G1H8(38),G1H8(39),G1H8(40),8)
  call HG1shiftOLR(G1H8(37),8,8)
  call Hloop_SV_V(ntryL,G1H8(11),wf4(:,6),G1H2(64),m3h4x2(:,7),heltab2x8(:,:,54))
  call Hloop_SV_V(ntryL,G1H8(12),wf4(:,1),G1H2(11),m3h4x2(:,8),heltab2x8(:,:,55))
  call Hloop_SV_V(ntryL,G1H8(13),wf4(:,1),G1H2(12),m3h4x2(:,9),heltab2x8(:,:,56))
  call Hloop_VV_S(ntryL,G1H8(14),wf4(:,6),G1H2(16),m3h4x2(:,10),heltab2x8(:,:,57))
  call Hloop_VV_S(ntryL,G1H8(15),wf4(:,1),G1H2(17),m3h4x2(:,11),heltab2x8(:,:,58))
  call Hloop_VV_S(ntryL,G1H8(16),wf4(:,1),G1H2(18),m3h4x2(:,12),heltab2x8(:,:,59))
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(19),mass4set(:,3),  & 
G1H8(11),G1H8(12),G1H8(13),G1H8(14),G1H8(15),8)
  call HG1shiftOLR(G1H8(12),8,8)
  call Hotf_4pt_reduction(G2H8(2),RedSet_4(19),mass4set(:,4),  & 
G1H8(16),G1H8(41),G1H8(42),G1H8(43),G1H8(44),8)
  call HG1shiftOLR(G1H8(41),8,8)
  call Hotf_4pt_reduction(G2H8(3),RedSet_4(19),mass4set(:,3),  & 
G1H8(45),G1H8(46),G1H8(47),G1H8(48),G1H8(49),8)
  call HG1shiftOLR(G1H8(46),8,8)
  call Hotf_4pt_reduction(G2H8(4),RedSet_4(19),mass4set(:,4),  & 
G1H8(50),G1H8(51),G1H8(52),G1H8(53),G1H8(54),8)
  call HG1shiftOLR(G1H8(51),8,8)
  call Hloop_UW_V(ntryL,G1H8(19),20,wf4(:,6),3,G2H2(51),m3h4x2(:,13),heltab2x8(:,:,60))
  call Hloop_UW_V(ntryL,G1H8(17),20,wf4(:,1),3,G2H2(52),m3h4x2(:,14),heltab2x8(:,:,61))
  call Hloop_QA_Z(ntryL,G2H8(9),ex2(:),G2H4(16),ngZu,m3h2x4(:,48),heltab2x8(:,:,62))
  call Hloop_QA_W(ntryL,G2H8(10),ex2(:),G2H4(33),m3h2x4(:,49),heltab2x8(:,:,63))
  call Hloop_QA_W(ntryL,G2H8(11),ex2(:),G2H4(1),m3h2x4(:,50),heltab2x8(:,:,64))
  call Hloop_QA_Z(ntryL,G1H8(23),ex2(:),G1H4(35),ngZu,m3h2x4(:,51),heltab2x8(:,:,65))
  call Hloop_QA_W(ntryL,G1H8(24),ex2(:),G1H4(5),m3h2x4(:,52),heltab2x8(:,:,66))
  call Hloop_QA_W(ntryL,G2H8(12),ex2(:),G2H4(2),m3h2x4(:,53),heltab2x8(:,:,67))
  call Hloop_QA_W(ntryL,G2H8(13),ex2(:),G2H4(3),m3h2x4(:,54),heltab2x8(:,:,68))
  call Hloop_QA_W(ntryL,G1H8(25),ex2(:),G1H4(44),m3h2x4(:,55),heltab2x8(:,:,69))
  call Hloop_QA_W(ntryL,G1H8(26),ex2(:),G1H4(50),m3h2x4(:,56),heltab2x8(:,:,70))
  call Hloop_AQ_Z(ntryL,G2H8(14),ex1(:),G2H4(7),ngZu,m3h2x4(:,57),heltab2x8(:,:,71))
  call Hloop_AQ_W(ntryL,G2H8(15),ex1(:),G2H4(8),m3h2x4(:,58),heltab2x8(:,:,72))
  call Hloop_AQ_W(ntryL,G2H8(16),ex1(:),G2H4(9),m3h2x4(:,59),heltab2x8(:,:,73))
  call Hloop_AQ_Z(ntryL,G1H8(27),ex1(:),G1H4(8),ngZu,m3h2x4(:,60),heltab2x8(:,:,74))
  call Hloop_AQ_W(ntryL,G1H8(28),ex1(:),G1H4(59),m3h2x4(:,61),heltab2x8(:,:,75))
  call Hloop_AQ_W(ntryL,G2H8(17),ex1(:),G2H4(13),m3h2x4(:,62),heltab2x8(:,:,76))
  call Hloop_AQ_W(ntryL,G2H8(18),ex1(:),G2H4(18),m3h2x4(:,63),heltab2x8(:,:,77))
  call Hloop_AQ_W(ntryL,G1H8(29),ex1(:),G1H4(33),m3h2x4(:,64),heltab2x8(:,:,78))
  call Hloop_AQ_W(ntryL,G1H8(30),ex1(:),G1H4(18),m3h2x4(:,65),heltab2x8(:,:,79))
  call Hloop_QV_A(ntryL,G1H8(31),wf4(:,9),G1H2(22),m3h4x2(:,15),heltab2x8(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(22),29,0,G2H2(53),n2h2(67))
  call Hloop_QV_A(ntryL,G1H8(32),wf4(:,9),G1H2(23),m3h4x2(:,16),heltab2x8(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(23),29,0,G2H2(54),n2h2(68))
  call Hloop_QZ_A(ntryL,G1H8(33),wf4(:,4),G1H2(24),ngZu,m3h4x2(:,17),heltab2x8(:,:,82))
  call Hloop_Q_A(ntryL,G1H2(24),29,0,G2H2(55),n2h2(69))
  call Hloop_QZ_A(ntryL,G1H8(34),wf4(:,4),G1H2(28),ngZd,m3h4x2(:,18),heltab2x8(:,:,83))
  call Hloop_Q_A(ntryL,G1H2(28),29,0,G2H2(56),n2h2(70))
  call Hloop_AQ_V(ntryL,G1H4(15),ex1(:),G1H2(29),m3h2x2(:,96),heltab2x4(:,:,96))
  call Hloop_AQ_V(ntryL,G1H4(16),ex1(:),G1H2(30),m3h2x2(:,97),heltab2x4(:,:,97))
  call Hloop_AQ_Z(ntryL,G1H4(1),ex1(:),G1H2(34),ngZu,m3h2x2(:,98),heltab2x4(:,:,98))
  call Hloop_AQ_Z(ntryL,G1H4(2),ex1(:),G1H2(35),ngZu,m3h2x2(:,99),heltab2x4(:,:,99))
  call Hloop_AQ_W(ntryL,G1H4(25),ex1(:),G1H2(36),m3h2x2(:,100),heltab2x4(:,:,100))
  call Hloop_QA_V(ntryL,G1H4(26),ex2(:),G1H2(40),m3h2x2(:,101),heltab2x4(:,:,101))
  call Hloop_QA_Z(ntryL,G1H4(27),ex2(:),G1H2(41),ngZu,m3h2x2(:,102),heltab2x4(:,:,102))
  call Hloop_QA_V(ntryL,G1H4(28),ex2(:),G1H2(42),m3h2x2(:,103),heltab2x4(:,:,103))
  call Hloop_QA_Z(ntryL,G1H4(4),ex2(:),G1H2(47),ngZu,m3h2x2(:,104),heltab2x4(:,:,104))
  call Hloop_AQ_V(ntryL,G1H4(40),ex1(:),G1H2(48),m3h2x2(:,105),heltab2x4(:,:,105))
  call Hloop_AQ_V(ntryL,G1H4(41),ex1(:),G1H2(52),m3h2x2(:,106),heltab2x4(:,:,106))
  call Hloop_AQ_Z(ntryL,G1H4(42),ex1(:),G1H2(53),ngZu,m3h2x2(:,107),heltab2x4(:,:,107))
  call Hloop_AQ_Z(ntryL,G1H4(43),ex1(:),G1H2(58),ngZu,m3h2x2(:,108),heltab2x4(:,:,108))
  call Hloop_QA_V(ntryL,G1H4(46),ex2(:),G1H2(59),m3h2x2(:,109),heltab2x4(:,:,109))
  call Hloop_QA_Z(ntryL,G1H4(53),ex2(:),G1H2(60),ngZu,m3h2x2(:,110),heltab2x4(:,:,110))
  call Hloop_QA_V(ntryL,G1H4(6),ex2(:),G1H2(22),m3h2x2(:,111),heltab2x4(:,:,111))
  call Hloop_QA_Z(ntryL,G1H4(7),ex2(:),G1H2(23),ngZu,m3h2x2(:,112),heltab2x4(:,:,112))
  call Hloop_QA_W(ntryL,G1H4(55),ex2(:),G1H2(24),m3h2x2(:,113),heltab2x4(:,:,113))
  call Hloop_WA_Q(ntryL,G1H4(56),ex4(:),G1H2(28),m3h2x2(:,114),heltab2x4(:,:,114))
  call Hloop_A_Q(ntryL,G1H2(28),27,nMB,G2H2(57),n2h2(71))
call HGT_OLR(G1H4(57),1,1,4)
call HGT_invQ_OLR(G1H4(57),2,5,4)
  call Hloop_SQ_A(ntryL,G1H4(57),ex3(:),G1H2(28),ngPbt,m3h2x2(:,115),heltab2x4(:,:,115))
  call Hloop_WA_Q(ntryL,G1H4(20),ex4(:),G1H2(65),m3h2x2(:,116),heltab2x4(:,:,116))
  call Hloop_A_Q(ntryL,G1H2(65),27,nMB,G2H2(58),n2h2(72))
  call Hloop_WA_Q(ntryL,G1H4(24),ex4(:),G1H2(65),m3h2x2(:,117),heltab2x4(:,:,117))
  call Hloop_A_Q(ntryL,G1H2(65),27,nMB,G2H2(59),n2h2(73))
  call Hloop_WQ_A(ntryL,G1H4(30),ex3(:),G1H2(65),m3h2x2(:,118),heltab2x4(:,:,118))
  call Hloop_Q_A(ntryL,G1H2(65),23,nMB,G2H2(60),n2h2(74))
call HGT_OLR(G1H4(36),1,1,4)
call HGT_invQ_OLR(G1H4(36),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(36),ex4(:),G1H2(65),ngPtb,m3h2x2(:,119),heltab2x4(:,:,119))
  call Hloop_WQ_A(ntryL,G1H4(31),ex3(:),G1H2(66),m3h2x2(:,120),heltab2x4(:,:,120))
  call Hloop_Q_A(ntryL,G1H2(66),23,nMB,G2H2(61),n2h2(75))
  call Hloop_WQ_A(ntryL,G1H4(22),ex3(:),G1H2(66),m3h2x2(:,121),heltab2x4(:,:,121))
  call Hloop_Q_A(ntryL,G1H2(66),23,nMB,G2H2(62),n2h2(76))
  call Hloop_SA_Q(ntryL,G1H4(17),ex4(:),G1H2(66),ngPtb,m3h2x2(:,122),heltab2x4(:,:,122))
  call Hloop_A_Q(ntryL,G1H2(66),27,nMB,G2H2(63),n2h2(77))
call HGT_raise_alpha_OLR(G1H4(21),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(21),2,5,4)
  call Hloop_WQ_A(ntryL,G1H4(21),ex3(:),G1H2(66),m3h2x2(:,123),heltab2x4(:,:,123))
  call Hloop_SA_Q(ntryL,G1H4(37),ex4(:),G1H2(67),ngPtb,m3h2x2(:,124),heltab2x4(:,:,124))
  call Hloop_A_Q(ntryL,G1H2(67),27,nMB,G2H2(64),n2h2(78))
  call Hloop_SA_Q(ntryL,G1H4(34),ex4(:),G1H2(67),ngPtb,m3h2x2(:,125),heltab2x4(:,:,125))
  call Hloop_A_Q(ntryL,G1H2(67),27,nMB,G2H2(65),n2h2(79))
  call Hloop_SA_Q(ntryL,G1H4(58),ex4(:),G1H2(67),ngH,m3h2x2(:,126),heltab2x4(:,:,126))
  call Hloop_A_Q(ntryL,G1H2(67),27,nMT,G2H2(66),n2h2(80))
call HGT_raise_alpha_OLR(G1H4(52),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(52),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(52),ex3(:),G1H2(67),ngZu,m3h2x2(:,127),heltab2x4(:,:,127))
  call Hloop_SA_Q(ntryL,G1H4(49),ex4(:),G1H2(68),ngH,m3h2x2(:,128),heltab2x4(:,:,128))
  call Hloop_A_Q(ntryL,G1H2(68),27,nMT,G2H2(67),n2h2(81))
  call Hloop_SA_Q(ntryL,G1H4(11),ex4(:),G1H2(68),ngH,m3h2x2(:,129),heltab2x4(:,:,129))
  call Hloop_A_Q(ntryL,G1H2(68),27,nMT,G2H2(68),n2h2(82))
  call Hloop_SQ_A(ntryL,G1H4(10),ex3(:),G1H2(68),ngPbt,m3h2x2(:,130),heltab2x4(:,:,130))
  call Hloop_Q_A(ntryL,G1H2(68),23,nMB,G2H2(69),n2h2(83))
call HGT_raise_alpha_OLR(G1H4(9),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(9),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(9),ex4(:),G1H2(68),m3h2x2(:,131),heltab2x4(:,:,131))
  call Hloop_SQ_A(ntryL,G1H4(39),ex3(:),G1H2(69),ngPbt,m3h2x2(:,132),heltab2x4(:,:,132))
  call Hloop_Q_A(ntryL,G1H2(69),23,nMB,G2H2(70),n2h2(84))
  call Hloop_SQ_A(ntryL,G1H4(19),ex3(:),G1H2(69),ngPbt,m3h2x2(:,133),heltab2x4(:,:,133))
  call Hloop_Q_A(ntryL,G1H2(69),23,nMB,G2H2(71),n2h2(85))
  call Hloop_SQ_A(ntryL,G1H4(45),ex3(:),G1H2(69),ngH,m3h2x2(:,134),heltab2x4(:,:,134))
  call Hloop_Q_A(ntryL,G1H2(69),23,nMT,G2H2(72),n2h2(86))
call HGT_raise_alpha_OLR(G1H4(23),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(23),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(23),ex4(:),G1H2(69),ngZu,m3h2x2(:,135),heltab2x4(:,:,135))
  call Hloop_SQ_A(ntryL,G1H4(29),ex3(:),G1H2(70),ngH,m3h2x2(:,136),heltab2x4(:,:,136))
  call Hloop_Q_A(ntryL,G1H2(70),23,nMT,G2H2(73),n2h2(87))
  call Hloop_SQ_A(ntryL,G1H4(60),ex3(:),G1H2(70),ngH,m3h2x2(:,137),heltab2x4(:,:,137))
  call Hloop_Q_A(ntryL,G1H2(70),23,nMT,G2H2(74),n2h2(88))
  call Hloop_QV_A(ntryL,G1H8(6),wf4(:,6),G1H2(70),m3h4x2(:,19),heltab2x8(:,:,84))
  call Hloop_Q_A(ntryL,G1H2(70),23,nMT,G2H2(75),n2h2(89))
call HGT_OLR(G1H8(7),1,1,8)
call HGT_invQ_OLR(G1H8(7),2,5,8)
  call Hloop_SA_Q(ntryL,G1H8(7),ex4(:),G1H4(32),ngX,m3h2x4(:,66),heltab2x8(:,:,85))
  call Hloop_QV_A(ntryL,G1H8(10),wf4(:,6),G1H2(70),m3h4x2(:,20),heltab2x8(:,:,86))
  call Hloop_Q_A(ntryL,G1H2(70),23,nMT,G2H2(76),n2h2(90))
  call Hloop_QV_A(ntryL,G1H8(18),wf4(:,6),G1H2(70),m3h4x2(:,21),heltab2x8(:,:,87))
  call Hloop_Q_A(ntryL,G1H2(70),23,nMT,G2H2(77),n2h2(91))
  call Hloop_QV_A(ntryL,G1H8(20),wf4(:,6),G1H2(70),m3h4x2(:,22),heltab2x8(:,:,88))
  call Hloop_Q_A(ntryL,G1H2(70),23,nMB,G2H2(78),n2h2(92))
call HGT_OLR(G1H8(21),1,1,8)
call HGT_invQ_OLR(G1H8(21),2,5,8)
  call Hloop_SA_Q(ntryL,G1H8(21),ex4(:),G1H4(3),ngPtb,m3h2x4(:,67),heltab2x8(:,:,89))
  call Hloop_QV_A(ntryL,G1H8(1),wf4(:,6),G1H2(70),m3h4x2(:,23),heltab2x8(:,:,90))
  call Hloop_Q_A(ntryL,G1H2(70),23,nMB,G2H2(79),n2h2(93))
  call Hloop_QV_A(ntryL,G1H8(2),wf4(:,6),G1H2(70),m3h4x2(:,24),heltab2x8(:,:,91))
  call Hloop_Q_A(ntryL,G1H2(70),23,nMB,G2H2(80),n2h2(94))
  call Hloop_QZ_A(ntryL,G1H8(3),wf4(:,1),G1H2(70),ngZu,m3h4x2(:,25),heltab2x8(:,:,92))
  call Hloop_Q_A(ntryL,G1H2(70),23,nMT,G2H2(81),n2h2(95))
call HGT_OLR(G1H8(4),1,1,8)
call HGT_invQ_OLR(G1H8(4),2,5,8)
  call Hloop_SA_Q(ntryL,G1H8(4),ex4(:),G1H4(62),ngX,m3h2x4(:,68),heltab2x8(:,:,93))
  call Hloop_QZ_A(ntryL,G1H8(8),wf4(:,1),G1H2(70),ngZu,m3h4x2(:,26),heltab2x8(:,:,94))
  call Hloop_Q_A(ntryL,G1H2(70),23,nMT,G2H2(82),n2h2(96))
  call Hloop_QZ_A(ntryL,G1H8(35),wf4(:,1),G1H2(70),ngZu,m3h4x2(:,27),heltab2x8(:,:,95))
  call Hloop_Q_A(ntryL,G1H2(70),23,nMT,G2H2(83),n2h2(97))
  call Hloop_QZ_A(ntryL,G1H8(36),wf4(:,1),G1H2(70),ngZd,m3h4x2(:,28),heltab2x8(:,:,96))
  call Hloop_Q_A(ntryL,G1H2(70),23,nMB,G2H2(84),n2h2(98))
call HGT_OLR(G1H8(37),1,1,8)
call HGT_invQ_OLR(G1H8(37),2,5,8)
  call Hloop_SA_Q(ntryL,G1H8(37),ex4(:),G1H4(48),ngPtb,m3h2x4(:,69),heltab2x8(:,:,97))
  call Hloop_QZ_A(ntryL,G1H8(39),wf4(:,1),G1H2(70),ngZd,m3h4x2(:,29),heltab2x8(:,:,98))
  call Hloop_Q_A(ntryL,G1H2(70),23,nMB,G2H2(85),n2h2(99))
  call Hloop_QZ_A(ntryL,G1H8(40),wf4(:,1),G1H2(70),ngZd,m3h4x2(:,30),heltab2x8(:,:,99))
  call Hloop_Q_A(ntryL,G1H2(70),23,nMB,G2H2(86),n2h2(100))
  call Hloop_QV_A(ntryL,G1H8(11),wf4(:,6),G1H2(70),m3h4x2(:,31),heltab2x8(:,:,100))
  call Hloop_Q_A(ntryL,G1H2(70),23,nMT,G2H2(87),n2h2(101))
call HGT_raise_alpha_OLR(G1H8(12),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(12),2,5,8)
  call Hloop_ZA_Q(ntryL,G1H8(12),ex4(:),G1H4(61),ngZu,m3h2x4(:,70),heltab2x8(:,:,101))
  call Hloop_QV_A(ntryL,G1H8(14),wf4(:,6),G1H2(70),m3h4x2(:,32),heltab2x8(:,:,102))
  call Hloop_Q_A(ntryL,G1H2(70),23,nMT,G2H2(88),n2h2(102))
  call Hloop_QV_A(ntryL,G1H8(15),wf4(:,6),G1H2(70),m3h4x2(:,33),heltab2x8(:,:,103))
  call Hloop_Q_A(ntryL,G1H2(70),23,nMT,G2H2(89),n2h2(103))
  call Hloop_QV_A(ntryL,G1H8(16),wf4(:,6),G1H2(70),m3h4x2(:,34),heltab2x8(:,:,104))
  call Hloop_Q_A(ntryL,G1H2(70),23,nMB,G2H2(90),n2h2(104))
call HGT_raise_alpha_OLR(G1H8(41),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(41),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(41),ex4(:),G1H4(12),m3h2x4(:,71),heltab2x8(:,:,105))
  call Hloop_QV_A(ntryL,G1H8(43),wf4(:,6),G1H2(70),m3h4x2(:,35),heltab2x8(:,:,106))
  call Hloop_Q_A(ntryL,G1H2(70),23,nMB,G2H2(91),n2h2(105))
  call Hloop_QV_A(ntryL,G1H8(44),wf4(:,6),G1H2(70),m3h4x2(:,36),heltab2x8(:,:,107))
  call Hloop_Q_A(ntryL,G1H2(70),23,nMB,G2H2(92),n2h2(106))
  call Hloop_QZ_A(ntryL,G1H8(45),wf4(:,1),G1H2(70),ngZu,m3h4x2(:,37),heltab2x8(:,:,108))
  call Hloop_Q_A(ntryL,G1H2(70),23,nMT,G2H2(93),n2h2(107))
call HGT_raise_alpha_OLR(G1H8(46),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(46),2,5,8)
  call Hloop_ZA_Q(ntryL,G1H8(46),ex4(:),G1H4(15),ngZu,m3h2x4(:,72),heltab2x8(:,:,109))
  call Hloop_QZ_A(ntryL,G1H8(48),wf4(:,1),G1H2(70),ngZu,m3h4x2(:,38),heltab2x8(:,:,110))
  call Hloop_Q_A(ntryL,G1H2(70),23,nMT,G2H2(94),n2h2(108))
  call Hloop_QZ_A(ntryL,G1H8(49),wf4(:,1),G1H2(70),ngZu,m3h4x2(:,39),heltab2x8(:,:,111))
  call Hloop_Q_A(ntryL,G1H2(70),23,nMT,G2H2(95),n2h2(109))
  call Hloop_QZ_A(ntryL,G1H8(50),wf4(:,1),G1H2(70),ngZd,m3h4x2(:,40),heltab2x8(:,:,112))
  call Hloop_Q_A(ntryL,G1H2(70),23,nMB,G2H2(96),n2h2(110))
call HGT_raise_alpha_OLR(G1H8(51),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(51),2,5,8)
  call Hloop_WA_Q(ntryL,G1H8(51),ex4(:),G1H4(16),m3h2x4(:,73),heltab2x8(:,:,113))
  call Hloop_QZ_A(ntryL,G1H8(53),wf4(:,1),G1H2(70),ngZd,m3h4x2(:,41),heltab2x8(:,:,114))
  call Hloop_Q_A(ntryL,G1H2(70),23,nMB,G2H2(97),n2h2(111))
  call Hloop_QZ_A(ntryL,G1H8(54),wf4(:,1),G1H2(70),ngZd,m3h4x2(:,42),heltab2x8(:,:,115))
  call Hloop_Q_A(ntryL,G1H2(70),23,nMB,G2H2(98),n2h2(112))
call HGT_OLR(G1H2(1),1,1,2)
call HGT_invQ_OLR(G1H2(1),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1),[G1H2(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G2H2(21)])
call HGT_OLR(G1H2(2),1,1,2)
call HGT_invQ_OLR(G1H2(2),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(2),[G1H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(30),[G1H2(43)])
call HGT_OLR(G1H2(3),1,1,2)
call HGT_invQ_OLR(G1H2(3),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(3),[G1H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(30),[G2H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(35),[G1H2(55)])
call HGT_OLR(G1H2(4),1,1,2)
call HGT_invQ_OLR(G1H2(4),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(4),[G1H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(36),[G1H2(61)])
call HGT_OLR(G1H2(5),1,1,2)
call HGT_invQ_OLR(G1H2(5),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(5),[G1H2(36)])
call HGT_OLR(G1H2(6),1,1,2)
call HGT_invQ_OLR(G1H2(6),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(6),[G1H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(39),[G2H2(36)])
call HGT_OLR(G1H2(7),1,1,2)
call HGT_invQ_OLR(G1H2(7),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(7),[G1H2(23)])
call HGT_OLR(G1H2(8),1,1,2)
call HGT_invQ_OLR(G1H2(8),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(8),[G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(42),[G1H2(25)])
call HGT_OLR(G1H2(9),1,1,2)
call HGT_invQ_OLR(G1H2(9),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(9),[G1H2(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G2H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(47),[G1H2(31)])
call HGT_OLR(G1H2(10),1,1,2)
call HGT_invQ_OLR(G1H2(10),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(10),[G1H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(40),[G1H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(26),[G1H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(39),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(41),[G1H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(32),[G1H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(51),[G1H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(45),[G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(57),[G1H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(29),[G1H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(44),[G1H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(34),[G1H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(56),[G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(52),[G2H2(51),G1H2(12),G1H2(64),G1H2(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(57),[G2H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G1H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(63),[G2H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(60),[G2H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(34),[G1H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(69),[G2H2(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(47),[G2H2(43),G1H2(18),G1H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(46),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(50),[G2H2(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(55),[G2H2(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(56),[G2H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(81),[G2H2(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(83),[G2H2(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(84),[G2H2(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(86),[G2H2(80)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(93),[G2H2(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(95),[G2H2(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(96),[G2H2(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(98),[G2H2(92)])
  call Hloop_VQ_A(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(1),n2h1(28))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(24),ex4(:),G2tensor(2),ngX,m3h2x1(:,59),heltab2x2(:,:,59))
  call Hloop_ZQ_A(ntryL,G1H2(2),ex3(:),G1H1(1),ngZu,m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(3),n2h1(29))
  call Hloop_VA_Q(ntryL,G1H2(3),ex4(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(4),n2h1(30))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(30),ex3(:),G2tensor(5),ngX,m3h2x1(:,62),heltab2x2(:,:,62))
  call Hloop_ZA_Q(ntryL,G1H2(4),ex4(:),G1H1(1),ngZu,m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(6),n2h1(31))
  call Hloop_WA_Q(ntryL,G1H2(5),ex4(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(7),n2h1(32))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(33),ex3(:),G2tensor(8),ngPbt,m3h2x1(:,65),heltab2x2(:,:,65))
  call Hloop_VQ_A(ntryL,G1H2(6),ex3(:),G1H1(1),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(9),n2h1(33))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(39),ex4(:),G2tensor(10),ngX,m3h2x1(:,67),heltab2x2(:,:,67))
  call Hloop_ZQ_A(ntryL,G1H2(7),ex3(:),G1H1(1),ngZu,m3h2x1(:,68),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(11),n2h1(34))
  call Hloop_WQ_A(ntryL,G1H2(8),ex3(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(13),n2h1(35))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(42),ex4(:),G2tensor(15),ngPtb,m3h2x1(:,70),heltab2x2(:,:,70))
  call Hloop_VA_Q(ntryL,G1H2(9),ex4(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(17),n2h1(36))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(48),ex3(:),G2tensor(19),ngX,m3h2x1(:,72),heltab2x2(:,:,72))
  call Hloop_ZA_Q(ntryL,G1H2(10),ex4(:),G1H1(1),ngZu,m3h2x1(:,73),heltab2x2(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(21),n2h1(37))
  call Hloop_VA_Q(ntryL,G1H2(40),ex4(:),G1H1(1),m3h2x1(:,74),heltab2x2(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(23),n2h1(38))
  call Hloop_VA_Q(ntryL,G1H2(26),ex4(:),G1H1(1),m3h2x1(:,75),heltab2x2(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(25),n2h1(39))
  call Hloop_VA_Q(ntryL,G1H2(39),ex4(:),G1H1(1),m3h2x1(:,76),heltab2x2(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(27),n2h1(40))
  call Hloop_ZA_Q(ntryL,G1H2(41),ex4(:),G1H1(1),ngZu,m3h2x1(:,77),heltab2x2(:,:,77))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(29),n2h1(41))
  call Hloop_ZA_Q(ntryL,G1H2(32),ex4(:),G1H1(1),ngZu,m3h2x1(:,78),heltab2x2(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(31),n2h1(42))
  call Hloop_ZA_Q(ntryL,G1H2(51),ex4(:),G1H1(1),ngZu,m3h2x1(:,79),heltab2x2(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(34),n2h1(43))
  call Hloop_VA_Q(ntryL,G1H2(45),ex4(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(37),n2h1(44))
  call Hloop_ZA_Q(ntryL,G1H2(57),ex4(:),G1H1(1),ngZu,m3h2x1(:,81),heltab2x2(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(40),n2h1(45))
  call Hloop_VA_Q(ntryL,G1H2(29),ex4(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(43),n2h1(46))
  call Hloop_VA_Q(ntryL,G1H2(44),ex4(:),G1H1(1),m3h2x1(:,83),heltab2x2(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(46),n2h1(47))
  call Hloop_ZA_Q(ntryL,G1H2(34),ex4(:),G1H1(1),ngZu,m3h2x1(:,84),heltab2x2(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(49),n2h1(48))
  call Hloop_ZA_Q(ntryL,G1H2(56),ex4(:),G1H1(1),ngZu,m3h2x1(:,85),heltab2x2(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(52),n2h1(49))
  call Hloop_WA_Q(ntryL,G1H2(62),ex4(:),G1H1(1),m3h2x1(:,86),heltab2x2(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(55),n2h1(50))
  call Hotf_4pt_reduction(G2H2(52),RedSet_4(19),mass4set(:,5),  & 
G1H2(70),G1H2(52),G1H2(58),G1H2(43),G1H2(30),2)
  call HG1shiftOLR(G1H2(52),8,2)
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(58),ngX,m3h2x1(:,87),heltab2x2(:,:,87))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(2),ex4(:),G2tensor(59),ngX,m3h2x1(:,88),heltab2x2(:,:,88))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(3),ex4(:),G2tensor(60),ngX,m3h2x1(:,89),heltab2x2(:,:,89))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(4),ex4(:),G2tensor(61),ngX,m3h2x1(:,90),heltab2x2(:,:,90))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(5),ex3(:),G2tensor(62),ngX,m3h2x1(:,91),heltab2x2(:,:,91))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(6),ex3(:),G2tensor(63),ngX,m3h2x1(:,92),heltab2x2(:,:,92))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(7),ex3(:),G2tensor(64),ngX,m3h2x1(:,93),heltab2x2(:,:,93))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(8),ex3(:),G2tensor(65),ngX,m3h2x1(:,94),heltab2x2(:,:,94))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(9),ex3(:),G2tensor(66),ngPbt,m3h2x1(:,95),heltab2x2(:,:,95))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(10),ex4(:),G2tensor(67),ngX,m3h2x1(:,96),heltab2x2(:,:,96))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(11),ex4(:),G2tensor(68),ngX,m3h2x1(:,97),heltab2x2(:,:,97))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(12),ex4(:),G2tensor(69),ngPtb,m3h2x1(:,98),heltab2x2(:,:,98))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(13),ex3(:),G2tensor(70),ngX,m3h2x1(:,99),heltab2x2(:,:,99))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(14),ex3(:),G2tensor(71),ngX,m3h2x1(:,100),heltab2x2(:,:,100))
  call Hotf_4pt_reduction(G2H2(15),RedSet_4(7),mass4set(:,6),  & 
G1H2(55),G1H2(35),G1H2(61),G1H2(36),G1H2(22),2)
  call HG1shiftOLR(G1H2(35),4,2)
  call Hotf_4pt_reduction(G2H2(16),RedSet_4(7),mass4set(:,7),  & 
G1H2(23),G1H2(24),G1H2(25),G1H2(42),G1H2(31),2)
  call HG1shiftOLR(G1H2(24),4,2)
  call Hotf_4pt_reduction(G2H2(17),RedSet_4(7),mass4set(:,8),  & 
G1H2(47),G1H2(13),G1H2(14),G1H2(15),G1H2(19),2)
  call HG1shiftOLR(G1H2(13),4,2)
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(57),ex3(:),G2tensor(72),ngPbt,m3h2x1(:,101),heltab2x2(:,:,101))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(19),ex3(:),G2tensor(73),ngH,m3h2x1(:,102),heltab2x2(:,:,102))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(20),ex3(:),G2tensor(74),ngX,m3h2x1(:,103),heltab2x2(:,:,103))
  call Hotf_4pt_reduction(G2H2(22),RedSet_4(7),mass4set(:,9),  & 
G1H2(20),G1H2(21),G1H2(27),G1H2(33),G1H2(37),2)
  call HG1shiftOLR(G1H2(21),4,2)
  call Hotf_4pt_reduction(G2H2(23),RedSet_4(7),mass4set(:,7),  & 
G1H2(38),G1H2(49),G1H2(50),G1H2(12),G1H2(64),2)
  call HG1shiftOLR(G1H2(49),4,2)
  call Hotf_4pt_reduction(G2H2(25),RedSet_4(7),mass4set(:,8),  & 
G1H2(63),G1H2(46),G1H2(54),G1H2(18),G1H2(16),2)
  call HG1shiftOLR(G1H2(46),4,2)
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(63),ex3(:),G2tensor(75),m3h2x1(:,104),heltab2x2(:,:,104))
  call Hotf_4pt_reduction(G2H2(28),RedSet_4(2),mass4set(:,6),  & 
G1H2(17),G1H2(1),G1H2(2),G1H2(3),G1H2(4),2)
  call HG1shiftOLR(G1H2(1),8,2)
  call Hotf_4pt_reduction(G2H2(29),RedSet_4(2),mass4set(:,7),  & 
G1H2(5),G1H2(6),G1H2(7),G1H2(8),G1H2(9),2)
  call HG1shiftOLR(G1H2(6),8,2)
  call Hotf_4pt_reduction(G2H2(31),RedSet_4(2),mass4set(:,8),  & 
G1H2(10),G1H2(40),G1H2(26),G1H2(39),G1H2(41),2)
  call HG1shiftOLR(G1H2(40),8,2)
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(60),ex4(:),G2tensor(76),ngPtb,m3h2x1(:,105),heltab2x2(:,:,105))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(34),ex4(:),G2tensor(77),ngH,m3h2x1(:,106),heltab2x2(:,:,106))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(35),ex4(:),G2tensor(78),ngX,m3h2x1(:,107),heltab2x2(:,:,107))
  call Hotf_4pt_reduction(G2H2(37),RedSet_4(2),mass4set(:,9),  & 
G1H2(32),G1H2(51),G1H2(45),G1H2(57),G1H2(29),2)
  call HG1shiftOLR(G1H2(51),8,2)
  call Hotf_4pt_reduction(G2H2(38),RedSet_4(2),mass4set(:,7),  & 
G1H2(44),G1H2(34),G1H2(56),G1H2(62),G1H2(71),2)
  call HG1shiftOLR(G1H2(34),8,2)
  call Hotf_4pt_reduction(G2H2(40),RedSet_4(2),mass4set(:,8),  & 
G1H2(72),G1H2(73),G1H2(74),G1H2(75),G1H2(76),2)
  call HG1shiftOLR(G1H2(73),8,2)
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(69),ex4(:),G2tensor(79),m3h2x1(:,108),heltab2x2(:,:,108))
  call Hotf_4pt_reduction(G2H2(47),RedSet_4(19),mass4set(:,5),  & 
G1H2(77),G1H2(78),G1H2(79),G1H2(80),G1H2(81),2)
  call HG1shiftOLR(G1H2(78),8,2)
  call Hotf_4pt_reduction(G2H2(44),RedSet_4(19),mass4set(:,10),  & 
G1H2(82),G1H2(83),G1H2(84),G1H2(85),G1H2(86),2)
  call HG1shiftOLR(G1H2(83),8,2)
  call Hotf_4pt_reduction(G2H2(46),RedSet_4(19),mass4set(:,11),  & 
G1H2(87),G1H2(88),G1H2(89),G1H2(90),G1H2(91),2)
  call HG1shiftOLR(G1H2(88),8,2)
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(50),ex4(:),G2tensor(80),ngH,m3h2x1(:,109),heltab2x2(:,:,109))
  call Hloop_ZA_Q(ntryL,G1H2(11),ex4(:),G1H1(1),ngZu,m3h2x1(:,110),heltab2x2(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(81),n2h1(51))
  call Hotf_4pt_reduction(G2H4(16),RedSet_4(12),mass4set(:,12),  & 
G1H4(1),G1H4(2),G1H4(25),G1H4(26),G1H4(27),4)
  call HG1shiftOLR(G1H4(2),12,4)
  call Hotf_4pt_reduction(G2H4(33),RedSet_4(12),mass4set(:,13),  & 
G1H4(28),G1H4(4),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(4),12,4)
  call Hotf_4pt_reduction(G2H4(1),RedSet_4(12),mass4set(:,13),  & 
G1H4(43),G1H4(46),G1H4(53),G1H4(6),G1H4(7),4)
  call HG1shiftOLR(G1H4(46),12,4)
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(35),wf4(:,47),G1tensor(1),m3h4x1(:,1),heltab2x4(:,:,138))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(5),wf4(:,47),G1tensor(7),m3h4x1(:,2),heltab2x4(:,:,139))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(2),wf4(:,9),G2tensor(82),m3h4x1(:,3),heltab2x4(:,:,140))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(3),wf4(:,4),G2tensor(83),m3h4x1(:,4),heltab2x4(:,:,141))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(44),19,wf4(:,9),12,G2tensor(84),m3h4x1(:,5),heltab2x4(:,:,142))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(50),19,wf4(:,4),12,G2tensor(85),m3h4x1(:,6),heltab2x4(:,:,143))
  call Hotf_4pt_reduction(G2H4(7),RedSet_4(4),mass4set(:,12),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(20),G1H4(24),4)
  call HG1shiftOLR(G1H4(56),12,4)
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(4),mass4set(:,13),  & 
G1H4(30),G1H4(36),G1H4(31),G1H4(22),G1H4(17),4)
  call HG1shiftOLR(G1H4(36),12,4)
  call Hotf_4pt_reduction(G2H4(9),RedSet_4(4),mass4set(:,13),  & 
G1H4(21),G1H4(37),G1H4(34),G1H4(58),G1H4(52),4)
  call HG1shiftOLR(G1H4(37),12,4)
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(8),wf4(:,47),G1tensor(13),m3h4x1(:,7),heltab2x4(:,:,144))
  call Hcheck_last_VS_V(ntryL,l_switch,G1H4(59),wf4(:,47),G1tensor(19),m3h4x1(:,8),heltab2x4(:,:,145))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(13),wf4(:,9),G2tensor(86),m3h4x1(:,9),heltab2x4(:,:,146))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(18),wf4(:,4),G2tensor(87),m3h4x1(:,10),heltab2x4(:,:,147))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(33),19,wf4(:,9),12,G2tensor(88),m3h4x1(:,11),heltab2x4(:,:,148))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(18),19,wf4(:,4),12,G2tensor(89),m3h4x1(:,12),heltab2x4(:,:,149))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(55),ex2(:),G2tensor(90),ngZu,m3h2x1(:,111),heltab2x2(:,:,111))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(56),ex2(:),G2tensor(91),m3h2x1(:,112),heltab2x2(:,:,112))
  call Hloop_VQ_A(ntryL,G1H2(48),ex3(:),G1H1(1),m3h2x1(:,113),heltab2x2(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(92),n2h1(52))
  call Hloop_ZQ_A(ntryL,G1H2(53),ex3(:),G1H1(1),ngZu,m3h2x1(:,114),heltab2x2(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(93),n2h1(53))
  call Hloop_VQ_A(ntryL,G1H2(59),ex3(:),G1H1(1),m3h2x1(:,115),heltab2x2(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(94),n2h1(54))
  call Hloop_ZQ_A(ntryL,G1H2(60),ex3(:),G1H1(1),ngZu,m3h2x1(:,116),heltab2x2(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(95),n2h1(55))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H2(59),ex3(:),G2tensor(96),ngPbt,m3h2x1(:,117),heltab2x2(:,:,117))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(62),ex4(:),G2tensor(97),ngPtb,m3h2x1(:,118),heltab2x2(:,:,118))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(65),ex3(:),G2tensor(98),m3h2x1(:,119),heltab2x2(:,:,119))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(66),ex3(:),G2tensor(99),ngZu,m3h2x1(:,120),heltab2x2(:,:,120))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(68),ex3(:),G2tensor(100),ngZu,m3h2x1(:,121),heltab2x2(:,:,121))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(71),ex4(:),G2tensor(101),m3h2x1(:,122),heltab2x2(:,:,122))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(72),ex4(:),G2tensor(102),ngZu,m3h2x1(:,123),heltab2x2(:,:,123))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(74),ex4(:),G2tensor(103),ngZu,m3h2x1(:,124),heltab2x2(:,:,124))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(81),ex4(:),G2tensor(104),ngX,m3h2x1(:,125),heltab2x2(:,:,125))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(83),ex4(:),G2tensor(105),ngX,m3h2x1(:,126),heltab2x2(:,:,126))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(84),ex4(:),G2tensor(106),ngPtb,m3h2x1(:,127),heltab2x2(:,:,127))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(86),ex4(:),G2tensor(107),ngPtb,m3h2x1(:,128),heltab2x2(:,:,128))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(93),ex4(:),G2tensor(108),ngZu,m3h2x1(:,129),heltab2x2(:,:,129))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(95),ex4(:),G2tensor(109),ngZu,m3h2x1(:,130),heltab2x2(:,:,130))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(96),ex4(:),G2tensor(110),m3h2x1(:,131),heltab2x2(:,:,131))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(98),ex4(:),G2tensor(111),m3h2x1(:,132),heltab2x2(:,:,132))
  call Hloop_WA_Q(ntryL,G1H2(70),ex4(:),G1H1(1),m3h2x1(:,133),heltab2x2(:,:,133))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(112),n2h1(56))
  call Hloop_WA_Q(ntryL,G1H2(52),ex4(:),G1H1(1),m3h2x1(:,134),heltab2x2(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(113),n2h1(57))
  call Hloop_WA_Q(ntryL,G1H2(30),ex4(:),G1H1(1),m3h2x1(:,135),heltab2x2(:,:,135))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(114),n2h1(58))
  call Hloop_SQ_A(ntryL,G1H2(55),ex3(:),G1H1(1),ngH,m3h2x1(:,136),heltab2x2(:,:,136))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(115),n2h1(59))
  call Hloop_SQ_A(ntryL,G1H2(35),ex3(:),G1H1(1),ngH,m3h2x1(:,137),heltab2x2(:,:,137))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(116),n2h1(60))
  call Hloop_SQ_A(ntryL,G1H2(22),ex3(:),G1H1(1),ngH,m3h2x1(:,138),heltab2x2(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(117),n2h1(61))
  call Hloop_SQ_A(ntryL,G1H2(23),ex3(:),G1H1(1),ngX,m3h2x1(:,139),heltab2x2(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(118),n2h1(62))
  call Hloop_SQ_A(ntryL,G1H2(24),ex3(:),G1H1(1),ngX,m3h2x1(:,140),heltab2x2(:,:,140))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(119),n2h1(63))
  call Hloop_SQ_A(ntryL,G1H2(31),ex3(:),G1H1(1),ngX,m3h2x1(:,141),heltab2x2(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(120),n2h1(64))
  call Hloop_SQ_A(ntryL,G1H2(47),ex3(:),G1H1(1),ngPbt,m3h2x1(:,142),heltab2x2(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(121),n2h1(65))
  call Hloop_SQ_A(ntryL,G1H2(13),ex3(:),G1H1(1),ngPbt,m3h2x1(:,143),heltab2x2(:,:,143))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(122),n2h1(66))
  call Hloop_SQ_A(ntryL,G1H2(19),ex3(:),G1H1(1),ngPbt,m3h2x1(:,144),heltab2x2(:,:,144))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(123),n2h1(67))
  call Hloop_VQ_A(ntryL,G1H2(20),ex3(:),G1H1(1),m3h2x1(:,145),heltab2x2(:,:,145))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(124),n2h1(68))
  call Hloop_VQ_A(ntryL,G1H2(21),ex3(:),G1H1(1),m3h2x1(:,146),heltab2x2(:,:,146))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(125),n2h1(69))
  call Hloop_VQ_A(ntryL,G1H2(37),ex3(:),G1H1(1),m3h2x1(:,147),heltab2x2(:,:,147))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(126),n2h1(70))
  call Hloop_ZQ_A(ntryL,G1H2(38),ex3(:),G1H1(1),ngZu,m3h2x1(:,148),heltab2x2(:,:,148))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(127),n2h1(71))
  call Hloop_ZQ_A(ntryL,G1H2(49),ex3(:),G1H1(1),ngZu,m3h2x1(:,149),heltab2x2(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(128),n2h1(72))
  call Hloop_ZQ_A(ntryL,G1H2(64),ex3(:),G1H1(1),ngZu,m3h2x1(:,150),heltab2x2(:,:,150))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(129),n2h1(73))
  call Hloop_WQ_A(ntryL,G1H2(63),ex3(:),G1H1(1),m3h2x1(:,151),heltab2x2(:,:,151))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(130),n2h1(74))
  call Hloop_WQ_A(ntryL,G1H2(46),ex3(:),G1H1(1),m3h2x1(:,152),heltab2x2(:,:,152))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(131),n2h1(75))
  call Hloop_WQ_A(ntryL,G1H2(16),ex3(:),G1H1(1),m3h2x1(:,153),heltab2x2(:,:,153))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(132),n2h1(76))
  call Hloop_SA_Q(ntryL,G1H2(17),ex4(:),G1H1(1),ngH,m3h2x1(:,154),heltab2x2(:,:,154))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(133),n2h1(77))
  call Hloop_SA_Q(ntryL,G1H2(1),ex4(:),G1H1(1),ngH,m3h2x1(:,155),heltab2x2(:,:,155))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(134),n2h1(78))
  call Hloop_SA_Q(ntryL,G1H2(4),ex4(:),G1H1(1),ngH,m3h2x1(:,156),heltab2x2(:,:,156))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(135),n2h1(79))
  call Hloop_SA_Q(ntryL,G1H2(5),ex4(:),G1H1(1),ngX,m3h2x1(:,157),heltab2x2(:,:,157))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(136),n2h1(80))
  call Hloop_SA_Q(ntryL,G1H2(6),ex4(:),G1H1(1),ngX,m3h2x1(:,158),heltab2x2(:,:,158))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(137),n2h1(81))
  call Hloop_SA_Q(ntryL,G1H2(9),ex4(:),G1H1(1),ngX,m3h2x1(:,159),heltab2x2(:,:,159))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(138),n2h1(82))
  call Hloop_SA_Q(ntryL,G1H2(10),ex4(:),G1H1(1),ngPtb,m3h2x1(:,160),heltab2x2(:,:,160))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(139),n2h1(83))
  call Hloop_SA_Q(ntryL,G1H2(40),ex4(:),G1H1(1),ngPtb,m3h2x1(:,161),heltab2x2(:,:,161))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(140),n2h1(84))
  call Hloop_SA_Q(ntryL,G1H2(41),ex4(:),G1H1(1),ngPtb,m3h2x1(:,162),heltab2x2(:,:,162))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(141),n2h1(85))
  call Hloop_VA_Q(ntryL,G1H2(32),ex4(:),G1H1(1),m3h2x1(:,163),heltab2x2(:,:,163))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(142),n2h1(86))
  call Hloop_VA_Q(ntryL,G1H2(51),ex4(:),G1H1(1),m3h2x1(:,164),heltab2x2(:,:,164))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(143),n2h1(87))
  call Hloop_VA_Q(ntryL,G1H2(29),ex4(:),G1H1(1),m3h2x1(:,165),heltab2x2(:,:,165))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(144),n2h1(88))
  call Hloop_ZA_Q(ntryL,G1H2(44),ex4(:),G1H1(1),ngZu,m3h2x1(:,166),heltab2x2(:,:,166))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(145),n2h1(89))
  call Hloop_ZA_Q(ntryL,G1H2(34),ex4(:),G1H1(1),ngZu,m3h2x1(:,167),heltab2x2(:,:,167))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(146),n2h1(90))
  call Hloop_ZA_Q(ntryL,G1H2(71),ex4(:),G1H1(1),ngZu,m3h2x1(:,168),heltab2x2(:,:,168))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(147),n2h1(91))
  call Hloop_WA_Q(ntryL,G1H2(72),ex4(:),G1H1(1),m3h2x1(:,169),heltab2x2(:,:,169))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(148),n2h1(92))
  call Hloop_WA_Q(ntryL,G1H2(73),ex4(:),G1H1(1),m3h2x1(:,170),heltab2x2(:,:,170))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(149),n2h1(93))
  call Hloop_WA_Q(ntryL,G1H2(76),ex4(:),G1H1(1),m3h2x1(:,171),heltab2x2(:,:,171))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(150),n2h1(94))
  call Hloop_SA_Q(ntryL,G1H2(77),ex4(:),G1H1(1),ngPtb,m3h2x1(:,172),heltab2x2(:,:,172))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(151),n2h1(95))
  call Hloop_SA_Q(ntryL,G1H2(78),ex4(:),G1H1(1),ngPtb,m3h2x1(:,173),heltab2x2(:,:,173))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(152),n2h1(96))
  call Hloop_SA_Q(ntryL,G1H2(81),ex4(:),G1H1(1),ngPtb,m3h2x1(:,174),heltab2x2(:,:,174))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(153),n2h1(97))
  call Hloop_SA_Q(ntryL,G1H2(82),ex4(:),G1H1(1),ngX,m3h2x1(:,175),heltab2x2(:,:,175))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(154),n2h1(98))
  call Hloop_SA_Q(ntryL,G1H2(83),ex4(:),G1H1(1),ngX,m3h2x1(:,176),heltab2x2(:,:,176))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(155),n2h1(99))
  call Hloop_SA_Q(ntryL,G1H2(86),ex4(:),G1H1(1),ngX,m3h2x1(:,177),heltab2x2(:,:,177))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(156),n2h1(100))
  call Hloop_SA_Q(ntryL,G1H2(87),ex4(:),G1H1(1),ngH,m3h2x1(:,178),heltab2x2(:,:,178))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(157),n2h1(101))
  call Hloop_SA_Q(ntryL,G1H2(88),ex4(:),G1H1(1),ngH,m3h2x1(:,179),heltab2x2(:,:,179))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(158),n2h1(102))
  call Hloop_SA_Q(ntryL,G1H2(91),ex4(:),G1H1(1),ngH,m3h2x1(:,180),heltab2x2(:,:,180))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(159),n2h1(103))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(1),19,wf4(:,47),12,G2tensor(160),m3h4x1(:,13),heltab2x4(:,:,150))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(2),0,wf4(:,47),12,G2tensor(161),m3h4x1(:,14),heltab2x4(:,:,151))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(27),19,wf4(:,47),12,G2tensor(162),m3h4x1(:,15),heltab2x4(:,:,152))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(28),19,wf4(:,47),12,G2tensor(163),m3h4x1(:,16),heltab2x4(:,:,153))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(4),0,wf4(:,47),12,G2tensor(164),m3h4x1(:,17),heltab2x4(:,:,154))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(42),19,wf4(:,47),12,G2tensor(165),m3h4x1(:,18),heltab2x4(:,:,155))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(43),19,wf4(:,2),12,G2tensor(166),m3h4x1(:,19),heltab2x4(:,:,156))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(46),0,wf4(:,2),12,G2tensor(167),m3h4x1(:,20),heltab2x4(:,:,157))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(7),19,wf4(:,2),12,G2tensor(168),m3h4x1(:,21),heltab2x4(:,:,158))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(55),19,wf4(:,47),12,G2tensor(169),m3h4x1(:,22),heltab2x4(:,:,159))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(56),0,wf4(:,47),12,G2tensor(170),m3h4x1(:,23),heltab2x4(:,:,160))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(24),19,wf4(:,47),12,G2tensor(171),m3h4x1(:,24),heltab2x4(:,:,161))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(30),19,wf4(:,47),12,G2tensor(172),m3h4x1(:,25),heltab2x4(:,:,162))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(36),0,wf4(:,47),12,G2tensor(173),m3h4x1(:,26),heltab2x4(:,:,163))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(17),19,wf4(:,47),12,G2tensor(174),m3h4x1(:,27),heltab2x4(:,:,164))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(21),19,wf4(:,2),12,G2tensor(175),m3h4x1(:,28),heltab2x4(:,:,165))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(37),0,wf4(:,2),12,G2tensor(176),m3h4x1(:,29),heltab2x4(:,:,166))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H4(52),19,wf4(:,2),12,G2tensor(177),m3h4x1(:,30),heltab2x4(:,:,167))
  call ol_merge_tensors(G2tensor(16),[G2tensor(12),G1tensor(18),G1tensor(6)])
  call ol_merge_tensors(G2tensor(169),[G2tensor(18),G2tensor(14),G1tensor(13),G1tensor(24),G1tensor(12)])
  call ol_merge_tensors(G2tensor(175),[G2tensor(172),G2tensor(89),G2tensor(88),G2tensor(87),G2tensor(86),G2tensor(20),G1tensor(19) &
    ,G1tensor(30)])
  call ol_merge_tensors(G2tensor(28),[G2tensor(22),G1tensor(54),G1tensor(36)])
  call ol_merge_tensors(G2tensor(160),[G2tensor(30),G2tensor(24),G1tensor(1),G1tensor(60),G1tensor(42)])
  call ol_merge_tensors(G2tensor(166),[G2tensor(163),G2tensor(85),G2tensor(84),G2tensor(83),G2tensor(82),G2tensor(26),G1tensor(7) &
    ,G1tensor(48)])
  call ol_merge_tensors(G2tensor(32),[G1tensor(62)])
  call ol_merge_tensors(G2tensor(36),[G2tensor(33),G1tensor(72),G1tensor(66)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(68)])
  call ol_merge_tensors(G2tensor(38),[G1tensor(74)])
  call ol_merge_tensors(G2tensor(42),[G2tensor(39),G1tensor(84),G1tensor(78)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(80)])
  call ol_merge_tensors(G2tensor(44),[G1tensor(86)])
  call ol_merge_tensors(G2tensor(51),[G2tensor(45),G1tensor(102),G1tensor(90)])
  call ol_merge_tensors(G2tensor(47),[G1tensor(92)])
  call ol_merge_tensors(G2tensor(54),[G2tensor(48),G1tensor(108),G1tensor(96)])
  call ol_merge_tensors(G2tensor(50),[G1tensor(98)])
  call ol_merge_tensors(G2tensor(53),[G1tensor(104)])
  call ol_merge_tensors(G2tensor(56),[G1tensor(110)])
  call ol_merge_tensors(G2tensor(57),[G1tensor(114)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(59),[G1tensor(34),G1tensor(4)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(11),G1tensor(5)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(8)])
  call ol_merge_tensors(G2tensor(60),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(61),[G1tensor(40),G1tensor(10)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(93),G1tensor(14)])
  call ol_merge_tensors(G2tensor(62),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(63),[G1tensor(52),G1tensor(16)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(23),G1tensor(17)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(105),G1tensor(20)])
  call ol_merge_tensors(G2tensor(64),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(65),[G1tensor(58),G1tensor(22)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(111),G1tensor(26)])
  call ol_merge_tensors(G2tensor(66),[G1tensor(27)])
  call ol_merge_tensors(G2tensor(75),[G2tensor(72),G1tensor(28)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(29)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(32)])
  call ol_merge_tensors(G2tensor(67),[G1tensor(33)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(41),G1tensor(35)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(38)])
  call ol_merge_tensors(G2tensor(68),[G1tensor(39)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(44)])
  call ol_merge_tensors(G2tensor(69),[G1tensor(45)])
  call ol_merge_tensors(G2tensor(79),[G2tensor(76),G1tensor(46)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(47)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(75),G1tensor(50)])
  call ol_merge_tensors(G2tensor(70),[G1tensor(51)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(59),G1tensor(53)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(81),G1tensor(56)])
  call ol_merge_tensors(G2tensor(71),[G1tensor(57)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(63)])
  call ol_merge_tensors(G2tensor(25),[G1tensor(76),G1tensor(64)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(89),G1tensor(65)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(69)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(82),G1tensor(70)])
  call ol_merge_tensors(G2tensor(34),[G1tensor(101),G1tensor(71)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(95),G1tensor(77)])
  call ol_merge_tensors(G2tensor(40),[G1tensor(107),G1tensor(83)])
  call ol_merge_tensors(G2tensor(43),[G1tensor(87)])
  call ol_merge_tensors(G2tensor(46),[G1tensor(94),G1tensor(88)])
  call ol_merge_tensors(G2tensor(49),[G1tensor(99)])
  call ol_merge_tensors(G2tensor(52),[G1tensor(106),G1tensor(100)])
  call ol_merge_tensors(G2tensor(55),[G1tensor(112)])
  call ol_merge_tensors(G2tensor(151),[G2tensor(112),G1tensor(113)])
  call ol_merge_tensors(G2tensor(99),[G2tensor(74)])
  call ol_merge_tensors(G2tensor(102),[G2tensor(78)])
  call ol_merge_tensors(G2tensor(154),[G2tensor(81)])
  call ol_merge_tensors(G2tensor(108),[G2tensor(104)])
  call ol_merge_tensors(G2tensor(110),[G2tensor(106)])
  call ol_merge_tensors(G2tensor(127),[G2tensor(118)])
  call ol_merge_tensors(G2tensor(130),[G2tensor(121)])
  call ol_merge_tensors(G2tensor(145),[G2tensor(136)])
  call ol_merge_tensors(G2tensor(148),[G2tensor(139)])
  call Hotf_4pt_reduction_last(G2tensor(16),RedSet_4(4),mass4set(:,14),  & 
G1tensor(25),G1tensor(31),G1tensor(37),G1tensor(43),G1tensor(49))
  call G_TensorShift(G1tensor(31),12)
  call Hotf_4pt_reduction_last(G2tensor(169),RedSet_4(4),mass4set(:,12),  & 
G1tensor(55),G1tensor(61),G1tensor(67),G1tensor(73),G1tensor(79))
  call G_TensorShift(G1tensor(61),12)
  call Hotf_4pt_reduction_last(G2tensor(175),RedSet_4(4),mass4set(:,13),  & 
G1tensor(85),G1tensor(91),G1tensor(97),G1tensor(103),G1tensor(109))
  call G_TensorShift(G1tensor(91),12)
  call Hotf_4pt_reduction_last(G2tensor(28),RedSet_4(12),mass4set(:,14),  & 
G1tensor(18),G1tensor(6),G1tensor(13),G1tensor(24),G1tensor(12))
  call G_TensorShift(G1tensor(6),12)
  call Hotf_4pt_reduction_last(G2tensor(160),RedSet_4(12),mass4set(:,12),  & 
G1tensor(19),G1tensor(30),G1tensor(54),G1tensor(36),G1tensor(1))
  call G_TensorShift(G1tensor(30),12)
  call Hotf_4pt_reduction_last(G2tensor(166),RedSet_4(12),mass4set(:,13),  & 
G1tensor(60),G1tensor(42),G1tensor(7),G1tensor(48),G1tensor(62))
  call G_TensorShift(G1tensor(42),12)
  call Hotf_4pt_reduction_last(G2tensor(32),RedSet_4(26),mass4set(:,15),  & 
G1tensor(72),G1tensor(66),G1tensor(68),G1tensor(74),G1tensor(84))
  call G_TensorShift(G1tensor(66),2)
  call Hotf_4pt_reduction_last(G2tensor(36),RedSet_4(20),mass4set(:,16),  & 
G1tensor(78),G1tensor(80),G1tensor(86),G1tensor(102),G1tensor(90))
  call G_TensorShift(G1tensor(80),10)
  call Hotf_4pt_reduction_last(G2tensor(35),RedSet_4(26),mass4set(:,17),  & 
G1tensor(92),G1tensor(108),G1tensor(96),G1tensor(98),G1tensor(104))
  call G_TensorShift(G1tensor(108),2)
  call Hotf_4pt_reduction_last(G2tensor(38),RedSet_4(26),mass4set(:,18),  & 
G1tensor(110),G1tensor(114),G1tensor(2),G1tensor(3),G1tensor(34))
  call G_TensorShift(G1tensor(114),2)
  call Hotf_4pt_reduction_last(G2tensor(42),RedSet_4(20),mass4set(:,19),  & 
G1tensor(4),G1tensor(11),G1tensor(5),G1tensor(8),G1tensor(9))
  call G_TensorShift(G1tensor(11),10)
  call Hotf_4pt_reduction_last(G2tensor(41),RedSet_4(26),mass4set(:,20),  & 
G1tensor(40),G1tensor(10),G1tensor(93),G1tensor(14),G1tensor(15))
  call G_TensorShift(G1tensor(10),2)
  call Hotf_4pt_reduction_last(G2tensor(44),RedSet_4(27),mass4set(:,15),  & 
G1tensor(52),G1tensor(16),G1tensor(23),G1tensor(17),G1tensor(105))
  call G_TensorShift(G1tensor(16),1)
  call Hotf_4pt_reduction_last(G2tensor(51),RedSet_4(24),mass4set(:,16),  & 
G1tensor(20),G1tensor(21),G1tensor(58),G1tensor(22),G1tensor(111))
  call G_TensorShift(G1tensor(21),9)
  call Hotf_4pt_reduction_last(G2tensor(47),RedSet_4(27),mass4set(:,18),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(32))
  call G_TensorShift(G1tensor(27),1)
  call Hotf_4pt_reduction_last(G2tensor(54),RedSet_4(24),mass4set(:,19),  & 
G1tensor(33),G1tensor(41),G1tensor(35),G1tensor(38),G1tensor(39))
  call G_TensorShift(G1tensor(41),9)
  call Hotf_4pt_reduction_last(G2tensor(50),RedSet_4(27),mass4set(:,17),  & 
G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(75))
  call G_TensorShift(G1tensor(45),1)
  call Hotf_4pt_reduction_last(G2tensor(53),RedSet_4(27),mass4set(:,20),  & 
G1tensor(50),G1tensor(51),G1tensor(59),G1tensor(53),G1tensor(81))
  call G_TensorShift(G1tensor(51),1)
  call Hotf_4pt_reduction_last(G2tensor(56),RedSet_4(27),mass4set(:,21),  & 
G1tensor(56),G1tensor(57),G1tensor(63),G1tensor(76),G1tensor(64))
  call G_TensorShift(G1tensor(57),1)
  call Hotf_4pt_reduction_last(G2tensor(57),RedSet_4(24),mass4set(:,22),  & 
G1tensor(89),G1tensor(65),G1tensor(69),G1tensor(82),G1tensor(70))
  call G_TensorShift(G1tensor(65),9)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(28),mass4set(:,23),  & 
G1tensor(101),G1tensor(71),G1tensor(95),G1tensor(77),G1tensor(107))
  call G_TensorShift(G1tensor(71),4)
  call Hotf_4pt_reduction_last(G2tensor(58),RedSet_4(1),mass4set(:,24),  & 
G1tensor(83),G1tensor(87),G1tensor(94),G1tensor(88),G1tensor(99))
  call G_TensorShift(G1tensor(87),8)
  call Hotf_4pt_reduction_last(G2tensor(59),RedSet_4(2),mass4set(:,25),  & 
G1tensor(106),G1tensor(100),G1tensor(112),G1tensor(113),G1tensor(115))
  call G_TensorShift(G1tensor(100),8)
  call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(3),mass4set(:,25),  & 
G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(117),8)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(28),mass4set(:,26),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125))
  call G_TensorShift(G1tensor(122),4)
  call Hotf_4pt_reduction_last(G2tensor(60),RedSet_4(1),mass4set(:,27),  & 
G1tensor(126),G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130))
  call G_TensorShift(G1tensor(127),8)
  call Hotf_4pt_reduction_last(G2tensor(61),RedSet_4(2),mass4set(:,28),  & 
G1tensor(131),G1tensor(132),G1tensor(133),G1tensor(134),G1tensor(135))
  call G_TensorShift(G1tensor(132),8)
  call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(22),mass4set(:,23),  & 
G1tensor(136),G1tensor(137),G1tensor(138),G1tensor(139),G1tensor(140))
  call G_TensorShift(G1tensor(137),8)
  call Hotf_4pt_reduction_last(G2tensor(62),RedSet_4(6),mass4set(:,24),  & 
G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144),G1tensor(145))
  call G_TensorShift(G1tensor(142),4)
  call Hotf_4pt_reduction_last(G2tensor(63),RedSet_4(7),mass4set(:,25),  & 
G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(147),4)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(8),mass4set(:,25),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155))
  call G_TensorShift(G1tensor(152),4)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(22),mass4set(:,26),  & 
G1tensor(156),G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160))
  call G_TensorShift(G1tensor(157),8)
  call Hotf_4pt_reduction_last(G2tensor(64),RedSet_4(6),mass4set(:,27),  & 
G1tensor(161),G1tensor(162),G1tensor(163),G1tensor(164),G1tensor(165))
  call G_TensorShift(G1tensor(162),4)
  call Hotf_4pt_reduction_last(G2tensor(65),RedSet_4(7),mass4set(:,28),  & 
G1tensor(166),G1tensor(167),G1tensor(168),G1tensor(169),G1tensor(170))
  call G_TensorShift(G1tensor(167),4)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(22),mass4set(:,29),  & 
G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174),G1tensor(175))
  call G_TensorShift(G1tensor(172),8)
  call Hotf_4pt_reduction_last(G2tensor(66),RedSet_4(6),mass4set(:,30),  & 
G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(177),4)
  call Hotf_4pt_reduction_last(G2tensor(75),RedSet_4(7),mass4set(:,1),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185))
  call G_TensorShift(G1tensor(182),4)
  call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(8),mass4set(:,31),  & 
G1tensor(186),G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190))
  call G_TensorShift(G1tensor(187),4)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(29),mass4set(:,23),  & 
G1tensor(191),G1tensor(192),G1tensor(193),G1tensor(194),G1tensor(195))
  call G_TensorShift(G1tensor(192),4)
  call Hotf_4pt_reduction_last(G2tensor(67),RedSet_4(10),mass4set(:,24),  & 
G1tensor(196),G1tensor(197),G1tensor(198),G1tensor(199),G1tensor(200))
  call G_TensorShift(G1tensor(197),8)
  call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(11),mass4set(:,25),  & 
G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204),G1tensor(205))
  call G_TensorShift(G1tensor(202),8)
  call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(29),mass4set(:,26),  & 
G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(207),4)
  call Hotf_4pt_reduction_last(G2tensor(68),RedSet_4(10),mass4set(:,27),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215))
  call G_TensorShift(G1tensor(212),8)



end subroutine vamp_1

end module ol_vamp_1_pphtt_ew_uuxttxh_3_/**/REALKIND
