
module ol_vamp_1_pphtt_ew_ttxhaa_2_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphtt_ew_ttxhaa_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphtt_ew_ttxhaa_2.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pphtt_ew_ttxhaa_2_/**/DREALKIND
  use ol_tensor_sum_storage_pphtt_ew_ttxhaa_2_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pphtt_ew_ttxhaa_2_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pphtt_ew_ttxhaa_2_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[nMT,nMT,nMH,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(1),n2h8(1))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[nMT,nMT,nMZ,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(2),n2h8(2))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[nMB,nMB,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(3),n2h8(3))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H16(1),0,ex5(:),16,G1H8(4),m3h2x8(:,4),heltab2x16(:,:,4))
  Gcoeff(:)%j = (c(114)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(5),h0tab(:,5),[16,4,1,2,8],[nMT,nMT,0,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(5),n2h8(4))
  Gcoeff(:)%j = (c(115)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(6),h0tab(:,6),[16,4,1,2,8],[nMT,nMT,nMZ,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(6),n2h8(5))
  Gcoeff(:)%j = (c(52)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(7),h0tab(:,7),[16,4,1,2,8],[nMB,nMB,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(7),n2h8(6))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(8),h0tab(:,8),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,8),heltab2x16(:,:,8))
  Gcoeff(:)%j = (c(50)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(9),h0tab(:,9),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(2),m3h2x8(:,9),heltab2x16(:,:,9))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(10),h0tab(:,10),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H16(1),0,ex5(:),16,G1H8(8),m3h2x8(:,10),heltab2x16(:,:,10))
  Gcoeff(:)%j = (c(50)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(11),h0tab(:,11),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H16(1),0,ex5(:),16,G1H8(9),m3h2x8(:,11),heltab2x16(:,:,11))
  Gcoeff(:)%j = (c(50)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(12),h0tab(:,12),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(10),m3h2x8(:,12),heltab2x16(:,:,12))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(13),h0tab(:,13),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(3),m3h2x8(:,13),heltab2x16(:,:,13))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(14),h0tab(:,14),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(4),m3h2x8(:,14),heltab2x16(:,:,14))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(15),h0tab(:,15),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(5),m3h2x8(:,15),heltab2x16(:,:,15))
  Gcoeff(:)%j = (c(84)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(16),h0tab(:,16),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(6),m3h2x8(:,16),heltab2x16(:,:,16))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(17),h0tab(:,17),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H16(1),0,ex5(:),16,G1H8(11),m3h2x8(:,17),heltab2x16(:,:,17))
  Gcoeff(:)%j = (c(50)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(18),h0tab(:,18),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(12),m3h2x8(:,18),heltab2x16(:,:,18))
  Gcoeff(:)%j = (c(84)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(19),h0tab(:,19),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(13),m3h2x8(:,19),heltab2x16(:,:,19))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(20),h0tab(:,20),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(7),m3h2x8(:,20),heltab2x16(:,:,20))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(21),h0tab(:,21),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(8),m3h2x8(:,21),heltab2x16(:,:,21))
  Gcoeff(:)%j = (c(84)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(22),h0tab(:,22),[16,4,1,2,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(14),m3h2x8(:,22),heltab2x16(:,:,22))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(23),h0tab(:,23),[16,2,1,4,8],[nMT,nMH,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(9),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_Q_A(ntryL,G0H8(9),16,nMT,G1H8(15),n2h8(7))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(24),h0tab(:,24),[16,2,1,4,8],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(9),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_Q_A(ntryL,G0H8(9),16,nMT,G1H8(16),n2h8(8))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(25),h0tab(:,25),[16,2,1,4,8],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(9),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_Q_A(ntryL,G0H8(9),16,nMB,G1H8(17),n2h8(9))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(26),h0tab(:,26),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H16(1),0,ex5(:),16,G1H8(18),m3h2x8(:,26),heltab2x16(:,:,26))
  Gcoeff(:)%j = (c(114)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(27),h0tab(:,27),[16,2,1,4,8],[nMT,0,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(9),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_Q_A(ntryL,G0H8(9),16,nMT,G1H8(19),n2h8(10))
  Gcoeff(:)%j = (c(115)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(28),h0tab(:,28),[16,2,1,4,8],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(9),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_Q_A(ntryL,G0H8(9),16,nMT,G1H8(20),n2h8(11))
  Gcoeff(:)%j = (c(52)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(29),h0tab(:,29),[16,2,1,4,8],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(9),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_Q_A(ntryL,G0H8(9),16,nMB,G1H8(21),n2h8(12))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(30),h0tab(:,30),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(9),m3h2x8(:,30),heltab2x16(:,:,30))
  Gcoeff(:)%j = (c(50)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(31),h0tab(:,31),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H16(1),0,ex5(:),16,G1H8(22),m3h2x8(:,31),heltab2x16(:,:,31))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(32),h0tab(:,32),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(10),m3h2x8(:,32),heltab2x16(:,:,32))
  Gcoeff(:)%j = (c(50)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(33),h0tab(:,33),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H16(1),0,ex5(:),16,G1H8(23),m3h2x8(:,33),heltab2x16(:,:,33))
  Gcoeff(:)%j = (c(50)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(34),h0tab(:,34),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(11),m3h2x8(:,34),heltab2x16(:,:,34))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(35),h0tab(:,35),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H16(1),0,ex5(:),16,G1H8(24),m3h2x8(:,35),heltab2x16(:,:,35))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(36),h0tab(:,36),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(12),m3h2x8(:,36),heltab2x16(:,:,36))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(37),h0tab(:,37),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(13),m3h2x8(:,37),heltab2x16(:,:,37))
  Gcoeff(:)%j = (c(84)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(38),h0tab(:,38),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H16(1),0,ex5(:),16,G1H8(25),m3h2x8(:,38),heltab2x16(:,:,38))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(39),h0tab(:,39),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(14),m3h2x8(:,39),heltab2x16(:,:,39))
  Gcoeff(:)%j = (c(50)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(40),h0tab(:,40),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H16(1),0,ex5(:),16,G1H8(26),m3h2x8(:,40),heltab2x16(:,:,40))
  Gcoeff(:)%j = (c(84)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(41),h0tab(:,41),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(15),m3h2x8(:,41),heltab2x16(:,:,41))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(42),h0tab(:,42),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H16(1),0,ex5(:),16,G1H8(27),m3h2x8(:,42),heltab2x16(:,:,42))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(43),h0tab(:,43),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(16),m3h2x8(:,43),heltab2x16(:,:,43))
  Gcoeff(:)%j = (c(84)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(44),h0tab(:,44),[16,2,1,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H16(1),0,ex5(:),16,G1H8(28),m3h2x8(:,44),heltab2x16(:,:,44))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(45),h0tab(:,45),[16,4,2,1,8],[nMT,nMT,nMH,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(17),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_Q_A(ntryL,G0H8(17),16,nMT,G1H8(29),n2h8(13))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(46),h0tab(:,46),[16,4,2,1,8],[nMT,nMT,nMZ,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(17),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_Q_A(ntryL,G0H8(17),16,nMT,G1H8(30),n2h8(14))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(47),h0tab(:,47),[16,4,2,1,8],[nMB,nMB,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(17),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_Q_A(ntryL,G0H8(17),16,nMB,G1H8(31),n2h8(15))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(48),h0tab(:,48),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H16(1),0,ex5(:),16,G1H8(32),m3h2x8(:,48),heltab2x16(:,:,48))
  Gcoeff(:)%j = (c(114)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(49),h0tab(:,49),[16,4,2,1,8],[nMT,nMT,0,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(17),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_Q_A(ntryL,G0H8(17),16,nMT,G1H8(33),n2h8(16))
  Gcoeff(:)%j = (c(115)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(50),h0tab(:,50),[16,4,2,1,8],[nMT,nMT,nMZ,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(17),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_Q_A(ntryL,G0H8(17),16,nMT,G1H8(34),n2h8(17))
  Gcoeff(:)%j = (c(52)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(51),h0tab(:,51),[16,4,2,1,8],[nMB,nMB,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(17),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_Q_A(ntryL,G0H8(17),16,nMB,G1H8(35),n2h8(18))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(52),h0tab(:,52),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(17),m3h2x8(:,52),heltab2x16(:,:,52))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(53),h0tab(:,53),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(18),m3h2x8(:,53),heltab2x16(:,:,53))
  Gcoeff(:)%j = (c(50)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(54),h0tab(:,54),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H16(1),0,ex5(:),16,G1H8(36),m3h2x8(:,54),heltab2x16(:,:,54))
  Gcoeff(:)%j = (c(60)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(55),h0tab(:,55),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H16(1),0,ex5(:),16,G1H8(37),m3h2x8(:,55),heltab2x16(:,:,55))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(56),h0tab(:,56),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H16(1),0,ex5(:),16,G1H8(38),m3h2x8(:,56),heltab2x16(:,:,56))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(57),h0tab(:,57),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(19),m3h2x8(:,57),heltab2x16(:,:,57))
  Gcoeff(:)%j = (-(c(84)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(58),h0tab(:,58),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(20),m3h2x8(:,58),heltab2x16(:,:,58))
  Gcoeff(:)%j = (c(60)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(59),h0tab(:,59),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(21),m3h2x8(:,59),heltab2x16(:,:,59))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(60),h0tab(:,60),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(22),m3h2x8(:,60),heltab2x16(:,:,60))
  Gcoeff(:)%j = (c(82)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(61),h0tab(:,61),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H16(1),0,ex5(:),16,G1H8(39),m3h2x8(:,61),heltab2x16(:,:,61))
  Gcoeff(:)%j = (-(c(84)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(62),h0tab(:,62),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H16(1),0,ex5(:),16,G1H8(40),m3h2x8(:,62),heltab2x16(:,:,62))
  Gcoeff(:)%j = (c(50)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(63),h0tab(:,63),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H16(1),0,ex5(:),16,G1H8(41),m3h2x8(:,63),heltab2x16(:,:,63))
  Gcoeff(:)%j = (c(82)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(64),h0tab(:,64),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(23),m3h2x8(:,64),heltab2x16(:,:,64))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(65),h0tab(:,65),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(24),m3h2x8(:,65),heltab2x16(:,:,65))
  Gcoeff(:)%j = (c(84)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(66),h0tab(:,66),[16,4,2,1,8],[nMW,nMW,nMB,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H16(1),0,ex5(:),16,G1H8(42),m3h2x8(:,66),heltab2x16(:,:,66))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(67),h0tab(:,67),[16,2,1,8,4],[nMT,nMH,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(25),m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_Q_A(ntryL,G0H8(25),16,nMT,G1H8(43),n2h8(19))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(68),h0tab(:,68),[16,2,1,8,4],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(25),m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_Q_A(ntryL,G0H8(25),16,nMT,G1H8(44),n2h8(20))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(69),h0tab(:,69),[16,2,1,8,4],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(25),m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_Q_A(ntryL,G0H8(25),16,nMB,G1H8(45),n2h8(21))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(70),h0tab(:,70),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H16(1),0,ex5(:),16,G1H8(46),m3h2x8(:,70),heltab2x16(:,:,70))
  Gcoeff(:)%j = (c(114)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(71),h0tab(:,71),[16,2,1,8,4],[nMT,0,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(25),m3h2x8(:,71),heltab2x16(:,:,71))
  call Hloop_Q_A(ntryL,G0H8(25),16,nMT,G1H8(47),n2h8(22))
  Gcoeff(:)%j = (c(115)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(72),h0tab(:,72),[16,2,1,8,4],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(25),m3h2x8(:,72),heltab2x16(:,:,72))
  call Hloop_Q_A(ntryL,G0H8(25),16,nMT,G1H8(48),n2h8(23))
  Gcoeff(:)%j = (c(52)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(73),h0tab(:,73),[16,2,1,8,4],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(25),m3h2x8(:,73),heltab2x16(:,:,73))
  call Hloop_Q_A(ntryL,G0H8(25),16,nMB,G1H8(49),n2h8(24))
  Gcoeff(:)%j = (c(50)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(74),h0tab(:,74),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(25),m3h2x8(:,74),heltab2x16(:,:,74))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(75),h0tab(:,75),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H16(1),0,ex5(:),16,G1H8(50),m3h2x8(:,75),heltab2x16(:,:,75))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(76),h0tab(:,76),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(26),m3h2x8(:,76),heltab2x16(:,:,76))
  Gcoeff(:)%j = (c(60)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(77),h0tab(:,77),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H16(1),0,ex5(:),16,G1H8(51),m3h2x8(:,77),heltab2x16(:,:,77))
  Gcoeff(:)%j = (-(c(84)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(78),h0tab(:,78),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(27),m3h2x8(:,78),heltab2x16(:,:,78))
  Gcoeff(:)%j = (c(50)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(79),h0tab(:,79),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H16(1),0,ex5(:),16,G1H8(52),m3h2x8(:,79),heltab2x16(:,:,79))
  Gcoeff(:)%j = (c(82)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(80),h0tab(:,80),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(28),m3h2x8(:,80),heltab2x16(:,:,80))
  Gcoeff(:)%j = (c(82)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(81),h0tab(:,81),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(29),m3h2x8(:,81),heltab2x16(:,:,81))
  Gcoeff(:)%j = (c(50)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(82),h0tab(:,82),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H16(1),0,ex5(:),16,G1H8(53),m3h2x8(:,82),heltab2x16(:,:,82))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(83),h0tab(:,83),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(30),m3h2x8(:,83),heltab2x16(:,:,83))
  Gcoeff(:)%j = (-(c(84)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(84),h0tab(:,84),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H16(1),0,ex5(:),16,G1H8(54),m3h2x8(:,84),heltab2x16(:,:,84))
  Gcoeff(:)%j = (c(84)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(85),h0tab(:,85),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(31),m3h2x8(:,85),heltab2x16(:,:,85))
  Gcoeff(:)%j = (c(82)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(86),h0tab(:,86),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H16(1),0,ex5(:),16,G1H8(55),m3h2x8(:,86),heltab2x16(:,:,86))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(87),h0tab(:,87),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(32),m3h2x8(:,87),heltab2x16(:,:,87))
  Gcoeff(:)%j = (c(84)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(88),h0tab(:,88),[16,2,1,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H16(1),0,ex5(:),16,G1H8(56),m3h2x8(:,88),heltab2x16(:,:,88))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(89),h0tab(:,89),[16,1,2,4,8],[nMT,nMH,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(33),m3h2x8(:,89),heltab2x16(:,:,89))
  call Hloop_A_Q(ntryL,G0H8(33),16,nMT,G1H8(57),n2h8(25))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(90),h0tab(:,90),[16,1,2,4,8],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(33),m3h2x8(:,90),heltab2x16(:,:,90))
  call Hloop_A_Q(ntryL,G0H8(33),16,nMT,G1H8(58),n2h8(26))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(91),h0tab(:,91),[16,1,2,4,8],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(33),m3h2x8(:,91),heltab2x16(:,:,91))
  call Hloop_A_Q(ntryL,G0H8(33),16,nMB,G1H8(59),n2h8(27))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(92),h0tab(:,92),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H16(1),0,ex5(:),16,G1H8(60),m3h2x8(:,92),heltab2x16(:,:,92))
  Gcoeff(:)%j = (c(114)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(93),h0tab(:,93),[16,1,2,4,8],[nMT,0,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(33),m3h2x8(:,93),heltab2x16(:,:,93))
  call Hloop_A_Q(ntryL,G0H8(33),16,nMT,G1H8(61),n2h8(28))
  Gcoeff(:)%j = (c(115)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(94),h0tab(:,94),[16,1,2,4,8],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(33),m3h2x8(:,94),heltab2x16(:,:,94))
  call Hloop_A_Q(ntryL,G0H8(33),16,nMT,G1H8(62),n2h8(29))
  Gcoeff(:)%j = (c(52)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(95),h0tab(:,95),[16,1,2,4,8],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(33),m3h2x8(:,95),heltab2x16(:,:,95))
  call Hloop_A_Q(ntryL,G0H8(33),16,nMB,G1H8(63),n2h8(30))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(96),h0tab(:,96),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(33),m3h2x8(:,96),heltab2x16(:,:,96))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(97),h0tab(:,97),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H16(1),0,ex5(:),16,G1H8(64),m3h2x8(:,97),heltab2x16(:,:,97))
  Gcoeff(:)%j = (c(50)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(98),h0tab(:,98),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H16(1),0,ex5(:),16,G1H8(65),m3h2x8(:,98),heltab2x16(:,:,98))
  Gcoeff(:)%j = (c(60)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(99),h0tab(:,99),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(34),m3h2x8(:,99),heltab2x16(:,:,99))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(100),h0tab(:,100),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(35),m3h2x8(:,100),heltab2x16(:,:,100))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(101),h0tab(:,101),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(36),m3h2x8(:,101),heltab2x16(:,:,101))
  Gcoeff(:)%j = (-(c(84)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(102),h0tab(:,102),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H16(1),0,ex5(:),16,G1H8(66),m3h2x8(:,102),heltab2x16(:,:,102))
  Gcoeff(:)%j = (c(60)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(103),h0tab(:,103),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(67),m3h2x8(:,103),heltab2x16(:,:,103))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(104),h0tab(:,104),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(37),m3h2x8(:,104),heltab2x16(:,:,104))
  Gcoeff(:)%j = (c(82)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(105),h0tab(:,105),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(38),m3h2x8(:,105),heltab2x16(:,:,105))
  Gcoeff(:)%j = (-(c(84)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(106),h0tab(:,106),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(39),m3h2x8(:,106),heltab2x16(:,:,106))
  Gcoeff(:)%j = (c(50)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(107),h0tab(:,107),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(68),m3h2x8(:,107),heltab2x16(:,:,107))
  Gcoeff(:)%j = (c(82)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(108),h0tab(:,108),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(69),m3h2x8(:,108),heltab2x16(:,:,108))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(109),h0tab(:,109),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(40),m3h2x8(:,109),heltab2x16(:,:,109))
  Gcoeff(:)%j = (c(84)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(110),h0tab(:,110),[16,1,2,4,8],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(70),m3h2x8(:,110),heltab2x16(:,:,110))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(111),h0tab(:,111),[16,1,2,8,4],[nMT,nMH,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(41),m3h2x8(:,111),heltab2x16(:,:,111))
  call Hloop_A_Q(ntryL,G0H8(41),16,nMT,G1H8(71),n2h8(31))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(112),h0tab(:,112),[16,1,2,8,4],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(41),m3h2x8(:,112),heltab2x16(:,:,112))
  call Hloop_A_Q(ntryL,G0H8(41),16,nMT,G1H8(72),n2h8(32))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(113),h0tab(:,113),[16,1,2,8,4],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(41),m3h2x8(:,113),heltab2x16(:,:,113))
  call Hloop_A_Q(ntryL,G0H8(41),16,nMB,G1H8(73),n2h8(33))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(114),h0tab(:,114),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H16(1),0,ex5(:),16,G1H8(74),m3h2x8(:,114),heltab2x16(:,:,114))
  Gcoeff(:)%j = (c(114)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(115),h0tab(:,115),[16,1,2,8,4],[nMT,0,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(41),m3h2x8(:,115),heltab2x16(:,:,115))
  call Hloop_A_Q(ntryL,G0H8(41),16,nMT,G1H8(75),n2h8(34))
  Gcoeff(:)%j = (c(115)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(116),h0tab(:,116),[16,1,2,8,4],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(41),m3h2x8(:,116),heltab2x16(:,:,116))
  call Hloop_A_Q(ntryL,G0H8(41),16,nMT,G1H8(76),n2h8(35))
  Gcoeff(:)%j = (c(52)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(117),h0tab(:,117),[16,1,2,8,4],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(41),m3h2x8(:,117),heltab2x16(:,:,117))
  call Hloop_A_Q(ntryL,G0H8(41),16,nMB,G1H8(77),n2h8(36))
  Gcoeff(:)%j = (-(c(50)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(118),h0tab(:,118),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(41),m3h2x8(:,118),heltab2x16(:,:,118))
  Gcoeff(:)%j = (c(50)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(119),h0tab(:,119),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H16(1),0,ex5(:),16,G1H8(78),m3h2x8(:,119),heltab2x16(:,:,119))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(120),h0tab(:,120),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H16(1),0,ex5(:),16,G1H8(79),m3h2x8(:,120),heltab2x16(:,:,120))
  Gcoeff(:)%j = (c(60)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(121),h0tab(:,121),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(42),m3h2x8(:,121),heltab2x16(:,:,121))
  Gcoeff(:)%j = (-(c(84)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(122),h0tab(:,122),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(43),m3h2x8(:,122),heltab2x16(:,:,122))
  Gcoeff(:)%j = (c(82)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(123),h0tab(:,123),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(44),m3h2x8(:,123),heltab2x16(:,:,123))
  Gcoeff(:)%j = (c(50)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(124),h0tab(:,124),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H16(1),0,ex5(:),16,G1H8(80),m3h2x8(:,124),heltab2x16(:,:,124))
  Gcoeff(:)%j = (c(50)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(125),h0tab(:,125),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(81),m3h2x8(:,125),heltab2x16(:,:,125))
  Gcoeff(:)%j = (c(82)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(126),h0tab(:,126),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(45),m3h2x8(:,126),heltab2x16(:,:,126))
  Gcoeff(:)%j = (-(c(86)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(127),h0tab(:,127),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(46),m3h2x8(:,127),heltab2x16(:,:,127))
  Gcoeff(:)%j = (-(c(84)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(128),h0tab(:,128),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(47),m3h2x8(:,128),heltab2x16(:,:,128))
  Gcoeff(:)%j = (c(84)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(129),h0tab(:,129),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(82),m3h2x8(:,129),heltab2x16(:,:,129))
  Gcoeff(:)%j = (-(c(82)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(130),h0tab(:,130),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(83),m3h2x8(:,130),heltab2x16(:,:,130))
  Gcoeff(:)%j = (c(82)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(131),h0tab(:,131),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(48),m3h2x8(:,131),heltab2x16(:,:,131))
  Gcoeff(:)%j = (c(84)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(132),h0tab(:,132),[16,1,2,8,4],[nMW,nMB,nMW,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(84),m3h2x8(:,132),heltab2x16(:,:,132))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(133),h0tab(:,133),[16,2,4,1,8],[nMT,nMH,nMH,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(49),m3h2x8(:,133),heltab2x16(:,:,133))
  call Hloop_Q_A(ntryL,G0H8(49),16,nMT,G1H8(85),n2h8(37))
  Gcoeff(:)%j = (c(40)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(134),h0tab(:,134),[16,2,4,1,8],[nMT,nMZ,nMZ,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(49),m3h2x8(:,134),heltab2x16(:,:,134))
  call Hloop_Q_A(ntryL,G0H8(49),16,nMT,G1H8(86),n2h8(38))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(135),h0tab(:,135),[16,2,4,1,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(49),m3h2x8(:,135),heltab2x16(:,:,135))
  call Hloop_Q_A(ntryL,G0H8(49),16,nMB,G1H8(87),n2h8(39))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(136),h0tab(:,136),[16,2,4,1,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H16(1),0,ex5(:),16,G1H8(88),m3h2x8(:,136),heltab2x16(:,:,136))
  Gcoeff(:)%j = (c(98)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(137),h0tab(:,137),[16,2,4,1,8],[nMT,nMZ,nMZ,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(49),m3h2x8(:,137),heltab2x16(:,:,137))
  call Hloop_Q_A(ntryL,G0H8(49),16,nMT,G1H8(89),n2h8(40))
  Gcoeff(:)%j = (c(45)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(138),h0tab(:,138),[16,2,4,1,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(49),m3h2x8(:,138),heltab2x16(:,:,138))
  call Hloop_Q_A(ntryL,G0H8(49),16,nMB,G1H8(90),n2h8(41))
  Gcoeff(:)%j = (c(98)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(139),h0tab(:,139),[16,2,4,1,8],[nMT,nMZ,nMZ,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(49),m3h2x8(:,139),heltab2x16(:,:,139))
  call Hloop_Q_A(ntryL,G0H8(49),16,nMT,G1H8(91),n2h8(42))
  Gcoeff(:)%j = (c(45)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(140),h0tab(:,140),[16,2,4,1,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(49),m3h2x8(:,140),heltab2x16(:,:,140))
  call Hloop_Q_A(ntryL,G0H8(49),16,nMB,G1H8(92),n2h8(43))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(141),h0tab(:,141),[16,2,4,1,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(49),m3h2x8(:,141),heltab2x16(:,:,141))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(142),h0tab(:,142),[16,2,4,1,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(50),m3h2x8(:,142),heltab2x16(:,:,142))
  Gcoeff(:)%j = (c(57)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(143),h0tab(:,143),[16,2,4,1,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H16(1),0,ex5(:),16,G1H8(93),m3h2x8(:,143),heltab2x16(:,:,143))
  Gcoeff(:)%j = (c(122)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(144),h0tab(:,144),[16,2,4,1,8],[nMT,nMZ,nMZ,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(51),m3h2x8(:,144),heltab2x16(:,:,144))
  call Hloop_Q_A(ntryL,G0H8(51),16,nMT,G1H8(94),n2h8(44))
  Gcoeff(:)%j = (c(77)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(145),h0tab(:,145),[16,2,4,1,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(51),m3h2x8(:,145),heltab2x16(:,:,145))
  call Hloop_Q_A(ntryL,G0H8(51),16,nMB,G1H8(95),n2h8(45))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(146),h0tab(:,146),[16,2,4,1,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H16(1),0,ex5(:),16,G1H8(96),m3h2x8(:,146),heltab2x16(:,:,146))
  Gcoeff(:)%j = (c(57)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(147),h0tab(:,147),[16,2,4,1,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(51),m3h2x8(:,147),heltab2x16(:,:,147))
  Gcoeff(:)%j = (-(c(85)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(148),h0tab(:,148),[16,2,4,1,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(52),m3h2x8(:,148),heltab2x16(:,:,148))
  Gcoeff(:)%j = (c(57)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(149),h0tab(:,149),[16,2,4,1,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H16(1),0,ex5(:),16,G1H8(97),m3h2x8(:,149),heltab2x16(:,:,149))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(150),h0tab(:,150),[16,2,8,1,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(53),m3h2x8(:,150),heltab2x16(:,:,150))
  call Hloop_Q_A(ntryL,G0H8(53),16,nMB,G1H8(98),n2h8(46))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(151),h0tab(:,151),[16,2,8,1,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H16(1),0,ex5(:),16,G1H8(99),m3h2x8(:,151),heltab2x16(:,:,151))
  Gcoeff(:)%j = (c(54)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(152),h0tab(:,152),[16,2,8,1,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(53),m3h2x8(:,152),heltab2x16(:,:,152))
  call Hloop_Q_A(ntryL,G0H8(53),16,nMB,G1H8(100),n2h8(47))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(153),h0tab(:,153),[16,2,8,1,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(53),m3h2x8(:,153),heltab2x16(:,:,153))
  call Hloop_Q_A(ntryL,G0H8(53),16,nMB,G1H8(101),n2h8(48))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(154),h0tab(:,154),[16,2,8,1,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(53),m3h2x8(:,154),heltab2x16(:,:,154))
  Gcoeff(:)%j = (c(58)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(155),h0tab(:,155),[16,2,8,1,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(54),m3h2x8(:,155),heltab2x16(:,:,155))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(156),h0tab(:,156),[16,2,8,1,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_SV_T(ntryL,G0H16(1),0,ex5(:),16,G1H8(102),m3h2x8(:,156),heltab2x16(:,:,156))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(157),h0tab(:,157),[16,2,8,1,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(55),m3h2x8(:,157),heltab2x16(:,:,157))
  call Hloop_Q_A(ntryL,G0H8(55),16,nMB,G1H8(103),n2h8(49))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(158),h0tab(:,158),[16,2,8,1,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H16(1),0,ex5(:),16,G1H8(104),m3h2x8(:,158),heltab2x16(:,:,158))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(159),h0tab(:,159),[16,2,8,1,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(55),m3h2x8(:,159),heltab2x16(:,:,159))
  Gcoeff(:)%j = (c(78)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(160),h0tab(:,160),[16,2,8,1,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(56),m3h2x8(:,160),heltab2x16(:,:,160))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(161),h0tab(:,161),[16,2,8,1,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_UW_V(ntryL,G0H16(1),0,ex5(:),16,G1H8(105),m3h2x8(:,161),heltab2x16(:,:,161))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(162),h0tab(:,162),[16,1,4,2,8],[nMT,nMH,nMH,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(57),m3h2x8(:,162),heltab2x16(:,:,162))
  call Hloop_A_Q(ntryL,G0H8(57),16,nMT,G1H8(106),n2h8(50))
  Gcoeff(:)%j = (c(40)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(163),h0tab(:,163),[16,1,4,2,8],[nMT,nMZ,nMZ,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(57),m3h2x8(:,163),heltab2x16(:,:,163))
  call Hloop_A_Q(ntryL,G0H8(57),16,nMT,G1H8(107),n2h8(51))
  Gcoeff(:)%j = (c(18)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(164),h0tab(:,164),[16,1,4,2,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(57),m3h2x8(:,164),heltab2x16(:,:,164))
  call Hloop_A_Q(ntryL,G0H8(57),16,nMB,G1H8(108),n2h8(52))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(165),h0tab(:,165),[16,1,4,2,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H16(1),0,ex5(:),16,G1H8(109),m3h2x8(:,165),heltab2x16(:,:,165))
  Gcoeff(:)%j = (c(98)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(166),h0tab(:,166),[16,1,4,2,8],[nMT,nMZ,nMZ,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(57),m3h2x8(:,166),heltab2x16(:,:,166))
  call Hloop_A_Q(ntryL,G0H8(57),16,nMT,G1H8(110),n2h8(53))
  Gcoeff(:)%j = (c(45)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(167),h0tab(:,167),[16,1,4,2,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(57),m3h2x8(:,167),heltab2x16(:,:,167))
  call Hloop_A_Q(ntryL,G0H8(57),16,nMB,G1H8(111),n2h8(54))
  Gcoeff(:)%j = (c(98)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(168),h0tab(:,168),[16,1,4,2,8],[nMT,nMZ,nMZ,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(57),m3h2x8(:,168),heltab2x16(:,:,168))
  call Hloop_A_Q(ntryL,G0H8(57),16,nMT,G1H8(112),n2h8(55))
  Gcoeff(:)%j = (c(45)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(169),h0tab(:,169),[16,1,4,2,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(57),m3h2x8(:,169),heltab2x16(:,:,169))
  call Hloop_A_Q(ntryL,G0H8(57),16,nMB,G1H8(113),n2h8(56))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(170),h0tab(:,170),[16,1,4,2,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(57),m3h2x8(:,170),heltab2x16(:,:,170))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(171),h0tab(:,171),[16,1,4,2,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H16(1),0,ex5(:),16,G1H8(114),m3h2x8(:,171),heltab2x16(:,:,171))
  Gcoeff(:)%j = (c(57)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(172),h0tab(:,172),[16,1,4,2,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(58),m3h2x8(:,172),heltab2x16(:,:,172))
  Gcoeff(:)%j = (c(122)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(173),h0tab(:,173),[16,1,4,2,8],[nMT,nMZ,nMZ,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(59),m3h2x8(:,173),heltab2x16(:,:,173))
  call Hloop_A_Q(ntryL,G0H8(59),16,nMT,G1H8(115),n2h8(57))
  Gcoeff(:)%j = (c(77)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(174),h0tab(:,174),[16,1,4,2,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(59),m3h2x8(:,174),heltab2x16(:,:,174))
  call Hloop_A_Q(ntryL,G0H8(59),16,nMB,G1H8(116),n2h8(58))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(175),h0tab(:,175),[16,1,4,2,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(59),m3h2x8(:,175),heltab2x16(:,:,175))
  Gcoeff(:)%j = (c(57)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(176),h0tab(:,176),[16,1,4,2,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(117),m3h2x8(:,176),heltab2x16(:,:,176))
  Gcoeff(:)%j = (-(c(85)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(177),h0tab(:,177),[16,1,4,2,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(60),m3h2x8(:,177),heltab2x16(:,:,177))
  Gcoeff(:)%j = (c(57)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(178),h0tab(:,178),[16,1,4,2,8],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(118),m3h2x8(:,178),heltab2x16(:,:,178))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(179),h0tab(:,179),[16,1,4,8,2],[nMW,nMB,nMB,nMB,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H16(1),0,ex5(:),16,G1H8(119),m3h2x8(:,179),heltab2x16(:,:,179))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(180),h0tab(:,180),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(61),m3h2x8(:,180),heltab2x16(:,:,180))
  call Hloop_A_Q(ntryL,G0H8(61),16,nMB,G1H8(120),n2h8(59))
  Gcoeff(:)%j = (c(54)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(181),h0tab(:,181),[16,1,4,8,2],[nMW,nMB,nMB,nMB,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(61),m3h2x8(:,181),heltab2x16(:,:,181))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(182),h0tab(:,182),[16,1,4,8,2],[nMW,nMB,nMB,nMB,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(62),m3h2x8(:,182),heltab2x16(:,:,182))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(183),h0tab(:,183),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(63),m3h2x8(:,183),heltab2x16(:,:,183))
  call Hloop_A_Q(ntryL,G0H8(63),16,nMB,G1H8(121),n2h8(60))
  Gcoeff(:)%j = (c(58)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(184),h0tab(:,184),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(63),m3h2x8(:,184),heltab2x16(:,:,184))
  call Hloop_A_Q(ntryL,G0H8(63),16,nMB,G1H8(122),n2h8(61))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(185),h0tab(:,185),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(63),m3h2x8(:,185),heltab2x16(:,:,185))
  call Hloop_A_Q(ntryL,G0H8(63),16,nMB,G1H8(123),n2h8(62))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(186),h0tab(:,186),[16,1,4,8,2],[nMW,nMB,nMB,nMB,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(124),m3h2x8(:,186),heltab2x16(:,:,186))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(187),h0tab(:,187),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(63),m3h2x8(:,187),heltab2x16(:,:,187))
  call Hloop_A_Q(ntryL,G0H8(63),16,nMB,G1H8(125),n2h8(63))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(188),h0tab(:,188),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(63),m3h2x8(:,188),heltab2x16(:,:,188))
  call Hloop_A_Q(ntryL,G0H8(63),16,nMB,G1H8(126),n2h8(64))
  Gcoeff(:)%j = (c(78)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(189),h0tab(:,189),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(63),m3h2x8(:,189),heltab2x16(:,:,189))
  call Hloop_A_Q(ntryL,G0H8(63),16,nMB,G1H8(127),n2h8(65))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(190),h0tab(:,190),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(63),m3h2x8(:,190),heltab2x16(:,:,190))
  call Hloop_A_Q(ntryL,G0H8(63),16,nMB,G1H8(128),n2h8(66))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(191),h0tab(:,191),[16,1,8,2,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(63),m3h2x8(:,191),heltab2x16(:,:,191))
  call Hloop_A_Q(ntryL,G0H8(63),16,nMB,G1H8(129),n2h8(67))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(192),h0tab(:,192),[16,1,8,2,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H16(1),0,ex5(:),16,G1H8(130),m3h2x8(:,192),heltab2x16(:,:,192))
  Gcoeff(:)%j = (c(54)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(193),h0tab(:,193),[16,1,8,2,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(63),m3h2x8(:,193),heltab2x16(:,:,193))
  call Hloop_A_Q(ntryL,G0H8(63),16,nMB,G1H8(131),n2h8(68))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(194),h0tab(:,194),[16,1,8,2,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(63),m3h2x8(:,194),heltab2x16(:,:,194))
  call Hloop_A_Q(ntryL,G0H8(63),16,nMB,G1H8(132),n2h8(69))
  Gcoeff(:)%j = (c(47)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(195),h0tab(:,195),[16,1,8,2,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(63),m3h2x8(:,195),heltab2x16(:,:,195))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(196),h0tab(:,196),[16,1,8,2,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H16(1),0,ex5(:),16,G1H8(133),m3h2x8(:,196),heltab2x16(:,:,196))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(197),h0tab(:,197),[16,1,8,2,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(64),m3h2x8(:,197),heltab2x16(:,:,197))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(198),h0tab(:,198),[16,1,8,2,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(65),m3h2x8(:,198),heltab2x16(:,:,198))
  call Hloop_A_Q(ntryL,G0H8(65),16,nMB,G1H8(134),n2h8(70))
  Gcoeff(:)%j = (c(80)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(199),h0tab(:,199),[16,1,8,2,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(65),m3h2x8(:,199),heltab2x16(:,:,199))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(200),h0tab(:,200),[16,1,8,2,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(135),m3h2x8(:,200),heltab2x16(:,:,200))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(201),h0tab(:,201),[16,1,8,2,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(66),m3h2x8(:,201),heltab2x16(:,:,201))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(202),h0tab(:,202),[16,1,8,2,4],[nMW,nMB,nMB,nMW,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(136),m3h2x8(:,202),heltab2x16(:,:,202))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(203),h0tab(:,203),[16,1,8,4,2],[nMW,nMB,nMB,nMB,nMW],5,0)
  call Hloop_TV_S(ntryL,G0H16(1),0,ex5(:),16,G1H8(137),m3h2x8(:,203),heltab2x16(:,:,203))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(204),h0tab(:,204),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(67),m3h2x8(:,204),heltab2x16(:,:,204))
  call Hloop_A_Q(ntryL,G0H8(67),16,nMB,G1H8(138),n2h8(71))
  Gcoeff(:)%j = (c(54)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(205),h0tab(:,205),[16,1,8,4,2],[nMW,nMB,nMB,nMB,nMW],5,0)
  call Hloop_VV_S(ntryL,G0H16(1),ex5(:),G0H8(67),m3h2x8(:,205),heltab2x16(:,:,205))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(206),h0tab(:,206),[16,1,8,4,2],[nMW,nMB,nMB,nMB,nMW],5,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex5(:),G0H8(68),m3h2x8(:,206),heltab2x16(:,:,206))
  Gcoeff(:)%j = (c(47)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(207),h0tab(:,207),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(69),m3h2x8(:,207),heltab2x16(:,:,207))
  call Hloop_A_Q(ntryL,G0H8(69),16,nMB,G1H8(139),n2h8(72))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(208),h0tab(:,208),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(69),m3h2x8(:,208),heltab2x16(:,:,208))
  call Hloop_A_Q(ntryL,G0H8(69),16,nMB,G1H8(140),n2h8(73))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(209),h0tab(:,209),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(69),m3h2x8(:,209),heltab2x16(:,:,209))
  call Hloop_A_Q(ntryL,G0H8(69),16,nMB,G1H8(141),n2h8(74))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(210),h0tab(:,210),[16,1,8,4,2],[nMW,nMB,nMB,nMB,nMW],5,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex5(:),16,G1H8(142),m3h2x8(:,210),heltab2x16(:,:,210))
  Gcoeff(:)%j = (c(80)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(211),h0tab(:,211),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(69),m3h2x8(:,211),heltab2x16(:,:,211))
  call Hloop_A_Q(ntryL,G0H8(69),16,nMB,G1H8(143),n2h8(75))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(212),h0tab(:,212),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(69),m3h2x8(:,212),heltab2x16(:,:,212))
  call Hloop_A_Q(ntryL,G0H8(69),16,nMB,G1H8(144),n2h8(76))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(213),h0tab(:,213),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(69),m3h2x8(:,213),heltab2x16(:,:,213))
  call Hloop_A_Q(ntryL,G0H8(69),16,nMB,G1H8(145),n2h8(77))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(214),h0tab(:,214),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(69),m3h2x8(:,214),heltab2x16(:,:,214))
  call Hloop_A_Q(ntryL,G0H8(69),16,nMB,G1H8(146),n2h8(78))
  call Hloop_AS_Q(ntryL,G1H8(1),ex3(:),G1H8(147),ngH,m3h1x8(:,1),heltab2x8(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(147),20,nMT,G2H8(1),n2h8(79))
  call Hloop_AS_Q(ntryL,G1H8(2),ex3(:),G1H8(1),ngH,m3h1x8(:,2),heltab2x8(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(2),n2h8(80))
  call Hloop_AS_Q(ntryL,G1H8(3),ex3(:),G1H8(147),ngH,m3h1x8(:,3),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(147),20,nMB,G2H8(3),n2h8(81))
  call Hloop_SS_S(ntryL,G1H8(4),ex3(:),G1H8(2),m3h1x8(:,4),heltab2x8(:,:,4))
  call Hloop_AS_Q(ntryL,G1H8(5),ex3(:),G1H8(1),ngH,m3h1x8(:,5),heltab2x8(:,:,5))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(4),n2h8(82))
  call Hloop_AS_Q(ntryL,G1H8(6),ex3(:),G1H8(3),ngH,m3h1x8(:,6),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G1H8(3),20,nMT,G2H8(5),n2h8(83))
  call Hloop_AS_Q(ntryL,G1H8(7),ex3(:),G1H8(147),ngH,m3h1x8(:,7),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G1H8(147),20,nMB,G2H8(6),n2h8(84))
  call Hloop_SS_S(ntryL,G0H8(1),ex3(:),G0H8(69),m3h1x8(:,8),heltab2x8(:,:,8))
  call Hloop_VT_S(ntryL,G0H8(2),16,ex3(:),4,G1H8(4),m3h1x8(:,9),heltab2x8(:,:,9))
  call Hloop_SS_S(ntryL,G1H8(8),ex3(:),G1H8(5),m3h1x8(:,10),heltab2x8(:,:,10))
  call Hloop_ST_V(ntryL,G1H8(9),16,ex3(:),4,G2H8(7),m3h1x8(:,11),heltab2x8(:,:,11))
  call Hloop_VT_S(ntryL,G1H8(10),16,ex3(:),4,G2H8(8),m3h1x8(:,12),heltab2x8(:,:,12))
  call Hloop_SS_S(ntryL,G0H8(3),ex3(:),G0H8(1),m3h1x8(:,13),heltab2x8(:,:,13))
  call Hloop_VT_S(ntryL,G0H8(4),16,ex3(:),4,G1H8(1),m3h1x8(:,14),heltab2x8(:,:,14))
  call Hloop_ST_V(ntryL,G0H8(5),16,ex3(:),4,G1H8(6),m3h1x8(:,15),heltab2x8(:,:,15))
  call Hloop_VS_V(ntryL,G0H8(6),ex3(:),G0H8(2),m3h1x8(:,16),heltab2x8(:,:,16))
  call Hloop_ST_V(ntryL,G1H8(11),16,ex3(:),4,G2H8(9),m3h1x8(:,17),heltab2x8(:,:,17))
  call Hloop_VT_S(ntryL,G1H8(12),16,ex3(:),4,G2H8(10),m3h1x8(:,18),heltab2x8(:,:,18))
  call Hloop_VS_V(ntryL,G1H8(13),ex3(:),G1H8(3),m3h1x8(:,19),heltab2x8(:,:,19))
  call Hloop_ST_V(ntryL,G0H8(7),16,ex3(:),4,G1H8(7),m3h1x8(:,20),heltab2x8(:,:,20))
  call Hloop_VS_V(ntryL,G0H8(8),ex3(:),G0H8(3),m3h1x8(:,21),heltab2x8(:,:,21))
  call Hloop_VS_V(ntryL,G1H8(14),ex3(:),G1H8(147),m3h1x8(:,22),heltab2x8(:,:,22))
  call Hloop_QA_S(ntryL,G1H8(15),ex2(:),G1H4(1),ngH,m3h2x4(:,1),heltab2x8(:,:,23))
  call Hloop_QA_S(ntryL,G1H8(16),ex2(:),G1H4(2),ngX,m3h2x4(:,2),heltab2x8(:,:,24))
  call Hloop_QA_S(ntryL,G1H8(17),ex2(:),G1H4(3),ngPtb,m3h2x4(:,3),heltab2x8(:,:,25))
  call Hloop_SA_Q(ntryL,G1H8(18),ex2(:),G1H4(4),ngPtb,m3h2x4(:,4),heltab2x8(:,:,26))
  call Hloop_A_Q(ntryL,G1H4(4),18,nMB,G2H4(1),n2h4(1))
  call Hloop_QA_V(ntryL,G1H8(19),ex2(:),G1H4(4),m3h2x4(:,5),heltab2x8(:,:,27))
  call Hloop_QA_Z(ntryL,G1H8(20),ex2(:),G1H4(5),ngZu,m3h2x4(:,6),heltab2x8(:,:,28))
  call Hloop_QA_W(ntryL,G1H8(21),ex2(:),G1H4(6),m3h2x4(:,7),heltab2x8(:,:,29))
  call Hloop_SA_Q(ntryL,G0H8(9),ex2(:),G0H4(1),ngPtb,m3h2x4(:,8),heltab2x8(:,:,30))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMB,G1H4(7),n2h4(2))
  call Hloop_SA_Q(ntryL,G1H8(22),ex2(:),G1H4(8),ngPtb,m3h2x4(:,9),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G1H4(8),18,nMB,G2H4(2),n2h4(3))
  call Hloop_WA_Q(ntryL,G0H8(10),ex2(:),G0H4(1),m3h2x4(:,10),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMB,G1H4(8),n2h4(4))
  call Hloop_SA_Q(ntryL,G1H8(23),ex2(:),G1H4(9),ngPtb,m3h2x4(:,11),heltab2x8(:,:,33))
  call Hloop_A_Q(ntryL,G1H4(9),18,nMB,G2H4(3),n2h4(5))
  call Hloop_SA_Q(ntryL,G0H8(11),ex2(:),G0H4(1),ngPtb,m3h2x4(:,12),heltab2x8(:,:,34))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMB,G1H4(9),n2h4(6))
  call Hloop_WA_Q(ntryL,G1H8(24),ex2(:),G1H4(10),m3h2x4(:,13),heltab2x8(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(10),18,nMB,G2H4(4),n2h4(7))
  call Hloop_WA_Q(ntryL,G0H8(12),ex2(:),G0H4(1),m3h2x4(:,14),heltab2x8(:,:,36))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMB,G1H4(10),n2h4(8))
  call Hloop_SA_Q(ntryL,G0H8(13),ex2(:),G0H4(1),ngPtb,m3h2x4(:,15),heltab2x8(:,:,37))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMB,G1H4(11),n2h4(9))
  call Hloop_SA_Q(ntryL,G1H8(25),ex2(:),G1H4(12),ngPtb,m3h2x4(:,16),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G1H4(12),18,nMB,G2H4(5),n2h4(10))
  call Hloop_WA_Q(ntryL,G0H8(14),ex2(:),G0H4(1),m3h2x4(:,17),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMB,G1H4(12),n2h4(11))
  call Hloop_WA_Q(ntryL,G1H8(26),ex2(:),G1H4(13),m3h2x4(:,18),heltab2x8(:,:,40))
  call Hloop_A_Q(ntryL,G1H4(13),18,nMB,G2H4(6),n2h4(12))
  call Hloop_SA_Q(ntryL,G0H8(15),ex2(:),G0H4(1),ngPtb,m3h2x4(:,19),heltab2x8(:,:,41))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMB,G1H4(13),n2h4(13))
  call Hloop_WA_Q(ntryL,G1H8(27),ex2(:),G1H4(14),m3h2x4(:,20),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G1H4(14),18,nMB,G2H4(7),n2h4(14))
  call Hloop_WA_Q(ntryL,G0H8(16),ex2(:),G0H4(1),m3h2x4(:,21),heltab2x8(:,:,43))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMB,G1H4(14),n2h4(15))
  call Hloop_WA_Q(ntryL,G1H8(28),ex2(:),G1H4(15),m3h2x4(:,22),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(15),18,nMB,G2H4(8),n2h4(16))
  call Hloop_QS_A(ntryL,G1H8(29),ex3(:),G1H8(8),ngH,m3h1x8(:,23),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G1H8(8),20,nMT,G2H8(11),n2h8(85))
  call Hloop_QS_A(ntryL,G1H8(30),ex3(:),G1H8(9),ngH,m3h1x8(:,24),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G1H8(9),20,nMT,G2H8(12),n2h8(86))
  call Hloop_QS_A(ntryL,G1H8(31),ex3(:),G1H8(10),ngH,m3h1x8(:,25),heltab2x8(:,:,47))
  call Hloop_Q_A(ntryL,G1H8(10),20,nMB,G2H8(13),n2h8(87))
  call Hloop_SS_S(ntryL,G1H8(32),ex3(:),G1H8(11),m3h1x8(:,26),heltab2x8(:,:,48))
  call Hloop_QS_A(ntryL,G1H8(33),ex3(:),G1H8(12),ngH,m3h1x8(:,27),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H8(12),20,nMT,G2H8(14),n2h8(88))
  call Hloop_QS_A(ntryL,G1H8(34),ex3(:),G1H8(13),ngH,m3h1x8(:,28),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H8(13),20,nMT,G2H8(15),n2h8(89))
  call Hloop_QS_A(ntryL,G1H8(35),ex3(:),G1H8(14),ngH,m3h1x8(:,29),heltab2x8(:,:,51))
  call Hloop_Q_A(ntryL,G1H8(14),20,nMB,G2H8(16),n2h8(90))
  call Hloop_SS_S(ntryL,G0H8(17),ex3(:),G0H8(4),m3h1x8(:,30),heltab2x8(:,:,52))
  call Hloop_VT_S(ntryL,G0H8(18),16,ex3(:),4,G1H8(15),m3h1x8(:,31),heltab2x8(:,:,53))
  call Hloop_ST_V(ntryL,G1H8(36),16,ex3(:),4,G2H8(17),m3h1x8(:,32),heltab2x8(:,:,54))
  call Hloop_SS_S(ntryL,G1H8(37),ex3(:),G1H8(16),m3h1x8(:,33),heltab2x8(:,:,55))
  call Hloop_VT_S(ntryL,G1H8(38),16,ex3(:),4,G2H8(18),m3h1x8(:,34),heltab2x8(:,:,56))
  call Hloop_ST_V(ntryL,G0H8(19),16,ex3(:),4,G1H8(17),m3h1x8(:,35),heltab2x8(:,:,57))
  call Hloop_VS_V(ntryL,G0H8(20),ex3(:),G0H8(5),m3h1x8(:,36),heltab2x8(:,:,58))
  call Hloop_SS_S(ntryL,G0H8(21),ex3(:),G0H8(6),m3h1x8(:,37),heltab2x8(:,:,59))
  call Hloop_VT_S(ntryL,G0H8(22),16,ex3(:),4,G1H8(18),m3h1x8(:,38),heltab2x8(:,:,60))
  call Hloop_ST_V(ntryL,G1H8(39),16,ex3(:),4,G2H8(19),m3h1x8(:,39),heltab2x8(:,:,61))
  call Hloop_VS_V(ntryL,G1H8(40),ex3(:),G1H8(19),m3h1x8(:,40),heltab2x8(:,:,62))
  call Hloop_VT_S(ntryL,G1H8(41),16,ex3(:),4,G2H8(20),m3h1x8(:,41),heltab2x8(:,:,63))
  call Hloop_ST_V(ntryL,G0H8(23),16,ex3(:),4,G1H8(20),m3h1x8(:,42),heltab2x8(:,:,64))
  call Hloop_VS_V(ntryL,G0H8(24),ex3(:),G0H8(7),m3h1x8(:,43),heltab2x8(:,:,65))
  call Hloop_VS_V(ntryL,G1H8(42),ex3(:),G1H8(21),m3h1x8(:,44),heltab2x8(:,:,66))
  call Hloop_QA_S(ntryL,G1H8(43),ex2(:),G1H4(15),ngH,m3h2x4(:,23),heltab2x8(:,:,67))
  call Hloop_QA_S(ntryL,G1H8(44),ex2(:),G1H4(16),ngX,m3h2x4(:,24),heltab2x8(:,:,68))
  call Hloop_QA_S(ntryL,G1H8(45),ex2(:),G1H4(17),ngPtb,m3h2x4(:,25),heltab2x8(:,:,69))
  call Hloop_SA_Q(ntryL,G1H8(46),ex2(:),G1H4(18),ngPtb,m3h2x4(:,26),heltab2x8(:,:,70))
  call Hloop_A_Q(ntryL,G1H4(18),18,nMB,G2H4(9),n2h4(17))
  call Hloop_QA_V(ntryL,G1H8(47),ex2(:),G1H4(18),m3h2x4(:,27),heltab2x8(:,:,71))
  call Hloop_QA_Z(ntryL,G1H8(48),ex2(:),G1H4(19),ngZu,m3h2x4(:,28),heltab2x8(:,:,72))
  call Hloop_QA_W(ntryL,G1H8(49),ex2(:),G1H4(20),m3h2x4(:,29),heltab2x8(:,:,73))
  call Hloop_SA_Q(ntryL,G0H8(25),ex2(:),G0H4(1),ngPtb,m3h2x4(:,30),heltab2x8(:,:,74))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMB,G1H4(21),n2h4(18))
  call Hloop_SA_Q(ntryL,G1H8(50),ex2(:),G1H4(22),ngPtb,m3h2x4(:,31),heltab2x8(:,:,75))
  call Hloop_A_Q(ntryL,G1H4(22),18,nMB,G2H4(10),n2h4(19))
  call Hloop_WA_Q(ntryL,G0H8(26),ex2(:),G0H4(1),m3h2x4(:,32),heltab2x8(:,:,76))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMB,G1H4(22),n2h4(20))
  call Hloop_SA_Q(ntryL,G1H8(51),ex2(:),G1H4(23),ngPtb,m3h2x4(:,33),heltab2x8(:,:,77))
  call Hloop_A_Q(ntryL,G1H4(23),18,nMB,G2H4(11),n2h4(21))
  call Hloop_SA_Q(ntryL,G0H8(27),ex2(:),G0H4(1),ngPtb,m3h2x4(:,34),heltab2x8(:,:,78))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMB,G1H4(23),n2h4(22))
  call Hloop_WA_Q(ntryL,G1H8(52),ex2(:),G1H4(24),m3h2x4(:,35),heltab2x8(:,:,79))
  call Hloop_A_Q(ntryL,G1H4(24),18,nMB,G2H4(12),n2h4(23))
  call Hloop_WA_Q(ntryL,G0H8(28),ex2(:),G0H4(1),m3h2x4(:,36),heltab2x8(:,:,80))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMB,G1H4(24),n2h4(24))
  call Hloop_SA_Q(ntryL,G0H8(29),ex2(:),G0H4(1),ngPtb,m3h2x4(:,37),heltab2x8(:,:,81))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMB,G1H4(25),n2h4(25))
  call Hloop_SA_Q(ntryL,G1H8(53),ex2(:),G1H4(26),ngPtb,m3h2x4(:,38),heltab2x8(:,:,82))
  call Hloop_A_Q(ntryL,G1H4(26),18,nMB,G2H4(13),n2h4(26))
  call Hloop_WA_Q(ntryL,G0H8(30),ex2(:),G0H4(1),m3h2x4(:,39),heltab2x8(:,:,83))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMB,G1H4(26),n2h4(27))
  call Hloop_WA_Q(ntryL,G1H8(54),ex2(:),G1H4(27),m3h2x4(:,40),heltab2x8(:,:,84))
  call Hloop_A_Q(ntryL,G1H4(27),18,nMB,G2H4(14),n2h4(28))
  call Hloop_SA_Q(ntryL,G0H8(31),ex2(:),G0H4(1),ngPtb,m3h2x4(:,41),heltab2x8(:,:,85))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMB,G1H4(27),n2h4(29))
  call Hloop_WA_Q(ntryL,G1H8(55),ex2(:),G1H4(28),m3h2x4(:,42),heltab2x8(:,:,86))
  call Hloop_A_Q(ntryL,G1H4(28),18,nMB,G2H4(15),n2h4(30))
  call Hloop_WA_Q(ntryL,G0H8(32),ex2(:),G0H4(1),m3h2x4(:,43),heltab2x8(:,:,87))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMB,G1H4(28),n2h4(31))
  call Hloop_WA_Q(ntryL,G1H8(56),ex2(:),G1H4(29),m3h2x4(:,44),heltab2x8(:,:,88))
  call Hloop_A_Q(ntryL,G1H4(29),18,nMB,G2H4(16),n2h4(32))
  call Hloop_AQ_S(ntryL,G1H8(57),ex1(:),G1H4(29),ngH,m3h2x4(:,45),heltab2x8(:,:,89))
  call Hloop_AQ_S(ntryL,G1H8(58),ex1(:),G1H4(30),ngX,m3h2x4(:,46),heltab2x8(:,:,90))
  call Hloop_AQ_S(ntryL,G1H8(59),ex1(:),G1H4(31),ngPbt,m3h2x4(:,47),heltab2x8(:,:,91))
  call Hloop_SQ_A(ntryL,G1H8(60),ex1(:),G1H4(32),ngPbt,m3h2x4(:,48),heltab2x8(:,:,92))
  call Hloop_Q_A(ntryL,G1H4(32),17,nMB,G2H4(17),n2h4(33))
  call Hloop_AQ_V(ntryL,G1H8(61),ex1(:),G1H4(32),m3h2x4(:,49),heltab2x8(:,:,93))
  call Hloop_AQ_Z(ntryL,G1H8(62),ex1(:),G1H4(33),ngZu,m3h2x4(:,50),heltab2x8(:,:,94))
  call Hloop_AQ_W(ntryL,G1H8(63),ex1(:),G1H4(34),m3h2x4(:,51),heltab2x8(:,:,95))
  call Hloop_SQ_A(ntryL,G0H8(33),ex1(:),G0H4(1),ngPbt,m3h2x4(:,52),heltab2x8(:,:,96))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(35),n2h4(34))
  call Hloop_SQ_A(ntryL,G1H8(64),ex1(:),G1H4(36),ngPbt,m3h2x4(:,53),heltab2x8(:,:,97))
  call Hloop_Q_A(ntryL,G1H4(36),17,nMB,G2H4(18),n2h4(35))
  call Hloop_SQ_A(ntryL,G1H8(65),ex1(:),G1H4(36),ngPbt,m3h2x4(:,54),heltab2x8(:,:,98))
  call Hloop_Q_A(ntryL,G1H4(36),17,nMB,G2H4(19),n2h4(36))
  call Hloop_WQ_A(ntryL,G0H8(34),ex1(:),G0H4(1),m3h2x4(:,55),heltab2x8(:,:,99))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(36),n2h4(37))
  call Hloop_SQ_A(ntryL,G0H8(35),ex1(:),G0H4(1),ngPbt,m3h2x4(:,56),heltab2x8(:,:,100))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(37),n2h4(38))
  call Hloop_SQ_A(ntryL,G0H8(36),ex1(:),G0H4(1),ngPbt,m3h2x4(:,57),heltab2x8(:,:,101))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(38),n2h4(39))
  call Hloop_SQ_A(ntryL,G1H8(66),ex1(:),G1H4(39),ngPbt,m3h2x4(:,58),heltab2x8(:,:,102))
  call Hloop_Q_A(ntryL,G1H4(39),17,nMB,G2H4(20),n2h4(40))
  call Hloop_WQ_A(ntryL,G1H8(67),ex1(:),G1H4(39),m3h2x4(:,59),heltab2x8(:,:,103))
  call Hloop_Q_A(ntryL,G1H4(39),17,nMB,G2H4(21),n2h4(41))
  call Hloop_WQ_A(ntryL,G0H8(37),ex1(:),G0H4(1),m3h2x4(:,60),heltab2x8(:,:,104))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(39),n2h4(42))
  call Hloop_WQ_A(ntryL,G0H8(38),ex1(:),G0H4(1),m3h2x4(:,61),heltab2x8(:,:,105))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(40),n2h4(43))
  call Hloop_SQ_A(ntryL,G0H8(39),ex1(:),G0H4(1),ngPbt,m3h2x4(:,62),heltab2x8(:,:,106))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(41),n2h4(44))
  call Hloop_WQ_A(ntryL,G1H8(68),ex1(:),G1H4(42),m3h2x4(:,63),heltab2x8(:,:,107))
  call Hloop_Q_A(ntryL,G1H4(42),17,nMB,G2H4(22),n2h4(45))
  call Hloop_WQ_A(ntryL,G1H8(69),ex1(:),G1H4(42),m3h2x4(:,64),heltab2x8(:,:,108))
  call Hloop_Q_A(ntryL,G1H4(42),17,nMB,G2H4(23),n2h4(46))
  call Hloop_WQ_A(ntryL,G0H8(40),ex1(:),G0H4(1),m3h2x4(:,65),heltab2x8(:,:,109))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(42),n2h4(47))
  call Hloop_WQ_A(ntryL,G1H8(70),ex1(:),G1H4(43),m3h2x4(:,66),heltab2x8(:,:,110))
  call Hloop_Q_A(ntryL,G1H4(43),17,nMB,G2H4(24),n2h4(48))
  call Hloop_AQ_S(ntryL,G1H8(71),ex1(:),G1H4(43),ngH,m3h2x4(:,67),heltab2x8(:,:,111))
  call Hloop_AQ_S(ntryL,G1H8(72),ex1(:),G1H4(44),ngX,m3h2x4(:,68),heltab2x8(:,:,112))
  call Hloop_AQ_S(ntryL,G1H8(73),ex1(:),G1H4(45),ngPbt,m3h2x4(:,69),heltab2x8(:,:,113))
  call Hloop_SQ_A(ntryL,G1H8(74),ex1(:),G1H4(46),ngPbt,m3h2x4(:,70),heltab2x8(:,:,114))
  call Hloop_Q_A(ntryL,G1H4(46),17,nMB,G2H4(25),n2h4(49))
  call Hloop_AQ_V(ntryL,G1H8(75),ex1(:),G1H4(46),m3h2x4(:,71),heltab2x8(:,:,115))
  call Hloop_AQ_Z(ntryL,G1H8(76),ex1(:),G1H4(47),ngZu,m3h2x4(:,72),heltab2x8(:,:,116))
  call Hloop_AQ_W(ntryL,G1H8(77),ex1(:),G1H4(48),m3h2x4(:,73),heltab2x8(:,:,117))
  call Hloop_SQ_A(ntryL,G0H8(41),ex1(:),G0H4(1),ngPbt,m3h2x4(:,74),heltab2x8(:,:,118))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(49),n2h4(50))
  call Hloop_SQ_A(ntryL,G1H8(78),ex1(:),G1H4(50),ngPbt,m3h2x4(:,75),heltab2x8(:,:,119))
  call Hloop_Q_A(ntryL,G1H4(50),17,nMB,G2H4(26),n2h4(51))
  call Hloop_SQ_A(ntryL,G1H8(79),ex1(:),G1H4(50),ngPbt,m3h2x4(:,76),heltab2x8(:,:,120))
  call Hloop_Q_A(ntryL,G1H4(50),17,nMB,G2H4(27),n2h4(52))
  call Hloop_WQ_A(ntryL,G0H8(42),ex1(:),G0H4(1),m3h2x4(:,77),heltab2x8(:,:,121))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(50),n2h4(53))
  call Hloop_SQ_A(ntryL,G0H8(43),ex1(:),G0H4(1),ngPbt,m3h2x4(:,78),heltab2x8(:,:,122))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(51),n2h4(54))
  call Hloop_SQ_A(ntryL,G0H8(44),ex1(:),G0H4(1),ngPbt,m3h2x4(:,79),heltab2x8(:,:,123))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(52),n2h4(55))
  call Hloop_SQ_A(ntryL,G1H8(80),ex1(:),G1H4(53),ngPbt,m3h2x4(:,80),heltab2x8(:,:,124))
  call Hloop_Q_A(ntryL,G1H4(53),17,nMB,G2H4(28),n2h4(56))
  call Hloop_WQ_A(ntryL,G1H8(81),ex1(:),G1H4(53),m3h2x4(:,81),heltab2x8(:,:,125))
  call Hloop_Q_A(ntryL,G1H4(53),17,nMB,G2H4(29),n2h4(57))
  call Hloop_WQ_A(ntryL,G0H8(45),ex1(:),G0H4(1),m3h2x4(:,82),heltab2x8(:,:,126))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(53),n2h4(58))
  call Hloop_WQ_A(ntryL,G0H8(46),ex1(:),G0H4(1),m3h2x4(:,83),heltab2x8(:,:,127))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(54),n2h4(59))
  call Hloop_SQ_A(ntryL,G0H8(47),ex1(:),G0H4(1),ngPbt,m3h2x4(:,84),heltab2x8(:,:,128))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(55),n2h4(60))
  call Hloop_WQ_A(ntryL,G1H8(82),ex1(:),G1H4(56),m3h2x4(:,85),heltab2x8(:,:,129))
  call Hloop_Q_A(ntryL,G1H4(56),17,nMB,G2H4(30),n2h4(61))
  call Hloop_WQ_A(ntryL,G1H8(83),ex1(:),G1H4(56),m3h2x4(:,86),heltab2x8(:,:,130))
  call Hloop_Q_A(ntryL,G1H4(56),17,nMB,G2H4(31),n2h4(62))
  call Hloop_WQ_A(ntryL,G0H8(48),ex1(:),G0H4(1),m3h2x4(:,87),heltab2x8(:,:,131))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(56),n2h4(63))
  call Hloop_WQ_A(ntryL,G1H8(84),ex1(:),G1H4(57),m3h2x4(:,88),heltab2x8(:,:,132))
  call Hloop_Q_A(ntryL,G1H4(57),17,nMB,G2H4(32),n2h4(64))
  call Hloop_QA_S(ntryL,G1H8(85),ex2(:),G1H4(57),ngH,m3h2x4(:,89),heltab2x8(:,:,133))
  call Hloop_QA_S(ntryL,G1H8(86),ex2(:),G1H4(58),ngX,m3h2x4(:,90),heltab2x8(:,:,134))
  call Hloop_QA_S(ntryL,G1H8(87),ex2(:),G1H4(59),ngPtb,m3h2x4(:,91),heltab2x8(:,:,135))
  call Hloop_SA_Q(ntryL,G1H8(88),ex2(:),G1H4(60),ngPtb,m3h2x4(:,92),heltab2x8(:,:,136))
  call Hloop_A_Q(ntryL,G1H4(60),18,nMB,G2H4(33),n2h4(65))
  call Hloop_QA_Z(ntryL,G1H8(89),ex2(:),G1H4(60),ngZu,m3h2x4(:,93),heltab2x8(:,:,137))
  call Hloop_QA_W(ntryL,G1H8(90),ex2(:),G1H4(61),m3h2x4(:,94),heltab2x8(:,:,138))
  call Hloop_QA_S(ntryL,G1H8(91),ex2(:),G1H4(62),ngX,m3h2x4(:,95),heltab2x8(:,:,139))
  call Hloop_QA_S(ntryL,G1H8(92),ex2(:),G1H4(63),ngPtb,m3h2x4(:,96),heltab2x8(:,:,140))
  call Hloop_SA_Q(ntryL,G0H8(49),ex2(:),G0H4(1),ngPtb,m3h2x4(:,97),heltab2x8(:,:,141))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMB,G1H4(64),n2h4(66))
  call Hloop_WA_Q(ntryL,G0H8(50),ex2(:),G0H4(1),m3h2x4(:,98),heltab2x8(:,:,142))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMB,G1H4(65),n2h4(67))
  call Hloop_SA_Q(ntryL,G1H8(93),ex2(:),G1H4(66),ngPtb,m3h2x4(:,99),heltab2x8(:,:,143))
  call Hloop_A_Q(ntryL,G1H4(66),18,nMB,G2H4(34),n2h4(68))
  call Hloop_QA_Z(ntryL,G1H8(94),ex2(:),G1H4(66),ngZu,m3h2x4(:,100),heltab2x8(:,:,144))
  call Hloop_QA_W(ntryL,G1H8(95),ex2(:),G1H4(67),m3h2x4(:,101),heltab2x8(:,:,145))
  call Hloop_WA_Q(ntryL,G1H8(96),ex2(:),G1H4(68),m3h2x4(:,102),heltab2x8(:,:,146))
  call Hloop_A_Q(ntryL,G1H4(68),18,nMB,G2H4(35),n2h4(69))
  call Hloop_SA_Q(ntryL,G0H8(51),ex2(:),G0H4(1),ngPtb,m3h2x4(:,103),heltab2x8(:,:,147))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMB,G1H4(68),n2h4(70))
  call Hloop_WA_Q(ntryL,G0H8(52),ex2(:),G0H4(1),m3h2x4(:,104),heltab2x8(:,:,148))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMB,G1H4(69),n2h4(71))
  call Hloop_WA_Q(ntryL,G1H8(97),ex2(:),G1H4(70),m3h2x4(:,105),heltab2x8(:,:,149))
  call Hloop_A_Q(ntryL,G1H4(70),18,nMB,G2H4(36),n2h4(72))
  call Hloop_QA_S(ntryL,G1H8(98),ex2(:),G1H4(70),ngPtb,m3h2x4(:,106),heltab2x8(:,:,150))
  call Hloop_SA_Q(ntryL,G1H8(99),ex2(:),G1H4(71),ngPtb,m3h2x4(:,107),heltab2x8(:,:,151))
  call Hloop_A_Q(ntryL,G1H4(71),18,nMB,G2H4(37),n2h4(73))
  call Hloop_QA_W(ntryL,G1H8(100),ex2(:),G1H4(71),m3h2x4(:,108),heltab2x8(:,:,152))
  call Hloop_QA_S(ntryL,G1H8(101),ex2(:),G1H4(72),ngPtb,m3h2x4(:,109),heltab2x8(:,:,153))
  call Hloop_SA_Q(ntryL,G0H8(53),ex2(:),G0H4(1),ngPtb,m3h2x4(:,110),heltab2x8(:,:,154))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMB,G1H4(73),n2h4(74))
  call Hloop_WA_Q(ntryL,G0H8(54),ex2(:),G0H4(1),m3h2x4(:,111),heltab2x8(:,:,155))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMB,G1H4(74),n2h4(75))
  call Hloop_SA_Q(ntryL,G1H8(102),ex2(:),G1H4(75),ngPtb,m3h2x4(:,112),heltab2x8(:,:,156))
  call Hloop_A_Q(ntryL,G1H4(75),18,nMB,G2H4(38),n2h4(76))
  call Hloop_QA_W(ntryL,G1H8(103),ex2(:),G1H4(75),m3h2x4(:,113),heltab2x8(:,:,157))
  call Hloop_WA_Q(ntryL,G1H8(104),ex2(:),G1H4(76),m3h2x4(:,114),heltab2x8(:,:,158))
  call Hloop_A_Q(ntryL,G1H4(76),18,nMB,G2H4(39),n2h4(77))
  call Hloop_SA_Q(ntryL,G0H8(55),ex2(:),G0H4(1),ngPtb,m3h2x4(:,115),heltab2x8(:,:,159))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMB,G1H4(76),n2h4(78))
  call Hloop_WA_Q(ntryL,G0H8(56),ex2(:),G0H4(1),m3h2x4(:,116),heltab2x8(:,:,160))
  call Hloop_A_Q(ntryL,G0H4(1),18,nMB,G1H4(77),n2h4(79))
  call Hloop_WA_Q(ntryL,G1H8(105),ex2(:),G1H4(78),m3h2x4(:,117),heltab2x8(:,:,161))
  call Hloop_A_Q(ntryL,G1H4(78),18,nMB,G2H4(40),n2h4(80))
  call Hloop_AQ_S(ntryL,G1H8(106),ex1(:),G1H4(78),ngH,m3h2x4(:,118),heltab2x8(:,:,162))
  call Hloop_AQ_S(ntryL,G1H8(107),ex1(:),G1H4(79),ngX,m3h2x4(:,119),heltab2x8(:,:,163))
  call Hloop_AQ_S(ntryL,G1H8(108),ex1(:),G1H4(80),ngPbt,m3h2x4(:,120),heltab2x8(:,:,164))
  call Hloop_SQ_A(ntryL,G1H8(109),ex1(:),G1H4(81),ngPbt,m3h2x4(:,121),heltab2x8(:,:,165))
  call Hloop_Q_A(ntryL,G1H4(81),17,nMB,G2H4(41),n2h4(81))
  call Hloop_AQ_S(ntryL,G1H8(110),ex1(:),G1H4(81),ngX,m3h2x4(:,122),heltab2x8(:,:,166))
  call Hloop_AQ_S(ntryL,G1H8(111),ex1(:),G1H4(82),ngPbt,m3h2x4(:,123),heltab2x8(:,:,167))
  call Hloop_AQ_Z(ntryL,G1H8(112),ex1(:),G1H4(83),ngZu,m3h2x4(:,124),heltab2x8(:,:,168))
  call Hloop_AQ_W(ntryL,G1H8(113),ex1(:),G1H4(84),m3h2x4(:,125),heltab2x8(:,:,169))
  call Hloop_SQ_A(ntryL,G0H8(57),ex1(:),G0H4(1),ngPbt,m3h2x4(:,126),heltab2x8(:,:,170))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(85),n2h4(82))
  call Hloop_SQ_A(ntryL,G1H8(114),ex1(:),G1H4(86),ngPbt,m3h2x4(:,127),heltab2x8(:,:,171))
  call Hloop_Q_A(ntryL,G1H4(86),17,nMB,G2H4(42),n2h4(83))
  call Hloop_WQ_A(ntryL,G0H8(58),ex1(:),G0H4(1),m3h2x4(:,128),heltab2x8(:,:,172))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(86),n2h4(84))
  call Hloop_AQ_Z(ntryL,G1H8(115),ex1(:),G1H4(87),ngZu,m3h2x4(:,129),heltab2x8(:,:,173))
  call Hloop_AQ_W(ntryL,G1H8(116),ex1(:),G1H4(88),m3h2x4(:,130),heltab2x8(:,:,174))
  call Hloop_SQ_A(ntryL,G0H8(59),ex1(:),G0H4(1),ngPbt,m3h2x4(:,131),heltab2x8(:,:,175))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(89),n2h4(85))
  call Hloop_WQ_A(ntryL,G1H8(117),ex1(:),G1H4(90),m3h2x4(:,132),heltab2x8(:,:,176))
  call Hloop_Q_A(ntryL,G1H4(90),17,nMB,G2H4(43),n2h4(86))
  call Hloop_WQ_A(ntryL,G0H8(60),ex1(:),G0H4(1),m3h2x4(:,133),heltab2x8(:,:,177))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(90),n2h4(87))
  call Hloop_WQ_A(ntryL,G1H8(118),ex1(:),G1H4(91),m3h2x4(:,134),heltab2x8(:,:,178))
  call Hloop_Q_A(ntryL,G1H4(91),17,nMB,G2H4(44),n2h4(88))
  call Hloop_SQ_A(ntryL,G1H8(119),ex1(:),G1H4(91),ngPbt,m3h2x4(:,135),heltab2x8(:,:,179))
  call Hloop_Q_A(ntryL,G1H4(91),17,nMB,G2H4(45),n2h4(89))
  call Hloop_AQ_S(ntryL,G1H8(120),ex1(:),G1H4(91),ngPbt,m3h2x4(:,136),heltab2x8(:,:,180))
  call Hloop_SQ_A(ntryL,G0H8(61),ex1(:),G0H4(1),ngPbt,m3h2x4(:,137),heltab2x8(:,:,181))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(92),n2h4(90))
  call Hloop_WQ_A(ntryL,G0H8(62),ex1(:),G0H4(1),m3h2x4(:,138),heltab2x8(:,:,182))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(93),n2h4(91))
  call Hloop_AQ_S(ntryL,G1H8(121),ex1(:),G1H4(94),ngPbt,m3h2x4(:,139),heltab2x8(:,:,183))
  call Hloop_AQ_S(ntryL,G1H8(122),ex1(:),G1H4(95),ngPbt,m3h2x4(:,140),heltab2x8(:,:,184))
  call Hloop_AQ_W(ntryL,G1H8(123),ex1(:),G1H4(96),m3h2x4(:,141),heltab2x8(:,:,185))
  call Hloop_WQ_A(ntryL,G1H8(124),ex1(:),G1H4(97),m3h2x4(:,142),heltab2x8(:,:,186))
  call Hloop_Q_A(ntryL,G1H4(97),17,nMB,G2H4(46),n2h4(92))
  call Hloop_AQ_S(ntryL,G1H8(125),ex1(:),G1H4(97),ngPbt,m3h2x4(:,143),heltab2x8(:,:,187))
  call Hloop_AQ_W(ntryL,G1H8(126),ex1(:),G1H4(98),m3h2x4(:,144),heltab2x8(:,:,188))
  call Hloop_AQ_W(ntryL,G1H8(127),ex1(:),G1H4(99),m3h2x4(:,145),heltab2x8(:,:,189))
  call Hloop_AQ_W(ntryL,G1H8(128),ex1(:),G1H4(100),m3h2x4(:,146),heltab2x8(:,:,190))
  call Hloop_AQ_S(ntryL,G1H8(129),ex1(:),G1H4(101),ngPbt,m3h2x4(:,147),heltab2x8(:,:,191))
  call Hloop_SQ_A(ntryL,G1H8(130),ex1(:),G1H4(102),ngPbt,m3h2x4(:,148),heltab2x8(:,:,192))
  call Hloop_Q_A(ntryL,G1H4(102),17,nMB,G2H4(47),n2h4(93))
  call Hloop_AQ_S(ntryL,G1H8(131),ex1(:),G1H4(102),ngPbt,m3h2x4(:,149),heltab2x8(:,:,193))
  call Hloop_AQ_W(ntryL,G1H8(132),ex1(:),G1H4(103),m3h2x4(:,150),heltab2x8(:,:,194))
  call Hloop_SQ_A(ntryL,G0H8(63),ex1(:),G0H4(1),ngPbt,m3h2x4(:,151),heltab2x8(:,:,195))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(104),n2h4(94))
  call Hloop_SQ_A(ntryL,G1H8(133),ex1(:),G1H4(105),ngPbt,m3h2x4(:,152),heltab2x8(:,:,196))
  call Hloop_Q_A(ntryL,G1H4(105),17,nMB,G2H4(48),n2h4(95))
  call Hloop_WQ_A(ntryL,G0H8(64),ex1(:),G0H4(1),m3h2x4(:,153),heltab2x8(:,:,197))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(105),n2h4(96))
  call Hloop_AQ_W(ntryL,G1H8(134),ex1(:),G1H4(106),m3h2x4(:,154),heltab2x8(:,:,198))
  call Hloop_SQ_A(ntryL,G0H8(65),ex1(:),G0H4(1),ngPbt,m3h2x4(:,155),heltab2x8(:,:,199))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(107),n2h4(97))
  call Hloop_WQ_A(ntryL,G1H8(135),ex1(:),G1H4(108),m3h2x4(:,156),heltab2x8(:,:,200))
  call Hloop_Q_A(ntryL,G1H4(108),17,nMB,G2H4(49),n2h4(98))
  call Hloop_WQ_A(ntryL,G0H8(66),ex1(:),G0H4(1),m3h2x4(:,157),heltab2x8(:,:,201))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(108),n2h4(99))
  call Hloop_WQ_A(ntryL,G1H8(136),ex1(:),G1H4(109),m3h2x4(:,158),heltab2x8(:,:,202))
  call Hloop_Q_A(ntryL,G1H4(109),17,nMB,G2H4(50),n2h4(100))
  call Hloop_SQ_A(ntryL,G1H8(137),ex1(:),G1H4(109),ngPbt,m3h2x4(:,159),heltab2x8(:,:,203))
  call Hloop_Q_A(ntryL,G1H4(109),17,nMB,G2H4(51),n2h4(101))
  call Hloop_AQ_S(ntryL,G1H8(138),ex1(:),G1H4(109),ngPbt,m3h2x4(:,160),heltab2x8(:,:,204))
  call Hloop_SQ_A(ntryL,G0H8(67),ex1(:),G0H4(1),ngPbt,m3h2x4(:,161),heltab2x8(:,:,205))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(110),n2h4(102))
  call Hloop_WQ_A(ntryL,G0H8(68),ex1(:),G0H4(1),m3h2x4(:,162),heltab2x8(:,:,206))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(111),n2h4(103))
  call Hloop_AQ_S(ntryL,G1H8(139),ex1(:),G1H4(112),ngPbt,m3h2x4(:,163),heltab2x8(:,:,207))
  call Hloop_AQ_S(ntryL,G1H8(140),ex1(:),G1H4(113),ngPbt,m3h2x4(:,164),heltab2x8(:,:,208))
  call Hloop_AQ_W(ntryL,G1H8(141),ex1(:),G1H4(114),m3h2x4(:,165),heltab2x8(:,:,209))
  call Hloop_WQ_A(ntryL,G1H8(142),ex1(:),G1H4(115),m3h2x4(:,166),heltab2x8(:,:,210))
  call Hloop_Q_A(ntryL,G1H4(115),17,nMB,G2H4(52),n2h4(104))
  call Hloop_AQ_S(ntryL,G1H8(143),ex1(:),G1H4(115),ngPbt,m3h2x4(:,167),heltab2x8(:,:,211))
  call Hloop_AQ_W(ntryL,G1H8(144),ex1(:),G1H4(116),m3h2x4(:,168),heltab2x8(:,:,212))
  call Hloop_AQ_W(ntryL,G1H8(145),ex1(:),G1H4(117),m3h2x4(:,169),heltab2x8(:,:,213))
  call Hloop_AQ_W(ntryL,G1H8(146),ex1(:),G1H4(118),m3h2x4(:,170),heltab2x8(:,:,214))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(4),[G1H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(8),[G0H8(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1),[G1H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(7),[G0H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(10),[G0H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(3),[G1H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(9),[G0H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(147),[G1H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(1),[G1H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(4),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(2),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(3),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(15),[G1H8(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(18),[G0H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(17),[G0H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(18),[G1H8(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(19),[G1H8(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(20),[G0H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(19),[G0H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(21),[G1H8(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G1H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G1H4(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G1H4(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(17),[G1H4(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(21),[G1H4(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G1H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(19),[G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(22),[G1H4(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(23),[G1H4(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(20),[G1H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(24),[G1H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(25),[G1H4(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(29),[G1H4(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(26),[G1H4(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(27),[G1H4(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(30),[G1H4(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(31),[G1H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(28),[G1H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(32),[G1H4(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(33),[G1H4(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(35),[G1H4(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(34),[G1H4(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(36),[G1H4(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(37),[G1H4(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(39),[G1H4(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(38),[G1H4(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(40),[G1H4(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(41),[G1H4(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(43),[G1H4(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(42),[G1H4(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(44),[G1H4(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(45),[G1H4(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(46),[G1H4(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(47),[G1H4(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(49),[G1H4(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(48),[G1H4(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(50),[G1H4(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(51),[G1H4(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(52),[G1H4(110)])
  call Hloop_AQ_S(ntryL,G2H8(1),ex1(:),G2H4(53),ngH,m3h2x4(:,171),heltab2x8(:,:,215))
  call Hloop_AQ_S(ntryL,G2H8(2),ex1(:),G2H4(54),ngX,m3h2x4(:,172),heltab2x8(:,:,216))
  call Hloop_AQ_S(ntryL,G2H8(3),ex1(:),G2H4(55),ngPbt,m3h2x4(:,173),heltab2x8(:,:,217))
  call Hloop_SQ_A(ntryL,G1H8(4),ex1(:),G1H4(8),ngPbt,m3h2x4(:,174),heltab2x8(:,:,218))
  call Hloop_Q_A(ntryL,G1H4(8),21,nMB,G2H4(56),n2h4(105))
  call Hloop_AQ_V(ntryL,G2H8(4),ex1(:),G2H4(57),m3h2x4(:,175),heltab2x8(:,:,219))
  call Hloop_AQ_Z(ntryL,G2H8(5),ex1(:),G2H4(58),ngZu,m3h2x4(:,176),heltab2x8(:,:,220))
  call Hloop_AQ_W(ntryL,G2H8(6),ex1(:),G2H4(59),m3h2x4(:,177),heltab2x8(:,:,221))
  call Hotf_5pt_reduction(G2H8(8),RedSet_5(1),mass5set(:,1),  & 
G1H8(22),G1H8(23),G1H8(24),G1H8(25),G1H8(26),G1H8(27),8)
  call HG1shiftOLR(G1H8(23),8,8)
  call Hloop_SQ_A(ntryL,G1H8(1),ex1(:),G1H4(7),ngPbt,m3h2x4(:,178),heltab2x8(:,:,222))
  call Hloop_Q_A(ntryL,G1H4(7),21,nMB,G2H4(60),n2h4(106))
  call Hotf_5pt_reduction(G2H8(7),RedSet_5(1),mass5set(:,1),  & 
G1H8(28),G1H8(29),G1H8(8),G1H8(30),G1H8(9),G1H8(31),8)
  call HG1shiftOLR(G1H8(29),8,8)
  call Hotf_5pt_reduction(G2H8(10),RedSet_5(1),mass5set(:,1),  & 
G1H8(10),G1H8(32),G1H8(33),G1H8(12),G1H8(34),G1H8(13),8)
  call HG1shiftOLR(G1H8(32),8,8)
  call Hloop_WQ_A(ntryL,G1H8(3),ex1(:),G1H4(10),m3h2x4(:,179),heltab2x8(:,:,223))
  call Hloop_Q_A(ntryL,G1H4(10),21,nMB,G2H4(61),n2h4(107))
  call Hotf_5pt_reduction(G2H8(9),RedSet_5(1),mass5set(:,1),  & 
G1H8(35),G1H8(14),G1H8(36),G1H8(37),G1H8(38),G1H8(39),8)
  call HG1shiftOLR(G1H8(14),8,8)
  call Hloop_WQ_A(ntryL,G1H8(147),ex1(:),G1H4(12),m3h2x4(:,180),heltab2x8(:,:,224))
  call Hloop_Q_A(ntryL,G1H4(12),21,nMB,G2H4(62),n2h4(108))
  call Hloop_SQ_A(ntryL,G1H4(1),ex1(:),G1H2(1),ngH,m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMT,G2H2(1),n2h2(1))
  call Hloop_SQ_A(ntryL,G1H4(2),ex1(:),G1H2(1),ngX,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMT,G2H2(2),n2h2(2))
  call Hloop_SQ_A(ntryL,G1H4(3),ex1(:),G1H2(1),ngPbt,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMB,G2H2(3),n2h2(3))
  call Hloop_AQ_S(ntryL,G2H4(1),ex1(:),G2H2(4),ngPbt,m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_VQ_A(ntryL,G1H4(4),ex1(:),G1H2(1),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMT,G2H2(5),n2h2(4))
  call Hloop_ZQ_A(ntryL,G1H4(5),ex1(:),G1H2(1),ngZu,m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMT,G2H2(6),n2h2(5))
  call Hloop_WQ_A(ntryL,G1H4(6),ex1(:),G1H2(1),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMB,G2H2(7),n2h2(6))
  call Hloop_AQ_S(ntryL,G2H4(4),ex1(:),G2H2(8),ngPbt,m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_S(ntryL,G2H4(2),ex1(:),G2H2(9),ngPbt,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_W(ntryL,G2H4(3),ex1(:),G2H2(10),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_AQ_S(ntryL,G2H4(6),ex1(:),G2H2(11),ngPbt,m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_W(ntryL,G2H4(7),ex1(:),G2H2(12),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_AQ_W(ntryL,G2H4(5),ex1(:),G2H2(13),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_AQ_W(ntryL,G2H4(8),ex1(:),G2H2(14),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QA_S(ntryL,G2H8(11),ex2(:),G2H4(1),ngH,m3h2x4(:,181),heltab2x8(:,:,225))
  call Hloop_QA_S(ntryL,G2H8(12),ex2(:),G2H4(4),ngX,m3h2x4(:,182),heltab2x8(:,:,226))
  call Hloop_QA_S(ntryL,G2H8(13),ex2(:),G2H4(2),ngPtb,m3h2x4(:,183),heltab2x8(:,:,227))
  call Hloop_SA_Q(ntryL,G1H8(15),ex2(:),G1H4(9),ngPtb,m3h2x4(:,184),heltab2x8(:,:,228))
  call Hloop_A_Q(ntryL,G1H4(9),22,nMB,G2H4(3),n2h4(109))
  call Hloop_QA_V(ntryL,G2H8(14),ex2(:),G2H4(6),m3h2x4(:,185),heltab2x8(:,:,229))
  call Hloop_QA_Z(ntryL,G2H8(15),ex2(:),G2H4(7),ngZu,m3h2x4(:,186),heltab2x8(:,:,230))
  call Hloop_QA_W(ntryL,G2H8(16),ex2(:),G2H4(5),m3h2x4(:,187),heltab2x8(:,:,231))
  call Hotf_5pt_reduction(G2H8(18),RedSet_5(2),mass5set(:,1),  & 
G1H8(40),G1H8(41),G1H8(42),G1H8(43),G1H8(44),G1H8(45),8)
  call HG1shiftOLR(G1H8(41),8,8)
  call Hotf_5pt_reduction(G2H8(17),RedSet_5(2),mass5set(:,1),  & 
G1H8(46),G1H8(47),G1H8(48),G1H8(49),G1H8(50),G1H8(51),8)
  call HG1shiftOLR(G1H8(47),8,8)
  call Hloop_SA_Q(ntryL,G1H8(18),ex2(:),G1H4(11),ngPtb,m3h2x4(:,188),heltab2x8(:,:,232))
  call Hloop_A_Q(ntryL,G1H4(11),22,nMB,G2H4(8),n2h4(110))
  call Hloop_WA_Q(ntryL,G1H8(19),ex2(:),G1H4(14),m3h2x4(:,189),heltab2x8(:,:,233))
  call Hloop_A_Q(ntryL,G1H4(14),22,nMB,G2H4(63),n2h4(111))
  call Hotf_5pt_reduction(G2H8(20),RedSet_5(2),mass5set(:,1),  & 
G1H8(52),G1H8(53),G1H8(54),G1H8(55),G1H8(56),G1H8(57),8)
  call HG1shiftOLR(G1H8(53),8,8)
  call Hotf_5pt_reduction(G2H8(19),RedSet_5(2),mass5set(:,1),  & 
G1H8(58),G1H8(59),G1H8(60),G1H8(61),G1H8(62),G1H8(63),8)
  call HG1shiftOLR(G1H8(59),8,8)
  call Hloop_WA_Q(ntryL,G1H8(21),ex2(:),G1H4(13),m3h2x4(:,190),heltab2x8(:,:,234))
  call Hloop_A_Q(ntryL,G1H4(13),22,nMB,G2H4(64),n2h4(112))
  call Hloop_SQ_A(ntryL,G1H4(15),ex1(:),G1H2(1),ngH,m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMT,G2H2(15),n2h2(7))
  call Hloop_SQ_A(ntryL,G1H4(16),ex1(:),G1H2(1),ngX,m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMT,G2H2(16),n2h2(8))
  call Hloop_SQ_A(ntryL,G1H4(17),ex1(:),G1H2(1),ngPbt,m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMB,G2H2(17),n2h2(9))
  call Hloop_AQ_S(ntryL,G2H4(9),ex1(:),G2H2(18),ngPbt,m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_VQ_A(ntryL,G1H4(18),ex1(:),G1H2(1),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMT,G2H2(19),n2h2(10))
  call Hloop_ZQ_A(ntryL,G1H4(19),ex1(:),G1H2(1),ngZu,m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMT,G2H2(20),n2h2(11))
  call Hloop_WQ_A(ntryL,G1H4(20),ex1(:),G1H2(1),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMB,G2H2(21),n2h2(12))
  call Hloop_AQ_S(ntryL,G2H4(12),ex1(:),G2H2(22),ngPbt,m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_AQ_S(ntryL,G2H4(10),ex1(:),G2H2(23),ngPbt,m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_AQ_W(ntryL,G2H4(11),ex1(:),G2H2(24),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_AQ_S(ntryL,G2H4(14),ex1(:),G2H2(25),ngPbt,m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_AQ_W(ntryL,G2H4(15),ex1(:),G2H2(26),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_AQ_W(ntryL,G2H4(13),ex1(:),G2H2(27),m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_AQ_W(ntryL,G2H4(16),ex1(:),G2H2(28),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_SA_Q(ntryL,G1H4(29),ex2(:),G1H2(1),ngH,m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMT,G2H2(29),n2h2(13))
  call Hloop_SA_Q(ntryL,G1H4(30),ex2(:),G1H2(1),ngX,m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMT,G2H2(30),n2h2(14))
  call Hloop_SA_Q(ntryL,G1H4(31),ex2(:),G1H2(1),ngPtb,m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMB,G2H2(31),n2h2(15))
  call Hloop_QA_S(ntryL,G2H4(17),ex2(:),G2H2(32),ngPtb,m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_VA_Q(ntryL,G1H4(32),ex2(:),G1H2(1),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMT,G2H2(33),n2h2(16))
  call Hloop_ZA_Q(ntryL,G1H4(33),ex2(:),G1H2(1),ngZu,m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMT,G2H2(34),n2h2(17))
  call Hloop_WA_Q(ntryL,G1H4(34),ex2(:),G1H2(1),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMB,G2H2(35),n2h2(18))
  call Hloop_QA_S(ntryL,G2H4(21),ex2(:),G2H2(36),ngPtb,m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_QA_S(ntryL,G2H4(18),ex2(:),G2H2(37),ngPtb,m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_QA_W(ntryL,G2H4(19),ex2(:),G2H2(38),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_QA_S(ntryL,G2H4(22),ex2(:),G2H2(39),ngPtb,m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_QA_W(ntryL,G2H4(23),ex2(:),G2H2(40),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_QA_W(ntryL,G2H4(20),ex2(:),G2H2(41),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_QA_W(ntryL,G2H4(24),ex2(:),G2H2(42),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_SA_Q(ntryL,G1H4(43),ex2(:),G1H2(1),ngH,m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMT,G2H2(43),n2h2(19))
  call Hloop_SA_Q(ntryL,G1H4(44),ex2(:),G1H2(1),ngX,m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMT,G2H2(44),n2h2(20))
  call Hloop_SA_Q(ntryL,G1H4(45),ex2(:),G1H2(1),ngPtb,m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMB,G2H2(45),n2h2(21))
  call Hloop_QA_S(ntryL,G2H4(25),ex2(:),G2H2(46),ngPtb,m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_VA_Q(ntryL,G1H4(46),ex2(:),G1H2(1),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMT,G2H2(47),n2h2(22))
  call Hloop_ZA_Q(ntryL,G1H4(47),ex2(:),G1H2(1),ngZu,m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMT,G2H2(48),n2h2(23))
  call Hloop_WA_Q(ntryL,G1H4(48),ex2(:),G1H2(1),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMB,G2H2(49),n2h2(24))
  call Hloop_QA_S(ntryL,G2H4(29),ex2(:),G2H2(50),ngPtb,m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_QA_S(ntryL,G2H4(26),ex2(:),G2H2(51),ngPtb,m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_QA_W(ntryL,G2H4(27),ex2(:),G2H2(52),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_QA_S(ntryL,G2H4(30),ex2(:),G2H2(53),ngPtb,m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_QA_W(ntryL,G2H4(31),ex2(:),G2H2(54),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_QA_W(ntryL,G2H4(28),ex2(:),G2H2(55),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_QA_W(ntryL,G2H4(32),ex2(:),G2H2(56),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_SS_S(ntryL,G1H4(57),ex3(:),G1H4(22),m3h1x4(:,1),heltab2x4(:,:,57))
  call Hloop_SS_S(ntryL,G1H4(58),ex3(:),G1H4(21),m3h1x4(:,2),heltab2x4(:,:,58))
  call Hloop_SS_S(ntryL,G1H4(59),ex3(:),G1H4(24),m3h1x4(:,3),heltab2x4(:,:,59))
  call Hotf_5pt_reduction(G2H4(33),RedSet_5(3),mass5set(:,2),  & 
G1H4(26),G1H4(23),G1H4(25),G1H4(28),G1H4(27),G1H4(36),4)
  call HG1shiftOLR(G1H4(23),8,4)
  call Hloop_VT_S(ntryL,G1H4(60),18,ex3(:),4,G2H4(9),m3h1x4(:,4),heltab2x4(:,:,60))
  call Hloop_VT_S(ntryL,G1H4(61),18,ex3(:),4,G2H4(12),m3h1x4(:,5),heltab2x4(:,:,61))
  call Hloop_ST_V(ntryL,G1H4(62),18,ex3(:),4,G2H4(10),m3h1x4(:,6),heltab2x4(:,:,62))
  call Hloop_ST_V(ntryL,G1H4(63),18,ex3(:),4,G2H4(11),m3h1x4(:,7),heltab2x4(:,:,63))
  call Hotf_5pt_reduction(G2H4(35),RedSet_5(3),mass5set(:,2),  & 
G1H4(35),G1H4(39),G1H4(40),G1H4(37),G1H4(38),G1H4(42),4)
  call HG1shiftOLR(G1H4(39),8,4)
  call Hotf_5pt_reduction(G2H4(34),RedSet_5(3),mass5set(:,2),  & 
G1H4(41),G1H4(50),G1H4(49),G1H4(53),G1H4(54),G1H4(51),4)
  call HG1shiftOLR(G1H4(50),8,4)
  call Hloop_VS_V(ntryL,G1H4(66),ex3(:),G1H4(52),m3h1x4(:,8),heltab2x4(:,:,64))
  call Hloop_VS_V(ntryL,G1H4(67),ex3(:),G1H4(56),m3h1x4(:,9),heltab2x4(:,:,65))
  call Hotf_5pt_reduction(G2H4(36),RedSet_5(3),mass5set(:,2),  & 
G1H4(55),G1H4(65),G1H4(64),G1H4(69),G1H4(68),G1H4(74),4)
  call HG1shiftOLR(G1H4(65),8,4)
  call Hloop_TV_S(ntryL,G1H4(70),18,ex4(:),8,G2H2(57),m3h2x2(:,57),heltab2x4(:,:,66))
  call Hotf_5pt_reduction(G2H4(37),RedSet_5(4),mass5set(:,2),  & 
G1H4(73),G1H4(77),G1H4(76),G1H4(86),G1H4(85),G1H4(90),4)
  call HG1shiftOLR(G1H4(77),4,4)
  call Hloop_VV_S(ntryL,G1H4(71),ex4(:),G1H2(1),m3h2x2(:,58),heltab2x4(:,:,67))
  call Hloop_SV_V(ntryL,G1H4(72),ex4(:),G1H2(2),m3h2x2(:,59),heltab2x4(:,:,68))
  call Hotf_5pt_reduction(G2H4(39),RedSet_5(4),mass5set(:,2),  & 
G1H4(89),G1H4(93),G1H4(92),G1H4(105),G1H4(104),G1H4(108),4)
  call HG1shiftOLR(G1H4(93),4,4)
  call Hotf_5pt_reduction(G2H4(38),RedSet_5(4),mass5set(:,2),  & 
G1H4(107),G1H4(111),G1H4(110),G1H4(8),G1H4(7),G1H4(10),4)
  call HG1shiftOLR(G1H4(111),4,4)
  call Hloop_UV_W(ntryL,G1H4(75),18,ex4(:),8,G2H2(58),m3h2x2(:,60),heltab2x4(:,:,69))
  call Hotf_5pt_reduction(G2H4(40),RedSet_5(4),mass5set(:,2),  & 
G1H4(12),G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),4)
  call HG1shiftOLR(G1H4(1),4,4)
  call Hloop_SS_S(ntryL,G1H4(78),ex3(:),G1H4(6),m3h1x4(:,10),heltab2x4(:,:,70))
  call Hloop_SS_S(ntryL,G1H4(79),ex3(:),G1H4(9),m3h1x4(:,11),heltab2x4(:,:,71))
  call Hloop_SS_S(ntryL,G1H4(80),ex3(:),G1H4(11),m3h1x4(:,12),heltab2x4(:,:,72))
  call Hotf_5pt_reduction(G2H4(41),RedSet_5(5),mass5set(:,2),  & 
G1H4(14),G1H4(13),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
  call HG1shiftOLR(G1H4(13),8,4)
  call Hloop_ST_V(ntryL,G1H4(81),17,ex3(:),4,G2H4(14),m3h1x4(:,13),heltab2x4(:,:,73))
  call Hloop_ST_V(ntryL,G1H4(82),17,ex3(:),4,G2H4(15),m3h1x4(:,14),heltab2x4(:,:,74))
  call Hloop_VT_S(ntryL,G1H4(83),17,ex3(:),4,G2H4(13),m3h1x4(:,15),heltab2x4(:,:,75))
  call Hloop_VT_S(ntryL,G1H4(84),17,ex3(:),4,G2H4(16),m3h1x4(:,16),heltab2x4(:,:,76))
  call Hotf_5pt_reduction(G2H4(43),RedSet_5(5),mass5set(:,2),  & 
G1H4(19),G1H4(20),G1H4(29),G1H4(30),G1H4(31),G1H4(32),4)
  call HG1shiftOLR(G1H4(20),8,4)
  call Hotf_5pt_reduction(G2H4(42),RedSet_5(5),mass5set(:,2),  & 
G1H4(33),G1H4(34),G1H4(43),G1H4(44),G1H4(45),G1H4(46),4)
  call HG1shiftOLR(G1H4(34),8,4)
  call Hloop_VS_V(ntryL,G1H4(87),ex3(:),G1H4(47),m3h1x4(:,17),heltab2x4(:,:,77))
  call Hloop_VS_V(ntryL,G1H4(88),ex3(:),G1H4(48),m3h1x4(:,18),heltab2x4(:,:,78))
  call Hotf_5pt_reduction(G2H4(44),RedSet_5(5),mass5set(:,2),  & 
G1H4(57),G1H4(58),G1H4(59),G1H4(60),G1H4(61),G1H4(62),4)
  call HG1shiftOLR(G1H4(58),8,4)
  call Hotf_5pt_reduction(G2H4(45),RedSet_5(6),mass5set(:,3),  & 
G1H4(63),G1H4(66),G1H4(67),G1H4(70),G1H4(71),G1H4(72),4)
  call HG1shiftOLR(G1H4(66),2,4)
  call Hloop_SS_S(ntryL,G1H4(91),ex3(:),G1H4(75),m3h1x4(:,19),heltab2x4(:,:,79))
  call Hotf_5pt_reduction(G2H4(46),RedSet_5(6),mass5set(:,3),  & 
G1H4(78),G1H4(79),G1H4(80),G1H4(81),G1H4(82),G1H4(83),4)
  call HG1shiftOLR(G1H4(79),2,4)
  call Hloop_ST_V(ntryL,G1H4(94),17,ex3(:),4,G2H4(17),m3h1x4(:,20),heltab2x4(:,:,80))
  call Hloop_SS_S(ntryL,G1H4(95),ex3(:),G1H4(84),m3h1x4(:,21),heltab2x4(:,:,81))
  call Hloop_VT_S(ntryL,G1H4(96),17,ex3(:),4,G2H4(21),m3h1x4(:,22),heltab2x4(:,:,82))
  call Hloop_ST_V(ntryL,G1H4(97),17,ex3(:),4,G2H4(18),m3h1x4(:,23),heltab2x4(:,:,83))
  call Hloop_VS_V(ntryL,G1H4(98),ex3(:),G1H4(87),m3h1x4(:,24),heltab2x4(:,:,84))
  call Hloop_VT_S(ntryL,G1H4(99),17,ex3(:),4,G2H4(19),m3h1x4(:,25),heltab2x4(:,:,85))
  call Hloop_VS_V(ntryL,G1H4(100),ex3(:),G1H4(88),m3h1x4(:,26),heltab2x4(:,:,86))
  call Hloop_SV_T(ntryL,G1H4(101),17,ex4(:),8,G2H2(59),m3h2x2(:,61),heltab2x4(:,:,87))
  call Hotf_5pt_reduction(G2H4(47),RedSet_5(7),mass5set(:,2),  & 
G1H4(91),G1H4(94),G1H4(95),G1H4(96),G1H4(97),G1H4(98),4)
  call HG1shiftOLR(G1H4(94),4,4)
  call Hloop_SV_V(ntryL,G1H4(102),ex4(:),G1H2(3),m3h2x2(:,62),heltab2x4(:,:,88))
  call Hloop_VV_S(ntryL,G1H4(103),ex4(:),G1H2(4),m3h2x2(:,63),heltab2x4(:,:,89))
  call Hotf_5pt_reduction(G2H4(49),RedSet_5(7),mass5set(:,2),  & 
G1H4(99),G1H4(100),G1H4(101),G1H4(102),G1H4(103),G1H4(119),4)
  call HG1shiftOLR(G1H4(100),4,4)
  call Hotf_5pt_reduction(G2H4(48),RedSet_5(7),mass5set(:,2),  & 
G1H4(120),G1H4(121),G1H4(122),G1H4(123),G1H4(124),G1H4(125),4)
  call HG1shiftOLR(G1H4(121),4,4)
  call Hloop_UW_V(ntryL,G1H4(106),17,ex4(:),8,G2H2(60),m3h2x2(:,64),heltab2x4(:,:,90))
  call Hotf_5pt_reduction(G2H4(50),RedSet_5(7),mass5set(:,2),  & 
G1H4(106),G1H4(126),G1H4(127),G1H4(128),G1H4(129),G1H4(130),4)
  call HG1shiftOLR(G1H4(126),4,4)
  call Hotf_5pt_reduction(G2H4(51),RedSet_5(8),mass5set(:,3),  & 
G1H4(131),G1H4(132),G1H4(133),G1H4(134),G1H4(135),G1H4(136),4)
  call HG1shiftOLR(G1H4(132),2,4)
  call Hloop_SV_T(ntryL,G1H4(109),17,ex4(:),8,G2H2(61),m3h2x2(:,65),heltab2x4(:,:,91))
  call Hotf_5pt_reduction(G2H4(52),RedSet_5(8),mass5set(:,3),  & 
G1H4(109),G1H4(137),G1H4(138),G1H4(139),G1H4(140),G1H4(141),4)
  call HG1shiftOLR(G1H4(137),2,4)
  call Hloop_SV_V(ntryL,G1H4(112),ex4(:),G1H2(5),m3h2x2(:,66),heltab2x4(:,:,92))
  call Hloop_SV_T(ntryL,G1H4(113),17,ex4(:),8,G2H2(62),m3h2x2(:,67),heltab2x4(:,:,93))
  call Hloop_VV_S(ntryL,G1H4(114),ex4(:),G1H2(6),m3h2x2(:,68),heltab2x4(:,:,94))
  call Hloop_SV_V(ntryL,G1H4(115),ex4(:),G1H2(7),m3h2x2(:,69),heltab2x4(:,:,95))
  call Hloop_UW_V(ntryL,G1H4(116),17,ex4(:),8,G2H2(63),m3h2x2(:,70),heltab2x4(:,:,96))
  call Hloop_VV_S(ntryL,G1H4(117),ex4(:),G1H2(8),m3h2x2(:,71),heltab2x4(:,:,97))
  call Hloop_UW_V(ntryL,G1H4(118),17,ex4(:),8,G2H2(64),m3h2x2(:,72),heltab2x4(:,:,98))
  call Hloop_SQ_A(ntryL,G1H8(22),ex1(:),G1H4(112),ngPbt,m3h2x4(:,191),heltab2x8(:,:,235))
  call Hloop_Q_A(ntryL,G1H4(112),21,nMB,G2H4(22),n2h4(113))
call HGT_raise_alpha_OLR(G1H8(23),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(23),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(23),ex4(:),G1H4(113),m3h2x4(:,192),heltab2x8(:,:,236))
  call Hloop_SQ_A(ntryL,G1H8(25),ex1(:),G1H4(114),ngPbt,m3h2x4(:,193),heltab2x8(:,:,237))
  call Hloop_Q_A(ntryL,G1H4(114),21,nMB,G2H4(23),n2h4(114))
  call Hloop_SQ_A(ntryL,G1H8(26),ex1(:),G1H4(115),ngPbt,m3h2x4(:,194),heltab2x8(:,:,238))
  call Hloop_Q_A(ntryL,G1H4(115),21,nMB,G2H4(20),n2h4(115))
  call Hloop_SQ_A(ntryL,G1H8(27),ex1(:),G1H4(116),ngPbt,m3h2x4(:,195),heltab2x8(:,:,239))
  call Hloop_Q_A(ntryL,G1H4(116),21,nMB,G2H4(24),n2h4(116))
  call Hloop_WQ_A(ntryL,G1H8(28),ex1(:),G1H4(117),m3h2x4(:,196),heltab2x8(:,:,240))
  call Hloop_Q_A(ntryL,G1H4(117),21,nMB,G2H4(25),n2h4(117))
call HGT_OLR(G1H8(29),1,1,8)
call HGT_invQ_OLR(G1H8(29),2,5,8)
  call Hloop_SV_T(ntryL,G1H8(29),-8,ex4(:),8,G2H4(29),m3h2x4(:,197),heltab2x8(:,:,241))
  call Hloop_WQ_A(ntryL,G1H8(30),ex1(:),G1H4(118),m3h2x4(:,198),heltab2x8(:,:,242))
  call Hloop_Q_A(ntryL,G1H4(118),21,nMB,G2H4(26),n2h4(118))
  call Hloop_WQ_A(ntryL,G1H8(9),ex1(:),G1H4(112),m3h2x4(:,199),heltab2x8(:,:,243))
  call Hloop_Q_A(ntryL,G1H4(112),21,nMB,G2H4(27),n2h4(119))
  call Hloop_WQ_A(ntryL,G1H8(31),ex1(:),G1H4(114),m3h2x4(:,200),heltab2x8(:,:,244))
  call Hloop_Q_A(ntryL,G1H4(114),21,nMB,G2H4(30),n2h4(120))
  call Hloop_SQ_A(ntryL,G1H8(10),ex1(:),G1H4(115),ngPbt,m3h2x4(:,201),heltab2x8(:,:,245))
  call Hloop_Q_A(ntryL,G1H4(115),21,nMB,G2H4(31),n2h4(121))
call HGT_raise_alpha_OLR(G1H8(32),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_UW_V(ntryL,G1H8(32),-8,ex4(:),8,G2H4(28),m3h2x4(:,202),heltab2x8(:,:,246))
  call Hloop_SQ_A(ntryL,G1H8(12),ex1(:),G1H4(116),ngPbt,m3h2x4(:,203),heltab2x8(:,:,247))
  call Hloop_Q_A(ntryL,G1H4(116),21,nMB,G2H4(32),n2h4(122))
  call Hloop_SQ_A(ntryL,G1H8(34),ex1(:),G1H4(117),ngPbt,m3h2x4(:,204),heltab2x8(:,:,248))
  call Hloop_Q_A(ntryL,G1H4(117),21,nMB,G2H4(33),n2h4(123))
  call Hloop_SQ_A(ntryL,G1H8(13),ex1(:),G1H4(118),ngPbt,m3h2x4(:,205),heltab2x8(:,:,249))
  call Hloop_Q_A(ntryL,G1H4(118),21,nMB,G2H4(35),n2h4(124))
  call Hloop_WQ_A(ntryL,G1H8(35),ex1(:),G1H4(112),m3h2x4(:,206),heltab2x8(:,:,250))
  call Hloop_Q_A(ntryL,G1H4(112),21,nMB,G2H4(34),n2h4(125))
call HGT_OLR(G1H8(14),1,1,8)
call HGT_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(14),ex4(:),G1H4(114),m3h2x4(:,207),heltab2x8(:,:,251))
  call Hloop_WQ_A(ntryL,G1H8(37),ex1(:),G1H4(115),m3h2x4(:,208),heltab2x8(:,:,252))
  call Hloop_Q_A(ntryL,G1H4(115),21,nMB,G2H4(36),n2h4(126))
  call Hloop_WQ_A(ntryL,G1H8(38),ex1(:),G1H4(116),m3h2x4(:,209),heltab2x8(:,:,253))
  call Hloop_Q_A(ntryL,G1H4(116),21,nMB,G2H4(37),n2h4(127))
  call Hloop_WQ_A(ntryL,G1H8(39),ex1(:),G1H4(117),m3h2x4(:,210),heltab2x8(:,:,254))
  call Hloop_Q_A(ntryL,G1H4(117),21,nMB,G2H4(39),n2h4(128))
  call Hloop_SA_Q(ntryL,G1H8(40),ex2(:),G1H4(118),ngPtb,m3h2x4(:,211),heltab2x8(:,:,255))
  call Hloop_A_Q(ntryL,G1H4(118),22,nMB,G2H4(38),n2h4(129))
call HGT_raise_alpha_OLR(G1H8(41),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(41),2,5,8)
  call Hloop_VV_S(ntryL,G1H8(41),ex4(:),G1H4(112),m3h2x4(:,212),heltab2x8(:,:,256))
  call Hloop_SA_Q(ntryL,G1H8(43),ex2(:),G1H4(115),ngPtb,m3h2x4(:,213),heltab2x8(:,:,257))
  call Hloop_A_Q(ntryL,G1H4(115),22,nMB,G2H4(40),n2h4(130))
  call Hloop_SA_Q(ntryL,G1H8(44),ex2(:),G1H4(116),ngPtb,m3h2x4(:,214),heltab2x8(:,:,258))
  call Hloop_A_Q(ntryL,G1H4(116),22,nMB,G2H4(41),n2h4(131))
  call Hloop_SA_Q(ntryL,G1H8(45),ex2(:),G1H4(117),ngPtb,m3h2x4(:,215),heltab2x8(:,:,259))
  call Hloop_A_Q(ntryL,G1H4(117),22,nMB,G2H4(43),n2h4(132))
  call Hloop_WA_Q(ntryL,G1H8(46),ex2(:),G1H4(118),m3h2x4(:,216),heltab2x8(:,:,260))
  call Hloop_A_Q(ntryL,G1H4(118),22,nMB,G2H4(42),n2h4(133))
call HGT_OLR(G1H8(47),1,1,8)
call HGT_invQ_OLR(G1H8(47),2,5,8)
  call Hloop_TV_S(ntryL,G1H8(47),-8,ex4(:),8,G2H4(44),m3h2x4(:,217),heltab2x8(:,:,261))
  call Hloop_WA_Q(ntryL,G1H8(49),ex2(:),G1H4(115),m3h2x4(:,218),heltab2x8(:,:,262))
  call Hloop_A_Q(ntryL,G1H4(115),22,nMB,G2H4(45),n2h4(134))
  call Hloop_WA_Q(ntryL,G1H8(50),ex2(:),G1H4(116),m3h2x4(:,219),heltab2x8(:,:,263))
  call Hloop_A_Q(ntryL,G1H4(116),22,nMB,G2H4(46),n2h4(135))
  call Hloop_WA_Q(ntryL,G1H8(51),ex2(:),G1H4(117),m3h2x4(:,220),heltab2x8(:,:,264))
  call Hloop_A_Q(ntryL,G1H4(117),22,nMB,G2H4(47),n2h4(136))
  call Hloop_SA_Q(ntryL,G1H8(52),ex2(:),G1H4(118),ngPtb,m3h2x4(:,221),heltab2x8(:,:,265))
  call Hloop_A_Q(ntryL,G1H4(118),22,nMB,G2H4(49),n2h4(137))
call HGT_raise_alpha_OLR(G1H8(53),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(53),2,5,8)
  call Hloop_UV_W(ntryL,G1H8(53),-8,ex4(:),8,G2H4(48),m3h2x4(:,222),heltab2x8(:,:,266))
  call Hloop_SA_Q(ntryL,G1H8(55),ex2(:),G1H4(115),ngPtb,m3h2x4(:,223),heltab2x8(:,:,267))
  call Hloop_A_Q(ntryL,G1H4(115),22,nMB,G2H4(50),n2h4(138))
  call Hloop_SA_Q(ntryL,G1H8(56),ex2(:),G1H4(116),ngPtb,m3h2x4(:,224),heltab2x8(:,:,268))
  call Hloop_A_Q(ntryL,G1H4(116),22,nMB,G2H4(51),n2h4(139))
  call Hloop_SA_Q(ntryL,G1H8(57),ex2(:),G1H4(117),ngPtb,m3h2x4(:,225),heltab2x8(:,:,269))
  call Hloop_A_Q(ntryL,G1H4(117),22,nMB,G2H4(52),n2h4(140))
  call Hloop_WA_Q(ntryL,G1H8(58),ex2(:),G1H4(118),m3h2x4(:,226),heltab2x8(:,:,270))
  call Hloop_A_Q(ntryL,G1H4(118),22,nMB,G2H4(65),n2h4(141))
call HGT_OLR(G1H8(59),1,1,8)
call HGT_invQ_OLR(G1H8(59),2,5,8)
  call Hloop_SV_V(ntryL,G1H8(59),ex4(:),G1H4(115),m3h2x4(:,227),heltab2x8(:,:,271))
  call Hloop_WA_Q(ntryL,G1H8(61),ex2(:),G1H4(116),m3h2x4(:,228),heltab2x8(:,:,272))
  call Hloop_A_Q(ntryL,G1H4(116),22,nMB,G2H4(66),n2h4(142))
  call Hloop_WA_Q(ntryL,G1H8(62),ex2(:),G1H4(117),m3h2x4(:,229),heltab2x8(:,:,273))
  call Hloop_A_Q(ntryL,G1H4(117),22,nMB,G2H4(67),n2h4(143))
  call Hloop_WA_Q(ntryL,G1H8(63),ex2(:),G1H4(118),m3h2x4(:,230),heltab2x8(:,:,274))
  call Hloop_A_Q(ntryL,G1H4(118),22,nMB,G2H4(68),n2h4(144))
  call Hloop_AS_Q(ntryL,G1H4(26),ex3(:),G1H4(116),ngH,m3h1x4(:,27),heltab2x4(:,:,99))
  call Hloop_A_Q(ntryL,G1H4(116),22,nMB,G2H4(69),n2h4(145))
call HGT_OLR(G1H4(23),1,1,4)
call HGT_invQ_OLR(G1H4(23),2,5,4)
  call Hloop_TV_S(ntryL,G1H4(23),-8,ex4(:),8,G2H2(65),m3h2x2(:,73),heltab2x4(:,:,100))
  call Hloop_AS_Q(ntryL,G1H4(28),ex3(:),G1H4(117),ngH,m3h1x4(:,28),heltab2x4(:,:,101))
  call Hloop_A_Q(ntryL,G1H4(117),22,nMB,G2H4(70),n2h4(147))
  call Hloop_AS_Q(ntryL,G1H4(27),ex3(:),G1H4(118),ngH,m3h1x4(:,29),heltab2x4(:,:,102))
  call Hloop_A_Q(ntryL,G1H4(118),22,nMB,G2H4(71),n2h4(148))
  call Hloop_AS_Q(ntryL,G1H4(36),ex3(:),G1H4(26),ngH,m3h1x4(:,30),heltab2x4(:,:,103))
  call Hloop_A_Q(ntryL,G1H4(26),22,nMB,G2H4(72),n2h4(149))
  call Hloop_AS_Q(ntryL,G1H4(35),ex3(:),G1H4(116),ngH,m3h1x4(:,31),heltab2x4(:,:,104))
  call Hloop_A_Q(ntryL,G1H4(116),22,nMB,G2H4(73),n2h4(150))
call HGT_raise_alpha_OLR(G1H4(39),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(39),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(39),ex4(:),G1H2(9),m3h2x2(:,74),heltab2x4(:,:,105))
  call Hloop_AS_Q(ntryL,G1H4(37),ex3(:),G1H4(23),ngH,m3h1x4(:,32),heltab2x4(:,:,106))
  call Hloop_A_Q(ntryL,G1H4(23),22,nMB,G2H4(74),n2h4(152))
  call Hloop_AS_Q(ntryL,G1H4(38),ex3(:),G1H4(28),ngH,m3h1x4(:,33),heltab2x4(:,:,107))
  call Hloop_A_Q(ntryL,G1H4(28),22,nMB,G2H4(75),n2h4(153))
  call Hloop_AS_Q(ntryL,G1H4(42),ex3(:),G1H4(117),ngH,m3h1x4(:,34),heltab2x4(:,:,108))
  call Hloop_A_Q(ntryL,G1H4(117),22,nMB,G2H4(76),n2h4(154))
  call Hloop_AS_Q(ntryL,G1H4(41),ex3(:),G1H4(27),ngH,m3h1x4(:,35),heltab2x4(:,:,109))
  call Hloop_A_Q(ntryL,G1H4(27),22,nMB,G2H4(77),n2h4(155))
call HGT_OLR(G1H4(50),1,1,4)
call HGT_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(50),ex4(:),G1H2(10),m3h2x2(:,75),heltab2x4(:,:,110))
  call Hloop_AS_Q(ntryL,G1H4(53),ex3(:),G1H4(118),ngH,m3h1x4(:,36),heltab2x4(:,:,111))
  call Hloop_A_Q(ntryL,G1H4(118),22,nMB,G2H4(78),n2h4(157))
  call Hloop_AS_Q(ntryL,G1H4(54),ex3(:),G1H4(36),ngH,m3h1x4(:,37),heltab2x4(:,:,112))
  call Hloop_A_Q(ntryL,G1H4(36),22,nMB,G2H4(79),n2h4(158))
  call Hloop_AS_Q(ntryL,G1H4(51),ex3(:),G1H4(26),ngH,m3h1x4(:,38),heltab2x4(:,:,113))
  call Hloop_A_Q(ntryL,G1H4(26),22,nMB,G2H4(80),n2h4(159))
  call Hloop_AS_Q(ntryL,G1H4(55),ex3(:),G1H4(35),ngH,m3h1x4(:,39),heltab2x4(:,:,114))
  call Hloop_A_Q(ntryL,G1H4(35),22,nMB,G2H4(81),n2h4(160))
call HGT_raise_alpha_OLR(G1H4(65),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(65),2,5,4)
  call Hloop_UV_W(ntryL,G1H4(65),-8,ex4(:),8,G2H2(66),m3h2x2(:,76),heltab2x4(:,:,115))
  call Hloop_AS_Q(ntryL,G1H4(69),ex3(:),G1H4(116),ngH,m3h1x4(:,40),heltab2x4(:,:,116))
  call Hloop_A_Q(ntryL,G1H4(116),22,nMB,G2H4(82),n2h4(162))
  call Hloop_AS_Q(ntryL,G1H4(68),ex3(:),G1H4(39),ngH,m3h1x4(:,41),heltab2x4(:,:,117))
  call Hloop_A_Q(ntryL,G1H4(39),22,nMB,G2H4(83),n2h4(163))
  call Hloop_AS_Q(ntryL,G1H4(74),ex3(:),G1H4(37),ngH,m3h1x4(:,42),heltab2x4(:,:,118))
  call Hloop_A_Q(ntryL,G1H4(37),22,nMB,G2H4(84),n2h4(164))
  call Hloop_AV_Q(ntryL,G1H4(73),ex4(:),G1H2(11),m3h2x2(:,77),heltab2x4(:,:,119))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMB,G2H2(67),n2h2(25))
call HGT_OLR(G1H4(77),1,1,4)
call HGT_invQ_OLR(G1H4(77),2,5,4)
  call Hloop_SS_S(ntryL,G1H4(77),ex3(:),G1H4(23),m3h1x4(:,43),heltab2x4(:,:,120))
  call Hloop_AV_Q(ntryL,G1H4(86),ex4(:),G1H2(11),m3h2x2(:,78),heltab2x4(:,:,121))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMB,G2H2(68),n2h2(26))
  call Hloop_AV_Q(ntryL,G1H4(85),ex4(:),G1H2(11),m3h2x2(:,79),heltab2x4(:,:,122))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMB,G2H2(69),n2h2(27))
  call Hloop_AV_Q(ntryL,G1H4(90),ex4(:),G1H2(11),m3h2x2(:,80),heltab2x4(:,:,123))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMB,G2H2(70),n2h2(28))
  call Hloop_AV_Q(ntryL,G1H4(89),ex4(:),G1H2(11),m3h2x2(:,81),heltab2x4(:,:,124))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMB,G2H2(71),n2h2(29))
call HGT_raise_alpha_OLR(G1H4(93),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(93),2,5,4)
  call Hloop_VT_S(ntryL,G1H4(93),-4,ex3(:),4,G2H4(85),m3h1x4(:,44),heltab2x4(:,:,125))
  call Hloop_AV_Q(ntryL,G1H4(105),ex4(:),G1H2(11),m3h2x2(:,82),heltab2x4(:,:,126))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMB,G2H2(72),n2h2(30))
  call Hloop_AV_Q(ntryL,G1H4(104),ex4(:),G1H2(11),m3h2x2(:,83),heltab2x4(:,:,127))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMB,G2H2(73),n2h2(31))
  call Hloop_AV_Q(ntryL,G1H4(108),ex4(:),G1H2(11),m3h2x2(:,84),heltab2x4(:,:,128))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMB,G2H2(74),n2h2(32))
  call Hloop_AV_Q(ntryL,G1H4(107),ex4(:),G1H2(11),m3h2x2(:,85),heltab2x4(:,:,129))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMB,G2H2(75),n2h2(33))
call HGT_OLR(G1H4(111),1,1,4)
call HGT_invQ_OLR(G1H4(111),2,5,4)
  call Hloop_ST_V(ntryL,G1H4(111),-4,ex3(:),4,G2H4(86),m3h1x4(:,45),heltab2x4(:,:,130))
  call Hloop_AV_Q(ntryL,G1H4(8),ex4(:),G1H2(11),m3h2x2(:,86),heltab2x4(:,:,131))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMB,G2H2(76),n2h2(34))
  call Hloop_AV_Q(ntryL,G1H4(7),ex4(:),G1H2(11),m3h2x2(:,87),heltab2x4(:,:,132))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMB,G2H2(77),n2h2(35))
  call Hloop_AV_Q(ntryL,G1H4(10),ex4(:),G1H2(11),m3h2x2(:,88),heltab2x4(:,:,133))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMB,G2H2(78),n2h2(36))
  call Hloop_AV_Q(ntryL,G1H4(12),ex4(:),G1H2(11),m3h2x2(:,89),heltab2x4(:,:,134))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMB,G2H2(79),n2h2(37))
call HGT_raise_alpha_OLR(G1H4(1),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(1),2,5,4)
  call Hloop_VS_V(ntryL,G1H4(1),ex3(:),G1H4(38),m3h1x4(:,46),heltab2x4(:,:,135))
  call Hloop_AV_Q(ntryL,G1H4(3),ex4(:),G1H2(11),m3h2x2(:,90),heltab2x4(:,:,136))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMB,G2H2(80),n2h2(38))
  call Hloop_AV_Q(ntryL,G1H4(4),ex4(:),G1H2(11),m3h2x2(:,91),heltab2x4(:,:,137))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMB,G2H2(81),n2h2(39))
  call Hloop_AV_Q(ntryL,G1H4(5),ex4(:),G1H2(11),m3h2x2(:,92),heltab2x4(:,:,138))
  call Hloop_A_Q(ntryL,G1H2(11),26,nMB,G2H2(82),n2h2(40))
  call Hloop_QS_A(ntryL,G1H4(14),ex3(:),G1H4(28),ngH,m3h1x4(:,47),heltab2x4(:,:,139))
  call Hloop_Q_A(ntryL,G1H4(28),21,nMB,G2H4(87),n2h4(169))
call HGT_OLR(G1H4(13),1,1,4)
call HGT_invQ_OLR(G1H4(13),2,5,4)
  call Hloop_SV_T(ntryL,G1H4(13),-8,ex4(:),8,G2H2(83),m3h2x2(:,93),heltab2x4(:,:,140))
  call Hloop_QS_A(ntryL,G1H4(16),ex3(:),G1H4(42),ngH,m3h1x4(:,48),heltab2x4(:,:,141))
  call Hloop_Q_A(ntryL,G1H4(42),21,nMB,G2H4(88),n2h4(171))
  call Hloop_QS_A(ntryL,G1H4(17),ex3(:),G1H4(117),ngH,m3h1x4(:,49),heltab2x4(:,:,142))
  call Hloop_Q_A(ntryL,G1H4(117),21,nMB,G2H4(89),n2h4(172))
  call Hloop_QS_A(ntryL,G1H4(18),ex3(:),G1H4(41),ngH,m3h1x4(:,50),heltab2x4(:,:,143))
  call Hloop_Q_A(ntryL,G1H4(41),21,nMB,G2H4(90),n2h4(173))
  call Hloop_QS_A(ntryL,G1H4(19),ex3(:),G1H4(27),ngH,m3h1x4(:,51),heltab2x4(:,:,144))
  call Hloop_Q_A(ntryL,G1H4(27),21,nMB,G2H4(91),n2h4(174))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_VV_S(ntryL,G1H4(20),ex4(:),G1H2(11),m3h2x2(:,94),heltab2x4(:,:,145))
  call Hloop_QS_A(ntryL,G1H4(30),ex3(:),G1H4(50),ngH,m3h1x4(:,52),heltab2x4(:,:,146))
  call Hloop_Q_A(ntryL,G1H4(50),21,nMB,G2H4(92),n2h4(176))
  call Hloop_QS_A(ntryL,G1H4(31),ex3(:),G1H4(53),ngH,m3h1x4(:,53),heltab2x4(:,:,147))
  call Hloop_Q_A(ntryL,G1H4(53),21,nMB,G2H4(93),n2h4(177))
  call Hloop_QS_A(ntryL,G1H4(32),ex3(:),G1H4(118),ngH,m3h1x4(:,54),heltab2x4(:,:,148))
  call Hloop_Q_A(ntryL,G1H4(118),21,nMB,G2H4(94),n2h4(178))
  call Hloop_QS_A(ntryL,G1H4(33),ex3(:),G1H4(54),ngH,m3h1x4(:,55),heltab2x4(:,:,149))
  call Hloop_Q_A(ntryL,G1H4(54),21,nMB,G2H4(95),n2h4(179))
call HGT_OLR(G1H4(34),1,1,4)
call HGT_invQ_OLR(G1H4(34),2,5,4)
  call Hloop_SV_V(ntryL,G1H4(34),ex4(:),G1H2(12),m3h2x2(:,95),heltab2x4(:,:,150))
  call Hloop_QS_A(ntryL,G1H4(44),ex3(:),G1H4(36),ngH,m3h1x4(:,56),heltab2x4(:,:,151))
  call Hloop_Q_A(ntryL,G1H4(36),21,nMB,G2H4(96),n2h4(181))
  call Hloop_QS_A(ntryL,G1H4(45),ex3(:),G1H4(51),ngH,m3h1x4(:,57),heltab2x4(:,:,152))
  call Hloop_Q_A(ntryL,G1H4(51),21,nMB,G2H4(97),n2h4(182))
  call Hloop_QS_A(ntryL,G1H4(46),ex3(:),G1H4(26),ngH,m3h1x4(:,58),heltab2x4(:,:,153))
  call Hloop_Q_A(ntryL,G1H4(26),21,nMB,G2H4(98),n2h4(183))
  call Hloop_QS_A(ntryL,G1H4(57),ex3(:),G1H4(55),ngH,m3h1x4(:,59),heltab2x4(:,:,154))
  call Hloop_Q_A(ntryL,G1H4(55),21,nMB,G2H4(99),n2h4(184))
call HGT_raise_alpha_OLR(G1H4(58),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(58),2,5,4)
  call Hloop_UW_V(ntryL,G1H4(58),-8,ex4(:),8,G2H2(84),m3h2x2(:,96),heltab2x4(:,:,155))
  call Hloop_QS_A(ntryL,G1H4(60),ex3(:),G1H4(35),ngH,m3h1x4(:,60),heltab2x4(:,:,156))
  call Hloop_Q_A(ntryL,G1H4(35),21,nMB,G2H4(100),n2h4(186))
  call Hloop_QS_A(ntryL,G1H4(61),ex3(:),G1H4(65),ngH,m3h1x4(:,61),heltab2x4(:,:,157))
  call Hloop_Q_A(ntryL,G1H4(65),21,nMB,G2H4(101),n2h4(187))
  call Hloop_QS_A(ntryL,G1H4(62),ex3(:),G1H4(69),ngH,m3h1x4(:,62),heltab2x4(:,:,158))
  call Hloop_Q_A(ntryL,G1H4(69),21,nMB,G2H4(102),n2h4(188))
  call Hloop_QS_A(ntryL,G1H4(63),ex3(:),G1H4(116),ngH,m3h1x4(:,63),heltab2x4(:,:,159))
  call Hloop_Q_A(ntryL,G1H4(116),21,nMB,G2H4(103),n2h4(189))
call HGT_OLR(G1H4(66),1,1,4)
call HGT_invQ_OLR(G1H4(66),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(66),ex2(:),G1H2(13),ngPtb,m3h2x2(:,97),heltab2x4(:,:,160))
  call Hloop_QS_A(ntryL,G1H4(70),ex3(:),G1H4(68),ngH,m3h1x4(:,64),heltab2x4(:,:,161))
  call Hloop_Q_A(ntryL,G1H4(68),21,nMB,G2H4(104),n2h4(191))
  call Hloop_QS_A(ntryL,G1H4(71),ex3(:),G1H4(39),ngH,m3h1x4(:,65),heltab2x4(:,:,162))
  call Hloop_Q_A(ntryL,G1H4(39),21,nMB,G2H4(105),n2h4(192))
  call Hloop_QS_A(ntryL,G1H4(72),ex3(:),G1H4(74),ngH,m3h1x4(:,66),heltab2x4(:,:,163))
  call Hloop_Q_A(ntryL,G1H4(74),21,nMB,G2H4(106),n2h4(193))
  call Hloop_QS_A(ntryL,G1H4(78),ex3(:),G1H4(37),ngH,m3h1x4(:,67),heltab2x4(:,:,164))
  call Hloop_Q_A(ntryL,G1H4(37),21,nMB,G2H4(107),n2h4(194))
call HGT_raise_alpha_OLR(G1H4(79),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(79),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(79),ex2(:),G1H2(14),m3h2x2(:,98),heltab2x4(:,:,165))
  call Hloop_QS_A(ntryL,G1H4(81),ex3(:),G1H4(73),ngH,m3h1x4(:,68),heltab2x4(:,:,166))
  call Hloop_Q_A(ntryL,G1H4(73),21,nMB,G2H4(108),n2h4(196))
  call Hloop_QS_A(ntryL,G1H4(82),ex3(:),G1H4(77),ngH,m3h1x4(:,69),heltab2x4(:,:,167))
  call Hloop_Q_A(ntryL,G1H4(77),21,nMB,G2H4(109),n2h4(197))
  call Hloop_QS_A(ntryL,G1H4(83),ex3(:),G1H4(86),ngH,m3h1x4(:,70),heltab2x4(:,:,168))
  call Hloop_Q_A(ntryL,G1H4(86),21,nMB,G2H4(110),n2h4(198))
  call Hloop_QV_A(ntryL,G1H4(91),ex4(:),G1H2(15),m3h2x2(:,99),heltab2x4(:,:,169))
  call Hloop_Q_A(ntryL,G1H2(15),25,nMB,G2H2(85),n2h2(41))
call HGT_OLR(G1H4(94),1,1,4)
call HGT_invQ_OLR(G1H4(94),2,5,4)
  call Hloop_SS_S(ntryL,G1H4(94),ex3(:),G1H4(85),m3h1x4(:,71),heltab2x4(:,:,170))
  call Hloop_QV_A(ntryL,G1H4(96),ex4(:),G1H2(15),m3h2x2(:,100),heltab2x4(:,:,171))
  call Hloop_Q_A(ntryL,G1H2(15),25,nMB,G2H2(86),n2h2(42))
  call Hloop_QV_A(ntryL,G1H4(97),ex4(:),G1H2(15),m3h2x2(:,101),heltab2x4(:,:,172))
  call Hloop_Q_A(ntryL,G1H2(15),25,nMB,G2H2(87),n2h2(43))
  call Hloop_QV_A(ntryL,G1H4(98),ex4(:),G1H2(15),m3h2x2(:,102),heltab2x4(:,:,173))
  call Hloop_Q_A(ntryL,G1H2(15),25,nMB,G2H2(88),n2h2(44))
  call Hloop_QV_A(ntryL,G1H4(99),ex4(:),G1H2(15),m3h2x2(:,103),heltab2x4(:,:,174))
  call Hloop_Q_A(ntryL,G1H2(15),25,nMB,G2H2(89),n2h2(45))
call HGT_raise_alpha_OLR(G1H4(100),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(100),2,5,4)
  call Hloop_VT_S(ntryL,G1H4(100),-4,ex3(:),4,G2H4(111),m3h1x4(:,72),heltab2x4(:,:,175))
  call Hloop_QV_A(ntryL,G1H4(102),ex4(:),G1H2(15),m3h2x2(:,104),heltab2x4(:,:,176))
  call Hloop_Q_A(ntryL,G1H2(15),25,nMB,G2H2(90),n2h2(46))
  call Hloop_QV_A(ntryL,G1H4(103),ex4(:),G1H2(15),m3h2x2(:,105),heltab2x4(:,:,177))
  call Hloop_Q_A(ntryL,G1H2(15),25,nMB,G2H2(91),n2h2(47))
  call Hloop_QV_A(ntryL,G1H4(119),ex4(:),G1H2(15),m3h2x2(:,106),heltab2x4(:,:,178))
  call Hloop_Q_A(ntryL,G1H2(15),25,nMB,G2H2(92),n2h2(48))
  call Hloop_QV_A(ntryL,G1H4(120),ex4(:),G1H2(15),m3h2x2(:,107),heltab2x4(:,:,179))
  call Hloop_Q_A(ntryL,G1H2(15),25,nMB,G2H2(93),n2h2(49))
call HGT_OLR(G1H4(121),1,1,4)
call HGT_invQ_OLR(G1H4(121),2,5,4)
  call Hloop_ST_V(ntryL,G1H4(121),-4,ex3(:),4,G2H4(112),m3h1x4(:,73),heltab2x4(:,:,180))
  call Hloop_QV_A(ntryL,G1H4(123),ex4(:),G1H2(15),m3h2x2(:,108),heltab2x4(:,:,181))
  call Hloop_Q_A(ntryL,G1H2(15),25,nMB,G2H2(94),n2h2(50))
  call Hloop_QV_A(ntryL,G1H4(124),ex4(:),G1H2(15),m3h2x2(:,109),heltab2x4(:,:,182))
  call Hloop_Q_A(ntryL,G1H2(15),25,nMB,G2H2(95),n2h2(51))
  call Hloop_QV_A(ntryL,G1H4(125),ex4(:),G1H2(15),m3h2x2(:,110),heltab2x4(:,:,183))
  call Hloop_Q_A(ntryL,G1H2(15),25,nMB,G2H2(96),n2h2(52))
  call Hloop_QV_A(ntryL,G1H4(106),ex4(:),G1H2(15),m3h2x2(:,111),heltab2x4(:,:,184))
  call Hloop_Q_A(ntryL,G1H2(15),25,nMB,G2H2(97),n2h2(53))
call HGT_raise_alpha_OLR(G1H4(126),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(126),2,5,4)
  call Hloop_VS_V(ntryL,G1H4(126),ex3(:),G1H4(90),m3h1x4(:,74),heltab2x4(:,:,185))
  call Hloop_QV_A(ntryL,G1H4(128),ex4(:),G1H2(15),m3h2x2(:,112),heltab2x4(:,:,186))
  call Hloop_Q_A(ntryL,G1H2(15),25,nMB,G2H2(98),n2h2(54))
  call Hloop_QV_A(ntryL,G1H4(129),ex4(:),G1H2(15),m3h2x2(:,113),heltab2x4(:,:,187))
  call Hloop_Q_A(ntryL,G1H2(15),25,nMB,G2H2(99),n2h2(55))
  call Hloop_QV_A(ntryL,G1H4(130),ex4(:),G1H2(15),m3h2x2(:,114),heltab2x4(:,:,188))
  call Hloop_Q_A(ntryL,G1H2(15),25,nMB,G2H2(100),n2h2(56))
  call Hloop_QV_A(ntryL,G1H4(131),ex4(:),G1H2(15),m3h2x2(:,115),heltab2x4(:,:,189))
  call Hloop_Q_A(ntryL,G1H2(15),25,nMB,G2H2(101),n2h2(57))
call HGT_OLR(G1H4(132),1,1,4)
call HGT_invQ_OLR(G1H4(132),2,5,4)
  call Hloop_SA_Q(ntryL,G1H4(132),ex2(:),G1H2(15),ngPtb,m3h2x2(:,116),heltab2x4(:,:,190))
  call Hloop_QV_A(ntryL,G1H4(134),ex4(:),G1H2(16),m3h2x2(:,117),heltab2x4(:,:,191))
  call Hloop_Q_A(ntryL,G1H2(16),25,nMB,G2H2(102),n2h2(58))
  call Hloop_QV_A(ntryL,G1H4(135),ex4(:),G1H2(16),m3h2x2(:,118),heltab2x4(:,:,192))
  call Hloop_Q_A(ntryL,G1H2(16),25,nMB,G2H2(103),n2h2(59))
  call Hloop_QV_A(ntryL,G1H4(136),ex4(:),G1H2(16),m3h2x2(:,119),heltab2x4(:,:,193))
  call Hloop_Q_A(ntryL,G1H2(16),25,nMB,G2H2(104),n2h2(60))
  call Hloop_QV_A(ntryL,G1H4(109),ex4(:),G1H2(16),m3h2x2(:,120),heltab2x4(:,:,194))
  call Hloop_Q_A(ntryL,G1H2(16),25,nMB,G2H2(105),n2h2(61))
call HGT_raise_alpha_OLR(G1H4(137),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(137),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(137),ex2(:),G1H2(16),m3h2x2(:,121),heltab2x4(:,:,195))
  call Hloop_QV_A(ntryL,G1H4(139),ex4(:),G1H2(17),m3h2x2(:,122),heltab2x4(:,:,196))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMB,G2H2(106),n2h2(62))
  call Hloop_QV_A(ntryL,G1H4(140),ex4(:),G1H2(17),m3h2x2(:,123),heltab2x4(:,:,197))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMB,G2H2(107),n2h2(63))
  call Hloop_QV_A(ntryL,G1H4(141),ex4(:),G1H2(17),m3h2x2(:,124),heltab2x4(:,:,198))
  call Hloop_Q_A(ntryL,G1H2(17),25,nMB,G2H2(108),n2h2(64))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(25),[G2H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(34),[G2H4(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(22),[G2H4(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(31),[G2H4(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G2H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G2H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(42),[G2H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(65),[G2H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(38),[G2H4(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(49),[G2H4(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G2H2(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(21),[G2H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(34),[G2H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(35),[G2H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(48),[G2H2(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(49),[G2H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(10),[G1H4(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(11),[G1H4(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(57),[G1H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(58),[G1H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G1H4(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G1H4(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(21),[G1H4(75)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(17),[G1H4(87)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(19),[G1H4(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G1H4(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(59),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(60),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(61),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(63),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(62),[G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(64),[G1H2(7)])
  call Hotf_5pt_reduction(G2H4(53),RedSet_5(1),mass5set(:,4),  & 
G1H4(89),G1H4(93),G1H4(105),G1H4(104),G1H4(108),G1H4(107),4)
  call HG1shiftOLR(G1H4(93),8,4)
  call Hotf_5pt_reduction(G2H4(54),RedSet_5(1),mass5set(:,5),  & 
G1H4(111),G1H4(8),G1H4(7),G1H4(10),G1H4(12),G1H4(1),4)
  call HG1shiftOLR(G1H4(8),8,4)
  call Hotf_5pt_reduction(G2H4(55),RedSet_5(1),mass5set(:,6),  & 
G1H4(3),G1H4(4),G1H4(5),G1H4(14),G1H4(28),G1H4(13),4)
  call HG1shiftOLR(G1H4(4),8,4)
  call Hloop_QA_S(ntryL,G2H4(25),ex2(:),G2H2(2),ngPtb,m3h2x2(:,125),heltab2x4(:,:,199))
  call Hotf_5pt_reduction(G2H4(57),RedSet_5(1),mass5set(:,7),  & 
G1H4(16),G1H4(42),G1H4(17),G1H4(117),G1H4(18),G1H4(41),4)
  call HG1shiftOLR(G1H4(42),8,4)
  call Hotf_5pt_reduction(G2H4(58),RedSet_5(1),mass5set(:,5),  & 
G1H4(19),G1H4(27),G1H4(20),G1H4(30),G1H4(50),G1H4(31),4)
  call HG1shiftOLR(G1H4(27),8,4)
  call Hotf_5pt_reduction(G2H4(59),RedSet_5(1),mass5set(:,6),  & 
G1H4(53),G1H4(32),G1H4(118),G1H4(33),G1H4(54),G1H4(34),4)
  call HG1shiftOLR(G1H4(32),8,4)
  call Hloop_QA_W(ntryL,G2H4(34),ex2(:),G2H2(3),m3h2x2(:,126),heltab2x4(:,:,200))
  call Hloop_QA_S(ntryL,G2H4(22),ex2(:),G2H2(16),ngPtb,m3h2x2(:,127),heltab2x4(:,:,201))
  call Hloop_QA_W(ntryL,G2H4(31),ex2(:),G2H2(17),m3h2x2(:,128),heltab2x4(:,:,202))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(9),mass5set(:,8),  & 
G1H2(17),G1H2(1),G1H2(2),G1H2(4),G1H2(3),G1H2(6),2)
  call HG1shiftOLR(G1H2(1),8,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(9),mass5set(:,9),  & 
G1H2(5),G1H2(8),G1H2(7),G1H2(18),G1H2(19),G1H2(20),2)
  call HG1shiftOLR(G1H2(8),8,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(9),mass5set(:,10),  & 
G1H2(21),G1H2(22),G1H2(23),G1H2(24),G1H2(25),G1H2(26),2)
  call HG1shiftOLR(G1H2(22),8,2)
  call Hloop_SS_S(ntryL,G2H2(4),ex3(:),G2H2(30),m3h1x2(:,1),heltab2x2(:,:,1))
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(9),mass5set(:,11),  & 
G1H2(27),G1H2(28),G1H2(29),G1H2(30),G1H2(31),G1H2(32),2)
  call HG1shiftOLR(G1H2(28),8,2)
  call Hloop_SS_S(ntryL,G2H2(8),ex3(:),G2H2(31),m3h1x2(:,2),heltab2x2(:,:,2))
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(9),mass5set(:,12),  & 
G1H2(33),G1H2(34),G1H2(35),G1H2(36),G1H2(37),G1H2(38),2)
  call HG1shiftOLR(G1H2(34),8,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(9),mass5set(:,12),  & 
G1H2(39),G1H2(40),G1H2(41),G1H2(42),G1H2(43),G1H2(44),2)
  call HG1shiftOLR(G1H2(40),8,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(9),mass5set(:,12),  & 
G1H2(45),G1H2(46),G1H2(47),G1H2(48),G1H2(49),G1H2(50),2)
  call HG1shiftOLR(G1H2(46),8,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(9),mass5set(:,12),  & 
G1H2(51),G1H2(52),G1H2(53),G1H2(54),G1H2(55),G1H2(56),2)
  call HG1shiftOLR(G1H2(52),8,2)
  call Hloop_VS_V(ntryL,G2H2(13),ex3(:),G2H2(44),m3h1x2(:,3),heltab2x2(:,:,3))
  call Hloop_VS_V(ntryL,G2H2(14),ex3(:),G2H2(45),m3h1x2(:,4),heltab2x2(:,:,4))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(2),mass5set(:,4),  & 
G1H4(44),G1H4(36),G1H4(45),G1H4(51),G1H4(46),G1H4(26),4)
  call HG1shiftOLR(G1H4(36),8,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(2),mass5set(:,5),  & 
G1H4(57),G1H4(55),G1H4(58),G1H4(60),G1H4(35),G1H4(61),4)
  call HG1shiftOLR(G1H4(55),8,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(2),mass5set(:,6),  & 
G1H4(65),G1H4(62),G1H4(69),G1H4(63),G1H4(116),G1H4(66),4)
  call HG1shiftOLR(G1H4(62),8,4)
  call Hloop_AQ_S(ntryL,G2H4(42),ex1(:),G2H2(1),ngPbt,m3h2x2(:,129),heltab2x4(:,:,203))
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(2),mass5set(:,7),  & 
G1H4(70),G1H4(68),G1H4(71),G1H4(39),G1H4(72),G1H4(74),4)
  call HG1shiftOLR(G1H4(68),8,4)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(2),mass5set(:,5),  & 
G1H4(78),G1H4(37),G1H4(79),G1H4(81),G1H4(73),G1H4(82),4)
  call HG1shiftOLR(G1H4(37),8,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(2),mass5set(:,6),  & 
G1H4(77),G1H4(83),G1H4(86),G1H4(91),G1H4(94),G1H4(96),4)
  call HG1shiftOLR(G1H4(83),8,4)
  call Hloop_AQ_W(ntryL,G2H4(65),ex1(:),G2H2(6),m3h2x2(:,130),heltab2x4(:,:,204))
  call Hloop_AQ_S(ntryL,G2H4(38),ex1(:),G2H2(7),ngPbt,m3h2x2(:,131),heltab2x4(:,:,205))
  call Hloop_AQ_W(ntryL,G2H4(49),ex1(:),G2H2(4),m3h2x2(:,132),heltab2x4(:,:,206))
  call Hotf_5pt_reduction(G2H2(15),RedSet_5(10),mass5set(:,8),  & 
G1H2(57),G1H2(58),G1H2(59),G1H2(60),G1H2(61),G1H2(62),2)
  call HG1shiftOLR(G1H2(58),4,2)
  call Hotf_5pt_reduction(G2H2(20),RedSet_5(10),mass5set(:,9),  & 
G1H2(63),G1H2(64),G1H2(65),G1H2(66),G1H2(67),G1H2(68),2)
  call HG1shiftOLR(G1H2(64),4,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(10),mass5set(:,10),  & 
G1H2(69),G1H2(70),G1H2(71),G1H2(72),G1H2(73),G1H2(74),2)
  call HG1shiftOLR(G1H2(70),4,2)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(10),mass5set(:,12),  & 
G1H2(75),G1H2(76),G1H2(77),G1H2(78),G1H2(79),G1H2(80),2)
  call HG1shiftOLR(G1H2(76),4,2)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(10),mass5set(:,11),  & 
G1H2(81),G1H2(82),G1H2(83),G1H2(84),G1H2(85),G1H2(86),2)
  call HG1shiftOLR(G1H2(82),4,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(10),mass5set(:,12),  & 
G1H2(87),G1H2(88),G1H2(89),G1H2(90),G1H2(91),G1H2(92),2)
  call HG1shiftOLR(G1H2(88),4,2)
  call Hloop_SV_V(ntryL,G2H2(23),ex4(:),G2H1(1),m3h2x1(:,1),heltab2x2(:,:,5))
  call Hloop_VV_S(ntryL,G2H2(24),ex4(:),G2H1(2),m3h2x1(:,2),heltab2x2(:,:,6))
  call Hloop_SV_V(ntryL,G2H2(25),ex4(:),G2H1(3),m3h2x1(:,3),heltab2x2(:,:,7))
  call Hloop_VV_S(ntryL,G2H2(26),ex4(:),G2H1(4),m3h2x1(:,4),heltab2x2(:,:,8))
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(10),mass5set(:,12),  & 
G1H2(93),G1H2(94),G1H2(95),G1H2(96),G1H2(97),G1H2(98),2)
  call HG1shiftOLR(G1H2(94),4,2)
  call Hotf_5pt_reduction(G2H2(28),RedSet_5(10),mass5set(:,12),  & 
G1H2(99),G1H2(100),G1H2(101),G1H2(102),G1H2(103),G1H2(104),2)
  call HG1shiftOLR(G1H2(100),4,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(11),mass5set(:,8),  & 
G1H2(105),G1H2(106),G1H2(107),G1H2(108),G1H2(109),G1H2(110),2)
  call HG1shiftOLR(G1H2(106),8,2)
  call Hotf_5pt_reduction(G2H2(34),RedSet_5(11),mass5set(:,9),  & 
G1H2(111),G1H2(112),G1H2(113),G1H2(114),G1H2(115),G1H2(116),2)
  call HG1shiftOLR(G1H2(112),8,2)
  call Hotf_5pt_reduction(G2H2(35),RedSet_5(11),mass5set(:,10),  & 
G1H2(117),G1H2(118),G1H2(119),G1H2(120),G1H2(121),G1H2(122),2)
  call HG1shiftOLR(G1H2(118),8,2)
  call Hloop_SS_S(ntryL,G2H2(32),ex3(:),G2H2(5),m3h1x2(:,5),heltab2x2(:,:,9))
  call Hotf_5pt_reduction(G2H2(33),RedSet_5(11),mass5set(:,11),  & 
G1H2(123),G1H2(124),G1H2(125),G1H2(126),G1H2(127),G1H2(128),2)
  call HG1shiftOLR(G1H2(124),8,2)
  call Hloop_SS_S(ntryL,G2H2(36),ex3(:),G2H2(8),m3h1x2(:,6),heltab2x2(:,:,10))
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(11),mass5set(:,12),  & 
G1H2(129),G1H2(130),G1H2(131),G1H2(132),G1H2(133),G1H2(134),2)
  call HG1shiftOLR(G1H2(130),8,2)
  call Hotf_5pt_reduction(G2H2(38),RedSet_5(11),mass5set(:,12),  & 
G1H2(135),G1H2(136),G1H2(137),G1H2(138),G1H2(139),G1H2(140),2)
  call HG1shiftOLR(G1H2(136),8,2)
  call Hotf_5pt_reduction(G2H2(39),RedSet_5(11),mass5set(:,12),  & 
G1H2(141),G1H2(142),G1H2(143),G1H2(144),G1H2(145),G1H2(146),2)
  call HG1shiftOLR(G1H2(142),8,2)
  call Hotf_5pt_reduction(G2H2(40),RedSet_5(11),mass5set(:,12),  & 
G1H2(147),G1H2(148),G1H2(149),G1H2(150),G1H2(151),G1H2(152),2)
  call HG1shiftOLR(G1H2(148),8,2)
  call Hloop_VS_V(ntryL,G2H2(41),ex3(:),G2H2(9),m3h1x2(:,7),heltab2x2(:,:,11))
  call Hloop_VS_V(ntryL,G2H2(42),ex3(:),G2H2(10),m3h1x2(:,8),heltab2x2(:,:,12))
  call Hotf_5pt_reduction(G2H2(43),RedSet_5(12),mass5set(:,8),  & 
G1H2(153),G1H2(154),G1H2(155),G1H2(156),G1H2(157),G1H2(158),2)
  call HG1shiftOLR(G1H2(154),4,2)
  call Hotf_5pt_reduction(G2H2(48),RedSet_5(12),mass5set(:,9),  & 
G1H2(159),G1H2(160),G1H2(161),G1H2(162),G1H2(163),G1H2(164),2)
  call HG1shiftOLR(G1H2(160),4,2)
  call Hotf_5pt_reduction(G2H2(49),RedSet_5(12),mass5set(:,10),  & 
G1H2(165),G1H2(166),G1H2(167),G1H2(168),G1H2(169),G1H2(170),2)
  call HG1shiftOLR(G1H2(166),4,2)
  call Hotf_5pt_reduction(G2H2(46),RedSet_5(12),mass5set(:,12),  & 
G1H2(171),G1H2(172),G1H2(173),G1H2(174),G1H2(175),G1H2(176),2)
  call HG1shiftOLR(G1H2(172),4,2)
  call Hotf_5pt_reduction(G2H2(47),RedSet_5(12),mass5set(:,11),  & 
G1H2(177),G1H2(178),G1H2(179),G1H2(180),G1H2(181),G1H2(182),2)
  call HG1shiftOLR(G1H2(178),4,2)
  call Hotf_5pt_reduction(G2H2(50),RedSet_5(12),mass5set(:,12),  & 
G1H2(183),G1H2(184),G1H2(185),G1H2(186),G1H2(187),G1H2(188),2)
  call HG1shiftOLR(G1H2(184),4,2)
  call Hloop_SV_V(ntryL,G2H2(51),ex4(:),G2H1(5),m3h2x1(:,5),heltab2x2(:,:,13))
  call Hloop_VV_S(ntryL,G2H2(52),ex4(:),G2H1(6),m3h2x1(:,6),heltab2x2(:,:,14))
  call Hloop_SV_V(ntryL,G2H2(53),ex4(:),G2H1(7),m3h2x1(:,7),heltab2x2(:,:,15))
  call Hloop_VV_S(ntryL,G2H2(54),ex4(:),G2H1(8),m3h2x1(:,8),heltab2x2(:,:,16))
  call Hotf_5pt_reduction(G2H2(55),RedSet_5(12),mass5set(:,12),  & 
G1H2(189),G1H2(190),G1H2(191),G1H2(192),G1H2(193),G1H2(194),2)
  call HG1shiftOLR(G1H2(190),4,2)
  call Hotf_5pt_reduction(G2H2(56),RedSet_5(12),mass5set(:,12),  & 
G1H2(195),G1H2(196),G1H2(197),G1H2(198),G1H2(199),G1H2(200),2)
  call HG1shiftOLR(G1H2(196),4,2)
  call Hloop_SQ_A(ntryL,G1H4(22),ex1(:),G1H2(201),ngH,m3h2x2(:,133),heltab2x4(:,:,207))
  call Hloop_Q_A(ntryL,G1H2(201),23,nMT,G2H2(11),n2h2(65))
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(3),mass5set(:,13),  & 
G1H4(97),G1H4(98),G1H4(99),G1H4(100),G1H4(102),G1H4(103),4)
  call HG1shiftOLR(G1H4(98),8,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(3),mass5set(:,14),  & 
G1H4(119),G1H4(120),G1H4(121),G1H4(123),G1H4(124),G1H4(125),4)
  call HG1shiftOLR(G1H4(120),8,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(3),mass5set(:,13),  & 
G1H4(106),G1H4(126),G1H4(128),G1H4(129),G1H4(130),G1H4(131),4)
  call HG1shiftOLR(G1H4(126),8,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(3),mass5set(:,14),  & 
G1H4(132),G1H4(134),G1H4(135),G1H4(136),G1H4(109),G1H4(137),4)
  call HG1shiftOLR(G1H4(134),8,4)
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(4),mass5set(:,14),  & 
G1H2(201),G1H2(202),G1H2(203),G1H2(204),G1H2(205),G1H2(206),2)
  call HG1shiftOLR(G1H2(202),4,2)
  call Hotf_5pt_reduction(G2H2(58),RedSet_5(4),mass5set(:,14),  & 
G1H2(207),G1H2(208),G1H2(209),G1H2(210),G1H2(211),G1H2(212),2)
  call HG1shiftOLR(G1H2(208),4,2)
  call Hloop_SA_Q(ntryL,G1H4(6),ex2(:),G1H2(213),ngH,m3h2x2(:,134),heltab2x4(:,:,208))
  call Hloop_A_Q(ntryL,G1H2(213),23,nMT,G2H2(12),n2h2(66))
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(5),mass5set(:,13),  & 
G1H4(139),G1H4(140),G1H4(141),G1H4(21),G1H4(24),G1H4(52),4)
  call HG1shiftOLR(G1H4(140),8,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(5),mass5set(:,14),  & 
G1H4(56),G1H4(9),G1H4(11),G1H4(47),G1H4(48),G1H4(75),4)
  call HG1shiftOLR(G1H4(9),8,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(5),mass5set(:,13),  & 
G1H4(87),G1H4(84),G1H4(88),G1H4(22),G1H4(6),G1H4(142),4)
  call HG1shiftOLR(G1H4(84),8,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(5),mass5set(:,14),  & 
G1H4(143),G1H4(144),G1H4(145),G1H4(146),G1H4(147),G1H4(148),4)
  call HG1shiftOLR(G1H4(144),8,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(6),mass5set(:,15),  & 
G1H4(149),G1H4(150),G1H4(151),G1H4(152),G1H4(153),G1H4(154),4)
  call HG1shiftOLR(G1H4(150),2,4)
  call Hloop_VV_S(ntryL,G2H4(17),ex4(:),G2H2(13),m3h2x2(:,135),heltab2x4(:,:,209))
  call Hloop_SV_V(ntryL,G2H4(19),ex4(:),G2H2(14),m3h2x2(:,136),heltab2x4(:,:,210))
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(6),mass5set(:,15),  & 
G1H4(155),G1H4(156),G1H4(157),G1H4(158),G1H4(159),G1H4(160),4)
  call HG1shiftOLR(G1H4(156),2,4)
  call Hotf_5pt_reduction(G2H2(59),RedSet_5(7),mass5set(:,14),  & 
G1H2(213),G1H2(214),G1H2(215),G1H2(216),G1H2(217),G1H2(218),2)
  call HG1shiftOLR(G1H2(214),4,2)
  call Hotf_5pt_reduction(G2H2(60),RedSet_5(7),mass5set(:,14),  & 
G1H2(219),G1H2(220),G1H2(221),G1H2(222),G1H2(223),G1H2(224),2)
  call HG1shiftOLR(G1H2(220),4,2)
  call Hloop_SS_S(ntryL,G2H2(61),ex3(:),G2H2(15),m3h1x2(:,9),heltab2x2(:,:,17))
  call Hotf_5pt_reduction(G2H2(63),RedSet_5(8),mass5set(:,15),  & 
G1H2(225),G1H2(226),G1H2(227),G1H2(228),G1H2(229),G1H2(230),2)
  call HG1shiftOLR(G1H2(226),2,2)
  call Hotf_5pt_reduction(G2H2(62),RedSet_5(8),mass5set(:,15),  & 
G1H2(231),G1H2(232),G1H2(233),G1H2(234),G1H2(235),G1H2(236),2)
  call HG1shiftOLR(G1H2(232),2,2)
  call Hloop_VS_V(ntryL,G2H2(64),ex3(:),G2H2(20),m3h1x2(:,10),heltab2x2(:,:,18))
  call Hloop_QA_S(ntryL,G2H4(20),ex2(:),G2H2(21),ngPtb,m3h2x2(:,137),heltab2x4(:,:,211))
  call Hloop_QA_S(ntryL,G2H4(24),ex2(:),G2H2(18),ngPtb,m3h2x2(:,138),heltab2x4(:,:,212))
  call Hloop_QA_S(ntryL,G2H4(27),ex2(:),G2H2(19),ngPtb,m3h2x2(:,139),heltab2x4(:,:,213))
  call Hloop_QA_S(ntryL,G2H4(30),ex2(:),G2H2(22),ngPtb,m3h2x2(:,140),heltab2x4(:,:,214))
  call Hloop_QA_W(ntryL,G2H4(33),ex2(:),G2H2(23),m3h2x2(:,141),heltab2x4(:,:,215))
  call Hloop_QA_W(ntryL,G2H4(35),ex2(:),G2H2(24),m3h2x2(:,142),heltab2x4(:,:,216))
  call Hloop_QA_W(ntryL,G2H4(37),ex2(:),G2H2(25),m3h2x2(:,143),heltab2x4(:,:,217))
  call Hloop_QA_W(ntryL,G2H4(39),ex2(:),G2H2(26),m3h2x2(:,144),heltab2x4(:,:,218))
  call Hloop_AQ_S(ntryL,G2H4(41),ex1(:),G2H2(27),ngPbt,m3h2x2(:,145),heltab2x4(:,:,219))
  call Hloop_AQ_S(ntryL,G2H4(43),ex1(:),G2H2(28),ngPbt,m3h2x2(:,146),heltab2x4(:,:,220))
  call Hloop_AQ_S(ntryL,G2H4(46),ex1(:),G2H2(29),ngPbt,m3h2x2(:,147),heltab2x4(:,:,221))
  call Hloop_AQ_S(ntryL,G2H4(47),ex1(:),G2H2(34),ngPbt,m3h2x2(:,148),heltab2x4(:,:,222))
  call Hloop_AQ_W(ntryL,G2H4(51),ex1(:),G2H2(35),m3h2x2(:,149),heltab2x4(:,:,223))
  call Hloop_AQ_W(ntryL,G2H4(52),ex1(:),G2H2(32),m3h2x2(:,150),heltab2x4(:,:,224))
  call Hloop_AQ_W(ntryL,G2H4(67),ex1(:),G2H2(33),m3h2x2(:,151),heltab2x4(:,:,225))
  call Hloop_AQ_W(ntryL,G2H4(68),ex1(:),G2H2(36),m3h2x2(:,152),heltab2x4(:,:,226))
  call Hloop_AQ_S(ntryL,G2H4(69),ex1(:),G2H2(37),ngPbt,m3h2x2(:,153),heltab2x4(:,:,227))
  call Hloop_AQ_S(ntryL,G2H4(71),ex1(:),G2H2(38),ngPbt,m3h2x2(:,154),heltab2x4(:,:,228))
  call Hloop_AQ_S(ntryL,G2H4(72),ex1(:),G2H2(39),ngPbt,m3h2x2(:,155),heltab2x4(:,:,229))
  call Hloop_AQ_S(ntryL,G2H4(73),ex1(:),G2H2(40),ngPbt,m3h2x2(:,156),heltab2x4(:,:,230))
  call Hloop_AQ_S(ntryL,G2H4(75),ex1(:),G2H2(41),ngPbt,m3h2x2(:,157),heltab2x4(:,:,231))
  call Hloop_AQ_S(ntryL,G2H4(76),ex1(:),G2H2(42),ngPbt,m3h2x2(:,158),heltab2x4(:,:,232))
  call Hloop_AQ_W(ntryL,G2H4(77),ex1(:),G2H2(43),m3h2x2(:,159),heltab2x4(:,:,233))
  call Hloop_AQ_W(ntryL,G2H4(79),ex1(:),G2H2(48),m3h2x2(:,160),heltab2x4(:,:,234))
  call Hloop_AQ_W(ntryL,G2H4(80),ex1(:),G2H2(49),m3h2x2(:,161),heltab2x4(:,:,235))
  call Hloop_AQ_W(ntryL,G2H4(81),ex1(:),G2H2(46),m3h2x2(:,162),heltab2x4(:,:,236))
  call Hloop_AQ_W(ntryL,G2H4(83),ex1(:),G2H2(47),m3h2x2(:,163),heltab2x4(:,:,237))
  call Hloop_AQ_W(ntryL,G2H4(84),ex1(:),G2H2(50),m3h2x2(:,164),heltab2x4(:,:,238))
  call Hloop_AQ_S(ntryL,G2H2(67),ex1(:),G2H1(9),ngPbt,m3h2x1(:,9),heltab2x2(:,:,19))
  call Hloop_AQ_S(ntryL,G2H2(69),ex1(:),G2H1(10),ngPbt,m3h2x1(:,10),heltab2x2(:,:,20))
  call Hloop_AQ_S(ntryL,G2H2(70),ex1(:),G2H1(11),ngPbt,m3h2x1(:,11),heltab2x2(:,:,21))
  call Hloop_AQ_S(ntryL,G2H2(71),ex1(:),G2H1(12),ngPbt,m3h2x1(:,12),heltab2x2(:,:,22))
  call Hloop_AQ_S(ntryL,G2H2(73),ex1(:),G2H1(13),ngPbt,m3h2x1(:,13),heltab2x2(:,:,23))
  call Hloop_AQ_S(ntryL,G2H2(74),ex1(:),G2H1(14),ngPbt,m3h2x1(:,14),heltab2x2(:,:,24))
  call Hloop_AQ_W(ntryL,G2H2(75),ex1(:),G2H1(15),m3h2x1(:,15),heltab2x2(:,:,25))
  call Hloop_AQ_W(ntryL,G2H2(77),ex1(:),G2H1(16),m3h2x1(:,16),heltab2x2(:,:,26))
  call Hloop_AQ_W(ntryL,G2H2(78),ex1(:),G2H1(17),m3h2x1(:,17),heltab2x2(:,:,27))
  call Hloop_AQ_W(ntryL,G2H2(79),ex1(:),G2H1(18),m3h2x1(:,18),heltab2x2(:,:,28))
  call Hloop_AQ_W(ntryL,G2H2(81),ex1(:),G2H1(19),m3h2x1(:,19),heltab2x2(:,:,29))
  call Hloop_AQ_W(ntryL,G2H2(82),ex1(:),G2H1(20),m3h2x1(:,20),heltab2x2(:,:,30))
  call Hloop_QA_S(ntryL,G2H4(87),ex2(:),G2H2(51),ngPtb,m3h2x2(:,165),heltab2x4(:,:,239))
  call Hloop_QA_S(ntryL,G2H4(89),ex2(:),G2H2(52),ngPtb,m3h2x2(:,166),heltab2x4(:,:,240))
  call Hloop_QA_S(ntryL,G2H4(90),ex2(:),G2H2(53),ngPtb,m3h2x2(:,167),heltab2x4(:,:,241))
  call Hloop_QA_S(ntryL,G2H4(91),ex2(:),G2H2(54),ngPtb,m3h2x2(:,168),heltab2x4(:,:,242))
  call Hloop_QA_S(ntryL,G2H4(93),ex2(:),G2H2(55),ngPtb,m3h2x2(:,169),heltab2x4(:,:,243))
  call Hloop_QA_S(ntryL,G2H4(94),ex2(:),G2H2(56),ngPtb,m3h2x2(:,170),heltab2x4(:,:,244))
  call Hloop_QA_W(ntryL,G2H4(95),ex2(:),G2H2(57),m3h2x2(:,171),heltab2x4(:,:,245))
  call Hloop_QA_W(ntryL,G2H4(97),ex2(:),G2H2(58),m3h2x2(:,172),heltab2x4(:,:,246))
  call Hloop_QA_W(ntryL,G2H4(98),ex2(:),G2H2(59),m3h2x2(:,173),heltab2x4(:,:,247))
  call Hloop_QA_W(ntryL,G2H4(99),ex2(:),G2H2(60),m3h2x2(:,174),heltab2x4(:,:,248))
  call Hloop_QA_W(ntryL,G2H4(101),ex2(:),G2H2(61),m3h2x2(:,175),heltab2x4(:,:,249))
  call Hloop_QA_W(ntryL,G2H4(102),ex2(:),G2H2(63),m3h2x2(:,176),heltab2x4(:,:,250))
  call Hotf_5pt_reduction(G2H4(103),RedSet_5(6),mass5set(:,3),  & 
G1H4(161),G1H4(162),G1H4(163),G1H4(164),G1H4(165),G1H4(166),4)
  call HG1shiftOLR(G1H4(162),2,4)
  call Hotf_4pt_reduction(G2H4(105),RedSet_4(1),mass4set(:,1),  & 
G1H4(167),G1H4(168),G1H4(169),G1H4(170),G1H4(171),4)
  call HG1shiftOLR(G1H4(168),2,4)
  call Hotf_4pt_reduction(G2H4(106),RedSet_4(2),mass4set(:,1),  & 
G1H4(172),G1H4(173),G1H4(174),G1H4(175),G1H4(176),4)
  call HG1shiftOLR(G1H4(173),10,4)
  call Hotf_5pt_reduction(G2H4(107),RedSet_5(6),mass5set(:,3),  & 
G1H4(177),G1H4(178),G1H4(179),G1H4(180),G1H4(181),G1H4(182),4)
  call HG1shiftOLR(G1H4(178),2,4)
  call Hotf_4pt_reduction(G2H4(109),RedSet_4(1),mass4set(:,1),  & 
G1H4(183),G1H4(184),G1H4(185),G1H4(186),G1H4(187),4)
  call HG1shiftOLR(G1H4(184),2,4)
  call Hotf_4pt_reduction(G2H4(110),RedSet_4(2),mass4set(:,1),  & 
G1H4(188),G1H4(189),G1H4(190),G1H4(191),G1H4(192),4)
  call HG1shiftOLR(G1H4(189),10,4)
  call Hloop_QA_S(ntryL,G2H2(85),ex2(:),G2H1(21),ngPtb,m3h2x1(:,21),heltab2x2(:,:,31))
  call Hloop_QA_S(ntryL,G2H2(87),ex2(:),G2H1(22),ngPtb,m3h2x1(:,22),heltab2x2(:,:,32))
  call Hloop_QA_S(ntryL,G2H2(88),ex2(:),G2H1(23),ngPtb,m3h2x1(:,23),heltab2x2(:,:,33))
  call Hloop_QA_S(ntryL,G2H2(89),ex2(:),G2H1(24),ngPtb,m3h2x1(:,24),heltab2x2(:,:,34))
  call Hloop_QA_S(ntryL,G2H2(91),ex2(:),G2H1(25),ngPtb,m3h2x1(:,25),heltab2x2(:,:,35))
  call Hloop_QA_S(ntryL,G2H2(92),ex2(:),G2H1(26),ngPtb,m3h2x1(:,26),heltab2x2(:,:,36))
  call Hloop_QA_W(ntryL,G2H2(93),ex2(:),G2H1(27),m3h2x1(:,27),heltab2x2(:,:,37))
  call Hloop_QA_W(ntryL,G2H2(95),ex2(:),G2H1(28),m3h2x1(:,28),heltab2x2(:,:,38))
  call Hloop_QA_W(ntryL,G2H2(96),ex2(:),G2H1(29),m3h2x1(:,29),heltab2x2(:,:,39))
  call Hloop_QA_W(ntryL,G2H2(97),ex2(:),G2H1(30),m3h2x1(:,30),heltab2x2(:,:,40))
  call Hloop_QA_W(ntryL,G2H2(99),ex2(:),G2H1(31),m3h2x1(:,31),heltab2x2(:,:,41))
  call Hloop_QA_W(ntryL,G2H2(100),ex2(:),G2H1(32),m3h2x1(:,32),heltab2x2(:,:,42))
  call Hotf_5pt_reduction(G2H2(101),RedSet_5(8),mass5set(:,3),  & 
G1H2(237),G1H2(238),G1H2(239),G1H2(240),G1H2(241),G1H2(242),2)
  call HG1shiftOLR(G1H2(238),2,2)
  call Hotf_4pt_reduction(G2H2(103),RedSet_4(1),mass4set(:,1),  & 
G1H2(243),G1H2(244),G1H2(245),G1H2(246),G1H2(247),2)
  call HG1shiftOLR(G1H2(244),2,2)
  call Hotf_4pt_reduction(G2H2(104),RedSet_4(3),mass4set(:,1),  & 
G1H2(248),G1H2(249),G1H2(250),G1H2(251),G1H2(252),2)
  call HG1shiftOLR(G1H2(249),6,2)
  call Hotf_5pt_reduction(G2H2(105),RedSet_5(8),mass5set(:,3),  & 
G1H2(253),G1H2(254),G1H2(255),G1H2(256),G1H2(257),G1H2(258),2)
  call HG1shiftOLR(G1H2(254),2,2)
  call Hotf_4pt_reduction(G2H2(107),RedSet_4(1),mass4set(:,1),  & 
G1H2(259),G1H2(260),G1H2(261),G1H2(262),G1H2(263),2)
  call HG1shiftOLR(G1H2(260),2,2)
  call Hotf_4pt_reduction(G2H2(108),RedSet_4(3),mass4set(:,1),  & 
G1H2(264),G1H2(265),G1H2(266),G1H2(267),G1H2(268),2)
  call HG1shiftOLR(G1H2(265),6,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(167),[G1H4(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(172),[G1H4(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(183),[G1H4(181)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(188),[G1H4(182)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(243),[G1H2(241)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(248),[G1H2(242)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(259),[G1H2(257)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(264),[G1H2(258)])
  call Hloop_SA_Q(ntryL,G1H4(89),ex2(:),G1H2(241),ngH,m3h2x2(:,177),heltab2x4(:,:,251))
  call Hloop_A_Q(ntryL,G1H2(241),23,nMT,G2H2(62),n2h2(67))
call HGT_OLR(G1H4(93),1,1,4)
call HGT_invQ_OLR(G1H4(93),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(93),-8,nMT,G2H4(56),n2h4(205))
  call Hloop_QV_A(ntryL,G2H4(56),ex4(:),G2H2(64),m3h2x2(:,178),heltab2x4(:,:,252))
  call Hloop_SA_Q(ntryL,G1H4(108),ex2(:),G1H2(242),ngH,m3h2x2(:,179),heltab2x4(:,:,253))
  call Hloop_A_Q(ntryL,G1H2(242),23,nMT,G2H2(67),n2h2(68))
  call Hloop_SA_Q(ntryL,G1H4(107),ex2(:),G1H2(257),ngH,m3h2x2(:,180),heltab2x4(:,:,254))
  call Hloop_A_Q(ntryL,G1H2(257),23,nMT,G2H2(69),n2h2(69))
  call Hloop_SA_Q(ntryL,G1H4(111),ex2(:),G1H2(258),ngX,m3h2x2(:,181),heltab2x4(:,:,255))
  call Hloop_A_Q(ntryL,G1H2(258),23,nMT,G2H2(70),n2h2(70))
call HGT_OLR(G1H4(8),1,1,4)
call HGT_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(8),-8,nMT,G2H4(60),n2h4(206))
  call Hloop_QV_A(ntryL,G2H4(60),ex4(:),G2H2(71),m3h2x2(:,182),heltab2x4(:,:,256))
  call Hloop_SA_Q(ntryL,G1H4(12),ex2(:),G1H2(241),ngX,m3h2x2(:,183),heltab2x4(:,:,257))
  call Hloop_A_Q(ntryL,G1H2(241),23,nMT,G2H2(73),n2h2(71))
  call Hloop_SA_Q(ntryL,G1H4(1),ex2(:),G1H2(242),ngX,m3h2x2(:,184),heltab2x4(:,:,258))
  call Hloop_A_Q(ntryL,G1H2(242),23,nMT,G2H2(74),n2h2(72))
  call Hloop_SA_Q(ntryL,G1H4(3),ex2(:),G1H2(257),ngPtb,m3h2x2(:,185),heltab2x4(:,:,259))
  call Hloop_A_Q(ntryL,G1H2(257),23,nMB,G2H2(75),n2h2(73))
call HGT_OLR(G1H4(4),1,1,4)
call HGT_invQ_OLR(G1H4(4),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(4),-8,nMB,G2H4(61),n2h4(207))
  call Hloop_QV_A(ntryL,G2H4(61),ex4(:),G2H2(77),m3h2x2(:,186),heltab2x4(:,:,260))
  call Hloop_SA_Q(ntryL,G1H4(28),ex2(:),G1H2(258),ngPtb,m3h2x2(:,187),heltab2x4(:,:,261))
  call Hloop_A_Q(ntryL,G1H2(258),23,nMB,G2H2(78),n2h2(74))
  call Hloop_SA_Q(ntryL,G1H4(13),ex2(:),G1H2(241),ngPtb,m3h2x2(:,188),heltab2x4(:,:,262))
  call Hloop_A_Q(ntryL,G1H2(241),23,nMB,G2H2(79),n2h2(75))
  call Hloop_VA_Q(ntryL,G1H4(16),ex2(:),G1H2(242),m3h2x2(:,189),heltab2x4(:,:,263))
  call Hloop_A_Q(ntryL,G1H2(242),23,nMT,G2H2(81),n2h2(76))
call HGT_OLR(G1H4(42),1,1,4)
call HGT_invQ_OLR(G1H4(42),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(42),-8,nMT,G2H4(62),n2h4(208))
  call Hloop_QV_A(ntryL,G2H4(62),ex4(:),G2H2(82),m3h2x2(:,190),heltab2x4(:,:,264))
  call Hloop_VA_Q(ntryL,G1H4(18),ex2(:),G1H2(257),m3h2x2(:,191),heltab2x4(:,:,265))
  call Hloop_A_Q(ntryL,G1H2(257),23,nMT,G2H2(85),n2h2(77))
  call Hloop_VA_Q(ntryL,G1H4(41),ex2(:),G1H2(258),m3h2x2(:,192),heltab2x4(:,:,266))
  call Hloop_A_Q(ntryL,G1H2(258),23,nMT,G2H2(87),n2h2(78))
  call Hloop_ZA_Q(ntryL,G1H4(19),ex2(:),G1H2(241),ngZu,m3h2x2(:,193),heltab2x4(:,:,267))
  call Hloop_A_Q(ntryL,G1H2(241),23,nMT,G2H2(88),n2h2(79))
call HGT_OLR(G1H4(27),1,1,4)
call HGT_invQ_OLR(G1H4(27),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(27),-8,nMT,G2H4(3),n2h4(209))
  call Hloop_QV_A(ntryL,G2H4(3),ex4(:),G2H2(89),m3h2x2(:,194),heltab2x4(:,:,268))
  call Hloop_ZA_Q(ntryL,G1H4(50),ex2(:),G1H2(242),ngZu,m3h2x2(:,195),heltab2x4(:,:,269))
  call Hloop_A_Q(ntryL,G1H2(242),23,nMT,G2H2(91),n2h2(80))
  call Hloop_ZA_Q(ntryL,G1H4(31),ex2(:),G1H2(257),ngZu,m3h2x2(:,196),heltab2x4(:,:,270))
  call Hloop_A_Q(ntryL,G1H2(257),23,nMT,G2H2(92),n2h2(81))
  call Hloop_WA_Q(ntryL,G1H4(53),ex2(:),G1H2(258),m3h2x2(:,197),heltab2x4(:,:,271))
  call Hloop_A_Q(ntryL,G1H2(258),23,nMB,G2H2(93),n2h2(82))
call HGT_OLR(G1H4(32),1,1,4)
call HGT_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(32),-8,nMB,G2H4(8),n2h4(210))
  call Hloop_QV_A(ntryL,G2H4(8),ex4(:),G2H2(95),m3h2x2(:,198),heltab2x4(:,:,272))
  call Hloop_WA_Q(ntryL,G1H4(54),ex2(:),G1H2(241),m3h2x2(:,199),heltab2x4(:,:,273))
  call Hloop_A_Q(ntryL,G1H2(241),23,nMB,G2H2(96),n2h2(83))
  call Hloop_WA_Q(ntryL,G1H4(34),ex2(:),G1H2(242),m3h2x2(:,200),heltab2x4(:,:,274))
  call Hloop_A_Q(ntryL,G1H2(242),23,nMB,G2H2(97),n2h2(84))
  call Hloop_QS_A(ntryL,G1H2(17),ex3(:),G1H2(257),ngH,m3h1x2(:,11),heltab2x2(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(257),23,nMT,G2H2(99),n2h2(85))
call HGT_OLR(G1H2(1),1,1,2)
call HGT_invQ_OLR(G1H2(1),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(1),-8,nMT,G2H2(100),n2h2(86))
  call Hloop_AV_Q(ntryL,G2H2(100),ex4(:),G2H1(33),m3h2x1(:,33),heltab2x2(:,:,44))
  call Hloop_QS_A(ntryL,G1H2(3),ex3(:),G1H2(258),ngH,m3h1x2(:,12),heltab2x2(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(258),23,nMT,G2H2(101),n2h2(87))
  call Hloop_QS_A(ntryL,G1H2(6),ex3(:),G1H2(241),ngH,m3h1x2(:,13),heltab2x2(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(241),23,nMT,G2H2(103),n2h2(88))
  call Hloop_QS_A(ntryL,G1H2(5),ex3(:),G1H2(242),ngH,m3h1x2(:,14),heltab2x2(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(242),23,nMT,G2H2(104),n2h2(89))
call HGT_OLR(G1H2(8),1,1,2)
call HGT_invQ_OLR(G1H2(8),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(8),-8,nMT,G2H2(105),n2h2(90))
  call Hloop_AV_Q(ntryL,G2H2(105),ex4(:),G2H1(34),m3h2x1(:,34),heltab2x2(:,:,48))
  call Hloop_QS_A(ntryL,G1H2(19),ex3(:),G1H2(17),ngH,m3h1x2(:,15),heltab2x2(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(17),23,nMT,G2H2(107),n2h2(91))
  call Hloop_QS_A(ntryL,G1H2(20),ex3(:),G1H2(257),ngH,m3h1x2(:,16),heltab2x2(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(257),23,nMT,G2H2(108),n2h2(92))
  call Hloop_QS_A(ntryL,G1H2(21),ex3(:),G1H2(1),ngH,m3h1x2(:,17),heltab2x2(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(100),n2h2(93))
call HGT_OLR(G1H2(22),1,1,2)
call HGT_invQ_OLR(G1H2(22),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(22),-8,nMB,G2H2(105),n2h2(94))
  call Hloop_AV_Q(ntryL,G2H2(105),ex4(:),G2H1(35),m3h2x1(:,35),heltab2x2(:,:,52))
  call Hloop_QS_A(ntryL,G1H2(25),ex3(:),G1H2(3),ngH,m3h1x2(:,18),heltab2x2(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMB,G2H2(105),n2h2(95))
  call Hloop_QS_A(ntryL,G1H2(26),ex3(:),G1H2(258),ngH,m3h1x2(:,19),heltab2x2(:,:,54))
  call Hloop_Q_A(ntryL,G1H2(258),23,nMB,G2H2(109),n2h2(96))
  call Hloop_QS_A(ntryL,G1H2(27),ex3(:),G1H2(6),ngH,m3h1x2(:,20),heltab2x2(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(6),23,nMT,G2H2(110),n2h2(97))
call HGT_OLR(G1H2(28),1,1,2)
call HGT_invQ_OLR(G1H2(28),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(28),-8,nMT,G2H2(111),n2h2(98))
  call Hloop_AV_Q(ntryL,G2H2(111),ex4(:),G2H1(36),m3h2x1(:,36),heltab2x2(:,:,56))
  call Hloop_QS_A(ntryL,G1H2(31),ex3(:),G1H2(241),ngH,m3h1x2(:,21),heltab2x2(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(241),23,nMT,G2H2(111),n2h2(99))
  call Hloop_QS_A(ntryL,G1H2(32),ex3(:),G1H2(5),ngH,m3h1x2(:,22),heltab2x2(:,:,58))
  call Hloop_Q_A(ntryL,G1H2(5),23,nMT,G2H2(112),n2h2(100))
  call Hloop_ST_V(ntryL,G1H2(33),19,ex3(:),4,G2H2(113),m3h1x2(:,23),heltab2x2(:,:,59))
call HGT_OLR(G1H2(34),1,1,2)
call HGT_invQ_OLR(G1H2(34),2,5,2)
  call Hloop_SV_V(ntryL,G1H2(34),ex4(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,60))
  call Hloop_ST_V(ntryL,G1H2(37),19,ex3(:),4,G2H2(114),m3h1x2(:,24),heltab2x2(:,:,61))
  call Hloop_ST_V(ntryL,G1H2(38),19,ex3(:),4,G2H2(115),m3h1x2(:,25),heltab2x2(:,:,62))
  call Hloop_VT_S(ntryL,G1H2(39),19,ex3(:),4,G2H2(116),m3h1x2(:,26),heltab2x2(:,:,63))
call HGT_OLR(G1H2(40),1,1,2)
call HGT_invQ_OLR(G1H2(40),2,5,2)
  call Hloop_TV_S(ntryL,G1H2(40),-8,ex4(:),8,G2H1(37),m3h2x1(:,38),heltab2x2(:,:,64))
  call Hloop_VT_S(ntryL,G1H2(43),19,ex3(:),4,G2H2(117),m3h1x2(:,27),heltab2x2(:,:,65))
  call Hloop_VT_S(ntryL,G1H2(44),19,ex3(:),4,G2H2(118),m3h1x2(:,28),heltab2x2(:,:,66))
  call Hloop_ST_V(ntryL,G1H2(45),19,ex3(:),4,G2H2(119),m3h1x2(:,29),heltab2x2(:,:,67))
call HGT_raise_alpha_OLR(G1H2(46),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(46),2,5,2)
  call Hloop_UV_W(ntryL,G1H2(46),-8,ex4(:),8,G2H1(38),m3h2x1(:,39),heltab2x2(:,:,68))
  call Hloop_ST_V(ntryL,G1H2(49),19,ex3(:),4,G2H2(120),m3h1x2(:,30),heltab2x2(:,:,69))
  call Hloop_ST_V(ntryL,G1H2(50),19,ex3(:),4,G2H2(121),m3h1x2(:,31),heltab2x2(:,:,70))
  call Hloop_VT_S(ntryL,G1H2(51),19,ex3(:),4,G2H2(122),m3h1x2(:,32),heltab2x2(:,:,71))
call HGT_raise_alpha_OLR(G1H2(52),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(52),2,5,2)
  call Hloop_VV_S(ntryL,G1H2(52),ex4(:),G1H1(2),m3h2x1(:,40),heltab2x2(:,:,72))
  call Hloop_VT_S(ntryL,G1H2(55),19,ex3(:),4,G2H2(123),m3h1x2(:,33),heltab2x2(:,:,73))
  call Hloop_VT_S(ntryL,G1H2(56),19,ex3(:),4,G2H2(124),m3h1x2(:,34),heltab2x2(:,:,74))
  call Hloop_SQ_A(ntryL,G1H4(44),ex1(:),G1H2(242),ngH,m3h2x2(:,201),heltab2x4(:,:,275))
  call Hloop_Q_A(ntryL,G1H2(242),23,nMT,G2H2(125),n2h2(105))
call HGT_OLR(G1H4(36),1,1,4)
call HGT_invQ_OLR(G1H4(36),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(36),-8,nMT,G2H4(63),n2h4(211))
  call Hloop_AV_Q(ntryL,G2H4(63),ex4(:),G2H2(126),m3h2x2(:,202),heltab2x4(:,:,276))
  call Hloop_SQ_A(ntryL,G1H4(46),ex1(:),G1H2(8),ngH,m3h2x2(:,203),heltab2x4(:,:,277))
  call Hloop_Q_A(ntryL,G1H2(8),23,nMT,G2H2(127),n2h2(106))
  call Hloop_SQ_A(ntryL,G1H4(26),ex1(:),G1H2(19),ngH,m3h2x2(:,204),heltab2x4(:,:,278))
  call Hloop_Q_A(ntryL,G1H2(19),23,nMT,G2H2(128),n2h2(107))
  call Hloop_SQ_A(ntryL,G1H4(57),ex1(:),G1H2(17),ngX,m3h2x2(:,205),heltab2x4(:,:,279))
  call Hloop_Q_A(ntryL,G1H2(17),23,nMT,G2H2(129),n2h2(108))
call HGT_OLR(G1H4(55),1,1,4)
call HGT_invQ_OLR(G1H4(55),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(55),-8,nMT,G2H4(64),n2h4(212))
  call Hloop_AV_Q(ntryL,G2H4(64),ex4(:),G2H2(130),m3h2x2(:,206),heltab2x4(:,:,280))
  call Hloop_SQ_A(ntryL,G1H4(35),ex1(:),G1H2(20),ngX,m3h2x2(:,207),heltab2x4(:,:,281))
  call Hloop_Q_A(ntryL,G1H2(20),23,nMT,G2H2(131),n2h2(109))
  call Hloop_SQ_A(ntryL,G1H4(61),ex1(:),G1H2(257),ngX,m3h2x2(:,208),heltab2x4(:,:,282))
  call Hloop_Q_A(ntryL,G1H2(257),23,nMT,G2H2(132),n2h2(110))
  call Hloop_SQ_A(ntryL,G1H4(65),ex1(:),G1H2(21),ngPbt,m3h2x2(:,209),heltab2x4(:,:,283))
  call Hloop_Q_A(ntryL,G1H2(21),23,nMB,G2H2(133),n2h2(111))
call HGT_OLR(G1H4(62),1,1,4)
call HGT_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(62),-8,nMB,G2H4(53),n2h4(213))
  call Hloop_AV_Q(ntryL,G2H4(53),ex4(:),G2H2(134),m3h2x2(:,210),heltab2x4(:,:,284))
  call Hloop_SQ_A(ntryL,G1H4(116),ex1(:),G1H2(1),ngPbt,m3h2x2(:,211),heltab2x4(:,:,285))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(135),n2h2(112))
  call Hloop_SQ_A(ntryL,G1H4(66),ex1(:),G1H2(22),ngPbt,m3h2x2(:,212),heltab2x4(:,:,286))
  call Hloop_Q_A(ntryL,G1H2(22),23,nMB,G2H2(136),n2h2(113))
  call Hloop_VQ_A(ntryL,G1H4(70),ex1(:),G1H2(25),m3h2x2(:,213),heltab2x4(:,:,287))
  call Hloop_Q_A(ntryL,G1H2(25),23,nMT,G2H2(137),n2h2(114))
call HGT_OLR(G1H4(68),1,1,4)
call HGT_invQ_OLR(G1H4(68),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(68),-8,nMT,G2H4(54),n2h4(214))
  call Hloop_AV_Q(ntryL,G2H4(54),ex4(:),G2H2(138),m3h2x2(:,214),heltab2x4(:,:,288))
  call Hloop_VQ_A(ntryL,G1H4(72),ex1(:),G1H2(3),m3h2x2(:,215),heltab2x4(:,:,289))
  call Hloop_Q_A(ntryL,G1H2(3),23,nMT,G2H2(139),n2h2(115))
  call Hloop_VQ_A(ntryL,G1H4(74),ex1(:),G1H2(26),m3h2x2(:,216),heltab2x4(:,:,290))
  call Hloop_Q_A(ntryL,G1H2(26),23,nMT,G2H2(140),n2h2(116))
  call Hloop_ZQ_A(ntryL,G1H4(78),ex1(:),G1H2(258),ngZu,m3h2x2(:,217),heltab2x4(:,:,291))
  call Hloop_Q_A(ntryL,G1H2(258),23,nMT,G2H2(141),n2h2(117))
call HGT_OLR(G1H4(37),1,1,4)
call HGT_invQ_OLR(G1H4(37),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(37),-8,nMT,G2H4(55),n2h4(215))
  call Hloop_AV_Q(ntryL,G2H4(55),ex4(:),G2H2(142),m3h2x2(:,218),heltab2x4(:,:,292))
  call Hloop_ZQ_A(ntryL,G1H4(73),ex1(:),G1H2(27),ngZu,m3h2x2(:,219),heltab2x4(:,:,293))
  call Hloop_Q_A(ntryL,G1H2(27),23,nMT,G2H2(143),n2h2(118))
  call Hloop_ZQ_A(ntryL,G1H4(82),ex1(:),G1H2(6),ngZu,m3h2x2(:,220),heltab2x4(:,:,294))
  call Hloop_Q_A(ntryL,G1H2(6),23,nMT,G2H2(144),n2h2(119))
  call Hloop_WQ_A(ntryL,G1H4(77),ex1(:),G1H2(28),m3h2x2(:,221),heltab2x4(:,:,295))
  call Hloop_Q_A(ntryL,G1H2(28),23,nMB,G2H2(145),n2h2(120))
call HGT_OLR(G1H4(83),1,1,4)
call HGT_invQ_OLR(G1H4(83),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(83),-8,nMB,G2H4(25),n2h4(216))
  call Hloop_AV_Q(ntryL,G2H4(25),ex4(:),G2H2(146),m3h2x2(:,222),heltab2x4(:,:,296))
  call Hloop_WQ_A(ntryL,G1H4(94),ex1(:),G1H2(31),m3h2x2(:,223),heltab2x4(:,:,297))
  call Hloop_Q_A(ntryL,G1H2(31),23,nMB,G2H2(147),n2h2(121))
  call Hloop_WQ_A(ntryL,G1H4(96),ex1(:),G1H2(241),m3h2x2(:,224),heltab2x4(:,:,298))
  call Hloop_Q_A(ntryL,G1H2(241),23,nMB,G2H2(148),n2h2(122))
  call Hloop_QV_A(ntryL,G1H2(57),ex4(:),G1H1(3),m3h2x1(:,41),heltab2x2(:,:,75))
  call Hloop_Q_A(ntryL,G1H1(3),27,nMT,G2H1(39),n2h1(1))
call HGT_OLR(G1H2(58),1,1,2)
call HGT_invQ_OLR(G1H2(58),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(58),-4,nMT,G2H2(149),n2h2(123))
  call Hloop_AS_Q(ntryL,G2H2(149),ex3(:),G2H2(150),ngH,m3h1x2(:,35),heltab2x2(:,:,76))
  call Hloop_QV_A(ntryL,G1H2(61),ex4(:),G1H1(3),m3h2x1(:,42),heltab2x2(:,:,77))
  call Hloop_Q_A(ntryL,G1H1(3),27,nMT,G2H1(40),n2h1(2))
  call Hloop_QV_A(ntryL,G1H2(62),ex4(:),G1H1(3),m3h2x1(:,43),heltab2x2(:,:,78))
  call Hloop_Q_A(ntryL,G1H1(3),27,nMT,G2H1(41),n2h1(3))
  call Hloop_QV_A(ntryL,G1H2(63),ex4(:),G1H1(3),m3h2x1(:,44),heltab2x2(:,:,79))
  call Hloop_Q_A(ntryL,G1H1(3),27,nMT,G2H1(42),n2h1(4))
call HGT_OLR(G1H2(64),1,1,2)
call HGT_invQ_OLR(G1H2(64),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(64),-4,nMT,G2H2(149),n2h2(124))
  call Hloop_AS_Q(ntryL,G2H2(149),ex3(:),G2H2(151),ngH,m3h1x2(:,36),heltab2x2(:,:,80))
  call Hloop_QV_A(ntryL,G1H2(67),ex4(:),G1H1(3),m3h2x1(:,45),heltab2x2(:,:,81))
  call Hloop_Q_A(ntryL,G1H1(3),27,nMT,G2H1(43),n2h1(5))
  call Hloop_QV_A(ntryL,G1H2(68),ex4(:),G1H1(3),m3h2x1(:,46),heltab2x2(:,:,82))
  call Hloop_Q_A(ntryL,G1H1(3),27,nMT,G2H1(44),n2h1(6))
  call Hloop_QV_A(ntryL,G1H2(69),ex4(:),G1H1(3),m3h2x1(:,47),heltab2x2(:,:,83))
  call Hloop_Q_A(ntryL,G1H1(3),27,nMB,G2H1(45),n2h1(7))
call HGT_OLR(G1H2(70),1,1,2)
call HGT_invQ_OLR(G1H2(70),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(70),-4,nMB,G2H2(149),n2h2(125))
  call Hloop_AS_Q(ntryL,G2H2(149),ex3(:),G2H2(152),ngH,m3h1x2(:,37),heltab2x2(:,:,84))
  call Hloop_QV_A(ntryL,G1H2(73),ex4(:),G1H1(3),m3h2x1(:,48),heltab2x2(:,:,85))
  call Hloop_Q_A(ntryL,G1H1(3),27,nMB,G2H1(46),n2h1(8))
  call Hloop_QV_A(ntryL,G1H2(74),ex4(:),G1H1(3),m3h2x1(:,49),heltab2x2(:,:,86))
  call Hloop_Q_A(ntryL,G1H1(3),27,nMB,G2H1(47),n2h1(9))
  call Hloop_SV_T(ntryL,G1H2(75),19,ex4(:),8,G2H1(48),m3h2x1(:,50),heltab2x2(:,:,87))
call HGT_OLR(G1H2(76),1,1,2)
call HGT_invQ_OLR(G1H2(76),2,5,2)
  call Hloop_SS_S(ntryL,G1H2(76),ex3(:),G1H2(32),m3h1x2(:,38),heltab2x2(:,:,88))
  call Hloop_SV_T(ntryL,G1H2(79),19,ex4(:),8,G2H1(49),m3h2x1(:,51),heltab2x2(:,:,89))
  call Hloop_SV_T(ntryL,G1H2(80),19,ex4(:),8,G2H1(50),m3h2x1(:,52),heltab2x2(:,:,90))
  call Hloop_QV_A(ntryL,G1H2(81),ex4(:),G1H1(3),m3h2x1(:,53),heltab2x2(:,:,91))
  call Hloop_Q_A(ntryL,G1H1(3),27,nMT,G2H1(51),n2h1(10))
call HGT_OLR(G1H2(82),1,1,2)
call HGT_invQ_OLR(G1H2(82),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(82),-4,nMT,G2H2(149),n2h2(127))
  call Hloop_AS_Q(ntryL,G2H2(149),ex3(:),G2H2(153),ngH,m3h1x2(:,39),heltab2x2(:,:,92))
  call Hloop_QV_A(ntryL,G1H2(85),ex4(:),G1H1(3),m3h2x1(:,54),heltab2x2(:,:,93))
  call Hloop_Q_A(ntryL,G1H1(3),27,nMT,G2H1(52),n2h1(11))
  call Hloop_QV_A(ntryL,G1H2(86),ex4(:),G1H1(3),m3h2x1(:,55),heltab2x2(:,:,94))
  call Hloop_Q_A(ntryL,G1H1(3),27,nMT,G2H1(53),n2h1(12))
  call Hloop_SV_T(ntryL,G1H2(87),19,ex4(:),8,G2H1(54),m3h2x1(:,56),heltab2x2(:,:,95))
call HGT_raise_alpha_OLR(G1H2(88),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(88),2,5,2)
  call Hloop_VT_S(ntryL,G1H2(88),-4,ex3(:),4,G2H2(149),m3h1x2(:,40),heltab2x2(:,:,96))
  call Hloop_SV_T(ntryL,G1H2(91),19,ex4(:),8,G2H1(55),m3h2x1(:,57),heltab2x2(:,:,97))
  call Hloop_SV_T(ntryL,G1H2(92),19,ex4(:),8,G2H1(56),m3h2x1(:,58),heltab2x2(:,:,98))
  call Hloop_UW_V(ntryL,G1H2(93),19,ex4(:),8,G2H1(57),m3h2x1(:,59),heltab2x2(:,:,99))
call HGT_OLR(G1H2(94),1,1,2)
call HGT_invQ_OLR(G1H2(94),2,5,2)
  call Hloop_ST_V(ntryL,G1H2(94),-4,ex3(:),4,G2H2(154),m3h1x2(:,41),heltab2x2(:,:,100))
  call Hloop_UW_V(ntryL,G1H2(97),19,ex4(:),8,G2H1(58),m3h2x1(:,60),heltab2x2(:,:,101))
  call Hloop_UW_V(ntryL,G1H2(98),19,ex4(:),8,G2H1(59),m3h2x1(:,61),heltab2x2(:,:,102))
  call Hloop_UW_V(ntryL,G1H2(99),19,ex4(:),8,G2H1(60),m3h2x1(:,62),heltab2x2(:,:,103))
call HGT_raise_alpha_OLR(G1H2(100),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(100),2,5,2)
  call Hloop_VS_V(ntryL,G1H2(100),ex3(:),G1H2(5),m3h1x2(:,42),heltab2x2(:,:,104))
  call Hloop_UW_V(ntryL,G1H2(103),19,ex4(:),8,G2H1(61),m3h2x1(:,63),heltab2x2(:,:,105))
  call Hloop_UW_V(ntryL,G1H2(104),19,ex4(:),8,G2H1(62),m3h2x1(:,64),heltab2x2(:,:,106))
  call Hloop_AS_Q(ntryL,G1H2(105),ex3(:),G1H2(33),ngH,m3h1x2(:,43),heltab2x2(:,:,107))
  call Hloop_A_Q(ntryL,G1H2(33),23,nMT,G2H2(155),n2h2(131))
call HGT_OLR(G1H2(106),1,1,2)
call HGT_invQ_OLR(G1H2(106),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(106),-8,nMT,G2H2(156),n2h2(132))
  call Hloop_QV_A(ntryL,G2H2(156),ex4(:),G2H1(63),m3h2x1(:,65),heltab2x2(:,:,108))
  call Hloop_AS_Q(ntryL,G1H2(109),ex3(:),G1H2(34),ngH,m3h1x2(:,44),heltab2x2(:,:,109))
  call Hloop_A_Q(ntryL,G1H2(34),23,nMT,G2H2(156),n2h2(133))
  call Hloop_AS_Q(ntryL,G1H2(110),ex3(:),G1H2(37),ngH,m3h1x2(:,45),heltab2x2(:,:,110))
  call Hloop_A_Q(ntryL,G1H2(37),23,nMT,G2H2(157),n2h2(134))
  call Hloop_AS_Q(ntryL,G1H2(111),ex3(:),G1H2(38),ngH,m3h1x2(:,46),heltab2x2(:,:,111))
  call Hloop_A_Q(ntryL,G1H2(38),23,nMT,G2H2(158),n2h2(135))
call HGT_OLR(G1H2(112),1,1,2)
call HGT_invQ_OLR(G1H2(112),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(112),-8,nMT,G2H2(159),n2h2(136))
  call Hloop_QV_A(ntryL,G2H2(159),ex4(:),G2H1(64),m3h2x1(:,66),heltab2x2(:,:,112))
  call Hloop_AS_Q(ntryL,G1H2(115),ex3(:),G1H2(39),ngH,m3h1x2(:,47),heltab2x2(:,:,113))
  call Hloop_A_Q(ntryL,G1H2(39),23,nMT,G2H2(159),n2h2(137))
  call Hloop_AS_Q(ntryL,G1H2(116),ex3(:),G1H2(40),ngH,m3h1x2(:,48),heltab2x2(:,:,114))
  call Hloop_A_Q(ntryL,G1H2(40),23,nMT,G2H2(160),n2h2(138))
  call Hloop_AS_Q(ntryL,G1H2(117),ex3(:),G1H2(43),ngH,m3h1x2(:,49),heltab2x2(:,:,115))
  call Hloop_A_Q(ntryL,G1H2(43),23,nMB,G2H2(161),n2h2(139))
call HGT_OLR(G1H2(118),1,1,2)
call HGT_invQ_OLR(G1H2(118),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(118),-8,nMB,G2H2(162),n2h2(140))
  call Hloop_QV_A(ntryL,G2H2(162),ex4(:),G2H1(65),m3h2x1(:,67),heltab2x2(:,:,116))
  call Hloop_AS_Q(ntryL,G1H2(121),ex3(:),G1H2(44),ngH,m3h1x2(:,50),heltab2x2(:,:,117))
  call Hloop_A_Q(ntryL,G1H2(44),23,nMB,G2H2(162),n2h2(141))
  call Hloop_AS_Q(ntryL,G1H2(122),ex3(:),G1H2(45),ngH,m3h1x2(:,51),heltab2x2(:,:,118))
  call Hloop_A_Q(ntryL,G1H2(45),23,nMB,G2H2(163),n2h2(142))
  call Hloop_AS_Q(ntryL,G1H2(123),ex3(:),G1H2(46),ngH,m3h1x2(:,52),heltab2x2(:,:,119))
  call Hloop_A_Q(ntryL,G1H2(46),23,nMT,G2H2(164),n2h2(143))
call HGT_OLR(G1H2(124),1,1,2)
call HGT_invQ_OLR(G1H2(124),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(124),-8,nMT,G2H2(165),n2h2(144))
  call Hloop_QV_A(ntryL,G2H2(165),ex4(:),G2H1(66),m3h2x1(:,68),heltab2x2(:,:,120))
  call Hloop_AS_Q(ntryL,G1H2(127),ex3(:),G1H2(49),ngH,m3h1x2(:,53),heltab2x2(:,:,121))
  call Hloop_A_Q(ntryL,G1H2(49),23,nMT,G2H2(165),n2h2(145))
  call Hloop_AS_Q(ntryL,G1H2(128),ex3(:),G1H2(50),ngH,m3h1x2(:,54),heltab2x2(:,:,122))
  call Hloop_A_Q(ntryL,G1H2(50),23,nMT,G2H2(166),n2h2(146))
  call Hloop_ST_V(ntryL,G1H2(129),19,ex3(:),4,G2H2(167),m3h1x2(:,55),heltab2x2(:,:,123))
call HGT_OLR(G1H2(130),1,1,2)
call HGT_invQ_OLR(G1H2(130),2,5,2)
  call Hloop_SV_V(ntryL,G1H2(130),ex4(:),G1H1(3),m3h2x1(:,69),heltab2x2(:,:,124))
  call Hloop_ST_V(ntryL,G1H2(133),19,ex3(:),4,G2H2(168),m3h1x2(:,56),heltab2x2(:,:,125))
  call Hloop_ST_V(ntryL,G1H2(134),19,ex3(:),4,G2H2(169),m3h1x2(:,57),heltab2x2(:,:,126))
  call Hloop_VT_S(ntryL,G1H2(135),19,ex3(:),4,G2H2(170),m3h1x2(:,58),heltab2x2(:,:,127))
call HGT_OLR(G1H2(136),1,1,2)
call HGT_invQ_OLR(G1H2(136),2,5,2)
  call Hloop_SV_T(ntryL,G1H2(136),-8,ex4(:),8,G2H1(67),m3h2x1(:,70),heltab2x2(:,:,128))
  call Hloop_VT_S(ntryL,G1H2(139),19,ex3(:),4,G2H2(171),m3h1x2(:,59),heltab2x2(:,:,129))
  call Hloop_VT_S(ntryL,G1H2(140),19,ex3(:),4,G2H2(172),m3h1x2(:,60),heltab2x2(:,:,130))
  call Hloop_ST_V(ntryL,G1H2(141),19,ex3(:),4,G2H2(173),m3h1x2(:,61),heltab2x2(:,:,131))
call HGT_raise_alpha_OLR(G1H2(142),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(142),2,5,2)
  call Hloop_UW_V(ntryL,G1H2(142),-8,ex4(:),8,G2H1(68),m3h2x1(:,71),heltab2x2(:,:,132))
  call Hloop_ST_V(ntryL,G1H2(145),19,ex3(:),4,G2H2(174),m3h1x2(:,62),heltab2x2(:,:,133))
  call Hloop_ST_V(ntryL,G1H2(146),19,ex3(:),4,G2H2(175),m3h1x2(:,63),heltab2x2(:,:,134))
  call Hloop_VT_S(ntryL,G1H2(147),19,ex3(:),4,G2H2(176),m3h1x2(:,64),heltab2x2(:,:,135))
call HGT_raise_alpha_OLR(G1H2(148),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(148),2,5,2)
  call Hloop_VV_S(ntryL,G1H2(148),ex4(:),G1H1(4),m3h2x1(:,72),heltab2x2(:,:,136))
  call Hloop_VT_S(ntryL,G1H2(151),19,ex3(:),4,G2H2(177),m3h1x2(:,65),heltab2x2(:,:,137))
  call Hloop_VT_S(ntryL,G1H2(152),19,ex3(:),4,G2H2(178),m3h1x2(:,66),heltab2x2(:,:,138))
  call Hloop_AV_Q(ntryL,G1H2(153),ex4(:),G1H1(5),m3h2x1(:,73),heltab2x2(:,:,139))
  call Hloop_A_Q(ntryL,G1H1(5),27,nMT,G2H1(69),n2h1(13))
call HGT_OLR(G1H2(154),1,1,2)
call HGT_invQ_OLR(G1H2(154),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(154),-4,nMT,G2H2(179),n2h2(151))
  call Hloop_QS_A(ntryL,G2H2(179),ex3(:),G2H2(180),ngH,m3h1x2(:,67),heltab2x2(:,:,140))
  call Hloop_AV_Q(ntryL,G1H2(157),ex4(:),G1H1(5),m3h2x1(:,74),heltab2x2(:,:,141))
  call Hloop_A_Q(ntryL,G1H1(5),27,nMT,G2H1(70),n2h1(14))
  call Hloop_AV_Q(ntryL,G1H2(158),ex4(:),G1H1(5),m3h2x1(:,75),heltab2x2(:,:,142))
  call Hloop_A_Q(ntryL,G1H1(5),27,nMT,G2H1(71),n2h1(15))
  call Hloop_AV_Q(ntryL,G1H2(159),ex4(:),G1H1(5),m3h2x1(:,76),heltab2x2(:,:,143))



end subroutine vamp_1

end module ol_vamp_1_pphtt_ew_ttxhaa_2_/**/REALKIND
