
! **********************************************************************
module ol_tables_storage_pphtt_ew_ttxddxh_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  ! helicity tables for the 1-loop recursion
integer(intkind2), save :: h0tab(16,180)
integer(intkind2), save :: heltab2x2(2,2,91)
integer(intkind2), save :: heltab2x4(2,4,94)
integer(intkind2), save :: heltab2x8(2,8,116)
integer(intkind2), save :: heltab2x16(2,16,260)


  ! number of helicity states for openloops recursion steps
integer(intkind2), save :: m0h(180)
integer(intkind2), save :: m3h2x1(3,91)
integer(intkind2), save :: m3h4x1(3,53)
integer(intkind2), save :: m3h8x1(3,40)
integer(intkind2), save :: m3h2x2(3,41)
integer(intkind2), save :: m3h4x2(3,20)
integer(intkind2), save :: m3h8x2(3,2)
integer(intkind2), save :: m3h2x4(3,56)
integer(intkind2), save :: m3h4x4(3,34)
integer(intkind2), save :: m3h2x8(3,132)
integer(intkind2), save :: m3h1x16(3,92)

integer(intkind2), save :: n2h1(113)
integer(intkind2), save :: n2h2(48)
integer(intkind2), save :: n2h4(66)
integer(intkind2), save :: n2h8(74)
integer(intkind2), save :: n2h16(51)


contains

!**********************************************************************
subroutine HOL_m3_init()
!**********************************************************************
! initialize m3 arrays for helicity summation
!**********************************************************************
  use KIND_TYPES, only: REALKIND, intkind2

m3h2x1(1,:)=2
m3h2x1(2,:)=1
m3h2x1(3,:)=2
m3h4x1(1,:)=4
m3h4x1(2,:)=1
m3h4x1(3,:)=4
m3h8x1(1,:)=8
m3h8x1(2,:)=1
m3h8x1(3,:)=8
m3h2x2(1,:)=2
m3h2x2(2,:)=2
m3h2x2(3,:)=4
m3h4x2(1,:)=4
m3h4x2(2,:)=2
m3h4x2(3,:)=8
m3h8x2(1,:)=8
m3h8x2(2,:)=2
m3h8x2(3,:)=16
m3h2x4(1,:)=2
m3h2x4(2,:)=4
m3h2x4(3,:)=8
m3h4x4(1,:)=4
m3h4x4(2,:)=4
m3h4x4(3,:)=16
m3h2x8(1,:)=2
m3h2x8(2,:)=8
m3h2x8(3,:)=16
m3h1x16(1,:)=1
m3h1x16(2,:)=16
m3h1x16(3,:)=16

n2h1(:)=1
n2h2(:)=2
n2h4(:)=4
n2h8(:)=8
n2h16(:)=16


end subroutine HOL_m3_init

!**********************************************************************

end module ol_tables_storage_pphtt_ew_ttxddxh_1_/**/REALKIND

! **********************************************************************
module ol_tensor_sum_storage_pphtt_ew_ttxddxh_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol, hcl, met
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
 use ol_data_types_/**/REALKIND, only: scalarbox 

  implicit none

  type(met), save :: M2L1R1

  ! Declarations of loop wave function tensors

  type(hol), save :: G0H1(1)
  type(hol), save :: G1H1(1)
  type(hol), save :: G2H1(1)
  type(hol), save :: G0H2(1)
  type(hol), save :: G1H2(40)
  type(hol), save :: G2H2(34)
  type(hol), save :: G0H4(1)
  type(hol), save :: G1H4(54)
  type(hol), save :: G2H4(14)
  type(hol), save :: G0H8(19)
  type(hol), save :: G1H8(34)
  type(hol), save :: G2H8(8)
  type(hol), save :: G0H16(15)
  type(hol), save :: G1H16(30)
  type(hcl), save, dimension(558) :: G0tensor
  type(hcl), save, dimension(270) :: G1tensor
  type(hcl), save, dimension(94) :: G2tensor
  type(hcl), save, dimension(4) :: G3tensor



  ! Declarations for on-the-fly tensor reduction
type (basis),      save :: RedBasis(48)
type (redset4),    save :: RedSet_4(30)
type (redset5),    save :: RedSet_5(6)
integer, save :: mass2set(0:1,11)
integer, save :: mass3set(0:2,32)
integer, save :: mass4set(0:3,20)
integer, save :: mass5set(0:4,4)



  ! Declarations for TI calls

  integer, save :: momenta_1(2)
  integer, save :: momenta_2(2)
  integer, save :: momenta_3(2)
  integer, save :: momenta_4(2)
  integer, save :: momenta_5(2)
  integer, save :: momenta_6(2)
  integer, save :: momenta_7(2)
  integer, save :: momenta_8(2)
  integer, save :: momenta_9(2)
  integer, save :: momenta_10(2)
  integer, save :: momenta_11(2)
  integer, save :: momenta_12(2)
  integer, save :: momenta_13(2)
  integer, save :: momenta_14(2)
  integer, save :: momenta_15(2)
  integer, save :: momenta_16(2)
  integer, save :: momenta_17(3)
  integer, save :: momenta_18(3)
  integer, save :: momenta_19(3)
  integer, save :: momenta_20(3)
  integer, save :: momenta_21(3)
  integer, save :: momenta_22(3)
  integer, save :: momenta_23(3)
  integer, save :: momenta_24(3)
  integer, save :: momenta_25(3)
  integer, save :: momenta_26(3)
  integer, save :: momenta_27(3)
  integer, save :: momenta_28(3)
  integer, save :: momenta_29(3)
  integer, save :: momenta_30(3)
  integer, save :: momenta_31(3)
  integer, save :: momenta_32(3)
  integer, save :: momenta_33(3)
  integer, save :: momenta_34(3)
  integer, save :: momenta_35(3)
  integer, save :: momenta_36(3)
  integer, save :: momenta_37(3)
  integer, save :: momenta_38(3)
  integer, save :: momenta_39(3)
  integer, save :: momenta_40(3)
  integer, save :: momenta_41(3)
  integer, save :: momenta_42(3)
  integer, save :: momenta_43(3)
  integer, save :: momenta_44(3)
  integer, save :: momenta_45(3)
  integer, save :: momenta_46(3)
  integer, save :: momenta_47(3)
  integer, save :: momenta_48(3)
  integer, save :: momenta_49(3)
  integer, save :: momenta_50(3)
  integer, save :: momenta_51(3)
  integer, save :: momenta_52(4)
  integer, save :: momenta_53(4)
  integer, save :: momenta_54(4)
  integer, save :: momenta_55(4)
  integer, save :: momenta_56(4)
  integer, save :: momenta_57(4)
  integer, save :: momenta_58(4)
  integer, save :: momenta_59(4)
  integer, save :: momenta_60(4)
  integer, save :: momenta_61(4)
  integer, save :: momenta_62(4)
  integer, save :: momenta_63(4)
  integer, save :: momenta_64(4)
  integer, save :: momenta_65(4)
  integer, save :: momenta_66(4)
  integer, save :: momenta_67(4)
  integer, save :: momenta_68(4)
  integer, save :: momenta_69(4)
  integer, save :: momenta_70(4)
  integer, save :: momenta_71(4)
  integer, save :: momenta_72(4)
  integer, save :: momenta_73(4)
  integer, save :: momenta_74(4)
  integer, save :: momenta_75(4)
  integer, save :: momenta_76(5)
  integer, save :: momenta_77(5)
  integer, save :: momenta_78(5)
  integer, save :: momenta_79(5)
  integer, save :: momenta_80(5)
  integer, save :: momenta_81(5)

  integer, save :: masses2_1(2)
  integer, save :: masses2_2(2)
  integer, save :: masses2_3(2)
  integer, save :: masses2_4(2)
  integer, save :: masses2_5(2)
  integer, save :: masses2_6(2)
  integer, save :: masses2_7(2)
  integer, save :: masses2_8(2)
  integer, save :: masses2_9(2)
  integer, save :: masses2_10(2)
  integer, save :: masses2_11(2)
  integer, save :: masses2_12(2)
  integer, save :: masses2_13(2)
  integer, save :: masses2_14(2)
  integer, save :: masses2_15(2)
  integer, save :: masses2_16(2)
  integer, save :: masses2_17(2)
  integer, save :: masses2_18(2)
  integer, save :: masses2_19(2)
  integer, save :: masses2_20(2)
  integer, save :: masses2_21(3)
  integer, save :: masses2_22(3)
  integer, save :: masses2_23(3)
  integer, save :: masses2_24(3)
  integer, save :: masses2_25(3)
  integer, save :: masses2_26(3)
  integer, save :: masses2_27(3)
  integer, save :: masses2_28(3)
  integer, save :: masses2_29(3)
  integer, save :: masses2_30(3)
  integer, save :: masses2_31(3)
  integer, save :: masses2_32(3)
  integer, save :: masses2_33(3)
  integer, save :: masses2_34(3)
  integer, save :: masses2_35(3)
  integer, save :: masses2_36(3)
  integer, save :: masses2_37(3)
  integer, save :: masses2_38(3)
  integer, save :: masses2_39(3)
  integer, save :: masses2_40(3)
  integer, save :: masses2_41(3)
  integer, save :: masses2_42(3)
  integer, save :: masses2_43(3)
  integer, save :: masses2_44(3)
  integer, save :: masses2_45(3)
  integer, save :: masses2_46(3)
  integer, save :: masses2_47(3)
  integer, save :: masses2_48(3)
  integer, save :: masses2_49(3)
  integer, save :: masses2_50(3)
  integer, save :: masses2_51(3)
  integer, save :: masses2_52(3)
  integer, save :: masses2_53(4)
  integer, save :: masses2_54(4)
  integer, save :: masses2_55(4)
  integer, save :: masses2_56(4)
  integer, save :: masses2_57(4)
  integer, save :: masses2_58(4)
  integer, save :: masses2_59(4)
  integer, save :: masses2_60(4)
  integer, save :: masses2_61(4)
  integer, save :: masses2_62(4)
  integer, save :: masses2_63(4)
  integer, save :: masses2_64(4)
  integer, save :: masses2_65(4)
  integer, save :: masses2_66(4)
  integer, save :: masses2_67(4)
  integer, save :: masses2_68(4)
  integer, save :: masses2_69(4)
  integer, save :: masses2_70(4)
  integer, save :: masses2_71(4)
  integer, save :: masses2_72(4)
  integer, save :: masses2_73(5)
  integer, save :: masses2_74(5)
  integer, save :: masses2_75(5)
  integer, save :: masses2_76(5)

type(scalarbox), save :: ScalarBoxes(39)

integer, save :: sbarray_1(5)
integer, save :: sbarray_2(5)
integer, save :: sbarray_3(5)
integer, save :: sbarray_4(5)
integer, save :: sbarray_5(5)
integer, save :: sbarray_6(5)
integer, save :: sbarray_7(5)
integer, save :: sbarray_8(5)
integer, save :: sbarray_9(5)
integer, save :: sbarray_10(5)

  type(hcl), save, dimension(227) :: T0sum
  type(hcl), save, dimension(10) :: T1sum


  contains

!**********************************************************************
subroutine HOL_memory_allocation_full()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_pphtt_ew_ttxddxh_1_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,1,G0H1,1)
  call hol_allocation(4,5,4,1,G1H1,1)
  call hol_allocation(4,15,4,1,G2H1,1)
  call hol_allocation(4,1,4,2,G0H2,1)
  call hol_allocation(4,5,4,2,G1H2,40)
  call hol_allocation(4,15,4,2,G2H2,34)
  call hol_allocation(4,1,4,4,G0H4,1)
  call hol_allocation(4,5,4,4,G1H4,54)
  call hol_allocation(4,15,4,4,G2H4,14)
  call hol_allocation(4,1,4,8,G0H8,19)
  call hol_allocation(4,5,4,8,G1H8,34)
  call hol_allocation(4,15,4,8,G2H8,8)
  call hol_allocation(4,1,4,16,G0H16,15)
  call hol_allocation(4,5,4,16,G1H16,30)


end subroutine HOL_memory_allocation_full

!**********************************************************************
subroutine HOL_memory_allocation_optimized()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_loop_storage_pphtt_ew_ttxddxh_1_/**/DREALKIND, only: nhel
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,min(nhel,1),G0H1,1)
  call hol_allocation(4,5,4,min(nhel,1),G1H1,1)
  call hol_allocation(4,15,4,min(nhel,1),G2H1,1)
  call hol_allocation(4,1,4,min(nhel,2),G0H2,1)
  call hol_allocation(4,5,4,min(nhel,2),G1H2,40)
  call hol_allocation(4,15,4,min(nhel,2),G2H2,34)
  call hol_allocation(4,1,4,min(nhel,4),G0H4,1)
  call hol_allocation(4,5,4,min(nhel,4),G1H4,54)
  call hol_allocation(4,15,4,min(nhel,4),G2H4,14)
  call hol_allocation(4,1,4,min(nhel,8),G0H8,19)
  call hol_allocation(4,5,4,min(nhel,8),G1H8,34)
  call hol_allocation(4,15,4,min(nhel,8),G2H8,8)
  call hol_allocation(4,1,4,min(nhel,16),G0H16,15)
  call hol_allocation(4,5,4,min(nhel,16),G1H16,30)


end subroutine HOL_memory_allocation_optimized

!**********************************************************************
subroutine HOL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_deallocation
  implicit none
  integer,   intent(in)    :: dmode

    call hol_deallocation(G0H1,1,dmode)
  call hol_deallocation(G1H1,1,dmode)
  call hol_deallocation(G2H1,1,dmode)
  call hol_deallocation(G0H2,1,dmode)
  call hol_deallocation(G1H2,40,dmode)
  call hol_deallocation(G2H2,34,dmode)
  call hol_deallocation(G0H4,1,dmode)
  call hol_deallocation(G1H4,54,dmode)
  call hol_deallocation(G2H4,14,dmode)
  call hol_deallocation(G0H8,19,dmode)
  call hol_deallocation(G1H8,34,dmode)
  call hol_deallocation(G2H8,8,dmode)
  call hol_deallocation(G0H16,15,dmode)
  call hol_deallocation(G1H16,30,dmode)


end subroutine HOL_memory_deallocation_/**/REALKIND

!**********************************************************************
subroutine HCL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

  call hcl_allocation(1,G0tensor, 558)
call hcl_allocation(5,G1tensor, 270)
call hcl_allocation(15,G2tensor, 94)
call hcl_allocation(35,G3tensor, 4)


end subroutine HCL_memory_allocation


!**********************************************************************
subroutine HCL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! deallocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_deallocation
  implicit none
  integer,   intent(in)    :: dmode

  call hcl_deallocation(G0tensor, 558,dmode)
call hcl_deallocation(G1tensor, 270,dmode)
call hcl_deallocation(G2tensor, 94,dmode)
call hcl_deallocation(G3tensor, 4,dmode)

    call hcl_deallocation(T0sum,227,dmode)
  call hcl_deallocation(T1sum,10,dmode)


end subroutine HCL_memory_deallocation_/**/REALKIND


!**********************************************************************
subroutine Tsum_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

    call hcl_allocation(1,T0sum,227)
  call hcl_allocation(5,T1sum,10)


end subroutine Tsum_memory_allocation


#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_pphtt_ew_ttxddxh_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 5
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_pphtt_ew_ttxddxh_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 1
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  use ol_parameters_init_/**/REALKIND, only: init_hcl
  implicit none
  integer :: i

  do i = 1,227
    call init_hcl(T0sum(i))
  end do
  do i = 1,10
    call init_hcl(T1sum(i))
  end do

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T1sum(1)%cmp, 4)
  call scale_one_tsum(T1sum(2)%cmp, 4)
  call scale_one_tsum(T1sum(3)%cmp, 4)
  call scale_one_tsum(T1sum(4)%cmp, 4)
  call scale_one_tsum(T1sum(5)%cmp, 4)
  call scale_one_tsum(T1sum(6)%cmp, 4)
  call scale_one_tsum(T1sum(7)%cmp, 4)
  call scale_one_tsum(T1sum(8)%cmp, 4)
  call scale_one_tsum(T1sum(9)%cmp, 4)
  call scale_one_tsum(T1sum(10)%cmp, 4)
  call scale_one_tsum(T0sum(1)%cmp, 2)
  call scale_one_tsum(T0sum(2)%cmp, 2)
  call scale_one_tsum(T0sum(3)%cmp, 2)
  call scale_one_tsum(T0sum(4)%cmp, 2)
  call scale_one_tsum(T0sum(5)%cmp, 2)
  call scale_one_tsum(T0sum(6)%cmp, 2)
  call scale_one_tsum(T0sum(7)%cmp, 2)
  call scale_one_tsum(T0sum(8)%cmp, 2)
  call scale_one_tsum(T0sum(9)%cmp, 2)
  call scale_one_tsum(T0sum(10)%cmp, 2)
  call scale_one_tsum(T0sum(11)%cmp, 2)
  call scale_one_tsum(T0sum(12)%cmp, 2)
  call scale_one_tsum(T0sum(13)%cmp, 2)
  call scale_one_tsum(T0sum(14)%cmp, 2)
  call scale_one_tsum(T0sum(15)%cmp, 2)
  call scale_one_tsum(T0sum(16)%cmp, 2)
  call scale_one_tsum(T0sum(17)%cmp, 2)
  call scale_one_tsum(T0sum(18)%cmp, 2)
  call scale_one_tsum(T0sum(19)%cmp, 2)
  call scale_one_tsum(T0sum(20)%cmp, 2)
  call scale_one_tsum(T0sum(21)%cmp, 2)
  call scale_one_tsum(T0sum(22)%cmp, 2)
  call scale_one_tsum(T0sum(23)%cmp, 2)
  call scale_one_tsum(T0sum(24)%cmp, 2)
  call scale_one_tsum(T0sum(25)%cmp, 2)
  call scale_one_tsum(T0sum(26)%cmp, 2)
  call scale_one_tsum(T0sum(27)%cmp, 2)
  call scale_one_tsum(T0sum(28)%cmp, 2)
  call scale_one_tsum(T0sum(29)%cmp, 2)
  call scale_one_tsum(T0sum(30)%cmp, 2)
  call scale_one_tsum(T0sum(31)%cmp, 2)
  call scale_one_tsum(T0sum(32)%cmp, 2)
  call scale_one_tsum(T0sum(33)%cmp, 2)
  call scale_one_tsum(T0sum(34)%cmp, 2)
  call scale_one_tsum(T0sum(35)%cmp, 2)
  call scale_one_tsum(T0sum(36)%cmp, 2)
  call scale_one_tsum(T0sum(37)%cmp, 2)
  call scale_one_tsum(T0sum(38)%cmp, 2)
  call scale_one_tsum(T0sum(39)%cmp, 2)
  call scale_one_tsum(T0sum(40)%cmp, 2)
  call scale_one_tsum(T0sum(41)%cmp, 2)
  call scale_one_tsum(T0sum(42)%cmp, 2)
  call scale_one_tsum(T0sum(43)%cmp, 2)
  call scale_one_tsum(T0sum(44)%cmp, 2)
  call scale_one_tsum(T0sum(45)%cmp, 2)
  call scale_one_tsum(T0sum(46)%cmp, 2)
  call scale_one_tsum(T0sum(47)%cmp, 2)
  call scale_one_tsum(T0sum(48)%cmp, 2)
  call scale_one_tsum(T0sum(49)%cmp, 2)
  call scale_one_tsum(T0sum(50)%cmp, 2)
  call scale_one_tsum(T0sum(51)%cmp, 2)
  call scale_one_tsum(T0sum(52)%cmp, 2)
  call scale_one_tsum(T0sum(53)%cmp, 2)
  call scale_one_tsum(T0sum(54)%cmp, 2)
  call scale_one_tsum(T0sum(55)%cmp, 0)
  call scale_one_tsum(T0sum(56)%cmp, 0)
  call scale_one_tsum(T0sum(57)%cmp, 0)
  call scale_one_tsum(T0sum(58)%cmp, 0)
  call scale_one_tsum(T0sum(59)%cmp, 0)
  call scale_one_tsum(T0sum(60)%cmp, 0)
  call scale_one_tsum(T0sum(61)%cmp, 0)
  call scale_one_tsum(T0sum(62)%cmp, 0)
  call scale_one_tsum(T0sum(63)%cmp, 0)
  call scale_one_tsum(T0sum(64)%cmp, 0)
  call scale_one_tsum(T0sum(65)%cmp, 0)
  call scale_one_tsum(T0sum(66)%cmp, 0)
  call scale_one_tsum(T0sum(67)%cmp, 0)
  call scale_one_tsum(T0sum(68)%cmp, 0)
  call scale_one_tsum(T0sum(69)%cmp, 0)
  call scale_one_tsum(T0sum(70)%cmp, 0)
  call scale_one_tsum(T0sum(71)%cmp, 0)
  call scale_one_tsum(T0sum(72)%cmp, 0)
  call scale_one_tsum(T0sum(73)%cmp, 0)
  call scale_one_tsum(T0sum(74)%cmp, 0)
  call scale_one_tsum(T0sum(75)%cmp, 0)
  call scale_one_tsum(T0sum(76)%cmp, 0)
  call scale_one_tsum(T0sum(77)%cmp, 0)
  call scale_one_tsum(T0sum(78)%cmp, 0)
  call scale_one_tsum(T0sum(79)%cmp, 0)
  call scale_one_tsum(T0sum(80)%cmp, 0)
  call scale_one_tsum(T0sum(81)%cmp, 0)
  call scale_one_tsum(T0sum(82)%cmp, 0)
  call scale_one_tsum(T0sum(83)%cmp, 0)
  call scale_one_tsum(T0sum(84)%cmp, 0)
  call scale_one_tsum(T0sum(85)%cmp, 0)
  call scale_one_tsum(T0sum(86)%cmp, 0)
  call scale_one_tsum(T0sum(87)%cmp, 0)
  call scale_one_tsum(T0sum(88)%cmp, 0)
  call scale_one_tsum(T0sum(89)%cmp, 0)
  call scale_one_tsum(T0sum(90)%cmp, 0)
  call scale_one_tsum(T0sum(91)%cmp, 0)
  call scale_one_tsum(T0sum(92)%cmp, 0)
  call scale_one_tsum(T0sum(93)%cmp, 0)
  call scale_one_tsum(T0sum(94)%cmp, 0)
  call scale_one_tsum(T0sum(95)%cmp, 0)
  call scale_one_tsum(T0sum(96)%cmp, 0)
  call scale_one_tsum(T0sum(97)%cmp, 0)
  call scale_one_tsum(T0sum(98)%cmp, 0)
  call scale_one_tsum(T0sum(99)%cmp, 0)
  call scale_one_tsum(T0sum(100)%cmp, 0)
  call scale_one_tsum(T0sum(101)%cmp, 0)
  call scale_one_tsum(T0sum(102)%cmp, 0)
  call scale_one_tsum(T0sum(103)%cmp, 0)
  call scale_one_tsum(T0sum(104)%cmp, 0)
  call scale_one_tsum(T0sum(105)%cmp, 0)
  call scale_one_tsum(T0sum(106)%cmp, 0)
  call scale_one_tsum(T0sum(107)%cmp, 0)
  call scale_one_tsum(T0sum(108)%cmp, 0)
  call scale_one_tsum(T0sum(109)%cmp, 0)
  call scale_one_tsum(T0sum(110)%cmp, 0)
  call scale_one_tsum(T0sum(111)%cmp, 0)
  call scale_one_tsum(T0sum(112)%cmp, 0)
  call scale_one_tsum(T0sum(113)%cmp, 0)
  call scale_one_tsum(T0sum(114)%cmp, 0)
  call scale_one_tsum(T0sum(115)%cmp, 0)
  call scale_one_tsum(T0sum(116)%cmp, 0)
  call scale_one_tsum(T0sum(117)%cmp, 0)
  call scale_one_tsum(T0sum(118)%cmp, 0)
  call scale_one_tsum(T0sum(119)%cmp, 0)
  call scale_one_tsum(T0sum(120)%cmp, 0)
  call scale_one_tsum(T0sum(121)%cmp, 0)
  call scale_one_tsum(T0sum(122)%cmp, 0)
  call scale_one_tsum(T0sum(123)%cmp, 0)
  call scale_one_tsum(T0sum(124)%cmp, 0)
  call scale_one_tsum(T0sum(125)%cmp, 0)
  call scale_one_tsum(T0sum(126)%cmp, 0)
  call scale_one_tsum(T0sum(127)%cmp, 0)
  call scale_one_tsum(T0sum(128)%cmp, 0)
  call scale_one_tsum(T0sum(129)%cmp, 0)
  call scale_one_tsum(T0sum(130)%cmp, 0)
  call scale_one_tsum(T0sum(131)%cmp, 0)
  call scale_one_tsum(T0sum(132)%cmp, 0)
  call scale_one_tsum(T0sum(133)%cmp, 0)
  call scale_one_tsum(T0sum(134)%cmp, 0)
  call scale_one_tsum(T0sum(135)%cmp, 0)
  call scale_one_tsum(T0sum(136)%cmp, 0)
  call scale_one_tsum(T0sum(137)%cmp, 0)
  call scale_one_tsum(T0sum(138)%cmp, 0)
  call scale_one_tsum(T0sum(139)%cmp, 0)
  call scale_one_tsum(T0sum(140)%cmp, 0)
  call scale_one_tsum(T0sum(141)%cmp, 0)
  call scale_one_tsum(T0sum(142)%cmp, 0)
  call scale_one_tsum(T0sum(143)%cmp, 0)
  call scale_one_tsum(T0sum(144)%cmp, 0)
  call scale_one_tsum(T0sum(145)%cmp, 0)
  call scale_one_tsum(T0sum(146)%cmp, 0)
  call scale_one_tsum(T0sum(147)%cmp, 0)
  call scale_one_tsum(T0sum(148)%cmp, 0)
  call scale_one_tsum(T0sum(149)%cmp, 0)
  call scale_one_tsum(T0sum(150)%cmp, 0)
  call scale_one_tsum(T0sum(151)%cmp, 0)
  call scale_one_tsum(T0sum(152)%cmp, 0)
  call scale_one_tsum(T0sum(153)%cmp, 0)
  call scale_one_tsum(T0sum(154)%cmp, 0)
  call scale_one_tsum(T0sum(155)%cmp, 0)
  call scale_one_tsum(T0sum(156)%cmp, -2)
  call scale_one_tsum(T0sum(157)%cmp, -2)
  call scale_one_tsum(T0sum(158)%cmp, -2)
  call scale_one_tsum(T0sum(159)%cmp, -2)
  call scale_one_tsum(T0sum(160)%cmp, -2)
  call scale_one_tsum(T0sum(161)%cmp, -2)
  call scale_one_tsum(T0sum(162)%cmp, -2)
  call scale_one_tsum(T0sum(163)%cmp, -2)
  call scale_one_tsum(T0sum(164)%cmp, -2)
  call scale_one_tsum(T0sum(165)%cmp, -2)
  call scale_one_tsum(T0sum(166)%cmp, -2)
  call scale_one_tsum(T0sum(167)%cmp, -2)
  call scale_one_tsum(T0sum(168)%cmp, -2)
  call scale_one_tsum(T0sum(169)%cmp, -2)
  call scale_one_tsum(T0sum(170)%cmp, -2)
  call scale_one_tsum(T0sum(171)%cmp, -2)
  call scale_one_tsum(T0sum(172)%cmp, -2)
  call scale_one_tsum(T0sum(173)%cmp, -2)
  call scale_one_tsum(T0sum(174)%cmp, -2)
  call scale_one_tsum(T0sum(175)%cmp, -2)
  call scale_one_tsum(T0sum(176)%cmp, -2)
  call scale_one_tsum(T0sum(177)%cmp, -2)
  call scale_one_tsum(T0sum(178)%cmp, -2)
  call scale_one_tsum(T0sum(179)%cmp, -2)
  call scale_one_tsum(T0sum(180)%cmp, -2)
  call scale_one_tsum(T0sum(181)%cmp, -2)
  call scale_one_tsum(T0sum(182)%cmp, -2)
  call scale_one_tsum(T0sum(183)%cmp, -2)
  call scale_one_tsum(T0sum(184)%cmp, -2)
  call scale_one_tsum(T0sum(185)%cmp, -2)
  call scale_one_tsum(T0sum(186)%cmp, -2)
  call scale_one_tsum(T0sum(187)%cmp, -2)
  call scale_one_tsum(T0sum(188)%cmp, -2)
  call scale_one_tsum(T0sum(189)%cmp, -2)
  call scale_one_tsum(T0sum(190)%cmp, -2)
  call scale_one_tsum(T0sum(191)%cmp, -2)
  call scale_one_tsum(T0sum(192)%cmp, -2)
  call scale_one_tsum(T0sum(193)%cmp, -2)
  call scale_one_tsum(T0sum(194)%cmp, -2)
  call scale_one_tsum(T0sum(195)%cmp, -2)
  call scale_one_tsum(T0sum(196)%cmp, -2)
  call scale_one_tsum(T0sum(197)%cmp, -2)
  call scale_one_tsum(T0sum(198)%cmp, -2)
  call scale_one_tsum(T0sum(199)%cmp, -2)
  call scale_one_tsum(T0sum(200)%cmp, -2)
  call scale_one_tsum(T0sum(201)%cmp, -2)
  call scale_one_tsum(T0sum(202)%cmp, -2)
  call scale_one_tsum(T0sum(203)%cmp, -2)
  call scale_one_tsum(T0sum(204)%cmp, -2)
  call scale_one_tsum(T0sum(205)%cmp, -2)
  call scale_one_tsum(T0sum(206)%cmp, -2)
  call scale_one_tsum(T0sum(207)%cmp, -2)
  call scale_one_tsum(T0sum(208)%cmp, -2)
  call scale_one_tsum(T0sum(209)%cmp, -2)
  call scale_one_tsum(T0sum(210)%cmp, -2)
  call scale_one_tsum(T0sum(211)%cmp, -2)
  call scale_one_tsum(T0sum(212)%cmp, -2)
  call scale_one_tsum(T0sum(213)%cmp, -2)
  call scale_one_tsum(T0sum(214)%cmp, -2)
  call scale_one_tsum(T0sum(215)%cmp, -2)
  call scale_one_tsum(T0sum(216)%cmp, -2)
  call scale_one_tsum(T0sum(217)%cmp, -2)
  call scale_one_tsum(T0sum(218)%cmp, -2)
  call scale_one_tsum(T0sum(219)%cmp, -2)
  call scale_one_tsum(T0sum(220)%cmp, -2)
  call scale_one_tsum(T0sum(221)%cmp, -2)
  call scale_one_tsum(T0sum(222)%cmp, -2)
  call scale_one_tsum(T0sum(223)%cmp, -2)
  call scale_one_tsum(T0sum(224)%cmp, -2)
  call scale_one_tsum(T0sum(225)%cmp, -2)
  call scale_one_tsum(T0sum(226)%cmp, -2)
  call scale_one_tsum(T0sum(227)%cmp, -2)

end subroutine scale_tensor_sum

! **********************************************************************
subroutine set_integral_masses_and_momenta()
! **********************************************************************

  use ol_parameters_decl_/**/REALKIND
  momenta_1 = [ 0, 0 ]
  momenta_2 = [ 16, 15 ]
  momenta_3 = [ 17, 14 ]
  momenta_4 = [ 18, 13 ]
  momenta_5 = [ 19, 12 ]
  momenta_6 = [ 20, 11 ]
  momenta_7 = [ 21, 10 ]
  momenta_8 = [ 22, 9 ]
  momenta_9 = [ 23, 8 ]
  momenta_10 = [ 24, 7 ]
  momenta_11 = [ 25, 6 ]
  momenta_12 = [ 26, 5 ]
  momenta_13 = [ 27, 4 ]
  momenta_14 = [ 28, 3 ]
  momenta_15 = [ 29, 2 ]
  momenta_16 = [ 30, 1 ]
  momenta_17 = [ 16, 1, 14 ]
  momenta_18 = [ 16, 2, 13 ]
  momenta_19 = [ 16, 3, 12 ]
  momenta_20 = [ 16, 4, 11 ]
  momenta_21 = [ 16, 5, 10 ]
  momenta_22 = [ 16, 7, 8 ]
  momenta_23 = [ 16, 9, 6 ]
  momenta_24 = [ 16, 11, 4 ]
  momenta_25 = [ 16, 13, 2 ]
  momenta_26 = [ 17, 2, 12 ]
  momenta_27 = [ 17, 4, 10 ]
  momenta_28 = [ 17, 6, 8 ]
  momenta_29 = [ 17, 8, 6 ]
  momenta_30 = [ 17, 10, 4 ]
  momenta_31 = [ 17, 12, 2 ]
  momenta_32 = [ 18, 1, 12 ]
  momenta_33 = [ 18, 5, 8 ]
  momenta_34 = [ 18, 9, 4 ]
  momenta_35 = [ 19, 4, 8 ]
  momenta_36 = [ 19, 8, 4 ]
  momenta_37 = [ 20, 1, 10 ]
  momenta_38 = [ 20, 2, 9 ]
  momenta_39 = [ 20, 3, 8 ]
  momenta_40 = [ 21, 2, 8 ]
  momenta_41 = [ 21, 8, 2 ]
  momenta_42 = [ 22, 1, 8 ]
  momenta_43 = [ 24, 1, 6 ]
  momenta_44 = [ 24, 2, 5 ]
  momenta_45 = [ 24, 3, 4 ]
  momenta_46 = [ 24, 4, 3 ]
  momenta_47 = [ 25, 2, 4 ]
  momenta_48 = [ 25, 4, 2 ]
  momenta_49 = [ 26, 1, 4 ]
  momenta_50 = [ 28, 1, 2 ]
  momenta_51 = [ 28, 2, 1 ]
  momenta_52 = [ 16, 1, 2, 12 ]
  momenta_53 = [ 16, 1, 4, 10 ]
  momenta_54 = [ 16, 1, 6, 8 ]
  momenta_55 = [ 16, 1, 8, 6 ]
  momenta_56 = [ 16, 1, 10, 4 ]
  momenta_57 = [ 16, 1, 12, 2 ]
  momenta_58 = [ 16, 2, 1, 12 ]
  momenta_59 = [ 16, 2, 5, 8 ]
  momenta_60 = [ 16, 2, 9, 4 ]
  momenta_61 = [ 16, 3, 4, 8 ]
  momenta_62 = [ 16, 3, 8, 4 ]
  momenta_63 = [ 16, 4, 3, 8 ]
  momenta_64 = [ 16, 5, 8, 2 ]
  momenta_65 = [ 16, 9, 4, 2 ]
  momenta_66 = [ 17, 2, 4, 8 ]
  momenta_67 = [ 17, 2, 8, 4 ]
  momenta_68 = [ 17, 4, 8, 2 ]
  momenta_69 = [ 17, 8, 4, 2 ]
  momenta_70 = [ 18, 1, 4, 8 ]
  momenta_71 = [ 18, 1, 8, 4 ]
  momenta_72 = [ 20, 1, 2, 8 ]
  momenta_73 = [ 20, 2, 1, 8 ]
  momenta_74 = [ 24, 1, 2, 4 ]
  momenta_75 = [ 24, 2, 1, 4 ]
  momenta_76 = [ 16, 1, 2, 4, 8 ]
  momenta_77 = [ 16, 1, 2, 8, 4 ]
  momenta_78 = [ 16, 1, 4, 8, 2 ]
  momenta_79 = [ 16, 1, 8, 4, 2 ]
  momenta_80 = [ 16, 2, 1, 4, 8 ]
  momenta_81 = [ 16, 2, 1, 8, 4 ]

  masses2_1 = [ 0, 0 ]
  masses2_2 = [ nMB, 0 ]
  masses2_3 = [ nMH, 0 ]
  masses2_4 = [ nMT, 0 ]
  masses2_5 = [ nMW, 0 ]
  masses2_6 = [ nMZ, 0 ]
  masses2_7 = [ nMB, nMB ]
  masses2_8 = [ nMW, nMB ]
  masses2_9 = [ nMH, nMH ]
  masses2_10 = [ nMT, nMH ]
  masses2_11 = [ 0, nMT ]
  masses2_12 = [ nMH, nMT ]
  masses2_13 = [ nMT, nMT ]
  masses2_14 = [ nMZ, nMT ]
  masses2_15 = [ 0, nMW ]
  masses2_16 = [ nMB, nMW ]
  masses2_17 = [ nMW, nMW ]
  masses2_18 = [ 0, nMZ ]
  masses2_19 = [ nMT, nMZ ]
  masses2_20 = [ nMZ, nMZ ]
  masses2_21 = [ 0, 0, 0 ]
  masses2_22 = [ nMT, 0, 0 ]
  masses2_23 = [ nMW, 0, 0 ]
  masses2_24 = [ nMZ, 0, 0 ]
  masses2_25 = [ nMT, 0, nMT ]
  masses2_26 = [ 0, 0, nMW ]
  masses2_27 = [ 0, 0, nMZ ]
  masses2_28 = [ nMT, 0, nMZ ]
  masses2_29 = [ nMB, nMB, nMB ]
  masses2_30 = [ nMW, nMB, nMB ]
  masses2_31 = [ nMB, nMB, nMW ]
  masses2_32 = [ nMH, nMH, nMT ]
  masses2_33 = [ nMT, nMH, nMT ]
  masses2_34 = [ 0, nMT, 0 ]
  masses2_35 = [ nMT, nMT, 0 ]
  masses2_36 = [ nMZ, nMT, 0 ]
  masses2_37 = [ nMT, nMT, nMH ]
  masses2_38 = [ nMH, nMT, nMT ]
  masses2_39 = [ nMT, nMT, nMT ]
  masses2_40 = [ nMZ, nMT, nMT ]
  masses2_41 = [ 0, nMT, nMZ ]
  masses2_42 = [ nMT, nMT, nMZ ]
  masses2_43 = [ 0, nMW, 0 ]
  masses2_44 = [ nMW, nMW, 0 ]
  masses2_45 = [ nMB, nMW, nMB ]
  masses2_46 = [ nMW, nMW, nMB ]
  masses2_47 = [ 0, nMZ, 0 ]
  masses2_48 = [ nMT, nMZ, 0 ]
  masses2_49 = [ nMZ, nMZ, 0 ]
  masses2_50 = [ 0, nMZ, nMT ]
  masses2_51 = [ nMT, nMZ, nMT ]
  masses2_52 = [ nMZ, nMZ, nMT ]
  masses2_53 = [ nMT, 0, 0, 0 ]
  masses2_54 = [ nMT, 0, 0, nMZ ]
  masses2_55 = [ nMB, nMB, nMW, nMB ]
  masses2_56 = [ nMH, nMH, nMT, nMT ]
  masses2_57 = [ 0, nMT, 0, 0 ]
  masses2_58 = [ nMT, nMT, 0, 0 ]
  masses2_59 = [ nMZ, nMT, 0, 0 ]
  masses2_60 = [ nMT, nMT, 0, nMT ]
  masses2_61 = [ nMT, nMT, 0, nMZ ]
  masses2_62 = [ nMT, nMT, nMH, nMT ]
  masses2_63 = [ 0, nMT, nMZ, 0 ]
  masses2_64 = [ nMT, nMT, nMZ, 0 ]
  masses2_65 = [ nMT, nMT, nMZ, nMT ]
  masses2_66 = [ nMW, nMW, 0, 0 ]
  masses2_67 = [ nMW, nMW, nMB, nMB ]
  masses2_68 = [ nMT, nMZ, 0, 0 ]
  masses2_69 = [ nMZ, nMZ, 0, 0 ]
  masses2_70 = [ 0, nMZ, nMT, 0 ]
  masses2_71 = [ nMZ, nMZ, nMT, 0 ]
  masses2_72 = [ nMZ, nMZ, nMT, nMT ]
  masses2_73 = [ nMT, nMT, 0, 0, 0 ]
  masses2_74 = [ nMT, nMT, 0, 0, nMZ ]
  masses2_75 = [ nMT, nMT, nMZ, 0, 0 ]
  masses2_76 = [ nMZ, nMZ, nMT, 0, 0 ]


end subroutine  set_integral_masses_and_momenta

! **********************************************************************
subroutine integrate_tensor_sum(M2out)
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/REALKIND, only: init_met, add_met, met_to_real
  use ol_loop_routines_/**/REALKIND, only: TI_call_OL
  implicit none
  real(REALKIND), intent(out) :: M2out
  type(met) :: M2
  call init_met(M2)

sbarray_1 = [1, 2, 3, 4, 5]
sbarray_2 = [6, 7, 8, 4, 9]
sbarray_3 = [10, 2, 11, 12, 13]
sbarray_4 = [14, 7, 15, 12, 16]
sbarray_5 = [17, 18, 19, 20, 21]
sbarray_6 = [22, 18, 23, 24, 25]
sbarray_7 = [26, 27, 28, 20, 29]
sbarray_8 = [30, 31, 19, 32, 33]
sbarray_9 = [34, 31, 23, 35, 36]
sbarray_10 = [37, 38, 28, 32, 39]


#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif
  call TI_call_OL(0,0, momenta_58, masses2_71, T0sum(1), M2,[4], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_52, masses2_71, T0sum(2), M2,[12], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_70, masses2_57, T0sum(3), M2,[21], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_53, masses2_58, T0sum(4), M2,[20], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_70, masses2_63, T0sum(5), M2,[25], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_53, masses2_64, T0sum(6), M2,[24], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_70, masses2_59, T0sum(7), M2,[1], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_71, masses2_57, T0sum(8), M2,[33], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_55, masses2_58, T0sum(9), M2,[32], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_71, masses2_63, T0sum(10), M2,[36], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_55, masses2_64, T0sum(11), M2,[35], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_71, masses2_59, T0sum(12), M2,[6], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_75, masses2_70, T0sum(13), M2,[5], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_61, masses2_69, T0sum(14), M2,[2], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_59, masses2_71, T0sum(15), M2,[3], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_73, masses2_70, T0sum(16), M2,[9], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_62, masses2_69, T0sum(17), M2,[7], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_60, masses2_71, T0sum(18), M2,[8], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_74, masses2_70, T0sum(19), M2,[13], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_66, masses2_59, T0sum(20), M2,[10], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_54, masses2_71, T0sum(21), M2,[11], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_72, masses2_70, T0sum(22), M2,[16], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_67, masses2_59, T0sum(23), M2,[14], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_56, masses2_71, T0sum(24), M2,[15], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_68, masses2_53, T0sum(25), M2,[17], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_64, masses2_58, T0sum(26), M2,[18], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_57, masses2_58, T0sum(27), M2,[19], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_68, masses2_68, T0sum(28), M2,[22], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_57, masses2_64, T0sum(29), M2,[23], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_68, masses2_54, T0sum(30), M2,[26], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_64, masses2_61, T0sum(31), M2,[27], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_57, masses2_61, T0sum(32), M2,[28], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_69, masses2_53, T0sum(33), M2,[30], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_65, masses2_58, T0sum(34), M2,[31], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_69, masses2_68, T0sum(35), M2,[34], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_69, masses2_54, T0sum(36), M2,[37], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_65, masses2_61, T0sum(37), M2,[38], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_63, masses2_69, T0sum(38), M2)
  call TI_call_OL(0,0, momenta_63, masses2_66, T0sum(39), M2)
  call TI_call_OL(0,0, momenta_57, masses2_56, T0sum(40), M2)
  call TI_call_OL(0,0, momenta_66, masses2_57, T0sum(41), M2,[30], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_66, masses2_63, T0sum(42), M2,[37], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_67, masses2_57, T0sum(43), M2,[17], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_67, masses2_63, T0sum(44), M2,[26], ScalarBoxes(:))
  call TI_call_OL(0,0, momenta_57, masses2_72, T0sum(45), M2)
  call TI_call_OL(0,0, momenta_57, masses2_67, T0sum(46), M2)
  call TI_call_OL(0,0, momenta_52, masses2_62, T0sum(47), M2)
  call TI_call_OL(0,0, momenta_52, masses2_65, T0sum(48), M2)
  call TI_call_OL(0,0, momenta_52, masses2_55, T0sum(49), M2)
  call TI_call_OL(0,0, momenta_52, masses2_60, T0sum(50), M2)
  call TI_call_OL(0,0, momenta_58, masses2_62, T0sum(51), M2)
  call TI_call_OL(0,0, momenta_58, masses2_65, T0sum(52), M2)
  call TI_call_OL(0,0, momenta_58, masses2_55, T0sum(53), M2)
  call TI_call_OL(0,0, momenta_58, masses2_60, T0sum(54), M2)
  call TI_call_OL(0,0, momenta_17, masses2_52, T0sum(55), M2)
  call TI_call_OL(0,0, momenta_17, masses2_46, T0sum(56), M2)
  call TI_call_OL(0,0, momenta_32, masses2_34, T0sum(57), M2)
  call TI_call_OL(0,0, momenta_17, masses2_35, T0sum(58), M2)
  call TI_call_OL(0,0, momenta_50, masses2_37, T0sum(59), M2)
  call TI_call_OL(0,0, momenta_17, masses2_37, T0sum(60), M2)
  call TI_call_OL(0,0, momenta_50, masses2_42, T0sum(61), M2)
  call TI_call_OL(0,0, momenta_17, masses2_42, T0sum(62), M2)
  call TI_call_OL(0,0, momenta_50, masses2_31, T0sum(63), M2)
  call TI_call_OL(0,0, momenta_17, masses2_31, T0sum(64), M2)
  call TI_call_OL(0,0, momenta_50, masses2_35, T0sum(65), M2)
  call TI_call_OL(0,0, momenta_51, masses2_37, T0sum(66), M2)
  call TI_call_OL(0,0, momenta_18, masses2_37, T0sum(67), M2)
  call TI_call_OL(0,0, momenta_51, masses2_42, T0sum(68), M2)
  call TI_call_OL(0,0, momenta_18, masses2_42, T0sum(69), M2)
  call TI_call_OL(0,0, momenta_51, masses2_31, T0sum(70), M2)
  call TI_call_OL(0,0, momenta_18, masses2_31, T0sum(71), M2)
  call TI_call_OL(0,0, momenta_51, masses2_35, T0sum(72), M2)
  call TI_call_OL(0,0, momenta_18, masses2_35, T0sum(73), M2)
  call TI_call_OL(0,0, momenta_51, masses2_50, T0sum(74), M2)
  call TI_call_OL(0,0, momenta_32, masses2_36, T0sum(75), M2)
  call TI_call_OL(0,0, momenta_19, masses2_49, T0sum(76), M2)
  call TI_call_OL(0,0, momenta_18, masses2_52, T0sum(77), M2)
  call TI_call_OL(0,0, momenta_50, masses2_50, T0sum(78), M2)
  call TI_call_OL(0,0, momenta_26, masses2_36, T0sum(79), M2)
  call TI_call_OL(0,0, momenta_49, masses2_34, T0sum(80), M2)
  call TI_call_OL(0,0, momenta_35, masses2_21, T0sum(81), M2)
  call TI_call_OL(0,0, momenta_33, masses2_34, T0sum(82), M2)
  call TI_call_OL(0,0, momenta_27, masses2_22, T0sum(83), M2)
  call TI_call_OL(0,0, momenta_21, masses2_35, T0sum(84), M2)
  call TI_call_OL(0,0, momenta_49, masses2_41, T0sum(85), M2)
  call TI_call_OL(0,0, momenta_35, masses2_47, T0sum(86), M2)
  call TI_call_OL(0,0, momenta_32, masses2_41, T0sum(87), M2)
  call TI_call_OL(0,0, momenta_27, masses2_48, T0sum(88), M2)
  call TI_call_OL(0,0, momenta_35, masses2_24, T0sum(89), M2)
  call TI_call_OL(0,0, momenta_33, masses2_36, T0sum(90), M2)
  call TI_call_OL(0,0, momenta_42, masses2_34, T0sum(91), M2)
  call TI_call_OL(0,0, momenta_36, masses2_21, T0sum(92), M2)
  call TI_call_OL(0,0, momenta_34, masses2_34, T0sum(93), M2)
  call TI_call_OL(0,0, momenta_29, masses2_22, T0sum(94), M2)
  call TI_call_OL(0,0, momenta_23, masses2_35, T0sum(95), M2)
  call TI_call_OL(0,0, momenta_42, masses2_41, T0sum(96), M2)
  call TI_call_OL(0,0, momenta_36, masses2_47, T0sum(97), M2)
  call TI_call_OL(0,0, momenta_29, masses2_48, T0sum(98), M2)
  call TI_call_OL(0,0, momenta_36, masses2_24, T0sum(99), M2)
  call TI_call_OL(0,0, momenta_34, masses2_36, T0sum(100), M2)
  call TI_call_OL(0,0, momenta_45, masses2_47, T0sum(101), M2)
  call TI_call_OL(0,0, momenta_44, masses2_50, T0sum(102), M2)
  call TI_call_OL(0,0, momenta_22, masses2_49, T0sum(103), M2)
  call TI_call_OL(0,0, momenta_39, masses2_47, T0sum(104), M2)
  call TI_call_OL(0,0, momenta_38, masses2_50, T0sum(105), M2)
  call TI_call_OL(0,0, momenta_24, masses2_49, T0sum(106), M2)
  call TI_call_OL(0,0, momenta_47, masses2_34, T0sum(107), M2)
  call TI_call_OL(0,0, momenta_43, masses2_50, T0sum(108), M2)
  call TI_call_OL(0,0, momenta_28, masses2_36, T0sum(109), M2)
  call TI_call_OL(0,0, momenta_40, masses2_34, T0sum(110), M2)
  call TI_call_OL(0,0, momenta_37, masses2_50, T0sum(111), M2)
  call TI_call_OL(0,0, momenta_30, masses2_36, T0sum(112), M2)
  call TI_call_OL(0,0, momenta_41, masses2_22, T0sum(113), M2)
  call TI_call_OL(0,0, momenta_31, masses2_22, T0sum(114), M2)
  call TI_call_OL(0,0, momenta_25, masses2_35, T0sum(115), M2)
  call TI_call_OL(0,0, momenta_31, masses2_48, T0sum(116), M2)
  call TI_call_OL(0,0, momenta_41, masses2_28, T0sum(117), M2)
  call TI_call_OL(0,0, momenta_31, masses2_28, T0sum(118), M2)
  call TI_call_OL(0,0, momenta_25, masses2_42, T0sum(119), M2)
  call TI_call_OL(0,0, momenta_48, masses2_22, T0sum(120), M2)
  call TI_call_OL(0,0, momenta_48, masses2_28, T0sum(121), M2)
  call TI_call_OL(0,0, momenta_46, masses2_47, T0sum(122), M2)
  call TI_call_OL(0,0, momenta_39, masses2_24, T0sum(123), M2)
  call TI_call_OL(0,0, momenta_20, masses2_49, T0sum(124), M2)
  call TI_call_OL(0,0, momenta_46, masses2_43, T0sum(125), M2)
  call TI_call_OL(0,0, momenta_39, masses2_23, T0sum(126), M2)
  call TI_call_OL(0,0, momenta_22, masses2_44, T0sum(127), M2)
  call TI_call_OL(0,0, momenta_20, masses2_44, T0sum(128), M2)
  call TI_call_OL(0,0, momenta_32, masses2_33, T0sum(129), M2)
  call TI_call_OL(0,0, momenta_31, masses2_38, T0sum(130), M2)
  call TI_call_OL(0,0, momenta_25, masses2_32, T0sum(131), M2)
  call TI_call_OL(0,0, momenta_17, masses2_32, T0sum(132), M2)
  call TI_call_OL(0,0, momenta_28, masses2_34, T0sum(133), M2)
  call TI_call_OL(0,0, momenta_26, masses2_34, T0sum(134), M2)
  call TI_call_OL(0,0, momenta_47, masses2_41, T0sum(135), M2)
  call TI_call_OL(0,0, momenta_26, masses2_41, T0sum(136), M2)
  call TI_call_OL(0,0, momenta_30, masses2_34, T0sum(137), M2)
  call TI_call_OL(0,0, momenta_40, masses2_41, T0sum(138), M2)
  call TI_call_OL(0,0, momenta_32, masses2_51, T0sum(139), M2)
  call TI_call_OL(0,0, momenta_31, masses2_40, T0sum(140), M2)
  call TI_call_OL(0,0, momenta_25, masses2_52, T0sum(141), M2)
  call TI_call_OL(0,0, momenta_32, masses2_45, T0sum(142), M2)
  call TI_call_OL(0,0, momenta_31, masses2_30, T0sum(143), M2)
  call TI_call_OL(0,0, momenta_25, masses2_46, T0sum(144), M2)
  call TI_call_OL(0,0, momenta_26, masses2_33, T0sum(145), M2)
  call TI_call_OL(0,0, momenta_19, masses2_39, T0sum(146), M2)
  call TI_call_OL(0,0, momenta_26, masses2_51, T0sum(147), M2)
  call TI_call_OL(0,0, momenta_26, masses2_45, T0sum(148), M2)
  call TI_call_OL(0,0, momenta_19, masses2_29, T0sum(149), M2)
  call TI_call_OL(0,0, momenta_26, masses2_25, T0sum(150), M2)
  call TI_call_OL(0,0, momenta_32, masses2_25, T0sum(151), M2)
  call TI_call_OL(0,0, momenta_18, masses2_32, T0sum(152), M2)
  call TI_call_OL(0,0, momenta_18, masses2_46, T0sum(153), M2)
  call TI_call_OL(0,0, momenta_35, masses2_27, T0sum(154), M2)
  call TI_call_OL(0,0, momenta_35, masses2_26, T0sum(155), M2)
  call TI_call_OL(0,0, momenta_16, masses2_19, T0sum(156), M2)
  call TI_call_OL(0,0, momenta_3, masses2_14, T0sum(157), M2)
  call TI_call_OL(0,0, momenta_2, masses2_20, T0sum(158), M2)
  call TI_call_OL(0,0, momenta_1, masses2_6, T0sum(159), M2)
  call TI_call_OL(0,0, momenta_1, masses2_4, T0sum(160), M2)
  call TI_call_OL(0,0, momenta_16, masses2_16, T0sum(161), M2)
  call TI_call_OL(0,0, momenta_3, masses2_8, T0sum(162), M2)
  call TI_call_OL(0,0, momenta_2, masses2_17, T0sum(163), M2)
  call TI_call_OL(0,0, momenta_1, masses2_5, T0sum(164), M2)
  call TI_call_OL(0,0, momenta_1, masses2_2, T0sum(165), M2)
  call TI_call_OL(0,0, momenta_16, masses2_11, T0sum(166), M2)
  call TI_call_OL(0,0, momenta_5, masses2_1, T0sum(167), M2)
  call TI_call_OL(0,0, momenta_4, masses2_11, T0sum(168), M2)
  call TI_call_OL(0,0, momenta_3, masses2_4, T0sum(169), M2)
  call TI_call_OL(0,0, momenta_2, masses2_13, T0sum(170), M2)
  call TI_call_OL(0,0, momenta_16, masses2_12, T0sum(171), M2)
  call TI_call_OL(0,0, momenta_15, masses2_10, T0sum(172), M2)
  call TI_call_OL(0,0, momenta_14, masses2_13, T0sum(173), M2)
  call TI_call_OL(0,0, momenta_1, masses2_3, T0sum(174), M2)
  call TI_call_OL(0,0, momenta_3, masses2_10, T0sum(175), M2)
  call TI_call_OL(0,0, momenta_16, masses2_14, T0sum(176), M2)
  call TI_call_OL(0,0, momenta_15, masses2_19, T0sum(177), M2)
  call TI_call_OL(0,0, momenta_3, masses2_19, T0sum(178), M2)
  call TI_call_OL(0,0, momenta_16, masses2_8, T0sum(179), M2)
  call TI_call_OL(0,0, momenta_15, masses2_16, T0sum(180), M2)
  call TI_call_OL(0,0, momenta_14, masses2_7, T0sum(181), M2)
  call TI_call_OL(0,0, momenta_3, masses2_16, T0sum(182), M2)
  call TI_call_OL(0,0, momenta_2, masses2_7, T0sum(183), M2)
  call TI_call_OL(0,0, momenta_15, masses2_4, T0sum(184), M2)
  call TI_call_OL(0,0, momenta_15, masses2_12, T0sum(185), M2)
  call TI_call_OL(0,0, momenta_16, masses2_10, T0sum(186), M2)
  call TI_call_OL(0,0, momenta_4, masses2_10, T0sum(187), M2)
  call TI_call_OL(0,0, momenta_15, masses2_14, T0sum(188), M2)
  call TI_call_OL(0,0, momenta_4, masses2_19, T0sum(189), M2)
  call TI_call_OL(0,0, momenta_15, masses2_8, T0sum(190), M2)
  call TI_call_OL(0,0, momenta_4, masses2_16, T0sum(191), M2)
  call TI_call_OL(0,0, momenta_15, masses2_11, T0sum(192), M2)
  call TI_call_OL(0,0, momenta_16, masses2_4, T0sum(193), M2)
  call TI_call_OL(0,0, momenta_4, masses2_4, T0sum(194), M2)
  call TI_call_OL(0,0, momenta_4, masses2_14, T0sum(195), M2)
  call TI_call_OL(0,0, momenta_13, masses2_1, T0sum(196), M2)
  call TI_call_OL(0,0, momenta_9, masses2_1, T0sum(197), M2)
  call TI_call_OL(0,0, momenta_5, masses2_13, T0sum(198), M2)
  call TI_call_OL(0,0, momenta_3, masses2_11, T0sum(199), M2)
  call TI_call_OL(0,0, momenta_5, masses2_7, T0sum(200), M2)
  call TI_call_OL(0,0, momenta_4, masses2_8, T0sum(201), M2)
  call TI_call_OL(0,0, momenta_13, masses2_6, T0sum(202), M2)
  call TI_call_OL(0,0, momenta_9, masses2_18, T0sum(203), M2)
  call TI_call_OL(0,0, momenta_13, masses2_5, T0sum(204), M2)
  call TI_call_OL(0,0, momenta_9, masses2_15, T0sum(205), M2)
  call TI_call_OL(0,0, momenta_14, masses2_18, T0sum(206), M2)
  call TI_call_OL(0,0, momenta_5, masses2_6, T0sum(207), M2)
  call TI_call_OL(0,0, momenta_12, masses2_11, T0sum(208), M2)
  call TI_call_OL(0,0, momenta_7, masses2_4, T0sum(209), M2)
  call TI_call_OL(0,0, momenta_13, masses2_18, T0sum(210), M2)
  call TI_call_OL(0,0, momenta_5, masses2_18, T0sum(211), M2)
  call TI_call_OL(0,0, momenta_9, masses2_6, T0sum(212), M2)
  call TI_call_OL(0,0, momenta_8, masses2_11, T0sum(213), M2)
  call TI_call_OL(0,0, momenta_11, masses2_4, T0sum(214), M2)
  call TI_call_OL(0,0, momenta_10, masses2_18, T0sum(215), M2)
  call TI_call_OL(0,0, momenta_6, masses2_18, T0sum(216), M2)
  call TI_call_OL(0,0, momenta_11, masses2_11, T0sum(217), M2)
  call TI_call_OL(0,0, momenta_7, masses2_11, T0sum(218), M2)
  call TI_call_OL(0,0, momenta_14, masses2_1, T0sum(219), M2)
  call TI_call_OL(0,0, momenta_6, masses2_6, T0sum(220), M2)
  call TI_call_OL(0,0, momenta_13, masses2_15, T0sum(221), M2)
  call TI_call_OL(0,0, momenta_10, masses2_15, T0sum(222), M2)
  call TI_call_OL(0,0, momenta_9, masses2_5, T0sum(223), M2)
  call TI_call_OL(0,0, momenta_6, masses2_5, T0sum(224), M2)
  call TI_call_OL(0,0, momenta_3, masses2_12, T0sum(225), M2)
  call TI_call_OL(0,0, momenta_2, masses2_9, T0sum(226), M2)
  call TI_call_OL(0,0, momenta_4, masses2_12, T0sum(227), M2)

  call TI_call_OL(0,1, momenta_80, masses2_76, T1sum(1), M2,sbarray_1, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_81, masses2_76, T1sum(2), M2,sbarray_2, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_76, masses2_76, T1sum(3), M2,sbarray_3, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_77, masses2_76, T1sum(4), M2,sbarray_4, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_78, masses2_73, T1sum(5), M2,sbarray_5, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_78, masses2_75, T1sum(6), M2,sbarray_6, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_78, masses2_74, T1sum(7), M2,sbarray_7, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_79, masses2_73, T1sum(8), M2,sbarray_8, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_79, masses2_75, T1sum(9), M2,sbarray_9, ScalarBoxes(:))
  call TI_call_OL(0,1, momenta_79, masses2_74, T1sum(10), M2,sbarray_10, ScalarBoxes(:))

  call add_met(M2,M2L1R1)

#ifdef LOOPSQUARED
  end if
#endif

  call met_to_real(M2out,M2)

#ifdef PRECISION_dp
  call HOL_memory_deallocation_/**/REALKIND(1)
  call HCL_memory_deallocation_/**/REALKIND(1)
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_pphtt_ew_ttxddxh_1_/**/REALKIND
