
module ol_colourmatrix_pphtt_ew_ttxddxh_3_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(51,3), K2(51,3), KL(51,3), Cas(5) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [   0,   0,   0]
  K1( 2,:) = [   0,   9,   0]
  K1( 3,:) = [   0,   0,   0]
  K1( 4,:) = [   0,   0,   0]
  K1( 5,:) = [   0,  12,   0]
  K1( 6,:) = [   0,   0,   0]
  K1( 7,:) = [   0,   0,   0]
  K1( 8,:) = [   0, -12,   0]
  K1( 9,:) = [   0,   0,   0]
  K1(10,:) = [   0,   0,   0]
  K1(11,:) = [   0,  12,   0]
  K1(12,:) = [   0,   0,   0]
  K1(13,:) = [   0,   0,   0]
  K1(14,:) = [   0,   0,   0]
  K1(15,:) = [   0,   0,   0]
  K1(16,:) = [   0,   0,   0]
  K1(17,:) = [   0,   0,   0]
  K1(18,:) = [   0,   0,   0]
  K1(19,:) = [   0,   0,   0]
  K1(20,:) = [   0,  12,   0]
  K1(21,:) = [   0,   0,   0]
  K1(22,:) = [   0,   0,   0]
  K1(23,:) = [   0,   0,   0]
  K1(24,:) = [   0,   0,   0]
  K1(25,:) = [   0,   0,   0]
  K1(26,:) = [   0,   0,   0]
  K1(27,:) = [   0,   0,   0]
  K1(28,:) = [   0,   0,   0]
  K1(29,:) = [   0, -12,   0]
  K1(30,:) = [   0,   0,   0]
  K1(31,:) = [   0,   0,   0]
  K1(32,:) = [   0,  12,   0]
  K1(33,:) = [   0,   0,   0]
  K1(34,:) = [   0,   0,   0]
  K1(35,:) = [   0,   0,   0]
  K1(36,:) = [   0,   0,   0]
  K1(37,:) = [   0,   0,   0]
  K1(38,:) = [   0,   0,   0]
  K1(39,:) = [   0,   0,   0]
  K1(40,:) = [   0,   0,   0]
  K1(41,:) = [   0,   0,   0]
  K1(42,:) = [   0,   0,   0]
  K1(43,:) = [   0,   0,   0]
  K1(44,:) = [   0,   0,   0]
  K1(45,:) = [   0,   0,   0]
  K1(46,:) = [   0,   0,   0]
  K1(47,:) = [   0,   0,   0]
  K1(48,:) = [   0,   0,   0]
  K1(49,:) = [   0,   3,   0]
  K1(50,:) = [   3,   0,   9]
  K1(51,:) = [   0,   9,   0]

  K2( 1,:) = [   0,   0,   3]
  K2( 2,:) = [   3,   9,   0]
  K2( 3,:) = [   0,   0,   9]
  K2( 4,:) = [   0,   0,   4]
  K2( 5,:) = [   4,  12,   0]
  K2( 6,:) = [   0,   0,  12]
  K2( 7,:) = [   0,   0,  -4]
  K2( 8,:) = [  -4, -12,   0]
  K2( 9,:) = [   0,   0, -12]
  K2(10,:) = [   0,   0,   4]
  K2(11,:) = [   4,  12,   0]
  K2(12,:) = [   0,   0,  12]
  K2(13,:) = [   0,   0,   4]
  K2(14,:) = [   4,   0,   0]
  K2(15,:) = [   0,   0,   0]
  K2(16,:) = [   0,   0,  -4]
  K2(17,:) = [  -4,   0,   0]
  K2(18,:) = [   0,   0,   0]
  K2(19,:) = [   0,   0,   4]
  K2(20,:) = [   4,  12,   0]
  K2(21,:) = [   0,   0,  12]
  K2(22,:) = [   0,   0,  -4]
  K2(23,:) = [  -4,   0,   0]
  K2(24,:) = [   0,   0,   0]
  K2(25,:) = [   0,   0,   4]
  K2(26,:) = [   4,   0,   0]
  K2(27,:) = [   0,   0,   0]
  K2(28,:) = [   0,   0,  -4]
  K2(29,:) = [  -4, -12,   0]
  K2(30,:) = [   0,   0, -12]
  K2(31,:) = [   0,   0,   4]
  K2(32,:) = [   4,  12,   0]
  K2(33,:) = [   0,   0,  12]
  K2(34,:) = [   0,   0,   0]
  K2(35,:) = [   0,   0,   0]
  K2(36,:) = [   0,   0,   0]
  K2(37,:) = [   0,   0,   0]
  K2(38,:) = [   0,   0,   0]
  K2(39,:) = [   0,   0,   0]
  K2(40,:) = [   0,   0,   0]
  K2(41,:) = [   0,   0,   0]
  K2(42,:) = [   0,   0,   0]
  K2(43,:) = [   0,   0,   0]
  K2(44,:) = [   0,   0,   0]
  K2(45,:) = [   0,   0,   0]
  K2(46,:) = [   0,   0,   0]
  K2(47,:) = [   0,   0,   0]
  K2(48,:) = [   0,   0,   0]
  K2(49,:) = [   9,   3,   0]
  K2(50,:) = [   0,   0,   0]
  K2(51,:) = [   3,   9,   0]

  KL( 1,:) = [   0,   3,   0]
  KL( 2,:) = [   3,   0,   9]
  KL( 3,:) = [   0,   9,   0]
  KL( 4,:) = [   0,   4,   0]
  KL( 5,:) = [   4,   0,  12]
  KL( 6,:) = [   0,  12,   0]
  KL( 7,:) = [   0,  -4,   0]
  KL( 8,:) = [  -4,   0, -12]
  KL( 9,:) = [   0, -12,   0]
  KL(10,:) = [   0,   4,   0]
  KL(11,:) = [   4,   0,  12]
  KL(12,:) = [   0,  12,   0]
  KL(13,:) = [   0,   4,   0]
  KL(14,:) = [   4,   0,   0]
  KL(15,:) = [   0,   0,   0]
  KL(16,:) = [   0,  -4,   0]
  KL(17,:) = [  -4,   0,   0]
  KL(18,:) = [   0,   0,   0]
  KL(19,:) = [   0,   4,   0]
  KL(20,:) = [   4,   0,  12]
  KL(21,:) = [   0,  12,   0]
  KL(22,:) = [   0,  -4,   0]
  KL(23,:) = [  -4,   0,   0]
  KL(24,:) = [   0,   0,   0]
  KL(25,:) = [   0,   4,   0]
  KL(26,:) = [   4,   0,   0]
  KL(27,:) = [   0,   0,   0]
  KL(28,:) = [   0,  -4,   0]
  KL(29,:) = [  -4,   0, -12]
  KL(30,:) = [   0, -12,   0]
  KL(31,:) = [   0,   4,   0]
  KL(32,:) = [   4,   0,  12]
  KL(33,:) = [   0,  12,   0]
  KL(34,:) = [   0,   0,   0]
  KL(35,:) = [   0,   0,   0]
  KL(36,:) = [   0,   0,   0]
  KL(37,:) = [   0,   0,   0]
  KL(38,:) = [   0,   0,   0]
  KL(39,:) = [   0,   0,   0]
  KL(40,:) = [   0,   0,   0]
  KL(41,:) = [   0,   0,   0]
  KL(42,:) = [   0,   0,   0]
  KL(43,:) = [   0,   0,   0]
  KL(44,:) = [   0,   0,   0]
  KL(45,:) = [   0,   0,   0]
  KL(46,:) = [   0,   0,   0]
  KL(47,:) = [   0,   0,   0]
  KL(48,:) = [   0,   0,   0]
  KL(49,:) = [   9,   0,   3]
  KL(50,:) = [   0,   0,   0]
  KL(51,:) = [   3,   0,   9]

#if 1 > 0
    co = 0
    do k = 1, 5
      co = co + k
      Cas(k) = K1(1+3*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_pphtt_ew_ttxddxh_3_/**/REALKIND



module ol_forced_parameters_pphtt_ew_ttxddxh_3_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pphtt_ew_ttxddxh_3_/**/REALKIND


! **********************************************************************
module ol_loop_storage_pphtt_ew_ttxddxh_3_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 16 ! number of helicity configurations
  integer(intkind2), save :: nhel = 16 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 16 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(16) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(65)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(1)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf2(2,16), wf4(4,67), wf8(8,16), wf16(16,88)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(366), c(346)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_pphtt_ew_ttxddxh_3_/**/REALKIND






! **********************************************************************
module ol_loop_pphtt_ew_ttxddxh_3_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_pphtt_ew_ttxddxh_3_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = (2*CI*countertermnorm*eQED**5*EWctHAA)/9._/**/REALKIND
    f(  2) = (CI*countertermnorm*eQED**5*EWctHZA)/3._/**/REALKIND
    f(  3) = (2*CI*countertermnorm*eQED**5*EWctHZA)/3._/**/REALKIND
    f(  4) = CI*countertermnorm*eQED**5*EWctHZZ
    f(  5) = (2*CI*countertermnorm*eQED**5*MT)/(9._/**/REALKIND*MW)
    f(  6) = (CI*countertermnorm*eQED**5*MT)/MW
    f(  7) = (CI*countertermnorm*eQED**3*gQCD**2*MT)/MW
    f(  8) = (countertermnorm*eQED**5*MT)/(cw**2*sw**2*2._/**/REALKIND)
    f(  9) = (countertermnorm*eQED**5*MH**2*MT)/(MW**2*sw**2*12._/**/REALKIND)
    f( 10) = (countertermnorm*eQED**5*MH**2*MT)/(MW**2*sw**2*4._/**/REALKIND)
    f( 11) = (countertermnorm*eQED**5*MT**2)/(MW**2*sw**2*12._/**/REALKIND)
    f( 12) = (countertermnorm*eQED**5*MT**2)/(MW**2*sw**2*4._/**/REALKIND)
    f( 13) = (CI*eQED**3*MT)/(4._/**/REALKIND*cw*MW*sw**2)
    f( 14) = (CI*countertermnorm*eQED**5*MT)/(12._/**/REALKIND*cw*MW*sw**2)
    f( 15) = (CI*countertermnorm*eQED**5*MT)/(4._/**/REALKIND*cw*MW*sw**2)
    f( 16) = (CI*countertermnorm*ctStt*eQED**3*gQCD**2*MT)/(4._/**/REALKIND*cw*MW*sw**2)
    f( 17) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2*MT)/(4._/**/REALKIND*cw*MW*sw**2)
    f( 18) = (countertermnorm*eQED**5)/(cw*sw*6._/**/REALKIND)
    f( 19) = (countertermnorm*eQED**5)/(cw*sw*3._/**/REALKIND)
    f( 20) = (countertermnorm*eQED**5)/(cw*sw*2._/**/REALKIND)
    f( 21) = (CI*eQED**3*MT)/(9._/**/REALKIND*MW*sw)
    f( 22) = (CI*eQED**3*MT)/(2._/**/REALKIND*MW*sw)
    f( 23) = (CI*countertermnorm*eQED**5*MT)/(9._/**/REALKIND*MW*sw)
    f( 24) = (CI*countertermnorm*eQED**5*MT)/(6._/**/REALKIND*MW*sw)
    f( 25) = (CI*countertermnorm*eQED**5*MT)/(3._/**/REALKIND*MW*sw)
    f( 26) = (CI*countertermnorm*eQED**5*MT)/(2._/**/REALKIND*MW*sw)
    f( 27) = (countertermnorm*eQED**5*MT)/(cw*MW*sw*2._/**/REALKIND)
    f( 28) = (countertermnorm*eQED**5*EWctAXH*MT)/(MW*sw*6._/**/REALKIND)
    f( 29) = (countertermnorm*eQED**5*EWctZXH*MT)/(MW*sw*2._/**/REALKIND)
    f( 30) = (CI*eQED*gQCD**2*MT)/(2._/**/REALKIND*MW*sw)
    f( 31) = (CI*countertermnorm*eQED**3*gQCD**2*MT)/(9._/**/REALKIND*MW*sw)
    f( 32) = (CI*countertermnorm*eQED**3*gQCD**2*MT)/(2._/**/REALKIND*MW*sw)
    f( 33) = (CI*countertermnorm*ctStt*eQED**3*gQCD**2*MT)/(9._/**/REALKIND*MW*sw)
    f( 34) = (CI*countertermnorm*ctStt*eQED**3*gQCD**2*MT)/(2._/**/REALKIND*MW*sw)
    f( 35) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2*MT)/(9._/**/REALKIND*MW*sw)
    f( 36) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2*MT)/(2._/**/REALKIND*MW*sw)
    f( 37) = (CI*countertermnorm*ctVtt*eQED**3*gQCD**2*MT)/(9._/**/REALKIND*MW*sw)
    f( 38) = (CI*countertermnorm*ctVtt*eQED**3*gQCD**2*MT)/(2._/**/REALKIND*MW*sw)
    f( 39) = (CI*eQED**3*MW)/(cw**2*sw)
    f( 40) = (CI*countertermnorm*eQED**5*MW)/(3._/**/REALKIND*cw**2*sw)
    f( 41) = (2*CI*countertermnorm*eQED**5*MW)/(3._/**/REALKIND*cw**2*sw)
    f( 42) = (CI*countertermnorm*eQED**5*MW)/(cw**2*sw)
    f( 43) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2*MW)/(cw**2*sw)
    f( 44) = (CI*countertermnorm*ctVtt*eQED**3*gQCD**2*MW)/(cw**2*sw)
    f( 45) = (eQED**5*integralnorm*MW*SwB)/(cw*6._/**/REALKIND)
    f( 46) = (eQED**5*integralnorm*MW*SwB)/(cw*3._/**/REALKIND)
    f( 47) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw*6._/**/REALKIND)
    f( 48) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw*3._/**/REALKIND)
    f( 49) = (eQED**5*integralnorm*MT*MW*SwB)/(cw**3*4._/**/REALKIND)
    f( 50) = (eQED**5*integralnorm*MT*MW*SwB)/(cw*6._/**/REALKIND)
    f( 51) = (eQED**5*integralnorm*MT*MW*SwB)/(cw*3._/**/REALKIND)
    f( 52) = (eQED**5*integralnorm*MW**3*SwB)/(cw**3*3._/**/REALKIND)
    f( 53) = (2*eQED**5*integralnorm*MW**3*SwB)/(cw**3*3._/**/REALKIND)
    f( 54) = (eQED**5*integralnorm*MW**3*SwB)/(cw*3._/**/REALKIND)
    f( 55) = (2*eQED**5*integralnorm*MW**3*SwB)/(cw*3._/**/REALKIND)
    f( 56) = (eQED**5*integralnorm*SwB)/(MW*sw**5*8._/**/REALKIND)
    f( 57) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**5*8._/**/REALKIND)
    f( 58) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**5*16._/**/REALKIND)
    f( 59) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**5*8._/**/REALKIND)
    f( 60) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(MW*sw**5*8._/**/REALKIND)
    f( 61) = (eQED**5*integralnorm*MT**2*SwB)/(MW*sw**5*8._/**/REALKIND)
    f( 62) = (eQED**5*integralnorm*MW*SwB)/(sw**5*4._/**/REALKIND)
    f( 63) = (eQED**5*integralnorm*MT*MW*SwB)/(sw**5*4._/**/REALKIND)
    f( 64) = (eQED**5*integralnorm*MB*SwB)/(cw*MW**3*sw**4*8._/**/REALKIND)
    f( 65) = (eQED**5*integralnorm*MH**2*MT*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f( 66) = (eQED**5*integralnorm*MH**4*MT*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f( 67) = (3*eQED**5*integralnorm*lambdaHHH*MH**4*MT*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f( 68) = (eQED**5*integralnorm*MH**2*MT**2*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f( 69) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT**2*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f( 70) = (eQED**5*integralnorm*MT**3*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f( 71) = (eQED**5*integralnorm*SwB)/(cw*MW*sw**4*8._/**/REALKIND)
    f( 72) = (cw*eQED**5*integralnorm*SwB)/(MW*sw**4*4._/**/REALKIND)
    f( 73) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**4*8._/**/REALKIND)
    f( 74) = (cw*eQED**5*integralnorm*MB*SwB)/(MW*sw**4*4._/**/REALKIND)
    f( 75) = (eQED**5*integralnorm*MT*SwB)/(cw**3*MW*sw**4*16._/**/REALKIND)
    f( 76) = (eQED**5*integralnorm*MT*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f( 77) = (eQED**5*integralnorm*MT*SwB)/(cw*MW*sw**4*16._/**/REALKIND)
    f( 78) = (eQED**5*integralnorm*MT*SwB)/(cw*MW*sw**4*8._/**/REALKIND)
    f( 79) = (cw*eQED**5*integralnorm*MT*SwB)/(MW*sw**4*8._/**/REALKIND)
    f( 80) = (cw*eQED**5*integralnorm*MT*SwB)/(MW*sw**4*4._/**/REALKIND)
    f( 81) = (eQED**5*integralnorm*MH**2*MT*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f( 82) = (cw*eQED**5*integralnorm*MH**2*MT*SwB)/(MW*sw**4*8._/**/REALKIND)
    f( 83) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f( 84) = (3*cw*eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(MW*sw**4*8._/**/REALKIND)
    f( 85) = (3*cw*eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(MW*sw**4*4._/**/REALKIND)
    f( 86) = (eQED**5*integralnorm*MT**2*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f( 87) = (cw*eQED**5*integralnorm*MT**2*SwB)/(MW*sw**4*8._/**/REALKIND)
    f( 88) = (cw*eQED**5*integralnorm*MT**2*SwB)/(MW*sw**4*4._/**/REALKIND)
    f( 89) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**4*2._/**/REALKIND)
    f( 90) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**4*2._/**/REALKIND)
    f( 91) = (eQED**5*integralnorm*MT*MW*SwB)/(cw**5*sw**4*4._/**/REALKIND)
    f( 92) = (eQED**5*integralnorm*MT*MW*SwB)/(cw*sw**4*16._/**/REALKIND)
    f( 93) = (eQED**5*integralnorm*MT*MW*SwB)/(cw*sw**4*4._/**/REALKIND)
    f( 94) = (eQED**5*integralnorm*MT*MW*SwB)/(cw*sw**4*2._/**/REALKIND)
    f( 95) = (cw*eQED**5*integralnorm*MT*MW*SwB)/(sw**4*8._/**/REALKIND)
    f( 96) = (cw*eQED**5*integralnorm*MT*MW*SwB)/(sw**4*2._/**/REALKIND)
    f( 97) = (eQED**5*integralnorm*MB*SwB)/(MW**3*sw**3*36._/**/REALKIND)
    f( 98) = (eQED**5*integralnorm*MB*SwB)/(MW**3*sw**3*18._/**/REALKIND)
    f( 99) = (eQED**5*integralnorm*MB*SwB)/(MW**3*sw**3*12._/**/REALKIND)
    f(100) = (eQED**5*integralnorm*MB*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f(101) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f(102) = (eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**3*36._/**/REALKIND)
    f(103) = (eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**3*18._/**/REALKIND)
    f(104) = (eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**3*12._/**/REALKIND)
    f(105) = (eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f(106) = (eQED**3*gQCD**2*integralnorm*MH**2*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f(107) = (eQED**5*integralnorm*MT*SwB)/(MW**3*sw**3*36._/**/REALKIND)
    f(108) = (eQED**5*integralnorm*MT*SwB)/(MW**3*sw**3*18._/**/REALKIND)
    f(109) = (eQED**5*integralnorm*MT*SwB)/(MW**3*sw**3*12._/**/REALKIND)
    f(110) = (eQED**5*integralnorm*MT*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f(111) = (eQED**3*gQCD**2*integralnorm*MT*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f(112) = (eQED**5*integralnorm*MH**2*MT*SwB)/(MW**3*sw**3*24._/**/REALKIND)
    f(113) = (eQED**5*integralnorm*MH**4*MT*SwB)/(MW**3*sw**3*24._/**/REALKIND)
    f(114) = (eQED**5*integralnorm*lambdaHHH*MH**4*MT*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(115) = (eQED**5*integralnorm*MH**2*MT**2*SwB)/(MW**3*sw**3*36._/**/REALKIND)
    f(116) = (eQED**5*integralnorm*MH**2*MT**2*SwB)/(MW**3*sw**3*24._/**/REALKIND)
    f(117) = (eQED**5*integralnorm*MH**2*MT**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(118) = (eQED**3*gQCD**2*integralnorm*MH**2*MT**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(119) = (eQED**5*integralnorm*lambdaHHH*MH**2*MT**2*SwB)/(MW**3*sw**3*12._/**/REALKIND)
    f(120) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(121) = (3*eQED**3*gQCD**2*integralnorm*lambdaHHH*MH**2*MT**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(122) = (eQED**5*integralnorm*MT**3*SwB)/(MW**3*sw**3*36._/**/REALKIND)
    f(123) = (eQED**5*integralnorm*MT**3*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(124) = (eQED**3*gQCD**2*integralnorm*MT**3*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(125) = (eQED**5*integralnorm*SwB)/(MW*sw**3*36._/**/REALKIND)
    f(126) = (eQED**5*integralnorm*SwB)/(MW*sw**3*18._/**/REALKIND)
    f(127) = (eQED**5*integralnorm*SwB)/(MW*sw**3*12._/**/REALKIND)
    f(128) = (eQED**5*integralnorm*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(129) = (eQED**5*integralnorm*SwB)/(cw**2*MW*sw**3*2._/**/REALKIND)
    f(130) = (eQED**3*gQCD**2*integralnorm*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(131) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*36._/**/REALKIND)
    f(132) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*18._/**/REALKIND)
    f(133) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*12._/**/REALKIND)
    f(134) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(135) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(136) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw**3*12._/**/REALKIND)
    f(137) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(138) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(139) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*36._/**/REALKIND)
    f(140) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*24._/**/REALKIND)
    f(141) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*18._/**/REALKIND)
    f(142) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*12._/**/REALKIND)
    f(143) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*9._/**/REALKIND)
    f(144) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*6._/**/REALKIND)
    f(145) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(146) = (eQED**5*integralnorm*MT*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(147) = (eQED**5*integralnorm*MT*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(148) = (cw**2*eQED**5*integralnorm*MT*SwB)/(MW*sw**3*2._/**/REALKIND)
    f(149) = (eQED**3*gQCD**2*integralnorm*MT*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(150) = (eQED**5*integralnorm*MH**2*MT*SwB)/(MW*sw**3*24._/**/REALKIND)
    f(151) = (eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(MW*sw**3*8._/**/REALKIND)
    f(152) = (eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(153) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(154) = (eQED**5*integralnorm*MT**2*SwB)/(MW*sw**3*24._/**/REALKIND)
    f(155) = (eQED**5*integralnorm*MT**2*SwB)/(MW*sw**3*12._/**/REALKIND)
    f(156) = (eQED**5*integralnorm*MT**2*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(157) = (eQED**5*integralnorm*MW*SwB)/(sw**3*18._/**/REALKIND)
    f(158) = (eQED**5*integralnorm*MW*SwB)/(sw**3*12._/**/REALKIND)
    f(159) = (eQED**5*integralnorm*MW*SwB)/(sw**3*9._/**/REALKIND)
    f(160) = (eQED**5*integralnorm*MW*SwB)/(sw**3*6._/**/REALKIND)
    f(161) = (2*eQED**5*integralnorm*MW*SwB)/(sw**3*9._/**/REALKIND)
    f(162) = (eQED**5*integralnorm*MW*SwB)/(sw**3*4._/**/REALKIND)
    f(163) = (eQED**5*integralnorm*MW*SwB)/(sw**3*3._/**/REALKIND)
    f(164) = (eQED**5*integralnorm*MW*SwB)/(sw**3*2._/**/REALKIND)
    f(165) = (eQED**5*integralnorm*MW*SwB)/sw**3
    f(166) = (eQED**5*integralnorm*MW*SwB)/(cw**4*sw**3*4._/**/REALKIND)
    f(167) = (eQED**5*integralnorm*MW*SwB)/(cw**4*sw**3*2._/**/REALKIND)
    f(168) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw**3*2._/**/REALKIND)
    f(169) = (cw**2*eQED**5*integralnorm*MW*SwB)/(sw**3*2._/**/REALKIND)
    f(170) = (cw**2*eQED**5*integralnorm*MW*SwB)/sw**3
    f(171) = (eQED**3*gQCD**2*integralnorm*MW*SwB)/(sw**3*2._/**/REALKIND)
    f(172) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(cw**4*sw**3*2._/**/REALKIND)
    f(173) = (eQED**5*integralnorm*MT*MW*SwB)/(sw**3*24._/**/REALKIND)
    f(174) = (eQED**5*integralnorm*MT*MW*SwB)/(sw**3*12._/**/REALKIND)
    f(175) = (eQED**5*integralnorm*MT*MW*SwB)/(sw**3*6._/**/REALKIND)
    f(176) = (eQED**5*integralnorm*MT*MW*SwB)/(cw**4*sw**3*2._/**/REALKIND)
    f(177) = (eQED**5*integralnorm*MW**3*SwB)/(cw**6*sw**3)
    f(178) = (eQED**5*integralnorm*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(179) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(180) = (eQED**5*integralnorm*MH**2*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(181) = (eQED**5*integralnorm*MT*SwB)/(cw*MW*sw**2*36._/**/REALKIND)
    f(182) = (eQED**5*integralnorm*MT*SwB)/(cw*MW*sw**2*18._/**/REALKIND)
    f(183) = (eQED**5*integralnorm*MT*SwB)/(cw*MW*sw**2*9._/**/REALKIND)
    f(184) = (eQED**5*integralnorm*MT*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(185) = (eQED**5*integralnorm*MT*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(186) = (cw*eQED**5*integralnorm*MT*SwB)/(MW*sw**2*6._/**/REALKIND)
    f(187) = (cw*eQED**5*integralnorm*MT*SwB)/(MW*sw**2*3._/**/REALKIND)
    f(188) = (eQED**3*gQCD**2*integralnorm*MT*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(189) = (eQED**5*integralnorm*MH**2*MT*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(190) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(191) = (eQED**5*integralnorm*MT**2*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(192) = (eQED**5*integralnorm*MW*SwB)/(cw**3*sw**2*2._/**/REALKIND)
    f(193) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*12._/**/REALKIND)
    f(194) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*6._/**/REALKIND)
    f(195) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(196) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*3._/**/REALKIND)
    f(197) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*2._/**/REALKIND)
    f(198) = (2*eQED**5*integralnorm*MW*SwB)/(cw*sw**2*3._/**/REALKIND)
    f(199) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**2*6._/**/REALKIND)
    f(200) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**2*3._/**/REALKIND)
    f(201) = (2*cw*eQED**5*integralnorm*MW*SwB)/(sw**2*3._/**/REALKIND)
    f(202) = (eQED**5*integralnorm*MT*MW*SwB)/(cw**3*sw**2*4._/**/REALKIND)
    f(203) = (eQED**5*integralnorm*MT*MW*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(204) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw*9._/**/REALKIND)
    f(205) = (2*eQED**5*integralnorm*MH**2*SwB)/(MW*sw*9._/**/REALKIND)
    f(206) = (eQED**5*integralnorm*MT*SwB)/(MW*sw*81._/**/REALKIND)
    f(207) = (2*eQED**5*integralnorm*MT*SwB)/(MW*sw*81._/**/REALKIND)
    f(208) = (4*eQED**5*integralnorm*MT*SwB)/(MW*sw*81._/**/REALKIND)
    f(209) = (eQED**5*integralnorm*MT*SwB)/(MW*sw*18._/**/REALKIND)
    f(210) = (eQED**5*integralnorm*MT*SwB)/(MW*sw*9._/**/REALKIND)
    f(211) = (2*eQED**5*integralnorm*MT*SwB)/(MW*sw*9._/**/REALKIND)
    f(212) = (eQED**5*integralnorm*MT*SwB)/(MW*sw*2._/**/REALKIND)
    f(213) = (eQED**3*gQCD**2*integralnorm*MT*SwB)/(MW*sw*18._/**/REALKIND)
    f(214) = (eQED**3*gQCD**2*integralnorm*MT*SwB)/(MW*sw*9._/**/REALKIND)
    f(215) = (2*eQED**3*gQCD**2*integralnorm*MT*SwB)/(MW*sw*9._/**/REALKIND)
    f(216) = (eQED**3*gQCD**2*integralnorm*MT*SwB)/(MW*sw*2._/**/REALKIND)
    f(217) = (eQED**5*integralnorm*MW*SwB)/(sw*9._/**/REALKIND)
    f(218) = (2*eQED**5*integralnorm*MW*SwB)/(sw*9._/**/REALKIND)
    f(219) = (eQED**5*integralnorm*MW*SwB)/(sw*2._/**/REALKIND)
    f(220) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw*9._/**/REALKIND)
    f(221) = (2*eQED**5*integralnorm*MW*SwB)/(cw**2*sw*9._/**/REALKIND)
    f(222) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(223) = (4*eQED**5*integralnorm*MW*SwB)/(cw**2*sw*9._/**/REALKIND)
    f(224) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw)
    f(225) = (eQED**3*gQCD**2*integralnorm*MW*SwB)/(cw**2*sw)
    f(226) = (eQED**5*integralnorm*MH**2*MW*SwB)/(sw*9._/**/REALKIND)
    f(227) = (eQED**5*integralnorm*MT*MW*SwB)/(sw*9._/**/REALKIND)
    f(228) = (eQED**5*integralnorm*MT*MW*SwB)/(cw**2*sw*12._/**/REALKIND)
    f(229) = (2*eQED**5*integralnorm*MW**3*SwB)/(sw*9._/**/REALKIND)
    f(230) = (eQED**5*integralnorm*MW*sw*SwB)/(cw**2*2._/**/REALKIND)
    f(231) = (eQED**5*integralnorm*MH**2*MW*sw*SwB)/(cw**2*2._/**/REALKIND)
    f(232) = (eQED**5*integralnorm*MT*MW*sw*SwB)/(cw**2*2._/**/REALKIND)
    f(233) = (eQED**5*integralnorm*MW**3*sw*SwB)/cw**4
    f(234) = (eQED**5*integralnorm*MW**3*sw*SwB)/cw**2
    f(235) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*8._/**/REALKIND))
    f(236) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*8._/**/REALKIND))
    f(237) = -((eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*8._/**/REALKIND))
    f(238) = -((eQED**5*integralnorm*MH**2*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND))
    f(239) = -((eQED**5*integralnorm*MH**4*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND))
    f(240) = (-3*eQED**5*integralnorm*lambdaHHH*MH**4*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(241) = -((eQED**5*integralnorm*MH**2*MT**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND))
    f(242) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**3*MW*sw**4*4._/**/REALKIND))
    f(243) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**4*8._/**/REALKIND))
    f(244) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*12._/**/REALKIND)
    f(245) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*6._/**/REALKIND)
    f(246) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*3._/**/REALKIND)
    f(247) = -((eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**4*16._/**/REALKIND))
    f(248) = -((eQED**5*integralnorm*MT*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**3*MW*sw**4*16._/**/REALKIND*8._/**/REALKIND))
    f(249) = (eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*12._/**/REALKIND)
    f(250) = (eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*6._/**/REALKIND)
    f(251) = -((eQED**5*integralnorm*MH**2*MT*(cw - sw)*(cw + sw)*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND))
    f(252) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**2*6._/**/REALKIND)
    f(253) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**2*3._/**/REALKIND)
    f(254) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*12._/**/REALKIND)
    f(255) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*6._/**/REALKIND)
    f(256) = (eQED**5*integralnorm*MT*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**3*24._/**/REALKIND)
    f(257) = (eQED**5*integralnorm*MH**2*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW*sw**3*4._/**/REALKIND*8._/**/REALKIND)
    f(258) = (eQED**5*integralnorm*MH**2*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*MW*sw**3*2._/**/REALKIND*4._/**/REALKIND)
    f(259) = (eQED**5*integralnorm*MT*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW*sw**3*4._/**/REALKIND*8._/**/REALKIND)
    f(260) = (eQED**5*integralnorm*MW*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**4*sw**3*2._/**/REALKIND*4._/**/REALKIND)
    f(261) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(262) = (eQED**5*integralnorm*MB**2*MT*SwF)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(263) = (eQED**5*integralnorm*ME**2*MT*SwF)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(264) = (eQED**5*integralnorm*ML**2*MT*SwF)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(265) = (eQED**5*integralnorm*MM**2*MT*SwF)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(266) = (eQED**5*integralnorm*MT**3*SwF)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(267) = (eQED**5*integralnorm*MB**2*MT*SwF)/(MW**3*sw**3*72._/**/REALKIND)
    f(268) = (eQED**5*integralnorm*MB**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(269) = (eQED**5*integralnorm*ME**2*MT*SwF)/(MW**3*sw**3*24._/**/REALKIND)
    f(270) = (eQED**5*integralnorm*ME**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(271) = (eQED**5*integralnorm*MB*MH**2*MT*SwF)/(MW**3*sw**3*72._/**/REALKIND)
    f(272) = (eQED**5*integralnorm*MB*MH**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(273) = (eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwF)/(MW**3*sw**3*24._/**/REALKIND)
    f(274) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(275) = (eQED**5*integralnorm*ME*MH**2*MT*SwF)/(MW**3*sw**3*24._/**/REALKIND)
    f(276) = (eQED**5*integralnorm*ME*MH**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(277) = (eQED**5*integralnorm*lambdaHHH*ME*MH**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(278) = (3*eQED**5*integralnorm*lambdaHHH*ME*MH**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(279) = (eQED**5*integralnorm*MH**2*ML*MT*SwF)/(MW**3*sw**3*24._/**/REALKIND)
    f(280) = (eQED**5*integralnorm*MH**2*ML*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(281) = (eQED**5*integralnorm*lambdaHHH*MH**2*ML*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(282) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*ML*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(283) = (eQED**5*integralnorm*ML**2*MT*SwF)/(MW**3*sw**3*24._/**/REALKIND)
    f(284) = (eQED**5*integralnorm*ML**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(285) = (eQED**5*integralnorm*MH**2*MM*MT*SwF)/(MW**3*sw**3*24._/**/REALKIND)
    f(286) = (eQED**5*integralnorm*MH**2*MM*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(287) = (eQED**5*integralnorm*lambdaHHH*MH**2*MM*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(288) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MM*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(289) = (eQED**5*integralnorm*MM**2*MT*SwF)/(MW**3*sw**3*24._/**/REALKIND)
    f(290) = (eQED**5*integralnorm*MM**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(291) = (eQED**5*integralnorm*MB*MT**2*SwF)/(MW**3*sw**3*72._/**/REALKIND)
    f(292) = (eQED**5*integralnorm*MB*MT**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(293) = (eQED**5*integralnorm*ME*MT**2*SwF)/(MW**3*sw**3*24._/**/REALKIND)
    f(294) = (eQED**5*integralnorm*ME*MT**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(295) = (eQED**5*integralnorm*MH**2*MT**2*SwF)/(MW**3*sw**3*36._/**/REALKIND)
    f(296) = (eQED**5*integralnorm*MH**2*MT**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(297) = (eQED**5*integralnorm*lambdaHHH*MH**2*MT**2*SwF)/(MW**3*sw**3*12._/**/REALKIND)
    f(298) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(299) = (eQED**5*integralnorm*ML*MT**2*SwF)/(MW**3*sw**3*24._/**/REALKIND)
    f(300) = (eQED**5*integralnorm*ML*MT**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(301) = (eQED**5*integralnorm*MM*MT**2*SwF)/(MW**3*sw**3*24._/**/REALKIND)
    f(302) = (eQED**5*integralnorm*MM*MT**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(303) = (eQED**5*integralnorm*MT**3*SwF)/(MW**3*sw**3*36._/**/REALKIND)
    f(304) = (eQED**5*integralnorm*MT**3*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(305) = (eQED**5*integralnorm*MB*MT*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(306) = (eQED**5*integralnorm*ME*MT*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(307) = (eQED**5*integralnorm*ML*MT*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(308) = (eQED**5*integralnorm*MM*MT*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(309) = (eQED**5*integralnorm*MT**2*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(310) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*36._/**/REALKIND)
    f(311) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*18._/**/REALKIND)
    f(312) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(313) = (eQED**5*integralnorm*ME*SwF)/(cw*MW*sw**2*12._/**/REALKIND)
    f(314) = (eQED**5*integralnorm*ME*SwF)/(cw*MW*sw**2*6._/**/REALKIND)
    f(315) = (eQED**5*integralnorm*ME*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(316) = (eQED**5*integralnorm*ML*SwF)/(cw*MW*sw**2*12._/**/REALKIND)
    f(317) = (eQED**5*integralnorm*ML*SwF)/(cw*MW*sw**2*6._/**/REALKIND)
    f(318) = (eQED**5*integralnorm*ML*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(319) = (eQED**5*integralnorm*MM*SwF)/(cw*MW*sw**2*12._/**/REALKIND)
    f(320) = (eQED**5*integralnorm*MM*SwF)/(cw*MW*sw**2*6._/**/REALKIND)
    f(321) = (eQED**5*integralnorm*MM*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(322) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*36._/**/REALKIND)
    f(323) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*18._/**/REALKIND)
    f(324) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*12._/**/REALKIND)
    f(325) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*9._/**/REALKIND)
    f(326) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(327) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*2._/**/REALKIND)
    f(328) = (3*eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(329) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*81._/**/REALKIND)
    f(330) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*18._/**/REALKIND)
    f(331) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*9._/**/REALKIND)
    f(332) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*2._/**/REALKIND)
    f(333) = (eQED**5*integralnorm*ME*SwF)/(MW*sw*9._/**/REALKIND)
    f(334) = (eQED**5*integralnorm*ME*SwF)/(MW*sw*6._/**/REALKIND)
    f(335) = (eQED**5*integralnorm*ME*SwF)/(MW*sw*3._/**/REALKIND)
    f(336) = (eQED**5*integralnorm*ME*SwF)/(MW*sw*2._/**/REALKIND)
    f(337) = (eQED**5*integralnorm*ML*SwF)/(MW*sw*9._/**/REALKIND)
    f(338) = (eQED**5*integralnorm*ML*SwF)/(MW*sw*6._/**/REALKIND)
    f(339) = (eQED**5*integralnorm*ML*SwF)/(MW*sw*3._/**/REALKIND)
    f(340) = (eQED**5*integralnorm*ML*SwF)/(MW*sw*2._/**/REALKIND)
    f(341) = (eQED**5*integralnorm*MM*SwF)/(MW*sw*9._/**/REALKIND)
    f(342) = (eQED**5*integralnorm*MM*SwF)/(MW*sw*6._/**/REALKIND)
    f(343) = (eQED**5*integralnorm*MM*SwF)/(MW*sw*3._/**/REALKIND)
    f(344) = (eQED**5*integralnorm*MM*SwF)/(MW*sw*2._/**/REALKIND)
    f(345) = (eQED**5*integralnorm*MT*SwF)/(MW*sw*81._/**/REALKIND)
    f(346) = (2*eQED**5*integralnorm*MT*SwF)/(MW*sw*81._/**/REALKIND)
    f(347) = (4*eQED**5*integralnorm*MT*SwF)/(MW*sw*81._/**/REALKIND)
    f(348) = (eQED**5*integralnorm*MT*SwF)/(MW*sw*18._/**/REALKIND)
    f(349) = (8*eQED**5*integralnorm*MT*SwF)/(MW*sw*81._/**/REALKIND)
    f(350) = (eQED**5*integralnorm*MT*SwF)/(MW*sw*9._/**/REALKIND)
    f(351) = (eQED**5*integralnorm*MT*SwF)/(MW*sw*6._/**/REALKIND)
    f(352) = (2*eQED**5*integralnorm*MT*SwF)/(MW*sw*9._/**/REALKIND)
    f(353) = (eQED**5*integralnorm*MT*SwF)/(MW*sw*3._/**/REALKIND)
    f(354) = (4*eQED**5*integralnorm*MT*SwF)/(MW*sw*9._/**/REALKIND)
    f(355) = (eQED**5*integralnorm*MT*SwF)/(MW*sw*2._/**/REALKIND)
    f(356) = (eQED**5*integralnorm*MT*SwF)/(MW*sw)
    f(357) = (3*eQED**5*integralnorm*MT*SwF)/(MW*sw*2._/**/REALKIND)
    f(358) = (eQED**5*integralnorm*MW*SwF)/(cw**2*sw*9._/**/REALKIND)
    f(359) = (2*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*9._/**/REALKIND)
    f(360) = (eQED**5*integralnorm*MW*SwF)/(cw**2*sw*3._/**/REALKIND)
    f(361) = (4*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*9._/**/REALKIND)
    f(362) = (2*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*3._/**/REALKIND)
    f(363) = (8*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*9._/**/REALKIND)
    f(364) = (eQED**5*integralnorm*MW*SwF)/(cw**2*sw)
    f(365) = (2*eQED**5*integralnorm*MW*SwF)/(cw**2*sw)
    f(366) = (3*eQED**5*integralnorm*MW*SwF)/(cw**2*sw)

  c = [ 6*f(45), 6*f(46), 6*f(47), 6*f(48), 6*f(49), 6*f(50), 6*f(51), 6*f(52), 6*f(53), 6*f(54), 6*f(55), 6*f(56), 6*f(57) &
    , 6*f(58), 6*f(59), 6*f(60), 6*f(61), 6*f(62), 6*f(63), 6*f(64), 6*f(65), 6*f(66), 6*f(67), 6*f(68), 6*f(69), 6*f(70), 6*f(71) &
    , 6*f(72), 6*f(73), 6*f(74), 6*f(75), 6*f(76), 6*f(77), 6*f(78), 6*f(79), 6*f(80), 6*f(81), 6*f(82), 6*f(83), 6*f(84), 6*f(85) &
    , 6*f(86), 6*f(87), 6*f(88), 6*f(89), 6*f(90), 6*f(91), 6*f(92), 6*f(93), 6*f(94), 6*f(95), 6*f(96), 6*f(97), 6*f(98), 6*f(99) &
    , 6*f(100), f(101), 3*f(101), 6*f(102), 6*f(103), 6*f(104), 6*f(105), f(106), 3*f(106), 6*f(107), 6*f(108), 6*f(109), 6*f(110) &
    , f(111), 3*f(111), 6*f(112), 6*f(113), 6*f(114), 6*f(115), 6*f(116), 6*f(117), f(118), 3*f(118), 6*f(119), 6*f(120), f(121) &
    , 3*f(121), 6*f(122), 6*f(123), f(124), 3*f(124), 6*f(125), 6*f(126), 6*f(127), 6*f(128), 6*f(129), f(130), 3*f(130), 6*f(131) &
    , 6*f(132), 6*f(133), 6*f(134), f(135), 3*f(135), 6*f(136), 6*f(137), 6*f(138), 6*f(139), 6*f(140), 6*f(141), 6*f(142) &
    , 6*f(143), 6*f(144), 6*f(145), 6*f(146), 6*f(147), 6*f(148), f(149), 3*f(149), 6*f(150), 6*f(151), 6*f(152), 6*f(153) &
    , 6*f(154), 6*f(155), 6*f(156), 6*f(157), 6*f(158), 6*f(159), 6*f(160), 6*f(161), 6*f(162), 6*f(163), 6*f(164), 6*f(165) &
    , 6*f(166), 6*f(167), 6*f(168), 6*f(169), 6*f(170), f(171), 3*f(171), 6*f(172), 6*f(173), 6*f(174), 6*f(175), 6*f(176) &
    , 6*f(177), 6*f(178), 6*f(179), 6*f(180), 6*f(181), 6*f(182), 6*f(183), 6*f(184), 6*f(185), 6*f(186), 6*f(187), f(188) &
    , 3*f(188), 8*f(188), 6*f(189), 6*f(190), 6*f(191), 6*f(192), 6*f(193), 6*f(194), 6*f(195), 6*f(196), 6*f(197), 6*f(198) &
    , 6*f(199), 6*f(200), 6*f(201), 6*f(202), 6*f(203), 6*f(204), 6*f(205), 6*f(206), 6*f(207), 6*f(208), 6*f(209), 6*f(210) &
    , 6*f(211), 6*f(212), f(213), 3*f(213), f(214), 3*f(214), 8*f(214), f(215), 3*f(215), f(216), 3*f(216), 8*f(216), 6*f(217) &
    , 6*f(218), 6*f(219), 6*f(220), 6*f(221), 6*f(222), 6*f(223), 6*f(224), f(225), 3*f(225), 8*f(225), 6*f(226), 6*f(227) &
    , 6*f(228), 6*f(229), 6*f(230), 6*f(231), 6*f(232), 6*f(233), 6*f(234), 6*f(235), 6*f(236), 6*f(237), 6*f(238), 6*f(239) &
    , 6*f(240), 6*f(241), 6*f(242), 6*f(243), 6*f(244), 6*f(245), 6*f(246), 6*f(247), 6*f(248), 6*f(249), 6*f(250), 6*f(251) &
    , 6*f(252), 6*f(253), 6*f(254), 6*f(255), 6*f(256), 6*f(257), 6*f(258), 6*f(259), 6*f(260), 6*f(261), 18*f(262), 6*f(263) &
    , 6*f(264), 6*f(265), 18*f(266), 18*f(267), 18*f(268), 6*f(269), 6*f(270), 18*f(271), 18*f(272), 18*f(273), 18*f(274) &
    , 6*f(275), 6*f(276), 6*f(277), 6*f(278), 6*f(279), 6*f(280), 6*f(281), 6*f(282), 6*f(283), 6*f(284), 6*f(285), 6*f(286) &
    , 6*f(287), 6*f(288), 6*f(289), 6*f(290), 18*f(291), 18*f(292), 6*f(293), 6*f(294), 18*f(295), 18*f(296), 18*f(297), 18*f(298) &
    , 6*f(299), 6*f(300), 6*f(301), 6*f(302), 18*f(303), 18*f(304), 18*f(305), 6*f(306), 6*f(307), 6*f(308), 18*f(309), 18*f(310) &
    , 18*f(311), 18*f(312), 6*f(313), 6*f(314), 6*f(315), 6*f(316), 6*f(317), 6*f(318), 6*f(319), 6*f(320), 6*f(321), 18*f(322) &
    , 18*f(323), 6*f(324), 18*f(325), 6*f(326), 18*f(326), 18*f(327), 6*f(328), 18*f(329), 18*f(330), 18*f(331), 18*f(332) &
    , 6*f(333), 6*f(334), 6*f(335), 6*f(336), 6*f(337), 6*f(338), 6*f(339), 6*f(340), 6*f(341), 6*f(342), 6*f(343), 6*f(344) &
    , 18*f(345), 18*f(346), 18*f(347), 18*f(348), 18*f(349), 6*f(350), 18*f(350), 6*f(351), 18*f(352), 6*f(353), 18*f(354) &
    , 6*f(355), 18*f(355), 18*f(356), 6*f(357), 18*f(358), 18*f(359), 6*f(360), 18*f(361), 6*f(362), 18*f(363), 6*f(364) &
    , 18*f(364), 18*f(365), 6*f(366) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(2) = 1 /((L(5,12) - MZ2)+L(6,12))
  den(4) = 1 /((L(5,17) - MT2)+L(6,17))
  den(5) = 1 /((L(5,12))+L(6,12))
  den(8) = 1 /((L(5,18) - MT2)+L(6,18))
  den(12) = 1 /((L(5,3))+L(6,3))
  den(15) = 1 /((L(5,28) - MZ2)+L(6,28))
  den(19) = 1 /((L(5,19) - MZ2)+L(6,19))
  den(23) = 1 /((L(5,14) - MT2)+L(6,14))
  den(31) = 1 /((L(5,19))+L(6,19))
  den(35) = 1 /((L(5,13) - MT2)+L(6,13))
  den(46) = 1 /((L(5,3) - MH2)+L(6,3))
  den(47) = 1 /((L(5,7))+L(6,7))
  den(50) = 1 /((L(5,11))+L(6,11))
  den(53) = 1 /((L(5,19) - MH2)+L(6,19))

  ! denominators
  den(3) = den(1)*den(2)
  den(6) = den(4)*den(5)
  den(7) = den(2)*den(4)
  den(9) = den(5)*den(8)
  den(10) = den(2)*den(8)
  den(11) = den(1)*den(5)
  den(13) = den(5)*den(12)
  den(14) = den(2)*den(12)
  den(16) = den(2)*den(15)
  den(17) = den(1)*den(16)
  den(18) = den(12)*den(16)
  den(20) = den(1)*den(19)
  den(21) = den(5)*den(20)
  den(22) = den(2)*den(20)
  den(24) = den(5)*den(23)
  den(25) = den(4)*den(24)
  den(26) = den(2)*den(23)
  den(27) = den(4)*den(26)
  den(28) = den(4)*den(19)
  den(29) = den(5)*den(28)
  den(30) = den(2)*den(28)
  den(32) = den(4)*den(31)
  den(33) = den(5)*den(32)
  den(34) = den(2)*den(32)
  den(36) = den(5)*den(35)
  den(37) = den(8)*den(36)
  den(38) = den(2)*den(35)
  den(39) = den(8)*den(38)
  den(40) = den(8)*den(19)
  den(41) = den(5)*den(40)
  den(42) = den(2)*den(40)
  den(43) = den(8)*den(31)
  den(44) = den(5)*den(43)
  den(45) = den(2)*den(43)
  den(48) = den(12)*den(47)
  den(49) = den(1)*den(47)
  den(51) = den(12)*den(50)
  den(52) = den(1)*den(50)
  den(54) = den(46)*den(53)
  den(55) = den(4)*den(53)
  den(56) = den(8)*den(53)
  den(57) = den(5)*den(46)
  den(58) = den(2)*den(46)
  den(59) = den(5)*den(54)
  den(60) = den(2)*den(54)
  den(61) = den(16)*den(46)
  den(62) = den(5)*den(55)
  den(63) = den(2)*den(55)
  den(64) = den(5)*den(56)
  den(65) = den(2)*den(56)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_pphtt_ew_ttxddxh_3_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,88))
  allocate(M1helarray(3,hel_states))
  allocate(M1helarray_ct(3,hel_states))
  allocate(M0_col1_helarray(3,hel_states))
#if 1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(3,hel_states,16))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
#else
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
  use ol_loop_storage_pphtt_ew_ttxddxh_3_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for top anti-top down anti-down higgs -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_pphtt_ew_ttxddxh_3, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_pphtt_ew_ttxddxh_3, only: &
    & external_perm_pphtt_ew_ttxddxh_3, &
    & external_perm_inv_pphtt_ew_ttxddxh_3, &
    & extcomb_perm_pphtt_ew_ttxddxh_3, &
    & average_factor_pphtt_ew_ttxddxh_3
  use ol_external_pphtt_ew_ttxddxh_3, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_pphtt_ew_ttxddxh_3_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pphtt_ew_ttxddxh_3_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_pphtt_ew_ttxddxh_3
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02
  logical, intent(in) :: qp_kinematics
  real(REALKIND),  intent(out), optional :: M2ct
  real(REALKIND),  intent(out), optional :: M2colint(16)
  real(REALKIND) :: iM2ct
  real(REALKIND) :: iM2colint(16)

  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(3), M2(3)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak
  logical              :: do_ct, do_colint
#if 5 > 3
  integer :: ind_cc_comb(5)
#endif
  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if (present(M2ct)) then
    do_ct = .true.
  else
    do_ct = .false.
  end if

  if (present(M2colint)) then
    do_colint = .true.
  else
    do_colint = .false.
  end if

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, qp_kinematics, M2ct=iM2ct, M2colint=iM2colint)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,88))
  end if

  if (do_ct) call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()
  if (do_ct) call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  if (do_ct) call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMT, nMT, 0, 0, nMH ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_pphtt_ew_ttxddxh_3, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMT, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rMT, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_S(P(:,5), rMH, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_Z(gZd,ntry, ex3(:), ex4(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_ST_V(ntry, wf4(:,1), 3, ex5(:), 16, wf4(:,3), n3(:,3), t3x4(:,:,3))
  call vert_QA_Z(gZu,ntry, ex1(:), ex2(:), wf4(:,4), n3(:,4), t3x4(:,:,4))
  call vert_SV_V(ntry, ex5(:), wf4(:,4), wf4(:,5), n3(:,5), t3x4(:,:,5))
  call vert_QS_A(gH,ntry, ex1(:), ex5(:), wf2(:,1), n3(:,6), t3x2(:,:,1))
  call vert_QA_V(ntry, ex3(:), ex4(:), wf4(:,6), n3(:,7), t3x4(:,:,6))
  call prop_Q_A(ntry, wf2(:,1), 17, MT, 1_intkind1, wf2(:,2), n2(1))
  call vert_QA_V(ntry, wf2(:,2), ex2(:), wf4(:,7), n3(:,8), t3x4(:,:,7))
  call vert_QA_Z(gZu,ntry, wf2(:,2), ex2(:), wf4(:,8), n3(:,9), t3x4(:,:,8))
  call vert_SA_Q(gH,ntry, ex5(:), ex2(:), wf2(:,3), n3(:,10), t3x2(:,:,2))
  call prop_A_Q(ntry, wf2(:,3), 18, MT, 1_intkind1, wf2(:,4), n2(2))
  call vert_QA_V(ntry, ex1(:), wf2(:,4), wf4(:,9), n3(:,11), t3x4(:,:,9))
  call vert_QA_Z(gZu,ntry, ex1(:), wf2(:,4), wf4(:,10), n3(:,12), t3x4(:,:,10))
  call counter_ST_V(ntry, wf4(:,1), 3, ex5(:), 16, wf4(:,11), n3(:,13), t3x4(:,:,11))
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,12), n3(:,14), t3x4(:,:,12))
  call counter_SV_V(ntry, ex5(:), wf4(:,12), wf4(:,13), n3(:,15), t3x4(:,:,13))
  call counter_SV_V(ntry, ex5(:), wf4(:,4), wf4(:,14), n3(:,16), t3x4(:,:,14))
  call counter_QA_Z(gZd,ntry, ex3(:), ex4(:), wf4(:,15), n3(:,17), t3x4(:,:,15))
  call counter_QA_Z(EWctVdd,ntry, ex3(:), ex4(:), wf4(:,16), n3(:,18), t3x4(:,:,16))
  call counter_QA_V(ntry, ex3(:), ex4(:), wf4(:,17), n3(:,19), t3x4(:,:,17))
  call counter_QA_V_LR(EWctAdd,ntry, ex3(:), ex4(:), wf4(:,18), n3(:,20), t3x4(:,:,18))
  call counter_QA_V_LR(EWctGdd,ntry, ex3(:), ex4(:), wf4(:,19), n3(:,21), t3x4(:,:,19))
  call counter_QA_V(ntry, wf2(:,2), ex2(:), wf4(:,20), n3(:,22), t3x4(:,:,20))
  call counter_QA_V_LR(EWctAtt,ntry, wf2(:,2), ex2(:), wf4(:,21), n3(:,23), t3x4(:,:,21))
  call counter_QA_Z(gZu,ntry, wf2(:,2), ex2(:), wf4(:,22), n3(:,24), t3x4(:,:,22))
  call counter_QA_Z(EWctVtt,ntry, wf2(:,2), ex2(:), wf4(:,23), n3(:,25), t3x4(:,:,23))
  call counter_QA_V_LR(EWctGtt,ntry, wf2(:,2), ex2(:), wf4(:,24), n3(:,26), t3x4(:,:,24))
  call counter_SA_Q(gH,ntry, ex5(:), ex2(:), wf2(:,5), n3(:,27), t3x2(:,:,3))
  call prop_A_Q(ntry, wf2(:,5), 18, MT, 1_intkind1, wf2(:,6), n2(3))
  call vert_QA_V(ntry, ex1(:), wf2(:,6), wf4(:,25), n3(:,28), t3x4(:,:,25))
  call counter_SA_Q(EWctHtt,ntry, ex5(:), ex2(:), wf2(:,7), n3(:,29), t3x2(:,:,4))
  call prop_A_Q(ntry, wf2(:,7), 18, MT, 1_intkind1, wf2(:,8), n2(4))
  call vert_QA_V(ntry, ex1(:), wf2(:,8), wf4(:,26), n3(:,30), t3x4(:,:,26))
  call vert_QA_Z(gZu,ntry, ex1(:), wf2(:,6), wf4(:,27), n3(:,31), t3x4(:,:,27))
  call vert_QA_Z(gZu,ntry, ex1(:), wf2(:,8), wf4(:,28), n3(:,32), t3x4(:,:,28))
  call counter_QA_V(ntry, ex1(:), wf2(:,4), wf4(:,29), n3(:,33), t3x4(:,:,29))
  call counter_QA_V_LR(EWctAtt,ntry, ex1(:), wf2(:,4), wf4(:,30), n3(:,34), t3x4(:,:,30))
  call counter_QA_Z(gZu,ntry, ex1(:), wf2(:,4), wf4(:,31), n3(:,35), t3x4(:,:,31))
  call counter_QA_Z(EWctVtt,ntry, ex1(:), wf2(:,4), wf4(:,32), n3(:,36), t3x4(:,:,32))
  call counter_QA_V_LR(EWctGtt,ntry, ex1(:), wf2(:,4), wf4(:,33), n3(:,37), t3x4(:,:,33))
  call counter_QS_A(gH,ntry, ex1(:), ex5(:), wf2(:,9), n3(:,38), t3x2(:,:,5))
  call prop_Q_A(ntry, wf2(:,9), 17, MT, 1_intkind1, wf2(:,10), n2(5))
  call vert_QA_V(ntry, wf2(:,10), ex2(:), wf4(:,34), n3(:,39), t3x4(:,:,34))
  call counter_QS_A(EWctHtt,ntry, ex1(:), ex5(:), wf2(:,11), n3(:,40), t3x2(:,:,6))
  call prop_Q_A(ntry, wf2(:,11), 17, MT, 1_intkind1, wf2(:,12), n2(6))
  call vert_QA_V(ntry, wf2(:,12), ex2(:), wf4(:,35), n3(:,41), t3x4(:,:,35))
  call vert_QA_Z(gZu,ntry, wf2(:,10), ex2(:), wf4(:,36), n3(:,42), t3x4(:,:,36))
  call vert_QA_Z(gZu,ntry, wf2(:,12), ex2(:), wf4(:,37), n3(:,43), t3x4(:,:,37))
  call counter_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,38), n3(:,44), t3x4(:,:,38))
  call vert_ST_V(ntry, wf4(:,38), 3, ex5(:), 16, wf4(:,39), n3(:,45), t3x4(:,:,39))
  call counter_AQ_S(EWctXtt,ntry, ex2(:), ex1(:), wf4(:,40), n3(:,46), t3x4(:,:,40))
  call vert_ST_V(ntry, wf4(:,40), 3, ex5(:), 16, wf4(:,41), n3(:,47), t3x4(:,:,41))
  call counter_QA_Z(gZu,ntry, ex1(:), ex2(:), wf4(:,42), n3(:,48), t3x4(:,:,42))
  call vert_SV_V(ntry, ex5(:), wf4(:,42), wf4(:,43), n3(:,49), t3x4(:,:,43))
  call counter_QA_Z(EWctVtt,ntry, ex1(:), ex2(:), wf4(:,44), n3(:,50), t3x4(:,:,44))
  call vert_SV_V(ntry, ex5(:), wf4(:,44), wf4(:,45), n3(:,51), t3x4(:,:,45))
  call vert_TV_S(ntry, ex5(:), 16, wf4(:,2), 12, wf4(:,46), n3(:,52), t3x4(:,:,46))
  call counter_S_S(EWctXX,ntry, wf4(:,1), 3, wf4(:,47), n2(7))
  call vert_SV_V(ntry, ex5(:), wf4(:,2), wf4(:,48), n3(:,53), t3x4(:,:,47))
  call counter_S_V(EWctXZ,ntry, wf4(:,1), 3, wf4(:,49), n2(8))
  call counter_V_S(EWctXA,ntry, wf4(:,12), 3, wf4(:,50), n2(9))
  call counter_V_S(EWctXZ,ntry, wf4(:,4), 3, wf4(:,51), n2(10))
  call counter_V_V(EWctAZ,ntry, wf4(:,12), 3, wf4(:,52), n2(11))
  call counter_V_V(EWctZZ,ntry, wf4(:,4), 3, wf4(:,53), n2(12))
  call vert_SS_S(ntry, wf4(:,1), ex5(:), wf4(:,54), n3(:,54), t3x4(:,:,48))
  call counter_V_S(EWctXA,ntry, wf4(:,6), 12, wf4(:,55), n2(13))
  call counter_V_S(EWctXZ,ntry, wf4(:,2), 12, wf4(:,56), n2(14))
  call vert_TV_S(ntry, ex5(:), 16, wf4(:,4), 3, wf4(:,57), n3(:,55), t3x4(:,:,49))
  call counter_V_V(EWctAZ,ntry, wf4(:,6), 12, wf4(:,58), n2(15))
  call counter_V_V(EWctZZ,ntry, wf4(:,2), 12, wf4(:,59), n2(16))
  call vert_AV_Q(ntry, ex2(:), wf4(:,6), wf8(:,1), n3(:,56), t3x8(:,:,1))
  call counter_Q_A(cttt,6,ntry, wf2(:,2), 17, wf2(:,13), n2(17))
  call prop_A_Q(ntry, wf8(:,1), 14, MT, 1_intkind1, wf8(:,2), n2(18))
  call counter_Q_A_LR(EWcttt,ntry, wf2(:,2), 17, wf2(:,14), n2(19))
  call vert_AZ_Q(gZu,ntry, ex2(:), wf4(:,2), wf8(:,3), n3(:,57), t3x8(:,:,2))
  call prop_A_Q(ntry, wf8(:,3), 14, MT, 1_intkind1, wf8(:,4), n2(20))
  call vert_AQ_S(gX,ntry, ex2(:), wf2(:,2), wf4(:,60), n3(:,58), t3x4(:,:,50))
  call counter_V_V(EWctAA,ntry, wf4(:,6), 12, wf4(:,61), n2(21))
  call counter_V_V(EWctAZ,ntry, wf4(:,2), 12, wf4(:,62), n2(22))
  call vert_VQ_A(ntry, wf4(:,6), ex1(:), wf8(:,5), n3(:,59), t3x8(:,:,3))
  call counter_A_Q(cttt,6,ntry, wf2(:,4), 18, wf2(:,15), n2(23))
  call prop_Q_A(ntry, wf8(:,5), 13, MT, 1_intkind1, wf8(:,6), n2(24))
  call counter_A_Q_LR(EWcttt,ntry, wf2(:,4), 18, wf2(:,16), n2(25))
  call vert_ZQ_A(gZu,ntry, wf4(:,2), ex1(:), wf8(:,7), n3(:,60), t3x8(:,:,4))
  call prop_Q_A(ntry, wf8(:,7), 13, MT, 1_intkind1, wf8(:,8), n2(26))
  call vert_AQ_S(gX,ntry, wf2(:,4), ex1(:), wf4(:,63), n3(:,61), t3x4(:,:,51))
  call vert_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,64), n3(:,62), t3x4(:,:,52))
  call vert_VQ_A(ntry, wf4(:,12), ex3(:), wf8(:,9), n3(:,63), t3x8(:,:,5))
  call prop_Q_A(ntry, wf8(:,9), 7, ZERO, 0_intkind1, wf8(:,10), n2(27))
  call vert_ZQ_A(gZd,ntry, wf4(:,4), ex3(:), wf8(:,11), n3(:,64), t3x8(:,:,6))
  call prop_Q_A(ntry, wf8(:,11), 7, ZERO, 0_intkind1, wf8(:,12), n2(28))
  call vert_AV_Q(ntry, ex4(:), wf4(:,12), wf8(:,13), n3(:,65), t3x8(:,:,7))
  call prop_A_Q(ntry, wf8(:,13), 11, ZERO, 0_intkind1, wf8(:,14), n2(29))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,4), wf8(:,15), n3(:,66), t3x8(:,:,8))
  call prop_A_Q(ntry, wf8(:,15), 11, ZERO, 0_intkind1, wf8(:,16), n2(30))
  call vert_SS_S(ntry, wf4(:,64), ex5(:), wf4(:,65), n3(:,67), t3x4(:,:,53))
  call vert_AQ_S(gH,ntry, ex2(:), wf2(:,2), wf4(:,66), n3(:,68), t3x4(:,:,54))
  call vert_AQ_S(gH,ntry, wf2(:,4), ex1(:), wf4(:,67), n3(:,69), t3x4(:,:,55))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    if (do_ct) call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  if (do_ct) M2ct = 0
  if (do_colint) M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    if (do_ct) call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      if (do_colint) call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    if (do_ct) M2ct = M2ct + M2add_ct
    if (do_colint) M2colint = M2colint + M2add_colint
  end do

#if 1 > 0 && 5 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    ind_cc_comb = [2,4,7,5,8]
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 5
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 1
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_VV(nsync, wf4(:,2), wf4(:,3), A(:,1), n3(:,70), t3x16(:,:,1), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,5), A(:,2), n3(:,71), t3x16(:,:,2), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,7), A(:,3), n3(:,72), t3x16(:,:,3), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,8), A(:,4), n3(:,73), t3x16(:,:,4), nhel, den(7))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,7), A(:,5), n3(:,74), t3x16(:,:,5), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,9), A(:,6), n3(:,75), t3x16(:,:,6), nhel, den(9))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,10), A(:,7), n3(:,76), t3x16(:,:,7), nhel, den(10))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,9), A(:,8), n3(:,77), t3x16(:,:,8), nhel, den(9))

    call Hcont_VV(nsync, wf4(:,6), wf4(:,11), A(:,9), n3(:,78), t3x16(:,:,9), nhel, den(11))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,11), A(:,10), n3(:,79), t3x16(:,:,10), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,13), A(:,11), n3(:,80), t3x16(:,:,11), nhel, den(13))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,13), A(:,12), n3(:,81), t3x16(:,:,12), nhel, den(14))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,14), A(:,13), n3(:,82), t3x16(:,:,13), nhel, den(11))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,14), A(:,14), n3(:,83), t3x16(:,:,14), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,3), wf4(:,15), A(:,15), n3(:,84), t3x16(:,:,15), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,3), wf4(:,16), A(:,16), n3(:,85), t3x16(:,:,16), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,5), wf4(:,15), A(:,17), n3(:,86), t3x16(:,:,17), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,5), wf4(:,16), A(:,18), n3(:,87), t3x16(:,:,18), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,17), A(:,19), n3(:,88), t3x16(:,:,19), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,18), A(:,20), n3(:,89), t3x16(:,:,20), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,8), wf4(:,15), A(:,21), n3(:,90), t3x16(:,:,21), nhel, den(7))
    call Hcont_VV(nsync, wf4(:,8), wf4(:,16), A(:,22), n3(:,91), t3x16(:,:,22), nhel, den(7))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,19), A(:,23), n3(:,92), t3x16(:,:,23), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,9), wf4(:,17), A(:,24), n3(:,93), t3x16(:,:,24), nhel, den(9))
    call Hcont_VV(nsync, wf4(:,9), wf4(:,18), A(:,25), n3(:,94), t3x16(:,:,25), nhel, den(9))
    call Hcont_VV(nsync, wf4(:,10), wf4(:,15), A(:,26), n3(:,95), t3x16(:,:,26), nhel, den(10))
    call Hcont_VV(nsync, wf4(:,10), wf4(:,16), A(:,27), n3(:,96), t3x16(:,:,27), nhel, den(10))
    call Hcont_VV(nsync, wf4(:,9), wf4(:,19), A(:,28), n3(:,97), t3x16(:,:,28), nhel, den(9))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,20), A(:,29), n3(:,98), t3x16(:,:,29), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,21), A(:,30), n3(:,99), t3x16(:,:,30), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,22), A(:,31), n3(:,100), t3x16(:,:,31), nhel, den(7))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,23), A(:,32), n3(:,101), t3x16(:,:,32), nhel, den(7))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,24), A(:,33), n3(:,102), t3x16(:,:,33), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,25), A(:,34), n3(:,103), t3x16(:,:,34), nhel, den(9))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,26), A(:,35), n3(:,104), t3x16(:,:,35), nhel, den(9))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,27), A(:,36), n3(:,105), t3x16(:,:,36), nhel, den(10))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,28), A(:,37), n3(:,106), t3x16(:,:,37), nhel, den(10))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,26), A(:,38), n3(:,107), t3x16(:,:,38), nhel, den(9))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,29), A(:,39), n3(:,108), t3x16(:,:,39), nhel, den(9))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,30), A(:,40), n3(:,109), t3x16(:,:,40), nhel, den(9))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,31), A(:,41), n3(:,110), t3x16(:,:,41), nhel, den(10))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,32), A(:,42), n3(:,111), t3x16(:,:,42), nhel, den(10))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,33), A(:,43), n3(:,112), t3x16(:,:,43), nhel, den(9))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,34), A(:,44), n3(:,113), t3x16(:,:,44), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,35), A(:,45), n3(:,114), t3x16(:,:,45), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,36), A(:,46), n3(:,115), t3x16(:,:,46), nhel, den(7))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,37), A(:,47), n3(:,116), t3x16(:,:,47), nhel, den(7))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,35), A(:,48), n3(:,117), t3x16(:,:,48), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,39), A(:,49), n3(:,118), t3x16(:,:,49), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,41), A(:,50), n3(:,119), t3x16(:,:,50), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,43), A(:,51), n3(:,120), t3x16(:,:,51), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,45), A(:,52), n3(:,121), t3x16(:,:,52), nhel, den(3))
    call Hcont_SS(nsync, wf4(:,46), wf4(:,47), A(:,53), n3(:,122), t3x16(:,:,53), nhel, den(17))
    call Hcont_VV(nsync, wf4(:,48), wf4(:,49), A(:,54), n3(:,123), t3x16(:,:,54), nhel, den(17))
    call Hcont_SS(nsync, wf4(:,46), wf4(:,50), A(:,55), n3(:,124), t3x16(:,:,55), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,46), wf4(:,51), A(:,56), n3(:,125), t3x16(:,:,56), nhel, den(17))
    call Hcont_VV(nsync, wf4(:,48), wf4(:,52), A(:,57), n3(:,126), t3x16(:,:,57), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,48), wf4(:,53), A(:,58), n3(:,127), t3x16(:,:,58), nhel, den(17))
    call Hcont_SS(nsync, wf4(:,54), wf4(:,55), A(:,59), n3(:,128), t3x16(:,:,59), nhel, den(21))
    call Hcont_SS(nsync, wf4(:,54), wf4(:,56), A(:,60), n3(:,129), t3x16(:,:,60), nhel, den(22))
    call Hcont_SS(nsync, wf4(:,55), wf4(:,57), A(:,61), n3(:,130), t3x16(:,:,61), nhel, den(21))
    call Hcont_SS(nsync, wf4(:,56), wf4(:,57), A(:,62), n3(:,131), t3x16(:,:,62), nhel, den(22))
    call Hcont_VV(nsync, wf4(:,3), wf4(:,58), A(:,63), n3(:,132), t3x16(:,:,63), nhel, den(21))
    call Hcont_VV(nsync, wf4(:,3), wf4(:,59), A(:,64), n3(:,133), t3x16(:,:,64), nhel, den(22))
    call Hcont_VV(nsync, wf4(:,5), wf4(:,58), A(:,65), n3(:,134), t3x16(:,:,65), nhel, den(21))
    call Hcont_VV(nsync, wf4(:,5), wf4(:,59), A(:,66), n3(:,135), t3x16(:,:,66), nhel, den(22))
    call Hcont_QA(nsync, wf2(:,13), wf8(:,2), A(:,67), n3(:,136), t3x16(:,:,67), nhel, den(25))
    call Hcont_QA(nsync, wf8(:,2), wf2(:,14), A(:,68), n3(:,137), t3x16(:,:,68), nhel, den(25))
    call Hcont_QA(nsync, wf2(:,13), wf8(:,4), A(:,69), n3(:,138), t3x16(:,:,69), nhel, den(27))
    call Hcont_QA(nsync, wf2(:,14), wf8(:,4), A(:,70), n3(:,139), t3x16(:,:,70), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,2), wf2(:,14), A(:,71), n3(:,140), t3x16(:,:,71), nhel, den(25))
    call Hcont_SS(nsync, wf4(:,55), wf4(:,60), A(:,72), n3(:,141), t3x16(:,:,72), nhel, den(29))
    call Hcont_SS(nsync, wf4(:,56), wf4(:,60), A(:,73), n3(:,142), t3x16(:,:,73), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,61), A(:,74), n3(:,143), t3x16(:,:,74), nhel, den(33))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,62), A(:,75), n3(:,144), t3x16(:,:,75), nhel, den(34))
    call Hcont_VV(nsync, wf4(:,8), wf4(:,58), A(:,76), n3(:,145), t3x16(:,:,76), nhel, den(29))
    call Hcont_VV(nsync, wf4(:,8), wf4(:,59), A(:,77), n3(:,146), t3x16(:,:,77), nhel, den(30))
    call Hcont_QA(nsync, wf2(:,15), wf8(:,6), A(:,78), n3(:,147), t3x16(:,:,78), nhel, den(37))
    call Hcont_QA(nsync, wf8(:,6), wf2(:,16), A(:,79), n3(:,148), t3x16(:,:,79), nhel, den(37))
    call Hcont_QA(nsync, wf2(:,15), wf8(:,8), A(:,80), n3(:,149), t3x16(:,:,80), nhel, den(39))
    call Hcont_QA(nsync, wf2(:,16), wf8(:,8), A(:,81), n3(:,150), t3x16(:,:,81), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,6), wf2(:,16), A(:,82), n3(:,151), t3x16(:,:,82), nhel, den(37))
    call Hcont_SS(nsync, wf4(:,55), wf4(:,63), A(:,83), n3(:,152), t3x16(:,:,83), nhel, den(41))
    call Hcont_SS(nsync, wf4(:,56), wf4(:,63), A(:,84), n3(:,153), t3x16(:,:,84), nhel, den(42))
    call Hcont_VV(nsync, wf4(:,9), wf4(:,61), A(:,85), n3(:,154), t3x16(:,:,85), nhel, den(44))
    call Hcont_VV(nsync, wf4(:,9), wf4(:,62), A(:,86), n3(:,155), t3x16(:,:,86), nhel, den(45))
    call Hcont_VV(nsync, wf4(:,10), wf4(:,58), A(:,87), n3(:,156), t3x16(:,:,87), nhel, den(41))
    call Hcont_VV(nsync, wf4(:,10), wf4(:,59), A(:,88), n3(:,157), t3x16(:,:,88), nhel, den(42))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(3), M2(3) ! M1helarray(3,nhel)
  integer :: empty(0), i

  M1(1)%j = ((A(j,5)%j+A(j,8)%j)*f(30))/2._/**/REALKIND
  M1(2)%j = A(j,1)%j*f(13)+(-A(j,3)%j-A(j,6)%j)*f(21)+(A(j,4)%j+A(j,7)%j)*f(22)+A(j,2)%j*f(39)
  M1(3)%j = ((-A(j,5)%j-A(j,8)%j)*f(30))/6._/**/REALKIND

  M2(1)%j = ((-A(j,38)%j-A(j,48)%j)*f(7))/2._/**/REALKIND+((A(j,23)%j+A(j,28)%j+A(j,33)%j+A(j,43)%j-A(j,71)%j &
       -A(j,82)%j)*f(32))/2._/**/REALKIND
  M2(2)%j = ((A(j,38)%j+A(j,48)%j)*f(7))/6._/**/REALKIND+A(j,49)%j*f(16)+A(j,15)%j*f(17)+(A(j,67)%j+A(j,78)%j)*f(31)+(-A(j,69)%j &
       -A(j,80)%j)*f(32)+((-A(j,23)%j-A(j,28)%j-A(j,33)%j-A(j,43)%j+A(j,71)%j+A(j,82)%j)*f(32))/6._/**/REALKIND+(-A(j,34)%j &
       -A(j,44)%j)*f(33)+(A(j,36)%j+A(j,46)%j)*f(34)+(-A(j,19)%j-A(j,24)%j)*f(35)+(A(j,21)%j+A(j,26)%j)*f(36)+(-A(j,29)%j &
       -A(j,39)%j)*f(37)+(A(j,31)%j+A(j,41)%j)*f(38)+A(j,17)%j*f(43)+A(j,51)%j*f(44)
  M2(3)%j = -(A(j,11)%j*f(1))+A(j,13)%j*f(2)-A(j,12)%j*f(3)+A(j,14)%j*f(4)+(A(j,35)%j+A(j,45)%j)*f(5)+(-A(j,37)%j-A(j,47)%j)*f(6) &
       -A(j,54)%j*f(8)-A(j,59)%j*f(9)-A(j,60)%j*f(10)+(-A(j,72)%j-A(j,83)%j)*f(11)+(-A(j,73)%j-A(j,84)%j)*f(12)-A(j,63)%j*f(14) &
       +(A(j,16)%j-A(j,53)%j-A(j,64)%j)*f(15)-A(j,61)%j*f(18)+A(j,55)%j*f(19)+(-A(j,56)%j-A(j,62)%j)*f(20)+(A(j,68)%j+A(j,74)%j &
       +A(j,79)%j+A(j,85)%j)*f(23)+(A(j,30)%j+A(j,40)%j-A(j,76)%j-A(j,87)%j)*f(24)+(-A(j,20)%j-A(j,25)%j+A(j,75)%j &
       +A(j,86)%j)*f(25)+(A(j,22)%j+A(j,27)%j+A(j,32)%j+A(j,42)%j-A(j,70)%j-A(j,77)%j-A(j,81)%j-A(j,88)%j)*f(26)-A(j,50)%j*f(27) &
       -A(j,9)%j*f(28)-A(j,10)%j*f(29)-A(j,65)%j*f(40)+A(j,57)%j*f(41)+(A(j,18)%j+A(j,52)%j-A(j,58)%j-A(j,66)%j)*f(42)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphtt_ew_ttxddxh_3_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(3)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 3
      do j = 1, 3
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphtt_ew_ttxddxh_3_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(3), Mct(3)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 3
    do j = 1, 3
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+3*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_pphtt_ew_ttxddxh_3_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(3)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 3*k
    do i = 1, 3
      do j = 1, 3
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphtt_ew_ttxddxh_3_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(3)
  complex(REALKIND), intent(in)  :: M2(3)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 3
    do j = 1, 3
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_pphtt_ew_ttxddxh_3_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(3)
  type(Hpolcont), intent(out)  :: M0_col(3)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 3 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 3 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+3*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_pphtt_ew_ttxddxh_3_/**/REALKIND
