
module ol_colourmatrix_pphtt_ew_ttxddxh_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(51,3), K2(51,4), KL(51,4), Cas(5) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [   9,   0,   3]
  K1( 2,:) = [   0,   0,   0]
  K1( 3,:) = [   3,   0,   9]
  K1( 4,:) = [   0,   4,   0]
  K1( 5,:) = [   4,   0,  12]
  K1( 6,:) = [   0,  12,   0]
  K1( 7,:) = [   0,  -4,   0]
  K1( 8,:) = [  -4,   0, -12]
  K1( 9,:) = [   0, -12,   0]
  K1(10,:) = [   0,   4,   0]
  K1(11,:) = [   4,   0,  12]
  K1(12,:) = [   0,  12,   0]
  K1(13,:) = [   0,   4,   0]
  K1(14,:) = [   4,   0,   0]
  K1(15,:) = [   0,   0,   0]
  K1(16,:) = [   0,  -4,   0]
  K1(17,:) = [  -4,   0,   0]
  K1(18,:) = [   0,   0,   0]
  K1(19,:) = [   0,   4,   0]
  K1(20,:) = [   4,   0,  12]
  K1(21,:) = [   0,  12,   0]
  K1(22,:) = [   0,  -4,   0]
  K1(23,:) = [  -4,   0,   0]
  K1(24,:) = [   0,   0,   0]
  K1(25,:) = [   0,   4,   0]
  K1(26,:) = [   4,   0,   0]
  K1(27,:) = [   0,   0,   0]
  K1(28,:) = [   0,  -4,   0]
  K1(29,:) = [  -4,   0, -12]
  K1(30,:) = [   0, -12,   0]
  K1(31,:) = [   0,   4,   0]
  K1(32,:) = [   4,   0,  12]
  K1(33,:) = [   0,  12,   0]
  K1(34,:) = [   0,   0,   0]
  K1(35,:) = [   0,   0,   0]
  K1(36,:) = [   0,   0,   0]
  K1(37,:) = [   0,   0,   0]
  K1(38,:) = [   0,   0,   0]
  K1(39,:) = [   0,   0,   0]
  K1(40,:) = [   0,   0,   0]
  K1(41,:) = [   0,   0,   0]
  K1(42,:) = [   0,   0,   0]
  K1(43,:) = [   0,   0,   0]
  K1(44,:) = [   0,   0,   0]
  K1(45,:) = [   0,   0,   0]
  K1(46,:) = [   0,   0,   0]
  K1(47,:) = [   0,   0,   0]
  K1(48,:) = [   0,   0,   0]
  K1(49,:) = [   9,   0,   3]
  K1(50,:) = [   0,   0,   0]
  K1(51,:) = [   3,   0,   9]

  K2( 1,:) = [   9,   0,   3,   0]
  K2( 2,:) = [   0,   3,   0,   9]
  K2( 3,:) = [   3,   0,   9,   0]
  K2( 4,:) = [   0,   0,   0,   0]
  K2( 5,:) = [   4,   0,  12,   0]
  K2( 6,:) = [   0,   0,   0,   0]
  K2( 7,:) = [   0,   0,   0,   0]
  K2( 8,:) = [  -4,   0, -12,   0]
  K2( 9,:) = [   0,   0,   0,   0]
  K2(10,:) = [   0,   0,   0,   0]
  K2(11,:) = [   4,   0,  12,   0]
  K2(12,:) = [   0,   0,   0,   0]
  K2(13,:) = [   0,   0,   0,   0]
  K2(14,:) = [   4,   0,   0,   0]
  K2(15,:) = [   0,   0,   0,   0]
  K2(16,:) = [   0,   0,   0,   0]
  K2(17,:) = [  -4,   0,   0,   0]
  K2(18,:) = [   0,   0,   0,   0]
  K2(19,:) = [   0,   0,   0,   0]
  K2(20,:) = [   4,   0,  12,   0]
  K2(21,:) = [   0,   0,   0,   0]
  K2(22,:) = [   0,   0,   0,   0]
  K2(23,:) = [  -4,   0,   0,   0]
  K2(24,:) = [   0,   0,   0,   0]
  K2(25,:) = [   0,   0,   0,   0]
  K2(26,:) = [   4,   0,   0,   0]
  K2(27,:) = [   0,   0,   0,   0]
  K2(28,:) = [   0,   0,   0,   0]
  K2(29,:) = [  -4,   0, -12,   0]
  K2(30,:) = [   0,   0,   0,   0]
  K2(31,:) = [   0,   0,   0,   0]
  K2(32,:) = [   4,   0,  12,   0]
  K2(33,:) = [   0,   0,   0,   0]
  K2(34,:) = [   0,   0,   0,   0]
  K2(35,:) = [   0,   0,   0,   0]
  K2(36,:) = [   0,   0,   0,   0]
  K2(37,:) = [   0,   0,   0,   0]
  K2(38,:) = [   0,   0,   0,   0]
  K2(39,:) = [   0,   0,   0,   0]
  K2(40,:) = [   0,   0,   0,   0]
  K2(41,:) = [   0,   0,   0,   0]
  K2(42,:) = [   0,   0,   0,   0]
  K2(43,:) = [   0,   0,   0,   0]
  K2(44,:) = [   0,   0,   0,   0]
  K2(45,:) = [   0,   0,   0,   0]
  K2(46,:) = [   0,   0,   0,   0]
  K2(47,:) = [   0,   0,   0,   0]
  K2(48,:) = [   0,   0,   0,   0]
  K2(49,:) = [   9,   0,   3,   0]
  K2(50,:) = [   0,   3,   0,   9]
  K2(51,:) = [   3,   0,   9,   0]

  KL( 1,:) = [   9,   0,   3,   0]
  KL( 2,:) = [   0,   3,   0,   9]
  KL( 3,:) = [   3,   0,   9,   0]
  KL( 4,:) = [   0,   0,   0,   0]
  KL( 5,:) = [   4,   0,  12,   0]
  KL( 6,:) = [   0,   0,   0,   0]
  KL( 7,:) = [   0,   0,   0,   0]
  KL( 8,:) = [  -4,   0, -12,   0]
  KL( 9,:) = [   0,   0,   0,   0]
  KL(10,:) = [   0,   0,   0,   0]
  KL(11,:) = [   4,   0,  12,   0]
  KL(12,:) = [   0,   0,   0,   0]
  KL(13,:) = [   0,   0,   0,   0]
  KL(14,:) = [   4,   0,   0,   0]
  KL(15,:) = [   0,   0,   0,   0]
  KL(16,:) = [   0,   0,   0,   0]
  KL(17,:) = [  -4,   0,   0,   0]
  KL(18,:) = [   0,   0,   0,   0]
  KL(19,:) = [   0,   0,   0,   0]
  KL(20,:) = [   4,   0,  12,   0]
  KL(21,:) = [   0,   0,   0,   0]
  KL(22,:) = [   0,   0,   0,   0]
  KL(23,:) = [  -4,   0,   0,   0]
  KL(24,:) = [   0,   0,   0,   0]
  KL(25,:) = [   0,   0,   0,   0]
  KL(26,:) = [   4,   0,   0,   0]
  KL(27,:) = [   0,   0,   0,   0]
  KL(28,:) = [   0,   0,   0,   0]
  KL(29,:) = [  -4,   0, -12,   0]
  KL(30,:) = [   0,   0,   0,   0]
  KL(31,:) = [   0,   0,   0,   0]
  KL(32,:) = [   4,   0,  12,   0]
  KL(33,:) = [   0,   0,   0,   0]
  KL(34,:) = [   0,   0,   0,   0]
  KL(35,:) = [   0,   0,   0,   0]
  KL(36,:) = [   0,   0,   0,   0]
  KL(37,:) = [   0,   0,   0,   0]
  KL(38,:) = [   0,   0,   0,   0]
  KL(39,:) = [   0,   0,   0,   0]
  KL(40,:) = [   0,   0,   0,   0]
  KL(41,:) = [   0,   0,   0,   0]
  KL(42,:) = [   0,   0,   0,   0]
  KL(43,:) = [   0,   0,   0,   0]
  KL(44,:) = [   0,   0,   0,   0]
  KL(45,:) = [   0,   0,   0,   0]
  KL(46,:) = [   0,   0,   0,   0]
  KL(47,:) = [   0,   0,   0,   0]
  KL(48,:) = [   0,   0,   0,   0]
  KL(49,:) = [   9,   0,   3,   0]
  KL(50,:) = [   0,   3,   0,   9]
  KL(51,:) = [   3,   0,   9,   0]

#if 1 > 0
    co = 0
    do k = 1, 5
      co = co + k
      Cas(k) = K1(1+3*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_pphtt_ew_ttxddxh_1_/**/REALKIND



module ol_forced_parameters_pphtt_ew_ttxddxh_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pphtt_ew_ttxddxh_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_pphtt_ew_ttxddxh_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 16 ! number of helicity configurations
  integer(intkind2), save :: nhel = 16 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 16 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(16) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(37)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(1)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf2(2,16), wf4(4,34), wf8(8,12), wf16(16,47)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(45), c(55)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_pphtt_ew_ttxddxh_1_/**/REALKIND






! **********************************************************************
module ol_loop_pphtt_ew_ttxddxh_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_pphtt_ew_ttxddxh_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = CI*countertermnorm*ctHGG*eQED*gQCD**4
    f( 2) = (CI*countertermnorm*eQED**3*gQCD**2*MT)/MW
    f( 3) = (CI*eQED**3*MT)/(4._/**/REALKIND*cw*MW*sw**2)
    f( 4) = (CI*countertermnorm*ctStt*eQED**3*gQCD**2*MT)/(4._/**/REALKIND*cw*MW*sw**2)
    f( 5) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2*MT)/(4._/**/REALKIND*cw*MW*sw**2)
    f( 6) = (CI*eQED**3*MT)/(9._/**/REALKIND*MW*sw)
    f( 7) = (CI*eQED**3*MT)/(2._/**/REALKIND*MW*sw)
    f( 8) = (CI*eQED*gQCD**2*MT)/(2._/**/REALKIND*MW*sw)
    f( 9) = (CI*countertermnorm*eQED**3*gQCD**2*MT)/(9._/**/REALKIND*MW*sw)
    f(10) = (CI*countertermnorm*eQED**3*gQCD**2*MT)/(2._/**/REALKIND*MW*sw)
    f(11) = (CI*countertermnorm*ctStt*eQED**3*gQCD**2*MT)/(9._/**/REALKIND*MW*sw)
    f(12) = (CI*countertermnorm*ctStt*eQED**3*gQCD**2*MT)/(2._/**/REALKIND*MW*sw)
    f(13) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2*MT)/(9._/**/REALKIND*MW*sw)
    f(14) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2*MT)/(2._/**/REALKIND*MW*sw)
    f(15) = (CI*countertermnorm*ctVtt*eQED**3*gQCD**2*MT)/(9._/**/REALKIND*MW*sw)
    f(16) = (CI*countertermnorm*ctVtt*eQED**3*gQCD**2*MT)/(2._/**/REALKIND*MW*sw)
    f(17) = (CI*countertermnorm*eQED*gQCD**4*MT)/(2._/**/REALKIND*MW*sw)
    f(18) = (CI*countertermnorm*ctGqq*eQED*gQCD**4*MT)/(2._/**/REALKIND*MW*sw)
    f(19) = (CI*countertermnorm*ctGtt*eQED*gQCD**4*MT)/(2._/**/REALKIND*MW*sw)
    f(20) = (CI*countertermnorm*ctStt*eQED*gQCD**4*MT)/(2._/**/REALKIND*MW*sw)
    f(21) = (CI*eQED**3*MW)/(cw**2*sw)
    f(22) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2*MW)/(cw**2*sw)
    f(23) = (CI*countertermnorm*ctVtt*eQED**3*gQCD**2*MW)/(cw**2*sw)
    f(24) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f(25) = (eQED**3*gQCD**2*integralnorm*MH**2*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f(26) = (eQED**3*gQCD**2*integralnorm*MT*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f(27) = (eQED**3*gQCD**2*integralnorm*MH**2*MT**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(28) = (3*eQED**3*gQCD**2*integralnorm*lambdaHHH*MH**2*MT**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(29) = (eQED**3*gQCD**2*integralnorm*MT**3*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(30) = (eQED**3*gQCD**2*integralnorm*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(31) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(32) = (eQED**3*gQCD**2*integralnorm*MT*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(33) = (eQED**3*gQCD**2*integralnorm*MW*SwB)/(sw**3*2._/**/REALKIND)
    f(34) = (eQED**3*gQCD**2*integralnorm*MT*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(35) = (eQED**3*gQCD**2*integralnorm*MT*SwB)/(MW*sw*18._/**/REALKIND)
    f(36) = (eQED**3*gQCD**2*integralnorm*MT*SwB)/(MW*sw*9._/**/REALKIND)
    f(37) = (2*eQED**3*gQCD**2*integralnorm*MT*SwB)/(MW*sw*9._/**/REALKIND)
    f(38) = (eQED**3*gQCD**2*integralnorm*MT*SwB)/(MW*sw*2._/**/REALKIND)
    f(39) = (CI*eQED*gQCD**4*integralnorm*MT*SwB)/(2._/**/REALKIND*MW*sw)
    f(40) = (eQED*gQCD**4*integralnorm*MT*SwB)/(MW*sw*4._/**/REALKIND)
    f(41) = (eQED*gQCD**4*integralnorm*MT*SwB)/(MW*sw*2._/**/REALKIND)
    f(42) = (eQED**3*gQCD**2*integralnorm*MW*SwB)/(cw**2*sw)
    f(43) = (eQED*gQCD**4*integralnorm*MB*SwF)/(MW*sw*2._/**/REALKIND)
    f(44) = (eQED*gQCD**4*integralnorm*MT*SwF)/(MW*sw*2._/**/REALKIND)
    f(45) = (eQED*gQCD**4*integralnorm*MT*SwF)/(MW*sw)

  c = [ 6*f(24), 18*f(24), 6*f(25), 18*f(25), 6*f(26), 18*f(26), 6*f(27), 18*f(27), 6*f(28), 18*f(28), 6*f(29), 18*f(29), 6*f(30) &
    , 18*f(30), 6*f(31), 18*f(31), 6*f(32), 18*f(32), 6*f(33), 18*f(33), 6*f(34), 18*f(34), 48*f(34), 6*f(35), 18*f(35), 6*f(36) &
    , 18*f(36), 48*f(36), 6*f(37), 18*f(37), 6*f(38), 18*f(38), 48*f(38), 9*CI*f(39), 27*CI*f(39), 18*f(40), 54*f(40), f(41) &
    , 3*f(41), 6*f(41), 8*f(41), 10*f(41), 18*f(41), 21*f(41), 24*f(41), 54*f(41), 6*f(42), 18*f(42), 48*f(42), 3*f(43), 9*f(43) &
    , 3*f(44), 9*f(44), 3*f(45), 9*f(45) ]
  c = (1._/**/REALKIND / 36) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(2) = 1 /((L(5,12) - MZ2)+L(6,12))
  den(4) = 1 /((L(5,17) - MT2)+L(6,17))
  den(5) = 1 /((L(5,12))+L(6,12))
  den(8) = 1 /((L(5,18) - MT2)+L(6,18))
  den(11) = 1 /((L(5,3))+L(6,3))
  den(13) = 1 /((L(5,14) - MT2)+L(6,14))
  den(18) = 1 /((L(5,19))+L(6,19))
  den(21) = 1 /((L(5,13) - MT2)+L(6,13))
  den(28) = 1 /((L(5,7))+L(6,7))
  den(30) = 1 /((L(5,11))+L(6,11))
  den(32) = 1 /((L(5,19) - MZ2)+L(6,19))
  den(34) = 1 /((L(5,28) - MZ2)+L(6,28))

  ! denominators
  den(3) = den(1)*den(2)
  den(6) = den(4)*den(5)
  den(7) = den(2)*den(4)
  den(9) = den(5)*den(8)
  den(10) = den(2)*den(8)
  den(12) = den(5)*den(11)
  den(14) = den(5)*den(13)
  den(15) = den(4)*den(14)
  den(16) = den(2)*den(13)
  den(17) = den(4)*den(16)
  den(19) = den(4)*den(18)
  den(20) = den(5)*den(19)
  den(22) = den(5)*den(21)
  den(23) = den(8)*den(22)
  den(24) = den(2)*den(21)
  den(25) = den(8)*den(24)
  den(26) = den(8)*den(18)
  den(27) = den(5)*den(26)
  den(29) = den(11)*den(28)
  den(31) = den(11)*den(30)
  den(33) = den(1)*den(32)
  den(35) = den(2)*den(34)
  den(36) = den(4)*den(32)
  den(37) = den(8)*den(32)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_pphtt_ew_ttxddxh_1_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,47))
  allocate(M1helarray(3,hel_states))
  allocate(M1helarray_ct(4,hel_states))
  allocate(M0_col1_helarray(4,hel_states))
#if 1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(4,hel_states,16))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
#else
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
  use ol_loop_storage_pphtt_ew_ttxddxh_1_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for top anti-top down anti-down higgs -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_pphtt_ew_ttxddxh_1, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_pphtt_ew_ttxddxh_1, only: &
    & external_perm_pphtt_ew_ttxddxh_1, &
    & external_perm_inv_pphtt_ew_ttxddxh_1, &
    & extcomb_perm_pphtt_ew_ttxddxh_1, &
    & average_factor_pphtt_ew_ttxddxh_1
  use ol_external_pphtt_ew_ttxddxh_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_pphtt_ew_ttxddxh_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pphtt_ew_ttxddxh_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_pphtt_ew_ttxddxh_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02
  logical, intent(in) :: qp_kinematics
  real(REALKIND),  intent(out), optional :: M2ct
  real(REALKIND),  intent(out), optional :: M2colint(16)
  real(REALKIND) :: iM2ct
  real(REALKIND) :: iM2colint(16)

  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(3), M2(4)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak
  logical              :: do_ct, do_colint
#if 5 > 3
  integer :: ind_cc_comb(5)
#endif
  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if (present(M2ct)) then
    do_ct = .true.
  else
    do_ct = .false.
  end if

  if (present(M2colint)) then
    do_colint = .true.
  else
    do_colint = .false.
  end if

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, qp_kinematics, M2ct=iM2ct, M2colint=iM2colint)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,47))
  end if

  if (do_ct) call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()
  if (do_ct) call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  if (do_ct) call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMT, nMT, 0, 0, nMH ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_pphtt_ew_ttxddxh_1, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMT, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rMT, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_S(P(:,5), rMH, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_Z(gZd,ntry, ex3(:), ex4(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_ST_V(ntry, wf4(:,1), 3, ex5(:), 16, wf4(:,3), n3(:,3), t3x4(:,:,3))
  call vert_QA_Z(gZu,ntry, ex1(:), ex2(:), wf4(:,4), n3(:,4), t3x4(:,:,4))
  call vert_SV_V(ntry, ex5(:), wf4(:,4), wf4(:,5), n3(:,5), t3x4(:,:,5))
  call vert_QS_A(gH,ntry, ex1(:), ex5(:), wf2(:,1), n3(:,6), t3x2(:,:,1))
  call vert_QA_V(ntry, ex3(:), ex4(:), wf4(:,6), n3(:,7), t3x4(:,:,6))
  call prop_Q_A(ntry, wf2(:,1), 17, MT, 1_intkind1, wf2(:,2), n2(1))
  call vert_QA_V(ntry, wf2(:,2), ex2(:), wf4(:,7), n3(:,8), t3x4(:,:,7))
  call vert_QA_Z(gZu,ntry, wf2(:,2), ex2(:), wf4(:,8), n3(:,9), t3x4(:,:,8))
  call vert_SA_Q(gH,ntry, ex5(:), ex2(:), wf2(:,3), n3(:,10), t3x2(:,:,2))
  call prop_A_Q(ntry, wf2(:,3), 18, MT, 1_intkind1, wf2(:,4), n2(2))
  call vert_QA_V(ntry, ex1(:), wf2(:,4), wf4(:,9), n3(:,11), t3x4(:,:,9))
  call vert_QA_Z(gZu,ntry, ex1(:), wf2(:,4), wf4(:,10), n3(:,12), t3x4(:,:,10))
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,11), n3(:,13), t3x4(:,:,11))
  call counter_SG_G(ntry, ex5(:), wf4(:,11), wf4(:,12), n3(:,14), t3x4(:,:,12))
  call counter_QA_Z(gZd,ntry, ex3(:), ex4(:), wf4(:,13), n3(:,15), t3x4(:,:,13))
  call counter_QA_V(ntry, ex3(:), ex4(:), wf4(:,14), n3(:,16), t3x4(:,:,14))
  call counter_QA_V_LR(EWctGdd,ntry, ex3(:), ex4(:), wf4(:,15), n3(:,17), t3x4(:,:,15))
  call counter_QA_V(ntry, wf2(:,2), ex2(:), wf4(:,16), n3(:,18), t3x4(:,:,16))
  call counter_QA_Z(gZu,ntry, wf2(:,2), ex2(:), wf4(:,17), n3(:,19), t3x4(:,:,17))
  call counter_QA_V_LR(EWctGtt,ntry, wf2(:,2), ex2(:), wf4(:,18), n3(:,20), t3x4(:,:,18))
  call counter_SA_Q(gH,ntry, ex5(:), ex2(:), wf2(:,5), n3(:,21), t3x2(:,:,3))
  call prop_A_Q(ntry, wf2(:,5), 18, MT, 1_intkind1, wf2(:,6), n2(3))
  call vert_QA_V(ntry, ex1(:), wf2(:,6), wf4(:,19), n3(:,22), t3x4(:,:,19))
  call vert_QA_Z(gZu,ntry, ex1(:), wf2(:,6), wf4(:,20), n3(:,23), t3x4(:,:,20))
  call counter_SA_Q(EWctHtt,ntry, ex5(:), ex2(:), wf2(:,7), n3(:,24), t3x2(:,:,4))
  call prop_A_Q(ntry, wf2(:,7), 18, MT, 1_intkind1, wf2(:,8), n2(4))
  call vert_QA_V(ntry, ex1(:), wf2(:,8), wf4(:,21), n3(:,25), t3x4(:,:,21))
  call counter_QA_V(ntry, ex1(:), wf2(:,4), wf4(:,22), n3(:,26), t3x4(:,:,22))
  call counter_QA_Z(gZu,ntry, ex1(:), wf2(:,4), wf4(:,23), n3(:,27), t3x4(:,:,23))
  call counter_QA_V_LR(EWctGtt,ntry, ex1(:), wf2(:,4), wf4(:,24), n3(:,28), t3x4(:,:,24))
  call counter_QS_A(gH,ntry, ex1(:), ex5(:), wf2(:,9), n3(:,29), t3x2(:,:,5))
  call prop_Q_A(ntry, wf2(:,9), 17, MT, 1_intkind1, wf2(:,10), n2(5))
  call vert_QA_V(ntry, wf2(:,10), ex2(:), wf4(:,25), n3(:,30), t3x4(:,:,25))
  call vert_QA_Z(gZu,ntry, wf2(:,10), ex2(:), wf4(:,26), n3(:,31), t3x4(:,:,26))
  call counter_QS_A(EWctHtt,ntry, ex1(:), ex5(:), wf2(:,11), n3(:,32), t3x2(:,:,6))
  call prop_Q_A(ntry, wf2(:,11), 17, MT, 1_intkind1, wf2(:,12), n2(6))
  call vert_QA_V(ntry, wf2(:,12), ex2(:), wf4(:,27), n3(:,33), t3x4(:,:,27))
  call counter_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,28), n3(:,34), t3x4(:,:,28))
  call vert_ST_V(ntry, wf4(:,28), 3, ex5(:), 16, wf4(:,29), n3(:,35), t3x4(:,:,29))
  call counter_QA_Z(gZu,ntry, ex1(:), ex2(:), wf4(:,30), n3(:,36), t3x4(:,:,30))
  call vert_SV_V(ntry, ex5(:), wf4(:,30), wf4(:,31), n3(:,37), t3x4(:,:,31))
  call vert_AV_Q(ntry, ex2(:), wf4(:,6), wf8(:,1), n3(:,38), t3x8(:,:,1))
  call counter_Q_A(cttt,6,ntry, wf2(:,2), 17, wf2(:,13), n2(7))
  call prop_A_Q(ntry, wf8(:,1), 14, MT, 1_intkind1, wf8(:,2), n2(8))
  call vert_AZ_Q(gZu,ntry, ex2(:), wf4(:,2), wf8(:,3), n3(:,39), t3x8(:,:,2))
  call prop_A_Q(ntry, wf8(:,3), 14, MT, 1_intkind1, wf8(:,4), n2(9))
  call counter_Q_A_LR(EWcttt,ntry, wf2(:,2), 17, wf2(:,14), n2(10))
  call counter_V_V(ctGG,21,ntry, wf4(:,6), 12, wf4(:,32), n2(11))
  call vert_VQ_A(ntry, wf4(:,6), ex1(:), wf8(:,5), n3(:,40), t3x8(:,:,3))
  call counter_A_Q(cttt,6,ntry, wf2(:,4), 18, wf2(:,15), n2(12))
  call prop_Q_A(ntry, wf8(:,5), 13, MT, 1_intkind1, wf8(:,6), n2(13))
  call vert_ZQ_A(gZu,ntry, wf4(:,2), ex1(:), wf8(:,7), n3(:,41), t3x8(:,:,4))
  call prop_Q_A(ntry, wf8(:,7), 13, MT, 1_intkind1, wf8(:,8), n2(14))
  call counter_A_Q_LR(EWcttt,ntry, wf2(:,4), 18, wf2(:,16), n2(15))
  call vert_VQ_A(ntry, wf4(:,11), ex3(:), wf8(:,9), n3(:,42), t3x8(:,:,5))
  call prop_Q_A(ntry, wf8(:,9), 7, ZERO, 0_intkind1, wf8(:,10), n2(16))
  call vert_AV_Q(ntry, ex4(:), wf4(:,11), wf8(:,11), n3(:,43), t3x8(:,:,6))
  call prop_A_Q(ntry, wf8(:,11), 11, ZERO, 0_intkind1, wf8(:,12), n2(17))
  call vert_TV_S(ntry, ex5(:), 16, wf4(:,2), 12, wf4(:,33), n3(:,44), t3x4(:,:,32))
  call vert_SV_V(ntry, ex5(:), wf4(:,2), wf4(:,34), n3(:,45), t3x4(:,:,33))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    if (do_ct) call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  if (do_ct) M2ct = 0
  if (do_colint) M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    if (do_ct) call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      if (do_colint) call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    if (do_ct) M2ct = M2ct + M2add_ct
    if (do_colint) M2colint = M2colint + M2add_colint
  end do

#if 1 > 0 && 5 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    ind_cc_comb = [2,4,7,5,8]
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 5
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 1
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_VV(nsync, wf4(:,2), wf4(:,3), A(:,1), n3(:,46), t3x16(:,:,1), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,5), A(:,2), n3(:,47), t3x16(:,:,2), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,7), A(:,3), n3(:,48), t3x16(:,:,3), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,8), A(:,4), n3(:,49), t3x16(:,:,4), nhel, den(7))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,7), A(:,5), n3(:,50), t3x16(:,:,5), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,9), A(:,6), n3(:,51), t3x16(:,:,6), nhel, den(9))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,10), A(:,7), n3(:,52), t3x16(:,:,7), nhel, den(10))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,9), A(:,8), n3(:,53), t3x16(:,:,8), nhel, den(9))

    call Hcont_VV(nsync, wf4(:,6), wf4(:,12), A(:,9), n3(:,54), t3x16(:,:,9), nhel, den(12))
    call Hcont_VV(nsync, wf4(:,3), wf4(:,13), A(:,10), n3(:,55), t3x16(:,:,10), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,5), wf4(:,13), A(:,11), n3(:,56), t3x16(:,:,11), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,14), A(:,12), n3(:,57), t3x16(:,:,12), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,8), wf4(:,13), A(:,13), n3(:,58), t3x16(:,:,13), nhel, den(7))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,14), A(:,14), n3(:,59), t3x16(:,:,14), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,15), A(:,15), n3(:,60), t3x16(:,:,15), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,9), wf4(:,14), A(:,16), n3(:,61), t3x16(:,:,16), nhel, den(9))
    call Hcont_VV(nsync, wf4(:,10), wf4(:,13), A(:,17), n3(:,62), t3x16(:,:,17), nhel, den(10))
    call Hcont_VV(nsync, wf4(:,9), wf4(:,14), A(:,18), n3(:,63), t3x16(:,:,18), nhel, den(9))
    call Hcont_VV(nsync, wf4(:,9), wf4(:,15), A(:,19), n3(:,64), t3x16(:,:,19), nhel, den(9))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,16), A(:,20), n3(:,65), t3x16(:,:,20), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,17), A(:,21), n3(:,66), t3x16(:,:,21), nhel, den(7))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,16), A(:,22), n3(:,67), t3x16(:,:,22), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,18), A(:,23), n3(:,68), t3x16(:,:,23), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,19), A(:,24), n3(:,69), t3x16(:,:,24), nhel, den(9))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,20), A(:,25), n3(:,70), t3x16(:,:,25), nhel, den(10))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,19), A(:,26), n3(:,71), t3x16(:,:,26), nhel, den(9))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,21), A(:,27), n3(:,72), t3x16(:,:,27), nhel, den(9))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,22), A(:,28), n3(:,73), t3x16(:,:,28), nhel, den(9))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,23), A(:,29), n3(:,74), t3x16(:,:,29), nhel, den(10))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,22), A(:,30), n3(:,75), t3x16(:,:,30), nhel, den(9))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,24), A(:,31), n3(:,76), t3x16(:,:,31), nhel, den(9))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,25), A(:,32), n3(:,77), t3x16(:,:,32), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,26), A(:,33), n3(:,78), t3x16(:,:,33), nhel, den(7))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,25), A(:,34), n3(:,79), t3x16(:,:,34), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,6), wf4(:,27), A(:,35), n3(:,80), t3x16(:,:,35), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,29), A(:,36), n3(:,81), t3x16(:,:,36), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,2), wf4(:,31), A(:,37), n3(:,82), t3x16(:,:,37), nhel, den(3))
    call Hcont_QA(nsync, wf2(:,13), wf8(:,2), A(:,38), n3(:,83), t3x16(:,:,38), nhel, den(15))
    call Hcont_QA(nsync, wf2(:,13), wf8(:,4), A(:,39), n3(:,84), t3x16(:,:,39), nhel, den(17))
    call Hcont_QA(nsync, wf2(:,13), wf8(:,2), A(:,40), n3(:,85), t3x16(:,:,40), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,2), wf2(:,14), A(:,41), n3(:,86), t3x16(:,:,41), nhel, den(15))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,32), A(:,42), n3(:,87), t3x16(:,:,42), nhel, den(20))
    call Hcont_QA(nsync, wf2(:,15), wf8(:,6), A(:,43), n3(:,88), t3x16(:,:,43), nhel, den(23))
    call Hcont_QA(nsync, wf2(:,15), wf8(:,8), A(:,44), n3(:,89), t3x16(:,:,44), nhel, den(25))
    call Hcont_QA(nsync, wf2(:,15), wf8(:,6), A(:,45), n3(:,90), t3x16(:,:,45), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,6), wf2(:,16), A(:,46), n3(:,91), t3x16(:,:,46), nhel, den(23))
    call Hcont_VV(nsync, wf4(:,9), wf4(:,32), A(:,47), n3(:,92), t3x16(:,:,47), nhel, den(27))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(3), M2(4) ! M1helarray(4,nhel)
  integer :: empty(0), i

  M1(1)%j = ((A(j,5)%j+A(j,8)%j)*f(8))/2._/**/REALKIND
  M1(2)%j = A(j,1)%j*f(3)+(-A(j,3)%j-A(j,6)%j)*f(6)+(A(j,4)%j+A(j,7)%j)*f(7)+A(j,2)%j*f(21)
  M1(3)%j = ((-A(j,5)%j-A(j,8)%j)*f(8))/6._/**/REALKIND

  M2(1)%j = ((-A(j,27)%j-A(j,35)%j)*f(2))/2._/**/REALKIND+((A(j,15)%j+A(j,19)%j+A(j,23)%j+A(j,31)%j-A(j,41)%j &
       -A(j,46)%j)*f(10))/2._/**/REALKIND
  M2(2)%j = (A(j,9)%j*f(1))/2._/**/REALKIND+((-A(j,40)%j-A(j,42)%j-A(j,45)%j-A(j,47)%j)*f(17))/2._/**/REALKIND+((A(j,14)%j &
       +A(j,18)%j)*f(18))/2._/**/REALKIND+((A(j,22)%j+A(j,30)%j)*f(19))/2._/**/REALKIND+((A(j,26)%j &
       +A(j,34)%j)*f(20))/2._/**/REALKIND
  M2(3)%j = ((A(j,27)%j+A(j,35)%j)*f(2))/6._/**/REALKIND+A(j,36)%j*f(4)+A(j,10)%j*f(5)+(A(j,38)%j+A(j,43)%j)*f(9)+(-A(j,39)%j &
       -A(j,44)%j)*f(10)+((-A(j,15)%j-A(j,19)%j-A(j,23)%j-A(j,31)%j+A(j,41)%j+A(j,46)%j)*f(10))/6._/**/REALKIND+(-A(j,24)%j &
       -A(j,32)%j)*f(11)+(A(j,25)%j+A(j,33)%j)*f(12)+(-A(j,12)%j-A(j,16)%j)*f(13)+(A(j,13)%j+A(j,17)%j)*f(14)+(-A(j,20)%j &
       -A(j,28)%j)*f(15)+(A(j,21)%j+A(j,29)%j)*f(16)+A(j,11)%j*f(22)+A(j,37)%j*f(23)
  M2(4)%j = -(A(j,9)%j*f(1))/6._/**/REALKIND+((A(j,40)%j+A(j,42)%j+A(j,45)%j+A(j,47)%j)*f(17))/6._/**/REALKIND+((-A(j,14)%j &
       -A(j,18)%j)*f(18))/6._/**/REALKIND+((-A(j,22)%j-A(j,30)%j)*f(19))/6._/**/REALKIND+((-A(j,26)%j &
       -A(j,34)%j)*f(20))/6._/**/REALKIND


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphtt_ew_ttxddxh_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(3)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 3
      do j = 1, 3
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphtt_ew_ttxddxh_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(3), Mct(4)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 3
    do j = 1, 4
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+3*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_pphtt_ew_ttxddxh_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(3)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 3*k
    do i = 1, 3
      do j = 1, 3
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphtt_ew_ttxddxh_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(3)
  complex(REALKIND), intent(in)  :: M2(3)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 3
    do j = 1, 3
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_pphtt_ew_ttxddxh_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(3)
  type(Hpolcont), intent(out)  :: M0_col(4)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 4 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 3 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+3*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_pphtt_ew_ttxddxh_1_/**/REALKIND
