
module ol_colourmatrix_pphtt_ew_ttxbbxh_3_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(68,4), K2(68,4), KL(68,4), Cas(5) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [   9,   0,   3,   0]
  K1( 2,:) = [   0,   0,   0,   0]
  K1( 3,:) = [   3,   0,   9,   0]
  K1( 4,:) = [   0,   0,   0,   0]
  K1( 5,:) = [  12,   0,   4,   0]
  K1( 6,:) = [   0,   0,   0,   0]
  K1( 7,:) = [   4,   0,  12,   0]
  K1( 8,:) = [   0,   0,   0,   0]
  K1( 9,:) = [   0,   0,  -4,   0]
  K1(10,:) = [   0,   0,   0,   0]
  K1(11,:) = [  -4,   0, -12,   0]
  K1(12,:) = [   0,   0,   0,   0]
  K1(13,:) = [  12,   0,   4,   0]
  K1(14,:) = [   0,   0,   0,   0]
  K1(15,:) = [   4,   0,  12,   0]
  K1(16,:) = [   0,   0,   0,   0]
  K1(17,:) = [   0,   0,   4,   0]
  K1(18,:) = [   0,   0,   0,   0]
  K1(19,:) = [   4,   0,   0,   0]
  K1(20,:) = [   0,   0,   0,   0]
  K1(21,:) = [ -12,   0,  -4,   0]
  K1(22,:) = [   0,   0,   0,   0]
  K1(23,:) = [  -4,   0,   0,   0]
  K1(24,:) = [   0,   0,   0,   0]
  K1(25,:) = [  12,   0,   4,   0]
  K1(26,:) = [   0,   0,   0,   0]
  K1(27,:) = [   4,   0,  12,   0]
  K1(28,:) = [   0,   0,   0,   0]
  K1(29,:) = [ -12,   0,  -4,   0]
  K1(30,:) = [   0,   0,   0,   0]
  K1(31,:) = [  -4,   0,   0,   0]
  K1(32,:) = [   0,   0,   0,   0]
  K1(33,:) = [   0,   0,   4,   0]
  K1(34,:) = [   0,   0,   0,   0]
  K1(35,:) = [   4,   0,   0,   0]
  K1(36,:) = [   0,   0,   0,   0]
  K1(37,:) = [   0,   0,  -4,   0]
  K1(38,:) = [   0,   0,   0,   0]
  K1(39,:) = [  -4,   0, -12,   0]
  K1(40,:) = [   0,   0,   0,   0]
  K1(41,:) = [  12,   0,   4,   0]
  K1(42,:) = [   0,   0,   0,   0]
  K1(43,:) = [   4,   0,  12,   0]
  K1(44,:) = [   0,   0,   0,   0]
  K1(45,:) = [   0,   0,   0,   0]
  K1(46,:) = [   0,   0,   0,   0]
  K1(47,:) = [   0,   0,   0,   0]
  K1(48,:) = [   0,   0,   0,   0]
  K1(49,:) = [   0,   0,   0,   0]
  K1(50,:) = [   0,   0,   0,   0]
  K1(51,:) = [   0,   0,   0,   0]
  K1(52,:) = [   0,   0,   0,   0]
  K1(53,:) = [   0,   0,   0,   0]
  K1(54,:) = [   0,   0,   0,   0]
  K1(55,:) = [   0,   0,   0,   0]
  K1(56,:) = [   0,   0,   0,   0]
  K1(57,:) = [   0,   0,   0,   0]
  K1(58,:) = [   0,   0,   0,   0]
  K1(59,:) = [   0,   0,   0,   0]
  K1(60,:) = [   0,   0,   0,   0]
  K1(61,:) = [   0,   0,   0,   0]
  K1(62,:) = [   0,   0,   0,   0]
  K1(63,:) = [   0,   0,   0,   0]
  K1(64,:) = [   0,   0,   0,   0]
  K1(65,:) = [   0,   9,   0,   3]
  K1(66,:) = [   9,   0,   3,   0]
  K1(67,:) = [   0,   3,   0,   9]
  K1(68,:) = [   3,   0,   9,   0]

  K2( 1,:) = [   0,   9,   3,   0]
  K2( 2,:) = [   9,   0,   0,   3]
  K2( 3,:) = [   0,   3,   9,   0]
  K2( 4,:) = [   3,   0,   0,   9]
  K2( 5,:) = [   0,  12,   4,   0]
  K2( 6,:) = [  12,   0,   0,   4]
  K2( 7,:) = [   0,   4,  12,   0]
  K2( 8,:) = [   4,   0,   0,  12]
  K2( 9,:) = [   0,   0,  -4,   0]
  K2(10,:) = [   0,   0,   0,  -4]
  K2(11,:) = [   0,  -4, -12,   0]
  K2(12,:) = [  -4,   0,   0, -12]
  K2(13,:) = [   0,  12,   4,   0]
  K2(14,:) = [  12,   0,   0,   4]
  K2(15,:) = [   0,   4,  12,   0]
  K2(16,:) = [   4,   0,   0,  12]
  K2(17,:) = [   0,   0,   4,   0]
  K2(18,:) = [   0,   0,   0,   4]
  K2(19,:) = [   0,   4,   0,   0]
  K2(20,:) = [   4,   0,   0,   0]
  K2(21,:) = [   0, -12,  -4,   0]
  K2(22,:) = [ -12,   0,   0,  -4]
  K2(23,:) = [   0,  -4,   0,   0]
  K2(24,:) = [  -4,   0,   0,   0]
  K2(25,:) = [   0,  12,   4,   0]
  K2(26,:) = [  12,   0,   0,   4]
  K2(27,:) = [   0,   4,  12,   0]
  K2(28,:) = [   4,   0,   0,  12]
  K2(29,:) = [   0, -12,  -4,   0]
  K2(30,:) = [ -12,   0,   0,  -4]
  K2(31,:) = [   0,  -4,   0,   0]
  K2(32,:) = [  -4,   0,   0,   0]
  K2(33,:) = [   0,   0,   4,   0]
  K2(34,:) = [   0,   0,   0,   4]
  K2(35,:) = [   0,   4,   0,   0]
  K2(36,:) = [   4,   0,   0,   0]
  K2(37,:) = [   0,   0,  -4,   0]
  K2(38,:) = [   0,   0,   0,  -4]
  K2(39,:) = [   0,  -4, -12,   0]
  K2(40,:) = [  -4,   0,   0, -12]
  K2(41,:) = [   0,  12,   4,   0]
  K2(42,:) = [  12,   0,   0,   4]
  K2(43,:) = [   0,   4,  12,   0]
  K2(44,:) = [   4,   0,   0,  12]
  K2(45,:) = [   0,   0,   0,   0]
  K2(46,:) = [   0,   0,   0,   0]
  K2(47,:) = [   0,   0,   0,   0]
  K2(48,:) = [   0,   0,   0,   0]
  K2(49,:) = [   0,   0,   0,   0]
  K2(50,:) = [   0,   0,   0,   0]
  K2(51,:) = [   0,   0,   0,   0]
  K2(52,:) = [   0,   0,   0,   0]
  K2(53,:) = [   0,   0,   0,   0]
  K2(54,:) = [   0,   0,   0,   0]
  K2(55,:) = [   0,   0,   0,   0]
  K2(56,:) = [   0,   0,   0,   0]
  K2(57,:) = [   0,   0,   0,   0]
  K2(58,:) = [   0,   0,   0,   0]
  K2(59,:) = [   0,   0,   0,   0]
  K2(60,:) = [   0,   0,   0,   0]
  K2(61,:) = [   0,   0,   0,   0]
  K2(62,:) = [   0,   0,   0,   0]
  K2(63,:) = [   0,   0,   0,   0]
  K2(64,:) = [   0,   0,   0,   0]
  K2(65,:) = [   0,   0,   0,   0]
  K2(66,:) = [   0,   9,   3,   0]
  K2(67,:) = [   0,   0,   0,   0]
  K2(68,:) = [   0,   3,   9,   0]

  KL( 1,:) = [   0,   9,   0,   3]
  KL( 2,:) = [   9,   0,   3,   0]
  KL( 3,:) = [   0,   3,   0,   9]
  KL( 4,:) = [   3,   0,   9,   0]
  KL( 5,:) = [   0,  12,   0,   4]
  KL( 6,:) = [  12,   0,   4,   0]
  KL( 7,:) = [   0,   4,   0,  12]
  KL( 8,:) = [   4,   0,  12,   0]
  KL( 9,:) = [   0,   0,   0,  -4]
  KL(10,:) = [   0,   0,  -4,   0]
  KL(11,:) = [   0,  -4,   0, -12]
  KL(12,:) = [  -4,   0, -12,   0]
  KL(13,:) = [   0,  12,   0,   4]
  KL(14,:) = [  12,   0,   4,   0]
  KL(15,:) = [   0,   4,   0,  12]
  KL(16,:) = [   4,   0,  12,   0]
  KL(17,:) = [   0,   0,   0,   4]
  KL(18,:) = [   0,   0,   4,   0]
  KL(19,:) = [   0,   4,   0,   0]
  KL(20,:) = [   4,   0,   0,   0]
  KL(21,:) = [   0, -12,   0,  -4]
  KL(22,:) = [ -12,   0,  -4,   0]
  KL(23,:) = [   0,  -4,   0,   0]
  KL(24,:) = [  -4,   0,   0,   0]
  KL(25,:) = [   0,  12,   0,   4]
  KL(26,:) = [  12,   0,   4,   0]
  KL(27,:) = [   0,   4,   0,  12]
  KL(28,:) = [   4,   0,  12,   0]
  KL(29,:) = [   0, -12,   0,  -4]
  KL(30,:) = [ -12,   0,  -4,   0]
  KL(31,:) = [   0,  -4,   0,   0]
  KL(32,:) = [  -4,   0,   0,   0]
  KL(33,:) = [   0,   0,   0,   4]
  KL(34,:) = [   0,   0,   4,   0]
  KL(35,:) = [   0,   4,   0,   0]
  KL(36,:) = [   4,   0,   0,   0]
  KL(37,:) = [   0,   0,   0,  -4]
  KL(38,:) = [   0,   0,  -4,   0]
  KL(39,:) = [   0,  -4,   0, -12]
  KL(40,:) = [  -4,   0, -12,   0]
  KL(41,:) = [   0,  12,   0,   4]
  KL(42,:) = [  12,   0,   4,   0]
  KL(43,:) = [   0,   4,   0,  12]
  KL(44,:) = [   4,   0,  12,   0]
  KL(45,:) = [   0,   0,   0,   0]
  KL(46,:) = [   0,   0,   0,   0]
  KL(47,:) = [   0,   0,   0,   0]
  KL(48,:) = [   0,   0,   0,   0]
  KL(49,:) = [   0,   0,   0,   0]
  KL(50,:) = [   0,   0,   0,   0]
  KL(51,:) = [   0,   0,   0,   0]
  KL(52,:) = [   0,   0,   0,   0]
  KL(53,:) = [   0,   0,   0,   0]
  KL(54,:) = [   0,   0,   0,   0]
  KL(55,:) = [   0,   0,   0,   0]
  KL(56,:) = [   0,   0,   0,   0]
  KL(57,:) = [   0,   0,   0,   0]
  KL(58,:) = [   0,   0,   0,   0]
  KL(59,:) = [   0,   0,   0,   0]
  KL(60,:) = [   0,   0,   0,   0]
  KL(61,:) = [   0,   0,   0,   0]
  KL(62,:) = [   0,   0,   0,   0]
  KL(63,:) = [   0,   0,   0,   0]
  KL(64,:) = [   0,   0,   0,   0]
  KL(65,:) = [   0,   0,   0,   0]
  KL(66,:) = [   0,   9,   0,   3]
  KL(67,:) = [   0,   0,   0,   0]
  KL(68,:) = [   0,   3,   0,   9]

#if 1 > 0
    co = 0
    do k = 1, 5
      co = co + k
      Cas(k) = K1(1+4*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_pphtt_ew_ttxbbxh_3_/**/REALKIND



module ol_forced_parameters_pphtt_ew_ttxbbxh_3_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pphtt_ew_ttxbbxh_3_/**/REALKIND


! **********************************************************************
module ol_loop_storage_pphtt_ew_ttxbbxh_3_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 16 ! number of helicity configurations
  integer(intkind2), save :: nhel = 16 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 16 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(16) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(158)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(1)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf2(2,32), wf4(4,174), wf8(8,102), wf16(16,393)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(941), c(840)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_pphtt_ew_ttxbbxh_3_/**/REALKIND






! **********************************************************************
module ol_loop_pphtt_ew_ttxbbxh_3_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_pphtt_ew_ttxbbxh_3_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = (2*CI*countertermnorm*eQED**5*EWctHAA)/9._/**/REALKIND
    f(  2) = (CI*countertermnorm*eQED**5*EWctHZA)/3._/**/REALKIND
    f(  3) = (2*CI*countertermnorm*eQED**5*EWctHZA)/3._/**/REALKIND
    f(  4) = CI*countertermnorm*eQED**5*EWctHZZ
    f(  5) = (2*CI*countertermnorm*eQED**5*MB)/(9._/**/REALKIND*MW)
    f(  6) = (CI*countertermnorm*eQED**5*MB)/MW
    f(  7) = (CI*countertermnorm*eQED**3*gQCD**2*MB)/MW
    f(  8) = (2*CI*countertermnorm*eQED**5*MT)/(9._/**/REALKIND*MW)
    f(  9) = (CI*countertermnorm*eQED**5*MT)/MW
    f( 10) = (CI*countertermnorm*eQED**3*gQCD**2*MT)/MW
    f( 11) = (CI*countertermnorm*eQED**5)/(4._/**/REALKIND*sw**3)
    f( 12) = (CI*countertermnorm*eQED**5)/(2._/**/REALKIND*sw**3)
    f( 13) = (CI*eQED**3*MB)/(4._/**/REALKIND*MW**3*sw**3)
    f( 14) = (CI*countertermnorm*eQED**5*MB)/(4._/**/REALKIND*MW**3*sw**3)
    f( 15) = (CI*countertermnorm*eQED**3*gQCD**2*MB)/(4._/**/REALKIND*MW**3*sw**3)
    f( 16) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(4._/**/REALKIND*MW**3*sw**3)
    f( 17) = (CI*eQED**3*MH**2)/(4._/**/REALKIND*MW**3*sw**3)
    f( 18) = (CI*countertermnorm*eQED**5*MH**2)/(4._/**/REALKIND*MW**3*sw**3)
    f( 19) = (CI*countertermnorm*eQED**5*EWctHPP*MH**2)/(4._/**/REALKIND*MW**3*sw**3)
    f( 20) = (CI*countertermnorm*eQED**3*gQCD**2*MH**2)/(4._/**/REALKIND*MW**3*sw**3)
    f( 21) = (CI*eQED**3*MT)/(4._/**/REALKIND*MW**3*sw**3)
    f( 22) = (CI*countertermnorm*eQED**5*MT)/(4._/**/REALKIND*MW**3*sw**3)
    f( 23) = (CI*countertermnorm*eQED**3*gQCD**2*MT)/(4._/**/REALKIND*MW**3*sw**3)
    f( 24) = (CI*countertermnorm*ctStt*eQED**3*gQCD**2*MT)/(4._/**/REALKIND*MW**3*sw**3)
    f( 25) = (CI*eQED**3*MB**2*MT)/(8._/**/REALKIND*MW**3*sw**3)
    f( 26) = (CI*countertermnorm*eQED**5*MB**2*MT)/(8._/**/REALKIND*MW**3*sw**3)
    f( 27) = (CI*countertermnorm*eQED**3*gQCD**2*MB**2*MT)/(8._/**/REALKIND*MW**3*sw**3)
    f( 28) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB**2*MT)/(8._/**/REALKIND*MW**3*sw**3)
    f( 29) = (CI*countertermnorm*ctStt*eQED**3*gQCD**2*MB**2*MT)/(8._/**/REALKIND*MW**3*sw**3)
    f( 30) = (CI*eQED**3*MB*MH**2*MT)/(8._/**/REALKIND*MW**3*sw**3)
    f( 31) = (CI*countertermnorm*eQED**5*MB*MH**2*MT)/(8._/**/REALKIND*MW**3*sw**3)
    f( 32) = (3*CI*countertermnorm*eQED**5*EWctHHH*MB*MH**2*MT)/(8._/**/REALKIND*MW**3*sw**3)
    f( 33) = (CI*countertermnorm*eQED**5*EWctHXX*MB*MH**2*MT)/(8._/**/REALKIND*MW**3*sw**3)
    f( 34) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB*MH**2*MT)/(8._/**/REALKIND*MW**3*sw**3)
    f( 35) = (CI*countertermnorm*ctStt*eQED**3*gQCD**2*MB*MH**2*MT)/(8._/**/REALKIND*MW**3*sw**3)
    f( 36) = (3*CI*eQED**3*lambdaHHH*MB*MH**2*MT)/(8._/**/REALKIND*MW**3*sw**3)
    f( 37) = (3*CI*countertermnorm*eQED**5*lambdaHHH*MB*MH**2*MT)/(8._/**/REALKIND*MW**3*sw**3)
    f( 38) = (3*CI*countertermnorm*ctSbb*eQED**3*gQCD**2*lambdaHHH*MB*MH**2*MT)/(8._/**/REALKIND*MW**3*sw**3)
    f( 39) = (3*CI*countertermnorm*ctStt*eQED**3*gQCD**2*lambdaHHH*MB*MH**2*MT)/(8._/**/REALKIND*MW**3*sw**3)
    f( 40) = (CI*eQED**3*MB*MT**2)/(8._/**/REALKIND*MW**3*sw**3)
    f( 41) = (CI*countertermnorm*eQED**5*MB*MT**2)/(8._/**/REALKIND*MW**3*sw**3)
    f( 42) = (CI*countertermnorm*eQED**3*gQCD**2*MB*MT**2)/(8._/**/REALKIND*MW**3*sw**3)
    f( 43) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB*MT**2)/(8._/**/REALKIND*MW**3*sw**3)
    f( 44) = (CI*countertermnorm*ctStt*eQED**3*gQCD**2*MB*MT**2)/(8._/**/REALKIND*MW**3*sw**3)
    f( 45) = (CI*countertermnorm*eQED**5)/(4._/**/REALKIND*MW**2*sw**3)
    f( 46) = (CI*countertermnorm*eQED**5*MB)/(4._/**/REALKIND*MW**2*sw**3)
    f( 47) = (CI*countertermnorm*eQED**5*MH**2)/(4._/**/REALKIND*MW**2*sw**3)
    f( 48) = (CI*countertermnorm*eQED**5*MT)/(4._/**/REALKIND*MW**2*sw**3)
    f( 49) = (countertermnorm*eQED**5*MB*MT)/(cw*MW**2*sw**3*8._/**/REALKIND)
    f( 50) = (CI*eQED**3)/(4._/**/REALKIND*MW*sw**3)
    f( 51) = (CI*countertermnorm*eQED**5)/(4._/**/REALKIND*MW*sw**3)
    f( 52) = (CI*countertermnorm*eQED**5*EWctVbt)/(4._/**/REALKIND*MW*sw**3)
    f( 53) = (CI*countertermnorm*eQED**5*EWctVtb)/(4._/**/REALKIND*MW*sw**3)
    f( 54) = (CI*countertermnorm*eQED**3*gQCD**2)/(4._/**/REALKIND*MW*sw**3)
    f( 55) = (CI*countertermnorm*ctVbt*eQED**3*gQCD**2)/(4._/**/REALKIND*MW*sw**3)
    f( 56) = (CI*eQED**3*MB)/(4._/**/REALKIND*MW*sw**3)
    f( 57) = (CI*countertermnorm*eQED**5*MB)/(4._/**/REALKIND*MW*sw**3)
    f( 58) = (CI*countertermnorm*eQED**5*EWctVbt*MB)/(4._/**/REALKIND*MW*sw**3)
    f( 59) = (CI*countertermnorm*eQED**5*EWctVtb*MB)/(4._/**/REALKIND*MW*sw**3)
    f( 60) = (CI*countertermnorm*eQED**3*gQCD**2*MB)/(4._/**/REALKIND*MW*sw**3)
    f( 61) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(4._/**/REALKIND*MW*sw**3)
    f( 62) = (CI*countertermnorm*ctVbt*eQED**3*gQCD**2*MB)/(4._/**/REALKIND*MW*sw**3)
    f( 63) = (CI*eQED**3*MT)/(4._/**/REALKIND*MW*sw**3)
    f( 64) = (CI*countertermnorm*eQED**5*MT)/(4._/**/REALKIND*MW*sw**3)
    f( 65) = (CI*countertermnorm*eQED**5*EWctVbt*MT)/(4._/**/REALKIND*MW*sw**3)
    f( 66) = (CI*countertermnorm*eQED**5*EWctVtb*MT)/(4._/**/REALKIND*MW*sw**3)
    f( 67) = (CI*countertermnorm*eQED**3*gQCD**2*MT)/(4._/**/REALKIND*MW*sw**3)
    f( 68) = (CI*countertermnorm*ctStt*eQED**3*gQCD**2*MT)/(4._/**/REALKIND*MW*sw**3)
    f( 69) = (CI*countertermnorm*ctVbt*eQED**3*gQCD**2*MT)/(4._/**/REALKIND*MW*sw**3)
    f( 70) = (CI*eQED**3*MW)/(2._/**/REALKIND*sw**3)
    f( 71) = (CI*countertermnorm*eQED**5*MW)/(2._/**/REALKIND*sw**3)
    f( 72) = (CI*countertermnorm*eQED**5*EWctVbt*MW)/(2._/**/REALKIND*sw**3)
    f( 73) = (CI*countertermnorm*eQED**5*EWctVtb*MW)/(2._/**/REALKIND*sw**3)
    f( 74) = (CI*countertermnorm*ctVbt*eQED**3*gQCD**2*MW)/(2._/**/REALKIND*sw**3)
    f( 75) = (CI*countertermnorm*eQED**5*EWctHWW)/(2._/**/REALKIND*sw**2)
    f( 76) = (countertermnorm*eQED**5*MB)/(cw**2*sw**2*2._/**/REALKIND)
    f( 77) = (countertermnorm*eQED**5*MT)/(cw**2*sw**2*2._/**/REALKIND)
    f( 78) = (CI*countertermnorm*eQED**5*MB)/(2._/**/REALKIND*MW**3*sw**2)
    f( 79) = (CI*countertermnorm*eQED**5*MT)/(2._/**/REALKIND*MW**3*sw**2)
    f( 80) = (CI*countertermnorm*eQED**5*MB**2*MT)/(4._/**/REALKIND*MW**3*sw**2)
    f( 81) = (countertermnorm*eQED**5*MB**2*MT)/(MW**3*sw**2*4._/**/REALKIND)
    f( 82) = (countertermnorm*eQED**5*MB*MH**2*MT)/(MW**3*sw**2*4._/**/REALKIND)
    f( 83) = (3*CI*countertermnorm*eQED**5*lambdaHHH*MB*MH**2*MT)/(4._/**/REALKIND*MW**3*sw**2)
    f( 84) = (CI*countertermnorm*eQED**5*MB*MT**2)/(4._/**/REALKIND*MW**3*sw**2)
    f( 85) = (countertermnorm*eQED**5*MB*MT**2)/(MW**3*sw**2*4._/**/REALKIND)
    f( 86) = (countertermnorm*eQED**5*MB**2)/(MW**2*sw**2*6._/**/REALKIND)
    f( 87) = (countertermnorm*eQED**5*MB**2)/(MW**2*sw**2*4._/**/REALKIND)
    f( 88) = (countertermnorm*eQED**5*MB*MH**2)/(MW**2*sw**2*6._/**/REALKIND)
    f( 89) = (countertermnorm*eQED**5*MB*MH**2)/(MW**2*sw**2*4._/**/REALKIND)
    f( 90) = (countertermnorm*eQED**5*MB*MT)/(MW**2*sw**2*12._/**/REALKIND)
    f( 91) = (countertermnorm*eQED**5*MB*MT)/(MW**2*sw**2*6._/**/REALKIND)
    f( 92) = (countertermnorm*eQED**5*MB*MT)/(MW**2*sw**2*4._/**/REALKIND)
    f( 93) = (countertermnorm*eQED**5*MH**2*MT)/(MW**2*sw**2*12._/**/REALKIND)
    f( 94) = (countertermnorm*eQED**5*MH**2*MT)/(MW**2*sw**2*4._/**/REALKIND)
    f( 95) = (countertermnorm*eQED**5*MT**2)/(MW**2*sw**2*12._/**/REALKIND)
    f( 96) = (countertermnorm*eQED**5*MT**2)/(MW**2*sw**2*4._/**/REALKIND)
    f( 97) = (CI*countertermnorm*eQED**5*EWctWPH)/(2._/**/REALKIND*MW*sw**2)
    f( 98) = (CI*eQED**3*MB)/(4._/**/REALKIND*cw*MW*sw**2)
    f( 99) = (CI*countertermnorm*eQED**5*MB)/(2._/**/REALKIND*MW*sw**2)
    f(100) = (CI*countertermnorm*eQED**5*MB)/(6._/**/REALKIND*cw*MW*sw**2)
    f(101) = (CI*countertermnorm*eQED**5*MB)/(4._/**/REALKIND*cw*MW*sw**2)
    f(102) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(4._/**/REALKIND*cw*MW*sw**2)
    f(103) = (CI*countertermnorm*ctVtt*eQED**3*gQCD**2*MB)/(4._/**/REALKIND*cw*MW*sw**2)
    f(104) = (CI*eQED**3*MT)/(4._/**/REALKIND*cw*MW*sw**2)
    f(105) = (CI*countertermnorm*eQED**5*MT)/(2._/**/REALKIND*MW*sw**2)
    f(106) = (CI*countertermnorm*eQED**5*MT)/(12._/**/REALKIND*cw*MW*sw**2)
    f(107) = (CI*countertermnorm*eQED**5*MT)/(4._/**/REALKIND*cw*MW*sw**2)
    f(108) = (CI*countertermnorm*ctStt*eQED**3*gQCD**2*MT)/(4._/**/REALKIND*cw*MW*sw**2)
    f(109) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MT)/(4._/**/REALKIND*cw*MW*sw**2)
    f(110) = (CI*countertermnorm*eQED**5*MB)/(2._/**/REALKIND*MW**3*sqrt2*sw**2)
    f(111) = (CI*countertermnorm*eQED**5*MH**2)/(2._/**/REALKIND*MW**3*sqrt2*sw**2)
    f(112) = (CI*countertermnorm*eQED**5*MT)/(2._/**/REALKIND*MW**3*sqrt2*sw**2)
    f(113) = (CI*countertermnorm*eQED**5)/(2._/**/REALKIND*MW*sqrt2*sw**2)
    f(114) = (countertermnorm*eQED**5)/(cw*sw*6._/**/REALKIND)
    f(115) = (countertermnorm*eQED**5)/(cw*sw*3._/**/REALKIND)
    f(116) = (countertermnorm*eQED**5)/(cw*sw*2._/**/REALKIND)
    f(117) = (CI*eQED**3*MB)/(9._/**/REALKIND*MW*sw)
    f(118) = (CI*eQED**3*MB)/(2._/**/REALKIND*MW*sw)
    f(119) = (CI*countertermnorm*eQED**5*MB)/(9._/**/REALKIND*MW*sw)
    f(120) = (CI*countertermnorm*eQED**5*MB)/(6._/**/REALKIND*MW*sw)
    f(121) = (CI*countertermnorm*eQED**5*MB)/(3._/**/REALKIND*MW*sw)
    f(122) = (CI*countertermnorm*eQED**5*MB)/(2._/**/REALKIND*MW*sw)
    f(123) = (countertermnorm*eQED**5*MB)/(cw*MW*sw*2._/**/REALKIND)
    f(124) = (countertermnorm*eQED**5*EWctAXH*MB)/(MW*sw*3._/**/REALKIND)
    f(125) = (countertermnorm*eQED**5*EWctZXH*MB)/(MW*sw*2._/**/REALKIND)
    f(126) = (CI*eQED*gQCD**2*MB)/(2._/**/REALKIND*MW*sw)
    f(127) = (CI*countertermnorm*eQED**3*gQCD**2*MB)/(9._/**/REALKIND*MW*sw)
    f(128) = (CI*countertermnorm*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*MW*sw)
    f(129) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(9._/**/REALKIND*MW*sw)
    f(130) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*MW*sw)
    f(131) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MB)/(9._/**/REALKIND*MW*sw)
    f(132) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*MW*sw)
    f(133) = (CI*countertermnorm*ctVtt*eQED**3*gQCD**2*MB)/(9._/**/REALKIND*MW*sw)
    f(134) = (CI*countertermnorm*ctVtt*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*MW*sw)
    f(135) = (CI*eQED**3*MT)/(9._/**/REALKIND*MW*sw)
    f(136) = (CI*eQED**3*MT)/(2._/**/REALKIND*MW*sw)
    f(137) = (CI*countertermnorm*eQED**5*MT)/(9._/**/REALKIND*MW*sw)
    f(138) = (CI*countertermnorm*eQED**5*MT)/(6._/**/REALKIND*MW*sw)
    f(139) = (CI*countertermnorm*eQED**5*MT)/(3._/**/REALKIND*MW*sw)
    f(140) = (CI*countertermnorm*eQED**5*MT)/(2._/**/REALKIND*MW*sw)
    f(141) = (countertermnorm*eQED**5*MT)/(cw*MW*sw*2._/**/REALKIND)
    f(142) = (countertermnorm*eQED**5*EWctAXH*MT)/(MW*sw*6._/**/REALKIND)
    f(143) = (countertermnorm*eQED**5*EWctZXH*MT)/(MW*sw*2._/**/REALKIND)
    f(144) = (CI*eQED*gQCD**2*MT)/(2._/**/REALKIND*MW*sw)
    f(145) = (CI*countertermnorm*eQED**3*gQCD**2*MT)/(9._/**/REALKIND*MW*sw)
    f(146) = (CI*countertermnorm*eQED**3*gQCD**2*MT)/(2._/**/REALKIND*MW*sw)
    f(147) = (CI*countertermnorm*ctStt*eQED**3*gQCD**2*MT)/(9._/**/REALKIND*MW*sw)
    f(148) = (CI*countertermnorm*ctStt*eQED**3*gQCD**2*MT)/(2._/**/REALKIND*MW*sw)
    f(149) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MT)/(9._/**/REALKIND*MW*sw)
    f(150) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MT)/(2._/**/REALKIND*MW*sw)
    f(151) = (CI*countertermnorm*ctVtt*eQED**3*gQCD**2*MT)/(9._/**/REALKIND*MW*sw)
    f(152) = (CI*countertermnorm*ctVtt*eQED**3*gQCD**2*MT)/(2._/**/REALKIND*MW*sw)
    f(153) = (CI*eQED**3*MW)/(cw**2*sw)
    f(154) = (CI*countertermnorm*eQED**5*MW)/(3._/**/REALKIND*cw**2*sw)
    f(155) = (2*CI*countertermnorm*eQED**5*MW)/(3._/**/REALKIND*cw**2*sw)
    f(156) = (CI*countertermnorm*eQED**5*MW)/(cw**2*sw)
    f(157) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MW)/(cw**2*sw)
    f(158) = (CI*countertermnorm*ctVtt*eQED**3*gQCD**2*MW)/(cw**2*sw)
    f(159) = (eQED**5*integralnorm*MW*SwB)/(cw*6._/**/REALKIND)
    f(160) = (eQED**5*integralnorm*MW*SwB)/(cw*3._/**/REALKIND)
    f(161) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**3*4._/**/REALKIND)
    f(162) = (eQED**5*integralnorm*MB*MW*SwB)/(cw*6._/**/REALKIND)
    f(163) = (eQED**5*integralnorm*MB*MW*SwB)/(cw*3._/**/REALKIND)
    f(164) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw*6._/**/REALKIND)
    f(165) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw*3._/**/REALKIND)
    f(166) = (eQED**5*integralnorm*MT*MW*SwB)/(cw**3*4._/**/REALKIND)
    f(167) = (eQED**5*integralnorm*MT*MW*SwB)/(cw*6._/**/REALKIND)
    f(168) = (eQED**5*integralnorm*MT*MW*SwB)/(cw*3._/**/REALKIND)
    f(169) = (eQED**5*integralnorm*MW**3*SwB)/(cw**3*3._/**/REALKIND)
    f(170) = (2*eQED**5*integralnorm*MW**3*SwB)/(cw**3*3._/**/REALKIND)
    f(171) = (eQED**5*integralnorm*MW**3*SwB)/(cw*3._/**/REALKIND)
    f(172) = (2*eQED**5*integralnorm*MW**3*SwB)/(cw*3._/**/REALKIND)
    f(173) = (eQED**5*integralnorm*MB*SwB)/(MW**5*sw**5*8._/**/REALKIND)
    f(174) = (eQED**5*integralnorm*MB**3*SwB)/(MW**5*sw**5*16._/**/REALKIND)
    f(175) = (eQED**5*integralnorm*MH**2*SwB)/(MW**5*sw**5*8._/**/REALKIND)
    f(176) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW**5*sw**5*16._/**/REALKIND)
    f(177) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(MW**5*sw**5*16._/**/REALKIND)
    f(178) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(MW**5*sw**5*16._/**/REALKIND)
    f(179) = (eQED**5*integralnorm*MH**4*SwB)/(MW**5*sw**5*32._/**/REALKIND)
    f(180) = (eQED**5*integralnorm*MH**4*SwB)/(MW**5*sw**5*16._/**/REALKIND)
    f(181) = (eQED**5*integralnorm*MH**4*SwB)/(MW**5*sw**5*8._/**/REALKIND)
    f(182) = (3*eQED**5*integralnorm*lambdaHHH*MH**4*SwB)/(MW**5*sw**5*32._/**/REALKIND)
    f(183) = (eQED**5*integralnorm*MB*MH**4*SwB)/(MW**5*sw**5*16._/**/REALKIND)
    f(184) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**4*SwB)/(MW**5*sw**5*16._/**/REALKIND)
    f(185) = (eQED**5*integralnorm*MH**6*SwB)/(MW**5*sw**5*16._/**/REALKIND)
    f(186) = (3*eQED**5*integralnorm*lambdaHHH*MH**6*SwB)/(MW**5*sw**5*16._/**/REALKIND)
    f(187) = (eQED**5*integralnorm*MT*SwB)/(MW**5*sw**5*8._/**/REALKIND)
    f(188) = (eQED**5*integralnorm*MB**2*MT*SwB)/(MW**5*sw**5*16._/**/REALKIND)
    f(189) = (eQED**5*integralnorm*MB**4*MT*SwB)/(MW**5*sw**5*32._/**/REALKIND)
    f(190) = (eQED**5*integralnorm*MH**2*MT*SwB)/(MW**5*sw**5*16._/**/REALKIND)
    f(191) = (eQED**5*integralnorm*MB*MH**2*MT*SwB)/(MW**5*sw**5*16._/**/REALKIND)
    f(192) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwB)/(MW**5*sw**5*16._/**/REALKIND)
    f(193) = (eQED**5*integralnorm*MB**2*MH**2*MT*SwB)/(MW**5*sw**5*32._/**/REALKIND)
    f(194) = (3*eQED**5*integralnorm*MB**2*MH**2*MT*SwB)/(MW**5*sw**5*32._/**/REALKIND)
    f(195) = (eQED**5*integralnorm*MB**3*MH**2*MT*SwB)/(MW**5*sw**5*32._/**/REALKIND)
    f(196) = (3*eQED**5*integralnorm*lambdaHHH*MB**3*MH**2*MT*SwB)/(MW**5*sw**5*32._/**/REALKIND)
    f(197) = (eQED**5*integralnorm*MH**4*MT*SwB)/(MW**5*sw**5*16._/**/REALKIND)
    f(198) = (3*eQED**5*integralnorm*lambdaHHH*MH**4*MT*SwB)/(MW**5*sw**5*16._/**/REALKIND)
    f(199) = (eQED**5*integralnorm*MB*MH**4*MT*SwB)/(MW**5*sw**5*64._/**/REALKIND)
    f(200) = (eQED**5*integralnorm*MB*MH**4*MT*SwB)/(MW**5*sw**5*32._/**/REALKIND)
    f(201) = (3*eQED**5*integralnorm*MB*MH**4*MT*SwB)/(MW**5*sw**5*64._/**/REALKIND)
    f(202) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**4*MT*SwB)/(MW**5*sw**5*64._/**/REALKIND)
    f(203) = (9*eQED**5*integralnorm*lambdaHHH*MB*MH**4*MT*SwB)/(MW**5*sw**5*64._/**/REALKIND)
    f(204) = (eQED**5*integralnorm*MB**2*MH**4*MT*SwB)/(MW**5*sw**5*64._/**/REALKIND)
    f(205) = (eQED**5*integralnorm*MB**2*MH**4*MT*SwB)/(MW**5*sw**5*32._/**/REALKIND)
    f(206) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**4*MT*SwB)/(MW**5*sw**5*32._/**/REALKIND)
    f(207) = (9*eQED**5*integralnorm*lambdaHHH**2*MB**2*MH**4*MT*SwB)/(MW**5*sw**5*64._/**/REALKIND)
    f(208) = (9*eQED**5*integralnorm*lambdaHHH**2*MB**2*MH**4*MT*SwB)/(MW**5*sw**5*32._/**/REALKIND)
    f(209) = (eQED**5*integralnorm*MB*MH**6*MT*SwB)/(MW**5*sw**5*32._/**/REALKIND)
    f(210) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**6*MT*SwB)/(MW**5*sw**5*64._/**/REALKIND)
    f(211) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**6*MT*SwB)/(MW**5*sw**5*32._/**/REALKIND)
    f(212) = (27*eQED**5*integralnorm*lambdaHHH**3*MB*MH**6*MT*SwB)/(MW**5*sw**5*64._/**/REALKIND)
    f(213) = (27*eQED**5*integralnorm*lambdaHHH**3*MB*MH**6*MT*SwB)/(MW**5*sw**5*32._/**/REALKIND)
    f(214) = (eQED**5*integralnorm*MB*MT**2*SwB)/(MW**5*sw**5*16._/**/REALKIND)
    f(215) = (eQED**5*integralnorm*MB**3*MT**2*SwB)/(MW**5*sw**5*32._/**/REALKIND)
    f(216) = (eQED**5*integralnorm*MH**2*MT**2*SwB)/(MW**5*sw**5*16._/**/REALKIND)
    f(217) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT**2*SwB)/(MW**5*sw**5*16._/**/REALKIND)
    f(218) = (eQED**5*integralnorm*MB*MH**2*MT**2*SwB)/(MW**5*sw**5*32._/**/REALKIND)
    f(219) = (3*eQED**5*integralnorm*MB*MH**2*MT**2*SwB)/(MW**5*sw**5*32._/**/REALKIND)
    f(220) = (eQED**5*integralnorm*MB**2*MH**2*MT**2*SwB)/(MW**5*sw**5*32._/**/REALKIND)
    f(221) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*MT**2*SwB)/(MW**5*sw**5*32._/**/REALKIND)
    f(222) = (eQED**5*integralnorm*MB*MH**4*MT**2*SwB)/(MW**5*sw**5*64._/**/REALKIND)
    f(223) = (eQED**5*integralnorm*MB*MH**4*MT**2*SwB)/(MW**5*sw**5*32._/**/REALKIND)
    f(224) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**4*MT**2*SwB)/(MW**5*sw**5*32._/**/REALKIND)
    f(225) = (9*eQED**5*integralnorm*lambdaHHH**2*MB*MH**4*MT**2*SwB)/(MW**5*sw**5*64._/**/REALKIND)
    f(226) = (9*eQED**5*integralnorm*lambdaHHH**2*MB*MH**4*MT**2*SwB)/(MW**5*sw**5*32._/**/REALKIND)
    f(227) = (eQED**5*integralnorm*MT**3*SwB)/(MW**5*sw**5*16._/**/REALKIND)
    f(228) = (eQED**5*integralnorm*MB**2*MT**3*SwB)/(MW**5*sw**5*32._/**/REALKIND)
    f(229) = (eQED**5*integralnorm*MB*MH**2*MT**3*SwB)/(MW**5*sw**5*32._/**/REALKIND)
    f(230) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT**3*SwB)/(MW**5*sw**5*32._/**/REALKIND)
    f(231) = (eQED**5*integralnorm*MB*MT**4*SwB)/(MW**5*sw**5*32._/**/REALKIND)
    f(232) = (eQED**5*integralnorm*SwB)/(MW**3*sw**5*8._/**/REALKIND)
    f(233) = (eQED**5*integralnorm*MB*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(234) = (eQED**5*integralnorm*MB*SwB)/(MW**3*sw**5*8._/**/REALKIND)
    f(235) = (eQED**5*integralnorm*MB**2*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(236) = (eQED**5*integralnorm*MB**3*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(237) = (eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(238) = (eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**5*8._/**/REALKIND)
    f(239) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(240) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(241) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(242) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(243) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(244) = (eQED**5*integralnorm*MH**4*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(245) = (3*eQED**5*integralnorm*lambdaHHH*MH**4*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(246) = (eQED**5*integralnorm*MT*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(247) = (eQED**5*integralnorm*MT*SwB)/(MW**3*sw**5*8._/**/REALKIND)
    f(248) = (eQED**5*integralnorm*MB*MT*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(249) = (eQED**5*integralnorm*MB**2*MT*SwB)/(MW**3*sw**5*32._/**/REALKIND)
    f(250) = (eQED**5*integralnorm*MB**2*MT*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(251) = (eQED**5*integralnorm*MB**2*MT*SwB)/(cw**2*MW**3*sw**5*32._/**/REALKIND)
    f(252) = (eQED**5*integralnorm*MH**2*MT*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(253) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(254) = (eQED**5*integralnorm*MB*MH**2*MT*SwB)/(MW**3*sw**5*32._/**/REALKIND)
    f(255) = (eQED**5*integralnorm*MB*MH**2*MT*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(256) = (eQED**5*integralnorm*MB*MH**2*MT*SwB)/(cw**2*MW**3*sw**5*32._/**/REALKIND)
    f(257) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwB)/(MW**3*sw**5*32._/**/REALKIND)
    f(258) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(259) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwB)/(cw**2*MW**3*sw**5*32._/**/REALKIND)
    f(260) = (eQED**5*integralnorm*MT**2*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(261) = (eQED**5*integralnorm*MB*MT**2*SwB)/(MW**3*sw**5*32._/**/REALKIND)
    f(262) = (eQED**5*integralnorm*MB*MT**2*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(263) = (eQED**5*integralnorm*MB*MT**2*SwB)/(cw**2*MW**3*sw**5*32._/**/REALKIND)
    f(264) = (eQED**5*integralnorm*MH**2*MT**2*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(265) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT**2*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(266) = (eQED**5*integralnorm*MT**3*SwB)/(MW**3*sw**5*16._/**/REALKIND)
    f(267) = (eQED**5*integralnorm*SwB)/(MW*sw**5*16._/**/REALKIND)
    f(268) = (eQED**5*integralnorm*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(269) = (eQED**5*integralnorm*SwB)/(MW*sw**5*4._/**/REALKIND)
    f(270) = (cw**2*eQED**5*integralnorm*SwB)/(MW*sw**5*4._/**/REALKIND)
    f(271) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**5*16._/**/REALKIND)
    f(272) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(273) = (cw**2*eQED**5*integralnorm*MB*SwB)/(MW*sw**5*4._/**/REALKIND)
    f(274) = (eQED**5*integralnorm*MB**2*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(275) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw**5*16._/**/REALKIND)
    f(276) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(277) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(MW*sw**5*16._/**/REALKIND)
    f(278) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(279) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(280) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**5*16._/**/REALKIND)
    f(281) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(282) = (cw**2*eQED**5*integralnorm*MT*SwB)/(MW*sw**5*4._/**/REALKIND)
    f(283) = (eQED**5*integralnorm*MB*MT*SwB)/(MW*sw**5*16._/**/REALKIND)
    f(284) = (eQED**5*integralnorm*MB*MT*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(285) = (eQED**5*integralnorm*MB*MT*SwB)/(cw**4*MW*sw**5*16._/**/REALKIND)
    f(286) = (eQED**5*integralnorm*MB**2*MT*SwB)/(MW*sw**5*32._/**/REALKIND)
    f(287) = (eQED**5*integralnorm*MB**2*MT*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(288) = (eQED**5*integralnorm*MB**2*MT*SwB)/(cw**4*MW*sw**5*32._/**/REALKIND)
    f(289) = (eQED**5*integralnorm*MB**2*MT*SwB)/(cw**4*MW*sw**5*16._/**/REALKIND)
    f(290) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(291) = (eQED**5*integralnorm*MB*MH**2*MT*SwB)/(MW*sw**5*32._/**/REALKIND)
    f(292) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwB)/(MW*sw**5*32._/**/REALKIND)
    f(293) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(294) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwB)/(cw**4*MW*sw**5*32._/**/REALKIND)
    f(295) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwB)/(cw**4*MW*sw**5*16._/**/REALKIND)
    f(296) = (eQED**5*integralnorm*MT**2*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(297) = (eQED**5*integralnorm*MB*MT**2*SwB)/(MW*sw**5*32._/**/REALKIND)
    f(298) = (eQED**5*integralnorm*MB*MT**2*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(299) = (eQED**5*integralnorm*MB*MT**2*SwB)/(cw**4*MW*sw**5*32._/**/REALKIND)
    f(300) = (eQED**5*integralnorm*MB*MT**2*SwB)/(cw**4*MW*sw**5*16._/**/REALKIND)
    f(301) = (eQED**5*integralnorm*MW*SwB)/(sw**5*8._/**/REALKIND)
    f(302) = (eQED**5*integralnorm*MW*SwB)/(sw**5*4._/**/REALKIND)
    f(303) = (eQED**5*integralnorm*MW*SwB)/(sw**5*2._/**/REALKIND)
    f(304) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw**5*8._/**/REALKIND)
    f(305) = (cw**2*eQED**5*integralnorm*MW*SwB)/(sw**5*4._/**/REALKIND)
    f(306) = (cw**2*eQED**5*integralnorm*MW*SwB)/(sw**5*2._/**/REALKIND)
    f(307) = (eQED**5*integralnorm*MB*MW*SwB)/(sw**5*4._/**/REALKIND)
    f(308) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(sw**5*4._/**/REALKIND)
    f(309) = (eQED**5*integralnorm*MT*MW*SwB)/(sw**5*4._/**/REALKIND)
    f(310) = (eQED**5*integralnorm*MB*MT*MW*SwB)/(sw**5*32._/**/REALKIND)
    f(311) = (eQED**5*integralnorm*MB*MT*MW*SwB)/(sw**5*4._/**/REALKIND)
    f(312) = (eQED**5*integralnorm*MB*MT*MW*SwB)/(cw**6*sw**5*32._/**/REALKIND)
    f(313) = (eQED**5*integralnorm*MB*MT*MW*SwB)/(cw**6*sw**5*4._/**/REALKIND)
    f(314) = (eQED**5*integralnorm*MW**3*SwB)/(sw**5*2._/**/REALKIND)
    f(315) = (eQED**5*integralnorm*MB*SwB)/(cw*MW**3*sw**4*8._/**/REALKIND)
    f(316) = (eQED**5*integralnorm*MB**3*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(317) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(318) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(319) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(320) = (eQED**5*integralnorm*MB*MH**4*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(321) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**4*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(322) = (eQED**5*integralnorm*MT*SwB)/(cw*MW**3*sw**4*8._/**/REALKIND)
    f(323) = (eQED**5*integralnorm*MB**2*MT*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(324) = (eQED**5*integralnorm*MH**2*MT*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(325) = (eQED**5*integralnorm*MB*MH**2*MT*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(326) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(327) = (eQED**5*integralnorm*MH**4*MT*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(328) = (3*eQED**5*integralnorm*lambdaHHH*MH**4*MT*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(329) = (eQED**5*integralnorm*MB*MT**2*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(330) = (eQED**5*integralnorm*MH**2*MT**2*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(331) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT**2*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(332) = (eQED**5*integralnorm*MT**3*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(333) = (eQED**5*integralnorm*SwB)/(cw*MW*sw**4*8._/**/REALKIND)
    f(334) = (cw*eQED**5*integralnorm*SwB)/(MW*sw**4*4._/**/REALKIND)
    f(335) = (eQED**5*integralnorm*MB*SwB)/(cw**3*MW*sw**4*16._/**/REALKIND)
    f(336) = (eQED**5*integralnorm*MB*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f(337) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**4*16._/**/REALKIND)
    f(338) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**4*8._/**/REALKIND)
    f(339) = (cw*eQED**5*integralnorm*MB*SwB)/(MW*sw**4*8._/**/REALKIND)
    f(340) = (cw*eQED**5*integralnorm*MB*SwB)/(MW*sw**4*4._/**/REALKIND)
    f(341) = (eQED**5*integralnorm*MB**2*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f(342) = (cw*eQED**5*integralnorm*MB**2*SwB)/(MW*sw**4*8._/**/REALKIND)
    f(343) = (cw*eQED**5*integralnorm*MB**2*SwB)/(MW*sw**4*4._/**/REALKIND)
    f(344) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f(345) = (cw*eQED**5*integralnorm*MB*MH**2*SwB)/(MW*sw**4*8._/**/REALKIND)
    f(346) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f(347) = (3*cw*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW*sw**4*8._/**/REALKIND)
    f(348) = (3*cw*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW*sw**4*4._/**/REALKIND)
    f(349) = (eQED**5*integralnorm*MT*SwB)/(cw**3*MW*sw**4*16._/**/REALKIND)
    f(350) = (eQED**5*integralnorm*MT*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f(351) = (eQED**5*integralnorm*MT*SwB)/(cw*MW*sw**4*16._/**/REALKIND)
    f(352) = (eQED**5*integralnorm*MT*SwB)/(cw*MW*sw**4*8._/**/REALKIND)
    f(353) = (cw*eQED**5*integralnorm*MT*SwB)/(MW*sw**4*8._/**/REALKIND)
    f(354) = (cw*eQED**5*integralnorm*MT*SwB)/(MW*sw**4*4._/**/REALKIND)
    f(355) = (eQED**5*integralnorm*MB*MT*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f(356) = (cw*eQED**5*integralnorm*MB*MT*SwB)/(MW*sw**4*8._/**/REALKIND)
    f(357) = (cw*eQED**5*integralnorm*MB*MT*SwB)/(MW*sw**4*4._/**/REALKIND)
    f(358) = (eQED**5*integralnorm*MH**2*MT*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f(359) = (cw*eQED**5*integralnorm*MH**2*MT*SwB)/(MW*sw**4*8._/**/REALKIND)
    f(360) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f(361) = (3*cw*eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(MW*sw**4*8._/**/REALKIND)
    f(362) = (3*cw*eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(MW*sw**4*4._/**/REALKIND)
    f(363) = (eQED**5*integralnorm*MT**2*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f(364) = (cw*eQED**5*integralnorm*MT**2*SwB)/(MW*sw**4*8._/**/REALKIND)
    f(365) = (cw*eQED**5*integralnorm*MT**2*SwB)/(MW*sw**4*4._/**/REALKIND)
    f(366) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**4*2._/**/REALKIND)
    f(367) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**4*2._/**/REALKIND)
    f(368) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**5*sw**4*4._/**/REALKIND)
    f(369) = (eQED**5*integralnorm*MB*MW*SwB)/(cw*sw**4*16._/**/REALKIND)
    f(370) = (eQED**5*integralnorm*MB*MW*SwB)/(cw*sw**4*4._/**/REALKIND)
    f(371) = (eQED**5*integralnorm*MB*MW*SwB)/(cw*sw**4*2._/**/REALKIND)
    f(372) = (cw*eQED**5*integralnorm*MB*MW*SwB)/(sw**4*8._/**/REALKIND)
    f(373) = (cw*eQED**5*integralnorm*MB*MW*SwB)/(sw**4*2._/**/REALKIND)
    f(374) = (eQED**5*integralnorm*MT*MW*SwB)/(cw**5*sw**4*4._/**/REALKIND)
    f(375) = (eQED**5*integralnorm*MT*MW*SwB)/(cw*sw**4*16._/**/REALKIND)
    f(376) = (eQED**5*integralnorm*MT*MW*SwB)/(cw*sw**4*4._/**/REALKIND)
    f(377) = (eQED**5*integralnorm*MT*MW*SwB)/(cw*sw**4*2._/**/REALKIND)
    f(378) = (cw*eQED**5*integralnorm*MT*MW*SwB)/(sw**4*8._/**/REALKIND)
    f(379) = (cw*eQED**5*integralnorm*MT*MW*SwB)/(sw**4*2._/**/REALKIND)
    f(380) = (eQED**5*integralnorm*MB*SwB)/(MW**3*sw**3*36._/**/REALKIND)
    f(381) = (eQED**5*integralnorm*MB*SwB)/(MW**3*sw**3*18._/**/REALKIND)
    f(382) = (eQED**5*integralnorm*MB*SwB)/(MW**3*sw**3*12._/**/REALKIND)
    f(383) = (eQED**5*integralnorm*MB*SwB)/(MW**3*sw**3*9._/**/REALKIND)
    f(384) = (eQED**5*integralnorm*MB*SwB)/(MW**3*sw**3*6._/**/REALKIND)
    f(385) = (eQED**5*integralnorm*MB*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f(386) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f(387) = (eQED**5*integralnorm*MB**3*SwB)/(MW**3*sw**3*36._/**/REALKIND)
    f(388) = (eQED**5*integralnorm*MB**3*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(389) = (eQED**3*gQCD**2*integralnorm*MB**3*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(390) = (eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**3*36._/**/REALKIND)
    f(391) = (eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**3*18._/**/REALKIND)
    f(392) = (eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**3*12._/**/REALKIND)
    f(393) = (eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**3*9._/**/REALKIND)
    f(394) = (eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**3*6._/**/REALKIND)
    f(395) = (eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f(396) = (eQED**3*gQCD**2*integralnorm*MH**2*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f(397) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW**3*sw**3*12._/**/REALKIND)
    f(398) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(MW**3*sw**3*36._/**/REALKIND)
    f(399) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(MW**3*sw**3*12._/**/REALKIND)
    f(400) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(401) = (eQED**3*gQCD**2*integralnorm*MB**2*MH**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(402) = (eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(MW**3*sw**3*12._/**/REALKIND)
    f(403) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(404) = (3*eQED**3*gQCD**2*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(405) = (eQED**5*integralnorm*MB*MH**4*SwB)/(MW**3*sw**3*12._/**/REALKIND)
    f(406) = (eQED**5*integralnorm*lambdaHHH*MB*MH**4*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f(407) = (eQED**5*integralnorm*MT*SwB)/(MW**3*sw**3*36._/**/REALKIND)
    f(408) = (eQED**5*integralnorm*MT*SwB)/(MW**3*sw**3*18._/**/REALKIND)
    f(409) = (eQED**5*integralnorm*MT*SwB)/(MW**3*sw**3*12._/**/REALKIND)
    f(410) = (eQED**5*integralnorm*MT*SwB)/(MW**3*sw**3*9._/**/REALKIND)
    f(411) = (eQED**5*integralnorm*MT*SwB)/(MW**3*sw**3*6._/**/REALKIND)
    f(412) = (eQED**5*integralnorm*MT*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f(413) = (eQED**3*gQCD**2*integralnorm*MT*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f(414) = (eQED**5*integralnorm*MB**2*MT*SwB)/(MW**3*sw**3*72._/**/REALKIND)
    f(415) = (eQED**5*integralnorm*MB**2*MT*SwB)/(MW**3*sw**3*36._/**/REALKIND)
    f(416) = (eQED**5*integralnorm*MB**2*MT*SwB)/(MW**3*sw**3*18._/**/REALKIND)
    f(417) = (eQED**5*integralnorm*MB**2*MT*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(418) = (eQED**3*gQCD**2*integralnorm*MB**2*MT*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(419) = (eQED**5*integralnorm*MH**2*MT*SwB)/(MW**3*sw**3*24._/**/REALKIND)
    f(420) = (eQED**5*integralnorm*MB*MH**2*MT*SwB)/(MW**3*sw**3*72._/**/REALKIND)
    f(421) = (eQED**5*integralnorm*MB*MH**2*MT*SwB)/(MW**3*sw**3*36._/**/REALKIND)
    f(422) = (eQED**5*integralnorm*MB*MH**2*MT*SwB)/(MW**3*sw**3*24._/**/REALKIND)
    f(423) = (eQED**5*integralnorm*MB*MH**2*MT*SwB)/(MW**3*sw**3*18._/**/REALKIND)
    f(424) = (eQED**5*integralnorm*MB*MH**2*MT*SwB)/(MW**3*sw**3*12._/**/REALKIND)
    f(425) = (eQED**5*integralnorm*MB*MH**2*MT*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(426) = (eQED**3*gQCD**2*integralnorm*MB*MH**2*MT*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(427) = (eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwB)/(MW**3*sw**3*24._/**/REALKIND)
    f(428) = (eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwB)/(MW**3*sw**3*12._/**/REALKIND)
    f(429) = (eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwB)/(MW**3*sw**3*6._/**/REALKIND)
    f(430) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(431) = (3*eQED**3*gQCD**2*integralnorm*lambdaHHH*MB*MH**2*MT*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(432) = (eQED**5*integralnorm*MH**4*MT*SwB)/(MW**3*sw**3*24._/**/REALKIND)
    f(433) = (eQED**5*integralnorm*lambdaHHH*MH**4*MT*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(434) = (eQED**5*integralnorm*MB*MT**2*SwB)/(MW**3*sw**3*72._/**/REALKIND)
    f(435) = (eQED**5*integralnorm*MB*MT**2*SwB)/(MW**3*sw**3*36._/**/REALKIND)
    f(436) = (eQED**5*integralnorm*MB*MT**2*SwB)/(MW**3*sw**3*18._/**/REALKIND)
    f(437) = (eQED**5*integralnorm*MB*MT**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(438) = (eQED**3*gQCD**2*integralnorm*MB*MT**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(439) = (eQED**5*integralnorm*MH**2*MT**2*SwB)/(MW**3*sw**3*36._/**/REALKIND)
    f(440) = (eQED**5*integralnorm*MH**2*MT**2*SwB)/(MW**3*sw**3*24._/**/REALKIND)
    f(441) = (eQED**5*integralnorm*MH**2*MT**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(442) = (eQED**3*gQCD**2*integralnorm*MH**2*MT**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(443) = (eQED**5*integralnorm*lambdaHHH*MH**2*MT**2*SwB)/(MW**3*sw**3*12._/**/REALKIND)
    f(444) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(445) = (3*eQED**3*gQCD**2*integralnorm*lambdaHHH*MH**2*MT**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(446) = (eQED**5*integralnorm*MT**3*SwB)/(MW**3*sw**3*36._/**/REALKIND)
    f(447) = (eQED**5*integralnorm*MT**3*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(448) = (eQED**3*gQCD**2*integralnorm*MT**3*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f(449) = (eQED**5*integralnorm*SwB)/(MW*sw**3*36._/**/REALKIND)
    f(450) = (eQED**5*integralnorm*SwB)/(MW*sw**3*18._/**/REALKIND)
    f(451) = (eQED**5*integralnorm*SwB)/(MW*sw**3*12._/**/REALKIND)
    f(452) = (eQED**5*integralnorm*SwB)/(MW*sw**3*9._/**/REALKIND)
    f(453) = (eQED**5*integralnorm*SwB)/(MW*sw**3*6._/**/REALKIND)
    f(454) = (eQED**5*integralnorm*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(455) = (eQED**5*integralnorm*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(456) = (eQED**5*integralnorm*SwB)/(cw**2*MW*sw**3*2._/**/REALKIND)
    f(457) = (eQED**3*gQCD**2*integralnorm*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(458) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*36._/**/REALKIND)
    f(459) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*18._/**/REALKIND)
    f(460) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*12._/**/REALKIND)
    f(461) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*9._/**/REALKIND)
    f(462) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*6._/**/REALKIND)
    f(463) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(464) = (eQED**5*integralnorm*MB*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(465) = (eQED**5*integralnorm*MB*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(466) = (cw**2*eQED**5*integralnorm*MB*SwB)/(MW*sw**3*2._/**/REALKIND)
    f(467) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(468) = (eQED**5*integralnorm*MB**2*SwB)/(MW*sw**3*12._/**/REALKIND)
    f(469) = (eQED**5*integralnorm*MB**2*SwB)/(MW*sw**3*6._/**/REALKIND)
    f(470) = (eQED**5*integralnorm*MB**2*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(471) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw**3*12._/**/REALKIND)
    f(472) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw**3*6._/**/REALKIND)
    f(473) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(474) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(475) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(476) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW*sw**3*12._/**/REALKIND)
    f(477) = (eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(478) = (eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW*sw**3*2._/**/REALKIND)
    f(479) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(480) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*36._/**/REALKIND)
    f(481) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*24._/**/REALKIND)
    f(482) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*18._/**/REALKIND)
    f(483) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*12._/**/REALKIND)
    f(484) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*9._/**/REALKIND)
    f(485) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*6._/**/REALKIND)
    f(486) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(487) = (eQED**5*integralnorm*MT*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(488) = (eQED**5*integralnorm*MT*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(489) = (cw**2*eQED**5*integralnorm*MT*SwB)/(MW*sw**3*2._/**/REALKIND)
    f(490) = (eQED**3*gQCD**2*integralnorm*MT*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(491) = (eQED**5*integralnorm*MB*MT*SwB)/(MW*sw**3*24._/**/REALKIND)
    f(492) = (eQED**5*integralnorm*MB*MT*SwB)/(MW*sw**3*12._/**/REALKIND)
    f(493) = (eQED**5*integralnorm*MB*MT*SwB)/(MW*sw**3*6._/**/REALKIND)
    f(494) = (eQED**5*integralnorm*MB*MT*SwB)/(cw**2*MW*sw**3*16._/**/REALKIND)
    f(495) = (eQED**5*integralnorm*MB*MT*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(496) = (eQED**5*integralnorm*MH**2*MT*SwB)/(MW*sw**3*24._/**/REALKIND)
    f(497) = (eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(MW*sw**3*8._/**/REALKIND)
    f(498) = (eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(499) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(500) = (eQED**5*integralnorm*MT**2*SwB)/(MW*sw**3*24._/**/REALKIND)
    f(501) = (eQED**5*integralnorm*MT**2*SwB)/(MW*sw**3*12._/**/REALKIND)
    f(502) = (eQED**5*integralnorm*MT**2*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(503) = (eQED**5*integralnorm*MW*SwB)/(sw**3*18._/**/REALKIND)
    f(504) = (eQED**5*integralnorm*MW*SwB)/(sw**3*12._/**/REALKIND)
    f(505) = (eQED**5*integralnorm*MW*SwB)/(sw**3*9._/**/REALKIND)
    f(506) = (eQED**5*integralnorm*MW*SwB)/(sw**3*6._/**/REALKIND)
    f(507) = (2*eQED**5*integralnorm*MW*SwB)/(sw**3*9._/**/REALKIND)
    f(508) = (eQED**5*integralnorm*MW*SwB)/(sw**3*4._/**/REALKIND)
    f(509) = (eQED**5*integralnorm*MW*SwB)/(sw**3*3._/**/REALKIND)
    f(510) = (eQED**5*integralnorm*MW*SwB)/(sw**3*2._/**/REALKIND)
    f(511) = (eQED**5*integralnorm*MW*SwB)/sw**3
    f(512) = (eQED**5*integralnorm*MW*SwB)/(cw**4*sw**3*4._/**/REALKIND)
    f(513) = (eQED**5*integralnorm*MW*SwB)/(cw**4*sw**3*2._/**/REALKIND)
    f(514) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw**3*8._/**/REALKIND)
    f(515) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw**3*2._/**/REALKIND)
    f(516) = (cw**2*eQED**5*integralnorm*MW*SwB)/(sw**3*2._/**/REALKIND)
    f(517) = (cw**2*eQED**5*integralnorm*MW*SwB)/sw**3
    f(518) = (eQED**3*gQCD**2*integralnorm*MW*SwB)/(sw**3*2._/**/REALKIND)
    f(519) = (eQED**5*integralnorm*MB*MW*SwB)/(sw**3*12._/**/REALKIND)
    f(520) = (eQED**5*integralnorm*MB*MW*SwB)/(sw**3*6._/**/REALKIND)
    f(521) = (eQED**5*integralnorm*MB*MW*SwB)/(sw**3*4._/**/REALKIND)
    f(522) = (eQED**5*integralnorm*MB*MW*SwB)/(sw**3*3._/**/REALKIND)
    f(523) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**4*sw**3*2._/**/REALKIND)
    f(524) = (eQED**5*integralnorm*MH**2*MW*SwB)/(sw**3*4._/**/REALKIND)
    f(525) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(cw**4*sw**3*2._/**/REALKIND)
    f(526) = (eQED**5*integralnorm*MT*MW*SwB)/(sw**3*24._/**/REALKIND)
    f(527) = (eQED**5*integralnorm*MT*MW*SwB)/(sw**3*12._/**/REALKIND)
    f(528) = (eQED**5*integralnorm*MT*MW*SwB)/(sw**3*6._/**/REALKIND)
    f(529) = (eQED**5*integralnorm*MT*MW*SwB)/(sw**3*4._/**/REALKIND)
    f(530) = (eQED**5*integralnorm*MT*MW*SwB)/(cw**4*sw**3*2._/**/REALKIND)
    f(531) = (eQED**5*integralnorm*MW**3*SwB)/(sw**3*2._/**/REALKIND)
    f(532) = (eQED**5*integralnorm*MW**3*SwB)/(cw**6*sw**3)
    f(533) = (eQED**5*integralnorm*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(534) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**2*36._/**/REALKIND)
    f(535) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**2*18._/**/REALKIND)
    f(536) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**2*9._/**/REALKIND)
    f(537) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(538) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(539) = (cw*eQED**5*integralnorm*MB*SwB)/(MW*sw**2*6._/**/REALKIND)
    f(540) = (cw*eQED**5*integralnorm*MB*SwB)/(MW*sw**2*3._/**/REALKIND)
    f(541) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(542) = (eQED**5*integralnorm*MB**2*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(543) = (eQED**5*integralnorm*MH**2*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(544) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(545) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(546) = (eQED**5*integralnorm*MT*SwB)/(cw*MW*sw**2*36._/**/REALKIND)
    f(547) = (eQED**5*integralnorm*MT*SwB)/(cw*MW*sw**2*18._/**/REALKIND)
    f(548) = (eQED**5*integralnorm*MT*SwB)/(cw*MW*sw**2*9._/**/REALKIND)
    f(549) = (eQED**5*integralnorm*MT*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(550) = (eQED**5*integralnorm*MT*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(551) = (cw*eQED**5*integralnorm*MT*SwB)/(MW*sw**2*6._/**/REALKIND)
    f(552) = (cw*eQED**5*integralnorm*MT*SwB)/(MW*sw**2*3._/**/REALKIND)
    f(553) = (eQED**3*gQCD**2*integralnorm*MT*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(554) = (eQED**5*integralnorm*MB*MT*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(555) = (eQED**5*integralnorm*MH**2*MT*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(556) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(557) = (eQED**5*integralnorm*MT**2*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(558) = (eQED**5*integralnorm*MW*SwB)/(cw**3*sw**2*2._/**/REALKIND)
    f(559) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*12._/**/REALKIND)
    f(560) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*6._/**/REALKIND)
    f(561) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(562) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*3._/**/REALKIND)
    f(563) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*2._/**/REALKIND)
    f(564) = (2*eQED**5*integralnorm*MW*SwB)/(cw*sw**2*3._/**/REALKIND)
    f(565) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**2*6._/**/REALKIND)
    f(566) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**2*3._/**/REALKIND)
    f(567) = (2*cw*eQED**5*integralnorm*MW*SwB)/(sw**2*3._/**/REALKIND)
    f(568) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**3*sw**2*4._/**/REALKIND)
    f(569) = (eQED**5*integralnorm*MB*MW*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(570) = (eQED**5*integralnorm*MT*MW*SwB)/(cw**3*sw**2*4._/**/REALKIND)
    f(571) = (eQED**5*integralnorm*MT*MW*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(572) = (eQED**5*integralnorm*SwB)/(cw**2*MW*sw*4._/**/REALKIND)
    f(573) = (eQED**5*integralnorm*MB*SwB)/(MW*sw*81._/**/REALKIND)
    f(574) = (2*eQED**5*integralnorm*MB*SwB)/(MW*sw*81._/**/REALKIND)
    f(575) = (4*eQED**5*integralnorm*MB*SwB)/(MW*sw*81._/**/REALKIND)
    f(576) = (eQED**5*integralnorm*MB*SwB)/(MW*sw*18._/**/REALKIND)
    f(577) = (eQED**5*integralnorm*MB*SwB)/(MW*sw*9._/**/REALKIND)
    f(578) = (2*eQED**5*integralnorm*MB*SwB)/(MW*sw*9._/**/REALKIND)
    f(579) = (eQED**5*integralnorm*MB*SwB)/(MW*sw*2._/**/REALKIND)
    f(580) = (eQED**5*integralnorm*MB*SwB)/(cw**2*MW*sw*4._/**/REALKIND)
    f(581) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(MW*sw*18._/**/REALKIND)
    f(582) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(MW*sw*9._/**/REALKIND)
    f(583) = (2*eQED**3*gQCD**2*integralnorm*MB*SwB)/(MW*sw*9._/**/REALKIND)
    f(584) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(MW*sw*2._/**/REALKIND)
    f(585) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw*9._/**/REALKIND)
    f(586) = (2*eQED**5*integralnorm*MH**2*SwB)/(MW*sw*9._/**/REALKIND)
    f(587) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*MW*sw*4._/**/REALKIND)
    f(588) = (eQED**5*integralnorm*MT*SwB)/(MW*sw*81._/**/REALKIND)
    f(589) = (2*eQED**5*integralnorm*MT*SwB)/(MW*sw*81._/**/REALKIND)
    f(590) = (4*eQED**5*integralnorm*MT*SwB)/(MW*sw*81._/**/REALKIND)
    f(591) = (eQED**5*integralnorm*MT*SwB)/(MW*sw*18._/**/REALKIND)
    f(592) = (eQED**5*integralnorm*MT*SwB)/(MW*sw*9._/**/REALKIND)
    f(593) = (2*eQED**5*integralnorm*MT*SwB)/(MW*sw*9._/**/REALKIND)
    f(594) = (eQED**5*integralnorm*MT*SwB)/(MW*sw*2._/**/REALKIND)
    f(595) = (eQED**5*integralnorm*MT*SwB)/(cw**2*MW*sw*4._/**/REALKIND)
    f(596) = (eQED**3*gQCD**2*integralnorm*MT*SwB)/(MW*sw*18._/**/REALKIND)
    f(597) = (eQED**3*gQCD**2*integralnorm*MT*SwB)/(MW*sw*9._/**/REALKIND)
    f(598) = (2*eQED**3*gQCD**2*integralnorm*MT*SwB)/(MW*sw*9._/**/REALKIND)
    f(599) = (eQED**3*gQCD**2*integralnorm*MT*SwB)/(MW*sw*2._/**/REALKIND)
    f(600) = (eQED**5*integralnorm*MW*SwB)/(sw*9._/**/REALKIND)
    f(601) = (2*eQED**5*integralnorm*MW*SwB)/(sw*9._/**/REALKIND)
    f(602) = (eQED**5*integralnorm*MW*SwB)/(sw*2._/**/REALKIND)
    f(603) = (eQED**5*integralnorm*MW*SwB)/(cw**4*sw*2._/**/REALKIND)
    f(604) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw*9._/**/REALKIND)
    f(605) = (2*eQED**5*integralnorm*MW*SwB)/(cw**2*sw*9._/**/REALKIND)
    f(606) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(607) = (4*eQED**5*integralnorm*MW*SwB)/(cw**2*sw*9._/**/REALKIND)
    f(608) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw*2._/**/REALKIND)
    f(609) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw)
    f(610) = (eQED**3*gQCD**2*integralnorm*MW*SwB)/(cw**2*sw)
    f(611) = (eQED**5*integralnorm*MB*MW*SwB)/(sw*9._/**/REALKIND)
    f(612) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**2*sw*6._/**/REALKIND)
    f(613) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(614) = (eQED**5*integralnorm*MH**2*MW*SwB)/(sw*9._/**/REALKIND)
    f(615) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(616) = (eQED**5*integralnorm*MT*MW*SwB)/(sw*9._/**/REALKIND)
    f(617) = (eQED**5*integralnorm*MT*MW*SwB)/(cw**2*sw*12._/**/REALKIND)
    f(618) = (eQED**5*integralnorm*MT*MW*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(619) = (2*eQED**5*integralnorm*MW**3*SwB)/(sw*9._/**/REALKIND)
    f(620) = (eQED**5*integralnorm*MW**3*SwB)/(cw**4*sw*2._/**/REALKIND)
    f(621) = (eQED**5*integralnorm*MW**3*SwB)/(cw**2*sw*2._/**/REALKIND)
    f(622) = (eQED**5*integralnorm*MW*sw*SwB)/(cw**2*2._/**/REALKIND)
    f(623) = (eQED**5*integralnorm*MB*MW*sw*SwB)/(cw**2*2._/**/REALKIND)
    f(624) = (eQED**5*integralnorm*MH**2*MW*sw*SwB)/(cw**2*2._/**/REALKIND)
    f(625) = (eQED**5*integralnorm*MT*MW*sw*SwB)/(cw**2*2._/**/REALKIND)
    f(626) = (eQED**5*integralnorm*MW**3*sw*SwB)/cw**4
    f(627) = (eQED**5*integralnorm*MW**3*sw*SwB)/cw**2
    f(628) = (eQED**5*integralnorm*MB*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f(629) = (eQED**5*integralnorm*MT*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW**3*sw**5*16._/**/REALKIND)
    f(630) = (eQED**5*integralnorm*MB*MH**2*MT*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW**3*sw**5*32._/**/REALKIND)
    f(631) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(MW*sw**5*8._/**/REALKIND))
    f(632) = (eQED**5*integralnorm*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**5*16._/**/REALKIND)
    f(633) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(MW*sw**5*8._/**/REALKIND))
    f(634) = (eQED**5*integralnorm*MB*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**5*16._/**/REALKIND)
    f(635) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(MW*sw**5*8._/**/REALKIND))
    f(636) = (eQED**5*integralnorm*MH**2*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**5*16._/**/REALKIND)
    f(637) = -((eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(MW*sw**5*8._/**/REALKIND))
    f(638) = (eQED**5*integralnorm*MT*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**5*16._/**/REALKIND)
    f(639) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(sw**5*8._/**/REALKIND))
    f(640) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(sw**5*4._/**/REALKIND))
    f(641) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**4*sw**5*16._/**/REALKIND))
    f(642) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**5*16._/**/REALKIND)
    f(643) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**5*8._/**/REALKIND)
    f(644) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*8._/**/REALKIND))
    f(645) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*8._/**/REALKIND))
    f(646) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND))
    f(647) = -((eQED**5*integralnorm*MB**2*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND))
    f(648) = -((eQED**5*integralnorm*MB*MH**4*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND))
    f(649) = (-3*eQED**5*integralnorm*lambdaHHH*MB*MH**4*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(650) = -((eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*8._/**/REALKIND))
    f(651) = -((eQED**5*integralnorm*MH**2*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND))
    f(652) = -((eQED**5*integralnorm*MB*MH**2*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND))
    f(653) = -((eQED**5*integralnorm*MH**4*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND))
    f(654) = (-3*eQED**5*integralnorm*lambdaHHH*MH**4*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(655) = -((eQED**5*integralnorm*MH**2*MT**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND))
    f(656) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**3*MW*sw**4*4._/**/REALKIND))
    f(657) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**4*8._/**/REALKIND))
    f(658) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**4*16._/**/REALKIND))
    f(659) = -((eQED**5*integralnorm*MB*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**3*MW*sw**4*16._/**/REALKIND*8._/**/REALKIND))
    f(660) = (eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*12._/**/REALKIND)
    f(661) = (eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*6._/**/REALKIND)
    f(662) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*12._/**/REALKIND)
    f(663) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*6._/**/REALKIND)
    f(664) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*3._/**/REALKIND)
    f(665) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND))
    f(666) = -((eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**4*16._/**/REALKIND))
    f(667) = -((eQED**5*integralnorm*MT*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**3*MW*sw**4*16._/**/REALKIND*8._/**/REALKIND))
    f(668) = (eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*12._/**/REALKIND)
    f(669) = (eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*6._/**/REALKIND)
    f(670) = -((eQED**5*integralnorm*MH**2*MT*(cw - sw)*(cw + sw)*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND))
    f(671) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**2*6._/**/REALKIND)
    f(672) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**2*3._/**/REALKIND)
    f(673) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*12._/**/REALKIND)
    f(674) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*6._/**/REALKIND)
    f(675) = (eQED**5*integralnorm*MB*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**2*MW**3*sw**5*16._/**/REALKIND*8._/**/REALKIND)
    f(676) = (eQED**5*integralnorm*MH**2*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**2*MW**3*sw**5*16._/**/REALKIND*8._/**/REALKIND)
    f(677) = (eQED**5*integralnorm*MT*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**2*MW**3*sw**5*16._/**/REALKIND*8._/**/REALKIND)
    f(678) = (eQED**5*integralnorm*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**4*MW*sw**5*4._/**/REALKIND*8._/**/REALKIND)
    f(679) = (eQED**5*integralnorm*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**2*MW*sw**5*16._/**/REALKIND*8._/**/REALKIND)
    f(680) = (eQED**5*integralnorm*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(681) = (eQED**5*integralnorm*MB*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**3*12._/**/REALKIND)
    f(682) = (eQED**5*integralnorm*MB*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(683) = (eQED**5*integralnorm*MH**2*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(684) = (eQED**5*integralnorm*MT*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**3*24._/**/REALKIND)
    f(685) = (eQED**5*integralnorm*MT*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(686) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**4*sw**3*4._/**/REALKIND))
    f(687) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**3*8._/**/REALKIND)
    f(688) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**3*4._/**/REALKIND)
    f(689) = (eQED**5*integralnorm*MB*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW*sw**3*4._/**/REALKIND*8._/**/REALKIND)
    f(690) = (eQED**5*integralnorm*MH**2*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW*sw**3*4._/**/REALKIND*8._/**/REALKIND)
    f(691) = (eQED**5*integralnorm*MH**2*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*MW*sw**3*2._/**/REALKIND*4._/**/REALKIND)
    f(692) = (eQED**5*integralnorm*MT*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW*sw**3*4._/**/REALKIND*8._/**/REALKIND)
    f(693) = (eQED**5*integralnorm*MW*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**4*sw**3*2._/**/REALKIND*4._/**/REALKIND)
    f(694) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(695) = (eQED**5*integralnorm*MB*SwF)/(MW**5*sw**5*8._/**/REALKIND)
    f(696) = (eQED**5*integralnorm*MB*ME**2*SwF)/(MW**5*sw**5*8._/**/REALKIND)
    f(697) = (eQED**5*integralnorm*ME**3*SwF)/(MW**5*sw**5*8._/**/REALKIND)
    f(698) = (eQED**5*integralnorm*MH**2*SwF)/(MW**5*sw**5*8._/**/REALKIND)
    f(699) = (eQED**5*integralnorm*ME**2*MH**2*SwF)/(MW**5*sw**5*8._/**/REALKIND)
    f(700) = (eQED**5*integralnorm*MB*ML**2*SwF)/(MW**5*sw**5*8._/**/REALKIND)
    f(701) = (eQED**5*integralnorm*MH**2*ML**2*SwF)/(MW**5*sw**5*8._/**/REALKIND)
    f(702) = (eQED**5*integralnorm*ML**3*SwF)/(MW**5*sw**5*8._/**/REALKIND)
    f(703) = (eQED**5*integralnorm*MB*MM**2*SwF)/(MW**5*sw**5*8._/**/REALKIND)
    f(704) = (eQED**5*integralnorm*MH**2*MM**2*SwF)/(MW**5*sw**5*8._/**/REALKIND)
    f(705) = (eQED**5*integralnorm*MM**3*SwF)/(MW**5*sw**5*8._/**/REALKIND)
    f(706) = (eQED**5*integralnorm*MT*SwF)/(MW**5*sw**5*8._/**/REALKIND)
    f(707) = (eQED**5*integralnorm*MB**4*MT*SwF)/(MW**5*sw**5*32._/**/REALKIND)
    f(708) = (eQED**5*integralnorm*ME**2*MT*SwF)/(MW**5*sw**5*8._/**/REALKIND)
    f(709) = (eQED**5*integralnorm*MB**2*ME**2*MT*SwF)/(MW**5*sw**5*32._/**/REALKIND)
    f(710) = (eQED**5*integralnorm*MB*ME**3*MT*SwF)/(MW**5*sw**5*32._/**/REALKIND)
    f(711) = (eQED**5*integralnorm*MB**3*MH**2*MT*SwF)/(MW**5*sw**5*32._/**/REALKIND)
    f(712) = (3*eQED**5*integralnorm*lambdaHHH*MB**3*MH**2*MT*SwF)/(MW**5*sw**5*32._/**/REALKIND)
    f(713) = (eQED**5*integralnorm*MB*ME**2*MH**2*MT*SwF)/(MW**5*sw**5*32._/**/REALKIND)
    f(714) = (3*eQED**5*integralnorm*lambdaHHH*MB*ME**2*MH**2*MT*SwF)/(MW**5*sw**5*32._/**/REALKIND)
    f(715) = (eQED**5*integralnorm*ML**2*MT*SwF)/(MW**5*sw**5*8._/**/REALKIND)
    f(716) = (eQED**5*integralnorm*MB**2*ML**2*MT*SwF)/(MW**5*sw**5*32._/**/REALKIND)
    f(717) = (eQED**5*integralnorm*MB*MH**2*ML**2*MT*SwF)/(MW**5*sw**5*32._/**/REALKIND)
    f(718) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*ML**2*MT*SwF)/(MW**5*sw**5*32._/**/REALKIND)
    f(719) = (eQED**5*integralnorm*MB*ML**3*MT*SwF)/(MW**5*sw**5*32._/**/REALKIND)
    f(720) = (eQED**5*integralnorm*MM**2*MT*SwF)/(MW**5*sw**5*8._/**/REALKIND)
    f(721) = (eQED**5*integralnorm*MB**2*MM**2*MT*SwF)/(MW**5*sw**5*32._/**/REALKIND)
    f(722) = (eQED**5*integralnorm*MB*MH**2*MM**2*MT*SwF)/(MW**5*sw**5*32._/**/REALKIND)
    f(723) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MM**2*MT*SwF)/(MW**5*sw**5*32._/**/REALKIND)
    f(724) = (eQED**5*integralnorm*MB*MM**3*MT*SwF)/(MW**5*sw**5*32._/**/REALKIND)
    f(725) = (eQED**5*integralnorm*MB**3*MT**2*SwF)/(MW**5*sw**5*32._/**/REALKIND)
    f(726) = (eQED**5*integralnorm*MB*ME**2*MT**2*SwF)/(MW**5*sw**5*32._/**/REALKIND)
    f(727) = (eQED**5*integralnorm*MB*ML**2*MT**2*SwF)/(MW**5*sw**5*32._/**/REALKIND)
    f(728) = (eQED**5*integralnorm*MB*MM**2*MT**2*SwF)/(MW**5*sw**5*32._/**/REALKIND)
    f(729) = (eQED**5*integralnorm*MB**2*MT**3*SwF)/(MW**5*sw**5*32._/**/REALKIND)
    f(730) = (eQED**5*integralnorm*MB*MH**2*MT**3*SwF)/(MW**5*sw**5*32._/**/REALKIND)
    f(731) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT**3*SwF)/(MW**5*sw**5*32._/**/REALKIND)
    f(732) = (eQED**5*integralnorm*MB*MT**4*SwF)/(MW**5*sw**5*32._/**/REALKIND)
    f(733) = (eQED**5*integralnorm*SwF)/(MW**3*sw**5*8._/**/REALKIND)
    f(734) = (eQED**5*integralnorm*MB*SwF)/(MW**3*sw**5*8._/**/REALKIND)
    f(735) = (eQED**5*integralnorm*ME*SwF)/(MW**3*sw**5*8._/**/REALKIND)
    f(736) = (eQED**5*integralnorm*MB*ME*SwF)/(MW**3*sw**5*8._/**/REALKIND)
    f(737) = (eQED**5*integralnorm*ME**2*SwF)/(MW**3*sw**5*8._/**/REALKIND)
    f(738) = (eQED**5*integralnorm*MH**2*SwF)/(MW**3*sw**5*8._/**/REALKIND)
    f(739) = (eQED**5*integralnorm*ME*MH**2*SwF)/(MW**3*sw**5*8._/**/REALKIND)
    f(740) = (eQED**5*integralnorm*ML*SwF)/(MW**3*sw**5*8._/**/REALKIND)
    f(741) = (eQED**5*integralnorm*MB*ML*SwF)/(MW**3*sw**5*8._/**/REALKIND)
    f(742) = (eQED**5*integralnorm*MH**2*ML*SwF)/(MW**3*sw**5*8._/**/REALKIND)
    f(743) = (eQED**5*integralnorm*ML**2*SwF)/(MW**3*sw**5*8._/**/REALKIND)
    f(744) = (eQED**5*integralnorm*MM*SwF)/(MW**3*sw**5*8._/**/REALKIND)
    f(745) = (eQED**5*integralnorm*MB*MM*SwF)/(MW**3*sw**5*8._/**/REALKIND)
    f(746) = (eQED**5*integralnorm*MH**2*MM*SwF)/(MW**3*sw**5*8._/**/REALKIND)
    f(747) = (eQED**5*integralnorm*MM**2*SwF)/(MW**3*sw**5*8._/**/REALKIND)
    f(748) = (eQED**5*integralnorm*MT*SwF)/(MW**3*sw**5*8._/**/REALKIND)
    f(749) = (eQED**5*integralnorm*ME*MT*SwF)/(MW**3*sw**5*8._/**/REALKIND)
    f(750) = (eQED**5*integralnorm*ML*MT*SwF)/(MW**3*sw**5*8._/**/REALKIND)
    f(751) = (eQED**5*integralnorm*MM*MT*SwF)/(MW**3*sw**5*8._/**/REALKIND)
    f(752) = (eQED**5*integralnorm*SwF)/(MW*sw**5*8._/**/REALKIND)
    f(753) = (eQED**5*integralnorm*SwF)/(MW*sw**5*4._/**/REALKIND)
    f(754) = (eQED**5*integralnorm*MB*SwF)/(MW*sw**5*8._/**/REALKIND)
    f(755) = (eQED**5*integralnorm*MB*SwF)/(MW*sw**5*4._/**/REALKIND)
    f(756) = (eQED**5*integralnorm*ME*SwF)/(MW*sw**5*8._/**/REALKIND)
    f(757) = (eQED**5*integralnorm*ME*SwF)/(MW*sw**5*4._/**/REALKIND)
    f(758) = (eQED**5*integralnorm*ML*SwF)/(MW*sw**5*8._/**/REALKIND)
    f(759) = (eQED**5*integralnorm*ML*SwF)/(MW*sw**5*4._/**/REALKIND)
    f(760) = (eQED**5*integralnorm*MM*SwF)/(MW*sw**5*8._/**/REALKIND)
    f(761) = (eQED**5*integralnorm*MM*SwF)/(MW*sw**5*4._/**/REALKIND)
    f(762) = (eQED**5*integralnorm*MT*SwF)/(MW*sw**5*8._/**/REALKIND)
    f(763) = (eQED**5*integralnorm*MT*SwF)/(MW*sw**5*4._/**/REALKIND)
    f(764) = (eQED**5*integralnorm*MW*SwF)/(sw**5*4._/**/REALKIND)
    f(765) = (eQED**5*integralnorm*MW*SwF)/(sw**5*2._/**/REALKIND)
    f(766) = (eQED**5*integralnorm*MB**3*SwF)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(767) = (eQED**5*integralnorm*MB*ME**2*SwF)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(768) = (eQED**5*integralnorm*MB*ML**2*SwF)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(769) = (eQED**5*integralnorm*MB*MM**2*SwF)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(770) = (eQED**5*integralnorm*MB**2*MT*SwF)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(771) = (eQED**5*integralnorm*MB*ME*MT*SwF)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(772) = (eQED**5*integralnorm*ME**2*MT*SwF)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(773) = (eQED**5*integralnorm*MB*ML*MT*SwF)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(774) = (eQED**5*integralnorm*ML**2*MT*SwF)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(775) = (eQED**5*integralnorm*MB*MM*MT*SwF)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(776) = (eQED**5*integralnorm*MM**2*MT*SwF)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(777) = (eQED**5*integralnorm*MB*MT**2*SwF)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(778) = (eQED**5*integralnorm*MT**3*SwF)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(779) = (eQED**5*integralnorm*MB**3*SwF)/(MW**3*sw**3*36._/**/REALKIND)
    f(780) = (eQED**5*integralnorm*MB**3*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(781) = (eQED**5*integralnorm*MB**2*ME*SwF)/(MW**3*sw**3*12._/**/REALKIND)
    f(782) = (eQED**5*integralnorm*MB**2*ME*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(783) = (eQED**5*integralnorm*MB*ME**2*SwF)/(MW**3*sw**3*12._/**/REALKIND)
    f(784) = (eQED**5*integralnorm*MB*ME**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(785) = (eQED**5*integralnorm*MB**2*MH**2*SwF)/(MW**3*sw**3*36._/**/REALKIND)
    f(786) = (eQED**5*integralnorm*MB**2*MH**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(787) = (eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwF)/(MW**3*sw**3*12._/**/REALKIND)
    f(788) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(789) = (eQED**5*integralnorm*MB*ME*MH**2*SwF)/(MW**3*sw**3*12._/**/REALKIND)
    f(790) = (eQED**5*integralnorm*MB*ME*MH**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(791) = (eQED**5*integralnorm*lambdaHHH*MB*ME*MH**2*SwF)/(MW**3*sw**3*4._/**/REALKIND)
    f(792) = (3*eQED**5*integralnorm*lambdaHHH*MB*ME*MH**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(793) = (eQED**5*integralnorm*MB**2*ML*SwF)/(MW**3*sw**3*12._/**/REALKIND)
    f(794) = (eQED**5*integralnorm*MB**2*ML*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(795) = (eQED**5*integralnorm*MB*MH**2*ML*SwF)/(MW**3*sw**3*12._/**/REALKIND)
    f(796) = (eQED**5*integralnorm*MB*MH**2*ML*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(797) = (eQED**5*integralnorm*lambdaHHH*MB*MH**2*ML*SwF)/(MW**3*sw**3*4._/**/REALKIND)
    f(798) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*ML*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(799) = (eQED**5*integralnorm*MB*ML**2*SwF)/(MW**3*sw**3*12._/**/REALKIND)
    f(800) = (eQED**5*integralnorm*MB*ML**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(801) = (eQED**5*integralnorm*MB**2*MM*SwF)/(MW**3*sw**3*12._/**/REALKIND)
    f(802) = (eQED**5*integralnorm*MB**2*MM*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(803) = (eQED**5*integralnorm*MB*MH**2*MM*SwF)/(MW**3*sw**3*12._/**/REALKIND)
    f(804) = (eQED**5*integralnorm*MB*MH**2*MM*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(805) = (eQED**5*integralnorm*lambdaHHH*MB*MH**2*MM*SwF)/(MW**3*sw**3*4._/**/REALKIND)
    f(806) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MM*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(807) = (eQED**5*integralnorm*MB*MM**2*SwF)/(MW**3*sw**3*12._/**/REALKIND)
    f(808) = (eQED**5*integralnorm*MB*MM**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(809) = (eQED**5*integralnorm*MB**2*MT*SwF)/(MW**3*sw**3*72._/**/REALKIND)
    f(810) = (eQED**5*integralnorm*MB**2*MT*SwF)/(MW**3*sw**3*36._/**/REALKIND)
    f(811) = (eQED**5*integralnorm*MB**2*MT*SwF)/(MW**3*sw**3*18._/**/REALKIND)
    f(812) = (eQED**5*integralnorm*MB**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(813) = (eQED**5*integralnorm*MB*ME*MT*SwF)/(MW**3*sw**3*24._/**/REALKIND)
    f(814) = (eQED**5*integralnorm*MB*ME*MT*SwF)/(MW**3*sw**3*12._/**/REALKIND)
    f(815) = (eQED**5*integralnorm*MB*ME*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(816) = (eQED**5*integralnorm*ME**2*MT*SwF)/(MW**3*sw**3*24._/**/REALKIND)
    f(817) = (eQED**5*integralnorm*ME**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(818) = (eQED**5*integralnorm*MB*MH**2*MT*SwF)/(MW**3*sw**3*72._/**/REALKIND)
    f(819) = (eQED**5*integralnorm*MB*MH**2*MT*SwF)/(MW**3*sw**3*18._/**/REALKIND)
    f(820) = (eQED**5*integralnorm*MB*MH**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(821) = (eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwF)/(MW**3*sw**3*24._/**/REALKIND)
    f(822) = (eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwF)/(MW**3*sw**3*6._/**/REALKIND)
    f(823) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(824) = (eQED**5*integralnorm*ME*MH**2*MT*SwF)/(MW**3*sw**3*24._/**/REALKIND)
    f(825) = (eQED**5*integralnorm*ME*MH**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(826) = (eQED**5*integralnorm*lambdaHHH*ME*MH**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(827) = (3*eQED**5*integralnorm*lambdaHHH*ME*MH**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(828) = (eQED**5*integralnorm*MB*ML*MT*SwF)/(MW**3*sw**3*24._/**/REALKIND)
    f(829) = (eQED**5*integralnorm*MB*ML*MT*SwF)/(MW**3*sw**3*12._/**/REALKIND)
    f(830) = (eQED**5*integralnorm*MB*ML*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(831) = (eQED**5*integralnorm*MH**2*ML*MT*SwF)/(MW**3*sw**3*24._/**/REALKIND)
    f(832) = (eQED**5*integralnorm*MH**2*ML*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(833) = (eQED**5*integralnorm*lambdaHHH*MH**2*ML*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(834) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*ML*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(835) = (eQED**5*integralnorm*ML**2*MT*SwF)/(MW**3*sw**3*24._/**/REALKIND)
    f(836) = (eQED**5*integralnorm*ML**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(837) = (eQED**5*integralnorm*MB*MM*MT*SwF)/(MW**3*sw**3*24._/**/REALKIND)
    f(838) = (eQED**5*integralnorm*MB*MM*MT*SwF)/(MW**3*sw**3*12._/**/REALKIND)
    f(839) = (eQED**5*integralnorm*MB*MM*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(840) = (eQED**5*integralnorm*MH**2*MM*MT*SwF)/(MW**3*sw**3*24._/**/REALKIND)
    f(841) = (eQED**5*integralnorm*MH**2*MM*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(842) = (eQED**5*integralnorm*lambdaHHH*MH**2*MM*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(843) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MM*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(844) = (eQED**5*integralnorm*MM**2*MT*SwF)/(MW**3*sw**3*24._/**/REALKIND)
    f(845) = (eQED**5*integralnorm*MM**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(846) = (eQED**5*integralnorm*MB*MT**2*SwF)/(MW**3*sw**3*72._/**/REALKIND)
    f(847) = (eQED**5*integralnorm*MB*MT**2*SwF)/(MW**3*sw**3*36._/**/REALKIND)
    f(848) = (eQED**5*integralnorm*MB*MT**2*SwF)/(MW**3*sw**3*18._/**/REALKIND)
    f(849) = (eQED**5*integralnorm*MB*MT**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(850) = (eQED**5*integralnorm*ME*MT**2*SwF)/(MW**3*sw**3*24._/**/REALKIND)
    f(851) = (eQED**5*integralnorm*ME*MT**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(852) = (eQED**5*integralnorm*MH**2*MT**2*SwF)/(MW**3*sw**3*36._/**/REALKIND)
    f(853) = (eQED**5*integralnorm*MH**2*MT**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(854) = (eQED**5*integralnorm*lambdaHHH*MH**2*MT**2*SwF)/(MW**3*sw**3*12._/**/REALKIND)
    f(855) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(856) = (eQED**5*integralnorm*ML*MT**2*SwF)/(MW**3*sw**3*24._/**/REALKIND)
    f(857) = (eQED**5*integralnorm*ML*MT**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(858) = (eQED**5*integralnorm*MM*MT**2*SwF)/(MW**3*sw**3*24._/**/REALKIND)
    f(859) = (eQED**5*integralnorm*MM*MT**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(860) = (eQED**5*integralnorm*MT**3*SwF)/(MW**3*sw**3*36._/**/REALKIND)
    f(861) = (eQED**5*integralnorm*MT**3*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(862) = (eQED**5*integralnorm*MB**2*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(863) = (eQED**5*integralnorm*MB*ME*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(864) = (eQED**5*integralnorm*MB*ML*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(865) = (eQED**5*integralnorm*MB*MM*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(866) = (eQED**5*integralnorm*MB*MT*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(867) = (eQED**5*integralnorm*ME*MT*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(868) = (eQED**5*integralnorm*ML*MT*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(869) = (eQED**5*integralnorm*MM*MT*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(870) = (eQED**5*integralnorm*MT**2*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(871) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*36._/**/REALKIND)
    f(872) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*18._/**/REALKIND)
    f(873) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*9._/**/REALKIND)
    f(874) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*6._/**/REALKIND)
    f(875) = (2*eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*9._/**/REALKIND)
    f(876) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(877) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*2._/**/REALKIND)
    f(878) = (3*eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(879) = (eQED**5*integralnorm*ME*SwF)/(cw*MW*sw**2*12._/**/REALKIND)
    f(880) = (eQED**5*integralnorm*ME*SwF)/(cw*MW*sw**2*6._/**/REALKIND)
    f(881) = (eQED**5*integralnorm*ME*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(882) = (eQED**5*integralnorm*ML*SwF)/(cw*MW*sw**2*12._/**/REALKIND)
    f(883) = (eQED**5*integralnorm*ML*SwF)/(cw*MW*sw**2*6._/**/REALKIND)
    f(884) = (eQED**5*integralnorm*ML*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(885) = (eQED**5*integralnorm*MM*SwF)/(cw*MW*sw**2*12._/**/REALKIND)
    f(886) = (eQED**5*integralnorm*MM*SwF)/(cw*MW*sw**2*6._/**/REALKIND)
    f(887) = (eQED**5*integralnorm*MM*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(888) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*36._/**/REALKIND)
    f(889) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*18._/**/REALKIND)
    f(890) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*12._/**/REALKIND)
    f(891) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*9._/**/REALKIND)
    f(892) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(893) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*2._/**/REALKIND)
    f(894) = (3*eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(895) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*81._/**/REALKIND)
    f(896) = (2*eQED**5*integralnorm*MB*SwF)/(MW*sw*81._/**/REALKIND)
    f(897) = (4*eQED**5*integralnorm*MB*SwF)/(MW*sw*81._/**/REALKIND)
    f(898) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*18._/**/REALKIND)
    f(899) = (8*eQED**5*integralnorm*MB*SwF)/(MW*sw*81._/**/REALKIND)
    f(900) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*9._/**/REALKIND)
    f(901) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*6._/**/REALKIND)
    f(902) = (2*eQED**5*integralnorm*MB*SwF)/(MW*sw*9._/**/REALKIND)
    f(903) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*3._/**/REALKIND)
    f(904) = (4*eQED**5*integralnorm*MB*SwF)/(MW*sw*9._/**/REALKIND)
    f(905) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*2._/**/REALKIND)
    f(906) = (eQED**5*integralnorm*MB*SwF)/(MW*sw)
    f(907) = (3*eQED**5*integralnorm*MB*SwF)/(MW*sw*2._/**/REALKIND)
    f(908) = (eQED**5*integralnorm*ME*SwF)/(MW*sw*9._/**/REALKIND)
    f(909) = (eQED**5*integralnorm*ME*SwF)/(MW*sw*6._/**/REALKIND)
    f(910) = (eQED**5*integralnorm*ME*SwF)/(MW*sw*3._/**/REALKIND)
    f(911) = (eQED**5*integralnorm*ME*SwF)/(MW*sw*2._/**/REALKIND)
    f(912) = (eQED**5*integralnorm*ML*SwF)/(MW*sw*9._/**/REALKIND)
    f(913) = (eQED**5*integralnorm*ML*SwF)/(MW*sw*6._/**/REALKIND)
    f(914) = (eQED**5*integralnorm*ML*SwF)/(MW*sw*3._/**/REALKIND)
    f(915) = (eQED**5*integralnorm*ML*SwF)/(MW*sw*2._/**/REALKIND)
    f(916) = (eQED**5*integralnorm*MM*SwF)/(MW*sw*9._/**/REALKIND)
    f(917) = (eQED**5*integralnorm*MM*SwF)/(MW*sw*6._/**/REALKIND)
    f(918) = (eQED**5*integralnorm*MM*SwF)/(MW*sw*3._/**/REALKIND)
    f(919) = (eQED**5*integralnorm*MM*SwF)/(MW*sw*2._/**/REALKIND)
    f(920) = (eQED**5*integralnorm*MT*SwF)/(MW*sw*81._/**/REALKIND)
    f(921) = (2*eQED**5*integralnorm*MT*SwF)/(MW*sw*81._/**/REALKIND)
    f(922) = (4*eQED**5*integralnorm*MT*SwF)/(MW*sw*81._/**/REALKIND)
    f(923) = (eQED**5*integralnorm*MT*SwF)/(MW*sw*18._/**/REALKIND)
    f(924) = (8*eQED**5*integralnorm*MT*SwF)/(MW*sw*81._/**/REALKIND)
    f(925) = (eQED**5*integralnorm*MT*SwF)/(MW*sw*9._/**/REALKIND)
    f(926) = (eQED**5*integralnorm*MT*SwF)/(MW*sw*6._/**/REALKIND)
    f(927) = (2*eQED**5*integralnorm*MT*SwF)/(MW*sw*9._/**/REALKIND)
    f(928) = (eQED**5*integralnorm*MT*SwF)/(MW*sw*3._/**/REALKIND)
    f(929) = (4*eQED**5*integralnorm*MT*SwF)/(MW*sw*9._/**/REALKIND)
    f(930) = (eQED**5*integralnorm*MT*SwF)/(MW*sw*2._/**/REALKIND)
    f(931) = (eQED**5*integralnorm*MT*SwF)/(MW*sw)
    f(932) = (3*eQED**5*integralnorm*MT*SwF)/(MW*sw*2._/**/REALKIND)
    f(933) = (eQED**5*integralnorm*MW*SwF)/(cw**2*sw*9._/**/REALKIND)
    f(934) = (2*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*9._/**/REALKIND)
    f(935) = (eQED**5*integralnorm*MW*SwF)/(cw**2*sw*3._/**/REALKIND)
    f(936) = (4*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*9._/**/REALKIND)
    f(937) = (2*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*3._/**/REALKIND)
    f(938) = (8*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*9._/**/REALKIND)
    f(939) = (eQED**5*integralnorm*MW*SwF)/(cw**2*sw)
    f(940) = (2*eQED**5*integralnorm*MW*SwF)/(cw**2*sw)
    f(941) = (3*eQED**5*integralnorm*MW*SwF)/(cw**2*sw)

  c = [ 6*f(159), 6*f(160), 6*f(161), 6*f(162), 6*f(163), 6*f(164), 6*f(165), 6*f(166), 6*f(167), 6*f(168), 6*f(169), 6*f(170) &
    , 6*f(171), 6*f(172), 6*f(173), 6*f(174), 6*f(175), 6*f(176), 6*f(177), 6*f(178), 6*f(179), 6*f(180), 6*f(181), 6*f(182) &
    , 6*f(183), 6*f(184), 6*f(185), 6*f(186), 6*f(187), 6*f(188), 6*f(189), 6*f(190), 6*f(191), 6*f(192), 6*f(193), 6*f(194) &
    , 6*f(195), 6*f(196), 6*f(197), 6*f(198), 6*f(199), 6*f(200), 6*f(201), 6*f(202), 6*f(203), 6*f(204), 6*f(205), 6*f(206) &
    , 6*f(207), 6*f(208), 6*f(209), 6*f(210), 6*f(211), 6*f(212), 6*f(213), 6*f(214), 6*f(215), 6*f(216), 6*f(217), 6*f(218) &
    , 6*f(219), 6*f(220), 6*f(221), 6*f(222), 6*f(223), 6*f(224), 6*f(225), 6*f(226), 6*f(227), 6*f(228), 6*f(229), 6*f(230) &
    , 6*f(231), 6*f(232), 6*f(233), 6*f(234), 6*f(235), 6*f(236), 6*f(237), 6*f(238), 6*f(239), 6*f(240), 6*f(241), 6*f(242) &
    , 6*f(243), 6*f(244), 6*f(245), 6*f(246), 6*f(247), 6*f(248), 6*f(249), 6*f(250), 6*f(251), 6*f(252), 6*f(253), 6*f(254) &
    , 6*f(255), 6*f(256), 6*f(257), 6*f(258), 6*f(259), 6*f(260), 6*f(261), 6*f(262), 6*f(263), 6*f(264), 6*f(265), 6*f(266) &
    , 6*f(267), 6*f(268), 6*f(269), 6*f(270), 6*f(271), 6*f(272), 6*f(273), 6*f(274), 6*f(275), 6*f(276), 6*f(277), 6*f(278) &
    , 6*f(279), 6*f(280), 6*f(281), 6*f(282), 6*f(283), 6*f(284), 6*f(285), 6*f(286), 6*f(287), 6*f(288), 6*f(289), 6*f(290) &
    , 6*f(291), 6*f(292), 6*f(293), 6*f(294), 6*f(295), 6*f(296), 6*f(297), 6*f(298), 6*f(299), 6*f(300), 6*f(301), 6*f(302) &
    , 6*f(303), 6*f(304), 6*f(305), 6*f(306), 6*f(307), 6*f(308), 6*f(309), 6*f(310), 6*f(311), 6*f(312), 6*f(313), 6*f(314) &
    , 6*f(315), 6*f(316), 6*f(317), 6*f(318), 6*f(319), 6*f(320), 6*f(321), 6*f(322), 6*f(323), 6*f(324), 6*f(325), 6*f(326) &
    , 6*f(327), 6*f(328), 6*f(329), 6*f(330), 6*f(331), 6*f(332), 6*f(333), 6*f(334), 6*f(335), 6*f(336), 6*f(337), 6*f(338) &
    , 6*f(339), 6*f(340), 6*f(341), 6*f(342), 6*f(343), 6*f(344), 6*f(345), 6*f(346), 6*f(347), 6*f(348), 6*f(349), 6*f(350) &
    , 6*f(351), 6*f(352), 6*f(353), 6*f(354), 6*f(355), 6*f(356), 6*f(357), 6*f(358), 6*f(359), 6*f(360), 6*f(361), 6*f(362) &
    , 6*f(363), 6*f(364), 6*f(365), 6*f(366), 6*f(367), 6*f(368), 6*f(369), 6*f(370), 6*f(371), 6*f(372), 6*f(373), 6*f(374) &
    , 6*f(375), 6*f(376), 6*f(377), 6*f(378), 6*f(379), 6*f(380), 6*f(381), 6*f(382), 6*f(383), 6*f(384), 6*f(385), f(386) &
    , 3*f(386), 8*f(386), 6*f(387), 6*f(388), f(389), 3*f(389), 6*f(390), 6*f(391), 6*f(392), 6*f(393), 6*f(394), 6*f(395), f(396) &
    , 3*f(396), 8*f(396), 6*f(397), 6*f(398), 6*f(399), 6*f(400), f(401), 3*f(401), 6*f(402), 6*f(403), f(404), 3*f(404), 6*f(405) &
    , 6*f(406), 6*f(407), 6*f(408), 6*f(409), 6*f(410), 6*f(411), 6*f(412), f(413), 3*f(413), 8*f(413), 6*f(414), 6*f(415) &
    , 6*f(416), 6*f(417), f(418), 3*f(418), 8*f(418), 6*f(419), 6*f(420), 6*f(421), 6*f(422), 6*f(423), 6*f(424), 6*f(425), f(426) &
    , 3*f(426), 8*f(426), 6*f(427), 6*f(428), 6*f(429), 6*f(430), f(431), 3*f(431), 8*f(431), 6*f(432), 6*f(433), 6*f(434) &
    , 6*f(435), 6*f(436), 6*f(437), f(438), 3*f(438), 8*f(438), 6*f(439), 6*f(440), 6*f(441), f(442), 3*f(442), 6*f(443), 6*f(444) &
    , f(445), 3*f(445), 6*f(446), 6*f(447), f(448), 3*f(448), 6*f(449), 6*f(450), 6*f(451), 6*f(452), 6*f(453), 6*f(454), 6*f(455) &
    , 6*f(456), f(457), 3*f(457), 8*f(457), 6*f(458), 6*f(459), 6*f(460), 6*f(461), 6*f(462), 6*f(463), 6*f(464), 6*f(465) &
    , 6*f(466), f(467), 3*f(467), 8*f(467), 6*f(468), 6*f(469), 6*f(470), 6*f(471), 6*f(472), 6*f(473), 6*f(474), 6*f(475) &
    , 6*f(476), 6*f(477), 6*f(478), 6*f(479), 6*f(480), 6*f(481), 6*f(482), 6*f(483), 6*f(484), 6*f(485), 6*f(486), 6*f(487) &
    , 6*f(488), 6*f(489), f(490), 3*f(490), 8*f(490), 6*f(491), 6*f(492), 6*f(493), 6*f(494), 6*f(495), 6*f(496), 6*f(497) &
    , 6*f(498), 6*f(499), 6*f(500), 6*f(501), 6*f(502), 6*f(503), 6*f(504), 6*f(505), 6*f(506), 6*f(507), 6*f(508), 6*f(509) &
    , 6*f(510), 6*f(511), 6*f(512), 6*f(513), 6*f(514), 6*f(515), 6*f(516), 6*f(517), f(518), 3*f(518), 8*f(518), 6*f(519) &
    , 6*f(520), 6*f(521), 6*f(522), 6*f(523), 6*f(524), 6*f(525), 6*f(526), 6*f(527), 6*f(528), 6*f(529), 6*f(530), 6*f(531) &
    , 6*f(532), 6*f(533), 6*f(534), 6*f(535), 6*f(536), 6*f(537), 6*f(538), 6*f(539), 6*f(540), f(541), 3*f(541), 8*f(541) &
    , 6*f(542), 6*f(543), 6*f(544), 6*f(545), 6*f(546), 6*f(547), 6*f(548), 6*f(549), 6*f(550), 6*f(551), 6*f(552), f(553) &
    , 3*f(553), 8*f(553), 6*f(554), 6*f(555), 6*f(556), 6*f(557), 6*f(558), 6*f(559), 6*f(560), 6*f(561), 6*f(562), 6*f(563) &
    , 6*f(564), 6*f(565), 6*f(566), 6*f(567), 6*f(568), 6*f(569), 6*f(570), 6*f(571), 6*f(572), 6*f(573), 6*f(574), 6*f(575) &
    , 6*f(576), 6*f(577), 6*f(578), 6*f(579), 6*f(580), f(581), 3*f(581), f(582), 3*f(582), 8*f(582), f(583), 3*f(583), f(584) &
    , 3*f(584), 8*f(584), 6*f(585), 6*f(586), 6*f(587), 6*f(588), 6*f(589), 6*f(590), 6*f(591), 6*f(592), 6*f(593), 6*f(594) &
    , 6*f(595), f(596), 3*f(596), f(597), 3*f(597), 8*f(597), f(598), 3*f(598), f(599), 3*f(599), 8*f(599), 6*f(600), 6*f(601) &
    , 6*f(602), 6*f(603), 6*f(604), 6*f(605), 6*f(606), 6*f(607), 6*f(608), 6*f(609), f(610), 3*f(610), 8*f(610), 6*f(611) &
    , 6*f(612), 6*f(613), 6*f(614), 6*f(615), 6*f(616), 6*f(617), 6*f(618), 6*f(619), 6*f(620), 6*f(621), 6*f(622), 6*f(623) &
    , 6*f(624), 6*f(625), 6*f(626), 6*f(627), 6*f(628), 6*f(629), 6*f(630), 6*f(631), 6*f(632), 6*f(633), 6*f(634), 6*f(635) &
    , 6*f(636), 6*f(637), 6*f(638), 6*f(639), 6*f(640), 6*f(641), 6*f(642), 6*f(643), 6*f(644), 6*f(645), 6*f(646), 6*f(647) &
    , 6*f(648), 6*f(649), 6*f(650), 6*f(651), 6*f(652), 6*f(653), 6*f(654), 6*f(655), 6*f(656), 6*f(657), 6*f(658), 6*f(659) &
    , 6*f(660), 6*f(661), 6*f(662), 6*f(663), 6*f(664), 6*f(665), 6*f(666), 6*f(667), 6*f(668), 6*f(669), 6*f(670), 6*f(671) &
    , 6*f(672), 6*f(673), 6*f(674), 6*f(675), 6*f(676), 6*f(677), 6*f(678), 6*f(679), 6*f(680), 6*f(681), 6*f(682), 6*f(683) &
    , 6*f(684), 6*f(685), 6*f(686), 6*f(687), 6*f(688), 6*f(689), 6*f(690), 6*f(691), 6*f(692), 6*f(693), 6*f(694), 18*f(695) &
    , 6*f(696), 6*f(697), 18*f(698), 6*f(699), 6*f(700), 6*f(701), 6*f(702), 6*f(703), 6*f(704), 6*f(705), 18*f(706), 18*f(707) &
    , 6*f(708), 6*f(709), 6*f(710), 18*f(711), 18*f(712), 6*f(713), 6*f(714), 6*f(715), 6*f(716), 6*f(717), 6*f(718), 6*f(719) &
    , 6*f(720), 6*f(721), 6*f(722), 6*f(723), 6*f(724), 18*f(725), 6*f(726), 6*f(727), 6*f(728), 18*f(729), 18*f(730), 18*f(731) &
    , 18*f(732), 18*f(733), 18*f(734), 6*f(735), 6*f(736), 6*f(737), 18*f(738), 6*f(739), 6*f(740), 6*f(741), 6*f(742), 6*f(743) &
    , 6*f(744), 6*f(745), 6*f(746), 6*f(747), 18*f(748), 6*f(749), 6*f(750), 6*f(751), 6*f(752), 18*f(752), 18*f(753), 6*f(754) &
    , 18*f(754), 18*f(755), 6*f(756), 6*f(757), 6*f(758), 6*f(759), 6*f(760), 6*f(761), 6*f(762), 18*f(762), 18*f(763), 6*f(764) &
    , 18*f(764), 18*f(765), 18*f(766), 6*f(767), 6*f(768), 6*f(769), 18*f(770), 6*f(771), 6*f(772), 6*f(773), 6*f(774), 6*f(775) &
    , 6*f(776), 18*f(777), 18*f(778), 18*f(779), 18*f(780), 6*f(781), 6*f(782), 6*f(783), 6*f(784), 18*f(785), 18*f(786) &
    , 18*f(787), 18*f(788), 6*f(789), 6*f(790), 6*f(791), 6*f(792), 6*f(793), 6*f(794), 6*f(795), 6*f(796), 6*f(797), 6*f(798) &
    , 6*f(799), 6*f(800), 6*f(801), 6*f(802), 6*f(803), 6*f(804), 6*f(805), 6*f(806), 6*f(807), 6*f(808), 18*f(809), 18*f(810) &
    , 18*f(811), 18*f(812), 6*f(813), 6*f(814), 6*f(815), 6*f(816), 6*f(817), 18*f(818), 18*f(819), 18*f(820), 18*f(821) &
    , 18*f(822), 18*f(823), 6*f(824), 6*f(825), 6*f(826), 6*f(827), 6*f(828), 6*f(829), 6*f(830), 6*f(831), 6*f(832), 6*f(833) &
    , 6*f(834), 6*f(835), 6*f(836), 6*f(837), 6*f(838), 6*f(839), 6*f(840), 6*f(841), 6*f(842), 6*f(843), 6*f(844), 6*f(845) &
    , 18*f(846), 18*f(847), 18*f(848), 18*f(849), 6*f(850), 6*f(851), 18*f(852), 18*f(853), 18*f(854), 18*f(855), 6*f(856) &
    , 6*f(857), 6*f(858), 6*f(859), 18*f(860), 18*f(861), 18*f(862), 6*f(863), 6*f(864), 6*f(865), 18*f(866), 6*f(867), 6*f(868) &
    , 6*f(869), 18*f(870), 18*f(871), 18*f(872), 18*f(873), 6*f(874), 18*f(875), 6*f(876), 18*f(876), 18*f(877), 6*f(878) &
    , 6*f(879), 6*f(880), 6*f(881), 6*f(882), 6*f(883), 6*f(884), 6*f(885), 6*f(886), 6*f(887), 18*f(888), 18*f(889), 6*f(890) &
    , 18*f(891), 6*f(892), 18*f(892), 18*f(893), 6*f(894), 18*f(895), 18*f(896), 18*f(897), 18*f(898), 18*f(899), 6*f(900) &
    , 18*f(900), 6*f(901), 18*f(902), 6*f(903), 18*f(904), 6*f(905), 18*f(905), 18*f(906), 6*f(907), 6*f(908), 6*f(909), 6*f(910) &
    , 6*f(911), 6*f(912), 6*f(913), 6*f(914), 6*f(915), 6*f(916), 6*f(917), 6*f(918), 6*f(919), 18*f(920), 18*f(921), 18*f(922) &
    , 18*f(923), 18*f(924), 6*f(925), 18*f(925), 6*f(926), 18*f(927), 6*f(928), 18*f(929), 6*f(930), 18*f(930), 18*f(931) &
    , 6*f(932), 18*f(933), 18*f(934), 6*f(935), 18*f(936), 6*f(937), 18*f(938), 6*f(939), 18*f(939), 18*f(940), 6*f(941) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3) - MH2)+L(6,3))
  den(2) = 1 /((L(5,12) - MH2)+L(6,12))
  den(4) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(5) = 1 /((L(5,12) - MZ2)+L(6,12))
  den(7) = 1 /((L(5,20) - MB2)+L(6,20))
  den(10) = 1 /((L(5,3))+L(6,3))
  den(12) = 1 /((L(5,24) - MB2)+L(6,24))
  den(16) = 1 /((L(5,9) - MW2)+L(6,9))
  den(17) = 1 /((L(5,6) - MW2)+L(6,6))
  den(19) = 1 /((L(5,17) - MT2)+L(6,17))
  den(22) = 1 /((L(5,18) - MT2)+L(6,18))
  den(27) = 1 /((L(5,12))+L(6,12))
  den(35) = 1 /((L(5,28) - MH2)+L(6,28))
  den(38) = 1 /((L(5,28) - MZ2)+L(6,28))
  den(42) = 1 /((L(5,19) - MH2)+L(6,19))
  den(45) = 1 /((L(5,19) - MZ2)+L(6,19))
  den(53) = 1 /((L(5,28))+L(6,28))
  den(58) = 1 /((L(5,11) - MB2)+L(6,11))
  den(73) = 1 /((L(5,7) - MB2)+L(6,7))
  den(80) = 1 /((L(5,22) - MW2)+L(6,22))
  den(83) = 1 /((L(5,25) - MW2)+L(6,25))
  den(86) = 1 /((L(5,14) - MT2)+L(6,14))
  den(97) = 1 /((L(5,13) - MT2)+L(6,13))
  den(115) = 1 /((L(5,19))+L(6,19))

  ! denominators
  den(3) = den(1)*den(2)
  den(6) = den(4)*den(5)
  den(8) = den(1)*den(7)
  den(9) = den(4)*den(7)
  den(11) = den(7)*den(10)
  den(13) = den(1)*den(12)
  den(14) = den(4)*den(12)
  den(15) = den(10)*den(12)
  den(18) = den(16)*den(17)
  den(20) = den(17)*den(19)
  den(21) = den(12)*den(17)
  den(23) = den(16)*den(22)
  den(24) = den(7)*den(16)
  den(25) = den(2)*den(19)
  den(26) = den(5)*den(19)
  den(28) = den(19)*den(27)
  den(29) = den(2)*den(22)
  den(30) = den(5)*den(22)
  den(31) = den(22)*den(27)
  den(32) = den(4)*den(27)
  den(33) = den(5)*den(10)
  den(34) = den(10)*den(27)
  den(36) = den(2)*den(35)
  den(37) = den(1)*den(36)
  den(39) = den(5)*den(38)
  den(40) = den(4)*den(39)
  den(41) = den(10)*den(39)
  den(43) = den(1)*den(42)
  den(44) = den(2)*den(43)
  den(46) = den(4)*den(45)
  den(47) = den(5)*den(46)
  den(48) = den(27)*den(46)
  den(49) = den(7)*den(35)
  den(50) = den(1)*den(49)
  den(51) = den(7)*den(38)
  den(52) = den(4)*den(51)
  den(54) = den(7)*den(53)
  den(55) = den(4)*den(54)
  den(56) = den(10)*den(51)
  den(57) = den(10)*den(54)
  den(59) = den(1)*den(58)
  den(60) = den(7)*den(59)
  den(61) = den(4)*den(58)
  den(62) = den(7)*den(61)
  den(63) = den(10)*den(58)
  den(64) = den(7)*den(63)
  den(65) = den(12)*den(35)
  den(66) = den(1)*den(65)
  den(67) = den(12)*den(38)
  den(68) = den(4)*den(67)
  den(69) = den(12)*den(53)
  den(70) = den(4)*den(69)
  den(71) = den(10)*den(67)
  den(72) = den(10)*den(69)
  den(74) = den(1)*den(73)
  den(75) = den(12)*den(74)
  den(76) = den(4)*den(73)
  den(77) = den(12)*den(76)
  den(78) = den(10)*den(73)
  den(79) = den(12)*den(78)
  den(81) = den(17)*den(80)
  den(82) = den(16)*den(81)
  den(84) = den(16)*den(83)
  den(85) = den(17)*den(84)
  den(87) = den(17)*den(86)
  den(88) = den(19)*den(87)
  den(89) = den(19)*den(83)
  den(90) = den(17)*den(89)
  den(91) = den(12)*den(83)
  den(92) = den(17)*den(91)
  den(93) = den(17)*den(73)
  den(94) = den(12)*den(93)
  den(95) = den(22)*den(80)
  den(96) = den(16)*den(95)
  den(98) = den(16)*den(97)
  den(99) = den(22)*den(98)
  den(100) = den(7)*den(80)
  den(101) = den(16)*den(100)
  den(102) = den(16)*den(58)
  den(103) = den(7)*den(102)
  den(104) = den(2)*den(86)
  den(105) = den(19)*den(104)
  den(106) = den(5)*den(86)
  den(107) = den(19)*den(106)
  den(108) = den(27)*den(86)
  den(109) = den(19)*den(108)
  den(110) = den(19)*den(42)
  den(111) = den(2)*den(110)
  den(112) = den(19)*den(45)
  den(113) = den(5)*den(112)
  den(114) = den(27)*den(112)
  den(116) = den(19)*den(115)
  den(117) = den(5)*den(116)
  den(118) = den(27)*den(116)
  den(119) = den(2)*den(97)
  den(120) = den(22)*den(119)
  den(121) = den(5)*den(97)
  den(122) = den(22)*den(121)
  den(123) = den(27)*den(97)
  den(124) = den(22)*den(123)
  den(125) = den(22)*den(42)
  den(126) = den(2)*den(125)
  den(127) = den(22)*den(45)
  den(128) = den(5)*den(127)
  den(129) = den(27)*den(127)
  den(130) = den(22)*den(115)
  den(131) = den(5)*den(130)
  den(132) = den(27)*den(130)
  den(133) = den(1)*den(5)
  den(134) = den(2)*den(4)
  den(135) = den(1)*den(27)
  den(136) = den(2)*den(10)
  den(137) = den(5)*den(43)
  den(138) = den(2)*den(46)
  den(139) = den(27)*den(43)
  den(140) = den(1)*den(39)
  den(141) = den(4)*den(36)
  den(142) = den(10)*den(36)
  den(143) = den(1)*den(51)
  den(144) = den(4)*den(49)
  den(145) = den(1)*den(54)
  den(146) = den(10)*den(49)
  den(147) = den(1)*den(67)
  den(148) = den(4)*den(65)
  den(149) = den(1)*den(69)
  den(150) = den(10)*den(65)
  den(151) = den(5)*den(110)
  den(152) = den(2)*den(112)
  den(153) = den(27)*den(110)
  den(154) = den(2)*den(116)
  den(155) = den(5)*den(125)
  den(156) = den(2)*den(127)
  den(157) = den(27)*den(125)
  den(158) = den(2)*den(130)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_pphtt_ew_ttxbbxh_3_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,393))
  allocate(M1helarray(4,hel_states))
  allocate(M1helarray_ct(4,hel_states))
  allocate(M0_col1_helarray(4,hel_states))
#if 1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(4,hel_states,16))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
#else
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
  use ol_loop_storage_pphtt_ew_ttxbbxh_3_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for top anti-top bottom anti-bottom higgs -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_pphtt_ew_ttxbbxh_3, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_pphtt_ew_ttxbbxh_3, only: &
    & external_perm_pphtt_ew_ttxbbxh_3, &
    & external_perm_inv_pphtt_ew_ttxbbxh_3, &
    & extcomb_perm_pphtt_ew_ttxbbxh_3, &
    & average_factor_pphtt_ew_ttxbbxh_3
  use ol_external_pphtt_ew_ttxbbxh_3, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_pphtt_ew_ttxbbxh_3_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pphtt_ew_ttxbbxh_3_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_pphtt_ew_ttxbbxh_3
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02
  logical, intent(in) :: qp_kinematics
  real(REALKIND),  intent(out), optional :: M2ct
  real(REALKIND),  intent(out), optional :: M2colint(16)
  real(REALKIND) :: iM2ct
  real(REALKIND) :: iM2colint(16)

  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(4), M2(4)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak
  logical              :: do_ct, do_colint
#if 5 > 3
  integer :: ind_cc_comb(5)
#endif
  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if (present(M2ct)) then
    do_ct = .true.
  else
    do_ct = .false.
  end if

  if (present(M2colint)) then
    do_colint = .true.
  else
    do_colint = .false.
  end if

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, qp_kinematics, M2ct=iM2ct, M2colint=iM2colint)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,393))
  end if

  if (do_ct) call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()
  if (do_ct) call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  if (do_ct) call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMT, nMT, nMB, nMB, nMH ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_pphtt_ew_ttxbbxh_3, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMT, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rMT, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rMB, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rMB, H4, ex4, POLSEL(4),4)
  call pol_wf_S(P(:,5), rMH, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_AQ_S(gH,ntry, ex4(:), ex3(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_SS_S(ntry, wf4(:,1), ex5(:), wf4(:,3), n3(:,3), t3x4(:,:,3))
  call vert_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,4), n3(:,4), t3x4(:,:,4))
  call vert_AQ_S(gX,ntry, ex4(:), ex3(:), wf4(:,5), n3(:,5), t3x4(:,:,5))
  call vert_SS_S(ntry, wf4(:,4), ex5(:), wf4(:,6), n3(:,6), t3x4(:,:,6))
  call vert_QA_Z(gZd,ntry, ex3(:), ex4(:), wf4(:,7), n3(:,7), t3x4(:,:,7))
  call vert_ST_V(ntry, wf4(:,4), 3, ex5(:), 16, wf4(:,8), n3(:,8), t3x4(:,:,8))
  call vert_QA_Z(gZu,ntry, ex1(:), ex2(:), wf4(:,9), n3(:,9), t3x4(:,:,9))
  call vert_TV_S(ntry, ex5(:), 16, wf4(:,9), 3, wf4(:,10), n3(:,10), t3x4(:,:,10))
  call vert_SV_V(ntry, ex5(:), wf4(:,9), wf4(:,11), n3(:,11), t3x4(:,:,11))
  call vert_QS_A(gH,ntry, ex3(:), ex5(:), wf2(:,1), n3(:,12), t3x2(:,:,1))
  call prop_Q_A(ntry, wf2(:,1), 20, MB, 1_intkind1, wf2(:,2), n2(1))
  call vert_SA_Q(gH,ntry, wf4(:,1), ex4(:), wf8(:,1), n3(:,13), t3x8(:,:,1))
  call vert_SA_Q(gX,ntry, wf4(:,4), ex4(:), wf8(:,2), n3(:,14), t3x8(:,:,2))
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,12), n3(:,15), t3x4(:,:,12))
  call vert_AV_Q(ntry, ex4(:), wf4(:,12), wf8(:,3), n3(:,16), t3x8(:,:,3))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,9), wf8(:,4), n3(:,17), t3x8(:,:,4))
  call vert_SA_Q(gH,ntry, ex5(:), ex4(:), wf2(:,3), n3(:,18), t3x2(:,:,2))
  call prop_A_Q(ntry, wf2(:,3), 24, MB, 1_intkind1, wf2(:,4), n2(2))
  call vert_QS_A(gH,ntry, ex3(:), wf4(:,1), wf8(:,5), n3(:,19), t3x8(:,:,5))
  call vert_QS_A(gX,ntry, ex3(:), wf4(:,4), wf8(:,6), n3(:,20), t3x8(:,:,6))
  call vert_VQ_A(ntry, wf4(:,12), ex3(:), wf8(:,7), n3(:,21), t3x8(:,:,7))
  call vert_ZQ_A(gZd,ntry, wf4(:,9), ex3(:), wf8(:,8), n3(:,22), t3x8(:,:,8))
  call vert_AQ_S(gPbt,ntry, ex4(:), ex1(:), wf4(:,13), n3(:,23), t3x4(:,:,13))
  call vert_AQ_S(gPtb,ntry, ex2(:), ex3(:), wf4(:,14), n3(:,24), t3x4(:,:,14))
  call vert_SS_S(ntry, wf4(:,13), ex5(:), wf4(:,15), n3(:,25), t3x4(:,:,15))
  call vert_QA_W(ntry, ex3(:), ex2(:), wf4(:,16), n3(:,26), t3x4(:,:,16))
  call vert_ST_V(ntry, wf4(:,13), 9, ex5(:), 16, wf4(:,17), n3(:,27), t3x4(:,:,17))
  call vert_QA_W(ntry, ex1(:), ex4(:), wf4(:,18), n3(:,28), t3x4(:,:,18))
  call vert_TV_S(ntry, ex5(:), 16, wf4(:,18), 9, wf4(:,19), n3(:,29), t3x4(:,:,19))
  call vert_SV_V(ntry, ex5(:), wf4(:,18), wf4(:,20), n3(:,30), t3x4(:,:,20))
  call vert_QS_A(gH,ntry, ex1(:), ex5(:), wf2(:,5), n3(:,31), t3x2(:,:,3))
  call prop_Q_A(ntry, wf2(:,5), 17, MT, 1_intkind1, wf2(:,6), n2(3))
  call vert_AQ_S(gPbt,ntry, ex4(:), wf2(:,6), wf4(:,21), n3(:,32), t3x4(:,:,21))
  call vert_QA_W(ntry, wf2(:,6), ex4(:), wf4(:,22), n3(:,33), t3x4(:,:,22))
  call vert_QS_A(gPbt,ntry, ex1(:), wf4(:,14), wf8(:,9), n3(:,34), t3x8(:,:,9))
  call vert_WQ_A(ntry, wf4(:,16), ex1(:), wf8(:,10), n3(:,35), t3x8(:,:,10))
  call vert_SA_Q(gH,ntry, ex5(:), ex2(:), wf2(:,7), n3(:,36), t3x2(:,:,4))
  call prop_A_Q(ntry, wf2(:,7), 18, MT, 1_intkind1, wf2(:,8), n2(4))
  call vert_QS_A(gPtb,ntry, ex3(:), wf4(:,13), wf8(:,11), n3(:,37), t3x8(:,:,11))
  call vert_WQ_A(ntry, wf4(:,18), ex3(:), wf8(:,12), n3(:,38), t3x8(:,:,12))
  call vert_SA_Q(gPtb,ntry, wf4(:,13), ex2(:), wf8(:,13), n3(:,39), t3x8(:,:,13))
  call vert_AW_Q(ntry, ex2(:), wf4(:,18), wf8(:,14), n3(:,40), t3x8(:,:,14))
  call vert_AQ_S(gH,ntry, ex2(:), wf2(:,6), wf4(:,23), n3(:,41), t3x4(:,:,23))
  call vert_AQ_S(gX,ntry, ex2(:), wf2(:,6), wf4(:,24), n3(:,42), t3x4(:,:,24))
  call vert_QA_V(ntry, ex3(:), ex4(:), wf4(:,25), n3(:,43), t3x4(:,:,25))
  call vert_QA_V(ntry, wf2(:,6), ex2(:), wf4(:,26), n3(:,44), t3x4(:,:,26))
  call vert_QA_Z(gZu,ntry, wf2(:,6), ex2(:), wf4(:,27), n3(:,45), t3x4(:,:,27))
  call vert_AQ_S(gH,ntry, wf2(:,8), ex1(:), wf4(:,28), n3(:,46), t3x4(:,:,28))
  call vert_AQ_S(gX,ntry, wf2(:,8), ex1(:), wf4(:,29), n3(:,47), t3x4(:,:,29))
  call vert_QA_V(ntry, ex1(:), wf2(:,8), wf4(:,30), n3(:,48), t3x4(:,:,30))
  call vert_QA_Z(gZu,ntry, ex1(:), wf2(:,8), wf4(:,31), n3(:,49), t3x4(:,:,31))
  call counter_SS_S(ntry, wf4(:,1), ex5(:), wf4(:,32), n3(:,50), t3x4(:,:,32))
  call counter_SS_S(ntry, wf4(:,4), ex5(:), wf4(:,33), n3(:,51), t3x4(:,:,33))
  call counter_ST_V(ntry, wf4(:,4), 3, ex5(:), 16, wf4(:,34), n3(:,52), t3x4(:,:,34))
  call counter_TV_S(ntry, ex5(:), 16, wf4(:,12), 3, wf4(:,35), n3(:,53), t3x4(:,:,35))
  call counter_TV_S(ntry, ex5(:), 16, wf4(:,9), 3, wf4(:,36), n3(:,54), t3x4(:,:,36))
  call counter_SV_V(ntry, ex5(:), wf4(:,12), wf4(:,37), n3(:,55), t3x4(:,:,37))
  call counter_SV_V(ntry, ex5(:), wf4(:,9), wf4(:,38), n3(:,56), t3x4(:,:,38))
  call counter_SA_Q(gH,ntry, wf4(:,1), ex4(:), wf8(:,15), n3(:,57), t3x8(:,:,15))
  call counter_SA_Q(EWctHbb,ntry, wf4(:,1), ex4(:), wf8(:,16), n3(:,58), t3x8(:,:,16))
  call counter_SA_Q(gX,ntry, wf4(:,4), ex4(:), wf8(:,17), n3(:,59), t3x8(:,:,17))
  call counter_SA_Q(EWctXbb,ntry, wf4(:,4), ex4(:), wf8(:,18), n3(:,60), t3x8(:,:,18))
  call counter_AV_Q(ntry, ex4(:), wf4(:,12), wf8(:,19), n3(:,61), t3x8(:,:,19))
  call counter_AV_Q_LR(EWctAbb,ntry, ex4(:), wf4(:,12), wf8(:,20), n3(:,62), t3x8(:,:,20))
  call counter_AZ_Q(gZd,ntry, ex4(:), wf4(:,9), wf8(:,21), n3(:,63), t3x8(:,:,21))
  call counter_AZ_Q(EWctVbb,ntry, ex4(:), wf4(:,9), wf8(:,22), n3(:,64), t3x8(:,:,22))
  call counter_AV_Q_LR(EWctGbb,ntry, ex4(:), wf4(:,12), wf8(:,23), n3(:,65), t3x8(:,:,23))
  call counter_SA_Q(gH,ntry, ex5(:), ex4(:), wf2(:,9), n3(:,66), t3x2(:,:,5))
  call prop_A_Q(ntry, wf2(:,9), 24, MB, 1_intkind1, wf2(:,10), n2(5))
  call counter_SA_Q(EWctHbb,ntry, ex5(:), ex4(:), wf2(:,11), n3(:,67), t3x2(:,:,6))
  call prop_A_Q(ntry, wf2(:,11), 24, MB, 1_intkind1, wf2(:,12), n2(6))
  call counter_QS_A(gH,ntry, ex3(:), wf4(:,1), wf8(:,24), n3(:,68), t3x8(:,:,24))
  call counter_QS_A(EWctHbb,ntry, ex3(:), wf4(:,1), wf8(:,25), n3(:,69), t3x8(:,:,25))
  call counter_QS_A(gX,ntry, ex3(:), wf4(:,4), wf8(:,26), n3(:,70), t3x8(:,:,26))
  call counter_QS_A(EWctXbb,ntry, ex3(:), wf4(:,4), wf8(:,27), n3(:,71), t3x8(:,:,27))
  call counter_VQ_A(ntry, wf4(:,12), ex3(:), wf8(:,28), n3(:,72), t3x8(:,:,28))
  call counter_VQ_A_LR(EWctAbb,ntry, wf4(:,12), ex3(:), wf8(:,29), n3(:,73), t3x8(:,:,29))
  call counter_ZQ_A(gZd,ntry, wf4(:,9), ex3(:), wf8(:,30), n3(:,74), t3x8(:,:,30))
  call counter_ZQ_A(EWctVbb,ntry, wf4(:,9), ex3(:), wf8(:,31), n3(:,75), t3x8(:,:,31))
  call counter_VQ_A_LR(EWctGbb,ntry, wf4(:,12), ex3(:), wf8(:,32), n3(:,76), t3x8(:,:,32))
  call counter_QS_A(gH,ntry, ex3(:), ex5(:), wf2(:,13), n3(:,77), t3x2(:,:,7))
  call prop_Q_A(ntry, wf2(:,13), 20, MB, 1_intkind1, wf2(:,14), n2(7))
  call counter_QS_A(EWctHbb,ntry, ex3(:), ex5(:), wf2(:,15), n3(:,78), t3x2(:,:,8))
  call prop_Q_A(ntry, wf2(:,15), 20, MB, 1_intkind1, wf2(:,16), n2(8))
  call counter_AQ_S(gH,ntry, ex4(:), ex3(:), wf4(:,39), n3(:,79), t3x4(:,:,39))
  call counter_AQ_S(EWctHbb,ntry, ex4(:), ex3(:), wf4(:,40), n3(:,80), t3x4(:,:,40))
  call counter_AQ_S(gX,ntry, ex4(:), ex3(:), wf4(:,41), n3(:,81), t3x4(:,:,41))
  call counter_AQ_S(EWctXbb,ntry, ex4(:), ex3(:), wf4(:,42), n3(:,82), t3x4(:,:,42))
  call counter_QA_Z(gZd,ntry, ex3(:), ex4(:), wf4(:,43), n3(:,83), t3x4(:,:,43))
  call counter_QA_Z(EWctVbb,ntry, ex3(:), ex4(:), wf4(:,44), n3(:,84), t3x4(:,:,44))
  call counter_SS_S(ntry, wf4(:,13), ex5(:), wf4(:,45), n3(:,85), t3x4(:,:,45))
  call counter_ST_V(ntry, wf4(:,13), 9, ex5(:), 16, wf4(:,46), n3(:,86), t3x4(:,:,46))
  call counter_TV_S(ntry, ex5(:), 16, wf4(:,18), 9, wf4(:,47), n3(:,87), t3x4(:,:,47))
  call counter_SV_V(ntry, ex5(:), wf4(:,18), wf4(:,48), n3(:,88), t3x4(:,:,48))
  call counter_AQ_S(ctSbt,ntry, ex4(:), wf2(:,6), wf4(:,49), n3(:,89), t3x4(:,:,49))
  call counter_AQ_S(EWctPbt,ntry, ex4(:), wf2(:,6), wf4(:,50), n3(:,90), t3x4(:,:,50))
  call counter_QA_W(ntry, wf2(:,6), ex4(:), wf4(:,51), n3(:,91), t3x4(:,:,51))
  call counter_QS_A(ctStb,ntry, ex3(:), wf4(:,13), wf8(:,33), n3(:,92), t3x8(:,:,33))
  call counter_QS_A(EWctPtb,ntry, ex3(:), wf4(:,13), wf8(:,34), n3(:,93), t3x8(:,:,34))
  call counter_WQ_A(ntry, wf4(:,18), ex3(:), wf8(:,35), n3(:,94), t3x8(:,:,35))
  call counter_QA_V(ntry, ex3(:), ex4(:), wf4(:,52), n3(:,95), t3x4(:,:,52))
  call counter_QA_V_LR(EWctAbb,ntry, ex3(:), ex4(:), wf4(:,53), n3(:,96), t3x4(:,:,53))
  call counter_QA_V_LR(EWctGbb,ntry, ex3(:), ex4(:), wf4(:,54), n3(:,97), t3x4(:,:,54))
  call counter_SA_Q(ctStb,ntry, wf4(:,13), ex2(:), wf8(:,36), n3(:,98), t3x8(:,:,36))
  call counter_SA_Q(EWctPtb,ntry, wf4(:,13), ex2(:), wf8(:,37), n3(:,99), t3x8(:,:,37))
  call counter_AW_Q(ntry, ex2(:), wf4(:,18), wf8(:,38), n3(:,100), t3x8(:,:,38))
  call counter_SA_Q(gH,ntry, ex5(:), ex2(:), wf2(:,17), n3(:,101), t3x2(:,:,9))
  call prop_A_Q(ntry, wf2(:,17), 18, MT, 1_intkind1, wf2(:,18), n2(9))
  call counter_SA_Q(EWctHtt,ntry, ex5(:), ex2(:), wf2(:,19), n3(:,102), t3x2(:,:,10))
  call prop_A_Q(ntry, wf2(:,19), 18, MT, 1_intkind1, wf2(:,20), n2(10))
  call counter_AQ_S(gH,ntry, ex2(:), wf2(:,6), wf4(:,55), n3(:,103), t3x4(:,:,55))
  call counter_AQ_S(EWctHtt,ntry, ex2(:), wf2(:,6), wf4(:,56), n3(:,104), t3x4(:,:,56))
  call counter_AQ_S(gX,ntry, ex2(:), wf2(:,6), wf4(:,57), n3(:,105), t3x4(:,:,57))
  call counter_AQ_S(EWctXtt,ntry, ex2(:), wf2(:,6), wf4(:,58), n3(:,106), t3x4(:,:,58))
  call counter_QA_V(ntry, wf2(:,6), ex2(:), wf4(:,59), n3(:,107), t3x4(:,:,59))
  call counter_QA_V_LR(EWctAtt,ntry, wf2(:,6), ex2(:), wf4(:,60), n3(:,108), t3x4(:,:,60))
  call counter_QA_Z(gZu,ntry, wf2(:,6), ex2(:), wf4(:,61), n3(:,109), t3x4(:,:,61))
  call counter_QA_Z(EWctVtt,ntry, wf2(:,6), ex2(:), wf4(:,62), n3(:,110), t3x4(:,:,62))
  call counter_QA_V_LR(EWctGtt,ntry, wf2(:,6), ex2(:), wf4(:,63), n3(:,111), t3x4(:,:,63))
  call vert_AQ_S(gH,ntry, wf2(:,18), ex1(:), wf4(:,64), n3(:,112), t3x4(:,:,64))
  call vert_AQ_S(gH,ntry, wf2(:,20), ex1(:), wf4(:,65), n3(:,113), t3x4(:,:,65))
  call vert_AQ_S(gX,ntry, wf2(:,18), ex1(:), wf4(:,66), n3(:,114), t3x4(:,:,66))
  call vert_AQ_S(gX,ntry, wf2(:,20), ex1(:), wf4(:,67), n3(:,115), t3x4(:,:,67))
  call vert_QA_V(ntry, ex1(:), wf2(:,18), wf4(:,68), n3(:,116), t3x4(:,:,68))
  call vert_QA_V(ntry, ex1(:), wf2(:,20), wf4(:,69), n3(:,117), t3x4(:,:,69))
  call vert_QA_Z(gZu,ntry, ex1(:), wf2(:,18), wf4(:,70), n3(:,118), t3x4(:,:,70))
  call vert_QA_Z(gZu,ntry, ex1(:), wf2(:,20), wf4(:,71), n3(:,119), t3x4(:,:,71))
  call counter_AQ_S(ctStb,ntry, ex2(:), ex3(:), wf4(:,72), n3(:,120), t3x4(:,:,72))
  call counter_AQ_S(EWctPtb,ntry, ex2(:), ex3(:), wf4(:,73), n3(:,121), t3x4(:,:,73))
  call counter_QA_W(ntry, ex3(:), ex2(:), wf4(:,74), n3(:,122), t3x4(:,:,74))
  call vert_QS_A(gPbt,ntry, ex1(:), wf4(:,72), wf8(:,39), n3(:,123), t3x8(:,:,39))
  call vert_QS_A(gPbt,ntry, ex1(:), wf4(:,73), wf8(:,40), n3(:,124), t3x8(:,:,40))
  call vert_WQ_A(ntry, wf4(:,74), ex1(:), wf8(:,41), n3(:,125), t3x8(:,:,41))
  call counter_QS_A(ctSbt,ntry, ex1(:), wf4(:,14), wf8(:,42), n3(:,126), t3x8(:,:,42))
  call counter_QS_A(EWctPbt,ntry, ex1(:), wf4(:,14), wf8(:,43), n3(:,127), t3x8(:,:,43))
  call counter_WQ_A(ntry, wf4(:,16), ex1(:), wf8(:,44), n3(:,128), t3x8(:,:,44))
  call counter_QS_A(gH,ntry, ex1(:), ex5(:), wf2(:,21), n3(:,129), t3x2(:,:,11))
  call prop_Q_A(ntry, wf2(:,21), 17, MT, 1_intkind1, wf2(:,22), n2(11))
  call vert_AQ_S(gPbt,ntry, ex4(:), wf2(:,22), wf4(:,75), n3(:,130), t3x4(:,:,75))
  call counter_QS_A(EWctHtt,ntry, ex1(:), ex5(:), wf2(:,23), n3(:,131), t3x2(:,:,12))
  call prop_Q_A(ntry, wf2(:,23), 17, MT, 1_intkind1, wf2(:,24), n2(12))
  call vert_AQ_S(gPbt,ntry, ex4(:), wf2(:,24), wf4(:,76), n3(:,132), t3x4(:,:,76))
  call vert_QA_W(ntry, wf2(:,22), ex4(:), wf4(:,77), n3(:,133), t3x4(:,:,77))
  call vert_QA_W(ntry, wf2(:,24), ex4(:), wf4(:,78), n3(:,134), t3x4(:,:,78))
  call counter_AQ_S(ctSbt,ntry, ex4(:), ex1(:), wf4(:,79), n3(:,135), t3x4(:,:,79))
  call vert_SS_S(ntry, wf4(:,79), ex5(:), wf4(:,80), n3(:,136), t3x4(:,:,80))
  call counter_AQ_S(EWctPbt,ntry, ex4(:), ex1(:), wf4(:,81), n3(:,137), t3x4(:,:,81))
  call vert_SS_S(ntry, wf4(:,81), ex5(:), wf4(:,82), n3(:,138), t3x4(:,:,82))
  call vert_ST_V(ntry, wf4(:,79), 9, ex5(:), 16, wf4(:,83), n3(:,139), t3x4(:,:,83))
  call vert_ST_V(ntry, wf4(:,81), 9, ex5(:), 16, wf4(:,84), n3(:,140), t3x4(:,:,84))
  call counter_QA_W(ntry, ex1(:), ex4(:), wf4(:,85), n3(:,141), t3x4(:,:,85))
  call vert_TV_S(ntry, ex5(:), 16, wf4(:,85), 9, wf4(:,86), n3(:,142), t3x4(:,:,86))
  call vert_SV_V(ntry, ex5(:), wf4(:,85), wf4(:,87), n3(:,143), t3x4(:,:,87))
  call counter_AQ_S(gH,ntry, wf2(:,8), ex1(:), wf4(:,88), n3(:,144), t3x4(:,:,88))
  call counter_AQ_S(EWctHtt,ntry, wf2(:,8), ex1(:), wf4(:,89), n3(:,145), t3x4(:,:,89))
  call counter_AQ_S(gX,ntry, wf2(:,8), ex1(:), wf4(:,90), n3(:,146), t3x4(:,:,90))
  call counter_AQ_S(EWctXtt,ntry, wf2(:,8), ex1(:), wf4(:,91), n3(:,147), t3x4(:,:,91))
  call counter_QA_V(ntry, ex1(:), wf2(:,8), wf4(:,92), n3(:,148), t3x4(:,:,92))
  call counter_QA_V_LR(EWctAtt,ntry, ex1(:), wf2(:,8), wf4(:,93), n3(:,149), t3x4(:,:,93))
  call counter_QA_Z(gZu,ntry, ex1(:), wf2(:,8), wf4(:,94), n3(:,150), t3x4(:,:,94))
  call counter_QA_Z(EWctVtt,ntry, ex1(:), wf2(:,8), wf4(:,95), n3(:,151), t3x4(:,:,95))
  call counter_QA_V_LR(EWctGtt,ntry, ex1(:), wf2(:,8), wf4(:,96), n3(:,152), t3x4(:,:,96))
  call vert_AQ_S(gH,ntry, ex2(:), wf2(:,22), wf4(:,97), n3(:,153), t3x4(:,:,97))
  call vert_AQ_S(gH,ntry, ex2(:), wf2(:,24), wf4(:,98), n3(:,154), t3x4(:,:,98))
  call vert_AQ_S(gX,ntry, ex2(:), wf2(:,22), wf4(:,99), n3(:,155), t3x4(:,:,99))
  call vert_AQ_S(gX,ntry, ex2(:), wf2(:,24), wf4(:,100), n3(:,156), t3x4(:,:,100))
  call vert_QA_V(ntry, wf2(:,22), ex2(:), wf4(:,101), n3(:,157), t3x4(:,:,101))
  call vert_QA_V(ntry, wf2(:,24), ex2(:), wf4(:,102), n3(:,158), t3x4(:,:,102))
  call vert_QA_Z(gZu,ntry, wf2(:,22), ex2(:), wf4(:,103), n3(:,159), t3x4(:,:,103))
  call vert_QA_Z(gZu,ntry, wf2(:,24), ex2(:), wf4(:,104), n3(:,160), t3x4(:,:,104))
  call vert_QS_A(gPtb,ntry, ex3(:), wf4(:,79), wf8(:,45), n3(:,161), t3x8(:,:,45))
  call vert_QS_A(gPtb,ntry, ex3(:), wf4(:,81), wf8(:,46), n3(:,162), t3x8(:,:,46))
  call vert_WQ_A(ntry, wf4(:,85), ex3(:), wf8(:,47), n3(:,163), t3x8(:,:,47))
  call vert_SA_Q(gPtb,ntry, wf4(:,79), ex2(:), wf8(:,48), n3(:,164), t3x8(:,:,48))
  call vert_SA_Q(gPtb,ntry, wf4(:,81), ex2(:), wf8(:,49), n3(:,165), t3x8(:,:,49))
  call vert_AW_Q(ntry, ex2(:), wf4(:,85), wf8(:,50), n3(:,166), t3x8(:,:,50))
  call counter_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,105), n3(:,167), t3x4(:,:,105))
  call vert_SS_S(ntry, wf4(:,105), ex5(:), wf4(:,106), n3(:,168), t3x4(:,:,106))
  call counter_AQ_S(EWctHtt,ntry, ex2(:), ex1(:), wf4(:,107), n3(:,169), t3x4(:,:,107))
  call vert_SS_S(ntry, wf4(:,107), ex5(:), wf4(:,108), n3(:,170), t3x4(:,:,108))
  call counter_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,109), n3(:,171), t3x4(:,:,109))
  call vert_SS_S(ntry, wf4(:,109), ex5(:), wf4(:,110), n3(:,172), t3x4(:,:,110))
  call counter_AQ_S(EWctXtt,ntry, ex2(:), ex1(:), wf4(:,111), n3(:,173), t3x4(:,:,111))
  call vert_SS_S(ntry, wf4(:,111), ex5(:), wf4(:,112), n3(:,174), t3x4(:,:,112))
  call vert_ST_V(ntry, wf4(:,109), 3, ex5(:), 16, wf4(:,113), n3(:,175), t3x4(:,:,113))
  call vert_ST_V(ntry, wf4(:,111), 3, ex5(:), 16, wf4(:,114), n3(:,176), t3x4(:,:,114))
  call counter_QA_Z(gZu,ntry, ex1(:), ex2(:), wf4(:,115), n3(:,177), t3x4(:,:,115))
  call vert_TV_S(ntry, ex5(:), 16, wf4(:,115), 3, wf4(:,116), n3(:,178), t3x4(:,:,116))
  call counter_QA_Z(EWctVtt,ntry, ex1(:), ex2(:), wf4(:,117), n3(:,179), t3x4(:,:,117))
  call vert_TV_S(ntry, ex5(:), 16, wf4(:,117), 3, wf4(:,118), n3(:,180), t3x4(:,:,118))
  call vert_SV_V(ntry, ex5(:), wf4(:,115), wf4(:,119), n3(:,181), t3x4(:,:,119))
  call vert_SV_V(ntry, ex5(:), wf4(:,117), wf4(:,120), n3(:,182), t3x4(:,:,120))
  call vert_SA_Q(gH,ntry, wf4(:,105), ex4(:), wf8(:,51), n3(:,183), t3x8(:,:,51))
  call vert_SA_Q(gH,ntry, wf4(:,107), ex4(:), wf8(:,52), n3(:,184), t3x8(:,:,52))
  call vert_SA_Q(gX,ntry, wf4(:,109), ex4(:), wf8(:,53), n3(:,185), t3x8(:,:,53))
  call vert_SA_Q(gX,ntry, wf4(:,111), ex4(:), wf8(:,54), n3(:,186), t3x8(:,:,54))
  call counter_QA_V(ntry, ex1(:), ex2(:), wf4(:,121), n3(:,187), t3x4(:,:,121))
  call vert_AV_Q(ntry, ex4(:), wf4(:,121), wf8(:,55), n3(:,188), t3x8(:,:,55))
  call counter_QA_V_LR(EWctAtt,ntry, ex1(:), ex2(:), wf4(:,122), n3(:,189), t3x4(:,:,122))
  call vert_AV_Q(ntry, ex4(:), wf4(:,122), wf8(:,56), n3(:,190), t3x8(:,:,56))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,115), wf8(:,57), n3(:,191), t3x8(:,:,57))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,117), wf8(:,58), n3(:,192), t3x8(:,:,58))
  call counter_QA_V_LR(EWctGtt,ntry, ex1(:), ex2(:), wf4(:,123), n3(:,193), t3x4(:,:,123))
  call vert_AV_Q(ntry, ex4(:), wf4(:,123), wf8(:,59), n3(:,194), t3x8(:,:,59))
  call vert_QS_A(gH,ntry, ex3(:), wf4(:,105), wf8(:,60), n3(:,195), t3x8(:,:,60))
  call vert_QS_A(gH,ntry, ex3(:), wf4(:,107), wf8(:,61), n3(:,196), t3x8(:,:,61))
  call vert_QS_A(gX,ntry, ex3(:), wf4(:,109), wf8(:,62), n3(:,197), t3x8(:,:,62))
  call vert_QS_A(gX,ntry, ex3(:), wf4(:,111), wf8(:,63), n3(:,198), t3x8(:,:,63))
  call vert_VQ_A(ntry, wf4(:,121), ex3(:), wf8(:,64), n3(:,199), t3x8(:,:,64))
  call vert_VQ_A(ntry, wf4(:,122), ex3(:), wf8(:,65), n3(:,200), t3x8(:,:,65))
  call vert_ZQ_A(gZd,ntry, wf4(:,115), ex3(:), wf8(:,66), n3(:,201), t3x8(:,:,66))
  call vert_ZQ_A(gZd,ntry, wf4(:,117), ex3(:), wf8(:,67), n3(:,202), t3x8(:,:,67))
  call vert_VQ_A(ntry, wf4(:,123), ex3(:), wf8(:,68), n3(:,203), t3x8(:,:,68))
  call vert_SS_S(ntry, wf4(:,2), ex5(:), wf4(:,124), n3(:,204), t3x4(:,:,124))
  call counter_S_S(EWctHH,ntry, wf4(:,1), 3, wf4(:,125), n2(13))
  call vert_SS_S(ntry, wf4(:,5), ex5(:), wf4(:,126), n3(:,205), t3x4(:,:,125))
  call counter_S_S(EWctXX,ntry, wf4(:,4), 3, wf4(:,127), n2(14))
  call vert_TV_S(ntry, ex5(:), 16, wf4(:,7), 12, wf4(:,128), n3(:,206), t3x4(:,:,126))
  call vert_ST_V(ntry, wf4(:,5), 12, ex5(:), 16, wf4(:,129), n3(:,207), t3x4(:,:,127))
  call counter_S_V(EWctXZ,ntry, wf4(:,4), 3, wf4(:,130), n2(15))
  call vert_SV_V(ntry, ex5(:), wf4(:,7), wf4(:,131), n3(:,208), t3x4(:,:,128))
  call counter_V_S(EWctXA,ntry, wf4(:,12), 3, wf4(:,132), n2(16))
  call counter_V_S(EWctXZ,ntry, wf4(:,9), 3, wf4(:,133), n2(17))
  call counter_V_V(EWctAZ,ntry, wf4(:,12), 3, wf4(:,134), n2(18))
  call counter_V_V(EWctZZ,ntry, wf4(:,9), 3, wf4(:,135), n2(19))
  call counter_S_S(EWctHH,ntry, wf4(:,2), 12, wf4(:,136), n2(20))
  call counter_S_S(EWctXX,ntry, wf4(:,5), 12, wf4(:,137), n2(21))
  call counter_S_V(EWctXZ,ntry, wf4(:,5), 12, wf4(:,138), n2(22))
  call counter_V_S(EWctXA,ntry, wf4(:,25), 12, wf4(:,139), n2(23))
  call counter_V_S(EWctXZ,ntry, wf4(:,7), 12, wf4(:,140), n2(24))
  call counter_V_V(EWctAZ,ntry, wf4(:,25), 12, wf4(:,141), n2(25))
  call counter_V_V(EWctZZ,ntry, wf4(:,7), 12, wf4(:,142), n2(26))
  call vert_AQ_S(gH,ntry, ex4(:), wf2(:,2), wf4(:,143), n3(:,209), t3x4(:,:,129))
  call vert_AQ_S(gX,ntry, ex4(:), wf2(:,2), wf4(:,144), n3(:,210), t3x4(:,:,130))
  call vert_QA_V(ntry, wf2(:,2), ex4(:), wf4(:,145), n3(:,211), t3x4(:,:,131))
  call counter_S_V(EWctXA,ntry, wf4(:,4), 3, wf4(:,146), n2(27))
  call vert_QA_Z(gZd,ntry, wf2(:,2), ex4(:), wf4(:,147), n3(:,212), t3x4(:,:,132))
  call counter_V_V(EWctAA,ntry, wf4(:,12), 3, wf4(:,148), n2(28))
  call counter_V_V(EWctAZ,ntry, wf4(:,9), 3, wf4(:,149), n2(29))
  call counter_Q_A(ctbb,5,ntry, wf2(:,2), 20, wf2(:,25), n2(30))
  call prop_A_Q(ntry, wf8(:,1), 11, MB, 1_intkind1, wf8(:,69), n2(31))
  call counter_Q_A_LR(EWctbb,ntry, wf2(:,2), 20, wf2(:,26), n2(32))
  call prop_A_Q(ntry, wf8(:,2), 11, MB, 1_intkind1, wf8(:,70), n2(33))
  call prop_A_Q(ntry, wf8(:,3), 11, MB, 1_intkind1, wf8(:,71), n2(34))
  call prop_A_Q(ntry, wf8(:,4), 11, MB, 1_intkind1, wf8(:,72), n2(35))
  call vert_AQ_S(gH,ntry, wf2(:,4), ex3(:), wf4(:,150), n3(:,213), t3x4(:,:,133))
  call vert_AQ_S(gX,ntry, wf2(:,4), ex3(:), wf4(:,151), n3(:,214), t3x4(:,:,134))
  call vert_QA_V(ntry, ex3(:), wf2(:,4), wf4(:,152), n3(:,215), t3x4(:,:,135))
  call vert_QA_Z(gZd,ntry, ex3(:), wf2(:,4), wf4(:,153), n3(:,216), t3x4(:,:,136))
  call counter_A_Q(ctbb,5,ntry, wf2(:,4), 24, wf2(:,27), n2(36))
  call prop_Q_A(ntry, wf8(:,5), 7, MB, 1_intkind1, wf8(:,73), n2(37))
  call counter_A_Q_LR(EWctbb,ntry, wf2(:,4), 24, wf2(:,28), n2(38))
  call prop_Q_A(ntry, wf8(:,6), 7, MB, 1_intkind1, wf8(:,74), n2(39))
  call prop_Q_A(ntry, wf8(:,7), 7, MB, 1_intkind1, wf8(:,75), n2(40))
  call prop_Q_A(ntry, wf8(:,8), 7, MB, 1_intkind1, wf8(:,76), n2(41))
  call vert_SS_S(ntry, wf4(:,14), ex5(:), wf4(:,154), n3(:,217), t3x4(:,:,137))
  call counter_S_S(EWctPP,ntry, wf4(:,13), 9, wf4(:,155), n2(42))
  call vert_TV_S(ntry, ex5(:), 16, wf4(:,16), 6, wf4(:,156), n3(:,218), t3x4(:,:,138))
  call vert_ST_V(ntry, wf4(:,14), 6, ex5(:), 16, wf4(:,157), n3(:,219), t3x4(:,:,139))
  call counter_S_V(EWctPW,ntry, wf4(:,13), 9, wf4(:,158), n2(43))
  call vert_SV_V(ntry, ex5(:), wf4(:,16), wf4(:,159), n3(:,220), t3x4(:,:,140))
  call counter_V_S(EWctPW,ntry, wf4(:,18), 9, wf4(:,160), n2(44))
  call counter_V_V(EWctWW,ntry, wf4(:,18), 9, wf4(:,161), n2(45))
  call counter_S_S(EWctPP,ntry, wf4(:,14), 6, wf4(:,162), n2(46))
  call counter_S_V(EWctPW,ntry, wf4(:,14), 6, wf4(:,163), n2(47))
  call counter_V_S(EWctPW,ntry, wf4(:,16), 6, wf4(:,164), n2(48))
  call counter_V_V(EWctWW,ntry, wf4(:,16), 6, wf4(:,165), n2(49))
  call vert_SA_Q(gPbt,ntry, wf4(:,14), ex4(:), wf8(:,77), n3(:,221), t3x8(:,:,69))
  call counter_Q_A(cttt,6,ntry, wf2(:,6), 17, wf2(:,29), n2(50))
  call prop_A_Q(ntry, wf8(:,77), 14, MT, 1_intkind1, wf8(:,78), n2(51))
  call counter_Q_A_LR(EWcttt,ntry, wf2(:,6), 17, wf2(:,30), n2(52))
  call vert_AW_Q(ntry, ex4(:), wf4(:,16), wf8(:,79), n3(:,222), t3x8(:,:,70))
  call prop_A_Q(ntry, wf8(:,79), 14, MT, 1_intkind1, wf8(:,80), n2(53))
  call vert_AQ_S(gPbt,ntry, wf2(:,4), ex1(:), wf4(:,166), n3(:,223), t3x4(:,:,141))
  call vert_QA_W(ntry, ex1(:), wf2(:,4), wf4(:,167), n3(:,224), t3x4(:,:,142))
  call prop_Q_A(ntry, wf8(:,9), 7, MB, 1_intkind1, wf8(:,81), n2(54))
  call prop_Q_A(ntry, wf8(:,10), 7, MB, 1_intkind1, wf8(:,82), n2(55))
  call vert_AQ_S(gPtb,ntry, wf2(:,8), ex3(:), wf4(:,168), n3(:,225), t3x4(:,:,143))
  call vert_QA_W(ntry, ex3(:), wf2(:,8), wf4(:,169), n3(:,226), t3x4(:,:,144))
  call counter_A_Q(cttt,6,ntry, wf2(:,8), 18, wf2(:,31), n2(56))
  call prop_Q_A(ntry, wf8(:,11), 13, MT, 1_intkind1, wf8(:,83), n2(57))
  call counter_A_Q_LR(EWcttt,ntry, wf2(:,8), 18, wf2(:,32), n2(58))
  call prop_Q_A(ntry, wf8(:,12), 13, MT, 1_intkind1, wf8(:,84), n2(59))
  call vert_AQ_S(gPtb,ntry, ex2(:), wf2(:,2), wf4(:,170), n3(:,227), t3x4(:,:,145))
  call vert_QA_W(ntry, wf2(:,2), ex2(:), wf4(:,171), n3(:,228), t3x4(:,:,146))
  call prop_A_Q(ntry, wf8(:,13), 11, MB, 1_intkind1, wf8(:,85), n2(60))
  call prop_A_Q(ntry, wf8(:,14), 11, MB, 1_intkind1, wf8(:,86), n2(61))
  call vert_SA_Q(gH,ntry, wf4(:,2), ex2(:), wf8(:,87), n3(:,229), t3x8(:,:,71))
  call prop_A_Q(ntry, wf8(:,87), 14, MT, 1_intkind1, wf8(:,88), n2(62))
  call vert_SA_Q(gX,ntry, wf4(:,5), ex2(:), wf8(:,89), n3(:,230), t3x8(:,:,72))
  call prop_A_Q(ntry, wf8(:,89), 14, MT, 1_intkind1, wf8(:,90), n2(63))
  call vert_AV_Q(ntry, ex2(:), wf4(:,25), wf8(:,91), n3(:,231), t3x8(:,:,73))
  call prop_A_Q(ntry, wf8(:,91), 14, MT, 1_intkind1, wf8(:,92), n2(64))
  call vert_AZ_Q(gZu,ntry, ex2(:), wf4(:,7), wf8(:,93), n3(:,232), t3x8(:,:,74))
  call prop_A_Q(ntry, wf8(:,93), 14, MT, 1_intkind1, wf8(:,94), n2(65))
  call counter_S_V(EWctXA,ntry, wf4(:,5), 12, wf4(:,172), n2(66))
  call counter_V_V(EWctAA,ntry, wf4(:,25), 12, wf4(:,173), n2(67))
  call counter_V_V(EWctAZ,ntry, wf4(:,7), 12, wf4(:,174), n2(68))
  call vert_QS_A(gH,ntry, ex1(:), wf4(:,2), wf8(:,95), n3(:,233), t3x8(:,:,75))
  call prop_Q_A(ntry, wf8(:,95), 13, MT, 1_intkind1, wf8(:,96), n2(69))
  call vert_QS_A(gX,ntry, ex1(:), wf4(:,5), wf8(:,97), n3(:,234), t3x8(:,:,76))
  call prop_Q_A(ntry, wf8(:,97), 13, MT, 1_intkind1, wf8(:,98), n2(70))
  call vert_VQ_A(ntry, wf4(:,25), ex1(:), wf8(:,99), n3(:,235), t3x8(:,:,77))
  call prop_Q_A(ntry, wf8(:,99), 13, MT, 1_intkind1, wf8(:,100), n2(71))
  call vert_ZQ_A(gZu,ntry, wf4(:,7), ex1(:), wf8(:,101), n3(:,236), t3x8(:,:,78))
  call prop_Q_A(ntry, wf8(:,101), 13, MT, 1_intkind1, wf8(:,102), n2(72))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    if (do_ct) call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  if (do_ct) M2ct = 0
  if (do_colint) M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    if (do_ct) call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      if (do_colint) call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    if (do_ct) M2ct = M2ct + M2add_ct
    if (do_colint) M2colint = M2colint + M2add_colint
  end do

#if 1 > 0 && 5 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    ind_cc_comb = [2,4,7,5,8]
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 5
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 1
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_SS(nsync, wf4(:,2), wf4(:,3), A(:,1), n3(:,237), t3x16(:,:,1), nhel, den(3))
    call Hcont_SS(nsync, wf4(:,5), wf4(:,6), A(:,2), n3(:,238), t3x16(:,:,2), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,8), A(:,3), n3(:,239), t3x16(:,:,3), nhel, den(6))
    call Hcont_SS(nsync, wf4(:,5), wf4(:,10), A(:,4), n3(:,240), t3x16(:,:,4), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,11), A(:,5), n3(:,241), t3x16(:,:,5), nhel, den(6))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,1), A(:,6), n3(:,242), t3x16(:,:,6), nhel, den(8))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,2), A(:,7), n3(:,243), t3x16(:,:,7), nhel, den(9))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,3), A(:,8), n3(:,244), t3x16(:,:,8), nhel, den(11))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,4), A(:,9), n3(:,245), t3x16(:,:,9), nhel, den(9))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,3), A(:,10), n3(:,246), t3x16(:,:,10), nhel, den(11))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,5), A(:,11), n3(:,247), t3x16(:,:,11), nhel, den(13))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,6), A(:,12), n3(:,248), t3x16(:,:,12), nhel, den(14))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,7), A(:,13), n3(:,249), t3x16(:,:,13), nhel, den(15))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,8), A(:,14), n3(:,250), t3x16(:,:,14), nhel, den(14))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,7), A(:,15), n3(:,251), t3x16(:,:,15), nhel, den(15))
    call Hcont_SS(nsync, wf4(:,14), wf4(:,15), A(:,16), n3(:,252), t3x16(:,:,16), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,16), wf4(:,17), A(:,17), n3(:,253), t3x16(:,:,17), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,14), wf4(:,19), A(:,18), n3(:,254), t3x16(:,:,18), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,16), wf4(:,20), A(:,19), n3(:,255), t3x16(:,:,19), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,14), wf4(:,21), A(:,20), n3(:,256), t3x16(:,:,20), nhel, den(20))
    call Hcont_VV(nsync, wf4(:,16), wf4(:,22), A(:,21), n3(:,257), t3x16(:,:,21), nhel, den(20))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,9), A(:,22), n3(:,258), t3x16(:,:,22), nhel, den(21))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,10), A(:,23), n3(:,259), t3x16(:,:,23), nhel, den(21))
    call Hcont_QA(nsync, wf2(:,8), wf8(:,11), A(:,24), n3(:,260), t3x16(:,:,24), nhel, den(23))
    call Hcont_QA(nsync, wf2(:,8), wf8(:,12), A(:,25), n3(:,261), t3x16(:,:,25), nhel, den(23))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,13), A(:,26), n3(:,262), t3x16(:,:,26), nhel, den(24))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,14), A(:,27), n3(:,263), t3x16(:,:,27), nhel, den(24))
    call Hcont_SS(nsync, wf4(:,2), wf4(:,23), A(:,28), n3(:,264), t3x16(:,:,28), nhel, den(25))
    call Hcont_SS(nsync, wf4(:,5), wf4(:,24), A(:,29), n3(:,265), t3x16(:,:,29), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,26), A(:,30), n3(:,266), t3x16(:,:,30), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,27), A(:,31), n3(:,267), t3x16(:,:,31), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,26), A(:,32), n3(:,268), t3x16(:,:,32), nhel, den(28))
    call Hcont_SS(nsync, wf4(:,2), wf4(:,28), A(:,33), n3(:,269), t3x16(:,:,33), nhel, den(29))
    call Hcont_SS(nsync, wf4(:,5), wf4(:,29), A(:,34), n3(:,270), t3x16(:,:,34), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,30), A(:,35), n3(:,271), t3x16(:,:,35), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,31), A(:,36), n3(:,272), t3x16(:,:,36), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,30), A(:,37), n3(:,273), t3x16(:,:,37), nhel, den(31))

    call Hcont_SS(nsync, wf4(:,2), wf4(:,32), A(:,38), n3(:,274), t3x16(:,:,38), nhel, den(3))
    call Hcont_SS(nsync, wf4(:,5), wf4(:,33), A(:,39), n3(:,275), t3x16(:,:,39), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,34), A(:,40), n3(:,276), t3x16(:,:,40), nhel, den(32))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,34), A(:,41), n3(:,277), t3x16(:,:,41), nhel, den(6))
    call Hcont_SS(nsync, wf4(:,5), wf4(:,35), A(:,42), n3(:,278), t3x16(:,:,42), nhel, den(33))
    call Hcont_SS(nsync, wf4(:,5), wf4(:,36), A(:,43), n3(:,279), t3x16(:,:,43), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,37), A(:,44), n3(:,280), t3x16(:,:,44), nhel, den(34))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,37), A(:,45), n3(:,281), t3x16(:,:,45), nhel, den(33))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,38), A(:,46), n3(:,282), t3x16(:,:,46), nhel, den(32))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,38), A(:,47), n3(:,283), t3x16(:,:,47), nhel, den(6))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,15), A(:,48), n3(:,284), t3x16(:,:,48), nhel, den(8))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,16), A(:,49), n3(:,285), t3x16(:,:,49), nhel, den(8))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,17), A(:,50), n3(:,286), t3x16(:,:,50), nhel, den(9))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,18), A(:,51), n3(:,287), t3x16(:,:,51), nhel, den(9))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,19), A(:,52), n3(:,288), t3x16(:,:,52), nhel, den(11))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,20), A(:,53), n3(:,289), t3x16(:,:,53), nhel, den(11))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,21), A(:,54), n3(:,290), t3x16(:,:,54), nhel, den(9))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,22), A(:,55), n3(:,291), t3x16(:,:,55), nhel, den(9))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,23), A(:,56), n3(:,292), t3x16(:,:,56), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,5), wf2(:,10), A(:,57), n3(:,293), t3x16(:,:,57), nhel, den(13))
    call Hcont_QA(nsync, wf8(:,5), wf2(:,12), A(:,58), n3(:,294), t3x16(:,:,58), nhel, den(13))
    call Hcont_QA(nsync, wf8(:,6), wf2(:,10), A(:,59), n3(:,295), t3x16(:,:,59), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,6), wf2(:,12), A(:,60), n3(:,296), t3x16(:,:,60), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,7), wf2(:,10), A(:,61), n3(:,297), t3x16(:,:,61), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,7), wf2(:,12), A(:,62), n3(:,298), t3x16(:,:,62), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,8), wf2(:,10), A(:,63), n3(:,299), t3x16(:,:,63), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,8), wf2(:,12), A(:,64), n3(:,300), t3x16(:,:,64), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,7), wf2(:,12), A(:,65), n3(:,301), t3x16(:,:,65), nhel, den(15))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,24), A(:,66), n3(:,302), t3x16(:,:,66), nhel, den(13))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,25), A(:,67), n3(:,303), t3x16(:,:,67), nhel, den(13))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,26), A(:,68), n3(:,304), t3x16(:,:,68), nhel, den(14))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,27), A(:,69), n3(:,305), t3x16(:,:,69), nhel, den(14))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,28), A(:,70), n3(:,306), t3x16(:,:,70), nhel, den(15))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,29), A(:,71), n3(:,307), t3x16(:,:,71), nhel, den(15))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,30), A(:,72), n3(:,308), t3x16(:,:,72), nhel, den(14))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,31), A(:,73), n3(:,309), t3x16(:,:,73), nhel, den(14))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,32), A(:,74), n3(:,310), t3x16(:,:,74), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,1), wf2(:,14), A(:,75), n3(:,311), t3x16(:,:,75), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,1), wf2(:,16), A(:,76), n3(:,312), t3x16(:,:,76), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,2), wf2(:,14), A(:,77), n3(:,313), t3x16(:,:,77), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,2), wf2(:,16), A(:,78), n3(:,314), t3x16(:,:,78), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,3), wf2(:,14), A(:,79), n3(:,315), t3x16(:,:,79), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,3), wf2(:,16), A(:,80), n3(:,316), t3x16(:,:,80), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,4), wf2(:,14), A(:,81), n3(:,317), t3x16(:,:,81), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,4), wf2(:,16), A(:,82), n3(:,318), t3x16(:,:,82), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,3), wf2(:,16), A(:,83), n3(:,319), t3x16(:,:,83), nhel, den(11))
    call Hcont_SS(nsync, wf4(:,3), wf4(:,39), A(:,84), n3(:,320), t3x16(:,:,84), nhel, den(3))
    call Hcont_SS(nsync, wf4(:,3), wf4(:,40), A(:,85), n3(:,321), t3x16(:,:,85), nhel, den(3))
    call Hcont_SS(nsync, wf4(:,6), wf4(:,41), A(:,86), n3(:,322), t3x16(:,:,86), nhel, den(6))
    call Hcont_SS(nsync, wf4(:,6), wf4(:,42), A(:,87), n3(:,323), t3x16(:,:,87), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,8), wf4(:,43), A(:,88), n3(:,324), t3x16(:,:,88), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,8), wf4(:,44), A(:,89), n3(:,325), t3x16(:,:,89), nhel, den(6))
    call Hcont_SS(nsync, wf4(:,10), wf4(:,41), A(:,90), n3(:,326), t3x16(:,:,90), nhel, den(6))
    call Hcont_SS(nsync, wf4(:,10), wf4(:,42), A(:,91), n3(:,327), t3x16(:,:,91), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,11), wf4(:,43), A(:,92), n3(:,328), t3x16(:,:,92), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,11), wf4(:,44), A(:,93), n3(:,329), t3x16(:,:,93), nhel, den(6))
    call Hcont_SS(nsync, wf4(:,14), wf4(:,45), A(:,94), n3(:,330), t3x16(:,:,94), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,16), wf4(:,46), A(:,95), n3(:,331), t3x16(:,:,95), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,14), wf4(:,47), A(:,96), n3(:,332), t3x16(:,:,96), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,16), wf4(:,48), A(:,97), n3(:,333), t3x16(:,:,97), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,14), wf4(:,49), A(:,98), n3(:,334), t3x16(:,:,98), nhel, den(20))
    call Hcont_SS(nsync, wf4(:,14), wf4(:,50), A(:,99), n3(:,335), t3x16(:,:,99), nhel, den(20))
    call Hcont_VV(nsync, wf4(:,16), wf4(:,51), A(:,100), n3(:,336), t3x16(:,:,100), nhel, den(20))
    call Hcont_VV(nsync, wf4(:,16), wf4(:,51), A(:,101), n3(:,337), t3x16(:,:,101), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,9), wf2(:,10), A(:,102), n3(:,338), t3x16(:,:,102), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,9), wf2(:,12), A(:,103), n3(:,339), t3x16(:,:,103), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,10), wf2(:,10), A(:,104), n3(:,340), t3x16(:,:,104), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,10), wf2(:,12), A(:,105), n3(:,341), t3x16(:,:,105), nhel, den(21))
    call Hcont_QA(nsync, wf2(:,8), wf8(:,33), A(:,106), n3(:,342), t3x16(:,:,106), nhel, den(23))
    call Hcont_QA(nsync, wf2(:,8), wf8(:,34), A(:,107), n3(:,343), t3x16(:,:,107), nhel, den(23))
    call Hcont_QA(nsync, wf2(:,8), wf8(:,35), A(:,108), n3(:,344), t3x16(:,:,108), nhel, den(23))
    call Hcont_QA(nsync, wf2(:,8), wf8(:,35), A(:,109), n3(:,345), t3x16(:,:,109), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,13), wf2(:,14), A(:,110), n3(:,346), t3x16(:,:,110), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,13), wf2(:,16), A(:,111), n3(:,347), t3x16(:,:,111), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,14), wf2(:,14), A(:,112), n3(:,348), t3x16(:,:,112), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,14), wf2(:,16), A(:,113), n3(:,349), t3x16(:,:,113), nhel, den(24))
    call Hcont_SS(nsync, wf4(:,23), wf4(:,39), A(:,114), n3(:,350), t3x16(:,:,114), nhel, den(25))
    call Hcont_SS(nsync, wf4(:,23), wf4(:,40), A(:,115), n3(:,351), t3x16(:,:,115), nhel, den(25))
    call Hcont_SS(nsync, wf4(:,24), wf4(:,41), A(:,116), n3(:,352), t3x16(:,:,116), nhel, den(26))
    call Hcont_SS(nsync, wf4(:,24), wf4(:,42), A(:,117), n3(:,353), t3x16(:,:,117), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,26), wf4(:,52), A(:,118), n3(:,354), t3x16(:,:,118), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,26), wf4(:,53), A(:,119), n3(:,355), t3x16(:,:,119), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,27), wf4(:,43), A(:,120), n3(:,356), t3x16(:,:,120), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,27), wf4(:,44), A(:,121), n3(:,357), t3x16(:,:,121), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,26), wf4(:,54), A(:,122), n3(:,358), t3x16(:,:,122), nhel, den(28))
    call Hcont_SS(nsync, wf4(:,28), wf4(:,39), A(:,123), n3(:,359), t3x16(:,:,123), nhel, den(29))
    call Hcont_SS(nsync, wf4(:,28), wf4(:,40), A(:,124), n3(:,360), t3x16(:,:,124), nhel, den(29))
    call Hcont_SS(nsync, wf4(:,29), wf4(:,41), A(:,125), n3(:,361), t3x16(:,:,125), nhel, den(30))
    call Hcont_SS(nsync, wf4(:,29), wf4(:,42), A(:,126), n3(:,362), t3x16(:,:,126), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,30), wf4(:,52), A(:,127), n3(:,363), t3x16(:,:,127), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,30), wf4(:,53), A(:,128), n3(:,364), t3x16(:,:,128), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,31), wf4(:,43), A(:,129), n3(:,365), t3x16(:,:,129), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,31), wf4(:,44), A(:,130), n3(:,366), t3x16(:,:,130), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,30), wf4(:,54), A(:,131), n3(:,367), t3x16(:,:,131), nhel, den(31))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,36), A(:,132), n3(:,368), t3x16(:,:,132), nhel, den(24))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,37), A(:,133), n3(:,369), t3x16(:,:,133), nhel, den(24))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,38), A(:,134), n3(:,370), t3x16(:,:,134), nhel, den(24))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,38), A(:,135), n3(:,371), t3x16(:,:,135), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,11), wf2(:,18), A(:,136), n3(:,372), t3x16(:,:,136), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,11), wf2(:,20), A(:,137), n3(:,373), t3x16(:,:,137), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,12), wf2(:,18), A(:,138), n3(:,374), t3x16(:,:,138), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,12), wf2(:,20), A(:,139), n3(:,375), t3x16(:,:,139), nhel, den(23))
    call Hcont_SS(nsync, wf4(:,2), wf4(:,55), A(:,140), n3(:,376), t3x16(:,:,140), nhel, den(25))
    call Hcont_SS(nsync, wf4(:,2), wf4(:,56), A(:,141), n3(:,377), t3x16(:,:,141), nhel, den(25))
    call Hcont_SS(nsync, wf4(:,5), wf4(:,57), A(:,142), n3(:,378), t3x16(:,:,142), nhel, den(26))
    call Hcont_SS(nsync, wf4(:,5), wf4(:,58), A(:,143), n3(:,379), t3x16(:,:,143), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,59), A(:,144), n3(:,380), t3x16(:,:,144), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,60), A(:,145), n3(:,381), t3x16(:,:,145), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,61), A(:,146), n3(:,382), t3x16(:,:,146), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,62), A(:,147), n3(:,383), t3x16(:,:,147), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,63), A(:,148), n3(:,384), t3x16(:,:,148), nhel, den(28))
    call Hcont_SS(nsync, wf4(:,2), wf4(:,64), A(:,149), n3(:,385), t3x16(:,:,149), nhel, den(29))
    call Hcont_SS(nsync, wf4(:,2), wf4(:,65), A(:,150), n3(:,386), t3x16(:,:,150), nhel, den(29))
    call Hcont_SS(nsync, wf4(:,5), wf4(:,66), A(:,151), n3(:,387), t3x16(:,:,151), nhel, den(30))
    call Hcont_SS(nsync, wf4(:,5), wf4(:,67), A(:,152), n3(:,388), t3x16(:,:,152), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,68), A(:,153), n3(:,389), t3x16(:,:,153), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,69), A(:,154), n3(:,390), t3x16(:,:,154), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,70), A(:,155), n3(:,391), t3x16(:,:,155), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,71), A(:,156), n3(:,392), t3x16(:,:,156), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,69), A(:,157), n3(:,393), t3x16(:,:,157), nhel, den(31))
    call Hcont_SS(nsync, wf4(:,15), wf4(:,72), A(:,158), n3(:,394), t3x16(:,:,158), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,15), wf4(:,73), A(:,159), n3(:,395), t3x16(:,:,159), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,17), wf4(:,74), A(:,160), n3(:,396), t3x16(:,:,160), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,17), wf4(:,74), A(:,161), n3(:,397), t3x16(:,:,161), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,19), wf4(:,72), A(:,162), n3(:,398), t3x16(:,:,162), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,19), wf4(:,73), A(:,163), n3(:,399), t3x16(:,:,163), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,20), wf4(:,74), A(:,164), n3(:,400), t3x16(:,:,164), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,20), wf4(:,74), A(:,165), n3(:,401), t3x16(:,:,165), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,21), wf4(:,72), A(:,166), n3(:,402), t3x16(:,:,166), nhel, den(20))
    call Hcont_SS(nsync, wf4(:,21), wf4(:,73), A(:,167), n3(:,403), t3x16(:,:,167), nhel, den(20))
    call Hcont_VV(nsync, wf4(:,22), wf4(:,74), A(:,168), n3(:,404), t3x16(:,:,168), nhel, den(20))
    call Hcont_VV(nsync, wf4(:,22), wf4(:,74), A(:,169), n3(:,405), t3x16(:,:,169), nhel, den(20))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,39), A(:,170), n3(:,406), t3x16(:,:,170), nhel, den(21))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,40), A(:,171), n3(:,407), t3x16(:,:,171), nhel, den(21))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,41), A(:,172), n3(:,408), t3x16(:,:,172), nhel, den(21))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,41), A(:,173), n3(:,409), t3x16(:,:,173), nhel, den(21))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,42), A(:,174), n3(:,410), t3x16(:,:,174), nhel, den(21))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,43), A(:,175), n3(:,411), t3x16(:,:,175), nhel, den(21))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,44), A(:,176), n3(:,412), t3x16(:,:,176), nhel, den(21))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,44), A(:,177), n3(:,413), t3x16(:,:,177), nhel, den(21))
    call Hcont_SS(nsync, wf4(:,14), wf4(:,75), A(:,178), n3(:,414), t3x16(:,:,178), nhel, den(20))
    call Hcont_SS(nsync, wf4(:,14), wf4(:,76), A(:,179), n3(:,415), t3x16(:,:,179), nhel, den(20))
    call Hcont_VV(nsync, wf4(:,16), wf4(:,77), A(:,180), n3(:,416), t3x16(:,:,180), nhel, den(20))
    call Hcont_VV(nsync, wf4(:,16), wf4(:,78), A(:,181), n3(:,417), t3x16(:,:,181), nhel, den(20))
    call Hcont_SS(nsync, wf4(:,14), wf4(:,80), A(:,182), n3(:,418), t3x16(:,:,182), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,14), wf4(:,82), A(:,183), n3(:,419), t3x16(:,:,183), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,16), wf4(:,83), A(:,184), n3(:,420), t3x16(:,:,184), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,16), wf4(:,84), A(:,185), n3(:,421), t3x16(:,:,185), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,14), wf4(:,86), A(:,186), n3(:,422), t3x16(:,:,186), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,14), wf4(:,86), A(:,187), n3(:,423), t3x16(:,:,187), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,16), wf4(:,87), A(:,188), n3(:,424), t3x16(:,:,188), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,16), wf4(:,87), A(:,189), n3(:,425), t3x16(:,:,189), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,2), wf4(:,88), A(:,190), n3(:,426), t3x16(:,:,190), nhel, den(29))
    call Hcont_SS(nsync, wf4(:,2), wf4(:,89), A(:,191), n3(:,427), t3x16(:,:,191), nhel, den(29))
    call Hcont_SS(nsync, wf4(:,5), wf4(:,90), A(:,192), n3(:,428), t3x16(:,:,192), nhel, den(30))
    call Hcont_SS(nsync, wf4(:,5), wf4(:,91), A(:,193), n3(:,429), t3x16(:,:,193), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,92), A(:,194), n3(:,430), t3x16(:,:,194), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,93), A(:,195), n3(:,431), t3x16(:,:,195), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,94), A(:,196), n3(:,432), t3x16(:,:,196), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,95), A(:,197), n3(:,433), t3x16(:,:,197), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,96), A(:,198), n3(:,434), t3x16(:,:,198), nhel, den(31))
    call Hcont_SS(nsync, wf4(:,2), wf4(:,97), A(:,199), n3(:,435), t3x16(:,:,199), nhel, den(25))
    call Hcont_SS(nsync, wf4(:,2), wf4(:,98), A(:,200), n3(:,436), t3x16(:,:,200), nhel, den(25))
    call Hcont_SS(nsync, wf4(:,5), wf4(:,99), A(:,201), n3(:,437), t3x16(:,:,201), nhel, den(26))
    call Hcont_SS(nsync, wf4(:,5), wf4(:,100), A(:,202), n3(:,438), t3x16(:,:,202), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,101), A(:,203), n3(:,439), t3x16(:,:,203), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,102), A(:,204), n3(:,440), t3x16(:,:,204), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,103), A(:,205), n3(:,441), t3x16(:,:,205), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,104), A(:,206), n3(:,442), t3x16(:,:,206), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,102), A(:,207), n3(:,443), t3x16(:,:,207), nhel, den(28))
    call Hcont_QA(nsync, wf2(:,8), wf8(:,45), A(:,208), n3(:,444), t3x16(:,:,208), nhel, den(23))
    call Hcont_QA(nsync, wf2(:,8), wf8(:,46), A(:,209), n3(:,445), t3x16(:,:,209), nhel, den(23))
    call Hcont_QA(nsync, wf2(:,8), wf8(:,47), A(:,210), n3(:,446), t3x16(:,:,210), nhel, den(23))
    call Hcont_QA(nsync, wf2(:,8), wf8(:,47), A(:,211), n3(:,447), t3x16(:,:,211), nhel, den(23))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,48), A(:,212), n3(:,448), t3x16(:,:,212), nhel, den(24))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,49), A(:,213), n3(:,449), t3x16(:,:,213), nhel, den(24))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,50), A(:,214), n3(:,450), t3x16(:,:,214), nhel, den(24))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,50), A(:,215), n3(:,451), t3x16(:,:,215), nhel, den(24))
    call Hcont_SS(nsync, wf4(:,2), wf4(:,106), A(:,216), n3(:,452), t3x16(:,:,216), nhel, den(3))
    call Hcont_SS(nsync, wf4(:,2), wf4(:,108), A(:,217), n3(:,453), t3x16(:,:,217), nhel, den(3))
    call Hcont_SS(nsync, wf4(:,5), wf4(:,110), A(:,218), n3(:,454), t3x16(:,:,218), nhel, den(6))
    call Hcont_SS(nsync, wf4(:,5), wf4(:,112), A(:,219), n3(:,455), t3x16(:,:,219), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,113), A(:,220), n3(:,456), t3x16(:,:,220), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,114), A(:,221), n3(:,457), t3x16(:,:,221), nhel, den(6))
    call Hcont_SS(nsync, wf4(:,5), wf4(:,116), A(:,222), n3(:,458), t3x16(:,:,222), nhel, den(6))
    call Hcont_SS(nsync, wf4(:,5), wf4(:,118), A(:,223), n3(:,459), t3x16(:,:,223), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,119), A(:,224), n3(:,460), t3x16(:,:,224), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,120), A(:,225), n3(:,461), t3x16(:,:,225), nhel, den(6))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,51), A(:,226), n3(:,462), t3x16(:,:,226), nhel, den(8))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,52), A(:,227), n3(:,463), t3x16(:,:,227), nhel, den(8))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,53), A(:,228), n3(:,464), t3x16(:,:,228), nhel, den(9))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,54), A(:,229), n3(:,465), t3x16(:,:,229), nhel, den(9))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,55), A(:,230), n3(:,466), t3x16(:,:,230), nhel, den(11))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,56), A(:,231), n3(:,467), t3x16(:,:,231), nhel, den(11))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,57), A(:,232), n3(:,468), t3x16(:,:,232), nhel, den(9))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,58), A(:,233), n3(:,469), t3x16(:,:,233), nhel, den(9))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,59), A(:,234), n3(:,470), t3x16(:,:,234), nhel, den(11))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,60), A(:,235), n3(:,471), t3x16(:,:,235), nhel, den(13))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,61), A(:,236), n3(:,472), t3x16(:,:,236), nhel, den(13))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,62), A(:,237), n3(:,473), t3x16(:,:,237), nhel, den(14))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,63), A(:,238), n3(:,474), t3x16(:,:,238), nhel, den(14))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,64), A(:,239), n3(:,475), t3x16(:,:,239), nhel, den(15))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,65), A(:,240), n3(:,476), t3x16(:,:,240), nhel, den(15))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,66), A(:,241), n3(:,477), t3x16(:,:,241), nhel, den(14))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,67), A(:,242), n3(:,478), t3x16(:,:,242), nhel, den(14))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,68), A(:,243), n3(:,479), t3x16(:,:,243), nhel, den(15))
    call Hcont_SS(nsync, wf4(:,124), wf4(:,125), A(:,244), n3(:,480), t3x16(:,:,244), nhel, den(37))
    call Hcont_SS(nsync, wf4(:,126), wf4(:,127), A(:,245), n3(:,481), t3x16(:,:,245), nhel, den(40))
    call Hcont_SS(nsync, wf4(:,127), wf4(:,128), A(:,246), n3(:,482), t3x16(:,:,246), nhel, den(40))
    call Hcont_VV(nsync, wf4(:,129), wf4(:,130), A(:,247), n3(:,483), t3x16(:,:,247), nhel, den(40))
    call Hcont_VV(nsync, wf4(:,130), wf4(:,131), A(:,248), n3(:,484), t3x16(:,:,248), nhel, den(40))
    call Hcont_SS(nsync, wf4(:,126), wf4(:,132), A(:,249), n3(:,485), t3x16(:,:,249), nhel, den(41))
    call Hcont_SS(nsync, wf4(:,126), wf4(:,133), A(:,250), n3(:,486), t3x16(:,:,250), nhel, den(40))
    call Hcont_SS(nsync, wf4(:,128), wf4(:,132), A(:,251), n3(:,487), t3x16(:,:,251), nhel, den(41))
    call Hcont_SS(nsync, wf4(:,128), wf4(:,133), A(:,252), n3(:,488), t3x16(:,:,252), nhel, den(40))
    call Hcont_VV(nsync, wf4(:,129), wf4(:,134), A(:,253), n3(:,489), t3x16(:,:,253), nhel, den(41))
    call Hcont_VV(nsync, wf4(:,129), wf4(:,135), A(:,254), n3(:,490), t3x16(:,:,254), nhel, den(40))
    call Hcont_VV(nsync, wf4(:,131), wf4(:,134), A(:,255), n3(:,491), t3x16(:,:,255), nhel, den(41))
    call Hcont_VV(nsync, wf4(:,131), wf4(:,135), A(:,256), n3(:,492), t3x16(:,:,256), nhel, den(40))
    call Hcont_SS(nsync, wf4(:,3), wf4(:,136), A(:,257), n3(:,493), t3x16(:,:,257), nhel, den(44))
    call Hcont_SS(nsync, wf4(:,6), wf4(:,137), A(:,258), n3(:,494), t3x16(:,:,258), nhel, den(47))
    call Hcont_SS(nsync, wf4(:,10), wf4(:,137), A(:,259), n3(:,495), t3x16(:,:,259), nhel, den(47))
    call Hcont_VV(nsync, wf4(:,8), wf4(:,138), A(:,260), n3(:,496), t3x16(:,:,260), nhel, den(47))
    call Hcont_VV(nsync, wf4(:,11), wf4(:,138), A(:,261), n3(:,497), t3x16(:,:,261), nhel, den(47))
    call Hcont_SS(nsync, wf4(:,6), wf4(:,139), A(:,262), n3(:,498), t3x16(:,:,262), nhel, den(48))
    call Hcont_SS(nsync, wf4(:,6), wf4(:,140), A(:,263), n3(:,499), t3x16(:,:,263), nhel, den(47))
    call Hcont_SS(nsync, wf4(:,10), wf4(:,139), A(:,264), n3(:,500), t3x16(:,:,264), nhel, den(48))
    call Hcont_SS(nsync, wf4(:,10), wf4(:,140), A(:,265), n3(:,501), t3x16(:,:,265), nhel, den(47))
    call Hcont_VV(nsync, wf4(:,8), wf4(:,141), A(:,266), n3(:,502), t3x16(:,:,266), nhel, den(48))
    call Hcont_VV(nsync, wf4(:,8), wf4(:,142), A(:,267), n3(:,503), t3x16(:,:,267), nhel, den(47))
    call Hcont_VV(nsync, wf4(:,11), wf4(:,141), A(:,268), n3(:,504), t3x16(:,:,268), nhel, den(48))
    call Hcont_VV(nsync, wf4(:,11), wf4(:,142), A(:,269), n3(:,505), t3x16(:,:,269), nhel, den(47))
    call Hcont_SS(nsync, wf4(:,125), wf4(:,143), A(:,270), n3(:,506), t3x16(:,:,270), nhel, den(50))
    call Hcont_SS(nsync, wf4(:,127), wf4(:,144), A(:,271), n3(:,507), t3x16(:,:,271), nhel, den(52))
    call Hcont_VV(nsync, wf4(:,145), wf4(:,146), A(:,272), n3(:,508), t3x16(:,:,272), nhel, den(55))
    call Hcont_VV(nsync, wf4(:,130), wf4(:,147), A(:,273), n3(:,509), t3x16(:,:,273), nhel, den(52))
    call Hcont_SS(nsync, wf4(:,132), wf4(:,144), A(:,274), n3(:,510), t3x16(:,:,274), nhel, den(56))
    call Hcont_SS(nsync, wf4(:,133), wf4(:,144), A(:,275), n3(:,511), t3x16(:,:,275), nhel, den(52))
    call Hcont_VV(nsync, wf4(:,145), wf4(:,148), A(:,276), n3(:,512), t3x16(:,:,276), nhel, den(57))
    call Hcont_VV(nsync, wf4(:,134), wf4(:,147), A(:,277), n3(:,513), t3x16(:,:,277), nhel, den(56))
    call Hcont_VV(nsync, wf4(:,145), wf4(:,149), A(:,278), n3(:,514), t3x16(:,:,278), nhel, den(55))
    call Hcont_VV(nsync, wf4(:,135), wf4(:,147), A(:,279), n3(:,515), t3x16(:,:,279), nhel, den(52))
    call Hcont_QA(nsync, wf2(:,25), wf8(:,69), A(:,280), n3(:,516), t3x16(:,:,280), nhel, den(60))
    call Hcont_QA(nsync, wf8(:,69), wf2(:,26), A(:,281), n3(:,517), t3x16(:,:,281), nhel, den(60))
    call Hcont_QA(nsync, wf2(:,25), wf8(:,70), A(:,282), n3(:,518), t3x16(:,:,282), nhel, den(62))
    call Hcont_QA(nsync, wf2(:,26), wf8(:,70), A(:,283), n3(:,519), t3x16(:,:,283), nhel, den(62))
    call Hcont_QA(nsync, wf2(:,25), wf8(:,71), A(:,284), n3(:,520), t3x16(:,:,284), nhel, den(64))
    call Hcont_QA(nsync, wf2(:,26), wf8(:,71), A(:,285), n3(:,521), t3x16(:,:,285), nhel, den(64))
    call Hcont_QA(nsync, wf2(:,25), wf8(:,72), A(:,286), n3(:,522), t3x16(:,:,286), nhel, den(62))
    call Hcont_QA(nsync, wf2(:,26), wf8(:,72), A(:,287), n3(:,523), t3x16(:,:,287), nhel, den(62))
    call Hcont_QA(nsync, wf2(:,26), wf8(:,71), A(:,288), n3(:,524), t3x16(:,:,288), nhel, den(64))
    call Hcont_SS(nsync, wf4(:,125), wf4(:,150), A(:,289), n3(:,525), t3x16(:,:,289), nhel, den(66))
    call Hcont_SS(nsync, wf4(:,127), wf4(:,151), A(:,290), n3(:,526), t3x16(:,:,290), nhel, den(68))
    call Hcont_VV(nsync, wf4(:,146), wf4(:,152), A(:,291), n3(:,527), t3x16(:,:,291), nhel, den(70))
    call Hcont_VV(nsync, wf4(:,130), wf4(:,153), A(:,292), n3(:,528), t3x16(:,:,292), nhel, den(68))
    call Hcont_SS(nsync, wf4(:,132), wf4(:,151), A(:,293), n3(:,529), t3x16(:,:,293), nhel, den(71))
    call Hcont_SS(nsync, wf4(:,133), wf4(:,151), A(:,294), n3(:,530), t3x16(:,:,294), nhel, den(68))
    call Hcont_VV(nsync, wf4(:,148), wf4(:,152), A(:,295), n3(:,531), t3x16(:,:,295), nhel, den(72))
    call Hcont_VV(nsync, wf4(:,134), wf4(:,153), A(:,296), n3(:,532), t3x16(:,:,296), nhel, den(71))
    call Hcont_VV(nsync, wf4(:,149), wf4(:,152), A(:,297), n3(:,533), t3x16(:,:,297), nhel, den(70))
    call Hcont_VV(nsync, wf4(:,135), wf4(:,153), A(:,298), n3(:,534), t3x16(:,:,298), nhel, den(68))
    call Hcont_QA(nsync, wf2(:,27), wf8(:,73), A(:,299), n3(:,535), t3x16(:,:,299), nhel, den(75))
    call Hcont_QA(nsync, wf8(:,73), wf2(:,28), A(:,300), n3(:,536), t3x16(:,:,300), nhel, den(75))
    call Hcont_QA(nsync, wf2(:,27), wf8(:,74), A(:,301), n3(:,537), t3x16(:,:,301), nhel, den(77))
    call Hcont_QA(nsync, wf2(:,28), wf8(:,74), A(:,302), n3(:,538), t3x16(:,:,302), nhel, den(77))
    call Hcont_QA(nsync, wf2(:,27), wf8(:,75), A(:,303), n3(:,539), t3x16(:,:,303), nhel, den(79))
    call Hcont_QA(nsync, wf2(:,28), wf8(:,75), A(:,304), n3(:,540), t3x16(:,:,304), nhel, den(79))
    call Hcont_QA(nsync, wf2(:,27), wf8(:,76), A(:,305), n3(:,541), t3x16(:,:,305), nhel, den(77))
    call Hcont_QA(nsync, wf2(:,28), wf8(:,76), A(:,306), n3(:,542), t3x16(:,:,306), nhel, den(77))
    call Hcont_QA(nsync, wf2(:,28), wf8(:,75), A(:,307), n3(:,543), t3x16(:,:,307), nhel, den(79))
    call Hcont_SS(nsync, wf4(:,154), wf4(:,155), A(:,308), n3(:,544), t3x16(:,:,308), nhel, den(82))
    call Hcont_SS(nsync, wf4(:,155), wf4(:,156), A(:,309), n3(:,545), t3x16(:,:,309), nhel, den(82))
    call Hcont_VV(nsync, wf4(:,157), wf4(:,158), A(:,310), n3(:,546), t3x16(:,:,310), nhel, den(82))
    call Hcont_VV(nsync, wf4(:,158), wf4(:,159), A(:,311), n3(:,547), t3x16(:,:,311), nhel, den(82))
    call Hcont_SS(nsync, wf4(:,154), wf4(:,160), A(:,312), n3(:,548), t3x16(:,:,312), nhel, den(82))
    call Hcont_SS(nsync, wf4(:,156), wf4(:,160), A(:,313), n3(:,549), t3x16(:,:,313), nhel, den(82))
    call Hcont_VV(nsync, wf4(:,157), wf4(:,161), A(:,314), n3(:,550), t3x16(:,:,314), nhel, den(82))
    call Hcont_VV(nsync, wf4(:,159), wf4(:,161), A(:,315), n3(:,551), t3x16(:,:,315), nhel, den(82))
    call Hcont_SS(nsync, wf4(:,15), wf4(:,162), A(:,316), n3(:,552), t3x16(:,:,316), nhel, den(85))
    call Hcont_SS(nsync, wf4(:,19), wf4(:,162), A(:,317), n3(:,553), t3x16(:,:,317), nhel, den(85))
    call Hcont_VV(nsync, wf4(:,17), wf4(:,163), A(:,318), n3(:,554), t3x16(:,:,318), nhel, den(85))
    call Hcont_VV(nsync, wf4(:,20), wf4(:,163), A(:,319), n3(:,555), t3x16(:,:,319), nhel, den(85))
    call Hcont_SS(nsync, wf4(:,15), wf4(:,164), A(:,320), n3(:,556), t3x16(:,:,320), nhel, den(85))
    call Hcont_SS(nsync, wf4(:,19), wf4(:,164), A(:,321), n3(:,557), t3x16(:,:,321), nhel, den(85))
    call Hcont_VV(nsync, wf4(:,17), wf4(:,165), A(:,322), n3(:,558), t3x16(:,:,322), nhel, den(85))
    call Hcont_VV(nsync, wf4(:,20), wf4(:,165), A(:,323), n3(:,559), t3x16(:,:,323), nhel, den(85))
    call Hcont_QA(nsync, wf2(:,29), wf8(:,78), A(:,324), n3(:,560), t3x16(:,:,324), nhel, den(88))
    call Hcont_QA(nsync, wf8(:,78), wf2(:,30), A(:,325), n3(:,561), t3x16(:,:,325), nhel, den(88))
    call Hcont_QA(nsync, wf2(:,29), wf8(:,80), A(:,326), n3(:,562), t3x16(:,:,326), nhel, den(88))
    call Hcont_QA(nsync, wf2(:,30), wf8(:,80), A(:,327), n3(:,563), t3x16(:,:,327), nhel, den(88))
    call Hcont_SS(nsync, wf4(:,21), wf4(:,162), A(:,328), n3(:,564), t3x16(:,:,328), nhel, den(90))
    call Hcont_VV(nsync, wf4(:,22), wf4(:,163), A(:,329), n3(:,565), t3x16(:,:,329), nhel, den(90))
    call Hcont_SS(nsync, wf4(:,21), wf4(:,164), A(:,330), n3(:,566), t3x16(:,:,330), nhel, den(90))
    call Hcont_VV(nsync, wf4(:,22), wf4(:,165), A(:,331), n3(:,567), t3x16(:,:,331), nhel, den(90))
    call Hcont_SS(nsync, wf4(:,162), wf4(:,166), A(:,332), n3(:,568), t3x16(:,:,332), nhel, den(92))
    call Hcont_SS(nsync, wf4(:,164), wf4(:,166), A(:,333), n3(:,569), t3x16(:,:,333), nhel, den(92))
    call Hcont_VV(nsync, wf4(:,163), wf4(:,167), A(:,334), n3(:,570), t3x16(:,:,334), nhel, den(92))
    call Hcont_VV(nsync, wf4(:,165), wf4(:,167), A(:,335), n3(:,571), t3x16(:,:,335), nhel, den(92))
    call Hcont_QA(nsync, wf2(:,27), wf8(:,81), A(:,336), n3(:,572), t3x16(:,:,336), nhel, den(94))
    call Hcont_QA(nsync, wf2(:,28), wf8(:,81), A(:,337), n3(:,573), t3x16(:,:,337), nhel, den(94))
    call Hcont_QA(nsync, wf2(:,27), wf8(:,82), A(:,338), n3(:,574), t3x16(:,:,338), nhel, den(94))
    call Hcont_QA(nsync, wf2(:,28), wf8(:,82), A(:,339), n3(:,575), t3x16(:,:,339), nhel, den(94))
    call Hcont_SS(nsync, wf4(:,155), wf4(:,168), A(:,340), n3(:,576), t3x16(:,:,340), nhel, den(96))
    call Hcont_VV(nsync, wf4(:,158), wf4(:,169), A(:,341), n3(:,577), t3x16(:,:,341), nhel, den(96))
    call Hcont_SS(nsync, wf4(:,160), wf4(:,168), A(:,342), n3(:,578), t3x16(:,:,342), nhel, den(96))
    call Hcont_VV(nsync, wf4(:,161), wf4(:,169), A(:,343), n3(:,579), t3x16(:,:,343), nhel, den(96))
    call Hcont_QA(nsync, wf2(:,31), wf8(:,83), A(:,344), n3(:,580), t3x16(:,:,344), nhel, den(99))
    call Hcont_QA(nsync, wf8(:,83), wf2(:,32), A(:,345), n3(:,581), t3x16(:,:,345), nhel, den(99))
    call Hcont_QA(nsync, wf2(:,31), wf8(:,84), A(:,346), n3(:,582), t3x16(:,:,346), nhel, den(99))
    call Hcont_QA(nsync, wf2(:,32), wf8(:,84), A(:,347), n3(:,583), t3x16(:,:,347), nhel, den(99))
    call Hcont_SS(nsync, wf4(:,155), wf4(:,170), A(:,348), n3(:,584), t3x16(:,:,348), nhel, den(101))
    call Hcont_VV(nsync, wf4(:,158), wf4(:,171), A(:,349), n3(:,585), t3x16(:,:,349), nhel, den(101))
    call Hcont_SS(nsync, wf4(:,160), wf4(:,170), A(:,350), n3(:,586), t3x16(:,:,350), nhel, den(101))
    call Hcont_VV(nsync, wf4(:,161), wf4(:,171), A(:,351), n3(:,587), t3x16(:,:,351), nhel, den(101))
    call Hcont_QA(nsync, wf2(:,25), wf8(:,85), A(:,352), n3(:,588), t3x16(:,:,352), nhel, den(103))
    call Hcont_QA(nsync, wf2(:,26), wf8(:,85), A(:,353), n3(:,589), t3x16(:,:,353), nhel, den(103))
    call Hcont_QA(nsync, wf2(:,25), wf8(:,86), A(:,354), n3(:,590), t3x16(:,:,354), nhel, den(103))
    call Hcont_QA(nsync, wf2(:,26), wf8(:,86), A(:,355), n3(:,591), t3x16(:,:,355), nhel, den(103))
    call Hcont_QA(nsync, wf2(:,29), wf8(:,88), A(:,356), n3(:,592), t3x16(:,:,356), nhel, den(105))
    call Hcont_QA(nsync, wf2(:,30), wf8(:,88), A(:,357), n3(:,593), t3x16(:,:,357), nhel, den(105))
    call Hcont_QA(nsync, wf2(:,29), wf8(:,90), A(:,358), n3(:,594), t3x16(:,:,358), nhel, den(107))
    call Hcont_QA(nsync, wf2(:,30), wf8(:,90), A(:,359), n3(:,595), t3x16(:,:,359), nhel, den(107))
    call Hcont_QA(nsync, wf2(:,29), wf8(:,92), A(:,360), n3(:,596), t3x16(:,:,360), nhel, den(109))
    call Hcont_QA(nsync, wf2(:,30), wf8(:,92), A(:,361), n3(:,597), t3x16(:,:,361), nhel, den(109))
    call Hcont_QA(nsync, wf2(:,29), wf8(:,94), A(:,362), n3(:,598), t3x16(:,:,362), nhel, den(107))
    call Hcont_QA(nsync, wf2(:,30), wf8(:,94), A(:,363), n3(:,599), t3x16(:,:,363), nhel, den(107))
    call Hcont_QA(nsync, wf2(:,30), wf8(:,92), A(:,364), n3(:,600), t3x16(:,:,364), nhel, den(109))
    call Hcont_SS(nsync, wf4(:,23), wf4(:,136), A(:,365), n3(:,601), t3x16(:,:,365), nhel, den(111))
    call Hcont_SS(nsync, wf4(:,24), wf4(:,137), A(:,366), n3(:,602), t3x16(:,:,366), nhel, den(113))
    call Hcont_SS(nsync, wf4(:,24), wf4(:,139), A(:,367), n3(:,603), t3x16(:,:,367), nhel, den(114))
    call Hcont_SS(nsync, wf4(:,24), wf4(:,140), A(:,368), n3(:,604), t3x16(:,:,368), nhel, den(113))
    call Hcont_VV(nsync, wf4(:,26), wf4(:,172), A(:,369), n3(:,605), t3x16(:,:,369), nhel, den(117))
    call Hcont_VV(nsync, wf4(:,27), wf4(:,138), A(:,370), n3(:,606), t3x16(:,:,370), nhel, den(113))
    call Hcont_VV(nsync, wf4(:,26), wf4(:,173), A(:,371), n3(:,607), t3x16(:,:,371), nhel, den(118))
    call Hcont_VV(nsync, wf4(:,26), wf4(:,174), A(:,372), n3(:,608), t3x16(:,:,372), nhel, den(117))
    call Hcont_VV(nsync, wf4(:,27), wf4(:,141), A(:,373), n3(:,609), t3x16(:,:,373), nhel, den(114))
    call Hcont_VV(nsync, wf4(:,27), wf4(:,142), A(:,374), n3(:,610), t3x16(:,:,374), nhel, den(113))
    call Hcont_QA(nsync, wf2(:,31), wf8(:,96), A(:,375), n3(:,611), t3x16(:,:,375), nhel, den(120))
    call Hcont_QA(nsync, wf2(:,32), wf8(:,96), A(:,376), n3(:,612), t3x16(:,:,376), nhel, den(120))
    call Hcont_QA(nsync, wf2(:,31), wf8(:,98), A(:,377), n3(:,613), t3x16(:,:,377), nhel, den(122))
    call Hcont_QA(nsync, wf2(:,32), wf8(:,98), A(:,378), n3(:,614), t3x16(:,:,378), nhel, den(122))
    call Hcont_QA(nsync, wf2(:,31), wf8(:,100), A(:,379), n3(:,615), t3x16(:,:,379), nhel, den(124))
    call Hcont_QA(nsync, wf2(:,32), wf8(:,100), A(:,380), n3(:,616), t3x16(:,:,380), nhel, den(124))
    call Hcont_QA(nsync, wf2(:,31), wf8(:,102), A(:,381), n3(:,617), t3x16(:,:,381), nhel, den(122))
    call Hcont_QA(nsync, wf2(:,32), wf8(:,102), A(:,382), n3(:,618), t3x16(:,:,382), nhel, den(122))
    call Hcont_QA(nsync, wf2(:,32), wf8(:,100), A(:,383), n3(:,619), t3x16(:,:,383), nhel, den(124))
    call Hcont_SS(nsync, wf4(:,28), wf4(:,136), A(:,384), n3(:,620), t3x16(:,:,384), nhel, den(126))
    call Hcont_SS(nsync, wf4(:,29), wf4(:,137), A(:,385), n3(:,621), t3x16(:,:,385), nhel, den(128))
    call Hcont_SS(nsync, wf4(:,29), wf4(:,139), A(:,386), n3(:,622), t3x16(:,:,386), nhel, den(129))
    call Hcont_SS(nsync, wf4(:,29), wf4(:,140), A(:,387), n3(:,623), t3x16(:,:,387), nhel, den(128))
    call Hcont_VV(nsync, wf4(:,30), wf4(:,172), A(:,388), n3(:,624), t3x16(:,:,388), nhel, den(131))
    call Hcont_VV(nsync, wf4(:,31), wf4(:,138), A(:,389), n3(:,625), t3x16(:,:,389), nhel, den(128))
    call Hcont_VV(nsync, wf4(:,30), wf4(:,173), A(:,390), n3(:,626), t3x16(:,:,390), nhel, den(132))
    call Hcont_VV(nsync, wf4(:,30), wf4(:,174), A(:,391), n3(:,627), t3x16(:,:,391), nhel, den(131))
    call Hcont_VV(nsync, wf4(:,31), wf4(:,141), A(:,392), n3(:,628), t3x16(:,:,392), nhel, den(129))
    call Hcont_VV(nsync, wf4(:,31), wf4(:,142), A(:,393), n3(:,629), t3x16(:,:,393), nhel, den(128))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(4), M2(4) ! M1helarray(4,nhel)
  integer :: empty(0), i

  M1(1)%j = (-A(j,22)%j-A(j,26)%j)*f(13)-A(j,16)%j*f(17)+(-A(j,20)%j-A(j,24)%j)*f(21)+(-A(j,17)%j-A(j,18)%j)*f(50)+(-A(j,23)%j &
       -A(j,27)%j)*f(56)+(-A(j,21)%j-A(j,25)%j)*f(63)-A(j,19)%j*f(70)
  M1(2)%j = ((A(j,10)%j+A(j,15)%j)*f(126))/2._/**/REALKIND+((A(j,32)%j+A(j,37)%j)*f(144))/2._/**/REALKIND
  M1(3)%j = (-A(j,6)%j-A(j,7)%j-A(j,11)%j-A(j,12)%j)*f(25)-A(j,2)%j*f(30)-A(j,1)%j*f(36)+(-A(j,28)%j-A(j,29)%j-A(j,33)%j &
       -A(j,34)%j)*f(40)-A(j,4)%j*f(98)+A(j,3)%j*f(104)+(-A(j,8)%j-A(j,13)%j)*f(117)+(A(j,9)%j+A(j,14)%j)*f(118)+(-A(j,30)%j &
       -A(j,35)%j)*f(135)+(A(j,31)%j+A(j,36)%j)*f(136)+A(j,5)%j*f(153)
  M1(4)%j = ((-A(j,10)%j-A(j,15)%j)*f(126))/6._/**/REALKIND+((-A(j,32)%j-A(j,37)%j)*f(144))/6._/**/REALKIND

  M2(1)%j = (A(j,313)%j-A(j,321)%j)*f(11)+(-A(j,311)%j+A(j,319)%j)*f(12)+(A(j,332)%j+A(j,337)%j+A(j,348)%j+A(j,353)%j)*f(14) &
       +(A(j,308)%j+A(j,316)%j)*f(18)-A(j,94)%j*f(19)+(A(j,325)%j+A(j,328)%j+A(j,340)%j+A(j,345)%j)*f(22)+(-A(j,310)%j &
       +A(j,318)%j)*f(45)+(-A(j,333)%j+A(j,334)%j-A(j,349)%j+A(j,350)%j)*f(46)+(A(j,312)%j-A(j,320)%j)*f(47)+(A(j,329)%j &
       -A(j,330)%j-A(j,341)%j+A(j,342)%j)*f(48)+(A(j,309)%j+A(j,314)%j+A(j,317)%j+A(j,322)%j)*f(51)-A(j,187)%j*f(52) &
       -A(j,161)%j*f(53)+(A(j,335)%j+A(j,339)%j+A(j,351)%j+A(j,355)%j)*f(57)+(-A(j,177)%j-A(j,215)%j)*f(58)+(-A(j,135)%j &
       -A(j,173)%j)*f(59)+(A(j,327)%j+A(j,331)%j+A(j,343)%j+A(j,347)%j)*f(64)+(-A(j,101)%j-A(j,211)%j)*f(65)+(-A(j,109)%j &
       -A(j,169)%j)*f(66)+(A(j,315)%j+A(j,323)%j)*f(71)-A(j,189)%j*f(72)-A(j,165)%j*f(73)-A(j,97)%j*f(75)+(A(j,103)%j &
       +A(j,111)%j)*f(78)+(A(j,137)%j+A(j,179)%j)*f(79)+(A(j,95)%j+A(j,96)%j)*f(97)+(A(j,105)%j+A(j,113)%j)*f(99)+(A(j,139)%j &
       +A(j,181)%j)*f(105)+(-A(j,133)%j-A(j,171)%j+A(j,175)%j+A(j,213)%j)*f(110)+(-A(j,159)%j+A(j,183)%j)*f(111)+(A(j,99)%j &
       -A(j,107)%j-A(j,167)%j+A(j,209)%j)*f(112)+(-A(j,163)%j+A(j,185)%j)*f(113)
  M2(2)%j = ((-A(j,65)%j-A(j,83)%j)*f(7))/2._/**/REALKIND+((-A(j,157)%j-A(j,207)%j)*f(10))/2._/**/REALKIND+(-A(j,132)%j-A(j,170)%j &
       -A(j,174)%j-A(j,212)%j+A(j,336)%j+A(j,352)%j)*f(15)+(-A(j,102)%j-A(j,110)%j)*f(16)+(-A(j,158)%j-A(j,182)%j)*f(20)+( &
       -A(j,98)%j-A(j,106)%j-A(j,166)%j-A(j,208)%j+A(j,324)%j+A(j,344)%j)*f(23)+(-A(j,136)%j-A(j,178)%j)*f(24)+(-A(j,162)%j &
       -A(j,184)%j)*f(54)+(-A(j,160)%j-A(j,186)%j)*f(55)+(A(j,338)%j+A(j,354)%j)*f(60)+(-A(j,104)%j-A(j,112)%j)*f(61)+(-A(j,134)%j &
       -A(j,172)%j-A(j,176)%j-A(j,214)%j)*f(62)+(A(j,326)%j+A(j,346)%j)*f(67)+(-A(j,138)%j-A(j,180)%j)*f(68)+(-A(j,100)%j &
       -A(j,108)%j-A(j,168)%j-A(j,210)%j)*f(69)+(-A(j,164)%j-A(j,188)%j)*f(74)+((A(j,56)%j+A(j,74)%j+A(j,234)%j+A(j,243)%j &
       -A(j,288)%j-A(j,307)%j)*f(128))/2._/**/REALKIND+((A(j,122)%j+A(j,131)%j+A(j,148)%j+A(j,198)%j-A(j,364)%j &
       -A(j,383)%j)*f(146))/2._/**/REALKIND
  M2(3)%j = ((A(j,65)%j+A(j,83)%j)*f(7))/6._/**/REALKIND+((A(j,157)%j+A(j,207)%j)*f(10))/6._/**/REALKIND+(A(j,280)%j+A(j,282)%j &
       +A(j,299)%j+A(j,301)%j)*f(27)+(-A(j,48)%j-A(j,50)%j-A(j,57)%j-A(j,59)%j-A(j,66)%j-A(j,68)%j-A(j,75)%j-A(j,77)%j)*f(28)+( &
       -A(j,226)%j-A(j,228)%j-A(j,235)%j-A(j,237)%j)*f(29)-A(j,86)%j*f(34)-A(j,218)%j*f(35)-A(j,84)%j*f(38)-A(j,216)%j*f(39) &
       +(A(j,356)%j+A(j,358)%j+A(j,375)%j+A(j,377)%j)*f(42)+(-A(j,114)%j-A(j,116)%j-A(j,123)%j-A(j,125)%j)*f(43)+(-A(j,140)%j &
       -A(j,142)%j-A(j,149)%j-A(j,151)%j-A(j,190)%j-A(j,192)%j-A(j,199)%j-A(j,201)%j)*f(44)-A(j,90)%j*f(102)-A(j,222)%j*f(103) &
       +A(j,220)%j*f(108)+A(j,88)%j*f(109)+(A(j,284)%j+A(j,303)%j)*f(127)+(-A(j,286)%j-A(j,305)%j)*f(128)+((-A(j,56)%j-A(j,74)%j &
       -A(j,234)%j-A(j,243)%j+A(j,288)%j+A(j,307)%j)*f(128))/6._/**/REALKIND+(-A(j,61)%j-A(j,79)%j)*f(129)+(A(j,63)%j &
       +A(j,81)%j)*f(130)+(-A(j,52)%j-A(j,70)%j)*f(131)+(A(j,54)%j+A(j,72)%j)*f(132)+(-A(j,230)%j-A(j,239)%j)*f(133)+(A(j,232)%j &
       +A(j,241)%j)*f(134)+(A(j,360)%j+A(j,379)%j)*f(145)+(-A(j,362)%j-A(j,381)%j)*f(146)+((-A(j,122)%j-A(j,131)%j-A(j,148)%j &
       -A(j,198)%j+A(j,364)%j+A(j,383)%j)*f(146))/6._/**/REALKIND+(-A(j,153)%j-A(j,203)%j)*f(147)+(A(j,155)%j+A(j,205)%j)*f(148)+( &
       -A(j,118)%j-A(j,127)%j)*f(149)+(A(j,120)%j+A(j,129)%j)*f(150)+(-A(j,144)%j-A(j,194)%j)*f(151)+(A(j,146)%j &
       +A(j,196)%j)*f(152)+A(j,92)%j*f(157)+A(j,224)%j*f(158)
  M2(4)%j = -(A(j,44)%j*f(1))+A(j,46)%j*f(2)-A(j,45)%j*f(3)+A(j,47)%j*f(4)+(A(j,62)%j+A(j,80)%j)*f(5)+(-A(j,64)%j-A(j,82)%j)*f(6) &
       +(A(j,154)%j+A(j,204)%j)*f(8)+(-A(j,156)%j-A(j,206)%j)*f(9)+(A(j,270)%j+A(j,271)%j+A(j,281)%j+A(j,283)%j+A(j,289)%j &
       +A(j,290)%j+A(j,300)%j+A(j,302)%j)*f(26)+(A(j,245)%j+A(j,258)%j)*f(31)-A(j,38)%j*f(32)-A(j,39)%j*f(33)+(A(j,244)%j &
       +A(j,257)%j)*f(37)+(A(j,357)%j+A(j,359)%j+A(j,365)%j+A(j,366)%j+A(j,376)%j+A(j,378)%j+A(j,384)%j+A(j,385)%j)*f(41) &
       +(A(j,247)%j+A(j,260)%j)*f(49)+A(j,261)%j*f(76)-A(j,248)%j*f(77)+(A(j,49)%j+A(j,58)%j+A(j,60)%j+A(j,67)%j+A(j,76)%j &
       +A(j,78)%j+A(j,227)%j+A(j,236)%j)*f(80)+(-A(j,51)%j-A(j,69)%j+A(j,229)%j+A(j,238)%j)*f(81)+(-A(j,87)%j+A(j,219)%j)*f(82) &
       +(A(j,85)%j+A(j,217)%j)*f(83)+(A(j,115)%j+A(j,124)%j+A(j,141)%j+A(j,150)%j+A(j,152)%j+A(j,191)%j+A(j,200)%j &
       +A(j,202)%j)*f(84)+(-A(j,117)%j-A(j,126)%j+A(j,143)%j+A(j,193)%j)*f(85)+(-A(j,274)%j-A(j,293)%j)*f(86)+(A(j,275)%j &
       +A(j,294)%j)*f(87)-A(j,249)%j*f(88)+A(j,250)%j*f(89)+(-A(j,272)%j-A(j,291)%j)*f(90)+(-A(j,369)%j-A(j,388)%j)*f(91)+( &
       -A(j,273)%j-A(j,292)%j+A(j,370)%j+A(j,389)%j)*f(92)-A(j,262)%j*f(93)-A(j,263)%j*f(94)+(-A(j,367)%j-A(j,386)%j)*f(95)+( &
       -A(j,368)%j-A(j,387)%j)*f(96)-A(j,253)%j*f(100)+(-A(j,223)%j+A(j,254)%j+A(j,259)%j)*f(101)-A(j,266)%j*f(106)+(A(j,89)%j &
       -A(j,246)%j-A(j,267)%j)*f(107)-A(j,264)%j*f(114)+A(j,251)%j*f(115)+(-A(j,252)%j-A(j,265)%j)*f(116)+(A(j,276)%j+A(j,285)%j &
       +A(j,295)%j+A(j,304)%j)*f(119)+(A(j,231)%j+A(j,240)%j-A(j,278)%j-A(j,297)%j)*f(120)+(-A(j,53)%j-A(j,71)%j+A(j,277)%j &
       +A(j,296)%j)*f(121)+(A(j,55)%j+A(j,73)%j+A(j,233)%j+A(j,242)%j-A(j,279)%j-A(j,287)%j-A(j,298)%j-A(j,306)%j)*f(122) &
       -A(j,91)%j*f(123)-A(j,42)%j*f(124)+A(j,43)%j*f(125)+(A(j,361)%j+A(j,371)%j+A(j,380)%j+A(j,390)%j)*f(137)+(A(j,145)%j &
       +A(j,195)%j-A(j,373)%j-A(j,392)%j)*f(138)+(-A(j,119)%j-A(j,128)%j+A(j,372)%j+A(j,391)%j)*f(139)+(A(j,121)%j+A(j,130)%j &
       +A(j,147)%j+A(j,197)%j-A(j,363)%j-A(j,374)%j-A(j,382)%j-A(j,393)%j)*f(140)-A(j,221)%j*f(141)-A(j,40)%j*f(142) &
       -A(j,41)%j*f(143)-A(j,268)%j*f(154)+A(j,255)%j*f(155)+(A(j,93)%j+A(j,225)%j-A(j,256)%j-A(j,269)%j)*f(156)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphtt_ew_ttxbbxh_3_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(4)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 4
      do j = 1, 4
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphtt_ew_ttxbbxh_3_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(4), Mct(4)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 4
    do j = 1, 4
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+4*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_pphtt_ew_ttxbbxh_3_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(4)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 4*k
    do i = 1, 4
      do j = 1, 4
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphtt_ew_ttxbbxh_3_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(4)
  complex(REALKIND), intent(in)  :: M2(4)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 4
    do j = 1, 4
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_pphtt_ew_ttxbbxh_3_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(4)
  type(Hpolcont), intent(out)  :: M0_col(4)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 4 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 4 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+4*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_pphtt_ew_ttxbbxh_3_/**/REALKIND
