
module ol_colourmatrix_pphtt_ew_ttxbbxh_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(68,4), K2(68,4), KL(68,4), Cas(5) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [   0,   0,   0,   0]
  K1( 2,:) = [   0,   9,   0,   3]
  K1( 3,:) = [   0,   0,   0,   0]
  K1( 4,:) = [   0,   3,   0,   9]
  K1( 5,:) = [   0,  12,   0,   4]
  K1( 6,:) = [  12,   0,   4,   0]
  K1( 7,:) = [   0,   4,   0,  12]
  K1( 8,:) = [   4,   0,  12,   0]
  K1( 9,:) = [   0,   0,   0,  -4]
  K1(10,:) = [   0,   0,  -4,   0]
  K1(11,:) = [   0,  -4,   0, -12]
  K1(12,:) = [  -4,   0, -12,   0]
  K1(13,:) = [   0,  12,   0,   4]
  K1(14,:) = [  12,   0,   4,   0]
  K1(15,:) = [   0,   4,   0,  12]
  K1(16,:) = [   4,   0,  12,   0]
  K1(17,:) = [   0,   0,   0,   4]
  K1(18,:) = [   0,   0,   4,   0]
  K1(19,:) = [   0,   4,   0,   0]
  K1(20,:) = [   4,   0,   0,   0]
  K1(21,:) = [   0, -12,   0,  -4]
  K1(22,:) = [ -12,   0,  -4,   0]
  K1(23,:) = [   0,  -4,   0,   0]
  K1(24,:) = [  -4,   0,   0,   0]
  K1(25,:) = [   0,  12,   0,   4]
  K1(26,:) = [  12,   0,   4,   0]
  K1(27,:) = [   0,   4,   0,  12]
  K1(28,:) = [   4,   0,  12,   0]
  K1(29,:) = [   0, -12,   0,  -4]
  K1(30,:) = [ -12,   0,  -4,   0]
  K1(31,:) = [   0,  -4,   0,   0]
  K1(32,:) = [  -4,   0,   0,   0]
  K1(33,:) = [   0,   0,   0,   4]
  K1(34,:) = [   0,   0,   4,   0]
  K1(35,:) = [   0,   4,   0,   0]
  K1(36,:) = [   4,   0,   0,   0]
  K1(37,:) = [   0,   0,   0,  -4]
  K1(38,:) = [   0,   0,  -4,   0]
  K1(39,:) = [   0,  -4,   0, -12]
  K1(40,:) = [  -4,   0, -12,   0]
  K1(41,:) = [   0,  12,   0,   4]
  K1(42,:) = [  12,   0,   4,   0]
  K1(43,:) = [   0,   4,   0,  12]
  K1(44,:) = [   4,   0,  12,   0]
  K1(45,:) = [   0,   0,   0,   0]
  K1(46,:) = [   0,   0,   0,   0]
  K1(47,:) = [   0,   0,   0,   0]
  K1(48,:) = [   0,   0,   0,   0]
  K1(49,:) = [   0,   0,   0,   0]
  K1(50,:) = [   0,   0,   0,   0]
  K1(51,:) = [   0,   0,   0,   0]
  K1(52,:) = [   0,   0,   0,   0]
  K1(53,:) = [   0,   0,   0,   0]
  K1(54,:) = [   0,   0,   0,   0]
  K1(55,:) = [   0,   0,   0,   0]
  K1(56,:) = [   0,   0,   0,   0]
  K1(57,:) = [   0,   0,   0,   0]
  K1(58,:) = [   0,   0,   0,   0]
  K1(59,:) = [   0,   0,   0,   0]
  K1(60,:) = [   0,   0,   0,   0]
  K1(61,:) = [   0,   0,   0,   0]
  K1(62,:) = [   0,   0,   0,   0]
  K1(63,:) = [   0,   0,   0,   0]
  K1(64,:) = [   0,   0,   0,   0]
  K1(65,:) = [   0,   0,   0,   0]
  K1(66,:) = [   0,   9,   0,   3]
  K1(67,:) = [   0,   0,   0,   0]
  K1(68,:) = [   0,   3,   0,   9]

  K2( 1,:) = [   0,   9,   0,   3]
  K2( 2,:) = [   9,   0,   3,   0]
  K2( 3,:) = [   0,   3,   0,   9]
  K2( 4,:) = [   3,   0,   9,   0]
  K2( 5,:) = [  12,   0,   4,   0]
  K2( 6,:) = [   0,   0,   0,   0]
  K2( 7,:) = [   4,   0,  12,   0]
  K2( 8,:) = [   0,   0,   0,   0]
  K2( 9,:) = [   0,   0,  -4,   0]
  K2(10,:) = [   0,   0,   0,   0]
  K2(11,:) = [  -4,   0, -12,   0]
  K2(12,:) = [   0,   0,   0,   0]
  K2(13,:) = [  12,   0,   4,   0]
  K2(14,:) = [   0,   0,   0,   0]
  K2(15,:) = [   4,   0,  12,   0]
  K2(16,:) = [   0,   0,   0,   0]
  K2(17,:) = [   0,   0,   4,   0]
  K2(18,:) = [   0,   0,   0,   0]
  K2(19,:) = [   4,   0,   0,   0]
  K2(20,:) = [   0,   0,   0,   0]
  K2(21,:) = [ -12,   0,  -4,   0]
  K2(22,:) = [   0,   0,   0,   0]
  K2(23,:) = [  -4,   0,   0,   0]
  K2(24,:) = [   0,   0,   0,   0]
  K2(25,:) = [  12,   0,   4,   0]
  K2(26,:) = [   0,   0,   0,   0]
  K2(27,:) = [   4,   0,  12,   0]
  K2(28,:) = [   0,   0,   0,   0]
  K2(29,:) = [ -12,   0,  -4,   0]
  K2(30,:) = [   0,   0,   0,   0]
  K2(31,:) = [  -4,   0,   0,   0]
  K2(32,:) = [   0,   0,   0,   0]
  K2(33,:) = [   0,   0,   4,   0]
  K2(34,:) = [   0,   0,   0,   0]
  K2(35,:) = [   4,   0,   0,   0]
  K2(36,:) = [   0,   0,   0,   0]
  K2(37,:) = [   0,   0,  -4,   0]
  K2(38,:) = [   0,   0,   0,   0]
  K2(39,:) = [  -4,   0, -12,   0]
  K2(40,:) = [   0,   0,   0,   0]
  K2(41,:) = [  12,   0,   4,   0]
  K2(42,:) = [   0,   0,   0,   0]
  K2(43,:) = [   4,   0,  12,   0]
  K2(44,:) = [   0,   0,   0,   0]
  K2(45,:) = [   0,   0,   0,   0]
  K2(46,:) = [   0,   0,   0,   0]
  K2(47,:) = [   0,   0,   0,   0]
  K2(48,:) = [   0,   0,   0,   0]
  K2(49,:) = [   0,   0,   0,   0]
  K2(50,:) = [   0,   0,   0,   0]
  K2(51,:) = [   0,   0,   0,   0]
  K2(52,:) = [   0,   0,   0,   0]
  K2(53,:) = [   0,   0,   0,   0]
  K2(54,:) = [   0,   0,   0,   0]
  K2(55,:) = [   0,   0,   0,   0]
  K2(56,:) = [   0,   0,   0,   0]
  K2(57,:) = [   0,   0,   0,   0]
  K2(58,:) = [   0,   0,   0,   0]
  K2(59,:) = [   0,   0,   0,   0]
  K2(60,:) = [   0,   0,   0,   0]
  K2(61,:) = [   0,   0,   0,   0]
  K2(62,:) = [   0,   0,   0,   0]
  K2(63,:) = [   0,   0,   0,   0]
  K2(64,:) = [   0,   0,   0,   0]
  K2(65,:) = [   0,   9,   0,   3]
  K2(66,:) = [   9,   0,   3,   0]
  K2(67,:) = [   0,   3,   0,   9]
  K2(68,:) = [   3,   0,   9,   0]

  KL( 1,:) = [   0,   9,   0,   3]
  KL( 2,:) = [   9,   0,   3,   0]
  KL( 3,:) = [   0,   3,   0,   9]
  KL( 4,:) = [   3,   0,   9,   0]
  KL( 5,:) = [  12,   0,   4,   0]
  KL( 6,:) = [   0,   0,   0,   0]
  KL( 7,:) = [   4,   0,  12,   0]
  KL( 8,:) = [   0,   0,   0,   0]
  KL( 9,:) = [   0,   0,  -4,   0]
  KL(10,:) = [   0,   0,   0,   0]
  KL(11,:) = [  -4,   0, -12,   0]
  KL(12,:) = [   0,   0,   0,   0]
  KL(13,:) = [  12,   0,   4,   0]
  KL(14,:) = [   0,   0,   0,   0]
  KL(15,:) = [   4,   0,  12,   0]
  KL(16,:) = [   0,   0,   0,   0]
  KL(17,:) = [   0,   0,   4,   0]
  KL(18,:) = [   0,   0,   0,   0]
  KL(19,:) = [   4,   0,   0,   0]
  KL(20,:) = [   0,   0,   0,   0]
  KL(21,:) = [ -12,   0,  -4,   0]
  KL(22,:) = [   0,   0,   0,   0]
  KL(23,:) = [  -4,   0,   0,   0]
  KL(24,:) = [   0,   0,   0,   0]
  KL(25,:) = [  12,   0,   4,   0]
  KL(26,:) = [   0,   0,   0,   0]
  KL(27,:) = [   4,   0,  12,   0]
  KL(28,:) = [   0,   0,   0,   0]
  KL(29,:) = [ -12,   0,  -4,   0]
  KL(30,:) = [   0,   0,   0,   0]
  KL(31,:) = [  -4,   0,   0,   0]
  KL(32,:) = [   0,   0,   0,   0]
  KL(33,:) = [   0,   0,   4,   0]
  KL(34,:) = [   0,   0,   0,   0]
  KL(35,:) = [   4,   0,   0,   0]
  KL(36,:) = [   0,   0,   0,   0]
  KL(37,:) = [   0,   0,  -4,   0]
  KL(38,:) = [   0,   0,   0,   0]
  KL(39,:) = [  -4,   0, -12,   0]
  KL(40,:) = [   0,   0,   0,   0]
  KL(41,:) = [  12,   0,   4,   0]
  KL(42,:) = [   0,   0,   0,   0]
  KL(43,:) = [   4,   0,  12,   0]
  KL(44,:) = [   0,   0,   0,   0]
  KL(45,:) = [   0,   0,   0,   0]
  KL(46,:) = [   0,   0,   0,   0]
  KL(47,:) = [   0,   0,   0,   0]
  KL(48,:) = [   0,   0,   0,   0]
  KL(49,:) = [   0,   0,   0,   0]
  KL(50,:) = [   0,   0,   0,   0]
  KL(51,:) = [   0,   0,   0,   0]
  KL(52,:) = [   0,   0,   0,   0]
  KL(53,:) = [   0,   0,   0,   0]
  KL(54,:) = [   0,   0,   0,   0]
  KL(55,:) = [   0,   0,   0,   0]
  KL(56,:) = [   0,   0,   0,   0]
  KL(57,:) = [   0,   0,   0,   0]
  KL(58,:) = [   0,   0,   0,   0]
  KL(59,:) = [   0,   0,   0,   0]
  KL(60,:) = [   0,   0,   0,   0]
  KL(61,:) = [   0,   0,   0,   0]
  KL(62,:) = [   0,   0,   0,   0]
  KL(63,:) = [   0,   0,   0,   0]
  KL(64,:) = [   0,   0,   0,   0]
  KL(65,:) = [   0,   9,   0,   3]
  KL(66,:) = [   9,   0,   3,   0]
  KL(67,:) = [   0,   3,   0,   9]
  KL(68,:) = [   3,   0,   9,   0]

#if 1 > 0
    co = 0
    do k = 1, 5
      co = co + k
      Cas(k) = K1(1+4*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_pphtt_ew_ttxbbxh_1_/**/REALKIND



module ol_forced_parameters_pphtt_ew_ttxbbxh_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pphtt_ew_ttxbbxh_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_pphtt_ew_ttxbbxh_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 16 ! number of helicity configurations
  integer(intkind2), save :: nhel = 16 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 16 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(16) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(102)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(1)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf2(2,32), wf4(4,104), wf8(8,80), wf16(16,188)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(115), c(108)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_pphtt_ew_ttxbbxh_1_/**/REALKIND






! **********************************************************************
module ol_loop_pphtt_ew_ttxbbxh_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_pphtt_ew_ttxbbxh_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = CI*countertermnorm*ctHGG*eQED*gQCD**4
    f(  2) = (CI*countertermnorm*eQED**3*gQCD**2*MB)/MW
    f(  3) = (CI*countertermnorm*eQED**3*gQCD**2*MT)/MW
    f(  4) = (CI*eQED**3*MB)/(4._/**/REALKIND*MW**3*sw**3)
    f(  5) = (CI*countertermnorm*eQED**3*gQCD**2*MB)/(4._/**/REALKIND*MW**3*sw**3)
    f(  6) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(4._/**/REALKIND*MW**3*sw**3)
    f(  7) = (CI*eQED**3*MH**2)/(4._/**/REALKIND*MW**3*sw**3)
    f(  8) = (CI*countertermnorm*eQED**3*gQCD**2*MH**2)/(4._/**/REALKIND*MW**3*sw**3)
    f(  9) = (CI*eQED**3*MT)/(4._/**/REALKIND*MW**3*sw**3)
    f( 10) = (CI*countertermnorm*eQED**3*gQCD**2*MT)/(4._/**/REALKIND*MW**3*sw**3)
    f( 11) = (CI*countertermnorm*ctStt*eQED**3*gQCD**2*MT)/(4._/**/REALKIND*MW**3*sw**3)
    f( 12) = (CI*eQED**3*MB**2*MT)/(8._/**/REALKIND*MW**3*sw**3)
    f( 13) = (CI*countertermnorm*eQED**3*gQCD**2*MB**2*MT)/(8._/**/REALKIND*MW**3*sw**3)
    f( 14) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB**2*MT)/(8._/**/REALKIND*MW**3*sw**3)
    f( 15) = (CI*countertermnorm*ctStt*eQED**3*gQCD**2*MB**2*MT)/(8._/**/REALKIND*MW**3*sw**3)
    f( 16) = (CI*eQED**3*MB*MH**2*MT)/(8._/**/REALKIND*MW**3*sw**3)
    f( 17) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB*MH**2*MT)/(8._/**/REALKIND*MW**3*sw**3)
    f( 18) = (CI*countertermnorm*ctStt*eQED**3*gQCD**2*MB*MH**2*MT)/(8._/**/REALKIND*MW**3*sw**3)
    f( 19) = (3*CI*eQED**3*lambdaHHH*MB*MH**2*MT)/(8._/**/REALKIND*MW**3*sw**3)
    f( 20) = (3*CI*countertermnorm*ctSbb*eQED**3*gQCD**2*lambdaHHH*MB*MH**2*MT)/(8._/**/REALKIND*MW**3*sw**3)
    f( 21) = (3*CI*countertermnorm*ctStt*eQED**3*gQCD**2*lambdaHHH*MB*MH**2*MT)/(8._/**/REALKIND*MW**3*sw**3)
    f( 22) = (CI*eQED**3*MB*MT**2)/(8._/**/REALKIND*MW**3*sw**3)
    f( 23) = (CI*countertermnorm*eQED**3*gQCD**2*MB*MT**2)/(8._/**/REALKIND*MW**3*sw**3)
    f( 24) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB*MT**2)/(8._/**/REALKIND*MW**3*sw**3)
    f( 25) = (CI*countertermnorm*ctStt*eQED**3*gQCD**2*MB*MT**2)/(8._/**/REALKIND*MW**3*sw**3)
    f( 26) = (CI*eQED**3)/(4._/**/REALKIND*MW*sw**3)
    f( 27) = (CI*countertermnorm*eQED**3*gQCD**2)/(4._/**/REALKIND*MW*sw**3)
    f( 28) = (CI*countertermnorm*ctVbt*eQED**3*gQCD**2)/(4._/**/REALKIND*MW*sw**3)
    f( 29) = (CI*eQED**3*MB)/(4._/**/REALKIND*MW*sw**3)
    f( 30) = (CI*countertermnorm*eQED**3*gQCD**2*MB)/(4._/**/REALKIND*MW*sw**3)
    f( 31) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(4._/**/REALKIND*MW*sw**3)
    f( 32) = (CI*countertermnorm*ctVbt*eQED**3*gQCD**2*MB)/(4._/**/REALKIND*MW*sw**3)
    f( 33) = (CI*eQED**3*MT)/(4._/**/REALKIND*MW*sw**3)
    f( 34) = (CI*countertermnorm*eQED**3*gQCD**2*MT)/(4._/**/REALKIND*MW*sw**3)
    f( 35) = (CI*countertermnorm*ctStt*eQED**3*gQCD**2*MT)/(4._/**/REALKIND*MW*sw**3)
    f( 36) = (CI*countertermnorm*ctVbt*eQED**3*gQCD**2*MT)/(4._/**/REALKIND*MW*sw**3)
    f( 37) = (CI*eQED**3*MW)/(2._/**/REALKIND*sw**3)
    f( 38) = (CI*countertermnorm*ctVbt*eQED**3*gQCD**2*MW)/(2._/**/REALKIND*sw**3)
    f( 39) = (CI*eQED**3*MB)/(4._/**/REALKIND*cw*MW*sw**2)
    f( 40) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(4._/**/REALKIND*cw*MW*sw**2)
    f( 41) = (CI*countertermnorm*ctVtt*eQED**3*gQCD**2*MB)/(4._/**/REALKIND*cw*MW*sw**2)
    f( 42) = (CI*eQED**3*MT)/(4._/**/REALKIND*cw*MW*sw**2)
    f( 43) = (CI*countertermnorm*ctStt*eQED**3*gQCD**2*MT)/(4._/**/REALKIND*cw*MW*sw**2)
    f( 44) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MT)/(4._/**/REALKIND*cw*MW*sw**2)
    f( 45) = (CI*eQED**3*MB)/(9._/**/REALKIND*MW*sw)
    f( 46) = (CI*eQED**3*MB)/(2._/**/REALKIND*MW*sw)
    f( 47) = (CI*eQED*gQCD**2*MB)/(2._/**/REALKIND*MW*sw)
    f( 48) = (CI*countertermnorm*eQED**3*gQCD**2*MB)/(9._/**/REALKIND*MW*sw)
    f( 49) = (CI*countertermnorm*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*MW*sw)
    f( 50) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(9._/**/REALKIND*MW*sw)
    f( 51) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*MW*sw)
    f( 52) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MB)/(9._/**/REALKIND*MW*sw)
    f( 53) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*MW*sw)
    f( 54) = (CI*countertermnorm*ctVtt*eQED**3*gQCD**2*MB)/(9._/**/REALKIND*MW*sw)
    f( 55) = (CI*countertermnorm*ctVtt*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*MW*sw)
    f( 56) = (CI*countertermnorm*eQED*gQCD**4*MB)/(2._/**/REALKIND*MW*sw)
    f( 57) = (CI*countertermnorm*ctGbb*eQED*gQCD**4*MB)/(2._/**/REALKIND*MW*sw)
    f( 58) = (CI*countertermnorm*ctGtt*eQED*gQCD**4*MB)/(2._/**/REALKIND*MW*sw)
    f( 59) = (CI*countertermnorm*ctSbb*eQED*gQCD**4*MB)/(2._/**/REALKIND*MW*sw)
    f( 60) = (CI*eQED**3*MT)/(9._/**/REALKIND*MW*sw)
    f( 61) = (CI*eQED**3*MT)/(2._/**/REALKIND*MW*sw)
    f( 62) = (CI*eQED*gQCD**2*MT)/(2._/**/REALKIND*MW*sw)
    f( 63) = (CI*countertermnorm*eQED**3*gQCD**2*MT)/(9._/**/REALKIND*MW*sw)
    f( 64) = (CI*countertermnorm*eQED**3*gQCD**2*MT)/(2._/**/REALKIND*MW*sw)
    f( 65) = (CI*countertermnorm*ctStt*eQED**3*gQCD**2*MT)/(9._/**/REALKIND*MW*sw)
    f( 66) = (CI*countertermnorm*ctStt*eQED**3*gQCD**2*MT)/(2._/**/REALKIND*MW*sw)
    f( 67) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MT)/(9._/**/REALKIND*MW*sw)
    f( 68) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MT)/(2._/**/REALKIND*MW*sw)
    f( 69) = (CI*countertermnorm*ctVtt*eQED**3*gQCD**2*MT)/(9._/**/REALKIND*MW*sw)
    f( 70) = (CI*countertermnorm*ctVtt*eQED**3*gQCD**2*MT)/(2._/**/REALKIND*MW*sw)
    f( 71) = (CI*countertermnorm*eQED*gQCD**4*MT)/(2._/**/REALKIND*MW*sw)
    f( 72) = (CI*countertermnorm*ctGbb*eQED*gQCD**4*MT)/(2._/**/REALKIND*MW*sw)
    f( 73) = (CI*countertermnorm*ctGtt*eQED*gQCD**4*MT)/(2._/**/REALKIND*MW*sw)
    f( 74) = (CI*countertermnorm*ctStt*eQED*gQCD**4*MT)/(2._/**/REALKIND*MW*sw)
    f( 75) = (CI*eQED**3*MW)/(cw**2*sw)
    f( 76) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MW)/(cw**2*sw)
    f( 77) = (CI*countertermnorm*ctVtt*eQED**3*gQCD**2*MW)/(cw**2*sw)
    f( 78) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f( 79) = (eQED**3*gQCD**2*integralnorm*MB**3*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f( 80) = (eQED**3*gQCD**2*integralnorm*MH**2*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f( 81) = (eQED**3*gQCD**2*integralnorm*MB**2*MH**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f( 82) = (3*eQED**3*gQCD**2*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f( 83) = (eQED**3*gQCD**2*integralnorm*MT*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f( 84) = (eQED**3*gQCD**2*integralnorm*MB**2*MT*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f( 85) = (eQED**3*gQCD**2*integralnorm*MB*MH**2*MT*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f( 86) = (3*eQED**3*gQCD**2*integralnorm*lambdaHHH*MB*MH**2*MT*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f( 87) = (eQED**3*gQCD**2*integralnorm*MB*MT**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f( 88) = (eQED**3*gQCD**2*integralnorm*MH**2*MT**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f( 89) = (3*eQED**3*gQCD**2*integralnorm*lambdaHHH*MH**2*MT**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f( 90) = (eQED**3*gQCD**2*integralnorm*MT**3*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f( 91) = (eQED**3*gQCD**2*integralnorm*SwB)/(MW*sw**3*4._/**/REALKIND)
    f( 92) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(MW*sw**3*4._/**/REALKIND)
    f( 93) = (eQED**3*gQCD**2*integralnorm*MT*SwB)/(MW*sw**3*4._/**/REALKIND)
    f( 94) = (eQED**3*gQCD**2*integralnorm*MW*SwB)/(sw**3*2._/**/REALKIND)
    f( 95) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f( 96) = (eQED**3*gQCD**2*integralnorm*MT*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f( 97) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(MW*sw*18._/**/REALKIND)
    f( 98) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(MW*sw*9._/**/REALKIND)
    f( 99) = (2*eQED**3*gQCD**2*integralnorm*MB*SwB)/(MW*sw*9._/**/REALKIND)
    f(100) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(MW*sw*2._/**/REALKIND)
    f(101) = (CI*eQED*gQCD**4*integralnorm*MB*SwB)/(2._/**/REALKIND*MW*sw)
    f(102) = (eQED*gQCD**4*integralnorm*MB*SwB)/(MW*sw*4._/**/REALKIND)
    f(103) = (eQED*gQCD**4*integralnorm*MB*SwB)/(MW*sw*2._/**/REALKIND)
    f(104) = (eQED**3*gQCD**2*integralnorm*MT*SwB)/(MW*sw*18._/**/REALKIND)
    f(105) = (eQED**3*gQCD**2*integralnorm*MT*SwB)/(MW*sw*9._/**/REALKIND)
    f(106) = (2*eQED**3*gQCD**2*integralnorm*MT*SwB)/(MW*sw*9._/**/REALKIND)
    f(107) = (eQED**3*gQCD**2*integralnorm*MT*SwB)/(MW*sw*2._/**/REALKIND)
    f(108) = (CI*eQED*gQCD**4*integralnorm*MT*SwB)/(2._/**/REALKIND*MW*sw)
    f(109) = (eQED*gQCD**4*integralnorm*MT*SwB)/(MW*sw*4._/**/REALKIND)
    f(110) = (eQED*gQCD**4*integralnorm*MT*SwB)/(MW*sw*2._/**/REALKIND)
    f(111) = (eQED**3*gQCD**2*integralnorm*MW*SwB)/(cw**2*sw)
    f(112) = (eQED*gQCD**4*integralnorm*MB*SwF)/(MW*sw*2._/**/REALKIND)
    f(113) = (eQED*gQCD**4*integralnorm*MB*SwF)/(MW*sw)
    f(114) = (eQED*gQCD**4*integralnorm*MT*SwF)/(MW*sw*2._/**/REALKIND)
    f(115) = (eQED*gQCD**4*integralnorm*MT*SwF)/(MW*sw)

  c = [ 6*f(78), 18*f(78), 48*f(78), 6*f(79), 18*f(79), 6*f(80), 18*f(80), 48*f(80), 6*f(81), 18*f(81), 6*f(82), 18*f(82), 6*f(83) &
    , 18*f(83), 48*f(83), 6*f(84), 18*f(84), 48*f(84), 6*f(85), 18*f(85), 48*f(85), 6*f(86), 18*f(86), 48*f(86), 6*f(87), 18*f(87) &
    , 48*f(87), 6*f(88), 18*f(88), 6*f(89), 18*f(89), 6*f(90), 18*f(90), 6*f(91), 18*f(91), 48*f(91), 6*f(92), 18*f(92), 48*f(92) &
    , 6*f(93), 18*f(93), 48*f(93), 6*f(94), 18*f(94), 48*f(94), 6*f(95), 18*f(95), 48*f(95), 6*f(96), 18*f(96), 48*f(96), 6*f(97) &
    , 18*f(97), 6*f(98), 18*f(98), 48*f(98), 6*f(99), 18*f(99), 6*f(100), 18*f(100), 48*f(100), 9*CI*f(101), 27*CI*f(101) &
    , 18*f(102), 54*f(102), f(103), 3*f(103), 6*f(103), 8*f(103), 10*f(103), 18*f(103), 21*f(103), 24*f(103), 54*f(103), 6*f(104) &
    , 18*f(104), 6*f(105), 18*f(105), 48*f(105), 6*f(106), 18*f(106), 6*f(107), 18*f(107), 48*f(107), 9*CI*f(108), 27*CI*f(108) &
    , 18*f(109), 54*f(109), f(110), 3*f(110), 6*f(110), 8*f(110), 10*f(110), 18*f(110), 21*f(110), 24*f(110), 54*f(110), 6*f(111) &
    , 18*f(111), 48*f(111), 3*f(112), 9*f(112), 3*f(113), 9*f(113), 3*f(114), 9*f(114), 3*f(115), 9*f(115) ]
  c = (1._/**/REALKIND / 36) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3) - MH2)+L(6,3))
  den(2) = 1 /((L(5,12) - MH2)+L(6,12))
  den(4) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(5) = 1 /((L(5,12) - MZ2)+L(6,12))
  den(7) = 1 /((L(5,20) - MB2)+L(6,20))
  den(10) = 1 /((L(5,3))+L(6,3))
  den(12) = 1 /((L(5,24) - MB2)+L(6,24))
  den(16) = 1 /((L(5,9) - MW2)+L(6,9))
  den(17) = 1 /((L(5,6) - MW2)+L(6,6))
  den(19) = 1 /((L(5,17) - MT2)+L(6,17))
  den(22) = 1 /((L(5,18) - MT2)+L(6,18))
  den(27) = 1 /((L(5,12))+L(6,12))
  den(33) = 1 /((L(5,28))+L(6,28))
  den(36) = 1 /((L(5,11) - MB2)+L(6,11))
  den(45) = 1 /((L(5,7) - MB2)+L(6,7))
  den(52) = 1 /((L(5,14) - MT2)+L(6,14))
  den(57) = 1 /((L(5,13) - MT2)+L(6,13))
  den(68) = 1 /((L(5,19))+L(6,19))
  den(79) = 1 /((L(5,19) - MH2)+L(6,19))
  den(81) = 1 /((L(5,19) - MZ2)+L(6,19))
  den(83) = 1 /((L(5,22) - MW2)+L(6,22))
  den(85) = 1 /((L(5,25) - MW2)+L(6,25))
  den(87) = 1 /((L(5,28) - MH2)+L(6,28))
  den(89) = 1 /((L(5,28) - MZ2)+L(6,28))

  ! denominators
  den(3) = den(1)*den(2)
  den(6) = den(4)*den(5)
  den(8) = den(1)*den(7)
  den(9) = den(4)*den(7)
  den(11) = den(7)*den(10)
  den(13) = den(1)*den(12)
  den(14) = den(4)*den(12)
  den(15) = den(10)*den(12)
  den(18) = den(16)*den(17)
  den(20) = den(17)*den(19)
  den(21) = den(12)*den(17)
  den(23) = den(16)*den(22)
  den(24) = den(7)*den(16)
  den(25) = den(2)*den(19)
  den(26) = den(5)*den(19)
  den(28) = den(19)*den(27)
  den(29) = den(2)*den(22)
  den(30) = den(5)*den(22)
  den(31) = den(22)*den(27)
  den(32) = den(10)*den(27)
  den(34) = den(7)*den(33)
  den(35) = den(10)*den(34)
  den(37) = den(1)*den(36)
  den(38) = den(7)*den(37)
  den(39) = den(4)*den(36)
  den(40) = den(7)*den(39)
  den(41) = den(10)*den(36)
  den(42) = den(7)*den(41)
  den(43) = den(12)*den(33)
  den(44) = den(10)*den(43)
  den(46) = den(1)*den(45)
  den(47) = den(12)*den(46)
  den(48) = den(4)*den(45)
  den(49) = den(12)*den(48)
  den(50) = den(10)*den(45)
  den(51) = den(12)*den(50)
  den(53) = den(17)*den(52)
  den(54) = den(19)*den(53)
  den(55) = den(17)*den(45)
  den(56) = den(12)*den(55)
  den(58) = den(16)*den(57)
  den(59) = den(22)*den(58)
  den(60) = den(16)*den(36)
  den(61) = den(7)*den(60)
  den(62) = den(2)*den(52)
  den(63) = den(19)*den(62)
  den(64) = den(5)*den(52)
  den(65) = den(19)*den(64)
  den(66) = den(27)*den(52)
  den(67) = den(19)*den(66)
  den(69) = den(19)*den(68)
  den(70) = den(27)*den(69)
  den(71) = den(2)*den(57)
  den(72) = den(22)*den(71)
  den(73) = den(5)*den(57)
  den(74) = den(22)*den(73)
  den(75) = den(27)*den(57)
  den(76) = den(22)*den(75)
  den(77) = den(22)*den(68)
  den(78) = den(27)*den(77)
  den(80) = den(1)*den(79)
  den(82) = den(4)*den(81)
  den(84) = den(17)*den(83)
  den(86) = den(16)*den(85)
  den(88) = den(2)*den(87)
  den(90) = den(5)*den(89)
  den(91) = den(19)*den(79)
  den(92) = den(19)*den(81)
  den(93) = den(19)*den(85)
  den(94) = den(22)*den(79)
  den(95) = den(22)*den(81)
  den(96) = den(22)*den(83)
  den(97) = den(7)*den(83)
  den(98) = den(7)*den(87)
  den(99) = den(7)*den(89)
  den(100) = den(12)*den(85)
  den(101) = den(12)*den(87)
  den(102) = den(12)*den(89)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_pphtt_ew_ttxbbxh_1_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,188))
  allocate(M1helarray(4,hel_states))
  allocate(M1helarray_ct(4,hel_states))
  allocate(M0_col1_helarray(4,hel_states))
#if 1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(4,hel_states,16))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
#else
recursive subroutine amp2(P_scatt, M02, qp_kinematics, M2ct, M2colint)
  use ol_loop_storage_pphtt_ew_ttxbbxh_1_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for top anti-top bottom anti-bottom higgs -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_pphtt_ew_ttxbbxh_1, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_pphtt_ew_ttxbbxh_1, only: &
    & external_perm_pphtt_ew_ttxbbxh_1, &
    & external_perm_inv_pphtt_ew_ttxbbxh_1, &
    & extcomb_perm_pphtt_ew_ttxbbxh_1, &
    & average_factor_pphtt_ew_ttxbbxh_1
  use ol_external_pphtt_ew_ttxbbxh_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_pphtt_ew_ttxbbxh_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pphtt_ew_ttxbbxh_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_pphtt_ew_ttxbbxh_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02
  logical, intent(in) :: qp_kinematics
  real(REALKIND),  intent(out), optional :: M2ct
  real(REALKIND),  intent(out), optional :: M2colint(16)
  real(REALKIND) :: iM2ct
  real(REALKIND) :: iM2colint(16)

  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(4), M2(4)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak
  logical              :: do_ct, do_colint
#if 5 > 3
  integer :: ind_cc_comb(5)
#endif
  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if (present(M2ct)) then
    do_ct = .true.
  else
    do_ct = .false.
  end if

  if (present(M2colint)) then
    do_colint = .true.
  else
    do_colint = .false.
  end if

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, qp_kinematics, M2ct=iM2ct, M2colint=iM2colint)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,188))
  end if

  if (do_ct) call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()
  if (do_ct) call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  if (do_ct) call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMT, nMT, nMB, nMB, nMH ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_pphtt_ew_ttxbbxh_1, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMT, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rMT, H2, ex2, POLSEL(2),2)
  call pol_wf_Q(P(:,3), rMB, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rMB, H4, ex4, POLSEL(4),4)
  call pol_wf_S(P(:,5), rMH, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_AQ_S(gH,ntry, ex4(:), ex3(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_SS_S(ntry, wf4(:,1), ex5(:), wf4(:,3), n3(:,3), t3x4(:,:,3))
  call vert_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,4), n3(:,4), t3x4(:,:,4))
  call vert_AQ_S(gX,ntry, ex4(:), ex3(:), wf4(:,5), n3(:,5), t3x4(:,:,5))
  call vert_SS_S(ntry, wf4(:,4), ex5(:), wf4(:,6), n3(:,6), t3x4(:,:,6))
  call vert_QA_Z(gZd,ntry, ex3(:), ex4(:), wf4(:,7), n3(:,7), t3x4(:,:,7))
  call vert_ST_V(ntry, wf4(:,4), 3, ex5(:), 16, wf4(:,8), n3(:,8), t3x4(:,:,8))
  call vert_QA_Z(gZu,ntry, ex1(:), ex2(:), wf4(:,9), n3(:,9), t3x4(:,:,9))
  call vert_TV_S(ntry, ex5(:), 16, wf4(:,9), 3, wf4(:,10), n3(:,10), t3x4(:,:,10))
  call vert_SV_V(ntry, ex5(:), wf4(:,9), wf4(:,11), n3(:,11), t3x4(:,:,11))
  call vert_QS_A(gH,ntry, ex3(:), ex5(:), wf2(:,1), n3(:,12), t3x2(:,:,1))
  call prop_Q_A(ntry, wf2(:,1), 20, MB, 1_intkind1, wf2(:,2), n2(1))
  call vert_SA_Q(gH,ntry, wf4(:,1), ex4(:), wf8(:,1), n3(:,13), t3x8(:,:,1))
  call vert_SA_Q(gX,ntry, wf4(:,4), ex4(:), wf8(:,2), n3(:,14), t3x8(:,:,2))
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,12), n3(:,15), t3x4(:,:,12))
  call vert_AV_Q(ntry, ex4(:), wf4(:,12), wf8(:,3), n3(:,16), t3x8(:,:,3))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,9), wf8(:,4), n3(:,17), t3x8(:,:,4))
  call vert_SA_Q(gH,ntry, ex5(:), ex4(:), wf2(:,3), n3(:,18), t3x2(:,:,2))
  call prop_A_Q(ntry, wf2(:,3), 24, MB, 1_intkind1, wf2(:,4), n2(2))
  call vert_QS_A(gH,ntry, ex3(:), wf4(:,1), wf8(:,5), n3(:,19), t3x8(:,:,5))
  call vert_QS_A(gX,ntry, ex3(:), wf4(:,4), wf8(:,6), n3(:,20), t3x8(:,:,6))
  call vert_VQ_A(ntry, wf4(:,12), ex3(:), wf8(:,7), n3(:,21), t3x8(:,:,7))
  call vert_ZQ_A(gZd,ntry, wf4(:,9), ex3(:), wf8(:,8), n3(:,22), t3x8(:,:,8))
  call vert_AQ_S(gPbt,ntry, ex4(:), ex1(:), wf4(:,13), n3(:,23), t3x4(:,:,13))
  call vert_AQ_S(gPtb,ntry, ex2(:), ex3(:), wf4(:,14), n3(:,24), t3x4(:,:,14))
  call vert_SS_S(ntry, wf4(:,13), ex5(:), wf4(:,15), n3(:,25), t3x4(:,:,15))
  call vert_QA_W(ntry, ex3(:), ex2(:), wf4(:,16), n3(:,26), t3x4(:,:,16))
  call vert_ST_V(ntry, wf4(:,13), 9, ex5(:), 16, wf4(:,17), n3(:,27), t3x4(:,:,17))
  call vert_QA_W(ntry, ex1(:), ex4(:), wf4(:,18), n3(:,28), t3x4(:,:,18))
  call vert_TV_S(ntry, ex5(:), 16, wf4(:,18), 9, wf4(:,19), n3(:,29), t3x4(:,:,19))
  call vert_SV_V(ntry, ex5(:), wf4(:,18), wf4(:,20), n3(:,30), t3x4(:,:,20))
  call vert_QS_A(gH,ntry, ex1(:), ex5(:), wf2(:,5), n3(:,31), t3x2(:,:,3))
  call prop_Q_A(ntry, wf2(:,5), 17, MT, 1_intkind1, wf2(:,6), n2(3))
  call vert_AQ_S(gPbt,ntry, ex4(:), wf2(:,6), wf4(:,21), n3(:,32), t3x4(:,:,21))
  call vert_QA_W(ntry, wf2(:,6), ex4(:), wf4(:,22), n3(:,33), t3x4(:,:,22))
  call vert_QS_A(gPbt,ntry, ex1(:), wf4(:,14), wf8(:,9), n3(:,34), t3x8(:,:,9))
  call vert_WQ_A(ntry, wf4(:,16), ex1(:), wf8(:,10), n3(:,35), t3x8(:,:,10))
  call vert_SA_Q(gH,ntry, ex5(:), ex2(:), wf2(:,7), n3(:,36), t3x2(:,:,4))
  call prop_A_Q(ntry, wf2(:,7), 18, MT, 1_intkind1, wf2(:,8), n2(4))
  call vert_QS_A(gPtb,ntry, ex3(:), wf4(:,13), wf8(:,11), n3(:,37), t3x8(:,:,11))
  call vert_WQ_A(ntry, wf4(:,18), ex3(:), wf8(:,12), n3(:,38), t3x8(:,:,12))
  call vert_SA_Q(gPtb,ntry, wf4(:,13), ex2(:), wf8(:,13), n3(:,39), t3x8(:,:,13))
  call vert_AW_Q(ntry, ex2(:), wf4(:,18), wf8(:,14), n3(:,40), t3x8(:,:,14))
  call vert_AQ_S(gH,ntry, ex2(:), wf2(:,6), wf4(:,23), n3(:,41), t3x4(:,:,23))
  call vert_AQ_S(gX,ntry, ex2(:), wf2(:,6), wf4(:,24), n3(:,42), t3x4(:,:,24))
  call vert_QA_V(ntry, ex3(:), ex4(:), wf4(:,25), n3(:,43), t3x4(:,:,25))
  call vert_QA_V(ntry, wf2(:,6), ex2(:), wf4(:,26), n3(:,44), t3x4(:,:,26))
  call vert_QA_Z(gZu,ntry, wf2(:,6), ex2(:), wf4(:,27), n3(:,45), t3x4(:,:,27))
  call vert_AQ_S(gH,ntry, wf2(:,8), ex1(:), wf4(:,28), n3(:,46), t3x4(:,:,28))
  call vert_AQ_S(gX,ntry, wf2(:,8), ex1(:), wf4(:,29), n3(:,47), t3x4(:,:,29))
  call vert_QA_V(ntry, ex1(:), wf2(:,8), wf4(:,30), n3(:,48), t3x4(:,:,30))
  call vert_QA_Z(gZu,ntry, ex1(:), wf2(:,8), wf4(:,31), n3(:,49), t3x4(:,:,31))
  call counter_SG_G(ntry, ex5(:), wf4(:,12), wf4(:,32), n3(:,50), t3x4(:,:,32))
  call counter_SA_Q(gH,ntry, wf4(:,1), ex4(:), wf8(:,15), n3(:,51), t3x8(:,:,15))
  call counter_SA_Q(gX,ntry, wf4(:,4), ex4(:), wf8(:,16), n3(:,52), t3x8(:,:,16))
  call counter_AV_Q(ntry, ex4(:), wf4(:,12), wf8(:,17), n3(:,53), t3x8(:,:,17))
  call counter_AZ_Q(gZd,ntry, ex4(:), wf4(:,9), wf8(:,18), n3(:,54), t3x8(:,:,18))
  call counter_AV_Q_LR(EWctGbb,ntry, ex4(:), wf4(:,12), wf8(:,19), n3(:,55), t3x8(:,:,19))
  call counter_SA_Q(gH,ntry, ex5(:), ex4(:), wf2(:,9), n3(:,56), t3x2(:,:,5))
  call prop_A_Q(ntry, wf2(:,9), 24, MB, 1_intkind1, wf2(:,10), n2(5))
  call counter_SA_Q(EWctHbb,ntry, ex5(:), ex4(:), wf2(:,11), n3(:,57), t3x2(:,:,6))
  call prop_A_Q(ntry, wf2(:,11), 24, MB, 1_intkind1, wf2(:,12), n2(6))
  call counter_QS_A(gH,ntry, ex3(:), wf4(:,1), wf8(:,20), n3(:,58), t3x8(:,:,20))
  call counter_QS_A(gX,ntry, ex3(:), wf4(:,4), wf8(:,21), n3(:,59), t3x8(:,:,21))
  call counter_VQ_A(ntry, wf4(:,12), ex3(:), wf8(:,22), n3(:,60), t3x8(:,:,22))
  call counter_ZQ_A(gZd,ntry, wf4(:,9), ex3(:), wf8(:,23), n3(:,61), t3x8(:,:,23))
  call counter_VQ_A_LR(EWctGbb,ntry, wf4(:,12), ex3(:), wf8(:,24), n3(:,62), t3x8(:,:,24))
  call counter_QS_A(gH,ntry, ex3(:), ex5(:), wf2(:,13), n3(:,63), t3x2(:,:,7))
  call prop_Q_A(ntry, wf2(:,13), 20, MB, 1_intkind1, wf2(:,14), n2(7))
  call counter_QS_A(EWctHbb,ntry, ex3(:), ex5(:), wf2(:,15), n3(:,64), t3x2(:,:,8))
  call prop_Q_A(ntry, wf2(:,15), 20, MB, 1_intkind1, wf2(:,16), n2(8))
  call counter_AQ_S(gH,ntry, ex4(:), ex3(:), wf4(:,33), n3(:,65), t3x4(:,:,33))
  call counter_AQ_S(gX,ntry, ex4(:), ex3(:), wf4(:,34), n3(:,66), t3x4(:,:,34))
  call counter_QA_Z(gZd,ntry, ex3(:), ex4(:), wf4(:,35), n3(:,67), t3x4(:,:,35))
  call counter_AQ_S(ctSbt,ntry, ex4(:), wf2(:,6), wf4(:,36), n3(:,68), t3x4(:,:,36))
  call counter_QA_W(ntry, wf2(:,6), ex4(:), wf4(:,37), n3(:,69), t3x4(:,:,37))
  call counter_QS_A(ctStb,ntry, ex3(:), wf4(:,13), wf8(:,25), n3(:,70), t3x8(:,:,25))
  call counter_WQ_A(ntry, wf4(:,18), ex3(:), wf8(:,26), n3(:,71), t3x8(:,:,26))
  call counter_QA_V(ntry, ex3(:), ex4(:), wf4(:,38), n3(:,72), t3x4(:,:,38))
  call counter_QA_V_LR(EWctGbb,ntry, ex3(:), ex4(:), wf4(:,39), n3(:,73), t3x4(:,:,39))
  call counter_SA_Q(ctStb,ntry, wf4(:,13), ex2(:), wf8(:,27), n3(:,74), t3x8(:,:,27))
  call counter_AW_Q(ntry, ex2(:), wf4(:,18), wf8(:,28), n3(:,75), t3x8(:,:,28))
  call counter_SA_Q(gH,ntry, ex5(:), ex2(:), wf2(:,17), n3(:,76), t3x2(:,:,9))
  call prop_A_Q(ntry, wf2(:,17), 18, MT, 1_intkind1, wf2(:,18), n2(9))
  call counter_AQ_S(gH,ntry, ex2(:), wf2(:,6), wf4(:,40), n3(:,77), t3x4(:,:,40))
  call counter_AQ_S(gX,ntry, ex2(:), wf2(:,6), wf4(:,41), n3(:,78), t3x4(:,:,41))
  call counter_QA_V(ntry, wf2(:,6), ex2(:), wf4(:,42), n3(:,79), t3x4(:,:,42))
  call counter_QA_Z(gZu,ntry, wf2(:,6), ex2(:), wf4(:,43), n3(:,80), t3x4(:,:,43))
  call counter_QA_V_LR(EWctGtt,ntry, wf2(:,6), ex2(:), wf4(:,44), n3(:,81), t3x4(:,:,44))
  call vert_AQ_S(gH,ntry, wf2(:,18), ex1(:), wf4(:,45), n3(:,82), t3x4(:,:,45))
  call vert_AQ_S(gX,ntry, wf2(:,18), ex1(:), wf4(:,46), n3(:,83), t3x4(:,:,46))
  call vert_QA_V(ntry, ex1(:), wf2(:,18), wf4(:,47), n3(:,84), t3x4(:,:,47))
  call vert_QA_Z(gZu,ntry, ex1(:), wf2(:,18), wf4(:,48), n3(:,85), t3x4(:,:,48))
  call counter_SA_Q(EWctHtt,ntry, ex5(:), ex2(:), wf2(:,19), n3(:,86), t3x2(:,:,10))
  call prop_A_Q(ntry, wf2(:,19), 18, MT, 1_intkind1, wf2(:,20), n2(10))
  call vert_QA_V(ntry, ex1(:), wf2(:,20), wf4(:,49), n3(:,87), t3x4(:,:,49))
  call counter_AQ_S(ctStb,ntry, ex2(:), ex3(:), wf4(:,50), n3(:,88), t3x4(:,:,50))
  call counter_QA_W(ntry, ex3(:), ex2(:), wf4(:,51), n3(:,89), t3x4(:,:,51))
  call vert_QS_A(gPbt,ntry, ex1(:), wf4(:,50), wf8(:,29), n3(:,90), t3x8(:,:,29))
  call vert_WQ_A(ntry, wf4(:,51), ex1(:), wf8(:,30), n3(:,91), t3x8(:,:,30))
  call counter_QS_A(ctSbt,ntry, ex1(:), wf4(:,14), wf8(:,31), n3(:,92), t3x8(:,:,31))
  call counter_WQ_A(ntry, wf4(:,16), ex1(:), wf8(:,32), n3(:,93), t3x8(:,:,32))
  call counter_QS_A(gH,ntry, ex1(:), ex5(:), wf2(:,21), n3(:,94), t3x2(:,:,11))
  call prop_Q_A(ntry, wf2(:,21), 17, MT, 1_intkind1, wf2(:,22), n2(11))
  call vert_AQ_S(gPbt,ntry, ex4(:), wf2(:,22), wf4(:,52), n3(:,95), t3x4(:,:,52))
  call vert_QA_W(ntry, wf2(:,22), ex4(:), wf4(:,53), n3(:,96), t3x4(:,:,53))
  call counter_AQ_S(ctSbt,ntry, ex4(:), ex1(:), wf4(:,54), n3(:,97), t3x4(:,:,54))
  call vert_SS_S(ntry, wf4(:,54), ex5(:), wf4(:,55), n3(:,98), t3x4(:,:,55))
  call vert_ST_V(ntry, wf4(:,54), 9, ex5(:), 16, wf4(:,56), n3(:,99), t3x4(:,:,56))
  call counter_QA_W(ntry, ex1(:), ex4(:), wf4(:,57), n3(:,100), t3x4(:,:,57))
  call vert_TV_S(ntry, ex5(:), 16, wf4(:,57), 9, wf4(:,58), n3(:,101), t3x4(:,:,58))
  call vert_SV_V(ntry, ex5(:), wf4(:,57), wf4(:,59), n3(:,102), t3x4(:,:,59))
  call counter_AQ_S(gH,ntry, wf2(:,8), ex1(:), wf4(:,60), n3(:,103), t3x4(:,:,60))
  call counter_AQ_S(gX,ntry, wf2(:,8), ex1(:), wf4(:,61), n3(:,104), t3x4(:,:,61))
  call counter_QA_V(ntry, ex1(:), wf2(:,8), wf4(:,62), n3(:,105), t3x4(:,:,62))
  call counter_QA_Z(gZu,ntry, ex1(:), wf2(:,8), wf4(:,63), n3(:,106), t3x4(:,:,63))
  call counter_QA_V_LR(EWctGtt,ntry, ex1(:), wf2(:,8), wf4(:,64), n3(:,107), t3x4(:,:,64))
  call vert_AQ_S(gH,ntry, ex2(:), wf2(:,22), wf4(:,65), n3(:,108), t3x4(:,:,65))
  call vert_AQ_S(gX,ntry, ex2(:), wf2(:,22), wf4(:,66), n3(:,109), t3x4(:,:,66))
  call vert_QA_V(ntry, wf2(:,22), ex2(:), wf4(:,67), n3(:,110), t3x4(:,:,67))
  call vert_QA_Z(gZu,ntry, wf2(:,22), ex2(:), wf4(:,68), n3(:,111), t3x4(:,:,68))
  call counter_QS_A(EWctHtt,ntry, ex1(:), ex5(:), wf2(:,23), n3(:,112), t3x2(:,:,12))
  call prop_Q_A(ntry, wf2(:,23), 17, MT, 1_intkind1, wf2(:,24), n2(12))
  call vert_QA_V(ntry, wf2(:,24), ex2(:), wf4(:,69), n3(:,113), t3x4(:,:,69))
  call vert_QS_A(gPtb,ntry, ex3(:), wf4(:,54), wf8(:,33), n3(:,114), t3x8(:,:,33))
  call vert_WQ_A(ntry, wf4(:,57), ex3(:), wf8(:,34), n3(:,115), t3x8(:,:,34))
  call vert_SA_Q(gPtb,ntry, wf4(:,54), ex2(:), wf8(:,35), n3(:,116), t3x8(:,:,35))
  call vert_AW_Q(ntry, ex2(:), wf4(:,57), wf8(:,36), n3(:,117), t3x8(:,:,36))
  call counter_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,70), n3(:,118), t3x4(:,:,70))
  call vert_SS_S(ntry, wf4(:,70), ex5(:), wf4(:,71), n3(:,119), t3x4(:,:,71))
  call counter_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,72), n3(:,120), t3x4(:,:,72))
  call vert_SS_S(ntry, wf4(:,72), ex5(:), wf4(:,73), n3(:,121), t3x4(:,:,73))
  call vert_ST_V(ntry, wf4(:,72), 3, ex5(:), 16, wf4(:,74), n3(:,122), t3x4(:,:,74))
  call counter_QA_Z(gZu,ntry, ex1(:), ex2(:), wf4(:,75), n3(:,123), t3x4(:,:,75))
  call vert_TV_S(ntry, ex5(:), 16, wf4(:,75), 3, wf4(:,76), n3(:,124), t3x4(:,:,76))
  call vert_SV_V(ntry, ex5(:), wf4(:,75), wf4(:,77), n3(:,125), t3x4(:,:,77))
  call vert_SA_Q(gH,ntry, wf4(:,70), ex4(:), wf8(:,37), n3(:,126), t3x8(:,:,37))
  call vert_SA_Q(gX,ntry, wf4(:,72), ex4(:), wf8(:,38), n3(:,127), t3x8(:,:,38))
  call counter_QA_V(ntry, ex1(:), ex2(:), wf4(:,78), n3(:,128), t3x4(:,:,78))
  call vert_AV_Q(ntry, ex4(:), wf4(:,78), wf8(:,39), n3(:,129), t3x8(:,:,39))
  call vert_AZ_Q(gZd,ntry, ex4(:), wf4(:,75), wf8(:,40), n3(:,130), t3x8(:,:,40))
  call counter_QA_V_LR(EWctGtt,ntry, ex1(:), ex2(:), wf4(:,79), n3(:,131), t3x4(:,:,79))
  call vert_AV_Q(ntry, ex4(:), wf4(:,79), wf8(:,41), n3(:,132), t3x8(:,:,41))
  call vert_QS_A(gH,ntry, ex3(:), wf4(:,70), wf8(:,42), n3(:,133), t3x8(:,:,42))
  call vert_QS_A(gX,ntry, ex3(:), wf4(:,72), wf8(:,43), n3(:,134), t3x8(:,:,43))
  call vert_VQ_A(ntry, wf4(:,78), ex3(:), wf8(:,44), n3(:,135), t3x8(:,:,44))
  call vert_ZQ_A(gZd,ntry, wf4(:,75), ex3(:), wf8(:,45), n3(:,136), t3x8(:,:,45))
  call vert_VQ_A(ntry, wf4(:,79), ex3(:), wf8(:,46), n3(:,137), t3x8(:,:,46))
  call vert_QA_V(ntry, wf2(:,2), ex4(:), wf4(:,80), n3(:,138), t3x4(:,:,80))
  call counter_V_V(ctGG,21,ntry, wf4(:,12), 3, wf4(:,81), n2(13))
  call counter_Q_A(ctbb,5,ntry, wf2(:,2), 20, wf2(:,25), n2(14))
  call prop_A_Q(ntry, wf8(:,1), 11, MB, 1_intkind1, wf8(:,47), n2(15))
  call prop_A_Q(ntry, wf8(:,2), 11, MB, 1_intkind1, wf8(:,48), n2(16))
  call prop_A_Q(ntry, wf8(:,3), 11, MB, 1_intkind1, wf8(:,49), n2(17))
  call prop_A_Q(ntry, wf8(:,4), 11, MB, 1_intkind1, wf8(:,50), n2(18))
  call counter_Q_A_LR(EWctbb,ntry, wf2(:,2), 20, wf2(:,26), n2(19))
  call vert_QA_V(ntry, ex3(:), wf2(:,4), wf4(:,82), n3(:,139), t3x4(:,:,81))
  call counter_A_Q(ctbb,5,ntry, wf2(:,4), 24, wf2(:,27), n2(20))
  call prop_Q_A(ntry, wf8(:,5), 7, MB, 1_intkind1, wf8(:,51), n2(21))
  call prop_Q_A(ntry, wf8(:,6), 7, MB, 1_intkind1, wf8(:,52), n2(22))
  call prop_Q_A(ntry, wf8(:,7), 7, MB, 1_intkind1, wf8(:,53), n2(23))
  call prop_Q_A(ntry, wf8(:,8), 7, MB, 1_intkind1, wf8(:,54), n2(24))
  call counter_A_Q_LR(EWctbb,ntry, wf2(:,4), 24, wf2(:,28), n2(25))
  call vert_SA_Q(gPbt,ntry, wf4(:,14), ex4(:), wf8(:,55), n3(:,140), t3x8(:,:,47))
  call counter_Q_A(cttt,6,ntry, wf2(:,6), 17, wf2(:,29), n2(26))
  call prop_A_Q(ntry, wf8(:,55), 14, MT, 1_intkind1, wf8(:,56), n2(27))
  call vert_AW_Q(ntry, ex4(:), wf4(:,16), wf8(:,57), n3(:,141), t3x8(:,:,48))
  call prop_A_Q(ntry, wf8(:,57), 14, MT, 1_intkind1, wf8(:,58), n2(28))
  call prop_Q_A(ntry, wf8(:,9), 7, MB, 1_intkind1, wf8(:,59), n2(29))
  call prop_Q_A(ntry, wf8(:,10), 7, MB, 1_intkind1, wf8(:,60), n2(30))
  call counter_A_Q(cttt,6,ntry, wf2(:,8), 18, wf2(:,30), n2(31))
  call prop_Q_A(ntry, wf8(:,11), 13, MT, 1_intkind1, wf8(:,61), n2(32))
  call prop_Q_A(ntry, wf8(:,12), 13, MT, 1_intkind1, wf8(:,62), n2(33))
  call prop_A_Q(ntry, wf8(:,13), 11, MB, 1_intkind1, wf8(:,63), n2(34))
  call prop_A_Q(ntry, wf8(:,14), 11, MB, 1_intkind1, wf8(:,64), n2(35))
  call vert_SA_Q(gH,ntry, wf4(:,2), ex2(:), wf8(:,65), n3(:,142), t3x8(:,:,49))
  call prop_A_Q(ntry, wf8(:,65), 14, MT, 1_intkind1, wf8(:,66), n2(36))
  call vert_SA_Q(gX,ntry, wf4(:,5), ex2(:), wf8(:,67), n3(:,143), t3x8(:,:,50))
  call prop_A_Q(ntry, wf8(:,67), 14, MT, 1_intkind1, wf8(:,68), n2(37))
  call vert_AV_Q(ntry, ex2(:), wf4(:,25), wf8(:,69), n3(:,144), t3x8(:,:,51))
  call prop_A_Q(ntry, wf8(:,69), 14, MT, 1_intkind1, wf8(:,70), n2(38))
  call vert_AZ_Q(gZu,ntry, ex2(:), wf4(:,7), wf8(:,71), n3(:,145), t3x8(:,:,52))
  call prop_A_Q(ntry, wf8(:,71), 14, MT, 1_intkind1, wf8(:,72), n2(39))
  call counter_Q_A_LR(EWcttt,ntry, wf2(:,6), 17, wf2(:,31), n2(40))
  call counter_V_V(ctGG,21,ntry, wf4(:,25), 12, wf4(:,83), n2(41))
  call vert_QS_A(gH,ntry, ex1(:), wf4(:,2), wf8(:,73), n3(:,146), t3x8(:,:,53))
  call prop_Q_A(ntry, wf8(:,73), 13, MT, 1_intkind1, wf8(:,74), n2(42))
  call vert_QS_A(gX,ntry, ex1(:), wf4(:,5), wf8(:,75), n3(:,147), t3x8(:,:,54))
  call prop_Q_A(ntry, wf8(:,75), 13, MT, 1_intkind1, wf8(:,76), n2(43))
  call vert_VQ_A(ntry, wf4(:,25), ex1(:), wf8(:,77), n3(:,148), t3x8(:,:,55))
  call prop_Q_A(ntry, wf8(:,77), 13, MT, 1_intkind1, wf8(:,78), n2(44))
  call vert_ZQ_A(gZu,ntry, wf4(:,7), ex1(:), wf8(:,79), n3(:,149), t3x8(:,:,56))
  call prop_Q_A(ntry, wf8(:,79), 13, MT, 1_intkind1, wf8(:,80), n2(45))
  call counter_A_Q_LR(EWcttt,ntry, wf2(:,8), 18, wf2(:,32), n2(46))
  call vert_SS_S(ntry, wf4(:,14), ex5(:), wf4(:,84), n3(:,150), t3x4(:,:,82))
  call vert_ST_V(ntry, wf4(:,14), 6, ex5(:), 16, wf4(:,85), n3(:,151), t3x4(:,:,83))
  call vert_TV_S(ntry, ex5(:), 16, wf4(:,16), 6, wf4(:,86), n3(:,152), t3x4(:,:,84))
  call vert_SV_V(ntry, ex5(:), wf4(:,16), wf4(:,87), n3(:,153), t3x4(:,:,85))
  call vert_SS_S(ntry, wf4(:,2), ex5(:), wf4(:,88), n3(:,154), t3x4(:,:,86))
  call vert_SS_S(ntry, wf4(:,5), ex5(:), wf4(:,89), n3(:,155), t3x4(:,:,87))
  call vert_ST_V(ntry, wf4(:,5), 12, ex5(:), 16, wf4(:,90), n3(:,156), t3x4(:,:,88))
  call vert_TV_S(ntry, ex5(:), 16, wf4(:,7), 12, wf4(:,91), n3(:,157), t3x4(:,:,89))
  call vert_SV_V(ntry, ex5(:), wf4(:,7), wf4(:,92), n3(:,158), t3x4(:,:,90))
  call vert_AQ_S(gPtb,ntry, wf2(:,8), ex3(:), wf4(:,93), n3(:,159), t3x4(:,:,91))
  call vert_QA_W(ntry, ex3(:), wf2(:,8), wf4(:,94), n3(:,160), t3x4(:,:,92))
  call vert_AQ_S(gPtb,ntry, ex2(:), wf2(:,2), wf4(:,95), n3(:,161), t3x4(:,:,93))
  call vert_QA_W(ntry, wf2(:,2), ex2(:), wf4(:,96), n3(:,162), t3x4(:,:,94))
  call vert_AQ_S(gH,ntry, ex4(:), wf2(:,2), wf4(:,97), n3(:,163), t3x4(:,:,95))
  call vert_AQ_S(gX,ntry, ex4(:), wf2(:,2), wf4(:,98), n3(:,164), t3x4(:,:,96))
  call vert_QA_Z(gZd,ntry, wf2(:,2), ex4(:), wf4(:,99), n3(:,165), t3x4(:,:,97))
  call vert_AQ_S(gPbt,ntry, wf2(:,4), ex1(:), wf4(:,100), n3(:,166), t3x4(:,:,98))
  call vert_QA_W(ntry, ex1(:), wf2(:,4), wf4(:,101), n3(:,167), t3x4(:,:,99))
  call vert_AQ_S(gH,ntry, wf2(:,4), ex3(:), wf4(:,102), n3(:,168), t3x4(:,:,100))
  call vert_AQ_S(gX,ntry, wf2(:,4), ex3(:), wf4(:,103), n3(:,169), t3x4(:,:,101))
  call vert_QA_Z(gZd,ntry, ex3(:), wf2(:,4), wf4(:,104), n3(:,170), t3x4(:,:,102))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    if (do_ct) call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  if (do_ct) M2ct = 0
  if (do_colint) M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    if (do_ct) call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      if (do_colint) call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    if (do_ct) M2ct = M2ct + M2add_ct
    if (do_colint) M2colint = M2colint + M2add_colint
  end do

#if 1 > 0 && 5 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    ind_cc_comb = [2,4,7,5,8]
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 5
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 1
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_SS(nsync, wf4(:,2), wf4(:,3), A(:,1), n3(:,171), t3x16(:,:,1), nhel, den(3))
    call Hcont_SS(nsync, wf4(:,5), wf4(:,6), A(:,2), n3(:,172), t3x16(:,:,2), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,8), A(:,3), n3(:,173), t3x16(:,:,3), nhel, den(6))
    call Hcont_SS(nsync, wf4(:,5), wf4(:,10), A(:,4), n3(:,174), t3x16(:,:,4), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,11), A(:,5), n3(:,175), t3x16(:,:,5), nhel, den(6))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,1), A(:,6), n3(:,176), t3x16(:,:,6), nhel, den(8))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,2), A(:,7), n3(:,177), t3x16(:,:,7), nhel, den(9))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,3), A(:,8), n3(:,178), t3x16(:,:,8), nhel, den(11))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,4), A(:,9), n3(:,179), t3x16(:,:,9), nhel, den(9))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,3), A(:,10), n3(:,180), t3x16(:,:,10), nhel, den(11))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,5), A(:,11), n3(:,181), t3x16(:,:,11), nhel, den(13))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,6), A(:,12), n3(:,182), t3x16(:,:,12), nhel, den(14))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,7), A(:,13), n3(:,183), t3x16(:,:,13), nhel, den(15))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,8), A(:,14), n3(:,184), t3x16(:,:,14), nhel, den(14))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,7), A(:,15), n3(:,185), t3x16(:,:,15), nhel, den(15))
    call Hcont_SS(nsync, wf4(:,14), wf4(:,15), A(:,16), n3(:,186), t3x16(:,:,16), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,16), wf4(:,17), A(:,17), n3(:,187), t3x16(:,:,17), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,14), wf4(:,19), A(:,18), n3(:,188), t3x16(:,:,18), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,16), wf4(:,20), A(:,19), n3(:,189), t3x16(:,:,19), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,14), wf4(:,21), A(:,20), n3(:,190), t3x16(:,:,20), nhel, den(20))
    call Hcont_VV(nsync, wf4(:,16), wf4(:,22), A(:,21), n3(:,191), t3x16(:,:,21), nhel, den(20))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,9), A(:,22), n3(:,192), t3x16(:,:,22), nhel, den(21))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,10), A(:,23), n3(:,193), t3x16(:,:,23), nhel, den(21))
    call Hcont_QA(nsync, wf2(:,8), wf8(:,11), A(:,24), n3(:,194), t3x16(:,:,24), nhel, den(23))
    call Hcont_QA(nsync, wf2(:,8), wf8(:,12), A(:,25), n3(:,195), t3x16(:,:,25), nhel, den(23))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,13), A(:,26), n3(:,196), t3x16(:,:,26), nhel, den(24))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,14), A(:,27), n3(:,197), t3x16(:,:,27), nhel, den(24))
    call Hcont_SS(nsync, wf4(:,2), wf4(:,23), A(:,28), n3(:,198), t3x16(:,:,28), nhel, den(25))
    call Hcont_SS(nsync, wf4(:,5), wf4(:,24), A(:,29), n3(:,199), t3x16(:,:,29), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,26), A(:,30), n3(:,200), t3x16(:,:,30), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,27), A(:,31), n3(:,201), t3x16(:,:,31), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,26), A(:,32), n3(:,202), t3x16(:,:,32), nhel, den(28))
    call Hcont_SS(nsync, wf4(:,2), wf4(:,28), A(:,33), n3(:,203), t3x16(:,:,33), nhel, den(29))
    call Hcont_SS(nsync, wf4(:,5), wf4(:,29), A(:,34), n3(:,204), t3x16(:,:,34), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,30), A(:,35), n3(:,205), t3x16(:,:,35), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,31), A(:,36), n3(:,206), t3x16(:,:,36), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,30), A(:,37), n3(:,207), t3x16(:,:,37), nhel, den(31))

    call Hcont_VV(nsync, wf4(:,25), wf4(:,32), A(:,38), n3(:,208), t3x16(:,:,38), nhel, den(32))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,15), A(:,39), n3(:,209), t3x16(:,:,39), nhel, den(8))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,16), A(:,40), n3(:,210), t3x16(:,:,40), nhel, den(9))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,17), A(:,41), n3(:,211), t3x16(:,:,41), nhel, den(11))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,18), A(:,42), n3(:,212), t3x16(:,:,42), nhel, den(9))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,17), A(:,43), n3(:,213), t3x16(:,:,43), nhel, den(11))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,19), A(:,44), n3(:,214), t3x16(:,:,44), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,5), wf2(:,10), A(:,45), n3(:,215), t3x16(:,:,45), nhel, den(13))
    call Hcont_QA(nsync, wf8(:,6), wf2(:,10), A(:,46), n3(:,216), t3x16(:,:,46), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,7), wf2(:,10), A(:,47), n3(:,217), t3x16(:,:,47), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,8), wf2(:,10), A(:,48), n3(:,218), t3x16(:,:,48), nhel, den(14))
    call Hcont_QA(nsync, wf8(:,7), wf2(:,10), A(:,49), n3(:,219), t3x16(:,:,49), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,7), wf2(:,12), A(:,50), n3(:,220), t3x16(:,:,50), nhel, den(15))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,20), A(:,51), n3(:,221), t3x16(:,:,51), nhel, den(13))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,21), A(:,52), n3(:,222), t3x16(:,:,52), nhel, den(14))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,22), A(:,53), n3(:,223), t3x16(:,:,53), nhel, den(15))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,23), A(:,54), n3(:,224), t3x16(:,:,54), nhel, den(14))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,22), A(:,55), n3(:,225), t3x16(:,:,55), nhel, den(15))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,24), A(:,56), n3(:,226), t3x16(:,:,56), nhel, den(15))
    call Hcont_QA(nsync, wf8(:,1), wf2(:,14), A(:,57), n3(:,227), t3x16(:,:,57), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,2), wf2(:,14), A(:,58), n3(:,228), t3x16(:,:,58), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,3), wf2(:,14), A(:,59), n3(:,229), t3x16(:,:,59), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,4), wf2(:,14), A(:,60), n3(:,230), t3x16(:,:,60), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,3), wf2(:,14), A(:,61), n3(:,231), t3x16(:,:,61), nhel, den(11))
    call Hcont_QA(nsync, wf8(:,3), wf2(:,16), A(:,62), n3(:,232), t3x16(:,:,62), nhel, den(11))
    call Hcont_SS(nsync, wf4(:,3), wf4(:,33), A(:,63), n3(:,233), t3x16(:,:,63), nhel, den(3))
    call Hcont_SS(nsync, wf4(:,6), wf4(:,34), A(:,64), n3(:,234), t3x16(:,:,64), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,8), wf4(:,35), A(:,65), n3(:,235), t3x16(:,:,65), nhel, den(6))
    call Hcont_SS(nsync, wf4(:,10), wf4(:,34), A(:,66), n3(:,236), t3x16(:,:,66), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,11), wf4(:,35), A(:,67), n3(:,237), t3x16(:,:,67), nhel, den(6))
    call Hcont_SS(nsync, wf4(:,14), wf4(:,36), A(:,68), n3(:,238), t3x16(:,:,68), nhel, den(20))
    call Hcont_VV(nsync, wf4(:,16), wf4(:,37), A(:,69), n3(:,239), t3x16(:,:,69), nhel, den(20))
    call Hcont_QA(nsync, wf8(:,9), wf2(:,10), A(:,70), n3(:,240), t3x16(:,:,70), nhel, den(21))
    call Hcont_QA(nsync, wf8(:,10), wf2(:,10), A(:,71), n3(:,241), t3x16(:,:,71), nhel, den(21))
    call Hcont_QA(nsync, wf2(:,8), wf8(:,25), A(:,72), n3(:,242), t3x16(:,:,72), nhel, den(23))
    call Hcont_QA(nsync, wf2(:,8), wf8(:,26), A(:,73), n3(:,243), t3x16(:,:,73), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,13), wf2(:,14), A(:,74), n3(:,244), t3x16(:,:,74), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,14), wf2(:,14), A(:,75), n3(:,245), t3x16(:,:,75), nhel, den(24))
    call Hcont_SS(nsync, wf4(:,23), wf4(:,33), A(:,76), n3(:,246), t3x16(:,:,76), nhel, den(25))
    call Hcont_SS(nsync, wf4(:,24), wf4(:,34), A(:,77), n3(:,247), t3x16(:,:,77), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,26), wf4(:,38), A(:,78), n3(:,248), t3x16(:,:,78), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,27), wf4(:,35), A(:,79), n3(:,249), t3x16(:,:,79), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,26), wf4(:,38), A(:,80), n3(:,250), t3x16(:,:,80), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,26), wf4(:,39), A(:,81), n3(:,251), t3x16(:,:,81), nhel, den(28))
    call Hcont_SS(nsync, wf4(:,28), wf4(:,33), A(:,82), n3(:,252), t3x16(:,:,82), nhel, den(29))
    call Hcont_SS(nsync, wf4(:,29), wf4(:,34), A(:,83), n3(:,253), t3x16(:,:,83), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,30), wf4(:,38), A(:,84), n3(:,254), t3x16(:,:,84), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,31), wf4(:,35), A(:,85), n3(:,255), t3x16(:,:,85), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,30), wf4(:,38), A(:,86), n3(:,256), t3x16(:,:,86), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,30), wf4(:,39), A(:,87), n3(:,257), t3x16(:,:,87), nhel, den(31))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,27), A(:,88), n3(:,258), t3x16(:,:,88), nhel, den(24))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,28), A(:,89), n3(:,259), t3x16(:,:,89), nhel, den(24))
    call Hcont_QA(nsync, wf8(:,11), wf2(:,18), A(:,90), n3(:,260), t3x16(:,:,90), nhel, den(23))
    call Hcont_QA(nsync, wf8(:,12), wf2(:,18), A(:,91), n3(:,261), t3x16(:,:,91), nhel, den(23))
    call Hcont_SS(nsync, wf4(:,2), wf4(:,40), A(:,92), n3(:,262), t3x16(:,:,92), nhel, den(25))
    call Hcont_SS(nsync, wf4(:,5), wf4(:,41), A(:,93), n3(:,263), t3x16(:,:,93), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,42), A(:,94), n3(:,264), t3x16(:,:,94), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,43), A(:,95), n3(:,265), t3x16(:,:,95), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,42), A(:,96), n3(:,266), t3x16(:,:,96), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,44), A(:,97), n3(:,267), t3x16(:,:,97), nhel, den(28))
    call Hcont_SS(nsync, wf4(:,2), wf4(:,45), A(:,98), n3(:,268), t3x16(:,:,98), nhel, den(29))
    call Hcont_SS(nsync, wf4(:,5), wf4(:,46), A(:,99), n3(:,269), t3x16(:,:,99), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,47), A(:,100), n3(:,270), t3x16(:,:,100), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,48), A(:,101), n3(:,271), t3x16(:,:,101), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,47), A(:,102), n3(:,272), t3x16(:,:,102), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,49), A(:,103), n3(:,273), t3x16(:,:,103), nhel, den(31))
    call Hcont_SS(nsync, wf4(:,15), wf4(:,50), A(:,104), n3(:,274), t3x16(:,:,104), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,17), wf4(:,51), A(:,105), n3(:,275), t3x16(:,:,105), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,19), wf4(:,50), A(:,106), n3(:,276), t3x16(:,:,106), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,20), wf4(:,51), A(:,107), n3(:,277), t3x16(:,:,107), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,21), wf4(:,50), A(:,108), n3(:,278), t3x16(:,:,108), nhel, den(20))
    call Hcont_VV(nsync, wf4(:,22), wf4(:,51), A(:,109), n3(:,279), t3x16(:,:,109), nhel, den(20))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,29), A(:,110), n3(:,280), t3x16(:,:,110), nhel, den(21))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,30), A(:,111), n3(:,281), t3x16(:,:,111), nhel, den(21))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,31), A(:,112), n3(:,282), t3x16(:,:,112), nhel, den(21))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,32), A(:,113), n3(:,283), t3x16(:,:,113), nhel, den(21))
    call Hcont_SS(nsync, wf4(:,14), wf4(:,52), A(:,114), n3(:,284), t3x16(:,:,114), nhel, den(20))
    call Hcont_VV(nsync, wf4(:,16), wf4(:,53), A(:,115), n3(:,285), t3x16(:,:,115), nhel, den(20))
    call Hcont_SS(nsync, wf4(:,14), wf4(:,55), A(:,116), n3(:,286), t3x16(:,:,116), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,16), wf4(:,56), A(:,117), n3(:,287), t3x16(:,:,117), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,14), wf4(:,58), A(:,118), n3(:,288), t3x16(:,:,118), nhel, den(18))
    call Hcont_VV(nsync, wf4(:,16), wf4(:,59), A(:,119), n3(:,289), t3x16(:,:,119), nhel, den(18))
    call Hcont_SS(nsync, wf4(:,2), wf4(:,60), A(:,120), n3(:,290), t3x16(:,:,120), nhel, den(29))
    call Hcont_SS(nsync, wf4(:,5), wf4(:,61), A(:,121), n3(:,291), t3x16(:,:,121), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,62), A(:,122), n3(:,292), t3x16(:,:,122), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,63), A(:,123), n3(:,293), t3x16(:,:,123), nhel, den(30))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,62), A(:,124), n3(:,294), t3x16(:,:,124), nhel, den(31))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,64), A(:,125), n3(:,295), t3x16(:,:,125), nhel, den(31))
    call Hcont_SS(nsync, wf4(:,2), wf4(:,65), A(:,126), n3(:,296), t3x16(:,:,126), nhel, den(25))
    call Hcont_SS(nsync, wf4(:,5), wf4(:,66), A(:,127), n3(:,297), t3x16(:,:,127), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,67), A(:,128), n3(:,298), t3x16(:,:,128), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,68), A(:,129), n3(:,299), t3x16(:,:,129), nhel, den(26))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,67), A(:,130), n3(:,300), t3x16(:,:,130), nhel, den(28))
    call Hcont_VV(nsync, wf4(:,25), wf4(:,69), A(:,131), n3(:,301), t3x16(:,:,131), nhel, den(28))
    call Hcont_QA(nsync, wf2(:,8), wf8(:,33), A(:,132), n3(:,302), t3x16(:,:,132), nhel, den(23))
    call Hcont_QA(nsync, wf2(:,8), wf8(:,34), A(:,133), n3(:,303), t3x16(:,:,133), nhel, den(23))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,35), A(:,134), n3(:,304), t3x16(:,:,134), nhel, den(24))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,36), A(:,135), n3(:,305), t3x16(:,:,135), nhel, den(24))
    call Hcont_SS(nsync, wf4(:,2), wf4(:,71), A(:,136), n3(:,306), t3x16(:,:,136), nhel, den(3))
    call Hcont_SS(nsync, wf4(:,5), wf4(:,73), A(:,137), n3(:,307), t3x16(:,:,137), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,74), A(:,138), n3(:,308), t3x16(:,:,138), nhel, den(6))
    call Hcont_SS(nsync, wf4(:,5), wf4(:,76), A(:,139), n3(:,309), t3x16(:,:,139), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,7), wf4(:,77), A(:,140), n3(:,310), t3x16(:,:,140), nhel, den(6))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,37), A(:,141), n3(:,311), t3x16(:,:,141), nhel, den(8))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,38), A(:,142), n3(:,312), t3x16(:,:,142), nhel, den(9))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,39), A(:,143), n3(:,313), t3x16(:,:,143), nhel, den(11))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,40), A(:,144), n3(:,314), t3x16(:,:,144), nhel, den(9))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,39), A(:,145), n3(:,315), t3x16(:,:,145), nhel, den(11))
    call Hcont_QA(nsync, wf2(:,2), wf8(:,41), A(:,146), n3(:,316), t3x16(:,:,146), nhel, den(11))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,42), A(:,147), n3(:,317), t3x16(:,:,147), nhel, den(13))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,43), A(:,148), n3(:,318), t3x16(:,:,148), nhel, den(14))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,44), A(:,149), n3(:,319), t3x16(:,:,149), nhel, den(15))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,45), A(:,150), n3(:,320), t3x16(:,:,150), nhel, den(14))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,44), A(:,151), n3(:,321), t3x16(:,:,151), nhel, den(15))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,46), A(:,152), n3(:,322), t3x16(:,:,152), nhel, den(15))
    call Hcont_VV(nsync, wf4(:,80), wf4(:,81), A(:,153), n3(:,323), t3x16(:,:,153), nhel, den(35))
    call Hcont_QA(nsync, wf2(:,25), wf8(:,47), A(:,154), n3(:,324), t3x16(:,:,154), nhel, den(38))
    call Hcont_QA(nsync, wf2(:,25), wf8(:,48), A(:,155), n3(:,325), t3x16(:,:,155), nhel, den(40))
    call Hcont_QA(nsync, wf2(:,25), wf8(:,49), A(:,156), n3(:,326), t3x16(:,:,156), nhel, den(42))
    call Hcont_QA(nsync, wf2(:,25), wf8(:,50), A(:,157), n3(:,327), t3x16(:,:,157), nhel, den(40))
    call Hcont_QA(nsync, wf2(:,25), wf8(:,49), A(:,158), n3(:,328), t3x16(:,:,158), nhel, den(42))
    call Hcont_QA(nsync, wf8(:,49), wf2(:,26), A(:,159), n3(:,329), t3x16(:,:,159), nhel, den(42))
    call Hcont_VV(nsync, wf4(:,81), wf4(:,82), A(:,160), n3(:,330), t3x16(:,:,160), nhel, den(44))
    call Hcont_QA(nsync, wf2(:,27), wf8(:,51), A(:,161), n3(:,331), t3x16(:,:,161), nhel, den(47))
    call Hcont_QA(nsync, wf2(:,27), wf8(:,52), A(:,162), n3(:,332), t3x16(:,:,162), nhel, den(49))
    call Hcont_QA(nsync, wf2(:,27), wf8(:,53), A(:,163), n3(:,333), t3x16(:,:,163), nhel, den(51))
    call Hcont_QA(nsync, wf2(:,27), wf8(:,54), A(:,164), n3(:,334), t3x16(:,:,164), nhel, den(49))
    call Hcont_QA(nsync, wf2(:,27), wf8(:,53), A(:,165), n3(:,335), t3x16(:,:,165), nhel, den(51))
    call Hcont_QA(nsync, wf8(:,53), wf2(:,28), A(:,166), n3(:,336), t3x16(:,:,166), nhel, den(51))
    call Hcont_QA(nsync, wf2(:,29), wf8(:,56), A(:,167), n3(:,337), t3x16(:,:,167), nhel, den(54))
    call Hcont_QA(nsync, wf2(:,29), wf8(:,58), A(:,168), n3(:,338), t3x16(:,:,168), nhel, den(54))
    call Hcont_QA(nsync, wf2(:,27), wf8(:,59), A(:,169), n3(:,339), t3x16(:,:,169), nhel, den(56))
    call Hcont_QA(nsync, wf2(:,27), wf8(:,60), A(:,170), n3(:,340), t3x16(:,:,170), nhel, den(56))
    call Hcont_QA(nsync, wf2(:,30), wf8(:,61), A(:,171), n3(:,341), t3x16(:,:,171), nhel, den(59))
    call Hcont_QA(nsync, wf2(:,30), wf8(:,62), A(:,172), n3(:,342), t3x16(:,:,172), nhel, den(59))
    call Hcont_QA(nsync, wf2(:,25), wf8(:,63), A(:,173), n3(:,343), t3x16(:,:,173), nhel, den(61))
    call Hcont_QA(nsync, wf2(:,25), wf8(:,64), A(:,174), n3(:,344), t3x16(:,:,174), nhel, den(61))
    call Hcont_QA(nsync, wf2(:,29), wf8(:,66), A(:,175), n3(:,345), t3x16(:,:,175), nhel, den(63))
    call Hcont_QA(nsync, wf2(:,29), wf8(:,68), A(:,176), n3(:,346), t3x16(:,:,176), nhel, den(65))
    call Hcont_QA(nsync, wf2(:,29), wf8(:,70), A(:,177), n3(:,347), t3x16(:,:,177), nhel, den(67))
    call Hcont_QA(nsync, wf2(:,29), wf8(:,72), A(:,178), n3(:,348), t3x16(:,:,178), nhel, den(65))
    call Hcont_QA(nsync, wf2(:,29), wf8(:,70), A(:,179), n3(:,349), t3x16(:,:,179), nhel, den(67))
    call Hcont_QA(nsync, wf8(:,70), wf2(:,31), A(:,180), n3(:,350), t3x16(:,:,180), nhel, den(67))
    call Hcont_VV(nsync, wf4(:,26), wf4(:,83), A(:,181), n3(:,351), t3x16(:,:,181), nhel, den(70))
    call Hcont_QA(nsync, wf2(:,30), wf8(:,74), A(:,182), n3(:,352), t3x16(:,:,182), nhel, den(72))
    call Hcont_QA(nsync, wf2(:,30), wf8(:,76), A(:,183), n3(:,353), t3x16(:,:,183), nhel, den(74))
    call Hcont_QA(nsync, wf2(:,30), wf8(:,78), A(:,184), n3(:,354), t3x16(:,:,184), nhel, den(76))
    call Hcont_QA(nsync, wf2(:,30), wf8(:,80), A(:,185), n3(:,355), t3x16(:,:,185), nhel, den(74))
    call Hcont_QA(nsync, wf2(:,30), wf8(:,78), A(:,186), n3(:,356), t3x16(:,:,186), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,78), wf2(:,32), A(:,187), n3(:,357), t3x16(:,:,187), nhel, den(76))
    call Hcont_VV(nsync, wf4(:,30), wf4(:,83), A(:,188), n3(:,358), t3x16(:,:,188), nhel, den(78))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(4), M2(4) ! M1helarray(4,nhel)
  integer :: empty(0), i

  M1(1)%j = (-A(j,22)%j-A(j,26)%j)*f(4)-A(j,16)%j*f(7)+(-A(j,20)%j-A(j,24)%j)*f(9)+(-A(j,17)%j-A(j,18)%j)*f(26)+(-A(j,23)%j &
       -A(j,27)%j)*f(29)+(-A(j,21)%j-A(j,25)%j)*f(33)-A(j,19)%j*f(37)
  M1(2)%j = ((A(j,10)%j+A(j,15)%j)*f(47))/2._/**/REALKIND+((A(j,32)%j+A(j,37)%j)*f(62))/2._/**/REALKIND
  M1(3)%j = (-A(j,6)%j-A(j,7)%j-A(j,11)%j-A(j,12)%j)*f(12)-A(j,2)%j*f(16)-A(j,1)%j*f(19)+(-A(j,28)%j-A(j,29)%j-A(j,33)%j &
       -A(j,34)%j)*f(22)-A(j,4)%j*f(39)+A(j,3)%j*f(42)+(-A(j,8)%j-A(j,13)%j)*f(45)+(A(j,9)%j+A(j,14)%j)*f(46)+(-A(j,30)%j &
       -A(j,35)%j)*f(60)+(A(j,31)%j+A(j,36)%j)*f(61)+A(j,5)%j*f(75)
  M1(4)%j = ((-A(j,10)%j-A(j,15)%j)*f(47))/6._/**/REALKIND+((-A(j,32)%j-A(j,37)%j)*f(62))/6._/**/REALKIND

  M2(1)%j = ((-A(j,50)%j-A(j,62)%j)*f(2))/2._/**/REALKIND+((-A(j,103)%j-A(j,131)%j)*f(3))/2._/**/REALKIND+(-A(j,88)%j-A(j,110)%j &
       -A(j,112)%j-A(j,134)%j+A(j,169)%j+A(j,173)%j)*f(5)+(-A(j,70)%j-A(j,74)%j)*f(6)+(-A(j,104)%j-A(j,116)%j)*f(8)+(-A(j,68)%j &
       -A(j,72)%j-A(j,108)%j-A(j,132)%j+A(j,167)%j+A(j,171)%j)*f(10)+(-A(j,90)%j-A(j,114)%j)*f(11)+(-A(j,106)%j-A(j,117)%j)*f(27) &
       +(-A(j,105)%j-A(j,118)%j)*f(28)+(A(j,170)%j+A(j,174)%j)*f(30)+(-A(j,71)%j-A(j,75)%j)*f(31)+(-A(j,89)%j-A(j,111)%j &
       -A(j,113)%j-A(j,135)%j)*f(32)+(A(j,168)%j+A(j,172)%j)*f(34)+(-A(j,91)%j-A(j,115)%j)*f(35)+(-A(j,69)%j-A(j,73)%j-A(j,109)%j &
       -A(j,133)%j)*f(36)+(-A(j,107)%j-A(j,119)%j)*f(38)+((A(j,44)%j+A(j,56)%j+A(j,146)%j+A(j,152)%j-A(j,159)%j &
       -A(j,166)%j)*f(49))/2._/**/REALKIND+((A(j,81)%j+A(j,87)%j+A(j,97)%j+A(j,125)%j-A(j,180)%j &
       -A(j,187)%j)*f(64))/2._/**/REALKIND
  M2(2)%j = (A(j,38)%j*f(1))/2._/**/REALKIND+((-A(j,153)%j-A(j,158)%j-A(j,160)%j-A(j,165)%j)*f(56))/2._/**/REALKIND+((A(j,43)%j &
       +A(j,55)%j)*f(57))/2._/**/REALKIND+((A(j,145)%j+A(j,151)%j)*f(58))/2._/**/REALKIND+((A(j,49)%j &
       +A(j,61)%j)*f(59))/2._/**/REALKIND+((-A(j,179)%j-A(j,181)%j-A(j,186)%j-A(j,188)%j)*f(71))/2._/**/REALKIND+((A(j,80)%j &
       +A(j,86)%j)*f(72))/2._/**/REALKIND+((A(j,96)%j+A(j,124)%j)*f(73))/2._/**/REALKIND+((A(j,102)%j &
       +A(j,130)%j)*f(74))/2._/**/REALKIND
  M2(3)%j = ((A(j,50)%j+A(j,62)%j)*f(2))/6._/**/REALKIND+((A(j,103)%j+A(j,131)%j)*f(3))/6._/**/REALKIND+(A(j,154)%j+A(j,155)%j &
       +A(j,161)%j+A(j,162)%j)*f(13)+(-A(j,39)%j-A(j,40)%j-A(j,45)%j-A(j,46)%j-A(j,51)%j-A(j,52)%j-A(j,57)%j-A(j,58)%j)*f(14)+( &
       -A(j,141)%j-A(j,142)%j-A(j,147)%j-A(j,148)%j)*f(15)-A(j,64)%j*f(17)-A(j,137)%j*f(18)-A(j,63)%j*f(20)-A(j,136)%j*f(21) &
       +(A(j,175)%j+A(j,176)%j+A(j,182)%j+A(j,183)%j)*f(23)+(-A(j,76)%j-A(j,77)%j-A(j,82)%j-A(j,83)%j)*f(24)+(-A(j,92)%j-A(j,93)%j &
       -A(j,98)%j-A(j,99)%j-A(j,120)%j-A(j,121)%j-A(j,126)%j-A(j,127)%j)*f(25)-A(j,66)%j*f(40)-A(j,139)%j*f(41)+A(j,138)%j*f(43) &
       +A(j,65)%j*f(44)+(A(j,156)%j+A(j,163)%j)*f(48)+(-A(j,157)%j-A(j,164)%j)*f(49)+((-A(j,44)%j-A(j,56)%j-A(j,146)%j-A(j,152)%j &
       +A(j,159)%j+A(j,166)%j)*f(49))/6._/**/REALKIND+(-A(j,47)%j-A(j,59)%j)*f(50)+(A(j,48)%j+A(j,60)%j)*f(51)+(-A(j,41)%j &
       -A(j,53)%j)*f(52)+(A(j,42)%j+A(j,54)%j)*f(53)+(-A(j,143)%j-A(j,149)%j)*f(54)+(A(j,144)%j+A(j,150)%j)*f(55)+(A(j,177)%j &
       +A(j,184)%j)*f(63)+(-A(j,178)%j-A(j,185)%j)*f(64)+((-A(j,81)%j-A(j,87)%j-A(j,97)%j-A(j,125)%j+A(j,180)%j &
       +A(j,187)%j)*f(64))/6._/**/REALKIND+(-A(j,100)%j-A(j,128)%j)*f(65)+(A(j,101)%j+A(j,129)%j)*f(66)+(-A(j,78)%j &
       -A(j,84)%j)*f(67)+(A(j,79)%j+A(j,85)%j)*f(68)+(-A(j,94)%j-A(j,122)%j)*f(69)+(A(j,95)%j+A(j,123)%j)*f(70)+A(j,67)%j*f(76) &
       +A(j,140)%j*f(77)
  M2(4)%j = -(A(j,38)%j*f(1))/6._/**/REALKIND+((A(j,153)%j+A(j,158)%j+A(j,160)%j+A(j,165)%j)*f(56))/6._/**/REALKIND+((-A(j,43)%j &
       -A(j,55)%j)*f(57))/6._/**/REALKIND+((-A(j,145)%j-A(j,151)%j)*f(58))/6._/**/REALKIND+((-A(j,49)%j &
       -A(j,61)%j)*f(59))/6._/**/REALKIND+((A(j,179)%j+A(j,181)%j+A(j,186)%j+A(j,188)%j)*f(71))/6._/**/REALKIND+((-A(j,80)%j &
       -A(j,86)%j)*f(72))/6._/**/REALKIND+((-A(j,96)%j-A(j,124)%j)*f(73))/6._/**/REALKIND+((-A(j,102)%j &
       -A(j,130)%j)*f(74))/6._/**/REALKIND


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphtt_ew_ttxbbxh_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(4)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 4
      do j = 1, 4
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphtt_ew_ttxbbxh_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(4), Mct(4)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 4
    do j = 1, 4
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+4*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_pphtt_ew_ttxbbxh_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(4)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 4*k
    do i = 1, 4
      do j = 1, 4
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphtt_ew_ttxbbxh_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(4)
  complex(REALKIND), intent(in)  :: M2(4)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 4
    do j = 1, 4
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_pphtt_ew_ttxbbxh_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(4)
  type(Hpolcont), intent(out)  :: M0_col(4)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 4 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 4 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+4*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_pphtt_ew_ttxbbxh_1_/**/REALKIND
