
module ol_vamp_2_pphtt_ew_uuxttxh_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_2(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphtt_ew_uuxttxh_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphtt_ew_uuxttxh_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pphtt_ew_uuxttxh_1_/**/DREALKIND
  use ol_tensor_sum_storage_pphtt_ew_uuxttxh_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pphtt_ew_uuxttxh_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pphtt_ew_uuxttxh_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(4,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================
  call ol_merge_tensors(T0sum(134),[G0tensor(553)])
  call ol_merge_tensors(T0sum(135),[G0tensor(14)])
  call ol_merge_tensors(T0sum(136),[G0tensor(29)])
  call ol_merge_tensors(T0sum(137),[G0tensor(25)])
  call ol_merge_tensors(T0sum(138),[G0tensor(30)])
  call ol_merge_tensors(T0sum(139),[G0tensor(162)])
  call ol_merge_tensors(T0sum(140),[G0tensor(202)])
  call ol_merge_tensors(T0sum(141),[G0tensor(180)])
  call ol_merge_tensors(T0sum(142),[G0tensor(44)])
  call ol_merge_tensors(T0sum(143),[G0tensor(57)])
  call ol_merge_tensors(T0sum(144),[G0tensor(67)])
  call ol_merge_tensors(T0sum(145),[G0tensor(77)])
  call ol_merge_tensors(T0sum(146),[G0tensor(78)])
  call ol_merge_tensors(T0sum(147),[G0tensor(173)])
  call ol_merge_tensors(T0sum(148),[G0tensor(92)])
  call ol_merge_tensors(T0sum(149),[G0tensor(89)])
  call ol_merge_tensors(T0sum(150),[G0tensor(103)])
  call ol_merge_tensors(T0sum(151),[G0tensor(133)])
  call ol_merge_tensors(T0sum(152),[G0tensor(169)])
  call ol_merge_tensors(T0sum(153),[G0tensor(144)])
  call ol_merge_tensors(T0sum(154),[G0tensor(559)])
  call ol_merge_tensors(T0sum(155),[G0tensor(154)])
  call ol_merge_tensors(T0sum(156),[G0tensor(183)])
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(11)*M(3,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(3),m0h(151),h0tab(:,151),[20,11],[nMH,nMT],2,2,wf2(:,2),wf8(:,17))
  call Hloop_AQ_S(ntryL,G0H16(3),wf2(:,2),G0H8(4),ngH,m3h2x8(:,87),heltab2x16(:,:,231))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(11)*M(3,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(152),h0tab(:,152),[20,11],[nMZ,nMT],2,2,wf2(:,2),wf8(:,17))
  call Hloop_AQ_S(ntryL,G0H16(1),wf2(:,2),G0H8(10),ngX,m3h2x8(:,88),heltab2x16(:,:,232))
  Gcoeff(:)%j = (c(6)*M(1,:)%j-c(5)*M(3,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(6),m0h(153),h0tab(:,153),[20,11],[nMW,nMB],2,2,wf2(:,2),wf8(:,17))
  call Hloop_AQ_S(ntryL,G0H16(6),wf2(:,2),G0H8(8),ngPbt,m3h2x8(:,89),heltab2x16(:,:,233))
  Gcoeff(:)%j = (c(26)*M(3,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(154),h0tab(:,154),[20,11],[0,nMT],2,2,wf2(:,2),wf8(:,17))
  call Hloop_AQ_V(ntryL,G0H16(8),wf2(:,2),G0H8(9),m3h2x8(:,90),heltab2x16(:,:,234))
  Gcoeff(:)%j = (c(29)*M(3,:)%j) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(5),m0h(155),h0tab(:,155),[20,11],[0,nMT],2,2,wf2(:,2),wf8(:,18))
  call Hloop_AQ_V(ntryL,G0H16(5),wf2(:,2),G0H8(15),m3h2x8(:,91),heltab2x16(:,:,235))
  Gcoeff(:)%j = (c(25)*M(1,:)%j-c(24)*M(3,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(156),h0tab(:,156),[20,11],[0,nMT],2,2,wf2(:,2),wf8(:,17))
  call Hloop_AQ_V(ntryL,G0H16(7),wf2(:,2),G0H8(13),m3h2x8(:,92),heltab2x16(:,:,236))
  Gcoeff(:)%j = (c(28)*M(1,:)%j-c(27)*M(3,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(157),h0tab(:,157),[20,11],[nMZ,nMT],2,2,wf2(:,2),wf8(:,17))
  call Hloop_AQ_Z(ntryL,G0H16(2),wf2(:,2),G0H8(14),ngZu,m3h2x8(:,93),heltab2x16(:,:,237))
  Gcoeff(:)%j = (c(18)*M(1,:)%j-c(17)*M(3,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(4),m0h(158),h0tab(:,158),[20,11],[nMW,nMB],2,2,wf2(:,2),wf8(:,17))
  call Hloop_AQ_W(ntryL,G0H16(4),wf2(:,2),G0H8(20),m3h2x8(:,94),heltab2x16(:,:,238))
  Gcoeff(:)%j = (c(41)*M(2,:)%j-c(37)*M(4,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(9),m0h(159),h0tab(:,159),[20,11],[0,nMT],2,2,wf2(:,2),wf8(:,17))
  call Hloop_AQ_V(ntryL,G0H16(9),wf2(:,2),G0H8(18),m3h2x8(:,95),heltab2x16(:,:,239))
  Gcoeff(:)%j = (-(c(51)*M(2,:)%j)+c(50)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(10),m0h(160),h0tab(:,160),[28,3],[0,0],2,2,wf4(:,16),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H16(10),wf4(:,16),G0H4(1),m3h4x4(:,37),heltab2x16(:,:,240))
  call Hloop_Q_A(ntryL,G0H4(1),28,0,G1H4(5),n2h4(57))
  Gcoeff(:)%j = (-(c(49)*M(2,:)%j)+c(48)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(11),m0h(161),h0tab(:,161),[28,3],[nMT,nMT],2,2,wf4(:,16),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H16(11),wf4(:,16),G0H4(1),m3h4x4(:,38),heltab2x16(:,:,241))
  call Hloop_Q_A(ntryL,G0H4(1),28,nMT,G1H4(4),n2h4(58))
  Gcoeff(:)%j = (-(c(51)*M(2,:)%j)+c(50)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(12),m0h(162),h0tab(:,162),[28,3],[0,0],2,2,wf4(:,16),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H16(12),wf4(:,16),G0H4(1),m3h4x4(:,39),heltab2x16(:,:,242))
  call Hloop_Q_A(ntryL,G0H4(1),28,0,G1H4(25),n2h4(59))
  Gcoeff(:)%j = (-(c(49)*M(2,:)%j)+c(48)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(13),m0h(163),h0tab(:,163),[28,3],[nMB,nMB],2,2,wf4(:,16),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H16(13),wf4(:,16),G0H4(1),m3h4x4(:,40),heltab2x16(:,:,243))
  call Hloop_Q_A(ntryL,G0H4(1),28,nMB,G1H4(21),n2h4(60))
  Gcoeff(:)%j = (-(c(42)*M(2,:)%j)+c(39)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(14),m0h(164),h0tab(:,164),[28,3],[0,0],2,2,wf4(:,16),wf4(:,6))
  call Hloop_CV_D(ntryL,G0H16(14),0,wf4(:,16),28,G1H4(23),m3h4x4(:,41),heltab2x16(:,:,244))
  Gcoeff(:)%j = (c(33)*M(2,:)%j-c(32)*M(4,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(165),h0tab(:,165),[28,3],[0,0],2,2,wf4(:,16),wf4(:,6))
  call Hloop_UV_W(ntryL,G0H16(15),0,wf4(:,16),28,G1H4(12),m3h4x4(:,42),heltab2x16(:,:,245))
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j)+c(11)*M(3,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(3),m0h(166),h0tab(:,166),[24,7],[nMT,nMH],2,2,wf2(:,4),wf8(:,19))
  call Hloop_SA_Q(ntryL,G0H16(3),wf2(:,4),G0H8(3),ngH,m3h2x8(:,96),heltab2x16(:,:,246))
  call Hloop_A_Q(ntryL,G0H8(3),24,nMT,G1H8(17),n2h8(55))
  Gcoeff(:)%j = (c(12)*M(1,:)%j-c(11)*M(3,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(167),h0tab(:,167),[24,7],[nMT,nMZ],2,2,wf2(:,4),wf8(:,19))
  call Hloop_SA_Q(ntryL,G0H16(1),wf2(:,4),G0H8(19),ngX,m3h2x8(:,97),heltab2x16(:,:,247))
  call Hloop_A_Q(ntryL,G0H8(19),24,nMT,G1H8(19),n2h8(56))
  Gcoeff(:)%j = (c(6)*M(1,:)%j-c(5)*M(3,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(6),m0h(168),h0tab(:,168),[24,7],[nMB,nMW],2,2,wf2(:,4),wf8(:,19))
  call Hloop_SA_Q(ntryL,G0H16(6),wf2(:,4),G0H8(16),ngPtb,m3h2x8(:,98),heltab2x16(:,:,248))
  call Hloop_A_Q(ntryL,G0H8(16),24,nMB,G1H8(20),n2h8(57))
  Gcoeff(:)%j = (c(26)*M(3,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(169),h0tab(:,169),[24,7],[nMT,0],2,2,wf2(:,4),wf8(:,19))
  call Hloop_VA_Q(ntryL,G0H16(8),wf2(:,4),G0H8(2),m3h2x8(:,99),heltab2x16(:,:,249))
  call Hloop_A_Q(ntryL,G0H8(2),24,nMT,G1H8(5),n2h8(58))
  Gcoeff(:)%j = (c(29)*M(3,:)%j) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(5),m0h(170),h0tab(:,170),[24,7],[nMT,0],2,2,wf2(:,4),wf8(:,20))
  call Hloop_VA_Q(ntryL,G0H16(5),wf2(:,4),G0H8(1),m3h2x8(:,100),heltab2x16(:,:,250))
  call Hloop_A_Q(ntryL,G0H8(1),24,nMT,G1H8(9),n2h8(59))
  Gcoeff(:)%j = (c(25)*M(1,:)%j-c(24)*M(3,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(171),h0tab(:,171),[24,7],[nMT,0],2,2,wf2(:,4),wf8(:,19))
  call Hloop_VA_Q(ntryL,G0H16(7),wf2(:,4),G0H8(7),m3h2x8(:,101),heltab2x16(:,:,251))
  call Hloop_A_Q(ntryL,G0H8(7),24,nMT,G1H8(10),n2h8(60))
  Gcoeff(:)%j = (c(28)*M(1,:)%j-c(27)*M(3,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(172),h0tab(:,172),[24,7],[nMT,nMZ],2,2,wf2(:,4),wf8(:,19))
  call Hloop_ZA_Q(ntryL,G0H16(2),wf2(:,4),G0H8(6),ngZu,m3h2x8(:,102),heltab2x16(:,:,252))
  call Hloop_A_Q(ntryL,G0H8(6),24,nMT,G1H8(8),n2h8(61))
  Gcoeff(:)%j = (c(18)*M(1,:)%j-c(17)*M(3,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(4),m0h(173),h0tab(:,173),[24,7],[nMB,nMW],2,2,wf2(:,4),wf8(:,19))
  call Hloop_WA_Q(ntryL,G0H16(4),wf2(:,4),G0H8(12),m3h2x8(:,103),heltab2x16(:,:,253))
  call Hloop_A_Q(ntryL,G0H8(12),24,nMB,G1H8(21),n2h8(62))
  Gcoeff(:)%j = (c(41)*M(2,:)%j-c(37)*M(4,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(9),m0h(174),h0tab(:,174),[24,7],[nMT,0],2,2,wf2(:,4),wf8(:,19))
  call Hloop_VA_Q(ntryL,G0H16(9),wf2(:,4),G0H8(11),m3h2x8(:,104),heltab2x16(:,:,254))
  call Hloop_A_Q(ntryL,G0H8(11),24,nMT,G1H8(3),n2h8(63))
  Gcoeff(:)%j = (-(c(51)*M(2,:)%j)+c(50)*M(4,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(10),m0h(175),h0tab(:,175),[28,3],[0,0],2,2,wf4(:,18),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H16(10),wf4(:,18),G0H4(1),m3h4x4(:,43),heltab2x16(:,:,255))
  call Hloop_Q_A(ntryL,G0H4(1),28,0,G1H4(18),n2h4(61))
  Gcoeff(:)%j = (-(c(49)*M(2,:)%j)+c(48)*M(4,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(11),m0h(176),h0tab(:,176),[28,3],[nMT,nMT],2,2,wf4(:,18),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H16(11),wf4(:,18),G0H4(1),m3h4x4(:,44),heltab2x16(:,:,256))
  call Hloop_Q_A(ntryL,G0H4(1),28,nMT,G1H4(7),n2h4(62))
  Gcoeff(:)%j = (-(c(51)*M(2,:)%j)+c(50)*M(4,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(12),m0h(177),h0tab(:,177),[28,3],[0,0],2,2,wf4(:,18),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H16(12),wf4(:,18),G0H4(1),m3h4x4(:,45),heltab2x16(:,:,257))
  call Hloop_Q_A(ntryL,G0H4(1),28,0,G1H4(13),n2h4(63))
  Gcoeff(:)%j = (-(c(49)*M(2,:)%j)+c(48)*M(4,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(13),m0h(178),h0tab(:,178),[28,3],[nMB,nMB],2,2,wf4(:,18),wf4(:,6))
  call Hloop_QV_A(ntryL,G0H16(13),wf4(:,18),G0H4(1),m3h4x4(:,46),heltab2x16(:,:,258))
  call Hloop_Q_A(ntryL,G0H4(1),28,nMB,G1H4(17),n2h4(64))
  Gcoeff(:)%j = (-(c(42)*M(2,:)%j)+c(39)*M(4,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(14),m0h(179),h0tab(:,179),[28,3],[0,0],2,2,wf4(:,18),wf4(:,6))
  call Hloop_CV_D(ntryL,G0H16(14),0,wf4(:,18),28,G1H4(22),m3h4x4(:,47),heltab2x16(:,:,259))
  Gcoeff(:)%j = (c(33)*M(2,:)%j-c(32)*M(4,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(180),h0tab(:,180),[28,3],[0,0],2,2,wf4(:,18),wf4(:,6))
  call Hloop_UV_W(ntryL,G0H16(15),0,wf4(:,18),28,G1H4(24),m3h4x4(:,48),heltab2x16(:,:,260))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H8(18),[G0H8(13),G0H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G1H4(18),G1H4(25),G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(17),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(22),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(3),[G1H8(10),G1H8(5)])
  call Hloop_SA_Q(ntryL,G0H8(4),wf8(:,17),G0H1(1),ngH,m3h8x1(:,17),heltab2x8(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(5),n2h1(118))
  call Hloop_SA_Q(ntryL,G0H8(10),wf8(:,17),G0H1(1),ngX,m3h8x1(:,18),heltab2x8(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(10),n2h1(119))
  call Hloop_SA_Q(ntryL,G0H8(8),wf8(:,17),G0H1(1),ngPtb,m3h8x1(:,19),heltab2x8(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(33),n2h1(120))
  call Hloop_VA_Q(ntryL,G0H8(18),wf8(:,17),G0H1(1),m3h8x1(:,20),heltab2x8(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(34),n2h1(121))
  call Hloop_VA_Q(ntryL,G0H8(15),wf8(:,18),G0H1(1),m3h8x1(:,21),heltab2x8(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(35),n2h1(122))
  call Hloop_ZA_Q(ntryL,G0H8(14),wf8(:,17),G0H1(1),ngZu,m3h8x1(:,22),heltab2x8(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMT,G1tensor(45),n2h1(123))
  call Hloop_WA_Q(ntryL,G0H8(20),wf8(:,17),G0H1(1),m3h8x1(:,23),heltab2x8(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(61),n2h1(124))
  call Hloop_QV_A(ntryL,G1H4(13),wf4(:,6),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(68),n2h1(125))
  call Hloop_QV_A(ntryL,G1H4(7),wf4(:,6),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(77),n2h1(126))
  call Hloop_QV_A(ntryL,G1H4(17),wf4(:,6),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(89),n2h1(127))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(22),28,wf4(:,6),3,G2tensor(92),m3h4x1(:,10),heltab2x4(:,:,71))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(24),28,wf4(:,6),3,G2tensor(86),m3h4x1(:,11),heltab2x4(:,:,72))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(17),wf8(:,19),G1tensor(66),ngH,m3h8x1(:,24),heltab2x8(:,:,86))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(19),wf8(:,19),G1tensor(71),ngX,m3h8x1(:,25),heltab2x8(:,:,87))
  call Hcheck_last_AQ_S(ntryL,l_switch,G1H8(20),wf8(:,19),G1tensor(76),ngPbt,m3h8x1(:,26),heltab2x8(:,:,88))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(3),wf8(:,19),G1tensor(81),m3h8x1(:,27),heltab2x8(:,:,89))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(9),wf8(:,20),G1tensor(86),m3h8x1(:,28),heltab2x8(:,:,90))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(8),wf8(:,19),G1tensor(91),ngZu,m3h8x1(:,29),heltab2x8(:,:,91))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(21),wf8(:,19),G1tensor(96),m3h8x1(:,30),heltab2x8(:,:,92))
  call ol_merge_tensors(G0tensor(555),[G0tensor(544),G0tensor(538),G0tensor(43),G0tensor(38),G0tensor(155),G0tensor(6)])
  call ol_merge_tensors(G0tensor(170),[G0tensor(181),G0tensor(11)])
  call ol_merge_tensors(G0tensor(509),[G0tensor(429),G0tensor(268),G0tensor(227),G0tensor(209),G0tensor(9),G0tensor(16)])
  call ol_merge_tensors(G0tensor(558),[G0tensor(547),G0tensor(541),G0tensor(510),G0tensor(505),G0tensor(500),G0tensor(477) &
    ,G0tensor(471),G0tensor(465),G0tensor(458),G0tensor(447),G0tensor(442),G0tensor(430),G0tensor(424),G0tensor(418),G0tensor(413) &
    ,G0tensor(401),G0tensor(395),G0tensor(390),G0tensor(384),G0tensor(373),G0tensor(367),G0tensor(360),G0tensor(355),G0tensor(325) &
    ,G0tensor(319),G0tensor(314),G0tensor(309),G0tensor(303),G0tensor(297),G0tensor(271),G0tensor(254),G0tensor(243),G0tensor(229) &
    ,G0tensor(220),G0tensor(210),G0tensor(198),G0tensor(159),G0tensor(98),G0tensor(59),G0tensor(39),G0tensor(140),G0tensor(12) &
    ,G0tensor(4),G0tensor(70),G0tensor(270),G0tensor(186),G0tensor(21)])
  call ol_merge_tensors(G0tensor(557),[G0tensor(552),G0tensor(546),G0tensor(540),G0tensor(535),G0tensor(495),G0tensor(489) &
    ,G0tensor(482),G0tensor(476),G0tensor(470),G0tensor(464),G0tensor(459),G0tensor(453),G0tensor(448),G0tensor(441),G0tensor(436) &
    ,G0tensor(431),G0tensor(425),G0tensor(419),G0tensor(412),G0tensor(407),G0tensor(402),G0tensor(396),G0tensor(389),G0tensor(383) &
    ,G0tensor(378),G0tensor(372),G0tensor(366),G0tensor(361),G0tensor(350),G0tensor(345),G0tensor(340),G0tensor(331),G0tensor(326) &
    ,G0tensor(320),G0tensor(308),G0tensor(302),G0tensor(296),G0tensor(291),G0tensor(286),G0tensor(281),G0tensor(276),G0tensor(174) &
    ,G0tensor(124),G0tensor(88),G0tensor(148),G0tensor(79),G0tensor(68),G0tensor(64),G0tensor(175),G0tensor(54),G0tensor(42) &
    ,G0tensor(157),G0tensor(160),G0tensor(24),G0tensor(17),G0tensor(195),G0tensor(23),G0tensor(100),G0tensor(90),G0tensor(247) &
    ,G0tensor(260),G0tensor(145),G0tensor(225),G0tensor(191),G0tensor(161),G0tensor(136),G0tensor(106),G0tensor(81) &
    ,G0tensor(26)])
  call ol_merge_tensors(G0tensor(97),[G0tensor(177),G0tensor(19),G0tensor(36)])
  call ol_merge_tensors(G0tensor(52),[G0tensor(211),G0tensor(41)])
  call ol_merge_tensors(G0tensor(562),[G0tensor(529),G0tensor(524),G0tensor(28),G0tensor(46)])
  call ol_merge_tensors(G0tensor(563),[G0tensor(530),G0tensor(525),G0tensor(520),G0tensor(515),G0tensor(190),G0tensor(163) &
    ,G0tensor(138),G0tensor(107),G0tensor(203),G0tensor(49),G0tensor(150),G0tensor(55),G0tensor(237),G0tensor(216),G0tensor(51)])
  call ol_merge_tensors(G0tensor(179),[G0tensor(109),G0tensor(213),G0tensor(58),G0tensor(182),G0tensor(60),G0tensor(147) &
    ,G0tensor(223),G0tensor(246),G0tensor(221),G0tensor(56)])
  call ol_merge_tensors(G0tensor(328),[G0tensor(322),G0tensor(273),G0tensor(122),G0tensor(265),G0tensor(91),G0tensor(66)])
  call ol_merge_tensors(G2tensor(86),[G2tensor(92),G2tensor(68),G0tensor(335),G0tensor(189),G0tensor(164),G0tensor(132) &
    ,G0tensor(5),G0tensor(267),G0tensor(71)])
  call ol_merge_tensors(G1tensor(86),[G1tensor(81),G0tensor(339),G0tensor(301),G0tensor(280),G0tensor(125),G0tensor(245) &
    ,G0tensor(76)])
  call ol_merge_tensors(G1tensor(35),[G1tensor(34),G0tensor(469),G0tensor(344),G0tensor(285),G0tensor(102),G0tensor(96)])
  call ol_merge_tensors(G0tensor(349),[G0tensor(290),G0tensor(269),G0tensor(83),G0tensor(73),G0tensor(185),G0tensor(47) &
    ,G0tensor(32),G0tensor(8),G0tensor(2),G0tensor(156),G0tensor(101)])
  call ol_merge_tensors(G2tensor(77),[G0tensor(480),G0tensor(135),G0tensor(228),G0tensor(20),G0tensor(142),G0tensor(256) &
    ,G0tensor(171),G0tensor(146),G0tensor(116)])
  call ol_merge_tensors(G0tensor(486),[G0tensor(217),G0tensor(121)])
  call ol_merge_tensors(G0tensor(492),[G0tensor(50),G0tensor(126)])
  call ol_merge_tensors(G0tensor(494),[G0tensor(488),G0tensor(483),G0tensor(149),G0tensor(119),G0tensor(74),G0tensor(37) &
    ,G0tensor(34),G0tensor(165),G0tensor(131)])
  call ol_merge_tensors(G0tensor(128),[G0tensor(93),G0tensor(114),G0tensor(72),G0tensor(172),G0tensor(33),G0tensor(151)])
  call ol_merge_tensors(G0tensor(445),[G0tensor(399),G0tensor(393),G0tensor(167),G0tensor(75),G0tensor(176)])
  call ol_merge_tensors(G2tensor(89),[G0tensor(27),G0tensor(250),G0tensor(231),G0tensor(201)])
  call ol_merge_tensors(G0tensor(207),[G0tensor(120),G0tensor(206)])
  call ol_merge_tensors(G0tensor(94),[G0tensor(48),G0tensor(236)])
  call ol_merge_tensors(G0tensor(153),[G0tensor(113),G0tensor(85),G0tensor(241)])
  call ol_merge_tensors(G0tensor(63),[G0tensor(261)])
  call ol_merge_tensors(G0tensor(65),[G0tensor(266)])
  call ol_merge_tensors(G0tensor(143),[G0tensor(69),G0tensor(40)])
  call ol_merge_tensors(G1tensor(66),[G0tensor(168),G0tensor(15)])
  call ol_merge_tensors(G0tensor(456),[G0tensor(428),G0tensor(422),G0tensor(416),G0tensor(363),G0tensor(299),G0tensor(293) &
    ,G0tensor(84),G0tensor(62),G0tensor(232)])
  call ol_merge_tensors(G1tensor(91),[G1tensor(71),G0tensor(359),G0tensor(324),G0tensor(318),G0tensor(115),G0tensor(188)])
  call ol_merge_tensors(G0tensor(139),[G0tensor(129),G0tensor(240)])
  call ol_merge_tensors(G1tensor(96),[G1tensor(76),G0tensor(112),G0tensor(235)])
  call ol_merge_tensors(G0tensor(549),[G0tensor(404),G0tensor(375),G0tensor(338),G0tensor(334),G0tensor(311),G0tensor(283) &
    ,G0tensor(274),G0tensor(200),G0tensor(194),G0tensor(257)])
  call ol_merge_tensors(G0tensor(532),[G0tensor(450),G0tensor(433),G0tensor(352),G0tensor(342),G0tensor(333),G0tensor(329) &
    ,G0tensor(279),G0tensor(248),G0tensor(238),G0tensor(262)])
  call ol_merge_tensors(G1tensor(45),[G1tensor(10),G0tensor(427),G0tensor(411),G0tensor(371),G0tensor(307),G0tensor(53)])
  call ol_merge_tensors(G0tensor(440),[G0tensor(388),G0tensor(382),G0tensor(18),G0tensor(95)])
  call ol_merge_tensors(G0tensor(451),[G0tensor(415),G0tensor(410),G0tensor(405),G0tensor(118),G0tensor(110),G0tensor(117)])
  call ol_merge_tensors(G0tensor(474),[G0tensor(468),G0tensor(462),G0tensor(123),G0tensor(10)])
  call ol_merge_tensors(G0tensor(434),[G0tensor(392),G0tensor(381),G0tensor(376),G0tensor(108),G0tensor(104),G0tensor(13)])
  call ol_merge_tensors(G0tensor(551),[G0tensor(545),G0tensor(534),G0tensor(137)])
  call ol_merge_tensors(G0tensor(127),[G0tensor(22)])
  call ol_merge_tensors(G0tensor(491),[G0tensor(479),G0tensor(35),G0tensor(152)])
  call ol_merge_tensors(G0tensor(87),[G0tensor(224)])
  call ol_merge_tensors(G0tensor(105),[G0tensor(99)])
  call ol_merge_tensors(G1tensor(5),[G0tensor(134)])
  call ol_merge_tensors(G1tensor(61),[G1tensor(33),G0tensor(158)])
  call ol_merge_tensors(G0tensor(537),[G0tensor(473),G0tensor(358),G0tensor(353),G0tensor(259)])
  call ol_merge_tensors(G0tensor(386),[G0tensor(369),G0tensor(364),G0tensor(218),G0tensor(193),G0tensor(184)])
  call ol_merge_tensors(G0tensor(560),[G0tensor(187)])
  call ol_merge_tensors(G0tensor(409),[G0tensor(380),G0tensor(300),G0tensor(239),G0tensor(208),G0tensor(197)])
  call ol_merge_tensors(G0tensor(417),[G0tensor(394),G0tensor(249),G0tensor(219),G0tensor(214)])
  call ol_merge_tensors(G0tensor(423),[G0tensor(400),G0tensor(222),G0tensor(204)])
  call ol_merge_tensors(G0tensor(497),[G0tensor(438),G0tensor(305),G0tensor(294),G0tensor(263),G0tensor(234)])
  call ol_merge_tensors(G0tensor(504),[G0tensor(457),G0tensor(446),G0tensor(264),G0tensor(253)])
  call ol_merge_tensors(G0tensor(316),[G0tensor(295),G0tensor(288),G0tensor(278),G0tensor(275)])
  call ol_merge_tensors(G0tensor(463),[G0tensor(455),G0tensor(452),G0tensor(306),G0tensor(289),G0tensor(284)])
  call ol_merge_tensors(G0tensor(554),[G0tensor(508),G0tensor(503),G0tensor(461),G0tensor(317),G0tensor(312)])
  call ol_merge_tensors(G0tensor(543),[G0tensor(467),G0tensor(354),G0tensor(323),G0tensor(313)])
  call ol_merge_tensors(G0tensor(365),[G0tensor(357),G0tensor(347),G0tensor(337),G0tensor(330)])
  call ol_merge_tensors(G0tensor(475),[G0tensor(421),G0tensor(406),G0tensor(370),G0tensor(348),G0tensor(343)])
  call ol_merge_tensors(G0tensor(539),[G0tensor(533),G0tensor(398),G0tensor(387),G0tensor(377)])
  call ol_merge_tensors(G0tensor(556),[G0tensor(550),G0tensor(444),G0tensor(439),G0tensor(435)])
  call ol_merge_tensors(G0tensor(485),[G0tensor(481)])
  call ol_merge_tensors(G0tensor(493),[G0tensor(487)])
  call ol_merge_tensors(G0tensor(517),[G0tensor(513),G0tensor(502),G0tensor(498)])
  call ol_merge_tensors(G0tensor(507),[G0tensor(499)])
  call ol_merge_tensors(G0tensor(527),[G0tensor(512)])
  call ol_merge_tensors(G0tensor(522),[G0tensor(514)])
  call ol_merge_tensors(G0tensor(523),[G0tensor(518)])
  call ol_merge_tensors(G0tensor(528),[G0tensor(519)])
call TI_bubble_red(G2tensor(86),28,mass2set(:,1),G0tensor(1),M2L1R1)
call TI_bubble_red(G2tensor(77),28,mass2set(:,2),G0tensor(31),M2L1R1,G0tensor(61))
call TI_bubble_red(G2tensor(89),28,mass2set(:,3),G0tensor(86),M2L1R1,G0tensor(111))
  call ol_merge_tensors(G0tensor(61),[G0tensor(557)])
  call ol_merge_tensors(G0tensor(111),[G0tensor(179)])
call TI_bubble_red(G1tensor(86),24,mass2set(:,4),G0tensor(141),M2L1R1,G0tensor(166))
call TI_bubble_red(G1tensor(35),20,mass2set(:,5),G0tensor(196),M2L1R1,G0tensor(226))
call TI_bubble_red(G1tensor(66),24,mass2set(:,6),G0tensor(251),M2L1R1,G0tensor(230),G0tensor(45))
call TI_bubble_red(G1tensor(91),24,mass2set(:,7),G0tensor(255),M2L1R1,G0tensor(242),G0tensor(192))
call TI_bubble_red(G1tensor(96),24,mass2set(:,8),G0tensor(199),M2L1R1,G0tensor(205),G0tensor(215))
call TI_bubble_red(G1tensor(45),20,mass2set(:,9),G0tensor(233),M2L1R1,G0tensor(244),G0tensor(258))
call TI_bubble_red(G1tensor(5),20,mass2set(:,10),G0tensor(272),M2L1R1,G0tensor(252),G0tensor(277))
call TI_bubble_red(G1tensor(61),20,mass2set(:,11),G0tensor(282),M2L1R1,G0tensor(287),G0tensor(292))
  call ol_merge_tensors(G0tensor(258),[G0tensor(242),G0tensor(558)])
  call ol_merge_tensors(G0tensor(252),[G0tensor(244),G0tensor(192),G0tensor(45),G0tensor(226),G0tensor(166),G0tensor(61)])
  call ol_merge_tensors(G0tensor(292),[G0tensor(205),G0tensor(563)])
  call ol_merge_tensors(G0tensor(287),[G0tensor(215),G0tensor(111)])
  call ol_merge_tensors(G0tensor(277),[G0tensor(230),G0tensor(494)])
  call ol_merge_tensors(T0sum(157),[G0tensor(555)])
  call ol_merge_tensors(T0sum(158),[G0tensor(170)])
  call ol_merge_tensors(T0sum(159),[G0tensor(509)])
  call ol_merge_tensors(T0sum(160),[G0tensor(258)])
  call ol_merge_tensors(T0sum(161),[G0tensor(252)])
  call ol_merge_tensors(T0sum(162),[G0tensor(97)])
  call ol_merge_tensors(T0sum(163),[G0tensor(52)])
  call ol_merge_tensors(T0sum(164),[G0tensor(562)])
  call ol_merge_tensors(T0sum(165),[G0tensor(292)])
  call ol_merge_tensors(T0sum(166),[G0tensor(287)])
  call ol_merge_tensors(T0sum(167),[G0tensor(328)])
  call ol_merge_tensors(T0sum(168),[G0tensor(1)])
  call ol_merge_tensors(T0sum(169),[G0tensor(141)])
  call ol_merge_tensors(T0sum(170),[G0tensor(196)])
  call ol_merge_tensors(T0sum(171),[G0tensor(349)])
  call ol_merge_tensors(T0sum(172),[G0tensor(31)])
  call ol_merge_tensors(T0sum(173),[G0tensor(486)])
  call ol_merge_tensors(T0sum(174),[G0tensor(492)])
  call ol_merge_tensors(T0sum(175),[G0tensor(277)])
  call ol_merge_tensors(T0sum(176),[G0tensor(128)])
  call ol_merge_tensors(T0sum(177),[G0tensor(445)])
  call ol_merge_tensors(T0sum(178),[G0tensor(86)])
  call ol_merge_tensors(T0sum(179),[G0tensor(207)])
  call ol_merge_tensors(T0sum(180),[G0tensor(94)])
  call ol_merge_tensors(T0sum(181),[G0tensor(153)])
  call ol_merge_tensors(T0sum(182),[G0tensor(63)])
  call ol_merge_tensors(T0sum(183),[G0tensor(65)])
  call ol_merge_tensors(T0sum(184),[G0tensor(143)])
  call ol_merge_tensors(T0sum(185),[G0tensor(251)])
  call ol_merge_tensors(T0sum(186),[G0tensor(456)])
  call ol_merge_tensors(T0sum(187),[G0tensor(255)])
  call ol_merge_tensors(T0sum(188),[G0tensor(139)])
  call ol_merge_tensors(T0sum(189),[G0tensor(199)])
  call ol_merge_tensors(T0sum(190),[G0tensor(549)])
  call ol_merge_tensors(T0sum(191),[G0tensor(532)])
  call ol_merge_tensors(T0sum(192),[G0tensor(233)])
  call ol_merge_tensors(T0sum(193),[G0tensor(440)])
  call ol_merge_tensors(T0sum(194),[G0tensor(451)])
  call ol_merge_tensors(T0sum(195),[G0tensor(474)])
  call ol_merge_tensors(T0sum(196),[G0tensor(434)])
  call ol_merge_tensors(T0sum(197),[G0tensor(551)])
  call ol_merge_tensors(T0sum(198),[G0tensor(127)])
  call ol_merge_tensors(T0sum(199),[G0tensor(491)])
  call ol_merge_tensors(T0sum(200),[G0tensor(87)])
  call ol_merge_tensors(T0sum(201),[G0tensor(105)])
  call ol_merge_tensors(T0sum(202),[G0tensor(272)])
  call ol_merge_tensors(T0sum(203),[G0tensor(282)])
  call ol_merge_tensors(T0sum(204),[G0tensor(537)])
  call ol_merge_tensors(T0sum(205),[G0tensor(386)])
  call ol_merge_tensors(T0sum(206),[G0tensor(178)])
  call ol_merge_tensors(T0sum(207),[G0tensor(560)])
  call ol_merge_tensors(T0sum(208),[G0tensor(409)])
  call ol_merge_tensors(T0sum(209),[G0tensor(417)])
  call ol_merge_tensors(T0sum(210),[G0tensor(423)])
  call ol_merge_tensors(T0sum(211),[G0tensor(497)])
  call ol_merge_tensors(T0sum(212),[G0tensor(504)])
  call ol_merge_tensors(T0sum(213),[G0tensor(316)])
  call ol_merge_tensors(T0sum(214),[G0tensor(463)])
  call ol_merge_tensors(T0sum(215),[G0tensor(554)])
  call ol_merge_tensors(T0sum(216),[G0tensor(543)])
  call ol_merge_tensors(T0sum(217),[G0tensor(365)])
  call ol_merge_tensors(T0sum(218),[G0tensor(475)])
  call ol_merge_tensors(T0sum(219),[G0tensor(539)])
  call ol_merge_tensors(T0sum(220),[G0tensor(556)])
  call ol_merge_tensors(T0sum(221),[G0tensor(485)])
  call ol_merge_tensors(T0sum(222),[G0tensor(493)])
  call ol_merge_tensors(T0sum(223),[G0tensor(517)])
  call ol_merge_tensors(T0sum(224),[G0tensor(507)])
  call ol_merge_tensors(T0sum(225),[G0tensor(527)])
  call ol_merge_tensors(T0sum(226),[G0tensor(522)])
  call ol_merge_tensors(T0sum(227),[G0tensor(523)])
  call ol_merge_tensors(T0sum(228),[G0tensor(528)])
  call ol_merge_tensors(T0sum(229),[G0tensor(561)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 18, 19, 23 ],masses2_54,RedSet_4(1),ScalarBoxes(1))
  call compute_scalar_box([ 16, 19, 23 ],masses2_71,RedSet_4(2),ScalarBoxes(2))
  call compute_scalar_box([ 16, 18, 23 ],masses2_71,RedSet_4(3),ScalarBoxes(3))
  call compute_scalar_box([ 16, 18, 19 ],masses2_70,RedSet_4(4),ScalarBoxes(4))
  call compute_scalar_box([ 2, 3, 7 ],masses2_54,RedSet_4(5),ScalarBoxes(5))
  call compute_scalar_box([ 18, 19, 27 ],masses2_54,RedSet_4(6),ScalarBoxes(6))
  call compute_scalar_box([ 16, 19, 27 ],masses2_71,RedSet_4(7),ScalarBoxes(7))
  call compute_scalar_box([ 16, 18, 27 ],masses2_71,RedSet_4(8),ScalarBoxes(8))
  call compute_scalar_box([ 2, 3, 11 ],masses2_54,RedSet_4(9),ScalarBoxes(9))
  call compute_scalar_box([ 17, 19, 23 ],masses2_54,RedSet_4(10),ScalarBoxes(10))
  call compute_scalar_box([ 16, 17, 23 ],masses2_71,RedSet_4(11),ScalarBoxes(11))
  call compute_scalar_box([ 16, 17, 19 ],masses2_70,RedSet_4(12),ScalarBoxes(12))
  call compute_scalar_box([ 1, 3, 7 ],masses2_54,RedSet_4(13),ScalarBoxes(13))
  call compute_scalar_box([ 17, 19, 27 ],masses2_54,RedSet_4(14),ScalarBoxes(14))
  call compute_scalar_box([ 16, 17, 27 ],masses2_71,RedSet_4(15),ScalarBoxes(15))
  call compute_scalar_box([ 1, 3, 11 ],masses2_54,RedSet_4(16),ScalarBoxes(16))
  call compute_scalar_box([ 20, 21, 23 ],masses2_53,RedSet_4(17),ScalarBoxes(17))
  call compute_scalar_box([ 16, 21, 23 ],masses2_59,RedSet_4(18),ScalarBoxes(18))
  call compute_scalar_box([ 16, 20, 23 ],masses2_59,RedSet_4(19),ScalarBoxes(19))
  call compute_scalar_box([ 16, 20, 21 ],masses2_59,RedSet_4(20),ScalarBoxes(20))
  call compute_scalar_box([ 4, 5, 7 ],masses2_53,RedSet_4(21),ScalarBoxes(21))
  call compute_scalar_box([ 20, 21, 23 ],masses2_69,RedSet_4(17),ScalarBoxes(22))
  call compute_scalar_box([ 16, 20, 23 ],masses2_66,RedSet_4(19),ScalarBoxes(23))
  call compute_scalar_box([ 16, 20, 21 ],masses2_66,RedSet_4(20),ScalarBoxes(24))
  call compute_scalar_box([ 4, 5, 7 ],masses2_69,RedSet_4(21),ScalarBoxes(25))
  call compute_scalar_box([ 20, 21, 23 ],masses2_55,RedSet_4(17),ScalarBoxes(26))
  call compute_scalar_box([ 16, 21, 23 ],masses2_61,RedSet_4(18),ScalarBoxes(27))
  call compute_scalar_box([ 16, 20, 23 ],masses2_61,RedSet_4(19),ScalarBoxes(28))
  call compute_scalar_box([ 4, 5, 7 ],masses2_55,RedSet_4(21),ScalarBoxes(29))
  call compute_scalar_box([ 20, 22, 23 ],masses2_53,RedSet_4(22),ScalarBoxes(30))
  call compute_scalar_box([ 16, 22, 23 ],masses2_59,RedSet_4(23),ScalarBoxes(31))
  call compute_scalar_box([ 16, 20, 22 ],masses2_59,RedSet_4(24),ScalarBoxes(32))
  call compute_scalar_box([ 4, 6, 7 ],masses2_53,RedSet_4(25),ScalarBoxes(33))
  call compute_scalar_box([ 20, 22, 23 ],masses2_55,RedSet_4(22),ScalarBoxes(34))
  call compute_scalar_box([ 16, 22, 23 ],masses2_61,RedSet_4(23),ScalarBoxes(35))
  call compute_scalar_box([ 4, 6, 7 ],masses2_55,RedSet_4(25),ScalarBoxes(36))
  call compute_scalar_box([ 20, 22, 23 ],masses2_69,RedSet_4(22),ScalarBoxes(37))
  call compute_scalar_box([ 16, 20, 22 ],masses2_66,RedSet_4(24),ScalarBoxes(38))
  call compute_scalar_box([ 4, 6, 7 ],masses2_69,RedSet_4(25),ScalarBoxes(39))
! end of process


end subroutine vamp_2

end module ol_vamp_2_pphtt_ew_uuxttxh_1_/**/REALKIND
