
module ol_vamp_1_pphtt_ew_ttxhag_2_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphtt_ew_ttxhag_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphtt_ew_ttxhag_2.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pphtt_ew_ttxhag_2_/**/DREALKIND
  use ol_tensor_sum_storage_pphtt_ew_ttxhag_2_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pphtt_ew_ttxhag_2_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pphtt_ew_ttxhag_2_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[nMT,nMT,nMH,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(1),n2h8(1))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[nMT,nMT,nMZ,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(2),n2h8(2))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[nMB,nMB,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(3),n2h8(3))
  Gcoeff(:)%j = (c(42)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[nMT,nMT,0,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(4),n2h8(4))
  Gcoeff(:)%j = (c(43)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(5),h0tab(:,5),[16,4,1,2,8],[nMT,nMT,nMZ,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(5),n2h8(5))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(6),h0tab(:,6),[16,4,1,2,8],[nMB,nMB,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(6),n2h8(6))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(7),h0tab(:,7),[16,2,1,4,8],[nMT,nMH,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(7),n2h8(7))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(8),h0tab(:,8),[16,2,1,4,8],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(8),n2h8(8))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(9),h0tab(:,9),[16,2,1,4,8],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(9),n2h8(9))
  Gcoeff(:)%j = (c(42)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(10),h0tab(:,10),[16,2,1,4,8],[nMT,0,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(10),n2h8(10))
  Gcoeff(:)%j = (c(43)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(11),h0tab(:,11),[16,2,1,4,8],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(11),n2h8(11))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(12),h0tab(:,12),[16,2,1,4,8],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(12),n2h8(12))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(13),h0tab(:,13),[16,4,2,1,8],[nMT,nMT,nMH,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(13),n2h8(13))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(14),h0tab(:,14),[16,4,2,1,8],[nMT,nMT,nMZ,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(14),n2h8(14))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(15),h0tab(:,15),[16,4,2,1,8],[nMB,nMB,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(15),n2h8(15))
  Gcoeff(:)%j = (c(42)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(16),h0tab(:,16),[16,4,2,1,8],[nMT,nMT,0,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(16),n2h8(16))
  Gcoeff(:)%j = (c(43)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(17),h0tab(:,17),[16,4,2,1,8],[nMT,nMT,nMZ,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(17),n2h8(17))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(18),h0tab(:,18),[16,4,2,1,8],[nMB,nMB,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(18),n2h8(18))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(19),h0tab(:,19),[16,2,1,8,4],[nMT,nMH,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(19),n2h8(19))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(20),h0tab(:,20),[16,2,1,8,4],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(20),n2h8(20))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(21),h0tab(:,21),[16,2,1,8,4],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(21),n2h8(21))
  Gcoeff(:)%j = (c(42)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(22),h0tab(:,22),[16,2,1,8,4],[nMT,0,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(22),n2h8(22))
  Gcoeff(:)%j = (c(43)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(23),h0tab(:,23),[16,2,1,8,4],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(23),n2h8(23))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(24),h0tab(:,24),[16,2,1,8,4],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(24),n2h8(24))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(25),h0tab(:,25),[16,1,2,4,8],[nMT,nMH,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(25),n2h8(25))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(26),h0tab(:,26),[16,1,2,4,8],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(26),n2h8(26))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(27),h0tab(:,27),[16,1,2,4,8],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(27),n2h8(27))
  Gcoeff(:)%j = (c(42)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(28),h0tab(:,28),[16,1,2,4,8],[nMT,0,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(28),n2h8(28))
  Gcoeff(:)%j = (c(43)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(29),h0tab(:,29),[16,1,2,4,8],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(29),n2h8(29))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(30),h0tab(:,30),[16,1,2,4,8],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(30),n2h8(30))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(31),h0tab(:,31),[16,1,2,8,4],[nMT,nMH,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(31),n2h8(31))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(32),h0tab(:,32),[16,1,2,8,4],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(32),n2h8(32))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(33),h0tab(:,33),[16,1,2,8,4],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(33),n2h8(33))
  Gcoeff(:)%j = (c(42)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(34),h0tab(:,34),[16,1,2,8,4],[nMT,0,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(34),n2h8(34))
  Gcoeff(:)%j = (c(43)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(35),h0tab(:,35),[16,1,2,8,4],[nMT,nMZ,nMT,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(35),n2h8(35))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(36),h0tab(:,36),[16,1,2,8,4],[nMB,nMW,nMB,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(36),n2h8(36))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(37),h0tab(:,37),[16,2,4,1,8],[nMT,nMH,nMH,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(37),n2h8(37))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(38),h0tab(:,38),[16,2,4,1,8],[nMT,nMZ,nMZ,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(38),n2h8(38))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(39),h0tab(:,39),[16,2,4,1,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(39),n2h8(39))
  Gcoeff(:)%j = (c(37)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(40),h0tab(:,40),[16,2,4,1,8],[nMT,nMZ,nMZ,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(40),n2h8(40))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(41),h0tab(:,41),[16,2,4,1,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(41),n2h8(41))
  Gcoeff(:)%j = (c(37)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(42),h0tab(:,42),[16,2,4,1,8],[nMT,nMZ,nMZ,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(42),n2h8(42))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(43),h0tab(:,43),[16,2,4,1,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,43),heltab2x16(:,:,43))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(43),n2h8(43))
  Gcoeff(:)%j = (c(46)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(44),h0tab(:,44),[16,2,4,1,8],[nMT,nMZ,nMZ,nMT,nMT],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,44),heltab2x16(:,:,44))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(44),n2h8(44))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(45),h0tab(:,45),[16,2,4,1,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,45),heltab2x16(:,:,45))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(45),n2h8(45))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(46),h0tab(:,46),[16,2,8,1,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,46),heltab2x16(:,:,46))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(46),n2h8(46))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(47),h0tab(:,47),[16,2,8,1,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,47),heltab2x16(:,:,47))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(47),n2h8(47))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(48),h0tab(:,48),[16,2,8,1,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,48),heltab2x16(:,:,48))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(48),n2h8(48))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(49),h0tab(:,49),[16,2,8,1,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,49),heltab2x16(:,:,49))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(49),n2h8(49))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(50),h0tab(:,50),[16,1,4,2,8],[nMT,nMH,nMH,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,50),heltab2x16(:,:,50))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(50),n2h8(50))
  Gcoeff(:)%j = (c(15)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(51),h0tab(:,51),[16,1,4,2,8],[nMT,nMZ,nMZ,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,51),heltab2x16(:,:,51))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(51),n2h8(51))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(52),h0tab(:,52),[16,1,4,2,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,52),heltab2x16(:,:,52))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(52),n2h8(52))
  Gcoeff(:)%j = (c(37)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(53),h0tab(:,53),[16,1,4,2,8],[nMT,nMZ,nMZ,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,53),heltab2x16(:,:,53))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(53),n2h8(53))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(54),h0tab(:,54),[16,1,4,2,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,54),heltab2x16(:,:,54))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(54),n2h8(54))
  Gcoeff(:)%j = (c(37)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(55),h0tab(:,55),[16,1,4,2,8],[nMT,nMZ,nMZ,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,55),heltab2x16(:,:,55))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(55),n2h8(55))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(56),h0tab(:,56),[16,1,4,2,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,56),heltab2x16(:,:,56))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(56),n2h8(56))
  Gcoeff(:)%j = (c(46)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(57),h0tab(:,57),[16,1,4,2,8],[nMT,nMZ,nMZ,nMT,nMT],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,57),heltab2x16(:,:,57))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(57),n2h8(57))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(58),h0tab(:,58),[16,1,4,2,8],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,58),heltab2x16(:,:,58))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(58),n2h8(58))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(59),h0tab(:,59),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,59),heltab2x16(:,:,59))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(59),n2h8(59))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(60),h0tab(:,60),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,60),heltab2x16(:,:,60))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(60),n2h8(60))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(61),h0tab(:,61),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,61),heltab2x16(:,:,61))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(61),n2h8(61))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(62),h0tab(:,62),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,62),heltab2x16(:,:,62))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(62),n2h8(62))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(63),h0tab(:,63),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,63),heltab2x16(:,:,63))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(63),n2h8(63))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(64),h0tab(:,64),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,64),heltab2x16(:,:,64))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(64),n2h8(64))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(65),h0tab(:,65),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,65),heltab2x16(:,:,65))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(65),n2h8(65))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(66),h0tab(:,66),[16,1,4,8,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,66),heltab2x16(:,:,66))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(66),n2h8(66))
  Gcoeff(:)%j = (c(6)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(67),h0tab(:,67),[16,1,8,2,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,67),heltab2x16(:,:,67))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(67),n2h8(67))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(68),h0tab(:,68),[16,1,8,2,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,68),heltab2x16(:,:,68))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(68),n2h8(68))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(69),h0tab(:,69),[16,1,8,2,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,69),heltab2x16(:,:,69))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(69),n2h8(69))
  Gcoeff(:)%j = (c(23)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(70),h0tab(:,70),[16,1,8,2,4],[nMB,nMW,nMW,nMB,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,70),heltab2x16(:,:,70))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(70),n2h8(70))
  Gcoeff(:)%j = (c(9)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(71),h0tab(:,71),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,71),heltab2x16(:,:,71))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(71),n2h8(71))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(72),h0tab(:,72),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,72),heltab2x16(:,:,72))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(72),n2h8(72))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(73),h0tab(:,73),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,73),heltab2x16(:,:,73))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(73),n2h8(73))
  Gcoeff(:)%j = (c(24)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(74),h0tab(:,74),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,74),heltab2x16(:,:,74))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(74),n2h8(74))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(75),h0tab(:,75),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,75),heltab2x16(:,:,75))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(75),n2h8(75))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(76),h0tab(:,76),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,76),heltab2x16(:,:,76))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(76),n2h8(76))
  Gcoeff(:)%j = (c(31)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(77),h0tab(:,77),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,77),heltab2x16(:,:,77))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(77),n2h8(77))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(78),h0tab(:,78),[16,1,8,4,2],[nMB,nMW,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,78),heltab2x16(:,:,78))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(78),n2h8(78))
  call Hloop_AS_Q(ntryL,G1H8(1),ex3(:),G1H8(79),ngH,m3h1x8(:,1),heltab2x8(:,:,1))
  call Hloop_A_Q(ntryL,G1H8(79),20,nMT,G2H8(1),n2h8(79))
  call Hloop_AS_Q(ntryL,G1H8(2),ex3(:),G1H8(1),ngH,m3h1x8(:,2),heltab2x8(:,:,2))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(2),n2h8(80))
  call Hloop_AS_Q(ntryL,G1H8(3),ex3(:),G1H8(79),ngH,m3h1x8(:,3),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G1H8(79),20,nMB,G2H8(3),n2h8(81))
  call Hloop_AS_Q(ntryL,G1H8(4),ex3(:),G1H8(2),ngH,m3h1x8(:,4),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G1H8(2),20,nMT,G2H8(4),n2h8(82))
  call Hloop_AS_Q(ntryL,G1H8(5),ex3(:),G1H8(1),ngH,m3h1x8(:,5),heltab2x8(:,:,5))
  call Hloop_A_Q(ntryL,G1H8(1),20,nMT,G2H8(5),n2h8(83))
  call Hloop_AS_Q(ntryL,G1H8(6),ex3(:),G1H8(3),ngH,m3h1x8(:,6),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G1H8(3),20,nMB,G2H8(6),n2h8(84))
  call Hloop_QA_S(ntryL,G1H8(7),ex2(:),G1H4(1),ngH,m3h2x4(:,1),heltab2x8(:,:,7))
  call Hloop_QA_S(ntryL,G1H8(8),ex2(:),G1H4(2),ngX,m3h2x4(:,2),heltab2x8(:,:,8))
  call Hloop_QA_S(ntryL,G1H8(9),ex2(:),G1H4(3),ngPtb,m3h2x4(:,3),heltab2x8(:,:,9))
  call Hloop_QA_V(ntryL,G1H8(10),ex2(:),G1H4(4),m3h2x4(:,4),heltab2x8(:,:,10))
  call Hloop_QA_Z(ntryL,G1H8(11),ex2(:),G1H4(5),ngZu,m3h2x4(:,5),heltab2x8(:,:,11))
  call Hloop_QA_W(ntryL,G1H8(12),ex2(:),G1H4(6),m3h2x4(:,6),heltab2x8(:,:,12))
  call Hloop_QS_A(ntryL,G1H8(13),ex3(:),G1H8(79),ngH,m3h1x8(:,7),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H8(79),20,nMT,G2H8(7),n2h8(85))
  call Hloop_QS_A(ntryL,G1H8(14),ex3(:),G1H8(4),ngH,m3h1x8(:,8),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G1H8(4),20,nMT,G2H8(8),n2h8(86))
  call Hloop_QS_A(ntryL,G1H8(15),ex3(:),G1H8(2),ngH,m3h1x8(:,9),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H8(2),20,nMB,G2H8(9),n2h8(87))
  call Hloop_QS_A(ntryL,G1H8(16),ex3(:),G1H8(5),ngH,m3h1x8(:,10),heltab2x8(:,:,16))
  call Hloop_Q_A(ntryL,G1H8(5),20,nMT,G2H8(10),n2h8(88))
  call Hloop_QS_A(ntryL,G1H8(17),ex3(:),G1H8(1),ngH,m3h1x8(:,11),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G1H8(1),20,nMT,G2H8(11),n2h8(89))
  call Hloop_QS_A(ntryL,G1H8(18),ex3(:),G1H8(6),ngH,m3h1x8(:,12),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G1H8(6),20,nMB,G2H8(12),n2h8(90))
  call Hloop_QA_S(ntryL,G1H8(19),ex2(:),G1H4(7),ngH,m3h2x4(:,7),heltab2x8(:,:,19))
  call Hloop_QA_S(ntryL,G1H8(20),ex2(:),G1H4(8),ngX,m3h2x4(:,8),heltab2x8(:,:,20))
  call Hloop_QA_S(ntryL,G1H8(21),ex2(:),G1H4(9),ngPtb,m3h2x4(:,9),heltab2x8(:,:,21))
  call Hloop_QA_V(ntryL,G1H8(22),ex2(:),G1H4(10),m3h2x4(:,10),heltab2x8(:,:,22))
  call Hloop_QA_Z(ntryL,G1H8(23),ex2(:),G1H4(11),ngZu,m3h2x4(:,11),heltab2x8(:,:,23))
  call Hloop_QA_W(ntryL,G1H8(24),ex2(:),G1H4(12),m3h2x4(:,12),heltab2x8(:,:,24))
  call Hloop_AQ_S(ntryL,G1H8(25),ex1(:),G1H4(13),ngH,m3h2x4(:,13),heltab2x8(:,:,25))
  call Hloop_AQ_S(ntryL,G1H8(26),ex1(:),G1H4(14),ngX,m3h2x4(:,14),heltab2x8(:,:,26))
  call Hloop_AQ_S(ntryL,G1H8(27),ex1(:),G1H4(15),ngPbt,m3h2x4(:,15),heltab2x8(:,:,27))
  call Hloop_AQ_V(ntryL,G1H8(28),ex1(:),G1H4(16),m3h2x4(:,16),heltab2x8(:,:,28))
  call Hloop_AQ_Z(ntryL,G1H8(29),ex1(:),G1H4(17),ngZu,m3h2x4(:,17),heltab2x8(:,:,29))
  call Hloop_AQ_W(ntryL,G1H8(30),ex1(:),G1H4(18),m3h2x4(:,18),heltab2x8(:,:,30))
  call Hloop_AQ_S(ntryL,G1H8(31),ex1(:),G1H4(19),ngH,m3h2x4(:,19),heltab2x8(:,:,31))
  call Hloop_AQ_S(ntryL,G1H8(32),ex1(:),G1H4(20),ngX,m3h2x4(:,20),heltab2x8(:,:,32))
  call Hloop_AQ_S(ntryL,G1H8(33),ex1(:),G1H4(21),ngPbt,m3h2x4(:,21),heltab2x8(:,:,33))
  call Hloop_AQ_V(ntryL,G1H8(34),ex1(:),G1H4(22),m3h2x4(:,22),heltab2x8(:,:,34))
  call Hloop_AQ_Z(ntryL,G1H8(35),ex1(:),G1H4(23),ngZu,m3h2x4(:,23),heltab2x8(:,:,35))
  call Hloop_AQ_W(ntryL,G1H8(36),ex1(:),G1H4(24),m3h2x4(:,24),heltab2x8(:,:,36))
  call Hloop_QA_S(ntryL,G1H8(37),ex2(:),G1H4(25),ngH,m3h2x4(:,25),heltab2x8(:,:,37))
  call Hloop_QA_S(ntryL,G1H8(38),ex2(:),G1H4(26),ngX,m3h2x4(:,26),heltab2x8(:,:,38))
  call Hloop_QA_S(ntryL,G1H8(39),ex2(:),G1H4(27),ngPtb,m3h2x4(:,27),heltab2x8(:,:,39))
  call Hloop_QA_Z(ntryL,G1H8(40),ex2(:),G1H4(28),ngZu,m3h2x4(:,28),heltab2x8(:,:,40))
  call Hloop_QA_W(ntryL,G1H8(41),ex2(:),G1H4(29),m3h2x4(:,29),heltab2x8(:,:,41))
  call Hloop_QA_S(ntryL,G1H8(42),ex2(:),G1H4(30),ngX,m3h2x4(:,30),heltab2x8(:,:,42))
  call Hloop_QA_S(ntryL,G1H8(43),ex2(:),G1H4(31),ngPtb,m3h2x4(:,31),heltab2x8(:,:,43))
  call Hloop_QA_Z(ntryL,G1H8(44),ex2(:),G1H4(32),ngZu,m3h2x4(:,32),heltab2x8(:,:,44))
  call Hloop_QA_W(ntryL,G1H8(45),ex2(:),G1H4(33),m3h2x4(:,33),heltab2x8(:,:,45))
  call Hloop_QA_S(ntryL,G1H8(46),ex2(:),G1H4(34),ngPtb,m3h2x4(:,34),heltab2x8(:,:,46))
  call Hloop_QA_W(ntryL,G1H8(47),ex2(:),G1H4(35),m3h2x4(:,35),heltab2x8(:,:,47))
  call Hloop_QA_S(ntryL,G1H8(48),ex2(:),G1H4(36),ngPtb,m3h2x4(:,36),heltab2x8(:,:,48))
  call Hloop_QA_W(ntryL,G1H8(49),ex2(:),G1H4(37),m3h2x4(:,37),heltab2x8(:,:,49))
  call Hloop_AQ_S(ntryL,G1H8(50),ex1(:),G1H4(38),ngH,m3h2x4(:,38),heltab2x8(:,:,50))
  call Hloop_AQ_S(ntryL,G1H8(51),ex1(:),G1H4(39),ngX,m3h2x4(:,39),heltab2x8(:,:,51))
  call Hloop_AQ_S(ntryL,G1H8(52),ex1(:),G1H4(40),ngPbt,m3h2x4(:,40),heltab2x8(:,:,52))
  call Hloop_AQ_S(ntryL,G1H8(53),ex1(:),G1H4(41),ngX,m3h2x4(:,41),heltab2x8(:,:,53))
  call Hloop_AQ_S(ntryL,G1H8(54),ex1(:),G1H4(42),ngPbt,m3h2x4(:,42),heltab2x8(:,:,54))
  call Hloop_AQ_Z(ntryL,G1H8(55),ex1(:),G1H4(43),ngZu,m3h2x4(:,43),heltab2x8(:,:,55))
  call Hloop_AQ_W(ntryL,G1H8(56),ex1(:),G1H4(44),m3h2x4(:,44),heltab2x8(:,:,56))
  call Hloop_AQ_Z(ntryL,G1H8(57),ex1(:),G1H4(45),ngZu,m3h2x4(:,45),heltab2x8(:,:,57))
  call Hloop_AQ_W(ntryL,G1H8(58),ex1(:),G1H4(46),m3h2x4(:,46),heltab2x8(:,:,58))
  call Hloop_AQ_S(ntryL,G1H8(59),ex1(:),G1H4(47),ngPbt,m3h2x4(:,47),heltab2x8(:,:,59))
  call Hloop_AQ_S(ntryL,G1H8(60),ex1(:),G1H4(48),ngPbt,m3h2x4(:,48),heltab2x8(:,:,60))
  call Hloop_AQ_S(ntryL,G1H8(61),ex1(:),G1H4(49),ngPbt,m3h2x4(:,49),heltab2x8(:,:,61))
  call Hloop_AQ_W(ntryL,G1H8(62),ex1(:),G1H4(50),m3h2x4(:,50),heltab2x8(:,:,62))
  call Hloop_AQ_S(ntryL,G1H8(63),ex1(:),G1H4(51),ngPbt,m3h2x4(:,51),heltab2x8(:,:,63))
  call Hloop_AQ_W(ntryL,G1H8(64),ex1(:),G1H4(52),m3h2x4(:,52),heltab2x8(:,:,64))
  call Hloop_AQ_W(ntryL,G1H8(65),ex1(:),G1H4(53),m3h2x4(:,53),heltab2x8(:,:,65))
  call Hloop_AQ_W(ntryL,G1H8(66),ex1(:),G1H4(54),m3h2x4(:,54),heltab2x8(:,:,66))
  call Hloop_AQ_S(ntryL,G1H8(67),ex1(:),G1H4(55),ngPbt,m3h2x4(:,55),heltab2x8(:,:,67))
  call Hloop_AQ_S(ntryL,G1H8(68),ex1(:),G1H4(56),ngPbt,m3h2x4(:,56),heltab2x8(:,:,68))
  call Hloop_AQ_W(ntryL,G1H8(69),ex1(:),G1H4(57),m3h2x4(:,57),heltab2x8(:,:,69))
  call Hloop_AQ_W(ntryL,G1H8(70),ex1(:),G1H4(58),m3h2x4(:,58),heltab2x8(:,:,70))
  call Hloop_AQ_S(ntryL,G1H8(71),ex1(:),G1H4(59),ngPbt,m3h2x4(:,59),heltab2x8(:,:,71))
  call Hloop_AQ_S(ntryL,G1H8(72),ex1(:),G1H4(60),ngPbt,m3h2x4(:,60),heltab2x8(:,:,72))
  call Hloop_AQ_S(ntryL,G1H8(73),ex1(:),G1H4(61),ngPbt,m3h2x4(:,61),heltab2x8(:,:,73))
  call Hloop_AQ_W(ntryL,G1H8(74),ex1(:),G1H4(62),m3h2x4(:,62),heltab2x8(:,:,74))
  call Hloop_AQ_S(ntryL,G1H8(75),ex1(:),G1H4(63),ngPbt,m3h2x4(:,63),heltab2x8(:,:,75))
  call Hloop_AQ_W(ntryL,G1H8(76),ex1(:),G1H4(64),m3h2x4(:,64),heltab2x8(:,:,76))
  call Hloop_AQ_W(ntryL,G1H8(77),ex1(:),G1H4(65),m3h2x4(:,65),heltab2x8(:,:,77))
  call Hloop_AQ_W(ntryL,G1H8(78),ex1(:),G1H4(66),m3h2x4(:,66),heltab2x8(:,:,78))
  call Hloop_AQ_S(ntryL,G2H8(1),ex1(:),G2H4(1),ngH,m3h2x4(:,67),heltab2x8(:,:,79))
  call Hloop_AQ_S(ntryL,G2H8(2),ex1(:),G2H4(2),ngX,m3h2x4(:,68),heltab2x8(:,:,80))
  call Hloop_AQ_S(ntryL,G2H8(3),ex1(:),G2H4(3),ngPbt,m3h2x4(:,69),heltab2x8(:,:,81))
  call Hloop_AQ_V(ntryL,G2H8(4),ex1(:),G2H4(4),m3h2x4(:,70),heltab2x8(:,:,82))
  call Hloop_AQ_Z(ntryL,G2H8(5),ex1(:),G2H4(5),ngZu,m3h2x4(:,71),heltab2x8(:,:,83))
  call Hloop_AQ_W(ntryL,G2H8(6),ex1(:),G2H4(6),m3h2x4(:,72),heltab2x8(:,:,84))
  call Hloop_SQ_A(ntryL,G1H4(1),ex1(:),G1H2(1),ngH,m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMT,G2H2(1),n2h2(1))
  call Hloop_SQ_A(ntryL,G1H4(2),ex1(:),G1H2(1),ngX,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMT,G2H2(2),n2h2(2))
  call Hloop_SQ_A(ntryL,G1H4(3),ex1(:),G1H2(1),ngPbt,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMB,G2H2(3),n2h2(3))
  call Hloop_VQ_A(ntryL,G1H4(4),ex1(:),G1H2(1),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMT,G2H2(4),n2h2(4))
  call Hloop_ZQ_A(ntryL,G1H4(5),ex1(:),G1H2(1),ngZu,m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMT,G2H2(5),n2h2(5))
  call Hloop_WQ_A(ntryL,G1H4(6),ex1(:),G1H2(1),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMB,G2H2(6),n2h2(6))
  call Hloop_QA_S(ntryL,G2H8(7),ex2(:),G2H4(7),ngH,m3h2x4(:,73),heltab2x8(:,:,85))
  call Hloop_QA_S(ntryL,G2H8(8),ex2(:),G2H4(8),ngX,m3h2x4(:,74),heltab2x8(:,:,86))
  call Hloop_QA_S(ntryL,G2H8(9),ex2(:),G2H4(9),ngPtb,m3h2x4(:,75),heltab2x8(:,:,87))
  call Hloop_QA_V(ntryL,G2H8(10),ex2(:),G2H4(10),m3h2x4(:,76),heltab2x8(:,:,88))
  call Hloop_QA_Z(ntryL,G2H8(11),ex2(:),G2H4(11),ngZu,m3h2x4(:,77),heltab2x8(:,:,89))
  call Hloop_QA_W(ntryL,G2H8(12),ex2(:),G2H4(12),m3h2x4(:,78),heltab2x8(:,:,90))
  call Hloop_SQ_A(ntryL,G1H4(7),ex1(:),G1H2(1),ngH,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMT,G2H2(7),n2h2(7))
  call Hloop_SQ_A(ntryL,G1H4(8),ex1(:),G1H2(1),ngX,m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMT,G2H2(8),n2h2(8))
  call Hloop_SQ_A(ntryL,G1H4(9),ex1(:),G1H2(1),ngPbt,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMB,G2H2(9),n2h2(9))
  call Hloop_VQ_A(ntryL,G1H4(10),ex1(:),G1H2(1),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMT,G2H2(10),n2h2(10))
  call Hloop_ZQ_A(ntryL,G1H4(11),ex1(:),G1H2(1),ngZu,m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMT,G2H2(11),n2h2(11))
  call Hloop_WQ_A(ntryL,G1H4(12),ex1(:),G1H2(1),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(1),19,nMB,G2H2(12),n2h2(12))
  call Hloop_SA_Q(ntryL,G1H4(13),ex2(:),G1H2(1),ngH,m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMT,G2H2(13),n2h2(13))
  call Hloop_SA_Q(ntryL,G1H4(14),ex2(:),G1H2(1),ngX,m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMT,G2H2(14),n2h2(14))
  call Hloop_SA_Q(ntryL,G1H4(15),ex2(:),G1H2(1),ngPtb,m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMB,G2H2(15),n2h2(15))
  call Hloop_VA_Q(ntryL,G1H4(16),ex2(:),G1H2(1),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMT,G2H2(16),n2h2(16))
  call Hloop_ZA_Q(ntryL,G1H4(17),ex2(:),G1H2(1),ngZu,m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMT,G2H2(17),n2h2(17))
  call Hloop_WA_Q(ntryL,G1H4(18),ex2(:),G1H2(1),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMB,G2H2(18),n2h2(18))
  call Hloop_SA_Q(ntryL,G1H4(19),ex2(:),G1H2(1),ngH,m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMT,G2H2(19),n2h2(19))
  call Hloop_SA_Q(ntryL,G1H4(20),ex2(:),G1H2(1),ngX,m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMT,G2H2(20),n2h2(20))
  call Hloop_SA_Q(ntryL,G1H4(21),ex2(:),G1H2(1),ngPtb,m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMB,G2H2(21),n2h2(21))
  call Hloop_VA_Q(ntryL,G1H4(22),ex2(:),G1H2(1),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMT,G2H2(22),n2h2(22))
  call Hloop_ZA_Q(ntryL,G1H4(23),ex2(:),G1H2(1),ngZu,m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMT,G2H2(23),n2h2(23))
  call Hloop_WA_Q(ntryL,G1H4(24),ex2(:),G1H2(1),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(1),19,nMB,G2H2(24),n2h2(24))
  call Hloop_SS_S(ntryL,G1H4(25),ex3(:),G1H4(1),m3h1x4(:,1),heltab2x4(:,:,25))
  call Hloop_SS_S(ntryL,G1H4(26),ex3(:),G1H4(2),m3h1x4(:,2),heltab2x4(:,:,26))
  call Hloop_SS_S(ntryL,G1H4(27),ex3(:),G1H4(3),m3h1x4(:,3),heltab2x4(:,:,27))
  call Hloop_VT_S(ntryL,G1H4(28),18,ex3(:),4,G2H4(13),m3h1x4(:,4),heltab2x4(:,:,28))
  call Hloop_VT_S(ntryL,G1H4(29),18,ex3(:),4,G2H4(14),m3h1x4(:,5),heltab2x4(:,:,29))
  call Hloop_ST_V(ntryL,G1H4(30),18,ex3(:),4,G2H4(15),m3h1x4(:,6),heltab2x4(:,:,30))
  call Hloop_ST_V(ntryL,G1H4(31),18,ex3(:),4,G2H4(16),m3h1x4(:,7),heltab2x4(:,:,31))
  call Hloop_VS_V(ntryL,G1H4(32),ex3(:),G1H4(4),m3h1x4(:,8),heltab2x4(:,:,32))
  call Hloop_VS_V(ntryL,G1H4(33),ex3(:),G1H4(5),m3h1x4(:,9),heltab2x4(:,:,33))
  call Hloop_TV_S(ntryL,G1H4(34),18,ex4(:),8,G2H2(25),m3h2x2(:,25),heltab2x4(:,:,34))
  call Hloop_VV_S(ntryL,G1H4(35),ex4(:),G1H2(1),m3h2x2(:,26),heltab2x4(:,:,35))
  call Hloop_SV_V(ntryL,G1H4(36),ex4(:),G1H2(2),m3h2x2(:,27),heltab2x4(:,:,36))
  call Hloop_UV_W(ntryL,G1H4(37),18,ex4(:),8,G2H2(26),m3h2x2(:,28),heltab2x4(:,:,37))
  call Hloop_SS_S(ntryL,G1H4(38),ex3(:),G1H4(6),m3h1x4(:,10),heltab2x4(:,:,38))
  call Hloop_SS_S(ntryL,G1H4(39),ex3(:),G1H4(7),m3h1x4(:,11),heltab2x4(:,:,39))
  call Hloop_SS_S(ntryL,G1H4(40),ex3(:),G1H4(8),m3h1x4(:,12),heltab2x4(:,:,40))
  call Hloop_ST_V(ntryL,G1H4(41),17,ex3(:),4,G2H4(17),m3h1x4(:,13),heltab2x4(:,:,41))
  call Hloop_ST_V(ntryL,G1H4(42),17,ex3(:),4,G2H4(18),m3h1x4(:,14),heltab2x4(:,:,42))
  call Hloop_VT_S(ntryL,G1H4(43),17,ex3(:),4,G2H4(19),m3h1x4(:,15),heltab2x4(:,:,43))
  call Hloop_VT_S(ntryL,G1H4(44),17,ex3(:),4,G2H4(20),m3h1x4(:,16),heltab2x4(:,:,44))
  call Hloop_VS_V(ntryL,G1H4(45),ex3(:),G1H4(9),m3h1x4(:,17),heltab2x4(:,:,45))
  call Hloop_VS_V(ntryL,G1H4(46),ex3(:),G1H4(10),m3h1x4(:,18),heltab2x4(:,:,46))
  call Hloop_SS_S(ntryL,G1H4(47),ex3(:),G1H4(11),m3h1x4(:,19),heltab2x4(:,:,47))
  call Hloop_ST_V(ntryL,G1H4(48),17,ex3(:),4,G2H4(21),m3h1x4(:,20),heltab2x4(:,:,48))
  call Hloop_SS_S(ntryL,G1H4(49),ex3(:),G1H4(12),m3h1x4(:,21),heltab2x4(:,:,49))
  call Hloop_VT_S(ntryL,G1H4(50),17,ex3(:),4,G2H4(22),m3h1x4(:,22),heltab2x4(:,:,50))
  call Hloop_ST_V(ntryL,G1H4(51),17,ex3(:),4,G2H4(23),m3h1x4(:,23),heltab2x4(:,:,51))
  call Hloop_VS_V(ntryL,G1H4(52),ex3(:),G1H4(13),m3h1x4(:,24),heltab2x4(:,:,52))
  call Hloop_VT_S(ntryL,G1H4(53),17,ex3(:),4,G2H4(24),m3h1x4(:,25),heltab2x4(:,:,53))
  call Hloop_VS_V(ntryL,G1H4(54),ex3(:),G1H4(14),m3h1x4(:,26),heltab2x4(:,:,54))
  call Hloop_SV_T(ntryL,G1H4(55),17,ex4(:),8,G2H2(27),m3h2x2(:,29),heltab2x4(:,:,55))
  call Hloop_SV_V(ntryL,G1H4(56),ex4(:),G1H2(3),m3h2x2(:,30),heltab2x4(:,:,56))
  call Hloop_VV_S(ntryL,G1H4(57),ex4(:),G1H2(4),m3h2x2(:,31),heltab2x4(:,:,57))
  call Hloop_UW_V(ntryL,G1H4(58),17,ex4(:),8,G2H2(28),m3h2x2(:,32),heltab2x4(:,:,58))
  call Hloop_SV_T(ntryL,G1H4(59),17,ex4(:),8,G2H2(29),m3h2x2(:,33),heltab2x4(:,:,59))
  call Hloop_SV_V(ntryL,G1H4(60),ex4(:),G1H2(5),m3h2x2(:,34),heltab2x4(:,:,60))
  call Hloop_SV_T(ntryL,G1H4(61),17,ex4(:),8,G2H2(30),m3h2x2(:,35),heltab2x4(:,:,61))
  call Hloop_VV_S(ntryL,G1H4(62),ex4(:),G1H2(6),m3h2x2(:,36),heltab2x4(:,:,62))
  call Hloop_SV_V(ntryL,G1H4(63),ex4(:),G1H2(7),m3h2x2(:,37),heltab2x4(:,:,63))
  call Hloop_UW_V(ntryL,G1H4(64),17,ex4(:),8,G2H2(31),m3h2x2(:,38),heltab2x4(:,:,64))
  call Hloop_VV_S(ntryL,G1H4(65),ex4(:),G1H2(8),m3h2x2(:,39),heltab2x4(:,:,65))
  call Hloop_UW_V(ntryL,G1H4(66),17,ex4(:),8,G2H2(32),m3h2x2(:,40),heltab2x4(:,:,66))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G2H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G2H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G2H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G2H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G2H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G2H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G2H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G2H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(13),[G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(14),[G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(15),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(16),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(25),[G1H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G1H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(19),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(20),[G1H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(17),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(22),[G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(21),[G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(24),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(23),[G1H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(27),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(29),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(31),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(30),[G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G1H2(7)])
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(15),G1H4(16),G1H4(17),G1H4(18),G1H4(19),G1H4(20),4)
  call HG1shiftOLR(G1H4(16),8,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(1),mass5set(:,2),  & 
G1H4(21),G1H4(22),G1H4(23),G1H4(24),G1H4(25),G1H4(26),4)
  call HG1shiftOLR(G1H4(22),8,4)
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(1),mass5set(:,3),  & 
G1H4(27),G1H4(28),G1H4(29),G1H4(30),G1H4(31),G1H4(32),4)
  call HG1shiftOLR(G1H4(28),8,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(1),mass5set(:,4),  & 
G1H4(33),G1H4(34),G1H4(35),G1H4(36),G1H4(37),G1H4(38),4)
  call HG1shiftOLR(G1H4(34),8,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(1),mass5set(:,2),  & 
G1H4(39),G1H4(40),G1H4(41),G1H4(42),G1H4(43),G1H4(44),4)
  call HG1shiftOLR(G1H4(40),8,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(1),mass5set(:,3),  & 
G1H4(45),G1H4(46),G1H4(47),G1H4(48),G1H4(49),G1H4(50),4)
  call HG1shiftOLR(G1H4(46),8,4)
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(2),mass5set(:,5),  & 
G1H2(1),G1H2(2),G1H2(4),G1H2(3),G1H2(6),G1H2(5),2)
  call HG1shiftOLR(G1H2(2),8,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(2),mass5set(:,6),  & 
G1H2(8),G1H2(7),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(7),8,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(2),mass5set(:,7),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),8,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(2),mass5set(:,8),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),8,2)
  call Hotf_5pt_reduction(G2H4(7),RedSet_5(3),mass5set(:,1),  & 
G1H4(51),G1H4(52),G1H4(53),G1H4(54),G1H4(55),G1H4(56),4)
  call HG1shiftOLR(G1H4(52),8,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(3),mass5set(:,2),  & 
G1H4(57),G1H4(58),G1H4(59),G1H4(60),G1H4(61),G1H4(62),4)
  call HG1shiftOLR(G1H4(58),8,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(3),mass5set(:,3),  & 
G1H4(63),G1H4(64),G1H4(65),G1H4(66),G1H4(2),G1H4(3),4)
  call HG1shiftOLR(G1H4(64),8,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(3),mass5set(:,4),  & 
G1H4(4),G1H4(5),G1H4(7),G1H4(8),G1H4(9),G1H4(10),4)
  call HG1shiftOLR(G1H4(5),8,4)
  call Hotf_5pt_reduction(G2H4(11),RedSet_5(3),mass5set(:,2),  & 
G1H4(11),G1H4(13),G1H4(12),G1H4(14),G1H4(67),G1H4(68),4)
  call HG1shiftOLR(G1H4(13),8,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(3),mass5set(:,3),  & 
G1H4(69),G1H4(70),G1H4(71),G1H4(72),G1H4(73),G1H4(74),4)
  call HG1shiftOLR(G1H4(70),8,4)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(4),mass5set(:,5),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),4,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(4),mass5set(:,6),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),4,2)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(4),mass5set(:,7),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),4,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(4),mass5set(:,8),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(44),4,2)
  call Hotf_5pt_reduction(G2H2(13),RedSet_5(5),mass5set(:,5),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(50),8,2)
  call Hotf_5pt_reduction(G2H2(17),RedSet_5(5),mass5set(:,6),  & 
G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(56),8,2)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(5),mass5set(:,7),  & 
G1H2(61),G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),2)
  call HG1shiftOLR(G1H2(62),8,2)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(5),mass5set(:,8),  & 
G1H2(67),G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),2)
  call HG1shiftOLR(G1H2(68),8,2)
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(6),mass5set(:,5),  & 
G1H2(73),G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),2)
  call HG1shiftOLR(G1H2(74),4,2)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(6),mass5set(:,6),  & 
G1H2(79),G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),2)
  call HG1shiftOLR(G1H2(80),4,2)
  call Hotf_5pt_reduction(G2H2(24),RedSet_5(6),mass5set(:,7),  & 
G1H2(85),G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),2)
  call HG1shiftOLR(G1H2(86),4,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(6),mass5set(:,8),  & 
G1H2(91),G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),2)
  call HG1shiftOLR(G1H2(92),4,2)
  call Hloop_SQ_A(ntryL,G1H4(1),ex1(:),G1H2(97),ngH,m3h2x2(:,41),heltab2x4(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(97),23,nMT,G2H2(2),n2h2(25))
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(7),mass5set(:,9),  & 
G1H4(1),G1H4(75),G1H4(76),G1H4(77),G1H4(78),G1H4(79),4)
  call HG1shiftOLR(G1H4(75),8,4)
  call Hotf_5pt_reduction(G2H4(14),RedSet_5(7),mass5set(:,10),  & 
G1H4(80),G1H4(81),G1H4(82),G1H4(83),G1H4(84),G1H4(85),4)
  call HG1shiftOLR(G1H4(81),8,4)
  call Hotf_5pt_reduction(G2H4(15),RedSet_5(7),mass5set(:,9),  & 
G1H4(86),G1H4(87),G1H4(88),G1H4(89),G1H4(90),G1H4(91),4)
  call HG1shiftOLR(G1H4(87),8,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(7),mass5set(:,10),  & 
G1H4(92),G1H4(93),G1H4(94),G1H4(95),G1H4(96),G1H4(97),4)
  call HG1shiftOLR(G1H4(93),8,4)
  call Hotf_5pt_reduction(G2H2(25),RedSet_5(8),mass5set(:,10),  & 
G1H2(97),G1H2(98),G1H2(99),G1H2(100),G1H2(101),G1H2(102),2)
  call HG1shiftOLR(G1H2(98),4,2)
  call Hotf_5pt_reduction(G2H2(26),RedSet_5(8),mass5set(:,10),  & 
G1H2(103),G1H2(104),G1H2(105),G1H2(106),G1H2(107),G1H2(108),2)
  call HG1shiftOLR(G1H2(104),4,2)
  call Hloop_SA_Q(ntryL,G1H4(6),ex2(:),G1H2(109),ngH,m3h2x2(:,42),heltab2x4(:,:,68))
  call Hloop_A_Q(ntryL,G1H2(109),23,nMT,G2H2(3),n2h2(26))
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(9),mass5set(:,9),  & 
G1H4(6),G1H4(98),G1H4(99),G1H4(100),G1H4(101),G1H4(102),4)
  call HG1shiftOLR(G1H4(98),8,4)
  call Hotf_5pt_reduction(G2H4(20),RedSet_5(9),mass5set(:,10),  & 
G1H4(103),G1H4(104),G1H4(105),G1H4(106),G1H4(107),G1H4(108),4)
  call HG1shiftOLR(G1H4(104),8,4)
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(9),mass5set(:,9),  & 
G1H4(109),G1H4(110),G1H4(111),G1H4(112),G1H4(113),G1H4(114),4)
  call HG1shiftOLR(G1H4(110),8,4)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(9),mass5set(:,10),  & 
G1H4(115),G1H4(116),G1H4(117),G1H4(118),G1H4(119),G1H4(120),4)
  call HG1shiftOLR(G1H4(116),8,4)
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(10),mass5set(:,11),  & 
G1H4(121),G1H4(122),G1H4(123),G1H4(124),G1H4(125),G1H4(126),4)
  call HG1shiftOLR(G1H4(122),2,4)
  call Hloop_VV_S(ntryL,G2H4(21),ex4(:),G2H2(8),m3h2x2(:,43),heltab2x4(:,:,69))
  call Hloop_SV_V(ntryL,G2H4(24),ex4(:),G2H2(9),m3h2x2(:,44),heltab2x4(:,:,70))
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(10),mass5set(:,11),  & 
G1H4(127),G1H4(128),G1H4(129),G1H4(130),G1H4(131),G1H4(132),4)
  call HG1shiftOLR(G1H4(128),2,4)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(11),mass5set(:,10),  & 
G1H2(109),G1H2(110),G1H2(111),G1H2(112),G1H2(113),G1H2(114),2)
  call HG1shiftOLR(G1H2(110),4,2)
  call Hotf_5pt_reduction(G2H2(28),RedSet_5(11),mass5set(:,10),  & 
G1H2(115),G1H2(116),G1H2(117),G1H2(118),G1H2(119),G1H2(120),2)
  call HG1shiftOLR(G1H2(116),4,2)
  call Hloop_SS_S(ntryL,G2H2(29),ex3(:),G2H2(14),m3h1x2(:,1),heltab2x2(:,:,1))
  call Hotf_5pt_reduction(G2H2(31),RedSet_5(12),mass5set(:,11),  & 
G1H2(121),G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),2)
  call HG1shiftOLR(G1H2(122),2,2)
  call Hotf_5pt_reduction(G2H2(30),RedSet_5(12),mass5set(:,11),  & 
G1H2(127),G1H2(128),G1H2(129),G1H2(130),G1H2(131),G1H2(132),2)
  call HG1shiftOLR(G1H2(128),2,2)
  call Hloop_VS_V(ntryL,G2H2(32),ex3(:),G2H2(15),m3h1x2(:,2),heltab2x2(:,:,2))
  call Hloop_SA_Q(ntryL,G1H4(15),ex2(:),G1H2(133),ngH,m3h2x2(:,45),heltab2x4(:,:,71))
  call Hloop_A_Q(ntryL,G1H2(133),23,nMT,G2H2(20),n2h2(27))
call HGT_OLR(G1H4(16),1,1,4)
call HGT_invQ_OLR(G1H4(16),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(16),-8,nMT,G2H4(1),n2h4(1))
  call Hloop_QV_A(ntryL,G2H4(1),ex4(:),G2H2(21),m3h2x2(:,46),heltab2x4(:,:,72))
  call Hloop_SA_Q(ntryL,G1H4(19),ex2(:),G1H2(133),ngH,m3h2x2(:,47),heltab2x4(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(133),23,nMT,G2H2(1),n2h2(28))
  call Hloop_SA_Q(ntryL,G1H4(20),ex2(:),G1H2(133),ngH,m3h2x2(:,48),heltab2x4(:,:,74))
  call Hloop_A_Q(ntryL,G1H2(133),23,nMT,G2H2(5),n2h2(29))
  call Hloop_SA_Q(ntryL,G1H4(21),ex2(:),G1H2(133),ngX,m3h2x2(:,49),heltab2x4(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(133),23,nMT,G2H2(6),n2h2(30))
call HGT_OLR(G1H4(22),1,1,4)
call HGT_invQ_OLR(G1H4(22),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(22),-8,nMT,G2H4(2),n2h4(2))
  call Hloop_QV_A(ntryL,G2H4(2),ex4(:),G2H2(4),m3h2x2(:,50),heltab2x4(:,:,76))
  call Hloop_SA_Q(ntryL,G1H4(25),ex2(:),G1H2(133),ngX,m3h2x2(:,51),heltab2x4(:,:,77))
  call Hloop_A_Q(ntryL,G1H2(133),23,nMT,G2H2(7),n2h2(31))
  call Hloop_SA_Q(ntryL,G1H4(26),ex2(:),G1H2(133),ngX,m3h2x2(:,52),heltab2x4(:,:,78))
  call Hloop_A_Q(ntryL,G1H2(133),23,nMT,G2H2(11),n2h2(32))
  call Hloop_SA_Q(ntryL,G1H4(27),ex2(:),G1H2(133),ngPtb,m3h2x2(:,53),heltab2x4(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(133),23,nMB,G2H2(12),n2h2(33))
call HGT_OLR(G1H4(28),1,1,4)
call HGT_invQ_OLR(G1H4(28),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(28),-8,nMB,G2H4(3),n2h4(3))
  call Hloop_QV_A(ntryL,G2H4(3),ex4(:),G2H2(10),m3h2x2(:,54),heltab2x4(:,:,80))
  call Hloop_SA_Q(ntryL,G1H4(31),ex2(:),G1H2(133),ngPtb,m3h2x2(:,55),heltab2x4(:,:,81))
  call Hloop_A_Q(ntryL,G1H2(133),23,nMB,G2H2(13),n2h2(34))
  call Hloop_SA_Q(ntryL,G1H4(32),ex2(:),G1H2(133),ngPtb,m3h2x2(:,56),heltab2x4(:,:,82))
  call Hloop_A_Q(ntryL,G1H2(133),23,nMB,G2H2(17),n2h2(35))
  call Hloop_VA_Q(ntryL,G1H4(33),ex2(:),G1H2(133),m3h2x2(:,57),heltab2x4(:,:,83))
  call Hloop_A_Q(ntryL,G1H2(133),23,nMT,G2H2(18),n2h2(36))
call HGT_OLR(G1H4(34),1,1,4)
call HGT_invQ_OLR(G1H4(34),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(34),-8,nMT,G2H4(4),n2h4(4))
  call Hloop_QV_A(ntryL,G2H4(4),ex4(:),G2H2(16),m3h2x2(:,58),heltab2x4(:,:,84))
  call Hloop_VA_Q(ntryL,G1H4(37),ex2(:),G1H2(133),m3h2x2(:,59),heltab2x4(:,:,85))
  call Hloop_A_Q(ntryL,G1H2(133),23,nMT,G2H2(19),n2h2(37))
  call Hloop_VA_Q(ntryL,G1H4(38),ex2(:),G1H2(133),m3h2x2(:,60),heltab2x4(:,:,86))
  call Hloop_A_Q(ntryL,G1H2(133),23,nMT,G2H2(23),n2h2(38))
  call Hloop_ZA_Q(ntryL,G1H4(39),ex2(:),G1H2(133),ngZu,m3h2x2(:,61),heltab2x4(:,:,87))
  call Hloop_A_Q(ntryL,G1H2(133),23,nMT,G2H2(24),n2h2(39))
call HGT_OLR(G1H4(40),1,1,4)
call HGT_invQ_OLR(G1H4(40),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(40),-8,nMT,G2H4(5),n2h4(5))
  call Hloop_QV_A(ntryL,G2H4(5),ex4(:),G2H2(22),m3h2x2(:,62),heltab2x4(:,:,88))
  call Hloop_ZA_Q(ntryL,G1H4(43),ex2(:),G1H2(133),ngZu,m3h2x2(:,63),heltab2x4(:,:,89))
  call Hloop_A_Q(ntryL,G1H2(133),23,nMT,G2H2(25),n2h2(40))
  call Hloop_ZA_Q(ntryL,G1H4(44),ex2(:),G1H2(133),ngZu,m3h2x2(:,64),heltab2x4(:,:,90))
  call Hloop_A_Q(ntryL,G1H2(133),23,nMT,G2H2(26),n2h2(41))
  call Hloop_WA_Q(ntryL,G1H4(45),ex2(:),G1H2(133),m3h2x2(:,65),heltab2x4(:,:,91))
  call Hloop_A_Q(ntryL,G1H2(133),23,nMB,G2H2(27),n2h2(42))
call HGT_OLR(G1H4(46),1,1,4)
call HGT_invQ_OLR(G1H4(46),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(46),-8,nMB,G2H4(6),n2h4(6))
  call Hloop_QV_A(ntryL,G2H4(6),ex4(:),G2H2(28),m3h2x2(:,66),heltab2x4(:,:,92))
  call Hloop_WA_Q(ntryL,G1H4(49),ex2(:),G1H2(133),m3h2x2(:,67),heltab2x4(:,:,93))
  call Hloop_A_Q(ntryL,G1H2(133),23,nMB,G2H2(29),n2h2(43))
  call Hloop_WA_Q(ntryL,G1H4(50),ex2(:),G1H2(133),m3h2x2(:,68),heltab2x4(:,:,94))
  call Hloop_A_Q(ntryL,G1H2(133),23,nMB,G2H2(31),n2h2(44))
  call Hloop_QS_A(ntryL,G1H2(1),ex3(:),G1H2(133),ngH,m3h1x2(:,3),heltab2x2(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(133),23,nMT,G2H2(30),n2h2(45))
call HGT_OLR(G1H2(2),1,1,2)
call HGT_invQ_OLR(G1H2(2),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(2),-8,nMT,G2H2(32),n2h2(46))
  call Hloop_AV_Q(ntryL,G2H2(32),ex4(:),G2H1(1),m3h2x1(:,1),heltab2x2(:,:,4))
  call Hloop_QS_A(ntryL,G1H2(6),ex3(:),G1H2(1),ngH,m3h1x2(:,4),heltab2x2(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(32),n2h2(47))
  call Hloop_QS_A(ntryL,G1H2(5),ex3(:),G1H2(133),ngH,m3h1x2(:,5),heltab2x2(:,:,6))
  call Hloop_Q_A(ntryL,G1H2(133),23,nMT,G2H2(33),n2h2(48))
  call Hloop_QS_A(ntryL,G1H2(8),ex3(:),G1H2(2),ngH,m3h1x2(:,6),heltab2x2(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(2),23,nMT,G2H2(34),n2h2(49))
call HGT_OLR(G1H2(7),1,1,2)
call HGT_invQ_OLR(G1H2(7),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(7),-8,nMT,G2H2(35),n2h2(50))
  call Hloop_AV_Q(ntryL,G2H2(35),ex4(:),G2H1(2),m3h2x1(:,2),heltab2x2(:,:,8))
  call Hloop_QS_A(ntryL,G1H2(11),ex3(:),G1H2(6),ngH,m3h1x2(:,7),heltab2x2(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(6),23,nMT,G2H2(35),n2h2(51))
  call Hloop_QS_A(ntryL,G1H2(12),ex3(:),G1H2(1),ngH,m3h1x2(:,8),heltab2x2(:,:,10))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(36),n2h2(52))
  call Hloop_QS_A(ntryL,G1H2(13),ex3(:),G1H2(5),ngH,m3h1x2(:,9),heltab2x2(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(5),23,nMB,G2H2(37),n2h2(53))
call HGT_OLR(G1H2(14),1,1,2)
call HGT_invQ_OLR(G1H2(14),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(14),-8,nMB,G2H2(38),n2h2(54))
  call Hloop_AV_Q(ntryL,G2H2(38),ex4(:),G2H1(3),m3h2x1(:,3),heltab2x2(:,:,12))
  call Hloop_QS_A(ntryL,G1H2(17),ex3(:),G1H2(133),ngH,m3h1x2(:,10),heltab2x2(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(133),23,nMB,G2H2(38),n2h2(55))
  call Hloop_QS_A(ntryL,G1H2(18),ex3(:),G1H2(8),ngH,m3h1x2(:,11),heltab2x2(:,:,14))
  call Hloop_Q_A(ntryL,G1H2(8),23,nMB,G2H2(39),n2h2(56))
  call Hloop_QS_A(ntryL,G1H2(19),ex3(:),G1H2(2),ngH,m3h1x2(:,12),heltab2x2(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(2),23,nMT,G2H2(40),n2h2(57))
call HGT_OLR(G1H2(20),1,1,2)
call HGT_invQ_OLR(G1H2(20),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(20),-8,nMT,G2H2(41),n2h2(58))
  call Hloop_AV_Q(ntryL,G2H2(41),ex4(:),G2H1(4),m3h2x1(:,4),heltab2x2(:,:,16))
  call Hloop_QS_A(ntryL,G1H2(23),ex3(:),G1H2(7),ngH,m3h1x2(:,13),heltab2x2(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(7),23,nMT,G2H2(41),n2h2(59))
  call Hloop_QS_A(ntryL,G1H2(24),ex3(:),G1H2(11),ngH,m3h1x2(:,14),heltab2x2(:,:,18))
  call Hloop_Q_A(ntryL,G1H2(11),23,nMT,G2H2(42),n2h2(60))
  call Hloop_SQ_A(ntryL,G1H4(51),ex1(:),G1H2(6),ngH,m3h2x2(:,69),heltab2x4(:,:,95))
  call Hloop_Q_A(ntryL,G1H2(6),23,nMT,G2H2(43),n2h2(61))
call HGT_OLR(G1H4(52),1,1,4)
call HGT_invQ_OLR(G1H4(52),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(52),-8,nMT,G2H4(7),n2h4(7))
  call Hloop_AV_Q(ntryL,G2H4(7),ex4(:),G2H2(44),m3h2x2(:,70),heltab2x4(:,:,96))
  call Hloop_SQ_A(ntryL,G1H4(55),ex1(:),G1H2(12),ngH,m3h2x2(:,71),heltab2x4(:,:,97))
  call Hloop_Q_A(ntryL,G1H2(12),23,nMT,G2H2(45),n2h2(62))
  call Hloop_SQ_A(ntryL,G1H4(56),ex1(:),G1H2(1),ngH,m3h2x2(:,72),heltab2x4(:,:,98))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMT,G2H2(46),n2h2(63))
  call Hloop_SQ_A(ntryL,G1H4(57),ex1(:),G1H2(13),ngX,m3h2x2(:,73),heltab2x4(:,:,99))
  call Hloop_Q_A(ntryL,G1H2(13),23,nMT,G2H2(47),n2h2(64))
call HGT_OLR(G1H4(58),1,1,4)
call HGT_invQ_OLR(G1H4(58),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(58),-8,nMT,G2H4(8),n2h4(8))
  call Hloop_AV_Q(ntryL,G2H4(8),ex4(:),G2H2(48),m3h2x2(:,74),heltab2x4(:,:,100))
  call Hloop_SQ_A(ntryL,G1H4(61),ex1(:),G1H2(5),ngX,m3h2x2(:,75),heltab2x4(:,:,101))
  call Hloop_Q_A(ntryL,G1H2(5),23,nMT,G2H2(49),n2h2(65))
  call Hloop_SQ_A(ntryL,G1H4(62),ex1(:),G1H2(14),ngX,m3h2x2(:,76),heltab2x4(:,:,102))
  call Hloop_Q_A(ntryL,G1H2(14),23,nMT,G2H2(50),n2h2(66))
  call Hloop_SQ_A(ntryL,G1H4(63),ex1(:),G1H2(17),ngPbt,m3h2x2(:,77),heltab2x4(:,:,103))
  call Hloop_Q_A(ntryL,G1H2(17),23,nMB,G2H2(51),n2h2(67))
call HGT_OLR(G1H4(64),1,1,4)
call HGT_invQ_OLR(G1H4(64),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(64),-8,nMB,G2H4(9),n2h4(9))
  call Hloop_AV_Q(ntryL,G2H4(9),ex4(:),G2H2(52),m3h2x2(:,78),heltab2x4(:,:,104))
  call Hloop_SQ_A(ntryL,G1H4(2),ex1(:),G1H2(133),ngPbt,m3h2x2(:,79),heltab2x4(:,:,105))
  call Hloop_Q_A(ntryL,G1H2(133),23,nMB,G2H2(53),n2h2(68))
  call Hloop_SQ_A(ntryL,G1H4(3),ex1(:),G1H2(18),ngPbt,m3h2x2(:,80),heltab2x4(:,:,106))
  call Hloop_Q_A(ntryL,G1H2(18),23,nMB,G2H2(54),n2h2(69))
  call Hloop_VQ_A(ntryL,G1H4(4),ex1(:),G1H2(8),m3h2x2(:,81),heltab2x4(:,:,107))
  call Hloop_Q_A(ntryL,G1H2(8),23,nMT,G2H2(55),n2h2(70))
call HGT_OLR(G1H4(5),1,1,4)
call HGT_invQ_OLR(G1H4(5),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(5),-8,nMT,G2H4(10),n2h4(10))
  call Hloop_AV_Q(ntryL,G2H4(10),ex4(:),G2H2(56),m3h2x2(:,82),heltab2x4(:,:,108))
  call Hloop_VQ_A(ntryL,G1H4(9),ex1(:),G1H2(19),m3h2x2(:,83),heltab2x4(:,:,109))
  call Hloop_Q_A(ntryL,G1H2(19),23,nMT,G2H2(57),n2h2(71))
  call Hloop_VQ_A(ntryL,G1H4(10),ex1(:),G1H2(2),m3h2x2(:,84),heltab2x4(:,:,110))
  call Hloop_Q_A(ntryL,G1H2(2),23,nMT,G2H2(58),n2h2(72))
  call Hloop_ZQ_A(ntryL,G1H4(11),ex1(:),G1H2(20),ngZu,m3h2x2(:,85),heltab2x4(:,:,111))
  call Hloop_Q_A(ntryL,G1H2(20),23,nMT,G2H2(59),n2h2(73))
call HGT_OLR(G1H4(13),1,1,4)
call HGT_invQ_OLR(G1H4(13),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(13),-8,nMT,G2H4(11),n2h4(11))
  call Hloop_AV_Q(ntryL,G2H4(11),ex4(:),G2H2(60),m3h2x2(:,86),heltab2x4(:,:,112))
  call Hloop_ZQ_A(ntryL,G1H4(67),ex1(:),G1H2(23),ngZu,m3h2x2(:,87),heltab2x4(:,:,113))
  call Hloop_Q_A(ntryL,G1H2(23),23,nMT,G2H2(61),n2h2(74))
  call Hloop_ZQ_A(ntryL,G1H4(68),ex1(:),G1H2(7),ngZu,m3h2x2(:,88),heltab2x4(:,:,114))
  call Hloop_Q_A(ntryL,G1H2(7),23,nMT,G2H2(62),n2h2(75))
  call Hloop_WQ_A(ntryL,G1H4(69),ex1(:),G1H2(24),m3h2x2(:,89),heltab2x4(:,:,115))
  call Hloop_Q_A(ntryL,G1H2(24),23,nMB,G2H2(63),n2h2(76))
call HGT_OLR(G1H4(70),1,1,4)
call HGT_invQ_OLR(G1H4(70),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(70),-8,nMB,G2H4(12),n2h4(12))
  call Hloop_AV_Q(ntryL,G2H4(12),ex4(:),G2H2(64),m3h2x2(:,90),heltab2x4(:,:,116))
  call Hloop_WQ_A(ntryL,G1H4(73),ex1(:),G1H2(11),m3h2x2(:,91),heltab2x4(:,:,117))
  call Hloop_Q_A(ntryL,G1H2(11),23,nMB,G2H2(65),n2h2(77))
  call Hloop_WQ_A(ntryL,G1H4(74),ex1(:),G1H2(6),m3h2x2(:,92),heltab2x4(:,:,118))
  call Hloop_Q_A(ntryL,G1H2(6),23,nMB,G2H2(66),n2h2(78))
  call Hloop_QV_A(ntryL,G1H2(25),ex4(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,19))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMT,G2H1(5),n2h1(1))
call HGT_OLR(G1H2(26),1,1,2)
call HGT_invQ_OLR(G1H2(26),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(26),-4,nMT,G2H2(67),n2h2(79))
  call Hloop_AS_Q(ntryL,G2H2(67),ex3(:),G2H2(68),ngH,m3h1x2(:,15),heltab2x2(:,:,20))
  call Hloop_QV_A(ntryL,G1H2(29),ex4(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,21))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMT,G2H1(6),n2h1(2))
  call Hloop_QV_A(ntryL,G1H2(30),ex4(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,22))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMT,G2H1(7),n2h1(3))
  call Hloop_QV_A(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,23))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMT,G2H1(8),n2h1(4))
call HGT_OLR(G1H2(32),1,1,2)
call HGT_invQ_OLR(G1H2(32),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(32),-4,nMT,G2H2(67),n2h2(80))
  call Hloop_AS_Q(ntryL,G2H2(67),ex3(:),G2H2(69),ngH,m3h1x2(:,16),heltab2x2(:,:,24))
  call Hloop_QV_A(ntryL,G1H2(35),ex4(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,25))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMT,G2H1(9),n2h1(5))
  call Hloop_QV_A(ntryL,G1H2(36),ex4(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,26))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMT,G2H1(10),n2h1(6))
  call Hloop_QV_A(ntryL,G1H2(37),ex4(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,27))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMB,G2H1(11),n2h1(7))
call HGT_OLR(G1H2(38),1,1,2)
call HGT_invQ_OLR(G1H2(38),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(38),-4,nMB,G2H2(67),n2h2(81))
  call Hloop_AS_Q(ntryL,G2H2(67),ex3(:),G2H2(70),ngH,m3h1x2(:,17),heltab2x2(:,:,28))
  call Hloop_QV_A(ntryL,G1H2(41),ex4(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,29))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMB,G2H1(12),n2h1(8))
  call Hloop_QV_A(ntryL,G1H2(42),ex4(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,30))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMB,G2H1(13),n2h1(9))
  call Hloop_QV_A(ntryL,G1H2(43),ex4(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,31))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMT,G2H1(14),n2h1(10))
call HGT_OLR(G1H2(44),1,1,2)
call HGT_invQ_OLR(G1H2(44),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(44),-4,nMT,G2H2(67),n2h2(82))
  call Hloop_AS_Q(ntryL,G2H2(67),ex3(:),G2H2(71),ngH,m3h1x2(:,18),heltab2x2(:,:,32))
  call Hloop_QV_A(ntryL,G1H2(47),ex4(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,33))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMT,G2H1(15),n2h1(11))
  call Hloop_QV_A(ntryL,G1H2(48),ex4(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,34))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMT,G2H1(16),n2h1(12))
  call Hloop_AS_Q(ntryL,G1H2(49),ex3(:),G1H2(12),ngH,m3h1x2(:,19),heltab2x2(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(12),23,nMT,G2H2(67),n2h2(83))
call HGT_OLR(G1H2(50),1,1,2)
call HGT_invQ_OLR(G1H2(50),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(50),-8,nMT,G2H2(72),n2h2(84))
  call Hloop_QV_A(ntryL,G2H2(72),ex4(:),G2H1(17),m3h2x1(:,17),heltab2x2(:,:,36))
  call Hloop_AS_Q(ntryL,G1H2(53),ex3(:),G1H2(1),ngH,m3h1x2(:,20),heltab2x2(:,:,37))
  call Hloop_A_Q(ntryL,G1H2(1),23,nMT,G2H2(72),n2h2(85))
  call Hloop_AS_Q(ntryL,G1H2(54),ex3(:),G1H2(13),ngH,m3h1x2(:,21),heltab2x2(:,:,38))
  call Hloop_A_Q(ntryL,G1H2(13),23,nMT,G2H2(73),n2h2(86))
  call Hloop_AS_Q(ntryL,G1H2(55),ex3(:),G1H2(5),ngH,m3h1x2(:,22),heltab2x2(:,:,39))
  call Hloop_A_Q(ntryL,G1H2(5),23,nMT,G2H2(74),n2h2(87))
call HGT_OLR(G1H2(56),1,1,2)
call HGT_invQ_OLR(G1H2(56),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(56),-8,nMT,G2H2(75),n2h2(88))
  call Hloop_QV_A(ntryL,G2H2(75),ex4(:),G2H1(18),m3h2x1(:,18),heltab2x2(:,:,40))
  call Hloop_AS_Q(ntryL,G1H2(59),ex3(:),G1H2(14),ngH,m3h1x2(:,23),heltab2x2(:,:,41))
  call Hloop_A_Q(ntryL,G1H2(14),23,nMT,G2H2(75),n2h2(89))
  call Hloop_AS_Q(ntryL,G1H2(60),ex3(:),G1H2(17),ngH,m3h1x2(:,24),heltab2x2(:,:,42))
  call Hloop_A_Q(ntryL,G1H2(17),23,nMT,G2H2(76),n2h2(90))
  call Hloop_AS_Q(ntryL,G1H2(61),ex3(:),G1H2(133),ngH,m3h1x2(:,25),heltab2x2(:,:,43))
  call Hloop_A_Q(ntryL,G1H2(133),23,nMB,G2H2(77),n2h2(91))
call HGT_OLR(G1H2(62),1,1,2)
call HGT_invQ_OLR(G1H2(62),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(62),-8,nMB,G2H2(78),n2h2(92))
  call Hloop_QV_A(ntryL,G2H2(78),ex4(:),G2H1(19),m3h2x1(:,19),heltab2x2(:,:,44))
  call Hloop_AS_Q(ntryL,G1H2(65),ex3(:),G1H2(18),ngH,m3h1x2(:,26),heltab2x2(:,:,45))
  call Hloop_A_Q(ntryL,G1H2(18),23,nMB,G2H2(78),n2h2(93))
  call Hloop_AS_Q(ntryL,G1H2(66),ex3(:),G1H2(8),ngH,m3h1x2(:,27),heltab2x2(:,:,46))
  call Hloop_A_Q(ntryL,G1H2(8),23,nMB,G2H2(79),n2h2(94))
  call Hloop_AS_Q(ntryL,G1H2(67),ex3(:),G1H2(19),ngH,m3h1x2(:,28),heltab2x2(:,:,47))
  call Hloop_A_Q(ntryL,G1H2(19),23,nMT,G2H2(80),n2h2(95))
call HGT_OLR(G1H2(68),1,1,2)
call HGT_invQ_OLR(G1H2(68),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(68),-8,nMT,G2H2(81),n2h2(96))
  call Hloop_QV_A(ntryL,G2H2(81),ex4(:),G2H1(20),m3h2x1(:,20),heltab2x2(:,:,48))
  call Hloop_AS_Q(ntryL,G1H2(71),ex3(:),G1H2(2),ngH,m3h1x2(:,29),heltab2x2(:,:,49))
  call Hloop_A_Q(ntryL,G1H2(2),23,nMT,G2H2(81),n2h2(97))
  call Hloop_AS_Q(ntryL,G1H2(72),ex3(:),G1H2(20),ngH,m3h1x2(:,30),heltab2x2(:,:,50))
  call Hloop_A_Q(ntryL,G1H2(20),23,nMT,G2H2(82),n2h2(98))
  call Hloop_AV_Q(ntryL,G1H2(73),ex4(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,51))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMT,G2H1(21),n2h1(13))
call HGT_OLR(G1H2(74),1,1,2)
call HGT_invQ_OLR(G1H2(74),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(74),-4,nMT,G2H2(83),n2h2(99))
  call Hloop_QS_A(ntryL,G2H2(83),ex3(:),G2H2(84),ngH,m3h1x2(:,31),heltab2x2(:,:,52))
  call Hloop_AV_Q(ntryL,G1H2(77),ex4(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,53))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMT,G2H1(22),n2h1(14))
  call Hloop_AV_Q(ntryL,G1H2(78),ex4(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,54))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMT,G2H1(23),n2h1(15))
  call Hloop_AV_Q(ntryL,G1H2(79),ex4(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,55))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMT,G2H1(24),n2h1(16))
call HGT_OLR(G1H2(80),1,1,2)
call HGT_invQ_OLR(G1H2(80),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(80),-4,nMT,G2H2(83),n2h2(100))
  call Hloop_QS_A(ntryL,G2H2(83),ex3(:),G2H2(85),ngH,m3h1x2(:,32),heltab2x2(:,:,56))
  call Hloop_AV_Q(ntryL,G1H2(83),ex4(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,57))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMT,G2H1(25),n2h1(17))
  call Hloop_AV_Q(ntryL,G1H2(84),ex4(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,58))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMT,G2H1(26),n2h1(18))
  call Hloop_AV_Q(ntryL,G1H2(85),ex4(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,59))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMB,G2H1(27),n2h1(19))
call HGT_OLR(G1H2(86),1,1,2)
call HGT_invQ_OLR(G1H2(86),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(86),-4,nMB,G2H2(83),n2h2(101))
  call Hloop_QS_A(ntryL,G2H2(83),ex3(:),G2H2(86),ngH,m3h1x2(:,33),heltab2x2(:,:,60))
  call Hloop_AV_Q(ntryL,G1H2(89),ex4(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,61))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMB,G2H1(28),n2h1(20))
  call Hloop_AV_Q(ntryL,G1H2(90),ex4(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,62))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMB,G2H1(29),n2h1(21))
  call Hloop_AV_Q(ntryL,G1H2(91),ex4(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,63))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMT,G2H1(30),n2h1(22))
call HGT_OLR(G1H2(92),1,1,2)
call HGT_invQ_OLR(G1H2(92),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(92),-4,nMT,G2H2(83),n2h2(102))
  call Hloop_QS_A(ntryL,G2H2(83),ex3(:),G2H2(87),ngH,m3h1x2(:,34),heltab2x2(:,:,64))
  call Hloop_AV_Q(ntryL,G1H2(95),ex4(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,65))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMT,G2H1(31),n2h1(23))
  call Hloop_AV_Q(ntryL,G1H2(96),ex4(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,66))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMT,G2H1(32),n2h1(24))
  call Hloop_SQ_A(ntryL,G1H4(1),ex1(:),G1H2(23),ngX,m3h2x2(:,93),heltab2x4(:,:,119))
  call Hloop_Q_A(ntryL,G1H2(23),23,nMT,G2H2(83),n2h2(103))
call HGT_OLR(G1H4(75),1,1,4)
call HGT_invQ_OLR(G1H4(75),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(75),-8,nMT,G2H4(13),n2h4(13))
  call Hloop_AV_Q(ntryL,G2H4(13),ex4(:),G2H2(88),m3h2x2(:,94),heltab2x4(:,:,120))
  call Hloop_SQ_A(ntryL,G1H4(78),ex1(:),G1H2(7),ngX,m3h2x2(:,95),heltab2x4(:,:,121))
  call Hloop_Q_A(ntryL,G1H2(7),23,nMT,G2H2(89),n2h2(104))
  call Hloop_SQ_A(ntryL,G1H4(79),ex1(:),G1H2(24),ngX,m3h2x2(:,96),heltab2x4(:,:,122))
  call Hloop_Q_A(ntryL,G1H2(24),23,nMT,G2H2(90),n2h2(105))
  call Hloop_SQ_A(ntryL,G1H4(80),ex1(:),G1H2(11),ngPbt,m3h2x2(:,97),heltab2x4(:,:,123))
  call Hloop_Q_A(ntryL,G1H2(11),23,nMB,G2H2(91),n2h2(106))
call HGT_OLR(G1H4(81),1,1,4)
call HGT_invQ_OLR(G1H4(81),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(81),-8,nMB,G2H4(14),n2h4(14))
  call Hloop_AV_Q(ntryL,G2H4(14),ex4(:),G2H2(92),m3h2x2(:,98),heltab2x4(:,:,124))
  call Hloop_SQ_A(ntryL,G1H4(84),ex1(:),G1H2(6),ngPbt,m3h2x2(:,99),heltab2x4(:,:,125))
  call Hloop_Q_A(ntryL,G1H2(6),23,nMB,G2H2(93),n2h2(107))
  call Hloop_SQ_A(ntryL,G1H4(85),ex1(:),G1H2(25),ngPbt,m3h2x2(:,100),heltab2x4(:,:,126))
  call Hloop_Q_A(ntryL,G1H2(25),23,nMB,G2H2(94),n2h2(108))
  call Hloop_ZQ_A(ntryL,G1H4(86),ex1(:),G1H2(26),ngZu,m3h2x2(:,101),heltab2x4(:,:,127))
  call Hloop_Q_A(ntryL,G1H2(26),23,nMT,G2H2(95),n2h2(109))
call HGT_OLR(G1H4(87),1,1,4)
call HGT_invQ_OLR(G1H4(87),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(87),-8,nMT,G2H4(15),n2h4(15))
  call Hloop_AV_Q(ntryL,G2H4(15),ex4(:),G2H2(96),m3h2x2(:,102),heltab2x4(:,:,128))
  call Hloop_ZQ_A(ntryL,G1H4(90),ex1(:),G1H2(29),ngZu,m3h2x2(:,103),heltab2x4(:,:,129))
  call Hloop_Q_A(ntryL,G1H2(29),23,nMT,G2H2(97),n2h2(110))
  call Hloop_ZQ_A(ntryL,G1H4(91),ex1(:),G1H2(30),ngZu,m3h2x2(:,104),heltab2x4(:,:,130))
  call Hloop_Q_A(ntryL,G1H2(30),23,nMT,G2H2(98),n2h2(111))
  call Hloop_WQ_A(ntryL,G1H4(92),ex1(:),G1H2(31),m3h2x2(:,105),heltab2x4(:,:,131))
  call Hloop_Q_A(ntryL,G1H2(31),23,nMB,G2H2(99),n2h2(112))
call HGT_OLR(G1H4(93),1,1,4)
call HGT_invQ_OLR(G1H4(93),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(93),-8,nMB,G2H4(16),n2h4(16))
  call Hloop_AV_Q(ntryL,G2H4(16),ex4(:),G2H2(100),m3h2x2(:,106),heltab2x4(:,:,132))
  call Hloop_WQ_A(ntryL,G1H4(96),ex1(:),G1H2(32),m3h2x2(:,107),heltab2x4(:,:,133))
  call Hloop_Q_A(ntryL,G1H2(32),23,nMB,G2H2(101),n2h2(113))
  call Hloop_WQ_A(ntryL,G1H4(97),ex1(:),G1H2(35),m3h2x2(:,108),heltab2x4(:,:,134))
  call Hloop_Q_A(ntryL,G1H2(35),23,nMB,G2H2(102),n2h2(114))
  call Hloop_SQ_A(ntryL,G1H2(97),ex1(:),G1H1(1),ngPbt,m3h2x1(:,33),heltab2x2(:,:,67))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMB,G2H1(33),n2h1(25))
call HGT_OLR(G1H2(98),1,1,2)
call HGT_invQ_OLR(G1H2(98),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(98),-4,nMB,G2H2(103),n2h2(115))
  call Hloop_AS_Q(ntryL,G2H2(103),ex3(:),G2H2(104),ngH,m3h1x2(:,35),heltab2x2(:,:,68))
  call Hloop_SQ_A(ntryL,G1H2(101),ex1(:),G1H1(1),ngPbt,m3h2x1(:,34),heltab2x2(:,:,69))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMB,G2H1(34),n2h1(26))
  call Hloop_SQ_A(ntryL,G1H2(102),ex1(:),G1H1(1),ngPbt,m3h2x1(:,35),heltab2x2(:,:,70))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMB,G2H1(35),n2h1(27))
  call Hloop_WQ_A(ntryL,G1H2(103),ex1(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,71))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMB,G2H1(36),n2h1(28))
call HGT_OLR(G1H2(104),1,1,2)
call HGT_invQ_OLR(G1H2(104),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(104),-4,nMB,G2H2(103),n2h2(116))
  call Hloop_AS_Q(ntryL,G2H2(103),ex3(:),G2H2(105),ngH,m3h1x2(:,36),heltab2x2(:,:,72))
  call Hloop_WQ_A(ntryL,G1H2(107),ex1(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,73))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMB,G2H1(37),n2h1(29))
  call Hloop_WQ_A(ntryL,G1H2(108),ex1(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,74))
  call Hloop_Q_A(ntryL,G1H1(1),27,nMB,G2H1(38),n2h1(30))
  call Hloop_SA_Q(ntryL,G1H4(6),ex2(:),G1H2(36),ngX,m3h2x2(:,109),heltab2x4(:,:,135))
  call Hloop_A_Q(ntryL,G1H2(36),23,nMT,G2H2(103),n2h2(117))
call HGT_OLR(G1H4(98),1,1,4)
call HGT_invQ_OLR(G1H4(98),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(98),-8,nMT,G2H4(19),n2h4(17))
  call Hloop_QV_A(ntryL,G2H4(19),ex4(:),G2H2(106),m3h2x2(:,110),heltab2x4(:,:,136))
  call Hloop_SA_Q(ntryL,G1H4(101),ex2(:),G1H2(37),ngX,m3h2x2(:,111),heltab2x4(:,:,137))
  call Hloop_A_Q(ntryL,G1H2(37),23,nMT,G2H2(107),n2h2(118))
  call Hloop_SA_Q(ntryL,G1H4(102),ex2(:),G1H2(38),ngX,m3h2x2(:,112),heltab2x4(:,:,138))
  call Hloop_A_Q(ntryL,G1H2(38),23,nMT,G2H2(108),n2h2(119))
  call Hloop_SA_Q(ntryL,G1H4(103),ex2(:),G1H2(41),ngPtb,m3h2x2(:,113),heltab2x4(:,:,139))
  call Hloop_A_Q(ntryL,G1H2(41),23,nMB,G2H2(109),n2h2(120))
call HGT_OLR(G1H4(104),1,1,4)
call HGT_invQ_OLR(G1H4(104),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(104),-8,nMB,G2H4(20),n2h4(18))
  call Hloop_QV_A(ntryL,G2H4(20),ex4(:),G2H2(110),m3h2x2(:,114),heltab2x4(:,:,140))
  call Hloop_SA_Q(ntryL,G1H4(107),ex2(:),G1H2(42),ngPtb,m3h2x2(:,115),heltab2x4(:,:,141))
  call Hloop_A_Q(ntryL,G1H2(42),23,nMB,G2H2(111),n2h2(121))
  call Hloop_SA_Q(ntryL,G1H4(108),ex2(:),G1H2(43),ngPtb,m3h2x2(:,116),heltab2x4(:,:,142))
  call Hloop_A_Q(ntryL,G1H2(43),23,nMB,G2H2(112),n2h2(122))
  call Hloop_ZA_Q(ntryL,G1H4(109),ex2(:),G1H2(44),ngZu,m3h2x2(:,117),heltab2x4(:,:,143))
  call Hloop_A_Q(ntryL,G1H2(44),23,nMT,G2H2(113),n2h2(123))
call HGT_OLR(G1H4(110),1,1,4)
call HGT_invQ_OLR(G1H4(110),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(110),-8,nMT,G2H4(17),n2h4(19))
  call Hloop_QV_A(ntryL,G2H4(17),ex4(:),G2H2(114),m3h2x2(:,118),heltab2x4(:,:,144))
  call Hloop_ZA_Q(ntryL,G1H4(113),ex2(:),G1H2(47),ngZu,m3h2x2(:,119),heltab2x4(:,:,145))
  call Hloop_A_Q(ntryL,G1H2(47),23,nMT,G2H2(115),n2h2(124))
  call Hloop_ZA_Q(ntryL,G1H4(114),ex2(:),G1H2(48),ngZu,m3h2x2(:,120),heltab2x4(:,:,146))
  call Hloop_A_Q(ntryL,G1H2(48),23,nMT,G2H2(116),n2h2(125))
  call Hloop_WA_Q(ntryL,G1H4(115),ex2(:),G1H2(49),m3h2x2(:,121),heltab2x4(:,:,147))
  call Hloop_A_Q(ntryL,G1H2(49),23,nMB,G2H2(117),n2h2(126))
call HGT_OLR(G1H4(116),1,1,4)
call HGT_invQ_OLR(G1H4(116),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(116),-8,nMB,G2H4(18),n2h4(20))
  call Hloop_QV_A(ntryL,G2H4(18),ex4(:),G2H2(118),m3h2x2(:,122),heltab2x4(:,:,148))
  call Hloop_WA_Q(ntryL,G1H4(119),ex2(:),G1H2(12),m3h2x2(:,123),heltab2x4(:,:,149))
  call Hloop_A_Q(ntryL,G1H2(12),23,nMB,G2H2(119),n2h2(127))
  call Hloop_WA_Q(ntryL,G1H4(120),ex2(:),G1H2(50),m3h2x2(:,124),heltab2x4(:,:,150))
  call Hloop_A_Q(ntryL,G1H2(50),23,nMB,G2H2(120),n2h2(128))
  call Hloop_SV_T(ntryL,G1H4(121),21,ex4(:),8,G2H2(121),m3h2x2(:,125),heltab2x4(:,:,151))
call HGT_OLR(G1H4(122),1,1,4)
call HGT_invQ_OLR(G1H4(122),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(122),-2,nMB,G2H4(22),n2h4(21))
  call Hloop_QA_S(ntryL,G2H4(22),ex2(:),G2H2(122),ngPtb,m3h2x2(:,126),heltab2x4(:,:,152))
  call Hloop_SV_T(ntryL,G1H4(125),21,ex4(:),8,G2H2(123),m3h2x2(:,127),heltab2x4(:,:,153))
  call Hloop_SV_T(ntryL,G1H4(126),21,ex4(:),8,G2H2(124),m3h2x2(:,128),heltab2x4(:,:,154))
  call Hloop_UW_V(ntryL,G1H4(127),21,ex4(:),8,G2H2(125),m3h2x2(:,129),heltab2x4(:,:,155))
call HGT_OLR(G1H4(128),1,1,4)
call HGT_invQ_OLR(G1H4(128),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(128),-2,nMB,G2H4(21),n2h4(22))
  call Hloop_QA_W(ntryL,G2H4(21),ex2(:),G2H2(126),m3h2x2(:,130),heltab2x4(:,:,156))
  call Hloop_UW_V(ntryL,G1H4(131),21,ex4(:),8,G2H2(127),m3h2x2(:,131),heltab2x4(:,:,157))
  call Hloop_UW_V(ntryL,G1H4(132),21,ex4(:),8,G2H2(128),m3h2x2(:,132),heltab2x4(:,:,158))
  call Hloop_SA_Q(ntryL,G1H2(109),ex2(:),G1H1(1),ngPtb,m3h2x1(:,39),heltab2x2(:,:,75))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMB,G2H1(39),n2h1(31))
call HGT_OLR(G1H2(110),1,1,2)
call HGT_invQ_OLR(G1H2(110),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(110),-4,nMB,G2H2(129),n2h2(129))
  call Hloop_QS_A(ntryL,G2H2(129),ex3(:),G2H2(130),ngH,m3h1x2(:,37),heltab2x2(:,:,76))
  call Hloop_SA_Q(ntryL,G1H2(113),ex2(:),G1H1(1),ngPtb,m3h2x1(:,40),heltab2x2(:,:,77))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMB,G2H1(40),n2h1(32))
  call Hloop_SA_Q(ntryL,G1H2(114),ex2(:),G1H1(1),ngPtb,m3h2x1(:,41),heltab2x2(:,:,78))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMB,G2H1(41),n2h1(33))
  call Hloop_WA_Q(ntryL,G1H2(115),ex2(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,79))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMB,G2H1(42),n2h1(34))
call HGT_OLR(G1H2(116),1,1,2)
call HGT_invQ_OLR(G1H2(116),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(116),-4,nMB,G2H2(129),n2h2(130))
  call Hloop_QS_A(ntryL,G2H2(129),ex3(:),G2H2(131),ngH,m3h1x2(:,38),heltab2x2(:,:,80))
  call Hloop_WA_Q(ntryL,G1H2(119),ex2(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,81))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMB,G2H1(43),n2h1(35))
  call Hloop_WA_Q(ntryL,G1H2(120),ex2(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,82))
  call Hloop_A_Q(ntryL,G1H1(1),27,nMB,G2H1(44),n2h1(36))
  call Hloop_VT_S(ntryL,G1H2(121),25,ex3(:),4,G2H2(129),m3h1x2(:,39),heltab2x2(:,:,83))
call HGT_OLR(G1H2(122),1,1,2)
call HGT_invQ_OLR(G1H2(122),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(122),-2,nMB,G2H2(132),n2h2(131))
  call Hloop_QA_S(ntryL,G2H2(132),ex2(:),G2H1(45),ngPtb,m3h2x1(:,45),heltab2x2(:,:,84))
  call Hloop_VT_S(ntryL,G1H2(125),25,ex3(:),4,G2H2(132),m3h1x2(:,40),heltab2x2(:,:,85))
  call Hloop_VT_S(ntryL,G1H2(126),25,ex3(:),4,G2H2(133),m3h1x2(:,41),heltab2x2(:,:,86))
  call Hloop_ST_V(ntryL,G1H2(127),25,ex3(:),4,G2H2(134),m3h1x2(:,42),heltab2x2(:,:,87))
call HGT_OLR(G1H2(128),1,1,2)
call HGT_invQ_OLR(G1H2(128),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(128),-2,nMB,G2H2(135),n2h2(132))
  call Hloop_QA_W(ntryL,G2H2(135),ex2(:),G2H1(46),m3h2x1(:,46),heltab2x2(:,:,88))
  call Hloop_ST_V(ntryL,G1H2(131),25,ex3(:),4,G2H2(135),m3h1x2(:,43),heltab2x2(:,:,89))
  call Hloop_ST_V(ntryL,G1H2(132),25,ex3(:),4,G2H2(136),m3h1x2(:,44),heltab2x2(:,:,90))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(121),[G2H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(125),[G2H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(129),[G2H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(134),[G2H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G2H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G2H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(27),[G2H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(31),[G2H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(59),[G2H2(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(62),[G2H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(63),[G2H2(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(66),[G2H2(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(95),[G2H2(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(98),[G2H2(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(99),[G2H2(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(102),[G2H2(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(36),[G2H1(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(38),[G2H1(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(113),[G2H2(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(116),[G2H2(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(117),[G2H2(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(120),[G2H2(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(42),[G2H1(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(44),[G2H1(41)])
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(7),mass5set(:,12),  & 
G1H2(53),G1H2(1),G1H2(54),G1H2(13),G1H2(55),G1H2(5),2)
  call HG1shiftOLR(G1H2(1),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(9),mass5set(:,12),  & 
G1H2(56),G1H2(59),G1H2(14),G1H2(60),G1H2(17),G1H2(61),2)
  call HG1shiftOLR(G1H2(59),8,2)
  call Hotf_5pt_reduction(G2H2(121),RedSet_5(10),mass5set(:,11),  & 
G1H2(133),G1H2(62),G1H2(65),G1H2(18),G1H2(66),G1H2(8),2)
  call HG1shiftOLR(G1H2(62),2,2)
  call Hotf_5pt_reduction(G2H2(125),RedSet_5(10),mass5set(:,11),  & 
G1H2(67),G1H2(19),G1H2(68),G1H2(71),G1H2(2),G1H2(72),2)
  call HG1shiftOLR(G1H2(19),2,2)
  call Hotf_5pt_reduction(G2H2(129),RedSet_5(12),mass5set(:,11),  & 
G1H2(20),G1H2(73),G1H2(74),G1H2(77),G1H2(78),G1H2(79),2)
  call HG1shiftOLR(G1H2(73),2,2)
  call Hotf_5pt_reduction(G2H2(134),RedSet_5(12),mass5set(:,11),  & 
G1H2(80),G1H2(83),G1H2(84),G1H2(85),G1H2(86),G1H2(89),2)
  call HG1shiftOLR(G1H2(83),2,2)
  call Hotf_5pt_reduction(G2H2(20),RedSet_5(1),mass5set(:,1),  & 
G1H2(90),G1H2(91),G1H2(92),G1H2(95),G1H2(96),G1H2(23),2)
  call HG1shiftOLR(G1H2(91),8,2)
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(1),mass4set(:,1),  & 
G1H2(7),G1H2(24),G1H2(11),G1H2(6),G1H2(25),2)
  call HG1shiftOLR(G1H2(24),10,2)
  call Hotf_5pt_reduction(G2H2(24),RedSet_5(1),mass5set(:,2),  & 
G1H2(26),G1H2(29),G1H2(30),G1H2(31),G1H2(32),G1H2(35),2)
  call HG1shiftOLR(G1H2(29),8,2)
  call Hotf_4pt_reduction(G2H2(26),RedSet_4(1),mass4set(:,2),  & 
G1H2(97),G1H2(98),G1H2(101),G1H2(102),G1H2(103),2)
  call HG1shiftOLR(G1H2(98),10,2)
  call Hotf_5pt_reduction(G2H2(27),RedSet_5(1),mass5set(:,3),  & 
G1H2(104),G1H2(107),G1H2(108),G1H2(36),G1H2(37),G1H2(38),2)
  call HG1shiftOLR(G1H2(107),8,2)
  call Hotf_4pt_reduction(G2H2(31),RedSet_4(1),mass4set(:,3),  & 
G1H2(41),G1H2(42),G1H2(43),G1H2(44),G1H2(47),2)
  call HG1shiftOLR(G1H2(42),10,2)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(1),mass5set(:,4),  & 
G1H2(48),G1H2(49),G1H2(12),G1H2(50),G1H2(109),G1H2(110),2)
  call HG1shiftOLR(G1H2(49),8,2)
  call Hotf_4pt_reduction(G2H2(23),RedSet_4(1),mass4set(:,4),  & 
G1H2(113),G1H2(114),G1H2(115),G1H2(116),G1H2(119),2)
  call HG1shiftOLR(G1H2(114),10,2)
  call Hotf_5pt_reduction(G2H2(30),RedSet_5(2),mass5set(:,5),  & 
G1H2(120),G1H2(121),G1H2(122),G1H2(125),G1H2(126),G1H2(127),2)
  call HG1shiftOLR(G1H2(121),8,2)
  call Hotf_4pt_reduction(G2H2(33),RedSet_4(2),mass4set(:,5),  & 
G1H2(128),G1H2(131),G1H2(132),G1H2(134),G1H2(135),2)
  call HG1shiftOLR(G1H2(131),12,2)
  call Hotf_5pt_reduction(G2H2(34),RedSet_5(2),mass5set(:,6),  & 
G1H2(136),G1H2(137),G1H2(138),G1H2(139),G1H2(140),G1H2(141),2)
  call HG1shiftOLR(G1H2(137),8,2)
  call Hotf_4pt_reduction(G2H2(36),RedSet_4(2),mass4set(:,6),  & 
G1H2(142),G1H2(143),G1H2(144),G1H2(145),G1H2(146),2)
  call HG1shiftOLR(G1H2(143),12,2)
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(2),mass5set(:,7),  & 
G1H2(147),G1H2(148),G1H2(149),G1H2(150),G1H2(151),G1H2(152),2)
  call HG1shiftOLR(G1H2(148),8,2)
  call Hotf_4pt_reduction(G2H2(39),RedSet_4(2),mass4set(:,7),  & 
G1H2(153),G1H2(154),G1H2(155),G1H2(156),G1H2(157),2)
  call HG1shiftOLR(G1H2(154),12,2)
  call Hotf_5pt_reduction(G2H2(40),RedSet_5(2),mass5set(:,8),  & 
G1H2(158),G1H2(159),G1H2(160),G1H2(161),G1H2(162),G1H2(163),2)
  call HG1shiftOLR(G1H2(159),8,2)
  call Hotf_4pt_reduction(G2H2(42),RedSet_4(2),mass4set(:,8),  & 
G1H2(164),G1H2(165),G1H2(166),G1H2(167),G1H2(168),2)
  call HG1shiftOLR(G1H2(165),12,2)
  call Hotf_5pt_reduction(G2H2(43),RedSet_5(3),mass5set(:,1),  & 
G1H2(169),G1H2(170),G1H2(171),G1H2(172),G1H2(173),G1H2(174),2)
  call HG1shiftOLR(G1H2(170),8,2)
  call Hotf_4pt_reduction(G2H2(46),RedSet_4(3),mass4set(:,1),  & 
G1H2(175),G1H2(176),G1H2(177),G1H2(178),G1H2(179),2)
  call HG1shiftOLR(G1H2(176),9,2)
  call Hotf_5pt_reduction(G2H2(59),RedSet_5(3),mass5set(:,2),  & 
G1H2(180),G1H2(181),G1H2(182),G1H2(183),G1H2(184),G1H2(185),2)
  call HG1shiftOLR(G1H2(181),8,2)
  call Hotf_4pt_reduction(G2H2(62),RedSet_4(3),mass4set(:,2),  & 
G1H2(186),G1H2(187),G1H2(188),G1H2(189),G1H2(190),2)
  call HG1shiftOLR(G1H2(187),9,2)
  call Hotf_5pt_reduction(G2H2(63),RedSet_5(3),mass5set(:,3),  & 
G1H2(191),G1H2(192),G1H2(193),G1H2(194),G1H2(195),G1H2(196),2)
  call HG1shiftOLR(G1H2(192),8,2)
  call Hotf_4pt_reduction(G2H2(66),RedSet_4(3),mass4set(:,3),  & 
G1H2(197),G1H2(198),G1H2(199),G1H2(200),G1H2(201),2)
  call HG1shiftOLR(G1H2(198),9,2)
  call Hotf_5pt_reduction(G2H2(55),RedSet_5(3),mass5set(:,4),  & 
G1H2(202),G1H2(203),G1H2(204),G1H2(205),G1H2(206),G1H2(207),2)
  call HG1shiftOLR(G1H2(203),8,2)
  call Hotf_4pt_reduction(G2H2(58),RedSet_4(3),mass4set(:,4),  & 
G1H2(208),G1H2(209),G1H2(210),G1H2(211),G1H2(212),2)
  call HG1shiftOLR(G1H2(209),9,2)
  call Hotf_5pt_reduction(G2H1(5),RedSet_5(4),mass5set(:,5),  & 
G1H1(1),G1H1(2),G1H1(3),G1H1(4),G1H1(5),G1H1(6),1)
  call HG1shiftOLR(G1H1(2),4,1)
  call Hotf_4pt_reduction(G2H1(7),RedSet_4(2),mass4set(:,5),  & 
G1H1(7),G1H1(8),G1H1(9),G1H1(10),G1H1(11),1)
  call HG1shiftOLR(G1H1(8),12,1)
  call Hotf_5pt_reduction(G2H1(8),RedSet_5(4),mass5set(:,6),  & 
G1H1(12),G1H1(13),G1H1(14),G1H1(15),G1H1(16),G1H1(17),1)
  call HG1shiftOLR(G1H1(13),4,1)
  call Hotf_4pt_reduction(G2H1(10),RedSet_4(2),mass4set(:,6),  & 
G1H1(18),G1H1(19),G1H1(20),G1H1(21),G1H1(22),1)
  call HG1shiftOLR(G1H1(19),12,1)
  call Hotf_5pt_reduction(G2H1(11),RedSet_5(4),mass5set(:,7),  & 
G1H1(23),G1H1(24),G1H1(25),G1H1(26),G1H1(27),G1H1(28),1)
  call HG1shiftOLR(G1H1(24),4,1)
  call Hotf_4pt_reduction(G2H1(13),RedSet_4(2),mass4set(:,7),  & 
G1H1(29),G1H1(30),G1H1(31),G1H1(32),G1H1(33),1)
  call HG1shiftOLR(G1H1(30),12,1)
  call Hotf_5pt_reduction(G2H1(14),RedSet_5(4),mass5set(:,8),  & 
G1H1(34),G1H1(35),G1H1(36),G1H1(37),G1H1(38),G1H1(39),1)
  call HG1shiftOLR(G1H1(35),4,1)
  call Hotf_4pt_reduction(G2H1(16),RedSet_4(2),mass4set(:,8),  & 
G1H1(40),G1H1(41),G1H1(42),G1H1(43),G1H1(44),1)
  call HG1shiftOLR(G1H1(41),12,1)
  call Hotf_5pt_reduction(G2H2(67),RedSet_5(5),mass5set(:,5),  & 
G1H2(213),G1H2(214),G1H2(215),G1H2(216),G1H2(217),G1H2(218),2)
  call HG1shiftOLR(G1H2(214),8,2)
  call Hotf_4pt_reduction(G2H2(73),RedSet_4(4),mass4set(:,5),  & 
G1H2(219),G1H2(220),G1H2(221),G1H2(222),G1H2(223),2)
  call HG1shiftOLR(G1H2(220),12,2)
  call Hotf_5pt_reduction(G2H2(74),RedSet_5(5),mass5set(:,6),  & 
G1H2(224),G1H2(225),G1H2(226),G1H2(227),G1H2(228),G1H2(229),2)
  call HG1shiftOLR(G1H2(225),8,2)
  call Hotf_4pt_reduction(G2H2(76),RedSet_4(4),mass4set(:,6),  & 
G1H2(230),G1H2(231),G1H2(232),G1H2(233),G1H2(234),2)
  call HG1shiftOLR(G1H2(231),12,2)
  call Hotf_5pt_reduction(G2H2(77),RedSet_5(5),mass5set(:,7),  & 
G1H2(235),G1H2(236),G1H2(237),G1H2(238),G1H2(239),G1H2(240),2)
  call HG1shiftOLR(G1H2(236),8,2)
  call Hotf_4pt_reduction(G2H2(79),RedSet_4(4),mass4set(:,7),  & 
G1H2(241),G1H2(242),G1H2(243),G1H2(244),G1H2(245),2)
  call HG1shiftOLR(G1H2(242),12,2)
  call Hotf_5pt_reduction(G2H2(80),RedSet_5(5),mass5set(:,8),  & 
G1H2(246),G1H2(247),G1H2(248),G1H2(249),G1H2(250),G1H2(251),2)
  call HG1shiftOLR(G1H2(247),8,2)
  call Hotf_4pt_reduction(G2H2(82),RedSet_4(4),mass4set(:,8),  & 
G1H2(252),G1H2(253),G1H2(254),G1H2(255),G1H2(256),2)
  call HG1shiftOLR(G1H2(253),12,2)
  call Hotf_5pt_reduction(G2H1(21),RedSet_5(6),mass5set(:,5),  & 
G1H1(45),G1H1(46),G1H1(47),G1H1(48),G1H1(49),G1H1(50),1)
  call HG1shiftOLR(G1H1(46),4,1)
  call Hotf_4pt_reduction(G2H1(23),RedSet_4(4),mass4set(:,5),  & 
G1H1(51),G1H1(52),G1H1(53),G1H1(54),G1H1(55),1)
  call HG1shiftOLR(G1H1(52),12,1)
  call Hotf_5pt_reduction(G2H1(24),RedSet_5(6),mass5set(:,6),  & 
G1H1(56),G1H1(57),G1H1(58),G1H1(59),G1H1(60),G1H1(61),1)
  call HG1shiftOLR(G1H1(57),4,1)
  call Hotf_4pt_reduction(G2H1(26),RedSet_4(4),mass4set(:,6),  & 
G1H1(62),G1H1(63),G1H1(64),G1H1(65),G1H1(66),1)
  call HG1shiftOLR(G1H1(63),12,1)
  call Hotf_5pt_reduction(G2H1(27),RedSet_5(6),mass5set(:,7),  & 
G1H1(67),G1H1(68),G1H1(69),G1H1(70),G1H1(71),G1H1(72),1)
  call HG1shiftOLR(G1H1(68),4,1)
  call Hotf_4pt_reduction(G2H1(29),RedSet_4(4),mass4set(:,7),  & 
G1H1(73),G1H1(74),G1H1(75),G1H1(76),G1H1(77),1)
  call HG1shiftOLR(G1H1(74),12,1)
  call Hotf_5pt_reduction(G2H1(30),RedSet_5(6),mass5set(:,8),  & 
G1H1(78),G1H1(79),G1H1(80),G1H1(81),G1H1(82),G1H1(83),1)
  call HG1shiftOLR(G1H1(79),4,1)
  call Hotf_4pt_reduction(G2H1(32),RedSet_4(4),mass4set(:,8),  & 
G1H1(84),G1H1(85),G1H1(86),G1H1(87),G1H1(88),1)
  call HG1shiftOLR(G1H1(85),12,1)
  call Hotf_5pt_reduction(G2H2(95),RedSet_5(7),mass5set(:,9),  & 
G1H2(257),G1H2(258),G1H2(259),G1H2(260),G1H2(261),G1H2(262),2)
  call HG1shiftOLR(G1H2(258),8,2)
  call Hotf_4pt_reduction(G2H2(98),RedSet_4(5),mass4set(:,9),  & 
G1H2(263),G1H2(264),G1H2(265),G1H2(266),G1H2(267),2)
  call HG1shiftOLR(G1H2(264),9,2)
  call Hotf_5pt_reduction(G2H2(99),RedSet_5(7),mass5set(:,10),  & 
G1H2(268),G1H2(269),G1H2(270),G1H2(271),G1H2(272),G1H2(273),2)
  call HG1shiftOLR(G1H2(269),8,2)
  call Hotf_4pt_reduction(G2H2(102),RedSet_4(5),mass4set(:,10),  & 
G1H2(274),G1H2(275),G1H2(276),G1H2(277),G1H2(278),2)
  call HG1shiftOLR(G1H2(275),9,2)
  call Hotf_5pt_reduction(G2H1(36),RedSet_5(8),mass5set(:,10),  & 
G1H1(89),G1H1(90),G1H1(91),G1H1(92),G1H1(93),G1H1(94),1)
  call HG1shiftOLR(G1H1(90),4,1)
  call Hotf_4pt_reduction(G2H1(38),RedSet_4(6),mass4set(:,10),  & 
G1H1(95),G1H1(96),G1H1(97),G1H1(98),G1H1(99),1)
  call HG1shiftOLR(G1H1(96),5,1)
  call Hotf_5pt_reduction(G2H2(113),RedSet_5(9),mass5set(:,9),  & 
G1H2(279),G1H2(280),G1H2(281),G1H2(282),G1H2(283),G1H2(284),2)
  call HG1shiftOLR(G1H2(280),8,2)
  call Hotf_4pt_reduction(G2H2(116),RedSet_4(7),mass4set(:,9),  & 
G1H2(285),G1H2(286),G1H2(287),G1H2(288),G1H2(289),2)
  call HG1shiftOLR(G1H2(286),10,2)
  call Hotf_5pt_reduction(G2H2(117),RedSet_5(9),mass5set(:,10),  & 
G1H2(290),G1H2(291),G1H2(292),G1H2(293),G1H2(294),G1H2(295),2)
  call HG1shiftOLR(G1H2(291),8,2)
  call Hotf_4pt_reduction(G2H2(120),RedSet_4(7),mass4set(:,10),  & 
G1H2(296),G1H2(297),G1H2(298),G1H2(299),G1H2(300),2)
  call HG1shiftOLR(G1H2(297),10,2)
  call Hotf_4pt_reduction(G2H2(124),RedSet_4(7),mass4set(:,10),  & 
G1H2(301),G1H2(302),G1H2(303),G1H2(304),G1H2(305),2)
  call HG1shiftOLR(G1H2(302),10,2)
  call Hotf_4pt_reduction(G2H2(128),RedSet_4(7),mass4set(:,10),  & 
G1H2(306),G1H2(307),G1H2(308),G1H2(309),G1H2(310),2)
  call HG1shiftOLR(G1H2(307),10,2)
  call Hotf_5pt_reduction(G2H1(42),RedSet_5(11),mass5set(:,10),  & 
G1H1(100),G1H1(101),G1H1(102),G1H1(103),G1H1(104),G1H1(105),1)
  call HG1shiftOLR(G1H1(101),4,1)
  call Hotf_4pt_reduction(G2H1(44),RedSet_4(8),mass4set(:,10),  & 
G1H1(106),G1H1(107),G1H1(108),G1H1(109),G1H1(110),1)
  call HG1shiftOLR(G1H1(107),6,1)
  call Hotf_4pt_reduction(G2H2(133),RedSet_4(8),mass4set(:,10),  & 
G1H2(311),G1H2(312),G1H2(313),G1H2(314),G1H2(315),2)
  call HG1shiftOLR(G1H2(312),6,2)
  call Hotf_4pt_reduction(G2H2(136),RedSet_4(8),mass4set(:,10),  & 
G1H2(316),G1H2(317),G1H2(318),G1H2(319),G1H2(320),2)
  call HG1shiftOLR(G1H2(317),6,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(301),[G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(306),[G1H2(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(311),[G1H2(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(316),[G1H2(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(7),[G1H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(97),[G1H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(41),[G1H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(113),[G1H2(110)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(128),[G1H2(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(142),[G1H2(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(153),[G1H2(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(164),[G1H2(163)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(175),[G1H2(174)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(186),[G1H2(185)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(197),[G1H2(196)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(208),[G1H2(207)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(7),[G1H1(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(18),[G1H1(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(29),[G1H1(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(40),[G1H1(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(219),[G1H2(218)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(230),[G1H2(229)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(241),[G1H2(240)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(252),[G1H2(251)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(51),[G1H1(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(62),[G1H1(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(73),[G1H1(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(84),[G1H1(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(263),[G1H2(262)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(274),[G1H2(273)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(95),[G1H1(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(285),[G1H2(284)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(296),[G1H2(295)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(106),[G1H1(105)])
  call Hloop_QV_A(ntryL,G1H2(53),ex4(:),G1H1(6),m3h2x1(:,47),heltab2x2(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),31,nMT,G2tensor(1),n2h1(37))
  call Hloop_QV_A(ntryL,G1H2(1),ex4(:),G1H1(17),m3h2x1(:,48),heltab2x2(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),8,nMT,G2tensor(2),n2h1(38))
  call Hloop_QV_A(ntryL,G1H2(5),ex4(:),G1H1(28),m3h2x1(:,49),heltab2x2(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(28),31,nMT,G2tensor(3),n2h1(39))
  call Hloop_AV_Q(ntryL,G1H2(56),ex4(:),G1H1(39),m3h2x1(:,50),heltab2x2(:,:,94))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(39),31,nMT,G2tensor(4),n2h1(40))
  call Hloop_AV_Q(ntryL,G1H2(59),ex4(:),G1H1(50),m3h2x1(:,51),heltab2x2(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(50),8,nMT,G2tensor(5),n2h1(41))
  call Hloop_AV_Q(ntryL,G1H2(61),ex4(:),G1H1(61),m3h2x1(:,52),heltab2x2(:,:,96))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(61),31,nMT,G2tensor(6),n2h1(42))
  call Hloop_SA_Q(ntryL,G1H2(133),ex2(:),G1H1(72),ngPtb,m3h2x1(:,53),heltab2x2(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(72),31,nMB,G2tensor(7),n2h1(43))
  call Hloop_SA_Q(ntryL,G1H2(62),ex2(:),G1H1(83),ngPtb,m3h2x1(:,54),heltab2x2(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(83),2,nMB,G2tensor(8),n2h1(44))
  call Hloop_SA_Q(ntryL,G1H2(301),ex2(:),G1H1(94),ngPtb,m3h2x1(:,55),heltab2x2(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(94),31,nMB,G2tensor(9),n2h1(45))
  call Hloop_WA_Q(ntryL,G1H2(67),ex2(:),G1H1(105),m3h2x1(:,56),heltab2x2(:,:,100))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(105),31,nMB,G2tensor(10),n2h1(46))
  call Hloop_WA_Q(ntryL,G1H2(19),ex2(:),G1H1(6),m3h2x1(:,57),heltab2x2(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(6),2,nMB,G2tensor(11),n2h1(47))
  call Hloop_WA_Q(ntryL,G1H2(306),ex2(:),G1H1(17),m3h2x1(:,58),heltab2x2(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),31,nMB,G2tensor(12),n2h1(48))
  call Hloop_SA_Q(ntryL,G1H2(20),ex2(:),G1H1(28),ngPtb,m3h2x1(:,59),heltab2x2(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(28),31,nMB,G2tensor(13),n2h1(49))
  call Hloop_SA_Q(ntryL,G1H2(73),ex2(:),G1H1(39),ngPtb,m3h2x1(:,60),heltab2x2(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(39),2,nMB,G2tensor(14),n2h1(50))
  call Hloop_SA_Q(ntryL,G1H2(311),ex2(:),G1H1(50),ngPtb,m3h2x1(:,61),heltab2x2(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(50),31,nMB,G2tensor(15),n2h1(51))
  call Hloop_WA_Q(ntryL,G1H2(80),ex2(:),G1H1(61),m3h2x1(:,62),heltab2x2(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(61),31,nMB,G2tensor(16),n2h1(52))
  call Hloop_WA_Q(ntryL,G1H2(83),ex2(:),G1H1(72),m3h2x1(:,63),heltab2x2(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(72),2,nMB,G2tensor(17),n2h1(53))
  call Hloop_WA_Q(ntryL,G1H2(316),ex2(:),G1H1(83),m3h2x1(:,64),heltab2x2(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(83),31,nMB,G2tensor(18),n2h1(54))
  call Hloop_AV_Q(ntryL,G1H2(90),ex4(:),G1H1(94),m3h2x1(:,65),heltab2x2(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(94),31,nMT,G2tensor(19),n2h1(55))
  call Hloop_AV_Q(ntryL,G1H2(91),ex4(:),G1H1(105),m3h2x1(:,66),heltab2x2(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(105),8,nMT,G2tensor(20),n2h1(56))
  call Hloop_AV_Q(ntryL,G1H2(7),ex4(:),G1H1(6),m3h2x1(:,67),heltab2x2(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(6),31,nMT,G2tensor(21),n2h1(57))
  call Hloop_AV_Q(ntryL,G1H2(24),ex4(:),G1H1(17),m3h2x1(:,68),heltab2x2(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),10,nMT,G2tensor(22),n2h1(58))
  call Hloop_AV_Q(ntryL,G1H2(26),ex4(:),G1H1(28),m3h2x1(:,69),heltab2x2(:,:,113))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(28),31,nMT,G2tensor(23),n2h1(59))
  call Hloop_AV_Q(ntryL,G1H2(29),ex4(:),G1H1(39),m3h2x1(:,70),heltab2x2(:,:,114))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(39),8,nMT,G2tensor(24),n2h1(60))
  call Hloop_AV_Q(ntryL,G1H2(97),ex4(:),G1H1(50),m3h2x1(:,71),heltab2x2(:,:,115))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(50),31,nMT,G2tensor(25),n2h1(61))
  call Hloop_AV_Q(ntryL,G1H2(98),ex4(:),G1H1(61),m3h2x1(:,72),heltab2x2(:,:,116))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(61),10,nMT,G2tensor(26),n2h1(62))
  call Hloop_AV_Q(ntryL,G1H2(104),ex4(:),G1H1(72),m3h2x1(:,73),heltab2x2(:,:,117))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(72),31,nMB,G2tensor(27),n2h1(63))
  call Hloop_AV_Q(ntryL,G1H2(107),ex4(:),G1H1(83),m3h2x1(:,74),heltab2x2(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(83),8,nMB,G2tensor(28),n2h1(64))
  call Hloop_AV_Q(ntryL,G1H2(41),ex4(:),G1H1(94),m3h2x1(:,75),heltab2x2(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(94),31,nMB,G2tensor(29),n2h1(65))
  call Hloop_AV_Q(ntryL,G1H2(42),ex4(:),G1H1(105),m3h2x1(:,76),heltab2x2(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(105),10,nMB,G2tensor(30),n2h1(66))
  call Hloop_AV_Q(ntryL,G1H2(48),ex4(:),G1H1(6),m3h2x1(:,77),heltab2x2(:,:,121))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(6),31,nMT,G2tensor(31),n2h1(67))
  call Hloop_AV_Q(ntryL,G1H2(49),ex4(:),G1H1(17),m3h2x1(:,78),heltab2x2(:,:,122))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),8,nMT,G2tensor(32),n2h1(68))
  call Hloop_AV_Q(ntryL,G1H2(113),ex4(:),G1H1(28),m3h2x1(:,79),heltab2x2(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(28),31,nMT,G2tensor(33),n2h1(69))
  call Hloop_AV_Q(ntryL,G1H2(114),ex4(:),G1H1(39),m3h2x1(:,80),heltab2x2(:,:,124))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(39),10,nMT,G2tensor(34),n2h1(70))
  call Hloop_QV_A(ntryL,G1H2(120),ex4(:),G1H1(50),m3h2x1(:,81),heltab2x2(:,:,125))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(50),31,nMT,G2tensor(35),n2h1(71))
  call Hloop_QV_A(ntryL,G1H2(121),ex4(:),G1H1(61),m3h2x1(:,82),heltab2x2(:,:,126))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(61),8,nMT,G2tensor(36),n2h1(72))
  call Hloop_QV_A(ntryL,G1H2(128),ex4(:),G1H1(72),m3h2x1(:,83),heltab2x2(:,:,127))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(72),31,nMT,G2tensor(37),n2h1(73))
  call Hloop_QV_A(ntryL,G1H2(131),ex4(:),G1H1(83),m3h2x1(:,84),heltab2x2(:,:,128))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(83),12,nMT,G2tensor(38),n2h1(74))
  call Hloop_QV_A(ntryL,G1H2(136),ex4(:),G1H1(94),m3h2x1(:,85),heltab2x2(:,:,129))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(94),31,nMT,G2tensor(39),n2h1(75))
  call Hloop_QV_A(ntryL,G1H2(137),ex4(:),G1H1(105),m3h2x1(:,86),heltab2x2(:,:,130))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(105),8,nMT,G2tensor(40),n2h1(76))
  call Hloop_QV_A(ntryL,G1H2(142),ex4(:),G1H1(6),m3h2x1(:,87),heltab2x2(:,:,131))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),31,nMT,G2tensor(41),n2h1(77))
  call Hloop_QV_A(ntryL,G1H2(143),ex4(:),G1H1(17),m3h2x1(:,88),heltab2x2(:,:,132))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),12,nMT,G2tensor(42),n2h1(78))
  call Hloop_QV_A(ntryL,G1H2(147),ex4(:),G1H1(28),m3h2x1(:,89),heltab2x2(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(28),31,nMB,G2tensor(43),n2h1(79))
  call Hloop_QV_A(ntryL,G1H2(148),ex4(:),G1H1(39),m3h2x1(:,90),heltab2x2(:,:,134))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(39),8,nMB,G2tensor(44),n2h1(80))
  call Hloop_QV_A(ntryL,G1H2(153),ex4(:),G1H1(50),m3h2x1(:,91),heltab2x2(:,:,135))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(50),31,nMB,G2tensor(45),n2h1(81))
  call Hloop_QV_A(ntryL,G1H2(154),ex4(:),G1H1(61),m3h2x1(:,92),heltab2x2(:,:,136))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(61),12,nMB,G2tensor(46),n2h1(82))
  call Hloop_QV_A(ntryL,G1H2(158),ex4(:),G1H1(72),m3h2x1(:,93),heltab2x2(:,:,137))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(72),31,nMT,G2tensor(47),n2h1(83))
  call Hloop_QV_A(ntryL,G1H2(159),ex4(:),G1H1(83),m3h2x1(:,94),heltab2x2(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(83),8,nMT,G2tensor(48),n2h1(84))
  call Hloop_QV_A(ntryL,G1H2(164),ex4(:),G1H1(94),m3h2x1(:,95),heltab2x2(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(94),31,nMT,G2tensor(49),n2h1(85))
  call Hloop_QV_A(ntryL,G1H2(165),ex4(:),G1H1(105),m3h2x1(:,96),heltab2x2(:,:,140))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(105),12,nMT,G2tensor(50),n2h1(86))
  call Hloop_QV_A(ntryL,G1H2(169),ex4(:),G1H1(6),m3h2x1(:,97),heltab2x2(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),31,nMT,G2tensor(51),n2h1(87))
  call Hloop_QV_A(ntryL,G1H2(170),ex4(:),G1H1(17),m3h2x1(:,98),heltab2x2(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),8,nMT,G2tensor(52),n2h1(88))
  call Hloop_QV_A(ntryL,G1H2(175),ex4(:),G1H1(28),m3h2x1(:,99),heltab2x2(:,:,143))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(28),31,nMT,G2tensor(53),n2h1(89))
  call Hloop_QV_A(ntryL,G1H2(176),ex4(:),G1H1(39),m3h2x1(:,100),heltab2x2(:,:,144))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(39),9,nMT,G2tensor(54),n2h1(90))
  call Hloop_QV_A(ntryL,G1H2(180),ex4(:),G1H1(50),m3h2x1(:,101),heltab2x2(:,:,145))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(50),31,nMT,G2tensor(55),n2h1(91))
  call Hloop_QV_A(ntryL,G1H2(181),ex4(:),G1H1(61),m3h2x1(:,102),heltab2x2(:,:,146))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(61),8,nMT,G2tensor(56),n2h1(92))
  call Hloop_QV_A(ntryL,G1H2(186),ex4(:),G1H1(72),m3h2x1(:,103),heltab2x2(:,:,147))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(72),31,nMT,G2tensor(57),n2h1(93))
  call Hloop_QV_A(ntryL,G1H2(187),ex4(:),G1H1(83),m3h2x1(:,104),heltab2x2(:,:,148))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(83),9,nMT,G2tensor(58),n2h1(94))
  call Hloop_QV_A(ntryL,G1H2(191),ex4(:),G1H1(94),m3h2x1(:,105),heltab2x2(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(94),31,nMB,G2tensor(59),n2h1(95))
  call Hloop_QV_A(ntryL,G1H2(192),ex4(:),G1H1(105),m3h2x1(:,106),heltab2x2(:,:,150))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(105),8,nMB,G2tensor(60),n2h1(96))
  call Hloop_QV_A(ntryL,G1H2(197),ex4(:),G1H1(6),m3h2x1(:,107),heltab2x2(:,:,151))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),31,nMB,G2tensor(61),n2h1(97))
  call Hloop_QV_A(ntryL,G1H2(198),ex4(:),G1H1(17),m3h2x1(:,108),heltab2x2(:,:,152))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),9,nMB,G2tensor(62),n2h1(98))
  call Hloop_QV_A(ntryL,G1H2(202),ex4(:),G1H1(28),m3h2x1(:,109),heltab2x2(:,:,153))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(28),31,nMT,G2tensor(63),n2h1(99))
  call Hloop_QV_A(ntryL,G1H2(203),ex4(:),G1H1(39),m3h2x1(:,110),heltab2x2(:,:,154))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(39),8,nMT,G2tensor(64),n2h1(100))
  call Hloop_QV_A(ntryL,G1H2(208),ex4(:),G1H1(50),m3h2x1(:,111),heltab2x2(:,:,155))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(50),31,nMT,G2tensor(65),n2h1(101))
  call Hloop_QV_A(ntryL,G1H2(209),ex4(:),G1H1(61),m3h2x1(:,112),heltab2x2(:,:,156))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(61),9,nMT,G2tensor(66),n2h1(102))
  call Hloop_QS_A(ntryL,G1H1(1),ex3(:),G1H1(72),ngH,m3h1x1(:,1),heltab2x1(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(72),31,nMT,G2tensor(67),n2h1(103))
  call Hloop_QS_A(ntryL,G1H1(2),ex3(:),G1H1(83),ngH,m3h1x1(:,2),heltab2x1(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(83),4,nMT,G2tensor(68),n2h1(104))
  call Hloop_QS_A(ntryL,G1H1(7),ex3(:),G1H1(94),ngH,m3h1x1(:,3),heltab2x1(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(94),31,nMT,G2tensor(69),n2h1(105))
  call Hloop_QS_A(ntryL,G1H1(8),ex3(:),G1H1(105),ngH,m3h1x1(:,4),heltab2x1(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(105),12,nMT,G2tensor(70),n2h1(106))
  call Hloop_QS_A(ntryL,G1H1(12),ex3(:),G1H1(6),ngH,m3h1x1(:,5),heltab2x1(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),31,nMT,G2tensor(71),n2h1(107))
  call Hloop_QS_A(ntryL,G1H1(13),ex3(:),G1H1(17),ngH,m3h1x1(:,6),heltab2x1(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),4,nMT,G2tensor(72),n2h1(108))
  call Hloop_QS_A(ntryL,G1H1(18),ex3(:),G1H1(28),ngH,m3h1x1(:,7),heltab2x1(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(28),31,nMT,G2tensor(73),n2h1(109))
  call Hloop_QS_A(ntryL,G1H1(19),ex3(:),G1H1(39),ngH,m3h1x1(:,8),heltab2x1(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(39),12,nMT,G2tensor(74),n2h1(110))
  call Hloop_QS_A(ntryL,G1H1(23),ex3(:),G1H1(50),ngH,m3h1x1(:,9),heltab2x1(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(50),31,nMB,G2tensor(75),n2h1(111))
  call Hloop_QS_A(ntryL,G1H1(24),ex3(:),G1H1(61),ngH,m3h1x1(:,10),heltab2x1(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(61),4,nMB,G2tensor(76),n2h1(112))
  call Hloop_QS_A(ntryL,G1H1(29),ex3(:),G1H1(1),ngH,m3h1x1(:,11),heltab2x1(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(77),n2h1(113))
  call Hloop_QS_A(ntryL,G1H1(30),ex3(:),G1H1(72),ngH,m3h1x1(:,12),heltab2x1(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(72),12,nMB,G2tensor(78),n2h1(114))
  call Hloop_QS_A(ntryL,G1H1(34),ex3(:),G1H1(2),ngH,m3h1x1(:,13),heltab2x1(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(2),31,nMT,G2tensor(79),n2h1(115))
  call Hloop_QS_A(ntryL,G1H1(35),ex3(:),G1H1(83),ngH,m3h1x1(:,14),heltab2x1(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(83),4,nMT,G2tensor(80),n2h1(116))
  call Hloop_QS_A(ntryL,G1H1(40),ex3(:),G1H1(7),ngH,m3h1x1(:,15),heltab2x1(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(7),31,nMT,G2tensor(81),n2h1(117))
  call Hloop_QS_A(ntryL,G1H1(41),ex3(:),G1H1(94),ngH,m3h1x1(:,16),heltab2x1(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(94),12,nMT,G2tensor(82),n2h1(118))
  call Hloop_AV_Q(ntryL,G1H2(213),ex4(:),G1H1(8),m3h2x1(:,113),heltab2x2(:,:,157))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(8),31,nMT,G2tensor(83),n2h1(119))
  call Hloop_AV_Q(ntryL,G1H2(214),ex4(:),G1H1(105),m3h2x1(:,114),heltab2x2(:,:,158))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(105),8,nMT,G2tensor(84),n2h1(120))
  call Hloop_AV_Q(ntryL,G1H2(219),ex4(:),G1H1(12),m3h2x1(:,115),heltab2x2(:,:,159))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(12),31,nMT,G2tensor(85),n2h1(121))
  call Hloop_AV_Q(ntryL,G1H2(220),ex4(:),G1H1(6),m3h2x1(:,116),heltab2x2(:,:,160))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(6),12,nMT,G2tensor(86),n2h1(122))
  call Hloop_AV_Q(ntryL,G1H2(224),ex4(:),G1H1(13),m3h2x1(:,117),heltab2x2(:,:,161))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(13),31,nMT,G2tensor(87),n2h1(123))
  call Hloop_AV_Q(ntryL,G1H2(225),ex4(:),G1H1(17),m3h2x1(:,118),heltab2x2(:,:,162))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),8,nMT,G2tensor(88),n2h1(124))
  call Hloop_AV_Q(ntryL,G1H2(230),ex4(:),G1H1(18),m3h2x1(:,119),heltab2x2(:,:,163))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(18),31,nMT,G2tensor(89),n2h1(125))
  call Hloop_AV_Q(ntryL,G1H2(231),ex4(:),G1H1(28),m3h2x1(:,120),heltab2x2(:,:,164))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(28),12,nMT,G2tensor(90),n2h1(126))
  call Hloop_AV_Q(ntryL,G1H2(235),ex4(:),G1H1(19),m3h2x1(:,121),heltab2x2(:,:,165))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),31,nMB,G2tensor(91),n2h1(127))
  call Hloop_AV_Q(ntryL,G1H2(236),ex4(:),G1H1(39),m3h2x1(:,122),heltab2x2(:,:,166))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(39),8,nMB,G2tensor(92),n2h1(128))
  call Hloop_AV_Q(ntryL,G1H2(241),ex4(:),G1H1(23),m3h2x1(:,123),heltab2x2(:,:,167))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(23),31,nMB,G2tensor(93),n2h1(129))
  call Hloop_AV_Q(ntryL,G1H2(242),ex4(:),G1H1(50),m3h2x1(:,124),heltab2x2(:,:,168))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(50),12,nMB,G2tensor(94),n2h1(130))
  call Hloop_AV_Q(ntryL,G1H2(246),ex4(:),G1H1(24),m3h2x1(:,125),heltab2x2(:,:,169))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(24),31,nMT,G2tensor(95),n2h1(131))
  call Hloop_AV_Q(ntryL,G1H2(247),ex4(:),G1H1(61),m3h2x1(:,126),heltab2x2(:,:,170))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(61),8,nMT,G2tensor(96),n2h1(132))
  call Hloop_AV_Q(ntryL,G1H2(252),ex4(:),G1H1(29),m3h2x1(:,127),heltab2x2(:,:,171))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(29),31,nMT,G2tensor(97),n2h1(133))
  call Hloop_AV_Q(ntryL,G1H2(253),ex4(:),G1H1(1),m3h2x1(:,128),heltab2x2(:,:,172))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),12,nMT,G2tensor(98),n2h1(134))
  call Hloop_AS_Q(ntryL,G1H1(45),ex3(:),G1H1(30),ngH,m3h1x1(:,17),heltab2x1(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(30),31,nMT,G2tensor(99),n2h1(135))
  call Hloop_AS_Q(ntryL,G1H1(46),ex3(:),G1H1(72),ngH,m3h1x1(:,18),heltab2x1(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(72),4,nMT,G2tensor(100),n2h1(136))
  call Hloop_AS_Q(ntryL,G1H1(51),ex3(:),G1H1(34),ngH,m3h1x1(:,19),heltab2x1(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(34),31,nMT,G2tensor(101),n2h1(137))
  call Hloop_AS_Q(ntryL,G1H1(52),ex3(:),G1H1(2),ngH,m3h1x1(:,20),heltab2x1(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),12,nMT,G2tensor(102),n2h1(138))
  call Hloop_AS_Q(ntryL,G1H1(56),ex3(:),G1H1(35),ngH,m3h1x1(:,21),heltab2x1(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(35),31,nMT,G2tensor(103),n2h1(139))
  call Hloop_AS_Q(ntryL,G1H1(57),ex3(:),G1H1(83),ngH,m3h1x1(:,22),heltab2x1(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(83),4,nMT,G2tensor(104),n2h1(140))
  call Hloop_AS_Q(ntryL,G1H1(62),ex3(:),G1H1(40),ngH,m3h1x1(:,23),heltab2x1(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(40),31,nMT,G2tensor(105),n2h1(141))
  call Hloop_AS_Q(ntryL,G1H1(63),ex3(:),G1H1(7),ngH,m3h1x1(:,24),heltab2x1(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(7),12,nMT,G2tensor(106),n2h1(142))
  call Hloop_AS_Q(ntryL,G1H1(67),ex3(:),G1H1(41),ngH,m3h1x1(:,25),heltab2x1(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(41),31,nMB,G2tensor(107),n2h1(143))
  call Hloop_AS_Q(ntryL,G1H1(68),ex3(:),G1H1(94),ngH,m3h1x1(:,26),heltab2x1(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(94),4,nMB,G2tensor(108),n2h1(144))
  call Hloop_AS_Q(ntryL,G1H1(73),ex3(:),G1H1(8),ngH,m3h1x1(:,27),heltab2x1(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(8),31,nMB,G2tensor(109),n2h1(145))
  call Hloop_AS_Q(ntryL,G1H1(74),ex3(:),G1H1(105),ngH,m3h1x1(:,28),heltab2x1(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(105),12,nMB,G2tensor(110),n2h1(146))
  call Hloop_AS_Q(ntryL,G1H1(78),ex3(:),G1H1(12),ngH,m3h1x1(:,29),heltab2x1(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(12),31,nMT,G2tensor(111),n2h1(147))
  call Hloop_AS_Q(ntryL,G1H1(79),ex3(:),G1H1(6),ngH,m3h1x1(:,30),heltab2x1(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(6),4,nMT,G2tensor(112),n2h1(148))
  call Hloop_AS_Q(ntryL,G1H1(84),ex3(:),G1H1(13),ngH,m3h1x1(:,31),heltab2x1(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(13),31,nMT,G2tensor(113),n2h1(149))
  call Hloop_AS_Q(ntryL,G1H1(85),ex3(:),G1H1(17),ngH,m3h1x1(:,32),heltab2x1(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),12,nMT,G2tensor(114),n2h1(150))
  call Hloop_QV_A(ntryL,G1H2(257),ex4(:),G1H1(18),m3h2x1(:,129),heltab2x2(:,:,173))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(18),31,nMT,G2tensor(115),n2h1(151))
  call Hloop_QV_A(ntryL,G1H2(258),ex4(:),G1H1(28),m3h2x1(:,130),heltab2x2(:,:,174))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(28),8,nMT,G2tensor(116),n2h1(152))
  call Hloop_QV_A(ntryL,G1H2(263),ex4(:),G1H1(19),m3h2x1(:,131),heltab2x2(:,:,175))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),31,nMT,G2tensor(117),n2h1(153))
  call Hloop_QV_A(ntryL,G1H2(264),ex4(:),G1H1(39),m3h2x1(:,132),heltab2x2(:,:,176))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(39),9,nMT,G2tensor(118),n2h1(154))
  call Hloop_QV_A(ntryL,G1H2(268),ex4(:),G1H1(23),m3h2x1(:,133),heltab2x2(:,:,177))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(23),31,nMB,G2tensor(119),n2h1(155))
  call Hloop_QV_A(ntryL,G1H2(269),ex4(:),G1H1(50),m3h2x1(:,134),heltab2x2(:,:,178))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(50),8,nMB,G2tensor(120),n2h1(156))
  call Hloop_QV_A(ntryL,G1H2(274),ex4(:),G1H1(24),m3h2x1(:,135),heltab2x2(:,:,179))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(24),31,nMB,G2tensor(121),n2h1(157))
  call Hloop_QV_A(ntryL,G1H2(275),ex4(:),G1H1(61),m3h2x1(:,136),heltab2x2(:,:,180))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(61),9,nMB,G2tensor(122),n2h1(158))
  call Hloop_QS_A(ntryL,G1H1(89),ex3(:),G1H1(29),ngH,m3h1x1(:,33),heltab2x1(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(29),31,nMB,G2tensor(123),n2h1(159))
  call Hloop_QS_A(ntryL,G1H1(90),ex3(:),G1H1(1),ngH,m3h1x1(:,34),heltab2x1(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(124),n2h1(160))
  call Hloop_QS_A(ntryL,G1H1(95),ex3(:),G1H1(45),ngH,m3h1x1(:,35),heltab2x1(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(45),31,nMB,G2tensor(125),n2h1(161))
  call Hloop_QS_A(ntryL,G1H1(96),ex3(:),G1H1(30),ngH,m3h1x1(:,36),heltab2x1(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(30),5,nMB,G2tensor(126),n2h1(162))
  call Hloop_AV_Q(ntryL,G1H2(279),ex4(:),G1H1(46),m3h2x1(:,137),heltab2x2(:,:,181))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(46),31,nMT,G2tensor(127),n2h1(163))
  call Hloop_AV_Q(ntryL,G1H2(280),ex4(:),G1H1(72),m3h2x1(:,138),heltab2x2(:,:,182))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(72),8,nMT,G2tensor(128),n2h1(164))
  call Hloop_AV_Q(ntryL,G1H2(285),ex4(:),G1H1(51),m3h2x1(:,139),heltab2x2(:,:,183))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(51),31,nMT,G2tensor(129),n2h1(165))
  call Hloop_AV_Q(ntryL,G1H2(286),ex4(:),G1H1(34),m3h2x1(:,140),heltab2x2(:,:,184))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(34),10,nMT,G2tensor(130),n2h1(166))
  call Hloop_AV_Q(ntryL,G1H2(290),ex4(:),G1H1(52),m3h2x1(:,141),heltab2x2(:,:,185))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(52),31,nMB,G2tensor(131),n2h1(167))
  call Hloop_AV_Q(ntryL,G1H2(291),ex4(:),G1H1(2),m3h2x1(:,142),heltab2x2(:,:,186))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),8,nMB,G2tensor(132),n2h1(168))
  call Hloop_AV_Q(ntryL,G1H2(296),ex4(:),G1H1(56),m3h2x1(:,143),heltab2x2(:,:,187))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(56),31,nMB,G2tensor(133),n2h1(169))
  call Hloop_AV_Q(ntryL,G1H2(297),ex4(:),G1H1(35),m3h2x1(:,144),heltab2x2(:,:,188))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(35),10,nMB,G2tensor(134),n2h1(170))
  call Hloop_SA_Q(ntryL,G1H2(302),ex2(:),G1H1(57),ngPtb,m3h2x1(:,145),heltab2x2(:,:,189))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(57),10,nMB,G2tensor(135),n2h1(171))
  call Hloop_WA_Q(ntryL,G1H2(307),ex2(:),G1H1(83),m3h2x1(:,146),heltab2x2(:,:,190))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(83),10,nMB,G2tensor(136),n2h1(172))
  call Hloop_AS_Q(ntryL,G1H1(100),ex3(:),G1H1(62),ngH,m3h1x1(:,37),heltab2x1(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(62),31,nMB,G2tensor(137),n2h1(173))
  call Hloop_AS_Q(ntryL,G1H1(101),ex3(:),G1H1(40),ngH,m3h1x1(:,38),heltab2x1(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(40),4,nMB,G2tensor(138),n2h1(174))
  call Hloop_AS_Q(ntryL,G1H1(106),ex3(:),G1H1(63),ngH,m3h1x1(:,39),heltab2x1(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(63),31,nMB,G2tensor(139),n2h1(175))
  call Hloop_AS_Q(ntryL,G1H1(107),ex3(:),G1H1(7),ngH,m3h1x1(:,40),heltab2x1(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(7),6,nMB,G2tensor(140),n2h1(176))
  call Hloop_SA_Q(ntryL,G1H2(312),ex2(:),G1H1(67),ngPtb,m3h2x1(:,147),heltab2x2(:,:,191))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(67),6,nMB,G2tensor(141),n2h1(177))
  call Hloop_WA_Q(ntryL,G1H2(317),ex2(:),G1H1(41),m3h2x1(:,148),heltab2x2(:,:,192))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(41),6,nMB,G2tensor(142),n2h1(178))
  call ol_merge_tensors(G2tensor(10),[G2tensor(7)])
  call ol_merge_tensors(G2tensor(16),[G2tensor(13)])
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(7),mass5set(:,12),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(9),mass5set(:,12),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(10),RedSet_5(10),mass5set(:,11),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),2)
  call Hotf_5pt_reduction_last(G2tensor(16),RedSet_5(12),mass5set(:,11),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),2)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(1),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(1),mass5set(:,2),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(1),mass5set(:,3),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(1),mass5set(:,4),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),8)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(2),mass5set(:,5),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(2),mass5set(:,6),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),8)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(2),mass5set(:,7),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(2),mass5set(:,8),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),8)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(3),mass5set(:,1),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),8)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(3),mass5set(:,2),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),8)
  call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(3),mass5set(:,3),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),8)
  call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(3),mass5set(:,4),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),8)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(4),mass5set(:,5),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),4)
  call Hotf_5pt_reduction_last(G2tensor(71),RedSet_5(4),mass5set(:,6),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),4)
  call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(4),mass5set(:,7),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),4)
  call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(4),mass5set(:,8),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),4)
  call Hotf_5pt_reduction_last(G2tensor(83),RedSet_5(5),mass5set(:,5),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),8)
  call Hotf_5pt_reduction_last(G2tensor(87),RedSet_5(5),mass5set(:,6),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),8)
  call Hotf_5pt_reduction_last(G2tensor(91),RedSet_5(5),mass5set(:,7),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),8)
  call Hotf_5pt_reduction_last(G2tensor(95),RedSet_5(5),mass5set(:,8),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),8)
  call Hotf_5pt_reduction_last(G2tensor(99),RedSet_5(6),mass5set(:,5),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),4)
  call Hotf_5pt_reduction_last(G2tensor(103),RedSet_5(6),mass5set(:,6),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),4)
  call Hotf_5pt_reduction_last(G2tensor(107),RedSet_5(6),mass5set(:,7),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),4)
  call Hotf_5pt_reduction_last(G2tensor(111),RedSet_5(6),mass5set(:,8),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),4)
  call Hotf_5pt_reduction_last(G2tensor(115),RedSet_5(7),mass5set(:,9),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),8)
  call Hotf_5pt_reduction_last(G2tensor(119),RedSet_5(7),mass5set(:,10),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),8)
  call Hotf_5pt_reduction_last(G2tensor(123),RedSet_5(8),mass5set(:,10),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),4)
  call Hotf_5pt_reduction_last(G2tensor(127),RedSet_5(9),mass5set(:,9),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),8)
  call Hotf_5pt_reduction_last(G2tensor(131),RedSet_5(9),mass5set(:,10),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),8)
  call Hotf_5pt_reduction_last(G2tensor(137),RedSet_5(11),mass5set(:,10),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  call ol_merge_tensors(T1sum(13),[G1tensor(73)])
  call ol_merge_tensors(T1sum(14),[G1tensor(79)])
  call ol_merge_tensors(T1sum(15),[G1tensor(85)])
  call ol_merge_tensors(T1sum(16),[G1tensor(91)])
  call ol_merge_tensors(T1sum(17),[G1tensor(97)])
  call ol_merge_tensors(T1sum(18),[G1tensor(103)])
  call ol_merge_tensors(T1sum(19),[G1tensor(109)])
  call ol_merge_tensors(T1sum(20),[G1tensor(115)])
  call ol_merge_tensors(T1sum(21),[G1tensor(121)])
  call ol_merge_tensors(T1sum(22),[G1tensor(127)])
  call ol_merge_tensors(T1sum(23),[G1tensor(133)])
  call ol_merge_tensors(T1sum(24),[G1tensor(139)])
  call ol_merge_tensors(T1sum(25),[G1tensor(145)])
  call ol_merge_tensors(T1sum(26),[G1tensor(151)])
  call ol_merge_tensors(T1sum(27),[G1tensor(157)])
  call ol_merge_tensors(T1sum(28),[G1tensor(163)])
  call ol_merge_tensors(T1sum(29),[G1tensor(169)])
  call ol_merge_tensors(T1sum(30),[G1tensor(175)])
  call ol_merge_tensors(T1sum(31),[G1tensor(181)])
  call ol_merge_tensors(T1sum(32),[G1tensor(187)])
  call ol_merge_tensors(T1sum(33),[G1tensor(193)])
  call ol_merge_tensors(T1sum(34),[G1tensor(199)])
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(79),h0tab(:,79),[16,1,12,2],[nMB,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,79),heltab2x16(:,:,79))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(3),n2h8(91))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(80),h0tab(:,80),[16,1,12,2],[nMB,nMW,nMW,nMB],5,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,80),heltab2x16(:,:,80))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(7),n2h8(92))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(81),h0tab(:,81),[16,2,8,5],[nMB,nMW,nMW,nMB],4,1,wf2(:,2))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,81),heltab2x16(:,:,81))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(8),n2h8(93))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(82),h0tab(:,82),[16,2,8,5],[nMB,nMW,nMW,nMB],4,1,wf2(:,2))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,82),heltab2x16(:,:,82))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(9),n2h8(94))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(83),h0tab(:,83),[16,2,8,5],[nMB,nMW,nMW,nMB],4,1,wf2(:,2))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,83),heltab2x16(:,:,83))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(10),n2h8(95))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(84),h0tab(:,84),[16,2,8,5],[nMB,nMW,nMW,nMB],4,1,wf2(:,2))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,84),heltab2x16(:,:,84))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(11),n2h8(96))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(85),h0tab(:,85),[16,5,2,8],[nMT,nMH,nMT,nMT],4,1,wf2(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,85),heltab2x16(:,:,85))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(12),n2h8(97))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(86),h0tab(:,86),[16,5,2,8],[nMT,nMZ,nMT,nMT],4,1,wf2(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,86),heltab2x16(:,:,86))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(13),n2h8(98))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(87),h0tab(:,87),[16,5,2,8],[nMB,nMW,nMB,nMB],4,1,wf2(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,87),heltab2x16(:,:,87))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(79),n2h8(99))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(88),h0tab(:,88),[16,5,2,8],[nMT,0,nMT,nMT],4,1,wf2(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,88),heltab2x16(:,:,88))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(14),n2h8(100))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(89),h0tab(:,89),[16,5,2,8],[nMT,nMZ,nMT,nMT],4,1,wf2(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,89),heltab2x16(:,:,89))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(4),n2h8(101))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(90),h0tab(:,90),[16,5,2,8],[nMB,nMW,nMB,nMB],4,1,wf2(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,90),heltab2x16(:,:,90))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(15),n2h8(102))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(91),h0tab(:,91),[16,2,5,8],[nMT,nMH,nMT,nMT],4,1,wf2(:,2))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,91),heltab2x16(:,:,91))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(2),n2h8(103))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(92),h0tab(:,92),[16,2,5,8],[nMT,nMZ,nMT,nMT],4,1,wf2(:,2))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,92),heltab2x16(:,:,92))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(16),n2h8(104))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(93),h0tab(:,93),[16,2,5,8],[nMB,nMW,nMB,nMB],4,1,wf2(:,2))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,93),heltab2x16(:,:,93))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(5),n2h8(105))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(94),h0tab(:,94),[16,2,5,8],[nMT,0,nMT,nMT],4,1,wf2(:,2))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,94),heltab2x16(:,:,94))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(17),n2h8(106))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(95),h0tab(:,95),[16,2,5,8],[nMT,nMZ,nMT,nMT],4,1,wf2(:,2))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,95),heltab2x16(:,:,95))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(1),n2h8(107))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(96),h0tab(:,96),[16,2,5,8],[nMB,nMW,nMB,nMB],4,1,wf2(:,2))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,96),heltab2x16(:,:,96))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(18),n2h8(108))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(97),h0tab(:,97),[16,1,8,6],[nMB,nMW,nMW,nMB],4,1,wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,97),heltab2x16(:,:,97))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(6),n2h8(109))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(98),h0tab(:,98),[16,1,8,6],[nMB,nMW,nMW,nMB],4,1,wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,98),heltab2x16(:,:,98))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(19),n2h8(110))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(99),h0tab(:,99),[16,1,8,6],[nMB,nMW,nMW,nMB],4,1,wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,99),heltab2x16(:,:,99))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(20),n2h8(111))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(100),h0tab(:,100),[16,1,8,6],[nMB,nMW,nMW,nMB],4,1,wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,100),heltab2x16(:,:,100))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(21),n2h8(112))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(101),h0tab(:,101),[16,6,1,8],[nMT,nMH,nMT,nMT],4,1,wf2(:,4))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,101),heltab2x16(:,:,101))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(22),n2h8(113))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(102),h0tab(:,102),[16,6,1,8],[nMT,nMZ,nMT,nMT],4,1,wf2(:,4))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,102),heltab2x16(:,:,102))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(23),n2h8(114))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(103),h0tab(:,103),[16,6,1,8],[nMB,nMW,nMB,nMB],4,1,wf2(:,4))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,103),heltab2x16(:,:,103))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(24),n2h8(115))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(104),h0tab(:,104),[16,6,1,8],[nMT,0,nMT,nMT],4,1,wf2(:,4))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,104),heltab2x16(:,:,104))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(25),n2h8(116))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(105),h0tab(:,105),[16,6,1,8],[nMT,nMZ,nMT,nMT],4,1,wf2(:,4))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,105),heltab2x16(:,:,105))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(26),n2h8(117))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(106),h0tab(:,106),[16,6,1,8],[nMB,nMW,nMB,nMB],4,1,wf2(:,4))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,106),heltab2x16(:,:,106))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(27),n2h8(118))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(107),h0tab(:,107),[16,1,6,8],[nMT,nMH,nMT,nMT],4,1,wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,107),heltab2x16(:,:,107))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(28),n2h8(119))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(108),h0tab(:,108),[16,1,6,8],[nMT,nMZ,nMT,nMT],4,1,wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,108),heltab2x16(:,:,108))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(29),n2h8(120))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(109),h0tab(:,109),[16,1,6,8],[nMB,nMW,nMB,nMB],4,1,wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,109),heltab2x16(:,:,109))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(30),n2h8(121))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(110),h0tab(:,110),[16,1,6,8],[nMT,0,nMT,nMT],4,1,wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,110),heltab2x16(:,:,110))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(31),n2h8(122))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(111),h0tab(:,111),[16,1,6,8],[nMT,nMZ,nMT,nMT],4,1,wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,111),heltab2x16(:,:,111))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(32),n2h8(123))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(112),h0tab(:,112),[16,1,6,8],[nMB,nMW,nMB,nMB],4,1,wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,112),heltab2x16(:,:,112))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(33),n2h8(124))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(113),h0tab(:,113),[16,2,4,9],[nMT,nMH,nMH,nMT],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,113),heltab2x16(:,:,113))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(34),n2h8(125))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(114),h0tab(:,114),[16,2,4,9],[nMT,nMZ,nMZ,nMT],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,114),heltab2x16(:,:,114))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(35),n2h8(126))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(115),h0tab(:,115),[16,2,4,9],[nMB,nMW,nMW,nMB],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,115),heltab2x16(:,:,115))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(36),n2h8(127))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(116),h0tab(:,116),[16,2,4,9],[nMT,nMZ,nMZ,nMT],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,116),heltab2x16(:,:,116))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(37),n2h8(128))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(117),h0tab(:,117),[16,2,4,9],[nMB,nMW,nMW,nMB],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,117),heltab2x16(:,:,117))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(38),n2h8(129))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(118),h0tab(:,118),[16,2,4,9],[nMT,nMZ,nMZ,nMT],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,118),heltab2x16(:,:,118))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(39),n2h8(130))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(119),h0tab(:,119),[16,2,4,9],[nMB,nMW,nMW,nMB],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,119),heltab2x16(:,:,119))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(40),n2h8(131))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(120),h0tab(:,120),[16,2,4,9],[nMT,nMZ,nMZ,nMT],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,120),heltab2x16(:,:,120))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(41),n2h8(132))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(121),h0tab(:,121),[16,2,4,9],[nMB,nMW,nMW,nMB],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,121),heltab2x16(:,:,121))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(42),n2h8(133))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(122),h0tab(:,122),[16,4,2,9],[nMT,nMT,nMH,nMT],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,122),heltab2x16(:,:,122))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(43),n2h8(134))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(123),h0tab(:,123),[16,4,2,9],[nMT,nMT,nMZ,nMT],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,123),heltab2x16(:,:,123))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(44),n2h8(135))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(124),h0tab(:,124),[16,4,2,9],[nMB,nMB,nMW,nMB],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,124),heltab2x16(:,:,124))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(45),n2h8(136))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(125),h0tab(:,125),[16,4,2,9],[nMT,nMT,0,nMT],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,125),heltab2x16(:,:,125))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(46),n2h8(137))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(126),h0tab(:,126),[16,4,2,9],[nMT,nMT,nMZ,nMT],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,126),heltab2x16(:,:,126))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(47),n2h8(138))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(127),h0tab(:,127),[16,4,2,9],[nMB,nMB,nMW,nMB],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,127),heltab2x16(:,:,127))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(48),n2h8(139))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(128),h0tab(:,128),[16,2,9,4],[nMT,nMH,nMT,nMT],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,128),heltab2x16(:,:,128))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(49),n2h8(140))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(129),h0tab(:,129),[16,2,9,4],[nMT,nMZ,nMT,nMT],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,129),heltab2x16(:,:,129))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(50),n2h8(141))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(130),h0tab(:,130),[16,2,9,4],[nMB,nMW,nMB,nMB],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,130),heltab2x16(:,:,130))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(51),n2h8(142))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(131),h0tab(:,131),[16,2,9,4],[nMT,0,nMT,nMT],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,131),heltab2x16(:,:,131))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(52),n2h8(143))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(132),h0tab(:,132),[16,2,9,4],[nMT,nMZ,nMT,nMT],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,132),heltab2x16(:,:,132))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMT,G1H8(53),n2h8(144))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(133),h0tab(:,133),[16,2,9,4],[nMB,nMW,nMB,nMB],4,1,wf4(:,8))
  call Hloop_QV_A(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,133),heltab2x16(:,:,133))
  call Hloop_Q_A(ntryL,G0H8(1),16,nMB,G1H8(54),n2h8(145))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(134),h0tab(:,134),[16,1,4,10],[nMT,nMH,nMH,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,134),heltab2x16(:,:,134))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(55),n2h8(146))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(135),h0tab(:,135),[16,1,4,10],[nMT,nMZ,nMZ,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,135),heltab2x16(:,:,135))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(56),n2h8(147))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(136),h0tab(:,136),[16,1,4,10],[nMB,nMW,nMW,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,136),heltab2x16(:,:,136))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(57),n2h8(148))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(137),h0tab(:,137),[16,1,4,10],[nMT,nMZ,nMZ,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,137),heltab2x16(:,:,137))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(58),n2h8(149))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(138),h0tab(:,138),[16,1,4,10],[nMB,nMW,nMW,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,138),heltab2x16(:,:,138))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(59),n2h8(150))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(139),h0tab(:,139),[16,1,4,10],[nMT,nMZ,nMZ,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,139),heltab2x16(:,:,139))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(60),n2h8(151))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(140),h0tab(:,140),[16,1,4,10],[nMB,nMW,nMW,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,140),heltab2x16(:,:,140))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(61),n2h8(152))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(141),h0tab(:,141),[16,1,4,10],[nMT,nMZ,nMZ,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,141),heltab2x16(:,:,141))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(62),n2h8(153))
  Gcoeff(:)%j = (c(32)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(142),h0tab(:,142),[16,1,4,10],[nMB,nMW,nMW,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,142),heltab2x16(:,:,142))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(63),n2h8(154))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(143),h0tab(:,143),[16,4,1,10],[nMT,nMT,nMH,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,143),heltab2x16(:,:,143))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(64),n2h8(155))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(144),h0tab(:,144),[16,4,1,10],[nMT,nMT,nMZ,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,144),heltab2x16(:,:,144))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(65),n2h8(156))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(145),h0tab(:,145),[16,4,1,10],[nMB,nMB,nMW,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,145),heltab2x16(:,:,145))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(66),n2h8(157))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(146),h0tab(:,146),[16,4,1,10],[nMT,nMT,0,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,146),heltab2x16(:,:,146))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(67),n2h8(158))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(147),h0tab(:,147),[16,4,1,10],[nMT,nMT,nMZ,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,147),heltab2x16(:,:,147))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(68),n2h8(159))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(148),h0tab(:,148),[16,4,1,10],[nMB,nMB,nMW,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,148),heltab2x16(:,:,148))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(69),n2h8(160))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(149),h0tab(:,149),[16,1,10,4],[nMT,nMH,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,149),heltab2x16(:,:,149))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(70),n2h8(161))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(150),h0tab(:,150),[16,1,10,4],[nMT,nMZ,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,150),heltab2x16(:,:,150))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(71),n2h8(162))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(151),h0tab(:,151),[16,1,10,4],[nMB,nMW,nMB,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,151),heltab2x16(:,:,151))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(72),n2h8(163))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(152),h0tab(:,152),[16,1,10,4],[nMT,0,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,152),heltab2x16(:,:,152))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(73),n2h8(164))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(153),h0tab(:,153),[16,1,10,4],[nMT,nMZ,nMT,nMT],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,153),heltab2x16(:,:,153))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMT,G1H8(74),n2h8(165))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(154),h0tab(:,154),[16,1,10,4],[nMB,nMW,nMB,nMB],4,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H16(1),ex5(:),G0H8(1),m3h2x8(:,154),heltab2x16(:,:,154))
  call Hloop_A_Q(ntryL,G0H8(1),16,nMB,G1H8(75),n2h8(166))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(155),h0tab(:,155),[17,4,2,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H16(1),wf4(:,10),G0H4(1),ngPbt,m3h4x4(:,1),heltab2x16(:,:,155))
  call Hloop_Q_A(ntryL,G0H4(1),17,nMB,G1H4(15),n2h4(23))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(156),h0tab(:,156),[17,4,2,8],[nMH,nMH,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AQ_S(ntryL,G0H16(1),wf4(:,10),G0H4(1),ngH,m3h4x4(:,2),heltab2x16(:,:,156))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(157),h0tab(:,157),[17,4,2,8],[nMZ,nMZ,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AQ_S(ntryL,G0H16(1),wf4(:,10),G0H4(2),ngX,m3h4x4(:,3),heltab2x16(:,:,157))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(158),h0tab(:,158),[17,4,2,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,10))
  call Hloop_AQ_S(ntryL,G0H16(1),wf4(:,10),G0H4(3),ngPbt,m3h4x4(:,4),heltab2x16(:,:,158))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(159),h0tab(:,159),[17,4,2,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,10))
  call Hloop_WQ_A(ntryL,G0H16(1),wf4(:,10),G0H4(4),m3h4x4(:,5),heltab2x16(:,:,159))
  call Hloop_Q_A(ntryL,G0H4(4),17,nMB,G1H4(16),n2h4(24))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(160),h0tab(:,160),[17,4,2,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H16(1),wf4(:,10),G0H4(4),ngPbt,m3h4x4(:,6),heltab2x16(:,:,160))
  call Hloop_Q_A(ntryL,G0H4(4),17,nMB,G1H4(19),n2h4(25))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(161),h0tab(:,161),[17,4,2,8],[nMZ,nMZ,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AQ_Z(ntryL,G0H16(1),wf4(:,10),G0H4(4),ngZu,m3h4x4(:,7),heltab2x16(:,:,161))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(162),h0tab(:,162),[17,4,2,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,10))
  call Hloop_AQ_W(ntryL,G0H16(1),wf4(:,10),G0H4(5),m3h4x4(:,8),heltab2x16(:,:,162))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(163),h0tab(:,163),[17,4,2,8],[nMZ,nMZ,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AQ_S(ntryL,G0H16(1),wf4(:,10),G0H4(6),ngX,m3h4x4(:,9),heltab2x16(:,:,163))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(164),h0tab(:,164),[17,4,2,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,10))
  call Hloop_AQ_S(ntryL,G0H16(1),wf4(:,10),G0H4(7),ngPbt,m3h4x4(:,10),heltab2x16(:,:,164))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(165),h0tab(:,165),[17,4,2,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,10))
  call Hloop_WQ_A(ntryL,G0H16(1),wf4(:,10),G0H4(8),m3h4x4(:,11),heltab2x16(:,:,165))
  call Hloop_Q_A(ntryL,G0H4(8),17,nMB,G1H4(20),n2h4(26))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(166),h0tab(:,166),[17,4,2,8],[nMZ,nMZ,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AQ_Z(ntryL,G0H16(1),wf4(:,10),G0H4(8),ngZu,m3h4x4(:,12),heltab2x16(:,:,166))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(167),h0tab(:,167),[17,4,2,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,10))
  call Hloop_AQ_W(ntryL,G0H16(1),wf4(:,10),G0H4(9),m3h4x4(:,13),heltab2x16(:,:,167))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(168),h0tab(:,168),[17,2,4,8],[nMH,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AQ_S(ntryL,G0H16(1),wf4(:,10),G0H4(10),ngH,m3h4x4(:,14),heltab2x16(:,:,168))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(169),h0tab(:,169),[17,2,4,8],[nMZ,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AQ_S(ntryL,G0H16(1),wf4(:,10),G0H4(11),ngX,m3h4x4(:,15),heltab2x16(:,:,169))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(170),h0tab(:,170),[17,2,4,8],[nMW,nMB,nMB,nMB],4,1,wf4(:,10))
  call Hloop_AQ_S(ntryL,G0H16(1),wf4(:,10),G0H4(12),ngPbt,m3h4x4(:,16),heltab2x16(:,:,170))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(171),h0tab(:,171),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H16(1),wf4(:,10),G0H4(13),ngPbt,m3h4x4(:,17),heltab2x16(:,:,171))
  call Hloop_Q_A(ntryL,G0H4(13),17,nMB,G1H4(21),n2h4(27))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(172),h0tab(:,172),[17,2,4,8],[0,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AQ_V(ntryL,G0H16(1),wf4(:,10),G0H4(13),m3h4x4(:,18),heltab2x16(:,:,172))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(173),h0tab(:,173),[17,2,4,8],[nMZ,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AQ_Z(ntryL,G0H16(1),wf4(:,10),G0H4(14),ngZu,m3h4x4(:,19),heltab2x16(:,:,173))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(174),h0tab(:,174),[17,2,4,8],[nMW,nMB,nMB,nMB],4,1,wf4(:,10))
  call Hloop_AQ_W(ntryL,G0H16(1),wf4(:,10),G0H4(15),m3h4x4(:,20),heltab2x16(:,:,174))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(175),h0tab(:,175),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,10))
  call Hloop_WQ_A(ntryL,G0H16(1),wf4(:,10),G0H4(16),m3h4x4(:,21),heltab2x16(:,:,175))
  call Hloop_Q_A(ntryL,G0H4(16),17,nMB,G1H4(22),n2h4(28))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(176),h0tab(:,176),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H16(1),wf4(:,10),G0H4(16),ngPbt,m3h4x4(:,22),heltab2x16(:,:,176))
  call Hloop_Q_A(ntryL,G0H4(16),17,nMB,G1H4(25),n2h4(29))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(177),h0tab(:,177),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H16(1),wf4(:,10),G0H4(16),ngPbt,m3h4x4(:,23),heltab2x16(:,:,177))
  call Hloop_Q_A(ntryL,G0H4(16),17,nMB,G1H4(26),n2h4(30))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(178),h0tab(:,178),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,10))
  call Hloop_WQ_A(ntryL,G0H16(1),wf4(:,10),G0H4(16),m3h4x4(:,24),heltab2x16(:,:,178))
  call Hloop_Q_A(ntryL,G0H4(16),17,nMB,G1H4(27),n2h4(31))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(179),h0tab(:,179),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,10))
  call Hloop_WQ_A(ntryL,G0H16(1),wf4(:,10),G0H4(16),m3h4x4(:,25),heltab2x16(:,:,179))
  call Hloop_Q_A(ntryL,G0H4(16),17,nMB,G1H4(28),n2h4(32))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(180),h0tab(:,180),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H16(1),wf4(:,10),G0H4(16),ngPbt,m3h4x4(:,26),heltab2x16(:,:,180))
  call Hloop_Q_A(ntryL,G0H4(16),17,nMB,G1H4(31),n2h4(33))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(181),h0tab(:,181),[17,2,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,10))
  call Hloop_WQ_A(ntryL,G0H16(1),wf4(:,10),G0H4(16),m3h4x4(:,27),heltab2x16(:,:,181))
  call Hloop_Q_A(ntryL,G0H4(16),17,nMB,G1H4(32),n2h4(34))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(182),h0tab(:,182),[17,2,8,4],[nMH,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AQ_S(ntryL,G0H16(1),wf4(:,10),G0H4(16),ngH,m3h4x4(:,28),heltab2x16(:,:,182))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(183),h0tab(:,183),[17,2,8,4],[nMZ,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AQ_S(ntryL,G0H16(1),wf4(:,10),G0H4(17),ngX,m3h4x4(:,29),heltab2x16(:,:,183))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(184),h0tab(:,184),[17,2,8,4],[nMW,nMB,nMB,nMB],4,1,wf4(:,10))
  call Hloop_AQ_S(ntryL,G0H16(1),wf4(:,10),G0H4(18),ngPbt,m3h4x4(:,30),heltab2x16(:,:,184))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(185),h0tab(:,185),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H16(1),wf4(:,10),G0H4(19),ngPbt,m3h4x4(:,31),heltab2x16(:,:,185))
  call Hloop_Q_A(ntryL,G0H4(19),17,nMB,G1H4(33),n2h4(35))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(186),h0tab(:,186),[17,2,8,4],[0,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AQ_V(ntryL,G0H16(1),wf4(:,10),G0H4(19),m3h4x4(:,32),heltab2x16(:,:,186))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(187),h0tab(:,187),[17,2,8,4],[nMZ,nMT,nMT,nMT],4,1,wf4(:,10))
  call Hloop_AQ_Z(ntryL,G0H16(1),wf4(:,10),G0H4(20),ngZu,m3h4x4(:,33),heltab2x16(:,:,187))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(188),h0tab(:,188),[17,2,8,4],[nMW,nMB,nMB,nMB],4,1,wf4(:,10))
  call Hloop_AQ_W(ntryL,G0H16(1),wf4(:,10),G0H4(21),m3h4x4(:,34),heltab2x16(:,:,188))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(189),h0tab(:,189),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,10))
  call Hloop_WQ_A(ntryL,G0H16(1),wf4(:,10),G0H4(22),m3h4x4(:,35),heltab2x16(:,:,189))
  call Hloop_Q_A(ntryL,G0H4(22),17,nMB,G1H4(34),n2h4(36))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(190),h0tab(:,190),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H16(1),wf4(:,10),G0H4(22),ngPbt,m3h4x4(:,36),heltab2x16(:,:,190))
  call Hloop_Q_A(ntryL,G0H4(22),17,nMB,G1H4(37),n2h4(37))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(191),h0tab(:,191),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H16(1),wf4(:,10),G0H4(22),ngPbt,m3h4x4(:,37),heltab2x16(:,:,191))
  call Hloop_Q_A(ntryL,G0H4(22),17,nMB,G1H4(38),n2h4(38))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(192),h0tab(:,192),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,10))
  call Hloop_WQ_A(ntryL,G0H16(1),wf4(:,10),G0H4(22),m3h4x4(:,38),heltab2x16(:,:,192))
  call Hloop_Q_A(ntryL,G0H4(22),17,nMB,G1H4(39),n2h4(39))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(193),h0tab(:,193),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,10))
  call Hloop_WQ_A(ntryL,G0H16(1),wf4(:,10),G0H4(22),m3h4x4(:,39),heltab2x16(:,:,193))
  call Hloop_Q_A(ntryL,G0H4(22),17,nMB,G1H4(40),n2h4(40))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(194),h0tab(:,194),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,10))
  call Hloop_SQ_A(ntryL,G0H16(1),wf4(:,10),G0H4(22),ngPbt,m3h4x4(:,40),heltab2x16(:,:,194))
  call Hloop_Q_A(ntryL,G0H4(22),17,nMB,G1H4(43),n2h4(41))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(195),h0tab(:,195),[17,2,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,10))
  call Hloop_WQ_A(ntryL,G0H16(1),wf4(:,10),G0H4(22),m3h4x4(:,41),heltab2x16(:,:,195))
  call Hloop_Q_A(ntryL,G0H4(22),17,nMB,G1H4(44),n2h4(42))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(196),h0tab(:,196),[18,4,1,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H16(1),wf4(:,5),G0H4(22),ngPtb,m3h4x4(:,42),heltab2x16(:,:,196))
  call Hloop_A_Q(ntryL,G0H4(22),18,nMB,G1H4(45),n2h4(43))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(197),h0tab(:,197),[18,4,1,8],[nMH,nMH,nMT,nMT],4,1,wf4(:,5))
  call Hloop_QA_S(ntryL,G0H16(1),wf4(:,5),G0H4(22),ngH,m3h4x4(:,43),heltab2x16(:,:,197))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(198),h0tab(:,198),[18,4,1,8],[nMZ,nMZ,nMT,nMT],4,1,wf4(:,5))
  call Hloop_QA_S(ntryL,G0H16(1),wf4(:,5),G0H4(23),ngX,m3h4x4(:,44),heltab2x16(:,:,198))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(199),h0tab(:,199),[18,4,1,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QA_S(ntryL,G0H16(1),wf4(:,5),G0H4(24),ngPtb,m3h4x4(:,45),heltab2x16(:,:,199))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(200),h0tab(:,200),[18,4,1,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,5))
  call Hloop_WA_Q(ntryL,G0H16(1),wf4(:,5),G0H4(25),m3h4x4(:,46),heltab2x16(:,:,200))
  call Hloop_A_Q(ntryL,G0H4(25),18,nMB,G1H4(46),n2h4(44))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(201),h0tab(:,201),[18,4,1,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H16(1),wf4(:,5),G0H4(25),ngPtb,m3h4x4(:,47),heltab2x16(:,:,201))
  call Hloop_A_Q(ntryL,G0H4(25),18,nMB,G1H4(49),n2h4(45))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(202),h0tab(:,202),[18,4,1,8],[nMZ,nMZ,nMT,nMT],4,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H16(1),wf4(:,5),G0H4(25),ngZu,m3h4x4(:,48),heltab2x16(:,:,202))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(203),h0tab(:,203),[18,4,1,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QA_W(ntryL,G0H16(1),wf4(:,5),G0H4(26),m3h4x4(:,49),heltab2x16(:,:,203))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(204),h0tab(:,204),[18,4,1,8],[nMZ,nMZ,nMT,nMT],4,1,wf4(:,5))
  call Hloop_QA_S(ntryL,G0H16(1),wf4(:,5),G0H4(27),ngX,m3h4x4(:,50),heltab2x16(:,:,204))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(205),h0tab(:,205),[18,4,1,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QA_S(ntryL,G0H16(1),wf4(:,5),G0H4(28),ngPtb,m3h4x4(:,51),heltab2x16(:,:,205))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(206),h0tab(:,206),[18,4,1,8],[nMB,nMB,nMW,nMW],4,1,wf4(:,5))
  call Hloop_WA_Q(ntryL,G0H16(1),wf4(:,5),G0H4(29),m3h4x4(:,52),heltab2x16(:,:,206))
  call Hloop_A_Q(ntryL,G0H4(29),18,nMB,G1H4(50),n2h4(46))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(207),h0tab(:,207),[18,4,1,8],[nMZ,nMZ,nMT,nMT],4,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H16(1),wf4(:,5),G0H4(29),ngZu,m3h4x4(:,53),heltab2x16(:,:,207))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(208),h0tab(:,208),[18,4,1,8],[nMW,nMW,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QA_W(ntryL,G0H16(1),wf4(:,5),G0H4(30),m3h4x4(:,54),heltab2x16(:,:,208))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(209),h0tab(:,209),[18,1,4,8],[nMH,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_QA_S(ntryL,G0H16(1),wf4(:,5),G0H4(31),ngH,m3h4x4(:,55),heltab2x16(:,:,209))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(210),h0tab(:,210),[18,1,4,8],[nMZ,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_QA_S(ntryL,G0H16(1),wf4(:,5),G0H4(32),ngX,m3h4x4(:,56),heltab2x16(:,:,210))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(211),h0tab(:,211),[18,1,4,8],[nMW,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QA_S(ntryL,G0H16(1),wf4(:,5),G0H4(33),ngPtb,m3h4x4(:,57),heltab2x16(:,:,211))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(212),h0tab(:,212),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H16(1),wf4(:,5),G0H4(34),ngPtb,m3h4x4(:,58),heltab2x16(:,:,212))
  call Hloop_A_Q(ntryL,G0H4(34),18,nMB,G1H4(51),n2h4(47))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(213),h0tab(:,213),[18,1,4,8],[0,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H16(1),wf4(:,5),G0H4(34),m3h4x4(:,59),heltab2x16(:,:,213))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(214),h0tab(:,214),[18,1,4,8],[nMZ,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H16(1),wf4(:,5),G0H4(35),ngZu,m3h4x4(:,60),heltab2x16(:,:,214))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(215),h0tab(:,215),[18,1,4,8],[nMW,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QA_W(ntryL,G0H16(1),wf4(:,5),G0H4(36),m3h4x4(:,61),heltab2x16(:,:,215))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(216),h0tab(:,216),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_WA_Q(ntryL,G0H16(1),wf4(:,5),G0H4(37),m3h4x4(:,62),heltab2x16(:,:,216))
  call Hloop_A_Q(ntryL,G0H4(37),18,nMB,G1H4(52),n2h4(48))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(217),h0tab(:,217),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H16(1),wf4(:,5),G0H4(37),ngPtb,m3h4x4(:,63),heltab2x16(:,:,217))
  call Hloop_A_Q(ntryL,G0H4(37),18,nMB,G1H4(55),n2h4(49))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(218),h0tab(:,218),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H16(1),wf4(:,5),G0H4(37),ngPtb,m3h4x4(:,64),heltab2x16(:,:,218))
  call Hloop_A_Q(ntryL,G0H4(37),18,nMB,G1H4(56),n2h4(50))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(219),h0tab(:,219),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_WA_Q(ntryL,G0H16(1),wf4(:,5),G0H4(37),m3h4x4(:,65),heltab2x16(:,:,219))
  call Hloop_A_Q(ntryL,G0H4(37),18,nMB,G1H4(57),n2h4(51))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(220),h0tab(:,220),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_WA_Q(ntryL,G0H16(1),wf4(:,5),G0H4(37),m3h4x4(:,66),heltab2x16(:,:,220))
  call Hloop_A_Q(ntryL,G0H4(37),18,nMB,G1H4(58),n2h4(52))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(221),h0tab(:,221),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H16(1),wf4(:,5),G0H4(37),ngPtb,m3h4x4(:,67),heltab2x16(:,:,221))
  call Hloop_A_Q(ntryL,G0H4(37),18,nMB,G1H4(61),n2h4(53))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(222),h0tab(:,222),[18,1,4,8],[nMB,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_WA_Q(ntryL,G0H16(1),wf4(:,5),G0H4(37),m3h4x4(:,68),heltab2x16(:,:,222))
  call Hloop_A_Q(ntryL,G0H4(37),18,nMB,G1H4(62),n2h4(54))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(223),h0tab(:,223),[18,1,8,4],[nMH,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_QA_S(ntryL,G0H16(1),wf4(:,5),G0H4(37),ngH,m3h4x4(:,69),heltab2x16(:,:,223))
  Gcoeff(:)%j = (c(17)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(224),h0tab(:,224),[18,1,8,4],[nMZ,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_QA_S(ntryL,G0H16(1),wf4(:,5),G0H4(38),ngX,m3h4x4(:,70),heltab2x16(:,:,224))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(225),h0tab(:,225),[18,1,8,4],[nMW,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QA_S(ntryL,G0H16(1),wf4(:,5),G0H4(39),ngPtb,m3h4x4(:,71),heltab2x16(:,:,225))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(226),h0tab(:,226),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H16(1),wf4(:,5),G0H4(40),ngPtb,m3h4x4(:,72),heltab2x16(:,:,226))
  call Hloop_A_Q(ntryL,G0H4(40),18,nMB,G1H4(63),n2h4(55))
  Gcoeff(:)%j = (c(42)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(227),h0tab(:,227),[18,1,8,4],[0,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_QA_V(ntryL,G0H16(1),wf4(:,5),G0H4(40),m3h4x4(:,73),heltab2x16(:,:,227))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(228),h0tab(:,228),[18,1,8,4],[nMZ,nMT,nMT,nMT],4,1,wf4(:,5))
  call Hloop_QA_Z(ntryL,G0H16(1),wf4(:,5),G0H4(41),ngZu,m3h4x4(:,74),heltab2x16(:,:,228))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(229),h0tab(:,229),[18,1,8,4],[nMW,nMB,nMB,nMB],4,1,wf4(:,5))
  call Hloop_QA_W(ntryL,G0H16(1),wf4(:,5),G0H4(42),m3h4x4(:,75),heltab2x16(:,:,229))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(230),h0tab(:,230),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_WA_Q(ntryL,G0H16(1),wf4(:,5),G0H4(43),m3h4x4(:,76),heltab2x16(:,:,230))
  call Hloop_A_Q(ntryL,G0H4(43),18,nMB,G1H4(64),n2h4(56))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(231),h0tab(:,231),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H16(1),wf4(:,5),G0H4(43),ngPtb,m3h4x4(:,77),heltab2x16(:,:,231))
  call Hloop_A_Q(ntryL,G0H4(43),18,nMB,G1H4(2),n2h4(57))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(232),h0tab(:,232),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H16(1),wf4(:,5),G0H4(43),ngPtb,m3h4x4(:,78),heltab2x16(:,:,232))
  call Hloop_A_Q(ntryL,G0H4(43),18,nMB,G1H4(3),n2h4(58))
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(233),h0tab(:,233),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_WA_Q(ntryL,G0H16(1),wf4(:,5),G0H4(43),m3h4x4(:,79),heltab2x16(:,:,233))
  call Hloop_A_Q(ntryL,G0H4(43),18,nMB,G1H4(4),n2h4(59))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(234),h0tab(:,234),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_WA_Q(ntryL,G0H16(1),wf4(:,5),G0H4(43),m3h4x4(:,80),heltab2x16(:,:,234))
  call Hloop_A_Q(ntryL,G0H4(43),18,nMB,G1H4(5),n2h4(60))
  Gcoeff(:)%j = (c(20)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(235),h0tab(:,235),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_SA_Q(ntryL,G0H16(1),wf4(:,5),G0H4(43),ngPtb,m3h4x4(:,81),heltab2x16(:,:,235))
  call Hloop_A_Q(ntryL,G0H4(43),18,nMB,G1H4(9),n2h4(61))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(236),h0tab(:,236),[18,1,8,4],[nMB,nMW,nMW,nMW],4,1,wf4(:,5))
  call Hloop_WA_Q(ntryL,G0H16(1),wf4(:,5),G0H4(43),m3h4x4(:,82),heltab2x16(:,:,236))
  call Hloop_A_Q(ntryL,G0H4(43),18,nMB,G1H4(10),n2h4(62))
  call Hloop_AQ_S(ntryL,G1H8(3),ex1(:),G1H4(11),ngPbt,m3h2x4(:,79),heltab2x8(:,:,91))
  call Hloop_AQ_W(ntryL,G1H8(7),ex1(:),G1H4(13),m3h2x4(:,80),heltab2x8(:,:,92))
  call Hloop_QA_S(ntryL,G1H8(8),ex2(:),G1H4(67),ngPtb,m3h2x4(:,81),heltab2x8(:,:,93))
  call Hloop_QA_S(ntryL,G1H8(9),ex2(:),G1H4(68),ngPtb,m3h2x4(:,82),heltab2x8(:,:,94))
  call Hloop_QA_W(ntryL,G1H8(10),ex2(:),G1H4(69),m3h2x4(:,83),heltab2x8(:,:,95))
  call Hloop_QA_W(ntryL,G1H8(11),ex2(:),G1H4(70),m3h2x4(:,84),heltab2x8(:,:,96))
  call Hloop_AQ_S(ntryL,G1H8(12),wf2(:,2),G1H4(73),ngH,m3h2x4(:,85),heltab2x8(:,:,97))
  call Hloop_AQ_S(ntryL,G1H8(13),wf2(:,2),G1H4(74),ngX,m3h2x4(:,86),heltab2x8(:,:,98))
  call Hloop_AQ_S(ntryL,G1H8(79),wf2(:,2),G1H4(1),ngPbt,m3h2x4(:,87),heltab2x8(:,:,99))
  call Hloop_AQ_V(ntryL,G1H8(14),wf2(:,2),G1H4(75),m3h2x4(:,88),heltab2x8(:,:,100))
  call Hloop_AQ_Z(ntryL,G1H8(4),wf2(:,2),G1H4(78),ngZu,m3h2x4(:,89),heltab2x8(:,:,101))
  call Hloop_AQ_W(ntryL,G1H8(15),wf2(:,2),G1H4(79),m3h2x4(:,90),heltab2x8(:,:,102))
  call Hloop_QA_S(ntryL,G1H8(2),ex2(:),G1H4(80),ngH,m3h2x4(:,91),heltab2x8(:,:,103))
  call Hloop_QA_S(ntryL,G1H8(16),ex2(:),G1H4(81),ngX,m3h2x4(:,92),heltab2x8(:,:,104))
  call Hloop_QA_S(ntryL,G1H8(5),ex2(:),G1H4(84),ngPtb,m3h2x4(:,93),heltab2x8(:,:,105))
  call Hloop_QA_V(ntryL,G1H8(17),ex2(:),G1H4(85),m3h2x4(:,94),heltab2x8(:,:,106))
  call Hloop_QA_Z(ntryL,G1H8(1),ex2(:),G1H4(86),ngZu,m3h2x4(:,95),heltab2x8(:,:,107))
  call Hloop_QA_W(ntryL,G1H8(18),ex2(:),G1H4(87),m3h2x4(:,96),heltab2x8(:,:,108))
  call Hloop_AQ_S(ntryL,G1H8(6),ex1(:),G1H4(90),ngPbt,m3h2x4(:,97),heltab2x8(:,:,109))
  call Hloop_AQ_S(ntryL,G1H8(19),ex1(:),G1H4(91),ngPbt,m3h2x4(:,98),heltab2x8(:,:,110))
  call Hloop_AQ_W(ntryL,G1H8(20),ex1(:),G1H4(92),m3h2x4(:,99),heltab2x8(:,:,111))
  call Hloop_AQ_W(ntryL,G1H8(21),ex1(:),G1H4(93),m3h2x4(:,100),heltab2x8(:,:,112))
  call Hloop_QA_S(ntryL,G1H8(22),wf2(:,4),G1H4(96),ngH,m3h2x4(:,101),heltab2x8(:,:,113))
  call Hloop_QA_S(ntryL,G1H8(23),wf2(:,4),G1H4(97),ngX,m3h2x4(:,102),heltab2x8(:,:,114))
  call Hloop_QA_S(ntryL,G1H8(24),wf2(:,4),G1H4(6),ngPtb,m3h2x4(:,103),heltab2x8(:,:,115))
  call Hloop_QA_V(ntryL,G1H8(25),wf2(:,4),G1H4(98),m3h2x4(:,104),heltab2x8(:,:,116))
  call Hloop_QA_Z(ntryL,G1H8(26),wf2(:,4),G1H4(101),ngZu,m3h2x4(:,105),heltab2x8(:,:,117))
  call Hloop_QA_W(ntryL,G1H8(27),wf2(:,4),G1H4(102),m3h2x4(:,106),heltab2x8(:,:,118))
  call Hloop_AQ_S(ntryL,G1H8(28),ex1(:),G1H4(103),ngH,m3h2x4(:,107),heltab2x8(:,:,119))
  call Hloop_AQ_S(ntryL,G1H8(29),ex1(:),G1H4(104),ngX,m3h2x4(:,108),heltab2x8(:,:,120))
  call Hloop_AQ_S(ntryL,G1H8(30),ex1(:),G1H4(107),ngPbt,m3h2x4(:,109),heltab2x8(:,:,121))
  call Hloop_AQ_V(ntryL,G1H8(31),ex1(:),G1H4(108),m3h2x4(:,110),heltab2x8(:,:,122))
  call Hloop_AQ_Z(ntryL,G1H8(32),ex1(:),G1H4(109),ngZu,m3h2x4(:,111),heltab2x8(:,:,123))
  call Hloop_AQ_W(ntryL,G1H8(33),ex1(:),G1H4(110),m3h2x4(:,112),heltab2x8(:,:,124))
  call Hloop_QA_S(ntryL,G1H8(34),ex2(:),G1H4(113),ngH,m3h2x4(:,113),heltab2x8(:,:,125))
  call Hloop_QA_S(ntryL,G1H8(35),ex2(:),G1H4(114),ngX,m3h2x4(:,114),heltab2x8(:,:,126))
  call Hloop_QA_S(ntryL,G1H8(36),ex2(:),G1H4(115),ngPtb,m3h2x4(:,115),heltab2x8(:,:,127))
  call Hloop_QA_S(ntryL,G1H8(37),ex2(:),G1H4(116),ngX,m3h2x4(:,116),heltab2x8(:,:,128))
  call Hloop_QA_S(ntryL,G1H8(38),ex2(:),G1H4(119),ngPtb,m3h2x4(:,117),heltab2x8(:,:,129))
  call Hloop_QA_Z(ntryL,G1H8(39),ex2(:),G1H4(120),ngZu,m3h2x4(:,118),heltab2x8(:,:,130))
  call Hloop_QA_W(ntryL,G1H8(40),ex2(:),G1H4(121),m3h2x4(:,119),heltab2x8(:,:,131))
  call Hloop_QA_Z(ntryL,G1H8(41),ex2(:),G1H4(122),ngZu,m3h2x4(:,120),heltab2x8(:,:,132))
  call Hloop_QA_W(ntryL,G1H8(42),ex2(:),G1H4(125),m3h2x4(:,121),heltab2x8(:,:,133))
  call Hloop_QS_A(ntryL,G1H8(43),ex3(:),G1H8(76),ngH,m3h1x8(:,13),heltab2x8(:,:,134))
  call Hloop_Q_A(ntryL,G1H8(76),20,nMT,G2H8(1),n2h8(167))
  call Hloop_QS_A(ntryL,G1H8(44),ex3(:),G1H8(77),ngH,m3h1x8(:,14),heltab2x8(:,:,135))
  call Hloop_Q_A(ntryL,G1H8(77),20,nMT,G2H8(2),n2h8(168))
  call Hloop_QS_A(ntryL,G1H8(45),ex3(:),G1H8(78),ngH,m3h1x8(:,15),heltab2x8(:,:,136))



end subroutine vamp_1

end module ol_vamp_1_pphtt_ew_ttxhag_2_/**/REALKIND
