
module ol_vamp_1_pphtt_ew_ttxbbxh_3_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphtt_ew_ttxbbxh_3.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphtt_ew_ttxbbxh_3.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pphtt_ew_ttxbbxh_3_/**/DREALKIND
  use ol_tensor_sum_storage_pphtt_ew_ttxbbxh_3_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pphtt_ew_ttxbbxh_3_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pphtt_ew_ttxbbxh_3_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(4,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(57)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(1),h0tab(:,1),[16,4,1,2,8],[nMB,nMH,nMT,nMH,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (c(57)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(2),h0tab(:,2),[16,4,1,2,8],[nMB,nMH,nMT,nMZ,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,2),heltab2x16(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (c(57)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(3),h0tab(:,3),[16,4,1,2,8],[nMB,nMZ,nMT,nMH,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (c(57)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(4),h0tab(:,4),[16,4,1,2,8],[nMB,nMZ,nMT,nMZ,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,4),heltab2x16(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(4),n2h16(4))
  Gcoeff(:)%j = (c(29)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(5),h0tab(:,5),[16,4,1,2,8],[nMT,nMW,nMB,nMW,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,5),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMT,G1H16(5),n2h16(5))
  Gcoeff(:)%j = (c(266)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(6),h0tab(:,6),[16,4,1,2,8],[nMB,nMH,nMT,0,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,6),heltab2x16(:,:,6))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(6),n2h16(6))
  Gcoeff(:)%j = (c(266)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(7),h0tab(:,7),[16,4,1,2,8],[nMB,nMZ,nMT,0,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,7),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(7),n2h16(7))
  Gcoeff(:)%j = (-(c(268)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(8),h0tab(:,8),[16,4,1,2,8],[nMB,nMH,nMT,nMZ,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,8),heltab2x16(:,:,8))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(8),n2h16(8))
  Gcoeff(:)%j = (-(c(268)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(9),h0tab(:,9),[16,4,1,2,8],[nMB,nMZ,nMT,nMZ,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,9),heltab2x16(:,:,9))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(9),n2h16(9))
  Gcoeff(:)%j = (c(89)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(10),h0tab(:,10),[16,4,1,2,8],[nMT,nMW,nMB,nMW,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,10),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMT,G1H16(10),n2h16(10))
  Gcoeff(:)%j = (-(c(270)*M(2,:)%j)+c(269)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(11),h0tab(:,11),[16,4,1,2,8],[nMB,nMH,nMT,0,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,11),heltab2x16(:,:,11))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(11),n2h16(11))
  Gcoeff(:)%j = (-(c(270)*M(2,:)%j)+c(269)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(12),h0tab(:,12),[16,4,1,2,8],[nMB,nMZ,nMT,0,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,12),heltab2x16(:,:,12))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(12),n2h16(12))
  Gcoeff(:)%j = (c(266)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(13),h0tab(:,13),[16,4,1,2,8],[nMB,0,nMT,nMH,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,13),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(13),n2h16(13))
  Gcoeff(:)%j = (c(266)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(14),h0tab(:,14),[16,4,1,2,8],[nMB,0,nMT,nMZ,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,14),heltab2x16(:,:,14))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(14),n2h16(14))
  Gcoeff(:)%j = (-(c(268)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(15),h0tab(:,15),[16,4,1,2,8],[nMB,nMZ,nMT,nMH,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,15),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(15),n2h16(15))
  Gcoeff(:)%j = (-(c(268)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(16),h0tab(:,16),[16,4,1,2,8],[nMB,nMZ,nMT,nMZ,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,16),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(16),n2h16(16))
  Gcoeff(:)%j = (c(89)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(17),h0tab(:,17),[16,4,1,2,8],[nMT,nMW,nMB,nMW,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,17),heltab2x16(:,:,17))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMT,G1H16(17),n2h16(17))
  Gcoeff(:)%j = (-(c(270)*M(2,:)%j)+c(269)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(18),h0tab(:,18),[16,4,1,2,8],[nMB,0,nMT,nMH,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,18),heltab2x16(:,:,18))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(18),n2h16(18))
  Gcoeff(:)%j = (-(c(270)*M(2,:)%j)+c(269)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(19),h0tab(:,19),[16,4,1,2,8],[nMB,0,nMT,nMZ,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,19),heltab2x16(:,:,19))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(19),n2h16(19))
  Gcoeff(:)%j = (c(448)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(20),h0tab(:,20),[16,4,1,2,8],[nMB,0,nMT,0,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,20),heltab2x16(:,:,20))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(20),n2h16(20))
  Gcoeff(:)%j = (-(c(451)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(21),h0tab(:,21),[16,4,1,2,8],[nMB,0,nMT,nMZ,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,21),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(21),n2h16(21))
  Gcoeff(:)%j = (-(c(451)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(22),h0tab(:,22),[16,4,1,2,8],[nMB,nMZ,nMT,0,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,22),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(22),n2h16(22))
  Gcoeff(:)%j = (c(453)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(23),h0tab(:,23),[16,4,1,2,8],[nMB,nMZ,nMT,nMZ,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,23),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(23),n2h16(23))
  Gcoeff(:)%j = (c(123)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(24),h0tab(:,24),[16,4,1,2,8],[nMT,nMW,nMB,nMW,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,24),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMT,G1H16(24),n2h16(24))
  Gcoeff(:)%j = (-(c(458)*M(2,:)%j)+c(457)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(25),h0tab(:,25),[16,4,1,2,8],[nMB,0,nMT,0,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,25),heltab2x16(:,:,25))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(25),n2h16(25))
  Gcoeff(:)%j = (-(c(458)*M(2,:)%j)+c(457)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(26),h0tab(:,26),[16,4,1,2,8],[nMB,0,nMT,0,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,26),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(26),n2h16(26))
  Gcoeff(:)%j = (c(463)*M(2,:)%j-c(462)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(27),h0tab(:,27),[16,4,1,2,8],[nMB,nMZ,nMT,0,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,27),heltab2x16(:,:,27))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(27),n2h16(27))
  Gcoeff(:)%j = (c(463)*M(2,:)%j-c(462)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(28),h0tab(:,28),[16,4,1,2,8],[nMB,0,nMT,nMZ,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(2),ngH,m3h1x16(:,28),heltab2x16(:,:,28))
  call Hloop_A_Q(ntryL,G0H16(2),16,nMB,G1H16(28),n2h16(28))
  Gcoeff(:)%j = (c(63)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(29),h0tab(:,29),[16,2,1,4,8],[nMH,nMT,nMH,nMB,nMH],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(2),m3h1x16(:,29),heltab2x16(:,:,29))
  Gcoeff(:)%j = (c(63)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(30),h0tab(:,30),[16,2,1,4,8],[nMH,nMT,nMZ,nMB,nMH],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(3),m3h1x16(:,30),heltab2x16(:,:,30))
  Gcoeff(:)%j = (c(62)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(31),h0tab(:,31),[16,2,1,4,8],[nMZ,nMT,nMH,nMB,nMZ],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(4),m3h1x16(:,31),heltab2x16(:,:,31))
  Gcoeff(:)%j = (c(62)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(32),h0tab(:,32),[16,2,1,4,8],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(5),m3h1x16(:,32),heltab2x16(:,:,32))
  Gcoeff(:)%j = (c(17)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(33),h0tab(:,33),[16,2,1,4,8],[nMW,nMB,nMW,nMT,nMW],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(6),m3h1x16(:,33),heltab2x16(:,:,33))
  Gcoeff(:)%j = (-(c(171)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(34),h0tab(:,34),[16,2,1,4,8],[nMZ,nMT,nMH,nMB,nMZ],5,0)
  call Hloop_VT_S(ntryL,G0H16(1),0,ex5(:),16,G1H16(29),m3h1x16(:,34),heltab2x16(:,:,34))
  Gcoeff(:)%j = (-(c(171)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(35),h0tab(:,35),[16,2,1,4,8],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_VT_S(ntryL,G0H16(1),0,ex5(:),16,G1H16(30),m3h1x16(:,35),heltab2x16(:,:,35))
  Gcoeff(:)%j = (c(74)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(36),h0tab(:,36),[16,2,1,4,8],[nMW,nMB,nMW,nMT,nMW],5,0)
  call Hloop_VT_S(ntryL,G0H16(1),0,ex5(:),16,G1H16(31),m3h1x16(:,36),heltab2x16(:,:,36))
  Gcoeff(:)%j = (c(165)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(37),h0tab(:,37),[16,2,1,4,8],[nMZ,nMT,nMH,nMB,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(1),0,ex5(:),16,G1H16(32),m3h1x16(:,37),heltab2x16(:,:,37))
  Gcoeff(:)%j = (c(165)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(38),h0tab(:,38),[16,2,1,4,8],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(1),0,ex5(:),16,G1H16(33),m3h1x16(:,38),heltab2x16(:,:,38))
  Gcoeff(:)%j = (c(74)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(39),h0tab(:,39),[16,2,1,4,8],[nMW,nMB,nMW,nMT,nMW],5,0)
  call Hloop_ST_V(ntryL,G0H16(1),0,ex5(:),16,G1H16(34),m3h1x16(:,39),heltab2x16(:,:,39))
  Gcoeff(:)%j = (c(283)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(40),h0tab(:,40),[16,2,1,4,8],[nMH,nMT,0,nMB,nMH],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(7),m3h1x16(:,40),heltab2x16(:,:,40))
  Gcoeff(:)%j = (c(274)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(41),h0tab(:,41),[16,2,1,4,8],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(8),m3h1x16(:,41),heltab2x16(:,:,41))
  Gcoeff(:)%j = (-(c(285)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(42),h0tab(:,42),[16,2,1,4,8],[nMH,nMT,nMZ,nMB,nMH],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(9),m3h1x16(:,42),heltab2x16(:,:,42))
  Gcoeff(:)%j = (-(c(278)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(43),h0tab(:,43),[16,2,1,4,8],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(10),m3h1x16(:,43),heltab2x16(:,:,43))
  Gcoeff(:)%j = (c(80)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(44),h0tab(:,44),[16,2,1,4,8],[nMW,nMB,nMW,nMT,nMW],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(11),m3h1x16(:,44),heltab2x16(:,:,44))
  Gcoeff(:)%j = (-(c(287)*M(2,:)%j)+c(286)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(45),h0tab(:,45),[16,2,1,4,8],[nMH,nMT,0,nMB,nMH],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(12),m3h1x16(:,45),heltab2x16(:,:,45))
  Gcoeff(:)%j = (-(c(280)*M(2,:)%j)+c(279)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(46),h0tab(:,46),[16,2,1,4,8],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(13),m3h1x16(:,46),heltab2x16(:,:,46))
  Gcoeff(:)%j = (-(c(363)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(47),h0tab(:,47),[16,2,1,4,8],[nMZ,nMT,nMH,nMB,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(14),m3h1x16(:,47),heltab2x16(:,:,47))
  Gcoeff(:)%j = (-(c(363)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(48),h0tab(:,48),[16,2,1,4,8],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(15),m3h1x16(:,48),heltab2x16(:,:,48))
  Gcoeff(:)%j = (c(111)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(49),h0tab(:,49),[16,2,1,4,8],[nMW,nMB,nMW,nMT,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(16),m3h1x16(:,49),heltab2x16(:,:,49))
  Gcoeff(:)%j = (-(c(419)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(50),h0tab(:,50),[16,2,1,4,8],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_VT_S(ntryL,G0H16(1),0,ex5(:),16,G1H16(35),m3h1x16(:,50),heltab2x16(:,:,50))
  Gcoeff(:)%j = (c(422)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(51),h0tab(:,51),[16,2,1,4,8],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_VT_S(ntryL,G0H16(1),0,ex5(:),16,G1H16(36),m3h1x16(:,51),heltab2x16(:,:,51))
  Gcoeff(:)%j = (c(110)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(52),h0tab(:,52),[16,2,1,4,8],[nMW,nMB,nMW,nMT,nMW],5,0)
  call Hloop_VT_S(ntryL,G0H16(1),0,ex5(:),16,G1H16(37),m3h1x16(:,52),heltab2x16(:,:,52))
  Gcoeff(:)%j = (c(426)*M(2,:)%j-c(425)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(53),h0tab(:,53),[16,2,1,4,8],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_VT_S(ntryL,G0H16(1),0,ex5(:),16,G1H16(38),m3h1x16(:,53),heltab2x16(:,:,53))
  Gcoeff(:)%j = (c(405)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(54),h0tab(:,54),[16,2,1,4,8],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(1),0,ex5(:),16,G1H16(39),m3h1x16(:,54),heltab2x16(:,:,54))
  Gcoeff(:)%j = (-(c(408)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(55),h0tab(:,55),[16,2,1,4,8],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(1),0,ex5(:),16,G1H16(40),m3h1x16(:,55),heltab2x16(:,:,55))
  Gcoeff(:)%j = (c(110)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(56),h0tab(:,56),[16,2,1,4,8],[nMW,nMB,nMW,nMT,nMW],5,0)
  call Hloop_ST_V(ntryL,G0H16(1),0,ex5(:),16,G1H16(41),m3h1x16(:,56),heltab2x16(:,:,56))
  Gcoeff(:)%j = (-(c(412)*M(2,:)%j)+c(411)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(57),h0tab(:,57),[16,2,1,4,8],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(1),0,ex5(:),16,G1H16(42),m3h1x16(:,57),heltab2x16(:,:,57))
  Gcoeff(:)%j = (-(c(491)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(58),h0tab(:,58),[16,2,1,4,8],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(17),m3h1x16(:,58),heltab2x16(:,:,58))
  Gcoeff(:)%j = (c(495)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(59),h0tab(:,59),[16,2,1,4,8],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(18),m3h1x16(:,59),heltab2x16(:,:,59))
  Gcoeff(:)%j = (c(144)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(60),h0tab(:,60),[16,2,1,4,8],[nMW,nMB,nMW,nMT,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(19),m3h1x16(:,60),heltab2x16(:,:,60))
  Gcoeff(:)%j = (c(497)*M(2,:)%j-c(496)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(61),h0tab(:,61),[16,2,1,4,8],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(20),m3h1x16(:,61),heltab2x16(:,:,61))
  Gcoeff(:)%j = (c(57)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(62),h0tab(:,62),[16,4,2,1,8],[nMB,nMH,nMT,nMH,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(21),ngH,m3h1x16(:,62),heltab2x16(:,:,62))
  call Hloop_A_Q(ntryL,G0H16(21),16,nMB,G1H16(43),n2h16(29))
  Gcoeff(:)%j = (c(57)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(63),h0tab(:,63),[16,4,2,1,8],[nMB,nMZ,nMT,nMH,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(21),ngH,m3h1x16(:,63),heltab2x16(:,:,63))
  call Hloop_A_Q(ntryL,G0H16(21),16,nMB,G1H16(44),n2h16(30))
  Gcoeff(:)%j = (c(57)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(64),h0tab(:,64),[16,4,2,1,8],[nMB,nMH,nMT,nMZ,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(21),ngH,m3h1x16(:,64),heltab2x16(:,:,64))
  call Hloop_A_Q(ntryL,G0H16(21),16,nMB,G1H16(45),n2h16(31))
  Gcoeff(:)%j = (c(57)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(65),h0tab(:,65),[16,4,2,1,8],[nMB,nMZ,nMT,nMZ,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(21),ngH,m3h1x16(:,65),heltab2x16(:,:,65))
  call Hloop_A_Q(ntryL,G0H16(21),16,nMB,G1H16(46),n2h16(32))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(66),h0tab(:,66),[16,4,2,1,8],[nMH,nMB,nMW,nMB,nMH],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(21),m3h1x16(:,66),heltab2x16(:,:,66))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(67),h0tab(:,67),[16,4,2,1,8],[nMZ,nMB,nMW,nMB,nMZ],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(22),m3h1x16(:,67),heltab2x16(:,:,67))
  Gcoeff(:)%j = (c(58)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(68),h0tab(:,68),[16,4,2,1,8],[nMW,nMT,nMH,nMT,nMW],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(23),m3h1x16(:,68),heltab2x16(:,:,68))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(69),h0tab(:,69),[16,4,2,1,8],[nMW,nMT,nMZ,nMT,nMW],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(24),m3h1x16(:,69),heltab2x16(:,:,69))
  Gcoeff(:)%j = (c(266)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(70),h0tab(:,70),[16,4,2,1,8],[nMB,0,nMT,nMH,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(25),ngH,m3h1x16(:,70),heltab2x16(:,:,70))
  call Hloop_A_Q(ntryL,G0H16(25),16,nMB,G1H16(47),n2h16(33))
  Gcoeff(:)%j = (c(266)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(71),h0tab(:,71),[16,4,2,1,8],[nMB,0,nMT,nMZ,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(25),ngH,m3h1x16(:,71),heltab2x16(:,:,71))
  call Hloop_A_Q(ntryL,G0H16(25),16,nMB,G1H16(48),n2h16(34))
  Gcoeff(:)%j = (-(c(268)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(72),h0tab(:,72),[16,4,2,1,8],[nMB,nMZ,nMT,nMH,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(25),ngH,m3h1x16(:,72),heltab2x16(:,:,72))
  call Hloop_A_Q(ntryL,G0H16(25),16,nMB,G1H16(49),n2h16(35))
  Gcoeff(:)%j = (-(c(268)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(73),h0tab(:,73),[16,4,2,1,8],[nMB,nMZ,nMT,nMZ,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(25),ngH,m3h1x16(:,73),heltab2x16(:,:,73))
  call Hloop_A_Q(ntryL,G0H16(25),16,nMB,G1H16(50),n2h16(36))
  Gcoeff(:)%j = (-(c(270)*M(2,:)%j)+c(269)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(74),h0tab(:,74),[16,4,2,1,8],[nMB,0,nMT,nMH,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(25),ngH,m3h1x16(:,74),heltab2x16(:,:,74))
  call Hloop_A_Q(ntryL,G0H16(25),16,nMB,G1H16(51),n2h16(37))
  Gcoeff(:)%j = (-(c(270)*M(2,:)%j)+c(269)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(75),h0tab(:,75),[16,4,2,1,8],[nMB,0,nMT,nMZ,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(25),ngH,m3h1x16(:,75),heltab2x16(:,:,75))
  call Hloop_A_Q(ntryL,G0H16(25),16,nMB,G1H16(52),n2h16(38))
  Gcoeff(:)%j = (c(266)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(76),h0tab(:,76),[16,4,2,1,8],[nMB,nMH,nMT,0,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(25),ngH,m3h1x16(:,76),heltab2x16(:,:,76))
  call Hloop_A_Q(ntryL,G0H16(25),16,nMB,G1H16(53),n2h16(39))
  Gcoeff(:)%j = (c(266)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(77),h0tab(:,77),[16,4,2,1,8],[nMB,nMZ,nMT,0,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(25),ngH,m3h1x16(:,77),heltab2x16(:,:,77))
  call Hloop_A_Q(ntryL,G0H16(25),16,nMB,G1H16(54),n2h16(40))
  Gcoeff(:)%j = (-(c(268)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(78),h0tab(:,78),[16,4,2,1,8],[nMB,nMH,nMT,nMZ,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(25),ngH,m3h1x16(:,78),heltab2x16(:,:,78))
  call Hloop_A_Q(ntryL,G0H16(25),16,nMB,G1H16(55),n2h16(41))
  Gcoeff(:)%j = (-(c(268)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(79),h0tab(:,79),[16,4,2,1,8],[nMB,nMZ,nMT,nMZ,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(25),ngH,m3h1x16(:,79),heltab2x16(:,:,79))
  call Hloop_A_Q(ntryL,G0H16(25),16,nMB,G1H16(56),n2h16(42))
  Gcoeff(:)%j = (-(c(270)*M(2,:)%j)+c(269)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(80),h0tab(:,80),[16,4,2,1,8],[nMB,nMH,nMT,0,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(25),ngH,m3h1x16(:,80),heltab2x16(:,:,80))
  call Hloop_A_Q(ntryL,G0H16(25),16,nMB,G1H16(57),n2h16(43))
  Gcoeff(:)%j = (-(c(270)*M(2,:)%j)+c(269)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(81),h0tab(:,81),[16,4,2,1,8],[nMB,nMZ,nMT,0,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(25),ngH,m3h1x16(:,81),heltab2x16(:,:,81))
  call Hloop_A_Q(ntryL,G0H16(25),16,nMB,G1H16(58),n2h16(44))
  Gcoeff(:)%j = (c(157)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(82),h0tab(:,82),[16,4,2,1,8],[nMZ,nMB,nMW,nMB,nMZ],5,0)
  call Hloop_VT_S(ntryL,G0H16(1),0,ex5(:),16,G1H16(59),m3h1x16(:,82),heltab2x16(:,:,82))
  Gcoeff(:)%j = (c(102)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(25),m0h(83),h0tab(:,83),[16,4,2,1,8],[nMW,nMT,nMH,nMT,nMW],5,0)
  call Hloop_VT_S(ntryL,G0H16(25),0,ex5(:),16,G1H16(60),m3h1x16(:,83),heltab2x16(:,:,83))
  Gcoeff(:)%j = (-(c(102)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(84),h0tab(:,84),[16,4,2,1,8],[nMW,nMT,nMZ,nMT,nMW],5,0)
  call Hloop_VT_S(ntryL,G0H16(1),0,ex5(:),16,G1H16(61),m3h1x16(:,84),heltab2x16(:,:,84))
  Gcoeff(:)%j = (c(157)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(25),m0h(85),h0tab(:,85),[16,4,2,1,8],[nMZ,nMB,nMW,nMB,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(25),0,ex5(:),16,G1H16(62),m3h1x16(:,85),heltab2x16(:,:,85))
  Gcoeff(:)%j = (c(102)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(86),h0tab(:,86),[16,4,2,1,8],[nMW,nMT,nMH,nMT,nMW],5,0)
  call Hloop_ST_V(ntryL,G0H16(1),0,ex5(:),16,G1H16(63),m3h1x16(:,86),heltab2x16(:,:,86))
  Gcoeff(:)%j = (-(c(102)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(25),m0h(87),h0tab(:,87),[16,4,2,1,8],[nMW,nMT,nMZ,nMT,nMW],5,0)
  call Hloop_ST_V(ntryL,G0H16(25),0,ex5(:),16,G1H16(64),m3h1x16(:,87),heltab2x16(:,:,87))
  Gcoeff(:)%j = (-(c(238)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(88),h0tab(:,88),[16,4,2,1,8],[nMW,nMT,0,nMT,nMW],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(25),m3h1x16(:,88),heltab2x16(:,:,88))
  Gcoeff(:)%j = (-(c(240)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(89),h0tab(:,89),[16,4,2,1,8],[nMW,nMT,nMZ,nMT,nMW],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(26),m3h1x16(:,89),heltab2x16(:,:,89))
  Gcoeff(:)%j = (c(85)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(90),h0tab(:,90),[16,4,2,1,8],[nMH,nMB,nMW,nMB,nMH],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(27),m3h1x16(:,90),heltab2x16(:,:,90))
  Gcoeff(:)%j = (-(c(84)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(91),h0tab(:,91),[16,4,2,1,8],[nMZ,nMB,nMW,nMB,nMZ],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(28),m3h1x16(:,91),heltab2x16(:,:,91))
  Gcoeff(:)%j = (c(241)*M(2,:)%j-c(242)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(92),h0tab(:,92),[16,4,2,1,8],[nMW,nMT,0,nMT,nMW],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(29),m3h1x16(:,92),heltab2x16(:,:,92))
  Gcoeff(:)%j = (c(448)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(93),h0tab(:,93),[16,4,2,1,8],[nMB,0,nMT,0,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(30),ngH,m3h1x16(:,93),heltab2x16(:,:,93))
  call Hloop_A_Q(ntryL,G0H16(30),16,nMB,G1H16(65),n2h16(45))
  Gcoeff(:)%j = (-(c(451)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(94),h0tab(:,94),[16,4,2,1,8],[nMB,nMZ,nMT,0,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(30),ngH,m3h1x16(:,94),heltab2x16(:,:,94))
  call Hloop_A_Q(ntryL,G0H16(30),16,nMB,G1H16(66),n2h16(46))
  Gcoeff(:)%j = (-(c(451)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(95),h0tab(:,95),[16,4,2,1,8],[nMB,0,nMT,nMZ,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(30),ngH,m3h1x16(:,95),heltab2x16(:,:,95))
  call Hloop_A_Q(ntryL,G0H16(30),16,nMB,G1H16(67),n2h16(47))
  Gcoeff(:)%j = (c(453)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(96),h0tab(:,96),[16,4,2,1,8],[nMB,nMZ,nMT,nMZ,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(30),ngH,m3h1x16(:,96),heltab2x16(:,:,96))
  call Hloop_A_Q(ntryL,G0H16(30),16,nMB,G1H16(68),n2h16(48))
  Gcoeff(:)%j = (-(c(458)*M(2,:)%j)+c(457)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(97),h0tab(:,97),[16,4,2,1,8],[nMB,0,nMT,0,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(30),ngH,m3h1x16(:,97),heltab2x16(:,:,97))
  call Hloop_A_Q(ntryL,G0H16(30),16,nMB,G1H16(69),n2h16(49))
  Gcoeff(:)%j = (-(c(458)*M(2,:)%j)+c(457)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(98),h0tab(:,98),[16,4,2,1,8],[nMB,0,nMT,0,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(30),ngH,m3h1x16(:,98),heltab2x16(:,:,98))
  call Hloop_A_Q(ntryL,G0H16(30),16,nMB,G1H16(70),n2h16(50))
  Gcoeff(:)%j = (c(463)*M(2,:)%j-c(462)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(99),h0tab(:,99),[16,4,2,1,8],[nMB,0,nMT,nMZ,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(30),ngH,m3h1x16(:,99),heltab2x16(:,:,99))
  call Hloop_A_Q(ntryL,G0H16(30),16,nMB,G1H16(71),n2h16(51))
  Gcoeff(:)%j = (c(463)*M(2,:)%j-c(462)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(100),h0tab(:,100),[16,4,2,1,8],[nMB,nMZ,nMT,0,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(30),ngH,m3h1x16(:,100),heltab2x16(:,:,100))
  call Hloop_A_Q(ntryL,G0H16(30),16,nMB,G1H16(72),n2h16(52))
  Gcoeff(:)%j = (-(c(318)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(101),h0tab(:,101),[16,4,2,1,8],[nMZ,nMB,nMW,nMB,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(30),m3h1x16(:,101),heltab2x16(:,:,101))
  Gcoeff(:)%j = (c(138)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(102),h0tab(:,102),[16,4,2,1,8],[nMW,nMT,nMH,nMT,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(31),m3h1x16(:,102),heltab2x16(:,:,102))
  Gcoeff(:)%j = (-(c(138)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(103),h0tab(:,103),[16,4,2,1,8],[nMW,nMT,nMZ,nMT,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(32),m3h1x16(:,103),heltab2x16(:,:,103))
  Gcoeff(:)%j = (-(c(314)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(104),h0tab(:,104),[16,4,2,1,8],[nMW,nMT,0,nMT,nMW],5,0)
  call Hloop_VT_S(ntryL,G0H16(1),0,ex5(:),16,G1H16(73),m3h1x16(:,104),heltab2x16(:,:,104))
  Gcoeff(:)%j = (c(180)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(105),h0tab(:,105),[16,4,2,1,8],[nMZ,nMB,nMW,nMB,nMZ],5,0)
  call Hloop_VT_S(ntryL,G0H16(1),0,ex5(:),16,G1H16(74),m3h1x16(:,105),heltab2x16(:,:,105))
  Gcoeff(:)%j = (-(c(316)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(106),h0tab(:,106),[16,4,2,1,8],[nMW,nMT,nMZ,nMT,nMW],5,0)
  call Hloop_VT_S(ntryL,G0H16(1),0,ex5(:),16,G1H16(75),m3h1x16(:,106),heltab2x16(:,:,106))
  Gcoeff(:)%j = (c(319)*M(2,:)%j-c(320)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(107),h0tab(:,107),[16,4,2,1,8],[nMW,nMT,0,nMT,nMW],5,0)
  call Hloop_VT_S(ntryL,G0H16(1),0,ex5(:),16,G1H16(76),m3h1x16(:,107),heltab2x16(:,:,107))
  Gcoeff(:)%j = (-(c(314)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(108),h0tab(:,108),[16,4,2,1,8],[nMW,nMT,0,nMT,nMW],5,0)
  call Hloop_ST_V(ntryL,G0H16(1),0,ex5(:),16,G1H16(77),m3h1x16(:,108),heltab2x16(:,:,108))
  Gcoeff(:)%j = (c(180)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(109),h0tab(:,109),[16,4,2,1,8],[nMZ,nMB,nMW,nMB,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(1),0,ex5(:),16,G1H16(78),m3h1x16(:,109),heltab2x16(:,:,109))
  Gcoeff(:)%j = (-(c(316)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(110),h0tab(:,110),[16,4,2,1,8],[nMW,nMT,nMZ,nMT,nMW],5,0)
  call Hloop_ST_V(ntryL,G0H16(1),0,ex5(:),16,G1H16(79),m3h1x16(:,110),heltab2x16(:,:,110))
  Gcoeff(:)%j = (c(319)*M(2,:)%j-c(320)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(111),h0tab(:,111),[16,4,2,1,8],[nMW,nMT,0,nMT,nMW],5,0)
  call Hloop_ST_V(ntryL,G0H16(1),0,ex5(:),16,G1H16(80),m3h1x16(:,111),heltab2x16(:,:,111))
  Gcoeff(:)%j = (-(c(383)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(112),h0tab(:,112),[16,4,2,1,8],[nMZ,nMB,nMW,nMB,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(33),m3h1x16(:,112),heltab2x16(:,:,112))
  Gcoeff(:)%j = (-(c(375)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(113),h0tab(:,113),[16,4,2,1,8],[nMW,nMT,0,nMT,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(34),m3h1x16(:,113),heltab2x16(:,:,113))
  Gcoeff(:)%j = (-(c(378)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(114),h0tab(:,114),[16,4,2,1,8],[nMW,nMT,nMZ,nMT,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(35),m3h1x16(:,114),heltab2x16(:,:,114))
  Gcoeff(:)%j = (c(386)*M(2,:)%j-c(387)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(115),h0tab(:,115),[16,4,2,1,8],[nMW,nMT,0,nMT,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(36),m3h1x16(:,115),heltab2x16(:,:,115))
  Gcoeff(:)%j = (c(69)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(116),h0tab(:,116),[16,2,1,8,4],[nMT,nMH,nMT,nMW,nMT],5,0)
  call Hloop_QS_A(ntryL,G0H16(1),ex5(:),G0H16(37),ngH,m3h1x16(:,116),heltab2x16(:,:,116))
  call Hloop_Q_A(ntryL,G0H16(37),16,nMT,G1H16(81),n2h16(53))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(117),h0tab(:,117),[16,2,1,8,4],[nMB,nMW,nMB,nMH,nMB],5,0)
  call Hloop_QS_A(ntryL,G0H16(1),ex5(:),G0H16(37),ngH,m3h1x16(:,117),heltab2x16(:,:,117))
  call Hloop_Q_A(ntryL,G0H16(37),16,nMB,G1H16(82),n2h16(54))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(118),h0tab(:,118),[16,2,1,8,4],[nMT,nMZ,nMT,nMW,nMT],5,0)
  call Hloop_QS_A(ntryL,G0H16(1),ex5(:),G0H16(37),ngH,m3h1x16(:,118),heltab2x16(:,:,118))
  call Hloop_Q_A(ntryL,G0H16(37),16,nMT,G1H16(83),n2h16(55))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(119),h0tab(:,119),[16,2,1,8,4],[nMB,nMW,nMB,nMZ,nMB],5,0)
  call Hloop_QS_A(ntryL,G0H16(1),ex5(:),G0H16(37),ngH,m3h1x16(:,119),heltab2x16(:,:,119))
  call Hloop_Q_A(ntryL,G0H16(37),16,nMB,G1H16(84),n2h16(56))
  Gcoeff(:)%j = (c(63)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(120),h0tab(:,120),[16,2,1,8,4],[nMH,nMT,nMH,nMB,nMH],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(37),m3h1x16(:,120),heltab2x16(:,:,120))
  Gcoeff(:)%j = (c(63)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(121),h0tab(:,121),[16,2,1,8,4],[nMH,nMT,nMZ,nMB,nMH],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(38),m3h1x16(:,121),heltab2x16(:,:,121))
  Gcoeff(:)%j = (c(62)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(122),h0tab(:,122),[16,2,1,8,4],[nMZ,nMT,nMH,nMB,nMZ],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(39),m3h1x16(:,122),heltab2x16(:,:,122))
  Gcoeff(:)%j = (c(62)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(123),h0tab(:,123),[16,2,1,8,4],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(40),m3h1x16(:,123),heltab2x16(:,:,123))
  Gcoeff(:)%j = (-(c(222)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(124),h0tab(:,124),[16,2,1,8,4],[nMB,nMW,nMB,0,nMB],5,0)
  call Hloop_QS_A(ntryL,G0H16(1),ex5(:),G0H16(41),ngH,m3h1x16(:,124),heltab2x16(:,:,124))
  call Hloop_Q_A(ntryL,G0H16(41),16,nMB,G1H16(85),n2h16(57))
  Gcoeff(:)%j = (-(c(227)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(125),h0tab(:,125),[16,2,1,8,4],[nMB,nMW,nMB,nMZ,nMB],5,0)
  call Hloop_QS_A(ntryL,G0H16(1),ex5(:),G0H16(41),ngH,m3h1x16(:,125),heltab2x16(:,:,125))
  call Hloop_Q_A(ntryL,G0H16(41),16,nMB,G1H16(86),n2h16(58))
  Gcoeff(:)%j = (c(108)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(126),h0tab(:,126),[16,2,1,8,4],[nMT,nMH,nMT,nMW,nMT],5,0)
  call Hloop_QS_A(ntryL,G0H16(1),ex5(:),G0H16(41),ngH,m3h1x16(:,126),heltab2x16(:,:,126))
  call Hloop_Q_A(ntryL,G0H16(41),16,nMT,G1H16(87),n2h16(59))
  Gcoeff(:)%j = (-(c(108)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(127),h0tab(:,127),[16,2,1,8,4],[nMT,nMZ,nMT,nMW,nMT],5,0)
  call Hloop_QS_A(ntryL,G0H16(1),ex5(:),G0H16(41),ngH,m3h1x16(:,127),heltab2x16(:,:,127))
  call Hloop_Q_A(ntryL,G0H16(41),16,nMT,G1H16(88),n2h16(60))
  Gcoeff(:)%j = (c(228)*M(2,:)%j-c(229)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(128),h0tab(:,128),[16,2,1,8,4],[nMB,nMW,nMB,0,nMB],5,0)
  call Hloop_QS_A(ntryL,G0H16(1),ex5(:),G0H16(41),ngH,m3h1x16(:,128),heltab2x16(:,:,128))
  call Hloop_Q_A(ntryL,G0H16(41),16,nMB,G1H16(89),n2h16(61))
  Gcoeff(:)%j = (-(c(259)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(129),h0tab(:,129),[16,2,1,8,4],[nMT,0,nMT,nMW,nMT],5,0)
  call Hloop_QS_A(ntryL,G0H16(1),ex5(:),G0H16(41),ngH,m3h1x16(:,129),heltab2x16(:,:,129))
  call Hloop_Q_A(ntryL,G0H16(41),16,nMT,G1H16(90),n2h16(62))
  Gcoeff(:)%j = (-(c(261)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(130),h0tab(:,130),[16,2,1,8,4],[nMT,nMZ,nMT,nMW,nMT],5,0)
  call Hloop_QS_A(ntryL,G0H16(1),ex5(:),G0H16(41),ngH,m3h1x16(:,130),heltab2x16(:,:,130))
  call Hloop_Q_A(ntryL,G0H16(41),16,nMT,G1H16(91),n2h16(63))
  Gcoeff(:)%j = (c(78)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(131),h0tab(:,131),[16,2,1,8,4],[nMB,nMW,nMB,nMH,nMB],5,0)
  call Hloop_QS_A(ntryL,G0H16(1),ex5(:),G0H16(41),ngH,m3h1x16(:,131),heltab2x16(:,:,131))
  call Hloop_Q_A(ntryL,G0H16(41),16,nMB,G1H16(92),n2h16(64))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(132),h0tab(:,132),[16,2,1,8,4],[nMB,nMW,nMB,nMZ,nMB],5,0)
  call Hloop_QS_A(ntryL,G0H16(1),ex5(:),G0H16(41),ngH,m3h1x16(:,132),heltab2x16(:,:,132))
  call Hloop_Q_A(ntryL,G0H16(41),16,nMB,G1H16(93),n2h16(65))
  Gcoeff(:)%j = (c(262)*M(2,:)%j-c(263)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(133),h0tab(:,133),[16,2,1,8,4],[nMT,0,nMT,nMW,nMT],5,0)
  call Hloop_QS_A(ntryL,G0H16(1),ex5(:),G0H16(41),ngH,m3h1x16(:,133),heltab2x16(:,:,133))
  call Hloop_Q_A(ntryL,G0H16(41),16,nMT,G1H16(94),n2h16(66))
  Gcoeff(:)%j = (-(c(171)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(134),h0tab(:,134),[16,2,1,8,4],[nMZ,nMT,nMH,nMB,nMZ],5,0)
  call Hloop_VT_S(ntryL,G0H16(1),0,ex5(:),16,G1H16(95),m3h1x16(:,134),heltab2x16(:,:,134))
  Gcoeff(:)%j = (-(c(171)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(41),m0h(135),h0tab(:,135),[16,2,1,8,4],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_VT_S(ntryL,G0H16(41),0,ex5(:),16,G1H16(96),m3h1x16(:,135),heltab2x16(:,:,135))
  Gcoeff(:)%j = (c(165)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(136),h0tab(:,136),[16,2,1,8,4],[nMZ,nMT,nMH,nMB,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(1),0,ex5(:),16,G1H16(97),m3h1x16(:,136),heltab2x16(:,:,136))
  Gcoeff(:)%j = (c(165)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(41),m0h(137),h0tab(:,137),[16,2,1,8,4],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(41),0,ex5(:),16,G1H16(98),m3h1x16(:,137),heltab2x16(:,:,137))
  Gcoeff(:)%j = (c(283)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(138),h0tab(:,138),[16,2,1,8,4],[nMH,nMT,0,nMB,nMH],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(41),m3h1x16(:,138),heltab2x16(:,:,138))
  Gcoeff(:)%j = (c(274)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(139),h0tab(:,139),[16,2,1,8,4],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(42),m3h1x16(:,139),heltab2x16(:,:,139))
  Gcoeff(:)%j = (-(c(285)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(140),h0tab(:,140),[16,2,1,8,4],[nMH,nMT,nMZ,nMB,nMH],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(43),m3h1x16(:,140),heltab2x16(:,:,140))
  Gcoeff(:)%j = (-(c(278)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(141),h0tab(:,141),[16,2,1,8,4],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(44),m3h1x16(:,141),heltab2x16(:,:,141))
  Gcoeff(:)%j = (-(c(287)*M(2,:)%j)+c(286)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(142),h0tab(:,142),[16,2,1,8,4],[nMH,nMT,0,nMB,nMH],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(45),m3h1x16(:,142),heltab2x16(:,:,142))
  Gcoeff(:)%j = (-(c(280)*M(2,:)%j)+c(279)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(143),h0tab(:,143),[16,2,1,8,4],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(46),m3h1x16(:,143),heltab2x16(:,:,143))
  Gcoeff(:)%j = (-(c(350)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(144),h0tab(:,144),[16,2,1,8,4],[nMT,0,nMT,nMW,nMT],5,0)
  call Hloop_QS_A(ntryL,G0H16(1),ex5(:),G0H16(47),ngH,m3h1x16(:,144),heltab2x16(:,:,144))
  call Hloop_Q_A(ntryL,G0H16(47),16,nMT,G1H16(99),n2h16(67))
  Gcoeff(:)%j = (-(c(322)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(145),h0tab(:,145),[16,2,1,8,4],[nMB,nMW,nMB,0,nMB],5,0)
  call Hloop_QS_A(ntryL,G0H16(1),ex5(:),G0H16(47),ngH,m3h1x16(:,145),heltab2x16(:,:,145))
  call Hloop_Q_A(ntryL,G0H16(47),16,nMB,G1H16(100),n2h16(68))
  Gcoeff(:)%j = (-(c(352)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(146),h0tab(:,146),[16,2,1,8,4],[nMT,nMZ,nMT,nMW,nMT],5,0)
  call Hloop_QS_A(ntryL,G0H16(1),ex5(:),G0H16(47),ngH,m3h1x16(:,146),heltab2x16(:,:,146))
  call Hloop_Q_A(ntryL,G0H16(47),16,nMT,G1H16(101),n2h16(69))
  Gcoeff(:)%j = (-(c(327)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(147),h0tab(:,147),[16,2,1,8,4],[nMB,nMW,nMB,nMZ,nMB],5,0)
  call Hloop_QS_A(ntryL,G0H16(1),ex5(:),G0H16(47),ngH,m3h1x16(:,147),heltab2x16(:,:,147))
  call Hloop_Q_A(ntryL,G0H16(47),16,nMB,G1H16(102),n2h16(70))
  Gcoeff(:)%j = (c(356)*M(2,:)%j-c(357)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(148),h0tab(:,148),[16,2,1,8,4],[nMT,0,nMT,nMW,nMT],5,0)
  call Hloop_QS_A(ntryL,G0H16(1),ex5(:),G0H16(47),ngH,m3h1x16(:,148),heltab2x16(:,:,148))
  call Hloop_Q_A(ntryL,G0H16(47),16,nMT,G1H16(103),n2h16(71))
  Gcoeff(:)%j = (c(331)*M(2,:)%j-c(332)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(149),h0tab(:,149),[16,2,1,8,4],[nMB,nMW,nMB,0,nMB],5,0)
  call Hloop_QS_A(ntryL,G0H16(1),ex5(:),G0H16(47),ngH,m3h1x16(:,149),heltab2x16(:,:,149))
  call Hloop_Q_A(ntryL,G0H16(47),16,nMB,G1H16(104),n2h16(72))
  Gcoeff(:)%j = (-(c(363)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(150),h0tab(:,150),[16,2,1,8,4],[nMZ,nMT,nMH,nMB,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(47),m3h1x16(:,150),heltab2x16(:,:,150))
  Gcoeff(:)%j = (-(c(363)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(151),h0tab(:,151),[16,2,1,8,4],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(48),m3h1x16(:,151),heltab2x16(:,:,151))
  Gcoeff(:)%j = (-(c(419)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(152),h0tab(:,152),[16,2,1,8,4],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_VT_S(ntryL,G0H16(1),0,ex5(:),16,G1H16(105),m3h1x16(:,152),heltab2x16(:,:,152))
  Gcoeff(:)%j = (c(422)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(153),h0tab(:,153),[16,2,1,8,4],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_VT_S(ntryL,G0H16(1),0,ex5(:),16,G1H16(106),m3h1x16(:,153),heltab2x16(:,:,153))
  Gcoeff(:)%j = (c(426)*M(2,:)%j-c(425)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(154),h0tab(:,154),[16,2,1,8,4],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_VT_S(ntryL,G0H16(1),0,ex5(:),16,G1H16(107),m3h1x16(:,154),heltab2x16(:,:,154))
  Gcoeff(:)%j = (c(405)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(155),h0tab(:,155),[16,2,1,8,4],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(1),0,ex5(:),16,G1H16(108),m3h1x16(:,155),heltab2x16(:,:,155))
  Gcoeff(:)%j = (-(c(408)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(156),h0tab(:,156),[16,2,1,8,4],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(1),0,ex5(:),16,G1H16(109),m3h1x16(:,156),heltab2x16(:,:,156))
  Gcoeff(:)%j = (-(c(412)*M(2,:)%j)+c(411)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(157),h0tab(:,157),[16,2,1,8,4],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(1),0,ex5(:),16,G1H16(110),m3h1x16(:,157),heltab2x16(:,:,157))
  Gcoeff(:)%j = (-(c(491)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(158),h0tab(:,158),[16,2,1,8,4],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(49),m3h1x16(:,158),heltab2x16(:,:,158))
  Gcoeff(:)%j = (c(495)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(159),h0tab(:,159),[16,2,1,8,4],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(50),m3h1x16(:,159),heltab2x16(:,:,159))
  Gcoeff(:)%j = (c(497)*M(2,:)%j-c(496)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(160),h0tab(:,160),[16,2,1,8,4],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(51),m3h1x16(:,160),heltab2x16(:,:,160))
  Gcoeff(:)%j = (c(69)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(161),h0tab(:,161),[16,1,2,4,8],[nMT,nMH,nMT,nMW,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(52),ngH,m3h1x16(:,161),heltab2x16(:,:,161))
  call Hloop_A_Q(ntryL,G0H16(52),16,nMT,G1H16(111),n2h16(73))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(162),h0tab(:,162),[16,1,2,4,8],[nMB,nMW,nMB,nMH,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(52),ngH,m3h1x16(:,162),heltab2x16(:,:,162))
  call Hloop_A_Q(ntryL,G0H16(52),16,nMB,G1H16(112),n2h16(74))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(163),h0tab(:,163),[16,1,2,4,8],[nMT,nMZ,nMT,nMW,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(52),ngH,m3h1x16(:,163),heltab2x16(:,:,163))
  call Hloop_A_Q(ntryL,G0H16(52),16,nMT,G1H16(113),n2h16(75))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(164),h0tab(:,164),[16,1,2,4,8],[nMB,nMW,nMB,nMZ,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(52),ngH,m3h1x16(:,164),heltab2x16(:,:,164))
  call Hloop_A_Q(ntryL,G0H16(52),16,nMB,G1H16(114),n2h16(76))
  Gcoeff(:)%j = (c(63)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(165),h0tab(:,165),[16,1,2,4,8],[nMH,nMT,nMH,nMB,nMH],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(52),m3h1x16(:,165),heltab2x16(:,:,165))
  Gcoeff(:)%j = (c(63)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(166),h0tab(:,166),[16,1,2,4,8],[nMH,nMT,nMZ,nMB,nMH],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(53),m3h1x16(:,166),heltab2x16(:,:,166))
  Gcoeff(:)%j = (c(62)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(167),h0tab(:,167),[16,1,2,4,8],[nMZ,nMT,nMH,nMB,nMZ],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(54),m3h1x16(:,167),heltab2x16(:,:,167))
  Gcoeff(:)%j = (c(62)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(168),h0tab(:,168),[16,1,2,4,8],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(55),m3h1x16(:,168),heltab2x16(:,:,168))
  Gcoeff(:)%j = (-(c(222)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(169),h0tab(:,169),[16,1,2,4,8],[nMB,nMW,nMB,0,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(56),ngH,m3h1x16(:,169),heltab2x16(:,:,169))
  call Hloop_A_Q(ntryL,G0H16(56),16,nMB,G1H16(115),n2h16(77))
  Gcoeff(:)%j = (-(c(227)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(170),h0tab(:,170),[16,1,2,4,8],[nMB,nMW,nMB,nMZ,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(56),ngH,m3h1x16(:,170),heltab2x16(:,:,170))
  call Hloop_A_Q(ntryL,G0H16(56),16,nMB,G1H16(116),n2h16(78))
  Gcoeff(:)%j = (c(108)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(171),h0tab(:,171),[16,1,2,4,8],[nMT,nMH,nMT,nMW,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(56),ngH,m3h1x16(:,171),heltab2x16(:,:,171))
  call Hloop_A_Q(ntryL,G0H16(56),16,nMT,G1H16(117),n2h16(79))
  Gcoeff(:)%j = (-(c(108)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(172),h0tab(:,172),[16,1,2,4,8],[nMT,nMZ,nMT,nMW,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(56),ngH,m3h1x16(:,172),heltab2x16(:,:,172))
  call Hloop_A_Q(ntryL,G0H16(56),16,nMT,G1H16(118),n2h16(80))
  Gcoeff(:)%j = (c(228)*M(2,:)%j-c(229)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(173),h0tab(:,173),[16,1,2,4,8],[nMB,nMW,nMB,0,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(56),ngH,m3h1x16(:,173),heltab2x16(:,:,173))
  call Hloop_A_Q(ntryL,G0H16(56),16,nMB,G1H16(119),n2h16(81))
  Gcoeff(:)%j = (-(c(259)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(174),h0tab(:,174),[16,1,2,4,8],[nMT,0,nMT,nMW,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(56),ngH,m3h1x16(:,174),heltab2x16(:,:,174))
  call Hloop_A_Q(ntryL,G0H16(56),16,nMT,G1H16(120),n2h16(82))
  Gcoeff(:)%j = (-(c(261)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(175),h0tab(:,175),[16,1,2,4,8],[nMT,nMZ,nMT,nMW,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(56),ngH,m3h1x16(:,175),heltab2x16(:,:,175))
  call Hloop_A_Q(ntryL,G0H16(56),16,nMT,G1H16(121),n2h16(83))
  Gcoeff(:)%j = (c(78)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(176),h0tab(:,176),[16,1,2,4,8],[nMB,nMW,nMB,nMH,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(56),ngH,m3h1x16(:,176),heltab2x16(:,:,176))
  call Hloop_A_Q(ntryL,G0H16(56),16,nMB,G1H16(122),n2h16(84))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(177),h0tab(:,177),[16,1,2,4,8],[nMB,nMW,nMB,nMZ,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(56),ngH,m3h1x16(:,177),heltab2x16(:,:,177))
  call Hloop_A_Q(ntryL,G0H16(56),16,nMB,G1H16(123),n2h16(85))
  Gcoeff(:)%j = (c(262)*M(2,:)%j-c(263)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(178),h0tab(:,178),[16,1,2,4,8],[nMT,0,nMT,nMW,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(56),ngH,m3h1x16(:,178),heltab2x16(:,:,178))
  call Hloop_A_Q(ntryL,G0H16(56),16,nMT,G1H16(124),n2h16(86))
  Gcoeff(:)%j = (-(c(171)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(179),h0tab(:,179),[16,1,2,4,8],[nMZ,nMT,nMH,nMB,nMZ],5,0)
  call Hloop_VT_S(ntryL,G0H16(1),0,ex5(:),16,G1H16(125),m3h1x16(:,179),heltab2x16(:,:,179))
  Gcoeff(:)%j = (-(c(171)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(56),m0h(180),h0tab(:,180),[16,1,2,4,8],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_VT_S(ntryL,G0H16(56),0,ex5(:),16,G1H16(126),m3h1x16(:,180),heltab2x16(:,:,180))
  Gcoeff(:)%j = (c(283)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(181),h0tab(:,181),[16,1,2,4,8],[nMH,nMT,0,nMB,nMH],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(56),m3h1x16(:,181),heltab2x16(:,:,181))
  Gcoeff(:)%j = (c(274)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(182),h0tab(:,182),[16,1,2,4,8],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(57),m3h1x16(:,182),heltab2x16(:,:,182))
  Gcoeff(:)%j = (-(c(285)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(183),h0tab(:,183),[16,1,2,4,8],[nMH,nMT,nMZ,nMB,nMH],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(58),m3h1x16(:,183),heltab2x16(:,:,183))
  Gcoeff(:)%j = (-(c(278)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(184),h0tab(:,184),[16,1,2,4,8],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(59),m3h1x16(:,184),heltab2x16(:,:,184))
  Gcoeff(:)%j = (-(c(287)*M(2,:)%j)+c(286)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(185),h0tab(:,185),[16,1,2,4,8],[nMH,nMT,0,nMB,nMH],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(60),m3h1x16(:,185),heltab2x16(:,:,185))
  Gcoeff(:)%j = (-(c(280)*M(2,:)%j)+c(279)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(186),h0tab(:,186),[16,1,2,4,8],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(61),m3h1x16(:,186),heltab2x16(:,:,186))
  Gcoeff(:)%j = (c(165)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(187),h0tab(:,187),[16,1,2,4,8],[nMZ,nMT,nMH,nMB,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(1),0,ex5(:),16,G1H16(127),m3h1x16(:,187),heltab2x16(:,:,187))
  Gcoeff(:)%j = (c(165)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(188),h0tab(:,188),[16,1,2,4,8],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(1),0,ex5(:),16,G1H16(128),m3h1x16(:,188),heltab2x16(:,:,188))
  Gcoeff(:)%j = (-(c(350)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(189),h0tab(:,189),[16,1,2,4,8],[nMT,0,nMT,nMW,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(62),ngH,m3h1x16(:,189),heltab2x16(:,:,189))
  call Hloop_A_Q(ntryL,G0H16(62),16,nMT,G1H16(129),n2h16(87))
  Gcoeff(:)%j = (-(c(322)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(190),h0tab(:,190),[16,1,2,4,8],[nMB,nMW,nMB,0,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(62),ngH,m3h1x16(:,190),heltab2x16(:,:,190))
  call Hloop_A_Q(ntryL,G0H16(62),16,nMB,G1H16(130),n2h16(88))
  Gcoeff(:)%j = (-(c(352)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(191),h0tab(:,191),[16,1,2,4,8],[nMT,nMZ,nMT,nMW,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(62),ngH,m3h1x16(:,191),heltab2x16(:,:,191))
  call Hloop_A_Q(ntryL,G0H16(62),16,nMT,G1H16(131),n2h16(89))
  Gcoeff(:)%j = (-(c(327)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(192),h0tab(:,192),[16,1,2,4,8],[nMB,nMW,nMB,nMZ,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(62),ngH,m3h1x16(:,192),heltab2x16(:,:,192))
  call Hloop_A_Q(ntryL,G0H16(62),16,nMB,G1H16(132),n2h16(90))
  Gcoeff(:)%j = (c(356)*M(2,:)%j-c(357)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(193),h0tab(:,193),[16,1,2,4,8],[nMT,0,nMT,nMW,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(62),ngH,m3h1x16(:,193),heltab2x16(:,:,193))
  call Hloop_A_Q(ntryL,G0H16(62),16,nMT,G1H16(133),n2h16(91))
  Gcoeff(:)%j = (c(331)*M(2,:)%j-c(332)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(194),h0tab(:,194),[16,1,2,4,8],[nMB,nMW,nMB,0,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(1),ex5(:),G0H16(62),ngH,m3h1x16(:,194),heltab2x16(:,:,194))
  call Hloop_A_Q(ntryL,G0H16(62),16,nMB,G1H16(134),n2h16(92))
  Gcoeff(:)%j = (-(c(419)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(195),h0tab(:,195),[16,1,2,4,8],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_VT_S(ntryL,G0H16(1),0,ex5(:),16,G1H16(135),m3h1x16(:,195),heltab2x16(:,:,195))
  Gcoeff(:)%j = (c(422)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(196),h0tab(:,196),[16,1,2,4,8],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_VT_S(ntryL,G0H16(62),0,ex5(:),16,G1H16(136),m3h1x16(:,196),heltab2x16(:,:,196))
  Gcoeff(:)%j = (c(426)*M(2,:)%j-c(425)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(197),h0tab(:,197),[16,1,2,4,8],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_VT_S(ntryL,G0H16(1),0,ex5(:),16,G1H16(137),m3h1x16(:,197),heltab2x16(:,:,197))
  Gcoeff(:)%j = (-(c(363)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(198),h0tab(:,198),[16,1,2,4,8],[nMZ,nMT,nMH,nMB,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(1),m3h1x16(:,198),heltab2x16(:,:,198))
  Gcoeff(:)%j = (-(c(363)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(199),h0tab(:,199),[16,1,2,4,8],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(63),m3h1x16(:,199),heltab2x16(:,:,199))
  Gcoeff(:)%j = (c(405)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(200),h0tab(:,200),[16,1,2,4,8],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(62),0,ex5(:),16,G1H16(138),m3h1x16(:,200),heltab2x16(:,:,200))
  Gcoeff(:)%j = (-(c(408)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(201),h0tab(:,201),[16,1,2,4,8],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(62),0,ex5(:),16,G1H16(139),m3h1x16(:,201),heltab2x16(:,:,201))
  Gcoeff(:)%j = (-(c(412)*M(2,:)%j)+c(411)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(202),h0tab(:,202),[16,1,2,4,8],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(62),0,ex5(:),16,G1H16(140),m3h1x16(:,202),heltab2x16(:,:,202))
  Gcoeff(:)%j = (-(c(491)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(203),h0tab(:,203),[16,1,2,4,8],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(64),m3h1x16(:,203),heltab2x16(:,:,203))
  Gcoeff(:)%j = (c(495)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(204),h0tab(:,204),[16,1,2,4,8],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(65),m3h1x16(:,204),heltab2x16(:,:,204))
  Gcoeff(:)%j = (c(497)*M(2,:)%j-c(496)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(205),h0tab(:,205),[16,1,2,4,8],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(66),m3h1x16(:,205),heltab2x16(:,:,205))
  Gcoeff(:)%j = (c(63)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(206),h0tab(:,206),[16,1,2,8,4],[nMH,nMT,nMH,nMB,nMH],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(67),m3h1x16(:,206),heltab2x16(:,:,206))
  Gcoeff(:)%j = (c(63)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(207),h0tab(:,207),[16,1,2,8,4],[nMH,nMT,nMZ,nMB,nMH],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(68),m3h1x16(:,207),heltab2x16(:,:,207))
  Gcoeff(:)%j = (c(62)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(208),h0tab(:,208),[16,1,2,8,4],[nMZ,nMT,nMH,nMB,nMZ],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(69),m3h1x16(:,208),heltab2x16(:,:,208))
  Gcoeff(:)%j = (c(62)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(209),h0tab(:,209),[16,1,2,8,4],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(70),m3h1x16(:,209),heltab2x16(:,:,209))
  Gcoeff(:)%j = (c(17)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(210),h0tab(:,210),[16,1,2,8,4],[nMW,nMB,nMW,nMT,nMW],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(71),m3h1x16(:,210),heltab2x16(:,:,210))
  Gcoeff(:)%j = (-(c(171)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(211),h0tab(:,211),[16,1,2,8,4],[nMZ,nMT,nMH,nMB,nMZ],5,0)
  call Hloop_VT_S(ntryL,G0H16(62),0,ex5(:),16,G1H16(141),m3h1x16(:,211),heltab2x16(:,:,211))
  Gcoeff(:)%j = (-(c(171)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(212),h0tab(:,212),[16,1,2,8,4],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_VT_S(ntryL,G0H16(62),0,ex5(:),16,G1H16(142),m3h1x16(:,212),heltab2x16(:,:,212))
  Gcoeff(:)%j = (c(74)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(213),h0tab(:,213),[16,1,2,8,4],[nMW,nMB,nMW,nMT,nMW],5,0)
  call Hloop_VT_S(ntryL,G0H16(62),0,ex5(:),16,G1H16(143),m3h1x16(:,213),heltab2x16(:,:,213))
  Gcoeff(:)%j = (c(283)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(214),h0tab(:,214),[16,1,2,8,4],[nMH,nMT,0,nMB,nMH],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(72),m3h1x16(:,214),heltab2x16(:,:,214))
  Gcoeff(:)%j = (c(274)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(215),h0tab(:,215),[16,1,2,8,4],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(73),m3h1x16(:,215),heltab2x16(:,:,215))
  Gcoeff(:)%j = (-(c(285)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(216),h0tab(:,216),[16,1,2,8,4],[nMH,nMT,nMZ,nMB,nMH],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(74),m3h1x16(:,216),heltab2x16(:,:,216))
  Gcoeff(:)%j = (-(c(278)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(217),h0tab(:,217),[16,1,2,8,4],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(75),m3h1x16(:,217),heltab2x16(:,:,217))
  Gcoeff(:)%j = (c(80)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(218),h0tab(:,218),[16,1,2,8,4],[nMW,nMB,nMW,nMT,nMW],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(76),m3h1x16(:,218),heltab2x16(:,:,218))
  Gcoeff(:)%j = (-(c(287)*M(2,:)%j)+c(286)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(219),h0tab(:,219),[16,1,2,8,4],[nMH,nMT,0,nMB,nMH],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(77),m3h1x16(:,219),heltab2x16(:,:,219))
  Gcoeff(:)%j = (-(c(280)*M(2,:)%j)+c(279)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(220),h0tab(:,220),[16,1,2,8,4],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(78),m3h1x16(:,220),heltab2x16(:,:,220))
  Gcoeff(:)%j = (c(165)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(221),h0tab(:,221),[16,1,2,8,4],[nMZ,nMT,nMH,nMB,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(62),0,ex5(:),16,G1H16(144),m3h1x16(:,221),heltab2x16(:,:,221))
  Gcoeff(:)%j = (c(165)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(222),h0tab(:,222),[16,1,2,8,4],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(62),0,ex5(:),16,G1H16(145),m3h1x16(:,222),heltab2x16(:,:,222))
  Gcoeff(:)%j = (c(74)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(223),h0tab(:,223),[16,1,2,8,4],[nMW,nMB,nMW,nMT,nMW],5,0)
  call Hloop_ST_V(ntryL,G0H16(62),0,ex5(:),16,G1H16(146),m3h1x16(:,223),heltab2x16(:,:,223))
  Gcoeff(:)%j = (-(c(419)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(224),h0tab(:,224),[16,1,2,8,4],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_VT_S(ntryL,G0H16(62),0,ex5(:),16,G1H16(147),m3h1x16(:,224),heltab2x16(:,:,224))
  Gcoeff(:)%j = (c(422)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(225),h0tab(:,225),[16,1,2,8,4],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_VT_S(ntryL,G0H16(62),0,ex5(:),16,G1H16(148),m3h1x16(:,225),heltab2x16(:,:,225))
  Gcoeff(:)%j = (c(110)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(226),h0tab(:,226),[16,1,2,8,4],[nMW,nMB,nMW,nMT,nMW],5,0)
  call Hloop_VT_S(ntryL,G0H16(62),0,ex5(:),16,G1H16(149),m3h1x16(:,226),heltab2x16(:,:,226))
  Gcoeff(:)%j = (c(426)*M(2,:)%j-c(425)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(227),h0tab(:,227),[16,1,2,8,4],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_VT_S(ntryL,G0H16(62),0,ex5(:),16,G1H16(150),m3h1x16(:,227),heltab2x16(:,:,227))
  Gcoeff(:)%j = (-(c(363)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(228),h0tab(:,228),[16,1,2,8,4],[nMZ,nMT,nMH,nMB,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(79),m3h1x16(:,228),heltab2x16(:,:,228))
  Gcoeff(:)%j = (-(c(363)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(229),h0tab(:,229),[16,1,2,8,4],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(80),m3h1x16(:,229),heltab2x16(:,:,229))
  Gcoeff(:)%j = (c(111)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(230),h0tab(:,230),[16,1,2,8,4],[nMW,nMB,nMW,nMT,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(81),m3h1x16(:,230),heltab2x16(:,:,230))
  Gcoeff(:)%j = (c(405)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(231),h0tab(:,231),[16,1,2,8,4],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(62),0,ex5(:),16,G1H16(151),m3h1x16(:,231),heltab2x16(:,:,231))
  Gcoeff(:)%j = (-(c(408)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(232),h0tab(:,232),[16,1,2,8,4],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(62),0,ex5(:),16,G1H16(152),m3h1x16(:,232),heltab2x16(:,:,232))
  Gcoeff(:)%j = (c(110)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(233),h0tab(:,233),[16,1,2,8,4],[nMW,nMB,nMW,nMT,nMW],5,0)
  call Hloop_ST_V(ntryL,G0H16(62),0,ex5(:),16,G1H16(153),m3h1x16(:,233),heltab2x16(:,:,233))
  Gcoeff(:)%j = (-(c(412)*M(2,:)%j)+c(411)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(234),h0tab(:,234),[16,1,2,8,4],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(62),0,ex5(:),16,G1H16(154),m3h1x16(:,234),heltab2x16(:,:,234))
  Gcoeff(:)%j = (-(c(491)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(235),h0tab(:,235),[16,1,2,8,4],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(82),m3h1x16(:,235),heltab2x16(:,:,235))
  Gcoeff(:)%j = (c(495)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(236),h0tab(:,236),[16,1,2,8,4],[nMZ,nMT,nMZ,nMB,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(83),m3h1x16(:,236),heltab2x16(:,:,236))
  Gcoeff(:)%j = (c(144)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(237),h0tab(:,237),[16,1,2,8,4],[nMW,nMB,nMW,nMT,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(84),m3h1x16(:,237),heltab2x16(:,:,237))
  Gcoeff(:)%j = (c(497)*M(2,:)%j-c(496)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(238),h0tab(:,238),[16,1,2,8,4],[nMZ,nMT,0,nMB,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(85),m3h1x16(:,238),heltab2x16(:,:,238))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(239),h0tab(:,239),[16,2,4,1,8],[nMH,nMT,nMW,nMB,nMH],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(86),m3h1x16(:,239),heltab2x16(:,:,239))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(240),h0tab(:,240),[16,2,4,1,8],[nMZ,nMT,nMW,nMB,nMZ],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(87),m3h1x16(:,240),heltab2x16(:,:,240))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(241),h0tab(:,241),[16,2,4,1,8],[nMW,nMB,nMH,nMT,nMW],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(88),m3h1x16(:,241),heltab2x16(:,:,241))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(242),h0tab(:,242),[16,2,4,1,8],[nMW,nMB,nMZ,nMT,nMW],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(89),m3h1x16(:,242),heltab2x16(:,:,242))
  Gcoeff(:)%j = (-(c(164)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(243),h0tab(:,243),[16,2,4,1,8],[nMZ,nMT,nMW,nMB,nMZ],5,0)
  call Hloop_VT_S(ntryL,G0H16(62),0,ex5(:),16,G1H16(155),m3h1x16(:,243),heltab2x16(:,:,243))
  Gcoeff(:)%j = (c(90)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(244),h0tab(:,244),[16,2,4,1,8],[nMW,nMB,nMH,nMT,nMW],5,0)
  call Hloop_VT_S(ntryL,G0H16(62),0,ex5(:),16,G1H16(156),m3h1x16(:,244),heltab2x16(:,:,244))
  Gcoeff(:)%j = (c(90)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(245),h0tab(:,245),[16,2,4,1,8],[nMW,nMB,nMZ,nMT,nMW],5,0)
  call Hloop_VT_S(ntryL,G0H16(62),0,ex5(:),16,G1H16(157),m3h1x16(:,245),heltab2x16(:,:,245))
  Gcoeff(:)%j = (c(157)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(246),h0tab(:,246),[16,2,4,1,8],[nMZ,nMT,nMW,nMB,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(62),0,ex5(:),16,G1H16(158),m3h1x16(:,246),heltab2x16(:,:,246))
  Gcoeff(:)%j = (c(90)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(247),h0tab(:,247),[16,2,4,1,8],[nMW,nMB,nMH,nMT,nMW],5,0)
  call Hloop_ST_V(ntryL,G0H16(62),0,ex5(:),16,G1H16(159),m3h1x16(:,247),heltab2x16(:,:,247))
  Gcoeff(:)%j = (c(90)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(248),h0tab(:,248),[16,2,4,1,8],[nMW,nMB,nMZ,nMT,nMW],5,0)
  call Hloop_ST_V(ntryL,G0H16(62),0,ex5(:),16,G1H16(160),m3h1x16(:,248),heltab2x16(:,:,248))
  Gcoeff(:)%j = (c(236)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(249),h0tab(:,249),[16,2,4,1,8],[nMW,nMB,0,nMT,nMW],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(90),m3h1x16(:,249),heltab2x16(:,:,249))
  Gcoeff(:)%j = (-(c(240)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(250),h0tab(:,250),[16,2,4,1,8],[nMW,nMB,nMZ,nMT,nMW],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(91),m3h1x16(:,250),heltab2x16(:,:,250))
  Gcoeff(:)%j = (c(100)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(251),h0tab(:,251),[16,2,4,1,8],[nMH,nMT,nMW,nMB,nMH],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(92),m3h1x16(:,251),heltab2x16(:,:,251))
  Gcoeff(:)%j = (c(97)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(252),h0tab(:,252),[16,2,4,1,8],[nMZ,nMT,nMW,nMB,nMZ],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(93),m3h1x16(:,252),heltab2x16(:,:,252))
  Gcoeff(:)%j = (c(241)*M(2,:)%j-c(242)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(253),h0tab(:,253),[16,2,4,1,8],[nMW,nMB,0,nMT,nMW],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(94),m3h1x16(:,253),heltab2x16(:,:,253))
  Gcoeff(:)%j = (-(c(318)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(254),h0tab(:,254),[16,2,4,1,8],[nMZ,nMT,nMW,nMB,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(95),m3h1x16(:,254),heltab2x16(:,:,254))
  Gcoeff(:)%j = (c(126)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(255),h0tab(:,255),[16,2,4,1,8],[nMW,nMB,nMH,nMT,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(96),m3h1x16(:,255),heltab2x16(:,:,255))
  Gcoeff(:)%j = (c(126)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(256),h0tab(:,256),[16,2,4,1,8],[nMW,nMB,nMZ,nMT,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(97),m3h1x16(:,256),heltab2x16(:,:,256))
  Gcoeff(:)%j = (c(312)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(257),h0tab(:,257),[16,2,4,1,8],[nMW,nMB,0,nMT,nMW],5,0)
  call Hloop_VT_S(ntryL,G0H16(62),0,ex5(:),16,G1H16(161),m3h1x16(:,257),heltab2x16(:,:,257))
  Gcoeff(:)%j = (-(c(194)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(258),h0tab(:,258),[16,2,4,1,8],[nMZ,nMT,nMW,nMB,nMZ],5,0)
  call Hloop_VT_S(ntryL,G0H16(62),0,ex5(:),16,G1H16(162),m3h1x16(:,258),heltab2x16(:,:,258))
  Gcoeff(:)%j = (-(c(316)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(259),h0tab(:,259),[16,2,4,1,8],[nMW,nMB,nMZ,nMT,nMW],5,0)
  call Hloop_VT_S(ntryL,G0H16(62),0,ex5(:),16,G1H16(163),m3h1x16(:,259),heltab2x16(:,:,259))
  Gcoeff(:)%j = (c(319)*M(2,:)%j-c(320)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(260),h0tab(:,260),[16,2,4,1,8],[nMW,nMB,0,nMT,nMW],5,0)
  call Hloop_VT_S(ntryL,G0H16(62),0,ex5(:),16,G1H16(164),m3h1x16(:,260),heltab2x16(:,:,260))
  Gcoeff(:)%j = (c(312)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(261),h0tab(:,261),[16,2,4,1,8],[nMW,nMB,0,nMT,nMW],5,0)
  call Hloop_ST_V(ntryL,G0H16(62),0,ex5(:),16,G1H16(165),m3h1x16(:,261),heltab2x16(:,:,261))
  Gcoeff(:)%j = (c(180)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(262),h0tab(:,262),[16,2,4,1,8],[nMZ,nMT,nMW,nMB,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(62),0,ex5(:),16,G1H16(166),m3h1x16(:,262),heltab2x16(:,:,262))
  Gcoeff(:)%j = (-(c(316)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(263),h0tab(:,263),[16,2,4,1,8],[nMW,nMB,nMZ,nMT,nMW],5,0)
  call Hloop_ST_V(ntryL,G0H16(62),0,ex5(:),16,G1H16(167),m3h1x16(:,263),heltab2x16(:,:,263))
  Gcoeff(:)%j = (c(319)*M(2,:)%j-c(320)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(264),h0tab(:,264),[16,2,4,1,8],[nMW,nMB,0,nMT,nMW],5,0)
  call Hloop_ST_V(ntryL,G0H16(62),0,ex5(:),16,G1H16(168),m3h1x16(:,264),heltab2x16(:,:,264))
  Gcoeff(:)%j = (-(c(383)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(265),h0tab(:,265),[16,2,4,1,8],[nMZ,nMT,nMW,nMB,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(98),m3h1x16(:,265),heltab2x16(:,:,265))
  Gcoeff(:)%j = (c(373)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(266),h0tab(:,266),[16,2,4,1,8],[nMW,nMB,0,nMT,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(99),m3h1x16(:,266),heltab2x16(:,:,266))
  Gcoeff(:)%j = (-(c(378)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(267),h0tab(:,267),[16,2,4,1,8],[nMW,nMB,nMZ,nMT,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(100),m3h1x16(:,267),heltab2x16(:,:,267))
  Gcoeff(:)%j = (c(386)*M(2,:)%j-c(387)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(268),h0tab(:,268),[16,2,4,1,8],[nMW,nMB,0,nMT,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(101),m3h1x16(:,268),heltab2x16(:,:,268))
  Gcoeff(:)%j = (c(56)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(269),h0tab(:,269),[16,2,8,1,4],[nMT,nMH,nMB,nMW,nMT],5,0)
  call Hloop_QS_A(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,269),heltab2x16(:,:,269))
  call Hloop_Q_A(ntryL,G0H16(102),16,nMT,G1H16(169),n2h16(93))
  Gcoeff(:)%j = (c(30)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(270),h0tab(:,270),[16,2,8,1,4],[nMB,nMW,nMT,nMH,nMB],5,0)
  call Hloop_QS_A(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,270),heltab2x16(:,:,270))
  call Hloop_Q_A(ntryL,G0H16(102),16,nMB,G1H16(170),n2h16(94))
  Gcoeff(:)%j = (c(56)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(271),h0tab(:,271),[16,2,8,1,4],[nMT,nMZ,nMB,nMW,nMT],5,0)
  call Hloop_QS_A(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,271),heltab2x16(:,:,271))
  call Hloop_Q_A(ntryL,G0H16(102),16,nMT,G1H16(171),n2h16(95))
  Gcoeff(:)%j = (c(30)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(272),h0tab(:,272),[16,2,8,1,4],[nMB,nMW,nMT,nMZ,nMB],5,0)
  call Hloop_QS_A(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,272),heltab2x16(:,:,272))
  call Hloop_Q_A(ntryL,G0H16(102),16,nMB,G1H16(172),n2h16(96))
  Gcoeff(:)%j = (c(257)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(273),h0tab(:,273),[16,2,8,1,4],[nMT,0,nMB,nMW,nMT],5,0)
  call Hloop_QS_A(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,273),heltab2x16(:,:,273))
  call Hloop_Q_A(ntryL,G0H16(102),16,nMT,G1H16(173),n2h16(97))
  Gcoeff(:)%j = (-(c(261)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(274),h0tab(:,274),[16,2,8,1,4],[nMT,nMZ,nMB,nMW,nMT],5,0)
  call Hloop_QS_A(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,274),heltab2x16(:,:,274))
  call Hloop_Q_A(ntryL,G0H16(102),16,nMT,G1H16(174),n2h16(98))
  Gcoeff(:)%j = (c(92)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(275),h0tab(:,275),[16,2,8,1,4],[nMB,nMW,nMT,nMH,nMB],5,0)
  call Hloop_QS_A(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,275),heltab2x16(:,:,275))
  call Hloop_Q_A(ntryL,G0H16(102),16,nMB,G1H16(175),n2h16(99))
  Gcoeff(:)%j = (c(92)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(276),h0tab(:,276),[16,2,8,1,4],[nMB,nMW,nMT,nMZ,nMB],5,0)
  call Hloop_QS_A(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,276),heltab2x16(:,:,276))
  call Hloop_Q_A(ntryL,G0H16(102),16,nMB,G1H16(176),n2h16(100))
  Gcoeff(:)%j = (c(262)*M(2,:)%j-c(263)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(277),h0tab(:,277),[16,2,8,1,4],[nMT,0,nMB,nMW,nMT],5,0)
  call Hloop_QS_A(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,277),heltab2x16(:,:,277))
  call Hloop_Q_A(ntryL,G0H16(102),16,nMT,G1H16(177),n2h16(101))
  Gcoeff(:)%j = (c(223)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(278),h0tab(:,278),[16,2,8,1,4],[nMB,nMW,nMT,0,nMB],5,0)
  call Hloop_QS_A(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,278),heltab2x16(:,:,278))
  call Hloop_Q_A(ntryL,G0H16(102),16,nMB,G1H16(178),n2h16(102))
  Gcoeff(:)%j = (-(c(227)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(279),h0tab(:,279),[16,2,8,1,4],[nMB,nMW,nMT,nMZ,nMB],5,0)
  call Hloop_QS_A(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,279),heltab2x16(:,:,279))
  call Hloop_Q_A(ntryL,G0H16(102),16,nMB,G1H16(179),n2h16(103))
  Gcoeff(:)%j = (c(104)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(280),h0tab(:,280),[16,2,8,1,4],[nMT,nMH,nMB,nMW,nMT],5,0)
  call Hloop_QS_A(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,280),heltab2x16(:,:,280))
  call Hloop_Q_A(ntryL,G0H16(102),16,nMT,G1H16(180),n2h16(104))
  Gcoeff(:)%j = (c(104)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(281),h0tab(:,281),[16,2,8,1,4],[nMT,nMZ,nMB,nMW,nMT],5,0)
  call Hloop_QS_A(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,281),heltab2x16(:,:,281))
  call Hloop_Q_A(ntryL,G0H16(102),16,nMT,G1H16(181),n2h16(105))
  Gcoeff(:)%j = (c(228)*M(2,:)%j-c(229)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(282),h0tab(:,282),[16,2,8,1,4],[nMB,nMW,nMT,0,nMB],5,0)
  call Hloop_QS_A(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,282),heltab2x16(:,:,282))
  call Hloop_Q_A(ntryL,G0H16(102),16,nMB,G1H16(182),n2h16(106))
  Gcoeff(:)%j = (c(348)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(283),h0tab(:,283),[16,2,8,1,4],[nMT,0,nMB,nMW,nMT],5,0)
  call Hloop_QS_A(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,283),heltab2x16(:,:,283))
  call Hloop_Q_A(ntryL,G0H16(102),16,nMT,G1H16(183),n2h16(107))
  Gcoeff(:)%j = (c(323)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(284),h0tab(:,284),[16,2,8,1,4],[nMB,nMW,nMT,0,nMB],5,0)
  call Hloop_QS_A(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,284),heltab2x16(:,:,284))
  call Hloop_Q_A(ntryL,G0H16(102),16,nMB,G1H16(184),n2h16(108))
  Gcoeff(:)%j = (-(c(352)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(285),h0tab(:,285),[16,2,8,1,4],[nMT,nMZ,nMB,nMW,nMT],5,0)
  call Hloop_QS_A(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,285),heltab2x16(:,:,285))
  call Hloop_Q_A(ntryL,G0H16(102),16,nMT,G1H16(185),n2h16(109))
  Gcoeff(:)%j = (-(c(327)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(286),h0tab(:,286),[16,2,8,1,4],[nMB,nMW,nMT,nMZ,nMB],5,0)
  call Hloop_QS_A(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,286),heltab2x16(:,:,286))
  call Hloop_Q_A(ntryL,G0H16(102),16,nMB,G1H16(186),n2h16(110))
  Gcoeff(:)%j = (c(356)*M(2,:)%j-c(357)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(287),h0tab(:,287),[16,2,8,1,4],[nMT,0,nMB,nMW,nMT],5,0)
  call Hloop_QS_A(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,287),heltab2x16(:,:,287))
  call Hloop_Q_A(ntryL,G0H16(102),16,nMT,G1H16(187),n2h16(111))
  Gcoeff(:)%j = (c(331)*M(2,:)%j-c(332)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(288),h0tab(:,288),[16,2,8,1,4],[nMB,nMW,nMT,0,nMB],5,0)
  call Hloop_QS_A(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,288),heltab2x16(:,:,288))
  call Hloop_Q_A(ntryL,G0H16(102),16,nMB,G1H16(188),n2h16(112))
  Gcoeff(:)%j = (c(56)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(289),h0tab(:,289),[16,1,4,2,8],[nMT,nMH,nMB,nMW,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,289),heltab2x16(:,:,289))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(189),n2h16(113))
  Gcoeff(:)%j = (c(30)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(290),h0tab(:,290),[16,1,4,2,8],[nMB,nMW,nMT,nMH,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,290),heltab2x16(:,:,290))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMB,G1H16(190),n2h16(114))
  Gcoeff(:)%j = (c(56)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(291),h0tab(:,291),[16,1,4,2,8],[nMT,nMZ,nMB,nMW,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,291),heltab2x16(:,:,291))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(191),n2h16(115))
  Gcoeff(:)%j = (c(30)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(292),h0tab(:,292),[16,1,4,2,8],[nMB,nMW,nMT,nMZ,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,292),heltab2x16(:,:,292))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMB,G1H16(192),n2h16(116))
  Gcoeff(:)%j = (c(223)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(293),h0tab(:,293),[16,1,4,2,8],[nMB,nMW,nMT,0,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,293),heltab2x16(:,:,293))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMB,G1H16(193),n2h16(117))
  Gcoeff(:)%j = (-(c(227)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(294),h0tab(:,294),[16,1,4,2,8],[nMB,nMW,nMT,nMZ,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,294),heltab2x16(:,:,294))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMB,G1H16(194),n2h16(118))
  Gcoeff(:)%j = (c(104)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(295),h0tab(:,295),[16,1,4,2,8],[nMT,nMH,nMB,nMW,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,295),heltab2x16(:,:,295))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(195),n2h16(119))
  Gcoeff(:)%j = (c(104)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(296),h0tab(:,296),[16,1,4,2,8],[nMT,nMZ,nMB,nMW,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,296),heltab2x16(:,:,296))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(196),n2h16(120))
  Gcoeff(:)%j = (c(228)*M(2,:)%j-c(229)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(297),h0tab(:,297),[16,1,4,2,8],[nMB,nMW,nMT,0,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,297),heltab2x16(:,:,297))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMB,G1H16(197),n2h16(121))
  Gcoeff(:)%j = (c(257)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(298),h0tab(:,298),[16,1,4,2,8],[nMT,0,nMB,nMW,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,298),heltab2x16(:,:,298))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(198),n2h16(122))
  Gcoeff(:)%j = (-(c(261)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(299),h0tab(:,299),[16,1,4,2,8],[nMT,nMZ,nMB,nMW,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,299),heltab2x16(:,:,299))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(199),n2h16(123))
  Gcoeff(:)%j = (c(92)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(300),h0tab(:,300),[16,1,4,2,8],[nMB,nMW,nMT,nMH,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,300),heltab2x16(:,:,300))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMB,G1H16(200),n2h16(124))
  Gcoeff(:)%j = (c(92)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(301),h0tab(:,301),[16,1,4,2,8],[nMB,nMW,nMT,nMZ,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,301),heltab2x16(:,:,301))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMB,G1H16(201),n2h16(125))
  Gcoeff(:)%j = (c(262)*M(2,:)%j-c(263)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(302),h0tab(:,302),[16,1,4,2,8],[nMT,0,nMB,nMW,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,302),heltab2x16(:,:,302))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(202),n2h16(126))
  Gcoeff(:)%j = (c(348)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(303),h0tab(:,303),[16,1,4,2,8],[nMT,0,nMB,nMW,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,303),heltab2x16(:,:,303))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(203),n2h16(127))
  Gcoeff(:)%j = (c(323)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(304),h0tab(:,304),[16,1,4,2,8],[nMB,nMW,nMT,0,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,304),heltab2x16(:,:,304))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMB,G1H16(204),n2h16(128))
  Gcoeff(:)%j = (-(c(352)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(305),h0tab(:,305),[16,1,4,2,8],[nMT,nMZ,nMB,nMW,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,305),heltab2x16(:,:,305))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(205),n2h16(129))
  Gcoeff(:)%j = (-(c(327)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(306),h0tab(:,306),[16,1,4,2,8],[nMB,nMW,nMT,nMZ,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,306),heltab2x16(:,:,306))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMB,G1H16(206),n2h16(130))
  Gcoeff(:)%j = (c(356)*M(2,:)%j-c(357)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(307),h0tab(:,307),[16,1,4,2,8],[nMT,0,nMB,nMW,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,307),heltab2x16(:,:,307))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(207),n2h16(131))
  Gcoeff(:)%j = (c(331)*M(2,:)%j-c(332)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(308),h0tab(:,308),[16,1,4,2,8],[nMB,nMW,nMT,0,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,308),heltab2x16(:,:,308))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMB,G1H16(208),n2h16(132))
  Gcoeff(:)%j = (c(70)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(309),h0tab(:,309),[16,1,4,8,2],[nMT,nMH,nMB,nMH,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,309),heltab2x16(:,:,309))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(209),n2h16(133))
  Gcoeff(:)%j = (c(70)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(310),h0tab(:,310),[16,1,4,8,2],[nMT,nMH,nMB,nMZ,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,310),heltab2x16(:,:,310))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(210),n2h16(134))
  Gcoeff(:)%j = (c(70)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(311),h0tab(:,311),[16,1,4,8,2],[nMT,nMZ,nMB,nMH,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,311),heltab2x16(:,:,311))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(211),n2h16(135))
  Gcoeff(:)%j = (c(70)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(312),h0tab(:,312),[16,1,4,8,2],[nMT,nMZ,nMB,nMZ,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,312),heltab2x16(:,:,312))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(212),n2h16(136))
  Gcoeff(:)%j = (c(15)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(313),h0tab(:,313),[16,1,4,8,2],[nMB,nMW,nMT,nMW,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,313),heltab2x16(:,:,313))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMB,G1H16(213),n2h16(137))
  Gcoeff(:)%j = (c(292)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(314),h0tab(:,314),[16,1,4,8,2],[nMT,nMH,nMB,0,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,314),heltab2x16(:,:,314))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(214),n2h16(138))
  Gcoeff(:)%j = (c(292)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(315),h0tab(:,315),[16,1,4,8,2],[nMT,nMZ,nMB,0,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,315),heltab2x16(:,:,315))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(215),n2h16(139))
  Gcoeff(:)%j = (-(c(294)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(316),h0tab(:,316),[16,1,4,8,2],[nMT,nMH,nMB,nMZ,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,316),heltab2x16(:,:,316))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(216),n2h16(140))
  Gcoeff(:)%j = (-(c(294)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(317),h0tab(:,317),[16,1,4,8,2],[nMT,nMZ,nMB,nMZ,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,317),heltab2x16(:,:,317))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(217),n2h16(141))
  Gcoeff(:)%j = (c(76)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(318),h0tab(:,318),[16,1,4,8,2],[nMB,nMW,nMT,nMW,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,318),heltab2x16(:,:,318))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMB,G1H16(218),n2h16(142))
  Gcoeff(:)%j = (-(c(296)*M(2,:)%j)+c(295)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(319),h0tab(:,319),[16,1,4,8,2],[nMT,nMH,nMB,0,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,319),heltab2x16(:,:,319))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(219),n2h16(143))
  Gcoeff(:)%j = (-(c(296)*M(2,:)%j)+c(295)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(320),h0tab(:,320),[16,1,4,8,2],[nMT,nMZ,nMB,0,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,320),heltab2x16(:,:,320))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(220),n2h16(144))
  Gcoeff(:)%j = (c(292)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(321),h0tab(:,321),[16,1,4,8,2],[nMT,0,nMB,nMH,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,321),heltab2x16(:,:,321))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(221),n2h16(145))
  Gcoeff(:)%j = (c(292)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(322),h0tab(:,322),[16,1,4,8,2],[nMT,0,nMB,nMZ,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,322),heltab2x16(:,:,322))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(222),n2h16(146))
  Gcoeff(:)%j = (-(c(294)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(323),h0tab(:,323),[16,1,4,8,2],[nMT,nMZ,nMB,nMH,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,323),heltab2x16(:,:,323))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(223),n2h16(147))
  Gcoeff(:)%j = (-(c(294)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(324),h0tab(:,324),[16,1,4,8,2],[nMT,nMZ,nMB,nMZ,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,324),heltab2x16(:,:,324))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(224),n2h16(148))
  Gcoeff(:)%j = (c(76)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(325),h0tab(:,325),[16,1,4,8,2],[nMB,nMW,nMT,nMW,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,325),heltab2x16(:,:,325))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMB,G1H16(225),n2h16(149))
  Gcoeff(:)%j = (-(c(296)*M(2,:)%j)+c(295)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(326),h0tab(:,326),[16,1,4,8,2],[nMT,0,nMB,nMH,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,326),heltab2x16(:,:,326))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(226),n2h16(150))
  Gcoeff(:)%j = (-(c(296)*M(2,:)%j)+c(295)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(327),h0tab(:,327),[16,1,4,8,2],[nMT,0,nMB,nMZ,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,327),heltab2x16(:,:,327))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(227),n2h16(151))
  Gcoeff(:)%j = (c(469)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(328),h0tab(:,328),[16,1,4,8,2],[nMT,0,nMB,0,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,328),heltab2x16(:,:,328))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(228),n2h16(152))
  Gcoeff(:)%j = (-(c(472)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(329),h0tab(:,329),[16,1,4,8,2],[nMT,0,nMB,nMZ,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,329),heltab2x16(:,:,329))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(229),n2h16(153))
  Gcoeff(:)%j = (-(c(472)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(330),h0tab(:,330),[16,1,4,8,2],[nMT,nMZ,nMB,0,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,330),heltab2x16(:,:,330))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(230),n2h16(154))
  Gcoeff(:)%j = (c(474)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(331),h0tab(:,331),[16,1,4,8,2],[nMT,nMZ,nMB,nMZ,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,331),heltab2x16(:,:,331))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(231),n2h16(155))
  Gcoeff(:)%j = (c(114)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(332),h0tab(:,332),[16,1,4,8,2],[nMB,nMW,nMT,nMW,nMB],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,332),heltab2x16(:,:,332))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMB,G1H16(232),n2h16(156))
  Gcoeff(:)%j = (-(c(479)*M(2,:)%j)+c(478)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(333),h0tab(:,333),[16,1,4,8,2],[nMT,0,nMB,0,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,333),heltab2x16(:,:,333))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(233),n2h16(157))
  Gcoeff(:)%j = (-(c(479)*M(2,:)%j)+c(478)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(334),h0tab(:,334),[16,1,4,8,2],[nMT,0,nMB,0,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,334),heltab2x16(:,:,334))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(234),n2h16(158))
  Gcoeff(:)%j = (c(484)*M(2,:)%j-c(483)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(335),h0tab(:,335),[16,1,4,8,2],[nMT,nMZ,nMB,0,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,335),heltab2x16(:,:,335))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(235),n2h16(159))
  Gcoeff(:)%j = (c(484)*M(2,:)%j-c(483)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(336),h0tab(:,336),[16,1,4,8,2],[nMT,0,nMB,nMZ,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(102),ngH,m3h1x16(:,336),heltab2x16(:,:,336))
  call Hloop_A_Q(ntryL,G0H16(102),16,nMT,G1H16(236),n2h16(160))
  Gcoeff(:)%j = (c(34)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(337),h0tab(:,337),[16,1,8,2,4],[nMH,nMT,nMW,nMB,nMH],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(102),m3h1x16(:,337),heltab2x16(:,:,337))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(338),h0tab(:,338),[16,1,8,2,4],[nMZ,nMT,nMW,nMB,nMZ],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(103),m3h1x16(:,338),heltab2x16(:,:,338))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(339),h0tab(:,339),[16,1,8,2,4],[nMW,nMB,nMH,nMT,nMW],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(104),m3h1x16(:,339),heltab2x16(:,:,339))
  Gcoeff(:)%j = (c(33)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(340),h0tab(:,340),[16,1,8,2,4],[nMW,nMB,nMZ,nMT,nMW],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(105),m3h1x16(:,340),heltab2x16(:,:,340))
  Gcoeff(:)%j = (-(c(164)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(341),h0tab(:,341),[16,1,8,2,4],[nMZ,nMT,nMW,nMB,nMZ],5,0)
  call Hloop_VT_S(ntryL,G0H16(62),0,ex5(:),16,G1H16(237),m3h1x16(:,341),heltab2x16(:,:,341))
  Gcoeff(:)%j = (c(90)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(342),h0tab(:,342),[16,1,8,2,4],[nMW,nMB,nMH,nMT,nMW],5,0)
  call Hloop_VT_S(ntryL,G0H16(62),0,ex5(:),16,G1H16(238),m3h1x16(:,342),heltab2x16(:,:,342))
  Gcoeff(:)%j = (c(90)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(343),h0tab(:,343),[16,1,8,2,4],[nMW,nMB,nMZ,nMT,nMW],5,0)
  call Hloop_VT_S(ntryL,G0H16(62),0,ex5(:),16,G1H16(239),m3h1x16(:,343),heltab2x16(:,:,343))
  Gcoeff(:)%j = (c(236)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(344),h0tab(:,344),[16,1,8,2,4],[nMW,nMB,0,nMT,nMW],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(106),m3h1x16(:,344),heltab2x16(:,:,344))
  Gcoeff(:)%j = (-(c(240)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(345),h0tab(:,345),[16,1,8,2,4],[nMW,nMB,nMZ,nMT,nMW],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(107),m3h1x16(:,345),heltab2x16(:,:,345))
  Gcoeff(:)%j = (c(100)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(346),h0tab(:,346),[16,1,8,2,4],[nMH,nMT,nMW,nMB,nMH],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(108),m3h1x16(:,346),heltab2x16(:,:,346))
  Gcoeff(:)%j = (c(97)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(347),h0tab(:,347),[16,1,8,2,4],[nMZ,nMT,nMW,nMB,nMZ],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(109),m3h1x16(:,347),heltab2x16(:,:,347))
  Gcoeff(:)%j = (c(241)*M(2,:)%j-c(242)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(348),h0tab(:,348),[16,1,8,2,4],[nMW,nMB,0,nMT,nMW],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(110),m3h1x16(:,348),heltab2x16(:,:,348))
  Gcoeff(:)%j = (c(157)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(349),h0tab(:,349),[16,1,8,2,4],[nMZ,nMT,nMW,nMB,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(62),0,ex5(:),16,G1H16(240),m3h1x16(:,349),heltab2x16(:,:,349))
  Gcoeff(:)%j = (c(90)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(350),h0tab(:,350),[16,1,8,2,4],[nMW,nMB,nMH,nMT,nMW],5,0)
  call Hloop_ST_V(ntryL,G0H16(62),0,ex5(:),16,G1H16(241),m3h1x16(:,350),heltab2x16(:,:,350))
  Gcoeff(:)%j = (c(90)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(351),h0tab(:,351),[16,1,8,2,4],[nMW,nMB,nMZ,nMT,nMW],5,0)
  call Hloop_ST_V(ntryL,G0H16(62),0,ex5(:),16,G1H16(242),m3h1x16(:,351),heltab2x16(:,:,351))
  Gcoeff(:)%j = (c(312)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(352),h0tab(:,352),[16,1,8,2,4],[nMW,nMB,0,nMT,nMW],5,0)
  call Hloop_VT_S(ntryL,G0H16(62),0,ex5(:),16,G1H16(243),m3h1x16(:,352),heltab2x16(:,:,352))
  Gcoeff(:)%j = (-(c(194)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(353),h0tab(:,353),[16,1,8,2,4],[nMZ,nMT,nMW,nMB,nMZ],5,0)
  call Hloop_VT_S(ntryL,G0H16(62),0,ex5(:),16,G1H16(244),m3h1x16(:,353),heltab2x16(:,:,353))
  Gcoeff(:)%j = (-(c(316)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(354),h0tab(:,354),[16,1,8,2,4],[nMW,nMB,nMZ,nMT,nMW],5,0)
  call Hloop_VT_S(ntryL,G0H16(62),0,ex5(:),16,G1H16(245),m3h1x16(:,354),heltab2x16(:,:,354))
  Gcoeff(:)%j = (c(319)*M(2,:)%j-c(320)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(355),h0tab(:,355),[16,1,8,2,4],[nMW,nMB,0,nMT,nMW],5,0)
  call Hloop_VT_S(ntryL,G0H16(62),0,ex5(:),16,G1H16(246),m3h1x16(:,355),heltab2x16(:,:,355))
  Gcoeff(:)%j = (-(c(318)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(356),h0tab(:,356),[16,1,8,2,4],[nMZ,nMT,nMW,nMB,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(111),m3h1x16(:,356),heltab2x16(:,:,356))
  Gcoeff(:)%j = (c(126)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(357),h0tab(:,357),[16,1,8,2,4],[nMW,nMB,nMH,nMT,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(112),m3h1x16(:,357),heltab2x16(:,:,357))
  Gcoeff(:)%j = (c(126)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(358),h0tab(:,358),[16,1,8,2,4],[nMW,nMB,nMZ,nMT,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(113),m3h1x16(:,358),heltab2x16(:,:,358))
  Gcoeff(:)%j = (c(312)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(359),h0tab(:,359),[16,1,8,2,4],[nMW,nMB,0,nMT,nMW],5,0)
  call Hloop_ST_V(ntryL,G0H16(62),0,ex5(:),16,G1H16(247),m3h1x16(:,359),heltab2x16(:,:,359))
  Gcoeff(:)%j = (c(180)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(360),h0tab(:,360),[16,1,8,2,4],[nMZ,nMT,nMW,nMB,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(62),0,ex5(:),16,G1H16(248),m3h1x16(:,360),heltab2x16(:,:,360))
  Gcoeff(:)%j = (-(c(316)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(361),h0tab(:,361),[16,1,8,2,4],[nMW,nMB,nMZ,nMT,nMW],5,0)
  call Hloop_ST_V(ntryL,G0H16(62),0,ex5(:),16,G1H16(249),m3h1x16(:,361),heltab2x16(:,:,361))
  Gcoeff(:)%j = (c(319)*M(2,:)%j-c(320)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(362),h0tab(:,362),[16,1,8,2,4],[nMW,nMB,0,nMT,nMW],5,0)
  call Hloop_ST_V(ntryL,G0H16(62),0,ex5(:),16,G1H16(250),m3h1x16(:,362),heltab2x16(:,:,362))
  Gcoeff(:)%j = (-(c(383)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(363),h0tab(:,363),[16,1,8,2,4],[nMZ,nMT,nMW,nMB,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(114),m3h1x16(:,363),heltab2x16(:,:,363))
  Gcoeff(:)%j = (c(373)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(364),h0tab(:,364),[16,1,8,2,4],[nMW,nMB,0,nMT,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(115),m3h1x16(:,364),heltab2x16(:,:,364))
  Gcoeff(:)%j = (-(c(378)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(365),h0tab(:,365),[16,1,8,2,4],[nMW,nMB,nMZ,nMT,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(116),m3h1x16(:,365),heltab2x16(:,:,365))
  Gcoeff(:)%j = (c(386)*M(2,:)%j-c(387)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(366),h0tab(:,366),[16,1,8,2,4],[nMW,nMB,0,nMT,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(117),m3h1x16(:,366),heltab2x16(:,:,366))
  Gcoeff(:)%j = (c(70)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(367),h0tab(:,367),[16,1,8,4,2],[nMT,nMH,nMB,nMH,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(118),ngH,m3h1x16(:,367),heltab2x16(:,:,367))
  call Hloop_A_Q(ntryL,G0H16(118),16,nMT,G1H16(251),n2h16(161))
  Gcoeff(:)%j = (c(70)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(368),h0tab(:,368),[16,1,8,4,2],[nMT,nMH,nMB,nMZ,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(118),ngH,m3h1x16(:,368),heltab2x16(:,:,368))
  call Hloop_A_Q(ntryL,G0H16(118),16,nMT,G1H16(252),n2h16(162))
  Gcoeff(:)%j = (c(70)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(369),h0tab(:,369),[16,1,8,4,2],[nMT,nMZ,nMB,nMH,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(118),ngH,m3h1x16(:,369),heltab2x16(:,:,369))
  call Hloop_A_Q(ntryL,G0H16(118),16,nMT,G1H16(253),n2h16(163))
  Gcoeff(:)%j = (c(70)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(370),h0tab(:,370),[16,1,8,4,2],[nMT,nMZ,nMB,nMZ,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(118),ngH,m3h1x16(:,370),heltab2x16(:,:,370))
  call Hloop_A_Q(ntryL,G0H16(118),16,nMT,G1H16(254),n2h16(164))
  Gcoeff(:)%j = (c(59)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(371),h0tab(:,371),[16,1,8,4,2],[nMH,nMT,nMW,nMT,nMH],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(118),m3h1x16(:,371),heltab2x16(:,:,371))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(372),h0tab(:,372),[16,1,8,4,2],[nMZ,nMT,nMW,nMT,nMZ],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(119),m3h1x16(:,372),heltab2x16(:,:,372))
  Gcoeff(:)%j = (c(19)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(373),h0tab(:,373),[16,1,8,4,2],[nMW,nMB,nMH,nMB,nMW],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(120),m3h1x16(:,373),heltab2x16(:,:,373))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(374),h0tab(:,374),[16,1,8,4,2],[nMW,nMB,nMZ,nMB,nMW],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(121),m3h1x16(:,374),heltab2x16(:,:,374))
  Gcoeff(:)%j = (c(292)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(375),h0tab(:,375),[16,1,8,4,2],[nMT,nMH,nMB,0,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(122),ngH,m3h1x16(:,375),heltab2x16(:,:,375))
  call Hloop_A_Q(ntryL,G0H16(122),16,nMT,G1H16(255),n2h16(165))
  Gcoeff(:)%j = (c(292)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(376),h0tab(:,376),[16,1,8,4,2],[nMT,nMZ,nMB,0,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(122),ngH,m3h1x16(:,376),heltab2x16(:,:,376))
  call Hloop_A_Q(ntryL,G0H16(122),16,nMT,G1H16(256),n2h16(166))
  Gcoeff(:)%j = (-(c(294)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(377),h0tab(:,377),[16,1,8,4,2],[nMT,nMH,nMB,nMZ,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(122),ngH,m3h1x16(:,377),heltab2x16(:,:,377))
  call Hloop_A_Q(ntryL,G0H16(122),16,nMT,G1H16(257),n2h16(167))
  Gcoeff(:)%j = (-(c(294)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(378),h0tab(:,378),[16,1,8,4,2],[nMT,nMZ,nMB,nMZ,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(122),ngH,m3h1x16(:,378),heltab2x16(:,:,378))
  call Hloop_A_Q(ntryL,G0H16(122),16,nMT,G1H16(258),n2h16(168))
  Gcoeff(:)%j = (-(c(296)*M(2,:)%j)+c(295)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(379),h0tab(:,379),[16,1,8,4,2],[nMT,nMH,nMB,0,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(122),ngH,m3h1x16(:,379),heltab2x16(:,:,379))
  call Hloop_A_Q(ntryL,G0H16(122),16,nMT,G1H16(259),n2h16(169))
  Gcoeff(:)%j = (-(c(296)*M(2,:)%j)+c(295)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(380),h0tab(:,380),[16,1,8,4,2],[nMT,nMZ,nMB,0,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(122),ngH,m3h1x16(:,380),heltab2x16(:,:,380))
  call Hloop_A_Q(ntryL,G0H16(122),16,nMT,G1H16(260),n2h16(170))
  Gcoeff(:)%j = (c(292)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(381),h0tab(:,381),[16,1,8,4,2],[nMT,0,nMB,nMH,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(122),ngH,m3h1x16(:,381),heltab2x16(:,:,381))
  call Hloop_A_Q(ntryL,G0H16(122),16,nMT,G1H16(261),n2h16(171))
  Gcoeff(:)%j = (c(292)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(382),h0tab(:,382),[16,1,8,4,2],[nMT,0,nMB,nMZ,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(122),ngH,m3h1x16(:,382),heltab2x16(:,:,382))
  call Hloop_A_Q(ntryL,G0H16(122),16,nMT,G1H16(262),n2h16(172))
  Gcoeff(:)%j = (-(c(294)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(383),h0tab(:,383),[16,1,8,4,2],[nMT,nMZ,nMB,nMH,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(122),ngH,m3h1x16(:,383),heltab2x16(:,:,383))
  call Hloop_A_Q(ntryL,G0H16(122),16,nMT,G1H16(263),n2h16(173))
  Gcoeff(:)%j = (-(c(294)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(384),h0tab(:,384),[16,1,8,4,2],[nMT,nMZ,nMB,nMZ,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(122),ngH,m3h1x16(:,384),heltab2x16(:,:,384))
  call Hloop_A_Q(ntryL,G0H16(122),16,nMT,G1H16(264),n2h16(174))
  Gcoeff(:)%j = (-(c(296)*M(2,:)%j)+c(295)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(385),h0tab(:,385),[16,1,8,4,2],[nMT,0,nMB,nMH,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(122),ngH,m3h1x16(:,385),heltab2x16(:,:,385))
  call Hloop_A_Q(ntryL,G0H16(122),16,nMT,G1H16(265),n2h16(175))
  Gcoeff(:)%j = (-(c(296)*M(2,:)%j)+c(295)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(386),h0tab(:,386),[16,1,8,4,2],[nMT,0,nMB,nMZ,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(122),ngH,m3h1x16(:,386),heltab2x16(:,:,386))
  call Hloop_A_Q(ntryL,G0H16(122),16,nMT,G1H16(266),n2h16(176))
  Gcoeff(:)%j = (-(c(235)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(387),h0tab(:,387),[16,1,8,4,2],[nMW,nMB,0,nMB,nMW],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(122),m3h1x16(:,387),heltab2x16(:,:,387))
  Gcoeff(:)%j = (-(c(240)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(388),h0tab(:,388),[16,1,8,4,2],[nMW,nMB,nMZ,nMB,nMW],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(123),m3h1x16(:,388),heltab2x16(:,:,388))
  Gcoeff(:)%j = (c(107)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(389),h0tab(:,389),[16,1,8,4,2],[nMH,nMT,nMW,nMT,nMH],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(124),m3h1x16(:,389),heltab2x16(:,:,389))
  Gcoeff(:)%j = (-(c(106)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(390),h0tab(:,390),[16,1,8,4,2],[nMZ,nMT,nMW,nMT,nMZ],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(125),m3h1x16(:,390),heltab2x16(:,:,390))
  Gcoeff(:)%j = (c(241)*M(2,:)%j-c(242)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(391),h0tab(:,391),[16,1,8,4,2],[nMW,nMB,0,nMB,nMW],5,0)
  call Hloop_SS_S(ntryL,G0H16(62),ex5(:),G0H16(126),m3h1x16(:,391),heltab2x16(:,:,391))
  Gcoeff(:)%j = (-(c(164)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(392),h0tab(:,392),[16,1,8,4,2],[nMZ,nMT,nMW,nMT,nMZ],5,0)
  call Hloop_VT_S(ntryL,G0H16(62),0,ex5(:),16,G1H16(267),m3h1x16(:,392),heltab2x16(:,:,392))
  Gcoeff(:)%j = (c(77)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(393),h0tab(:,393),[16,1,8,4,2],[nMW,nMB,nMH,nMB,nMW],5,0)
  call Hloop_VT_S(ntryL,G0H16(62),0,ex5(:),16,G1H16(268),m3h1x16(:,393),heltab2x16(:,:,393))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(394),h0tab(:,394),[16,1,8,4,2],[nMW,nMB,nMZ,nMB,nMW],5,0)
  call Hloop_VT_S(ntryL,G0H16(62),0,ex5(:),16,G1H16(269),m3h1x16(:,394),heltab2x16(:,:,394))
  Gcoeff(:)%j = (-(c(164)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(395),h0tab(:,395),[16,1,8,4,2],[nMZ,nMT,nMW,nMT,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(62),0,ex5(:),16,G1H16(270),m3h1x16(:,395),heltab2x16(:,:,395))
  Gcoeff(:)%j = (c(77)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(396),h0tab(:,396),[16,1,8,4,2],[nMW,nMB,nMH,nMB,nMW],5,0)
  call Hloop_ST_V(ntryL,G0H16(62),0,ex5(:),16,G1H16(271),m3h1x16(:,396),heltab2x16(:,:,396))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(397),h0tab(:,397),[16,1,8,4,2],[nMW,nMB,nMZ,nMB,nMW],5,0)
  call Hloop_ST_V(ntryL,G0H16(62),0,ex5(:),16,G1H16(272),m3h1x16(:,397),heltab2x16(:,:,397))
  Gcoeff(:)%j = (c(469)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(398),h0tab(:,398),[16,1,8,4,2],[nMT,0,nMB,0,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(127),ngH,m3h1x16(:,398),heltab2x16(:,:,398))
  call Hloop_A_Q(ntryL,G0H16(127),16,nMT,G1H16(273),n2h16(177))
  Gcoeff(:)%j = (-(c(472)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(399),h0tab(:,399),[16,1,8,4,2],[nMT,0,nMB,nMZ,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(127),ngH,m3h1x16(:,399),heltab2x16(:,:,399))
  call Hloop_A_Q(ntryL,G0H16(127),16,nMT,G1H16(274),n2h16(178))
  Gcoeff(:)%j = (-(c(472)*M(3,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(400),h0tab(:,400),[16,1,8,4,2],[nMT,nMZ,nMB,0,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(127),ngH,m3h1x16(:,400),heltab2x16(:,:,400))
  call Hloop_A_Q(ntryL,G0H16(127),16,nMT,G1H16(275),n2h16(179))
  Gcoeff(:)%j = (c(474)*M(3,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(401),h0tab(:,401),[16,1,8,4,2],[nMT,nMZ,nMB,nMZ,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(127),ngH,m3h1x16(:,401),heltab2x16(:,:,401))
  call Hloop_A_Q(ntryL,G0H16(127),16,nMT,G1H16(276),n2h16(180))
  Gcoeff(:)%j = (-(c(479)*M(2,:)%j)+c(478)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(402),h0tab(:,402),[16,1,8,4,2],[nMT,0,nMB,0,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(127),ngH,m3h1x16(:,402),heltab2x16(:,:,402))
  call Hloop_A_Q(ntryL,G0H16(127),16,nMT,G1H16(277),n2h16(181))
  Gcoeff(:)%j = (-(c(479)*M(2,:)%j)+c(478)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(403),h0tab(:,403),[16,1,8,4,2],[nMT,0,nMB,0,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(127),ngH,m3h1x16(:,403),heltab2x16(:,:,403))
  call Hloop_A_Q(ntryL,G0H16(127),16,nMT,G1H16(278),n2h16(182))
  Gcoeff(:)%j = (c(484)*M(2,:)%j-c(483)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(404),h0tab(:,404),[16,1,8,4,2],[nMT,nMZ,nMB,0,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(127),ngH,m3h1x16(:,404),heltab2x16(:,:,404))
  call Hloop_A_Q(ntryL,G0H16(127),16,nMT,G1H16(279),n2h16(183))
  Gcoeff(:)%j = (c(484)*M(2,:)%j-c(483)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(405),h0tab(:,405),[16,1,8,4,2],[nMT,0,nMB,nMZ,nMT],5,0)
  call Hloop_AS_Q(ntryL,G0H16(62),ex5(:),G0H16(127),ngH,m3h1x16(:,405),heltab2x16(:,:,405))
  call Hloop_A_Q(ntryL,G0H16(127),16,nMT,G1H16(280),n2h16(184))
  Gcoeff(:)%j = (-(c(311)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(406),h0tab(:,406),[16,1,8,4,2],[nMW,nMB,0,nMB,nMW],5,0)
  call Hloop_VT_S(ntryL,G0H16(62),0,ex5(:),16,G1H16(281),m3h1x16(:,406),heltab2x16(:,:,406))
  Gcoeff(:)%j = (-(c(194)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(127),m0h(407),h0tab(:,407),[16,1,8,4,2],[nMZ,nMT,nMW,nMT,nMZ],5,0)
  call Hloop_VT_S(ntryL,G0H16(127),0,ex5(:),16,G1H16(282),m3h1x16(:,407),heltab2x16(:,:,407))
  Gcoeff(:)%j = (-(c(316)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(408),h0tab(:,408),[16,1,8,4,2],[nMW,nMB,nMZ,nMB,nMW],5,0)
  call Hloop_VT_S(ntryL,G0H16(62),0,ex5(:),16,G1H16(283),m3h1x16(:,408),heltab2x16(:,:,408))
  Gcoeff(:)%j = (c(319)*M(2,:)%j-c(320)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(127),m0h(409),h0tab(:,409),[16,1,8,4,2],[nMW,nMB,0,nMB,nMW],5,0)
  call Hloop_VT_S(ntryL,G0H16(127),0,ex5(:),16,G1H16(284),m3h1x16(:,409),heltab2x16(:,:,409))
  Gcoeff(:)%j = (-(c(311)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(410),h0tab(:,410),[16,1,8,4,2],[nMW,nMB,0,nMB,nMW],5,0)
  call Hloop_ST_V(ntryL,G0H16(62),0,ex5(:),16,G1H16(285),m3h1x16(:,410),heltab2x16(:,:,410))
  Gcoeff(:)%j = (-(c(194)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(127),m0h(411),h0tab(:,411),[16,1,8,4,2],[nMZ,nMT,nMW,nMT,nMZ],5,0)
  call Hloop_ST_V(ntryL,G0H16(127),0,ex5(:),16,G1H16(286),m3h1x16(:,411),heltab2x16(:,:,411))
  Gcoeff(:)%j = (-(c(316)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(412),h0tab(:,412),[16,1,8,4,2],[nMW,nMB,nMZ,nMB,nMW],5,0)
  call Hloop_ST_V(ntryL,G0H16(62),0,ex5(:),16,G1H16(287),m3h1x16(:,412),heltab2x16(:,:,412))
  Gcoeff(:)%j = (c(319)*M(2,:)%j-c(320)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(127),m0h(413),h0tab(:,413),[16,1,8,4,2],[nMW,nMB,0,nMB,nMW],5,0)
  call Hloop_ST_V(ntryL,G0H16(127),0,ex5(:),16,G1H16(288),m3h1x16(:,413),heltab2x16(:,:,413))
  Gcoeff(:)%j = (-(c(318)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(414),h0tab(:,414),[16,1,8,4,2],[nMZ,nMT,nMW,nMT,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(127),m3h1x16(:,414),heltab2x16(:,:,414))
  Gcoeff(:)%j = (c(116)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(415),h0tab(:,415),[16,1,8,4,2],[nMW,nMB,nMH,nMB,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(128),m3h1x16(:,415),heltab2x16(:,:,415))
  Gcoeff(:)%j = (-(c(116)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(416),h0tab(:,416),[16,1,8,4,2],[nMW,nMB,nMZ,nMB,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(129),m3h1x16(:,416),heltab2x16(:,:,416))
  Gcoeff(:)%j = (-(c(383)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(417),h0tab(:,417),[16,1,8,4,2],[nMZ,nMT,nMW,nMT,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(130),m3h1x16(:,417),heltab2x16(:,:,417))
  Gcoeff(:)%j = (-(c(371)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(418),h0tab(:,418),[16,1,8,4,2],[nMW,nMB,0,nMB,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(131),m3h1x16(:,418),heltab2x16(:,:,418))
  Gcoeff(:)%j = (-(c(378)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(419),h0tab(:,419),[16,1,8,4,2],[nMW,nMB,nMZ,nMB,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(132),m3h1x16(:,419),heltab2x16(:,:,419))
  Gcoeff(:)%j = (c(386)*M(2,:)%j-c(387)*M(4,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(420),h0tab(:,420),[16,1,8,4,2],[nMW,nMB,0,nMB,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(62),ex5(:),G0H16(133),m3h1x16(:,420),heltab2x16(:,:,420))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(11),[G1H16(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(12),[G1H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(18),[G1H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(19),[G1H16(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(26),[G1H16(25),G1H16(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(28),[G1H16(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(27),[G1H16(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(12),[G0H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(13),[G0H16(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(38),[G1H16(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(42),[G1H16(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(20),[G0H16(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(51),[G1H16(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(52),[G1H16(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(57),[G1H16(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(58),[G1H16(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(29),[G0H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(70),[G1H16(69),G1H16(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(72),[G1H16(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(71),[G1H16(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(76),[G1H16(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(80),[G1H16(77)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(36),[G0H16(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(89),[G1H16(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(94),[G1H16(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(45),[G0H16(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(46),[G0H16(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(103),[G1H16(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(104),[G1H16(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(107),[G1H16(105)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(110),[G1H16(108)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(51),[G0H16(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(119),[G1H16(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(124),[G1H16(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(60),[G0H16(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(61),[G0H16(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(133),[G1H16(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(134),[G1H16(130)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(137),[G1H16(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(140),[G1H16(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(66),[G0H16(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(77),[G0H16(72)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(78),[G0H16(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(150),[G1H16(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(154),[G1H16(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(85),[G0H16(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(94),[G0H16(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(164),[G1H16(161)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(168),[G1H16(165)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(101),[G0H16(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(177),[G1H16(173)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(182),[G1H16(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(187),[G1H16(183)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(188),[G1H16(184)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(197),[G1H16(193)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(202),[G1H16(198)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(207),[G1H16(203)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(208),[G1H16(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(219),[G1H16(214)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(220),[G1H16(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(226),[G1H16(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(227),[G1H16(222)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(234),[G1H16(233),G1H16(228)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(236),[G1H16(229)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(235),[G1H16(230)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(110),[G0H16(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(246),[G1H16(243)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(250),[G1H16(247)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(117),[G0H16(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(259),[G1H16(255)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(260),[G1H16(256)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(265),[G1H16(261)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(266),[G1H16(262)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(126),[G0H16(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(278),[G1H16(277),G1H16(273)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(280),[G1H16(274)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(279),[G1H16(275)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(284),[G1H16(281)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(288),[G1H16(285)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(133),[G0H16(131)])
  call Hloop_AQ_S(ntryL,G1H16(1),ex3(:),G1H8(1),ngH,m3h2x8(:,1),heltab2x16(:,:,421))
  call Hloop_AQ_S(ntryL,G1H16(2),ex3(:),G1H8(2),ngH,m3h2x8(:,2),heltab2x16(:,:,422))
  call Hloop_AQ_S(ntryL,G1H16(3),ex3(:),G1H8(3),ngX,m3h2x8(:,3),heltab2x16(:,:,423))
  call Hloop_AQ_S(ntryL,G1H16(4),ex3(:),G1H8(4),ngX,m3h2x8(:,4),heltab2x16(:,:,424))
  call Hloop_AQ_S(ntryL,G1H16(5),ex3(:),G1H8(5),ngPtb,m3h2x8(:,5),heltab2x16(:,:,425))
  call Hloop_AQ_S(ntryL,G1H16(11),ex3(:),G1H8(6),ngH,m3h2x8(:,6),heltab2x16(:,:,426))
  call Hloop_AQ_S(ntryL,G1H16(12),ex3(:),G1H8(7),ngX,m3h2x8(:,7),heltab2x16(:,:,427))
  call Hloop_AQ_S(ntryL,G1H16(8),ex3(:),G1H8(8),ngH,m3h2x8(:,8),heltab2x16(:,:,428))
  call Hloop_AQ_S(ntryL,G1H16(9),ex3(:),G1H8(9),ngX,m3h2x8(:,9),heltab2x16(:,:,429))
  call Hloop_AQ_S(ntryL,G1H16(10),ex3(:),G1H8(10),ngPtb,m3h2x8(:,10),heltab2x16(:,:,430))
  call Hloop_AQ_V(ntryL,G1H16(18),ex3(:),G1H8(11),m3h2x8(:,11),heltab2x16(:,:,431))
  call Hloop_AQ_V(ntryL,G1H16(19),ex3(:),G1H8(12),m3h2x8(:,12),heltab2x16(:,:,432))
  call Hloop_AQ_Z(ntryL,G1H16(15),ex3(:),G1H8(13),ngZd,m3h2x8(:,13),heltab2x16(:,:,433))
  call Hloop_AQ_Z(ntryL,G1H16(16),ex3(:),G1H8(14),ngZd,m3h2x8(:,14),heltab2x16(:,:,434))
  call Hloop_AQ_W(ntryL,G1H16(17),ex3(:),G1H8(15),m3h2x8(:,15),heltab2x16(:,:,435))
  call Hloop_AQ_V(ntryL,G1H16(26),ex3(:),G1H8(16),m3h2x8(:,16),heltab2x16(:,:,436))
  call Hloop_AQ_V(ntryL,G1H16(28),ex3(:),G1H8(17),m3h2x8(:,17),heltab2x16(:,:,437))
  call Hloop_AQ_Z(ntryL,G1H16(27),ex3(:),G1H8(18),ngZd,m3h2x8(:,18),heltab2x16(:,:,438))
  call Hloop_AQ_Z(ntryL,G1H16(23),ex3(:),G1H8(19),ngZd,m3h2x8(:,19),heltab2x16(:,:,439))
  call Hloop_AQ_W(ntryL,G1H16(24),ex3(:),G1H8(20),m3h2x8(:,20),heltab2x16(:,:,440))
  call Hloop_SA_Q(ntryL,G0H16(2),ex2(:),G0H8(1),ngH,m3h2x8(:,21),heltab2x16(:,:,441))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(21),n2h8(1))
  call Hloop_SA_Q(ntryL,G0H16(3),ex2(:),G0H8(1),ngH,m3h2x8(:,22),heltab2x16(:,:,442))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(22),n2h8(2))
  call Hloop_SA_Q(ntryL,G0H16(4),ex2(:),G0H8(1),ngX,m3h2x8(:,23),heltab2x16(:,:,443))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(23),n2h8(3))
  call Hloop_SA_Q(ntryL,G0H16(5),ex2(:),G0H8(1),ngX,m3h2x8(:,24),heltab2x16(:,:,444))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(24),n2h8(4))
  call Hloop_SA_Q(ntryL,G0H16(6),ex2(:),G0H8(1),ngPtb,m3h2x8(:,25),heltab2x16(:,:,445))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMB,G1H8(25),n2h8(5))
  call Hloop_SA_Q(ntryL,G1H16(29),ex2(:),G1H8(26),ngX,m3h2x8(:,26),heltab2x16(:,:,446))
  call Hloop_A_Q(ntryL,G1H8(26),18,nMT,G2H8(1),n2h8(6))
  call Hloop_SA_Q(ntryL,G1H16(30),ex2(:),G1H8(26),ngX,m3h2x8(:,27),heltab2x16(:,:,447))
  call Hloop_A_Q(ntryL,G1H8(26),18,nMT,G2H8(2),n2h8(7))
  call Hloop_SA_Q(ntryL,G1H16(31),ex2(:),G1H8(26),ngPtb,m3h2x8(:,28),heltab2x16(:,:,448))
  call Hloop_A_Q(ntryL,G1H8(26),18,nMB,G2H8(3),n2h8(8))
  call Hloop_ZA_Q(ntryL,G1H16(32),ex2(:),G1H8(26),ngZu,m3h2x8(:,29),heltab2x16(:,:,449))
  call Hloop_A_Q(ntryL,G1H8(26),18,nMT,G2H8(4),n2h8(9))
  call Hloop_ZA_Q(ntryL,G1H16(33),ex2(:),G1H8(26),ngZu,m3h2x8(:,30),heltab2x16(:,:,450))
  call Hloop_A_Q(ntryL,G1H8(26),18,nMT,G2H8(5),n2h8(10))
  call Hloop_WA_Q(ntryL,G1H16(34),ex2(:),G1H8(26),m3h2x8(:,31),heltab2x16(:,:,451))
  call Hloop_A_Q(ntryL,G1H8(26),18,nMB,G2H8(6),n2h8(11))
  call Hloop_SA_Q(ntryL,G0H16(12),ex2(:),G0H8(1),ngH,m3h2x8(:,32),heltab2x16(:,:,452))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(26),n2h8(12))
  call Hloop_SA_Q(ntryL,G0H16(13),ex2(:),G0H8(1),ngX,m3h2x8(:,33),heltab2x16(:,:,453))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(27),n2h8(13))
  call Hloop_SA_Q(ntryL,G0H16(9),ex2(:),G0H8(1),ngH,m3h2x8(:,34),heltab2x16(:,:,454))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(28),n2h8(14))
  call Hloop_SA_Q(ntryL,G0H16(10),ex2(:),G0H8(1),ngX,m3h2x8(:,35),heltab2x16(:,:,455))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(29),n2h8(15))
  call Hloop_SA_Q(ntryL,G0H16(11),ex2(:),G0H8(1),ngPtb,m3h2x8(:,36),heltab2x16(:,:,456))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMB,G1H8(30),n2h8(16))
  call Hloop_ZA_Q(ntryL,G0H16(14),ex2(:),G0H8(1),ngZu,m3h2x8(:,37),heltab2x16(:,:,457))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(31),n2h8(17))
  call Hloop_ZA_Q(ntryL,G0H16(15),ex2(:),G0H8(1),ngZu,m3h2x8(:,38),heltab2x16(:,:,458))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(32),n2h8(18))
  call Hloop_WA_Q(ntryL,G0H16(16),ex2(:),G0H8(1),m3h2x8(:,39),heltab2x16(:,:,459))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMB,G1H8(33),n2h8(19))
  call Hloop_SA_Q(ntryL,G1H16(38),ex2(:),G1H8(34),ngX,m3h2x8(:,40),heltab2x16(:,:,460))
  call Hloop_A_Q(ntryL,G1H8(34),18,nMT,G2H8(7),n2h8(20))
  call Hloop_SA_Q(ntryL,G1H16(36),ex2(:),G1H8(34),ngX,m3h2x8(:,41),heltab2x16(:,:,461))
  call Hloop_A_Q(ntryL,G1H8(34),18,nMT,G2H8(8),n2h8(21))
  call Hloop_SA_Q(ntryL,G1H16(37),ex2(:),G1H8(34),ngPtb,m3h2x8(:,42),heltab2x16(:,:,462))
  call Hloop_A_Q(ntryL,G1H8(34),18,nMB,G2H8(9),n2h8(22))
  call Hloop_ZA_Q(ntryL,G1H16(42),ex2(:),G1H8(34),ngZu,m3h2x8(:,43),heltab2x16(:,:,463))
  call Hloop_A_Q(ntryL,G1H8(34),18,nMT,G2H8(10),n2h8(23))
  call Hloop_ZA_Q(ntryL,G1H16(40),ex2(:),G1H8(34),ngZu,m3h2x8(:,44),heltab2x16(:,:,464))
  call Hloop_A_Q(ntryL,G1H8(34),18,nMT,G2H8(11),n2h8(24))
  call Hloop_WA_Q(ntryL,G1H16(41),ex2(:),G1H8(34),m3h2x8(:,45),heltab2x16(:,:,465))
  call Hloop_A_Q(ntryL,G1H8(34),18,nMB,G2H8(12),n2h8(25))
  call Hloop_ZA_Q(ntryL,G0H16(20),ex2(:),G0H8(1),ngZu,m3h2x8(:,46),heltab2x16(:,:,466))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(34),n2h8(26))
  call Hloop_ZA_Q(ntryL,G0H16(18),ex2(:),G0H8(1),ngZu,m3h2x8(:,47),heltab2x16(:,:,467))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(35),n2h8(27))
  call Hloop_WA_Q(ntryL,G0H16(19),ex2(:),G0H8(1),m3h2x8(:,48),heltab2x16(:,:,468))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMB,G1H8(36),n2h8(28))
  call Hloop_AQ_S(ntryL,G1H16(43),ex3(:),G1H8(37),ngH,m3h2x8(:,49),heltab2x16(:,:,469))
  call Hloop_AQ_S(ntryL,G1H16(44),ex3(:),G1H8(38),ngX,m3h2x8(:,50),heltab2x16(:,:,470))
  call Hloop_AQ_S(ntryL,G1H16(45),ex3(:),G1H8(39),ngH,m3h2x8(:,51),heltab2x16(:,:,471))
  call Hloop_AQ_S(ntryL,G1H16(46),ex3(:),G1H8(40),ngX,m3h2x8(:,52),heltab2x16(:,:,472))
  call Hloop_SQ_A(ntryL,G0H16(21),ex3(:),G0H8(1),ngH,m3h2x8(:,53),heltab2x16(:,:,473))
  call Hloop_Q_A(ntryL,G0H8(1),20,nMB,G1H8(41),n2h8(29))
  call Hloop_SQ_A(ntryL,G0H16(22),ex3(:),G0H8(1),ngX,m3h2x8(:,54),heltab2x16(:,:,474))
  call Hloop_Q_A(ntryL,G0H8(1),20,nMB,G1H8(42),n2h8(30))
  call Hloop_SQ_A(ntryL,G0H16(23),ex3(:),G0H8(1),ngPtb,m3h2x8(:,55),heltab2x16(:,:,475))
  call Hloop_Q_A(ntryL,G0H8(1),20,nMT,G1H8(43),n2h8(31))
  call Hloop_SQ_A(ntryL,G0H16(24),ex3(:),G0H8(1),ngPtb,m3h2x8(:,56),heltab2x16(:,:,476))
  call Hloop_Q_A(ntryL,G0H8(1),20,nMT,G1H8(44),n2h8(32))
  call Hloop_AQ_V(ntryL,G1H16(51),ex3(:),G1H8(45),m3h2x8(:,57),heltab2x16(:,:,477))
  call Hloop_AQ_V(ntryL,G1H16(52),ex3(:),G1H8(46),m3h2x8(:,58),heltab2x16(:,:,478))
  call Hloop_AQ_Z(ntryL,G1H16(49),ex3(:),G1H8(47),ngZd,m3h2x8(:,59),heltab2x16(:,:,479))
  call Hloop_AQ_Z(ntryL,G1H16(50),ex3(:),G1H8(48),ngZd,m3h2x8(:,60),heltab2x16(:,:,480))
  call Hloop_AQ_S(ntryL,G1H16(57),ex3(:),G1H8(49),ngH,m3h2x8(:,61),heltab2x16(:,:,481))
  call Hloop_AQ_S(ntryL,G1H16(58),ex3(:),G1H8(50),ngX,m3h2x8(:,62),heltab2x16(:,:,482))
  call Hloop_AQ_S(ntryL,G1H16(55),ex3(:),G1H8(51),ngH,m3h2x8(:,63),heltab2x16(:,:,483))
  call Hloop_AQ_S(ntryL,G1H16(56),ex3(:),G1H8(52),ngX,m3h2x8(:,64),heltab2x16(:,:,484))
  call Hloop_SQ_A(ntryL,G1H16(59),ex3(:),G1H8(53),ngX,m3h2x8(:,65),heltab2x16(:,:,485))
  call Hloop_Q_A(ntryL,G1H8(53),20,nMB,G2H8(13),n2h8(33))
  call Hloop_SQ_A(ntryL,G1H16(60),ex3(:),G1H8(53),ngPtb,m3h2x8(:,66),heltab2x16(:,:,486))
  call Hloop_Q_A(ntryL,G1H8(53),20,nMT,G2H8(14),n2h8(34))
  call Hloop_SQ_A(ntryL,G1H16(61),ex3(:),G1H8(53),ngPtb,m3h2x8(:,67),heltab2x16(:,:,487))
  call Hloop_Q_A(ntryL,G1H8(53),20,nMT,G2H8(15),n2h8(35))
  call Hloop_ZQ_A(ntryL,G1H16(62),ex3(:),G1H8(53),ngZd,m3h2x8(:,68),heltab2x16(:,:,488))
  call Hloop_Q_A(ntryL,G1H8(53),20,nMB,G2H8(16),n2h8(36))
  call Hloop_WQ_A(ntryL,G1H16(63),ex3(:),G1H8(53),m3h2x8(:,69),heltab2x16(:,:,489))
  call Hloop_Q_A(ntryL,G1H8(53),20,nMT,G2H8(17),n2h8(37))
  call Hloop_WQ_A(ntryL,G1H16(64),ex3(:),G1H8(53),m3h2x8(:,70),heltab2x16(:,:,490))
  call Hloop_Q_A(ntryL,G1H8(53),20,nMT,G2H8(18),n2h8(38))
  call Hloop_SQ_A(ntryL,G0H16(29),ex3(:),G0H8(1),ngPtb,m3h2x8(:,71),heltab2x16(:,:,491))
  call Hloop_Q_A(ntryL,G0H8(1),20,nMT,G1H8(53),n2h8(39))
  call Hloop_SQ_A(ntryL,G0H16(26),ex3(:),G0H8(1),ngPtb,m3h2x8(:,72),heltab2x16(:,:,492))
  call Hloop_Q_A(ntryL,G0H8(1),20,nMT,G1H8(54),n2h8(40))
  call Hloop_SQ_A(ntryL,G0H16(27),ex3(:),G0H8(1),ngH,m3h2x8(:,73),heltab2x16(:,:,493))
  call Hloop_Q_A(ntryL,G0H8(1),20,nMB,G1H8(55),n2h8(41))
  call Hloop_SQ_A(ntryL,G0H16(28),ex3(:),G0H8(1),ngX,m3h2x8(:,74),heltab2x16(:,:,494))
  call Hloop_Q_A(ntryL,G0H8(1),20,nMB,G1H8(56),n2h8(42))
  call Hloop_AQ_V(ntryL,G1H16(70),ex3(:),G1H8(57),m3h2x8(:,75),heltab2x16(:,:,495))
  call Hloop_AQ_Z(ntryL,G1H16(72),ex3(:),G1H8(58),ngZd,m3h2x8(:,76),heltab2x16(:,:,496))
  call Hloop_AQ_V(ntryL,G1H16(71),ex3(:),G1H8(59),m3h2x8(:,77),heltab2x16(:,:,497))
  call Hloop_AQ_Z(ntryL,G1H16(68),ex3(:),G1H8(60),ngZd,m3h2x8(:,78),heltab2x16(:,:,498))
  call Hloop_ZQ_A(ntryL,G0H16(30),ex3(:),G0H8(1),ngZd,m3h2x8(:,79),heltab2x16(:,:,499))
  call Hloop_Q_A(ntryL,G0H8(1),20,nMB,G1H8(61),n2h8(43))
  call Hloop_WQ_A(ntryL,G0H16(31),ex3(:),G0H8(1),m3h2x8(:,80),heltab2x16(:,:,500))
  call Hloop_Q_A(ntryL,G0H8(1),20,nMT,G1H8(62),n2h8(44))
  call Hloop_WQ_A(ntryL,G0H16(32),ex3(:),G0H8(1),m3h2x8(:,81),heltab2x16(:,:,501))
  call Hloop_Q_A(ntryL,G0H8(1),20,nMT,G1H8(63),n2h8(45))
  call Hloop_SQ_A(ntryL,G1H16(76),ex3(:),G1H8(64),ngPtb,m3h2x8(:,82),heltab2x16(:,:,502))
  call Hloop_Q_A(ntryL,G1H8(64),20,nMT,G2H8(19),n2h8(46))
  call Hloop_SQ_A(ntryL,G1H16(74),ex3(:),G1H8(64),ngX,m3h2x8(:,83),heltab2x16(:,:,503))
  call Hloop_Q_A(ntryL,G1H8(64),20,nMB,G2H8(20),n2h8(47))
  call Hloop_SQ_A(ntryL,G1H16(75),ex3(:),G1H8(64),ngPtb,m3h2x8(:,84),heltab2x16(:,:,504))
  call Hloop_Q_A(ntryL,G1H8(64),20,nMT,G2H8(21),n2h8(48))
  call Hloop_WQ_A(ntryL,G1H16(80),ex3(:),G1H8(64),m3h2x8(:,85),heltab2x16(:,:,505))
  call Hloop_Q_A(ntryL,G1H8(64),20,nMT,G2H8(22),n2h8(49))
  call Hloop_ZQ_A(ntryL,G1H16(78),ex3(:),G1H8(64),ngZd,m3h2x8(:,86),heltab2x16(:,:,506))
  call Hloop_Q_A(ntryL,G1H8(64),20,nMB,G2H8(23),n2h8(50))
  call Hloop_WQ_A(ntryL,G1H16(79),ex3(:),G1H8(64),m3h2x8(:,87),heltab2x16(:,:,507))
  call Hloop_Q_A(ntryL,G1H8(64),20,nMT,G2H8(24),n2h8(51))
  call Hloop_ZQ_A(ntryL,G0H16(33),ex3(:),G0H8(1),ngZd,m3h2x8(:,88),heltab2x16(:,:,508))
  call Hloop_Q_A(ntryL,G0H8(1),20,nMB,G1H8(64),n2h8(52))
  call Hloop_WQ_A(ntryL,G0H16(36),ex3(:),G0H8(1),m3h2x8(:,89),heltab2x16(:,:,509))
  call Hloop_Q_A(ntryL,G0H8(1),20,nMT,G1H8(65),n2h8(53))
  call Hloop_WQ_A(ntryL,G0H16(35),ex3(:),G0H8(1),m3h2x8(:,90),heltab2x16(:,:,510))
  call Hloop_Q_A(ntryL,G0H8(1),20,nMT,G1H8(66),n2h8(54))
  call Hloop_QA_S(ntryL,G1H16(81),ex2(:),G1H8(67),ngH,m3h2x8(:,91),heltab2x16(:,:,511))
  call Hloop_QA_S(ntryL,G1H16(82),ex2(:),G1H8(68),ngPtb,m3h2x8(:,92),heltab2x16(:,:,512))
  call Hloop_QA_S(ntryL,G1H16(83),ex2(:),G1H8(69),ngX,m3h2x8(:,93),heltab2x16(:,:,513))
  call Hloop_QA_S(ntryL,G1H16(84),ex2(:),G1H8(70),ngPtb,m3h2x8(:,94),heltab2x16(:,:,514))
  call Hloop_SA_Q(ntryL,G0H16(37),ex2(:),G0H8(1),ngH,m3h2x8(:,95),heltab2x16(:,:,515))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(71),n2h8(55))
  call Hloop_SA_Q(ntryL,G0H16(38),ex2(:),G0H8(1),ngH,m3h2x8(:,96),heltab2x16(:,:,516))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(72),n2h8(56))
  call Hloop_SA_Q(ntryL,G0H16(39),ex2(:),G0H8(1),ngX,m3h2x8(:,97),heltab2x16(:,:,517))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(73),n2h8(57))
  call Hloop_SA_Q(ntryL,G0H16(40),ex2(:),G0H8(1),ngX,m3h2x8(:,98),heltab2x16(:,:,518))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(74),n2h8(58))
  call Hloop_QA_S(ntryL,G1H16(89),ex2(:),G1H8(75),ngPtb,m3h2x8(:,99),heltab2x16(:,:,519))
  call Hloop_QA_S(ntryL,G1H16(86),ex2(:),G1H8(76),ngPtb,m3h2x8(:,100),heltab2x16(:,:,520))
  call Hloop_QA_S(ntryL,G1H16(87),ex2(:),G1H8(77),ngH,m3h2x8(:,101),heltab2x16(:,:,521))
  call Hloop_QA_S(ntryL,G1H16(88),ex2(:),G1H8(78),ngX,m3h2x8(:,102),heltab2x16(:,:,522))
  call Hloop_QA_V(ntryL,G1H16(94),ex2(:),G1H8(79),m3h2x8(:,103),heltab2x16(:,:,523))
  call Hloop_QA_Z(ntryL,G1H16(91),ex2(:),G1H8(80),ngZu,m3h2x8(:,104),heltab2x16(:,:,524))
  call Hloop_QA_W(ntryL,G1H16(92),ex2(:),G1H8(81),m3h2x8(:,105),heltab2x16(:,:,525))
  call Hloop_QA_W(ntryL,G1H16(93),ex2(:),G1H8(82),m3h2x8(:,106),heltab2x16(:,:,526))
  call Hloop_SA_Q(ntryL,G1H16(95),ex2(:),G1H8(83),ngX,m3h2x8(:,107),heltab2x16(:,:,527))
  call Hloop_A_Q(ntryL,G1H8(83),18,nMT,G2H8(25),n2h8(59))
  call Hloop_SA_Q(ntryL,G1H16(96),ex2(:),G1H8(83),ngX,m3h2x8(:,108),heltab2x16(:,:,528))
  call Hloop_A_Q(ntryL,G1H8(83),18,nMT,G2H8(26),n2h8(60))
  call Hloop_ZA_Q(ntryL,G1H16(97),ex2(:),G1H8(83),ngZu,m3h2x8(:,109),heltab2x16(:,:,529))
  call Hloop_A_Q(ntryL,G1H8(83),18,nMT,G2H8(27),n2h8(61))
  call Hloop_ZA_Q(ntryL,G1H16(98),ex2(:),G1H8(83),ngZu,m3h2x8(:,110),heltab2x16(:,:,530))
  call Hloop_A_Q(ntryL,G1H8(83),18,nMT,G2H8(28),n2h8(62))
  call Hloop_SA_Q(ntryL,G0H16(45),ex2(:),G0H8(1),ngH,m3h2x8(:,111),heltab2x16(:,:,531))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(83),n2h8(63))
  call Hloop_SA_Q(ntryL,G0H16(46),ex2(:),G0H8(1),ngX,m3h2x8(:,112),heltab2x16(:,:,532))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(84),n2h8(64))
  call Hloop_SA_Q(ntryL,G0H16(43),ex2(:),G0H8(1),ngH,m3h2x8(:,113),heltab2x16(:,:,533))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(85),n2h8(65))
  call Hloop_SA_Q(ntryL,G0H16(44),ex2(:),G0H8(1),ngX,m3h2x8(:,114),heltab2x16(:,:,534))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(86),n2h8(66))
  call Hloop_QA_V(ntryL,G1H16(103),ex2(:),G1H8(87),m3h2x8(:,115),heltab2x16(:,:,535))
  call Hloop_QA_W(ntryL,G1H16(104),ex2(:),G1H8(88),m3h2x8(:,116),heltab2x16(:,:,536))
  call Hloop_QA_Z(ntryL,G1H16(101),ex2(:),G1H8(89),ngZu,m3h2x8(:,117),heltab2x16(:,:,537))
  call Hloop_QA_W(ntryL,G1H16(102),ex2(:),G1H8(90),m3h2x8(:,118),heltab2x16(:,:,538))
  call Hloop_ZA_Q(ntryL,G0H16(47),ex2(:),G0H8(1),ngZu,m3h2x8(:,119),heltab2x16(:,:,539))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(91),n2h8(67))
  call Hloop_ZA_Q(ntryL,G0H16(48),ex2(:),G0H8(1),ngZu,m3h2x8(:,120),heltab2x16(:,:,540))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(92),n2h8(68))
  call Hloop_SA_Q(ntryL,G1H16(107),ex2(:),G1H8(93),ngX,m3h2x8(:,121),heltab2x16(:,:,541))
  call Hloop_A_Q(ntryL,G1H8(93),18,nMT,G2H8(29),n2h8(69))
  call Hloop_SA_Q(ntryL,G1H16(106),ex2(:),G1H8(93),ngX,m3h2x8(:,122),heltab2x16(:,:,542))
  call Hloop_A_Q(ntryL,G1H8(93),18,nMT,G2H8(30),n2h8(70))
  call Hloop_ZA_Q(ntryL,G1H16(110),ex2(:),G1H8(93),ngZu,m3h2x8(:,123),heltab2x16(:,:,543))
  call Hloop_A_Q(ntryL,G1H8(93),18,nMT,G2H8(31),n2h8(71))
  call Hloop_ZA_Q(ntryL,G1H16(109),ex2(:),G1H8(93),ngZu,m3h2x8(:,124),heltab2x16(:,:,544))
  call Hloop_A_Q(ntryL,G1H8(93),18,nMT,G2H8(32),n2h8(72))
  call Hloop_ZA_Q(ntryL,G0H16(51),ex2(:),G0H8(1),ngZu,m3h2x8(:,125),heltab2x16(:,:,545))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(93),n2h8(73))
  call Hloop_ZA_Q(ntryL,G0H16(50),ex2(:),G0H8(1),ngZu,m3h2x8(:,126),heltab2x16(:,:,546))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(94),n2h8(74))
  call Hloop_AQ_S(ntryL,G1H16(111),ex1(:),G1H8(95),ngH,m3h2x8(:,127),heltab2x16(:,:,547))
  call Hloop_AQ_S(ntryL,G1H16(112),ex1(:),G1H8(96),ngPbt,m3h2x8(:,128),heltab2x16(:,:,548))
  call Hloop_AQ_S(ntryL,G1H16(113),ex1(:),G1H8(97),ngX,m3h2x8(:,129),heltab2x16(:,:,549))
  call Hloop_AQ_S(ntryL,G1H16(114),ex1(:),G1H8(98),ngPbt,m3h2x8(:,130),heltab2x16(:,:,550))
  call Hloop_SQ_A(ntryL,G0H16(52),ex1(:),G0H8(1),ngH,m3h2x8(:,131),heltab2x16(:,:,551))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(99),n2h8(75))
  call Hloop_SQ_A(ntryL,G0H16(53),ex1(:),G0H8(1),ngH,m3h2x8(:,132),heltab2x16(:,:,552))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(100),n2h8(76))
  call Hloop_SQ_A(ntryL,G0H16(54),ex1(:),G0H8(1),ngX,m3h2x8(:,133),heltab2x16(:,:,553))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(101),n2h8(77))
  call Hloop_SQ_A(ntryL,G0H16(55),ex1(:),G0H8(1),ngX,m3h2x8(:,134),heltab2x16(:,:,554))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(102),n2h8(78))
  call Hloop_AQ_S(ntryL,G1H16(119),ex1(:),G1H8(103),ngPbt,m3h2x8(:,135),heltab2x16(:,:,555))
  call Hloop_AQ_S(ntryL,G1H16(116),ex1(:),G1H8(104),ngPbt,m3h2x8(:,136),heltab2x16(:,:,556))
  call Hloop_AQ_S(ntryL,G1H16(117),ex1(:),G1H8(105),ngH,m3h2x8(:,137),heltab2x16(:,:,557))
  call Hloop_AQ_S(ntryL,G1H16(118),ex1(:),G1H8(106),ngX,m3h2x8(:,138),heltab2x16(:,:,558))
  call Hloop_AQ_V(ntryL,G1H16(124),ex1(:),G1H8(107),m3h2x8(:,139),heltab2x16(:,:,559))
  call Hloop_AQ_Z(ntryL,G1H16(121),ex1(:),G1H8(108),ngZu,m3h2x8(:,140),heltab2x16(:,:,560))
  call Hloop_AQ_W(ntryL,G1H16(122),ex1(:),G1H8(109),m3h2x8(:,141),heltab2x16(:,:,561))
  call Hloop_AQ_W(ntryL,G1H16(123),ex1(:),G1H8(110),m3h2x8(:,142),heltab2x16(:,:,562))
  call Hloop_SQ_A(ntryL,G1H16(125),ex1(:),G1H8(111),ngX,m3h2x8(:,143),heltab2x16(:,:,563))
  call Hloop_Q_A(ntryL,G1H8(111),17,nMT,G2H8(33),n2h8(79))
  call Hloop_SQ_A(ntryL,G1H16(126),ex1(:),G1H8(111),ngX,m3h2x8(:,144),heltab2x16(:,:,564))
  call Hloop_Q_A(ntryL,G1H8(111),17,nMT,G2H8(34),n2h8(80))
  call Hloop_SQ_A(ntryL,G0H16(60),ex1(:),G0H8(1),ngH,m3h2x8(:,145),heltab2x16(:,:,565))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(111),n2h8(81))
  call Hloop_SQ_A(ntryL,G0H16(61),ex1(:),G0H8(1),ngX,m3h2x8(:,146),heltab2x16(:,:,566))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(112),n2h8(82))
  call Hloop_SQ_A(ntryL,G0H16(58),ex1(:),G0H8(1),ngH,m3h2x8(:,147),heltab2x16(:,:,567))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(113),n2h8(83))
  call Hloop_SQ_A(ntryL,G0H16(59),ex1(:),G0H8(1),ngX,m3h2x8(:,148),heltab2x16(:,:,568))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(114),n2h8(84))
  call Hloop_ZQ_A(ntryL,G1H16(127),ex1(:),G1H8(115),ngZu,m3h2x8(:,149),heltab2x16(:,:,569))
  call Hloop_Q_A(ntryL,G1H8(115),17,nMT,G2H8(35),n2h8(85))
  call Hloop_ZQ_A(ntryL,G1H16(128),ex1(:),G1H8(115),ngZu,m3h2x8(:,150),heltab2x16(:,:,570))
  call Hloop_Q_A(ntryL,G1H8(115),17,nMT,G2H8(36),n2h8(86))
  call Hloop_AQ_V(ntryL,G1H16(133),ex1(:),G1H8(115),m3h2x8(:,151),heltab2x16(:,:,571))
  call Hloop_AQ_W(ntryL,G1H16(134),ex1(:),G1H8(116),m3h2x8(:,152),heltab2x16(:,:,572))
  call Hloop_AQ_Z(ntryL,G1H16(131),ex1(:),G1H8(117),ngZu,m3h2x8(:,153),heltab2x16(:,:,573))
  call Hloop_AQ_W(ntryL,G1H16(132),ex1(:),G1H8(118),m3h2x8(:,154),heltab2x16(:,:,574))
  call Hloop_SQ_A(ntryL,G1H16(137),ex1(:),G1H8(119),ngX,m3h2x8(:,155),heltab2x16(:,:,575))
  call Hloop_Q_A(ntryL,G1H8(119),17,nMT,G2H8(37),n2h8(87))
  call Hloop_SQ_A(ntryL,G1H16(136),ex1(:),G1H8(119),ngX,m3h2x8(:,156),heltab2x16(:,:,576))
  call Hloop_Q_A(ntryL,G1H8(119),17,nMT,G2H8(38),n2h8(88))
  call Hloop_ZQ_A(ntryL,G0H16(1),ex1(:),G0H8(1),ngZu,m3h2x8(:,157),heltab2x16(:,:,577))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(119),n2h8(89))
  call Hloop_ZQ_A(ntryL,G0H16(63),ex1(:),G0H8(1),ngZu,m3h2x8(:,158),heltab2x16(:,:,578))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(120),n2h8(90))
  call Hloop_ZQ_A(ntryL,G1H16(140),ex1(:),G1H8(121),ngZu,m3h2x8(:,159),heltab2x16(:,:,579))
  call Hloop_Q_A(ntryL,G1H8(121),17,nMT,G2H8(39),n2h8(91))
  call Hloop_ZQ_A(ntryL,G1H16(139),ex1(:),G1H8(121),ngZu,m3h2x8(:,160),heltab2x16(:,:,580))
  call Hloop_Q_A(ntryL,G1H8(121),17,nMT,G2H8(40),n2h8(92))
  call Hloop_ZQ_A(ntryL,G0H16(66),ex1(:),G0H8(1),ngZu,m3h2x8(:,161),heltab2x16(:,:,581))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(121),n2h8(93))
  call Hloop_ZQ_A(ntryL,G0H16(65),ex1(:),G0H8(1),ngZu,m3h2x8(:,162),heltab2x16(:,:,582))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(122),n2h8(94))
  call Hloop_SQ_A(ntryL,G0H16(67),ex1(:),G0H8(1),ngH,m3h2x8(:,163),heltab2x16(:,:,583))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(123),n2h8(95))
  call Hloop_SQ_A(ntryL,G0H16(68),ex1(:),G0H8(1),ngH,m3h2x8(:,164),heltab2x16(:,:,584))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(124),n2h8(96))
  call Hloop_SQ_A(ntryL,G0H16(69),ex1(:),G0H8(1),ngX,m3h2x8(:,165),heltab2x16(:,:,585))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(125),n2h8(97))
  call Hloop_SQ_A(ntryL,G0H16(70),ex1(:),G0H8(1),ngX,m3h2x8(:,166),heltab2x16(:,:,586))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(126),n2h8(98))
  call Hloop_SQ_A(ntryL,G0H16(71),ex1(:),G0H8(1),ngPbt,m3h2x8(:,167),heltab2x16(:,:,587))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMB,G1H8(127),n2h8(99))
  call Hloop_SQ_A(ntryL,G1H16(141),ex1(:),G1H8(128),ngX,m3h2x8(:,168),heltab2x16(:,:,588))
  call Hloop_Q_A(ntryL,G1H8(128),17,nMT,G2H8(41),n2h8(100))
  call Hloop_SQ_A(ntryL,G1H16(142),ex1(:),G1H8(128),ngX,m3h2x8(:,169),heltab2x16(:,:,589))
  call Hloop_Q_A(ntryL,G1H8(128),17,nMT,G2H8(42),n2h8(101))
  call Hloop_SQ_A(ntryL,G1H16(143),ex1(:),G1H8(128),ngPbt,m3h2x8(:,170),heltab2x16(:,:,590))
  call Hloop_Q_A(ntryL,G1H8(128),17,nMB,G2H8(43),n2h8(102))
  call Hloop_SQ_A(ntryL,G0H16(77),ex1(:),G0H8(1),ngH,m3h2x8(:,171),heltab2x16(:,:,591))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(128),n2h8(103))
  call Hloop_SQ_A(ntryL,G0H16(78),ex1(:),G0H8(1),ngX,m3h2x8(:,172),heltab2x16(:,:,592))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(129),n2h8(104))
  call Hloop_SQ_A(ntryL,G0H16(74),ex1(:),G0H8(1),ngH,m3h2x8(:,173),heltab2x16(:,:,593))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(130),n2h8(105))
  call Hloop_SQ_A(ntryL,G0H16(75),ex1(:),G0H8(1),ngX,m3h2x8(:,174),heltab2x16(:,:,594))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(131),n2h8(106))
  call Hloop_SQ_A(ntryL,G0H16(76),ex1(:),G0H8(1),ngPbt,m3h2x8(:,175),heltab2x16(:,:,595))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMB,G1H8(132),n2h8(107))
  call Hloop_ZQ_A(ntryL,G1H16(144),ex1(:),G1H8(133),ngZu,m3h2x8(:,176),heltab2x16(:,:,596))
  call Hloop_Q_A(ntryL,G1H8(133),17,nMT,G2H8(44),n2h8(108))
  call Hloop_ZQ_A(ntryL,G1H16(145),ex1(:),G1H8(133),ngZu,m3h2x8(:,177),heltab2x16(:,:,597))
  call Hloop_Q_A(ntryL,G1H8(133),17,nMT,G2H8(45),n2h8(109))
  call Hloop_WQ_A(ntryL,G1H16(146),ex1(:),G1H8(133),m3h2x8(:,178),heltab2x16(:,:,598))
  call Hloop_Q_A(ntryL,G1H8(133),17,nMB,G2H8(46),n2h8(110))
  call Hloop_SQ_A(ntryL,G1H16(150),ex1(:),G1H8(133),ngX,m3h2x8(:,179),heltab2x16(:,:,599))
  call Hloop_Q_A(ntryL,G1H8(133),17,nMT,G2H8(47),n2h8(111))
  call Hloop_SQ_A(ntryL,G1H16(148),ex1(:),G1H8(133),ngX,m3h2x8(:,180),heltab2x16(:,:,600))
  call Hloop_Q_A(ntryL,G1H8(133),17,nMT,G2H8(48),n2h8(112))
  call Hloop_SQ_A(ntryL,G1H16(149),ex1(:),G1H8(133),ngPbt,m3h2x8(:,181),heltab2x16(:,:,601))
  call Hloop_Q_A(ntryL,G1H8(133),17,nMB,G2H8(49),n2h8(113))
  call Hloop_ZQ_A(ntryL,G0H16(79),ex1(:),G0H8(1),ngZu,m3h2x8(:,182),heltab2x16(:,:,602))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(133),n2h8(114))
  call Hloop_ZQ_A(ntryL,G0H16(80),ex1(:),G0H8(1),ngZu,m3h2x8(:,183),heltab2x16(:,:,603))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(134),n2h8(115))
  call Hloop_WQ_A(ntryL,G0H16(81),ex1(:),G0H8(1),m3h2x8(:,184),heltab2x16(:,:,604))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMB,G1H8(135),n2h8(116))
  call Hloop_ZQ_A(ntryL,G1H16(154),ex1(:),G1H8(136),ngZu,m3h2x8(:,185),heltab2x16(:,:,605))
  call Hloop_Q_A(ntryL,G1H8(136),17,nMT,G2H8(50),n2h8(117))
  call Hloop_ZQ_A(ntryL,G1H16(152),ex1(:),G1H8(136),ngZu,m3h2x8(:,186),heltab2x16(:,:,606))
  call Hloop_Q_A(ntryL,G1H8(136),17,nMT,G2H8(51),n2h8(118))
  call Hloop_WQ_A(ntryL,G1H16(153),ex1(:),G1H8(136),m3h2x8(:,187),heltab2x16(:,:,607))
  call Hloop_Q_A(ntryL,G1H8(136),17,nMB,G2H8(52),n2h8(119))
  call Hloop_ZQ_A(ntryL,G0H16(85),ex1(:),G0H8(1),ngZu,m3h2x8(:,188),heltab2x16(:,:,608))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(136),n2h8(120))
  call Hloop_ZQ_A(ntryL,G0H16(83),ex1(:),G0H8(1),ngZu,m3h2x8(:,189),heltab2x16(:,:,609))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(137),n2h8(121))
  call Hloop_WQ_A(ntryL,G0H16(84),ex1(:),G0H8(1),m3h2x8(:,190),heltab2x16(:,:,610))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMB,G1H8(138),n2h8(122))
  call Hloop_SA_Q(ntryL,G0H16(86),ex2(:),G0H8(1),ngH,m3h2x8(:,191),heltab2x16(:,:,611))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(139),n2h8(123))
  call Hloop_SA_Q(ntryL,G0H16(87),ex2(:),G0H8(1),ngX,m3h2x8(:,192),heltab2x16(:,:,612))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(140),n2h8(124))
  call Hloop_SA_Q(ntryL,G0H16(88),ex2(:),G0H8(1),ngPtb,m3h2x8(:,193),heltab2x16(:,:,613))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMB,G1H8(141),n2h8(125))
  call Hloop_SA_Q(ntryL,G0H16(89),ex2(:),G0H8(1),ngPtb,m3h2x8(:,194),heltab2x16(:,:,614))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMB,G1H8(142),n2h8(126))
  call Hloop_SA_Q(ntryL,G1H16(155),ex2(:),G1H8(143),ngX,m3h2x8(:,195),heltab2x16(:,:,615))
  call Hloop_A_Q(ntryL,G1H8(143),18,nMT,G2H8(53),n2h8(127))
  call Hloop_SA_Q(ntryL,G1H16(156),ex2(:),G1H8(143),ngPtb,m3h2x8(:,196),heltab2x16(:,:,616))
  call Hloop_A_Q(ntryL,G1H8(143),18,nMB,G2H8(54),n2h8(128))
  call Hloop_SA_Q(ntryL,G1H16(157),ex2(:),G1H8(143),ngPtb,m3h2x8(:,197),heltab2x16(:,:,617))
  call Hloop_A_Q(ntryL,G1H8(143),18,nMB,G2H8(55),n2h8(129))
  call Hloop_ZA_Q(ntryL,G1H16(158),ex2(:),G1H8(143),ngZu,m3h2x8(:,198),heltab2x16(:,:,618))
  call Hloop_A_Q(ntryL,G1H8(143),18,nMT,G2H8(56),n2h8(130))
  call Hloop_WA_Q(ntryL,G1H16(159),ex2(:),G1H8(143),m3h2x8(:,199),heltab2x16(:,:,619))
  call Hloop_A_Q(ntryL,G1H8(143),18,nMB,G2H8(57),n2h8(131))
  call Hloop_WA_Q(ntryL,G1H16(160),ex2(:),G1H8(143),m3h2x8(:,200),heltab2x16(:,:,620))
  call Hloop_A_Q(ntryL,G1H8(143),18,nMB,G2H8(58),n2h8(132))
  call Hloop_SA_Q(ntryL,G0H16(94),ex2(:),G0H8(1),ngPtb,m3h2x8(:,201),heltab2x16(:,:,621))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMB,G1H8(143),n2h8(133))
  call Hloop_SA_Q(ntryL,G0H16(91),ex2(:),G0H8(1),ngPtb,m3h2x8(:,202),heltab2x16(:,:,622))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMB,G1H8(144),n2h8(134))
  call Hloop_SA_Q(ntryL,G0H16(92),ex2(:),G0H8(1),ngH,m3h2x8(:,203),heltab2x16(:,:,623))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(145),n2h8(135))
  call Hloop_SA_Q(ntryL,G0H16(93),ex2(:),G0H8(1),ngX,m3h2x8(:,204),heltab2x16(:,:,624))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(146),n2h8(136))
  call Hloop_ZA_Q(ntryL,G0H16(95),ex2(:),G0H8(1),ngZu,m3h2x8(:,205),heltab2x16(:,:,625))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(147),n2h8(137))
  call Hloop_WA_Q(ntryL,G0H16(96),ex2(:),G0H8(1),m3h2x8(:,206),heltab2x16(:,:,626))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMB,G1H8(148),n2h8(138))
  call Hloop_WA_Q(ntryL,G0H16(97),ex2(:),G0H8(1),m3h2x8(:,207),heltab2x16(:,:,627))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMB,G1H8(149),n2h8(139))
  call Hloop_SA_Q(ntryL,G1H16(164),ex2(:),G1H8(150),ngPtb,m3h2x8(:,208),heltab2x16(:,:,628))
  call Hloop_A_Q(ntryL,G1H8(150),18,nMB,G2H8(59),n2h8(140))
  call Hloop_SA_Q(ntryL,G1H16(162),ex2(:),G1H8(150),ngX,m3h2x8(:,209),heltab2x16(:,:,629))
  call Hloop_A_Q(ntryL,G1H8(150),18,nMT,G2H8(60),n2h8(141))
  call Hloop_SA_Q(ntryL,G1H16(163),ex2(:),G1H8(150),ngPtb,m3h2x8(:,210),heltab2x16(:,:,630))
  call Hloop_A_Q(ntryL,G1H8(150),18,nMB,G2H8(61),n2h8(142))
  call Hloop_WA_Q(ntryL,G1H16(168),ex2(:),G1H8(150),m3h2x8(:,211),heltab2x16(:,:,631))
  call Hloop_A_Q(ntryL,G1H8(150),18,nMB,G2H8(62),n2h8(143))
  call Hloop_ZA_Q(ntryL,G1H16(166),ex2(:),G1H8(150),ngZu,m3h2x8(:,212),heltab2x16(:,:,632))
  call Hloop_A_Q(ntryL,G1H8(150),18,nMT,G2H8(63),n2h8(144))
  call Hloop_WA_Q(ntryL,G1H16(167),ex2(:),G1H8(150),m3h2x8(:,213),heltab2x16(:,:,633))
  call Hloop_A_Q(ntryL,G1H8(150),18,nMB,G2H8(64),n2h8(145))
  call Hloop_ZA_Q(ntryL,G0H16(98),ex2(:),G0H8(1),ngZu,m3h2x8(:,214),heltab2x16(:,:,634))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMT,G1H8(150),n2h8(146))
  call Hloop_WA_Q(ntryL,G0H16(101),ex2(:),G0H8(1),m3h2x8(:,215),heltab2x16(:,:,635))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMB,G1H8(151),n2h8(147))
  call Hloop_WA_Q(ntryL,G0H16(100),ex2(:),G0H8(1),m3h2x8(:,216),heltab2x16(:,:,636))
  call Hloop_A_Q(ntryL,G0H8(1),18,nMB,G1H8(152),n2h8(148))
  call Hloop_QA_S(ntryL,G1H16(169),ex2(:),G1H8(153),ngH,m3h2x8(:,217),heltab2x16(:,:,637))
  call Hloop_QA_S(ntryL,G1H16(170),ex2(:),G1H8(154),ngPtb,m3h2x8(:,218),heltab2x16(:,:,638))
  call Hloop_QA_S(ntryL,G1H16(171),ex2(:),G1H8(155),ngX,m3h2x8(:,219),heltab2x16(:,:,639))
  call Hloop_QA_S(ntryL,G1H16(172),ex2(:),G1H8(156),ngPtb,m3h2x8(:,220),heltab2x16(:,:,640))
  call Hloop_QA_V(ntryL,G1H16(177),ex2(:),G1H8(157),m3h2x8(:,221),heltab2x16(:,:,641))
  call Hloop_QA_Z(ntryL,G1H16(174),ex2(:),G1H8(158),ngZu,m3h2x8(:,222),heltab2x16(:,:,642))
  call Hloop_QA_W(ntryL,G1H16(175),ex2(:),G1H8(159),m3h2x8(:,223),heltab2x16(:,:,643))
  call Hloop_QA_W(ntryL,G1H16(176),ex2(:),G1H8(160),m3h2x8(:,224),heltab2x16(:,:,644))
  call Hloop_QA_S(ntryL,G1H16(182),ex2(:),G1H8(161),ngPtb,m3h2x8(:,225),heltab2x16(:,:,645))
  call Hloop_QA_S(ntryL,G1H16(179),ex2(:),G1H8(162),ngPtb,m3h2x8(:,226),heltab2x16(:,:,646))
  call Hloop_QA_S(ntryL,G1H16(180),ex2(:),G1H8(163),ngH,m3h2x8(:,227),heltab2x16(:,:,647))
  call Hloop_QA_S(ntryL,G1H16(181),ex2(:),G1H8(164),ngX,m3h2x8(:,228),heltab2x16(:,:,648))
  call Hloop_QA_V(ntryL,G1H16(187),ex2(:),G1H8(165),m3h2x8(:,229),heltab2x16(:,:,649))
  call Hloop_QA_W(ntryL,G1H16(188),ex2(:),G1H8(166),m3h2x8(:,230),heltab2x16(:,:,650))
  call Hloop_QA_Z(ntryL,G1H16(185),ex2(:),G1H8(167),ngZu,m3h2x8(:,231),heltab2x16(:,:,651))
  call Hloop_QA_W(ntryL,G1H16(186),ex2(:),G1H8(168),m3h2x8(:,232),heltab2x16(:,:,652))
  call Hloop_AQ_S(ntryL,G1H16(189),ex1(:),G1H8(169),ngH,m3h2x8(:,233),heltab2x16(:,:,653))
  call Hloop_AQ_S(ntryL,G1H16(190),ex1(:),G1H8(170),ngPbt,m3h2x8(:,234),heltab2x16(:,:,654))
  call Hloop_AQ_S(ntryL,G1H16(191),ex1(:),G1H8(171),ngX,m3h2x8(:,235),heltab2x16(:,:,655))
  call Hloop_AQ_S(ntryL,G1H16(192),ex1(:),G1H8(172),ngPbt,m3h2x8(:,236),heltab2x16(:,:,656))
  call Hloop_AQ_S(ntryL,G1H16(197),ex1(:),G1H8(173),ngPbt,m3h2x8(:,237),heltab2x16(:,:,657))
  call Hloop_AQ_S(ntryL,G1H16(194),ex1(:),G1H8(174),ngPbt,m3h2x8(:,238),heltab2x16(:,:,658))
  call Hloop_AQ_S(ntryL,G1H16(195),ex1(:),G1H8(175),ngH,m3h2x8(:,239),heltab2x16(:,:,659))
  call Hloop_AQ_S(ntryL,G1H16(196),ex1(:),G1H8(176),ngX,m3h2x8(:,240),heltab2x16(:,:,660))
  call Hloop_AQ_V(ntryL,G1H16(202),ex1(:),G1H8(177),m3h2x8(:,241),heltab2x16(:,:,661))
  call Hloop_AQ_Z(ntryL,G1H16(199),ex1(:),G1H8(178),ngZu,m3h2x8(:,242),heltab2x16(:,:,662))
  call Hloop_AQ_W(ntryL,G1H16(200),ex1(:),G1H8(179),m3h2x8(:,243),heltab2x16(:,:,663))
  call Hloop_AQ_W(ntryL,G1H16(201),ex1(:),G1H8(180),m3h2x8(:,244),heltab2x16(:,:,664))
  call Hloop_AQ_V(ntryL,G1H16(207),ex1(:),G1H8(181),m3h2x8(:,245),heltab2x16(:,:,665))
  call Hloop_AQ_W(ntryL,G1H16(208),ex1(:),G1H8(182),m3h2x8(:,246),heltab2x16(:,:,666))
  call Hloop_AQ_Z(ntryL,G1H16(205),ex1(:),G1H8(183),ngZu,m3h2x8(:,247),heltab2x16(:,:,667))
  call Hloop_AQ_W(ntryL,G1H16(206),ex1(:),G1H8(184),m3h2x8(:,248),heltab2x16(:,:,668))
  call Hloop_AQ_S(ntryL,G1H16(209),ex1(:),G1H8(185),ngH,m3h2x8(:,249),heltab2x16(:,:,669))
  call Hloop_AQ_S(ntryL,G1H16(210),ex1(:),G1H8(186),ngH,m3h2x8(:,250),heltab2x16(:,:,670))
  call Hloop_AQ_S(ntryL,G1H16(211),ex1(:),G1H8(187),ngX,m3h2x8(:,251),heltab2x16(:,:,671))
  call Hloop_AQ_S(ntryL,G1H16(212),ex1(:),G1H8(188),ngX,m3h2x8(:,252),heltab2x16(:,:,672))
  call Hloop_AQ_S(ntryL,G1H16(213),ex1(:),G1H8(189),ngPbt,m3h2x8(:,253),heltab2x16(:,:,673))
  call Hloop_AQ_S(ntryL,G1H16(219),ex1(:),G1H8(190),ngH,m3h2x8(:,254),heltab2x16(:,:,674))
  call Hloop_AQ_S(ntryL,G1H16(220),ex1(:),G1H8(191),ngX,m3h2x8(:,255),heltab2x16(:,:,675))
  call Hloop_AQ_S(ntryL,G1H16(216),ex1(:),G1H8(192),ngH,m3h2x8(:,256),heltab2x16(:,:,676))
  call Hloop_AQ_S(ntryL,G1H16(217),ex1(:),G1H8(193),ngX,m3h2x8(:,257),heltab2x16(:,:,677))
  call Hloop_AQ_S(ntryL,G1H16(218),ex1(:),G1H8(194),ngPbt,m3h2x8(:,258),heltab2x16(:,:,678))
  call Hloop_AQ_V(ntryL,G1H16(226),ex1(:),G1H8(195),m3h2x8(:,259),heltab2x16(:,:,679))
  call Hloop_AQ_V(ntryL,G1H16(227),ex1(:),G1H8(196),m3h2x8(:,260),heltab2x16(:,:,680))
  call Hloop_AQ_Z(ntryL,G1H16(223),ex1(:),G1H8(197),ngZu,m3h2x8(:,261),heltab2x16(:,:,681))
  call Hloop_AQ_Z(ntryL,G1H16(224),ex1(:),G1H8(198),ngZu,m3h2x8(:,262),heltab2x16(:,:,682))
  call Hloop_AQ_W(ntryL,G1H16(225),ex1(:),G1H8(199),m3h2x8(:,263),heltab2x16(:,:,683))
  call Hloop_AQ_V(ntryL,G1H16(234),ex1(:),G1H8(200),m3h2x8(:,264),heltab2x16(:,:,684))
  call Hloop_AQ_V(ntryL,G1H16(236),ex1(:),G1H8(201),m3h2x8(:,265),heltab2x16(:,:,685))
  call Hloop_AQ_Z(ntryL,G1H16(235),ex1(:),G1H8(202),ngZu,m3h2x8(:,266),heltab2x16(:,:,686))
  call Hloop_AQ_Z(ntryL,G1H16(231),ex1(:),G1H8(203),ngZu,m3h2x8(:,267),heltab2x16(:,:,687))
  call Hloop_AQ_W(ntryL,G1H16(232),ex1(:),G1H8(204),m3h2x8(:,268),heltab2x16(:,:,688))
  call Hloop_SQ_A(ntryL,G0H16(102),ex1(:),G0H8(1),ngH,m3h2x8(:,269),heltab2x16(:,:,689))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(205),n2h8(149))
  call Hloop_SQ_A(ntryL,G0H16(103),ex1(:),G0H8(1),ngX,m3h2x8(:,270),heltab2x16(:,:,690))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(206),n2h8(150))
  call Hloop_SQ_A(ntryL,G0H16(104),ex1(:),G0H8(1),ngPbt,m3h2x8(:,271),heltab2x16(:,:,691))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMB,G1H8(207),n2h8(151))
  call Hloop_SQ_A(ntryL,G0H16(105),ex1(:),G0H8(1),ngPbt,m3h2x8(:,272),heltab2x16(:,:,692))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMB,G1H8(208),n2h8(152))
  call Hloop_SQ_A(ntryL,G1H16(237),ex1(:),G1H8(209),ngX,m3h2x8(:,273),heltab2x16(:,:,693))
  call Hloop_Q_A(ntryL,G1H8(209),17,nMT,G2H8(65),n2h8(153))
  call Hloop_SQ_A(ntryL,G1H16(238),ex1(:),G1H8(209),ngPbt,m3h2x8(:,274),heltab2x16(:,:,694))
  call Hloop_Q_A(ntryL,G1H8(209),17,nMB,G2H8(66),n2h8(154))
  call Hloop_SQ_A(ntryL,G1H16(239),ex1(:),G1H8(209),ngPbt,m3h2x8(:,275),heltab2x16(:,:,695))
  call Hloop_Q_A(ntryL,G1H8(209),17,nMB,G2H8(67),n2h8(155))
  call Hloop_SQ_A(ntryL,G0H16(110),ex1(:),G0H8(1),ngPbt,m3h2x8(:,276),heltab2x16(:,:,696))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMB,G1H8(209),n2h8(156))
  call Hloop_SQ_A(ntryL,G0H16(107),ex1(:),G0H8(1),ngPbt,m3h2x8(:,277),heltab2x16(:,:,697))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMB,G1H8(210),n2h8(157))
  call Hloop_SQ_A(ntryL,G0H16(108),ex1(:),G0H8(1),ngH,m3h2x8(:,278),heltab2x16(:,:,698))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(211),n2h8(158))
  call Hloop_SQ_A(ntryL,G0H16(109),ex1(:),G0H8(1),ngX,m3h2x8(:,279),heltab2x16(:,:,699))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(212),n2h8(159))
  call Hloop_ZQ_A(ntryL,G1H16(240),ex1(:),G1H8(213),ngZu,m3h2x8(:,280),heltab2x16(:,:,700))
  call Hloop_Q_A(ntryL,G1H8(213),17,nMT,G2H8(68),n2h8(160))
  call Hloop_WQ_A(ntryL,G1H16(241),ex1(:),G1H8(213),m3h2x8(:,281),heltab2x16(:,:,701))
  call Hloop_Q_A(ntryL,G1H8(213),17,nMB,G2H8(69),n2h8(161))
  call Hloop_WQ_A(ntryL,G1H16(242),ex1(:),G1H8(213),m3h2x8(:,282),heltab2x16(:,:,702))
  call Hloop_Q_A(ntryL,G1H8(213),17,nMB,G2H8(70),n2h8(162))
  call Hloop_SQ_A(ntryL,G1H16(246),ex1(:),G1H8(213),ngPbt,m3h2x8(:,283),heltab2x16(:,:,703))
  call Hloop_Q_A(ntryL,G1H8(213),17,nMB,G2H8(71),n2h8(163))
  call Hloop_SQ_A(ntryL,G1H16(244),ex1(:),G1H8(213),ngX,m3h2x8(:,284),heltab2x16(:,:,704))
  call Hloop_Q_A(ntryL,G1H8(213),17,nMT,G2H8(72),n2h8(164))
  call Hloop_SQ_A(ntryL,G1H16(245),ex1(:),G1H8(213),ngPbt,m3h2x8(:,285),heltab2x16(:,:,705))
  call Hloop_Q_A(ntryL,G1H8(213),17,nMB,G2H8(73),n2h8(165))
  call Hloop_ZQ_A(ntryL,G0H16(111),ex1(:),G0H8(1),ngZu,m3h2x8(:,286),heltab2x16(:,:,706))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(213),n2h8(166))
  call Hloop_WQ_A(ntryL,G0H16(112),ex1(:),G0H8(1),m3h2x8(:,287),heltab2x16(:,:,707))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMB,G1H8(214),n2h8(167))
  call Hloop_WQ_A(ntryL,G0H16(113),ex1(:),G0H8(1),m3h2x8(:,288),heltab2x16(:,:,708))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMB,G1H8(215),n2h8(168))
  call Hloop_WQ_A(ntryL,G1H16(250),ex1(:),G1H8(216),m3h2x8(:,289),heltab2x16(:,:,709))
  call Hloop_Q_A(ntryL,G1H8(216),17,nMB,G2H8(74),n2h8(169))
  call Hloop_ZQ_A(ntryL,G1H16(248),ex1(:),G1H8(216),ngZu,m3h2x8(:,290),heltab2x16(:,:,710))
  call Hloop_Q_A(ntryL,G1H8(216),17,nMT,G2H8(75),n2h8(170))
  call Hloop_WQ_A(ntryL,G1H16(249),ex1(:),G1H8(216),m3h2x8(:,291),heltab2x16(:,:,711))
  call Hloop_Q_A(ntryL,G1H8(216),17,nMB,G2H8(76),n2h8(171))
  call Hloop_ZQ_A(ntryL,G0H16(114),ex1(:),G0H8(1),ngZu,m3h2x8(:,292),heltab2x16(:,:,712))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(216),n2h8(172))
  call Hloop_WQ_A(ntryL,G0H16(117),ex1(:),G0H8(1),m3h2x8(:,293),heltab2x16(:,:,713))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMB,G1H8(217),n2h8(173))
  call Hloop_WQ_A(ntryL,G0H16(116),ex1(:),G0H8(1),m3h2x8(:,294),heltab2x16(:,:,714))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMB,G1H8(218),n2h8(174))
  call Hloop_AQ_S(ntryL,G1H16(251),ex1(:),G1H8(219),ngH,m3h2x8(:,295),heltab2x16(:,:,715))
  call Hloop_AQ_S(ntryL,G1H16(252),ex1(:),G1H8(220),ngH,m3h2x8(:,296),heltab2x16(:,:,716))
  call Hloop_AQ_S(ntryL,G1H16(253),ex1(:),G1H8(221),ngX,m3h2x8(:,297),heltab2x16(:,:,717))
  call Hloop_AQ_S(ntryL,G1H16(254),ex1(:),G1H8(222),ngX,m3h2x8(:,298),heltab2x16(:,:,718))
  call Hloop_SQ_A(ntryL,G0H16(118),ex1(:),G0H8(1),ngH,m3h2x8(:,299),heltab2x16(:,:,719))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(223),n2h8(175))
  call Hloop_SQ_A(ntryL,G0H16(119),ex1(:),G0H8(1),ngX,m3h2x8(:,300),heltab2x16(:,:,720))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(224),n2h8(176))
  call Hloop_SQ_A(ntryL,G0H16(120),ex1(:),G0H8(1),ngPbt,m3h2x8(:,301),heltab2x16(:,:,721))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMB,G1H8(225),n2h8(177))
  call Hloop_SQ_A(ntryL,G0H16(121),ex1(:),G0H8(1),ngPbt,m3h2x8(:,302),heltab2x16(:,:,722))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMB,G1H8(226),n2h8(178))
  call Hloop_AQ_S(ntryL,G1H16(259),ex1(:),G1H8(227),ngH,m3h2x8(:,303),heltab2x16(:,:,723))
  call Hloop_AQ_S(ntryL,G1H16(260),ex1(:),G1H8(228),ngX,m3h2x8(:,304),heltab2x16(:,:,724))
  call Hloop_AQ_S(ntryL,G1H16(257),ex1(:),G1H8(229),ngH,m3h2x8(:,305),heltab2x16(:,:,725))
  call Hloop_AQ_S(ntryL,G1H16(258),ex1(:),G1H8(230),ngX,m3h2x8(:,306),heltab2x16(:,:,726))
  call Hloop_AQ_V(ntryL,G1H16(265),ex1(:),G1H8(231),m3h2x8(:,307),heltab2x16(:,:,727))
  call Hloop_AQ_V(ntryL,G1H16(266),ex1(:),G1H8(232),m3h2x8(:,308),heltab2x16(:,:,728))
  call Hloop_AQ_Z(ntryL,G1H16(263),ex1(:),G1H8(233),ngZu,m3h2x8(:,309),heltab2x16(:,:,729))
  call Hloop_AQ_Z(ntryL,G1H16(264),ex1(:),G1H8(234),ngZu,m3h2x8(:,310),heltab2x16(:,:,730))
  call Hloop_SQ_A(ntryL,G0H16(126),ex1(:),G0H8(1),ngPbt,m3h2x8(:,311),heltab2x16(:,:,731))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMB,G1H8(235),n2h8(179))
  call Hloop_SQ_A(ntryL,G0H16(123),ex1(:),G0H8(1),ngPbt,m3h2x8(:,312),heltab2x16(:,:,732))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMB,G1H8(236),n2h8(180))
  call Hloop_SQ_A(ntryL,G0H16(124),ex1(:),G0H8(1),ngH,m3h2x8(:,313),heltab2x16(:,:,733))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(237),n2h8(181))
  call Hloop_SQ_A(ntryL,G0H16(125),ex1(:),G0H8(1),ngX,m3h2x8(:,314),heltab2x16(:,:,734))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(238),n2h8(182))
  call Hloop_SQ_A(ntryL,G1H16(267),ex1(:),G1H8(239),ngX,m3h2x8(:,315),heltab2x16(:,:,735))
  call Hloop_Q_A(ntryL,G1H8(239),17,nMT,G2H8(77),n2h8(183))
  call Hloop_SQ_A(ntryL,G1H16(268),ex1(:),G1H8(239),ngPbt,m3h2x8(:,316),heltab2x16(:,:,736))
  call Hloop_Q_A(ntryL,G1H8(239),17,nMB,G2H8(78),n2h8(184))
  call Hloop_SQ_A(ntryL,G1H16(269),ex1(:),G1H8(239),ngPbt,m3h2x8(:,317),heltab2x16(:,:,737))
  call Hloop_Q_A(ntryL,G1H8(239),17,nMB,G2H8(79),n2h8(185))
  call Hloop_ZQ_A(ntryL,G1H16(270),ex1(:),G1H8(239),ngZu,m3h2x8(:,318),heltab2x16(:,:,738))
  call Hloop_Q_A(ntryL,G1H8(239),17,nMT,G2H8(80),n2h8(186))
  call Hloop_WQ_A(ntryL,G1H16(271),ex1(:),G1H8(239),m3h2x8(:,319),heltab2x16(:,:,739))
  call Hloop_Q_A(ntryL,G1H8(239),17,nMB,G2H8(81),n2h8(187))
  call Hloop_WQ_A(ntryL,G1H16(272),ex1(:),G1H8(239),m3h2x8(:,320),heltab2x16(:,:,740))
  call Hloop_Q_A(ntryL,G1H8(239),17,nMB,G2H8(82),n2h8(188))
  call Hloop_AQ_V(ntryL,G1H16(278),ex1(:),G1H8(239),m3h2x8(:,321),heltab2x16(:,:,741))
  call Hloop_AQ_V(ntryL,G1H16(280),ex1(:),G1H8(240),m3h2x8(:,322),heltab2x16(:,:,742))
  call Hloop_AQ_Z(ntryL,G1H16(279),ex1(:),G1H8(241),ngZu,m3h2x8(:,323),heltab2x16(:,:,743))
  call Hloop_AQ_Z(ntryL,G1H16(276),ex1(:),G1H8(242),ngZu,m3h2x8(:,324),heltab2x16(:,:,744))
  call Hloop_SQ_A(ntryL,G1H16(284),ex1(:),G1H8(243),ngPbt,m3h2x8(:,325),heltab2x16(:,:,745))
  call Hloop_Q_A(ntryL,G1H8(243),17,nMB,G2H8(83),n2h8(189))
  call Hloop_SQ_A(ntryL,G1H16(282),ex1(:),G1H8(243),ngX,m3h2x8(:,326),heltab2x16(:,:,746))
  call Hloop_Q_A(ntryL,G1H8(243),17,nMT,G2H8(84),n2h8(190))
  call Hloop_SQ_A(ntryL,G1H16(283),ex1(:),G1H8(243),ngPbt,m3h2x8(:,327),heltab2x16(:,:,747))
  call Hloop_Q_A(ntryL,G1H8(243),17,nMB,G2H8(85),n2h8(191))
  call Hloop_WQ_A(ntryL,G1H16(288),ex1(:),G1H8(243),m3h2x8(:,328),heltab2x16(:,:,748))
  call Hloop_Q_A(ntryL,G1H8(243),17,nMB,G2H8(86),n2h8(192))
  call Hloop_ZQ_A(ntryL,G1H16(286),ex1(:),G1H8(243),ngZu,m3h2x8(:,329),heltab2x16(:,:,749))
  call Hloop_Q_A(ntryL,G1H8(243),17,nMT,G2H8(87),n2h8(193))
  call Hloop_WQ_A(ntryL,G1H16(287),ex1(:),G1H8(243),m3h2x8(:,330),heltab2x16(:,:,750))
  call Hloop_Q_A(ntryL,G1H8(243),17,nMB,G2H8(88),n2h8(194))
  call Hloop_ZQ_A(ntryL,G0H16(127),ex1(:),G0H8(1),ngZu,m3h2x8(:,331),heltab2x16(:,:,751))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(243),n2h8(195))
  call Hloop_WQ_A(ntryL,G0H16(128),ex1(:),G0H8(1),m3h2x8(:,332),heltab2x16(:,:,752))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMB,G1H8(244),n2h8(196))
  call Hloop_WQ_A(ntryL,G0H16(129),ex1(:),G0H8(1),m3h2x8(:,333),heltab2x16(:,:,753))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMB,G1H8(245),n2h8(197))
  call Hloop_ZQ_A(ntryL,G0H16(130),ex1(:),G0H8(1),ngZu,m3h2x8(:,334),heltab2x16(:,:,754))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMT,G1H8(246),n2h8(198))
  call Hloop_WQ_A(ntryL,G0H16(133),ex1(:),G0H8(1),m3h2x8(:,335),heltab2x16(:,:,755))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMB,G1H8(247),n2h8(199))
  call Hloop_WQ_A(ntryL,G0H16(132),ex1(:),G0H8(1),m3h2x8(:,336),heltab2x16(:,:,756))
  call Hloop_Q_A(ntryL,G0H8(1),17,nMB,G1H8(248),n2h8(200))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(4),[G1H8(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(5),[G1H8(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(6),[G1H8(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(1),[G1H8(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(2),[G1H8(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(3),[G1H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(10),[G1H8(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(11),[G1H8(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(12),[G1H8(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(7),[G1H8(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(8),[G1H8(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(9),[G1H8(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(16),[G1H8(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(17),[G1H8(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(18),[G1H8(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(13),[G1H8(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(14),[G1H8(62)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(15),[G1H8(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(22),[G1H8(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(24),[G1H8(54)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(23),[G1H8(56)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(19),[G1H8(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(20),[G1H8(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(21),[G1H8(66)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(27),[G1H8(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(28),[G1H8(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(25),[G1H8(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(26),[G1H8(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(31),[G1H8(84)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(32),[G1H8(86)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(29),[G1H8(93)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(30),[G1H8(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(35),[G1H8(101)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(36),[G1H8(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(33),[G1H8(119)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(34),[G1H8(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(39),[G1H8(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(40),[G1H8(114)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(37),[G1H8(121)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(38),[G1H8(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(44),[G1H8(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(45),[G1H8(126)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(46),[G1H8(127)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(41),[G1H8(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(42),[G1H8(134)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(43),[G1H8(135)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(50),[G1H8(129)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(51),[G1H8(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(52),[G1H8(132)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(47),[G1H8(136)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(48),[G1H8(137)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(49),[G1H8(138)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(56),[G1H8(140)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(57),[G1H8(141)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(58),[G1H8(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(53),[G1H8(147)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(54),[G1H8(148)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(55),[G1H8(149)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(62),[G1H8(143)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(64),[G1H8(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(63),[G1H8(146)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(59),[G1H8(151)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(60),[G1H8(150)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(61),[G1H8(152)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(68),[G1H8(206)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(69),[G1H8(207)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(70),[G1H8(208)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(65),[G1H8(213)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(66),[G1H8(214)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(67),[G1H8(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(74),[G1H8(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(76),[G1H8(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(75),[G1H8(212)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(71),[G1H8(217)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(72),[G1H8(216)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(73),[G1H8(218)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(80),[G1H8(224)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(81),[G1H8(225)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(82),[G1H8(226)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(86),[G1H8(235)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(88),[G1H8(236)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(87),[G1H8(238)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(77),[G1H8(243)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(78),[G1H8(244)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(79),[G1H8(245)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(83),[G1H8(247)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(84),[G1H8(246)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(85),[G1H8(248)])
  call Hloop_SQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),ngH,m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(1),n2h4(1))
  call Hloop_SQ_A(ntryL,G1H8(2),ex1(:),G1H4(1),ngH,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(2),n2h4(2))
  call Hloop_SQ_A(ntryL,G1H8(3),ex1(:),G1H4(1),ngX,m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(3),n2h4(3))
  call Hloop_SQ_A(ntryL,G1H8(4),ex1(:),G1H4(1),ngX,m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(4),n2h4(4))
  call Hloop_SQ_A(ntryL,G1H8(5),ex1(:),G1H4(1),ngPbt,m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(5),n2h4(5))
  call Hloop_SQ_A(ntryL,G1H8(6),ex1(:),G1H4(1),ngH,m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(6),n2h4(6))
  call Hloop_SQ_A(ntryL,G1H8(7),ex1(:),G1H4(1),ngX,m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(7),n2h4(7))
  call Hloop_SQ_A(ntryL,G1H8(8),ex1(:),G1H4(1),ngH,m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(8),n2h4(8))
  call Hloop_SQ_A(ntryL,G1H8(9),ex1(:),G1H4(1),ngX,m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(9),n2h4(9))
  call Hloop_SQ_A(ntryL,G1H8(10),ex1(:),G1H4(1),ngPbt,m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(10),n2h4(10))
  call Hloop_VQ_A(ntryL,G1H8(11),ex1(:),G1H4(1),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(11),n2h4(11))
  call Hloop_VQ_A(ntryL,G1H8(12),ex1(:),G1H4(1),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(12),n2h4(12))
  call Hloop_ZQ_A(ntryL,G1H8(13),ex1(:),G1H4(1),ngZu,m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(13),n2h4(13))
  call Hloop_ZQ_A(ntryL,G1H8(14),ex1(:),G1H4(1),ngZu,m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(14),n2h4(14))
  call Hloop_WQ_A(ntryL,G1H8(15),ex1(:),G1H4(1),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(15),n2h4(15))
  call Hloop_VQ_A(ntryL,G1H8(16),ex1(:),G1H4(1),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(16),n2h4(16))
  call Hloop_VQ_A(ntryL,G1H8(17),ex1(:),G1H4(1),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(17),n2h4(17))
  call Hloop_ZQ_A(ntryL,G1H8(18),ex1(:),G1H4(1),ngZu,m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(18),n2h4(18))
  call Hloop_ZQ_A(ntryL,G1H8(19),ex1(:),G1H4(1),ngZu,m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMT,G2H4(19),n2h4(19))
  call Hloop_WQ_A(ntryL,G1H8(20),ex1(:),G1H4(1),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G1H4(1),21,nMB,G2H4(20),n2h4(20))
  call Hloop_AQ_S(ntryL,G1H8(21),ex1(:),G1H4(1),ngH,m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_AQ_S(ntryL,G1H8(22),ex1(:),G1H4(2),ngX,m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_AQ_S(ntryL,G2H8(4),ex1(:),G2H4(21),ngH,m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_AQ_S(ntryL,G2H8(5),ex1(:),G2H4(22),ngX,m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_AQ_S(ntryL,G2H8(6),ex1(:),G2H4(23),ngPbt,m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_AQ_S(ntryL,G2H8(1),ex1(:),G2H4(24),ngH,m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_AQ_S(ntryL,G2H8(2),ex1(:),G2H4(25),ngX,m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_AQ_S(ntryL,G2H8(3),ex1(:),G2H4(26),ngPbt,m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_AQ_V(ntryL,G1H8(26),ex1(:),G1H4(3),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_AQ_V(ntryL,G2H8(10),ex1(:),G2H4(27),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_AQ_Z(ntryL,G1H8(28),ex1(:),G1H4(4),ngZu,m3h2x4(:,31),heltab2x8(:,:,31))
  call Hloop_AQ_Z(ntryL,G2H8(11),ex1(:),G2H4(28),ngZu,m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_AQ_W(ntryL,G2H8(12),ex1(:),G2H4(29),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_AQ_V(ntryL,G2H8(7),ex1(:),G2H4(30),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_AQ_Z(ntryL,G2H8(8),ex1(:),G2H4(31),ngZu,m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_AQ_W(ntryL,G2H8(9),ex1(:),G2H4(32),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_SA_Q(ntryL,G1H8(37),ex2(:),G1H4(5),ngH,m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(5),22,nMT,G2H4(33),n2h4(21))
  call Hloop_SA_Q(ntryL,G1H8(38),ex2(:),G1H4(5),ngX,m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G1H4(5),22,nMT,G2H4(34),n2h4(22))
  call Hloop_SA_Q(ntryL,G1H8(39),ex2(:),G1H4(5),ngH,m3h2x4(:,39),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(5),22,nMT,G2H4(35),n2h4(23))
  call Hloop_SA_Q(ntryL,G1H8(40),ex2(:),G1H4(5),ngX,m3h2x4(:,40),heltab2x8(:,:,40))
  call Hloop_A_Q(ntryL,G1H4(5),22,nMT,G2H4(36),n2h4(24))
  call Hloop_QA_S(ntryL,G1H8(41),ex2(:),G1H4(5),ngPtb,m3h2x4(:,41),heltab2x8(:,:,41))
  call Hloop_QA_S(ntryL,G2H8(16),ex2(:),G2H4(37),ngPtb,m3h2x4(:,42),heltab2x8(:,:,42))
  call Hloop_QA_S(ntryL,G2H8(17),ex2(:),G2H4(38),ngH,m3h2x4(:,43),heltab2x8(:,:,43))
  call Hloop_QA_S(ntryL,G2H8(18),ex2(:),G2H4(39),ngX,m3h2x4(:,44),heltab2x8(:,:,44))
  call Hloop_VA_Q(ntryL,G1H8(45),ex2(:),G1H4(6),m3h2x4(:,45),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(6),22,nMT,G2H4(40),n2h4(25))
  call Hloop_VA_Q(ntryL,G1H8(46),ex2(:),G1H4(6),m3h2x4(:,46),heltab2x8(:,:,46))
  call Hloop_A_Q(ntryL,G1H4(6),22,nMT,G2H4(41),n2h4(26))
  call Hloop_ZA_Q(ntryL,G1H8(47),ex2(:),G1H4(6),ngZu,m3h2x4(:,47),heltab2x8(:,:,47))
  call Hloop_A_Q(ntryL,G1H4(6),22,nMT,G2H4(42),n2h4(27))
  call Hloop_ZA_Q(ntryL,G1H8(48),ex2(:),G1H4(6),ngZu,m3h2x4(:,48),heltab2x8(:,:,48))
  call Hloop_A_Q(ntryL,G1H4(6),22,nMT,G2H4(43),n2h4(28))
  call Hloop_SA_Q(ntryL,G1H8(49),ex2(:),G1H4(6),ngH,m3h2x4(:,49),heltab2x8(:,:,49))
  call Hloop_A_Q(ntryL,G1H4(6),22,nMT,G2H4(44),n2h4(29))
  call Hloop_SA_Q(ntryL,G1H8(50),ex2(:),G1H4(6),ngX,m3h2x4(:,50),heltab2x8(:,:,50))
  call Hloop_A_Q(ntryL,G1H4(6),22,nMT,G2H4(45),n2h4(30))
  call Hloop_SA_Q(ntryL,G1H8(51),ex2(:),G1H4(6),ngH,m3h2x4(:,51),heltab2x8(:,:,51))
  call Hloop_A_Q(ntryL,G1H4(6),22,nMT,G2H4(46),n2h4(31))
  call Hloop_SA_Q(ntryL,G1H8(52),ex2(:),G1H4(6),ngX,m3h2x4(:,52),heltab2x8(:,:,52))
  call Hloop_A_Q(ntryL,G1H4(6),22,nMT,G2H4(47),n2h4(32))
  call Hloop_QA_S(ntryL,G2H8(13),ex2(:),G2H4(48),ngPtb,m3h2x4(:,53),heltab2x8(:,:,53))
  call Hloop_QA_S(ntryL,G2H8(14),ex2(:),G2H4(49),ngH,m3h2x4(:,54),heltab2x8(:,:,54))
  call Hloop_QA_S(ntryL,G2H8(15),ex2(:),G2H4(50),ngX,m3h2x4(:,55),heltab2x8(:,:,55))
  call Hloop_QA_V(ntryL,G2H8(22),ex2(:),G2H4(51),m3h2x4(:,56),heltab2x8(:,:,56))
  call Hloop_QA_Z(ntryL,G2H8(24),ex2(:),G2H4(52),ngZu,m3h2x4(:,57),heltab2x8(:,:,57))
  call Hloop_QA_W(ntryL,G1H8(55),ex2(:),G1H4(6),m3h2x4(:,58),heltab2x8(:,:,58))
  call Hloop_QA_W(ntryL,G2H8(23),ex2(:),G2H4(53),m3h2x4(:,59),heltab2x8(:,:,59))
  call Hloop_VA_Q(ntryL,G1H8(57),ex2(:),G1H4(7),m3h2x4(:,60),heltab2x8(:,:,60))
  call Hloop_A_Q(ntryL,G1H4(7),22,nMT,G2H4(54),n2h4(33))
  call Hloop_ZA_Q(ntryL,G1H8(58),ex2(:),G1H4(7),ngZu,m3h2x4(:,61),heltab2x8(:,:,61))
  call Hloop_A_Q(ntryL,G1H4(7),22,nMT,G2H4(55),n2h4(34))
  call Hloop_VA_Q(ntryL,G1H8(59),ex2(:),G1H4(7),m3h2x4(:,62),heltab2x8(:,:,62))
  call Hloop_A_Q(ntryL,G1H4(7),22,nMT,G2H4(56),n2h4(35))
  call Hloop_ZA_Q(ntryL,G1H8(60),ex2(:),G1H4(7),ngZu,m3h2x4(:,63),heltab2x8(:,:,63))
  call Hloop_A_Q(ntryL,G1H4(7),22,nMT,G2H4(57),n2h4(36))
  call Hloop_QA_V(ntryL,G2H8(19),ex2(:),G2H4(58),m3h2x4(:,64),heltab2x8(:,:,64))
  call Hloop_QA_W(ntryL,G2H8(20),ex2(:),G2H4(59),m3h2x4(:,65),heltab2x8(:,:,65))
  call Hloop_QA_Z(ntryL,G2H8(21),ex2(:),G2H4(60),ngZu,m3h2x4(:,66),heltab2x8(:,:,66))
  call Hloop_SQ_A(ntryL,G1H8(67),ex1(:),G1H4(7),ngH,m3h2x4(:,67),heltab2x8(:,:,67))
  call Hloop_Q_A(ntryL,G1H4(7),19,nMT,G2H4(61),n2h4(37))
  call Hloop_SQ_A(ntryL,G1H8(68),ex1(:),G1H4(7),ngPbt,m3h2x4(:,68),heltab2x8(:,:,68))
  call Hloop_Q_A(ntryL,G1H4(7),19,nMB,G2H4(62),n2h4(38))
  call Hloop_SQ_A(ntryL,G1H8(69),ex1(:),G1H4(7),ngX,m3h2x4(:,69),heltab2x8(:,:,69))
  call Hloop_Q_A(ntryL,G1H4(7),19,nMT,G2H4(63),n2h4(39))
  call Hloop_SQ_A(ntryL,G1H8(70),ex1(:),G1H4(7),ngPbt,m3h2x4(:,70),heltab2x8(:,:,70))
  call Hloop_Q_A(ntryL,G1H4(7),19,nMB,G2H4(64),n2h4(40))
  call Hloop_AQ_S(ntryL,G1H8(71),ex1(:),G1H4(7),ngH,m3h2x4(:,71),heltab2x8(:,:,71))
  call Hloop_AQ_S(ntryL,G1H8(72),ex1(:),G1H4(8),ngX,m3h2x4(:,72),heltab2x8(:,:,72))
  call Hloop_AQ_S(ntryL,G2H8(27),ex1(:),G2H4(65),ngH,m3h2x4(:,73),heltab2x8(:,:,73))
  call Hloop_AQ_S(ntryL,G2H8(28),ex1(:),G2H4(66),ngX,m3h2x4(:,74),heltab2x8(:,:,74))
  call Hloop_SQ_A(ntryL,G1H8(75),ex1(:),G1H4(9),ngPbt,m3h2x4(:,75),heltab2x8(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(9),19,nMB,G2H4(67),n2h4(41))
  call Hloop_SQ_A(ntryL,G1H8(76),ex1(:),G1H4(9),ngPbt,m3h2x4(:,76),heltab2x8(:,:,76))
  call Hloop_Q_A(ntryL,G1H4(9),19,nMB,G2H4(68),n2h4(42))
  call Hloop_SQ_A(ntryL,G1H8(77),ex1(:),G1H4(9),ngH,m3h2x4(:,77),heltab2x8(:,:,77))
  call Hloop_Q_A(ntryL,G1H4(9),19,nMT,G2H4(69),n2h4(43))
  call Hloop_SQ_A(ntryL,G1H8(78),ex1(:),G1H4(9),ngX,m3h2x4(:,78),heltab2x8(:,:,78))
  call Hloop_Q_A(ntryL,G1H4(9),19,nMT,G2H4(70),n2h4(44))
  call Hloop_VQ_A(ntryL,G1H8(79),ex1(:),G1H4(9),m3h2x4(:,79),heltab2x8(:,:,79))
  call Hloop_Q_A(ntryL,G1H4(9),19,nMT,G2H4(71),n2h4(45))
  call Hloop_ZQ_A(ntryL,G1H8(80),ex1(:),G1H4(9),ngZu,m3h2x4(:,80),heltab2x8(:,:,80))
  call Hloop_Q_A(ntryL,G1H4(9),19,nMT,G2H4(72),n2h4(46))
  call Hloop_WQ_A(ntryL,G1H8(81),ex1(:),G1H4(9),m3h2x4(:,81),heltab2x8(:,:,81))
  call Hloop_Q_A(ntryL,G1H4(9),19,nMB,G2H4(73),n2h4(47))
  call Hloop_WQ_A(ntryL,G1H8(82),ex1(:),G1H4(9),m3h2x4(:,82),heltab2x8(:,:,82))
  call Hloop_Q_A(ntryL,G1H4(9),19,nMB,G2H4(74),n2h4(48))
  call Hloop_AQ_S(ntryL,G2H8(25),ex1(:),G2H4(75),ngH,m3h2x4(:,83),heltab2x8(:,:,83))
  call Hloop_AQ_S(ntryL,G2H8(26),ex1(:),G2H4(76),ngX,m3h2x4(:,84),heltab2x8(:,:,84))
  call Hloop_AQ_V(ntryL,G1H8(83),ex1(:),G1H4(9),m3h2x4(:,85),heltab2x8(:,:,85))
  call Hloop_AQ_V(ntryL,G2H8(31),ex1(:),G2H4(77),m3h2x4(:,86),heltab2x8(:,:,86))
  call Hloop_AQ_Z(ntryL,G1H8(85),ex1(:),G1H4(10),ngZu,m3h2x4(:,87),heltab2x8(:,:,87))
  call Hloop_AQ_Z(ntryL,G2H8(32),ex1(:),G2H4(78),ngZu,m3h2x4(:,88),heltab2x8(:,:,88))
  call Hloop_VQ_A(ntryL,G1H8(87),ex1(:),G1H4(11),m3h2x4(:,89),heltab2x8(:,:,89))
  call Hloop_Q_A(ntryL,G1H4(11),19,nMT,G2H4(79),n2h4(49))
  call Hloop_WQ_A(ntryL,G1H8(88),ex1(:),G1H4(11),m3h2x4(:,90),heltab2x8(:,:,90))
  call Hloop_Q_A(ntryL,G1H4(11),19,nMB,G2H4(80),n2h4(50))
  call Hloop_ZQ_A(ntryL,G1H8(89),ex1(:),G1H4(11),ngZu,m3h2x4(:,91),heltab2x8(:,:,91))
  call Hloop_Q_A(ntryL,G1H4(11),19,nMT,G2H4(81),n2h4(51))
  call Hloop_WQ_A(ntryL,G1H8(90),ex1(:),G1H4(11),m3h2x4(:,92),heltab2x8(:,:,92))
  call Hloop_Q_A(ntryL,G1H4(11),19,nMB,G2H4(82),n2h4(52))
  call Hloop_AQ_V(ntryL,G2H8(29),ex1(:),G2H4(83),m3h2x4(:,93),heltab2x8(:,:,93))
  call Hloop_AQ_Z(ntryL,G2H8(30),ex1(:),G2H4(84),ngZu,m3h2x4(:,94),heltab2x8(:,:,94))
  call Hloop_SA_Q(ntryL,G1H8(95),ex2(:),G1H4(11),ngH,m3h2x4(:,95),heltab2x8(:,:,95))
  call Hloop_A_Q(ntryL,G1H4(11),19,nMT,G2H4(85),n2h4(53))
  call Hloop_SA_Q(ntryL,G1H8(96),ex2(:),G1H4(11),ngPtb,m3h2x4(:,96),heltab2x8(:,:,96))
  call Hloop_A_Q(ntryL,G1H4(11),19,nMB,G2H4(86),n2h4(54))
  call Hloop_SA_Q(ntryL,G1H8(97),ex2(:),G1H4(11),ngX,m3h2x4(:,97),heltab2x8(:,:,97))
  call Hloop_A_Q(ntryL,G1H4(11),19,nMT,G2H4(87),n2h4(55))
  call Hloop_SA_Q(ntryL,G1H8(98),ex2(:),G1H4(11),ngPtb,m3h2x4(:,98),heltab2x8(:,:,98))
  call Hloop_A_Q(ntryL,G1H4(11),19,nMB,G2H4(88),n2h4(56))
  call Hloop_QA_S(ntryL,G1H8(99),ex2(:),G1H4(11),ngH,m3h2x4(:,99),heltab2x8(:,:,99))
  call Hloop_QA_S(ntryL,G1H8(100),ex2(:),G1H4(12),ngX,m3h2x4(:,100),heltab2x8(:,:,100))
  call Hloop_QA_S(ntryL,G2H8(35),ex2(:),G2H4(89),ngH,m3h2x4(:,101),heltab2x8(:,:,101))
  call Hloop_QA_S(ntryL,G2H8(36),ex2(:),G2H4(90),ngX,m3h2x4(:,102),heltab2x8(:,:,102))
  call Hloop_SA_Q(ntryL,G1H8(103),ex2(:),G1H4(13),ngPtb,m3h2x4(:,103),heltab2x8(:,:,103))
  call Hloop_A_Q(ntryL,G1H4(13),19,nMB,G2H4(91),n2h4(57))
  call Hloop_SA_Q(ntryL,G1H8(104),ex2(:),G1H4(13),ngPtb,m3h2x4(:,104),heltab2x8(:,:,104))
  call Hloop_A_Q(ntryL,G1H4(13),19,nMB,G2H4(92),n2h4(58))
  call Hloop_SA_Q(ntryL,G1H8(105),ex2(:),G1H4(13),ngH,m3h2x4(:,105),heltab2x8(:,:,105))
  call Hloop_A_Q(ntryL,G1H4(13),19,nMT,G2H4(93),n2h4(59))
  call Hloop_SA_Q(ntryL,G1H8(106),ex2(:),G1H4(13),ngX,m3h2x4(:,106),heltab2x8(:,:,106))
  call Hloop_A_Q(ntryL,G1H4(13),19,nMT,G2H4(94),n2h4(60))
  call Hloop_VA_Q(ntryL,G1H8(107),ex2(:),G1H4(13),m3h2x4(:,107),heltab2x8(:,:,107))
  call Hloop_A_Q(ntryL,G1H4(13),19,nMT,G2H4(95),n2h4(61))
  call Hloop_ZA_Q(ntryL,G1H8(108),ex2(:),G1H4(13),ngZu,m3h2x4(:,108),heltab2x8(:,:,108))
  call Hloop_A_Q(ntryL,G1H4(13),19,nMT,G2H4(96),n2h4(62))
  call Hloop_WA_Q(ntryL,G1H8(109),ex2(:),G1H4(13),m3h2x4(:,109),heltab2x8(:,:,109))
  call Hloop_A_Q(ntryL,G1H4(13),19,nMB,G2H4(97),n2h4(63))
  call Hloop_WA_Q(ntryL,G1H8(110),ex2(:),G1H4(13),m3h2x4(:,110),heltab2x8(:,:,110))
  call Hloop_A_Q(ntryL,G1H4(13),19,nMB,G2H4(98),n2h4(64))
  call Hloop_QA_S(ntryL,G2H8(33),ex2(:),G2H4(99),ngH,m3h2x4(:,111),heltab2x8(:,:,111))
  call Hloop_QA_S(ntryL,G2H8(34),ex2(:),G2H4(100),ngX,m3h2x4(:,112),heltab2x8(:,:,112))
  call Hloop_QA_V(ntryL,G1H8(111),ex2(:),G1H4(13),m3h2x4(:,113),heltab2x8(:,:,113))
  call Hloop_QA_V(ntryL,G2H8(39),ex2(:),G2H4(101),m3h2x4(:,114),heltab2x8(:,:,114))
  call Hloop_QA_Z(ntryL,G1H8(113),ex2(:),G1H4(14),ngZu,m3h2x4(:,115),heltab2x8(:,:,115))
  call Hloop_QA_Z(ntryL,G2H8(40),ex2(:),G2H4(102),ngZu,m3h2x4(:,116),heltab2x8(:,:,116))
  call Hloop_VA_Q(ntryL,G1H8(115),ex2(:),G1H4(15),m3h2x4(:,117),heltab2x8(:,:,117))
  call Hloop_A_Q(ntryL,G1H4(15),19,nMT,G2H4(103),n2h4(65))
  call Hloop_WA_Q(ntryL,G1H8(116),ex2(:),G1H4(15),m3h2x4(:,118),heltab2x8(:,:,118))
  call Hloop_A_Q(ntryL,G1H4(15),19,nMB,G2H4(104),n2h4(66))
  call Hloop_ZA_Q(ntryL,G1H8(117),ex2(:),G1H4(15),ngZu,m3h2x4(:,119),heltab2x8(:,:,119))
  call Hloop_A_Q(ntryL,G1H4(15),19,nMT,G2H4(105),n2h4(67))
  call Hloop_WA_Q(ntryL,G1H8(118),ex2(:),G1H4(15),m3h2x4(:,120),heltab2x8(:,:,120))
  call Hloop_A_Q(ntryL,G1H4(15),19,nMB,G2H4(106),n2h4(68))
  call Hloop_QA_V(ntryL,G2H8(37),ex2(:),G2H4(107),m3h2x4(:,121),heltab2x8(:,:,121))
  call Hloop_QA_Z(ntryL,G2H8(38),ex2(:),G2H4(108),ngZu,m3h2x4(:,122),heltab2x8(:,:,122))
  call Hloop_QA_S(ntryL,G1H8(123),ex2(:),G1H4(15),ngH,m3h2x4(:,123),heltab2x8(:,:,123))
  call Hloop_QA_S(ntryL,G1H8(124),ex2(:),G1H4(16),ngX,m3h2x4(:,124),heltab2x8(:,:,124))
  call Hloop_QA_S(ntryL,G2H8(44),ex2(:),G2H4(109),ngH,m3h2x4(:,125),heltab2x8(:,:,125))
  call Hloop_QA_S(ntryL,G2H8(45),ex2(:),G2H4(110),ngX,m3h2x4(:,126),heltab2x8(:,:,126))
  call Hloop_QA_S(ntryL,G2H8(46),ex2(:),G2H4(111),ngPtb,m3h2x4(:,127),heltab2x8(:,:,127))
  call Hloop_QA_S(ntryL,G2H8(41),ex2(:),G2H4(112),ngH,m3h2x4(:,128),heltab2x8(:,:,128))
  call Hloop_QA_S(ntryL,G2H8(42),ex2(:),G2H4(113),ngX,m3h2x4(:,129),heltab2x8(:,:,129))
  call Hloop_QA_S(ntryL,G2H8(43),ex2(:),G2H4(114),ngPtb,m3h2x4(:,130),heltab2x8(:,:,130))
  call Hloop_QA_V(ntryL,G1H8(128),ex2(:),G1H4(17),m3h2x4(:,131),heltab2x8(:,:,131))
  call Hloop_QA_V(ntryL,G2H8(50),ex2(:),G2H4(115),m3h2x4(:,132),heltab2x8(:,:,132))
  call Hloop_QA_Z(ntryL,G1H8(130),ex2(:),G1H4(18),ngZu,m3h2x4(:,133),heltab2x8(:,:,133))
  call Hloop_QA_Z(ntryL,G2H8(51),ex2(:),G2H4(116),ngZu,m3h2x4(:,134),heltab2x8(:,:,134))
  call Hloop_QA_W(ntryL,G2H8(52),ex2(:),G2H4(117),m3h2x4(:,135),heltab2x8(:,:,135))
  call Hloop_QA_V(ntryL,G2H8(47),ex2(:),G2H4(118),m3h2x4(:,136),heltab2x8(:,:,136))
  call Hloop_QA_Z(ntryL,G2H8(48),ex2(:),G2H4(119),ngZu,m3h2x4(:,137),heltab2x8(:,:,137))
  call Hloop_QA_W(ntryL,G2H8(49),ex2(:),G2H4(120),m3h2x4(:,138),heltab2x8(:,:,138))
  call Hloop_AQ_S(ntryL,G1H8(139),ex3(:),G1H4(19),ngPtb,m3h2x4(:,139),heltab2x8(:,:,139))
  call Hloop_AQ_S(ntryL,G2H8(56),ex3(:),G2H4(121),ngPtb,m3h2x4(:,140),heltab2x8(:,:,140))
  call Hloop_AQ_S(ntryL,G2H8(57),ex3(:),G2H4(122),ngH,m3h2x4(:,141),heltab2x8(:,:,141))
  call Hloop_AQ_S(ntryL,G2H8(58),ex3(:),G2H4(123),ngX,m3h2x4(:,142),heltab2x8(:,:,142))
  call Hloop_AQ_S(ntryL,G2H8(53),ex3(:),G2H4(124),ngPtb,m3h2x4(:,143),heltab2x8(:,:,143))
  call Hloop_AQ_S(ntryL,G2H8(54),ex3(:),G2H4(125),ngH,m3h2x4(:,144),heltab2x8(:,:,144))
  call Hloop_AQ_S(ntryL,G2H8(55),ex3(:),G2H4(126),ngX,m3h2x4(:,145),heltab2x8(:,:,145))
  call Hloop_AQ_V(ntryL,G2H8(62),ex3(:),G2H4(127),m3h2x4(:,146),heltab2x8(:,:,146))
  call Hloop_AQ_Z(ntryL,G2H8(64),ex3(:),G2H4(128),ngZd,m3h2x4(:,147),heltab2x8(:,:,147))
  call Hloop_AQ_W(ntryL,G1H8(145),ex3(:),G1H4(20),m3h2x4(:,148),heltab2x8(:,:,148))
  call Hloop_AQ_W(ntryL,G2H8(63),ex3(:),G2H4(129),m3h2x4(:,149),heltab2x8(:,:,149))
  call Hloop_AQ_V(ntryL,G2H8(59),ex3(:),G2H4(130),m3h2x4(:,150),heltab2x8(:,:,150))
  call Hloop_AQ_W(ntryL,G2H8(60),ex3(:),G2H4(131),m3h2x4(:,151),heltab2x8(:,:,151))
  call Hloop_AQ_Z(ntryL,G2H8(61),ex3(:),G2H4(132),ngZd,m3h2x4(:,152),heltab2x8(:,:,152))
  call Hloop_SA_Q(ntryL,G1H8(153),ex4(:),G1H4(21),ngH,m3h2x4(:,153),heltab2x8(:,:,153))
  call Hloop_A_Q(ntryL,G1H4(21),26,nMB,G2H4(133),n2h4(69))
  call Hloop_SA_Q(ntryL,G1H8(154),ex4(:),G1H4(21),ngPbt,m3h2x4(:,154),heltab2x8(:,:,154))
  call Hloop_A_Q(ntryL,G1H4(21),26,nMT,G2H4(134),n2h4(70))
  call Hloop_SA_Q(ntryL,G1H8(155),ex4(:),G1H4(21),ngX,m3h2x4(:,155),heltab2x8(:,:,155))
  call Hloop_A_Q(ntryL,G1H4(21),26,nMB,G2H4(135),n2h4(71))
  call Hloop_SA_Q(ntryL,G1H8(156),ex4(:),G1H4(21),ngPbt,m3h2x4(:,156),heltab2x8(:,:,156))
  call Hloop_A_Q(ntryL,G1H4(21),26,nMT,G2H4(136),n2h4(72))
  call Hloop_VA_Q(ntryL,G1H8(157),ex4(:),G1H4(21),m3h2x4(:,157),heltab2x8(:,:,157))
  call Hloop_A_Q(ntryL,G1H4(21),26,nMB,G2H4(137),n2h4(73))
  call Hloop_ZA_Q(ntryL,G1H8(158),ex4(:),G1H4(21),ngZd,m3h2x4(:,158),heltab2x8(:,:,158))
  call Hloop_A_Q(ntryL,G1H4(21),26,nMB,G2H4(138),n2h4(74))
  call Hloop_WA_Q(ntryL,G1H8(159),ex4(:),G1H4(21),m3h2x4(:,159),heltab2x8(:,:,159))
  call Hloop_A_Q(ntryL,G1H4(21),26,nMT,G2H4(139),n2h4(75))
  call Hloop_WA_Q(ntryL,G1H8(160),ex4(:),G1H4(21),m3h2x4(:,160),heltab2x8(:,:,160))
  call Hloop_A_Q(ntryL,G1H4(21),26,nMT,G2H4(140),n2h4(76))
  call Hloop_SA_Q(ntryL,G1H8(161),ex4(:),G1H4(21),ngPbt,m3h2x4(:,161),heltab2x8(:,:,161))
  call Hloop_A_Q(ntryL,G1H4(21),26,nMT,G2H4(141),n2h4(77))
  call Hloop_SA_Q(ntryL,G1H8(162),ex4(:),G1H4(21),ngPbt,m3h2x4(:,162),heltab2x8(:,:,162))
  call Hloop_A_Q(ntryL,G1H4(21),26,nMT,G2H4(142),n2h4(78))
  call Hloop_SA_Q(ntryL,G1H8(163),ex4(:),G1H4(21),ngH,m3h2x4(:,163),heltab2x8(:,:,163))
  call Hloop_A_Q(ntryL,G1H4(21),26,nMB,G2H4(143),n2h4(79))
  call Hloop_SA_Q(ntryL,G1H8(164),ex4(:),G1H4(21),ngX,m3h2x4(:,164),heltab2x8(:,:,164))
  call Hloop_A_Q(ntryL,G1H4(21),26,nMB,G2H4(144),n2h4(80))
  call Hloop_VA_Q(ntryL,G1H8(165),ex4(:),G1H4(21),m3h2x4(:,165),heltab2x8(:,:,165))
  call Hloop_A_Q(ntryL,G1H4(21),26,nMB,G2H4(145),n2h4(81))
  call Hloop_WA_Q(ntryL,G1H8(166),ex4(:),G1H4(21),m3h2x4(:,166),heltab2x8(:,:,166))
  call Hloop_A_Q(ntryL,G1H4(21),26,nMT,G2H4(146),n2h4(82))
  call Hloop_ZA_Q(ntryL,G1H8(167),ex4(:),G1H4(21),ngZd,m3h2x4(:,167),heltab2x8(:,:,167))
  call Hloop_A_Q(ntryL,G1H4(21),26,nMB,G2H4(147),n2h4(83))
  call Hloop_WA_Q(ntryL,G1H8(168),ex4(:),G1H4(21),m3h2x4(:,168),heltab2x8(:,:,168))
  call Hloop_A_Q(ntryL,G1H4(21),26,nMT,G2H4(148),n2h4(84))
  call Hloop_SQ_A(ntryL,G1H8(169),ex3(:),G1H4(21),ngH,m3h2x4(:,169),heltab2x8(:,:,169))
  call Hloop_Q_A(ntryL,G1H4(21),21,nMB,G2H4(149),n2h4(85))
  call Hloop_SQ_A(ntryL,G1H8(170),ex3(:),G1H4(21),ngPtb,m3h2x4(:,170),heltab2x8(:,:,170))
  call Hloop_Q_A(ntryL,G1H4(21),21,nMT,G2H4(150),n2h4(86))
  call Hloop_SQ_A(ntryL,G1H8(171),ex3(:),G1H4(21),ngX,m3h2x4(:,171),heltab2x8(:,:,171))
  call Hloop_Q_A(ntryL,G1H4(21),21,nMB,G2H4(151),n2h4(87))
  call Hloop_SQ_A(ntryL,G1H8(172),ex3(:),G1H4(21),ngPtb,m3h2x4(:,172),heltab2x8(:,:,172))
  call Hloop_Q_A(ntryL,G1H4(21),21,nMT,G2H4(152),n2h4(88))
  call Hloop_SQ_A(ntryL,G1H8(173),ex3(:),G1H4(21),ngPtb,m3h2x4(:,173),heltab2x8(:,:,173))
  call Hloop_Q_A(ntryL,G1H4(21),21,nMT,G2H4(153),n2h4(89))
  call Hloop_SQ_A(ntryL,G1H8(174),ex3(:),G1H4(21),ngPtb,m3h2x4(:,174),heltab2x8(:,:,174))
  call Hloop_Q_A(ntryL,G1H4(21),21,nMT,G2H4(154),n2h4(90))
  call Hloop_SQ_A(ntryL,G1H8(175),ex3(:),G1H4(21),ngH,m3h2x4(:,175),heltab2x8(:,:,175))
  call Hloop_Q_A(ntryL,G1H4(21),21,nMB,G2H4(155),n2h4(91))
  call Hloop_SQ_A(ntryL,G1H8(176),ex3(:),G1H4(21),ngX,m3h2x4(:,176),heltab2x8(:,:,176))
  call Hloop_Q_A(ntryL,G1H4(21),21,nMB,G2H4(156),n2h4(92))
  call Hloop_VQ_A(ntryL,G1H8(177),ex3(:),G1H4(21),m3h2x4(:,177),heltab2x8(:,:,177))
  call Hloop_Q_A(ntryL,G1H4(21),21,nMB,G2H4(157),n2h4(93))
  call Hloop_ZQ_A(ntryL,G1H8(178),ex3(:),G1H4(21),ngZd,m3h2x4(:,178),heltab2x8(:,:,178))
  call Hloop_Q_A(ntryL,G1H4(21),21,nMB,G2H4(158),n2h4(94))



end subroutine vamp_1

end module ol_vamp_1_pphtt_ew_ttxbbxh_3_/**/REALKIND
