
module ol_colourmatrix_pphtt_ew_ttxhaa_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(17,1), K2(17,1), KL(17,1), Cas(5) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 3]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 3]

  K2( 1,:) = [ 3]
  K2( 2,:) = [ 0]
  K2( 3,:) = [ 0]
  K2( 4,:) = [ 0]
  K2( 5,:) = [ 0]
  K2( 6,:) = [ 0]
  K2( 7,:) = [ 0]
  K2( 8,:) = [ 0]
  K2( 9,:) = [ 0]
  K2(10,:) = [ 0]
  K2(11,:) = [ 0]
  K2(12,:) = [ 0]
  K2(13,:) = [ 0]
  K2(14,:) = [ 0]
  K2(15,:) = [ 0]
  K2(16,:) = [ 0]
  K2(17,:) = [ 3]

  KL( 1,:) = [ 3]
  KL( 2,:) = [ 0]
  KL( 3,:) = [ 0]
  KL( 4,:) = [ 0]
  KL( 5,:) = [ 0]
  KL( 6,:) = [ 0]
  KL( 7,:) = [ 0]
  KL( 8,:) = [ 0]
  KL( 9,:) = [ 0]
  KL(10,:) = [ 0]
  KL(11,:) = [ 0]
  KL(12,:) = [ 0]
  KL(13,:) = [ 0]
  KL(14,:) = [ 0]
  KL(15,:) = [ 0]
  KL(16,:) = [ 0]
  KL(17,:) = [ 3]

#if 1 > 0
    co = 0
    do k = 1, 5
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_pphtt_ew_ttxhaa_2_/**/REALKIND



module ol_forced_parameters_pphtt_ew_ttxhaa_2_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pphtt_ew_ttxhaa_2_/**/REALKIND


! **********************************************************************
module ol_loop_storage_pphtt_ew_ttxhaa_2_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 16 ! number of helicity configurations
  integer(intkind2), save :: nhel = 16 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: hel_states = 16 ! number of helicity configurations needed for mem-allocation
  integer(intkind2), save :: Hel(16) ! physical helicity states
#endif

  type(Hpolcont), save, allocatable :: A(:,:), M1helarray(:,:), M1helarray_ct(:,:)
  complex(REALKIND), save :: den(90)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(1), ex4(2), ex5(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf2(2,14), wf4(4,62), wf8(8,28), wf16(16,51)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(216), c(207)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save, allocatable :: M0_col1_helarray(:,:), M0M1_hel_cc(:,:,:)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_pphtt_ew_ttxhaa_2_/**/REALKIND






! **********************************************************************
module ol_loop_pphtt_ew_ttxhaa_2_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_pphtt_ew_ttxhaa_2_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = (4*CI*countertermnorm*eQED**5*EWctHAA)/9._/**/REALKIND
    f(  2) = (2*CI*countertermnorm*eQED**5*EWctHZA)/3._/**/REALKIND
    f(  3) = (4*CI*countertermnorm*eQED**5*MT)/(9._/**/REALKIND*MW)
    f(  4) = (3*CI*countertermnorm*eQED**5*EWctHAA*lambdaHHH*MH**2*MT)/(4._/**/REALKIND*MW**2*sw**2)
    f(  5) = (CI*countertermnorm*eQED**5*EWctHAA*MT**2)/(4._/**/REALKIND*MW**2*sw**2)
    f(  6) = (2*CI*eQED**3*MT)/(9._/**/REALKIND*MW*sw)
    f(  7) = (2*CI*countertermnorm*eQED**5*MT)/(9._/**/REALKIND*MW*sw)
    f(  8) = (CI*countertermnorm*eQED**5*MT)/(3._/**/REALKIND*MW*sw)
    f(  9) = (countertermnorm*eQED**5*EWctAXH*MT)/(MW*sw*3._/**/REALKIND)
    f( 10) = (eQED**5*integralnorm*MW*SwB)/(cw*3._/**/REALKIND)
    f( 11) = (eQED**5*integralnorm*MW*SwB)/(cw*2._/**/REALKIND)
    f( 12) = (eQED**5*integralnorm*MW*SwB)/cw
    f( 13) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw*3._/**/REALKIND)
    f( 14) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw*2._/**/REALKIND)
    f( 15) = (eQED**5*integralnorm*MT*MW*SwB)/(cw*2._/**/REALKIND)
    f( 16) = (eQED**5*integralnorm*MW**3*SwB)/cw**3
    f( 17) = (eQED**5*integralnorm*MW**3*SwB)/(cw*2._/**/REALKIND)
    f( 18) = (2*eQED**5*integralnorm*MW**3*SwB)/(cw*3._/**/REALKIND)
    f( 19) = (eQED**5*integralnorm*MW**3*SwB)/cw
    f( 20) = (eQED**5*integralnorm*MB*SwB)/(MW**3*sw**3*36._/**/REALKIND)
    f( 21) = (eQED**5*integralnorm*MB*SwB)/(MW**3*sw**3*18._/**/REALKIND)
    f( 22) = (eQED**5*integralnorm*MB*SwB)/(MW**3*sw**3*12._/**/REALKIND)
    f( 23) = (eQED**5*integralnorm*MB*SwB)/(MW**3*sw**3*9._/**/REALKIND)
    f( 24) = (eQED**5*integralnorm*MB*SwB)/(MW**3*sw**3*6._/**/REALKIND)
    f( 25) = (eQED**5*integralnorm*MB*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f( 26) = (eQED**5*integralnorm*MB*SwB)/(MW**3*sw**3*2._/**/REALKIND)
    f( 27) = (eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**3*36._/**/REALKIND)
    f( 28) = (eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**3*18._/**/REALKIND)
    f( 29) = (eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**3*12._/**/REALKIND)
    f( 30) = (eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**3*9._/**/REALKIND)
    f( 31) = (eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**3*6._/**/REALKIND)
    f( 32) = (eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f( 33) = (eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**3*2._/**/REALKIND)
    f( 34) = (eQED**5*integralnorm*MT*SwB)/(MW**3*sw**3*36._/**/REALKIND)
    f( 35) = (eQED**5*integralnorm*MT*SwB)/(MW**3*sw**3*18._/**/REALKIND)
    f( 36) = (eQED**5*integralnorm*MT*SwB)/(MW**3*sw**3*12._/**/REALKIND)
    f( 37) = (eQED**5*integralnorm*MT*SwB)/(MW**3*sw**3*9._/**/REALKIND)
    f( 38) = (eQED**5*integralnorm*MT*SwB)/(MW**3*sw**3*6._/**/REALKIND)
    f( 39) = (eQED**5*integralnorm*MT*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f( 40) = (eQED**5*integralnorm*MT*SwB)/(MW**3*sw**3*2._/**/REALKIND)
    f( 41) = (eQED**5*integralnorm*MH**2*MT*SwB)/(MW**3*sw**3*12._/**/REALKIND)
    f( 42) = (eQED**5*integralnorm*MH**2*MT*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f( 43) = (eQED**5*integralnorm*MH**2*MT*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f( 44) = (eQED**5*integralnorm*MH**4*MT*SwB)/(MW**3*sw**3*12._/**/REALKIND)
    f( 45) = (eQED**5*integralnorm*MH**4*MT*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f( 46) = (eQED**5*integralnorm*MH**4*MT*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f( 47) = (3*eQED**5*integralnorm*lambdaHHH*MH**4*MT*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f( 48) = (3*eQED**5*integralnorm*lambdaHHH*MH**4*MT*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f( 49) = (eQED**5*integralnorm*MH**2*MT**2*SwB)/(MW**3*sw**3*18._/**/REALKIND)
    f( 50) = (eQED**5*integralnorm*MH**2*MT**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f( 51) = (eQED**5*integralnorm*MH**2*MT**2*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f( 52) = (eQED**5*integralnorm*lambdaHHH*MH**2*MT**2*SwB)/(MW**3*sw**3*6._/**/REALKIND)
    f( 53) = (eQED**5*integralnorm*MT**3*SwB)/(MW**3*sw**3*18._/**/REALKIND)
    f( 54) = (eQED**5*integralnorm*SwB)/(MW*sw**3*36._/**/REALKIND)
    f( 55) = (eQED**5*integralnorm*SwB)/(MW*sw**3*18._/**/REALKIND)
    f( 56) = (eQED**5*integralnorm*SwB)/(MW*sw**3*12._/**/REALKIND)
    f( 57) = (eQED**5*integralnorm*SwB)/(MW*sw**3*9._/**/REALKIND)
    f( 58) = (eQED**5*integralnorm*SwB)/(MW*sw**3*6._/**/REALKIND)
    f( 59) = (eQED**5*integralnorm*SwB)/(MW*sw**3*4._/**/REALKIND)
    f( 60) = (eQED**5*integralnorm*SwB)/(MW*sw**3*2._/**/REALKIND)
    f( 61) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*36._/**/REALKIND)
    f( 62) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*18._/**/REALKIND)
    f( 63) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*12._/**/REALKIND)
    f( 64) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*9._/**/REALKIND)
    f( 65) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*6._/**/REALKIND)
    f( 66) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*4._/**/REALKIND)
    f( 67) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw**3*12._/**/REALKIND)
    f( 68) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw**3*6._/**/REALKIND)
    f( 69) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw**3*4._/**/REALKIND)
    f( 70) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*36._/**/REALKIND)
    f( 71) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*18._/**/REALKIND)
    f( 72) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*12._/**/REALKIND)
    f( 73) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*9._/**/REALKIND)
    f( 74) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*8._/**/REALKIND)
    f( 75) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*6._/**/REALKIND)
    f( 76) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*4._/**/REALKIND)
    f( 77) = (eQED**5*integralnorm*MH**2*MT*SwB)/(MW*sw**3*12._/**/REALKIND)
    f( 78) = (eQED**5*integralnorm*MH**2*MT*SwB)/(MW*sw**3*8._/**/REALKIND)
    f( 79) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(MW*sw**3*8._/**/REALKIND)
    f( 80) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT*SwB)/(MW*sw**3*4._/**/REALKIND)
    f( 81) = (eQED**5*integralnorm*MH**4*MT*SwB)/(MW*sw**3*8._/**/REALKIND)
    f( 82) = (3*eQED**5*integralnorm*lambdaHHH*MH**4*MT*SwB)/(MW*sw**3*8._/**/REALKIND)
    f( 83) = (eQED**5*integralnorm*MT**2*SwB)/(MW*sw**3*8._/**/REALKIND)
    f( 84) = (eQED**5*integralnorm*MT**2*SwB)/(MW*sw**3*4._/**/REALKIND)
    f( 85) = (eQED**5*integralnorm*MH**2*MT**2*SwB)/(MW*sw**3*8._/**/REALKIND)
    f( 86) = (eQED**5*integralnorm*MW*SwB)/(sw**3*18._/**/REALKIND)
    f( 87) = (eQED**5*integralnorm*MW*SwB)/(sw**3*12._/**/REALKIND)
    f( 88) = (eQED**5*integralnorm*MW*SwB)/(sw**3*9._/**/REALKIND)
    f( 89) = (eQED**5*integralnorm*MW*SwB)/(sw**3*6._/**/REALKIND)
    f( 90) = (2*eQED**5*integralnorm*MW*SwB)/(sw**3*9._/**/REALKIND)
    f( 91) = (eQED**5*integralnorm*MW*SwB)/(sw**3*4._/**/REALKIND)
    f( 92) = (eQED**5*integralnorm*MW*SwB)/(sw**3*3._/**/REALKIND)
    f( 93) = (eQED**5*integralnorm*MW*SwB)/(sw**3*2._/**/REALKIND)
    f( 94) = (eQED**5*integralnorm*MB*MW*SwB)/(sw**3*4._/**/REALKIND)
    f( 95) = (eQED**5*integralnorm*MH**2*MW*SwB)/(sw**3*4._/**/REALKIND)
    f( 96) = (eQED**5*integralnorm*MT*MW*SwB)/(sw**3*12._/**/REALKIND)
    f( 97) = (eQED**5*integralnorm*MT*MW*SwB)/(sw**3*8._/**/REALKIND)
    f( 98) = (eQED**5*integralnorm*MT*MW*SwB)/(sw**3*6._/**/REALKIND)
    f( 99) = (eQED**5*integralnorm*MT*MW*SwB)/(sw**3*4._/**/REALKIND)
    f(100) = (eQED**5*integralnorm*MT*MW*SwB)/(sw**3*3._/**/REALKIND)
    f(101) = (eQED**5*integralnorm*MT*MW*SwB)/(sw**3*2._/**/REALKIND)
    f(102) = (eQED**5*integralnorm*MH**2*MT*MW*SwB)/(sw**3*4._/**/REALKIND)
    f(103) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MT*MW*SwB)/(sw**3*4._/**/REALKIND)
    f(104) = (eQED**5*integralnorm*MT**2*MW*SwB)/(sw**3*4._/**/REALKIND)
    f(105) = (eQED**5*integralnorm*MW**3*SwB)/(sw**3*2._/**/REALKIND)
    f(106) = (eQED**5*integralnorm*MT*MW**3*SwB)/(sw**3*2._/**/REALKIND)
    f(107) = (eQED**5*integralnorm*MT*SwB)/(cw*MW*sw**2*9._/**/REALKIND)
    f(108) = (cw*eQED**5*integralnorm*MT*SwB)/(MW*sw**2*2._/**/REALKIND)
    f(109) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(110) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2)
    f(111) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**2*3._/**/REALKIND)
    f(112) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**2*2._/**/REALKIND)
    f(113) = (2*cw*eQED**5*integralnorm*MW*SwB)/(sw**2*3._/**/REALKIND)
    f(114) = (cw*eQED**5*integralnorm*MW*SwB)/sw**2
    f(115) = (cw*eQED**5*integralnorm*MH**2*MW*SwB)/(sw**2*2._/**/REALKIND)
    f(116) = (cw*eQED**5*integralnorm*MT*MW*SwB)/(sw**2*2._/**/REALKIND)
    f(117) = (eQED**5*integralnorm*MW**3*SwB)/(cw*sw**2)
    f(118) = (cw*eQED**5*integralnorm*MW**3*SwB)/sw**2
    f(119) = (2*eQED**5*integralnorm*MH**2*SwB)/(MW*sw*9._/**/REALKIND)
    f(120) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw*3._/**/REALKIND)
    f(121) = (4*eQED**5*integralnorm*MH**2*SwB)/(MW*sw*9._/**/REALKIND)
    f(122) = (2*eQED**5*integralnorm*MH**2*SwB)/(MW*sw*3._/**/REALKIND)
    f(123) = (8*eQED**5*integralnorm*MT*SwB)/(MW*sw*81._/**/REALKIND)
    f(124) = (2*eQED**5*integralnorm*MT*SwB)/(MW*sw*9._/**/REALKIND)
    f(125) = (eQED**5*integralnorm*MT*SwB)/(MW*sw*3._/**/REALKIND)
    f(126) = (2*eQED**5*integralnorm*MT*SwB)/(MW*sw*3._/**/REALKIND)
    f(127) = (2*eQED**5*integralnorm*MW*SwB)/(sw*9._/**/REALKIND)
    f(128) = (eQED**5*integralnorm*MW*SwB)/(sw*3._/**/REALKIND)
    f(129) = (4*eQED**5*integralnorm*MW*SwB)/(sw*9._/**/REALKIND)
    f(130) = (2*eQED**5*integralnorm*MW*SwB)/(sw*3._/**/REALKIND)
    f(131) = (4*eQED**5*integralnorm*MW*SwB)/(cw**2*sw*9._/**/REALKIND)
    f(132) = (2*eQED**5*integralnorm*MH**2*MW*SwB)/(sw*9._/**/REALKIND)
    f(133) = (eQED**5*integralnorm*MH**2*MW*SwB)/(sw*3._/**/REALKIND)
    f(134) = (eQED**5*integralnorm*MT*MW*SwB)/(sw*3._/**/REALKIND)
    f(135) = (eQED**5*integralnorm*MT*MW*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(136) = (eQED**5*integralnorm*MW**3*SwB)/(sw*3._/**/REALKIND)
    f(137) = (4*eQED**5*integralnorm*MW**3*SwB)/(sw*9._/**/REALKIND)
    f(138) = (2*eQED**5*integralnorm*MW**3*SwB)/(sw*3._/**/REALKIND)
    f(139) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*6._/**/REALKIND)
    f(140) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(141) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*3._/**/REALKIND)
    f(142) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*2._/**/REALKIND)
    f(143) = (eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(144) = (eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*2._/**/REALKIND)
    f(145) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**2*2._/**/REALKIND)
    f(146) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**2)
    f(147) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*6._/**/REALKIND)
    f(148) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(149) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*2._/**/REALKIND)
    f(150) = (eQED**5*integralnorm*MH**2*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(151) = (eQED**5*integralnorm*MT*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(152) = (eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**2*2._/**/REALKIND)
    f(153) = (eQED**5*integralnorm*MW**3*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*2._/**/REALKIND)
    f(154) = (eQED**5*integralnorm*MT*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(155) = (eQED**5*integralnorm*MT*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(156) = (eQED**5*integralnorm*MT*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**3*8._/**/REALKIND)
    f(157) = (eQED**5*integralnorm*MB**2*MT*SwF)/(MW**3*sw**3*72._/**/REALKIND)
    f(158) = (eQED**5*integralnorm*MB**2*MT*SwF)/(MW**3*sw**3*36._/**/REALKIND)
    f(159) = (eQED**5*integralnorm*ME**2*MT*SwF)/(MW**3*sw**3*12._/**/REALKIND)
    f(160) = (eQED**5*integralnorm*ME**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(161) = (eQED**5*integralnorm*MB*MH**2*MT*SwF)/(MW**3*sw**3*72._/**/REALKIND)
    f(162) = (eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwF)/(MW**3*sw**3*24._/**/REALKIND)
    f(163) = (eQED**5*integralnorm*ME*MH**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(164) = (3*eQED**5*integralnorm*lambdaHHH*ME*MH**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(165) = (eQED**5*integralnorm*MH**2*ML*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(166) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*ML*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(167) = (eQED**5*integralnorm*ML**2*MT*SwF)/(MW**3*sw**3*12._/**/REALKIND)
    f(168) = (eQED**5*integralnorm*ML**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(169) = (eQED**5*integralnorm*MH**2*MM*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(170) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MM*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(171) = (eQED**5*integralnorm*MM**2*MT*SwF)/(MW**3*sw**3*12._/**/REALKIND)
    f(172) = (eQED**5*integralnorm*MM**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(173) = (eQED**5*integralnorm*MB*MT**2*SwF)/(MW**3*sw**3*72._/**/REALKIND)
    f(174) = (eQED**5*integralnorm*ME*MT**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(175) = (eQED**5*integralnorm*MH**2*MT**2*SwF)/(MW**3*sw**3*18._/**/REALKIND)
    f(176) = (eQED**5*integralnorm*lambdaHHH*MH**2*MT**2*SwF)/(MW**3*sw**3*6._/**/REALKIND)
    f(177) = (eQED**5*integralnorm*ML*MT**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(178) = (eQED**5*integralnorm*MM*MT**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(179) = (eQED**5*integralnorm*MT**3*SwF)/(MW**3*sw**3*18._/**/REALKIND)
    f(180) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*36._/**/REALKIND)
    f(181) = (eQED**5*integralnorm*ME*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(182) = (eQED**5*integralnorm*ML*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(183) = (eQED**5*integralnorm*MM*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(184) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*36._/**/REALKIND)
    f(185) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*18._/**/REALKIND)
    f(186) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*9._/**/REALKIND)
    f(187) = (2*eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*9._/**/REALKIND)
    f(188) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(189) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*81._/**/REALKIND)
    f(190) = (2*eQED**5*integralnorm*MB*SwF)/(MW*sw*81._/**/REALKIND)
    f(191) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*18._/**/REALKIND)
    f(192) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*9._/**/REALKIND)
    f(193) = (2*eQED**5*integralnorm*ME*SwF)/(MW*sw*9._/**/REALKIND)
    f(194) = (eQED**5*integralnorm*ME*SwF)/(MW*sw*3._/**/REALKIND)
    f(195) = (eQED**5*integralnorm*ME*SwF)/(MW*sw*2._/**/REALKIND)
    f(196) = (2*eQED**5*integralnorm*ML*SwF)/(MW*sw*9._/**/REALKIND)
    f(197) = (eQED**5*integralnorm*ML*SwF)/(MW*sw*3._/**/REALKIND)
    f(198) = (eQED**5*integralnorm*ML*SwF)/(MW*sw*2._/**/REALKIND)
    f(199) = (2*eQED**5*integralnorm*MM*SwF)/(MW*sw*9._/**/REALKIND)
    f(200) = (eQED**5*integralnorm*MM*SwF)/(MW*sw*3._/**/REALKIND)
    f(201) = (eQED**5*integralnorm*MM*SwF)/(MW*sw*2._/**/REALKIND)
    f(202) = (eQED**5*integralnorm*MT*SwF)/(MW*sw*81._/**/REALKIND)
    f(203) = (2*eQED**5*integralnorm*MT*SwF)/(MW*sw*81._/**/REALKIND)
    f(204) = (eQED**5*integralnorm*MT*SwF)/(MW*sw*18._/**/REALKIND)
    f(205) = (8*eQED**5*integralnorm*MT*SwF)/(MW*sw*81._/**/REALKIND)
    f(206) = (eQED**5*integralnorm*MT*SwF)/(MW*sw*9._/**/REALKIND)
    f(207) = (16*eQED**5*integralnorm*MT*SwF)/(MW*sw*81._/**/REALKIND)
    f(208) = (2*eQED**5*integralnorm*MT*SwF)/(MW*sw*9._/**/REALKIND)
    f(209) = (eQED**5*integralnorm*MT*SwF)/(MW*sw*3._/**/REALKIND)
    f(210) = (4*eQED**5*integralnorm*MT*SwF)/(MW*sw*9._/**/REALKIND)
    f(211) = (eQED**5*integralnorm*MT*SwF)/(MW*sw*2._/**/REALKIND)
    f(212) = (eQED**5*integralnorm*MW*SwF)/(cw**2*sw*9._/**/REALKIND)
    f(213) = (2*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*9._/**/REALKIND)
    f(214) = (4*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*9._/**/REALKIND)
    f(215) = (8*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*9._/**/REALKIND)
    f(216) = (eQED**5*integralnorm*MW*SwF)/(cw**2*sw)

  c = [ f(10), f(11), f(12), f(13), f(14), f(15), f(16), f(17), f(18), f(19), f(20), f(21), f(22), f(23), f(24), f(25), f(26) &
    , f(27), f(28), f(29), f(30), f(31), f(32), f(33), f(34), f(35), f(36), f(37), f(38), f(39), f(40), f(41), f(42), f(43), f(44) &
    , f(45), f(46), f(47), f(48), f(49), f(50), f(51), f(52), f(53), f(54), f(55), f(56), f(57), f(58), f(59), f(60), f(61), f(62) &
    , f(63), f(64), f(65), f(66), f(67), f(68), f(69), f(70), f(71), f(72), f(73), f(74), f(75), f(76), f(77), f(78), f(79), f(80) &
    , f(81), f(82), f(83), f(84), f(85), f(86), f(87), f(88), f(89), f(90), f(91), f(92), f(93), f(94), f(95), f(96), f(97), f(98) &
    , f(99), f(100), f(101), f(102), f(103), f(104), f(105), f(106), f(107), f(108), f(109), f(110), f(111), f(112), f(113) &
    , f(114), f(115), f(116), f(117), f(118), f(119), f(120), f(121), f(122), f(123), f(124), f(125), f(126), f(127), f(128) &
    , f(129), f(130), f(131), f(132), f(133), f(134), f(135), f(136), f(137), f(138), f(139), f(140), f(141), f(142), f(143) &
    , f(144), f(145), f(146), f(147), f(148), f(149), f(150), f(151), f(152), f(153), f(154), f(155), f(156), 3*f(157), 3*f(158) &
    , f(159), f(160), 3*f(161), 3*f(162), f(163), f(164), f(165), f(166), f(167), f(168), f(169), f(170), f(171), f(172), 3*f(173) &
    , f(174), 3*f(175), 3*f(176), f(177), f(178), 3*f(179), 3*f(180), f(181), f(182), f(183), 3*f(184), 3*f(185), 3*f(186) &
    , 3*f(187), f(188), 3*f(189), 3*f(190), 3*f(191), 3*f(192), f(193), f(194), f(195), f(196), f(197), f(198), f(199), f(200) &
    , f(201), 3*f(202), 3*f(203), 3*f(204), 3*f(205), 3*f(206), 3*f(207), 3*f(208), f(209), 3*f(210), f(211), 3*f(212), 3*f(213) &
    , 3*f(214), 3*f(215), f(216) ]
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,5) - MT2)+L(6,5))
  den(2) = 1 /((L(5,10) - MT2)+L(6,10))
  den(4) = 1 /((L(5,18) - MT2)+L(6,18))
  den(6) = 1 /((L(5,9) - MT2)+L(6,9))
  den(7) = 1 /((L(5,6) - MT2)+L(6,6))
  den(9) = 1 /((L(5,17) - MT2)+L(6,17))
  den(13) = 1 /((L(5,3) - MH2)+L(6,3))
  den(14) = 1 /((L(5,24) - MH2)+L(6,24))
  den(18) = 1 /((L(5,20) - MZ2)+L(6,20))
  den(20) = 1 /((L(5,20))+L(6,20))
  den(24) = 1 /((L(5,12) - MZ2)+L(6,12))
  den(26) = 1 /((L(5,12))+L(6,12))
  den(30) = 1 /((L(5,26) - MT2)+L(6,26))
  den(33) = 1 /((L(5,21) - MT2)+L(6,21))
  den(38) = 1 /((L(5,13) - MT2)+L(6,13))
  den(41) = 1 /((L(5,22) - MT2)+L(6,22))
  den(44) = 1 /((L(5,25) - MT2)+L(6,25))
  den(47) = 1 /((L(5,14) - MT2)+L(6,14))
  den(60) = 1 /((L(5,3) - MZ2)+L(6,3))
  den(61) = 1 /((L(5,3))+L(6,3))
  den(62) = 1 /((L(5,7) - MH2)+L(6,7))
  den(64) = 1 /((L(5,7) - MZ2)+L(6,7))
  den(68) = 1 /((L(5,7))+L(6,7))
  den(73) = 1 /((L(5,11) - MH2)+L(6,11))
  den(75) = 1 /((L(5,11) - MZ2)+L(6,11))
  den(77) = 1 /((L(5,11))+L(6,11))
  den(82) = 1 /((L(5,19) - MH2)+L(6,19))
  den(84) = 1 /((L(5,19) - MZ2)+L(6,19))
  den(86) = 1 /((L(5,19))+L(6,19))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(1)*den(4)
  den(8) = den(6)*den(7)
  den(10) = den(7)*den(9)
  den(11) = den(4)*den(6)
  den(12) = den(2)*den(9)
  den(15) = den(13)*den(14)
  den(16) = den(1)*den(14)
  den(17) = den(7)*den(14)
  den(19) = den(6)*den(18)
  den(21) = den(6)*den(20)
  den(22) = den(2)*den(18)
  den(23) = den(2)*den(20)
  den(25) = den(9)*den(24)
  den(27) = den(9)*den(26)
  den(28) = den(4)*den(24)
  den(29) = den(4)*den(26)
  den(31) = den(2)*den(30)
  den(32) = den(1)*den(31)
  den(34) = den(1)*den(33)
  den(35) = den(2)*den(34)
  den(36) = den(4)*den(30)
  den(37) = den(1)*den(36)
  den(39) = den(1)*den(38)
  den(40) = den(4)*den(39)
  den(42) = den(7)*den(41)
  den(43) = den(6)*den(42)
  den(45) = den(6)*den(44)
  den(46) = den(7)*den(45)
  den(48) = den(7)*den(47)
  den(49) = den(9)*den(48)
  den(50) = den(9)*den(44)
  den(51) = den(7)*den(50)
  den(52) = den(4)*den(41)
  den(53) = den(6)*den(52)
  den(54) = den(6)*den(38)
  den(55) = den(4)*den(54)
  den(56) = den(2)*den(47)
  den(57) = den(9)*den(56)
  den(58) = den(9)*den(33)
  den(59) = den(2)*den(58)
  den(63) = den(13)*den(62)
  den(65) = den(60)*den(64)
  den(66) = den(1)*den(62)
  den(67) = den(1)*den(64)
  den(69) = den(1)*den(68)
  den(70) = den(7)*den(62)
  den(71) = den(7)*den(64)
  den(72) = den(7)*den(68)
  den(74) = den(6)*den(73)
  den(76) = den(6)*den(75)
  den(78) = den(6)*den(77)
  den(79) = den(2)*den(73)
  den(80) = den(2)*den(75)
  den(81) = den(2)*den(77)
  den(83) = den(9)*den(82)
  den(85) = den(9)*den(84)
  den(87) = den(9)*den(86)
  den(88) = den(4)*den(82)
  den(89) = den(4)*den(84)
  den(90) = den(4)*den(86)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif

! **********************************************************************
subroutine allocate_diagrams()
!-----------------------------------------------------------------------
! After the first Born evaluation, colour-stripped amplitudes and
! colour vectors are initialiased with the minimum number of relevant
! helicity states.
! **********************************************************************
#ifndef PRECISION_dp
  use ol_loop_storage_pphtt_ew_ttxhaa_2_/**/DREALKIND, only: hel_states
#endif
  implicit none

  if (allocated(A)) deallocate(A)
  if (allocated(M1helarray)) deallocate(M1helarray)
  if (allocated(M1helarray_ct)) deallocate(M1helarray_ct)
  if (allocated(M0_col1_helarray)) deallocate(M0_col1_helarray)
  allocate(A(hel_states,51))
  allocate(M1helarray(1,hel_states))
  allocate(M1helarray_ct(1,hel_states))
  allocate(M0_col1_helarray(1,hel_states))
#if 1 > 0
  if (allocated(M0M1_hel_cc)) deallocate(M0M1_hel_cc)
  allocate(M0M1_hel_cc(1,hel_states,16))
#endif
end subroutine allocate_diagrams

!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_pphtt_ew_ttxhaa_2_/**/DREALKIND, only: &
  nhel, Hel, hel_states
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for top anti-top higgs gamma gamma -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init, ensure_mp_loop_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_settings_pphtt_ew_ttxhaa_2, only: hel_mem_opt, loopcc
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_pphtt_ew_ttxhaa_2, only: &
    & external_perm_pphtt_ew_ttxhaa_2, &
    & external_perm_inv_pphtt_ew_ttxhaa_2, &
    & extcomb_perm_pphtt_ew_ttxhaa_2, &
    & average_factor_pphtt_ew_ttxhaa_2
  use ol_external_pphtt_ew_ttxhaa_2, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_pphtt_ew_ttxhaa_2_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pphtt_ew_ttxhaa_2_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_pphtt_ew_ttxhaa_2
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: &
    & IR_is_on, DOI, CT_is_on, R2_is_on, TP_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(16)
  logical, intent(in) :: qp_kinematics
  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(1), M2(1)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak, DOI_bak

#if 5 > 3
  integer :: ind_cc_comb(5)
#endif

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(51)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    DOI_bak = DOI
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    DOI = 1
    call amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
    DOI = DOI_bak
  end if

  if (ntry < 2) then
    if (allocated(A)) deallocate(A)
    allocate(A(nhel,51))
  end if

  call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()
  call ensure_mp_loop_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    call check_forced_parameters()
  end if
  call fac_init_loop()

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMT, nMT, nMH, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_pphtt_ew_ttxhaa_2, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMT, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rMT, H2, ex2, POLSEL(2),2)
  call pol_wf_S(P(:,3), rMH, H3, ex3, POLSEL(3),3)
  call pol_wf_V(P(:,4), rZERO, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rZERO, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QS_A(gH,ntry, ex1(:), ex3(:), wf2(:,1), n3(:,1), t3x2(:,:,1))
  call vert_AV_Q(ntry, ex2(:), ex4(:), wf4(:,1), n3(:,2), t3x4(:,:,1))
  call prop_Q_A(ntry, wf2(:,1), 5, MT, 1_intkind1, wf2(:,2), n2(1))
  call prop_A_Q(ntry, wf4(:,1), 10, MT, 1_intkind1, wf4(:,2), n2(2))
  call vert_VQ_A(ntry, ex5(:), wf2(:,2), wf4(:,3), n3(:,3), t3x4(:,:,2))
  call vert_AV_Q(ntry, ex2(:), ex5(:), wf4(:,4), n3(:,4), t3x4(:,:,3))
  call prop_A_Q(ntry, wf4(:,4), 18, MT, 1_intkind1, wf4(:,5), n2(3))
  call vert_VQ_A(ntry, ex4(:), wf2(:,2), wf4(:,6), n3(:,5), t3x4(:,:,4))
  call vert_VQ_A(ntry, ex4(:), ex1(:), wf4(:,7), n3(:,6), t3x4(:,:,5))
  call vert_SA_Q(gH,ntry, ex3(:), ex2(:), wf2(:,3), n3(:,7), t3x2(:,:,2))
  call prop_Q_A(ntry, wf4(:,7), 9, MT, 1_intkind1, wf4(:,8), n2(4))
  call prop_A_Q(ntry, wf2(:,3), 6, MT, 1_intkind1, wf2(:,4), n2(5))
  call vert_VQ_A(ntry, ex5(:), wf4(:,8), wf8(:,1), n3(:,8), t3x8(:,:,1))
  call vert_VQ_A(ntry, ex5(:), ex1(:), wf4(:,9), n3(:,9), t3x4(:,:,6))
  call prop_Q_A(ntry, wf4(:,9), 17, MT, 1_intkind1, wf4(:,10), n2(6))
  call vert_VQ_A(ntry, ex4(:), wf4(:,10), wf8(:,2), n3(:,10), t3x8(:,:,2))
  call vert_QS_A(gH,ntry, wf4(:,8), ex3(:), wf4(:,11), n3(:,11), t3x4(:,:,7))
  call vert_QS_A(gH,ntry, wf4(:,10), ex3(:), wf4(:,12), n3(:,12), t3x4(:,:,8))
  call vert_AQ_S(gH,ntry, ex2(:), ex1(:), wf4(:,13), n3(:,13), t3x4(:,:,9))
  call counter_VV_S(ntry, ex4(:), ex5(:), wf4(:,14), n3(:,14), t3x4(:,:,10))
  call vert_SS_S(ntry, wf4(:,13), ex3(:), wf4(:,15), n3(:,15), t3x4(:,:,11))
  call counter_VQ_A_LR(EWctAtt,ntry, ex5(:), wf2(:,2), wf4(:,16), n3(:,16), t3x4(:,:,12))
  call counter_VQ_A_LR(EWctAtt,ntry, ex4(:), wf2(:,2), wf4(:,17), n3(:,17), t3x4(:,:,13))
  call vert_AQ_S(gH,ntry, ex2(:), wf2(:,2), wf4(:,18), n3(:,18), t3x4(:,:,14))
  call counter_VQ_A_LR(EWctAtt,ntry, ex5(:), wf4(:,8), wf8(:,3), n3(:,19), t3x8(:,:,3))
  call counter_VQ_A_LR(EWctAtt,ntry, ex4(:), wf4(:,10), wf8(:,4), n3(:,20), t3x8(:,:,4))
  call vert_AQ_S(gH,ntry, wf2(:,4), ex1(:), wf4(:,19), n3(:,21), t3x4(:,:,15))
  call counter_QS_A(EWctHtt,ntry, wf4(:,8), ex3(:), wf4(:,20), n3(:,22), t3x4(:,:,16))
  call counter_TV_S(ntry, ex3(:), 4, ex5(:), 16, wf2(:,5), n3(:,23), t3x2(:,:,3))
  call vert_AQ_S(gX,ntry, ex2(:), wf4(:,8), wf8(:,5), n3(:,24), t3x8(:,:,5))
  call counter_SV_V(ntry, ex3(:), ex5(:), wf2(:,6), n3(:,25), t3x2(:,:,4))
  call vert_QA_V(ntry, wf4(:,8), ex2(:), wf8(:,6), n3(:,26), t3x8(:,:,6))
  call vert_QA_Z(gZu,ntry, wf4(:,8), ex2(:), wf8(:,7), n3(:,27), t3x8(:,:,7))
  call counter_QS_A(EWctHtt,ntry, wf4(:,10), ex3(:), wf4(:,21), n3(:,28), t3x4(:,:,17))
  call vert_AQ_S(gX,ntry, wf4(:,2), ex1(:), wf8(:,8), n3(:,29), t3x8(:,:,8))
  call vert_QA_V(ntry, ex1(:), wf4(:,2), wf8(:,9), n3(:,30), t3x8(:,:,9))
  call vert_QA_Z(gZu,ntry, ex1(:), wf4(:,2), wf8(:,10), n3(:,31), t3x8(:,:,10))
  call counter_TV_S(ntry, ex3(:), 4, ex4(:), 8, wf2(:,7), n3(:,32), t3x2(:,:,5))
  call vert_AQ_S(gX,ntry, ex2(:), wf4(:,10), wf8(:,11), n3(:,33), t3x8(:,:,11))
  call counter_SV_V(ntry, ex3(:), ex4(:), wf2(:,8), n3(:,34), t3x2(:,:,6))
  call vert_QA_V(ntry, wf4(:,10), ex2(:), wf8(:,12), n3(:,35), t3x8(:,:,12))
  call vert_QA_Z(gZu,ntry, wf4(:,10), ex2(:), wf8(:,13), n3(:,36), t3x8(:,:,13))
  call vert_AQ_S(gX,ntry, wf4(:,5), ex1(:), wf8(:,14), n3(:,37), t3x8(:,:,14))
  call vert_QA_V(ntry, ex1(:), wf4(:,5), wf8(:,15), n3(:,38), t3x8(:,:,15))
  call vert_QA_Z(gZu,ntry, ex1(:), wf4(:,5), wf8(:,16), n3(:,39), t3x8(:,:,16))
  call counter_AV_Q_LR(EWctAtt,ntry, ex2(:), ex5(:), wf4(:,22), n3(:,40), t3x4(:,:,18))
  call prop_A_Q(ntry, wf4(:,22), 18, MT, 1_intkind1, wf4(:,23), n2(7))
  call counter_AV_Q_LR(EWctAtt,ntry, ex2(:), ex4(:), wf4(:,24), n3(:,41), t3x4(:,:,19))
  call prop_A_Q(ntry, wf4(:,24), 10, MT, 1_intkind1, wf4(:,25), n2(8))
  call counter_SA_Q(EWctHtt,ntry, ex3(:), ex2(:), wf2(:,9), n3(:,42), t3x2(:,:,7))
  call prop_A_Q(ntry, wf2(:,9), 6, MT, 1_intkind1, wf2(:,10), n2(9))
  call counter_VQ_A_LR(EWctAtt,ntry, ex5(:), ex1(:), wf4(:,26), n3(:,43), t3x4(:,:,20))
  call prop_Q_A(ntry, wf4(:,26), 17, MT, 1_intkind1, wf4(:,27), n2(10))
  call vert_VQ_A(ntry, ex4(:), wf4(:,27), wf8(:,17), n3(:,44), t3x8(:,:,17))
  call counter_VQ_A_LR(EWctAtt,ntry, ex4(:), ex1(:), wf4(:,28), n3(:,45), t3x4(:,:,21))
  call prop_Q_A(ntry, wf4(:,28), 9, MT, 1_intkind1, wf4(:,29), n2(11))
  call vert_VQ_A(ntry, ex5(:), wf4(:,29), wf8(:,18), n3(:,46), t3x8(:,:,18))
  call vert_QS_A(gH,ntry, wf4(:,27), ex3(:), wf4(:,30), n3(:,47), t3x4(:,:,22))
  call vert_QS_A(gH,ntry, wf4(:,29), ex3(:), wf4(:,31), n3(:,48), t3x4(:,:,23))
  call counter_QS_A(EWctHtt,ntry, ex1(:), ex3(:), wf2(:,11), n3(:,49), t3x2(:,:,8))
  call prop_Q_A(ntry, wf2(:,11), 5, MT, 1_intkind1, wf2(:,12), n2(12))
  call vert_VQ_A(ntry, ex5(:), wf2(:,12), wf4(:,32), n3(:,50), t3x4(:,:,24))
  call vert_VQ_A(ntry, ex4(:), wf2(:,12), wf4(:,33), n3(:,51), t3x4(:,:,25))
  call vert_AV_Q(ntry, wf4(:,2), ex5(:), wf8(:,19), n3(:,52), t3x8(:,:,19))
  call counter_Q_A_LR(EWcttt,ntry, wf2(:,2), 5, wf2(:,13), n2(13))
  call prop_A_Q(ntry, wf8(:,19), 26, MT, 1_intkind1, wf8(:,20), n2(14))
  call counter_A_Q_LR(EWcttt,ntry, wf4(:,2), 10, wf4(:,34), n2(15))
  call prop_Q_A(ntry, wf4(:,3), 21, MT, 1_intkind1, wf4(:,35), n2(16))
  call vert_AV_Q(ntry, wf4(:,5), ex4(:), wf8(:,21), n3(:,53), t3x8(:,:,20))
  call prop_A_Q(ntry, wf8(:,21), 26, MT, 1_intkind1, wf8(:,22), n2(17))
  call counter_A_Q_LR(EWcttt,ntry, wf4(:,5), 18, wf4(:,36), n2(18))
  call prop_Q_A(ntry, wf4(:,6), 13, MT, 1_intkind1, wf4(:,37), n2(19))
  call vert_AV_Q(ntry, wf2(:,4), ex5(:), wf4(:,38), n3(:,54), t3x4(:,:,26))
  call counter_Q_A_LR(EWcttt,ntry, wf4(:,8), 9, wf4(:,39), n2(20))
  call prop_A_Q(ntry, wf4(:,38), 22, MT, 1_intkind1, wf4(:,40), n2(21))
  call counter_A_Q_LR(EWcttt,ntry, wf2(:,4), 6, wf2(:,14), n2(22))
  call prop_Q_A(ntry, wf8(:,1), 25, MT, 1_intkind1, wf8(:,23), n2(23))
  call vert_AV_Q(ntry, wf2(:,4), ex4(:), wf4(:,41), n3(:,55), t3x4(:,:,27))
  call counter_Q_A_LR(EWcttt,ntry, wf4(:,10), 17, wf4(:,42), n2(24))
  call prop_A_Q(ntry, wf4(:,41), 14, MT, 1_intkind1, wf4(:,43), n2(25))
  call prop_Q_A(ntry, wf8(:,2), 25, MT, 1_intkind1, wf8(:,24), n2(26))
  call vert_SA_Q(gH,ntry, ex3(:), wf4(:,5), wf4(:,44), n3(:,56), t3x4(:,:,28))
  call prop_A_Q(ntry, wf4(:,44), 22, MT, 1_intkind1, wf4(:,45), n2(27))
  call prop_Q_A(ntry, wf4(:,11), 13, MT, 1_intkind1, wf4(:,46), n2(28))
  call vert_SA_Q(gH,ntry, ex3(:), wf4(:,2), wf4(:,47), n3(:,57), t3x4(:,:,29))
  call prop_A_Q(ntry, wf4(:,47), 14, MT, 1_intkind1, wf4(:,48), n2(29))
  call prop_Q_A(ntry, wf4(:,12), 21, MT, 1_intkind1, wf4(:,49), n2(30))
  call vert_AQ_S(gX,ntry, ex2(:), ex1(:), wf4(:,50), n3(:,58), t3x4(:,:,30))
  call vert_QA_V(ntry, ex1(:), ex2(:), wf4(:,51), n3(:,59), t3x4(:,:,31))
  call vert_QA_Z(gZu,ntry, ex1(:), ex2(:), wf4(:,52), n3(:,60), t3x4(:,:,32))
  call vert_SS_S(ntry, wf4(:,50), ex3(:), wf4(:,53), n3(:,61), t3x4(:,:,33))
  call vert_ST_V(ntry, wf4(:,50), 3, ex3(:), 4, wf4(:,54), n3(:,62), t3x4(:,:,34))
  call vert_TV_S(ntry, ex3(:), 4, wf4(:,52), 3, wf4(:,55), n3(:,63), t3x4(:,:,35))
  call vert_SV_V(ntry, ex3(:), wf4(:,52), wf4(:,56), n3(:,64), t3x4(:,:,36))
  call vert_AQ_S(gX,ntry, ex2(:), wf2(:,2), wf4(:,57), n3(:,65), t3x4(:,:,37))
  call vert_QA_V(ntry, wf2(:,2), ex2(:), wf4(:,58), n3(:,66), t3x4(:,:,38))
  call vert_QA_Z(gZu,ntry, wf2(:,2), ex2(:), wf4(:,59), n3(:,67), t3x4(:,:,39))
  call vert_AQ_S(gX,ntry, wf2(:,4), ex1(:), wf4(:,60), n3(:,68), t3x4(:,:,40))
  call vert_QA_V(ntry, ex1(:), wf2(:,4), wf4(:,61), n3(:,69), t3x4(:,:,41))
  call vert_QA_Z(gZu,ntry, ex1(:), wf2(:,4), wf4(:,62), n3(:,70), t3x4(:,:,42))
  call vert_AQ_S(gH,ntry, ex2(:), wf4(:,8), wf8(:,25), n3(:,71), t3x8(:,:,21))
  call vert_AQ_S(gH,ntry, wf4(:,2), ex1(:), wf8(:,26), n3(:,72), t3x8(:,:,22))
  call vert_AQ_S(gH,ntry, ex2(:), wf4(:,10), wf8(:,27), n3(:,73), t3x8(:,:,23))
  call vert_AQ_S(gH,ntry, wf4(:,5), ex1(:), wf8(:,28), n3(:,74), t3x8(:,:,24))


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  if (ntry < 2) then
    if(hel_mem_opt) hel_states = nhel
    call allocate_diagrams()
  end if

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

#if 1 > 0 && 5 > 3
  if (loopcc) then
    !!Born-loop colour correlators interference
    ind_cc_comb = [2,4,7,5,8]
    M0M1_hel_cc(:,:,:)%j = 0
    M2ctcc = 0
    do n = 1, 5
      M2add_ct = 0
      m = ind_cc_comb(n)
        do k = 1, nhel
          call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
          call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
          M2ctcc(m) = M2ctcc(m) + M2add_ct
        end do
    end do
    M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
    M0M1_hel_cc(:,nhel+1:,:)%j = 0
  end if
#endif

  if (ntry < 1) then
    if (allocated(A)) deallocate(A)
  end if
  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 2
do i4= 1, 2
do i3= 1, 1
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_QA(nsync, wf4(:,2), wf4(:,3), A(:,1), n3(:,75), t3x16(:,:,1), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,5), wf4(:,6), A(:,2), n3(:,76), t3x16(:,:,2), nhel, den(5))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,1), A(:,3), n3(:,77), t3x16(:,:,3), nhel, den(8))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,2), A(:,4), n3(:,78), t3x16(:,:,4), nhel, den(10))
    call Hcont_QA(nsync, wf4(:,5), wf4(:,11), A(:,5), n3(:,79), t3x16(:,:,5), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,2), wf4(:,12), A(:,6), n3(:,80), t3x16(:,:,6), nhel, den(12))

    call Hcont_SS(nsync, wf4(:,14), wf4(:,15), A(:,7), n3(:,81), t3x16(:,:,7), nhel, den(15))
    call Hcont_QA(nsync, wf4(:,2), wf4(:,16), A(:,8), n3(:,82), t3x16(:,:,8), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,5), wf4(:,17), A(:,9), n3(:,83), t3x16(:,:,9), nhel, den(5))
    call Hcont_SS(nsync, wf4(:,14), wf4(:,18), A(:,10), n3(:,84), t3x16(:,:,10), nhel, den(16))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,3), A(:,11), n3(:,85), t3x16(:,:,11), nhel, den(8))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,4), A(:,12), n3(:,86), t3x16(:,:,12), nhel, den(10))
    call Hcont_SS(nsync, wf4(:,14), wf4(:,19), A(:,13), n3(:,87), t3x16(:,:,13), nhel, den(17))
    call Hcont_QA(nsync, wf4(:,5), wf4(:,20), A(:,14), n3(:,88), t3x16(:,:,14), nhel, den(11))
    call Hcont_SS(nsync, wf2(:,5), wf8(:,5), A(:,15), n3(:,89), t3x16(:,:,15), nhel, den(19))
    call Hcont_VV(nsync, wf2(:,6), wf8(:,6), A(:,16), n3(:,90), t3x16(:,:,16), nhel, den(21))
    call Hcont_VV(nsync, wf2(:,6), wf8(:,7), A(:,17), n3(:,91), t3x16(:,:,17), nhel, den(19))
    call Hcont_QA(nsync, wf4(:,2), wf4(:,21), A(:,18), n3(:,92), t3x16(:,:,18), nhel, den(12))
    call Hcont_SS(nsync, wf2(:,5), wf8(:,8), A(:,19), n3(:,93), t3x16(:,:,19), nhel, den(22))
    call Hcont_VV(nsync, wf2(:,6), wf8(:,9), A(:,20), n3(:,94), t3x16(:,:,20), nhel, den(23))
    call Hcont_VV(nsync, wf2(:,6), wf8(:,10), A(:,21), n3(:,95), t3x16(:,:,21), nhel, den(22))
    call Hcont_SS(nsync, wf2(:,7), wf8(:,11), A(:,22), n3(:,96), t3x16(:,:,22), nhel, den(25))
    call Hcont_VV(nsync, wf2(:,8), wf8(:,12), A(:,23), n3(:,97), t3x16(:,:,23), nhel, den(27))
    call Hcont_VV(nsync, wf2(:,8), wf8(:,13), A(:,24), n3(:,98), t3x16(:,:,24), nhel, den(25))
    call Hcont_SS(nsync, wf2(:,7), wf8(:,14), A(:,25), n3(:,99), t3x16(:,:,25), nhel, den(28))
    call Hcont_VV(nsync, wf2(:,8), wf8(:,15), A(:,26), n3(:,100), t3x16(:,:,26), nhel, den(29))
    call Hcont_VV(nsync, wf2(:,8), wf8(:,16), A(:,27), n3(:,101), t3x16(:,:,27), nhel, den(28))
    call Hcont_QA(nsync, wf4(:,6), wf4(:,23), A(:,28), n3(:,102), t3x16(:,:,28), nhel, den(5))
    call Hcont_QA(nsync, wf4(:,3), wf4(:,25), A(:,29), n3(:,103), t3x16(:,:,29), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,11), wf4(:,23), A(:,30), n3(:,104), t3x16(:,:,30), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,12), wf4(:,25), A(:,31), n3(:,105), t3x16(:,:,31), nhel, den(12))
    call Hcont_QA(nsync, wf8(:,1), wf2(:,10), A(:,32), n3(:,106), t3x16(:,:,32), nhel, den(8))
    call Hcont_QA(nsync, wf8(:,2), wf2(:,10), A(:,33), n3(:,107), t3x16(:,:,33), nhel, den(10))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,17), A(:,34), n3(:,108), t3x16(:,:,34), nhel, den(10))
    call Hcont_QA(nsync, wf2(:,4), wf8(:,18), A(:,35), n3(:,109), t3x16(:,:,35), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,2), wf4(:,30), A(:,36), n3(:,110), t3x16(:,:,36), nhel, den(12))
    call Hcont_QA(nsync, wf4(:,5), wf4(:,31), A(:,37), n3(:,111), t3x16(:,:,37), nhel, den(11))
    call Hcont_QA(nsync, wf4(:,2), wf4(:,32), A(:,38), n3(:,112), t3x16(:,:,38), nhel, den(3))
    call Hcont_QA(nsync, wf4(:,5), wf4(:,33), A(:,39), n3(:,113), t3x16(:,:,39), nhel, den(5))
    call Hcont_QA(nsync, wf2(:,13), wf8(:,20), A(:,40), n3(:,114), t3x16(:,:,40), nhel, den(32))
    call Hcont_QA(nsync, wf4(:,34), wf4(:,35), A(:,41), n3(:,115), t3x16(:,:,41), nhel, den(35))
    call Hcont_QA(nsync, wf2(:,13), wf8(:,22), A(:,42), n3(:,116), t3x16(:,:,42), nhel, den(37))
    call Hcont_QA(nsync, wf4(:,36), wf4(:,37), A(:,43), n3(:,117), t3x16(:,:,43), nhel, den(40))
    call Hcont_QA(nsync, wf4(:,39), wf4(:,40), A(:,44), n3(:,118), t3x16(:,:,44), nhel, den(43))
    call Hcont_QA(nsync, wf2(:,14), wf8(:,23), A(:,45), n3(:,119), t3x16(:,:,45), nhel, den(46))
    call Hcont_QA(nsync, wf4(:,42), wf4(:,43), A(:,46), n3(:,120), t3x16(:,:,46), nhel, den(49))
    call Hcont_QA(nsync, wf2(:,14), wf8(:,24), A(:,47), n3(:,121), t3x16(:,:,47), nhel, den(51))
    call Hcont_QA(nsync, wf4(:,39), wf4(:,45), A(:,48), n3(:,122), t3x16(:,:,48), nhel, den(53))
    call Hcont_QA(nsync, wf4(:,36), wf4(:,46), A(:,49), n3(:,123), t3x16(:,:,49), nhel, den(55))
    call Hcont_QA(nsync, wf4(:,42), wf4(:,48), A(:,50), n3(:,124), t3x16(:,:,50), nhel, den(57))
    call Hcont_QA(nsync, wf4(:,34), wf4(:,49), A(:,51), n3(:,125), t3x16(:,:,51), nhel, den(59))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(1) ! M1helarray(1,nhel)
  integer :: empty(0), i

  M1(1)%j = (A(j,1)%j+A(j,2)%j+A(j,3)%j+A(j,4)%j+A(j,5)%j+A(j,6)%j)*f(6)

  M2(1)%j = (A(j,16)%j+A(j,20)%j+A(j,23)%j+A(j,26)%j)*f(1)+(-A(j,17)%j-A(j,21)%j-A(j,24)%j-A(j,27)%j)*f(2)+(-A(j,14)%j-A(j,18)%j &
       -A(j,32)%j-A(j,33)%j-A(j,38)%j-A(j,39)%j)*f(3)-A(j,7)%j*f(4)+(-A(j,10)%j-A(j,13)%j)*f(5)+(-A(j,40)%j-A(j,41)%j-A(j,42)%j &
       -A(j,43)%j-A(j,44)%j-A(j,45)%j-A(j,46)%j-A(j,47)%j-A(j,48)%j-A(j,49)%j-A(j,50)%j-A(j,51)%j)*f(7)+(-A(j,8)%j-A(j,9)%j &
       -A(j,11)%j-A(j,12)%j-A(j,28)%j-A(j,29)%j-A(j,30)%j-A(j,31)%j-A(j,34)%j-A(j,35)%j-A(j,36)%j-A(j,37)%j)*f(8)+(A(j,15)%j &
       +A(j,19)%j+A(j,22)%j+A(j,25)%j)*f(9)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphtt_ew_ttxhaa_2_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphtt_ew_ttxhaa_2_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(1)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 1
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_pphtt_ew_ttxhaa_2_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pphtt_ew_ttxhaa_2_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_pphtt_ew_ttxhaa_2_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(1)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 1 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_pphtt_ew_ttxhaa_2_/**/REALKIND
