
module ol_vamp_1_pphllj_ew_nenexbbxhg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphllj_ew_nenexbbxhg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphllj_ew_nenexbbxhg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pphllj_ew_nenexbbxhg_1_/**/DREALKIND
  use ol_tensor_sum_storage_pphllj_ew_nenexbbxhg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pphllj_ew_nenexbbxhg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pphllj_ew_nenexbbxhg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(103)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[32,8,2,1,4,16],[nMB,nMZ,0,nMZ,nMB,nMB],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (c(12)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[32,8,2,1,4,16],[nMT,nMW,0,nMW,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (c(103)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[32,4,1,2,8,16],[nMB,nMZ,0,nMZ,nMB,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (c(12)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[32,4,1,2,8,16],[nMT,nMW,0,nMW,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(4),n2h16(4))
  Gcoeff(:)%j = (-(c(83)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[32,4,1,2,16,8],[nMB,nMZ,0,nMZ,nMZ,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(5),n2h16(5))
  Gcoeff(:)%j = (c(7)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[32,4,1,2,16,8],[nMT,nMW,0,nMW,nMW,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(6),n2h16(6))
  Gcoeff(:)%j = (c(110)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[32,4,1,2,16,8],[nMB,nMZ,0,nMZ,nMZ,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(7),n2h16(7))
  Gcoeff(:)%j = (c(13)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[32,4,1,2,16,8],[nMT,nMW,0,nMW,nMW,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(8),n2h16(8))
  Gcoeff(:)%j = (c(103)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[32,8,1,2,4,16],[nMB,nMZ,0,nMZ,nMB,nMB],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(9),n2h16(9))
  Gcoeff(:)%j = (c(103)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[32,4,2,1,8,16],[nMB,nMZ,0,nMZ,nMB,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(10),n2h16(10))
  Gcoeff(:)%j = (-(c(83)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[32,4,16,2,1,8],[nMB,nMZ,nMZ,0,nMZ,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(11),n2h16(11))
  Gcoeff(:)%j = (c(110)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[32,4,16,2,1,8],[nMB,nMZ,nMZ,0,nMZ,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(12),n2h16(12))
  Gcoeff(:)%j = (-(c(83)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[32,4,2,1,16,8],[nMB,nMZ,0,nMZ,nMZ,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(13),n2h16(13))
  Gcoeff(:)%j = (c(110)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[32,4,2,1,16,8],[nMB,nMZ,0,nMZ,nMZ,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(14),n2h16(14))
  Gcoeff(:)%j = (-(c(83)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[32,4,16,1,2,8],[nMB,nMZ,nMZ,0,nMZ,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(15),n2h16(15))
  Gcoeff(:)%j = (c(7)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[32,4,16,1,2,8],[nMT,nMW,nMW,0,nMW,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(16),n2h16(16))
  Gcoeff(:)%j = (c(110)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[32,4,16,1,2,8],[nMB,nMZ,nMZ,0,nMZ,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(17),n2h16(17))
  Gcoeff(:)%j = (c(13)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[32,4,16,1,2,8],[nMT,nMW,nMW,0,nMW,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(18),n2h16(18))
  call Hloop_QA_Z(ntryL,G1H16(1),ex4(:),G1H8(1),ngZd,m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_QA_W(ntryL,G1H16(2),ex4(:),G1H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_AQ_Z(ntryL,G1H16(3),ex3(:),G1H8(3),ngZd,m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_AQ_W(ntryL,G1H16(4),ex3(:),G1H8(4),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_AQ_Z(ntryL,G1H16(5),ex3(:),G1H8(5),ngZd,m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_AQ_W(ntryL,G1H16(6),ex3(:),G1H8(6),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_AQ_Z(ntryL,G1H16(7),ex3(:),G1H8(7),ngZd,m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_AQ_W(ntryL,G1H16(8),ex3(:),G1H8(8),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_QA_Z(ntryL,G1H16(9),ex4(:),G1H8(9),ngZd,m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_AQ_Z(ntryL,G1H16(10),ex3(:),G1H8(10),ngZd,m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_AQ_S(ntryL,G1H16(11),ex3(:),G1H8(11),ngX,m3h2x8(:,11),heltab2x16(:,:,11))
  call Hloop_AQ_Z(ntryL,G1H16(12),ex3(:),G1H8(12),ngZd,m3h2x8(:,12),heltab2x16(:,:,12))
  call Hloop_AQ_Z(ntryL,G1H16(13),ex3(:),G1H8(13),ngZd,m3h2x8(:,13),heltab2x16(:,:,13))
  call Hloop_AQ_Z(ntryL,G1H16(14),ex3(:),G1H8(14),ngZd,m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_AQ_S(ntryL,G1H16(15),ex3(:),G1H8(15),ngX,m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_AQ_S(ntryL,G1H16(16),ex3(:),G1H8(16),ngPtb,m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_AQ_Z(ntryL,G1H16(17),ex3(:),G1H8(17),ngZd,m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_AQ_W(ntryL,G1H16(18),ex3(:),G1H8(18),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_ZA_Q(ntryL,G1H8(1),ex2(:),G1H4(1),ngZn,m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_A_Q(ntryL,G1H4(1),42,0,G2H4(1),n2h4(1))
  call Hloop_WA_Q(ntryL,G1H8(2),ex2(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_A_Q(ntryL,G1H4(1),42,0,G2H4(2),n2h4(2))
  call Hloop_ZQ_A(ntryL,G1H8(3),ex1(:),G1H4(1),ngZn,m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),37,0,G2H4(3),n2h4(3))
  call Hloop_WQ_A(ntryL,G1H8(4),ex1(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),37,0,G2H4(4),n2h4(4))
  call Hloop_ZQ_A(ntryL,G1H8(5),ex1(:),G1H4(1),ngZn,m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H4(1),37,0,G2H4(5),n2h4(5))
  call Hloop_WQ_A(ntryL,G1H8(6),ex1(:),G1H4(1),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_Q_A(ntryL,G1H4(1),37,0,G2H4(6),n2h4(6))
  call Hloop_ZQ_A(ntryL,G1H8(7),ex1(:),G1H4(1),ngZn,m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H4(1),37,0,G2H4(7),n2h4(7))
  call Hloop_WQ_A(ntryL,G1H8(8),ex1(:),G1H4(1),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(1),37,0,G2H4(8),n2h4(8))
  call Hloop_ZQ_A(ntryL,G1H8(9),ex1(:),G1H4(1),ngZn,m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),41,0,G2H4(9),n2h4(9))
  call Hloop_ZA_Q(ntryL,G1H8(10),ex2(:),G1H4(1),ngZn,m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_A_Q(ntryL,G1H4(1),38,0,G2H4(10),n2h4(10))
  call Hloop_ST_V(ntryL,G1H8(11),36,ex5(:),16,G2H8(1),m3h1x8(:,1),heltab2x8(:,:,11))
  call Hloop_VS_V(ntryL,G1H8(12),ex5(:),G1H8(1),m3h1x8(:,2),heltab2x8(:,:,12))
  call Hloop_ZA_Q(ntryL,G1H8(13),ex2(:),G1H4(1),ngZn,m3h2x4(:,11),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G1H4(1),38,0,G2H4(11),n2h4(11))
  call Hloop_ZA_Q(ntryL,G1H8(14),ex2(:),G1H4(1),ngZn,m3h2x4(:,12),heltab2x8(:,:,14))
  call Hloop_A_Q(ntryL,G1H4(1),38,0,G2H4(12),n2h4(12))
  call Hloop_ST_V(ntryL,G1H8(15),36,ex5(:),16,G2H8(2),m3h1x8(:,3),heltab2x8(:,:,15))
  call Hloop_ST_V(ntryL,G1H8(16),36,ex5(:),16,G2H8(3),m3h1x8(:,4),heltab2x8(:,:,16))
  call Hloop_VS_V(ntryL,G1H8(17),ex5(:),G1H8(2),m3h1x8(:,5),heltab2x8(:,:,17))
  call Hloop_VS_V(ntryL,G1H8(18),ex5(:),G1H8(3),m3h1x8(:,6),heltab2x8(:,:,18))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(1),[G1H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(2),[G1H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(3),[G1H8(3)])
  call Hloop_AQ_Z(ntryL,G2H4(1),ex1(:),G2H2(1),ngZn,m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_W(ntryL,G2H4(2),ex1(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_QA_Z(ntryL,G2H4(3),ex2(:),G2H2(3),ngZn,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_QA_W(ntryL,G2H4(4),ex2(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_Z(ntryL,G2H4(5),ex2(:),G2H2(5),ngZn,m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_W(ntryL,G2H4(6),ex2(:),G2H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_QA_Z(ntryL,G2H4(7),ex2(:),G2H2(7),ngZn,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_QA_W(ntryL,G2H4(8),ex2(:),G2H2(8),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_QA_Z(ntryL,G2H4(9),ex2(:),G2H2(9),ngZn,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_Z(ntryL,G2H4(10),ex1(:),G2H2(10),ngZn,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(1),mass5set(:,1),  & 
G1H8(4),G1H8(5),G1H8(6),G1H8(7),G1H8(8),G1H8(9),8)
  call HG1shiftOLR(G1H8(5),8,8)
  call Hloop_AQ_Z(ntryL,G2H4(11),ex1(:),G2H2(11),ngZn,m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_Z(ntryL,G2H4(12),ex1(:),G2H2(12),ngZn,m3h2x2(:,12),heltab2x4(:,:,12))
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(2),mass5set(:,1),  & 
G1H8(10),G1H8(11),G1H8(12),G1H8(13),G1H8(14),G1H8(15),8)
  call HG1shiftOLR(G1H8(11),8,8)
  call Hotf_5pt_reduction(G2H8(3),RedSet_5(2),mass5set(:,2),  & 
G1H8(16),G1H8(17),G1H8(18),G1H8(1),G1H8(2),G1H8(3),8)
  call HG1shiftOLR(G1H8(17),8,8)
  call Hloop_ZA_Q(ntryL,G1H8(4),ex2(:),G1H4(1),ngZn,m3h2x4(:,13),heltab2x8(:,:,19))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(1),n2h4(13))
call HGT_OLR(G1H8(5),1,1,8)
call HGT_invQ_OLR(G1H8(5),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(5),-8,nMB,G2H8(1),n2h8(1))
  call Hloop_QA_Z(ntryL,G2H8(1),ex4(:),G2H4(2),ngZd,m3h2x4(:,14),heltab2x8(:,:,20))
  call Hloop_ZA_Q(ntryL,G1H8(8),ex2(:),G1H4(1),ngZn,m3h2x4(:,15),heltab2x8(:,:,21))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(3),n2h4(14))
  call Hloop_ZA_Q(ntryL,G1H8(9),ex2(:),G1H4(1),ngZn,m3h2x4(:,16),heltab2x8(:,:,22))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(4),n2h4(15))
  call Hloop_ZQ_A(ntryL,G1H8(10),ex1(:),G1H4(1),ngZn,m3h2x4(:,17),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(5),n2h4(16))
call HGT_OLR(G1H8(11),1,1,8)
call HGT_invQ_OLR(G1H8(11),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(11),-8,nMB,G2H8(2),n2h8(2))
  call Hloop_QA_Z(ntryL,G2H8(2),ex4(:),G2H4(6),ngZd,m3h2x4(:,18),heltab2x8(:,:,24))
  call Hloop_ZQ_A(ntryL,G1H8(14),ex1(:),G1H4(1),ngZn,m3h2x4(:,19),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(7),n2h4(17))
  call Hloop_ZQ_A(ntryL,G1H8(15),ex1(:),G1H4(1),ngZn,m3h2x4(:,20),heltab2x8(:,:,26))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(8),n2h4(18))
  call Hloop_WQ_A(ntryL,G1H8(16),ex1(:),G1H4(1),m3h2x4(:,21),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(9),n2h4(19))
call HGT_OLR(G1H8(17),1,1,8)
call HGT_invQ_OLR(G1H8(17),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(17),-8,nMT,G2H8(3),n2h8(3))
  call Hloop_QA_W(ntryL,G2H8(3),ex4(:),G2H4(10),m3h2x4(:,22),heltab2x8(:,:,28))
  call Hloop_WQ_A(ntryL,G1H8(2),ex1(:),G1H4(1),m3h2x4(:,23),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(11),n2h4(20))
  call Hloop_WQ_A(ntryL,G1H8(3),ex1(:),G1H4(1),m3h2x4(:,24),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(12),n2h4(21))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(3),mass5set(:,3),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),16,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(3),mass5set(:,4),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),16,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(4),mass5set(:,3),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),16,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(4),mass5set(:,4),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),16,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(4),mass5set(:,3),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),8,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(4),mass5set(:,4),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),8,2)
  call Hloop_VS_V(ntryL,G2H2(7),ex5(:),G2H2(1),m3h1x2(:,1),heltab2x2(:,:,1))
  call Hloop_VS_V(ntryL,G2H2(8),ex5(:),G2H2(2),m3h1x2(:,2),heltab2x2(:,:,2))
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(5),mass5set(:,3),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),16,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(6),mass5set(:,3),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(44),16,2)
  call Hotf_5pt_reduction(G2H2(11),RedSet_5(6),mass5set(:,3),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(50),8,2)
  call Hloop_VS_V(ntryL,G2H2(12),ex5(:),G2H2(3),m3h1x2(:,3),heltab2x2(:,:,3))
  call Hloop_AQ_Z(ntryL,G2H4(1),ex1(:),G2H2(4),ngZn,m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_AQ_Z(ntryL,G2H4(4),ex1(:),G2H2(5),ngZn,m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_QA_Z(ntryL,G2H4(5),ex2(:),G2H2(6),ngZn,m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_Z(ntryL,G2H4(8),ex2(:),G2H2(7),ngZn,m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_QA_W(ntryL,G2H4(9),ex2(:),G2H2(8),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_QA_W(ntryL,G2H4(12),ex2(:),G2H2(9),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_ZQ_A(ntryL,G1H2(1),ex3(:),G1H1(1),ngZd,m3h2x1(:,1),heltab2x2(:,:,4))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMB,G2H1(1),n2h1(1))
call HGT_OLR(G1H2(2),1,1,2)
call HGT_invQ_OLR(G1H2(2),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(2),-16,nMB,G2H2(10),n2h2(1))
  call Hloop_AS_Q(ntryL,G2H2(10),ex5(:),G2H2(11),ngH,m3h1x2(:,4),heltab2x2(:,:,5))
  call Hloop_ZQ_A(ntryL,G1H2(6),ex3(:),G1H1(1),ngZd,m3h2x1(:,2),heltab2x2(:,:,6))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMB,G2H1(2),n2h1(2))
  call Hloop_WQ_A(ntryL,G1H2(7),ex3(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,7))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMT,G2H1(3),n2h1(3))
call HGT_OLR(G1H2(8),1,1,2)
call HGT_invQ_OLR(G1H2(8),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(8),-16,nMT,G2H2(12),n2h2(2))
  call Hloop_AS_Q(ntryL,G2H2(12),ex5(:),G2H2(10),ngH,m3h1x2(:,5),heltab2x2(:,:,8))
  call Hloop_WQ_A(ntryL,G1H2(12),ex3(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,9))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMT,G2H1(4),n2h1(4))
  call Hloop_ZA_Q(ntryL,G1H2(13),ex4(:),G1H1(1),ngZd,m3h2x1(:,5),heltab2x2(:,:,10))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMB,G2H1(5),n2h1(5))
call HGT_OLR(G1H2(14),1,1,2)
call HGT_invQ_OLR(G1H2(14),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(14),-16,nMB,G2H2(12),n2h2(3))
  call Hloop_QS_A(ntryL,G2H2(12),ex5(:),G2H2(13),ngH,m3h1x2(:,6),heltab2x2(:,:,11))
  call Hloop_ZA_Q(ntryL,G1H2(18),ex4(:),G1H1(1),ngZd,m3h2x1(:,6),heltab2x2(:,:,12))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMB,G2H1(6),n2h1(6))
  call Hloop_WA_Q(ntryL,G1H2(19),ex4(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,13))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMT,G2H1(7),n2h1(7))
call HGT_OLR(G1H2(20),1,1,2)
call HGT_invQ_OLR(G1H2(20),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(20),-16,nMT,G2H2(12),n2h2(4))
  call Hloop_QS_A(ntryL,G2H2(12),ex5(:),G2H2(14),ngH,m3h1x2(:,7),heltab2x2(:,:,14))
  call Hloop_WA_Q(ntryL,G1H2(24),ex4(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,15))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMT,G2H1(8),n2h1(8))
  call Hloop_VT_S(ntryL,G1H2(25),39,ex5(:),16,G2H2(12),m3h1x2(:,8),heltab2x2(:,:,16))
call HGT_OLR(G1H2(26),1,1,2)
call HGT_invQ_OLR(G1H2(26),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(26),-8,nMB,G2H2(15),n2h2(5))
  call Hloop_QA_S(ntryL,G2H2(15),ex4(:),G2H1(9),ngX,m3h2x1(:,9),heltab2x2(:,:,17))
  call Hloop_VT_S(ntryL,G1H2(30),39,ex5(:),16,G2H2(15),m3h1x2(:,9),heltab2x2(:,:,18))
  call Hloop_VT_S(ntryL,G1H2(31),39,ex5(:),16,G2H2(16),m3h1x2(:,10),heltab2x2(:,:,19))
call HGT_OLR(G1H2(32),1,1,2)
call HGT_invQ_OLR(G1H2(32),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(32),-8,nMT,G2H2(17),n2h2(6))
  call Hloop_QA_S(ntryL,G2H2(17),ex4(:),G2H1(10),ngPbt,m3h2x1(:,10),heltab2x2(:,:,20))
  call Hloop_VT_S(ntryL,G1H2(36),39,ex5(:),16,G2H2(17),m3h1x2(:,11),heltab2x2(:,:,21))
  call Hloop_ZQ_A(ntryL,G1H2(37),ex3(:),G1H1(1),ngZd,m3h2x1(:,11),heltab2x2(:,:,22))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMB,G2H1(11),n2h1(9))
call HGT_OLR(G1H2(38),1,1,2)
call HGT_invQ_OLR(G1H2(38),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(38),-16,nMB,G2H2(18),n2h2(7))
  call Hloop_AS_Q(ntryL,G2H2(18),ex5(:),G2H2(19),ngH,m3h1x2(:,12),heltab2x2(:,:,23))
  call Hloop_ZQ_A(ntryL,G1H2(42),ex3(:),G1H1(1),ngZd,m3h2x1(:,12),heltab2x2(:,:,24))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMB,G2H1(12),n2h1(10))
  call Hloop_ZA_Q(ntryL,G1H2(43),ex4(:),G1H1(1),ngZd,m3h2x1(:,13),heltab2x2(:,:,25))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMB,G2H1(13),n2h1(11))
call HGT_OLR(G1H2(44),1,1,2)
call HGT_invQ_OLR(G1H2(44),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(44),-16,nMB,G2H2(18),n2h2(8))
  call Hloop_QS_A(ntryL,G2H2(18),ex5(:),G2H2(20),ngH,m3h1x2(:,13),heltab2x2(:,:,26))
  call Hloop_ZA_Q(ntryL,G1H2(48),ex4(:),G1H1(1),ngZd,m3h2x1(:,14),heltab2x2(:,:,27))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMB,G2H1(14),n2h1(12))
  call Hloop_VT_S(ntryL,G1H2(49),39,ex5(:),16,G2H2(18),m3h1x2(:,14),heltab2x2(:,:,28))
call HGT_OLR(G1H2(50),1,1,2)
call HGT_invQ_OLR(G1H2(50),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(50),-8,nMB,G2H2(21),n2h2(9))
  call Hloop_QA_S(ntryL,G2H2(21),ex4(:),G2H1(15),ngX,m3h2x1(:,15),heltab2x2(:,:,29))
  call Hloop_VT_S(ntryL,G1H2(54),39,ex5(:),16,G2H2(21),m3h1x2(:,15),heltab2x2(:,:,30))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(4),mass5set(:,3),  & 
G1H2(1),G1H2(2),G1H2(6),G1H2(7),G1H2(8),G1H2(12),2)
  call HG1shiftOLR(G1H2(2),8,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(4),mass5set(:,4),  & 
G1H2(13),G1H2(14),G1H2(18),G1H2(19),G1H2(20),G1H2(24),2)
  call HG1shiftOLR(G1H2(14),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(6),mass5set(:,3),  & 
G1H2(25),G1H2(26),G1H2(30),G1H2(31),G1H2(32),G1H2(36),2)
  call HG1shiftOLR(G1H2(26),8,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(1),mass5set(:,1),  & 
G1H2(37),G1H2(38),G1H2(42),G1H2(43),G1H2(44),G1H2(48),2)
  call HG1shiftOLR(G1H2(38),8,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(2),mass5set(:,1),  & 
G1H2(49),G1H2(50),G1H2(54),G1H2(55),G1H2(56),G1H2(57),2)
  call HG1shiftOLR(G1H2(50),8,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(2),mass5set(:,2),  & 
G1H2(58),G1H2(59),G1H2(60),G1H2(61),G1H2(62),G1H2(63),2)
  call HG1shiftOLR(G1H2(59),8,2)
  call Hotf_5pt_reduction(G2H1(1),RedSet_5(3),mass5set(:,3),  & 
G1H1(1),G1H1(2),G1H1(3),G1H1(4),G1H1(5),G1H1(6),1)
  call HG1shiftOLR(G1H1(2),16,1)
  call Hotf_5pt_reduction(G2H1(3),RedSet_5(3),mass5set(:,4),  & 
G1H1(7),G1H1(8),G1H1(9),G1H1(10),G1H1(11),G1H1(12),1)
  call HG1shiftOLR(G1H1(8),16,1)
  call Hotf_5pt_reduction(G2H1(5),RedSet_5(4),mass5set(:,3),  & 
G1H1(13),G1H1(14),G1H1(15),G1H1(16),G1H1(17),G1H1(18),1)
  call HG1shiftOLR(G1H1(14),16,1)
  call Hotf_5pt_reduction(G2H1(7),RedSet_5(4),mass5set(:,4),  & 
G1H1(19),G1H1(20),G1H1(21),G1H1(22),G1H1(23),G1H1(24),1)
  call HG1shiftOLR(G1H1(20),16,1)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(4),mass5set(:,3),  & 
G1H2(64),G1H2(65),G1H2(66),G1H2(67),G1H2(68),G1H2(69),2)
  call HG1shiftOLR(G1H2(65),8,2)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(4),mass5set(:,4),  & 
G1H2(70),G1H2(71),G1H2(72),G1H2(73),G1H2(74),G1H2(75),2)
  call HG1shiftOLR(G1H2(71),8,2)
  call Hotf_5pt_reduction(G2H1(11),RedSet_5(5),mass5set(:,3),  & 
G1H1(25),G1H1(26),G1H1(27),G1H1(28),G1H1(29),G1H1(30),1)
  call HG1shiftOLR(G1H1(26),16,1)
  call Hotf_5pt_reduction(G2H1(13),RedSet_5(6),mass5set(:,3),  & 
G1H1(31),G1H1(32),G1H1(33),G1H1(34),G1H1(35),G1H1(36),1)
  call HG1shiftOLR(G1H1(32),16,1)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(6),mass5set(:,3),  & 
G1H2(76),G1H2(77),G1H2(78),G1H2(79),G1H2(80),G1H2(81),2)
  call HG1shiftOLR(G1H2(77),8,2)
  call Hloop_ZA_Q(ntryL,G1H2(1),ex4(:),G1H1(37),ngZd,m3h2x1(:,16),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(37),63,nMB,G2tensor(1),n2h1(13))
  call Hloop_ZA_Q(ntryL,G1H2(2),ex4(:),G1H1(37),ngZd,m3h2x1(:,17),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(37),8,nMB,G2tensor(2),n2h1(14))
  call Hloop_WA_Q(ntryL,G1H2(13),ex4(:),G1H1(37),m3h2x1(:,18),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(37),63,nMT,G2tensor(3),n2h1(15))
  call Hloop_WA_Q(ntryL,G1H2(14),ex4(:),G1H1(37),m3h2x1(:,19),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(37),8,nMT,G2tensor(4),n2h1(16))
  call Hloop_ZA_Q(ntryL,G1H2(25),ex4(:),G1H1(37),ngZd,m3h2x1(:,20),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(37),63,nMB,G2tensor(5),n2h1(17))
  call Hloop_ZA_Q(ntryL,G1H2(26),ex4(:),G1H1(37),ngZd,m3h2x1(:,21),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(37),8,nMB,G2tensor(6),n2h1(18))
  call Hloop_ZA_Q(ntryL,G1H2(37),ex4(:),G1H1(37),ngZd,m3h2x1(:,22),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(37),63,nMB,G2tensor(7),n2h1(19))
  call Hloop_ZA_Q(ntryL,G1H2(38),ex4(:),G1H1(37),ngZd,m3h2x1(:,23),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(37),8,nMB,G2tensor(8),n2h1(20))
  call Hloop_ZA_Q(ntryL,G1H2(49),ex4(:),G1H1(37),ngZd,m3h2x1(:,24),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(37),63,nMB,G2tensor(9),n2h1(21))
  call Hloop_ZA_Q(ntryL,G1H2(50),ex4(:),G1H1(37),ngZd,m3h2x1(:,25),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(37),8,nMB,G2tensor(10),n2h1(22))
  call Hloop_WA_Q(ntryL,G1H2(58),ex4(:),G1H1(37),m3h2x1(:,26),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(37),63,nMT,G2tensor(11),n2h1(23))
  call Hloop_WA_Q(ntryL,G1H2(59),ex4(:),G1H1(37),m3h2x1(:,27),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(37),8,nMT,G2tensor(12),n2h1(24))
  call Hloop_QS_A(ntryL,G1H1(1),ex5(:),G1H1(37),ngH,m3h1x1(:,1),heltab2x1(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(37),63,nMB,G2tensor(13),n2h1(25))
  call Hloop_QS_A(ntryL,G1H1(2),ex5(:),G1H1(1),ngH,m3h1x1(:,2),heltab2x1(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(14),n2h1(26))
  call Hloop_QS_A(ntryL,G1H1(7),ex5(:),G1H1(37),ngH,m3h1x1(:,3),heltab2x1(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(37),63,nMT,G2tensor(15),n2h1(27))
  call Hloop_QS_A(ntryL,G1H1(8),ex5(:),G1H1(2),ngH,m3h1x1(:,4),heltab2x1(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(2),16,nMT,G2tensor(16),n2h1(28))
  call Hloop_AS_Q(ntryL,G1H1(13),ex5(:),G1H1(1),ngH,m3h1x1(:,5),heltab2x1(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(17),n2h1(29))
  call Hloop_AS_Q(ntryL,G1H1(14),ex5(:),G1H1(7),ngH,m3h1x1(:,6),heltab2x1(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(7),16,nMB,G2tensor(18),n2h1(30))
  call Hloop_AS_Q(ntryL,G1H1(19),ex5(:),G1H1(37),ngH,m3h1x1(:,7),heltab2x1(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(37),63,nMT,G2tensor(19),n2h1(31))
  call Hloop_AS_Q(ntryL,G1H1(20),ex5(:),G1H1(8),ngH,m3h1x1(:,8),heltab2x1(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(8),16,nMT,G2tensor(20),n2h1(32))
  call Hloop_SA_Q(ntryL,G1H2(64),ex4(:),G1H1(2),ngX,m3h2x1(:,28),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),63,nMB,G2tensor(21),n2h1(33))
  call Hloop_SA_Q(ntryL,G1H2(65),ex4(:),G1H1(13),ngX,m3h2x1(:,29),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(13),8,nMB,G2tensor(22),n2h1(34))
  call Hloop_SA_Q(ntryL,G1H2(70),ex4(:),G1H1(1),ngPbt,m3h2x1(:,30),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(23),n2h1(35))
  call Hloop_SA_Q(ntryL,G1H2(71),ex4(:),G1H1(14),ngPbt,m3h2x1(:,31),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(14),8,nMT,G2tensor(24),n2h1(36))
  call Hloop_QS_A(ntryL,G1H1(25),ex5(:),G1H1(7),ngH,m3h1x1(:,9),heltab2x1(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(7),63,nMB,G2tensor(25),n2h1(37))
  call Hloop_QS_A(ntryL,G1H1(26),ex5(:),G1H1(19),ngH,m3h1x1(:,10),heltab2x1(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),16,nMB,G2tensor(26),n2h1(38))
  call Hloop_AS_Q(ntryL,G1H1(31),ex5(:),G1H1(37),ngH,m3h1x1(:,11),heltab2x1(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(37),63,nMB,G2tensor(27),n2h1(39))
  call Hloop_AS_Q(ntryL,G1H1(32),ex5(:),G1H1(20),ngH,m3h1x1(:,12),heltab2x1(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(20),16,nMB,G2tensor(28),n2h1(40))
  call Hloop_SA_Q(ntryL,G1H2(76),ex4(:),G1H1(8),ngX,m3h2x1(:,32),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(8),63,nMB,G2tensor(29),n2h1(41))
  call Hloop_SA_Q(ntryL,G1H2(77),ex4(:),G1H1(2),ngX,m3h2x1(:,33),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),8,nMB,G2tensor(30),n2h1(42))
  call ol_merge_tensors(G2tensor(21),[G2tensor(1)])
  call ol_merge_tensors(G2tensor(23),[G2tensor(3)])
  call ol_merge_tensors(G2tensor(29),[G2tensor(5)])
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(4),mass5set(:,3),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(4),mass5set(:,4),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(6),mass5set(:,3),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(1),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),8)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(2),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(2),mass5set(:,2),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(3),mass5set(:,3),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),16)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(3),mass5set(:,4),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),16)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(4),mass5set(:,3),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),16)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(4),mass5set(:,4),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),16)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(5),mass5set(:,3),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),16)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(6),mass5set(:,3),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),16)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  call ol_merge_tensors(T1sum(11),[G1tensor(61)])
  call ol_merge_tensors(T1sum(12),[G1tensor(67)])
  Gcoeff(:)%j = (-(c(50)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[32,3,16,4,8],[nMB,nMB,nMB,nMH,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(1),n2h16(19))
  Gcoeff(:)%j = (c(50)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[32,3,16,4,8],[nMB,nMB,nMB,nMZ,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(2),n2h16(20))
  Gcoeff(:)%j = (c(54)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[32,3,16,4,8],[nMT,nMT,nMT,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(3),n2h16(21))
  Gcoeff(:)%j = (c(102)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[32,3,16,4,8],[nMB,nMB,nMB,0,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(4),n2h16(22))
  Gcoeff(:)%j = (c(103)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[32,3,16,4,8],[nMB,nMB,nMB,nMZ,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(5),n2h16(23))
  Gcoeff(:)%j = (c(66)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[32,3,16,4,8],[nMT,nMT,nMT,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,24),heltab2x32(:,:,24))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(6),n2h16(24))
  Gcoeff(:)%j = (-(c(105)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[32,3,16,4,8],[nMB,nMB,nMB,0,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(7),n2h16(25))
  Gcoeff(:)%j = (-(c(50)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[32,3,8,4,16],[nMB,nMB,nMH,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(8),n2h16(26))
  Gcoeff(:)%j = (c(50)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[32,3,8,4,16],[nMB,nMB,nMZ,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,27),heltab2x32(:,:,27))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(9),n2h16(27))
  Gcoeff(:)%j = (c(54)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[32,3,8,4,16],[nMT,nMT,nMW,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,28),heltab2x32(:,:,28))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(10),n2h16(28))
  Gcoeff(:)%j = (c(102)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[32,3,8,4,16],[nMB,nMB,0,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,29),heltab2x32(:,:,29))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(11),n2h16(29))
  Gcoeff(:)%j = (c(103)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[32,3,8,4,16],[nMB,nMB,nMZ,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,30),heltab2x32(:,:,30))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(12),n2h16(30))
  Gcoeff(:)%j = (c(66)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[32,3,8,4,16],[nMT,nMT,nMW,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,31),heltab2x32(:,:,31))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(13),n2h16(31))
  Gcoeff(:)%j = (-(c(105)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[32,3,8,4,16],[nMB,nMB,0,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,32),heltab2x32(:,:,32))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(14),n2h16(32))
  Gcoeff(:)%j = (-(c(50)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(33),h0tab(:,33),[32,3,16,8,4],[nMB,nMB,nMB,nMH,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,33),heltab2x32(:,:,33))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(15),n2h16(33))
  Gcoeff(:)%j = (c(50)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(34),h0tab(:,34),[32,3,16,8,4],[nMB,nMB,nMB,nMZ,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,34),heltab2x32(:,:,34))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(16),n2h16(34))
  Gcoeff(:)%j = (c(54)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(35),h0tab(:,35),[32,3,16,8,4],[nMT,nMT,nMT,nMW,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,35),heltab2x32(:,:,35))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(17),n2h16(35))
  Gcoeff(:)%j = (c(102)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(36),h0tab(:,36),[32,3,16,8,4],[nMB,nMB,nMB,0,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,36),heltab2x32(:,:,36))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(18),n2h16(36))
  Gcoeff(:)%j = (c(103)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(37),h0tab(:,37),[32,3,16,8,4],[nMB,nMB,nMB,nMZ,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,37),heltab2x32(:,:,37))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(19),n2h16(37))
  Gcoeff(:)%j = (c(66)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(38),h0tab(:,38),[32,3,16,8,4],[nMT,nMT,nMT,nMW,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,38),heltab2x32(:,:,38))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(20),n2h16(38))
  Gcoeff(:)%j = (-(c(105)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(39),h0tab(:,39),[32,3,16,8,4],[nMB,nMB,nMB,0,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,39),heltab2x32(:,:,39))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(21),n2h16(39))
  Gcoeff(:)%j = (-(c(50)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(40),h0tab(:,40),[32,4,8,3,16],[nMB,nMH,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,40),heltab2x32(:,:,40))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(22),n2h16(40))
  Gcoeff(:)%j = (c(50)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(41),h0tab(:,41),[32,4,8,3,16],[nMB,nMZ,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,41),heltab2x32(:,:,41))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(23),n2h16(41))
  Gcoeff(:)%j = (c(54)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(42),h0tab(:,42),[32,4,8,3,16],[nMT,nMW,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,42),heltab2x32(:,:,42))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(24),n2h16(42))
  Gcoeff(:)%j = (c(102)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(43),h0tab(:,43),[32,4,8,3,16],[nMB,0,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,43),heltab2x32(:,:,43))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(25),n2h16(43))
  Gcoeff(:)%j = (c(103)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(44),h0tab(:,44),[32,4,8,3,16],[nMB,nMZ,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,44),heltab2x32(:,:,44))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(26),n2h16(44))
  Gcoeff(:)%j = (c(66)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(45),h0tab(:,45),[32,4,8,3,16],[nMT,nMW,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,45),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(27),n2h16(45))
  Gcoeff(:)%j = (-(c(105)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(46),h0tab(:,46),[32,4,8,3,16],[nMB,0,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,46),heltab2x32(:,:,46))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(28),n2h16(46))
  Gcoeff(:)%j = (-(c(50)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(47),h0tab(:,47),[32,3,4,8,16],[nMB,nMB,nMH,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,47),heltab2x32(:,:,47))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(29),n2h16(47))
  Gcoeff(:)%j = (c(50)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(48),h0tab(:,48),[32,3,4,8,16],[nMB,nMB,nMZ,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,48),heltab2x32(:,:,48))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(30),n2h16(48))
  Gcoeff(:)%j = (c(54)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(49),h0tab(:,49),[32,3,4,8,16],[nMT,nMT,nMW,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,49),heltab2x32(:,:,49))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(31),n2h16(49))
  Gcoeff(:)%j = (c(102)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(50),h0tab(:,50),[32,3,4,8,16],[nMB,nMB,0,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,50),heltab2x32(:,:,50))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(32),n2h16(50))
  Gcoeff(:)%j = (c(103)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(51),h0tab(:,51),[32,3,4,8,16],[nMB,nMB,nMZ,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,51),heltab2x32(:,:,51))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(33),n2h16(51))
  Gcoeff(:)%j = (c(66)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(52),h0tab(:,52),[32,3,4,8,16],[nMT,nMT,nMW,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,52),heltab2x32(:,:,52))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(34),n2h16(52))
  Gcoeff(:)%j = (-(c(105)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(53),h0tab(:,53),[32,3,4,8,16],[nMB,nMB,0,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,53),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(35),n2h16(53))
  Gcoeff(:)%j = (-(c(50)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(54),h0tab(:,54),[32,8,4,3,16],[nMB,nMH,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,54),heltab2x32(:,:,54))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(36),n2h16(54))
  Gcoeff(:)%j = (c(50)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(55),h0tab(:,55),[32,8,4,3,16],[nMB,nMZ,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,55),heltab2x32(:,:,55))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(37),n2h16(55))
  Gcoeff(:)%j = (c(54)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(56),h0tab(:,56),[32,8,4,3,16],[nMT,nMW,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,56),heltab2x32(:,:,56))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(38),n2h16(56))
  Gcoeff(:)%j = (c(102)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(57),h0tab(:,57),[32,8,4,3,16],[nMB,0,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,57),heltab2x32(:,:,57))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(39),n2h16(57))
  Gcoeff(:)%j = (c(103)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(58),h0tab(:,58),[32,8,4,3,16],[nMB,nMZ,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,58),heltab2x32(:,:,58))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(40),n2h16(58))
  Gcoeff(:)%j = (c(66)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(59),h0tab(:,59),[32,8,4,3,16],[nMT,nMW,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,59),heltab2x32(:,:,59))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(41),n2h16(59))
  Gcoeff(:)%j = (-(c(105)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(60),h0tab(:,60),[32,8,4,3,16],[nMB,0,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,60),heltab2x32(:,:,60))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(42),n2h16(60))
  Gcoeff(:)%j = (-(c(53)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(61),h0tab(:,61),[32,3,8,16,4],[nMB,nMB,nMH,nMH,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,61),heltab2x32(:,:,61))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(43),n2h16(61))
  Gcoeff(:)%j = (c(52)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(62),h0tab(:,62),[32,3,8,16,4],[nMB,nMB,nMZ,nMZ,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,62),heltab2x32(:,:,62))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(44),n2h16(62))
  Gcoeff(:)%j = (c(51)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(63),h0tab(:,63),[32,3,8,16,4],[nMT,nMT,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,63),heltab2x32(:,:,63))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(45),n2h16(63))
  Gcoeff(:)%j = (-(c(83)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(64),h0tab(:,64),[32,3,8,16,4],[nMB,nMB,nMZ,nMZ,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,64),heltab2x32(:,:,64))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(46),n2h16(64))
  Gcoeff(:)%j = (c(55)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(65),h0tab(:,65),[32,3,8,16,4],[nMT,nMT,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,65),heltab2x32(:,:,65))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(47),n2h16(65))
  Gcoeff(:)%j = (-(c(83)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(66),h0tab(:,66),[32,3,8,16,4],[nMB,nMB,nMZ,nMZ,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,66),heltab2x32(:,:,66))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(48),n2h16(66))
  Gcoeff(:)%j = (c(55)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(67),h0tab(:,67),[32,3,8,16,4],[nMT,nMT,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,67),heltab2x32(:,:,67))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(49),n2h16(67))
  Gcoeff(:)%j = (c(110)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(68),h0tab(:,68),[32,3,8,16,4],[nMB,nMB,nMZ,nMZ,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,68),heltab2x32(:,:,68))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(50),n2h16(68))
  Gcoeff(:)%j = (c(70)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(69),h0tab(:,69),[32,3,8,16,4],[nMT,nMT,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,69),heltab2x32(:,:,69))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(51),n2h16(69))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(70),h0tab(:,70),[32,4,16,3,8],[nMB,nMH,nMH,nMZ,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,70),heltab2x32(:,:,70))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(52),n2h16(70))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(71),h0tab(:,71),[32,4,16,3,8],[nMB,nMZ,nMZ,nMH,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,71),heltab2x32(:,:,71))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(53),n2h16(71))
  Gcoeff(:)%j = (-(c(120)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(72),h0tab(:,72),[32,4,16,3,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,72),heltab2x32(:,:,72))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(54),n2h16(72))
  Gcoeff(:)%j = (c(31)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(73),h0tab(:,73),[32,4,16,3,8],[nMB,nMZ,nMZ,nMH,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,73),heltab2x32(:,:,73))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(55),n2h16(73))
  Gcoeff(:)%j = (c(80)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(74),h0tab(:,74),[32,4,16,3,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,74),heltab2x32(:,:,74))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(56),n2h16(74))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(75),h0tab(:,75),[32,4,16,3,8],[nMB,nMH,nMH,nMZ,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,75),heltab2x32(:,:,75))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(57),n2h16(75))
  Gcoeff(:)%j = (-(c(89)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(76),h0tab(:,76),[32,4,16,3,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,76),heltab2x32(:,:,76))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(58),n2h16(76))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(77),h0tab(:,77),[32,4,16,3,8],[nMB,nMZ,nMZ,nMH,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,77),heltab2x32(:,:,77))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(59),n2h16(77))
  Gcoeff(:)%j = (-(c(127)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(78),h0tab(:,78),[32,4,16,3,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,78),heltab2x32(:,:,78))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(60),n2h16(78))
  Gcoeff(:)%j = (-(c(104)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(79),h0tab(:,79),[32,4,16,3,8],[0,nMB,nMB,nMB,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(61),m3h2x16(:,79),heltab2x32(:,:,79))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(80),h0tab(:,80),[32,4,16,3,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,80),heltab2x32(:,:,80))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(62),n2h16(79))
  Gcoeff(:)%j = (-(c(77)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(81),h0tab(:,81),[32,4,16,3,8],[nMB,nMZ,nMZ,nMH,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,81),heltab2x32(:,:,81))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(63),n2h16(80))
  Gcoeff(:)%j = (c(97)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(82),h0tab(:,82),[32,4,16,3,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,82),heltab2x32(:,:,82))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(64),n2h16(81))
  Gcoeff(:)%j = (-(c(95)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(83),h0tab(:,83),[32,4,16,3,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,83),heltab2x32(:,:,83))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(65),n2h16(82))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(84),h0tab(:,84),[32,4,16,3,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,84),heltab2x32(:,:,84))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(66),n2h16(83))
  Gcoeff(:)%j = (-(c(53)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(85),h0tab(:,85),[32,3,4,16,8],[nMB,nMB,nMH,nMH,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,85),heltab2x32(:,:,85))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(67),n2h16(84))
  Gcoeff(:)%j = (c(52)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(86),h0tab(:,86),[32,3,4,16,8],[nMB,nMB,nMZ,nMZ,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,86),heltab2x32(:,:,86))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(68),n2h16(85))
  Gcoeff(:)%j = (c(51)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(87),h0tab(:,87),[32,3,4,16,8],[nMT,nMT,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,87),heltab2x32(:,:,87))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(69),n2h16(86))
  Gcoeff(:)%j = (-(c(83)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(88),h0tab(:,88),[32,3,4,16,8],[nMB,nMB,nMZ,nMZ,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,88),heltab2x32(:,:,88))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(70),n2h16(87))
  Gcoeff(:)%j = (c(55)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(89),h0tab(:,89),[32,3,4,16,8],[nMT,nMT,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,89),heltab2x32(:,:,89))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(71),n2h16(88))
  Gcoeff(:)%j = (-(c(83)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(90),h0tab(:,90),[32,3,4,16,8],[nMB,nMB,nMZ,nMZ,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,90),heltab2x32(:,:,90))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(72),n2h16(89))
  Gcoeff(:)%j = (c(55)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(91),h0tab(:,91),[32,3,4,16,8],[nMT,nMT,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,91),heltab2x32(:,:,91))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(73),n2h16(90))
  Gcoeff(:)%j = (c(110)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(92),h0tab(:,92),[32,3,4,16,8],[nMB,nMB,nMZ,nMZ,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,92),heltab2x32(:,:,92))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(74),n2h16(91))
  Gcoeff(:)%j = (c(70)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(93),h0tab(:,93),[32,3,4,16,8],[nMT,nMT,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,93),heltab2x32(:,:,93))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(75),n2h16(92))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(94),h0tab(:,94),[32,8,3,4,16],[nMB,nMZ,nMH,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,94),heltab2x32(:,:,94))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(76),n2h16(93))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(95),h0tab(:,95),[32,8,3,4,16],[nMB,nMH,nMZ,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,95),heltab2x32(:,:,95))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(77),n2h16(94))
  Gcoeff(:)%j = (-(c(125)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(96),h0tab(:,96),[32,8,3,4,16],[nMT,nMW,nMW,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,96),heltab2x32(:,:,96))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(78),n2h16(95))
  Gcoeff(:)%j = (-(c(62)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(97),h0tab(:,97),[32,8,3,4,16],[nMB,nMZ,nMH,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,97),heltab2x32(:,:,97))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(79),n2h16(96))
  Gcoeff(:)%j = (-(c(92)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(98),h0tab(:,98),[32,8,3,4,16],[nMT,nMW,nMW,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,98),heltab2x32(:,:,98))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(80),n2h16(97))
  Gcoeff(:)%j = (-(c(62)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(99),h0tab(:,99),[32,8,3,4,16],[nMB,nMH,nMZ,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,99),heltab2x32(:,:,99))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(81),n2h16(98))
  Gcoeff(:)%j = (c(92)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(100),h0tab(:,100),[32,8,3,4,16],[nMT,nMW,nMW,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,100),heltab2x32(:,:,100))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(82),n2h16(99))
  Gcoeff(:)%j = (c(40)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(101),h0tab(:,101),[32,8,3,4,16],[nMT,nMW,nMW,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,101),heltab2x32(:,:,101))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(83),n2h16(100))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(102),h0tab(:,102),[32,4,3,16,8],[nMB,nMZ,nMH,nMH,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,102),heltab2x32(:,:,102))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(84),n2h16(101))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(103),h0tab(:,103),[32,4,3,16,8],[nMB,nMH,nMZ,nMZ,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,103),heltab2x32(:,:,103))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(85),n2h16(102))
  Gcoeff(:)%j = (-(c(120)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(104),h0tab(:,104),[32,4,3,16,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,104),heltab2x32(:,:,104))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(86),n2h16(103))
  Gcoeff(:)%j = (c(31)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(105),h0tab(:,105),[32,4,3,16,8],[nMB,nMH,nMZ,nMZ,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,105),heltab2x32(:,:,105))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(87),n2h16(104))
  Gcoeff(:)%j = (-(c(80)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(106),h0tab(:,106),[32,4,3,16,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,106),heltab2x32(:,:,106))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(88),n2h16(105))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(107),h0tab(:,107),[32,4,3,16,8],[nMB,nMH,nMZ,nMZ,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,107),heltab2x32(:,:,107))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(89),n2h16(106))
  Gcoeff(:)%j = (-(c(127)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(108),h0tab(:,108),[32,4,3,16,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,108),heltab2x32(:,:,108))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(90),n2h16(107))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(109),h0tab(:,109),[32,4,3,16,8],[nMB,nMZ,nMH,nMH,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,109),heltab2x32(:,:,109))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(91),n2h16(108))
  Gcoeff(:)%j = (c(89)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(110),h0tab(:,110),[32,4,3,16,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,110),heltab2x32(:,:,110))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(92),n2h16(109))
  Gcoeff(:)%j = (-(c(104)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(111),h0tab(:,111),[32,4,3,16,8],[0,nMB,nMB,nMB,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(93),m3h2x16(:,111),heltab2x32(:,:,111))
  Gcoeff(:)%j = (-(c(77)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(112),h0tab(:,112),[32,4,3,16,8],[nMB,nMH,nMZ,nMZ,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,112),heltab2x32(:,:,112))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(94),n2h16(110))
  Gcoeff(:)%j = (-(c(97)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(113),h0tab(:,113),[32,4,3,16,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,113),heltab2x32(:,:,113))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(95),n2h16(111))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(114),h0tab(:,114),[32,4,3,16,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,114),heltab2x32(:,:,114))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(96),n2h16(112))
  Gcoeff(:)%j = (c(95)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(115),h0tab(:,115),[32,4,3,16,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,115),heltab2x32(:,:,115))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(97),n2h16(113))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(116),h0tab(:,116),[32,4,3,16,8],[nMT,nMW,nMW,nMW,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,116),heltab2x32(:,:,116))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(98),n2h16(114))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(117),h0tab(:,117),[32,4,3,8,16],[nMB,nMH,nMZ,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,117),heltab2x32(:,:,117))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(99),n2h16(115))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(118),h0tab(:,118),[32,4,3,8,16],[nMB,nMZ,nMH,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,118),heltab2x32(:,:,118))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(100),n2h16(116))
  Gcoeff(:)%j = (-(c(125)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(119),h0tab(:,119),[32,4,3,8,16],[nMT,nMW,nMW,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,119),heltab2x32(:,:,119))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(101),n2h16(117))
  Gcoeff(:)%j = (-(c(62)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(120),h0tab(:,120),[32,4,3,8,16],[nMB,nMH,nMZ,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,120),heltab2x32(:,:,120))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(102),n2h16(118))
  Gcoeff(:)%j = (-(c(92)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(121),h0tab(:,121),[32,4,3,8,16],[nMT,nMW,nMW,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,121),heltab2x32(:,:,121))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(103),n2h16(119))
  Gcoeff(:)%j = (-(c(62)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(122),h0tab(:,122),[32,4,3,8,16],[nMB,nMZ,nMH,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,122),heltab2x32(:,:,122))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(104),n2h16(120))
  Gcoeff(:)%j = (c(92)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(123),h0tab(:,123),[32,4,3,8,16],[nMT,nMW,nMW,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,123),heltab2x32(:,:,123))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(105),n2h16(121))
  Gcoeff(:)%j = (c(40)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(124),h0tab(:,124),[32,4,3,8,16],[nMT,nMW,nMW,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,124),heltab2x32(:,:,124))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(106),n2h16(122))
  Gcoeff(:)%j = (c(103)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(125),h0tab(:,125),[32,8,1,2,20],[nMB,nMZ,0,nMZ,nMB],5,1,wf2(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,125),heltab2x32(:,:,125))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(107),n2h16(123))
  Gcoeff(:)%j = (c(103)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(126),h0tab(:,126),[32,8,2,1,20],[nMB,nMZ,0,nMZ,nMB],5,1,wf2(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,126),heltab2x32(:,:,126))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(108),n2h16(124))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(127),h0tab(:,127),[32,8,2,1,20],[nMT,nMW,0,nMW,nMT],5,1,wf2(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,127),heltab2x32(:,:,127))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(109),n2h16(125))
  Gcoeff(:)%j = (c(103)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(128),h0tab(:,128),[32,4,1,2,24],[nMB,nMZ,0,nMZ,nMB],5,1,wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,128),heltab2x32(:,:,128))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(110),n2h16(126))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(129),h0tab(:,129),[32,4,1,2,24],[nMT,nMW,0,nMW,nMT],5,1,wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,129),heltab2x32(:,:,129))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(111),n2h16(127))
  Gcoeff(:)%j = (c(103)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(130),h0tab(:,130),[32,4,2,1,24],[nMB,nMZ,0,nMZ,nMB],5,1,wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,130),heltab2x32(:,:,130))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(112),n2h16(128))
  Gcoeff(:)%j = (-(c(83)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(131),h0tab(:,131),[36,8,1,2,16],[nMB,nMZ,0,nMZ,nMZ],5,1,wf4(:,6))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,6),G0H8(1),ngX,m3h4x8(:,1),heltab2x32(:,:,131))
  call Hloop_Q_A(ntryL,G0H8(1),36,nMB,G1H8(4),n2h8(4))
  Gcoeff(:)%j = (c(110)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(132),h0tab(:,132),[36,8,1,2,16],[nMB,nMZ,0,nMZ,nMZ],5,1,wf4(:,6))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,6),G0H8(1),ngZd,m3h4x8(:,2),heltab2x32(:,:,132))
  call Hloop_Q_A(ntryL,G0H8(1),36,nMB,G1H8(5),n2h8(5))
  Gcoeff(:)%j = (c(103)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(133),h0tab(:,133),[36,2,1,8,16],[nMZ,0,nMZ,nMB,nMB],5,1,wf4(:,6))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,6),G0H8(1),ngZd,m3h4x8(:,3),heltab2x32(:,:,133))
  Gcoeff(:)%j = (-(c(83)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(134),h0tab(:,134),[36,8,2,1,16],[nMB,nMZ,0,nMZ,nMZ],5,1,wf4(:,6))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,6),G0H8(2),ngX,m3h4x8(:,4),heltab2x32(:,:,134))
  call Hloop_Q_A(ntryL,G0H8(2),36,nMB,G1H8(8),n2h8(6))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(135),h0tab(:,135),[36,8,2,1,16],[nMT,nMW,0,nMW,nMW],5,1,wf4(:,6))
  call Hloop_SQ_A(ntryL,G0H32(1),wf4(:,6),G0H8(2),ngPtb,m3h4x8(:,5),heltab2x32(:,:,135))
  call Hloop_Q_A(ntryL,G0H8(2),36,nMT,G1H8(9),n2h8(7))
  Gcoeff(:)%j = (c(110)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(136),h0tab(:,136),[36,8,2,1,16],[nMB,nMZ,0,nMZ,nMZ],5,1,wf4(:,6))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,6),G0H8(2),ngZd,m3h4x8(:,6),heltab2x32(:,:,136))
  call Hloop_Q_A(ntryL,G0H8(2),36,nMB,G1H8(10),n2h8(8))
  Gcoeff(:)%j = (c(13)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(137),h0tab(:,137),[36,8,2,1,16],[nMT,nMW,0,nMW,nMW],5,1,wf4(:,6))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,6),G0H8(2),m3h4x8(:,7),heltab2x32(:,:,137))
  call Hloop_Q_A(ntryL,G0H8(2),36,nMT,G1H8(11),n2h8(9))
  Gcoeff(:)%j = (-(c(83)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(138),h0tab(:,138),[36,2,1,16,8],[nMZ,0,nMZ,nMZ,nMB],5,1,wf4(:,6))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,6),G0H8(2),ngZd,m3h4x8(:,8),heltab2x32(:,:,138))
  Gcoeff(:)%j = (c(110)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(139),h0tab(:,139),[36,2,1,16,8],[nMZ,0,nMZ,nMZ,nMB],5,1,wf4(:,6))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,6),G0H8(3),ngZd,m3h4x8(:,9),heltab2x32(:,:,139))
  Gcoeff(:)%j = (c(103)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(140),h0tab(:,140),[36,1,2,8,16],[nMZ,0,nMZ,nMB,nMB],5,1,wf4(:,6))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,6),G0H8(4),ngZd,m3h4x8(:,10),heltab2x32(:,:,140))
  Gcoeff(:)%j = (c(12)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(141),h0tab(:,141),[36,1,2,8,16],[nMW,0,nMW,nMT,nMT],5,1,wf4(:,6))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,6),G0H8(5),m3h4x8(:,11),heltab2x32(:,:,141))
  Gcoeff(:)%j = (-(c(83)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(142),h0tab(:,142),[36,1,2,16,8],[nMZ,0,nMZ,nMZ,nMB],5,1,wf4(:,6))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,6),G0H8(6),ngZd,m3h4x8(:,12),heltab2x32(:,:,142))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(143),h0tab(:,143),[36,1,2,16,8],[nMW,0,nMW,nMW,nMT],5,1,wf4(:,6))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,6),G0H8(7),m3h4x8(:,13),heltab2x32(:,:,143))
  Gcoeff(:)%j = (c(110)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(144),h0tab(:,144),[36,1,2,16,8],[nMZ,0,nMZ,nMZ,nMB],5,1,wf4(:,6))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,6),G0H8(8),ngZd,m3h4x8(:,14),heltab2x32(:,:,144))
  Gcoeff(:)%j = (c(13)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(145),h0tab(:,145),[36,1,2,16,8],[nMW,0,nMW,nMW,nMT],5,1,wf4(:,6))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,6),G0H8(9),m3h4x8(:,15),heltab2x32(:,:,145))
  Gcoeff(:)%j = (-(c(83)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(146),h0tab(:,146),[40,4,1,2,16],[nMB,nMZ,0,nMZ,nMZ],5,1,wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(10),ngX,m3h4x8(:,16),heltab2x32(:,:,146))
  call Hloop_A_Q(ntryL,G0H8(10),40,nMB,G1H8(14),n2h8(10))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(147),h0tab(:,147),[40,4,1,2,16],[nMT,nMW,0,nMW,nMW],5,1,wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(10),ngPbt,m3h4x8(:,17),heltab2x32(:,:,147))
  call Hloop_A_Q(ntryL,G0H8(10),40,nMT,G1H8(15),n2h8(11))
  Gcoeff(:)%j = (c(110)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(148),h0tab(:,148),[40,4,1,2,16],[nMB,nMZ,0,nMZ,nMZ],5,1,wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(10),ngZd,m3h4x8(:,18),heltab2x32(:,:,148))
  call Hloop_A_Q(ntryL,G0H8(10),40,nMB,G1H8(16),n2h8(12))
  Gcoeff(:)%j = (c(13)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(149),h0tab(:,149),[40,4,1,2,16],[nMT,nMW,0,nMW,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(10),m3h4x8(:,19),heltab2x32(:,:,149))
  call Hloop_A_Q(ntryL,G0H8(10),40,nMT,G1H8(17),n2h8(13))
  Gcoeff(:)%j = (c(103)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(150),h0tab(:,150),[40,2,1,4,16],[nMZ,0,nMZ,nMB,nMB],5,1,wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,3),G0H8(10),ngZd,m3h4x8(:,20),heltab2x32(:,:,150))
  Gcoeff(:)%j = (c(12)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(151),h0tab(:,151),[40,2,1,4,16],[nMW,0,nMW,nMT,nMT],5,1,wf4(:,3))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,3),G0H8(11),m3h4x8(:,21),heltab2x32(:,:,151))
  Gcoeff(:)%j = (-(c(83)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(152),h0tab(:,152),[40,4,2,1,16],[nMB,nMZ,0,nMZ,nMZ],5,1,wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(12),ngX,m3h4x8(:,22),heltab2x32(:,:,152))
  call Hloop_A_Q(ntryL,G0H8(12),40,nMB,G1H8(2),n2h8(14))
  Gcoeff(:)%j = (c(110)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(153),h0tab(:,153),[40,4,2,1,16],[nMB,nMZ,0,nMZ,nMZ],5,1,wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(12),ngZd,m3h4x8(:,23),heltab2x32(:,:,153))
  call Hloop_A_Q(ntryL,G0H8(12),40,nMB,G1H8(3),n2h8(15))
  Gcoeff(:)%j = (-(c(83)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(154),h0tab(:,154),[40,2,1,16,4],[nMZ,0,nMZ,nMZ,nMB],5,1,wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,3),G0H8(12),ngZd,m3h4x8(:,24),heltab2x32(:,:,154))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(155),h0tab(:,155),[40,2,1,16,4],[nMW,0,nMW,nMW,nMT],5,1,wf4(:,3))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,3),G0H8(13),m3h4x8(:,25),heltab2x32(:,:,155))
  Gcoeff(:)%j = (c(110)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(156),h0tab(:,156),[40,2,1,16,4],[nMZ,0,nMZ,nMZ,nMB],5,1,wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,3),G0H8(14),ngZd,m3h4x8(:,26),heltab2x32(:,:,156))
  Gcoeff(:)%j = (c(13)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(157),h0tab(:,157),[40,2,1,16,4],[nMW,0,nMW,nMW,nMT],5,1,wf4(:,3))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,3),G0H8(15),m3h4x8(:,27),heltab2x32(:,:,157))
  Gcoeff(:)%j = (c(103)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(158),h0tab(:,158),[40,1,2,4,16],[nMZ,0,nMZ,nMB,nMB],5,1,wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,3),G0H8(16),ngZd,m3h4x8(:,28),heltab2x32(:,:,158))
  Gcoeff(:)%j = (-(c(83)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(159),h0tab(:,159),[40,1,2,16,4],[nMZ,0,nMZ,nMZ,nMB],5,1,wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,3),G0H8(17),ngZd,m3h4x8(:,29),heltab2x32(:,:,159))
  Gcoeff(:)%j = (c(110)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(160),h0tab(:,160),[40,1,2,16,4],[nMZ,0,nMZ,nMZ,nMB],5,1,wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,3),G0H8(18),ngZd,m3h4x8(:,30),heltab2x32(:,:,160))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(7),[G1H16(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(14),[G1H16(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(21),[G1H16(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(28),[G1H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(35),[G1H16(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(42),[G1H16(39)])
  call Hloop_AZ_Q(ntryL,G1H16(1),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,1),heltab2x16(:,:,19))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMB,G2H4(1),n2h4(22))
  call Hloop_AZ_Q(ntryL,G1H16(2),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,2),heltab2x16(:,:,20))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMB,G2H4(4),n2h4(23))
  call Hloop_AZ_Q(ntryL,G1H16(3),wf4(:,1),G1H4(1),ngZu,m3h4x4(:,3),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMT,G2H4(5),n2h4(24))
  call Hloop_AZ_Q(ntryL,G1H16(7),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,4),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMB,G2H4(8),n2h4(25))
  call Hloop_AZ_Q(ntryL,G1H16(5),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,5),heltab2x16(:,:,23))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMB,G2H4(9),n2h4(26))
  call Hloop_AZ_Q(ntryL,G1H16(6),wf4(:,1),G1H4(1),ngZu,m3h4x4(:,6),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMT,G2H4(12),n2h4(27))
  call Hloop_QZ_A(ntryL,G1H16(8),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,7),heltab2x16(:,:,25))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMB,G2H4(13),n2h4(28))
  call Hloop_QZ_A(ntryL,G1H16(9),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,8),heltab2x16(:,:,26))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMB,G2H4(14),n2h4(29))
  call Hloop_QZ_A(ntryL,G1H16(10),wf4(:,1),G1H4(1),ngZu,m3h4x4(:,9),heltab2x16(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMT,G2H4(15),n2h4(30))
  call Hloop_QZ_A(ntryL,G1H16(14),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,10),heltab2x16(:,:,28))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMB,G2H4(16),n2h4(31))
  call Hloop_QZ_A(ntryL,G1H16(12),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,11),heltab2x16(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMB,G2H4(17),n2h4(32))
  call Hloop_QZ_A(ntryL,G1H16(13),wf4(:,1),G1H4(1),ngZu,m3h4x4(:,12),heltab2x16(:,:,30))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMT,G2H4(18),n2h4(33))
  call Hloop_QZ_A(ntryL,G1H16(15),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,13),heltab2x16(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMB,G2H4(19),n2h4(34))
  call Hloop_QZ_A(ntryL,G1H16(16),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,14),heltab2x16(:,:,32))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMB,G2H4(20),n2h4(35))
  call Hloop_QZ_A(ntryL,G1H16(17),wf4(:,1),G1H4(1),ngZu,m3h4x4(:,15),heltab2x16(:,:,33))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMT,G2H4(21),n2h4(36))
  call Hloop_QZ_A(ntryL,G1H16(21),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,16),heltab2x16(:,:,34))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMB,G2H4(22),n2h4(37))
  call Hloop_QZ_A(ntryL,G1H16(19),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,17),heltab2x16(:,:,35))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMB,G2H4(23),n2h4(38))
  call Hloop_QZ_A(ntryL,G1H16(20),wf4(:,1),G1H4(1),ngZu,m3h4x4(:,18),heltab2x16(:,:,36))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMT,G2H4(24),n2h4(39))
  call Hloop_AQ_S(ntryL,G1H16(22),ex3(:),G1H8(19),ngH,m3h2x8(:,19),heltab2x16(:,:,37))
  call Hloop_AQ_S(ntryL,G1H16(23),ex3(:),G1H8(20),ngX,m3h2x8(:,20),heltab2x16(:,:,38))
  call Hloop_AQ_S(ntryL,G1H16(24),ex3(:),G1H8(21),ngPtb,m3h2x8(:,21),heltab2x16(:,:,39))
  call Hloop_AQ_V(ntryL,G1H16(28),ex3(:),G1H8(22),m3h2x8(:,22),heltab2x16(:,:,40))
  call Hloop_AQ_Z(ntryL,G1H16(26),ex3(:),G1H8(23),ngZd,m3h2x8(:,23),heltab2x16(:,:,41))
  call Hloop_AQ_W(ntryL,G1H16(27),ex3(:),G1H8(24),m3h2x8(:,24),heltab2x16(:,:,42))
  call Hloop_AZ_Q(ntryL,G1H16(29),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,19),heltab2x16(:,:,43))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMB,G2H4(25),n2h4(40))
  call Hloop_AZ_Q(ntryL,G1H16(30),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,20),heltab2x16(:,:,44))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMB,G2H4(26),n2h4(41))
  call Hloop_AZ_Q(ntryL,G1H16(31),wf4(:,1),G1H4(1),ngZu,m3h4x4(:,21),heltab2x16(:,:,45))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMT,G2H4(27),n2h4(42))
  call Hloop_AZ_Q(ntryL,G1H16(35),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,22),heltab2x16(:,:,46))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMB,G2H4(28),n2h4(43))
  call Hloop_AZ_Q(ntryL,G1H16(33),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,23),heltab2x16(:,:,47))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMB,G2H4(29),n2h4(44))
  call Hloop_AZ_Q(ntryL,G1H16(34),wf4(:,1),G1H4(1),ngZu,m3h4x4(:,24),heltab2x16(:,:,48))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMT,G2H4(30),n2h4(45))
  call Hloop_QA_S(ntryL,G1H16(36),ex4(:),G1H8(25),ngH,m3h2x8(:,25),heltab2x16(:,:,49))
  call Hloop_QA_S(ntryL,G1H16(37),ex4(:),G1H8(26),ngX,m3h2x8(:,26),heltab2x16(:,:,50))
  call Hloop_QA_S(ntryL,G1H16(38),ex4(:),G1H8(27),ngPbt,m3h2x8(:,27),heltab2x16(:,:,51))
  call Hloop_QA_V(ntryL,G1H16(42),ex4(:),G1H8(28),m3h2x8(:,28),heltab2x16(:,:,52))
  call Hloop_QA_Z(ntryL,G1H16(40),ex4(:),G1H8(29),ngZd,m3h2x8(:,29),heltab2x16(:,:,53))
  call Hloop_QA_W(ntryL,G1H16(41),ex4(:),G1H8(30),m3h2x8(:,30),heltab2x16(:,:,54))
  call Hloop_QZ_A(ntryL,G1H16(43),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,25),heltab2x16(:,:,55))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMB,G2H4(31),n2h4(46))
  call Hloop_QZ_A(ntryL,G1H16(44),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,26),heltab2x16(:,:,56))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMB,G2H4(32),n2h4(47))
  call Hloop_QZ_A(ntryL,G1H16(45),wf4(:,1),G1H4(1),ngZu,m3h4x4(:,27),heltab2x16(:,:,57))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMT,G2H4(33),n2h4(48))
  call Hloop_QZ_A(ntryL,G1H16(46),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,28),heltab2x16(:,:,58))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMB,G2H4(34),n2h4(49))
  call Hloop_QZ_A(ntryL,G1H16(47),wf4(:,1),G1H4(1),ngZu,m3h4x4(:,29),heltab2x16(:,:,59))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMT,G2H4(35),n2h4(50))
  call Hloop_QZ_A(ntryL,G1H16(48),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,30),heltab2x16(:,:,60))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMB,G2H4(36),n2h4(51))
  call Hloop_QZ_A(ntryL,G1H16(49),wf4(:,1),G1H4(1),ngZu,m3h4x4(:,31),heltab2x16(:,:,61))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMT,G2H4(37),n2h4(52))
  call Hloop_QZ_A(ntryL,G1H16(50),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,32),heltab2x16(:,:,62))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMB,G2H4(38),n2h4(53))
  call Hloop_QZ_A(ntryL,G1H16(51),wf4(:,1),G1H4(1),ngZu,m3h4x4(:,33),heltab2x16(:,:,63))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMT,G2H4(39),n2h4(54))
  call Hloop_AQ_S(ntryL,G1H16(52),ex3(:),G1H8(31),ngH,m3h2x8(:,31),heltab2x16(:,:,64))
  call Hloop_AQ_S(ntryL,G1H16(53),ex3(:),G1H8(32),ngX,m3h2x8(:,32),heltab2x16(:,:,65))
  call Hloop_AQ_S(ntryL,G1H16(54),ex3(:),G1H8(33),ngPtb,m3h2x8(:,33),heltab2x16(:,:,66))
  call Hloop_AQ_S(ntryL,G1H16(55),ex3(:),G1H8(34),ngX,m3h2x8(:,34),heltab2x16(:,:,67))
  call Hloop_AQ_S(ntryL,G1H16(56),ex3(:),G1H8(35),ngPtb,m3h2x8(:,35),heltab2x16(:,:,68))
  call Hloop_AQ_S(ntryL,G1H16(57),ex3(:),G1H8(36),ngH,m3h2x8(:,36),heltab2x16(:,:,69))
  call Hloop_AQ_S(ntryL,G1H16(58),ex3(:),G1H8(37),ngPtb,m3h2x8(:,37),heltab2x16(:,:,70))
  call Hloop_AQ_Z(ntryL,G1H16(59),ex3(:),G1H8(38),ngZd,m3h2x8(:,38),heltab2x16(:,:,71))
  call Hloop_AQ_W(ntryL,G1H16(60),ex3(:),G1H8(39),m3h2x8(:,39),heltab2x16(:,:,72))
  call Hloop_VQ_A(ntryL,G1H16(61),ex3(:),G1H8(40),m3h2x8(:,40),heltab2x16(:,:,73))
  call Hloop_Q_A(ntryL,G1H8(40),36,nMB,G2H8(1),n2h8(16))
  call Hloop_AQ_S(ntryL,G1H16(62),ex3(:),G1H8(40),ngPtb,m3h2x8(:,41),heltab2x16(:,:,74))
  call Hloop_AQ_Z(ntryL,G1H16(63),ex3(:),G1H8(41),ngZd,m3h2x8(:,42),heltab2x16(:,:,75))
  call Hloop_AQ_W(ntryL,G1H16(64),ex3(:),G1H8(42),m3h2x8(:,43),heltab2x16(:,:,76))
  call Hloop_AQ_W(ntryL,G1H16(65),ex3(:),G1H8(43),m3h2x8(:,44),heltab2x16(:,:,77))
  call Hloop_AQ_W(ntryL,G1H16(66),ex3(:),G1H8(44),m3h2x8(:,45),heltab2x16(:,:,78))
  call Hloop_AZ_Q(ntryL,G1H16(67),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,34),heltab2x16(:,:,79))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMB,G2H4(40),n2h4(55))
  call Hloop_AZ_Q(ntryL,G1H16(68),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,35),heltab2x16(:,:,80))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMB,G2H4(41),n2h4(56))
  call Hloop_AZ_Q(ntryL,G1H16(69),wf4(:,1),G1H4(1),ngZu,m3h4x4(:,36),heltab2x16(:,:,81))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMT,G2H4(42),n2h4(57))
  call Hloop_AZ_Q(ntryL,G1H16(70),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,37),heltab2x16(:,:,82))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMB,G2H4(43),n2h4(58))
  call Hloop_AZ_Q(ntryL,G1H16(71),wf4(:,1),G1H4(1),ngZu,m3h4x4(:,38),heltab2x16(:,:,83))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMT,G2H4(44),n2h4(59))
  call Hloop_AZ_Q(ntryL,G1H16(72),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,39),heltab2x16(:,:,84))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMB,G2H4(45),n2h4(60))
  call Hloop_AZ_Q(ntryL,G1H16(73),wf4(:,1),G1H4(1),ngZu,m3h4x4(:,40),heltab2x16(:,:,85))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMT,G2H4(46),n2h4(61))
  call Hloop_AZ_Q(ntryL,G1H16(74),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,41),heltab2x16(:,:,86))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMB,G2H4(47),n2h4(62))
  call Hloop_AZ_Q(ntryL,G1H16(75),wf4(:,1),G1H4(1),ngZu,m3h4x4(:,42),heltab2x16(:,:,87))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMT,G2H4(48),n2h4(63))
  call Hloop_QA_S(ntryL,G1H16(76),ex4(:),G1H8(45),ngX,m3h2x8(:,46),heltab2x16(:,:,88))
  call Hloop_QA_S(ntryL,G1H16(77),ex4(:),G1H8(46),ngH,m3h2x8(:,47),heltab2x16(:,:,89))
  call Hloop_QA_S(ntryL,G1H16(78),ex4(:),G1H8(47),ngPbt,m3h2x8(:,48),heltab2x16(:,:,90))
  call Hloop_QA_Z(ntryL,G1H16(79),ex4(:),G1H8(48),ngZd,m3h2x8(:,49),heltab2x16(:,:,91))
  call Hloop_QA_W(ntryL,G1H16(80),ex4(:),G1H8(49),m3h2x8(:,50),heltab2x16(:,:,92))
  call Hloop_QA_S(ntryL,G1H16(81),ex4(:),G1H8(50),ngH,m3h2x8(:,51),heltab2x16(:,:,93))
  call Hloop_QA_S(ntryL,G1H16(82),ex4(:),G1H8(51),ngPbt,m3h2x8(:,52),heltab2x16(:,:,94))
  call Hloop_QA_W(ntryL,G1H16(83),ex4(:),G1H8(52),m3h2x8(:,53),heltab2x16(:,:,95))
  call Hloop_AQ_S(ntryL,G1H16(84),ex3(:),G1H8(53),ngX,m3h2x8(:,54),heltab2x16(:,:,96))
  call Hloop_AQ_S(ntryL,G1H16(85),ex3(:),G1H8(54),ngH,m3h2x8(:,55),heltab2x16(:,:,97))
  call Hloop_AQ_S(ntryL,G1H16(86),ex3(:),G1H8(55),ngPtb,m3h2x8(:,56),heltab2x16(:,:,98))
  call Hloop_AQ_S(ntryL,G1H16(87),ex3(:),G1H8(56),ngH,m3h2x8(:,57),heltab2x16(:,:,99))
  call Hloop_AQ_S(ntryL,G1H16(88),ex3(:),G1H8(57),ngPtb,m3h2x8(:,58),heltab2x16(:,:,100))
  call Hloop_AQ_S(ntryL,G1H16(89),ex3(:),G1H8(58),ngH,m3h2x8(:,59),heltab2x16(:,:,101))
  call Hloop_AQ_S(ntryL,G1H16(90),ex3(:),G1H8(59),ngPtb,m3h2x8(:,60),heltab2x16(:,:,102))
  call Hloop_AQ_Z(ntryL,G1H16(91),ex3(:),G1H8(60),ngZd,m3h2x8(:,61),heltab2x16(:,:,103))
  call Hloop_AQ_W(ntryL,G1H16(92),ex3(:),G1H8(61),m3h2x8(:,62),heltab2x16(:,:,104))
  call Hloop_VQ_A(ntryL,G1H16(93),ex3(:),G1H8(62),m3h2x8(:,63),heltab2x16(:,:,105))
  call Hloop_Q_A(ntryL,G1H8(62),36,nMB,G2H8(2),n2h8(17))
  call Hloop_AQ_S(ntryL,G1H16(94),ex3(:),G1H8(62),ngH,m3h2x8(:,64),heltab2x16(:,:,106))
  call Hloop_AQ_S(ntryL,G1H16(95),ex3(:),G1H8(63),ngPtb,m3h2x8(:,65),heltab2x16(:,:,107))
  call Hloop_AQ_W(ntryL,G1H16(96),ex3(:),G1H8(64),m3h2x8(:,66),heltab2x16(:,:,108))
  call Hloop_AQ_W(ntryL,G1H16(97),ex3(:),G1H8(65),m3h2x8(:,67),heltab2x16(:,:,109))
  call Hloop_AQ_W(ntryL,G1H16(98),ex3(:),G1H8(66),m3h2x8(:,68),heltab2x16(:,:,110))
  call Hloop_AQ_S(ntryL,G1H16(99),ex3(:),G1H8(67),ngH,m3h2x8(:,69),heltab2x16(:,:,111))
  call Hloop_AQ_S(ntryL,G1H16(100),ex3(:),G1H8(68),ngX,m3h2x8(:,70),heltab2x16(:,:,112))
  call Hloop_AQ_S(ntryL,G1H16(101),ex3(:),G1H8(69),ngPtb,m3h2x8(:,71),heltab2x16(:,:,113))
  call Hloop_AQ_S(ntryL,G1H16(102),ex3(:),G1H8(70),ngH,m3h2x8(:,72),heltab2x16(:,:,114))
  call Hloop_AQ_S(ntryL,G1H16(103),ex3(:),G1H8(71),ngPtb,m3h2x8(:,73),heltab2x16(:,:,115))
  call Hloop_AQ_Z(ntryL,G1H16(104),ex3(:),G1H8(72),ngZd,m3h2x8(:,74),heltab2x16(:,:,116))
  call Hloop_AQ_W(ntryL,G1H16(105),ex3(:),G1H8(73),m3h2x8(:,75),heltab2x16(:,:,117))
  call Hloop_AQ_W(ntryL,G1H16(106),ex3(:),G1H8(74),m3h2x8(:,76),heltab2x16(:,:,118))
  call Hloop_QA_Z(ntryL,G1H16(107),ex4(:),G1H8(75),ngZd,m3h2x8(:,77),heltab2x16(:,:,119))
  call Hloop_QA_Z(ntryL,G1H16(108),ex4(:),G1H8(76),ngZd,m3h2x8(:,78),heltab2x16(:,:,120))
  call Hloop_QA_W(ntryL,G1H16(109),ex4(:),G1H8(77),m3h2x8(:,79),heltab2x16(:,:,121))
  call Hloop_AQ_Z(ntryL,G1H16(110),ex3(:),G1H8(78),ngZd,m3h2x8(:,80),heltab2x16(:,:,122))
  call Hloop_AQ_W(ntryL,G1H16(111),ex3(:),G1H8(79),m3h2x8(:,81),heltab2x16(:,:,123))
  call Hloop_AQ_Z(ntryL,G1H16(112),ex3(:),G1H8(80),ngZd,m3h2x8(:,82),heltab2x16(:,:,124))
  call Hloop_QA_Z(ntryL,G1H8(4),ex4(:),G1H4(1),ngZd,m3h2x4(:,25),heltab2x8(:,:,31))
  call Hloop_QA_Z(ntryL,G1H8(5),ex4(:),G1H4(2),ngZd,m3h2x4(:,26),heltab2x8(:,:,32))
  call Hloop_ZA_Q(ntryL,G0H8(1),ex2(:),G0H4(1),ngZn,m3h2x4(:,27),heltab2x8(:,:,33))
  call Hloop_A_Q(ntryL,G0H4(1),38,0,G1H4(3),n2h4(64))
  call Hloop_QA_Z(ntryL,G1H8(8),ex4(:),G1H4(4),ngZd,m3h2x4(:,28),heltab2x8(:,:,34))
  call Hloop_QA_W(ntryL,G1H8(9),ex4(:),G1H4(5),m3h2x4(:,29),heltab2x8(:,:,35))
  call Hloop_QA_Z(ntryL,G1H8(10),ex4(:),G1H4(6),ngZd,m3h2x4(:,30),heltab2x8(:,:,36))
  call Hloop_QA_W(ntryL,G1H8(11),ex4(:),G1H4(7),m3h2x4(:,31),heltab2x8(:,:,37))
  call Hloop_ZA_Q(ntryL,G0H8(2),ex2(:),G0H4(1),ngZn,m3h2x4(:,32),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G0H4(1),38,0,G1H4(8),n2h4(65))
  call Hloop_ZA_Q(ntryL,G0H8(3),ex2(:),G0H4(1),ngZn,m3h2x4(:,33),heltab2x8(:,:,39))
  call Hloop_A_Q(ntryL,G0H4(1),38,0,G1H4(9),n2h4(66))
  call Hloop_ZQ_A(ntryL,G0H8(4),ex1(:),G0H4(1),ngZn,m3h2x4(:,34),heltab2x8(:,:,40))
  call Hloop_Q_A(ntryL,G0H4(1),37,0,G1H4(10),n2h4(67))
  call Hloop_WQ_A(ntryL,G0H8(5),ex1(:),G0H4(1),m3h2x4(:,35),heltab2x8(:,:,41))
  call Hloop_Q_A(ntryL,G0H4(1),37,0,G1H4(11),n2h4(68))
  call Hloop_ZQ_A(ntryL,G0H8(6),ex1(:),G0H4(1),ngZn,m3h2x4(:,36),heltab2x8(:,:,42))
  call Hloop_Q_A(ntryL,G0H4(1),37,0,G1H4(12),n2h4(69))
  call Hloop_WQ_A(ntryL,G0H8(7),ex1(:),G0H4(1),m3h2x4(:,37),heltab2x8(:,:,43))
  call Hloop_Q_A(ntryL,G0H4(1),37,0,G1H4(13),n2h4(70))
  call Hloop_ZQ_A(ntryL,G0H8(8),ex1(:),G0H4(1),ngZn,m3h2x4(:,38),heltab2x8(:,:,44))
  call Hloop_Q_A(ntryL,G0H4(1),37,0,G1H4(14),n2h4(71))
  call Hloop_WQ_A(ntryL,G0H8(9),ex1(:),G0H4(1),m3h2x4(:,39),heltab2x8(:,:,45))
  call Hloop_Q_A(ntryL,G0H4(1),37,0,G1H4(15),n2h4(72))
  call Hloop_AQ_Z(ntryL,G1H8(14),ex3(:),G1H4(16),ngZd,m3h2x4(:,40),heltab2x8(:,:,46))
  call Hloop_AQ_W(ntryL,G1H8(15),ex3(:),G1H4(17),m3h2x4(:,41),heltab2x8(:,:,47))
  call Hloop_AQ_Z(ntryL,G1H8(16),ex3(:),G1H4(18),ngZd,m3h2x4(:,42),heltab2x8(:,:,48))
  call Hloop_AQ_W(ntryL,G1H8(17),ex3(:),G1H4(19),m3h2x4(:,43),heltab2x8(:,:,49))
  call Hloop_ZA_Q(ntryL,G0H8(10),ex2(:),G0H4(1),ngZn,m3h2x4(:,44),heltab2x8(:,:,50))
  call Hloop_A_Q(ntryL,G0H4(1),42,0,G1H4(20),n2h4(73))
  call Hloop_WA_Q(ntryL,G0H8(11),ex2(:),G0H4(1),m3h2x4(:,45),heltab2x8(:,:,51))
  call Hloop_A_Q(ntryL,G0H4(1),42,0,G1H4(21),n2h4(74))
  call Hloop_AQ_Z(ntryL,G1H8(2),ex3(:),G1H4(22),ngZd,m3h2x4(:,46),heltab2x8(:,:,52))
  call Hloop_AQ_Z(ntryL,G1H8(3),ex3(:),G1H4(23),ngZd,m3h2x4(:,47),heltab2x8(:,:,53))
  call Hloop_ZA_Q(ntryL,G0H8(12),ex2(:),G0H4(1),ngZn,m3h2x4(:,48),heltab2x8(:,:,54))
  call Hloop_A_Q(ntryL,G0H4(1),42,0,G1H4(24),n2h4(75))
  call Hloop_WA_Q(ntryL,G0H8(13),ex2(:),G0H4(1),m3h2x4(:,49),heltab2x8(:,:,55))
  call Hloop_A_Q(ntryL,G0H4(1),42,0,G1H4(25),n2h4(76))
  call Hloop_ZA_Q(ntryL,G0H8(14),ex2(:),G0H4(1),ngZn,m3h2x4(:,50),heltab2x8(:,:,56))
  call Hloop_A_Q(ntryL,G0H4(1),42,0,G1H4(26),n2h4(77))
  call Hloop_WA_Q(ntryL,G0H8(15),ex2(:),G0H4(1),m3h2x4(:,51),heltab2x8(:,:,57))
  call Hloop_A_Q(ntryL,G0H4(1),42,0,G1H4(27),n2h4(78))
  call Hloop_ZQ_A(ntryL,G0H8(16),ex1(:),G0H4(1),ngZn,m3h2x4(:,52),heltab2x8(:,:,58))
  call Hloop_Q_A(ntryL,G0H4(1),41,0,G1H4(28),n2h4(79))
  call Hloop_ZQ_A(ntryL,G0H8(17),ex1(:),G0H4(1),ngZn,m3h2x4(:,53),heltab2x8(:,:,59))
  call Hloop_Q_A(ntryL,G0H4(1),41,0,G1H4(29),n2h4(80))
  call Hloop_ZQ_A(ntryL,G0H8(18),ex1(:),G0H4(1),ngZn,m3h2x4(:,54),heltab2x8(:,:,60))
  call Hloop_Q_A(ntryL,G0H4(1),41,0,G1H4(30),n2h4(81))
  call Hloop_ZA_Q(ntryL,G1H8(6),ex2(:),G1H4(31),ngZn,m3h2x4(:,55),heltab2x8(:,:,61))
  call Hloop_A_Q(ntryL,G1H4(31),54,0,G2H4(49),n2h4(82))
  call Hloop_ZA_Q(ntryL,G1H8(7),ex2(:),G1H4(31),ngZn,m3h2x4(:,56),heltab2x8(:,:,62))
  call Hloop_A_Q(ntryL,G1H4(31),54,0,G2H4(50),n2h4(83))
  call Hloop_ZQ_A(ntryL,G1H8(12),ex1(:),G1H4(31),ngZn,m3h2x4(:,57),heltab2x8(:,:,63))
  call Hloop_Q_A(ntryL,G1H4(31),53,0,G2H4(51),n2h4(84))
  call Hloop_ZQ_A(ntryL,G1H8(13),ex1(:),G1H4(31),ngZn,m3h2x4(:,58),heltab2x8(:,:,64))
  call Hloop_Q_A(ntryL,G1H4(31),53,0,G2H4(52),n2h4(85))
  call Hloop_WQ_A(ntryL,G1H8(18),ex1(:),G1H4(31),m3h2x4(:,59),heltab2x8(:,:,65))
  call Hloop_Q_A(ntryL,G1H4(31),53,0,G2H4(53),n2h4(86))
  call Hloop_WQ_A(ntryL,G1H8(1),ex1(:),G1H4(31),m3h2x4(:,60),heltab2x8(:,:,66))
  call Hloop_Q_A(ntryL,G1H4(31),53,0,G2H4(54),n2h4(87))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(7),mass5set(:,5),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
  call HG1shiftOLR(G1H4(32),8,4)
  call Hotf_5pt_reduction(G2H4(4),RedSet_5(7),mass5set(:,6),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
  call HG1shiftOLR(G1H4(38),8,4)
  call Hotf_5pt_reduction(G2H4(5),RedSet_5(7),mass5set(:,7),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
  call HG1shiftOLR(G1H4(44),8,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(7),mass5set(:,8),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
  call HG1shiftOLR(G1H4(50),8,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(7),mass5set(:,6),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
  call HG1shiftOLR(G1H4(56),8,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(7),mass5set(:,7),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
  call HG1shiftOLR(G1H4(62),8,4)
  call Hloop_QA_S(ntryL,G2H4(13),ex4(:),G2H2(1),ngH,m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_QA_S(ntryL,G2H4(14),ex4(:),G2H2(2),ngX,m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_QA_S(ntryL,G2H4(15),ex4(:),G2H2(3),ngPbt,m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_QA_V(ntryL,G2H4(16),ex4(:),G2H2(4),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_QA_Z(ntryL,G2H4(17),ex4(:),G2H2(6),ngZd,m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_QA_W(ntryL,G2H4(18),ex4(:),G2H2(8),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hotf_5pt_reduction(G2H4(19),RedSet_5(8),mass5set(:,5),  & 
G1H4(67),G1H4(68),G1H4(69),G1H4(70),G1H4(71),G1H4(72),4)
  call HG1shiftOLR(G1H4(68),4,4)
  call Hotf_5pt_reduction(G2H4(20),RedSet_5(8),mass5set(:,6),  & 
G1H4(73),G1H4(74),G1H4(75),G1H4(76),G1H4(77),G1H4(78),4)
  call HG1shiftOLR(G1H4(74),4,4)
  call Hotf_5pt_reduction(G2H4(21),RedSet_5(8),mass5set(:,7),  & 
G1H4(79),G1H4(80),G1H4(81),G1H4(82),G1H4(83),G1H4(84),4)
  call HG1shiftOLR(G1H4(80),4,4)
  call Hotf_5pt_reduction(G2H4(22),RedSet_5(8),mass5set(:,8),  & 
G1H4(85),G1H4(86),G1H4(87),G1H4(88),G1H4(89),G1H4(90),4)
  call HG1shiftOLR(G1H4(86),4,4)
  call Hotf_5pt_reduction(G2H4(23),RedSet_5(8),mass5set(:,6),  & 
G1H4(91),G1H4(92),G1H4(93),G1H4(94),G1H4(95),G1H4(96),4)
  call HG1shiftOLR(G1H4(92),4,4)
  call Hotf_5pt_reduction(G2H4(24),RedSet_5(8),mass5set(:,7),  & 
G1H4(97),G1H4(98),G1H4(99),G1H4(100),G1H4(101),G1H4(102),4)
  call HG1shiftOLR(G1H4(98),4,4)
  call Hloop_SA_Q(ntryL,G1H8(19),ex4(:),G1H4(103),ngH,m3h2x4(:,61),heltab2x8(:,:,67))
  call Hloop_A_Q(ntryL,G1H4(103),44,nMB,G2H4(1),n2h4(88))
  call Hloop_SA_Q(ntryL,G1H8(20),ex4(:),G1H4(103),ngX,m3h2x4(:,62),heltab2x8(:,:,68))
  call Hloop_A_Q(ntryL,G1H4(103),44,nMB,G2H4(4),n2h4(89))
  call Hloop_SA_Q(ntryL,G1H8(21),ex4(:),G1H4(103),ngPbt,m3h2x4(:,63),heltab2x8(:,:,69))
  call Hloop_A_Q(ntryL,G1H4(103),44,nMT,G2H4(5),n2h4(90))
  call Hloop_VA_Q(ntryL,G1H8(22),ex4(:),G1H4(103),m3h2x4(:,64),heltab2x8(:,:,70))
  call Hloop_A_Q(ntryL,G1H4(103),44,nMB,G2H4(8),n2h4(91))
  call Hloop_ZA_Q(ntryL,G1H8(23),ex4(:),G1H4(103),ngZd,m3h2x4(:,65),heltab2x8(:,:,71))
  call Hloop_A_Q(ntryL,G1H4(103),44,nMB,G2H4(9),n2h4(92))
  call Hloop_WA_Q(ntryL,G1H8(24),ex4(:),G1H4(103),m3h2x4(:,66),heltab2x8(:,:,72))
  call Hloop_A_Q(ntryL,G1H4(103),44,nMT,G2H4(12),n2h4(93))
  call Hloop_AQ_S(ntryL,G2H4(25),ex3(:),G2H2(12),ngH,m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_AQ_S(ntryL,G2H4(26),ex3(:),G2H2(16),ngX,m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_AQ_S(ntryL,G2H4(27),ex3(:),G2H2(18),ngPtb,m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_AQ_V(ntryL,G2H4(28),ex3(:),G2H2(22),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_AQ_Z(ntryL,G2H4(29),ex3(:),G2H2(23),ngZd,m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_AQ_W(ntryL,G2H4(30),ex3(:),G2H2(24),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_SQ_A(ntryL,G1H8(25),ex3(:),G1H4(103),ngH,m3h2x4(:,67),heltab2x8(:,:,73))
  call Hloop_Q_A(ntryL,G1H4(103),44,nMB,G2H4(13),n2h4(94))
  call Hloop_SQ_A(ntryL,G1H8(26),ex3(:),G1H4(103),ngX,m3h2x4(:,68),heltab2x8(:,:,74))
  call Hloop_Q_A(ntryL,G1H4(103),44,nMB,G2H4(14),n2h4(95))
  call Hloop_SQ_A(ntryL,G1H8(27),ex3(:),G1H4(103),ngPtb,m3h2x4(:,69),heltab2x8(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(103),44,nMT,G2H4(15),n2h4(96))
  call Hloop_VQ_A(ntryL,G1H8(28),ex3(:),G1H4(103),m3h2x4(:,70),heltab2x8(:,:,76))
  call Hloop_Q_A(ntryL,G1H4(103),44,nMB,G2H4(16),n2h4(97))
  call Hloop_ZQ_A(ntryL,G1H8(29),ex3(:),G1H4(103),ngZd,m3h2x4(:,71),heltab2x8(:,:,77))
  call Hloop_Q_A(ntryL,G1H4(103),44,nMB,G2H4(17),n2h4(98))
  call Hloop_WQ_A(ntryL,G1H8(30),ex3(:),G1H4(103),m3h2x4(:,72),heltab2x8(:,:,78))
  call Hloop_Q_A(ntryL,G1H4(103),44,nMT,G2H4(18),n2h4(99))
  call Hloop_QA_S(ntryL,G2H4(31),ex4(:),G2H2(25),ngH,m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_QA_S(ntryL,G2H4(32),ex4(:),G2H2(26),ngX,m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_QA_S(ntryL,G2H4(33),ex4(:),G2H2(27),ngPbt,m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_QA_Z(ntryL,G2H4(34),ex4(:),G2H2(28),ngZd,m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_QA_W(ntryL,G2H4(35),ex4(:),G2H2(29),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_QA_S(ntryL,G2H4(36),ex4(:),G2H2(30),ngX,m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_QA_S(ntryL,G2H4(37),ex4(:),G2H2(31),ngPbt,m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_QA_Z(ntryL,G2H4(38),ex4(:),G2H2(32),ngZd,m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_QA_W(ntryL,G2H4(39),ex4(:),G2H2(33),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_SS_S(ntryL,G1H8(31),ex5(:),G1H8(4),m3h1x8(:,7),heltab2x8(:,:,79))
  call Hloop_SS_S(ntryL,G1H8(32),ex5(:),G1H8(5),m3h1x8(:,8),heltab2x8(:,:,80))
  call Hloop_SS_S(ntryL,G1H8(33),ex5(:),G1H8(8),m3h1x8(:,9),heltab2x8(:,:,81))
  call Hloop_ST_V(ntryL,G1H8(34),36,ex5(:),16,G2H8(3),m3h1x8(:,10),heltab2x8(:,:,82))
  call Hloop_ST_V(ntryL,G1H8(35),36,ex5(:),16,G2H8(4),m3h1x8(:,11),heltab2x8(:,:,83))
  call Hloop_SS_S(ntryL,G1H8(36),ex5(:),G1H8(9),m3h1x8(:,12),heltab2x8(:,:,84))
  call Hloop_SS_S(ntryL,G1H8(37),ex5(:),G1H8(10),m3h1x8(:,13),heltab2x8(:,:,85))
  call Hloop_VT_S(ntryL,G1H8(38),36,ex5(:),16,G2H8(5),m3h1x8(:,14),heltab2x8(:,:,86))
  call Hloop_VT_S(ntryL,G1H8(39),36,ex5(:),16,G2H8(6),m3h1x8(:,15),heltab2x8(:,:,87))
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(9),mass5set(:,9),  & 
G1H8(11),G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(2),8)
  call HG1shiftOLR(G1H8(14),8,8)
  call Hloop_ST_V(ntryL,G1H8(40),36,ex5(:),16,G2H8(1),m3h1x8(:,16),heltab2x8(:,:,88))
  call Hloop_VS_V(ntryL,G1H8(41),ex5(:),G1H8(3),m3h1x8(:,17),heltab2x8(:,:,89))
  call Hloop_VS_V(ntryL,G1H8(42),ex5(:),G1H8(6),m3h1x8(:,18),heltab2x8(:,:,90))
  call Hloop_VT_S(ntryL,G1H8(43),36,ex5(:),16,G2H8(7),m3h1x8(:,19),heltab2x8(:,:,91))
  call Hloop_VS_V(ntryL,G1H8(44),ex5(:),G1H8(7),m3h1x8(:,20),heltab2x8(:,:,92))
  call Hloop_AQ_S(ntryL,G2H4(40),ex3(:),G2H2(34),ngH,m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_AQ_S(ntryL,G2H4(41),ex3(:),G2H2(35),ngX,m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_AQ_S(ntryL,G2H4(42),ex3(:),G2H2(36),ngPtb,m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_AQ_S(ntryL,G2H4(43),ex3(:),G2H2(37),ngX,m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_AQ_S(ntryL,G2H4(44),ex3(:),G2H2(38),ngPtb,m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_AQ_Z(ntryL,G2H4(45),ex3(:),G2H2(39),ngZd,m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_AQ_W(ntryL,G2H4(46),ex3(:),G2H2(40),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_AQ_Z(ntryL,G2H4(47),ex3(:),G2H2(41),ngZd,m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_AQ_W(ntryL,G2H4(48),ex3(:),G2H2(42),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_SV_T(ntryL,G1H8(45),40,wf4(:,1),3,G2H2(43),m3h4x2(:,1),heltab2x8(:,:,93))
  call Hloop_TV_S(ntryL,G1H8(46),40,wf4(:,1),3,G2H2(44),m3h4x2(:,2),heltab2x8(:,:,94))
  call Hloop_SV_T(ntryL,G1H8(47),40,wf4(:,1),3,G2H2(45),m3h4x2(:,3),heltab2x8(:,:,95))
  call Hloop_VV_S(ntryL,G1H8(48),wf4(:,1),G1H2(1),m3h4x2(:,4),heltab2x8(:,:,96))
  call Hloop_VV_S(ntryL,G1H8(49),wf4(:,1),G1H2(2),m3h4x2(:,5),heltab2x8(:,:,97))
  call Hloop_SV_V(ntryL,G1H8(50),wf4(:,1),G1H2(13),m3h4x2(:,6),heltab2x8(:,:,98))
  call Hloop_SV_V(ntryL,G1H8(51),wf4(:,1),G1H2(14),m3h4x2(:,7),heltab2x8(:,:,99))
  call Hloop_UW_V(ntryL,G1H8(52),40,wf4(:,1),3,G2H2(46),m3h4x2(:,8),heltab2x8(:,:,100))
  call Hloop_SV_T(ntryL,G1H8(53),36,wf4(:,1),3,G2H2(47),m3h4x2(:,9),heltab2x8(:,:,101))
  call Hloop_TV_S(ntryL,G1H8(54),36,wf4(:,1),3,G2H2(48),m3h4x2(:,10),heltab2x8(:,:,102))
  call Hloop_TV_S(ntryL,G1H8(55),36,wf4(:,1),3,G2H2(49),m3h4x2(:,11),heltab2x8(:,:,103))
  call Hloop_SV_V(ntryL,G1H8(56),wf4(:,1),G1H2(25),m3h4x2(:,12),heltab2x8(:,:,104))
  call Hloop_SV_V(ntryL,G1H8(57),wf4(:,1),G1H2(26),m3h4x2(:,13),heltab2x8(:,:,105))
  call Hloop_TV_S(ntryL,G1H8(58),36,wf4(:,1),3,G2H2(50),m3h4x2(:,14),heltab2x8(:,:,106))
  call Hloop_TV_S(ntryL,G1H8(59),36,wf4(:,1),3,G2H2(51),m3h4x2(:,15),heltab2x8(:,:,107))
  call Hloop_VV_S(ntryL,G1H8(60),wf4(:,1),G1H2(37),m3h4x2(:,16),heltab2x8(:,:,108))
  call Hloop_VV_S(ntryL,G1H8(61),wf4(:,1),G1H2(38),m3h4x2(:,17),heltab2x8(:,:,109))
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(10),mass5set(:,9),  & 
G1H8(12),G1H8(13),G1H8(18),G1H8(1),G1H8(19),G1H8(20),8)
  call HG1shiftOLR(G1H8(13),8,8)
  call Hloop_SV_V(ntryL,G1H8(62),wf4(:,1),G1H2(49),m3h4x2(:,18),heltab2x8(:,:,110))
  call Hloop_SV_V(ntryL,G1H8(63),wf4(:,1),G1H2(50),m3h4x2(:,19),heltab2x8(:,:,111))
  call Hloop_UV_W(ntryL,G1H8(64),36,wf4(:,1),3,G2H2(52),m3h4x2(:,20),heltab2x8(:,:,112))
  call Hloop_VV_S(ntryL,G1H8(65),wf4(:,1),G1H2(58),m3h4x2(:,21),heltab2x8(:,:,113))
  call Hloop_UV_W(ntryL,G1H8(66),36,wf4(:,1),3,G2H2(53),m3h4x2(:,22),heltab2x8(:,:,114))
  call Hloop_TV_S(ntryL,G1H8(67),36,wf4(:,1),3,G2H2(54),m3h4x2(:,23),heltab2x8(:,:,115))
  call Hloop_SV_T(ntryL,G1H8(68),36,wf4(:,1),3,G2H2(55),m3h4x2(:,24),heltab2x8(:,:,116))
  call Hloop_TV_S(ntryL,G1H8(69),36,wf4(:,1),3,G2H2(56),m3h4x2(:,25),heltab2x8(:,:,117))
  call Hloop_SV_V(ntryL,G1H8(70),wf4(:,1),G1H2(59),m3h4x2(:,26),heltab2x8(:,:,118))
  call Hloop_SV_V(ntryL,G1H8(71),wf4(:,1),G1H2(64),m3h4x2(:,27),heltab2x8(:,:,119))
  call Hloop_VV_S(ntryL,G1H8(72),wf4(:,1),G1H2(65),m3h4x2(:,28),heltab2x8(:,:,120))
  call Hloop_VV_S(ntryL,G1H8(73),wf4(:,1),G1H2(70),m3h4x2(:,29),heltab2x8(:,:,121))
  call Hloop_UV_W(ntryL,G1H8(74),36,wf4(:,1),3,G2H2(57),m3h4x2(:,30),heltab2x8(:,:,122))
  call Hloop_ZQ_A(ntryL,G1H8(75),ex1(:),G1H4(103),ngZn,m3h2x4(:,73),heltab2x8(:,:,123))
  call Hloop_Q_A(ntryL,G1H4(103),41,0,G2H4(19),n2h4(100))
  call Hloop_ZA_Q(ntryL,G1H8(76),ex2(:),G1H4(103),ngZn,m3h2x4(:,74),heltab2x8(:,:,124))
  call Hloop_A_Q(ntryL,G1H4(103),42,0,G2H4(20),n2h4(101))
  call Hloop_WA_Q(ntryL,G1H8(77),ex2(:),G1H4(103),m3h2x4(:,75),heltab2x8(:,:,125))
  call Hloop_A_Q(ntryL,G1H4(103),42,0,G2H4(21),n2h4(102))
  call Hloop_ZQ_A(ntryL,G1H8(78),ex1(:),G1H4(103),ngZn,m3h2x4(:,76),heltab2x8(:,:,126))
  call Hloop_Q_A(ntryL,G1H4(103),37,0,G2H4(22),n2h4(103))
  call Hloop_WQ_A(ntryL,G1H8(79),ex1(:),G1H4(103),m3h2x4(:,77),heltab2x8(:,:,127))
  call Hloop_Q_A(ntryL,G1H4(103),37,0,G2H4(23),n2h4(104))
  call Hloop_ZA_Q(ntryL,G1H8(80),ex2(:),G1H4(103),ngZn,m3h2x4(:,78),heltab2x8(:,:,128))
  call Hloop_A_Q(ntryL,G1H4(103),38,0,G2H4(24),n2h4(105))
  call Hloop_ZQ_A(ntryL,G1H4(1),ex1(:),G1H2(71),ngZn,m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(71),45,0,G2H2(58),n2h2(10))
  call Hloop_ZQ_A(ntryL,G1H4(2),ex1(:),G1H2(76),ngZn,m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(76),45,0,G2H2(59),n2h2(11))
  call Hloop_AQ_Z(ntryL,G1H4(3),ex1(:),G1H2(77),ngZn,m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_ZA_Q(ntryL,G1H4(4),ex2(:),G1H2(71),ngZn,m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_A_Q(ntryL,G1H2(71),46,0,G2H2(60),n2h2(12))
  call Hloop_WA_Q(ntryL,G1H4(5),ex2(:),G1H2(76),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_A_Q(ntryL,G1H2(76),46,0,G2H2(61),n2h2(13))
  call Hloop_ZA_Q(ntryL,G1H4(6),ex2(:),G1H2(71),ngZn,m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_A_Q(ntryL,G1H2(71),46,0,G2H2(62),n2h2(14))
  call Hloop_WA_Q(ntryL,G1H4(7),ex2(:),G1H2(76),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_A_Q(ntryL,G1H2(76),46,0,G2H2(63),n2h2(15))
  call Hloop_AQ_Z(ntryL,G1H4(8),ex1(:),G1H2(71),ngZn,m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_AQ_Z(ntryL,G1H4(9),ex1(:),G1H2(76),ngZn,m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_QA_Z(ntryL,G1H4(10),ex2(:),G1H2(82),ngZn,m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_QA_W(ntryL,G1H4(11),ex2(:),G1H2(83),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_QA_Z(ntryL,G1H4(12),ex2(:),G1H2(84),ngZn,m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_QA_W(ntryL,G1H4(13),ex2(:),G1H2(85),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_QA_Z(ntryL,G1H4(14),ex2(:),G1H2(86),ngZn,m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_QA_W(ntryL,G1H4(15),ex2(:),G1H2(87),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_ZQ_A(ntryL,G1H4(16),ex1(:),G1H2(88),ngZn,m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(88),45,0,G2H2(64),n2h2(16))
  call Hloop_WQ_A(ntryL,G1H4(17),ex1(:),G1H2(88),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(88),45,0,G2H2(65),n2h2(17))
  call Hloop_ZQ_A(ntryL,G1H4(18),ex1(:),G1H2(88),ngZn,m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_Q_A(ntryL,G1H2(88),45,0,G2H2(66),n2h2(18))
  call Hloop_WQ_A(ntryL,G1H4(19),ex1(:),G1H2(88),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(88),45,0,G2H2(67),n2h2(19))
  call Hloop_AQ_Z(ntryL,G1H4(20),ex1(:),G1H2(88),ngZn,m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_AQ_W(ntryL,G1H4(21),ex1(:),G1H2(89),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_ZA_Q(ntryL,G1H4(22),ex2(:),G1H2(90),ngZn,m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_A_Q(ntryL,G1H2(90),46,0,G2H2(68),n2h2(20))
  call Hloop_ZA_Q(ntryL,G1H4(23),ex2(:),G1H2(90),ngZn,m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_A_Q(ntryL,G1H2(90),46,0,G2H2(69),n2h2(21))
  call Hloop_AQ_Z(ntryL,G1H4(24),ex1(:),G1H2(90),ngZn,m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_AQ_W(ntryL,G1H4(25),ex1(:),G1H2(91),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_AQ_Z(ntryL,G1H4(26),ex1(:),G1H2(92),ngZn,m3h2x2(:,74),heltab2x4(:,:,74))
  call Hloop_AQ_W(ntryL,G1H4(27),ex1(:),G1H2(93),m3h2x2(:,75),heltab2x4(:,:,75))
  call Hloop_QA_Z(ntryL,G1H4(28),ex2(:),G1H2(94),ngZn,m3h2x2(:,76),heltab2x4(:,:,76))
  call Hloop_QA_Z(ntryL,G1H4(29),ex2(:),G1H2(95),ngZn,m3h2x2(:,77),heltab2x4(:,:,77))
  call Hloop_QA_Z(ntryL,G1H4(30),ex2(:),G1H2(96),ngZn,m3h2x2(:,78),heltab2x4(:,:,78))
  call Hloop_AS_Q(ntryL,G1H4(31),ex5(:),G1H4(103),ngH,m3h1x4(:,1),heltab2x4(:,:,79))
  call Hloop_A_Q(ntryL,G1H4(103),51,nMB,G2H4(25),n2h4(106))
call HGT_OLR(G1H4(32),1,1,4)
call HGT_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(32),-8,nMB,G2H4(26),n2h4(107))
  call Hloop_QA_S(ntryL,G2H4(26),ex4(:),G2H2(70),ngH,m3h2x2(:,79),heltab2x4(:,:,80))
  call Hloop_AS_Q(ntryL,G1H4(34),ex5(:),G1H4(1),ngH,m3h1x4(:,2),heltab2x4(:,:,81))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMB,G2H4(27),n2h4(108))
  call Hloop_AS_Q(ntryL,G1H4(35),ex5(:),G1H4(2),ngH,m3h1x4(:,3),heltab2x4(:,:,82))
  call Hloop_A_Q(ntryL,G1H4(2),51,nMB,G2H4(28),n2h4(109))
  call Hloop_AS_Q(ntryL,G1H4(36),ex5(:),G1H4(3),ngH,m3h1x4(:,4),heltab2x4(:,:,83))
  call Hloop_A_Q(ntryL,G1H4(3),51,nMB,G2H4(29),n2h4(110))
  call Hloop_AS_Q(ntryL,G1H4(37),ex5(:),G1H4(4),ngH,m3h1x4(:,5),heltab2x4(:,:,84))
  call Hloop_A_Q(ntryL,G1H4(4),51,nMB,G2H4(30),n2h4(111))
call HGT_OLR(G1H4(38),1,1,4)
call HGT_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(38),-8,nMB,G2H4(31),n2h4(112))
  call Hloop_QA_S(ntryL,G2H4(31),ex4(:),G2H2(71),ngX,m3h2x2(:,80),heltab2x4(:,:,85))
  call Hloop_AS_Q(ntryL,G1H4(40),ex5(:),G1H4(5),ngH,m3h1x4(:,6),heltab2x4(:,:,86))
  call Hloop_A_Q(ntryL,G1H4(5),51,nMB,G2H4(32),n2h4(113))
  call Hloop_AS_Q(ntryL,G1H4(41),ex5(:),G1H4(6),ngH,m3h1x4(:,7),heltab2x4(:,:,87))
  call Hloop_A_Q(ntryL,G1H4(6),51,nMB,G2H4(33),n2h4(114))
  call Hloop_AS_Q(ntryL,G1H4(42),ex5(:),G1H4(7),ngH,m3h1x4(:,8),heltab2x4(:,:,88))
  call Hloop_A_Q(ntryL,G1H4(7),51,nMB,G2H4(34),n2h4(115))
  call Hloop_AS_Q(ntryL,G1H4(43),ex5(:),G1H4(8),ngH,m3h1x4(:,9),heltab2x4(:,:,89))
  call Hloop_A_Q(ntryL,G1H4(8),51,nMT,G2H4(35),n2h4(116))
call HGT_OLR(G1H4(44),1,1,4)
call HGT_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(44),-8,nMT,G2H4(36),n2h4(117))
  call Hloop_QA_S(ntryL,G2H4(36),ex4(:),G2H2(72),ngPbt,m3h2x2(:,81),heltab2x4(:,:,90))
  call Hloop_AS_Q(ntryL,G1H4(46),ex5(:),G1H4(9),ngH,m3h1x4(:,10),heltab2x4(:,:,91))
  call Hloop_A_Q(ntryL,G1H4(9),51,nMT,G2H4(37),n2h4(118))
  call Hloop_AS_Q(ntryL,G1H4(47),ex5(:),G1H4(10),ngH,m3h1x4(:,11),heltab2x4(:,:,92))
  call Hloop_A_Q(ntryL,G1H4(10),51,nMT,G2H4(38),n2h4(119))
  call Hloop_AS_Q(ntryL,G1H4(48),ex5(:),G1H4(11),ngH,m3h1x4(:,12),heltab2x4(:,:,93))
  call Hloop_A_Q(ntryL,G1H4(11),51,nMT,G2H4(39),n2h4(120))
  call Hloop_AS_Q(ntryL,G1H4(49),ex5(:),G1H4(12),ngH,m3h1x4(:,13),heltab2x4(:,:,94))
  call Hloop_A_Q(ntryL,G1H4(12),51,nMB,G2H4(40),n2h4(121))
call HGT_OLR(G1H4(50),1,1,4)
call HGT_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(50),-8,nMB,G2H4(41),n2h4(122))
  call Hloop_QA_V(ntryL,G2H4(41),ex4(:),G2H2(73),m3h2x2(:,82),heltab2x4(:,:,95))
  call Hloop_AS_Q(ntryL,G1H4(52),ex5(:),G1H4(13),ngH,m3h1x4(:,14),heltab2x4(:,:,96))
  call Hloop_A_Q(ntryL,G1H4(13),51,nMB,G2H4(42),n2h4(123))
  call Hloop_AS_Q(ntryL,G1H4(53),ex5(:),G1H4(14),ngH,m3h1x4(:,15),heltab2x4(:,:,97))
  call Hloop_A_Q(ntryL,G1H4(14),51,nMB,G2H4(43),n2h4(124))
  call Hloop_AS_Q(ntryL,G1H4(54),ex5(:),G1H4(15),ngH,m3h1x4(:,16),heltab2x4(:,:,98))
  call Hloop_A_Q(ntryL,G1H4(15),51,nMB,G2H4(44),n2h4(125))
  call Hloop_AS_Q(ntryL,G1H4(55),ex5(:),G1H4(16),ngH,m3h1x4(:,17),heltab2x4(:,:,99))
  call Hloop_A_Q(ntryL,G1H4(16),51,nMB,G2H4(45),n2h4(126))
call HGT_OLR(G1H4(56),1,1,4)
call HGT_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(56),-8,nMB,G2H4(46),n2h4(127))
  call Hloop_QA_Z(ntryL,G2H4(46),ex4(:),G2H2(74),ngZd,m3h2x2(:,83),heltab2x4(:,:,100))
  call Hloop_AS_Q(ntryL,G1H4(58),ex5(:),G1H4(17),ngH,m3h1x4(:,18),heltab2x4(:,:,101))
  call Hloop_A_Q(ntryL,G1H4(17),51,nMB,G2H4(47),n2h4(128))
  call Hloop_AS_Q(ntryL,G1H4(59),ex5(:),G1H4(18),ngH,m3h1x4(:,19),heltab2x4(:,:,102))
  call Hloop_A_Q(ntryL,G1H4(18),51,nMB,G2H4(48),n2h4(129))
  call Hloop_AS_Q(ntryL,G1H4(60),ex5(:),G1H4(19),ngH,m3h1x4(:,20),heltab2x4(:,:,103))
  call Hloop_A_Q(ntryL,G1H4(19),51,nMB,G2H4(26),n2h4(130))
  call Hloop_AS_Q(ntryL,G1H4(61),ex5(:),G1H4(20),ngH,m3h1x4(:,21),heltab2x4(:,:,104))
  call Hloop_A_Q(ntryL,G1H4(20),51,nMT,G2H4(31),n2h4(131))
call HGT_OLR(G1H4(62),1,1,4)
call HGT_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(62),-8,nMT,G2H4(36),n2h4(132))
  call Hloop_QA_W(ntryL,G2H4(36),ex4(:),G2H2(75),m3h2x2(:,84),heltab2x4(:,:,105))
  call Hloop_AS_Q(ntryL,G1H4(64),ex5(:),G1H4(21),ngH,m3h1x4(:,22),heltab2x4(:,:,106))
  call Hloop_A_Q(ntryL,G1H4(21),51,nMT,G2H4(41),n2h4(133))
  call Hloop_AS_Q(ntryL,G1H4(65),ex5(:),G1H4(22),ngH,m3h1x4(:,23),heltab2x4(:,:,107))
  call Hloop_A_Q(ntryL,G1H4(22),51,nMT,G2H4(46),n2h4(134))
  call Hloop_AS_Q(ntryL,G1H4(66),ex5(:),G1H4(23),ngH,m3h1x4(:,24),heltab2x4(:,:,108))
  call Hloop_A_Q(ntryL,G1H4(23),51,nMT,G2H4(36),n2h4(135))
  call Hloop_QS_A(ntryL,G1H4(67),ex5(:),G1H4(24),ngH,m3h1x4(:,25),heltab2x4(:,:,109))
  call Hloop_Q_A(ntryL,G1H4(24),51,nMB,G2H4(55),n2h4(136))
call HGT_OLR(G1H4(68),1,1,4)
call HGT_invQ_OLR(G1H4(68),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(68),-4,nMB,G2H4(56),n2h4(137))
  call Hloop_AQ_S(ntryL,G2H4(56),ex3(:),G2H2(76),ngH,m3h2x2(:,85),heltab2x4(:,:,110))
  call Hloop_QS_A(ntryL,G1H4(70),ex5(:),G1H4(25),ngH,m3h1x4(:,26),heltab2x4(:,:,111))
  call Hloop_Q_A(ntryL,G1H4(25),51,nMB,G2H4(56),n2h4(138))
  call Hloop_QS_A(ntryL,G1H4(71),ex5(:),G1H4(26),ngH,m3h1x4(:,27),heltab2x4(:,:,112))
  call Hloop_Q_A(ntryL,G1H4(26),51,nMB,G2H4(57),n2h4(139))
  call Hloop_QS_A(ntryL,G1H4(72),ex5(:),G1H4(27),ngH,m3h1x4(:,28),heltab2x4(:,:,113))
  call Hloop_Q_A(ntryL,G1H4(27),51,nMB,G2H4(58),n2h4(140))
  call Hloop_QS_A(ntryL,G1H4(73),ex5(:),G1H4(28),ngH,m3h1x4(:,29),heltab2x4(:,:,114))
  call Hloop_Q_A(ntryL,G1H4(28),51,nMB,G2H4(59),n2h4(141))
call HGT_OLR(G1H4(74),1,1,4)
call HGT_invQ_OLR(G1H4(74),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(74),-4,nMB,G2H4(60),n2h4(142))
  call Hloop_AQ_S(ntryL,G2H4(60),ex3(:),G2H2(77),ngX,m3h2x2(:,86),heltab2x4(:,:,115))
  call Hloop_QS_A(ntryL,G1H4(76),ex5(:),G1H4(29),ngH,m3h1x4(:,30),heltab2x4(:,:,116))
  call Hloop_Q_A(ntryL,G1H4(29),51,nMB,G2H4(60),n2h4(143))
  call Hloop_QS_A(ntryL,G1H4(77),ex5(:),G1H4(30),ngH,m3h1x4(:,31),heltab2x4(:,:,117))
  call Hloop_Q_A(ntryL,G1H4(30),51,nMB,G2H4(61),n2h4(144))
  call Hloop_QS_A(ntryL,G1H4(78),ex5(:),G1H4(31),ngH,m3h1x4(:,32),heltab2x4(:,:,118))
  call Hloop_Q_A(ntryL,G1H4(31),51,nMB,G2H4(62),n2h4(145))
  call Hloop_QS_A(ntryL,G1H4(79),ex5(:),G1H4(103),ngH,m3h1x4(:,33),heltab2x4(:,:,119))
  call Hloop_Q_A(ntryL,G1H4(103),51,nMT,G2H4(63),n2h4(146))
call HGT_OLR(G1H4(80),1,1,4)
call HGT_invQ_OLR(G1H4(80),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(80),-4,nMT,G2H4(64),n2h4(147))
  call Hloop_AQ_S(ntryL,G2H4(64),ex3(:),G2H2(78),ngPtb,m3h2x2(:,87),heltab2x4(:,:,120))
  call Hloop_QS_A(ntryL,G1H4(82),ex5(:),G1H4(32),ngH,m3h1x4(:,34),heltab2x4(:,:,121))
  call Hloop_Q_A(ntryL,G1H4(32),51,nMT,G2H4(64),n2h4(148))
  call Hloop_QS_A(ntryL,G1H4(83),ex5(:),G1H4(34),ngH,m3h1x4(:,35),heltab2x4(:,:,122))
  call Hloop_Q_A(ntryL,G1H4(34),51,nMT,G2H4(65),n2h4(149))
  call Hloop_QS_A(ntryL,G1H4(84),ex5(:),G1H4(1),ngH,m3h1x4(:,36),heltab2x4(:,:,123))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(66),n2h4(150))
  call Hloop_QS_A(ntryL,G1H4(85),ex5(:),G1H4(35),ngH,m3h1x4(:,37),heltab2x4(:,:,124))
  call Hloop_Q_A(ntryL,G1H4(35),51,nMB,G2H4(67),n2h4(151))
call HGT_OLR(G1H4(86),1,1,4)
call HGT_invQ_OLR(G1H4(86),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(86),-4,nMB,G2H4(68),n2h4(152))
  call Hloop_AQ_V(ntryL,G2H4(68),ex3(:),G2H2(79),m3h2x2(:,88),heltab2x4(:,:,125))
  call Hloop_QS_A(ntryL,G1H4(88),ex5(:),G1H4(2),ngH,m3h1x4(:,38),heltab2x4(:,:,126))
  call Hloop_Q_A(ntryL,G1H4(2),51,nMB,G2H4(68),n2h4(153))
  call Hloop_QS_A(ntryL,G1H4(89),ex5(:),G1H4(36),ngH,m3h1x4(:,39),heltab2x4(:,:,127))
  call Hloop_Q_A(ntryL,G1H4(36),51,nMB,G2H4(69),n2h4(154))
  call Hloop_QS_A(ntryL,G1H4(90),ex5(:),G1H4(3),ngH,m3h1x4(:,40),heltab2x4(:,:,128))
  call Hloop_Q_A(ntryL,G1H4(3),51,nMB,G2H4(70),n2h4(155))
  call Hloop_QS_A(ntryL,G1H4(91),ex5(:),G1H4(37),ngH,m3h1x4(:,41),heltab2x4(:,:,129))
  call Hloop_Q_A(ntryL,G1H4(37),51,nMB,G2H4(71),n2h4(156))
call HGT_OLR(G1H4(92),1,1,4)
call HGT_invQ_OLR(G1H4(92),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(92),-4,nMB,G2H4(72),n2h4(157))
  call Hloop_AQ_Z(ntryL,G2H4(72),ex3(:),G2H2(80),ngZd,m3h2x2(:,89),heltab2x4(:,:,130))
  call Hloop_QS_A(ntryL,G1H4(94),ex5(:),G1H4(4),ngH,m3h1x4(:,42),heltab2x4(:,:,131))
  call Hloop_Q_A(ntryL,G1H4(4),51,nMB,G2H4(72),n2h4(158))
  call Hloop_QS_A(ntryL,G1H4(95),ex5(:),G1H4(38),ngH,m3h1x4(:,43),heltab2x4(:,:,132))
  call Hloop_Q_A(ntryL,G1H4(38),51,nMB,G2H4(73),n2h4(159))
  call Hloop_QS_A(ntryL,G1H4(96),ex5(:),G1H4(40),ngH,m3h1x4(:,44),heltab2x4(:,:,133))
  call Hloop_Q_A(ntryL,G1H4(40),51,nMB,G2H4(74),n2h4(160))
  call Hloop_QS_A(ntryL,G1H4(97),ex5(:),G1H4(5),ngH,m3h1x4(:,45),heltab2x4(:,:,134))
  call Hloop_Q_A(ntryL,G1H4(5),51,nMT,G2H4(75),n2h4(161))
call HGT_OLR(G1H4(98),1,1,4)
call HGT_invQ_OLR(G1H4(98),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(98),-4,nMT,G2H4(76),n2h4(162))
  call Hloop_AQ_W(ntryL,G2H4(76),ex3(:),G2H2(81),m3h2x2(:,90),heltab2x4(:,:,135))
  call Hloop_QS_A(ntryL,G1H4(100),ex5(:),G1H4(41),ngH,m3h1x4(:,46),heltab2x4(:,:,136))
  call Hloop_Q_A(ntryL,G1H4(41),51,nMT,G2H4(76),n2h4(163))
  call Hloop_QS_A(ntryL,G1H4(101),ex5(:),G1H4(6),ngH,m3h1x4(:,47),heltab2x4(:,:,137))
  call Hloop_Q_A(ntryL,G1H4(6),51,nMT,G2H4(77),n2h4(164))
  call Hloop_QS_A(ntryL,G1H4(102),ex5(:),G1H4(42),ngH,m3h1x4(:,48),heltab2x4(:,:,138))
  call Hloop_Q_A(ntryL,G1H4(42),51,nMT,G2H4(78),n2h4(165))
  call Hloop_QS_A(ntryL,G1H8(11),ex5(:),G1H8(21),ngH,m3h1x8(:,21),heltab2x8(:,:,129))
  call Hloop_Q_A(ntryL,G1H8(21),52,nMB,G2H8(2),n2h8(18))
call HGT_raise_alpha_OLR(G1H8(14),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(14),ex4(:),G1H4(7),m3h2x4(:,79),heltab2x8(:,:,130))
  call Hloop_QS_A(ntryL,G1H8(16),ex5(:),G1H8(22),ngH,m3h1x8(:,22),heltab2x8(:,:,131))
  call Hloop_Q_A(ntryL,G1H8(22),52,nMB,G2H8(8),n2h8(20))
  call Hloop_QS_A(ntryL,G1H8(17),ex5(:),G1H8(23),ngH,m3h1x8(:,23),heltab2x8(:,:,132))
  call Hloop_Q_A(ntryL,G1H8(23),52,nMB,G2H8(9),n2h8(21))
  call Hloop_QS_A(ntryL,G1H8(2),ex5(:),G1H8(24),ngH,m3h1x8(:,24),heltab2x8(:,:,133))
  call Hloop_Q_A(ntryL,G1H8(24),52,nMB,G2H8(10),n2h8(22))
  call Hloop_QZ_A(ntryL,G1H8(12),wf4(:,1),G1H2(97),ngZd,m3h4x2(:,31),heltab2x8(:,:,134))
  call Hloop_Q_A(ntryL,G1H2(97),39,nMB,G2H2(82),n2h2(22))
call HGT_raise_alpha_OLR(G1H8(13),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(13),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(13),ex4(:),G1H4(43),m3h2x4(:,80),heltab2x8(:,:,135))
  call Hloop_QZ_A(ntryL,G1H8(1),wf4(:,1),G1H2(97),ngZd,m3h4x2(:,32),heltab2x8(:,:,136))
  call Hloop_Q_A(ntryL,G1H2(97),39,nMB,G2H2(83),n2h2(23))
  call Hloop_QZ_A(ntryL,G1H8(19),wf4(:,1),G1H2(97),ngZd,m3h4x2(:,33),heltab2x8(:,:,137))
  call Hloop_Q_A(ntryL,G1H2(97),39,nMB,G2H2(84),n2h2(24))
  call Hloop_QZ_A(ntryL,G1H8(20),wf4(:,1),G1H2(97),ngZd,m3h4x2(:,34),heltab2x8(:,:,138))
  call Hloop_Q_A(ntryL,G1H2(97),39,nMB,G2H2(85),n2h2(25))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(88),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(41),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(89),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(46),[G1H2(14),G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(82),[G1H2(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(47),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(83),[G1H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(57),[G1H2(64),G1H2(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(84),[G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(53),[G1H2(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(85),[G1H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(52),[G1H2(26),G1H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(94),[G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(77),[G1H2(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(71),[G1H2(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(9),[G2H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(12),[G2H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(17),[G2H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G2H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(5),[G1H8(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(6),[G1H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(3),[G1H8(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(4),[G1H8(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(7),[G1H8(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H8(1),[G1H8(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(43),[G1H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(45),[G1H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(47),[G1H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(49),[G1H2(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(51),[G1H2(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(53),[G1H2(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(55),[G1H2(65)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(56),[G1H2(70)])
call HGT_lower_alpha_w2_OLR(G2H4(2),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(2),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(2),6,15,4)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(11),mass5set(:,10),  & 
G1H4(8),G1H4(44),G1H4(46),G1H4(9),G1H4(47),G1H4(10),4)
  call HG1shiftOLR(G1H4(44),1,4)
  call Hloop_AQ_Z(ntryL,G2H4(3),ex1(:),G2H2(86),ngZn,m3h2x2(:,91),heltab2x4(:,:,139))
call HGT_lower_alpha_w2_OLR(G2H4(6),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(6),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(6),6,15,4)
  call Hotf_5pt_reduction(G2H4(6),RedSet_5(12),mass5set(:,10),  & 
G1H4(48),G1H4(11),G1H4(49),G1H4(12),G1H4(50),G1H4(52),4)
  call HG1shiftOLR(G1H4(11),2,4)
  call Hloop_QA_Z(ntryL,G2H4(7),ex2(:),G2H2(87),ngZn,m3h2x2(:,92),heltab2x4(:,:,140))
call HGT_lower_alpha_w2_OLR(G2H4(10),1,1,4)
call HGT_lower_alpha_w2_invQ_OLR(G2H4(10),2,5,4)
call HGT_lower_alpha_w2_OLR(G2H4(10),6,15,4)
  call Hotf_5pt_reduction(G2H4(10),RedSet_5(12),mass5set(:,11),  & 
G1H4(13),G1H4(53),G1H4(14),G1H4(54),G1H4(15),G1H4(55),4)
  call HG1shiftOLR(G1H4(53),2,4)
  call Hloop_QA_W(ntryL,G2H4(11),ex2(:),G2H2(88),m3h2x2(:,93),heltab2x4(:,:,141))
  call Hloop_ZQ_A(ntryL,G1H2(88),ex3(:),G1H1(13),ngZd,m3h2x1(:,34),heltab2x2(:,:,49))
  call Hloop_Q_A(ntryL,G1H1(13),47,nMB,G2H1(1),n2h1(43))
  call Hloop_ZQ_A(ntryL,G1H2(4),ex3(:),G1H1(1),ngZd,m3h2x1(:,35),heltab2x2(:,:,50))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMB,G2H1(3),n2h1(44))
  call Hloop_ZQ_A(ntryL,G1H2(41),ex3(:),G1H1(14),ngZd,m3h2x1(:,36),heltab2x2(:,:,51))
  call Hloop_Q_A(ntryL,G1H1(14),47,nMB,G2H1(5),n2h1(45))
  call Hloop_WQ_A(ntryL,G1H2(89),ex3(:),G1H1(25),m3h2x1(:,37),heltab2x2(:,:,52))
  call Hloop_Q_A(ntryL,G1H1(25),47,nMT,G2H1(7),n2h1(46))
  call Hloop_WQ_A(ntryL,G1H2(10),ex3(:),G1H1(7),m3h2x1(:,38),heltab2x2(:,:,53))
  call Hloop_Q_A(ntryL,G1H1(7),47,nMT,G2H1(11),n2h1(47))
  call Hotf_5pt_reduction(G2H2(46),RedSet_5(13),mass5set(:,12),  & 
G1H2(97),G1H2(3),G1H2(5),G1H2(9),G1H2(14),G1H2(11),2)
  call HG1shiftOLR(G1H2(3),16,2)
  call Hloop_ZA_Q(ntryL,G1H2(82),ex4(:),G1H1(26),ngZd,m3h2x1(:,39),heltab2x2(:,:,54))
  call Hloop_A_Q(ntryL,G1H1(26),47,nMB,G2H1(13),n2h1(48))
  call Hloop_ZA_Q(ntryL,G1H2(16),ex4(:),G1H1(19),ngZd,m3h2x1(:,40),heltab2x2(:,:,55))
  call Hloop_A_Q(ntryL,G1H1(19),47,nMB,G2H1(16),n2h1(49))
  call Hloop_ZA_Q(ntryL,G1H2(47),ex4(:),G1H1(31),ngZd,m3h2x1(:,41),heltab2x2(:,:,56))
  call Hloop_A_Q(ntryL,G1H1(31),47,nMB,G2H1(17),n2h1(50))
  call Hloop_WA_Q(ntryL,G1H2(83),ex4(:),G1H1(37),m3h2x1(:,42),heltab2x2(:,:,57))
  call Hloop_A_Q(ntryL,G1H1(37),47,nMT,G2H1(18),n2h1(51))
  call Hloop_WA_Q(ntryL,G1H2(22),ex4(:),G1H1(32),m3h2x1(:,43),heltab2x2(:,:,58))
  call Hloop_A_Q(ntryL,G1H1(32),47,nMT,G2H1(19),n2h1(52))
  call Hotf_5pt_reduction(G2H2(57),RedSet_5(14),mass5set(:,12),  & 
G1H2(15),G1H2(17),G1H2(21),G1H2(64),G1H2(23),G1H2(27),2)
  call HG1shiftOLR(G1H2(17),16,2)
  call Hloop_VT_S(ntryL,G1H2(84),39,ex5(:),16,G2H2(46),m3h1x2(:,16),heltab2x2(:,:,59))
  call Hloop_VT_S(ntryL,G1H2(28),39,ex5(:),16,G2H2(57),m3h1x2(:,17),heltab2x2(:,:,60))
  call Hloop_VT_S(ntryL,G1H2(53),39,ex5(:),16,G2H2(89),m3h1x2(:,18),heltab2x2(:,:,61))
  call Hloop_VT_S(ntryL,G1H2(85),39,ex5(:),16,G2H2(90),m3h1x2(:,19),heltab2x2(:,:,62))
  call Hloop_VT_S(ntryL,G1H2(34),39,ex5(:),16,G2H2(91),m3h1x2(:,20),heltab2x2(:,:,63))
  call Hotf_5pt_reduction(G2H2(52),RedSet_5(10),mass5set(:,13),  & 
G1H2(29),G1H2(33),G1H2(26),G1H2(35),G1H2(39),G1H2(45),2)
  call HG1shiftOLR(G1H2(33),8,2)
  call Hloop_ZQ_A(ntryL,G1H2(94),ex3(:),G1H1(20),ngZd,m3h2x1(:,44),heltab2x2(:,:,64))
  call Hloop_Q_A(ntryL,G1H1(20),47,nMB,G2H1(20),n2h1(53))
  call Hloop_ZQ_A(ntryL,G1H2(40),ex3(:),G1H1(8),ngZd,m3h2x1(:,45),heltab2x2(:,:,65))
  call Hloop_Q_A(ntryL,G1H1(8),47,nMB,G2H1(21),n2h1(54))
  call Hloop_ZA_Q(ntryL,G1H2(77),ex4(:),G1H1(2),ngZd,m3h2x1(:,46),heltab2x2(:,:,66))
  call Hloop_A_Q(ntryL,G1H1(2),47,nMB,G2H1(22),n2h1(55))
  call Hloop_ZA_Q(ntryL,G1H2(46),ex4(:),G1H1(13),ngZd,m3h2x1(:,47),heltab2x2(:,:,67))
  call Hloop_A_Q(ntryL,G1H1(13),47,nMB,G2H1(23),n2h1(56))
  call Hloop_VT_S(ntryL,G1H2(71),39,ex5(:),16,G2H2(52),m3h1x2(:,21),heltab2x2(:,:,68))
  call Hloop_VT_S(ntryL,G1H2(52),39,ex5(:),16,G2H2(92),m3h1x2(:,22),heltab2x2(:,:,69))
  call Hloop_AQ_Z(ntryL,G2H4(49),ex1(:),G2H2(93),ngZn,m3h2x2(:,94),heltab2x4(:,:,142))
  call Hloop_AQ_Z(ntryL,G2H4(50),ex1(:),G2H2(94),ngZn,m3h2x2(:,95),heltab2x4(:,:,143))
  call Hloop_QA_Z(ntryL,G2H4(51),ex2(:),G2H2(95),ngZn,m3h2x2(:,96),heltab2x4(:,:,144))
  call Hloop_QA_Z(ntryL,G2H4(52),ex2(:),G2H2(96),ngZn,m3h2x2(:,97),heltab2x4(:,:,145))
  call Hloop_QA_W(ntryL,G2H4(53),ex2(:),G2H2(97),m3h2x2(:,98),heltab2x4(:,:,146))
  call Hloop_QA_W(ntryL,G2H4(54),ex2(:),G2H2(98),m3h2x2(:,99),heltab2x4(:,:,147))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(15),mass5set(:,14),  & 
G1H2(51),G1H2(1),G1H2(2),G1H2(37),G1H2(38),G1H2(58),2)
  call HG1shiftOLR(G1H2(1),16,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(15),mass5set(:,15),  & 
G1H2(50),G1H2(65),G1H2(70),G1H2(88),G1H2(4),G1H2(41),2)
  call HG1shiftOLR(G1H2(65),16,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(15),mass5set(:,16),  & 
G1H2(89),G1H2(10),G1H2(82),G1H2(16),G1H2(47),G1H2(83),2)
  call HG1shiftOLR(G1H2(10),16,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(15),mass5set(:,17),  & 
G1H2(22),G1H2(84),G1H2(28),G1H2(53),G1H2(85),G1H2(34),2)
  call HG1shiftOLR(G1H2(84),16,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(15),mass5set(:,15),  & 
G1H2(94),G1H2(40),G1H2(77),G1H2(46),G1H2(71),G1H2(52),2)
  call HG1shiftOLR(G1H2(40),16,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(15),mass5set(:,16),  & 
G1H2(98),G1H2(99),G1H2(100),G1H2(101),G1H2(102),G1H2(103),2)
  call HG1shiftOLR(G1H2(99),16,2)
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(16),mass5set(:,18),  & 
G1H4(16),G1H4(56),G1H4(58),G1H4(17),G1H4(59),G1H4(18),4)
  call HG1shiftOLR(G1H4(56),16,4)
  call Hotf_5pt_reduction(G2H4(9),RedSet_5(16),mass5set(:,19),  & 
G1H4(60),G1H4(19),G1H4(61),G1H4(20),G1H4(62),G1H4(64),4)
  call HG1shiftOLR(G1H4(19),16,4)
  call Hotf_5pt_reduction(G2H4(12),RedSet_5(16),mass5set(:,20),  & 
G1H4(21),G1H4(65),G1H4(22),G1H4(66),G1H4(23),G1H4(67),4)
  call HG1shiftOLR(G1H4(65),16,4)
  call Hotf_5pt_reduction(G2H4(8),RedSet_5(16),mass5set(:,21),  & 
G1H4(24),G1H4(68),G1H4(70),G1H4(25),G1H4(71),G1H4(26),4)
  call HG1shiftOLR(G1H4(68),16,4)
  call Hotf_5pt_reduction(G2H2(12),RedSet_5(17),mass5set(:,14),  & 
G1H2(104),G1H2(105),G1H2(106),G1H2(107),G1H2(108),G1H2(109),2)
  call HG1shiftOLR(G1H2(105),16,2)
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(17),mass5set(:,15),  & 
G1H2(110),G1H2(111),G1H2(112),G1H2(113),G1H2(114),G1H2(115),2)
  call HG1shiftOLR(G1H2(111),16,2)
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(17),mass5set(:,16),  & 
G1H2(116),G1H2(117),G1H2(118),G1H2(119),G1H2(120),G1H2(121),2)
  call HG1shiftOLR(G1H2(117),16,2)
  call Hotf_5pt_reduction(G2H2(22),RedSet_5(17),mass5set(:,17),  & 
G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),G1H2(127),2)
  call HG1shiftOLR(G1H2(123),16,2)
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(17),mass5set(:,15),  & 
G1H2(128),G1H2(129),G1H2(130),G1H2(131),G1H2(132),G1H2(133),2)
  call HG1shiftOLR(G1H2(129),16,2)
  call Hotf_5pt_reduction(G2H2(24),RedSet_5(17),mass5set(:,16),  & 
G1H2(134),G1H2(135),G1H2(136),G1H2(137),G1H2(138),G1H2(139),2)
  call HG1shiftOLR(G1H2(135),16,2)
  call Hotf_5pt_reduction(G2H4(13),RedSet_5(18),mass5set(:,18),  & 
G1H4(72),G1H4(27),G1H4(73),G1H4(28),G1H4(74),G1H4(76),4)
  call HG1shiftOLR(G1H4(27),16,4)
  call Hotf_5pt_reduction(G2H4(17),RedSet_5(18),mass5set(:,19),  & 
G1H4(29),G1H4(77),G1H4(30),G1H4(78),G1H4(31),G1H4(79),4)
  call HG1shiftOLR(G1H4(77),16,4)
  call Hotf_5pt_reduction(G2H4(18),RedSet_5(18),mass5set(:,20),  & 
G1H4(103),G1H4(80),G1H4(82),G1H4(32),G1H4(83),G1H4(34),4)
  call HG1shiftOLR(G1H4(80),16,4)
  call Hotf_5pt_reduction(G2H4(16),RedSet_5(18),mass5set(:,21),  & 
G1H4(84),G1H4(1),G1H4(85),G1H4(35),G1H4(86),G1H4(88),4)
  call HG1shiftOLR(G1H4(1),16,4)
  call Hloop_SS_S(ntryL,G2H2(25),ex5(:),G2H2(1),m3h1x2(:,23),heltab2x2(:,:,70))
  call Hloop_SS_S(ntryL,G2H2(26),ex5(:),G2H2(2),m3h1x2(:,24),heltab2x2(:,:,71))
  call Hloop_SS_S(ntryL,G2H2(27),ex5(:),G2H2(3),m3h1x2(:,25),heltab2x2(:,:,72))
  call Hotf_5pt_reduction(G2H2(28),RedSet_5(19),mass5set(:,22),  & 
G1H2(140),G1H2(141),G1H2(142),G1H2(143),G1H2(144),G1H2(145),2)
  call HG1shiftOLR(G1H2(141),4,2)
  call Hotf_5pt_reduction(G2H2(29),RedSet_5(19),mass5set(:,23),  & 
G1H2(146),G1H2(147),G1H2(148),G1H2(149),G1H2(150),G1H2(151),2)
  call HG1shiftOLR(G1H2(147),4,2)
  call Hotf_5pt_reduction(G2H2(30),RedSet_5(19),mass5set(:,22),  & 
G1H2(152),G1H2(153),G1H2(154),G1H2(155),G1H2(156),G1H2(157),2)
  call HG1shiftOLR(G1H2(153),4,2)
  call Hotf_5pt_reduction(G2H2(31),RedSet_5(19),mass5set(:,23),  & 
G1H2(158),G1H2(159),G1H2(160),G1H2(161),G1H2(162),G1H2(163),2)
  call HG1shiftOLR(G1H2(159),4,2)
  call Hloop_VS_V(ntryL,G2H2(32),ex5(:),G2H2(4),m3h1x2(:,26),heltab2x2(:,:,73))
  call Hloop_VS_V(ntryL,G2H2(33),ex5(:),G2H2(6),m3h1x2(:,27),heltab2x2(:,:,74))
  call Hloop_TV_S(ntryL,G1H8(4),52,wf4(:,1),3,G2H2(8),m3h4x2(:,35),heltab2x8(:,:,139))
  call Hotf_5pt_reduction(G2H8(5),RedSet_5(9),mass5set(:,24),  & 
G1H8(25),G1H8(26),G1H8(27),G1H8(28),G1H8(29),G1H8(30),8)
  call HG1shiftOLR(G1H8(26),8,8)
  call Hotf_5pt_reduction(G2H8(6),RedSet_5(9),mass5set(:,13),  & 
G1H8(31),G1H8(32),G1H8(33),G1H8(34),G1H8(35),G1H8(36),8)
  call HG1shiftOLR(G1H8(32),8,8)
  call Hloop_VV_S(ntryL,G2H8(3),wf4(:,1),G2H2(12),m3h4x2(:,36),heltab2x8(:,:,140))
  call Hloop_VV_S(ntryL,G2H8(4),wf4(:,1),G2H2(16),m3h4x2(:,37),heltab2x8(:,:,141))
  call Hloop_SV_V(ntryL,G1H8(9),wf4(:,1),G1H2(164),m3h4x2(:,38),heltab2x8(:,:,142))
  call Hloop_SV_V(ntryL,G2H8(7),wf4(:,1),G2H2(18),m3h4x2(:,39),heltab2x8(:,:,143))
  call Hotf_5pt_reduction(G2H8(1),RedSet_5(9),mass5set(:,13),  & 
G1H8(37),G1H8(38),G1H8(39),G1H8(40),G1H8(41),G1H8(42),8)
  call HG1shiftOLR(G1H8(38),8,8)
  call Hloop_SS_S(ntryL,G2H2(34),ex5(:),G2H2(22),m3h1x2(:,28),heltab2x2(:,:,75))
  call Hloop_SS_S(ntryL,G2H2(35),ex5(:),G2H2(23),m3h1x2(:,29),heltab2x2(:,:,76))
  call Hloop_SS_S(ntryL,G2H2(36),ex5(:),G2H2(24),m3h1x2(:,30),heltab2x2(:,:,77))
  call Hotf_5pt_reduction(G2H2(37),RedSet_5(20),mass5set(:,22),  & 
G1H2(165),G1H2(166),G1H2(167),G1H2(168),G1H2(169),G1H2(170),2)
  call HG1shiftOLR(G1H2(166),8,2)
  call Hotf_5pt_reduction(G2H2(38),RedSet_5(20),mass5set(:,23),  & 
G1H2(171),G1H2(172),G1H2(173),G1H2(174),G1H2(175),G1H2(176),2)
  call HG1shiftOLR(G1H2(172),8,2)
  call Hotf_5pt_reduction(G2H2(39),RedSet_5(20),mass5set(:,22),  & 
G1H2(177),G1H2(178),G1H2(179),G1H2(180),G1H2(181),G1H2(182),2)
  call HG1shiftOLR(G1H2(178),8,2)
  call Hotf_5pt_reduction(G2H2(40),RedSet_5(20),mass5set(:,23),  & 
G1H2(183),G1H2(184),G1H2(185),G1H2(186),G1H2(187),G1H2(188),2)
  call HG1shiftOLR(G1H2(184),8,2)
  call Hloop_VS_V(ntryL,G2H2(41),ex5(:),G2H2(25),m3h1x2(:,31),heltab2x2(:,:,78))
  call Hloop_VS_V(ntryL,G2H2(42),ex5(:),G2H2(26),m3h1x2(:,32),heltab2x2(:,:,79))
  call Hotf_5pt_reduction(G2H2(43),RedSet_5(13),mass5set(:,25),  & 
G1H2(189),G1H2(190),G1H2(191),G1H2(192),G1H2(193),G1H2(194),2)
  call HG1shiftOLR(G1H2(190),16,2)
  call Hotf_5pt_reduction(G2H2(44),RedSet_5(13),mass5set(:,26),  & 
G1H2(195),G1H2(196),G1H2(197),G1H2(198),G1H2(199),G1H2(200),2)
  call HG1shiftOLR(G1H2(196),16,2)
  call Hotf_5pt_reduction(G2H2(45),RedSet_5(13),mass5set(:,12),  & 
G1H2(201),G1H2(202),G1H2(203),G1H2(204),G1H2(205),G1H2(206),2)
  call HG1shiftOLR(G1H2(202),16,2)
  call Hloop_ZQ_A(ntryL,G1H2(13),ex3(:),G1H1(1),ngZd,m3h2x1(:,48),heltab2x2(:,:,80))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMB,G2H1(24),n2h1(57))
  call Hloop_SS_S(ntryL,G2H2(47),ex5(:),G2H2(27),m3h1x2(:,33),heltab2x2(:,:,81))
  call Hloop_SS_S(ntryL,G2H2(48),ex5(:),G2H2(28),m3h1x2(:,34),heltab2x2(:,:,82))
  call Hloop_SS_S(ntryL,G2H2(49),ex5(:),G2H2(29),m3h1x2(:,35),heltab2x2(:,:,83))
  call Hloop_VT_S(ntryL,G1H2(25),39,ex5(:),16,G2H2(30),m3h1x2(:,36),heltab2x2(:,:,84))
  call Hotf_5pt_reduction(G2H2(50),RedSet_5(10),mass5set(:,27),  & 
G1H2(13),G1H2(25),G1H2(207),G1H2(208),G1H2(209),G1H2(210),2)
  call HG1shiftOLR(G1H2(25),8,2)
  call Hotf_5pt_reduction(G2H2(51),RedSet_5(10),mass5set(:,13),  & 
G1H2(211),G1H2(212),G1H2(213),G1H2(214),G1H2(215),G1H2(216),2)
  call HG1shiftOLR(G1H2(212),8,2)
  call Hloop_VS_V(ntryL,G1H2(49),ex5(:),G1H2(217),m3h1x2(:,37),heltab2x2(:,:,85))
  call Hloop_VS_V(ntryL,G2H2(53),ex5(:),G2H2(31),m3h1x2(:,38),heltab2x2(:,:,86))
  call Hotf_5pt_reduction(G2H2(54),RedSet_5(14),mass5set(:,26),  & 
G1H2(49),G1H2(218),G1H2(219),G1H2(220),G1H2(221),G1H2(222),2)
  call HG1shiftOLR(G1H2(218),16,2)
  call Hotf_5pt_reduction(G2H2(55),RedSet_5(14),mass5set(:,25),  & 
G1H2(223),G1H2(224),G1H2(225),G1H2(226),G1H2(227),G1H2(228),2)
  call HG1shiftOLR(G1H2(224),16,2)
  call Hotf_5pt_reduction(G2H2(56),RedSet_5(14),mass5set(:,12),  & 
G1H2(229),G1H2(230),G1H2(231),G1H2(232),G1H2(233),G1H2(234),2)
  call HG1shiftOLR(G1H2(230),16,2)
  call Hloop_ZA_Q(ntryL,G1H2(59),ex4(:),G1H1(14),ngZd,m3h2x1(:,49),heltab2x2(:,:,87))
  call Hloop_A_Q(ntryL,G1H1(14),47,nMB,G2H1(25),n2h1(58))
  call Hloop_QA_Z(ntryL,G2H4(19),ex2(:),G2H2(32),ngZn,m3h2x2(:,100),heltab2x4(:,:,148))
  call Hloop_AQ_Z(ntryL,G2H4(20),ex1(:),G2H2(33),ngZn,m3h2x2(:,101),heltab2x4(:,:,149))
  call Hloop_AQ_W(ntryL,G2H4(21),ex1(:),G2H2(34),m3h2x2(:,102),heltab2x4(:,:,150))
  call Hloop_QA_Z(ntryL,G2H4(22),ex2(:),G2H2(35),ngZn,m3h2x2(:,103),heltab2x4(:,:,151))
  call Hloop_QA_W(ntryL,G2H4(23),ex2(:),G2H2(36),m3h2x2(:,104),heltab2x4(:,:,152))
  call Hloop_AQ_Z(ntryL,G2H4(24),ex1(:),G2H2(37),ngZn,m3h2x2(:,105),heltab2x4(:,:,153))
  call Hloop_QA_Z(ntryL,G2H2(58),ex2(:),G2H1(26),ngZn,m3h2x1(:,50),heltab2x2(:,:,88))
  call Hloop_QA_Z(ntryL,G2H2(59),ex2(:),G2H1(27),ngZn,m3h2x1(:,51),heltab2x2(:,:,89))
  call Hloop_AQ_Z(ntryL,G2H2(60),ex1(:),G2H1(28),ngZn,m3h2x1(:,52),heltab2x2(:,:,90))
  call Hloop_AQ_W(ntryL,G2H2(61),ex1(:),G2H1(29),m3h2x1(:,53),heltab2x2(:,:,91))
  call Hloop_AQ_Z(ntryL,G2H2(62),ex1(:),G2H1(30),ngZn,m3h2x1(:,54),heltab2x2(:,:,92))
  call Hloop_AQ_W(ntryL,G2H2(63),ex1(:),G2H1(31),m3h2x1(:,55),heltab2x2(:,:,93))
  call Hloop_VS_V(ntryL,G1H2(76),ex5(:),G1H2(59),m3h1x2(:,39),heltab2x2(:,:,94))
  call Hloop_VS_V(ntryL,G1H2(86),ex5(:),G1H2(76),m3h1x2(:,40),heltab2x2(:,:,95))
  call Hloop_VS_V(ntryL,G1H2(87),ex5(:),G1H2(86),m3h1x2(:,41),heltab2x2(:,:,96))
  call Hloop_QA_Z(ntryL,G2H2(64),ex2(:),G2H1(32),ngZn,m3h2x1(:,56),heltab2x2(:,:,97))
  call Hloop_QA_W(ntryL,G2H2(65),ex2(:),G2H1(33),m3h2x1(:,57),heltab2x2(:,:,98))
  call Hloop_QA_Z(ntryL,G2H2(66),ex2(:),G2H1(34),ngZn,m3h2x1(:,58),heltab2x2(:,:,99))
  call Hloop_QA_W(ntryL,G2H2(67),ex2(:),G2H1(35),m3h2x1(:,59),heltab2x2(:,:,100))
  call Hloop_AQ_Z(ntryL,G2H2(68),ex1(:),G2H1(36),ngZn,m3h2x1(:,60),heltab2x2(:,:,101))
  call Hloop_AQ_Z(ntryL,G2H2(69),ex1(:),G2H1(37),ngZn,m3h2x1(:,61),heltab2x2(:,:,102))
  call Hloop_VT_S(ntryL,G1H2(90),43,ex5(:),16,G2H2(38),m3h1x2(:,42),heltab2x2(:,:,103))
  call Hloop_VT_S(ntryL,G1H2(91),43,ex5(:),16,G2H2(39),m3h1x2(:,43),heltab2x2(:,:,104))
  call Hloop_VS_V(ntryL,G1H2(92),ex5(:),G1H2(87),m3h1x2(:,44),heltab2x2(:,:,105))
  call Hloop_VS_V(ntryL,G1H2(93),ex5(:),G1H2(90),m3h1x2(:,45),heltab2x2(:,:,106))
  call Hloop_VT_S(ntryL,G1H2(95),43,ex5(:),16,G2H2(40),m3h1x2(:,46),heltab2x2(:,:,107))
  call Hloop_VS_V(ntryL,G1H2(96),ex5(:),G1H2(91),m3h1x2(:,47),heltab2x2(:,:,108))
  call Hloop_AQ_S(ntryL,G2H4(25),ex3(:),G2H2(41),ngH,m3h2x2(:,106),heltab2x4(:,:,154))
  call Hloop_AQ_S(ntryL,G2H4(28),ex3(:),G2H2(42),ngH,m3h2x2(:,107),heltab2x4(:,:,155))
  call Hloop_AQ_S(ntryL,G2H4(29),ex3(:),G2H2(43),ngH,m3h2x2(:,108),heltab2x4(:,:,156))
  call Hloop_AQ_S(ntryL,G2H4(30),ex3(:),G2H2(44),ngX,m3h2x2(:,109),heltab2x4(:,:,157))
  call Hloop_AQ_S(ntryL,G2H4(33),ex3(:),G2H2(45),ngX,m3h2x2(:,110),heltab2x4(:,:,158))
  call Hloop_AQ_S(ntryL,G2H4(34),ex3(:),G2H2(47),ngX,m3h2x2(:,111),heltab2x4(:,:,159))
  call Hloop_AQ_S(ntryL,G2H4(35),ex3(:),G2H2(48),ngPtb,m3h2x2(:,112),heltab2x4(:,:,160))
  call Hloop_AQ_S(ntryL,G2H4(38),ex3(:),G2H2(49),ngPtb,m3h2x2(:,113),heltab2x4(:,:,161))
  call Hloop_AQ_S(ntryL,G2H4(39),ex3(:),G2H2(50),ngPtb,m3h2x2(:,114),heltab2x4(:,:,162))
  call Hloop_AQ_V(ntryL,G2H4(40),ex3(:),G2H2(51),m3h2x2(:,115),heltab2x4(:,:,163))
  call Hloop_AQ_V(ntryL,G2H4(43),ex3(:),G2H2(53),m3h2x2(:,116),heltab2x4(:,:,164))
  call Hloop_AQ_V(ntryL,G2H4(44),ex3(:),G2H2(54),m3h2x2(:,117),heltab2x4(:,:,165))
  call Hloop_AQ_Z(ntryL,G2H4(45),ex3(:),G2H2(55),ngZd,m3h2x2(:,118),heltab2x4(:,:,166))
  call Hloop_AQ_Z(ntryL,G2H4(48),ex3(:),G2H2(56),ngZd,m3h2x2(:,119),heltab2x4(:,:,167))
  call Hloop_AQ_Z(ntryL,G2H4(26),ex3(:),G2H2(58),ngZd,m3h2x2(:,120),heltab2x4(:,:,168))
  call Hloop_AQ_W(ntryL,G2H4(31),ex3(:),G2H2(59),m3h2x2(:,121),heltab2x4(:,:,169))
  call Hloop_AQ_W(ntryL,G2H4(46),ex3(:),G2H2(60),m3h2x2(:,122),heltab2x4(:,:,170))
  call Hloop_AQ_W(ntryL,G2H4(36),ex3(:),G2H2(61),m3h2x2(:,123),heltab2x4(:,:,171))
  call Hloop_QA_S(ntryL,G2H4(55),ex4(:),G2H2(62),ngH,m3h2x2(:,124),heltab2x4(:,:,172))
  call Hloop_QA_S(ntryL,G2H4(57),ex4(:),G2H2(63),ngH,m3h2x2(:,125),heltab2x4(:,:,173))
  call Hloop_QA_S(ntryL,G2H4(58),ex4(:),G2H2(64),ngH,m3h2x2(:,126),heltab2x4(:,:,174))
  call Hloop_QA_S(ntryL,G2H4(59),ex4(:),G2H2(65),ngX,m3h2x2(:,127),heltab2x4(:,:,175))
  call Hloop_QA_S(ntryL,G2H4(61),ex4(:),G2H2(66),ngX,m3h2x2(:,128),heltab2x4(:,:,176))
  call Hloop_QA_S(ntryL,G2H4(62),ex4(:),G2H2(67),ngX,m3h2x2(:,129),heltab2x4(:,:,177))
  call Hloop_QA_S(ntryL,G2H4(63),ex4(:),G2H2(68),ngPbt,m3h2x2(:,130),heltab2x4(:,:,178))
  call Hloop_QA_S(ntryL,G2H4(65),ex4(:),G2H2(69),ngPbt,m3h2x2(:,131),heltab2x4(:,:,179))
  call Hloop_QA_S(ntryL,G2H4(66),ex4(:),G2H2(99),ngPbt,m3h2x2(:,132),heltab2x4(:,:,180))
  call Hloop_QA_V(ntryL,G2H4(67),ex4(:),G2H2(100),m3h2x2(:,133),heltab2x4(:,:,181))
  call Hloop_QA_V(ntryL,G2H4(69),ex4(:),G2H2(101),m3h2x2(:,134),heltab2x4(:,:,182))
  call Hloop_QA_V(ntryL,G2H4(70),ex4(:),G2H2(102),m3h2x2(:,135),heltab2x4(:,:,183))
  call Hloop_QA_Z(ntryL,G2H4(71),ex4(:),G2H2(103),ngZd,m3h2x2(:,136),heltab2x4(:,:,184))
  call Hloop_QA_Z(ntryL,G2H4(73),ex4(:),G2H2(104),ngZd,m3h2x2(:,137),heltab2x4(:,:,185))
  call Hloop_QA_Z(ntryL,G2H4(74),ex4(:),G2H2(105),ngZd,m3h2x2(:,138),heltab2x4(:,:,186))
  call Hloop_QA_W(ntryL,G2H4(75),ex4(:),G2H2(106),m3h2x2(:,139),heltab2x4(:,:,187))
  call Hloop_QA_W(ntryL,G2H4(77),ex4(:),G2H2(107),m3h2x2(:,140),heltab2x4(:,:,188))
  call Hloop_QA_W(ntryL,G2H4(78),ex4(:),G2H2(108),m3h2x2(:,141),heltab2x4(:,:,189))
  call Hotf_5pt_reduction(G2H8(2),RedSet_5(9),mass5set(:,9),  & 
G1H8(43),G1H8(44),G1H8(45),G1H8(46),G1H8(47),G1H8(48),8)
  call HG1shiftOLR(G1H8(44),8,8)
  call Hotf_4pt_reduction(G2H8(9),RedSet_4(10),mass4set(:,1),  & 
G1H8(49),G1H8(50),G1H8(51),G1H8(52),G1H8(53),8)
  call HG1shiftOLR(G1H8(50),8,8)
  call Hotf_4pt_reduction(G2H8(10),RedSet_4(37),mass4set(:,1),  & 
G1H8(54),G1H8(55),G1H8(56),G1H8(57),G1H8(58),8)
  call HG1shiftOLR(G1H8(55),11,8)
  call Hotf_5pt_reduction(G2H2(82),RedSet_5(10),mass5set(:,9),  & 
G1H2(92),G1H2(93),G1H2(95),G1H2(96),G1H2(235),G1H2(236),2)
  call HG1shiftOLR(G1H2(93),8,2)
  call Hotf_4pt_reduction(G2H2(84),RedSet_4(10),mass4set(:,1),  & 
G1H2(237),G1H2(238),G1H2(239),G1H2(240),G1H2(241),2)
  call HG1shiftOLR(G1H2(238),8,2)
  call Hotf_4pt_reduction(G2H2(85),RedSet_4(11),mass4set(:,1),  & 
G1H2(242),G1H2(243),G1H2(244),G1H2(245),G1H2(246),2)
  call HG1shiftOLR(G1H2(243),24,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(49),[G1H8(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(54),[G1H8(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(237),[G1H2(235)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(242),[G1H2(236)])
  call Hloop_ZA_Q(ntryL,G1H4(8),ex2(:),G1H2(235),ngZn,m3h2x2(:,142),heltab2x4(:,:,190))
  call Hloop_A_Q(ntryL,G1H2(235),62,0,G2H2(82),n2h2(26))
call HGT_raise_alpha_OLR(G1H4(44),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_ZQ_A(ntryL,G1H4(44),ex1(:),G1H2(236),ngZn,m3h2x2(:,143),heltab2x4(:,:,191))
  call Hloop_ZA_Q(ntryL,G1H4(47),ex2(:),G1H2(235),ngZn,m3h2x2(:,144),heltab2x4(:,:,192))
  call Hloop_A_Q(ntryL,G1H2(235),62,0,G2H2(84),n2h2(27))
  call Hloop_ZA_Q(ntryL,G1H4(10),ex2(:),G1H2(235),ngZn,m3h2x2(:,145),heltab2x4(:,:,193))
  call Hloop_A_Q(ntryL,G1H2(235),62,0,G2H2(85),n2h2(28))
  call Hloop_ZQ_A(ntryL,G1H4(48),ex1(:),G1H2(235),ngZn,m3h2x2(:,146),heltab2x4(:,:,194))
  call Hloop_Q_A(ntryL,G1H2(235),61,0,G2H2(109),n2h2(29))
call HGT_raise_alpha_OLR(G1H4(11),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(11),2,5,4)
  call Hloop_ZA_Q(ntryL,G1H4(11),ex2(:),G1H2(235),ngZn,m3h2x2(:,147),heltab2x4(:,:,195))
  call Hloop_ZQ_A(ntryL,G1H4(50),ex1(:),G1H2(247),ngZn,m3h2x2(:,148),heltab2x4(:,:,196))
  call Hloop_Q_A(ntryL,G1H2(247),61,0,G2H2(110),n2h2(30))
  call Hloop_ZQ_A(ntryL,G1H4(52),ex1(:),G1H2(247),ngZn,m3h2x2(:,149),heltab2x4(:,:,197))
  call Hloop_Q_A(ntryL,G1H2(247),61,0,G2H2(111),n2h2(31))
  call Hloop_WQ_A(ntryL,G1H4(13),ex1(:),G1H2(247),m3h2x2(:,150),heltab2x4(:,:,198))
  call Hloop_Q_A(ntryL,G1H2(247),61,0,G2H2(112),n2h2(32))
call HGT_raise_alpha_OLR(G1H4(53),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(53),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(53),ex2(:),G1H2(247),m3h2x2(:,151),heltab2x4(:,:,199))
  call Hloop_WQ_A(ntryL,G1H4(15),ex1(:),G1H2(248),m3h2x2(:,152),heltab2x4(:,:,200))
  call Hloop_Q_A(ntryL,G1H2(248),61,0,G2H2(113),n2h2(33))
  call Hloop_WQ_A(ntryL,G1H4(55),ex1(:),G1H2(248),m3h2x2(:,153),heltab2x4(:,:,201))
  call Hloop_Q_A(ntryL,G1H2(248),61,0,G2H2(114),n2h2(34))
  call Hloop_WQ_A(ntryL,G1H2(97),ex3(:),G1H1(25),m3h2x1(:,62),heltab2x2(:,:,109))
  call Hloop_Q_A(ntryL,G1H1(25),47,nMT,G2H1(38),n2h1(59))
call HGT_OLR(G1H2(3),1,1,2)
call HGT_invQ_OLR(G1H2(3),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(3),-16,nMT,G2H2(115),n2h2(35))
  call Hloop_AS_Q(ntryL,G2H2(115),ex5(:),G2H2(116),ngH,m3h1x2(:,48),heltab2x2(:,:,110))
  call Hloop_WQ_A(ntryL,G1H2(14),ex3(:),G1H1(7),m3h2x1(:,63),heltab2x2(:,:,111))
  call Hloop_Q_A(ntryL,G1H1(7),47,nMT,G2H1(39),n2h1(60))
  call Hloop_WQ_A(ntryL,G1H2(11),ex3(:),G1H1(26),m3h2x1(:,64),heltab2x2(:,:,112))
  call Hloop_Q_A(ntryL,G1H1(26),47,nMT,G2H1(40),n2h1(61))
  call Hloop_WA_Q(ntryL,G1H2(15),ex4(:),G1H1(19),m3h2x1(:,65),heltab2x2(:,:,113))
  call Hloop_A_Q(ntryL,G1H1(19),47,nMT,G2H1(41),n2h1(62))
call HGT_OLR(G1H2(17),1,1,2)
call HGT_invQ_OLR(G1H2(17),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(17),-16,nMT,G2H2(115),n2h2(36))
  call Hloop_QS_A(ntryL,G2H2(115),ex5(:),G2H2(117),ngH,m3h1x2(:,49),heltab2x2(:,:,114))
  call Hloop_WA_Q(ntryL,G1H2(23),ex4(:),G1H1(31),m3h2x1(:,66),heltab2x2(:,:,115))
  call Hloop_A_Q(ntryL,G1H1(31),47,nMT,G2H1(42),n2h1(63))
  call Hloop_WA_Q(ntryL,G1H2(27),ex4(:),G1H1(37),m3h2x1(:,67),heltab2x2(:,:,116))
  call Hloop_A_Q(ntryL,G1H1(37),47,nMT,G2H1(43),n2h1(64))
  call Hloop_VT_S(ntryL,G1H2(29),39,ex5(:),16,G2H2(115),m3h1x2(:,50),heltab2x2(:,:,117))
call HGT_OLR(G1H2(33),1,1,2)
call HGT_invQ_OLR(G1H2(33),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(33),-8,nMT,G2H2(118),n2h2(37))
  call Hloop_QA_S(ntryL,G2H2(118),ex4(:),G2H1(44),ngPbt,m3h2x1(:,68),heltab2x2(:,:,118))
  call Hloop_VT_S(ntryL,G1H2(39),39,ex5(:),16,G2H2(118),m3h1x2(:,51),heltab2x2(:,:,119))
  call Hloop_VT_S(ntryL,G1H2(45),39,ex5(:),16,G2H2(119),m3h1x2(:,52),heltab2x2(:,:,120))
  call Hloop_SQ_A(ntryL,G1H2(51),ex3(:),G1H1(32),ngH,m3h2x1(:,69),heltab2x2(:,:,121))
  call Hloop_Q_A(ntryL,G1H1(32),47,nMB,G2H1(45),n2h1(65))
call HGT_OLR(G1H2(1),1,1,2)
call HGT_invQ_OLR(G1H2(1),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(1),-16,nMB,G2H2(120),n2h2(38))
  call Hloop_AS_Q(ntryL,G2H2(120),ex5(:),G2H2(121),ngH,m3h1x2(:,53),heltab2x2(:,:,122))
  call Hloop_SQ_A(ntryL,G1H2(38),ex3(:),G1H1(20),ngH,m3h2x1(:,70),heltab2x2(:,:,123))
  call Hloop_Q_A(ntryL,G1H1(20),47,nMB,G2H1(46),n2h1(66))
  call Hloop_SQ_A(ntryL,G1H2(58),ex3(:),G1H1(8),ngH,m3h2x1(:,71),heltab2x2(:,:,124))
  call Hloop_Q_A(ntryL,G1H1(8),47,nMB,G2H1(47),n2h1(67))
  call Hloop_SQ_A(ntryL,G1H2(50),ex3(:),G1H1(2),ngX,m3h2x1(:,72),heltab2x2(:,:,125))
  call Hloop_Q_A(ntryL,G1H1(2),47,nMB,G2H1(48),n2h1(68))
call HGT_OLR(G1H2(65),1,1,2)
call HGT_invQ_OLR(G1H2(65),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(65),-16,nMB,G2H2(120),n2h2(39))
  call Hloop_AS_Q(ntryL,G2H2(120),ex5(:),G2H2(122),ngH,m3h1x2(:,54),heltab2x2(:,:,126))
  call Hloop_SQ_A(ntryL,G1H2(4),ex3(:),G1H1(13),ngX,m3h2x1(:,73),heltab2x2(:,:,127))
  call Hloop_Q_A(ntryL,G1H1(13),47,nMB,G2H1(49),n2h1(69))
  call Hloop_SQ_A(ntryL,G1H2(41),ex3(:),G1H1(1),ngX,m3h2x1(:,74),heltab2x2(:,:,128))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMB,G2H1(50),n2h1(70))
  call Hloop_SQ_A(ntryL,G1H2(89),ex3(:),G1H1(14),ngPtb,m3h2x1(:,75),heltab2x2(:,:,129))
  call Hloop_Q_A(ntryL,G1H1(14),47,nMT,G2H1(51),n2h1(71))
call HGT_OLR(G1H2(10),1,1,2)
call HGT_invQ_OLR(G1H2(10),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(10),-16,nMT,G2H2(120),n2h2(40))
  call Hloop_AS_Q(ntryL,G2H2(120),ex5(:),G2H2(123),ngH,m3h1x2(:,55),heltab2x2(:,:,130))
  call Hloop_SQ_A(ntryL,G1H2(47),ex3(:),G1H1(25),ngPtb,m3h2x1(:,76),heltab2x2(:,:,131))
  call Hloop_Q_A(ntryL,G1H1(25),47,nMT,G2H1(52),n2h1(72))
  call Hloop_SQ_A(ntryL,G1H2(83),ex3(:),G1H1(7),ngPtb,m3h2x1(:,77),heltab2x2(:,:,132))
  call Hloop_Q_A(ntryL,G1H1(7),47,nMT,G2H1(53),n2h1(73))
  call Hloop_VQ_A(ntryL,G1H2(22),ex3(:),G1H1(26),m3h2x1(:,78),heltab2x2(:,:,133))
  call Hloop_Q_A(ntryL,G1H1(26),47,nMB,G2H1(54),n2h1(74))
call HGT_OLR(G1H2(84),1,1,2)
call HGT_invQ_OLR(G1H2(84),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(84),-16,nMB,G2H2(120),n2h2(41))
  call Hloop_AS_Q(ntryL,G2H2(120),ex5(:),G2H2(124),ngH,m3h1x2(:,56),heltab2x2(:,:,134))
  call Hloop_VQ_A(ntryL,G1H2(85),ex3(:),G1H1(19),m3h2x1(:,79),heltab2x2(:,:,135))
  call Hloop_Q_A(ntryL,G1H1(19),47,nMB,G2H1(55),n2h1(75))
  call Hloop_VQ_A(ntryL,G1H2(34),ex3(:),G1H1(31),m3h2x1(:,80),heltab2x2(:,:,136))
  call Hloop_Q_A(ntryL,G1H1(31),47,nMB,G2H1(56),n2h1(76))
  call Hloop_ZQ_A(ntryL,G1H2(94),ex3(:),G1H1(37),ngZd,m3h2x1(:,81),heltab2x2(:,:,137))
  call Hloop_Q_A(ntryL,G1H1(37),47,nMB,G2H1(57),n2h1(77))
call HGT_OLR(G1H2(40),1,1,2)
call HGT_invQ_OLR(G1H2(40),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(40),-16,nMB,G2H2(120),n2h2(42))
  call Hloop_AS_Q(ntryL,G2H2(120),ex5(:),G2H2(125),ngH,m3h1x2(:,57),heltab2x2(:,:,138))
  call Hloop_ZQ_A(ntryL,G1H2(71),ex3(:),G1H1(32),ngZd,m3h2x1(:,82),heltab2x2(:,:,139))
  call Hloop_Q_A(ntryL,G1H1(32),47,nMB,G2H1(58),n2h1(78))
  call Hloop_ZQ_A(ntryL,G1H2(52),ex3(:),G1H1(20),ngZd,m3h2x1(:,83),heltab2x2(:,:,140))
  call Hloop_Q_A(ntryL,G1H1(20),47,nMB,G2H1(59),n2h1(79))
  call Hloop_WQ_A(ntryL,G1H2(98),ex3(:),G1H1(8),m3h2x1(:,84),heltab2x2(:,:,141))
  call Hloop_Q_A(ntryL,G1H1(8),47,nMT,G2H1(60),n2h1(80))
call HGT_OLR(G1H2(99),1,1,2)
call HGT_invQ_OLR(G1H2(99),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(99),-16,nMT,G2H2(120),n2h2(43))
  call Hloop_AS_Q(ntryL,G2H2(120),ex5(:),G2H2(126),ngH,m3h1x2(:,58),heltab2x2(:,:,142))
  call Hloop_WQ_A(ntryL,G1H2(102),ex3(:),G1H1(2),m3h2x1(:,85),heltab2x2(:,:,143))
  call Hloop_Q_A(ntryL,G1H1(2),47,nMT,G2H1(61),n2h1(81))
  call Hloop_WQ_A(ntryL,G1H2(103),ex3(:),G1H1(13),m3h2x1(:,86),heltab2x2(:,:,144))
  call Hloop_Q_A(ntryL,G1H1(13),47,nMT,G2H1(62),n2h1(82))
  call Hloop_AZ_Q(ntryL,G1H4(16),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,1),heltab2x4(:,:,202))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMB,G2H1(63),n2h1(83))
call HGT_OLR(G1H4(56),1,1,4)
call HGT_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(56),-16,nMB,G2H4(4),n2h4(169))
  call Hloop_QS_A(ntryL,G2H4(4),ex5(:),G2H4(5),ngH,m3h1x4(:,49),heltab2x4(:,:,203))
  call Hloop_AZ_Q(ntryL,G1H4(59),wf4(:,1),G1H1(14),ngZd,m3h4x1(:,2),heltab2x4(:,:,204))
  call Hloop_A_Q(ntryL,G1H1(14),47,nMB,G2H1(64),n2h1(84))
  call Hloop_AZ_Q(ntryL,G1H4(18),wf4(:,1),G1H1(25),ngZd,m3h4x1(:,3),heltab2x4(:,:,205))
  call Hloop_A_Q(ntryL,G1H1(25),47,nMB,G2H1(65),n2h1(85))
  call Hloop_AZ_Q(ntryL,G1H4(60),wf4(:,1),G1H1(7),ngZd,m3h4x1(:,4),heltab2x4(:,:,206))
  call Hloop_A_Q(ntryL,G1H1(7),47,nMB,G2H1(66),n2h1(86))
call HGT_OLR(G1H4(19),1,1,4)
call HGT_invQ_OLR(G1H4(19),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(19),-16,nMB,G2H4(14),n2h4(170))
  call Hloop_QS_A(ntryL,G2H4(14),ex5(:),G2H4(15),ngH,m3h1x4(:,50),heltab2x4(:,:,207))
  call Hloop_AZ_Q(ntryL,G1H4(62),wf4(:,1),G1H1(26),ngZd,m3h4x1(:,5),heltab2x4(:,:,208))
  call Hloop_A_Q(ntryL,G1H1(26),47,nMB,G2H1(67),n2h1(87))
  call Hloop_AZ_Q(ntryL,G1H4(64),wf4(:,1),G1H1(19),ngZd,m3h4x1(:,6),heltab2x4(:,:,209))
  call Hloop_A_Q(ntryL,G1H1(19),47,nMB,G2H1(68),n2h1(88))
  call Hloop_AZ_Q(ntryL,G1H4(21),wf4(:,1),G1H1(31),ngZu,m3h4x1(:,7),heltab2x4(:,:,210))
  call Hloop_A_Q(ntryL,G1H1(31),47,nMT,G2H1(69),n2h1(89))
call HGT_OLR(G1H4(65),1,1,4)
call HGT_invQ_OLR(G1H4(65),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(65),-16,nMT,G2H4(2),n2h4(171))
  call Hloop_QS_A(ntryL,G2H4(2),ex5(:),G2H4(3),ngH,m3h1x4(:,51),heltab2x4(:,:,211))
  call Hloop_AZ_Q(ntryL,G1H4(23),wf4(:,1),G1H1(37),ngZu,m3h4x1(:,8),heltab2x4(:,:,212))
  call Hloop_A_Q(ntryL,G1H1(37),47,nMT,G2H1(70),n2h1(90))
  call Hloop_AZ_Q(ntryL,G1H4(67),wf4(:,1),G1H1(32),ngZu,m3h4x1(:,9),heltab2x4(:,:,213))
  call Hloop_A_Q(ntryL,G1H1(32),47,nMT,G2H1(71),n2h1(91))
  call Hloop_AZ_Q(ntryL,G1H4(24),wf4(:,1),G1H1(20),ngZd,m3h4x1(:,10),heltab2x4(:,:,214))
  call Hloop_A_Q(ntryL,G1H1(20),47,nMB,G2H1(72),n2h1(92))
call HGT_OLR(G1H4(68),1,1,4)
call HGT_invQ_OLR(G1H4(68),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(68),-16,nMB,G2H4(6),n2h4(172))
  call Hloop_QS_A(ntryL,G2H4(6),ex5(:),G2H4(7),ngH,m3h1x4(:,52),heltab2x4(:,:,215))
  call Hloop_AZ_Q(ntryL,G1H4(71),wf4(:,1),G1H1(8),ngZd,m3h4x1(:,11),heltab2x4(:,:,216))
  call Hloop_A_Q(ntryL,G1H1(8),47,nMB,G2H1(73),n2h1(93))
  call Hloop_AZ_Q(ntryL,G1H4(26),wf4(:,1),G1H1(2),ngZd,m3h4x1(:,12),heltab2x4(:,:,217))
  call Hloop_A_Q(ntryL,G1H1(2),47,nMB,G2H1(74),n2h1(94))
  call Hloop_SA_Q(ntryL,G1H2(104),ex4(:),G1H1(13),ngH,m3h2x1(:,87),heltab2x2(:,:,145))
  call Hloop_A_Q(ntryL,G1H1(13),47,nMB,G2H1(75),n2h1(95))
call HGT_OLR(G1H2(105),1,1,2)
call HGT_invQ_OLR(G1H2(105),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(105),-16,nMB,G2H2(120),n2h2(44))
  call Hloop_QS_A(ntryL,G2H2(120),ex5(:),G2H2(127),ngH,m3h1x2(:,59),heltab2x2(:,:,146))
  call Hloop_SA_Q(ntryL,G1H2(108),ex4(:),G1H1(1),ngH,m3h2x1(:,88),heltab2x2(:,:,147))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMB,G2H1(76),n2h1(96))
  call Hloop_SA_Q(ntryL,G1H2(109),ex4(:),G1H1(14),ngH,m3h2x1(:,89),heltab2x2(:,:,148))
  call Hloop_A_Q(ntryL,G1H1(14),47,nMB,G2H1(77),n2h1(97))
  call Hloop_SA_Q(ntryL,G1H2(110),ex4(:),G1H1(25),ngX,m3h2x1(:,90),heltab2x2(:,:,149))
  call Hloop_A_Q(ntryL,G1H1(25),47,nMB,G2H1(78),n2h1(98))
call HGT_OLR(G1H2(111),1,1,2)
call HGT_invQ_OLR(G1H2(111),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(111),-16,nMB,G2H2(120),n2h2(45))
  call Hloop_QS_A(ntryL,G2H2(120),ex5(:),G2H2(128),ngH,m3h1x2(:,60),heltab2x2(:,:,150))
  call Hloop_SA_Q(ntryL,G1H2(114),ex4(:),G1H1(7),ngX,m3h2x1(:,91),heltab2x2(:,:,151))
  call Hloop_A_Q(ntryL,G1H1(7),47,nMB,G2H1(79),n2h1(99))
  call Hloop_SA_Q(ntryL,G1H2(115),ex4(:),G1H1(26),ngX,m3h2x1(:,92),heltab2x2(:,:,152))
  call Hloop_A_Q(ntryL,G1H1(26),47,nMB,G2H1(80),n2h1(100))
  call Hloop_SA_Q(ntryL,G1H2(116),ex4(:),G1H1(19),ngPbt,m3h2x1(:,93),heltab2x2(:,:,153))
  call Hloop_A_Q(ntryL,G1H1(19),47,nMT,G2H1(81),n2h1(101))
call HGT_OLR(G1H2(117),1,1,2)
call HGT_invQ_OLR(G1H2(117),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(117),-16,nMT,G2H2(120),n2h2(46))
  call Hloop_QS_A(ntryL,G2H2(120),ex5(:),G2H2(129),ngH,m3h1x2(:,61),heltab2x2(:,:,154))
  call Hloop_SA_Q(ntryL,G1H2(120),ex4(:),G1H1(31),ngPbt,m3h2x1(:,94),heltab2x2(:,:,155))
  call Hloop_A_Q(ntryL,G1H1(31),47,nMT,G2H1(82),n2h1(102))
  call Hloop_SA_Q(ntryL,G1H2(121),ex4(:),G1H1(37),ngPbt,m3h2x1(:,95),heltab2x2(:,:,156))
  call Hloop_A_Q(ntryL,G1H1(37),47,nMT,G2H1(83),n2h1(103))
  call Hloop_VA_Q(ntryL,G1H2(122),ex4(:),G1H1(32),m3h2x1(:,96),heltab2x2(:,:,157))
  call Hloop_A_Q(ntryL,G1H1(32),47,nMB,G2H1(84),n2h1(104))
call HGT_OLR(G1H2(123),1,1,2)
call HGT_invQ_OLR(G1H2(123),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(123),-16,nMB,G2H2(120),n2h2(47))
  call Hloop_QS_A(ntryL,G2H2(120),ex5(:),G2H2(130),ngH,m3h1x2(:,62),heltab2x2(:,:,158))
  call Hloop_VA_Q(ntryL,G1H2(126),ex4(:),G1H1(20),m3h2x1(:,97),heltab2x2(:,:,159))
  call Hloop_A_Q(ntryL,G1H1(20),47,nMB,G2H1(85),n2h1(105))
  call Hloop_VA_Q(ntryL,G1H2(127),ex4(:),G1H1(8),m3h2x1(:,98),heltab2x2(:,:,160))
  call Hloop_A_Q(ntryL,G1H1(8),47,nMB,G2H1(86),n2h1(106))
  call Hloop_ZA_Q(ntryL,G1H2(128),ex4(:),G1H1(2),ngZd,m3h2x1(:,99),heltab2x2(:,:,161))
  call Hloop_A_Q(ntryL,G1H1(2),47,nMB,G2H1(87),n2h1(107))
call HGT_OLR(G1H2(129),1,1,2)
call HGT_invQ_OLR(G1H2(129),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(129),-16,nMB,G2H2(120),n2h2(48))
  call Hloop_QS_A(ntryL,G2H2(120),ex5(:),G2H2(131),ngH,m3h1x2(:,63),heltab2x2(:,:,162))
  call Hloop_ZA_Q(ntryL,G1H2(132),ex4(:),G1H1(13),ngZd,m3h2x1(:,100),heltab2x2(:,:,163))
  call Hloop_A_Q(ntryL,G1H1(13),47,nMB,G2H1(88),n2h1(108))
  call Hloop_ZA_Q(ntryL,G1H2(133),ex4(:),G1H1(1),ngZd,m3h2x1(:,101),heltab2x2(:,:,164))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMB,G2H1(89),n2h1(109))
  call Hloop_WA_Q(ntryL,G1H2(134),ex4(:),G1H1(14),m3h2x1(:,102),heltab2x2(:,:,165))
  call Hloop_A_Q(ntryL,G1H1(14),47,nMT,G2H1(90),n2h1(110))
call HGT_OLR(G1H2(135),1,1,2)
call HGT_invQ_OLR(G1H2(135),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(135),-16,nMT,G2H2(120),n2h2(49))
  call Hloop_QS_A(ntryL,G2H2(120),ex5(:),G2H2(132),ngH,m3h1x2(:,64),heltab2x2(:,:,166))
  call Hloop_WA_Q(ntryL,G1H2(138),ex4(:),G1H1(25),m3h2x1(:,103),heltab2x2(:,:,167))
  call Hloop_A_Q(ntryL,G1H1(25),47,nMT,G2H1(91),n2h1(111))
  call Hloop_WA_Q(ntryL,G1H2(139),ex4(:),G1H1(7),m3h2x1(:,104),heltab2x2(:,:,168))
  call Hloop_A_Q(ntryL,G1H1(7),47,nMT,G2H1(92),n2h1(112))
  call Hloop_QZ_A(ntryL,G1H4(72),wf4(:,1),G1H1(26),ngZd,m3h4x1(:,13),heltab2x4(:,:,218))
  call Hloop_Q_A(ntryL,G1H1(26),47,nMB,G2H1(93),n2h1(113))
call HGT_OLR(G1H4(27),1,1,4)
call HGT_invQ_OLR(G1H4(27),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(27),-16,nMB,G2H4(10),n2h4(173))
  call Hloop_AS_Q(ntryL,G2H4(10),ex5(:),G2H4(11),ngH,m3h1x4(:,53),heltab2x4(:,:,219))
  call Hloop_QZ_A(ntryL,G1H4(74),wf4(:,1),G1H1(19),ngZd,m3h4x1(:,14),heltab2x4(:,:,220))
  call Hloop_Q_A(ntryL,G1H1(19),47,nMB,G2H1(94),n2h1(114))
  call Hloop_QZ_A(ntryL,G1H4(76),wf4(:,1),G1H1(31),ngZd,m3h4x1(:,15),heltab2x4(:,:,221))
  call Hloop_Q_A(ntryL,G1H1(31),47,nMB,G2H1(95),n2h1(115))
  call Hloop_QZ_A(ntryL,G1H4(29),wf4(:,1),G1H1(37),ngZd,m3h4x1(:,16),heltab2x4(:,:,222))
  call Hloop_Q_A(ntryL,G1H1(37),47,nMB,G2H1(96),n2h1(116))
call HGT_OLR(G1H4(77),1,1,4)
call HGT_invQ_OLR(G1H4(77),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(77),-16,nMB,G2H4(49),n2h4(174))
  call Hloop_AS_Q(ntryL,G2H4(49),ex5(:),G2H4(50),ngH,m3h1x4(:,54),heltab2x4(:,:,223))
  call Hloop_QZ_A(ntryL,G1H4(31),wf4(:,1),G1H1(32),ngZd,m3h4x1(:,17),heltab2x4(:,:,224))
  call Hloop_Q_A(ntryL,G1H1(32),47,nMB,G2H1(97),n2h1(117))
  call Hloop_QZ_A(ntryL,G1H4(79),wf4(:,1),G1H1(20),ngZd,m3h4x1(:,18),heltab2x4(:,:,225))
  call Hloop_Q_A(ntryL,G1H1(20),47,nMB,G2H1(98),n2h1(118))
  call Hloop_QZ_A(ntryL,G1H4(103),wf4(:,1),G1H1(8),ngZu,m3h4x1(:,19),heltab2x4(:,:,226))
  call Hloop_Q_A(ntryL,G1H1(8),47,nMT,G2H1(99),n2h1(119))
call HGT_OLR(G1H4(80),1,1,4)
call HGT_invQ_OLR(G1H4(80),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(80),-16,nMT,G2H4(51),n2h4(175))
  call Hloop_AS_Q(ntryL,G2H4(51),ex5(:),G2H4(52),ngH,m3h1x4(:,55),heltab2x4(:,:,227))
  call Hloop_QZ_A(ntryL,G1H4(83),wf4(:,1),G1H1(2),ngZu,m3h4x1(:,20),heltab2x4(:,:,228))
  call Hloop_Q_A(ntryL,G1H1(2),47,nMT,G2H1(100),n2h1(120))
  call Hloop_QZ_A(ntryL,G1H4(34),wf4(:,1),G1H1(13),ngZu,m3h4x1(:,21),heltab2x4(:,:,229))
  call Hloop_Q_A(ntryL,G1H1(13),47,nMT,G2H1(101),n2h1(121))
  call Hloop_QZ_A(ntryL,G1H4(84),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,22),heltab2x4(:,:,230))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMB,G2H1(102),n2h1(122))
call HGT_OLR(G1H4(1),1,1,4)
call HGT_invQ_OLR(G1H4(1),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(1),-16,nMB,G2H4(53),n2h4(176))
  call Hloop_AS_Q(ntryL,G2H4(53),ex5(:),G2H4(54),ngH,m3h1x4(:,56),heltab2x4(:,:,231))
  call Hloop_QZ_A(ntryL,G1H4(86),wf4(:,1),G1H1(14),ngZd,m3h4x1(:,23),heltab2x4(:,:,232))
  call Hloop_Q_A(ntryL,G1H1(14),47,nMB,G2H1(103),n2h1(123))
  call Hloop_QZ_A(ntryL,G1H4(88),wf4(:,1),G1H1(25),ngZd,m3h4x1(:,24),heltab2x4(:,:,233))
  call Hloop_Q_A(ntryL,G1H1(25),47,nMB,G2H1(104),n2h1(124))
  call Hloop_VT_S(ntryL,G1H2(140),43,ex5(:),16,G2H2(120),m3h1x2(:,65),heltab2x2(:,:,169))
call HGT_OLR(G1H2(141),1,1,2)
call HGT_invQ_OLR(G1H2(141),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(141),-4,nMB,G2H2(133),n2h2(50))
  call Hloop_AQ_S(ntryL,G2H2(133),ex3(:),G2H1(105),ngX,m3h2x1(:,105),heltab2x2(:,:,170))
  call Hloop_VT_S(ntryL,G1H2(144),43,ex5(:),16,G2H2(133),m3h1x2(:,66),heltab2x2(:,:,171))
  call Hloop_VT_S(ntryL,G1H2(145),43,ex5(:),16,G2H2(134),m3h1x2(:,67),heltab2x2(:,:,172))
  call Hloop_VT_S(ntryL,G1H2(146),43,ex5(:),16,G2H2(135),m3h1x2(:,68),heltab2x2(:,:,173))
call HGT_OLR(G1H2(147),1,1,2)
call HGT_invQ_OLR(G1H2(147),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(147),-4,nMT,G2H2(136),n2h2(51))
  call Hloop_AQ_S(ntryL,G2H2(136),ex3(:),G2H1(106),ngPtb,m3h2x1(:,106),heltab2x2(:,:,174))
  call Hloop_VT_S(ntryL,G1H2(150),43,ex5(:),16,G2H2(136),m3h1x2(:,69),heltab2x2(:,:,175))
  call Hloop_VT_S(ntryL,G1H2(151),43,ex5(:),16,G2H2(137),m3h1x2(:,70),heltab2x2(:,:,176))
  call Hloop_ST_V(ntryL,G1H2(152),43,ex5(:),16,G2H2(138),m3h1x2(:,71),heltab2x2(:,:,177))
call HGT_OLR(G1H2(153),1,1,2)
call HGT_invQ_OLR(G1H2(153),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(153),-4,nMB,G2H2(139),n2h2(52))
  call Hloop_AQ_Z(ntryL,G2H2(139),ex3(:),G2H1(107),ngZd,m3h2x1(:,107),heltab2x2(:,:,178))
  call Hloop_ST_V(ntryL,G1H2(156),43,ex5(:),16,G2H2(139),m3h1x2(:,72),heltab2x2(:,:,179))
  call Hloop_ST_V(ntryL,G1H2(157),43,ex5(:),16,G2H2(140),m3h1x2(:,73),heltab2x2(:,:,180))
  call Hloop_ST_V(ntryL,G1H2(158),43,ex5(:),16,G2H2(141),m3h1x2(:,74),heltab2x2(:,:,181))
call HGT_OLR(G1H2(159),1,1,2)
call HGT_invQ_OLR(G1H2(159),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(159),-4,nMT,G2H2(142),n2h2(53))
  call Hloop_AQ_W(ntryL,G2H2(142),ex3(:),G2H1(108),m3h2x1(:,108),heltab2x2(:,:,182))
  call Hloop_ST_V(ntryL,G1H2(162),43,ex5(:),16,G2H2(142),m3h1x2(:,75),heltab2x2(:,:,183))
  call Hloop_ST_V(ntryL,G1H2(163),43,ex5(:),16,G2H2(143),m3h1x2(:,76),heltab2x2(:,:,184))
  call Hloop_SV_T(ntryL,G1H8(25),52,wf4(:,1),3,G2H2(144),m3h4x2(:,40),heltab2x8(:,:,144))
call HGT_OLR(G1H8(26),1,1,8)
call HGT_invQ_OLR(G1H8(26),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(26),-8,nMB,G2H8(5),n2h8(24))
  call Hloop_QA_S(ntryL,G2H8(5),ex4(:),G2H4(1),ngH,m3h2x4(:,81),heltab2x8(:,:,145))
  call Hloop_SV_T(ntryL,G1H8(29),52,wf4(:,1),3,G2H2(145),m3h4x2(:,41),heltab2x8(:,:,146))
  call Hloop_SV_T(ntryL,G1H8(30),52,wf4(:,1),3,G2H2(146),m3h4x2(:,42),heltab2x8(:,:,147))
  call Hloop_TV_S(ntryL,G1H8(31),52,wf4(:,1),3,G2H2(147),m3h4x2(:,43),heltab2x8(:,:,148))
call HGT_OLR(G1H8(32),1,1,8)
call HGT_invQ_OLR(G1H8(32),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(32),-8,nMT,G2H8(6),n2h8(25))
  call Hloop_QA_S(ntryL,G2H8(6),ex4(:),G2H4(9),ngPbt,m3h2x4(:,82),heltab2x8(:,:,149))
  call Hloop_TV_S(ntryL,G1H8(35),52,wf4(:,1),3,G2H2(148),m3h4x2(:,44),heltab2x8(:,:,150))
  call Hloop_TV_S(ntryL,G1H8(36),52,wf4(:,1),3,G2H2(149),m3h4x2(:,45),heltab2x8(:,:,151))
  call Hloop_UV_W(ntryL,G1H8(37),52,wf4(:,1),3,G2H2(150),m3h4x2(:,46),heltab2x8(:,:,152))
call HGT_OLR(G1H8(38),1,1,8)
call HGT_invQ_OLR(G1H8(38),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(38),-8,nMT,G2H8(3),n2h8(26))
  call Hloop_QA_W(ntryL,G2H8(3),ex4(:),G2H4(12),m3h2x4(:,83),heltab2x8(:,:,153))
  call Hloop_UV_W(ntryL,G1H8(41),52,wf4(:,1),3,G2H2(151),m3h4x2(:,47),heltab2x8(:,:,154))
  call Hloop_UV_W(ntryL,G1H8(42),52,wf4(:,1),3,G2H2(152),m3h4x2(:,48),heltab2x8(:,:,155))
  call Hloop_ST_V(ntryL,G1H2(165),39,ex5(:),16,G2H2(153),m3h1x2(:,77),heltab2x2(:,:,185))
call HGT_OLR(G1H2(166),1,1,2)
call HGT_invQ_OLR(G1H2(166),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(166),-8,nMB,G2H2(154),n2h2(54))
  call Hloop_QA_Z(ntryL,G2H2(154),ex4(:),G2H1(109),ngZd,m3h2x1(:,109),heltab2x2(:,:,186))
  call Hloop_ST_V(ntryL,G1H2(169),39,ex5(:),16,G2H2(154),m3h1x2(:,78),heltab2x2(:,:,187))
  call Hloop_ST_V(ntryL,G1H2(170),39,ex5(:),16,G2H2(155),m3h1x2(:,79),heltab2x2(:,:,188))
  call Hloop_ST_V(ntryL,G1H2(171),39,ex5(:),16,G2H2(156),m3h1x2(:,80),heltab2x2(:,:,189))
call HGT_OLR(G1H2(172),1,1,2)
call HGT_invQ_OLR(G1H2(172),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(172),-8,nMT,G2H2(157),n2h2(55))
  call Hloop_QA_W(ntryL,G2H2(157),ex4(:),G2H1(110),m3h2x1(:,110),heltab2x2(:,:,190))
  call Hloop_ST_V(ntryL,G1H2(175),39,ex5(:),16,G2H2(157),m3h1x2(:,81),heltab2x2(:,:,191))
  call Hloop_ST_V(ntryL,G1H2(176),39,ex5(:),16,G2H2(158),m3h1x2(:,82),heltab2x2(:,:,192))
  call Hloop_VT_S(ntryL,G1H2(177),39,ex5(:),16,G2H2(159),m3h1x2(:,83),heltab2x2(:,:,193))
call HGT_OLR(G1H2(178),1,1,2)
call HGT_invQ_OLR(G1H2(178),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(178),-8,nMB,G2H2(160),n2h2(56))
  call Hloop_QA_S(ntryL,G2H2(160),ex4(:),G2H1(111),ngX,m3h2x1(:,111),heltab2x2(:,:,194))
  call Hloop_VT_S(ntryL,G1H2(181),39,ex5(:),16,G2H2(160),m3h1x2(:,84),heltab2x2(:,:,195))
  call Hloop_VT_S(ntryL,G1H2(182),39,ex5(:),16,G2H2(161),m3h1x2(:,85),heltab2x2(:,:,196))
  call Hloop_VT_S(ntryL,G1H2(183),39,ex5(:),16,G2H2(162),m3h1x2(:,86),heltab2x2(:,:,197))
call HGT_OLR(G1H2(184),1,1,2)
call HGT_invQ_OLR(G1H2(184),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(184),-8,nMT,G2H2(163),n2h2(57))
  call Hloop_QA_S(ntryL,G2H2(163),ex4(:),G2H1(112),ngPbt,m3h2x1(:,112),heltab2x2(:,:,198))
  call Hloop_VT_S(ntryL,G1H2(187),39,ex5(:),16,G2H2(163),m3h1x2(:,87),heltab2x2(:,:,199))
  call Hloop_VT_S(ntryL,G1H2(188),39,ex5(:),16,G2H2(164),m3h1x2(:,88),heltab2x2(:,:,200))
  call Hloop_SQ_A(ntryL,G1H2(189),ex3(:),G1H1(7),ngH,m3h2x1(:,113),heltab2x2(:,:,201))
  call Hloop_Q_A(ntryL,G1H1(7),47,nMB,G2H1(113),n2h1(125))
call HGT_OLR(G1H2(190),1,1,2)
call HGT_invQ_OLR(G1H2(190),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(190),-16,nMB,G2H2(165),n2h2(58))
  call Hloop_AS_Q(ntryL,G2H2(165),ex5(:),G2H2(166),ngH,m3h1x2(:,89),heltab2x2(:,:,202))
  call Hloop_SQ_A(ntryL,G1H2(193),ex3(:),G1H1(26),ngH,m3h2x1(:,114),heltab2x2(:,:,203))
  call Hloop_Q_A(ntryL,G1H1(26),47,nMB,G2H1(114),n2h1(126))
  call Hloop_SQ_A(ntryL,G1H2(194),ex3(:),G1H1(19),ngH,m3h2x1(:,115),heltab2x2(:,:,204))
  call Hloop_Q_A(ntryL,G1H1(19),47,nMB,G2H1(115),n2h1(127))
  call Hloop_SQ_A(ntryL,G1H2(195),ex3(:),G1H1(31),ngX,m3h2x1(:,116),heltab2x2(:,:,205))
  call Hloop_Q_A(ntryL,G1H1(31),47,nMB,G2H1(116),n2h1(128))
call HGT_OLR(G1H2(196),1,1,2)
call HGT_invQ_OLR(G1H2(196),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(196),-16,nMB,G2H2(165),n2h2(59))
  call Hloop_AS_Q(ntryL,G2H2(165),ex5(:),G2H2(167),ngH,m3h1x2(:,90),heltab2x2(:,:,206))
  call Hloop_SQ_A(ntryL,G1H2(199),ex3(:),G1H1(37),ngX,m3h2x1(:,117),heltab2x2(:,:,207))
  call Hloop_Q_A(ntryL,G1H1(37),47,nMB,G2H1(117),n2h1(129))
  call Hloop_SQ_A(ntryL,G1H2(200),ex3(:),G1H1(32),ngX,m3h2x1(:,118),heltab2x2(:,:,208))
  call Hloop_Q_A(ntryL,G1H1(32),47,nMB,G2H1(118),n2h1(130))
  call Hloop_SQ_A(ntryL,G1H2(201),ex3(:),G1H1(20),ngPtb,m3h2x1(:,119),heltab2x2(:,:,209))
  call Hloop_Q_A(ntryL,G1H1(20),47,nMT,G2H1(119),n2h1(131))
call HGT_OLR(G1H2(202),1,1,2)
call HGT_invQ_OLR(G1H2(202),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(202),-16,nMT,G2H2(165),n2h2(60))
  call Hloop_AS_Q(ntryL,G2H2(165),ex5(:),G2H2(168),ngH,m3h1x2(:,91),heltab2x2(:,:,210))
  call Hloop_SQ_A(ntryL,G1H2(205),ex3(:),G1H1(8),ngPtb,m3h2x1(:,120),heltab2x2(:,:,211))
  call Hloop_Q_A(ntryL,G1H1(8),47,nMT,G2H1(120),n2h1(132))
  call Hloop_SQ_A(ntryL,G1H2(206),ex3(:),G1H1(2),ngPtb,m3h2x1(:,121),heltab2x2(:,:,212))
  call Hloop_Q_A(ntryL,G1H1(2),47,nMT,G2H1(121),n2h1(133))
  call Hloop_ST_V(ntryL,G1H2(13),39,ex5(:),16,G2H2(165),m3h1x2(:,92),heltab2x2(:,:,213))
call HGT_OLR(G1H2(25),1,1,2)
call HGT_invQ_OLR(G1H2(25),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(25),-8,nMB,G2H2(169),n2h2(61))
  call Hloop_QA_Z(ntryL,G2H2(169),ex4(:),G2H1(122),ngZd,m3h2x1(:,122),heltab2x2(:,:,214))
  call Hloop_ST_V(ntryL,G1H2(209),39,ex5(:),16,G2H2(169),m3h1x2(:,93),heltab2x2(:,:,215))
  call Hloop_ST_V(ntryL,G1H2(210),39,ex5(:),16,G2H2(170),m3h1x2(:,94),heltab2x2(:,:,216))
  call Hloop_ST_V(ntryL,G1H2(211),39,ex5(:),16,G2H2(171),m3h1x2(:,95),heltab2x2(:,:,217))
call HGT_OLR(G1H2(212),1,1,2)
call HGT_invQ_OLR(G1H2(212),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(212),-8,nMT,G2H2(172),n2h2(62))
  call Hloop_QA_W(ntryL,G2H2(172),ex4(:),G2H1(123),m3h2x1(:,123),heltab2x2(:,:,218))
  call Hloop_ST_V(ntryL,G1H2(215),39,ex5(:),16,G2H2(172),m3h1x2(:,96),heltab2x2(:,:,219))
  call Hloop_ST_V(ntryL,G1H2(216),39,ex5(:),16,G2H2(173),m3h1x2(:,97),heltab2x2(:,:,220))
  call Hloop_SA_Q(ntryL,G1H2(49),ex4(:),G1H1(13),ngX,m3h2x1(:,124),heltab2x2(:,:,221))
  call Hloop_A_Q(ntryL,G1H1(13),47,nMB,G2H1(124),n2h1(134))
call HGT_OLR(G1H2(218),1,1,2)
call HGT_invQ_OLR(G1H2(218),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(218),-16,nMB,G2H2(174),n2h2(63))
  call Hloop_QS_A(ntryL,G2H2(174),ex5(:),G2H2(175),ngH,m3h1x2(:,98),heltab2x2(:,:,222))
  call Hloop_SA_Q(ntryL,G1H2(221),ex4(:),G1H1(1),ngX,m3h2x1(:,125),heltab2x2(:,:,223))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMB,G2H1(125),n2h1(135))
  call Hloop_SA_Q(ntryL,G1H2(222),ex4(:),G1H1(14),ngX,m3h2x1(:,126),heltab2x2(:,:,224))
  call Hloop_A_Q(ntryL,G1H1(14),47,nMB,G2H1(126),n2h1(136))
  call Hloop_SA_Q(ntryL,G1H2(223),ex4(:),G1H1(25),ngH,m3h2x1(:,127),heltab2x2(:,:,225))
  call Hloop_A_Q(ntryL,G1H1(25),47,nMB,G2H1(127),n2h1(137))
call HGT_OLR(G1H2(224),1,1,2)
call HGT_invQ_OLR(G1H2(224),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(224),-16,nMB,G2H2(174),n2h2(64))
  call Hloop_QS_A(ntryL,G2H2(174),ex5(:),G2H2(176),ngH,m3h1x2(:,99),heltab2x2(:,:,226))
  call Hloop_SA_Q(ntryL,G1H2(227),ex4(:),G1H1(7),ngH,m3h2x1(:,128),heltab2x2(:,:,227))
  call Hloop_A_Q(ntryL,G1H1(7),47,nMB,G2H1(128),n2h1(138))
  call Hloop_SA_Q(ntryL,G1H2(228),ex4(:),G1H1(26),ngH,m3h2x1(:,129),heltab2x2(:,:,228))
  call Hloop_A_Q(ntryL,G1H1(26),47,nMB,G2H1(129),n2h1(139))
  call Hloop_SA_Q(ntryL,G1H2(229),ex4(:),G1H1(19),ngPbt,m3h2x1(:,130),heltab2x2(:,:,229))
  call Hloop_A_Q(ntryL,G1H1(19),47,nMT,G2H1(130),n2h1(140))
call HGT_OLR(G1H2(230),1,1,2)
call HGT_invQ_OLR(G1H2(230),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(230),-16,nMT,G2H2(174),n2h2(65))
  call Hloop_QS_A(ntryL,G2H2(174),ex5(:),G2H2(177),ngH,m3h1x2(:,100),heltab2x2(:,:,230))
  call Hloop_SA_Q(ntryL,G1H2(233),ex4(:),G1H1(31),ngPbt,m3h2x1(:,131),heltab2x2(:,:,231))
  call Hloop_A_Q(ntryL,G1H1(31),47,nMT,G2H1(131),n2h1(141))
  call Hloop_SA_Q(ntryL,G1H2(234),ex4(:),G1H1(37),ngPbt,m3h2x1(:,132),heltab2x2(:,:,232))
  call Hloop_A_Q(ntryL,G1H1(37),47,nMT,G2H1(132),n2h1(142))
  call Hloop_QZ_A(ntryL,G1H8(43),wf4(:,1),G1H2(248),ngZd,m3h4x2(:,49),heltab2x8(:,:,156))
  call Hloop_Q_A(ntryL,G1H2(248),55,nMB,G2H2(174),n2h2(66))
call HGT_raise_alpha_OLR(G1H8(44),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(44),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(44),ex4(:),G1H4(2),m3h2x4(:,84),heltab2x8(:,:,157))
  call Hloop_QZ_A(ntryL,G1H8(49),wf4(:,1),G1H2(97),ngZd,m3h4x2(:,50),heltab2x8(:,:,158))
  call Hloop_Q_A(ntryL,G1H2(97),55,nMB,G2H2(178),n2h2(67))
  call Hloop_QZ_A(ntryL,G1H8(54),wf4(:,1),G1H2(3),ngZd,m3h4x2(:,51),heltab2x8(:,:,159))
  call Hloop_Q_A(ntryL,G1H2(3),55,nMB,G2H2(179),n2h2(68))
call HGT_raise_alpha_OLR(G1H8(50),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(50),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(50),ex4(:),G1H4(89),m3h2x4(:,85),heltab2x8(:,:,160))
  call Hloop_QZ_A(ntryL,G1H8(53),wf4(:,1),G1H2(14),ngZd,m3h4x2(:,52),heltab2x8(:,:,161))
  call Hloop_Q_A(ntryL,G1H2(14),55,nMB,G2H2(180),n2h2(69))
call HGT_raise_alpha_OLR(G1H8(55),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(55),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(55),ex4(:),G1H4(36),m3h2x4(:,86),heltab2x8(:,:,162))
  call Hloop_QZ_A(ntryL,G1H8(58),wf4(:,1),G1H2(11),ngZd,m3h4x2(:,53),heltab2x8(:,:,163))
  call Hloop_Q_A(ntryL,G1H2(11),55,nMB,G2H2(181),n2h2(70))
  call Hloop_QS_A(ntryL,G1H2(92),ex5(:),G1H2(15),ngH,m3h1x2(:,101),heltab2x2(:,:,233))
  call Hloop_Q_A(ntryL,G1H2(15),55,nMB,G2H2(182),n2h2(71))
call HGT_raise_alpha_OLR(G1H2(93),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(93),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(93),ex4(:),G1H1(32),m3h2x1(:,133),heltab2x2(:,:,234))
  call Hloop_QS_A(ntryL,G1H2(237),ex5(:),G1H2(17),ngH,m3h1x2(:,102),heltab2x2(:,:,235))
  call Hloop_Q_A(ntryL,G1H2(17),55,nMB,G2H2(183),n2h2(73))
  call Hloop_QS_A(ntryL,G1H2(242),ex5(:),G1H2(23),ngH,m3h1x2(:,103),heltab2x2(:,:,236))
  call Hloop_Q_A(ntryL,G1H2(23),55,nMB,G2H2(184),n2h2(74))
call HGT_raise_alpha_OLR(G1H2(238),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(238),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(238),ex4(:),G1H1(20),m3h2x1(:,134),heltab2x2(:,:,237))
  call Hloop_QS_A(ntryL,G1H2(241),ex5(:),G1H2(27),ngH,m3h1x2(:,104),heltab2x2(:,:,238))
  call Hloop_Q_A(ntryL,G1H2(27),55,nMB,G2H2(185),n2h2(76))
call HGT_raise_alpha_OLR(G1H2(243),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(243),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(243),ex4(:),G1H1(8),m3h2x1(:,135),heltab2x2(:,:,239))
  call Hloop_QS_A(ntryL,G1H2(246),ex5(:),G1H2(29),ngH,m3h1x2(:,105),heltab2x2(:,:,240))
  call Hloop_Q_A(ntryL,G1H2(29),55,nMB,G2H2(186),n2h2(78))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G2H2(5),G1H2(57),G1H2(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(150),[G2H2(18),G2H2(9),G1H2(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(2),[G1H1(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(4),[G1H1(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(6),[G1H1(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(8),[G1H1(24)])



end subroutine vamp_1

end module ol_vamp_1_pphllj_ew_nenexbbxhg_1_/**/REALKIND
