
module ol_vamp_1_pphllj_ew_nenexbbxha_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphllj_ew_nenexbbxha_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphllj_ew_nenexbbxha_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pphllj_ew_nenexbbxha_1_/**/DREALKIND
  use ol_tensor_sum_storage_pphllj_ew_nenexbbxha_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pphllj_ew_nenexbbxha_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pphllj_ew_nenexbbxha_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(1,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[32,3,16,4,8],[nMB,nMB,nMB,0,nMB],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[32,3,8,4,16],[nMB,nMB,0,nMB,nMB],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[32,3,16,8,4],[nMB,nMB,nMB,0,nMB],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[32,4,8,3,16],[nMB,0,nMB,nMB,nMB],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(4),n2h16(4))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[32,3,4,8,16],[nMB,nMB,0,nMB,nMB],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(5),n2h16(5))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[32,8,4,3,16],[nMB,0,nMB,nMB,nMB],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(6),n2h16(6))
  call Hloop_AZ_Q(ntryL,G1H16(1),wf4(:,3),G1H4(1),ngZd,m3h4x4(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMB,G2H4(1),n2h4(1))
  call Hloop_QZ_A(ntryL,G1H16(2),wf4(:,3),G1H4(1),ngZd,m3h4x4(:,2),heltab2x16(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMB,G2H4(2),n2h4(2))
  call Hloop_QZ_A(ntryL,G1H16(3),wf4(:,3),G1H4(1),ngZd,m3h4x4(:,3),heltab2x16(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMB,G2H4(3),n2h4(3))
  call Hloop_AQ_V(ntryL,G1H16(4),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,4))
  call Hloop_AZ_Q(ntryL,G1H16(5),wf4(:,3),G1H4(1),ngZd,m3h4x4(:,4),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMB,G2H4(4),n2h4(4))
  call Hloop_QA_V(ntryL,G1H16(6),ex4(:),G1H8(2),m3h2x8(:,2),heltab2x16(:,:,6))
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
  call HG1shiftOLR(G1H4(2),8,4)
  call Hloop_QA_V(ntryL,G2H4(2),ex4(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hotf_5pt_reduction(G2H4(3),RedSet_5(2),mass5set(:,1),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(8),4,4)
  call Hloop_VA_Q(ntryL,G1H8(1),ex4(:),G1H4(13),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_A_Q(ntryL,G1H4(13),44,nMB,G2H4(1),n2h4(5))
  call Hloop_AQ_V(ntryL,G2H4(4),ex3(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_VQ_A(ntryL,G1H8(2),ex3(:),G1H4(13),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(13),44,nMB,G2H4(2),n2h4(6))
  call Hloop_AS_Q(ntryL,G1H4(1),ex5(:),G1H4(13),ngH,m3h1x4(:,1),heltab2x4(:,:,3))
  call Hloop_A_Q(ntryL,G1H4(13),51,nMB,G2H4(3),n2h4(7))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(2),-8,nMB,G2H4(4),n2h4(8))
  call Hloop_QA_V(ntryL,G2H4(4),ex4(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,4))
  call Hloop_AS_Q(ntryL,G1H4(4),ex5(:),G1H4(1),ngH,m3h1x4(:,2),heltab2x4(:,:,5))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMB,G2H4(4),n2h4(9))
  call Hloop_AS_Q(ntryL,G1H4(5),ex5(:),G1H4(13),ngH,m3h1x4(:,3),heltab2x4(:,:,6))
  call Hloop_A_Q(ntryL,G1H4(13),51,nMB,G2H4(5),n2h4(10))
  call Hloop_AS_Q(ntryL,G1H4(6),ex5(:),G1H4(2),ngH,m3h1x4(:,4),heltab2x4(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(2),51,nMB,G2H4(6),n2h4(11))
  call Hloop_QS_A(ntryL,G1H4(7),ex5(:),G1H4(4),ngH,m3h1x4(:,5),heltab2x4(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(4),51,nMB,G2H4(7),n2h4(12))
call HGT_OLR(G1H4(8),1,1,4)
call HGT_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(8),-4,nMB,G2H4(8),n2h4(13))
  call Hloop_AQ_V(ntryL,G2H4(8),ex3(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,9))
  call Hloop_QS_A(ntryL,G1H4(10),ex5(:),G1H4(1),ngH,m3h1x4(:,6),heltab2x4(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMB,G2H4(8),n2h4(14))
  call Hloop_QS_A(ntryL,G1H4(11),ex5(:),G1H4(5),ngH,m3h1x4(:,7),heltab2x4(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(5),51,nMB,G2H4(9),n2h4(15))
  call Hloop_QS_A(ntryL,G1H4(12),ex5(:),G1H4(13),ngH,m3h1x4(:,8),heltab2x4(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(13),51,nMB,G2H4(10),n2h4(16))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(3),mass5set(:,2),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),16,2)
  call Hotf_5pt_reduction(G2H4(1),RedSet_5(4),mass5set(:,3),  & 
G1H4(6),G1H4(2),G1H4(7),G1H4(4),G1H4(8),G1H4(10),4)
  call HG1shiftOLR(G1H4(2),16,4)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(5),mass5set(:,2),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),16,2)
  call Hotf_5pt_reduction(G2H4(2),RedSet_5(6),mass5set(:,3),  & 
G1H4(1),G1H4(11),G1H4(5),G1H4(12),G1H4(13),G1H4(14),4)
  call HG1shiftOLR(G1H4(11),16,4)
  call Hloop_AQ_V(ntryL,G2H4(3),ex3(:),G2H2(1),m3h2x2(:,5),heltab2x4(:,:,13))
  call Hloop_AQ_V(ntryL,G2H4(5),ex3(:),G2H2(2),m3h2x2(:,6),heltab2x4(:,:,14))
  call Hloop_AQ_V(ntryL,G2H4(6),ex3(:),G2H2(5),m3h2x2(:,7),heltab2x4(:,:,15))
  call Hloop_QA_V(ntryL,G2H4(7),ex4(:),G2H2(6),m3h2x2(:,8),heltab2x4(:,:,16))
  call Hloop_QA_V(ntryL,G2H4(9),ex4(:),G2H2(7),m3h2x2(:,9),heltab2x4(:,:,17))
  call Hloop_QA_V(ntryL,G2H4(10),ex4(:),G2H2(8),m3h2x2(:,10),heltab2x4(:,:,18))
  call Hloop_VQ_A(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMB,G2H1(1),n2h1(1))
call HGT_OLR(G1H2(2),1,1,2)
call HGT_invQ_OLR(G1H2(2),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(2),-16,nMB,G2H2(9),n2h2(1))
  call Hloop_AS_Q(ntryL,G2H2(9),ex5(:),G2H2(10),ngH,m3h1x2(:,1),heltab2x2(:,:,2))
  call Hloop_VQ_A(ntryL,G1H2(5),ex3(:),G1H1(1),m3h2x1(:,2),heltab2x2(:,:,3))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMB,G2H1(2),n2h1(2))
  call Hloop_VQ_A(ntryL,G1H2(6),ex3(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,4))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMB,G2H1(3),n2h1(3))
  call Hloop_AZ_Q(ntryL,G1H4(6),wf4(:,3),G1H1(1),ngZd,m3h4x1(:,1),heltab2x4(:,:,19))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMB,G2H1(4),n2h1(4))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(2),-16,nMB,G2H4(1),n2h4(17))
  call Hloop_QS_A(ntryL,G2H4(1),ex5(:),G2H4(2),ngH,m3h1x4(:,9),heltab2x4(:,:,20))
  call Hloop_AZ_Q(ntryL,G1H4(8),wf4(:,3),G1H1(1),ngZd,m3h4x1(:,2),heltab2x4(:,:,21))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMB,G2H1(5),n2h1(5))
  call Hloop_AZ_Q(ntryL,G1H4(10),wf4(:,3),G1H1(1),ngZd,m3h4x1(:,3),heltab2x4(:,:,22))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMB,G2H1(6),n2h1(6))
  call Hloop_VA_Q(ntryL,G1H2(7),ex4(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,5))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMB,G2H1(7),n2h1(7))
call HGT_OLR(G1H2(8),1,1,2)
call HGT_invQ_OLR(G1H2(8),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(8),-16,nMB,G2H2(9),n2h2(2))
  call Hloop_QS_A(ntryL,G2H2(9),ex5(:),G2H2(11),ngH,m3h1x2(:,2),heltab2x2(:,:,6))
  call Hloop_VA_Q(ntryL,G1H2(11),ex4(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,7))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMB,G2H1(8),n2h1(8))
  call Hloop_VA_Q(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,8))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMB,G2H1(9),n2h1(9))
  call Hloop_QZ_A(ntryL,G1H4(1),wf4(:,3),G1H1(1),ngZd,m3h4x1(:,4),heltab2x4(:,:,23))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMB,G2H1(10),n2h1(10))
call HGT_OLR(G1H4(11),1,1,4)
call HGT_invQ_OLR(G1H4(11),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(11),-16,nMB,G2H4(3),n2h4(18))
  call Hloop_AS_Q(ntryL,G2H4(3),ex5(:),G2H4(5),ngH,m3h1x4(:,10),heltab2x4(:,:,24))
  call Hloop_QZ_A(ntryL,G1H4(13),wf4(:,3),G1H1(1),ngZd,m3h4x1(:,5),heltab2x4(:,:,25))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMB,G2H1(11),n2h1(11))
  call Hloop_QZ_A(ntryL,G1H4(14),wf4(:,3),G1H1(1),ngZd,m3h4x1(:,6),heltab2x4(:,:,26))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMB,G2H1(12),n2h1(12))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(5),G1H2(6),G1H2(7),G1H2(8),2)
  call HG1shiftOLR(G1H2(2),8,2)
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(1),mass4set(:,1),  & 
G1H2(11),G1H2(12),G1H2(13),G1H2(14),G1H2(15),2)
  call HG1shiftOLR(G1H2(12),12,2)
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(2),mass5set(:,1),  & 
G1H2(16),G1H2(17),G1H2(18),G1H2(19),G1H2(20),G1H2(21),2)
  call HG1shiftOLR(G1H2(17),4,2)
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(1),mass4set(:,1),  & 
G1H2(22),G1H2(23),G1H2(24),G1H2(25),G1H2(26),2)
  call HG1shiftOLR(G1H2(23),12,2)
  call Hotf_5pt_reduction(G2H1(1),RedSet_5(3),mass5set(:,2),  & 
G1H1(1),G1H1(2),G1H1(3),G1H1(4),G1H1(5),G1H1(6),1)
  call HG1shiftOLR(G1H1(2),16,1)
  call Hotf_4pt_reduction(G2H1(3),RedSet_4(2),mass4set(:,2),  & 
G1H1(7),G1H1(8),G1H1(9),G1H1(10),G1H1(11),1)
  call HG1shiftOLR(G1H1(8),20,1)
  call Hotf_5pt_reduction(G2H1(4),RedSet_5(4),mass5set(:,3),  & 
G1H1(12),G1H1(13),G1H1(14),G1H1(15),G1H1(16),G1H1(17),1)
  call HG1shiftOLR(G1H1(13),16,1)
  call Hotf_4pt_reduction(G2H1(6),RedSet_4(3),mass4set(:,3),  & 
G1H1(18),G1H1(19),G1H1(20),G1H1(21),G1H1(22),1)
  call HG1shiftOLR(G1H1(19),19,1)
  call Hotf_5pt_reduction(G2H1(7),RedSet_5(5),mass5set(:,2),  & 
G1H1(23),G1H1(24),G1H1(25),G1H1(26),G1H1(27),G1H1(28),1)
  call HG1shiftOLR(G1H1(24),16,1)
  call Hotf_4pt_reduction(G2H1(9),RedSet_4(4),mass4set(:,2),  & 
G1H1(29),G1H1(30),G1H1(31),G1H1(32),G1H1(33),1)
  call HG1shiftOLR(G1H1(30),24,1)
  call Hotf_5pt_reduction(G2H1(10),RedSet_5(6),mass5set(:,3),  & 
G1H1(34),G1H1(35),G1H1(36),G1H1(37),G1H1(38),G1H1(39),1)
  call HG1shiftOLR(G1H1(35),16,1)
  call Hotf_4pt_reduction(G2H1(12),RedSet_4(5),mass4set(:,3),  & 
G1H1(40),G1H1(41),G1H1(42),G1H1(43),G1H1(44),1)
  call HG1shiftOLR(G1H1(41),19,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(11),[G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(22),[G1H2(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(7),[G1H1(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(18),[G1H1(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(29),[G1H1(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(40),[G1H1(39)])
  call Hloop_VA_Q(ntryL,G1H2(1),ex4(:),G1H1(6),m3h2x1(:,7),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(6),63,nMB,G2tensor(1),n2h1(13))
  call Hloop_VA_Q(ntryL,G1H2(2),ex4(:),G1H1(17),m3h2x1(:,8),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),8,nMB,G2tensor(2),n2h1(14))
  call Hloop_VA_Q(ntryL,G1H2(11),ex4(:),G1H1(28),m3h2x1(:,9),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(28),63,nMB,G2tensor(3),n2h1(15))
  call Hloop_VA_Q(ntryL,G1H2(12),ex4(:),G1H1(39),m3h2x1(:,10),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(39),12,nMB,G2tensor(4),n2h1(16))
  call Hloop_VQ_A(ntryL,G1H2(16),ex3(:),G1H1(6),m3h2x1(:,11),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),63,nMB,G2tensor(5),n2h1(17))
  call Hloop_VQ_A(ntryL,G1H2(17),ex3(:),G1H1(17),m3h2x1(:,12),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),4,nMB,G2tensor(6),n2h1(18))
  call Hloop_VQ_A(ntryL,G1H2(22),ex3(:),G1H1(28),m3h2x1(:,13),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(28),63,nMB,G2tensor(7),n2h1(19))
  call Hloop_VQ_A(ntryL,G1H2(23),ex3(:),G1H1(39),m3h2x1(:,14),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(39),12,nMB,G2tensor(8),n2h1(20))
  call Hloop_QS_A(ntryL,G1H1(1),ex5(:),G1H1(6),ngH,m3h1x1(:,1),heltab2x1(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),63,nMB,G2tensor(9),n2h1(21))
  call Hloop_QS_A(ntryL,G1H1(2),ex5(:),G1H1(17),ngH,m3h1x1(:,2),heltab2x1(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(17),16,nMB,G2tensor(10),n2h1(22))
  call Hloop_QS_A(ntryL,G1H1(7),ex5(:),G1H1(28),ngH,m3h1x1(:,3),heltab2x1(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(28),63,nMB,G2tensor(11),n2h1(23))
  call Hloop_QS_A(ntryL,G1H1(8),ex5(:),G1H1(39),ngH,m3h1x1(:,4),heltab2x1(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(39),20,nMB,G2tensor(12),n2h1(24))
  call Hloop_AS_Q(ntryL,G1H1(12),ex5(:),G1H1(1),ngH,m3h1x1(:,5),heltab2x1(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(13),n2h1(25))
  call Hloop_AS_Q(ntryL,G1H1(13),ex5(:),G1H1(6),ngH,m3h1x1(:,6),heltab2x1(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(6),16,nMB,G2tensor(14),n2h1(26))
  call Hloop_AS_Q(ntryL,G1H1(18),ex5(:),G1H1(2),ngH,m3h1x1(:,7),heltab2x1(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),63,nMB,G2tensor(15),n2h1(27))
  call Hloop_AS_Q(ntryL,G1H1(19),ex5(:),G1H1(17),ngH,m3h1x1(:,8),heltab2x1(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),19,nMB,G2tensor(16),n2h1(28))
  call Hloop_AS_Q(ntryL,G1H1(23),ex5(:),G1H1(7),ngH,m3h1x1(:,9),heltab2x1(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(7),63,nMB,G2tensor(17),n2h1(29))
  call Hloop_AS_Q(ntryL,G1H1(24),ex5(:),G1H1(28),ngH,m3h1x1(:,10),heltab2x1(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(28),16,nMB,G2tensor(18),n2h1(30))
  call Hloop_AS_Q(ntryL,G1H1(29),ex5(:),G1H1(8),ngH,m3h1x1(:,11),heltab2x1(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(8),63,nMB,G2tensor(19),n2h1(31))
  call Hloop_AS_Q(ntryL,G1H1(30),ex5(:),G1H1(39),ngH,m3h1x1(:,12),heltab2x1(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(39),24,nMB,G2tensor(20),n2h1(32))
  call Hloop_QS_A(ntryL,G1H1(34),ex5(:),G1H1(12),ngH,m3h1x1(:,13),heltab2x1(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(12),63,nMB,G2tensor(21),n2h1(33))
  call Hloop_QS_A(ntryL,G1H1(35),ex5(:),G1H1(1),ngH,m3h1x1(:,14),heltab2x1(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(22),n2h1(34))
  call Hloop_QS_A(ntryL,G1H1(40),ex5(:),G1H1(13),ngH,m3h1x1(:,15),heltab2x1(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(13),63,nMB,G2tensor(23),n2h1(35))
  call Hloop_QS_A(ntryL,G1H1(41),ex5(:),G1H1(6),ngH,m3h1x1(:,16),heltab2x1(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),19,nMB,G2tensor(24),n2h1(36))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(2),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),4)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(3),mass5set(:,2),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),16)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(4),mass5set(:,3),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),16)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(5),mass5set(:,2),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),16)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(6),mass5set(:,3),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),16)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[32,3,20,8],[nMB,nMB,0,nMB],4,2,wf4(:,3),wf2(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(1),n2h16(7))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[32,3,8,20],[nMB,nMB,0,nMB],4,2,wf4(:,3),wf2(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(2),n2h16(8))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[32,3,24,4],[nMB,nMB,0,nMB],4,2,wf4(:,3),wf2(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(3),n2h16(9))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(47)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[32,3,4,24],[nMB,nMB,0,nMB],4,2,wf4(:,3),wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(4),n2h16(10))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[36,3,16,8],[nMB,nMB,nMB,0],4,2,wf4(:,7),wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,7),G0H8(1),m3h4x8(:,1),heltab2x32(:,:,11))
  call Hloop_Q_A(ntryL,G0H8(1),36,nMB,G1H8(1),n2h8(1))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[36,8,3,16],[0,nMB,nMB,nMB],4,2,wf4(:,7),wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,7),G0H8(1),m3h4x8(:,2),heltab2x32(:,:,12))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[40,3,16,4],[nMB,nMB,nMB,0],4,2,wf4(:,4),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,4),G0H8(2),m3h4x8(:,3),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G0H8(2),40,nMB,G1H8(2),n2h8(2))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(37)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[40,4,3,16],[0,nMB,nMB,nMB],4,2,wf4(:,4),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,4),G0H8(2),m3h4x8(:,4),heltab2x32(:,:,14))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[32,7,8,16],[nMB,0,nMB,nMB],4,1,wf8(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,11),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(5),n2h16(11))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[32,8,7,16],[nMB,0,nMB,nMB],4,1,wf8(:,5))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,16))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(6),n2h16(12))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[32,11,4,16],[nMB,0,nMB,nMB],4,1,wf8(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,13),heltab2x32(:,:,17))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(7),n2h16(13))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[32,4,11,16],[nMB,0,nMB,nMB],4,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,14),heltab2x32(:,:,18))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(8),n2h16(14))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[32,4,8,19],[nMB,0,nMB,nMB],4,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,15),heltab2x32(:,:,19))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(9),n2h16(15))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[32,8,4,19],[nMB,0,nMB,nMB],4,1,wf4(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,16),heltab2x32(:,:,20))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(10),n2h16(16))
  call Hloop_AS_Q(ntryL,G1H4(3),ex5(:),G1H4(6),ngH,m3h1x4(:,11),heltab2x4(:,:,27))
  call Hloop_A_Q(ntryL,G1H4(6),51,nMB,G2H4(6),n2h4(19))
  call Hloop_QS_A(ntryL,G1H4(9),ex5(:),G1H4(2),ngH,m3h1x4(:,12),heltab2x4(:,:,28))
  call Hloop_Q_A(ntryL,G1H4(2),51,nMB,G2H4(7),n2h4(20))
  call Hloop_AZ_Q(ntryL,G1H16(1),wf4(:,3),G1H4(8),ngZd,m3h4x4(:,5),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(8),35,nMB,G2H4(9),n2h4(21))
  call Hloop_QZ_A(ntryL,G1H16(2),wf4(:,3),G1H4(10),ngZd,m3h4x4(:,6),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(10),35,nMB,G2H4(10),n2h4(22))
  call Hloop_QZ_A(ntryL,G1H16(3),wf4(:,3),G1H4(1),ngZd,m3h4x4(:,7),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMB,G2H4(1),n2h4(23))
  call Hloop_AZ_Q(ntryL,G1H16(4),wf4(:,3),G1H4(11),ngZd,m3h4x4(:,8),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G1H4(11),35,nMB,G2H4(3),n2h4(24))
  call Hloop_QZ_A(ntryL,G1H8(1),wf4(:,3),G1H2(8),ngZd,m3h4x2(:,1),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(8),39,nMB,G2H2(9),n2h2(3))
  call Hloop_VA_Q(ntryL,G0H8(1),ex4(:),G0H4(1),m3h2x4(:,3),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G0H4(1),44,nMB,G1H4(13),n2h4(25))
  call Hloop_AZ_Q(ntryL,G1H8(2),wf4(:,3),G1H2(21),ngZd,m3h4x2(:,2),heltab2x8(:,:,5))
  call Hloop_A_Q(ntryL,G1H2(21),43,nMB,G2H2(1),n2h2(4))
  call Hloop_VQ_A(ntryL,G0H8(2),ex3(:),G0H4(1),m3h2x4(:,4),heltab2x8(:,:,6))
  call Hloop_Q_A(ntryL,G0H4(1),44,nMB,G1H4(14),n2h4(26))
  call Hloop_AQ_V(ntryL,G1H16(5),wf8(:,5),G1H2(1),m3h8x2(:,1),heltab2x16(:,:,11))
  call Hloop_QA_V(ntryL,G1H16(6),ex4(:),G1H8(1),m3h2x8(:,3),heltab2x16(:,:,12))
  call Hloop_QA_V(ntryL,G1H16(7),wf8(:,3),G1H2(2),m3h8x2(:,2),heltab2x16(:,:,13))
  call Hloop_AQ_V(ntryL,G1H16(8),ex3(:),G1H8(2),m3h2x8(:,4),heltab2x16(:,:,14))
  call Hloop_AQ_V(ntryL,G1H16(9),ex3(:),G1H8(3),m3h2x8(:,5),heltab2x16(:,:,15))
  call Hloop_QA_V(ntryL,G1H16(10),ex4(:),G1H8(4),m3h2x8(:,6),heltab2x16(:,:,16))
call HGT_lower_alpha_w2_OLR(G2H2(3),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(3),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(3),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G2H2(1)])
call HGT_lower_alpha_w2_OLR(G2H2(4),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(4),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(4),6,15,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G2H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(2),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1),[G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(14),[G1H4(5)])
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(28),mass4set(:,4),  & 
G1H2(11),G1H2(12),G1H2(16),G1H2(17),G1H2(22),2)
  call HG1shiftOLR(G1H2(12),4,2)
  call Hloop_AQ_V(ntryL,G2H4(4),ex3(:),G2H2(5),m3h2x2(:,11),heltab2x4(:,:,29))
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(29),mass4set(:,4),  & 
G1H2(23),G1H2(8),G1H2(21),G1H2(4),G1H2(10),2)
  call HG1shiftOLR(G1H2(8),8,2)
  call Hloop_QA_V(ntryL,G2H4(8),ex4(:),G2H2(6),m3h2x2(:,12),heltab2x4(:,:,30))
  call Hloop_VQ_A(ntryL,G1H2(3),ex3(:),G1H1(18),m3h2x1(:,15),heltab2x2(:,:,17))
  call Hloop_Q_A(ntryL,G1H1(18),47,nMB,G2H1(1),n2h1(37))
  call Hloop_VQ_A(ntryL,G1H2(2),ex3(:),G1H1(2),m3h2x1(:,16),heltab2x2(:,:,18))
  call Hloop_Q_A(ntryL,G1H1(2),47,nMB,G2H1(3),n2h1(38))
  call Hloop_AZ_Q(ntryL,G1H4(13),wf4(:,3),G1H1(19),ngZd,m3h4x1(:,7),heltab2x4(:,:,31))
  call Hloop_A_Q(ntryL,G1H1(19),47,nMB,G2H1(4),n2h1(39))
  call Hloop_AZ_Q(ntryL,G1H4(4),wf4(:,3),G1H1(17),ngZd,m3h4x1(:,8),heltab2x4(:,:,32))
  call Hloop_A_Q(ntryL,G1H1(17),47,nMB,G2H1(6),n2h1(40))
  call Hloop_VA_Q(ntryL,G1H2(9),ex4(:),G1H1(23),m3h2x1(:,17),heltab2x2(:,:,19))
  call Hloop_A_Q(ntryL,G1H1(23),47,nMB,G2H1(7),n2h1(41))
  call Hloop_VA_Q(ntryL,G1H2(1),ex4(:),G1H1(7),m3h2x1(:,18),heltab2x2(:,:,20))
  call Hloop_A_Q(ntryL,G1H1(7),47,nMB,G2H1(9),n2h1(42))
  call Hloop_QZ_A(ntryL,G1H4(14),wf4(:,3),G1H1(24),ngZd,m3h4x1(:,9),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H1(24),47,nMB,G2H1(10),n2h1(43))
  call Hloop_QZ_A(ntryL,G1H4(12),wf4(:,3),G1H1(28),ngZd,m3h4x1(:,10),heltab2x4(:,:,34))
  call Hloop_Q_A(ntryL,G1H1(28),47,nMB,G2H1(12),n2h1(44))
  call Hloop_AQ_V(ntryL,G2H4(6),ex3(:),G2H2(8),m3h2x2(:,13),heltab2x4(:,:,35))
  call Hloop_QA_V(ntryL,G2H4(7),ex4(:),G2H2(1),m3h2x2(:,14),heltab2x4(:,:,36))
  call Hloop_AQ_V(ntryL,G2H4(9),wf2(:,2),G2H2(9),m3h2x2(:,15),heltab2x4(:,:,37))
  call Hloop_QA_V(ntryL,G2H4(10),ex4(:),G2H2(3),m3h2x2(:,16),heltab2x4(:,:,38))
  call Hloop_QA_V(ntryL,G2H4(1),wf2(:,4),G2H2(4),m3h2x2(:,17),heltab2x4(:,:,39))
  call Hloop_AQ_V(ntryL,G2H4(3),ex3(:),G2H2(12),m3h2x2(:,18),heltab2x4(:,:,40))
  call Hloop_VQ_A(ntryL,G1H8(1),wf8(:,5),G1H1(29),m3h8x1(:,1),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H1(29),47,nMB,G2H1(13),n2h1(45))
  call Hloop_VA_Q(ntryL,G1H8(2),wf8(:,3),G1H1(8),m3h8x1(:,2),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G1H1(8),47,nMB,G2H1(14),n2h1(46))
  call Hloop_VA_Q(ntryL,G1H8(3),ex4(:),G1H4(3),m3h2x4(:,5),heltab2x8(:,:,9))
  call Hloop_A_Q(ntryL,G1H4(3),44,nMB,G2H4(4),n2h4(27))
  call Hloop_VQ_A(ntryL,G1H8(4),ex3(:),G1H4(6),m3h2x4(:,6),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(6),44,nMB,G2H4(8),n2h4(28))
  call Hloop_AS_Q(ntryL,G1H2(11),ex5(:),G1H2(3),ngH,m3h1x2(:,3),heltab2x2(:,:,21))
  call Hloop_A_Q(ntryL,G1H2(3),59,nMB,G2H2(13),n2h2(5))
call HGT_raise_alpha_OLR(G1H2(12),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(12),2,5,2)
  call Hloop_VQ_A(ntryL,G1H2(12),ex3(:),G1H1(30),m3h2x1(:,19),heltab2x2(:,:,22))
  call Hloop_AS_Q(ntryL,G1H2(17),ex5(:),G1H2(2),ngH,m3h1x2(:,4),heltab2x2(:,:,23))
  call Hloop_A_Q(ntryL,G1H2(2),59,nMB,G2H2(14),n2h2(7))
  call Hloop_AS_Q(ntryL,G1H2(22),ex5(:),G1H2(9),ngH,m3h1x2(:,5),heltab2x2(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(9),59,nMB,G2H2(15),n2h2(8))
  call Hloop_QS_A(ntryL,G1H2(23),ex5(:),G1H2(1),ngH,m3h1x2(:,6),heltab2x2(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMB,G2H2(16),n2h2(9))
call HGT_raise_alpha_OLR(G1H2(8),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(8),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(8),ex4(:),G1H1(39),m3h2x1(:,20),heltab2x2(:,:,26))
  call Hloop_QS_A(ntryL,G1H2(4),ex5(:),G1H2(11),ngH,m3h1x2(:,7),heltab2x2(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(11),55,nMB,G2H2(17),n2h2(11))
  call Hloop_QS_A(ntryL,G1H2(10),ex5(:),G1H2(3),ngH,m3h1x2(:,8),heltab2x2(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(3),55,nMB,G2H2(18),n2h2(12))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G2H2(2),G1H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G2H2(7),G1H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(2),[G1H1(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(14),[G2H1(5),G1H1(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(8),[G1H1(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(13),[G2H1(11),G1H1(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(1),[G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G1H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(1),[G1H1(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(3),[G1H1(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(4),[G1H1(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(6),[G1H1(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(7),[G1H1(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(9),[G1H1(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(10),[G1H1(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H1(12),[G1H1(37)])
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(8),mass4set(:,2),  & 
G1H2(12),G1H2(17),G1H2(2),G1H2(22),G1H2(9),2)
  call HG1shiftOLR(G1H2(17),8,2)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(12),mass4set(:,2),  & 
G1H2(23),G1H2(1),G1H2(8),G1H2(4),G1H2(11),2)
  call HG1shiftOLR(G1H2(1),4,2)
call HGT_OLR(G2H2(10),1,1,2)
call HGT_invQ_OLR(G2H2(10),2,5,2)
call HGT_OLR(G2H2(10),6,15,2)
  call Hotf_4pt_reduction(G2H2(10),RedSet_4(30),mass4set(:,2),  & 
G1H2(10),G1H2(3),G1H2(7),G1H2(20),G1H2(5),2)
  call HG1shiftOLR(G1H2(3),4,2)
  call Hotf_4pt_reduction(G2H1(2),RedSet_4(16),mass4set(:,1),  & 
G1H1(34),G1H1(12),G1H1(35),G1H1(1),G1H1(40),1)
  call HG1shiftOLR(G1H1(12),16,1)
call HGT_OLR(G2H4(2),1,1,4)
call HGT_invQ_OLR(G2H4(2),2,5,4)
call HGT_OLR(G2H4(2),6,15,4)
  call Hotf_4pt_reduction(G2H4(2),RedSet_4(31),mass4set(:,3),  & 
G1H4(9),G1H4(2),G1H4(8),G1H4(10),G1H4(1),4)
  call HG1shiftOLR(G1H4(2),3,4)
  call Hotf_4pt_reduction(G2H1(14),RedSet_4(20),mass4set(:,3),  & 
G1H1(13),G1H1(41),G1H1(6),G1H1(18),G1H1(2),1)
  call HG1shiftOLR(G1H1(41),16,1)
call HGT_OLR(G2H2(11),1,1,2)
call HGT_invQ_OLR(G2H2(11),2,5,2)
call HGT_OLR(G2H2(11),6,15,2)
  call Hotf_4pt_reduction(G2H2(11),RedSet_4(32),mass4set(:,2),  & 
G1H2(6),G1H2(18),G1H2(19),G1H2(27),G1H2(28),2)
  call HG1shiftOLR(G1H2(18),8,2)
  call Hotf_4pt_reduction(G2H1(8),RedSet_4(16),mass4set(:,1),  & 
G1H1(19),G1H1(17),G1H1(23),G1H1(7),G1H1(24),1)
  call HG1shiftOLR(G1H1(17),16,1)
call HGT_OLR(G2H4(5),1,1,4)
call HGT_invQ_OLR(G2H4(5),2,5,4)
call HGT_OLR(G2H4(5),6,15,4)
  call Hotf_4pt_reduction(G2H4(5),RedSet_4(33),mass4set(:,3),  & 
G1H4(11),G1H4(7),G1H4(5),G1H4(13),G1H4(4),4)
  call HG1shiftOLR(G1H4(7),3,4)
  call Hotf_4pt_reduction(G2H1(13),RedSet_4(26),mass4set(:,3),  & 
G1H1(28),G1H1(29),G1H1(8),G1H1(5),G1H1(16),1)
  call HG1shiftOLR(G1H1(29),16,1)
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(6),mass4set(:,2),  & 
G1H2(29),G1H2(30),G1H2(31),G1H2(32),G1H2(33),2)
  call HG1shiftOLR(G1H2(30),8,2)
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(7),mass4set(:,2),  & 
G1H2(34),G1H2(35),G1H2(36),G1H2(37),G1H2(38),2)
  call HG1shiftOLR(G1H2(35),8,2)
  call Hloop_VA_Q(ntryL,G1H2(13),ex4(:),G1H1(27),m3h2x1(:,21),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(27),63,nMB,G2tensor(1),n2h1(47))
  call Hloop_VA_Q(ntryL,G1H2(14),ex4(:),G1H1(38),m3h2x1(:,22),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(38),63,nMB,G2tensor(5),n2h1(48))
  call Hloop_VA_Q(ntryL,G1H2(15),ex4(:),G1H1(3),m3h2x1(:,23),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(3),63,nMB,G2tensor(9),n2h1(49))
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(10),mass4set(:,2),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(39),G1H2(40),2)
  call HG1shiftOLR(G1H2(14),4,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(11),mass4set(:,2),  & 
G1H2(41),G1H2(42),G1H2(43),G1H2(44),G1H2(45),2)
  call HG1shiftOLR(G1H2(42),4,2)
  call Hloop_VQ_A(ntryL,G1H2(24),ex3(:),G1H1(4),m3h2x1(:,24),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(4),63,nMB,G2tensor(13),n2h1(50))
  call Hloop_VQ_A(ntryL,G1H2(25),ex3(:),G1H1(14),m3h2x1(:,25),heltab2x2(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(14),63,nMB,G2tensor(17),n2h1(51))
  call Hloop_VQ_A(ntryL,G1H2(26),ex3(:),G1H1(15),m3h2x1(:,26),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(15),63,nMB,G2tensor(21),n2h1(52))
  call Hotf_4pt_reduction(G2H1(1),RedSet_4(14),mass4set(:,3),  & 
G1H1(25),G1H1(26),G1H1(36),G1H1(37),G1H1(27),1)
  call HG1shiftOLR(G1H1(26),16,1)
  call Hotf_4pt_reduction(G2H1(3),RedSet_4(15),mass4set(:,3),  & 
G1H1(38),G1H1(3),G1H1(4),G1H1(14),G1H1(15),1)
  call HG1shiftOLR(G1H1(3),16,1)
  call Hloop_QS_A(ntryL,G1H1(9),ex5(:),G1H1(45),ngH,m3h1x1(:,17),heltab2x1(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(45),63,nMB,G2tensor(25),n2h1(53))
  call Hloop_QS_A(ntryL,G1H1(10),ex5(:),G1H1(9),ngH,m3h1x1(:,18),heltab2x1(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),63,nMB,G2tensor(26),n2h1(54))
  call Hloop_QS_A(ntryL,G1H1(11),ex5(:),G1H1(45),ngH,m3h1x1(:,19),heltab2x1(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(45),63,nMB,G2tensor(27),n2h1(55))
  call Hotf_4pt_reduction(G2H1(4),RedSet_4(18),mass4set(:,5),  & 
G1H1(10),G1H1(9),G1H1(11),G1H1(45),G1H1(46),1)
  call HG1shiftOLR(G1H1(9),16,1)
  call Hotf_4pt_reduction(G2H1(6),RedSet_4(19),mass4set(:,1),  & 
G1H1(47),G1H1(48),G1H1(49),G1H1(50),G1H1(51),1)
  call HG1shiftOLR(G1H1(48),16,1)
  call Hloop_AS_Q(ntryL,G1H1(20),ex5(:),G1H1(52),ngH,m3h1x1(:,20),heltab2x1(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(52),63,nMB,G2tensor(28),n2h1(56))
  call Hloop_AS_Q(ntryL,G1H1(21),ex5(:),G1H1(20),ngH,m3h1x1(:,21),heltab2x1(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(20),63,nMB,G2tensor(29),n2h1(57))
  call Hloop_AS_Q(ntryL,G1H1(22),ex5(:),G1H1(52),ngH,m3h1x1(:,22),heltab2x1(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(52),63,nMB,G2tensor(30),n2h1(58))
  call Hotf_4pt_reduction(G2H1(7),RedSet_4(22),mass4set(:,3),  & 
G1H1(21),G1H1(20),G1H1(22),G1H1(52),G1H1(53),1)
  call HG1shiftOLR(G1H1(20),16,1)
  call Hotf_4pt_reduction(G2H1(9),RedSet_4(23),mass4set(:,3),  & 
G1H1(54),G1H1(55),G1H1(56),G1H1(57),G1H1(58),1)
  call HG1shiftOLR(G1H1(55),16,1)
  call Hloop_AS_Q(ntryL,G1H1(31),ex5(:),G1H1(59),ngH,m3h1x1(:,23),heltab2x1(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(59),63,nMB,G2tensor(31),n2h1(59))
  call Hloop_AS_Q(ntryL,G1H1(32),ex5(:),G1H1(31),ngH,m3h1x1(:,24),heltab2x1(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(31),63,nMB,G2tensor(32),n2h1(60))
  call Hloop_AS_Q(ntryL,G1H1(33),ex5(:),G1H1(59),ngH,m3h1x1(:,25),heltab2x1(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(59),63,nMB,G2tensor(33),n2h1(61))
  call Hotf_4pt_reduction(G2H1(10),RedSet_4(25),mass4set(:,5),  & 
G1H1(32),G1H1(31),G1H1(33),G1H1(59),G1H1(60),1)
  call HG1shiftOLR(G1H1(31),16,1)
  call Hotf_4pt_reduction(G2H1(12),RedSet_4(19),mass4set(:,1),  & 
G1H1(61),G1H1(62),G1H1(63),G1H1(64),G1H1(65),1)
  call HG1shiftOLR(G1H1(62),16,1)
  call Hloop_QS_A(ntryL,G1H1(42),ex5(:),G1H1(66),ngH,m3h1x1(:,26),heltab2x1(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(66),63,nMB,G2tensor(34),n2h1(62))
  call Hloop_QS_A(ntryL,G1H1(43),ex5(:),G1H1(42),ngH,m3h1x1(:,27),heltab2x1(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),63,nMB,G2tensor(35),n2h1(63))
  call Hloop_QS_A(ntryL,G1H1(44),ex5(:),G1H1(66),ngH,m3h1x1(:,28),heltab2x1(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(66),63,nMB,G2tensor(36),n2h1(64))
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(2),mass4set(:,2),  & 
G1H2(24),G1H2(25),G1H2(26),G1H2(46),G1H2(47),2)
  call HG1shiftOLR(G1H2(25),20,2)
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(4),mass4set(:,2),  & 
G1H2(48),G1H2(49),G1H2(50),G1H2(51),G1H2(52),2)
  call HG1shiftOLR(G1H2(49),24,2)
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(3),mass4set(:,3),  & 
G1H4(14),G1H4(12),G1H4(3),G1H4(6),G1H4(15),4)
  call HG1shiftOLR(G1H4(12),19,4)
  call Hotf_4pt_reduction(G2H4(8),RedSet_4(5),mass4set(:,3),  & 
G1H4(16),G1H4(17),G1H4(18),G1H4(19),G1H4(20),4)
  call HG1shiftOLR(G1H4(17),19,4)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(13),ex3(:),G2tensor(37),m3h2x1(:,27),heltab2x2(:,:,35))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(15),ex3(:),G2tensor(38),m3h2x1(:,28),heltab2x2(:,:,36))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(16),ex4(:),G2tensor(39),m3h2x1(:,29),heltab2x2(:,:,37))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(18),ex4(:),G2tensor(40),m3h2x1(:,30),heltab2x2(:,:,38))
  call Hloop_VA_Q(ntryL,G1H2(12),ex4(:),G1H1(43),m3h2x1(:,31),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(43),63,nMB,G2tensor(41),n2h1(65))
  call Hloop_VA_Q(ntryL,G1H2(17),ex4(:),G1H1(42),m3h2x1(:,32),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),8,nMB,G2tensor(42),n2h1(66))
  call Hloop_VA_Q(ntryL,G1H2(9),ex4(:),G1H1(44),m3h2x1(:,33),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(44),63,nMB,G2tensor(43),n2h1(67))
  call Hloop_VQ_A(ntryL,G1H2(23),ex3(:),G1H1(66),m3h2x1(:,34),heltab2x2(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(66),63,nMB,G2tensor(44),n2h1(68))
  call Hloop_VQ_A(ntryL,G1H2(1),ex3(:),G1H1(43),m3h2x1(:,35),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(43),4,nMB,G2tensor(45),n2h1(69))
  call Hloop_VQ_A(ntryL,G1H2(11),ex3(:),G1H1(42),m3h2x1(:,36),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),63,nMB,G2tensor(46),n2h1(70))
  call Hloop_VQ_A(ntryL,G1H2(10),ex3(:),G1H1(44),m3h2x1(:,37),heltab2x2(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(44),63,nMB,G2tensor(47),n2h1(71))
  call Hloop_VQ_A(ntryL,G1H2(3),ex3(:),G1H1(66),m3h2x1(:,38),heltab2x2(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(66),4,nMB,G2tensor(48),n2h1(72))
  call Hloop_VQ_A(ntryL,G1H2(5),ex3(:),G1H1(43),m3h2x1(:,39),heltab2x2(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(43),63,nMB,G2tensor(49),n2h1(73))
  call Hloop_QS_A(ntryL,G1H1(34),ex5(:),G1H1(42),ngH,m3h1x1(:,29),heltab2x1(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),63,nMB,G2tensor(50),n2h1(74))
  call Hloop_QS_A(ntryL,G1H1(12),ex5(:),G1H1(44),ngH,m3h1x1(:,30),heltab2x1(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(44),16,nMB,G2tensor(51),n2h1(75))
  call Hloop_QS_A(ntryL,G1H1(40),ex5(:),G1H1(66),ngH,m3h1x1(:,31),heltab2x1(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(66),63,nMB,G2tensor(52),n2h1(76))
  call Hloop_AZ_Q(ntryL,G1H4(9),wf4(:,3),G1H1(43),ngZd,m3h4x1(:,11),heltab2x4(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(43),63,nMB,G2tensor(53),n2h1(77))
  call Hloop_AZ_Q(ntryL,G1H4(2),wf4(:,3),G1H1(34),ngZd,m3h4x1(:,12),heltab2x4(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(34),3,nMB,G2tensor(54),n2h1(78))
  call Hloop_AZ_Q(ntryL,G1H4(1),wf4(:,3),G1H1(42),ngZd,m3h4x1(:,13),heltab2x4(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),63,nMB,G2tensor(55),n2h1(79))
  call Hloop_AS_Q(ntryL,G1H1(13),ex5(:),G1H1(12),ngH,m3h1x1(:,32),heltab2x1(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(12),63,nMB,G2tensor(56),n2h1(80))
  call Hloop_AS_Q(ntryL,G1H1(41),ex5(:),G1H1(44),ngH,m3h1x1(:,33),heltab2x1(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(44),16,nMB,G2tensor(57),n2h1(81))
  call Hloop_AS_Q(ntryL,G1H1(2),ex5(:),G1H1(40),ngH,m3h1x1(:,34),heltab2x1(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(40),63,nMB,G2tensor(58),n2h1(82))
  call Hloop_VA_Q(ntryL,G1H2(6),ex4(:),G1H1(66),m3h2x1(:,40),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(66),63,nMB,G2tensor(59),n2h1(83))
  call Hloop_VA_Q(ntryL,G1H2(18),ex4(:),G1H1(43),m3h2x1(:,41),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(43),8,nMB,G2tensor(60),n2h1(84))
  call Hloop_VA_Q(ntryL,G1H2(28),ex4(:),G1H1(34),m3h2x1(:,42),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(34),63,nMB,G2tensor(61),n2h1(85))
  call Hloop_AS_Q(ntryL,G1H1(19),ex5(:),G1H1(42),ngH,m3h1x1(:,35),heltab2x1(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),63,nMB,G2tensor(62),n2h1(86))
  call Hloop_AS_Q(ntryL,G1H1(17),ex5(:),G1H1(13),ngH,m3h1x1(:,36),heltab2x1(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(13),16,nMB,G2tensor(63),n2h1(87))
  call Hloop_AS_Q(ntryL,G1H1(24),ex5(:),G1H1(12),ngH,m3h1x1(:,37),heltab2x1(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(12),63,nMB,G2tensor(64),n2h1(88))
  call Hloop_QZ_A(ntryL,G1H4(11),wf4(:,3),G1H1(41),ngZd,m3h4x1(:,14),heltab2x4(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(41),63,nMB,G2tensor(65),n2h1(89))
  call Hloop_QZ_A(ntryL,G1H4(7),wf4(:,3),G1H1(44),ngZd,m3h4x1(:,15),heltab2x4(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(44),3,nMB,G2tensor(66),n2h1(90))
  call Hloop_QZ_A(ntryL,G1H4(4),wf4(:,3),G1H1(2),ngZd,m3h4x1(:,16),heltab2x4(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(2),63,nMB,G2tensor(67),n2h1(91))
  call Hloop_QS_A(ntryL,G1H1(28),ex5(:),G1H1(40),ngH,m3h1x1(:,38),heltab2x1(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(40),63,nMB,G2tensor(68),n2h1(92))
  call Hloop_QS_A(ntryL,G1H1(29),ex5(:),G1H1(66),ngH,m3h1x1(:,39),heltab2x1(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(66),16,nMB,G2tensor(69),n2h1(93))
  call Hloop_QS_A(ntryL,G1H1(16),ex5(:),G1H1(43),ngH,m3h1x1(:,40),heltab2x1(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(43),63,nMB,G2tensor(70),n2h1(94))
  call Hloop_VA_Q(ntryL,G1H2(29),ex4(:),G1H1(34),m3h2x1(:,43),heltab2x2(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(34),63,nMB,G2tensor(71),n2h1(95))
  call Hloop_VA_Q(ntryL,G1H2(30),ex4(:),G1H1(19),m3h2x1(:,44),heltab2x2(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),8,nMB,G2tensor(72),n2h1(96))
  call Hloop_VA_Q(ntryL,G1H2(33),ex4(:),G1H1(42),m3h2x1(:,45),heltab2x2(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),63,nMB,G2tensor(73),n2h1(97))
  call Hloop_VA_Q(ntryL,G1H2(34),ex4(:),G1H1(17),m3h2x1(:,46),heltab2x2(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),63,nMB,G2tensor(74),n2h1(98))
  call Hloop_VA_Q(ntryL,G1H2(35),ex4(:),G1H1(13),m3h2x1(:,47),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(13),8,nMB,G2tensor(75),n2h1(99))
  call Hloop_VA_Q(ntryL,G1H2(38),ex4(:),G1H1(24),m3h2x1(:,48),heltab2x2(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(24),63,nMB,G2tensor(76),n2h1(100))
  call Hloop_VQ_A(ntryL,G1H2(13),ex3(:),G1H1(12),m3h2x1(:,49),heltab2x2(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(12),63,nMB,G2tensor(77),n2h1(101))
  call Hloop_VQ_A(ntryL,G1H2(14),ex3(:),G1H1(41),m3h2x1(:,50),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(41),4,nMB,G2tensor(78),n2h1(102))
  call Hloop_VQ_A(ntryL,G1H2(40),ex3(:),G1H1(44),m3h2x1(:,51),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(44),63,nMB,G2tensor(79),n2h1(103))
  call Hloop_VQ_A(ntryL,G1H2(41),ex3(:),G1H1(2),m3h2x1(:,52),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(2),63,nMB,G2tensor(80),n2h1(104))
  call Hloop_VQ_A(ntryL,G1H2(42),ex3(:),G1H1(28),m3h2x1(:,53),heltab2x2(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(28),4,nMB,G2tensor(81),n2h1(105))
  call Hloop_VQ_A(ntryL,G1H2(45),ex3(:),G1H1(40),m3h2x1(:,54),heltab2x2(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(40),63,nMB,G2tensor(82),n2h1(106))
  call Hloop_QS_A(ntryL,G1H1(25),ex5(:),G1H1(29),ngH,m3h1x1(:,41),heltab2x1(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(29),63,nMB,G2tensor(83),n2h1(107))
  call Hloop_QS_A(ntryL,G1H1(26),ex5(:),G1H1(66),ngH,m3h1x1(:,42),heltab2x1(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(66),16,nMB,G2tensor(84),n2h1(108))
  call Hloop_QS_A(ntryL,G1H1(27),ex5(:),G1H1(16),ngH,m3h1x1(:,43),heltab2x1(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(16),63,nMB,G2tensor(85),n2h1(109))
  call Hloop_QS_A(ntryL,G1H1(38),ex5(:),G1H1(43),ngH,m3h1x1(:,44),heltab2x1(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(43),63,nMB,G2tensor(86),n2h1(110))
  call Hloop_QS_A(ntryL,G1H1(3),ex5(:),G1H1(34),ngH,m3h1x1(:,45),heltab2x1(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(34),16,nMB,G2tensor(87),n2h1(111))
  call Hloop_QS_A(ntryL,G1H1(15),ex5(:),G1H1(19),ngH,m3h1x1(:,46),heltab2x1(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),63,nMB,G2tensor(88),n2h1(112))
  call Hloop_AS_Q(ntryL,G1H1(10),ex5(:),G1H1(42),ngH,m3h1x1(:,47),heltab2x1(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),63,nMB,G2tensor(89),n2h1(113))
  call Hloop_AS_Q(ntryL,G1H1(9),ex5(:),G1H1(17),ngH,m3h1x1(:,48),heltab2x1(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),16,nMB,G2tensor(90),n2h1(114))
  call Hloop_AS_Q(ntryL,G1H1(46),ex5(:),G1H1(13),ngH,m3h1x1(:,49),heltab2x1(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(13),63,nMB,G2tensor(91),n2h1(115))
  call Hloop_AS_Q(ntryL,G1H1(47),ex5(:),G1H1(24),ngH,m3h1x1(:,50),heltab2x1(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(24),63,nMB,G2tensor(92),n2h1(116))
  call Hloop_AS_Q(ntryL,G1H1(48),ex5(:),G1H1(12),ngH,m3h1x1(:,51),heltab2x1(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(12),16,nMB,G2tensor(93),n2h1(117))
  call Hloop_AS_Q(ntryL,G1H1(51),ex5(:),G1H1(41),ngH,m3h1x1(:,52),heltab2x1(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(41),63,nMB,G2tensor(94),n2h1(118))
  call Hloop_AS_Q(ntryL,G1H1(21),ex5(:),G1H1(44),ngH,m3h1x1(:,53),heltab2x1(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(44),63,nMB,G2tensor(95),n2h1(119))
  call Hloop_AS_Q(ntryL,G1H1(20),ex5(:),G1H1(2),ngH,m3h1x1(:,54),heltab2x1(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),16,nMB,G2tensor(96),n2h1(120))
  call Hloop_AS_Q(ntryL,G1H1(53),ex5(:),G1H1(28),ngH,m3h1x1(:,55),heltab2x1(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(28),63,nMB,G2tensor(97),n2h1(121))
  call Hloop_AS_Q(ntryL,G1H1(54),ex5(:),G1H1(40),ngH,m3h1x1(:,56),heltab2x1(:,:,56))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(40),63,nMB,G2tensor(98),n2h1(122))
  call Hloop_AS_Q(ntryL,G1H1(55),ex5(:),G1H1(25),ngH,m3h1x1(:,57),heltab2x1(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(25),16,nMB,G2tensor(99),n2h1(123))
  call Hloop_AS_Q(ntryL,G1H1(58),ex5(:),G1H1(29),ngH,m3h1x1(:,58),heltab2x1(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(29),63,nMB,G2tensor(100),n2h1(124))
  call Hloop_QS_A(ntryL,G1H1(32),ex5(:),G1H1(26),ngH,m3h1x1(:,59),heltab2x1(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(26),63,nMB,G2tensor(101),n2h1(125))
  call Hloop_QS_A(ntryL,G1H1(31),ex5(:),G1H1(66),ngH,m3h1x1(:,60),heltab2x1(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(66),16,nMB,G2tensor(102),n2h1(126))
  call Hloop_QS_A(ntryL,G1H1(60),ex5(:),G1H1(27),ngH,m3h1x1(:,61),heltab2x1(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(27),63,nMB,G2tensor(103),n2h1(127))
  call Hloop_QS_A(ntryL,G1H1(61),ex5(:),G1H1(16),ngH,m3h1x1(:,62),heltab2x1(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(16),63,nMB,G2tensor(104),n2h1(128))
  call Hloop_QS_A(ntryL,G1H1(62),ex5(:),G1H1(38),ngH,m3h1x1(:,63),heltab2x1(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(38),16,nMB,G2tensor(105),n2h1(129))
  call Hloop_QS_A(ntryL,G1H1(65),ex5(:),G1H1(43),ngH,m3h1x1(:,64),heltab2x1(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(43),63,nMB,G2tensor(106),n2h1(130))
  call Hloop_VQ_A(ntryL,G1H2(24),wf2(:,2),G1H1(3),m3h2x1(:,55),heltab2x2(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(3),63,nMB,G2tensor(107),n2h1(131))
  call Hloop_VQ_A(ntryL,G1H2(25),wf2(:,2),G1H1(34),m3h2x1(:,56),heltab2x2(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(34),20,nMB,G2tensor(108),n2h1(132))
  call Hloop_VQ_A(ntryL,G1H2(47),wf2(:,2),G1H1(15),m3h2x1(:,57),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(15),63,nMB,G2tensor(109),n2h1(133))
  call Hloop_VA_Q(ntryL,G1H2(48),wf2(:,4),G1H1(19),m3h2x1(:,58),heltab2x2(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),63,nMB,G2tensor(110),n2h1(134))
  call Hloop_VA_Q(ntryL,G1H2(49),wf2(:,4),G1H1(10),m3h2x1(:,59),heltab2x2(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(10),24,nMB,G2tensor(111),n2h1(135))
  call Hloop_VA_Q(ntryL,G1H2(52),wf2(:,4),G1H1(42),m3h2x1(:,60),heltab2x2(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),63,nMB,G2tensor(112),n2h1(136))
  call Hloop_AZ_Q(ntryL,G1H4(14),wf4(:,19),G1H1(9),ngZd,m3h4x1(:,17),heltab2x4(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),63,nMB,G2tensor(113),n2h1(137))
  call Hloop_AZ_Q(ntryL,G1H4(12),wf4(:,19),G1H1(17),ngZd,m3h4x1(:,18),heltab2x4(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),19,nMB,G2tensor(114),n2h1(138))
  call Hloop_AZ_Q(ntryL,G1H4(15),wf4(:,19),G1H1(46),ngZd,m3h4x1(:,19),heltab2x4(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(46),63,nMB,G2tensor(115),n2h1(139))
  call Hloop_QZ_A(ntryL,G1H4(16),wf4(:,19),G1H1(13),ngZd,m3h4x1(:,20),heltab2x4(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(13),63,nMB,G2tensor(116),n2h1(140))
  call Hloop_QZ_A(ntryL,G1H4(17),wf4(:,19),G1H1(47),ngZd,m3h4x1(:,21),heltab2x4(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(47),19,nMB,G2tensor(117),n2h1(141))
  call Hloop_QZ_A(ntryL,G1H4(20),wf4(:,19),G1H1(24),ngZd,m3h4x1(:,22),heltab2x4(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(24),63,nMB,G2tensor(118),n2h1(142))
  call ol_merge_tensors(G2tensor(37),[G2tensor(2),G1tensor(2)])
  call ol_merge_tensors(G2tensor(7),[G2tensor(3),G1tensor(12),G1tensor(6)])
  call ol_merge_tensors(G2tensor(39),[G2tensor(6),G1tensor(8)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(10),G1tensor(14)])
  call ol_merge_tensors(G2tensor(107),[G2tensor(11),G1tensor(18)])
  call ol_merge_tensors(G2tensor(53),[G2tensor(14),G1tensor(20)])
  call ol_merge_tensors(G2tensor(113),[G2tensor(15),G1tensor(24)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(18),G1tensor(26)])
  call ol_merge_tensors(G2tensor(110),[G2tensor(19),G1tensor(30)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(22),G1tensor(32)])
  call ol_merge_tensors(G2tensor(116),[G2tensor(23),G1tensor(36)])
  call ol_merge_tensors(G2tensor(71),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(74),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(5)])
  call ol_merge_tensors(G2tensor(77),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(80),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(44),[G1tensor(11)])
  call ol_merge_tensors(G2tensor(83),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(86),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(62),[G2tensor(50),G1tensor(29),G1tensor(17)])
  call ol_merge_tensors(G2tensor(89),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(104),[G2tensor(92),G1tensor(34),G1tensor(22)])
  call ol_merge_tensors(G2tensor(56),[G1tensor(23)])
  call ol_merge_tensors(G2tensor(95),[G1tensor(27)])
  call ol_merge_tensors(G2tensor(98),[G1tensor(28)])
  call ol_merge_tensors(G2tensor(101),[G1tensor(33)])
  call ol_merge_tensors(G2tensor(68),[G1tensor(35)])
  call Hotf_4pt_reduction_last(G2tensor(37),RedSet_4(28),mass4set(:,4),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25))
  call G_TensorShift(G1tensor(7),4)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(1),mass4set(:,1),  & 
G1tensor(31),G1tensor(2),G1tensor(12),G1tensor(6),G1tensor(8))
  call G_TensorShift(G1tensor(2),12)
  call Hotf_4pt_reduction_last(G2tensor(39),RedSet_4(29),mass4set(:,4),  & 
G1tensor(14),G1tensor(18),G1tensor(20),G1tensor(24),G1tensor(26))
  call G_TensorShift(G1tensor(18),8)
  call Hotf_4pt_reduction_last(G2tensor(47),RedSet_4(30),mass4set(:,2),  & 
G1tensor(30),G1tensor(32),G1tensor(36),G1tensor(3),G1tensor(4))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_4pt_reduction_last(G2tensor(107),RedSet_4(2),mass4set(:,2),  & 
G1tensor(5),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(15))
  call G_TensorShift(G1tensor(9),20)
  call Hotf_4pt_reduction_last(G2tensor(53),RedSet_4(31),mass4set(:,3),  & 
G1tensor(16),G1tensor(29),G1tensor(17),G1tensor(21),G1tensor(34))
  call G_TensorShift(G1tensor(29),3)
  call Hotf_4pt_reduction_last(G2tensor(113),RedSet_4(3),mass4set(:,3),  & 
G1tensor(22),G1tensor(23),G1tensor(27),G1tensor(28),G1tensor(33))
  call G_TensorShift(G1tensor(23),19)
  call Hotf_4pt_reduction_last(G2tensor(59),RedSet_4(32),mass4set(:,2),  & 
G1tensor(35),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
  call G_TensorShift(G1tensor(37),8)
  call Hotf_4pt_reduction_last(G2tensor(110),RedSet_4(4),mass4set(:,2),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
  call G_TensorShift(G1tensor(42),24)
  call Hotf_4pt_reduction_last(G2tensor(65),RedSet_4(33),mass4set(:,3),  & 
G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
  call G_TensorShift(G1tensor(47),3)
  call Hotf_4pt_reduction_last(G2tensor(116),RedSet_4(5),mass4set(:,3),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
  call G_TensorShift(G1tensor(52),19)
  call Hotf_4pt_reduction_last(G2tensor(71),RedSet_4(6),mass4set(:,2),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(57),8)
  call Hotf_4pt_reduction_last(G2tensor(74),RedSet_4(7),mass4set(:,2),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_4pt_reduction_last(G2tensor(41),RedSet_4(8),mass4set(:,2),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
  call G_TensorShift(G1tensor(67),8)
  call Hotf_4pt_reduction_last(G2tensor(77),RedSet_4(10),mass4set(:,2),  & 
G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75))
  call G_TensorShift(G1tensor(72),4)
  call Hotf_4pt_reduction_last(G2tensor(80),RedSet_4(11),mass4set(:,2),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
  call G_TensorShift(G1tensor(77),4)
  call Hotf_4pt_reduction_last(G2tensor(44),RedSet_4(12),mass4set(:,2),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
  call G_TensorShift(G1tensor(82),4)
  call Hotf_4pt_reduction_last(G2tensor(83),RedSet_4(14),mass4set(:,3),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(87),16)
  call Hotf_4pt_reduction_last(G2tensor(86),RedSet_4(15),mass4set(:,3),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
  call G_TensorShift(G1tensor(92),16)
  call Hotf_4pt_reduction_last(G2tensor(62),RedSet_4(16),mass4set(:,1),  & 
G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
  call G_TensorShift(G1tensor(97),16)
  call Hotf_4pt_reduction_last(G2tensor(89),RedSet_4(18),mass4set(:,5),  & 
G1tensor(101),G1tensor(102),G1tensor(103),G1tensor(104),G1tensor(105))
  call G_TensorShift(G1tensor(102),16)
  call Hotf_4pt_reduction_last(G2tensor(104),RedSet_4(19),mass4set(:,1),  & 
G1tensor(106),G1tensor(107),G1tensor(108),G1tensor(109),G1tensor(110))
  call G_TensorShift(G1tensor(107),16)
  call Hotf_4pt_reduction_last(G2tensor(56),RedSet_4(20),mass4set(:,3),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115))
  call G_TensorShift(G1tensor(112),16)
  call Hotf_4pt_reduction_last(G2tensor(95),RedSet_4(22),mass4set(:,3),  & 
G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(117),16)
  call Hotf_4pt_reduction_last(G2tensor(98),RedSet_4(23),mass4set(:,3),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125))
  call G_TensorShift(G1tensor(122),16)
  call Hotf_4pt_reduction_last(G2tensor(101),RedSet_4(25),mass4set(:,5),  & 
G1tensor(126),G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130))
  call G_TensorShift(G1tensor(127),16)
  call Hotf_4pt_reduction_last(G2tensor(68),RedSet_4(26),mass4set(:,3),  & 
G1tensor(131),G1tensor(132),G1tensor(133),G1tensor(134),G1tensor(135))
  call G_TensorShift(G1tensor(132),16)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(28),mass4set(:,4),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(1),mass4set(:,1),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(14),RedSet_4(29),mass4set(:,4),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(30),RedSet_4(30),mass4set(:,2),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(5),RedSet_4(2),mass4set(:,2),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(31),mass4set(:,3),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(22),RedSet_4(3),mass4set(:,3),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(35),RedSet_4(32),mass4set(:,2),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(4),mass4set(:,2),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(33),mass4set(:,3),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(5),mass4set(:,3),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(6),mass4set(:,2),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(7),mass4set(:,2),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(8),mass4set(:,2),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(10),mass4set(:,2),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(11),mass4set(:,2),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(12),mass4set(:,2),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(14),mass4set(:,3),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(15),mass4set(:,3),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(16),mass4set(:,1),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(18),mass4set(:,5),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(19),mass4set(:,1),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(20),mass4set(:,3),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(22),mass4set(:,3),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
  call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(23),mass4set(:,3),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
  call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(25),mass4set(:,5),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
  call Hotf_4pt_reduction_last(G1tensor(131),RedSet_4(26),mass4set(:,3),  & 
G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  call ol_merge_tensors(T0sum(21),[G0tensor(101)])
  call ol_merge_tensors(T0sum(22),[G0tensor(106)])
  call ol_merge_tensors(T0sum(23),[G0tensor(111)])
  call ol_merge_tensors(T0sum(24),[G0tensor(116)])
  call ol_merge_tensors(T0sum(25),[G0tensor(121)])
  call ol_merge_tensors(T0sum(26),[G0tensor(126)])
  call ol_merge_tensors(T0sum(27),[G0tensor(131)])
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(71)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[40,3,20],[nMB,nMB,0],3,3,wf4(:,4),wf4(:,3),wf2(:,2))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,4),G0H8(1),m3h4x8(:,5),heltab2x32(:,:,21))
  call Hloop_A_Q(ntryL,G0H8(1),40,nMB,G1H8(1),n2h8(3))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[32,11,20],[nMB,0,nMB],3,2,wf8(:,3),wf2(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,17),heltab2x32(:,:,22))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(1),n2h16(17))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[52,3,8],[nMB,nMB,0],3,2,wf4(:,16),wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,16),G0H8(2),m3h4x8(:,6),heltab2x32(:,:,23))
  call Hloop_Q_A(ntryL,G0H8(2),52,nMB,G1H8(2),n2h8(4))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(42)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[32,8,23],[nMB,0,nMB],3,1,wf8(:,20))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,18),heltab2x32(:,:,24))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(2),n2h16(18))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(72)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[36,3,24],[nMB,nMB,0],3,3,wf4(:,7),wf4(:,3),wf2(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,7),G0H8(1),m3h4x8(:,7),heltab2x32(:,:,25))
  call Hloop_Q_A(ntryL,G0H8(1),36,nMB,G1H8(3),n2h8(5))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[32,7,24],[nMB,0,nMB],3,2,wf8(:,5),wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(3),n2h16(19))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[56,3,4],[nMB,nMB,0],3,2,wf4(:,23),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,23),G0H8(2),m3h4x8(:,8),heltab2x32(:,:,27))
  call Hloop_A_Q(ntryL,G0H8(2),56,nMB,G1H8(4),n2h8(6))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(49)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[32,4,27],[nMB,0,nMB],3,1,wf8(:,23))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,20),heltab2x32(:,:,28))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(4),n2h16(20))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[36,11,16],[0,nMB,nMB],3,2,wf4(:,7),wf8(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,7),G0H8(1),m3h4x8(:,9),heltab2x32(:,:,29))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[36,8,19],[0,nMB,nMB],3,2,wf4(:,7),wf4(:,19))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,7),G0H8(2),m3h4x8(:,10),heltab2x32(:,:,30))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[52,3,8],[nMB,nMB,0],3,2,wf4(:,20),wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,20),G0H8(3),m3h4x8(:,11),heltab2x32(:,:,31))
  call Hloop_Q_A(ntryL,G0H8(3),52,nMB,G1H8(5),n2h8(7))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(52)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[39,8,16],[0,nMB,nMB],3,1,wf16(:,6))
  call Hloop_AQ_V(ntryL,G0H32(1),wf16(:,6),G0H2(1),m3h16x2(:,1),heltab2x32(:,:,32))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(20)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(33),h0tab(:,33),[40,7,16],[0,nMB,nMB],3,2,wf4(:,4),wf8(:,5))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,4),G0H8(3),m3h4x8(:,12),heltab2x32(:,:,33))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(34),h0tab(:,34),[40,4,19],[0,nMB,nMB],3,2,wf4(:,4),wf4(:,19))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,4),G0H8(4),m3h4x8(:,13),heltab2x32(:,:,34))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(35),h0tab(:,35),[56,3,4],[nMB,nMB,0],3,2,wf4(:,26),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,26),G0H8(5),m3h4x8(:,14),heltab2x32(:,:,35))
  call Hloop_A_Q(ntryL,G0H8(5),56,nMB,G1H8(6),n2h8(8))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(39)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(36),h0tab(:,36),[43,4,16],[0,nMB,nMB],3,1,wf16(:,5))
  call Hloop_QA_V(ntryL,G0H32(1),wf16(:,5),G0H2(2),m3h16x2(:,2),heltab2x32(:,:,36))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(65)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(37),h0tab(:,37),[32,8,23],[nMB,0,nMB],3,1,wf8(:,28))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,21),heltab2x32(:,:,37))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(5),n2h16(21))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(66)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(38),h0tab(:,38),[39,8,16],[0,nMB,nMB],3,1,wf16(:,8))
  call Hloop_AQ_V(ntryL,G0H32(1),wf16(:,8),G0H2(3),m3h16x2(:,3),heltab2x32(:,:,38))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(67)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(39),h0tab(:,39),[32,4,27],[nMB,0,nMB],3,1,wf8(:,30))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,22),heltab2x32(:,:,39))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(6),n2h16(22))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(68)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(40),h0tab(:,40),[43,4,16],[0,nMB,nMB],3,1,wf16(:,10))
  call Hloop_QA_V(ntryL,G0H32(1),wf16(:,10),G0H2(4),m3h16x2(:,4),heltab2x32(:,:,40))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(69)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(41),h0tab(:,41),[32,8,23],[nMB,0,nMB],3,1,wf8(:,32))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,41))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(7),n2h16(23))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(70)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(42),h0tab(:,42),[32,4,27],[nMB,0,nMB],3,1,wf8(:,34))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,24),heltab2x32(:,:,42))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(8),n2h16(24))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(5),[G1H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(6),[G1H8(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(3),[G0H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(4),[G0H2(2)])
  call Hloop_AS_Q(ntryL,G1H2(16),ex5(:),G1H2(12),ngH,m3h1x2(:,9),heltab2x2(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(12),59,nMB,G2H2(2),n2h2(13))
  call Hloop_QS_A(ntryL,G1H2(21),ex5(:),G1H2(17),ngH,m3h1x2(:,10),heltab2x2(:,:,70))
  call Hloop_Q_A(ntryL,G1H2(17),55,nMB,G2H2(7),n2h2(14))
  call Hloop_AZ_Q(ntryL,G1H8(1),wf4(:,3),G1H2(9),ngZd,m3h4x2(:,3),heltab2x8(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(9),43,nMB,G2H2(9),n2h2(15))
  call Hloop_QA_V(ntryL,G1H16(1),wf8(:,3),G1H2(23),m3h8x2(:,3),heltab2x16(:,:,17))
  call Hloop_QZ_A(ntryL,G1H8(5),wf4(:,3),G1H2(1),ngZd,m3h4x2(:,4),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMB,G2H2(4),n2h2(16))
  call Hloop_QA_V(ntryL,G1H16(2),ex4(:),G1H8(2),m3h2x8(:,7),heltab2x16(:,:,18))
  call Hloop_QZ_A(ntryL,G1H8(3),wf4(:,3),G1H2(11),ngZd,m3h4x2(:,5),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(11),39,nMB,G2H2(10),n2h2(17))
  call Hloop_AQ_V(ntryL,G1H16(3),wf8(:,5),G1H2(10),m3h8x2(:,4),heltab2x16(:,:,19))
  call Hloop_AZ_Q(ntryL,G1H8(6),wf4(:,3),G1H2(3),ngZd,m3h4x2(:,6),heltab2x8(:,:,14))
  call Hloop_A_Q(ntryL,G1H2(3),59,nMB,G2H2(11),n2h2(18))
  call Hloop_AQ_V(ntryL,G1H16(4),ex3(:),G1H8(4),m3h2x8(:,8),heltab2x16(:,:,20))
  call Hloop_VA_Q(ntryL,G0H8(1),wf8(:,3),G0H1(1),m3h8x1(:,3),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G0H1(1),47,nMB,G1H1(48),n2h1(143))
  call Hloop_VA_Q(ntryL,G0H8(2),ex4(:),G0H4(1),m3h2x4(:,7),heltab2x8(:,:,16))
  call Hloop_A_Q(ntryL,G0H4(1),44,nMB,G1H4(9),n2h4(29))
  call Hloop_VA_Q(ntryL,G0H2(3),ex4(:),G0H1(1),m3h2x1(:,61),heltab2x2(:,:,71))
  call Hloop_A_Q(ntryL,G0H1(1),47,nMB,G1H1(12),n2h1(144))
  call Hloop_VQ_A(ntryL,G0H8(3),wf8(:,5),G0H1(1),m3h8x1(:,4),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G0H1(1),47,nMB,G1H1(51),n2h1(145))
  call Hloop_VQ_A(ntryL,G0H8(4),ex3(:),G0H4(1),m3h2x4(:,8),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G0H4(1),44,nMB,G1H4(2),n2h4(30))
  call Hloop_VQ_A(ntryL,G0H2(4),ex3(:),G0H1(1),m3h2x1(:,62),heltab2x2(:,:,72))
  call Hloop_Q_A(ntryL,G0H1(1),47,nMB,G1H1(41),n2h1(146))
  call Hloop_QA_V(ntryL,G1H16(5),ex4(:),G1H8(1),m3h2x8(:,9),heltab2x16(:,:,21))
  call Hloop_AQ_V(ntryL,G1H16(6),ex3(:),G1H8(5),m3h2x8(:,10),heltab2x16(:,:,22))
  call Hloop_QA_V(ntryL,G1H16(7),ex4(:),G1H8(3),m3h2x8(:,11),heltab2x16(:,:,23))
  call Hloop_AQ_V(ntryL,G1H16(8),ex3(:),G1H8(6),m3h2x8(:,12),heltab2x16(:,:,24))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(49),[G1H1(11)])
call HGT_w2_OLR(G1H1(30),1,1,1)
call HGT_w2_invQ_OLR(G1H1(30),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(30),[G1H1(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(63),[G1H1(33)])
call HGT_w2_OLR(G1H1(39),1,1,1)
call HGT_w2_invQ_OLR(G1H1(39),2,5,1)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(39),[G1H1(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(32),[G1H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(37),[G1H2(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(39),[G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(44),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(43),[G1H2(15),G1H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(37),[G1H1(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(64),[G1H1(14),G1H1(5),G1H1(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(48),[G1H1(45),G1H1(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(57),[G1H1(50),G1H1(7),G1H1(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(36),[G1H2(31),G1H2(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(52),[G1H1(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(51),[G1H1(59),G1H1(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(41),[G1H1(4),G1H1(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H1(12),[G1H1(56),G1H1(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(23),[G1H2(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(10),[G1H2(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(9),[G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G1H4(18)])
  call Hloop_AS_Q(ntryL,G1H1(30),ex5(:),G1H1(21),ngH,m3h1x1(:,65),heltab2x1(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(21),63,nMB,G2tensor(2),n2h1(147))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(14),ex3(:),G2tensor(3),m3h2x1(:,63),heltab2x2(:,:,73))
  call Hloop_QS_A(ntryL,G1H1(39),ex5(:),G1H1(44),ngH,m3h1x1(:,66),heltab2x1(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(44),63,nMB,G2tensor(6),n2h1(148))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(17),ex4(:),G2tensor(10),m3h2x1(:,64),heltab2x2(:,:,74))
  call Hloop_VA_Q(ntryL,G1H2(32),ex4(:),G1H1(20),m3h2x1(:,65),heltab2x2(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(20),63,nMB,G2tensor(11),n2h1(149))
  call Hloop_VA_Q(ntryL,G1H2(37),ex4(:),G1H1(2),m3h2x1(:,66),heltab2x2(:,:,76))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),63,nMB,G2tensor(14),n2h1(150))
  call Hloop_VQ_A(ntryL,G1H2(39),ex3(:),G1H1(53),m3h2x1(:,67),heltab2x2(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(53),63,nMB,G2tensor(15),n2h1(151))
  call Hloop_VQ_A(ntryL,G1H2(44),ex3(:),G1H1(28),m3h2x1(:,68),heltab2x2(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(28),63,nMB,G2tensor(18),n2h1(152))
  call Hloop_VQ_A(ntryL,G1H2(43),ex3(:),G1H1(54),m3h2x1(:,69),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(54),63,nMB,G2tensor(19),n2h1(153))
  call Hloop_VQ_A(ntryL,G1H2(20),ex3(:),G1H1(40),m3h2x1(:,70),heltab2x2(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(40),63,nMB,G2tensor(22),n2h1(154))
  call Hloop_QS_A(ntryL,G1H1(37),ex5(:),G1H1(55),ngH,m3h1x1(:,67),heltab2x1(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(55),63,nMB,G2tensor(23),n2h1(155))
  call Hloop_QS_A(ntryL,G1H1(64),ex5(:),G1H1(25),ngH,m3h1x1(:,68),heltab2x1(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(25),63,nMB,G2tensor(50),n2h1(156))
  call Hloop_AZ_Q(ntryL,G1H4(8),wf4(:,3),G1H1(58),ngZd,m3h4x1(:,23),heltab2x4(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(58),63,nMB,G2tensor(92),n2h1(157))
  call Hloop_AZ_Q(ntryL,G1H4(10),wf4(:,3),G1H1(29),ngZd,m3h4x1(:,24),heltab2x4(:,:,54))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(29),63,nMB,G2tensor(37),n2h1(158))
  call Hloop_AS_Q(ntryL,G1H1(48),ex5(:),G1H1(32),ngH,m3h1x1(:,69),heltab2x1(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(32),63,nMB,G2tensor(7),n2h1(159))
  call Hloop_AS_Q(ntryL,G1H1(57),ex5(:),G1H1(26),ngH,m3h1x1(:,70),heltab2x1(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(26),63,nMB,G2tensor(39),n2h1(160))
  call Hloop_VA_Q(ntryL,G1H2(36),ex4(:),G1H1(31),m3h2x1(:,71),heltab2x2(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(31),63,nMB,G2tensor(47),n2h1(161))
  call Hloop_VA_Q(ntryL,G1H2(27),ex4(:),G1H1(66),m3h2x1(:,72),heltab2x2(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(66),63,nMB,G2tensor(107),n2h1(162))
  call Hloop_AS_Q(ntryL,G1H1(52),ex5(:),G1H1(60),ngH,m3h1x1(:,71),heltab2x1(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(60),63,nMB,G2tensor(53),n2h1(163))
  call Hloop_QZ_A(ntryL,G1H4(5),wf4(:,3),G1H1(27),ngZd,m3h4x1(:,25),heltab2x4(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(27),63,nMB,G2tensor(113),n2h1(164))
  call Hloop_QZ_A(ntryL,G1H4(13),wf4(:,3),G1H1(61),ngZd,m3h4x1(:,26),heltab2x4(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(61),63,nMB,G2tensor(59),n2h1(165))
  call Hloop_QS_A(ntryL,G1H1(51),ex5(:),G1H1(16),ngH,m3h1x1(:,72),heltab2x1(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(16),63,nMB,G2tensor(110),n2h1(166))
  call Hloop_QS_A(ntryL,G1H1(41),ex5(:),G1H1(62),ngH,m3h1x1(:,73),heltab2x1(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(62),63,nMB,G2tensor(65),n2h1(167))
  call Hloop_AS_Q(ntryL,G1H1(12),ex5(:),G1H1(38),ngH,m3h1x1(:,74),heltab2x1(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(38),63,nMB,G2tensor(116),n2h1(168))
  call Hloop_VQ_A(ntryL,G1H2(26),wf2(:,2),G1H1(65),m3h2x1(:,73),heltab2x2(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(65),63,nMB,G2tensor(71),n2h1(169))
  call Hloop_VQ_A(ntryL,G1H2(23),wf2(:,2),G1H1(43),m3h2x1(:,74),heltab2x2(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(43),63,nMB,G2tensor(74),n2h1(170))
  call Hloop_VA_Q(ntryL,G1H2(50),wf2(:,4),G1H1(3),m3h2x1(:,75),heltab2x2(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(3),63,nMB,G2tensor(41),n2h1(171))
  call Hloop_VA_Q(ntryL,G1H2(10),wf2(:,4),G1H1(34),m3h2x1(:,76),heltab2x2(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(34),63,nMB,G2tensor(77),n2h1(172))
  call Hloop_AZ_Q(ntryL,G1H4(9),wf4(:,19),G1H1(15),ngZd,m3h4x1(:,27),heltab2x4(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(15),63,nMB,G2tensor(80),n2h1(173))
  call Hloop_AZ_Q(ntryL,G1H4(6),wf4(:,19),G1H1(19),ngZd,m3h4x1(:,28),heltab2x4(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),63,nMB,G2tensor(44),n2h1(174))
  call Hloop_QZ_A(ntryL,G1H4(2),wf4(:,19),G1H1(10),ngZd,m3h4x1(:,29),heltab2x4(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(10),63,nMB,G2tensor(83),n2h1(175))
  call Hloop_QZ_A(ntryL,G1H4(19),wf4(:,19),G1H1(42),ngZd,m3h4x1(:,30),heltab2x4(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),63,nMB,G2tensor(86),n2h1(176))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(2),ex3(:),G2tensor(62),m3h2x1(:,77),heltab2x2(:,:,87))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(7),ex4(:),G2tensor(89),m3h2x1(:,78),heltab2x2(:,:,88))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(9),wf2(:,2),G2tensor(104),m3h2x1(:,79),heltab2x2(:,:,89))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(4),ex4(:),G2tensor(56),m3h2x1(:,80),heltab2x2(:,:,90))
  call Hloop_VQ_A(ntryL,G1H8(2),wf8(:,20),G1H1(9),m3h8x1(:,5),heltab2x8(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),63,nMB,G2tensor(95),n2h1(177))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(10),wf2(:,4),G2tensor(98),m3h2x1(:,81),heltab2x2(:,:,91))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(11),ex3(:),G2tensor(101),m3h2x1(:,82),heltab2x2(:,:,92))
  call Hloop_VA_Q(ntryL,G1H8(4),wf8(:,23),G1H1(17),m3h8x1(:,6),heltab2x8(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),63,nMB,G2tensor(68),n2h1(178))
  call Hloop_VQ_A(ntryL,G1H8(1),wf8(:,28),G1H1(46),m3h8x1(:,7),heltab2x8(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(46),63,nMB,G2tensor(119),n2h1(179))
  call Hloop_VA_Q(ntryL,G1H8(5),wf8(:,30),G1H1(13),m3h8x1(:,8),heltab2x8(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(13),63,nMB,G2tensor(120),n2h1(180))
  call Hloop_VQ_A(ntryL,G1H8(3),wf8(:,32),G1H1(47),m3h8x1(:,9),heltab2x8(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(47),63,nMB,G2tensor(121),n2h1(181))
  call Hloop_VA_Q(ntryL,G1H8(6),wf8(:,34),G1H1(24),m3h8x1(:,10),heltab2x8(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(24),63,nMB,G2tensor(122),n2h1(182))
  call ol_merge_tensors(G2tensor(6),[G2tensor(2),G2tensor(8),G2tensor(4),G1tensor(128),G1tensor(108),G1tensor(103),G1tensor(18) &
    ,G1tensor(2),G1tensor(7),G0tensor(128),G0tensor(108),G0tensor(103),G0tensor(12),G0tensor(7),G0tensor(2)])
  call ol_merge_tensors(G2tensor(56),[G2tensor(108),G2tensor(48),G2tensor(12),G1tensor(9),G1tensor(32),G0tensor(22) &
    ,G0tensor(17)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(114),G2tensor(96),G2tensor(54),G2tensor(16),G1tensor(117),G1tensor(63),G1tensor(58) &
    ,G1tensor(38),G1tensor(23),G1tensor(29),G0tensor(117),G0tensor(63),G0tensor(58),G0tensor(38),G0tensor(32),G0tensor(27)])
  call ol_merge_tensors(G2tensor(101),[G2tensor(111),G2tensor(60),G2tensor(20),G1tensor(42),G1tensor(37),G0tensor(42) &
    ,G0tensor(37)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(117),G2tensor(84),G2tensor(66),G2tensor(24),G1tensor(87),G1tensor(78),G1tensor(73) &
    ,G1tensor(52),G1tensor(47),G1tensor(36),G0tensor(87),G0tensor(78),G0tensor(73),G0tensor(52),G0tensor(47),G0tensor(18)])
  call ol_merge_tensors(G2tensor(79),[G2tensor(73),G2tensor(13),G2tensor(1),G1tensor(75),G1tensor(60),G1tensor(12),G0tensor(75) &
    ,G0tensor(60),G0tensor(8)])
  call ol_merge_tensors(G2tensor(82),[G2tensor(76),G2tensor(17),G2tensor(5),G1tensor(80),G1tensor(65),G1tensor(6),G0tensor(80) &
    ,G0tensor(65),G0tensor(9)])
  call ol_merge_tensors(G2tensor(112),[G2tensor(109),G2tensor(64),G2tensor(52),G2tensor(46),G2tensor(43),G2tensor(33),G2tensor(27) &
    ,G2tensor(21),G2tensor(9),G1tensor(100),G1tensor(85),G1tensor(70),G1tensor(45),G1tensor(15),G1tensor(8),G0tensor(100) &
    ,G0tensor(85),G0tensor(70),G0tensor(45),G0tensor(25),G0tensor(10)])
  call ol_merge_tensors(G2tensor(71),[G2tensor(85),G2tensor(25),G1tensor(90),G1tensor(10),G0tensor(90),G0tensor(23)])
  call ol_merge_tensors(G2tensor(74),[G2tensor(88),G2tensor(26),G1tensor(95),G1tensor(11),G0tensor(95),G0tensor(24)])
  call ol_merge_tensors(G2tensor(80),[G2tensor(91),G2tensor(28),G1tensor(105),G1tensor(27),G0tensor(105),G0tensor(33)])
  call ol_merge_tensors(G2tensor(86),[G2tensor(44),G2tensor(106),G2tensor(94),G2tensor(35),G2tensor(29),G1tensor(110),G1tensor(54) &
    ,G1tensor(28),G0tensor(110),G0tensor(54),G0tensor(34)])
  call ol_merge_tensors(G2tensor(122),[G2tensor(120),G2tensor(68),G2tensor(115),G2tensor(58),G2tensor(30),G1tensor(115) &
    ,G1tensor(33),G0tensor(115),G0tensor(35)])
  call ol_merge_tensors(G2tensor(41),[G2tensor(97),G2tensor(31),G1tensor(120),G1tensor(43),G0tensor(120),G0tensor(43)])
  call ol_merge_tensors(G2tensor(77),[G2tensor(100),G2tensor(32),G1tensor(125),G1tensor(44),G0tensor(125),G0tensor(44)])
  call ol_merge_tensors(G2tensor(83),[G2tensor(103),G2tensor(34),G1tensor(130),G1tensor(53),G0tensor(130),G0tensor(53)])
  call ol_merge_tensors(G2tensor(121),[G2tensor(119),G2tensor(95),G2tensor(118),G2tensor(70),G2tensor(36),G1tensor(135) &
    ,G1tensor(55),G0tensor(135),G0tensor(55)])
  call ol_merge_tensors(G2tensor(104),[G2tensor(42),G2tensor(38),G1tensor(67),G1tensor(25),G0tensor(67),G0tensor(5)])
  call ol_merge_tensors(G2tensor(98),[G2tensor(45),G2tensor(40),G1tensor(82),G1tensor(26),G0tensor(82),G0tensor(15)])
  call ol_merge_tensors(G2tensor(63),[G2tensor(61),G2tensor(51),G2tensor(49),G1tensor(97),G1tensor(40),G1tensor(4),G0tensor(97) &
    ,G0tensor(40),G0tensor(20)])
  call ol_merge_tensors(G2tensor(57),[G2tensor(55),G1tensor(112),G1tensor(34),G0tensor(112),G0tensor(30)])
  call ol_merge_tensors(G2tensor(69),[G2tensor(67),G1tensor(132),G1tensor(50),G0tensor(132),G0tensor(50)])
  call ol_merge_tensors(G2tensor(62),[G2tensor(72),G1tensor(57),G1tensor(13),G0tensor(57),G0tensor(3)])
  call ol_merge_tensors(G2tensor(3),[G2tensor(75),G1tensor(62),G1tensor(19),G0tensor(62),G0tensor(4)])
  call ol_merge_tensors(G2tensor(89),[G2tensor(78),G1tensor(72),G1tensor(20),G0tensor(72),G0tensor(13)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(81),G1tensor(77),G1tensor(24),G0tensor(77),G0tensor(14)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(87),G1tensor(92),G1tensor(3),G0tensor(92),G0tensor(19)])
  call ol_merge_tensors(G2tensor(92),[G2tensor(90),G1tensor(102),G1tensor(17),G0tensor(102),G0tensor(28)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(37),G2tensor(105),G2tensor(93),G1tensor(107),G1tensor(49),G1tensor(21) &
    ,G0tensor(107),G0tensor(49),G0tensor(29)])
  call ol_merge_tensors(G2tensor(107),[G2tensor(99),G1tensor(122),G1tensor(39),G0tensor(122),G0tensor(39)])
  call ol_merge_tensors(G2tensor(113),[G2tensor(102),G1tensor(127),G1tensor(48),G0tensor(127),G0tensor(48)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(68),G1tensor(59),G0tensor(68),G0tensor(59)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(69),G1tensor(64),G0tensor(69),G0tensor(64)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(83),G1tensor(74),G0tensor(83),G0tensor(74)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(84),G1tensor(79),G0tensor(84),G0tensor(79)])
  call ol_merge_tensors(G2tensor(65),[G1tensor(93),G1tensor(88),G0tensor(93),G0tensor(88)])
  call ol_merge_tensors(G2tensor(53),[G2tensor(23),G1tensor(119),G1tensor(98),G1tensor(89),G0tensor(119),G0tensor(98) &
    ,G0tensor(89)])
  call ol_merge_tensors(G2tensor(39),[G2tensor(50),G1tensor(134),G1tensor(124),G1tensor(114),G1tensor(109),G1tensor(99) &
    ,G1tensor(94),G0tensor(134),G0tensor(124),G0tensor(114),G0tensor(109),G0tensor(99),G0tensor(94)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(113),G1tensor(104),G0tensor(113),G0tensor(104)])
  call ol_merge_tensors(G2tensor(116),[G1tensor(123),G1tensor(118),G0tensor(123),G0tensor(118)])
  call ol_merge_tensors(G2tensor(110),[G1tensor(133),G1tensor(129),G0tensor(133),G0tensor(129)])
  call TI_triangle_red(G2tensor(6),RedBasis(19),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1,[nMB], &
    G0tensor(21))
  call TI_triangle_red(G2tensor(56),RedBasis(55),mass3set(:,2),G0tensor(26),G0tensor(31),G0tensor(36),G0tensor(41),M2L1R1,[nMB], &
    G0tensor(46))
  call TI_triangle_red(G2tensor(47),RedBasis(6),mass3set(:,3),G0tensor(51),G0tensor(56),G0tensor(61),G0tensor(66),M2L1R1,[nMB], &
    G0tensor(71))
  call TI_triangle_red(G2tensor(101),RedBasis(56),mass3set(:,2),G0tensor(76),G0tensor(81),G0tensor(86),G0tensor(91),M2L1R1,[nMB], &
    G0tensor(96))
  call TI_triangle_red(G2tensor(19),RedBasis(9),mass3set(:,3),G0tensor(101),G0tensor(106),G0tensor(111), &
    G0tensor(116),M2L1R1,[nMB],G0tensor(121))
  call TI_triangle_red(G2tensor(79),RedBasis(4),mass3set(:,1),G0tensor(126),G0tensor(131),G0tensor(128), &
    G0tensor(108),M2L1R1,[nMB],G0tensor(103))
  call TI_triangle_red(G2tensor(82),RedBasis(2),mass3set(:,1),G0tensor(12),G0tensor(7),G0tensor(2),G0tensor(22),M2L1R1,[nMB], &
    G0tensor(17))
  call TI_triangle_red(G2tensor(112),RedBasis(1),mass3set(:,1),G0tensor(117),G0tensor(63),G0tensor(58),G0tensor(38),M2L1R1,[nMB], &
    G0tensor(32))
  call TI_triangle_red(G2tensor(71),RedBasis(12),mass3set(:,3),G0tensor(27),G0tensor(42),G0tensor(37),G0tensor(87),M2L1R1,[nMB], &
    G0tensor(78))
  call TI_triangle_red(G2tensor(74),RedBasis(10),mass3set(:,3),G0tensor(73),G0tensor(52),G0tensor(47),G0tensor(18),M2L1R1,[nMB], &
    G0tensor(75))
  call TI_triangle_red(G2tensor(80),RedBasis(17),mass3set(:,4),G0tensor(60),G0tensor(8),G0tensor(80),G0tensor(65),M2L1R1,[nMB], &
    G0tensor(9))
  call TI_triangle_red(G2tensor(86),RedBasis(16),mass3set(:,1),G0tensor(100),G0tensor(85),G0tensor(70),G0tensor(45),M2L1R1,[nMB], &
    G0tensor(25))
  call TI_triangle_red(G2tensor(122),RedBasis(15),mass3set(:,3),G0tensor(10),G0tensor(90),G0tensor(23),G0tensor(95),M2L1R1,[nMB], &
    G0tensor(24))
  call TI_triangle_red(G2tensor(41),RedBasis(21),mass3set(:,3),G0tensor(105),G0tensor(33),G0tensor(110),G0tensor(54),M2L1R1,[nMB], &
    G0tensor(34))
  call TI_triangle_red(G2tensor(77),RedBasis(20),mass3set(:,3),G0tensor(115),G0tensor(35),G0tensor(120),G0tensor(43),M2L1R1,[nMB], &
    G0tensor(125))
  call TI_triangle_red(G2tensor(83),RedBasis(24),mass3set(:,4),G0tensor(44),G0tensor(130),G0tensor(53),G0tensor(135),M2L1R1,[nMB], &
    G0tensor(55))
  call TI_triangle_red(G2tensor(121),RedBasis(23),mass3set(:,3),G0tensor(67),G0tensor(5),G0tensor(82),G0tensor(15),M2L1R1,[nMB], &
    G0tensor(97))
  call TI_triangle_red(G2tensor(104),RedBasis(41),mass3set(:,2),G0tensor(40),G0tensor(20),G0tensor(112),G0tensor(30),M2L1R1,[nMB], &
    G0tensor(132))
  call TI_triangle_red(G2tensor(98),RedBasis(44),mass3set(:,2),G0tensor(50),G0tensor(57),G0tensor(3),G0tensor(62),M2L1R1,[nMB], &
    G0tensor(4))
  call TI_triangle_red(G2tensor(63),RedBasis(47),mass3set(:,1),G0tensor(72),G0tensor(13),G0tensor(77),G0tensor(14),M2L1R1,[nMB], &
    G0tensor(92))
  call TI_triangle_red(G2tensor(57),RedBasis(49),mass3set(:,3),G0tensor(19),G0tensor(102),G0tensor(28),G0tensor(107),M2L1R1,[nMB], &
    G0tensor(49))
  call TI_triangle_red(G2tensor(69),RedBasis(53),mass3set(:,3),G0tensor(29),G0tensor(122),G0tensor(39),G0tensor(127),M2L1R1,[nMB], &
    G0tensor(48))
  call TI_triangle_red(G2tensor(62),RedBasis(43),mass3set(:,2),G0tensor(68),G0tensor(59),G0tensor(69),G0tensor(64),M2L1R1,[nMB], &
    G0tensor(83))
  call TI_triangle_red(G2tensor(3),RedBasis(42),mass3set(:,2),G0tensor(74),G0tensor(84),G0tensor(79),G0tensor(93),M2L1R1,[nMB], &
    G0tensor(88))
  call TI_triangle_red(G2tensor(89),RedBasis(46),mass3set(:,2),G0tensor(119),G0tensor(98),G0tensor(89),G0tensor(134),M2L1R1,[nMB], &
    G0tensor(124))
  call TI_triangle_red(G2tensor(10),RedBasis(45),mass3set(:,2),G0tensor(114),G0tensor(109),G0tensor(99),G0tensor(94),M2L1R1,[nMB], &
    G0tensor(113))
  call TI_triangle_red(G2tensor(22),RedBasis(48),mass3set(:,3),G0tensor(104),G0tensor(123),G0tensor(118), &
    G0tensor(133),M2L1R1,[nMB],G0tensor(129))
  call TI_triangle_red(G2tensor(92),RedBasis(51),mass3set(:,4),G0tensor(136),G0tensor(137),G0tensor(138), &
    G0tensor(139),M2L1R1,[nMB],G0tensor(140))
  call TI_triangle_red(G2tensor(59),RedBasis(50),mass3set(:,1),G0tensor(141),G0tensor(142),G0tensor(143), &
    G0tensor(144),M2L1R1,[nMB],G0tensor(145))
  call TI_triangle_red(G2tensor(107),RedBasis(52),mass3set(:,3),G0tensor(146),G0tensor(147),G0tensor(148), &
    G0tensor(149),M2L1R1,[nMB],G0tensor(150))
  call TI_triangle_red(G2tensor(113),RedBasis(54),mass3set(:,4),G0tensor(151),G0tensor(152),G0tensor(153), &
    G0tensor(154),M2L1R1,[nMB],G0tensor(155))
  call TI_triangle_red(G2tensor(11),RedBasis(5),mass3set(:,3),G0tensor(156),G0tensor(157),G0tensor(158), &
    G0tensor(159),M2L1R1,[nMB],G0tensor(160))
  call TI_triangle_red(G2tensor(14),RedBasis(3),mass3set(:,3),G0tensor(161),G0tensor(162),G0tensor(163), &
    G0tensor(164),M2L1R1,[nMB],G0tensor(165))
  call TI_triangle_red(G2tensor(15),RedBasis(8),mass3set(:,3),G0tensor(166),G0tensor(167),G0tensor(168), &
    G0tensor(169),M2L1R1,[nMB],G0tensor(170))
  call TI_triangle_red(G2tensor(18),RedBasis(7),mass3set(:,3),G0tensor(171),G0tensor(172),G0tensor(173), &
    G0tensor(174),M2L1R1,[nMB],G0tensor(175))
  call TI_triangle_red(G2tensor(65),RedBasis(14),mass3set(:,4),G0tensor(176),G0tensor(177),G0tensor(178), &
    G0tensor(179),M2L1R1,[nMB],G0tensor(180))
  call TI_triangle_red(G2tensor(53),RedBasis(13),mass3set(:,1),G0tensor(181),G0tensor(182),G0tensor(183), &
    G0tensor(184),M2L1R1,[nMB],G0tensor(185))
  call TI_triangle_red(G2tensor(39),RedBasis(11),mass3set(:,1),G0tensor(186),G0tensor(187),G0tensor(188), &
    G0tensor(189),M2L1R1,[nMB],G0tensor(190))
  call TI_triangle_red(G2tensor(7),RedBasis(18),mass3set(:,4),G0tensor(191),G0tensor(192),G0tensor(193), &
    G0tensor(194),M2L1R1,[nMB],G0tensor(195))
  call TI_triangle_red(G2tensor(116),RedBasis(22),mass3set(:,4),G0tensor(196),G0tensor(197),G0tensor(198), &
    G0tensor(199),M2L1R1,[nMB],G0tensor(200))
  call TI_triangle_red(G2tensor(110),RedBasis(25),mass3set(:,4),G0tensor(201),G0tensor(202),G0tensor(203), &
    G0tensor(204),M2L1R1,[nMB],G0tensor(205))
  call ol_merge_tensors(T0sum(28),[G0tensor(1)])
  call ol_merge_tensors(T0sum(29),[G0tensor(26)])
  call ol_merge_tensors(T0sum(30),[G0tensor(51)])
  call ol_merge_tensors(T0sum(31),[G0tensor(76)])
  call ol_merge_tensors(T0sum(32),[G0tensor(101)])
  call ol_merge_tensors(T0sum(33),[G0tensor(126)])
  call ol_merge_tensors(T0sum(34),[G0tensor(12)])
  call ol_merge_tensors(T0sum(35),[G0tensor(117)])
  call ol_merge_tensors(T0sum(36),[G0tensor(27)])
  call ol_merge_tensors(T0sum(37),[G0tensor(73)])
  call ol_merge_tensors(T0sum(38),[G0tensor(60)])
  call ol_merge_tensors(T0sum(39),[G0tensor(100)])
  call ol_merge_tensors(T0sum(40),[G0tensor(10)])
  call ol_merge_tensors(T0sum(41),[G0tensor(105)])
  call ol_merge_tensors(T0sum(42),[G0tensor(115)])
  call ol_merge_tensors(T0sum(43),[G0tensor(44)])
  call ol_merge_tensors(T0sum(44),[G0tensor(67)])
  call ol_merge_tensors(T0sum(45),[G0tensor(40)])
  call ol_merge_tensors(T0sum(46),[G0tensor(50)])
  call ol_merge_tensors(T0sum(47),[G0tensor(72)])
  call ol_merge_tensors(T0sum(48),[G0tensor(19)])
  call ol_merge_tensors(T0sum(49),[G0tensor(29)])
  call ol_merge_tensors(T0sum(50),[G0tensor(68)])
  call ol_merge_tensors(T0sum(51),[G0tensor(74)])
  call ol_merge_tensors(T0sum(52),[G0tensor(119)])
  call ol_merge_tensors(T0sum(53),[G0tensor(114)])
  call ol_merge_tensors(T0sum(54),[G0tensor(104)])
  call ol_merge_tensors(T0sum(55),[G0tensor(136)])
  call ol_merge_tensors(T0sum(56),[G0tensor(141)])
  call ol_merge_tensors(T0sum(57),[G0tensor(146)])
  call ol_merge_tensors(T0sum(58),[G0tensor(151)])
  call ol_merge_tensors(T0sum(59),[G0tensor(156)])
  call ol_merge_tensors(T0sum(60),[G0tensor(161)])
  call ol_merge_tensors(T0sum(61),[G0tensor(166)])
  call ol_merge_tensors(T0sum(62),[G0tensor(171)])
  call ol_merge_tensors(T0sum(63),[G0tensor(176)])
  call ol_merge_tensors(T0sum(64),[G0tensor(181)])
  call ol_merge_tensors(T0sum(65),[G0tensor(186)])
  call ol_merge_tensors(T0sum(66),[G0tensor(191)])
  call ol_merge_tensors(T0sum(67),[G0tensor(196)])
  call ol_merge_tensors(T0sum(68),[G0tensor(201)])
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(43)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(43),h0tab(:,43),[40,23],[0,nMB],2,2,wf4(:,4),wf8(:,20))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,4),G0H8(5),m3h4x8(:,15),heltab2x32(:,:,43))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(40)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(44),h0tab(:,44),[43,20],[nMB,0],2,2,wf16(:,5),wf2(:,2))
  call Hloop_VA_Q(ntryL,G0H32(1),wf16(:,5),G0H2(1),m3h16x2(:,5),heltab2x32(:,:,44))
  call Hloop_A_Q(ntryL,G0H2(1),43,nMB,G1H2(5),n2h2(19))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(46)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(45),h0tab(:,45),[52,11],[nMB,0],2,2,wf4(:,16),wf8(:,3))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,16),G0H8(1),m3h4x8(:,16),heltab2x32(:,:,45))
  call Hloop_Q_A(ntryL,G0H8(1),52,nMB,G1H8(2),n2h8(9))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(73)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(46),h0tab(:,46),[43,20],[nMB,0],2,2,wf16(:,10),wf2(:,2))
  call Hloop_VA_Q(ntryL,G0H32(1),wf16(:,10),G0H2(2),m3h16x2(:,6),heltab2x32(:,:,46))
  call Hloop_A_Q(ntryL,G0H2(2),43,nMB,G1H2(6),n2h2(20))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(53)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(47),h0tab(:,47),[39,24],[nMB,0],2,2,wf16(:,6),wf2(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf16(:,6),G0H2(3),m3h16x2(:,7),heltab2x32(:,:,47))
  call Hloop_Q_A(ntryL,G0H2(3),39,nMB,G1H2(18),n2h2(21))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(50)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(48),h0tab(:,48),[36,27],[0,nMB],2,2,wf4(:,7),wf8(:,23))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,7),G0H8(2),m3h4x8(:,17),heltab2x32(:,:,48))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(74)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(49),h0tab(:,49),[39,24],[nMB,0],2,2,wf16(:,8),wf2(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf16(:,8),G0H2(4),m3h16x2(:,8),heltab2x32(:,:,49))
  call Hloop_Q_A(ntryL,G0H2(4),39,nMB,G1H2(28),n2h2(22))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(54)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(50),h0tab(:,50),[56,7],[nMB,0],2,2,wf4(:,23),wf8(:,5))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,23),G0H8(3),m3h4x8(:,18),heltab2x32(:,:,50))
  call Hloop_A_Q(ntryL,G0H8(3),56,nMB,G1H8(4),n2h8(10))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(60)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(51),h0tab(:,51),[52,11],[nMB,0],2,2,wf4(:,20),wf8(:,3))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,20),G0H8(4),m3h4x8(:,19),heltab2x32(:,:,51))
  call Hloop_Q_A(ntryL,G0H8(4),52,nMB,G1H8(1),n2h8(11))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(75)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(52),h0tab(:,52),[36,27],[0,nMB],2,2,wf4(:,7),wf8(:,30))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,7),G0H8(1),m3h4x8(:,20),heltab2x32(:,:,52))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(76)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(53),h0tab(:,53),[36,27],[0,nMB],2,2,wf4(:,7),wf8(:,34))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,7),G0H8(3),m3h4x8(:,21),heltab2x32(:,:,53))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(77)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(54),h0tab(:,54),[40,23],[0,nMB],2,2,wf4(:,4),wf8(:,28))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,4),G0H8(4),m3h4x8(:,22),heltab2x32(:,:,54))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(63)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(55),h0tab(:,55),[56,7],[nMB,0],2,2,wf4(:,26),wf8(:,5))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,26),G0H8(6),m3h4x8(:,23),heltab2x32(:,:,55))
  call Hloop_A_Q(ntryL,G0H8(6),56,nMB,G1H8(5),n2h8(12))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(78)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(56),h0tab(:,56),[40,23],[nMB,0],2,2,wf4(:,4),wf8(:,32))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,4),G0H8(6),m3h4x8(:,24),heltab2x32(:,:,56))
  call Hloop_A_Q(ntryL,G0H8(6),40,nMB,G1H8(3),n2h8(13))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(6),[G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(1),[G1H8(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(28),[G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(5),[G1H8(4)])
  call Hloop_VQ_A(ntryL,G0H8(5),wf8(:,20),G0H1(1),m3h8x1(:,11),heltab2x8(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,nMB,G1tensor(1),n2h1(183))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H2(6),wf2(:,2),G1tensor(31),m3h2x1(:,83),heltab2x2(:,:,93))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H8(1),wf8(:,3),G1tensor(14),m3h8x1(:,12),heltab2x8(:,:,26))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H2(28),wf2(:,4),G1tensor(30),m3h2x1(:,84),heltab2x2(:,:,94))
  call Hloop_VA_Q(ntryL,G0H8(2),wf8(:,23),G0H1(1),m3h8x1(:,13),heltab2x8(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMB,G1tensor(5),n2h1(184))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(5),wf8(:,5),G1tensor(16),m3h8x1(:,14),heltab2x8(:,:,28))
  call Hloop_VA_Q(ntryL,G0H8(1),wf8(:,30),G0H1(1),m3h8x1(:,15),heltab2x8(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMB,G1tensor(22),n2h1(185))
  call Hloop_VA_Q(ntryL,G0H8(3),wf8(:,34),G0H1(1),m3h8x1(:,16),heltab2x8(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,nMB,G1tensor(35),n2h1(186))
  call Hloop_VQ_A(ntryL,G0H8(4),wf8(:,28),G0H1(1),m3h8x1(:,17),heltab2x8(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),63,nMB,G1tensor(41),n2h1(187))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(3),wf8(:,32),G1tensor(46),m3h8x1(:,18),heltab2x8(:,:,32))
  call ol_merge_tensors(G0tensor(153),[G0tensor(143),G0tensor(138),G0tensor(13),G0tensor(57),G0tensor(20),G0tensor(63) &
    ,G0tensor(81),G0tensor(31),G0tensor(6)])
  call ol_merge_tensors(G0tensor(203),[G0tensor(198),G0tensor(193),G0tensor(188),G0tensor(183),G0tensor(178),G0tensor(98) &
    ,G0tensor(59),G0tensor(131),G0tensor(11)])
  call ol_merge_tensors(G0tensor(109),[G0tensor(84),G0tensor(53),G0tensor(70),G0tensor(80),G0tensor(7),G0tensor(16)])
  call ol_merge_tensors(G0tensor(205),[G0tensor(200),G0tensor(195),G0tensor(190),G0tensor(185),G0tensor(180),G0tensor(175) &
    ,G0tensor(170),G0tensor(165),G0tensor(160),G0tensor(155),G0tensor(150),G0tensor(145),G0tensor(140),G0tensor(129),G0tensor(113) &
    ,G0tensor(124),G0tensor(88),G0tensor(83),G0tensor(48),G0tensor(49),G0tensor(92),G0tensor(4),G0tensor(132),G0tensor(97) &
    ,G0tensor(55),G0tensor(125),G0tensor(34),G0tensor(24),G0tensor(25),G0tensor(9),G0tensor(75),G0tensor(78),G0tensor(32) &
    ,G0tensor(17),G0tensor(103),G0tensor(121),G0tensor(96),G0tensor(71),G0tensor(46),G0tensor(21)])
  call ol_merge_tensors(G0tensor(99),[G0tensor(89),G0tensor(122),G0tensor(5),G0tensor(42),G0tensor(106),G0tensor(36)])
  call ol_merge_tensors(G1tensor(14),[G0tensor(123),G0tensor(52),G0tensor(41)])
  call ol_merge_tensors(G0tensor(79),[G0tensor(69),G0tensor(102),G0tensor(33),G0tensor(90),G0tensor(86),G0tensor(56)])
  call ol_merge_tensors(G0tensor(197),[G0tensor(163),G0tensor(158),G0tensor(148),G0tensor(137),G0tensor(8),G0tensor(61)])
  call ol_merge_tensors(G0tensor(182),[G0tensor(142),G0tensor(77),G0tensor(85),G0tensor(2),G0tensor(128),G0tensor(116) &
    ,G0tensor(66)])
  call ol_merge_tensors(G1tensor(16),[G0tensor(147),G0tensor(35),G0tensor(91)])
  call ol_merge_tensors(G0tensor(177),[G0tensor(173),G0tensor(168),G0tensor(152),G0tensor(118),G0tensor(130),G0tensor(111)])
  call ol_merge_tensors(G0tensor(184),[G0tensor(169),G0tensor(159),G0tensor(54),G0tensor(87),G0tensor(58),G0tensor(108)])
  call ol_merge_tensors(G0tensor(189),[G0tensor(174),G0tensor(164),G0tensor(15),G0tensor(43),G0tensor(95),G0tensor(45) &
    ,G0tensor(18),G0tensor(38),G0tensor(22)])
  call ol_merge_tensors(G0tensor(179),[G0tensor(47),G0tensor(37)])
  call ol_merge_tensors(G1tensor(35),[G1tensor(22),G1tensor(5),G0tensor(194),G0tensor(23),G0tensor(65)])
  call ol_merge_tensors(G0tensor(199),[G0tensor(120),G0tensor(110)])
  call ol_merge_tensors(G1tensor(41),[G1tensor(1),G0tensor(204),G0tensor(82),G0tensor(135)])
  call ol_merge_tensors(G1tensor(31),[G0tensor(157),G0tensor(64),G0tensor(112)])
  call ol_merge_tensors(G1tensor(46),[G0tensor(162),G0tensor(93),G0tensor(30)])
  call ol_merge_tensors(G1tensor(30),[G0tensor(167),G0tensor(134),G0tensor(3)])
  call ol_merge_tensors(G0tensor(172),[G0tensor(94),G0tensor(62)])
  call ol_merge_tensors(G0tensor(187),[G0tensor(149),G0tensor(144),G0tensor(133),G0tensor(127),G0tensor(107),G0tensor(14)])
  call ol_merge_tensors(G0tensor(192),[G0tensor(139),G0tensor(28)])
  call ol_merge_tensors(G0tensor(202),[G0tensor(154),G0tensor(39)])
call TI_bubble_red(G1tensor(14),52,mass2set(:,1),G0tensor(1),M2L1R1,G0tensor(26))
call TI_bubble_red(G1tensor(16),56,mass2set(:,1),G0tensor(51),M2L1R1,G0tensor(76))
call TI_bubble_red(G1tensor(35),36,mass2set(:,2),G0tensor(101),M2L1R1,G0tensor(126))
call TI_bubble_red(G1tensor(41),40,mass2set(:,2),G0tensor(12),M2L1R1,G0tensor(117))
call TI_bubble_red(G1tensor(31),43,mass2set(:,1),G0tensor(27),M2L1R1,G0tensor(73))
call TI_bubble_red(G1tensor(46),40,mass2set(:,1),G0tensor(60),M2L1R1,G0tensor(100))
call TI_bubble_red(G1tensor(30),39,mass2set(:,1),G0tensor(10),M2L1R1,G0tensor(105))
  call ol_merge_tensors(G0tensor(105),[G0tensor(100),G0tensor(73),G0tensor(117),G0tensor(126),G0tensor(76),G0tensor(26) &
    ,G0tensor(205)])
  call ol_merge_tensors(T0sum(69),[G0tensor(153)])
  call ol_merge_tensors(T0sum(70),[G0tensor(203)])
  call ol_merge_tensors(T0sum(71),[G0tensor(109)])
  call ol_merge_tensors(T0sum(72),[G0tensor(105)])
  call ol_merge_tensors(T0sum(73),[G0tensor(99)])
  call ol_merge_tensors(T0sum(74),[G0tensor(1)])
  call ol_merge_tensors(T0sum(75),[G0tensor(79)])
  call ol_merge_tensors(T0sum(76),[G0tensor(197)])
  call ol_merge_tensors(T0sum(77),[G0tensor(182)])
  call ol_merge_tensors(T0sum(78),[G0tensor(51)])
  call ol_merge_tensors(T0sum(79),[G0tensor(177)])
  call ol_merge_tensors(T0sum(80),[G0tensor(184)])
  call ol_merge_tensors(T0sum(81),[G0tensor(189)])
  call ol_merge_tensors(T0sum(82),[G0tensor(179)])
  call ol_merge_tensors(T0sum(83),[G0tensor(101)])
  call ol_merge_tensors(T0sum(84),[G0tensor(199)])
  call ol_merge_tensors(T0sum(85),[G0tensor(12)])
  call ol_merge_tensors(T0sum(86),[G0tensor(27)])
  call ol_merge_tensors(T0sum(87),[G0tensor(60)])
  call ol_merge_tensors(T0sum(88),[G0tensor(10)])
  call ol_merge_tensors(T0sum(89),[G0tensor(172)])
  call ol_merge_tensors(T0sum(90),[G0tensor(187)])
  call ol_merge_tensors(T0sum(91),[G0tensor(192)])
  call ol_merge_tensors(T0sum(92),[G0tensor(202)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 35, 51, 55 ],masses2_10,RedSet_4(6),ScalarBoxes(1))
  call compute_scalar_box([ 32, 51, 55 ],masses2_10,RedSet_4(7),ScalarBoxes(2))
  call compute_scalar_box([ 32, 35, 55 ],masses2_10,RedSet_4(8),ScalarBoxes(3))
  call compute_scalar_box([ 32, 35, 51 ],masses2_12,RedSet_4(1),ScalarBoxes(4))
  call compute_scalar_box([ 3, 19, 23 ],masses2_10,RedSet_4(9),ScalarBoxes(5))
  call compute_scalar_box([ 35, 51, 59 ],masses2_10,RedSet_4(10),ScalarBoxes(6))
  call compute_scalar_box([ 32, 51, 59 ],masses2_10,RedSet_4(11),ScalarBoxes(7))
  call compute_scalar_box([ 32, 35, 59 ],masses2_10,RedSet_4(12),ScalarBoxes(8))
  call compute_scalar_box([ 3, 19, 27 ],masses2_10,RedSet_4(13),ScalarBoxes(9))
  call compute_scalar_box([ 35, 43, 47 ],masses2_9,RedSet_4(14),ScalarBoxes(10))
  call compute_scalar_box([ 32, 43, 47 ],masses2_9,RedSet_4(15),ScalarBoxes(11))
  call compute_scalar_box([ 32, 35, 47 ],masses2_12,RedSet_4(16),ScalarBoxes(12))
  call compute_scalar_box([ 32, 35, 43 ],masses2_10,RedSet_4(2),ScalarBoxes(13))
  call compute_scalar_box([ 3, 11, 15 ],masses2_9,RedSet_4(17),ScalarBoxes(14))
  call compute_scalar_box([ 36, 44, 47 ],masses2_8,RedSet_4(18),ScalarBoxes(15))
  call compute_scalar_box([ 32, 44, 47 ],masses2_12,RedSet_4(19),ScalarBoxes(16))
  call compute_scalar_box([ 32, 36, 47 ],masses2_9,RedSet_4(20),ScalarBoxes(17))
  call compute_scalar_box([ 32, 36, 44 ],masses2_9,RedSet_4(3),ScalarBoxes(18))
  call compute_scalar_box([ 4, 12, 15 ],masses2_8,RedSet_4(21),ScalarBoxes(19))
  call compute_scalar_box([ 35, 39, 47 ],masses2_9,RedSet_4(22),ScalarBoxes(20))
  call compute_scalar_box([ 32, 39, 47 ],masses2_9,RedSet_4(23),ScalarBoxes(21))
  call compute_scalar_box([ 32, 35, 39 ],masses2_10,RedSet_4(4),ScalarBoxes(22))
  call compute_scalar_box([ 3, 7, 15 ],masses2_9,RedSet_4(24),ScalarBoxes(23))
  call compute_scalar_box([ 40, 44, 47 ],masses2_8,RedSet_4(25),ScalarBoxes(24))
  call compute_scalar_box([ 32, 40, 47 ],masses2_9,RedSet_4(26),ScalarBoxes(25))
  call compute_scalar_box([ 32, 40, 44 ],masses2_9,RedSet_4(5),ScalarBoxes(26))
  call compute_scalar_box([ 8, 12, 15 ],masses2_8,RedSet_4(27),ScalarBoxes(27))
! end of process


end subroutine vamp_1

end module ol_vamp_1_pphllj_ew_nenexbbxha_1_/**/REALKIND
