
module ol_vamp_1_pphllj_ew_neexuxdhg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphllj_ew_neexuxdhg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphllj_ew_neexuxdhg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pphllj_ew_neexuxdhg_1_/**/DREALKIND
  use ol_tensor_sum_storage_pphllj_ew_neexuxdhg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pphllj_ew_neexuxdhg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pphllj_ew_neexuxdhg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(22)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[32,4,1,2,16,8],[0,nMW,0,nMZ,nMZ,0],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[32,4,1,2,16,8],[0,nMZ,0,nMW,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[32,4,16,2,1,8],[0,nMZ,nMZ,0,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[32,4,16,2,1,8],[0,nMW,nMW,0,nMZ,0],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(4),n2h16(4))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[32,4,2,1,16,8],[0,nMW,0,nMZ,nMZ,0],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(5),n2h16(5))
  Gcoeff(:)%j = (c(19)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[32,4,2,1,16,8],[0,0,0,nMW,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(6),n2h16(6))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[32,4,2,1,16,8],[0,nMZ,0,nMW,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(7),n2h16(7))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[32,4,16,1,2,8],[0,nMZ,nMZ,0,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(8),n2h16(8))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[32,4,16,1,2,8],[0,nMW,nMW,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(9),n2h16(9))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[32,4,16,1,2,8],[0,nMW,nMW,0,nMZ,0],6,0)
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(10),n2h16(10))
  call Hloop_QA_W(ntryL,G1H16(1),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_QA_Z(ntryL,G1H16(2),ex3(:),G1H8(2),ngZu,m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_QA_Z(ntryL,G1H16(3),ex3(:),G1H8(3),ngZu,m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_QA_W(ntryL,G1H16(4),ex3(:),G1H8(4),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_QA_W(ntryL,G1H16(5),ex3(:),G1H8(5),m3h2x8(:,5),heltab2x16(:,:,5))
  call Hloop_QA_V(ntryL,G1H16(6),ex3(:),G1H8(6),m3h2x8(:,6),heltab2x16(:,:,6))
  call Hloop_QA_Z(ntryL,G1H16(7),ex3(:),G1H8(7),ngZu,m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_QA_Z(ntryL,G1H16(8),ex3(:),G1H8(8),ngZu,m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_QA_W(ntryL,G1H16(9),ex3(:),G1H8(9),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_QA_W(ntryL,G1H16(10),ex3(:),G1H8(10),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_WQ_A(ntryL,G1H8(1),ex1(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),37,0,G2H4(1),n2h4(1))
  call Hloop_ZQ_A(ntryL,G1H8(2),ex1(:),G1H4(1),ngZn,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),37,0,G2H4(2),n2h4(2))
  call Hloop_VS_V(ntryL,G1H8(3),ex5(:),G1H8(1),m3h1x8(:,1),heltab2x8(:,:,3))
  call Hloop_VS_V(ntryL,G1H8(4),ex5(:),G1H8(2),m3h1x8(:,2),heltab2x8(:,:,4))
  call Hloop_WA_Q(ntryL,G1H8(5),ex2(:),G1H4(1),m3h2x4(:,3),heltab2x8(:,:,5))
  call Hloop_A_Q(ntryL,G1H4(1),38,0,G2H4(3),n2h4(3))
  call Hloop_VA_Q(ntryL,G1H8(6),ex2(:),G1H4(1),m3h2x4(:,4),heltab2x8(:,:,6))
  call Hloop_A_Q(ntryL,G1H4(1),38,0,G2H4(4),n2h4(4))
  call Hloop_ZA_Q(ntryL,G1H8(7),ex2(:),G1H4(1),ngZl,m3h2x4(:,5),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(1),38,0,G2H4(5),n2h4(5))
  call Hloop_VS_V(ntryL,G1H8(8),ex5(:),G1H8(3),m3h1x8(:,3),heltab2x8(:,:,8))
  call Hloop_VS_V(ntryL,G1H8(9),ex5(:),G1H8(4),m3h1x8(:,4),heltab2x8(:,:,9))
  call Hloop_VS_V(ntryL,G1H8(10),ex5(:),G1H8(5),m3h1x8(:,5),heltab2x8(:,:,10))
  call Hloop_QA_Z(ntryL,G2H4(1),ex2(:),G2H2(1),ngZl,m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_W(ntryL,G2H4(2),ex2(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_ZA_Q(ntryL,G1H8(1),ex2(:),G1H4(1),ngZl,m3h2x4(:,6),heltab2x8(:,:,11))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(1),n2h4(6))
  call Hloop_WA_Q(ntryL,G1H8(2),ex2(:),G1H4(1),m3h2x4(:,7),heltab2x8(:,:,12))
  call Hloop_A_Q(ntryL,G1H4(1),54,0,G2H4(2),n2h4(7))
  call Hloop_AQ_Z(ntryL,G2H4(3),ex1(:),G2H2(3),ngZn,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_W(ntryL,G2H4(4),ex1(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_W(ntryL,G2H4(5),ex1(:),G2H2(5),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_ZQ_A(ntryL,G1H8(3),ex1(:),G1H4(1),ngZn,m3h2x4(:,8),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(3),n2h4(8))
  call Hloop_WQ_A(ntryL,G1H8(4),ex1(:),G1H4(1),m3h2x4(:,9),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(4),n2h4(9))
  call Hloop_WQ_A(ntryL,G1H8(5),ex1(:),G1H4(1),m3h2x4(:,10),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(1),53,0,G2H4(5),n2h4(10))
  call Hloop_VS_V(ntryL,G2H2(1),ex5(:),G2H2(6),m3h1x2(:,1),heltab2x2(:,:,1))
  call Hloop_VS_V(ntryL,G2H2(2),ex5(:),G2H2(1),m3h1x2(:,2),heltab2x2(:,:,2))
  call Hloop_AQ_W(ntryL,G2H4(1),ex1(:),G2H2(2),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_Z(ntryL,G2H4(2),ex1(:),G2H2(7),ngZn,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_VS_V(ntryL,G2H2(3),ex5(:),G2H2(8),m3h1x2(:,3),heltab2x2(:,:,3))
  call Hloop_VS_V(ntryL,G2H2(4),ex5(:),G2H2(3),m3h1x2(:,4),heltab2x2(:,:,4))
  call Hloop_VS_V(ntryL,G2H2(5),ex5(:),G2H2(4),m3h1x2(:,5),heltab2x2(:,:,5))
  call Hloop_QA_W(ntryL,G2H4(3),ex2(:),G2H2(5),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_QA_V(ntryL,G2H4(4),ex2(:),G2H2(9),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_QA_Z(ntryL,G2H4(5),ex2(:),G2H2(10),ngZl,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hotf_5pt_reduction(G2H2(6),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),8,2)
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,2),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),8,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(2),mass5set(:,3),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(14),8,2)
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(2),mass5set(:,4),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),2)
  call HG1shiftOLR(G1H2(20),8,2)
  call Hotf_5pt_reduction(G2H2(8),RedSet_5(3),mass5set(:,1),  & 
G1H2(25),G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),2)
  call HG1shiftOLR(G1H2(26),8,2)
  call Hotf_5pt_reduction(G2H2(3),RedSet_5(3),mass5set(:,5),  & 
G1H2(31),G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),2)
  call HG1shiftOLR(G1H2(32),8,2)
  call Hotf_5pt_reduction(G2H2(4),RedSet_5(3),mass5set(:,2),  & 
G1H2(37),G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),2)
  call HG1shiftOLR(G1H2(38),8,2)
  call Hotf_5pt_reduction(G2H2(5),RedSet_5(4),mass5set(:,3),  & 
G1H2(43),G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),2)
  call HG1shiftOLR(G1H2(44),8,2)
  call Hotf_5pt_reduction(G2H2(9),RedSet_5(4),mass5set(:,4),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),2)
  call HG1shiftOLR(G1H2(50),8,2)
  call Hotf_5pt_reduction(G2H2(10),RedSet_5(4),mass5set(:,4),  & 
G1H2(55),G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),2)
  call HG1shiftOLR(G1H2(56),8,2)
  call Hloop_ZQ_A(ntryL,G1H2(1),ex4(:),G1H1(1),ngZd,m3h2x1(:,1),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(1))
  call Hloop_ZQ_A(ntryL,G1H2(2),ex4(:),G1H1(1),ngZd,m3h2x1(:,2),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(2),n2h1(2))
  call Hloop_WQ_A(ntryL,G1H2(7),ex4(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(3),n2h1(3))
  call Hloop_WQ_A(ntryL,G1H2(8),ex4(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(4),n2h1(4))
  call Hloop_WQ_A(ntryL,G1H2(13),ex4(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(5))
  call Hloop_WQ_A(ntryL,G1H2(14),ex4(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(6),n2h1(6))
  call Hloop_ZQ_A(ntryL,G1H2(19),ex4(:),G1H1(1),ngZd,m3h2x1(:,7),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(7))
  call Hloop_ZQ_A(ntryL,G1H2(20),ex4(:),G1H1(1),ngZd,m3h2x1(:,8),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(8),n2h1(8))
  call Hloop_ZQ_A(ntryL,G1H2(25),ex4(:),G1H1(1),ngZd,m3h2x1(:,9),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(9))
  call Hloop_ZQ_A(ntryL,G1H2(26),ex4(:),G1H1(1),ngZd,m3h2x1(:,10),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(10),n2h1(10))
  call Hloop_WQ_A(ntryL,G1H2(31),ex4(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(11))
  call Hloop_WQ_A(ntryL,G1H2(32),ex4(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(12),n2h1(12))
  call Hloop_WQ_A(ntryL,G1H2(37),ex4(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(13))
  call Hloop_WQ_A(ntryL,G1H2(38),ex4(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(14),n2h1(14))
  call Hloop_WQ_A(ntryL,G1H2(43),ex4(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(15))
  call Hloop_WQ_A(ntryL,G1H2(44),ex4(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(16),n2h1(16))
  call Hloop_VQ_A(ntryL,G1H2(49),ex4(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(17))
  call Hloop_VQ_A(ntryL,G1H2(50),ex4(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(18),n2h1(18))
  call Hloop_ZQ_A(ntryL,G1H2(55),ex4(:),G1H1(1),ngZd,m3h2x1(:,19),heltab2x2(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(19))
  call Hloop_ZQ_A(ntryL,G1H2(56),ex4(:),G1H1(1),ngZd,m3h2x1(:,20),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(20),n2h1(20))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(1),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(2),mass5set(:,3),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(2),mass5set(:,4),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),8)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(3),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(3),mass5set(:,5),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(3),mass5set(:,2),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(4),mass5set(:,3),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),8)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(4),mass5set(:,4),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),8)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(4),mass5set(:,4),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),8)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[32,3,8,16,4],[0,0,nMZ,nMZ,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(1),n2h16(11))
  Gcoeff(:)%j = (c(14)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[32,4,16,3,8],[0,nMW,nMW,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(2),n2h16(12))
  Gcoeff(:)%j = (c(28)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[32,4,16,3,8],[0,nMW,nMW,nMZ,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(3),n2h16(13))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[32,4,16,3,8],[0,nMZ,nMZ,nMW,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(4),n2h16(14))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[32,4,16,3,8],[0,nMW,nMW,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(5),n2h16(15))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[32,4,16,3,8],[0,nMW,nMW,nMZ,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(6),n2h16(16))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[32,3,4,16,8],[0,0,nMZ,nMZ,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(7),n2h16(17))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[32,4,3,16,8],[0,0,nMW,nMW,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(8),n2h16(18))
  Gcoeff(:)%j = (c(28)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[32,4,3,16,8],[0,nMZ,nMW,nMW,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(9),n2h16(19))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[32,4,3,16,8],[0,nMW,nMZ,nMZ,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(10),n2h16(20))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[32,4,3,16,8],[0,0,nMW,nMW,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(11),n2h16(21))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[32,4,3,16,8],[0,nMZ,nMW,nMW,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(12),n2h16(22))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[36,8,1,2,16],[0,nMW,0,nMZ,nMZ],5,1,wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(1),ngZu,m3h4x8(:,1),heltab2x32(:,:,23))
  call Hloop_A_Q(ntryL,G0H8(1),36,0,G1H8(6),n2h8(1))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[36,8,1,2,16],[0,nMZ,0,nMW,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(1),m3h4x8(:,2),heltab2x32(:,:,24))
  call Hloop_A_Q(ntryL,G0H8(1),36,0,G1H8(7),n2h8(2))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[36,8,2,1,16],[0,nMW,0,nMZ,nMZ],5,1,wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(1),ngZu,m3h4x8(:,3),heltab2x32(:,:,25))
  call Hloop_A_Q(ntryL,G0H8(1),36,0,G1H8(8),n2h8(3))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[36,8,2,1,16],[0,0,0,nMW,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(1),m3h4x8(:,4),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G0H8(1),36,0,G1H8(9),n2h8(4))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[36,8,2,1,16],[0,nMZ,0,nMW,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(1),m3h4x8(:,5),heltab2x32(:,:,27))
  call Hloop_A_Q(ntryL,G0H8(1),36,0,G1H8(10),n2h8(5))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[36,2,1,16,8],[nMW,0,nMZ,nMZ,0],5,1,wf4(:,3))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,3),G0H8(1),m3h4x8(:,6),heltab2x32(:,:,28))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[36,2,1,16,8],[0,0,nMW,nMW,0],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,3),G0H8(2),m3h4x8(:,7),heltab2x32(:,:,29))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[36,2,1,16,8],[nMZ,0,nMW,nMW,0],5,1,wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,3),G0H8(3),ngZu,m3h4x8(:,8),heltab2x32(:,:,30))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[36,1,2,16,8],[nMW,0,nMZ,nMZ,0],5,1,wf4(:,3))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,3),G0H8(4),m3h4x8(:,9),heltab2x32(:,:,31))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[36,1,2,16,8],[nMZ,0,nMW,nMW,0],5,1,wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,3),G0H8(5),ngZu,m3h4x8(:,10),heltab2x32(:,:,32))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(33),h0tab(:,33),[40,4,1,2,16],[0,nMW,0,nMZ,nMZ],5,1,wf4(:,6))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,6),G0H8(6),ngZd,m3h4x8(:,11),heltab2x32(:,:,33))
  call Hloop_Q_A(ntryL,G0H8(6),40,0,G1H8(1),n2h8(6))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(34),h0tab(:,34),[40,4,1,2,16],[0,nMZ,0,nMW,nMW],5,1,wf4(:,6))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,6),G0H8(6),m3h4x8(:,12),heltab2x32(:,:,34))
  call Hloop_Q_A(ntryL,G0H8(6),40,0,G1H8(2),n2h8(7))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(35),h0tab(:,35),[40,4,2,1,16],[0,nMW,0,nMZ,nMZ],5,1,wf4(:,6))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,6),G0H8(6),ngZd,m3h4x8(:,13),heltab2x32(:,:,35))
  call Hloop_Q_A(ntryL,G0H8(6),40,0,G1H8(3),n2h8(8))
  Gcoeff(:)%j = (c(19)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(36),h0tab(:,36),[40,4,2,1,16],[0,0,0,nMW,nMW],5,1,wf4(:,6))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,6),G0H8(6),m3h4x8(:,14),heltab2x32(:,:,36))
  call Hloop_Q_A(ntryL,G0H8(6),40,0,G1H8(4),n2h8(9))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(37),h0tab(:,37),[40,4,2,1,16],[0,nMZ,0,nMW,nMW],5,1,wf4(:,6))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,6),G0H8(6),m3h4x8(:,15),heltab2x32(:,:,37))
  call Hloop_Q_A(ntryL,G0H8(6),40,0,G1H8(5),n2h8(10))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(38),h0tab(:,38),[40,2,1,16,4],[nMW,0,nMZ,nMZ,0],5,1,wf4(:,6))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,6),G0H8(6),m3h4x8(:,16),heltab2x32(:,:,38))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(39),h0tab(:,39),[40,2,1,16,4],[0,0,nMW,nMW,0],5,1,wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,6),G0H8(7),m3h4x8(:,17),heltab2x32(:,:,39))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(40),h0tab(:,40),[40,2,1,16,4],[nMZ,0,nMW,nMW,0],5,1,wf4(:,6))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,6),G0H8(8),ngZd,m3h4x8(:,18),heltab2x32(:,:,40))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(41),h0tab(:,41),[40,1,2,16,4],[nMW,0,nMZ,nMZ,0],5,1,wf4(:,6))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,6),G0H8(9),m3h4x8(:,19),heltab2x32(:,:,41))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(42),h0tab(:,42),[40,1,2,16,4],[nMZ,0,nMW,nMW,0],5,1,wf4(:,6))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,6),G0H8(10),ngZd,m3h4x8(:,20),heltab2x32(:,:,42))
  call Hloop_AW_Q(ntryL,G1H16(1),wf4(:,1),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,11))
  call Hloop_A_Q(ntryL,G1H4(1),35,0,G2H4(1),n2h4(11))
  call Hloop_QA_W(ntryL,G1H16(2),ex3(:),G1H8(11),m3h2x8(:,11),heltab2x16(:,:,12))
  call Hloop_QA_W(ntryL,G1H16(3),ex3(:),G1H8(12),m3h2x8(:,12),heltab2x16(:,:,13))
  call Hloop_QA_Z(ntryL,G1H16(4),ex3(:),G1H8(13),ngZu,m3h2x8(:,13),heltab2x16(:,:,14))
  call Hloop_QA_W(ntryL,G1H16(5),ex3(:),G1H8(14),m3h2x8(:,14),heltab2x16(:,:,15))
  call Hloop_QA_W(ntryL,G1H16(6),ex3(:),G1H8(15),m3h2x8(:,15),heltab2x16(:,:,16))
  call Hloop_QW_A(ntryL,G1H16(7),wf4(:,1),G1H4(1),m3h4x4(:,2),heltab2x16(:,:,17))
  call Hloop_Q_A(ntryL,G1H4(1),35,0,G2H4(2),n2h4(12))
  call Hloop_QA_V(ntryL,G1H16(8),ex3(:),G1H8(16),m3h2x8(:,16),heltab2x16(:,:,18))
  call Hloop_QA_Z(ntryL,G1H16(9),ex3(:),G1H8(17),ngZu,m3h2x8(:,17),heltab2x16(:,:,19))
  call Hloop_QA_W(ntryL,G1H16(10),ex3(:),G1H8(18),m3h2x8(:,18),heltab2x16(:,:,20))
  call Hloop_QA_V(ntryL,G1H16(11),ex3(:),G1H8(19),m3h2x8(:,19),heltab2x16(:,:,21))
  call Hloop_QA_Z(ntryL,G1H16(12),ex3(:),G1H8(20),ngZu,m3h2x8(:,20),heltab2x16(:,:,22))
  call Hloop_AQ_W(ntryL,G1H8(6),ex4(:),G1H4(1),m3h2x4(:,11),heltab2x8(:,:,16))
  call Hloop_AQ_Z(ntryL,G1H8(7),ex4(:),G1H4(2),ngZd,m3h2x4(:,12),heltab2x8(:,:,17))
  call Hloop_AQ_W(ntryL,G1H8(8),ex4(:),G1H4(3),m3h2x4(:,13),heltab2x8(:,:,18))
  call Hloop_AQ_V(ntryL,G1H8(9),ex4(:),G1H4(4),m3h2x4(:,14),heltab2x8(:,:,19))
  call Hloop_AQ_Z(ntryL,G1H8(10),ex4(:),G1H4(5),ngZd,m3h2x4(:,15),heltab2x8(:,:,20))
  call Hloop_WA_Q(ntryL,G0H8(1),ex2(:),G0H4(1),m3h2x4(:,16),heltab2x8(:,:,21))
  call Hloop_A_Q(ntryL,G0H4(1),38,0,G1H4(6),n2h4(13))
  call Hloop_VA_Q(ntryL,G0H8(2),ex2(:),G0H4(1),m3h2x4(:,17),heltab2x8(:,:,22))
  call Hloop_A_Q(ntryL,G0H4(1),38,0,G1H4(7),n2h4(14))
  call Hloop_ZA_Q(ntryL,G0H8(3),ex2(:),G0H4(1),ngZl,m3h2x4(:,18),heltab2x8(:,:,23))
  call Hloop_A_Q(ntryL,G0H4(1),38,0,G1H4(8),n2h4(15))
  call Hloop_WQ_A(ntryL,G0H8(4),ex1(:),G0H4(1),m3h2x4(:,19),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G0H4(1),37,0,G1H4(9),n2h4(16))
  call Hloop_ZQ_A(ntryL,G0H8(5),ex1(:),G0H4(1),ngZn,m3h2x4(:,20),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G0H4(1),37,0,G1H4(10),n2h4(17))
  call Hloop_QA_W(ntryL,G1H8(1),ex3(:),G1H4(11),m3h2x4(:,21),heltab2x8(:,:,26))
  call Hloop_QA_Z(ntryL,G1H8(2),ex3(:),G1H4(12),ngZu,m3h2x4(:,22),heltab2x8(:,:,27))
  call Hloop_QA_W(ntryL,G1H8(3),ex3(:),G1H4(13),m3h2x4(:,23),heltab2x8(:,:,28))
  call Hloop_QA_V(ntryL,G1H8(4),ex3(:),G1H4(14),m3h2x4(:,24),heltab2x8(:,:,29))
  call Hloop_QA_Z(ntryL,G1H8(5),ex3(:),G1H4(15),ngZu,m3h2x4(:,25),heltab2x8(:,:,30))
  call Hloop_WA_Q(ntryL,G0H8(6),ex2(:),G0H4(1),m3h2x4(:,26),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G0H4(1),42,0,G1H4(16),n2h4(18))
  call Hloop_VA_Q(ntryL,G0H8(7),ex2(:),G0H4(1),m3h2x4(:,27),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G0H4(1),42,0,G1H4(17),n2h4(19))
  call Hloop_ZA_Q(ntryL,G0H8(8),ex2(:),G0H4(1),ngZl,m3h2x4(:,28),heltab2x8(:,:,33))
  call Hloop_A_Q(ntryL,G0H4(1),42,0,G1H4(18),n2h4(20))
  call Hloop_WQ_A(ntryL,G0H8(9),ex1(:),G0H4(1),m3h2x4(:,29),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G0H4(1),41,0,G1H4(19),n2h4(21))
  call Hloop_ZQ_A(ntryL,G0H8(10),ex1(:),G0H4(1),ngZn,m3h2x4(:,30),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G0H4(1),41,0,G1H4(20),n2h4(22))
  call Hloop_AQ_Z(ntryL,G2H4(1),ex4(:),G2H2(6),ngZd,m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_VT_S(ntryL,G1H8(11),36,ex5(:),16,G2H8(1),m3h1x8(:,6),heltab2x8(:,:,36))
  call Hloop_VT_S(ntryL,G1H8(12),36,ex5(:),16,G2H8(2),m3h1x8(:,7),heltab2x8(:,:,37))
  call Hloop_VS_V(ntryL,G1H8(13),ex5(:),G1H8(6),m3h1x8(:,8),heltab2x8(:,:,38))
  call Hloop_VS_V(ntryL,G1H8(14),ex5(:),G1H8(7),m3h1x8(:,9),heltab2x8(:,:,39))
  call Hloop_VS_V(ntryL,G1H8(15),ex5(:),G1H8(8),m3h1x8(:,10),heltab2x8(:,:,40))
  call Hloop_QA_Z(ntryL,G2H4(2),ex3(:),G2H2(1),ngZu,m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_VV_S(ntryL,G1H8(16),wf4(:,1),G1H2(1),m3h4x2(:,1),heltab2x8(:,:,41))
  call Hloop_VV_S(ntryL,G1H8(17),wf4(:,1),G1H2(2),m3h4x2(:,2),heltab2x8(:,:,42))
  call Hloop_UW_V(ntryL,G1H8(18),36,wf4(:,1),3,G2H2(2),m3h4x2(:,3),heltab2x8(:,:,43))
  call Hloop_UV_W(ntryL,G1H8(19),36,wf4(:,1),3,G2H2(7),m3h4x2(:,4),heltab2x8(:,:,44))
  call Hloop_UV_W(ntryL,G1H8(20),36,wf4(:,1),3,G2H2(8),m3h4x2(:,5),heltab2x8(:,:,45))
  call Hloop_WQ_A(ntryL,G1H4(1),ex1(:),G1H2(7),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(7),45,0,G2H2(3),n2h2(1))
  call Hloop_ZQ_A(ntryL,G1H4(2),ex1(:),G1H2(8),ngZn,m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_Q_A(ntryL,G1H2(8),45,0,G2H2(4),n2h2(2))
  call Hloop_WA_Q(ntryL,G1H4(3),ex2(:),G1H2(13),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_A_Q(ntryL,G1H2(13),46,0,G2H2(5),n2h2(3))
  call Hloop_VA_Q(ntryL,G1H4(4),ex2(:),G1H2(14),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_A_Q(ntryL,G1H2(14),46,0,G2H2(9),n2h2(4))
  call Hloop_ZA_Q(ntryL,G1H4(5),ex2(:),G1H2(19),ngZl,m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_A_Q(ntryL,G1H2(19),46,0,G2H2(10),n2h2(5))
  call Hloop_AQ_Z(ntryL,G1H4(6),ex1(:),G1H2(20),ngZn,m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_AQ_W(ntryL,G1H4(7),ex1(:),G1H2(25),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_AQ_W(ntryL,G1H4(8),ex1(:),G1H2(26),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_QA_Z(ntryL,G1H4(9),ex2(:),G1H2(31),ngZl,m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_QA_W(ntryL,G1H4(10),ex2(:),G1H2(32),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_WQ_A(ntryL,G1H4(11),ex1(:),G1H2(37),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(37),45,0,G2H2(11),n2h2(6))
  call Hloop_ZQ_A(ntryL,G1H4(12),ex1(:),G1H2(38),ngZn,m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_Q_A(ntryL,G1H2(38),45,0,G2H2(12),n2h2(7))
  call Hloop_WA_Q(ntryL,G1H4(13),ex2(:),G1H2(43),m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(43),46,0,G2H2(13),n2h2(8))
  call Hloop_VA_Q(ntryL,G1H4(14),ex2(:),G1H2(44),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_A_Q(ntryL,G1H2(44),46,0,G2H2(14),n2h2(9))
  call Hloop_ZA_Q(ntryL,G1H4(15),ex2(:),G1H2(49),ngZl,m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(49),46,0,G2H2(15),n2h2(10))
  call Hloop_AQ_Z(ntryL,G1H4(16),ex1(:),G1H2(50),ngZn,m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_AQ_W(ntryL,G1H4(17),ex1(:),G1H2(55),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_AQ_W(ntryL,G1H4(18),ex1(:),G1H2(56),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_QA_Z(ntryL,G1H4(19),ex2(:),G1H2(7),ngZl,m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_QA_W(ntryL,G1H4(20),ex2(:),G1H2(8),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_VS_V(ntryL,G2H2(6),ex5(:),G2H2(16),m3h1x2(:,6),heltab2x2(:,:,26))
  call Hloop_SV_V(ntryL,G2H8(1),wf4(:,1),G2H2(6),m3h4x2(:,6),heltab2x8(:,:,46))
  call Hloop_SV_V(ntryL,G2H8(2),wf4(:,1),G2H2(17),m3h4x2(:,7),heltab2x8(:,:,47))
  call Hloop_UV_W(ntryL,G1H8(6),52,wf4(:,1),3,G2H2(18),m3h4x2(:,8),heltab2x8(:,:,48))
  call Hloop_UW_V(ntryL,G1H8(7),52,wf4(:,1),3,G2H2(19),m3h4x2(:,9),heltab2x8(:,:,49))
  call Hloop_UW_V(ntryL,G1H8(8),52,wf4(:,1),3,G2H2(20),m3h4x2(:,10),heltab2x8(:,:,50))
  call Hloop_VS_V(ntryL,G2H2(1),ex5(:),G2H2(21),m3h1x2(:,7),heltab2x2(:,:,27))
  call Hloop_ST_V(ntryL,G1H2(1),39,ex5(:),16,G2H2(1),m3h1x2(:,8),heltab2x2(:,:,28))
  call Hloop_ST_V(ntryL,G1H2(2),39,ex5(:),16,G2H2(22),m3h1x2(:,9),heltab2x2(:,:,29))
  call Hloop_VS_V(ntryL,G2H2(2),ex5(:),G2H2(23),m3h1x2(:,10),heltab2x2(:,:,30))
  call Hloop_VS_V(ntryL,G2H2(7),ex5(:),G2H2(2),m3h1x2(:,11),heltab2x2(:,:,31))
  call Hloop_VS_V(ntryL,G2H2(8),ex5(:),G2H2(7),m3h1x2(:,12),heltab2x2(:,:,32))
  call Hloop_QA_Z(ntryL,G2H2(3),ex2(:),G2H1(1),ngZl,m3h2x1(:,21),heltab2x2(:,:,33))
  call Hloop_QA_W(ntryL,G2H2(4),ex2(:),G2H1(2),m3h2x1(:,22),heltab2x2(:,:,34))
  call Hloop_AQ_Z(ntryL,G2H2(5),ex1(:),G2H1(3),ngZn,m3h2x1(:,23),heltab2x2(:,:,35))
  call Hloop_AQ_W(ntryL,G2H2(9),ex1(:),G2H1(4),m3h2x1(:,24),heltab2x2(:,:,36))
  call Hloop_AQ_W(ntryL,G2H2(10),ex1(:),G2H1(5),m3h2x1(:,25),heltab2x2(:,:,37))
  call Hloop_VS_V(ntryL,G1H2(20),ex5(:),G1H2(13),m3h1x2(:,13),heltab2x2(:,:,38))
  call Hloop_VS_V(ntryL,G1H2(25),ex5(:),G1H2(14),m3h1x2(:,14),heltab2x2(:,:,39))
  call Hloop_VS_V(ntryL,G1H2(26),ex5(:),G1H2(19),m3h1x2(:,15),heltab2x2(:,:,40))
  call Hloop_VS_V(ntryL,G1H2(31),ex5(:),G1H2(37),m3h1x2(:,16),heltab2x2(:,:,41))
  call Hloop_VS_V(ntryL,G1H2(32),ex5(:),G1H2(38),m3h1x2(:,17),heltab2x2(:,:,42))
  call Hloop_QA_Z(ntryL,G2H2(11),ex2(:),G2H1(6),ngZl,m3h2x1(:,26),heltab2x2(:,:,43))
  call Hloop_QA_W(ntryL,G2H2(12),ex2(:),G2H1(7),m3h2x1(:,27),heltab2x2(:,:,44))
  call Hloop_AQ_Z(ntryL,G2H2(13),ex1(:),G2H1(8),ngZn,m3h2x1(:,28),heltab2x2(:,:,45))
  call Hloop_AQ_W(ntryL,G2H2(14),ex1(:),G2H1(9),m3h2x1(:,29),heltab2x2(:,:,46))
  call Hloop_AQ_W(ntryL,G2H2(15),ex1(:),G2H1(10),m3h2x1(:,30),heltab2x2(:,:,47))
  call Hloop_VS_V(ntryL,G1H2(50),ex5(:),G1H2(43),m3h1x2(:,18),heltab2x2(:,:,48))
  call Hloop_VS_V(ntryL,G1H2(55),ex5(:),G1H2(44),m3h1x2(:,19),heltab2x2(:,:,49))
  call Hloop_VS_V(ntryL,G1H2(56),ex5(:),G1H2(49),m3h1x2(:,20),heltab2x2(:,:,50))
  call Hloop_VS_V(ntryL,G1H2(7),ex5(:),G1H2(1),m3h1x2(:,21),heltab2x2(:,:,51))
  call Hloop_VS_V(ntryL,G1H2(8),ex5(:),G1H2(2),m3h1x2(:,22),heltab2x2(:,:,52))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(37),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(23),[G1H2(29),G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(38),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(7),[G2H2(22),G1H2(41),G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G1H2(48),G1H2(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G2H2(17),G1H2(60),G1H2(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(13),[G1H2(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(14),[G1H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(40),[G1H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G2H2(1),G1H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(19),[G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G2H2(6),G1H2(54)])
  call Hloop_ZQ_A(ntryL,G1H2(37),ex4(:),G1H1(1),ngZd,m3h2x1(:,31),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(1),n2h1(21))
  call Hloop_ZQ_A(ntryL,G1H2(4),ex4(:),G1H1(1),ngZd,m3h2x1(:,32),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(3),n2h1(22))
  call Hotf_5pt_reduction(G2H2(23),RedSet_5(5),mass5set(:,6),  & 
G1H2(20),G1H2(25),G1H2(26),G1H2(31),G1H2(32),G1H2(50),2)
  call HG1shiftOLR(G1H2(25),8,2)
  call Hloop_ZQ_A(ntryL,G1H2(6),ex4(:),G1H1(1),ngZd,m3h2x1(:,33),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(5),n2h1(23))
  call Hloop_WQ_A(ntryL,G1H2(38),ex4(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(7),n2h1(24))
  call Hloop_WQ_A(ntryL,G1H2(10),ex4(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(9),n2h1(25))
  call Hotf_5pt_reduction(G2H2(7),RedSet_5(5),mass5set(:,7),  & 
G1H2(55),G1H2(56),G1H2(7),G1H2(8),G1H2(3),G1H2(29),2)
  call HG1shiftOLR(G1H2(56),8,2)
  call Hloop_WQ_A(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(11),n2h1(26))
  call Hloop_WQ_A(ntryL,G1H2(15),ex4(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(13),n2h1(27))
  call Hloop_WQ_A(ntryL,G1H2(16),ex4(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(28))
  call Hloop_WQ_A(ntryL,G1H2(17),ex4(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(17),n2h1(29))
  call Hotf_5pt_reduction(G2H2(18),RedSet_5(6),mass5set(:,8),  & 
G1H2(5),G1H2(9),G1H2(41),G1H2(11),G1H2(48),G1H2(18),2)
  call HG1shiftOLR(G1H2(9),8,2)
  call Hloop_ZQ_A(ntryL,G1H2(21),ex4(:),G1H1(1),ngZd,m3h2x1(:,40),heltab2x2(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(30))
  call Hloop_ZQ_A(ntryL,G1H2(22),ex4(:),G1H1(1),ngZd,m3h2x1(:,41),heltab2x2(:,:,63))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(31))
  call Hloop_ZQ_A(ntryL,G1H2(23),ex4(:),G1H1(1),ngZd,m3h2x1(:,42),heltab2x2(:,:,64))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(22),n2h1(32))
  call Hotf_5pt_reduction(G2H2(20),RedSet_5(6),mass5set(:,9),  & 
G1H2(60),G1H2(24),G1H2(27),G1H2(33),G1H2(34),G1H2(35),2)
  call HG1shiftOLR(G1H2(24),8,2)
  call Hloop_ZQ_A(ntryL,G1H2(13),ex4(:),G1H1(1),ngZd,m3h2x1(:,43),heltab2x2(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(33))
  call Hloop_ZQ_A(ntryL,G1H2(28),ex4(:),G1H1(1),ngZd,m3h2x1(:,44),heltab2x2(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(24),n2h1(34))
  call Hloop_ZQ_A(ntryL,G1H2(30),ex4(:),G1H1(1),ngZd,m3h2x1(:,45),heltab2x2(:,:,67))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(25),n2h1(35))
  call Hloop_WQ_A(ntryL,G1H2(14),ex4(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(26),n2h1(36))
  call Hloop_WQ_A(ntryL,G1H2(40),ex4(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,69))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(27),n2h1(37))
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(5),mass5set(:,10),  & 
G1H2(39),G1H2(54),G1H2(37),G1H2(4),G1H2(6),G1H2(38),2)
  call HG1shiftOLR(G1H2(54),8,2)
  call Hloop_WQ_A(ntryL,G1H2(36),ex4(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,70))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(28),n2h1(38))
  call Hloop_WQ_A(ntryL,G1H2(19),ex4(:),G1H1(1),m3h2x1(:,49),heltab2x2(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(39))
  call Hloop_WQ_A(ntryL,G1H2(42),ex4(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(30),n2h1(40))
  call Hloop_WQ_A(ntryL,G1H2(45),ex4(:),G1H1(1),m3h2x1(:,51),heltab2x2(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(41))
  call Hloop_WQ_A(ntryL,G1H2(46),ex4(:),G1H1(1),m3h2x1(:,52),heltab2x2(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(32),n2h1(42))
  call Hloop_WQ_A(ntryL,G1H2(47),ex4(:),G1H1(1),m3h2x1(:,53),heltab2x2(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(33),n2h1(43))
  call Hloop_VQ_A(ntryL,G1H2(51),ex4(:),G1H1(1),m3h2x1(:,54),heltab2x2(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(34),n2h1(44))
  call Hloop_VQ_A(ntryL,G1H2(52),ex4(:),G1H1(1),m3h2x1(:,55),heltab2x2(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(35),n2h1(45))
  call Hloop_VQ_A(ntryL,G1H2(53),ex4(:),G1H1(1),m3h2x1(:,56),heltab2x2(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(36),n2h1(46))
  call Hotf_5pt_reduction(G2H2(19),RedSet_5(6),mass5set(:,4),  & 
G1H2(10),G1H2(12),G1H2(15),G1H2(16),G1H2(17),G1H2(21),2)
  call HG1shiftOLR(G1H2(12),8,2)
  call Hloop_ZQ_A(ntryL,G1H2(57),ex4(:),G1H1(1),ngZd,m3h2x1(:,57),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(47))
  call Hloop_ZQ_A(ntryL,G1H2(58),ex4(:),G1H1(1),ngZd,m3h2x1(:,58),heltab2x2(:,:,80))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(38),n2h1(48))
  call Hloop_ZQ_A(ntryL,G1H2(59),ex4(:),G1H1(1),ngZd,m3h2x1(:,59),heltab2x2(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(39),n2h1(49))
  call Hotf_5pt_reduction(G2H2(16),RedSet_5(7),mass5set(:,11),  & 
G1H2(22),G1H2(23),G1H2(13),G1H2(28),G1H2(30),G1H2(14),2)
  call HG1shiftOLR(G1H2(23),4,2)
  call Hotf_5pt_reduction(G2H2(21),RedSet_5(8),mass5set(:,11),  & 
G1H2(40),G1H2(36),G1H2(19),G1H2(42),G1H2(45),G1H2(46),2)
  call HG1shiftOLR(G1H2(36),8,2)
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(1),ex5(:),G2tensor(40),m3h1x1(:,1),heltab2x1(:,:,1))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(2),ex5(:),G2tensor(41),m3h1x1(:,2),heltab2x1(:,:,2))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(3),ex5(:),G2tensor(42),m3h1x1(:,3),heltab2x1(:,:,3))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(4),ex5(:),G2tensor(43),m3h1x1(:,4),heltab2x1(:,:,4))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(5),ex5(:),G2tensor(44),m3h1x1(:,5),heltab2x1(:,:,5))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(6),ex5(:),G2tensor(45),m3h1x1(:,6),heltab2x1(:,:,6))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(7),ex5(:),G2tensor(46),m3h1x1(:,7),heltab2x1(:,:,7))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(8),ex5(:),G2tensor(47),m3h1x1(:,8),heltab2x1(:,:,8))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(9),ex5(:),G2tensor(48),m3h1x1(:,9),heltab2x1(:,:,9))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(10),ex5(:),G2tensor(49),m3h1x1(:,10),heltab2x1(:,:,10))
  call Hloop_ZA_Q(ntryL,G1H2(43),ex3(:),G1H1(1),ngZu,m3h2x1(:,60),heltab2x2(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(50),n2h1(50))
  call Hloop_WA_Q(ntryL,G1H2(44),ex3(:),G1H1(1),m3h2x1(:,61),heltab2x2(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(51),n2h1(51))
  call Hloop_WA_Q(ntryL,G1H2(49),ex3(:),G1H1(1),m3h2x1(:,62),heltab2x2(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(52),n2h1(52))
  call Hloop_ZA_Q(ntryL,G1H2(1),ex3(:),G1H1(1),ngZu,m3h2x1(:,63),heltab2x2(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(53),n2h1(53))
  call Hloop_WA_Q(ntryL,G1H2(2),ex3(:),G1H1(1),m3h2x1(:,64),heltab2x2(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(54),n2h1(54))
  call Hloop_ZQ_A(ntryL,G1H2(20),ex4(:),G1H1(1),ngZd,m3h2x1(:,65),heltab2x2(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(55),n2h1(55))
  call Hloop_ZQ_A(ntryL,G1H2(25),ex4(:),G1H1(1),ngZd,m3h2x1(:,66),heltab2x2(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(56),n2h1(56))
  call Hloop_ZQ_A(ntryL,G1H2(50),ex4(:),G1H1(1),ngZd,m3h2x1(:,67),heltab2x2(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(57),n2h1(57))
  call Hloop_WQ_A(ntryL,G1H2(55),ex4(:),G1H1(1),m3h2x1(:,68),heltab2x2(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(58),n2h1(58))
  call Hloop_WQ_A(ntryL,G1H2(56),ex4(:),G1H1(1),m3h2x1(:,69),heltab2x2(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(59),n2h1(59))
  call Hloop_WQ_A(ntryL,G1H2(29),ex4(:),G1H1(1),m3h2x1(:,70),heltab2x2(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(60),n2h1(60))
  call Hloop_WQ_A(ntryL,G1H2(5),ex4(:),G1H1(1),m3h2x1(:,71),heltab2x2(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(61),n2h1(61))
  call Hloop_WQ_A(ntryL,G1H2(9),ex4(:),G1H1(1),m3h2x1(:,72),heltab2x2(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(62),n2h1(62))
  call Hloop_WQ_A(ntryL,G1H2(18),ex4(:),G1H1(1),m3h2x1(:,73),heltab2x2(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(63),n2h1(63))
  call Hloop_ZQ_A(ntryL,G1H2(60),ex4(:),G1H1(1),ngZd,m3h2x1(:,74),heltab2x2(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(64),n2h1(64))
  call Hloop_ZQ_A(ntryL,G1H2(24),ex4(:),G1H1(1),ngZd,m3h2x1(:,75),heltab2x2(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(65),n2h1(65))
  call Hloop_ZQ_A(ntryL,G1H2(35),ex4(:),G1H1(1),ngZd,m3h2x1(:,76),heltab2x2(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(66),n2h1(66))
  call Hloop_WQ_A(ntryL,G1H2(39),ex4(:),G1H1(1),m3h2x1(:,77),heltab2x2(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(67),n2h1(67))
  call Hloop_WQ_A(ntryL,G1H2(54),ex4(:),G1H1(1),m3h2x1(:,78),heltab2x2(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(68),n2h1(68))
  call Hloop_WQ_A(ntryL,G1H2(38),ex4(:),G1H1(1),m3h2x1(:,79),heltab2x2(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(69),n2h1(69))
  call Hloop_VQ_A(ntryL,G1H2(10),ex4(:),G1H1(1),m3h2x1(:,80),heltab2x2(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(70),n2h1(70))
  call Hloop_VQ_A(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,81),heltab2x2(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(71),n2h1(71))
  call Hloop_VQ_A(ntryL,G1H2(21),ex4(:),G1H1(1),m3h2x1(:,82),heltab2x2(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(72),n2h1(72))
  call Hloop_ZA_Q(ntryL,G1H2(22),ex3(:),G1H1(1),ngZu,m3h2x1(:,83),heltab2x2(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(73),n2h1(73))
  call Hloop_ZA_Q(ntryL,G1H2(23),ex3(:),G1H1(1),ngZu,m3h2x1(:,84),heltab2x2(:,:,106))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(74),n2h1(74))
  call Hloop_ZA_Q(ntryL,G1H2(14),ex3(:),G1H1(1),ngZu,m3h2x1(:,85),heltab2x2(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(75),n2h1(75))
  call Hloop_ZQ_A(ntryL,G1H2(40),ex4(:),G1H1(1),ngZd,m3h2x1(:,86),heltab2x2(:,:,108))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(76),n2h1(76))
  call Hloop_ZQ_A(ntryL,G1H2(36),ex4(:),G1H1(1),ngZd,m3h2x1(:,87),heltab2x2(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),8,0,G2tensor(77),n2h1(77))
  call Hloop_ZQ_A(ntryL,G1H2(46),ex4(:),G1H1(1),ngZd,m3h2x1(:,88),heltab2x2(:,:,110))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(78),n2h1(78))
  call ol_merge_tensors(G2tensor(45),[G2tensor(2),G1tensor(2)])
  call ol_merge_tensors(G2tensor(46),[G2tensor(4),G1tensor(8)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(14)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(20)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(10),G1tensor(26)])
  call ol_merge_tensors(G2tensor(48),[G2tensor(12),G1tensor(32)])
  call ol_merge_tensors(G2tensor(49),[G2tensor(14),G1tensor(38)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(44)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(50)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(56)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(55),[G1tensor(29),G1tensor(5)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(6)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(41),G1tensor(11)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(12)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(17)])
  call ol_merge_tensors(G2tensor(61),[G1tensor(48),G1tensor(18)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(22)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(23)])
  call ol_merge_tensors(G2tensor(64),[G1tensor(60),G1tensor(24)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(27)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(28)])
  call ol_merge_tensors(G2tensor(25),[G1tensor(30)])
  call ol_merge_tensors(G2tensor(26),[G1tensor(33)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(40),G1tensor(34)])
  call ol_merge_tensors(G2tensor(67),[G1tensor(35)])
  call ol_merge_tensors(G2tensor(28),[G1tensor(36)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(39)])
  call ol_merge_tensors(G2tensor(30),[G1tensor(42)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(45)])
  call ol_merge_tensors(G2tensor(32),[G1tensor(46)])
  call ol_merge_tensors(G2tensor(33),[G1tensor(47)])
  call ol_merge_tensors(G2tensor(34),[G1tensor(51)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(52)])
  call ol_merge_tensors(G2tensor(36),[G1tensor(53)])
  call ol_merge_tensors(G2tensor(70),[G1tensor(54)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(57)])
  call ol_merge_tensors(G2tensor(38),[G1tensor(58)])
  call ol_merge_tensors(G2tensor(39),[G1tensor(59)])
  call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(9),mass5set(:,12),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25),G1tensor(31))
  call G_TensorShift(G1tensor(7),16)
  call Hotf_5pt_reduction_last(G2tensor(46),RedSet_5(9),mass5set(:,13),  & 
G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55),G1tensor(2),G1tensor(8))
  call G_TensorShift(G1tensor(43),16)
  call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(10),mass5set(:,14),  & 
G1tensor(14),G1tensor(20),G1tensor(26),G1tensor(32),G1tensor(38),G1tensor(44))
  call G_TensorShift(G1tensor(20),1)
  call Hotf_5pt_reduction_last(G2tensor(8),RedSet_5(10),mass5set(:,15),  & 
G1tensor(50),G1tensor(56),G1tensor(3),G1tensor(4),G1tensor(29),G1tensor(5))
  call G_TensorShift(G1tensor(56),1)
  call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(11),mass5set(:,12),  & 
G1tensor(6),G1tensor(9),G1tensor(10),G1tensor(41),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(9),16)
  call Hotf_5pt_reduction_last(G2tensor(48),RedSet_5(11),mass5set(:,16),  & 
G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(48),G1tensor(18),G1tensor(21))
  call G_TensorShift(G1tensor(16),16)
  call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(11),mass5set(:,13),  & 
G1tensor(22),G1tensor(23),G1tensor(60),G1tensor(24),G1tensor(27),G1tensor(28))
  call G_TensorShift(G1tensor(23),16)
  call Hotf_5pt_reduction_last(G2tensor(16),RedSet_5(12),mass5set(:,14),  & 
G1tensor(30),G1tensor(33),G1tensor(40),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(33),2)
  call Hotf_5pt_reduction_last(G2tensor(18),RedSet_5(12),mass5set(:,4),  & 
G1tensor(39),G1tensor(42),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(51))
  call G_TensorShift(G1tensor(42),2)
  call Hotf_5pt_reduction_last(G2tensor(20),RedSet_5(12),mass5set(:,15),  & 
G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(57),G1tensor(58),G1tensor(59))
  call G_TensorShift(G1tensor(53),2)
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(13),mass5set(:,17),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
  call G_TensorShift(G1tensor(62),8)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(14),mass5set(:,11),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
  call G_TensorShift(G1tensor(68),8)
  call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(5),mass5set(:,6),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(74),8)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(15),mass5set(:,1),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
  call G_TensorShift(G1tensor(80),8)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(13),mass5set(:,18),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(86),8)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(14),mass5set(:,10),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
  call G_TensorShift(G1tensor(92),8)
  call Hotf_5pt_reduction_last(G2tensor(58),RedSet_5(5),mass5set(:,7),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
  call G_TensorShift(G1tensor(98),8)
  call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(15),mass5set(:,2),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
  call G_TensorShift(G1tensor(104),8)
  call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(16),mass5set(:,19),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
  call G_TensorShift(G1tensor(110),8)
  call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(17),mass5set(:,2),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(116),8)
  call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(18),mass5set(:,2),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
  call G_TensorShift(G1tensor(122),8)
  call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(6),mass5set(:,8),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
  call G_TensorShift(G1tensor(128),8)
  call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(16),mass5set(:,20),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
  call G_TensorShift(G1tensor(134),8)
  call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(17),mass5set(:,1),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
  call G_TensorShift(G1tensor(140),8)
  call Hotf_5pt_reduction_last(G2tensor(22),RedSet_5(18),mass5set(:,1),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(146),8)
  call Hotf_5pt_reduction_last(G2tensor(64),RedSet_5(6),mass5set(:,9),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
  call G_TensorShift(G1tensor(152),8)
  call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(19),mass5set(:,17),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
  call G_TensorShift(G1tensor(158),8)
  call Hotf_5pt_reduction_last(G2tensor(24),RedSet_5(20),mass5set(:,11),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
  call G_TensorShift(G1tensor(164),8)
  call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(21),mass5set(:,1),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
  call G_TensorShift(G1tensor(170),8)
  call Hotf_5pt_reduction_last(G2tensor(26),RedSet_5(19),mass5set(:,10),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
  call G_TensorShift(G1tensor(176),8)
  call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(20),mass5set(:,10),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
  call G_TensorShift(G1tensor(182),8)
  call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(5),mass5set(:,10),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
  call G_TensorShift(G1tensor(188),8)
  call Hotf_5pt_reduction_last(G2tensor(28),RedSet_5(21),mass5set(:,5),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
  call G_TensorShift(G1tensor(194),8)
  call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(19),mass5set(:,18),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
  call G_TensorShift(G1tensor(200),8)
  call Hotf_5pt_reduction_last(G2tensor(30),RedSet_5(21),mass5set(:,2),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
  call G_TensorShift(G1tensor(206),8)
  call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(22),mass5set(:,19),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
  call G_TensorShift(G1tensor(212),8)
  call Hotf_5pt_reduction_last(G2tensor(32),RedSet_5(23),mass5set(:,2),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
  call G_TensorShift(G1tensor(218),8)
  call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(24),mass5set(:,2),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
  call G_TensorShift(G1tensor(224),8)
  call Hotf_5pt_reduction_last(G2tensor(34),RedSet_5(22),mass5set(:,21),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(230),8)
  call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(23),mass5set(:,22),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
  call G_TensorShift(G1tensor(236),8)
  call Hotf_5pt_reduction_last(G2tensor(36),RedSet_5(24),mass5set(:,22),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
  call G_TensorShift(G1tensor(242),8)
  call Hotf_5pt_reduction_last(G2tensor(70),RedSet_5(6),mass5set(:,4),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
  call G_TensorShift(G1tensor(248),8)
  call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(22),mass5set(:,20),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257),G1tensor(258))
  call G_TensorShift(G1tensor(254),8)
  call Hotf_5pt_reduction_last(G2tensor(38),RedSet_5(23),mass5set(:,1),  & 
G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264))
  call G_TensorShift(G1tensor(260),8)
  call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(24),mass5set(:,1),  & 
G1tensor(265),G1tensor(266),G1tensor(267),G1tensor(268),G1tensor(269),G1tensor(270))
  call G_TensorShift(G1tensor(266),8)
  call Hotf_5pt_reduction_last(G2tensor(40),RedSet_5(25),mass5set(:,12),  & 
G1tensor(271),G1tensor(272),G1tensor(273),G1tensor(274),G1tensor(275),G1tensor(276))
  call G_TensorShift(G1tensor(272),16)
  call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(25),mass5set(:,13),  & 
G1tensor(277),G1tensor(278),G1tensor(279),G1tensor(280),G1tensor(281),G1tensor(282))
  call G_TensorShift(G1tensor(278),16)
  call Hotf_5pt_reduction_last(G2tensor(42),RedSet_5(26),mass5set(:,12),  & 
G1tensor(283),G1tensor(284),G1tensor(285),G1tensor(286),G1tensor(287),G1tensor(288))
  call G_TensorShift(G1tensor(284),16)
  call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(26),mass5set(:,16),  & 
G1tensor(289),G1tensor(290),G1tensor(291),G1tensor(292),G1tensor(293),G1tensor(294))
  call G_TensorShift(G1tensor(290),16)
  call Hotf_5pt_reduction_last(G2tensor(44),RedSet_5(26),mass5set(:,13),  & 
G1tensor(295),G1tensor(296),G1tensor(297),G1tensor(298),G1tensor(299),G1tensor(300))
  call G_TensorShift(G1tensor(296),16)
  call Hotf_5pt_reduction_last(G2tensor(50),RedSet_5(27),mass5set(:,17),  & 
G1tensor(301),G1tensor(302),G1tensor(303),G1tensor(304),G1tensor(305),G1tensor(306))
  call G_TensorShift(G1tensor(302),4)
  call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(27),mass5set(:,10),  & 
G1tensor(307),G1tensor(308),G1tensor(309),G1tensor(310),G1tensor(311),G1tensor(312))
  call G_TensorShift(G1tensor(308),4)
  call Hotf_5pt_reduction_last(G2tensor(52),RedSet_5(27),mass5set(:,18),  & 
G1tensor(313),G1tensor(314),G1tensor(315),G1tensor(316),G1tensor(317),G1tensor(318))
  call G_TensorShift(G1tensor(314),4)
  call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(28),mass5set(:,17),  & 
G1tensor(319),G1tensor(320),G1tensor(321),G1tensor(322),G1tensor(323),G1tensor(324))
  call G_TensorShift(G1tensor(320),4)
  call Hotf_5pt_reduction_last(G2tensor(54),RedSet_5(28),mass5set(:,18),  & 
G1tensor(325),G1tensor(326),G1tensor(327),G1tensor(328),G1tensor(329),G1tensor(330))
  call G_TensorShift(G1tensor(326),4)
  call Hotf_5pt_reduction_last(G2tensor(73),RedSet_5(7),mass5set(:,11),  & 
G1tensor(331),G1tensor(332),G1tensor(333),G1tensor(334),G1tensor(335),G1tensor(336))
  call G_TensorShift(G1tensor(332),4)
  call Hotf_5pt_reduction_last(G2tensor(76),RedSet_5(8),mass5set(:,11),  & 
G1tensor(337),G1tensor(338),G1tensor(339),G1tensor(340),G1tensor(341),G1tensor(342))
  call G_TensorShift(G1tensor(338),8)
  call ol_merge_tensors(T1sum(11),[G1tensor(1)])
  call ol_merge_tensors(T1sum(12),[G1tensor(37)])
  call ol_merge_tensors(T1sum(13),[G1tensor(14)])
  call ol_merge_tensors(T1sum(14),[G1tensor(50)])
  call ol_merge_tensors(T1sum(15),[G1tensor(6)])
  call ol_merge_tensors(T1sum(16),[G1tensor(15)])
  call ol_merge_tensors(T1sum(17),[G1tensor(22)])
  call ol_merge_tensors(T1sum(18),[G1tensor(30)])
  call ol_merge_tensors(T1sum(19),[G1tensor(39)])
  call ol_merge_tensors(T1sum(20),[G1tensor(52)])
  call ol_merge_tensors(T1sum(21),[G1tensor(61)])
  call ol_merge_tensors(T1sum(22),[G1tensor(67)])
  call ol_merge_tensors(T1sum(23),[G1tensor(73)])
  call ol_merge_tensors(T1sum(24),[G1tensor(79)])
  call ol_merge_tensors(T1sum(25),[G1tensor(85)])
  call ol_merge_tensors(T1sum(26),[G1tensor(91)])
  call ol_merge_tensors(T1sum(27),[G1tensor(97)])
  call ol_merge_tensors(T1sum(28),[G1tensor(103)])
  call ol_merge_tensors(T1sum(29),[G1tensor(109)])
  call ol_merge_tensors(T1sum(30),[G1tensor(115)])
  call ol_merge_tensors(T1sum(31),[G1tensor(121)])
  call ol_merge_tensors(T1sum(32),[G1tensor(127)])
  call ol_merge_tensors(T1sum(33),[G1tensor(133)])
  call ol_merge_tensors(T1sum(34),[G1tensor(139)])
  call ol_merge_tensors(T1sum(35),[G1tensor(145)])
  call ol_merge_tensors(T1sum(36),[G1tensor(151)])
  call ol_merge_tensors(T1sum(37),[G1tensor(157)])
  call ol_merge_tensors(T1sum(38),[G1tensor(163)])
  call ol_merge_tensors(T1sum(39),[G1tensor(169)])
  call ol_merge_tensors(T1sum(40),[G1tensor(175)])
  call ol_merge_tensors(T1sum(41),[G1tensor(181)])
  call ol_merge_tensors(T1sum(42),[G1tensor(187)])
  call ol_merge_tensors(T1sum(43),[G1tensor(193)])
  call ol_merge_tensors(T1sum(44),[G1tensor(199)])
  call ol_merge_tensors(T1sum(45),[G1tensor(205)])
  call ol_merge_tensors(T1sum(46),[G1tensor(211)])
  call ol_merge_tensors(T1sum(47),[G1tensor(217)])
  call ol_merge_tensors(T1sum(48),[G1tensor(223)])
  call ol_merge_tensors(T1sum(49),[G1tensor(229)])
  call ol_merge_tensors(T1sum(50),[G1tensor(235)])
  call ol_merge_tensors(T1sum(51),[G1tensor(241)])
  call ol_merge_tensors(T1sum(52),[G1tensor(247)])
  call ol_merge_tensors(T1sum(53),[G1tensor(253)])
  call ol_merge_tensors(T1sum(54),[G1tensor(259)])
  call ol_merge_tensors(T1sum(55),[G1tensor(265)])
  call ol_merge_tensors(T1sum(56),[G1tensor(271)])
  call ol_merge_tensors(T1sum(57),[G1tensor(277)])
  call ol_merge_tensors(T1sum(58),[G1tensor(283)])
  call ol_merge_tensors(T1sum(59),[G1tensor(289)])
  call ol_merge_tensors(T1sum(60),[G1tensor(295)])
  call ol_merge_tensors(T1sum(61),[G1tensor(301)])
  call ol_merge_tensors(T1sum(62),[G1tensor(307)])
  call ol_merge_tensors(T1sum(63),[G1tensor(313)])
  call ol_merge_tensors(T1sum(64),[G1tensor(319)])
  call ol_merge_tensors(T1sum(65),[G1tensor(325)])
  call ol_merge_tensors(T1sum(66),[G1tensor(331)])
  call ol_merge_tensors(T1sum(67),[G1tensor(337)])
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(43),h0tab(:,43),[36,3,8,16],[0,0,nMZ,nMZ],4,2,wf4(:,3),wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(1),ngZu,m3h4x8(:,21),heltab2x32(:,:,43))
  call Hloop_A_Q(ntryL,G0H8(1),36,0,G1H8(9),n2h8(11))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(44),h0tab(:,44),[36,3,16,8],[0,nMW,nMW,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,3),G0H8(2),m3h4x8(:,22),heltab2x32(:,:,44))
  Gcoeff(:)%j = (c(28)*M(2,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(45),h0tab(:,45),[36,3,16,8],[nMZ,nMW,nMW,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,3),G0H8(3),ngZu,m3h4x8(:,23),heltab2x32(:,:,45))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(46),h0tab(:,46),[36,3,16,8],[nMW,nMZ,nMZ,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_QA_W(ntryL,G0H32(1),wf4(:,3),G0H8(4),m3h4x8(:,24),heltab2x32(:,:,46))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(47),h0tab(:,47),[36,3,16,8],[0,nMW,nMW,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,3),G0H8(5),m3h4x8(:,25),heltab2x32(:,:,47))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(48),h0tab(:,48),[36,3,16,8],[nMZ,nMW,nMW,0],4,2,wf4(:,3),wf4(:,1))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,3),G0H8(6),ngZu,m3h4x8(:,26),heltab2x32(:,:,48))
  Gcoeff(:)%j = (c(14)*M(2,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(49),h0tab(:,49),[36,8,3,16],[0,0,nMW,nMW],4,2,wf4(:,3),wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(7),m3h4x8(:,27),heltab2x32(:,:,49))
  call Hloop_A_Q(ntryL,G0H8(7),36,0,G1H8(10),n2h8(12))
  Gcoeff(:)%j = (c(28)*M(2,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(50),h0tab(:,50),[36,8,3,16],[0,nMZ,nMW,nMW],4,2,wf4(:,3),wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(8),m3h4x8(:,28),heltab2x32(:,:,50))
  call Hloop_A_Q(ntryL,G0H8(8),36,0,G1H8(1),n2h8(13))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(51),h0tab(:,51),[36,8,3,16],[0,nMW,nMZ,nMZ],4,2,wf4(:,3),wf4(:,1))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(9),ngZu,m3h4x8(:,29),heltab2x32(:,:,51))
  call Hloop_A_Q(ntryL,G0H8(9),36,0,G1H8(2),n2h8(14))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(52),h0tab(:,52),[36,8,3,16],[0,0,nMW,nMW],4,2,wf4(:,3),wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(10),m3h4x8(:,30),heltab2x32(:,:,52))
  call Hloop_A_Q(ntryL,G0H8(10),36,0,G1H8(3),n2h8(15))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(31)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(53),h0tab(:,53),[36,8,3,16],[0,nMZ,nMW,nMW],4,2,wf4(:,3),wf4(:,1))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(1),m3h4x8(:,31),heltab2x32(:,:,53))
  call Hloop_A_Q(ntryL,G0H8(1),36,0,G1H8(4),n2h8(16))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(54),h0tab(:,54),[40,3,4,16],[0,0,nMZ,nMZ],4,2,wf4(:,6),wf4(:,1))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,6),G0H8(7),ngZd,m3h4x8(:,32),heltab2x32(:,:,54))
  call Hloop_Q_A(ntryL,G0H8(7),40,0,G1H8(5),n2h8(17))
  Gcoeff(:)%j = (c(14)*M(2,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(55),h0tab(:,55),[40,3,16,4],[0,nMW,nMW,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,6),G0H8(8),m3h4x8(:,33),heltab2x32(:,:,55))
  Gcoeff(:)%j = (c(28)*M(2,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(56),h0tab(:,56),[40,3,16,4],[nMZ,nMW,nMW,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,6),G0H8(9),ngZd,m3h4x8(:,34),heltab2x32(:,:,56))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(57),h0tab(:,57),[40,3,16,4],[nMW,nMZ,nMZ,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AQ_W(ntryL,G0H32(1),wf4(:,6),G0H8(10),m3h4x8(:,35),heltab2x32(:,:,57))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(58),h0tab(:,58),[40,3,16,4],[0,nMW,nMW,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,6),G0H8(1),m3h4x8(:,36),heltab2x32(:,:,58))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(59),h0tab(:,59),[40,3,16,4],[nMZ,nMW,nMW,0],4,2,wf4(:,6),wf4(:,1))
  call Hloop_AQ_Z(ntryL,G0H32(1),wf4(:,6),G0H8(7),ngZd,m3h4x8(:,37),heltab2x32(:,:,59))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(60),h0tab(:,60),[40,4,3,16],[0,0,nMW,nMW],4,2,wf4(:,6),wf4(:,1))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,6),G0H8(11),m3h4x8(:,38),heltab2x32(:,:,60))
  call Hloop_Q_A(ntryL,G0H8(11),40,0,G1H8(11),n2h8(18))
  Gcoeff(:)%j = (c(28)*M(2,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(61),h0tab(:,61),[40,4,3,16],[0,nMZ,nMW,nMW],4,2,wf4(:,6),wf4(:,1))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,6),G0H8(11),m3h4x8(:,39),heltab2x32(:,:,61))
  call Hloop_Q_A(ntryL,G0H8(11),40,0,G1H8(12),n2h8(19))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(62),h0tab(:,62),[40,4,3,16],[0,nMW,nMZ,nMZ],4,2,wf4(:,6),wf4(:,1))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,6),G0H8(11),ngZd,m3h4x8(:,40),heltab2x32(:,:,62))
  call Hloop_Q_A(ntryL,G0H8(11),40,0,G1H8(13),n2h8(20))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(63),h0tab(:,63),[40,4,3,16],[0,0,nMW,nMW],4,2,wf4(:,6),wf4(:,1))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,6),G0H8(11),m3h4x8(:,41),heltab2x32(:,:,63))
  call Hloop_Q_A(ntryL,G0H8(11),40,0,G1H8(14),n2h8(21))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(64),h0tab(:,64),[40,4,3,16],[0,nMZ,nMW,nMW],4,2,wf4(:,6),wf4(:,1))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,6),G0H8(11),m3h4x8(:,42),heltab2x32(:,:,64))
  call Hloop_Q_A(ntryL,G0H8(11),40,0,G1H8(15),n2h8(22))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(65),h0tab(:,65),[32,7,16,8],[0,nMZ,nMZ,0],4,1,wf8(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,65))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(1),n2h16(23))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(66),h0tab(:,66),[32,7,16,8],[0,nMW,nMW,0],4,1,wf8(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,24),heltab2x32(:,:,66))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(2),n2h16(24))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(67),h0tab(:,67),[32,4,16,11],[0,nMZ,nMZ,0],4,1,wf8(:,22))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,25),heltab2x32(:,:,67))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(3),n2h16(25))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(68),h0tab(:,68),[32,4,16,11],[0,nMW,nMW,0],4,1,wf8(:,22))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,26),heltab2x32(:,:,68))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(4),n2h16(26))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(69),h0tab(:,69),[32,4,8,19],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,27),heltab2x32(:,:,69))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(5),n2h16(27))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(70),h0tab(:,70),[32,4,8,19],[0,nMZ,0,0],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,28),heltab2x32(:,:,70))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(6),n2h16(28))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(71),h0tab(:,71),[32,4,8,19],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,29),heltab2x32(:,:,71))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(7),n2h16(29))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(72),h0tab(:,72),[32,8,4,19],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,30),heltab2x32(:,:,72))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(8),n2h16(30))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(73),h0tab(:,73),[32,8,4,19],[0,nMZ,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,31),heltab2x32(:,:,73))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(9),n2h16(31))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(74),h0tab(:,74),[32,8,4,19],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,32),heltab2x32(:,:,74))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(10),n2h16(32))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(75),h0tab(:,75),[32,4,19,8],[0,0,nMW,0],4,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,33),heltab2x32(:,:,75))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(11),n2h16(33))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(76),h0tab(:,76),[32,4,19,8],[0,nMW,0,0],4,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,34),heltab2x32(:,:,76))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(12),n2h16(34))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(77),h0tab(:,77),[32,4,19,8],[0,nMZ,nMW,0],4,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,35),heltab2x32(:,:,77))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(13),n2h16(35))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(78),h0tab(:,78),[32,4,19,8],[0,nMW,nMZ,0],4,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,36),heltab2x32(:,:,78))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(14),n2h16(36))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(79),h0tab(:,79),[32,4,19,8],[0,0,nMW,0],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,37),heltab2x32(:,:,79))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(15),n2h16(37))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(80),h0tab(:,80),[32,4,19,8],[0,nMW,0,0],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,38),heltab2x32(:,:,80))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(16),n2h16(38))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(81),h0tab(:,81),[32,4,19,8],[0,nMZ,nMW,0],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,39),heltab2x32(:,:,81))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(17),n2h16(39))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(82),h0tab(:,82),[32,4,19,8],[0,nMW,nMZ,0],4,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,40),heltab2x32(:,:,82))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(18),n2h16(40))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(83),h0tab(:,83),[32,4,19,8],[0,0,0,0],4,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(19),m3h2x16(:,41),heltab2x32(:,:,83))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(84),h0tab(:,84),[44,2,1,16],[0,0,nMW,nMW],4,1,wf8(:,1))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,1),G0H4(1),m3h8x4(:,1),heltab2x32(:,:,84))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(85),h0tab(:,85),[44,2,1,16],[nMZ,0,nMW,nMW],4,1,wf8(:,1))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,1),G0H4(2),m3h8x4(:,2),heltab2x32(:,:,85))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(86),h0tab(:,86),[44,2,1,16],[nMW,0,nMZ,nMZ],4,1,wf8(:,1))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,1),44,G1H4(1),m3h8x4(:,3),heltab2x32(:,:,86))
  Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(87),h0tab(:,87),[44,2,1,16],[0,0,nMW,nMW],4,1,wf8(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,1),44,G1H4(2),m3h8x4(:,4),heltab2x32(:,:,87))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(88),h0tab(:,88),[44,2,1,16],[nMZ,0,nMW,nMW],4,1,wf8(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,1),44,G1H4(3),m3h8x4(:,5),heltab2x32(:,:,88))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(89),h0tab(:,89),[44,1,2,16],[nMZ,0,nMW,nMW],4,1,wf8(:,1))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,1),G0H4(3),m3h8x4(:,6),heltab2x32(:,:,89))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(90),h0tab(:,90),[44,1,2,16],[nMW,0,nMZ,nMZ],4,1,wf8(:,1))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,1),44,G1H4(4),m3h8x4(:,7),heltab2x32(:,:,90))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(91),h0tab(:,91),[44,1,2,16],[nMZ,0,nMW,nMW],4,1,wf8(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,1),44,G1H4(5),m3h8x4(:,8),heltab2x32(:,:,91))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(92),h0tab(:,92),[44,1,16,2],[0,nMZ,nMZ,0],4,1,wf8(:,1))
  call Hloop_AW_Q(ntryL,G0H32(1),wf8(:,1),G0H4(4),m3h8x4(:,9),heltab2x32(:,:,92))
  call Hloop_A_Q(ntryL,G0H4(4),44,0,G1H4(6),n2h4(23))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(93),h0tab(:,93),[44,2,1,16],[0,0,nMW,nMW],4,1,wf8(:,2))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,2),G0H4(4),m3h8x4(:,10),heltab2x32(:,:,93))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(94),h0tab(:,94),[44,2,1,16],[nMZ,0,nMW,nMW],4,1,wf8(:,2))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,2),G0H4(5),m3h8x4(:,11),heltab2x32(:,:,94))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(95),h0tab(:,95),[44,2,1,16],[nMW,0,nMZ,nMZ],4,1,wf8(:,2))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,2),44,G1H4(7),m3h8x4(:,12),heltab2x32(:,:,95))
  Gcoeff(:)%j = (c(20)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(96),h0tab(:,96),[44,2,1,16],[0,0,nMW,nMW],4,1,wf8(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,2),44,G1H4(8),m3h8x4(:,13),heltab2x32(:,:,96))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(97),h0tab(:,97),[44,2,1,16],[nMZ,0,nMW,nMW],4,1,wf8(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,2),44,G1H4(9),m3h8x4(:,14),heltab2x32(:,:,97))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(98),h0tab(:,98),[44,1,2,16],[nMZ,0,nMW,nMW],4,1,wf8(:,2))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,2),G0H4(6),m3h8x4(:,15),heltab2x32(:,:,98))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(99),h0tab(:,99),[44,1,2,16],[nMW,0,nMZ,nMZ],4,1,wf8(:,2))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,2),44,G1H4(10),m3h8x4(:,16),heltab2x32(:,:,99))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(100),h0tab(:,100),[44,1,2,16],[nMZ,0,nMW,nMW],4,1,wf8(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,2),44,G1H4(11),m3h8x4(:,17),heltab2x32(:,:,100))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(101),h0tab(:,101),[44,1,16,2],[0,nMZ,nMZ,0],4,1,wf8(:,2))
  call Hloop_AW_Q(ntryL,G0H32(1),wf8(:,2),G0H4(7),m3h8x4(:,18),heltab2x32(:,:,101))
  call Hloop_A_Q(ntryL,G0H4(7),44,0,G1H4(12),n2h4(24))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(7),[G1H16(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(10),[G1H16(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(4),[G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(5),[G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(9),[G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(6),[G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(6)])
  call Hloop_AW_Q(ntryL,G1H8(9),wf4(:,1),G1H2(47),m3h4x2(:,11),heltab2x8(:,:,51))
  call Hloop_A_Q(ntryL,G1H2(47),39,0,G2H2(8),n2h2(11))
  call Hloop_VV_S(ntryL,G0H8(2),wf4(:,1),G0H2(1),m3h4x2(:,12),heltab2x8(:,:,52))
  call Hloop_VV_S(ntryL,G0H8(3),wf4(:,1),G0H2(2),m3h4x2(:,13),heltab2x8(:,:,53))
  call Hloop_UW_V(ntryL,G0H8(4),36,wf4(:,1),3,G1H2(51),m3h4x2(:,14),heltab2x8(:,:,54))
  call Hloop_UV_W(ntryL,G0H8(5),36,wf4(:,1),3,G1H2(52),m3h4x2(:,15),heltab2x8(:,:,55))
  call Hloop_UV_W(ntryL,G0H8(6),36,wf4(:,1),3,G1H2(53),m3h4x2(:,16),heltab2x8(:,:,56))
  call Hloop_AQ_V(ntryL,G1H8(10),ex4(:),G1H4(13),m3h2x4(:,31),heltab2x8(:,:,57))
  call Hloop_AQ_Z(ntryL,G1H8(1),ex4(:),G1H4(14),ngZd,m3h2x4(:,32),heltab2x8(:,:,58))
  call Hloop_AQ_W(ntryL,G1H8(2),ex4(:),G1H4(15),m3h2x4(:,33),heltab2x8(:,:,59))
  call Hloop_AQ_V(ntryL,G1H8(3),ex4(:),G1H4(16),m3h2x4(:,34),heltab2x8(:,:,60))
  call Hloop_AQ_Z(ntryL,G1H8(4),ex4(:),G1H4(17),ngZd,m3h2x4(:,35),heltab2x8(:,:,61))
  call Hloop_QW_A(ntryL,G1H8(5),wf4(:,1),G1H2(57),m3h4x2(:,17),heltab2x8(:,:,62))
  call Hloop_Q_A(ntryL,G1H2(57),43,0,G2H2(3),n2h2(12))
  call Hloop_VV_S(ntryL,G0H8(8),wf4(:,1),G0H2(3),m3h4x2(:,18),heltab2x8(:,:,63))
  call Hloop_VV_S(ntryL,G0H8(9),wf4(:,1),G0H2(4),m3h4x2(:,19),heltab2x8(:,:,64))
  call Hloop_UW_V(ntryL,G0H8(10),40,wf4(:,1),3,G1H2(58),m3h4x2(:,20),heltab2x8(:,:,65))
  call Hloop_UV_W(ntryL,G0H8(1),40,wf4(:,1),3,G1H2(59),m3h4x2(:,21),heltab2x8(:,:,66))
  call Hloop_UV_W(ntryL,G0H8(7),40,wf4(:,1),3,G1H2(43),m3h4x2(:,22),heltab2x8(:,:,67))
  call Hloop_QA_V(ntryL,G1H8(11),ex3(:),G1H4(18),m3h2x4(:,36),heltab2x8(:,:,68))
  call Hloop_QA_Z(ntryL,G1H8(12),ex3(:),G1H4(19),ngZu,m3h2x4(:,37),heltab2x8(:,:,69))
  call Hloop_QA_W(ntryL,G1H8(13),ex3(:),G1H4(20),m3h2x4(:,38),heltab2x8(:,:,70))
  call Hloop_QA_V(ntryL,G1H8(14),ex3(:),G1H4(1),m3h2x4(:,39),heltab2x8(:,:,71))
  call Hloop_QA_Z(ntryL,G1H8(15),ex3(:),G1H4(2),ngZu,m3h2x4(:,40),heltab2x8(:,:,72))
  call Hloop_QA_Z(ntryL,G1H16(1),wf8(:,4),G1H2(44),ngZd,m3h8x2(:,1),heltab2x16(:,:,23))
  call Hloop_QA_W(ntryL,G1H16(2),wf8(:,4),G1H2(49),m3h8x2(:,2),heltab2x16(:,:,24))
  call Hloop_QA_Z(ntryL,G1H16(3),ex3(:),G1H8(16),ngZu,m3h2x8(:,21),heltab2x16(:,:,25))
  call Hloop_QA_W(ntryL,G1H16(4),ex3(:),G1H8(17),m3h2x8(:,22),heltab2x16(:,:,26))
  call Hloop_QA_V(ntryL,G1H16(7),ex3(:),G1H8(18),m3h2x8(:,23),heltab2x16(:,:,27))
  call Hloop_QA_Z(ntryL,G1H16(6),ex3(:),G1H8(19),ngZu,m3h2x8(:,24),heltab2x16(:,:,28))
  call Hloop_AQ_V(ntryL,G1H16(10),ex4(:),G1H8(20),m3h2x8(:,25),heltab2x16(:,:,29))
  call Hloop_AQ_Z(ntryL,G1H16(9),ex4(:),G1H8(6),ngZd,m3h2x8(:,26),heltab2x16(:,:,30))
  call Hloop_QA_V(ntryL,G1H16(11),ex3(:),G1H8(7),m3h2x8(:,27),heltab2x16(:,:,31))
  call Hloop_QA_W(ntryL,G1H16(12),ex3(:),G1H8(8),m3h2x8(:,28),heltab2x16(:,:,32))
  call Hloop_QA_Z(ntryL,G1H16(13),ex3(:),G1H8(9),ngZu,m3h2x8(:,29),heltab2x16(:,:,33))
  call Hloop_QA_W(ntryL,G1H16(14),ex3(:),G1H8(10),m3h2x8(:,30),heltab2x16(:,:,34))
  call Hloop_QA_V(ntryL,G1H16(15),ex3(:),G1H8(1),m3h2x8(:,31),heltab2x16(:,:,35))
  call Hloop_QA_W(ntryL,G1H16(16),ex3(:),G1H8(2),m3h2x8(:,32),heltab2x16(:,:,36))
  call Hloop_QA_Z(ntryL,G1H16(17),ex3(:),G1H8(3),ngZu,m3h2x8(:,33),heltab2x16(:,:,37))
  call Hloop_QA_W(ntryL,G1H16(18),ex3(:),G1H8(4),m3h2x8(:,34),heltab2x16(:,:,38))
  call Hloop_VA_Q(ntryL,G1H16(19),ex3(:),G1H8(5),m3h2x8(:,35),heltab2x16(:,:,39))
  call Hloop_A_Q(ntryL,G1H8(5),36,0,G2H8(1),n2h8(23))
  call Hloop_VA_Q(ntryL,G0H4(4),ex2(:),G0H2(5),m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_A_Q(ntryL,G0H2(5),46,0,G1H2(1),n2h2(13))
  call Hloop_ZA_Q(ntryL,G0H4(5),ex2(:),G0H2(5),ngZl,m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_A_Q(ntryL,G0H2(5),46,0,G1H2(2),n2h2(14))
  call Hloop_WA_Q(ntryL,G1H4(7),ex2(:),G1H2(20),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(20),46,0,G2H2(4),n2h2(15))
  call Hloop_VA_Q(ntryL,G1H4(8),ex2(:),G1H2(25),m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(25),46,0,G2H2(5),n2h2(16))
  call Hloop_ZA_Q(ntryL,G1H4(9),ex2(:),G1H2(50),ngZl,m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_A_Q(ntryL,G1H2(50),46,0,G2H2(9),n2h2(17))
  call Hloop_ZQ_A(ntryL,G0H4(6),ex1(:),G0H2(5),ngZn,m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_Q_A(ntryL,G0H2(5),45,0,G1H2(55),n2h2(18))
  call Hloop_WQ_A(ntryL,G1H4(10),ex1(:),G1H2(56),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(56),45,0,G2H2(10),n2h2(19))
  call Hloop_ZQ_A(ntryL,G1H4(11),ex1(:),G1H2(29),ngZn,m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(29),45,0,G2H2(11),n2h2(20))
  call Hloop_AQ_Z(ntryL,G1H4(12),ex1(:),G1H2(5),ngZn,m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_AQ_Z(ntryL,G2H2(8),ex4(:),G2H1(1),ngZd,m3h2x1(:,89),heltab2x2(:,:,111))
  call Hloop_ST_V(ntryL,G0H2(1),39,ex5(:),16,G1H2(9),m3h1x2(:,23),heltab2x2(:,:,112))
  call Hloop_ST_V(ntryL,G0H2(2),39,ex5(:),16,G1H2(18),m3h1x2(:,24),heltab2x2(:,:,113))
  call Hloop_VS_V(ntryL,G1H2(51),ex5(:),G1H2(60),m3h1x2(:,25),heltab2x2(:,:,114))
  call Hloop_VS_V(ntryL,G1H2(52),ex5(:),G1H2(24),m3h1x2(:,26),heltab2x2(:,:,115))
  call Hloop_VS_V(ntryL,G1H2(53),ex5(:),G1H2(35),m3h1x2(:,27),heltab2x2(:,:,116))
  call Hloop_VV_S(ntryL,G1H4(13),wf4(:,1),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,42))
  call Hloop_VV_S(ntryL,G1H4(14),wf4(:,1),G1H1(2),m3h4x1(:,2),heltab2x4(:,:,43))
  call Hloop_UW_V(ntryL,G1H4(15),44,wf4(:,1),3,G2H1(2),m3h4x1(:,3),heltab2x4(:,:,44))
  call Hloop_UV_W(ntryL,G1H4(16),44,wf4(:,1),3,G2H1(3),m3h4x1(:,4),heltab2x4(:,:,45))
  call Hloop_UV_W(ntryL,G1H4(17),44,wf4(:,1),3,G2H1(4),m3h4x1(:,5),heltab2x4(:,:,46))
  call Hloop_QA_Z(ntryL,G2H2(3),ex3(:),G2H1(5),ngZu,m3h2x1(:,90),heltab2x2(:,:,117))
  call Hloop_ST_V(ntryL,G0H2(3),43,ex5(:),16,G1H2(39),m3h1x2(:,28),heltab2x2(:,:,118))
  call Hloop_ST_V(ntryL,G0H2(4),43,ex5(:),16,G1H2(54),m3h1x2(:,29),heltab2x2(:,:,119))
  call Hloop_VS_V(ntryL,G1H2(58),ex5(:),G1H2(38),m3h1x2(:,30),heltab2x2(:,:,120))
  call Hloop_VS_V(ntryL,G1H2(59),ex5(:),G1H2(10),m3h1x2(:,31),heltab2x2(:,:,121))
  call Hloop_VS_V(ntryL,G1H2(43),ex5(:),G1H2(12),m3h1x2(:,32),heltab2x2(:,:,122))
  call Hloop_VV_S(ntryL,G1H4(18),wf4(:,1),G1H1(3),m3h4x1(:,6),heltab2x4(:,:,47))
  call Hloop_VV_S(ntryL,G1H4(19),wf4(:,1),G1H1(4),m3h4x1(:,7),heltab2x4(:,:,48))
  call Hloop_UW_V(ntryL,G1H4(20),44,wf4(:,1),3,G2H1(6),m3h4x1(:,8),heltab2x4(:,:,49))
  call Hloop_UV_W(ntryL,G1H4(1),44,wf4(:,1),3,G2H1(7),m3h4x1(:,9),heltab2x4(:,:,50))
  call Hloop_UV_W(ntryL,G1H4(2),44,wf4(:,1),3,G2H1(8),m3h4x1(:,10),heltab2x4(:,:,51))
  call Hloop_VS_V(ntryL,G1H2(44),ex5(:),G1H2(21),m3h1x2(:,33),heltab2x2(:,:,123))
  call Hloop_VS_V(ntryL,G1H2(49),ex5(:),G1H2(22),m3h1x2(:,34),heltab2x2(:,:,124))
  call Hloop_VS_V(ntryL,G1H8(16),ex5(:),G1H8(11),m3h1x8(:,11),heltab2x8(:,:,73))
  call Hloop_VS_V(ntryL,G1H8(17),ex5(:),G1H8(12),m3h1x8(:,12),heltab2x8(:,:,74))
  call Hloop_VQ_A(ntryL,G1H8(18),ex4(:),G1H4(3),m3h2x4(:,41),heltab2x8(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(3),44,0,G2H4(3),n2h4(25))
  call Hloop_ZQ_A(ntryL,G1H8(19),ex4(:),G1H4(4),ngZd,m3h2x4(:,42),heltab2x8(:,:,76))
  call Hloop_Q_A(ntryL,G1H4(4),44,0,G2H4(4),n2h4(26))
  call Hloop_VA_Q(ntryL,G1H8(20),ex3(:),G1H4(5),m3h2x4(:,43),heltab2x8(:,:,77))
  call Hloop_A_Q(ntryL,G1H4(5),44,0,G2H4(5),n2h4(27))
  call Hloop_ZA_Q(ntryL,G1H8(6),ex3(:),G1H4(6),ngZu,m3h2x4(:,44),heltab2x8(:,:,78))
  call Hloop_A_Q(ntryL,G1H4(6),44,0,G2H4(1),n2h4(28))
  call Hloop_VS_V(ntryL,G1H8(7),wf4(:,11),G1H2(23),m3h4x2(:,23),heltab2x8(:,:,79))
  call Hloop_VS_V(ntryL,G1H8(8),wf4(:,11),G1H2(14),m3h4x2(:,24),heltab2x8(:,:,80))
  call Hloop_VS_V(ntryL,G1H8(9),wf4(:,11),G1H2(40),m3h4x2(:,25),heltab2x8(:,:,81))
  call Hloop_VS_V(ntryL,G1H8(10),wf4(:,11),G1H2(36),m3h4x2(:,26),heltab2x8(:,:,82))
  call Hloop_UV_W(ntryL,G1H8(1),36,wf4(:,4),19,G2H2(12),m3h4x2(:,27),heltab2x8(:,:,83))
  call Hloop_UW_V(ntryL,G1H8(2),36,wf4(:,4),19,G2H2(13),m3h4x2(:,28),heltab2x8(:,:,84))
  call Hloop_UV_W(ntryL,G1H8(3),36,wf4(:,4),19,G2H2(14),m3h4x2(:,29),heltab2x8(:,:,85))
  call Hloop_UW_V(ntryL,G1H8(4),36,wf4(:,4),19,G2H2(15),m3h4x2(:,30),heltab2x8(:,:,86))
  call Hotf_4pt_reduction(G2H8(1),RedSet_4(10),mass4set(:,1),  & 
G1H8(13),G1H8(14),G1H8(15),G1H8(5),G1H8(16),8)
  call HG1shiftOLR(G1H8(14),8,8)
  call Hloop_AQ_W(ntryL,G1H2(1),ex1(:),G1H1(5),m3h2x1(:,91),heltab2x2(:,:,125))
  call Hloop_AQ_W(ntryL,G1H2(2),ex1(:),G1H1(6),m3h2x1(:,92),heltab2x2(:,:,126))
  call Hloop_AQ_Z(ntryL,G2H2(4),ex1(:),G2H1(9),ngZn,m3h2x1(:,93),heltab2x2(:,:,127))
  call Hloop_AQ_W(ntryL,G2H2(5),ex1(:),G2H1(10),m3h2x1(:,94),heltab2x2(:,:,128))
  call Hloop_AQ_W(ntryL,G2H2(9),ex1(:),G2H1(11),m3h2x1(:,95),heltab2x2(:,:,129))
  call Hloop_QA_W(ntryL,G1H2(55),ex2(:),G1H1(7),m3h2x1(:,96),heltab2x2(:,:,130))
  call Hloop_QA_Z(ntryL,G2H2(10),ex2(:),G2H1(12),ngZl,m3h2x1(:,97),heltab2x2(:,:,131))
  call Hloop_QA_W(ntryL,G2H2(11),ex2(:),G2H1(13),m3h2x1(:,98),heltab2x2(:,:,132))
  call Hloop_VS_V(ntryL,G1H2(5),ex5(:),G1H2(46),m3h1x2(:,35),heltab2x2(:,:,133))
  call Hloop_AW_Q(ntryL,G1H8(13),wf4(:,4),G1H2(47),m3h4x2(:,31),heltab2x8(:,:,87))
  call Hloop_A_Q(ntryL,G1H2(47),55,0,G2H2(22),n2h2(21))
call HGT_raise_alpha_OLR(G1H8(14),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(14),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(14),ex4(:),G1H4(7),m3h2x4(:,45),heltab2x8(:,:,88))
  call Hloop_AW_Q(ntryL,G1H8(5),wf4(:,4),G1H2(57),m3h4x2(:,32),heltab2x8(:,:,89))
  call Hloop_A_Q(ntryL,G1H2(57),55,0,G2H2(17),n2h2(22))
  call Hloop_AW_Q(ntryL,G1H8(16),wf4(:,4),G1H2(20),m3h4x2(:,33),heltab2x8(:,:,90))
  call Hloop_A_Q(ntryL,G1H2(20),55,0,G2H2(1),n2h2(23))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(60),[G1H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(21),[G1H2(42),G1H2(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G1H2(36),G1H2(34),G1H2(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(35),[G1H2(18),G1H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(22),[G1H2(4),G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(14),[G1H2(40),G1H2(48),G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(24),[G1H2(9),G1H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(12),[G1H2(23),G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G1H2(14),G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(10),[G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(12),[G1H2(54)])
  call Hloop_ZQ_A(ntryL,G1H2(60),ex4(:),G1H1(8),ngZd,m3h2x1(:,99),heltab2x2(:,:,134))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),63,0,G2tensor(2),n2h1(79))
  call Hloop_ZQ_A(ntryL,G1H2(21),ex4(:),G1H1(8),ngZd,m3h2x1(:,100),heltab2x2(:,:,135))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),63,0,G2tensor(4),n2h1(80))
  call Hotf_4pt_reduction(G2H2(15),RedSet_4(10),mass4set(:,2),  & 
G1H2(25),G1H2(50),G1H2(56),G1H2(29),G1H2(51),2)
  call HG1shiftOLR(G1H2(50),8,2)
  call Hloop_WQ_A(ntryL,G1H2(35),ex4(:),G1H1(8),m3h2x1(:,101),heltab2x2(:,:,136))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),63,0,G2tensor(10),n2h1(81))
  call Hloop_WQ_A(ntryL,G1H2(22),ex4(:),G1H1(8),m3h2x1(:,102),heltab2x2(:,:,137))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),63,0,G2tensor(12),n2h1(82))
  call Hotf_4pt_reduction(G2H2(14),RedSet_4(10),mass4set(:,3),  & 
G1H2(52),G1H2(53),G1H2(58),G1H2(59),G1H2(43),2)
  call HG1shiftOLR(G1H2(53),8,2)
  call Hloop_WQ_A(ntryL,G1H2(41),ex4(:),G1H1(8),m3h2x1(:,103),heltab2x2(:,:,138))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),63,0,G2tensor(14),n2h1(83))
  call Hloop_WQ_A(ntryL,G1H2(11),ex4(:),G1H1(8),m3h2x1(:,104),heltab2x2(:,:,139))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),63,0,G2tensor(45),n2h1(84))
  call Hloop_ZQ_A(ntryL,G1H2(27),ex4(:),G1H1(8),ngZd,m3h2x1(:,105),heltab2x2(:,:,140))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),63,0,G2tensor(46),n2h1(85))
  call Hloop_ZQ_A(ntryL,G1H2(33),ex4(:),G1H1(8),ngZd,m3h2x1(:,106),heltab2x2(:,:,141))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),63,0,G2tensor(6),n2h1(86))
  call Hloop_WQ_A(ntryL,G1H2(24),ex4(:),G1H1(8),m3h2x1(:,107),heltab2x2(:,:,142))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),63,0,G2tensor(8),n2h1(87))
  call Hotf_4pt_reduction(G2H2(12),RedSet_4(10),mass4set(:,4),  & 
G1H2(44),G1H2(49),G1H2(1),G1H2(2),G1H2(55),2)
  call HG1shiftOLR(G1H2(49),8,2)
  call Hloop_VQ_A(ntryL,G1H2(15),ex4(:),G1H1(8),m3h2x1(:,108),heltab2x2(:,:,143))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),63,0,G2tensor(47),n2h1(88))
  call Hloop_VQ_A(ntryL,G1H2(16),ex4(:),G1H1(8),m3h2x1(:,109),heltab2x2(:,:,144))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),63,0,G2tensor(48),n2h1(89))
  call Hotf_4pt_reduction(G2H2(13),RedSet_4(10),mass4set(:,5),  & 
G1H2(5),G1H2(47),G1H2(57),G1H2(20),G1H2(26),2)
  call HG1shiftOLR(G1H2(47),8,2)
  call Hloop_ZA_Q(ntryL,G1H2(13),ex3(:),G1H1(8),ngZu,m3h2x1(:,110),heltab2x2(:,:,145))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(8),63,0,G2tensor(49),n2h1(90))
  call Hloop_ZA_Q(ntryL,G1H2(28),ex3(:),G1H1(8),ngZu,m3h2x1(:,111),heltab2x2(:,:,146))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(8),63,0,G2tensor(16),n2h1(91))
  call Hloop_ZA_Q(ntryL,G1H2(30),ex3(:),G1H1(8),ngZu,m3h2x1(:,112),heltab2x2(:,:,147))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(8),63,0,G2tensor(18),n2h1(92))
  call Hloop_ZQ_A(ntryL,G1H2(19),ex4(:),G1H1(8),ngZd,m3h2x1(:,113),heltab2x2(:,:,148))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),63,0,G2tensor(20),n2h1(93))
  call Hloop_ZQ_A(ntryL,G1H2(45),ex4(:),G1H1(8),ngZd,m3h2x1(:,114),heltab2x2(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),63,0,G2tensor(1),n2h1(94))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(1),ex5(:),G2tensor(3),m3h1x1(:,11),heltab2x1(:,:,11))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(1),47,ex5(:),16,G2tensor(55),m3h1x1(:,12),heltab2x1(:,:,12))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(2),47,ex5(:),16,G2tensor(5),m3h1x1(:,13),heltab2x1(:,:,13))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(2),ex5(:),G2tensor(7),m3h1x1(:,14),heltab2x1(:,:,14))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(3),ex5(:),G2tensor(9),m3h1x1(:,15),heltab2x1(:,:,15))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(4),ex5(:),G2tensor(58),m3h1x1(:,16),heltab2x1(:,:,16))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(5),ex5(:),G2tensor(11),m3h1x1(:,17),heltab2x1(:,:,17))
  call Hloop_WA_Q(ntryL,G1H2(10),ex3(:),G1H1(8),m3h2x1(:,115),heltab2x2(:,:,150))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(8),63,0,G2tensor(13),n2h1(95))
  call Hloop_WA_Q(ntryL,G1H2(12),ex3(:),G1H1(1),m3h2x1(:,116),heltab2x2(:,:,151))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(96))
  call Hloop_ZA_Q(ntryL,G1H2(38),ex3(:),G1H1(2),ngZu,m3h2x1(:,117),heltab2x2(:,:,152))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),63,0,G2tensor(17),n2h1(97))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(3),47,ex5(:),16,G2tensor(61),m3h1x1(:,18),heltab2x1(:,:,18))
  call Hcheck_last_ST_V(ntryL,l_switch,G1H1(4),47,ex5(:),16,G2tensor(19),m3h1x1(:,19),heltab2x1(:,:,19))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(6),ex5(:),G2tensor(21),m3h1x1(:,20),heltab2x1(:,:,20))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(7),ex5(:),G2tensor(22),m3h1x1(:,21),heltab2x1(:,:,21))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(8),ex5(:),G2tensor(64),m3h1x1(:,22),heltab2x1(:,:,22))
  call Hloop_ZQ_A(ntryL,G1H8(11),wf8(:,22),G1H1(8),ngZu,m3h8x1(:,1),heltab2x8(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),63,0,G2tensor(23),n2h1(98))
  call Hloop_WQ_A(ntryL,G1H8(12),wf8(:,22),G1H1(1),m3h8x1(:,2),heltab2x8(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(24),n2h1(99))
  call Hotf_4pt_reduction(G2H4(3),RedSet_4(87),mass4set(:,1),  & 
G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
  call HG1shiftOLR(G1H4(9),19,4)
  call Hotf_4pt_reduction(G2H4(4),RedSet_4(87),mass4set(:,6),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),4)
  call HG1shiftOLR(G1H4(14),19,4)
  call Hotf_4pt_reduction(G2H4(5),RedSet_4(88),mass4set(:,1),  & 
G1H4(18),G1H4(19),G1H4(20),G1H4(1),G1H4(2),4)
  call HG1shiftOLR(G1H4(19),19,4)
  call Hotf_4pt_reduction(G2H4(1),RedSet_4(88),mass4set(:,6),  & 
G1H4(3),G1H4(4),G1H4(5),G1H4(6),G1H4(21),4)
  call HG1shiftOLR(G1H4(4),19,4)
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(5),47,ex5(:),16,G2tensor(25),m3h1x1(:,23),heltab2x1(:,:,23))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(6),47,ex5(:),16,G2tensor(26),m3h1x1(:,24),heltab2x1(:,:,24))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(9),ex5(:),G2tensor(27),m3h1x1(:,25),heltab2x1(:,:,25))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(10),ex5(:),G2tensor(67),m3h1x1(:,26),heltab2x1(:,:,26))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(11),ex5(:),G2tensor(28),m3h1x1(:,27),heltab2x1(:,:,27))
  call Hcheck_last_VT_S(ntryL,l_switch,G1H1(7),47,ex5(:),16,G2tensor(29),m3h1x1(:,28),heltab2x1(:,:,28))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(12),ex5(:),G2tensor(30),m3h1x1(:,29),heltab2x1(:,:,29))
  call Hcheck_last_VS_V(ntryL,l_switch,G2H1(13),ex5(:),G2tensor(31),m3h1x1(:,30),heltab2x1(:,:,30))
  call Hloop_ZA_Q(ntryL,G1H2(46),ex2(:),G1H1(2),ngZl,m3h2x1(:,118),heltab2x2(:,:,153))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),63,0,G2tensor(32),n2h1(100))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(22),ex4(:),G2tensor(33),m3h2x1(:,119),heltab2x2(:,:,154))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(34),m3h2x1(:,120),heltab2x2(:,:,155))
  call Hloop_ZQ_A(ntryL,G1H2(25),ex4(:),G1H1(3),ngZd,m3h2x1(:,121),heltab2x2(:,:,156))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(3),63,0,G2tensor(35),n2h1(101))
  call Hloop_ZQ_A(ntryL,G1H2(50),ex4(:),G1H1(4),ngZd,m3h2x1(:,122),heltab2x2(:,:,157))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(4),8,0,G2tensor(36),n2h1(102))
  call Hloop_ZQ_A(ntryL,G1H2(51),ex4(:),G1H1(8),ngZd,m3h2x1(:,123),heltab2x2(:,:,158))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),63,0,G2tensor(70),n2h1(103))
  call Hloop_WQ_A(ntryL,G1H2(52),ex4(:),G1H1(1),m3h2x1(:,124),heltab2x2(:,:,159))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(37),n2h1(104))
  call Hloop_WQ_A(ntryL,G1H2(53),ex4(:),G1H1(5),m3h2x1(:,125),heltab2x2(:,:,160))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(5),8,0,G2tensor(38),n2h1(105))
  call Hloop_WQ_A(ntryL,G1H2(43),ex4(:),G1H1(6),m3h2x1(:,126),heltab2x2(:,:,161))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),63,0,G2tensor(39),n2h1(106))
  call Hloop_WQ_A(ntryL,G1H2(44),ex4(:),G1H1(7),m3h2x1(:,127),heltab2x2(:,:,162))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(7),63,0,G2tensor(40),n2h1(107))
  call Hloop_WQ_A(ntryL,G1H2(49),ex4(:),G1H1(2),m3h2x1(:,128),heltab2x2(:,:,163))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(2),8,0,G2tensor(41),n2h1(108))
  call Hloop_WQ_A(ntryL,G1H2(55),ex4(:),G1H1(3),m3h2x1(:,129),heltab2x2(:,:,164))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(3),63,0,G2tensor(42),n2h1(109))
  call Hloop_VQ_A(ntryL,G1H2(5),ex4(:),G1H1(4),m3h2x1(:,130),heltab2x2(:,:,165))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(4),63,0,G2tensor(43),n2h1(110))
  call Hloop_VQ_A(ntryL,G1H2(47),ex4(:),G1H1(8),m3h2x1(:,131),heltab2x2(:,:,166))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),8,0,G2tensor(44),n2h1(111))
  call Hloop_VQ_A(ntryL,G1H2(26),ex4(:),G1H1(1),m3h2x1(:,132),heltab2x2(:,:,167))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(50),n2h1(112))
  call Hloop_QW_A(ntryL,G1H4(8),wf4(:,4),G1H1(5),m3h4x1(:,11),heltab2x4(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(5),63,0,G2tensor(51),n2h1(113))
  call Hloop_QW_A(ntryL,G1H4(9),wf4(:,4),G1H1(6),m3h4x1(:,12),heltab2x4(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),19,0,G2tensor(52),n2h1(114))
  call Hloop_QW_A(ntryL,G1H4(12),wf4(:,4),G1H1(7),m3h4x1(:,13),heltab2x4(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(7),63,0,G2tensor(53),n2h1(115))
  call Hloop_QW_A(ntryL,G1H4(13),wf4(:,4),G1H1(2),m3h4x1(:,14),heltab2x4(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(2),63,0,G2tensor(54),n2h1(116))
  call Hloop_QW_A(ntryL,G1H4(14),wf4(:,4),G1H1(3),m3h4x1(:,15),heltab2x4(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(3),19,0,G2tensor(73),n2h1(117))
  call Hloop_QW_A(ntryL,G1H4(17),wf4(:,4),G1H1(4),m3h4x1(:,16),heltab2x4(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(4),63,0,G2tensor(76),n2h1(118))
  call Hloop_AW_Q(ntryL,G1H4(18),wf4(:,4),G1H1(8),m3h4x1(:,17),heltab2x4(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(8),63,0,G2tensor(79),n2h1(119))
  call Hloop_AW_Q(ntryL,G1H4(19),wf4(:,4),G1H1(1),m3h4x1(:,18),heltab2x4(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),19,0,G2tensor(80),n2h1(120))
  call Hloop_AW_Q(ntryL,G1H4(2),wf4(:,4),G1H1(5),m3h4x1(:,19),heltab2x4(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(5),63,0,G2tensor(81),n2h1(121))
  call Hloop_AW_Q(ntryL,G1H4(3),wf4(:,4),G1H1(6),m3h4x1(:,20),heltab2x4(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(6),63,0,G2tensor(82),n2h1(122))
  call Hloop_AW_Q(ntryL,G1H4(4),wf4(:,4),G1H1(7),m3h4x1(:,21),heltab2x4(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(7),19,0,G2tensor(83),n2h1(123))
  call Hloop_AW_Q(ntryL,G1H4(21),wf4(:,4),G1H1(2),m3h4x1(:,22),heltab2x4(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),63,0,G2tensor(84),n2h1(124))
  call ol_merge_tensors(G2tensor(21),[G2tensor(56),G1tensor(74),G1tensor(11),G1tensor(25)])
  call ol_merge_tensors(G2tensor(57),[G1tensor(78)])
  call ol_merge_tensors(G2tensor(64),[G2tensor(19),G2tensor(59),G1tensor(98),G1tensor(27),G1tensor(2)])
  call ol_merge_tensors(G2tensor(60),[G1tensor(102)])
  call ol_merge_tensors(G2tensor(62),[G1tensor(128),G1tensor(36),G1tensor(44)])
  call ol_merge_tensors(G2tensor(23),[G2tensor(63),G1tensor(132)])
  call ol_merge_tensors(G2tensor(65),[G1tensor(152),G1tensor(59),G1tensor(5)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(72),G2tensor(66),G1tensor(252),G1tensor(156)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(61),G2tensor(68),G1tensor(188),G1tensor(18)])
  call ol_merge_tensors(G2tensor(69),[G1tensor(192)])
  call ol_merge_tensors(G2tensor(71),[G1tensor(248),G1tensor(51)])
  call ol_merge_tensors(G2tensor(3),[G2tensor(74),G1tensor(332)])
  call ol_merge_tensors(G2tensor(75),[G1tensor(336)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(77),G1tensor(338)])
  call ol_merge_tensors(G2tensor(78),[G1tensor(342)])
  call ol_merge_tensors(G2tensor(30),[G1tensor(320),G1tensor(273),G1tensor(62),G1tensor(13)])
  call ol_merge_tensors(G1tensor(68),[G1tensor(19)])
  call ol_merge_tensors(G1tensor(80),[G1tensor(31)])
  call ol_merge_tensors(G2tensor(31),[G2tensor(29),G1tensor(326),G1tensor(279),G1tensor(86),G1tensor(49)])
  call ol_merge_tensors(G1tensor(92),[G1tensor(55)])
  call ol_merge_tensors(G1tensor(104),[G1tensor(8)])
  call ol_merge_tensors(G1tensor(110),[G1tensor(26)])
  call ol_merge_tensors(G1tensor(116),[G1tensor(32)])
  call ol_merge_tensors(G1tensor(122),[G1tensor(38)])
  call ol_merge_tensors(G1tensor(134),[G1tensor(3)])
  call ol_merge_tensors(G1tensor(140),[G1tensor(4)])
  call ol_merge_tensors(G1tensor(146),[G1tensor(29)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(302),G1tensor(285),G1tensor(158),G1tensor(10)])
  call ol_merge_tensors(G1tensor(164),[G1tensor(41)])
  call ol_merge_tensors(G1tensor(170),[G1tensor(12)])
  call ol_merge_tensors(G2tensor(67),[G2tensor(25),G1tensor(308),G1tensor(291),G1tensor(176),G1tensor(17)])
  call ol_merge_tensors(G1tensor(182),[G1tensor(24),G1tensor(48)])
  call ol_merge_tensors(G1tensor(194),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(28),[G2tensor(26),G1tensor(314),G1tensor(297),G1tensor(200),G1tensor(60)])
  call ol_merge_tensors(G1tensor(206),[G1tensor(28)])
  call ol_merge_tensors(G1tensor(212),[G1tensor(40)])
  call ol_merge_tensors(G1tensor(218),[G1tensor(34)])
  call ol_merge_tensors(G1tensor(224),[G1tensor(35)])
  call ol_merge_tensors(G1tensor(53),[G1tensor(42)])
  call ol_merge_tensors(G1tensor(230),[G1tensor(45)])
  call ol_merge_tensors(G1tensor(236),[G1tensor(46)])
  call ol_merge_tensors(G1tensor(242),[G1tensor(47)])
  call ol_merge_tensors(G1tensor(254),[G1tensor(54)])
  call ol_merge_tensors(G1tensor(260),[G1tensor(57)])
  call ol_merge_tensors(G1tensor(266),[G1tensor(58)])
  call ol_merge_tensors(G1tensor(69),[G1tensor(63)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(160),G1tensor(75),G1tensor(64)])
  call ol_merge_tensors(G1tensor(81),[G1tensor(65)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(340),G1tensor(166),G1tensor(76),G1tensor(70)])
  call ol_merge_tensors(G1tensor(82),[G1tensor(71)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(269),G1tensor(173),G1tensor(155),G1tensor(149),G1tensor(83),G1tensor(77)])
  call ol_merge_tensors(G1tensor(93),[G1tensor(87)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(202),G1tensor(99),G1tensor(88)])
  call ol_merge_tensors(G1tensor(105),[G1tensor(89)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(190),G1tensor(184),G1tensor(100),G1tensor(94)])
  call ol_merge_tensors(G1tensor(106),[G1tensor(95)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(227),G1tensor(209),G1tensor(131),G1tensor(125),G1tensor(107),G1tensor(101)])
  call ol_merge_tensors(G1tensor(117),[G1tensor(111)])
  call ol_merge_tensors(G1tensor(123),[G1tensor(112)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(215),G1tensor(129),G1tensor(113)])
  call ol_merge_tensors(G1tensor(124),[G1tensor(118)])
  call ol_merge_tensors(G2tensor(45),[G1tensor(221),G1tensor(130),G1tensor(119)])
  call ol_merge_tensors(G1tensor(141),[G1tensor(135)])
  call ol_merge_tensors(G1tensor(147),[G1tensor(136)])
  call ol_merge_tensors(G2tensor(46),[G1tensor(257),G1tensor(153),G1tensor(137)])
  call ol_merge_tensors(G1tensor(148),[G1tensor(142)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(263),G1tensor(154),G1tensor(143)])
  call ol_merge_tensors(G1tensor(165),[G1tensor(159)])
  call ol_merge_tensors(G1tensor(171),[G1tensor(161)])
  call ol_merge_tensors(G1tensor(172),[G1tensor(167)])
  call ol_merge_tensors(G1tensor(201),[G1tensor(183),G1tensor(177)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(189),G1tensor(178)])
  call ol_merge_tensors(G1tensor(195),[G1tensor(179)])
  call ol_merge_tensors(G1tensor(208),[G1tensor(196),G1tensor(185)])
  call ol_merge_tensors(G2tensor(40),[G1tensor(197),G1tensor(191)])
  call ol_merge_tensors(G1tensor(207),[G1tensor(203)])
  call ol_merge_tensors(G1tensor(219),[G1tensor(213)])
  call ol_merge_tensors(G1tensor(225),[G1tensor(214)])
  call ol_merge_tensors(G1tensor(226),[G1tensor(220)])
  call ol_merge_tensors(G1tensor(237),[G1tensor(231)])
  call ol_merge_tensors(G1tensor(243),[G1tensor(232)])
  call ol_merge_tensors(G2tensor(47),[G1tensor(249),G1tensor(233)])
  call ol_merge_tensors(G1tensor(258),[G1tensor(234)])
  call ol_merge_tensors(G1tensor(244),[G1tensor(238)])
  call ol_merge_tensors(G2tensor(48),[G1tensor(250),G1tensor(239)])
  call ol_merge_tensors(G1tensor(264),[G1tensor(240)])
  call ol_merge_tensors(G2tensor(43),[G1tensor(251),G1tensor(245)])
  call ol_merge_tensors(G1tensor(270),[G1tensor(246)])
  call ol_merge_tensors(G1tensor(261),[G1tensor(255)])
  call ol_merge_tensors(G1tensor(267),[G1tensor(256)])
  call ol_merge_tensors(G1tensor(268),[G1tensor(262)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(287),G1tensor(275)])
  call ol_merge_tensors(G2tensor(58),[G2tensor(5),G1tensor(299),G1tensor(281)])
  call ol_merge_tensors(G1tensor(298),[G1tensor(292)])
  call ol_merge_tensors(G2tensor(9),[G2tensor(55),G1tensor(293)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(322),G1tensor(304)])
  call ol_merge_tensors(G1tensor(315),[G1tensor(309)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(310)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(328),G1tensor(316)])
  call ol_merge_tensors(G2tensor(49),[G1tensor(333)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(334)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(335)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(339)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(341)])
  call Hotf_4pt_reduction_last(G2tensor(21),RedSet_4(52),mass4set(:,7),  & 
G1tensor(1),G1tensor(37),G1tensor(14),G1tensor(50),G1tensor(6))
  call G_TensorShift(G1tensor(37),16)
  call Hotf_4pt_reduction_last(G2tensor(57),RedSet_4(11),mass4set(:,2),  & 
G1tensor(15),G1tensor(22),G1tensor(30),G1tensor(39),G1tensor(52))
  call G_TensorShift(G1tensor(22),24)
  call Hotf_4pt_reduction_last(G2tensor(64),RedSet_4(52),mass4set(:,8),  & 
G1tensor(61),G1tensor(67),G1tensor(73),G1tensor(79),G1tensor(85))
  call G_TensorShift(G1tensor(67),16)
  call Hotf_4pt_reduction_last(G2tensor(60),RedSet_4(11),mass4set(:,3),  & 
G1tensor(91),G1tensor(97),G1tensor(103),G1tensor(109),G1tensor(115))
  call G_TensorShift(G1tensor(97),24)
  call Hotf_4pt_reduction_last(G2tensor(62),RedSet_4(57),mass4set(:,9),  & 
G1tensor(121),G1tensor(127),G1tensor(133),G1tensor(139),G1tensor(145))
  call G_TensorShift(G1tensor(127),3)
  call Hotf_4pt_reduction_last(G2tensor(23),RedSet_4(27),mass4set(:,10),  & 
G1tensor(151),G1tensor(157),G1tensor(163),G1tensor(169),G1tensor(175))
  call G_TensorShift(G1tensor(157),11)
  call Hotf_4pt_reduction_last(G2tensor(65),RedSet_4(57),mass4set(:,11),  & 
G1tensor(181),G1tensor(187),G1tensor(193),G1tensor(199),G1tensor(205))
  call G_TensorShift(G1tensor(187),3)
  call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(27),mass4set(:,12),  & 
G1tensor(211),G1tensor(217),G1tensor(223),G1tensor(229),G1tensor(235))
  call G_TensorShift(G1tensor(217),11)
  call Hotf_4pt_reduction_last(G2tensor(22),RedSet_4(52),mass4set(:,13),  & 
G1tensor(241),G1tensor(247),G1tensor(253),G1tensor(259),G1tensor(265))
  call G_TensorShift(G1tensor(247),16)
  call Hotf_4pt_reduction_last(G2tensor(69),RedSet_4(11),mass4set(:,4),  & 
G1tensor(271),G1tensor(277),G1tensor(283),G1tensor(289),G1tensor(295))
  call G_TensorShift(G1tensor(277),24)
  call Hotf_4pt_reduction_last(G2tensor(71),RedSet_4(57),mass4set(:,12),  & 
G1tensor(301),G1tensor(307),G1tensor(313),G1tensor(319),G1tensor(325))
  call G_TensorShift(G1tensor(307),3)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(89),mass4set(:,14),  & 
G1tensor(331),G1tensor(337),G1tensor(74),G1tensor(11),G1tensor(25))
  call G_TensorShift(G1tensor(337),16)
  call Hotf_4pt_reduction_last(G2tensor(75),RedSet_4(81),mass4set(:,15),  & 
G1tensor(78),G1tensor(98),G1tensor(27),G1tensor(2),G1tensor(102))
  call G_TensorShift(G1tensor(98),20)
  call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(90),mass4set(:,14),  & 
G1tensor(128),G1tensor(36),G1tensor(44),G1tensor(132),G1tensor(152))
  call G_TensorShift(G1tensor(36),16)
  call Hotf_4pt_reduction_last(G2tensor(78),RedSet_4(85),mass4set(:,15),  & 
G1tensor(59),G1tensor(5),G1tensor(252),G1tensor(156),G1tensor(188))
  call G_TensorShift(G1tensor(5),24)
  call Hotf_4pt_reduction_last(G2tensor(30),RedSet_4(50),mass4set(:,16),  & 
G1tensor(18),G1tensor(192),G1tensor(248),G1tensor(51),G1tensor(332))
  call G_TensorShift(G1tensor(192),16)
  call Hotf_4pt_reduction_last(G2tensor(31),RedSet_4(50),mass4set(:,17),  & 
G1tensor(336),G1tensor(338),G1tensor(342),G1tensor(320),G1tensor(273))
  call G_TensorShift(G1tensor(338),16)
  call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(58),mass4set(:,16),  & 
G1tensor(62),G1tensor(13),G1tensor(19),G1tensor(31),G1tensor(326))
  call G_TensorShift(G1tensor(13),16)
  call Hotf_4pt_reduction_last(G2tensor(67),RedSet_4(58),mass4set(:,13),  & 
G1tensor(279),G1tensor(86),G1tensor(49),G1tensor(55),G1tensor(8))
  call G_TensorShift(G1tensor(86),16)
  call Hotf_4pt_reduction_last(G2tensor(28),RedSet_4(58),mass4set(:,17),  & 
G1tensor(26),G1tensor(32),G1tensor(38),G1tensor(3),G1tensor(4))
  call G_TensorShift(G1tensor(32),16)
  call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(2),mass4set(:,18),  & 
G1tensor(29),G1tensor(302),G1tensor(285),G1tensor(158),G1tensor(10))
  call G_TensorShift(G1tensor(302),8)
  call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(6),mass4set(:,10),  & 
G1tensor(41),G1tensor(12),G1tensor(308),G1tensor(291),G1tensor(176))
  call G_TensorShift(G1tensor(12),8)
  call Hotf_4pt_reduction_last(G2tensor(35),RedSet_4(10),mass4set(:,2),  & 
G1tensor(17),G1tensor(24),G1tensor(48),G1tensor(21),G1tensor(314))
  call G_TensorShift(G1tensor(24),8)
  call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(2),mass4set(:,19),  & 
G1tensor(297),G1tensor(200),G1tensor(60),G1tensor(28),G1tensor(40))
  call G_TensorShift(G1tensor(200),8)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(6),mass4set(:,12),  & 
G1tensor(34),G1tensor(35),G1tensor(42),G1tensor(45),G1tensor(46))
  call G_TensorShift(G1tensor(35),8)
  call Hotf_4pt_reduction_last(G2tensor(37),RedSet_4(10),mass4set(:,3),  & 
G1tensor(47),G1tensor(54),G1tensor(57),G1tensor(58),G1tensor(63))
  call G_TensorShift(G1tensor(54),8)
  call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(18),mass4set(:,20),  & 
G1tensor(160),G1tensor(75),G1tensor(64),G1tensor(65),G1tensor(340))
  call G_TensorShift(G1tensor(75),8)
  call Hotf_4pt_reduction_last(G2tensor(45),RedSet_4(22),mass4set(:,3),  & 
G1tensor(166),G1tensor(76),G1tensor(70),G1tensor(71),G1tensor(269))
  call G_TensorShift(G1tensor(76),8)
  call Hotf_4pt_reduction_last(G2tensor(46),RedSet_4(18),mass4set(:,21),  & 
G1tensor(173),G1tensor(155),G1tensor(149),G1tensor(83),G1tensor(77))
  call G_TensorShift(G1tensor(155),8)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(22),mass4set(:,2),  & 
G1tensor(87),G1tensor(202),G1tensor(99),G1tensor(88),G1tensor(89))
  call G_TensorShift(G1tensor(202),8)
  call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(2),mass4set(:,12),  & 
G1tensor(190),G1tensor(184),G1tensor(100),G1tensor(94),G1tensor(95))
  call G_TensorShift(G1tensor(184),8)
  call Hotf_4pt_reduction_last(G2tensor(40),RedSet_4(10),mass4set(:,4),  & 
G1tensor(227),G1tensor(209),G1tensor(131),G1tensor(125),G1tensor(107))
  call G_TensorShift(G1tensor(209),8)
  call Hotf_4pt_reduction_last(G2tensor(47),RedSet_4(18),mass4set(:,22),  & 
G1tensor(101),G1tensor(111),G1tensor(112),G1tensor(215),G1tensor(129))
  call G_TensorShift(G1tensor(111),8)
  call Hotf_4pt_reduction_last(G2tensor(48),RedSet_4(22),mass4set(:,5),  & 
G1tensor(113),G1tensor(118),G1tensor(221),G1tensor(130),G1tensor(119))
  call G_TensorShift(G1tensor(118),8)
  call Hotf_4pt_reduction_last(G2tensor(43),RedSet_4(10),mass4set(:,5),  & 
G1tensor(135),G1tensor(136),G1tensor(257),G1tensor(153),G1tensor(137))
  call G_TensorShift(G1tensor(136),8)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(65),mass4set(:,7),  & 
G1tensor(142),G1tensor(263),G1tensor(154),G1tensor(143),G1tensor(159))
  call G_TensorShift(G1tensor(263),16)
  call Hotf_4pt_reduction_last(G2tensor(58),RedSet_4(65),mass4set(:,8),  & 
G1tensor(161),G1tensor(167),G1tensor(183),G1tensor(177),G1tensor(189))
  call G_TensorShift(G1tensor(167),16)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(65),mass4set(:,13),  & 
G1tensor(178),G1tensor(179),G1tensor(196),G1tensor(185),G1tensor(197))
  call G_TensorShift(G1tensor(179),16)
  call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(72),mass4set(:,18),  & 
G1tensor(191),G1tensor(203),G1tensor(213),G1tensor(214),G1tensor(220))
  call G_TensorShift(G1tensor(203),4)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(72),mass4set(:,12),  & 
G1tensor(231),G1tensor(232),G1tensor(249),G1tensor(233),G1tensor(234))
  call G_TensorShift(G1tensor(232),4)
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(72),mass4set(:,19),  & 
G1tensor(238),G1tensor(250),G1tensor(239),G1tensor(240),G1tensor(251))
  call G_TensorShift(G1tensor(250),4)
  call Hotf_4pt_reduction_last(G2tensor(49),RedSet_4(78),mass4set(:,10),  & 
G1tensor(245),G1tensor(246),G1tensor(255),G1tensor(256),G1tensor(262))
  call G_TensorShift(G1tensor(246),4)
  call Hotf_4pt_reduction_last(G2tensor(16),RedSet_4(79),mass4set(:,10),  & 
G1tensor(287),G1tensor(275),G1tensor(299),G1tensor(281),G1tensor(292))
  call G_TensorShift(G1tensor(275),4)
  call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(80),mass4set(:,15),  & 
G1tensor(293),G1tensor(322),G1tensor(304),G1tensor(309),G1tensor(310))
  call G_TensorShift(G1tensor(322),4)
  call Hotf_4pt_reduction_last(G2tensor(20),RedSet_4(83),mass4set(:,10),  & 
G1tensor(328),G1tensor(316),G1tensor(333),G1tensor(334),G1tensor(335))
  call G_TensorShift(G1tensor(316),8)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(84),mass4set(:,15),  & 
G1tensor(339),G1tensor(341),G1tensor(343),G1tensor(344),G1tensor(345))
  call G_TensorShift(G1tensor(341),8)
  call Hotf_4pt_reduction_last(G2tensor(32),RedSet_4(91),mass4set(:,10),  & 
G1tensor(346),G1tensor(347),G1tensor(348),G1tensor(349),G1tensor(350))
  call G_TensorShift(G1tensor(347),2)
  call Hotf_4pt_reduction_last(G2tensor(33),RedSet_4(10),mass4set(:,1),  & 
G1tensor(351),G1tensor(352),G1tensor(353),G1tensor(354),G1tensor(355))
  call G_TensorShift(G1tensor(352),8)
  call Hotf_4pt_reduction_last(G2tensor(51),RedSet_4(87),mass4set(:,1),  & 
G1tensor(356),G1tensor(357),G1tensor(358),G1tensor(359),G1tensor(360))
  call G_TensorShift(G1tensor(357),19)
  call Hotf_4pt_reduction_last(G2tensor(54),RedSet_4(87),mass4set(:,6),  & 
G1tensor(361),G1tensor(362),G1tensor(363),G1tensor(364),G1tensor(365))
  call G_TensorShift(G1tensor(362),19)
  call Hotf_4pt_reduction_last(G2tensor(79),RedSet_4(88),mass4set(:,1),  & 
G1tensor(366),G1tensor(367),G1tensor(368),G1tensor(369),G1tensor(370))
  call G_TensorShift(G1tensor(367),19)
  call Hotf_4pt_reduction_last(G2tensor(82),RedSet_4(88),mass4set(:,6),  & 
G1tensor(371),G1tensor(372),G1tensor(373),G1tensor(374),G1tensor(375))
  call G_TensorShift(G1tensor(372),19)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(52),mass4set(:,7),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(15),RedSet_4(11),mass4set(:,2),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(52),mass4set(:,8),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(11),mass4set(:,3),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(57),mass4set(:,9),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(27),mass4set(:,10),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(181),RedSet_4(57),mass4set(:,11),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(211),RedSet_4(27),mass4set(:,12),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(241),RedSet_4(52),mass4set(:,13),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(271),RedSet_4(11),mass4set(:,4),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(301),RedSet_4(57),mass4set(:,12),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(331),RedSet_4(89),mass4set(:,14),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(78),RedSet_4(81),mass4set(:,15),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(128),RedSet_4(90),mass4set(:,14),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(59),RedSet_4(85),mass4set(:,15),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(7),RedSet_4(92),mass4set(:,23),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(18),RedSet_4(50),mass4set(:,16),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(68),RedSet_4(51),mass4set(:,14),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(80),RedSet_4(53),mass4set(:,23),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(43),RedSet_4(92),mass4set(:,24),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(336),RedSet_4(50),mass4set(:,17),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(92),RedSet_4(51),mass4set(:,13),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(104),RedSet_4(53),mass4set(:,24),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call Hotf_4pt_reduction_last(G1tensor(20),RedSet_4(93),mass4set(:,10),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
  call Hotf_4pt_reduction_last(G1tensor(110),RedSet_4(54),mass4set(:,25),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
  call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(55),mass4set(:,24),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
  call Hotf_4pt_reduction_last(G1tensor(122),RedSet_4(56),mass4set(:,24),  & 
G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(93),mass4set(:,12),  & 
G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140))
  call Hotf_4pt_reduction_last(G1tensor(134),RedSet_4(54),mass4set(:,26),  & 
G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144),G0tensor(145))
  call Hotf_4pt_reduction_last(G1tensor(140),RedSet_4(55),mass4set(:,23),  & 
G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149),G0tensor(150))
  call Hotf_4pt_reduction_last(G1tensor(146),RedSet_4(56),mass4set(:,23),  & 
G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154),G0tensor(155))
  call Hotf_4pt_reduction_last(G1tensor(9),RedSet_4(94),mass4set(:,23),  & 
G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159),G0tensor(160))
  call Hotf_4pt_reduction_last(G1tensor(62),RedSet_4(58),mass4set(:,16),  & 
G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164),G0tensor(165))
  call Hotf_4pt_reduction_last(G1tensor(164),RedSet_4(59),mass4set(:,14),  & 
G0tensor(166),G0tensor(167),G0tensor(168),G0tensor(169),G0tensor(170))
  call Hotf_4pt_reduction_last(G1tensor(170),RedSet_4(60),mass4set(:,23),  & 
G0tensor(171),G0tensor(172),G0tensor(173),G0tensor(174),G0tensor(175))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(94),mass4set(:,27),  & 
G0tensor(176),G0tensor(177),G0tensor(178),G0tensor(179),G0tensor(180))
  call Hotf_4pt_reduction_last(G1tensor(279),RedSet_4(58),mass4set(:,13),  & 
G0tensor(181),G0tensor(182),G0tensor(183),G0tensor(184),G0tensor(185))
  call Hotf_4pt_reduction_last(G1tensor(182),RedSet_4(59),mass4set(:,13),  & 
G0tensor(186),G0tensor(187),G0tensor(188),G0tensor(189),G0tensor(190))
  call Hotf_4pt_reduction_last(G1tensor(194),RedSet_4(60),mass4set(:,27),  & 
G0tensor(191),G0tensor(192),G0tensor(193),G0tensor(194),G0tensor(195))
  call Hotf_4pt_reduction_last(G1tensor(23),RedSet_4(94),mass4set(:,24),  & 
G0tensor(196),G0tensor(197),G0tensor(198),G0tensor(199),G0tensor(200))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(58),mass4set(:,17),  & 
G0tensor(201),G0tensor(202),G0tensor(203),G0tensor(204),G0tensor(205))
  call Hotf_4pt_reduction_last(G1tensor(206),RedSet_4(60),mass4set(:,24),  & 
G0tensor(206),G0tensor(207),G0tensor(208),G0tensor(209),G0tensor(210))
  call Hotf_4pt_reduction_last(G1tensor(33),RedSet_4(95),mass4set(:,10),  & 
G0tensor(211),G0tensor(212),G0tensor(213),G0tensor(214),G0tensor(215))
  call Hotf_4pt_reduction_last(G1tensor(212),RedSet_4(61),mass4set(:,25),  & 
G0tensor(216),G0tensor(217),G0tensor(218),G0tensor(219),G0tensor(220))
  call Hotf_4pt_reduction_last(G1tensor(218),RedSet_4(62),mass4set(:,24),  & 
G0tensor(221),G0tensor(222),G0tensor(223),G0tensor(224),G0tensor(225))
  call Hotf_4pt_reduction_last(G1tensor(224),RedSet_4(63),mass4set(:,24),  & 
G0tensor(226),G0tensor(227),G0tensor(228),G0tensor(229),G0tensor(230))
  call Hotf_4pt_reduction_last(G1tensor(53),RedSet_4(95),mass4set(:,12),  & 
G0tensor(231),G0tensor(232),G0tensor(233),G0tensor(234),G0tensor(235))
  call Hotf_4pt_reduction_last(G1tensor(230),RedSet_4(61),mass4set(:,22),  & 
G0tensor(236),G0tensor(237),G0tensor(238),G0tensor(239),G0tensor(240))
  call Hotf_4pt_reduction_last(G1tensor(236),RedSet_4(62),mass4set(:,5),  & 
G0tensor(241),G0tensor(242),G0tensor(243),G0tensor(244),G0tensor(245))
  call Hotf_4pt_reduction_last(G1tensor(242),RedSet_4(63),mass4set(:,5),  & 
G0tensor(246),G0tensor(247),G0tensor(248),G0tensor(249),G0tensor(250))
  call Hotf_4pt_reduction_last(G1tensor(254),RedSet_4(61),mass4set(:,26),  & 
G0tensor(251),G0tensor(252),G0tensor(253),G0tensor(254),G0tensor(255))
  call Hotf_4pt_reduction_last(G1tensor(260),RedSet_4(62),mass4set(:,23),  & 
G0tensor(256),G0tensor(257),G0tensor(258),G0tensor(259),G0tensor(260))
  call Hotf_4pt_reduction_last(G1tensor(266),RedSet_4(63),mass4set(:,23),  & 
G0tensor(261),G0tensor(262),G0tensor(263),G0tensor(264),G0tensor(265))
  call Hotf_4pt_reduction_last(G1tensor(69),RedSet_4(1),mass4set(:,10),  & 
G0tensor(266),G0tensor(267),G0tensor(268),G0tensor(269),G0tensor(270))
  call Hotf_4pt_reduction_last(G1tensor(29),RedSet_4(2),mass4set(:,18),  & 
G0tensor(271),G0tensor(272),G0tensor(273),G0tensor(274),G0tensor(275))
  call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(3),mass4set(:,28),  & 
G0tensor(276),G0tensor(277),G0tensor(278),G0tensor(279),G0tensor(280))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(4),mass4set(:,28),  & 
G0tensor(281),G0tensor(282),G0tensor(283),G0tensor(284),G0tensor(285))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(6),mass4set(:,10),  & 
G0tensor(286),G0tensor(287),G0tensor(288),G0tensor(289),G0tensor(290))
  call Hotf_4pt_reduction_last(G1tensor(82),RedSet_4(7),mass4set(:,15),  & 
G0tensor(291),G0tensor(292),G0tensor(293),G0tensor(294),G0tensor(295))
  call Hotf_4pt_reduction_last(G1tensor(72),RedSet_4(8),mass4set(:,15),  & 
G0tensor(296),G0tensor(297),G0tensor(298),G0tensor(299),G0tensor(300))
  call Hotf_4pt_reduction_last(G1tensor(17),RedSet_4(10),mass4set(:,2),  & 
G0tensor(301),G0tensor(302),G0tensor(303),G0tensor(304),G0tensor(305))
  call Hotf_4pt_reduction_last(G1tensor(84),RedSet_4(13),mass4set(:,5),  & 
G0tensor(306),G0tensor(307),G0tensor(308),G0tensor(309),G0tensor(310))
  call Hotf_4pt_reduction_last(G1tensor(93),RedSet_4(1),mass4set(:,12),  & 
G0tensor(311),G0tensor(312),G0tensor(313),G0tensor(314),G0tensor(315))
  call Hotf_4pt_reduction_last(G1tensor(297),RedSet_4(2),mass4set(:,19),  & 
G0tensor(316),G0tensor(317),G0tensor(318),G0tensor(319),G0tensor(320))
  call Hotf_4pt_reduction_last(G1tensor(105),RedSet_4(3),mass4set(:,29),  & 
G0tensor(321),G0tensor(322),G0tensor(323),G0tensor(324),G0tensor(325))
  call Hotf_4pt_reduction_last(G1tensor(90),RedSet_4(4),mass4set(:,29),  & 
G0tensor(326),G0tensor(327),G0tensor(328),G0tensor(329),G0tensor(330))
  call Hotf_4pt_reduction_last(G1tensor(34),RedSet_4(6),mass4set(:,12),  & 
G0tensor(331),G0tensor(332),G0tensor(333),G0tensor(334),G0tensor(335))
  call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(7),mass4set(:,4),  & 
G0tensor(336),G0tensor(337),G0tensor(338),G0tensor(339),G0tensor(340))
  call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(8),mass4set(:,4),  & 
G0tensor(341),G0tensor(342),G0tensor(343),G0tensor(344),G0tensor(345))
  call Hotf_4pt_reduction_last(G1tensor(47),RedSet_4(10),mass4set(:,3),  & 
G0tensor(346),G0tensor(347),G0tensor(348),G0tensor(349),G0tensor(350))
  call Hotf_4pt_reduction_last(G1tensor(108),RedSet_4(13),mass4set(:,6),  & 
G0tensor(351),G0tensor(352),G0tensor(353),G0tensor(354),G0tensor(355))
  call Hotf_4pt_reduction_last(G1tensor(117),RedSet_4(16),mass4set(:,29),  & 
G0tensor(356),G0tensor(357),G0tensor(358),G0tensor(359),G0tensor(360))
  call Hotf_4pt_reduction_last(G1tensor(123),RedSet_4(17),mass4set(:,29),  & 
G0tensor(361),G0tensor(362),G0tensor(363),G0tensor(364),G0tensor(365))
  call Hotf_4pt_reduction_last(G1tensor(160),RedSet_4(18),mass4set(:,20),  & 
G0tensor(366),G0tensor(367),G0tensor(368),G0tensor(369),G0tensor(370))
  call Hotf_4pt_reduction_last(G1tensor(114),RedSet_4(19),mass4set(:,30),  & 
G0tensor(371),G0tensor(372),G0tensor(373),G0tensor(374),G0tensor(375))
  call Hotf_4pt_reduction_last(G1tensor(124),RedSet_4(21),mass4set(:,4),  & 
G0tensor(376),G0tensor(377),G0tensor(378),G0tensor(379),G0tensor(380))
  call Hotf_4pt_reduction_last(G1tensor(166),RedSet_4(22),mass4set(:,3),  & 
G0tensor(381),G0tensor(382),G0tensor(383),G0tensor(384),G0tensor(385))
  call Hotf_4pt_reduction_last(G1tensor(120),RedSet_4(23),mass4set(:,6),  & 
G0tensor(386),G0tensor(387),G0tensor(388),G0tensor(389),G0tensor(390))
  call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(25),mass4set(:,6),  & 
G0tensor(391),G0tensor(392),G0tensor(393),G0tensor(394),G0tensor(395))
  call Hotf_4pt_reduction_last(G1tensor(141),RedSet_4(16),mass4set(:,28),  & 
G0tensor(396),G0tensor(397),G0tensor(398),G0tensor(399),G0tensor(400))
  call Hotf_4pt_reduction_last(G1tensor(147),RedSet_4(17),mass4set(:,28),  & 
G0tensor(401),G0tensor(402),G0tensor(403),G0tensor(404),G0tensor(405))
  call Hotf_4pt_reduction_last(G1tensor(173),RedSet_4(18),mass4set(:,21),  & 
G0tensor(406),G0tensor(407),G0tensor(408),G0tensor(409),G0tensor(410))
  call Hotf_4pt_reduction_last(G1tensor(138),RedSet_4(19),mass4set(:,22),  & 
G0tensor(411),G0tensor(412),G0tensor(413),G0tensor(414),G0tensor(415))
  call Hotf_4pt_reduction_last(G1tensor(148),RedSet_4(21),mass4set(:,15),  & 
G0tensor(416),G0tensor(417),G0tensor(418),G0tensor(419),G0tensor(420))
  call Hotf_4pt_reduction_last(G1tensor(87),RedSet_4(22),mass4set(:,2),  & 
G0tensor(421),G0tensor(422),G0tensor(423),G0tensor(424),G0tensor(425))
  call Hotf_4pt_reduction_last(G1tensor(144),RedSet_4(23),mass4set(:,5),  & 
G0tensor(426),G0tensor(427),G0tensor(428),G0tensor(429),G0tensor(430))
  call Hotf_4pt_reduction_last(G1tensor(150),RedSet_4(25),mass4set(:,5),  & 
G0tensor(431),G0tensor(432),G0tensor(433),G0tensor(434),G0tensor(435))
  call Hotf_4pt_reduction_last(G1tensor(165),RedSet_4(30),mass4set(:,10),  & 
G0tensor(436),G0tensor(437),G0tensor(438),G0tensor(439),G0tensor(440))
  call Hotf_4pt_reduction_last(G1tensor(171),RedSet_4(31),mass4set(:,28),  & 
G0tensor(441),G0tensor(442),G0tensor(443),G0tensor(444),G0tensor(445))
  call Hotf_4pt_reduction_last(G1tensor(162),RedSet_4(32),mass4set(:,28),  & 
G0tensor(446),G0tensor(447),G0tensor(448),G0tensor(449),G0tensor(450))
  call Hotf_4pt_reduction_last(G1tensor(172),RedSet_4(34),mass4set(:,15),  & 
G0tensor(451),G0tensor(452),G0tensor(453),G0tensor(454),G0tensor(455))
  call Hotf_4pt_reduction_last(G1tensor(168),RedSet_4(35),mass4set(:,15),  & 
G0tensor(456),G0tensor(457),G0tensor(458),G0tensor(459),G0tensor(460))
  call Hotf_4pt_reduction_last(G1tensor(174),RedSet_4(37),mass4set(:,5),  & 
G0tensor(461),G0tensor(462),G0tensor(463),G0tensor(464),G0tensor(465))
  call Hotf_4pt_reduction_last(G1tensor(201),RedSet_4(30),mass4set(:,12),  & 
G0tensor(466),G0tensor(467),G0tensor(468),G0tensor(469),G0tensor(470))
  call Hotf_4pt_reduction_last(G1tensor(190),RedSet_4(2),mass4set(:,12),  & 
G0tensor(471),G0tensor(472),G0tensor(473),G0tensor(474),G0tensor(475))
  call Hotf_4pt_reduction_last(G1tensor(195),RedSet_4(31),mass4set(:,4),  & 
G0tensor(476),G0tensor(477),G0tensor(478),G0tensor(479),G0tensor(480))
  call Hotf_4pt_reduction_last(G1tensor(180),RedSet_4(32),mass4set(:,4),  & 
G0tensor(481),G0tensor(482),G0tensor(483),G0tensor(484),G0tensor(485))
  call Hotf_4pt_reduction_last(G1tensor(208),RedSet_4(34),mass4set(:,4),  & 
G0tensor(486),G0tensor(487),G0tensor(488),G0tensor(489),G0tensor(490))
  call Hotf_4pt_reduction_last(G1tensor(186),RedSet_4(35),mass4set(:,4),  & 
G0tensor(491),G0tensor(492),G0tensor(493),G0tensor(494),G0tensor(495))
  call Hotf_4pt_reduction_last(G1tensor(227),RedSet_4(10),mass4set(:,4),  & 
G0tensor(496),G0tensor(497),G0tensor(498),G0tensor(499),G0tensor(500))
  call Hotf_4pt_reduction_last(G1tensor(198),RedSet_4(37),mass4set(:,1),  & 
G0tensor(501),G0tensor(502),G0tensor(503),G0tensor(504),G0tensor(505))
  call Hotf_4pt_reduction_last(G1tensor(207),RedSet_4(31),mass4set(:,29),  & 
G0tensor(506),G0tensor(507),G0tensor(508),G0tensor(509),G0tensor(510))
  call Hotf_4pt_reduction_last(G1tensor(204),RedSet_4(32),mass4set(:,29),  & 
G0tensor(511),G0tensor(512),G0tensor(513),G0tensor(514),G0tensor(515))
  call Hotf_4pt_reduction_last(G1tensor(210),RedSet_4(37),mass4set(:,6),  & 
G0tensor(516),G0tensor(517),G0tensor(518),G0tensor(519),G0tensor(520))
  call Hotf_4pt_reduction_last(G1tensor(219),RedSet_4(40),mass4set(:,29),  & 
G0tensor(521),G0tensor(522),G0tensor(523),G0tensor(524),G0tensor(525))
  call Hotf_4pt_reduction_last(G1tensor(225),RedSet_4(41),mass4set(:,29),  & 
G0tensor(526),G0tensor(527),G0tensor(528),G0tensor(529),G0tensor(530))
  call Hotf_4pt_reduction_last(G1tensor(216),RedSet_4(42),mass4set(:,30),  & 
G0tensor(531),G0tensor(532),G0tensor(533),G0tensor(534),G0tensor(535))
  call Hotf_4pt_reduction_last(G1tensor(226),RedSet_4(44),mass4set(:,4),  & 
G0tensor(536),G0tensor(537),G0tensor(538),G0tensor(539),G0tensor(540))
  call Hotf_4pt_reduction_last(G1tensor(222),RedSet_4(45),mass4set(:,6),  & 
G0tensor(541),G0tensor(542),G0tensor(543),G0tensor(544),G0tensor(545))
  call Hotf_4pt_reduction_last(G1tensor(228),RedSet_4(47),mass4set(:,6),  & 
G0tensor(546),G0tensor(547),G0tensor(548),G0tensor(549),G0tensor(550))
  call Hotf_4pt_reduction_last(G1tensor(237),RedSet_4(40),mass4set(:,31),  & 
G0tensor(551),G0tensor(552),G0tensor(553),G0tensor(554),G0tensor(555))
  call Hotf_4pt_reduction_last(G1tensor(243),RedSet_4(41),mass4set(:,31),  & 
G0tensor(556),G0tensor(557),G0tensor(558),G0tensor(559),G0tensor(560))
  call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(18),mass4set(:,22),  & 
G0tensor(561),G0tensor(562),G0tensor(563),G0tensor(564),G0tensor(565))
  call Hotf_4pt_reduction_last(G1tensor(258),RedSet_4(42),mass4set(:,22),  & 
G0tensor(566),G0tensor(567),G0tensor(568),G0tensor(569),G0tensor(570))
  call Hotf_4pt_reduction_last(G1tensor(244),RedSet_4(44),mass4set(:,1),  & 
G0tensor(571),G0tensor(572),G0tensor(573),G0tensor(574),G0tensor(575))
  call Hotf_4pt_reduction_last(G1tensor(113),RedSet_4(22),mass4set(:,5),  & 
G0tensor(576),G0tensor(577),G0tensor(578),G0tensor(579),G0tensor(580))
  call Hotf_4pt_reduction_last(G1tensor(264),RedSet_4(45),mass4set(:,5),  & 
G0tensor(581),G0tensor(582),G0tensor(583),G0tensor(584),G0tensor(585))
  call Hotf_4pt_reduction_last(G1tensor(135),RedSet_4(10),mass4set(:,5),  & 
G0tensor(586),G0tensor(587),G0tensor(588),G0tensor(589),G0tensor(590))
  call Hotf_4pt_reduction_last(G1tensor(270),RedSet_4(47),mass4set(:,5),  & 
G0tensor(591),G0tensor(592),G0tensor(593),G0tensor(594),G0tensor(595))
  call Hotf_4pt_reduction_last(G1tensor(261),RedSet_4(40),mass4set(:,28),  & 
G0tensor(596),G0tensor(597),G0tensor(598),G0tensor(599),G0tensor(600))
  call Hotf_4pt_reduction_last(G1tensor(267),RedSet_4(41),mass4set(:,28),  & 
G0tensor(601),G0tensor(602),G0tensor(603),G0tensor(604),G0tensor(605))
  call Hotf_4pt_reduction_last(G1tensor(268),RedSet_4(44),mass4set(:,15),  & 
G0tensor(606),G0tensor(607),G0tensor(608),G0tensor(609),G0tensor(610))
  call Hotf_4pt_reduction_last(G1tensor(272),RedSet_4(96),mass4set(:,23),  & 
G0tensor(611),G0tensor(612),G0tensor(613),G0tensor(614),G0tensor(615))
  call Hotf_4pt_reduction_last(G1tensor(274),RedSet_4(64),mass4set(:,14),  & 
G0tensor(616),G0tensor(617),G0tensor(618),G0tensor(619),G0tensor(620))
  call Hotf_4pt_reduction_last(G1tensor(142),RedSet_4(65),mass4set(:,7),  & 
G0tensor(621),G0tensor(622),G0tensor(623),G0tensor(624),G0tensor(625))
  call Hotf_4pt_reduction_last(G1tensor(276),RedSet_4(66),mass4set(:,23),  & 
G0tensor(626),G0tensor(627),G0tensor(628),G0tensor(629),G0tensor(630))
  call Hotf_4pt_reduction_last(G1tensor(278),RedSet_4(96),mass4set(:,24),  & 
G0tensor(631),G0tensor(632),G0tensor(633),G0tensor(634),G0tensor(635))
  call Hotf_4pt_reduction_last(G1tensor(280),RedSet_4(64),mass4set(:,13),  & 
G0tensor(636),G0tensor(637),G0tensor(638),G0tensor(639),G0tensor(640))
  call Hotf_4pt_reduction_last(G1tensor(161),RedSet_4(65),mass4set(:,8),  & 
G0tensor(641),G0tensor(642),G0tensor(643),G0tensor(644),G0tensor(645))
  call Hotf_4pt_reduction_last(G1tensor(282),RedSet_4(66),mass4set(:,24),  & 
G0tensor(646),G0tensor(647),G0tensor(648),G0tensor(649),G0tensor(650))
  call Hotf_4pt_reduction_last(G1tensor(284),RedSet_4(97),mass4set(:,23),  & 
G0tensor(651),G0tensor(652),G0tensor(653),G0tensor(654),G0tensor(655))
  call Hotf_4pt_reduction_last(G1tensor(286),RedSet_4(68),mass4set(:,14),  & 
G0tensor(656),G0tensor(657),G0tensor(658),G0tensor(659),G0tensor(660))
  call Hotf_4pt_reduction_last(G1tensor(288),RedSet_4(69),mass4set(:,23),  & 
G0tensor(661),G0tensor(662),G0tensor(663),G0tensor(664),G0tensor(665))
  call Hotf_4pt_reduction_last(G1tensor(290),RedSet_4(97),mass4set(:,27),  & 
G0tensor(666),G0tensor(667),G0tensor(668),G0tensor(669),G0tensor(670))
  call Hotf_4pt_reduction_last(G1tensor(298),RedSet_4(68),mass4set(:,13),  & 
G0tensor(671),G0tensor(672),G0tensor(673),G0tensor(674),G0tensor(675))
  call Hotf_4pt_reduction_last(G1tensor(178),RedSet_4(65),mass4set(:,13),  & 
G0tensor(676),G0tensor(677),G0tensor(678),G0tensor(679),G0tensor(680))
  call Hotf_4pt_reduction_last(G1tensor(294),RedSet_4(69),mass4set(:,27),  & 
G0tensor(681),G0tensor(682),G0tensor(683),G0tensor(684),G0tensor(685))
  call Hotf_4pt_reduction_last(G1tensor(296),RedSet_4(97),mass4set(:,24),  & 
G0tensor(686),G0tensor(687),G0tensor(688),G0tensor(689),G0tensor(690))
  call Hotf_4pt_reduction_last(G1tensor(300),RedSet_4(69),mass4set(:,24),  & 
G0tensor(691),G0tensor(692),G0tensor(693),G0tensor(694),G0tensor(695))
  call Hotf_4pt_reduction_last(G1tensor(303),RedSet_4(71),mass4set(:,10),  & 
G0tensor(696),G0tensor(697),G0tensor(698),G0tensor(699),G0tensor(700))
  call Hotf_4pt_reduction_last(G1tensor(191),RedSet_4(72),mass4set(:,18),  & 
G0tensor(701),G0tensor(702),G0tensor(703),G0tensor(704),G0tensor(705))
  call Hotf_4pt_reduction_last(G1tensor(305),RedSet_4(73),mass4set(:,28),  & 
G0tensor(706),G0tensor(707),G0tensor(708),G0tensor(709),G0tensor(710))
  call Hotf_4pt_reduction_last(G1tensor(306),RedSet_4(74),mass4set(:,28),  & 
G0tensor(711),G0tensor(712),G0tensor(713),G0tensor(714),G0tensor(715))
  call Hotf_4pt_reduction_last(G1tensor(315),RedSet_4(71),mass4set(:,12),  & 
G0tensor(716),G0tensor(717),G0tensor(718),G0tensor(719),G0tensor(720))
  call Hotf_4pt_reduction_last(G1tensor(231),RedSet_4(72),mass4set(:,12),  & 
G0tensor(721),G0tensor(722),G0tensor(723),G0tensor(724),G0tensor(725))
  call Hotf_4pt_reduction_last(G1tensor(311),RedSet_4(73),mass4set(:,4),  & 
G0tensor(726),G0tensor(727),G0tensor(728),G0tensor(729),G0tensor(730))
  call Hotf_4pt_reduction_last(G1tensor(312),RedSet_4(74),mass4set(:,4),  & 
G0tensor(731),G0tensor(732),G0tensor(733),G0tensor(734),G0tensor(735))
  call Hotf_4pt_reduction_last(G1tensor(238),RedSet_4(72),mass4set(:,19),  & 
G0tensor(736),G0tensor(737),G0tensor(738),G0tensor(739),G0tensor(740))
  call Hotf_4pt_reduction_last(G1tensor(317),RedSet_4(73),mass4set(:,29),  & 
G0tensor(741),G0tensor(742),G0tensor(743),G0tensor(744),G0tensor(745))
  call Hotf_4pt_reduction_last(G1tensor(318),RedSet_4(74),mass4set(:,29),  & 
G0tensor(746),G0tensor(747),G0tensor(748),G0tensor(749),G0tensor(750))
  call Hotf_4pt_reduction_last(G1tensor(321),RedSet_4(75),mass4set(:,10),  & 
G0tensor(751),G0tensor(752),G0tensor(753),G0tensor(754),G0tensor(755))
  call Hotf_4pt_reduction_last(G1tensor(323),RedSet_4(76),mass4set(:,28),  & 
G0tensor(756),G0tensor(757),G0tensor(758),G0tensor(759),G0tensor(760))
  call Hotf_4pt_reduction_last(G1tensor(324),RedSet_4(77),mass4set(:,28),  & 
G0tensor(761),G0tensor(762),G0tensor(763),G0tensor(764),G0tensor(765))
  call Hotf_4pt_reduction_last(G1tensor(327),RedSet_4(75),mass4set(:,12),  & 
G0tensor(766),G0tensor(767),G0tensor(768),G0tensor(769),G0tensor(770))
  call Hotf_4pt_reduction_last(G1tensor(329),RedSet_4(76),mass4set(:,29),  & 
G0tensor(771),G0tensor(772),G0tensor(773),G0tensor(774),G0tensor(775))
  call Hotf_4pt_reduction_last(G1tensor(330),RedSet_4(77),mass4set(:,29),  & 
G0tensor(776),G0tensor(777),G0tensor(778),G0tensor(779),G0tensor(780))
  call Hotf_4pt_reduction_last(G1tensor(245),RedSet_4(78),mass4set(:,10),  & 
G0tensor(781),G0tensor(782),G0tensor(783),G0tensor(784),G0tensor(785))
  call Hotf_4pt_reduction_last(G1tensor(287),RedSet_4(79),mass4set(:,10),  & 
G0tensor(786),G0tensor(787),G0tensor(788),G0tensor(789),G0tensor(790))
  call Hotf_4pt_reduction_last(G1tensor(293),RedSet_4(80),mass4set(:,15),  & 
G0tensor(791),G0tensor(792),G0tensor(793),G0tensor(794),G0tensor(795))
  call Hotf_4pt_reduction_last(G1tensor(328),RedSet_4(83),mass4set(:,10),  & 
G0tensor(796),G0tensor(797),G0tensor(798),G0tensor(799),G0tensor(800))
  call Hotf_4pt_reduction_last(G1tensor(339),RedSet_4(84),mass4set(:,15),  & 
G0tensor(801),G0tensor(802),G0tensor(803),G0tensor(804),G0tensor(805))
  call Hotf_4pt_reduction_last(G1tensor(346),RedSet_4(91),mass4set(:,10),  & 
G0tensor(806),G0tensor(807),G0tensor(808),G0tensor(809),G0tensor(810))
  call Hotf_4pt_reduction_last(G1tensor(351),RedSet_4(10),mass4set(:,1),  & 
G0tensor(811),G0tensor(812),G0tensor(813),G0tensor(814),G0tensor(815))
  call Hotf_4pt_reduction_last(G1tensor(356),RedSet_4(87),mass4set(:,1),  & 
G0tensor(816),G0tensor(817),G0tensor(818),G0tensor(819),G0tensor(820))
  call Hotf_4pt_reduction_last(G1tensor(361),RedSet_4(87),mass4set(:,6),  & 
G0tensor(821),G0tensor(822),G0tensor(823),G0tensor(824),G0tensor(825))
  call Hotf_4pt_reduction_last(G1tensor(366),RedSet_4(88),mass4set(:,1),  & 
G0tensor(826),G0tensor(827),G0tensor(828),G0tensor(829),G0tensor(830))
  call Hotf_4pt_reduction_last(G1tensor(371),RedSet_4(88),mass4set(:,6),  & 
G0tensor(831),G0tensor(832),G0tensor(833),G0tensor(834),G0tensor(835))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  call ol_merge_tensors(T0sum(21),[G0tensor(101)])
  call ol_merge_tensors(T0sum(22),[G0tensor(106)])
  call ol_merge_tensors(T0sum(23),[G0tensor(111)])
  call ol_merge_tensors(T0sum(24),[G0tensor(116)])
  call ol_merge_tensors(T0sum(25),[G0tensor(121)])
  call ol_merge_tensors(T0sum(26),[G0tensor(126)])
  call ol_merge_tensors(T0sum(27),[G0tensor(131)])
  call ol_merge_tensors(T0sum(28),[G0tensor(136)])
  call ol_merge_tensors(T0sum(29),[G0tensor(141)])
  call ol_merge_tensors(T0sum(30),[G0tensor(146)])
  call ol_merge_tensors(T0sum(31),[G0tensor(151)])
  call ol_merge_tensors(T0sum(32),[G0tensor(156)])
  call ol_merge_tensors(T0sum(33),[G0tensor(161)])
  call ol_merge_tensors(T0sum(34),[G0tensor(166)])
  call ol_merge_tensors(T0sum(35),[G0tensor(171)])
  call ol_merge_tensors(T0sum(36),[G0tensor(176)])
  call ol_merge_tensors(T0sum(37),[G0tensor(181)])
  call ol_merge_tensors(T0sum(38),[G0tensor(186)])
  call ol_merge_tensors(T0sum(39),[G0tensor(191)])
  call ol_merge_tensors(T0sum(40),[G0tensor(196)])
  call ol_merge_tensors(T0sum(41),[G0tensor(201)])
  call ol_merge_tensors(T0sum(42),[G0tensor(206)])
  call ol_merge_tensors(T0sum(43),[G0tensor(211)])
  call ol_merge_tensors(T0sum(44),[G0tensor(216)])
  call ol_merge_tensors(T0sum(45),[G0tensor(221)])
  call ol_merge_tensors(T0sum(46),[G0tensor(226)])
  call ol_merge_tensors(T0sum(47),[G0tensor(231)])
  call ol_merge_tensors(T0sum(48),[G0tensor(236)])
  call ol_merge_tensors(T0sum(49),[G0tensor(241)])
  call ol_merge_tensors(T0sum(50),[G0tensor(246)])
  call ol_merge_tensors(T0sum(51),[G0tensor(251)])
  call ol_merge_tensors(T0sum(52),[G0tensor(256)])
  call ol_merge_tensors(T0sum(53),[G0tensor(261)])
  call ol_merge_tensors(T0sum(54),[G0tensor(266)])
  call ol_merge_tensors(T0sum(55),[G0tensor(271)])
  call ol_merge_tensors(T0sum(56),[G0tensor(276)])
  call ol_merge_tensors(T0sum(57),[G0tensor(281)])
  call ol_merge_tensors(T0sum(58),[G0tensor(286)])
  call ol_merge_tensors(T0sum(59),[G0tensor(291)])
  call ol_merge_tensors(T0sum(60),[G0tensor(296)])
  call ol_merge_tensors(T0sum(61),[G0tensor(301)])
  call ol_merge_tensors(T0sum(62),[G0tensor(306)])
  call ol_merge_tensors(T0sum(63),[G0tensor(311)])
  call ol_merge_tensors(T0sum(64),[G0tensor(316)])
  call ol_merge_tensors(T0sum(65),[G0tensor(321)])
  call ol_merge_tensors(T0sum(66),[G0tensor(326)])
  call ol_merge_tensors(T0sum(67),[G0tensor(331)])
  call ol_merge_tensors(T0sum(68),[G0tensor(336)])
  call ol_merge_tensors(T0sum(69),[G0tensor(341)])
  call ol_merge_tensors(T0sum(70),[G0tensor(346)])
  call ol_merge_tensors(T0sum(71),[G0tensor(351)])
  call ol_merge_tensors(T0sum(72),[G0tensor(356)])
  call ol_merge_tensors(T0sum(73),[G0tensor(361)])
  call ol_merge_tensors(T0sum(74),[G0tensor(366)])
  call ol_merge_tensors(T0sum(75),[G0tensor(371)])
  call ol_merge_tensors(T0sum(76),[G0tensor(376)])
  call ol_merge_tensors(T0sum(77),[G0tensor(381)])
  call ol_merge_tensors(T0sum(78),[G0tensor(386)])
  call ol_merge_tensors(T0sum(79),[G0tensor(391)])
  call ol_merge_tensors(T0sum(80),[G0tensor(396)])
  call ol_merge_tensors(T0sum(81),[G0tensor(401)])
  call ol_merge_tensors(T0sum(82),[G0tensor(406)])
  call ol_merge_tensors(T0sum(83),[G0tensor(411)])
  call ol_merge_tensors(T0sum(84),[G0tensor(416)])
  call ol_merge_tensors(T0sum(85),[G0tensor(421)])
  call ol_merge_tensors(T0sum(86),[G0tensor(426)])
  call ol_merge_tensors(T0sum(87),[G0tensor(431)])
  call ol_merge_tensors(T0sum(88),[G0tensor(436)])
  call ol_merge_tensors(T0sum(89),[G0tensor(441)])
  call ol_merge_tensors(T0sum(90),[G0tensor(446)])
  call ol_merge_tensors(T0sum(91),[G0tensor(451)])
  call ol_merge_tensors(T0sum(92),[G0tensor(456)])
  call ol_merge_tensors(T0sum(93),[G0tensor(461)])
  call ol_merge_tensors(T0sum(94),[G0tensor(466)])
  call ol_merge_tensors(T0sum(95),[G0tensor(471)])
  call ol_merge_tensors(T0sum(96),[G0tensor(476)])
  call ol_merge_tensors(T0sum(97),[G0tensor(481)])
  call ol_merge_tensors(T0sum(98),[G0tensor(486)])
  call ol_merge_tensors(T0sum(99),[G0tensor(491)])
  call ol_merge_tensors(T0sum(100),[G0tensor(496)])
  call ol_merge_tensors(T0sum(101),[G0tensor(501)])
  call ol_merge_tensors(T0sum(102),[G0tensor(506)])
  call ol_merge_tensors(T0sum(103),[G0tensor(511)])
  call ol_merge_tensors(T0sum(104),[G0tensor(516)])
  call ol_merge_tensors(T0sum(105),[G0tensor(521)])
  call ol_merge_tensors(T0sum(106),[G0tensor(526)])
  call ol_merge_tensors(T0sum(107),[G0tensor(531)])
  call ol_merge_tensors(T0sum(108),[G0tensor(536)])
  call ol_merge_tensors(T0sum(109),[G0tensor(541)])
  call ol_merge_tensors(T0sum(110),[G0tensor(546)])
  call ol_merge_tensors(T0sum(111),[G0tensor(551)])
  call ol_merge_tensors(T0sum(112),[G0tensor(556)])
  call ol_merge_tensors(T0sum(113),[G0tensor(561)])
  call ol_merge_tensors(T0sum(114),[G0tensor(566)])
  call ol_merge_tensors(T0sum(115),[G0tensor(571)])
  call ol_merge_tensors(T0sum(116),[G0tensor(576)])
  call ol_merge_tensors(T0sum(117),[G0tensor(581)])
  call ol_merge_tensors(T0sum(118),[G0tensor(586)])
  call ol_merge_tensors(T0sum(119),[G0tensor(591)])
  call ol_merge_tensors(T0sum(120),[G0tensor(596)])
  call ol_merge_tensors(T0sum(121),[G0tensor(601)])
  call ol_merge_tensors(T0sum(122),[G0tensor(606)])
  call ol_merge_tensors(T0sum(123),[G0tensor(611)])
  call ol_merge_tensors(T0sum(124),[G0tensor(616)])
  call ol_merge_tensors(T0sum(125),[G0tensor(621)])
  call ol_merge_tensors(T0sum(126),[G0tensor(626)])
  call ol_merge_tensors(T0sum(127),[G0tensor(631)])
  call ol_merge_tensors(T0sum(128),[G0tensor(636)])
  call ol_merge_tensors(T0sum(129),[G0tensor(641)])
  call ol_merge_tensors(T0sum(130),[G0tensor(646)])
  call ol_merge_tensors(T0sum(131),[G0tensor(651)])
  call ol_merge_tensors(T0sum(132),[G0tensor(656)])
  call ol_merge_tensors(T0sum(133),[G0tensor(661)])
  call ol_merge_tensors(T0sum(134),[G0tensor(666)])
  call ol_merge_tensors(T0sum(135),[G0tensor(671)])
  call ol_merge_tensors(T0sum(136),[G0tensor(676)])
  call ol_merge_tensors(T0sum(137),[G0tensor(681)])
  call ol_merge_tensors(T0sum(138),[G0tensor(686)])
  call ol_merge_tensors(T0sum(139),[G0tensor(691)])
  call ol_merge_tensors(T0sum(140),[G0tensor(696)])
  call ol_merge_tensors(T0sum(141),[G0tensor(701)])
  call ol_merge_tensors(T0sum(142),[G0tensor(706)])
  call ol_merge_tensors(T0sum(143),[G0tensor(711)])
  call ol_merge_tensors(T0sum(144),[G0tensor(716)])
  call ol_merge_tensors(T0sum(145),[G0tensor(721)])
  call ol_merge_tensors(T0sum(146),[G0tensor(726)])
  call ol_merge_tensors(T0sum(147),[G0tensor(731)])
  call ol_merge_tensors(T0sum(148),[G0tensor(736)])
  call ol_merge_tensors(T0sum(149),[G0tensor(741)])
  call ol_merge_tensors(T0sum(150),[G0tensor(746)])
  call ol_merge_tensors(T0sum(151),[G0tensor(751)])
  call ol_merge_tensors(T0sum(152),[G0tensor(756)])
  call ol_merge_tensors(T0sum(153),[G0tensor(761)])
  call ol_merge_tensors(T0sum(154),[G0tensor(766)])
  call ol_merge_tensors(T0sum(155),[G0tensor(771)])
  call ol_merge_tensors(T0sum(156),[G0tensor(776)])
  call ol_merge_tensors(T0sum(157),[G0tensor(781)])
  call ol_merge_tensors(T0sum(158),[G0tensor(786)])
  call ol_merge_tensors(T0sum(159),[G0tensor(791)])
  call ol_merge_tensors(T0sum(160),[G0tensor(796)])
  call ol_merge_tensors(T0sum(161),[G0tensor(801)])
  call ol_merge_tensors(T0sum(162),[G0tensor(806)])
  call ol_merge_tensors(T0sum(163),[G0tensor(811)])
  call ol_merge_tensors(T0sum(164),[G0tensor(816)])
  call ol_merge_tensors(T0sum(165),[G0tensor(821)])
  call ol_merge_tensors(T0sum(166),[G0tensor(826)])
  call ol_merge_tensors(T0sum(167),[G0tensor(831)])
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(102),h0tab(:,102),[36,11,16],[0,nMZ,nMZ],3,2,wf4(:,3),wf8(:,22))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(11),ngZu,m3h4x8(:,43),heltab2x32(:,:,102))
  call Hloop_A_Q(ntryL,G0H8(11),36,0,G1H8(17),n2h8(25))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(55)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(103),h0tab(:,103),[36,11,16],[0,nMW,nMW],3,2,wf4(:,3),wf8(:,22))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(2),m3h4x8(:,44),heltab2x32(:,:,103))
  call Hloop_A_Q(ntryL,G0H8(2),36,0,G1H8(18),n2h8(26))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(104),h0tab(:,104),[36,8,19],[0,nMW,0],3,2,wf4(:,3),wf4(:,11))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(3),m3h4x8(:,45),heltab2x32(:,:,104))
  call Hloop_A_Q(ntryL,G0H8(3),36,0,G1H8(19),n2h8(27))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(105),h0tab(:,105),[36,8,19],[0,0,nMW],3,2,wf4(:,3),wf4(:,11))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(4),m3h4x8(:,46),heltab2x32(:,:,105))
  call Hloop_A_Q(ntryL,G0H8(4),36,0,G1H8(20),n2h8(28))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(106),h0tab(:,106),[36,8,19],[0,nMW,nMZ],3,2,wf4(:,3),wf4(:,11))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(5),ngZu,m3h4x8(:,47),heltab2x32(:,:,106))
  call Hloop_A_Q(ntryL,G0H8(5),36,0,G1H8(6),n2h8(29))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(107),h0tab(:,107),[36,8,19],[0,nMZ,nMW],3,2,wf4(:,3),wf4(:,11))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(6),m3h4x8(:,48),heltab2x32(:,:,107))
  call Hloop_A_Q(ntryL,G0H8(6),36,0,G1H8(7),n2h8(30))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(108),h0tab(:,108),[36,8,19],[0,0,0],3,2,wf4(:,3),wf4(:,4))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,3),G0H8(8),m3h4x8(:,49),heltab2x32(:,:,108))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(109),h0tab(:,109),[36,8,19],[nMZ,0,0],3,2,wf4(:,3),wf4(:,4))
  call Hloop_QA_Z(ntryL,G0H32(1),wf4(:,3),G0H8(9),ngZu,m3h4x8(:,50),heltab2x32(:,:,109))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(110),h0tab(:,110),[36,8,19],[0,0,0],3,2,wf4(:,3),wf4(:,4))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,3),G0H8(10),m3h4x8(:,51),heltab2x32(:,:,110))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(111),h0tab(:,111),[36,8,19],[0,nMW,0],3,2,wf4(:,3),wf4(:,4))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(1),m3h4x8(:,52),heltab2x32(:,:,111))
  call Hloop_A_Q(ntryL,G0H8(1),36,0,G1H8(8),n2h8(31))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(112),h0tab(:,112),[36,8,19],[0,0,nMW],3,2,wf4(:,3),wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(7),m3h4x8(:,53),heltab2x32(:,:,112))
  call Hloop_A_Q(ntryL,G0H8(7),36,0,G1H8(9),n2h8(32))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(113),h0tab(:,113),[36,8,19],[0,nMW,nMZ],3,2,wf4(:,3),wf4(:,4))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(11),ngZu,m3h4x8(:,54),heltab2x32(:,:,113))
  call Hloop_A_Q(ntryL,G0H8(11),36,0,G1H8(10),n2h8(33))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(114),h0tab(:,114),[36,8,19],[0,nMZ,nMW],3,2,wf4(:,3),wf4(:,4))
  call Hloop_WA_Q(ntryL,G0H32(1),wf4(:,3),G0H8(2),m3h4x8(:,55),heltab2x32(:,:,114))
  call Hloop_A_Q(ntryL,G0H8(2),36,0,G1H8(1),n2h8(34))
  Gcoeff(:)%j = (c(38)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(115),h0tab(:,115),[44,3,16],[0,nMM,nMM],3,2,wf8(:,1),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H32(1),wf8(:,1),G0H4(7),m3h8x4(:,19),heltab2x32(:,:,115))
  call Hloop_A_Q(ntryL,G0H4(7),44,0,G1H4(8),n2h4(29))
  Gcoeff(:)%j = (c(37)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(116),h0tab(:,116),[44,3,16],[0,nML,nML],3,2,wf8(:,1),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H32(1),wf8(:,1),G0H4(1),m3h8x4(:,20),heltab2x32(:,:,116))
  call Hloop_A_Q(ntryL,G0H4(1),44,0,G1H4(9),n2h4(30))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(117),h0tab(:,117),[44,3,16],[nMB,nMT,nMT],3,2,wf8(:,1),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H32(1),wf8(:,1),G0H4(2),m3h8x4(:,21),heltab2x32(:,:,117))
  call Hloop_Q_A(ntryL,G0H4(2),44,nMB,G1H4(12),n2h4(31))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(118),h0tab(:,118),[44,3,16],[nMT,nMB,nMB],3,2,wf8(:,1),wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H32(1),wf8(:,1),G0H4(3),m3h8x4(:,22),heltab2x32(:,:,118))
  call Hloop_A_Q(ntryL,G0H4(3),44,nMT,G1H4(13),n2h4(32))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(119),h0tab(:,119),[44,3,16],[nMW,nMH,nMH],3,2,wf8(:,1),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,1),44,G1H4(14),m3h8x4(:,23),heltab2x32(:,:,119))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(120),h0tab(:,120),[44,3,16],[nMW,nMZ,nMZ],3,2,wf8(:,1),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,1),44,G1H4(17),m3h8x4(:,24),heltab2x32(:,:,120))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(121),h0tab(:,121),[44,3,16],[nMH,nMW,nMW],3,2,wf8(:,1),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,1),44,G1H4(18),m3h8x4(:,25),heltab2x32(:,:,121))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(122),h0tab(:,122),[44,3,16],[nMZ,nMW,nMW],3,2,wf8(:,1),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,1),44,G1H4(19),m3h8x4(:,26),heltab2x32(:,:,122))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(123),h0tab(:,123),[44,3,16],[nMW,nMZ,nMZ],3,2,wf8(:,1),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,1),44,G1H4(2),m3h8x4(:,27),heltab2x32(:,:,123))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(124),h0tab(:,124),[44,3,16],[0,nMW,nMW],3,2,wf8(:,1),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,1),G1H4(3),m3h8x4(:,28),heltab2x32(:,:,124))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(125),h0tab(:,125),[44,3,16],[nMZ,nMW,nMW],3,2,wf8(:,1),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,1),G1H4(4),m3h8x4(:,29),heltab2x32(:,:,125))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(126),h0tab(:,126),[44,3,16],[nMW,nMZ,nMZ],3,2,wf8(:,1),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H32(1),0,wf8(:,1),G1H4(21),m3h8x4(:,30),heltab2x32(:,:,126))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(127),h0tab(:,127),[44,3,16],[0,nMW,nMW],3,2,wf8(:,1),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,1),44,G1H4(22),m3h8x4(:,31),heltab2x32(:,:,127))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(128),h0tab(:,128),[44,3,16],[nMZ,nMW,nMW],3,2,wf8(:,1),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H32(1),0,wf8(:,1),44,G1H4(23),m3h8x4(:,32),heltab2x32(:,:,128))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(129),h0tab(:,129),[44,3,16],[nMW,nMZ,nMZ],3,2,wf8(:,1),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H32(1),0,wf8(:,1),44,G1H4(24),m3h8x4(:,33),heltab2x32(:,:,129))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(130),h0tab(:,130),[44,3,16],[0,nMW,nMW],3,2,wf8(:,1),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,1),44,G1H4(25),m3h8x4(:,34),heltab2x32(:,:,130))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(131),h0tab(:,131),[44,3,16],[nMZ,nMW,nMW],3,2,wf8(:,1),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,1),44,G1H4(26),m3h8x4(:,35),heltab2x32(:,:,131))
  Gcoeff(:)%j = (c(26)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(132),h0tab(:,132),[44,3,16],[0,nMW,nMW],3,2,wf8(:,1),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,1),G0H4(4),m3h8x4(:,36),heltab2x32(:,:,132))
  Gcoeff(:)%j = (c(30)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(133),h0tab(:,133),[44,3,16],[nMZ,nMW,nMW],3,2,wf8(:,1),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,1),G0H4(5),m3h8x4(:,37),heltab2x32(:,:,133))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(134),h0tab(:,134),[44,3,16],[nMW,nMH,nMH],3,2,wf8(:,1),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,1),G0H4(6),m3h8x4(:,38),heltab2x32(:,:,134))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(135),h0tab(:,135),[44,3,16],[nMW,nMZ,nMZ],3,2,wf8(:,1),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,1),G0H4(7),m3h8x4(:,39),heltab2x32(:,:,135))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(136),h0tab(:,136),[44,3,16],[nMH,nMW,nMW],3,2,wf8(:,1),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,1),G0H4(1),m3h8x4(:,40),heltab2x32(:,:,136))
  Gcoeff(:)%j = (-(c(21)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(137),h0tab(:,137),[44,3,16],[nMW,nMZ,nMZ],3,2,wf8(:,1),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H32(1),0,wf8(:,1),44,G1H4(27),m3h8x4(:,41),heltab2x32(:,:,137))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(138),h0tab(:,138),[44,3,16],[nMH,nMW,nMW],3,2,wf8(:,1),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H32(1),0,wf8(:,1),44,G1H4(28),m3h8x4(:,42),heltab2x32(:,:,138))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(139),h0tab(:,139),[44,3,16],[0,nMW,nMW],3,2,wf8(:,1),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,1),44,G1H4(29),m3h8x4(:,43),heltab2x32(:,:,139))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(140),h0tab(:,140),[44,3,16],[nMZ,nMW,nMW],3,2,wf8(:,1),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H32(1),0,wf8(:,1),44,G1H4(30),m3h8x4(:,44),heltab2x32(:,:,140))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(141),h0tab(:,141),[44,3,16],[0,nMW,nMW],3,2,wf8(:,1),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,1),G0H4(2),m3h8x4(:,45),heltab2x32(:,:,141))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(142),h0tab(:,142),[44,3,16],[nMZ,nMW,nMW],3,2,wf8(:,1),wf4(:,1))
  call Hloop_SV_V(ntryL,G0H32(1),wf8(:,1),G0H4(3),m3h8x4(:,46),heltab2x32(:,:,142))
  Gcoeff(:)%j = (c(31)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(143),h0tab(:,143),[44,3,16],[nMW,nMZ,nMZ],3,2,wf8(:,1),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,1),G0H4(8),m3h8x4(:,47),heltab2x32(:,:,143))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(144),h0tab(:,144),[44,3,16],[nMH,nMW,nMW],3,2,wf8(:,1),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H32(1),wf8(:,1),G0H4(9),m3h8x4(:,48),heltab2x32(:,:,144))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(145),h0tab(:,145),[39,8,16],[0,nMZ,nMZ],3,1,wf16(:,2))
  call Hloop_ZA_Q(ntryL,G0H32(1),wf16(:,2),G0H2(5),ngZd,m3h16x2(:,1),heltab2x32(:,:,145))
  call Hloop_A_Q(ntryL,G0H2(5),39,0,G1H2(42),n2h2(24))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(33)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(146),h0tab(:,146),[39,8,16],[0,nMW,nMW],3,1,wf16(:,2))
  call Hloop_WA_Q(ntryL,G0H32(1),wf16(:,2),G0H2(1),m3h16x2(:,2),heltab2x32(:,:,146))
  call Hloop_A_Q(ntryL,G0H2(1),39,0,G1H2(31),n2h2(25))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(147),h0tab(:,147),[40,7,16],[0,nMZ,nMZ],3,2,wf4(:,6),wf8(:,4))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,6),G0H8(3),ngZd,m3h4x8(:,56),heltab2x32(:,:,147))
  call Hloop_Q_A(ntryL,G0H8(3),40,0,G1H8(2),n2h8(35))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(56)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(148),h0tab(:,148),[40,7,16],[0,nMW,nMW],3,2,wf4(:,6),wf8(:,4))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,6),G0H8(4),m3h4x8(:,57),heltab2x32(:,:,148))
  call Hloop_Q_A(ntryL,G0H8(4),40,0,G1H8(3),n2h8(36))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(149),h0tab(:,149),[40,4,19],[0,0,nMW],3,2,wf4(:,6),wf4(:,11))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,6),G0H8(5),m3h4x8(:,58),heltab2x32(:,:,149))
  call Hloop_Q_A(ntryL,G0H8(5),40,0,G1H8(4),n2h8(37))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(150),h0tab(:,150),[40,4,19],[0,nMW,0],3,2,wf4(:,6),wf4(:,11))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,6),G0H8(6),m3h4x8(:,59),heltab2x32(:,:,150))
  call Hloop_Q_A(ntryL,G0H8(6),40,0,G1H8(13),n2h8(38))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(151),h0tab(:,151),[40,4,19],[0,nMZ,nMW],3,2,wf4(:,6),wf4(:,11))
  call Hloop_WQ_A(ntryL,G0H32(1),wf4(:,6),G0H8(1),m3h4x8(:,60),heltab2x32(:,:,151))
  call Hloop_Q_A(ntryL,G0H8(1),40,0,G1H8(14),n2h8(39))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(152),h0tab(:,152),[40,4,19],[0,nMW,nMZ],3,2,wf4(:,6),wf4(:,11))
  call Hloop_ZQ_A(ntryL,G0H32(1),wf4(:,6),G0H8(7),ngZd,m3h4x8(:,61),heltab2x32(:,:,152))
  call Hloop_Q_A(ntryL,G0H8(7),40,0,G1H8(5),n2h8(40))



end subroutine vamp_1

end module ol_vamp_1_pphllj_ew_neexuxdhg_1_/**/REALKIND
