
module ol_vamp_1_pphllj_nenexddxhg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphllj_nenexddxhg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphllj_nenexddxhg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pphllj_nenexddxhg_1_/**/DREALKIND
  use ol_tensor_sum_storage_pphllj_nenexddxhg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_pphllj_nenexddxhg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pphllj_nenexddxhg_1_/**/DREALKIND, only: ntryL, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(32)
  type(Hpolcont), intent(in) :: M(1,32)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(35)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,8),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(1),n2h16(1))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(35)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,8),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(2),n2h16(2))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(35)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,8),wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(3),n2h16(3))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(35)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,8),wf4(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(4),n2h16(4))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(35)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,4),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(5),n2h16(5))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(35)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,4),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(6),n2h16(6))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(35)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,4),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,7),heltab2x32(:,:,7))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(7),n2h16(7))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(35)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,4),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(8),n2h16(8))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(35)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,4),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(9),n2h16(9))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(35)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,4),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(10),n2h16(10))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(35)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,4),wf4(:,8))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(11),n2h16(11))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(35)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,4),wf4(:,8))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(12),n2h16(12))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(11)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[32,4,8,19],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(13),n2h16(13))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(11)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[32,8,4,19],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(14),n2h16(14))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(11)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[32,4,19,8],[0,0,0,0],4,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(15),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_AV_Q(ntryL,G1H16(1),wf4(:,8),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H4(1),44,nMT,G2H4(1),n2h4(1))
  call Hloop_QV_A(ntryL,G1H16(2),wf4(:,8),G1H4(1),m3h4x4(:,2),heltab2x16(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),44,nMT,G2H4(2),n2h4(2))
  call Hloop_AV_Q(ntryL,G1H16(3),wf4(:,8),G1H4(1),m3h4x4(:,3),heltab2x16(:,:,3))
  call Hloop_A_Q(ntryL,G1H4(1),44,nMB,G2H4(3),n2h4(3))
  call Hloop_QV_A(ntryL,G1H16(4),wf4(:,8),G1H4(1),m3h4x4(:,4),heltab2x16(:,:,4))
  call Hloop_Q_A(ntryL,G1H4(1),44,nMB,G2H4(4),n2h4(4))
  call Hloop_AZ_Q(ntryL,G1H16(5),wf4(:,4),G1H4(1),ngZu,m3h4x4(:,5),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMT,G2H4(5),n2h4(5))
  call Hloop_QZ_A(ntryL,G1H16(6),wf4(:,4),G1H4(1),ngZu,m3h4x4(:,6),heltab2x16(:,:,6))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMT,G2H4(6),n2h4(6))
  call Hloop_AZ_Q(ntryL,G1H16(7),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,7),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMB,G2H4(7),n2h4(7))
  call Hloop_QZ_A(ntryL,G1H16(8),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,8),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMB,G2H4(8),n2h4(8))
  call Hloop_QZ_A(ntryL,G1H16(9),wf4(:,4),G1H4(1),ngZu,m3h4x4(:,9),heltab2x16(:,:,9))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMT,G2H4(9),n2h4(9))
  call Hloop_AZ_Q(ntryL,G1H16(10),wf4(:,4),G1H4(1),ngZu,m3h4x4(:,10),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMT,G2H4(10),n2h4(10))
  call Hloop_QZ_A(ntryL,G1H16(11),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,11),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMB,G2H4(11),n2h4(11))
  call Hloop_AZ_Q(ntryL,G1H16(12),wf4(:,4),G1H4(1),ngZd,m3h4x4(:,12),heltab2x16(:,:,12))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMB,G2H4(12),n2h4(12))
  call Hloop_AQ_V(ntryL,G1H16(13),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,13))
  call Hloop_QA_V(ntryL,G1H16(14),ex4(:),G1H8(2),m3h2x8(:,2),heltab2x16(:,:,14))
  call Hloop_VQ_A(ntryL,G1H16(15),ex3(:),G1H8(3),m3h2x8(:,3),heltab2x16(:,:,15))
  call Hloop_Q_A(ntryL,G1H8(3),36,0,G2H8(1),n2h8(1))
call Hotf_4pt_reduction(G2H4(1),RedSet_4(1),mass4set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G0H4(1),4)
call HG1shiftOLR(G1H4(2),16,4)
call Hotf_4pt_reduction(G2H4(2),RedSet_4(1),mass4set(:,1),  & 
G1H4(6),G1H4(7),G1H4(8),G1H4(9),G1H4(10),G0H4(2),4)
call HG1shiftOLR(G1H4(7),16,4)
call Hotf_4pt_reduction(G2H4(3),RedSet_4(1),mass4set(:,2),  & 
G1H4(11),G1H4(12),G1H4(13),G1H4(14),G1H4(15),G0H4(3),4)
call HG1shiftOLR(G1H4(12),16,4)
call Hotf_4pt_reduction(G2H4(4),RedSet_4(1),mass4set(:,2),  & 
G1H4(16),G1H4(17),G1H4(18),G1H4(19),G1H4(20),G0H4(4),4)
call HG1shiftOLR(G1H4(17),16,4)
call Hotf_4pt_reduction(G2H4(5),RedSet_4(2),mass4set(:,1),  & 
G1H4(21),G1H4(22),G1H4(23),G1H4(24),G1H4(25),G0H4(5),4)
call HG1shiftOLR(G1H4(22),16,4)
call Hotf_4pt_reduction(G2H4(6),RedSet_4(2),mass4set(:,1),  & 
G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),G0H4(6),4)
call HG1shiftOLR(G1H4(27),16,4)
call Hotf_4pt_reduction(G2H4(7),RedSet_4(2),mass4set(:,2),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G0H4(7),4)
call HG1shiftOLR(G1H4(32),16,4)
call Hotf_4pt_reduction(G2H4(8),RedSet_4(2),mass4set(:,2),  & 
G1H4(36),G1H4(37),G1H4(38),G1H4(39),G1H4(40),G0H4(8),4)
call HG1shiftOLR(G1H4(37),16,4)
call Hotf_4pt_reduction(G2H4(9),RedSet_4(3),mass4set(:,1),  & 
G1H4(41),G1H4(42),G1H4(43),G1H4(44),G1H4(45),G0H4(9),4)
call HG1shiftOLR(G1H4(42),12,4)
call Hotf_4pt_reduction(G2H4(10),RedSet_4(3),mass4set(:,1),  & 
G1H4(46),G1H4(47),G1H4(48),G1H4(49),G1H4(50),G0H4(10),4)
call HG1shiftOLR(G1H4(47),12,4)
call Hotf_4pt_reduction(G2H4(11),RedSet_4(3),mass4set(:,2),  & 
G1H4(51),G1H4(52),G1H4(53),G1H4(54),G1H4(55),G0H4(11),4)
call HG1shiftOLR(G1H4(52),12,4)
call Hotf_4pt_reduction(G2H4(12),RedSet_4(3),mass4set(:,2),  & 
G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),G0H4(12),4)
call HG1shiftOLR(G1H4(57),12,4)
  call Hloop_VA_Q(ntryL,G1H8(1),ex4(:),G1H4(61),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_A_Q(ntryL,G1H4(61),44,0,G2H4(1),n2h4(13))
  call Hloop_VQ_A(ntryL,G1H8(2),ex3(:),G1H4(61),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(61),44,0,G2H4(2),n2h4(14))
call Hotf_4pt_reduction(G2H8(1),RedSet_4(4),mass4set(:,3),  & 
G1H8(3),G1H8(1),G1H8(2),G1H8(4),G1H8(5),8)
call HG1shiftOLR(G1H8(1),8,8)
  call Hloop_AZ_Q(ntryL,G1H4(1),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,1),heltab2x4(:,:,1))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMT,G2H1(1),n2h1(1))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(2),-16,nMT,G2H4(3),n2h4(15))
  call Hloop_QS_A(ntryL,G2H4(3),ex5(:),G2H4(4),ngH,m3h1x4(:,1),heltab2x4(:,:,2))
  call Hloop_AZ_Q(ntryL,G1H4(4),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,2),heltab2x4(:,:,3))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMT,G2H1(2),n2h1(2))
  call Hloop_AZ_Q(ntryL,G1H4(5),wf4(:,4),G1H1(1),ngZu,m3h4x1(:,3),heltab2x4(:,:,4))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMT,G2H1(3),n2h1(3))
  call Hloop_AZ_Q(ntryL,G0H4(1),wf4(:,4),G0H1(1),ngZu,m3h4x1(:,4),heltab2x4(:,:,5))
  call Hloop_A_Q(ntryL,G0H1(1),47,nMT,G1H1(1),n2h1(4))
  call Hloop_QZ_A(ntryL,G1H4(6),wf4(:,4),G1H1(2),ngZu,m3h4x1(:,5),heltab2x4(:,:,6))
  call Hloop_Q_A(ntryL,G1H1(2),47,nMT,G2H1(4),n2h1(5))
call HGT_OLR(G1H4(7),1,1,4)
call HGT_invQ_OLR(G1H4(7),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(7),-16,nMT,G2H4(5),n2h4(16))
  call Hloop_AS_Q(ntryL,G2H4(5),ex5(:),G2H4(6),ngH,m3h1x4(:,2),heltab2x4(:,:,7))
  call Hloop_QZ_A(ntryL,G1H4(9),wf4(:,4),G1H1(2),ngZu,m3h4x1(:,6),heltab2x4(:,:,8))
  call Hloop_Q_A(ntryL,G1H1(2),47,nMT,G2H1(5),n2h1(6))
  call Hloop_QZ_A(ntryL,G1H4(10),wf4(:,4),G1H1(2),ngZu,m3h4x1(:,7),heltab2x4(:,:,9))
  call Hloop_Q_A(ntryL,G1H1(2),47,nMT,G2H1(6),n2h1(7))
  call Hloop_QZ_A(ntryL,G0H4(2),wf4(:,4),G0H1(1),ngZu,m3h4x1(:,8),heltab2x4(:,:,10))
  call Hloop_Q_A(ntryL,G0H1(1),47,nMT,G1H1(2),n2h1(8))
  call Hloop_AZ_Q(ntryL,G1H4(11),wf4(:,4),G1H1(3),ngZd,m3h4x1(:,9),heltab2x4(:,:,11))
  call Hloop_A_Q(ntryL,G1H1(3),47,nMB,G2H1(7),n2h1(9))
call HGT_OLR(G1H4(12),1,1,4)
call HGT_invQ_OLR(G1H4(12),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(12),-16,nMB,G2H4(7),n2h4(17))
  call Hloop_QS_A(ntryL,G2H4(7),ex5(:),G2H4(8),ngH,m3h1x4(:,3),heltab2x4(:,:,12))
  call Hloop_AZ_Q(ntryL,G1H4(14),wf4(:,4),G1H1(3),ngZd,m3h4x1(:,10),heltab2x4(:,:,13))
  call Hloop_A_Q(ntryL,G1H1(3),47,nMB,G2H1(8),n2h1(10))
  call Hloop_AZ_Q(ntryL,G1H4(15),wf4(:,4),G1H1(3),ngZd,m3h4x1(:,11),heltab2x4(:,:,14))
  call Hloop_A_Q(ntryL,G1H1(3),47,nMB,G2H1(9),n2h1(11))
  call Hloop_AZ_Q(ntryL,G0H4(3),wf4(:,4),G0H1(1),ngZd,m3h4x1(:,12),heltab2x4(:,:,15))
  call Hloop_A_Q(ntryL,G0H1(1),47,nMB,G1H1(3),n2h1(12))
  call Hloop_QZ_A(ntryL,G1H4(16),wf4(:,4),G1H1(4),ngZd,m3h4x1(:,13),heltab2x4(:,:,16))
  call Hloop_Q_A(ntryL,G1H1(4),47,nMB,G2H1(10),n2h1(13))
call HGT_OLR(G1H4(17),1,1,4)
call HGT_invQ_OLR(G1H4(17),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(17),-16,nMB,G2H4(9),n2h4(18))
  call Hloop_AS_Q(ntryL,G2H4(9),ex5(:),G2H4(10),ngH,m3h1x4(:,4),heltab2x4(:,:,17))
  call Hloop_QZ_A(ntryL,G1H4(19),wf4(:,4),G1H1(4),ngZd,m3h4x1(:,14),heltab2x4(:,:,18))
  call Hloop_Q_A(ntryL,G1H1(4),47,nMB,G2H1(11),n2h1(14))
  call Hloop_QZ_A(ntryL,G1H4(20),wf4(:,4),G1H1(4),ngZd,m3h4x1(:,15),heltab2x4(:,:,19))
  call Hloop_Q_A(ntryL,G1H1(4),47,nMB,G2H1(12),n2h1(15))
  call Hloop_QZ_A(ntryL,G0H4(4),wf4(:,4),G0H1(1),ngZd,m3h4x1(:,16),heltab2x4(:,:,20))
  call Hloop_Q_A(ntryL,G0H1(1),47,nMB,G1H1(4),n2h1(16))
  call Hloop_AV_Q(ntryL,G1H4(21),wf4(:,8),G1H1(5),m3h4x1(:,17),heltab2x4(:,:,21))
  call Hloop_A_Q(ntryL,G1H1(5),47,nMT,G2H1(13),n2h1(17))
call HGT_OLR(G1H4(22),1,1,4)
call HGT_invQ_OLR(G1H4(22),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(22),-16,nMT,G2H4(11),n2h4(19))
  call Hloop_QS_A(ntryL,G2H4(11),ex5(:),G2H4(12),ngH,m3h1x4(:,5),heltab2x4(:,:,22))
  call Hloop_AV_Q(ntryL,G1H4(24),wf4(:,8),G1H1(5),m3h4x1(:,18),heltab2x4(:,:,23))
  call Hloop_A_Q(ntryL,G1H1(5),47,nMT,G2H1(14),n2h1(18))
  call Hloop_AV_Q(ntryL,G1H4(25),wf4(:,8),G1H1(5),m3h4x1(:,19),heltab2x4(:,:,24))
  call Hloop_A_Q(ntryL,G1H1(5),47,nMT,G2H1(15),n2h1(19))
  call Hloop_AV_Q(ntryL,G0H4(5),wf4(:,8),G0H1(1),m3h4x1(:,20),heltab2x4(:,:,25))
  call Hloop_A_Q(ntryL,G0H1(1),47,nMT,G1H1(5),n2h1(20))
  call Hloop_QV_A(ntryL,G1H4(26),wf4(:,8),G1H1(6),m3h4x1(:,21),heltab2x4(:,:,26))
  call Hloop_Q_A(ntryL,G1H1(6),47,nMT,G2H1(16),n2h1(21))
call HGT_OLR(G1H4(27),1,1,4)
call HGT_invQ_OLR(G1H4(27),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(27),-16,nMT,G2H4(3),n2h4(20))
  call Hloop_AS_Q(ntryL,G2H4(3),ex5(:),G2H4(5),ngH,m3h1x4(:,6),heltab2x4(:,:,27))
  call Hloop_QV_A(ntryL,G1H4(29),wf4(:,8),G1H1(6),m3h4x1(:,22),heltab2x4(:,:,28))
  call Hloop_Q_A(ntryL,G1H1(6),47,nMT,G2H1(17),n2h1(22))
  call Hloop_QV_A(ntryL,G1H4(30),wf4(:,8),G1H1(6),m3h4x1(:,23),heltab2x4(:,:,29))
  call Hloop_Q_A(ntryL,G1H1(6),47,nMT,G2H1(18),n2h1(23))
  call Hloop_QV_A(ntryL,G0H4(6),wf4(:,8),G0H1(1),m3h4x1(:,24),heltab2x4(:,:,30))
  call Hloop_Q_A(ntryL,G0H1(1),47,nMT,G1H1(6),n2h1(24))
  call Hloop_AV_Q(ntryL,G1H4(31),wf4(:,8),G1H1(7),m3h4x1(:,25),heltab2x4(:,:,31))
  call Hloop_A_Q(ntryL,G1H1(7),47,nMB,G2H1(19),n2h1(25))
call HGT_OLR(G1H4(32),1,1,4)
call HGT_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(32),-16,nMB,G2H4(7),n2h4(21))
  call Hloop_QS_A(ntryL,G2H4(7),ex5(:),G2H4(9),ngH,m3h1x4(:,7),heltab2x4(:,:,32))
  call Hloop_AV_Q(ntryL,G1H4(34),wf4(:,8),G1H1(7),m3h4x1(:,26),heltab2x4(:,:,33))
  call Hloop_A_Q(ntryL,G1H1(7),47,nMB,G2H1(20),n2h1(26))
  call Hloop_AV_Q(ntryL,G1H4(35),wf4(:,8),G1H1(7),m3h4x1(:,27),heltab2x4(:,:,34))
  call Hloop_A_Q(ntryL,G1H1(7),47,nMB,G2H1(21),n2h1(27))
  call Hloop_AV_Q(ntryL,G0H4(7),wf4(:,8),G0H1(1),m3h4x1(:,28),heltab2x4(:,:,35))
  call Hloop_A_Q(ntryL,G0H1(1),47,nMB,G1H1(7),n2h1(28))
  call Hloop_QV_A(ntryL,G1H4(36),wf4(:,8),G1H1(8),m3h4x1(:,29),heltab2x4(:,:,36))
  call Hloop_Q_A(ntryL,G1H1(8),47,nMB,G2H1(22),n2h1(29))
call HGT_OLR(G1H4(37),1,1,4)
call HGT_invQ_OLR(G1H4(37),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(37),-16,nMB,G2H4(11),n2h4(22))
  call Hloop_AS_Q(ntryL,G2H4(11),ex5(:),G2H4(3),ngH,m3h1x4(:,8),heltab2x4(:,:,37))
  call Hloop_QV_A(ntryL,G1H4(39),wf4(:,8),G1H1(8),m3h4x1(:,30),heltab2x4(:,:,38))
  call Hloop_Q_A(ntryL,G1H1(8),47,nMB,G2H1(23),n2h1(30))
  call Hloop_QV_A(ntryL,G1H4(40),wf4(:,8),G1H1(8),m3h4x1(:,31),heltab2x4(:,:,39))
  call Hloop_Q_A(ntryL,G1H1(8),47,nMB,G2H1(24),n2h1(31))
  call Hloop_QV_A(ntryL,G0H4(8),wf4(:,8),G0H1(1),m3h4x1(:,32),heltab2x4(:,:,40))
  call Hloop_Q_A(ntryL,G0H1(1),47,nMB,G1H1(8),n2h1(32))
  call Hloop_QS_A(ntryL,G1H4(41),ex5(:),G1H4(61),ngH,m3h1x4(:,9),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H4(61),51,nMT,G2H4(7),n2h4(23))
call HGT_OLR(G1H4(42),1,1,4)
call HGT_invQ_OLR(G1H4(42),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(42),-12,nMT,G2H4(11),n2h4(24))
  call Hloop_AV_Q(ntryL,G2H4(11),wf4(:,8),G2H1(25),m3h4x1(:,33),heltab2x4(:,:,42))
  call Hloop_QS_A(ntryL,G1H4(44),ex5(:),G1H4(1),ngH,m3h1x4(:,10),heltab2x4(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(11),n2h4(25))
  call Hloop_QS_A(ntryL,G1H4(45),ex5(:),G1H4(2),ngH,m3h1x4(:,11),heltab2x4(:,:,44))
  call Hloop_Q_A(ntryL,G1H4(2),51,nMT,G2H4(13),n2h4(26))
  call Hloop_QS_A(ntryL,G0H4(9),ex5(:),G0H4(1),ngH,m3h1x4(:,12),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G0H4(1),51,nMT,G1H4(4),n2h4(27))
  call Hloop_AS_Q(ntryL,G1H4(46),ex5(:),G1H4(5),ngH,m3h1x4(:,13),heltab2x4(:,:,46))
  call Hloop_A_Q(ntryL,G1H4(5),51,nMT,G2H4(14),n2h4(28))
call HGT_OLR(G1H4(47),1,1,4)
call HGT_invQ_OLR(G1H4(47),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(47),-12,nMT,G2H4(15),n2h4(29))
  call Hloop_QV_A(ntryL,G2H4(15),wf4(:,8),G2H1(26),m3h4x1(:,34),heltab2x4(:,:,47))
  call Hloop_AS_Q(ntryL,G1H4(49),ex5(:),G1H4(6),ngH,m3h1x4(:,14),heltab2x4(:,:,48))
  call Hloop_A_Q(ntryL,G1H4(6),51,nMT,G2H4(15),n2h4(30))
  call Hloop_AS_Q(ntryL,G1H4(50),ex5(:),G1H4(7),ngH,m3h1x4(:,15),heltab2x4(:,:,49))
  call Hloop_A_Q(ntryL,G1H4(7),51,nMT,G2H4(16),n2h4(31))
  call Hloop_AS_Q(ntryL,G0H4(10),ex5(:),G0H4(2),ngH,m3h1x4(:,16),heltab2x4(:,:,50))
  call Hloop_A_Q(ntryL,G0H4(2),51,nMT,G1H4(9),n2h4(32))
  call Hloop_QS_A(ntryL,G1H4(51),ex5(:),G1H4(10),ngH,m3h1x4(:,17),heltab2x4(:,:,51))
  call Hloop_Q_A(ntryL,G1H4(10),51,nMB,G2H4(17),n2h4(33))
call HGT_OLR(G1H4(52),1,1,4)
call HGT_invQ_OLR(G1H4(52),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(52),-12,nMB,G2H4(18),n2h4(34))
  call Hloop_AV_Q(ntryL,G2H4(18),wf4(:,8),G2H1(27),m3h4x1(:,35),heltab2x4(:,:,52))
  call Hloop_QS_A(ntryL,G1H4(54),ex5(:),G1H4(11),ngH,m3h1x4(:,18),heltab2x4(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(11),51,nMB,G2H4(18),n2h4(35))
  call Hloop_QS_A(ntryL,G1H4(55),ex5(:),G1H4(12),ngH,m3h1x4(:,19),heltab2x4(:,:,54))
  call Hloop_Q_A(ntryL,G1H4(12),51,nMB,G2H4(19),n2h4(36))
  call Hloop_QS_A(ntryL,G0H4(11),ex5(:),G0H4(3),ngH,m3h1x4(:,20),heltab2x4(:,:,55))
  call Hloop_Q_A(ntryL,G0H4(3),51,nMB,G1H4(14),n2h4(37))
  call Hloop_AS_Q(ntryL,G1H4(56),ex5(:),G1H4(15),ngH,m3h1x4(:,21),heltab2x4(:,:,56))
  call Hloop_A_Q(ntryL,G1H4(15),51,nMB,G2H4(20),n2h4(38))
call HGT_OLR(G1H4(57),1,1,4)
call HGT_invQ_OLR(G1H4(57),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(57),-12,nMB,G2H4(21),n2h4(39))
  call Hloop_QV_A(ntryL,G2H4(21),wf4(:,8),G2H1(28),m3h4x1(:,36),heltab2x4(:,:,57))
  call Hloop_AS_Q(ntryL,G1H4(59),ex5(:),G1H4(16),ngH,m3h1x4(:,22),heltab2x4(:,:,58))
  call Hloop_A_Q(ntryL,G1H4(16),51,nMB,G2H4(21),n2h4(40))
  call Hloop_AS_Q(ntryL,G1H4(60),ex5(:),G1H4(17),ngH,m3h1x4(:,23),heltab2x4(:,:,59))
  call Hloop_A_Q(ntryL,G1H4(17),51,nMB,G2H4(22),n2h4(41))
  call Hloop_AS_Q(ntryL,G0H4(12),ex5(:),G0H4(4),ngH,m3h1x4(:,24),heltab2x4(:,:,60))
  call Hloop_A_Q(ntryL,G0H4(4),51,nMB,G1H4(19),n2h4(42))
  call Hloop_QZ_A(ntryL,G1H8(3),wf4(:,9),G1H2(1),ngZd,m3h4x2(:,1),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(1),n2h2(1))
call HGT_raise_alpha_OLR(G1H8(1),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(1),ex4(:),G1H4(20),m3h2x4(:,3),heltab2x8(:,:,4))
  call Hloop_QZ_A(ntryL,G1H8(4),wf4(:,9),G1H2(1),ngZd,m3h4x2(:,2),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(2),n2h2(2))
  call Hloop_QZ_A(ntryL,G1H8(5),wf4(:,9),G1H2(1),ngZd,m3h4x2(:,3),heltab2x8(:,:,6))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(3),n2h2(3))
call Hotf_4pt_reduction(G2H4(1),RedSet_4(5),mass4set(:,3),  & 
G1H4(21),G1H4(22),G1H4(24),G1H4(25),G1H4(26),4)
call HG1shiftOLR(G1H4(22),19,4)
call Hotf_4pt_reduction(G2H4(2),RedSet_4(6),mass4set(:,3),  & 
G1H4(27),G1H4(29),G1H4(30),G1H4(31),G1H4(32),4)
call HG1shiftOLR(G1H4(29),19,4)
call Hotf_4pt_reduction(G2H1(1),RedSet_4(1),mass4set(:,1),  & 
G1H1(9),G1H1(10),G1H1(11),G1H1(12),G1H1(13),1)
call HG1shiftOLR(G1H1(10),16,1)
  call Hloop_AS_Q(ntryL,G2H1(3),ex5(:),G2H1(1),ngH,m3h1x1(:,1),heltab2x1(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(1),n2h1(33))
  call Hloop_AS_Q(ntryL,G1H1(1),ex5(:),G1H1(14),ngH,m3h1x1(:,2),heltab2x1(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(14),63,nMT,G2tensor(1),n2h1(34))
call Hotf_4pt_reduction(G2H1(4),RedSet_4(1),mass4set(:,1),  & 
G1H1(1),G1H1(14),G1H1(15),G1H1(16),G1H1(17),1)
call HG1shiftOLR(G1H1(14),16,1)
  call Hloop_QS_A(ntryL,G2H1(6),ex5(:),G2H1(3),ngH,m3h1x1(:,3),heltab2x1(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(3),63,nMT,G3tensor(2),n2h1(35))
  call Hloop_QS_A(ntryL,G1H1(2),ex5(:),G1H1(18),ngH,m3h1x1(:,4),heltab2x1(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(18),63,nMT,G2tensor(2),n2h1(36))
call Hotf_4pt_reduction(G2H1(7),RedSet_4(1),mass4set(:,2),  & 
G1H1(2),G1H1(18),G1H1(19),G1H1(20),G1H1(21),1)
call HG1shiftOLR(G1H1(18),16,1)
  call Hloop_AS_Q(ntryL,G2H1(9),ex5(:),G2H1(1),ngH,m3h1x1(:,5),heltab2x1(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(3),n2h1(37))
  call Hloop_AS_Q(ntryL,G1H1(3),ex5(:),G1H1(22),ngH,m3h1x1(:,6),heltab2x1(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(22),63,nMB,G2tensor(3),n2h1(38))
call Hotf_4pt_reduction(G2H1(10),RedSet_4(1),mass4set(:,2),  & 
G1H1(3),G1H1(22),G1H1(23),G1H1(24),G1H1(25),1)
call HG1shiftOLR(G1H1(22),16,1)
  call Hloop_QS_A(ntryL,G2H1(12),ex5(:),G2H1(4),ngH,m3h1x1(:,7),heltab2x1(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(4),63,nMB,G3tensor(4),n2h1(39))
  call Hloop_QS_A(ntryL,G1H1(4),ex5(:),G1H1(26),ngH,m3h1x1(:,8),heltab2x1(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(26),63,nMB,G2tensor(4),n2h1(40))
call Hotf_4pt_reduction(G2H1(13),RedSet_4(2),mass4set(:,1),  & 
G1H1(4),G1H1(26),G1H1(27),G1H1(28),G1H1(29),1)
call HG1shiftOLR(G1H1(26),16,1)
  call Hloop_AS_Q(ntryL,G2H1(15),ex5(:),G2H1(6),ngH,m3h1x1(:,9),heltab2x1(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(6),63,nMT,G3tensor(5),n2h1(41))
  call Hloop_AS_Q(ntryL,G1H1(5),ex5(:),G1H1(30),ngH,m3h1x1(:,10),heltab2x1(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(30),63,nMT,G2tensor(5),n2h1(42))
call Hotf_4pt_reduction(G2H1(16),RedSet_4(2),mass4set(:,1),  & 
G1H1(5),G1H1(30),G1H1(31),G1H1(32),G1H1(33),1)
call HG1shiftOLR(G1H1(30),16,1)
  call Hloop_QS_A(ntryL,G2H1(18),ex5(:),G2H1(3),ngH,m3h1x1(:,11),heltab2x1(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(3),63,nMT,G3tensor(6),n2h1(43))
  call Hloop_QS_A(ntryL,G1H1(6),ex5(:),G1H1(34),ngH,m3h1x1(:,12),heltab2x1(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(34),63,nMT,G2tensor(6),n2h1(44))
call Hotf_4pt_reduction(G2H1(19),RedSet_4(2),mass4set(:,2),  & 
G1H1(6),G1H1(34),G1H1(35),G1H1(36),G1H1(37),1)
call HG1shiftOLR(G1H1(34),16,1)
  call Hloop_AS_Q(ntryL,G2H1(21),ex5(:),G2H1(7),ngH,m3h1x1(:,13),heltab2x1(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(7),63,nMB,G3tensor(7),n2h1(45))
  call Hloop_AS_Q(ntryL,G1H1(7),ex5(:),G1H1(38),ngH,m3h1x1(:,14),heltab2x1(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(38),63,nMB,G2tensor(7),n2h1(46))
call Hotf_4pt_reduction(G2H1(22),RedSet_4(2),mass4set(:,2),  & 
G1H1(7),G1H1(38),G1H1(39),G1H1(40),G1H1(41),1)
call HG1shiftOLR(G1H1(38),16,1)
  call Hloop_QS_A(ntryL,G2H1(24),ex5(:),G2H1(9),ngH,m3h1x1(:,15),heltab2x1(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(9),63,nMB,G3tensor(8),n2h1(47))
  call Hloop_QS_A(ntryL,G1H1(8),ex5(:),G1H1(42),ngH,m3h1x1(:,16),heltab2x1(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),63,nMB,G2tensor(8),n2h1(48))
call Hotf_4pt_reduction(G2H4(7),RedSet_4(3),mass4set(:,1),  & 
G1H4(34),G1H4(35),G1H4(36),G1H4(37),G1H4(39),4)
call HG1shiftOLR(G1H4(35),12,4)
  call Hloop_QV_A(ntryL,G2H4(13),wf4(:,8),G2H1(1),m3h4x1(:,37),heltab2x4(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(9),n2h1(49))
  call Hloop_QV_A(ntryL,G1H4(4),wf4(:,8),G1H1(8),m3h4x1(:,38),heltab2x4(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),63,nMT,G2tensor(9),n2h1(50))
call Hotf_4pt_reduction(G2H4(14),RedSet_4(3),mass4set(:,1),  & 
G1H4(40),G1H4(41),G1H4(61),G1H4(42),G1H4(44),4)
call HG1shiftOLR(G1H4(41),12,4)
  call Hloop_AV_Q(ntryL,G2H4(16),wf4(:,8),G2H1(10),m3h4x1(:,39),heltab2x4(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(10),63,nMT,G3tensor(10),n2h1(51))
  call Hloop_AV_Q(ntryL,G1H4(9),wf4(:,8),G1H1(42),m3h4x1(:,40),heltab2x4(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),63,nMT,G2tensor(10),n2h1(52))
call Hotf_4pt_reduction(G2H4(17),RedSet_4(3),mass4set(:,2),  & 
G1H4(1),G1H4(45),G1H4(2),G1H4(46),G1H4(5),4)
call HG1shiftOLR(G1H4(45),12,4)
  call Hloop_QV_A(ntryL,G2H4(19),wf4(:,8),G2H1(12),m3h4x1(:,41),heltab2x4(:,:,65))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(12),63,nMB,G3tensor(11),n2h1(53))
  call Hloop_QV_A(ntryL,G1H4(14),wf4(:,8),G1H1(8),m3h4x1(:,42),heltab2x4(:,:,66))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),63,nMB,G2tensor(11),n2h1(54))
call Hotf_4pt_reduction(G2H4(20),RedSet_4(3),mass4set(:,2),  & 
G1H4(47),G1H4(49),G1H4(6),G1H4(50),G1H4(7),4)
call HG1shiftOLR(G1H4(49),12,4)
  call Hloop_AV_Q(ntryL,G2H4(22),wf4(:,8),G2H1(4),m3h4x1(:,43),heltab2x4(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(4),63,nMB,G3tensor(12),n2h1(55))
  call Hloop_AV_Q(ntryL,G1H4(19),wf4(:,8),G1H1(42),m3h4x1(:,44),heltab2x4(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),63,nMB,G2tensor(12),n2h1(56))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(13),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(3),ex4(:),G2tensor(14),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hloop_AZ_Q(ntryL,G1H4(21),wf4(:,9),G1H1(8),ngZd,m3h4x1(:,45),heltab2x4(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(8),63,0,G2tensor(15),n2h1(57))
  call Hloop_AZ_Q(ntryL,G1H4(22),wf4(:,9),G1H1(42),ngZd,m3h4x1(:,46),heltab2x4(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),19,0,G2tensor(16),n2h1(58))
  call Hloop_AZ_Q(ntryL,G1H4(26),wf4(:,9),G1H1(8),ngZd,m3h4x1(:,47),heltab2x4(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(8),63,0,G2tensor(17),n2h1(59))
  call Hloop_QZ_A(ntryL,G1H4(27),wf4(:,9),G1H1(42),ngZd,m3h4x1(:,48),heltab2x4(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),63,0,G2tensor(18),n2h1(60))
  call Hloop_QZ_A(ntryL,G1H4(29),wf4(:,9),G1H1(8),ngZd,m3h4x1(:,49),heltab2x4(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),19,0,G2tensor(19),n2h1(61))
  call Hloop_QZ_A(ntryL,G1H4(32),wf4(:,9),G1H1(42),ngZd,m3h4x1(:,50),heltab2x4(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),63,0,G2tensor(20),n2h1(62))
  call Hloop_AS_Q(ntryL,G1H1(9),ex5(:),G1H1(8),ngH,m3h1x1(:,17),heltab2x1(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(8),63,nMT,G2tensor(21),n2h1(63))
  call Hloop_AS_Q(ntryL,G1H1(10),ex5(:),G1H1(42),ngH,m3h1x1(:,18),heltab2x1(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),16,nMT,G2tensor(22),n2h1(64))
  call Hloop_AS_Q(ntryL,G1H1(13),ex5(:),G1H1(9),ngH,m3h1x1(:,19),heltab2x1(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),63,nMT,G2tensor(23),n2h1(65))
  call Hloop_QS_A(ntryL,G1H1(1),ex5(:),G1H1(8),ngH,m3h1x1(:,20),heltab2x1(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),63,nMT,G2tensor(24),n2h1(66))
  call Hloop_QS_A(ntryL,G1H1(14),ex5(:),G1H1(10),ngH,m3h1x1(:,21),heltab2x1(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(10),16,nMT,G2tensor(25),n2h1(67))
  call Hloop_QS_A(ntryL,G1H1(17),ex5(:),G1H1(42),ngH,m3h1x1(:,22),heltab2x1(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),63,nMT,G2tensor(26),n2h1(68))
  call Hloop_AS_Q(ntryL,G1H1(2),ex5(:),G1H1(13),ngH,m3h1x1(:,23),heltab2x1(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(13),63,nMB,G2tensor(27),n2h1(69))
  call Hloop_AS_Q(ntryL,G1H1(18),ex5(:),G1H1(9),ngH,m3h1x1(:,24),heltab2x1(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),16,nMB,G2tensor(28),n2h1(70))
  call Hloop_AS_Q(ntryL,G1H1(21),ex5(:),G1H1(1),ngH,m3h1x1(:,25),heltab2x1(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(29),n2h1(71))
  call Hloop_QS_A(ntryL,G1H1(3),ex5(:),G1H1(8),ngH,m3h1x1(:,26),heltab2x1(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),63,nMB,G2tensor(30),n2h1(72))
  call Hloop_QS_A(ntryL,G1H1(22),ex5(:),G1H1(14),ngH,m3h1x1(:,27),heltab2x1(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(14),16,nMB,G2tensor(31),n2h1(73))
  call Hloop_QS_A(ntryL,G1H1(25),ex5(:),G1H1(10),ngH,m3h1x1(:,28),heltab2x1(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(10),63,nMB,G2tensor(32),n2h1(74))
  call Hloop_AS_Q(ntryL,G1H1(4),ex5(:),G1H1(17),ngH,m3h1x1(:,29),heltab2x1(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),63,nMT,G2tensor(33),n2h1(75))
  call Hloop_AS_Q(ntryL,G1H1(26),ex5(:),G1H1(42),ngH,m3h1x1(:,30),heltab2x1(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),16,nMT,G2tensor(34),n2h1(76))
  call Hloop_AS_Q(ntryL,G1H1(29),ex5(:),G1H1(2),ngH,m3h1x1(:,31),heltab2x1(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),63,nMT,G2tensor(35),n2h1(77))
  call Hloop_QS_A(ntryL,G1H1(5),ex5(:),G1H1(13),ngH,m3h1x1(:,32),heltab2x1(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(13),63,nMT,G2tensor(36),n2h1(78))
  call Hloop_QS_A(ntryL,G1H1(30),ex5(:),G1H1(18),ngH,m3h1x1(:,33),heltab2x1(:,:,33))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(18),16,nMT,G2tensor(37),n2h1(79))
  call Hloop_QS_A(ntryL,G1H1(33),ex5(:),G1H1(9),ngH,m3h1x1(:,34),heltab2x1(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),63,nMT,G2tensor(38),n2h1(80))
  call Hloop_AS_Q(ntryL,G1H1(6),ex5(:),G1H1(21),ngH,m3h1x1(:,35),heltab2x1(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(21),63,nMB,G2tensor(39),n2h1(81))
  call Hloop_AS_Q(ntryL,G1H1(34),ex5(:),G1H1(1),ngH,m3h1x1(:,36),heltab2x1(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(40),n2h1(82))
  call Hloop_AS_Q(ntryL,G1H1(37),ex5(:),G1H1(3),ngH,m3h1x1(:,37),heltab2x1(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(3),63,nMB,G2tensor(41),n2h1(83))
  call Hloop_QS_A(ntryL,G1H1(7),ex5(:),G1H1(8),ngH,m3h1x1(:,38),heltab2x1(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(8),63,nMB,G2tensor(42),n2h1(84))
  call Hloop_QS_A(ntryL,G1H1(38),ex5(:),G1H1(22),ngH,m3h1x1(:,39),heltab2x1(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(22),16,nMB,G2tensor(43),n2h1(85))
  call Hloop_QS_A(ntryL,G1H1(41),ex5(:),G1H1(14),ngH,m3h1x1(:,40),heltab2x1(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(14),63,nMB,G2tensor(44),n2h1(86))
  call Hloop_QV_A(ntryL,G1H4(34),wf4(:,8),G1H1(25),m3h4x1(:,51),heltab2x4(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(25),63,nMT,G2tensor(45),n2h1(87))
  call Hloop_QV_A(ntryL,G1H4(35),wf4(:,8),G1H1(10),m3h4x1(:,52),heltab2x4(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(10),12,nMT,G2tensor(46),n2h1(88))
  call Hloop_QV_A(ntryL,G1H4(39),wf4(:,8),G1H1(4),m3h4x1(:,53),heltab2x4(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(4),63,nMT,G2tensor(47),n2h1(89))
  call Hloop_AV_Q(ntryL,G1H4(40),wf4(:,8),G1H1(17),m3h4x1(:,54),heltab2x4(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),63,nMT,G2tensor(48),n2h1(90))
  call Hloop_AV_Q(ntryL,G1H4(41),wf4(:,8),G1H1(26),m3h4x1(:,55),heltab2x4(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(26),12,nMT,G2tensor(49),n2h1(91))
  call Hloop_AV_Q(ntryL,G1H4(44),wf4(:,8),G1H1(42),m3h4x1(:,56),heltab2x4(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),63,nMT,G2tensor(50),n2h1(92))
  call Hloop_QV_A(ntryL,G1H4(1),wf4(:,8),G1H1(29),m3h4x1(:,57),heltab2x4(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(29),63,nMB,G2tensor(51),n2h1(93))
  call Hloop_QV_A(ntryL,G1H4(45),wf4(:,8),G1H1(2),m3h4x1(:,58),heltab2x4(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(2),12,nMB,G2tensor(52),n2h1(94))
  call Hloop_QV_A(ntryL,G1H4(5),wf4(:,8),G1H1(5),m3h4x1(:,59),heltab2x4(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(5),63,nMB,G2tensor(53),n2h1(95))
  call Hloop_AV_Q(ntryL,G1H4(47),wf4(:,8),G1H1(13),m3h4x1(:,60),heltab2x4(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(13),63,nMB,G2tensor(54),n2h1(96))
  call Hloop_AV_Q(ntryL,G1H4(49),wf4(:,8),G1H1(30),m3h4x1(:,61),heltab2x4(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(30),12,nMB,G2tensor(55),n2h1(97))
  call Hloop_AV_Q(ntryL,G1H4(7),wf4(:,8),G1H1(18),m3h4x1(:,62),heltab2x4(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(18),63,nMB,G2tensor(56),n2h1(98))
  call ol_merge_tensors(G2tensor(2),[G2tensor(1)])
  call ol_merge_tensors(G2tensor(4),[G2tensor(3)])
  call ol_merge_tensors(G2tensor(6),[G2tensor(5)])
  call ol_merge_tensors(G2tensor(8),[G2tensor(7)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(9)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(11)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(21)])
  call ol_merge_tensors(G2tensor(30),[G2tensor(27)])
  call ol_merge_tensors(G2tensor(36),[G2tensor(33)])
  call ol_merge_tensors(G2tensor(42),[G2tensor(39)])
  call ol_merge_tensors(G2tensor(48),[G2tensor(45)])
  call ol_merge_tensors(G2tensor(54),[G2tensor(51)])
call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(1),mass4set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G0tensor(1))
call G_TensorShift(G1tensor(2),16)
call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(1),mass4set(:,2),  & 
G1tensor(1),G1tensor(6),G1tensor(7),G1tensor(8),G1tensor(9),G0tensor(2))
call G_TensorShift(G1tensor(6),16)
call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(2),mass4set(:,1),  & 
G1tensor(1),G1tensor(10),G1tensor(11),G1tensor(12),G1tensor(13),G0tensor(3))
call G_TensorShift(G1tensor(10),16)
call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(2),mass4set(:,2),  & 
G1tensor(1),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G0tensor(4))
call G_TensorShift(G1tensor(14),16)
call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(3),mass4set(:,1),  & 
G1tensor(1),G1tensor(18),G1tensor(19),G1tensor(20),G1tensor(21),G0tensor(5))
call G_TensorShift(G1tensor(18),12)
call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(3),mass4set(:,2),  & 
G1tensor(1),G1tensor(22),G1tensor(23),G1tensor(24),G1tensor(25),G0tensor(6))
call G_TensorShift(G1tensor(22),12)
call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(4),mass4set(:,3),  & 
G1tensor(1),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29))
call G_TensorShift(G1tensor(26),8)
call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(5),mass4set(:,3),  & 
G1tensor(30),G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34))
call G_TensorShift(G1tensor(31),19)
call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(6),mass4set(:,3),  & 
G1tensor(35),G1tensor(36),G1tensor(37),G1tensor(38),G1tensor(39))
call G_TensorShift(G1tensor(36),19)
call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(1),mass4set(:,1),  & 
G1tensor(40),G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44))
call G_TensorShift(G1tensor(41),16)
call Hotf_4pt_reduction_last(G2tensor(30),RedSet_4(1),mass4set(:,2),  & 
G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49))
call G_TensorShift(G1tensor(46),16)
call Hotf_4pt_reduction_last(G2tensor(36),RedSet_4(2),mass4set(:,1),  & 
G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
call G_TensorShift(G1tensor(51),16)
call Hotf_4pt_reduction_last(G2tensor(42),RedSet_4(2),mass4set(:,2),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59))
call G_TensorShift(G1tensor(56),16)
call Hotf_4pt_reduction_last(G2tensor(48),RedSet_4(3),mass4set(:,1),  & 
G1tensor(60),G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64))
call G_TensorShift(G1tensor(61),12)
call Hotf_4pt_reduction_last(G2tensor(54),RedSet_4(3),mass4set(:,2),  & 
G1tensor(65),G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69))
call G_TensorShift(G1tensor(66),12)
call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(4),mass4set(:,3),  & 
G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10),G0tensor(11))
call Hotf_4pt_reduction_last(G1tensor(30),RedSet_4(5),mass4set(:,3),  & 
G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15),G0tensor(16))
call Hotf_4pt_reduction_last(G1tensor(35),RedSet_4(6),mass4set(:,3),  & 
G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20),G0tensor(21))
call Hotf_4pt_reduction_last(G1tensor(40),RedSet_4(1),mass4set(:,1),  & 
G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25),G0tensor(26))
call Hotf_4pt_reduction_last(G1tensor(45),RedSet_4(1),mass4set(:,2),  & 
G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30),G0tensor(31))
call Hotf_4pt_reduction_last(G1tensor(50),RedSet_4(2),mass4set(:,1),  & 
G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35),G0tensor(36))
call Hotf_4pt_reduction_last(G1tensor(55),RedSet_4(2),mass4set(:,2),  & 
G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40),G0tensor(41))
call Hotf_4pt_reduction_last(G1tensor(60),RedSet_4(3),mass4set(:,1),  & 
G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45),G0tensor(46))
call Hotf_4pt_reduction_last(G1tensor(65),RedSet_4(3),mass4set(:,2),  & 
G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50),G0tensor(51))
call ol_merge_tensors(T0sum(1),[G0tensor(1)])
call ol_merge_tensors(T0sum(2),[G0tensor(2)])
call ol_merge_tensors(T0sum(3),[G0tensor(3)])
call ol_merge_tensors(T0sum(4),[G0tensor(4)])
call ol_merge_tensors(T0sum(5),[G0tensor(5)])
call ol_merge_tensors(T0sum(6),[G0tensor(6)])
call ol_merge_tensors(T0sum(7),[G0tensor(7)])
call ol_merge_tensors(T0sum(8),[G0tensor(12)])
call ol_merge_tensors(T0sum(9),[G0tensor(17)])
call ol_merge_tensors(T0sum(10),[G0tensor(22)])
call ol_merge_tensors(T0sum(11),[G0tensor(27)])
call ol_merge_tensors(T0sum(12),[G0tensor(32)])
call ol_merge_tensors(T0sum(13),[G0tensor(37)])
call ol_merge_tensors(T0sum(14),[G0tensor(42)])
call ol_merge_tensors(T0sum(15),[G0tensor(47)])
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[32,12,19],[0,0,0],3,2,wf4(:,8),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(1),n2h16(15))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[32,12,19],[nMT,nMT,nMT],3,2,wf4(:,8),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(2),n2h16(16))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[32,12,19],[0,0,0],3,2,wf4(:,8),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(3),n2h16(17))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[32,12,19],[nMT,nMT,nMT],3,2,wf4(:,8),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(4),n2h16(18))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[32,12,19],[0,0,0],3,2,wf4(:,8),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(5),n2h16(19))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[32,12,19],[nMB,nMB,nMB],3,2,wf4(:,8),wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,21),heltab2x32(:,:,21))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(6),n2h16(20))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[32,12,19],[0,0,0],3,2,wf4(:,8),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(7),n2h16(21))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(12)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[32,12,19],[nMB,nMB,nMB],3,2,wf4(:,8),wf4(:,9))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(8),n2h16(22))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(20)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[36,8,19],[0,0,0],3,2,wf4(:,3),wf4(:,9))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(1),m3h4x8(:,1),heltab2x32(:,:,24))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(21)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[40,4,19],[0,0,0],3,2,wf4(:,7),wf4(:,9))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,7),G0H8(2),m3h4x8(:,2),heltab2x32(:,:,25))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(27)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[32,15,16],[nMT,nMT,nMT],3,1,wf16(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,24),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(9),n2h16(23))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(27)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[32,15,16],[nMT,nMT,nMT],3,1,wf16(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,25),heltab2x32(:,:,27))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(10),n2h16(24))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(27)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[32,15,16],[nMB,nMB,nMB],3,1,wf16(:,1))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,26),heltab2x32(:,:,28))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(11),n2h16(25))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(27)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[32,15,16],[nMB,nMB,nMB],3,1,wf16(:,1))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,27),heltab2x32(:,:,29))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(12),n2h16(26))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(30)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[32,15,16],[nMT,nMT,nMT],3,1,wf16(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,28),heltab2x32(:,:,30))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(13),n2h16(27))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(30)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[32,15,16],[nMT,nMT,nMT],3,1,wf16(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,29),heltab2x32(:,:,31))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(14),n2h16(28))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(30)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[32,15,16],[nMB,nMB,nMB],3,1,wf16(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,30),heltab2x32(:,:,32))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(15),n2h16(29))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(30)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(33),h0tab(:,33),[32,15,16],[nMB,nMB,nMB],3,1,wf16(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,31),heltab2x32(:,:,33))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(16),n2h16(30))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(32)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(34),h0tab(:,34),[32,8,23],[0,0,0],3,1,wf8(:,19))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,32),heltab2x32(:,:,34))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(17),n2h16(31))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(32)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(35),h0tab(:,35),[32,8,23],[0,0,0],3,1,wf8(:,19))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(18),m3h2x16(:,33),heltab2x32(:,:,35))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(34)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(36),h0tab(:,36),[32,4,27],[0,0,0],3,1,wf8(:,21))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,34),heltab2x32(:,:,36))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(19),n2h16(32))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(34)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(37),h0tab(:,37),[32,4,27],[0,0,0],3,1,wf8(:,21))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(20),m3h2x16(:,35),heltab2x32(:,:,37))
  call Hloop_AZ_Q(ntryL,G1H4(3),wf4(:,4),G1H1(33),ngZu,m3h4x1(:,63),heltab2x4(:,:,87))
  call Hloop_A_Q(ntryL,G1H1(33),47,nMT,G2H1(13),n2h1(99))
  call Hloop_QZ_A(ntryL,G1H4(8),wf4(:,4),G1H1(9),ngZu,m3h4x1(:,64),heltab2x4(:,:,88))
  call Hloop_Q_A(ntryL,G1H1(9),47,nMT,G2H1(15),n2h1(100))
  call Hloop_AZ_Q(ntryL,G1H4(13),wf4(:,4),G1H1(6),ngZd,m3h4x1(:,65),heltab2x4(:,:,89))
  call Hloop_A_Q(ntryL,G1H1(6),47,nMB,G2H1(6),n2h1(101))
  call Hloop_QZ_A(ntryL,G1H4(18),wf4(:,4),G1H1(21),ngZd,m3h4x1(:,66),heltab2x4(:,:,90))
  call Hloop_Q_A(ntryL,G1H1(21),47,nMB,G2H1(16),n2h1(102))
  call Hloop_AV_Q(ntryL,G1H4(23),wf4(:,8),G1H1(34),m3h4x1(:,67),heltab2x4(:,:,91))
  call Hloop_A_Q(ntryL,G1H1(34),47,nMT,G2H1(18),n2h1(103))
  call Hloop_QV_A(ntryL,G1H4(28),wf4(:,8),G1H1(1),m3h4x1(:,68),heltab2x4(:,:,92))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMT,G2H1(3),n2h1(104))
  call Hloop_AV_Q(ntryL,G1H4(33),wf4(:,8),G1H1(37),m3h4x1(:,69),heltab2x4(:,:,93))
  call Hloop_A_Q(ntryL,G1H1(37),47,nMB,G2H1(19),n2h1(105))
  call Hloop_QV_A(ntryL,G1H4(38),wf4(:,8),G1H1(3),m3h4x1(:,70),heltab2x4(:,:,94))
  call Hloop_Q_A(ntryL,G1H1(3),47,nMB,G2H1(21),n2h1(106))
  call Hloop_QS_A(ntryL,G1H4(43),ex5(:),G1H4(51),ngH,m3h1x4(:,25),heltab2x4(:,:,95))
  call Hloop_Q_A(ntryL,G1H4(51),51,nMT,G2H4(1),n2h4(43))
  call Hloop_AS_Q(ntryL,G1H4(48),ex5(:),G1H4(10),ngH,m3h1x4(:,26),heltab2x4(:,:,96))
  call Hloop_A_Q(ntryL,G1H4(10),51,nMT,G2H4(2),n2h4(44))
  call Hloop_QS_A(ntryL,G1H4(53),ex5(:),G1H4(52),ngH,m3h1x4(:,27),heltab2x4(:,:,97))
  call Hloop_Q_A(ntryL,G1H4(52),51,nMB,G2H4(7),n2h4(45))
  call Hloop_AS_Q(ntryL,G1H4(58),ex5(:),G1H4(54),ngH,m3h1x4(:,28),heltab2x4(:,:,98))
  call Hloop_A_Q(ntryL,G1H4(54),51,nMB,G2H4(13),n2h4(46))
  call Hloop_QZ_A(ntryL,G1H8(2),wf4(:,9),G1H2(1),ngZd,m3h4x2(:,4),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(1),55,0,G2H2(1),n2h2(4))
  call Hloop_AV_Q(ntryL,G1H16(1),wf4(:,8),G1H4(11),m3h4x4(:,13),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G1H4(11),44,0,G2H4(14),n2h4(47))
  call Hloop_AV_Q(ntryL,G1H16(2),wf4(:,8),G1H4(55),m3h4x4(:,14),heltab2x16(:,:,17))
  call Hloop_A_Q(ntryL,G1H4(55),44,nMT,G2H4(16),n2h4(48))
  call Hloop_QV_A(ntryL,G1H16(3),wf4(:,8),G1H4(12),m3h4x4(:,15),heltab2x16(:,:,18))
  call Hloop_Q_A(ntryL,G1H4(12),44,0,G2H4(17),n2h4(49))
  call Hloop_QV_A(ntryL,G1H16(4),wf4(:,8),G1H4(56),m3h4x4(:,16),heltab2x16(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(56),44,nMT,G2H4(19),n2h4(50))
  call Hloop_AV_Q(ntryL,G1H16(5),wf4(:,8),G1H4(15),m3h4x4(:,17),heltab2x16(:,:,20))
  call Hloop_A_Q(ntryL,G1H4(15),44,0,G2H4(20),n2h4(51))
  call Hloop_AV_Q(ntryL,G1H16(6),wf4(:,8),G1H4(57),m3h4x4(:,18),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G1H4(57),44,nMB,G2H4(22),n2h4(52))
  call Hloop_QV_A(ntryL,G1H16(7),wf4(:,8),G1H4(59),m3h4x4(:,19),heltab2x16(:,:,22))
  call Hloop_Q_A(ntryL,G1H4(59),44,0,G2H4(23),n2h4(53))
  call Hloop_QV_A(ntryL,G1H16(8),wf4(:,8),G1H4(16),m3h4x4(:,20),heltab2x16(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(16),44,nMB,G2H4(24),n2h4(54))
  call Hloop_VA_Q(ntryL,G0H8(1),ex4(:),G0H4(5),m3h2x4(:,4),heltab2x8(:,:,8))
  call Hloop_A_Q(ntryL,G0H4(5),44,0,G1H4(60),n2h4(55))
  call Hloop_VQ_A(ntryL,G0H8(2),ex3(:),G0H4(6),m3h2x4(:,5),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G0H4(6),44,0,G1H4(17),n2h4(56))
  call Hloop_AV_Q(ntryL,G1H16(9),wf16(:,1),G1H1(7),m3h16x1(:,1),heltab2x16(:,:,24))
  call Hloop_A_Q(ntryL,G1H1(7),47,nMT,G2H1(7),n2h1(107))
  call Hloop_QV_A(ntryL,G1H16(10),wf16(:,1),G1H1(8),m3h16x1(:,2),heltab2x16(:,:,25))
  call Hloop_Q_A(ntryL,G1H1(8),47,nMT,G2H1(22),n2h1(108))
  call Hloop_AV_Q(ntryL,G1H16(11),wf16(:,1),G1H1(38),m3h16x1(:,3),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G1H1(38),47,nMB,G2H1(24),n2h1(109))
  call Hloop_QV_A(ntryL,G1H16(12),wf16(:,1),G1H1(22),m3h16x1(:,4),heltab2x16(:,:,27))
  call Hloop_Q_A(ntryL,G1H1(22),47,nMB,G2H1(9),n2h1(110))
  call Hloop_AV_Q(ntryL,G1H16(13),wf16(:,2),G1H1(41),m3h16x1(:,5),heltab2x16(:,:,28))
  call Hloop_A_Q(ntryL,G1H1(41),47,nMT,G2H1(1),n2h1(111))
  call Hloop_QV_A(ntryL,G1H16(14),wf16(:,2),G1H1(14),m3h16x1(:,6),heltab2x16(:,:,29))
  call Hloop_Q_A(ntryL,G1H1(14),47,nMT,G2H1(10),n2h1(112))
  call Hloop_AV_Q(ntryL,G1H16(15),wf16(:,2),G1H1(25),m3h16x1(:,7),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G1H1(25),47,nMB,G2H1(12),n2h1(113))
  call Hloop_QV_A(ntryL,G1H16(16),wf16(:,2),G1H1(10),m3h16x1(:,8),heltab2x16(:,:,31))
  call Hloop_Q_A(ntryL,G1H1(10),47,nMB,G2H1(4),n2h1(114))
  call Hloop_QA_V(ntryL,G1H16(17),ex4(:),G1H8(3),m3h2x8(:,4),heltab2x16(:,:,32))
  call Hloop_VA_Q(ntryL,G1H16(18),ex4(:),G1H8(1),m3h2x8(:,5),heltab2x16(:,:,33))
  call Hloop_A_Q(ntryL,G1H8(1),40,0,G2H8(1),n2h8(3))
  call Hloop_AQ_V(ntryL,G1H16(19),ex3(:),G1H8(4),m3h2x8(:,6),heltab2x16(:,:,34))
  call Hloop_VQ_A(ntryL,G1H16(20),ex3(:),G1H8(5),m3h2x8(:,7),heltab2x16(:,:,35))
  call Hloop_Q_A(ntryL,G1H8(5),36,0,G2H8(2),n2h8(4))
  call ol_merge(ntryL,G2H1(1),[G2H1(7),G2H1(14),G2H1(2),G1H1(28),G1H1(12)])
  call ol_merge(ntryL,G2H1(10),[G2H1(22),G2H1(17),G2H1(5),G1H1(32),G1H1(16)])
  call ol_merge(ntryL,G2H1(12),[G2H1(24),G2H1(20),G2H1(8),G1H1(36),G1H1(20)])
  call ol_merge(ntryL,G2H1(4),[G2H1(9),G2H1(23),G2H1(11),G1H1(40),G1H1(24)])
  call ol_merge(ntryL,G2H1(15),[G1H1(15)])
call HGT_OLR(G2H1(25),1,1,1)
call HGT_invQ_OLR(G2H1(25),2,5,1)
call HGT_OLR(G2H1(25),6,15,1)
  call ol_merge(ntryL,G2H1(25),[G2H1(15)])
  call ol_merge(ntryL,G2H4(11),[G1H4(37)])
  call ol_merge(ntryL,G2H1(13),[G1H1(11)])
call HGT_OLR(G2H1(26),1,1,1)
call HGT_invQ_OLR(G2H1(26),2,5,1)
call HGT_OLR(G2H1(26),6,15,1)
  call ol_merge(ntryL,G2H1(26),[G2H1(13)])
  call ol_merge(ntryL,G2H4(15),[G1H4(42)])
  call ol_merge(ntryL,G2H1(16),[G1H1(23)])
call HGT_OLR(G2H1(27),1,1,1)
call HGT_invQ_OLR(G2H1(27),2,5,1)
call HGT_OLR(G2H1(27),6,15,1)
  call ol_merge(ntryL,G2H1(27),[G2H1(16)])
  call ol_merge(ntryL,G2H4(18),[G1H4(46)])
  call ol_merge(ntryL,G2H1(6),[G1H1(19)])
call HGT_OLR(G2H1(28),1,1,1)
call HGT_invQ_OLR(G2H1(28),2,5,1)
call HGT_OLR(G2H1(28),6,15,1)
  call ol_merge(ntryL,G2H1(28),[G2H1(6)])
  call ol_merge(ntryL,G2H4(21),[G1H4(50)])
  call ol_merge(ntryL,G1H4(17),[G1H4(30)])
call HGT_w2_OLR(G1H4(20),1,1,4)
call HGT_w2_invQ_OLR(G1H4(20),2,5,4)
  call ol_merge(ntryL,G1H4(20),[G1H4(17)])
  call ol_merge(ntryL,G1H4(60),[G1H4(24)])
  call ol_merge(ntryL,G2H4(20),[G1H4(25)])
  call ol_merge(ntryL,G2H4(23),[G1H4(31)])
  call ol_merge(ntryL,G2H1(18),[G1H1(27)])
  call ol_merge(ntryL,G2H1(3),[G1H1(31)])
  call ol_merge(ntryL,G2H1(19),[G1H1(35)])
  call ol_merge(ntryL,G2H1(21),[G1H1(39)])
  call ol_merge(ntryL,G2H4(1),[G1H4(36)])
  call ol_merge(ntryL,G2H4(2),[G1H4(61)])
  call ol_merge(ntryL,G2H4(7),[G1H4(2)])
  call ol_merge(ntryL,G2H4(13),[G1H4(6)])
call HGT_OLR(G2H4(4),1,1,4)
call HGT_invQ_OLR(G2H4(4),2,5,4)
call HGT_OLR(G2H4(4),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(4),wf4(:,4),G2H1(7),ngZu,m3h4x1(:,71),heltab2x4(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(7),63,nMT,G3tensor(13),n2h1(115))
  call Hloop_AS_Q(ntryL,G2H1(1),ex5(:),G2H1(14),ngH,m3h1x1(:,41),heltab2x1(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(14),63,nMT,G3tensor(14),n2h1(116))
call HGT_OLR(G2H4(6),1,1,4)
call HGT_invQ_OLR(G2H4(6),2,5,4)
call HGT_OLR(G2H4(6),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(6),wf4(:,4),G2H1(2),ngZu,m3h4x1(:,72),heltab2x4(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(2),63,nMT,G3tensor(15),n2h1(117))
  call Hloop_QS_A(ntryL,G2H1(10),ex5(:),G2H1(22),ngH,m3h1x1(:,42),heltab2x1(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(22),63,nMT,G3tensor(16),n2h1(118))
call HGT_OLR(G2H4(8),1,1,4)
call HGT_invQ_OLR(G2H4(8),2,5,4)
call HGT_OLR(G2H4(8),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(8),wf4(:,4),G2H1(17),ngZd,m3h4x1(:,73),heltab2x4(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(17),63,nMB,G3tensor(17),n2h1(119))
  call Hloop_AS_Q(ntryL,G2H1(12),ex5(:),G2H1(5),ngH,m3h1x1(:,43),heltab2x1(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(5),63,nMB,G3tensor(18),n2h1(120))
call HGT_OLR(G2H4(10),1,1,4)
call HGT_invQ_OLR(G2H4(10),2,5,4)
call HGT_OLR(G2H4(10),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(10),wf4(:,4),G2H1(24),ngZd,m3h4x1(:,74),heltab2x4(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(24),63,nMB,G3tensor(19),n2h1(121))
  call Hloop_QS_A(ntryL,G2H1(4),ex5(:),G2H1(20),ngH,m3h1x1(:,44),heltab2x1(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(20),63,nMB,G3tensor(20),n2h1(122))
call HGT_OLR(G2H4(12),1,1,4)
call HGT_invQ_OLR(G2H4(12),2,5,4)
call HGT_OLR(G2H4(12),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(12),wf4(:,8),G2H1(8),m3h4x1(:,75),heltab2x4(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(8),63,nMT,G3tensor(21),n2h1(123))
call HGT_OLR(G2H4(5),1,1,4)
call HGT_invQ_OLR(G2H4(5),2,5,4)
call HGT_OLR(G2H4(5),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(5),wf4(:,8),G2H1(9),m3h4x1(:,76),heltab2x4(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(9),63,nMT,G3tensor(22),n2h1(124))
call HGT_OLR(G2H4(9),1,1,4)
call HGT_invQ_OLR(G2H4(9),2,5,4)
call HGT_OLR(G2H4(9),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(9),wf4(:,8),G2H1(23),m3h4x1(:,77),heltab2x4(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(23),63,nMB,G3tensor(23),n2h1(125))
call HGT_OLR(G2H4(3),1,1,4)
call HGT_invQ_OLR(G2H4(3),2,5,4)
call HGT_OLR(G2H4(3),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(3),wf4(:,8),G2H1(11),m3h4x1(:,78),heltab2x4(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(11),63,nMB,G3tensor(24),n2h1(126))
  call Hloop_QS_A(ntryL,G2H1(25),ex5(:),G2H1(15),ngH,m3h1x1(:,45),heltab2x1(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(15),63,nMT,G3tensor(25),n2h1(127))
  call Hloop_QV_A(ntryL,G2H4(11),wf4(:,8),G2H1(13),m3h4x1(:,79),heltab2x4(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(13),63,nMT,G3tensor(26),n2h1(128))
  call Hloop_AS_Q(ntryL,G2H1(26),ex5(:),G2H1(16),ngH,m3h1x1(:,46),heltab2x1(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(16),63,nMT,G3tensor(27),n2h1(129))
  call Hloop_AV_Q(ntryL,G2H4(15),wf4(:,8),G2H1(6),m3h4x1(:,80),heltab2x4(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(6),63,nMT,G3tensor(28),n2h1(130))
  call Hloop_QS_A(ntryL,G2H1(27),ex5(:),G2H1(7),ngH,m3h1x1(:,47),heltab2x1(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(7),63,nMB,G3tensor(29),n2h1(131))
  call Hloop_QV_A(ntryL,G2H4(18),wf4(:,8),G2H1(1),m3h4x1(:,81),heltab2x4(:,:,109))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(30),n2h1(132))
  call Hloop_AS_Q(ntryL,G2H1(28),ex5(:),G2H1(14),ngH,m3h1x1(:,48),heltab2x1(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(14),63,nMB,G3tensor(31),n2h1(133))
  call Hloop_AV_Q(ntryL,G2H4(21),wf4(:,8),G2H1(2),m3h4x1(:,82),heltab2x4(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(2),63,nMB,G3tensor(32),n2h1(134))
  call Hloop_QZ_A(ntryL,G1H4(20),wf4(:,9),G1H1(4),ngZd,m3h4x1(:,83),heltab2x4(:,:,111))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(4),63,0,G2tensor(1),n2h1(135))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(2),ex4(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hloop_AZ_Q(ntryL,G1H4(60),wf4(:,9),G1H1(17),ngZd,m3h4x1(:,84),heltab2x4(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(17),63,0,G2tensor(5),n2h1(136))
  call Hloop_AZ_Q(ntryL,G2H4(20),wf4(:,9),G2H1(10),ngZd,m3h4x1(:,85),heltab2x4(:,:,113))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(10),63,0,G3tensor(33),n2h1(137))
  call Hloop_QZ_A(ntryL,G2H4(23),wf4(:,9),G2H1(22),ngZd,m3h4x1(:,86),heltab2x4(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(22),63,0,G3tensor(34),n2h1(138))
  call Hloop_AS_Q(ntryL,G2H1(18),ex5(:),G2H1(17),ngH,m3h1x1(:,49),heltab2x1(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(17),63,nMT,G3tensor(35),n2h1(139))
  call Hloop_QS_A(ntryL,G2H1(3),ex5(:),G2H1(12),ngH,m3h1x1(:,50),heltab2x1(:,:,50))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(12),63,nMT,G3tensor(36),n2h1(140))
  call Hloop_AS_Q(ntryL,G2H1(19),ex5(:),G2H1(5),ngH,m3h1x1(:,51),heltab2x1(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(5),63,nMB,G3tensor(37),n2h1(141))
  call Hloop_QS_A(ntryL,G2H1(21),ex5(:),G2H1(24),ngH,m3h1x1(:,52),heltab2x1(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(24),63,nMB,G3tensor(38),n2h1(142))
  call Hloop_QV_A(ntryL,G2H4(1),wf4(:,8),G2H1(4),m3h4x1(:,87),heltab2x4(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(4),63,nMT,G3tensor(39),n2h1(143))
  call Hloop_AV_Q(ntryL,G2H4(2),wf4(:,8),G2H1(20),m3h4x1(:,88),heltab2x4(:,:,116))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(20),63,nMT,G3tensor(40),n2h1(144))
  call Hloop_QV_A(ntryL,G2H4(7),wf4(:,8),G2H1(8),m3h4x1(:,89),heltab2x4(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(8),63,nMB,G3tensor(41),n2h1(145))
  call Hloop_AV_Q(ntryL,G2H4(13),wf4(:,8),G2H1(9),m3h4x1(:,90),heltab2x4(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(9),63,nMB,G3tensor(42),n2h1(146))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(7),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hloop_AZ_Q(ntryL,G2H4(14),wf4(:,9),G2H1(23),ngZu,m3h4x1(:,91),heltab2x4(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(23),63,0,G3tensor(43),n2h1(147))
  call Hloop_AZ_Q(ntryL,G2H4(16),wf4(:,9),G2H1(11),ngZu,m3h4x1(:,92),heltab2x4(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(11),63,nMT,G3tensor(44),n2h1(148))
  call Hloop_QZ_A(ntryL,G2H4(17),wf4(:,9),G2H1(25),ngZu,m3h4x1(:,93),heltab2x4(:,:,121))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(25),63,0,G3tensor(45),n2h1(149))
  call Hloop_QZ_A(ntryL,G2H4(19),wf4(:,9),G2H1(15),ngZu,m3h4x1(:,94),heltab2x4(:,:,122))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(15),63,nMT,G3tensor(46),n2h1(150))
  call Hloop_AZ_Q(ntryL,G2H4(22),wf4(:,9),G2H1(13),ngZd,m3h4x1(:,95),heltab2x4(:,:,123))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(13),63,nMB,G3tensor(47),n2h1(151))
  call Hloop_QZ_A(ntryL,G2H4(24),wf4(:,9),G2H1(26),ngZd,m3h4x1(:,96),heltab2x4(:,:,124))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(26),63,nMB,G3tensor(48),n2h1(152))
  call Hloop_VQ_A(ntryL,G1H8(3),wf8(:,19),G1H1(26),m3h8x1(:,1),heltab2x8(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(26),63,0,G2tensor(9),n2h1(153))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(1),wf8(:,19),G2tensor(11),m3h8x1(:,2),heltab2x8(:,:,11))
  call Hloop_VA_Q(ntryL,G1H8(4),wf8(:,21),G1H1(42),m3h8x1(:,3),heltab2x8(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),63,0,G2tensor(21),n2h1(154))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(2),wf8(:,21),G2tensor(27),m3h8x1(:,4),heltab2x8(:,:,13))
  call ol_merge_tensors(G3tensor(46),[G3tensor(44),G3tensor(2),G3tensor(1),G2tensor(26),G2tensor(23),G1tensor(44),G0tensor(26)])
  call ol_merge_tensors(G3tensor(48),[G3tensor(47),G3tensor(4),G3tensor(3),G2tensor(32),G2tensor(29),G1tensor(49),G0tensor(31)])
  call ol_merge_tensors(G3tensor(10),[G3tensor(9),G3tensor(6),G3tensor(5),G2tensor(50),G2tensor(47),G2tensor(38),G2tensor(35) &
    ,G1tensor(64),G1tensor(54),G0tensor(46),G0tensor(36)])
  call ol_merge_tensors(G3tensor(12),[G3tensor(11),G3tensor(8),G3tensor(7),G2tensor(56),G2tensor(53),G2tensor(44),G2tensor(41) &
    ,G1tensor(69),G1tensor(59),G0tensor(51),G0tensor(41)])
  call ol_merge_tensors(G2tensor(27),[G2tensor(21),G2tensor(17),G2tensor(14),G1tensor(34),G1tensor(29),G0tensor(16) &
    ,G0tensor(11)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(31),G0tensor(13)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(36),G0tensor(18)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(9),G2tensor(20),G1tensor(39),G0tensor(21)])
  call ol_merge_tensors(G3tensor(15),[G3tensor(13),G2tensor(25),G2tensor(22),G1tensor(41),G0tensor(23)])
  call ol_merge_tensors(G3tensor(19),[G3tensor(17),G2tensor(31),G2tensor(28),G1tensor(46),G0tensor(28)])
  call ol_merge_tensors(G3tensor(22),[G3tensor(21),G2tensor(37),G2tensor(34),G1tensor(51),G0tensor(33)])
  call ol_merge_tensors(G3tensor(24),[G3tensor(23),G2tensor(43),G2tensor(40),G1tensor(56),G0tensor(38)])
  call ol_merge_tensors(G3tensor(27),[G3tensor(25),G2tensor(49),G2tensor(46),G1tensor(61),G1tensor(42),G0tensor(43) &
    ,G0tensor(24)])
  call ol_merge_tensors(G3tensor(31),[G3tensor(29),G2tensor(55),G2tensor(52),G1tensor(66),G1tensor(47),G0tensor(48) &
    ,G0tensor(29)])
  call ol_merge_tensors(G1tensor(18),[G1tensor(3)])
  call ol_merge_tensors(G1tensor(12),[G1tensor(4)])
  call ol_merge_tensors(G1tensor(22),[G1tensor(7)])
  call ol_merge_tensors(G1tensor(16),[G1tensor(8)])
  call ol_merge_tensors(G1tensor(21),[G1tensor(13)])
  call ol_merge_tensors(G1tensor(25),[G1tensor(17)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(37),G1tensor(26),G0tensor(19),G0tensor(8)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(27),G0tensor(9)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(28),G0tensor(10)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(32),G0tensor(14)])
  call ol_merge_tensors(G3tensor(45),[G3tensor(43),G3tensor(34),G3tensor(33),G1tensor(38),G1tensor(33),G0tensor(20) &
    ,G0tensor(15)])
  call ol_merge_tensors(G3tensor(16),[G3tensor(14),G1tensor(53),G1tensor(43),G0tensor(35),G0tensor(25)])
  call ol_merge_tensors(G3tensor(20),[G3tensor(18),G1tensor(58),G1tensor(48),G0tensor(40),G0tensor(30)])
  call ol_merge_tensors(G3tensor(36),[G3tensor(35),G1tensor(52),G0tensor(34)])
  call ol_merge_tensors(G3tensor(38),[G3tensor(37),G1tensor(57),G0tensor(39)])
  call ol_merge_tensors(G3tensor(40),[G3tensor(39),G1tensor(62),G0tensor(44)])
  call ol_merge_tensors(G3tensor(28),[G3tensor(26),G1tensor(63),G0tensor(45)])
  call ol_merge_tensors(G3tensor(42),[G3tensor(41),G1tensor(67),G0tensor(49)])
  call ol_merge_tensors(G3tensor(32),[G3tensor(30),G1tensor(68),G0tensor(50)])
call TI_triangle_red(G3tensor(46),RedBasis(1),mass3set(:,1),G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),M2L1R1,[nMT], &
    G0tensor(5))
call TI_triangle_red(G3tensor(48),RedBasis(1),mass3set(:,2),G0tensor(6),G0tensor(7),G0tensor(12),G0tensor(17),M2L1R1,[nMB], &
    G0tensor(22))
call TI_triangle_red(G3tensor(10),RedBasis(4),mass3set(:,1),G0tensor(27),G0tensor(32),G0tensor(37),G0tensor(42),M2L1R1,[nMT], &
    G0tensor(47))
call TI_triangle_red(G3tensor(12),RedBasis(4),mass3set(:,2),G0tensor(26),G0tensor(31),G0tensor(46),G0tensor(36),M2L1R1,[nMB], &
    G0tensor(51))
call TI_triangle_red(G2tensor(27),RedBasis(8),mass3set(:,3),G0tensor(41),G0tensor(16),G0tensor(11),G0tensor(13),M2L1R1)
call TI_triangle_red(G2tensor(16),RedBasis(14),mass3set(:,3),G0tensor(18),G0tensor(21),G0tensor(23),G0tensor(28),M2L1R1)
call TI_triangle_red(G2tensor(19),RedBasis(15),mass3set(:,3),G0tensor(33),G0tensor(38),G0tensor(43),G0tensor(24),M2L1R1)
call TI_triangle_red(G2tensor(11),RedBasis(12),mass3set(:,3),G0tensor(48),G0tensor(29),G0tensor(19),G0tensor(8),M2L1R1)
call TI_triangle_red(G3tensor(15),RedBasis(16),mass3set(:,1),G0tensor(9),G0tensor(10),G0tensor(14),G0tensor(20),M2L1R1,[nMT], &
    G0tensor(15))
call TI_triangle_red(G3tensor(19),RedBasis(16),mass3set(:,2),G0tensor(35),G0tensor(25),G0tensor(40),G0tensor(30),M2L1R1,[nMB], &
    G0tensor(34))
call TI_triangle_red(G3tensor(22),RedBasis(17),mass3set(:,1),G0tensor(39),G0tensor(44),G0tensor(45),G0tensor(49),M2L1R1,[nMT], &
    G0tensor(50))
call TI_triangle_red(G3tensor(24),RedBasis(17),mass3set(:,2),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55),M2L1R1,[nMB], &
    G0tensor(56))
call TI_triangle_red(G3tensor(27),RedBasis(3),mass3set(:,1),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60),M2L1R1,[nMT], &
    G0tensor(61))
call TI_triangle_red(G3tensor(31),RedBasis(3),mass3set(:,2),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65),M2L1R1,[nMB], &
    G0tensor(66))
call TI_triangle_red(G2tensor(1),RedBasis(13),mass3set(:,3),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70),M2L1R1)
call TI_triangle_red(G2tensor(7),RedBasis(10),mass3set(:,3),G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),M2L1R1)
call TI_triangle_red(G2tensor(3),RedBasis(9),mass3set(:,3),G0tensor(75),G0tensor(76),G0tensor(77),G0tensor(78),M2L1R1)
call TI_triangle_red(G2tensor(5),RedBasis(11),mass3set(:,3),G0tensor(79),G0tensor(80),G0tensor(81),G0tensor(82),M2L1R1)
call TI_triangle_red(G3tensor(45),RedBasis(1),mass3set(:,3),G0tensor(83),G0tensor(84),G0tensor(85),G0tensor(86),M2L1R1)
call TI_triangle_red(G3tensor(16),RedBasis(2),mass3set(:,1),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90),M2L1R1,[nMT], &
    G0tensor(91))
call TI_triangle_red(G3tensor(20),RedBasis(2),mass3set(:,2),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95),M2L1R1,[nMB], &
    G0tensor(96))
call TI_triangle_red(G3tensor(36),RedBasis(5),mass3set(:,1),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100),M2L1R1,[nMT], &
    G0tensor(101))
call TI_triangle_red(G3tensor(38),RedBasis(5),mass3set(:,2),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105),M2L1R1,[nMB], &
    G0tensor(106))
call TI_triangle_red(G3tensor(40),RedBasis(7),mass3set(:,1),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110),M2L1R1,[nMT], &
    G0tensor(111))
call TI_triangle_red(G3tensor(28),RedBasis(6),mass3set(:,1),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115),M2L1R1,[nMT], &
    G0tensor(116))
call TI_triangle_red(G3tensor(42),RedBasis(7),mass3set(:,2),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120),M2L1R1,[nMB], &
    G0tensor(121))
call TI_triangle_red(G3tensor(32),RedBasis(6),mass3set(:,2),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125),M2L1R1,[nMB], &
    G0tensor(126))
call ol_merge_tensors(T0sum(16),[G0tensor(1)])
call ol_merge_tensors(T0sum(17),[G0tensor(6)])
call ol_merge_tensors(T0sum(18),[G0tensor(27)])
call ol_merge_tensors(T0sum(19),[G0tensor(26)])
call ol_merge_tensors(T0sum(20),[G0tensor(41)])
call ol_merge_tensors(T0sum(21),[G0tensor(18)])
call ol_merge_tensors(T0sum(22),[G0tensor(33)])
call ol_merge_tensors(T0sum(23),[G0tensor(48)])
call ol_merge_tensors(T0sum(24),[G0tensor(9)])
call ol_merge_tensors(T0sum(25),[G0tensor(35)])
call ol_merge_tensors(T0sum(26),[G0tensor(39)])
call ol_merge_tensors(T0sum(27),[G0tensor(52)])
call ol_merge_tensors(T0sum(28),[G0tensor(57)])
call ol_merge_tensors(T0sum(29),[G0tensor(62)])
call ol_merge_tensors(T1sum(1),[G1tensor(2)])
call ol_merge_tensors(T1sum(2),[G1tensor(18)])
call ol_merge_tensors(T1sum(3),[G1tensor(12)])
call ol_merge_tensors(T1sum(4),[G1tensor(5)])
call ol_merge_tensors(T1sum(5),[G1tensor(6)])
call ol_merge_tensors(T1sum(6),[G1tensor(22)])
call ol_merge_tensors(T1sum(7),[G1tensor(16)])
call ol_merge_tensors(T1sum(8),[G1tensor(9)])
call ol_merge_tensors(T1sum(9),[G1tensor(10)])
call ol_merge_tensors(T1sum(10),[G1tensor(11)])
call ol_merge_tensors(T1sum(11),[G1tensor(21)])
call ol_merge_tensors(T1sum(12),[G1tensor(14)])
call ol_merge_tensors(T1sum(13),[G1tensor(15)])
call ol_merge_tensors(T1sum(14),[G1tensor(25)])
call ol_merge_tensors(T1sum(15),[G1tensor(19)])
call ol_merge_tensors(T1sum(16),[G1tensor(20)])
call ol_merge_tensors(T1sum(17),[G1tensor(23)])
call ol_merge_tensors(T1sum(18),[G1tensor(24)])
call ol_merge_tensors(T0sum(30),[G0tensor(67)])
call ol_merge_tensors(T0sum(31),[G0tensor(71)])
call ol_merge_tensors(T0sum(32),[G0tensor(75)])
call ol_merge_tensors(T0sum(33),[G0tensor(79)])
call ol_merge_tensors(T0sum(34),[G0tensor(83)])
call ol_merge_tensors(T0sum(35),[G0tensor(87)])
call ol_merge_tensors(T0sum(36),[G0tensor(92)])
call ol_merge_tensors(T0sum(37),[G0tensor(97)])
call ol_merge_tensors(T0sum(38),[G0tensor(102)])
call ol_merge_tensors(T0sum(39),[G0tensor(107)])
call ol_merge_tensors(T0sum(40),[G0tensor(112)])
call ol_merge_tensors(T0sum(41),[G0tensor(117)])
call ol_merge_tensors(T0sum(42),[G0tensor(122)])
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(36)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(38),h0tab(:,38),[36,27],[0,0],2,2,wf4(:,3),wf8(:,21))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,3),G0H8(1),m3h4x8(:,3),heltab2x32(:,:,38))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(37)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(39),h0tab(:,39),[40,23],[0,0],2,2,wf4(:,7),wf8(:,19))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,7),G0H8(2),m3h4x8(:,4),heltab2x32(:,:,39))
  call Hloop_A_Q(ntryL,G0H8(2),40,0,G1H8(2),n2h8(5))
  call Hloop_VA_Q(ntryL,G0H8(1),wf8(:,21),G0H1(1),m3h8x1(:,5),heltab2x8(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),63,0,G1tensor(1),n2h1(155))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(2),wf8(:,19),G1tensor(30),m3h8x1(:,6),heltab2x8(:,:,15))
  call ol_merge_tensors(G0tensor(114),[G0tensor(109),G0tensor(98),G0tensor(45),G0tensor(10),G0tensor(2)])
  call ol_merge_tensors(G0tensor(113),[G0tensor(60),G0tensor(3)])
  call ol_merge_tensors(G0tensor(115),[G0tensor(90),G0tensor(42),G0tensor(4)])
  call ol_merge_tensors(G0tensor(116),[G0tensor(111),G0tensor(101),G0tensor(91),G0tensor(61),G0tensor(50),G0tensor(15) &
    ,G0tensor(47),G0tensor(5)])
  call ol_merge_tensors(G0tensor(124),[G0tensor(119),G0tensor(103),G0tensor(54),G0tensor(25),G0tensor(7)])
  call ol_merge_tensors(G0tensor(123),[G0tensor(65),G0tensor(12)])
  call ol_merge_tensors(G0tensor(125),[G0tensor(95),G0tensor(36),G0tensor(17)])
  call ol_merge_tensors(G0tensor(126),[G0tensor(121),G0tensor(106),G0tensor(96),G0tensor(66),G0tensor(56),G0tensor(34) &
    ,G0tensor(51),G0tensor(22)])
  call ol_merge_tensors(G0tensor(58),[G0tensor(44),G0tensor(14),G0tensor(32)])
  call ol_merge_tensors(G0tensor(110),[G0tensor(100),G0tensor(37)])
  call ol_merge_tensors(G0tensor(63),[G0tensor(53),G0tensor(40),G0tensor(31)])
  call ol_merge_tensors(G0tensor(120),[G0tensor(105),G0tensor(46)])
  call ol_merge_tensors(G0tensor(68),[G0tensor(43),G0tensor(21),G0tensor(16)])
  call ol_merge_tensors(G1tensor(1),[G0tensor(82),G0tensor(74),G0tensor(11)])
  call ol_merge_tensors(G0tensor(86),[G0tensor(78),G0tensor(8),G0tensor(13)])
  call ol_merge_tensors(G0tensor(80),[G0tensor(77),G0tensor(73),G0tensor(29),G0tensor(38),G0tensor(23)])
  call ol_merge_tensors(G0tensor(84),[G0tensor(24),G0tensor(28)])
  call ol_merge_tensors(G1tensor(30),[G0tensor(76),G0tensor(70),G0tensor(19)])
  call ol_merge_tensors(G0tensor(88),[G0tensor(49),G0tensor(20)])
  call ol_merge_tensors(G0tensor(93),[G0tensor(55),G0tensor(30)])
  call ol_merge_tensors(G0tensor(108),[G0tensor(99),G0tensor(89),G0tensor(59)])
  call ol_merge_tensors(G0tensor(118),[G0tensor(104),G0tensor(94),G0tensor(64)])
  call ol_merge_tensors(G0tensor(85),[G0tensor(81),G0tensor(72),G0tensor(69)])
call TI_bubble_red(G1tensor(1),36,mass2set(:,1),G0tensor(1),M2L1R1)
call TI_bubble_red(G1tensor(30),40,mass2set(:,1),G0tensor(6),M2L1R1)
call ol_merge_tensors(T0sum(43),[G0tensor(114)])
call ol_merge_tensors(T0sum(44),[G0tensor(113)])
call ol_merge_tensors(T0sum(45),[G0tensor(115)])
call ol_merge_tensors(T0sum(46),[G0tensor(116)])
call ol_merge_tensors(T0sum(47),[G0tensor(124)])
call ol_merge_tensors(T0sum(48),[G0tensor(123)])
call ol_merge_tensors(T0sum(49),[G0tensor(125)])
call ol_merge_tensors(T0sum(50),[G0tensor(126)])
call ol_merge_tensors(T0sum(51),[G0tensor(58)])
call ol_merge_tensors(T0sum(52),[G0tensor(110)])
call ol_merge_tensors(T0sum(53),[G0tensor(63)])
call ol_merge_tensors(T0sum(54),[G0tensor(120)])
call ol_merge_tensors(T0sum(55),[G0tensor(68)])
call ol_merge_tensors(T0sum(56),[G0tensor(1)])
call ol_merge_tensors(T0sum(57),[G0tensor(86)])
call ol_merge_tensors(T0sum(58),[G0tensor(80)])
call ol_merge_tensors(T0sum(59),[G0tensor(84)])
call ol_merge_tensors(T0sum(60),[G0tensor(6)])
call ol_merge_tensors(T0sum(61),[G0tensor(88)])
call ol_merge_tensors(T0sum(62),[G0tensor(93)])
call ol_merge_tensors(T0sum(63),[G0tensor(108)])
call ol_merge_tensors(T0sum(64),[G0tensor(118)])
call ol_merge_tensors(T0sum(65),[G0tensor(85)])
! end of process


end subroutine vamp_1

end module ol_vamp_1_pphllj_nenexddxhg_1_/**/REALKIND
