
module ol_vamp_1_pphllj_nenexbbxhg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphllj_nenexbbxhg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphllj_nenexbbxhg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pphllj_nenexbbxhg_1_/**/DREALKIND
  use ol_tensor_sum_storage_pphllj_nenexbbxhg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pphllj_nenexbbxhg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pphllj_nenexbbxhg_1_/**/DREALKIND, only: ntryL, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(32)
  type(Hpolcont), intent(in) :: M(1,32)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(1),h0tab(:,1),[32,3,16,4,8],[nMB,nMB,nMB,0,nMB],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,1),heltab2x32(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(1),n2h16(1))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(2),h0tab(:,2),[32,3,8,4,16],[nMB,nMB,0,nMB,nMB],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,2),heltab2x32(:,:,2))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(2),n2h16(2))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(3),h0tab(:,3),[32,3,16,8,4],[nMB,nMB,nMB,0,nMB],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,3),heltab2x32(:,:,3))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(3),n2h16(3))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(4),h0tab(:,4),[32,4,8,3,16],[nMB,0,nMB,nMB,nMB],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,4),heltab2x32(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(4),n2h16(4))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(5),h0tab(:,5),[32,3,4,8,16],[nMB,nMB,0,nMB,nMB],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,5),heltab2x32(:,:,5))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(5),n2h16(5))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(6),h0tab(:,6),[32,8,4,3,16],[nMB,0,nMB,nMB,nMB],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,6),heltab2x32(:,:,6))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(6),n2h16(6))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(7),h0tab(:,7),[32,4,16,3,8],[0,nMB,nMB,nMB,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(7),m3h2x16(:,7),heltab2x32(:,:,7))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(8),h0tab(:,8),[32,4,3,16,8],[0,nMB,nMB,nMB,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(8),m3h2x16(:,8),heltab2x32(:,:,8))
  call Hloop_AZ_Q(ntryL,G1H16(1),wf4(:,3),G1H4(1),ngZd,m3h4x4(:,1),heltab2x16(:,:,1))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMB,G2H4(1),n2h4(1))
  call Hloop_QZ_A(ntryL,G1H16(2),wf4(:,3),G1H4(1),ngZd,m3h4x4(:,2),heltab2x16(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMB,G2H4(2),n2h4(2))
  call Hloop_QZ_A(ntryL,G1H16(3),wf4(:,3),G1H4(1),ngZd,m3h4x4(:,3),heltab2x16(:,:,3))
  call Hloop_Q_A(ntryL,G1H4(1),35,nMB,G2H4(3),n2h4(3))
  call Hloop_AQ_V(ntryL,G1H16(4),ex3(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,4))
  call Hloop_AZ_Q(ntryL,G1H16(5),wf4(:,3),G1H4(1),ngZd,m3h4x4(:,4),heltab2x16(:,:,5))
  call Hloop_A_Q(ntryL,G1H4(1),35,nMB,G2H4(4),n2h4(4))
  call Hloop_QA_V(ntryL,G1H16(6),ex4(:),G1H8(2),m3h2x8(:,2),heltab2x16(:,:,6))
  call Hloop_VQ_A(ntryL,G1H16(7),ex3(:),G1H8(3),m3h2x8(:,3),heltab2x16(:,:,7))
  call Hloop_Q_A(ntryL,G1H8(3),36,nMB,G2H8(1),n2h8(1))
  call Hloop_VQ_A(ntryL,G1H16(8),ex3(:),G1H8(3),m3h2x8(:,4),heltab2x16(:,:,8))
  call Hloop_Q_A(ntryL,G1H8(3),36,nMB,G2H8(2),n2h8(2))
call Hotf_5pt_reduction(G2H4(1),RedSet_5(1),mass5set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
call HG1shiftOLR(G1H4(2),8,4)
  call Hloop_QA_V(ntryL,G2H4(2),ex4(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
call Hotf_5pt_reduction(G2H4(3),RedSet_5(2),mass5set(:,1),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
call HG1shiftOLR(G1H4(8),4,4)
  call Hloop_VA_Q(ntryL,G1H8(1),ex4(:),G1H4(13),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_A_Q(ntryL,G1H4(13),44,nMB,G2H4(1),n2h4(5))
  call Hloop_AQ_V(ntryL,G2H4(4),ex3(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_VQ_A(ntryL,G1H8(2),ex3(:),G1H4(13),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(13),44,nMB,G2H4(2),n2h4(6))
call Hotf_5pt_reduction(G2H8(1),RedSet_5(3),mass5set(:,2),  & 
G1H8(3),G1H8(1),G1H8(2),G1H8(4),G1H8(5),G1H8(6),8)
call HG1shiftOLR(G1H8(1),8,8)
call Hotf_5pt_reduction(G2H8(2),RedSet_5(4),mass5set(:,2),  & 
G1H8(7),G1H8(8),G1H8(9),G1H8(10),G1H8(11),G1H8(12),8)
call HG1shiftOLR(G1H8(8),8,8)
  call Hloop_AS_Q(ntryL,G1H4(1),ex5(:),G1H4(13),ngH,m3h1x4(:,1),heltab2x4(:,:,3))
  call Hloop_A_Q(ntryL,G1H4(13),51,nMB,G2H4(3),n2h4(7))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(2),-8,nMB,G2H4(4),n2h4(8))
  call Hloop_QA_V(ntryL,G2H4(4),ex4(:),G2H2(3),m3h2x2(:,3),heltab2x4(:,:,4))
  call Hloop_AS_Q(ntryL,G1H4(4),ex5(:),G1H4(1),ngH,m3h1x4(:,2),heltab2x4(:,:,5))
  call Hloop_A_Q(ntryL,G1H4(1),51,nMB,G2H4(4),n2h4(9))
  call Hloop_AS_Q(ntryL,G1H4(5),ex5(:),G1H4(13),ngH,m3h1x4(:,3),heltab2x4(:,:,6))
  call Hloop_A_Q(ntryL,G1H4(13),51,nMB,G2H4(5),n2h4(10))
  call Hloop_AS_Q(ntryL,G1H4(6),ex5(:),G1H4(2),ngH,m3h1x4(:,4),heltab2x4(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(2),51,nMB,G2H4(6),n2h4(11))
  call Hloop_QS_A(ntryL,G1H4(7),ex5(:),G1H4(4),ngH,m3h1x4(:,5),heltab2x4(:,:,8))
  call Hloop_Q_A(ntryL,G1H4(4),51,nMB,G2H4(7),n2h4(12))
call HGT_OLR(G1H4(8),1,1,4)
call HGT_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(8),-4,nMB,G2H4(8),n2h4(13))
  call Hloop_AQ_V(ntryL,G2H4(8),ex3(:),G2H2(4),m3h2x2(:,4),heltab2x4(:,:,9))
  call Hloop_QS_A(ntryL,G1H4(10),ex5(:),G1H4(1),ngH,m3h1x4(:,6),heltab2x4(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMB,G2H4(8),n2h4(14))
  call Hloop_QS_A(ntryL,G1H4(11),ex5(:),G1H4(5),ngH,m3h1x4(:,7),heltab2x4(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(5),51,nMB,G2H4(9),n2h4(15))
  call Hloop_QS_A(ntryL,G1H4(12),ex5(:),G1H4(13),ngH,m3h1x4(:,8),heltab2x4(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(13),51,nMB,G2H4(10),n2h4(16))
  call Hloop_QS_A(ntryL,G1H8(3),ex5(:),G1H8(13),ngH,m3h1x8(:,1),heltab2x8(:,:,3))
  call Hloop_Q_A(ntryL,G1H8(13),52,nMB,G2H8(1),n2h8(3))
call HGT_raise_alpha_OLR(G1H8(1),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(1),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(1),ex4(:),G1H4(6),m3h2x4(:,3),heltab2x8(:,:,4))
  call Hloop_QS_A(ntryL,G1H8(4),ex5(:),G1H8(3),ngH,m3h1x8(:,2),heltab2x8(:,:,5))
  call Hloop_Q_A(ntryL,G1H8(3),52,nMB,G2H8(2),n2h8(5))
  call Hloop_QS_A(ntryL,G1H8(5),ex5(:),G1H8(13),ngH,m3h1x8(:,3),heltab2x8(:,:,6))
  call Hloop_Q_A(ntryL,G1H8(13),52,nMB,G2H8(3),n2h8(6))
  call Hloop_QS_A(ntryL,G1H8(6),ex5(:),G1H8(1),ngH,m3h1x8(:,4),heltab2x8(:,:,7))
  call Hloop_Q_A(ntryL,G1H8(1),52,nMB,G2H8(4),n2h8(7))
  call Hloop_QZ_A(ntryL,G1H8(7),wf4(:,3),G1H2(1),ngZd,m3h4x2(:,1),heltab2x8(:,:,8))
  call Hloop_Q_A(ntryL,G1H2(1),39,nMB,G2H2(5),n2h2(1))
call HGT_raise_alpha_OLR(G1H8(8),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(8),ex4(:),G1H4(2),m3h2x4(:,4),heltab2x8(:,:,9))
  call Hloop_QZ_A(ntryL,G1H8(10),wf4(:,3),G1H2(1),ngZd,m3h4x2(:,2),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G1H2(1),39,nMB,G2H2(6),n2h2(2))
  call Hloop_QZ_A(ntryL,G1H8(11),wf4(:,3),G1H2(1),ngZd,m3h4x2(:,3),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(1),39,nMB,G2H2(7),n2h2(3))
  call Hloop_QZ_A(ntryL,G1H8(12),wf4(:,3),G1H2(1),ngZd,m3h4x2(:,4),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(1),39,nMB,G2H2(8),n2h2(4))
call Hotf_5pt_reduction(G2H2(1),RedSet_5(5),mass5set(:,3),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
call HG1shiftOLR(G1H2(2),16,2)
call Hotf_5pt_reduction(G2H4(1),RedSet_5(6),mass5set(:,4),  & 
G1H4(7),G1H4(4),G1H4(8),G1H4(10),G1H4(1),G1H4(11),4)
call HG1shiftOLR(G1H4(4),16,4)
call Hotf_5pt_reduction(G2H2(2),RedSet_5(7),mass5set(:,3),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
call HG1shiftOLR(G1H2(8),16,2)
call Hotf_5pt_reduction(G2H4(2),RedSet_5(8),mass5set(:,4),  & 
G1H4(5),G1H4(12),G1H4(13),G1H4(14),G1H4(15),G1H4(16),4)
call HG1shiftOLR(G1H4(12),16,4)
  call Hloop_AQ_V(ntryL,G2H4(3),ex3(:),G2H2(1),m3h2x2(:,5),heltab2x4(:,:,13))
  call Hloop_AQ_V(ntryL,G2H4(5),ex3(:),G2H2(2),m3h2x2(:,6),heltab2x4(:,:,14))
  call Hloop_AQ_V(ntryL,G2H4(6),ex3(:),G2H2(9),m3h2x2(:,7),heltab2x4(:,:,15))
  call Hloop_QA_V(ntryL,G2H4(7),ex4(:),G2H2(10),m3h2x2(:,8),heltab2x4(:,:,16))
  call Hloop_QA_V(ntryL,G2H4(9),ex4(:),G2H2(11),m3h2x2(:,9),heltab2x4(:,:,17))
  call Hloop_QA_V(ntryL,G2H4(10),ex4(:),G2H2(12),m3h2x2(:,10),heltab2x4(:,:,18))
call Hotf_5pt_reduction(G2H8(1),RedSet_5(3),mass5set(:,2),  & 
G1H8(4),G1H8(3),G1H8(5),G1H8(13),G1H8(6),G1H8(1),8)
call HG1shiftOLR(G1H8(3),8,8)
call Hotf_4pt_reduction(G2H8(3),RedSet_4(1),mass4set(:,1),  & 
G1H8(7),G1H8(8),G1H8(10),G1H8(11),G1H8(12),8)
call HG1shiftOLR(G1H8(8),8,8)
call Hotf_4pt_reduction(G2H8(4),RedSet_4(2),mass4set(:,1),  & 
G1H8(14),G1H8(15),G1H8(16),G1H8(17),G1H8(18),8)
call HG1shiftOLR(G1H8(15),11,8)
call Hotf_5pt_reduction(G2H2(5),RedSet_5(4),mass5set(:,2),  & 
G1H2(13),G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
call HG1shiftOLR(G1H2(14),8,2)
call Hotf_4pt_reduction(G2H2(7),RedSet_4(1),mass4set(:,1),  & 
G1H2(19),G1H2(20),G1H2(21),G1H2(22),G1H2(23),2)
call HG1shiftOLR(G1H2(20),8,2)
call Hotf_4pt_reduction(G2H2(8),RedSet_4(3),mass4set(:,1),  & 
G1H2(24),G1H2(25),G1H2(26),G1H2(27),G1H2(28),2)
call HG1shiftOLR(G1H2(25),24,2)
  call ol_merge(ntryL,G1H8(7),[G1H8(6)])
  call ol_merge(ntryL,G1H8(14),[G1H8(1)])
  call ol_merge(ntryL,G1H2(19),[G1H2(17)])
  call ol_merge(ntryL,G1H2(24),[G1H2(18)])
  call Hloop_VQ_A(ntryL,G1H2(1),ex3(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMB,G2H1(1),n2h1(1))
call HGT_OLR(G1H2(2),1,1,2)
call HGT_invQ_OLR(G1H2(2),2,5,2)
  call Hloop_A_Q(ntryL,G1H2(2),-16,nMB,G2H2(5),n2h2(5))
  call Hloop_AS_Q(ntryL,G2H2(5),ex5(:),G2H2(7),ngH,m3h1x2(:,1),heltab2x2(:,:,2))
  call Hloop_VQ_A(ntryL,G1H2(5),ex3(:),G1H1(1),m3h2x1(:,2),heltab2x2(:,:,3))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMB,G2H1(2),n2h1(2))
  call Hloop_VQ_A(ntryL,G1H2(6),ex3(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,4))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMB,G2H1(3),n2h1(3))
  call Hloop_AZ_Q(ntryL,G1H4(7),wf4(:,3),G1H1(1),ngZd,m3h4x1(:,1),heltab2x4(:,:,19))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMB,G2H1(4),n2h1(4))
call HGT_OLR(G1H4(4),1,1,4)
call HGT_invQ_OLR(G1H4(4),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(4),-16,nMB,G2H4(1),n2h4(17))
  call Hloop_QS_A(ntryL,G2H4(1),ex5(:),G2H4(2),ngH,m3h1x4(:,9),heltab2x4(:,:,20))
  call Hloop_AZ_Q(ntryL,G1H4(1),wf4(:,3),G1H1(1),ngZd,m3h4x1(:,2),heltab2x4(:,:,21))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMB,G2H1(5),n2h1(5))
  call Hloop_AZ_Q(ntryL,G1H4(11),wf4(:,3),G1H1(1),ngZd,m3h4x1(:,3),heltab2x4(:,:,22))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMB,G2H1(6),n2h1(6))
  call Hloop_VA_Q(ntryL,G1H2(7),ex4(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,5))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMB,G2H1(7),n2h1(7))
call HGT_OLR(G1H2(8),1,1,2)
call HGT_invQ_OLR(G1H2(8),2,5,2)
  call Hloop_Q_A(ntryL,G1H2(8),-16,nMB,G2H2(8),n2h2(6))
  call Hloop_QS_A(ntryL,G2H2(8),ex5(:),G2H2(5),ngH,m3h1x2(:,2),heltab2x2(:,:,6))
  call Hloop_VA_Q(ntryL,G1H2(11),ex4(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,7))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMB,G2H1(8),n2h1(8))
  call Hloop_VA_Q(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,8))
  call Hloop_A_Q(ntryL,G1H1(1),47,nMB,G2H1(9),n2h1(9))
  call Hloop_QZ_A(ntryL,G1H4(5),wf4(:,3),G1H1(1),ngZd,m3h4x1(:,4),heltab2x4(:,:,23))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMB,G2H1(10),n2h1(10))
call HGT_OLR(G1H4(12),1,1,4)
call HGT_invQ_OLR(G1H4(12),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(12),-16,nMB,G2H4(3),n2h4(18))
  call Hloop_AS_Q(ntryL,G2H4(3),ex5(:),G2H4(5),ngH,m3h1x4(:,10),heltab2x4(:,:,24))
  call Hloop_QZ_A(ntryL,G1H4(15),wf4(:,3),G1H1(1),ngZd,m3h4x1(:,5),heltab2x4(:,:,25))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMB,G2H1(11),n2h1(11))
  call Hloop_QZ_A(ntryL,G1H4(16),wf4(:,3),G1H1(1),ngZd,m3h4x1(:,6),heltab2x4(:,:,26))
  call Hloop_Q_A(ntryL,G1H1(1),47,nMB,G2H1(12),n2h1(12))
  call Hloop_QZ_A(ntryL,G1H8(4),wf4(:,3),G1H2(17),ngZd,m3h4x2(:,5),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(17),55,nMB,G2H2(8),n2h2(7))
call HGT_raise_alpha_OLR(G1H8(3),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(3),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(3),ex4(:),G1H4(7),m3h2x4(:,5),heltab2x8(:,:,14))
  call Hloop_QZ_A(ntryL,G1H8(7),wf4(:,3),G1H2(18),ngZd,m3h4x2(:,6),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(18),55,nMB,G2H2(13),n2h2(8))
  call Hloop_QZ_A(ntryL,G1H8(14),wf4(:,3),G1H2(1),ngZd,m3h4x2(:,7),heltab2x8(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMB,G2H2(14),n2h2(9))
call HGT_raise_alpha_OLR(G1H8(8),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(8),ex4(:),G1H4(4),m3h2x4(:,6),heltab2x8(:,:,17))
  call Hloop_QZ_A(ntryL,G1H8(12),wf4(:,3),G1H2(2),ngZd,m3h4x2(:,8),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G1H2(2),55,nMB,G2H2(15),n2h2(10))
call HGT_raise_alpha_OLR(G1H8(15),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(15),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(15),ex4(:),G1H4(1),m3h2x4(:,7),heltab2x8(:,:,19))
  call Hloop_QZ_A(ntryL,G1H8(18),wf4(:,3),G1H2(5),ngZd,m3h4x2(:,9),heltab2x8(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(5),55,nMB,G2H2(16),n2h2(11))
  call Hloop_QS_A(ntryL,G1H2(13),ex5(:),G1H2(6),ngH,m3h1x2(:,3),heltab2x2(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(6),55,nMB,G2H2(17),n2h2(12))
call HGT_raise_alpha_OLR(G1H2(14),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(14),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(14),ex4(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,10))
  call Hloop_QS_A(ntryL,G1H2(19),ex5(:),G1H2(7),ngH,m3h1x2(:,4),heltab2x2(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(7),55,nMB,G2H2(18),n2h2(14))
  call Hloop_QS_A(ntryL,G1H2(24),ex5(:),G1H2(8),ngH,m3h1x2(:,5),heltab2x2(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(8),55,nMB,G2H2(19),n2h2(15))
call HGT_raise_alpha_OLR(G1H2(20),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(20),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(20),ex4(:),G1H1(2),m3h2x1(:,8),heltab2x2(:,:,13))
  call Hloop_QS_A(ntryL,G1H2(23),ex5(:),G1H2(11),ngH,m3h1x2(:,6),heltab2x2(:,:,14))
  call Hloop_Q_A(ntryL,G1H2(11),55,nMB,G2H2(20),n2h2(17))
call HGT_raise_alpha_OLR(G1H2(25),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(25),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(25),ex4(:),G1H1(3),m3h2x1(:,9),heltab2x2(:,:,15))
  call Hloop_QS_A(ntryL,G1H2(28),ex5(:),G1H2(12),ngH,m3h1x2(:,7),heltab2x2(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(12),55,nMB,G2H2(21),n2h2(19))
call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(17),G1H2(18),G1H2(1),G1H2(2),G1H2(5),G1H2(13),2)
call HG1shiftOLR(G1H2(18),8,2)
call Hotf_4pt_reduction(G2H2(9),RedSet_4(4),mass4set(:,2),  & 
G1H2(6),G1H2(14),G1H2(19),G1H2(7),G1H2(24),2)
call HG1shiftOLR(G1H2(14),12,2)
call Hotf_5pt_reduction(G2H2(10),RedSet_5(2),mass5set(:,1),  & 
G1H2(8),G1H2(20),G1H2(23),G1H2(11),G1H2(25),G1H2(28),2)
call HG1shiftOLR(G1H2(20),4,2)
call Hotf_4pt_reduction(G2H2(12),RedSet_4(4),mass4set(:,2),  & 
G1H2(12),G1H2(29),G1H2(30),G1H2(31),G1H2(32),2)
call HG1shiftOLR(G1H2(29),12,2)
call Hotf_5pt_reduction(G2H1(1),RedSet_5(5),mass5set(:,3),  & 
G1H1(4),G1H1(5),G1H1(6),G1H1(7),G1H1(8),G1H1(9),1)
call HG1shiftOLR(G1H1(5),16,1)
call Hotf_4pt_reduction(G2H1(3),RedSet_4(5),mass4set(:,3),  & 
G1H1(10),G1H1(11),G1H1(12),G1H1(13),G1H1(14),1)
call HG1shiftOLR(G1H1(11),20,1)
call Hotf_5pt_reduction(G2H1(4),RedSet_5(6),mass5set(:,4),  & 
G1H1(15),G1H1(16),G1H1(17),G1H1(18),G1H1(19),G1H1(20),1)
call HG1shiftOLR(G1H1(16),16,1)
call Hotf_4pt_reduction(G2H1(6),RedSet_4(6),mass4set(:,4),  & 
G1H1(21),G1H1(22),G1H1(23),G1H1(24),G1H1(25),1)
call HG1shiftOLR(G1H1(22),19,1)
call Hotf_5pt_reduction(G2H1(7),RedSet_5(7),mass5set(:,3),  & 
G1H1(26),G1H1(27),G1H1(28),G1H1(29),G1H1(30),G1H1(31),1)
call HG1shiftOLR(G1H1(27),16,1)
call Hotf_4pt_reduction(G2H1(9),RedSet_4(7),mass4set(:,3),  & 
G1H1(32),G1H1(33),G1H1(34),G1H1(35),G1H1(36),1)
call HG1shiftOLR(G1H1(33),24,1)
call Hotf_5pt_reduction(G2H1(10),RedSet_5(8),mass5set(:,4),  & 
G1H1(37),G1H1(38),G1H1(39),G1H1(40),G1H1(41),G1H1(42),1)
call HG1shiftOLR(G1H1(38),16,1)
call Hotf_4pt_reduction(G2H1(12),RedSet_4(8),mass4set(:,4),  & 
G1H1(43),G1H1(44),G1H1(45),G1H1(46),G1H1(47),1)
call HG1shiftOLR(G1H1(44),19,1)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(8),ex4(:),G2tensor(1),m3h2x1(:,10),heltab2x2(:,:,17))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(14),ex4(:),G2tensor(2),m3h2x1(:,11),heltab2x2(:,:,18))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(17),ex4(:),G2tensor(3),m3h2x1(:,12),heltab2x2(:,:,19))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(19),ex4(:),G2tensor(4),m3h2x1(:,13),heltab2x2(:,:,20))
  call ol_merge(ntryL,G1H2(6),[G1H2(13)])
  call ol_merge(ntryL,G1H2(12),[G1H2(28)])
  call ol_merge(ntryL,G1H1(10),[G1H1(9)])
  call ol_merge(ntryL,G1H1(21),[G1H1(20)])
  call ol_merge(ntryL,G1H1(32),[G1H1(31)])
  call ol_merge(ntryL,G1H1(43),[G1H1(42)])
  call Hloop_VA_Q(ntryL,G1H2(17),ex4(:),G1H1(9),m3h2x1(:,14),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),63,nMB,G2tensor(5),n2h1(13))
  call Hloop_VA_Q(ntryL,G1H2(18),ex4(:),G1H1(20),m3h2x1(:,15),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(20),8,nMB,G2tensor(6),n2h1(14))
  call Hloop_VA_Q(ntryL,G1H2(6),ex4(:),G1H1(31),m3h2x1(:,16),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(31),63,nMB,G2tensor(7),n2h1(15))
  call Hloop_VA_Q(ntryL,G1H2(14),ex4(:),G1H1(42),m3h2x1(:,17),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),12,nMB,G2tensor(8),n2h1(16))
  call Hloop_VQ_A(ntryL,G1H2(8),ex3(:),G1H1(9),m3h2x1(:,18),heltab2x2(:,:,25))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),63,nMB,G2tensor(9),n2h1(17))
  call Hloop_VQ_A(ntryL,G1H2(20),ex3(:),G1H1(20),m3h2x1(:,19),heltab2x2(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(20),4,nMB,G2tensor(10),n2h1(18))
  call Hloop_VQ_A(ntryL,G1H2(12),ex3(:),G1H1(31),m3h2x1(:,20),heltab2x2(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(31),63,nMB,G2tensor(11),n2h1(19))
  call Hloop_VQ_A(ntryL,G1H2(29),ex3(:),G1H1(42),m3h2x1(:,21),heltab2x2(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),12,nMB,G2tensor(12),n2h1(20))
  call Hloop_QS_A(ntryL,G1H1(4),ex5(:),G1H1(9),ngH,m3h1x1(:,1),heltab2x1(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),63,nMB,G2tensor(13),n2h1(21))
  call Hloop_QS_A(ntryL,G1H1(5),ex5(:),G1H1(20),ngH,m3h1x1(:,2),heltab2x1(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(20),16,nMB,G2tensor(14),n2h1(22))
  call Hloop_QS_A(ntryL,G1H1(10),ex5(:),G1H1(31),ngH,m3h1x1(:,3),heltab2x1(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(31),63,nMB,G2tensor(15),n2h1(23))
  call Hloop_QS_A(ntryL,G1H1(11),ex5(:),G1H1(42),ngH,m3h1x1(:,4),heltab2x1(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(42),20,nMB,G2tensor(16),n2h1(24))
  call Hloop_AS_Q(ntryL,G1H1(15),ex5(:),G1H1(4),ngH,m3h1x1(:,5),heltab2x1(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(4),63,nMB,G2tensor(17),n2h1(25))
  call Hloop_AS_Q(ntryL,G1H1(16),ex5(:),G1H1(9),ngH,m3h1x1(:,6),heltab2x1(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),16,nMB,G2tensor(18),n2h1(26))
  call Hloop_AS_Q(ntryL,G1H1(21),ex5(:),G1H1(5),ngH,m3h1x1(:,7),heltab2x1(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(5),63,nMB,G2tensor(19),n2h1(27))
  call Hloop_AS_Q(ntryL,G1H1(22),ex5(:),G1H1(20),ngH,m3h1x1(:,8),heltab2x1(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(20),19,nMB,G2tensor(20),n2h1(28))
  call Hloop_AS_Q(ntryL,G1H1(26),ex5(:),G1H1(10),ngH,m3h1x1(:,9),heltab2x1(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(10),63,nMB,G2tensor(21),n2h1(29))
  call Hloop_AS_Q(ntryL,G1H1(27),ex5(:),G1H1(31),ngH,m3h1x1(:,10),heltab2x1(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(31),16,nMB,G2tensor(22),n2h1(30))
  call Hloop_AS_Q(ntryL,G1H1(32),ex5(:),G1H1(11),ngH,m3h1x1(:,11),heltab2x1(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(11),63,nMB,G2tensor(23),n2h1(31))
  call Hloop_AS_Q(ntryL,G1H1(33),ex5(:),G1H1(42),ngH,m3h1x1(:,12),heltab2x1(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(42),24,nMB,G2tensor(24),n2h1(32))
  call Hloop_QS_A(ntryL,G1H1(37),ex5(:),G1H1(15),ngH,m3h1x1(:,13),heltab2x1(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(15),63,nMB,G2tensor(25),n2h1(33))
  call Hloop_QS_A(ntryL,G1H1(38),ex5(:),G1H1(4),ngH,m3h1x1(:,14),heltab2x1(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(4),16,nMB,G2tensor(26),n2h1(34))
  call Hloop_QS_A(ntryL,G1H1(43),ex5(:),G1H1(16),ngH,m3h1x1(:,15),heltab2x1(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(16),63,nMB,G2tensor(27),n2h1(35))
  call Hloop_QS_A(ntryL,G1H1(44),ex5(:),G1H1(9),ngH,m3h1x1(:,16),heltab2x1(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),19,nMB,G2tensor(28),n2h1(36))
call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(3),mass5set(:,2),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
call G_TensorShift(G1tensor(2),8)
call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(4),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
call G_TensorShift(G1tensor(8),8)
call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(1),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
call G_TensorShift(G1tensor(14),8)
call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(2),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
call G_TensorShift(G1tensor(20),4)
call Hotf_5pt_reduction_last(G2tensor(13),RedSet_5(5),mass5set(:,3),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
call G_TensorShift(G1tensor(26),16)
call Hotf_5pt_reduction_last(G2tensor(17),RedSet_5(6),mass5set(:,4),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
call G_TensorShift(G1tensor(32),16)
call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(7),mass5set(:,3),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
call G_TensorShift(G1tensor(38),16)
call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(8),mass5set(:,4),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
call G_TensorShift(G1tensor(44),16)
call ol_merge_tensors(T1sum(1),[G1tensor(1)])
call ol_merge_tensors(T1sum(2),[G1tensor(7)])
call ol_merge_tensors(T1sum(3),[G1tensor(13)])
call ol_merge_tensors(T1sum(4),[G1tensor(19)])
call ol_merge_tensors(T1sum(5),[G1tensor(25)])
call ol_merge_tensors(T1sum(6),[G1tensor(31)])
call ol_merge_tensors(T1sum(7),[G1tensor(37)])
call ol_merge_tensors(T1sum(8),[G1tensor(43)])
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(85)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(9),h0tab(:,9),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,12),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,9),heltab2x32(:,:,9))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(1),n2h16(7))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(85)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(10),h0tab(:,10),[32,12,3,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,12),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,10),heltab2x32(:,:,10))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(2),n2h16(8))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(85)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(11),h0tab(:,11),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,12),wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,11),heltab2x32(:,:,11))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(3),n2h16(9))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(85)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(12),h0tab(:,12),[32,12,3,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,12),wf4(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,12),heltab2x32(:,:,12))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(4),n2h16(10))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(85)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(13),h0tab(:,13),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,3),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,13),heltab2x32(:,:,13))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(5),n2h16(11))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(85)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(14),h0tab(:,14),[32,3,12,16],[nMT,nMT,nMT,nMT],4,2,wf4(:,3),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,14),heltab2x32(:,:,14))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(6),n2h16(12))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(85)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(15),h0tab(:,15),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,3),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,15),heltab2x32(:,:,15))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(7),n2h16(13))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(85)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(16),h0tab(:,16),[32,3,12,16],[nMB,nMB,nMB,nMB],4,2,wf4(:,3),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,16),heltab2x32(:,:,16))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(8),n2h16(14))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(85)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(17),h0tab(:,17),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,3),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,17),heltab2x32(:,:,17))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(9),n2h16(15))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(85)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(18),h0tab(:,18),[32,3,16,12],[nMT,nMT,nMT,nMT],4,2,wf4(:,3),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,18),heltab2x32(:,:,18))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(10),n2h16(16))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(85)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(19),h0tab(:,19),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,3),wf4(:,12))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,19),heltab2x32(:,:,19))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(11),n2h16(17))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(85)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(20),h0tab(:,20),[32,3,16,12],[nMB,nMB,nMB,nMB],4,2,wf4(:,3),wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,20),heltab2x32(:,:,20))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(12),n2h16(18))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(21),h0tab(:,21),[32,8,3,20],[0,nMB,nMB,0],4,2,wf4(:,3),wf2(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(13),m3h2x16(:,21),heltab2x32(:,:,21))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(22),h0tab(:,22),[32,3,20,8],[nMB,nMB,0,nMB],4,2,wf4(:,3),wf2(:,2))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,22),heltab2x32(:,:,22))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(14),n2h16(19))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(23),h0tab(:,23),[32,3,8,20],[nMB,nMB,0,nMB],4,2,wf4(:,3),wf2(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,23),heltab2x32(:,:,23))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(15),n2h16(20))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(58)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(24),h0tab(:,24),[32,4,3,24],[0,nMB,nMB,0],4,2,wf4(:,3),wf2(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(16),m3h2x16(:,24),heltab2x32(:,:,24))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(58)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(25),h0tab(:,25),[32,3,24,4],[nMB,nMB,0,nMB],4,2,wf4(:,3),wf2(:,4))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,25),heltab2x32(:,:,25))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(17),n2h16(21))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(58)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(26),h0tab(:,26),[32,3,4,24],[nMB,nMB,0,nMB],4,2,wf4(:,3),wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,26),heltab2x32(:,:,26))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(18),n2h16(22))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(11)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(27),h0tab(:,27),[36,3,16,8],[nMB,nMB,nMB,0],4,2,wf4(:,7),wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,7),G0H8(1),m3h4x8(:,1),heltab2x32(:,:,27))
  call Hloop_Q_A(ntryL,G0H8(1),36,nMB,G1H8(6),n2h8(12))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(11)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(28),h0tab(:,28),[36,8,3,16],[0,nMB,nMB,nMB],4,2,wf4(:,7),wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,7),G0H8(1),m3h4x8(:,2),heltab2x32(:,:,28))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(48)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(29),h0tab(:,29),[40,3,16,4],[nMB,nMB,nMB,0],4,2,wf4(:,4),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,4),G0H8(2),m3h4x8(:,3),heltab2x32(:,:,29))
  call Hloop_A_Q(ntryL,G0H8(2),40,nMB,G1H8(1),n2h8(13))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(48)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(30),h0tab(:,30),[40,4,3,16],[0,nMB,nMB,nMB],4,2,wf4(:,4),wf4(:,3))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,4),G0H8(2),m3h4x8(:,4),heltab2x32(:,:,30))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(31),h0tab(:,31),[32,7,16,8],[0,nMB,nMB,0],4,1,wf8(:,5))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(19),m3h2x16(:,27),heltab2x32(:,:,31))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(32),h0tab(:,32),[32,7,8,16],[nMB,0,nMB,nMB],4,1,wf8(:,5))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,28),heltab2x32(:,:,32))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(20),n2h16(23))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(14)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(33),h0tab(:,33),[32,8,7,16],[nMB,0,nMB,nMB],4,1,wf8(:,5))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,29),heltab2x32(:,:,33))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(21),n2h16(24))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(34),h0tab(:,34),[32,4,16,11],[0,nMB,nMB,0],4,1,wf8(:,3))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(22),m3h2x16(:,30),heltab2x32(:,:,34))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(35),h0tab(:,35),[32,11,4,16],[nMB,0,nMB,nMB],4,1,wf8(:,3))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,31),heltab2x32(:,:,35))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(23),n2h16(25))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(7)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(36),h0tab(:,36),[32,4,11,16],[nMB,0,nMB,nMB],4,1,wf8(:,3))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,32),heltab2x32(:,:,36))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(24),n2h16(26))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(37),h0tab(:,37),[32,4,8,19],[nMB,0,nMB,nMB],4,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,33),heltab2x32(:,:,37))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(25),n2h16(27))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(38),h0tab(:,38),[32,8,4,19],[nMB,0,nMB,nMB],4,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,34),heltab2x32(:,:,38))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(26),n2h16(28))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(39),h0tab(:,39),[32,4,19,8],[0,nMB,nMB,0],4,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(27),m3h2x16(:,35),heltab2x32(:,:,39))
  call ol_merge(ntryL,G1H8(6),[G1H8(9)])
  call Hloop_AS_Q(ntryL,G1H4(3),ex5(:),G1H4(11),ngH,m3h1x4(:,11),heltab2x4(:,:,27))
  call Hloop_A_Q(ntryL,G1H4(11),51,nMB,G2H4(6),n2h4(19))
  call Hloop_QS_A(ntryL,G1H4(9),ex5(:),G1H4(5),ngH,m3h1x4(:,12),heltab2x4(:,:,28))
  call Hloop_Q_A(ntryL,G1H4(5),51,nMB,G2H4(7),n2h4(20))
  call Hloop_QS_A(ntryL,G1H8(2),ex5(:),G1H8(4),ngH,m3h1x8(:,5),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H8(4),52,nMB,G2H8(1),n2h8(14))
  call Hloop_QZ_A(ntryL,G1H8(6),wf4(:,3),G1H2(13),ngZd,m3h4x2(:,10),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G1H2(13),39,nMB,G2H2(1),n2h2(20))
  call Hloop_AV_Q(ntryL,G1H16(1),wf4(:,12),G1H4(12),m3h4x4(:,5),heltab2x16(:,:,9))
  call Hloop_A_Q(ntryL,G1H4(12),44,nMT,G2H4(9),n2h4(21))
  call Hloop_QV_A(ntryL,G1H16(2),wf4(:,12),G1H4(15),m3h4x4(:,6),heltab2x16(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(15),44,nMT,G2H4(10),n2h4(22))
  call Hloop_AV_Q(ntryL,G1H16(3),wf4(:,12),G1H4(16),m3h4x4(:,7),heltab2x16(:,:,11))
  call Hloop_A_Q(ntryL,G1H4(16),44,nMB,G2H4(1),n2h4(23))
  call Hloop_QV_A(ntryL,G1H16(4),wf4(:,12),G1H4(3),m3h4x4(:,8),heltab2x16(:,:,12))
  call Hloop_Q_A(ntryL,G1H4(3),44,nMB,G2H4(3),n2h4(24))
  call Hloop_AZ_Q(ntryL,G1H16(5),wf4(:,3),G1H4(11),ngZu,m3h4x4(:,9),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G1H4(11),35,nMT,G2H4(11),n2h4(25))
  call Hloop_QZ_A(ntryL,G1H16(6),wf4(:,3),G1H4(9),ngZu,m3h4x4(:,10),heltab2x16(:,:,14))
  call Hloop_Q_A(ntryL,G1H4(9),35,nMT,G2H4(12),n2h4(26))
  call Hloop_AZ_Q(ntryL,G1H16(7),wf4(:,3),G1H4(5),ngZd,m3h4x4(:,11),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G1H4(5),35,nMB,G2H4(13),n2h4(27))
  call Hloop_QZ_A(ntryL,G1H16(8),wf4(:,3),G1H4(12),ngZd,m3h4x4(:,12),heltab2x16(:,:,16))
  call Hloop_Q_A(ntryL,G1H4(12),35,nMB,G2H4(14),n2h4(28))
  call Hloop_QZ_A(ntryL,G1H16(9),wf4(:,3),G1H4(15),ngZu,m3h4x4(:,13),heltab2x16(:,:,17))
  call Hloop_Q_A(ntryL,G1H4(15),35,nMT,G2H4(15),n2h4(29))
  call Hloop_AZ_Q(ntryL,G1H16(10),wf4(:,3),G1H4(16),ngZu,m3h4x4(:,14),heltab2x16(:,:,18))
  call Hloop_A_Q(ntryL,G1H4(16),35,nMT,G2H4(16),n2h4(30))
  call Hloop_QZ_A(ntryL,G1H16(11),wf4(:,3),G1H4(3),ngZd,m3h4x4(:,15),heltab2x16(:,:,19))
  call Hloop_Q_A(ntryL,G1H4(3),35,nMB,G2H4(17),n2h4(31))
  call Hloop_AZ_Q(ntryL,G1H16(12),wf4(:,3),G1H4(11),ngZd,m3h4x4(:,16),heltab2x16(:,:,20))
  call Hloop_A_Q(ntryL,G1H4(11),35,nMB,G2H4(18),n2h4(32))
  call Hloop_VA_Q(ntryL,G1H16(13),ex4(:),G1H8(3),m3h2x8(:,5),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G1H8(3),40,nMB,G2H8(3),n2h8(15))
  call Hloop_AZ_Q(ntryL,G1H16(14),wf4(:,3),G1H4(9),ngZd,m3h4x4(:,17),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G1H4(9),35,nMB,G2H4(19),n2h4(33))
  call Hloop_QZ_A(ntryL,G1H16(15),wf4(:,3),G1H4(5),ngZd,m3h4x4(:,18),heltab2x16(:,:,23))
  call Hloop_Q_A(ntryL,G1H4(5),35,nMB,G2H4(20),n2h4(34))
  call Hloop_VQ_A(ntryL,G1H16(16),ex3(:),G1H8(7),m3h2x8(:,6),heltab2x16(:,:,24))
  call Hloop_Q_A(ntryL,G1H8(7),36,nMB,G2H8(4),n2h8(16))
  call Hloop_QZ_A(ntryL,G1H16(17),wf4(:,3),G1H4(12),ngZd,m3h4x4(:,19),heltab2x16(:,:,25))
  call Hloop_Q_A(ntryL,G1H4(12),35,nMB,G2H4(21),n2h4(35))
  call Hloop_AZ_Q(ntryL,G1H16(18),wf4(:,3),G1H4(15),ngZd,m3h4x4(:,20),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G1H4(15),35,nMB,G2H4(22),n2h4(36))
  call Hloop_VA_Q(ntryL,G0H8(1),ex4(:),G0H4(1),m3h2x4(:,8),heltab2x8(:,:,23))
  call Hloop_A_Q(ntryL,G0H4(1),44,nMB,G1H4(16),n2h4(37))
  call Hloop_AZ_Q(ntryL,G1H8(1),wf4(:,3),G1H2(28),ngZd,m3h4x2(:,11),heltab2x8(:,:,24))
  call Hloop_A_Q(ntryL,G1H2(28),43,nMB,G2H2(9),n2h2(21))
  call Hloop_VQ_A(ntryL,G0H8(2),ex3(:),G0H4(1),m3h2x4(:,9),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G0H4(1),44,nMB,G1H4(3),n2h4(38))
  call Hloop_VQ_A(ntryL,G1H16(19),wf8(:,5),G1H2(17),m3h8x2(:,1),heltab2x16(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(17),39,nMB,G2H2(10),n2h2(22))
  call Hloop_AQ_V(ntryL,G1H16(20),wf8(:,5),G1H2(18),m3h8x2(:,2),heltab2x16(:,:,28))
  call Hloop_QA_V(ntryL,G1H16(21),ex4(:),G1H8(14),m3h2x8(:,7),heltab2x16(:,:,29))
  call Hloop_VQ_A(ntryL,G1H16(22),ex3(:),G1H8(8),m3h2x8(:,8),heltab2x16(:,:,30))
  call Hloop_Q_A(ntryL,G1H8(8),36,nMB,G2H8(5),n2h8(17))
  call Hloop_QA_V(ntryL,G1H16(23),wf8(:,3),G1H2(6),m3h8x2(:,3),heltab2x16(:,:,31))
  call Hloop_AQ_V(ntryL,G1H16(24),ex3(:),G1H8(12),m3h2x8(:,9),heltab2x16(:,:,32))
  call Hloop_AQ_V(ntryL,G1H16(25),ex3(:),G1H8(15),m3h2x8(:,10),heltab2x16(:,:,33))
  call Hloop_QA_V(ntryL,G1H16(26),ex4(:),G1H8(18),m3h2x8(:,11),heltab2x16(:,:,34))
  call Hloop_VQ_A(ntryL,G1H16(27),ex3(:),G1H8(9),m3h2x8(:,12),heltab2x16(:,:,35))
  call Hloop_Q_A(ntryL,G1H8(9),36,nMB,G2H8(6),n2h8(18))
call HGT_lower_alpha_w2_OLR(G2H2(3),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(3),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(3),6,15,2)
  call ol_merge(ntryL,G2H2(3),[G2H2(9)])
  call ol_merge(ntryL,G2H2(1),[G1H2(15)])
call HGT_lower_alpha_w2_OLR(G2H2(4),1,1,2)
call HGT_lower_alpha_w2_invQ_OLR(G2H2(4),2,5,2)
call HGT_lower_alpha_w2_OLR(G2H2(4),6,15,2)
  call ol_merge(ntryL,G2H2(4),[G2H2(1)])
  call ol_merge(ntryL,G2H8(2),[G1H8(13)])
  call ol_merge(ntryL,G1H4(3),[G1H4(13)])
call HGT_w2_OLR(G1H4(2),1,1,4)
call HGT_w2_invQ_OLR(G1H4(2),2,5,4)
  call ol_merge(ntryL,G1H4(2),[G1H4(3)])
  call ol_merge(ntryL,G2H2(10),[G2H2(6),G1H2(16)])
  call ol_merge(ntryL,G1H2(6),[G1H2(4)])
  call ol_merge(ntryL,G1H4(16),[G1H4(8)])
  call ol_merge(ntryL,G2H4(1),[G1H4(10)])
  call ol_merge(ntryL,G1H2(18),[G1H2(10)])
  call ol_merge(ntryL,G2H4(3),[G1H4(14)])
  call ol_merge(ntryL,G2H8(1),[G1H8(5)])
call Hotf_4pt_reduction(G2H2(3),RedSet_4(37),mass4set(:,5),  & 
G1H2(14),G1H2(8),G1H2(20),G1H2(12),G1H2(29),2)
call HG1shiftOLR(G1H2(8),4,2)
  call Hloop_AQ_V(ntryL,G2H4(4),ex3(:),G2H2(12),m3h2x2(:,11),heltab2x4(:,:,29))
call Hotf_4pt_reduction(G2H2(4),RedSet_4(12),mass4set(:,5),  & 
G1H2(13),G1H2(28),G1H2(17),G1H2(15),G1H2(16),2)
call HG1shiftOLR(G1H2(28),8,2)
  call Hloop_QA_V(ntryL,G2H4(8),ex4(:),G2H2(8),m3h2x2(:,12),heltab2x4(:,:,30))
call HGT_w2_OLR(G1H4(6),1,1,4)
call HGT_w2_invQ_OLR(G1H4(6),2,5,4)
  call Hloop_QS_A(ntryL,G1H4(6),ex5(:),G1H4(11),ngH,m3h1x4(:,13),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H4(11),60,nMB,G2H4(4),n2h4(39))
call Hotf_4pt_reduction(G2H8(2),RedSet_4(10),mass4set(:,1),  & 
G1H8(2),G1H8(4),G1H8(6),G1H8(3),G1H8(7),8)
call HG1shiftOLR(G1H8(4),8,8)
  call Hloop_QZ_A(ntryL,G1H4(2),wf4(:,3),G1H1(21),ngZd,m3h4x1(:,7),heltab2x4(:,:,32))
  call Hloop_Q_A(ntryL,G1H1(21),47,nMB,G2H1(1),n2h1(37))
call Hotf_4pt_reduction(G2H2(10),RedSet_4(13),mass4set(:,1),  & 
G1H2(4),G1H2(10),G1H2(33),G1H2(34),G1H2(35),2)
call HG1shiftOLR(G1H2(10),8,2)
  call Hloop_VQ_A(ntryL,G1H2(3),ex3(:),G1H1(5),m3h2x1(:,22),heltab2x2(:,:,29))
  call Hloop_Q_A(ntryL,G1H1(5),47,nMB,G2H1(3),n2h1(38))
  call Hloop_VQ_A(ntryL,G1H2(6),ex3(:),G1H1(22),m3h2x1(:,23),heltab2x2(:,:,30))
  call Hloop_Q_A(ntryL,G1H1(22),47,nMB,G2H1(4),n2h1(39))
  call Hloop_AZ_Q(ntryL,G1H4(16),wf4(:,3),G1H1(20),ngZd,m3h4x1(:,8),heltab2x4(:,:,33))
  call Hloop_A_Q(ntryL,G1H1(20),47,nMB,G2H1(6),n2h1(40))
call Hotf_4pt_reduction(G2H4(1),RedSet_4(28),mass4set(:,2),  & 
G1H4(9),G1H4(5),G1H4(12),G1H4(15),G1H4(13),G0H4(1),4)
call HG1shiftOLR(G1H4(5),16,4)
  call Hloop_VA_Q(ntryL,G1H2(9),ex4(:),G1H1(26),m3h2x1(:,24),heltab2x2(:,:,31))
  call Hloop_A_Q(ntryL,G1H1(26),47,nMB,G2H1(7),n2h1(41))
  call Hloop_VA_Q(ntryL,G1H2(18),ex4(:),G1H1(10),m3h2x1(:,25),heltab2x2(:,:,32))
  call Hloop_A_Q(ntryL,G1H1(10),47,nMB,G2H1(9),n2h1(42))
call Hotf_4pt_reduction(G2H4(3),RedSet_4(28),mass4set(:,2),  & 
G1H4(3),G1H4(8),G1H4(10),G1H4(14),G1H4(6),G0H4(2),4)
call HG1shiftOLR(G1H4(8),16,4)
call Hotf_4pt_reduction(G2H8(1),RedSet_4(9),mass4set(:,5),  & 
G1H8(1),G1H8(8),G1H8(9),G1H8(13),G1H8(5),8)
call HG1shiftOLR(G1H8(8),8,8)
  call Hloop_QZ_A(ntryL,G1H8(10),wf4(:,3),G1H2(3),ngZd,m3h4x2(:,12),heltab2x8(:,:,26))
  call Hloop_Q_A(ntryL,G1H2(3),55,nMB,G2H2(14),n2h2(23))
  call Hloop_QZ_A(ntryL,G1H8(11),wf4(:,3),G1H2(6),ngZd,m3h4x2(:,13),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(6),55,nMB,G2H2(17),n2h2(24))
  call Hloop_QZ_A(ntryL,G1H8(16),wf4(:,3),G1H2(9),ngZd,m3h4x2(:,14),heltab2x8(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(9),55,nMB,G2H2(19),n2h2(25))
  call Hloop_QZ_A(ntryL,G1H8(17),wf4(:,3),G1H2(18),ngZd,m3h4x2(:,15),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(18),55,nMB,G2H2(9),n2h2(26))
  call Hloop_QS_A(ntryL,G1H2(21),ex5(:),G1H2(3),ngH,m3h1x2(:,8),heltab2x2(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(3),55,nMB,G2H2(1),n2h2(27))
  call Hloop_QS_A(ntryL,G1H2(22),ex5(:),G1H2(6),ngH,m3h1x2(:,9),heltab2x2(:,:,34))
  call Hloop_Q_A(ntryL,G1H2(6),55,nMB,G2H2(6),n2h2(28))
  call Hloop_QS_A(ntryL,G1H2(26),ex5(:),G1H2(9),ngH,m3h1x2(:,10),heltab2x2(:,:,35))
  call Hloop_Q_A(ntryL,G1H2(9),55,nMB,G2H2(3),n2h2(29))
  call Hloop_QS_A(ntryL,G1H2(27),ex5(:),G1H2(18),ngH,m3h1x2(:,11),heltab2x2(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(18),55,nMB,G2H2(4),n2h2(30))
  call Hloop_AQ_V(ntryL,G2H4(6),ex3(:),G2H2(10),m3h2x2(:,13),heltab2x4(:,:,34))
  call Hloop_QA_V(ntryL,G2H4(7),ex4(:),G2H2(22),m3h2x2(:,14),heltab2x4(:,:,35))
call Hotf_4pt_reduction(G2H4(9),RedSet_4(28),mass4set(:,6),  & 
G1H4(11),G1H4(2),G1H4(16),G1H4(17),G1H4(18),G0H4(3),4)
call HG1shiftOLR(G1H4(2),16,4)
call Hotf_4pt_reduction(G2H4(10),RedSet_4(28),mass4set(:,6),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G0H4(4),4)
call HG1shiftOLR(G1H4(20),16,4)
call Hotf_4pt_reduction(G2H4(11),RedSet_4(25),mass4set(:,6),  & 
G1H4(24),G1H4(25),G1H4(26),G1H4(27),G1H4(28),G0H4(5),4)
call HG1shiftOLR(G1H4(25),16,4)
call Hotf_4pt_reduction(G2H4(12),RedSet_4(25),mass4set(:,6),  & 
G1H4(29),G1H4(30),G1H4(31),G1H4(32),G1H4(33),G0H4(6),4)
call HG1shiftOLR(G1H4(30),16,4)
call Hotf_4pt_reduction(G2H4(13),RedSet_4(25),mass4set(:,2),  & 
G1H4(34),G1H4(35),G1H4(36),G1H4(37),G1H4(38),G0H4(7),4)
call HG1shiftOLR(G1H4(35),16,4)
call Hotf_4pt_reduction(G2H4(14),RedSet_4(25),mass4set(:,2),  & 
G1H4(39),G1H4(40),G1H4(41),G1H4(42),G1H4(43),G0H4(8),4)
call HG1shiftOLR(G1H4(40),16,4)
call Hotf_4pt_reduction(G2H4(15),RedSet_4(4),mass4set(:,6),  & 
G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),G0H4(9),4)
call HG1shiftOLR(G1H4(45),12,4)
call Hotf_4pt_reduction(G2H4(16),RedSet_4(4),mass4set(:,6),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G0H4(10),4)
call HG1shiftOLR(G1H4(50),12,4)
call Hotf_4pt_reduction(G2H4(17),RedSet_4(4),mass4set(:,2),  & 
G1H4(54),G1H4(55),G1H4(56),G1H4(57),G1H4(58),G0H4(11),4)
call HG1shiftOLR(G1H4(55),12,4)
call Hotf_4pt_reduction(G2H4(18),RedSet_4(4),mass4set(:,2),  & 
G1H4(59),G1H4(60),G1H4(61),G1H4(62),G1H4(63),G0H4(12),4)
call HG1shiftOLR(G1H4(60),12,4)
call Hotf_4pt_reduction(G2H8(3),RedSet_4(38),mass4set(:,1),  & 
G1H8(10),G1H8(11),G1H8(16),G1H8(17),G1H8(19),8)
call HG1shiftOLR(G1H8(11),20,8)
  call Hloop_AQ_V(ntryL,G2H4(19),wf2(:,2),G2H2(23),m3h2x2(:,15),heltab2x4(:,:,36))
  call Hloop_QA_V(ntryL,G2H4(20),ex4(:),G2H2(24),m3h2x2(:,16),heltab2x4(:,:,37))
call Hotf_4pt_reduction(G2H8(4),RedSet_4(3),mass4set(:,1),  & 
G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
call HG1shiftOLR(G1H8(21),24,8)
  call Hloop_QA_V(ntryL,G2H4(21),wf2(:,4),G2H2(25),m3h2x2(:,17),heltab2x4(:,:,38))
  call Hloop_AQ_V(ntryL,G2H4(22),ex3(:),G2H2(26),m3h2x2(:,18),heltab2x4(:,:,39))
  call Hloop_VQ_A(ntryL,G1H8(14),wf8(:,5),G1H1(27),m3h8x1(:,1),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G1H1(27),47,nMB,G2H1(10),n2h1(43))
call Hotf_4pt_reduction(G2H8(5),RedSet_4(2),mass4set(:,1),  & 
G1H8(14),G1H8(25),G1H8(26),G1H8(27),G1H8(28),8)
call HG1shiftOLR(G1H8(25),11,8)
  call Hloop_VA_Q(ntryL,G1H8(12),wf8(:,3),G1H1(31),m3h8x1(:,2),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G1H1(31),47,nMB,G2H1(12),n2h1(44))
  call Hloop_VA_Q(ntryL,G1H8(15),ex4(:),G1H4(64),m3h2x4(:,10),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G1H4(64),44,nMB,G2H4(8),n2h4(40))
  call Hloop_VQ_A(ntryL,G1H8(18),ex3(:),G1H4(64),m3h2x4(:,11),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G1H4(64),44,nMB,G2H4(1),n2h4(41))
call Hotf_4pt_reduction(G2H8(6),RedSet_4(1),mass4set(:,1),  & 
G1H8(12),G1H8(15),G1H8(18),G1H8(29),G1H8(30),8)
call HG1shiftOLR(G1H8(15),8,8)
  call Hloop_AS_Q(ntryL,G1H2(14),ex5(:),G1H2(21),ngH,m3h1x2(:,12),heltab2x2(:,:,37))
  call Hloop_A_Q(ntryL,G1H2(21),59,nMB,G2H2(27),n2h2(31))
call HGT_raise_alpha_OLR(G1H2(8),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(8),2,5,2)
  call Hloop_VQ_A(ntryL,G1H2(8),ex3(:),G1H1(32),m3h2x1(:,26),heltab2x2(:,:,38))
  call Hloop_AS_Q(ntryL,G1H2(12),ex5(:),G1H2(3),ngH,m3h1x2(:,13),heltab2x2(:,:,39))
  call Hloop_A_Q(ntryL,G1H2(3),59,nMB,G2H2(28),n2h2(33))
  call Hloop_AS_Q(ntryL,G1H2(29),ex5(:),G1H2(22),ngH,m3h1x2(:,14),heltab2x2(:,:,40))
  call Hloop_A_Q(ntryL,G1H2(22),59,nMB,G2H2(29),n2h2(34))
  call Hloop_QS_A(ntryL,G1H2(13),ex5(:),G1H2(6),ngH,m3h1x2(:,15),heltab2x2(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(6),55,nMB,G2H2(30),n2h2(35))
call HGT_raise_alpha_OLR(G1H2(28),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(28),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(28),ex4(:),G1H1(11),m3h2x1(:,27),heltab2x2(:,:,42))
  call Hloop_QS_A(ntryL,G1H2(15),ex5(:),G1H2(26),ngH,m3h1x2(:,16),heltab2x2(:,:,43))
  call Hloop_Q_A(ntryL,G1H2(26),55,nMB,G2H2(31),n2h2(37))
  call Hloop_QS_A(ntryL,G1H2(16),ex5(:),G1H2(9),ngH,m3h1x2(:,17),heltab2x2(:,:,44))
  call Hloop_Q_A(ntryL,G1H2(9),55,nMB,G2H2(32),n2h2(38))
  call Hloop_QZ_A(ntryL,G1H8(2),wf4(:,3),G1H2(27),ngZd,m3h4x2(:,16),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G1H2(27),55,nMB,G2H2(33),n2h2(39))
call HGT_raise_alpha_OLR(G1H8(4),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(4),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(4),ex4(:),G1H4(64),m3h2x4(:,12),heltab2x8(:,:,35))
  call Hloop_QZ_A(ntryL,G1H8(3),wf4(:,3),G1H2(18),ngZd,m3h4x2(:,17),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G1H2(18),55,nMB,G2H2(34),n2h2(40))
  call Hloop_QZ_A(ntryL,G1H8(7),wf4(:,3),G1H2(14),ngZd,m3h4x2(:,18),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(14),55,nMB,G2H2(35),n2h2(41))
  call Hloop_QS_A(ntryL,G1H2(4),ex5(:),G1H2(21),ngH,m3h1x2(:,18),heltab2x2(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(21),55,nMB,G2H2(36),n2h2(42))
call HGT_raise_alpha_OLR(G1H2(10),1,1,2)
call HGT_raise_alpha_invQ_OLR(G1H2(10),2,5,2)
  call Hloop_VA_Q(ntryL,G1H2(10),ex4(:),G1H1(33),m3h2x1(:,28),heltab2x2(:,:,46))
  call Hloop_QS_A(ntryL,G1H2(34),ex5(:),G1H2(8),ngH,m3h1x2(:,19),heltab2x2(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(8),55,nMB,G2H2(37),n2h2(44))
  call Hloop_QS_A(ntryL,G1H2(35),ex5(:),G1H2(12),ngH,m3h1x2(:,20),heltab2x2(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(12),55,nMB,G2H2(38),n2h2(45))
  call Hloop_AZ_Q(ntryL,G1H4(9),wf4(:,3),G1H1(42),ngZd,m3h4x1(:,9),heltab2x4(:,:,40))
  call Hloop_A_Q(ntryL,G1H1(42),47,nMB,G2H1(13),n2h1(45))
call HGT_OLR(G1H4(5),1,1,4)
call HGT_invQ_OLR(G1H4(5),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(5),-16,nMB,G2H4(3),n2h4(42))
  call Hloop_QS_A(ntryL,G2H4(3),ex5(:),G2H4(6),ngH,m3h1x4(:,14),heltab2x4(:,:,41))
  call Hloop_AZ_Q(ntryL,G1H4(15),wf4(:,3),G1H1(37),ngZd,m3h4x1(:,10),heltab2x4(:,:,42))
  call Hloop_A_Q(ntryL,G1H1(37),47,nMB,G2H1(14),n2h1(46))
  call Hloop_AZ_Q(ntryL,G1H4(13),wf4(:,3),G1H1(15),ngZd,m3h4x1(:,11),heltab2x4(:,:,43))
  call Hloop_A_Q(ntryL,G1H1(15),47,nMB,G2H1(15),n2h1(47))
  call Hloop_AZ_Q(ntryL,G0H4(1),wf4(:,3),G0H1(1),ngZd,m3h4x1(:,12),heltab2x4(:,:,44))
  call Hloop_A_Q(ntryL,G0H1(1),47,nMB,G1H1(38),n2h1(48))
  call Hloop_QZ_A(ntryL,G1H4(3),wf4(:,3),G1H1(4),ngZd,m3h4x1(:,13),heltab2x4(:,:,45))
  call Hloop_Q_A(ntryL,G1H1(4),47,nMB,G2H1(16),n2h1(49))
call HGT_OLR(G1H4(8),1,1,4)
call HGT_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(8),-16,nMB,G2H4(7),n2h4(43))
  call Hloop_AS_Q(ntryL,G2H4(7),ex5(:),G2H4(9),ngH,m3h1x4(:,15),heltab2x4(:,:,46))
  call Hloop_QZ_A(ntryL,G1H4(14),wf4(:,3),G1H1(43),ngZd,m3h4x1(:,14),heltab2x4(:,:,47))
  call Hloop_Q_A(ntryL,G1H1(43),47,nMB,G2H1(17),n2h1(50))
  call Hloop_QZ_A(ntryL,G1H4(6),wf4(:,3),G1H1(16),ngZd,m3h4x1(:,15),heltab2x4(:,:,48))
  call Hloop_Q_A(ntryL,G1H1(16),47,nMB,G2H1(18),n2h1(51))
  call Hloop_QZ_A(ntryL,G0H4(2),wf4(:,3),G0H1(1),ngZd,m3h4x1(:,16),heltab2x4(:,:,49))
  call Hloop_Q_A(ntryL,G0H1(1),47,nMB,G1H1(44),n2h1(52))
  call Hloop_QZ_A(ntryL,G1H8(1),wf4(:,3),G1H2(3),ngZd,m3h4x2(:,19),heltab2x8(:,:,38))
  call Hloop_Q_A(ntryL,G1H2(3),55,nMB,G2H2(39),n2h2(46))
call HGT_raise_alpha_OLR(G1H8(8),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(8),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(8),ex4(:),G1H4(9),m3h2x4(:,13),heltab2x8(:,:,39))
  call Hloop_QZ_A(ntryL,G1H8(13),wf4(:,3),G1H2(29),ngZd,m3h4x2(:,20),heltab2x8(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(29),55,nMB,G2H2(40),n2h2(47))
  call Hloop_QZ_A(ntryL,G1H8(5),wf4(:,3),G1H2(22),ngZd,m3h4x2(:,21),heltab2x8(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(22),55,nMB,G2H2(41),n2h2(48))
  call Hloop_AZ_Q(ntryL,G1H4(11),wf4(:,3),G1H1(9),ngZu,m3h4x1(:,17),heltab2x4(:,:,50))
  call Hloop_A_Q(ntryL,G1H1(9),47,nMT,G2H1(19),n2h1(53))
call HGT_OLR(G1H4(2),1,1,4)
call HGT_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(2),-16,nMT,G2H4(10),n2h4(44))
  call Hloop_QS_A(ntryL,G2H4(10),ex5(:),G2H4(11),ngH,m3h1x4(:,16),heltab2x4(:,:,51))
  call Hloop_AZ_Q(ntryL,G1H4(17),wf4(:,3),G1H1(21),ngZu,m3h4x1(:,18),heltab2x4(:,:,52))
  call Hloop_A_Q(ntryL,G1H1(21),47,nMT,G2H1(20),n2h1(54))
  call Hloop_AZ_Q(ntryL,G1H4(18),wf4(:,3),G1H1(5),ngZu,m3h4x1(:,19),heltab2x4(:,:,53))
  call Hloop_A_Q(ntryL,G1H1(5),47,nMT,G2H1(21),n2h1(55))
  call Hloop_AZ_Q(ntryL,G0H4(3),wf4(:,3),G0H1(1),ngZu,m3h4x1(:,20),heltab2x4(:,:,54))
  call Hloop_A_Q(ntryL,G0H1(1),47,nMT,G1H1(22),n2h1(56))
  call Hloop_QZ_A(ntryL,G1H4(19),wf4(:,3),G1H1(20),ngZu,m3h4x1(:,21),heltab2x4(:,:,55))
  call Hloop_Q_A(ntryL,G1H1(20),47,nMT,G2H1(22),n2h1(57))
call HGT_OLR(G1H4(20),1,1,4)
call HGT_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(20),-16,nMT,G2H4(12),n2h4(45))
  call Hloop_AS_Q(ntryL,G2H4(12),ex5(:),G2H4(13),ngH,m3h1x4(:,17),heltab2x4(:,:,56))
  call Hloop_QZ_A(ntryL,G1H4(22),wf4(:,3),G1H1(26),ngZu,m3h4x1(:,22),heltab2x4(:,:,57))
  call Hloop_Q_A(ntryL,G1H1(26),47,nMT,G2H1(23),n2h1(58))
  call Hloop_QZ_A(ntryL,G1H4(23),wf4(:,3),G1H1(10),ngZu,m3h4x1(:,23),heltab2x4(:,:,58))
  call Hloop_Q_A(ntryL,G1H1(10),47,nMT,G2H1(24),n2h1(59))
  call Hloop_QZ_A(ntryL,G0H4(4),wf4(:,3),G0H1(1),ngZu,m3h4x1(:,24),heltab2x4(:,:,59))
  call Hloop_Q_A(ntryL,G0H1(1),47,nMT,G1H1(27),n2h1(60))
  call Hloop_AV_Q(ntryL,G1H4(24),wf4(:,12),G1H1(31),m3h4x1(:,25),heltab2x4(:,:,60))
  call Hloop_A_Q(ntryL,G1H1(31),47,nMT,G2H1(25),n2h1(61))
call HGT_OLR(G1H4(25),1,1,4)
call HGT_invQ_OLR(G1H4(25),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(25),-16,nMT,G2H4(14),n2h4(46))
  call Hloop_QS_A(ntryL,G2H4(14),ex5(:),G2H4(15),ngH,m3h1x4(:,18),heltab2x4(:,:,61))
  call Hloop_AV_Q(ntryL,G1H4(27),wf4(:,12),G1H1(42),m3h4x1(:,26),heltab2x4(:,:,62))
  call Hloop_A_Q(ntryL,G1H1(42),47,nMT,G2H1(26),n2h1(62))
  call Hloop_AV_Q(ntryL,G1H4(28),wf4(:,12),G1H1(37),m3h4x1(:,27),heltab2x4(:,:,63))
  call Hloop_A_Q(ntryL,G1H1(37),47,nMT,G2H1(27),n2h1(63))
  call Hloop_AV_Q(ntryL,G0H4(5),wf4(:,12),G0H1(1),m3h4x1(:,28),heltab2x4(:,:,64))
  call Hloop_A_Q(ntryL,G0H1(1),47,nMT,G1H1(15),n2h1(64))
  call Hloop_QV_A(ntryL,G1H4(29),wf4(:,12),G1H1(4),m3h4x1(:,29),heltab2x4(:,:,65))
  call Hloop_Q_A(ntryL,G1H1(4),47,nMT,G2H1(28),n2h1(65))
call HGT_OLR(G1H4(30),1,1,4)
call HGT_invQ_OLR(G1H4(30),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(30),-16,nMT,G2H4(16),n2h4(47))
  call Hloop_AS_Q(ntryL,G2H4(16),ex5(:),G2H4(17),ngH,m3h1x4(:,19),heltab2x4(:,:,66))
  call Hloop_QV_A(ntryL,G1H4(32),wf4(:,12),G1H1(43),m3h4x1(:,30),heltab2x4(:,:,67))
  call Hloop_Q_A(ntryL,G1H1(43),47,nMT,G2H1(29),n2h1(66))
  call Hloop_QV_A(ntryL,G1H4(33),wf4(:,12),G1H1(16),m3h4x1(:,31),heltab2x4(:,:,68))
  call Hloop_Q_A(ntryL,G1H1(16),47,nMT,G2H1(30),n2h1(67))
  call Hloop_QV_A(ntryL,G0H4(6),wf4(:,12),G0H1(1),m3h4x1(:,32),heltab2x4(:,:,69))
  call Hloop_Q_A(ntryL,G0H1(1),47,nMT,G1H1(9),n2h1(68))
  call Hloop_AV_Q(ntryL,G1H4(34),wf4(:,12),G1H1(21),m3h4x1(:,33),heltab2x4(:,:,70))
  call Hloop_A_Q(ntryL,G1H1(21),47,nMB,G2H1(31),n2h1(69))
call HGT_OLR(G1H4(35),1,1,4)
call HGT_invQ_OLR(G1H4(35),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(35),-16,nMB,G2H4(18),n2h4(48))
  call Hloop_QS_A(ntryL,G2H4(18),ex5(:),G2H4(19),ngH,m3h1x4(:,20),heltab2x4(:,:,71))
  call Hloop_AV_Q(ntryL,G1H4(37),wf4(:,12),G1H1(5),m3h4x1(:,34),heltab2x4(:,:,72))
  call Hloop_A_Q(ntryL,G1H1(5),47,nMB,G2H1(32),n2h1(70))
  call Hloop_AV_Q(ntryL,G1H4(38),wf4(:,12),G1H1(20),m3h4x1(:,35),heltab2x4(:,:,73))
  call Hloop_A_Q(ntryL,G1H1(20),47,nMB,G2H1(33),n2h1(71))
  call Hloop_AV_Q(ntryL,G0H4(7),wf4(:,12),G0H1(1),m3h4x1(:,36),heltab2x4(:,:,74))
  call Hloop_A_Q(ntryL,G0H1(1),47,nMB,G1H1(26),n2h1(72))
  call Hloop_QV_A(ntryL,G1H4(39),wf4(:,12),G1H1(10),m3h4x1(:,37),heltab2x4(:,:,75))
  call Hloop_Q_A(ntryL,G1H1(10),47,nMB,G2H1(34),n2h1(73))
call HGT_OLR(G1H4(40),1,1,4)
call HGT_invQ_OLR(G1H4(40),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(40),-16,nMB,G2H4(20),n2h4(49))
  call Hloop_AS_Q(ntryL,G2H4(20),ex5(:),G2H4(21),ngH,m3h1x4(:,21),heltab2x4(:,:,76))
  call Hloop_QV_A(ntryL,G1H4(42),wf4(:,12),G1H1(31),m3h4x1(:,38),heltab2x4(:,:,77))
  call Hloop_Q_A(ntryL,G1H1(31),47,nMB,G2H1(35),n2h1(74))
  call Hloop_QV_A(ntryL,G1H4(43),wf4(:,12),G1H1(42),m3h4x1(:,39),heltab2x4(:,:,78))
  call Hloop_Q_A(ntryL,G1H1(42),47,nMB,G2H1(36),n2h1(75))
  call Hloop_QV_A(ntryL,G0H4(8),wf4(:,12),G0H1(1),m3h4x1(:,40),heltab2x4(:,:,79))
  call Hloop_Q_A(ntryL,G0H1(1),47,nMB,G1H1(37),n2h1(76))
  call Hloop_QS_A(ntryL,G1H4(44),ex5(:),G1H4(5),ngH,m3h1x4(:,22),heltab2x4(:,:,80))
  call Hloop_Q_A(ntryL,G1H4(5),51,nMT,G2H4(22),n2h4(50))
call HGT_OLR(G1H4(45),1,1,4)
call HGT_invQ_OLR(G1H4(45),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(45),-12,nMT,G2H4(3),n2h4(51))
  call Hloop_AV_Q(ntryL,G2H4(3),wf4(:,12),G2H1(37),m3h4x1(:,41),heltab2x4(:,:,81))
  call Hloop_QS_A(ntryL,G1H4(47),ex5(:),G1H4(15),ngH,m3h1x4(:,23),heltab2x4(:,:,82))
  call Hloop_Q_A(ntryL,G1H4(15),51,nMT,G2H4(7),n2h4(52))
  call Hloop_QS_A(ntryL,G1H4(48),ex5(:),G1H4(13),ngH,m3h1x4(:,24),heltab2x4(:,:,83))
  call Hloop_Q_A(ntryL,G1H4(13),51,nMT,G2H4(10),n2h4(53))
  call Hloop_QS_A(ntryL,G0H4(9),ex5(:),G0H4(1),ngH,m3h1x4(:,25),heltab2x4(:,:,84))
  call Hloop_Q_A(ntryL,G0H4(1),51,nMT,G1H4(3),n2h4(54))
  call Hloop_AS_Q(ntryL,G1H4(49),ex5(:),G1H4(8),ngH,m3h1x4(:,26),heltab2x4(:,:,85))
  call Hloop_A_Q(ntryL,G1H4(8),51,nMT,G2H4(12),n2h4(55))
call HGT_OLR(G1H4(50),1,1,4)
call HGT_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(50),-12,nMT,G2H4(14),n2h4(56))
  call Hloop_QV_A(ntryL,G2H4(14),wf4(:,12),G2H1(38),m3h4x1(:,42),heltab2x4(:,:,86))
  call Hloop_AS_Q(ntryL,G1H4(52),ex5(:),G1H4(14),ngH,m3h1x4(:,27),heltab2x4(:,:,87))
  call Hloop_A_Q(ntryL,G1H4(14),51,nMT,G2H4(16),n2h4(57))
  call Hloop_AS_Q(ntryL,G1H4(53),ex5(:),G1H4(6),ngH,m3h1x4(:,28),heltab2x4(:,:,88))
  call Hloop_A_Q(ntryL,G1H4(6),51,nMT,G2H4(18),n2h4(58))
  call Hloop_AS_Q(ntryL,G0H4(10),ex5(:),G0H4(2),ngH,m3h1x4(:,29),heltab2x4(:,:,89))
  call Hloop_A_Q(ntryL,G0H4(2),51,nMT,G1H4(11),n2h4(59))
  call Hloop_QS_A(ntryL,G1H4(54),ex5(:),G1H4(2),ngH,m3h1x4(:,30),heltab2x4(:,:,90))
  call Hloop_Q_A(ntryL,G1H4(2),51,nMB,G2H4(20),n2h4(60))
call HGT_OLR(G1H4(55),1,1,4)
call HGT_invQ_OLR(G1H4(55),2,5,4)
  call Hloop_A_Q(ntryL,G1H4(55),-12,nMB,G2H4(3),n2h4(61))
  call Hloop_AV_Q(ntryL,G2H4(3),wf4(:,12),G2H1(39),m3h4x1(:,43),heltab2x4(:,:,91))
  call Hloop_QS_A(ntryL,G1H4(57),ex5(:),G1H4(17),ngH,m3h1x4(:,31),heltab2x4(:,:,92))
  call Hloop_Q_A(ntryL,G1H4(17),51,nMB,G2H4(14),n2h4(62))
  call Hloop_QS_A(ntryL,G1H4(58),ex5(:),G1H4(18),ngH,m3h1x4(:,32),heltab2x4(:,:,93))
  call Hloop_Q_A(ntryL,G1H4(18),51,nMB,G2H4(3),n2h4(63))
  call Hloop_QS_A(ntryL,G0H4(11),ex5(:),G0H4(3),ngH,m3h1x4(:,33),heltab2x4(:,:,94))
  call Hloop_Q_A(ntryL,G0H4(3),51,nMB,G1H4(19),n2h4(64))
  call Hloop_AS_Q(ntryL,G1H4(59),ex5(:),G1H4(20),ngH,m3h1x4(:,34),heltab2x4(:,:,95))
  call Hloop_A_Q(ntryL,G1H4(20),51,nMB,G2H4(23),n2h4(65))
call HGT_OLR(G1H4(60),1,1,4)
call HGT_invQ_OLR(G1H4(60),2,5,4)
  call Hloop_Q_A(ntryL,G1H4(60),-12,nMB,G2H4(24),n2h4(66))
  call Hloop_QV_A(ntryL,G2H4(24),wf4(:,12),G2H1(40),m3h4x1(:,44),heltab2x4(:,:,96))
  call Hloop_AS_Q(ntryL,G1H4(62),ex5(:),G1H4(22),ngH,m3h1x4(:,35),heltab2x4(:,:,97))
  call Hloop_A_Q(ntryL,G1H4(22),51,nMB,G2H4(24),n2h4(67))
  call Hloop_AS_Q(ntryL,G1H4(63),ex5(:),G1H4(23),ngH,m3h1x4(:,36),heltab2x4(:,:,98))
  call Hloop_A_Q(ntryL,G1H4(23),51,nMB,G2H4(25),n2h4(68))
  call Hloop_AS_Q(ntryL,G0H4(12),ex5(:),G0H4(4),ngH,m3h1x4(:,37),heltab2x4(:,:,99))
  call Hloop_A_Q(ntryL,G0H4(4),51,nMB,G1H4(24),n2h4(69))
  call Hloop_AZ_Q(ntryL,G1H8(10),wf4(:,3),G1H2(13),ngZd,m3h4x2(:,22),heltab2x8(:,:,42))
  call Hloop_A_Q(ntryL,G1H2(13),43,nMB,G2H2(42),n2h2(49))
call HGT_raise_alpha_OLR(G1H8(11),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(11),2,5,8)
  call Hloop_VQ_A(ntryL,G1H8(11),wf2(:,2),G1H4(25),m3h2x4(:,14),heltab2x8(:,:,43))
  call Hloop_AZ_Q(ntryL,G1H8(17),wf4(:,3),G1H2(6),ngZd,m3h4x2(:,23),heltab2x8(:,:,44))
  call Hloop_A_Q(ntryL,G1H2(6),43,nMB,G2H2(43),n2h2(50))
  call Hloop_AZ_Q(ntryL,G1H8(19),wf4(:,3),G1H2(28),ngZd,m3h4x2(:,24),heltab2x8(:,:,45))
  call Hloop_A_Q(ntryL,G1H2(28),43,nMB,G2H2(44),n2h2(51))
  call Hloop_QZ_A(ntryL,G1H8(20),wf4(:,3),G1H2(15),ngZd,m3h4x2(:,25),heltab2x8(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(15),39,nMB,G2H2(45),n2h2(52))
call HGT_raise_alpha_OLR(G1H8(21),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(21),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(21),wf2(:,4),G1H4(27),m3h2x4(:,15),heltab2x8(:,:,47))
  call Hloop_QZ_A(ntryL,G1H8(23),wf4(:,3),G1H2(26),ngZd,m3h4x2(:,26),heltab2x8(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(26),39,nMB,G2H2(46),n2h2(53))
  call Hloop_QZ_A(ntryL,G1H8(24),wf4(:,3),G1H2(16),ngZd,m3h4x2(:,27),heltab2x8(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(16),39,nMB,G2H2(47),n2h2(54))
  call Hloop_QS_A(ntryL,G1H8(14),ex5(:),G1H8(2),ngH,m3h1x8(:,6),heltab2x8(:,:,50))
  call Hloop_Q_A(ntryL,G1H8(2),52,nMB,G2H8(2),n2h8(23))
call HGT_raise_alpha_OLR(G1H8(25),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(25),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(25),wf8(:,3),G1H1(4),m3h8x1(:,3),heltab2x8(:,:,51))
  call Hloop_QS_A(ntryL,G1H8(27),ex5(:),G1H8(4),ngH,m3h1x8(:,7),heltab2x8(:,:,52))
  call Hloop_Q_A(ntryL,G1H8(4),52,nMB,G2H8(1),n2h8(25))
  call Hloop_QS_A(ntryL,G1H8(28),ex5(:),G1H8(3),ngH,m3h1x8(:,8),heltab2x8(:,:,53))
  call Hloop_Q_A(ntryL,G1H8(3),52,nMB,G2H8(3),n2h8(26))
  call Hloop_QZ_A(ntryL,G1H8(12),wf4(:,13),G1H2(9),ngZd,m3h4x2(:,28),heltab2x8(:,:,54))
  call Hloop_Q_A(ntryL,G1H2(9),55,nMB,G2H2(48),n2h2(55))
call HGT_raise_alpha_OLR(G1H8(15),1,1,8)
call HGT_raise_alpha_invQ_OLR(G1H8(15),2,5,8)
  call Hloop_VA_Q(ntryL,G1H8(15),ex4(:),G1H4(28),m3h2x4(:,16),heltab2x8(:,:,55))
  call Hloop_QZ_A(ntryL,G1H8(29),wf4(:,13),G1H2(27),ngZd,m3h4x2(:,29),heltab2x8(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(27),55,nMB,G2H2(49),n2h2(56))
  call Hloop_QZ_A(ntryL,G1H8(30),wf4(:,13),G1H2(18),ngZd,m3h4x2(:,30),heltab2x8(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(18),55,nMB,G2H2(50),n2h2(57))
  call ol_merge(ntryL,G2H2(23),[G2H2(2),G1H2(5)])
  call ol_merge(ntryL,G2H2(25),[G2H2(11),G1H2(25)])
  call ol_merge(ntryL,G2H1(34),[G2H1(2),G1H1(8)])
  call ol_merge(ntryL,G2H1(12),[G2H1(5),G1H1(19)])
  call ol_merge(ntryL,G2H1(31),[G2H1(8),G1H1(30)])
  call ol_merge(ntryL,G2H1(10),[G2H1(11),G1H1(41)])
call HGT_w2_OLR(G1H4(7),1,1,4)
call HGT_w2_invQ_OLR(G1H4(7),2,5,4)
  call ol_merge(ntryL,G2H4(4),[G1H4(7)])
  call ol_merge(ntryL,G2H2(48),[G2H2(18),G2H2(13)])
  call ol_merge(ntryL,G2H2(50),[G2H2(21),G2H2(20),G2H2(16),G2H2(15)])
  call ol_merge(ntryL,G2H1(1),[G1H1(39)])
call HGT_w2_OLR(G1H1(1),1,1,1)
call HGT_w2_invQ_OLR(G1H1(1),2,5,1)
  call ol_merge(ntryL,G2H1(1),[G1H1(1)])
call HGT_w2_OLR(G1H1(2),1,1,1)
call HGT_w2_invQ_OLR(G1H1(2),2,5,1)
  call ol_merge(ntryL,G1H1(2),[G1H1(45)])
  call ol_merge(ntryL,G2H2(10),[G1H2(1)])
  call ol_merge(ntryL,G2H2(12),[G1H2(2)])
  call ol_merge(ntryL,G2H2(22),[G1H2(23)])
  call ol_merge(ntryL,G2H2(8),[G1H2(11)])
  call ol_merge(ntryL,G2H1(3),[G1H1(6)])
  call ol_merge(ntryL,G2H1(4),[G1H1(7)])
  call ol_merge(ntryL,G2H1(36),[G1H1(14)])
  call ol_merge(ntryL,G2H1(6),[G1H1(17)])
  call ol_merge(ntryL,G2H1(13),[G1H1(18)])
  call ol_merge(ntryL,G2H1(15),[G1H1(24)])
  call ol_merge(ntryL,G2H1(7),[G1H1(28)])
  call ol_merge(ntryL,G2H1(9),[G1H1(29)])
  call ol_merge(ntryL,G2H1(33),[G1H1(36)])
  call ol_merge(ntryL,G2H1(16),[G1H1(40)])
  call ol_merge(ntryL,G2H1(18),[G1H1(46)])
  call ol_merge(ntryL,G2H2(41),[G2H2(19)])
  call ol_merge(ntryL,G2H2(35),[G2H2(9)])
  call ol_merge(ntryL,G2H2(32),[G2H2(3)])
  call ol_merge(ntryL,G2H2(38),[G2H2(4)])
call Hotf_4pt_reduction(G2H2(23),RedSet_4(17),mass4set(:,3),  & 
G1H2(14),G1H2(4),G1H2(21),G1H2(10),G1H2(34),2)
call HG1shiftOLR(G1H2(4),8,2)
call Hotf_4pt_reduction(G2H2(25),RedSet_4(21),mass4set(:,3),  & 
G1H2(8),G1H2(35),G1H2(12),G1H2(3),G1H2(29),2)
call HG1shiftOLR(G1H2(35),4,2)
call HGT_OLR(G2H2(7),1,1,2)
call HGT_invQ_OLR(G2H2(7),2,5,2)
call HGT_OLR(G2H2(7),6,15,2)
call Hotf_4pt_reduction(G2H2(7),RedSet_4(39),mass4set(:,3),  & 
G1H2(22),G1H2(13),G1H2(6),G1H2(28),G1H2(15),2)
call HG1shiftOLR(G1H2(13),4,2)
call Hotf_4pt_reduction(G2H1(34),RedSet_4(25),mass4set(:,2),  & 
G1H1(43),G1H1(16),G1H1(21),G1H1(5),G1H1(20),1)
call HG1shiftOLR(G1H1(16),16,1)
call HGT_OLR(G2H4(2),1,1,4)
call HGT_invQ_OLR(G2H4(2),2,5,4)
call HGT_OLR(G2H4(2),6,15,4)
call Hotf_4pt_reduction(G2H4(2),RedSet_4(40),mass4set(:,4),  & 
G1H4(29),G1H4(30),G1H4(32),G1H4(33),G1H4(34),4)
call HG1shiftOLR(G1H4(30),3,4)
call Hotf_4pt_reduction(G2H1(12),RedSet_4(29),mass4set(:,4),  & 
G1H1(10),G1H1(31),G1H1(42),G1H1(8),G1H1(19),1)
call HG1shiftOLR(G1H1(31),16,1)
call HGT_OLR(G2H2(5),1,1,2)
call HGT_invQ_OLR(G2H2(5),2,5,2)
call HGT_OLR(G2H2(5),6,15,2)
call Hotf_4pt_reduction(G2H2(5),RedSet_4(41),mass4set(:,3),  & 
G1H2(26),G1H2(16),G1H2(9),G1H2(27),G1H2(18),2)
call HG1shiftOLR(G1H2(16),8,2)
call Hotf_4pt_reduction(G2H1(31),RedSet_4(25),mass4set(:,2),  & 
G1H1(30),G1H1(41),G1H1(39),G1H1(1),G1H1(45),1)
call HG1shiftOLR(G1H1(41),16,1)
call HGT_OLR(G2H4(5),1,1,4)
call HGT_invQ_OLR(G2H4(5),2,5,4)
call HGT_OLR(G2H4(5),6,15,4)
call Hotf_4pt_reduction(G2H4(5),RedSet_4(42),mass4set(:,4),  & 
G1H4(35),G1H4(37),G1H4(38),G1H4(39),G1H4(40),4)
call HG1shiftOLR(G1H4(37),3,4)
call Hotf_4pt_reduction(G2H1(10),RedSet_4(35),mass4set(:,4),  & 
G1H1(6),G1H1(7),G1H1(14),G1H1(17),G1H1(18),1)
call HG1shiftOLR(G1H1(7),16,1)
call Hotf_4pt_reduction(G2H4(4),RedSet_4(43),mass4set(:,7),  & 
G1H4(42),G1H4(43),G1H4(44),G1H4(5),G1H4(45),4)
call HG1shiftOLR(G1H4(43),3,4)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(48),ex4(:),G2tensor(1),m3h2x1(:,29),heltab2x2(:,:,49))
call HGT_w2_OLR(G1H4(4),1,1,4)
call HGT_w2_invQ_OLR(G1H4(4),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(4),wf4(:,3),G1H1(24),ngZd,m3h4x1(:,45),heltab2x4(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(24),63,nMB,G2tensor(3),n2h1(77))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(50),ex4(:),G2tensor(5),m3h2x1(:,30),heltab2x2(:,:,50))
call HGT_w2_OLR(G1H4(1),1,1,4)
call HGT_w2_invQ_OLR(G1H4(1),2,5,4)
  call Hloop_QZ_A(ntryL,G1H4(1),wf4(:,3),G1H1(28),ngZd,m3h4x1(:,46),heltab2x4(:,:,101))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(28),3,nMB,G2tensor(9),n2h1(78))
call Hotf_4pt_reduction(G2H1(1),RedSet_4(34),mass4set(:,7),  & 
G1H1(29),G1H1(36),G1H1(40),G1H1(46),G1H1(24),1)
call HG1shiftOLR(G1H1(36),16,1)
  call Hloop_QS_A(ntryL,G1H1(2),ex5(:),G1H1(28),ngH,m3h1x1(:,17),heltab2x1(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(28),63,nMB,G2tensor(13),n2h1(79))
call HGT_w2_OLR(G1H1(3),1,1,1)
call HGT_w2_invQ_OLR(G1H1(3),2,5,1)
  call Hloop_QS_A(ntryL,G1H1(3),ex5(:),G1H1(2),ngH,m3h1x1(:,18),heltab2x1(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(2),16,nMB,G2tensor(17),n2h1(80))
call Hotf_4pt_reduction(G2H2(10),RedSet_4(15),mass4set(:,3),  & 
G1H2(5),G1H2(25),G1H2(1),G1H2(2),G1H2(23),2)
call HG1shiftOLR(G1H2(25),8,2)
call Hotf_4pt_reduction(G2H2(12),RedSet_4(16),mass4set(:,3),  & 
G1H2(11),G1H2(36),G1H2(37),G1H2(38),G1H2(39),2)
call HG1shiftOLR(G1H2(36),8,2)
  call Hloop_VA_Q(ntryL,G1H2(19),ex4(:),G1H1(28),m3h2x1(:,31),heltab2x2(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(28),63,nMB,G2tensor(21),n2h1(81))
  call Hloop_VA_Q(ntryL,G1H2(7),ex4(:),G1H1(3),m3h2x1(:,32),heltab2x2(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(3),63,nMB,G2tensor(25),n2h1(82))
  call Hloop_VA_Q(ntryL,G1H2(24),ex4(:),G1H1(2),m3h2x1(:,33),heltab2x2(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(2),63,nMB,G2tensor(29),n2h1(83))
call Hotf_4pt_reduction(G2H2(22),RedSet_4(19),mass4set(:,3),  & 
G1H2(19),G1H2(7),G1H2(24),G1H2(40),G1H2(41),2)
call HG1shiftOLR(G1H2(7),4,2)
call Hotf_4pt_reduction(G2H2(8),RedSet_4(20),mass4set(:,3),  & 
G1H2(42),G1H2(43),G1H2(44),G1H2(45),G1H2(46),2)
call HG1shiftOLR(G1H2(43),4,2)
  call Hloop_VQ_A(ntryL,G1H2(30),ex3(:),G1H1(28),m3h2x1(:,34),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(28),63,nMB,G2tensor(30),n2h1(84))
  call Hloop_VQ_A(ntryL,G1H2(31),ex3(:),G1H1(3),m3h2x1(:,35),heltab2x2(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(3),63,nMB,G2tensor(31),n2h1(85))
  call Hloop_VQ_A(ntryL,G1H2(32),ex3(:),G1H1(2),m3h2x1(:,36),heltab2x2(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(2),63,nMB,G2tensor(32),n2h1(86))
call Hotf_4pt_reduction(G2H1(3),RedSet_4(23),mass4set(:,4),  & 
G1H1(28),G1H1(3),G1H1(2),G1H1(48),G1H1(49),1)
call HG1shiftOLR(G1H1(3),16,1)
call Hotf_4pt_reduction(G2H1(4),RedSet_4(24),mass4set(:,4),  & 
G1H1(50),G1H1(51),G1H1(52),G1H1(53),G1H1(54),1)
call HG1shiftOLR(G1H1(51),16,1)
  call Hloop_QS_A(ntryL,G1H1(12),ex5(:),G1H1(55),ngH,m3h1x1(:,19),heltab2x1(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(55),63,nMB,G2tensor(33),n2h1(87))
  call Hloop_QS_A(ntryL,G1H1(13),ex5(:),G1H1(12),ngH,m3h1x1(:,20),heltab2x1(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(12),63,nMB,G2tensor(34),n2h1(88))
  call Hloop_QS_A(ntryL,G2H1(36),ex5(:),G2H1(2),ngH,m3h1x1(:,21),heltab2x1(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(2),63,nMB,G3tensor(1),n2h1(89))
call Hotf_4pt_reduction(G2H1(6),RedSet_4(27),mass4set(:,7),  & 
G1H1(55),G1H1(13),G1H1(12),G1H1(56),G1H1(57),1)
call HG1shiftOLR(G1H1(13),16,1)
call Hotf_4pt_reduction(G2H1(13),RedSet_4(28),mass4set(:,2),  & 
G1H1(58),G1H1(59),G1H1(60),G1H1(61),G1H1(62),1)
call HG1shiftOLR(G1H1(59),16,1)
  call Hloop_AS_Q(ntryL,G1H1(23),ex5(:),G1H1(63),ngH,m3h1x1(:,22),heltab2x1(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(63),63,nMB,G2tensor(35),n2h1(90))
  call Hloop_AS_Q(ntryL,G2H1(15),ex5(:),G2H1(5),ngH,m3h1x1(:,23),heltab2x1(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(5),63,nMB,G3tensor(2),n2h1(91))
  call Hloop_AS_Q(ntryL,G1H1(25),ex5(:),G1H1(23),ngH,m3h1x1(:,24),heltab2x1(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(23),63,nMB,G2tensor(36),n2h1(92))
call Hotf_4pt_reduction(G2H1(7),RedSet_4(31),mass4set(:,4),  & 
G1H1(63),G1H1(25),G1H1(23),G1H1(64),G1H1(65),1)
call HG1shiftOLR(G1H1(25),16,1)
call Hotf_4pt_reduction(G2H1(9),RedSet_4(32),mass4set(:,4),  & 
G1H1(66),G1H1(67),G1H1(68),G1H1(69),G1H1(70),1)
call HG1shiftOLR(G1H1(67),16,1)
  call Hloop_AS_Q(ntryL,G1H1(34),ex5(:),G1H1(71),ngH,m3h1x1(:,25),heltab2x1(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(71),63,nMB,G2tensor(37),n2h1(93))
  call Hloop_AS_Q(ntryL,G1H1(35),ex5(:),G1H1(34),ngH,m3h1x1(:,26),heltab2x1(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(34),63,nMB,G2tensor(38),n2h1(94))
  call Hloop_AS_Q(ntryL,G2H1(33),ex5(:),G2H1(8),ngH,m3h1x1(:,27),heltab2x1(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(8),63,nMB,G3tensor(3),n2h1(95))
call Hotf_4pt_reduction(G2H1(16),RedSet_4(28),mass4set(:,2),  & 
G1H1(71),G1H1(35),G1H1(34),G1H1(72),G1H1(73),1)
call HG1shiftOLR(G1H1(35),16,1)
  call Hloop_QS_A(ntryL,G2H1(18),ex5(:),G2H1(11),ngH,m3h1x1(:,28),heltab2x1(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(11),63,nMB,G3tensor(4),n2h1(96))
  call Hloop_QS_A(ntryL,G1H1(47),ex5(:),G1H1(74),ngH,m3h1x1(:,29),heltab2x1(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(74),63,nMB,G2tensor(39),n2h1(97))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(41),ex4(:),G2tensor(40),m3h2x1(:,37),heltab2x2(:,:,57))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(35),ex4(:),G2tensor(41),m3h2x1(:,38),heltab2x2(:,:,58))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(32),ex4(:),G2tensor(42),m3h2x1(:,39),heltab2x2(:,:,59))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(38),ex4(:),G2tensor(43),m3h2x1(:,40),heltab2x2(:,:,60))
call Hotf_4pt_reduction(G2H2(24),RedSet_4(5),mass4set(:,3),  & 
G1H2(30),G1H2(31),G1H2(32),G1H2(47),G1H2(48),2)
call HG1shiftOLR(G1H2(31),20,2)
call Hotf_4pt_reduction(G2H2(26),RedSet_4(7),mass4set(:,3),  & 
G1H2(49),G1H2(50),G1H2(51),G1H2(52),G1H2(53),2)
call HG1shiftOLR(G1H2(50),24,2)
call Hotf_4pt_reduction(G2H4(8),RedSet_4(6),mass4set(:,4),  & 
G1H4(47),G1H4(15),G1H4(48),G1H4(13),G1H4(49),4)
call HG1shiftOLR(G1H4(15),19,4)
call Hotf_4pt_reduction(G2H4(1),RedSet_4(8),mass4set(:,4),  & 
G1H4(8),G1H4(50),G1H4(52),G1H4(14),G1H4(53),4)
call HG1shiftOLR(G1H4(50),19,4)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(27),ex3(:),G2tensor(44),m3h2x1(:,41),heltab2x2(:,:,61))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(29),ex3(:),G2tensor(45),m3h2x1(:,42),heltab2x2(:,:,62))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(30),ex4(:),G2tensor(46),m3h2x1(:,43),heltab2x2(:,:,63))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(33),ex4(:),G2tensor(47),m3h2x1(:,44),heltab2x2(:,:,64))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(36),ex4(:),G2tensor(48),m3h2x1(:,45),heltab2x2(:,:,65))
  call Hloop_AS_Q(ntryL,G1H1(38),ex5(:),G1H1(47),ngH,m3h1x1(:,30),heltab2x1(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(47),63,nMB,G2tensor(49),n2h1(98))
  call Hloop_QS_A(ntryL,G1H1(44),ex5(:),G1H1(74),ngH,m3h1x1(:,31),heltab2x1(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(74),63,nMB,G2tensor(50),n2h1(99))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(39),ex4(:),G2tensor(51),m3h2x1(:,46),heltab2x2(:,:,66))
call Hotf_4pt_reduction(G2H1(19),RedSet_4(28),mass4set(:,6),  & 
G1H1(38),G1H1(47),G1H1(44),G1H1(74),G1H1(75),1)
call HG1shiftOLR(G1H1(47),16,1)
  call Hloop_AS_Q(ntryL,G2H1(21),ex5(:),G2H1(34),ngH,m3h1x1(:,32),heltab2x1(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(34),63,nMT,G3tensor(5),n2h1(100))
  call Hloop_AS_Q(ntryL,G1H1(22),ex5(:),G1H1(76),ngH,m3h1x1(:,33),heltab2x1(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(76),63,nMT,G2tensor(52),n2h1(101))
call Hotf_4pt_reduction(G2H1(22),RedSet_4(28),mass4set(:,6),  & 
G1H1(22),G1H1(76),G1H1(77),G1H1(78),G1H1(79),1)
call HG1shiftOLR(G1H1(76),16,1)
  call Hloop_QS_A(ntryL,G2H1(24),ex5(:),G2H1(12),ngH,m3h1x1(:,34),heltab2x1(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(12),63,nMT,G3tensor(6),n2h1(102))
  call Hloop_QS_A(ntryL,G1H1(27),ex5(:),G1H1(80),ngH,m3h1x1(:,35),heltab2x1(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(80),63,nMT,G2tensor(53),n2h1(103))
call Hotf_4pt_reduction(G2H1(25),RedSet_4(25),mass4set(:,6),  & 
G1H1(27),G1H1(80),G1H1(81),G1H1(82),G1H1(83),1)
call HG1shiftOLR(G1H1(80),16,1)
  call Hloop_AS_Q(ntryL,G2H1(27),ex5(:),G2H1(31),ngH,m3h1x1(:,36),heltab2x1(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(31),63,nMT,G3tensor(7),n2h1(104))
  call Hloop_AS_Q(ntryL,G1H1(15),ex5(:),G1H1(84),ngH,m3h1x1(:,37),heltab2x1(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(84),63,nMT,G2tensor(54),n2h1(105))
call Hotf_4pt_reduction(G2H1(28),RedSet_4(25),mass4set(:,6),  & 
G1H1(15),G1H1(84),G1H1(85),G1H1(86),G1H1(87),1)
call HG1shiftOLR(G1H1(84),16,1)
  call Hloop_QS_A(ntryL,G2H1(30),ex5(:),G2H1(10),ngH,m3h1x1(:,38),heltab2x1(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(10),63,nMT,G3tensor(8),n2h1(106))
  call Hloop_QS_A(ntryL,G1H1(9),ex5(:),G1H1(88),ngH,m3h1x1(:,39),heltab2x1(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(88),63,nMT,G2tensor(55),n2h1(107))
  call Hloop_AS_Q(ntryL,G1H1(26),ex5(:),G1H1(9),ngH,m3h1x1(:,40),heltab2x1(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),63,nMB,G2tensor(56),n2h1(108))
  call Hloop_QS_A(ntryL,G1H1(37),ex5(:),G1H1(88),ngH,m3h1x1(:,41),heltab2x1(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(88),63,nMB,G2tensor(57),n2h1(109))
call Hotf_4pt_reduction(G2H4(22),RedSet_4(4),mass4set(:,6),  & 
G1H4(6),G1H4(54),G1H4(2),G1H4(55),G1H4(57),4)
call HG1shiftOLR(G1H4(54),12,4)
  call Hloop_QV_A(ntryL,G2H4(10),wf4(:,12),G2H1(1),m3h4x1(:,47),heltab2x4(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(9),n2h1(110))
  call Hloop_QV_A(ntryL,G1H4(3),wf4(:,12),G1H1(26),m3h4x1(:,48),heltab2x4(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(26),63,nMT,G2tensor(58),n2h1(111))
call Hotf_4pt_reduction(G2H4(12),RedSet_4(4),mass4set(:,6),  & 
G1H4(17),G1H4(58),G1H4(18),G1H4(59),G1H4(20),4)
call HG1shiftOLR(G1H4(58),12,4)
  call Hloop_AV_Q(ntryL,G2H4(18),wf4(:,12),G2H1(3),m3h4x1(:,49),heltab2x4(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(3),63,nMT,G3tensor(10),n2h1(112))
  call Hloop_AV_Q(ntryL,G1H4(11),wf4(:,12),G1H1(9),m3h4x1(:,50),heltab2x4(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),63,nMT,G2tensor(59),n2h1(113))
call Hotf_4pt_reduction(G2H4(20),RedSet_4(4),mass4set(:,2),  & 
G1H4(60),G1H4(62),G1H4(22),G1H4(63),G1H4(23),4)
call HG1shiftOLR(G1H4(62),12,4)
  call Hloop_QV_A(ntryL,G2H4(3),wf4(:,12),G2H1(4),m3h4x1(:,51),heltab2x4(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(4),63,nMB,G3tensor(11),n2h1(114))
  call Hloop_QV_A(ntryL,G1H4(19),wf4(:,12),G1H1(37),m3h4x1(:,52),heltab2x4(:,:,107))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(37),63,nMB,G2tensor(60),n2h1(115))
call Hotf_4pt_reduction(G2H4(23),RedSet_4(4),mass4set(:,2),  & 
G1H4(7),G1H4(4),G1H4(1),G1H4(3),G1H4(11),4)
call HG1shiftOLR(G1H4(4),12,4)
  call Hloop_AV_Q(ntryL,G2H4(25),wf4(:,12),G2H1(36),m3h4x1(:,53),heltab2x4(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(36),63,nMB,G3tensor(12),n2h1(116))
  call Hloop_AV_Q(ntryL,G1H4(24),wf4(:,12),G1H1(88),m3h4x1(:,54),heltab2x4(:,:,109))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(88),63,nMB,G2tensor(61),n2h1(117))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(42),wf2(:,2),G2tensor(62),m3h2x1(:,47),heltab2x2(:,:,67))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(44),wf2(:,2),G2tensor(63),m3h2x1(:,48),heltab2x2(:,:,68))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(45),wf2(:,4),G2tensor(64),m3h2x1(:,49),heltab2x2(:,:,69))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(47),wf2(:,4),G2tensor(65),m3h2x1(:,50),heltab2x2(:,:,70))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(2),wf8(:,3),G2tensor(66),m3h8x1(:,4),heltab2x8(:,:,58))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(3),wf8(:,3),G2tensor(67),m3h8x1(:,5),heltab2x8(:,:,59))
  call Hloop_VA_Q(ntryL,G1H2(14),ex4(:),G1H1(26),m3h2x1(:,51),heltab2x2(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(26),63,nMB,G2tensor(68),n2h1(118))
  call Hloop_VA_Q(ntryL,G1H2(4),ex4(:),G1H1(9),m3h2x1(:,52),heltab2x2(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),8,nMB,G2tensor(69),n2h1(119))
  call Hloop_VA_Q(ntryL,G1H2(34),ex4(:),G1H1(37),m3h2x1(:,53),heltab2x2(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(37),63,nMB,G2tensor(70),n2h1(120))
  call Hloop_VQ_A(ntryL,G1H2(8),ex3(:),G1H1(88),m3h2x1(:,54),heltab2x2(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(88),63,nMB,G2tensor(71),n2h1(121))
  call Hloop_VQ_A(ntryL,G1H2(35),ex3(:),G1H1(26),m3h2x1(:,55),heltab2x2(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(26),4,nMB,G2tensor(72),n2h1(122))
  call Hloop_VQ_A(ntryL,G1H2(29),ex3(:),G1H1(9),m3h2x1(:,56),heltab2x2(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),63,nMB,G2tensor(73),n2h1(123))
  call Hloop_VQ_A(ntryL,G1H2(22),ex3(:),G1H1(37),m3h2x1(:,57),heltab2x2(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(37),63,nMB,G2tensor(74),n2h1(124))
  call Hloop_VQ_A(ntryL,G1H2(13),ex3(:),G1H1(88),m3h2x1(:,58),heltab2x2(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(88),4,nMB,G2tensor(75),n2h1(125))
  call Hloop_VQ_A(ntryL,G1H2(15),ex3(:),G1H1(26),m3h2x1(:,59),heltab2x2(:,:,79))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(26),63,nMB,G2tensor(76),n2h1(126))
  call Hloop_QS_A(ntryL,G1H1(43),ex5(:),G1H1(9),ngH,m3h1x1(:,42),heltab2x1(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),63,nMB,G2tensor(77),n2h1(127))
  call Hloop_QS_A(ntryL,G1H1(16),ex5(:),G1H1(37),ngH,m3h1x1(:,43),heltab2x1(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(37),16,nMB,G2tensor(78),n2h1(128))
  call Hloop_QS_A(ntryL,G1H1(20),ex5(:),G1H1(88),ngH,m3h1x1(:,44),heltab2x1(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(88),63,nMB,G2tensor(79),n2h1(129))
  call Hloop_AZ_Q(ntryL,G1H4(29),wf4(:,3),G1H1(26),ngZd,m3h4x1(:,55),heltab2x4(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(26),63,nMB,G2tensor(80),n2h1(130))
  call Hloop_AZ_Q(ntryL,G1H4(30),wf4(:,3),G1H1(43),ngZd,m3h4x1(:,56),heltab2x4(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(43),3,nMB,G2tensor(81),n2h1(131))
  call Hloop_AZ_Q(ntryL,G1H4(34),wf4(:,3),G1H1(9),ngZd,m3h4x1(:,57),heltab2x4(:,:,112))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),63,nMB,G2tensor(82),n2h1(132))
  call Hloop_AS_Q(ntryL,G1H1(10),ex5(:),G1H1(16),ngH,m3h1x1(:,45),heltab2x1(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(16),63,nMB,G2tensor(83),n2h1(133))
  call Hloop_AS_Q(ntryL,G1H1(31),ex5(:),G1H1(37),ngH,m3h1x1(:,46),heltab2x1(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(37),16,nMB,G2tensor(84),n2h1(134))
  call Hloop_AS_Q(ntryL,G1H1(19),ex5(:),G1H1(20),ngH,m3h1x1(:,47),heltab2x1(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(20),63,nMB,G2tensor(85),n2h1(135))
  call Hloop_VA_Q(ntryL,G1H2(26),ex4(:),G1H1(88),m3h2x1(:,60),heltab2x2(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(88),63,nMB,G2tensor(86),n2h1(136))
  call Hloop_VA_Q(ntryL,G1H2(16),ex4(:),G1H1(26),m3h2x1(:,61),heltab2x2(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(26),8,nMB,G2tensor(87),n2h1(137))
  call Hloop_VA_Q(ntryL,G1H2(18),ex4(:),G1H1(43),m3h2x1(:,62),heltab2x2(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(43),63,nMB,G2tensor(88),n2h1(138))
  call Hloop_AS_Q(ntryL,G1H1(30),ex5(:),G1H1(9),ngH,m3h1x1(:,48),heltab2x1(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(9),63,nMB,G2tensor(89),n2h1(139))
  call Hloop_AS_Q(ntryL,G1H1(41),ex5(:),G1H1(10),ngH,m3h1x1(:,49),heltab2x1(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(10),16,nMB,G2tensor(90),n2h1(140))
  call Hloop_AS_Q(ntryL,G1H1(45),ex5(:),G1H1(16),ngH,m3h1x1(:,50),heltab2x1(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(16),63,nMB,G2tensor(91),n2h1(141))
  call Hloop_QZ_A(ntryL,G1H4(35),wf4(:,3),G1H1(31),ngZd,m3h4x1(:,58),heltab2x4(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(31),63,nMB,G2tensor(92),n2h1(142))
  call Hloop_QZ_A(ntryL,G1H4(37),wf4(:,3),G1H1(37),ngZd,m3h4x1(:,59),heltab2x4(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(37),3,nMB,G2tensor(93),n2h1(143))
  call Hloop_QZ_A(ntryL,G1H4(40),wf4(:,3),G1H1(19),ngZd,m3h4x1(:,60),heltab2x4(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),63,nMB,G2tensor(94),n2h1(144))
  call Hloop_QS_A(ntryL,G1H1(6),ex5(:),G1H1(20),ngH,m3h1x1(:,51),heltab2x1(:,:,51))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(20),63,nMB,G2tensor(95),n2h1(145))
  call Hloop_QS_A(ntryL,G1H1(7),ex5(:),G1H1(88),ngH,m3h1x1(:,52),heltab2x1(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(88),16,nMB,G2tensor(96),n2h1(146))
  call Hloop_QS_A(ntryL,G1H1(18),ex5(:),G1H1(26),ngH,m3h1x1(:,53),heltab2x1(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(26),63,nMB,G2tensor(97),n2h1(147))
  call Hloop_QZ_A(ntryL,G1H4(42),wf4(:,3),G1H1(43),ngZd,m3h4x1(:,61),heltab2x4(:,:,116))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(43),63,nMB,G2tensor(98),n2h1(148))
  call Hloop_QZ_A(ntryL,G1H4(43),wf4(:,3),G1H1(30),ngZd,m3h4x1(:,62),heltab2x4(:,:,117))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(30),3,nMB,G2tensor(99),n2h1(149))
  call Hloop_QZ_A(ntryL,G1H4(45),wf4(:,3),G1H1(9),ngZd,m3h4x1(:,63),heltab2x4(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),63,nMB,G2tensor(100),n2h1(150))
  call Hloop_QS_A(ntryL,G1H1(29),ex5(:),G1H1(41),ngH,m3h1x1(:,54),heltab2x1(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(41),63,nMB,G2tensor(101),n2h1(151))
  call Hloop_QS_A(ntryL,G1H1(36),ex5(:),G1H1(10),ngH,m3h1x1(:,55),heltab2x1(:,:,55))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(10),16,nMB,G2tensor(102),n2h1(152))
  call Hloop_QS_A(ntryL,G1H1(24),ex5(:),G1H1(45),ngH,m3h1x1(:,56),heltab2x1(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(45),63,nMB,G2tensor(103),n2h1(153))
  call Hloop_VA_Q(ntryL,G1H2(5),ex4(:),G1H1(16),m3h2x1(:,63),heltab2x2(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(16),63,nMB,G2tensor(104),n2h1(154))
  call Hloop_VA_Q(ntryL,G1H2(25),ex4(:),G1H1(31),m3h2x1(:,64),heltab2x2(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(31),8,nMB,G2tensor(105),n2h1(155))
  call Hloop_VA_Q(ntryL,G1H2(23),ex4(:),G1H1(37),m3h2x1(:,65),heltab2x2(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(37),63,nMB,G2tensor(106),n2h1(156))
  call Hloop_VA_Q(ntryL,G1H2(11),ex4(:),G1H1(19),m3h2x1(:,66),heltab2x2(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),63,nMB,G2tensor(107),n2h1(157))
  call Hloop_VA_Q(ntryL,G1H2(36),ex4(:),G1H1(6),m3h2x1(:,67),heltab2x2(:,:,87))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(6),8,nMB,G2tensor(108),n2h1(158))
  call Hloop_VA_Q(ntryL,G1H2(39),ex4(:),G1H1(20),m3h2x1(:,68),heltab2x2(:,:,88))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(20),63,nMB,G2tensor(109),n2h1(159))
  call Hloop_VQ_A(ntryL,G1H2(19),ex3(:),G1H1(7),m3h2x1(:,69),heltab2x2(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(7),63,nMB,G2tensor(110),n2h1(160))
  call Hloop_VQ_A(ntryL,G1H2(7),ex3(:),G1H1(88),m3h2x1(:,70),heltab2x2(:,:,90))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(88),4,nMB,G2tensor(111),n2h1(161))
  call Hloop_VQ_A(ntryL,G1H2(41),ex3(:),G1H1(18),m3h2x1(:,71),heltab2x2(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(18),63,nMB,G2tensor(112),n2h1(162))
  call Hloop_VQ_A(ntryL,G1H2(42),ex3(:),G1H1(26),m3h2x1(:,72),heltab2x2(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(26),63,nMB,G2tensor(113),n2h1(163))
  call Hloop_VQ_A(ntryL,G1H2(43),ex3(:),G1H1(43),m3h2x1(:,73),heltab2x2(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(43),4,nMB,G2tensor(114),n2h1(164))
  call Hloop_VQ_A(ntryL,G1H2(46),ex3(:),G1H1(30),m3h2x1(:,74),heltab2x2(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(30),63,nMB,G2tensor(115),n2h1(165))
  call Hloop_QS_A(ntryL,G1H1(28),ex5(:),G1H1(9),ngH,m3h1x1(:,57),heltab2x1(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),63,nMB,G2tensor(116),n2h1(166))
  call Hloop_QS_A(ntryL,G1H1(3),ex5(:),G1H1(29),ngH,m3h1x1(:,58),heltab2x1(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(29),16,nMB,G2tensor(117),n2h1(167))
  call Hloop_QS_A(ntryL,G1H1(49),ex5(:),G1H1(41),ngH,m3h1x1(:,59),heltab2x1(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(41),63,nMB,G2tensor(118),n2h1(168))
  call Hloop_QS_A(ntryL,G1H1(50),ex5(:),G1H1(36),ngH,m3h1x1(:,60),heltab2x1(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(36),63,nMB,G2tensor(119),n2h1(169))
  call Hloop_QS_A(ntryL,G1H1(51),ex5(:),G1H1(10),ngH,m3h1x1(:,61),heltab2x1(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(10),16,nMB,G2tensor(120),n2h1(170))
  call Hloop_QS_A(ntryL,G1H1(54),ex5(:),G1H1(24),ngH,m3h1x1(:,62),heltab2x1(:,:,62))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(24),63,nMB,G2tensor(121),n2h1(171))
  call Hloop_AS_Q(ntryL,G1H1(55),ex5(:),G1H1(45),ngH,m3h1x1(:,63),heltab2x1(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(45),63,nMB,G2tensor(122),n2h1(172))
  call Hloop_AS_Q(ntryL,G1H1(13),ex5(:),G1H1(16),ngH,m3h1x1(:,64),heltab2x1(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(16),16,nMB,G2tensor(123),n2h1(173))
  call Hloop_AS_Q(ntryL,G1H1(57),ex5(:),G1H1(31),ngH,m3h1x1(:,65),heltab2x1(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(31),63,nMB,G2tensor(124),n2h1(174))
  call Hloop_AS_Q(ntryL,G1H1(58),ex5(:),G1H1(37),ngH,m3h1x1(:,66),heltab2x1(:,:,66))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(37),63,nMB,G2tensor(125),n2h1(175))
  call Hloop_AS_Q(ntryL,G1H1(59),ex5(:),G1H1(19),ngH,m3h1x1(:,67),heltab2x1(:,:,67))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),16,nMB,G2tensor(126),n2h1(176))
  call Hloop_AS_Q(ntryL,G1H1(62),ex5(:),G1H1(6),ngH,m3h1x1(:,68),heltab2x1(:,:,68))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(6),63,nMB,G2tensor(127),n2h1(177))
  call Hloop_AS_Q(ntryL,G1H1(63),ex5(:),G1H1(20),ngH,m3h1x1(:,69),heltab2x1(:,:,69))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(20),63,nMB,G2tensor(128),n2h1(178))
  call Hloop_AS_Q(ntryL,G1H1(25),ex5(:),G1H1(7),ngH,m3h1x1(:,70),heltab2x1(:,:,70))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(7),16,nMB,G2tensor(129),n2h1(179))
  call Hloop_AS_Q(ntryL,G1H1(65),ex5(:),G1H1(88),ngH,m3h1x1(:,71),heltab2x1(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(88),63,nMB,G2tensor(130),n2h1(180))
  call Hloop_AS_Q(ntryL,G1H1(66),ex5(:),G1H1(18),ngH,m3h1x1(:,72),heltab2x1(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(18),63,nMB,G2tensor(131),n2h1(181))
  call Hloop_AS_Q(ntryL,G1H1(67),ex5(:),G1H1(26),ngH,m3h1x1(:,73),heltab2x1(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(26),16,nMB,G2tensor(132),n2h1(182))
  call Hloop_AS_Q(ntryL,G1H1(70),ex5(:),G1H1(43),ngH,m3h1x1(:,74),heltab2x1(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(43),63,nMB,G2tensor(133),n2h1(183))
  call Hloop_QS_A(ntryL,G1H1(71),ex5(:),G1H1(30),ngH,m3h1x1(:,75),heltab2x1(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(30),63,nMB,G2tensor(134),n2h1(184))
  call Hloop_QS_A(ntryL,G1H1(35),ex5(:),G1H1(28),ngH,m3h1x1(:,76),heltab2x1(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(28),16,nMB,G2tensor(135),n2h1(185))
  call Hloop_QS_A(ntryL,G1H1(73),ex5(:),G1H1(9),ngH,m3h1x1(:,77),heltab2x1(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(9),63,nMB,G2tensor(136),n2h1(186))
  call Hloop_VQ_A(ntryL,G1H2(30),wf2(:,2),G1H1(3),m3h2x1(:,75),heltab2x2(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(3),63,nMB,G2tensor(137),n2h1(187))
  call Hloop_VQ_A(ntryL,G1H2(31),wf2(:,2),G1H1(29),m3h2x1(:,76),heltab2x2(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(29),20,nMB,G2tensor(138),n2h1(188))
  call Hloop_VQ_A(ntryL,G1H2(48),wf2(:,2),G1H1(49),m3h2x1(:,77),heltab2x2(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(49),63,nMB,G2tensor(139),n2h1(189))
  call Hloop_VA_Q(ntryL,G1H2(49),wf2(:,4),G1H1(41),m3h2x1(:,78),heltab2x2(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(41),63,nMB,G2tensor(140),n2h1(190))
  call Hloop_VA_Q(ntryL,G1H2(50),wf2(:,4),G1H1(50),m3h2x1(:,79),heltab2x2(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(50),24,nMB,G2tensor(141),n2h1(191))
  call Hloop_VA_Q(ntryL,G1H2(53),wf2(:,4),G1H1(36),m3h2x1(:,80),heltab2x2(:,:,100))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(36),63,nMB,G2tensor(142),n2h1(192))
  call Hloop_AZ_Q(ntryL,G1H4(47),wf4(:,13),G1H1(51),ngZd,m3h4x1(:,64),heltab2x4(:,:,119))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(51),63,nMB,G2tensor(143),n2h1(193))
  call Hloop_AZ_Q(ntryL,G1H4(15),wf4(:,13),G1H1(10),ngZd,m3h4x1(:,65),heltab2x4(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(10),19,nMB,G2tensor(144),n2h1(194))
  call Hloop_AZ_Q(ntryL,G1H4(49),wf4(:,13),G1H1(54),ngZd,m3h4x1(:,66),heltab2x4(:,:,121))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(54),63,nMB,G2tensor(145),n2h1(195))
  call Hloop_QZ_A(ntryL,G1H4(8),wf4(:,13),G1H1(24),ngZd,m3h4x1(:,67),heltab2x4(:,:,122))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(24),63,nMB,G2tensor(146),n2h1(196))
  call Hloop_QZ_A(ntryL,G1H4(50),wf4(:,13),G1H1(55),ngZd,m3h4x1(:,68),heltab2x4(:,:,123))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(55),19,nMB,G2tensor(147),n2h1(197))
  call Hloop_QZ_A(ntryL,G1H4(53),wf4(:,13),G1H1(45),ngZd,m3h4x1(:,69),heltab2x4(:,:,124))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(45),63,nMB,G2tensor(148),n2h1(198))
  call Hloop_AS_Q(ntryL,G1H1(38),ex5(:),G1H1(13),ngH,m3h1x1(:,78),heltab2x1(:,:,78))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(13),63,nMT,G2tensor(149),n2h1(199))
  call Hloop_AS_Q(ntryL,G1H1(47),ex5(:),G1H1(16),ngH,m3h1x1(:,79),heltab2x1(:,:,79))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(16),16,nMT,G2tensor(150),n2h1(200))
  call Hloop_AS_Q(ntryL,G1H1(75),ex5(:),G1H1(57),ngH,m3h1x1(:,80),heltab2x1(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(57),63,nMT,G2tensor(151),n2h1(201))
  call Hloop_QS_A(ntryL,G1H1(22),ex5(:),G1H1(31),ngH,m3h1x1(:,81),heltab2x1(:,:,81))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(31),63,nMT,G2tensor(152),n2h1(202))
  call Hloop_QS_A(ntryL,G1H1(76),ex5(:),G1H1(58),ngH,m3h1x1(:,82),heltab2x1(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(58),16,nMT,G2tensor(153),n2h1(203))
  call Hloop_QS_A(ntryL,G1H1(79),ex5(:),G1H1(37),ngH,m3h1x1(:,83),heltab2x1(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(37),63,nMT,G2tensor(154),n2h1(204))
  call Hloop_AS_Q(ntryL,G1H1(27),ex5(:),G1H1(59),ngH,m3h1x1(:,84),heltab2x1(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(59),63,nMT,G2tensor(155),n2h1(205))
  call Hloop_AS_Q(ntryL,G1H1(80),ex5(:),G1H1(19),ngH,m3h1x1(:,85),heltab2x1(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(19),16,nMT,G2tensor(156),n2h1(206))
  call Hloop_AS_Q(ntryL,G1H1(83),ex5(:),G1H1(62),ngH,m3h1x1(:,86),heltab2x1(:,:,86))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(62),63,nMT,G2tensor(157),n2h1(207))
  call Hloop_QS_A(ntryL,G1H1(15),ex5(:),G1H1(6),ngH,m3h1x1(:,87),heltab2x1(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(6),63,nMT,G2tensor(158),n2h1(208))
  call Hloop_QS_A(ntryL,G1H1(84),ex5(:),G1H1(63),ngH,m3h1x1(:,88),heltab2x1(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(63),16,nMT,G2tensor(159),n2h1(209))
  call Hloop_QS_A(ntryL,G1H1(87),ex5(:),G1H1(20),ngH,m3h1x1(:,89),heltab2x1(:,:,89))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(20),63,nMT,G2tensor(160),n2h1(210))
  call Hloop_QV_A(ntryL,G1H4(6),wf4(:,12),G1H1(25),m3h4x1(:,70),heltab2x4(:,:,125))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(25),63,nMT,G2tensor(161),n2h1(211))
  call Hloop_QV_A(ntryL,G1H4(54),wf4(:,12),G1H1(7),m3h4x1(:,71),heltab2x4(:,:,126))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(7),12,nMT,G2tensor(162),n2h1(212))
  call Hloop_QV_A(ntryL,G1H4(57),wf4(:,12),G1H1(65),m3h4x1(:,72),heltab2x4(:,:,127))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(65),63,nMT,G2tensor(163),n2h1(213))
  call Hloop_AV_Q(ntryL,G1H4(17),wf4(:,12),G1H1(88),m3h4x1(:,73),heltab2x4(:,:,128))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(88),63,nMT,G2tensor(164),n2h1(214))
  call Hloop_AV_Q(ntryL,G1H4(58),wf4(:,12),G1H1(66),m3h4x1(:,74),heltab2x4(:,:,129))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(66),12,nMT,G2tensor(165),n2h1(215))
  call Hloop_AV_Q(ntryL,G1H4(20),wf4(:,12),G1H1(18),m3h4x1(:,75),heltab2x4(:,:,130))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(18),63,nMT,G2tensor(166),n2h1(216))
  call Hloop_QV_A(ntryL,G1H4(60),wf4(:,12),G1H1(67),m3h4x1(:,76),heltab2x4(:,:,131))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(67),63,nMB,G2tensor(167),n2h1(217))
  call Hloop_QV_A(ntryL,G1H4(62),wf4(:,12),G1H1(26),m3h4x1(:,77),heltab2x4(:,:,132))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(26),12,nMB,G2tensor(168),n2h1(218))
  call Hloop_QV_A(ntryL,G1H4(23),wf4(:,12),G1H1(70),m3h4x1(:,78),heltab2x4(:,:,133))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(70),63,nMB,G2tensor(169),n2h1(219))
  call Hloop_AV_Q(ntryL,G1H4(7),wf4(:,12),G1H1(43),m3h4x1(:,79),heltab2x4(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(43),63,nMB,G2tensor(170),n2h1(220))
  call Hloop_AV_Q(ntryL,G1H4(4),wf4(:,12),G1H1(71),m3h4x1(:,80),heltab2x4(:,:,135))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(71),12,nMB,G2tensor(171),n2h1(221))
  call Hloop_AV_Q(ntryL,G1H4(11),wf4(:,12),G1H1(30),m3h4x1(:,81),heltab2x4(:,:,136))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(30),63,nMB,G2tensor(172),n2h1(222))
  call ol_merge_tensors(G2tensor(66),[G2tensor(2),G1tensor(6)])
  call ol_merge_tensors(G2tensor(64),[G2tensor(4),G1tensor(12)])
  call ol_merge_tensors(G2tensor(44),[G2tensor(6),G1tensor(14)])
  call ol_merge_tensors(G2tensor(170),[G2tensor(167),G2tensor(11),G2tensor(7),G1tensor(24),G1tensor(18)])
  call ol_merge_tensors(G2tensor(46),[G2tensor(10),G1tensor(20),G1tensor(9)])
  call ol_merge_tensors(G2tensor(74),[G2tensor(14),G1tensor(26)])
  call ol_merge_tensors(G2tensor(137),[G2tensor(15),G1tensor(30)])
  call ol_merge_tensors(G2tensor(80),[G2tensor(18),G1tensor(32)])
  call ol_merge_tensors(G2tensor(143),[G2tensor(19),G1tensor(36)])
  call ol_merge_tensors(G2tensor(86),[G2tensor(22),G1tensor(38)])
  call ol_merge_tensors(G2tensor(140),[G2tensor(23),G1tensor(42)])
  call ol_merge_tensors(G2tensor(92),[G2tensor(26),G1tensor(44)])
  call ol_merge_tensors(G2tensor(146),[G2tensor(27),G1tensor(48)])
  call ol_merge_tensors(G2tensor(98),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(51),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(47),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(11),G1tensor(5)])
  call ol_merge_tensors(G2tensor(101),[G1tensor(45),G1tensor(8)])
  call ol_merge_tensors(G2tensor(48),[G1tensor(10)])
  call ol_merge_tensors(G2tensor(104),[G1tensor(15)])
  call ol_merge_tensors(G2tensor(107),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(68),[G1tensor(17)])
  call ol_merge_tensors(G2tensor(110),[G1tensor(21)])
  call ol_merge_tensors(G2tensor(113),[G1tensor(22)])
  call ol_merge_tensors(G2tensor(71),[G1tensor(23)])
  call ol_merge_tensors(G2tensor(116),[G1tensor(27)])
  call ol_merge_tensors(G2tensor(119),[G1tensor(28)])
  call ol_merge_tensors(G2tensor(89),[G2tensor(77),G1tensor(41),G1tensor(29)])
  call ol_merge_tensors(G2tensor(122),[G1tensor(33)])
  call ol_merge_tensors(G2tensor(134),[G2tensor(125),G1tensor(46),G1tensor(34)])
  call ol_merge_tensors(G2tensor(83),[G1tensor(35)])
  call ol_merge_tensors(G2tensor(128),[G1tensor(39)])
  call ol_merge_tensors(G2tensor(131),[G1tensor(40)])
  call ol_merge_tensors(G2tensor(95),[G1tensor(47)])
  call ol_merge_tensors(G2tensor(50),[G2tensor(49)])
  call ol_merge_tensors(G2tensor(53),[G2tensor(52)])
  call ol_merge_tensors(G2tensor(55),[G2tensor(54)])
  call ol_merge_tensors(G2tensor(57),[G2tensor(56)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(58)])
  call ol_merge_tensors(G2tensor(61),[G2tensor(60)])
  call ol_merge_tensors(G2tensor(152),[G2tensor(149)])
  call ol_merge_tensors(G2tensor(158),[G2tensor(155)])
  call ol_merge_tensors(G2tensor(164),[G2tensor(161)])
call Hotf_4pt_reduction_last(G2tensor(66),RedSet_4(2),mass4set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25))
call G_TensorShift(G1tensor(7),11)
call Hotf_4pt_reduction_last(G2tensor(64),RedSet_4(3),mass4set(:,1),  & 
G1tensor(31),G1tensor(37),G1tensor(43),G1tensor(6),G1tensor(12))
call G_TensorShift(G1tensor(37),24)
call Hotf_4pt_reduction_last(G2tensor(44),RedSet_4(37),mass4set(:,5),  & 
G1tensor(14),G1tensor(24),G1tensor(18),G1tensor(20),G1tensor(9))
call G_TensorShift(G1tensor(24),4)
call Hotf_4pt_reduction_last(G2tensor(170),RedSet_4(4),mass4set(:,2),  & 
G1tensor(26),G1tensor(30),G1tensor(32),G1tensor(36),G1tensor(38))
call G_TensorShift(G1tensor(30),12)
call Hotf_4pt_reduction_last(G2tensor(46),RedSet_4(12),mass4set(:,5),  & 
G1tensor(42),G1tensor(44),G1tensor(48),G1tensor(2),G1tensor(3))
call G_TensorShift(G1tensor(44),8)
call Hotf_4pt_reduction_last(G2tensor(74),RedSet_4(39),mass4set(:,3),  & 
G1tensor(4),G1tensor(11),G1tensor(5),G1tensor(45),G1tensor(8))
call G_TensorShift(G1tensor(11),4)
call Hotf_4pt_reduction_last(G2tensor(137),RedSet_4(5),mass4set(:,3),  & 
G1tensor(10),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(21))
call G_TensorShift(G1tensor(15),20)
call Hotf_4pt_reduction_last(G2tensor(80),RedSet_4(40),mass4set(:,4),  & 
G1tensor(22),G1tensor(23),G1tensor(27),G1tensor(28),G1tensor(41))
call G_TensorShift(G1tensor(23),3)
call Hotf_4pt_reduction_last(G2tensor(143),RedSet_4(6),mass4set(:,4),  & 
G1tensor(29),G1tensor(33),G1tensor(46),G1tensor(34),G1tensor(35))
call G_TensorShift(G1tensor(33),19)
call Hotf_4pt_reduction_last(G2tensor(86),RedSet_4(41),mass4set(:,3),  & 
G1tensor(39),G1tensor(40),G1tensor(47),G1tensor(49),G1tensor(50))
call G_TensorShift(G1tensor(40),8)
call Hotf_4pt_reduction_last(G2tensor(140),RedSet_4(7),mass4set(:,3),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
call G_TensorShift(G1tensor(52),24)
call Hotf_4pt_reduction_last(G2tensor(92),RedSet_4(42),mass4set(:,4),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
call G_TensorShift(G1tensor(57),3)
call Hotf_4pt_reduction_last(G2tensor(146),RedSet_4(8),mass4set(:,4),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
call G_TensorShift(G1tensor(62),19)
call Hotf_4pt_reduction_last(G2tensor(98),RedSet_4(43),mass4set(:,7),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
call G_TensorShift(G1tensor(67),3)
call Hotf_4pt_reduction_last(G2tensor(51),RedSet_4(9),mass4set(:,5),  & 
G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75))
call G_TensorShift(G1tensor(72),8)
call Hotf_4pt_reduction_last(G2tensor(47),RedSet_4(10),mass4set(:,1),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
call G_TensorShift(G1tensor(77),8)
call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
call G_TensorShift(G1tensor(82),8)
call Hotf_4pt_reduction_last(G2tensor(101),RedSet_4(34),mass4set(:,7),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
call G_TensorShift(G1tensor(87),16)
call Hotf_4pt_reduction_last(G2tensor(48),RedSet_4(13),mass4set(:,1),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
call G_TensorShift(G1tensor(92),8)
call Hotf_4pt_reduction_last(G2tensor(104),RedSet_4(15),mass4set(:,3),  & 
G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
call G_TensorShift(G1tensor(97),8)
call Hotf_4pt_reduction_last(G2tensor(107),RedSet_4(16),mass4set(:,3),  & 
G1tensor(101),G1tensor(102),G1tensor(103),G1tensor(104),G1tensor(105))
call G_TensorShift(G1tensor(102),8)
call Hotf_4pt_reduction_last(G2tensor(68),RedSet_4(17),mass4set(:,3),  & 
G1tensor(106),G1tensor(107),G1tensor(108),G1tensor(109),G1tensor(110))
call G_TensorShift(G1tensor(107),8)
call Hotf_4pt_reduction_last(G2tensor(110),RedSet_4(19),mass4set(:,3),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115))
call G_TensorShift(G1tensor(112),4)
call Hotf_4pt_reduction_last(G2tensor(113),RedSet_4(20),mass4set(:,3),  & 
G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
call G_TensorShift(G1tensor(117),4)
call Hotf_4pt_reduction_last(G2tensor(71),RedSet_4(21),mass4set(:,3),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125))
call G_TensorShift(G1tensor(122),4)
call Hotf_4pt_reduction_last(G2tensor(116),RedSet_4(23),mass4set(:,4),  & 
G1tensor(126),G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130))
call G_TensorShift(G1tensor(127),16)
call Hotf_4pt_reduction_last(G2tensor(119),RedSet_4(24),mass4set(:,4),  & 
G1tensor(131),G1tensor(132),G1tensor(133),G1tensor(134),G1tensor(135))
call G_TensorShift(G1tensor(132),16)
call Hotf_4pt_reduction_last(G2tensor(89),RedSet_4(25),mass4set(:,2),  & 
G1tensor(136),G1tensor(137),G1tensor(138),G1tensor(139),G1tensor(140))
call G_TensorShift(G1tensor(137),16)
call Hotf_4pt_reduction_last(G2tensor(122),RedSet_4(27),mass4set(:,7),  & 
G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144),G1tensor(145))
call G_TensorShift(G1tensor(142),16)
call Hotf_4pt_reduction_last(G2tensor(134),RedSet_4(28),mass4set(:,2),  & 
G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
call G_TensorShift(G1tensor(147),16)
call Hotf_4pt_reduction_last(G2tensor(83),RedSet_4(29),mass4set(:,4),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155))
call G_TensorShift(G1tensor(152),16)
call Hotf_4pt_reduction_last(G2tensor(128),RedSet_4(31),mass4set(:,4),  & 
G1tensor(156),G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160))
call G_TensorShift(G1tensor(157),16)
call Hotf_4pt_reduction_last(G2tensor(131),RedSet_4(32),mass4set(:,4),  & 
G1tensor(161),G1tensor(162),G1tensor(163),G1tensor(164),G1tensor(165))
call G_TensorShift(G1tensor(162),16)
call Hotf_4pt_reduction_last(G2tensor(95),RedSet_4(35),mass4set(:,4),  & 
G1tensor(166),G1tensor(167),G1tensor(168),G1tensor(169),G1tensor(170))
call G_TensorShift(G1tensor(167),16)
call Hotf_4pt_reduction_last(G2tensor(50),RedSet_4(28),mass4set(:,2),  & 
G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174),G1tensor(175),G0tensor(1))
call G_TensorShift(G1tensor(172),16)
call Hotf_4pt_reduction_last(G2tensor(53),RedSet_4(28),mass4set(:,6),  & 
G1tensor(171),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G0tensor(2))
call G_TensorShift(G1tensor(176),16)
call Hotf_4pt_reduction_last(G2tensor(55),RedSet_4(25),mass4set(:,6),  & 
G1tensor(171),G1tensor(180),G1tensor(181),G1tensor(182),G1tensor(183),G0tensor(3))
call G_TensorShift(G1tensor(180),16)
call Hotf_4pt_reduction_last(G2tensor(57),RedSet_4(25),mass4set(:,2),  & 
G1tensor(171),G1tensor(184),G1tensor(185),G1tensor(186),G1tensor(187),G0tensor(4))
call G_TensorShift(G1tensor(184),16)
call Hotf_4pt_reduction_last(G2tensor(59),RedSet_4(4),mass4set(:,6),  & 
G1tensor(171),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G0tensor(5))
call G_TensorShift(G1tensor(188),12)
call Hotf_4pt_reduction_last(G2tensor(61),RedSet_4(4),mass4set(:,2),  & 
G1tensor(171),G1tensor(192),G1tensor(193),G1tensor(194),G1tensor(195),G0tensor(6))
call G_TensorShift(G1tensor(192),12)
call Hotf_4pt_reduction_last(G2tensor(62),RedSet_4(38),mass4set(:,1),  & 
G1tensor(171),G1tensor(196),G1tensor(197),G1tensor(198),G1tensor(199))
call G_TensorShift(G1tensor(196),20)
call Hotf_4pt_reduction_last(G2tensor(152),RedSet_4(28),mass4set(:,6),  & 
G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
call G_TensorShift(G1tensor(201),16)
call Hotf_4pt_reduction_last(G2tensor(158),RedSet_4(25),mass4set(:,6),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209))
call G_TensorShift(G1tensor(206),16)
call Hotf_4pt_reduction_last(G2tensor(164),RedSet_4(4),mass4set(:,6),  & 
G1tensor(210),G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214))
call G_TensorShift(G1tensor(211),12)
call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(2),mass4set(:,1),  & 
G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10),G0tensor(11))
call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(3),mass4set(:,1),  & 
G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15),G0tensor(16))
call Hotf_4pt_reduction_last(G1tensor(14),RedSet_4(37),mass4set(:,5),  & 
G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20),G0tensor(21))
call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(4),mass4set(:,2),  & 
G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25),G0tensor(26))
call Hotf_4pt_reduction_last(G1tensor(42),RedSet_4(12),mass4set(:,5),  & 
G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30),G0tensor(31))
call Hotf_4pt_reduction_last(G1tensor(4),RedSet_4(39),mass4set(:,3),  & 
G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35),G0tensor(36))
call Hotf_4pt_reduction_last(G1tensor(10),RedSet_4(5),mass4set(:,3),  & 
G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40),G0tensor(41))
call Hotf_4pt_reduction_last(G1tensor(22),RedSet_4(40),mass4set(:,4),  & 
G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45),G0tensor(46))
call Hotf_4pt_reduction_last(G1tensor(29),RedSet_4(6),mass4set(:,4),  & 
G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50),G0tensor(51))
call Hotf_4pt_reduction_last(G1tensor(39),RedSet_4(41),mass4set(:,3),  & 
G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55),G0tensor(56))
call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(7),mass4set(:,3),  & 
G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60),G0tensor(61))
call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(42),mass4set(:,4),  & 
G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65),G0tensor(66))
call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(8),mass4set(:,4),  & 
G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70),G0tensor(71))
call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(43),mass4set(:,7),  & 
G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75),G0tensor(76))
call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(9),mass4set(:,5),  & 
G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80),G0tensor(81))
call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(10),mass4set(:,1),  & 
G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85),G0tensor(86))
call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(1),mass4set(:,1),  & 
G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90),G0tensor(91))
call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(34),mass4set(:,7),  & 
G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95),G0tensor(96))
call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(13),mass4set(:,1),  & 
G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100),G0tensor(101))
call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(15),mass4set(:,3),  & 
G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105),G0tensor(106))
call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(16),mass4set(:,3),  & 
G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110),G0tensor(111))
call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(17),mass4set(:,3),  & 
G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115),G0tensor(116))
call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(19),mass4set(:,3),  & 
G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120),G0tensor(121))
call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(20),mass4set(:,3),  & 
G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125),G0tensor(126))
call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(21),mass4set(:,3),  & 
G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130),G0tensor(131))
call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(23),mass4set(:,4),  & 
G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135),G0tensor(136))
call Hotf_4pt_reduction_last(G1tensor(131),RedSet_4(24),mass4set(:,4),  & 
G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140),G0tensor(141))
call Hotf_4pt_reduction_last(G1tensor(136),RedSet_4(25),mass4set(:,2),  & 
G0tensor(142),G0tensor(143),G0tensor(144),G0tensor(145),G0tensor(146))
call Hotf_4pt_reduction_last(G1tensor(141),RedSet_4(27),mass4set(:,7),  & 
G0tensor(147),G0tensor(148),G0tensor(149),G0tensor(150),G0tensor(151))
call Hotf_4pt_reduction_last(G1tensor(146),RedSet_4(28),mass4set(:,2),  & 
G0tensor(152),G0tensor(153),G0tensor(154),G0tensor(155),G0tensor(156))
call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(29),mass4set(:,4),  & 
G0tensor(157),G0tensor(158),G0tensor(159),G0tensor(160),G0tensor(161))
call Hotf_4pt_reduction_last(G1tensor(156),RedSet_4(31),mass4set(:,4),  & 
G0tensor(162),G0tensor(163),G0tensor(164),G0tensor(165),G0tensor(166))
call Hotf_4pt_reduction_last(G1tensor(161),RedSet_4(32),mass4set(:,4),  & 
G0tensor(167),G0tensor(168),G0tensor(169),G0tensor(170),G0tensor(171))
call Hotf_4pt_reduction_last(G1tensor(166),RedSet_4(35),mass4set(:,4),  & 
G0tensor(172),G0tensor(173),G0tensor(174),G0tensor(175),G0tensor(176))
call Hotf_4pt_reduction_last(G1tensor(171),RedSet_4(38),mass4set(:,1),  & 
G0tensor(177),G0tensor(178),G0tensor(179),G0tensor(180),G0tensor(181))
call Hotf_4pt_reduction_last(G1tensor(200),RedSet_4(28),mass4set(:,6),  & 
G0tensor(182),G0tensor(183),G0tensor(184),G0tensor(185),G0tensor(186))
call Hotf_4pt_reduction_last(G1tensor(205),RedSet_4(25),mass4set(:,6),  & 
G0tensor(187),G0tensor(188),G0tensor(189),G0tensor(190),G0tensor(191))
call Hotf_4pt_reduction_last(G1tensor(210),RedSet_4(4),mass4set(:,6),  & 
G0tensor(192),G0tensor(193),G0tensor(194),G0tensor(195),G0tensor(196))
call ol_merge_tensors(T0sum(1),[G0tensor(7)])
call ol_merge_tensors(T0sum(2),[G0tensor(12)])
call ol_merge_tensors(T0sum(3),[G0tensor(17)])
call ol_merge_tensors(T0sum(4),[G0tensor(22)])
call ol_merge_tensors(T0sum(5),[G0tensor(27)])
call ol_merge_tensors(T0sum(6),[G0tensor(32)])
call ol_merge_tensors(T0sum(7),[G0tensor(37)])
call ol_merge_tensors(T0sum(8),[G0tensor(42)])
call ol_merge_tensors(T0sum(9),[G0tensor(47)])
call ol_merge_tensors(T0sum(10),[G0tensor(52)])
call ol_merge_tensors(T0sum(11),[G0tensor(57)])
call ol_merge_tensors(T0sum(12),[G0tensor(62)])
call ol_merge_tensors(T0sum(13),[G0tensor(67)])
call ol_merge_tensors(T0sum(14),[G0tensor(72)])
call ol_merge_tensors(T0sum(15),[G0tensor(77)])
call ol_merge_tensors(T0sum(16),[G0tensor(82)])
call ol_merge_tensors(T0sum(17),[G0tensor(87)])
call ol_merge_tensors(T0sum(18),[G0tensor(92)])
call ol_merge_tensors(T0sum(19),[G0tensor(97)])
call ol_merge_tensors(T0sum(20),[G0tensor(102)])
call ol_merge_tensors(T0sum(21),[G0tensor(107)])
call ol_merge_tensors(T0sum(22),[G0tensor(112)])
call ol_merge_tensors(T0sum(23),[G0tensor(117)])
call ol_merge_tensors(T0sum(24),[G0tensor(122)])
call ol_merge_tensors(T0sum(25),[G0tensor(127)])
call ol_merge_tensors(T0sum(26),[G0tensor(132)])
call ol_merge_tensors(T0sum(27),[G0tensor(137)])
call ol_merge_tensors(T0sum(28),[G0tensor(142)])
call ol_merge_tensors(T0sum(29),[G0tensor(147)])
call ol_merge_tensors(T0sum(30),[G0tensor(152)])
call ol_merge_tensors(T0sum(31),[G0tensor(157)])
call ol_merge_tensors(T0sum(32),[G0tensor(162)])
call ol_merge_tensors(T0sum(33),[G0tensor(167)])
call ol_merge_tensors(T0sum(34),[G0tensor(172)])
call ol_merge_tensors(T0sum(35),[G0tensor(1)])
call ol_merge_tensors(T0sum(36),[G0tensor(2)])
call ol_merge_tensors(T0sum(37),[G0tensor(3)])
call ol_merge_tensors(T0sum(38),[G0tensor(4)])
call ol_merge_tensors(T0sum(39),[G0tensor(5)])
call ol_merge_tensors(T0sum(40),[G0tensor(6)])
call ol_merge_tensors(T0sum(41),[G0tensor(177)])
call ol_merge_tensors(T0sum(42),[G0tensor(182)])
call ol_merge_tensors(T0sum(43),[G0tensor(187)])
call ol_merge_tensors(T0sum(44),[G0tensor(192)])
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(26)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(40),h0tab(:,40),[32,12,19],[0,0,0],3,2,wf4(:,12),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,36),heltab2x32(:,:,40))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(1),n2h16(29))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(26)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(41),h0tab(:,41),[32,12,19],[nMT,nMT,nMT],3,2,wf4(:,12),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,37),heltab2x32(:,:,41))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(2),n2h16(30))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(26)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(42),h0tab(:,42),[32,12,19],[0,0,0],3,2,wf4(:,12),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,38),heltab2x32(:,:,42))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(3),n2h16(31))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(26)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(43),h0tab(:,43),[32,12,19],[nMT,nMT,nMT],3,2,wf4(:,12),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,39),heltab2x32(:,:,43))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(4),n2h16(32))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(26)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(44),h0tab(:,44),[32,12,19],[0,0,0],3,2,wf4(:,12),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,40),heltab2x32(:,:,44))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(5),n2h16(33))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(26)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(45),h0tab(:,45),[32,12,19],[nMB,nMB,nMB],3,2,wf4(:,12),wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,41),heltab2x32(:,:,45))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(6),n2h16(34))
Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(26)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(46),h0tab(:,46),[32,12,19],[0,0,0],3,2,wf4(:,12),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,42),heltab2x32(:,:,46))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(7),n2h16(35))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(26)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(47),h0tab(:,47),[32,12,19],[nMB,nMB,nMB],3,2,wf4(:,12),wf4(:,13))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,43),heltab2x32(:,:,47))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(8),n2h16(36))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(86)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(48),h0tab(:,48),[40,3,20],[nMB,nMB,0],3,3,wf4(:,4),wf4(:,3),wf2(:,2))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,4),G0H8(1),m3h4x8(:,5),heltab2x32(:,:,48))
  call Hloop_A_Q(ntryL,G0H8(1),40,nMB,G1H8(7),n2h8(28))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(49),h0tab(:,49),[32,11,20],[nMB,0,nMB],3,2,wf8(:,3),wf2(:,2))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,44),heltab2x32(:,:,49))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(9),n2h16(37))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(8)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(50),h0tab(:,50),[32,11,20],[0,nMB,0],3,2,wf8(:,3),wf2(:,2))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(10),m3h2x16(:,45),heltab2x32(:,:,50))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(29)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(51),h0tab(:,51),[32,3,28],[0,0,0],3,2,wf4(:,3),wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,46),heltab2x32(:,:,51))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(11),n2h16(38))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(29)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(52),h0tab(:,52),[32,3,28],[nMT,nMT,nMT],3,2,wf4(:,3),wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,47),heltab2x32(:,:,52))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(12),n2h16(39))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(29)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(53),h0tab(:,53),[32,3,28],[0,0,0],3,2,wf4(:,3),wf4(:,15))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,48),heltab2x32(:,:,53))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(13),n2h16(40))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(29)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(54),h0tab(:,54),[32,3,28],[nMT,nMT,nMT],3,2,wf4(:,3),wf4(:,15))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,49),heltab2x32(:,:,54))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(14),n2h16(41))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(29)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(55),h0tab(:,55),[32,3,28],[0,0,0],3,2,wf4(:,3),wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,50),heltab2x32(:,:,55))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(15),n2h16(42))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(29)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(56),h0tab(:,56),[32,3,28],[nMB,nMB,nMB],3,2,wf4(:,3),wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,51),heltab2x32(:,:,56))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(16),n2h16(43))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(29)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(57),h0tab(:,57),[32,3,28],[0,0,0],3,2,wf4(:,3),wf4(:,15))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,52),heltab2x32(:,:,57))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(17),n2h16(44))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(29)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(58),h0tab(:,58),[32,3,28],[nMB,nMB,nMB],3,2,wf4(:,3),wf4(:,15))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,53),heltab2x32(:,:,58))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(18),n2h16(45))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(38)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(59),h0tab(:,59),[52,3,8],[nMB,nMB,0],3,2,wf4(:,23),wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,23),G0H8(2),m3h4x8(:,6),heltab2x32(:,:,59))
  call Hloop_Q_A(ntryL,G0H8(2),52,nMB,G1H8(1),n2h8(29))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(53)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(60),h0tab(:,60),[32,8,23],[nMB,0,nMB],3,1,wf8(:,22))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,54),heltab2x32(:,:,60))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(19),n2h16(46))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(53)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(61),h0tab(:,61),[32,8,23],[0,nMB,0],3,1,wf8(:,22))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(20),m3h2x16(:,55),heltab2x32(:,:,61))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(87)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(62),h0tab(:,62),[36,3,24],[nMB,nMB,0],3,3,wf4(:,7),wf4(:,3),wf2(:,4))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,7),G0H8(1),m3h4x8(:,7),heltab2x32(:,:,62))
  call Hloop_Q_A(ntryL,G0H8(1),36,nMB,G1H8(8),n2h8(30))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(63),h0tab(:,63),[32,7,24],[nMB,0,nMB],3,2,wf8(:,5),wf2(:,4))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,56),heltab2x32(:,:,63))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(21),n2h16(47))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(15)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(64),h0tab(:,64),[32,7,24],[0,nMB,0],3,2,wf8(:,5),wf2(:,4))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(22),m3h2x16(:,57),heltab2x32(:,:,64))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(65),h0tab(:,65),[32,3,28],[0,0,0],3,2,wf4(:,3),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,58),heltab2x32(:,:,65))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(23),n2h16(48))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(66),h0tab(:,66),[32,3,28],[nMT,nMT,nMT],3,2,wf4(:,3),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,59),heltab2x32(:,:,66))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(24),n2h16(49))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(67),h0tab(:,67),[32,3,28],[0,0,0],3,2,wf4(:,3),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,60),heltab2x32(:,:,67))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(25),n2h16(50))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(68),h0tab(:,68),[32,3,28],[nMT,nMT,nMT],3,2,wf4(:,3),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,61),heltab2x32(:,:,68))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(26),n2h16(51))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(69),h0tab(:,69),[32,3,28],[0,0,0],3,2,wf4(:,3),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,62),heltab2x32(:,:,69))
  call Hloop_A_Q(ntryL,G0H16(1),32,0,G1H16(27),n2h16(52))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(70),h0tab(:,70),[32,3,28],[nMB,nMB,nMB],3,2,wf4(:,3),wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,63),heltab2x32(:,:,70))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(28),n2h16(53))
Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(71),h0tab(:,71),[32,3,28],[0,0,0],3,2,wf4(:,3),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,64),heltab2x32(:,:,71))
  call Hloop_Q_A(ntryL,G0H16(1),32,0,G1H16(29),n2h16(54))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(72),h0tab(:,72),[32,3,28],[nMB,nMB,nMB],3,2,wf4(:,3),wf4(:,17))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,65),heltab2x32(:,:,72))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(30),n2h16(55))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(44)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(73),h0tab(:,73),[56,3,4],[nMB,nMB,0],3,2,wf4(:,29),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,29),G0H8(2),m3h4x8(:,8),heltab2x32(:,:,73))
  call Hloop_A_Q(ntryL,G0H8(2),56,nMB,G1H8(13),n2h8(31))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(60)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(74),h0tab(:,74),[32,4,27],[nMB,0,nMB],3,1,wf8(:,25))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,66),heltab2x32(:,:,74))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(31),n2h16(56))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(60)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(75),h0tab(:,75),[32,4,27],[0,nMB,0],3,1,wf8(:,25))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(32),m3h2x16(:,67),heltab2x32(:,:,75))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(16)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(76),h0tab(:,76),[36,11,16],[0,nMB,nMB],3,2,wf4(:,7),wf8(:,3))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,7),G0H8(1),m3h4x8(:,9),heltab2x32(:,:,76))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(39)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(77),h0tab(:,77),[36,8,19],[0,nMB,nMB],3,2,wf4(:,7),wf4(:,13))
  call Hloop_AQ_V(ntryL,G0H32(1),wf4(:,7),G0H8(2),m3h4x8(:,10),heltab2x32(:,:,77))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(41)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(78),h0tab(:,78),[52,3,8],[nMB,nMB,0],3,2,wf4(:,26),wf4(:,3))
  call Hloop_VQ_A(ntryL,G0H32(1),wf4(:,26),G0H8(3),m3h4x8(:,11),heltab2x32(:,:,78))
  call Hloop_Q_A(ntryL,G0H8(3),52,nMB,G1H8(5),n2h8(32))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(63)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(79),h0tab(:,79),[39,8,16],[0,nMB,nMB],3,1,wf16(:,6))
  call Hloop_AQ_V(ntryL,G0H32(1),wf16(:,6),G0H2(1),m3h16x2(:,1),heltab2x32(:,:,79))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(20)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(80),h0tab(:,80),[40,7,16],[0,nMB,nMB],3,2,wf4(:,4),wf8(:,5))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,4),G0H8(3),m3h4x8(:,12),heltab2x32(:,:,80))
Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(45)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(81),h0tab(:,81),[40,4,19],[0,nMB,nMB],3,2,wf4(:,4),wf4(:,13))
  call Hloop_QA_V(ntryL,G0H32(1),wf4(:,4),G0H8(4),m3h4x8(:,13),heltab2x32(:,:,81))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(47)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(82),h0tab(:,82),[56,3,4],[nMB,nMB,0],3,2,wf4(:,32),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H32(1),wf4(:,32),G0H8(5),m3h4x8(:,14),heltab2x32(:,:,82))
  call Hloop_A_Q(ntryL,G0H8(5),56,nMB,G1H8(10),n2h8(33))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(50)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(83),h0tab(:,83),[43,4,16],[0,nMB,nMB],3,1,wf16(:,5))
  call Hloop_QA_V(ntryL,G0H32(1),wf16(:,5),G0H2(2),m3h16x2(:,2),heltab2x32(:,:,83))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(77)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(84),h0tab(:,84),[32,15,16],[nMT,nMT,nMT],3,1,wf16(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,68),heltab2x32(:,:,84))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(33),n2h16(57))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(77)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(85),h0tab(:,85),[32,15,16],[nMT,nMT,nMT],3,1,wf16(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,69),heltab2x32(:,:,85))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(34),n2h16(58))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(77)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(86),h0tab(:,86),[32,15,16],[nMB,nMB,nMB],3,1,wf16(:,7))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,70),heltab2x32(:,:,86))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(35),n2h16(59))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(77)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(87),h0tab(:,87),[32,15,16],[nMB,nMB,nMB],3,1,wf16(:,7))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,71),heltab2x32(:,:,87))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(36),n2h16(60))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(78)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(88),h0tab(:,88),[32,8,23],[nMB,0,nMB],3,1,wf8(:,30))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,72),heltab2x32(:,:,88))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(37),n2h16(61))
Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(78)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(89),h0tab(:,89),[32,8,23],[0,nMB,0],3,1,wf8(:,30))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(38),m3h2x16(:,73),heltab2x32(:,:,89))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(79)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(90),h0tab(:,90),[39,8,16],[0,nMB,nMB],3,1,wf16(:,9))
  call Hloop_AQ_V(ntryL,G0H32(1),wf16(:,9),G0H2(3),m3h16x2(:,3),heltab2x32(:,:,90))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(80)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(91),h0tab(:,91),[32,15,16],[nMT,nMT,nMT],3,1,wf16(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,74),heltab2x32(:,:,91))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMT,G1H16(39),n2h16(62))
Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(80)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(92),h0tab(:,92),[32,15,16],[nMT,nMT,nMT],3,1,wf16(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,75),heltab2x32(:,:,92))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMT,G1H16(40),n2h16(63))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(80)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(93),h0tab(:,93),[32,15,16],[nMB,nMB,nMB],3,1,wf16(:,10))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,76),heltab2x32(:,:,93))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(41),n2h16(64))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(80)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(94),h0tab(:,94),[32,15,16],[nMB,nMB,nMB],3,1,wf16(:,10))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,77),heltab2x32(:,:,94))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(42),n2h16(65))
Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(81)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(95),h0tab(:,95),[32,4,27],[nMB,0,nMB],3,1,wf8(:,32))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,78),heltab2x32(:,:,95))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(43),n2h16(66))
Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(81)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(96),h0tab(:,96),[32,4,27],[0,nMB,0],3,1,wf8(:,32))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(44),m3h2x16(:,79),heltab2x32(:,:,96))
Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(82)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(97),h0tab(:,97),[43,4,16],[0,nMB,nMB],3,1,wf16(:,12))
  call Hloop_QA_V(ntryL,G0H32(1),wf16(:,12),G0H2(4),m3h16x2(:,4),heltab2x32(:,:,97))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(83)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(98),h0tab(:,98),[32,8,23],[nMB,0,nMB],3,1,wf8(:,34))
  call Hloop_QV_A(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,80),heltab2x32(:,:,98))
  call Hloop_Q_A(ntryL,G0H16(1),32,nMB,G1H16(45),n2h16(67))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(83)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(99),h0tab(:,99),[32,8,23],[0,nMB,0],3,1,wf8(:,34))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(46),m3h2x16(:,81),heltab2x32(:,:,99))
Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(84)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(100),h0tab(:,100),[32,4,27],[nMB,0,nMB],3,1,wf8(:,36))
  call Hloop_AV_Q(ntryL,G0H32(1),ex6(:),G0H16(1),m3h2x16(:,82),heltab2x32(:,:,100))
  call Hloop_A_Q(ntryL,G0H16(1),32,nMB,G1H16(47),n2h16(68))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(84)
call G0_hol_initialisation(ntryL,Gcoeff,G0H32(1),m0h(101),h0tab(:,101),[32,4,27],[0,nMB,0],3,1,wf8(:,36))
  call Hloop_UV_W(ntryL,G0H32(1),0,ex6(:),32,G1H16(48),m3h2x16(:,83),heltab2x32(:,:,101))
  call ol_merge(ntryL,G1H2(33),[G1H2(17)])
  call ol_merge(ntryL,G1H8(5),[G1H8(1),G1H8(9),G1H8(6)])
  call ol_merge(ntryL,G1H8(7),[G1H8(16)])
  call ol_merge(ntryL,G1H8(8),[G1H8(22)])
  call ol_merge(ntryL,G1H8(10),[G1H8(13)])
  call ol_merge(ntryL,G0H2(3),[G0H2(1)])
  call ol_merge(ntryL,G0H2(4),[G0H2(2)])
  call Hloop_AS_Q(ntryL,G1H2(20),ex5(:),G1H2(14),ngH,m3h1x2(:,21),heltab2x2(:,:,101))
  call Hloop_A_Q(ntryL,G1H2(14),59,nMB,G2H2(2),n2h2(58))
  call Hloop_QS_A(ntryL,G1H2(33),ex5(:),G1H2(4),ngH,m3h1x2(:,22),heltab2x2(:,:,102))
  call Hloop_Q_A(ntryL,G1H2(4),55,nMB,G2H2(11),n2h2(59))
  call Hloop_QZ_A(ntryL,G1H8(5),wf4(:,3),G1H2(34),ngZd,m3h4x2(:,31),heltab2x8(:,:,60))
  call Hloop_Q_A(ntryL,G1H2(34),55,nMB,G2H2(18),n2h2(60))
  call Hloop_AZ_Q(ntryL,G1H4(12),wf4(:,3),G1H1(35),ngZd,m3h4x1(:,82),heltab2x4(:,:,137))
  call Hloop_A_Q(ntryL,G1H1(35),47,nMB,G2H1(2),n2h1(223))
  call Hloop_QZ_A(ntryL,G1H4(10),wf4(:,3),G1H1(28),ngZd,m3h4x1(:,83),heltab2x4(:,:,138))
  call Hloop_Q_A(ntryL,G1H1(28),47,nMB,G2H1(6),n2h1(224))
  call Hloop_AZ_Q(ntryL,G1H4(16),wf4(:,3),G1H1(73),ngZu,m3h4x1(:,84),heltab2x4(:,:,139))
  call Hloop_A_Q(ntryL,G1H1(73),47,nMT,G2H1(13),n2h1(225))
  call Hloop_QZ_A(ntryL,G1H4(21),wf4(:,3),G1H1(9),ngZu,m3h4x1(:,85),heltab2x4(:,:,140))
  call Hloop_Q_A(ntryL,G1H1(9),47,nMT,G2H1(15),n2h1(226))
  call Hloop_AV_Q(ntryL,G1H4(26),wf4(:,12),G1H1(3),m3h4x1(:,86),heltab2x4(:,:,141))
  call Hloop_A_Q(ntryL,G1H1(3),47,nMT,G2H1(5),n2h1(227))
  call Hloop_QV_A(ntryL,G1H4(31),wf4(:,12),G1H1(29),m3h4x1(:,87),heltab2x4(:,:,142))
  call Hloop_Q_A(ntryL,G1H1(29),47,nMT,G2H1(7),n2h1(228))
  call Hloop_AV_Q(ntryL,G1H4(36),wf4(:,12),G1H1(49),m3h4x1(:,88),heltab2x4(:,:,143))
  call Hloop_A_Q(ntryL,G1H1(49),47,nMB,G2H1(9),n2h1(229))
  call Hloop_QV_A(ntryL,G1H4(41),wf4(:,12),G1H1(41),m3h4x1(:,89),heltab2x4(:,:,144))
  call Hloop_Q_A(ntryL,G1H1(41),47,nMB,G2H1(33),n2h1(230))
  call Hloop_QS_A(ntryL,G1H4(46),ex5(:),G1H4(19),ngH,m3h1x4(:,38),heltab2x4(:,:,145))
  call Hloop_Q_A(ntryL,G1H4(19),51,nMT,G2H4(2),n2h4(70))
  call Hloop_AS_Q(ntryL,G1H4(51),ex5(:),G1H4(24),ngH,m3h1x4(:,39),heltab2x4(:,:,146))
  call Hloop_A_Q(ntryL,G1H4(24),51,nMT,G2H4(5),n2h4(71))
  call Hloop_QS_A(ntryL,G1H4(56),ex5(:),G1H4(29),ngH,m3h1x4(:,40),heltab2x4(:,:,147))
  call Hloop_Q_A(ntryL,G1H4(29),51,nMB,G2H4(4),n2h4(72))
  call Hloop_AS_Q(ntryL,G1H4(61),ex5(:),G1H4(30),ngH,m3h1x4(:,41),heltab2x4(:,:,148))
  call Hloop_A_Q(ntryL,G1H4(30),51,nMB,G2H4(8),n2h4(73))
  call Hloop_AZ_Q(ntryL,G1H8(7),wf4(:,3),G1H2(8),ngZd,m3h4x2(:,32),heltab2x8(:,:,61))
  call Hloop_A_Q(ntryL,G1H2(8),43,nMB,G2H2(13),n2h2(61))
  call Hloop_QZ_A(ntryL,G1H8(8),wf4(:,3),G1H2(35),ngZd,m3h4x2(:,33),heltab2x8(:,:,62))
  call Hloop_Q_A(ntryL,G1H2(35),39,nMB,G2H2(21),n2h2(62))
  call Hloop_QS_A(ntryL,G1H8(26),ex5(:),G1H8(11),ngH,m3h1x8(:,9),heltab2x8(:,:,63))
  call Hloop_Q_A(ntryL,G1H8(11),52,nMB,G2H8(4),n2h8(34))
  call Hloop_QZ_A(ntryL,G1H8(18),wf4(:,13),G1H2(29),ngZd,m3h4x2(:,34),heltab2x8(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(29),55,nMB,G2H2(20),n2h2(63))
  call Hloop_AV_Q(ntryL,G1H16(1),wf4(:,12),G1H4(34),m3h4x4(:,21),heltab2x16(:,:,36))
  call Hloop_A_Q(ntryL,G1H4(34),44,0,G2H4(1),n2h4(74))
  call Hloop_AV_Q(ntryL,G1H16(2),wf4(:,12),G1H4(35),m3h4x4(:,22),heltab2x16(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(35),44,nMT,G2H4(22),n2h4(75))
  call Hloop_QV_A(ntryL,G1H16(3),wf4(:,12),G1H4(37),m3h4x4(:,23),heltab2x16(:,:,38))
  call Hloop_Q_A(ntryL,G1H4(37),44,0,G2H4(10),n2h4(76))
  call Hloop_QV_A(ntryL,G1H16(4),wf4(:,12),G1H4(40),m3h4x4(:,24),heltab2x16(:,:,39))
  call Hloop_Q_A(ntryL,G1H4(40),44,nMT,G2H4(12),n2h4(77))
  call Hloop_AV_Q(ntryL,G1H16(5),wf4(:,12),G1H4(42),m3h4x4(:,25),heltab2x16(:,:,40))
  call Hloop_A_Q(ntryL,G1H4(42),44,0,G2H4(18),n2h4(78))
  call Hloop_AV_Q(ntryL,G1H16(6),wf4(:,12),G1H4(43),m3h4x4(:,26),heltab2x16(:,:,41))
  call Hloop_A_Q(ntryL,G1H4(43),44,nMB,G2H4(20),n2h4(79))
  call Hloop_QV_A(ntryL,G1H16(7),wf4(:,12),G1H4(45),m3h4x4(:,27),heltab2x16(:,:,42))
  call Hloop_Q_A(ntryL,G1H4(45),44,0,G2H4(3),n2h4(80))
  call Hloop_QV_A(ntryL,G1H16(8),wf4(:,12),G1H4(47),m3h4x4(:,28),heltab2x16(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(47),44,nMB,G2H4(23),n2h4(81))
  call Hloop_QA_V(ntryL,G1H16(9),wf8(:,3),G1H2(22),m3h8x2(:,4),heltab2x16(:,:,44))
  call Hloop_VA_Q(ntryL,G1H16(10),wf8(:,3),G1H2(13),m3h8x2(:,5),heltab2x16(:,:,45))
  call Hloop_A_Q(ntryL,G1H2(13),43,nMB,G2H2(16),n2h2(64))
  call Hloop_AZ_Q(ntryL,G1H16(11),wf4(:,3),G1H4(15),ngZu,m3h4x4(:,29),heltab2x16(:,:,46))
  call Hloop_A_Q(ntryL,G1H4(15),35,0,G2H4(25),n2h4(82))
  call Hloop_AZ_Q(ntryL,G1H16(12),wf4(:,3),G1H4(49),ngZu,m3h4x4(:,30),heltab2x16(:,:,47))
  call Hloop_A_Q(ntryL,G1H4(49),35,nMT,G2H4(26),n2h4(83))
  call Hloop_QZ_A(ntryL,G1H16(13),wf4(:,3),G1H4(8),ngZu,m3h4x4(:,31),heltab2x16(:,:,48))
  call Hloop_Q_A(ntryL,G1H4(8),35,0,G2H4(27),n2h4(84))
  call Hloop_QZ_A(ntryL,G1H16(14),wf4(:,3),G1H4(50),ngZu,m3h4x4(:,32),heltab2x16(:,:,49))
  call Hloop_Q_A(ntryL,G1H4(50),35,nMT,G2H4(28),n2h4(85))
  call Hloop_AZ_Q(ntryL,G1H16(15),wf4(:,3),G1H4(53),ngZd,m3h4x4(:,33),heltab2x16(:,:,50))
  call Hloop_A_Q(ntryL,G1H4(53),35,0,G2H4(29),n2h4(86))
  call Hloop_AZ_Q(ntryL,G1H16(16),wf4(:,3),G1H4(6),ngZd,m3h4x4(:,34),heltab2x16(:,:,51))
  call Hloop_A_Q(ntryL,G1H4(6),35,nMB,G2H4(30),n2h4(87))
  call Hloop_QZ_A(ntryL,G1H16(17),wf4(:,3),G1H4(54),ngZd,m3h4x4(:,35),heltab2x16(:,:,52))
  call Hloop_Q_A(ntryL,G1H4(54),35,0,G2H4(31),n2h4(88))
  call Hloop_QZ_A(ntryL,G1H16(18),wf4(:,3),G1H4(57),ngZd,m3h4x4(:,36),heltab2x16(:,:,53))
  call Hloop_Q_A(ntryL,G1H4(57),35,nMB,G2H4(32),n2h4(89))
  call Hloop_QA_V(ntryL,G1H16(19),ex4(:),G1H8(17),m3h2x8(:,13),heltab2x16(:,:,54))
  call Hloop_VA_Q(ntryL,G1H16(20),ex4(:),G1H8(19),m3h2x8(:,14),heltab2x16(:,:,55))
  call Hloop_A_Q(ntryL,G1H8(19),40,nMB,G2H8(5),n2h8(35))
  call Hloop_AQ_V(ntryL,G1H16(21),wf8(:,5),G1H2(15),m3h8x2(:,6),heltab2x16(:,:,56))
  call Hloop_VQ_A(ntryL,G1H16(22),wf8(:,5),G1H2(26),m3h8x2(:,7),heltab2x16(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(26),39,nMB,G2H2(15),n2h2(65))
  call Hloop_AZ_Q(ntryL,G1H16(23),wf4(:,3),G1H4(17),ngZu,m3h4x4(:,37),heltab2x16(:,:,58))
  call Hloop_A_Q(ntryL,G1H4(17),35,0,G2H4(33),n2h4(90))
  call Hloop_AZ_Q(ntryL,G1H16(24),wf4(:,3),G1H4(58),ngZu,m3h4x4(:,38),heltab2x16(:,:,59))
  call Hloop_A_Q(ntryL,G1H4(58),35,nMT,G2H4(34),n2h4(91))
  call Hloop_QZ_A(ntryL,G1H16(25),wf4(:,3),G1H4(20),ngZu,m3h4x4(:,39),heltab2x16(:,:,60))
  call Hloop_Q_A(ntryL,G1H4(20),35,0,G2H4(35),n2h4(92))
  call Hloop_QZ_A(ntryL,G1H16(26),wf4(:,3),G1H4(60),ngZu,m3h4x4(:,40),heltab2x16(:,:,61))
  call Hloop_Q_A(ntryL,G1H4(60),35,nMT,G2H4(36),n2h4(93))
  call Hloop_AZ_Q(ntryL,G1H16(27),wf4(:,3),G1H4(62),ngZd,m3h4x4(:,41),heltab2x16(:,:,62))
  call Hloop_A_Q(ntryL,G1H4(62),35,0,G2H4(37),n2h4(94))
  call Hloop_AZ_Q(ntryL,G1H16(28),wf4(:,3),G1H4(23),ngZd,m3h4x4(:,42),heltab2x16(:,:,63))
  call Hloop_A_Q(ntryL,G1H4(23),35,nMB,G2H4(38),n2h4(95))
  call Hloop_QZ_A(ntryL,G1H16(29),wf4(:,3),G1H4(7),ngZd,m3h4x4(:,43),heltab2x16(:,:,64))
  call Hloop_Q_A(ntryL,G1H4(7),35,0,G2H4(39),n2h4(96))
  call Hloop_QZ_A(ntryL,G1H16(30),wf4(:,3),G1H4(4),ngZd,m3h4x4(:,44),heltab2x16(:,:,65))
  call Hloop_Q_A(ntryL,G1H4(4),35,nMB,G2H4(40),n2h4(97))
  call Hloop_AZ_Q(ntryL,G1H8(10),wf4(:,3),G1H2(16),ngZd,m3h4x2(:,35),heltab2x8(:,:,65))
  call Hloop_A_Q(ntryL,G1H2(16),59,nMB,G2H2(19),n2h2(66))
  call Hloop_AQ_V(ntryL,G1H16(31),ex3(:),G1H8(20),m3h2x8(:,15),heltab2x16(:,:,66))
  call Hloop_VQ_A(ntryL,G1H16(32),ex3(:),G1H8(21),m3h2x8(:,16),heltab2x16(:,:,67))
  call Hloop_Q_A(ntryL,G1H8(21),36,nMB,G2H8(6),n2h8(36))
  call Hloop_VA_Q(ntryL,G0H8(1),wf8(:,3),G0H1(1),m3h8x1(:,6),heltab2x8(:,:,66))
  call Hloop_A_Q(ntryL,G0H1(1),47,nMB,G1H1(50),n2h1(231))
  call Hloop_VA_Q(ntryL,G0H8(2),ex4(:),G0H4(5),m3h2x4(:,17),heltab2x8(:,:,67))
  call Hloop_A_Q(ntryL,G0H4(5),44,nMB,G1H4(11),n2h4(98))
  call Hloop_VA_Q(ntryL,G0H2(3),ex4(:),G0H1(1),m3h2x1(:,81),heltab2x2(:,:,103))
  call Hloop_A_Q(ntryL,G0H1(1),47,nMB,G1H1(36),n2h1(232))
  call Hloop_VQ_A(ntryL,G0H8(3),wf8(:,5),G0H1(1),m3h8x1(:,7),heltab2x8(:,:,68))
  call Hloop_Q_A(ntryL,G0H1(1),47,nMB,G1H1(51),n2h1(233))
  call Hloop_VQ_A(ntryL,G0H8(4),ex3(:),G0H4(6),m3h2x4(:,18),heltab2x8(:,:,69))
  call Hloop_Q_A(ntryL,G0H4(6),44,nMB,G1H4(12),n2h4(99))
  call Hloop_VQ_A(ntryL,G0H2(4),ex3(:),G0H1(1),m3h2x1(:,82),heltab2x2(:,:,104))
  call Hloop_Q_A(ntryL,G0H1(1),47,nMB,G1H1(10),n2h1(234))
  call Hloop_AV_Q(ntryL,G1H16(33),wf16(:,7),G1H1(54),m3h16x1(:,1),heltab2x16(:,:,68))
  call Hloop_A_Q(ntryL,G1H1(54),47,nMT,G2H1(8),n2h1(235))
  call Hloop_QV_A(ntryL,G1H16(34),wf16(:,7),G1H1(24),m3h16x1(:,2),heltab2x16(:,:,69))
  call Hloop_Q_A(ntryL,G1H1(24),47,nMT,G2H1(16),n2h1(236))
  call Hloop_AV_Q(ntryL,G1H16(35),wf16(:,7),G1H1(55),m3h16x1(:,3),heltab2x16(:,:,70))
  call Hloop_A_Q(ntryL,G1H1(55),47,nMB,G2H1(18),n2h1(237))
  call Hloop_QV_A(ntryL,G1H16(36),wf16(:,7),G1H1(45),m3h16x1(:,4),heltab2x16(:,:,71))
  call Hloop_Q_A(ntryL,G1H1(45),47,nMB,G2H1(11),n2h1(238))
  call Hloop_QA_V(ntryL,G1H16(37),ex4(:),G1H8(23),m3h2x8(:,17),heltab2x16(:,:,72))
  call Hloop_VA_Q(ntryL,G1H16(38),ex4(:),G1H8(24),m3h2x8(:,18),heltab2x16(:,:,73))
  call Hloop_A_Q(ntryL,G1H8(24),40,nMB,G2H8(2),n2h8(37))
  call Hloop_AV_Q(ntryL,G1H16(39),wf16(:,10),G1H1(38),m3h16x1(:,5),heltab2x16(:,:,74))
  call Hloop_A_Q(ntryL,G1H1(38),47,nMT,G2H1(19),n2h1(239))
  call Hloop_QV_A(ntryL,G1H16(40),wf16(:,10),G1H1(13),m3h16x1(:,6),heltab2x16(:,:,75))
  call Hloop_Q_A(ntryL,G1H1(13),47,nMT,G2H1(21),n2h1(240))
  call Hloop_AV_Q(ntryL,G1H16(41),wf16(:,10),G1H1(47),m3h16x1(:,7),heltab2x16(:,:,76))
  call Hloop_A_Q(ntryL,G1H1(47),47,nMB,G2H1(34),n2h1(241))
  call Hloop_QV_A(ntryL,G1H16(42),wf16(:,10),G1H1(16),m3h16x1(:,8),heltab2x16(:,:,77))
  call Hloop_Q_A(ntryL,G1H1(16),47,nMB,G2H1(22),n2h1(242))
  call Hloop_AQ_V(ntryL,G1H16(43),ex3(:),G1H8(14),m3h2x8(:,19),heltab2x16(:,:,78))
  call Hloop_VQ_A(ntryL,G1H16(44),ex3(:),G1H8(2),m3h2x8(:,20),heltab2x16(:,:,79))
  call Hloop_Q_A(ntryL,G1H8(2),36,nMB,G2H8(3),n2h8(38))
  call Hloop_QA_V(ntryL,G1H16(45),ex4(:),G1H8(25),m3h2x8(:,21),heltab2x16(:,:,80))
  call Hloop_VA_Q(ntryL,G1H16(46),ex4(:),G1H8(27),m3h2x8(:,22),heltab2x16(:,:,81))
  call Hloop_A_Q(ntryL,G1H8(27),40,nMB,G2H8(7),n2h8(39))
  call Hloop_AQ_V(ntryL,G1H16(47),ex3(:),G1H8(4),m3h2x8(:,23),heltab2x16(:,:,82))
  call Hloop_VQ_A(ntryL,G1H16(48),ex3(:),G1H8(28),m3h2x8(:,24),heltab2x16(:,:,83))
  call Hloop_Q_A(ntryL,G1H8(28),36,nMB,G2H8(8),n2h8(40))
  call ol_merge(ntryL,G2H2(20),[G2H2(40),G2H2(31),G2H2(1),G2H2(14)])
  call ol_merge(ntryL,G2H2(49),[G2H2(37),G2H2(34),G2H2(6),G2H2(17)])
call ol_merge_last(G1H1(32), G1H1(32)) 
  call ol_merge(ntryL,G2H1(40),[G1H1(32)])
  call ol_merge(ntryL,G2H1(2),[G1H1(60),G1H1(12)])
call HGT_OLR(G2H1(40),1,1,1)
call HGT_invQ_OLR(G2H1(40),2,5,1)
call HGT_OLR(G2H1(40),6,15,1)
  call ol_merge(ntryL,G2H1(40),[G2H1(2)])
call ol_merge_last(G1H1(11), G1H1(11)) 
  call ol_merge(ntryL,G2H1(39),[G1H1(11)])
  call ol_merge(ntryL,G2H1(6),[G1H1(34),G1H1(40)])
call HGT_OLR(G2H1(39),1,1,1)
call HGT_invQ_OLR(G2H1(39),2,5,1)
call HGT_OLR(G2H1(39),6,15,1)
  call ol_merge(ntryL,G2H1(39),[G2H1(6)])
call HGT_w2_OLR(G1H4(64),1,1,4)
call HGT_w2_invQ_OLR(G1H4(64),2,5,4)
  call ol_merge(ntryL,G1H4(64),[G1H4(5)])
  call ol_merge(ntryL,G1H1(51),[G1H1(46),G1H1(14)])
call HGT_w2_OLR(G1H1(33),1,1,1)
call HGT_w2_invQ_OLR(G1H1(33),2,5,1)
  call ol_merge(ntryL,G1H1(33),[G1H1(51)])
call HGT_OLR(G2H4(6),1,1,4)
call HGT_invQ_OLR(G2H4(6),2,5,4)
call HGT_OLR(G2H4(6),6,15,4)
  call ol_merge(ntryL,G2H4(6),[G1H4(33)])
  call ol_merge(ntryL,G2H1(34),[G2H1(18),G2H1(32),G2H1(14),G1H1(69),G1H1(61),G1H1(1),G1H1(8)])
call HGT_OLR(G2H4(9),1,1,4)
call HGT_invQ_OLR(G2H4(9),2,5,4)
call HGT_OLR(G2H4(9),6,15,4)
  call ol_merge(ntryL,G2H4(9),[G1H4(39)])
  call ol_merge(ntryL,G2H1(22),[G2H1(11),G2H1(35),G2H1(17),G1H1(72),G1H1(53),G1H1(17),G1H1(5)])
call HGT_w2_OLR(G1H4(9),1,1,4)
call HGT_w2_invQ_OLR(G1H4(9),2,5,4)
  call ol_merge(ntryL,G1H4(9),[G1H4(44)])
  call ol_merge(ntryL,G2H1(19),[G2H1(8),G2H1(26),G2H1(20),G1H1(82),G1H1(74)])
  call ol_merge(ntryL,G2H1(21),[G2H1(16),G2H1(29),G2H1(23),G1H1(86),G1H1(78)])
  call ol_merge(ntryL,G2H1(15),[G1H1(77)])
call HGT_OLR(G2H1(37),1,1,1)
call HGT_invQ_OLR(G2H1(37),2,5,1)
call HGT_OLR(G2H1(37),6,15,1)
  call ol_merge(ntryL,G2H1(37),[G2H1(15)])
  call ol_merge(ntryL,G2H4(7),[G1H4(55)])
  call ol_merge(ntryL,G2H1(13),[G1H1(44)])
call HGT_OLR(G2H1(38),1,1,1)
call HGT_invQ_OLR(G2H1(38),2,5,1)
call HGT_OLR(G2H1(38),6,15,1)
  call ol_merge(ntryL,G2H1(38),[G2H1(13)])
  call ol_merge(ntryL,G2H4(16),[G1H4(59)])
  call ol_merge(ntryL,G2H4(14),[G1H4(63)])
  call ol_merge(ntryL,G2H4(24),[G1H4(3)])
call HGT_w2_OLR(G1H4(25),1,1,4)
call HGT_w2_invQ_OLR(G1H4(25),2,5,4)
  call ol_merge(ntryL,G1H4(25),[G1H4(32)])
  call ol_merge(ntryL,G2H2(16),[G2H2(43)])
call HGT_w2_OLR(G1H4(27),1,1,4)
call HGT_w2_invQ_OLR(G1H4(27),2,5,4)
  call ol_merge(ntryL,G1H4(27),[G1H4(38)])
  call ol_merge(ntryL,G2H2(15),[G2H2(46)])
  call ol_merge(ntryL,G1H1(10),[G1H1(52),G1H1(2)])
call HGT_w2_OLR(G1H1(4),1,1,1)
call HGT_w2_invQ_OLR(G1H1(4),2,5,1)
  call ol_merge(ntryL,G1H1(4),[G1H1(10)])
  call ol_merge(ntryL,G1H4(12),[G1H4(52)])
call HGT_w2_OLR(G1H4(28),1,1,4)
call HGT_w2_invQ_OLR(G1H4(28),2,5,4)
  call ol_merge(ntryL,G1H4(28),[G1H4(12)])
  call ol_merge(ntryL,G1H2(2),[G1H2(21)])
  call ol_merge(ntryL,G1H2(38),[G1H2(10)])
  call ol_merge(ntryL,G1H2(40),[G1H2(12)])
  call ol_merge(ntryL,G1H2(45),[G1H2(3)])
  call ol_merge(ntryL,G1H2(44),[G1H2(24),G1H2(6)])
  call ol_merge(ntryL,G2H1(33),[G1H1(48),G1H1(21)])
  call ol_merge(ntryL,G1H1(50),[G1H1(56),G1H1(42)])
  call ol_merge(ntryL,G1H2(37),[G1H2(1),G1H2(9)])
  call ol_merge(ntryL,G2H1(9),[G1H1(64),G1H1(39)])
  call ol_merge(ntryL,G1H1(36),[G1H1(68),G1H1(23)])
  call ol_merge(ntryL,G1H2(22),[G1H2(47)])
  call ol_merge(ntryL,G1H2(15),[G1H2(52)])
  call ol_merge(ntryL,G1H4(11),[G1H4(48)])
  call ol_merge(ntryL,G2H4(20),[G1H4(13)])
  call ol_merge(ntryL,G2H4(23),[G1H4(14)])
  call ol_merge(ntryL,G2H1(5),[G1H1(81)])
  call ol_merge(ntryL,G2H1(7),[G1H1(85)])
  call ol_merge(ntryL,G2H4(2),[G1H4(2)])
  call ol_merge(ntryL,G2H4(5),[G1H4(18)])
  call ol_merge(ntryL,G2H4(4),[G1H4(22)])
  call ol_merge(ntryL,G2H4(8),[G1H4(1)])
  call ol_merge(ntryL,G2H4(29),[G2H4(25)])
  call ol_merge(ntryL,G2H4(31),[G2H4(27)])
  call ol_merge(ntryL,G2H4(37),[G2H4(33)])
  call ol_merge(ntryL,G2H4(39),[G2H4(35)])
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(20),ex4(:),G2tensor(2),m3h2x1(:,83),heltab2x2(:,:,105))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(49),ex4(:),G2tensor(4),m3h2x1(:,84),heltab2x2(:,:,106))
  call Hloop_AS_Q(ntryL,G2H1(40),ex5(:),G2H1(24),ngH,m3h1x1(:,90),heltab2x1(:,:,90))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(24),63,nMB,G3tensor(13),n2h1(243))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(28),ex3(:),G2tensor(6),m3h2x1(:,85),heltab2x2(:,:,107))
  call Hloop_QS_A(ntryL,G2H1(39),ex5(:),G2H1(12),ngH,m3h1x1(:,91),heltab2x1(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(12),63,nMB,G3tensor(14),n2h1(244))
  call Hloop_QZ_A(ntryL,G1H4(64),wf4(:,3),G1H1(75),ngZd,m3h4x1(:,90),heltab2x4(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(75),63,nMB,G2tensor(167),n2h1(245))
  call Hloop_QS_A(ntryL,G1H1(33),ex5(:),G1H1(57),ngH,m3h1x1(:,92),heltab2x1(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(57),63,nMB,G2tensor(11),n2h1(246))
  call Hloop_AZ_Q(ntryL,G2H4(6),wf4(:,3),G2H1(25),ngZd,m3h4x1(:,91),heltab2x4(:,:,150))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(25),63,nMB,G3tensor(15),n2h1(247))
  call Hloop_AS_Q(ntryL,G2H1(34),ex5(:),G2H1(27),ngH,m3h1x1(:,93),heltab2x1(:,:,93))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(27),63,nMB,G3tensor(16),n2h1(248))
  call Hloop_QZ_A(ntryL,G2H4(9),wf4(:,3),G2H1(31),ngZd,m3h4x1(:,92),heltab2x4(:,:,151))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(31),63,nMB,G3tensor(17),n2h1(249))
  call Hloop_QS_A(ntryL,G2H1(22),ex5(:),G2H1(28),ngH,m3h1x1(:,94),heltab2x1(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(28),63,nMB,G3tensor(18),n2h1(250))
  call Hloop_QZ_A(ntryL,G1H4(9),wf4(:,3),G1H1(22),ngZd,m3h4x1(:,93),heltab2x4(:,:,152))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(22),63,nMB,G2tensor(7),n2h1(251))
call HGT_OLR(G2H4(11),1,1,4)
call HGT_invQ_OLR(G2H4(11),2,5,4)
call HGT_OLR(G2H4(11),6,15,4)
  call Hloop_AZ_Q(ntryL,G2H4(11),wf4(:,3),G2H1(30),ngZu,m3h4x1(:,94),heltab2x4(:,:,153))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(30),63,nMT,G3tensor(19),n2h1(252))
  call Hloop_AS_Q(ntryL,G2H1(19),ex5(:),G2H1(10),ngH,m3h1x1(:,95),heltab2x1(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(10),63,nMT,G3tensor(20),n2h1(253))
call HGT_OLR(G2H4(13),1,1,4)
call HGT_invQ_OLR(G2H4(13),2,5,4)
call HGT_OLR(G2H4(13),6,15,4)
  call Hloop_QZ_A(ntryL,G2H4(13),wf4(:,3),G2H1(1),ngZu,m3h4x1(:,95),heltab2x4(:,:,154))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMT,G3tensor(21),n2h1(254))
  call Hloop_QS_A(ntryL,G2H1(21),ex5(:),G2H1(3),ngH,m3h1x1(:,96),heltab2x1(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(3),63,nMT,G3tensor(22),n2h1(255))
call HGT_OLR(G2H4(15),1,1,4)
call HGT_invQ_OLR(G2H4(15),2,5,4)
call HGT_OLR(G2H4(15),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(15),wf4(:,12),G2H1(4),m3h4x1(:,96),heltab2x4(:,:,155))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(4),63,nMT,G3tensor(23),n2h1(256))
call HGT_OLR(G2H4(17),1,1,4)
call HGT_invQ_OLR(G2H4(17),2,5,4)
call HGT_OLR(G2H4(17),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(17),wf4(:,12),G2H1(36),m3h4x1(:,97),heltab2x4(:,:,156))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(36),63,nMT,G3tensor(24),n2h1(257))
call HGT_OLR(G2H4(19),1,1,4)
call HGT_invQ_OLR(G2H4(19),2,5,4)
call HGT_OLR(G2H4(19),6,15,4)
  call Hloop_AV_Q(ntryL,G2H4(19),wf4(:,12),G2H1(2),m3h4x1(:,98),heltab2x4(:,:,157))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(2),63,nMB,G3tensor(25),n2h1(258))
call HGT_OLR(G2H4(21),1,1,4)
call HGT_invQ_OLR(G2H4(21),2,5,4)
call HGT_OLR(G2H4(21),6,15,4)
  call Hloop_QV_A(ntryL,G2H4(21),wf4(:,12),G2H1(6),m3h4x1(:,99),heltab2x4(:,:,158))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(6),63,nMB,G3tensor(26),n2h1(259))
  call Hloop_QS_A(ntryL,G2H1(37),ex5(:),G2H1(18),ngH,m3h1x1(:,97),heltab2x1(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(18),63,nMT,G3tensor(27),n2h1(260))
  call Hloop_QV_A(ntryL,G2H4(7),wf4(:,12),G2H1(32),m3h4x1(:,100),heltab2x4(:,:,159))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(32),63,nMT,G3tensor(28),n2h1(261))
  call Hloop_AS_Q(ntryL,G2H1(38),ex5(:),G2H1(14),ngH,m3h1x1(:,98),heltab2x1(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(14),63,nMT,G3tensor(29),n2h1(262))
  call Hloop_AV_Q(ntryL,G2H4(16),wf4(:,12),G2H1(11),m3h4x1(:,101),heltab2x4(:,:,160))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(11),63,nMT,G3tensor(30),n2h1(263))
  call Hloop_QV_A(ntryL,G2H4(14),wf4(:,12),G2H1(35),m3h4x1(:,102),heltab2x4(:,:,161))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(35),63,nMB,G3tensor(31),n2h1(264))
  call Hloop_AV_Q(ntryL,G2H4(24),wf4(:,12),G2H1(17),m3h4x1(:,103),heltab2x4(:,:,162))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(17),63,nMB,G3tensor(32),n2h1(265))
  call Hloop_AZ_Q(ntryL,G1H4(25),wf4(:,3),G1H1(31),ngZd,m3h4x1(:,104),heltab2x4(:,:,163))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(31),63,nMB,G2tensor(10),n2h1(266))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(16),wf2(:,2),G2tensor(14),m3h2x1(:,86),heltab2x2(:,:,108))
  call Hloop_QZ_A(ntryL,G1H4(27),wf4(:,3),G1H1(76),ngZd,m3h4x1(:,105),heltab2x4(:,:,164))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(76),63,nMB,G2tensor(15),n2h1(267))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(15),wf2(:,4),G2tensor(18),m3h2x1(:,87),heltab2x2(:,:,109))
  call Hloop_QS_A(ntryL,G1H1(4),ex5(:),G1H1(58),ngH,m3h1x1(:,99),heltab2x1(:,:,99))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(58),63,nMB,G2tensor(19),n2h1(268))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(1),wf8(:,3),G2tensor(22),m3h8x1(:,8),heltab2x8(:,:,70))
  call Hloop_QZ_A(ntryL,G1H4(28),wf4(:,13),G1H1(79),ngZd,m3h4x1(:,106),heltab2x4(:,:,165))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(79),63,nMB,G2tensor(23),n2h1(269))
  call Hloop_VA_Q(ntryL,G1H2(2),ex4(:),G1H1(37),m3h2x1(:,88),heltab2x2(:,:,110))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(37),63,nMB,G2tensor(26),n2h1(270))
  call Hloop_VA_Q(ntryL,G1H2(38),ex4(:),G1H1(27),m3h2x1(:,89),heltab2x2(:,:,111))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(27),63,nMB,G2tensor(27),n2h1(271))
  call Hloop_VQ_A(ntryL,G1H2(40),ex3(:),G1H1(59),m3h2x1(:,90),heltab2x2(:,:,112))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(59),63,nMB,G2tensor(77),n2h1(272))
  call Hloop_VQ_A(ntryL,G1H2(45),ex3(:),G1H1(80),m3h2x1(:,91),heltab2x2(:,:,113))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(80),63,nMB,G2tensor(125),n2h1(273))
  call Hloop_VQ_A(ntryL,G1H2(44),ex3(:),G1H1(19),m3h2x1(:,92),heltab2x2(:,:,114))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(19),63,nMB,G2tensor(49),n2h1(274))
  call Hloop_VQ_A(ntryL,G1H2(28),ex3(:),G1H1(83),m3h2x1(:,93),heltab2x2(:,:,115))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(83),63,nMB,G2tensor(52),n2h1(275))
  call Hloop_QS_A(ntryL,G2H1(33),ex5(:),G2H1(8),ngH,m3h1x1(:,100),heltab2x1(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(8),63,nMB,G3tensor(33),n2h1(276))
  call Hloop_AS_Q(ntryL,G1H1(50),ex5(:),G1H1(62),ngH,m3h1x1(:,101),heltab2x1(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(62),63,nMB,G2tensor(54),n2h1(277))
  call Hloop_VA_Q(ntryL,G1H2(37),ex4(:),G1H1(15),m3h2x1(:,94),heltab2x2(:,:,116))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(15),63,nMB,G2tensor(56),n2h1(278))
  call Hloop_VA_Q(ntryL,G1H2(27),ex4(:),G1H1(6),m3h2x1(:,95),heltab2x2(:,:,117))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(6),63,nMB,G2tensor(58),n2h1(279))
  call Hloop_AS_Q(ntryL,G2H1(9),ex5(:),G2H1(26),ngH,m3h1x1(:,102),heltab2x1(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(26),63,nMB,G3tensor(34),n2h1(280))
  call Hloop_AS_Q(ntryL,G1H1(36),ex5(:),G1H1(84),ngH,m3h1x1(:,103),heltab2x1(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(84),63,nMB,G2tensor(60),n2h1(281))
  call Hloop_VQ_A(ntryL,G1H2(32),wf2(:,2),G1H1(63),m3h2x1(:,96),heltab2x2(:,:,118))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(63),63,nMB,G2tensor(149),n2h1(282))
  call Hloop_VQ_A(ntryL,G1H2(22),wf2(:,2),G1H1(87),m3h2x1(:,97),heltab2x2(:,:,119))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(87),63,nMB,G2tensor(155),n2h1(283))
  call Hloop_VA_Q(ntryL,G1H2(51),wf2(:,4),G1H1(20),m3h2x1(:,98),heltab2x2(:,:,120))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(20),63,nMB,G2tensor(161),n2h1(284))
  call Hloop_VA_Q(ntryL,G1H2(15),wf2(:,4),G1H1(25),m3h2x1(:,99),heltab2x2(:,:,121))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(25),63,nMB,G2tensor(66),n2h1(285))
  call Hloop_AZ_Q(ntryL,G1H4(11),wf4(:,13),G1H1(7),ngZd,m3h4x1(:,107),heltab2x4(:,:,166))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(7),63,nMB,G2tensor(64),n2h1(286))
  call Hloop_AZ_Q(ntryL,G2H4(20),wf4(:,13),G2H1(20),ngZd,m3h4x1(:,108),heltab2x4(:,:,167))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(20),63,nMB,G3tensor(35),n2h1(287))
  call Hloop_QZ_A(ntryL,G2H4(23),wf4(:,13),G2H1(16),ngZd,m3h4x1(:,109),heltab2x4(:,:,168))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(16),63,nMB,G3tensor(36),n2h1(288))
  call Hloop_AS_Q(ntryL,G2H1(5),ex5(:),G2H1(29),ngH,m3h1x1(:,104),heltab2x1(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(29),63,nMT,G3tensor(37),n2h1(289))
  call Hloop_QS_A(ntryL,G2H1(7),ex5(:),G2H1(23),ngH,m3h1x1(:,105),heltab2x1(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(23),63,nMT,G3tensor(38),n2h1(290))
  call Hloop_QV_A(ntryL,G2H4(2),wf4(:,12),G2H1(15),m3h4x1(:,110),heltab2x4(:,:,169))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(15),63,nMT,G3tensor(39),n2h1(291))
  call Hloop_AV_Q(ntryL,G2H4(5),wf4(:,12),G2H1(13),m3h4x1(:,111),heltab2x4(:,:,170))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(13),63,nMT,G3tensor(40),n2h1(292))
  call Hloop_QV_A(ntryL,G2H4(4),wf4(:,12),G2H1(40),m3h4x1(:,112),heltab2x4(:,:,171))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(40),63,nMB,G3tensor(41),n2h1(293))
  call Hloop_AV_Q(ntryL,G2H4(8),wf4(:,12),G2H1(24),m3h4x1(:,113),heltab2x4(:,:,172))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(24),63,nMB,G3tensor(42),n2h1(294))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(2),ex3(:),G2tensor(44),m3h2x1(:,100),heltab2x2(:,:,122))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(11),ex4(:),G2tensor(170),m3h2x1(:,101),heltab2x2(:,:,123))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(18),ex4(:),G2tensor(46),m3h2x1(:,102),heltab2x2(:,:,124))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(13),wf2(:,2),G2tensor(74),m3h2x1(:,103),heltab2x2(:,:,125))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(21),wf2(:,4),G2tensor(137),m3h2x1(:,104),heltab2x2(:,:,126))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(4),wf8(:,3),G2tensor(80),m3h8x1(:,9),heltab2x8(:,:,71))
  call Hloop_AZ_Q(ntryL,G2H4(1),wf4(:,13),G2H1(39),ngZu,m3h4x1(:,114),heltab2x4(:,:,173))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(39),63,0,G3tensor(43),n2h1(295))
  call Hloop_AZ_Q(ntryL,G2H4(22),wf4(:,13),G2H1(12),ngZu,m3h4x1(:,115),heltab2x4(:,:,174))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(12),63,nMT,G3tensor(44),n2h1(296))
  call Hloop_QZ_A(ntryL,G2H4(10),wf4(:,13),G2H1(25),ngZu,m3h4x1(:,116),heltab2x4(:,:,175))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(25),63,0,G3tensor(45),n2h1(297))
  call Hloop_QZ_A(ntryL,G2H4(12),wf4(:,13),G2H1(34),ngZu,m3h4x1(:,117),heltab2x4(:,:,176))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(34),63,nMT,G3tensor(46),n2h1(298))
  call Hloop_AZ_Q(ntryL,G2H4(18),wf4(:,13),G2H1(27),ngZd,m3h4x1(:,118),heltab2x4(:,:,177))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(27),63,0,G3tensor(47),n2h1(299))
  call Hloop_QZ_A(ntryL,G2H4(3),wf4(:,13),G2H1(31),ngZd,m3h4x1(:,119),heltab2x4(:,:,178))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(31),63,0,G3tensor(48),n2h1(300))
  call Hloop_AV_Q(ntryL,G2H4(29),wf4(:,15),G2H1(22),m3h4x1(:,120),heltab2x4(:,:,179))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(22),63,0,G3tensor(49),n2h1(301))
  call Hloop_AV_Q(ntryL,G2H4(26),wf4(:,15),G2H1(28),m3h4x1(:,121),heltab2x4(:,:,180))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(28),63,nMT,G3tensor(50),n2h1(302))
  call Hloop_QV_A(ntryL,G2H4(31),wf4(:,15),G2H1(30),m3h4x1(:,122),heltab2x4(:,:,181))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(30),63,0,G3tensor(51),n2h1(303))
  call Hloop_QV_A(ntryL,G2H4(28),wf4(:,15),G2H1(19),m3h4x1(:,123),heltab2x4(:,:,182))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(19),63,nMT,G3tensor(52),n2h1(304))
  call Hloop_AV_Q(ntryL,G2H4(30),wf4(:,15),G2H1(10),m3h4x1(:,124),heltab2x4(:,:,183))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(10),63,nMB,G3tensor(53),n2h1(305))
  call Hloop_QV_A(ntryL,G2H4(32),wf4(:,15),G2H1(1),m3h4x1(:,125),heltab2x4(:,:,184))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),63,nMB,G3tensor(54),n2h1(306))
  call Hloop_VQ_A(ntryL,G1H8(17),wf8(:,22),G1H1(65),m3h8x1(:,10),heltab2x8(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(65),63,nMB,G2tensor(143),n2h1(307))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H8(5),wf8(:,22),G2tensor(86),m3h8x1(:,11),heltab2x8(:,:,73))
  call Hloop_AV_Q(ntryL,G2H4(37),wf4(:,17),G2H1(21),m3h4x1(:,126),heltab2x4(:,:,185))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(21),63,0,G3tensor(55),n2h1(308))
  call Hloop_AV_Q(ntryL,G2H4(34),wf4(:,17),G2H1(3),m3h4x1(:,127),heltab2x4(:,:,186))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(3),63,nMT,G3tensor(56),n2h1(309))
  call Hloop_QV_A(ntryL,G2H4(39),wf4(:,17),G2H1(4),m3h4x1(:,128),heltab2x4(:,:,187))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(4),63,0,G3tensor(57),n2h1(310))
  call Hloop_QV_A(ntryL,G2H4(36),wf4(:,17),G2H1(36),m3h4x1(:,129),heltab2x4(:,:,188))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(36),63,nMT,G3tensor(58),n2h1(311))
  call Hloop_AV_Q(ntryL,G2H4(38),wf4(:,17),G2H1(2),m3h4x1(:,130),heltab2x4(:,:,189))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(2),63,nMB,G3tensor(59),n2h1(312))
  call Hloop_QV_A(ntryL,G2H4(40),wf4(:,17),G2H1(6),m3h4x1(:,131),heltab2x4(:,:,190))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(6),63,nMB,G3tensor(60),n2h1(313))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(19),ex3(:),G2tensor(140),m3h2x1(:,105),heltab2x2(:,:,127))
  call Hloop_VA_Q(ntryL,G1H8(20),wf8(:,25),G1H1(88),m3h8x1(:,12),heltab2x8(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(88),63,nMB,G2tensor(92),n2h1(314))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H8(6),wf8(:,25),G2tensor(146),m3h8x1(:,13),heltab2x8(:,:,75))
  call Hloop_VQ_A(ntryL,G1H8(23),wf8(:,30),G1H1(66),m3h8x1(:,14),heltab2x8(:,:,76))



end subroutine vamp_1

end module ol_vamp_1_pphllj_nenexbbxhg_1_/**/REALKIND
