
module ol_vamp_2_pphllj2_eexhggg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_2(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphllj2_eexhggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphllj2_eexhggg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphllj2_eexhggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphllj2_eexhggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(2)

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,5) :: G0
  complex(REALKIND), dimension(4,5,4,18) :: G1
  complex(REALKIND), dimension(4,15,4,64) :: G2
  complex(REALKIND), dimension(4,35,4,96) :: G3
  complex(REALKIND), dimension(4,70,4,32) :: G4
  complex(REALKIND), dimension(35,32) :: G3tensor
  complex(REALKIND), dimension(70,70) :: G4tensor
  complex(REALKIND), dimension(126,24) :: G5tensor


  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,8),MB,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,13),G1(:,:,:,2))
  call loop_Q_A(G1(:,:,:,2),Q(:,56),MB,G2(:,:,:,1))
  call loop_QS_A(G2(:,:,:,1),wf(:,25),G2(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,2),Q(:,63),MB,G3tensor(:,1))
  call loop_QZ_A(G2(:,:,:,1),wf(:,28),G2(:,:,:,3),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,3),Q(:,63),MB,G3tensor(:,2))
  call loop_QS_A(G2(:,:,:,1),wf(:,33),G2(:,:,:,4),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,63),MB,G3tensor(:,3))
  call loop_QV_A(G2(:,:,:,1),wf(:,18),G2(:,:,:,5))
  call check_last_Q_A(l_switch,G2(:,:,:,5),Q(:,63),MB,G3tensor(:,4))
  call loop_QZ_A(G2(:,:,:,1),wf(:,34),G2(:,:,:,6),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,6),Q(:,63),MB,G3tensor(:,5))
  call loop_QS_A(G2(:,:,:,1),wf(:,35),G2(:,:,:,7),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,7),Q(:,63),MB,G3tensor(:,6))
  call loop_QV_A(G2(:,:,:,1),wf(:,23),G2(:,:,:,8))
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,63),MB,G3tensor(:,7))
  call loop_QZ_A(G2(:,:,:,1),wf(:,36),G2(:,:,:,9),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,9),Q(:,63),MB,G3tensor(:,8))
  call loop_QS_A(G1(:,:,:,1),wf(:,-2),G1(:,:,:,3),gH)
  call loop_Q_A(G1(:,:,:,3),Q(:,12),MB,G2(:,:,:,10))
  call loop_QV_A(G2(:,:,:,10),wf(:,13),G2(:,:,:,11))
  call loop_Q_A(G2(:,:,:,11),Q(:,60),MB,G3(:,:,:,1))
  call loop_QS_A(G3(:,:,:,1),wf(:,8),G3(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,2),Q(:,63),MB,G4tensor(:,1))
  call loop_QV_A(G3(:,:,:,1),wf(:,37),G3(:,:,:,3))
  call check_last_Q_A(l_switch,G3(:,:,:,3),Q(:,63),MB,G4tensor(:,2))
  call loop_QZ_A(G3(:,:,:,1),wf(:,3),G3(:,:,:,4),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,4),Q(:,63),MB,G4tensor(:,3))
  call loop_QV_A(G2(:,:,:,10),wf(:,-4),G2(:,:,:,12))
  call loop_Q_A(G2(:,:,:,12),Q(:,28),MB,G3(:,:,:,5))
  call loop_QV_A(G3(:,:,:,5),wf(:,-5),G3(:,:,:,6))
  call loop_Q_A(G3(:,:,:,6),Q(:,60),MB,G4(:,:,:,1))
  call loop_QS_A(G4(:,:,:,1),wf(:,8),G4(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,2),Q(:,63),MB,G5tensor(:,1))
  call loop_QV_A(G4(:,:,:,1),wf(:,37),G4(:,:,:,3))
  call check_last_Q_A(l_switch,G4(:,:,:,3),Q(:,63),MB,G5tensor(:,2))
  call loop_QZ_A(G4(:,:,:,1),wf(:,3),G4(:,:,:,4),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,4),Q(:,63),MB,G5tensor(:,3))
  call loop_QV_A(G2(:,:,:,10),wf(:,-5),G2(:,:,:,13))
  call loop_Q_A(G2(:,:,:,13),Q(:,44),MB,G3(:,:,:,7))
  call loop_QV_A(G3(:,:,:,7),wf(:,-4),G3(:,:,:,8))
  call loop_Q_A(G3(:,:,:,8),Q(:,60),MB,G4(:,:,:,5))
  call loop_QS_A(G4(:,:,:,5),wf(:,8),G4(:,:,:,6),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,6),Q(:,63),MB,G5tensor(:,4))
  call loop_QV_A(G4(:,:,:,5),wf(:,37),G4(:,:,:,7))
  call check_last_Q_A(l_switch,G4(:,:,:,7),Q(:,63),MB,G5tensor(:,5))
  call loop_QZ_A(G4(:,:,:,5),wf(:,3),G4(:,:,:,8),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,8),Q(:,63),MB,G5tensor(:,6))
  call loop_QV_A(G1(:,:,:,1),wf(:,-4),G1(:,:,:,4))
  call loop_Q_A(G1(:,:,:,4),Q(:,24),MB,G2(:,:,:,14))
  call loop_QV_A(G2(:,:,:,14),wf(:,-5),G2(:,:,:,15))
  call loop_Q_A(G2(:,:,:,15),Q(:,56),MB,G3(:,:,:,9))
  call loop_QS_A(G3(:,:,:,9),wf(:,25),G3(:,:,:,10),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,10),Q(:,63),MB,G4tensor(:,4))
  call loop_QZ_A(G3(:,:,:,9),wf(:,28),G3(:,:,:,11),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,11),Q(:,63),MB,G4tensor(:,5))
  call loop_QS_A(G3(:,:,:,9),wf(:,33),G3(:,:,:,12),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,12),Q(:,63),MB,G4tensor(:,6))
  call loop_QV_A(G3(:,:,:,9),wf(:,18),G3(:,:,:,13))
  call check_last_Q_A(l_switch,G3(:,:,:,13),Q(:,63),MB,G4tensor(:,7))
  call loop_QZ_A(G3(:,:,:,9),wf(:,34),G3(:,:,:,14),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,14),Q(:,63),MB,G4tensor(:,8))
  call loop_QS_A(G3(:,:,:,9),wf(:,35),G3(:,:,:,15),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,15),Q(:,63),MB,G4tensor(:,9))
  call loop_QV_A(G3(:,:,:,9),wf(:,23),G3(:,:,:,16))
  call check_last_Q_A(l_switch,G3(:,:,:,16),Q(:,63),MB,G4tensor(:,10))
  call loop_QZ_A(G3(:,:,:,9),wf(:,36),G3(:,:,:,17),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,17),Q(:,63),MB,G4tensor(:,11))
  call loop_QS_A(G2(:,:,:,14),wf(:,-2),G2(:,:,:,16),gH)
  call loop_Q_A(G2(:,:,:,16),Q(:,28),MB,G3(:,:,:,18))
  call loop_QV_A(G3(:,:,:,18),wf(:,-5),G3(:,:,:,19))
  call loop_Q_A(G3(:,:,:,19),Q(:,60),MB,G4(:,:,:,9))
  call loop_QS_A(G4(:,:,:,9),wf(:,8),G4(:,:,:,10),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,10),Q(:,63),MB,G5tensor(:,7))
  call loop_QV_A(G4(:,:,:,9),wf(:,37),G4(:,:,:,11))
  call check_last_Q_A(l_switch,G4(:,:,:,11),Q(:,63),MB,G5tensor(:,8))
  call loop_QZ_A(G4(:,:,:,9),wf(:,3),G4(:,:,:,12),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,12),Q(:,63),MB,G5tensor(:,9))
  call loop_QV_A(G1(:,:,:,1),wf(:,-5),G1(:,:,:,5))
  call loop_Q_A(G1(:,:,:,5),Q(:,40),MB,G2(:,:,:,17))
  call loop_QV_A(G2(:,:,:,17),wf(:,-4),G2(:,:,:,18))
  call loop_Q_A(G2(:,:,:,18),Q(:,56),MB,G3(:,:,:,20))
  call loop_QS_A(G3(:,:,:,20),wf(:,25),G3(:,:,:,21),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,21),Q(:,63),MB,G4tensor(:,12))
  call loop_QZ_A(G3(:,:,:,20),wf(:,28),G3(:,:,:,22),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,22),Q(:,63),MB,G4tensor(:,13))
  call loop_QS_A(G3(:,:,:,20),wf(:,33),G3(:,:,:,23),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,23),Q(:,63),MB,G4tensor(:,14))
  call loop_QV_A(G3(:,:,:,20),wf(:,18),G3(:,:,:,24))
  call check_last_Q_A(l_switch,G3(:,:,:,24),Q(:,63),MB,G4tensor(:,15))
  call loop_QZ_A(G3(:,:,:,20),wf(:,34),G3(:,:,:,25),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,25),Q(:,63),MB,G4tensor(:,16))
  call loop_QS_A(G3(:,:,:,20),wf(:,35),G3(:,:,:,26),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,26),Q(:,63),MB,G4tensor(:,17))
  call loop_QV_A(G3(:,:,:,20),wf(:,23),G3(:,:,:,27))
  call check_last_Q_A(l_switch,G3(:,:,:,27),Q(:,63),MB,G4tensor(:,18))
  call loop_QZ_A(G3(:,:,:,20),wf(:,36),G3(:,:,:,28),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,28),Q(:,63),MB,G4tensor(:,19))
  call loop_QS_A(G2(:,:,:,17),wf(:,-2),G2(:,:,:,19),gH)
  call loop_Q_A(G2(:,:,:,19),Q(:,44),MB,G3(:,:,:,29))
  call loop_QV_A(G3(:,:,:,29),wf(:,-4),G3(:,:,:,30))
  call loop_Q_A(G3(:,:,:,30),Q(:,60),MB,G4(:,:,:,13))
  call loop_QS_A(G4(:,:,:,13),wf(:,8),G4(:,:,:,14),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,14),Q(:,63),MB,G5tensor(:,10))
  call loop_QV_A(G4(:,:,:,13),wf(:,37),G4(:,:,:,15))
  call check_last_Q_A(l_switch,G4(:,:,:,15),Q(:,63),MB,G5tensor(:,11))
  call loop_QZ_A(G4(:,:,:,13),wf(:,3),G4(:,:,:,16),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,16),Q(:,63),MB,G5tensor(:,12))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,8),MB,G1(:,:,:,6))
  call loop_AV_Q(G1(:,:,:,6),wf(:,13),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,56),MB,G2(:,:,:,20))
  call loop_AS_Q(G2(:,:,:,20),wf(:,25),G2(:,:,:,21),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,21),Q(:,63),MB,G3tensor(:,9))
  call loop_AZ_Q(G2(:,:,:,20),wf(:,28),G2(:,:,:,22),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,22),Q(:,63),MB,G3tensor(:,10))
  call loop_AS_Q(G2(:,:,:,20),wf(:,33),G2(:,:,:,23),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,23),Q(:,63),MB,G3tensor(:,11))
  call loop_AV_Q(G2(:,:,:,20),wf(:,18),G2(:,:,:,24))
  call check_last_A_Q(l_switch,G2(:,:,:,24),Q(:,63),MB,G3tensor(:,12))
  call loop_AZ_Q(G2(:,:,:,20),wf(:,34),G2(:,:,:,25),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,25),Q(:,63),MB,G3tensor(:,13))
  call loop_AS_Q(G2(:,:,:,20),wf(:,35),G2(:,:,:,26),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,26),Q(:,63),MB,G3tensor(:,14))
  call loop_AV_Q(G2(:,:,:,20),wf(:,23),G2(:,:,:,27))
  call check_last_A_Q(l_switch,G2(:,:,:,27),Q(:,63),MB,G3tensor(:,15))
  call loop_AZ_Q(G2(:,:,:,20),wf(:,36),G2(:,:,:,28),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,28),Q(:,63),MB,G3tensor(:,16))
  call loop_AS_Q(G1(:,:,:,6),wf(:,-2),G1(:,:,:,8),gH)
  call loop_A_Q(G1(:,:,:,8),Q(:,12),MB,G2(:,:,:,29))
  call loop_AV_Q(G2(:,:,:,29),wf(:,13),G2(:,:,:,30))
  call loop_A_Q(G2(:,:,:,30),Q(:,60),MB,G3(:,:,:,31))
  call loop_AS_Q(G3(:,:,:,31),wf(:,8),G3(:,:,:,32),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,32),Q(:,63),MB,G4tensor(:,20))
  call loop_AV_Q(G3(:,:,:,31),wf(:,37),G3(:,:,:,33))
  call check_last_A_Q(l_switch,G3(:,:,:,33),Q(:,63),MB,G4tensor(:,21))
  call loop_AZ_Q(G3(:,:,:,31),wf(:,3),G3(:,:,:,34),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,34),Q(:,63),MB,G4tensor(:,22))
  call loop_AV_Q(G2(:,:,:,29),wf(:,-4),G2(:,:,:,31))
  call loop_A_Q(G2(:,:,:,31),Q(:,28),MB,G3(:,:,:,35))
  call loop_AV_Q(G3(:,:,:,35),wf(:,-5),G3(:,:,:,36))
  call loop_A_Q(G3(:,:,:,36),Q(:,60),MB,G4(:,:,:,17))
  call loop_AS_Q(G4(:,:,:,17),wf(:,8),G4(:,:,:,18),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,18),Q(:,63),MB,G5tensor(:,13))
  call loop_AV_Q(G4(:,:,:,17),wf(:,37),G4(:,:,:,19))
  call check_last_A_Q(l_switch,G4(:,:,:,19),Q(:,63),MB,G5tensor(:,14))
  call loop_AZ_Q(G4(:,:,:,17),wf(:,3),G4(:,:,:,20),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,20),Q(:,63),MB,G5tensor(:,15))
  call loop_AV_Q(G2(:,:,:,29),wf(:,-5),G2(:,:,:,32))
  call loop_A_Q(G2(:,:,:,32),Q(:,44),MB,G3(:,:,:,37))
  call loop_AV_Q(G3(:,:,:,37),wf(:,-4),G3(:,:,:,38))
  call loop_A_Q(G3(:,:,:,38),Q(:,60),MB,G4(:,:,:,21))
  call loop_AS_Q(G4(:,:,:,21),wf(:,8),G4(:,:,:,22),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,22),Q(:,63),MB,G5tensor(:,16))
  call loop_AV_Q(G4(:,:,:,21),wf(:,37),G4(:,:,:,23))
  call check_last_A_Q(l_switch,G4(:,:,:,23),Q(:,63),MB,G5tensor(:,17))
  call loop_AZ_Q(G4(:,:,:,21),wf(:,3),G4(:,:,:,24),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,24),Q(:,63),MB,G5tensor(:,18))
  call loop_AV_Q(G1(:,:,:,6),wf(:,-4),G1(:,:,:,9))
  call loop_A_Q(G1(:,:,:,9),Q(:,24),MB,G2(:,:,:,33))
  call loop_AV_Q(G2(:,:,:,33),wf(:,-5),G2(:,:,:,34))
  call loop_A_Q(G2(:,:,:,34),Q(:,56),MB,G3(:,:,:,39))
  call loop_AS_Q(G3(:,:,:,39),wf(:,25),G3(:,:,:,40),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,40),Q(:,63),MB,G4tensor(:,23))
  call loop_AZ_Q(G3(:,:,:,39),wf(:,28),G3(:,:,:,41),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,41),Q(:,63),MB,G4tensor(:,24))
  call loop_AS_Q(G3(:,:,:,39),wf(:,33),G3(:,:,:,42),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,42),Q(:,63),MB,G4tensor(:,25))
  call loop_AV_Q(G3(:,:,:,39),wf(:,18),G3(:,:,:,43))
  call check_last_A_Q(l_switch,G3(:,:,:,43),Q(:,63),MB,G4tensor(:,26))
  call loop_AZ_Q(G3(:,:,:,39),wf(:,34),G3(:,:,:,44),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,44),Q(:,63),MB,G4tensor(:,27))
  call loop_AS_Q(G3(:,:,:,39),wf(:,35),G3(:,:,:,45),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,45),Q(:,63),MB,G4tensor(:,28))
  call loop_AV_Q(G3(:,:,:,39),wf(:,23),G3(:,:,:,46))
  call check_last_A_Q(l_switch,G3(:,:,:,46),Q(:,63),MB,G4tensor(:,29))
  call loop_AZ_Q(G3(:,:,:,39),wf(:,36),G3(:,:,:,47),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,47),Q(:,63),MB,G4tensor(:,30))
  call loop_AS_Q(G2(:,:,:,33),wf(:,-2),G2(:,:,:,35),gH)
  call loop_A_Q(G2(:,:,:,35),Q(:,28),MB,G3(:,:,:,48))
  call loop_AV_Q(G3(:,:,:,48),wf(:,-5),G3(:,:,:,49))
  call loop_A_Q(G3(:,:,:,49),Q(:,60),MB,G4(:,:,:,25))
  call loop_AS_Q(G4(:,:,:,25),wf(:,8),G4(:,:,:,26),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,26),Q(:,63),MB,G5tensor(:,19))
  call loop_AV_Q(G4(:,:,:,25),wf(:,37),G4(:,:,:,27))
  call check_last_A_Q(l_switch,G4(:,:,:,27),Q(:,63),MB,G5tensor(:,20))
  call loop_AZ_Q(G4(:,:,:,25),wf(:,3),G4(:,:,:,28),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,28),Q(:,63),MB,G5tensor(:,21))
  call loop_AV_Q(G1(:,:,:,6),wf(:,-5),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,40),MB,G2(:,:,:,36))
  call loop_AV_Q(G2(:,:,:,36),wf(:,-4),G2(:,:,:,37))
  call loop_A_Q(G2(:,:,:,37),Q(:,56),MB,G3(:,:,:,50))
  call loop_AS_Q(G3(:,:,:,50),wf(:,25),G3(:,:,:,51),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,51),Q(:,63),MB,G4tensor(:,31))
  call loop_AZ_Q(G3(:,:,:,50),wf(:,28),G3(:,:,:,52),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,52),Q(:,63),MB,G4tensor(:,32))
  call loop_AS_Q(G3(:,:,:,50),wf(:,33),G3(:,:,:,53),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,53),Q(:,63),MB,G4tensor(:,33))
  call loop_AV_Q(G3(:,:,:,50),wf(:,18),G3(:,:,:,54))
  call check_last_A_Q(l_switch,G3(:,:,:,54),Q(:,63),MB,G4tensor(:,34))
  call loop_AZ_Q(G3(:,:,:,50),wf(:,34),G3(:,:,:,55),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,55),Q(:,63),MB,G4tensor(:,35))
  call loop_AS_Q(G3(:,:,:,50),wf(:,35),G3(:,:,:,56),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,56),Q(:,63),MB,G4tensor(:,36))
  call loop_AV_Q(G3(:,:,:,50),wf(:,23),G3(:,:,:,57))
  call check_last_A_Q(l_switch,G3(:,:,:,57),Q(:,63),MB,G4tensor(:,37))
  call loop_AZ_Q(G3(:,:,:,50),wf(:,36),G3(:,:,:,58),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,58),Q(:,63),MB,G4tensor(:,38))
  call loop_AS_Q(G2(:,:,:,36),wf(:,-2),G2(:,:,:,38),gH)
  call loop_A_Q(G2(:,:,:,38),Q(:,44),MB,G3(:,:,:,59))
  call loop_AV_Q(G3(:,:,:,59),wf(:,-4),G3(:,:,:,60))
  call loop_A_Q(G3(:,:,:,60),Q(:,60),MB,G4(:,:,:,29))
  call loop_AS_Q(G4(:,:,:,29),wf(:,8),G4(:,:,:,30),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,30),Q(:,63),MB,G5tensor(:,22))
  call loop_AV_Q(G4(:,:,:,29),wf(:,37),G4(:,:,:,31))
  call check_last_A_Q(l_switch,G4(:,:,:,31),Q(:,63),MB,G5tensor(:,23))
  call loop_AZ_Q(G4(:,:,:,29),wf(:,3),G4(:,:,:,32),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,32),Q(:,63),MB,G5tensor(:,24))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,8),ZERO,G1(:,:,:,11))
  call loop_QV_A(G1(:,:,:,11),wf(:,13),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,56),ZERO,G2(:,:,:,39))
  call loop_QZ_A(G2(:,:,:,39),wf(:,28),G2(:,:,:,40),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,40),Q(:,63),ZERO,G3tensor(:,17))
  call loop_QZ_A(G2(:,:,:,39),wf(:,28),G2(:,:,:,41),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,41),Q(:,63),ZERO,G3tensor(:,18))
  call loop_QV_A(G2(:,:,:,39),wf(:,18),G2(:,:,:,42))
  call check_last_Q_A(l_switch,G2(:,:,:,42),Q(:,63),ZERO,G3tensor(:,19))
  call loop_QZ_A(G2(:,:,:,39),wf(:,34),G2(:,:,:,43),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,43),Q(:,63),ZERO,G3tensor(:,20))
  call loop_QZ_A(G2(:,:,:,39),wf(:,34),G2(:,:,:,44),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,44),Q(:,63),ZERO,G3tensor(:,21))
  call loop_QV_A(G2(:,:,:,39),wf(:,23),G2(:,:,:,45))
  call check_last_Q_A(l_switch,G2(:,:,:,45),Q(:,63),ZERO,G3tensor(:,22))
  call loop_QZ_A(G2(:,:,:,39),wf(:,36),G2(:,:,:,46),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,46),Q(:,63),ZERO,G3tensor(:,23))
  call loop_QZ_A(G2(:,:,:,39),wf(:,36),G2(:,:,:,47),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,47),Q(:,63),ZERO,G3tensor(:,24))
  call loop_QV_A(G1(:,:,:,11),wf(:,-4),G1(:,:,:,13))
  call loop_Q_A(G1(:,:,:,13),Q(:,24),ZERO,G2(:,:,:,48))
  call loop_QV_A(G2(:,:,:,48),wf(:,-5),G2(:,:,:,49))
  call loop_Q_A(G2(:,:,:,49),Q(:,56),ZERO,G3(:,:,:,61))
  call loop_QZ_A(G3(:,:,:,61),wf(:,28),G3(:,:,:,62),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,62),Q(:,63),ZERO,G4tensor(:,39))
  call loop_QZ_A(G3(:,:,:,61),wf(:,28),G3(:,:,:,63),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,63),Q(:,63),ZERO,G4tensor(:,40))
  call loop_QV_A(G3(:,:,:,61),wf(:,18),G3(:,:,:,64))
  call check_last_Q_A(l_switch,G3(:,:,:,64),Q(:,63),ZERO,G4tensor(:,41))
  call loop_QZ_A(G3(:,:,:,61),wf(:,34),G3(:,:,:,65),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,65),Q(:,63),ZERO,G4tensor(:,42))
  call loop_QZ_A(G3(:,:,:,61),wf(:,34),G3(:,:,:,66),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,66),Q(:,63),ZERO,G4tensor(:,43))
  call loop_QV_A(G3(:,:,:,61),wf(:,23),G3(:,:,:,67))
  call check_last_Q_A(l_switch,G3(:,:,:,67),Q(:,63),ZERO,G4tensor(:,44))
  call loop_QZ_A(G3(:,:,:,61),wf(:,36),G3(:,:,:,68),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,68),Q(:,63),ZERO,G4tensor(:,45))
  call loop_QZ_A(G3(:,:,:,61),wf(:,36),G3(:,:,:,69),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,69),Q(:,63),ZERO,G4tensor(:,46))
  call loop_QV_A(G1(:,:,:,11),wf(:,-5),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,40),ZERO,G2(:,:,:,50))
  call loop_QV_A(G2(:,:,:,50),wf(:,-4),G2(:,:,:,51))
  call loop_Q_A(G2(:,:,:,51),Q(:,56),ZERO,G3(:,:,:,70))
  call loop_QZ_A(G3(:,:,:,70),wf(:,28),G3(:,:,:,71),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,71),Q(:,63),ZERO,G4tensor(:,47))
  call loop_QZ_A(G3(:,:,:,70),wf(:,28),G3(:,:,:,72),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,72),Q(:,63),ZERO,G4tensor(:,48))
  call loop_QV_A(G3(:,:,:,70),wf(:,18),G3(:,:,:,73))
  call check_last_Q_A(l_switch,G3(:,:,:,73),Q(:,63),ZERO,G4tensor(:,49))
  call loop_QZ_A(G3(:,:,:,70),wf(:,34),G3(:,:,:,74),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,74),Q(:,63),ZERO,G4tensor(:,50))
  call loop_QZ_A(G3(:,:,:,70),wf(:,34),G3(:,:,:,75),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,75),Q(:,63),ZERO,G4tensor(:,51))
  call loop_QV_A(G3(:,:,:,70),wf(:,23),G3(:,:,:,76))
  call check_last_Q_A(l_switch,G3(:,:,:,76),Q(:,63),ZERO,G4tensor(:,52))
  call loop_QZ_A(G3(:,:,:,70),wf(:,36),G3(:,:,:,77),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,77),Q(:,63),ZERO,G4tensor(:,53))
  call loop_QZ_A(G3(:,:,:,70),wf(:,36),G3(:,:,:,78),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,78),Q(:,63),ZERO,G4tensor(:,54))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,8),ZERO,G1(:,:,:,15))
  call loop_AV_Q(G1(:,:,:,15),wf(:,13),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,56),ZERO,G2(:,:,:,52))
  call loop_AZ_Q(G2(:,:,:,52),wf(:,28),G2(:,:,:,53),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,53),Q(:,63),ZERO,G3tensor(:,25))
  call loop_AZ_Q(G2(:,:,:,52),wf(:,28),G2(:,:,:,54),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,54),Q(:,63),ZERO,G3tensor(:,26))
  call loop_AV_Q(G2(:,:,:,52),wf(:,18),G2(:,:,:,55))
  call check_last_A_Q(l_switch,G2(:,:,:,55),Q(:,63),ZERO,G3tensor(:,27))
  call loop_AZ_Q(G2(:,:,:,52),wf(:,34),G2(:,:,:,56),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,56),Q(:,63),ZERO,G3tensor(:,28))
  call loop_AZ_Q(G2(:,:,:,52),wf(:,34),G2(:,:,:,57),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,57),Q(:,63),ZERO,G3tensor(:,29))
  call loop_AV_Q(G2(:,:,:,52),wf(:,23),G2(:,:,:,58))
  call check_last_A_Q(l_switch,G2(:,:,:,58),Q(:,63),ZERO,G3tensor(:,30))
  call loop_AZ_Q(G2(:,:,:,52),wf(:,36),G2(:,:,:,59),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,59),Q(:,63),ZERO,G3tensor(:,31))
  call loop_AZ_Q(G2(:,:,:,52),wf(:,36),G2(:,:,:,60),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,60),Q(:,63),ZERO,G3tensor(:,32))
  call loop_AV_Q(G1(:,:,:,15),wf(:,-4),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,24),ZERO,G2(:,:,:,61))
  call loop_AV_Q(G2(:,:,:,61),wf(:,-5),G2(:,:,:,62))
  call loop_A_Q(G2(:,:,:,62),Q(:,56),ZERO,G3(:,:,:,79))
  call loop_AZ_Q(G3(:,:,:,79),wf(:,28),G3(:,:,:,80),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,80),Q(:,63),ZERO,G4tensor(:,55))
  call loop_AZ_Q(G3(:,:,:,79),wf(:,28),G3(:,:,:,81),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,81),Q(:,63),ZERO,G4tensor(:,56))
  call loop_AV_Q(G3(:,:,:,79),wf(:,18),G3(:,:,:,82))
  call check_last_A_Q(l_switch,G3(:,:,:,82),Q(:,63),ZERO,G4tensor(:,57))
  call loop_AZ_Q(G3(:,:,:,79),wf(:,34),G3(:,:,:,83),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,83),Q(:,63),ZERO,G4tensor(:,58))
  call loop_AZ_Q(G3(:,:,:,79),wf(:,34),G3(:,:,:,84),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,84),Q(:,63),ZERO,G4tensor(:,59))
  call loop_AV_Q(G3(:,:,:,79),wf(:,23),G3(:,:,:,85))
  call check_last_A_Q(l_switch,G3(:,:,:,85),Q(:,63),ZERO,G4tensor(:,60))
  call loop_AZ_Q(G3(:,:,:,79),wf(:,36),G3(:,:,:,86),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,86),Q(:,63),ZERO,G4tensor(:,61))
  call loop_AZ_Q(G3(:,:,:,79),wf(:,36),G3(:,:,:,87),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,87),Q(:,63),ZERO,G4tensor(:,62))
  call loop_AV_Q(G1(:,:,:,15),wf(:,-5),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,40),ZERO,G2(:,:,:,63))
  call loop_AV_Q(G2(:,:,:,63),wf(:,-4),G2(:,:,:,64))
  call loop_A_Q(G2(:,:,:,64),Q(:,56),ZERO,G3(:,:,:,88))
  call loop_AZ_Q(G3(:,:,:,88),wf(:,28),G3(:,:,:,89),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,89),Q(:,63),ZERO,G4tensor(:,63))
  call loop_AZ_Q(G3(:,:,:,88),wf(:,28),G3(:,:,:,90),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,90),Q(:,63),ZERO,G4tensor(:,64))
  call loop_AV_Q(G3(:,:,:,88),wf(:,18),G3(:,:,:,91))
  call check_last_A_Q(l_switch,G3(:,:,:,91),Q(:,63),ZERO,G4tensor(:,65))
  call loop_AZ_Q(G3(:,:,:,88),wf(:,34),G3(:,:,:,92),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,92),Q(:,63),ZERO,G4tensor(:,66))
  call loop_AZ_Q(G3(:,:,:,88),wf(:,34),G3(:,:,:,93),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,93),Q(:,63),ZERO,G4tensor(:,67))
  call loop_AV_Q(G3(:,:,:,88),wf(:,23),G3(:,:,:,94))
  call check_last_A_Q(l_switch,G3(:,:,:,94),Q(:,63),ZERO,G4tensor(:,68))
  call loop_AZ_Q(G3(:,:,:,88),wf(:,36),G3(:,:,:,95),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,95),Q(:,63),ZERO,G4tensor(:,69))
  call loop_AZ_Q(G3(:,:,:,88),wf(:,36),G3(:,:,:,96),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,96),Q(:,63),ZERO,G4tensor(:,70))


  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-(CI*f(24)) * den(26)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,1),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(24) * den(26)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,1),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(24)) * den(26)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,9),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(24) * den(26)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,9),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(4) * den(27)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,17),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(4)) * den(27)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,17),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(4) * den(27)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,25),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(4)) * den(27)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,25),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(4) * den(27)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,18),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(4)) * den(27)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,18),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(3) * den(27)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,2),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(3)) * den(27)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,2),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(4) * den(27)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,26),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(4)) * den(27)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,26),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(3) * den(27)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,10),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(3)) * den(27)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,10),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(26)) * den(10)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,1),T4sum(1:70,16))
  M(2) = M(2) + (CI*f(26) * den(10)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,1),T4sum(1:70,16))
  M(1) = M(1) + (-(CI*f(26)) * den(10)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,20),T4sum(1:70,16))
  M(2) = M(2) + (CI*f(26) * den(10)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,20),T4sum(1:70,16))
  M(1) = M(1) + (CI*f(7) * den(52)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,2),T4sum(1:70,16))
  M(2) = M(2) + (-(CI*f(7)) * den(52)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,2),T4sum(1:70,16))
  M(1) = M(1) + (CI*f(7) * den(52)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,21),T4sum(1:70,16))
  M(2) = M(2) + (-(CI*f(7)) * den(52)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,21),T4sum(1:70,16))
  M(1) = M(1) + (CI*f(8) * den(53)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,3),T4sum(1:70,16))
  M(2) = M(2) + (-(CI*f(8)) * den(53)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,3),T4sum(1:70,16))
  M(1) = M(1) + (CI*f(8) * den(53)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,22),T4sum(1:70,16))
  M(2) = M(2) + (-(CI*f(8)) * den(53)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,22),T4sum(1:70,16))
  M(1) = M(1) + (f(25) * den(19)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,23),T4sum(1:70,23))
  M(2) = M(2) + (f(25) * den(19)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,4),T4sum(1:70,23))
  M(1) = M(1) + (-f(6) * den(22)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,55),T4sum(1:70,24))
  M(2) = M(2) + (-f(6) * den(22)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,39),T4sum(1:70,24))
  M(1) = M(1) + (-f(6) * den(22)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,56),T4sum(1:70,24))
  M(1) = M(1) + (-f(5) * den(22)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,24),T4sum(1:70,23))
  M(2) = M(2) + (-f(6) * den(22)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,40),T4sum(1:70,24))
  M(2) = M(2) + (-f(5) * den(22)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,5),T4sum(1:70,23))
  M(2) = M(2) + (f(25) * den(19)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,31),T4sum(1:70,26))
  M(1) = M(1) + (f(25) * den(19)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,12),T4sum(1:70,26))
  M(2) = M(2) + (-f(6) * den(22)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,63),T4sum(1:70,27))
  M(1) = M(1) + (-f(6) * den(22)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,47),T4sum(1:70,27))
  M(2) = M(2) + (-f(6) * den(22)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,64),T4sum(1:70,27))
  M(2) = M(2) + (-f(5) * den(22)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,32),T4sum(1:70,26))
  M(1) = M(1) + (-f(6) * den(22)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,48),T4sum(1:70,27))
  M(1) = M(1) + (-f(5) * den(22)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,13),T4sum(1:70,26))
  M(2) = M(2) + (f(27) * den(4)) * TI2_call(5,momenta_22,masses2_7,G5tensor(:,1),T5sum(1:126,4))
  M(1) = M(1) + (f(27) * den(4)) * TI2_call(5,momenta_22,masses2_7,G5tensor(:,13),T5sum(1:126,4))
  M(2) = M(2) + (-f(9) * den(44)) * TI2_call(5,momenta_22,masses2_7,G5tensor(:,2),T5sum(1:126,4))
  M(1) = M(1) + (-f(9) * den(44)) * TI2_call(5,momenta_22,masses2_7,G5tensor(:,14),T5sum(1:126,4))
  M(2) = M(2) + (-f(10) * den(1)) * TI2_call(5,momenta_22,masses2_7,G5tensor(:,3),T5sum(1:126,4))
  M(1) = M(1) + (-f(10) * den(1)) * TI2_call(5,momenta_22,masses2_7,G5tensor(:,15),T5sum(1:126,4))
  M(1) = M(1) + (f(27) * den(4)) * TI2_call(5,momenta_23,masses2_7,G5tensor(:,4),T5sum(1:126,8))
  M(2) = M(2) + (f(27) * den(4)) * TI2_call(5,momenta_23,masses2_7,G5tensor(:,16),T5sum(1:126,8))
  M(1) = M(1) + (-f(9) * den(44)) * TI2_call(5,momenta_23,masses2_7,G5tensor(:,5),T5sum(1:126,8))
  M(2) = M(2) + (-f(9) * den(44)) * TI2_call(5,momenta_23,masses2_7,G5tensor(:,17),T5sum(1:126,8))
  M(1) = M(1) + (-f(10) * den(1)) * TI2_call(5,momenta_23,masses2_7,G5tensor(:,6),T5sum(1:126,8))
  M(2) = M(2) + (-f(10) * den(1)) * TI2_call(5,momenta_23,masses2_7,G5tensor(:,18),T5sum(1:126,8))
  M(2) = M(2) + (f(27) * den(4)) * TI2_call(5,momenta_24,masses2_7,G5tensor(:,7),T5sum(1:126,14))
  M(1) = M(1) + (f(27) * den(4)) * TI2_call(5,momenta_24,masses2_7,G5tensor(:,19),T5sum(1:126,14))
  M(2) = M(2) + (-f(9) * den(44)) * TI2_call(5,momenta_24,masses2_7,G5tensor(:,8),T5sum(1:126,14))
  M(1) = M(1) + (-f(9) * den(44)) * TI2_call(5,momenta_24,masses2_7,G5tensor(:,20),T5sum(1:126,14))
  M(2) = M(2) + (-f(10) * den(1)) * TI2_call(5,momenta_24,masses2_7,G5tensor(:,9),T5sum(1:126,14))
  M(1) = M(1) + (-f(10) * den(1)) * TI2_call(5,momenta_24,masses2_7,G5tensor(:,21),T5sum(1:126,14))
  M(2) = M(2) + (f(27) * den(4)) * TI2_call(5,momenta_25,masses2_7,G5tensor(:,22),T5sum(1:126,16))
  M(1) = M(1) + (f(27) * den(4)) * TI2_call(5,momenta_25,masses2_7,G5tensor(:,10),T5sum(1:126,16))
  M(2) = M(2) + (-f(9) * den(44)) * TI2_call(5,momenta_25,masses2_7,G5tensor(:,23),T5sum(1:126,16))
  M(1) = M(1) + (-f(9) * den(44)) * TI2_call(5,momenta_25,masses2_7,G5tensor(:,11),T5sum(1:126,16))
  M(2) = M(2) + (-f(10) * den(1)) * TI2_call(5,momenta_25,masses2_7,G5tensor(:,24),T5sum(1:126,16))
  M(1) = M(1) + (-f(10) * den(1)) * TI2_call(5,momenta_25,masses2_7,G5tensor(:,12),T5sum(1:126,16))
  M(1) = M(1) + (-(CI*f(31)) * den(34)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,3),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(31) * den(34)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,3),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(31)) * den(34)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,11),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(31) * den(34)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,11),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(16)) * den(56)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,19),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(16) * den(56)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,19),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(16)) * den(56)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,27),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(16) * den(56)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,27),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(14) * den(56)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,19),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(14)) * den(56)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,19),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(13) * den(56)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,4),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(13)) * den(56)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,4),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(14) * den(56)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,27),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(14)) * den(56)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,27),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(13) * den(56)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,12),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(13)) * den(56)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,12),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(17) * den(35)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,20),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(17)) * den(35)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,20),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(17) * den(35)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,28),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(17)) * den(35)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,28),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(17) * den(35)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,21),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(17)) * den(35)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,21),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(35)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,5),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(35)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,5),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(17) * den(35)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,29),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(17)) * den(35)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,29),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(35)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,13),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(35)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,13),T3sum(1:35,8))
  M(1) = M(1) + (f(32) * den(28)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,25),T4sum(1:70,23))
  M(2) = M(2) + (f(32) * den(28)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,6),T4sum(1:70,23))
  M(1) = M(1) + (f(21) * den(46)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,57),T4sum(1:70,24))
  M(2) = M(2) + (f(21) * den(46)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,41),T4sum(1:70,24))
  M(1) = M(1) + (-f(19) * den(46)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,57),T4sum(1:70,24))
  M(1) = M(1) + (-f(18) * den(46)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,26),T4sum(1:70,23))
  M(2) = M(2) + (-f(19) * den(46)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,41),T4sum(1:70,24))
  M(2) = M(2) + (-f(18) * den(46)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,7),T4sum(1:70,23))
  M(1) = M(1) + (-f(22) * den(30)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,58),T4sum(1:70,24))
  M(2) = M(2) + (-f(22) * den(30)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,42),T4sum(1:70,24))
  M(1) = M(1) + (-f(22) * den(30)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,59),T4sum(1:70,24))
  M(1) = M(1) + (-f(20) * den(30)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,27),T4sum(1:70,23))
  M(2) = M(2) + (-f(22) * den(30)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,43),T4sum(1:70,24))
  M(2) = M(2) + (-f(20) * den(30)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,8),T4sum(1:70,23))
  M(2) = M(2) + (f(32) * den(28)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,33),T4sum(1:70,26))
  M(1) = M(1) + (f(32) * den(28)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,14),T4sum(1:70,26))
  M(2) = M(2) + (f(21) * den(46)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,65),T4sum(1:70,27))
  M(1) = M(1) + (f(21) * den(46)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,49),T4sum(1:70,27))
  M(2) = M(2) + (-f(19) * den(46)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,65),T4sum(1:70,27))
  M(2) = M(2) + (-f(18) * den(46)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,34),T4sum(1:70,26))
  M(1) = M(1) + (-f(19) * den(46)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,49),T4sum(1:70,27))
  M(1) = M(1) + (-f(18) * den(46)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,15),T4sum(1:70,26))
  M(2) = M(2) + (-f(22) * den(30)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,66),T4sum(1:70,27))
  M(1) = M(1) + (-f(22) * den(30)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,50),T4sum(1:70,27))
  M(2) = M(2) + (-f(22) * den(30)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,67),T4sum(1:70,27))
  M(2) = M(2) + (-f(20) * den(30)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,35),T4sum(1:70,26))
  M(1) = M(1) + (-f(22) * den(30)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,51),T4sum(1:70,27))
  M(1) = M(1) + (-f(20) * den(30)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,16),T4sum(1:70,26))
  M(1) = M(1) + (-(CI*f(31)) * den(42)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,6),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(31) * den(42)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,6),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(31)) * den(42)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,14),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(31) * den(42)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,14),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(16)) * den(59)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,22),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(16) * den(59)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,22),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(16)) * den(59)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,30),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(16) * den(59)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,30),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(14) * den(59)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,22),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(14)) * den(59)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,22),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(13) * den(59)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,7),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(13)) * den(59)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,7),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(14) * den(59)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,30),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(14)) * den(59)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,30),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(13) * den(59)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,15),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(13)) * den(59)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,15),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(17) * den(43)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,23),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(17)) * den(43)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,23),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(17) * den(43)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,31),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(17)) * den(43)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,31),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(17) * den(43)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,24),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(17)) * den(43)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,24),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(43)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,8),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(43)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,8),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(17) * den(43)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,32),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(17)) * den(43)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,32),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(15) * den(43)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,16),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(15)) * den(43)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,16),T3sum(1:35,8))
  M(1) = M(1) + (f(32) * den(36)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,28),T4sum(1:70,23))
  M(2) = M(2) + (f(32) * den(36)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,9),T4sum(1:70,23))
  M(1) = M(1) + (f(21) * den(47)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,60),T4sum(1:70,24))
  M(2) = M(2) + (f(21) * den(47)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,44),T4sum(1:70,24))
  M(1) = M(1) + (-f(19) * den(47)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,60),T4sum(1:70,24))
  M(1) = M(1) + (-f(18) * den(47)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,29),T4sum(1:70,23))
  M(2) = M(2) + (-f(19) * den(47)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,44),T4sum(1:70,24))
  M(2) = M(2) + (-f(18) * den(47)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,10),T4sum(1:70,23))
  M(1) = M(1) + (-f(22) * den(38)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,61),T4sum(1:70,24))
  M(2) = M(2) + (-f(22) * den(38)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,45),T4sum(1:70,24))
  M(1) = M(1) + (-f(22) * den(38)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,62),T4sum(1:70,24))
  M(1) = M(1) + (-f(20) * den(38)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,30),T4sum(1:70,23))
  M(2) = M(2) + (-f(22) * den(38)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,46),T4sum(1:70,24))
  M(2) = M(2) + (-f(20) * den(38)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,11),T4sum(1:70,23))
  M(2) = M(2) + (f(32) * den(36)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,36),T4sum(1:70,26))
  M(1) = M(1) + (f(32) * den(36)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,17),T4sum(1:70,26))
  M(2) = M(2) + (f(21) * den(47)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,68),T4sum(1:70,27))
  M(1) = M(1) + (f(21) * den(47)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,52),T4sum(1:70,27))
  M(2) = M(2) + (-f(19) * den(47)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,68),T4sum(1:70,27))
  M(2) = M(2) + (-f(18) * den(47)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,37),T4sum(1:70,26))
  M(1) = M(1) + (-f(19) * den(47)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,52),T4sum(1:70,27))
  M(1) = M(1) + (-f(18) * den(47)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,18),T4sum(1:70,26))
  M(2) = M(2) + (-f(22) * den(38)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,69),T4sum(1:70,27))
  M(1) = M(1) + (-f(22) * den(38)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,53),T4sum(1:70,27))
  M(2) = M(2) + (-f(22) * den(38)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,70),T4sum(1:70,27))
  M(2) = M(2) + (-f(20) * den(38)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,38),T4sum(1:70,26))
  M(1) = M(1) + (-f(22) * den(38)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,54),T4sum(1:70,27))
  M(1) = M(1) + (-f(20) * den(38)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,19),T4sum(1:70,26))

end subroutine vamp_2

end module ol_vamp_2_pphllj2_eexhggg_1_/**/REALKIND
