
module ol_vamp_1_pphllj2_eexhggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphllj2_eexhggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphllj2_eexhggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphllj2_eexhggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphllj2_eexhggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,23) :: G0
  complex(REALKIND), dimension(4,5,4,94) :: G1
  complex(REALKIND), dimension(4,15,4,198) :: G2
  complex(REALKIND), dimension(4,35,4,246) :: G3
  complex(REALKIND), dimension(4,70,4,144) :: G4
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,24,32))
    allocate(G4tensorhel(70,96,32))
    allocate(G5tensorhel(126,96,32))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,8),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,24),ZERO,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-5),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,56),ZERO,G2(:,:,:,1))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,10),G2(:,:,:,2),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,63),ZERO,G3tensor(:,1))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,10),G2(:,:,:,3),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,3),Q(:,63),ZERO,G3tensor(:,2))
  call loop_AV_Q(G0(:,:,:,1),wf(:,8),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,24),MT,G1(:,:,:,3))
  call loop_AV_Q(G1(:,:,:,3),wf(:,-5),G1(:,:,:,4))
  call loop_A_Q(G1(:,:,:,4),Q(:,56),MT,G2(:,:,:,4))
  call loop_AZ_Q(G2(:,:,:,4),wf(:,10),G2(:,:,:,5),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,5),Q(:,63),MT,G3tensor(:,3))
  call loop_AS_Q(G1(:,:,:,3),wf(:,-2),G1(:,:,:,5),gH)
  call loop_A_Q(G1(:,:,:,5),Q(:,28),MT,G2(:,:,:,6))
  call loop_AV_Q(G2(:,:,:,6),wf(:,-5),G2(:,:,:,7))
  call loop_A_Q(G2(:,:,:,7),Q(:,60),MT,G3(:,:,:,1))
  call loop_AV_Q(G3(:,:,:,1),wf(:,15),G3(:,:,:,2))
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,63),MT,G4tensor(:,1))
  call loop_AZ_Q(G3(:,:,:,1),wf(:,3),G3(:,:,:,3),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,3),Q(:,63),MT,G4tensor(:,2))
  call loop_QV_A(G0(:,:,:,1),wf(:,8),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,24),ZERO,G1(:,:,:,6))
  call loop_QV_A(G1(:,:,:,6),wf(:,-5),G1(:,:,:,7))
  call loop_Q_A(G1(:,:,:,7),Q(:,56),ZERO,G2(:,:,:,8))
  call loop_QZ_A(G2(:,:,:,8),wf(:,10),G2(:,:,:,9),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,9),Q(:,63),ZERO,G3tensor(:,4))
  call loop_QZ_A(G2(:,:,:,8),wf(:,10),G2(:,:,:,10),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,10),Q(:,63),ZERO,G3tensor(:,5))
  call loop_QV_A(G0(:,:,:,1),wf(:,8),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,24),MT,G1(:,:,:,8))
  call loop_QV_A(G1(:,:,:,8),wf(:,-5),G1(:,:,:,9))
  call loop_Q_A(G1(:,:,:,9),Q(:,56),MT,G2(:,:,:,11))
  call loop_QZ_A(G2(:,:,:,11),wf(:,10),G2(:,:,:,12),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,12),Q(:,63),MT,G3tensor(:,6))
  call loop_QS_A(G1(:,:,:,8),wf(:,-2),G1(:,:,:,10),gH)
  call loop_Q_A(G1(:,:,:,10),Q(:,28),MT,G2(:,:,:,13))
  call loop_QV_A(G2(:,:,:,13),wf(:,-5),G2(:,:,:,14))
  call loop_Q_A(G2(:,:,:,14),Q(:,60),MT,G3(:,:,:,4))
  call loop_QV_A(G3(:,:,:,4),wf(:,15),G3(:,:,:,5))
  call check_last_Q_A(l_switch,G3(:,:,:,5),Q(:,63),MT,G4tensor(:,3))
  call loop_QZ_A(G3(:,:,:,4),wf(:,3),G3(:,:,:,6),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,6),Q(:,63),MT,G4tensor(:,4))
  call loop_AV_Q(G0(:,:,:,1),wf(:,8),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,24),MB,G1(:,:,:,11))
  call loop_AV_Q(G1(:,:,:,11),wf(:,-5),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,56),MB,G2(:,:,:,15))
  call loop_AZ_Q(G2(:,:,:,15),wf(:,10),G2(:,:,:,16),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,16),Q(:,63),MB,G3tensor(:,7))
  call loop_AS_Q(G1(:,:,:,11),wf(:,-2),G1(:,:,:,13),gH)
  call loop_A_Q(G1(:,:,:,13),Q(:,28),MB,G2(:,:,:,17))
  call loop_AV_Q(G2(:,:,:,17),wf(:,-5),G2(:,:,:,18))
  call loop_A_Q(G2(:,:,:,18),Q(:,60),MB,G3(:,:,:,7))
  call loop_AV_Q(G3(:,:,:,7),wf(:,15),G3(:,:,:,8))
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,63),MB,G4tensor(:,5))
  call loop_AZ_Q(G3(:,:,:,7),wf(:,3),G3(:,:,:,9),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,9),Q(:,63),MB,G4tensor(:,6))
  call loop_QV_A(G0(:,:,:,1),wf(:,8),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,24),MB,G1(:,:,:,14))
  call loop_QV_A(G1(:,:,:,14),wf(:,-5),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,56),MB,G2(:,:,:,19))
  call loop_QZ_A(G2(:,:,:,19),wf(:,10),G2(:,:,:,20),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,20),Q(:,63),MB,G3tensor(:,8))
  call loop_QS_A(G1(:,:,:,14),wf(:,-2),G1(:,:,:,16),gH)
  call loop_Q_A(G1(:,:,:,16),Q(:,28),MB,G2(:,:,:,21))
  call loop_QV_A(G2(:,:,:,21),wf(:,-5),G2(:,:,:,22))
  call loop_Q_A(G2(:,:,:,22),Q(:,60),MB,G3(:,:,:,10))
  call loop_QV_A(G3(:,:,:,10),wf(:,15),G3(:,:,:,11))
  call check_last_Q_A(l_switch,G3(:,:,:,11),Q(:,63),MB,G4tensor(:,7))
  call loop_QZ_A(G3(:,:,:,10),wf(:,3),G3(:,:,:,12),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,12),Q(:,63),MB,G4tensor(:,8))
  call loop_AS_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,8),gH)
  call loop_A_Q(G0(:,:,:,8),Q(:,4),MT,G1(:,:,:,17))
  call loop_AV_Q(G1(:,:,:,17),wf(:,-5),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,36),MT,G2(:,:,:,23))
  call loop_AV_Q(G2(:,:,:,23),wf(:,8),G2(:,:,:,24))
  call loop_A_Q(G2(:,:,:,24),Q(:,60),MT,G3(:,:,:,13))
  call loop_AV_Q(G3(:,:,:,13),wf(:,15),G3(:,:,:,14))
  call check_last_A_Q(l_switch,G3(:,:,:,14),Q(:,63),MT,G4tensor(:,9))
  call loop_AZ_Q(G3(:,:,:,13),wf(:,3),G3(:,:,:,15),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,15),Q(:,63),MT,G4tensor(:,10))
  call loop_AV_Q(G2(:,:,:,23),wf(:,-3),G2(:,:,:,25))
  call loop_A_Q(G2(:,:,:,25),Q(:,44),MT,G3(:,:,:,16))
  call loop_AV_Q(G3(:,:,:,16),wf(:,-4),G3(:,:,:,17))
  call loop_A_Q(G3(:,:,:,17),Q(:,60),MT,G4(:,:,:,1))
  call loop_AV_Q(G4(:,:,:,1),wf(:,15),G4(:,:,:,2))
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,63),MT,G5tensor(:,1))
  call loop_AZ_Q(G4(:,:,:,1),wf(:,3),G4(:,:,:,3),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,3),Q(:,63),MT,G5tensor(:,2))
  call loop_AV_Q(G2(:,:,:,23),wf(:,-4),G2(:,:,:,26))
  call loop_A_Q(G2(:,:,:,26),Q(:,52),MT,G3(:,:,:,18))
  call loop_AV_Q(G3(:,:,:,18),wf(:,-3),G3(:,:,:,19))
  call loop_A_Q(G3(:,:,:,19),Q(:,60),MT,G4(:,:,:,4))
  call loop_AV_Q(G4(:,:,:,4),wf(:,15),G4(:,:,:,5))
  call check_last_A_Q(l_switch,G4(:,:,:,5),Q(:,63),MT,G5tensor(:,3))
  call loop_AZ_Q(G4(:,:,:,4),wf(:,3),G4(:,:,:,6),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,6),Q(:,63),MT,G5tensor(:,4))
  call loop_AV_Q(G1(:,:,:,17),wf(:,8),G1(:,:,:,19))
  call loop_A_Q(G1(:,:,:,19),Q(:,28),MT,G2(:,:,:,27))
  call loop_AV_Q(G2(:,:,:,27),wf(:,-5),G2(:,:,:,28))
  call loop_A_Q(G2(:,:,:,28),Q(:,60),MT,G3(:,:,:,20))
  call loop_AV_Q(G3(:,:,:,20),wf(:,15),G3(:,:,:,21))
  call check_last_A_Q(l_switch,G3(:,:,:,21),Q(:,63),MT,G4tensor(:,11))
  call loop_AZ_Q(G3(:,:,:,20),wf(:,3),G3(:,:,:,22),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,22),Q(:,63),MT,G4tensor(:,12))
  call loop_AV_Q(G1(:,:,:,17),wf(:,-4),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,20),MT,G2(:,:,:,29))
  call loop_AV_Q(G2(:,:,:,29),wf(:,11),G2(:,:,:,30))
  call loop_A_Q(G2(:,:,:,30),Q(:,60),MT,G3(:,:,:,23))
  call loop_AV_Q(G3(:,:,:,23),wf(:,15),G3(:,:,:,24))
  call check_last_A_Q(l_switch,G3(:,:,:,24),Q(:,63),MT,G4tensor(:,13))
  call loop_AZ_Q(G3(:,:,:,23),wf(:,3),G3(:,:,:,25),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,25),Q(:,63),MT,G4tensor(:,14))
  call loop_AV_Q(G2(:,:,:,29),wf(:,-3),G2(:,:,:,31))
  call loop_A_Q(G2(:,:,:,31),Q(:,28),MT,G3(:,:,:,26))
  call loop_AV_Q(G3(:,:,:,26),wf(:,-5),G3(:,:,:,27))
  call loop_A_Q(G3(:,:,:,27),Q(:,60),MT,G4(:,:,:,7))
  call loop_AV_Q(G4(:,:,:,7),wf(:,15),G4(:,:,:,8))
  call check_last_A_Q(l_switch,G4(:,:,:,8),Q(:,63),MT,G5tensor(:,5))
  call loop_AZ_Q(G4(:,:,:,7),wf(:,3),G4(:,:,:,9),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,9),Q(:,63),MT,G5tensor(:,6))
  call loop_AV_Q(G2(:,:,:,29),wf(:,-5),G2(:,:,:,32))
  call loop_A_Q(G2(:,:,:,32),Q(:,52),MT,G3(:,:,:,28))
  call loop_AV_Q(G3(:,:,:,28),wf(:,-3),G3(:,:,:,29))
  call loop_A_Q(G3(:,:,:,29),Q(:,60),MT,G4(:,:,:,10))
  call loop_AV_Q(G4(:,:,:,10),wf(:,15),G4(:,:,:,11))
  call check_last_A_Q(l_switch,G4(:,:,:,11),Q(:,63),MT,G5tensor(:,7))
  call loop_AZ_Q(G4(:,:,:,10),wf(:,3),G4(:,:,:,12),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,12),Q(:,63),MT,G5tensor(:,8))
  call loop_AV_Q(G1(:,:,:,17),wf(:,11),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,44),MT,G2(:,:,:,33))
  call loop_AV_Q(G2(:,:,:,33),wf(:,-4),G2(:,:,:,34))
  call loop_A_Q(G2(:,:,:,34),Q(:,60),MT,G3(:,:,:,30))
  call loop_AV_Q(G3(:,:,:,30),wf(:,15),G3(:,:,:,31))
  call check_last_A_Q(l_switch,G3(:,:,:,31),Q(:,63),MT,G4tensor(:,15))
  call loop_AZ_Q(G3(:,:,:,30),wf(:,3),G3(:,:,:,32),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,32),Q(:,63),MT,G4tensor(:,16))
  call loop_AV_Q(G1(:,:,:,17),wf(:,-3),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,12),MT,G2(:,:,:,35))
  call loop_AV_Q(G2(:,:,:,35),wf(:,13),G2(:,:,:,36))
  call loop_A_Q(G2(:,:,:,36),Q(:,60),MT,G3(:,:,:,33))
  call loop_AV_Q(G3(:,:,:,33),wf(:,15),G3(:,:,:,34))
  call check_last_A_Q(l_switch,G3(:,:,:,34),Q(:,63),MT,G4tensor(:,17))
  call loop_AZ_Q(G3(:,:,:,33),wf(:,3),G3(:,:,:,35),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,35),Q(:,63),MT,G4tensor(:,18))
  call loop_AV_Q(G2(:,:,:,35),wf(:,-4),G2(:,:,:,37))
  call loop_A_Q(G2(:,:,:,37),Q(:,28),MT,G3(:,:,:,36))
  call loop_AV_Q(G3(:,:,:,36),wf(:,-5),G3(:,:,:,37))
  call loop_A_Q(G3(:,:,:,37),Q(:,60),MT,G4(:,:,:,13))
  call loop_AV_Q(G4(:,:,:,13),wf(:,15),G4(:,:,:,14))
  call check_last_A_Q(l_switch,G4(:,:,:,14),Q(:,63),MT,G5tensor(:,9))
  call loop_AZ_Q(G4(:,:,:,13),wf(:,3),G4(:,:,:,15),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,15),Q(:,63),MT,G5tensor(:,10))
  call loop_AV_Q(G2(:,:,:,35),wf(:,-5),G2(:,:,:,38))
  call loop_A_Q(G2(:,:,:,38),Q(:,44),MT,G3(:,:,:,38))
  call loop_AV_Q(G3(:,:,:,38),wf(:,-4),G3(:,:,:,39))
  call loop_A_Q(G3(:,:,:,39),Q(:,60),MT,G4(:,:,:,16))
  call loop_AV_Q(G4(:,:,:,16),wf(:,15),G4(:,:,:,17))
  call check_last_A_Q(l_switch,G4(:,:,:,17),Q(:,63),MT,G5tensor(:,11))
  call loop_AZ_Q(G4(:,:,:,16),wf(:,3),G4(:,:,:,18),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,18),Q(:,63),MT,G5tensor(:,12))
  call loop_AV_Q(G1(:,:,:,17),wf(:,13),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,52),MT,G2(:,:,:,39))
  call loop_AV_Q(G2(:,:,:,39),wf(:,-3),G2(:,:,:,40))
  call loop_A_Q(G2(:,:,:,40),Q(:,60),MT,G3(:,:,:,40))
  call loop_AV_Q(G3(:,:,:,40),wf(:,15),G3(:,:,:,41))
  call check_last_A_Q(l_switch,G3(:,:,:,41),Q(:,63),MT,G4tensor(:,19))
  call loop_AZ_Q(G3(:,:,:,40),wf(:,3),G3(:,:,:,42),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,42),Q(:,63),MT,G4tensor(:,20))
  call loop_QS_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,9),gH)
  call loop_Q_A(G0(:,:,:,9),Q(:,4),MT,G1(:,:,:,24))
  call loop_QV_A(G1(:,:,:,24),wf(:,-5),G1(:,:,:,25))
  call loop_Q_A(G1(:,:,:,25),Q(:,36),MT,G2(:,:,:,41))
  call loop_QV_A(G2(:,:,:,41),wf(:,8),G2(:,:,:,42))
  call loop_Q_A(G2(:,:,:,42),Q(:,60),MT,G3(:,:,:,43))
  call loop_QV_A(G3(:,:,:,43),wf(:,15),G3(:,:,:,44))
  call check_last_Q_A(l_switch,G3(:,:,:,44),Q(:,63),MT,G4tensor(:,21))
  call loop_QZ_A(G3(:,:,:,43),wf(:,3),G3(:,:,:,45),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,45),Q(:,63),MT,G4tensor(:,22))
  call loop_QV_A(G2(:,:,:,41),wf(:,-3),G2(:,:,:,43))
  call loop_Q_A(G2(:,:,:,43),Q(:,44),MT,G3(:,:,:,46))
  call loop_QV_A(G3(:,:,:,46),wf(:,-4),G3(:,:,:,47))
  call loop_Q_A(G3(:,:,:,47),Q(:,60),MT,G4(:,:,:,19))
  call loop_QV_A(G4(:,:,:,19),wf(:,15),G4(:,:,:,20))
  call check_last_Q_A(l_switch,G4(:,:,:,20),Q(:,63),MT,G5tensor(:,13))
  call loop_QZ_A(G4(:,:,:,19),wf(:,3),G4(:,:,:,21),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,21),Q(:,63),MT,G5tensor(:,14))
  call loop_QV_A(G2(:,:,:,41),wf(:,-4),G2(:,:,:,44))
  call loop_Q_A(G2(:,:,:,44),Q(:,52),MT,G3(:,:,:,48))
  call loop_QV_A(G3(:,:,:,48),wf(:,-3),G3(:,:,:,49))
  call loop_Q_A(G3(:,:,:,49),Q(:,60),MT,G4(:,:,:,22))
  call loop_QV_A(G4(:,:,:,22),wf(:,15),G4(:,:,:,23))
  call check_last_Q_A(l_switch,G4(:,:,:,23),Q(:,63),MT,G5tensor(:,15))
  call loop_QZ_A(G4(:,:,:,22),wf(:,3),G4(:,:,:,24),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,24),Q(:,63),MT,G5tensor(:,16))
  call loop_QV_A(G1(:,:,:,24),wf(:,8),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,28),MT,G2(:,:,:,45))
  call loop_QV_A(G2(:,:,:,45),wf(:,-5),G2(:,:,:,46))
  call loop_Q_A(G2(:,:,:,46),Q(:,60),MT,G3(:,:,:,50))
  call loop_QV_A(G3(:,:,:,50),wf(:,15),G3(:,:,:,51))
  call check_last_Q_A(l_switch,G3(:,:,:,51),Q(:,63),MT,G4tensor(:,23))
  call loop_QZ_A(G3(:,:,:,50),wf(:,3),G3(:,:,:,52),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,52),Q(:,63),MT,G4tensor(:,24))
  call loop_QV_A(G1(:,:,:,24),wf(:,-4),G1(:,:,:,27))
  call loop_Q_A(G1(:,:,:,27),Q(:,20),MT,G2(:,:,:,47))
  call loop_QV_A(G2(:,:,:,47),wf(:,11),G2(:,:,:,48))
  call loop_Q_A(G2(:,:,:,48),Q(:,60),MT,G3(:,:,:,53))
  call loop_QV_A(G3(:,:,:,53),wf(:,15),G3(:,:,:,54))
  call check_last_Q_A(l_switch,G3(:,:,:,54),Q(:,63),MT,G4tensor(:,25))
  call loop_QZ_A(G3(:,:,:,53),wf(:,3),G3(:,:,:,55),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,55),Q(:,63),MT,G4tensor(:,26))
  call loop_QV_A(G2(:,:,:,47),wf(:,-3),G2(:,:,:,49))
  call loop_Q_A(G2(:,:,:,49),Q(:,28),MT,G3(:,:,:,56))
  call loop_QV_A(G3(:,:,:,56),wf(:,-5),G3(:,:,:,57))
  call loop_Q_A(G3(:,:,:,57),Q(:,60),MT,G4(:,:,:,25))
  call loop_QV_A(G4(:,:,:,25),wf(:,15),G4(:,:,:,26))
  call check_last_Q_A(l_switch,G4(:,:,:,26),Q(:,63),MT,G5tensor(:,17))
  call loop_QZ_A(G4(:,:,:,25),wf(:,3),G4(:,:,:,27),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,27),Q(:,63),MT,G5tensor(:,18))
  call loop_QV_A(G2(:,:,:,47),wf(:,-5),G2(:,:,:,50))
  call loop_Q_A(G2(:,:,:,50),Q(:,52),MT,G3(:,:,:,58))
  call loop_QV_A(G3(:,:,:,58),wf(:,-3),G3(:,:,:,59))
  call loop_Q_A(G3(:,:,:,59),Q(:,60),MT,G4(:,:,:,28))
  call loop_QV_A(G4(:,:,:,28),wf(:,15),G4(:,:,:,29))
  call check_last_Q_A(l_switch,G4(:,:,:,29),Q(:,63),MT,G5tensor(:,19))
  call loop_QZ_A(G4(:,:,:,28),wf(:,3),G4(:,:,:,30),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,30),Q(:,63),MT,G5tensor(:,20))
  call loop_QV_A(G1(:,:,:,24),wf(:,11),G1(:,:,:,28))
  call loop_Q_A(G1(:,:,:,28),Q(:,44),MT,G2(:,:,:,51))
  call loop_QV_A(G2(:,:,:,51),wf(:,-4),G2(:,:,:,52))
  call loop_Q_A(G2(:,:,:,52),Q(:,60),MT,G3(:,:,:,60))
  call loop_QV_A(G3(:,:,:,60),wf(:,15),G3(:,:,:,61))
  call check_last_Q_A(l_switch,G3(:,:,:,61),Q(:,63),MT,G4tensor(:,27))
  call loop_QZ_A(G3(:,:,:,60),wf(:,3),G3(:,:,:,62),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,62),Q(:,63),MT,G4tensor(:,28))
  call loop_QV_A(G1(:,:,:,24),wf(:,-3),G1(:,:,:,29))
  call loop_Q_A(G1(:,:,:,29),Q(:,12),MT,G2(:,:,:,53))
  call loop_QV_A(G2(:,:,:,53),wf(:,13),G2(:,:,:,54))
  call loop_Q_A(G2(:,:,:,54),Q(:,60),MT,G3(:,:,:,63))
  call loop_QV_A(G3(:,:,:,63),wf(:,15),G3(:,:,:,64))
  call check_last_Q_A(l_switch,G3(:,:,:,64),Q(:,63),MT,G4tensor(:,29))
  call loop_QZ_A(G3(:,:,:,63),wf(:,3),G3(:,:,:,65),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,65),Q(:,63),MT,G4tensor(:,30))
  call loop_QV_A(G2(:,:,:,53),wf(:,-4),G2(:,:,:,55))
  call loop_Q_A(G2(:,:,:,55),Q(:,28),MT,G3(:,:,:,66))
  call loop_QV_A(G3(:,:,:,66),wf(:,-5),G3(:,:,:,67))
  call loop_Q_A(G3(:,:,:,67),Q(:,60),MT,G4(:,:,:,31))
  call loop_QV_A(G4(:,:,:,31),wf(:,15),G4(:,:,:,32))
  call check_last_Q_A(l_switch,G4(:,:,:,32),Q(:,63),MT,G5tensor(:,21))
  call loop_QZ_A(G4(:,:,:,31),wf(:,3),G4(:,:,:,33),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,33),Q(:,63),MT,G5tensor(:,22))
  call loop_QV_A(G2(:,:,:,53),wf(:,-5),G2(:,:,:,56))
  call loop_Q_A(G2(:,:,:,56),Q(:,44),MT,G3(:,:,:,68))
  call loop_QV_A(G3(:,:,:,68),wf(:,-4),G3(:,:,:,69))
  call loop_Q_A(G3(:,:,:,69),Q(:,60),MT,G4(:,:,:,34))
  call loop_QV_A(G4(:,:,:,34),wf(:,15),G4(:,:,:,35))
  call check_last_Q_A(l_switch,G4(:,:,:,35),Q(:,63),MT,G5tensor(:,23))
  call loop_QZ_A(G4(:,:,:,34),wf(:,3),G4(:,:,:,36),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,36),Q(:,63),MT,G5tensor(:,24))
  call loop_QV_A(G1(:,:,:,24),wf(:,13),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,52),MT,G2(:,:,:,57))
  call loop_QV_A(G2(:,:,:,57),wf(:,-3),G2(:,:,:,58))
  call loop_Q_A(G2(:,:,:,58),Q(:,60),MT,G3(:,:,:,70))
  call loop_QV_A(G3(:,:,:,70),wf(:,15),G3(:,:,:,71))
  call check_last_Q_A(l_switch,G3(:,:,:,71),Q(:,63),MT,G4tensor(:,31))
  call loop_QZ_A(G3(:,:,:,70),wf(:,3),G3(:,:,:,72),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,72),Q(:,63),MT,G4tensor(:,32))
  call loop_AS_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,10),gH)
  call loop_A_Q(G0(:,:,:,10),Q(:,4),MB,G1(:,:,:,31))
  call loop_AV_Q(G1(:,:,:,31),wf(:,-5),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,36),MB,G2(:,:,:,59))
  call loop_AV_Q(G2(:,:,:,59),wf(:,8),G2(:,:,:,60))
  call loop_A_Q(G2(:,:,:,60),Q(:,60),MB,G3(:,:,:,73))
  call loop_AV_Q(G3(:,:,:,73),wf(:,15),G3(:,:,:,74))
  call check_last_A_Q(l_switch,G3(:,:,:,74),Q(:,63),MB,G4tensor(:,33))
  call loop_AZ_Q(G3(:,:,:,73),wf(:,3),G3(:,:,:,75),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,75),Q(:,63),MB,G4tensor(:,34))
  call loop_AV_Q(G2(:,:,:,59),wf(:,-3),G2(:,:,:,61))
  call loop_A_Q(G2(:,:,:,61),Q(:,44),MB,G3(:,:,:,76))
  call loop_AV_Q(G3(:,:,:,76),wf(:,-4),G3(:,:,:,77))
  call loop_A_Q(G3(:,:,:,77),Q(:,60),MB,G4(:,:,:,37))
  call loop_AV_Q(G4(:,:,:,37),wf(:,15),G4(:,:,:,38))
  call check_last_A_Q(l_switch,G4(:,:,:,38),Q(:,63),MB,G5tensor(:,25))
  call loop_AZ_Q(G4(:,:,:,37),wf(:,3),G4(:,:,:,39),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,39),Q(:,63),MB,G5tensor(:,26))
  call loop_AV_Q(G2(:,:,:,59),wf(:,-4),G2(:,:,:,62))
  call loop_A_Q(G2(:,:,:,62),Q(:,52),MB,G3(:,:,:,78))
  call loop_AV_Q(G3(:,:,:,78),wf(:,-3),G3(:,:,:,79))
  call loop_A_Q(G3(:,:,:,79),Q(:,60),MB,G4(:,:,:,40))
  call loop_AV_Q(G4(:,:,:,40),wf(:,15),G4(:,:,:,41))
  call check_last_A_Q(l_switch,G4(:,:,:,41),Q(:,63),MB,G5tensor(:,27))
  call loop_AZ_Q(G4(:,:,:,40),wf(:,3),G4(:,:,:,42),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,42),Q(:,63),MB,G5tensor(:,28))
  call loop_AV_Q(G1(:,:,:,31),wf(:,8),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,28),MB,G2(:,:,:,63))
  call loop_AV_Q(G2(:,:,:,63),wf(:,-5),G2(:,:,:,64))
  call loop_A_Q(G2(:,:,:,64),Q(:,60),MB,G3(:,:,:,80))
  call loop_AV_Q(G3(:,:,:,80),wf(:,15),G3(:,:,:,81))
  call check_last_A_Q(l_switch,G3(:,:,:,81),Q(:,63),MB,G4tensor(:,35))
  call loop_AZ_Q(G3(:,:,:,80),wf(:,3),G3(:,:,:,82),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,82),Q(:,63),MB,G4tensor(:,36))
  call loop_AV_Q(G1(:,:,:,31),wf(:,-4),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,20),MB,G2(:,:,:,65))
  call loop_AV_Q(G2(:,:,:,65),wf(:,11),G2(:,:,:,66))
  call loop_A_Q(G2(:,:,:,66),Q(:,60),MB,G3(:,:,:,83))
  call loop_AV_Q(G3(:,:,:,83),wf(:,15),G3(:,:,:,84))
  call check_last_A_Q(l_switch,G3(:,:,:,84),Q(:,63),MB,G4tensor(:,37))
  call loop_AZ_Q(G3(:,:,:,83),wf(:,3),G3(:,:,:,85),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,85),Q(:,63),MB,G4tensor(:,38))
  call loop_AV_Q(G2(:,:,:,65),wf(:,-3),G2(:,:,:,67))
  call loop_A_Q(G2(:,:,:,67),Q(:,28),MB,G3(:,:,:,86))
  call loop_AV_Q(G3(:,:,:,86),wf(:,-5),G3(:,:,:,87))
  call loop_A_Q(G3(:,:,:,87),Q(:,60),MB,G4(:,:,:,43))
  call loop_AV_Q(G4(:,:,:,43),wf(:,15),G4(:,:,:,44))
  call check_last_A_Q(l_switch,G4(:,:,:,44),Q(:,63),MB,G5tensor(:,29))
  call loop_AZ_Q(G4(:,:,:,43),wf(:,3),G4(:,:,:,45),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,45),Q(:,63),MB,G5tensor(:,30))
  call loop_AV_Q(G2(:,:,:,65),wf(:,-5),G2(:,:,:,68))
  call loop_A_Q(G2(:,:,:,68),Q(:,52),MB,G3(:,:,:,88))
  call loop_AV_Q(G3(:,:,:,88),wf(:,-3),G3(:,:,:,89))
  call loop_A_Q(G3(:,:,:,89),Q(:,60),MB,G4(:,:,:,46))
  call loop_AV_Q(G4(:,:,:,46),wf(:,15),G4(:,:,:,47))
  call check_last_A_Q(l_switch,G4(:,:,:,47),Q(:,63),MB,G5tensor(:,31))
  call loop_AZ_Q(G4(:,:,:,46),wf(:,3),G4(:,:,:,48),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,48),Q(:,63),MB,G5tensor(:,32))
  call loop_AV_Q(G1(:,:,:,31),wf(:,11),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,44),MB,G2(:,:,:,69))
  call loop_AV_Q(G2(:,:,:,69),wf(:,-4),G2(:,:,:,70))
  call loop_A_Q(G2(:,:,:,70),Q(:,60),MB,G3(:,:,:,90))
  call loop_AV_Q(G3(:,:,:,90),wf(:,15),G3(:,:,:,91))
  call check_last_A_Q(l_switch,G3(:,:,:,91),Q(:,63),MB,G4tensor(:,39))
  call loop_AZ_Q(G3(:,:,:,90),wf(:,3),G3(:,:,:,92),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,92),Q(:,63),MB,G4tensor(:,40))
  call loop_AV_Q(G1(:,:,:,31),wf(:,-3),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,12),MB,G2(:,:,:,71))
  call loop_AV_Q(G2(:,:,:,71),wf(:,13),G2(:,:,:,72))
  call loop_A_Q(G2(:,:,:,72),Q(:,60),MB,G3(:,:,:,93))
  call loop_AV_Q(G3(:,:,:,93),wf(:,15),G3(:,:,:,94))
  call check_last_A_Q(l_switch,G3(:,:,:,94),Q(:,63),MB,G4tensor(:,41))
  call loop_AZ_Q(G3(:,:,:,93),wf(:,3),G3(:,:,:,95),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,95),Q(:,63),MB,G4tensor(:,42))
  call loop_AV_Q(G2(:,:,:,71),wf(:,-4),G2(:,:,:,73))
  call loop_A_Q(G2(:,:,:,73),Q(:,28),MB,G3(:,:,:,96))
  call loop_AV_Q(G3(:,:,:,96),wf(:,-5),G3(:,:,:,97))
  call loop_A_Q(G3(:,:,:,97),Q(:,60),MB,G4(:,:,:,49))
  call loop_AV_Q(G4(:,:,:,49),wf(:,15),G4(:,:,:,50))
  call check_last_A_Q(l_switch,G4(:,:,:,50),Q(:,63),MB,G5tensor(:,33))
  call loop_AZ_Q(G4(:,:,:,49),wf(:,3),G4(:,:,:,51),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,51),Q(:,63),MB,G5tensor(:,34))
  call loop_AV_Q(G2(:,:,:,71),wf(:,-5),G2(:,:,:,74))
  call loop_A_Q(G2(:,:,:,74),Q(:,44),MB,G3(:,:,:,98))
  call loop_AV_Q(G3(:,:,:,98),wf(:,-4),G3(:,:,:,99))
  call loop_A_Q(G3(:,:,:,99),Q(:,60),MB,G4(:,:,:,52))
  call loop_AV_Q(G4(:,:,:,52),wf(:,15),G4(:,:,:,53))
  call check_last_A_Q(l_switch,G4(:,:,:,53),Q(:,63),MB,G5tensor(:,35))
  call loop_AZ_Q(G4(:,:,:,52),wf(:,3),G4(:,:,:,54),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,54),Q(:,63),MB,G5tensor(:,36))
  call loop_AV_Q(G1(:,:,:,31),wf(:,13),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,52),MB,G2(:,:,:,75))
  call loop_AV_Q(G2(:,:,:,75),wf(:,-3),G2(:,:,:,76))
  call loop_A_Q(G2(:,:,:,76),Q(:,60),MB,G3(:,:,:,100))
  call loop_AV_Q(G3(:,:,:,100),wf(:,15),G3(:,:,:,101))
  call check_last_A_Q(l_switch,G3(:,:,:,101),Q(:,63),MB,G4tensor(:,43))
  call loop_AZ_Q(G3(:,:,:,100),wf(:,3),G3(:,:,:,102),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,102),Q(:,63),MB,G4tensor(:,44))
  call loop_QS_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,11),gH)
  call loop_Q_A(G0(:,:,:,11),Q(:,4),MB,G1(:,:,:,38))
  call loop_QV_A(G1(:,:,:,38),wf(:,-5),G1(:,:,:,39))
  call loop_Q_A(G1(:,:,:,39),Q(:,36),MB,G2(:,:,:,77))
  call loop_QV_A(G2(:,:,:,77),wf(:,8),G2(:,:,:,78))
  call loop_Q_A(G2(:,:,:,78),Q(:,60),MB,G3(:,:,:,103))
  call loop_QV_A(G3(:,:,:,103),wf(:,15),G3(:,:,:,104))
  call check_last_Q_A(l_switch,G3(:,:,:,104),Q(:,63),MB,G4tensor(:,45))
  call loop_QZ_A(G3(:,:,:,103),wf(:,3),G3(:,:,:,105),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,105),Q(:,63),MB,G4tensor(:,46))
  call loop_QV_A(G2(:,:,:,77),wf(:,-3),G2(:,:,:,79))
  call loop_Q_A(G2(:,:,:,79),Q(:,44),MB,G3(:,:,:,106))
  call loop_QV_A(G3(:,:,:,106),wf(:,-4),G3(:,:,:,107))
  call loop_Q_A(G3(:,:,:,107),Q(:,60),MB,G4(:,:,:,55))
  call loop_QV_A(G4(:,:,:,55),wf(:,15),G4(:,:,:,56))
  call check_last_Q_A(l_switch,G4(:,:,:,56),Q(:,63),MB,G5tensor(:,37))
  call loop_QZ_A(G4(:,:,:,55),wf(:,3),G4(:,:,:,57),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,57),Q(:,63),MB,G5tensor(:,38))
  call loop_QV_A(G2(:,:,:,77),wf(:,-4),G2(:,:,:,80))
  call loop_Q_A(G2(:,:,:,80),Q(:,52),MB,G3(:,:,:,108))
  call loop_QV_A(G3(:,:,:,108),wf(:,-3),G3(:,:,:,109))
  call loop_Q_A(G3(:,:,:,109),Q(:,60),MB,G4(:,:,:,58))
  call loop_QV_A(G4(:,:,:,58),wf(:,15),G4(:,:,:,59))
  call check_last_Q_A(l_switch,G4(:,:,:,59),Q(:,63),MB,G5tensor(:,39))
  call loop_QZ_A(G4(:,:,:,58),wf(:,3),G4(:,:,:,60),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,60),Q(:,63),MB,G5tensor(:,40))
  call loop_QV_A(G1(:,:,:,38),wf(:,8),G1(:,:,:,40))
  call loop_Q_A(G1(:,:,:,40),Q(:,28),MB,G2(:,:,:,81))
  call loop_QV_A(G2(:,:,:,81),wf(:,-5),G2(:,:,:,82))
  call loop_Q_A(G2(:,:,:,82),Q(:,60),MB,G3(:,:,:,110))
  call loop_QV_A(G3(:,:,:,110),wf(:,15),G3(:,:,:,111))
  call check_last_Q_A(l_switch,G3(:,:,:,111),Q(:,63),MB,G4tensor(:,47))
  call loop_QZ_A(G3(:,:,:,110),wf(:,3),G3(:,:,:,112),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,112),Q(:,63),MB,G4tensor(:,48))
  call loop_QV_A(G1(:,:,:,38),wf(:,-4),G1(:,:,:,41))
  call loop_Q_A(G1(:,:,:,41),Q(:,20),MB,G2(:,:,:,83))
  call loop_QV_A(G2(:,:,:,83),wf(:,11),G2(:,:,:,84))
  call loop_Q_A(G2(:,:,:,84),Q(:,60),MB,G3(:,:,:,113))
  call loop_QV_A(G3(:,:,:,113),wf(:,15),G3(:,:,:,114))
  call check_last_Q_A(l_switch,G3(:,:,:,114),Q(:,63),MB,G4tensor(:,49))
  call loop_QZ_A(G3(:,:,:,113),wf(:,3),G3(:,:,:,115),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,115),Q(:,63),MB,G4tensor(:,50))
  call loop_QV_A(G2(:,:,:,83),wf(:,-3),G2(:,:,:,85))
  call loop_Q_A(G2(:,:,:,85),Q(:,28),MB,G3(:,:,:,116))
  call loop_QV_A(G3(:,:,:,116),wf(:,-5),G3(:,:,:,117))
  call loop_Q_A(G3(:,:,:,117),Q(:,60),MB,G4(:,:,:,61))
  call loop_QV_A(G4(:,:,:,61),wf(:,15),G4(:,:,:,62))
  call check_last_Q_A(l_switch,G4(:,:,:,62),Q(:,63),MB,G5tensor(:,41))
  call loop_QZ_A(G4(:,:,:,61),wf(:,3),G4(:,:,:,63),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,63),Q(:,63),MB,G5tensor(:,42))
  call loop_QV_A(G2(:,:,:,83),wf(:,-5),G2(:,:,:,86))
  call loop_Q_A(G2(:,:,:,86),Q(:,52),MB,G3(:,:,:,118))
  call loop_QV_A(G3(:,:,:,118),wf(:,-3),G3(:,:,:,119))
  call loop_Q_A(G3(:,:,:,119),Q(:,60),MB,G4(:,:,:,64))
  call loop_QV_A(G4(:,:,:,64),wf(:,15),G4(:,:,:,65))
  call check_last_Q_A(l_switch,G4(:,:,:,65),Q(:,63),MB,G5tensor(:,43))
  call loop_QZ_A(G4(:,:,:,64),wf(:,3),G4(:,:,:,66),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,66),Q(:,63),MB,G5tensor(:,44))
  call loop_QV_A(G1(:,:,:,38),wf(:,11),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,44),MB,G2(:,:,:,87))
  call loop_QV_A(G2(:,:,:,87),wf(:,-4),G2(:,:,:,88))
  call loop_Q_A(G2(:,:,:,88),Q(:,60),MB,G3(:,:,:,120))
  call loop_QV_A(G3(:,:,:,120),wf(:,15),G3(:,:,:,121))
  call check_last_Q_A(l_switch,G3(:,:,:,121),Q(:,63),MB,G4tensor(:,51))
  call loop_QZ_A(G3(:,:,:,120),wf(:,3),G3(:,:,:,122),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,122),Q(:,63),MB,G4tensor(:,52))
  call loop_QV_A(G1(:,:,:,38),wf(:,-3),G1(:,:,:,43))
  call loop_Q_A(G1(:,:,:,43),Q(:,12),MB,G2(:,:,:,89))
  call loop_QV_A(G2(:,:,:,89),wf(:,13),G2(:,:,:,90))
  call loop_Q_A(G2(:,:,:,90),Q(:,60),MB,G3(:,:,:,123))
  call loop_QV_A(G3(:,:,:,123),wf(:,15),G3(:,:,:,124))
  call check_last_Q_A(l_switch,G3(:,:,:,124),Q(:,63),MB,G4tensor(:,53))
  call loop_QZ_A(G3(:,:,:,123),wf(:,3),G3(:,:,:,125),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,125),Q(:,63),MB,G4tensor(:,54))
  call loop_QV_A(G2(:,:,:,89),wf(:,-4),G2(:,:,:,91))
  call loop_Q_A(G2(:,:,:,91),Q(:,28),MB,G3(:,:,:,126))
  call loop_QV_A(G3(:,:,:,126),wf(:,-5),G3(:,:,:,127))
  call loop_Q_A(G3(:,:,:,127),Q(:,60),MB,G4(:,:,:,67))
  call loop_QV_A(G4(:,:,:,67),wf(:,15),G4(:,:,:,68))
  call check_last_Q_A(l_switch,G4(:,:,:,68),Q(:,63),MB,G5tensor(:,45))
  call loop_QZ_A(G4(:,:,:,67),wf(:,3),G4(:,:,:,69),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,69),Q(:,63),MB,G5tensor(:,46))
  call loop_QV_A(G2(:,:,:,89),wf(:,-5),G2(:,:,:,92))
  call loop_Q_A(G2(:,:,:,92),Q(:,44),MB,G3(:,:,:,128))
  call loop_QV_A(G3(:,:,:,128),wf(:,-4),G3(:,:,:,129))
  call loop_Q_A(G3(:,:,:,129),Q(:,60),MB,G4(:,:,:,70))
  call loop_QV_A(G4(:,:,:,70),wf(:,15),G4(:,:,:,71))
  call check_last_Q_A(l_switch,G4(:,:,:,71),Q(:,63),MB,G5tensor(:,47))
  call loop_QZ_A(G4(:,:,:,70),wf(:,3),G4(:,:,:,72),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,72),Q(:,63),MB,G5tensor(:,48))
  call loop_QV_A(G1(:,:,:,38),wf(:,13),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,52),MB,G2(:,:,:,93))
  call loop_QV_A(G2(:,:,:,93),wf(:,-3),G2(:,:,:,94))
  call loop_Q_A(G2(:,:,:,94),Q(:,60),MB,G3(:,:,:,130))
  call loop_QV_A(G3(:,:,:,130),wf(:,15),G3(:,:,:,131))
  call check_last_Q_A(l_switch,G3(:,:,:,131),Q(:,63),MB,G4tensor(:,55))
  call loop_QZ_A(G3(:,:,:,130),wf(:,3),G3(:,:,:,132),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,132),Q(:,63),MB,G4tensor(:,56))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,16),ZERO,G1(:,:,:,45))
  call loop_QV_A(G1(:,:,:,45),wf(:,11),G1(:,:,:,46))
  call loop_Q_A(G1(:,:,:,46),Q(:,56),ZERO,G2(:,:,:,95))
  call loop_QZ_A(G2(:,:,:,95),wf(:,10),G2(:,:,:,96),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,96),Q(:,63),ZERO,G3tensor(:,9))
  call loop_QZ_A(G2(:,:,:,95),wf(:,10),G2(:,:,:,97),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,97),Q(:,63),ZERO,G3tensor(:,10))
  call loop_QV_A(G1(:,:,:,45),wf(:,-3),G1(:,:,:,47))
  call loop_Q_A(G1(:,:,:,47),Q(:,24),ZERO,G2(:,:,:,98))
  call loop_QV_A(G2(:,:,:,98),wf(:,-5),G2(:,:,:,99))
  call loop_Q_A(G2(:,:,:,99),Q(:,56),ZERO,G3(:,:,:,133))
  call loop_QZ_A(G3(:,:,:,133),wf(:,10),G3(:,:,:,134),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,134),Q(:,63),ZERO,G4tensor(:,57))
  call loop_QZ_A(G3(:,:,:,133),wf(:,10),G3(:,:,:,135),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,135),Q(:,63),ZERO,G4tensor(:,58))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,16),MT,G1(:,:,:,48))
  call loop_QV_A(G1(:,:,:,48),wf(:,11),G1(:,:,:,49))
  call loop_Q_A(G1(:,:,:,49),Q(:,56),MT,G2(:,:,:,100))
  call loop_QZ_A(G2(:,:,:,100),wf(:,10),G2(:,:,:,101),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,101),Q(:,63),MT,G3tensor(:,11))
  call loop_QS_A(G1(:,:,:,48),wf(:,-2),G1(:,:,:,50),gH)
  call loop_Q_A(G1(:,:,:,50),Q(:,20),MT,G2(:,:,:,102))
  call loop_QV_A(G2(:,:,:,102),wf(:,11),G2(:,:,:,103))
  call loop_Q_A(G2(:,:,:,103),Q(:,60),MT,G3(:,:,:,136))
  call loop_QV_A(G3(:,:,:,136),wf(:,15),G3(:,:,:,137))
  call check_last_Q_A(l_switch,G3(:,:,:,137),Q(:,63),MT,G4tensor(:,59))
  call loop_QZ_A(G3(:,:,:,136),wf(:,3),G3(:,:,:,138),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,138),Q(:,63),MT,G4tensor(:,60))
  call loop_QV_A(G2(:,:,:,102),wf(:,-3),G2(:,:,:,104))
  call loop_Q_A(G2(:,:,:,104),Q(:,28),MT,G3(:,:,:,139))
  call loop_QV_A(G3(:,:,:,139),wf(:,-5),G3(:,:,:,140))
  call loop_Q_A(G3(:,:,:,140),Q(:,60),MT,G4(:,:,:,73))
  call loop_QV_A(G4(:,:,:,73),wf(:,15),G4(:,:,:,74))
  call check_last_Q_A(l_switch,G4(:,:,:,74),Q(:,63),MT,G5tensor(:,49))
  call loop_QZ_A(G4(:,:,:,73),wf(:,3),G4(:,:,:,75),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,75),Q(:,63),MT,G5tensor(:,50))
  call loop_QV_A(G1(:,:,:,48),wf(:,-3),G1(:,:,:,51))
  call loop_Q_A(G1(:,:,:,51),Q(:,24),MT,G2(:,:,:,105))
  call loop_QV_A(G2(:,:,:,105),wf(:,-5),G2(:,:,:,106))
  call loop_Q_A(G2(:,:,:,106),Q(:,56),MT,G3(:,:,:,141))
  call loop_QZ_A(G3(:,:,:,141),wf(:,10),G3(:,:,:,142),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,142),Q(:,63),MT,G4tensor(:,61))
  call loop_QS_A(G2(:,:,:,105),wf(:,-2),G2(:,:,:,107),gH)
  call loop_Q_A(G2(:,:,:,107),Q(:,28),MT,G3(:,:,:,143))
  call loop_QV_A(G3(:,:,:,143),wf(:,-5),G3(:,:,:,144))
  call loop_Q_A(G3(:,:,:,144),Q(:,60),MT,G4(:,:,:,76))
  call loop_QV_A(G4(:,:,:,76),wf(:,15),G4(:,:,:,77))
  call check_last_Q_A(l_switch,G4(:,:,:,77),Q(:,63),MT,G5tensor(:,51))
  call loop_QZ_A(G4(:,:,:,76),wf(:,3),G4(:,:,:,78),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,78),Q(:,63),MT,G5tensor(:,52))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,14))
  call loop_A_Q(G0(:,:,:,14),Q(:,16),ZERO,G1(:,:,:,52))
  call loop_AV_Q(G1(:,:,:,52),wf(:,11),G1(:,:,:,53))
  call loop_A_Q(G1(:,:,:,53),Q(:,56),ZERO,G2(:,:,:,108))
  call loop_AZ_Q(G2(:,:,:,108),wf(:,10),G2(:,:,:,109),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,109),Q(:,63),ZERO,G3tensor(:,12))
  call loop_AZ_Q(G2(:,:,:,108),wf(:,10),G2(:,:,:,110),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,110),Q(:,63),ZERO,G3tensor(:,13))
  call loop_AV_Q(G1(:,:,:,52),wf(:,-3),G1(:,:,:,54))
  call loop_A_Q(G1(:,:,:,54),Q(:,24),ZERO,G2(:,:,:,111))
  call loop_AV_Q(G2(:,:,:,111),wf(:,-5),G2(:,:,:,112))
  call loop_A_Q(G2(:,:,:,112),Q(:,56),ZERO,G3(:,:,:,145))
  call loop_AZ_Q(G3(:,:,:,145),wf(:,10),G3(:,:,:,146),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,146),Q(:,63),ZERO,G4tensor(:,62))
  call loop_AZ_Q(G3(:,:,:,145),wf(:,10),G3(:,:,:,147),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,147),Q(:,63),ZERO,G4tensor(:,63))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,16),MT,G1(:,:,:,55))
  call loop_AV_Q(G1(:,:,:,55),wf(:,11),G1(:,:,:,56))
  call loop_A_Q(G1(:,:,:,56),Q(:,56),MT,G2(:,:,:,113))
  call loop_AZ_Q(G2(:,:,:,113),wf(:,10),G2(:,:,:,114),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,114),Q(:,63),MT,G3tensor(:,14))
  call loop_AS_Q(G1(:,:,:,55),wf(:,-2),G1(:,:,:,57),gH)
  call loop_A_Q(G1(:,:,:,57),Q(:,20),MT,G2(:,:,:,115))
  call loop_AV_Q(G2(:,:,:,115),wf(:,11),G2(:,:,:,116))
  call loop_A_Q(G2(:,:,:,116),Q(:,60),MT,G3(:,:,:,148))
  call loop_AV_Q(G3(:,:,:,148),wf(:,15),G3(:,:,:,149))
  call check_last_A_Q(l_switch,G3(:,:,:,149),Q(:,63),MT,G4tensor(:,64))
  call loop_AZ_Q(G3(:,:,:,148),wf(:,3),G3(:,:,:,150),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,150),Q(:,63),MT,G4tensor(:,65))
  call loop_AV_Q(G2(:,:,:,115),wf(:,-3),G2(:,:,:,117))
  call loop_A_Q(G2(:,:,:,117),Q(:,28),MT,G3(:,:,:,151))
  call loop_AV_Q(G3(:,:,:,151),wf(:,-5),G3(:,:,:,152))
  call loop_A_Q(G3(:,:,:,152),Q(:,60),MT,G4(:,:,:,79))
  call loop_AV_Q(G4(:,:,:,79),wf(:,15),G4(:,:,:,80))
  call check_last_A_Q(l_switch,G4(:,:,:,80),Q(:,63),MT,G5tensor(:,53))
  call loop_AZ_Q(G4(:,:,:,79),wf(:,3),G4(:,:,:,81),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,81),Q(:,63),MT,G5tensor(:,54))
  call loop_AV_Q(G1(:,:,:,55),wf(:,-3),G1(:,:,:,58))
  call loop_A_Q(G1(:,:,:,58),Q(:,24),MT,G2(:,:,:,118))
  call loop_AV_Q(G2(:,:,:,118),wf(:,-5),G2(:,:,:,119))
  call loop_A_Q(G2(:,:,:,119),Q(:,56),MT,G3(:,:,:,153))
  call loop_AZ_Q(G3(:,:,:,153),wf(:,10),G3(:,:,:,154),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,154),Q(:,63),MT,G4tensor(:,66))
  call loop_AS_Q(G2(:,:,:,118),wf(:,-2),G2(:,:,:,120),gH)
  call loop_A_Q(G2(:,:,:,120),Q(:,28),MT,G3(:,:,:,155))
  call loop_AV_Q(G3(:,:,:,155),wf(:,-5),G3(:,:,:,156))
  call loop_A_Q(G3(:,:,:,156),Q(:,60),MT,G4(:,:,:,82))
  call loop_AV_Q(G4(:,:,:,82),wf(:,15),G4(:,:,:,83))
  call check_last_A_Q(l_switch,G4(:,:,:,83),Q(:,63),MT,G5tensor(:,55))
  call loop_AZ_Q(G4(:,:,:,82),wf(:,3),G4(:,:,:,84),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,84),Q(:,63),MT,G5tensor(:,56))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,16),MB,G1(:,:,:,59))
  call loop_QV_A(G1(:,:,:,59),wf(:,11),G1(:,:,:,60))
  call loop_Q_A(G1(:,:,:,60),Q(:,56),MB,G2(:,:,:,121))
  call loop_QZ_A(G2(:,:,:,121),wf(:,10),G2(:,:,:,122),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,122),Q(:,63),MB,G3tensor(:,15))
  call loop_QS_A(G1(:,:,:,59),wf(:,-2),G1(:,:,:,61),gH)
  call loop_Q_A(G1(:,:,:,61),Q(:,20),MB,G2(:,:,:,123))
  call loop_QV_A(G2(:,:,:,123),wf(:,11),G2(:,:,:,124))
  call loop_Q_A(G2(:,:,:,124),Q(:,60),MB,G3(:,:,:,157))
  call loop_QV_A(G3(:,:,:,157),wf(:,15),G3(:,:,:,158))
  call check_last_Q_A(l_switch,G3(:,:,:,158),Q(:,63),MB,G4tensor(:,67))
  call loop_QZ_A(G3(:,:,:,157),wf(:,3),G3(:,:,:,159),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,159),Q(:,63),MB,G4tensor(:,68))
  call loop_QV_A(G2(:,:,:,123),wf(:,-3),G2(:,:,:,125))
  call loop_Q_A(G2(:,:,:,125),Q(:,28),MB,G3(:,:,:,160))
  call loop_QV_A(G3(:,:,:,160),wf(:,-5),G3(:,:,:,161))
  call loop_Q_A(G3(:,:,:,161),Q(:,60),MB,G4(:,:,:,85))
  call loop_QV_A(G4(:,:,:,85),wf(:,15),G4(:,:,:,86))
  call check_last_Q_A(l_switch,G4(:,:,:,86),Q(:,63),MB,G5tensor(:,57))
  call loop_QZ_A(G4(:,:,:,85),wf(:,3),G4(:,:,:,87),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,87),Q(:,63),MB,G5tensor(:,58))
  call loop_QV_A(G1(:,:,:,59),wf(:,-3),G1(:,:,:,62))
  call loop_Q_A(G1(:,:,:,62),Q(:,24),MB,G2(:,:,:,126))
  call loop_QV_A(G2(:,:,:,126),wf(:,-5),G2(:,:,:,127))
  call loop_Q_A(G2(:,:,:,127),Q(:,56),MB,G3(:,:,:,162))
  call loop_QZ_A(G3(:,:,:,162),wf(:,10),G3(:,:,:,163),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,163),Q(:,63),MB,G4tensor(:,69))
  call loop_QS_A(G2(:,:,:,126),wf(:,-2),G2(:,:,:,128),gH)
  call loop_Q_A(G2(:,:,:,128),Q(:,28),MB,G3(:,:,:,164))
  call loop_QV_A(G3(:,:,:,164),wf(:,-5),G3(:,:,:,165))
  call loop_Q_A(G3(:,:,:,165),Q(:,60),MB,G4(:,:,:,88))
  call loop_QV_A(G4(:,:,:,88),wf(:,15),G4(:,:,:,89))
  call check_last_Q_A(l_switch,G4(:,:,:,89),Q(:,63),MB,G5tensor(:,59))
  call loop_QZ_A(G4(:,:,:,88),wf(:,3),G4(:,:,:,90),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,90),Q(:,63),MB,G5tensor(:,60))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,17))
  call loop_A_Q(G0(:,:,:,17),Q(:,16),MB,G1(:,:,:,63))
  call loop_AV_Q(G1(:,:,:,63),wf(:,11),G1(:,:,:,64))
  call loop_A_Q(G1(:,:,:,64),Q(:,56),MB,G2(:,:,:,129))
  call loop_AZ_Q(G2(:,:,:,129),wf(:,10),G2(:,:,:,130),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,130),Q(:,63),MB,G3tensor(:,16))
  call loop_AS_Q(G1(:,:,:,63),wf(:,-2),G1(:,:,:,65),gH)
  call loop_A_Q(G1(:,:,:,65),Q(:,20),MB,G2(:,:,:,131))
  call loop_AV_Q(G2(:,:,:,131),wf(:,11),G2(:,:,:,132))
  call loop_A_Q(G2(:,:,:,132),Q(:,60),MB,G3(:,:,:,166))
  call loop_AV_Q(G3(:,:,:,166),wf(:,15),G3(:,:,:,167))
  call check_last_A_Q(l_switch,G3(:,:,:,167),Q(:,63),MB,G4tensor(:,70))
  call loop_AZ_Q(G3(:,:,:,166),wf(:,3),G3(:,:,:,168),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,168),Q(:,63),MB,G4tensor(:,71))
  call loop_AV_Q(G2(:,:,:,131),wf(:,-3),G2(:,:,:,133))
  call loop_A_Q(G2(:,:,:,133),Q(:,28),MB,G3(:,:,:,169))
  call loop_AV_Q(G3(:,:,:,169),wf(:,-5),G3(:,:,:,170))
  call loop_A_Q(G3(:,:,:,170),Q(:,60),MB,G4(:,:,:,91))
  call loop_AV_Q(G4(:,:,:,91),wf(:,15),G4(:,:,:,92))
  call check_last_A_Q(l_switch,G4(:,:,:,92),Q(:,63),MB,G5tensor(:,61))
  call loop_AZ_Q(G4(:,:,:,91),wf(:,3),G4(:,:,:,93),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,93),Q(:,63),MB,G5tensor(:,62))
  call loop_AV_Q(G1(:,:,:,63),wf(:,-3),G1(:,:,:,66))
  call loop_A_Q(G1(:,:,:,66),Q(:,24),MB,G2(:,:,:,134))
  call loop_AV_Q(G2(:,:,:,134),wf(:,-5),G2(:,:,:,135))
  call loop_A_Q(G2(:,:,:,135),Q(:,56),MB,G3(:,:,:,171))
  call loop_AZ_Q(G3(:,:,:,171),wf(:,10),G3(:,:,:,172),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,172),Q(:,63),MB,G4tensor(:,72))
  call loop_AS_Q(G2(:,:,:,134),wf(:,-2),G2(:,:,:,136),gH)
  call loop_A_Q(G2(:,:,:,136),Q(:,28),MB,G3(:,:,:,173))
  call loop_AV_Q(G3(:,:,:,173),wf(:,-5),G3(:,:,:,174))
  call loop_A_Q(G3(:,:,:,174),Q(:,60),MB,G4(:,:,:,94))
  call loop_AV_Q(G4(:,:,:,94),wf(:,15),G4(:,:,:,95))
  call check_last_A_Q(l_switch,G4(:,:,:,95),Q(:,63),MB,G5tensor(:,63))
  call loop_AZ_Q(G4(:,:,:,94),wf(:,3),G4(:,:,:,96),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,96),Q(:,63),MB,G5tensor(:,64))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,18))
  call loop_Q_A(G0(:,:,:,18),Q(:,8),ZERO,G1(:,:,:,67))
  call loop_QV_A(G1(:,:,:,67),wf(:,13),G1(:,:,:,68))
  call loop_Q_A(G1(:,:,:,68),Q(:,56),ZERO,G2(:,:,:,137))
  call loop_QZ_A(G2(:,:,:,137),wf(:,10),G2(:,:,:,138),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,138),Q(:,63),ZERO,G3tensor(:,17))
  call loop_QZ_A(G2(:,:,:,137),wf(:,10),G2(:,:,:,139),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,139),Q(:,63),ZERO,G3tensor(:,18))
  call loop_QV_A(G1(:,:,:,67),wf(:,-4),G1(:,:,:,69))
  call loop_Q_A(G1(:,:,:,69),Q(:,24),ZERO,G2(:,:,:,140))
  call loop_QV_A(G2(:,:,:,140),wf(:,-5),G2(:,:,:,141))
  call loop_Q_A(G2(:,:,:,141),Q(:,56),ZERO,G3(:,:,:,175))
  call loop_QZ_A(G3(:,:,:,175),wf(:,10),G3(:,:,:,176),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,176),Q(:,63),ZERO,G4tensor(:,73))
  call loop_QZ_A(G3(:,:,:,175),wf(:,10),G3(:,:,:,177),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,177),Q(:,63),ZERO,G4tensor(:,74))
  call loop_QV_A(G1(:,:,:,67),wf(:,-5),G1(:,:,:,70))
  call loop_Q_A(G1(:,:,:,70),Q(:,40),ZERO,G2(:,:,:,142))
  call loop_QV_A(G2(:,:,:,142),wf(:,-4),G2(:,:,:,143))
  call loop_Q_A(G2(:,:,:,143),Q(:,56),ZERO,G3(:,:,:,178))
  call loop_QZ_A(G3(:,:,:,178),wf(:,10),G3(:,:,:,179),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,179),Q(:,63),ZERO,G4tensor(:,75))
  call loop_QZ_A(G3(:,:,:,178),wf(:,10),G3(:,:,:,180),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,180),Q(:,63),ZERO,G4tensor(:,76))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,8),MT,G1(:,:,:,71))
  call loop_QV_A(G1(:,:,:,71),wf(:,13),G1(:,:,:,72))
  call loop_Q_A(G1(:,:,:,72),Q(:,56),MT,G2(:,:,:,144))
  call loop_QZ_A(G2(:,:,:,144),wf(:,10),G2(:,:,:,145),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,145),Q(:,63),MT,G3tensor(:,19))
  call loop_QS_A(G1(:,:,:,71),wf(:,-2),G1(:,:,:,73),gH)
  call loop_Q_A(G1(:,:,:,73),Q(:,12),MT,G2(:,:,:,146))
  call loop_QV_A(G2(:,:,:,146),wf(:,13),G2(:,:,:,147))
  call loop_Q_A(G2(:,:,:,147),Q(:,60),MT,G3(:,:,:,181))
  call loop_QV_A(G3(:,:,:,181),wf(:,15),G3(:,:,:,182))
  call check_last_Q_A(l_switch,G3(:,:,:,182),Q(:,63),MT,G4tensor(:,77))
  call loop_QZ_A(G3(:,:,:,181),wf(:,3),G3(:,:,:,183),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,183),Q(:,63),MT,G4tensor(:,78))
  call loop_QV_A(G2(:,:,:,146),wf(:,-4),G2(:,:,:,148))
  call loop_Q_A(G2(:,:,:,148),Q(:,28),MT,G3(:,:,:,184))
  call loop_QV_A(G3(:,:,:,184),wf(:,-5),G3(:,:,:,185))
  call loop_Q_A(G3(:,:,:,185),Q(:,60),MT,G4(:,:,:,97))
  call loop_QV_A(G4(:,:,:,97),wf(:,15),G4(:,:,:,98))
  call check_last_Q_A(l_switch,G4(:,:,:,98),Q(:,63),MT,G5tensor(:,65))
  call loop_QZ_A(G4(:,:,:,97),wf(:,3),G4(:,:,:,99),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,99),Q(:,63),MT,G5tensor(:,66))
  call loop_QV_A(G2(:,:,:,146),wf(:,-5),G2(:,:,:,149))
  call loop_Q_A(G2(:,:,:,149),Q(:,44),MT,G3(:,:,:,186))
  call loop_QV_A(G3(:,:,:,186),wf(:,-4),G3(:,:,:,187))
  call loop_Q_A(G3(:,:,:,187),Q(:,60),MT,G4(:,:,:,100))
  call loop_QV_A(G4(:,:,:,100),wf(:,15),G4(:,:,:,101))
  call check_last_Q_A(l_switch,G4(:,:,:,101),Q(:,63),MT,G5tensor(:,67))
  call loop_QZ_A(G4(:,:,:,100),wf(:,3),G4(:,:,:,102),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,102),Q(:,63),MT,G5tensor(:,68))
  call loop_QV_A(G1(:,:,:,71),wf(:,-4),G1(:,:,:,74))
  call loop_Q_A(G1(:,:,:,74),Q(:,24),MT,G2(:,:,:,150))
  call loop_QV_A(G2(:,:,:,150),wf(:,-5),G2(:,:,:,151))
  call loop_Q_A(G2(:,:,:,151),Q(:,56),MT,G3(:,:,:,188))
  call loop_QZ_A(G3(:,:,:,188),wf(:,10),G3(:,:,:,189),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,189),Q(:,63),MT,G4tensor(:,79))
  call loop_QS_A(G2(:,:,:,150),wf(:,-2),G2(:,:,:,152),gH)
  call loop_Q_A(G2(:,:,:,152),Q(:,28),MT,G3(:,:,:,190))
  call loop_QV_A(G3(:,:,:,190),wf(:,-5),G3(:,:,:,191))
  call loop_Q_A(G3(:,:,:,191),Q(:,60),MT,G4(:,:,:,103))
  call loop_QV_A(G4(:,:,:,103),wf(:,15),G4(:,:,:,104))
  call check_last_Q_A(l_switch,G4(:,:,:,104),Q(:,63),MT,G5tensor(:,69))
  call loop_QZ_A(G4(:,:,:,103),wf(:,3),G4(:,:,:,105),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,105),Q(:,63),MT,G5tensor(:,70))
  call loop_QV_A(G1(:,:,:,71),wf(:,-5),G1(:,:,:,75))
  call loop_Q_A(G1(:,:,:,75),Q(:,40),MT,G2(:,:,:,153))
  call loop_QV_A(G2(:,:,:,153),wf(:,-4),G2(:,:,:,154))
  call loop_Q_A(G2(:,:,:,154),Q(:,56),MT,G3(:,:,:,192))
  call loop_QZ_A(G3(:,:,:,192),wf(:,10),G3(:,:,:,193),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,193),Q(:,63),MT,G4tensor(:,80))
  call loop_QS_A(G2(:,:,:,153),wf(:,-2),G2(:,:,:,155),gH)
  call loop_Q_A(G2(:,:,:,155),Q(:,44),MT,G3(:,:,:,194))
  call loop_QV_A(G3(:,:,:,194),wf(:,-4),G3(:,:,:,195))
  call loop_Q_A(G3(:,:,:,195),Q(:,60),MT,G4(:,:,:,106))
  call loop_QV_A(G4(:,:,:,106),wf(:,15),G4(:,:,:,107))
  call check_last_Q_A(l_switch,G4(:,:,:,107),Q(:,63),MT,G5tensor(:,71))
  call loop_QZ_A(G4(:,:,:,106),wf(:,3),G4(:,:,:,108),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,108),Q(:,63),MT,G5tensor(:,72))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,20))
  call loop_A_Q(G0(:,:,:,20),Q(:,8),ZERO,G1(:,:,:,76))
  call loop_AV_Q(G1(:,:,:,76),wf(:,13),G1(:,:,:,77))
  call loop_A_Q(G1(:,:,:,77),Q(:,56),ZERO,G2(:,:,:,156))
  call loop_AZ_Q(G2(:,:,:,156),wf(:,10),G2(:,:,:,157),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,157),Q(:,63),ZERO,G3tensor(:,20))
  call loop_AZ_Q(G2(:,:,:,156),wf(:,10),G2(:,:,:,158),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,158),Q(:,63),ZERO,G3tensor(:,21))
  call loop_AV_Q(G1(:,:,:,76),wf(:,-4),G1(:,:,:,78))
  call loop_A_Q(G1(:,:,:,78),Q(:,24),ZERO,G2(:,:,:,159))
  call loop_AV_Q(G2(:,:,:,159),wf(:,-5),G2(:,:,:,160))
  call loop_A_Q(G2(:,:,:,160),Q(:,56),ZERO,G3(:,:,:,196))
  call loop_AZ_Q(G3(:,:,:,196),wf(:,10),G3(:,:,:,197),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,197),Q(:,63),ZERO,G4tensor(:,81))
  call loop_AZ_Q(G3(:,:,:,196),wf(:,10),G3(:,:,:,198),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,198),Q(:,63),ZERO,G4tensor(:,82))
  call loop_AV_Q(G1(:,:,:,76),wf(:,-5),G1(:,:,:,79))
  call loop_A_Q(G1(:,:,:,79),Q(:,40),ZERO,G2(:,:,:,161))
  call loop_AV_Q(G2(:,:,:,161),wf(:,-4),G2(:,:,:,162))
  call loop_A_Q(G2(:,:,:,162),Q(:,56),ZERO,G3(:,:,:,199))
  call loop_AZ_Q(G3(:,:,:,199),wf(:,10),G3(:,:,:,200),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,200),Q(:,63),ZERO,G4tensor(:,83))
  call loop_AZ_Q(G3(:,:,:,199),wf(:,10),G3(:,:,:,201),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,201),Q(:,63),ZERO,G4tensor(:,84))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,21))
  call loop_A_Q(G0(:,:,:,21),Q(:,8),MT,G1(:,:,:,80))
  call loop_AV_Q(G1(:,:,:,80),wf(:,13),G1(:,:,:,81))
  call loop_A_Q(G1(:,:,:,81),Q(:,56),MT,G2(:,:,:,163))
  call loop_AZ_Q(G2(:,:,:,163),wf(:,10),G2(:,:,:,164),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,164),Q(:,63),MT,G3tensor(:,22))
  call loop_AS_Q(G1(:,:,:,80),wf(:,-2),G1(:,:,:,82),gH)
  call loop_A_Q(G1(:,:,:,82),Q(:,12),MT,G2(:,:,:,165))
  call loop_AV_Q(G2(:,:,:,165),wf(:,13),G2(:,:,:,166))
  call loop_A_Q(G2(:,:,:,166),Q(:,60),MT,G3(:,:,:,202))
  call loop_AV_Q(G3(:,:,:,202),wf(:,15),G3(:,:,:,203))
  call check_last_A_Q(l_switch,G3(:,:,:,203),Q(:,63),MT,G4tensor(:,85))
  call loop_AZ_Q(G3(:,:,:,202),wf(:,3),G3(:,:,:,204),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,204),Q(:,63),MT,G4tensor(:,86))
  call loop_AV_Q(G2(:,:,:,165),wf(:,-4),G2(:,:,:,167))
  call loop_A_Q(G2(:,:,:,167),Q(:,28),MT,G3(:,:,:,205))
  call loop_AV_Q(G3(:,:,:,205),wf(:,-5),G3(:,:,:,206))
  call loop_A_Q(G3(:,:,:,206),Q(:,60),MT,G4(:,:,:,109))
  call loop_AV_Q(G4(:,:,:,109),wf(:,15),G4(:,:,:,110))
  call check_last_A_Q(l_switch,G4(:,:,:,110),Q(:,63),MT,G5tensor(:,73))
  call loop_AZ_Q(G4(:,:,:,109),wf(:,3),G4(:,:,:,111),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,111),Q(:,63),MT,G5tensor(:,74))
  call loop_AV_Q(G2(:,:,:,165),wf(:,-5),G2(:,:,:,168))
  call loop_A_Q(G2(:,:,:,168),Q(:,44),MT,G3(:,:,:,207))
  call loop_AV_Q(G3(:,:,:,207),wf(:,-4),G3(:,:,:,208))
  call loop_A_Q(G3(:,:,:,208),Q(:,60),MT,G4(:,:,:,112))
  call loop_AV_Q(G4(:,:,:,112),wf(:,15),G4(:,:,:,113))
  call check_last_A_Q(l_switch,G4(:,:,:,113),Q(:,63),MT,G5tensor(:,75))
  call loop_AZ_Q(G4(:,:,:,112),wf(:,3),G4(:,:,:,114),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,114),Q(:,63),MT,G5tensor(:,76))
  call loop_AV_Q(G1(:,:,:,80),wf(:,-4),G1(:,:,:,83))
  call loop_A_Q(G1(:,:,:,83),Q(:,24),MT,G2(:,:,:,169))
  call loop_AV_Q(G2(:,:,:,169),wf(:,-5),G2(:,:,:,170))
  call loop_A_Q(G2(:,:,:,170),Q(:,56),MT,G3(:,:,:,209))
  call loop_AZ_Q(G3(:,:,:,209),wf(:,10),G3(:,:,:,210),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,210),Q(:,63),MT,G4tensor(:,87))
  call loop_AS_Q(G2(:,:,:,169),wf(:,-2),G2(:,:,:,171),gH)
  call loop_A_Q(G2(:,:,:,171),Q(:,28),MT,G3(:,:,:,211))
  call loop_AV_Q(G3(:,:,:,211),wf(:,-5),G3(:,:,:,212))
  call loop_A_Q(G3(:,:,:,212),Q(:,60),MT,G4(:,:,:,115))
  call loop_AV_Q(G4(:,:,:,115),wf(:,15),G4(:,:,:,116))
  call check_last_A_Q(l_switch,G4(:,:,:,116),Q(:,63),MT,G5tensor(:,77))
  call loop_AZ_Q(G4(:,:,:,115),wf(:,3),G4(:,:,:,117),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,117),Q(:,63),MT,G5tensor(:,78))
  call loop_AV_Q(G1(:,:,:,80),wf(:,-5),G1(:,:,:,84))
  call loop_A_Q(G1(:,:,:,84),Q(:,40),MT,G2(:,:,:,172))
  call loop_AV_Q(G2(:,:,:,172),wf(:,-4),G2(:,:,:,173))
  call loop_A_Q(G2(:,:,:,173),Q(:,56),MT,G3(:,:,:,213))
  call loop_AZ_Q(G3(:,:,:,213),wf(:,10),G3(:,:,:,214),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,214),Q(:,63),MT,G4tensor(:,88))
  call loop_AS_Q(G2(:,:,:,172),wf(:,-2),G2(:,:,:,174),gH)
  call loop_A_Q(G2(:,:,:,174),Q(:,44),MT,G3(:,:,:,215))
  call loop_AV_Q(G3(:,:,:,215),wf(:,-4),G3(:,:,:,216))
  call loop_A_Q(G3(:,:,:,216),Q(:,60),MT,G4(:,:,:,118))
  call loop_AV_Q(G4(:,:,:,118),wf(:,15),G4(:,:,:,119))
  call check_last_A_Q(l_switch,G4(:,:,:,119),Q(:,63),MT,G5tensor(:,79))
  call loop_AZ_Q(G4(:,:,:,118),wf(:,3),G4(:,:,:,120),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,120),Q(:,63),MT,G5tensor(:,80))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,8),MB,G1(:,:,:,85))
  call loop_QV_A(G1(:,:,:,85),wf(:,13),G1(:,:,:,86))
  call loop_Q_A(G1(:,:,:,86),Q(:,56),MB,G2(:,:,:,175))
  call loop_QZ_A(G2(:,:,:,175),wf(:,10),G2(:,:,:,176),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,176),Q(:,63),MB,G3tensor(:,23))
  call loop_QS_A(G1(:,:,:,85),wf(:,-2),G1(:,:,:,87),gH)
  call loop_Q_A(G1(:,:,:,87),Q(:,12),MB,G2(:,:,:,177))
  call loop_QV_A(G2(:,:,:,177),wf(:,13),G2(:,:,:,178))
  call loop_Q_A(G2(:,:,:,178),Q(:,60),MB,G3(:,:,:,217))
  call loop_QV_A(G3(:,:,:,217),wf(:,15),G3(:,:,:,218))
  call check_last_Q_A(l_switch,G3(:,:,:,218),Q(:,63),MB,G4tensor(:,89))
  call loop_QZ_A(G3(:,:,:,217),wf(:,3),G3(:,:,:,219),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,219),Q(:,63),MB,G4tensor(:,90))
  call loop_QV_A(G2(:,:,:,177),wf(:,-4),G2(:,:,:,179))
  call loop_Q_A(G2(:,:,:,179),Q(:,28),MB,G3(:,:,:,220))
  call loop_QV_A(G3(:,:,:,220),wf(:,-5),G3(:,:,:,221))
  call loop_Q_A(G3(:,:,:,221),Q(:,60),MB,G4(:,:,:,121))
  call loop_QV_A(G4(:,:,:,121),wf(:,15),G4(:,:,:,122))
  call check_last_Q_A(l_switch,G4(:,:,:,122),Q(:,63),MB,G5tensor(:,81))
  call loop_QZ_A(G4(:,:,:,121),wf(:,3),G4(:,:,:,123),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,123),Q(:,63),MB,G5tensor(:,82))
  call loop_QV_A(G2(:,:,:,177),wf(:,-5),G2(:,:,:,180))
  call loop_Q_A(G2(:,:,:,180),Q(:,44),MB,G3(:,:,:,222))
  call loop_QV_A(G3(:,:,:,222),wf(:,-4),G3(:,:,:,223))
  call loop_Q_A(G3(:,:,:,223),Q(:,60),MB,G4(:,:,:,124))
  call loop_QV_A(G4(:,:,:,124),wf(:,15),G4(:,:,:,125))
  call check_last_Q_A(l_switch,G4(:,:,:,125),Q(:,63),MB,G5tensor(:,83))
  call loop_QZ_A(G4(:,:,:,124),wf(:,3),G4(:,:,:,126),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,126),Q(:,63),MB,G5tensor(:,84))
  call loop_QV_A(G1(:,:,:,85),wf(:,-4),G1(:,:,:,88))
  call loop_Q_A(G1(:,:,:,88),Q(:,24),MB,G2(:,:,:,181))
  call loop_QV_A(G2(:,:,:,181),wf(:,-5),G2(:,:,:,182))
  call loop_Q_A(G2(:,:,:,182),Q(:,56),MB,G3(:,:,:,224))
  call loop_QZ_A(G3(:,:,:,224),wf(:,10),G3(:,:,:,225),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,225),Q(:,63),MB,G4tensor(:,91))
  call loop_QS_A(G2(:,:,:,181),wf(:,-2),G2(:,:,:,183),gH)
  call loop_Q_A(G2(:,:,:,183),Q(:,28),MB,G3(:,:,:,226))
  call loop_QV_A(G3(:,:,:,226),wf(:,-5),G3(:,:,:,227))
  call loop_Q_A(G3(:,:,:,227),Q(:,60),MB,G4(:,:,:,127))
  call loop_QV_A(G4(:,:,:,127),wf(:,15),G4(:,:,:,128))
  call check_last_Q_A(l_switch,G4(:,:,:,128),Q(:,63),MB,G5tensor(:,85))
  call loop_QZ_A(G4(:,:,:,127),wf(:,3),G4(:,:,:,129),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,129),Q(:,63),MB,G5tensor(:,86))
  call loop_QV_A(G1(:,:,:,85),wf(:,-5),G1(:,:,:,89))
  call loop_Q_A(G1(:,:,:,89),Q(:,40),MB,G2(:,:,:,184))
  call loop_QV_A(G2(:,:,:,184),wf(:,-4),G2(:,:,:,185))
  call loop_Q_A(G2(:,:,:,185),Q(:,56),MB,G3(:,:,:,228))
  call loop_QZ_A(G3(:,:,:,228),wf(:,10),G3(:,:,:,229),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,229),Q(:,63),MB,G4tensor(:,92))
  call loop_QS_A(G2(:,:,:,184),wf(:,-2),G2(:,:,:,186),gH)
  call loop_Q_A(G2(:,:,:,186),Q(:,44),MB,G3(:,:,:,230))
  call loop_QV_A(G3(:,:,:,230),wf(:,-4),G3(:,:,:,231))
  call loop_Q_A(G3(:,:,:,231),Q(:,60),MB,G4(:,:,:,130))
  call loop_QV_A(G4(:,:,:,130),wf(:,15),G4(:,:,:,131))
  call check_last_Q_A(l_switch,G4(:,:,:,131),Q(:,63),MB,G5tensor(:,87))
  call loop_QZ_A(G4(:,:,:,130),wf(:,3),G4(:,:,:,132),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,132),Q(:,63),MB,G5tensor(:,88))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,23))
  call loop_A_Q(G0(:,:,:,23),Q(:,8),MB,G1(:,:,:,90))
  call loop_AV_Q(G1(:,:,:,90),wf(:,13),G1(:,:,:,91))
  call loop_A_Q(G1(:,:,:,91),Q(:,56),MB,G2(:,:,:,187))
  call loop_AZ_Q(G2(:,:,:,187),wf(:,10),G2(:,:,:,188),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,188),Q(:,63),MB,G3tensor(:,24))
  call loop_AS_Q(G1(:,:,:,90),wf(:,-2),G1(:,:,:,92),gH)
  call loop_A_Q(G1(:,:,:,92),Q(:,12),MB,G2(:,:,:,189))
  call loop_AV_Q(G2(:,:,:,189),wf(:,13),G2(:,:,:,190))
  call loop_A_Q(G2(:,:,:,190),Q(:,60),MB,G3(:,:,:,232))
  call loop_AV_Q(G3(:,:,:,232),wf(:,15),G3(:,:,:,233))
  call check_last_A_Q(l_switch,G3(:,:,:,233),Q(:,63),MB,G4tensor(:,93))
  call loop_AZ_Q(G3(:,:,:,232),wf(:,3),G3(:,:,:,234),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,234),Q(:,63),MB,G4tensor(:,94))
  call loop_AV_Q(G2(:,:,:,189),wf(:,-4),G2(:,:,:,191))
  call loop_A_Q(G2(:,:,:,191),Q(:,28),MB,G3(:,:,:,235))
  call loop_AV_Q(G3(:,:,:,235),wf(:,-5),G3(:,:,:,236))
  call loop_A_Q(G3(:,:,:,236),Q(:,60),MB,G4(:,:,:,133))
  call loop_AV_Q(G4(:,:,:,133),wf(:,15),G4(:,:,:,134))
  call check_last_A_Q(l_switch,G4(:,:,:,134),Q(:,63),MB,G5tensor(:,89))
  call loop_AZ_Q(G4(:,:,:,133),wf(:,3),G4(:,:,:,135),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,135),Q(:,63),MB,G5tensor(:,90))
  call loop_AV_Q(G2(:,:,:,189),wf(:,-5),G2(:,:,:,192))
  call loop_A_Q(G2(:,:,:,192),Q(:,44),MB,G3(:,:,:,237))
  call loop_AV_Q(G3(:,:,:,237),wf(:,-4),G3(:,:,:,238))
  call loop_A_Q(G3(:,:,:,238),Q(:,60),MB,G4(:,:,:,136))
  call loop_AV_Q(G4(:,:,:,136),wf(:,15),G4(:,:,:,137))
  call check_last_A_Q(l_switch,G4(:,:,:,137),Q(:,63),MB,G5tensor(:,91))
  call loop_AZ_Q(G4(:,:,:,136),wf(:,3),G4(:,:,:,138),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,138),Q(:,63),MB,G5tensor(:,92))
  call loop_AV_Q(G1(:,:,:,90),wf(:,-4),G1(:,:,:,93))
  call loop_A_Q(G1(:,:,:,93),Q(:,24),MB,G2(:,:,:,193))
  call loop_AV_Q(G2(:,:,:,193),wf(:,-5),G2(:,:,:,194))
  call loop_A_Q(G2(:,:,:,194),Q(:,56),MB,G3(:,:,:,239))
  call loop_AZ_Q(G3(:,:,:,239),wf(:,10),G3(:,:,:,240),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,240),Q(:,63),MB,G4tensor(:,95))
  call loop_AS_Q(G2(:,:,:,193),wf(:,-2),G2(:,:,:,195),gH)
  call loop_A_Q(G2(:,:,:,195),Q(:,28),MB,G3(:,:,:,241))
  call loop_AV_Q(G3(:,:,:,241),wf(:,-5),G3(:,:,:,242))
  call loop_A_Q(G3(:,:,:,242),Q(:,60),MB,G4(:,:,:,139))
  call loop_AV_Q(G4(:,:,:,139),wf(:,15),G4(:,:,:,140))
  call check_last_A_Q(l_switch,G4(:,:,:,140),Q(:,63),MB,G5tensor(:,93))
  call loop_AZ_Q(G4(:,:,:,139),wf(:,3),G4(:,:,:,141),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,141),Q(:,63),MB,G5tensor(:,94))
  call loop_AV_Q(G1(:,:,:,90),wf(:,-5),G1(:,:,:,94))
  call loop_A_Q(G1(:,:,:,94),Q(:,40),MB,G2(:,:,:,196))
  call loop_AV_Q(G2(:,:,:,196),wf(:,-4),G2(:,:,:,197))
  call loop_A_Q(G2(:,:,:,197),Q(:,56),MB,G3(:,:,:,243))
  call loop_AZ_Q(G3(:,:,:,243),wf(:,10),G3(:,:,:,244),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,244),Q(:,63),MB,G4tensor(:,96))
  call loop_AS_Q(G2(:,:,:,196),wf(:,-2),G2(:,:,:,198),gH)
  call loop_A_Q(G2(:,:,:,198),Q(:,44),MB,G3(:,:,:,245))
  call loop_AV_Q(G3(:,:,:,245),wf(:,-4),G3(:,:,:,246))
  call loop_A_Q(G3(:,:,:,246),Q(:,60),MB,G4(:,:,:,142))
  call loop_AV_Q(G4(:,:,:,142),wf(:,15),G4(:,:,:,143))
  call check_last_A_Q(l_switch,G4(:,:,:,143),Q(:,63),MB,G5tensor(:,95))
  call loop_AZ_Q(G4(:,:,:,142),wf(:,3),G4(:,:,:,144),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,144),Q(:,63),MB,G5tensor(:,96))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (CI*f(4) * den(7)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,1),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(4)) * den(7)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(3) * den(7)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,3),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(3)) * den(7)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,3),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(4) * den(7)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,4),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(4)) * den(7)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(3) * den(7)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,6),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(3)) * den(7)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,6),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(4) * den(7)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,2),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(4)) * den(7)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(3) * den(7)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,7),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(3)) * den(7)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,7),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(4) * den(7)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,5),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(4)) * den(7)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(3) * den(7)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,8),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(3)) * den(7)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,8),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(11)) * den(13)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,9),T4sum(1:70,1))
  M(2) = M(2) + (CI*f(11) * den(13)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,9),T4sum(1:70,1))
  M(1) = M(1) + (-(CI*f(11)) * den(13)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,21),T4sum(1:70,1))
  M(2) = M(2) + (CI*f(11) * den(13)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,21),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(7) * den(13)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,33),T4sum(1:70,2))
  M(2) = M(2) + (-(CI*f(7)) * den(13)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,33),T4sum(1:70,2))
  M(1) = M(1) + (CI*f(7) * den(13)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,45),T4sum(1:70,2))
  M(2) = M(2) + (-(CI*f(7)) * den(13)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,45),T4sum(1:70,2))
  M(1) = M(1) + (CI*f(12) * den(14)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,10),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(12)) * den(14)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,10),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(12) * den(14)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,22),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(12)) * den(14)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,22),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(8) * den(14)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,34),T4sum(1:70,2))
  M(2) = M(2) + (-(CI*f(8)) * den(14)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,34),T4sum(1:70,2))
  M(1) = M(1) + (CI*f(8) * den(14)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,46),T4sum(1:70,2))
  M(2) = M(2) + (-(CI*f(8)) * den(14)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,46),T4sum(1:70,2))
  M(1) = M(1) + (-(CI*f(11)) * den(13)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,1),T4sum(1:70,3))
  M(2) = M(2) + (CI*f(11) * den(13)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,1),T4sum(1:70,3))
  M(1) = M(1) + (-(CI*f(11)) * den(13)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,3),T4sum(1:70,3))
  M(2) = M(2) + (CI*f(11) * den(13)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,3),T4sum(1:70,3))
  M(1) = M(1) + (CI*f(7) * den(13)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,5),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(7)) * den(13)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,5),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(7) * den(13)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,7),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(7)) * den(13)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,7),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(12) * den(14)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,2),T4sum(1:70,3))
  M(2) = M(2) + (-(CI*f(12)) * den(14)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,2),T4sum(1:70,3))
  M(1) = M(1) + (CI*f(12) * den(14)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,4),T4sum(1:70,3))
  M(2) = M(2) + (-(CI*f(12)) * den(14)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,4),T4sum(1:70,3))
  M(1) = M(1) + (CI*f(8) * den(14)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,6),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(8)) * den(14)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,6),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(8) * den(14)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,8),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(8)) * den(14)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,8),T4sum(1:70,4))
  M(1) = M(1) + (-(CI*f(11)) * den(13)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,23),T4sum(1:70,5))
  M(2) = M(2) + (CI*f(11) * den(13)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,23),T4sum(1:70,5))
  M(1) = M(1) + (-(CI*f(11)) * den(13)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,11),T4sum(1:70,5))
  M(2) = M(2) + (CI*f(11) * den(13)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,11),T4sum(1:70,5))
  M(1) = M(1) + (CI*f(7) * den(13)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,47),T4sum(1:70,6))
  M(2) = M(2) + (-(CI*f(7)) * den(13)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,47),T4sum(1:70,6))
  M(1) = M(1) + (CI*f(7) * den(13)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,35),T4sum(1:70,6))
  M(2) = M(2) + (-(CI*f(7)) * den(13)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,35),T4sum(1:70,6))
  M(1) = M(1) + (CI*f(12) * den(14)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,24),T4sum(1:70,5))
  M(2) = M(2) + (-(CI*f(12)) * den(14)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,24),T4sum(1:70,5))
  M(1) = M(1) + (CI*f(12) * den(14)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,12),T4sum(1:70,5))
  M(2) = M(2) + (-(CI*f(12)) * den(14)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,12),T4sum(1:70,5))
  M(1) = M(1) + (CI*f(8) * den(14)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,48),T4sum(1:70,6))
  M(2) = M(2) + (-(CI*f(8)) * den(14)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,48),T4sum(1:70,6))
  M(1) = M(1) + (CI*f(8) * den(14)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,36),T4sum(1:70,6))
  M(2) = M(2) + (-(CI*f(8)) * den(14)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,36),T4sum(1:70,6))
  M(1) = M(1) + (-(CI*f(4)) * den(9)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,9),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(4) * den(9)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,9),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(3)) * den(9)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,11),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(3) * den(9)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,11),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(4)) * den(9)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,12),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(4) * den(9)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,12),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(3)) * den(9)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,14),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(3) * den(9)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,14),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(4)) * den(9)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,10),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(4) * den(9)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,10),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(3)) * den(9)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,15),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(3) * den(9)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,15),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(4)) * den(9)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,13),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(4) * den(9)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,13),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(3)) * den(9)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,16),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(3) * den(9)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,16),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(11) * den(15)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,13),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(11)) * den(15)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,13),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(11) * den(15)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,25),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(11)) * den(15)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,25),T4sum(1:70,7))
  M(1) = M(1) + (-(CI*f(7)) * den(15)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,37),T4sum(1:70,8))
  M(2) = M(2) + (CI*f(7) * den(15)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,37),T4sum(1:70,8))
  M(1) = M(1) + (-(CI*f(7)) * den(15)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,49),T4sum(1:70,8))
  M(2) = M(2) + (CI*f(7) * den(15)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,49),T4sum(1:70,8))
  M(1) = M(1) + (-(CI*f(12)) * den(16)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,14),T4sum(1:70,7))
  M(2) = M(2) + (CI*f(12) * den(16)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,14),T4sum(1:70,7))
  M(1) = M(1) + (-(CI*f(12)) * den(16)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,26),T4sum(1:70,7))
  M(2) = M(2) + (CI*f(12) * den(16)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,26),T4sum(1:70,7))
  M(1) = M(1) + (-(CI*f(8)) * den(16)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,38),T4sum(1:70,8))
  M(2) = M(2) + (CI*f(8) * den(16)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,38),T4sum(1:70,8))
  M(1) = M(1) + (-(CI*f(8)) * den(16)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,50),T4sum(1:70,8))
  M(2) = M(2) + (CI*f(8) * den(16)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,50),T4sum(1:70,8))
  M(1) = M(1) + (CI*f(11) * den(15)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,59),T4sum(1:70,9))
  M(2) = M(2) + (-(CI*f(11)) * den(15)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,59),T4sum(1:70,9))
  M(1) = M(1) + (CI*f(11) * den(15)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,64),T4sum(1:70,9))
  M(2) = M(2) + (-(CI*f(11)) * den(15)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,64),T4sum(1:70,9))
  M(1) = M(1) + (-(CI*f(7)) * den(15)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,67),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(7) * den(15)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,67),T4sum(1:70,10))
  M(1) = M(1) + (-(CI*f(7)) * den(15)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,70),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(7) * den(15)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,70),T4sum(1:70,10))
  M(1) = M(1) + (-(CI*f(12)) * den(16)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,60),T4sum(1:70,9))
  M(2) = M(2) + (CI*f(12) * den(16)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,60),T4sum(1:70,9))
  M(1) = M(1) + (-(CI*f(12)) * den(16)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,65),T4sum(1:70,9))
  M(2) = M(2) + (CI*f(12) * den(16)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,65),T4sum(1:70,9))
  M(1) = M(1) + (-(CI*f(8)) * den(16)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,68),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(8) * den(16)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,68),T4sum(1:70,10))
  M(1) = M(1) + (-(CI*f(8)) * den(16)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,71),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(8) * den(16)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,71),T4sum(1:70,10))
  M(1) = M(1) + (CI*f(11) * den(15)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,27),T4sum(1:70,11))
  M(2) = M(2) + (-(CI*f(11)) * den(15)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,27),T4sum(1:70,11))
  M(1) = M(1) + (CI*f(11) * den(15)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,15),T4sum(1:70,11))
  M(2) = M(2) + (-(CI*f(11)) * den(15)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,15),T4sum(1:70,11))
  M(1) = M(1) + (-(CI*f(7)) * den(15)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,51),T4sum(1:70,12))
  M(2) = M(2) + (CI*f(7) * den(15)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,51),T4sum(1:70,12))
  M(1) = M(1) + (-(CI*f(7)) * den(15)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,39),T4sum(1:70,12))
  M(2) = M(2) + (CI*f(7) * den(15)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,39),T4sum(1:70,12))
  M(1) = M(1) + (-(CI*f(12)) * den(16)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,28),T4sum(1:70,11))
  M(2) = M(2) + (CI*f(12) * den(16)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,28),T4sum(1:70,11))
  M(1) = M(1) + (-(CI*f(12)) * den(16)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,16),T4sum(1:70,11))
  M(2) = M(2) + (CI*f(12) * den(16)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,16),T4sum(1:70,11))
  M(1) = M(1) + (-(CI*f(8)) * den(16)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,52),T4sum(1:70,12))
  M(2) = M(2) + (CI*f(8) * den(16)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,52),T4sum(1:70,12))
  M(1) = M(1) + (-(CI*f(8)) * den(16)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,40),T4sum(1:70,12))
  M(2) = M(2) + (CI*f(8) * den(16)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,40),T4sum(1:70,12))
  M(1) = M(1) + (CI*f(4) * den(11)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,17),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(4)) * den(11)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,17),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(3) * den(11)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,19),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(3)) * den(11)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,19),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(4) * den(11)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,20),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(4)) * den(11)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,20),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(3) * den(11)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,22),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(3)) * den(11)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,22),T3sum(1:35,8))
  M(1) = M(1) + (CI*f(4) * den(11)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,18),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(4)) * den(11)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,18),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(3) * den(11)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,23),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(3)) * den(11)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,23),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(4) * den(11)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,21),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(4)) * den(11)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,21),T3sum(1:35,7))
  M(1) = M(1) + (CI*f(3) * den(11)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,24),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(3)) * den(11)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,24),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(11)) * den(17)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,17),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(11) * den(17)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,17),T4sum(1:70,13))
  M(1) = M(1) + (-(CI*f(11)) * den(17)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,29),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(11) * den(17)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,29),T4sum(1:70,13))
  M(1) = M(1) + (CI*f(7) * den(17)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,41),T4sum(1:70,14))
  M(2) = M(2) + (-(CI*f(7)) * den(17)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,41),T4sum(1:70,14))
  M(1) = M(1) + (CI*f(7) * den(17)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,53),T4sum(1:70,14))
  M(2) = M(2) + (-(CI*f(7)) * den(17)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,53),T4sum(1:70,14))
  M(1) = M(1) + (CI*f(12) * den(18)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,18),T4sum(1:70,13))
  M(2) = M(2) + (-(CI*f(12)) * den(18)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,18),T4sum(1:70,13))
  M(1) = M(1) + (CI*f(12) * den(18)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,30),T4sum(1:70,13))
  M(2) = M(2) + (-(CI*f(12)) * den(18)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,30),T4sum(1:70,13))
  M(1) = M(1) + (CI*f(8) * den(18)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,42),T4sum(1:70,14))
  M(2) = M(2) + (-(CI*f(8)) * den(18)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,42),T4sum(1:70,14))
  M(1) = M(1) + (CI*f(8) * den(18)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,54),T4sum(1:70,14))
  M(2) = M(2) + (-(CI*f(8)) * den(18)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,54),T4sum(1:70,14))
  M(1) = M(1) + (-(CI*f(11)) * den(17)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,77),T4sum(1:70,15))
  M(2) = M(2) + (CI*f(11) * den(17)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,77),T4sum(1:70,15))
  M(1) = M(1) + (-(CI*f(11)) * den(17)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,85),T4sum(1:70,15))
  M(2) = M(2) + (CI*f(11) * den(17)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,85),T4sum(1:70,15))
  M(1) = M(1) + (CI*f(7) * den(17)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,89),T4sum(1:70,16))
  M(2) = M(2) + (-(CI*f(7)) * den(17)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,89),T4sum(1:70,16))
  M(1) = M(1) + (CI*f(7) * den(17)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,93),T4sum(1:70,16))
  M(2) = M(2) + (-(CI*f(7)) * den(17)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,93),T4sum(1:70,16))
  M(1) = M(1) + (CI*f(12) * den(18)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,78),T4sum(1:70,15))
  M(2) = M(2) + (-(CI*f(12)) * den(18)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,78),T4sum(1:70,15))
  M(1) = M(1) + (CI*f(12) * den(18)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,86),T4sum(1:70,15))
  M(2) = M(2) + (-(CI*f(12)) * den(18)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,86),T4sum(1:70,15))
  M(1) = M(1) + (CI*f(8) * den(18)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,90),T4sum(1:70,16))
  M(2) = M(2) + (-(CI*f(8)) * den(18)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,90),T4sum(1:70,16))
  M(1) = M(1) + (CI*f(8) * den(18)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,94),T4sum(1:70,16))
  M(2) = M(2) + (-(CI*f(8)) * den(18)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,94),T4sum(1:70,16))
  M(1) = M(1) + (-(CI*f(11)) * den(17)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,31),T4sum(1:70,17))
  M(2) = M(2) + (CI*f(11) * den(17)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,31),T4sum(1:70,17))
  M(1) = M(1) + (-(CI*f(11)) * den(17)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,19),T4sum(1:70,17))
  M(2) = M(2) + (CI*f(11) * den(17)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,19),T4sum(1:70,17))
  M(1) = M(1) + (CI*f(7) * den(17)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,55),T4sum(1:70,18))
  M(2) = M(2) + (-(CI*f(7)) * den(17)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,55),T4sum(1:70,18))
  M(1) = M(1) + (CI*f(7) * den(17)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,43),T4sum(1:70,18))
  M(2) = M(2) + (-(CI*f(7)) * den(17)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,43),T4sum(1:70,18))
  M(1) = M(1) + (CI*f(12) * den(18)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,32),T4sum(1:70,17))
  M(2) = M(2) + (-(CI*f(12)) * den(18)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,32),T4sum(1:70,17))
  M(1) = M(1) + (CI*f(12) * den(18)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,20),T4sum(1:70,17))
  M(2) = M(2) + (-(CI*f(12)) * den(18)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,20),T4sum(1:70,17))
  M(1) = M(1) + (CI*f(8) * den(18)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,56),T4sum(1:70,18))
  M(2) = M(2) + (-(CI*f(8)) * den(18)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,56),T4sum(1:70,18))
  M(1) = M(1) + (CI*f(8) * den(18)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,44),T4sum(1:70,18))
  M(2) = M(2) + (-(CI*f(8)) * den(18)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,44),T4sum(1:70,18))
  M(1) = M(1) + (-f(6) * den(6)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,57),T4sum(1:70,19))
  M(1) = M(1) + (-f(5) * den(6)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,61),T4sum(1:70,20))
  M(2) = M(2) + (-f(6) * den(6)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,62),T4sum(1:70,19))
  M(2) = M(2) + (-f(5) * den(6)) * TI2_call(4,momenta_14,masses2_5,G4tensor(:,66),T4sum(1:70,20))
  M(1) = M(1) + (-f(6) * den(6)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,58),T4sum(1:70,19))
  M(1) = M(1) + (-f(5) * den(6)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,69),T4sum(1:70,21))
  M(2) = M(2) + (-f(6) * den(6)) * TI2_call(4,momenta_14,masses2_6,G4tensor(:,63),T4sum(1:70,19))
  M(2) = M(2) + (-f(5) * den(6)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,72),T4sum(1:70,21))
  M(1) = M(1) + (-f(6) * den(6)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,81),T4sum(1:70,22))
  M(1) = M(1) + (-f(5) * den(6)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,87),T4sum(1:70,23))
  M(2) = M(2) + (-f(6) * den(6)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,73),T4sum(1:70,22))
  M(2) = M(2) + (-f(5) * den(6)) * TI2_call(4,momenta_11,masses2_5,G4tensor(:,79),T4sum(1:70,23))
  M(1) = M(1) + (-f(6) * den(6)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,82),T4sum(1:70,22))
  M(1) = M(1) + (-f(5) * den(6)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,95),T4sum(1:70,24))
  M(2) = M(2) + (-f(6) * den(6)) * TI2_call(4,momenta_11,masses2_6,G4tensor(:,74),T4sum(1:70,22))
  M(2) = M(2) + (-f(5) * den(6)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,91),T4sum(1:70,24))
  M(2) = M(2) + (-f(6) * den(6)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,83),T4sum(1:70,25))
  M(2) = M(2) + (-f(5) * den(6)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,88),T4sum(1:70,26))
  M(1) = M(1) + (-f(6) * den(6)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,75),T4sum(1:70,25))
  M(1) = M(1) + (-f(5) * den(6)) * TI2_call(4,momenta_12,masses2_5,G4tensor(:,80),T4sum(1:70,26))
  M(2) = M(2) + (-f(6) * den(6)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,84),T4sum(1:70,25))
  M(2) = M(2) + (-f(5) * den(6)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,96),T4sum(1:70,27))
  M(1) = M(1) + (-f(6) * den(6)) * TI2_call(4,momenta_12,masses2_6,G4tensor(:,76),T4sum(1:70,25))
  M(1) = M(1) + (-f(5) * den(6)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,92),T4sum(1:70,27))
  M(2) = M(2) + (f(13) * den(12)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,53),T5sum(1:126,1))
  M(1) = M(1) + (f(13) * den(12)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,49),T5sum(1:126,1))
  M(2) = M(2) + (-f(9) * den(12)) * TI2_call(5,momenta_26,masses2_7,G5tensor(:,61),T5sum(1:126,2))
  M(1) = M(1) + (-f(9) * den(12)) * TI2_call(5,momenta_26,masses2_7,G5tensor(:,57),T5sum(1:126,2))
  M(2) = M(2) + (-f(14) * den(1)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,54),T5sum(1:126,1))
  M(1) = M(1) + (-f(14) * den(1)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,50),T5sum(1:126,1))
  M(2) = M(2) + (-f(10) * den(1)) * TI2_call(5,momenta_26,masses2_7,G5tensor(:,62),T5sum(1:126,2))
  M(1) = M(1) + (-f(10) * den(1)) * TI2_call(5,momenta_26,masses2_7,G5tensor(:,58),T5sum(1:126,2))
  M(2) = M(2) + (f(13) * den(12)) * TI2_call(5,momenta_22,masses2_8,G5tensor(:,65),T5sum(1:126,3))
  M(1) = M(1) + (f(13) * den(12)) * TI2_call(5,momenta_22,masses2_8,G5tensor(:,73),T5sum(1:126,3))
  M(2) = M(2) + (-f(9) * den(12)) * TI2_call(5,momenta_22,masses2_7,G5tensor(:,81),T5sum(1:126,4))
  M(1) = M(1) + (-f(9) * den(12)) * TI2_call(5,momenta_22,masses2_7,G5tensor(:,89),T5sum(1:126,4))
  M(2) = M(2) + (-f(14) * den(1)) * TI2_call(5,momenta_22,masses2_8,G5tensor(:,66),T5sum(1:126,3))
  M(1) = M(1) + (-f(14) * den(1)) * TI2_call(5,momenta_22,masses2_8,G5tensor(:,74),T5sum(1:126,3))
  M(2) = M(2) + (-f(10) * den(1)) * TI2_call(5,momenta_22,masses2_7,G5tensor(:,82),T5sum(1:126,4))
  M(1) = M(1) + (-f(10) * den(1)) * TI2_call(5,momenta_22,masses2_7,G5tensor(:,90),T5sum(1:126,4))
  M(1) = M(1) + (f(13) * den(12)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,51),T5sum(1:126,5))
  M(2) = M(2) + (f(13) * den(12)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,55),T5sum(1:126,5))
  M(1) = M(1) + (-f(9) * den(12)) * TI2_call(5,momenta_27,masses2_7,G5tensor(:,59),T5sum(1:126,6))
  M(2) = M(2) + (-f(9) * den(12)) * TI2_call(5,momenta_27,masses2_7,G5tensor(:,63),T5sum(1:126,6))
  M(1) = M(1) + (-f(14) * den(1)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,52),T5sum(1:126,5))
  M(2) = M(2) + (-f(14) * den(1)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,56),T5sum(1:126,5))
  M(1) = M(1) + (-f(10) * den(1)) * TI2_call(5,momenta_27,masses2_7,G5tensor(:,60),T5sum(1:126,6))
  M(2) = M(2) + (-f(10) * den(1)) * TI2_call(5,momenta_27,masses2_7,G5tensor(:,64),T5sum(1:126,6))
  M(1) = M(1) + (f(13) * den(12)) * TI2_call(5,momenta_23,masses2_8,G5tensor(:,67),T5sum(1:126,7))
  M(2) = M(2) + (f(13) * den(12)) * TI2_call(5,momenta_23,masses2_8,G5tensor(:,75),T5sum(1:126,7))
  M(1) = M(1) + (-f(9) * den(12)) * TI2_call(5,momenta_23,masses2_7,G5tensor(:,83),T5sum(1:126,8))
  M(2) = M(2) + (-f(9) * den(12)) * TI2_call(5,momenta_23,masses2_7,G5tensor(:,91),T5sum(1:126,8))
  M(1) = M(1) + (-f(14) * den(1)) * TI2_call(5,momenta_23,masses2_8,G5tensor(:,68),T5sum(1:126,7))
  M(2) = M(2) + (-f(14) * den(1)) * TI2_call(5,momenta_23,masses2_8,G5tensor(:,76),T5sum(1:126,7))
  M(1) = M(1) + (-f(10) * den(1)) * TI2_call(5,momenta_23,masses2_7,G5tensor(:,84),T5sum(1:126,8))
  M(2) = M(2) + (-f(10) * den(1)) * TI2_call(5,momenta_23,masses2_7,G5tensor(:,92),T5sum(1:126,8))
  M(1) = M(1) + (f(13) * den(12)) * TI2_call(5,momenta_16,masses2_8,G5tensor(:,9),T5sum(1:126,9))
  M(2) = M(2) + (f(13) * den(12)) * TI2_call(5,momenta_16,masses2_8,G5tensor(:,21),T5sum(1:126,9))
  M(1) = M(1) + (-f(9) * den(12)) * TI2_call(5,momenta_16,masses2_7,G5tensor(:,33),T5sum(1:126,10))
  M(2) = M(2) + (-f(9) * den(12)) * TI2_call(5,momenta_16,masses2_7,G5tensor(:,45),T5sum(1:126,10))
  M(1) = M(1) + (-f(14) * den(1)) * TI2_call(5,momenta_16,masses2_8,G5tensor(:,10),T5sum(1:126,9))
  M(2) = M(2) + (-f(14) * den(1)) * TI2_call(5,momenta_16,masses2_8,G5tensor(:,22),T5sum(1:126,9))
  M(1) = M(1) + (-f(10) * den(1)) * TI2_call(5,momenta_16,masses2_7,G5tensor(:,34),T5sum(1:126,10))
  M(2) = M(2) + (-f(10) * den(1)) * TI2_call(5,momenta_16,masses2_7,G5tensor(:,46),T5sum(1:126,10))
  M(2) = M(2) + (f(13) * den(12)) * TI2_call(5,momenta_17,masses2_8,G5tensor(:,11),T5sum(1:126,11))
  M(1) = M(1) + (f(13) * den(12)) * TI2_call(5,momenta_17,masses2_8,G5tensor(:,23),T5sum(1:126,11))
  M(2) = M(2) + (-f(9) * den(12)) * TI2_call(5,momenta_17,masses2_7,G5tensor(:,35),T5sum(1:126,12))
  M(1) = M(1) + (-f(9) * den(12)) * TI2_call(5,momenta_17,masses2_7,G5tensor(:,47),T5sum(1:126,12))
  M(2) = M(2) + (-f(14) * den(1)) * TI2_call(5,momenta_17,masses2_8,G5tensor(:,12),T5sum(1:126,11))
  M(1) = M(1) + (-f(14) * den(1)) * TI2_call(5,momenta_17,masses2_8,G5tensor(:,24),T5sum(1:126,11))
  M(2) = M(2) + (-f(10) * den(1)) * TI2_call(5,momenta_17,masses2_7,G5tensor(:,36),T5sum(1:126,12))
  M(1) = M(1) + (-f(10) * den(1)) * TI2_call(5,momenta_17,masses2_7,G5tensor(:,48),T5sum(1:126,12))
  M(2) = M(2) + (f(13) * den(12)) * TI2_call(5,momenta_24,masses2_8,G5tensor(:,69),T5sum(1:126,13))
  M(1) = M(1) + (f(13) * den(12)) * TI2_call(5,momenta_24,masses2_8,G5tensor(:,77),T5sum(1:126,13))
  M(2) = M(2) + (-f(9) * den(12)) * TI2_call(5,momenta_24,masses2_7,G5tensor(:,85),T5sum(1:126,14))
  M(1) = M(1) + (-f(9) * den(12)) * TI2_call(5,momenta_24,masses2_7,G5tensor(:,93),T5sum(1:126,14))
  M(2) = M(2) + (-f(14) * den(1)) * TI2_call(5,momenta_24,masses2_8,G5tensor(:,70),T5sum(1:126,13))
  M(1) = M(1) + (-f(14) * den(1)) * TI2_call(5,momenta_24,masses2_8,G5tensor(:,78),T5sum(1:126,13))
  M(2) = M(2) + (-f(10) * den(1)) * TI2_call(5,momenta_24,masses2_7,G5tensor(:,86),T5sum(1:126,14))
  M(1) = M(1) + (-f(10) * den(1)) * TI2_call(5,momenta_24,masses2_7,G5tensor(:,94),T5sum(1:126,14))
  M(2) = M(2) + (f(13) * den(12)) * TI2_call(5,momenta_25,masses2_8,G5tensor(:,79),T5sum(1:126,15))
  M(1) = M(1) + (f(13) * den(12)) * TI2_call(5,momenta_25,masses2_8,G5tensor(:,71),T5sum(1:126,15))
  M(2) = M(2) + (-f(9) * den(12)) * TI2_call(5,momenta_25,masses2_7,G5tensor(:,95),T5sum(1:126,16))
  M(1) = M(1) + (-f(9) * den(12)) * TI2_call(5,momenta_25,masses2_7,G5tensor(:,87),T5sum(1:126,16))
  M(2) = M(2) + (-f(14) * den(1)) * TI2_call(5,momenta_25,masses2_8,G5tensor(:,80),T5sum(1:126,15))
  M(1) = M(1) + (-f(14) * den(1)) * TI2_call(5,momenta_25,masses2_8,G5tensor(:,72),T5sum(1:126,15))
  M(2) = M(2) + (-f(10) * den(1)) * TI2_call(5,momenta_25,masses2_7,G5tensor(:,96),T5sum(1:126,16))
  M(1) = M(1) + (-f(10) * den(1)) * TI2_call(5,momenta_25,masses2_7,G5tensor(:,88),T5sum(1:126,16))
  M(2) = M(2) + (f(13) * den(12)) * TI2_call(5,momenta_18,masses2_8,G5tensor(:,5),T5sum(1:126,17))
  M(1) = M(1) + (f(13) * den(12)) * TI2_call(5,momenta_18,masses2_8,G5tensor(:,17),T5sum(1:126,17))
  M(2) = M(2) + (-f(9) * den(12)) * TI2_call(5,momenta_18,masses2_7,G5tensor(:,29),T5sum(1:126,18))
  M(1) = M(1) + (-f(9) * den(12)) * TI2_call(5,momenta_18,masses2_7,G5tensor(:,41),T5sum(1:126,18))
  M(2) = M(2) + (-f(14) * den(1)) * TI2_call(5,momenta_18,masses2_8,G5tensor(:,6),T5sum(1:126,17))
  M(1) = M(1) + (-f(14) * den(1)) * TI2_call(5,momenta_18,masses2_8,G5tensor(:,18),T5sum(1:126,17))
  M(2) = M(2) + (-f(10) * den(1)) * TI2_call(5,momenta_18,masses2_7,G5tensor(:,30),T5sum(1:126,18))
  M(1) = M(1) + (-f(10) * den(1)) * TI2_call(5,momenta_18,masses2_7,G5tensor(:,42),T5sum(1:126,18))
  M(1) = M(1) + (f(13) * den(12)) * TI2_call(5,momenta_19,masses2_8,G5tensor(:,7),T5sum(1:126,19))
  M(2) = M(2) + (f(13) * den(12)) * TI2_call(5,momenta_19,masses2_8,G5tensor(:,19),T5sum(1:126,19))
  M(1) = M(1) + (-f(9) * den(12)) * TI2_call(5,momenta_19,masses2_7,G5tensor(:,31),T5sum(1:126,20))
  M(2) = M(2) + (-f(9) * den(12)) * TI2_call(5,momenta_19,masses2_7,G5tensor(:,43),T5sum(1:126,20))
  M(1) = M(1) + (-f(14) * den(1)) * TI2_call(5,momenta_19,masses2_8,G5tensor(:,8),T5sum(1:126,19))
  M(2) = M(2) + (-f(14) * den(1)) * TI2_call(5,momenta_19,masses2_8,G5tensor(:,20),T5sum(1:126,19))
  M(1) = M(1) + (-f(10) * den(1)) * TI2_call(5,momenta_19,masses2_7,G5tensor(:,32),T5sum(1:126,20))
  M(2) = M(2) + (-f(10) * den(1)) * TI2_call(5,momenta_19,masses2_7,G5tensor(:,44),T5sum(1:126,20))
  M(1) = M(1) + (f(13) * den(12)) * TI2_call(5,momenta_20,masses2_8,G5tensor(:,1),T5sum(1:126,21))
  M(2) = M(2) + (f(13) * den(12)) * TI2_call(5,momenta_20,masses2_8,G5tensor(:,13),T5sum(1:126,21))
  M(1) = M(1) + (-f(9) * den(12)) * TI2_call(5,momenta_20,masses2_7,G5tensor(:,25),T5sum(1:126,22))
  M(2) = M(2) + (-f(9) * den(12)) * TI2_call(5,momenta_20,masses2_7,G5tensor(:,37),T5sum(1:126,22))
  M(1) = M(1) + (-f(14) * den(1)) * TI2_call(5,momenta_20,masses2_8,G5tensor(:,2),T5sum(1:126,21))
  M(2) = M(2) + (-f(14) * den(1)) * TI2_call(5,momenta_20,masses2_8,G5tensor(:,14),T5sum(1:126,21))
  M(1) = M(1) + (-f(10) * den(1)) * TI2_call(5,momenta_20,masses2_7,G5tensor(:,26),T5sum(1:126,22))
  M(2) = M(2) + (-f(10) * den(1)) * TI2_call(5,momenta_20,masses2_7,G5tensor(:,38),T5sum(1:126,22))
  M(2) = M(2) + (f(13) * den(12)) * TI2_call(5,momenta_21,masses2_8,G5tensor(:,3),T5sum(1:126,23))
  M(1) = M(1) + (f(13) * den(12)) * TI2_call(5,momenta_21,masses2_8,G5tensor(:,15),T5sum(1:126,23))
  M(2) = M(2) + (-f(9) * den(12)) * TI2_call(5,momenta_21,masses2_7,G5tensor(:,27),T5sum(1:126,24))
  M(1) = M(1) + (-f(9) * den(12)) * TI2_call(5,momenta_21,masses2_7,G5tensor(:,39),T5sum(1:126,24))
  M(2) = M(2) + (-f(14) * den(1)) * TI2_call(5,momenta_21,masses2_8,G5tensor(:,4),T5sum(1:126,23))
  M(1) = M(1) + (-f(14) * den(1)) * TI2_call(5,momenta_21,masses2_8,G5tensor(:,16),T5sum(1:126,23))
  M(2) = M(2) + (-f(10) * den(1)) * TI2_call(5,momenta_21,masses2_7,G5tensor(:,28),T5sum(1:126,24))
  M(1) = M(1) + (-f(10) * den(1)) * TI2_call(5,momenta_21,masses2_7,G5tensor(:,40),T5sum(1:126,24))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_pphllj2_eexhggg_1_/**/REALKIND
