
module ol_vamp_3_pphll_ew_eexbbxh_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_3(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphll_ew_eexbbxh_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphll_ew_eexbbxh_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphll_ew_eexbbxh_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphll_ew_eexbbxh_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,38) :: G0
  complex(REALKIND), dimension(4,5,4,79) :: G1
  complex(REALKIND), dimension(1,10) :: G0tensor
  complex(REALKIND), dimension(5,24) :: G1tensor
  complex(REALKIND), dimension(15,56) :: G2tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_VV_S(G0(:,:,:,1),wf(:,63),G0(:,:,:,2))
  call check_last_SV_V(l_switch,G0(:,:,:,2),wf(:,6),G0tensor(:,1))
  call check_last_SV_V(l_switch,G0(:,:,:,2),wf(:,1),G0tensor(:,2))
  call loop_VV_S(G0(:,:,:,1),wf(:,65),G0(:,:,:,3))
  call check_last_SV_V(l_switch,G0(:,:,:,3),wf(:,6),G0tensor(:,3))
  call check_last_SV_V(l_switch,G0(:,:,:,3),wf(:,1),G0tensor(:,4))
  call loop_VV_S(G0(:,:,:,1),wf(:,65),G0(:,:,:,4))
  call check_last_SV_V(l_switch,G0(:,:,:,4),wf(:,1),G0tensor(:,5))
  call loop_SA_Q(G0(:,:,:,1),wf(:,12),G0(:,:,:,5),gH)
  call loop_A_Q(G0(:,:,:,5),Q(:,24),MB,G1(:,:,:,1))
  call check_last_AQ_S(l_switch,G1(:,:,:,1),wf(:,75),G1tensor(:,1),gH)
  call check_last_AQ_S(l_switch,G1(:,:,:,1),wf(:,77),G1tensor(:,2),gH)
  call loop_SA_Q(G0(:,:,:,1),wf(:,12),G0(:,:,:,6),gX)
  call loop_A_Q(G0(:,:,:,6),Q(:,24),MB,G1(:,:,:,2))
  call check_last_AQ_S(l_switch,G1(:,:,:,2),wf(:,75),G1tensor(:,3),gX)
  call check_last_AQ_S(l_switch,G1(:,:,:,2),wf(:,77),G1tensor(:,4),gX)
  call loop_SA_Q(G0(:,:,:,1),wf(:,12),G0(:,:,:,7),gPbt)
  call loop_A_Q(G0(:,:,:,7),Q(:,24),MT,G1(:,:,:,3))
  call check_last_AQ_S(l_switch,G1(:,:,:,3),wf(:,75),G1tensor(:,5),gPtb)
  call check_last_AQ_S(l_switch,G1(:,:,:,3),wf(:,77),G1tensor(:,6),gPtb)
  call loop_ZA_Q(G0(:,:,:,1),wf(:,12),G0(:,:,:,8),gZd)
  call loop_A_Q(G0(:,:,:,8),Q(:,24),MB,G1(:,:,:,4))
  call check_last_AQ_Z(l_switch,G1(:,:,:,4),wf(:,75),G1tensor(:,7),gZd)
  call check_last_AQ_Z(l_switch,G1(:,:,:,4),wf(:,77),G1tensor(:,8),gZd)
  call loop_WA_Q(G0(:,:,:,1),wf(:,12),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,24),MT,G1(:,:,:,5))
  call check_last_AQ_W(l_switch,G1(:,:,:,5),wf(:,75),G1tensor(:,9))
  call check_last_AQ_W(l_switch,G1(:,:,:,5),wf(:,77),G1tensor(:,10))
  call loop_QS_A(G0(:,:,:,1),wf(:,89),G0(:,:,:,10),gH)
  call loop_Q_A(G0(:,:,:,10),Q(:,28),MM,G1(:,:,:,6))
  call loop_QV_A(G1(:,:,:,6),wf(:,6),G1(:,:,:,7))
  call check_last_Q_A(l_switch,G1(:,:,:,7),Q(:,31),MM,G2tensor(:,1))
  call loop_QZ_A(G1(:,:,:,6),wf(:,1),G1(:,:,:,8),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,8),Q(:,31),MM,G2tensor(:,2))
  call loop_QS_A(G0(:,:,:,1),wf(:,89),G0(:,:,:,11),gH)
  call loop_Q_A(G0(:,:,:,11),Q(:,28),ML,G1(:,:,:,9))
  call loop_QV_A(G1(:,:,:,9),wf(:,6),G1(:,:,:,10))
  call check_last_Q_A(l_switch,G1(:,:,:,10),Q(:,31),ML,G2tensor(:,3))
  call loop_QZ_A(G1(:,:,:,9),wf(:,1),G1(:,:,:,11),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,11),Q(:,31),ML,G2tensor(:,4))
  call loop_QS_A(G0(:,:,:,1),wf(:,89),G0(:,:,:,12),gH)
  call loop_Q_A(G0(:,:,:,12),Q(:,28),MT,G1(:,:,:,12))
  call loop_QV_A(G1(:,:,:,12),wf(:,6),G1(:,:,:,13))
  call check_last_Q_A(l_switch,G1(:,:,:,13),Q(:,31),MT,G2tensor(:,5))
  call loop_QZ_A(G1(:,:,:,12),wf(:,1),G1(:,:,:,14),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,14),Q(:,31),MT,G2tensor(:,6))
  call loop_QS_A(G0(:,:,:,1),wf(:,89),G0(:,:,:,13),gH)
  call loop_Q_A(G0(:,:,:,13),Q(:,28),MB,G1(:,:,:,15))
  call loop_QV_A(G1(:,:,:,15),wf(:,6),G1(:,:,:,16))
  call check_last_Q_A(l_switch,G1(:,:,:,16),Q(:,31),MB,G2tensor(:,7))
  call loop_QZ_A(G1(:,:,:,15),wf(:,1),G1(:,:,:,17),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,17),Q(:,31),MB,G2tensor(:,8))
  call loop_QS_A(G0(:,:,:,1),wf(:,71),G0(:,:,:,14),gX)
  call loop_Q_A(G0(:,:,:,14),Q(:,28),MM,G1(:,:,:,18))
  call loop_QV_A(G1(:,:,:,18),wf(:,6),G1(:,:,:,19))
  call check_last_Q_A(l_switch,G1(:,:,:,19),Q(:,31),MM,G2tensor(:,9))
  call loop_QZ_A(G1(:,:,:,18),wf(:,1),G1(:,:,:,20),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,20),Q(:,31),MM,G2tensor(:,10))
  call loop_QS_A(G0(:,:,:,1),wf(:,71),G0(:,:,:,15),gX)
  call loop_Q_A(G0(:,:,:,15),Q(:,28),ML,G1(:,:,:,21))
  call loop_QV_A(G1(:,:,:,21),wf(:,6),G1(:,:,:,22))
  call check_last_Q_A(l_switch,G1(:,:,:,22),Q(:,31),ML,G2tensor(:,11))
  call loop_QZ_A(G1(:,:,:,21),wf(:,1),G1(:,:,:,23),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,23),Q(:,31),ML,G2tensor(:,12))
  call loop_QS_A(G0(:,:,:,1),wf(:,71),G0(:,:,:,16),gX)
  call loop_Q_A(G0(:,:,:,16),Q(:,28),MT,G1(:,:,:,24))
  call loop_QV_A(G1(:,:,:,24),wf(:,6),G1(:,:,:,25))
  call check_last_Q_A(l_switch,G1(:,:,:,25),Q(:,31),MT,G2tensor(:,13))
  call loop_QZ_A(G1(:,:,:,24),wf(:,1),G1(:,:,:,26),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,26),Q(:,31),MT,G2tensor(:,14))
  call loop_QS_A(G0(:,:,:,1),wf(:,71),G0(:,:,:,17),gX)
  call loop_Q_A(G0(:,:,:,17),Q(:,28),MB,G1(:,:,:,27))
  call loop_QV_A(G1(:,:,:,27),wf(:,6),G1(:,:,:,28))
  call check_last_Q_A(l_switch,G1(:,:,:,28),Q(:,31),MB,G2tensor(:,15))
  call loop_QZ_A(G1(:,:,:,27),wf(:,1),G1(:,:,:,29),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,29),Q(:,31),MB,G2tensor(:,16))
  call loop_SS_S(G0(:,:,:,1),wf(:,89),G0(:,:,:,18))
  call check_last_TV_S(l_switch,G0(:,:,:,18),Q(:,28),wf(:,6),Q(:,3),G1tensor(:,11))
  call check_last_TV_S(l_switch,G0(:,:,:,18),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,12))
  call loop_SS_S(G0(:,:,:,1),wf(:,71),G0(:,:,:,19))
  call check_last_TV_S(l_switch,G0(:,:,:,19),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,13))
  call loop_SS_S(G0(:,:,:,1),wf(:,89),G0(:,:,:,20))
  call check_last_CV_D(l_switch,G0(:,:,:,20),Q(:,28),wf(:,6),Q(:,3),G1tensor(:,14))
  call check_last_CV_D(l_switch,G0(:,:,:,20),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,15))
  call loop_SS_S(G0(:,:,:,1),wf(:,71),G0(:,:,:,21))
  call check_last_CV_D(l_switch,G0(:,:,:,21),Q(:,28),wf(:,6),Q(:,3),G1tensor(:,16))
  call check_last_CV_D(l_switch,G0(:,:,:,21),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,17))
  call loop_VS_V(G0(:,:,:,1),wf(:,89),G0(:,:,:,22))
  call check_last_UV_W(l_switch,G0(:,:,:,22),Q(:,28),wf(:,6),Q(:,3),G1tensor(:,18))
  call check_last_UV_W(l_switch,G0(:,:,:,22),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,19))
  call loop_VT_S(G0(:,:,:,1),Q(:,0),wf(:,89),Q(:,28),G1(:,:,:,30))
  call check_last_SV_V(l_switch,G1(:,:,:,30),wf(:,6),G1tensor(:,20))
  call check_last_SV_V(l_switch,G1(:,:,:,30),wf(:,1),G1tensor(:,21))
  call loop_VT_S(G0(:,:,:,1),Q(:,0),wf(:,71),Q(:,28),G1(:,:,:,31))
  call check_last_SV_V(l_switch,G1(:,:,:,31),wf(:,6),G1tensor(:,22))
  call check_last_SV_V(l_switch,G1(:,:,:,31),wf(:,1),G1tensor(:,23))
  call loop_VS_T(G0(:,:,:,1),Q(:,0),wf(:,71),Q(:,28),G1(:,:,:,32))
  call check_last_SV_V(l_switch,G1(:,:,:,32),wf(:,1),G1tensor(:,24))
  call loop_QV_A(G0(:,:,:,1),wf(:,72),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,28),ZERO,G1(:,:,:,33))
  call loop_QV_A(G1(:,:,:,33),wf(:,6),G1(:,:,:,34))
  call check_last_Q_A(l_switch,G1(:,:,:,34),Q(:,31),ZERO,G2tensor(:,17))
  call loop_QZ_A(G1(:,:,:,33),wf(:,1),G1(:,:,:,35),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,35),Q(:,31),ZERO,G2tensor(:,18))
  call loop_QZ_A(G1(:,:,:,33),wf(:,1),G1(:,:,:,36),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,36),Q(:,31),ZERO,G2tensor(:,19))
  call loop_QZ_A(G1(:,:,:,33),wf(:,1),G1(:,:,:,37),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,37),Q(:,31),ZERO,G2tensor(:,20))
  call loop_QV_A(G0(:,:,:,1),wf(:,72),G0(:,:,:,24))
  call loop_Q_A(G0(:,:,:,24),Q(:,28),MM,G1(:,:,:,38))
  call loop_QV_A(G1(:,:,:,38),wf(:,6),G1(:,:,:,39))
  call check_last_Q_A(l_switch,G1(:,:,:,39),Q(:,31),MM,G2tensor(:,21))
  call loop_QZ_A(G1(:,:,:,38),wf(:,1),G1(:,:,:,40),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,40),Q(:,31),MM,G2tensor(:,22))
  call loop_QV_A(G0(:,:,:,1),wf(:,72),G0(:,:,:,25))
  call loop_Q_A(G0(:,:,:,25),Q(:,28),ML,G1(:,:,:,41))
  call loop_QV_A(G1(:,:,:,41),wf(:,6),G1(:,:,:,42))
  call check_last_Q_A(l_switch,G1(:,:,:,42),Q(:,31),ML,G2tensor(:,23))
  call loop_QZ_A(G1(:,:,:,41),wf(:,1),G1(:,:,:,43),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,43),Q(:,31),ML,G2tensor(:,24))
  call loop_QV_A(G0(:,:,:,1),wf(:,72),G0(:,:,:,26))
  call loop_Q_A(G0(:,:,:,26),Q(:,28),MT,G1(:,:,:,44))
  call loop_QV_A(G1(:,:,:,44),wf(:,6),G1(:,:,:,45))
  call check_last_Q_A(l_switch,G1(:,:,:,45),Q(:,31),MT,G2tensor(:,25))
  call loop_QZ_A(G1(:,:,:,44),wf(:,1),G1(:,:,:,46),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,46),Q(:,31),MT,G2tensor(:,26))
  call loop_QV_A(G0(:,:,:,1),wf(:,72),G0(:,:,:,27))
  call loop_Q_A(G0(:,:,:,27),Q(:,28),MB,G1(:,:,:,47))
  call loop_QV_A(G1(:,:,:,47),wf(:,6),G1(:,:,:,48))
  call check_last_Q_A(l_switch,G1(:,:,:,48),Q(:,31),MB,G2tensor(:,27))
  call loop_QZ_A(G1(:,:,:,47),wf(:,1),G1(:,:,:,49),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,49),Q(:,31),MB,G2tensor(:,28))
  call loop_QZ_A(G0(:,:,:,1),wf(:,73),G0(:,:,:,28),gZl)
  call loop_Q_A(G0(:,:,:,28),Q(:,28),ZERO,G1(:,:,:,50))
  call loop_QV_A(G1(:,:,:,50),wf(:,6),G1(:,:,:,51))
  call check_last_Q_A(l_switch,G1(:,:,:,51),Q(:,31),ZERO,G2tensor(:,29))
  call loop_QZ_A(G1(:,:,:,50),wf(:,1),G1(:,:,:,52),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,52),Q(:,31),ZERO,G2tensor(:,30))
  call loop_QZ_A(G0(:,:,:,1),wf(:,73),G0(:,:,:,29),gZl)
  call loop_Q_A(G0(:,:,:,29),Q(:,28),MM,G1(:,:,:,53))
  call loop_QV_A(G1(:,:,:,53),wf(:,6),G1(:,:,:,54))
  call check_last_Q_A(l_switch,G1(:,:,:,54),Q(:,31),MM,G2tensor(:,31))
  call loop_QZ_A(G1(:,:,:,53),wf(:,1),G1(:,:,:,55),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,55),Q(:,31),MM,G2tensor(:,32))
  call loop_QZ_A(G0(:,:,:,1),wf(:,73),G0(:,:,:,30),gZl)
  call loop_Q_A(G0(:,:,:,30),Q(:,28),ML,G1(:,:,:,56))
  call loop_QV_A(G1(:,:,:,56),wf(:,6),G1(:,:,:,57))
  call check_last_Q_A(l_switch,G1(:,:,:,57),Q(:,31),ML,G2tensor(:,33))
  call loop_QZ_A(G1(:,:,:,56),wf(:,1),G1(:,:,:,58),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,58),Q(:,31),ML,G2tensor(:,34))
  call loop_QZ_A(G0(:,:,:,1),wf(:,73),G0(:,:,:,31),gZu)
  call loop_Q_A(G0(:,:,:,31),Q(:,28),ZERO,G1(:,:,:,59))
  call loop_QV_A(G1(:,:,:,59),wf(:,6),G1(:,:,:,60))
  call check_last_Q_A(l_switch,G1(:,:,:,60),Q(:,31),ZERO,G2tensor(:,35))
  call loop_QZ_A(G1(:,:,:,59),wf(:,1),G1(:,:,:,61),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,61),Q(:,31),ZERO,G2tensor(:,36))
  call loop_QZ_A(G0(:,:,:,1),wf(:,73),G0(:,:,:,32),gZu)
  call loop_Q_A(G0(:,:,:,32),Q(:,28),MT,G1(:,:,:,62))
  call loop_QV_A(G1(:,:,:,62),wf(:,6),G1(:,:,:,63))
  call check_last_Q_A(l_switch,G1(:,:,:,63),Q(:,31),MT,G2tensor(:,37))
  call loop_QZ_A(G1(:,:,:,62),wf(:,1),G1(:,:,:,64),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,64),Q(:,31),MT,G2tensor(:,38))
  call loop_QZ_A(G0(:,:,:,1),wf(:,73),G0(:,:,:,33),gZd)
  call loop_Q_A(G0(:,:,:,33),Q(:,28),ZERO,G1(:,:,:,65))
  call loop_QV_A(G1(:,:,:,65),wf(:,6),G1(:,:,:,66))
  call check_last_Q_A(l_switch,G1(:,:,:,66),Q(:,31),ZERO,G2tensor(:,39))
  call loop_QZ_A(G1(:,:,:,65),wf(:,1),G1(:,:,:,67),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,67),Q(:,31),ZERO,G2tensor(:,40))
  call loop_QZ_A(G0(:,:,:,1),wf(:,73),G0(:,:,:,34),gZd)
  call loop_Q_A(G0(:,:,:,34),Q(:,28),MB,G1(:,:,:,68))
  call loop_QV_A(G1(:,:,:,68),wf(:,6),G1(:,:,:,69))
  call check_last_Q_A(l_switch,G1(:,:,:,69),Q(:,31),MB,G2tensor(:,41))
  call loop_QZ_A(G1(:,:,:,68),wf(:,1),G1(:,:,:,70),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,70),Q(:,31),MB,G2tensor(:,42))
  call loop_QZ_A(G0(:,:,:,1),wf(:,73),G0(:,:,:,35),gZn)
  call loop_Q_A(G0(:,:,:,35),Q(:,28),ZERO,G1(:,:,:,71))
  call loop_QZ_A(G1(:,:,:,71),wf(:,1),G1(:,:,:,72),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,72),Q(:,31),ZERO,G2tensor(:,43))
  call loop_TV_S(G0(:,:,:,1),Q(:,0),wf(:,72),Q(:,28),G1(:,:,:,73))
  call check_last_TV_S(l_switch,G1(:,:,:,73),Q(:,28),wf(:,6),Q(:,3),G2tensor(:,44))
  call check_last_TV_S(l_switch,G1(:,:,:,73),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,45))
  call loop_TV_S(G0(:,:,:,1),Q(:,0),wf(:,73),Q(:,28),G1(:,:,:,74))
  call check_last_TV_S(l_switch,G1(:,:,:,74),Q(:,28),wf(:,6),Q(:,3),G2tensor(:,46))
  call check_last_TV_S(l_switch,G1(:,:,:,74),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,47))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,73),Q(:,28),G1(:,:,:,75))
  call check_last_TV_S(l_switch,G1(:,:,:,75),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,48))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,72),Q(:,28),G1(:,:,:,76))
  call check_last_CV_D(l_switch,G1(:,:,:,76),Q(:,28),wf(:,6),Q(:,3),G2tensor(:,49))
  call check_last_CV_D(l_switch,G1(:,:,:,76),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,50))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,73),Q(:,28),G1(:,:,:,77))
  call check_last_CV_D(l_switch,G1(:,:,:,77),Q(:,28),wf(:,6),Q(:,3),G2tensor(:,51))
  call check_last_CV_D(l_switch,G1(:,:,:,77),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,52))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,72),Q(:,28),G1(:,:,:,78))
  call check_last_UV_W(l_switch,G1(:,:,:,78),Q(:,28),wf(:,6),Q(:,3),G2tensor(:,53))
  call check_last_UV_W(l_switch,G1(:,:,:,78),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,54))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,73),Q(:,28),G1(:,:,:,79))
  call check_last_UV_W(l_switch,G1(:,:,:,79),Q(:,28),wf(:,6),Q(:,3),G2tensor(:,55))
  call check_last_UV_W(l_switch,G1(:,:,:,79),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,56))
  call loop_VV_S(G0(:,:,:,1),wf(:,72),G0(:,:,:,36))
  call check_last_SV_V(l_switch,G0(:,:,:,36),wf(:,6),G0tensor(:,6))
  call check_last_SV_V(l_switch,G0(:,:,:,36),wf(:,1),G0tensor(:,7))
  call loop_VV_S(G0(:,:,:,1),wf(:,73),G0(:,:,:,37))
  call check_last_SV_V(l_switch,G0(:,:,:,37),wf(:,6),G0tensor(:,8))
  call check_last_SV_V(l_switch,G0(:,:,:,37),wf(:,1),G0tensor(:,9))
  call loop_VV_S(G0(:,:,:,1),wf(:,73),G0(:,:,:,38))
  call check_last_SV_V(l_switch,G0(:,:,:,38),wf(:,1),G0tensor(:,10))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (-(c(153)*M(2))) * den(28)
  T2sum(1:1,62) = T2sum(1:1,62) + Gcoeff * G0tensor(:,1)
  Gcoeff = (-(c(153)*M(2))) * den(28)
  T2sum(1:1,62) = T2sum(1:1,62) + Gcoeff * G0tensor(:,1)
  Gcoeff = (-(c(5)*M(2))) * den(24)
  T2sum(1:1,62) = T2sum(1:1,62) + Gcoeff * G0tensor(:,3)
  Gcoeff = (-(c(5)*M(2))) * den(24)
  T2sum(1:1,62) = T2sum(1:1,62) + Gcoeff * G0tensor(:,3)
  Gcoeff = (-(c(4)*M(2))) * den(29)
  T2sum(1:1,62) = T2sum(1:1,62) + Gcoeff * G0tensor(:,2)
  Gcoeff = (-(c(4)*M(2))) * den(29)
  T2sum(1:1,62) = T2sum(1:1,62) + Gcoeff * G0tensor(:,2)
  Gcoeff = (-(c(109)*M(2))) * den(25)
  T2sum(1:1,63) = T2sum(1:1,63) + Gcoeff * G0tensor(:,5)
  Gcoeff = (-(c(158)*M(2))) * den(25)
  T2sum(1:1,62) = T2sum(1:1,62) + Gcoeff * G0tensor(:,4)
  Gcoeff = (-(c(158)*M(2))) * den(25)
  T2sum(1:1,62) = T2sum(1:1,62) + Gcoeff * G0tensor(:,4)
  Gcoeff = (-(c(56)*M(2))) * den(43)
  T1sum(1:5,14) = T1sum(1:5,14) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(56)*M(2)) * den(43)
  T1sum(1:5,15) = T1sum(1:5,15) + Gcoeff * G1tensor(:,3)
  Gcoeff = (c(53)*M(2)) * den(43)
  T1sum(1:5,16) = T1sum(1:5,16) + Gcoeff * G1tensor(:,5)
  Gcoeff = (-(c(57)*M(2))) * den(45)
  T1sum(1:5,14) = T1sum(1:5,14) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(57)*M(2)) * den(45)
  T1sum(1:5,15) = T1sum(1:5,15) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(55)*M(2)) * den(45)
  T1sum(1:5,16) = T1sum(1:5,16) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(139)*M(2)) * den(43)
  T1sum(1:5,15) = T1sum(1:5,15) + Gcoeff * G1tensor(:,7)
  Gcoeff = (c(75)*M(2)) * den(43)
  T1sum(1:5,16) = T1sum(1:5,16) + Gcoeff * G1tensor(:,9)
  Gcoeff = (c(140)*M(2)) * den(45)
  T1sum(1:5,15) = T1sum(1:5,15) + Gcoeff * G1tensor(:,8)
  Gcoeff = (c(78)*M(2)) * den(45)
  T1sum(1:5,16) = T1sum(1:5,16) + Gcoeff * G1tensor(:,10)
  Gcoeff = (c(204)*M(2)) * den(64)
  T2sum(1:15,71) = T2sum(1:15,71) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(200)*M(2)) * den(64)
  T2sum(1:15,72) = T2sum(1:15,72) + Gcoeff * G2tensor(:,3)
  Gcoeff = (-(c(208)*M(2))) * den(64)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(194)*M(2)) * den(64)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,7)
  Gcoeff = (-(c(204)*M(2))) * den(36)
  T2sum(1:15,71) = T2sum(1:15,71) + Gcoeff * G2tensor(:,9)
  Gcoeff = (-(c(200)*M(2))) * den(36)
  T2sum(1:15,72) = T2sum(1:15,72) + Gcoeff * G2tensor(:,11)
  Gcoeff = (-(c(208)*M(2))) * den(36)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,13)
  Gcoeff = (-(c(194)*M(2))) * den(36)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(204)*M(2)) * den(65)
  T2sum(1:15,71) = T2sum(1:15,71) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(200)*M(2)) * den(65)
  T2sum(1:15,72) = T2sum(1:15,72) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(209)*M(2)) * den(65)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(195)*M(2)) * den(65)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,8)
  Gcoeff = (-(c(204)*M(2))) * den(37)
  T2sum(1:15,71) = T2sum(1:15,71) + Gcoeff * G2tensor(:,10)
  Gcoeff = (-(c(200)*M(2))) * den(37)
  T2sum(1:15,72) = T2sum(1:15,72) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(209)*M(2)) * den(37)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,14)
  Gcoeff = (-(c(195)*M(2))) * den(37)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(63)*M(2)) * den(64)
  T2sum(1:5,62) = T2sum(1:5,62) + Gcoeff * G1tensor(:,11)
  Gcoeff = (c(165)*M(2)) * den(65)
  T2sum(1:5,62) = T2sum(1:5,62) + Gcoeff * G1tensor(:,12)
  Gcoeff = (c(22)*M(2)) * den(37)
  T2sum(1:5,63) = T2sum(1:5,63) + Gcoeff * G1tensor(:,13)
  Gcoeff = (c(82)*M(2)) * den(64)
  T2sum(1:5,62) = T2sum(1:5,62) + Gcoeff * G1tensor(:,14)
  Gcoeff = (-(c(82)*M(2))) * den(64)
  T2sum(1:5,62) = T2sum(1:5,62) + Gcoeff * G1tensor(:,14)
  Gcoeff = (-(c(82)*M(2))) * den(36)
  T2sum(1:5,62) = T2sum(1:5,62) + Gcoeff * G1tensor(:,16)
  Gcoeff = (-(c(82)*M(2))) * den(36)
  T2sum(1:5,62) = T2sum(1:5,62) + Gcoeff * G1tensor(:,16)
  Gcoeff = (-(c(36)*M(2))) * den(65)
  T2sum(1:5,62) = T2sum(1:5,62) + Gcoeff * G1tensor(:,15)
  Gcoeff = (c(36)*M(2)) * den(65)
  T2sum(1:5,62) = T2sum(1:5,62) + Gcoeff * G1tensor(:,15)
  Gcoeff = (c(36)*M(2)) * den(37)
  T2sum(1:5,62) = T2sum(1:5,62) + Gcoeff * G1tensor(:,17)
  Gcoeff = (c(36)*M(2)) * den(37)
  T2sum(1:5,62) = T2sum(1:5,62) + Gcoeff * G1tensor(:,17)
  Gcoeff = (c(83)*M(2)) * den(64)
  T2sum(1:5,62) = T2sum(1:5,62) + Gcoeff * G1tensor(:,18)
  Gcoeff = (-(c(37)*M(2))) * den(65)
  T2sum(1:5,62) = T2sum(1:5,62) + Gcoeff * G1tensor(:,19)
  Gcoeff = (c(82)*M(2)) * den(64)
  T2sum(1:5,62) = T2sum(1:5,62) + Gcoeff * G1tensor(:,20)
  Gcoeff = (-(c(82)*M(2))) * den(64)
  T2sum(1:5,62) = T2sum(1:5,62) + Gcoeff * G1tensor(:,20)
  Gcoeff = (-(c(82)*M(2))) * den(36)
  T2sum(1:5,62) = T2sum(1:5,62) + Gcoeff * G1tensor(:,22)
  Gcoeff = (-(c(82)*M(2))) * den(36)
  T2sum(1:5,62) = T2sum(1:5,62) + Gcoeff * G1tensor(:,22)
  Gcoeff = (c(120)*M(2)) * den(65)
  T2sum(1:5,62) = T2sum(1:5,62) + Gcoeff * G1tensor(:,21)
  Gcoeff = (-(c(120)*M(2))) * den(65)
  T2sum(1:5,62) = T2sum(1:5,62) + Gcoeff * G1tensor(:,21)
  Gcoeff = (c(35)*M(2)) * den(37)
  T2sum(1:5,63) = T2sum(1:5,63) + Gcoeff * G1tensor(:,24)
  Gcoeff = (-(c(120)*M(2))) * den(37)
  T2sum(1:5,62) = T2sum(1:5,62) + Gcoeff * G1tensor(:,23)
  Gcoeff = (-(c(120)*M(2))) * den(37)
  T2sum(1:5,62) = T2sum(1:5,62) + Gcoeff * G1tensor(:,23)
  Gcoeff = (-(c(241)*M(2))) * den(39)
  T2sum(1:15,75) = T2sum(1:15,75) + Gcoeff * G2tensor(:,17)
  Gcoeff = (-(c(241)*M(2))) * den(39)
  T2sum(1:15,71) = T2sum(1:15,71) + Gcoeff * G2tensor(:,21)
  Gcoeff = (-(c(241)*M(2))) * den(39)
  T2sum(1:15,72) = T2sum(1:15,72) + Gcoeff * G2tensor(:,23)
  Gcoeff = (-(c(240)*M(2))) * den(39)
  T2sum(1:15,75) = T2sum(1:15,75) + Gcoeff * G2tensor(:,17)
  Gcoeff = (-(c(238)*M(2))) * den(39)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,25)
  Gcoeff = (-(c(236)*M(2))) * den(39)
  T2sum(1:15,75) = T2sum(1:15,75) + Gcoeff * G2tensor(:,17)
  Gcoeff = (-(c(235)*M(2))) * den(39)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,27)
  Gcoeff = (-(c(245)*M(2))) * den(36)
  T2sum(1:15,75) = T2sum(1:15,75) + Gcoeff * G2tensor(:,29)
  Gcoeff = (-(c(245)*M(2))) * den(36)
  T2sum(1:15,71) = T2sum(1:15,71) + Gcoeff * G2tensor(:,31)
  Gcoeff = (-(c(245)*M(2))) * den(36)
  T2sum(1:15,72) = T2sum(1:15,72) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(247)*M(2)) * den(36)
  T2sum(1:15,75) = T2sum(1:15,75) + Gcoeff * G2tensor(:,35)
  Gcoeff = (c(244)*M(2)) * den(36)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,37)
  Gcoeff = (-(c(244)*M(2))) * den(36)
  T2sum(1:15,75) = T2sum(1:15,75) + Gcoeff * G2tensor(:,39)
  Gcoeff = (-(c(242)*M(2))) * den(36)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,41)
  Gcoeff = (-(c(241)*M(2))) * den(40)
  T2sum(1:15,75) = T2sum(1:15,75) + Gcoeff * G2tensor(:,18)
  Gcoeff = (-(c(241)*M(2))) * den(40)
  T2sum(1:15,71) = T2sum(1:15,71) + Gcoeff * G2tensor(:,22)
  Gcoeff = (-(c(241)*M(2))) * den(40)
  T2sum(1:15,72) = T2sum(1:15,72) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(243)*M(2)) * den(40)
  T2sum(1:15,75) = T2sum(1:15,75) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(239)*M(2)) * den(40)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,26)
  Gcoeff = (-(c(239)*M(2))) * den(40)
  T2sum(1:15,75) = T2sum(1:15,75) + Gcoeff * G2tensor(:,20)
  Gcoeff = (-(c(237)*M(2))) * den(40)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,28)
  Gcoeff = (-(c(249)*M(2))) * den(37)
  T2sum(1:15,75) = T2sum(1:15,75) + Gcoeff * G2tensor(:,43)
  Gcoeff = (-(c(245)*M(2))) * den(37)
  T2sum(1:15,75) = T2sum(1:15,75) + Gcoeff * G2tensor(:,30)
  Gcoeff = (-(c(245)*M(2))) * den(37)
  T2sum(1:15,71) = T2sum(1:15,71) + Gcoeff * G2tensor(:,32)
  Gcoeff = (-(c(245)*M(2))) * den(37)
  T2sum(1:15,72) = T2sum(1:15,72) + Gcoeff * G2tensor(:,34)
  Gcoeff = (-(c(248)*M(2))) * den(37)
  T2sum(1:15,75) = T2sum(1:15,75) + Gcoeff * G2tensor(:,36)
  Gcoeff = (-(c(246)*M(2))) * den(37)
  T2sum(1:15,73) = T2sum(1:15,73) + Gcoeff * G2tensor(:,38)
  Gcoeff = (-(c(248)*M(2))) * den(37)
  T2sum(1:15,75) = T2sum(1:15,75) + Gcoeff * G2tensor(:,40)
  Gcoeff = (-(c(246)*M(2))) * den(37)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,42)
  Gcoeff = (c(139)*M(2)) * den(39)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,44)
  Gcoeff = (-(c(174)*M(2))) * den(36)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,46)
  Gcoeff = (-(c(173)*M(2))) * den(40)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,45)
  Gcoeff = (-(c(79)*M(2))) * den(37)
  T2sum(1:15,63) = T2sum(1:15,63) + Gcoeff * G2tensor(:,48)
  Gcoeff = (c(185)*M(2)) * den(37)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,47)
  Gcoeff = (-(c(139)*M(2))) * den(39)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,49)
  Gcoeff = (-(c(139)*M(2))) * den(39)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,49)
  Gcoeff = (c(118)*M(2)) * den(36)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,51)
  Gcoeff = (c(118)*M(2)) * den(36)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,51)
  Gcoeff = (c(117)*M(2)) * den(40)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,50)
  Gcoeff = (c(117)*M(2)) * den(40)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,50)
  Gcoeff = (-(c(81)*M(2))) * den(37)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,52)
  Gcoeff = (-(c(81)*M(2))) * den(37)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,52)
  Gcoeff = (c(139)*M(2)) * den(39)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,53)
  Gcoeff = (-(c(118)*M(2))) * den(36)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,55)
  Gcoeff = (-(c(117)*M(2))) * den(40)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,54)
  Gcoeff = (c(81)*M(2)) * den(37)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,56)
  Gcoeff = (-(c(153)*M(2))) * den(39)
  T2sum(1:1,62) = T2sum(1:1,62) + Gcoeff * G0tensor(:,6)
  Gcoeff = (-(c(153)*M(2))) * den(39)
  T2sum(1:1,62) = T2sum(1:1,62) + Gcoeff * G0tensor(:,6)
  Gcoeff = (-(c(5)*M(2))) * den(36)
  T2sum(1:1,62) = T2sum(1:1,62) + Gcoeff * G0tensor(:,8)
  Gcoeff = (-(c(5)*M(2))) * den(36)
  T2sum(1:1,62) = T2sum(1:1,62) + Gcoeff * G0tensor(:,8)
  Gcoeff = (-(c(4)*M(2))) * den(40)
  T2sum(1:1,62) = T2sum(1:1,62) + Gcoeff * G0tensor(:,7)
  Gcoeff = (-(c(4)*M(2))) * den(40)
  T2sum(1:1,62) = T2sum(1:1,62) + Gcoeff * G0tensor(:,7)
  Gcoeff = (-(c(109)*M(2))) * den(37)
  T2sum(1:1,63) = T2sum(1:1,63) + Gcoeff * G0tensor(:,10)
  Gcoeff = (-(c(158)*M(2))) * den(37)
  T2sum(1:1,62) = T2sum(1:1,62) + Gcoeff * G0tensor(:,9)
  Gcoeff = (-(c(158)*M(2))) * den(37)
  T2sum(1:1,62) = T2sum(1:1,62) + Gcoeff * G0tensor(:,9)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_3

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_3_pphll_ew_eexbbxh_1_/**/REALKIND
