
module ol_vamp_2_pphll_ew_nenexbbxh_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_2(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphll_ew_nenexbbxh_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphll_ew_nenexbbxh_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphll_ew_nenexbbxh_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphll_ew_nenexbbxh_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,122) :: G0
  complex(REALKIND), dimension(4,5,4,212) :: G1
  complex(REALKIND), dimension(1,13) :: G0tensor
  complex(REALKIND), dimension(5,46) :: G1tensor
  complex(REALKIND), dimension(15,122) :: G2tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QZ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,2),gZl)
  call loop_Q_A(G0(:,:,:,2),Q(:,19),ML,G1(:,:,:,1))
  call loop_QS_A(G1(:,:,:,1),wf(:,64),G1(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,2),Q(:,31),ML,G2tensor(:,1))
  call loop_QS_A(G1(:,:,:,1),wf(:,2),G1(:,:,:,3),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,3),Q(:,31),ML,G2tensor(:,2))
  call loop_QV_A(G1(:,:,:,1),wf(:,13),G1(:,:,:,4))
  call check_last_Q_A(l_switch,G1(:,:,:,4),Q(:,31),ML,G2tensor(:,3))
  call loop_QZ_A(G1(:,:,:,1),wf(:,4),G1(:,:,:,5),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,5),Q(:,31),ML,G2tensor(:,4))
  call loop_QZ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,3),gZu)
  call loop_Q_A(G0(:,:,:,3),Q(:,19),MT,G1(:,:,:,6))
  call loop_QS_A(G1(:,:,:,6),wf(:,64),G1(:,:,:,7),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,7),Q(:,31),MT,G2tensor(:,5))
  call loop_QS_A(G1(:,:,:,6),wf(:,2),G1(:,:,:,8),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,8),Q(:,31),MT,G2tensor(:,6))
  call loop_QV_A(G1(:,:,:,6),wf(:,13),G1(:,:,:,9))
  call check_last_Q_A(l_switch,G1(:,:,:,9),Q(:,31),MT,G2tensor(:,7))
  call loop_QZ_A(G1(:,:,:,6),wf(:,4),G1(:,:,:,10),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,10),Q(:,31),MT,G2tensor(:,8))
  call loop_QZ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,4),gZd)
  call loop_Q_A(G0(:,:,:,4),Q(:,19),MB,G1(:,:,:,11))
  call loop_QS_A(G1(:,:,:,11),wf(:,64),G1(:,:,:,12),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,12),Q(:,31),MB,G2tensor(:,9))
  call loop_QS_A(G1(:,:,:,11),wf(:,2),G1(:,:,:,13),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,13),Q(:,31),MB,G2tensor(:,10))
  call loop_QV_A(G1(:,:,:,11),wf(:,13),G1(:,:,:,14))
  call check_last_Q_A(l_switch,G1(:,:,:,14),Q(:,31),MB,G2tensor(:,11))
  call loop_QZ_A(G1(:,:,:,11),wf(:,4),G1(:,:,:,15),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,15),Q(:,31),MB,G2tensor(:,12))
  call loop_TV_S(G0(:,:,:,1),Q(:,0),wf(:,5),Q(:,19),G1(:,:,:,16))
  call check_last_SS_S(l_switch,G1(:,:,:,16),wf(:,64),G1tensor(:,1))
  call check_last_TV_S(l_switch,G1(:,:,:,16),Q(:,19),wf(:,13),Q(:,12),G2tensor(:,13))
  call check_last_TV_S(l_switch,G1(:,:,:,16),Q(:,19),wf(:,4),Q(:,12),G2tensor(:,14))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,5),Q(:,19),G1(:,:,:,17))
  call check_last_SS_S(l_switch,G1(:,:,:,17),wf(:,2),G1tensor(:,2))
  call check_last_TV_S(l_switch,G1(:,:,:,17),Q(:,19),wf(:,4),Q(:,12),G2tensor(:,15))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,5),Q(:,19),G1(:,:,:,18))
  call check_last_SS_S(l_switch,G1(:,:,:,18),wf(:,64),G1tensor(:,3))
  call check_last_SS_S(l_switch,G1(:,:,:,18),wf(:,2),G1tensor(:,4))
  call check_last_CV_D(l_switch,G1(:,:,:,18),Q(:,19),wf(:,13),Q(:,12),G2tensor(:,16))
  call check_last_CV_D(l_switch,G1(:,:,:,18),Q(:,19),wf(:,4),Q(:,12),G2tensor(:,17))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,5),Q(:,19),G1(:,:,:,19))
  call check_last_VS_V(l_switch,G1(:,:,:,19),wf(:,64),G1tensor(:,5))
  call check_last_UV_W(l_switch,G1(:,:,:,19),Q(:,19),wf(:,13),Q(:,12),G2tensor(:,18))
  call check_last_UV_W(l_switch,G1(:,:,:,19),Q(:,19),wf(:,4),Q(:,12),G2tensor(:,19))
  call loop_VV_S(G0(:,:,:,1),wf(:,5),G0(:,:,:,5))
  call check_last_ST_V(l_switch,G0(:,:,:,5),Q(:,19),wf(:,64),Q(:,12),G1tensor(:,6))
  call check_last_ST_V(l_switch,G0(:,:,:,5),Q(:,19),wf(:,2),Q(:,12),G1tensor(:,7))
  call check_last_SV_V(l_switch,G0(:,:,:,5),wf(:,13),G0tensor(:,1))
  call check_last_SV_V(l_switch,G0(:,:,:,5),wf(:,4),G0tensor(:,2))
  call loop_VV_S(G0(:,:,:,1),wf(:,5),G0(:,:,:,6))
  call check_last_TS_V(l_switch,G0(:,:,:,6),Q(:,19),wf(:,2),Q(:,12),G1tensor(:,8))
  call check_last_SV_V(l_switch,G0(:,:,:,6),wf(:,4),G0tensor(:,3))
  call loop_QZ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,7),gZl)
  call loop_Q_A(G0(:,:,:,7),Q(:,19),ZERO,G1(:,:,:,20))
  call loop_QV_A(G1(:,:,:,20),wf(:,13),G1(:,:,:,21))
  call check_last_Q_A(l_switch,G1(:,:,:,21),Q(:,31),ZERO,G2tensor(:,20))
  call loop_QZ_A(G1(:,:,:,20),wf(:,4),G1(:,:,:,22),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,22),Q(:,31),ZERO,G2tensor(:,21))
  call loop_QZ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,8),gZu)
  call loop_Q_A(G0(:,:,:,8),Q(:,19),ZERO,G1(:,:,:,23))
  call loop_QV_A(G1(:,:,:,23),wf(:,13),G1(:,:,:,24))
  call check_last_Q_A(l_switch,G1(:,:,:,24),Q(:,31),ZERO,G2tensor(:,22))
  call loop_QZ_A(G1(:,:,:,23),wf(:,4),G1(:,:,:,25),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,25),Q(:,31),ZERO,G2tensor(:,23))
  call loop_QZ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,9),gZd)
  call loop_Q_A(G0(:,:,:,9),Q(:,19),ZERO,G1(:,:,:,26))
  call loop_QV_A(G1(:,:,:,26),wf(:,13),G1(:,:,:,27))
  call check_last_Q_A(l_switch,G1(:,:,:,27),Q(:,31),ZERO,G2tensor(:,24))
  call loop_QZ_A(G1(:,:,:,26),wf(:,4),G1(:,:,:,28),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,28),Q(:,31),ZERO,G2tensor(:,25))
  call loop_QZ_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,10),gZn)
  call loop_Q_A(G0(:,:,:,10),Q(:,19),ZERO,G1(:,:,:,29))
  call loop_QZ_A(G1(:,:,:,29),wf(:,4),G1(:,:,:,30),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,30),Q(:,31),ZERO,G2tensor(:,26))
  call loop_QS_A(G0(:,:,:,1),wf(:,69),G0(:,:,:,11),gH)
  call loop_Q_A(G0(:,:,:,11),Q(:,28),MM,G1(:,:,:,31))
  call loop_QZ_A(G1(:,:,:,31),wf(:,1),G1(:,:,:,32),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,32),Q(:,31),MM,G2tensor(:,27))
  call loop_QS_A(G0(:,:,:,1),wf(:,69),G0(:,:,:,12),gH)
  call loop_Q_A(G0(:,:,:,12),Q(:,28),ML,G1(:,:,:,33))
  call loop_QZ_A(G1(:,:,:,33),wf(:,1),G1(:,:,:,34),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,34),Q(:,31),ML,G2tensor(:,28))
  call loop_QS_A(G0(:,:,:,1),wf(:,69),G0(:,:,:,13),gH)
  call loop_Q_A(G0(:,:,:,13),Q(:,28),MT,G1(:,:,:,35))
  call loop_QZ_A(G1(:,:,:,35),wf(:,1),G1(:,:,:,36),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,36),Q(:,31),MT,G2tensor(:,29))
  call loop_QS_A(G0(:,:,:,1),wf(:,69),G0(:,:,:,14),gH)
  call loop_Q_A(G0(:,:,:,14),Q(:,28),MB,G1(:,:,:,37))
  call loop_QZ_A(G1(:,:,:,37),wf(:,1),G1(:,:,:,38),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,38),Q(:,31),MB,G2tensor(:,30))
  call loop_QS_A(G0(:,:,:,1),wf(:,39),G0(:,:,:,15),gX)
  call loop_Q_A(G0(:,:,:,15),Q(:,28),MM,G1(:,:,:,39))
  call loop_QZ_A(G1(:,:,:,39),wf(:,1),G1(:,:,:,40),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,40),Q(:,31),MM,G2tensor(:,31))
  call loop_QS_A(G0(:,:,:,1),wf(:,39),G0(:,:,:,16),gX)
  call loop_Q_A(G0(:,:,:,16),Q(:,28),ML,G1(:,:,:,41))
  call loop_QZ_A(G1(:,:,:,41),wf(:,1),G1(:,:,:,42),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,42),Q(:,31),ML,G2tensor(:,32))
  call loop_QS_A(G0(:,:,:,1),wf(:,39),G0(:,:,:,17),gX)
  call loop_Q_A(G0(:,:,:,17),Q(:,28),MT,G1(:,:,:,43))
  call loop_QZ_A(G1(:,:,:,43),wf(:,1),G1(:,:,:,44),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,44),Q(:,31),MT,G2tensor(:,33))
  call loop_QS_A(G0(:,:,:,1),wf(:,39),G0(:,:,:,18),gX)
  call loop_Q_A(G0(:,:,:,18),Q(:,28),MB,G1(:,:,:,45))
  call loop_QZ_A(G1(:,:,:,45),wf(:,1),G1(:,:,:,46),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,46),Q(:,31),MB,G2tensor(:,34))
  call loop_SS_S(G0(:,:,:,1),wf(:,69),G0(:,:,:,19))
  call check_last_TV_S(l_switch,G0(:,:,:,19),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,9))
  call loop_SS_S(G0(:,:,:,1),wf(:,39),G0(:,:,:,20))
  call check_last_TV_S(l_switch,G0(:,:,:,20),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,10))
  call loop_SS_S(G0(:,:,:,1),wf(:,69),G0(:,:,:,21))
  call check_last_CV_D(l_switch,G0(:,:,:,21),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,11))
  call loop_SS_S(G0(:,:,:,1),wf(:,39),G0(:,:,:,22))
  call check_last_CV_D(l_switch,G0(:,:,:,22),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,12))
  call loop_VS_V(G0(:,:,:,1),wf(:,69),G0(:,:,:,23))
  call check_last_UV_W(l_switch,G0(:,:,:,23),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,13))
  call loop_VT_S(G0(:,:,:,1),Q(:,0),wf(:,69),Q(:,28),G1(:,:,:,47))
  call check_last_SV_V(l_switch,G1(:,:,:,47),wf(:,1),G1tensor(:,14))
  call loop_VS_T(G0(:,:,:,1),Q(:,0),wf(:,39),Q(:,28),G1(:,:,:,48))
  call check_last_SV_V(l_switch,G1(:,:,:,48),wf(:,1),G1tensor(:,15))
  call loop_VT_S(G0(:,:,:,1),Q(:,0),wf(:,39),Q(:,28),G1(:,:,:,49))
  call check_last_SV_V(l_switch,G1(:,:,:,49),wf(:,1),G1tensor(:,16))
  call loop_QZ_A(G0(:,:,:,1),wf(:,42),G0(:,:,:,24),gZn)
  call loop_Q_A(G0(:,:,:,24),Q(:,28),ZERO,G1(:,:,:,50))
  call loop_QZ_A(G1(:,:,:,50),wf(:,1),G1(:,:,:,51),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,51),Q(:,31),ZERO,G2tensor(:,35))
  call loop_QZ_A(G0(:,:,:,1),wf(:,42),G0(:,:,:,25),gZl)
  call loop_Q_A(G0(:,:,:,25),Q(:,28),ZERO,G1(:,:,:,52))
  call loop_QZ_A(G1(:,:,:,52),wf(:,1),G1(:,:,:,53),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,53),Q(:,31),ZERO,G2tensor(:,36))
  call loop_QZ_A(G0(:,:,:,1),wf(:,42),G0(:,:,:,26),gZl)
  call loop_Q_A(G0(:,:,:,26),Q(:,28),MM,G1(:,:,:,54))
  call loop_QZ_A(G1(:,:,:,54),wf(:,1),G1(:,:,:,55),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,55),Q(:,31),MM,G2tensor(:,37))
  call loop_QZ_A(G0(:,:,:,1),wf(:,42),G0(:,:,:,27),gZl)
  call loop_Q_A(G0(:,:,:,27),Q(:,28),ML,G1(:,:,:,56))
  call loop_QZ_A(G1(:,:,:,56),wf(:,1),G1(:,:,:,57),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,57),Q(:,31),ML,G2tensor(:,38))
  call loop_QZ_A(G0(:,:,:,1),wf(:,42),G0(:,:,:,28),gZu)
  call loop_Q_A(G0(:,:,:,28),Q(:,28),ZERO,G1(:,:,:,58))
  call loop_QZ_A(G1(:,:,:,58),wf(:,1),G1(:,:,:,59),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,59),Q(:,31),ZERO,G2tensor(:,39))
  call loop_QZ_A(G0(:,:,:,1),wf(:,42),G0(:,:,:,29),gZu)
  call loop_Q_A(G0(:,:,:,29),Q(:,28),MT,G1(:,:,:,60))
  call loop_QZ_A(G1(:,:,:,60),wf(:,1),G1(:,:,:,61),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,61),Q(:,31),MT,G2tensor(:,40))
  call loop_QZ_A(G0(:,:,:,1),wf(:,42),G0(:,:,:,30),gZd)
  call loop_Q_A(G0(:,:,:,30),Q(:,28),ZERO,G1(:,:,:,62))
  call loop_QZ_A(G1(:,:,:,62),wf(:,1),G1(:,:,:,63),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,63),Q(:,31),ZERO,G2tensor(:,41))
  call loop_QZ_A(G0(:,:,:,1),wf(:,42),G0(:,:,:,31),gZd)
  call loop_Q_A(G0(:,:,:,31),Q(:,28),MB,G1(:,:,:,64))
  call loop_QZ_A(G1(:,:,:,64),wf(:,1),G1(:,:,:,65),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,65),Q(:,31),MB,G2tensor(:,42))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,42),Q(:,28),G1(:,:,:,66))
  call check_last_TV_S(l_switch,G1(:,:,:,66),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,43))
  call loop_TV_S(G0(:,:,:,1),Q(:,0),wf(:,42),Q(:,28),G1(:,:,:,67))
  call check_last_TV_S(l_switch,G1(:,:,:,67),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,44))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,42),Q(:,28),G1(:,:,:,68))
  call check_last_CV_D(l_switch,G1(:,:,:,68),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,45))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,42),Q(:,28),G1(:,:,:,69))
  call check_last_UV_W(l_switch,G1(:,:,:,69),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,46))
  call loop_VV_S(G0(:,:,:,1),wf(:,42),G0(:,:,:,32))
  call check_last_SV_V(l_switch,G0(:,:,:,32),wf(:,1),G0tensor(:,4))
  call loop_VV_S(G0(:,:,:,1),wf(:,42),G0(:,:,:,33))
  call check_last_SV_V(l_switch,G0(:,:,:,33),wf(:,1),G0tensor(:,5))
  call loop_QS_A(G0(:,:,:,1),wf(:,41),G0(:,:,:,34),gX)
  call loop_Q_A(G0(:,:,:,34),Q(:,28),MM,G1(:,:,:,70))
  call loop_QZ_A(G1(:,:,:,70),wf(:,1),G1(:,:,:,71),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,71),Q(:,31),MM,G2tensor(:,47))
  call loop_QS_A(G0(:,:,:,1),wf(:,41),G0(:,:,:,35),gX)
  call loop_Q_A(G0(:,:,:,35),Q(:,28),ML,G1(:,:,:,72))
  call loop_QZ_A(G1(:,:,:,72),wf(:,1),G1(:,:,:,73),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,73),Q(:,31),ML,G2tensor(:,48))
  call loop_QS_A(G0(:,:,:,1),wf(:,41),G0(:,:,:,36),gX)
  call loop_Q_A(G0(:,:,:,36),Q(:,28),MT,G1(:,:,:,74))
  call loop_QZ_A(G1(:,:,:,74),wf(:,1),G1(:,:,:,75),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,75),Q(:,31),MT,G2tensor(:,49))
  call loop_QS_A(G0(:,:,:,1),wf(:,41),G0(:,:,:,37),gX)
  call loop_Q_A(G0(:,:,:,37),Q(:,28),MB,G1(:,:,:,76))
  call loop_QZ_A(G1(:,:,:,76),wf(:,1),G1(:,:,:,77),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,77),Q(:,31),MB,G2tensor(:,50))
  call loop_SS_S(G0(:,:,:,1),wf(:,41),G0(:,:,:,38))
  call check_last_TV_S(l_switch,G0(:,:,:,38),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,17))
  call loop_SS_S(G0(:,:,:,1),wf(:,41),G0(:,:,:,39))
  call check_last_CV_D(l_switch,G0(:,:,:,39),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,18))
  call loop_VS_T(G0(:,:,:,1),Q(:,0),wf(:,41),Q(:,28),G1(:,:,:,78))
  call check_last_SV_V(l_switch,G1(:,:,:,78),wf(:,1),G1tensor(:,19))
  call loop_VT_S(G0(:,:,:,1),Q(:,0),wf(:,41),Q(:,28),G1(:,:,:,79))
  call check_last_SV_V(l_switch,G1(:,:,:,79),wf(:,1),G1tensor(:,20))
  call loop_QZ_A(G0(:,:,:,1),wf(:,44),G0(:,:,:,40),gZn)
  call loop_Q_A(G0(:,:,:,40),Q(:,28),ZERO,G1(:,:,:,80))
  call loop_QZ_A(G1(:,:,:,80),wf(:,1),G1(:,:,:,81),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,81),Q(:,31),ZERO,G2tensor(:,51))
  call loop_QZ_A(G0(:,:,:,1),wf(:,44),G0(:,:,:,41),gZl)
  call loop_Q_A(G0(:,:,:,41),Q(:,28),ZERO,G1(:,:,:,82))
  call loop_QZ_A(G1(:,:,:,82),wf(:,1),G1(:,:,:,83),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,83),Q(:,31),ZERO,G2tensor(:,52))
  call loop_QZ_A(G0(:,:,:,1),wf(:,44),G0(:,:,:,42),gZl)
  call loop_Q_A(G0(:,:,:,42),Q(:,28),MM,G1(:,:,:,84))
  call loop_QZ_A(G1(:,:,:,84),wf(:,1),G1(:,:,:,85),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,85),Q(:,31),MM,G2tensor(:,53))
  call loop_QZ_A(G0(:,:,:,1),wf(:,44),G0(:,:,:,43),gZl)
  call loop_Q_A(G0(:,:,:,43),Q(:,28),ML,G1(:,:,:,86))
  call loop_QZ_A(G1(:,:,:,86),wf(:,1),G1(:,:,:,87),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,87),Q(:,31),ML,G2tensor(:,54))
  call loop_QZ_A(G0(:,:,:,1),wf(:,44),G0(:,:,:,44),gZu)
  call loop_Q_A(G0(:,:,:,44),Q(:,28),ZERO,G1(:,:,:,88))
  call loop_QZ_A(G1(:,:,:,88),wf(:,1),G1(:,:,:,89),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,89),Q(:,31),ZERO,G2tensor(:,55))
  call loop_QZ_A(G0(:,:,:,1),wf(:,44),G0(:,:,:,45),gZu)
  call loop_Q_A(G0(:,:,:,45),Q(:,28),MT,G1(:,:,:,90))
  call loop_QZ_A(G1(:,:,:,90),wf(:,1),G1(:,:,:,91),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,91),Q(:,31),MT,G2tensor(:,56))
  call loop_QZ_A(G0(:,:,:,1),wf(:,44),G0(:,:,:,46),gZd)
  call loop_Q_A(G0(:,:,:,46),Q(:,28),ZERO,G1(:,:,:,92))
  call loop_QZ_A(G1(:,:,:,92),wf(:,1),G1(:,:,:,93),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,93),Q(:,31),ZERO,G2tensor(:,57))
  call loop_QZ_A(G0(:,:,:,1),wf(:,44),G0(:,:,:,47),gZd)
  call loop_Q_A(G0(:,:,:,47),Q(:,28),MB,G1(:,:,:,94))
  call loop_QZ_A(G1(:,:,:,94),wf(:,1),G1(:,:,:,95),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,95),Q(:,31),MB,G2tensor(:,58))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,44),Q(:,28),G1(:,:,:,96))
  call check_last_TV_S(l_switch,G1(:,:,:,96),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,59))
  call loop_TV_S(G0(:,:,:,1),Q(:,0),wf(:,44),Q(:,28),G1(:,:,:,97))
  call check_last_TV_S(l_switch,G1(:,:,:,97),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,60))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,44),Q(:,28),G1(:,:,:,98))
  call check_last_CV_D(l_switch,G1(:,:,:,98),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,61))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,44),Q(:,28),G1(:,:,:,99))
  call check_last_UV_W(l_switch,G1(:,:,:,99),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,62))
  call loop_VV_S(G0(:,:,:,1),wf(:,44),G0(:,:,:,48))
  call check_last_SV_V(l_switch,G0(:,:,:,48),wf(:,1),G0tensor(:,6))
  call loop_VV_S(G0(:,:,:,1),wf(:,44),G0(:,:,:,49))
  call check_last_SV_V(l_switch,G0(:,:,:,49),wf(:,1),G0tensor(:,7))
  call loop_AQ_S(G0(:,:,:,1),wf(:,7),G0(:,:,:,50),gH)
  call loop_SA_Q(G0(:,:,:,50),wf(:,56),G0(:,:,:,51),gH)
  call check_last_A_Q(l_switch,G0(:,:,:,51),Q(:,31),MB,G1tensor(:,21))
  call loop_AQ_S(G0(:,:,:,1),wf(:,7),G0(:,:,:,52),gX)
  call loop_SA_Q(G0(:,:,:,52),wf(:,56),G0(:,:,:,53),gX)
  call check_last_A_Q(l_switch,G0(:,:,:,53),Q(:,31),MB,G1tensor(:,22))
  call loop_AQ_S(G0(:,:,:,1),wf(:,7),G0(:,:,:,54),gPtb)
  call loop_SA_Q(G0(:,:,:,54),wf(:,56),G0(:,:,:,55),gPbt)
  call check_last_A_Q(l_switch,G0(:,:,:,55),Q(:,31),MT,G1tensor(:,23))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,7),G0(:,:,:,56),gZd)
  call loop_ZA_Q(G0(:,:,:,56),wf(:,56),G0(:,:,:,57),gZd)
  call check_last_A_Q(l_switch,G0(:,:,:,57),Q(:,31),MB,G1tensor(:,24))
  call loop_AQ_W(G0(:,:,:,1),wf(:,7),G0(:,:,:,58))
  call loop_WA_Q(G0(:,:,:,58),wf(:,56),G0(:,:,:,59))
  call check_last_A_Q(l_switch,G0(:,:,:,59),Q(:,31),MT,G1tensor(:,25))
  call loop_QS_A(G0(:,:,:,1),wf(:,70),G0(:,:,:,60),gH)
  call loop_Q_A(G0(:,:,:,60),Q(:,28),MM,G1(:,:,:,100))
  call loop_QZ_A(G1(:,:,:,100),wf(:,1),G1(:,:,:,101),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,101),Q(:,31),MM,G2tensor(:,63))
  call loop_QS_A(G0(:,:,:,1),wf(:,70),G0(:,:,:,61),gH)
  call loop_Q_A(G0(:,:,:,61),Q(:,28),ML,G1(:,:,:,102))
  call loop_QZ_A(G1(:,:,:,102),wf(:,1),G1(:,:,:,103),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,103),Q(:,31),ML,G2tensor(:,64))
  call loop_QS_A(G0(:,:,:,1),wf(:,70),G0(:,:,:,62),gH)
  call loop_Q_A(G0(:,:,:,62),Q(:,28),MT,G1(:,:,:,104))
  call loop_QZ_A(G1(:,:,:,104),wf(:,1),G1(:,:,:,105),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,105),Q(:,31),MT,G2tensor(:,65))
  call loop_QS_A(G0(:,:,:,1),wf(:,70),G0(:,:,:,63),gH)
  call loop_Q_A(G0(:,:,:,63),Q(:,28),MB,G1(:,:,:,106))
  call loop_QZ_A(G1(:,:,:,106),wf(:,1),G1(:,:,:,107),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,107),Q(:,31),MB,G2tensor(:,66))
  call loop_QS_A(G0(:,:,:,1),wf(:,51),G0(:,:,:,64),gX)
  call loop_Q_A(G0(:,:,:,64),Q(:,28),MM,G1(:,:,:,108))
  call loop_QZ_A(G1(:,:,:,108),wf(:,1),G1(:,:,:,109),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,109),Q(:,31),MM,G2tensor(:,67))
  call loop_QS_A(G0(:,:,:,1),wf(:,51),G0(:,:,:,65),gX)
  call loop_Q_A(G0(:,:,:,65),Q(:,28),ML,G1(:,:,:,110))
  call loop_QZ_A(G1(:,:,:,110),wf(:,1),G1(:,:,:,111),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,111),Q(:,31),ML,G2tensor(:,68))
  call loop_QS_A(G0(:,:,:,1),wf(:,51),G0(:,:,:,66),gX)
  call loop_Q_A(G0(:,:,:,66),Q(:,28),MT,G1(:,:,:,112))
  call loop_QZ_A(G1(:,:,:,112),wf(:,1),G1(:,:,:,113),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,113),Q(:,31),MT,G2tensor(:,69))
  call loop_QS_A(G0(:,:,:,1),wf(:,51),G0(:,:,:,67),gX)
  call loop_Q_A(G0(:,:,:,67),Q(:,28),MB,G1(:,:,:,114))
  call loop_QZ_A(G1(:,:,:,114),wf(:,1),G1(:,:,:,115),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,115),Q(:,31),MB,G2tensor(:,70))
  call loop_SS_S(G0(:,:,:,1),wf(:,70),G0(:,:,:,68))
  call check_last_TV_S(l_switch,G0(:,:,:,68),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,26))
  call loop_SS_S(G0(:,:,:,1),wf(:,51),G0(:,:,:,69))
  call check_last_TV_S(l_switch,G0(:,:,:,69),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,27))
  call loop_SS_S(G0(:,:,:,1),wf(:,70),G0(:,:,:,70))
  call check_last_CV_D(l_switch,G0(:,:,:,70),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,28))
  call loop_SS_S(G0(:,:,:,1),wf(:,51),G0(:,:,:,71))
  call check_last_CV_D(l_switch,G0(:,:,:,71),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,29))
  call loop_VS_V(G0(:,:,:,1),wf(:,70),G0(:,:,:,72))
  call check_last_UV_W(l_switch,G0(:,:,:,72),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,30))
  call loop_VT_S(G0(:,:,:,1),Q(:,0),wf(:,70),Q(:,28),G1(:,:,:,116))
  call check_last_SV_V(l_switch,G1(:,:,:,116),wf(:,1),G1tensor(:,31))
  call loop_VS_T(G0(:,:,:,1),Q(:,0),wf(:,51),Q(:,28),G1(:,:,:,117))
  call check_last_SV_V(l_switch,G1(:,:,:,117),wf(:,1),G1tensor(:,32))
  call loop_VT_S(G0(:,:,:,1),Q(:,0),wf(:,51),Q(:,28),G1(:,:,:,118))
  call check_last_SV_V(l_switch,G1(:,:,:,118),wf(:,1),G1tensor(:,33))
  call loop_QV_A(G0(:,:,:,1),wf(:,52),G0(:,:,:,73))
  call loop_Q_A(G0(:,:,:,73),Q(:,28),ZERO,G1(:,:,:,119))
  call loop_QZ_A(G1(:,:,:,119),wf(:,1),G1(:,:,:,120),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,120),Q(:,31),ZERO,G2tensor(:,71))
  call loop_QZ_A(G1(:,:,:,119),wf(:,1),G1(:,:,:,121),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,121),Q(:,31),ZERO,G2tensor(:,72))
  call loop_QZ_A(G1(:,:,:,119),wf(:,1),G1(:,:,:,122),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,122),Q(:,31),ZERO,G2tensor(:,73))
  call loop_QV_A(G0(:,:,:,1),wf(:,52),G0(:,:,:,74))
  call loop_Q_A(G0(:,:,:,74),Q(:,28),MM,G1(:,:,:,123))
  call loop_QZ_A(G1(:,:,:,123),wf(:,1),G1(:,:,:,124),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,124),Q(:,31),MM,G2tensor(:,74))
  call loop_QV_A(G0(:,:,:,1),wf(:,52),G0(:,:,:,75))
  call loop_Q_A(G0(:,:,:,75),Q(:,28),ML,G1(:,:,:,125))
  call loop_QZ_A(G1(:,:,:,125),wf(:,1),G1(:,:,:,126),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,126),Q(:,31),ML,G2tensor(:,75))
  call loop_QV_A(G0(:,:,:,1),wf(:,52),G0(:,:,:,76))
  call loop_Q_A(G0(:,:,:,76),Q(:,28),MT,G1(:,:,:,127))
  call loop_QZ_A(G1(:,:,:,127),wf(:,1),G1(:,:,:,128),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,128),Q(:,31),MT,G2tensor(:,76))
  call loop_QV_A(G0(:,:,:,1),wf(:,52),G0(:,:,:,77))
  call loop_Q_A(G0(:,:,:,77),Q(:,28),MB,G1(:,:,:,129))
  call loop_QZ_A(G1(:,:,:,129),wf(:,1),G1(:,:,:,130),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,130),Q(:,31),MB,G2tensor(:,77))
  call loop_QZ_A(G0(:,:,:,1),wf(:,54),G0(:,:,:,78),gZn)
  call loop_Q_A(G0(:,:,:,78),Q(:,28),ZERO,G1(:,:,:,131))
  call loop_QZ_A(G1(:,:,:,131),wf(:,1),G1(:,:,:,132),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,132),Q(:,31),ZERO,G2tensor(:,78))
  call loop_QZ_A(G0(:,:,:,1),wf(:,54),G0(:,:,:,79),gZl)
  call loop_Q_A(G0(:,:,:,79),Q(:,28),ZERO,G1(:,:,:,133))
  call loop_QZ_A(G1(:,:,:,133),wf(:,1),G1(:,:,:,134),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,134),Q(:,31),ZERO,G2tensor(:,79))
  call loop_QZ_A(G0(:,:,:,1),wf(:,54),G0(:,:,:,80),gZl)
  call loop_Q_A(G0(:,:,:,80),Q(:,28),MM,G1(:,:,:,135))
  call loop_QZ_A(G1(:,:,:,135),wf(:,1),G1(:,:,:,136),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,136),Q(:,31),MM,G2tensor(:,80))
  call loop_QZ_A(G0(:,:,:,1),wf(:,54),G0(:,:,:,81),gZl)
  call loop_Q_A(G0(:,:,:,81),Q(:,28),ML,G1(:,:,:,137))
  call loop_QZ_A(G1(:,:,:,137),wf(:,1),G1(:,:,:,138),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,138),Q(:,31),ML,G2tensor(:,81))
  call loop_QZ_A(G0(:,:,:,1),wf(:,54),G0(:,:,:,82),gZu)
  call loop_Q_A(G0(:,:,:,82),Q(:,28),ZERO,G1(:,:,:,139))
  call loop_QZ_A(G1(:,:,:,139),wf(:,1),G1(:,:,:,140),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,140),Q(:,31),ZERO,G2tensor(:,82))
  call loop_QZ_A(G0(:,:,:,1),wf(:,54),G0(:,:,:,83),gZu)
  call loop_Q_A(G0(:,:,:,83),Q(:,28),MT,G1(:,:,:,141))
  call loop_QZ_A(G1(:,:,:,141),wf(:,1),G1(:,:,:,142),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,142),Q(:,31),MT,G2tensor(:,83))
  call loop_QZ_A(G0(:,:,:,1),wf(:,54),G0(:,:,:,84),gZd)
  call loop_Q_A(G0(:,:,:,84),Q(:,28),ZERO,G1(:,:,:,143))
  call loop_QZ_A(G1(:,:,:,143),wf(:,1),G1(:,:,:,144),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,144),Q(:,31),ZERO,G2tensor(:,84))
  call loop_QZ_A(G0(:,:,:,1),wf(:,54),G0(:,:,:,85),gZd)
  call loop_Q_A(G0(:,:,:,85),Q(:,28),MB,G1(:,:,:,145))
  call loop_QZ_A(G1(:,:,:,145),wf(:,1),G1(:,:,:,146),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,146),Q(:,31),MB,G2tensor(:,85))
  call loop_TV_S(G0(:,:,:,1),Q(:,0),wf(:,52),Q(:,28),G1(:,:,:,147))
  call check_last_TV_S(l_switch,G1(:,:,:,147),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,86))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,54),Q(:,28),G1(:,:,:,148))
  call check_last_TV_S(l_switch,G1(:,:,:,148),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,87))
  call loop_TV_S(G0(:,:,:,1),Q(:,0),wf(:,54),Q(:,28),G1(:,:,:,149))
  call check_last_TV_S(l_switch,G1(:,:,:,149),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,88))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,52),Q(:,28),G1(:,:,:,150))
  call check_last_CV_D(l_switch,G1(:,:,:,150),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,89))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,54),Q(:,28),G1(:,:,:,151))
  call check_last_CV_D(l_switch,G1(:,:,:,151),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,90))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,52),Q(:,28),G1(:,:,:,152))
  call check_last_UV_W(l_switch,G1(:,:,:,152),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,91))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,54),Q(:,28),G1(:,:,:,153))
  call check_last_UV_W(l_switch,G1(:,:,:,153),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,92))
  call loop_VV_S(G0(:,:,:,1),wf(:,52),G0(:,:,:,86))
  call check_last_SV_V(l_switch,G0(:,:,:,86),wf(:,1),G0tensor(:,8))
  call loop_VV_S(G0(:,:,:,1),wf(:,54),G0(:,:,:,87))
  call check_last_SV_V(l_switch,G0(:,:,:,87),wf(:,1),G0tensor(:,9))
  call loop_VV_S(G0(:,:,:,1),wf(:,54),G0(:,:,:,88))
  call check_last_SV_V(l_switch,G0(:,:,:,88),wf(:,1),G0tensor(:,10))
  call loop_SA_Q(G0(:,:,:,1),wf(:,10),G0(:,:,:,89),gH)
  call loop_A_Q(G0(:,:,:,89),Q(:,24),MB,G1(:,:,:,154))
  call check_last_AQ_S(l_switch,G1(:,:,:,154),wf(:,62),G1tensor(:,34),gH)
  call loop_SA_Q(G0(:,:,:,1),wf(:,10),G0(:,:,:,90),gX)
  call loop_A_Q(G0(:,:,:,90),Q(:,24),MB,G1(:,:,:,155))
  call check_last_AQ_S(l_switch,G1(:,:,:,155),wf(:,62),G1tensor(:,35),gX)
  call loop_SA_Q(G0(:,:,:,1),wf(:,10),G0(:,:,:,91),gPbt)
  call loop_A_Q(G0(:,:,:,91),Q(:,24),MT,G1(:,:,:,156))
  call check_last_AQ_S(l_switch,G1(:,:,:,156),wf(:,62),G1tensor(:,36),gPtb)
  call loop_ZA_Q(G0(:,:,:,1),wf(:,10),G0(:,:,:,92),gZd)
  call loop_A_Q(G0(:,:,:,92),Q(:,24),MB,G1(:,:,:,157))
  call check_last_AQ_Z(l_switch,G1(:,:,:,157),wf(:,62),G1tensor(:,37),gZd)
  call loop_WA_Q(G0(:,:,:,1),wf(:,10),G0(:,:,:,93))
  call loop_A_Q(G0(:,:,:,93),Q(:,24),MT,G1(:,:,:,158))
  call check_last_AQ_W(l_switch,G1(:,:,:,158),wf(:,62),G1tensor(:,38))
  call loop_QS_A(G0(:,:,:,1),wf(:,71),G0(:,:,:,94),gH)
  call loop_Q_A(G0(:,:,:,94),Q(:,28),MM,G1(:,:,:,159))
  call loop_QZ_A(G1(:,:,:,159),wf(:,1),G1(:,:,:,160),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,160),Q(:,31),MM,G2tensor(:,93))
  call loop_QS_A(G0(:,:,:,1),wf(:,71),G0(:,:,:,95),gH)
  call loop_Q_A(G0(:,:,:,95),Q(:,28),ML,G1(:,:,:,161))
  call loop_QZ_A(G1(:,:,:,161),wf(:,1),G1(:,:,:,162),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,162),Q(:,31),ML,G2tensor(:,94))
  call loop_QS_A(G0(:,:,:,1),wf(:,71),G0(:,:,:,96),gH)
  call loop_Q_A(G0(:,:,:,96),Q(:,28),MT,G1(:,:,:,163))
  call loop_QZ_A(G1(:,:,:,163),wf(:,1),G1(:,:,:,164),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,164),Q(:,31),MT,G2tensor(:,95))
  call loop_QS_A(G0(:,:,:,1),wf(:,71),G0(:,:,:,97),gH)
  call loop_Q_A(G0(:,:,:,97),Q(:,28),MB,G1(:,:,:,165))
  call loop_QZ_A(G1(:,:,:,165),wf(:,1),G1(:,:,:,166),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,166),Q(:,31),MB,G2tensor(:,96))
  call loop_QS_A(G0(:,:,:,1),wf(:,58),G0(:,:,:,98),gX)
  call loop_Q_A(G0(:,:,:,98),Q(:,28),MM,G1(:,:,:,167))
  call loop_QZ_A(G1(:,:,:,167),wf(:,1),G1(:,:,:,168),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,168),Q(:,31),MM,G2tensor(:,97))
  call loop_QS_A(G0(:,:,:,1),wf(:,58),G0(:,:,:,99),gX)
  call loop_Q_A(G0(:,:,:,99),Q(:,28),ML,G1(:,:,:,169))
  call loop_QZ_A(G1(:,:,:,169),wf(:,1),G1(:,:,:,170),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,170),Q(:,31),ML,G2tensor(:,98))
  call loop_QS_A(G0(:,:,:,1),wf(:,58),G0(:,:,:,100),gX)
  call loop_Q_A(G0(:,:,:,100),Q(:,28),MT,G1(:,:,:,171))
  call loop_QZ_A(G1(:,:,:,171),wf(:,1),G1(:,:,:,172),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,172),Q(:,31),MT,G2tensor(:,99))
  call loop_QS_A(G0(:,:,:,1),wf(:,58),G0(:,:,:,101),gX)
  call loop_Q_A(G0(:,:,:,101),Q(:,28),MB,G1(:,:,:,173))
  call loop_QZ_A(G1(:,:,:,173),wf(:,1),G1(:,:,:,174),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,174),Q(:,31),MB,G2tensor(:,100))
  call loop_SS_S(G0(:,:,:,1),wf(:,71),G0(:,:,:,102))
  call check_last_TV_S(l_switch,G0(:,:,:,102),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,39))
  call loop_SS_S(G0(:,:,:,1),wf(:,58),G0(:,:,:,103))
  call check_last_TV_S(l_switch,G0(:,:,:,103),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,40))
  call loop_SS_S(G0(:,:,:,1),wf(:,71),G0(:,:,:,104))
  call check_last_CV_D(l_switch,G0(:,:,:,104),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,41))
  call loop_SS_S(G0(:,:,:,1),wf(:,58),G0(:,:,:,105))
  call check_last_CV_D(l_switch,G0(:,:,:,105),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,42))
  call loop_VS_V(G0(:,:,:,1),wf(:,71),G0(:,:,:,106))
  call check_last_UV_W(l_switch,G0(:,:,:,106),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,43))
  call loop_VT_S(G0(:,:,:,1),Q(:,0),wf(:,71),Q(:,28),G1(:,:,:,175))
  call check_last_SV_V(l_switch,G1(:,:,:,175),wf(:,1),G1tensor(:,44))
  call loop_VS_T(G0(:,:,:,1),Q(:,0),wf(:,58),Q(:,28),G1(:,:,:,176))
  call check_last_SV_V(l_switch,G1(:,:,:,176),wf(:,1),G1tensor(:,45))
  call loop_VT_S(G0(:,:,:,1),Q(:,0),wf(:,58),Q(:,28),G1(:,:,:,177))
  call check_last_SV_V(l_switch,G1(:,:,:,177),wf(:,1),G1tensor(:,46))
  call loop_QV_A(G0(:,:,:,1),wf(:,59),G0(:,:,:,107))
  call loop_Q_A(G0(:,:,:,107),Q(:,28),ZERO,G1(:,:,:,178))
  call loop_QZ_A(G1(:,:,:,178),wf(:,1),G1(:,:,:,179),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,179),Q(:,31),ZERO,G2tensor(:,101))
  call loop_QZ_A(G1(:,:,:,178),wf(:,1),G1(:,:,:,180),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,180),Q(:,31),ZERO,G2tensor(:,102))
  call loop_QZ_A(G1(:,:,:,178),wf(:,1),G1(:,:,:,181),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,181),Q(:,31),ZERO,G2tensor(:,103))
  call loop_QV_A(G0(:,:,:,1),wf(:,59),G0(:,:,:,108))
  call loop_Q_A(G0(:,:,:,108),Q(:,28),MM,G1(:,:,:,182))
  call loop_QZ_A(G1(:,:,:,182),wf(:,1),G1(:,:,:,183),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,183),Q(:,31),MM,G2tensor(:,104))
  call loop_QV_A(G0(:,:,:,1),wf(:,59),G0(:,:,:,109))
  call loop_Q_A(G0(:,:,:,109),Q(:,28),ML,G1(:,:,:,184))
  call loop_QZ_A(G1(:,:,:,184),wf(:,1),G1(:,:,:,185),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,185),Q(:,31),ML,G2tensor(:,105))
  call loop_QV_A(G0(:,:,:,1),wf(:,59),G0(:,:,:,110))
  call loop_Q_A(G0(:,:,:,110),Q(:,28),MT,G1(:,:,:,186))
  call loop_QZ_A(G1(:,:,:,186),wf(:,1),G1(:,:,:,187),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,187),Q(:,31),MT,G2tensor(:,106))
  call loop_QV_A(G0(:,:,:,1),wf(:,59),G0(:,:,:,111))
  call loop_Q_A(G0(:,:,:,111),Q(:,28),MB,G1(:,:,:,188))
  call loop_QZ_A(G1(:,:,:,188),wf(:,1),G1(:,:,:,189),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,189),Q(:,31),MB,G2tensor(:,107))
  call loop_QZ_A(G0(:,:,:,1),wf(:,60),G0(:,:,:,112),gZn)
  call loop_Q_A(G0(:,:,:,112),Q(:,28),ZERO,G1(:,:,:,190))
  call loop_QZ_A(G1(:,:,:,190),wf(:,1),G1(:,:,:,191),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,191),Q(:,31),ZERO,G2tensor(:,108))
  call loop_QZ_A(G0(:,:,:,1),wf(:,60),G0(:,:,:,113),gZl)
  call loop_Q_A(G0(:,:,:,113),Q(:,28),ZERO,G1(:,:,:,192))
  call loop_QZ_A(G1(:,:,:,192),wf(:,1),G1(:,:,:,193),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,193),Q(:,31),ZERO,G2tensor(:,109))
  call loop_QZ_A(G0(:,:,:,1),wf(:,60),G0(:,:,:,114),gZl)
  call loop_Q_A(G0(:,:,:,114),Q(:,28),MM,G1(:,:,:,194))
  call loop_QZ_A(G1(:,:,:,194),wf(:,1),G1(:,:,:,195),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,195),Q(:,31),MM,G2tensor(:,110))
  call loop_QZ_A(G0(:,:,:,1),wf(:,60),G0(:,:,:,115),gZl)
  call loop_Q_A(G0(:,:,:,115),Q(:,28),ML,G1(:,:,:,196))
  call loop_QZ_A(G1(:,:,:,196),wf(:,1),G1(:,:,:,197),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,197),Q(:,31),ML,G2tensor(:,111))
  call loop_QZ_A(G0(:,:,:,1),wf(:,60),G0(:,:,:,116),gZu)
  call loop_Q_A(G0(:,:,:,116),Q(:,28),ZERO,G1(:,:,:,198))
  call loop_QZ_A(G1(:,:,:,198),wf(:,1),G1(:,:,:,199),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,199),Q(:,31),ZERO,G2tensor(:,112))
  call loop_QZ_A(G0(:,:,:,1),wf(:,60),G0(:,:,:,117),gZu)
  call loop_Q_A(G0(:,:,:,117),Q(:,28),MT,G1(:,:,:,200))
  call loop_QZ_A(G1(:,:,:,200),wf(:,1),G1(:,:,:,201),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,201),Q(:,31),MT,G2tensor(:,113))
  call loop_QZ_A(G0(:,:,:,1),wf(:,60),G0(:,:,:,118),gZd)
  call loop_Q_A(G0(:,:,:,118),Q(:,28),ZERO,G1(:,:,:,202))
  call loop_QZ_A(G1(:,:,:,202),wf(:,1),G1(:,:,:,203),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,203),Q(:,31),ZERO,G2tensor(:,114))
  call loop_QZ_A(G0(:,:,:,1),wf(:,60),G0(:,:,:,119),gZd)
  call loop_Q_A(G0(:,:,:,119),Q(:,28),MB,G1(:,:,:,204))
  call loop_QZ_A(G1(:,:,:,204),wf(:,1),G1(:,:,:,205),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,205),Q(:,31),MB,G2tensor(:,115))
  call loop_TV_S(G0(:,:,:,1),Q(:,0),wf(:,59),Q(:,28),G1(:,:,:,206))
  call check_last_TV_S(l_switch,G1(:,:,:,206),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,116))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,60),Q(:,28),G1(:,:,:,207))
  call check_last_TV_S(l_switch,G1(:,:,:,207),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,117))
  call loop_TV_S(G0(:,:,:,1),Q(:,0),wf(:,60),Q(:,28),G1(:,:,:,208))
  call check_last_TV_S(l_switch,G1(:,:,:,208),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,118))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,59),Q(:,28),G1(:,:,:,209))
  call check_last_CV_D(l_switch,G1(:,:,:,209),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,119))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,60),Q(:,28),G1(:,:,:,210))
  call check_last_CV_D(l_switch,G1(:,:,:,210),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,120))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,59),Q(:,28),G1(:,:,:,211))
  call check_last_UV_W(l_switch,G1(:,:,:,211),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,121))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,60),Q(:,28),G1(:,:,:,212))
  call check_last_UV_W(l_switch,G1(:,:,:,212),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,122))
  call loop_VV_S(G0(:,:,:,1),wf(:,59),G0(:,:,:,120))
  call check_last_SV_V(l_switch,G0(:,:,:,120),wf(:,1),G0tensor(:,11))
  call loop_VV_S(G0(:,:,:,1),wf(:,60),G0(:,:,:,121))
  call check_last_SV_V(l_switch,G0(:,:,:,121),wf(:,1),G0tensor(:,12))
  call loop_VV_S(G0(:,:,:,1),wf(:,60),G0(:,:,:,122))
  call check_last_SV_V(l_switch,G0(:,:,:,122),wf(:,1),G0tensor(:,13))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(154)*M(2)) * den(45)
  T2sum(1:15,54) = T2sum(1:15,54) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(156)*M(2)) * den(45)
  T2sum(1:15,55) = T2sum(1:15,55) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(153)*M(2)) * den(45)
  T2sum(1:15,56) = T2sum(1:15,56) + Gcoeff * G2tensor(:,9)
  Gcoeff = (-(c(154)*M(2))) * den(18)
  T2sum(1:15,54) = T2sum(1:15,54) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(156)*M(2)) * den(18)
  T2sum(1:15,55) = T2sum(1:15,55) + Gcoeff * G2tensor(:,6)
  Gcoeff = (-(c(153)*M(2))) * den(18)
  T2sum(1:15,56) = T2sum(1:15,56) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(126)*M(2)) * den(45)
  T2sum(1:5,51) = T2sum(1:5,51) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(33)*M(2)) * den(18)
  T2sum(1:5,52) = T2sum(1:5,52) + Gcoeff * G1tensor(:,2)
  Gcoeff = (-(c(44)*M(2))) * den(45)
  T2sum(1:5,51) = T2sum(1:5,51) + Gcoeff * G1tensor(:,3)
  Gcoeff = (c(44)*M(2)) * den(45)
  T2sum(1:5,51) = T2sum(1:5,51) + Gcoeff * G1tensor(:,3)
  Gcoeff = (c(44)*M(2)) * den(18)
  T2sum(1:5,51) = T2sum(1:5,51) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(44)*M(2)) * den(18)
  T2sum(1:5,51) = T2sum(1:5,51) + Gcoeff * G1tensor(:,4)
  Gcoeff = (-(c(45)*M(2))) * den(45)
  T2sum(1:5,51) = T2sum(1:5,51) + Gcoeff * G1tensor(:,5)
  Gcoeff = (-(c(97)*M(2))) * den(45)
  T2sum(1:5,51) = T2sum(1:5,51) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(97)*M(2)) * den(45)
  T2sum(1:5,51) = T2sum(1:5,51) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(42)*M(2)) * den(18)
  T2sum(1:5,52) = T2sum(1:5,52) + Gcoeff * G1tensor(:,8)
  Gcoeff = (-(c(97)*M(2))) * den(18)
  T2sum(1:5,51) = T2sum(1:5,51) + Gcoeff * G1tensor(:,7)
  Gcoeff = (-(c(97)*M(2))) * den(18)
  T2sum(1:5,51) = T2sum(1:5,51) + Gcoeff * G1tensor(:,7)
  Gcoeff = (-(c(184)*M(2))) * den(19)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,20)
  Gcoeff = (-(c(184)*M(2))) * den(19)
  T2sum(1:15,54) = T2sum(1:15,54) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(185)*M(2)) * den(19)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(183)*M(2)) * den(19)
  T2sum(1:15,55) = T2sum(1:15,55) + Gcoeff * G2tensor(:,7)
  Gcoeff = (-(c(183)*M(2))) * den(19)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,24)
  Gcoeff = (-(c(182)*M(2))) * den(19)
  T2sum(1:15,56) = T2sum(1:15,56) + Gcoeff * G2tensor(:,11)
  Gcoeff = (-(c(189)*M(2))) * den(18)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,26)
  Gcoeff = (-(c(186)*M(2))) * den(18)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,21)
  Gcoeff = (-(c(186)*M(2))) * den(18)
  T2sum(1:15,54) = T2sum(1:15,54) + Gcoeff * G2tensor(:,4)
  Gcoeff = (-(c(188)*M(2))) * den(18)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,23)
  Gcoeff = (-(c(187)*M(2))) * den(18)
  T2sum(1:15,55) = T2sum(1:15,55) + Gcoeff * G2tensor(:,8)
  Gcoeff = (-(c(188)*M(2))) * den(18)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,25)
  Gcoeff = (-(c(187)*M(2))) * den(18)
  T2sum(1:15,56) = T2sum(1:15,56) + Gcoeff * G2tensor(:,12)
  Gcoeff = (-(c(127)*M(2))) * den(19)
  T2sum(1:15,51) = T2sum(1:15,51) + Gcoeff * G2tensor(:,13)
  Gcoeff = (-(c(71)*M(2))) * den(18)
  T2sum(1:15,52) = T2sum(1:15,52) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(132)*M(2)) * den(18)
  T2sum(1:15,51) = T2sum(1:15,51) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(93)*M(2)) * den(19)
  T2sum(1:15,51) = T2sum(1:15,51) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(93)*M(2)) * den(19)
  T2sum(1:15,51) = T2sum(1:15,51) + Gcoeff * G2tensor(:,16)
  Gcoeff = (-(c(70)*M(2))) * den(18)
  T2sum(1:15,51) = T2sum(1:15,51) + Gcoeff * G2tensor(:,17)
  Gcoeff = (-(c(70)*M(2))) * den(18)
  T2sum(1:15,51) = T2sum(1:15,51) + Gcoeff * G2tensor(:,17)
  Gcoeff = (-(c(93)*M(2))) * den(19)
  T2sum(1:15,51) = T2sum(1:15,51) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(70)*M(2)) * den(18)
  T2sum(1:15,51) = T2sum(1:15,51) + Gcoeff * G2tensor(:,19)
  Gcoeff = (-(c(5)*M(2))) * den(19)
  T2sum(1:1,51) = T2sum(1:1,51) + Gcoeff * G0tensor(:,1)
  Gcoeff = (-(c(5)*M(2))) * den(19)
  T2sum(1:1,51) = T2sum(1:1,51) + Gcoeff * G0tensor(:,1)
  Gcoeff = (-(c(78)*M(2))) * den(18)
  T2sum(1:1,52) = T2sum(1:1,52) + Gcoeff * G0tensor(:,3)
  Gcoeff = (-(c(110)*M(2))) * den(18)
  T2sum(1:1,51) = T2sum(1:1,51) + Gcoeff * G0tensor(:,2)
  Gcoeff = (-(c(110)*M(2))) * den(18)
  T2sum(1:1,51) = T2sum(1:1,51) + Gcoeff * G0tensor(:,2)
  Gcoeff = (c(147)*M(2)) * den(46)
  T2sum(1:15,58) = T2sum(1:15,58) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(143)*M(2)) * den(46)
  T2sum(1:15,59) = T2sum(1:15,59) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(151)*M(2)) * den(46)
  T2sum(1:15,60) = T2sum(1:15,60) + Gcoeff * G2tensor(:,29)
  Gcoeff = (c(140)*M(2)) * den(46)
  T2sum(1:15,61) = T2sum(1:15,61) + Gcoeff * G2tensor(:,30)
  Gcoeff = (-(c(146)*M(2))) * den(15)
  T2sum(1:15,58) = T2sum(1:15,58) + Gcoeff * G2tensor(:,31)
  Gcoeff = (-(c(142)*M(2))) * den(15)
  T2sum(1:15,59) = T2sum(1:15,59) + Gcoeff * G2tensor(:,32)
  Gcoeff = (c(150)*M(2)) * den(15)
  T2sum(1:15,60) = T2sum(1:15,60) + Gcoeff * G2tensor(:,33)
  Gcoeff = (-(c(139)*M(2))) * den(15)
  T2sum(1:15,61) = T2sum(1:15,61) + Gcoeff * G2tensor(:,34)
  Gcoeff = (c(117)*M(2)) * den(46)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,9)
  Gcoeff = (c(19)*M(2)) * den(15)
  T2sum(1:5,50) = T2sum(1:5,50) + Gcoeff * G1tensor(:,10)
  Gcoeff = (-(c(36)*M(2))) * den(46)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,11)
  Gcoeff = (c(36)*M(2)) * den(46)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,11)
  Gcoeff = (c(34)*M(2)) * den(15)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,12)
  Gcoeff = (c(34)*M(2)) * den(15)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,12)
  Gcoeff = (-(c(37)*M(2))) * den(46)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,13)
  Gcoeff = (c(88)*M(2)) * den(46)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,14)
  Gcoeff = (-(c(88)*M(2))) * den(46)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,14)
  Gcoeff = (c(33)*M(2)) * den(15)
  T2sum(1:5,50) = T2sum(1:5,50) + Gcoeff * G1tensor(:,15)
  Gcoeff = (-(c(87)*M(2))) * den(15)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,16)
  Gcoeff = (-(c(87)*M(2))) * den(15)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,16)
  Gcoeff = (c(161)*M(2)) * den(15)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,35)
  Gcoeff = (c(158)*M(2)) * den(15)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,36)
  Gcoeff = (c(158)*M(2)) * den(15)
  T2sum(1:15,58) = T2sum(1:15,58) + Gcoeff * G2tensor(:,37)
  Gcoeff = (c(158)*M(2)) * den(15)
  T2sum(1:15,59) = T2sum(1:15,59) + Gcoeff * G2tensor(:,38)
  Gcoeff = (c(160)*M(2)) * den(15)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,39)
  Gcoeff = (c(159)*M(2)) * den(15)
  T2sum(1:15,60) = T2sum(1:15,60) + Gcoeff * G2tensor(:,40)
  Gcoeff = (c(160)*M(2)) * den(15)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,41)
  Gcoeff = (c(159)*M(2)) * den(15)
  T2sum(1:15,61) = T2sum(1:15,61) + Gcoeff * G2tensor(:,42)
  Gcoeff = (c(24)*M(2)) * den(15)
  T2sum(1:15,50) = T2sum(1:15,50) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(122)*M(2)) * den(15)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,44)
  Gcoeff = (c(29)*M(2)) * den(15)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,45)
  Gcoeff = (c(29)*M(2)) * den(15)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,45)
  Gcoeff = (-(c(29)*M(2))) * den(15)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,46)
  Gcoeff = (c(42)*M(2)) * den(15)
  T2sum(1:1,50) = T2sum(1:1,50) + Gcoeff * G0tensor(:,4)
  Gcoeff = (c(2)*M(2)) * den(15)
  T2sum(1:1,49) = T2sum(1:1,49) + Gcoeff * G0tensor(:,5)
  Gcoeff = (c(2)*M(2)) * den(15)
  T2sum(1:1,49) = T2sum(1:1,49) + Gcoeff * G0tensor(:,5)
  Gcoeff = (c(165)*M(2)) * den(15)
  T2sum(1:15,58) = T2sum(1:15,58) + Gcoeff * G2tensor(:,47)
  Gcoeff = (c(163)*M(2)) * den(15)
  T2sum(1:15,59) = T2sum(1:15,59) + Gcoeff * G2tensor(:,48)
  Gcoeff = (-(c(167)*M(2))) * den(15)
  T2sum(1:15,60) = T2sum(1:15,60) + Gcoeff * G2tensor(:,49)
  Gcoeff = (c(159)*M(2)) * den(15)
  T2sum(1:15,61) = T2sum(1:15,61) + Gcoeff * G2tensor(:,50)
  Gcoeff = (-(c(62)*M(2))) * den(15)
  T2sum(1:5,50) = T2sum(1:5,50) + Gcoeff * G1tensor(:,17)
  Gcoeff = (-(c(68)*M(2))) * den(15)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,18)
  Gcoeff = (-(c(68)*M(2))) * den(15)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,18)
  Gcoeff = (-(c(71)*M(2))) * den(15)
  T2sum(1:5,50) = T2sum(1:5,50) + Gcoeff * G1tensor(:,19)
  Gcoeff = (c(104)*M(2)) * den(15)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,20)
  Gcoeff = (c(104)*M(2)) * den(15)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,20)
  Gcoeff = (-(c(189)*M(2))) * den(15)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,51)
  Gcoeff = (-(c(186)*M(2))) * den(15)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,52)
  Gcoeff = (-(c(186)*M(2))) * den(15)
  T2sum(1:15,58) = T2sum(1:15,58) + Gcoeff * G2tensor(:,53)
  Gcoeff = (-(c(186)*M(2))) * den(15)
  T2sum(1:15,59) = T2sum(1:15,59) + Gcoeff * G2tensor(:,54)
  Gcoeff = (-(c(188)*M(2))) * den(15)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,55)
  Gcoeff = (-(c(187)*M(2))) * den(15)
  T2sum(1:15,60) = T2sum(1:15,60) + Gcoeff * G2tensor(:,56)
  Gcoeff = (-(c(188)*M(2))) * den(15)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,57)
  Gcoeff = (-(c(187)*M(2))) * den(15)
  T2sum(1:15,61) = T2sum(1:15,61) + Gcoeff * G2tensor(:,58)
  Gcoeff = (-(c(71)*M(2))) * den(15)
  T2sum(1:15,50) = T2sum(1:15,50) + Gcoeff * G2tensor(:,59)
  Gcoeff = (c(132)*M(2)) * den(15)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,60)
  Gcoeff = (-(c(70)*M(2))) * den(15)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,61)
  Gcoeff = (-(c(70)*M(2))) * den(15)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,61)
  Gcoeff = (c(70)*M(2)) * den(15)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,62)
  Gcoeff = (-(c(78)*M(2))) * den(15)
  T2sum(1:1,50) = T2sum(1:1,50) + Gcoeff * G0tensor(:,6)
  Gcoeff = (-(c(110)*M(2))) * den(15)
  T2sum(1:1,49) = T2sum(1:1,49) + Gcoeff * G0tensor(:,7)
  Gcoeff = (-(c(110)*M(2))) * den(15)
  T2sum(1:1,49) = T2sum(1:1,49) + Gcoeff * G0tensor(:,7)
  Gcoeff = (-(c(49)*M(2))) * den(27)
  T1sum(1:5,10) = T1sum(1:5,10) + Gcoeff * G1tensor(:,21)
  Gcoeff = (c(49)*M(2)) * den(27)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,22)
  Gcoeff = (c(48)*M(2)) * den(27)
  T1sum(1:5,12) = T1sum(1:5,12) + Gcoeff * G1tensor(:,23)
  Gcoeff = (c(100)*M(2)) * den(27)
  T1sum(1:5,11) = T1sum(1:5,11) + Gcoeff * G1tensor(:,24)
  Gcoeff = (c(57)*M(2)) * den(27)
  T1sum(1:5,12) = T1sum(1:5,12) + Gcoeff * G1tensor(:,25)
  Gcoeff = (c(145)*M(2)) * den(47)
  T2sum(1:15,58) = T2sum(1:15,58) + Gcoeff * G2tensor(:,63)
  Gcoeff = (c(141)*M(2)) * den(47)
  T2sum(1:15,59) = T2sum(1:15,59) + Gcoeff * G2tensor(:,64)
  Gcoeff = (c(149)*M(2)) * den(47)
  T2sum(1:15,60) = T2sum(1:15,60) + Gcoeff * G2tensor(:,65)
  Gcoeff = (c(138)*M(2)) * den(47)
  T2sum(1:15,61) = T2sum(1:15,61) + Gcoeff * G2tensor(:,66)
  Gcoeff = (-(c(145)*M(2))) * den(21)
  T2sum(1:15,58) = T2sum(1:15,58) + Gcoeff * G2tensor(:,67)
  Gcoeff = (-(c(141)*M(2))) * den(21)
  T2sum(1:15,59) = T2sum(1:15,59) + Gcoeff * G2tensor(:,68)
  Gcoeff = (c(149)*M(2)) * den(21)
  T2sum(1:15,60) = T2sum(1:15,60) + Gcoeff * G2tensor(:,69)
  Gcoeff = (-(c(138)*M(2))) * den(21)
  T2sum(1:15,61) = T2sum(1:15,61) + Gcoeff * G2tensor(:,70)
  Gcoeff = (c(115)*M(2)) * den(47)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,26)
  Gcoeff = (c(17)*M(2)) * den(21)
  T2sum(1:5,50) = T2sum(1:5,50) + Gcoeff * G1tensor(:,27)
  Gcoeff = (-(c(31)*M(2))) * den(47)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,28)
  Gcoeff = (c(31)*M(2)) * den(47)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,28)
  Gcoeff = (c(31)*M(2)) * den(21)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,29)
  Gcoeff = (c(31)*M(2)) * den(21)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,29)
  Gcoeff = (-(c(32)*M(2))) * den(47)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,30)
  Gcoeff = (c(85)*M(2)) * den(47)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,31)
  Gcoeff = (-(c(85)*M(2))) * den(47)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,31)
  Gcoeff = (c(30)*M(2)) * den(21)
  T2sum(1:5,50) = T2sum(1:5,50) + Gcoeff * G1tensor(:,32)
  Gcoeff = (-(c(85)*M(2))) * den(21)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,33)
  Gcoeff = (-(c(85)*M(2))) * den(21)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,33)
  Gcoeff = (-(c(170)*M(2))) * den(24)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,71)
  Gcoeff = (-(c(170)*M(2))) * den(24)
  T2sum(1:15,58) = T2sum(1:15,58) + Gcoeff * G2tensor(:,74)
  Gcoeff = (-(c(170)*M(2))) * den(24)
  T2sum(1:15,59) = T2sum(1:15,59) + Gcoeff * G2tensor(:,75)
  Gcoeff = (c(171)*M(2)) * den(24)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,72)
  Gcoeff = (c(169)*M(2)) * den(24)
  T2sum(1:15,60) = T2sum(1:15,60) + Gcoeff * G2tensor(:,76)
  Gcoeff = (-(c(169)*M(2))) * den(24)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,73)
  Gcoeff = (-(c(168)*M(2))) * den(24)
  T2sum(1:15,61) = T2sum(1:15,61) + Gcoeff * G2tensor(:,77)
  Gcoeff = (-(c(175)*M(2))) * den(21)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,78)
  Gcoeff = (-(c(172)*M(2))) * den(21)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,79)
  Gcoeff = (-(c(172)*M(2))) * den(21)
  T2sum(1:15,58) = T2sum(1:15,58) + Gcoeff * G2tensor(:,80)
  Gcoeff = (-(c(172)*M(2))) * den(21)
  T2sum(1:15,59) = T2sum(1:15,59) + Gcoeff * G2tensor(:,81)
  Gcoeff = (-(c(174)*M(2))) * den(21)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,82)
  Gcoeff = (-(c(173)*M(2))) * den(21)
  T2sum(1:15,60) = T2sum(1:15,60) + Gcoeff * G2tensor(:,83)
  Gcoeff = (-(c(174)*M(2))) * den(21)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,84)
  Gcoeff = (-(c(173)*M(2))) * den(21)
  T2sum(1:15,61) = T2sum(1:15,61) + Gcoeff * G2tensor(:,85)
  Gcoeff = (-(c(123)*M(2))) * den(24)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,86)
  Gcoeff = (-(c(58)*M(2))) * den(21)
  T2sum(1:15,50) = T2sum(1:15,50) + Gcoeff * G2tensor(:,87)
  Gcoeff = (c(129)*M(2)) * den(21)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,88)
  Gcoeff = (c(83)*M(2)) * den(24)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,89)
  Gcoeff = (c(83)*M(2)) * den(24)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,89)
  Gcoeff = (-(c(60)*M(2))) * den(21)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,90)
  Gcoeff = (-(c(60)*M(2))) * den(21)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,90)
  Gcoeff = (-(c(83)*M(2))) * den(24)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,91)
  Gcoeff = (c(60)*M(2)) * den(21)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,92)
  Gcoeff = (-(c(3)*M(2))) * den(24)
  T2sum(1:1,49) = T2sum(1:1,49) + Gcoeff * G0tensor(:,8)
  Gcoeff = (-(c(3)*M(2))) * den(24)
  T2sum(1:1,49) = T2sum(1:1,49) + Gcoeff * G0tensor(:,8)
  Gcoeff = (-(c(76)*M(2))) * den(21)
  T2sum(1:1,50) = T2sum(1:1,50) + Gcoeff * G0tensor(:,9)
  Gcoeff = (-(c(108)*M(2))) * den(21)
  T2sum(1:1,49) = T2sum(1:1,49) + Gcoeff * G0tensor(:,10)
  Gcoeff = (-(c(108)*M(2))) * den(21)
  T2sum(1:1,49) = T2sum(1:1,49) + Gcoeff * G0tensor(:,10)
  Gcoeff = (-(c(49)*M(2))) * den(34)
  T1sum(1:5,14) = T1sum(1:5,14) + Gcoeff * G1tensor(:,34)
  Gcoeff = (c(49)*M(2)) * den(34)
  T1sum(1:5,15) = T1sum(1:5,15) + Gcoeff * G1tensor(:,35)
  Gcoeff = (c(48)*M(2)) * den(34)
  T1sum(1:5,16) = T1sum(1:5,16) + Gcoeff * G1tensor(:,36)
  Gcoeff = (c(100)*M(2)) * den(34)
  T1sum(1:5,15) = T1sum(1:5,15) + Gcoeff * G1tensor(:,37)
  Gcoeff = (c(57)*M(2)) * den(34)
  T1sum(1:5,16) = T1sum(1:5,16) + Gcoeff * G1tensor(:,38)
  Gcoeff = (c(145)*M(2)) * den(48)
  T2sum(1:15,58) = T2sum(1:15,58) + Gcoeff * G2tensor(:,93)
  Gcoeff = (c(141)*M(2)) * den(48)
  T2sum(1:15,59) = T2sum(1:15,59) + Gcoeff * G2tensor(:,94)
  Gcoeff = (c(149)*M(2)) * den(48)
  T2sum(1:15,60) = T2sum(1:15,60) + Gcoeff * G2tensor(:,95)
  Gcoeff = (c(138)*M(2)) * den(48)
  T2sum(1:15,61) = T2sum(1:15,61) + Gcoeff * G2tensor(:,96)
  Gcoeff = (-(c(145)*M(2))) * den(29)
  T2sum(1:15,58) = T2sum(1:15,58) + Gcoeff * G2tensor(:,97)
  Gcoeff = (-(c(141)*M(2))) * den(29)
  T2sum(1:15,59) = T2sum(1:15,59) + Gcoeff * G2tensor(:,98)
  Gcoeff = (c(149)*M(2)) * den(29)
  T2sum(1:15,60) = T2sum(1:15,60) + Gcoeff * G2tensor(:,99)
  Gcoeff = (-(c(138)*M(2))) * den(29)
  T2sum(1:15,61) = T2sum(1:15,61) + Gcoeff * G2tensor(:,100)
  Gcoeff = (c(115)*M(2)) * den(48)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,39)
  Gcoeff = (c(17)*M(2)) * den(29)
  T2sum(1:5,50) = T2sum(1:5,50) + Gcoeff * G1tensor(:,40)
  Gcoeff = (-(c(31)*M(2))) * den(48)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,41)
  Gcoeff = (c(31)*M(2)) * den(48)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,41)
  Gcoeff = (c(31)*M(2)) * den(29)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,42)
  Gcoeff = (c(31)*M(2)) * den(29)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,42)
  Gcoeff = (-(c(32)*M(2))) * den(48)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,43)
  Gcoeff = (c(85)*M(2)) * den(48)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,44)
  Gcoeff = (-(c(85)*M(2))) * den(48)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,44)
  Gcoeff = (c(30)*M(2)) * den(29)
  T2sum(1:5,50) = T2sum(1:5,50) + Gcoeff * G1tensor(:,45)
  Gcoeff = (-(c(85)*M(2))) * den(29)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,46)
  Gcoeff = (-(c(85)*M(2))) * den(29)
  T2sum(1:5,49) = T2sum(1:5,49) + Gcoeff * G1tensor(:,46)
  Gcoeff = (-(c(170)*M(2))) * den(31)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,101)
  Gcoeff = (-(c(170)*M(2))) * den(31)
  T2sum(1:15,58) = T2sum(1:15,58) + Gcoeff * G2tensor(:,104)
  Gcoeff = (-(c(170)*M(2))) * den(31)
  T2sum(1:15,59) = T2sum(1:15,59) + Gcoeff * G2tensor(:,105)
  Gcoeff = (c(171)*M(2)) * den(31)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,102)
  Gcoeff = (c(169)*M(2)) * den(31)
  T2sum(1:15,60) = T2sum(1:15,60) + Gcoeff * G2tensor(:,106)
  Gcoeff = (-(c(169)*M(2))) * den(31)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,103)
  Gcoeff = (-(c(168)*M(2))) * den(31)
  T2sum(1:15,61) = T2sum(1:15,61) + Gcoeff * G2tensor(:,107)
  Gcoeff = (-(c(175)*M(2))) * den(29)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,108)
  Gcoeff = (-(c(172)*M(2))) * den(29)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,109)
  Gcoeff = (-(c(172)*M(2))) * den(29)
  T2sum(1:15,58) = T2sum(1:15,58) + Gcoeff * G2tensor(:,110)
  Gcoeff = (-(c(172)*M(2))) * den(29)
  T2sum(1:15,59) = T2sum(1:15,59) + Gcoeff * G2tensor(:,111)
  Gcoeff = (-(c(174)*M(2))) * den(29)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,112)
  Gcoeff = (-(c(173)*M(2))) * den(29)
  T2sum(1:15,60) = T2sum(1:15,60) + Gcoeff * G2tensor(:,113)
  Gcoeff = (-(c(174)*M(2))) * den(29)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,114)
  Gcoeff = (-(c(173)*M(2))) * den(29)
  T2sum(1:15,61) = T2sum(1:15,61) + Gcoeff * G2tensor(:,115)
  Gcoeff = (-(c(123)*M(2))) * den(31)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,116)
  Gcoeff = (-(c(58)*M(2))) * den(29)
  T2sum(1:15,50) = T2sum(1:15,50) + Gcoeff * G2tensor(:,117)
  Gcoeff = (c(129)*M(2)) * den(29)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,118)
  Gcoeff = (c(83)*M(2)) * den(31)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,119)
  Gcoeff = (c(83)*M(2)) * den(31)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,119)
  Gcoeff = (-(c(60)*M(2))) * den(29)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,120)
  Gcoeff = (-(c(60)*M(2))) * den(29)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,120)
  Gcoeff = (-(c(83)*M(2))) * den(31)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,121)
  Gcoeff = (c(60)*M(2)) * den(29)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,122)
  Gcoeff = (-(c(3)*M(2))) * den(31)
  T2sum(1:1,49) = T2sum(1:1,49) + Gcoeff * G0tensor(:,11)
  Gcoeff = (-(c(3)*M(2))) * den(31)
  T2sum(1:1,49) = T2sum(1:1,49) + Gcoeff * G0tensor(:,11)
  Gcoeff = (-(c(76)*M(2))) * den(29)
  T2sum(1:1,50) = T2sum(1:1,50) + Gcoeff * G0tensor(:,12)
  Gcoeff = (-(c(108)*M(2))) * den(29)
  T2sum(1:1,49) = T2sum(1:1,49) + Gcoeff * G0tensor(:,13)
  Gcoeff = (-(c(108)*M(2))) * den(29)
  T2sum(1:1,49) = T2sum(1:1,49) + Gcoeff * G0tensor(:,13)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_2

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_2_pphll_ew_nenexbbxh_1_/**/REALKIND
