
module ol_vamp_1_pphll_ew_neexuxdh_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphll_ew_neexuxdh_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphll_ew_neexuxdh_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphll_ew_neexuxdh_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphll_ew_neexuxdh_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,105) :: G0
  complex(REALKIND), dimension(4,5,4,160) :: G1
  complex(REALKIND), dimension(4,15,4,25) :: G2
  complex(REALKIND), dimension(1,22) :: G0tensor
  complex(REALKIND), dimension(5,33) :: G1tensor
  complex(REALKIND), dimension(15,91) :: G2tensor
  complex(REALKIND), dimension(35,4) :: G3tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QW_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,12),MM,G1(:,:,:,1))
  call loop_QS_A(G1(:,:,:,1),wf(:,-4),G1(:,:,:,2),gH)
  call loop_Q_A(G1(:,:,:,2),Q(:,28),MM,G2(:,:,:,1))
  call loop_QW_A(G2(:,:,:,1),wf(:,1),G2(:,:,:,2))
  call check_last_Q_A(l_switch,G2(:,:,:,2),Q(:,31),ZERO,G3tensor(:,1))
  call loop_QW_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,12),ML,G1(:,:,:,3))
  call loop_QS_A(G1(:,:,:,3),wf(:,-4),G1(:,:,:,4),gH)
  call loop_Q_A(G1(:,:,:,4),Q(:,28),ML,G2(:,:,:,3))
  call loop_QW_A(G2(:,:,:,3),wf(:,1),G2(:,:,:,4))
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,31),ZERO,G3tensor(:,2))
  call loop_AW_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,12),MT,G1(:,:,:,5))
  call loop_AS_Q(G1(:,:,:,5),wf(:,-4),G1(:,:,:,6),gH)
  call loop_A_Q(G1(:,:,:,6),Q(:,28),MT,G2(:,:,:,5))
  call loop_AW_Q(G2(:,:,:,5),wf(:,1),G2(:,:,:,6))
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,31),MB,G3tensor(:,3))
  call loop_QW_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,12),MB,G1(:,:,:,7))
  call loop_QS_A(G1(:,:,:,7),wf(:,-4),G1(:,:,:,8),gH)
  call loop_Q_A(G1(:,:,:,8),Q(:,28),MB,G2(:,:,:,7))
  call loop_QW_A(G2(:,:,:,7),wf(:,1),G2(:,:,:,8))
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,31),MT,G3tensor(:,4))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,12),G1(:,:,:,9))
  call loop_SS_S(G1(:,:,:,9),wf(:,-4),G1(:,:,:,10))
  call check_last_TV_S(l_switch,G1(:,:,:,10),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,1))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,12),G1(:,:,:,11))
  call loop_SS_S(G1(:,:,:,11),wf(:,-4),G1(:,:,:,12))
  call check_last_TV_S(l_switch,G1(:,:,:,12),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,2))
  call loop_ST_V(G1(:,:,:,11),Q(:,12),wf(:,-4),Q(:,16),G2(:,:,:,9))
  call check_last_VV_S(l_switch,G2(:,:,:,9),wf(:,1),G2tensor(:,3))
  call loop_TV_S(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,12),G1(:,:,:,13))
  call loop_SS_S(G1(:,:,:,13),wf(:,-4),G1(:,:,:,14))
  call check_last_SV_T(l_switch,G1(:,:,:,14),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,4))
  call check_last_SV_T(l_switch,G1(:,:,:,14),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,5))
  call loop_ST_V(G1(:,:,:,13),Q(:,12),wf(:,-4),Q(:,16),G2(:,:,:,10))
  call check_last_VV_S(l_switch,G2(:,:,:,10),wf(:,1),G2tensor(:,6))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,2),G1(:,:,:,15))
  call loop_SS_S(G1(:,:,:,15),wf(:,-4),G1(:,:,:,16))
  call check_last_DV_C(l_switch,G1(:,:,:,16),Q(:,28),wf(:,1),G2tensor(:,7))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,12),G1(:,:,:,17))
  call loop_SS_S(G1(:,:,:,17),wf(:,-4),G1(:,:,:,18))
  call check_last_CV_D(l_switch,G1(:,:,:,18),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,8))
  call check_last_CV_D(l_switch,G1(:,:,:,18),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,9))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,12),G1(:,:,:,19))
  call loop_SS_S(G1(:,:,:,19),wf(:,-4),G1(:,:,:,20))
  call check_last_CV_D(l_switch,G1(:,:,:,20),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,10))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,2),G1(:,:,:,21))
  call loop_SS_S(G1(:,:,:,21),wf(:,-4),G1(:,:,:,22))
  call check_last_DV_C(l_switch,G1(:,:,:,22),Q(:,28),wf(:,1),G2tensor(:,11))
  call check_last_DV_C(l_switch,G1(:,:,:,22),Q(:,28),wf(:,1),G2tensor(:,12))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,12),G1(:,:,:,23))
  call loop_VS_V(G1(:,:,:,23),wf(:,-4),G1(:,:,:,24))
  call check_last_UV_W(l_switch,G1(:,:,:,24),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,13))
  call loop_UW_V(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,12),G1(:,:,:,25))
  call loop_VS_V(G1(:,:,:,25),wf(:,-4),G1(:,:,:,26))
  call check_last_UW_V(l_switch,G1(:,:,:,26),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,14))
  call check_last_UW_V(l_switch,G1(:,:,:,26),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,15))
  call loop_WQ_A(G1(:,:,:,26),wf(:,0),G1(:,:,:,27))
  call loop_Q_A(G1(:,:,:,27),Q(:,29),ZERO,G2(:,:,:,11))
  call check_last_QA_V(l_switch,G2(:,:,:,11),wf(:,-1),G2tensor(:,16))
  call loop_VT_S(G1(:,:,:,25),Q(:,12),wf(:,-4),Q(:,16),G2(:,:,:,12))
  call check_last_SV_V(l_switch,G2(:,:,:,12),wf(:,1),G2tensor(:,17))
  call check_last_SV_V(l_switch,G2(:,:,:,12),wf(:,1),G2tensor(:,18))
  call loop_VV_S(G0(:,:,:,1),wf(:,2),G0(:,:,:,6))
  call loop_SS_S(G0(:,:,:,6),wf(:,-4),G0(:,:,:,7))
  call check_last_SV_V(l_switch,G0(:,:,:,7),wf(:,1),G0tensor(:,1))
  call check_last_SV_V(l_switch,G0(:,:,:,7),wf(:,1),G0tensor(:,2))
  call loop_ST_V(G0(:,:,:,6),Q(:,12),wf(:,-4),Q(:,16),G1(:,:,:,28))
  call check_last_UW_V(l_switch,G1(:,:,:,28),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,19))
  call check_last_UW_V(l_switch,G1(:,:,:,28),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,20))
  call loop_WQ_A(G1(:,:,:,28),wf(:,0),G1(:,:,:,29))
  call loop_Q_A(G1(:,:,:,29),Q(:,29),ZERO,G2(:,:,:,13))
  call check_last_QA_V(l_switch,G2(:,:,:,13),wf(:,-1),G2tensor(:,21))
  call loop_VV_S(G0(:,:,:,1),wf(:,2),G0(:,:,:,8))
  call loop_SS_S(G0(:,:,:,8),wf(:,-4),G0(:,:,:,9))
  call check_last_SV_V(l_switch,G0(:,:,:,9),wf(:,1),G0tensor(:,3))
  call loop_SV_V(G0(:,:,:,1),wf(:,2),G0(:,:,:,10))
  call loop_VT_S(G0(:,:,:,10),Q(:,12),wf(:,-4),Q(:,16),G1(:,:,:,30))
  call check_last_TV_S(l_switch,G1(:,:,:,30),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,22))
  call loop_VS_V(G0(:,:,:,10),wf(:,-4),G0(:,:,:,11))
  call check_last_VV_S(l_switch,G0(:,:,:,11),wf(:,1),G0tensor(:,4))
  call loop_SV_V(G0(:,:,:,1),wf(:,2),G0(:,:,:,12))
  call loop_VT_S(G0(:,:,:,12),Q(:,12),wf(:,-4),Q(:,16),G1(:,:,:,31))
  call check_last_SV_T(l_switch,G1(:,:,:,31),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,23))
  call loop_VS_V(G0(:,:,:,12),wf(:,-4),G0(:,:,:,13))
  call check_last_VV_S(l_switch,G0(:,:,:,13),wf(:,1),G0tensor(:,5))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,-3),G0(:,:,:,14),gZd)
  call loop_VS_V(G0(:,:,:,14),wf(:,-4),G0(:,:,:,15))
  call loop_ZA_Q(G0(:,:,:,15),wf(:,17),G0(:,:,:,16),gZd)
  call check_last_A_Q(l_switch,G0(:,:,:,16),Q(:,31),ZERO,G1tensor(:,1))
  call loop_VS_V(G0(:,:,:,14),wf(:,6),G0(:,:,:,17))
  call loop_WA_Q(G0(:,:,:,17),wf(:,-2),G0(:,:,:,18))
  call check_last_A_Q(l_switch,G0(:,:,:,18),Q(:,31),ZERO,G1tensor(:,2))
  call loop_UV_W(G0(:,:,:,14),Q(:,8),wf(:,3),Q(:,19),G1(:,:,:,32))
  call loop_WA_Q(G1(:,:,:,32),wf(:,-2),G1(:,:,:,33))
  call check_last_A_Q(l_switch,G1(:,:,:,33),Q(:,31),ZERO,G2tensor(:,24))
  call loop_AQ_W(G0(:,:,:,1),wf(:,-3),G0(:,:,:,19))
  call loop_VS_V(G0(:,:,:,19),wf(:,-4),G0(:,:,:,20))
  call loop_WA_Q(G0(:,:,:,20),wf(:,17),G0(:,:,:,21))
  call check_last_A_Q(l_switch,G0(:,:,:,21),Q(:,31),ZERO,G1tensor(:,3))
  call loop_VS_V(G0(:,:,:,19),wf(:,6),G0(:,:,:,22))
  call loop_ZA_Q(G0(:,:,:,22),wf(:,-2),G0(:,:,:,23),gZu)
  call check_last_A_Q(l_switch,G0(:,:,:,23),Q(:,31),ZERO,G1tensor(:,4))
  call loop_UW_V(G0(:,:,:,19),Q(:,8),wf(:,3),Q(:,19),G1(:,:,:,34))
  call loop_ZA_Q(G1(:,:,:,34),wf(:,-2),G1(:,:,:,35),gZu)
  call check_last_A_Q(l_switch,G1(:,:,:,35),Q(:,31),ZERO,G2tensor(:,25))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,19),G0(:,:,:,24),gZu)
  call loop_VS_V(G0(:,:,:,24),wf(:,-4),G0(:,:,:,25))
  call loop_ZA_Q(G0(:,:,:,25),wf(:,-2),G0(:,:,:,26),gZu)
  call check_last_A_Q(l_switch,G0(:,:,:,26),Q(:,31),ZERO,G1tensor(:,5))
  call loop_AQ_W(G0(:,:,:,1),wf(:,19),G0(:,:,:,27))
  call loop_VS_V(G0(:,:,:,27),wf(:,-4),G0(:,:,:,28))
  call loop_WA_Q(G0(:,:,:,28),wf(:,-2),G0(:,:,:,29))
  call check_last_A_Q(l_switch,G0(:,:,:,29),Q(:,31),ZERO,G1tensor(:,6))
  call loop_VS_V(G0(:,:,:,1),wf(:,6),G0(:,:,:,30))
  call loop_WQ_A(G0(:,:,:,30),wf(:,-3),G0(:,:,:,31))
  call loop_Q_A(G0(:,:,:,31),Q(:,27),ZERO,G1(:,:,:,36))
  call check_last_QA_V(l_switch,G1(:,:,:,36),wf(:,-2),G1tensor(:,7))
  call loop_WA_Q(G0(:,:,:,30),wf(:,-2),G0(:,:,:,32))
  call loop_A_Q(G0(:,:,:,32),Q(:,23),ZERO,G1(:,:,:,37))
  call check_last_AQ_V(l_switch,G1(:,:,:,37),wf(:,-3),G1tensor(:,8))
  call check_last_UV_W(l_switch,G0(:,:,:,30),Q(:,19),wf(:,2),Q(:,12),G1tensor(:,9))
  call loop_VQ_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,33))
  call loop_Q_A(G0(:,:,:,33),Q(:,8),ZERO,G1(:,:,:,38))
  call loop_QW_A(G1(:,:,:,38),wf(:,3),G1(:,:,:,39))
  call loop_Q_A(G1(:,:,:,39),Q(:,27),ZERO,G2(:,:,:,14))
  call check_last_QA_V(l_switch,G2(:,:,:,14),wf(:,-2),G2tensor(:,26))
  call loop_QA_W(G1(:,:,:,38),wf(:,-2),G1(:,:,:,40))
  call loop_VT_S(G1(:,:,:,40),Q(:,12),wf(:,-4),Q(:,16),G2(:,:,:,15))
  call check_last_SV_V(l_switch,G2(:,:,:,15),wf(:,1),G2tensor(:,27))
  call loop_VS_V(G1(:,:,:,40),wf(:,-4),G1(:,:,:,41))
  call check_last_UW_V(l_switch,G1(:,:,:,41),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,28))
  call loop_WQ_A(G1(:,:,:,41),wf(:,0),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,29),ZERO,G2(:,:,:,16))
  call check_last_QA_V(l_switch,G2(:,:,:,16),wf(:,-1),G2tensor(:,29))
  call loop_ZQ_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,34),gZd)
  call loop_Q_A(G0(:,:,:,34),Q(:,8),ZERO,G1(:,:,:,43))
  call loop_QW_A(G1(:,:,:,43),wf(:,3),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,27),ZERO,G2(:,:,:,17))
  call check_last_QA_Z(l_switch,G2(:,:,:,17),wf(:,-2),G2tensor(:,30),gZu)
  call loop_QA_W(G1(:,:,:,43),wf(:,-2),G1(:,:,:,45))
  call loop_VT_S(G1(:,:,:,45),Q(:,12),wf(:,-4),Q(:,16),G2(:,:,:,18))
  call check_last_SV_V(l_switch,G2(:,:,:,18),wf(:,1),G2tensor(:,31))
  call loop_VS_V(G1(:,:,:,45),wf(:,-4),G1(:,:,:,46))
  call check_last_UW_V(l_switch,G1(:,:,:,46),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,32))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,3),Q(:,19),G1(:,:,:,47))
  call loop_WQ_A(G1(:,:,:,47),wf(:,-3),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,27),ZERO,G2(:,:,:,19))
  call check_last_QA_V(l_switch,G2(:,:,:,19),wf(:,-2),G2tensor(:,33))
  call loop_WA_Q(G1(:,:,:,47),wf(:,-2),G1(:,:,:,49))
  call loop_A_Q(G1(:,:,:,49),Q(:,23),ZERO,G2(:,:,:,20))
  call check_last_AQ_V(l_switch,G2(:,:,:,20),wf(:,-3),G2tensor(:,34))
  call check_last_UV_W(l_switch,G1(:,:,:,47),Q(:,19),wf(:,2),Q(:,12),G2tensor(:,35))
  call loop_WQ_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,35))
  call loop_Q_A(G0(:,:,:,35),Q(:,8),ZERO,G1(:,:,:,50))
  call loop_QA_Z(G1(:,:,:,50),wf(:,-2),G1(:,:,:,51),gZu)
  call loop_VS_V(G1(:,:,:,51),wf(:,-4),G1(:,:,:,52))
  call check_last_UV_W(l_switch,G1(:,:,:,52),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,36))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,36))
  call loop_A_Q(G0(:,:,:,36),Q(:,4),ZERO,G1(:,:,:,53))
  call loop_AQ_W(G1(:,:,:,53),wf(:,-3),G1(:,:,:,54))
  call loop_VT_S(G1(:,:,:,54),Q(:,12),wf(:,-4),Q(:,16),G2(:,:,:,21))
  call check_last_SV_V(l_switch,G2(:,:,:,21),wf(:,1),G2tensor(:,37))
  call loop_VS_V(G1(:,:,:,54),wf(:,-4),G1(:,:,:,55))
  call check_last_UW_V(l_switch,G1(:,:,:,55),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,38))
  call loop_WQ_A(G1(:,:,:,55),wf(:,0),G1(:,:,:,56))
  call loop_Q_A(G1(:,:,:,56),Q(:,29),ZERO,G2(:,:,:,22))
  call check_last_QA_V(l_switch,G2(:,:,:,22),wf(:,-1),G2tensor(:,39))
  call loop_ZA_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,37),gZu)
  call loop_A_Q(G0(:,:,:,37),Q(:,4),ZERO,G1(:,:,:,57))
  call loop_AQ_W(G1(:,:,:,57),wf(:,-3),G1(:,:,:,58))
  call loop_VT_S(G1(:,:,:,58),Q(:,12),wf(:,-4),Q(:,16),G2(:,:,:,23))
  call check_last_SV_V(l_switch,G2(:,:,:,23),wf(:,1),G2tensor(:,40))
  call loop_VS_V(G1(:,:,:,58),wf(:,-4),G1(:,:,:,59))
  call check_last_UW_V(l_switch,G1(:,:,:,59),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,41))
  call loop_WA_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,38))
  call loop_A_Q(G0(:,:,:,38),Q(:,4),ZERO,G1(:,:,:,60))
  call loop_AQ_Z(G1(:,:,:,60),wf(:,-3),G1(:,:,:,61),gZd)
  call loop_VS_V(G1(:,:,:,61),wf(:,-4),G1(:,:,:,62))
  call check_last_UV_W(l_switch,G1(:,:,:,62),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,42))
  call loop_QA_Z(G0(:,:,:,1),wf(:,-2),G0(:,:,:,39),gZu)
  call loop_VS_V(G0(:,:,:,39),wf(:,-4),G0(:,:,:,40))
  call loop_ZQ_A(G0(:,:,:,40),wf(:,-3),G0(:,:,:,41),gZd)
  call loop_Q_A(G0(:,:,:,41),Q(:,28),ZERO,G1(:,:,:,63))
  call loop_QW_A(G1(:,:,:,63),wf(:,1),G1(:,:,:,64))
  call check_last_Q_A(l_switch,G1(:,:,:,64),Q(:,31),ZERO,G2tensor(:,43))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,21),G0(:,:,:,42),gZl)
  call loop_VS_V(G0(:,:,:,42),wf(:,-4),G0(:,:,:,43))
  call loop_ZA_Q(G0(:,:,:,43),wf(:,-1),G0(:,:,:,44),gZl)
  call check_last_A_Q(l_switch,G0(:,:,:,44),Q(:,31),ZERO,G1tensor(:,10))
  call loop_AQ_W(G0(:,:,:,1),wf(:,21),G0(:,:,:,45))
  call loop_VS_V(G0(:,:,:,45),wf(:,-4),G0(:,:,:,46))
  call loop_WA_Q(G0(:,:,:,46),wf(:,-1),G0(:,:,:,47))
  call check_last_A_Q(l_switch,G0(:,:,:,47),Q(:,31),ZERO,G1tensor(:,11))
  call loop_QA_Z(G0(:,:,:,1),wf(:,23),G0(:,:,:,48),gZn)
  call loop_VS_V(G0(:,:,:,48),wf(:,-4),G0(:,:,:,49))
  call loop_ZQ_A(G0(:,:,:,49),wf(:,0),G0(:,:,:,50),gZn)
  call check_last_Q_A(l_switch,G0(:,:,:,50),Q(:,31),ZERO,G1tensor(:,12))
  call loop_QA_W(G0(:,:,:,1),wf(:,23),G0(:,:,:,51))
  call loop_VS_V(G0(:,:,:,51),wf(:,-4),G0(:,:,:,52))
  call loop_WQ_A(G0(:,:,:,52),wf(:,0),G0(:,:,:,53))
  call check_last_Q_A(l_switch,G0(:,:,:,53),Q(:,31),ZERO,G1tensor(:,13))
  call loop_VS_V(G0(:,:,:,1),wf(:,10),G0(:,:,:,54))
  call loop_WQ_A(G0(:,:,:,54),wf(:,0),G0(:,:,:,55))
  call loop_Q_A(G0(:,:,:,55),Q(:,29),ZERO,G1(:,:,:,65))
  call check_last_QA_V(l_switch,G1(:,:,:,65),wf(:,-1),G1tensor(:,14))
  call check_last_UW_V(l_switch,G0(:,:,:,54),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,15))
  call loop_QA_W(G0(:,:,:,1),wf(:,-1),G0(:,:,:,56))
  call loop_VS_V(G0(:,:,:,56),wf(:,10),G0(:,:,:,57))
  call loop_ZQ_A(G0(:,:,:,57),wf(:,0),G0(:,:,:,58),gZn)
  call check_last_Q_A(l_switch,G0(:,:,:,58),Q(:,31),ZERO,G1tensor(:,16))
  call loop_UV_W(G0(:,:,:,56),Q(:,2),wf(:,12),Q(:,28),G1(:,:,:,66))
  call loop_ZQ_A(G1(:,:,:,66),wf(:,0),G1(:,:,:,67),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,67),Q(:,31),ZERO,G2tensor(:,44))
  call loop_UV_W(G0(:,:,:,56),Q(:,2),wf(:,2),Q(:,12),G1(:,:,:,68))
  call loop_VS_V(G1(:,:,:,68),wf(:,-4),G1(:,:,:,69))
  call loop_ZQ_A(G1(:,:,:,69),wf(:,0),G1(:,:,:,70),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,70),Q(:,31),ZERO,G2tensor(:,45))
  call loop_VT_S(G0(:,:,:,56),Q(:,2),wf(:,-4),Q(:,16),G1(:,:,:,71))
  call loop_SV_V(G1(:,:,:,71),wf(:,2),G1(:,:,:,72))
  call loop_ZQ_A(G1(:,:,:,72),wf(:,0),G1(:,:,:,73),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,73),Q(:,31),ZERO,G2tensor(:,46))
  call loop_VS_V(G0(:,:,:,56),wf(:,-4),G0(:,:,:,59))
  call loop_UV_W(G0(:,:,:,59),Q(:,18),wf(:,2),Q(:,12),G1(:,:,:,74))
  call loop_ZQ_A(G1(:,:,:,74),wf(:,0),G1(:,:,:,75),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,75),Q(:,31),ZERO,G2tensor(:,47))
  call loop_WQ_A(G0(:,:,:,59),wf(:,-3),G0(:,:,:,60))
  call loop_Q_A(G0(:,:,:,60),Q(:,26),ZERO,G1(:,:,:,76))
  call loop_QA_Z(G1(:,:,:,76),wf(:,-2),G1(:,:,:,77),gZu)
  call loop_ZQ_A(G1(:,:,:,77),wf(:,0),G1(:,:,:,78),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,78),Q(:,31),ZERO,G2tensor(:,48))
  call loop_WA_Q(G0(:,:,:,59),wf(:,-2),G0(:,:,:,61))
  call loop_A_Q(G0(:,:,:,61),Q(:,22),ZERO,G1(:,:,:,79))
  call loop_AQ_Z(G1(:,:,:,79),wf(:,-3),G1(:,:,:,80),gZd)
  call loop_ZQ_A(G1(:,:,:,80),wf(:,0),G1(:,:,:,81),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,81),Q(:,31),ZERO,G2tensor(:,49))
  call loop_WA_Q(G0(:,:,:,56),wf(:,-2),G0(:,:,:,62))
  call loop_A_Q(G0(:,:,:,62),Q(:,6),ZERO,G1(:,:,:,82))
  call loop_AQ_Z(G1(:,:,:,82),wf(:,-3),G1(:,:,:,83),gZd)
  call loop_VS_V(G1(:,:,:,83),wf(:,-4),G1(:,:,:,84))
  call loop_ZQ_A(G1(:,:,:,84),wf(:,0),G1(:,:,:,85),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,85),Q(:,31),ZERO,G2tensor(:,50))
  call loop_WQ_A(G0(:,:,:,56),wf(:,-3),G0(:,:,:,63))
  call loop_Q_A(G0(:,:,:,63),Q(:,10),ZERO,G1(:,:,:,86))
  call loop_QA_Z(G1(:,:,:,86),wf(:,-2),G1(:,:,:,87),gZu)
  call loop_VS_V(G1(:,:,:,87),wf(:,-4),G1(:,:,:,88))
  call loop_ZQ_A(G1(:,:,:,88),wf(:,0),G1(:,:,:,89),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,89),Q(:,31),ZERO,G2tensor(:,51))
  call loop_QA_Z(G0(:,:,:,1),wf(:,-1),G0(:,:,:,64),gZl)
  call loop_VS_V(G0(:,:,:,64),wf(:,10),G0(:,:,:,65))
  call loop_WQ_A(G0(:,:,:,65),wf(:,0),G0(:,:,:,66))
  call check_last_Q_A(l_switch,G0(:,:,:,66),Q(:,31),ZERO,G1tensor(:,17))
  call loop_UW_V(G0(:,:,:,64),Q(:,2),wf(:,12),Q(:,28),G1(:,:,:,90))
  call loop_WQ_A(G1(:,:,:,90),wf(:,0),G1(:,:,:,91))
  call check_last_Q_A(l_switch,G1(:,:,:,91),Q(:,31),ZERO,G2tensor(:,52))
  call loop_VV_S(G0(:,:,:,64),wf(:,2),G0(:,:,:,67))
  call loop_ST_V(G0(:,:,:,67),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,92))
  call loop_WQ_A(G1(:,:,:,92),wf(:,0),G1(:,:,:,93))
  call check_last_Q_A(l_switch,G1(:,:,:,93),Q(:,31),ZERO,G2tensor(:,53))
  call loop_UW_V(G0(:,:,:,64),Q(:,2),wf(:,2),Q(:,12),G1(:,:,:,94))
  call loop_VS_V(G1(:,:,:,94),wf(:,-4),G1(:,:,:,95))
  call loop_WQ_A(G1(:,:,:,95),wf(:,0),G1(:,:,:,96))
  call check_last_Q_A(l_switch,G1(:,:,:,96),Q(:,31),ZERO,G2tensor(:,54))
  call loop_VS_V(G0(:,:,:,64),wf(:,-4),G0(:,:,:,68))
  call loop_UW_V(G0(:,:,:,68),Q(:,18),wf(:,2),Q(:,12),G1(:,:,:,97))
  call loop_WQ_A(G1(:,:,:,97),wf(:,0),G1(:,:,:,98))
  call check_last_Q_A(l_switch,G1(:,:,:,98),Q(:,31),ZERO,G2tensor(:,55))
  call loop_ZQ_A(G0(:,:,:,68),wf(:,-3),G0(:,:,:,69),gZd)
  call loop_Q_A(G0(:,:,:,69),Q(:,26),ZERO,G1(:,:,:,99))
  call loop_QA_W(G1(:,:,:,99),wf(:,-2),G1(:,:,:,100))
  call loop_WQ_A(G1(:,:,:,100),wf(:,0),G1(:,:,:,101))
  call check_last_Q_A(l_switch,G1(:,:,:,101),Q(:,31),ZERO,G2tensor(:,56))
  call loop_ZA_Q(G0(:,:,:,68),wf(:,-2),G0(:,:,:,70),gZu)
  call loop_A_Q(G0(:,:,:,70),Q(:,22),ZERO,G1(:,:,:,102))
  call loop_AQ_W(G1(:,:,:,102),wf(:,-3),G1(:,:,:,103))
  call loop_WQ_A(G1(:,:,:,103),wf(:,0),G1(:,:,:,104))
  call check_last_Q_A(l_switch,G1(:,:,:,104),Q(:,31),ZERO,G2tensor(:,57))
  call loop_ZA_Q(G0(:,:,:,64),wf(:,-2),G0(:,:,:,71),gZu)
  call loop_A_Q(G0(:,:,:,71),Q(:,6),ZERO,G1(:,:,:,105))
  call loop_AQ_W(G1(:,:,:,105),wf(:,-3),G1(:,:,:,106))
  call loop_VS_V(G1(:,:,:,106),wf(:,-4),G1(:,:,:,107))
  call loop_WQ_A(G1(:,:,:,107),wf(:,0),G1(:,:,:,108))
  call check_last_Q_A(l_switch,G1(:,:,:,108),Q(:,31),ZERO,G2tensor(:,58))
  call loop_ZQ_A(G0(:,:,:,64),wf(:,-3),G0(:,:,:,72),gZd)
  call loop_Q_A(G0(:,:,:,72),Q(:,10),ZERO,G1(:,:,:,109))
  call loop_QA_W(G1(:,:,:,109),wf(:,-2),G1(:,:,:,110))
  call loop_VS_V(G1(:,:,:,110),wf(:,-4),G1(:,:,:,111))
  call loop_WQ_A(G1(:,:,:,111),wf(:,0),G1(:,:,:,112))
  call check_last_Q_A(l_switch,G1(:,:,:,112),Q(:,31),ZERO,G2tensor(:,59))
  call loop_ZA_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,73),gZl)
  call loop_A_Q(G0(:,:,:,73),Q(:,2),ZERO,G1(:,:,:,113))
  call loop_AW_Q(G1(:,:,:,113),wf(:,12),G1(:,:,:,114))
  call loop_A_Q(G1(:,:,:,114),Q(:,30),ZERO,G2(:,:,:,24))
  call check_last_AQ_Z(l_switch,G2(:,:,:,24),wf(:,0),G2tensor(:,60),gZn)
  call loop_UW_V(G0(:,:,:,1),Q(:,0),wf(:,12),Q(:,28),G1(:,:,:,115))
  call loop_WQ_A(G1(:,:,:,115),wf(:,0),G1(:,:,:,116))
  call loop_Q_A(G1(:,:,:,116),Q(:,29),ZERO,G2(:,:,:,25))
  call check_last_QA_V(l_switch,G2(:,:,:,25),wf(:,-1),G2tensor(:,61))
  call check_last_UW_V(l_switch,G1(:,:,:,115),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,62))
  call loop_QW_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,74))
  call loop_Q_A(G0(:,:,:,74),Q(:,12),ZERO,G1(:,:,:,117))
  call loop_QA_Z(G1(:,:,:,117),wf(:,-1),G1(:,:,:,118),gZl)
  call loop_VS_V(G1(:,:,:,118),wf(:,-4),G1(:,:,:,119))
  call loop_ZQ_A(G1(:,:,:,119),wf(:,0),G1(:,:,:,120),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,120),Q(:,31),ZERO,G2tensor(:,63))
  call loop_SS_S(G0(:,:,:,1),wf(:,-4),G0(:,:,:,75))
  call check_last_SVV_S(l_switch,G0(:,:,:,75),wf(:,1),wf(:,2),G0tensor(:,6))
  call loop_SS_S(G0(:,:,:,1),wf(:,-4),G0(:,:,:,76))
  call check_last_SVV_S(l_switch,G0(:,:,:,76),wf(:,1),wf(:,2),G0tensor(:,7))
  call loop_SS_S(G0(:,:,:,1),wf(:,-4),G0(:,:,:,77))
  call check_last_SVV_S(l_switch,G0(:,:,:,77),wf(:,1),wf(:,2),G0tensor(:,8))
  call loop_VS_V(G0(:,:,:,1),wf(:,-4),G0(:,:,:,78))
  call check_last_VWW_V(l_switch,G0(:,:,:,78),wf(:,1),wf(:,2),G0tensor(:,9))
  call loop_VS_V(G0(:,:,:,1),wf(:,-4),G0(:,:,:,79))
  call check_last_WWV_V(l_switch,G0(:,:,:,79),wf(:,2),wf(:,1),G0tensor(:,10))
  call loop_VVS_S(G0(:,:,:,1),wf(:,2),wf(:,-4),G0(:,:,:,80))
  call check_last_SV_V(l_switch,G0(:,:,:,80),wf(:,1),G0tensor(:,11))
  call check_last_SV_V(l_switch,G0(:,:,:,80),wf(:,1),G0tensor(:,12))
  call loop_VVS_S(G0(:,:,:,1),wf(:,2),wf(:,-4),G0(:,:,:,81))
  call check_last_SV_V(l_switch,G0(:,:,:,81),wf(:,1),G0tensor(:,13))
  call loop_VVS_S(G0(:,:,:,1),wf(:,1),wf(:,-4),G0(:,:,:,82))
  call check_last_SV_V(l_switch,G0(:,:,:,82),wf(:,2),G0tensor(:,14))
  call check_last_SV_V(l_switch,G0(:,:,:,82),wf(:,2),G0tensor(:,15))
  call loop_VVS_S(G0(:,:,:,1),wf(:,1),wf(:,-4),G0(:,:,:,83))
  call check_last_SV_V(l_switch,G0(:,:,:,83),wf(:,2),G0tensor(:,16))
  call loop_QS_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,84),gPnl)
  call loop_Q_A(G0(:,:,:,84),Q(:,19),ZERO,G1(:,:,:,121))
  call loop_QW_A(G1(:,:,:,121),wf(:,2),G1(:,:,:,122))
  call check_last_Q_A(l_switch,G1(:,:,:,122),Q(:,31),MM,G2tensor(:,64))
  call loop_QW_A(G1(:,:,:,121),wf(:,2),G1(:,:,:,123))
  call check_last_Q_A(l_switch,G1(:,:,:,123),Q(:,31),ML,G2tensor(:,65))
  call loop_QS_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,85),gPtb)
  call loop_Q_A(G0(:,:,:,85),Q(:,19),MT,G1(:,:,:,124))
  call loop_QW_A(G1(:,:,:,124),wf(:,2),G1(:,:,:,125))
  call check_last_Q_A(l_switch,G1(:,:,:,125),Q(:,31),MB,G2tensor(:,66))
  call loop_SS_S(G0(:,:,:,1),wf(:,6),G0(:,:,:,86))
  call check_last_TV_S(l_switch,G0(:,:,:,86),Q(:,19),wf(:,2),Q(:,12),G1tensor(:,18))
  call loop_SS_S(G0(:,:,:,1),wf(:,6),G0(:,:,:,87))
  call check_last_CV_D(l_switch,G0(:,:,:,87),Q(:,19),wf(:,2),Q(:,12),G1tensor(:,19))
  call loop_SS_S(G0(:,:,:,1),wf(:,6),G0(:,:,:,88))
  call check_last_DV_C(l_switch,G0(:,:,:,88),Q(:,19),wf(:,2),G1tensor(:,20))
  call loop_SS_S(G0(:,:,:,1),wf(:,6),G0(:,:,:,89))
  call check_last_DV_C(l_switch,G0(:,:,:,89),Q(:,19),wf(:,2),G1tensor(:,21))
  call loop_VS_V(G0(:,:,:,1),wf(:,6),G0(:,:,:,90))
  call check_last_UW_V(l_switch,G0(:,:,:,90),Q(:,19),wf(:,2),Q(:,12),G1tensor(:,22))
  call loop_VS_T(G0(:,:,:,1),Q(:,0),wf(:,6),Q(:,19),G1(:,:,:,126))
  call check_last_SV_V(l_switch,G1(:,:,:,126),wf(:,2),G1tensor(:,23))
  call check_last_SV_V(l_switch,G1(:,:,:,126),wf(:,2),G1tensor(:,24))
  call loop_VS_T(G0(:,:,:,1),Q(:,0),wf(:,6),Q(:,19),G1(:,:,:,127))
  call check_last_SV_V(l_switch,G1(:,:,:,127),wf(:,2),G1tensor(:,25))
  call loop_QW_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,91))
  call loop_Q_A(G0(:,:,:,91),Q(:,19),ZERO,G1(:,:,:,128))
  call loop_QW_A(G1(:,:,:,128),wf(:,2),G1(:,:,:,129))
  call check_last_Q_A(l_switch,G1(:,:,:,129),Q(:,31),ZERO,G2tensor(:,67))
  call loop_QW_A(G1(:,:,:,128),wf(:,2),G1(:,:,:,130))
  call check_last_Q_A(l_switch,G1(:,:,:,130),Q(:,31),MM,G2tensor(:,68))
  call loop_QW_A(G1(:,:,:,128),wf(:,2),G1(:,:,:,131))
  call check_last_Q_A(l_switch,G1(:,:,:,131),Q(:,31),ML,G2tensor(:,69))
  call loop_QW_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,92))
  call loop_Q_A(G0(:,:,:,92),Q(:,19),MT,G1(:,:,:,132))
  call loop_QW_A(G1(:,:,:,132),wf(:,2),G1(:,:,:,133))
  call check_last_Q_A(l_switch,G1(:,:,:,133),Q(:,31),MB,G2tensor(:,70))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,3),Q(:,19),G1(:,:,:,134))
  call check_last_TV_S(l_switch,G1(:,:,:,134),Q(:,19),wf(:,2),Q(:,12),G2tensor(:,71))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,3),Q(:,19),G1(:,:,:,135))
  call check_last_TV_S(l_switch,G1(:,:,:,135),Q(:,19),wf(:,2),Q(:,12),G2tensor(:,72))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,3),Q(:,19),G1(:,:,:,136))
  call check_last_CV_D(l_switch,G1(:,:,:,136),Q(:,19),wf(:,2),Q(:,12),G2tensor(:,73))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,3),Q(:,19),G1(:,:,:,137))
  call check_last_CV_D(l_switch,G1(:,:,:,137),Q(:,19),wf(:,2),Q(:,12),G2tensor(:,74))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,3),G1(:,:,:,138))
  call check_last_DV_C(l_switch,G1(:,:,:,138),Q(:,19),wf(:,2),G2tensor(:,75))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,3),G1(:,:,:,139))
  call check_last_DV_C(l_switch,G1(:,:,:,139),Q(:,19),wf(:,2),G2tensor(:,76))
  call loop_UW_V(G0(:,:,:,1),Q(:,0),wf(:,3),Q(:,19),G1(:,:,:,140))
  call check_last_UW_V(l_switch,G1(:,:,:,140),Q(:,19),wf(:,2),Q(:,12),G2tensor(:,77))
  call loop_VV_S(G0(:,:,:,1),wf(:,3),G0(:,:,:,93))
  call check_last_SV_V(l_switch,G0(:,:,:,93),wf(:,2),G0tensor(:,17))
  call check_last_SV_V(l_switch,G0(:,:,:,93),wf(:,2),G0tensor(:,18))
  call loop_VV_S(G0(:,:,:,1),wf(:,3),G0(:,:,:,94))
  call check_last_SV_V(l_switch,G0(:,:,:,94),wf(:,2),G0tensor(:,19))
  call loop_AS_Q(G0(:,:,:,1),wf(:,10),G0(:,:,:,95),gPln)
  call loop_A_Q(G0(:,:,:,95),Q(:,28),ZERO,G1(:,:,:,141))
  call loop_AW_Q(G1(:,:,:,141),wf(:,1),G1(:,:,:,142))
  call check_last_A_Q(l_switch,G1(:,:,:,142),Q(:,31),MM,G2tensor(:,78))
  call loop_AW_Q(G1(:,:,:,141),wf(:,1),G1(:,:,:,143))
  call check_last_A_Q(l_switch,G1(:,:,:,143),Q(:,31),ML,G2tensor(:,79))
  call loop_AS_Q(G0(:,:,:,1),wf(:,10),G0(:,:,:,96),gPbt)
  call loop_A_Q(G0(:,:,:,96),Q(:,28),MT,G1(:,:,:,144))
  call loop_AW_Q(G1(:,:,:,144),wf(:,1),G1(:,:,:,145))
  call check_last_A_Q(l_switch,G1(:,:,:,145),Q(:,31),MB,G2tensor(:,80))
  call loop_SS_S(G0(:,:,:,1),wf(:,10),G0(:,:,:,97))
  call check_last_TV_S(l_switch,G0(:,:,:,97),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,26))
  call loop_SS_S(G0(:,:,:,1),wf(:,10),G0(:,:,:,98))
  call check_last_DV_C(l_switch,G0(:,:,:,98),Q(:,28),wf(:,1),G1tensor(:,27))
  call loop_SS_S(G0(:,:,:,1),wf(:,10),G0(:,:,:,99))
  call check_last_DV_C(l_switch,G0(:,:,:,99),Q(:,28),wf(:,1),G1tensor(:,28))
  call loop_SS_S(G0(:,:,:,1),wf(:,10),G0(:,:,:,100))
  call check_last_CV_D(l_switch,G0(:,:,:,100),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,29))
  call loop_VS_V(G0(:,:,:,1),wf(:,10),G0(:,:,:,101))
  call check_last_UV_W(l_switch,G0(:,:,:,101),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,30))
  call loop_VT_S(G0(:,:,:,1),Q(:,0),wf(:,10),Q(:,28),G1(:,:,:,146))
  call check_last_SV_V(l_switch,G1(:,:,:,146),wf(:,1),G1tensor(:,31))
  call check_last_SV_V(l_switch,G1(:,:,:,146),wf(:,1),G1tensor(:,32))
  call loop_VS_T(G0(:,:,:,1),Q(:,0),wf(:,10),Q(:,28),G1(:,:,:,147))
  call check_last_SV_V(l_switch,G1(:,:,:,147),wf(:,1),G1tensor(:,33))
  call loop_AW_Q(G0(:,:,:,1),wf(:,12),G0(:,:,:,102))
  call loop_A_Q(G0(:,:,:,102),Q(:,28),ZERO,G1(:,:,:,148))
  call loop_AW_Q(G1(:,:,:,148),wf(:,1),G1(:,:,:,149))
  call check_last_A_Q(l_switch,G1(:,:,:,149),Q(:,31),ZERO,G2tensor(:,81))
  call loop_AW_Q(G1(:,:,:,148),wf(:,1),G1(:,:,:,150))
  call check_last_A_Q(l_switch,G1(:,:,:,150),Q(:,31),MM,G2tensor(:,82))
  call loop_AW_Q(G1(:,:,:,148),wf(:,1),G1(:,:,:,151))
  call check_last_A_Q(l_switch,G1(:,:,:,151),Q(:,31),ML,G2tensor(:,83))
  call loop_AW_Q(G0(:,:,:,1),wf(:,12),G0(:,:,:,103))
  call loop_A_Q(G0(:,:,:,103),Q(:,28),MT,G1(:,:,:,152))
  call loop_AW_Q(G1(:,:,:,152),wf(:,1),G1(:,:,:,153))
  call check_last_A_Q(l_switch,G1(:,:,:,153),Q(:,31),MB,G2tensor(:,84))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,12),Q(:,28),G1(:,:,:,154))
  call check_last_TV_S(l_switch,G1(:,:,:,154),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,85))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,12),Q(:,28),G1(:,:,:,155))
  call check_last_TV_S(l_switch,G1(:,:,:,155),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,86))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,12),G1(:,:,:,156))
  call check_last_DV_C(l_switch,G1(:,:,:,156),Q(:,28),wf(:,1),G2tensor(:,87))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,12),G1(:,:,:,157))
  call check_last_DV_C(l_switch,G1(:,:,:,157),Q(:,28),wf(:,1),G2tensor(:,88))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,12),Q(:,28),G1(:,:,:,158))
  call check_last_CV_D(l_switch,G1(:,:,:,158),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,89))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,12),Q(:,28),G1(:,:,:,159))
  call check_last_CV_D(l_switch,G1(:,:,:,159),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,90))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,12),Q(:,28),G1(:,:,:,160))
  call check_last_UV_W(l_switch,G1(:,:,:,160),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,91))
  call loop_VV_S(G0(:,:,:,1),wf(:,12),G0(:,:,:,104))
  call check_last_SV_V(l_switch,G0(:,:,:,104),wf(:,1),G0tensor(:,20))
  call check_last_SV_V(l_switch,G0(:,:,:,104),wf(:,1),G0tensor(:,21))
  call loop_VV_S(G0(:,:,:,1),wf(:,12),G0(:,:,:,105))
  call check_last_SV_V(l_switch,G0(:,:,:,105),wf(:,1),G0tensor(:,22))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(34)*M(2)) * den(3)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(33)*M(2)) * den(3)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,2)
  Gcoeff = (c(35)*M(2)) * den(3)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,3)
  Gcoeff = (c(32)*M(2)) * den(3)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,4)
  Gcoeff = (c(3)*M(2)) * den(3)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(1)*M(2)) * den(3)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(1)*M(2)) * den(3)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(1)*M(2)) * den(3)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(5)*M(2)) * den(3)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(16)*M(2)) * den(3)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(7)*M(2)) * den(3)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(5)*M(2)) * den(3)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(16)*M(2)) * den(3)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(7)*M(2)) * den(3)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,12)
  Gcoeff = (-(c(6)*M(2))) * den(3)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,13)
  Gcoeff = (-(c(18)*M(2))) * den(3)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,14)
  Gcoeff = (-(c(8)*M(2))) * den(3)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(22)*M(2)) * den(3)
  T2sum(1:1,5) = T2sum(1:1,5) + Gcoeff * G0tensor(:,1)
  Gcoeff = (c(26)*M(2)) * den(3)
  T2sum(1:1,4) = T2sum(1:1,4) + Gcoeff * G0tensor(:,2)
  Gcoeff = (c(9)*M(2)) * den(3)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,3)
  Gcoeff = (-(c(19)*M(2))) * den(3)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(4)*M(2)) * den(3)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,23)
  Gcoeff = (-(c(19)*M(2))) * den(3)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(4)*M(2)) * den(3)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,6)
  Gcoeff = (-(c(16)*M(2))) * den(3)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(16)*M(2)) * den(3)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(16)*M(2)) * den(3)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,19)
  Gcoeff = (-(c(16)*M(2))) * den(3)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(27)*M(2)) * den(3)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,4)
  Gcoeff = (c(10)*M(2)) * den(3)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,5)
  Gcoeff = (-(c(20)*M(2))) * den(11)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,1)
  Gcoeff = (-(c(5)*M(2))) * den(11)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,3)
  Gcoeff = (-(c(20)*M(2))) * den(13)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,5)
  Gcoeff = (-(c(5)*M(2))) * den(13)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(15)*M(2)) * den(8)
  T2sum(1:5,6) = T2sum(1:5,6) + Gcoeff * G1tensor(:,7)
  Gcoeff = (-(c(13)*M(2))) * den(8)
  T2sum(1:5,7) = T2sum(1:5,7) + Gcoeff * G1tensor(:,8)
  Gcoeff = (-(c(24)*M(2))) * den(8)
  T2sum(1:5,8) = T2sum(1:5,8) + Gcoeff * G1tensor(:,4)
  Gcoeff = (-(c(24)*M(2))) * den(8)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(14)*M(2)) * den(8)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,26)
  Gcoeff = (-(c(18)*M(2))) * den(8)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,30)
  Gcoeff = (-(c(21)*M(1))) * den(8)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,26)
  Gcoeff = (-(c(17)*M(2))) * den(8)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(15)*M(2)) * den(8)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,34)
  Gcoeff = (-(c(12)*M(2))) * den(8)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,25)
  Gcoeff = (-(c(12)*M(2))) * den(8)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(13)*M(2)) * den(1)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(24)*M(2)) * den(1)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,31)
  Gcoeff = (-(c(11)*M(2))) * den(1)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,36)
  Gcoeff = (c(15)*M(2)) * den(1)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,28)
  Gcoeff = (-(c(12)*M(2))) * den(1)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,32)
  Gcoeff = (-(c(15)*M(2))) * den(1)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,37)
  Gcoeff = (c(24)*M(2)) * den(1)
  T2sum(1:15,16) = T2sum(1:15,16) + Gcoeff * G2tensor(:,40)
  Gcoeff = (-(c(11)*M(2))) * den(1)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,42)
  Gcoeff = (-(c(17)*M(2))) * den(1)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,38)
  Gcoeff = (-(c(12)*M(2))) * den(1)
  T2sum(1:15,16) = T2sum(1:15,16) + Gcoeff * G2tensor(:,41)
  Gcoeff = (-(c(20)*M(2))) * den(1)
  T2sum(1:15,18) = T2sum(1:15,18) + Gcoeff * G2tensor(:,43)
  Gcoeff = (-(c(20)*M(2))) * den(15)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,10)
  Gcoeff = (-(c(5)*M(2))) * den(15)
  T1sum(1:5,6) = T1sum(1:5,6) + Gcoeff * G1tensor(:,11)
  Gcoeff = (-(c(20)*M(2))) * den(17)
  T1sum(1:5,7) = T1sum(1:5,7) + Gcoeff * G1tensor(:,12)
  Gcoeff = (-(c(5)*M(2))) * den(17)
  T1sum(1:5,8) = T1sum(1:5,8) + Gcoeff * G1tensor(:,13)
  Gcoeff = (c(16)*M(2)) * den(5)
  T2sum(1:5,19) = T2sum(1:5,19) + Gcoeff * G1tensor(:,14)
  Gcoeff = (c(24)*M(2)) * den(5)
  T2sum(1:5,20) = T2sum(1:5,20) + Gcoeff * G1tensor(:,16)
  Gcoeff = (c(24)*M(2)) * den(5)
  T2sum(1:5,21) = T2sum(1:5,21) + Gcoeff * G1tensor(:,17)
  Gcoeff = (-(c(18)*M(2))) * den(5)
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,60)
  Gcoeff = (c(18)*M(2)) * den(5)
  T2sum(1:15,19) = T2sum(1:15,19) + Gcoeff * G2tensor(:,61)
  Gcoeff = (-(c(12)*M(2))) * den(5)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,44)
  Gcoeff = (-(c(12)*M(2))) * den(5)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,52)
  Gcoeff = (-(c(16)*M(2))) * den(2)
  T2sum(1:15,23) = T2sum(1:15,23) + Gcoeff * G2tensor(:,21)
  Gcoeff = (-(c(24)*M(2))) * den(2)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,53)
  Gcoeff = (-(c(11)*M(2))) * den(2)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,45)
  Gcoeff = (c(18)*M(2)) * den(2)
  T2sum(1:15,23) = T2sum(1:15,23) + Gcoeff * G2tensor(:,16)
  Gcoeff = (-(c(12)*M(2))) * den(2)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,54)
  Gcoeff = (-(c(24)*M(2))) * den(2)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,46)
  Gcoeff = (-(c(11)*M(2))) * den(2)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,55)
  Gcoeff = (-(c(12)*M(2))) * den(2)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,47)
  Gcoeff = (-(c(20)*M(2))) * den(2)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,63)
  Gcoeff = (-(c(20)*M(2)))
  T2sum(1:15,29) = T2sum(1:15,29) + Gcoeff * G2tensor(:,56)
  Gcoeff = (-(c(18)*M(2)))
  T2sum(1:15,30) = T2sum(1:15,30) + Gcoeff * G2tensor(:,48)
  Gcoeff = (-(c(20)*M(2)))
  T2sum(1:15,31) = T2sum(1:15,31) + Gcoeff * G2tensor(:,57)
  Gcoeff = (-(c(18)*M(2)))
  T2sum(1:15,32) = T2sum(1:15,32) + Gcoeff * G2tensor(:,49)
  Gcoeff = (-(c(20)*M(2)))
  T2sum(1:15,33) = T2sum(1:15,33) + Gcoeff * G2tensor(:,50)
  Gcoeff = (c(17)*M(2))
  T2sum(1:15,34) = T2sum(1:15,34) + Gcoeff * G2tensor(:,39)
  Gcoeff = (-(c(18)*M(2)))
  T2sum(1:15,35) = T2sum(1:15,35) + Gcoeff * G2tensor(:,58)
  Gcoeff = (-(c(20)*M(2)))
  T2sum(1:15,36) = T2sum(1:15,36) + Gcoeff * G2tensor(:,51)
  Gcoeff = (-(c(15)*M(2)))
  T2sum(1:15,37) = T2sum(1:15,37) + Gcoeff * G2tensor(:,29)
  Gcoeff = (-(c(18)*M(2)))
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,59)
  Gcoeff = (c(3)*M(2)) * den(3)
  T0sum(1:1,1) = T0sum(1:1,1) + Gcoeff * G0tensor(:,6)
  Gcoeff = (c(1)*M(2)) * den(3)
  T0sum(1:1,2) = T0sum(1:1,2) + Gcoeff * G0tensor(:,7)
  Gcoeff = (c(2)*M(2)) * den(3)
  T0sum(1:1,3) = T0sum(1:1,3) + Gcoeff * G0tensor(:,8)
  Gcoeff = (c(5)*M(2)) * den(3)
  T0sum(1:1,2) = T0sum(1:1,2) + Gcoeff * G0tensor(:,9)
  Gcoeff = (-(c(6)*M(2))) * den(3)
  T0sum(1:1,3) = T0sum(1:1,3) + Gcoeff * G0tensor(:,10)
  Gcoeff = (c(16)*M(2)) * den(3)
  T2sum(1:1,39) = T2sum(1:1,39) + Gcoeff * G0tensor(:,11)
  Gcoeff = (c(25)*M(2)) * den(3)
  T1sum(1:1,9) = T1sum(1:1,9) + Gcoeff * G0tensor(:,12)
  Gcoeff = (c(5)*M(2)) * den(3)
  T2sum(1:1,40) = T2sum(1:1,40) + Gcoeff * G0tensor(:,13)
  Gcoeff = (c(16)*M(2)) * den(3)
  T2sum(1:1,41) = T2sum(1:1,41) + Gcoeff * G0tensor(:,14)
  Gcoeff = (c(25)*M(2)) * den(3)
  T1sum(1:1,10) = T1sum(1:1,10) + Gcoeff * G0tensor(:,15)
  Gcoeff = (c(5)*M(2)) * den(3)
  T2sum(1:1,42) = T2sum(1:1,42) + Gcoeff * G0tensor(:,16)
  Gcoeff = (-(c(34)*M(2))) * den(9)
  T2sum(1:15,43) = T2sum(1:15,43) + Gcoeff * G2tensor(:,64)
  Gcoeff = (-(c(33)*M(2))) * den(9)
  T2sum(1:15,44) = T2sum(1:15,44) + Gcoeff * G2tensor(:,65)
  Gcoeff = (c(31)*M(2)) * den(9)
  T2sum(1:15,45) = T2sum(1:15,45) + Gcoeff * G2tensor(:,66)
  Gcoeff = (c(1)*M(2)) * den(9)
  T2sum(1:5,42) = T2sum(1:5,42) + Gcoeff * G1tensor(:,18)
  Gcoeff = (c(4)*M(2)) * den(9)
  T2sum(1:5,46) = T2sum(1:5,46) + Gcoeff * G1tensor(:,19)
  Gcoeff = (c(16)*M(2)) * den(9)
  T2sum(1:5,47) = T2sum(1:5,47) + Gcoeff * G1tensor(:,20)
  Gcoeff = (-(c(29)*M(2))) * den(9)
  T2sum(1:5,46) = T2sum(1:5,46) + Gcoeff * G1tensor(:,21)
  Gcoeff = (c(16)*M(2)) * den(9)
  T2sum(1:5,41) = T2sum(1:5,41) + Gcoeff * G1tensor(:,9)
  Gcoeff = (-(c(16)*M(2))) * den(9)
  T2sum(1:5,46) = T2sum(1:5,46) + Gcoeff * G1tensor(:,22)
  Gcoeff = (c(16)*M(2)) * den(9)
  T2sum(1:5,41) = T2sum(1:5,41) + Gcoeff * G1tensor(:,23)
  Gcoeff = (c(30)*M(2)) * den(9)
  T1sum(1:5,10) = T1sum(1:5,10) + Gcoeff * G1tensor(:,24)
  Gcoeff = (c(4)*M(2)) * den(9)
  T2sum(1:5,42) = T2sum(1:5,42) + Gcoeff * G1tensor(:,25)
  Gcoeff = (c(36)*M(2)) * den(9)
  T2sum(1:15,48) = T2sum(1:15,48) + Gcoeff * G2tensor(:,67)
  Gcoeff = (c(36)*M(2)) * den(9)
  T2sum(1:15,43) = T2sum(1:15,43) + Gcoeff * G2tensor(:,68)
  Gcoeff = (c(36)*M(2)) * den(9)
  T2sum(1:15,44) = T2sum(1:15,44) + Gcoeff * G2tensor(:,69)
  Gcoeff = (c(38)*M(2)) * den(9)
  T2sum(1:15,48) = T2sum(1:15,48) + Gcoeff * G2tensor(:,67)
  Gcoeff = (c(37)*M(2)) * den(9)
  T2sum(1:15,45) = T2sum(1:15,45) + Gcoeff * G2tensor(:,70)
  Gcoeff = (c(4)*M(2)) * den(9)
  T2sum(1:15,42) = T2sum(1:15,42) + Gcoeff * G2tensor(:,71)
  Gcoeff = (c(4)*M(2)) * den(9)
  T2sum(1:15,46) = T2sum(1:15,46) + Gcoeff * G2tensor(:,72)
  Gcoeff = (c(18)*M(2)) * den(9)
  T2sum(1:15,47) = T2sum(1:15,47) + Gcoeff * G2tensor(:,73)
  Gcoeff = (c(8)*M(2)) * den(9)
  T2sum(1:15,46) = T2sum(1:15,46) + Gcoeff * G2tensor(:,74)
  Gcoeff = (c(18)*M(2)) * den(9)
  T2sum(1:15,47) = T2sum(1:15,47) + Gcoeff * G2tensor(:,75)
  Gcoeff = (c(8)*M(2)) * den(9)
  T2sum(1:15,46) = T2sum(1:15,46) + Gcoeff * G2tensor(:,76)
  Gcoeff = (-(c(18)*M(2))) * den(9)
  T2sum(1:15,41) = T2sum(1:15,41) + Gcoeff * G2tensor(:,35)
  Gcoeff = (-(c(8)*M(2))) * den(9)
  T2sum(1:15,46) = T2sum(1:15,46) + Gcoeff * G2tensor(:,77)
  Gcoeff = (c(23)*M(2)) * den(9)
  T2sum(1:1,41) = T2sum(1:1,41) + Gcoeff * G0tensor(:,17)
  Gcoeff = (c(28)*M(2)) * den(9)
  T1sum(1:1,10) = T1sum(1:1,10) + Gcoeff * G0tensor(:,18)
  Gcoeff = (c(10)*M(2)) * den(9)
  T2sum(1:1,42) = T2sum(1:1,42) + Gcoeff * G0tensor(:,19)
  Gcoeff = (c(34)*M(2)) * den(6)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,78)
  Gcoeff = (c(33)*M(2)) * den(6)
  T2sum(1:15,50) = T2sum(1:15,50) + Gcoeff * G2tensor(:,79)
  Gcoeff = (c(31)*M(2)) * den(6)
  T2sum(1:15,51) = T2sum(1:15,51) + Gcoeff * G2tensor(:,80)
  Gcoeff = (c(1)*M(2)) * den(6)
  T2sum(1:5,40) = T2sum(1:5,40) + Gcoeff * G1tensor(:,26)
  Gcoeff = (c(16)*M(2)) * den(6)
  T2sum(1:5,52) = T2sum(1:5,52) + Gcoeff * G1tensor(:,27)
  Gcoeff = (-(c(29)*M(2))) * den(6)
  T2sum(1:5,53) = T2sum(1:5,53) + Gcoeff * G1tensor(:,28)
  Gcoeff = (c(4)*M(2)) * den(6)
  T2sum(1:5,53) = T2sum(1:5,53) + Gcoeff * G1tensor(:,29)
  Gcoeff = (-(c(16)*M(2))) * den(6)
  T2sum(1:5,39) = T2sum(1:5,39) + Gcoeff * G1tensor(:,15)
  Gcoeff = (c(16)*M(2)) * den(6)
  T2sum(1:5,53) = T2sum(1:5,53) + Gcoeff * G1tensor(:,30)
  Gcoeff = (-(c(16)*M(2))) * den(6)
  T2sum(1:5,39) = T2sum(1:5,39) + Gcoeff * G1tensor(:,31)
  Gcoeff = (-(c(30)*M(2))) * den(6)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,32)
  Gcoeff = (c(4)*M(2)) * den(6)
  T2sum(1:5,40) = T2sum(1:5,40) + Gcoeff * G1tensor(:,33)
  Gcoeff = (c(36)*M(2)) * den(6)
  T2sum(1:15,54) = T2sum(1:15,54) + Gcoeff * G2tensor(:,81)
  Gcoeff = (c(36)*M(2)) * den(6)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,82)
  Gcoeff = (c(36)*M(2)) * den(6)
  T2sum(1:15,50) = T2sum(1:15,50) + Gcoeff * G2tensor(:,83)
  Gcoeff = (c(38)*M(2)) * den(6)
  T2sum(1:15,54) = T2sum(1:15,54) + Gcoeff * G2tensor(:,81)
  Gcoeff = (c(37)*M(2)) * den(6)
  T2sum(1:15,51) = T2sum(1:15,51) + Gcoeff * G2tensor(:,84)
  Gcoeff = (c(4)*M(2)) * den(6)
  T2sum(1:15,40) = T2sum(1:15,40) + Gcoeff * G2tensor(:,85)
  Gcoeff = (c(4)*M(2)) * den(6)
  T2sum(1:15,53) = T2sum(1:15,53) + Gcoeff * G2tensor(:,86)
  Gcoeff = (c(18)*M(2)) * den(6)
  T2sum(1:15,52) = T2sum(1:15,52) + Gcoeff * G2tensor(:,87)
  Gcoeff = (c(8)*M(2)) * den(6)
  T2sum(1:15,53) = T2sum(1:15,53) + Gcoeff * G2tensor(:,88)
  Gcoeff = (c(18)*M(2)) * den(6)
  T2sum(1:15,52) = T2sum(1:15,52) + Gcoeff * G2tensor(:,89)
  Gcoeff = (c(8)*M(2)) * den(6)
  T2sum(1:15,53) = T2sum(1:15,53) + Gcoeff * G2tensor(:,90)
  Gcoeff = (-(c(18)*M(2))) * den(6)
  T2sum(1:15,39) = T2sum(1:15,39) + Gcoeff * G2tensor(:,62)
  Gcoeff = (-(c(8)*M(2))) * den(6)
  T2sum(1:15,53) = T2sum(1:15,53) + Gcoeff * G2tensor(:,91)
  Gcoeff = (c(23)*M(2)) * den(6)
  T2sum(1:1,39) = T2sum(1:1,39) + Gcoeff * G0tensor(:,20)
  Gcoeff = (c(28)*M(2)) * den(6)
  T1sum(1:1,9) = T1sum(1:1,9) + Gcoeff * G0tensor(:,21)
  Gcoeff = (c(10)*M(2)) * den(6)
  T2sum(1:1,40) = T2sum(1:1,40) + Gcoeff * G0tensor(:,22)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_1_pphll_ew_neexuxdh_1_/**/REALKIND
