
module ol_vamp_1_pphll_ew_eexddxh_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphll_ew_eexddxh_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphll_ew_eexddxh_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphll_ew_eexddxh_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphll_ew_eexddxh_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,144) :: G0
  complex(REALKIND), dimension(4,5,4,235) :: G1
  complex(REALKIND), dimension(4,15,4,69) :: G2
  complex(REALKIND), dimension(1,36) :: G0tensor
  complex(REALKIND), dimension(5,28) :: G1tensor
  complex(REALKIND), dimension(15,161) :: G2tensor
  complex(REALKIND), dimension(35,32) :: G3tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,12),MM,G1(:,:,:,1))
  call loop_AS_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,2),gH)
  call loop_A_Q(G1(:,:,:,2),Q(:,28),MM,G2(:,:,:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,4),G2(:,:,:,2))
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,31),MM,G3tensor(:,1))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,1),G2(:,:,:,3),gZl)
  call check_last_A_Q(l_switch,G2(:,:,:,3),Q(:,31),MM,G3tensor(:,2))
  call loop_AV_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,12),ML,G1(:,:,:,3))
  call loop_AS_Q(G1(:,:,:,3),wf(:,-4),G1(:,:,:,4),gH)
  call loop_A_Q(G1(:,:,:,4),Q(:,28),ML,G2(:,:,:,4))
  call loop_AV_Q(G2(:,:,:,4),wf(:,4),G2(:,:,:,5))
  call check_last_A_Q(l_switch,G2(:,:,:,5),Q(:,31),ML,G3tensor(:,3))
  call loop_AZ_Q(G2(:,:,:,4),wf(:,1),G2(:,:,:,6),gZl)
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,31),ML,G3tensor(:,4))
  call loop_QV_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,12),MM,G1(:,:,:,5))
  call loop_QS_A(G1(:,:,:,5),wf(:,-4),G1(:,:,:,6),gH)
  call loop_Q_A(G1(:,:,:,6),Q(:,28),MM,G2(:,:,:,7))
  call loop_QV_A(G2(:,:,:,7),wf(:,4),G2(:,:,:,8))
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,31),MM,G3tensor(:,5))
  call loop_QZ_A(G2(:,:,:,7),wf(:,1),G2(:,:,:,9),gZl)
  call check_last_Q_A(l_switch,G2(:,:,:,9),Q(:,31),MM,G3tensor(:,6))
  call loop_QV_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,12),ML,G1(:,:,:,7))
  call loop_QS_A(G1(:,:,:,7),wf(:,-4),G1(:,:,:,8),gH)
  call loop_Q_A(G1(:,:,:,8),Q(:,28),ML,G2(:,:,:,10))
  call loop_QV_A(G2(:,:,:,10),wf(:,4),G2(:,:,:,11))
  call check_last_Q_A(l_switch,G2(:,:,:,11),Q(:,31),ML,G3tensor(:,7))
  call loop_QZ_A(G2(:,:,:,10),wf(:,1),G2(:,:,:,12),gZl)
  call check_last_Q_A(l_switch,G2(:,:,:,12),Q(:,31),ML,G3tensor(:,8))
  call loop_AV_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,12),MT,G1(:,:,:,9))
  call loop_AS_Q(G1(:,:,:,9),wf(:,-4),G1(:,:,:,10),gH)
  call loop_A_Q(G1(:,:,:,10),Q(:,28),MT,G2(:,:,:,13))
  call loop_AV_Q(G2(:,:,:,13),wf(:,4),G2(:,:,:,14))
  call check_last_A_Q(l_switch,G2(:,:,:,14),Q(:,31),MT,G3tensor(:,9))
  call loop_AZ_Q(G2(:,:,:,13),wf(:,1),G2(:,:,:,15),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,15),Q(:,31),MT,G3tensor(:,10))
  call loop_QV_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,12),MT,G1(:,:,:,11))
  call loop_QS_A(G1(:,:,:,11),wf(:,-4),G1(:,:,:,12),gH)
  call loop_Q_A(G1(:,:,:,12),Q(:,28),MT,G2(:,:,:,16))
  call loop_QV_A(G2(:,:,:,16),wf(:,4),G2(:,:,:,17))
  call check_last_Q_A(l_switch,G2(:,:,:,17),Q(:,31),MT,G3tensor(:,11))
  call loop_QZ_A(G2(:,:,:,16),wf(:,1),G2(:,:,:,18),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,18),Q(:,31),MT,G3tensor(:,12))
  call loop_AV_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,12),MB,G1(:,:,:,13))
  call loop_AS_Q(G1(:,:,:,13),wf(:,-4),G1(:,:,:,14),gH)
  call loop_A_Q(G1(:,:,:,14),Q(:,28),MB,G2(:,:,:,19))
  call loop_AV_Q(G2(:,:,:,19),wf(:,4),G2(:,:,:,20))
  call check_last_A_Q(l_switch,G2(:,:,:,20),Q(:,31),MB,G3tensor(:,13))
  call loop_AZ_Q(G2(:,:,:,19),wf(:,1),G2(:,:,:,21),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,21),Q(:,31),MB,G3tensor(:,14))
  call loop_QV_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,12),MB,G1(:,:,:,15))
  call loop_QS_A(G1(:,:,:,15),wf(:,-4),G1(:,:,:,16),gH)
  call loop_Q_A(G1(:,:,:,16),Q(:,28),MB,G2(:,:,:,22))
  call loop_QV_A(G2(:,:,:,22),wf(:,4),G2(:,:,:,23))
  call check_last_Q_A(l_switch,G2(:,:,:,23),Q(:,31),MB,G3tensor(:,15))
  call loop_QZ_A(G2(:,:,:,22),wf(:,1),G2(:,:,:,24),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,24),Q(:,31),MB,G3tensor(:,16))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,10),gZl)
  call loop_A_Q(G0(:,:,:,10),Q(:,12),MM,G1(:,:,:,17))
  call loop_AS_Q(G1(:,:,:,17),wf(:,-4),G1(:,:,:,18),gH)
  call loop_A_Q(G1(:,:,:,18),Q(:,28),MM,G2(:,:,:,25))
  call loop_AV_Q(G2(:,:,:,25),wf(:,4),G2(:,:,:,26))
  call check_last_A_Q(l_switch,G2(:,:,:,26),Q(:,31),MM,G3tensor(:,17))
  call loop_AZ_Q(G2(:,:,:,25),wf(:,1),G2(:,:,:,27),gZl)
  call check_last_A_Q(l_switch,G2(:,:,:,27),Q(:,31),MM,G3tensor(:,18))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,11),gZl)
  call loop_A_Q(G0(:,:,:,11),Q(:,12),ML,G1(:,:,:,19))
  call loop_AS_Q(G1(:,:,:,19),wf(:,-4),G1(:,:,:,20),gH)
  call loop_A_Q(G1(:,:,:,20),Q(:,28),ML,G2(:,:,:,28))
  call loop_AV_Q(G2(:,:,:,28),wf(:,4),G2(:,:,:,29))
  call check_last_A_Q(l_switch,G2(:,:,:,29),Q(:,31),ML,G3tensor(:,19))
  call loop_AZ_Q(G2(:,:,:,28),wf(:,1),G2(:,:,:,30),gZl)
  call check_last_A_Q(l_switch,G2(:,:,:,30),Q(:,31),ML,G3tensor(:,20))
  call loop_QZ_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,12),gZl)
  call loop_Q_A(G0(:,:,:,12),Q(:,12),MM,G1(:,:,:,21))
  call loop_QS_A(G1(:,:,:,21),wf(:,-4),G1(:,:,:,22),gH)
  call loop_Q_A(G1(:,:,:,22),Q(:,28),MM,G2(:,:,:,31))
  call loop_QV_A(G2(:,:,:,31),wf(:,4),G2(:,:,:,32))
  call check_last_Q_A(l_switch,G2(:,:,:,32),Q(:,31),MM,G3tensor(:,21))
  call loop_QZ_A(G2(:,:,:,31),wf(:,1),G2(:,:,:,33),gZl)
  call check_last_Q_A(l_switch,G2(:,:,:,33),Q(:,31),MM,G3tensor(:,22))
  call loop_QZ_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,13),gZl)
  call loop_Q_A(G0(:,:,:,13),Q(:,12),ML,G1(:,:,:,23))
  call loop_QS_A(G1(:,:,:,23),wf(:,-4),G1(:,:,:,24),gH)
  call loop_Q_A(G1(:,:,:,24),Q(:,28),ML,G2(:,:,:,34))
  call loop_QV_A(G2(:,:,:,34),wf(:,4),G2(:,:,:,35))
  call check_last_Q_A(l_switch,G2(:,:,:,35),Q(:,31),ML,G3tensor(:,23))
  call loop_QZ_A(G2(:,:,:,34),wf(:,1),G2(:,:,:,36),gZl)
  call check_last_Q_A(l_switch,G2(:,:,:,36),Q(:,31),ML,G3tensor(:,24))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,14),gZu)
  call loop_A_Q(G0(:,:,:,14),Q(:,12),MT,G1(:,:,:,25))
  call loop_AS_Q(G1(:,:,:,25),wf(:,-4),G1(:,:,:,26),gH)
  call loop_A_Q(G1(:,:,:,26),Q(:,28),MT,G2(:,:,:,37))
  call loop_AV_Q(G2(:,:,:,37),wf(:,4),G2(:,:,:,38))
  call check_last_A_Q(l_switch,G2(:,:,:,38),Q(:,31),MT,G3tensor(:,25))
  call loop_AZ_Q(G2(:,:,:,37),wf(:,1),G2(:,:,:,39),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,39),Q(:,31),MT,G3tensor(:,26))
  call loop_QZ_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,15),gZu)
  call loop_Q_A(G0(:,:,:,15),Q(:,12),MT,G1(:,:,:,27))
  call loop_QS_A(G1(:,:,:,27),wf(:,-4),G1(:,:,:,28),gH)
  call loop_Q_A(G1(:,:,:,28),Q(:,28),MT,G2(:,:,:,40))
  call loop_QV_A(G2(:,:,:,40),wf(:,4),G2(:,:,:,41))
  call check_last_Q_A(l_switch,G2(:,:,:,41),Q(:,31),MT,G3tensor(:,27))
  call loop_QZ_A(G2(:,:,:,40),wf(:,1),G2(:,:,:,42),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,42),Q(:,31),MT,G3tensor(:,28))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,16),gZd)
  call loop_A_Q(G0(:,:,:,16),Q(:,12),MB,G1(:,:,:,29))
  call loop_AS_Q(G1(:,:,:,29),wf(:,-4),G1(:,:,:,30),gH)
  call loop_A_Q(G1(:,:,:,30),Q(:,28),MB,G2(:,:,:,43))
  call loop_AV_Q(G2(:,:,:,43),wf(:,4),G2(:,:,:,44))
  call check_last_A_Q(l_switch,G2(:,:,:,44),Q(:,31),MB,G3tensor(:,29))
  call loop_AZ_Q(G2(:,:,:,43),wf(:,1),G2(:,:,:,45),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,45),Q(:,31),MB,G3tensor(:,30))
  call loop_QZ_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,17),gZd)
  call loop_Q_A(G0(:,:,:,17),Q(:,12),MB,G1(:,:,:,31))
  call loop_QS_A(G1(:,:,:,31),wf(:,-4),G1(:,:,:,32),gH)
  call loop_Q_A(G1(:,:,:,32),Q(:,28),MB,G2(:,:,:,46))
  call loop_QV_A(G2(:,:,:,46),wf(:,4),G2(:,:,:,47))
  call check_last_Q_A(l_switch,G2(:,:,:,47),Q(:,31),MB,G3tensor(:,31))
  call loop_QZ_A(G2(:,:,:,46),wf(:,1),G2(:,:,:,48),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,48),Q(:,31),MB,G3tensor(:,32))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,5),Q(:,12),G1(:,:,:,33))
  call loop_SS_S(G1(:,:,:,33),wf(:,-4),G1(:,:,:,34))
  call check_last_SV_T(l_switch,G1(:,:,:,34),Q(:,28),wf(:,4),Q(:,3),G2tensor(:,1))
  call check_last_SV_T(l_switch,G1(:,:,:,34),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,2))
  call loop_ST_V(G1(:,:,:,33),Q(:,12),wf(:,-4),Q(:,16),G2(:,:,:,49))
  call check_last_VV_S(l_switch,G2(:,:,:,49),wf(:,4),G2tensor(:,3))
  call check_last_VV_S(l_switch,G2(:,:,:,49),wf(:,1),G2tensor(:,4))
  call loop_TV_S(G0(:,:,:,1),Q(:,0),wf(:,5),Q(:,12),G1(:,:,:,35))
  call loop_SS_S(G1(:,:,:,35),wf(:,-4),G1(:,:,:,36))
  call check_last_TV_S(l_switch,G1(:,:,:,36),Q(:,28),wf(:,4),Q(:,3),G2tensor(:,5))
  call check_last_TV_S(l_switch,G1(:,:,:,36),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,6))
  call loop_ST_V(G1(:,:,:,35),Q(:,12),wf(:,-4),Q(:,16),G2(:,:,:,50))
  call check_last_VV_S(l_switch,G2(:,:,:,50),wf(:,4),G2tensor(:,7))
  call check_last_VV_S(l_switch,G2(:,:,:,50),wf(:,1),G2tensor(:,8))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,12),G1(:,:,:,37))
  call loop_SS_S(G1(:,:,:,37),wf(:,-4),G1(:,:,:,38))
  call check_last_SV_T(l_switch,G1(:,:,:,38),Q(:,28),wf(:,4),Q(:,3),G2tensor(:,9))
  call check_last_SV_T(l_switch,G1(:,:,:,38),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,10))
  call loop_ST_V(G1(:,:,:,37),Q(:,12),wf(:,-4),Q(:,16),G2(:,:,:,51))
  call check_last_VV_S(l_switch,G2(:,:,:,51),wf(:,4),G2tensor(:,11))
  call check_last_VV_S(l_switch,G2(:,:,:,51),wf(:,1),G2tensor(:,12))
  call loop_TV_S(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,12),G1(:,:,:,39))
  call loop_SS_S(G1(:,:,:,39),wf(:,-4),G1(:,:,:,40))
  call check_last_TV_S(l_switch,G1(:,:,:,40),Q(:,28),wf(:,4),Q(:,3),G2tensor(:,13))
  call check_last_TV_S(l_switch,G1(:,:,:,40),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,14))
  call loop_ST_V(G1(:,:,:,39),Q(:,12),wf(:,-4),Q(:,16),G2(:,:,:,52))
  call check_last_VV_S(l_switch,G2(:,:,:,52),wf(:,4),G2tensor(:,15))
  call check_last_VV_S(l_switch,G2(:,:,:,52),wf(:,1),G2tensor(:,16))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,12),G1(:,:,:,41))
  call loop_SS_S(G1(:,:,:,41),wf(:,-4),G1(:,:,:,42))
  call check_last_TV_S(l_switch,G1(:,:,:,42),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,17))
  call loop_TV_S(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,12),G1(:,:,:,43))
  call loop_SS_S(G1(:,:,:,43),wf(:,-4),G1(:,:,:,44))
  call check_last_SV_T(l_switch,G1(:,:,:,44),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,18))
  call loop_ST_V(G1(:,:,:,43),Q(:,12),wf(:,-4),Q(:,16),G2(:,:,:,53))
  call check_last_VV_S(l_switch,G2(:,:,:,53),wf(:,1),G2tensor(:,19))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,5),G1(:,:,:,45))
  call loop_SS_S(G1(:,:,:,45),wf(:,-4),G1(:,:,:,46))
  call check_last_DV_C(l_switch,G1(:,:,:,46),Q(:,28),wf(:,4),G2tensor(:,20))
  call check_last_DV_C(l_switch,G1(:,:,:,46),Q(:,28),wf(:,1),G2tensor(:,21))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,5),Q(:,12),G1(:,:,:,47))
  call loop_SS_S(G1(:,:,:,47),wf(:,-4),G1(:,:,:,48))
  call check_last_CV_D(l_switch,G1(:,:,:,48),Q(:,28),wf(:,4),Q(:,3),G2tensor(:,22))
  call check_last_CV_D(l_switch,G1(:,:,:,48),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,23))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,2),G1(:,:,:,49))
  call loop_SS_S(G1(:,:,:,49),wf(:,-4),G1(:,:,:,50))
  call check_last_DV_C(l_switch,G1(:,:,:,50),Q(:,28),wf(:,4),G2tensor(:,24))
  call check_last_DV_C(l_switch,G1(:,:,:,50),Q(:,28),wf(:,1),G2tensor(:,25))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,12),G1(:,:,:,51))
  call loop_SS_S(G1(:,:,:,51),wf(:,-4),G1(:,:,:,52))
  call check_last_CV_D(l_switch,G1(:,:,:,52),Q(:,28),wf(:,4),Q(:,3),G2tensor(:,26))
  call check_last_CV_D(l_switch,G1(:,:,:,52),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,27))
  call loop_UW_V(G0(:,:,:,1),Q(:,0),wf(:,5),Q(:,12),G1(:,:,:,53))
  call loop_VS_V(G1(:,:,:,53),wf(:,-4),G1(:,:,:,54))
  call check_last_UW_V(l_switch,G1(:,:,:,54),Q(:,28),wf(:,4),Q(:,3),G2tensor(:,28))
  call check_last_UW_V(l_switch,G1(:,:,:,54),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,29))
  call loop_VT_S(G1(:,:,:,53),Q(:,12),wf(:,-4),Q(:,16),G2(:,:,:,54))
  call check_last_SV_V(l_switch,G2(:,:,:,54),wf(:,4),G2tensor(:,30))
  call check_last_SV_V(l_switch,G2(:,:,:,54),wf(:,1),G2tensor(:,31))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,5),Q(:,12),G1(:,:,:,55))
  call loop_VS_V(G1(:,:,:,55),wf(:,-4),G1(:,:,:,56))
  call check_last_UV_W(l_switch,G1(:,:,:,56),Q(:,28),wf(:,4),Q(:,3),G2tensor(:,32))
  call check_last_UV_W(l_switch,G1(:,:,:,56),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,33))
  call loop_VT_S(G1(:,:,:,55),Q(:,12),wf(:,-4),Q(:,16),G2(:,:,:,55))
  call check_last_SV_V(l_switch,G2(:,:,:,55),wf(:,4),G2tensor(:,34))
  call check_last_SV_V(l_switch,G2(:,:,:,55),wf(:,1),G2tensor(:,35))
  call loop_UW_V(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,12),G1(:,:,:,57))
  call loop_VS_V(G1(:,:,:,57),wf(:,-4),G1(:,:,:,58))
  call check_last_UW_V(l_switch,G1(:,:,:,58),Q(:,28),wf(:,4),Q(:,3),G2tensor(:,36))
  call check_last_UW_V(l_switch,G1(:,:,:,58),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,37))
  call loop_VT_S(G1(:,:,:,57),Q(:,12),wf(:,-4),Q(:,16),G2(:,:,:,56))
  call check_last_SV_V(l_switch,G2(:,:,:,56),wf(:,4),G2tensor(:,38))
  call check_last_SV_V(l_switch,G2(:,:,:,56),wf(:,1),G2tensor(:,39))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,12),G1(:,:,:,59))
  call loop_VS_V(G1(:,:,:,59),wf(:,-4),G1(:,:,:,60))
  call check_last_UV_W(l_switch,G1(:,:,:,60),Q(:,28),wf(:,4),Q(:,3),G2tensor(:,40))
  call check_last_UV_W(l_switch,G1(:,:,:,60),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,41))
  call loop_VT_S(G1(:,:,:,59),Q(:,12),wf(:,-4),Q(:,16),G2(:,:,:,57))
  call check_last_SV_V(l_switch,G2(:,:,:,57),wf(:,4),G2tensor(:,42))
  call check_last_SV_V(l_switch,G2(:,:,:,57),wf(:,1),G2tensor(:,43))
  call loop_VV_S(G0(:,:,:,1),wf(:,5),G0(:,:,:,18))
  call loop_SS_S(G0(:,:,:,18),wf(:,-4),G0(:,:,:,19))
  call check_last_SV_V(l_switch,G0(:,:,:,19),wf(:,4),G0tensor(:,1))
  call check_last_SV_V(l_switch,G0(:,:,:,19),wf(:,1),G0tensor(:,2))
  call loop_ST_V(G0(:,:,:,18),Q(:,12),wf(:,-4),Q(:,16),G1(:,:,:,61))
  call check_last_UW_V(l_switch,G1(:,:,:,61),Q(:,28),wf(:,4),Q(:,3),G2tensor(:,44))
  call check_last_UV_W(l_switch,G1(:,:,:,61),Q(:,28),wf(:,4),Q(:,3),G2tensor(:,45))
  call check_last_UW_V(l_switch,G1(:,:,:,61),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,46))
  call check_last_UV_W(l_switch,G1(:,:,:,61),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,47))
  call loop_VV_S(G0(:,:,:,1),wf(:,2),G0(:,:,:,20))
  call loop_SS_S(G0(:,:,:,20),wf(:,-4),G0(:,:,:,21))
  call check_last_SV_V(l_switch,G0(:,:,:,21),wf(:,4),G0tensor(:,3))
  call check_last_SV_V(l_switch,G0(:,:,:,21),wf(:,1),G0tensor(:,4))
  call loop_ST_V(G0(:,:,:,20),Q(:,12),wf(:,-4),Q(:,16),G1(:,:,:,62))
  call check_last_UW_V(l_switch,G1(:,:,:,62),Q(:,28),wf(:,4),Q(:,3),G2tensor(:,48))
  call check_last_UV_W(l_switch,G1(:,:,:,62),Q(:,28),wf(:,4),Q(:,3),G2tensor(:,49))
  call check_last_UW_V(l_switch,G1(:,:,:,62),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,50))
  call check_last_UV_W(l_switch,G1(:,:,:,62),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,51))
  call loop_VV_S(G0(:,:,:,1),wf(:,2),G0(:,:,:,22))
  call loop_SS_S(G0(:,:,:,22),wf(:,-4),G0(:,:,:,23))
  call check_last_SV_V(l_switch,G0(:,:,:,23),wf(:,1),G0tensor(:,5))
  call loop_SV_V(G0(:,:,:,1),wf(:,5),G0(:,:,:,24))
  call loop_VT_S(G0(:,:,:,24),Q(:,12),wf(:,-4),Q(:,16),G1(:,:,:,63))
  call check_last_SV_T(l_switch,G1(:,:,:,63),Q(:,28),wf(:,4),Q(:,3),G2tensor(:,52))
  call check_last_TV_S(l_switch,G1(:,:,:,63),Q(:,28),wf(:,4),Q(:,3),G2tensor(:,53))
  call check_last_SV_T(l_switch,G1(:,:,:,63),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,54))
  call check_last_TV_S(l_switch,G1(:,:,:,63),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,55))
  call loop_VS_V(G0(:,:,:,24),wf(:,-4),G0(:,:,:,25))
  call check_last_VV_S(l_switch,G0(:,:,:,25),wf(:,4),G0tensor(:,6))
  call check_last_VV_S(l_switch,G0(:,:,:,25),wf(:,1),G0tensor(:,7))
  call loop_SV_V(G0(:,:,:,1),wf(:,2),G0(:,:,:,26))
  call loop_VT_S(G0(:,:,:,26),Q(:,12),wf(:,-4),Q(:,16),G1(:,:,:,64))
  call check_last_SV_T(l_switch,G1(:,:,:,64),Q(:,28),wf(:,4),Q(:,3),G2tensor(:,56))
  call check_last_TV_S(l_switch,G1(:,:,:,64),Q(:,28),wf(:,4),Q(:,3),G2tensor(:,57))
  call check_last_SV_T(l_switch,G1(:,:,:,64),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,58))
  call check_last_TV_S(l_switch,G1(:,:,:,64),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,59))
  call loop_VS_V(G0(:,:,:,26),wf(:,-4),G0(:,:,:,27))
  call check_last_VV_S(l_switch,G0(:,:,:,27),wf(:,4),G0tensor(:,8))
  call check_last_VV_S(l_switch,G0(:,:,:,27),wf(:,1),G0tensor(:,9))
  call loop_SV_V(G0(:,:,:,1),wf(:,2),G0(:,:,:,28))
  call loop_VT_S(G0(:,:,:,28),Q(:,12),wf(:,-4),Q(:,16),G1(:,:,:,65))
  call check_last_SV_T(l_switch,G1(:,:,:,65),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,60))
  call loop_VS_V(G0(:,:,:,28),wf(:,-4),G0(:,:,:,29))
  call check_last_VV_S(l_switch,G0(:,:,:,29),wf(:,1),G0tensor(:,10))
  call loop_QA_Z(G0(:,:,:,1),wf(:,-3),G0(:,:,:,30),gZd)
  call loop_VS_V(G0(:,:,:,30),wf(:,-4),G0(:,:,:,31))
  call loop_ZQ_A(G0(:,:,:,31),wf(:,24),G0(:,:,:,32),gZd)
  call check_last_Q_A(l_switch,G0(:,:,:,32),Q(:,31),ZERO,G1tensor(:,1))
  call loop_ZQ_A(G0(:,:,:,31),wf(:,26),G0(:,:,:,33),gZd)
  call check_last_Q_A(l_switch,G0(:,:,:,33),Q(:,31),ZERO,G1tensor(:,2))
  call loop_QA_W(G0(:,:,:,1),wf(:,-3),G0(:,:,:,34))
  call loop_VS_V(G0(:,:,:,34),wf(:,-4),G0(:,:,:,35))
  call loop_WQ_A(G0(:,:,:,35),wf(:,24),G0(:,:,:,36))
  call check_last_Q_A(l_switch,G0(:,:,:,36),Q(:,31),ZERO,G1tensor(:,3))
  call loop_WQ_A(G0(:,:,:,35),wf(:,26),G0(:,:,:,37))
  call check_last_Q_A(l_switch,G0(:,:,:,37),Q(:,31),ZERO,G1tensor(:,4))
  call loop_UW_V(G0(:,:,:,34),Q(:,8),wf(:,3),Q(:,19),G1(:,:,:,66))
  call loop_WQ_A(G1(:,:,:,66),wf(:,-2),G1(:,:,:,67))
  call check_last_Q_A(l_switch,G1(:,:,:,67),Q(:,31),ZERO,G2tensor(:,61))
  call loop_QA_Z(G0(:,:,:,1),wf(:,28),G0(:,:,:,38),gZd)
  call loop_VS_V(G0(:,:,:,38),wf(:,-4),G0(:,:,:,39))
  call loop_ZQ_A(G0(:,:,:,39),wf(:,-2),G0(:,:,:,40),gZd)
  call check_last_Q_A(l_switch,G0(:,:,:,40),Q(:,31),ZERO,G1tensor(:,5))
  call loop_QA_W(G0(:,:,:,1),wf(:,28),G0(:,:,:,41))
  call loop_VS_V(G0(:,:,:,41),wf(:,-4),G0(:,:,:,42))
  call loop_WQ_A(G0(:,:,:,42),wf(:,-2),G0(:,:,:,43))
  call check_last_Q_A(l_switch,G0(:,:,:,43),Q(:,31),ZERO,G1tensor(:,6))
  call loop_QA_Z(G0(:,:,:,1),wf(:,30),G0(:,:,:,44),gZd)
  call loop_VS_V(G0(:,:,:,44),wf(:,-4),G0(:,:,:,45))
  call loop_ZQ_A(G0(:,:,:,45),wf(:,-2),G0(:,:,:,46),gZd)
  call check_last_Q_A(l_switch,G0(:,:,:,46),Q(:,31),ZERO,G1tensor(:,7))
  call loop_QA_W(G0(:,:,:,1),wf(:,30),G0(:,:,:,47))
  call loop_VS_V(G0(:,:,:,47),wf(:,-4),G0(:,:,:,48))
  call loop_WQ_A(G0(:,:,:,48),wf(:,-2),G0(:,:,:,49))
  call check_last_Q_A(l_switch,G0(:,:,:,49),Q(:,31),ZERO,G1tensor(:,8))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,50))
  call loop_A_Q(G0(:,:,:,50),Q(:,8),ZERO,G1(:,:,:,68))
  call loop_AZ_Q(G1(:,:,:,68),wf(:,3),G1(:,:,:,69),gZd)
  call loop_A_Q(G1(:,:,:,69),Q(:,27),ZERO,G2(:,:,:,58))
  call check_last_AQ_V(l_switch,G2(:,:,:,58),wf(:,-2),G2tensor(:,62))
  call loop_AQ_Z(G1(:,:,:,68),wf(:,-2),G1(:,:,:,70),gZd)
  call loop_VS_V(G1(:,:,:,70),wf(:,-4),G1(:,:,:,71))
  call loop_ZA_Q(G1(:,:,:,71),wf(:,-1),G1(:,:,:,72),gZl)
  call loop_A_Q(G1(:,:,:,72),Q(:,30),ZERO,G2(:,:,:,59))
  call check_last_AQ_V(l_switch,G2(:,:,:,59),wf(:,0),G2tensor(:,63))
  call loop_ZQ_A(G1(:,:,:,71),wf(:,0),G1(:,:,:,73),gZl)
  call loop_Q_A(G1(:,:,:,73),Q(:,29),ZERO,G2(:,:,:,60))
  call check_last_QA_V(l_switch,G2(:,:,:,60),wf(:,-1),G2tensor(:,64))
  call loop_ZA_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,51),gZd)
  call loop_A_Q(G0(:,:,:,51),Q(:,8),ZERO,G1(:,:,:,74))
  call loop_AZ_Q(G1(:,:,:,74),wf(:,3),G1(:,:,:,75),gZd)
  call loop_A_Q(G1(:,:,:,75),Q(:,27),ZERO,G2(:,:,:,61))
  call check_last_AQ_Z(l_switch,G2(:,:,:,61),wf(:,-2),G2tensor(:,65),gZd)
  call loop_WA_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,52))
  call loop_A_Q(G0(:,:,:,52),Q(:,8),ZERO,G1(:,:,:,76))
  call loop_AZ_Q(G1(:,:,:,76),wf(:,3),G1(:,:,:,77),gZu)
  call loop_A_Q(G1(:,:,:,77),Q(:,27),ZERO,G2(:,:,:,62))
  call check_last_AQ_W(l_switch,G2(:,:,:,62),wf(:,-2),G2tensor(:,66))
  call loop_AQ_W(G1(:,:,:,76),wf(:,-2),G1(:,:,:,78))
  call loop_VT_S(G1(:,:,:,78),Q(:,12),wf(:,-4),Q(:,16),G2(:,:,:,63))
  call check_last_SV_V(l_switch,G2(:,:,:,63),wf(:,4),G2tensor(:,67))
  call check_last_SV_V(l_switch,G2(:,:,:,63),wf(:,1),G2tensor(:,68))
  call loop_VS_V(G1(:,:,:,78),wf(:,-4),G1(:,:,:,79))
  call check_last_UV_W(l_switch,G1(:,:,:,79),Q(:,28),wf(:,4),Q(:,3),G2tensor(:,69))
  call check_last_UV_W(l_switch,G1(:,:,:,79),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,70))
  call loop_WQ_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,53))
  call loop_Q_A(G0(:,:,:,53),Q(:,4),ZERO,G1(:,:,:,80))
  call loop_QA_W(G1(:,:,:,80),wf(:,-3),G1(:,:,:,81))
  call loop_VT_S(G1(:,:,:,81),Q(:,12),wf(:,-4),Q(:,16),G2(:,:,:,64))
  call check_last_SV_V(l_switch,G2(:,:,:,64),wf(:,4),G2tensor(:,71))
  call check_last_SV_V(l_switch,G2(:,:,:,64),wf(:,1),G2tensor(:,72))
  call loop_VS_V(G1(:,:,:,81),wf(:,-4),G1(:,:,:,82))
  call check_last_UW_V(l_switch,G1(:,:,:,82),Q(:,28),wf(:,4),Q(:,3),G2tensor(:,73))
  call check_last_UW_V(l_switch,G1(:,:,:,82),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,74))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,-2),G0(:,:,:,54),gZd)
  call loop_VS_V(G0(:,:,:,54),wf(:,-4),G0(:,:,:,55))
  call loop_ZA_Q(G0(:,:,:,55),wf(:,-3),G0(:,:,:,56),gZd)
  call loop_A_Q(G0(:,:,:,56),Q(:,28),ZERO,G1(:,:,:,83))
  call loop_AV_Q(G1(:,:,:,83),wf(:,4),G1(:,:,:,84))
  call check_last_A_Q(l_switch,G1(:,:,:,84),Q(:,31),ZERO,G2tensor(:,75))
  call loop_AZ_Q(G1(:,:,:,83),wf(:,1),G1(:,:,:,85),gZd)
  call check_last_A_Q(l_switch,G1(:,:,:,85),Q(:,31),ZERO,G2tensor(:,76))
  call loop_AQ_W(G0(:,:,:,1),wf(:,-2),G0(:,:,:,57))
  call loop_VS_V(G0(:,:,:,57),wf(:,-4),G0(:,:,:,58))
  call loop_WA_Q(G0(:,:,:,58),wf(:,-3),G0(:,:,:,59))
  call loop_A_Q(G0(:,:,:,59),Q(:,28),ZERO,G1(:,:,:,86))
  call loop_AV_Q(G1(:,:,:,86),wf(:,4),G1(:,:,:,87))
  call check_last_A_Q(l_switch,G1(:,:,:,87),Q(:,31),ZERO,G2tensor(:,77))
  call loop_AZ_Q(G1(:,:,:,86),wf(:,1),G1(:,:,:,88),gZu)
  call check_last_A_Q(l_switch,G1(:,:,:,88),Q(:,31),ZERO,G2tensor(:,78))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,32),G0(:,:,:,60),gZl)
  call loop_VS_V(G0(:,:,:,60),wf(:,-4),G0(:,:,:,61))
  call loop_ZA_Q(G0(:,:,:,61),wf(:,-1),G0(:,:,:,62),gZl)
  call check_last_A_Q(l_switch,G0(:,:,:,62),Q(:,31),ZERO,G1tensor(:,9))
  call loop_AQ_W(G0(:,:,:,1),wf(:,32),G0(:,:,:,63))
  call loop_VS_V(G0(:,:,:,63),wf(:,-4),G0(:,:,:,64))
  call loop_WA_Q(G0(:,:,:,64),wf(:,-1),G0(:,:,:,65))
  call check_last_A_Q(l_switch,G0(:,:,:,65),Q(:,31),ZERO,G1tensor(:,10))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,34),G0(:,:,:,66),gZl)
  call loop_VS_V(G0(:,:,:,66),wf(:,-4),G0(:,:,:,67))
  call loop_ZA_Q(G0(:,:,:,67),wf(:,-1),G0(:,:,:,68),gZl)
  call check_last_A_Q(l_switch,G0(:,:,:,68),Q(:,31),ZERO,G1tensor(:,11))
  call loop_AQ_W(G0(:,:,:,1),wf(:,34),G0(:,:,:,69))
  call loop_VS_V(G0(:,:,:,69),wf(:,-4),G0(:,:,:,70))
  call loop_WA_Q(G0(:,:,:,70),wf(:,-1),G0(:,:,:,71))
  call check_last_A_Q(l_switch,G0(:,:,:,71),Q(:,31),ZERO,G1tensor(:,12))
  call loop_QA_Z(G0(:,:,:,1),wf(:,36),G0(:,:,:,72),gZl)
  call loop_VS_V(G0(:,:,:,72),wf(:,-4),G0(:,:,:,73))
  call loop_ZQ_A(G0(:,:,:,73),wf(:,0),G0(:,:,:,74),gZl)
  call check_last_Q_A(l_switch,G0(:,:,:,74),Q(:,31),ZERO,G1tensor(:,13))
  call loop_QA_W(G0(:,:,:,1),wf(:,36),G0(:,:,:,75))
  call loop_VS_V(G0(:,:,:,75),wf(:,-4),G0(:,:,:,76))
  call loop_WQ_A(G0(:,:,:,76),wf(:,0),G0(:,:,:,77))
  call check_last_Q_A(l_switch,G0(:,:,:,77),Q(:,31),ZERO,G1tensor(:,14))
  call loop_QA_Z(G0(:,:,:,1),wf(:,38),G0(:,:,:,78),gZl)
  call loop_VS_V(G0(:,:,:,78),wf(:,-4),G0(:,:,:,79))
  call loop_ZQ_A(G0(:,:,:,79),wf(:,0),G0(:,:,:,80),gZl)
  call check_last_Q_A(l_switch,G0(:,:,:,80),Q(:,31),ZERO,G1tensor(:,15))
  call loop_QA_W(G0(:,:,:,1),wf(:,38),G0(:,:,:,81))
  call loop_VS_V(G0(:,:,:,81),wf(:,-4),G0(:,:,:,82))
  call loop_WQ_A(G0(:,:,:,82),wf(:,0),G0(:,:,:,83))
  call check_last_Q_A(l_switch,G0(:,:,:,83),Q(:,31),ZERO,G1tensor(:,16))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,84))
  call loop_A_Q(G0(:,:,:,84),Q(:,2),ZERO,G1(:,:,:,89))
  call loop_AZ_Q(G1(:,:,:,89),wf(:,15),G1(:,:,:,90),gZl)
  call loop_A_Q(G1(:,:,:,90),Q(:,30),ZERO,G2(:,:,:,65))
  call check_last_AQ_V(l_switch,G2(:,:,:,65),wf(:,0),G2tensor(:,79))
  call loop_ZA_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,85),gZl)
  call loop_A_Q(G0(:,:,:,85),Q(:,2),ZERO,G1(:,:,:,91))
  call loop_AZ_Q(G1(:,:,:,91),wf(:,15),G1(:,:,:,92),gZl)
  call loop_A_Q(G1(:,:,:,92),Q(:,30),ZERO,G2(:,:,:,66))
  call check_last_AQ_Z(l_switch,G2(:,:,:,66),wf(:,0),G2tensor(:,80),gZl)
  call loop_WA_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,86))
  call loop_A_Q(G0(:,:,:,86),Q(:,2),ZERO,G1(:,:,:,93))
  call loop_AZ_Q(G1(:,:,:,93),wf(:,15),G1(:,:,:,94),gZn)
  call loop_A_Q(G1(:,:,:,94),Q(:,30),ZERO,G2(:,:,:,67))
  call check_last_AQ_W(l_switch,G2(:,:,:,67),wf(:,0),G2tensor(:,81))
  call loop_QA_W(G0(:,:,:,1),wf(:,-1),G0(:,:,:,87))
  call loop_UW_V(G0(:,:,:,87),Q(:,2),wf(:,15),Q(:,28),G1(:,:,:,95))
  call loop_WQ_A(G1(:,:,:,95),wf(:,0),G1(:,:,:,96))
  call check_last_Q_A(l_switch,G1(:,:,:,96),Q(:,31),ZERO,G2tensor(:,82))
  call loop_VV_S(G0(:,:,:,87),wf(:,5),G0(:,:,:,88))
  call loop_ST_V(G0(:,:,:,88),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,97))
  call loop_WQ_A(G1(:,:,:,97),wf(:,0),G1(:,:,:,98))
  call check_last_Q_A(l_switch,G1(:,:,:,98),Q(:,31),ZERO,G2tensor(:,83))
  call loop_VV_S(G0(:,:,:,87),wf(:,2),G0(:,:,:,89))
  call loop_ST_V(G0(:,:,:,89),Q(:,14),wf(:,-4),Q(:,16),G1(:,:,:,99))
  call loop_WQ_A(G1(:,:,:,99),wf(:,0),G1(:,:,:,100))
  call check_last_Q_A(l_switch,G1(:,:,:,100),Q(:,31),ZERO,G2tensor(:,84))
  call loop_UW_V(G0(:,:,:,87),Q(:,2),wf(:,5),Q(:,12),G1(:,:,:,101))
  call loop_VS_V(G1(:,:,:,101),wf(:,-4),G1(:,:,:,102))
  call loop_WQ_A(G1(:,:,:,102),wf(:,0),G1(:,:,:,103))
  call check_last_Q_A(l_switch,G1(:,:,:,103),Q(:,31),ZERO,G2tensor(:,85))
  call loop_UW_V(G0(:,:,:,87),Q(:,2),wf(:,2),Q(:,12),G1(:,:,:,104))
  call loop_VS_V(G1(:,:,:,104),wf(:,-4),G1(:,:,:,105))
  call loop_WQ_A(G1(:,:,:,105),wf(:,0),G1(:,:,:,106))
  call check_last_Q_A(l_switch,G1(:,:,:,106),Q(:,31),ZERO,G2tensor(:,86))
  call loop_VT_S(G0(:,:,:,87),Q(:,2),wf(:,-4),Q(:,16),G1(:,:,:,107))
  call loop_SV_V(G1(:,:,:,107),wf(:,5),G1(:,:,:,108))
  call loop_WQ_A(G1(:,:,:,108),wf(:,0),G1(:,:,:,109))
  call check_last_Q_A(l_switch,G1(:,:,:,109),Q(:,31),ZERO,G2tensor(:,87))
  call loop_SV_V(G1(:,:,:,107),wf(:,2),G1(:,:,:,110))
  call loop_WQ_A(G1(:,:,:,110),wf(:,0),G1(:,:,:,111))
  call check_last_Q_A(l_switch,G1(:,:,:,111),Q(:,31),ZERO,G2tensor(:,88))
  call loop_VS_V(G0(:,:,:,87),wf(:,-4),G0(:,:,:,90))
  call loop_UW_V(G0(:,:,:,90),Q(:,18),wf(:,5),Q(:,12),G1(:,:,:,112))
  call loop_WQ_A(G1(:,:,:,112),wf(:,0),G1(:,:,:,113))
  call check_last_Q_A(l_switch,G1(:,:,:,113),Q(:,31),ZERO,G2tensor(:,89))
  call loop_UW_V(G0(:,:,:,90),Q(:,18),wf(:,2),Q(:,12),G1(:,:,:,114))
  call loop_WQ_A(G1(:,:,:,114),wf(:,0),G1(:,:,:,115))
  call check_last_Q_A(l_switch,G1(:,:,:,115),Q(:,31),ZERO,G2tensor(:,90))
  call loop_WQ_A(G0(:,:,:,90),wf(:,-2),G0(:,:,:,91))
  call loop_Q_A(G0(:,:,:,91),Q(:,22),ZERO,G1(:,:,:,116))
  call loop_QA_W(G1(:,:,:,116),wf(:,-3),G1(:,:,:,117))
  call loop_WQ_A(G1(:,:,:,117),wf(:,0),G1(:,:,:,118))
  call check_last_Q_A(l_switch,G1(:,:,:,118),Q(:,31),ZERO,G2tensor(:,91))
  call loop_WQ_A(G0(:,:,:,87),wf(:,-2),G0(:,:,:,92))
  call loop_Q_A(G0(:,:,:,92),Q(:,6),ZERO,G1(:,:,:,119))
  call loop_QA_W(G1(:,:,:,119),wf(:,-3),G1(:,:,:,120))
  call loop_VS_V(G1(:,:,:,120),wf(:,-4),G1(:,:,:,121))
  call loop_WQ_A(G1(:,:,:,121),wf(:,0),G1(:,:,:,122))
  call check_last_Q_A(l_switch,G1(:,:,:,122),Q(:,31),ZERO,G2tensor(:,92))
  call loop_QV_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,93))
  call loop_Q_A(G0(:,:,:,93),Q(:,12),ZERO,G1(:,:,:,123))
  call loop_QA_Z(G1(:,:,:,123),wf(:,-1),G1(:,:,:,124),gZl)
  call loop_VS_V(G1(:,:,:,124),wf(:,-4),G1(:,:,:,125))
  call loop_ZQ_A(G1(:,:,:,125),wf(:,0),G1(:,:,:,126),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,126),Q(:,31),ZERO,G2tensor(:,93))
  call loop_QZ_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,94),gZl)
  call loop_Q_A(G0(:,:,:,94),Q(:,12),ZERO,G1(:,:,:,127))
  call loop_QA_Z(G1(:,:,:,127),wf(:,-1),G1(:,:,:,128),gZl)
  call loop_VS_V(G1(:,:,:,128),wf(:,-4),G1(:,:,:,129))
  call loop_ZQ_A(G1(:,:,:,129),wf(:,0),G1(:,:,:,130),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,130),Q(:,31),ZERO,G2tensor(:,94))
  call loop_QZ_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,95),gZn)
  call loop_Q_A(G0(:,:,:,95),Q(:,12),ZERO,G1(:,:,:,131))
  call loop_QA_W(G1(:,:,:,131),wf(:,-1),G1(:,:,:,132))
  call loop_VS_V(G1(:,:,:,132),wf(:,-4),G1(:,:,:,133))
  call loop_WQ_A(G1(:,:,:,133),wf(:,0),G1(:,:,:,134))
  call check_last_Q_A(l_switch,G1(:,:,:,134),Q(:,31),ZERO,G2tensor(:,95))
  call loop_VQ_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,96))
  call loop_Q_A(G0(:,:,:,96),Q(:,4),ZERO,G1(:,:,:,135))
  call loop_QA_Z(G1(:,:,:,135),wf(:,-3),G1(:,:,:,136),gZd)
  call loop_VS_V(G1(:,:,:,136),wf(:,-4),G1(:,:,:,137))
  call loop_ZA_Q(G1(:,:,:,137),wf(:,-1),G1(:,:,:,138),gZl)
  call loop_A_Q(G1(:,:,:,138),Q(:,30),ZERO,G2(:,:,:,68))
  call check_last_AQ_V(l_switch,G2(:,:,:,68),wf(:,0),G2tensor(:,96))
  call loop_ZQ_A(G1(:,:,:,137),wf(:,0),G1(:,:,:,139),gZl)
  call loop_Q_A(G1(:,:,:,139),Q(:,29),ZERO,G2(:,:,:,69))
  call check_last_QA_V(l_switch,G2(:,:,:,69),wf(:,-1),G2tensor(:,97))
  call loop_QA_Z(G0(:,:,:,1),wf(:,-1),G0(:,:,:,97),gZl)
  call loop_VS_V(G0(:,:,:,97),wf(:,-4),G0(:,:,:,98))
  call loop_ZA_Q(G0(:,:,:,98),wf(:,-3),G0(:,:,:,99),gZd)
  call loop_A_Q(G0(:,:,:,99),Q(:,26),ZERO,G1(:,:,:,140))
  call loop_AQ_Z(G1(:,:,:,140),wf(:,-2),G1(:,:,:,141),gZd)
  call loop_ZQ_A(G1(:,:,:,141),wf(:,0),G1(:,:,:,142),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,142),Q(:,31),ZERO,G2tensor(:,98))
  call loop_ZQ_A(G0(:,:,:,98),wf(:,-2),G0(:,:,:,100),gZd)
  call loop_Q_A(G0(:,:,:,100),Q(:,22),ZERO,G1(:,:,:,143))
  call loop_QA_Z(G1(:,:,:,143),wf(:,-3),G1(:,:,:,144),gZd)
  call loop_ZQ_A(G1(:,:,:,144),wf(:,0),G1(:,:,:,145),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,145),Q(:,31),ZERO,G2tensor(:,99))
  call loop_ZQ_A(G0(:,:,:,97),wf(:,-2),G0(:,:,:,101),gZd)
  call loop_Q_A(G0(:,:,:,101),Q(:,6),ZERO,G1(:,:,:,146))
  call loop_QA_Z(G1(:,:,:,146),wf(:,-3),G1(:,:,:,147),gZd)
  call loop_VS_V(G1(:,:,:,147),wf(:,-4),G1(:,:,:,148))
  call loop_ZQ_A(G1(:,:,:,148),wf(:,0),G1(:,:,:,149),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,149),Q(:,31),ZERO,G2tensor(:,100))
  call loop_ZA_Q(G0(:,:,:,97),wf(:,-3),G0(:,:,:,102),gZd)
  call loop_A_Q(G0(:,:,:,102),Q(:,10),ZERO,G1(:,:,:,150))
  call loop_AQ_Z(G1(:,:,:,150),wf(:,-2),G1(:,:,:,151),gZd)
  call loop_VS_V(G1(:,:,:,151),wf(:,-4),G1(:,:,:,152))
  call loop_ZQ_A(G1(:,:,:,152),wf(:,0),G1(:,:,:,153),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,153),Q(:,31),ZERO,G2tensor(:,101))
  call loop_SS_S(G0(:,:,:,1),wf(:,-4),G0(:,:,:,103))
  call check_last_SVV_S(l_switch,G0(:,:,:,103),wf(:,4),wf(:,5),G0tensor(:,11))
  call check_last_SVV_S(l_switch,G0(:,:,:,103),wf(:,2),wf(:,4),G0tensor(:,12))
  call check_last_SVV_S(l_switch,G0(:,:,:,103),wf(:,1),wf(:,5),G0tensor(:,13))
  call check_last_SVV_S(l_switch,G0(:,:,:,103),wf(:,1),wf(:,2),G0tensor(:,14))
  call loop_SS_S(G0(:,:,:,1),wf(:,-4),G0(:,:,:,104))
  call check_last_SVV_S(l_switch,G0(:,:,:,104),wf(:,1),wf(:,2),G0tensor(:,15))
  call loop_SS_S(G0(:,:,:,1),wf(:,-4),G0(:,:,:,105))
  call check_last_SVV_S(l_switch,G0(:,:,:,105),wf(:,1),wf(:,2),G0tensor(:,16))
  call loop_VS_V(G0(:,:,:,1),wf(:,-4),G0(:,:,:,106))
  call check_last_VWW_V(l_switch,G0(:,:,:,106),wf(:,4),wf(:,5),G0tensor(:,17))
  call check_last_VWW_V(l_switch,G0(:,:,:,106),wf(:,2),wf(:,4),G0tensor(:,18))
  call check_last_VWW_V(l_switch,G0(:,:,:,106),wf(:,1),wf(:,5),G0tensor(:,19))
  call check_last_VWW_V(l_switch,G0(:,:,:,106),wf(:,1),wf(:,2),G0tensor(:,20))
  call loop_VVS_S(G0(:,:,:,1),wf(:,5),wf(:,-4),G0(:,:,:,107))
  call check_last_SV_V(l_switch,G0(:,:,:,107),wf(:,4),G0tensor(:,21))
  call check_last_SV_V(l_switch,G0(:,:,:,107),wf(:,1),G0tensor(:,22))
  call loop_VVS_S(G0(:,:,:,1),wf(:,2),wf(:,-4),G0(:,:,:,108))
  call check_last_SV_V(l_switch,G0(:,:,:,108),wf(:,4),G0tensor(:,23))
  call check_last_SV_V(l_switch,G0(:,:,:,108),wf(:,1),G0tensor(:,24))
  call loop_VVS_S(G0(:,:,:,1),wf(:,2),wf(:,-4),G0(:,:,:,109))
  call check_last_SV_V(l_switch,G0(:,:,:,109),wf(:,1),G0tensor(:,25))
  call loop_VVS_S(G0(:,:,:,1),wf(:,4),wf(:,-4),G0(:,:,:,110))
  call check_last_SV_V(l_switch,G0(:,:,:,110),wf(:,5),G0tensor(:,26))
  call check_last_SV_V(l_switch,G0(:,:,:,110),wf(:,2),G0tensor(:,27))
  call loop_VVS_S(G0(:,:,:,1),wf(:,1),wf(:,-4),G0(:,:,:,111))
  call check_last_SV_V(l_switch,G0(:,:,:,111),wf(:,5),G0tensor(:,28))
  call check_last_SV_V(l_switch,G0(:,:,:,111),wf(:,2),G0tensor(:,29))
  call loop_VVS_S(G0(:,:,:,1),wf(:,1),wf(:,-4),G0(:,:,:,112))
  call check_last_SV_V(l_switch,G0(:,:,:,112),wf(:,2),G0tensor(:,30))
  call loop_QS_A(G0(:,:,:,1),wf(:,18),G0(:,:,:,113),gX)
  call loop_Q_A(G0(:,:,:,113),Q(:,19),MM,G1(:,:,:,154))
  call loop_QV_A(G1(:,:,:,154),wf(:,5),G1(:,:,:,155))
  call check_last_Q_A(l_switch,G1(:,:,:,155),Q(:,31),MM,G2tensor(:,102))
  call loop_QZ_A(G1(:,:,:,154),wf(:,2),G1(:,:,:,156),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,156),Q(:,31),MM,G2tensor(:,103))
  call loop_QS_A(G0(:,:,:,1),wf(:,18),G0(:,:,:,114),gX)
  call loop_Q_A(G0(:,:,:,114),Q(:,19),ML,G1(:,:,:,157))
  call loop_QV_A(G1(:,:,:,157),wf(:,5),G1(:,:,:,158))
  call check_last_Q_A(l_switch,G1(:,:,:,158),Q(:,31),ML,G2tensor(:,104))
  call loop_QZ_A(G1(:,:,:,157),wf(:,2),G1(:,:,:,159),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,159),Q(:,31),ML,G2tensor(:,105))
  call loop_QS_A(G0(:,:,:,1),wf(:,18),G0(:,:,:,115),gX)
  call loop_Q_A(G0(:,:,:,115),Q(:,19),MT,G1(:,:,:,160))
  call loop_QV_A(G1(:,:,:,160),wf(:,5),G1(:,:,:,161))
  call check_last_Q_A(l_switch,G1(:,:,:,161),Q(:,31),MT,G2tensor(:,106))
  call loop_QZ_A(G1(:,:,:,160),wf(:,2),G1(:,:,:,162),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,162),Q(:,31),MT,G2tensor(:,107))
  call loop_QS_A(G0(:,:,:,1),wf(:,18),G0(:,:,:,116),gX)
  call loop_Q_A(G0(:,:,:,116),Q(:,19),MB,G1(:,:,:,163))
  call loop_QV_A(G1(:,:,:,163),wf(:,5),G1(:,:,:,164))
  call check_last_Q_A(l_switch,G1(:,:,:,164),Q(:,31),MB,G2tensor(:,108))
  call loop_QZ_A(G1(:,:,:,163),wf(:,2),G1(:,:,:,165),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,165),Q(:,31),MB,G2tensor(:,109))
  call loop_SS_S(G0(:,:,:,1),wf(:,18),G0(:,:,:,117))
  call check_last_TV_S(l_switch,G0(:,:,:,117),Q(:,19),wf(:,2),Q(:,12),G1tensor(:,17))
  call loop_SS_S(G0(:,:,:,1),wf(:,18),G0(:,:,:,118))
  call check_last_CV_D(l_switch,G0(:,:,:,118),Q(:,19),wf(:,5),Q(:,12),G1tensor(:,18))
  call check_last_CV_D(l_switch,G0(:,:,:,118),Q(:,19),wf(:,2),Q(:,12),G1tensor(:,19))
  call loop_VT_S(G0(:,:,:,1),Q(:,0),wf(:,18),Q(:,19),G1(:,:,:,166))
  call check_last_SV_V(l_switch,G1(:,:,:,166),wf(:,5),G1tensor(:,20))
  call check_last_SV_V(l_switch,G1(:,:,:,166),wf(:,2),G1tensor(:,21))
  call loop_VS_T(G0(:,:,:,1),Q(:,0),wf(:,18),Q(:,19),G1(:,:,:,167))
  call check_last_SV_V(l_switch,G1(:,:,:,167),wf(:,2),G1tensor(:,22))
  call loop_QZ_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,119),gZl)
  call loop_Q_A(G0(:,:,:,119),Q(:,19),ZERO,G1(:,:,:,168))
  call loop_QV_A(G1(:,:,:,168),wf(:,5),G1(:,:,:,169))
  call check_last_Q_A(l_switch,G1(:,:,:,169),Q(:,31),ZERO,G2tensor(:,110))
  call loop_QZ_A(G1(:,:,:,168),wf(:,2),G1(:,:,:,170),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,170),Q(:,31),ZERO,G2tensor(:,111))
  call loop_QZ_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,120),gZl)
  call loop_Q_A(G0(:,:,:,120),Q(:,19),MM,G1(:,:,:,171))
  call loop_QV_A(G1(:,:,:,171),wf(:,5),G1(:,:,:,172))
  call check_last_Q_A(l_switch,G1(:,:,:,172),Q(:,31),MM,G2tensor(:,112))
  call loop_QZ_A(G1(:,:,:,171),wf(:,2),G1(:,:,:,173),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,173),Q(:,31),MM,G2tensor(:,113))
  call loop_QZ_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,121),gZl)
  call loop_Q_A(G0(:,:,:,121),Q(:,19),ML,G1(:,:,:,174))
  call loop_QV_A(G1(:,:,:,174),wf(:,5),G1(:,:,:,175))
  call check_last_Q_A(l_switch,G1(:,:,:,175),Q(:,31),ML,G2tensor(:,114))
  call loop_QZ_A(G1(:,:,:,174),wf(:,2),G1(:,:,:,176),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,176),Q(:,31),ML,G2tensor(:,115))
  call loop_QZ_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,122),gZu)
  call loop_Q_A(G0(:,:,:,122),Q(:,19),ZERO,G1(:,:,:,177))
  call loop_QV_A(G1(:,:,:,177),wf(:,5),G1(:,:,:,178))
  call check_last_Q_A(l_switch,G1(:,:,:,178),Q(:,31),ZERO,G2tensor(:,116))
  call loop_QZ_A(G1(:,:,:,177),wf(:,2),G1(:,:,:,179),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,179),Q(:,31),ZERO,G2tensor(:,117))
  call loop_QZ_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,123),gZu)
  call loop_Q_A(G0(:,:,:,123),Q(:,19),MT,G1(:,:,:,180))
  call loop_QV_A(G1(:,:,:,180),wf(:,5),G1(:,:,:,181))
  call check_last_Q_A(l_switch,G1(:,:,:,181),Q(:,31),MT,G2tensor(:,118))
  call loop_QZ_A(G1(:,:,:,180),wf(:,2),G1(:,:,:,182),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,182),Q(:,31),MT,G2tensor(:,119))
  call loop_QZ_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,124),gZd)
  call loop_Q_A(G0(:,:,:,124),Q(:,19),ZERO,G1(:,:,:,183))
  call loop_QV_A(G1(:,:,:,183),wf(:,5),G1(:,:,:,184))
  call check_last_Q_A(l_switch,G1(:,:,:,184),Q(:,31),ZERO,G2tensor(:,120))
  call loop_QZ_A(G1(:,:,:,183),wf(:,2),G1(:,:,:,185),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,185),Q(:,31),ZERO,G2tensor(:,121))
  call loop_QZ_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,125),gZd)
  call loop_Q_A(G0(:,:,:,125),Q(:,19),MB,G1(:,:,:,186))
  call loop_QV_A(G1(:,:,:,186),wf(:,5),G1(:,:,:,187))
  call check_last_Q_A(l_switch,G1(:,:,:,187),Q(:,31),MB,G2tensor(:,122))
  call loop_QZ_A(G1(:,:,:,186),wf(:,2),G1(:,:,:,188),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,188),Q(:,31),MB,G2tensor(:,123))
  call loop_QZ_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,126),gZn)
  call loop_Q_A(G0(:,:,:,126),Q(:,19),ZERO,G1(:,:,:,189))
  call loop_QZ_A(G1(:,:,:,189),wf(:,2),G1(:,:,:,190),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,190),Q(:,31),ZERO,G2tensor(:,124))
  call loop_TV_S(G0(:,:,:,1),Q(:,0),wf(:,3),Q(:,19),G1(:,:,:,191))
  call check_last_TV_S(l_switch,G1(:,:,:,191),Q(:,19),wf(:,5),Q(:,12),G2tensor(:,125))
  call check_last_TV_S(l_switch,G1(:,:,:,191),Q(:,19),wf(:,2),Q(:,12),G2tensor(:,126))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,3),Q(:,19),G1(:,:,:,192))
  call check_last_TV_S(l_switch,G1(:,:,:,192),Q(:,19),wf(:,2),Q(:,12),G2tensor(:,127))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,3),Q(:,19),G1(:,:,:,193))
  call check_last_CV_D(l_switch,G1(:,:,:,193),Q(:,19),wf(:,5),Q(:,12),G2tensor(:,128))
  call check_last_CV_D(l_switch,G1(:,:,:,193),Q(:,19),wf(:,2),Q(:,12),G2tensor(:,129))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,3),Q(:,19),G1(:,:,:,194))
  call check_last_UV_W(l_switch,G1(:,:,:,194),Q(:,19),wf(:,5),Q(:,12),G2tensor(:,130))
  call check_last_UV_W(l_switch,G1(:,:,:,194),Q(:,19),wf(:,2),Q(:,12),G2tensor(:,131))
  call loop_VV_S(G0(:,:,:,1),wf(:,3),G0(:,:,:,127))
  call check_last_SV_V(l_switch,G0(:,:,:,127),wf(:,5),G0tensor(:,31))
  call check_last_SV_V(l_switch,G0(:,:,:,127),wf(:,2),G0tensor(:,32))
  call loop_VV_S(G0(:,:,:,1),wf(:,3),G0(:,:,:,128))
  call check_last_SV_V(l_switch,G0(:,:,:,128),wf(:,2),G0tensor(:,33))
  call loop_QS_A(G0(:,:,:,1),wf(:,12),G0(:,:,:,129),gX)
  call loop_Q_A(G0(:,:,:,129),Q(:,28),MM,G1(:,:,:,195))
  call loop_QV_A(G1(:,:,:,195),wf(:,4),G1(:,:,:,196))
  call check_last_Q_A(l_switch,G1(:,:,:,196),Q(:,31),MM,G2tensor(:,132))
  call loop_QZ_A(G1(:,:,:,195),wf(:,1),G1(:,:,:,197),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,197),Q(:,31),MM,G2tensor(:,133))
  call loop_QS_A(G0(:,:,:,1),wf(:,12),G0(:,:,:,130),gX)
  call loop_Q_A(G0(:,:,:,130),Q(:,28),ML,G1(:,:,:,198))
  call loop_QV_A(G1(:,:,:,198),wf(:,4),G1(:,:,:,199))
  call check_last_Q_A(l_switch,G1(:,:,:,199),Q(:,31),ML,G2tensor(:,134))
  call loop_QZ_A(G1(:,:,:,198),wf(:,1),G1(:,:,:,200),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,200),Q(:,31),ML,G2tensor(:,135))
  call loop_QS_A(G0(:,:,:,1),wf(:,12),G0(:,:,:,131),gX)
  call loop_Q_A(G0(:,:,:,131),Q(:,28),MT,G1(:,:,:,201))
  call loop_QV_A(G1(:,:,:,201),wf(:,4),G1(:,:,:,202))
  call check_last_Q_A(l_switch,G1(:,:,:,202),Q(:,31),MT,G2tensor(:,136))
  call loop_QZ_A(G1(:,:,:,201),wf(:,1),G1(:,:,:,203),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,203),Q(:,31),MT,G2tensor(:,137))
  call loop_QS_A(G0(:,:,:,1),wf(:,12),G0(:,:,:,132),gX)
  call loop_Q_A(G0(:,:,:,132),Q(:,28),MB,G1(:,:,:,204))
  call loop_QV_A(G1(:,:,:,204),wf(:,4),G1(:,:,:,205))
  call check_last_Q_A(l_switch,G1(:,:,:,205),Q(:,31),MB,G2tensor(:,138))
  call loop_QZ_A(G1(:,:,:,204),wf(:,1),G1(:,:,:,206),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,206),Q(:,31),MB,G2tensor(:,139))
  call loop_SS_S(G0(:,:,:,1),wf(:,12),G0(:,:,:,133))
  call check_last_TV_S(l_switch,G0(:,:,:,133),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,23))
  call loop_SS_S(G0(:,:,:,1),wf(:,12),G0(:,:,:,134))
  call check_last_CV_D(l_switch,G0(:,:,:,134),Q(:,28),wf(:,4),Q(:,3),G1tensor(:,24))
  call check_last_CV_D(l_switch,G0(:,:,:,134),Q(:,28),wf(:,1),Q(:,3),G1tensor(:,25))
  call loop_VT_S(G0(:,:,:,1),Q(:,0),wf(:,12),Q(:,28),G1(:,:,:,207))
  call check_last_SV_V(l_switch,G1(:,:,:,207),wf(:,4),G1tensor(:,26))
  call check_last_SV_V(l_switch,G1(:,:,:,207),wf(:,1),G1tensor(:,27))
  call loop_VS_T(G0(:,:,:,1),Q(:,0),wf(:,12),Q(:,28),G1(:,:,:,208))
  call check_last_SV_V(l_switch,G1(:,:,:,208),wf(:,1),G1tensor(:,28))
  call loop_QZ_A(G0(:,:,:,1),wf(:,15),G0(:,:,:,135),gZl)
  call loop_Q_A(G0(:,:,:,135),Q(:,28),ZERO,G1(:,:,:,209))
  call loop_QV_A(G1(:,:,:,209),wf(:,4),G1(:,:,:,210))
  call check_last_Q_A(l_switch,G1(:,:,:,210),Q(:,31),ZERO,G2tensor(:,140))
  call loop_QZ_A(G1(:,:,:,209),wf(:,1),G1(:,:,:,211),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,211),Q(:,31),ZERO,G2tensor(:,141))
  call loop_QZ_A(G0(:,:,:,1),wf(:,15),G0(:,:,:,136),gZl)
  call loop_Q_A(G0(:,:,:,136),Q(:,28),MM,G1(:,:,:,212))
  call loop_QV_A(G1(:,:,:,212),wf(:,4),G1(:,:,:,213))
  call check_last_Q_A(l_switch,G1(:,:,:,213),Q(:,31),MM,G2tensor(:,142))
  call loop_QZ_A(G1(:,:,:,212),wf(:,1),G1(:,:,:,214),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,214),Q(:,31),MM,G2tensor(:,143))
  call loop_QZ_A(G0(:,:,:,1),wf(:,15),G0(:,:,:,137),gZl)
  call loop_Q_A(G0(:,:,:,137),Q(:,28),ML,G1(:,:,:,215))
  call loop_QV_A(G1(:,:,:,215),wf(:,4),G1(:,:,:,216))
  call check_last_Q_A(l_switch,G1(:,:,:,216),Q(:,31),ML,G2tensor(:,144))
  call loop_QZ_A(G1(:,:,:,215),wf(:,1),G1(:,:,:,217),gZl)
  call check_last_Q_A(l_switch,G1(:,:,:,217),Q(:,31),ML,G2tensor(:,145))
  call loop_QZ_A(G0(:,:,:,1),wf(:,15),G0(:,:,:,138),gZu)
  call loop_Q_A(G0(:,:,:,138),Q(:,28),ZERO,G1(:,:,:,218))
  call loop_QV_A(G1(:,:,:,218),wf(:,4),G1(:,:,:,219))
  call check_last_Q_A(l_switch,G1(:,:,:,219),Q(:,31),ZERO,G2tensor(:,146))
  call loop_QZ_A(G1(:,:,:,218),wf(:,1),G1(:,:,:,220),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,220),Q(:,31),ZERO,G2tensor(:,147))
  call loop_QZ_A(G0(:,:,:,1),wf(:,15),G0(:,:,:,139),gZu)
  call loop_Q_A(G0(:,:,:,139),Q(:,28),MT,G1(:,:,:,221))
  call loop_QV_A(G1(:,:,:,221),wf(:,4),G1(:,:,:,222))
  call check_last_Q_A(l_switch,G1(:,:,:,222),Q(:,31),MT,G2tensor(:,148))
  call loop_QZ_A(G1(:,:,:,221),wf(:,1),G1(:,:,:,223),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,223),Q(:,31),MT,G2tensor(:,149))
  call loop_QZ_A(G0(:,:,:,1),wf(:,15),G0(:,:,:,140),gZd)
  call loop_Q_A(G0(:,:,:,140),Q(:,28),ZERO,G1(:,:,:,224))
  call loop_QV_A(G1(:,:,:,224),wf(:,4),G1(:,:,:,225))
  call check_last_Q_A(l_switch,G1(:,:,:,225),Q(:,31),ZERO,G2tensor(:,150))
  call loop_QZ_A(G1(:,:,:,224),wf(:,1),G1(:,:,:,226),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,226),Q(:,31),ZERO,G2tensor(:,151))
  call loop_QZ_A(G0(:,:,:,1),wf(:,15),G0(:,:,:,141),gZd)
  call loop_Q_A(G0(:,:,:,141),Q(:,28),MB,G1(:,:,:,227))
  call loop_QV_A(G1(:,:,:,227),wf(:,4),G1(:,:,:,228))
  call check_last_Q_A(l_switch,G1(:,:,:,228),Q(:,31),MB,G2tensor(:,152))
  call loop_QZ_A(G1(:,:,:,227),wf(:,1),G1(:,:,:,229),gZd)
  call check_last_Q_A(l_switch,G1(:,:,:,229),Q(:,31),MB,G2tensor(:,153))
  call loop_QZ_A(G0(:,:,:,1),wf(:,15),G0(:,:,:,142),gZn)
  call loop_Q_A(G0(:,:,:,142),Q(:,28),ZERO,G1(:,:,:,230))
  call loop_QZ_A(G1(:,:,:,230),wf(:,1),G1(:,:,:,231),gZn)
  call check_last_Q_A(l_switch,G1(:,:,:,231),Q(:,31),ZERO,G2tensor(:,154))
  call loop_TV_S(G0(:,:,:,1),Q(:,0),wf(:,15),Q(:,28),G1(:,:,:,232))
  call check_last_TV_S(l_switch,G1(:,:,:,232),Q(:,28),wf(:,4),Q(:,3),G2tensor(:,155))
  call check_last_TV_S(l_switch,G1(:,:,:,232),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,156))
  call loop_SV_T(G0(:,:,:,1),Q(:,0),wf(:,15),Q(:,28),G1(:,:,:,233))
  call check_last_TV_S(l_switch,G1(:,:,:,233),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,157))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,15),Q(:,28),G1(:,:,:,234))
  call check_last_CV_D(l_switch,G1(:,:,:,234),Q(:,28),wf(:,4),Q(:,3),G2tensor(:,158))
  call check_last_CV_D(l_switch,G1(:,:,:,234),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,159))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,15),Q(:,28),G1(:,:,:,235))
  call check_last_UV_W(l_switch,G1(:,:,:,235),Q(:,28),wf(:,4),Q(:,3),G2tensor(:,160))
  call check_last_UV_W(l_switch,G1(:,:,:,235),Q(:,28),wf(:,1),Q(:,3),G2tensor(:,161))
  call loop_VV_S(G0(:,:,:,1),wf(:,15),G0(:,:,:,143))
  call check_last_SV_V(l_switch,G0(:,:,:,143),wf(:,4),G0tensor(:,34))
  call check_last_SV_V(l_switch,G0(:,:,:,143),wf(:,1),G0tensor(:,35))
  call loop_VV_S(G0(:,:,:,1),wf(:,15),G0(:,:,:,144))
  call check_last_SV_V(l_switch,G0(:,:,:,144),wf(:,1),G0tensor(:,36))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (-(c(79)*M(2))) * den(6)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,1)
  Gcoeff = (-(c(77)*M(2))) * den(6)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,3)
  Gcoeff = (-(c(79)*M(2))) * den(6)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,5)
  Gcoeff = (-(c(77)*M(2))) * den(6)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,7)
  Gcoeff = (-(c(81)*M(2))) * den(6)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,9)
  Gcoeff = (-(c(81)*M(2))) * den(6)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,11)
  Gcoeff = (-(c(73)*M(2))) * den(6)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,13)
  Gcoeff = (-(c(73)*M(2))) * den(6)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,15)
  Gcoeff = (-(c(80)*M(2))) * den(7)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,17)
  Gcoeff = (-(c(78)*M(2))) * den(7)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,19)
  Gcoeff = (-(c(80)*M(2))) * den(7)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,21)
  Gcoeff = (-(c(78)*M(2))) * den(7)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,23)
  Gcoeff = (c(83)*M(2)) * den(7)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,25)
  Gcoeff = (c(83)*M(2)) * den(7)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,27)
  Gcoeff = (-(c(75)*M(2))) * den(7)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,29)
  Gcoeff = (-(c(75)*M(2))) * den(7)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,31)
  Gcoeff = (-(c(79)*M(2))) * den(8)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,2)
  Gcoeff = (-(c(77)*M(2))) * den(8)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,4)
  Gcoeff = (-(c(79)*M(2))) * den(8)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,6)
  Gcoeff = (-(c(77)*M(2))) * den(8)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,8)
  Gcoeff = (c(82)*M(2)) * den(8)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,10)
  Gcoeff = (c(82)*M(2)) * den(8)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,12)
  Gcoeff = (-(c(74)*M(2))) * den(8)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,14)
  Gcoeff = (-(c(74)*M(2))) * den(8)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,16)
  Gcoeff = (-(c(80)*M(2))) * den(3)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,18)
  Gcoeff = (-(c(78)*M(2))) * den(3)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,20)
  Gcoeff = (-(c(80)*M(2))) * den(3)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,22)
  Gcoeff = (-(c(78)*M(2))) * den(3)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,24)
  Gcoeff = (-(c(84)*M(2))) * den(3)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,26)
  Gcoeff = (-(c(84)*M(2))) * den(3)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,28)
  Gcoeff = (-(c(76)*M(2))) * den(3)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,30)
  Gcoeff = (-(c(76)*M(2))) * den(3)
  T3sum(1:35,4) = T3sum(1:35,4) + Gcoeff * G3tensor(:,32)
  Gcoeff = (c(35)*M(2)) * den(6)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(35)*M(2)) * den(6)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,5)
  Gcoeff = (-(c(53)*M(2))) * den(7)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,9)
  Gcoeff = (-(c(53)*M(2))) * den(7)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,13)
  Gcoeff = (-(c(51)*M(2))) * den(8)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,2)
  Gcoeff = (-(c(51)*M(2))) * den(8)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,6)
  Gcoeff = (-(c(13)*M(2))) * den(3)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,17)
  Gcoeff = (-(c(12)*M(2))) * den(3)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(59)*M(2)) * den(3)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(59)*M(2)) * den(3)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,14)
  Gcoeff = (-(c(37)*M(2))) * den(6)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,20)
  Gcoeff = (-(c(37)*M(2))) * den(6)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,22)
  Gcoeff = (-(c(37)*M(2))) * den(6)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,20)
  Gcoeff = (-(c(37)*M(2))) * den(6)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(33)*M(2)) * den(7)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(33)*M(2)) * den(7)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(33)*M(2)) * den(7)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(33)*M(2)) * den(7)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(31)*M(2)) * den(8)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(31)*M(2)) * den(8)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(31)*M(2)) * den(8)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(31)*M(2)) * den(8)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,23)
  Gcoeff = (-(c(23)*M(2))) * den(3)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,25)
  Gcoeff = (-(c(23)*M(2))) * den(3)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,27)
  Gcoeff = (-(c(23)*M(2))) * den(3)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,25)
  Gcoeff = (-(c(23)*M(2))) * den(3)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(38)*M(2)) * den(6)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(38)*M(2)) * den(6)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,32)
  Gcoeff = (-(c(34)*M(2))) * den(7)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,36)
  Gcoeff = (-(c(34)*M(2))) * den(7)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,40)
  Gcoeff = (-(c(32)*M(2))) * den(8)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,29)
  Gcoeff = (-(c(32)*M(2))) * den(8)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(24)*M(2)) * den(3)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,37)
  Gcoeff = (c(24)*M(2)) * den(3)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,41)
  Gcoeff = (-(c(45)*M(2))) * den(6)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,1)
  Gcoeff = (-(c(45)*M(2))) * den(6)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,1)
  Gcoeff = (-(c(4)*M(2))) * den(7)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,3)
  Gcoeff = (-(c(4)*M(2))) * den(7)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,3)
  Gcoeff = (-(c(3)*M(2))) * den(8)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,2)
  Gcoeff = (-(c(3)*M(2))) * den(8)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,2)
  Gcoeff = (-(c(25)*M(2))) * den(3)
  T2sum(1:1,2) = T2sum(1:1,2) + Gcoeff * G0tensor(:,5)
  Gcoeff = (-(c(48)*M(2))) * den(3)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,4)
  Gcoeff = (-(c(48)*M(2))) * den(3)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,4)
  Gcoeff = (-(c(37)*M(2))) * den(6)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,52)
  Gcoeff = (c(37)*M(2)) * den(6)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,53)
  Gcoeff = (-(c(2)*M(2))) * den(7)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,56)
  Gcoeff = (c(2)*M(2)) * den(7)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,57)
  Gcoeff = (c(57)*M(2)) * den(8)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,54)
  Gcoeff = (-(c(57)*M(2))) * den(8)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,55)
  Gcoeff = (-(c(20)*M(2))) * den(3)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,60)
  Gcoeff = (-(c(62)*M(2))) * den(3)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,58)
  Gcoeff = (c(62)*M(2)) * den(3)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,59)
  Gcoeff = (c(37)*M(2)) * den(6)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,3)
  Gcoeff = (-(c(37)*M(2))) * den(6)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,7)
  Gcoeff = (-(c(58)*M(2))) * den(7)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(58)*M(2)) * den(7)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(1)*M(2)) * den(8)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,4)
  Gcoeff = (-(c(1)*M(2))) * den(8)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,8)
  Gcoeff = (-(c(20)*M(2))) * den(3)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(62)*M(2)) * den(3)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,12)
  Gcoeff = (-(c(62)*M(2))) * den(3)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,16)
  Gcoeff = (-(c(37)*M(2))) * den(6)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,30)
  Gcoeff = (c(37)*M(2)) * den(6)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,34)
  Gcoeff = (c(33)*M(2)) * den(7)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,38)
  Gcoeff = (-(c(33)*M(2))) * den(7)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,42)
  Gcoeff = (-(c(1)*M(2))) * den(8)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(1)*M(2)) * den(8)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,35)
  Gcoeff = (c(39)*M(2)) * den(3)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,39)
  Gcoeff = (-(c(39)*M(2))) * den(3)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(37)*M(2)) * den(6)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,44)
  Gcoeff = (-(c(37)*M(2))) * den(6)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,45)
  Gcoeff = (c(2)*M(2)) * den(7)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,48)
  Gcoeff = (-(c(2)*M(2))) * den(7)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,49)
  Gcoeff = (-(c(31)*M(2))) * den(8)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,46)
  Gcoeff = (c(31)*M(2)) * den(8)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,47)
  Gcoeff = (-(c(39)*M(2))) * den(3)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,50)
  Gcoeff = (c(39)*M(2)) * den(3)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,51)
  Gcoeff = (-(c(46)*M(2))) * den(6)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,6)
  Gcoeff = (-(c(46)*M(2))) * den(6)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,6)
  Gcoeff = (-(c(8)*M(2))) * den(7)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,8)
  Gcoeff = (-(c(8)*M(2))) * den(7)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,8)
  Gcoeff = (-(c(7)*M(2))) * den(8)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,7)
  Gcoeff = (-(c(7)*M(2))) * den(8)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,7)
  Gcoeff = (-(c(26)*M(2))) * den(3)
  T2sum(1:1,3) = T2sum(1:1,3) + Gcoeff * G0tensor(:,10)
  Gcoeff = (-(c(50)*M(2))) * den(3)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,9)
  Gcoeff = (-(c(50)*M(2))) * den(3)
  T2sum(1:1,1) = T2sum(1:1,1) + Gcoeff * G0tensor(:,9)
  Gcoeff = (c(42)*M(2)) * den(18)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(15)*M(2)) * den(18)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,3)
  Gcoeff = (c(43)*M(2)) * den(19)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(18)*M(2)) * den(19)
  T1sum(1:5,2) = T1sum(1:5,2) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(42)*M(2)) * den(21)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,5)
  Gcoeff = (c(15)*M(2)) * den(21)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(43)*M(2)) * den(22)
  T1sum(1:5,3) = T1sum(1:5,3) + Gcoeff * G1tensor(:,7)
  Gcoeff = (c(18)*M(2)) * den(22)
  T1sum(1:5,4) = T1sum(1:5,4) + Gcoeff * G1tensor(:,8)
  Gcoeff = (c(40)*M(2)) * den(14)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,62)
  Gcoeff = (c(43)*M(2)) * den(14)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,65)
  Gcoeff = (c(22)*M(2)) * den(14)
  T2sum(1:15,6) = T2sum(1:15,6) + Gcoeff * G2tensor(:,66)
  Gcoeff = (c(44)*M(1)) * den(14)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,62)
  Gcoeff = (c(10)*M(2)) * den(14)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,61)
  Gcoeff = (-(c(16)*M(2))) * den(4)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,67)
  Gcoeff = (-(c(28)*M(2))) * den(1)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,68)
  Gcoeff = (-(c(18)*M(2))) * den(4)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,69)
  Gcoeff = (c(11)*M(2)) * den(1)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,70)
  Gcoeff = (c(16)*M(2)) * den(4)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,71)
  Gcoeff = (c(28)*M(2)) * den(1)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,72)
  Gcoeff = (-(c(18)*M(2))) * den(4)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,73)
  Gcoeff = (c(11)*M(2)) * den(1)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,74)
  Gcoeff = (c(42)*M(2)) * den(4)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,75)
  Gcoeff = (-(c(17)*M(2))) * den(4)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,77)
  Gcoeff = (c(43)*M(2)) * den(1)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,76)
  Gcoeff = (c(18)*M(2)) * den(1)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,78)
  Gcoeff = (c(42)*M(2)) * den(24)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,9)
  Gcoeff = (c(15)*M(2)) * den(24)
  T1sum(1:5,6) = T1sum(1:5,6) + Gcoeff * G1tensor(:,10)
  Gcoeff = (c(43)*M(2)) * den(25)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,11)
  Gcoeff = (c(18)*M(2)) * den(25)
  T1sum(1:5,6) = T1sum(1:5,6) + Gcoeff * G1tensor(:,12)
  Gcoeff = (c(42)*M(2)) * den(27)
  T1sum(1:5,7) = T1sum(1:5,7) + Gcoeff * G1tensor(:,13)
  Gcoeff = (c(15)*M(2)) * den(27)
  T1sum(1:5,8) = T1sum(1:5,8) + Gcoeff * G1tensor(:,14)
  Gcoeff = (c(43)*M(2)) * den(28)
  T1sum(1:5,7) = T1sum(1:5,7) + Gcoeff * G1tensor(:,15)
  Gcoeff = (c(18)*M(2)) * den(28)
  T1sum(1:5,8) = T1sum(1:5,8) + Gcoeff * G1tensor(:,16)
  Gcoeff = (c(43)*M(2)) * den(10)
  T2sum(1:15,12) = T2sum(1:15,12) + Gcoeff * G2tensor(:,79)
  Gcoeff = (c(43)*M(2)) * den(10)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,80)
  Gcoeff = (c(22)*M(2)) * den(10)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,81)
  Gcoeff = (c(10)*M(2)) * den(10)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,82)
  Gcoeff = (-(c(14)*M(2))) * den(5)
  T2sum(1:15,16) = T2sum(1:15,16) + Gcoeff * G2tensor(:,83)
  Gcoeff = (-(c(28)*M(2))) * den(2)
  T2sum(1:15,16) = T2sum(1:15,16) + Gcoeff * G2tensor(:,84)
  Gcoeff = (-(c(15)*M(2))) * den(5)
  T2sum(1:15,16) = T2sum(1:15,16) + Gcoeff * G2tensor(:,85)
  Gcoeff = (c(11)*M(2)) * den(2)
  T2sum(1:15,16) = T2sum(1:15,16) + Gcoeff * G2tensor(:,86)
  Gcoeff = (c(14)*M(2)) * den(5)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,87)
  Gcoeff = (c(28)*M(2)) * den(2)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,88)
  Gcoeff = (-(c(15)*M(2))) * den(5)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,89)
  Gcoeff = (c(11)*M(2)) * den(2)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,90)
  Gcoeff = (c(42)*M(2)) * den(5)
  T2sum(1:15,18) = T2sum(1:15,18) + Gcoeff * G2tensor(:,93)
  Gcoeff = (c(43)*M(2)) * den(2)
  T2sum(1:15,18) = T2sum(1:15,18) + Gcoeff * G2tensor(:,94)
  Gcoeff = (c(18)*M(2)) * den(2)
  T2sum(1:15,19) = T2sum(1:15,19) + Gcoeff * G2tensor(:,95)
  Gcoeff = (c(42)*M(2))
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,96)
  Gcoeff = (c(43)*M(2))
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,98)
  Gcoeff = (c(42)*M(2))
  T2sum(1:15,22) = T2sum(1:15,22) + Gcoeff * G2tensor(:,63)
  Gcoeff = (c(43)*M(2))
  T2sum(1:15,23) = T2sum(1:15,23) + Gcoeff * G2tensor(:,99)
  Gcoeff = (c(9)*M(2))
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,91)
  Gcoeff = (c(42)*M(2))
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,97)
  Gcoeff = (c(43)*M(2))
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,100)
  Gcoeff = (c(9)*M(2))
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,92)
  Gcoeff = (c(42)*M(2))
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,64)
  Gcoeff = (c(43)*M(2))
  T2sum(1:15,29) = T2sum(1:15,29) + Gcoeff * G2tensor(:,101)
  Gcoeff = (-(c(36)*M(2))) * den(6)
  T0sum(1:1,1) = T0sum(1:1,1) + Gcoeff * G0tensor(:,11)
  Gcoeff = (c(54)*M(2)) * den(7)
  T0sum(1:1,1) = T0sum(1:1,1) + Gcoeff * G0tensor(:,12)
  Gcoeff = (c(52)*M(2)) * den(8)
  T0sum(1:1,1) = T0sum(1:1,1) + Gcoeff * G0tensor(:,13)
  Gcoeff = (-(c(13)*M(2))) * den(3)
  T0sum(1:1,2) = T0sum(1:1,2) + Gcoeff * G0tensor(:,15)
  Gcoeff = (-(c(12)*M(2))) * den(3)
  T0sum(1:1,3) = T0sum(1:1,3) + Gcoeff * G0tensor(:,16)
  Gcoeff = (-(c(60)*M(2))) * den(3)
  T0sum(1:1,1) = T0sum(1:1,1) + Gcoeff * G0tensor(:,14)
  Gcoeff = (-(c(38)*M(2))) * den(6)
  T0sum(1:1,1) = T0sum(1:1,1) + Gcoeff * G0tensor(:,17)
  Gcoeff = (c(34)*M(2)) * den(7)
  T0sum(1:1,1) = T0sum(1:1,1) + Gcoeff * G0tensor(:,18)
  Gcoeff = (c(32)*M(2)) * den(8)
  T0sum(1:1,1) = T0sum(1:1,1) + Gcoeff * G0tensor(:,19)
  Gcoeff = (-(c(24)*M(2))) * den(3)
  T0sum(1:1,1) = T0sum(1:1,1) + Gcoeff * G0tensor(:,20)
  Gcoeff = (-(c(37)*M(2))) * den(6)
  T2sum(1:1,30) = T2sum(1:1,30) + Gcoeff * G0tensor(:,21)
  Gcoeff = (-(c(37)*M(2))) * den(6)
  T2sum(1:1,30) = T2sum(1:1,30) + Gcoeff * G0tensor(:,21)
  Gcoeff = (-(c(2)*M(2))) * den(7)
  T2sum(1:1,30) = T2sum(1:1,30) + Gcoeff * G0tensor(:,23)
  Gcoeff = (-(c(2)*M(2))) * den(7)
  T2sum(1:1,30) = T2sum(1:1,30) + Gcoeff * G0tensor(:,23)
  Gcoeff = (-(c(1)*M(2))) * den(8)
  T2sum(1:1,30) = T2sum(1:1,30) + Gcoeff * G0tensor(:,22)
  Gcoeff = (-(c(1)*M(2))) * den(8)
  T2sum(1:1,30) = T2sum(1:1,30) + Gcoeff * G0tensor(:,22)
  Gcoeff = (-(c(21)*M(2))) * den(3)
  T2sum(1:1,31) = T2sum(1:1,31) + Gcoeff * G0tensor(:,25)
  Gcoeff = (-(c(47)*M(2))) * den(3)
  T2sum(1:1,30) = T2sum(1:1,30) + Gcoeff * G0tensor(:,24)
  Gcoeff = (-(c(47)*M(2))) * den(3)
  T2sum(1:1,30) = T2sum(1:1,30) + Gcoeff * G0tensor(:,24)
  Gcoeff = (-(c(37)*M(2))) * den(6)
  T2sum(1:1,32) = T2sum(1:1,32) + Gcoeff * G0tensor(:,26)
  Gcoeff = (-(c(37)*M(2))) * den(6)
  T2sum(1:1,32) = T2sum(1:1,32) + Gcoeff * G0tensor(:,26)
  Gcoeff = (-(c(2)*M(2))) * den(7)
  T2sum(1:1,32) = T2sum(1:1,32) + Gcoeff * G0tensor(:,27)
  Gcoeff = (-(c(2)*M(2))) * den(7)
  T2sum(1:1,32) = T2sum(1:1,32) + Gcoeff * G0tensor(:,27)
  Gcoeff = (-(c(1)*M(2))) * den(8)
  T2sum(1:1,32) = T2sum(1:1,32) + Gcoeff * G0tensor(:,28)
  Gcoeff = (-(c(1)*M(2))) * den(8)
  T2sum(1:1,32) = T2sum(1:1,32) + Gcoeff * G0tensor(:,28)
  Gcoeff = (-(c(21)*M(2))) * den(3)
  T2sum(1:1,33) = T2sum(1:1,33) + Gcoeff * G0tensor(:,30)
  Gcoeff = (-(c(47)*M(2))) * den(3)
  T2sum(1:1,32) = T2sum(1:1,32) + Gcoeff * G0tensor(:,29)
  Gcoeff = (-(c(47)*M(2))) * den(3)
  T2sum(1:1,32) = T2sum(1:1,32) + Gcoeff * G0tensor(:,29)
  Gcoeff = (c(68)*M(2)) * den(15)
  T2sum(1:15,34) = T2sum(1:15,34) + Gcoeff * G2tensor(:,102)
  Gcoeff = (c(66)*M(2)) * den(15)
  T2sum(1:15,35) = T2sum(1:15,35) + Gcoeff * G2tensor(:,104)
  Gcoeff = (c(70)*M(2)) * den(15)
  T2sum(1:15,36) = T2sum(1:15,36) + Gcoeff * G2tensor(:,106)
  Gcoeff = (c(63)*M(2)) * den(15)
  T2sum(1:15,37) = T2sum(1:15,37) + Gcoeff * G2tensor(:,108)
  Gcoeff = (c(69)*M(2)) * den(16)
  T2sum(1:15,34) = T2sum(1:15,34) + Gcoeff * G2tensor(:,103)
  Gcoeff = (c(67)*M(2)) * den(16)
  T2sum(1:15,35) = T2sum(1:15,35) + Gcoeff * G2tensor(:,105)
  Gcoeff = (-(c(72)*M(2))) * den(16)
  T2sum(1:15,36) = T2sum(1:15,36) + Gcoeff * G2tensor(:,107)
  Gcoeff = (c(65)*M(2)) * den(16)
  T2sum(1:15,37) = T2sum(1:15,37) + Gcoeff * G2tensor(:,109)
  Gcoeff = (-(c(12)*M(2))) * den(16)
  T2sum(1:5,33) = T2sum(1:5,33) + Gcoeff * G1tensor(:,17)
  Gcoeff = (c(27)*M(2)) * den(15)
  T2sum(1:5,32) = T2sum(1:5,32) + Gcoeff * G1tensor(:,18)
  Gcoeff = (c(27)*M(2)) * den(15)
  T2sum(1:5,32) = T2sum(1:5,32) + Gcoeff * G1tensor(:,18)
  Gcoeff = (-(c(16)*M(2))) * den(16)
  T2sum(1:5,32) = T2sum(1:5,32) + Gcoeff * G1tensor(:,19)
  Gcoeff = (-(c(16)*M(2))) * den(16)
  T2sum(1:5,32) = T2sum(1:5,32) + Gcoeff * G1tensor(:,19)
  Gcoeff = (c(27)*M(2)) * den(15)
  T2sum(1:5,32) = T2sum(1:5,32) + Gcoeff * G1tensor(:,20)
  Gcoeff = (c(27)*M(2)) * den(15)
  T2sum(1:5,32) = T2sum(1:5,32) + Gcoeff * G1tensor(:,20)
  Gcoeff = (-(c(20)*M(2))) * den(16)
  T2sum(1:5,33) = T2sum(1:5,33) + Gcoeff * G1tensor(:,22)
  Gcoeff = (c(41)*M(2)) * den(16)
  T2sum(1:5,32) = T2sum(1:5,32) + Gcoeff * G1tensor(:,21)
  Gcoeff = (c(41)*M(2)) * den(16)
  T2sum(1:5,32) = T2sum(1:5,32) + Gcoeff * G1tensor(:,21)
  Gcoeff = (-(c(87)*M(2))) * den(15)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,110)
  Gcoeff = (-(c(87)*M(2))) * den(15)
  T2sum(1:15,34) = T2sum(1:15,34) + Gcoeff * G2tensor(:,112)
  Gcoeff = (-(c(87)*M(2))) * den(15)
  T2sum(1:15,35) = T2sum(1:15,35) + Gcoeff * G2tensor(:,114)
  Gcoeff = (c(89)*M(2)) * den(15)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,116)
  Gcoeff = (c(86)*M(2)) * den(15)
  T2sum(1:15,36) = T2sum(1:15,36) + Gcoeff * G2tensor(:,118)
  Gcoeff = (-(c(86)*M(2))) * den(15)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,120)
  Gcoeff = (-(c(85)*M(2))) * den(15)
  T2sum(1:15,37) = T2sum(1:15,37) + Gcoeff * G2tensor(:,122)
  Gcoeff = (-(c(95)*M(2))) * den(16)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,124)
  Gcoeff = (-(c(91)*M(2))) * den(16)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,111)
  Gcoeff = (-(c(91)*M(2))) * den(16)
  T2sum(1:15,34) = T2sum(1:15,34) + Gcoeff * G2tensor(:,113)
  Gcoeff = (-(c(91)*M(2))) * den(16)
  T2sum(1:15,35) = T2sum(1:15,35) + Gcoeff * G2tensor(:,115)
  Gcoeff = (-(c(94)*M(2))) * den(16)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,117)
  Gcoeff = (-(c(92)*M(2))) * den(16)
  T2sum(1:15,36) = T2sum(1:15,36) + Gcoeff * G2tensor(:,119)
  Gcoeff = (-(c(94)*M(2))) * den(16)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,121)
  Gcoeff = (-(c(92)*M(2))) * den(16)
  T2sum(1:15,37) = T2sum(1:15,37) + Gcoeff * G2tensor(:,123)
  Gcoeff = (-(c(55)*M(2))) * den(15)
  T2sum(1:15,32) = T2sum(1:15,32) + Gcoeff * G2tensor(:,125)
  Gcoeff = (-(c(20)*M(2))) * den(16)
  T2sum(1:15,33) = T2sum(1:15,33) + Gcoeff * G2tensor(:,127)
  Gcoeff = (c(61)*M(2)) * den(16)
  T2sum(1:15,32) = T2sum(1:15,32) + Gcoeff * G2tensor(:,126)
  Gcoeff = (c(29)*M(2)) * den(15)
  T2sum(1:15,32) = T2sum(1:15,32) + Gcoeff * G2tensor(:,128)
  Gcoeff = (c(29)*M(2)) * den(15)
  T2sum(1:15,32) = T2sum(1:15,32) + Gcoeff * G2tensor(:,128)
  Gcoeff = (-(c(19)*M(2))) * den(16)
  T2sum(1:15,32) = T2sum(1:15,32) + Gcoeff * G2tensor(:,129)
  Gcoeff = (-(c(19)*M(2))) * den(16)
  T2sum(1:15,32) = T2sum(1:15,32) + Gcoeff * G2tensor(:,129)
  Gcoeff = (-(c(29)*M(2))) * den(15)
  T2sum(1:15,32) = T2sum(1:15,32) + Gcoeff * G2tensor(:,130)
  Gcoeff = (c(19)*M(2)) * den(16)
  T2sum(1:15,32) = T2sum(1:15,32) + Gcoeff * G2tensor(:,131)
  Gcoeff = (-(c(5)*M(2))) * den(15)
  T2sum(1:1,32) = T2sum(1:1,32) + Gcoeff * G0tensor(:,31)
  Gcoeff = (-(c(5)*M(2))) * den(15)
  T2sum(1:1,32) = T2sum(1:1,32) + Gcoeff * G0tensor(:,31)
  Gcoeff = (-(c(26)*M(2))) * den(16)
  T2sum(1:1,33) = T2sum(1:1,33) + Gcoeff * G0tensor(:,33)
  Gcoeff = (-(c(49)*M(2))) * den(16)
  T2sum(1:1,32) = T2sum(1:1,32) + Gcoeff * G0tensor(:,32)
  Gcoeff = (-(c(49)*M(2))) * den(16)
  T2sum(1:1,32) = T2sum(1:1,32) + Gcoeff * G0tensor(:,32)
  Gcoeff = (c(69)*M(2)) * den(11)
  T2sum(1:15,39) = T2sum(1:15,39) + Gcoeff * G2tensor(:,132)
  Gcoeff = (c(67)*M(2)) * den(11)
  T2sum(1:15,40) = T2sum(1:15,40) + Gcoeff * G2tensor(:,134)
  Gcoeff = (c(71)*M(2)) * den(11)
  T2sum(1:15,41) = T2sum(1:15,41) + Gcoeff * G2tensor(:,136)
  Gcoeff = (c(64)*M(2)) * den(11)
  T2sum(1:15,42) = T2sum(1:15,42) + Gcoeff * G2tensor(:,138)
  Gcoeff = (c(69)*M(2)) * den(12)
  T2sum(1:15,39) = T2sum(1:15,39) + Gcoeff * G2tensor(:,133)
  Gcoeff = (c(67)*M(2)) * den(12)
  T2sum(1:15,40) = T2sum(1:15,40) + Gcoeff * G2tensor(:,135)
  Gcoeff = (-(c(72)*M(2))) * den(12)
  T2sum(1:15,41) = T2sum(1:15,41) + Gcoeff * G2tensor(:,137)
  Gcoeff = (c(65)*M(2)) * den(12)
  T2sum(1:15,42) = T2sum(1:15,42) + Gcoeff * G2tensor(:,139)
  Gcoeff = (-(c(12)*M(2))) * den(12)
  T2sum(1:5,31) = T2sum(1:5,31) + Gcoeff * G1tensor(:,23)
  Gcoeff = (c(28)*M(2)) * den(11)
  T2sum(1:5,30) = T2sum(1:5,30) + Gcoeff * G1tensor(:,24)
  Gcoeff = (c(28)*M(2)) * den(11)
  T2sum(1:5,30) = T2sum(1:5,30) + Gcoeff * G1tensor(:,24)
  Gcoeff = (-(c(16)*M(2))) * den(12)
  T2sum(1:5,30) = T2sum(1:5,30) + Gcoeff * G1tensor(:,25)
  Gcoeff = (-(c(16)*M(2))) * den(12)
  T2sum(1:5,30) = T2sum(1:5,30) + Gcoeff * G1tensor(:,25)
  Gcoeff = (c(28)*M(2)) * den(11)
  T2sum(1:5,30) = T2sum(1:5,30) + Gcoeff * G1tensor(:,26)
  Gcoeff = (c(28)*M(2)) * den(11)
  T2sum(1:5,30) = T2sum(1:5,30) + Gcoeff * G1tensor(:,26)
  Gcoeff = (-(c(20)*M(2))) * den(12)
  T2sum(1:5,31) = T2sum(1:5,31) + Gcoeff * G1tensor(:,28)
  Gcoeff = (c(41)*M(2)) * den(12)
  T2sum(1:5,30) = T2sum(1:5,30) + Gcoeff * G1tensor(:,27)
  Gcoeff = (c(41)*M(2)) * den(12)
  T2sum(1:5,30) = T2sum(1:5,30) + Gcoeff * G1tensor(:,27)
  Gcoeff = (-(c(91)*M(2))) * den(11)
  T2sum(1:15,43) = T2sum(1:15,43) + Gcoeff * G2tensor(:,140)
  Gcoeff = (-(c(91)*M(2))) * den(11)
  T2sum(1:15,39) = T2sum(1:15,39) + Gcoeff * G2tensor(:,142)
  Gcoeff = (-(c(91)*M(2))) * den(11)
  T2sum(1:15,40) = T2sum(1:15,40) + Gcoeff * G2tensor(:,144)
  Gcoeff = (c(93)*M(2)) * den(11)
  T2sum(1:15,43) = T2sum(1:15,43) + Gcoeff * G2tensor(:,146)
  Gcoeff = (c(90)*M(2)) * den(11)
  T2sum(1:15,41) = T2sum(1:15,41) + Gcoeff * G2tensor(:,148)
  Gcoeff = (-(c(90)*M(2))) * den(11)
  T2sum(1:15,43) = T2sum(1:15,43) + Gcoeff * G2tensor(:,150)
  Gcoeff = (-(c(88)*M(2))) * den(11)
  T2sum(1:15,42) = T2sum(1:15,42) + Gcoeff * G2tensor(:,152)
  Gcoeff = (-(c(95)*M(2))) * den(12)
  T2sum(1:15,43) = T2sum(1:15,43) + Gcoeff * G2tensor(:,154)
  Gcoeff = (-(c(91)*M(2))) * den(12)
  T2sum(1:15,43) = T2sum(1:15,43) + Gcoeff * G2tensor(:,141)
  Gcoeff = (-(c(91)*M(2))) * den(12)
  T2sum(1:15,39) = T2sum(1:15,39) + Gcoeff * G2tensor(:,143)
  Gcoeff = (-(c(91)*M(2))) * den(12)
  T2sum(1:15,40) = T2sum(1:15,40) + Gcoeff * G2tensor(:,145)
  Gcoeff = (-(c(94)*M(2))) * den(12)
  T2sum(1:15,43) = T2sum(1:15,43) + Gcoeff * G2tensor(:,147)
  Gcoeff = (-(c(92)*M(2))) * den(12)
  T2sum(1:15,41) = T2sum(1:15,41) + Gcoeff * G2tensor(:,149)
  Gcoeff = (-(c(94)*M(2))) * den(12)
  T2sum(1:15,43) = T2sum(1:15,43) + Gcoeff * G2tensor(:,151)
  Gcoeff = (-(c(92)*M(2))) * den(12)
  T2sum(1:15,42) = T2sum(1:15,42) + Gcoeff * G2tensor(:,153)
  Gcoeff = (-(c(56)*M(2))) * den(11)
  T2sum(1:15,30) = T2sum(1:15,30) + Gcoeff * G2tensor(:,155)
  Gcoeff = (-(c(20)*M(2))) * den(12)
  T2sum(1:15,31) = T2sum(1:15,31) + Gcoeff * G2tensor(:,157)
  Gcoeff = (c(61)*M(2)) * den(12)
  T2sum(1:15,30) = T2sum(1:15,30) + Gcoeff * G2tensor(:,156)
  Gcoeff = (c(30)*M(2)) * den(11)
  T2sum(1:15,30) = T2sum(1:15,30) + Gcoeff * G2tensor(:,158)
  Gcoeff = (c(30)*M(2)) * den(11)
  T2sum(1:15,30) = T2sum(1:15,30) + Gcoeff * G2tensor(:,158)
  Gcoeff = (-(c(19)*M(2))) * den(12)
  T2sum(1:15,30) = T2sum(1:15,30) + Gcoeff * G2tensor(:,159)
  Gcoeff = (-(c(19)*M(2))) * den(12)
  T2sum(1:15,30) = T2sum(1:15,30) + Gcoeff * G2tensor(:,159)
  Gcoeff = (-(c(30)*M(2))) * den(11)
  T2sum(1:15,30) = T2sum(1:15,30) + Gcoeff * G2tensor(:,160)
  Gcoeff = (c(19)*M(2)) * den(12)
  T2sum(1:15,30) = T2sum(1:15,30) + Gcoeff * G2tensor(:,161)
  Gcoeff = (-(c(6)*M(2))) * den(11)
  T2sum(1:1,30) = T2sum(1:1,30) + Gcoeff * G0tensor(:,34)
  Gcoeff = (-(c(6)*M(2))) * den(11)
  T2sum(1:1,30) = T2sum(1:1,30) + Gcoeff * G0tensor(:,34)
  Gcoeff = (-(c(26)*M(2))) * den(12)
  T2sum(1:1,31) = T2sum(1:1,31) + Gcoeff * G0tensor(:,36)
  Gcoeff = (-(c(49)*M(2))) * den(12)
  T2sum(1:1,30) = T2sum(1:1,30) + Gcoeff * G0tensor(:,35)
  Gcoeff = (-(c(49)*M(2))) * den(12)
  T2sum(1:1,30) = T2sum(1:1,30) + Gcoeff * G0tensor(:,35)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_1_pphll_ew_eexddxh_1_/**/REALKIND
