
module ol_colourmatrix_pphll_ew_nenexuuxh_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(17,1), K2(1,2), KL(1,2)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 3]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 3]

  K2(1,:) = [ 0, 3]

  KL(1,:) = [ 0, 3]


  end subroutine colourmatrix_init
end module ol_colourmatrix_pphll_ew_nenexuuxh_1_/**/REALKIND



module ol_forced_parameters_pphll_ew_nenexuuxh_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pphll_ew_nenexuuxh_1_/**/REALKIND

module ol_loop_pphll_ew_nenexuuxh_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(74), c(67)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-5+1:26)
  ! denominators
  complex(REALKIND), save :: den(20)
  ! Born, CT and Loop colour vector for each helicity configuration
  complex(REALKIND), save :: M0(1,16), Mct(2,16), Mcol_loop(2,16)
  ! zero helicity identifier
  logical,           save :: zerohel(16) = .true., zerohel_ct(16) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_decl_/**/DREALKIND, only: do_ew_renorm
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  call ensure_mp_loop_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (2*CI*countertermnorm*eQED**5*EWctHZA)/3._/**/REALKIND
    f( 2) = CI*countertermnorm*eQED**5*EWctHZZ
    f( 3) = (countertermnorm*eQED**5)/(cw*sw*3._/**/REALKIND)
    f( 4) = (countertermnorm*eQED**5)/(cw*sw*2._/**/REALKIND)
    f( 5) = (CI*eQED**3*MW)/(cw**2*sw)
    f( 6) = (2*CI*countertermnorm*eQED**5*MW)/(3._/**/REALKIND*cw**2*sw)
    f( 7) = (CI*countertermnorm*eQED**5*MW)/(cw**2*sw)
    f( 8) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2*MW)/(cw**2*sw)
    f( 9) = (eQED**5*integralnorm*MW*SwB)/(cw*3._/**/REALKIND)
    f(10) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw*3._/**/REALKIND)
    f(11) = (2*eQED**5*integralnorm*MW**3*SwB)/(cw**3*3._/**/REALKIND)
    f(12) = (2*eQED**5*integralnorm*MW**3*SwB)/(cw*3._/**/REALKIND)
    f(13) = (eQED**5*integralnorm*MW*SwB)/(sw**5*4._/**/REALKIND)
    f(14) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**4*2._/**/REALKIND)
    f(15) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**4*2._/**/REALKIND)
    f(16) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(17) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(18) = (eQED**5*integralnorm*MW*SwB)/(sw**3*6._/**/REALKIND)
    f(19) = (eQED**5*integralnorm*MW*SwB)/(sw**3*4._/**/REALKIND)
    f(20) = (eQED**5*integralnorm*MW*SwB)/(sw**3*3._/**/REALKIND)
    f(21) = (eQED**5*integralnorm*MW*SwB)/(sw**3*2._/**/REALKIND)
    f(22) = (eQED**5*integralnorm*MW*SwB)/sw**3
    f(23) = (eQED**5*integralnorm*MW*SwB)/(cw**4*sw**3*4._/**/REALKIND)
    f(24) = (eQED**5*integralnorm*MW*SwB)/(cw**4*sw**3*2._/**/REALKIND)
    f(25) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw**3*2._/**/REALKIND)
    f(26) = (cw**2*eQED**5*integralnorm*MW*SwB)/(sw**3*2._/**/REALKIND)
    f(27) = (cw**2*eQED**5*integralnorm*MW*SwB)/sw**3
    f(28) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(cw**4*sw**3*2._/**/REALKIND)
    f(29) = (eQED**5*integralnorm*MW**3*SwB)/(cw**6*sw**3)
    f(30) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*6._/**/REALKIND)
    f(31) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(32) = (2*eQED**5*integralnorm*MW*SwB)/(cw*sw**2*3._/**/REALKIND)
    f(33) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**2*3._/**/REALKIND)
    f(34) = (2*cw*eQED**5*integralnorm*MW*SwB)/(sw**2*3._/**/REALKIND)
    f(35) = (eQED**5*integralnorm*MW*SwB)/(sw*2._/**/REALKIND)
    f(36) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(37) = (4*eQED**5*integralnorm*MW*SwB)/(cw**2*sw*9._/**/REALKIND)
    f(38) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw)
    f(39) = (eQED**3*gQCD**2*integralnorm*MW*SwB)/(cw**2*sw)
    f(40) = (eQED**5*integralnorm*MW*sw*SwB)/(cw**2*2._/**/REALKIND)
    f(41) = (eQED**5*integralnorm*MH**2*MW*sw*SwB)/(cw**2*2._/**/REALKIND)
    f(42) = (eQED**5*integralnorm*MW**3*sw*SwB)/cw**4
    f(43) = (eQED**5*integralnorm*MW**3*sw*SwB)/cw**2
    f(44) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*6._/**/REALKIND)
    f(45) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*3._/**/REALKIND)
    f(46) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**2*3._/**/REALKIND)
    f(47) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*6._/**/REALKIND)
    f(48) = (eQED**5*integralnorm*MH**2*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW*sw**3*4._/**/REALKIND*8._/**/REALKIND)
    f(49) = (eQED**5*integralnorm*MH**2*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*MW*sw**3*2._/**/REALKIND*4._/**/REALKIND)
    f(50) = (eQED**5*integralnorm*MW*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**4*sw**3*2._/**/REALKIND*4._/**/REALKIND)
    f(51) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(52) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*18._/**/REALKIND)
    f(53) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(54) = (eQED**5*integralnorm*ML*SwF)/(cw*MW*sw**2*6._/**/REALKIND)
    f(55) = (eQED**5*integralnorm*ML*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(56) = (eQED**5*integralnorm*MM*SwF)/(cw*MW*sw**2*6._/**/REALKIND)
    f(57) = (eQED**5*integralnorm*MM*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(58) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*9._/**/REALKIND)
    f(59) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(60) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*9._/**/REALKIND)
    f(61) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*2._/**/REALKIND)
    f(62) = (eQED**5*integralnorm*ML*SwF)/(MW*sw*3._/**/REALKIND)
    f(63) = (eQED**5*integralnorm*ML*SwF)/(MW*sw*2._/**/REALKIND)
    f(64) = (eQED**5*integralnorm*MM*SwF)/(MW*sw*3._/**/REALKIND)
    f(65) = (eQED**5*integralnorm*MM*SwF)/(MW*sw*2._/**/REALKIND)
    f(66) = (2*eQED**5*integralnorm*MT*SwF)/(MW*sw*9._/**/REALKIND)
    f(67) = (eQED**5*integralnorm*MT*SwF)/(MW*sw*2._/**/REALKIND)
    f(68) = (2*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*9._/**/REALKIND)
    f(69) = (4*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*9._/**/REALKIND)
    f(70) = (2*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*3._/**/REALKIND)
    f(71) = (8*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*9._/**/REALKIND)
    f(72) = (eQED**5*integralnorm*MW*SwF)/(cw**2*sw)
    f(73) = (2*eQED**5*integralnorm*MW*SwF)/(cw**2*sw)
    f(74) = (3*eQED**5*integralnorm*MW*SwF)/(cw**2*sw)

  c = [ 3*f(9), 3*f(10), 3*f(11), 3*f(12), 3*f(13), 3*f(14), 3*f(15), 3*f(16), 3*f(17), 3*f(18), 3*f(19), 3*f(20), 3*f(21) &
    , 3*f(22), 3*f(23), 3*f(24), 3*f(25), 3*f(26), 3*f(27), 3*f(28), 3*f(29), 3*f(30), 3*f(31), 3*f(32), 3*f(33), 3*f(34), 3*f(35) &
    , 3*f(36), 3*f(37), 3*f(38), 4*f(39), 3*f(40), 3*f(41), 3*f(42), 3*f(43), 3*f(44), 3*f(45), 3*f(46), 3*f(47), 3*f(48), 3*f(49) &
    , 3*f(50), 3*f(51), 9*f(52), 9*f(53), 3*f(54), 3*f(55), 3*f(56), 3*f(57), 9*f(58), 9*f(59), 9*f(60), 9*f(61), 3*f(62), 3*f(63) &
    , 3*f(64), 3*f(65), 9*f(66), 9*f(67), 9*f(68), 9*f(69), 3*f(70), 9*f(71), 3*f(72), 9*f(72), 9*f(73), 3*f(74) ]
  c = (1._/**/REALKIND / 3) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2, POLSEL)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,5)
  integer,           intent(in)  :: H(5)
  integer,           intent(in), optional  :: POLSEL(5)
  complex(REALKIND), intent(out) :: M1(1), M2(2)
  complex(REALKIND) :: A(12)
  ! external WFs
  if (present(POLSEL)) then
    call pol_wf_Q(P(:,1), rZERO, H(1), wf(:,0), POLSEL(1))
    call pol_wf_A(P(:,2), rZERO, H(2), wf(:,-1), POLSEL(2))
    call pol_wf_Q(P(:,3), rZERO, H(3), wf(:,-2), POLSEL(3))
    call pol_wf_A(P(:,4), rZERO, H(4), wf(:,-3), POLSEL(4))
    call pol_wf_S(P(:,5), rMH, H(5), wf(:,-4), POLSEL(5))

  else
    call pol_wf_Q(P(:,1), rZERO, H(1), wf(:,0), 0)
    call pol_wf_A(P(:,2), rZERO, H(2), wf(:,-1), 0)
    call pol_wf_Q(P(:,3), rZERO, H(3), wf(:,-2), 0)
    call pol_wf_A(P(:,4), rZERO, H(4), wf(:,-3), 0)
    call pol_wf_S(P(:,5), rMH, H(5), wf(:,-4), 0)

  end if

  ! internal WFs
  call vert_QA_Z(gZn,wf(:,0),wf(:,-1),wf(:,1))
  call vert_QA_Z(gZu,wf(:,-2),wf(:,-3),wf(:,2))
  call vert_SV_V(wf(:,-4),wf(:,1),wf(:,3))
  call vert_QA_V(wf(:,-2),wf(:,-3),wf(:,4))
  call counter_SV_V(wf(:,-4),wf(:,1),wf(:,5))
  call counter_QA_Z(gZu,wf(:,-2),wf(:,-3),wf(:,6))
  call counter_QA_Z(EWctVuu,wf(:,-2),wf(:,-3),wf(:,7))
  call counter_QA_Z(EWctVnn,wf(:,0),wf(:,-1),wf(:,8))
  call vert_SV_V(wf(:,-4),wf(:,8),wf(:,9))
  call vert_TV_S(wf(:,-4),Q(:,16),wf(:,2),Q(:,12),wf(:,10))
  call counter_V_S(EWctXZ,wf(:,1),Q(:,3),wf(:,11))
  call vert_SV_V(wf(:,-4),wf(:,2),wf(:,12))
  call counter_V_V(EWctZZ,wf(:,1),Q(:,3),wf(:,13))
  call vert_TV_S(wf(:,-4),Q(:,16),wf(:,1),Q(:,3),wf(:,14))
  call counter_V_S(EWctXA,wf(:,4),Q(:,12),wf(:,15))
  call counter_V_S(EWctXZ,wf(:,2),Q(:,12),wf(:,16))
  call counter_V_V(EWctAZ,wf(:,4),Q(:,12),wf(:,17))
  call counter_V_V(EWctZZ,wf(:,2),Q(:,12),wf(:,18))
  call vert_ZQ_A(gZu,wf(:,1),wf(:,-2),wf(:,19))
  call prop_Q_A(wf(:,19),Q(:,7),ZERO,0_intkind1,wf(:,20))
  call vert_AZ_Q(gZu,wf(:,-3),wf(:,1),wf(:,21))
  call prop_A_Q(wf(:,21),Q(:,11),ZERO,0_intkind1,wf(:,22))
  call vert_ZQ_A(gZn,wf(:,2),wf(:,0),wf(:,23))
  call prop_Q_A(wf(:,23),Q(:,13),ZERO,0_intkind1,wf(:,24))
  call vert_AZ_Q(gZn,wf(:,-1),wf(:,2),wf(:,25))
  call prop_A_Q(wf(:,25),Q(:,14),ZERO,0_intkind1,wf(:,26))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,3) - MZ2)
  den(2) = 1 / (Q(5,12) - MZ2)
  den(4) = 1 / (Q(5,12))
  den(6) = 1 / (Q(5,28) - MZ2)
  den(9) = 1 / (Q(5,19) - MZ2)
  den(13) = 1 / (Q(5,7))
  den(15) = 1 / (Q(5,11))
  den(17) = 1 / (Q(5,13))
  den(19) = 1 / (Q(5,14))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(1)*den(4)
  den(7) = den(2)*den(6)
  den(8) = den(1)*den(7)
  den(10) = den(1)*den(9)
  den(11) = den(4)*den(10)
  den(12) = den(2)*den(10)
  den(14) = den(1)*den(13)
  den(16) = den(1)*den(15)
  den(18) = den(2)*den(17)
  den(20) = den(2)*den(19)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(12)

  A(1) = cont_VV(wf(:,2),wf(:,3)) * den(3)

  A(2) = cont_VV(wf(:,4),wf(:,5)) * den(5)
  A(3) = cont_VV(wf(:,2),wf(:,5)) * den(3)
  A(4) = cont_VV(wf(:,3),wf(:,6)) * den(3)
  A(5) = cont_VV(wf(:,3),wf(:,7)) * den(3)
  A(6) = cont_VV(wf(:,2),wf(:,9)) * den(3)
  A(7) = cont_SS(wf(:,10),wf(:,11)) * den(8)
  A(8) = cont_VV(wf(:,12),wf(:,13)) * den(8)
  A(9) = cont_SS(wf(:,14),wf(:,15)) * den(11)
  A(10) = cont_SS(wf(:,14),wf(:,16)) * den(12)
  A(11) = cont_VV(wf(:,3),wf(:,17)) * den(11)
  A(12) = cont_VV(wf(:,3),wf(:,18)) * den(12)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(12)
  complex(REALKIND), intent(out) :: M1(1), M2(2)

  M1(1) = A(1)*f(5)

  M2(1) = A(4)*f(8)
  M2(2) = -(A(2)*f(1))+A(3)*f(2)+A(9)*f(3)+(-A(7)-A(10))*f(4)+A(11)*f(6)+(A(5)+A(6)-A(8)-A(12))*f(7)

end subroutine colourvectors

end module ol_loop_pphll_ew_nenexuuxh_1_/**/REALKIND
