
module ol_colourmatrix_pphll_ew_nenexbbxh_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(17,1), K2(1,2), KL(1,2)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 3]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 3]

  K2(1,:) = [ 0, 3]

  KL(1,:) = [ 0, 3]


  end subroutine colourmatrix_init
end module ol_colourmatrix_pphll_ew_nenexbbxh_1_/**/REALKIND



module ol_forced_parameters_pphll_ew_nenexbbxh_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pphll_ew_nenexbbxh_1_/**/REALKIND

module ol_loop_pphll_ew_nenexbbxh_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(209), c(189)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-5+1:71)
  ! denominators
  complex(REALKIND), save :: den(48)
  ! Born, CT and Loop colour vector for each helicity configuration
  complex(REALKIND), save :: M0(1,16), Mct(2,16), Mcol_loop(2,16)
  ! zero helicity identifier
  logical,           save :: zerohel(16) = .true., zerohel_ct(16) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_decl_/**/DREALKIND, only: do_ew_renorm
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  call ensure_mp_loop_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = (CI*countertermnorm*eQED**5*EWctHZA)/3._/**/REALKIND
    f(  2) = CI*countertermnorm*eQED**5*EWctHZZ
    f(  3) = (CI*countertermnorm*eQED**5*MB)/MW
    f(  4) = (countertermnorm*eQED**5*MB)/(cw**2*sw**2*2._/**/REALKIND)
    f(  5) = (countertermnorm*eQED**5*MB**2)/(MW**2*sw**2*4._/**/REALKIND)
    f(  6) = (countertermnorm*eQED**5*MB*MH**2)/(MW**2*sw**2*4._/**/REALKIND)
    f(  7) = (CI*eQED**3*MB)/(4._/**/REALKIND*cw*MW*sw**2)
    f(  8) = (CI*countertermnorm*eQED**5*MB)/(4._/**/REALKIND*cw*MW*sw**2)
    f(  9) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(4._/**/REALKIND*cw*MW*sw**2)
    f( 10) = (countertermnorm*eQED**5)/(cw*sw*6._/**/REALKIND)
    f( 11) = (countertermnorm*eQED**5)/(cw*sw*2._/**/REALKIND)
    f( 12) = (CI*eQED**3*MB)/(2._/**/REALKIND*MW*sw)
    f( 13) = (CI*countertermnorm*eQED**5*MB)/(6._/**/REALKIND*MW*sw)
    f( 14) = (CI*countertermnorm*eQED**5*MB)/(2._/**/REALKIND*MW*sw)
    f( 15) = (countertermnorm*eQED**5*MB)/(cw*MW*sw*2._/**/REALKIND)
    f( 16) = (countertermnorm*eQED**5*EWctZXH*MB)/(MW*sw*2._/**/REALKIND)
    f( 17) = (CI*countertermnorm*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*MW*sw)
    f( 18) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*MW*sw)
    f( 19) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*MW*sw)
    f( 20) = (CI*eQED**3*MW)/(cw**2*sw)
    f( 21) = (CI*countertermnorm*eQED**5*MW)/(3._/**/REALKIND*cw**2*sw)
    f( 22) = (CI*countertermnorm*eQED**5*MW)/(cw**2*sw)
    f( 23) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MW)/(cw**2*sw)
    f( 24) = (eQED**5*integralnorm*MW*SwB)/(cw*6._/**/REALKIND)
    f( 25) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**3*4._/**/REALKIND)
    f( 26) = (eQED**5*integralnorm*MB*MW*SwB)/(cw*6._/**/REALKIND)
    f( 27) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw*6._/**/REALKIND)
    f( 28) = (eQED**5*integralnorm*MW**3*SwB)/(cw**3*3._/**/REALKIND)
    f( 29) = (eQED**5*integralnorm*MW**3*SwB)/(cw*3._/**/REALKIND)
    f( 30) = (eQED**5*integralnorm*SwB)/(MW*sw**5*8._/**/REALKIND)
    f( 31) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**5*16._/**/REALKIND)
    f( 32) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**5*8._/**/REALKIND)
    f( 33) = (eQED**5*integralnorm*MB**2*SwB)/(MW*sw**5*8._/**/REALKIND)
    f( 34) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW*sw**5*8._/**/REALKIND)
    f( 35) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**5*8._/**/REALKIND)
    f( 36) = (eQED**5*integralnorm*MW*SwB)/(sw**5*4._/**/REALKIND)
    f( 37) = (eQED**5*integralnorm*MB*MW*SwB)/(sw**5*4._/**/REALKIND)
    f( 38) = (eQED**5*integralnorm*MB**3*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f( 39) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f( 40) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f( 41) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f( 42) = (eQED**5*integralnorm*MB*MH**4*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f( 43) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**4*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f( 44) = (eQED**5*integralnorm*MT*SwB)/(cw*MW**3*sw**4*8._/**/REALKIND)
    f( 45) = (eQED**5*integralnorm*SwB)/(cw*MW*sw**4*8._/**/REALKIND)
    f( 46) = (cw*eQED**5*integralnorm*SwB)/(MW*sw**4*4._/**/REALKIND)
    f( 47) = (eQED**5*integralnorm*MB*SwB)/(cw**3*MW*sw**4*16._/**/REALKIND)
    f( 48) = (eQED**5*integralnorm*MB*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f( 49) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**4*16._/**/REALKIND)
    f( 50) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**4*8._/**/REALKIND)
    f( 51) = (cw*eQED**5*integralnorm*MB*SwB)/(MW*sw**4*8._/**/REALKIND)
    f( 52) = (cw*eQED**5*integralnorm*MB*SwB)/(MW*sw**4*4._/**/REALKIND)
    f( 53) = (eQED**5*integralnorm*MB**2*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f( 54) = (cw*eQED**5*integralnorm*MB**2*SwB)/(MW*sw**4*8._/**/REALKIND)
    f( 55) = (cw*eQED**5*integralnorm*MB**2*SwB)/(MW*sw**4*4._/**/REALKIND)
    f( 56) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f( 57) = (cw*eQED**5*integralnorm*MB*MH**2*SwB)/(MW*sw**4*8._/**/REALKIND)
    f( 58) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f( 59) = (3*cw*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW*sw**4*8._/**/REALKIND)
    f( 60) = (3*cw*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW*sw**4*4._/**/REALKIND)
    f( 61) = (eQED**5*integralnorm*MT*SwB)/(cw*MW*sw**4*8._/**/REALKIND)
    f( 62) = (cw*eQED**5*integralnorm*MT*SwB)/(MW*sw**4*4._/**/REALKIND)
    f( 63) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**4*2._/**/REALKIND)
    f( 64) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**4*2._/**/REALKIND)
    f( 65) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**5*sw**4*4._/**/REALKIND)
    f( 66) = (eQED**5*integralnorm*MB*MW*SwB)/(cw*sw**4*16._/**/REALKIND)
    f( 67) = (eQED**5*integralnorm*MB*MW*SwB)/(cw*sw**4*4._/**/REALKIND)
    f( 68) = (eQED**5*integralnorm*MB*MW*SwB)/(cw*sw**4*2._/**/REALKIND)
    f( 69) = (cw*eQED**5*integralnorm*MB*MW*SwB)/(sw**4*8._/**/REALKIND)
    f( 70) = (cw*eQED**5*integralnorm*MB*MW*SwB)/(sw**4*2._/**/REALKIND)
    f( 71) = (eQED**5*integralnorm*MB*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f( 72) = (eQED**5*integralnorm*MB**3*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f( 73) = (eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f( 74) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f( 75) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f( 76) = (eQED**5*integralnorm*MT*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f( 77) = (eQED**5*integralnorm*SwB)/(MW*sw**3*4._/**/REALKIND)
    f( 78) = (eQED**5*integralnorm*SwB)/(cw**2*MW*sw**3*2._/**/REALKIND)
    f( 79) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*12._/**/REALKIND)
    f( 80) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*4._/**/REALKIND)
    f( 81) = (eQED**5*integralnorm*MB*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f( 82) = (eQED**5*integralnorm*MB*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f( 83) = (cw**2*eQED**5*integralnorm*MB*SwB)/(MW*sw**3*2._/**/REALKIND)
    f( 84) = (eQED**5*integralnorm*MB**2*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f( 85) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f( 86) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f( 87) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f( 88) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*4._/**/REALKIND)
    f( 89) = (eQED**5*integralnorm*MW*SwB)/(sw**3*12._/**/REALKIND)
    f( 90) = (eQED**5*integralnorm*MW*SwB)/(sw**3*6._/**/REALKIND)
    f( 91) = (eQED**5*integralnorm*MW*SwB)/(sw**3*4._/**/REALKIND)
    f( 92) = (eQED**5*integralnorm*MW*SwB)/(sw**3*2._/**/REALKIND)
    f( 93) = (eQED**5*integralnorm*MW*SwB)/sw**3
    f( 94) = (eQED**5*integralnorm*MW*SwB)/(cw**4*sw**3*4._/**/REALKIND)
    f( 95) = (eQED**5*integralnorm*MW*SwB)/(cw**4*sw**3*2._/**/REALKIND)
    f( 96) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw**3*2._/**/REALKIND)
    f( 97) = (cw**2*eQED**5*integralnorm*MW*SwB)/(sw**3*2._/**/REALKIND)
    f( 98) = (cw**2*eQED**5*integralnorm*MW*SwB)/sw**3
    f( 99) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**4*sw**3*2._/**/REALKIND)
    f(100) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(cw**4*sw**3*2._/**/REALKIND)
    f(101) = (eQED**5*integralnorm*MW**3*SwB)/(cw**6*sw**3)
    f(102) = (eQED**5*integralnorm*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(103) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**2*36._/**/REALKIND)
    f(104) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(105) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(106) = (cw*eQED**5*integralnorm*MB*SwB)/(MW*sw**2*6._/**/REALKIND)
    f(107) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(108) = (eQED**5*integralnorm*MB**2*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(109) = (eQED**5*integralnorm*MH**2*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(110) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(111) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(112) = (eQED**5*integralnorm*MT*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(113) = (eQED**5*integralnorm*MW*SwB)/(cw**3*sw**2*2._/**/REALKIND)
    f(114) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*12._/**/REALKIND)
    f(115) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(116) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*3._/**/REALKIND)
    f(117) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*2._/**/REALKIND)
    f(118) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**2*6._/**/REALKIND)
    f(119) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**2*3._/**/REALKIND)
    f(120) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**3*sw**2*4._/**/REALKIND)
    f(121) = (eQED**5*integralnorm*MB*MW*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(122) = (eQED**5*integralnorm*MB*SwB)/(MW*sw*18._/**/REALKIND)
    f(123) = (eQED**5*integralnorm*MB*SwB)/(MW*sw*2._/**/REALKIND)
    f(124) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(MW*sw*2._/**/REALKIND)
    f(125) = (eQED**5*integralnorm*MW*SwB)/(sw*2._/**/REALKIND)
    f(126) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw*9._/**/REALKIND)
    f(127) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(128) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw)
    f(129) = (eQED**3*gQCD**2*integralnorm*MW*SwB)/(cw**2*sw)
    f(130) = (eQED**5*integralnorm*MW*sw*SwB)/(cw**2*2._/**/REALKIND)
    f(131) = (eQED**5*integralnorm*MB*MW*sw*SwB)/(cw**2*2._/**/REALKIND)
    f(132) = (eQED**5*integralnorm*MH**2*MW*sw*SwB)/(cw**2*2._/**/REALKIND)
    f(133) = (eQED**5*integralnorm*MW**3*sw*SwB)/cw**4
    f(134) = (eQED**5*integralnorm*MW**3*sw*SwB)/cw**2
    f(135) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*8._/**/REALKIND))
    f(136) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*8._/**/REALKIND))
    f(137) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND))
    f(138) = -((eQED**5*integralnorm*MB**2*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND))
    f(139) = -((eQED**5*integralnorm*MB*MH**4*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND))
    f(140) = (-3*eQED**5*integralnorm*lambdaHHH*MB*MH**4*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(141) = -((eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*8._/**/REALKIND))
    f(142) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**3*MW*sw**4*4._/**/REALKIND))
    f(143) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**4*8._/**/REALKIND))
    f(144) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**4*16._/**/REALKIND))
    f(145) = -((eQED**5*integralnorm*MB*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**3*MW*sw**4*16._/**/REALKIND*8._/**/REALKIND))
    f(146) = (eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*12._/**/REALKIND)
    f(147) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*12._/**/REALKIND)
    f(148) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*6._/**/REALKIND)
    f(149) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND))
    f(150) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**2*6._/**/REALKIND)
    f(151) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*12._/**/REALKIND)
    f(152) = (eQED**5*integralnorm*MB*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW*sw**3*4._/**/REALKIND*8._/**/REALKIND)
    f(153) = (eQED**5*integralnorm*MH**2*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW*sw**3*4._/**/REALKIND*8._/**/REALKIND)
    f(154) = (eQED**5*integralnorm*MH**2*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*MW*sw**3*2._/**/REALKIND*4._/**/REALKIND)
    f(155) = (eQED**5*integralnorm*MW*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**4*sw**3*2._/**/REALKIND*4._/**/REALKIND)
    f(156) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(157) = (eQED**5*integralnorm*MB**3*SwF)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(158) = (eQED**5*integralnorm*MB*ML**2*SwF)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(159) = (eQED**5*integralnorm*MB*MM**2*SwF)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(160) = (eQED**5*integralnorm*MB*MT**2*SwF)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(161) = (eQED**5*integralnorm*MB**3*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(162) = (eQED**5*integralnorm*MB**2*MH**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(163) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(164) = (eQED**5*integralnorm*MB**2*ML*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(165) = (eQED**5*integralnorm*MB*MH**2*ML*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(166) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*ML*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(167) = (eQED**5*integralnorm*MB*ML**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(168) = (eQED**5*integralnorm*MB**2*MM*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(169) = (eQED**5*integralnorm*MB*MH**2*MM*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(170) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MM*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(171) = (eQED**5*integralnorm*MB*MM**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(172) = (eQED**5*integralnorm*MB**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(173) = (eQED**5*integralnorm*MB*MH**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(174) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(175) = (eQED**5*integralnorm*MB*MT**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(176) = (eQED**5*integralnorm*MB**2*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(177) = (eQED**5*integralnorm*MB*ML*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(178) = (eQED**5*integralnorm*MB*MM*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(179) = (eQED**5*integralnorm*MB*MT*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(180) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*36._/**/REALKIND)
    f(181) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(182) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*2._/**/REALKIND)
    f(183) = (3*eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(184) = (eQED**5*integralnorm*ML*SwF)/(cw*MW*sw**2*12._/**/REALKIND)
    f(185) = (eQED**5*integralnorm*ML*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(186) = (eQED**5*integralnorm*MM*SwF)/(cw*MW*sw**2*12._/**/REALKIND)
    f(187) = (eQED**5*integralnorm*MM*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(188) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*18._/**/REALKIND)
    f(189) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(190) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*18._/**/REALKIND)
    f(191) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*9._/**/REALKIND)
    f(192) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*6._/**/REALKIND)
    f(193) = (2*eQED**5*integralnorm*MB*SwF)/(MW*sw*9._/**/REALKIND)
    f(194) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*2._/**/REALKIND)
    f(195) = (eQED**5*integralnorm*MB*SwF)/(MW*sw)
    f(196) = (3*eQED**5*integralnorm*MB*SwF)/(MW*sw*2._/**/REALKIND)
    f(197) = (eQED**5*integralnorm*ML*SwF)/(MW*sw*6._/**/REALKIND)
    f(198) = (eQED**5*integralnorm*ML*SwF)/(MW*sw*2._/**/REALKIND)
    f(199) = (eQED**5*integralnorm*MM*SwF)/(MW*sw*6._/**/REALKIND)
    f(200) = (eQED**5*integralnorm*MM*SwF)/(MW*sw*2._/**/REALKIND)
    f(201) = (eQED**5*integralnorm*MT*SwF)/(MW*sw*9._/**/REALKIND)
    f(202) = (eQED**5*integralnorm*MT*SwF)/(MW*sw*2._/**/REALKIND)
    f(203) = (eQED**5*integralnorm*MW*SwF)/(cw**2*sw*9._/**/REALKIND)
    f(204) = (2*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*9._/**/REALKIND)
    f(205) = (eQED**5*integralnorm*MW*SwF)/(cw**2*sw*3._/**/REALKIND)
    f(206) = (4*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*9._/**/REALKIND)
    f(207) = (eQED**5*integralnorm*MW*SwF)/(cw**2*sw)
    f(208) = (2*eQED**5*integralnorm*MW*SwF)/(cw**2*sw)
    f(209) = (3*eQED**5*integralnorm*MW*SwF)/(cw**2*sw)

  c = [ 3*f(24), 3*f(25), 3*f(26), 3*f(27), 3*f(28), 3*f(29), 3*f(30), 3*f(31), 3*f(32), 3*f(33), 3*f(34), 3*f(35), 3*f(36) &
    , 3*f(37), 3*f(38), 3*f(39), 3*f(40), 3*f(41), 3*f(42), 3*f(43), 3*f(44), 3*f(45), 3*f(46), 3*f(47), 3*f(48), 3*f(49), 3*f(50) &
    , 3*f(51), 3*f(52), 3*f(53), 3*f(54), 3*f(55), 3*f(56), 3*f(57), 3*f(58), 3*f(59), 3*f(60), 3*f(61), 3*f(62), 3*f(63), 3*f(64) &
    , 3*f(65), 3*f(66), 3*f(67), 3*f(68), 3*f(69), 3*f(70), 3*f(71), 3*f(72), 3*f(73), 3*f(74), 3*f(75), 3*f(76), 3*f(77), 3*f(78) &
    , 3*f(79), 3*f(80), 3*f(81), 3*f(82), 3*f(83), 3*f(84), 3*f(85), 3*f(86), 3*f(87), 3*f(88), 3*f(89), 3*f(90), 3*f(91), 3*f(92) &
    , 3*f(93), 3*f(94), 3*f(95), 3*f(96), 3*f(97), 3*f(98), 3*f(99), 3*f(100), 3*f(101), 3*f(102), 3*f(103), 3*f(104), 3*f(105) &
    , 3*f(106), 4*f(107), 3*f(108), 3*f(109), 3*f(110), 3*f(111), 3*f(112), 3*f(113), 3*f(114), 3*f(115), 3*f(116), 3*f(117) &
    , 3*f(118), 3*f(119), 3*f(120), 3*f(121), 3*f(122), 3*f(123), 4*f(124), 3*f(125), 3*f(126), 3*f(127), 3*f(128), 4*f(129) &
    , 3*f(130), 3*f(131), 3*f(132), 3*f(133), 3*f(134), 3*f(135), 3*f(136), 3*f(137), 3*f(138), 3*f(139), 3*f(140), 3*f(141) &
    , 3*f(142), 3*f(143), 3*f(144), 3*f(145), 3*f(146), 3*f(147), 3*f(148), 3*f(149), 3*f(150), 3*f(151), 3*f(152), 3*f(153) &
    , 3*f(154), 3*f(155), 3*f(156), 9*f(157), 3*f(158), 3*f(159), 9*f(160), 9*f(161), 9*f(162), 9*f(163), 3*f(164), 3*f(165) &
    , 3*f(166), 3*f(167), 3*f(168), 3*f(169), 3*f(170), 3*f(171), 9*f(172), 9*f(173), 9*f(174), 9*f(175), 9*f(176), 3*f(177) &
    , 3*f(178), 9*f(179), 9*f(180), 3*f(181), 9*f(181), 9*f(182), 3*f(183), 3*f(184), 3*f(185), 3*f(186), 3*f(187), 9*f(188) &
    , 9*f(189), 9*f(190), 9*f(191), 3*f(192), 9*f(193), 3*f(194), 9*f(194), 9*f(195), 3*f(196), 3*f(197), 3*f(198), 3*f(199) &
    , 3*f(200), 9*f(201), 9*f(202), 9*f(203), 9*f(204), 3*f(205), 9*f(206), 3*f(207), 9*f(207), 9*f(208), 3*f(209) ]
  c = (1._/**/REALKIND / 3) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2, POLSEL)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,5)
  integer,           intent(in)  :: H(5)
  integer,           intent(in), optional  :: POLSEL(5)
  complex(REALKIND), intent(out) :: M1(1), M2(2)
  complex(REALKIND) :: A(45)
  ! external WFs
  if (present(POLSEL)) then
    call pol_wf_Q(P(:,1), rZERO, H(1), wf(:,0), POLSEL(1))
    call pol_wf_A(P(:,2), rZERO, H(2), wf(:,-1), POLSEL(2))
    call pol_wf_Q(P(:,3), rMB, H(3), wf(:,-2), POLSEL(3))
    call pol_wf_A(P(:,4), rMB, H(4), wf(:,-3), POLSEL(4))
    call pol_wf_S(P(:,5), rMH, H(5), wf(:,-4), POLSEL(5))

  else
    call pol_wf_Q(P(:,1), rZERO, H(1), wf(:,0), 0)
    call pol_wf_A(P(:,2), rZERO, H(2), wf(:,-1), 0)
    call pol_wf_Q(P(:,3), rMB, H(3), wf(:,-2), 0)
    call pol_wf_A(P(:,4), rMB, H(4), wf(:,-3), 0)
    call pol_wf_S(P(:,5), rMH, H(5), wf(:,-4), 0)

  end if

  ! internal WFs
  call vert_QA_Z(gZn,wf(:,0),wf(:,-1),wf(:,1))
  call vert_AQ_S(gX,wf(:,-3),wf(:,-2),wf(:,2))
  call vert_TV_S(wf(:,-4),Q(:,16),wf(:,1),Q(:,3),wf(:,3))
  call vert_QA_Z(gZd,wf(:,-2),wf(:,-3),wf(:,4))
  call vert_SV_V(wf(:,-4),wf(:,1),wf(:,5))
  call vert_QS_A(gH,wf(:,-2),wf(:,-4),wf(:,6))
  call prop_Q_A(wf(:,6),Q(:,20),MB,1_intkind1,wf(:,7))
  call vert_AZ_Q(gZd,wf(:,-3),wf(:,1),wf(:,8))
  call vert_SA_Q(gH,wf(:,-4),wf(:,-3),wf(:,9))
  call prop_A_Q(wf(:,9),Q(:,24),MB,1_intkind1,wf(:,10))
  call vert_ZQ_A(gZd,wf(:,1),wf(:,-2),wf(:,11))
  call counter_TV_S(wf(:,-4),Q(:,16),wf(:,1),Q(:,3),wf(:,12))
  call vert_QA_V(wf(:,-2),wf(:,-3),wf(:,13))
  call counter_SV_V(wf(:,-4),wf(:,1),wf(:,14))
  call counter_AZ_Q(gZd,wf(:,-3),wf(:,1),wf(:,15))
  call counter_AZ_Q(EWctVbb,wf(:,-3),wf(:,1),wf(:,16))
  call counter_SA_Q(gH,wf(:,-4),wf(:,-3),wf(:,17))
  call prop_A_Q(wf(:,17),Q(:,24),MB,1_intkind1,wf(:,18))
  call counter_SA_Q(EWctHbb,wf(:,-4),wf(:,-3),wf(:,19))
  call prop_A_Q(wf(:,19),Q(:,24),MB,1_intkind1,wf(:,20))
  call counter_ZQ_A(gZd,wf(:,1),wf(:,-2),wf(:,21))
  call counter_ZQ_A(EWctVbb,wf(:,1),wf(:,-2),wf(:,22))
  call counter_QS_A(gH,wf(:,-2),wf(:,-4),wf(:,23))
  call prop_Q_A(wf(:,23),Q(:,20),MB,1_intkind1,wf(:,24))
  call counter_QS_A(EWctHbb,wf(:,-2),wf(:,-4),wf(:,25))
  call prop_Q_A(wf(:,25),Q(:,20),MB,1_intkind1,wf(:,26))
  call counter_AQ_S(gX,wf(:,-3),wf(:,-2),wf(:,27))
  call counter_AQ_S(EWctXbb,wf(:,-3),wf(:,-2),wf(:,28))
  call counter_QA_Z(gZd,wf(:,-2),wf(:,-3),wf(:,29))
  call counter_QA_Z(EWctVbb,wf(:,-2),wf(:,-3),wf(:,30))
  call counter_QA_Z(EWctVnn,wf(:,0),wf(:,-1),wf(:,31))
  call vert_TV_S(wf(:,-4),Q(:,16),wf(:,31),Q(:,3),wf(:,32))
  call vert_SV_V(wf(:,-4),wf(:,31),wf(:,33))
  call counter_QA_Z(EWctAnn,wf(:,0),wf(:,-1),wf(:,34))
  call vert_AV_Q(wf(:,-3),wf(:,34),wf(:,35))
  call vert_AZ_Q(gZd,wf(:,-3),wf(:,31),wf(:,36))
  call vert_VQ_A(wf(:,34),wf(:,-2),wf(:,37))
  call vert_ZQ_A(gZd,wf(:,31),wf(:,-2),wf(:,38))
  call vert_SS_S(wf(:,2),wf(:,-4),wf(:,39))
  call counter_V_S(EWctXZ,wf(:,1),Q(:,3),wf(:,40))
  call vert_TV_S(wf(:,-4),Q(:,16),wf(:,4),Q(:,12),wf(:,41))
  call vert_ST_V(wf(:,2),Q(:,12),wf(:,-4),Q(:,16),wf(:,42))
  call counter_V_V(EWctZZ,wf(:,1),Q(:,3),wf(:,43))
  call vert_SV_V(wf(:,-4),wf(:,4),wf(:,44))
  call counter_S_S(EWctXX,wf(:,2),Q(:,12),wf(:,45))
  call counter_S_V(EWctXZ,wf(:,2),Q(:,12),wf(:,46))
  call counter_V_S(EWctXA,wf(:,13),Q(:,12),wf(:,47))
  call counter_V_S(EWctXZ,wf(:,4),Q(:,12),wf(:,48))
  call counter_V_V(EWctAZ,wf(:,13),Q(:,12),wf(:,49))
  call counter_V_V(EWctZZ,wf(:,4),Q(:,12),wf(:,50))
  call vert_AQ_S(gX,wf(:,-3),wf(:,7),wf(:,51))
  call vert_QA_V(wf(:,7),wf(:,-3),wf(:,52))
  call counter_V_V(EWctAZ,wf(:,1),Q(:,3),wf(:,53))
  call vert_QA_Z(gZd,wf(:,7),wf(:,-3),wf(:,54))
  call counter_Q_A(ctbb,5,wf(:,7),Q(:,20),wf(:,55))
  call prop_A_Q(wf(:,8),Q(:,11),MB,1_intkind1,wf(:,56))
  call counter_Q_A_LR(EWctbb,wf(:,7),Q(:,20),wf(:,57))
  call vert_AQ_S(gX,wf(:,10),wf(:,-2),wf(:,58))
  call vert_QA_V(wf(:,-2),wf(:,10),wf(:,59))
  call vert_QA_Z(gZd,wf(:,-2),wf(:,10),wf(:,60))
  call counter_A_Q(ctbb,5,wf(:,10),Q(:,24),wf(:,61))
  call prop_Q_A(wf(:,11),Q(:,7),MB,1_intkind1,wf(:,62))
  call counter_A_Q_LR(EWctbb,wf(:,10),Q(:,24),wf(:,63))
  call vert_AQ_S(gH,wf(:,-3),wf(:,-2),wf(:,64))
  call vert_ZQ_A(gZn,wf(:,4),wf(:,0),wf(:,65))
  call prop_Q_A(wf(:,65),Q(:,13),ZERO,0_intkind1,wf(:,66))
  call vert_AZ_Q(gZn,wf(:,-1),wf(:,4),wf(:,67))
  call prop_A_Q(wf(:,67),Q(:,14),ZERO,0_intkind1,wf(:,68))
  call vert_SS_S(wf(:,64),wf(:,-4),wf(:,69))
  call vert_AQ_S(gH,wf(:,-3),wf(:,7),wf(:,70))
  call vert_AQ_S(gH,wf(:,10),wf(:,-2),wf(:,71))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,3) - MZ2)
  den(2) = 1 / (Q(5,12) - MZ2)
  den(4) = 1 / (Q(5,20) - MB2)
  den(6) = 1 / (Q(5,24) - MB2)
  den(8) = 1 / (Q(5,12))
  den(10) = 1 / (Q(5,3))
  den(13) = 1 / (Q(5,28) - MZ2)
  den(16) = 1 / (Q(5,19) - MZ2)
  den(22) = 1 / (Q(5,28))
  den(25) = 1 / (Q(5,11) - MB2)
  den(32) = 1 / (Q(5,7) - MB2)
  den(35) = 1 / (Q(5,12) - MH2)
  den(36) = 1 / (Q(5,13))
  den(38) = 1 / (Q(5,14))
  den(40) = 1 / (Q(5,28) - MH2)

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(1)*den(4)
  den(7) = den(1)*den(6)
  den(9) = den(1)*den(8)
  den(11) = den(4)*den(10)
  den(12) = den(6)*den(10)
  den(14) = den(2)*den(13)
  den(15) = den(1)*den(14)
  den(17) = den(1)*den(16)
  den(18) = den(2)*den(17)
  den(19) = den(8)*den(17)
  den(20) = den(4)*den(13)
  den(21) = den(1)*den(20)
  den(23) = den(4)*den(22)
  den(24) = den(1)*den(23)
  den(26) = den(1)*den(25)
  den(27) = den(4)*den(26)
  den(28) = den(6)*den(13)
  den(29) = den(1)*den(28)
  den(30) = den(6)*den(22)
  den(31) = den(1)*den(30)
  den(33) = den(1)*den(32)
  den(34) = den(6)*den(33)
  den(37) = den(2)*den(36)
  den(39) = den(2)*den(38)
  den(41) = den(35)*den(40)
  den(42) = den(4)*den(40)
  den(43) = den(6)*den(40)
  den(44) = den(1)*den(35)
  den(45) = den(17)*den(35)
  den(46) = den(1)*den(41)
  den(47) = den(1)*den(42)
  den(48) = den(1)*den(43)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(45)

  A(1) = cont_SS(wf(:,2),wf(:,3)) * den(3)
  A(2) = cont_VV(wf(:,4),wf(:,5)) * den(3)
  A(3) = cont_QA(wf(:,7),wf(:,8)) * den(5)
  A(4) = cont_QA(wf(:,10),wf(:,11)) * den(7)

  A(5) = cont_SS(wf(:,2),wf(:,12)) * den(3)
  A(6) = cont_VV(wf(:,13),wf(:,14)) * den(9)
  A(7) = cont_VV(wf(:,4),wf(:,14)) * den(3)
  A(8) = cont_QA(wf(:,7),wf(:,15)) * den(5)
  A(9) = cont_QA(wf(:,7),wf(:,16)) * den(5)
  A(10) = cont_QA(wf(:,11),wf(:,18)) * den(7)
  A(11) = cont_QA(wf(:,11),wf(:,20)) * den(7)
  A(12) = cont_QA(wf(:,10),wf(:,21)) * den(7)
  A(13) = cont_QA(wf(:,10),wf(:,22)) * den(7)
  A(14) = cont_QA(wf(:,8),wf(:,24)) * den(5)
  A(15) = cont_QA(wf(:,8),wf(:,26)) * den(5)
  A(16) = cont_SS(wf(:,3),wf(:,27)) * den(3)
  A(17) = cont_SS(wf(:,3),wf(:,28)) * den(3)
  A(18) = cont_VV(wf(:,5),wf(:,29)) * den(3)
  A(19) = cont_VV(wf(:,5),wf(:,30)) * den(3)
  A(20) = cont_SS(wf(:,2),wf(:,32)) * den(3)
  A(21) = cont_VV(wf(:,4),wf(:,33)) * den(3)
  A(22) = cont_QA(wf(:,7),wf(:,35)) * den(11)
  A(23) = cont_QA(wf(:,7),wf(:,36)) * den(5)
  A(24) = cont_QA(wf(:,10),wf(:,37)) * den(12)
  A(25) = cont_QA(wf(:,10),wf(:,38)) * den(7)
  A(26) = cont_SS(wf(:,39),wf(:,40)) * den(15)
  A(27) = cont_SS(wf(:,40),wf(:,41)) * den(15)
  A(28) = cont_VV(wf(:,42),wf(:,43)) * den(15)
  A(29) = cont_VV(wf(:,43),wf(:,44)) * den(15)
  A(30) = cont_SS(wf(:,3),wf(:,45)) * den(18)
  A(31) = cont_VV(wf(:,5),wf(:,46)) * den(18)
  A(32) = cont_SS(wf(:,3),wf(:,47)) * den(19)
  A(33) = cont_SS(wf(:,3),wf(:,48)) * den(18)
  A(34) = cont_VV(wf(:,5),wf(:,49)) * den(19)
  A(35) = cont_VV(wf(:,5),wf(:,50)) * den(18)
  A(36) = cont_SS(wf(:,40),wf(:,51)) * den(21)
  A(37) = cont_VV(wf(:,52),wf(:,53)) * den(24)
  A(38) = cont_VV(wf(:,43),wf(:,54)) * den(21)
  A(39) = cont_QA(wf(:,55),wf(:,56)) * den(27)
  A(40) = cont_QA(wf(:,56),wf(:,57)) * den(27)
  A(41) = cont_SS(wf(:,40),wf(:,58)) * den(29)
  A(42) = cont_VV(wf(:,53),wf(:,59)) * den(31)
  A(43) = cont_VV(wf(:,43),wf(:,60)) * den(29)
  A(44) = cont_QA(wf(:,61),wf(:,62)) * den(34)
  A(45) = cont_QA(wf(:,62),wf(:,63)) * den(34)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(45)
  complex(REALKIND), intent(out) :: M1(1), M2(2)

  M1(1) = -(A(1)*f(7))+(A(3)+A(4))*f(12)+A(2)*f(20)

  M2(1) = -(A(16)*f(9))+(-A(39)-A(44))*f(17)+(A(10)+A(14))*f(18)+(A(8)+A(12))*f(19)+A(18)*f(23)
  M2(2) = A(6)*f(1)+A(7)*f(2)+(-A(11)-A(15))*f(3)+A(31)*f(4)+(A(36)+A(41))*f(5)+A(26)*f(6)+(-A(20)+A(28)+A(30))*f(8)-A(32)*f(10)+( &
       -A(27)-A(33))*f(11)+(A(22)+A(24)-A(37)-A(42))*f(13)+(A(9)+A(13)+A(23)+A(25)-A(38)-A(40)-A(43)-A(45))*f(14)-A(17)*f(15) &
       +A(5)*f(16)-A(34)*f(21)+(A(19)+A(21)-A(29)-A(35))*f(22)

end subroutine colourvectors

end module ol_loop_pphll_ew_nenexbbxh_1_/**/REALKIND
