
module ol_colourmatrix_pphll_ew_neexuxdh_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(17,1), K2(1,2), KL(1,2)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 3]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 3]

  K2(1,:) = [ 0, 3]

  KL(1,:) = [ 0, 3]


  end subroutine colourmatrix_init
end module ol_colourmatrix_pphll_ew_neexuxdh_1_/**/REALKIND



module ol_forced_parameters_pphll_ew_neexuxdh_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pphll_ew_neexuxdh_1_/**/REALKIND

module ol_loop_pphll_ew_neexuxdh_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(45), c(38)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-5+1:23)
  ! denominators
  complex(REALKIND), save :: den(17)
  ! Born, CT and Loop colour vector for each helicity configuration
  complex(REALKIND), save :: M0(1,16), Mct(2,16), Mcol_loop(2,16)
  ! zero helicity identifier
  logical,           save :: zerohel(16) = .true., zerohel_ct(16) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_decl_/**/DREALKIND, only: do_ew_renorm
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  call ensure_mp_loop_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*countertermnorm*eQED**5)/(4._/**/REALKIND*sw**3)
    f( 2) = (CI*countertermnorm*ctSqq*eQED**3*gQCD**2)/(4._/**/REALKIND*MW*sw**3)
    f( 3) = (CI*eQED**3*MW)/(2._/**/REALKIND*sw**3)
    f( 4) = (CI*countertermnorm*eQED**5*MW)/(2._/**/REALKIND*sw**3)
    f( 5) = (CI*countertermnorm*eQED**5*EWctVne*MW)/(2._/**/REALKIND*sw**3)
    f( 6) = (CI*countertermnorm*eQED**5*EWctVud*MW)/(2._/**/REALKIND*sw**3)
    f( 7) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2*MW)/(2._/**/REALKIND*sw**3)
    f( 8) = (CI*countertermnorm*eQED**5*EWctHWW)/(2._/**/REALKIND*sw**2)
    f( 9) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw**5*16._/**/REALKIND)
    f(10) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw**5*8._/**/REALKIND)
    f(11) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(MW*sw**5*16._/**/REALKIND)
    f(12) = (eQED**5*integralnorm*MW*SwB)/(sw**5*8._/**/REALKIND)
    f(13) = (eQED**5*integralnorm*MW*SwB)/(sw**5*4._/**/REALKIND)
    f(14) = (eQED**5*integralnorm*MW*SwB)/(sw**5*2._/**/REALKIND)
    f(15) = (cw**2*eQED**5*integralnorm*MW*SwB)/(sw**5*4._/**/REALKIND)
    f(16) = (cw**2*eQED**5*integralnorm*MW*SwB)/(sw**5*2._/**/REALKIND)
    f(17) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(sw**5*4._/**/REALKIND)
    f(18) = (eQED**5*integralnorm*MW**3*SwB)/(sw**5*2._/**/REALKIND)
    f(19) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**4*2._/**/REALKIND)
    f(20) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**4*2._/**/REALKIND)
    f(21) = (eQED**5*integralnorm*MW*SwB)/(sw**3*12._/**/REALKIND)
    f(22) = (eQED**5*integralnorm*MW*SwB)/(sw**3*9._/**/REALKIND)
    f(23) = (eQED**5*integralnorm*MW*SwB)/(sw**3*6._/**/REALKIND)
    f(24) = (eQED**5*integralnorm*MW*SwB)/(sw**3*4._/**/REALKIND)
    f(25) = (eQED**5*integralnorm*MW*SwB)/(sw**3*3._/**/REALKIND)
    f(26) = (eQED**5*integralnorm*MW*SwB)/(sw**3*2._/**/REALKIND)
    f(27) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw**3*8._/**/REALKIND)
    f(28) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw**3*2._/**/REALKIND)
    f(29) = (eQED**3*gQCD**2*integralnorm*MW*SwB)/(sw**3*2._/**/REALKIND)
    f(30) = (eQED**5*integralnorm*MH**2*MW*SwB)/(sw**3*4._/**/REALKIND)
    f(31) = (eQED**5*integralnorm*MW**3*SwB)/(sw**3*2._/**/REALKIND)
    f(32) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(33) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(34) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(35) = (eQED**5*integralnorm*MW**3*SwB)/(cw**4*sw*2._/**/REALKIND)
    f(36) = (eQED**5*integralnorm*MW**3*SwB)/(cw**2*sw*2._/**/REALKIND)
    f(37) = -((eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(sw**5*8._/**/REALKIND))
    f(38) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw**3*8._/**/REALKIND)
    f(39) = (eQED**5*integralnorm*SwF)/(MW*sw**5*8._/**/REALKIND)
    f(40) = (eQED**5*integralnorm*MB*SwF)/(MW*sw**5*8._/**/REALKIND)
    f(41) = (eQED**5*integralnorm*ML*SwF)/(MW*sw**5*8._/**/REALKIND)
    f(42) = (eQED**5*integralnorm*MM*SwF)/(MW*sw**5*8._/**/REALKIND)
    f(43) = (eQED**5*integralnorm*MT*SwF)/(MW*sw**5*8._/**/REALKIND)
    f(44) = (eQED**5*integralnorm*MW*SwF)/(sw**5*4._/**/REALKIND)
    f(45) = (eQED**5*integralnorm*MW*SwF)/(sw**5*2._/**/REALKIND)

  c = [ 3*f(9), 3*f(10), 3*f(11), 3*f(12), 3*f(13), 3*f(14), 3*f(15), 3*f(16), 3*f(17), 3*f(18), 3*f(19), 3*f(20), 3*f(21) &
    , 3*f(22), 3*f(23), 3*f(24), 3*f(25), 3*f(26), 3*f(27), 3*f(28), 4*f(29), 3*f(30), 3*f(31), 3*f(32), 3*f(33), 3*f(34), 3*f(35) &
    , 3*f(36), 3*f(37), 3*f(38), 9*f(39), 9*f(40), 3*f(41), 3*f(42), 9*f(43), 3*f(44), 9*f(44), 9*f(45) ]
  c = (1._/**/REALKIND / 3) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2, POLSEL)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,5)
  integer,           intent(in)  :: H(5)
  integer,           intent(in), optional  :: POLSEL(5)
  complex(REALKIND), intent(out) :: M1(1), M2(2)
  complex(REALKIND) :: A(10)
  ! external WFs
  if (present(POLSEL)) then
    call pol_wf_Q(P(:,1), rZERO, H(1), wf(:,0), POLSEL(1))
    call pol_wf_A(P(:,2), rZERO, H(2), wf(:,-1), POLSEL(2))
    call pol_wf_A(P(:,3), rZERO, H(3), wf(:,-2), POLSEL(3))
    call pol_wf_Q(P(:,4), rZERO, H(4), wf(:,-3), POLSEL(4))
    call pol_wf_S(P(:,5), rMH, H(5), wf(:,-4), POLSEL(5))

  else
    call pol_wf_Q(P(:,1), rZERO, H(1), wf(:,0), 0)
    call pol_wf_A(P(:,2), rZERO, H(2), wf(:,-1), 0)
    call pol_wf_A(P(:,3), rZERO, H(3), wf(:,-2), 0)
    call pol_wf_Q(P(:,4), rZERO, H(4), wf(:,-3), 0)
    call pol_wf_S(P(:,5), rMH, H(5), wf(:,-4), 0)

  end if

  ! internal WFs
  call vert_QA_W(wf(:,0),wf(:,-1),wf(:,1))
  call vert_QA_W(wf(:,-3),wf(:,-2),wf(:,2))
  call vert_SV_V(wf(:,-4),wf(:,1),wf(:,3))
  call counter_SV_V(wf(:,-4),wf(:,1),wf(:,4))
  call counter_AQ_S(gPud,wf(:,-2),wf(:,-3),wf(:,5))
  call vert_TV_S(wf(:,-4),Q(:,16),wf(:,1),Q(:,3),wf(:,6))
  call counter_QA_W(wf(:,-3),wf(:,-2),wf(:,7))
  call counter_QA_W(wf(:,0),wf(:,-1),wf(:,8))
  call vert_SV_V(wf(:,-4),wf(:,8),wf(:,9))
  call vert_TV_S(wf(:,-4),Q(:,16),wf(:,2),Q(:,12),wf(:,10))
  call counter_V_S(EWctPW,wf(:,1),Q(:,3),wf(:,11))
  call vert_SV_V(wf(:,-4),wf(:,2),wf(:,12))
  call counter_V_V(EWctWW,wf(:,1),Q(:,3),wf(:,13))
  call counter_V_S(EWctPW,wf(:,2),Q(:,12),wf(:,14))
  call counter_V_V(EWctWW,wf(:,2),Q(:,12),wf(:,15))
  call vert_AW_Q(wf(:,-2),wf(:,1),wf(:,16))
  call prop_A_Q(wf(:,16),Q(:,7),ZERO,0_intkind1,wf(:,17))
  call vert_WQ_A(wf(:,1),wf(:,-3),wf(:,18))
  call prop_Q_A(wf(:,18),Q(:,11),ZERO,0_intkind1,wf(:,19))
  call vert_WQ_A(wf(:,2),wf(:,0),wf(:,20))
  call prop_Q_A(wf(:,20),Q(:,13),ZERO,0_intkind1,wf(:,21))
  call vert_AW_Q(wf(:,-1),wf(:,2),wf(:,22))
  call prop_A_Q(wf(:,22),Q(:,14),ZERO,0_intkind1,wf(:,23))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,3) - MW2)
  den(2) = 1 / (Q(5,12) - MW2)
  den(4) = 1 / (Q(5,28) - MW2)
  den(7) = 1 / (Q(5,19) - MW2)
  den(10) = 1 / (Q(5,7))
  den(12) = 1 / (Q(5,11))
  den(14) = 1 / (Q(5,13))
  den(16) = 1 / (Q(5,14))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(2)*den(4)
  den(6) = den(1)*den(5)
  den(8) = den(1)*den(7)
  den(9) = den(2)*den(8)
  den(11) = den(1)*den(10)
  den(13) = den(1)*den(12)
  den(15) = den(2)*den(14)
  den(17) = den(2)*den(16)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(10)

  A(1) = cont_VV(wf(:,2),wf(:,3)) * den(3)

  A(2) = cont_VV(wf(:,2),wf(:,4)) * den(3)
  A(3) = cont_SS(wf(:,5),wf(:,6)) * den(3)
  A(4) = cont_VV(wf(:,3),wf(:,7)) * den(3)
  A(5) = cont_VV(wf(:,3),wf(:,7)) * den(3)
  A(6) = cont_VV(wf(:,2),wf(:,9)) * den(3)
  A(7) = cont_SS(wf(:,10),wf(:,11)) * den(6)
  A(8) = cont_VV(wf(:,12),wf(:,13)) * den(6)
  A(9) = cont_SS(wf(:,6),wf(:,14)) * den(9)
  A(10) = cont_VV(wf(:,3),wf(:,15)) * den(9)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(10)
  complex(REALKIND), intent(out) :: M1(1), M2(2)

  M1(1) = -(A(1)*f(3))

  M2(1) = -(A(3)*f(2))-A(4)*f(7)
  M2(2) = (A(7)-A(9))*f(1)+(A(8)+A(10))*f(4)-A(6)*f(5)-A(5)*f(6)-A(2)*f(8)

end subroutine colourvectors

end module ol_loop_pphll_ew_neexuxdh_1_/**/REALKIND
