
module ol_colourmatrix_pphll_ew_eexbbxh_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(17,1), K2(1,2), KL(1,2)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 3]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 0]
  K1(13,:) = [ 0]
  K1(14,:) = [ 0]
  K1(15,:) = [ 0]
  K1(16,:) = [ 0]
  K1(17,:) = [ 3]

  K2(1,:) = [ 0, 3]

  KL(1,:) = [ 0, 3]


  end subroutine colourmatrix_init
end module ol_colourmatrix_pphll_ew_eexbbxh_1_/**/REALKIND



module ol_forced_parameters_pphll_ew_eexbbxh_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMH /= 0) write(*,101) 'wMH = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pphll_ew_eexbbxh_1_/**/REALKIND

module ol_loop_pphll_ew_eexbbxh_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(294), c(268)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-5+1:89)
  ! denominators
  complex(REALKIND), save :: den(65)
  ! Born, CT and Loop colour vector for each helicity configuration
  complex(REALKIND), save :: M0(1,16), Mct(2,16), Mcol_loop(2,16)
  ! zero helicity identifier
  logical,           save :: zerohel(16) = .true., zerohel_ct(16) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_decl_/**/DREALKIND, only: do_ew_renorm
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  call ensure_mp_loop_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(  1) = (CI*countertermnorm*eQED**5*EWctHAA)/3._/**/REALKIND
    f(  2) = (CI*countertermnorm*eQED**5*EWctHZA)/3._/**/REALKIND
    f(  3) = CI*countertermnorm*eQED**5*EWctHZA
    f(  4) = CI*countertermnorm*eQED**5*EWctHZZ
    f(  5) = (CI*countertermnorm*eQED**5*MB)/(3._/**/REALKIND*MW)
    f(  6) = (CI*countertermnorm*eQED**5*MB)/MW
    f(  7) = (countertermnorm*eQED**5*MB)/(cw**2*sw**2*2._/**/REALKIND)
    f(  8) = (countertermnorm*eQED**5*MB**2)/(MW**2*sw**2*4._/**/REALKIND)
    f(  9) = (countertermnorm*eQED**5*MB*MH**2)/(MW**2*sw**2*4._/**/REALKIND)
    f( 10) = (CI*eQED**3*MB)/(4._/**/REALKIND*cw*MW*sw**2)
    f( 11) = (CI*countertermnorm*eQED**5*MB)/(4._/**/REALKIND*cw*MW*sw**2)
    f( 12) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(4._/**/REALKIND*cw*MW*sw**2)
    f( 13) = (countertermnorm*eQED**5)/(cw*sw*6._/**/REALKIND)
    f( 14) = (countertermnorm*eQED**5)/(cw*sw*2._/**/REALKIND)
    f( 15) = (CI*eQED**3*MB)/(6._/**/REALKIND*MW*sw)
    f( 16) = (CI*eQED**3*MB)/(2._/**/REALKIND*MW*sw)
    f( 17) = (CI*countertermnorm*eQED**5*MB)/(6._/**/REALKIND*MW*sw)
    f( 18) = (CI*countertermnorm*eQED**5*MB)/(2._/**/REALKIND*MW*sw)
    f( 19) = (countertermnorm*eQED**5*MB)/(cw*MW*sw*2._/**/REALKIND)
    f( 20) = (countertermnorm*eQED**5*EWctAXH*MB)/(MW*sw*2._/**/REALKIND)
    f( 21) = (countertermnorm*eQED**5*EWctZXH*MB)/(MW*sw*2._/**/REALKIND)
    f( 22) = (CI*countertermnorm*eQED**3*gQCD**2*MB)/(6._/**/REALKIND*MW*sw)
    f( 23) = (CI*countertermnorm*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*MW*sw)
    f( 24) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(6._/**/REALKIND*MW*sw)
    f( 25) = (CI*countertermnorm*ctSbb*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*MW*sw)
    f( 26) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MB)/(6._/**/REALKIND*MW*sw)
    f( 27) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MB)/(2._/**/REALKIND*MW*sw)
    f( 28) = (CI*eQED**3*MW)/(cw**2*sw)
    f( 29) = (CI*countertermnorm*eQED**5*MW)/(3._/**/REALKIND*cw**2*sw)
    f( 30) = (CI*countertermnorm*eQED**5*MW)/(cw**2*sw)
    f( 31) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2*MW)/(cw**2*sw)
    f( 32) = (eQED**5*integralnorm*MW*SwB)/(cw*6._/**/REALKIND)
    f( 33) = (eQED**5*integralnorm*MW*SwB)/(cw*2._/**/REALKIND)
    f( 34) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**3*4._/**/REALKIND)
    f( 35) = (eQED**5*integralnorm*MB*MW*SwB)/(cw*6._/**/REALKIND)
    f( 36) = (eQED**5*integralnorm*MB*MW*SwB)/(cw*2._/**/REALKIND)
    f( 37) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw*6._/**/REALKIND)
    f( 38) = (eQED**5*integralnorm*MH**2*MW*SwB)/(cw*2._/**/REALKIND)
    f( 39) = (eQED**5*integralnorm*MW**3*SwB)/(cw**3*3._/**/REALKIND)
    f( 40) = (eQED**5*integralnorm*MW**3*SwB)/cw**3
    f( 41) = (eQED**5*integralnorm*MW**3*SwB)/(cw*3._/**/REALKIND)
    f( 42) = (eQED**5*integralnorm*MW**3*SwB)/cw
    f( 43) = (eQED**5*integralnorm*SwB)/(MW*sw**5*8._/**/REALKIND)
    f( 44) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**5*16._/**/REALKIND)
    f( 45) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**5*8._/**/REALKIND)
    f( 46) = (eQED**5*integralnorm*MB**2*SwB)/(MW*sw**5*8._/**/REALKIND)
    f( 47) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW*sw**5*8._/**/REALKIND)
    f( 48) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**5*8._/**/REALKIND)
    f( 49) = (eQED**5*integralnorm*MW*SwB)/(sw**5*4._/**/REALKIND)
    f( 50) = (eQED**5*integralnorm*MB*MW*SwB)/(sw**5*4._/**/REALKIND)
    f( 51) = (eQED**5*integralnorm*MB**3*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f( 52) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f( 53) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f( 54) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f( 55) = (eQED**5*integralnorm*MB*MH**4*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f( 56) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**4*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f( 57) = (eQED**5*integralnorm*MT*SwB)/(cw*MW**3*sw**4*8._/**/REALKIND)
    f( 58) = (eQED**5*integralnorm*SwB)/(cw*MW*sw**4*8._/**/REALKIND)
    f( 59) = (cw*eQED**5*integralnorm*SwB)/(MW*sw**4*4._/**/REALKIND)
    f( 60) = (eQED**5*integralnorm*MB*SwB)/(cw**3*MW*sw**4*16._/**/REALKIND)
    f( 61) = (eQED**5*integralnorm*MB*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f( 62) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**4*16._/**/REALKIND)
    f( 63) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**4*8._/**/REALKIND)
    f( 64) = (cw*eQED**5*integralnorm*MB*SwB)/(MW*sw**4*8._/**/REALKIND)
    f( 65) = (cw*eQED**5*integralnorm*MB*SwB)/(MW*sw**4*4._/**/REALKIND)
    f( 66) = (eQED**5*integralnorm*MB**2*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f( 67) = (cw*eQED**5*integralnorm*MB**2*SwB)/(MW*sw**4*8._/**/REALKIND)
    f( 68) = (cw*eQED**5*integralnorm*MB**2*SwB)/(MW*sw**4*4._/**/REALKIND)
    f( 69) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f( 70) = (cw*eQED**5*integralnorm*MB*MH**2*SwB)/(MW*sw**4*8._/**/REALKIND)
    f( 71) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND)
    f( 72) = (3*cw*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW*sw**4*8._/**/REALKIND)
    f( 73) = (3*cw*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW*sw**4*4._/**/REALKIND)
    f( 74) = (eQED**5*integralnorm*MT*SwB)/(cw*MW*sw**4*8._/**/REALKIND)
    f( 75) = (cw*eQED**5*integralnorm*MT*SwB)/(MW*sw**4*4._/**/REALKIND)
    f( 76) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**4*2._/**/REALKIND)
    f( 77) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**4*2._/**/REALKIND)
    f( 78) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**5*sw**4*4._/**/REALKIND)
    f( 79) = (eQED**5*integralnorm*MB*MW*SwB)/(cw*sw**4*16._/**/REALKIND)
    f( 80) = (eQED**5*integralnorm*MB*MW*SwB)/(cw*sw**4*4._/**/REALKIND)
    f( 81) = (eQED**5*integralnorm*MB*MW*SwB)/(cw*sw**4*2._/**/REALKIND)
    f( 82) = (cw*eQED**5*integralnorm*MB*MW*SwB)/(sw**4*8._/**/REALKIND)
    f( 83) = (cw*eQED**5*integralnorm*MB*MW*SwB)/(sw**4*2._/**/REALKIND)
    f( 84) = (eQED**5*integralnorm*MB*SwB)/(MW**3*sw**3*12._/**/REALKIND)
    f( 85) = (eQED**5*integralnorm*MB*SwB)/(MW**3*sw**3*6._/**/REALKIND)
    f( 86) = (eQED**5*integralnorm*MB*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f( 87) = (eQED**5*integralnorm*MB**3*SwB)/(MW**3*sw**3*24._/**/REALKIND)
    f( 88) = (eQED**5*integralnorm*MB**3*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f( 89) = (eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**3*12._/**/REALKIND)
    f( 90) = (eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**3*6._/**/REALKIND)
    f( 91) = (eQED**5*integralnorm*MH**2*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f( 92) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f( 93) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(MW**3*sw**3*24._/**/REALKIND)
    f( 94) = (eQED**5*integralnorm*MB**2*MH**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f( 95) = (eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f( 96) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f( 97) = (eQED**5*integralnorm*MB*MH**4*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f( 98) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**4*SwB)/(MW**3*sw**3*8._/**/REALKIND)
    f( 99) = (eQED**5*integralnorm*MT*SwB)/(MW**3*sw**3*12._/**/REALKIND)
    f(100) = (eQED**5*integralnorm*MT*SwB)/(MW**3*sw**3*6._/**/REALKIND)
    f(101) = (eQED**5*integralnorm*MT*SwB)/(MW**3*sw**3*4._/**/REALKIND)
    f(102) = (eQED**5*integralnorm*SwB)/(MW*sw**3*12._/**/REALKIND)
    f(103) = (eQED**5*integralnorm*SwB)/(MW*sw**3*6._/**/REALKIND)
    f(104) = (eQED**5*integralnorm*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(105) = (eQED**5*integralnorm*SwB)/(cw**2*MW*sw**3*2._/**/REALKIND)
    f(106) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*12._/**/REALKIND)
    f(107) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*8._/**/REALKIND)
    f(108) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*6._/**/REALKIND)
    f(109) = (eQED**5*integralnorm*MB*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(110) = (eQED**5*integralnorm*MB*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(111) = (eQED**5*integralnorm*MB*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(112) = (cw**2*eQED**5*integralnorm*MB*SwB)/(MW*sw**3*2._/**/REALKIND)
    f(113) = (eQED**5*integralnorm*MB**2*SwB)/(MW*sw**3*8._/**/REALKIND)
    f(114) = (eQED**5*integralnorm*MB**2*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(115) = (eQED**5*integralnorm*MB**2*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(116) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(117) = (eQED**5*integralnorm*MH**2*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(118) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(119) = (eQED**5*integralnorm*MB*MH**2*SwB)/(MW*sw**3*8._/**/REALKIND)
    f(120) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW*sw**3*8._/**/REALKIND)
    f(121) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(122) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(123) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*12._/**/REALKIND)
    f(124) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*6._/**/REALKIND)
    f(125) = (eQED**5*integralnorm*MT*SwB)/(MW*sw**3*4._/**/REALKIND)
    f(126) = (eQED**5*integralnorm*MW*SwB)/(sw**3*12._/**/REALKIND)
    f(127) = (eQED**5*integralnorm*MW*SwB)/(sw**3*6._/**/REALKIND)
    f(128) = (eQED**5*integralnorm*MW*SwB)/(sw**3*4._/**/REALKIND)
    f(129) = (eQED**5*integralnorm*MW*SwB)/(sw**3*3._/**/REALKIND)
    f(130) = (eQED**5*integralnorm*MW*SwB)/(sw**3*2._/**/REALKIND)
    f(131) = (eQED**5*integralnorm*MW*SwB)/sw**3
    f(132) = (eQED**5*integralnorm*MW*SwB)/(cw**4*sw**3*4._/**/REALKIND)
    f(133) = (eQED**5*integralnorm*MW*SwB)/(cw**4*sw**3*2._/**/REALKIND)
    f(134) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw**3*2._/**/REALKIND)
    f(135) = (cw**2*eQED**5*integralnorm*MW*SwB)/(sw**3*2._/**/REALKIND)
    f(136) = (cw**2*eQED**5*integralnorm*MW*SwB)/sw**3
    f(137) = (eQED**5*integralnorm*MB*MW*SwB)/(sw**3*8._/**/REALKIND)
    f(138) = (eQED**5*integralnorm*MB*MW*SwB)/(sw**3*4._/**/REALKIND)
    f(139) = (eQED**5*integralnorm*MB*MW*SwB)/(sw**3*2._/**/REALKIND)
    f(140) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**4*sw**3*2._/**/REALKIND)
    f(141) = (3*eQED**5*integralnorm*lambdaHHH*MH**2*MW*SwB)/(cw**4*sw**3*2._/**/REALKIND)
    f(142) = (eQED**5*integralnorm*MW**3*SwB)/(cw**6*sw**3)
    f(143) = (eQED**5*integralnorm*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(144) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**2*36._/**/REALKIND)
    f(145) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**2*12._/**/REALKIND)
    f(146) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(147) = (eQED**5*integralnorm*MB*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(148) = (cw*eQED**5*integralnorm*MB*SwB)/(MW*sw**2*6._/**/REALKIND)
    f(149) = (cw*eQED**5*integralnorm*MB*SwB)/(MW*sw**2*2._/**/REALKIND)
    f(150) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(151) = (eQED**5*integralnorm*MB**2*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(152) = (eQED**5*integralnorm*MH**2*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(153) = (eQED**5*integralnorm*MB*MH**2*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(154) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*SwB)/(cw*MW*sw**2*8._/**/REALKIND)
    f(155) = (eQED**5*integralnorm*MT*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(156) = (eQED**5*integralnorm*MW*SwB)/(cw**3*sw**2*2._/**/REALKIND)
    f(157) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*12._/**/REALKIND)
    f(158) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(159) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*3._/**/REALKIND)
    f(160) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2*2._/**/REALKIND)
    f(161) = (eQED**5*integralnorm*MW*SwB)/(cw*sw**2)
    f(162) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**2*6._/**/REALKIND)
    f(163) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**2*3._/**/REALKIND)
    f(164) = (cw*eQED**5*integralnorm*MW*SwB)/(sw**2*2._/**/REALKIND)
    f(165) = (cw*eQED**5*integralnorm*MW*SwB)/sw**2
    f(166) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**3*sw**2*4._/**/REALKIND)
    f(167) = (eQED**5*integralnorm*MB*MW*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(168) = (eQED**5*integralnorm*MB*SwB)/(MW*sw*54._/**/REALKIND)
    f(169) = (eQED**5*integralnorm*MB*SwB)/(MW*sw*18._/**/REALKIND)
    f(170) = (eQED**5*integralnorm*MB*SwB)/(MW*sw*6._/**/REALKIND)
    f(171) = (eQED**5*integralnorm*MB*SwB)/(MW*sw*2._/**/REALKIND)
    f(172) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(MW*sw*6._/**/REALKIND)
    f(173) = (eQED**3*gQCD**2*integralnorm*MB*SwB)/(MW*sw*2._/**/REALKIND)
    f(174) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw*6._/**/REALKIND)
    f(175) = (eQED**5*integralnorm*MH**2*SwB)/(MW*sw*3._/**/REALKIND)
    f(176) = (eQED**5*integralnorm*MW*SwB)/(sw*6._/**/REALKIND)
    f(177) = (eQED**5*integralnorm*MW*SwB)/(sw*3._/**/REALKIND)
    f(178) = (eQED**5*integralnorm*MW*SwB)/(sw*2._/**/REALKIND)
    f(179) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw*9._/**/REALKIND)
    f(180) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(181) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw*3._/**/REALKIND)
    f(182) = (eQED**5*integralnorm*MW*SwB)/(cw**2*sw)
    f(183) = (eQED**3*gQCD**2*integralnorm*MW*SwB)/(cw**2*sw)
    f(184) = (eQED**5*integralnorm*MB*MW*SwB)/(sw*6._/**/REALKIND)
    f(185) = (eQED**5*integralnorm*MB*MW*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(186) = (eQED**5*integralnorm*MH**2*MW*SwB)/(sw*6._/**/REALKIND)
    f(187) = (eQED**5*integralnorm*MW**3*SwB)/(sw*3._/**/REALKIND)
    f(188) = (eQED**5*integralnorm*MW*sw*SwB)/(cw**2*2._/**/REALKIND)
    f(189) = (eQED**5*integralnorm*MB*MW*sw*SwB)/(cw**2*2._/**/REALKIND)
    f(190) = (eQED**5*integralnorm*MH**2*MW*sw*SwB)/(cw**2*2._/**/REALKIND)
    f(191) = (eQED**5*integralnorm*MW**3*sw*SwB)/cw**4
    f(192) = (eQED**5*integralnorm*MW**3*sw*SwB)/cw**2
    f(193) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*8._/**/REALKIND))
    f(194) = -((eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*8._/**/REALKIND))
    f(195) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND))
    f(196) = -((eQED**5*integralnorm*MB**2*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND))
    f(197) = -((eQED**5*integralnorm*MB*MH**4*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND))
    f(198) = (-3*eQED**5*integralnorm*lambdaHHH*MB*MH**4*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(199) = -((eQED**5*integralnorm*MT*(cw - sw)*(cw + sw)*SwB)/(cw*MW**3*sw**4*8._/**/REALKIND))
    f(200) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw**3*MW*sw**4*4._/**/REALKIND))
    f(201) = -((eQED**5*integralnorm*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**4*8._/**/REALKIND))
    f(202) = -((eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**4*16._/**/REALKIND))
    f(203) = -((eQED**5*integralnorm*MB*SwB*(-(cw**2*sw**2*16._/**/REALKIND) + cw**4*8._/**/REALKIND  &
      + sw**4*8._/**/REALKIND))/(cw**3*MW*sw**4*16._/**/REALKIND*8._/**/REALKIND))
    f(204) = (eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*12._/**/REALKIND)
    f(205) = (eQED**5*integralnorm*MB*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(206) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*12._/**/REALKIND)
    f(207) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*6._/**/REALKIND)
    f(208) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*4._/**/REALKIND)
    f(209) = (eQED**5*integralnorm*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw*MW*sw**2*2._/**/REALKIND)
    f(210) = -((eQED**5*integralnorm*MB*MH**2*(cw - sw)*(cw + sw)*SwB)/(cw**3*MW*sw**4*8._/**/REALKIND))
    f(211) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**2*6._/**/REALKIND)
    f(212) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw**3*sw**2*2._/**/REALKIND)
    f(213) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*12._/**/REALKIND)
    f(214) = (eQED**5*integralnorm*MW*(cw - sw)*(cw + sw)*SwB)/(cw*sw**2*4._/**/REALKIND)
    f(215) = (eQED**5*integralnorm*MB*(-cw + sw)*(cw + sw)*SwB)/(cw**2*MW*sw**3*8._/**/REALKIND)
    f(216) = (eQED**5*integralnorm*MB*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW*sw**3*4._/**/REALKIND*8._/**/REALKIND)
    f(217) = (eQED**5*integralnorm*MH**2*SwB*(cw**4*4._/**/REALKIND + sw**4*4._/**/REALKIND  &
      - cw**2*sw**2*8._/**/REALKIND))/(cw**2*MW*sw**3*4._/**/REALKIND*8._/**/REALKIND)
    f(218) = (eQED**5*integralnorm*MH**2*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**2*MW*sw**3*2._/**/REALKIND*4._/**/REALKIND)
    f(219) = (eQED**5*integralnorm*MW*SwB*(cw**4*2._/**/REALKIND + sw**4*2._/**/REALKIND  &
      - cw**2*sw**2*4._/**/REALKIND))/(cw**4*sw**3*2._/**/REALKIND*4._/**/REALKIND)
    f(220) = (eQED**5*integralnorm*MW*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sw*4._/**/REALKIND)
    f(221) = (eQED**5*integralnorm*MB**3*SwF)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(222) = (eQED**5*integralnorm*MB*ML**2*SwF)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(223) = (eQED**5*integralnorm*MB*MM**2*SwF)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(224) = (eQED**5*integralnorm*MB*MT**2*SwF)/(cw*MW**3*sw**4*16._/**/REALKIND)
    f(225) = (eQED**5*integralnorm*MB**3*SwF)/(MW**3*sw**3*24._/**/REALKIND)
    f(226) = (eQED**5*integralnorm*MB**3*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(227) = (eQED**5*integralnorm*MB**2*MH**2*SwF)/(MW**3*sw**3*24._/**/REALKIND)
    f(228) = (eQED**5*integralnorm*MB**2*MH**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(229) = (eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(230) = (3*eQED**5*integralnorm*lambdaHHH*MB**2*MH**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(231) = (eQED**5*integralnorm*MB**2*ML*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(232) = (eQED**5*integralnorm*MB*MH**2*ML*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(233) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*ML*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(234) = (eQED**5*integralnorm*MB*ML**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(235) = (eQED**5*integralnorm*MB**2*MM*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(236) = (eQED**5*integralnorm*MB*MH**2*MM*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(237) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MM*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(238) = (eQED**5*integralnorm*MB*MM**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(239) = (eQED**5*integralnorm*MB**2*MT*SwF)/(MW**3*sw**3*12._/**/REALKIND)
    f(240) = (eQED**5*integralnorm*MB**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(241) = (eQED**5*integralnorm*MB*MH**2*MT*SwF)/(MW**3*sw**3*12._/**/REALKIND)
    f(242) = (eQED**5*integralnorm*MB*MH**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(243) = (eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwF)/(MW**3*sw**3*4._/**/REALKIND)
    f(244) = (3*eQED**5*integralnorm*lambdaHHH*MB*MH**2*MT*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(245) = (eQED**5*integralnorm*MB*MT**2*SwF)/(MW**3*sw**3*12._/**/REALKIND)
    f(246) = (eQED**5*integralnorm*MB*MT**2*SwF)/(MW**3*sw**3*8._/**/REALKIND)
    f(247) = (eQED**5*integralnorm*MB**2*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(248) = (eQED**5*integralnorm*MB*ML*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(249) = (eQED**5*integralnorm*MB*MM*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(250) = (eQED**5*integralnorm*MB*MT*SwF)/(cw**2*MW*sw**3*4._/**/REALKIND)
    f(251) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*36._/**/REALKIND)
    f(252) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*12._/**/REALKIND)
    f(253) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*6._/**/REALKIND)
    f(254) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(255) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*3._/**/REALKIND)
    f(256) = (eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*2._/**/REALKIND)
    f(257) = (3*eQED**5*integralnorm*MB*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(258) = (eQED**5*integralnorm*ML*SwF)/(cw*MW*sw**2*12._/**/REALKIND)
    f(259) = (eQED**5*integralnorm*ML*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(260) = (eQED**5*integralnorm*MM*SwF)/(cw*MW*sw**2*12._/**/REALKIND)
    f(261) = (eQED**5*integralnorm*MM*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(262) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*18._/**/REALKIND)
    f(263) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*6._/**/REALKIND)
    f(264) = (eQED**5*integralnorm*MT*SwF)/(cw*MW*sw**2*4._/**/REALKIND)
    f(265) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*54._/**/REALKIND)
    f(266) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*27._/**/REALKIND)
    f(267) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*18._/**/REALKIND)
    f(268) = (2*eQED**5*integralnorm*MB*SwF)/(MW*sw*27._/**/REALKIND)
    f(269) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*9._/**/REALKIND)
    f(270) = (4*eQED**5*integralnorm*MB*SwF)/(MW*sw*27._/**/REALKIND)
    f(271) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*6._/**/REALKIND)
    f(272) = (2*eQED**5*integralnorm*MB*SwF)/(MW*sw*9._/**/REALKIND)
    f(273) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*3._/**/REALKIND)
    f(274) = (eQED**5*integralnorm*MB*SwF)/(MW*sw*2._/**/REALKIND)
    f(275) = (2*eQED**5*integralnorm*MB*SwF)/(MW*sw*3._/**/REALKIND)
    f(276) = (eQED**5*integralnorm*MB*SwF)/(MW*sw)
    f(277) = (3*eQED**5*integralnorm*MB*SwF)/(MW*sw*2._/**/REALKIND)
    f(278) = (eQED**5*integralnorm*ML*SwF)/(MW*sw*6._/**/REALKIND)
    f(279) = (eQED**5*integralnorm*ML*SwF)/(MW*sw*2._/**/REALKIND)
    f(280) = (eQED**5*integralnorm*MM*SwF)/(MW*sw*6._/**/REALKIND)
    f(281) = (eQED**5*integralnorm*MM*SwF)/(MW*sw*2._/**/REALKIND)
    f(282) = (2*eQED**5*integralnorm*MT*SwF)/(MW*sw*27._/**/REALKIND)
    f(283) = (eQED**5*integralnorm*MT*SwF)/(MW*sw*9._/**/REALKIND)
    f(284) = (eQED**5*integralnorm*MT*SwF)/(MW*sw*3._/**/REALKIND)
    f(285) = (eQED**5*integralnorm*MT*SwF)/(MW*sw*2._/**/REALKIND)
    f(286) = (eQED**5*integralnorm*MW*SwF)/(cw**2*sw*9._/**/REALKIND)
    f(287) = (2*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*9._/**/REALKIND)
    f(288) = (eQED**5*integralnorm*MW*SwF)/(cw**2*sw*3._/**/REALKIND)
    f(289) = (4*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*9._/**/REALKIND)
    f(290) = (2*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*3._/**/REALKIND)
    f(291) = (eQED**5*integralnorm*MW*SwF)/(cw**2*sw)
    f(292) = (4*eQED**5*integralnorm*MW*SwF)/(cw**2*sw*3._/**/REALKIND)
    f(293) = (2*eQED**5*integralnorm*MW*SwF)/(cw**2*sw)
    f(294) = (3*eQED**5*integralnorm*MW*SwF)/(cw**2*sw)

  c = [ 3*f(32), 3*f(33), 3*f(34), 3*f(35), 3*f(36), 3*f(37), 3*f(38), 3*f(39), 3*f(40), 3*f(41), 3*f(42), 3*f(43), 3*f(44) &
    , 3*f(45), 3*f(46), 3*f(47), 3*f(48), 3*f(49), 3*f(50), 3*f(51), 3*f(52), 3*f(53), 3*f(54), 3*f(55), 3*f(56), 3*f(57), 3*f(58) &
    , 3*f(59), 3*f(60), 3*f(61), 3*f(62), 3*f(63), 3*f(64), 3*f(65), 3*f(66), 3*f(67), 3*f(68), 3*f(69), 3*f(70), 3*f(71), 3*f(72) &
    , 3*f(73), 3*f(74), 3*f(75), 3*f(76), 3*f(77), 3*f(78), 3*f(79), 3*f(80), 3*f(81), 3*f(82), 3*f(83), 3*f(84), 3*f(85), 3*f(86) &
    , 3*f(87), 3*f(88), 3*f(89), 3*f(90), 3*f(91), 3*f(92), 3*f(93), 3*f(94), 3*f(95), 3*f(96), 3*f(97), 3*f(98), 3*f(99) &
    , 3*f(100), 3*f(101), 3*f(102), 3*f(103), 3*f(104), 3*f(105), 3*f(106), 3*f(107), 3*f(108), 3*f(109), 3*f(110), 3*f(111) &
    , 3*f(112), 3*f(113), 3*f(114), 3*f(115), 3*f(116), 3*f(117), 3*f(118), 3*f(119), 3*f(120), 3*f(121), 3*f(122), 3*f(123) &
    , 3*f(124), 3*f(125), 3*f(126), 3*f(127), 3*f(128), 3*f(129), 3*f(130), 3*f(131), 3*f(132), 3*f(133), 3*f(134), 3*f(135) &
    , 3*f(136), 3*f(137), 3*f(138), 3*f(139), 3*f(140), 3*f(141), 3*f(142), 3*f(143), 3*f(144), 3*f(145), 3*f(146), 3*f(147) &
    , 3*f(148), 3*f(149), 4*f(150), 3*f(151), 3*f(152), 3*f(153), 3*f(154), 3*f(155), 3*f(156), 3*f(157), 3*f(158), 3*f(159) &
    , 3*f(160), 3*f(161), 3*f(162), 3*f(163), 3*f(164), 3*f(165), 3*f(166), 3*f(167), 3*f(168), 3*f(169), 3*f(170), 3*f(171) &
    , 4*f(172), 4*f(173), 3*f(174), 3*f(175), 3*f(176), 3*f(177), 3*f(178), 3*f(179), 3*f(180), 3*f(181), 3*f(182), 4*f(183) &
    , 3*f(184), 3*f(185), 3*f(186), 3*f(187), 3*f(188), 3*f(189), 3*f(190), 3*f(191), 3*f(192), 3*f(193), 3*f(194), 3*f(195) &
    , 3*f(196), 3*f(197), 3*f(198), 3*f(199), 3*f(200), 3*f(201), 3*f(202), 3*f(203), 3*f(204), 3*f(205), 3*f(206), 3*f(207) &
    , 3*f(208), 3*f(209), 3*f(210), 3*f(211), 3*f(212), 3*f(213), 3*f(214), 3*f(215), 3*f(216), 3*f(217), 3*f(218), 3*f(219) &
    , 3*f(220), 9*f(221), 3*f(222), 3*f(223), 9*f(224), 9*f(225), 9*f(226), 9*f(227), 9*f(228), 9*f(229), 9*f(230), 3*f(231) &
    , 3*f(232), 3*f(233), 3*f(234), 3*f(235), 3*f(236), 3*f(237), 3*f(238), 9*f(239), 9*f(240), 9*f(241), 9*f(242), 9*f(243) &
    , 9*f(244), 9*f(245), 9*f(246), 9*f(247), 3*f(248), 3*f(249), 9*f(250), 9*f(251), 9*f(252), 9*f(253), 3*f(254), 9*f(254) &
    , 9*f(255), 9*f(256), 3*f(257), 3*f(258), 3*f(259), 3*f(260), 3*f(261), 9*f(262), 9*f(263), 9*f(264), 9*f(265), 9*f(266) &
    , 9*f(267), 9*f(268), 9*f(269), 9*f(270), 3*f(271), 9*f(271), 9*f(272), 9*f(273), 3*f(274), 9*f(274), 9*f(275), 9*f(276) &
    , 3*f(277), 3*f(278), 3*f(279), 3*f(280), 3*f(281), 9*f(282), 9*f(283), 9*f(284), 9*f(285), 9*f(286), 9*f(287), 3*f(288) &
    , 9*f(288), 9*f(289), 9*f(290), 3*f(291), 9*f(291), 9*f(292), 9*f(293), 3*f(294) ]
  c = (1._/**/REALKIND / 3) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2, POLSEL)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,5)
  integer,           intent(in)  :: H(5)
  integer,           intent(in), optional  :: POLSEL(5)
  complex(REALKIND), intent(out) :: M1(1), M2(2)
  complex(REALKIND) :: A(72)
  ! external WFs
  if (present(POLSEL)) then
    call pol_wf_Q(P(:,1), rZERO, H(1), wf(:,0), POLSEL(1))
    call pol_wf_A(P(:,2), rZERO, H(2), wf(:,-1), POLSEL(2))
    call pol_wf_Q(P(:,3), rMB, H(3), wf(:,-2), POLSEL(3))
    call pol_wf_A(P(:,4), rMB, H(4), wf(:,-3), POLSEL(4))
    call pol_wf_S(P(:,5), rMH, H(5), wf(:,-4), POLSEL(5))

  else
    call pol_wf_Q(P(:,1), rZERO, H(1), wf(:,0), 0)
    call pol_wf_A(P(:,2), rZERO, H(2), wf(:,-1), 0)
    call pol_wf_Q(P(:,3), rMB, H(3), wf(:,-2), 0)
    call pol_wf_A(P(:,4), rMB, H(4), wf(:,-3), 0)
    call pol_wf_S(P(:,5), rMH, H(5), wf(:,-4), 0)

  end if

  ! internal WFs
  call vert_QA_Z(gZl,wf(:,0),wf(:,-1),wf(:,1))
  call vert_AQ_S(gX,wf(:,-3),wf(:,-2),wf(:,2))
  call vert_TV_S(wf(:,-4),Q(:,16),wf(:,1),Q(:,3),wf(:,3))
  call vert_QA_Z(gZd,wf(:,-2),wf(:,-3),wf(:,4))
  call vert_SV_V(wf(:,-4),wf(:,1),wf(:,5))
  call vert_QA_V(wf(:,0),wf(:,-1),wf(:,6))
  call vert_QS_A(gH,wf(:,-2),wf(:,-4),wf(:,7))
  call prop_Q_A(wf(:,7),Q(:,20),MB,1_intkind1,wf(:,8))
  call vert_AV_Q(wf(:,-3),wf(:,6),wf(:,9))
  call vert_AZ_Q(gZd,wf(:,-3),wf(:,1),wf(:,10))
  call vert_SA_Q(gH,wf(:,-4),wf(:,-3),wf(:,11))
  call prop_A_Q(wf(:,11),Q(:,24),MB,1_intkind1,wf(:,12))
  call vert_VQ_A(wf(:,6),wf(:,-2),wf(:,13))
  call vert_ZQ_A(gZd,wf(:,1),wf(:,-2),wf(:,14))
  call counter_TV_S(wf(:,-4),Q(:,16),wf(:,6),Q(:,3),wf(:,15))
  call counter_TV_S(wf(:,-4),Q(:,16),wf(:,1),Q(:,3),wf(:,16))
  call vert_QA_V(wf(:,-2),wf(:,-3),wf(:,17))
  call counter_SV_V(wf(:,-4),wf(:,6),wf(:,18))
  call counter_SV_V(wf(:,-4),wf(:,1),wf(:,19))
  call counter_AV_Q(wf(:,-3),wf(:,6),wf(:,20))
  call counter_AV_Q_LR(EWctAbb,wf(:,-3),wf(:,6),wf(:,21))
  call counter_AZ_Q(gZd,wf(:,-3),wf(:,1),wf(:,22))
  call counter_AZ_Q(EWctVbb,wf(:,-3),wf(:,1),wf(:,23))
  call counter_SA_Q(gH,wf(:,-4),wf(:,-3),wf(:,24))
  call prop_A_Q(wf(:,24),Q(:,24),MB,1_intkind1,wf(:,25))
  call counter_SA_Q(EWctHbb,wf(:,-4),wf(:,-3),wf(:,26))
  call prop_A_Q(wf(:,26),Q(:,24),MB,1_intkind1,wf(:,27))
  call counter_VQ_A(wf(:,6),wf(:,-2),wf(:,28))
  call counter_VQ_A_LR(EWctAbb,wf(:,6),wf(:,-2),wf(:,29))
  call counter_ZQ_A(gZd,wf(:,1),wf(:,-2),wf(:,30))
  call counter_ZQ_A(EWctVbb,wf(:,1),wf(:,-2),wf(:,31))
  call counter_QS_A(gH,wf(:,-2),wf(:,-4),wf(:,32))
  call prop_Q_A(wf(:,32),Q(:,20),MB,1_intkind1,wf(:,33))
  call counter_QS_A(EWctHbb,wf(:,-2),wf(:,-4),wf(:,34))
  call prop_Q_A(wf(:,34),Q(:,20),MB,1_intkind1,wf(:,35))
  call counter_AQ_S(gX,wf(:,-3),wf(:,-2),wf(:,36))
  call counter_AQ_S(EWctXbb,wf(:,-3),wf(:,-2),wf(:,37))
  call counter_QA_Z(gZd,wf(:,-2),wf(:,-3),wf(:,38))
  call counter_QA_Z(EWctVbb,wf(:,-2),wf(:,-3),wf(:,39))
  call counter_QA_Z(EWctVee,wf(:,0),wf(:,-1),wf(:,40))
  call vert_TV_S(wf(:,-4),Q(:,16),wf(:,40),Q(:,3),wf(:,41))
  call vert_SV_V(wf(:,-4),wf(:,40),wf(:,42))
  call counter_QA_Z(EWctAee,wf(:,0),wf(:,-1),wf(:,43))
  call vert_AV_Q(wf(:,-3),wf(:,43),wf(:,44))
  call vert_AZ_Q(gZd,wf(:,-3),wf(:,40),wf(:,45))
  call vert_VQ_A(wf(:,43),wf(:,-2),wf(:,46))
  call vert_ZQ_A(gZd,wf(:,40),wf(:,-2),wf(:,47))
  call vert_SS_S(wf(:,2),wf(:,-4),wf(:,48))
  call counter_V_S(EWctXA,wf(:,6),Q(:,3),wf(:,49))
  call counter_V_S(EWctXZ,wf(:,1),Q(:,3),wf(:,50))
  call vert_TV_S(wf(:,-4),Q(:,16),wf(:,4),Q(:,12),wf(:,51))
  call vert_ST_V(wf(:,2),Q(:,12),wf(:,-4),Q(:,16),wf(:,52))
  call counter_V_V(EWctAZ,wf(:,6),Q(:,3),wf(:,53))
  call counter_V_V(EWctZZ,wf(:,1),Q(:,3),wf(:,54))
  call vert_SV_V(wf(:,-4),wf(:,4),wf(:,55))
  call counter_S_S(EWctXX,wf(:,2),Q(:,12),wf(:,56))
  call counter_S_V(EWctXZ,wf(:,2),Q(:,12),wf(:,57))
  call counter_V_S(EWctXA,wf(:,17),Q(:,12),wf(:,58))
  call counter_V_S(EWctXZ,wf(:,4),Q(:,12),wf(:,59))
  call counter_V_V(EWctAZ,wf(:,17),Q(:,12),wf(:,60))
  call counter_V_V(EWctZZ,wf(:,4),Q(:,12),wf(:,61))
  call vert_AQ_S(gX,wf(:,-3),wf(:,8),wf(:,62))
  call vert_QA_V(wf(:,8),wf(:,-3),wf(:,63))
  call counter_V_V(EWctAA,wf(:,6),Q(:,3),wf(:,64))
  call vert_QA_Z(gZd,wf(:,8),wf(:,-3),wf(:,65))
  call counter_V_V(EWctAZ,wf(:,1),Q(:,3),wf(:,66))
  call counter_Q_A(ctbb,5,wf(:,8),Q(:,20),wf(:,67))
  call prop_A_Q(wf(:,9),Q(:,11),MB,1_intkind1,wf(:,68))
  call counter_Q_A_LR(EWctbb,wf(:,8),Q(:,20),wf(:,69))
  call prop_A_Q(wf(:,10),Q(:,11),MB,1_intkind1,wf(:,70))
  call vert_AQ_S(gX,wf(:,12),wf(:,-2),wf(:,71))
  call vert_QA_V(wf(:,-2),wf(:,12),wf(:,72))
  call vert_QA_Z(gZd,wf(:,-2),wf(:,12),wf(:,73))
  call counter_A_Q(ctbb,5,wf(:,12),Q(:,24),wf(:,74))
  call prop_Q_A(wf(:,13),Q(:,7),MB,1_intkind1,wf(:,75))
  call counter_A_Q_LR(EWctbb,wf(:,12),Q(:,24),wf(:,76))
  call prop_Q_A(wf(:,14),Q(:,7),MB,1_intkind1,wf(:,77))
  call vert_AQ_S(gH,wf(:,-3),wf(:,-2),wf(:,78))
  call vert_VQ_A(wf(:,17),wf(:,0),wf(:,79))
  call prop_Q_A(wf(:,79),Q(:,13),ZERO,0_intkind1,wf(:,80))
  call vert_ZQ_A(gZl,wf(:,4),wf(:,0),wf(:,81))
  call prop_Q_A(wf(:,81),Q(:,13),ZERO,0_intkind1,wf(:,82))
  call vert_AV_Q(wf(:,-1),wf(:,17),wf(:,83))
  call prop_A_Q(wf(:,83),Q(:,14),ZERO,0_intkind1,wf(:,84))
  call vert_AZ_Q(gZl,wf(:,-1),wf(:,4),wf(:,85))
  call prop_A_Q(wf(:,85),Q(:,14),ZERO,0_intkind1,wf(:,86))
  call vert_SS_S(wf(:,78),wf(:,-4),wf(:,87))
  call vert_AQ_S(gH,wf(:,-3),wf(:,8),wf(:,88))
  call vert_AQ_S(gH,wf(:,12),wf(:,-2),wf(:,89))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,3) - MZ2)
  den(2) = 1 / (Q(5,12) - MZ2)
  den(4) = 1 / (Q(5,3))
  den(5) = 1 / (Q(5,20) - MB2)
  den(8) = 1 / (Q(5,24) - MB2)
  den(12) = 1 / (Q(5,12))
  den(15) = 1 / (Q(5,28) - MZ2)
  den(19) = 1 / (Q(5,19) - MZ2)
  den(26) = 1 / (Q(5,28))
  den(30) = 1 / (Q(5,11) - MB2)
  den(41) = 1 / (Q(5,7) - MB2)
  den(46) = 1 / (Q(5,12) - MH2)
  den(47) = 1 / (Q(5,13))
  den(50) = 1 / (Q(5,14))
  den(53) = 1 / (Q(5,28) - MH2)

  ! denominators
  den(3) = den(1)*den(2)
  den(6) = den(4)*den(5)
  den(7) = den(1)*den(5)
  den(9) = den(4)*den(8)
  den(10) = den(1)*den(8)
  den(11) = den(2)*den(4)
  den(13) = den(4)*den(12)
  den(14) = den(1)*den(12)
  den(16) = den(2)*den(15)
  den(17) = den(4)*den(16)
  den(18) = den(1)*den(16)
  den(20) = den(1)*den(19)
  den(21) = den(2)*den(20)
  den(22) = den(12)*den(20)
  den(23) = den(5)*den(15)
  den(24) = den(4)*den(23)
  den(25) = den(1)*den(23)
  den(27) = den(5)*den(26)
  den(28) = den(4)*den(27)
  den(29) = den(1)*den(27)
  den(31) = den(4)*den(30)
  den(32) = den(5)*den(31)
  den(33) = den(1)*den(30)
  den(34) = den(5)*den(33)
  den(35) = den(8)*den(15)
  den(36) = den(4)*den(35)
  den(37) = den(1)*den(35)
  den(38) = den(8)*den(26)
  den(39) = den(4)*den(38)
  den(40) = den(1)*den(38)
  den(42) = den(4)*den(41)
  den(43) = den(8)*den(42)
  den(44) = den(1)*den(41)
  den(45) = den(8)*den(44)
  den(48) = den(12)*den(47)
  den(49) = den(2)*den(47)
  den(51) = den(12)*den(50)
  den(52) = den(2)*den(50)
  den(54) = den(46)*den(53)
  den(55) = den(5)*den(53)
  den(56) = den(8)*den(53)
  den(57) = den(4)*den(46)
  den(58) = den(1)*den(46)
  den(59) = den(20)*den(46)
  den(60) = den(4)*den(54)
  den(61) = den(1)*den(54)
  den(62) = den(4)*den(55)
  den(63) = den(1)*den(55)
  den(64) = den(4)*den(56)
  den(65) = den(1)*den(56)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(72)

  A(1) = cont_SS(wf(:,2),wf(:,3)) * den(3)
  A(2) = cont_VV(wf(:,4),wf(:,5)) * den(3)
  A(3) = cont_QA(wf(:,8),wf(:,9)) * den(6)
  A(4) = cont_QA(wf(:,8),wf(:,10)) * den(7)
  A(5) = cont_QA(wf(:,12),wf(:,13)) * den(9)
  A(6) = cont_QA(wf(:,12),wf(:,14)) * den(10)

  A(7) = cont_SS(wf(:,2),wf(:,15)) * den(11)
  A(8) = cont_SS(wf(:,2),wf(:,16)) * den(3)
  A(9) = cont_VV(wf(:,17),wf(:,18)) * den(13)
  A(10) = cont_VV(wf(:,4),wf(:,18)) * den(11)
  A(11) = cont_VV(wf(:,17),wf(:,19)) * den(14)
  A(12) = cont_VV(wf(:,4),wf(:,19)) * den(3)
  A(13) = cont_QA(wf(:,8),wf(:,20)) * den(6)
  A(14) = cont_QA(wf(:,8),wf(:,21)) * den(6)
  A(15) = cont_QA(wf(:,8),wf(:,22)) * den(7)
  A(16) = cont_QA(wf(:,8),wf(:,23)) * den(7)
  A(17) = cont_QA(wf(:,13),wf(:,25)) * den(9)
  A(18) = cont_QA(wf(:,13),wf(:,27)) * den(9)
  A(19) = cont_QA(wf(:,14),wf(:,25)) * den(10)
  A(20) = cont_QA(wf(:,14),wf(:,27)) * den(10)
  A(21) = cont_QA(wf(:,12),wf(:,28)) * den(9)
  A(22) = cont_QA(wf(:,12),wf(:,29)) * den(9)
  A(23) = cont_QA(wf(:,12),wf(:,30)) * den(10)
  A(24) = cont_QA(wf(:,12),wf(:,31)) * den(10)
  A(25) = cont_QA(wf(:,9),wf(:,33)) * den(6)
  A(26) = cont_QA(wf(:,9),wf(:,35)) * den(6)
  A(27) = cont_QA(wf(:,10),wf(:,33)) * den(7)
  A(28) = cont_QA(wf(:,10),wf(:,35)) * den(7)
  A(29) = cont_SS(wf(:,3),wf(:,36)) * den(3)
  A(30) = cont_SS(wf(:,3),wf(:,37)) * den(3)
  A(31) = cont_VV(wf(:,5),wf(:,38)) * den(3)
  A(32) = cont_VV(wf(:,5),wf(:,39)) * den(3)
  A(33) = cont_SS(wf(:,2),wf(:,41)) * den(3)
  A(34) = cont_VV(wf(:,4),wf(:,42)) * den(3)
  A(35) = cont_QA(wf(:,8),wf(:,44)) * den(6)
  A(36) = cont_QA(wf(:,8),wf(:,45)) * den(7)
  A(37) = cont_QA(wf(:,12),wf(:,46)) * den(9)
  A(38) = cont_QA(wf(:,12),wf(:,47)) * den(10)
  A(39) = cont_SS(wf(:,48),wf(:,49)) * den(17)
  A(40) = cont_SS(wf(:,48),wf(:,50)) * den(18)
  A(41) = cont_SS(wf(:,49),wf(:,51)) * den(17)
  A(42) = cont_SS(wf(:,50),wf(:,51)) * den(18)
  A(43) = cont_VV(wf(:,52),wf(:,53)) * den(17)
  A(44) = cont_VV(wf(:,52),wf(:,54)) * den(18)
  A(45) = cont_VV(wf(:,53),wf(:,55)) * den(17)
  A(46) = cont_VV(wf(:,54),wf(:,55)) * den(18)
  A(47) = cont_SS(wf(:,3),wf(:,56)) * den(21)
  A(48) = cont_VV(wf(:,5),wf(:,57)) * den(21)
  A(49) = cont_SS(wf(:,3),wf(:,58)) * den(22)
  A(50) = cont_SS(wf(:,3),wf(:,59)) * den(21)
  A(51) = cont_VV(wf(:,5),wf(:,60)) * den(22)
  A(52) = cont_VV(wf(:,5),wf(:,61)) * den(21)
  A(53) = cont_SS(wf(:,49),wf(:,62)) * den(24)
  A(54) = cont_SS(wf(:,50),wf(:,62)) * den(25)
  A(55) = cont_VV(wf(:,63),wf(:,64)) * den(28)
  A(56) = cont_VV(wf(:,53),wf(:,65)) * den(24)
  A(57) = cont_VV(wf(:,63),wf(:,66)) * den(29)
  A(58) = cont_VV(wf(:,54),wf(:,65)) * den(25)
  A(59) = cont_QA(wf(:,67),wf(:,68)) * den(32)
  A(60) = cont_QA(wf(:,68),wf(:,69)) * den(32)
  A(61) = cont_QA(wf(:,67),wf(:,70)) * den(34)
  A(62) = cont_QA(wf(:,69),wf(:,70)) * den(34)
  A(63) = cont_SS(wf(:,49),wf(:,71)) * den(36)
  A(64) = cont_SS(wf(:,50),wf(:,71)) * den(37)
  A(65) = cont_VV(wf(:,64),wf(:,72)) * den(39)
  A(66) = cont_VV(wf(:,53),wf(:,73)) * den(36)
  A(67) = cont_VV(wf(:,66),wf(:,72)) * den(40)
  A(68) = cont_VV(wf(:,54),wf(:,73)) * den(37)
  A(69) = cont_QA(wf(:,74),wf(:,75)) * den(43)
  A(70) = cont_QA(wf(:,75),wf(:,76)) * den(43)
  A(71) = cont_QA(wf(:,74),wf(:,77)) * den(45)
  A(72) = cont_QA(wf(:,76),wf(:,77)) * den(45)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(72)
  complex(REALKIND), intent(out) :: M1(1), M2(2)

  M1(1) = -(A(1)*f(10))+(A(3)+A(5))*f(15)+(A(4)+A(6))*f(16)+A(2)*f(28)

  M2(1) = -(A(29)*f(12))+(-A(59)-A(69))*f(22)+(-A(61)-A(71))*f(23)+(A(17)+A(25))*f(24)+(A(19)+A(27))*f(25)+(A(13)+A(21))*f(26) &
       +(A(15)+A(23))*f(27)+A(31)*f(31)
  M2(2) = A(9)*f(1)+A(11)*f(2)+A(10)*f(3)+A(12)*f(4)+(-A(18)-A(26))*f(5)+(-A(20)-A(28))*f(6)+A(48)*f(7)+(A(53)+A(54)+A(63) &
       +A(64))*f(8)+(A(39)+A(40))*f(9)+(-A(33)+A(43)+A(44)+A(47))*f(11)-A(49)*f(13)+(-A(41)-A(42)-A(50))*f(14)+(A(35)+A(37)-A(55) &
       -A(57)-A(60)-A(65)-A(67)-A(70))*f(17)+(A(14)+A(16)+A(22)+A(24)+A(36)+A(38)-A(56)-A(58)-A(62)-A(66)-A(68)-A(72))*f(18) &
       -A(30)*f(19)+A(7)*f(20)+A(8)*f(21)-A(51)*f(29)+(A(32)+A(34)-A(45)-A(46)-A(52))*f(30)

end subroutine colourvectors

end module ol_loop_pphll_ew_eexbbxh_1_/**/REALKIND
