
module ol_vamp_1_pphll_ew_nexeudxh_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphll_ew_nexeudxh_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphll_ew_nexeudxh_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pphll_ew_nexeudxh_1_/**/DREALKIND
  use ol_tensor_sum_storage_pphll_ew_nexeudxh_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pphll_ew_nexeudxh_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pphll_ew_nexeudxh_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(20)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(1),h0tab(:,1),[16,2,1,4,8],[nMZ,0,nMW,0,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(2),m3h1x16(:,1),heltab2x16(:,:,1))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(2),h0tab(:,2),[16,2,1,4,8],[nMW,0,nMZ,0,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(3),m3h1x16(:,2),heltab2x16(:,:,2))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(3),h0tab(:,3),[16,2,1,8,4],[nMZ,0,nMW,0,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(4),m3h1x16(:,3),heltab2x16(:,:,3))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(4),h0tab(:,4),[16,2,1,8,4],[nMW,0,nMZ,0,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(5),m3h1x16(:,4),heltab2x16(:,:,4))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(5),h0tab(:,5),[16,1,2,4,8],[nMZ,0,nMW,0,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(6),m3h1x16(:,5),heltab2x16(:,:,5))
  Gcoeff(:)%j = (c(17)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(6),h0tab(:,6),[16,1,2,4,8],[nMW,0,0,0,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(7),m3h1x16(:,6),heltab2x16(:,:,6))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(7),h0tab(:,7),[16,1,2,4,8],[nMW,0,nMZ,0,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(8),m3h1x16(:,7),heltab2x16(:,:,7))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(8),h0tab(:,8),[16,1,2,8,4],[nMZ,0,nMW,0,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(9),m3h1x16(:,8),heltab2x16(:,:,8))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(9),h0tab(:,9),[16,1,2,8,4],[nMW,0,0,0,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(10),m3h1x16(:,9),heltab2x16(:,:,9))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(10),h0tab(:,10),[16,1,2,8,4],[nMW,0,nMZ,0,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(11),m3h1x16(:,10),heltab2x16(:,:,10))
  call Hloop_ZQ_A(ntryL,G0H16(2),ex2(:),G0H8(1),ngZl,m3h2x8(:,1),heltab2x16(:,:,11))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(1),n2h8(1))
  call Hloop_WQ_A(ntryL,G0H16(3),ex2(:),G0H8(1),m3h2x8(:,2),heltab2x16(:,:,12))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(2),n2h8(2))
  call Hloop_ZQ_A(ntryL,G0H16(4),ex2(:),G0H8(1),ngZl,m3h2x8(:,3),heltab2x16(:,:,13))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(3),n2h8(3))
  call Hloop_WQ_A(ntryL,G0H16(5),ex2(:),G0H8(1),m3h2x8(:,4),heltab2x16(:,:,14))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(4),n2h8(4))
  call Hloop_ZA_Q(ntryL,G0H16(6),ex1(:),G0H8(1),ngZn,m3h2x8(:,5),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G0H8(1),17,0,G1H8(5),n2h8(5))
  call Hloop_WA_Q(ntryL,G0H16(7),ex1(:),G0H8(1),m3h2x8(:,6),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G0H8(1),17,0,G1H8(6),n2h8(6))
  call Hloop_WA_Q(ntryL,G0H16(8),ex1(:),G0H8(1),m3h2x8(:,7),heltab2x16(:,:,17))
  call Hloop_A_Q(ntryL,G0H8(1),17,0,G1H8(7),n2h8(7))
  call Hloop_ZA_Q(ntryL,G0H16(9),ex1(:),G0H8(1),ngZn,m3h2x8(:,8),heltab2x16(:,:,18))
  call Hloop_A_Q(ntryL,G0H8(1),17,0,G1H8(8),n2h8(8))
  call Hloop_WA_Q(ntryL,G0H16(10),ex1(:),G0H8(1),m3h2x8(:,9),heltab2x16(:,:,19))
  call Hloop_A_Q(ntryL,G0H8(1),17,0,G1H8(9),n2h8(9))
  call Hloop_WA_Q(ntryL,G0H16(11),ex1(:),G0H8(1),m3h2x8(:,10),heltab2x16(:,:,20))
  call Hloop_A_Q(ntryL,G0H8(1),17,0,G1H8(10),n2h8(10))
  call Hloop_QA_W(ntryL,G1H8(1),ex1(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_QA_Z(ntryL,G1H8(2),ex1(:),G1H4(2),ngZn,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_QA_W(ntryL,G1H8(3),ex1(:),G1H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_QA_Z(ntryL,G1H8(4),ex1(:),G1H4(4),ngZn,m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_AQ_W(ntryL,G1H8(5),ex2(:),G1H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_V(ntryL,G1H8(6),ex2(:),G1H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_AQ_Z(ntryL,G1H8(7),ex2(:),G1H4(7),ngZl,m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_AQ_W(ntryL,G1H8(8),ex2(:),G1H4(8),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_AQ_V(ntryL,G1H8(9),ex2(:),G1H4(9),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_AQ_Z(ntryL,G1H8(10),ex2(:),G1H4(10),ngZl,m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_WQ_A(ntryL,G1H4(1),ex3(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(1),n2h2(1))
  call Hloop_ZQ_A(ntryL,G1H4(2),ex3(:),G1H2(1),ngZu,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(2),n2h2(2))
  call Hloop_WA_Q(ntryL,G1H4(3),ex4(:),G1H2(1),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(3),n2h2(3))
  call Hloop_ZA_Q(ntryL,G1H4(4),ex4(:),G1H2(1),ngZd,m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(4),n2h2(4))
  call Hloop_WQ_A(ntryL,G1H4(5),ex3(:),G1H2(1),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(5),n2h2(5))
  call Hloop_VQ_A(ntryL,G1H4(6),ex3(:),G1H2(1),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(6),n2h2(6))
  call Hloop_ZQ_A(ntryL,G1H4(7),ex3(:),G1H2(1),ngZu,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(7),n2h2(7))
  call Hloop_WA_Q(ntryL,G1H4(8),ex4(:),G1H2(1),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(8),n2h2(8))
  call Hloop_VA_Q(ntryL,G1H4(9),ex4(:),G1H2(1),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(9),n2h2(9))
  call Hloop_ZA_Q(ntryL,G1H4(10),ex4(:),G1H2(1),ngZd,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(10),n2h2(10))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(1),ngZd,m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(2),ex4(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(3),ex3(:),G2tensor(3),ngZu,m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(4),ex3(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(5),ex4(:),G2tensor(5),ngZd,m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(6),ex4(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(7),ex4(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(8),ex3(:),G2tensor(8),ngZu,m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(9),ex3(:),G2tensor(9),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(10),ex3(:),G2tensor(10),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(1),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(2),mass5set(:,1),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),4)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(2),mass5set(:,2),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),4)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(3),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),8)
  call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(3),mass5set(:,3),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(3),mass5set(:,2),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(8),RedSet_5(4),mass5set(:,1),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),4)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(4),mass5set(:,3),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),4)
  call Hotf_5pt_reduction_last(G2tensor(10),RedSet_5(4),mass5set(:,2),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  Gcoeff(:)%j = (-(c(13)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(11),h0tab(:,11),[16,3,8,4],[nMW,0,0,nMW],4,1,wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(1),0,ex5(:),16,G1H16(1),m3h1x16(:,11),heltab2x16(:,:,21))
  Gcoeff(:)%j = (-(c(24)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(12),h0tab(:,12),[16,3,8,4],[nMW,nMZ,0,nMW],4,1,wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(2),0,ex5(:),16,G1H16(2),m3h1x16(:,12),heltab2x16(:,:,22))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(3),m0h(13),h0tab(:,13),[16,3,8,4],[nMZ,nMW,0,nMZ],4,1,wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(3),ex5(:),G0H16(4),m3h1x16(:,13),heltab2x16(:,:,23))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(5),m0h(14),h0tab(:,14),[16,3,8,4],[nMW,0,0,nMW],4,1,wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(5),ex5(:),G0H16(6),m3h1x16(:,14),heltab2x16(:,:,24))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(15),h0tab(:,15),[16,3,8,4],[nMW,nMZ,0,nMW],4,1,wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(8),m3h1x16(:,15),heltab2x16(:,:,25))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(9),m0h(16),h0tab(:,16),[16,3,4,8],[nMW,0,0,nMW],4,1,wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(9),0,ex5(:),16,G1H16(3),m3h1x16(:,16),heltab2x16(:,:,26))
  Gcoeff(:)%j = (-(c(24)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(10),m0h(17),h0tab(:,17),[16,3,4,8],[nMW,nMZ,0,nMW],4,1,wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(10),0,ex5(:),16,G1H16(4),m3h1x16(:,17),heltab2x16(:,:,27))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(11),m0h(18),h0tab(:,18),[16,3,4,8],[nMZ,nMW,0,nMZ],4,1,wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(11),ex5(:),G0H16(1),m3h1x16(:,18),heltab2x16(:,:,28))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(19),h0tab(:,19),[16,3,4,8],[nMW,0,0,nMW],4,1,wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(2),ex5(:),G0H16(3),m3h1x16(:,19),heltab2x16(:,:,29))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(5),m0h(20),h0tab(:,20),[16,3,4,8],[nMW,nMZ,0,nMW],4,1,wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(5),ex5(:),G0H16(7),m3h1x16(:,20),heltab2x16(:,:,30))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(9),m0h(21),h0tab(:,21),[16,4,3,8],[nMZ,0,0,nMZ],4,1,wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(9),ex5(:),G0H16(10),m3h1x16(:,21),heltab2x16(:,:,31))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(11),m0h(22),h0tab(:,22),[16,1,2,12],[nMW,0,0,nMW],4,1,wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(11),0,ex5(:),16,G1H16(5),m3h1x16(:,22),heltab2x16(:,:,32))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(23),h0tab(:,23),[16,1,2,12],[nMW,0,nMZ,nMW],4,1,wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(2),0,ex5(:),16,G1H16(6),m3h1x16(:,23),heltab2x16(:,:,33))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(5),m0h(24),h0tab(:,24),[16,1,2,12],[nMZ,0,nMW,nMZ],4,1,wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(5),ex5(:),G0H16(9),m3h1x16(:,24),heltab2x16(:,:,34))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(11),m0h(25),h0tab(:,25),[16,1,2,12],[nMW,0,0,nMW],4,1,wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(11),ex5(:),G0H16(2),m3h1x16(:,25),heltab2x16(:,:,35))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(5),m0h(26),h0tab(:,26),[16,1,2,12],[nMW,0,nMZ,nMW],4,1,wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(5),ex5(:),G0H16(11),m3h1x16(:,26),heltab2x16(:,:,36))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(5),m0h(27),h0tab(:,27),[16,2,1,12],[nMW,0,nMZ,nMW],4,1,wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(5),0,ex5(:),16,G1H16(7),m3h1x16(:,27),heltab2x16(:,:,37))
  Gcoeff(:)%j = (-(c(11)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(5),m0h(28),h0tab(:,28),[16,2,1,12],[nMZ,0,nMW,nMZ],4,1,wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(5),ex5(:),G0H16(12),m3h1x16(:,28),heltab2x16(:,:,38))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(5),m0h(29),h0tab(:,29),[16,2,1,12],[nMW,0,nMZ,nMW],4,1,wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(5),ex5(:),G0H16(13),m3h1x16(:,29),heltab2x16(:,:,39))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(5),m0h(30),h0tab(:,30),[16,1,12,2],[nMZ,0,0,nMZ],4,1,wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(5),ex5(:),G0H16(14),m3h1x16(:,30),heltab2x16(:,:,40))
  call Hloop_SV_V(ntryL,G1H16(1),wf4(:,1),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,41))
  call Hloop_SV_V(ntryL,G1H16(2),wf4(:,1),G1H4(2),m3h4x4(:,2),heltab2x16(:,:,42))
  call Hloop_UW_V(ntryL,G0H16(4),16,wf4(:,1),3,G1H4(3),m3h4x4(:,3),heltab2x16(:,:,43))
  call Hloop_UV_W(ntryL,G0H16(6),16,wf4(:,1),3,G1H4(4),m3h4x4(:,4),heltab2x16(:,:,44))
  call Hloop_UV_W(ntryL,G0H16(8),16,wf4(:,1),3,G1H4(5),m3h4x4(:,5),heltab2x16(:,:,45))
  call Hloop_SV_V(ntryL,G1H16(3),wf4(:,1),G1H4(6),m3h4x4(:,6),heltab2x16(:,:,46))
  call Hloop_SV_V(ntryL,G1H16(4),wf4(:,1),G1H4(7),m3h4x4(:,7),heltab2x16(:,:,47))
  call Hloop_UW_V(ntryL,G0H16(1),16,wf4(:,1),3,G1H4(8),m3h4x4(:,8),heltab2x16(:,:,48))
  call Hloop_UV_W(ntryL,G0H16(3),16,wf4(:,1),3,G1H4(9),m3h4x4(:,9),heltab2x16(:,:,49))
  call Hloop_UV_W(ntryL,G0H16(7),16,wf4(:,1),3,G1H4(10),m3h4x4(:,10),heltab2x16(:,:,50))
  call Hloop_ZQ_A(ntryL,G0H16(10),ex3(:),G0H8(1),ngZu,m3h2x8(:,11),heltab2x16(:,:,51))
  call Hloop_Q_A(ntryL,G0H8(1),20,0,G1H8(1),n2h8(11))
  call Hloop_WA_Q(ntryL,G1H16(5),ex1(:),G1H8(2),m3h2x8(:,12),heltab2x16(:,:,52))
  call Hloop_A_Q(ntryL,G1H8(2),17,0,G2H8(1),n2h8(12))
  call Hloop_WA_Q(ntryL,G1H16(6),ex1(:),G1H8(3),m3h2x8(:,13),heltab2x16(:,:,53))
  call Hloop_A_Q(ntryL,G1H8(3),17,0,G2H8(2),n2h8(13))
  call Hloop_ZA_Q(ntryL,G0H16(9),ex1(:),G0H8(1),ngZn,m3h2x8(:,14),heltab2x16(:,:,54))
  call Hloop_A_Q(ntryL,G0H8(1),17,0,G1H8(4),n2h8(14))
  call Hloop_WA_Q(ntryL,G0H16(2),ex1(:),G0H8(1),m3h2x8(:,15),heltab2x16(:,:,55))
  call Hloop_A_Q(ntryL,G0H8(1),17,0,G1H8(5),n2h8(15))
  call Hloop_WA_Q(ntryL,G0H16(11),ex1(:),G0H8(1),m3h2x8(:,16),heltab2x16(:,:,56))
  call Hloop_A_Q(ntryL,G0H8(1),17,0,G1H8(6),n2h8(16))
  call Hloop_WQ_A(ntryL,G1H16(7),ex2(:),G1H8(7),m3h2x8(:,17),heltab2x16(:,:,57))
  call Hloop_Q_A(ntryL,G1H8(7),18,0,G2H8(3),n2h8(17))
  call Hloop_ZQ_A(ntryL,G0H16(12),ex2(:),G0H8(1),ngZl,m3h2x8(:,18),heltab2x16(:,:,58))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(8),n2h8(18))
  call Hloop_WQ_A(ntryL,G0H16(13),ex2(:),G0H8(1),m3h2x8(:,19),heltab2x16(:,:,59))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(9),n2h8(19))
  call Hloop_ZA_Q(ntryL,G0H16(14),ex1(:),G0H8(1),ngZn,m3h2x8(:,20),heltab2x16(:,:,60))
  call Hloop_A_Q(ntryL,G0H8(1),17,0,G1H8(10),n2h8(20))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(4),[G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(5),[G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(9),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G1H4(7)])
  call Hloop_VA_Q(ntryL,G1H4(4),ex4(:),G1H2(1),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(1),n2h2(11))
  call Hloop_ZA_Q(ntryL,G1H4(5),ex4(:),G1H2(1),ngZd,m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(2),n2h2(12))
  call Hloop_WA_Q(ntryL,G1H4(3),ex4(:),G1H2(1),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(3),n2h2(13))
  call Hloop_VQ_A(ntryL,G1H4(9),ex3(:),G1H2(1),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(4),n2h2(14))
  call Hloop_ZQ_A(ntryL,G1H4(10),ex3(:),G1H2(1),ngZu,m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(5),n2h2(15))
  call Hloop_WQ_A(ntryL,G1H4(8),ex3(:),G1H2(1),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(6),n2h2(16))
  call Hloop_QW_A(ntryL,G1H8(1),wf4(:,1),G1H2(1),m3h4x2(:,1),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(7),n2h2(17))
  call Hloop_AQ_V(ntryL,G2H8(1),ex2(:),G2H4(1),m3h2x4(:,11),heltab2x8(:,:,12))
  call Hloop_AQ_Z(ntryL,G2H8(2),ex2(:),G2H4(2),ngZl,m3h2x4(:,12),heltab2x8(:,:,13))
  call Hloop_AQ_W(ntryL,G1H8(4),ex2(:),G1H4(1),m3h2x4(:,13),heltab2x8(:,:,14))
  call Hloop_AQ_V(ntryL,G1H8(5),ex2(:),G1H4(2),m3h2x4(:,14),heltab2x8(:,:,15))
  call Hloop_AQ_Z(ntryL,G1H8(6),ex2(:),G1H4(6),ngZl,m3h2x4(:,15),heltab2x8(:,:,16))
  call Hloop_QA_Z(ntryL,G2H8(3),ex1(:),G2H4(3),ngZn,m3h2x4(:,16),heltab2x8(:,:,17))
  call Hloop_QA_W(ntryL,G1H8(8),ex1(:),G1H4(7),m3h2x4(:,17),heltab2x8(:,:,18))
  call Hloop_QA_Z(ntryL,G1H8(9),ex1(:),G1H4(4),ngZn,m3h2x4(:,18),heltab2x8(:,:,19))
  call Hloop_AW_Q(ntryL,G1H8(10),wf4(:,2),G1H2(1),m3h4x2(:,2),heltab2x8(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(1),29,0,G2H2(8),n2h2(18))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(1),ex3(:),G2tensor(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(2),ex3(:),G2tensor(2),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(3),ex3(:),G2tensor(3),ngZu,m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(4),ex4(:),G2tensor(4),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(5),ex4(:),G2tensor(5),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(6),ex4(:),G2tensor(6),ngZd,m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(7),ex4(:),G2tensor(7),ngZd,m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(1),wf4(:,2),G2tensor(8),m3h4x1(:,1),heltab2x4(:,:,17))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(2),wf4(:,2),G2tensor(9),m3h4x1(:,2),heltab2x4(:,:,18))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(1),19,wf4(:,2),12,G2tensor(10),m3h4x1(:,3),heltab2x4(:,:,19))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(2),19,wf4(:,2),12,G2tensor(11),m3h4x1(:,4),heltab2x4(:,:,20))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(6),19,wf4(:,2),12,G2tensor(12),m3h4x1(:,5),heltab2x4(:,:,21))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(3),wf4(:,2),G2tensor(13),m3h4x1(:,6),heltab2x4(:,:,22))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(7),19,wf4(:,2),12,G2tensor(14),m3h4x1(:,7),heltab2x4(:,:,23))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(4),19,wf4(:,2),12,G2tensor(15),m3h4x1(:,8),heltab2x4(:,:,24))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(8),ex2(:),G2tensor(16),ngZl,m3h2x1(:,18),heltab2x2(:,:,18))
  call ol_merge_tensors(G2tensor(6),[G1tensor(28),G1tensor(4)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(18),G1tensor(6)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(40),G1tensor(10)])
  call ol_merge_tensors(G2tensor(15),[G2tensor(13),G1tensor(24),G1tensor(12)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(46),G1tensor(16)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(58),G1tensor(22)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(48),G1tensor(30)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(34)])
  call ol_merge_tensors(G1tensor(41),[G1tensor(35)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(8),G1tensor(54),G1tensor(36)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(9),G1tensor(60),G1tensor(42)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(52)])
  call ol_merge_tensors(G1tensor(59),[G1tensor(53)])
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(2),mass4set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25))
  call G_TensorShift(G1tensor(7),8)
  call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(4),mass4set(:,2),  & 
G1tensor(31),G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55))
  call G_TensorShift(G1tensor(37),12)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(2),mass4set(:,3),  & 
G1tensor(28),G1tensor(4),G1tensor(18),G1tensor(6),G1tensor(40))
  call G_TensorShift(G1tensor(4),8)
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(4),mass4set(:,4),  & 
G1tensor(10),G1tensor(24),G1tensor(12),G1tensor(46),G1tensor(16))
  call G_TensorShift(G1tensor(24),12)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(7),mass4set(:,1),  & 
G1tensor(58),G1tensor(22),G1tensor(48),G1tensor(30),G1tensor(34))
  call G_TensorShift(G1tensor(22),4)
  call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(7),mass4set(:,3),  & 
G1tensor(35),G1tensor(54),G1tensor(36),G1tensor(60),G1tensor(42))
  call G_TensorShift(G1tensor(54),4)
  call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(12),mass4set(:,2),  & 
G1tensor(52),G1tensor(53),G1tensor(61),G1tensor(62),G1tensor(63))
  call G_TensorShift(G1tensor(53),12)
  call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(2),mass4set(:,5),  & 
G1tensor(64),G1tensor(65),G1tensor(66),G1tensor(67),G1tensor(68))
  call G_TensorShift(G1tensor(65),8)
  call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(12),mass4set(:,5),  & 
G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72),G1tensor(73))
  call G_TensorShift(G1tensor(70),12)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(12),mass4set(:,4),  & 
G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
  call G_TensorShift(G1tensor(75),12)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(7),mass4set(:,5),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83))
  call G_TensorShift(G1tensor(80),4)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(17),mass4set(:,6),  & 
G1tensor(84),G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88))
  call G_TensorShift(G1tensor(85),8)
  call Hotf_4pt_reduction_last(G2tensor(16),RedSet_4(18),mass4set(:,6),  & 
G1tensor(89),G1tensor(90),G1tensor(91),G1tensor(92),G1tensor(93))
  call G_TensorShift(G1tensor(90),2)
  call Hotf_4pt_reduction_last(G1tensor(2),RedSet_4(19),mass4set(:,7),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(3),RedSet_4(1),mass4set(:,8),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(2),mass4set(:,1),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(5),RedSet_4(3),mass4set(:,6),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(4),mass4set(:,2),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(8),RedSet_4(19),mass4set(:,9),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(9),RedSet_4(1),mass4set(:,10),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(28),RedSet_4(2),mass4set(:,3),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(3),mass4set(:,5),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(10),RedSet_4(4),mass4set(:,4),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(14),RedSet_4(20),mass4set(:,7),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(15),RedSet_4(6),mass4set(:,8),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(58),RedSet_4(7),mass4set(:,1),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(17),RedSet_4(8),mass4set(:,6),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(20),RedSet_4(20),mass4set(:,9),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(6),mass4set(:,10),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(35),RedSet_4(7),mass4set(:,3),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(23),RedSet_4(8),mass4set(:,5),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(21),mass4set(:,7),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(27),RedSet_4(10),mass4set(:,8),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(29),RedSet_4(11),mass4set(:,6),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(52),RedSet_4(12),mass4set(:,2),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(32),RedSet_4(21),mass4set(:,11),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call Hotf_4pt_reduction_last(G1tensor(33),RedSet_4(10),mass4set(:,12),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
  call Hotf_4pt_reduction_last(G1tensor(64),RedSet_4(2),mass4set(:,5),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(11),mass4set(:,5),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
  call Hotf_4pt_reduction_last(G1tensor(69),RedSet_4(12),mass4set(:,5),  & 
G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135))
  call Hotf_4pt_reduction_last(G1tensor(38),RedSet_4(21),mass4set(:,9),  & 
G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140))
  call Hotf_4pt_reduction_last(G1tensor(39),RedSet_4(10),mass4set(:,10),  & 
G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144),G0tensor(145))
  call Hotf_4pt_reduction_last(G1tensor(74),RedSet_4(12),mass4set(:,4),  & 
G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149),G0tensor(150))
  call Hotf_4pt_reduction_last(G1tensor(44),RedSet_4(22),mass4set(:,7),  & 
G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154),G0tensor(155))
  call Hotf_4pt_reduction_last(G1tensor(45),RedSet_4(14),mass4set(:,8),  & 
G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159),G0tensor(160))
  call Hotf_4pt_reduction_last(G1tensor(47),RedSet_4(15),mass4set(:,6),  & 
G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164),G0tensor(165))
  call Hotf_4pt_reduction_last(G1tensor(50),RedSet_4(22),mass4set(:,11),  & 
G0tensor(166),G0tensor(167),G0tensor(168),G0tensor(169),G0tensor(170))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(14),mass4set(:,12),  & 
G0tensor(171),G0tensor(172),G0tensor(173),G0tensor(174),G0tensor(175))
  call Hotf_4pt_reduction_last(G1tensor(79),RedSet_4(7),mass4set(:,5),  & 
G0tensor(176),G0tensor(177),G0tensor(178),G0tensor(179),G0tensor(180))
  call Hotf_4pt_reduction_last(G1tensor(59),RedSet_4(15),mass4set(:,5),  & 
G0tensor(181),G0tensor(182),G0tensor(183),G0tensor(184),G0tensor(185))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(22),mass4set(:,9),  & 
G0tensor(186),G0tensor(187),G0tensor(188),G0tensor(189),G0tensor(190))
  call Hotf_4pt_reduction_last(G1tensor(57),RedSet_4(14),mass4set(:,10),  & 
G0tensor(191),G0tensor(192),G0tensor(193),G0tensor(194),G0tensor(195))
  call Hotf_4pt_reduction_last(G1tensor(84),RedSet_4(17),mass4set(:,6),  & 
G0tensor(196),G0tensor(197),G0tensor(198),G0tensor(199),G0tensor(200))
  call Hotf_4pt_reduction_last(G1tensor(89),RedSet_4(18),mass4set(:,6),  & 
G0tensor(201),G0tensor(202),G0tensor(203),G0tensor(204),G0tensor(205))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  call ol_merge_tensors(T0sum(21),[G0tensor(101)])
  call ol_merge_tensors(T0sum(22),[G0tensor(106)])
  call ol_merge_tensors(T0sum(23),[G0tensor(111)])
  call ol_merge_tensors(T0sum(24),[G0tensor(116)])
  call ol_merge_tensors(T0sum(25),[G0tensor(121)])
  call ol_merge_tensors(T0sum(26),[G0tensor(126)])
  call ol_merge_tensors(T0sum(27),[G0tensor(131)])
  call ol_merge_tensors(T0sum(28),[G0tensor(136)])
  call ol_merge_tensors(T0sum(29),[G0tensor(141)])
  call ol_merge_tensors(T0sum(30),[G0tensor(146)])
  call ol_merge_tensors(T0sum(31),[G0tensor(151)])
  call ol_merge_tensors(T0sum(32),[G0tensor(156)])
  call ol_merge_tensors(T0sum(33),[G0tensor(161)])
  call ol_merge_tensors(T0sum(34),[G0tensor(166)])
  call ol_merge_tensors(T0sum(35),[G0tensor(171)])
  call ol_merge_tensors(T0sum(36),[G0tensor(176)])
  call ol_merge_tensors(T0sum(37),[G0tensor(181)])
  call ol_merge_tensors(T0sum(38),[G0tensor(186)])
  call ol_merge_tensors(T0sum(39),[G0tensor(191)])
  call ol_merge_tensors(T0sum(40),[G0tensor(196)])
  call ol_merge_tensors(T0sum(41),[G0tensor(201)])
  Gcoeff(:)%j = (c(34)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(5),m0h(31),h0tab(:,31),[16,3,12],[nMM,0,nMM],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(5),ex5(:),G0H16(4),ngH,m3h1x16(:,31),heltab2x16(:,:,61))
  call Hloop_A_Q(ntryL,G0H16(4),16,nMM,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (c(33)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(6),m0h(32),h0tab(:,32),[16,3,12],[nML,0,nML],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(6),ex5(:),G0H16(8),ngH,m3h1x16(:,32),heltab2x16(:,:,62))
  call Hloop_A_Q(ntryL,G0H16(8),16,nML,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (c(35)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(33),h0tab(:,33),[16,3,12],[nMT,nMB,nMT],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H16(1),ex5(:),G0H16(3),ngH,m3h1x16(:,33),heltab2x16(:,:,63))
  call Hloop_Q_A(ntryL,G0H16(3),16,nMT,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (c(32)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(34),h0tab(:,34),[16,3,12],[nMB,nMT,nMB],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(7),ex5(:),G0H16(10),ngH,m3h1x16(:,34),heltab2x16(:,:,64))
  call Hloop_A_Q(ntryL,G0H16(10),16,nMB,G1H16(4),n2h16(4))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(9),m0h(35),h0tab(:,35),[16,3,12],[nMH,nMW,nMH],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(9),ex5(:),G0H16(2),m3h1x16(:,35),heltab2x16(:,:,65))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(11),m0h(36),h0tab(:,36),[16,3,12],[nMZ,nMW,nMZ],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(11),ex5(:),G0H16(12),m3h1x16(:,36),heltab2x16(:,:,66))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(13),m0h(37),h0tab(:,37),[16,3,12],[nMW,nMH,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(13),ex5(:),G0H16(14),m3h1x16(:,37),heltab2x16(:,:,67))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(5),m0h(38),h0tab(:,38),[16,3,12],[nMW,nMZ,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(5),ex5(:),G0H16(4),m3h1x16(:,38),heltab2x16(:,:,68))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(6),m0h(39),h0tab(:,39),[16,3,12],[nMZ,nMW,nMZ],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(6),ex5(:),G0H16(8),m3h1x16(:,39),heltab2x16(:,:,69))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(40),h0tab(:,40),[16,3,12],[nMW,0,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(3),m3h1x16(:,40),heltab2x16(:,:,70))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(41),h0tab(:,41),[16,3,12],[nMW,nMZ,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(7),ex5(:),G0H16(10),m3h1x16(:,41),heltab2x16(:,:,71))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(9),m0h(42),h0tab(:,42),[16,3,12],[nMZ,nMW,nMZ],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(9),ex5(:),G0H16(11),m3h1x16(:,42),heltab2x16(:,:,72))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(13),m0h(43),h0tab(:,43),[16,3,12],[nMW,0,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(13),ex5(:),G0H16(5),m3h1x16(:,43),heltab2x16(:,:,73))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(6),m0h(44),h0tab(:,44),[16,3,12],[nMW,nMZ,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(6),ex5(:),G0H16(1),m3h1x16(:,44),heltab2x16(:,:,74))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(45),h0tab(:,45),[16,3,12],[nMZ,nMW,nMZ],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(9),m3h1x16(:,45),heltab2x16(:,:,75))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(13),m0h(46),h0tab(:,46),[16,3,12],[nMW,0,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(13),ex5(:),G0H16(6),m3h1x16(:,46),heltab2x16(:,:,76))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(47),h0tab(:,47),[16,3,12],[nMW,nMZ,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(13),m3h1x16(:,47),heltab2x16(:,:,77))
  Gcoeff(:)%j = (c(22)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(48),h0tab(:,48),[16,3,12],[nMW,0,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(7),ex5(:),G0H16(15),m3h1x16(:,48),heltab2x16(:,:,78))
  Gcoeff(:)%j = (c(26)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(49),h0tab(:,49),[16,3,12],[nMW,nMZ,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(7),ex5(:),G0H16(16),m3h1x16(:,49),heltab2x16(:,:,79))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(50),h0tab(:,50),[16,3,12],[nMH,nMW,nMH],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(7),ex5(:),G0H16(17),m3h1x16(:,50),heltab2x16(:,:,80))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(51),h0tab(:,51),[16,3,12],[nMZ,nMW,nMZ],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(7),0,ex5(:),16,G1H16(5),m3h1x16(:,51),heltab2x16(:,:,81))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(52),h0tab(:,52),[16,3,12],[nMW,nMH,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(7),0,ex5(:),16,G1H16(6),m3h1x16(:,52),heltab2x16(:,:,82))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(53),h0tab(:,53),[16,3,12],[nMZ,nMW,nMZ],3,2,wf4(:,1),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(7),0,ex5(:),16,G1H16(7),m3h1x16(:,53),heltab2x16(:,:,83))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(54),h0tab(:,54),[16,3,12],[nMW,nMH,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(7),0,ex5(:),16,G1H16(8),m3h1x16(:,54),heltab2x16(:,:,84))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(55),h0tab(:,55),[16,3,12],[nMW,0,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(7),0,ex5(:),16,G1H16(9),m3h1x16(:,55),heltab2x16(:,:,85))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(56),h0tab(:,56),[16,3,12],[nMW,nMZ,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(7),0,ex5(:),16,G1H16(10),m3h1x16(:,56),heltab2x16(:,:,86))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(57),h0tab(:,57),[16,3,12],[nMW,0,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(7),0,ex5(:),16,G1H16(11),m3h1x16(:,57),heltab2x16(:,:,87))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(58),h0tab(:,58),[16,3,12],[nMW,nMZ,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(7),0,ex5(:),16,G1H16(12),m3h1x16(:,58),heltab2x16(:,:,88))
  Gcoeff(:)%j = (c(27)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(59),h0tab(:,59),[16,3,12],[nMZ,nMW,nMZ],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(18),m3h1x16(:,59),heltab2x16(:,:,89))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(60),h0tab(:,60),[16,3,12],[nMW,nMH,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(19),m3h1x16(:,60),heltab2x16(:,:,90))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(61),h0tab(:,61),[16,7,8],[nMZ,0,nMZ],3,1,wf8(:,2))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(20),m3h1x16(:,61),heltab2x16(:,:,91))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(62),h0tab(:,62),[16,7,8],[nMW,0,nMW],3,1,wf8(:,2))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(21),m3h1x16(:,62),heltab2x16(:,:,92))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(63),h0tab(:,63),[16,4,11],[nMZ,0,nMZ],3,1,wf8(:,4))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(22),m3h1x16(:,63),heltab2x16(:,:,93))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(64),h0tab(:,64),[16,4,11],[nMW,0,nMW],3,1,wf8(:,4))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(23),m3h1x16(:,64),heltab2x16(:,:,94))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(65),h0tab(:,65),[19,4,8],[0,0,nMW],3,1,wf4(:,6))
  call Hloop_VS_V(ntryL,G0H16(7),wf4(:,6),G0H4(1),m3h4x4(:,11),heltab2x16(:,:,95))
  Gcoeff(:)%j = (c(13)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(66),h0tab(:,66),[19,4,8],[nMW,0,0],3,1,wf4(:,6))
  call Hloop_VS_V(ntryL,G0H16(7),wf4(:,6),G0H4(2),m3h4x4(:,12),heltab2x16(:,:,96))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(67),h0tab(:,67),[19,4,8],[nMZ,0,nMW],3,1,wf4(:,6))
  call Hloop_VS_V(ntryL,G0H16(7),wf4(:,6),G0H4(3),m3h4x4(:,13),heltab2x16(:,:,97))
  Gcoeff(:)%j = (c(24)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(68),h0tab(:,68),[19,4,8],[nMW,0,nMZ],3,1,wf4(:,6))
  call Hloop_VS_V(ntryL,G0H16(7),wf4(:,6),G0H4(4),m3h4x4(:,14),heltab2x16(:,:,98))
  Gcoeff(:)%j = (c(14)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(69),h0tab(:,69),[19,4,8],[0,0,0],3,1,wf4(:,3))
  call Hloop_AW_Q(ntryL,G0H16(7),wf4(:,3),G0H4(5),m3h4x4(:,15),heltab2x16(:,:,99))
  call Hloop_A_Q(ntryL,G0H4(5),19,0,G1H4(5),n2h4(1))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(70),h0tab(:,70),[19,4,8],[0,nMZ,0],3,1,wf4(:,3))
  call Hloop_AW_Q(ntryL,G0H16(7),wf4(:,3),G0H4(5),m3h4x4(:,16),heltab2x16(:,:,100))
  call Hloop_A_Q(ntryL,G0H4(5),19,0,G1H4(3),n2h4(2))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(71),h0tab(:,71),[19,4,8],[0,0,0],3,1,wf4(:,3))
  call Hloop_AW_Q(ntryL,G0H16(7),wf4(:,3),G0H4(5),m3h4x4(:,17),heltab2x16(:,:,101))
  call Hloop_A_Q(ntryL,G0H4(5),19,0,G1H4(9),n2h4(3))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(72),h0tab(:,72),[19,4,8],[0,0,nMW],3,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H16(7),0,wf4(:,3),19,G1H4(10),m3h4x4(:,18),heltab2x16(:,:,102))
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(73),h0tab(:,73),[19,4,8],[nMW,0,0],3,1,wf4(:,3))
  call Hloop_UW_V(ntryL,G0H16(7),0,wf4(:,3),19,G1H4(8),m3h4x4(:,19),heltab2x16(:,:,103))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(74),h0tab(:,74),[19,4,8],[nMZ,0,nMW],3,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H16(7),0,wf4(:,3),19,G1H4(1),m3h4x4(:,20),heltab2x16(:,:,104))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(75),h0tab(:,75),[19,4,8],[nMW,0,nMZ],3,1,wf4(:,3))
  call Hloop_UW_V(ntryL,G0H16(7),0,wf4(:,3),19,G1H4(2),m3h4x4(:,21),heltab2x16(:,:,105))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(76),h0tab(:,76),[16,2,13],[nMZ,0,nMZ],3,1,wf8(:,6))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(24),m3h1x16(:,65),heltab2x16(:,:,106))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(77),h0tab(:,77),[16,2,13],[nMW,0,nMW],3,1,wf8(:,6))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(25),m3h1x16(:,66),heltab2x16(:,:,107))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(78),h0tab(:,78),[16,1,14],[nMZ,0,nMZ],3,1,wf8(:,8))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(26),m3h1x16(:,67),heltab2x16(:,:,108))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(17)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(79),h0tab(:,79),[16,1,14],[nMW,0,nMW],3,1,wf8(:,8))
  call Hloop_VS_V(ntryL,G0H16(7),ex5(:),G0H16(27),m3h1x16(:,68),heltab2x16(:,:,109))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(80),h0tab(:,80),[28,1,2],[nMW,0,0],3,1,wf4(:,10))
  call Hloop_VS_V(ntryL,G0H16(7),wf4(:,10),G0H4(5),m3h4x4(:,22),heltab2x16(:,:,110))
  Gcoeff(:)%j = (-(c(24)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(81),h0tab(:,81),[28,1,2],[nMZ,0,nMW],3,1,wf4(:,10))
  call Hloop_VS_V(ntryL,G0H16(7),wf4(:,10),G0H4(6),m3h4x4(:,23),heltab2x16(:,:,111))
  Gcoeff(:)%j = (-(c(24)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(82),h0tab(:,82),[28,1,2],[nMW,0,nMZ],3,1,wf4(:,10))
  call Hloop_VS_V(ntryL,G0H16(7),wf4(:,10),G0H4(7),m3h4x4(:,24),heltab2x16(:,:,112))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(83),h0tab(:,83),[28,1,2],[0,nMZ,0],3,1,wf4(:,12))
  call Hloop_QW_A(ntryL,G0H16(7),wf4(:,12),G0H4(8),m3h4x4(:,25),heltab2x16(:,:,113))
  call Hloop_Q_A(ntryL,G0H4(8),28,0,G1H4(6),n2h4(4))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(84),h0tab(:,84),[28,1,2],[nMW,0,0],3,1,wf4(:,12))
  call Hloop_UV_W(ntryL,G0H16(7),0,wf4(:,12),28,G1H4(7),m3h4x4(:,26),heltab2x16(:,:,114))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(85),h0tab(:,85),[28,1,2],[nMZ,0,nMW],3,1,wf4(:,12))
  call Hloop_UW_V(ntryL,G0H16(7),0,wf4(:,12),28,G1H4(4),m3h4x4(:,27),heltab2x16(:,:,115))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(86),h0tab(:,86),[28,1,2],[nMW,0,nMZ],3,1,wf4(:,12))
  call Hloop_UV_W(ntryL,G0H16(7),0,wf4(:,12),28,G1H4(11),m3h4x4(:,28),heltab2x16(:,:,116))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(1),[G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(9),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(4),[G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G0H4(7)])
  call Hloop_AW_Q(ntryL,G1H16(1),wf4(:,1),G1H4(5),m3h4x4(:,29),heltab2x16(:,:,117))
  call Hloop_A_Q(ntryL,G1H4(5),19,0,G2H4(1),n2h4(5))
  call Hloop_AW_Q(ntryL,G1H16(2),wf4(:,1),G1H4(5),m3h4x4(:,30),heltab2x16(:,:,118))
  call Hloop_A_Q(ntryL,G1H4(5),19,0,G2H4(2),n2h4(6))
  call Hloop_QW_A(ntryL,G1H16(3),wf4(:,1),G1H4(5),m3h4x4(:,31),heltab2x16(:,:,119))
  call Hloop_Q_A(ntryL,G1H4(5),19,nMB,G2H4(3),n2h4(7))
  call Hloop_AW_Q(ntryL,G1H16(4),wf4(:,1),G1H4(5),m3h4x4(:,32),heltab2x16(:,:,120))
  call Hloop_A_Q(ntryL,G1H4(5),19,nMT,G2H4(4),n2h4(8))
  call Hloop_TV_S(ntryL,G0H16(2),16,wf4(:,1),3,G1H4(5),m3h4x4(:,33),heltab2x16(:,:,121))
  call Hloop_TV_S(ntryL,G0H16(12),16,wf4(:,1),3,G1H4(12),m3h4x4(:,34),heltab2x16(:,:,122))
  call Hloop_SV_T(ntryL,G0H16(14),16,wf4(:,1),3,G1H4(13),m3h4x4(:,35),heltab2x16(:,:,123))
  call Hloop_SV_T(ntryL,G0H16(4),16,wf4(:,1),3,G1H4(14),m3h4x4(:,36),heltab2x16(:,:,124))
  call Hloop_CV_D(ntryL,G0H16(8),16,wf4(:,1),3,G1H4(15),m3h4x4(:,37),heltab2x16(:,:,125))
  call Hloop_DV_C(ntryL,G0H16(3),16,wf4(:,1),G1H4(16),m3h4x4(:,38),heltab2x16(:,:,126))
  call Hloop_DV_C(ntryL,G0H16(10),16,wf4(:,1),G1H4(17),m3h4x4(:,39),heltab2x16(:,:,127))
  call Hloop_DV_C(ntryL,G0H16(11),16,wf4(:,1),G1H4(18),m3h4x4(:,40),heltab2x16(:,:,128))
  call Hloop_CV_D(ntryL,G0H16(5),16,wf4(:,1),3,G1H4(19),m3h4x4(:,41),heltab2x16(:,:,129))
  call Hloop_CV_D(ntryL,G0H16(1),16,wf4(:,1),3,G1H4(20),m3h4x4(:,42),heltab2x16(:,:,130))
  call Hloop_UW_V(ntryL,G0H16(9),16,wf4(:,1),3,G1H4(21),m3h4x4(:,43),heltab2x16(:,:,131))
  call Hloop_UV_W(ntryL,G0H16(6),16,wf4(:,1),3,G1H4(22),m3h4x4(:,44),heltab2x16(:,:,132))
  call Hloop_UV_W(ntryL,G0H16(13),16,wf4(:,1),3,G1H4(23),m3h4x4(:,45),heltab2x16(:,:,133))
  call Hloop_SV_V(ntryL,G0H16(15),wf4(:,1),G0H4(8),m3h4x4(:,46),heltab2x16(:,:,134))
  call Hloop_SV_V(ntryL,G0H16(16),wf4(:,1),G0H4(1),m3h4x4(:,47),heltab2x16(:,:,135))
  call Hloop_SV_V(ntryL,G0H16(17),wf4(:,1),G0H4(2),m3h4x4(:,48),heltab2x16(:,:,136))
  call Hloop_TV_S(ntryL,G1H16(5),16,wf4(:,1),3,G2H4(5),m3h4x4(:,49),heltab2x16(:,:,137))
  call Hloop_SV_T(ntryL,G1H16(6),16,wf4(:,1),3,G2H4(6),m3h4x4(:,50),heltab2x16(:,:,138))
  call Hloop_VV_S(ntryL,G1H16(7),wf4(:,1),G1H4(24),m3h4x4(:,51),heltab2x16(:,:,139))
  call Hloop_VV_S(ntryL,G1H16(8),wf4(:,1),G1H4(25),m3h4x4(:,52),heltab2x16(:,:,140))
  call Hloop_SV_V(ntryL,G1H16(9),wf4(:,1),G1H4(26),m3h4x4(:,53),heltab2x16(:,:,141))
  call Hloop_SV_V(ntryL,G1H16(10),wf4(:,1),G1H4(27),m3h4x4(:,54),heltab2x16(:,:,142))
  call Hloop_UV_W(ntryL,G1H16(11),16,wf4(:,1),3,G2H4(7),m3h4x4(:,55),heltab2x16(:,:,143))
  call Hloop_UV_W(ntryL,G1H16(12),16,wf4(:,1),3,G2H4(8),m3h4x4(:,56),heltab2x16(:,:,144))
  call Hloop_VV_S(ntryL,G0H16(18),wf4(:,1),G0H4(3),m3h4x4(:,57),heltab2x16(:,:,145))
  call Hloop_VV_S(ntryL,G0H16(19),wf4(:,1),G0H4(4),m3h4x4(:,58),heltab2x16(:,:,146))
  call Hloop_ZQ_A(ntryL,G0H16(20),wf8(:,2),G0H2(1),ngZd,m3h8x2(:,1),heltab2x16(:,:,147))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(1),n2h2(19))
  call Hloop_WQ_A(ntryL,G0H16(21),wf8(:,2),G0H2(1),m3h8x2(:,2),heltab2x16(:,:,148))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(2),n2h2(20))
  call Hloop_ZQ_A(ntryL,G0H16(22),ex3(:),G0H8(1),ngZu,m3h2x8(:,21),heltab2x16(:,:,149))
  call Hloop_Q_A(ntryL,G0H8(1),20,0,G1H8(2),n2h8(21))
  call Hloop_WQ_A(ntryL,G0H16(23),ex3(:),G0H8(1),m3h2x8(:,22),heltab2x16(:,:,150))
  call Hloop_Q_A(ntryL,G0H8(1),20,0,G1H8(3),n2h8(22))
  call Hloop_VQ_A(ntryL,G1H4(10),ex3(:),G1H2(3),m3h2x2(:,17),heltab2x4(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(9),n2h2(21))
  call Hloop_WQ_A(ntryL,G1H4(8),ex3(:),G1H2(3),m3h2x2(:,18),heltab2x4(:,:,26))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(10),n2h2(22))
  call Hloop_ZQ_A(ntryL,G1H4(1),ex3(:),G1H2(3),ngZu,m3h2x2(:,19),heltab2x4(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(1),n2h2(23))
  call Hloop_WQ_A(ntryL,G1H4(2),ex3(:),G1H2(3),m3h2x2(:,20),heltab2x4(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(3),23,0,G2H2(2),n2h2(24))
  call Hloop_AQ_V(ntryL,G1H4(9),ex3(:),G1H2(3),m3h2x2(:,21),heltab2x4(:,:,29))
  call Hloop_AQ_Z(ntryL,G1H4(3),ex3(:),G1H2(4),ngZu,m3h2x2(:,22),heltab2x4(:,:,30))
  call Hloop_ZQ_A(ntryL,G0H16(24),ex2(:),G0H8(1),ngZl,m3h2x8(:,23),heltab2x16(:,:,151))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(7),n2h8(23))
  call Hloop_WQ_A(ntryL,G0H16(25),ex2(:),G0H8(1),m3h2x8(:,24),heltab2x16(:,:,152))
  call Hloop_Q_A(ntryL,G0H8(1),18,0,G1H8(1),n2h8(24))
  call Hloop_ZA_Q(ntryL,G0H16(26),ex1(:),G0H8(1),ngZn,m3h2x8(:,25),heltab2x16(:,:,153))
  call Hloop_A_Q(ntryL,G0H8(1),17,0,G1H8(4),n2h8(25))
  call Hloop_WA_Q(ntryL,G0H16(27),ex1(:),G0H8(1),m3h2x8(:,26),heltab2x16(:,:,154))
  call Hloop_A_Q(ntryL,G0H8(1),17,0,G1H8(5),n2h8(26))
  call Hloop_WA_Q(ntryL,G1H4(7),ex1(:),G1H2(5),m3h2x2(:,23),heltab2x4(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(5),29,0,G2H2(3),n2h2(25))
  call Hloop_ZA_Q(ntryL,G1H4(4),ex1(:),G1H2(5),ngZn,m3h2x2(:,24),heltab2x4(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(5),29,0,G2H2(4),n2h2(26))
  call Hloop_WA_Q(ntryL,G1H4(11),ex1(:),G1H2(5),m3h2x2(:,25),heltab2x4(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(5),29,0,G2H2(5),n2h2(27))
  call Hloop_QA_Z(ntryL,G1H4(6),ex1(:),G1H2(5),ngZn,m3h2x2(:,26),heltab2x4(:,:,34))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G1H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(26),[G1H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(27),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(7),[G0H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(8),[G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(5),[G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(6),[G0H4(4)])
  call Hloop_AW_Q(ntryL,G2H4(1),wf4(:,2),G2H1(1),m3h4x1(:,9),heltab2x4(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(1),n2h1(1))
  call Hloop_AW_Q(ntryL,G2H4(2),wf4(:,2),G2H1(1),m3h4x1(:,10),heltab2x4(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(2),n2h1(2))
  call Hloop_QW_A(ntryL,G2H4(3),wf4(:,2),G2H1(1),m3h4x1(:,11),heltab2x4(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(3),n2h1(3))
  call Hloop_AW_Q(ntryL,G2H4(4),wf4(:,2),G2H1(1),m3h4x1(:,12),heltab2x4(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(4),n2h1(4))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(5),19,wf4(:,2),12,G2tensor(13),m3h4x1(:,13),heltab2x4(:,:,39))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(24),19,wf4(:,2),12,G2tensor(8),m3h4x1(:,14),heltab2x4(:,:,40))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(25),19,wf4(:,2),12,G2tensor(9),m3h4x1(:,15),heltab2x4(:,:,41))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(14),19,wf4(:,2),12,G2tensor(6),m3h4x1(:,16),heltab2x4(:,:,42))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(15),19,wf4(:,2),12,G2tensor(14),m3h4x1(:,17),heltab2x4(:,:,43))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(16),19,wf4(:,2),G2tensor(5),m3h4x1(:,18),heltab2x4(:,:,44))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(17),19,wf4(:,2),G2tensor(15),m3h4x1(:,19),heltab2x4(:,:,45))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(18),19,wf4(:,2),G2tensor(3),m3h4x1(:,20),heltab2x4(:,:,46))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(19),19,wf4(:,2),12,G2tensor(2),m3h4x1(:,21),heltab2x4(:,:,47))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(20),19,wf4(:,2),12,G2tensor(10),m3h4x1(:,22),heltab2x4(:,:,48))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(21),19,wf4(:,2),12,G2tensor(4),m3h4x1(:,23),heltab2x4(:,:,49))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(26),19,wf4(:,2),12,G2tensor(11),m3h4x1(:,24),heltab2x4(:,:,50))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(27),19,wf4(:,2),12,G2tensor(12),m3h4x1(:,25),heltab2x4(:,:,51))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(7),wf4(:,2),G2tensor(1),m3h4x1(:,26),heltab2x4(:,:,52))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(8),wf4(:,2),G2tensor(7),m3h4x1(:,27),heltab2x4(:,:,53))
  call Hcheck_last_VV_S(ntryL,l_switch,G0H4(2),wf4(:,2),G0tensor(1),m3h4x1(:,28),heltab2x4(:,:,54))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H4(5),wf4(:,2),G2tensor(16),m3h4x1(:,29),heltab2x4(:,:,55))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H4(6),wf4(:,2),G2tensor(17),m3h4x1(:,30),heltab2x4(:,:,56))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H2(1),ex4(:),G1tensor(2),ngZd,m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H2(2),ex4(:),G1tensor(3),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H8(2),wf8(:,4),G1tensor(1),ngZu,m3h8x1(:,1),heltab2x8(:,:,21))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H8(3),wf8(:,4),G1tensor(5),m3h8x1(:,2),heltab2x8(:,:,22))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(9),ex4(:),G2tensor(18),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(10),ex4(:),G2tensor(19),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(20),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(2),ex4(:),G2tensor(21),ngZd,m3h2x1(:,24),heltab2x2(:,:,24))
  call Hloop_VA_Q(ntryL,G1H2(3),ex4(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(22),n2h1(5))
  call Hloop_ZA_Q(ntryL,G1H2(4),ex4(:),G1H1(1),ngZd,m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(23),n2h1(6))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H8(7),wf8(:,6),G1tensor(31),ngZl,m3h8x1(:,3),heltab2x8(:,:,23))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H8(1),wf8(:,6),G1tensor(8),m3h8x1(:,4),heltab2x8(:,:,24))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(4),wf8(:,8),G1tensor(9),ngZn,m3h8x1(:,5),heltab2x8(:,:,25))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(5),wf8(:,8),G1tensor(28),m3h8x1(:,6),heltab2x8(:,:,26))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(3),ex2(:),G2tensor(24),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(4),ex2(:),G2tensor(25),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(5),ex2(:),G2tensor(26),ngZl,m3h2x1(:,29),heltab2x2(:,:,29))
  call Hloop_ZQ_A(ntryL,G1H2(5),ex2(:),G1H1(1),ngZl,m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(27),n2h1(7))
  call ol_merge_tensors(G1tensor(7),[G0tensor(94),G0tensor(12),G0tensor(4)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(13),G0tensor(98),G0tensor(13),G0tensor(8)])
  call ol_merge_tensors(G1tensor(2),[G1tensor(87),G1tensor(19),G0tensor(199),G0tensor(104),G0tensor(19),G0tensor(14)])
  call ol_merge_tensors(G2tensor(16),[G2tensor(4),G2tensor(3),G2tensor(14),G2tensor(8),G1tensor(62),G1tensor(34),G1tensor(49) &
    ,G1tensor(25),G0tensor(109),G0tensor(65),G0tensor(24),G0tensor(15)])
  call ol_merge_tensors(G1tensor(37),[G0tensor(52),G0tensor(22),G0tensor(2)])
  call ol_merge_tensors(G1tensor(43),[G0tensor(60),G0tensor(23),G0tensor(10)])
  call ol_merge_tensors(G1tensor(31),[G1tensor(55),G0tensor(70),G0tensor(25),G0tensor(20)])
  call ol_merge_tensors(G1tensor(4),[G0tensor(139),G0tensor(37),G0tensor(29)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(18),G0tensor(143),G0tensor(38),G0tensor(33)])
  call ol_merge_tensors(G1tensor(3),[G1tensor(67),G1tensor(6),G0tensor(129),G0tensor(124),G0tensor(44),G0tensor(39)])
  call ol_merge_tensors(G2tensor(7),[G2tensor(12),G2tensor(10),G2tensor(15),G2tensor(6),G1tensor(77),G1tensor(42),G1tensor(46) &
    ,G1tensor(40),G0tensor(149),G0tensor(85),G0tensor(49),G0tensor(40)])
  call ol_merge_tensors(G1tensor(24),[G0tensor(72),G0tensor(47),G0tensor(27)])
  call ol_merge_tensors(G1tensor(12),[G0tensor(80),G0tensor(48),G0tensor(35)])
  call ol_merge_tensors(G1tensor(8),[G1tensor(16),G0tensor(90),G0tensor(50),G0tensor(45)])
  call ol_merge_tensors(G1tensor(22),[G0tensor(154),G0tensor(62),G0tensor(54)])
  call ol_merge_tensors(G1tensor(48),[G0tensor(158),G0tensor(63),G0tensor(58)])
  call ol_merge_tensors(G1tensor(30),[G0tensor(164),G0tensor(69),G0tensor(64)])
  call ol_merge_tensors(G1tensor(54),[G0tensor(189),G0tensor(82),G0tensor(74)])
  call ol_merge_tensors(G1tensor(36),[G0tensor(193),G0tensor(83),G0tensor(78)])
  call ol_merge_tensors(G1tensor(82),[G1tensor(60),G0tensor(184),G0tensor(179),G0tensor(89),G0tensor(84)])
  call ol_merge_tensors(G2tensor(25),[G1tensor(53),G0tensor(152),G0tensor(107),G0tensor(92)])
  call ol_merge_tensors(G1tensor(61),[G0tensor(160),G0tensor(108),G0tensor(100)])
  call ol_merge_tensors(G1tensor(9),[G1tensor(93),G1tensor(63),G0tensor(205),G0tensor(165),G0tensor(110),G0tensor(105)])
  call ol_merge_tensors(G1tensor(65),[G0tensor(122),G0tensor(114)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(66),G0tensor(123),G0tensor(118)])
  call ol_merge_tensors(G2tensor(1),[G2tensor(11),G2tensor(2),G2tensor(5),G1tensor(83),G1tensor(72),G1tensor(68),G0tensor(180) &
    ,G0tensor(134),G0tensor(125)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(70),G0tensor(167),G0tensor(132),G0tensor(112)])
  call ol_merge_tensors(G1tensor(71),[G0tensor(175),G0tensor(133),G0tensor(120)])
  call ol_merge_tensors(G1tensor(28),[G1tensor(78),G1tensor(73),G0tensor(185),G0tensor(150),G0tensor(135),G0tensor(130)])
  call ol_merge_tensors(G2tensor(26),[G1tensor(75),G0tensor(187),G0tensor(147),G0tensor(137)])
  call ol_merge_tensors(G1tensor(76),[G0tensor(195),G0tensor(148),G0tensor(145)])
  call ol_merge_tensors(G1tensor(80),[G0tensor(177),G0tensor(169)])
  call ol_merge_tensors(G1tensor(81),[G0tensor(178),G0tensor(173)])
  call ol_merge_tensors(G1tensor(85),[G0tensor(197)])
  call ol_merge_tensors(G1tensor(86),[G0tensor(198)])
  call ol_merge_tensors(G1tensor(1),[G1tensor(88),G0tensor(200)])
  call ol_merge_tensors(G1tensor(90),[G0tensor(202)])
  call ol_merge_tensors(G1tensor(91),[G0tensor(203)])
  call ol_merge_tensors(G1tensor(92),[G0tensor(204)])
  call ol_merge_tensors(G0tensor(7),[G0tensor(3)])
  call ol_merge_tensors(G0tensor(17),[G0tensor(5)])
  call ol_merge_tensors(G0tensor(18),[G0tensor(9)])
  call ol_merge_tensors(G0tensor(32),[G0tensor(28)])
  call ol_merge_tensors(G0tensor(42),[G0tensor(30)])
  call ol_merge_tensors(G0tensor(43),[G0tensor(34)])
  call ol_merge_tensors(G0tensor(57),[G0tensor(53)])
  call ol_merge_tensors(G0tensor(67),[G0tensor(55)])
  call ol_merge_tensors(G0tensor(68),[G0tensor(59)])
  call ol_merge_tensors(G0tensor(77),[G0tensor(73)])
  call ol_merge_tensors(G0tensor(87),[G0tensor(75)])
  call ol_merge_tensors(G0tensor(88),[G0tensor(79)])
  call ol_merge_tensors(G0tensor(97),[G0tensor(93)])
  call ol_merge_tensors(G0tensor(102),[G0tensor(95)])
  call ol_merge_tensors(G0tensor(103),[G0tensor(99)])
  call ol_merge_tensors(G0tensor(117),[G0tensor(113)])
  call ol_merge_tensors(G0tensor(140),[G0tensor(127),G0tensor(115)])
  call ol_merge_tensors(G0tensor(144),[G0tensor(128),G0tensor(119)])
  call ol_merge_tensors(G0tensor(142),[G0tensor(138)])
  call ol_merge_tensors(G0tensor(157),[G0tensor(153)])
  call ol_merge_tensors(G0tensor(162),[G0tensor(155)])
  call ol_merge_tensors(G0tensor(163),[G0tensor(159)])
  call ol_merge_tensors(G0tensor(172),[G0tensor(168)])
  call ol_merge_tensors(G0tensor(190),[G0tensor(182),G0tensor(170)])
  call ol_merge_tensors(G0tensor(194),[G0tensor(183),G0tensor(174)])
  call ol_merge_tensors(G0tensor(192),[G0tensor(188)])
  call ol_merge_tensors(G2tensor(13),[G0tensor(1)])
  call ol_merge_tensors(G2tensor(17),[G2tensor(9)])
  call TI_triangle_red(G2tensor(21),RedBasis(6),mass3set(:,1),G0tensor(6),G0tensor(11),G0tensor(16),G0tensor(21),M2L1R1,[nMZ,nMW], &
    G0tensor(26),G0tensor(31))
  call TI_triangle_red(G2tensor(16),RedBasis(2),mass3set(:,2),G0tensor(36),G0tensor(41),G0tensor(46), &
    G0tensor(51),M2L1R1,[nMZ,nMW],G0tensor(56),G0tensor(61))
  call TI_triangle_red(G2tensor(20),RedBasis(6),mass3set(:,3),G0tensor(66),G0tensor(71),G0tensor(76), &
    G0tensor(81),M2L1R1,[nMW,nMZ],G0tensor(86),G0tensor(91))
  call TI_triangle_red(G2tensor(7),RedBasis(2),mass3set(:,4),G0tensor(96),G0tensor(101),G0tensor(106), &
    G0tensor(111),M2L1R1,[nMW,nMZ],G0tensor(116),G0tensor(121))
  call TI_triangle_red(G2tensor(25),RedBasis(35),mass3set(:,3),G0tensor(126),G0tensor(131),G0tensor(136), &
    G0tensor(141),M2L1R1,[nMW,nMZ],G0tensor(146),G0tensor(151))
  call TI_triangle_red(G2tensor(18),RedBasis(6),mass3set(:,5),G0tensor(156),G0tensor(161),G0tensor(166), &
    G0tensor(171),M2L1R1,[nMW],G0tensor(176))
  call TI_triangle_red(G2tensor(1),RedBasis(2),mass3set(:,6),G0tensor(181),G0tensor(186),G0tensor(191),G0tensor(196),M2L1R1,[nMW], &
    G0tensor(201))
  call TI_triangle_red(G2tensor(24),RedBasis(35),mass3set(:,7),G0tensor(94),G0tensor(12),G0tensor(4),G0tensor(98),M2L1R1,[nMW], &
    G0tensor(13))
  call TI_triangle_red(G2tensor(26),RedBasis(35),mass3set(:,1),G0tensor(8),G0tensor(199),G0tensor(104), &
    G0tensor(19),M2L1R1,[nMZ,nMW],G0tensor(14),G0tensor(109))
  call TI_triangle_red(G3tensor(1),RedBasis(2),mass3set(:,8),G0tensor(65),G0tensor(24),G0tensor(15),G0tensor(52),M2L1R1,[nMM], &
    G0tensor(22))
  call TI_triangle_red(G3tensor(2),RedBasis(2),mass3set(:,9),G0tensor(2),G0tensor(60),G0tensor(23),G0tensor(10),M2L1R1,[nML], &
    G0tensor(70))
  call TI_triangle_red(G3tensor(3),RedBasis(2),mass3set(:,10),G0tensor(25),G0tensor(20),G0tensor(139), &
    G0tensor(37),M2L1R1,[nMT,nMB],G0tensor(29),G0tensor(143))
  call TI_triangle_red(G3tensor(4),RedBasis(2),mass3set(:,11),G0tensor(38),G0tensor(33),G0tensor(129), &
    G0tensor(124),M2L1R1,[nMB,nMT],G0tensor(44),G0tensor(39))
  call TI_triangle_red(G2tensor(13),RedBasis(2),mass3set(:,12),G0tensor(149),G0tensor(85),G0tensor(49), &
    G0tensor(40),M2L1R1,[nMH,nMW],G0tensor(72),G0tensor(47))
  call TI_triangle_red(G2tensor(17),RedBasis(2),mass3set(:,13),G0tensor(27),G0tensor(80),G0tensor(48), &
    G0tensor(35),M2L1R1,[nMW,nMH],G0tensor(90),G0tensor(50))
  call TI_triangle_red(G2tensor(19),RedBasis(6),mass3set(:,7),G0tensor(45),G0tensor(154),G0tensor(62),G0tensor(54),M2L1R1,[nMW], &
    G0tensor(158))
  call TI_triangle_red(G2tensor(22),RedBasis(6),mass3set(:,14),G0tensor(63),G0tensor(58),G0tensor(164),G0tensor(69),M2L1R1)
  call TI_triangle_red(G2tensor(23),RedBasis(6),mass3set(:,15),G0tensor(64),G0tensor(189),G0tensor(82),G0tensor(74),M2L1R1,[nMZ], &
    G0tensor(193))
  call TI_triangle_red(G2tensor(27),RedBasis(35),mass3set(:,15),G0tensor(83),G0tensor(78),G0tensor(184), &
    G0tensor(179),M2L1R1,[nMZ],G0tensor(89))
  call TI_triangle_red(G1tensor(7),RedBasis(27),mass3set(:,16),G0tensor(84),G0tensor(152),G0tensor(107), &
    G0tensor(92),M2L1R1,[nMZ,nMW],G0tensor(160),G0tensor(108))
  call TI_triangle_red(G1tensor(2),RedBasis(3),mass3set(:,17),G0tensor(100),G0tensor(205),G0tensor(165), &
    G0tensor(110),M2L1R1,[nMZ],G0tensor(105))
  call TI_triangle_red(G1tensor(37),RedBasis(36),mass3set(:,3),G0tensor(122),G0tensor(114),G0tensor(123), &
    G0tensor(118),M2L1R1,[nMW,nMZ],G0tensor(180),G0tensor(134))
  call TI_triangle_red(G1tensor(43),RedBasis(4),mass3set(:,18),G0tensor(125),G0tensor(167),G0tensor(132), &
    G0tensor(112),M2L1R1,[nMZ,nMW],G0tensor(175),G0tensor(133))
  call TI_triangle_red(G1tensor(31),RedBasis(1),mass3set(:,17),G0tensor(120),G0tensor(185),G0tensor(150), &
    G0tensor(135),M2L1R1,[nMZ],G0tensor(130))
  call TI_triangle_red(G1tensor(4),RedBasis(27),mass3set(:,19),G0tensor(187),G0tensor(147),G0tensor(137), &
    G0tensor(195),M2L1R1,[nMW,nMZ],G0tensor(148),G0tensor(145))
  call TI_triangle_red(G1tensor(3),RedBasis(3),mass3set(:,6),G0tensor(177),G0tensor(169),G0tensor(178),G0tensor(173),M2L1R1,[nMW], &
    G0tensor(197))
  call TI_triangle_red(G1tensor(24),RedBasis(36),mass3set(:,1),G0tensor(198),G0tensor(200),G0tensor(202), &
    G0tensor(203),M2L1R1,[nMZ,nMW],G0tensor(204),G0tensor(3))
  call TI_triangle_red(G1tensor(12),RedBasis(4),mass3set(:,20),G0tensor(5),G0tensor(9),G0tensor(28),G0tensor(30),M2L1R1,[nMW,nMZ], &
    G0tensor(34),G0tensor(53))
  call TI_triangle_red(G1tensor(8),RedBasis(1),mass3set(:,6),G0tensor(55),G0tensor(59),G0tensor(73),G0tensor(75),M2L1R1,[nMW], &
    G0tensor(79))
  call TI_triangle_red(G1tensor(22),RedBasis(23),mass3set(:,16),G0tensor(93),G0tensor(95),G0tensor(99), &
    G0tensor(113),M2L1R1,[nMZ,nMW],G0tensor(127),G0tensor(115))
  call TI_triangle_red(G1tensor(48),RedBasis(9),mass3set(:,1),G0tensor(128),G0tensor(119),G0tensor(138), &
    G0tensor(153),M2L1R1,[nMZ,nMW],G0tensor(155),G0tensor(159))
  call TI_triangle_red(G1tensor(30),RedBasis(7),mass3set(:,17),G0tensor(168),G0tensor(182),G0tensor(170), &
    G0tensor(183),M2L1R1,[nMZ],G0tensor(174))
  call TI_triangle_red(G1tensor(54),RedBasis(23),mass3set(:,19),G0tensor(188),G0tensor(1),G0tensor(206), &
    G0tensor(207),M2L1R1,[nMW,nMZ],G0tensor(208),G0tensor(209))
  call TI_triangle_red(G1tensor(36),RedBasis(9),mass3set(:,3),G0tensor(210),G0tensor(211),G0tensor(212), &
    G0tensor(213),M2L1R1,[nMW,nMZ],G0tensor(214),G0tensor(215))
  call TI_triangle_red(G1tensor(82),RedBasis(7),mass3set(:,6),G0tensor(216),G0tensor(217),G0tensor(218), &
    G0tensor(219),M2L1R1,[nMW],G0tensor(220))
  call TI_triangle_red(G1tensor(61),RedBasis(11),mass3set(:,18),G0tensor(221),G0tensor(222),G0tensor(223), &
    G0tensor(224),M2L1R1,[nMZ,nMW],G0tensor(225),G0tensor(226))
  call TI_triangle_red(G1tensor(9),RedBasis(10),mass3set(:,17),G0tensor(227),G0tensor(228),G0tensor(229), &
    G0tensor(230),M2L1R1,[nMZ],G0tensor(231))
  call TI_triangle_red(G1tensor(65),RedBasis(27),mass3set(:,7),G0tensor(232),G0tensor(233),G0tensor(234), &
    G0tensor(235),M2L1R1,[nMW],G0tensor(236))
  call TI_triangle_red(G1tensor(71),RedBasis(11),mass3set(:,5),G0tensor(237),G0tensor(238),G0tensor(239), &
    G0tensor(240),M2L1R1,[nMW],G0tensor(241))
  call TI_triangle_red(G1tensor(28),RedBasis(10),mass3set(:,6),G0tensor(242),G0tensor(243),G0tensor(244), &
    G0tensor(245),M2L1R1,[nMW],G0tensor(246))
  call TI_triangle_red(G1tensor(76),RedBasis(11),mass3set(:,20),G0tensor(247),G0tensor(248),G0tensor(249), &
    G0tensor(250),M2L1R1,[nMW,nMZ],G0tensor(251),G0tensor(252))
  call TI_triangle_red(G1tensor(80),RedBasis(23),mass3set(:,7),G0tensor(253),G0tensor(254),G0tensor(255), &
    G0tensor(256),M2L1R1,[nMW],G0tensor(257))
  call TI_triangle_red(G1tensor(81),RedBasis(9),mass3set(:,5),G0tensor(258),G0tensor(259),G0tensor(260), &
    G0tensor(261),M2L1R1,[nMW],G0tensor(262))
  call TI_triangle_red(G1tensor(85),RedBasis(37),mass3set(:,21),G0tensor(263),G0tensor(264),G0tensor(265), &
    G0tensor(266),M2L1R1,[nMZ],G0tensor(267))
  call TI_triangle_red(G1tensor(86),RedBasis(23),mass3set(:,22),G0tensor(268),G0tensor(269),G0tensor(270), &
    G0tensor(271),M2L1R1,[nMZ],G0tensor(272))
  call TI_triangle_red(G1tensor(1),RedBasis(22),mass3set(:,17),G0tensor(273),G0tensor(274),G0tensor(275), &
    G0tensor(276),M2L1R1,[nMZ],G0tensor(277))
  call TI_triangle_red(G1tensor(90),RedBasis(4),mass3set(:,21),G0tensor(278),G0tensor(279),G0tensor(280), &
    G0tensor(281),M2L1R1,[nMZ],G0tensor(282))
  call TI_triangle_red(G1tensor(91),RedBasis(25),mass3set(:,22),G0tensor(283),G0tensor(284),G0tensor(285), &
    G0tensor(286),M2L1R1,[nMZ],G0tensor(287))
  call TI_triangle_red(G1tensor(92),RedBasis(24),mass3set(:,17),G0tensor(288),G0tensor(289),G0tensor(290), &
    G0tensor(291),M2L1R1,[nMZ],G0tensor(292))
  call TI_triangle_red(G1tensor(5),RedBasis(22),mass3set(:,6),G0tensor(293),G0tensor(294),G0tensor(295), &
    G0tensor(296),M2L1R1,[nMW],G0tensor(297))
  call ol_merge_tensors(T0sum(42),[G0tensor(84)])
  call ol_merge_tensors(T0sum(43),[G0tensor(6)])
  call ol_merge_tensors(T0sum(44),[G0tensor(100)])
  call ol_merge_tensors(T0sum(45),[G0tensor(36)])
  call ol_merge_tensors(T0sum(46),[G0tensor(122)])
  call ol_merge_tensors(T0sum(47),[G0tensor(125)])
  call ol_merge_tensors(T0sum(48),[G0tensor(120)])
  call ol_merge_tensors(T0sum(49),[G0tensor(187)])
  call ol_merge_tensors(T0sum(50),[G0tensor(66)])
  call ol_merge_tensors(T0sum(51),[G0tensor(177)])
  call ol_merge_tensors(T0sum(52),[G0tensor(96)])
  call ol_merge_tensors(T0sum(53),[G0tensor(198)])
  call ol_merge_tensors(T0sum(54),[G0tensor(5)])
  call ol_merge_tensors(T0sum(55),[G0tensor(55)])
  call ol_merge_tensors(T0sum(56),[G0tensor(93)])
  call ol_merge_tensors(T0sum(57),[G0tensor(128)])
  call ol_merge_tensors(T0sum(58),[G0tensor(168)])
  call ol_merge_tensors(T0sum(59),[G0tensor(188)])
  call ol_merge_tensors(T0sum(60),[G0tensor(210)])
  call ol_merge_tensors(T0sum(61),[G0tensor(216)])
  call ol_merge_tensors(T0sum(62),[G0tensor(126)])
  call ol_merge_tensors(T0sum(63),[G0tensor(221)])
  call ol_merge_tensors(T0sum(64),[G0tensor(227)])
  call ol_merge_tensors(T0sum(65),[G0tensor(232)])
  call ol_merge_tensors(T0sum(66),[G0tensor(156)])
  call ol_merge_tensors(T0sum(67),[G0tensor(181)])
  call ol_merge_tensors(T0sum(68),[G0tensor(94)])
  call ol_merge_tensors(T0sum(69),[G0tensor(237)])
  call ol_merge_tensors(T0sum(70),[G0tensor(242)])
  call ol_merge_tensors(T0sum(71),[G0tensor(8)])
  call ol_merge_tensors(T0sum(72),[G0tensor(247)])
  call ol_merge_tensors(T0sum(73),[G0tensor(253)])
  call ol_merge_tensors(T0sum(74),[G0tensor(258)])
  call ol_merge_tensors(T0sum(75),[G0tensor(263)])
  call ol_merge_tensors(T0sum(76),[G0tensor(268)])
  call ol_merge_tensors(T0sum(77),[G0tensor(273)])
  call ol_merge_tensors(T0sum(78),[G0tensor(278)])
  call ol_merge_tensors(T0sum(79),[G0tensor(283)])
  call ol_merge_tensors(T0sum(80),[G0tensor(288)])
  call ol_merge_tensors(T0sum(81),[G0tensor(7)])
  call ol_merge_tensors(T0sum(82),[G0tensor(17)])
  call ol_merge_tensors(T0sum(83),[G0tensor(18)])
  call ol_merge_tensors(T0sum(84),[G0tensor(32)])
  call ol_merge_tensors(T0sum(85),[G0tensor(42)])
  call ol_merge_tensors(T0sum(86),[G0tensor(43)])
  call ol_merge_tensors(T0sum(87),[G0tensor(57)])
  call ol_merge_tensors(T0sum(88),[G0tensor(67)])
  call ol_merge_tensors(T0sum(89),[G0tensor(68)])
  call ol_merge_tensors(T0sum(90),[G0tensor(77)])
  call ol_merge_tensors(T0sum(91),[G0tensor(87)])
  call ol_merge_tensors(T0sum(92),[G0tensor(88)])
  call ol_merge_tensors(T0sum(93),[G0tensor(97)])
  call ol_merge_tensors(T0sum(94),[G0tensor(102)])
  call ol_merge_tensors(T0sum(95),[G0tensor(103)])
  call ol_merge_tensors(T0sum(96),[G0tensor(117)])
  call ol_merge_tensors(T0sum(97),[G0tensor(140)])
  call ol_merge_tensors(T0sum(98),[G0tensor(144)])
  call ol_merge_tensors(T0sum(99),[G0tensor(142)])
  call ol_merge_tensors(T0sum(100),[G0tensor(157)])
  call ol_merge_tensors(T0sum(101),[G0tensor(162)])
  call ol_merge_tensors(T0sum(102),[G0tensor(163)])
  call ol_merge_tensors(T0sum(103),[G0tensor(172)])
  call ol_merge_tensors(T0sum(104),[G0tensor(190)])
  call ol_merge_tensors(T0sum(105),[G0tensor(194)])
  call ol_merge_tensors(T0sum(106),[G0tensor(192)])
  call ol_merge_tensors(T0sum(107),[G0tensor(65)])
  call ol_merge_tensors(T0sum(108),[G0tensor(2)])
  call ol_merge_tensors(T0sum(109),[G0tensor(25)])
  call ol_merge_tensors(T0sum(110),[G0tensor(38)])
  call ol_merge_tensors(T0sum(111),[G0tensor(149)])
  call ol_merge_tensors(T0sum(112),[G0tensor(27)])
  call ol_merge_tensors(T0sum(113),[G0tensor(293)])
  call ol_merge_tensors(T0sum(114),[G0tensor(45)])
  call ol_merge_tensors(T0sum(115),[G0tensor(63)])
  call ol_merge_tensors(T0sum(116),[G0tensor(64)])
  call ol_merge_tensors(T0sum(117),[G0tensor(83)])
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(87),h0tab(:,87),[16,15],[nMH,nMH],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(7),ex5(:),G0H16(2),m3h1x16(:,69),heltab2x16(:,:,155))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(12),m0h(88),h0tab(:,88),[16,15],[nMZ,nMZ],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(12),ex5(:),G0H16(14),m3h1x16(:,70),heltab2x16(:,:,156))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(4),m0h(89),h0tab(:,89),[16,15],[nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(4),ex5(:),G0H16(8),m3h1x16(:,71),heltab2x16(:,:,157))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(3),m0h(90),h0tab(:,90),[16,15],[nMZ,nMZ],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(3),ex5(:),G0H16(10),m3h1x16(:,72),heltab2x16(:,:,158))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(11),m0h(91),h0tab(:,91),[16,15],[nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(11),ex5(:),G0H16(5),m3h1x16(:,73),heltab2x16(:,:,159))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(92),h0tab(:,92),[28,3],[nMW,0],3,2,wf4(:,2),wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H16(1),wf4(:,2),ex5(:),G0H4(5),m4h4x1x4(:,1),heltab3x16(:,:,1))
  Gcoeff(:)%j = (c(25)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(9),m0h(93),h0tab(:,93),[28,3],[nMW,nMZ],3,2,wf4(:,2),wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H16(9),wf4(:,2),ex5(:),G0H4(6),m4h4x1x4(:,2),heltab3x16(:,:,2))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(6),m0h(94),h0tab(:,94),[28,3],[nMH,nMW],3,2,wf4(:,2),wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H16(6),wf4(:,2),ex5(:),G0H4(7),m4h4x1x4(:,3),heltab3x16(:,:,3))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(13),m0h(95),h0tab(:,95),[19,12],[nMW,0],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VVS_S(ntryL,G0H16(13),wf4(:,1),ex5(:),G0H4(8),m4h4x1x4(:,4),heltab3x16(:,:,4))
  Gcoeff(:)%j = (c(25)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(96),h0tab(:,96),[19,12],[nMW,nMZ],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VVS_S(ntryL,G0H16(15),wf4(:,1),ex5(:),G0H4(1),m4h4x1x4(:,5),heltab3x16(:,:,5))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(16),m0h(97),h0tab(:,97),[19,12],[nMH,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VVS_S(ntryL,G0H16(16),wf4(:,1),ex5(:),G0H4(3),m4h4x1x4(:,6),heltab3x16(:,:,6))
  Gcoeff(:)%j = (c(34)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(17),m0h(98),h0tab(:,98),[19,12],[0,nMM],2,2,wf4(:,6),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(17),wf4(:,6),G0H4(4),ngPln,m3h4x4(:,59),heltab2x16(:,:,160))
  call Hloop_A_Q(ntryL,G0H4(4),19,0,G1H4(10),n2h4(9))
  Gcoeff(:)%j = (c(33)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(18),m0h(99),h0tab(:,99),[19,12],[0,nML],2,2,wf4(:,6),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(18),wf4(:,6),G0H4(2),ngPln,m3h4x4(:,60),heltab2x16(:,:,161))
  call Hloop_A_Q(ntryL,G0H4(2),19,0,G1H4(8),n2h4(10))
  Gcoeff(:)%j = (c(31)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(100),h0tab(:,100),[19,12],[nMT,nMB],2,2,wf4(:,6),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(19),wf4(:,6),G0H4(4),ngPbt,m3h4x4(:,61),heltab2x16(:,:,162))
  call Hloop_A_Q(ntryL,G0H4(4),19,nMT,G1H4(1),n2h4(11))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(20),m0h(101),h0tab(:,101),[19,12],[nMH,nMW],2,2,wf4(:,6),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(20),wf4(:,6),G0H4(2),m3h4x4(:,62),heltab2x16(:,:,163))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(21),m0h(102),h0tab(:,102),[19,12],[0,nMW],2,2,wf4(:,6),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(21),wf4(:,6),G0H4(4),m3h4x4(:,63),heltab2x16(:,:,164))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(22),m0h(103),h0tab(:,103),[19,12],[nMZ,nMW],2,2,wf4(:,6),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(22),wf4(:,6),G0H4(9),m3h4x4(:,64),heltab2x16(:,:,165))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(23),m0h(104),h0tab(:,104),[19,12],[nMZ,nMW],2,2,wf4(:,6),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(23),wf4(:,6),G0H4(10),m3h4x4(:,65),heltab2x16(:,:,166))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(24),m0h(105),h0tab(:,105),[19,12],[0,nMW],2,2,wf4(:,6),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(24),wf4(:,6),G0H4(11),m3h4x4(:,66),heltab2x16(:,:,167))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(25),m0h(106),h0tab(:,106),[19,12],[nMZ,nMW],2,2,wf4(:,6),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(25),wf4(:,6),G0H4(12),m3h4x4(:,67),heltab2x16(:,:,168))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(26),m0h(107),h0tab(:,107),[19,12],[nMW,0],2,2,wf4(:,6),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(26),0,wf4(:,6),19,G1H4(2),m3h4x4(:,68),heltab2x16(:,:,169))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(27),m0h(108),h0tab(:,108),[19,12],[nMW,nMZ],2,2,wf4(:,6),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(27),0,wf4(:,6),19,G1H4(9),m3h4x4(:,69),heltab2x16(:,:,170))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(109),h0tab(:,109),[19,12],[nMH,nMW],2,2,wf4(:,6),wf4(:,2))
  call Hloop_VS_T(ntryL,G0H16(7),0,wf4(:,6),19,G1H4(3),m3h4x4(:,70),heltab2x16(:,:,171))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(12),m0h(110),h0tab(:,110),[19,12],[0,0],2,2,wf4(:,3),wf4(:,2))
  call Hloop_AW_Q(ntryL,G0H16(12),wf4(:,3),G0H4(13),m3h4x4(:,71),heltab2x16(:,:,172))
  call Hloop_A_Q(ntryL,G0H4(13),19,0,G1H4(7),n2h4(12))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(4),m0h(111),h0tab(:,111),[19,12],[0,nMM],2,2,wf4(:,3),wf4(:,2))
  call Hloop_AW_Q(ntryL,G0H16(4),wf4(:,3),G0H4(13),m3h4x4(:,72),heltab2x16(:,:,173))
  call Hloop_A_Q(ntryL,G0H4(13),19,0,G1H4(4),n2h4(13))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(3),m0h(112),h0tab(:,112),[19,12],[0,nML],2,2,wf4(:,3),wf4(:,2))
  call Hloop_AW_Q(ntryL,G0H16(3),wf4(:,3),G0H4(13),m3h4x4(:,73),heltab2x16(:,:,174))
  call Hloop_A_Q(ntryL,G0H4(13),19,0,G1H4(11),n2h4(14))
  Gcoeff(:)%j = (c(38)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(11),m0h(113),h0tab(:,113),[19,12],[0,0],2,2,wf4(:,3),wf4(:,2))
  call Hloop_AW_Q(ntryL,G0H16(11),wf4(:,3),G0H4(13),m3h4x4(:,74),heltab2x16(:,:,175))
  call Hloop_A_Q(ntryL,G0H4(13),19,0,G1H4(6),n2h4(15))
  Gcoeff(:)%j = (c(37)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(114),h0tab(:,114),[19,12],[nMT,nMB],2,2,wf4(:,3),wf4(:,2))
  call Hloop_AW_Q(ntryL,G0H16(1),wf4(:,3),G0H4(13),m3h4x4(:,75),heltab2x16(:,:,176))
  call Hloop_A_Q(ntryL,G0H4(13),19,nMT,G1H4(12),n2h4(16))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(9),m0h(115),h0tab(:,115),[19,12],[nMH,nMW],2,2,wf4(:,3),wf4(:,2))
  call Hloop_SV_T(ntryL,G0H16(9),0,wf4(:,3),19,G1H4(13),m3h4x4(:,76),heltab2x16(:,:,177))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(6),m0h(116),h0tab(:,116),[19,12],[nMZ,nMW],2,2,wf4(:,3),wf4(:,2))
  call Hloop_SV_T(ntryL,G0H16(6),0,wf4(:,3),19,G1H4(22),m3h4x4(:,77),heltab2x16(:,:,178))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(13),m0h(117),h0tab(:,117),[19,12],[0,nMW],2,2,wf4(:,3),wf4(:,2))
  call Hloop_DV_C(ntryL,G0H16(13),0,wf4(:,3),G1H4(23),m3h4x4(:,78),heltab2x16(:,:,179))
  Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(118),h0tab(:,118),[19,12],[nMZ,nMW],2,2,wf4(:,3),wf4(:,2))
  call Hloop_DV_C(ntryL,G0H16(15),0,wf4(:,3),G1H4(5),m3h4x4(:,79),heltab2x16(:,:,180))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(16),m0h(119),h0tab(:,119),[19,12],[0,nMW],2,2,wf4(:,3),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H16(16),0,wf4(:,3),19,G1H4(24),m3h4x4(:,80),heltab2x16(:,:,181))
  Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(17),m0h(120),h0tab(:,120),[19,12],[nMZ,nMW],2,2,wf4(:,3),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H16(17),0,wf4(:,3),19,G1H4(25),m3h4x4(:,81),heltab2x16(:,:,182))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(18),m0h(121),h0tab(:,121),[19,12],[0,nMW],2,2,wf4(:,3),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H16(18),0,wf4(:,3),19,G1H4(14),m3h4x4(:,82),heltab2x16(:,:,183))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(122),h0tab(:,122),[19,12],[nMZ,nMW],2,2,wf4(:,3),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H16(19),0,wf4(:,3),19,G1H4(15),m3h4x4(:,83),heltab2x16(:,:,184))
  Gcoeff(:)%j = (c(23)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(20),m0h(123),h0tab(:,123),[19,12],[nMW,0],2,2,wf4(:,3),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H16(20),wf4(:,3),G0H4(13),m3h4x4(:,84),heltab2x16(:,:,185))
  Gcoeff(:)%j = (c(28)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(21),m0h(124),h0tab(:,124),[19,12],[nMW,nMZ],2,2,wf4(:,3),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H16(21),wf4(:,3),G0H4(14),m3h4x4(:,85),heltab2x16(:,:,186))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(22),m0h(125),h0tab(:,125),[19,12],[nMH,nMW],2,2,wf4(:,3),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H16(22),wf4(:,3),G0H4(15),m3h4x4(:,86),heltab2x16(:,:,187))
  Gcoeff(:)%j = (-(c(34)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(23),m0h(126),h0tab(:,126),[28,3],[0,nMM],2,2,wf4(:,10),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(23),wf4(:,10),G0H4(16),ngPnl,m3h4x4(:,87),heltab2x16(:,:,188))
  call Hloop_Q_A(ntryL,G0H4(16),28,0,G1H4(16),n2h4(17))
  Gcoeff(:)%j = (-(c(33)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(24),m0h(127),h0tab(:,127),[28,3],[0,nML],2,2,wf4(:,10),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(24),wf4(:,10),G0H4(16),ngPnl,m3h4x4(:,88),heltab2x16(:,:,189))
  call Hloop_Q_A(ntryL,G0H4(16),28,0,G1H4(17),n2h4(18))
  Gcoeff(:)%j = (c(31)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(25),m0h(128),h0tab(:,128),[28,3],[nMT,nMB],2,2,wf4(:,10),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(25),wf4(:,10),G0H4(16),ngPtb,m3h4x4(:,89),heltab2x16(:,:,190))
  call Hloop_Q_A(ntryL,G0H4(16),28,nMT,G1H4(18),n2h4(19))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(26),m0h(129),h0tab(:,129),[28,3],[nMH,nMW],2,2,wf4(:,10),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(26),wf4(:,10),G0H4(16),m3h4x4(:,90),heltab2x16(:,:,191))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(27),m0h(130),h0tab(:,130),[28,3],[nMZ,nMW],2,2,wf4(:,10),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(27),wf4(:,10),G0H4(17),m3h4x4(:,91),heltab2x16(:,:,192))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(131),h0tab(:,131),[28,3],[0,nMW],2,2,wf4(:,10),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(7),wf4(:,10),G0H4(18),m3h4x4(:,92),heltab2x16(:,:,193))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(12),m0h(132),h0tab(:,132),[28,3],[nMZ,nMW],2,2,wf4(:,10),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(12),wf4(:,10),G0H4(19),m3h4x4(:,93),heltab2x16(:,:,194))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(4),m0h(133),h0tab(:,133),[28,3],[0,nMW],2,2,wf4(:,10),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(4),wf4(:,10),G0H4(20),m3h4x4(:,94),heltab2x16(:,:,195))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(3),m0h(134),h0tab(:,134),[28,3],[nMZ,nMW],2,2,wf4(:,10),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(3),wf4(:,10),G0H4(21),m3h4x4(:,95),heltab2x16(:,:,196))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(11),m0h(135),h0tab(:,135),[28,3],[nMW,0],2,2,wf4(:,10),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H16(11),0,wf4(:,10),28,G1H4(19),m3h4x4(:,96),heltab2x16(:,:,197))
  Gcoeff(:)%j = (c(30)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(136),h0tab(:,136),[28,3],[nMW,nMZ],2,2,wf4(:,10),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H16(1),0,wf4(:,10),28,G1H4(20),m3h4x4(:,97),heltab2x16(:,:,198))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(9),m0h(137),h0tab(:,137),[28,3],[nMH,nMW],2,2,wf4(:,10),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H16(9),0,wf4(:,10),28,G1H4(21),m3h4x4(:,98),heltab2x16(:,:,199))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(6),m0h(138),h0tab(:,138),[28,3],[0,0],2,2,wf4(:,12),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H16(6),wf4(:,12),G0H4(22),m3h4x4(:,99),heltab2x16(:,:,200))
  call Hloop_Q_A(ntryL,G0H4(22),28,0,G1H4(26),n2h4(20))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(13),m0h(139),h0tab(:,139),[28,3],[0,nMM],2,2,wf4(:,12),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H16(13),wf4(:,12),G0H4(22),m3h4x4(:,100),heltab2x16(:,:,201))
  call Hloop_Q_A(ntryL,G0H4(22),28,0,G1H4(27),n2h4(21))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(140),h0tab(:,140),[28,3],[0,nML],2,2,wf4(:,12),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H16(15),wf4(:,12),G0H4(22),m3h4x4(:,101),heltab2x16(:,:,202))
  call Hloop_Q_A(ntryL,G0H4(22),28,0,G1H4(28),n2h4(22))
  Gcoeff(:)%j = (c(38)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(16),m0h(141),h0tab(:,141),[28,3],[0,0],2,2,wf4(:,12),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H16(16),wf4(:,12),G0H4(22),m3h4x4(:,102),heltab2x16(:,:,203))
  call Hloop_Q_A(ntryL,G0H4(22),28,0,G1H4(29),n2h4(23))
  Gcoeff(:)%j = (c(37)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(17),m0h(142),h0tab(:,142),[28,3],[nMT,nMB],2,2,wf4(:,12),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H16(17),wf4(:,12),G0H4(22),m3h4x4(:,103),heltab2x16(:,:,204))
  call Hloop_Q_A(ntryL,G0H4(22),28,nMT,G1H4(30),n2h4(24))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(18),m0h(143),h0tab(:,143),[28,3],[nMH,nMW],2,2,wf4(:,12),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H16(18),0,wf4(:,12),28,G1H4(31),m3h4x4(:,104),heltab2x16(:,:,205))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(144),h0tab(:,144),[28,3],[nMZ,nMW],2,2,wf4(:,12),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H16(19),0,wf4(:,12),28,G1H4(32),m3h4x4(:,105),heltab2x16(:,:,206))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(20),m0h(145),h0tab(:,145),[28,3],[0,nMW],2,2,wf4(:,12),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(20),0,wf4(:,12),28,G1H4(33),m3h4x4(:,106),heltab2x16(:,:,207))
  Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(21),m0h(146),h0tab(:,146),[28,3],[nMZ,nMW],2,2,wf4(:,12),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(21),0,wf4(:,12),28,G1H4(34),m3h4x4(:,107),heltab2x16(:,:,208))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(22),m0h(147),h0tab(:,147),[28,3],[0,nMW],2,2,wf4(:,12),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H16(22),0,wf4(:,12),G1H4(35),m3h4x4(:,108),heltab2x16(:,:,209))
  Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(23),m0h(148),h0tab(:,148),[28,3],[nMZ,nMW],2,2,wf4(:,12),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H16(23),0,wf4(:,12),G1H4(36),m3h4x4(:,109),heltab2x16(:,:,210))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(24),m0h(149),h0tab(:,149),[28,3],[0,nMW],2,2,wf4(:,12),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H16(24),0,wf4(:,12),28,G1H4(37),m3h4x4(:,110),heltab2x16(:,:,211))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(25),m0h(150),h0tab(:,150),[28,3],[nMZ,nMW],2,2,wf4(:,12),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H16(25),0,wf4(:,12),28,G1H4(38),m3h4x4(:,111),heltab2x16(:,:,212))
  Gcoeff(:)%j = (c(23)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(26),m0h(151),h0tab(:,151),[28,3],[nMW,0],2,2,wf4(:,12),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(26),wf4(:,12),G0H4(22),m3h4x4(:,112),heltab2x16(:,:,213))
  Gcoeff(:)%j = (c(28)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(27),m0h(152),h0tab(:,152),[28,3],[nMW,nMZ],2,2,wf4(:,12),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(27),wf4(:,12),G0H4(23),m3h4x4(:,113),heltab2x16(:,:,214))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(153),h0tab(:,153),[28,3],[nMH,nMW],2,2,wf4(:,12),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(7),wf4(:,12),G0H4(24),m3h4x4(:,114),heltab2x16(:,:,215))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G0H4(22),G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G0H4(23),G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(21),[G0H4(24),G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G0H4(13),G0H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(9),[G0H4(14),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(3),[G0H4(15),G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(4),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G1H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(23),[G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(5),[G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G0H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(14),[G0H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(15),[G0H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(27),[G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(28),[G1H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(30),[G1H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(31),[G0H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(34),[G0H4(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(35),[G0H4(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(36),[G0H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(37),[G0H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(38),[G0H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(29),[G1H4(26)])
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H16(2),wf4(:,1),wf4(:,2),G0tensor(84),m4h4x4x1(:,1),heltab3x16(:,:,7))
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H16(14),wf4(:,1),wf4(:,2),G0tensor(6),m4h4x4x1(:,2),heltab3x16(:,:,8))
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H16(8),wf4(:,1),wf4(:,2),G0tensor(100),m4h4x4x1(:,3),heltab3x16(:,:,9))
  call Hcheck_last_VWW_V(ntryL,l_switch,G0H16(10),wf4(:,1),wf4(:,2),G0tensor(36),m4h4x4x1(:,4),heltab3x16(:,:,10))
  call Hcheck_last_WWV_V(ntryL,l_switch,G0H16(5),wf4(:,1),wf4(:,2),G0tensor(122),m4h4x4x1(:,5),heltab3x16(:,:,11))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(19),wf4(:,1),G1tensor(11),m3h4x1(:,31),heltab2x4(:,:,57))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(20),wf4(:,1),G1tensor(10),m3h4x1(:,32),heltab2x4(:,:,58))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(21),wf4(:,1),G1tensor(14),m3h4x1(:,33),heltab2x4(:,:,59))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(2),wf4(:,2),G1tensor(15),m3h4x1(:,34),heltab2x4(:,:,60))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(9),wf4(:,2),G1tensor(58),m3h4x1(:,35),heltab2x4(:,:,61))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(3),wf4(:,2),G1tensor(17),m3h4x1(:,36),heltab2x4(:,:,62))
  call Hloop_AW_Q(ntryL,G1H4(4),wf4(:,2),G1H1(1),m3h4x1(:,37),heltab2x4(:,:,63))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(4),n2h1(8))
  call Hloop_AW_Q(ntryL,G1H4(11),wf4(:,2),G1H1(1),m3h4x1(:,38),heltab2x4(:,:,64))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nML,G2tensor(3),n2h1(9))
  call Hloop_AW_Q(ntryL,G1H4(12),wf4(:,2),G1H1(1),m3h4x1(:,39),heltab2x4(:,:,65))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(14),n2h1(10))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(13),19,wf4(:,2),12,G2tensor(8),m3h4x1(:,40),heltab2x4(:,:,66))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(23),19,wf4(:,2),G2tensor(12),m3h4x1(:,41),heltab2x4(:,:,67))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(5),19,wf4(:,2),G2tensor(10),m3h4x1(:,42),heltab2x4(:,:,68))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(25),19,wf4(:,2),12,G2tensor(15),m3h4x1(:,43),heltab2x4(:,:,69))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(14),19,wf4(:,2),12,G2tensor(6),m3h4x1(:,44),heltab2x4(:,:,70))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(15),19,wf4(:,2),12,G2tensor(11),m3h4x1(:,45),heltab2x4(:,:,71))
  call Hloop_AW_Q(ntryL,G1H4(6),wf4(:,2),G1H1(1),m3h4x1(:,46),heltab2x4(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(2),n2h1(11))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(22),19,wf4(:,2),12,G2tensor(5),m3h4x1(:,47),heltab2x4(:,:,73))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(24),19,wf4(:,2),12,G2tensor(9),m3h4x1(:,48),heltab2x4(:,:,74))
  call Hloop_QW_A(ntryL,G1H4(27),wf4(:,1),G1H1(1),m3h4x1(:,49),heltab2x4(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(21),n2h1(12))
  call Hloop_QW_A(ntryL,G1H4(28),wf4(:,1),G1H1(1),m3h4x1(:,50),heltab2x4(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(16),n2h1(13))
  call Hloop_QW_A(ntryL,G1H4(30),wf4(:,1),G1H1(1),m3h4x1(:,51),heltab2x4(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(20),n2h1(14))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(31),28,wf4(:,1),3,G2tensor(7),m3h4x1(:,52),heltab2x4(:,:,78))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(34),28,wf4(:,1),3,G2tensor(25),m3h4x1(:,53),heltab2x4(:,:,79))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(35),28,wf4(:,1),G2tensor(18),m3h4x1(:,54),heltab2x4(:,:,80))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(36),28,wf4(:,1),G2tensor(1),m3h4x1(:,55),heltab2x4(:,:,81))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(37),28,wf4(:,1),3,G2tensor(24),m3h4x1(:,56),heltab2x4(:,:,82))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(38),28,wf4(:,1),3,G2tensor(26),m3h4x1(:,57),heltab2x4(:,:,83))
  call Hloop_QW_A(ntryL,G1H4(29),wf4(:,1),G1H1(1),m3h4x1(:,58),heltab2x4(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(13),n2h1(15))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(32),28,wf4(:,1),3,G2tensor(17),m3h4x1(:,59),heltab2x4(:,:,85))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(33),28,wf4(:,1),3,G2tensor(19),m3h4x1(:,60),heltab2x4(:,:,86))
  call ol_merge_tensors(G0tensor(294),[G0tensor(107),G0tensor(154),G0tensor(11)])
  call ol_merge_tensors(G0tensor(270),[G0tensor(165),G0tensor(16)])
  call ol_merge_tensors(G1tensor(58),[G0tensor(223),G0tensor(153),G0tensor(132),G0tensor(46),G0tensor(21)])
  call ol_merge_tensors(G0tensor(292),[G0tensor(287),G0tensor(282),G0tensor(277),G0tensor(272),G0tensor(267),G0tensor(252) &
    ,G0tensor(231),G0tensor(225),G0tensor(215),G0tensor(209),G0tensor(174),G0tensor(155),G0tensor(127),G0tensor(53),G0tensor(204) &
    ,G0tensor(145),G0tensor(130),G0tensor(175),G0tensor(134),G0tensor(105),G0tensor(160),G0tensor(89),G0tensor(193),G0tensor(14) &
    ,G0tensor(151),G0tensor(121),G0tensor(91),G0tensor(56),G0tensor(26)])
  call ol_merge_tensors(G0tensor(297),[G0tensor(262),G0tensor(257),G0tensor(251),G0tensor(246),G0tensor(241),G0tensor(236) &
    ,G0tensor(226),G0tensor(220),G0tensor(214),G0tensor(208),G0tensor(159),G0tensor(115),G0tensor(79),G0tensor(34),G0tensor(3) &
    ,G0tensor(197),G0tensor(148),G0tensor(133),G0tensor(180),G0tensor(108),G0tensor(158),G0tensor(90),G0tensor(47),G0tensor(109) &
    ,G0tensor(13),G0tensor(201),G0tensor(176),G0tensor(146),G0tensor(116),G0tensor(86),G0tensor(61),G0tensor(31)])
  call ol_merge_tensors(G2tensor(17),[G2tensor(26),G2tensor(1),G2tensor(25),G0tensor(95),G0tensor(118),G0tensor(152),G0tensor(141) &
    ,G0tensor(41)])
  call ol_merge_tensors(G0tensor(36),[G0tensor(6),G0tensor(291),G0tensor(276),G0tensor(230),G0tensor(183),G0tensor(135) &
    ,G0tensor(110),G0tensor(51)])
  call ol_merge_tensors(G0tensor(274),[G0tensor(264),G0tensor(137),G0tensor(71)])
  call ol_merge_tensors(G0tensor(178),[G0tensor(166),G0tensor(76)])
  call ol_merge_tensors(G2tensor(5),[G2tensor(11),G2tensor(15),G2tensor(10),G0tensor(249),G0tensor(213),G0tensor(28),G0tensor(106) &
    ,G0tensor(81)])
  call ol_merge_tensors(G1tensor(10),[G0tensor(1),G0tensor(203),G0tensor(147),G0tensor(19),G0tensor(101)])
  call ol_merge_tensors(G0tensor(122),[G0tensor(100),G0tensor(296),G0tensor(245),G0tensor(219),G0tensor(75),G0tensor(173) &
    ,G0tensor(35),G0tensor(196),G0tensor(111)])
  call ol_merge_tensors(G0tensor(279),[G0tensor(228),G0tensor(131)])
  call ol_merge_tensors(G0tensor(222),[G0tensor(136)])
  call ol_merge_tensors(G0tensor(234),[G0tensor(58),G0tensor(161)])
  call ol_merge_tensors(G2tensor(9),[G2tensor(6),G2tensor(12),G0tensor(261),G0tensor(239),G0tensor(191),G0tensor(171)])
  call ol_merge_tensors(G1tensor(11),[G0tensor(254),G0tensor(233),G0tensor(98),G0tensor(186)])
  call ol_merge_tensors(G0tensor(243),[G0tensor(199),G0tensor(12)])
  call ol_merge_tensors(G0tensor(238),[G0tensor(4)])
  call ol_merge_tensors(G0tensor(290),[G0tensor(285),G0tensor(248),G0tensor(104)])
  call ol_merge_tensors(G2tensor(4),[G0tensor(15)])
  call ol_merge_tensors(G2tensor(3),[G0tensor(23)])
  call ol_merge_tensors(G2tensor(20),[G0tensor(20)])
  call ol_merge_tensors(G0tensor(39),[G0tensor(29)])
  call ol_merge_tensors(G0tensor(44),[G0tensor(143)])
  call ol_merge_tensors(G2tensor(14),[G0tensor(129)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(14),G0tensor(85)])
  call ol_merge_tensors(G0tensor(84),[G0tensor(40)])
  call ol_merge_tensors(G0tensor(50),[G0tensor(72)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(17),G0tensor(48)])
  call ol_merge_tensors(G0tensor(259),[G0tensor(255),G0tensor(164),G0tensor(62)])
  call ol_merge_tensors(G1tensor(15),[G0tensor(54)])
  call ol_merge_tensors(G2tensor(2),[G0tensor(284),G0tensor(280),G0tensor(74),G0tensor(69)])
  call ol_merge_tensors(G0tensor(170),[G0tensor(138),G0tensor(189)])
  call ol_merge_tensors(G0tensor(211),[G0tensor(206),G0tensor(82)])
  call ol_merge_tensors(G0tensor(9),[G0tensor(202),G0tensor(78)])
  call ol_merge_tensors(G0tensor(185),[G0tensor(114),G0tensor(184)])
  call ol_merge_tensors(G2tensor(13),[G0tensor(269),G0tensor(265),G0tensor(179)])
  call ol_merge_tensors(G0tensor(266),[G0tensor(205),G0tensor(92)])
  call ol_merge_tensors(G0tensor(167),[G0tensor(123)])
  call ol_merge_tensors(G0tensor(150),[G0tensor(112)])
  call ol_merge_tensors(G0tensor(235),[G0tensor(169),G0tensor(195)])
  call ol_merge_tensors(G0tensor(59),[G0tensor(200)])
  call ol_merge_tensors(G0tensor(73),[G0tensor(30)])
  call ol_merge_tensors(G0tensor(119),[G0tensor(99)])
  call ol_merge_tensors(G0tensor(182),[G0tensor(113)])
  call ol_merge_tensors(G0tensor(256),[G0tensor(217),G0tensor(207)])
  call ol_merge_tensors(G0tensor(260),[G0tensor(218),G0tensor(212)])
  call ol_merge_tensors(G0tensor(286),[G0tensor(229),G0tensor(224)])
  call ol_merge_tensors(G0tensor(250),[G0tensor(244),G0tensor(240)])
  call ol_merge_tensors(G0tensor(275),[G0tensor(271)])
  call ol_merge_tensors(G0tensor(289),[G0tensor(281)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(24),G2tensor(18)])
call TI_bubble_red(G2tensor(17),28,mass2set(:,1),G0tensor(125),M2L1R1,G0tensor(120),G0tensor(187))
call TI_bubble_red(G2tensor(5),19,mass2set(:,1),G0tensor(66),M2L1R1,G0tensor(177),G0tensor(96))
call TI_bubble_red(G2tensor(9),19,mass2set(:,2),G0tensor(198),M2L1R1,G0tensor(5))
call TI_bubble_red(G2tensor(4),19,mass2set(:,3),G0tensor(55),M2L1R1,G0tensor(93))
call TI_bubble_red(G2tensor(3),19,mass2set(:,4),G0tensor(128),M2L1R1,G0tensor(168))
call TI_bubble_red(G2tensor(20),28,mass2set(:,5),G0tensor(188),M2L1R1,G0tensor(210),G0tensor(216))
call TI_bubble_red(G2tensor(14),19,mass2set(:,5),G0tensor(126),M2L1R1,G0tensor(221),G0tensor(227))
call TI_bubble_red(G2tensor(7),28,mass2set(:,6),G0tensor(232),M2L1R1,G0tensor(156),G0tensor(181))
call TI_bubble_red(G2tensor(8),19,mass2set(:,6),G0tensor(94),M2L1R1,G0tensor(237),G0tensor(242))
call TI_bubble_red(G2tensor(2),19,mass2set(:,7),G0tensor(8),M2L1R1)
call TI_bubble_red(G2tensor(13),28,mass2set(:,7),G0tensor(247),M2L1R1)
call TI_bubble_red(G2tensor(21),28,mass2set(:,3),G0tensor(253),M2L1R1,G0tensor(258))
call TI_bubble_red(G2tensor(16),28,mass2set(:,4),G0tensor(263),M2L1R1,G0tensor(268))
call TI_bubble_red(G2tensor(19),28,mass2set(:,2),G0tensor(273),M2L1R1,G0tensor(278))
  call ol_merge_tensors(G0tensor(96),[G0tensor(187),G0tensor(292)])
  call ol_merge_tensors(G0tensor(278),[G0tensor(237),G0tensor(156),G0tensor(5),G0tensor(177),G0tensor(120),G0tensor(297)])
  call ol_merge_tensors(G0tensor(258),[G0tensor(22),G0tensor(93)])
  call ol_merge_tensors(G0tensor(268),[G0tensor(70),G0tensor(168)])
  call ol_merge_tensors(G0tensor(221),[G0tensor(44),G0tensor(210)])
  call ol_merge_tensors(G0tensor(227),[G0tensor(39),G0tensor(216)])
  call ol_merge_tensors(G0tensor(242),[G0tensor(50),G0tensor(181)])
call TI_bubble_red(G1tensor(58),19,mass2set(:,8),G0tensor(283),M2L1R1,G0tensor(288),G0tensor(7))
call TI_bubble_red(G1tensor(10),28,mass2set(:,8),G0tensor(17),M2L1R1,G0tensor(18),G0tensor(32))
call TI_bubble_red(G1tensor(11),28,mass2set(:,9),G0tensor(42),M2L1R1,G0tensor(43))
call TI_bubble_red(G1tensor(15),19,mass2set(:,9),G0tensor(57),M2L1R1,G0tensor(67))
  call ol_merge_tensors(G0tensor(18),[G0tensor(96),G0tensor(288)])
  call ol_merge_tensors(G0tensor(67),[G0tensor(43),G0tensor(32),G0tensor(278),G0tensor(7)])
  call ol_merge_tensors(T0sum(118),[G0tensor(294)])
  call ol_merge_tensors(T0sum(119),[G0tensor(270)])
  call ol_merge_tensors(T0sum(120),[G0tensor(283)])
  call ol_merge_tensors(T0sum(121),[G0tensor(18)])
  call ol_merge_tensors(T0sum(122),[G0tensor(67)])
  call ol_merge_tensors(T0sum(123),[G0tensor(125)])
  call ol_merge_tensors(T0sum(124),[G0tensor(36)])
  call ol_merge_tensors(T0sum(125),[G0tensor(274)])
  call ol_merge_tensors(T0sum(126),[G0tensor(178)])
  call ol_merge_tensors(T0sum(127),[G0tensor(66)])
  call ol_merge_tensors(T0sum(128),[G0tensor(17)])
  call ol_merge_tensors(T0sum(129),[G0tensor(122)])
  call ol_merge_tensors(T0sum(130),[G0tensor(279)])
  call ol_merge_tensors(T0sum(131),[G0tensor(222)])
  call ol_merge_tensors(T0sum(132),[G0tensor(234)])
  call ol_merge_tensors(T0sum(133),[G0tensor(198)])
  call ol_merge_tensors(T0sum(134),[G0tensor(42)])
  call ol_merge_tensors(T0sum(135),[G0tensor(243)])
  call ol_merge_tensors(T0sum(136),[G0tensor(238)])
  call ol_merge_tensors(T0sum(137),[G0tensor(290)])
  call ol_merge_tensors(T0sum(138),[G0tensor(24)])
  call ol_merge_tensors(T0sum(139),[G0tensor(55)])
  call ol_merge_tensors(T0sum(140),[G0tensor(258)])
  call ol_merge_tensors(T0sum(141),[G0tensor(52)])
  call ol_merge_tensors(T0sum(142),[G0tensor(60)])
  call ol_merge_tensors(T0sum(143),[G0tensor(128)])
  call ol_merge_tensors(T0sum(144),[G0tensor(268)])
  call ol_merge_tensors(T0sum(145),[G0tensor(10)])
  call ol_merge_tensors(T0sum(146),[G0tensor(188)])
  call ol_merge_tensors(T0sum(147),[G0tensor(221)])
  call ol_merge_tensors(T0sum(148),[G0tensor(227)])
  call ol_merge_tensors(T0sum(149),[G0tensor(139)])
  call ol_merge_tensors(T0sum(150),[G0tensor(37)])
  call ol_merge_tensors(T0sum(151),[G0tensor(33)])
  call ol_merge_tensors(T0sum(152),[G0tensor(126)])
  call ol_merge_tensors(T0sum(153),[G0tensor(124)])
  call ol_merge_tensors(T0sum(154),[G0tensor(232)])
  call ol_merge_tensors(T0sum(155),[G0tensor(242)])
  call ol_merge_tensors(T0sum(156),[G0tensor(49)])
  call ol_merge_tensors(T0sum(157),[G0tensor(84)])
  call ol_merge_tensors(T0sum(158),[G0tensor(80)])
  call ol_merge_tensors(T0sum(159),[G0tensor(94)])
  call ol_merge_tensors(T0sum(160),[G0tensor(259)])
  call ol_merge_tensors(T0sum(161),[G0tensor(57)])
  call ol_merge_tensors(T0sum(162),[G0tensor(8)])
  call ol_merge_tensors(T0sum(163),[G0tensor(170)])
  call ol_merge_tensors(T0sum(164),[G0tensor(211)])
  call ol_merge_tensors(T0sum(165),[G0tensor(9)])
  call ol_merge_tensors(T0sum(166),[G0tensor(185)])
  call ol_merge_tensors(T0sum(167),[G0tensor(247)])
  call ol_merge_tensors(T0sum(168),[G0tensor(266)])
  call ol_merge_tensors(T0sum(169),[G0tensor(167)])
  call ol_merge_tensors(T0sum(170),[G0tensor(150)])
  call ol_merge_tensors(T0sum(171),[G0tensor(235)])
  call ol_merge_tensors(T0sum(172),[G0tensor(59)])
  call ol_merge_tensors(T0sum(173),[G0tensor(73)])
  call ol_merge_tensors(T0sum(174),[G0tensor(119)])
  call ol_merge_tensors(T0sum(175),[G0tensor(182)])
  call ol_merge_tensors(T0sum(176),[G0tensor(256)])
  call ol_merge_tensors(T0sum(177),[G0tensor(260)])
  call ol_merge_tensors(T0sum(178),[G0tensor(286)])
  call ol_merge_tensors(T0sum(179),[G0tensor(250)])
  call ol_merge_tensors(T0sum(180),[G0tensor(275)])
  call ol_merge_tensors(T0sum(181),[G0tensor(289)])
  call ol_merge_tensors(T0sum(182),[G0tensor(295)])
  call ol_merge_tensors(T0sum(183),[G0tensor(253)])
  call ol_merge_tensors(T0sum(184),[G0tensor(263)])
  call ol_merge_tensors(T0sum(185),[G0tensor(273)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 18, 19, 23 ],masses2_50,RedSet_4(1),ScalarBoxes(1))
  call compute_scalar_box([ 16, 19, 23 ],masses2_60,RedSet_4(2),ScalarBoxes(2))
  call compute_scalar_box([ 16, 18, 23 ],masses2_57,RedSet_4(3),ScalarBoxes(3))
  call compute_scalar_box([ 16, 18, 19 ],masses2_59,RedSet_4(4),ScalarBoxes(4))
  call compute_scalar_box([ 2, 3, 7 ],masses2_50,RedSet_4(5),ScalarBoxes(5))
  call compute_scalar_box([ 18, 19, 23 ],masses2_51,RedSet_4(1),ScalarBoxes(6))
  call compute_scalar_box([ 16, 19, 23 ],masses2_56,RedSet_4(2),ScalarBoxes(7))
  call compute_scalar_box([ 16, 18, 23 ],masses2_53,RedSet_4(3),ScalarBoxes(8))
  call compute_scalar_box([ 16, 18, 19 ],masses2_55,RedSet_4(4),ScalarBoxes(9))
  call compute_scalar_box([ 2, 3, 7 ],masses2_51,RedSet_4(5),ScalarBoxes(10))
  call compute_scalar_box([ 18, 19, 27 ],masses2_50,RedSet_4(6),ScalarBoxes(11))
  call compute_scalar_box([ 16, 19, 27 ],masses2_60,RedSet_4(7),ScalarBoxes(12))
  call compute_scalar_box([ 16, 18, 27 ],masses2_57,RedSet_4(8),ScalarBoxes(13))
  call compute_scalar_box([ 2, 3, 11 ],masses2_50,RedSet_4(9),ScalarBoxes(14))
  call compute_scalar_box([ 18, 19, 27 ],masses2_51,RedSet_4(6),ScalarBoxes(15))
  call compute_scalar_box([ 16, 19, 27 ],masses2_56,RedSet_4(7),ScalarBoxes(16))
  call compute_scalar_box([ 16, 18, 27 ],masses2_53,RedSet_4(8),ScalarBoxes(17))
  call compute_scalar_box([ 2, 3, 11 ],masses2_51,RedSet_4(9),ScalarBoxes(18))
  call compute_scalar_box([ 17, 19, 23 ],masses2_50,RedSet_4(10),ScalarBoxes(19))
  call compute_scalar_box([ 16, 17, 23 ],masses2_57,RedSet_4(11),ScalarBoxes(20))
  call compute_scalar_box([ 16, 17, 19 ],masses2_59,RedSet_4(12),ScalarBoxes(21))
  call compute_scalar_box([ 1, 3, 7 ],masses2_50,RedSet_4(13),ScalarBoxes(22))
  call compute_scalar_box([ 17, 19, 23 ],masses2_49,RedSet_4(10),ScalarBoxes(23))
  call compute_scalar_box([ 16, 19, 23 ],masses2_53,RedSet_4(2),ScalarBoxes(24))
  call compute_scalar_box([ 16, 17, 23 ],masses2_53,RedSet_4(11),ScalarBoxes(25))
  call compute_scalar_box([ 16, 17, 19 ],masses2_53,RedSet_4(12),ScalarBoxes(26))
  call compute_scalar_box([ 1, 3, 7 ],masses2_49,RedSet_4(13),ScalarBoxes(27))
  call compute_scalar_box([ 17, 19, 23 ],masses2_51,RedSet_4(10),ScalarBoxes(28))
  call compute_scalar_box([ 16, 17, 19 ],masses2_55,RedSet_4(12),ScalarBoxes(29))
  call compute_scalar_box([ 1, 3, 7 ],masses2_51,RedSet_4(13),ScalarBoxes(30))
  call compute_scalar_box([ 17, 19, 27 ],masses2_50,RedSet_4(14),ScalarBoxes(31))
  call compute_scalar_box([ 16, 17, 27 ],masses2_57,RedSet_4(15),ScalarBoxes(32))
  call compute_scalar_box([ 1, 3, 11 ],masses2_50,RedSet_4(16),ScalarBoxes(33))
  call compute_scalar_box([ 17, 19, 27 ],masses2_49,RedSet_4(14),ScalarBoxes(34))
  call compute_scalar_box([ 16, 19, 27 ],masses2_53,RedSet_4(7),ScalarBoxes(35))
  call compute_scalar_box([ 16, 17, 27 ],masses2_53,RedSet_4(15),ScalarBoxes(36))
  call compute_scalar_box([ 1, 3, 11 ],masses2_49,RedSet_4(16),ScalarBoxes(37))
  call compute_scalar_box([ 17, 19, 27 ],masses2_51,RedSet_4(14),ScalarBoxes(38))
  call compute_scalar_box([ 1, 3, 11 ],masses2_51,RedSet_4(16),ScalarBoxes(39))
! end of process


end subroutine vamp_1

end module ol_vamp_1_pphll_ew_nexeudxh_1_/**/REALKIND
