
module ol_vamp_1_pphll_ew_eexuuxh_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphll_ew_eexuuxh_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphll_ew_eexuuxh_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pphll_ew_eexuuxh_1_/**/DREALKIND
  use ol_tensor_sum_storage_pphll_ew_eexuuxh_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pphll_ew_eexuuxh_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pphll_ew_eexuuxh_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(41)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(1),h0tab(:,1),[16,2,1,4,8],[nMZ,0,0,0,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(2),m3h1x16(:,1),heltab2x16(:,:,1))
  Gcoeff(:)%j = (c(42)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(2),h0tab(:,2),[16,2,1,4,8],[nMZ,0,nMZ,0,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(3),m3h1x16(:,2),heltab2x16(:,:,2))
  Gcoeff(:)%j = (c(9)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(3),h0tab(:,3),[16,2,1,4,8],[nMW,0,nMW,0,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(4),m3h1x16(:,3),heltab2x16(:,:,3))
  Gcoeff(:)%j = (-(c(41)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(4),h0tab(:,4),[16,2,1,8,4],[nMZ,0,0,0,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(5),m3h1x16(:,4),heltab2x16(:,:,4))
  Gcoeff(:)%j = (c(42)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(5),h0tab(:,5),[16,2,1,8,4],[nMZ,0,nMZ,0,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(6),m3h1x16(:,5),heltab2x16(:,:,5))
  Gcoeff(:)%j = (-(c(41)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(6),h0tab(:,6),[16,1,2,4,8],[nMZ,0,0,0,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(7),m3h1x16(:,6),heltab2x16(:,:,6))
  Gcoeff(:)%j = (c(42)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(7),h0tab(:,7),[16,1,2,4,8],[nMZ,0,nMZ,0,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(8),m3h1x16(:,7),heltab2x16(:,:,7))
  Gcoeff(:)%j = (-(c(41)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(8),h0tab(:,8),[16,1,2,8,4],[nMZ,0,0,0,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(9),m3h1x16(:,8),heltab2x16(:,:,8))
  Gcoeff(:)%j = (c(42)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(9),h0tab(:,9),[16,1,2,8,4],[nMZ,0,nMZ,0,nMZ],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(10),m3h1x16(:,9),heltab2x16(:,:,9))
  Gcoeff(:)%j = (c(9)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(10),h0tab(:,10),[16,1,2,8,4],[nMW,0,nMW,0,nMW],5,0)
  call Hloop_VS_V(ntryL,G0H16(1),ex5(:),G0H16(11),m3h1x16(:,10),heltab2x16(:,:,10))
  call Hloop_ZA_Q(ntryL,G0H16(2),ex2(:),G0H8(1),ngZl,m3h2x8(:,1),heltab2x16(:,:,11))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(1),n2h8(1))
  call Hloop_ZA_Q(ntryL,G0H16(3),ex2(:),G0H8(1),ngZl,m3h2x8(:,2),heltab2x16(:,:,12))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(2),n2h8(2))
  call Hloop_WA_Q(ntryL,G0H16(4),ex2(:),G0H8(1),m3h2x8(:,3),heltab2x16(:,:,13))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(3),n2h8(3))
  call Hloop_ZA_Q(ntryL,G0H16(5),ex2(:),G0H8(1),ngZl,m3h2x8(:,4),heltab2x16(:,:,14))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(4),n2h8(4))
  call Hloop_ZA_Q(ntryL,G0H16(6),ex2(:),G0H8(1),ngZl,m3h2x8(:,5),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(5),n2h8(5))
  call Hloop_ZQ_A(ntryL,G0H16(7),ex1(:),G0H8(1),ngZl,m3h2x8(:,6),heltab2x16(:,:,16))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(6),n2h8(6))
  call Hloop_ZQ_A(ntryL,G0H16(8),ex1(:),G0H8(1),ngZl,m3h2x8(:,7),heltab2x16(:,:,17))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(7),n2h8(7))
  call Hloop_ZQ_A(ntryL,G0H16(9),ex1(:),G0H8(1),ngZl,m3h2x8(:,8),heltab2x16(:,:,18))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(8),n2h8(8))
  call Hloop_ZQ_A(ntryL,G0H16(10),ex1(:),G0H8(1),ngZl,m3h2x8(:,9),heltab2x16(:,:,19))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(9),n2h8(9))
  call Hloop_WQ_A(ntryL,G0H16(11),ex1(:),G0H8(1),m3h2x8(:,10),heltab2x16(:,:,20))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(10),n2h8(10))
  call Hloop_AQ_V(ntryL,G1H8(1),ex1(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_AQ_Z(ntryL,G1H8(2),ex1(:),G1H4(2),ngZl,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_AQ_W(ntryL,G1H8(3),ex1(:),G1H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_AQ_V(ntryL,G1H8(4),ex1(:),G1H4(4),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_AQ_Z(ntryL,G1H8(5),ex1(:),G1H4(5),ngZl,m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_QA_V(ntryL,G1H8(6),ex2(:),G1H4(6),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_QA_Z(ntryL,G1H8(7),ex2(:),G1H4(7),ngZl,m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_QA_V(ntryL,G1H8(8),ex2(:),G1H4(8),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_QA_Z(ntryL,G1H8(9),ex2(:),G1H4(9),ngZl,m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_QA_W(ntryL,G1H8(10),ex2(:),G1H4(10),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_VQ_A(ntryL,G1H4(1),ex3(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(1),n2h2(1))
  call Hloop_ZQ_A(ntryL,G1H4(2),ex3(:),G1H2(1),ngZu,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(2),n2h2(2))
  call Hloop_WQ_A(ntryL,G1H4(3),ex3(:),G1H2(1),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(3),n2h2(3))
  call Hloop_VA_Q(ntryL,G1H4(4),ex4(:),G1H2(1),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(4),n2h2(4))
  call Hloop_ZA_Q(ntryL,G1H4(5),ex4(:),G1H2(1),ngZu,m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(5),n2h2(5))
  call Hloop_VQ_A(ntryL,G1H4(6),ex3(:),G1H2(1),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(6),n2h2(6))
  call Hloop_ZQ_A(ntryL,G1H4(7),ex3(:),G1H2(1),ngZu,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(7),n2h2(7))
  call Hloop_VA_Q(ntryL,G1H4(8),ex4(:),G1H2(1),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(8),n2h2(8))
  call Hloop_ZA_Q(ntryL,G1H4(9),ex4(:),G1H2(1),ngZu,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(9),n2h2(9))
  call Hloop_WA_Q(ntryL,G1H4(10),ex4(:),G1H2(1),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(10),n2h2(10))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(1),ex4(:),G2tensor(1),ngZu,m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(2),ex4(:),G2tensor(2),ngZu,m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(3),ex4(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(4),ex3(:),G2tensor(4),ngZu,m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(5),ex3(:),G2tensor(5),ngZu,m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(6),ex4(:),G2tensor(6),ngZu,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(7),ex4(:),G2tensor(7),ngZu,m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(8),ex3(:),G2tensor(8),ngZu,m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(9),ex3(:),G2tensor(9),ngZu,m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(10),ex3(:),G2tensor(10),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(1),mass5set(:,2),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(1),mass5set(:,3),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
  call G_TensorShift(G1tensor(14),8)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(2),mass5set(:,1),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
  call G_TensorShift(G1tensor(20),4)
  call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(2),mass5set(:,2),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(26),4)
  call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(3),mass5set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(3),mass5set(:,2),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(38),8)
  call Hotf_5pt_reduction_last(G2tensor(8),RedSet_5(4),mass5set(:,1),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
  call G_TensorShift(G1tensor(44),4)
  call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(4),mass5set(:,2),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
  call G_TensorShift(G1tensor(50),4)
  call Hotf_5pt_reduction_last(G2tensor(10),RedSet_5(4),mass5set(:,3),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(56),4)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  call ol_merge_tensors(T1sum(3),[G1tensor(13)])
  call ol_merge_tensors(T1sum(4),[G1tensor(19)])
  call ol_merge_tensors(T1sum(5),[G1tensor(25)])
  call ol_merge_tensors(T1sum(6),[G1tensor(31)])
  call ol_merge_tensors(T1sum(7),[G1tensor(37)])
  call ol_merge_tensors(T1sum(8),[G1tensor(43)])
  call ol_merge_tensors(T1sum(9),[G1tensor(49)])
  call ol_merge_tensors(T1sum(10),[G1tensor(55)])
  Gcoeff(:)%j = (c(15)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(11),h0tab(:,11),[16,3,8,4],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_VT_S(ntryL,G0H16(1),0,ex5(:),16,G1H16(1),m3h1x16(:,11),heltab2x16(:,:,21))
  Gcoeff(:)%j = (c(27)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(12),h0tab(:,12),[16,3,8,4],[nMW,nMW,0,nMW],4,1,wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(2),0,ex5(:),16,G1H16(2),m3h1x16(:,12),heltab2x16(:,:,22))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(3),m0h(13),h0tab(:,13),[16,3,8,4],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_VS_V(ntryL,G0H16(3),ex5(:),G0H16(4),m3h1x16(:,13),heltab2x16(:,:,23))
  Gcoeff(:)%j = (c(11)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(5),m0h(14),h0tab(:,14),[16,3,8,4],[nMW,nMW,0,nMW],4,1,wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(5),ex5(:),G0H16(6),m3h1x16(:,14),heltab2x16(:,:,24))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(15),h0tab(:,15),[16,3,4,8],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_VT_S(ntryL,G0H16(7),0,ex5(:),16,G1H16(3),m3h1x16(:,15),heltab2x16(:,:,25))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(16),h0tab(:,16),[16,3,4,8],[nMW,nMW,0,nMW],4,1,wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(8),0,ex5(:),16,G1H16(4),m3h1x16(:,16),heltab2x16(:,:,26))
  Gcoeff(:)%j = (-(c(17)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(9),m0h(17),h0tab(:,17),[16,3,4,8],[nMW,nMW,0,nMW],4,1,wf4(:,4))
  call Hloop_VS_V(ntryL,G0H16(9),ex5(:),G0H16(10),m3h1x16(:,17),heltab2x16(:,:,27))
  Gcoeff(:)%j = (c(11)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(11),m0h(18),h0tab(:,18),[16,3,4,8],[nMW,nMW,0,nMW],4,1,wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(11),ex5(:),G0H16(1),m3h1x16(:,18),heltab2x16(:,:,28))
  Gcoeff(:)%j = (-(c(41)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(19),h0tab(:,19),[16,4,3,8],[nMZ,0,0,nMZ],4,1,wf4(:,4))
  call Hloop_VS_V(ntryL,G0H16(2),ex5(:),G0H16(3),m3h1x16(:,19),heltab2x16(:,:,29))
  Gcoeff(:)%j = (c(14)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(5),m0h(20),h0tab(:,20),[16,4,3,8],[nMW,0,0,nMW],4,1,wf4(:,4))
  call Hloop_VS_V(ntryL,G0H16(5),ex5(:),G0H16(7),m3h1x16(:,20),heltab2x16(:,:,30))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(21),h0tab(:,21),[16,4,3,8],[nMZ,0,0,nMZ],4,1,wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(9),m3h1x16(:,21),heltab2x16(:,:,31))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(11),m0h(22),h0tab(:,22),[16,4,3,8],[nMW,0,0,nMW],4,1,wf4(:,1))
  call Hloop_VS_V(ntryL,G0H16(11),ex5(:),G0H16(2),m3h1x16(:,22),heltab2x16(:,:,32))
  Gcoeff(:)%j = (c(14)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(5),m0h(23),h0tab(:,23),[16,1,2,12],[nMW,0,nMW,nMW],4,1,wf4(:,5))
  call Hloop_ST_V(ntryL,G0H16(5),0,ex5(:),16,G1H16(5),m3h1x16(:,23),heltab2x16(:,:,33))
  Gcoeff(:)%j = (-(c(27)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(24),h0tab(:,24),[16,1,2,12],[nMW,0,nMW,nMW],4,1,wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(8),0,ex5(:),16,G1H16(6),m3h1x16(:,24),heltab2x16(:,:,34))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(11),m0h(25),h0tab(:,25),[16,1,2,12],[nMW,0,nMW,nMW],4,1,wf4(:,5))
  call Hloop_VS_V(ntryL,G0H16(11),ex5(:),G0H16(5),m3h1x16(:,25),heltab2x16(:,:,35))
  Gcoeff(:)%j = (c(11)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(26),h0tab(:,26),[16,1,2,12],[nMW,0,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(11),m3h1x16(:,26),heltab2x16(:,:,36))
  Gcoeff(:)%j = (-(c(14)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(27),h0tab(:,27),[16,2,1,12],[nMW,0,nMW,nMW],4,1,wf4(:,5))
  call Hloop_ST_V(ntryL,G0H16(8),0,ex5(:),16,G1H16(7),m3h1x16(:,27),heltab2x16(:,:,37))
  Gcoeff(:)%j = (c(27)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(28),h0tab(:,28),[16,2,1,12],[nMW,0,nMW,nMW],4,1,wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(8),0,ex5(:),16,G1H16(8),m3h1x16(:,28),heltab2x16(:,:,38))
  Gcoeff(:)%j = (c(16)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(29),h0tab(:,29),[16,2,1,12],[nMW,0,nMW,nMW],4,1,wf4(:,5))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(12),m3h1x16(:,29),heltab2x16(:,:,39))
  Gcoeff(:)%j = (c(11)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(30),h0tab(:,30),[16,2,1,12],[nMW,0,nMW,nMW],4,1,wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(13),m3h1x16(:,30),heltab2x16(:,:,40))
  Gcoeff(:)%j = (-(c(41)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(31),h0tab(:,31),[16,1,12,2],[nMZ,0,0,nMZ],4,1,wf4(:,5))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(14),m3h1x16(:,31),heltab2x16(:,:,41))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(32),h0tab(:,32),[16,1,12,2],[nMZ,0,0,nMZ],4,1,wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(15),m3h1x16(:,32),heltab2x16(:,:,42))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(33),h0tab(:,33),[16,1,12,2],[nMW,0,0,nMW],4,1,wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(16),m3h1x16(:,33),heltab2x16(:,:,43))
  call Hloop_SV_V(ntryL,G1H16(1),wf4(:,4),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,44))
  call Hloop_SV_V(ntryL,G1H16(2),wf4(:,1),G1H4(2),m3h4x4(:,2),heltab2x16(:,:,45))
  call Hloop_UW_V(ntryL,G0H16(4),16,wf4(:,4),3,G1H4(3),m3h4x4(:,3),heltab2x16(:,:,46))
  call Hloop_UW_V(ntryL,G0H16(6),16,wf4(:,1),3,G1H4(4),m3h4x4(:,4),heltab2x16(:,:,47))
  call Hloop_SV_V(ntryL,G1H16(3),wf4(:,4),G1H4(5),m3h4x4(:,5),heltab2x16(:,:,48))
  call Hloop_SV_V(ntryL,G1H16(4),wf4(:,1),G1H4(6),m3h4x4(:,6),heltab2x16(:,:,49))
  call Hloop_UV_W(ntryL,G0H16(10),16,wf4(:,4),3,G1H4(7),m3h4x4(:,7),heltab2x16(:,:,50))
  call Hloop_UV_W(ntryL,G0H16(1),16,wf4(:,1),3,G1H4(8),m3h4x4(:,8),heltab2x16(:,:,51))
  call Hloop_ZQ_A(ntryL,G0H16(3),ex3(:),G0H8(1),ngZu,m3h2x8(:,11),heltab2x16(:,:,52))
  call Hloop_Q_A(ntryL,G0H8(1),20,0,G1H8(1),n2h8(11))
  call Hloop_WQ_A(ntryL,G0H16(7),ex3(:),G0H8(1),m3h2x8(:,12),heltab2x16(:,:,53))
  call Hloop_Q_A(ntryL,G0H8(1),20,0,G1H8(2),n2h8(12))
  call Hloop_ZQ_A(ntryL,G0H16(9),ex3(:),G0H8(1),ngZu,m3h2x8(:,13),heltab2x16(:,:,54))
  call Hloop_Q_A(ntryL,G0H8(1),20,0,G1H8(3),n2h8(13))
  call Hloop_WQ_A(ntryL,G0H16(2),ex3(:),G0H8(1),m3h2x8(:,14),heltab2x16(:,:,55))
  call Hloop_Q_A(ntryL,G0H8(1),20,0,G1H8(4),n2h8(14))
  call Hloop_WQ_A(ntryL,G1H16(5),ex1(:),G1H8(5),m3h2x8(:,15),heltab2x16(:,:,56))
  call Hloop_Q_A(ntryL,G1H8(5),17,0,G2H8(1),n2h8(15))
  call Hloop_WQ_A(ntryL,G1H16(6),ex1(:),G1H8(6),m3h2x8(:,16),heltab2x16(:,:,57))
  call Hloop_Q_A(ntryL,G1H8(6),17,0,G2H8(2),n2h8(16))
  call Hloop_WQ_A(ntryL,G0H16(5),ex1(:),G0H8(1),m3h2x8(:,17),heltab2x16(:,:,58))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(7),n2h8(17))
  call Hloop_WQ_A(ntryL,G0H16(11),ex1(:),G0H8(1),m3h2x8(:,18),heltab2x16(:,:,59))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(8),n2h8(18))
  call Hloop_WA_Q(ntryL,G1H16(7),ex2(:),G1H8(9),m3h2x8(:,19),heltab2x16(:,:,60))
  call Hloop_A_Q(ntryL,G1H8(9),18,0,G2H8(3),n2h8(19))
  call Hloop_WA_Q(ntryL,G1H16(8),ex2(:),G1H8(10),m3h2x8(:,20),heltab2x16(:,:,61))
  call Hloop_A_Q(ntryL,G1H8(10),18,0,G2H8(4),n2h8(20))
  call Hloop_WA_Q(ntryL,G0H16(12),ex2(:),G0H8(1),m3h2x8(:,21),heltab2x16(:,:,62))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(5),n2h8(21))
  call Hloop_WA_Q(ntryL,G0H16(13),ex2(:),G0H8(1),m3h2x8(:,22),heltab2x16(:,:,63))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(6),n2h8(22))
  call Hloop_ZQ_A(ntryL,G0H16(14),ex1(:),G0H8(1),ngZl,m3h2x8(:,23),heltab2x16(:,:,64))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(9),n2h8(23))
  call Hloop_ZQ_A(ntryL,G0H16(15),ex1(:),G0H8(1),ngZl,m3h2x8(:,24),heltab2x16(:,:,65))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(10),n2h8(24))
  call Hloop_WQ_A(ntryL,G0H16(16),ex1(:),G0H8(1),m3h2x8(:,25),heltab2x16(:,:,66))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(11),n2h8(25))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(4),[G1H4(3),G1H4(2),G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(7),G1H4(6),G1H4(5)])
  call Hloop_WA_Q(ntryL,G1H4(4),ex4(:),G1H2(1),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(1),27,0,G2H2(1),n2h2(11))
  call Hloop_WQ_A(ntryL,G1H4(8),ex3(:),G1H2(1),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(2),n2h2(12))
  call Hloop_QV_A(ntryL,G1H8(1),wf4(:,4),G1H2(1),m3h4x2(:,1),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(3),n2h2(13))
  call Hloop_QV_A(ntryL,G1H8(2),wf4(:,4),G1H2(1),m3h4x2(:,2),heltab2x8(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(4),n2h2(14))
  call Hloop_QZ_A(ntryL,G1H8(3),wf4(:,1),G1H2(1),ngZu,m3h4x2(:,3),heltab2x8(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(5),n2h2(15))
  call Hloop_QZ_A(ntryL,G1H8(4),wf4(:,1),G1H2(1),ngZd,m3h4x2(:,4),heltab2x8(:,:,14))
  call Hloop_Q_A(ntryL,G1H2(1),23,0,G2H2(6),n2h2(16))
  call Hloop_QA_W(ntryL,G2H8(1),ex2(:),G2H4(1),m3h2x4(:,11),heltab2x8(:,:,15))
  call Hloop_QA_W(ntryL,G2H8(2),ex2(:),G2H4(2),m3h2x4(:,12),heltab2x8(:,:,16))
  call Hloop_QA_W(ntryL,G1H8(7),ex2(:),G1H4(9),m3h2x4(:,13),heltab2x8(:,:,17))
  call Hloop_QA_W(ntryL,G1H8(8),ex2(:),G1H4(10),m3h2x4(:,14),heltab2x8(:,:,18))
  call Hloop_AQ_W(ntryL,G2H8(3),ex1(:),G2H4(3),m3h2x4(:,15),heltab2x8(:,:,19))
  call Hloop_AQ_W(ntryL,G2H8(4),ex1(:),G2H4(4),m3h2x4(:,16),heltab2x8(:,:,20))
  call Hloop_AQ_W(ntryL,G1H8(5),ex1(:),G1H4(3),m3h2x4(:,17),heltab2x8(:,:,21))
  call Hloop_AQ_W(ntryL,G1H8(6),ex1(:),G1H4(2),m3h2x4(:,18),heltab2x8(:,:,22))
  call Hloop_QV_A(ntryL,G1H8(9),wf4(:,5),G1H2(1),m3h4x2(:,5),heltab2x8(:,:,23))
  call Hloop_Q_A(ntryL,G1H2(1),29,0,G2H2(7),n2h2(17))
  call Hloop_QZ_A(ntryL,G1H8(10),wf4(:,2),G1H2(1),ngZl,m3h4x2(:,6),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H2(1),29,0,G2H2(8),n2h2(18))
  call Hloop_QZ_A(ntryL,G1H8(11),wf4(:,2),G1H2(1),ngZn,m3h4x2(:,7),heltab2x8(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(1),29,0,G2H2(9),n2h2(19))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G2H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G2H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G2H2(7)])
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(1),ex3(:),G2tensor(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(2),ex4(:),G2tensor(2),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(5),ex4(:),G2tensor(3),ngZu,m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(6),ex4(:),G2tensor(4),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(1),wf4(:,5),G2tensor(5),m3h4x1(:,1),heltab2x4(:,:,13))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(2),wf4(:,2),G2tensor(6),m3h4x1(:,2),heltab2x4(:,:,14))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(9),19,wf4(:,5),12,G2tensor(7),m3h4x1(:,3),heltab2x4(:,:,15))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(10),19,wf4(:,2),12,G2tensor(8),m3h4x1(:,4),heltab2x4(:,:,16))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(3),wf4(:,5),G2tensor(9),m3h4x1(:,5),heltab2x4(:,:,17))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(4),wf4(:,2),G2tensor(10),m3h4x1(:,6),heltab2x4(:,:,18))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(3),19,wf4(:,5),12,G2tensor(11),m3h4x1(:,7),heltab2x4(:,:,19))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(2),19,wf4(:,2),12,G2tensor(12),m3h4x1(:,8),heltab2x4(:,:,20))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(8),ex2(:),G2tensor(13),ngZl,m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(9),ex2(:),G2tensor(14),m3h2x1(:,16),heltab2x2(:,:,16))
  call ol_merge_tensors(G1tensor(34),[G1tensor(4)])
  call ol_merge_tensors(G1tensor(11),[G1tensor(5)])
  call ol_merge_tensors(G1tensor(24),[G1tensor(6)])
  call ol_merge_tensors(G1tensor(40),[G1tensor(10)])
  call ol_merge_tensors(G1tensor(30),[G1tensor(12)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(16)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(11),G2tensor(10),G2tensor(9),G1tensor(18)])
  call ol_merge_tensors(G1tensor(46),[G1tensor(22)])
  call ol_merge_tensors(G1tensor(29),[G1tensor(23)])
  call ol_merge_tensors(G1tensor(52),[G1tensor(28)])
  call ol_merge_tensors(G1tensor(41),[G1tensor(35)])
  call ol_merge_tensors(G1tensor(48),[G1tensor(36)])
  call ol_merge_tensors(G1tensor(54),[G1tensor(42)])
  call ol_merge_tensors(G1tensor(53),[G1tensor(47)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(58)])
  call ol_merge_tensors(G2tensor(8),[G2tensor(7),G2tensor(6),G2tensor(5),G1tensor(60)])
  call Hotf_4pt_reduction_last(G2tensor(2),RedSet_4(2),mass4set(:,1),  & 
G1tensor(1),G1tensor(7),G1tensor(13),G1tensor(19),G1tensor(25))
  call G_TensorShift(G1tensor(7),8)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(4),mass4set(:,2),  & 
G1tensor(31),G1tensor(37),G1tensor(43),G1tensor(49),G1tensor(55))
  call G_TensorShift(G1tensor(37),12)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(7),mass4set(:,1),  & 
G1tensor(4),G1tensor(5),G1tensor(6),G1tensor(10),G1tensor(12))
  call G_TensorShift(G1tensor(5),4)
  call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(12),mass4set(:,2),  & 
G1tensor(16),G1tensor(18),G1tensor(22),G1tensor(23),G1tensor(28))
  call G_TensorShift(G1tensor(18),12)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(17),mass4set(:,3),  & 
G1tensor(35),G1tensor(36),G1tensor(42),G1tensor(47),G1tensor(58))
  call G_TensorShift(G1tensor(36),8)
  call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(17),mass4set(:,4),  & 
G1tensor(60),G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64))
  call G_TensorShift(G1tensor(61),8)
  call Hotf_4pt_reduction_last(G2tensor(13),RedSet_4(18),mass4set(:,3),  & 
G1tensor(65),G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69))
  call G_TensorShift(G1tensor(66),2)
  call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(18),mass4set(:,4),  & 
G1tensor(70),G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74))
  call G_TensorShift(G1tensor(71),2)
  call Hotf_4pt_reduction_last(G1tensor(2),RedSet_4(19),mass4set(:,5),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(3),RedSet_4(1),mass4set(:,6),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(34),RedSet_4(2),mass4set(:,3),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(3),mass4set(:,3),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(24),RedSet_4(4),mass4set(:,3),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(8),RedSet_4(19),mass4set(:,7),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(9),RedSet_4(1),mass4set(:,8),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(40),RedSet_4(2),mass4set(:,9),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(30),RedSet_4(4),mass4set(:,10),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(14),RedSet_4(19),mass4set(:,11),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(15),RedSet_4(1),mass4set(:,12),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(2),mass4set(:,1),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(17),RedSet_4(3),mass4set(:,4),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(4),mass4set(:,2),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(20),RedSet_4(20),mass4set(:,5),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(6),mass4set(:,6),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(7),mass4set(:,3),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(29),RedSet_4(8),mass4set(:,3),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(20),mass4set(:,7),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(27),RedSet_4(6),mass4set(:,8),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(52),RedSet_4(7),mass4set(:,9),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(32),RedSet_4(21),mass4set(:,5),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(33),RedSet_4(10),mass4set(:,6),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(11),mass4set(:,3),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
  call Hotf_4pt_reduction_last(G1tensor(48),RedSet_4(12),mass4set(:,3),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
  call Hotf_4pt_reduction_last(G1tensor(38),RedSet_4(21),mass4set(:,7),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
  call Hotf_4pt_reduction_last(G1tensor(39),RedSet_4(10),mass4set(:,8),  & 
G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135))
  call Hotf_4pt_reduction_last(G1tensor(54),RedSet_4(12),mass4set(:,10),  & 
G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140))
  call Hotf_4pt_reduction_last(G1tensor(44),RedSet_4(22),mass4set(:,5),  & 
G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144),G0tensor(145))
  call Hotf_4pt_reduction_last(G1tensor(45),RedSet_4(14),mass4set(:,6),  & 
G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149),G0tensor(150))
  call Hotf_4pt_reduction_last(G1tensor(53),RedSet_4(15),mass4set(:,3),  & 
G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154),G0tensor(155))
  call Hotf_4pt_reduction_last(G1tensor(50),RedSet_4(22),mass4set(:,7),  & 
G0tensor(156),G0tensor(157),G0tensor(158),G0tensor(159),G0tensor(160))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(14),mass4set(:,8),  & 
G0tensor(161),G0tensor(162),G0tensor(163),G0tensor(164),G0tensor(165))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(22),mass4set(:,11),  & 
G0tensor(166),G0tensor(167),G0tensor(168),G0tensor(169),G0tensor(170))
  call Hotf_4pt_reduction_last(G1tensor(57),RedSet_4(14),mass4set(:,12),  & 
G0tensor(171),G0tensor(172),G0tensor(173),G0tensor(174),G0tensor(175))
  call Hotf_4pt_reduction_last(G1tensor(4),RedSet_4(7),mass4set(:,1),  & 
G0tensor(176),G0tensor(177),G0tensor(178),G0tensor(179),G0tensor(180))
  call Hotf_4pt_reduction_last(G1tensor(59),RedSet_4(15),mass4set(:,4),  & 
G0tensor(181),G0tensor(182),G0tensor(183),G0tensor(184),G0tensor(185))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(12),mass4set(:,2),  & 
G0tensor(186),G0tensor(187),G0tensor(188),G0tensor(189),G0tensor(190))
  call Hotf_4pt_reduction_last(G1tensor(35),RedSet_4(17),mass4set(:,3),  & 
G0tensor(191),G0tensor(192),G0tensor(193),G0tensor(194),G0tensor(195))
  call Hotf_4pt_reduction_last(G1tensor(60),RedSet_4(17),mass4set(:,4),  & 
G0tensor(196),G0tensor(197),G0tensor(198),G0tensor(199),G0tensor(200))
  call Hotf_4pt_reduction_last(G1tensor(65),RedSet_4(18),mass4set(:,3),  & 
G0tensor(201),G0tensor(202),G0tensor(203),G0tensor(204),G0tensor(205))
  call Hotf_4pt_reduction_last(G1tensor(70),RedSet_4(18),mass4set(:,4),  & 
G0tensor(206),G0tensor(207),G0tensor(208),G0tensor(209),G0tensor(210))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  call ol_merge_tensors(T0sum(21),[G0tensor(101)])
  call ol_merge_tensors(T0sum(22),[G0tensor(106)])
  call ol_merge_tensors(T0sum(23),[G0tensor(111)])
  call ol_merge_tensors(T0sum(24),[G0tensor(116)])
  call ol_merge_tensors(T0sum(25),[G0tensor(121)])
  call ol_merge_tensors(T0sum(26),[G0tensor(126)])
  call ol_merge_tensors(T0sum(27),[G0tensor(131)])
  call ol_merge_tensors(T0sum(28),[G0tensor(136)])
  call ol_merge_tensors(T0sum(29),[G0tensor(141)])
  call ol_merge_tensors(T0sum(30),[G0tensor(146)])
  call ol_merge_tensors(T0sum(31),[G0tensor(151)])
  call ol_merge_tensors(T0sum(32),[G0tensor(156)])
  call ol_merge_tensors(T0sum(33),[G0tensor(161)])
  call ol_merge_tensors(T0sum(34),[G0tensor(166)])
  call ol_merge_tensors(T0sum(35),[G0tensor(171)])
  call ol_merge_tensors(T0sum(36),[G0tensor(176)])
  call ol_merge_tensors(T0sum(37),[G0tensor(181)])
  call ol_merge_tensors(T0sum(38),[G0tensor(186)])
  call ol_merge_tensors(T0sum(39),[G0tensor(191)])
  call ol_merge_tensors(T0sum(40),[G0tensor(196)])
  call ol_merge_tensors(T0sum(41),[G0tensor(201)])
  call ol_merge_tensors(T0sum(42),[G0tensor(206)])
  Gcoeff(:)%j = (c(78)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(34),h0tab(:,34),[16,3,12],[nMM,nMM,nMM],3,2,wf4(:,4),wf4(:,5))
  call Hloop_AS_Q(ntryL,G0H16(8),ex5(:),G0H16(4),ngH,m3h1x16(:,34),heltab2x16(:,:,67))
  call Hloop_A_Q(ntryL,G0H16(4),16,nMM,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(6),m0h(35),h0tab(:,35),[16,3,12],[nML,nML,nML],3,2,wf4(:,4),wf4(:,5))
  call Hloop_AS_Q(ntryL,G0H16(6),ex5(:),G0H16(10),ngH,m3h1x16(:,35),heltab2x16(:,:,68))
  call Hloop_A_Q(ntryL,G0H16(10),16,nML,G1H16(2),n2h16(2))
  Gcoeff(:)%j = (c(78)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(36),h0tab(:,36),[16,3,12],[nMM,nMM,nMM],3,2,wf4(:,4),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(1),ex5(:),G0H16(3),ngH,m3h1x16(:,36),heltab2x16(:,:,69))
  call Hloop_Q_A(ntryL,G0H16(3),16,nMM,G1H16(3),n2h16(3))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(37),h0tab(:,37),[16,3,12],[nML,nML,nML],3,2,wf4(:,4),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(7),ex5(:),G0H16(9),ngH,m3h1x16(:,37),heltab2x16(:,:,70))
  call Hloop_Q_A(ntryL,G0H16(9),16,nML,G1H16(4),n2h16(4))
  Gcoeff(:)%j = (c(80)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(38),h0tab(:,38),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,4),wf4(:,5))
  call Hloop_AS_Q(ntryL,G0H16(2),ex5(:),G0H16(5),ngH,m3h1x16(:,38),heltab2x16(:,:,71))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMT,G1H16(5),n2h16(5))
  Gcoeff(:)%j = (c(80)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(11),m0h(39),h0tab(:,39),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,4),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(11),ex5(:),G0H16(12),ngH,m3h1x16(:,39),heltab2x16(:,:,72))
  call Hloop_Q_A(ntryL,G0H16(12),16,nMT,G1H16(6),n2h16(6))
  Gcoeff(:)%j = (c(72)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(13),m0h(40),h0tab(:,40),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,4),wf4(:,5))
  call Hloop_AS_Q(ntryL,G0H16(13),ex5(:),G0H16(14),ngH,m3h1x16(:,40),heltab2x16(:,:,73))
  call Hloop_A_Q(ntryL,G0H16(14),16,nMB,G1H16(7),n2h16(7))
  Gcoeff(:)%j = (c(72)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(41),h0tab(:,41),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,4),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(15),ex5(:),G0H16(16),ngH,m3h1x16(:,41),heltab2x16(:,:,74))
  call Hloop_Q_A(ntryL,G0H16(16),16,nMB,G1H16(8),n2h16(8))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(42),h0tab(:,42),[16,3,12],[nMM,nMM,nMM],3,2,wf4(:,4),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(8),ex5(:),G0H16(4),ngH,m3h1x16(:,42),heltab2x16(:,:,75))
  call Hloop_A_Q(ntryL,G0H16(4),16,nMM,G1H16(9),n2h16(9))
  Gcoeff(:)%j = (-(c(77)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(6),m0h(43),h0tab(:,43),[16,3,12],[nML,nML,nML],3,2,wf4(:,4),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(6),ex5(:),G0H16(10),ngH,m3h1x16(:,43),heltab2x16(:,:,76))
  call Hloop_A_Q(ntryL,G0H16(10),16,nML,G1H16(10),n2h16(10))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(44),h0tab(:,44),[16,3,12],[nMM,nMM,nMM],3,2,wf4(:,4),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H16(1),ex5(:),G0H16(3),ngH,m3h1x16(:,44),heltab2x16(:,:,77))
  call Hloop_Q_A(ntryL,G0H16(3),16,nMM,G1H16(11),n2h16(11))
  Gcoeff(:)%j = (-(c(77)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(45),h0tab(:,45),[16,3,12],[nML,nML,nML],3,2,wf4(:,4),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H16(7),ex5(:),G0H16(9),ngH,m3h1x16(:,45),heltab2x16(:,:,78))
  call Hloop_Q_A(ntryL,G0H16(9),16,nML,G1H16(12),n2h16(12))
  Gcoeff(:)%j = (c(82)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(46),h0tab(:,46),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,4),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(2),ex5(:),G0H16(5),ngH,m3h1x16(:,46),heltab2x16(:,:,79))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMT,G1H16(13),n2h16(13))
  Gcoeff(:)%j = (c(82)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(11),m0h(47),h0tab(:,47),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,4),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H16(11),ex5(:),G0H16(12),ngH,m3h1x16(:,47),heltab2x16(:,:,80))
  call Hloop_Q_A(ntryL,G0H16(12),16,nMT,G1H16(14),n2h16(14))
  Gcoeff(:)%j = (-(c(74)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(13),m0h(48),h0tab(:,48),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,4),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(13),ex5(:),G0H16(14),ngH,m3h1x16(:,48),heltab2x16(:,:,81))
  call Hloop_A_Q(ntryL,G0H16(14),16,nMB,G1H16(15),n2h16(15))
  Gcoeff(:)%j = (-(c(74)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(49),h0tab(:,49),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,4),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H16(15),ex5(:),G0H16(16),ngH,m3h1x16(:,49),heltab2x16(:,:,82))
  call Hloop_Q_A(ntryL,G0H16(16),16,nMB,G1H16(16),n2h16(16))
  Gcoeff(:)%j = (c(78)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(50),h0tab(:,50),[16,3,12],[nMM,nMM,nMM],3,2,wf4(:,1),wf4(:,5))
  call Hloop_AS_Q(ntryL,G0H16(8),ex5(:),G0H16(4),ngH,m3h1x16(:,50),heltab2x16(:,:,83))
  call Hloop_A_Q(ntryL,G0H16(4),16,nMM,G1H16(17),n2h16(17))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(6),m0h(51),h0tab(:,51),[16,3,12],[nML,nML,nML],3,2,wf4(:,1),wf4(:,5))
  call Hloop_AS_Q(ntryL,G0H16(6),ex5(:),G0H16(10),ngH,m3h1x16(:,51),heltab2x16(:,:,84))
  call Hloop_A_Q(ntryL,G0H16(10),16,nML,G1H16(18),n2h16(18))
  Gcoeff(:)%j = (c(78)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(52),h0tab(:,52),[16,3,12],[nMM,nMM,nMM],3,2,wf4(:,1),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(1),ex5(:),G0H16(3),ngH,m3h1x16(:,52),heltab2x16(:,:,85))
  call Hloop_Q_A(ntryL,G0H16(3),16,nMM,G1H16(19),n2h16(19))
  Gcoeff(:)%j = (c(76)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(53),h0tab(:,53),[16,3,12],[nML,nML,nML],3,2,wf4(:,1),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(7),ex5(:),G0H16(9),ngH,m3h1x16(:,53),heltab2x16(:,:,86))
  call Hloop_Q_A(ntryL,G0H16(9),16,nML,G1H16(20),n2h16(20))
  Gcoeff(:)%j = (-(c(81)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(54),h0tab(:,54),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,5))
  call Hloop_AS_Q(ntryL,G0H16(2),ex5(:),G0H16(5),ngH,m3h1x16(:,54),heltab2x16(:,:,87))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMT,G1H16(21),n2h16(21))
  Gcoeff(:)%j = (-(c(81)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(11),m0h(55),h0tab(:,55),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(11),ex5(:),G0H16(12),ngH,m3h1x16(:,55),heltab2x16(:,:,88))
  call Hloop_Q_A(ntryL,G0H16(12),16,nMT,G1H16(22),n2h16(22))
  Gcoeff(:)%j = (c(73)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(13),m0h(56),h0tab(:,56),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,5))
  call Hloop_AS_Q(ntryL,G0H16(13),ex5(:),G0H16(14),ngH,m3h1x16(:,56),heltab2x16(:,:,89))
  call Hloop_A_Q(ntryL,G0H16(14),16,nMB,G1H16(23),n2h16(23))
  Gcoeff(:)%j = (c(73)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(57),h0tab(:,57),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(15),ex5(:),G0H16(16),ngH,m3h1x16(:,57),heltab2x16(:,:,90))
  call Hloop_Q_A(ntryL,G0H16(16),16,nMB,G1H16(24),n2h16(24))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(58),h0tab(:,58),[16,3,12],[nMM,nMM,nMM],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(8),ex5(:),G0H16(4),ngH,m3h1x16(:,58),heltab2x16(:,:,91))
  call Hloop_A_Q(ntryL,G0H16(4),16,nMM,G1H16(25),n2h16(25))
  Gcoeff(:)%j = (-(c(77)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(6),m0h(59),h0tab(:,59),[16,3,12],[nML,nML,nML],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(6),ex5(:),G0H16(10),ngH,m3h1x16(:,59),heltab2x16(:,:,92))
  call Hloop_A_Q(ntryL,G0H16(10),16,nML,G1H16(26),n2h16(26))
  Gcoeff(:)%j = (-(c(79)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(60),h0tab(:,60),[16,3,12],[nMM,nMM,nMM],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H16(1),ex5(:),G0H16(3),ngH,m3h1x16(:,60),heltab2x16(:,:,93))
  call Hloop_Q_A(ntryL,G0H16(3),16,nMM,G1H16(27),n2h16(27))
  Gcoeff(:)%j = (-(c(77)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(61),h0tab(:,61),[16,3,12],[nML,nML,nML],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H16(7),ex5(:),G0H16(9),ngH,m3h1x16(:,61),heltab2x16(:,:,94))
  call Hloop_Q_A(ntryL,G0H16(9),16,nML,G1H16(28),n2h16(28))
  Gcoeff(:)%j = (-(c(83)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(62),h0tab(:,62),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(2),ex5(:),G0H16(5),ngH,m3h1x16(:,62),heltab2x16(:,:,95))
  call Hloop_A_Q(ntryL,G0H16(5),16,nMT,G1H16(29),n2h16(29))
  Gcoeff(:)%j = (-(c(83)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(11),m0h(63),h0tab(:,63),[16,3,12],[nMT,nMT,nMT],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H16(11),ex5(:),G0H16(12),ngH,m3h1x16(:,63),heltab2x16(:,:,96))
  call Hloop_Q_A(ntryL,G0H16(12),16,nMT,G1H16(30),n2h16(30))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(13),m0h(64),h0tab(:,64),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,2))
  call Hloop_AS_Q(ntryL,G0H16(13),ex5(:),G0H16(14),ngH,m3h1x16(:,64),heltab2x16(:,:,97))
  call Hloop_A_Q(ntryL,G0H16(14),16,nMB,G1H16(31),n2h16(31))
  Gcoeff(:)%j = (-(c(75)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(65),h0tab(:,65),[16,3,12],[nMB,nMB,nMB],3,2,wf4(:,1),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H16(15),ex5(:),G0H16(16),ngH,m3h1x16(:,65),heltab2x16(:,:,98))
  call Hloop_Q_A(ntryL,G0H16(16),16,nMB,G1H16(32),n2h16(32))
  Gcoeff(:)%j = (-(c(34)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(66),h0tab(:,66),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(8),ex5(:),G0H16(4),m3h1x16(:,66),heltab2x16(:,:,99))
  Gcoeff(:)%j = (-(c(34)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(6),m0h(67),h0tab(:,67),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(6),ex5(:),G0H16(10),m3h1x16(:,67),heltab2x16(:,:,100))
  Gcoeff(:)%j = (-(c(51)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(68),h0tab(:,68),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(3),m3h1x16(:,68),heltab2x16(:,:,101))
  Gcoeff(:)%j = (-(c(51)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(69),h0tab(:,69),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(7),ex5(:),G0H16(9),m3h1x16(:,69),heltab2x16(:,:,102))
  Gcoeff(:)%j = (c(50)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(70),h0tab(:,70),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(2),ex5(:),G0H16(5),m3h1x16(:,70),heltab2x16(:,:,103))
  Gcoeff(:)%j = (c(50)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(11),m0h(71),h0tab(:,71),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(11),ex5(:),G0H16(12),m3h1x16(:,71),heltab2x16(:,:,104))
  Gcoeff(:)%j = (-(c(13)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(13),m0h(72),h0tab(:,72),[16,3,12],[nMH,nMZ,nMH],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(13),ex5(:),G0H16(14),m3h1x16(:,72),heltab2x16(:,:,105))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(73),h0tab(:,73),[16,3,12],[nMZ,nMH,nMZ],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(15),ex5(:),G0H16(16),m3h1x16(:,73),heltab2x16(:,:,106))
  Gcoeff(:)%j = (c(58)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(74),h0tab(:,74),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(8),ex5(:),G0H16(6),m3h1x16(:,74),heltab2x16(:,:,107))
  Gcoeff(:)%j = (c(58)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(75),h0tab(:,75),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(1),ex5(:),G0H16(7),m3h1x16(:,75),heltab2x16(:,:,108))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(76),h0tab(:,76),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(2),ex5(:),G0H16(11),m3h1x16(:,76),heltab2x16(:,:,109))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(13),m0h(77),h0tab(:,77),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(13),ex5(:),G0H16(15),m3h1x16(:,77),heltab2x16(:,:,110))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(78),h0tab(:,78),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(8),ex5(:),G0H16(1),m3h1x16(:,78),heltab2x16(:,:,111))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(2),m0h(79),h0tab(:,79),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(2),ex5(:),G0H16(13),m3h1x16(:,79),heltab2x16(:,:,112))
  Gcoeff(:)%j = (c(31)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(80),h0tab(:,80),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(8),ex5(:),G0H16(2),m3h1x16(:,80),heltab2x16(:,:,113))
  Gcoeff(:)%j = (c(31)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(81),h0tab(:,81),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(8),ex5(:),G0H16(17),m3h1x16(:,81),heltab2x16(:,:,114))
  Gcoeff(:)%j = (c(31)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(82),h0tab(:,82),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(8),ex5(:),G0H16(18),m3h1x16(:,82),heltab2x16(:,:,115))
  Gcoeff(:)%j = (c(31)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(83),h0tab(:,83),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(8),ex5(:),G0H16(19),m3h1x16(:,83),heltab2x16(:,:,116))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(84),h0tab(:,84),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(8),ex5(:),G0H16(20),m3h1x16(:,84),heltab2x16(:,:,117))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(85),h0tab(:,85),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(8),ex5(:),G0H16(21),m3h1x16(:,85),heltab2x16(:,:,118))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(86),h0tab(:,86),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(8),ex5(:),G0H16(22),m3h1x16(:,86),heltab2x16(:,:,119))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(87),h0tab(:,87),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(8),ex5(:),G0H16(23),m3h1x16(:,87),heltab2x16(:,:,120))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(88),h0tab(:,88),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(8),ex5(:),G0H16(24),m3h1x16(:,88),heltab2x16(:,:,121))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(89),h0tab(:,89),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(8),ex5(:),G0H16(25),m3h1x16(:,89),heltab2x16(:,:,122))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(90),h0tab(:,90),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(8),ex5(:),G0H16(26),m3h1x16(:,90),heltab2x16(:,:,123))
  Gcoeff(:)%j = (-(c(22)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(91),h0tab(:,91),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(8),ex5(:),G0H16(27),m3h1x16(:,91),heltab2x16(:,:,124))
  Gcoeff(:)%j = (-(c(38)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(92),h0tab(:,92),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,5))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(28),m3h1x16(:,92),heltab2x16(:,:,125))
  Gcoeff(:)%j = (-(c(38)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(93),h0tab(:,93),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,5))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(29),m3h1x16(:,93),heltab2x16(:,:,126))
  Gcoeff(:)%j = (-(c(33)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(94),h0tab(:,94),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(30),m3h1x16(:,94),heltab2x16(:,:,127))
  Gcoeff(:)%j = (-(c(33)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(95),h0tab(:,95),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(31),m3h1x16(:,95),heltab2x16(:,:,128))
  Gcoeff(:)%j = (c(32)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(96),h0tab(:,96),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,5))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(32),m3h1x16(:,96),heltab2x16(:,:,129))
  Gcoeff(:)%j = (c(32)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(97),h0tab(:,97),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,5))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(33),m3h1x16(:,97),heltab2x16(:,:,130))
  Gcoeff(:)%j = (c(23)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(98),h0tab(:,98),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(34),m3h1x16(:,98),heltab2x16(:,:,131))
  Gcoeff(:)%j = (c(23)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(99),h0tab(:,99),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(35),m3h1x16(:,99),heltab2x16(:,:,132))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(100),h0tab(:,100),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(8),ex5(:),G0H16(36),m3h1x16(:,100),heltab2x16(:,:,133))
  Gcoeff(:)%j = (c(44)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(101),h0tab(:,101),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(8),ex5(:),G0H16(37),m3h1x16(:,101),heltab2x16(:,:,134))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(102),h0tab(:,102),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(8),ex5(:),G0H16(38),m3h1x16(:,102),heltab2x16(:,:,135))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(103),h0tab(:,103),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(8),ex5(:),G0H16(39),m3h1x16(:,103),heltab2x16(:,:,136))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(104),h0tab(:,104),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(8),ex5(:),G0H16(40),m3h1x16(:,104),heltab2x16(:,:,137))
  Gcoeff(:)%j = (c(3)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(105),h0tab(:,105),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(8),ex5(:),G0H16(41),m3h1x16(:,105),heltab2x16(:,:,138))
  Gcoeff(:)%j = (-(c(24)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(106),h0tab(:,106),[16,3,12],[nMH,nMZ,nMH],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(8),ex5(:),G0H16(42),m3h1x16(:,106),heltab2x16(:,:,139))
  Gcoeff(:)%j = (-(c(47)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(107),h0tab(:,107),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(8),ex5(:),G0H16(43),m3h1x16(:,107),heltab2x16(:,:,140))
  Gcoeff(:)%j = (-(c(47)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(108),h0tab(:,108),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(8),ex5(:),G0H16(44),m3h1x16(:,108),heltab2x16(:,:,141))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(109),h0tab(:,109),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,5))
  call Hloop_VT_S(ntryL,G0H16(8),0,ex5(:),16,G1H16(33),m3h1x16(:,109),heltab2x16(:,:,142))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(110),h0tab(:,110),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,5))
  call Hloop_VT_S(ntryL,G0H16(8),0,ex5(:),16,G1H16(34),m3h1x16(:,110),heltab2x16(:,:,143))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(111),h0tab(:,111),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(8),0,ex5(:),16,G1H16(35),m3h1x16(:,111),heltab2x16(:,:,144))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(112),h0tab(:,112),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(8),0,ex5(:),16,G1H16(36),m3h1x16(:,112),heltab2x16(:,:,145))
  Gcoeff(:)%j = (-(c(56)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(113),h0tab(:,113),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,5))
  call Hloop_VT_S(ntryL,G0H16(8),0,ex5(:),16,G1H16(37),m3h1x16(:,113),heltab2x16(:,:,146))
  Gcoeff(:)%j = (c(56)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(114),h0tab(:,114),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,5))
  call Hloop_VT_S(ntryL,G0H16(8),0,ex5(:),16,G1H16(38),m3h1x16(:,114),heltab2x16(:,:,147))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(115),h0tab(:,115),[16,3,12],[nMZ,nMH,nMZ],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(8),0,ex5(:),16,G1H16(39),m3h1x16(:,115),heltab2x16(:,:,148))
  Gcoeff(:)%j = (-(c(61)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(116),h0tab(:,116),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(8),0,ex5(:),16,G1H16(40),m3h1x16(:,116),heltab2x16(:,:,149))
  Gcoeff(:)%j = (c(61)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(117),h0tab(:,117),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(8),0,ex5(:),16,G1H16(41),m3h1x16(:,117),heltab2x16(:,:,150))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(118),h0tab(:,118),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,5))
  call Hloop_ST_V(ntryL,G0H16(8),0,ex5(:),16,G1H16(42),m3h1x16(:,118),heltab2x16(:,:,151))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(119),h0tab(:,119),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,5))
  call Hloop_ST_V(ntryL,G0H16(8),0,ex5(:),16,G1H16(43),m3h1x16(:,119),heltab2x16(:,:,152))
  Gcoeff(:)%j = (-(c(57)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(120),h0tab(:,120),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(8),0,ex5(:),16,G1H16(44),m3h1x16(:,120),heltab2x16(:,:,153))
  Gcoeff(:)%j = (c(57)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(121),h0tab(:,121),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(8),0,ex5(:),16,G1H16(45),m3h1x16(:,121),heltab2x16(:,:,154))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(122),h0tab(:,122),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,5))
  call Hloop_ST_V(ntryL,G0H16(8),0,ex5(:),16,G1H16(46),m3h1x16(:,122),heltab2x16(:,:,155))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(123),h0tab(:,123),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,5))
  call Hloop_ST_V(ntryL,G0H16(8),0,ex5(:),16,G1H16(47),m3h1x16(:,123),heltab2x16(:,:,156))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(124),h0tab(:,124),[16,3,12],[nMZ,nMH,nMZ],3,2,wf4(:,1),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(8),0,ex5(:),16,G1H16(48),m3h1x16(:,124),heltab2x16(:,:,157))
  Gcoeff(:)%j = (c(61)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(125),h0tab(:,125),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(8),0,ex5(:),16,G1H16(49),m3h1x16(:,125),heltab2x16(:,:,158))
  Gcoeff(:)%j = (-(c(61)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(126),h0tab(:,126),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(8),0,ex5(:),16,G1H16(50),m3h1x16(:,126),heltab2x16(:,:,159))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(127),h0tab(:,127),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,5))
  call Hloop_VT_S(ntryL,G0H16(8),0,ex5(:),16,G1H16(51),m3h1x16(:,127),heltab2x16(:,:,160))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(128),h0tab(:,128),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,5))
  call Hloop_VT_S(ntryL,G0H16(8),0,ex5(:),16,G1H16(52),m3h1x16(:,128),heltab2x16(:,:,161))
  Gcoeff(:)%j = (c(31)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(129),h0tab(:,129),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(8),0,ex5(:),16,G1H16(53),m3h1x16(:,129),heltab2x16(:,:,162))
  Gcoeff(:)%j = (-(c(31)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(130),h0tab(:,130),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(8),0,ex5(:),16,G1H16(54),m3h1x16(:,130),heltab2x16(:,:,163))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(131),h0tab(:,131),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,5))
  call Hloop_VT_S(ntryL,G0H16(8),0,ex5(:),16,G1H16(55),m3h1x16(:,131),heltab2x16(:,:,164))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(132),h0tab(:,132),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,5))
  call Hloop_VT_S(ntryL,G0H16(8),0,ex5(:),16,G1H16(56),m3h1x16(:,132),heltab2x16(:,:,165))
  Gcoeff(:)%j = (c(37)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(133),h0tab(:,133),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(8),0,ex5(:),16,G1H16(57),m3h1x16(:,133),heltab2x16(:,:,166))
  Gcoeff(:)%j = (-(c(37)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(134),h0tab(:,134),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(8),0,ex5(:),16,G1H16(58),m3h1x16(:,134),heltab2x16(:,:,167))
  Gcoeff(:)%j = (-(c(36)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(135),h0tab(:,135),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,5))
  call Hloop_ST_V(ntryL,G0H16(8),0,ex5(:),16,G1H16(59),m3h1x16(:,135),heltab2x16(:,:,168))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(136),h0tab(:,136),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,5))
  call Hloop_ST_V(ntryL,G0H16(8),0,ex5(:),16,G1H16(60),m3h1x16(:,136),heltab2x16(:,:,169))
  Gcoeff(:)%j = (c(2)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(137),h0tab(:,137),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(8),0,ex5(:),16,G1H16(61),m3h1x16(:,137),heltab2x16(:,:,170))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(138),h0tab(:,138),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(8),0,ex5(:),16,G1H16(62),m3h1x16(:,138),heltab2x16(:,:,171))
  Gcoeff(:)%j = (c(30)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(139),h0tab(:,139),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,5))
  call Hloop_ST_V(ntryL,G0H16(8),0,ex5(:),16,G1H16(63),m3h1x16(:,139),heltab2x16(:,:,172))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(140),h0tab(:,140),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,5))
  call Hloop_ST_V(ntryL,G0H16(8),0,ex5(:),16,G1H16(64),m3h1x16(:,140),heltab2x16(:,:,173))
  Gcoeff(:)%j = (-(c(37)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(141),h0tab(:,141),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(8),0,ex5(:),16,G1H16(65),m3h1x16(:,141),heltab2x16(:,:,174))
  Gcoeff(:)%j = (c(37)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(142),h0tab(:,142),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_ST_V(ntryL,G0H16(8),0,ex5(:),16,G1H16(66),m3h1x16(:,142),heltab2x16(:,:,175))
  Gcoeff(:)%j = (c(45)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(143),h0tab(:,143),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,5))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(45),m3h1x16(:,143),heltab2x16(:,:,176))
  Gcoeff(:)%j = (c(45)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(144),h0tab(:,144),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,5))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(46),m3h1x16(:,144),heltab2x16(:,:,177))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(145),h0tab(:,145),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(47),m3h1x16(:,145),heltab2x16(:,:,178))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(146),h0tab(:,146),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,4),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(48),m3h1x16(:,146),heltab2x16(:,:,179))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(147),h0tab(:,147),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,5))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(49),m3h1x16(:,147),heltab2x16(:,:,180))
  Gcoeff(:)%j = (c(7)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(148),h0tab(:,148),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,5))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(50),m3h1x16(:,148),heltab2x16(:,:,181))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(149),h0tab(:,149),[16,3,12],[nMZ,nMH,nMZ],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(51),m3h1x16(:,149),heltab2x16(:,:,182))
  Gcoeff(:)%j = (-(c(49)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(150),h0tab(:,150),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(52),m3h1x16(:,150),heltab2x16(:,:,183))
  Gcoeff(:)%j = (-(c(49)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(151),h0tab(:,151),[16,3,12],[nMW,nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(53),m3h1x16(:,151),heltab2x16(:,:,184))
  Gcoeff(:)%j = (-(c(41)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(152),h0tab(:,152),[16,7,8],[nMZ,0,nMZ],3,1,wf8(:,2))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(54),m3h1x16(:,152),heltab2x16(:,:,185))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(18)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(153),h0tab(:,153),[16,7,8],[nMW,0,nMW],3,1,wf8(:,2))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(55),m3h1x16(:,153),heltab2x16(:,:,186))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(154),h0tab(:,154),[16,7,8],[nMZ,0,nMZ],3,1,wf8(:,4))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(56),m3h1x16(:,154),heltab2x16(:,:,187))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(19)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(155),h0tab(:,155),[16,7,8],[nMW,0,nMW],3,1,wf8(:,4))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(57),m3h1x16(:,155),heltab2x16(:,:,188))
  Gcoeff(:)%j = (-(c(41)*M(2,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(156),h0tab(:,156),[16,4,11],[nMZ,0,nMZ],3,1,wf8(:,6))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(58),m3h1x16(:,156),heltab2x16(:,:,189))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(21)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(157),h0tab(:,157),[16,4,11],[nMW,0,nMW],3,1,wf8(:,6))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(59),m3h1x16(:,157),heltab2x16(:,:,190))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(158),h0tab(:,158),[16,4,11],[nMZ,0,nMZ],3,1,wf8(:,8))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(60),m3h1x16(:,158),heltab2x16(:,:,191))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(159),h0tab(:,159),[16,4,11],[nMW,0,nMW],3,1,wf8(:,8))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(61),m3h1x16(:,159),heltab2x16(:,:,192))
  Gcoeff(:)%j = (c(40)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(160),h0tab(:,160),[19,4,8],[0,0,0],3,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H16(8),wf4(:,3),G0H4(1),ngZu,m3h4x4(:,9),heltab2x16(:,:,193))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(1),n2h4(1))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(161),h0tab(:,161),[19,4,8],[0,nMZ,0],3,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H16(8),wf4(:,3),G0H4(1),ngZu,m3h4x4(:,10),heltab2x16(:,:,194))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(7),n2h4(2))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(162),h0tab(:,162),[19,4,8],[0,nMW,0],3,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H16(8),wf4(:,3),G0H4(1),ngZd,m3h4x4(:,11),heltab2x16(:,:,195))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(6),n2h4(3))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(163),h0tab(:,163),[19,4,8],[0,0,0],3,1,wf4(:,3))
  call Hloop_AZ_Q(ntryL,G0H16(8),wf4(:,3),G0H4(1),ngZu,m3h4x4(:,12),heltab2x16(:,:,196))
  call Hloop_A_Q(ntryL,G0H4(1),19,0,G1H4(5),n2h4(4))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(14)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(164),h0tab(:,164),[19,4,8],[nMW,0,nMW],3,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H16(8),0,wf4(:,3),19,G1H4(4),m3h4x4(:,13),heltab2x16(:,:,197))
  Gcoeff(:)%j = (-(c(41)*M(2,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(165),h0tab(:,165),[16,2,13],[nMZ,0,nMZ],3,1,wf8(:,10))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(62),m3h1x16(:,160),heltab2x16(:,:,198))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(166),h0tab(:,166),[16,2,13],[nMW,0,nMW],3,1,wf8(:,10))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(63),m3h1x16(:,161),heltab2x16(:,:,199))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(167),h0tab(:,167),[16,2,13],[nMZ,0,nMZ],3,1,wf8(:,12))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(64),m3h1x16(:,162),heltab2x16(:,:,200))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(25)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(168),h0tab(:,168),[16,2,13],[nMW,0,nMW],3,1,wf8(:,12))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(65),m3h1x16(:,163),heltab2x16(:,:,201))
  Gcoeff(:)%j = (-(c(41)*M(2,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(169),h0tab(:,169),[16,1,14],[nMZ,0,nMZ],3,1,wf8(:,14))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(66),m3h1x16(:,164),heltab2x16(:,:,202))
  Gcoeff(:)%j = (-(c(16)*M(2,:)%j)) * den(27)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(170),h0tab(:,170),[16,1,14],[nMW,0,nMW],3,1,wf8(:,14))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(67),m3h1x16(:,165),heltab2x16(:,:,203))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(171),h0tab(:,171),[16,1,14],[nMZ,0,nMZ],3,1,wf8(:,16))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(68),m3h1x16(:,166),heltab2x16(:,:,204))
  Gcoeff(:)%j = (c(17)*M(2,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(172),h0tab(:,172),[16,1,14],[nMW,0,nMW],3,1,wf8(:,16))
  call Hloop_VS_V(ntryL,G0H16(8),ex5(:),G0H16(69),m3h1x16(:,167),heltab2x16(:,:,205))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(173),h0tab(:,173),[28,1,2],[0,0,0],3,1,wf4(:,15))
  call Hloop_AZ_Q(ntryL,G0H16(8),wf4(:,15),G0H4(1),ngZl,m3h4x4(:,14),heltab2x16(:,:,206))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(8),n2h4(5))
  Gcoeff(:)%j = (c(42)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(174),h0tab(:,174),[28,1,2],[0,nMZ,0],3,1,wf4(:,15))
  call Hloop_AZ_Q(ntryL,G0H16(8),wf4(:,15),G0H4(1),ngZl,m3h4x4(:,15),heltab2x16(:,:,207))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(9),n2h4(6))
  Gcoeff(:)%j = (c(21)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(175),h0tab(:,175),[28,1,2],[0,nMW,0],3,1,wf4(:,15))
  call Hloop_AZ_Q(ntryL,G0H16(8),wf4(:,15),G0H4(1),ngZn,m3h4x4(:,16),heltab2x16(:,:,208))
  call Hloop_A_Q(ntryL,G0H4(1),28,0,G1H4(10),n2h4(7))
  Gcoeff(:)%j = (c(10)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(176),h0tab(:,176),[28,1,2],[nMW,0,nMW],3,1,wf4(:,15))
  call Hloop_UW_V(ntryL,G0H16(8),0,wf4(:,15),28,G1H4(3),m3h4x4(:,17),heltab2x16(:,:,209))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(1),[G0H16(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(13),[G0H16(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(18),[G0H16(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(19),[G0H16(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(22),[G0H16(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(23),[G0H16(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(26),[G0H16(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(27),[G0H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(37),[G0H16(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(39),[G0H16(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(41),[G0H16(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(44),[G0H16(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(46),[G0H16(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(48),[G0H16(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(50),[G0H16(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H16(53),[G0H16(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(5),[G1H4(1)])
  call Hloop_AV_Q(ntryL,G1H16(1),wf4(:,4),G1H4(2),m3h4x4(:,18),heltab2x16(:,:,210))
  call Hloop_A_Q(ntryL,G1H4(2),19,nMM,G2H4(1),n2h4(8))
  call Hloop_AV_Q(ntryL,G1H16(2),wf4(:,4),G1H4(1),m3h4x4(:,19),heltab2x16(:,:,211))
  call Hloop_A_Q(ntryL,G1H4(1),19,nML,G2H4(2),n2h4(9))
  call Hloop_QV_A(ntryL,G1H16(3),wf4(:,4),G1H4(2),m3h4x4(:,20),heltab2x16(:,:,212))
  call Hloop_Q_A(ntryL,G1H4(2),19,nMM,G2H4(3),n2h4(10))
  call Hloop_QV_A(ntryL,G1H16(4),wf4(:,4),G1H4(1),m3h4x4(:,21),heltab2x16(:,:,213))
  call Hloop_Q_A(ntryL,G1H4(1),19,nML,G2H4(4),n2h4(11))
  call Hloop_AV_Q(ntryL,G1H16(5),wf4(:,4),G1H4(2),m3h4x4(:,22),heltab2x16(:,:,214))
  call Hloop_A_Q(ntryL,G1H4(2),19,nMT,G2H4(5),n2h4(12))
  call Hloop_QV_A(ntryL,G1H16(6),wf4(:,4),G1H4(1),m3h4x4(:,23),heltab2x16(:,:,215))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(6),n2h4(13))
  call Hloop_AV_Q(ntryL,G1H16(7),wf4(:,4),G1H4(2),m3h4x4(:,24),heltab2x16(:,:,216))
  call Hloop_A_Q(ntryL,G1H4(2),19,nMB,G2H4(7),n2h4(14))
  call Hloop_QV_A(ntryL,G1H16(8),wf4(:,4),G1H4(1),m3h4x4(:,25),heltab2x16(:,:,217))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(8),n2h4(15))
  call Hloop_AV_Q(ntryL,G1H16(9),wf4(:,4),G1H4(2),m3h4x4(:,26),heltab2x16(:,:,218))
  call Hloop_A_Q(ntryL,G1H4(2),19,nMM,G2H4(9),n2h4(16))
  call Hloop_AV_Q(ntryL,G1H16(10),wf4(:,4),G1H4(1),m3h4x4(:,27),heltab2x16(:,:,219))
  call Hloop_A_Q(ntryL,G1H4(1),19,nML,G2H4(10),n2h4(17))
  call Hloop_QV_A(ntryL,G1H16(11),wf4(:,4),G1H4(2),m3h4x4(:,28),heltab2x16(:,:,220))
  call Hloop_Q_A(ntryL,G1H4(2),19,nMM,G2H4(11),n2h4(18))
  call Hloop_QV_A(ntryL,G1H16(12),wf4(:,4),G1H4(1),m3h4x4(:,29),heltab2x16(:,:,221))
  call Hloop_Q_A(ntryL,G1H4(1),19,nML,G2H4(12),n2h4(19))
  call Hloop_AV_Q(ntryL,G1H16(13),wf4(:,4),G1H4(2),m3h4x4(:,30),heltab2x16(:,:,222))
  call Hloop_A_Q(ntryL,G1H4(2),19,nMT,G2H4(13),n2h4(20))
  call Hloop_QV_A(ntryL,G1H16(14),wf4(:,4),G1H4(1),m3h4x4(:,31),heltab2x16(:,:,223))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(14),n2h4(21))
  call Hloop_AV_Q(ntryL,G1H16(15),wf4(:,4),G1H4(2),m3h4x4(:,32),heltab2x16(:,:,224))
  call Hloop_A_Q(ntryL,G1H4(2),19,nMB,G2H4(15),n2h4(22))
  call Hloop_QV_A(ntryL,G1H16(16),wf4(:,4),G1H4(1),m3h4x4(:,33),heltab2x16(:,:,225))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(16),n2h4(23))
  call Hloop_AZ_Q(ntryL,G1H16(17),wf4(:,1),G1H4(2),ngZl,m3h4x4(:,34),heltab2x16(:,:,226))
  call Hloop_A_Q(ntryL,G1H4(2),19,nMM,G2H4(17),n2h4(24))
  call Hloop_AZ_Q(ntryL,G1H16(18),wf4(:,1),G1H4(1),ngZl,m3h4x4(:,35),heltab2x16(:,:,227))
  call Hloop_A_Q(ntryL,G1H4(1),19,nML,G2H4(18),n2h4(25))
  call Hloop_QZ_A(ntryL,G1H16(19),wf4(:,1),G1H4(2),ngZl,m3h4x4(:,36),heltab2x16(:,:,228))
  call Hloop_Q_A(ntryL,G1H4(2),19,nMM,G2H4(19),n2h4(26))
  call Hloop_QZ_A(ntryL,G1H16(20),wf4(:,1),G1H4(1),ngZl,m3h4x4(:,37),heltab2x16(:,:,229))
  call Hloop_Q_A(ntryL,G1H4(1),19,nML,G2H4(20),n2h4(27))
  call Hloop_AZ_Q(ntryL,G1H16(21),wf4(:,1),G1H4(2),ngZu,m3h4x4(:,38),heltab2x16(:,:,230))
  call Hloop_A_Q(ntryL,G1H4(2),19,nMT,G2H4(21),n2h4(28))
  call Hloop_QZ_A(ntryL,G1H16(22),wf4(:,1),G1H4(1),ngZu,m3h4x4(:,39),heltab2x16(:,:,231))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(22),n2h4(29))
  call Hloop_AZ_Q(ntryL,G1H16(23),wf4(:,1),G1H4(2),ngZd,m3h4x4(:,40),heltab2x16(:,:,232))
  call Hloop_A_Q(ntryL,G1H4(2),19,nMB,G2H4(23),n2h4(30))
  call Hloop_QZ_A(ntryL,G1H16(24),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,41),heltab2x16(:,:,233))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(24),n2h4(31))
  call Hloop_AZ_Q(ntryL,G1H16(25),wf4(:,1),G1H4(2),ngZl,m3h4x4(:,42),heltab2x16(:,:,234))
  call Hloop_A_Q(ntryL,G1H4(2),19,nMM,G2H4(25),n2h4(32))
  call Hloop_AZ_Q(ntryL,G1H16(26),wf4(:,1),G1H4(1),ngZl,m3h4x4(:,43),heltab2x16(:,:,235))
  call Hloop_A_Q(ntryL,G1H4(1),19,nML,G2H4(26),n2h4(33))
  call Hloop_QZ_A(ntryL,G1H16(27),wf4(:,1),G1H4(2),ngZl,m3h4x4(:,44),heltab2x16(:,:,236))
  call Hloop_Q_A(ntryL,G1H4(2),19,nMM,G2H4(27),n2h4(34))
  call Hloop_QZ_A(ntryL,G1H16(28),wf4(:,1),G1H4(1),ngZl,m3h4x4(:,45),heltab2x16(:,:,237))
  call Hloop_Q_A(ntryL,G1H4(1),19,nML,G2H4(28),n2h4(35))
  call Hloop_AZ_Q(ntryL,G1H16(29),wf4(:,1),G1H4(2),ngZu,m3h4x4(:,46),heltab2x16(:,:,238))
  call Hloop_A_Q(ntryL,G1H4(2),19,nMT,G2H4(29),n2h4(36))
  call Hloop_QZ_A(ntryL,G1H16(30),wf4(:,1),G1H4(1),ngZu,m3h4x4(:,47),heltab2x16(:,:,239))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMT,G2H4(30),n2h4(37))
  call Hloop_AZ_Q(ntryL,G1H16(31),wf4(:,1),G1H4(2),ngZd,m3h4x4(:,48),heltab2x16(:,:,240))
  call Hloop_A_Q(ntryL,G1H4(2),19,nMB,G2H4(31),n2h4(38))
  call Hloop_QZ_A(ntryL,G1H16(32),wf4(:,1),G1H4(1),ngZd,m3h4x4(:,49),heltab2x16(:,:,241))
  call Hloop_Q_A(ntryL,G1H4(1),19,nMB,G2H4(32),n2h4(39))
  call Hloop_SV_T(ntryL,G0H16(4),16,wf4(:,4),3,G1H4(2),m3h4x4(:,50),heltab2x16(:,:,242))
  call Hloop_TV_S(ntryL,G0H16(10),16,wf4(:,4),3,G1H4(1),m3h4x4(:,51),heltab2x16(:,:,243))
  call Hloop_SV_T(ntryL,G0H16(3),16,wf4(:,4),3,G1H4(11),m3h4x4(:,52),heltab2x16(:,:,244))
  call Hloop_TV_S(ntryL,G0H16(9),16,wf4(:,4),3,G1H4(12),m3h4x4(:,53),heltab2x16(:,:,245))
  call Hloop_SV_T(ntryL,G0H16(5),16,wf4(:,1),3,G1H4(13),m3h4x4(:,54),heltab2x16(:,:,246))
  call Hloop_TV_S(ntryL,G0H16(12),16,wf4(:,1),3,G1H4(14),m3h4x4(:,55),heltab2x16(:,:,247))
  call Hloop_TV_S(ntryL,G0H16(14),16,wf4(:,1),3,G1H4(15),m3h4x4(:,56),heltab2x16(:,:,248))
  call Hloop_SV_T(ntryL,G0H16(16),16,wf4(:,1),3,G1H4(16),m3h4x4(:,57),heltab2x16(:,:,249))
  call Hloop_SV_T(ntryL,G0H16(6),16,wf4(:,1),3,G1H4(17),m3h4x4(:,58),heltab2x16(:,:,250))
  call Hloop_TV_S(ntryL,G0H16(7),16,wf4(:,1),3,G1H4(18),m3h4x4(:,59),heltab2x16(:,:,251))
  call Hloop_DV_C(ntryL,G0H16(1),16,wf4(:,4),G1H4(19),m3h4x4(:,60),heltab2x16(:,:,252))
  call Hloop_CV_D(ntryL,G0H16(13),16,wf4(:,4),3,G1H4(20),m3h4x4(:,61),heltab2x16(:,:,253))
  call Hloop_DV_C(ntryL,G0H16(18),16,wf4(:,4),G1H4(21),m3h4x4(:,62),heltab2x16(:,:,254))
  call Hloop_CV_D(ntryL,G0H16(19),16,wf4(:,4),3,G1H4(22),m3h4x4(:,63),heltab2x16(:,:,255))
  call Hloop_DV_C(ntryL,G0H16(22),16,wf4(:,1),G1H4(23),m3h4x4(:,64),heltab2x16(:,:,256))
  call Hloop_CV_D(ntryL,G0H16(23),16,wf4(:,1),3,G1H4(24),m3h4x4(:,65),heltab2x16(:,:,257))
  call Hloop_DV_C(ntryL,G0H16(26),16,wf4(:,1),G1H4(25),m3h4x4(:,66),heltab2x16(:,:,258))
  call Hloop_CV_D(ntryL,G0H16(27),16,wf4(:,1),3,G1H4(26),m3h4x4(:,67),heltab2x16(:,:,259))
  call Hloop_UW_V(ntryL,G0H16(28),16,wf4(:,4),3,G1H4(27),m3h4x4(:,68),heltab2x16(:,:,260))
  call Hloop_UV_W(ntryL,G0H16(29),16,wf4(:,4),3,G1H4(28),m3h4x4(:,69),heltab2x16(:,:,261))
  call Hloop_UW_V(ntryL,G0H16(30),16,wf4(:,4),3,G1H4(29),m3h4x4(:,70),heltab2x16(:,:,262))
  call Hloop_UV_W(ntryL,G0H16(31),16,wf4(:,4),3,G1H4(30),m3h4x4(:,71),heltab2x16(:,:,263))
  call Hloop_UW_V(ntryL,G0H16(32),16,wf4(:,1),3,G1H4(31),m3h4x4(:,72),heltab2x16(:,:,264))
  call Hloop_UV_W(ntryL,G0H16(33),16,wf4(:,1),3,G1H4(32),m3h4x4(:,73),heltab2x16(:,:,265))
  call Hloop_UW_V(ntryL,G0H16(34),16,wf4(:,1),3,G1H4(33),m3h4x4(:,74),heltab2x16(:,:,266))
  call Hloop_UV_W(ntryL,G0H16(35),16,wf4(:,1),3,G1H4(34),m3h4x4(:,75),heltab2x16(:,:,267))
  call Hloop_SV_V(ntryL,G0H16(37),wf4(:,4),G0H4(1),m3h4x4(:,76),heltab2x16(:,:,268))
  call Hloop_SV_V(ntryL,G0H16(39),wf4(:,4),G0H4(2),m3h4x4(:,77),heltab2x16(:,:,269))
  call Hloop_SV_V(ntryL,G0H16(41),wf4(:,1),G0H4(3),m3h4x4(:,78),heltab2x16(:,:,270))
  call Hloop_SV_V(ntryL,G0H16(42),wf4(:,1),G0H4(4),m3h4x4(:,79),heltab2x16(:,:,271))
  call Hloop_SV_V(ntryL,G0H16(44),wf4(:,1),G0H4(5),m3h4x4(:,80),heltab2x16(:,:,272))
  call Hloop_SV_T(ntryL,G1H16(33),16,wf4(:,4),3,G2H4(33),m3h4x4(:,81),heltab2x16(:,:,273))
  call Hloop_TV_S(ntryL,G1H16(34),16,wf4(:,4),3,G2H4(34),m3h4x4(:,82),heltab2x16(:,:,274))
  call Hloop_SV_T(ntryL,G1H16(35),16,wf4(:,4),3,G2H4(35),m3h4x4(:,83),heltab2x16(:,:,275))
  call Hloop_TV_S(ntryL,G1H16(36),16,wf4(:,4),3,G2H4(36),m3h4x4(:,84),heltab2x16(:,:,276))
  call Hloop_SV_T(ntryL,G1H16(37),16,wf4(:,1),3,G2H4(37),m3h4x4(:,85),heltab2x16(:,:,277))
  call Hloop_TV_S(ntryL,G1H16(38),16,wf4(:,1),3,G2H4(38),m3h4x4(:,86),heltab2x16(:,:,278))
  call Hloop_SV_T(ntryL,G1H16(39),16,wf4(:,1),3,G2H4(39),m3h4x4(:,87),heltab2x16(:,:,279))
  call Hloop_SV_T(ntryL,G1H16(40),16,wf4(:,1),3,G2H4(40),m3h4x4(:,88),heltab2x16(:,:,280))
  call Hloop_TV_S(ntryL,G1H16(41),16,wf4(:,1),3,G2H4(41),m3h4x4(:,89),heltab2x16(:,:,281))
  call Hloop_VV_S(ntryL,G1H16(42),wf4(:,4),G1H4(35),m3h4x4(:,90),heltab2x16(:,:,282))
  call Hloop_VV_S(ntryL,G1H16(43),wf4(:,4),G1H4(36),m3h4x4(:,91),heltab2x16(:,:,283))
  call Hloop_VV_S(ntryL,G1H16(44),wf4(:,4),G1H4(37),m3h4x4(:,92),heltab2x16(:,:,284))
  call Hloop_VV_S(ntryL,G1H16(45),wf4(:,4),G1H4(38),m3h4x4(:,93),heltab2x16(:,:,285))
  call Hloop_VV_S(ntryL,G1H16(46),wf4(:,1),G1H4(39),m3h4x4(:,94),heltab2x16(:,:,286))
  call Hloop_VV_S(ntryL,G1H16(47),wf4(:,1),G1H4(40),m3h4x4(:,95),heltab2x16(:,:,287))
  call Hloop_VV_S(ntryL,G1H16(48),wf4(:,1),G1H4(41),m3h4x4(:,96),heltab2x16(:,:,288))
  call Hloop_VV_S(ntryL,G1H16(49),wf4(:,1),G1H4(42),m3h4x4(:,97),heltab2x16(:,:,289))
  call Hloop_VV_S(ntryL,G1H16(50),wf4(:,1),G1H4(43),m3h4x4(:,98),heltab2x16(:,:,290))
  call Hloop_SV_V(ntryL,G1H16(51),wf4(:,4),G1H4(44),m3h4x4(:,99),heltab2x16(:,:,291))
  call Hloop_SV_V(ntryL,G1H16(52),wf4(:,4),G1H4(45),m3h4x4(:,100),heltab2x16(:,:,292))
  call Hloop_SV_V(ntryL,G1H16(53),wf4(:,4),G1H4(46),m3h4x4(:,101),heltab2x16(:,:,293))
  call Hloop_SV_V(ntryL,G1H16(54),wf4(:,4),G1H4(47),m3h4x4(:,102),heltab2x16(:,:,294))
  call Hloop_SV_V(ntryL,G1H16(55),wf4(:,1),G1H4(48),m3h4x4(:,103),heltab2x16(:,:,295))
  call Hloop_SV_V(ntryL,G1H16(56),wf4(:,1),G1H4(49),m3h4x4(:,104),heltab2x16(:,:,296))
  call Hloop_SV_V(ntryL,G1H16(57),wf4(:,1),G1H4(50),m3h4x4(:,105),heltab2x16(:,:,297))
  call Hloop_SV_V(ntryL,G1H16(58),wf4(:,1),G1H4(51),m3h4x4(:,106),heltab2x16(:,:,298))
  call Hloop_UW_V(ntryL,G1H16(59),16,wf4(:,4),3,G2H4(42),m3h4x4(:,107),heltab2x16(:,:,299))
  call Hloop_UV_W(ntryL,G1H16(60),16,wf4(:,4),3,G2H4(43),m3h4x4(:,108),heltab2x16(:,:,300))
  call Hloop_UW_V(ntryL,G1H16(61),16,wf4(:,4),3,G2H4(44),m3h4x4(:,109),heltab2x16(:,:,301))
  call Hloop_UV_W(ntryL,G1H16(62),16,wf4(:,4),3,G2H4(45),m3h4x4(:,110),heltab2x16(:,:,302))
  call Hloop_UW_V(ntryL,G1H16(63),16,wf4(:,1),3,G2H4(46),m3h4x4(:,111),heltab2x16(:,:,303))
  call Hloop_UV_W(ntryL,G1H16(64),16,wf4(:,1),3,G2H4(47),m3h4x4(:,112),heltab2x16(:,:,304))
  call Hloop_UW_V(ntryL,G1H16(65),16,wf4(:,1),3,G2H4(48),m3h4x4(:,113),heltab2x16(:,:,305))
  call Hloop_UV_W(ntryL,G1H16(66),16,wf4(:,1),3,G2H4(49),m3h4x4(:,114),heltab2x16(:,:,306))
  call Hloop_VV_S(ntryL,G0H16(46),wf4(:,4),G0H4(6),m3h4x4(:,115),heltab2x16(:,:,307))
  call Hloop_VV_S(ntryL,G0H16(48),wf4(:,4),G0H4(7),m3h4x4(:,116),heltab2x16(:,:,308))
  call Hloop_VV_S(ntryL,G0H16(50),wf4(:,1),G0H4(8),m3h4x4(:,117),heltab2x16(:,:,309))
  call Hloop_VV_S(ntryL,G0H16(51),wf4(:,1),G0H4(9),m3h4x4(:,118),heltab2x16(:,:,310))
  call Hloop_VV_S(ntryL,G0H16(53),wf4(:,1),G0H4(10),m3h4x4(:,119),heltab2x16(:,:,311))
  call Hloop_ZQ_A(ntryL,G0H16(54),wf8(:,2),G0H2(1),ngZu,m3h8x2(:,1),heltab2x16(:,:,312))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(1),n2h2(20))
  call Hloop_WQ_A(ntryL,G0H16(55),wf8(:,2),G0H2(1),m3h8x2(:,2),heltab2x16(:,:,313))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(2),n2h2(21))
  call Hloop_ZQ_A(ntryL,G0H16(56),wf8(:,4),G0H2(1),ngZu,m3h8x2(:,3),heltab2x16(:,:,314))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(3),n2h2(22))
  call Hloop_WQ_A(ntryL,G0H16(57),wf8(:,4),G0H2(1),m3h8x2(:,4),heltab2x16(:,:,315))
  call Hloop_Q_A(ntryL,G0H2(1),23,0,G1H2(4),n2h2(23))
  call Hloop_ZQ_A(ntryL,G0H16(58),ex3(:),G0H8(1),ngZu,m3h2x8(:,26),heltab2x16(:,:,316))
  call Hloop_Q_A(ntryL,G0H8(1),20,0,G1H8(1),n2h8(26))
  call Hloop_WQ_A(ntryL,G0H16(59),ex3(:),G0H8(1),m3h2x8(:,27),heltab2x16(:,:,317))
  call Hloop_Q_A(ntryL,G0H8(1),20,0,G1H8(2),n2h8(27))
  call Hloop_ZQ_A(ntryL,G0H16(60),ex3(:),G0H8(1),ngZu,m3h2x8(:,28),heltab2x16(:,:,318))
  call Hloop_Q_A(ntryL,G0H8(1),20,0,G1H8(3),n2h8(28))
  call Hloop_WQ_A(ntryL,G0H16(61),ex3(:),G0H8(1),m3h2x8(:,29),heltab2x16(:,:,319))
  call Hloop_Q_A(ntryL,G0H8(1),20,0,G1H8(4),n2h8(29))
  call Hloop_AQ_V(ntryL,G1H4(5),ex3(:),G1H2(5),m3h2x2(:,13),heltab2x4(:,:,21))
  call Hloop_AQ_Z(ntryL,G1H4(7),ex3(:),G1H2(6),ngZu,m3h2x2(:,14),heltab2x4(:,:,22))
  call Hloop_AQ_W(ntryL,G1H4(6),ex3(:),G1H2(7),m3h2x2(:,15),heltab2x4(:,:,23))
  call Hloop_WQ_A(ntryL,G1H4(4),ex3(:),G1H2(8),m3h2x2(:,16),heltab2x4(:,:,24))
  call Hloop_Q_A(ntryL,G1H2(8),23,0,G2H2(10),n2h2(24))
  call Hloop_ZA_Q(ntryL,G0H16(62),ex2(:),G0H8(1),ngZl,m3h2x8(:,30),heltab2x16(:,:,320))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(7),n2h8(30))
  call Hloop_WA_Q(ntryL,G0H16(63),ex2(:),G0H8(1),m3h2x8(:,31),heltab2x16(:,:,321))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(8),n2h8(31))
  call Hloop_ZA_Q(ntryL,G0H16(64),ex2(:),G0H8(1),ngZl,m3h2x8(:,32),heltab2x16(:,:,322))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(5),n2h8(32))
  call Hloop_WA_Q(ntryL,G0H16(65),ex2(:),G0H8(1),m3h2x8(:,33),heltab2x16(:,:,323))
  call Hloop_A_Q(ntryL,G0H8(1),18,0,G1H8(6),n2h8(33))
  call Hloop_ZQ_A(ntryL,G0H16(66),ex1(:),G0H8(1),ngZl,m3h2x8(:,34),heltab2x16(:,:,324))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(9),n2h8(34))
  call Hloop_WQ_A(ntryL,G0H16(67),ex1(:),G0H8(1),m3h2x8(:,35),heltab2x16(:,:,325))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(10),n2h8(35))
  call Hloop_ZQ_A(ntryL,G0H16(68),ex1(:),G0H8(1),ngZl,m3h2x8(:,36),heltab2x16(:,:,326))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(11),n2h8(36))
  call Hloop_WQ_A(ntryL,G0H16(69),ex1(:),G0H8(1),m3h2x8(:,37),heltab2x16(:,:,327))
  call Hloop_Q_A(ntryL,G0H8(1),17,0,G1H8(12),n2h8(37))
  call Hloop_AQ_V(ntryL,G1H4(8),ex1(:),G1H2(8),m3h2x2(:,17),heltab2x4(:,:,25))
  call Hloop_AQ_Z(ntryL,G1H4(9),ex1(:),G1H2(9),ngZl,m3h2x2(:,18),heltab2x4(:,:,26))
  call Hloop_AQ_W(ntryL,G1H4(10),ex1(:),G1H2(10),m3h2x2(:,19),heltab2x4(:,:,27))
  call Hloop_WQ_A(ntryL,G1H4(3),ex1(:),G1H2(11),m3h2x2(:,20),heltab2x4(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(11),29,0,G2H2(3),n2h2(25))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(17),[G2H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(18),[G2H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(19),[G2H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(20),[G2H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(21),[G2H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(22),[G2H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(23),[G2H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(24),[G2H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(25),[G2H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(26),[G2H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(27),[G2H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(28),[G2H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(29),[G2H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(30),[G2H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(31),[G2H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(32),[G2H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(39),[G1H4(35),G1H4(13),G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(40),[G1H4(36),G1H4(14),G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(42),[G1H4(37),G1H4(17),G1H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(43),[G1H4(38),G1H4(18),G1H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(41),[G1H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(23),[G1H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(24),[G1H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(25),[G1H4(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(26),[G1H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(48),[G1H4(44),G1H4(31),G1H4(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(49),[G1H4(45),G1H4(32),G1H4(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(50),[G1H4(46),G1H4(33),G1H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(51),[G1H4(47),G1H4(34),G1H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(47),[G2H4(46),G2H4(43),G2H4(42),G0H4(3),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(49),[G2H4(48),G2H4(45),G2H4(44),G0H4(5),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(38),[G2H4(37),G2H4(34),G2H4(33),G0H4(8),G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(41),[G2H4(40),G2H4(36),G2H4(35),G0H4(10),G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H4(39),[G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(3),[G1H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(4),[G1H2(2)])
  call Hloop_AV_Q(ntryL,G2H4(17),wf4(:,5),G2H1(1),m3h4x1(:,9),heltab2x4(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(1),n2h1(1))
  call Hloop_AV_Q(ntryL,G2H4(18),wf4(:,5),G2H1(1),m3h4x1(:,10),heltab2x4(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(2),n2h1(2))
  call Hloop_QV_A(ntryL,G2H4(19),wf4(:,5),G2H1(1),m3h4x1(:,11),heltab2x4(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(3),n2h1(3))
  call Hloop_QV_A(ntryL,G2H4(20),wf4(:,5),G2H1(1),m3h4x1(:,12),heltab2x4(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(4),n2h1(4))
  call Hloop_AV_Q(ntryL,G2H4(21),wf4(:,5),G2H1(1),m3h4x1(:,13),heltab2x4(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(5),n2h1(5))
  call Hloop_QV_A(ntryL,G2H4(22),wf4(:,5),G2H1(1),m3h4x1(:,14),heltab2x4(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(6),n2h1(6))
  call Hloop_AV_Q(ntryL,G2H4(23),wf4(:,5),G2H1(1),m3h4x1(:,15),heltab2x4(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(7),n2h1(7))
  call Hloop_QV_A(ntryL,G2H4(24),wf4(:,5),G2H1(1),m3h4x1(:,16),heltab2x4(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(8),n2h1(8))
  call Hloop_AZ_Q(ntryL,G2H4(25),wf4(:,2),G2H1(1),ngZl,m3h4x1(:,17),heltab2x4(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(9),n2h1(9))
  call Hloop_AZ_Q(ntryL,G2H4(26),wf4(:,2),G2H1(1),ngZl,m3h4x1(:,18),heltab2x4(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nML,G3tensor(10),n2h1(10))
  call Hloop_QZ_A(ntryL,G2H4(27),wf4(:,2),G2H1(1),ngZl,m3h4x1(:,19),heltab2x4(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMM,G3tensor(11),n2h1(11))
  call Hloop_QZ_A(ntryL,G2H4(28),wf4(:,2),G2H1(1),ngZl,m3h4x1(:,20),heltab2x4(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nML,G3tensor(12),n2h1(12))
  call Hloop_AZ_Q(ntryL,G2H4(29),wf4(:,2),G2H1(1),ngZu,m3h4x1(:,21),heltab2x4(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(13),n2h1(13))
  call Hloop_QZ_A(ntryL,G2H4(30),wf4(:,2),G2H1(1),ngZu,m3h4x1(:,22),heltab2x4(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMT,G3tensor(14),n2h1(14))
  call Hloop_AZ_Q(ntryL,G2H4(31),wf4(:,2),G2H1(1),ngZd,m3h4x1(:,23),heltab2x4(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(15),n2h1(15))
  call Hloop_QZ_A(ntryL,G2H4(32),wf4(:,2),G2H1(1),ngZd,m3h4x1(:,24),heltab2x4(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),31,nMB,G3tensor(16),n2h1(16))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(39),19,wf4(:,5),12,G2tensor(11),m3h4x1(:,25),heltab2x4(:,:,45))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(40),19,wf4(:,5),12,G2tensor(10),m3h4x1(:,26),heltab2x4(:,:,46))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(42),19,wf4(:,2),12,G2tensor(9),m3h4x1(:,27),heltab2x4(:,:,47))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(43),19,wf4(:,2),12,G2tensor(7),m3h4x1(:,28),heltab2x4(:,:,48))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H4(15),19,wf4(:,2),12,G2tensor(6),m3h4x1(:,29),heltab2x4(:,:,49))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(41),19,wf4(:,2),12,G2tensor(5),m3h4x1(:,30),heltab2x4(:,:,50))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(23),19,wf4(:,5),G2tensor(2),m3h4x1(:,31),heltab2x4(:,:,51))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(24),19,wf4(:,5),12,G2tensor(12),m3h4x1(:,32),heltab2x4(:,:,52))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(25),19,wf4(:,2),G2tensor(1),m3h4x1(:,33),heltab2x4(:,:,53))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(26),19,wf4(:,2),12,G2tensor(8),m3h4x1(:,34),heltab2x4(:,:,54))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(48),19,wf4(:,5),12,G2tensor(3),m3h4x1(:,35),heltab2x4(:,:,55))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(49),19,wf4(:,5),12,G2tensor(4),m3h4x1(:,36),heltab2x4(:,:,56))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(50),19,wf4(:,2),12,G2tensor(13),m3h4x1(:,37),heltab2x4(:,:,57))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(51),19,wf4(:,2),12,G2tensor(14),m3h4x1(:,38),heltab2x4(:,:,58))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(47),wf4(:,5),G2tensor(15),m3h4x1(:,39),heltab2x4(:,:,59))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H4(49),wf4(:,2),G2tensor(16),m3h4x1(:,40),heltab2x4(:,:,60))
  call Hcheck_last_VV_S(ntryL,l_switch,G0H4(4),wf4(:,2),G0tensor(1),m3h4x1(:,41),heltab2x4(:,:,61))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H4(38),wf4(:,5),G2tensor(17),m3h4x1(:,42),heltab2x4(:,:,62))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H4(41),wf4(:,2),G2tensor(18),m3h4x1(:,43),heltab2x4(:,:,63))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H4(39),wf4(:,2),G2tensor(19),m3h4x1(:,44),heltab2x4(:,:,64))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H2(3),ex4(:),G1tensor(2),ngZu,m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H2(4),ex4(:),G1tensor(3),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H8(1),wf8(:,6),G1tensor(34),ngZu,m3h8x1(:,1),heltab2x8(:,:,26))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H8(2),wf8(:,6),G1tensor(11),m3h8x1(:,2),heltab2x8(:,:,27))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H8(3),wf8(:,8),G1tensor(24),ngZu,m3h8x1(:,3),heltab2x8(:,:,28))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H8(4),wf8(:,8),G1tensor(8),m3h8x1(:,4),heltab2x8(:,:,29))
  call Hloop_VA_Q(ntryL,G1H2(5),ex4(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(20),n2h1(17))
  call Hloop_ZA_Q(ntryL,G1H2(6),ex4(:),G1H1(1),ngZu,m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(21),n2h1(18))
  call Hloop_WA_Q(ntryL,G1H2(7),ex4(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(22),n2h1(19))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(10),ex4(:),G2tensor(23),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(7),wf8(:,10),G1tensor(9),ngZl,m3h8x1(:,5),heltab2x8(:,:,30))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(8),wf8(:,10),G1tensor(40),m3h8x1(:,6),heltab2x8(:,:,31))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H8(5),wf8(:,12),G1tensor(30),ngZl,m3h8x1(:,7),heltab2x8(:,:,32))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H8(6),wf8(:,12),G1tensor(14),m3h8x1(:,8),heltab2x8(:,:,33))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H8(9),wf8(:,14),G1tensor(15),ngZl,m3h8x1(:,9),heltab2x8(:,:,34))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H8(10),wf8(:,14),G1tensor(1),m3h8x1(:,10),heltab2x8(:,:,35))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H8(11),wf8(:,16),G1tensor(17),ngZl,m3h8x1(:,11),heltab2x8(:,:,36))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H8(12),wf8(:,16),G1tensor(31),m3h8x1(:,12),heltab2x8(:,:,37))
  call Hloop_VA_Q(ntryL,G1H2(8),ex2(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(24),n2h1(20))
  call Hloop_ZA_Q(ntryL,G1H2(9),ex2(:),G1H1(1),ngZl,m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(25),n2h1(21))
  call Hloop_WA_Q(ntryL,G1H2(10),ex2(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(26),n2h1(22))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(3),ex2(:),G2tensor(27),m3h2x1(:,26),heltab2x2(:,:,26))
  call ol_merge_tensors(G1tensor(7),[G0tensor(57),G0tensor(49)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(13),G0tensor(58),G0tensor(53)])
  call ol_merge_tensors(G1tensor(3),[G1tensor(63),G1tensor(19),G0tensor(199),G0tensor(64),G0tensor(59)])
  call ol_merge_tensors(G2tensor(18),[G2tensor(17),G2tensor(16),G2tensor(15),G2tensor(14),G2tensor(13),G2tensor(4),G2tensor(3) &
    ,G2tensor(8),G2tensor(1),G2tensor(12),G2tensor(2),G2tensor(7),G2tensor(9),G2tensor(10),G2tensor(11),G1tensor(23),G1tensor(12) &
    ,G1tensor(49),G1tensor(25),G0tensor(189),G0tensor(180),G0tensor(69),G0tensor(60)])
  call ol_merge_tensors(G1tensor(37),[G0tensor(67),G0tensor(47)])
  call ol_merge_tensors(G1tensor(43),[G0tensor(68),G0tensor(55)])
  call ol_merge_tensors(G1tensor(14),[G1tensor(40),G1tensor(55),G0tensor(70),G0tensor(65)])
  call ol_merge_tensors(G1tensor(5),[G0tensor(177),G0tensor(169)])
  call ol_merge_tensors(G1tensor(6),[G0tensor(178),G0tensor(173)])
  call ol_merge_tensors(G1tensor(10),[G0tensor(184),G0tensor(179)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(18),G0tensor(187),G0tensor(167)])
  call ol_merge_tensors(G1tensor(22),[G0tensor(188),G0tensor(175)])
  call ol_merge_tensors(G1tensor(31),[G1tensor(1),G1tensor(74),G1tensor(28),G0tensor(210),G0tensor(190),G0tensor(185)])
  call ol_merge_tensors(G1tensor(36),[G0tensor(192)])
  call ol_merge_tensors(G1tensor(42),[G0tensor(193)])
  call ol_merge_tensors(G1tensor(2),[G1tensor(47),G0tensor(194),G0tensor(119),G0tensor(39),G0tensor(19),G0tensor(14)])
  call ol_merge_tensors(G1tensor(24),[G1tensor(34),G1tensor(58),G0tensor(195)])
  call ol_merge_tensors(G1tensor(61),[G0tensor(197)])
  call ol_merge_tensors(G1tensor(62),[G0tensor(198)])
  call ol_merge_tensors(G1tensor(8),[G1tensor(11),G1tensor(64),G0tensor(200)])
  call ol_merge_tensors(G1tensor(66),[G0tensor(202)])
  call ol_merge_tensors(G1tensor(67),[G0tensor(203)])
  call ol_merge_tensors(G1tensor(68),[G0tensor(204)])
  call ol_merge_tensors(G1tensor(17),[G1tensor(15),G1tensor(69),G0tensor(205),G0tensor(155),G0tensor(140),G0tensor(125) &
    ,G0tensor(120)])
  call ol_merge_tensors(G1tensor(71),[G0tensor(207)])
  call ol_merge_tensors(G1tensor(72),[G0tensor(208)])
  call ol_merge_tensors(G1tensor(73),[G0tensor(209)])
  call ol_merge_tensors(G0tensor(72),[G0tensor(22),G0tensor(2)])
  call ol_merge_tensors(G0tensor(7),[G0tensor(3)])
  call ol_merge_tensors(G0tensor(109),[G0tensor(12),G0tensor(4)])
  call ol_merge_tensors(G0tensor(30),[G0tensor(17),G0tensor(5)])
  call ol_merge_tensors(G0tensor(113),[G0tensor(13),G0tensor(8)])
  call ol_merge_tensors(G0tensor(34),[G0tensor(18),G0tensor(9)])
  call ol_merge_tensors(G0tensor(80),[G0tensor(23),G0tensor(10)])
  call ol_merge_tensors(G0tensor(124),[G0tensor(85),G0tensor(24),G0tensor(15)])
  call ol_merge_tensors(G1tensor(30),[G1tensor(9),G0tensor(90),G0tensor(45),G0tensor(25),G0tensor(20)])
  call ol_merge_tensors(G0tensor(92),[G0tensor(42),G0tensor(27)])
  call ol_merge_tensors(G0tensor(32),[G0tensor(28)])
  call ol_merge_tensors(G0tensor(129),[G0tensor(37),G0tensor(29)])
  call ol_merge_tensors(G0tensor(133),[G0tensor(38),G0tensor(33)])
  call ol_merge_tensors(G0tensor(100),[G0tensor(43),G0tensor(35)])
  call ol_merge_tensors(G0tensor(139),[G0tensor(105),G0tensor(44),G0tensor(40)])
  call ol_merge_tensors(G0tensor(52),[G0tensor(48)])
  call ol_merge_tensors(G0tensor(62),[G0tensor(50)])
  call ol_merge_tensors(G0tensor(63),[G0tensor(54)])
  call ol_merge_tensors(G0tensor(77),[G0tensor(73)])
  call ol_merge_tensors(G0tensor(144),[G0tensor(82),G0tensor(74)])
  call ol_merge_tensors(G0tensor(95),[G0tensor(87),G0tensor(75)])
  call ol_merge_tensors(G0tensor(148),[G0tensor(83),G0tensor(78)])
  call ol_merge_tensors(G0tensor(99),[G0tensor(88),G0tensor(79)])
  call ol_merge_tensors(G0tensor(154),[G0tensor(104),G0tensor(89),G0tensor(84)])
  call ol_merge_tensors(G0tensor(97),[G0tensor(93)])
  call ol_merge_tensors(G0tensor(159),[G0tensor(102),G0tensor(94)])
  call ol_merge_tensors(G0tensor(163),[G0tensor(103),G0tensor(98)])
  call ol_merge_tensors(G0tensor(142),[G0tensor(122),G0tensor(107)])
  call ol_merge_tensors(G0tensor(112),[G0tensor(108)])
  call ol_merge_tensors(G0tensor(130),[G0tensor(117),G0tensor(110)])
  call ol_merge_tensors(G0tensor(134),[G0tensor(118),G0tensor(114)])
  call ol_merge_tensors(G0tensor(150),[G0tensor(123),G0tensor(115)])
  call ol_merge_tensors(G0tensor(157),[G0tensor(137),G0tensor(127)])
  call ol_merge_tensors(G0tensor(132),[G0tensor(128)])
  call ol_merge_tensors(G0tensor(165),[G0tensor(138),G0tensor(135)])
  call ol_merge_tensors(G0tensor(147),[G0tensor(143)])
  call ol_merge_tensors(G0tensor(160),[G0tensor(152),G0tensor(145)])
  call ol_merge_tensors(G0tensor(164),[G0tensor(153),G0tensor(149)])
  call ol_merge_tensors(G0tensor(162),[G0tensor(158)])
  call ol_merge_tensors(G0tensor(172),[G0tensor(168)])
  call ol_merge_tensors(G0tensor(182),[G0tensor(170)])
  call ol_merge_tensors(G0tensor(183),[G0tensor(174)])
  call ol_merge_tensors(G3tensor(11),[G3tensor(9),G3tensor(3),G3tensor(1)])
  call ol_merge_tensors(G3tensor(12),[G3tensor(10),G3tensor(4),G3tensor(2)])
  call ol_merge_tensors(G3tensor(14),[G3tensor(13),G3tensor(6),G3tensor(5)])
  call ol_merge_tensors(G3tensor(16),[G3tensor(15),G3tensor(8),G3tensor(7)])
  call ol_merge_tensors(G2tensor(6),[G0tensor(1)])
  call ol_merge_tensors(G2tensor(19),[G2tensor(5)])
  call TI_triangle_red(G2tensor(23),RedBasis(6),mass3set(:,1),G0tensor(6),G0tensor(11),G0tensor(16),G0tensor(21),M2L1R1,[nMW], &
    G0tensor(26))
  call TI_triangle_red(G2tensor(18),RedBasis(2),mass3set(:,2),G0tensor(31),G0tensor(36),G0tensor(41),G0tensor(46),M2L1R1,[nMW], &
    G0tensor(51))
  call TI_triangle_red(G2tensor(27),RedBasis(35),mass3set(:,1),G0tensor(56),G0tensor(61),G0tensor(66),G0tensor(71),M2L1R1,[nMW], &
    G0tensor(76))
  call TI_triangle_red(G3tensor(11),RedBasis(2),mass3set(:,3),G0tensor(81),G0tensor(86),G0tensor(91),G0tensor(96),M2L1R1,[nMM], &
    G0tensor(101))
  call TI_triangle_red(G3tensor(12),RedBasis(2),mass3set(:,4),G0tensor(106),G0tensor(111),G0tensor(116), &
    G0tensor(121),M2L1R1,[nML],G0tensor(126))
  call TI_triangle_red(G3tensor(14),RedBasis(2),mass3set(:,5),G0tensor(131),G0tensor(136),G0tensor(141), &
    G0tensor(146),M2L1R1,[nMT],G0tensor(151))
  call TI_triangle_red(G3tensor(16),RedBasis(2),mass3set(:,6),G0tensor(156),G0tensor(161),G0tensor(166), &
    G0tensor(171),M2L1R1,[nMB],G0tensor(176))
  call TI_triangle_red(G2tensor(6),RedBasis(2),mass3set(:,7),G0tensor(181),G0tensor(186),G0tensor(191), &
    G0tensor(196),M2L1R1,[nMH,nMZ],G0tensor(201),G0tensor(206))
  call TI_triangle_red(G2tensor(19),RedBasis(2),mass3set(:,8),G0tensor(57),G0tensor(49),G0tensor(58), &
    G0tensor(53),M2L1R1,[nMZ,nMH],G0tensor(199),G0tensor(64))
  call TI_triangle_red(G2tensor(20),RedBasis(6),mass3set(:,9),G0tensor(59),G0tensor(189),G0tensor(180),G0tensor(69),M2L1R1)
  call TI_triangle_red(G2tensor(21),RedBasis(6),mass3set(:,10),G0tensor(60),G0tensor(67),G0tensor(47),G0tensor(68),M2L1R1,[nMZ], &
    G0tensor(55))
  call TI_triangle_red(G2tensor(22),RedBasis(6),mass3set(:,11),G0tensor(70),G0tensor(65),G0tensor(177),G0tensor(169),M2L1R1,[nMW], &
    G0tensor(178))
  call TI_triangle_red(G2tensor(24),RedBasis(35),mass3set(:,9),G0tensor(173),G0tensor(184),G0tensor(179),G0tensor(187),M2L1R1)
  call TI_triangle_red(G2tensor(25),RedBasis(35),mass3set(:,10),G0tensor(167),G0tensor(188),G0tensor(175), &
    G0tensor(210),M2L1R1,[nMZ],G0tensor(190))
  call TI_triangle_red(G2tensor(26),RedBasis(35),mass3set(:,11),G0tensor(185),G0tensor(192),G0tensor(193), &
    G0tensor(194),M2L1R1,[nMW],G0tensor(119))
  call TI_triangle_red(G1tensor(7),RedBasis(27),mass3set(:,12),G0tensor(39),G0tensor(19),G0tensor(14),G0tensor(195),M2L1R1,[nMW], &
    G0tensor(197))
  call TI_triangle_red(G1tensor(3),RedBasis(3),mass3set(:,1),G0tensor(198),G0tensor(200),G0tensor(202),G0tensor(203),M2L1R1,[nMW], &
    G0tensor(204))
  call TI_triangle_red(G1tensor(37),RedBasis(36),mass3set(:,1),G0tensor(205),G0tensor(155),G0tensor(140), &
    G0tensor(125),M2L1R1,[nMW],G0tensor(120))
  call TI_triangle_red(G1tensor(43),RedBasis(4),mass3set(:,13),G0tensor(207),G0tensor(208),G0tensor(209), &
    G0tensor(22),M2L1R1,[nMW],G0tensor(2))
  call TI_triangle_red(G1tensor(14),RedBasis(1),mass3set(:,1),G0tensor(3),G0tensor(12),G0tensor(4),G0tensor(17),M2L1R1,[nMW], &
    G0tensor(5))
  call TI_triangle_red(G1tensor(5),RedBasis(23),mass3set(:,12),G0tensor(13),G0tensor(8),G0tensor(18),G0tensor(9),M2L1R1,[nMW], &
    G0tensor(23))
  call TI_triangle_red(G1tensor(6),RedBasis(9),mass3set(:,1),G0tensor(10),G0tensor(85),G0tensor(24),G0tensor(15),M2L1R1,[nMW], &
    G0tensor(90))
  call TI_triangle_red(G1tensor(10),RedBasis(7),mass3set(:,1),G0tensor(45),G0tensor(25),G0tensor(20),G0tensor(42),M2L1R1,[nMW], &
    G0tensor(27))
  call TI_triangle_red(G1tensor(22),RedBasis(11),mass3set(:,13),G0tensor(28),G0tensor(37),G0tensor(29),G0tensor(38),M2L1R1,[nMW], &
    G0tensor(33))
  call TI_triangle_red(G1tensor(31),RedBasis(10),mass3set(:,1),G0tensor(43),G0tensor(35),G0tensor(105),G0tensor(44),M2L1R1,[nMW], &
    G0tensor(40))
  call TI_triangle_red(G1tensor(36),RedBasis(37),mass3set(:,14),G0tensor(48),G0tensor(50),G0tensor(54),G0tensor(73),M2L1R1,[nMZ], &
    G0tensor(82))
  call TI_triangle_red(G1tensor(42),RedBasis(23),mass3set(:,15),G0tensor(74),G0tensor(87),G0tensor(75),G0tensor(83),M2L1R1,[nMZ], &
    G0tensor(78))
  call TI_triangle_red(G1tensor(2),RedBasis(3),mass3set(:,16),G0tensor(88),G0tensor(79),G0tensor(104),G0tensor(89),M2L1R1,[nMZ], &
    G0tensor(84))
  call TI_triangle_red(G1tensor(24),RedBasis(22),mass3set(:,16),G0tensor(93),G0tensor(102),G0tensor(94), &
    G0tensor(103),M2L1R1,[nMZ],G0tensor(98))
  call TI_triangle_red(G1tensor(61),RedBasis(37),mass3set(:,17),G0tensor(122),G0tensor(107),G0tensor(108), &
    G0tensor(117),M2L1R1,[nMW],G0tensor(110))
  call TI_triangle_red(G1tensor(62),RedBasis(23),mass3set(:,18),G0tensor(118),G0tensor(114),G0tensor(123), &
    G0tensor(115),M2L1R1,[nMW],G0tensor(137))
  call TI_triangle_red(G1tensor(8),RedBasis(22),mass3set(:,1),G0tensor(127),G0tensor(128),G0tensor(138), &
    G0tensor(135),M2L1R1,[nMW],G0tensor(143))
  call TI_triangle_red(G1tensor(66),RedBasis(4),mass3set(:,14),G0tensor(152),G0tensor(145),G0tensor(153), &
    G0tensor(149),M2L1R1,[nMZ],G0tensor(158))
  call TI_triangle_red(G1tensor(67),RedBasis(25),mass3set(:,15),G0tensor(168),G0tensor(170),G0tensor(174), &
    G0tensor(1),M2L1R1,[nMZ],G0tensor(211))
  call TI_triangle_red(G1tensor(68),RedBasis(24),mass3set(:,16),G0tensor(212),G0tensor(213),G0tensor(214), &
    G0tensor(215),M2L1R1,[nMZ],G0tensor(216))
  call TI_triangle_red(G1tensor(17),RedBasis(10),mass3set(:,16),G0tensor(217),G0tensor(218),G0tensor(219), &
    G0tensor(220),M2L1R1,[nMZ],G0tensor(221))
  call TI_triangle_red(G1tensor(71),RedBasis(4),mass3set(:,17),G0tensor(222),G0tensor(223),G0tensor(224), &
    G0tensor(225),M2L1R1,[nMW],G0tensor(226))
  call TI_triangle_red(G1tensor(72),RedBasis(25),mass3set(:,18),G0tensor(227),G0tensor(228),G0tensor(229), &
    G0tensor(230),M2L1R1,[nMW],G0tensor(231))
  call TI_triangle_red(G1tensor(73),RedBasis(24),mass3set(:,1),G0tensor(232),G0tensor(233),G0tensor(234), &
    G0tensor(235),M2L1R1,[nMW],G0tensor(236))
  call TI_triangle_red(G1tensor(30),RedBasis(1),mass3set(:,16),G0tensor(237),G0tensor(238),G0tensor(239), &
    G0tensor(240),M2L1R1,[nMZ],G0tensor(241))
  call ol_merge_tensors(T0sum(43),[G0tensor(39)])
  call ol_merge_tensors(T0sum(44),[G0tensor(6)])
  call ol_merge_tensors(T0sum(45),[G0tensor(198)])
  call ol_merge_tensors(T0sum(46),[G0tensor(31)])
  call ol_merge_tensors(T0sum(47),[G0tensor(205)])
  call ol_merge_tensors(T0sum(48),[G0tensor(207)])
  call ol_merge_tensors(T0sum(49),[G0tensor(3)])
  call ol_merge_tensors(T0sum(50),[G0tensor(13)])
  call ol_merge_tensors(T0sum(51),[G0tensor(10)])
  call ol_merge_tensors(T0sum(52),[G0tensor(45)])
  call ol_merge_tensors(T0sum(53),[G0tensor(56)])
  call ol_merge_tensors(T0sum(54),[G0tensor(28)])
  call ol_merge_tensors(T0sum(55),[G0tensor(43)])
  call ol_merge_tensors(T0sum(56),[G0tensor(48)])
  call ol_merge_tensors(T0sum(57),[G0tensor(74)])
  call ol_merge_tensors(T0sum(58),[G0tensor(88)])
  call ol_merge_tensors(T0sum(59),[G0tensor(93)])
  call ol_merge_tensors(T0sum(60),[G0tensor(122)])
  call ol_merge_tensors(T0sum(61),[G0tensor(118)])
  call ol_merge_tensors(T0sum(62),[G0tensor(127)])
  call ol_merge_tensors(T0sum(63),[G0tensor(152)])
  call ol_merge_tensors(T0sum(64),[G0tensor(168)])
  call ol_merge_tensors(T0sum(65),[G0tensor(212)])
  call ol_merge_tensors(T0sum(66),[G0tensor(217)])
  call ol_merge_tensors(T0sum(67),[G0tensor(222)])
  call ol_merge_tensors(T0sum(68),[G0tensor(227)])
  call ol_merge_tensors(T0sum(69),[G0tensor(232)])
  call ol_merge_tensors(T0sum(70),[G0tensor(72)])
  call ol_merge_tensors(T0sum(71),[G0tensor(7)])
  call ol_merge_tensors(T0sum(72),[G0tensor(109)])
  call ol_merge_tensors(T0sum(73),[G0tensor(30)])
  call ol_merge_tensors(T0sum(74),[G0tensor(113)])
  call ol_merge_tensors(T0sum(75),[G0tensor(34)])
  call ol_merge_tensors(T0sum(76),[G0tensor(80)])
  call ol_merge_tensors(T0sum(77),[G0tensor(124)])
  call ol_merge_tensors(T0sum(78),[G0tensor(237)])
  call ol_merge_tensors(T0sum(79),[G0tensor(92)])
  call ol_merge_tensors(T0sum(80),[G0tensor(32)])
  call ol_merge_tensors(T0sum(81),[G0tensor(129)])
  call ol_merge_tensors(T0sum(82),[G0tensor(133)])
  call ol_merge_tensors(T0sum(83),[G0tensor(100)])
  call ol_merge_tensors(T0sum(84),[G0tensor(139)])
  call ol_merge_tensors(T0sum(85),[G0tensor(52)])
  call ol_merge_tensors(T0sum(86),[G0tensor(62)])
  call ol_merge_tensors(T0sum(87),[G0tensor(63)])
  call ol_merge_tensors(T0sum(88),[G0tensor(77)])
  call ol_merge_tensors(T0sum(89),[G0tensor(144)])
  call ol_merge_tensors(T0sum(90),[G0tensor(95)])
  call ol_merge_tensors(T0sum(91),[G0tensor(148)])
  call ol_merge_tensors(T0sum(92),[G0tensor(99)])
  call ol_merge_tensors(T0sum(93),[G0tensor(154)])
  call ol_merge_tensors(T0sum(94),[G0tensor(97)])
  call ol_merge_tensors(T0sum(95),[G0tensor(159)])
  call ol_merge_tensors(T0sum(96),[G0tensor(163)])
  call ol_merge_tensors(T0sum(97),[G0tensor(142)])
  call ol_merge_tensors(T0sum(98),[G0tensor(112)])
  call ol_merge_tensors(T0sum(99),[G0tensor(130)])
  call ol_merge_tensors(T0sum(100),[G0tensor(134)])
  call ol_merge_tensors(T0sum(101),[G0tensor(150)])
  call ol_merge_tensors(T0sum(102),[G0tensor(157)])
  call ol_merge_tensors(T0sum(103),[G0tensor(132)])
  call ol_merge_tensors(T0sum(104),[G0tensor(165)])
  call ol_merge_tensors(T0sum(105),[G0tensor(147)])
  call ol_merge_tensors(T0sum(106),[G0tensor(160)])
  call ol_merge_tensors(T0sum(107),[G0tensor(164)])
  call ol_merge_tensors(T0sum(108),[G0tensor(162)])
  call ol_merge_tensors(T0sum(109),[G0tensor(172)])
  call ol_merge_tensors(T0sum(110),[G0tensor(182)])
  call ol_merge_tensors(T0sum(111),[G0tensor(183)])
  call ol_merge_tensors(T0sum(112),[G0tensor(81)])
  call ol_merge_tensors(T0sum(113),[G0tensor(106)])
  call ol_merge_tensors(T0sum(114),[G0tensor(131)])
  call ol_merge_tensors(T0sum(115),[G0tensor(156)])
  call ol_merge_tensors(T0sum(116),[G0tensor(181)])
  call ol_merge_tensors(T0sum(117),[G0tensor(57)])
  call ol_merge_tensors(T0sum(118),[G0tensor(59)])
  call ol_merge_tensors(T0sum(119),[G0tensor(60)])
  call ol_merge_tensors(T0sum(120),[G0tensor(70)])
  call ol_merge_tensors(T0sum(121),[G0tensor(173)])
  call ol_merge_tensors(T0sum(122),[G0tensor(167)])
  call ol_merge_tensors(T0sum(123),[G0tensor(185)])
  Gcoeff(:)%j = (c(35)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(177),h0tab(:,177),[16,15],[nMW,nMW],3,2,wf4(:,4),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(8),ex5(:),G0H16(11),m3h1x16(:,168),heltab2x16(:,:,328))
  Gcoeff(:)%j = (c(53)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(178),h0tab(:,178),[16,15],[nMW,nMW],3,2,wf4(:,2),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H16(15),ex5(:),G0H16(2),m3h1x16(:,169),heltab2x16(:,:,329))
  Gcoeff(:)%j = (-(c(52)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(17),m0h(179),h0tab(:,179),[16,15],[nMW,nMW],3,2,wf4(:,1),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(17),ex5(:),G0H16(20),m3h1x16(:,170),heltab2x16(:,:,330))
  Gcoeff(:)%j = (-(c(13)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(21),m0h(180),h0tab(:,180),[16,15],[nMH,nMH],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(21),ex5(:),G0H16(24),m3h1x16(:,171),heltab2x16(:,:,331))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(25),m0h(181),h0tab(:,181),[16,15],[nMZ,nMZ],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(25),ex5(:),G0H16(36),m3h1x16(:,172),heltab2x16(:,:,332))
  Gcoeff(:)%j = (-(c(59)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(38),m0h(182),h0tab(:,182),[16,15],[nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(38),ex5(:),G0H16(40),m3h1x16(:,173),heltab2x16(:,:,333))
  Gcoeff(:)%j = (c(38)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(43),m0h(183),h0tab(:,183),[16,15],[nMW,nMW],3,2,wf4(:,4),wf4(:,5))
  call Hloop_VS_V(ntryL,G0H16(43),ex5(:),G0H16(45),m3h1x16(:,174),heltab2x16(:,:,334))
  Gcoeff(:)%j = (c(33)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(47),m0h(184),h0tab(:,184),[16,15],[nMW,nMW],3,2,wf4(:,2),wf4(:,4))
  call Hloop_VS_V(ntryL,G0H16(47),ex5(:),G0H16(49),m3h1x16(:,175),heltab2x16(:,:,335))
  Gcoeff(:)%j = (-(c(32)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(52),m0h(185),h0tab(:,185),[16,15],[nMW,nMW],3,2,wf4(:,1),wf4(:,5))
  call Hloop_VS_V(ntryL,G0H16(52),ex5(:),G0H16(4),m3h1x16(:,176),heltab2x16(:,:,336))
  Gcoeff(:)%j = (-(c(23)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(10),m0h(186),h0tab(:,186),[16,15],[nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VS_V(ntryL,G0H16(10),ex5(:),G0H16(3),m3h1x16(:,177),heltab2x16(:,:,337))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(9),m0h(187),h0tab(:,187),[28,3],[nMW,nMW],3,2,wf4(:,5),wf4(:,4))
  call Hloop_VVS_S(ntryL,G0H16(9),wf4(:,5),ex5(:),G0H4(3),m4h4x1x4(:,1),heltab3x16(:,:,1))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(5),m0h(188),h0tab(:,188),[28,3],[nMW,nMW],3,2,wf4(:,5),wf4(:,4))
  call Hloop_VVS_S(ntryL,G0H16(5),wf4(:,5),ex5(:),G0H4(1),m4h4x1x4(:,2),heltab3x16(:,:,2))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(12),m0h(189),h0tab(:,189),[28,3],[nMW,nMW],3,2,wf4(:,2),wf4(:,4))
  call Hloop_VVS_S(ntryL,G0H16(12),wf4(:,2),ex5(:),G0H4(5),m4h4x1x4(:,3),heltab3x16(:,:,3))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(14),m0h(190),h0tab(:,190),[28,3],[nMW,nMW],3,2,wf4(:,2),wf4(:,4))
  call Hloop_VVS_S(ntryL,G0H16(14),wf4(:,2),ex5(:),G0H4(2),m4h4x1x4(:,4),heltab3x16(:,:,4))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(16),m0h(191),h0tab(:,191),[28,3],[nMW,nMW],3,2,wf4(:,5),wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H16(16),wf4(:,5),ex5(:),G0H4(8),m4h4x1x4(:,5),heltab3x16(:,:,5))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(6),m0h(192),h0tab(:,192),[28,3],[nMW,nMW],3,2,wf4(:,5),wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H16(6),wf4(:,5),ex5(:),G0H4(6),m4h4x1x4(:,6),heltab3x16(:,:,6))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(193),h0tab(:,193),[28,3],[nMH,nMZ],3,2,wf4(:,2),wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H16(7),wf4(:,2),ex5(:),G0H4(10),m4h4x1x4(:,7),heltab3x16(:,:,7))
  Gcoeff(:)%j = (-(c(46)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(194),h0tab(:,194),[28,3],[nMW,nMW],3,2,wf4(:,2),wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H16(1),wf4(:,2),ex5(:),G0H4(7),m4h4x1x4(:,8),heltab3x16(:,:,8))
  Gcoeff(:)%j = (-(c(46)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(13),m0h(195),h0tab(:,195),[28,3],[nMW,nMW],3,2,wf4(:,2),wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H16(13),wf4(:,2),ex5(:),G0H4(9),m4h4x1x4(:,9),heltab3x16(:,:,9))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(18),m0h(196),h0tab(:,196),[19,12],[nMW,nMW],3,2,wf4(:,4),wf4(:,5))
  call Hloop_VVS_S(ntryL,G0H16(18),wf4(:,4),ex5(:),G0H4(4),m4h4x1x4(:,10),heltab3x16(:,:,10))
  Gcoeff(:)%j = (c(36)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(197),h0tab(:,197),[19,12],[nMW,nMW],3,2,wf4(:,4),wf4(:,5))
  call Hloop_VVS_S(ntryL,G0H16(19),wf4(:,4),ex5(:),G0H4(11),m4h4x1x4(:,11),heltab3x16(:,:,11))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(22),m0h(198),h0tab(:,198),[19,12],[nMW,nMW],3,2,wf4(:,4),wf4(:,2))
  call Hloop_VVS_S(ntryL,G0H16(22),wf4(:,4),ex5(:),G0H4(12),m4h4x1x4(:,12),heltab3x16(:,:,12))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(23),m0h(199),h0tab(:,199),[19,12],[nMW,nMW],3,2,wf4(:,4),wf4(:,2))
  call Hloop_VVS_S(ntryL,G0H16(23),wf4(:,4),ex5(:),G0H4(13),m4h4x1x4(:,13),heltab3x16(:,:,13))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(26),m0h(200),h0tab(:,200),[19,12],[nMW,nMW],3,2,wf4(:,1),wf4(:,5))
  call Hloop_VVS_S(ntryL,G0H16(26),wf4(:,1),ex5(:),G0H4(14),m4h4x1x4(:,14),heltab3x16(:,:,14))
  Gcoeff(:)%j = (c(1)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(27),m0h(201),h0tab(:,201),[19,12],[nMW,nMW],3,2,wf4(:,1),wf4(:,5))
  call Hloop_VVS_S(ntryL,G0H16(27),wf4(:,1),ex5(:),G0H4(15),m4h4x1x4(:,15),heltab3x16(:,:,15))
  Gcoeff(:)%j = (-(c(20)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(28),m0h(202),h0tab(:,202),[19,12],[nMH,nMZ],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VVS_S(ntryL,G0H16(28),wf4(:,1),ex5(:),G0H4(16),m4h4x1x4(:,16),heltab3x16(:,:,16))
  Gcoeff(:)%j = (-(c(46)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(29),m0h(203),h0tab(:,203),[19,12],[nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VVS_S(ntryL,G0H16(29),wf4(:,1),ex5(:),G0H4(17),m4h4x1x4(:,17),heltab3x16(:,:,17))
  Gcoeff(:)%j = (-(c(46)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(30),m0h(204),h0tab(:,204),[19,12],[nMW,nMW],3,2,wf4(:,1),wf4(:,2))
  call Hloop_VVS_S(ntryL,G0H16(30),wf4(:,1),ex5(:),G0H4(18),m4h4x1x4(:,18),heltab3x16(:,:,18))
  Gcoeff(:)%j = (-(c(67)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(31),m0h(205),h0tab(:,205),[19,12],[nMM,nMM],2,2,wf4(:,18),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(31),wf4(:,18),G0H4(19),ngX,m3h4x4(:,120),heltab2x16(:,:,338))
  call Hloop_Q_A(ntryL,G0H4(19),19,nMM,G1H4(5),n2h4(40))
  Gcoeff(:)%j = (-(c(65)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(32),m0h(206),h0tab(:,206),[19,12],[nML,nML],2,2,wf4(:,18),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(32),wf4(:,18),G0H4(19),ngX,m3h4x4(:,121),heltab2x16(:,:,339))
  call Hloop_Q_A(ntryL,G0H4(19),19,nML,G1H4(7),n2h4(41))
  Gcoeff(:)%j = (-(c(69)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(33),m0h(207),h0tab(:,207),[19,12],[nMT,nMT],2,2,wf4(:,18),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(33),wf4(:,18),G0H4(19),ngX,m3h4x4(:,122),heltab2x16(:,:,340))
  call Hloop_Q_A(ntryL,G0H4(19),19,nMT,G1H4(6),n2h4(42))
  Gcoeff(:)%j = (-(c(62)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(34),m0h(208),h0tab(:,208),[19,12],[nMB,nMB],2,2,wf4(:,18),wf4(:,5))
  call Hloop_QS_A(ntryL,G0H16(34),wf4(:,18),G0H4(19),ngX,m3h4x4(:,123),heltab2x16(:,:,341))
  call Hloop_Q_A(ntryL,G0H4(19),19,nMB,G1H4(4),n2h4(43))
  Gcoeff(:)%j = (c(68)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(35),m0h(209),h0tab(:,209),[19,12],[nMM,nMM],2,2,wf4(:,18),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H16(35),wf4(:,18),G0H4(19),ngX,m3h4x4(:,124),heltab2x16(:,:,342))
  call Hloop_Q_A(ntryL,G0H4(19),19,nMM,G1H4(8),n2h4(44))
  Gcoeff(:)%j = (c(66)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(37),m0h(210),h0tab(:,210),[19,12],[nML,nML],2,2,wf4(:,18),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H16(37),wf4(:,18),G0H4(19),ngX,m3h4x4(:,125),heltab2x16(:,:,343))
  call Hloop_Q_A(ntryL,G0H4(19),19,nML,G1H4(9),n2h4(45))
  Gcoeff(:)%j = (-(c(71)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(39),m0h(211),h0tab(:,211),[19,12],[nMT,nMT],2,2,wf4(:,18),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H16(39),wf4(:,18),G0H4(19),ngX,m3h4x4(:,126),heltab2x16(:,:,344))
  call Hloop_Q_A(ntryL,G0H4(19),19,nMT,G1H4(10),n2h4(46))
  Gcoeff(:)%j = (c(64)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(41),m0h(212),h0tab(:,212),[19,12],[nMB,nMB],2,2,wf4(:,18),wf4(:,2))
  call Hloop_QS_A(ntryL,G0H16(41),wf4(:,18),G0H4(19),ngX,m3h4x4(:,127),heltab2x16(:,:,345))
  call Hloop_Q_A(ntryL,G0H4(19),19,nMB,G1H4(3),n2h4(47))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(42),m0h(213),h0tab(:,213),[19,12],[nMH,nMZ],2,2,wf4(:,18),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(42),wf4(:,18),G0H4(19),m3h4x4(:,128),heltab2x16(:,:,346))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(44),m0h(214),h0tab(:,214),[19,12],[nMW,nMW],2,2,wf4(:,18),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(44),wf4(:,18),G0H4(20),m3h4x4(:,129),heltab2x16(:,:,347))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(46),m0h(215),h0tab(:,215),[19,12],[nMW,nMW],2,2,wf4(:,18),wf4(:,5))
  call Hloop_SS_S(ntryL,G0H16(46),wf4(:,18),G0H4(21),m3h4x4(:,130),heltab2x16(:,:,348))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(48),m0h(216),h0tab(:,216),[19,12],[nMW,nMW],2,2,wf4(:,18),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(48),wf4(:,18),G0H4(22),m3h4x4(:,131),heltab2x16(:,:,349))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(50),m0h(217),h0tab(:,217),[19,12],[nMW,nMW],2,2,wf4(:,18),wf4(:,2))
  call Hloop_SS_S(ntryL,G0H16(50),wf4(:,18),G0H4(23),m3h4x4(:,132),heltab2x16(:,:,350))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(51),m0h(218),h0tab(:,218),[19,12],[nMW,nMW],2,2,wf4(:,18),wf4(:,5))
  call Hloop_VT_S(ntryL,G0H16(51),0,wf4(:,18),19,G1H4(35),m3h4x4(:,133),heltab2x16(:,:,351))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(53),m0h(219),h0tab(:,219),[19,12],[nMW,nMW],2,2,wf4(:,18),wf4(:,5))
  call Hloop_VT_S(ntryL,G0H16(53),0,wf4(:,18),19,G1H4(13),m3h4x4(:,134),heltab2x16(:,:,352))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(54),m0h(220),h0tab(:,220),[19,12],[nMH,nMZ],2,2,wf4(:,18),wf4(:,2))
  call Hloop_VS_T(ntryL,G0H16(54),0,wf4(:,18),19,G1H4(2),m3h4x4(:,135),heltab2x16(:,:,353))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(55),m0h(221),h0tab(:,221),[19,12],[nMW,nMW],2,2,wf4(:,18),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(55),0,wf4(:,18),19,G1H4(36),m3h4x4(:,136),heltab2x16(:,:,354))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(56),m0h(222),h0tab(:,222),[19,12],[nMW,nMW],2,2,wf4(:,18),wf4(:,2))
  call Hloop_VT_S(ntryL,G0H16(56),0,wf4(:,18),19,G1H4(14),m3h4x4(:,137),heltab2x16(:,:,355))
  Gcoeff(:)%j = (c(87)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(57),m0h(223),h0tab(:,223),[19,12],[0,0],2,2,wf4(:,3),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H16(57),wf4(:,3),G0H4(24),ngZl,m3h4x4(:,138),heltab2x16(:,:,356))
  call Hloop_Q_A(ntryL,G0H4(24),19,0,G1H4(1),n2h4(48))
  Gcoeff(:)%j = (c(87)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(58),m0h(224),h0tab(:,224),[19,12],[nMM,nMM],2,2,wf4(:,3),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H16(58),wf4(:,3),G0H4(24),ngZl,m3h4x4(:,139),heltab2x16(:,:,357))
  call Hloop_Q_A(ntryL,G0H4(24),19,nMM,G1H4(37),n2h4(49))
  Gcoeff(:)%j = (c(87)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(59),m0h(225),h0tab(:,225),[19,12],[nML,nML],2,2,wf4(:,3),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H16(59),wf4(:,3),G0H4(24),ngZl,m3h4x4(:,140),heltab2x16(:,:,358))
  call Hloop_Q_A(ntryL,G0H4(24),19,nML,G1H4(17),n2h4(50))
  Gcoeff(:)%j = (-(c(89)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(60),m0h(226),h0tab(:,226),[19,12],[0,0],2,2,wf4(:,3),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H16(60),wf4(:,3),G0H4(24),ngZu,m3h4x4(:,141),heltab2x16(:,:,359))
  call Hloop_Q_A(ntryL,G0H4(24),19,0,G1H4(11),n2h4(51))
  Gcoeff(:)%j = (-(c(86)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(61),m0h(227),h0tab(:,227),[19,12],[nMT,nMT],2,2,wf4(:,3),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H16(61),wf4(:,3),G0H4(24),ngZu,m3h4x4(:,142),heltab2x16(:,:,360))
  call Hloop_Q_A(ntryL,G0H4(24),19,nMT,G1H4(38),n2h4(52))
  Gcoeff(:)%j = (c(86)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(228),h0tab(:,228),[19,12],[0,0],2,2,wf4(:,3),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H16(62),wf4(:,3),G0H4(24),ngZd,m3h4x4(:,143),heltab2x16(:,:,361))
  call Hloop_Q_A(ntryL,G0H4(24),19,0,G1H4(18),n2h4(53))
  Gcoeff(:)%j = (c(84)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(63),m0h(229),h0tab(:,229),[19,12],[nMB,nMB],2,2,wf4(:,3),wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H16(63),wf4(:,3),G0H4(24),ngZd,m3h4x4(:,144),heltab2x16(:,:,362))
  call Hloop_Q_A(ntryL,G0H4(24),19,nMB,G1H4(12),n2h4(54))
  Gcoeff(:)%j = (-(c(94)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(64),m0h(230),h0tab(:,230),[19,12],[0,0],2,2,wf4(:,3),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H16(64),wf4(:,3),G0H4(24),ngZn,m3h4x4(:,145),heltab2x16(:,:,363))
  call Hloop_Q_A(ntryL,G0H4(24),19,0,G1H4(16),n2h4(55))
  Gcoeff(:)%j = (-(c(90)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(65),m0h(231),h0tab(:,231),[19,12],[0,0],2,2,wf4(:,3),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H16(65),wf4(:,3),G0H4(24),ngZl,m3h4x4(:,146),heltab2x16(:,:,364))
  call Hloop_Q_A(ntryL,G0H4(24),19,0,G1H4(19),n2h4(56))
  Gcoeff(:)%j = (-(c(90)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(66),m0h(232),h0tab(:,232),[19,12],[nMM,nMM],2,2,wf4(:,3),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H16(66),wf4(:,3),G0H4(24),ngZl,m3h4x4(:,147),heltab2x16(:,:,365))
  call Hloop_Q_A(ntryL,G0H4(24),19,nMM,G1H4(20),n2h4(57))
  Gcoeff(:)%j = (-(c(90)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(67),m0h(233),h0tab(:,233),[19,12],[nML,nML],2,2,wf4(:,3),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H16(67),wf4(:,3),G0H4(24),ngZl,m3h4x4(:,148),heltab2x16(:,:,366))
  call Hloop_Q_A(ntryL,G0H4(24),19,nML,G1H4(21),n2h4(58))
  Gcoeff(:)%j = (-(c(93)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(68),m0h(234),h0tab(:,234),[19,12],[0,0],2,2,wf4(:,3),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H16(68),wf4(:,3),G0H4(24),ngZu,m3h4x4(:,149),heltab2x16(:,:,367))
  call Hloop_Q_A(ntryL,G0H4(24),19,0,G1H4(22),n2h4(59))
  Gcoeff(:)%j = (-(c(91)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(69),m0h(235),h0tab(:,235),[19,12],[nMT,nMT],2,2,wf4(:,3),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H16(69),wf4(:,3),G0H4(24),ngZu,m3h4x4(:,150),heltab2x16(:,:,368))
  call Hloop_Q_A(ntryL,G0H4(24),19,nMT,G1H4(44),n2h4(60))
  Gcoeff(:)%j = (-(c(93)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(236),h0tab(:,236),[19,12],[0,0],2,2,wf4(:,3),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H16(8),wf4(:,3),G0H4(24),ngZd,m3h4x4(:,151),heltab2x16(:,:,369))
  call Hloop_Q_A(ntryL,G0H4(24),19,0,G1H4(31),n2h4(61))
  Gcoeff(:)%j = (-(c(91)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(237),h0tab(:,237),[19,12],[nMB,nMB],2,2,wf4(:,3),wf4(:,2))
  call Hloop_QZ_A(ntryL,G0H16(15),wf4(:,3),G0H4(24),ngZd,m3h4x4(:,152),heltab2x16(:,:,370))
  call Hloop_Q_A(ntryL,G0H4(24),19,nMB,G1H4(27),n2h4(62))
  Gcoeff(:)%j = (c(54)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(17),m0h(238),h0tab(:,238),[19,12],[nMW,nMW],2,2,wf4(:,3),wf4(:,5))
  call Hloop_TV_S(ntryL,G0H16(17),0,wf4(:,3),19,G1H4(45),m3h4x4(:,153),heltab2x16(:,:,371))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(21),m0h(239),h0tab(:,239),[19,12],[nMH,nMZ],2,2,wf4(:,3),wf4(:,2))
  call Hloop_SV_T(ntryL,G0H16(21),0,wf4(:,3),19,G1H4(32),m3h4x4(:,154),heltab2x16(:,:,372))
  Gcoeff(:)%j = (c(60)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(25),m0h(240),h0tab(:,240),[19,12],[nMW,nMW],2,2,wf4(:,3),wf4(:,2))
  call Hloop_TV_S(ntryL,G0H16(25),0,wf4(:,3),19,G1H4(28),m3h4x4(:,155),heltab2x16(:,:,373))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(38),m0h(241),h0tab(:,241),[19,12],[nMW,nMW],2,2,wf4(:,3),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H16(38),0,wf4(:,3),19,G1H4(46),m3h4x4(:,156),heltab2x16(:,:,374))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(43),m0h(242),h0tab(:,242),[19,12],[nMW,nMW],2,2,wf4(:,3),wf4(:,5))
  call Hloop_CV_D(ntryL,G0H16(43),0,wf4(:,3),19,G1H4(33),m3h4x4(:,157),heltab2x16(:,:,375))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(47),m0h(243),h0tab(:,243),[19,12],[nMW,nMW],2,2,wf4(:,3),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H16(47),0,wf4(:,3),19,G1H4(29),m3h4x4(:,158),heltab2x16(:,:,376))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(52),m0h(244),h0tab(:,244),[19,12],[nMW,nMW],2,2,wf4(:,3),wf4(:,2))
  call Hloop_CV_D(ntryL,G0H16(52),0,wf4(:,3),19,G1H4(47),m3h4x4(:,159),heltab2x16(:,:,377))
  Gcoeff(:)%j = (c(28)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(10),m0h(245),h0tab(:,245),[19,12],[nMW,nMW],2,2,wf4(:,3),wf4(:,5))
  call Hloop_UV_W(ntryL,G0H16(10),0,wf4(:,3),19,G1H4(34),m3h4x4(:,160),heltab2x16(:,:,378))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(9),m0h(246),h0tab(:,246),[19,12],[nMW,nMW],2,2,wf4(:,3),wf4(:,2))
  call Hloop_UV_W(ntryL,G0H16(9),0,wf4(:,3),19,G1H4(30),m3h4x4(:,161),heltab2x16(:,:,379))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(5),m0h(247),h0tab(:,247),[19,12],[nMW,nMW],2,2,wf4(:,3),wf4(:,5))
  call Hloop_VV_S(ntryL,G0H16(5),wf4(:,3),G0H4(24),m3h4x4(:,162),heltab2x16(:,:,380))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(12),m0h(248),h0tab(:,248),[19,12],[nMW,nMW],2,2,wf4(:,3),wf4(:,5))
  call Hloop_VV_S(ntryL,G0H16(12),wf4(:,3),G0H4(25),m3h4x4(:,163),heltab2x16(:,:,381))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(14),m0h(249),h0tab(:,249),[19,12],[nMH,nMZ],2,2,wf4(:,3),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H16(14),wf4(:,3),G0H4(26),m3h4x4(:,164),heltab2x16(:,:,382))
  Gcoeff(:)%j = (-(c(48)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(16),m0h(250),h0tab(:,250),[19,12],[nMW,nMW],2,2,wf4(:,3),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H16(16),wf4(:,3),G0H4(27),m3h4x4(:,165),heltab2x16(:,:,383))
  Gcoeff(:)%j = (-(c(48)*M(2,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(6),m0h(251),h0tab(:,251),[19,12],[nMW,nMW],2,2,wf4(:,3),wf4(:,2))
  call Hloop_VV_S(ntryL,G0H16(6),wf4(:,3),G0H4(28),m3h4x4(:,166),heltab2x16(:,:,384))
  Gcoeff(:)%j = (c(68)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(7),m0h(252),h0tab(:,252),[28,3],[nMM,nMM],2,2,wf4(:,12),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H16(7),wf4(:,12),G0H4(29),ngX,m3h4x4(:,167),heltab2x16(:,:,385))
  call Hloop_Q_A(ntryL,G0H4(29),28,nMM,G1H4(39),n2h4(63))
  Gcoeff(:)%j = (c(66)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(253),h0tab(:,253),[28,3],[nML,nML],2,2,wf4(:,12),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H16(1),wf4(:,12),G0H4(29),ngX,m3h4x4(:,168),heltab2x16(:,:,386))
  call Hloop_Q_A(ntryL,G0H4(29),28,nML,G1H4(40),n2h4(64))
  Gcoeff(:)%j = (c(70)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(13),m0h(254),h0tab(:,254),[28,3],[nMT,nMT],2,2,wf4(:,12),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H16(13),wf4(:,12),G0H4(29),ngX,m3h4x4(:,169),heltab2x16(:,:,387))
  call Hloop_Q_A(ntryL,G0H4(29),28,nMT,G1H4(42),n2h4(65))
  Gcoeff(:)%j = (c(63)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(18),m0h(255),h0tab(:,255),[28,3],[nMB,nMB],2,2,wf4(:,12),wf4(:,4))
  call Hloop_QS_A(ntryL,G0H16(18),wf4(:,12),G0H4(29),ngX,m3h4x4(:,170),heltab2x16(:,:,388))
  call Hloop_Q_A(ntryL,G0H4(29),28,nMB,G1H4(43),n2h4(66))
  Gcoeff(:)%j = (c(68)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(19),m0h(256),h0tab(:,256),[28,3],[nMM,nMM],2,2,wf4(:,12),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(19),wf4(:,12),G0H4(29),ngX,m3h4x4(:,171),heltab2x16(:,:,389))
  call Hloop_Q_A(ntryL,G0H4(29),28,nMM,G1H4(15),n2h4(67))
  Gcoeff(:)%j = (c(66)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(22),m0h(257),h0tab(:,257),[28,3],[nML,nML],2,2,wf4(:,12),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(22),wf4(:,12),G0H4(29),ngX,m3h4x4(:,172),heltab2x16(:,:,390))
  call Hloop_Q_A(ntryL,G0H4(29),28,nML,G1H4(41),n2h4(68))
  Gcoeff(:)%j = (-(c(71)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(23),m0h(258),h0tab(:,258),[28,3],[nMT,nMT],2,2,wf4(:,12),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(23),wf4(:,12),G0H4(29),ngX,m3h4x4(:,173),heltab2x16(:,:,391))
  call Hloop_Q_A(ntryL,G0H4(29),28,nMT,G1H4(23),n2h4(69))
  Gcoeff(:)%j = (c(64)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(26),m0h(259),h0tab(:,259),[28,3],[nMB,nMB],2,2,wf4(:,12),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H16(26),wf4(:,12),G0H4(29),ngX,m3h4x4(:,174),heltab2x16(:,:,392))
  call Hloop_Q_A(ntryL,G0H4(29),28,nMB,G1H4(24),n2h4(70))
  Gcoeff(:)%j = (-(c(12)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(27),m0h(260),h0tab(:,260),[28,3],[nMH,nMZ],2,2,wf4(:,12),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(27),wf4(:,12),G0H4(29),m3h4x4(:,175),heltab2x16(:,:,393))
  Gcoeff(:)%j = (c(27)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(28),m0h(261),h0tab(:,261),[28,3],[nMW,nMW],2,2,wf4(:,12),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H16(28),wf4(:,12),G0H4(30),m3h4x4(:,176),heltab2x16(:,:,394))
  Gcoeff(:)%j = (c(27)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(29),m0h(262),h0tab(:,262),[28,3],[nMW,nMW],2,2,wf4(:,12),wf4(:,4))
  call Hloop_SS_S(ntryL,G0H16(29),wf4(:,12),G0H4(31),m3h4x4(:,177),heltab2x16(:,:,395))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(30),m0h(263),h0tab(:,263),[28,3],[nMW,nMW],2,2,wf4(:,12),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(30),wf4(:,12),G0H4(32),m3h4x4(:,178),heltab2x16(:,:,396))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(31),m0h(264),h0tab(:,264),[28,3],[nMW,nMW],2,2,wf4(:,12),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H16(31),wf4(:,12),G0H4(33),m3h4x4(:,179),heltab2x16(:,:,397))
  Gcoeff(:)%j = (c(27)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(32),m0h(265),h0tab(:,265),[28,3],[nMW,nMW],2,2,wf4(:,12),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H16(32),0,wf4(:,12),28,G1H4(25),m3h4x4(:,180),heltab2x16(:,:,398))
  Gcoeff(:)%j = (c(27)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(33),m0h(266),h0tab(:,266),[28,3],[nMW,nMW],2,2,wf4(:,12),wf4(:,4))
  call Hloop_VT_S(ntryL,G0H16(33),0,wf4(:,12),28,G1H4(26),m3h4x4(:,181),heltab2x16(:,:,399))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(34),m0h(267),h0tab(:,267),[28,3],[nMH,nMZ],2,2,wf4(:,12),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H16(34),0,wf4(:,12),28,G1H4(48),m3h4x4(:,182),heltab2x16(:,:,400))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(35),m0h(268),h0tab(:,268),[28,3],[nMW,nMW],2,2,wf4(:,12),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(35),0,wf4(:,12),28,G1H4(49),m3h4x4(:,183),heltab2x16(:,:,401))
  Gcoeff(:)%j = (c(39)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(37),m0h(269),h0tab(:,269),[28,3],[nMW,nMW],2,2,wf4(:,12),wf4(:,1))
  call Hloop_VT_S(ntryL,G0H16(37),0,wf4(:,12),28,G1H4(50),m3h4x4(:,184),heltab2x16(:,:,402))
  Gcoeff(:)%j = (-(c(90)*M(2,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(39),m0h(270),h0tab(:,270),[28,3],[0,0],2,2,wf4(:,15),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H16(39),wf4(:,15),G0H4(34),ngZl,m3h4x4(:,185),heltab2x16(:,:,403))
  call Hloop_Q_A(ntryL,G0H4(34),28,0,G1H4(51),n2h4(71))
  Gcoeff(:)%j = (-(c(90)*M(2,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(41),m0h(271),h0tab(:,271),[28,3],[nMM,nMM],2,2,wf4(:,15),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H16(41),wf4(:,15),G0H4(34),ngZl,m3h4x4(:,186),heltab2x16(:,:,404))
  call Hloop_Q_A(ntryL,G0H4(34),28,nMM,G1H4(52),n2h4(72))
  Gcoeff(:)%j = (-(c(90)*M(2,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(42),m0h(272),h0tab(:,272),[28,3],[nML,nML],2,2,wf4(:,15),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H16(42),wf4(:,15),G0H4(34),ngZl,m3h4x4(:,187),heltab2x16(:,:,405))
  call Hloop_Q_A(ntryL,G0H4(34),28,nML,G1H4(53),n2h4(73))
  Gcoeff(:)%j = (c(92)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(44),m0h(273),h0tab(:,273),[28,3],[0,0],2,2,wf4(:,15),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H16(44),wf4(:,15),G0H4(34),ngZu,m3h4x4(:,188),heltab2x16(:,:,406))
  call Hloop_Q_A(ntryL,G0H4(34),28,0,G1H4(54),n2h4(74))
  Gcoeff(:)%j = (c(88)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(46),m0h(274),h0tab(:,274),[28,3],[nMT,nMT],2,2,wf4(:,15),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H16(46),wf4(:,15),G0H4(34),ngZu,m3h4x4(:,189),heltab2x16(:,:,407))
  call Hloop_Q_A(ntryL,G0H4(34),28,nMT,G1H4(55),n2h4(75))
  Gcoeff(:)%j = (-(c(88)*M(2,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(48),m0h(275),h0tab(:,275),[28,3],[0,0],2,2,wf4(:,15),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H16(48),wf4(:,15),G0H4(34),ngZd,m3h4x4(:,190),heltab2x16(:,:,408))
  call Hloop_Q_A(ntryL,G0H4(34),28,0,G1H4(56),n2h4(76))
  Gcoeff(:)%j = (-(c(85)*M(2,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(50),m0h(276),h0tab(:,276),[28,3],[nMB,nMB],2,2,wf4(:,15),wf4(:,4))
  call Hloop_QZ_A(ntryL,G0H16(50),wf4(:,15),G0H4(34),ngZd,m3h4x4(:,191),heltab2x16(:,:,409))
  call Hloop_Q_A(ntryL,G0H4(34),28,nMB,G1H4(57),n2h4(77))
  Gcoeff(:)%j = (-(c(94)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(51),m0h(277),h0tab(:,277),[28,3],[0,0],2,2,wf4(:,15),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(51),wf4(:,15),G0H4(34),ngZn,m3h4x4(:,192),heltab2x16(:,:,410))
  call Hloop_Q_A(ntryL,G0H4(34),28,0,G1H4(58),n2h4(78))
  Gcoeff(:)%j = (-(c(90)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(53),m0h(278),h0tab(:,278),[28,3],[0,0],2,2,wf4(:,15),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(53),wf4(:,15),G0H4(34),ngZl,m3h4x4(:,193),heltab2x16(:,:,411))
  call Hloop_Q_A(ntryL,G0H4(34),28,0,G1H4(59),n2h4(79))
  Gcoeff(:)%j = (-(c(90)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(54),m0h(279),h0tab(:,279),[28,3],[nMM,nMM],2,2,wf4(:,15),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(54),wf4(:,15),G0H4(34),ngZl,m3h4x4(:,194),heltab2x16(:,:,412))
  call Hloop_Q_A(ntryL,G0H4(34),28,nMM,G1H4(60),n2h4(80))
  Gcoeff(:)%j = (-(c(90)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(55),m0h(280),h0tab(:,280),[28,3],[nML,nML],2,2,wf4(:,15),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(55),wf4(:,15),G0H4(34),ngZl,m3h4x4(:,195),heltab2x16(:,:,413))
  call Hloop_Q_A(ntryL,G0H4(34),28,nML,G1H4(61),n2h4(81))
  Gcoeff(:)%j = (-(c(93)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(56),m0h(281),h0tab(:,281),[28,3],[0,0],2,2,wf4(:,15),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(56),wf4(:,15),G0H4(34),ngZu,m3h4x4(:,196),heltab2x16(:,:,414))
  call Hloop_Q_A(ntryL,G0H4(34),28,0,G1H4(62),n2h4(82))
  Gcoeff(:)%j = (-(c(91)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(57),m0h(282),h0tab(:,282),[28,3],[nMT,nMT],2,2,wf4(:,15),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(57),wf4(:,15),G0H4(34),ngZu,m3h4x4(:,197),heltab2x16(:,:,415))
  call Hloop_Q_A(ntryL,G0H4(34),28,nMT,G1H4(63),n2h4(83))
  Gcoeff(:)%j = (-(c(93)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(58),m0h(283),h0tab(:,283),[28,3],[0,0],2,2,wf4(:,15),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(58),wf4(:,15),G0H4(34),ngZd,m3h4x4(:,198),heltab2x16(:,:,416))
  call Hloop_Q_A(ntryL,G0H4(34),28,0,G1H4(64),n2h4(84))
  Gcoeff(:)%j = (-(c(91)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(59),m0h(284),h0tab(:,284),[28,3],[nMB,nMB],2,2,wf4(:,15),wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H16(59),wf4(:,15),G0H4(34),ngZd,m3h4x4(:,199),heltab2x16(:,:,417))
  call Hloop_Q_A(ntryL,G0H4(34),28,nMB,G1H4(65),n2h4(85))
  Gcoeff(:)%j = (-(c(55)*M(2,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(60),m0h(285),h0tab(:,285),[28,3],[nMW,nMW],2,2,wf4(:,15),wf4(:,4))
  call Hloop_TV_S(ntryL,G0H16(60),0,wf4(:,15),28,G1H4(66),m3h4x4(:,200),heltab2x16(:,:,418))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(61),m0h(286),h0tab(:,286),[28,3],[nMH,nMZ],2,2,wf4(:,15),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H16(61),0,wf4(:,15),28,G1H4(67),m3h4x4(:,201),heltab2x16(:,:,419))
  Gcoeff(:)%j = (c(60)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(62),m0h(287),h0tab(:,287),[28,3],[nMW,nMW],2,2,wf4(:,15),wf4(:,1))
  call Hloop_TV_S(ntryL,G0H16(62),0,wf4(:,15),28,G1H4(68),m3h4x4(:,202),heltab2x16(:,:,420))
  Gcoeff(:)%j = (c(29)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(63),m0h(288),h0tab(:,288),[28,3],[nMW,nMW],2,2,wf4(:,15),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H16(63),0,wf4(:,15),28,G1H4(69),m3h4x4(:,203),heltab2x16(:,:,421))
  Gcoeff(:)%j = (c(29)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(64),m0h(289),h0tab(:,289),[28,3],[nMW,nMW],2,2,wf4(:,15),wf4(:,4))
  call Hloop_CV_D(ntryL,G0H16(64),0,wf4(:,15),28,G1H4(70),m3h4x4(:,204),heltab2x16(:,:,422))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(65),m0h(290),h0tab(:,290),[28,3],[nMW,nMW],2,2,wf4(:,15),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(65),0,wf4(:,15),28,G1H4(71),m3h4x4(:,205),heltab2x16(:,:,423))
  Gcoeff(:)%j = (-(c(18)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(66),m0h(291),h0tab(:,291),[28,3],[nMW,nMW],2,2,wf4(:,15),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H16(66),0,wf4(:,15),28,G1H4(72),m3h4x4(:,206),heltab2x16(:,:,424))
  Gcoeff(:)%j = (-(c(29)*M(2,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(67),m0h(292),h0tab(:,292),[28,3],[nMW,nMW],2,2,wf4(:,15),wf4(:,4))
  call Hloop_UV_W(ntryL,G0H16(67),0,wf4(:,15),28,G1H4(73),m3h4x4(:,207),heltab2x16(:,:,425))
  Gcoeff(:)%j = (c(18)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(68),m0h(293),h0tab(:,293),[28,3],[nMW,nMW],2,2,wf4(:,15),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H16(68),0,wf4(:,15),28,G1H4(74),m3h4x4(:,208),heltab2x16(:,:,426))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(69),m0h(294),h0tab(:,294),[28,3],[nMW,nMW],2,2,wf4(:,15),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H16(69),wf4(:,15),G0H4(34),m3h4x4(:,209),heltab2x16(:,:,427))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(8),m0h(295),h0tab(:,295),[28,3],[nMW,nMW],2,2,wf4(:,15),wf4(:,4))
  call Hloop_VV_S(ntryL,G0H16(8),wf4(:,15),G0H4(35),m3h4x4(:,210),heltab2x16(:,:,428))
  Gcoeff(:)%j = (-(c(25)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(15),m0h(296),h0tab(:,296),[28,3],[nMH,nMZ],2,2,wf4(:,15),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(15),wf4(:,15),G0H4(36),m3h4x4(:,211),heltab2x16(:,:,429))
  Gcoeff(:)%j = (-(c(48)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(17),m0h(297),h0tab(:,297),[28,3],[nMW,nMW],2,2,wf4(:,15),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(17),wf4(:,15),G0H4(37),m3h4x4(:,212),heltab2x16(:,:,430))
  Gcoeff(:)%j = (-(c(48)*M(2,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(21),m0h(298),h0tab(:,298),[28,3],[nMW,nMW],2,2,wf4(:,15),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H16(21),wf4(:,15),G0H4(38),m3h4x4(:,213),heltab2x16(:,:,431))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(26),[G1H4(25),G0H4(35),G0H4(34),G0H4(2),G0H4(5),G0H4(1) &
    ,G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(50),[G1H4(49),G0H4(38),G0H4(37),G0H4(9),G0H4(7),G0H4(6) &
    ,G0H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(48),[G0H4(36),G0H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G1H4(35),G0H4(25),G0H4(24),G0H4(15),G0H4(14) &
    ,G0H4(11),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(14),[G1H4(36),G0H4(28),G0H4(27),G0H4(18),G0H4(17) &
    ,G0H4(13),G0H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G0H4(26),G0H4(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(37),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(17),[G1H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(38),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G1H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(21),[G1H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(44),[G1H4(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(27),[G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(32),[G0H4(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(33),[G1H4(46),G0H4(21),G0H4(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(47),[G1H4(29),G0H4(23),G0H4(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(18),[G1H4(11),G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(52),[G1H4(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(53),[G1H4(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(55),[G1H4(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(57),[G1H4(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(60),[G1H4(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(61),[G1H4(41)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(63),[G1H4(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(65),[G1H4(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(67),[G0H4(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(70),[G1H4(69),G0H4(31),G0H4(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(72),[G1H4(71),G0H4(33),G0H4(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(56),[G1H4(54),G1H4(51)])
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H16(11),wf4(:,4),wf4(:,5),G0tensor(39),m4h4x4x1(:,1),heltab3x16(:,:,19))
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H16(2),wf4(:,2),wf4(:,4),G0tensor(6),m4h4x4x1(:,2),heltab3x16(:,:,20))
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H16(20),wf4(:,1),wf4(:,5),G0tensor(198),m4h4x4x1(:,3),heltab3x16(:,:,21))
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H16(24),wf4(:,1),wf4(:,2),G0tensor(31),m4h4x4x1(:,4),heltab3x16(:,:,22))
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H16(36),wf4(:,1),wf4(:,2),G0tensor(205),m4h4x4x1(:,5),heltab3x16(:,:,23))
  call Hcheck_last_SVV_S(ntryL,l_switch,G0H16(40),wf4(:,1),wf4(:,2),G0tensor(207),m4h4x4x1(:,6),heltab3x16(:,:,24))
  call Hcheck_last_VWW_V(ntryL,l_switch,G0H16(45),wf4(:,4),wf4(:,5),G0tensor(3),m4h4x4x1(:,7),heltab3x16(:,:,25))
  call Hcheck_last_VWW_V(ntryL,l_switch,G0H16(49),wf4(:,2),wf4(:,4),G0tensor(13),m4h4x4x1(:,8),heltab3x16(:,:,26))
  call Hcheck_last_VWW_V(ntryL,l_switch,G0H16(4),wf4(:,1),wf4(:,5),G0tensor(10),m4h4x4x1(:,9),heltab3x16(:,:,27))
  call Hcheck_last_VWW_V(ntryL,l_switch,G0H16(3),wf4(:,1),wf4(:,2),G0tensor(45),m4h4x4x1(:,10),heltab3x16(:,:,28))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(26),wf4(:,4),G1tensor(20),m3h4x1(:,45),heltab2x4(:,:,65))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(50),wf4(:,1),G1tensor(21),m3h4x1(:,46),heltab2x4(:,:,66))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(48),wf4(:,1),G1tensor(46),m3h4x1(:,47),heltab2x4(:,:,67))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(13),wf4(:,5),G1tensor(29),m3h4x1(:,48),heltab2x4(:,:,68))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(14),wf4(:,2),G1tensor(26),m3h4x1(:,49),heltab2x4(:,:,69))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(2),wf4(:,2),G1tensor(27),m3h4x1(:,50),heltab2x4(:,:,70))
  call Hloop_QV_A(ntryL,G1H4(37),wf4(:,5),G1H1(1),m3h4x1(:,51),heltab2x4(:,:,71))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(17),n2h1(23))
  call Hloop_QV_A(ntryL,G1H4(17),wf4(:,5),G1H1(1),m3h4x1(:,52),heltab2x4(:,:,72))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(16),n2h1(24))
  call Hloop_QV_A(ntryL,G1H4(38),wf4(:,5),G1H1(1),m3h4x1(:,53),heltab2x4(:,:,73))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(15),n2h1(25))
  call Hloop_QV_A(ntryL,G1H4(12),wf4(:,5),G1H1(1),m3h4x1(:,54),heltab2x4(:,:,74))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(14),n2h1(26))
  call Hloop_QZ_A(ntryL,G1H4(20),wf4(:,2),G1H1(1),ngZl,m3h4x1(:,55),heltab2x4(:,:,75))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(13),n2h1(27))
  call Hloop_QZ_A(ntryL,G1H4(21),wf4(:,2),G1H1(1),ngZl,m3h4x1(:,56),heltab2x4(:,:,76))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(4),n2h1(28))
  call Hloop_QZ_A(ntryL,G1H4(44),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,57),heltab2x4(:,:,77))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(3),n2h1(29))
  call Hloop_QZ_A(ntryL,G1H4(27),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,58),heltab2x4(:,:,78))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(8),n2h1(30))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(32),19,wf4(:,2),12,G2tensor(1),m3h4x1(:,59),heltab2x4(:,:,79))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(33),19,wf4(:,5),12,G2tensor(12),m3h4x1(:,60),heltab2x4(:,:,80))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(47),19,wf4(:,2),12,G2tensor(2),m3h4x1(:,61),heltab2x4(:,:,81))
  call Hloop_QV_A(ntryL,G1H4(18),wf4(:,5),G1H1(1),m3h4x1(:,62),heltab2x4(:,:,82))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(31))
  call Hloop_QZ_A(ntryL,G1H4(16),wf4(:,2),G1H1(1),ngZn,m3h4x1(:,63),heltab2x4(:,:,83))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(9),n2h1(32))
  call Hloop_QZ_A(ntryL,G1H4(19),wf4(:,2),G1H1(1),ngZl,m3h4x1(:,64),heltab2x4(:,:,84))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(10),n2h1(33))
  call Hloop_QZ_A(ntryL,G1H4(22),wf4(:,2),G1H1(1),ngZu,m3h4x1(:,65),heltab2x4(:,:,85))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(11),n2h1(34))
  call Hloop_QZ_A(ntryL,G1H4(31),wf4(:,2),G1H1(1),ngZd,m3h4x1(:,66),heltab2x4(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(5),n2h1(35))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(45),19,wf4(:,5),12,G2tensor(23),m3h4x1(:,67),heltab2x4(:,:,87))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(28),19,wf4(:,2),12,G2tensor(18),m3h4x1(:,68),heltab2x4(:,:,88))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(34),19,wf4(:,5),12,G2tensor(27),m3h4x1(:,69),heltab2x4(:,:,89))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(30),19,wf4(:,2),12,G2tensor(6),m3h4x1(:,70),heltab2x4(:,:,90))
  call Hloop_QV_A(ntryL,G1H4(52),wf4(:,4),G1H1(1),m3h4x1(:,71),heltab2x4(:,:,91))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(19),n2h1(36))
  call Hloop_QV_A(ntryL,G1H4(53),wf4(:,4),G1H1(1),m3h4x1(:,72),heltab2x4(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(20),n2h1(37))
  call Hloop_QV_A(ntryL,G1H4(55),wf4(:,4),G1H1(1),m3h4x1(:,73),heltab2x4(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(21),n2h1(38))
  call Hloop_QV_A(ntryL,G1H4(57),wf4(:,4),G1H1(1),m3h4x1(:,74),heltab2x4(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(22),n2h1(39))
  call Hloop_QZ_A(ntryL,G1H4(60),wf4(:,1),G1H1(1),ngZl,m3h4x1(:,75),heltab2x4(:,:,95))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMM,G2tensor(24),n2h1(40))
  call Hloop_QZ_A(ntryL,G1H4(61),wf4(:,1),G1H1(1),ngZl,m3h4x1(:,76),heltab2x4(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nML,G2tensor(25),n2h1(41))
  call Hloop_QZ_A(ntryL,G1H4(63),wf4(:,1),G1H1(1),ngZu,m3h4x1(:,77),heltab2x4(:,:,97))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(26),n2h1(42))
  call Hloop_QZ_A(ntryL,G1H4(65),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,78),heltab2x4(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(28),n2h1(43))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(67),28,wf4(:,1),3,G2tensor(29),m3h4x1(:,79),heltab2x4(:,:,99))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(70),28,wf4(:,4),3,G2tensor(30),m3h4x1(:,80),heltab2x4(:,:,100))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(72),28,wf4(:,1),3,G2tensor(31),m3h4x1(:,81),heltab2x4(:,:,101))
  call Hloop_QV_A(ntryL,G1H4(56),wf4(:,4),G1H1(1),m3h4x1(:,82),heltab2x4(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(32),n2h1(44))
  call Hloop_QZ_A(ntryL,G1H4(58),wf4(:,1),G1H1(1),ngZn,m3h4x1(:,83),heltab2x4(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(33),n2h1(45))
  call Hloop_QZ_A(ntryL,G1H4(59),wf4(:,1),G1H1(1),ngZl,m3h4x1(:,84),heltab2x4(:,:,104))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(34),n2h1(46))
  call Hloop_QZ_A(ntryL,G1H4(62),wf4(:,1),G1H1(1),ngZu,m3h4x1(:,85),heltab2x4(:,:,105))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(35),n2h1(47))
  call Hloop_QZ_A(ntryL,G1H4(64),wf4(:,1),G1H1(1),ngZd,m3h4x1(:,86),heltab2x4(:,:,106))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(36),n2h1(48))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(66),28,wf4(:,4),3,G2tensor(37),m3h4x1(:,87),heltab2x4(:,:,107))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(68),28,wf4(:,1),3,G2tensor(38),m3h4x1(:,88),heltab2x4(:,:,108))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(73),28,wf4(:,4),3,G2tensor(39),m3h4x1(:,89),heltab2x4(:,:,109))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(74),28,wf4(:,1),3,G2tensor(40),m3h4x1(:,90),heltab2x4(:,:,110))
  call ol_merge_tensors(G0tensor(128),[G0tensor(107),G0tensor(14),G0tensor(11)])
  call ol_merge_tensors(G0tensor(123),[G0tensor(202),G0tensor(16)])
  call ol_merge_tensors(G2tensor(6),[G2tensor(27),G2tensor(18),G2tensor(23),G2tensor(2),G2tensor(12),G1tensor(26),G1tensor(29) &
    ,G0tensor(29),G0tensor(15),G0tensor(209),G0tensor(41),G0tensor(21)])
  call ol_merge_tensors(G0tensor(236),[G0tensor(231),G0tensor(226),G0tensor(143),G0tensor(137),G0tensor(110),G0tensor(40) &
    ,G0tensor(33),G0tensor(27),G0tensor(90),G0tensor(23),G0tensor(5),G0tensor(2),G0tensor(120),G0tensor(204),G0tensor(197) &
    ,G0tensor(119),G0tensor(178),G0tensor(76),G0tensor(51),G0tensor(26)])
  call ol_merge_tensors(G2tensor(40),[G2tensor(39),G2tensor(38),G2tensor(37),G2tensor(31),G2tensor(30),G1tensor(21),G1tensor(20) &
    ,G0tensor(8),G0tensor(125),G0tensor(19),G0tensor(71),G0tensor(36)])
  call ol_merge_tensors(G0tensor(45),[G0tensor(10),G0tensor(13),G0tensor(3),G0tensor(207),G0tensor(198),G0tensor(6),G0tensor(39) &
    ,G0tensor(235),G0tensor(135),G0tensor(44),G0tensor(42),G0tensor(17),G0tensor(203),G0tensor(46)])
  call ol_merge_tensors(G0tensor(223),[G0tensor(35),G0tensor(61)])
  call ol_merge_tensors(G0tensor(234),[G0tensor(229),G0tensor(37),G0tensor(66)])
  call ol_merge_tensors(G2tensor(24),[G2tensor(19),G0tensor(86)])
  call ol_merge_tensors(G2tensor(13),[G2tensor(17),G0tensor(91)])
  call ol_merge_tensors(G2tensor(25),[G2tensor(20),G0tensor(111)])
  call ol_merge_tensors(G2tensor(4),[G2tensor(16),G0tensor(116)])
  call ol_merge_tensors(G2tensor(26),[G2tensor(21),G0tensor(136)])
  call ol_merge_tensors(G2tensor(3),[G2tensor(15),G0tensor(141)])
  call ol_merge_tensors(G2tensor(28),[G2tensor(22),G0tensor(161)])
  call ol_merge_tensors(G2tensor(8),[G2tensor(14),G0tensor(166)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(46),G0tensor(186)])
  call ol_merge_tensors(G0tensor(31),[G0tensor(196)])
  call ol_merge_tensors(G0tensor(64),[G0tensor(201)])
  call ol_merge_tensors(G0tensor(241),[G0tensor(221),G0tensor(216),G0tensor(211),G0tensor(158),G0tensor(98),G0tensor(84) &
    ,G0tensor(78),G0tensor(82),G0tensor(190),G0tensor(55),G0tensor(199),G0tensor(206)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(27),G0tensor(58)])
  call ol_merge_tensors(G0tensor(205),[G0tensor(240),G0tensor(220),G0tensor(215),G0tensor(103),G0tensor(89),G0tensor(53)])
  call ol_merge_tensors(G2tensor(5),[G2tensor(11),G2tensor(10),G2tensor(9),G2tensor(7),G0tensor(228),G0tensor(224),G0tensor(170) &
    ,G0tensor(153),G0tensor(169),G0tensor(68),G0tensor(69)])
  call ol_merge_tensors(G0tensor(20),[G0tensor(24),G0tensor(65)])
  call ol_merge_tensors(G0tensor(85),[G0tensor(18),G0tensor(177)])
  call ol_merge_tensors(G2tensor(36),[G2tensor(35),G2tensor(34),G2tensor(33),G2tensor(32),G0tensor(114),G0tensor(108),G0tensor(87) &
    ,G0tensor(54),G0tensor(194),G0tensor(210),G0tensor(187)])
  call ol_merge_tensors(G0tensor(238),[G0tensor(175)])
  call ol_merge_tensors(G0tensor(208),[G0tensor(140),G0tensor(192)])
  call ol_merge_tensors(G0tensor(12),[G0tensor(155),G0tensor(193)])
  call ol_merge_tensors(G0tensor(117),[G0tensor(200),G0tensor(195)])
  call ol_merge_tensors(G0tensor(4),[G0tensor(22)])
  call ol_merge_tensors(G0tensor(25),[G0tensor(9)])
  call ol_merge_tensors(G0tensor(230),[G0tensor(105),G0tensor(38)])
  call ol_merge_tensors(G0tensor(102),[G0tensor(50)])
  call ol_merge_tensors(G0tensor(79),[G0tensor(73)])
  call ol_merge_tensors(G0tensor(104),[G0tensor(75)])
  call ol_merge_tensors(G0tensor(94),[G0tensor(83)])
  call ol_merge_tensors(G0tensor(138),[G0tensor(115)])
  call ol_merge_tensors(G0tensor(218),[G0tensor(145)])
  call ol_merge_tensors(G0tensor(213),[G0tensor(149)])
  call ol_merge_tensors(G0tensor(214),[G0tensor(174)])
  call ol_merge_tensors(G0tensor(219),[G0tensor(1)])
  call ol_merge_tensors(G0tensor(233),[G0tensor(225)])
call TI_bubble_red(G2tensor(6),19,mass2set(:,1),G0tensor(56),M2L1R1,G0tensor(28))
call TI_bubble_red(G2tensor(40),28,mass2set(:,1),G0tensor(43),M2L1R1,G0tensor(48))
call TI_bubble_red(G2tensor(24),28,mass2set(:,2),G0tensor(74),M2L1R1,G0tensor(88))
call TI_bubble_red(G2tensor(13),19,mass2set(:,2),G0tensor(93),M2L1R1,G0tensor(122))
call TI_bubble_red(G2tensor(25),28,mass2set(:,3),G0tensor(118),M2L1R1,G0tensor(127))
call TI_bubble_red(G2tensor(4),19,mass2set(:,3),G0tensor(152),M2L1R1,G0tensor(168))
call TI_bubble_red(G2tensor(26),28,mass2set(:,4),G0tensor(212),M2L1R1,G0tensor(217))
call TI_bubble_red(G2tensor(3),19,mass2set(:,4),G0tensor(222),M2L1R1,G0tensor(227))
call TI_bubble_red(G2tensor(28),28,mass2set(:,5),G0tensor(232),M2L1R1,G0tensor(72))
call TI_bubble_red(G2tensor(8),19,mass2set(:,5),G0tensor(7),M2L1R1,G0tensor(109))
call TI_bubble_red(G2tensor(29),28,mass2set(:,6),G0tensor(30),M2L1R1,G0tensor(113),G0tensor(34))
call TI_bubble_red(G2tensor(1),19,mass2set(:,6),G0tensor(80),M2L1R1,G0tensor(124),G0tensor(237))
call TI_bubble_red(G2tensor(5),19,mass2set(:,7),G0tensor(92),M2L1R1)
call TI_bubble_red(G2tensor(36),28,mass2set(:,7),G0tensor(32),M2L1R1)
  call ol_merge_tensors(G0tensor(48),[G0tensor(236),G0tensor(28)])
  call ol_merge_tensors(G0tensor(101),[G0tensor(122),G0tensor(88)])
  call ol_merge_tensors(G0tensor(126),[G0tensor(168),G0tensor(127)])
  call ol_merge_tensors(G0tensor(151),[G0tensor(227),G0tensor(217)])
  call ol_merge_tensors(G0tensor(176),[G0tensor(109),G0tensor(72)])
  call ol_merge_tensors(G0tensor(124),[G0tensor(241),G0tensor(113)])
  call ol_merge_tensors(G0tensor(237),[G0tensor(64),G0tensor(34)])
  call ol_merge_tensors(T0sum(124),[G0tensor(128)])
  call ol_merge_tensors(T0sum(125),[G0tensor(123)])
  call ol_merge_tensors(T0sum(126),[G0tensor(56)])
  call ol_merge_tensors(T0sum(127),[G0tensor(48)])
  call ol_merge_tensors(T0sum(128),[G0tensor(43)])
  call ol_merge_tensors(T0sum(129),[G0tensor(45)])
  call ol_merge_tensors(T0sum(130),[G0tensor(223)])
  call ol_merge_tensors(T0sum(131),[G0tensor(234)])
  call ol_merge_tensors(T0sum(132),[G0tensor(74)])
  call ol_merge_tensors(T0sum(133),[G0tensor(101)])
  call ol_merge_tensors(T0sum(134),[G0tensor(93)])
  call ol_merge_tensors(T0sum(135),[G0tensor(96)])
  call ol_merge_tensors(T0sum(136),[G0tensor(118)])
  call ol_merge_tensors(T0sum(137),[G0tensor(126)])
  call ol_merge_tensors(T0sum(138),[G0tensor(152)])
  call ol_merge_tensors(T0sum(139),[G0tensor(121)])
  call ol_merge_tensors(T0sum(140),[G0tensor(212)])
  call ol_merge_tensors(T0sum(141),[G0tensor(151)])
  call ol_merge_tensors(T0sum(142),[G0tensor(222)])
  call ol_merge_tensors(T0sum(143),[G0tensor(146)])
  call ol_merge_tensors(T0sum(144),[G0tensor(232)])
  call ol_merge_tensors(T0sum(145),[G0tensor(176)])
  call ol_merge_tensors(T0sum(146),[G0tensor(7)])
  call ol_merge_tensors(T0sum(147),[G0tensor(171)])
  call ol_merge_tensors(T0sum(148),[G0tensor(30)])
  call ol_merge_tensors(T0sum(149),[G0tensor(124)])
  call ol_merge_tensors(T0sum(150),[G0tensor(237)])
  call ol_merge_tensors(T0sum(151),[G0tensor(191)])
  call ol_merge_tensors(T0sum(152),[G0tensor(31)])
  call ol_merge_tensors(T0sum(153),[G0tensor(49)])
  call ol_merge_tensors(T0sum(154),[G0tensor(80)])
  call ol_merge_tensors(T0sum(155),[G0tensor(205)])
  call ol_merge_tensors(T0sum(156),[G0tensor(189)])
  call ol_merge_tensors(T0sum(157),[G0tensor(180)])
  call ol_merge_tensors(T0sum(158),[G0tensor(92)])
  call ol_merge_tensors(T0sum(159),[G0tensor(67)])
  call ol_merge_tensors(T0sum(160),[G0tensor(47)])
  call ol_merge_tensors(T0sum(161),[G0tensor(20)])
  call ol_merge_tensors(T0sum(162),[G0tensor(85)])
  call ol_merge_tensors(T0sum(163),[G0tensor(184)])
  call ol_merge_tensors(T0sum(164),[G0tensor(179)])
  call ol_merge_tensors(T0sum(165),[G0tensor(32)])
  call ol_merge_tensors(T0sum(166),[G0tensor(188)])
  call ol_merge_tensors(T0sum(167),[G0tensor(238)])
  call ol_merge_tensors(T0sum(168),[G0tensor(208)])
  call ol_merge_tensors(T0sum(169),[G0tensor(12)])
  call ol_merge_tensors(T0sum(170),[G0tensor(117)])
  call ol_merge_tensors(T0sum(171),[G0tensor(4)])
  call ol_merge_tensors(T0sum(172),[G0tensor(25)])
  call ol_merge_tensors(T0sum(173),[G0tensor(230)])
  call ol_merge_tensors(T0sum(174),[G0tensor(102)])
  call ol_merge_tensors(T0sum(175),[G0tensor(79)])
  call ol_merge_tensors(T0sum(176),[G0tensor(104)])
  call ol_merge_tensors(T0sum(177),[G0tensor(94)])
  call ol_merge_tensors(T0sum(178),[G0tensor(138)])
  call ol_merge_tensors(T0sum(179),[G0tensor(218)])
  call ol_merge_tensors(T0sum(180),[G0tensor(213)])
  call ol_merge_tensors(T0sum(181),[G0tensor(214)])
  call ol_merge_tensors(T0sum(182),[G0tensor(219)])
  call ol_merge_tensors(T0sum(183),[G0tensor(233)])
  call ol_merge_tensors(T0sum(184),[G0tensor(239)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 18, 19, 23 ],masses2_41,RedSet_4(1),ScalarBoxes(1))
  call compute_scalar_box([ 16, 19, 23 ],masses2_49,RedSet_4(2),ScalarBoxes(2))
  call compute_scalar_box([ 16, 18, 23 ],masses2_49,RedSet_4(3),ScalarBoxes(3))
  call compute_scalar_box([ 16, 18, 19 ],masses2_49,RedSet_4(4),ScalarBoxes(4))
  call compute_scalar_box([ 2, 3, 7 ],masses2_41,RedSet_4(5),ScalarBoxes(5))
  call compute_scalar_box([ 18, 19, 23 ],masses2_43,RedSet_4(1),ScalarBoxes(6))
  call compute_scalar_box([ 16, 19, 23 ],masses2_52,RedSet_4(2),ScalarBoxes(7))
  call compute_scalar_box([ 16, 18, 19 ],masses2_51,RedSet_4(4),ScalarBoxes(8))
  call compute_scalar_box([ 2, 3, 7 ],masses2_43,RedSet_4(5),ScalarBoxes(9))
  call compute_scalar_box([ 18, 19, 23 ],masses2_42,RedSet_4(1),ScalarBoxes(10))
  call compute_scalar_box([ 16, 19, 23 ],masses2_47,RedSet_4(2),ScalarBoxes(11))
  call compute_scalar_box([ 16, 18, 23 ],masses2_44,RedSet_4(3),ScalarBoxes(12))
  call compute_scalar_box([ 16, 18, 19 ],masses2_46,RedSet_4(4),ScalarBoxes(13))
  call compute_scalar_box([ 2, 3, 7 ],masses2_42,RedSet_4(5),ScalarBoxes(14))
  call compute_scalar_box([ 18, 19, 27 ],masses2_41,RedSet_4(6),ScalarBoxes(15))
  call compute_scalar_box([ 16, 19, 27 ],masses2_49,RedSet_4(7),ScalarBoxes(16))
  call compute_scalar_box([ 16, 18, 27 ],masses2_49,RedSet_4(8),ScalarBoxes(17))
  call compute_scalar_box([ 2, 3, 11 ],masses2_41,RedSet_4(9),ScalarBoxes(18))
  call compute_scalar_box([ 18, 19, 27 ],masses2_43,RedSet_4(6),ScalarBoxes(19))
  call compute_scalar_box([ 16, 19, 27 ],masses2_52,RedSet_4(7),ScalarBoxes(20))
  call compute_scalar_box([ 2, 3, 11 ],masses2_43,RedSet_4(9),ScalarBoxes(21))
  call compute_scalar_box([ 17, 19, 23 ],masses2_41,RedSet_4(10),ScalarBoxes(22))
  call compute_scalar_box([ 16, 17, 23 ],masses2_49,RedSet_4(11),ScalarBoxes(23))
  call compute_scalar_box([ 16, 17, 19 ],masses2_49,RedSet_4(12),ScalarBoxes(24))
  call compute_scalar_box([ 1, 3, 7 ],masses2_41,RedSet_4(13),ScalarBoxes(25))
  call compute_scalar_box([ 17, 19, 23 ],masses2_43,RedSet_4(10),ScalarBoxes(26))
  call compute_scalar_box([ 16, 17, 19 ],masses2_51,RedSet_4(12),ScalarBoxes(27))
  call compute_scalar_box([ 1, 3, 7 ],masses2_43,RedSet_4(13),ScalarBoxes(28))
  call compute_scalar_box([ 17, 19, 27 ],masses2_41,RedSet_4(14),ScalarBoxes(29))
  call compute_scalar_box([ 16, 17, 27 ],masses2_49,RedSet_4(15),ScalarBoxes(30))
  call compute_scalar_box([ 1, 3, 11 ],masses2_41,RedSet_4(16),ScalarBoxes(31))
  call compute_scalar_box([ 17, 19, 27 ],masses2_43,RedSet_4(14),ScalarBoxes(32))
  call compute_scalar_box([ 1, 3, 11 ],masses2_43,RedSet_4(16),ScalarBoxes(33))
  call compute_scalar_box([ 17, 19, 27 ],masses2_42,RedSet_4(14),ScalarBoxes(34))
  call compute_scalar_box([ 16, 19, 27 ],masses2_47,RedSet_4(7),ScalarBoxes(35))
  call compute_scalar_box([ 16, 17, 27 ],masses2_44,RedSet_4(15),ScalarBoxes(36))
  call compute_scalar_box([ 16, 17, 19 ],masses2_46,RedSet_4(12),ScalarBoxes(37))
  call compute_scalar_box([ 1, 3, 11 ],masses2_42,RedSet_4(16),ScalarBoxes(38))
! end of process


end subroutine vamp_1

end module ol_vamp_1_pphll_ew_eexuuxh_1_/**/REALKIND
