
module ol_vamp_8_pphjjj2_hggggg_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_8(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphjjj2_hggggg_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphjjj2_hggggg_2.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphjjj2_hggggg_2_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphjjj2_hggggg_2_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(24)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,115) :: G0
  complex(REALKIND), dimension(4,5,4,410) :: G1
  complex(REALKIND), dimension(4,15,4,642) :: G2
  complex(REALKIND), dimension(4,35,4,284) :: G3
  complex(REALKIND), dimension(4,70,4,100) :: G4
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,204,32))
    allocate(G4tensorhel(70,92,32))
    allocate(G5tensorhel(126,50,32))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,18),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,10),MT,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,19),G1(:,:,:,2))
  call loop_Q_A(G1(:,:,:,2),Q(:,62),MT,G2(:,:,:,1))
  call loop_QS_A(G2(:,:,:,1),wf(:,0),G2(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,2),Q(:,63),MT,G3tensor(:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,21),G1(:,:,:,3))
  call loop_Q_A(G1(:,:,:,3),Q(:,62),MT,G2(:,:,:,3))
  call loop_QS_A(G2(:,:,:,3),wf(:,0),G2(:,:,:,4),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,63),MT,G3tensor(:,2))
  call loop_QV_A(G1(:,:,:,1),wf(:,22),G1(:,:,:,4))
  call loop_Q_A(G1(:,:,:,4),Q(:,62),MT,G2(:,:,:,5))
  call loop_QS_A(G2(:,:,:,5),wf(:,0),G2(:,:,:,6),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,6),Q(:,63),MT,G3tensor(:,3))
  call loop_QV_A(G1(:,:,:,1),wf(:,175),G1(:,:,:,5))
  call loop_Q_A(G1(:,:,:,5),Q(:,62),MT,G2(:,:,:,7))
  call loop_QS_A(G2(:,:,:,7),wf(:,0),G2(:,:,:,8),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,63),MT,G3tensor(:,4))
  call loop_QV_A(G1(:,:,:,1),wf(:,76),G1(:,:,:,6))
  call loop_Q_A(G1(:,:,:,6),Q(:,30),MT,G2(:,:,:,9))
  call loop_QV_A(G2(:,:,:,9),wf(:,-5),G2(:,:,:,10))
  call loop_Q_A(G2(:,:,:,10),Q(:,62),MT,G3(:,:,:,1))
  call loop_QS_A(G3(:,:,:,1),wf(:,0),G3(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,2),Q(:,63),MT,G4tensor(:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,-5),G1(:,:,:,7))
  call loop_Q_A(G1(:,:,:,7),Q(:,42),MT,G2(:,:,:,11))
  call loop_QV_A(G2(:,:,:,11),wf(:,76),G2(:,:,:,12))
  call loop_Q_A(G2(:,:,:,12),Q(:,62),MT,G3(:,:,:,3))
  call loop_QS_A(G3(:,:,:,3),wf(:,0),G3(:,:,:,4),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,4),Q(:,63),MT,G4tensor(:,2))
  call loop_QV_A(G2(:,:,:,11),wf(:,-2),G2(:,:,:,13))
  call loop_Q_A(G2(:,:,:,13),Q(:,46),MT,G3(:,:,:,5))
  call loop_QV_A(G3(:,:,:,5),wf(:,-4),G3(:,:,:,6))
  call loop_Q_A(G3(:,:,:,6),Q(:,62),MT,G4(:,:,:,1))
  call loop_QS_A(G4(:,:,:,1),wf(:,0),G4(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,2),Q(:,63),MT,G5tensor(:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,178),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,62),MT,G2(:,:,:,14))
  call loop_QS_A(G2(:,:,:,14),wf(:,0),G2(:,:,:,15),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,15),Q(:,63),MT,G3tensor(:,5))
  call loop_QV_A(G1(:,:,:,1),wf(:,84),G1(:,:,:,9))
  call loop_Q_A(G1(:,:,:,9),Q(:,46),MT,G2(:,:,:,16))
  call loop_QV_A(G2(:,:,:,16),wf(:,-4),G2(:,:,:,17))
  call loop_Q_A(G2(:,:,:,17),Q(:,62),MT,G3(:,:,:,7))
  call loop_QS_A(G3(:,:,:,7),wf(:,0),G3(:,:,:,8),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,8),Q(:,63),MT,G4tensor(:,3))
  call loop_QV_A(G1(:,:,:,1),wf(:,-4),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,26),MT,G2(:,:,:,18))
  call loop_QV_A(G2(:,:,:,18),wf(:,84),G2(:,:,:,19))
  call loop_Q_A(G2(:,:,:,19),Q(:,62),MT,G3(:,:,:,9))
  call loop_QS_A(G3(:,:,:,9),wf(:,0),G3(:,:,:,10),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,10),Q(:,63),MT,G4tensor(:,4))
  call loop_QV_A(G2(:,:,:,18),wf(:,-2),G2(:,:,:,20))
  call loop_Q_A(G2(:,:,:,20),Q(:,30),MT,G3(:,:,:,11))
  call loop_QV_A(G3(:,:,:,11),wf(:,-5),G3(:,:,:,12))
  call loop_Q_A(G3(:,:,:,12),Q(:,62),MT,G4(:,:,:,3))
  call loop_QS_A(G4(:,:,:,3),wf(:,0),G4(:,:,:,4),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,4),Q(:,63),MT,G5tensor(:,2))
  call loop_QV_A(G1(:,:,:,1),wf(:,180),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,62),MT,G2(:,:,:,21))
  call loop_QS_A(G2(:,:,:,21),wf(:,0),G2(:,:,:,22),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,22),Q(:,63),MT,G3tensor(:,6))
  call loop_QV_A(G1(:,:,:,1),wf(:,-2),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,14),MT,G2(:,:,:,23))
  call loop_QV_A(G2(:,:,:,23),wf(:,119),G2(:,:,:,24))
  call loop_Q_A(G2(:,:,:,24),Q(:,62),MT,G3(:,:,:,13))
  call loop_QS_A(G3(:,:,:,13),wf(:,0),G3(:,:,:,14),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,14),Q(:,63),MT,G4tensor(:,5))
  call loop_QV_A(G2(:,:,:,23),wf(:,-5),G2(:,:,:,25))
  call loop_Q_A(G2(:,:,:,25),Q(:,46),MT,G3(:,:,:,15))
  call loop_QV_A(G3(:,:,:,15),wf(:,-4),G3(:,:,:,16))
  call loop_Q_A(G3(:,:,:,16),Q(:,62),MT,G4(:,:,:,5))
  call loop_QS_A(G4(:,:,:,5),wf(:,0),G4(:,:,:,6),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,6),Q(:,63),MT,G5tensor(:,3))
  call loop_QV_A(G2(:,:,:,23),wf(:,-4),G2(:,:,:,26))
  call loop_Q_A(G2(:,:,:,26),Q(:,30),MT,G3(:,:,:,17))
  call loop_QV_A(G3(:,:,:,17),wf(:,-5),G3(:,:,:,18))
  call loop_Q_A(G3(:,:,:,18),Q(:,62),MT,G4(:,:,:,7))
  call loop_QS_A(G4(:,:,:,7),wf(:,0),G4(:,:,:,8),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,8),Q(:,63),MT,G5tensor(:,4))
  call loop_AV_Q(G0(:,:,:,1),wf(:,18),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,10),MB,G1(:,:,:,13))
  call loop_AV_Q(G1(:,:,:,13),wf(:,19),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,62),MB,G2(:,:,:,27))
  call loop_AS_Q(G2(:,:,:,27),wf(:,0),G2(:,:,:,28),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,28),Q(:,63),MB,G3tensor(:,7))
  call loop_AV_Q(G1(:,:,:,13),wf(:,21),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,62),MB,G2(:,:,:,29))
  call loop_AS_Q(G2(:,:,:,29),wf(:,0),G2(:,:,:,30),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,30),Q(:,63),MB,G3tensor(:,8))
  call loop_AV_Q(G1(:,:,:,13),wf(:,22),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,62),MB,G2(:,:,:,31))
  call loop_AS_Q(G2(:,:,:,31),wf(:,0),G2(:,:,:,32),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,32),Q(:,63),MB,G3tensor(:,9))
  call loop_AV_Q(G1(:,:,:,13),wf(:,175),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,62),MB,G2(:,:,:,33))
  call loop_AS_Q(G2(:,:,:,33),wf(:,0),G2(:,:,:,34),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,34),Q(:,63),MB,G3tensor(:,10))
  call loop_AV_Q(G1(:,:,:,13),wf(:,76),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,30),MB,G2(:,:,:,35))
  call loop_AV_Q(G2(:,:,:,35),wf(:,-5),G2(:,:,:,36))
  call loop_A_Q(G2(:,:,:,36),Q(:,62),MB,G3(:,:,:,19))
  call loop_AS_Q(G3(:,:,:,19),wf(:,0),G3(:,:,:,20),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,20),Q(:,63),MB,G4tensor(:,6))
  call loop_AV_Q(G1(:,:,:,13),wf(:,-5),G1(:,:,:,19))
  call loop_A_Q(G1(:,:,:,19),Q(:,42),MB,G2(:,:,:,37))
  call loop_AV_Q(G2(:,:,:,37),wf(:,76),G2(:,:,:,38))
  call loop_A_Q(G2(:,:,:,38),Q(:,62),MB,G3(:,:,:,21))
  call loop_AS_Q(G3(:,:,:,21),wf(:,0),G3(:,:,:,22),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,22),Q(:,63),MB,G4tensor(:,7))
  call loop_AV_Q(G2(:,:,:,37),wf(:,-2),G2(:,:,:,39))
  call loop_A_Q(G2(:,:,:,39),Q(:,46),MB,G3(:,:,:,23))
  call loop_AV_Q(G3(:,:,:,23),wf(:,-4),G3(:,:,:,24))
  call loop_A_Q(G3(:,:,:,24),Q(:,62),MB,G4(:,:,:,9))
  call loop_AS_Q(G4(:,:,:,9),wf(:,0),G4(:,:,:,10),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,10),Q(:,63),MB,G5tensor(:,5))
  call loop_AV_Q(G1(:,:,:,13),wf(:,178),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,62),MB,G2(:,:,:,40))
  call loop_AS_Q(G2(:,:,:,40),wf(:,0),G2(:,:,:,41),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,41),Q(:,63),MB,G3tensor(:,11))
  call loop_AV_Q(G1(:,:,:,13),wf(:,84),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,46),MB,G2(:,:,:,42))
  call loop_AV_Q(G2(:,:,:,42),wf(:,-4),G2(:,:,:,43))
  call loop_A_Q(G2(:,:,:,43),Q(:,62),MB,G3(:,:,:,25))
  call loop_AS_Q(G3(:,:,:,25),wf(:,0),G3(:,:,:,26),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,26),Q(:,63),MB,G4tensor(:,8))
  call loop_AV_Q(G1(:,:,:,13),wf(:,-4),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,26),MB,G2(:,:,:,44))
  call loop_AV_Q(G2(:,:,:,44),wf(:,84),G2(:,:,:,45))
  call loop_A_Q(G2(:,:,:,45),Q(:,62),MB,G3(:,:,:,27))
  call loop_AS_Q(G3(:,:,:,27),wf(:,0),G3(:,:,:,28),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,28),Q(:,63),MB,G4tensor(:,9))
  call loop_AV_Q(G2(:,:,:,44),wf(:,-2),G2(:,:,:,46))
  call loop_A_Q(G2(:,:,:,46),Q(:,30),MB,G3(:,:,:,29))
  call loop_AV_Q(G3(:,:,:,29),wf(:,-5),G3(:,:,:,30))
  call loop_A_Q(G3(:,:,:,30),Q(:,62),MB,G4(:,:,:,11))
  call loop_AS_Q(G4(:,:,:,11),wf(:,0),G4(:,:,:,12),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,12),Q(:,63),MB,G5tensor(:,6))
  call loop_AV_Q(G1(:,:,:,13),wf(:,180),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,62),MB,G2(:,:,:,47))
  call loop_AS_Q(G2(:,:,:,47),wf(:,0),G2(:,:,:,48),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,48),Q(:,63),MB,G3tensor(:,12))
  call loop_AV_Q(G1(:,:,:,13),wf(:,-2),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,14),MB,G2(:,:,:,49))
  call loop_AV_Q(G2(:,:,:,49),wf(:,119),G2(:,:,:,50))
  call loop_A_Q(G2(:,:,:,50),Q(:,62),MB,G3(:,:,:,31))
  call loop_AS_Q(G3(:,:,:,31),wf(:,0),G3(:,:,:,32),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,32),Q(:,63),MB,G4tensor(:,10))
  call loop_AV_Q(G2(:,:,:,49),wf(:,-5),G2(:,:,:,51))
  call loop_A_Q(G2(:,:,:,51),Q(:,46),MB,G3(:,:,:,33))
  call loop_AV_Q(G3(:,:,:,33),wf(:,-4),G3(:,:,:,34))
  call loop_A_Q(G3(:,:,:,34),Q(:,62),MB,G4(:,:,:,13))
  call loop_AS_Q(G4(:,:,:,13),wf(:,0),G4(:,:,:,14),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,14),Q(:,63),MB,G5tensor(:,7))
  call loop_AV_Q(G2(:,:,:,49),wf(:,-4),G2(:,:,:,52))
  call loop_A_Q(G2(:,:,:,52),Q(:,30),MB,G3(:,:,:,35))
  call loop_AV_Q(G3(:,:,:,35),wf(:,-5),G3(:,:,:,36))
  call loop_A_Q(G3(:,:,:,36),Q(:,62),MB,G4(:,:,:,15))
  call loop_AS_Q(G4(:,:,:,15),wf(:,0),G4(:,:,:,16),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,16),Q(:,63),MB,G5tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,18),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,10),MB,G1(:,:,:,25))
  call loop_QV_A(G1(:,:,:,25),wf(:,19),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,62),MB,G2(:,:,:,53))
  call loop_QS_A(G2(:,:,:,53),wf(:,0),G2(:,:,:,54),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,54),Q(:,63),MB,G3tensor(:,13))
  call loop_QV_A(G1(:,:,:,25),wf(:,21),G1(:,:,:,27))
  call loop_Q_A(G1(:,:,:,27),Q(:,62),MB,G2(:,:,:,55))
  call loop_QS_A(G2(:,:,:,55),wf(:,0),G2(:,:,:,56),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,56),Q(:,63),MB,G3tensor(:,14))
  call loop_QV_A(G1(:,:,:,25),wf(:,22),G1(:,:,:,28))
  call loop_Q_A(G1(:,:,:,28),Q(:,62),MB,G2(:,:,:,57))
  call loop_QS_A(G2(:,:,:,57),wf(:,0),G2(:,:,:,58),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,58),Q(:,63),MB,G3tensor(:,15))
  call loop_QV_A(G1(:,:,:,25),wf(:,175),G1(:,:,:,29))
  call loop_Q_A(G1(:,:,:,29),Q(:,62),MB,G2(:,:,:,59))
  call loop_QS_A(G2(:,:,:,59),wf(:,0),G2(:,:,:,60),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,60),Q(:,63),MB,G3tensor(:,16))
  call loop_QV_A(G1(:,:,:,25),wf(:,76),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,30),MB,G2(:,:,:,61))
  call loop_QV_A(G2(:,:,:,61),wf(:,-5),G2(:,:,:,62))
  call loop_Q_A(G2(:,:,:,62),Q(:,62),MB,G3(:,:,:,37))
  call loop_QS_A(G3(:,:,:,37),wf(:,0),G3(:,:,:,38),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,38),Q(:,63),MB,G4tensor(:,11))
  call loop_QV_A(G1(:,:,:,25),wf(:,-5),G1(:,:,:,31))
  call loop_Q_A(G1(:,:,:,31),Q(:,42),MB,G2(:,:,:,63))
  call loop_QV_A(G2(:,:,:,63),wf(:,76),G2(:,:,:,64))
  call loop_Q_A(G2(:,:,:,64),Q(:,62),MB,G3(:,:,:,39))
  call loop_QS_A(G3(:,:,:,39),wf(:,0),G3(:,:,:,40),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,40),Q(:,63),MB,G4tensor(:,12))
  call loop_QV_A(G2(:,:,:,63),wf(:,-2),G2(:,:,:,65))
  call loop_Q_A(G2(:,:,:,65),Q(:,46),MB,G3(:,:,:,41))
  call loop_QV_A(G3(:,:,:,41),wf(:,-4),G3(:,:,:,42))
  call loop_Q_A(G3(:,:,:,42),Q(:,62),MB,G4(:,:,:,17))
  call loop_QS_A(G4(:,:,:,17),wf(:,0),G4(:,:,:,18),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,18),Q(:,63),MB,G5tensor(:,9))
  call loop_QV_A(G1(:,:,:,25),wf(:,178),G1(:,:,:,32))
  call loop_Q_A(G1(:,:,:,32),Q(:,62),MB,G2(:,:,:,66))
  call loop_QS_A(G2(:,:,:,66),wf(:,0),G2(:,:,:,67),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,67),Q(:,63),MB,G3tensor(:,17))
  call loop_QV_A(G1(:,:,:,25),wf(:,84),G1(:,:,:,33))
  call loop_Q_A(G1(:,:,:,33),Q(:,46),MB,G2(:,:,:,68))
  call loop_QV_A(G2(:,:,:,68),wf(:,-4),G2(:,:,:,69))
  call loop_Q_A(G2(:,:,:,69),Q(:,62),MB,G3(:,:,:,43))
  call loop_QS_A(G3(:,:,:,43),wf(:,0),G3(:,:,:,44),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,44),Q(:,63),MB,G4tensor(:,13))
  call loop_QV_A(G1(:,:,:,25),wf(:,-4),G1(:,:,:,34))
  call loop_Q_A(G1(:,:,:,34),Q(:,26),MB,G2(:,:,:,70))
  call loop_QV_A(G2(:,:,:,70),wf(:,84),G2(:,:,:,71))
  call loop_Q_A(G2(:,:,:,71),Q(:,62),MB,G3(:,:,:,45))
  call loop_QS_A(G3(:,:,:,45),wf(:,0),G3(:,:,:,46),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,46),Q(:,63),MB,G4tensor(:,14))
  call loop_QV_A(G2(:,:,:,70),wf(:,-2),G2(:,:,:,72))
  call loop_Q_A(G2(:,:,:,72),Q(:,30),MB,G3(:,:,:,47))
  call loop_QV_A(G3(:,:,:,47),wf(:,-5),G3(:,:,:,48))
  call loop_Q_A(G3(:,:,:,48),Q(:,62),MB,G4(:,:,:,19))
  call loop_QS_A(G4(:,:,:,19),wf(:,0),G4(:,:,:,20),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,20),Q(:,63),MB,G5tensor(:,10))
  call loop_QV_A(G1(:,:,:,25),wf(:,180),G1(:,:,:,35))
  call loop_Q_A(G1(:,:,:,35),Q(:,62),MB,G2(:,:,:,73))
  call loop_QS_A(G2(:,:,:,73),wf(:,0),G2(:,:,:,74),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,74),Q(:,63),MB,G3tensor(:,18))
  call loop_QV_A(G1(:,:,:,25),wf(:,-2),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,14),MB,G2(:,:,:,75))
  call loop_QV_A(G2(:,:,:,75),wf(:,119),G2(:,:,:,76))
  call loop_Q_A(G2(:,:,:,76),Q(:,62),MB,G3(:,:,:,49))
  call loop_QS_A(G3(:,:,:,49),wf(:,0),G3(:,:,:,50),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,50),Q(:,63),MB,G4tensor(:,15))
  call loop_QV_A(G2(:,:,:,75),wf(:,-5),G2(:,:,:,77))
  call loop_Q_A(G2(:,:,:,77),Q(:,46),MB,G3(:,:,:,51))
  call loop_QV_A(G3(:,:,:,51),wf(:,-4),G3(:,:,:,52))
  call loop_Q_A(G3(:,:,:,52),Q(:,62),MB,G4(:,:,:,21))
  call loop_QS_A(G4(:,:,:,21),wf(:,0),G4(:,:,:,22),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,22),Q(:,63),MB,G5tensor(:,11))
  call loop_QV_A(G2(:,:,:,75),wf(:,-4),G2(:,:,:,78))
  call loop_Q_A(G2(:,:,:,78),Q(:,30),MB,G3(:,:,:,53))
  call loop_QV_A(G3(:,:,:,53),wf(:,-5),G3(:,:,:,54))
  call loop_Q_A(G3(:,:,:,54),Q(:,62),MB,G4(:,:,:,23))
  call loop_QS_A(G4(:,:,:,23),wf(:,0),G4(:,:,:,24),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,24),Q(:,63),MB,G5tensor(:,12))
  call loop_QV_A(G0(:,:,:,1),wf(:,268),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,30),MT,G1(:,:,:,37))
  call loop_QV_A(G1(:,:,:,37),wf(:,-5),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,62),MT,G2(:,:,:,79))
  call loop_QS_A(G2(:,:,:,79),wf(:,0),G2(:,:,:,80),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,80),Q(:,63),MT,G3tensor(:,19))
  call loop_QV_A(G0(:,:,:,1),wf(:,269),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,30),MT,G1(:,:,:,39))
  call loop_QV_A(G1(:,:,:,39),wf(:,-5),G1(:,:,:,40))
  call loop_Q_A(G1(:,:,:,40),Q(:,62),MT,G2(:,:,:,81))
  call loop_QS_A(G2(:,:,:,81),wf(:,0),G2(:,:,:,82),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,82),Q(:,63),MT,G3tensor(:,20))
  call loop_QV_A(G0(:,:,:,1),wf(:,270),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,30),MT,G1(:,:,:,41))
  call loop_QV_A(G1(:,:,:,41),wf(:,-5),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,62),MT,G2(:,:,:,83))
  call loop_QS_A(G2(:,:,:,83),wf(:,0),G2(:,:,:,84),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,84),Q(:,63),MT,G3tensor(:,21))
  call loop_AV_Q(G0(:,:,:,1),wf(:,268),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,30),MT,G1(:,:,:,43))
  call loop_AV_Q(G1(:,:,:,43),wf(:,-5),G1(:,:,:,44))
  call loop_A_Q(G1(:,:,:,44),Q(:,62),MT,G2(:,:,:,85))
  call loop_AS_Q(G2(:,:,:,85),wf(:,0),G2(:,:,:,86),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,86),Q(:,63),MT,G3tensor(:,22))
  call loop_AV_Q(G0(:,:,:,1),wf(:,269),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,30),MT,G1(:,:,:,45))
  call loop_AV_Q(G1(:,:,:,45),wf(:,-5),G1(:,:,:,46))
  call loop_A_Q(G1(:,:,:,46),Q(:,62),MT,G2(:,:,:,87))
  call loop_AS_Q(G2(:,:,:,87),wf(:,0),G2(:,:,:,88),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,88),Q(:,63),MT,G3tensor(:,23))
  call loop_AV_Q(G0(:,:,:,1),wf(:,270),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,30),MT,G1(:,:,:,47))
  call loop_AV_Q(G1(:,:,:,47),wf(:,-5),G1(:,:,:,48))
  call loop_A_Q(G1(:,:,:,48),Q(:,62),MT,G2(:,:,:,89))
  call loop_AS_Q(G2(:,:,:,89),wf(:,0),G2(:,:,:,90),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,90),Q(:,63),MT,G3tensor(:,24))
  call loop_QV_A(G0(:,:,:,1),wf(:,268),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,30),MB,G1(:,:,:,49))
  call loop_QV_A(G1(:,:,:,49),wf(:,-5),G1(:,:,:,50))
  call loop_Q_A(G1(:,:,:,50),Q(:,62),MB,G2(:,:,:,91))
  call loop_QS_A(G2(:,:,:,91),wf(:,0),G2(:,:,:,92),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,92),Q(:,63),MB,G3tensor(:,25))
  call loop_QV_A(G0(:,:,:,1),wf(:,269),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,30),MB,G1(:,:,:,51))
  call loop_QV_A(G1(:,:,:,51),wf(:,-5),G1(:,:,:,52))
  call loop_Q_A(G1(:,:,:,52),Q(:,62),MB,G2(:,:,:,93))
  call loop_QS_A(G2(:,:,:,93),wf(:,0),G2(:,:,:,94),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,94),Q(:,63),MB,G3tensor(:,26))
  call loop_QV_A(G0(:,:,:,1),wf(:,270),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,30),MB,G1(:,:,:,53))
  call loop_QV_A(G1(:,:,:,53),wf(:,-5),G1(:,:,:,54))
  call loop_Q_A(G1(:,:,:,54),Q(:,62),MB,G2(:,:,:,95))
  call loop_QS_A(G2(:,:,:,95),wf(:,0),G2(:,:,:,96),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,96),Q(:,63),MB,G3tensor(:,27))
  call loop_AV_Q(G0(:,:,:,1),wf(:,268),G0(:,:,:,14))
  call loop_A_Q(G0(:,:,:,14),Q(:,30),MB,G1(:,:,:,55))
  call loop_AV_Q(G1(:,:,:,55),wf(:,-5),G1(:,:,:,56))
  call loop_A_Q(G1(:,:,:,56),Q(:,62),MB,G2(:,:,:,97))
  call loop_AS_Q(G2(:,:,:,97),wf(:,0),G2(:,:,:,98),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,98),Q(:,63),MB,G3tensor(:,28))
  call loop_AV_Q(G0(:,:,:,1),wf(:,269),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,30),MB,G1(:,:,:,57))
  call loop_AV_Q(G1(:,:,:,57),wf(:,-5),G1(:,:,:,58))
  call loop_A_Q(G1(:,:,:,58),Q(:,62),MB,G2(:,:,:,99))
  call loop_AS_Q(G2(:,:,:,99),wf(:,0),G2(:,:,:,100),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,100),Q(:,63),MB,G3tensor(:,29))
  call loop_AV_Q(G0(:,:,:,1),wf(:,270),G0(:,:,:,16))
  call loop_A_Q(G0(:,:,:,16),Q(:,30),MB,G1(:,:,:,59))
  call loop_AV_Q(G1(:,:,:,59),wf(:,-5),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,62),MB,G2(:,:,:,101))
  call loop_AS_Q(G2(:,:,:,101),wf(:,0),G2(:,:,:,102),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,102),Q(:,63),MB,G3tensor(:,30))
  call loop_AV_Q(G0(:,:,:,1),wf(:,29),G0(:,:,:,17))
  call loop_A_Q(G0(:,:,:,17),Q(:,18),MT,G1(:,:,:,61))
  call loop_AV_Q(G1(:,:,:,61),wf(:,30),G1(:,:,:,62))
  call loop_A_Q(G1(:,:,:,62),Q(:,62),MT,G2(:,:,:,103))
  call loop_AS_Q(G2(:,:,:,103),wf(:,0),G2(:,:,:,104),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,104),Q(:,63),MT,G3tensor(:,31))
  call loop_AV_Q(G1(:,:,:,61),wf(:,32),G1(:,:,:,63))
  call loop_A_Q(G1(:,:,:,63),Q(:,62),MT,G2(:,:,:,105))
  call loop_AS_Q(G2(:,:,:,105),wf(:,0),G2(:,:,:,106),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,106),Q(:,63),MT,G3tensor(:,32))
  call loop_AV_Q(G1(:,:,:,61),wf(:,33),G1(:,:,:,64))
  call loop_A_Q(G1(:,:,:,64),Q(:,62),MT,G2(:,:,:,107))
  call loop_AS_Q(G2(:,:,:,107),wf(:,0),G2(:,:,:,108),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,108),Q(:,63),MT,G3tensor(:,33))
  call loop_AV_Q(G1(:,:,:,61),wf(:,183),G1(:,:,:,65))
  call loop_A_Q(G1(:,:,:,65),Q(:,62),MT,G2(:,:,:,109))
  call loop_AS_Q(G2(:,:,:,109),wf(:,0),G2(:,:,:,110),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,110),Q(:,63),MT,G3tensor(:,34))
  call loop_AV_Q(G1(:,:,:,61),wf(:,65),G1(:,:,:,66))
  call loop_A_Q(G1(:,:,:,66),Q(:,30),MT,G2(:,:,:,111))
  call loop_AV_Q(G2(:,:,:,111),wf(:,-5),G2(:,:,:,112))
  call loop_A_Q(G2(:,:,:,112),Q(:,62),MT,G3(:,:,:,55))
  call loop_AS_Q(G3(:,:,:,55),wf(:,0),G3(:,:,:,56),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,56),Q(:,63),MT,G4tensor(:,16))
  call loop_AV_Q(G1(:,:,:,61),wf(:,191),G1(:,:,:,67))
  call loop_A_Q(G1(:,:,:,67),Q(:,62),MT,G2(:,:,:,113))
  call loop_AS_Q(G2(:,:,:,113),wf(:,0),G2(:,:,:,114),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,114),Q(:,63),MT,G3tensor(:,35))
  call loop_AV_Q(G1(:,:,:,61),wf(:,-3),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,26),MT,G2(:,:,:,115))
  call loop_AV_Q(G2(:,:,:,115),wf(:,84),G2(:,:,:,116))
  call loop_A_Q(G2(:,:,:,116),Q(:,62),MT,G3(:,:,:,57))
  call loop_AS_Q(G3(:,:,:,57),wf(:,0),G3(:,:,:,58),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,58),Q(:,63),MT,G4tensor(:,17))
  call loop_AV_Q(G2(:,:,:,115),wf(:,-2),G2(:,:,:,117))
  call loop_A_Q(G2(:,:,:,117),Q(:,30),MT,G3(:,:,:,59))
  call loop_AV_Q(G3(:,:,:,59),wf(:,-5),G3(:,:,:,60))
  call loop_A_Q(G3(:,:,:,60),Q(:,62),MT,G4(:,:,:,25))
  call loop_AS_Q(G4(:,:,:,25),wf(:,0),G4(:,:,:,26),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,26),Q(:,63),MT,G5tensor(:,13))
  call loop_AV_Q(G1(:,:,:,61),wf(:,193),G1(:,:,:,69))
  call loop_A_Q(G1(:,:,:,69),Q(:,62),MT,G2(:,:,:,118))
  call loop_AS_Q(G2(:,:,:,118),wf(:,0),G2(:,:,:,119),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,119),Q(:,63),MT,G3tensor(:,36))
  call loop_AV_Q(G1(:,:,:,61),wf(:,-2),G1(:,:,:,70))
  call loop_A_Q(G1(:,:,:,70),Q(:,22),MT,G2(:,:,:,120))
  call loop_AV_Q(G2(:,:,:,120),wf(:,109),G2(:,:,:,121))
  call loop_A_Q(G2(:,:,:,121),Q(:,62),MT,G3(:,:,:,61))
  call loop_AS_Q(G3(:,:,:,61),wf(:,0),G3(:,:,:,62),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,62),Q(:,63),MT,G4tensor(:,18))
  call loop_AV_Q(G2(:,:,:,120),wf(:,-3),G2(:,:,:,122))
  call loop_A_Q(G2(:,:,:,122),Q(:,30),MT,G3(:,:,:,63))
  call loop_AV_Q(G3(:,:,:,63),wf(:,-5),G3(:,:,:,64))
  call loop_A_Q(G3(:,:,:,64),Q(:,62),MT,G4(:,:,:,27))
  call loop_AS_Q(G4(:,:,:,27),wf(:,0),G4(:,:,:,28),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,28),Q(:,63),MT,G5tensor(:,14))
  call loop_QV_A(G0(:,:,:,1),wf(:,29),G0(:,:,:,18))
  call loop_Q_A(G0(:,:,:,18),Q(:,18),MT,G1(:,:,:,71))
  call loop_QV_A(G1(:,:,:,71),wf(:,30),G1(:,:,:,72))
  call loop_Q_A(G1(:,:,:,72),Q(:,62),MT,G2(:,:,:,123))
  call loop_QS_A(G2(:,:,:,123),wf(:,0),G2(:,:,:,124),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,124),Q(:,63),MT,G3tensor(:,37))
  call loop_QV_A(G1(:,:,:,71),wf(:,32),G1(:,:,:,73))
  call loop_Q_A(G1(:,:,:,73),Q(:,62),MT,G2(:,:,:,125))
  call loop_QS_A(G2(:,:,:,125),wf(:,0),G2(:,:,:,126),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,126),Q(:,63),MT,G3tensor(:,38))
  call loop_QV_A(G1(:,:,:,71),wf(:,33),G1(:,:,:,74))
  call loop_Q_A(G1(:,:,:,74),Q(:,62),MT,G2(:,:,:,127))
  call loop_QS_A(G2(:,:,:,127),wf(:,0),G2(:,:,:,128),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,128),Q(:,63),MT,G3tensor(:,39))
  call loop_QV_A(G1(:,:,:,71),wf(:,183),G1(:,:,:,75))
  call loop_Q_A(G1(:,:,:,75),Q(:,62),MT,G2(:,:,:,129))
  call loop_QS_A(G2(:,:,:,129),wf(:,0),G2(:,:,:,130),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,130),Q(:,63),MT,G3tensor(:,40))
  call loop_QV_A(G1(:,:,:,71),wf(:,65),G1(:,:,:,76))
  call loop_Q_A(G1(:,:,:,76),Q(:,30),MT,G2(:,:,:,131))
  call loop_QV_A(G2(:,:,:,131),wf(:,-5),G2(:,:,:,132))
  call loop_Q_A(G2(:,:,:,132),Q(:,62),MT,G3(:,:,:,65))
  call loop_QS_A(G3(:,:,:,65),wf(:,0),G3(:,:,:,66),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,66),Q(:,63),MT,G4tensor(:,19))
  call loop_QV_A(G1(:,:,:,71),wf(:,191),G1(:,:,:,77))
  call loop_Q_A(G1(:,:,:,77),Q(:,62),MT,G2(:,:,:,133))
  call loop_QS_A(G2(:,:,:,133),wf(:,0),G2(:,:,:,134),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,134),Q(:,63),MT,G3tensor(:,41))
  call loop_QV_A(G1(:,:,:,71),wf(:,-3),G1(:,:,:,78))
  call loop_Q_A(G1(:,:,:,78),Q(:,26),MT,G2(:,:,:,135))
  call loop_QV_A(G2(:,:,:,135),wf(:,84),G2(:,:,:,136))
  call loop_Q_A(G2(:,:,:,136),Q(:,62),MT,G3(:,:,:,67))
  call loop_QS_A(G3(:,:,:,67),wf(:,0),G3(:,:,:,68),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,68),Q(:,63),MT,G4tensor(:,20))
  call loop_QV_A(G2(:,:,:,135),wf(:,-2),G2(:,:,:,137))
  call loop_Q_A(G2(:,:,:,137),Q(:,30),MT,G3(:,:,:,69))
  call loop_QV_A(G3(:,:,:,69),wf(:,-5),G3(:,:,:,70))
  call loop_Q_A(G3(:,:,:,70),Q(:,62),MT,G4(:,:,:,29))
  call loop_QS_A(G4(:,:,:,29),wf(:,0),G4(:,:,:,30),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,30),Q(:,63),MT,G5tensor(:,15))
  call loop_QV_A(G1(:,:,:,71),wf(:,193),G1(:,:,:,79))
  call loop_Q_A(G1(:,:,:,79),Q(:,62),MT,G2(:,:,:,138))
  call loop_QS_A(G2(:,:,:,138),wf(:,0),G2(:,:,:,139),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,139),Q(:,63),MT,G3tensor(:,42))
  call loop_QV_A(G1(:,:,:,71),wf(:,-2),G1(:,:,:,80))
  call loop_Q_A(G1(:,:,:,80),Q(:,22),MT,G2(:,:,:,140))
  call loop_QV_A(G2(:,:,:,140),wf(:,109),G2(:,:,:,141))
  call loop_Q_A(G2(:,:,:,141),Q(:,62),MT,G3(:,:,:,71))
  call loop_QS_A(G3(:,:,:,71),wf(:,0),G3(:,:,:,72),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,72),Q(:,63),MT,G4tensor(:,21))
  call loop_QV_A(G2(:,:,:,140),wf(:,-3),G2(:,:,:,142))
  call loop_Q_A(G2(:,:,:,142),Q(:,30),MT,G3(:,:,:,73))
  call loop_QV_A(G3(:,:,:,73),wf(:,-5),G3(:,:,:,74))
  call loop_Q_A(G3(:,:,:,74),Q(:,62),MT,G4(:,:,:,31))
  call loop_QS_A(G4(:,:,:,31),wf(:,0),G4(:,:,:,32),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,32),Q(:,63),MT,G5tensor(:,16))
  call loop_AV_Q(G0(:,:,:,1),wf(:,29),G0(:,:,:,19))
  call loop_A_Q(G0(:,:,:,19),Q(:,18),MB,G1(:,:,:,81))
  call loop_AV_Q(G1(:,:,:,81),wf(:,30),G1(:,:,:,82))
  call loop_A_Q(G1(:,:,:,82),Q(:,62),MB,G2(:,:,:,143))
  call loop_AS_Q(G2(:,:,:,143),wf(:,0),G2(:,:,:,144),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,144),Q(:,63),MB,G3tensor(:,43))
  call loop_AV_Q(G1(:,:,:,81),wf(:,32),G1(:,:,:,83))
  call loop_A_Q(G1(:,:,:,83),Q(:,62),MB,G2(:,:,:,145))
  call loop_AS_Q(G2(:,:,:,145),wf(:,0),G2(:,:,:,146),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,146),Q(:,63),MB,G3tensor(:,44))
  call loop_AV_Q(G1(:,:,:,81),wf(:,33),G1(:,:,:,84))
  call loop_A_Q(G1(:,:,:,84),Q(:,62),MB,G2(:,:,:,147))
  call loop_AS_Q(G2(:,:,:,147),wf(:,0),G2(:,:,:,148),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,148),Q(:,63),MB,G3tensor(:,45))
  call loop_AV_Q(G1(:,:,:,81),wf(:,183),G1(:,:,:,85))
  call loop_A_Q(G1(:,:,:,85),Q(:,62),MB,G2(:,:,:,149))
  call loop_AS_Q(G2(:,:,:,149),wf(:,0),G2(:,:,:,150),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,150),Q(:,63),MB,G3tensor(:,46))
  call loop_AV_Q(G1(:,:,:,81),wf(:,65),G1(:,:,:,86))
  call loop_A_Q(G1(:,:,:,86),Q(:,30),MB,G2(:,:,:,151))
  call loop_AV_Q(G2(:,:,:,151),wf(:,-5),G2(:,:,:,152))
  call loop_A_Q(G2(:,:,:,152),Q(:,62),MB,G3(:,:,:,75))
  call loop_AS_Q(G3(:,:,:,75),wf(:,0),G3(:,:,:,76),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,76),Q(:,63),MB,G4tensor(:,22))
  call loop_AV_Q(G1(:,:,:,81),wf(:,191),G1(:,:,:,87))
  call loop_A_Q(G1(:,:,:,87),Q(:,62),MB,G2(:,:,:,153))
  call loop_AS_Q(G2(:,:,:,153),wf(:,0),G2(:,:,:,154),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,154),Q(:,63),MB,G3tensor(:,47))
  call loop_AV_Q(G1(:,:,:,81),wf(:,-3),G1(:,:,:,88))
  call loop_A_Q(G1(:,:,:,88),Q(:,26),MB,G2(:,:,:,155))
  call loop_AV_Q(G2(:,:,:,155),wf(:,84),G2(:,:,:,156))
  call loop_A_Q(G2(:,:,:,156),Q(:,62),MB,G3(:,:,:,77))
  call loop_AS_Q(G3(:,:,:,77),wf(:,0),G3(:,:,:,78),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,78),Q(:,63),MB,G4tensor(:,23))
  call loop_AV_Q(G2(:,:,:,155),wf(:,-2),G2(:,:,:,157))
  call loop_A_Q(G2(:,:,:,157),Q(:,30),MB,G3(:,:,:,79))
  call loop_AV_Q(G3(:,:,:,79),wf(:,-5),G3(:,:,:,80))
  call loop_A_Q(G3(:,:,:,80),Q(:,62),MB,G4(:,:,:,33))
  call loop_AS_Q(G4(:,:,:,33),wf(:,0),G4(:,:,:,34),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,34),Q(:,63),MB,G5tensor(:,17))
  call loop_AV_Q(G1(:,:,:,81),wf(:,193),G1(:,:,:,89))
  call loop_A_Q(G1(:,:,:,89),Q(:,62),MB,G2(:,:,:,158))
  call loop_AS_Q(G2(:,:,:,158),wf(:,0),G2(:,:,:,159),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,159),Q(:,63),MB,G3tensor(:,48))
  call loop_AV_Q(G1(:,:,:,81),wf(:,-2),G1(:,:,:,90))
  call loop_A_Q(G1(:,:,:,90),Q(:,22),MB,G2(:,:,:,160))
  call loop_AV_Q(G2(:,:,:,160),wf(:,109),G2(:,:,:,161))
  call loop_A_Q(G2(:,:,:,161),Q(:,62),MB,G3(:,:,:,81))
  call loop_AS_Q(G3(:,:,:,81),wf(:,0),G3(:,:,:,82),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,82),Q(:,63),MB,G4tensor(:,24))
  call loop_AV_Q(G2(:,:,:,160),wf(:,-3),G2(:,:,:,162))
  call loop_A_Q(G2(:,:,:,162),Q(:,30),MB,G3(:,:,:,83))
  call loop_AV_Q(G3(:,:,:,83),wf(:,-5),G3(:,:,:,84))
  call loop_A_Q(G3(:,:,:,84),Q(:,62),MB,G4(:,:,:,35))
  call loop_AS_Q(G4(:,:,:,35),wf(:,0),G4(:,:,:,36),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,36),Q(:,63),MB,G5tensor(:,18))
  call loop_QV_A(G0(:,:,:,1),wf(:,29),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,18),MB,G1(:,:,:,91))
  call loop_QV_A(G1(:,:,:,91),wf(:,30),G1(:,:,:,92))
  call loop_Q_A(G1(:,:,:,92),Q(:,62),MB,G2(:,:,:,163))
  call loop_QS_A(G2(:,:,:,163),wf(:,0),G2(:,:,:,164),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,164),Q(:,63),MB,G3tensor(:,49))
  call loop_QV_A(G1(:,:,:,91),wf(:,32),G1(:,:,:,93))
  call loop_Q_A(G1(:,:,:,93),Q(:,62),MB,G2(:,:,:,165))
  call loop_QS_A(G2(:,:,:,165),wf(:,0),G2(:,:,:,166),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,166),Q(:,63),MB,G3tensor(:,50))
  call loop_QV_A(G1(:,:,:,91),wf(:,33),G1(:,:,:,94))
  call loop_Q_A(G1(:,:,:,94),Q(:,62),MB,G2(:,:,:,167))
  call loop_QS_A(G2(:,:,:,167),wf(:,0),G2(:,:,:,168),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,168),Q(:,63),MB,G3tensor(:,51))
  call loop_QV_A(G1(:,:,:,91),wf(:,183),G1(:,:,:,95))
  call loop_Q_A(G1(:,:,:,95),Q(:,62),MB,G2(:,:,:,169))
  call loop_QS_A(G2(:,:,:,169),wf(:,0),G2(:,:,:,170),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,170),Q(:,63),MB,G3tensor(:,52))
  call loop_QV_A(G1(:,:,:,91),wf(:,65),G1(:,:,:,96))
  call loop_Q_A(G1(:,:,:,96),Q(:,30),MB,G2(:,:,:,171))
  call loop_QV_A(G2(:,:,:,171),wf(:,-5),G2(:,:,:,172))
  call loop_Q_A(G2(:,:,:,172),Q(:,62),MB,G3(:,:,:,85))
  call loop_QS_A(G3(:,:,:,85),wf(:,0),G3(:,:,:,86),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,86),Q(:,63),MB,G4tensor(:,25))
  call loop_QV_A(G1(:,:,:,91),wf(:,191),G1(:,:,:,97))
  call loop_Q_A(G1(:,:,:,97),Q(:,62),MB,G2(:,:,:,173))
  call loop_QS_A(G2(:,:,:,173),wf(:,0),G2(:,:,:,174),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,174),Q(:,63),MB,G3tensor(:,53))
  call loop_QV_A(G1(:,:,:,91),wf(:,-3),G1(:,:,:,98))
  call loop_Q_A(G1(:,:,:,98),Q(:,26),MB,G2(:,:,:,175))
  call loop_QV_A(G2(:,:,:,175),wf(:,84),G2(:,:,:,176))
  call loop_Q_A(G2(:,:,:,176),Q(:,62),MB,G3(:,:,:,87))
  call loop_QS_A(G3(:,:,:,87),wf(:,0),G3(:,:,:,88),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,88),Q(:,63),MB,G4tensor(:,26))
  call loop_QV_A(G2(:,:,:,175),wf(:,-2),G2(:,:,:,177))
  call loop_Q_A(G2(:,:,:,177),Q(:,30),MB,G3(:,:,:,89))
  call loop_QV_A(G3(:,:,:,89),wf(:,-5),G3(:,:,:,90))
  call loop_Q_A(G3(:,:,:,90),Q(:,62),MB,G4(:,:,:,37))
  call loop_QS_A(G4(:,:,:,37),wf(:,0),G4(:,:,:,38),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,38),Q(:,63),MB,G5tensor(:,19))
  call loop_QV_A(G1(:,:,:,91),wf(:,193),G1(:,:,:,99))
  call loop_Q_A(G1(:,:,:,99),Q(:,62),MB,G2(:,:,:,178))
  call loop_QS_A(G2(:,:,:,178),wf(:,0),G2(:,:,:,179),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,179),Q(:,63),MB,G3tensor(:,54))
  call loop_QV_A(G1(:,:,:,91),wf(:,-2),G1(:,:,:,100))
  call loop_Q_A(G1(:,:,:,100),Q(:,22),MB,G2(:,:,:,180))
  call loop_QV_A(G2(:,:,:,180),wf(:,109),G2(:,:,:,181))
  call loop_Q_A(G2(:,:,:,181),Q(:,62),MB,G3(:,:,:,91))
  call loop_QS_A(G3(:,:,:,91),wf(:,0),G3(:,:,:,92),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,92),Q(:,63),MB,G4tensor(:,27))
  call loop_QV_A(G2(:,:,:,180),wf(:,-3),G2(:,:,:,182))
  call loop_Q_A(G2(:,:,:,182),Q(:,30),MB,G3(:,:,:,93))
  call loop_QV_A(G3(:,:,:,93),wf(:,-5),G3(:,:,:,94))
  call loop_Q_A(G3(:,:,:,94),Q(:,62),MB,G4(:,:,:,39))
  call loop_QS_A(G4(:,:,:,39),wf(:,0),G4(:,:,:,40),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,40),Q(:,63),MB,G5tensor(:,20))
  call loop_QV_A(G0(:,:,:,1),wf(:,38),G0(:,:,:,21))
  call loop_Q_A(G0(:,:,:,21),Q(:,28),MT,G1(:,:,:,101))
  call loop_QV_A(G1(:,:,:,101),wf(:,37),G1(:,:,:,102))
  call loop_Q_A(G1(:,:,:,102),Q(:,62),MT,G2(:,:,:,183))
  call loop_QS_A(G2(:,:,:,183),wf(:,0),G2(:,:,:,184),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,184),Q(:,63),MT,G3tensor(:,55))
  call loop_QV_A(G1(:,:,:,101),wf(:,-1),G1(:,:,:,103))
  call loop_Q_A(G1(:,:,:,103),Q(:,30),MT,G2(:,:,:,185))
  call loop_QV_A(G2(:,:,:,185),wf(:,-5),G2(:,:,:,186))
  call loop_Q_A(G2(:,:,:,186),Q(:,62),MT,G3(:,:,:,95))
  call loop_QS_A(G3(:,:,:,95),wf(:,0),G3(:,:,:,96),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,96),Q(:,63),MT,G4tensor(:,28))
  call loop_QV_A(G0(:,:,:,1),wf(:,40),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,28),MT,G1(:,:,:,104))
  call loop_QV_A(G1(:,:,:,104),wf(:,37),G1(:,:,:,105))
  call loop_Q_A(G1(:,:,:,105),Q(:,62),MT,G2(:,:,:,187))
  call loop_QS_A(G2(:,:,:,187),wf(:,0),G2(:,:,:,188),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,188),Q(:,63),MT,G3tensor(:,56))
  call loop_QV_A(G1(:,:,:,104),wf(:,-1),G1(:,:,:,106))
  call loop_Q_A(G1(:,:,:,106),Q(:,30),MT,G2(:,:,:,189))
  call loop_QV_A(G2(:,:,:,189),wf(:,-5),G2(:,:,:,190))
  call loop_Q_A(G2(:,:,:,190),Q(:,62),MT,G3(:,:,:,97))
  call loop_QS_A(G3(:,:,:,97),wf(:,0),G3(:,:,:,98),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,98),Q(:,63),MT,G4tensor(:,29))
  call loop_QV_A(G0(:,:,:,1),wf(:,41),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,28),MT,G1(:,:,:,107))
  call loop_QV_A(G1(:,:,:,107),wf(:,37),G1(:,:,:,108))
  call loop_Q_A(G1(:,:,:,108),Q(:,62),MT,G2(:,:,:,191))
  call loop_QS_A(G2(:,:,:,191),wf(:,0),G2(:,:,:,192),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,192),Q(:,63),MT,G3tensor(:,57))
  call loop_QV_A(G1(:,:,:,107),wf(:,-1),G1(:,:,:,109))
  call loop_Q_A(G1(:,:,:,109),Q(:,30),MT,G2(:,:,:,193))
  call loop_QV_A(G2(:,:,:,193),wf(:,-5),G2(:,:,:,194))
  call loop_Q_A(G2(:,:,:,194),Q(:,62),MT,G3(:,:,:,99))
  call loop_QS_A(G3(:,:,:,99),wf(:,0),G3(:,:,:,100),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,100),Q(:,63),MT,G4tensor(:,30))
  call loop_AV_Q(G0(:,:,:,1),wf(:,38),G0(:,:,:,24))
  call loop_A_Q(G0(:,:,:,24),Q(:,28),MT,G1(:,:,:,110))
  call loop_AV_Q(G1(:,:,:,110),wf(:,37),G1(:,:,:,111))
  call loop_A_Q(G1(:,:,:,111),Q(:,62),MT,G2(:,:,:,195))
  call loop_AS_Q(G2(:,:,:,195),wf(:,0),G2(:,:,:,196),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,196),Q(:,63),MT,G3tensor(:,58))
  call loop_AV_Q(G1(:,:,:,110),wf(:,-1),G1(:,:,:,112))
  call loop_A_Q(G1(:,:,:,112),Q(:,30),MT,G2(:,:,:,197))
  call loop_AV_Q(G2(:,:,:,197),wf(:,-5),G2(:,:,:,198))
  call loop_A_Q(G2(:,:,:,198),Q(:,62),MT,G3(:,:,:,101))
  call loop_AS_Q(G3(:,:,:,101),wf(:,0),G3(:,:,:,102),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,102),Q(:,63),MT,G4tensor(:,31))
  call loop_AV_Q(G0(:,:,:,1),wf(:,40),G0(:,:,:,25))
  call loop_A_Q(G0(:,:,:,25),Q(:,28),MT,G1(:,:,:,113))
  call loop_AV_Q(G1(:,:,:,113),wf(:,37),G1(:,:,:,114))
  call loop_A_Q(G1(:,:,:,114),Q(:,62),MT,G2(:,:,:,199))
  call loop_AS_Q(G2(:,:,:,199),wf(:,0),G2(:,:,:,200),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,200),Q(:,63),MT,G3tensor(:,59))
  call loop_AV_Q(G1(:,:,:,113),wf(:,-1),G1(:,:,:,115))
  call loop_A_Q(G1(:,:,:,115),Q(:,30),MT,G2(:,:,:,201))
  call loop_AV_Q(G2(:,:,:,201),wf(:,-5),G2(:,:,:,202))
  call loop_A_Q(G2(:,:,:,202),Q(:,62),MT,G3(:,:,:,103))
  call loop_AS_Q(G3(:,:,:,103),wf(:,0),G3(:,:,:,104),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,104),Q(:,63),MT,G4tensor(:,32))
  call loop_AV_Q(G0(:,:,:,1),wf(:,41),G0(:,:,:,26))
  call loop_A_Q(G0(:,:,:,26),Q(:,28),MT,G1(:,:,:,116))
  call loop_AV_Q(G1(:,:,:,116),wf(:,37),G1(:,:,:,117))
  call loop_A_Q(G1(:,:,:,117),Q(:,62),MT,G2(:,:,:,203))
  call loop_AS_Q(G2(:,:,:,203),wf(:,0),G2(:,:,:,204),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,204),Q(:,63),MT,G3tensor(:,60))
  call loop_AV_Q(G1(:,:,:,116),wf(:,-1),G1(:,:,:,118))
  call loop_A_Q(G1(:,:,:,118),Q(:,30),MT,G2(:,:,:,205))
  call loop_AV_Q(G2(:,:,:,205),wf(:,-5),G2(:,:,:,206))
  call loop_A_Q(G2(:,:,:,206),Q(:,62),MT,G3(:,:,:,105))
  call loop_AS_Q(G3(:,:,:,105),wf(:,0),G3(:,:,:,106),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,106),Q(:,63),MT,G4tensor(:,33))
  call loop_QV_A(G0(:,:,:,1),wf(:,38),G0(:,:,:,27))
  call loop_Q_A(G0(:,:,:,27),Q(:,28),MB,G1(:,:,:,119))
  call loop_QV_A(G1(:,:,:,119),wf(:,37),G1(:,:,:,120))
  call loop_Q_A(G1(:,:,:,120),Q(:,62),MB,G2(:,:,:,207))
  call loop_QS_A(G2(:,:,:,207),wf(:,0),G2(:,:,:,208),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,208),Q(:,63),MB,G3tensor(:,61))
  call loop_QV_A(G1(:,:,:,119),wf(:,-1),G1(:,:,:,121))
  call loop_Q_A(G1(:,:,:,121),Q(:,30),MB,G2(:,:,:,209))
  call loop_QV_A(G2(:,:,:,209),wf(:,-5),G2(:,:,:,210))
  call loop_Q_A(G2(:,:,:,210),Q(:,62),MB,G3(:,:,:,107))
  call loop_QS_A(G3(:,:,:,107),wf(:,0),G3(:,:,:,108),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,108),Q(:,63),MB,G4tensor(:,34))
  call loop_QV_A(G0(:,:,:,1),wf(:,40),G0(:,:,:,28))
  call loop_Q_A(G0(:,:,:,28),Q(:,28),MB,G1(:,:,:,122))
  call loop_QV_A(G1(:,:,:,122),wf(:,37),G1(:,:,:,123))
  call loop_Q_A(G1(:,:,:,123),Q(:,62),MB,G2(:,:,:,211))
  call loop_QS_A(G2(:,:,:,211),wf(:,0),G2(:,:,:,212),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,212),Q(:,63),MB,G3tensor(:,62))
  call loop_QV_A(G1(:,:,:,122),wf(:,-1),G1(:,:,:,124))
  call loop_Q_A(G1(:,:,:,124),Q(:,30),MB,G2(:,:,:,213))
  call loop_QV_A(G2(:,:,:,213),wf(:,-5),G2(:,:,:,214))
  call loop_Q_A(G2(:,:,:,214),Q(:,62),MB,G3(:,:,:,109))
  call loop_QS_A(G3(:,:,:,109),wf(:,0),G3(:,:,:,110),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,110),Q(:,63),MB,G4tensor(:,35))
  call loop_QV_A(G0(:,:,:,1),wf(:,41),G0(:,:,:,29))
  call loop_Q_A(G0(:,:,:,29),Q(:,28),MB,G1(:,:,:,125))
  call loop_QV_A(G1(:,:,:,125),wf(:,37),G1(:,:,:,126))
  call loop_Q_A(G1(:,:,:,126),Q(:,62),MB,G2(:,:,:,215))
  call loop_QS_A(G2(:,:,:,215),wf(:,0),G2(:,:,:,216),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,216),Q(:,63),MB,G3tensor(:,63))
  call loop_QV_A(G1(:,:,:,125),wf(:,-1),G1(:,:,:,127))
  call loop_Q_A(G1(:,:,:,127),Q(:,30),MB,G2(:,:,:,217))
  call loop_QV_A(G2(:,:,:,217),wf(:,-5),G2(:,:,:,218))
  call loop_Q_A(G2(:,:,:,218),Q(:,62),MB,G3(:,:,:,111))
  call loop_QS_A(G3(:,:,:,111),wf(:,0),G3(:,:,:,112),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,112),Q(:,63),MB,G4tensor(:,36))
  call loop_AV_Q(G0(:,:,:,1),wf(:,38),G0(:,:,:,30))
  call loop_A_Q(G0(:,:,:,30),Q(:,28),MB,G1(:,:,:,128))
  call loop_AV_Q(G1(:,:,:,128),wf(:,37),G1(:,:,:,129))
  call loop_A_Q(G1(:,:,:,129),Q(:,62),MB,G2(:,:,:,219))
  call loop_AS_Q(G2(:,:,:,219),wf(:,0),G2(:,:,:,220),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,220),Q(:,63),MB,G3tensor(:,64))
  call loop_AV_Q(G1(:,:,:,128),wf(:,-1),G1(:,:,:,130))
  call loop_A_Q(G1(:,:,:,130),Q(:,30),MB,G2(:,:,:,221))
  call loop_AV_Q(G2(:,:,:,221),wf(:,-5),G2(:,:,:,222))
  call loop_A_Q(G2(:,:,:,222),Q(:,62),MB,G3(:,:,:,113))
  call loop_AS_Q(G3(:,:,:,113),wf(:,0),G3(:,:,:,114),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,114),Q(:,63),MB,G4tensor(:,37))
  call loop_AV_Q(G0(:,:,:,1),wf(:,40),G0(:,:,:,31))
  call loop_A_Q(G0(:,:,:,31),Q(:,28),MB,G1(:,:,:,131))
  call loop_AV_Q(G1(:,:,:,131),wf(:,37),G1(:,:,:,132))
  call loop_A_Q(G1(:,:,:,132),Q(:,62),MB,G2(:,:,:,223))
  call loop_AS_Q(G2(:,:,:,223),wf(:,0),G2(:,:,:,224),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,224),Q(:,63),MB,G3tensor(:,65))
  call loop_AV_Q(G1(:,:,:,131),wf(:,-1),G1(:,:,:,133))
  call loop_A_Q(G1(:,:,:,133),Q(:,30),MB,G2(:,:,:,225))
  call loop_AV_Q(G2(:,:,:,225),wf(:,-5),G2(:,:,:,226))
  call loop_A_Q(G2(:,:,:,226),Q(:,62),MB,G3(:,:,:,115))
  call loop_AS_Q(G3(:,:,:,115),wf(:,0),G3(:,:,:,116),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,116),Q(:,63),MB,G4tensor(:,38))
  call loop_AV_Q(G0(:,:,:,1),wf(:,41),G0(:,:,:,32))
  call loop_A_Q(G0(:,:,:,32),Q(:,28),MB,G1(:,:,:,134))
  call loop_AV_Q(G1(:,:,:,134),wf(:,37),G1(:,:,:,135))
  call loop_A_Q(G1(:,:,:,135),Q(:,62),MB,G2(:,:,:,227))
  call loop_AS_Q(G2(:,:,:,227),wf(:,0),G2(:,:,:,228),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,228),Q(:,63),MB,G3tensor(:,66))
  call loop_AV_Q(G1(:,:,:,134),wf(:,-1),G1(:,:,:,136))
  call loop_A_Q(G1(:,:,:,136),Q(:,30),MB,G2(:,:,:,229))
  call loop_AV_Q(G2(:,:,:,229),wf(:,-5),G2(:,:,:,230))
  call loop_A_Q(G2(:,:,:,230),Q(:,62),MB,G3(:,:,:,117))
  call loop_AS_Q(G3(:,:,:,117),wf(:,0),G3(:,:,:,118),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,118),Q(:,63),MB,G4tensor(:,39))
  call loop_QV_A(G0(:,:,:,1),wf(:,283),G0(:,:,:,33))
  call loop_Q_A(G0(:,:,:,33),Q(:,30),MT,G1(:,:,:,137))
  call loop_QV_A(G1(:,:,:,137),wf(:,-5),G1(:,:,:,138))
  call loop_Q_A(G1(:,:,:,138),Q(:,62),MT,G2(:,:,:,231))
  call loop_QS_A(G2(:,:,:,231),wf(:,0),G2(:,:,:,232),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,232),Q(:,63),MT,G3tensor(:,67))
  call loop_QV_A(G0(:,:,:,1),wf(:,284),G0(:,:,:,34))
  call loop_Q_A(G0(:,:,:,34),Q(:,30),MT,G1(:,:,:,139))
  call loop_QV_A(G1(:,:,:,139),wf(:,-5),G1(:,:,:,140))
  call loop_Q_A(G1(:,:,:,140),Q(:,62),MT,G2(:,:,:,233))
  call loop_QS_A(G2(:,:,:,233),wf(:,0),G2(:,:,:,234),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,234),Q(:,63),MT,G3tensor(:,68))
  call loop_QV_A(G0(:,:,:,1),wf(:,285),G0(:,:,:,35))
  call loop_Q_A(G0(:,:,:,35),Q(:,30),MT,G1(:,:,:,141))
  call loop_QV_A(G1(:,:,:,141),wf(:,-5),G1(:,:,:,142))
  call loop_Q_A(G1(:,:,:,142),Q(:,62),MT,G2(:,:,:,235))
  call loop_QS_A(G2(:,:,:,235),wf(:,0),G2(:,:,:,236),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,236),Q(:,63),MT,G3tensor(:,69))
  call loop_AV_Q(G0(:,:,:,1),wf(:,283),G0(:,:,:,36))
  call loop_A_Q(G0(:,:,:,36),Q(:,30),MT,G1(:,:,:,143))
  call loop_AV_Q(G1(:,:,:,143),wf(:,-5),G1(:,:,:,144))
  call loop_A_Q(G1(:,:,:,144),Q(:,62),MT,G2(:,:,:,237))
  call loop_AS_Q(G2(:,:,:,237),wf(:,0),G2(:,:,:,238),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,238),Q(:,63),MT,G3tensor(:,70))
  call loop_AV_Q(G0(:,:,:,1),wf(:,284),G0(:,:,:,37))
  call loop_A_Q(G0(:,:,:,37),Q(:,30),MT,G1(:,:,:,145))
  call loop_AV_Q(G1(:,:,:,145),wf(:,-5),G1(:,:,:,146))
  call loop_A_Q(G1(:,:,:,146),Q(:,62),MT,G2(:,:,:,239))
  call loop_AS_Q(G2(:,:,:,239),wf(:,0),G2(:,:,:,240),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,240),Q(:,63),MT,G3tensor(:,71))
  call loop_AV_Q(G0(:,:,:,1),wf(:,285),G0(:,:,:,38))
  call loop_A_Q(G0(:,:,:,38),Q(:,30),MT,G1(:,:,:,147))
  call loop_AV_Q(G1(:,:,:,147),wf(:,-5),G1(:,:,:,148))
  call loop_A_Q(G1(:,:,:,148),Q(:,62),MT,G2(:,:,:,241))
  call loop_AS_Q(G2(:,:,:,241),wf(:,0),G2(:,:,:,242),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,242),Q(:,63),MT,G3tensor(:,72))
  call loop_QV_A(G0(:,:,:,1),wf(:,283),G0(:,:,:,39))
  call loop_Q_A(G0(:,:,:,39),Q(:,30),MB,G1(:,:,:,149))
  call loop_QV_A(G1(:,:,:,149),wf(:,-5),G1(:,:,:,150))
  call loop_Q_A(G1(:,:,:,150),Q(:,62),MB,G2(:,:,:,243))
  call loop_QS_A(G2(:,:,:,243),wf(:,0),G2(:,:,:,244),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,244),Q(:,63),MB,G3tensor(:,73))
  call loop_QV_A(G0(:,:,:,1),wf(:,284),G0(:,:,:,40))
  call loop_Q_A(G0(:,:,:,40),Q(:,30),MB,G1(:,:,:,151))
  call loop_QV_A(G1(:,:,:,151),wf(:,-5),G1(:,:,:,152))
  call loop_Q_A(G1(:,:,:,152),Q(:,62),MB,G2(:,:,:,245))
  call loop_QS_A(G2(:,:,:,245),wf(:,0),G2(:,:,:,246),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,246),Q(:,63),MB,G3tensor(:,74))
  call loop_QV_A(G0(:,:,:,1),wf(:,285),G0(:,:,:,41))
  call loop_Q_A(G0(:,:,:,41),Q(:,30),MB,G1(:,:,:,153))
  call loop_QV_A(G1(:,:,:,153),wf(:,-5),G1(:,:,:,154))
  call loop_Q_A(G1(:,:,:,154),Q(:,62),MB,G2(:,:,:,247))
  call loop_QS_A(G2(:,:,:,247),wf(:,0),G2(:,:,:,248),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,248),Q(:,63),MB,G3tensor(:,75))
  call loop_AV_Q(G0(:,:,:,1),wf(:,283),G0(:,:,:,42))
  call loop_A_Q(G0(:,:,:,42),Q(:,30),MB,G1(:,:,:,155))
  call loop_AV_Q(G1(:,:,:,155),wf(:,-5),G1(:,:,:,156))
  call loop_A_Q(G1(:,:,:,156),Q(:,62),MB,G2(:,:,:,249))
  call loop_AS_Q(G2(:,:,:,249),wf(:,0),G2(:,:,:,250),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,250),Q(:,63),MB,G3tensor(:,76))
  call loop_AV_Q(G0(:,:,:,1),wf(:,284),G0(:,:,:,43))
  call loop_A_Q(G0(:,:,:,43),Q(:,30),MB,G1(:,:,:,157))
  call loop_AV_Q(G1(:,:,:,157),wf(:,-5),G1(:,:,:,158))
  call loop_A_Q(G1(:,:,:,158),Q(:,62),MB,G2(:,:,:,251))
  call loop_AS_Q(G2(:,:,:,251),wf(:,0),G2(:,:,:,252),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,252),Q(:,63),MB,G3tensor(:,77))
  call loop_AV_Q(G0(:,:,:,1),wf(:,285),G0(:,:,:,44))
  call loop_A_Q(G0(:,:,:,44),Q(:,30),MB,G1(:,:,:,159))
  call loop_AV_Q(G1(:,:,:,159),wf(:,-5),G1(:,:,:,160))
  call loop_A_Q(G1(:,:,:,160),Q(:,62),MB,G2(:,:,:,253))
  call loop_AS_Q(G2(:,:,:,253),wf(:,0),G2(:,:,:,254),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,254),Q(:,63),MB,G3tensor(:,78))
  call loop_QV_A(G0(:,:,:,1),wf(:,292),G0(:,:,:,45))
  call loop_Q_A(G0(:,:,:,45),Q(:,30),MT,G1(:,:,:,161))
  call loop_QV_A(G1(:,:,:,161),wf(:,-5),G1(:,:,:,162))
  call loop_Q_A(G1(:,:,:,162),Q(:,62),MT,G2(:,:,:,255))
  call loop_QS_A(G2(:,:,:,255),wf(:,0),G2(:,:,:,256),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,256),Q(:,63),MT,G3tensor(:,79))
  call loop_QV_A(G0(:,:,:,1),wf(:,293),G0(:,:,:,46))
  call loop_Q_A(G0(:,:,:,46),Q(:,30),MT,G1(:,:,:,163))
  call loop_QV_A(G1(:,:,:,163),wf(:,-5),G1(:,:,:,164))
  call loop_Q_A(G1(:,:,:,164),Q(:,62),MT,G2(:,:,:,257))
  call loop_QS_A(G2(:,:,:,257),wf(:,0),G2(:,:,:,258),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,258),Q(:,63),MT,G3tensor(:,80))
  call loop_QV_A(G0(:,:,:,1),wf(:,294),G0(:,:,:,47))
  call loop_Q_A(G0(:,:,:,47),Q(:,30),MT,G1(:,:,:,165))
  call loop_QV_A(G1(:,:,:,165),wf(:,-5),G1(:,:,:,166))
  call loop_Q_A(G1(:,:,:,166),Q(:,62),MT,G2(:,:,:,259))
  call loop_QS_A(G2(:,:,:,259),wf(:,0),G2(:,:,:,260),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,260),Q(:,63),MT,G3tensor(:,81))
  call loop_AV_Q(G0(:,:,:,1),wf(:,292),G0(:,:,:,48))
  call loop_A_Q(G0(:,:,:,48),Q(:,30),MT,G1(:,:,:,167))
  call loop_AV_Q(G1(:,:,:,167),wf(:,-5),G1(:,:,:,168))
  call loop_A_Q(G1(:,:,:,168),Q(:,62),MT,G2(:,:,:,261))
  call loop_AS_Q(G2(:,:,:,261),wf(:,0),G2(:,:,:,262),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,262),Q(:,63),MT,G3tensor(:,82))
  call loop_AV_Q(G0(:,:,:,1),wf(:,293),G0(:,:,:,49))
  call loop_A_Q(G0(:,:,:,49),Q(:,30),MT,G1(:,:,:,169))
  call loop_AV_Q(G1(:,:,:,169),wf(:,-5),G1(:,:,:,170))
  call loop_A_Q(G1(:,:,:,170),Q(:,62),MT,G2(:,:,:,263))
  call loop_AS_Q(G2(:,:,:,263),wf(:,0),G2(:,:,:,264),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,264),Q(:,63),MT,G3tensor(:,83))
  call loop_AV_Q(G0(:,:,:,1),wf(:,294),G0(:,:,:,50))
  call loop_A_Q(G0(:,:,:,50),Q(:,30),MT,G1(:,:,:,171))
  call loop_AV_Q(G1(:,:,:,171),wf(:,-5),G1(:,:,:,172))
  call loop_A_Q(G1(:,:,:,172),Q(:,62),MT,G2(:,:,:,265))
  call loop_AS_Q(G2(:,:,:,265),wf(:,0),G2(:,:,:,266),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,266),Q(:,63),MT,G3tensor(:,84))
  call loop_QV_A(G0(:,:,:,1),wf(:,292),G0(:,:,:,51))
  call loop_Q_A(G0(:,:,:,51),Q(:,30),MB,G1(:,:,:,173))
  call loop_QV_A(G1(:,:,:,173),wf(:,-5),G1(:,:,:,174))
  call loop_Q_A(G1(:,:,:,174),Q(:,62),MB,G2(:,:,:,267))
  call loop_QS_A(G2(:,:,:,267),wf(:,0),G2(:,:,:,268),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,268),Q(:,63),MB,G3tensor(:,85))
  call loop_QV_A(G0(:,:,:,1),wf(:,293),G0(:,:,:,52))
  call loop_Q_A(G0(:,:,:,52),Q(:,30),MB,G1(:,:,:,175))
  call loop_QV_A(G1(:,:,:,175),wf(:,-5),G1(:,:,:,176))
  call loop_Q_A(G1(:,:,:,176),Q(:,62),MB,G2(:,:,:,269))
  call loop_QS_A(G2(:,:,:,269),wf(:,0),G2(:,:,:,270),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,270),Q(:,63),MB,G3tensor(:,86))
  call loop_QV_A(G0(:,:,:,1),wf(:,294),G0(:,:,:,53))
  call loop_Q_A(G0(:,:,:,53),Q(:,30),MB,G1(:,:,:,177))
  call loop_QV_A(G1(:,:,:,177),wf(:,-5),G1(:,:,:,178))
  call loop_Q_A(G1(:,:,:,178),Q(:,62),MB,G2(:,:,:,271))
  call loop_QS_A(G2(:,:,:,271),wf(:,0),G2(:,:,:,272),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,272),Q(:,63),MB,G3tensor(:,87))
  call loop_AV_Q(G0(:,:,:,1),wf(:,292),G0(:,:,:,54))
  call loop_A_Q(G0(:,:,:,54),Q(:,30),MB,G1(:,:,:,179))
  call loop_AV_Q(G1(:,:,:,179),wf(:,-5),G1(:,:,:,180))
  call loop_A_Q(G1(:,:,:,180),Q(:,62),MB,G2(:,:,:,273))
  call loop_AS_Q(G2(:,:,:,273),wf(:,0),G2(:,:,:,274),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,274),Q(:,63),MB,G3tensor(:,88))
  call loop_AV_Q(G0(:,:,:,1),wf(:,293),G0(:,:,:,55))
  call loop_A_Q(G0(:,:,:,55),Q(:,30),MB,G1(:,:,:,181))
  call loop_AV_Q(G1(:,:,:,181),wf(:,-5),G1(:,:,:,182))
  call loop_A_Q(G1(:,:,:,182),Q(:,62),MB,G2(:,:,:,275))
  call loop_AS_Q(G2(:,:,:,275),wf(:,0),G2(:,:,:,276),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,276),Q(:,63),MB,G3tensor(:,89))
  call loop_AV_Q(G0(:,:,:,1),wf(:,294),G0(:,:,:,56))
  call loop_A_Q(G0(:,:,:,56),Q(:,30),MB,G1(:,:,:,183))
  call loop_AV_Q(G1(:,:,:,183),wf(:,-5),G1(:,:,:,184))
  call loop_A_Q(G1(:,:,:,184),Q(:,62),MB,G2(:,:,:,277))
  call loop_AS_Q(G2(:,:,:,277),wf(:,0),G2(:,:,:,278),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,278),Q(:,63),MB,G3tensor(:,90))
  call loop_AV_Q(G0(:,:,:,1),wf(:,65),G0(:,:,:,57))
  call loop_A_Q(G0(:,:,:,57),Q(:,12),MT,G1(:,:,:,185))
  call loop_AV_Q(G1(:,:,:,185),wf(:,66),G1(:,:,:,186))
  call loop_A_Q(G1(:,:,:,186),Q(:,62),MT,G2(:,:,:,279))
  call loop_AS_Q(G2(:,:,:,279),wf(:,0),G2(:,:,:,280),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,280),Q(:,63),MT,G3tensor(:,91))
  call loop_AV_Q(G1(:,:,:,185),wf(:,68),G1(:,:,:,187))
  call loop_A_Q(G1(:,:,:,187),Q(:,62),MT,G2(:,:,:,281))
  call loop_AS_Q(G2(:,:,:,281),wf(:,0),G2(:,:,:,282),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,282),Q(:,63),MT,G3tensor(:,92))
  call loop_AV_Q(G1(:,:,:,185),wf(:,69),G1(:,:,:,188))
  call loop_A_Q(G1(:,:,:,188),Q(:,62),MT,G2(:,:,:,283))
  call loop_AS_Q(G2(:,:,:,283),wf(:,0),G2(:,:,:,284),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,284),Q(:,63),MT,G3tensor(:,93))
  call loop_AV_Q(G1(:,:,:,185),wf(:,184),G1(:,:,:,189))
  call loop_A_Q(G1(:,:,:,189),Q(:,62),MT,G2(:,:,:,285))
  call loop_AS_Q(G2(:,:,:,285),wf(:,0),G2(:,:,:,286),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,286),Q(:,63),MT,G3tensor(:,94))
  call loop_AV_Q(G1(:,:,:,185),wf(:,29),G1(:,:,:,190))
  call loop_A_Q(G1(:,:,:,190),Q(:,30),MT,G2(:,:,:,287))
  call loop_AV_Q(G2(:,:,:,287),wf(:,-5),G2(:,:,:,288))
  call loop_A_Q(G2(:,:,:,288),Q(:,62),MT,G3(:,:,:,119))
  call loop_AS_Q(G3(:,:,:,119),wf(:,0),G3(:,:,:,120),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,120),Q(:,63),MT,G4tensor(:,40))
  call loop_AV_Q(G1(:,:,:,185),wf(:,-5),G1(:,:,:,191))
  call loop_A_Q(G1(:,:,:,191),Q(:,44),MT,G2(:,:,:,289))
  call loop_AV_Q(G2(:,:,:,289),wf(:,29),G2(:,:,:,290))
  call loop_A_Q(G2(:,:,:,290),Q(:,62),MT,G3(:,:,:,121))
  call loop_AS_Q(G3(:,:,:,121),wf(:,0),G3(:,:,:,122),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,122),Q(:,63),MT,G4tensor(:,41))
  call loop_AV_Q(G2(:,:,:,289),wf(:,-1),G2(:,:,:,291))
  call loop_A_Q(G2(:,:,:,291),Q(:,46),MT,G3(:,:,:,123))
  call loop_AV_Q(G3(:,:,:,123),wf(:,-4),G3(:,:,:,124))
  call loop_A_Q(G3(:,:,:,124),Q(:,62),MT,G4(:,:,:,41))
  call loop_AS_Q(G4(:,:,:,41),wf(:,0),G4(:,:,:,42),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,42),Q(:,63),MT,G5tensor(:,21))
  call loop_AV_Q(G1(:,:,:,185),wf(:,187),G1(:,:,:,192))
  call loop_A_Q(G1(:,:,:,192),Q(:,62),MT,G2(:,:,:,292))
  call loop_AS_Q(G2(:,:,:,292),wf(:,0),G2(:,:,:,293),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,293),Q(:,63),MT,G3tensor(:,95))
  call loop_AV_Q(G1(:,:,:,185),wf(:,37),G1(:,:,:,193))
  call loop_A_Q(G1(:,:,:,193),Q(:,46),MT,G2(:,:,:,294))
  call loop_AV_Q(G2(:,:,:,294),wf(:,-4),G2(:,:,:,295))
  call loop_A_Q(G2(:,:,:,295),Q(:,62),MT,G3(:,:,:,125))
  call loop_AS_Q(G3(:,:,:,125),wf(:,0),G3(:,:,:,126),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,126),Q(:,63),MT,G4tensor(:,42))
  call loop_AV_Q(G1(:,:,:,185),wf(:,-4),G1(:,:,:,194))
  call loop_A_Q(G1(:,:,:,194),Q(:,28),MT,G2(:,:,:,296))
  call loop_AV_Q(G2(:,:,:,296),wf(:,37),G2(:,:,:,297))
  call loop_A_Q(G2(:,:,:,297),Q(:,62),MT,G3(:,:,:,127))
  call loop_AS_Q(G3(:,:,:,127),wf(:,0),G3(:,:,:,128),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,128),Q(:,63),MT,G4tensor(:,43))
  call loop_AV_Q(G2(:,:,:,296),wf(:,-1),G2(:,:,:,298))
  call loop_A_Q(G2(:,:,:,298),Q(:,30),MT,G3(:,:,:,129))
  call loop_AV_Q(G3(:,:,:,129),wf(:,-5),G3(:,:,:,130))
  call loop_A_Q(G3(:,:,:,130),Q(:,62),MT,G4(:,:,:,43))
  call loop_AS_Q(G4(:,:,:,43),wf(:,0),G4(:,:,:,44),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,44),Q(:,63),MT,G5tensor(:,22))
  call loop_AV_Q(G1(:,:,:,185),wf(:,188),G1(:,:,:,195))
  call loop_A_Q(G1(:,:,:,195),Q(:,62),MT,G2(:,:,:,299))
  call loop_AS_Q(G2(:,:,:,299),wf(:,0),G2(:,:,:,300),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,300),Q(:,63),MT,G3tensor(:,96))
  call loop_AV_Q(G1(:,:,:,185),wf(:,-1),G1(:,:,:,196))
  call loop_A_Q(G1(:,:,:,196),Q(:,14),MT,G2(:,:,:,301))
  call loop_AV_Q(G2(:,:,:,301),wf(:,119),G2(:,:,:,302))
  call loop_A_Q(G2(:,:,:,302),Q(:,62),MT,G3(:,:,:,131))
  call loop_AS_Q(G3(:,:,:,131),wf(:,0),G3(:,:,:,132),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,132),Q(:,63),MT,G4tensor(:,44))
  call loop_AV_Q(G2(:,:,:,301),wf(:,-5),G2(:,:,:,303))
  call loop_A_Q(G2(:,:,:,303),Q(:,46),MT,G3(:,:,:,133))
  call loop_AV_Q(G3(:,:,:,133),wf(:,-4),G3(:,:,:,134))
  call loop_A_Q(G3(:,:,:,134),Q(:,62),MT,G4(:,:,:,45))
  call loop_AS_Q(G4(:,:,:,45),wf(:,0),G4(:,:,:,46),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,46),Q(:,63),MT,G5tensor(:,23))
  call loop_AV_Q(G2(:,:,:,301),wf(:,-4),G2(:,:,:,304))
  call loop_A_Q(G2(:,:,:,304),Q(:,30),MT,G3(:,:,:,135))
  call loop_AV_Q(G3(:,:,:,135),wf(:,-5),G3(:,:,:,136))
  call loop_A_Q(G3(:,:,:,136),Q(:,62),MT,G4(:,:,:,47))
  call loop_AS_Q(G4(:,:,:,47),wf(:,0),G4(:,:,:,48),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,48),Q(:,63),MT,G5tensor(:,24))
  call loop_QV_A(G0(:,:,:,1),wf(:,65),G0(:,:,:,58))
  call loop_Q_A(G0(:,:,:,58),Q(:,12),MT,G1(:,:,:,197))
  call loop_QV_A(G1(:,:,:,197),wf(:,66),G1(:,:,:,198))
  call loop_Q_A(G1(:,:,:,198),Q(:,62),MT,G2(:,:,:,305))
  call loop_QS_A(G2(:,:,:,305),wf(:,0),G2(:,:,:,306),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,306),Q(:,63),MT,G3tensor(:,97))
  call loop_QV_A(G1(:,:,:,197),wf(:,68),G1(:,:,:,199))
  call loop_Q_A(G1(:,:,:,199),Q(:,62),MT,G2(:,:,:,307))
  call loop_QS_A(G2(:,:,:,307),wf(:,0),G2(:,:,:,308),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,308),Q(:,63),MT,G3tensor(:,98))
  call loop_QV_A(G1(:,:,:,197),wf(:,69),G1(:,:,:,200))
  call loop_Q_A(G1(:,:,:,200),Q(:,62),MT,G2(:,:,:,309))
  call loop_QS_A(G2(:,:,:,309),wf(:,0),G2(:,:,:,310),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,310),Q(:,63),MT,G3tensor(:,99))
  call loop_QV_A(G1(:,:,:,197),wf(:,184),G1(:,:,:,201))
  call loop_Q_A(G1(:,:,:,201),Q(:,62),MT,G2(:,:,:,311))
  call loop_QS_A(G2(:,:,:,311),wf(:,0),G2(:,:,:,312),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,312),Q(:,63),MT,G3tensor(:,100))
  call loop_QV_A(G1(:,:,:,197),wf(:,29),G1(:,:,:,202))
  call loop_Q_A(G1(:,:,:,202),Q(:,30),MT,G2(:,:,:,313))
  call loop_QV_A(G2(:,:,:,313),wf(:,-5),G2(:,:,:,314))
  call loop_Q_A(G2(:,:,:,314),Q(:,62),MT,G3(:,:,:,137))
  call loop_QS_A(G3(:,:,:,137),wf(:,0),G3(:,:,:,138),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,138),Q(:,63),MT,G4tensor(:,45))
  call loop_QV_A(G1(:,:,:,197),wf(:,-5),G1(:,:,:,203))
  call loop_Q_A(G1(:,:,:,203),Q(:,44),MT,G2(:,:,:,315))
  call loop_QV_A(G2(:,:,:,315),wf(:,29),G2(:,:,:,316))
  call loop_Q_A(G2(:,:,:,316),Q(:,62),MT,G3(:,:,:,139))
  call loop_QS_A(G3(:,:,:,139),wf(:,0),G3(:,:,:,140),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,140),Q(:,63),MT,G4tensor(:,46))
  call loop_QV_A(G2(:,:,:,315),wf(:,-1),G2(:,:,:,317))
  call loop_Q_A(G2(:,:,:,317),Q(:,46),MT,G3(:,:,:,141))
  call loop_QV_A(G3(:,:,:,141),wf(:,-4),G3(:,:,:,142))
  call loop_Q_A(G3(:,:,:,142),Q(:,62),MT,G4(:,:,:,49))
  call loop_QS_A(G4(:,:,:,49),wf(:,0),G4(:,:,:,50),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,50),Q(:,63),MT,G5tensor(:,25))
  call loop_QV_A(G1(:,:,:,197),wf(:,187),G1(:,:,:,204))
  call loop_Q_A(G1(:,:,:,204),Q(:,62),MT,G2(:,:,:,318))
  call loop_QS_A(G2(:,:,:,318),wf(:,0),G2(:,:,:,319),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,319),Q(:,63),MT,G3tensor(:,101))
  call loop_QV_A(G1(:,:,:,197),wf(:,37),G1(:,:,:,205))
  call loop_Q_A(G1(:,:,:,205),Q(:,46),MT,G2(:,:,:,320))
  call loop_QV_A(G2(:,:,:,320),wf(:,-4),G2(:,:,:,321))
  call loop_Q_A(G2(:,:,:,321),Q(:,62),MT,G3(:,:,:,143))
  call loop_QS_A(G3(:,:,:,143),wf(:,0),G3(:,:,:,144),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,144),Q(:,63),MT,G4tensor(:,47))
  call loop_QV_A(G1(:,:,:,197),wf(:,-4),G1(:,:,:,206))
  call loop_Q_A(G1(:,:,:,206),Q(:,28),MT,G2(:,:,:,322))
  call loop_QV_A(G2(:,:,:,322),wf(:,37),G2(:,:,:,323))
  call loop_Q_A(G2(:,:,:,323),Q(:,62),MT,G3(:,:,:,145))
  call loop_QS_A(G3(:,:,:,145),wf(:,0),G3(:,:,:,146),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,146),Q(:,63),MT,G4tensor(:,48))
  call loop_QV_A(G2(:,:,:,322),wf(:,-1),G2(:,:,:,324))
  call loop_Q_A(G2(:,:,:,324),Q(:,30),MT,G3(:,:,:,147))
  call loop_QV_A(G3(:,:,:,147),wf(:,-5),G3(:,:,:,148))
  call loop_Q_A(G3(:,:,:,148),Q(:,62),MT,G4(:,:,:,51))
  call loop_QS_A(G4(:,:,:,51),wf(:,0),G4(:,:,:,52),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,52),Q(:,63),MT,G5tensor(:,26))
  call loop_QV_A(G1(:,:,:,197),wf(:,188),G1(:,:,:,207))
  call loop_Q_A(G1(:,:,:,207),Q(:,62),MT,G2(:,:,:,325))
  call loop_QS_A(G2(:,:,:,325),wf(:,0),G2(:,:,:,326),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,326),Q(:,63),MT,G3tensor(:,102))
  call loop_QV_A(G1(:,:,:,197),wf(:,-1),G1(:,:,:,208))
  call loop_Q_A(G1(:,:,:,208),Q(:,14),MT,G2(:,:,:,327))
  call loop_QV_A(G2(:,:,:,327),wf(:,119),G2(:,:,:,328))
  call loop_Q_A(G2(:,:,:,328),Q(:,62),MT,G3(:,:,:,149))
  call loop_QS_A(G3(:,:,:,149),wf(:,0),G3(:,:,:,150),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,150),Q(:,63),MT,G4tensor(:,49))
  call loop_QV_A(G2(:,:,:,327),wf(:,-5),G2(:,:,:,329))
  call loop_Q_A(G2(:,:,:,329),Q(:,46),MT,G3(:,:,:,151))
  call loop_QV_A(G3(:,:,:,151),wf(:,-4),G3(:,:,:,152))
  call loop_Q_A(G3(:,:,:,152),Q(:,62),MT,G4(:,:,:,53))
  call loop_QS_A(G4(:,:,:,53),wf(:,0),G4(:,:,:,54),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,54),Q(:,63),MT,G5tensor(:,27))
  call loop_QV_A(G2(:,:,:,327),wf(:,-4),G2(:,:,:,330))
  call loop_Q_A(G2(:,:,:,330),Q(:,30),MT,G3(:,:,:,153))
  call loop_QV_A(G3(:,:,:,153),wf(:,-5),G3(:,:,:,154))
  call loop_Q_A(G3(:,:,:,154),Q(:,62),MT,G4(:,:,:,55))
  call loop_QS_A(G4(:,:,:,55),wf(:,0),G4(:,:,:,56),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,56),Q(:,63),MT,G5tensor(:,28))
  call loop_AV_Q(G0(:,:,:,1),wf(:,65),G0(:,:,:,59))
  call loop_A_Q(G0(:,:,:,59),Q(:,12),MB,G1(:,:,:,209))
  call loop_AV_Q(G1(:,:,:,209),wf(:,66),G1(:,:,:,210))
  call loop_A_Q(G1(:,:,:,210),Q(:,62),MB,G2(:,:,:,331))
  call loop_AS_Q(G2(:,:,:,331),wf(:,0),G2(:,:,:,332),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,332),Q(:,63),MB,G3tensor(:,103))
  call loop_AV_Q(G1(:,:,:,209),wf(:,68),G1(:,:,:,211))
  call loop_A_Q(G1(:,:,:,211),Q(:,62),MB,G2(:,:,:,333))
  call loop_AS_Q(G2(:,:,:,333),wf(:,0),G2(:,:,:,334),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,334),Q(:,63),MB,G3tensor(:,104))
  call loop_AV_Q(G1(:,:,:,209),wf(:,69),G1(:,:,:,212))
  call loop_A_Q(G1(:,:,:,212),Q(:,62),MB,G2(:,:,:,335))
  call loop_AS_Q(G2(:,:,:,335),wf(:,0),G2(:,:,:,336),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,336),Q(:,63),MB,G3tensor(:,105))
  call loop_AV_Q(G1(:,:,:,209),wf(:,184),G1(:,:,:,213))
  call loop_A_Q(G1(:,:,:,213),Q(:,62),MB,G2(:,:,:,337))
  call loop_AS_Q(G2(:,:,:,337),wf(:,0),G2(:,:,:,338),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,338),Q(:,63),MB,G3tensor(:,106))
  call loop_AV_Q(G1(:,:,:,209),wf(:,29),G1(:,:,:,214))
  call loop_A_Q(G1(:,:,:,214),Q(:,30),MB,G2(:,:,:,339))
  call loop_AV_Q(G2(:,:,:,339),wf(:,-5),G2(:,:,:,340))
  call loop_A_Q(G2(:,:,:,340),Q(:,62),MB,G3(:,:,:,155))
  call loop_AS_Q(G3(:,:,:,155),wf(:,0),G3(:,:,:,156),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,156),Q(:,63),MB,G4tensor(:,50))
  call loop_AV_Q(G1(:,:,:,209),wf(:,-5),G1(:,:,:,215))
  call loop_A_Q(G1(:,:,:,215),Q(:,44),MB,G2(:,:,:,341))
  call loop_AV_Q(G2(:,:,:,341),wf(:,29),G2(:,:,:,342))
  call loop_A_Q(G2(:,:,:,342),Q(:,62),MB,G3(:,:,:,157))
  call loop_AS_Q(G3(:,:,:,157),wf(:,0),G3(:,:,:,158),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,158),Q(:,63),MB,G4tensor(:,51))
  call loop_AV_Q(G2(:,:,:,341),wf(:,-1),G2(:,:,:,343))
  call loop_A_Q(G2(:,:,:,343),Q(:,46),MB,G3(:,:,:,159))
  call loop_AV_Q(G3(:,:,:,159),wf(:,-4),G3(:,:,:,160))
  call loop_A_Q(G3(:,:,:,160),Q(:,62),MB,G4(:,:,:,57))
  call loop_AS_Q(G4(:,:,:,57),wf(:,0),G4(:,:,:,58),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,58),Q(:,63),MB,G5tensor(:,29))
  call loop_AV_Q(G1(:,:,:,209),wf(:,187),G1(:,:,:,216))
  call loop_A_Q(G1(:,:,:,216),Q(:,62),MB,G2(:,:,:,344))
  call loop_AS_Q(G2(:,:,:,344),wf(:,0),G2(:,:,:,345),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,345),Q(:,63),MB,G3tensor(:,107))
  call loop_AV_Q(G1(:,:,:,209),wf(:,37),G1(:,:,:,217))
  call loop_A_Q(G1(:,:,:,217),Q(:,46),MB,G2(:,:,:,346))
  call loop_AV_Q(G2(:,:,:,346),wf(:,-4),G2(:,:,:,347))
  call loop_A_Q(G2(:,:,:,347),Q(:,62),MB,G3(:,:,:,161))
  call loop_AS_Q(G3(:,:,:,161),wf(:,0),G3(:,:,:,162),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,162),Q(:,63),MB,G4tensor(:,52))
  call loop_AV_Q(G1(:,:,:,209),wf(:,-4),G1(:,:,:,218))
  call loop_A_Q(G1(:,:,:,218),Q(:,28),MB,G2(:,:,:,348))
  call loop_AV_Q(G2(:,:,:,348),wf(:,37),G2(:,:,:,349))
  call loop_A_Q(G2(:,:,:,349),Q(:,62),MB,G3(:,:,:,163))
  call loop_AS_Q(G3(:,:,:,163),wf(:,0),G3(:,:,:,164),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,164),Q(:,63),MB,G4tensor(:,53))
  call loop_AV_Q(G2(:,:,:,348),wf(:,-1),G2(:,:,:,350))
  call loop_A_Q(G2(:,:,:,350),Q(:,30),MB,G3(:,:,:,165))
  call loop_AV_Q(G3(:,:,:,165),wf(:,-5),G3(:,:,:,166))
  call loop_A_Q(G3(:,:,:,166),Q(:,62),MB,G4(:,:,:,59))
  call loop_AS_Q(G4(:,:,:,59),wf(:,0),G4(:,:,:,60),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,60),Q(:,63),MB,G5tensor(:,30))
  call loop_AV_Q(G1(:,:,:,209),wf(:,188),G1(:,:,:,219))
  call loop_A_Q(G1(:,:,:,219),Q(:,62),MB,G2(:,:,:,351))
  call loop_AS_Q(G2(:,:,:,351),wf(:,0),G2(:,:,:,352),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,352),Q(:,63),MB,G3tensor(:,108))
  call loop_AV_Q(G1(:,:,:,209),wf(:,-1),G1(:,:,:,220))
  call loop_A_Q(G1(:,:,:,220),Q(:,14),MB,G2(:,:,:,353))
  call loop_AV_Q(G2(:,:,:,353),wf(:,119),G2(:,:,:,354))
  call loop_A_Q(G2(:,:,:,354),Q(:,62),MB,G3(:,:,:,167))
  call loop_AS_Q(G3(:,:,:,167),wf(:,0),G3(:,:,:,168),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,168),Q(:,63),MB,G4tensor(:,54))
  call loop_AV_Q(G2(:,:,:,353),wf(:,-5),G2(:,:,:,355))
  call loop_A_Q(G2(:,:,:,355),Q(:,46),MB,G3(:,:,:,169))
  call loop_AV_Q(G3(:,:,:,169),wf(:,-4),G3(:,:,:,170))
  call loop_A_Q(G3(:,:,:,170),Q(:,62),MB,G4(:,:,:,61))
  call loop_AS_Q(G4(:,:,:,61),wf(:,0),G4(:,:,:,62),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,62),Q(:,63),MB,G5tensor(:,31))
  call loop_AV_Q(G2(:,:,:,353),wf(:,-4),G2(:,:,:,356))
  call loop_A_Q(G2(:,:,:,356),Q(:,30),MB,G3(:,:,:,171))
  call loop_AV_Q(G3(:,:,:,171),wf(:,-5),G3(:,:,:,172))
  call loop_A_Q(G3(:,:,:,172),Q(:,62),MB,G4(:,:,:,63))
  call loop_AS_Q(G4(:,:,:,63),wf(:,0),G4(:,:,:,64),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,64),Q(:,63),MB,G5tensor(:,32))
  call loop_QV_A(G0(:,:,:,1),wf(:,65),G0(:,:,:,60))
  call loop_Q_A(G0(:,:,:,60),Q(:,12),MB,G1(:,:,:,221))
  call loop_QV_A(G1(:,:,:,221),wf(:,66),G1(:,:,:,222))
  call loop_Q_A(G1(:,:,:,222),Q(:,62),MB,G2(:,:,:,357))
  call loop_QS_A(G2(:,:,:,357),wf(:,0),G2(:,:,:,358),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,358),Q(:,63),MB,G3tensor(:,109))
  call loop_QV_A(G1(:,:,:,221),wf(:,68),G1(:,:,:,223))
  call loop_Q_A(G1(:,:,:,223),Q(:,62),MB,G2(:,:,:,359))
  call loop_QS_A(G2(:,:,:,359),wf(:,0),G2(:,:,:,360),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,360),Q(:,63),MB,G3tensor(:,110))
  call loop_QV_A(G1(:,:,:,221),wf(:,69),G1(:,:,:,224))
  call loop_Q_A(G1(:,:,:,224),Q(:,62),MB,G2(:,:,:,361))
  call loop_QS_A(G2(:,:,:,361),wf(:,0),G2(:,:,:,362),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,362),Q(:,63),MB,G3tensor(:,111))
  call loop_QV_A(G1(:,:,:,221),wf(:,184),G1(:,:,:,225))
  call loop_Q_A(G1(:,:,:,225),Q(:,62),MB,G2(:,:,:,363))
  call loop_QS_A(G2(:,:,:,363),wf(:,0),G2(:,:,:,364),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,364),Q(:,63),MB,G3tensor(:,112))
  call loop_QV_A(G1(:,:,:,221),wf(:,29),G1(:,:,:,226))
  call loop_Q_A(G1(:,:,:,226),Q(:,30),MB,G2(:,:,:,365))
  call loop_QV_A(G2(:,:,:,365),wf(:,-5),G2(:,:,:,366))
  call loop_Q_A(G2(:,:,:,366),Q(:,62),MB,G3(:,:,:,173))
  call loop_QS_A(G3(:,:,:,173),wf(:,0),G3(:,:,:,174),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,174),Q(:,63),MB,G4tensor(:,55))
  call loop_QV_A(G1(:,:,:,221),wf(:,-5),G1(:,:,:,227))
  call loop_Q_A(G1(:,:,:,227),Q(:,44),MB,G2(:,:,:,367))
  call loop_QV_A(G2(:,:,:,367),wf(:,29),G2(:,:,:,368))
  call loop_Q_A(G2(:,:,:,368),Q(:,62),MB,G3(:,:,:,175))
  call loop_QS_A(G3(:,:,:,175),wf(:,0),G3(:,:,:,176),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,176),Q(:,63),MB,G4tensor(:,56))
  call loop_QV_A(G2(:,:,:,367),wf(:,-1),G2(:,:,:,369))
  call loop_Q_A(G2(:,:,:,369),Q(:,46),MB,G3(:,:,:,177))
  call loop_QV_A(G3(:,:,:,177),wf(:,-4),G3(:,:,:,178))
  call loop_Q_A(G3(:,:,:,178),Q(:,62),MB,G4(:,:,:,65))
  call loop_QS_A(G4(:,:,:,65),wf(:,0),G4(:,:,:,66),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,66),Q(:,63),MB,G5tensor(:,33))
  call loop_QV_A(G1(:,:,:,221),wf(:,187),G1(:,:,:,228))
  call loop_Q_A(G1(:,:,:,228),Q(:,62),MB,G2(:,:,:,370))
  call loop_QS_A(G2(:,:,:,370),wf(:,0),G2(:,:,:,371),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,371),Q(:,63),MB,G3tensor(:,113))
  call loop_QV_A(G1(:,:,:,221),wf(:,37),G1(:,:,:,229))
  call loop_Q_A(G1(:,:,:,229),Q(:,46),MB,G2(:,:,:,372))
  call loop_QV_A(G2(:,:,:,372),wf(:,-4),G2(:,:,:,373))
  call loop_Q_A(G2(:,:,:,373),Q(:,62),MB,G3(:,:,:,179))
  call loop_QS_A(G3(:,:,:,179),wf(:,0),G3(:,:,:,180),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,180),Q(:,63),MB,G4tensor(:,57))
  call loop_QV_A(G1(:,:,:,221),wf(:,-4),G1(:,:,:,230))
  call loop_Q_A(G1(:,:,:,230),Q(:,28),MB,G2(:,:,:,374))
  call loop_QV_A(G2(:,:,:,374),wf(:,37),G2(:,:,:,375))
  call loop_Q_A(G2(:,:,:,375),Q(:,62),MB,G3(:,:,:,181))
  call loop_QS_A(G3(:,:,:,181),wf(:,0),G3(:,:,:,182),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,182),Q(:,63),MB,G4tensor(:,58))
  call loop_QV_A(G2(:,:,:,374),wf(:,-1),G2(:,:,:,376))
  call loop_Q_A(G2(:,:,:,376),Q(:,30),MB,G3(:,:,:,183))
  call loop_QV_A(G3(:,:,:,183),wf(:,-5),G3(:,:,:,184))
  call loop_Q_A(G3(:,:,:,184),Q(:,62),MB,G4(:,:,:,67))
  call loop_QS_A(G4(:,:,:,67),wf(:,0),G4(:,:,:,68),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,68),Q(:,63),MB,G5tensor(:,34))
  call loop_QV_A(G1(:,:,:,221),wf(:,188),G1(:,:,:,231))
  call loop_Q_A(G1(:,:,:,231),Q(:,62),MB,G2(:,:,:,377))
  call loop_QS_A(G2(:,:,:,377),wf(:,0),G2(:,:,:,378),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,378),Q(:,63),MB,G3tensor(:,114))
  call loop_QV_A(G1(:,:,:,221),wf(:,-1),G1(:,:,:,232))
  call loop_Q_A(G1(:,:,:,232),Q(:,14),MB,G2(:,:,:,379))
  call loop_QV_A(G2(:,:,:,379),wf(:,119),G2(:,:,:,380))
  call loop_Q_A(G2(:,:,:,380),Q(:,62),MB,G3(:,:,:,185))
  call loop_QS_A(G3(:,:,:,185),wf(:,0),G3(:,:,:,186),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,186),Q(:,63),MB,G4tensor(:,59))
  call loop_QV_A(G2(:,:,:,379),wf(:,-5),G2(:,:,:,381))
  call loop_Q_A(G2(:,:,:,381),Q(:,46),MB,G3(:,:,:,187))
  call loop_QV_A(G3(:,:,:,187),wf(:,-4),G3(:,:,:,188))
  call loop_Q_A(G3(:,:,:,188),Q(:,62),MB,G4(:,:,:,69))
  call loop_QS_A(G4(:,:,:,69),wf(:,0),G4(:,:,:,70),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,70),Q(:,63),MB,G5tensor(:,35))
  call loop_QV_A(G2(:,:,:,379),wf(:,-4),G2(:,:,:,382))
  call loop_Q_A(G2(:,:,:,382),Q(:,30),MB,G3(:,:,:,189))
  call loop_QV_A(G3(:,:,:,189),wf(:,-5),G3(:,:,:,190))
  call loop_Q_A(G3(:,:,:,190),Q(:,62),MB,G4(:,:,:,71))
  call loop_QS_A(G4(:,:,:,71),wf(:,0),G4(:,:,:,72),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,72),Q(:,63),MB,G5tensor(:,36))
  call loop_QV_A(G0(:,:,:,1),wf(:,313),G0(:,:,:,61))
  call loop_Q_A(G0(:,:,:,61),Q(:,30),MT,G1(:,:,:,233))
  call loop_QV_A(G1(:,:,:,233),wf(:,-5),G1(:,:,:,234))
  call loop_Q_A(G1(:,:,:,234),Q(:,62),MT,G2(:,:,:,383))
  call loop_QS_A(G2(:,:,:,383),wf(:,0),G2(:,:,:,384),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,384),Q(:,63),MT,G3tensor(:,115))
  call loop_QV_A(G0(:,:,:,1),wf(:,314),G0(:,:,:,62))
  call loop_Q_A(G0(:,:,:,62),Q(:,30),MT,G1(:,:,:,235))
  call loop_QV_A(G1(:,:,:,235),wf(:,-5),G1(:,:,:,236))
  call loop_Q_A(G1(:,:,:,236),Q(:,62),MT,G2(:,:,:,385))
  call loop_QS_A(G2(:,:,:,385),wf(:,0),G2(:,:,:,386),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,386),Q(:,63),MT,G3tensor(:,116))
  call loop_QV_A(G0(:,:,:,1),wf(:,315),G0(:,:,:,63))
  call loop_Q_A(G0(:,:,:,63),Q(:,30),MT,G1(:,:,:,237))
  call loop_QV_A(G1(:,:,:,237),wf(:,-5),G1(:,:,:,238))
  call loop_Q_A(G1(:,:,:,238),Q(:,62),MT,G2(:,:,:,387))
  call loop_QS_A(G2(:,:,:,387),wf(:,0),G2(:,:,:,388),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,388),Q(:,63),MT,G3tensor(:,117))
  call loop_AV_Q(G0(:,:,:,1),wf(:,313),G0(:,:,:,64))
  call loop_A_Q(G0(:,:,:,64),Q(:,30),MT,G1(:,:,:,239))
  call loop_AV_Q(G1(:,:,:,239),wf(:,-5),G1(:,:,:,240))
  call loop_A_Q(G1(:,:,:,240),Q(:,62),MT,G2(:,:,:,389))
  call loop_AS_Q(G2(:,:,:,389),wf(:,0),G2(:,:,:,390),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,390),Q(:,63),MT,G3tensor(:,118))
  call loop_AV_Q(G0(:,:,:,1),wf(:,314),G0(:,:,:,65))
  call loop_A_Q(G0(:,:,:,65),Q(:,30),MT,G1(:,:,:,241))
  call loop_AV_Q(G1(:,:,:,241),wf(:,-5),G1(:,:,:,242))
  call loop_A_Q(G1(:,:,:,242),Q(:,62),MT,G2(:,:,:,391))
  call loop_AS_Q(G2(:,:,:,391),wf(:,0),G2(:,:,:,392),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,392),Q(:,63),MT,G3tensor(:,119))
  call loop_AV_Q(G0(:,:,:,1),wf(:,315),G0(:,:,:,66))
  call loop_A_Q(G0(:,:,:,66),Q(:,30),MT,G1(:,:,:,243))
  call loop_AV_Q(G1(:,:,:,243),wf(:,-5),G1(:,:,:,244))
  call loop_A_Q(G1(:,:,:,244),Q(:,62),MT,G2(:,:,:,393))
  call loop_AS_Q(G2(:,:,:,393),wf(:,0),G2(:,:,:,394),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,394),Q(:,63),MT,G3tensor(:,120))
  call loop_QV_A(G0(:,:,:,1),wf(:,313),G0(:,:,:,67))
  call loop_Q_A(G0(:,:,:,67),Q(:,30),MB,G1(:,:,:,245))
  call loop_QV_A(G1(:,:,:,245),wf(:,-5),G1(:,:,:,246))
  call loop_Q_A(G1(:,:,:,246),Q(:,62),MB,G2(:,:,:,395))
  call loop_QS_A(G2(:,:,:,395),wf(:,0),G2(:,:,:,396),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,396),Q(:,63),MB,G3tensor(:,121))
  call loop_QV_A(G0(:,:,:,1),wf(:,314),G0(:,:,:,68))
  call loop_Q_A(G0(:,:,:,68),Q(:,30),MB,G1(:,:,:,247))
  call loop_QV_A(G1(:,:,:,247),wf(:,-5),G1(:,:,:,248))
  call loop_Q_A(G1(:,:,:,248),Q(:,62),MB,G2(:,:,:,397))
  call loop_QS_A(G2(:,:,:,397),wf(:,0),G2(:,:,:,398),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,398),Q(:,63),MB,G3tensor(:,122))
  call loop_QV_A(G0(:,:,:,1),wf(:,315),G0(:,:,:,69))
  call loop_Q_A(G0(:,:,:,69),Q(:,30),MB,G1(:,:,:,249))
  call loop_QV_A(G1(:,:,:,249),wf(:,-5),G1(:,:,:,250))
  call loop_Q_A(G1(:,:,:,250),Q(:,62),MB,G2(:,:,:,399))
  call loop_QS_A(G2(:,:,:,399),wf(:,0),G2(:,:,:,400),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,400),Q(:,63),MB,G3tensor(:,123))
  call loop_AV_Q(G0(:,:,:,1),wf(:,313),G0(:,:,:,70))
  call loop_A_Q(G0(:,:,:,70),Q(:,30),MB,G1(:,:,:,251))
  call loop_AV_Q(G1(:,:,:,251),wf(:,-5),G1(:,:,:,252))
  call loop_A_Q(G1(:,:,:,252),Q(:,62),MB,G2(:,:,:,401))
  call loop_AS_Q(G2(:,:,:,401),wf(:,0),G2(:,:,:,402),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,402),Q(:,63),MB,G3tensor(:,124))
  call loop_AV_Q(G0(:,:,:,1),wf(:,314),G0(:,:,:,71))
  call loop_A_Q(G0(:,:,:,71),Q(:,30),MB,G1(:,:,:,253))
  call loop_AV_Q(G1(:,:,:,253),wf(:,-5),G1(:,:,:,254))
  call loop_A_Q(G1(:,:,:,254),Q(:,62),MB,G2(:,:,:,403))
  call loop_AS_Q(G2(:,:,:,403),wf(:,0),G2(:,:,:,404),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,404),Q(:,63),MB,G3tensor(:,125))
  call loop_AV_Q(G0(:,:,:,1),wf(:,315),G0(:,:,:,72))
  call loop_A_Q(G0(:,:,:,72),Q(:,30),MB,G1(:,:,:,255))
  call loop_AV_Q(G1(:,:,:,255),wf(:,-5),G1(:,:,:,256))
  call loop_A_Q(G1(:,:,:,256),Q(:,62),MB,G2(:,:,:,405))
  call loop_AS_Q(G2(:,:,:,405),wf(:,0),G2(:,:,:,406),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,406),Q(:,63),MB,G3tensor(:,126))
  call loop_AV_Q(G0(:,:,:,1),wf(:,76),G0(:,:,:,73))
  call loop_A_Q(G0(:,:,:,73),Q(:,20),MT,G1(:,:,:,257))
  call loop_AV_Q(G1(:,:,:,257),wf(:,77),G1(:,:,:,258))
  call loop_A_Q(G1(:,:,:,258),Q(:,62),MT,G2(:,:,:,407))
  call loop_AS_Q(G2(:,:,:,407),wf(:,0),G2(:,:,:,408),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,408),Q(:,63),MT,G3tensor(:,127))
  call loop_AV_Q(G1(:,:,:,257),wf(:,79),G1(:,:,:,259))
  call loop_A_Q(G1(:,:,:,259),Q(:,62),MT,G2(:,:,:,409))
  call loop_AS_Q(G2(:,:,:,409),wf(:,0),G2(:,:,:,410),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,410),Q(:,63),MT,G3tensor(:,128))
  call loop_AV_Q(G1(:,:,:,257),wf(:,80),G1(:,:,:,260))
  call loop_A_Q(G1(:,:,:,260),Q(:,62),MT,G2(:,:,:,411))
  call loop_AS_Q(G2(:,:,:,411),wf(:,0),G2(:,:,:,412),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,412),Q(:,63),MT,G3tensor(:,129))
  call loop_AV_Q(G1(:,:,:,257),wf(:,176),G1(:,:,:,261))
  call loop_A_Q(G1(:,:,:,261),Q(:,62),MT,G2(:,:,:,413))
  call loop_AS_Q(G2(:,:,:,413),wf(:,0),G2(:,:,:,414),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,414),Q(:,63),MT,G3tensor(:,130))
  call loop_AV_Q(G1(:,:,:,257),wf(:,18),G1(:,:,:,262))
  call loop_A_Q(G1(:,:,:,262),Q(:,30),MT,G2(:,:,:,415))
  call loop_AV_Q(G2(:,:,:,415),wf(:,-5),G2(:,:,:,416))
  call loop_A_Q(G2(:,:,:,416),Q(:,62),MT,G3(:,:,:,191))
  call loop_AS_Q(G3(:,:,:,191),wf(:,0),G3(:,:,:,192),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,192),Q(:,63),MT,G4tensor(:,60))
  call loop_AV_Q(G1(:,:,:,257),wf(:,196),G1(:,:,:,263))
  call loop_A_Q(G1(:,:,:,263),Q(:,62),MT,G2(:,:,:,417))
  call loop_AS_Q(G2(:,:,:,417),wf(:,0),G2(:,:,:,418),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,418),Q(:,63),MT,G3tensor(:,131))
  call loop_AV_Q(G1(:,:,:,257),wf(:,-3),G1(:,:,:,264))
  call loop_A_Q(G1(:,:,:,264),Q(:,28),MT,G2(:,:,:,419))
  call loop_AV_Q(G2(:,:,:,419),wf(:,37),G2(:,:,:,420))
  call loop_A_Q(G2(:,:,:,420),Q(:,62),MT,G3(:,:,:,193))
  call loop_AS_Q(G3(:,:,:,193),wf(:,0),G3(:,:,:,194),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,194),Q(:,63),MT,G4tensor(:,61))
  call loop_AV_Q(G2(:,:,:,419),wf(:,-1),G2(:,:,:,421))
  call loop_A_Q(G2(:,:,:,421),Q(:,30),MT,G3(:,:,:,195))
  call loop_AV_Q(G3(:,:,:,195),wf(:,-5),G3(:,:,:,196))
  call loop_A_Q(G3(:,:,:,196),Q(:,62),MT,G4(:,:,:,73))
  call loop_AS_Q(G4(:,:,:,73),wf(:,0),G4(:,:,:,74),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,74),Q(:,63),MT,G5tensor(:,37))
  call loop_AV_Q(G1(:,:,:,257),wf(:,197),G1(:,:,:,265))
  call loop_A_Q(G1(:,:,:,265),Q(:,62),MT,G2(:,:,:,422))
  call loop_AS_Q(G2(:,:,:,422),wf(:,0),G2(:,:,:,423),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,423),Q(:,63),MT,G3tensor(:,132))
  call loop_AV_Q(G1(:,:,:,257),wf(:,-1),G1(:,:,:,266))
  call loop_A_Q(G1(:,:,:,266),Q(:,22),MT,G2(:,:,:,424))
  call loop_AV_Q(G2(:,:,:,424),wf(:,109),G2(:,:,:,425))
  call loop_A_Q(G2(:,:,:,425),Q(:,62),MT,G3(:,:,:,197))
  call loop_AS_Q(G3(:,:,:,197),wf(:,0),G3(:,:,:,198),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,198),Q(:,63),MT,G4tensor(:,62))
  call loop_AV_Q(G2(:,:,:,424),wf(:,-3),G2(:,:,:,426))
  call loop_A_Q(G2(:,:,:,426),Q(:,30),MT,G3(:,:,:,199))
  call loop_AV_Q(G3(:,:,:,199),wf(:,-5),G3(:,:,:,200))
  call loop_A_Q(G3(:,:,:,200),Q(:,62),MT,G4(:,:,:,75))
  call loop_AS_Q(G4(:,:,:,75),wf(:,0),G4(:,:,:,76),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,76),Q(:,63),MT,G5tensor(:,38))
  call loop_QV_A(G0(:,:,:,1),wf(:,76),G0(:,:,:,74))
  call loop_Q_A(G0(:,:,:,74),Q(:,20),MT,G1(:,:,:,267))
  call loop_QV_A(G1(:,:,:,267),wf(:,77),G1(:,:,:,268))
  call loop_Q_A(G1(:,:,:,268),Q(:,62),MT,G2(:,:,:,427))
  call loop_QS_A(G2(:,:,:,427),wf(:,0),G2(:,:,:,428),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,428),Q(:,63),MT,G3tensor(:,133))
  call loop_QV_A(G1(:,:,:,267),wf(:,79),G1(:,:,:,269))
  call loop_Q_A(G1(:,:,:,269),Q(:,62),MT,G2(:,:,:,429))
  call loop_QS_A(G2(:,:,:,429),wf(:,0),G2(:,:,:,430),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,430),Q(:,63),MT,G3tensor(:,134))
  call loop_QV_A(G1(:,:,:,267),wf(:,80),G1(:,:,:,270))
  call loop_Q_A(G1(:,:,:,270),Q(:,62),MT,G2(:,:,:,431))
  call loop_QS_A(G2(:,:,:,431),wf(:,0),G2(:,:,:,432),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,432),Q(:,63),MT,G3tensor(:,135))
  call loop_QV_A(G1(:,:,:,267),wf(:,176),G1(:,:,:,271))
  call loop_Q_A(G1(:,:,:,271),Q(:,62),MT,G2(:,:,:,433))
  call loop_QS_A(G2(:,:,:,433),wf(:,0),G2(:,:,:,434),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,434),Q(:,63),MT,G3tensor(:,136))
  call loop_QV_A(G1(:,:,:,267),wf(:,18),G1(:,:,:,272))
  call loop_Q_A(G1(:,:,:,272),Q(:,30),MT,G2(:,:,:,435))
  call loop_QV_A(G2(:,:,:,435),wf(:,-5),G2(:,:,:,436))
  call loop_Q_A(G2(:,:,:,436),Q(:,62),MT,G3(:,:,:,201))
  call loop_QS_A(G3(:,:,:,201),wf(:,0),G3(:,:,:,202),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,202),Q(:,63),MT,G4tensor(:,63))
  call loop_QV_A(G1(:,:,:,267),wf(:,196),G1(:,:,:,273))
  call loop_Q_A(G1(:,:,:,273),Q(:,62),MT,G2(:,:,:,437))
  call loop_QS_A(G2(:,:,:,437),wf(:,0),G2(:,:,:,438),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,438),Q(:,63),MT,G3tensor(:,137))
  call loop_QV_A(G1(:,:,:,267),wf(:,-3),G1(:,:,:,274))
  call loop_Q_A(G1(:,:,:,274),Q(:,28),MT,G2(:,:,:,439))
  call loop_QV_A(G2(:,:,:,439),wf(:,37),G2(:,:,:,440))
  call loop_Q_A(G2(:,:,:,440),Q(:,62),MT,G3(:,:,:,203))
  call loop_QS_A(G3(:,:,:,203),wf(:,0),G3(:,:,:,204),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,204),Q(:,63),MT,G4tensor(:,64))
  call loop_QV_A(G2(:,:,:,439),wf(:,-1),G2(:,:,:,441))
  call loop_Q_A(G2(:,:,:,441),Q(:,30),MT,G3(:,:,:,205))
  call loop_QV_A(G3(:,:,:,205),wf(:,-5),G3(:,:,:,206))
  call loop_Q_A(G3(:,:,:,206),Q(:,62),MT,G4(:,:,:,77))
  call loop_QS_A(G4(:,:,:,77),wf(:,0),G4(:,:,:,78),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,78),Q(:,63),MT,G5tensor(:,39))
  call loop_QV_A(G1(:,:,:,267),wf(:,197),G1(:,:,:,275))
  call loop_Q_A(G1(:,:,:,275),Q(:,62),MT,G2(:,:,:,442))
  call loop_QS_A(G2(:,:,:,442),wf(:,0),G2(:,:,:,443),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,443),Q(:,63),MT,G3tensor(:,138))
  call loop_QV_A(G1(:,:,:,267),wf(:,-1),G1(:,:,:,276))
  call loop_Q_A(G1(:,:,:,276),Q(:,22),MT,G2(:,:,:,444))
  call loop_QV_A(G2(:,:,:,444),wf(:,109),G2(:,:,:,445))
  call loop_Q_A(G2(:,:,:,445),Q(:,62),MT,G3(:,:,:,207))
  call loop_QS_A(G3(:,:,:,207),wf(:,0),G3(:,:,:,208),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,208),Q(:,63),MT,G4tensor(:,65))
  call loop_QV_A(G2(:,:,:,444),wf(:,-3),G2(:,:,:,446))
  call loop_Q_A(G2(:,:,:,446),Q(:,30),MT,G3(:,:,:,209))
  call loop_QV_A(G3(:,:,:,209),wf(:,-5),G3(:,:,:,210))
  call loop_Q_A(G3(:,:,:,210),Q(:,62),MT,G4(:,:,:,79))
  call loop_QS_A(G4(:,:,:,79),wf(:,0),G4(:,:,:,80),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,80),Q(:,63),MT,G5tensor(:,40))
  call loop_AV_Q(G0(:,:,:,1),wf(:,76),G0(:,:,:,75))
  call loop_A_Q(G0(:,:,:,75),Q(:,20),MB,G1(:,:,:,277))
  call loop_AV_Q(G1(:,:,:,277),wf(:,77),G1(:,:,:,278))
  call loop_A_Q(G1(:,:,:,278),Q(:,62),MB,G2(:,:,:,447))
  call loop_AS_Q(G2(:,:,:,447),wf(:,0),G2(:,:,:,448),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,448),Q(:,63),MB,G3tensor(:,139))
  call loop_AV_Q(G1(:,:,:,277),wf(:,79),G1(:,:,:,279))
  call loop_A_Q(G1(:,:,:,279),Q(:,62),MB,G2(:,:,:,449))
  call loop_AS_Q(G2(:,:,:,449),wf(:,0),G2(:,:,:,450),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,450),Q(:,63),MB,G3tensor(:,140))
  call loop_AV_Q(G1(:,:,:,277),wf(:,80),G1(:,:,:,280))
  call loop_A_Q(G1(:,:,:,280),Q(:,62),MB,G2(:,:,:,451))
  call loop_AS_Q(G2(:,:,:,451),wf(:,0),G2(:,:,:,452),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,452),Q(:,63),MB,G3tensor(:,141))
  call loop_AV_Q(G1(:,:,:,277),wf(:,176),G1(:,:,:,281))
  call loop_A_Q(G1(:,:,:,281),Q(:,62),MB,G2(:,:,:,453))
  call loop_AS_Q(G2(:,:,:,453),wf(:,0),G2(:,:,:,454),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,454),Q(:,63),MB,G3tensor(:,142))
  call loop_AV_Q(G1(:,:,:,277),wf(:,18),G1(:,:,:,282))
  call loop_A_Q(G1(:,:,:,282),Q(:,30),MB,G2(:,:,:,455))
  call loop_AV_Q(G2(:,:,:,455),wf(:,-5),G2(:,:,:,456))
  call loop_A_Q(G2(:,:,:,456),Q(:,62),MB,G3(:,:,:,211))
  call loop_AS_Q(G3(:,:,:,211),wf(:,0),G3(:,:,:,212),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,212),Q(:,63),MB,G4tensor(:,66))
  call loop_AV_Q(G1(:,:,:,277),wf(:,196),G1(:,:,:,283))
  call loop_A_Q(G1(:,:,:,283),Q(:,62),MB,G2(:,:,:,457))
  call loop_AS_Q(G2(:,:,:,457),wf(:,0),G2(:,:,:,458),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,458),Q(:,63),MB,G3tensor(:,143))
  call loop_AV_Q(G1(:,:,:,277),wf(:,-3),G1(:,:,:,284))
  call loop_A_Q(G1(:,:,:,284),Q(:,28),MB,G2(:,:,:,459))
  call loop_AV_Q(G2(:,:,:,459),wf(:,37),G2(:,:,:,460))
  call loop_A_Q(G2(:,:,:,460),Q(:,62),MB,G3(:,:,:,213))
  call loop_AS_Q(G3(:,:,:,213),wf(:,0),G3(:,:,:,214),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,214),Q(:,63),MB,G4tensor(:,67))
  call loop_AV_Q(G2(:,:,:,459),wf(:,-1),G2(:,:,:,461))
  call loop_A_Q(G2(:,:,:,461),Q(:,30),MB,G3(:,:,:,215))
  call loop_AV_Q(G3(:,:,:,215),wf(:,-5),G3(:,:,:,216))
  call loop_A_Q(G3(:,:,:,216),Q(:,62),MB,G4(:,:,:,81))
  call loop_AS_Q(G4(:,:,:,81),wf(:,0),G4(:,:,:,82),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,82),Q(:,63),MB,G5tensor(:,41))
  call loop_AV_Q(G1(:,:,:,277),wf(:,197),G1(:,:,:,285))
  call loop_A_Q(G1(:,:,:,285),Q(:,62),MB,G2(:,:,:,462))
  call loop_AS_Q(G2(:,:,:,462),wf(:,0),G2(:,:,:,463),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,463),Q(:,63),MB,G3tensor(:,144))
  call loop_AV_Q(G1(:,:,:,277),wf(:,-1),G1(:,:,:,286))
  call loop_A_Q(G1(:,:,:,286),Q(:,22),MB,G2(:,:,:,464))
  call loop_AV_Q(G2(:,:,:,464),wf(:,109),G2(:,:,:,465))
  call loop_A_Q(G2(:,:,:,465),Q(:,62),MB,G3(:,:,:,217))
  call loop_AS_Q(G3(:,:,:,217),wf(:,0),G3(:,:,:,218),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,218),Q(:,63),MB,G4tensor(:,68))
  call loop_AV_Q(G2(:,:,:,464),wf(:,-3),G2(:,:,:,466))
  call loop_A_Q(G2(:,:,:,466),Q(:,30),MB,G3(:,:,:,219))
  call loop_AV_Q(G3(:,:,:,219),wf(:,-5),G3(:,:,:,220))
  call loop_A_Q(G3(:,:,:,220),Q(:,62),MB,G4(:,:,:,83))
  call loop_AS_Q(G4(:,:,:,83),wf(:,0),G4(:,:,:,84),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,84),Q(:,63),MB,G5tensor(:,42))
  call loop_QV_A(G0(:,:,:,1),wf(:,76),G0(:,:,:,76))
  call loop_Q_A(G0(:,:,:,76),Q(:,20),MB,G1(:,:,:,287))
  call loop_QV_A(G1(:,:,:,287),wf(:,77),G1(:,:,:,288))
  call loop_Q_A(G1(:,:,:,288),Q(:,62),MB,G2(:,:,:,467))
  call loop_QS_A(G2(:,:,:,467),wf(:,0),G2(:,:,:,468),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,468),Q(:,63),MB,G3tensor(:,145))
  call loop_QV_A(G1(:,:,:,287),wf(:,79),G1(:,:,:,289))
  call loop_Q_A(G1(:,:,:,289),Q(:,62),MB,G2(:,:,:,469))
  call loop_QS_A(G2(:,:,:,469),wf(:,0),G2(:,:,:,470),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,470),Q(:,63),MB,G3tensor(:,146))
  call loop_QV_A(G1(:,:,:,287),wf(:,80),G1(:,:,:,290))
  call loop_Q_A(G1(:,:,:,290),Q(:,62),MB,G2(:,:,:,471))
  call loop_QS_A(G2(:,:,:,471),wf(:,0),G2(:,:,:,472),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,472),Q(:,63),MB,G3tensor(:,147))
  call loop_QV_A(G1(:,:,:,287),wf(:,176),G1(:,:,:,291))
  call loop_Q_A(G1(:,:,:,291),Q(:,62),MB,G2(:,:,:,473))
  call loop_QS_A(G2(:,:,:,473),wf(:,0),G2(:,:,:,474),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,474),Q(:,63),MB,G3tensor(:,148))
  call loop_QV_A(G1(:,:,:,287),wf(:,18),G1(:,:,:,292))
  call loop_Q_A(G1(:,:,:,292),Q(:,30),MB,G2(:,:,:,475))
  call loop_QV_A(G2(:,:,:,475),wf(:,-5),G2(:,:,:,476))
  call loop_Q_A(G2(:,:,:,476),Q(:,62),MB,G3(:,:,:,221))
  call loop_QS_A(G3(:,:,:,221),wf(:,0),G3(:,:,:,222),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,222),Q(:,63),MB,G4tensor(:,69))
  call loop_QV_A(G1(:,:,:,287),wf(:,196),G1(:,:,:,293))
  call loop_Q_A(G1(:,:,:,293),Q(:,62),MB,G2(:,:,:,477))
  call loop_QS_A(G2(:,:,:,477),wf(:,0),G2(:,:,:,478),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,478),Q(:,63),MB,G3tensor(:,149))
  call loop_QV_A(G1(:,:,:,287),wf(:,-3),G1(:,:,:,294))
  call loop_Q_A(G1(:,:,:,294),Q(:,28),MB,G2(:,:,:,479))
  call loop_QV_A(G2(:,:,:,479),wf(:,37),G2(:,:,:,480))
  call loop_Q_A(G2(:,:,:,480),Q(:,62),MB,G3(:,:,:,223))
  call loop_QS_A(G3(:,:,:,223),wf(:,0),G3(:,:,:,224),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,224),Q(:,63),MB,G4tensor(:,70))
  call loop_QV_A(G2(:,:,:,479),wf(:,-1),G2(:,:,:,481))
  call loop_Q_A(G2(:,:,:,481),Q(:,30),MB,G3(:,:,:,225))
  call loop_QV_A(G3(:,:,:,225),wf(:,-5),G3(:,:,:,226))
  call loop_Q_A(G3(:,:,:,226),Q(:,62),MB,G4(:,:,:,85))
  call loop_QS_A(G4(:,:,:,85),wf(:,0),G4(:,:,:,86),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,86),Q(:,63),MB,G5tensor(:,43))
  call loop_QV_A(G1(:,:,:,287),wf(:,197),G1(:,:,:,295))
  call loop_Q_A(G1(:,:,:,295),Q(:,62),MB,G2(:,:,:,482))
  call loop_QS_A(G2(:,:,:,482),wf(:,0),G2(:,:,:,483),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,483),Q(:,63),MB,G3tensor(:,150))
  call loop_QV_A(G1(:,:,:,287),wf(:,-1),G1(:,:,:,296))
  call loop_Q_A(G1(:,:,:,296),Q(:,22),MB,G2(:,:,:,484))
  call loop_QV_A(G2(:,:,:,484),wf(:,109),G2(:,:,:,485))
  call loop_Q_A(G2(:,:,:,485),Q(:,62),MB,G3(:,:,:,227))
  call loop_QS_A(G3(:,:,:,227),wf(:,0),G3(:,:,:,228),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,228),Q(:,63),MB,G4tensor(:,71))
  call loop_QV_A(G2(:,:,:,484),wf(:,-3),G2(:,:,:,486))
  call loop_Q_A(G2(:,:,:,486),Q(:,30),MB,G3(:,:,:,229))
  call loop_QV_A(G3(:,:,:,229),wf(:,-5),G3(:,:,:,230))
  call loop_Q_A(G3(:,:,:,230),Q(:,62),MB,G4(:,:,:,87))
  call loop_QS_A(G4(:,:,:,87),wf(:,0),G4(:,:,:,88),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,88),Q(:,63),MB,G5tensor(:,44))
  call loop_QV_A(G0(:,:,:,1),wf(:,85),G0(:,:,:,77))
  call loop_Q_A(G0(:,:,:,77),Q(:,26),MT,G1(:,:,:,297))
  call loop_QV_A(G1(:,:,:,297),wf(:,84),G1(:,:,:,298))
  call loop_Q_A(G1(:,:,:,298),Q(:,62),MT,G2(:,:,:,487))
  call loop_QS_A(G2(:,:,:,487),wf(:,0),G2(:,:,:,488),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,488),Q(:,63),MT,G3tensor(:,151))
  call loop_QV_A(G1(:,:,:,297),wf(:,-2),G1(:,:,:,299))
  call loop_Q_A(G1(:,:,:,299),Q(:,30),MT,G2(:,:,:,489))
  call loop_QV_A(G2(:,:,:,489),wf(:,-5),G2(:,:,:,490))
  call loop_Q_A(G2(:,:,:,490),Q(:,62),MT,G3(:,:,:,231))
  call loop_QS_A(G3(:,:,:,231),wf(:,0),G3(:,:,:,232),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,232),Q(:,63),MT,G4tensor(:,72))
  call loop_QV_A(G0(:,:,:,1),wf(:,87),G0(:,:,:,78))
  call loop_Q_A(G0(:,:,:,78),Q(:,26),MT,G1(:,:,:,300))
  call loop_QV_A(G1(:,:,:,300),wf(:,84),G1(:,:,:,301))
  call loop_Q_A(G1(:,:,:,301),Q(:,62),MT,G2(:,:,:,491))
  call loop_QS_A(G2(:,:,:,491),wf(:,0),G2(:,:,:,492),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,492),Q(:,63),MT,G3tensor(:,152))
  call loop_QV_A(G1(:,:,:,300),wf(:,-2),G1(:,:,:,302))
  call loop_Q_A(G1(:,:,:,302),Q(:,30),MT,G2(:,:,:,493))
  call loop_QV_A(G2(:,:,:,493),wf(:,-5),G2(:,:,:,494))
  call loop_Q_A(G2(:,:,:,494),Q(:,62),MT,G3(:,:,:,233))
  call loop_QS_A(G3(:,:,:,233),wf(:,0),G3(:,:,:,234),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,234),Q(:,63),MT,G4tensor(:,73))
  call loop_QV_A(G0(:,:,:,1),wf(:,88),G0(:,:,:,79))
  call loop_Q_A(G0(:,:,:,79),Q(:,26),MT,G1(:,:,:,303))
  call loop_QV_A(G1(:,:,:,303),wf(:,84),G1(:,:,:,304))
  call loop_Q_A(G1(:,:,:,304),Q(:,62),MT,G2(:,:,:,495))
  call loop_QS_A(G2(:,:,:,495),wf(:,0),G2(:,:,:,496),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,496),Q(:,63),MT,G3tensor(:,153))
  call loop_QV_A(G1(:,:,:,303),wf(:,-2),G1(:,:,:,305))
  call loop_Q_A(G1(:,:,:,305),Q(:,30),MT,G2(:,:,:,497))
  call loop_QV_A(G2(:,:,:,497),wf(:,-5),G2(:,:,:,498))
  call loop_Q_A(G2(:,:,:,498),Q(:,62),MT,G3(:,:,:,235))
  call loop_QS_A(G3(:,:,:,235),wf(:,0),G3(:,:,:,236),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,236),Q(:,63),MT,G4tensor(:,74))
  call loop_AV_Q(G0(:,:,:,1),wf(:,85),G0(:,:,:,80))
  call loop_A_Q(G0(:,:,:,80),Q(:,26),MT,G1(:,:,:,306))
  call loop_AV_Q(G1(:,:,:,306),wf(:,84),G1(:,:,:,307))
  call loop_A_Q(G1(:,:,:,307),Q(:,62),MT,G2(:,:,:,499))
  call loop_AS_Q(G2(:,:,:,499),wf(:,0),G2(:,:,:,500),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,500),Q(:,63),MT,G3tensor(:,154))
  call loop_AV_Q(G1(:,:,:,306),wf(:,-2),G1(:,:,:,308))
  call loop_A_Q(G1(:,:,:,308),Q(:,30),MT,G2(:,:,:,501))
  call loop_AV_Q(G2(:,:,:,501),wf(:,-5),G2(:,:,:,502))
  call loop_A_Q(G2(:,:,:,502),Q(:,62),MT,G3(:,:,:,237))
  call loop_AS_Q(G3(:,:,:,237),wf(:,0),G3(:,:,:,238),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,238),Q(:,63),MT,G4tensor(:,75))
  call loop_AV_Q(G0(:,:,:,1),wf(:,87),G0(:,:,:,81))
  call loop_A_Q(G0(:,:,:,81),Q(:,26),MT,G1(:,:,:,309))
  call loop_AV_Q(G1(:,:,:,309),wf(:,84),G1(:,:,:,310))
  call loop_A_Q(G1(:,:,:,310),Q(:,62),MT,G2(:,:,:,503))
  call loop_AS_Q(G2(:,:,:,503),wf(:,0),G2(:,:,:,504),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,504),Q(:,63),MT,G3tensor(:,155))
  call loop_AV_Q(G1(:,:,:,309),wf(:,-2),G1(:,:,:,311))
  call loop_A_Q(G1(:,:,:,311),Q(:,30),MT,G2(:,:,:,505))
  call loop_AV_Q(G2(:,:,:,505),wf(:,-5),G2(:,:,:,506))
  call loop_A_Q(G2(:,:,:,506),Q(:,62),MT,G3(:,:,:,239))
  call loop_AS_Q(G3(:,:,:,239),wf(:,0),G3(:,:,:,240),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,240),Q(:,63),MT,G4tensor(:,76))
  call loop_AV_Q(G0(:,:,:,1),wf(:,88),G0(:,:,:,82))
  call loop_A_Q(G0(:,:,:,82),Q(:,26),MT,G1(:,:,:,312))
  call loop_AV_Q(G1(:,:,:,312),wf(:,84),G1(:,:,:,313))
  call loop_A_Q(G1(:,:,:,313),Q(:,62),MT,G2(:,:,:,507))
  call loop_AS_Q(G2(:,:,:,507),wf(:,0),G2(:,:,:,508),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,508),Q(:,63),MT,G3tensor(:,156))
  call loop_AV_Q(G1(:,:,:,312),wf(:,-2),G1(:,:,:,314))
  call loop_A_Q(G1(:,:,:,314),Q(:,30),MT,G2(:,:,:,509))
  call loop_AV_Q(G2(:,:,:,509),wf(:,-5),G2(:,:,:,510))
  call loop_A_Q(G2(:,:,:,510),Q(:,62),MT,G3(:,:,:,241))
  call loop_AS_Q(G3(:,:,:,241),wf(:,0),G3(:,:,:,242),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,242),Q(:,63),MT,G4tensor(:,77))
  call loop_QV_A(G0(:,:,:,1),wf(:,85),G0(:,:,:,83))
  call loop_Q_A(G0(:,:,:,83),Q(:,26),MB,G1(:,:,:,315))
  call loop_QV_A(G1(:,:,:,315),wf(:,84),G1(:,:,:,316))
  call loop_Q_A(G1(:,:,:,316),Q(:,62),MB,G2(:,:,:,511))
  call loop_QS_A(G2(:,:,:,511),wf(:,0),G2(:,:,:,512),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,512),Q(:,63),MB,G3tensor(:,157))
  call loop_QV_A(G1(:,:,:,315),wf(:,-2),G1(:,:,:,317))
  call loop_Q_A(G1(:,:,:,317),Q(:,30),MB,G2(:,:,:,513))
  call loop_QV_A(G2(:,:,:,513),wf(:,-5),G2(:,:,:,514))
  call loop_Q_A(G2(:,:,:,514),Q(:,62),MB,G3(:,:,:,243))
  call loop_QS_A(G3(:,:,:,243),wf(:,0),G3(:,:,:,244),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,244),Q(:,63),MB,G4tensor(:,78))
  call loop_QV_A(G0(:,:,:,1),wf(:,87),G0(:,:,:,84))
  call loop_Q_A(G0(:,:,:,84),Q(:,26),MB,G1(:,:,:,318))
  call loop_QV_A(G1(:,:,:,318),wf(:,84),G1(:,:,:,319))
  call loop_Q_A(G1(:,:,:,319),Q(:,62),MB,G2(:,:,:,515))
  call loop_QS_A(G2(:,:,:,515),wf(:,0),G2(:,:,:,516),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,516),Q(:,63),MB,G3tensor(:,158))
  call loop_QV_A(G1(:,:,:,318),wf(:,-2),G1(:,:,:,320))
  call loop_Q_A(G1(:,:,:,320),Q(:,30),MB,G2(:,:,:,517))
  call loop_QV_A(G2(:,:,:,517),wf(:,-5),G2(:,:,:,518))
  call loop_Q_A(G2(:,:,:,518),Q(:,62),MB,G3(:,:,:,245))
  call loop_QS_A(G3(:,:,:,245),wf(:,0),G3(:,:,:,246),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,246),Q(:,63),MB,G4tensor(:,79))
  call loop_QV_A(G0(:,:,:,1),wf(:,88),G0(:,:,:,85))
  call loop_Q_A(G0(:,:,:,85),Q(:,26),MB,G1(:,:,:,321))
  call loop_QV_A(G1(:,:,:,321),wf(:,84),G1(:,:,:,322))
  call loop_Q_A(G1(:,:,:,322),Q(:,62),MB,G2(:,:,:,519))
  call loop_QS_A(G2(:,:,:,519),wf(:,0),G2(:,:,:,520),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,520),Q(:,63),MB,G3tensor(:,159))
  call loop_QV_A(G1(:,:,:,321),wf(:,-2),G1(:,:,:,323))
  call loop_Q_A(G1(:,:,:,323),Q(:,30),MB,G2(:,:,:,521))
  call loop_QV_A(G2(:,:,:,521),wf(:,-5),G2(:,:,:,522))
  call loop_Q_A(G2(:,:,:,522),Q(:,62),MB,G3(:,:,:,247))
  call loop_QS_A(G3(:,:,:,247),wf(:,0),G3(:,:,:,248),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,248),Q(:,63),MB,G4tensor(:,80))
  call loop_AV_Q(G0(:,:,:,1),wf(:,85),G0(:,:,:,86))
  call loop_A_Q(G0(:,:,:,86),Q(:,26),MB,G1(:,:,:,324))
  call loop_AV_Q(G1(:,:,:,324),wf(:,84),G1(:,:,:,325))
  call loop_A_Q(G1(:,:,:,325),Q(:,62),MB,G2(:,:,:,523))
  call loop_AS_Q(G2(:,:,:,523),wf(:,0),G2(:,:,:,524),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,524),Q(:,63),MB,G3tensor(:,160))
  call loop_AV_Q(G1(:,:,:,324),wf(:,-2),G1(:,:,:,326))
  call loop_A_Q(G1(:,:,:,326),Q(:,30),MB,G2(:,:,:,525))
  call loop_AV_Q(G2(:,:,:,525),wf(:,-5),G2(:,:,:,526))
  call loop_A_Q(G2(:,:,:,526),Q(:,62),MB,G3(:,:,:,249))
  call loop_AS_Q(G3(:,:,:,249),wf(:,0),G3(:,:,:,250),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,250),Q(:,63),MB,G4tensor(:,81))
  call loop_AV_Q(G0(:,:,:,1),wf(:,87),G0(:,:,:,87))
  call loop_A_Q(G0(:,:,:,87),Q(:,26),MB,G1(:,:,:,327))
  call loop_AV_Q(G1(:,:,:,327),wf(:,84),G1(:,:,:,328))
  call loop_A_Q(G1(:,:,:,328),Q(:,62),MB,G2(:,:,:,527))
  call loop_AS_Q(G2(:,:,:,527),wf(:,0),G2(:,:,:,528),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,528),Q(:,63),MB,G3tensor(:,161))
  call loop_AV_Q(G1(:,:,:,327),wf(:,-2),G1(:,:,:,329))
  call loop_A_Q(G1(:,:,:,329),Q(:,30),MB,G2(:,:,:,529))
  call loop_AV_Q(G2(:,:,:,529),wf(:,-5),G2(:,:,:,530))
  call loop_A_Q(G2(:,:,:,530),Q(:,62),MB,G3(:,:,:,251))
  call loop_AS_Q(G3(:,:,:,251),wf(:,0),G3(:,:,:,252),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,252),Q(:,63),MB,G4tensor(:,82))
  call loop_AV_Q(G0(:,:,:,1),wf(:,88),G0(:,:,:,88))
  call loop_A_Q(G0(:,:,:,88),Q(:,26),MB,G1(:,:,:,330))
  call loop_AV_Q(G1(:,:,:,330),wf(:,84),G1(:,:,:,331))
  call loop_A_Q(G1(:,:,:,331),Q(:,62),MB,G2(:,:,:,531))
  call loop_AS_Q(G2(:,:,:,531),wf(:,0),G2(:,:,:,532),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,532),Q(:,63),MB,G3tensor(:,162))
  call loop_AV_Q(G1(:,:,:,330),wf(:,-2),G1(:,:,:,332))
  call loop_A_Q(G1(:,:,:,332),Q(:,30),MB,G2(:,:,:,533))
  call loop_AV_Q(G2(:,:,:,533),wf(:,-5),G2(:,:,:,534))
  call loop_A_Q(G2(:,:,:,534),Q(:,62),MB,G3(:,:,:,253))
  call loop_AS_Q(G3(:,:,:,253),wf(:,0),G3(:,:,:,254),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,254),Q(:,63),MB,G4tensor(:,83))
  call loop_QV_A(G0(:,:,:,1),wf(:,328),G0(:,:,:,89))
  call loop_Q_A(G0(:,:,:,89),Q(:,30),MT,G1(:,:,:,333))
  call loop_QV_A(G1(:,:,:,333),wf(:,-5),G1(:,:,:,334))
  call loop_Q_A(G1(:,:,:,334),Q(:,62),MT,G2(:,:,:,535))
  call loop_QS_A(G2(:,:,:,535),wf(:,0),G2(:,:,:,536),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,536),Q(:,63),MT,G3tensor(:,163))
  call loop_QV_A(G0(:,:,:,1),wf(:,329),G0(:,:,:,90))
  call loop_Q_A(G0(:,:,:,90),Q(:,30),MT,G1(:,:,:,335))
  call loop_QV_A(G1(:,:,:,335),wf(:,-5),G1(:,:,:,336))
  call loop_Q_A(G1(:,:,:,336),Q(:,62),MT,G2(:,:,:,537))
  call loop_QS_A(G2(:,:,:,537),wf(:,0),G2(:,:,:,538),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,538),Q(:,63),MT,G3tensor(:,164))
  call loop_QV_A(G0(:,:,:,1),wf(:,330),G0(:,:,:,91))
  call loop_Q_A(G0(:,:,:,91),Q(:,30),MT,G1(:,:,:,337))
  call loop_QV_A(G1(:,:,:,337),wf(:,-5),G1(:,:,:,338))
  call loop_Q_A(G1(:,:,:,338),Q(:,62),MT,G2(:,:,:,539))
  call loop_QS_A(G2(:,:,:,539),wf(:,0),G2(:,:,:,540),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,540),Q(:,63),MT,G3tensor(:,165))
  call loop_AV_Q(G0(:,:,:,1),wf(:,328),G0(:,:,:,92))
  call loop_A_Q(G0(:,:,:,92),Q(:,30),MT,G1(:,:,:,339))
  call loop_AV_Q(G1(:,:,:,339),wf(:,-5),G1(:,:,:,340))
  call loop_A_Q(G1(:,:,:,340),Q(:,62),MT,G2(:,:,:,541))
  call loop_AS_Q(G2(:,:,:,541),wf(:,0),G2(:,:,:,542),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,542),Q(:,63),MT,G3tensor(:,166))
  call loop_AV_Q(G0(:,:,:,1),wf(:,329),G0(:,:,:,93))
  call loop_A_Q(G0(:,:,:,93),Q(:,30),MT,G1(:,:,:,341))
  call loop_AV_Q(G1(:,:,:,341),wf(:,-5),G1(:,:,:,342))
  call loop_A_Q(G1(:,:,:,342),Q(:,62),MT,G2(:,:,:,543))
  call loop_AS_Q(G2(:,:,:,543),wf(:,0),G2(:,:,:,544),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,544),Q(:,63),MT,G3tensor(:,167))
  call loop_AV_Q(G0(:,:,:,1),wf(:,330),G0(:,:,:,94))
  call loop_A_Q(G0(:,:,:,94),Q(:,30),MT,G1(:,:,:,343))
  call loop_AV_Q(G1(:,:,:,343),wf(:,-5),G1(:,:,:,344))
  call loop_A_Q(G1(:,:,:,344),Q(:,62),MT,G2(:,:,:,545))
  call loop_AS_Q(G2(:,:,:,545),wf(:,0),G2(:,:,:,546),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,546),Q(:,63),MT,G3tensor(:,168))
  call loop_QV_A(G0(:,:,:,1),wf(:,328),G0(:,:,:,95))
  call loop_Q_A(G0(:,:,:,95),Q(:,30),MB,G1(:,:,:,345))
  call loop_QV_A(G1(:,:,:,345),wf(:,-5),G1(:,:,:,346))
  call loop_Q_A(G1(:,:,:,346),Q(:,62),MB,G2(:,:,:,547))
  call loop_QS_A(G2(:,:,:,547),wf(:,0),G2(:,:,:,548),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,548),Q(:,63),MB,G3tensor(:,169))
  call loop_QV_A(G0(:,:,:,1),wf(:,329),G0(:,:,:,96))
  call loop_Q_A(G0(:,:,:,96),Q(:,30),MB,G1(:,:,:,347))
  call loop_QV_A(G1(:,:,:,347),wf(:,-5),G1(:,:,:,348))
  call loop_Q_A(G1(:,:,:,348),Q(:,62),MB,G2(:,:,:,549))
  call loop_QS_A(G2(:,:,:,549),wf(:,0),G2(:,:,:,550),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,550),Q(:,63),MB,G3tensor(:,170))
  call loop_QV_A(G0(:,:,:,1),wf(:,330),G0(:,:,:,97))
  call loop_Q_A(G0(:,:,:,97),Q(:,30),MB,G1(:,:,:,349))
  call loop_QV_A(G1(:,:,:,349),wf(:,-5),G1(:,:,:,350))
  call loop_Q_A(G1(:,:,:,350),Q(:,62),MB,G2(:,:,:,551))
  call loop_QS_A(G2(:,:,:,551),wf(:,0),G2(:,:,:,552),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,552),Q(:,63),MB,G3tensor(:,171))
  call loop_AV_Q(G0(:,:,:,1),wf(:,328),G0(:,:,:,98))
  call loop_A_Q(G0(:,:,:,98),Q(:,30),MB,G1(:,:,:,351))
  call loop_AV_Q(G1(:,:,:,351),wf(:,-5),G1(:,:,:,352))
  call loop_A_Q(G1(:,:,:,352),Q(:,62),MB,G2(:,:,:,553))
  call loop_AS_Q(G2(:,:,:,553),wf(:,0),G2(:,:,:,554),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,554),Q(:,63),MB,G3tensor(:,172))
  call loop_AV_Q(G0(:,:,:,1),wf(:,329),G0(:,:,:,99))
  call loop_A_Q(G0(:,:,:,99),Q(:,30),MB,G1(:,:,:,353))
  call loop_AV_Q(G1(:,:,:,353),wf(:,-5),G1(:,:,:,354))
  call loop_A_Q(G1(:,:,:,354),Q(:,62),MB,G2(:,:,:,555))
  call loop_AS_Q(G2(:,:,:,555),wf(:,0),G2(:,:,:,556),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,556),Q(:,63),MB,G3tensor(:,173))
  call loop_AV_Q(G0(:,:,:,1),wf(:,330),G0(:,:,:,100))
  call loop_A_Q(G0(:,:,:,100),Q(:,30),MB,G1(:,:,:,355))
  call loop_AV_Q(G1(:,:,:,355),wf(:,-5),G1(:,:,:,356))
  call loop_A_Q(G1(:,:,:,356),Q(:,62),MB,G2(:,:,:,557))
  call loop_AS_Q(G2(:,:,:,557),wf(:,0),G2(:,:,:,558),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,558),Q(:,63),MB,G3tensor(:,174))
  call loop_QV_A(G0(:,:,:,1),wf(:,334),G0(:,:,:,101))
  call loop_Q_A(G0(:,:,:,101),Q(:,30),MT,G1(:,:,:,357))
  call loop_QV_A(G1(:,:,:,357),wf(:,-5),G1(:,:,:,358))
  call loop_Q_A(G1(:,:,:,358),Q(:,62),MT,G2(:,:,:,559))
  call loop_QS_A(G2(:,:,:,559),wf(:,0),G2(:,:,:,560),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,560),Q(:,63),MT,G3tensor(:,175))
  call loop_QV_A(G0(:,:,:,1),wf(:,335),G0(:,:,:,102))
  call loop_Q_A(G0(:,:,:,102),Q(:,30),MT,G1(:,:,:,359))
  call loop_QV_A(G1(:,:,:,359),wf(:,-5),G1(:,:,:,360))
  call loop_Q_A(G1(:,:,:,360),Q(:,62),MT,G2(:,:,:,561))
  call loop_QS_A(G2(:,:,:,561),wf(:,0),G2(:,:,:,562),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,562),Q(:,63),MT,G3tensor(:,176))
  call loop_QV_A(G0(:,:,:,1),wf(:,336),G0(:,:,:,103))
  call loop_Q_A(G0(:,:,:,103),Q(:,30),MT,G1(:,:,:,361))
  call loop_QV_A(G1(:,:,:,361),wf(:,-5),G1(:,:,:,362))
  call loop_Q_A(G1(:,:,:,362),Q(:,62),MT,G2(:,:,:,563))
  call loop_QS_A(G2(:,:,:,563),wf(:,0),G2(:,:,:,564),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,564),Q(:,63),MT,G3tensor(:,177))
  call loop_AV_Q(G0(:,:,:,1),wf(:,334),G0(:,:,:,104))
  call loop_A_Q(G0(:,:,:,104),Q(:,30),MT,G1(:,:,:,363))
  call loop_AV_Q(G1(:,:,:,363),wf(:,-5),G1(:,:,:,364))
  call loop_A_Q(G1(:,:,:,364),Q(:,62),MT,G2(:,:,:,565))
  call loop_AS_Q(G2(:,:,:,565),wf(:,0),G2(:,:,:,566),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,566),Q(:,63),MT,G3tensor(:,178))
  call loop_AV_Q(G0(:,:,:,1),wf(:,335),G0(:,:,:,105))
  call loop_A_Q(G0(:,:,:,105),Q(:,30),MT,G1(:,:,:,365))
  call loop_AV_Q(G1(:,:,:,365),wf(:,-5),G1(:,:,:,366))
  call loop_A_Q(G1(:,:,:,366),Q(:,62),MT,G2(:,:,:,567))
  call loop_AS_Q(G2(:,:,:,567),wf(:,0),G2(:,:,:,568),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,568),Q(:,63),MT,G3tensor(:,179))
  call loop_AV_Q(G0(:,:,:,1),wf(:,336),G0(:,:,:,106))
  call loop_A_Q(G0(:,:,:,106),Q(:,30),MT,G1(:,:,:,367))
  call loop_AV_Q(G1(:,:,:,367),wf(:,-5),G1(:,:,:,368))
  call loop_A_Q(G1(:,:,:,368),Q(:,62),MT,G2(:,:,:,569))
  call loop_AS_Q(G2(:,:,:,569),wf(:,0),G2(:,:,:,570),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,570),Q(:,63),MT,G3tensor(:,180))
  call loop_QV_A(G0(:,:,:,1),wf(:,334),G0(:,:,:,107))
  call loop_Q_A(G0(:,:,:,107),Q(:,30),MB,G1(:,:,:,369))
  call loop_QV_A(G1(:,:,:,369),wf(:,-5),G1(:,:,:,370))
  call loop_Q_A(G1(:,:,:,370),Q(:,62),MB,G2(:,:,:,571))
  call loop_QS_A(G2(:,:,:,571),wf(:,0),G2(:,:,:,572),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,572),Q(:,63),MB,G3tensor(:,181))
  call loop_QV_A(G0(:,:,:,1),wf(:,335),G0(:,:,:,108))
  call loop_Q_A(G0(:,:,:,108),Q(:,30),MB,G1(:,:,:,371))
  call loop_QV_A(G1(:,:,:,371),wf(:,-5),G1(:,:,:,372))
  call loop_Q_A(G1(:,:,:,372),Q(:,62),MB,G2(:,:,:,573))
  call loop_QS_A(G2(:,:,:,573),wf(:,0),G2(:,:,:,574),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,574),Q(:,63),MB,G3tensor(:,182))
  call loop_QV_A(G0(:,:,:,1),wf(:,336),G0(:,:,:,109))
  call loop_Q_A(G0(:,:,:,109),Q(:,30),MB,G1(:,:,:,373))
  call loop_QV_A(G1(:,:,:,373),wf(:,-5),G1(:,:,:,374))
  call loop_Q_A(G1(:,:,:,374),Q(:,62),MB,G2(:,:,:,575))
  call loop_QS_A(G2(:,:,:,575),wf(:,0),G2(:,:,:,576),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,576),Q(:,63),MB,G3tensor(:,183))
  call loop_AV_Q(G0(:,:,:,1),wf(:,334),G0(:,:,:,110))
  call loop_A_Q(G0(:,:,:,110),Q(:,30),MB,G1(:,:,:,375))
  call loop_AV_Q(G1(:,:,:,375),wf(:,-5),G1(:,:,:,376))
  call loop_A_Q(G1(:,:,:,376),Q(:,62),MB,G2(:,:,:,577))
  call loop_AS_Q(G2(:,:,:,577),wf(:,0),G2(:,:,:,578),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,578),Q(:,63),MB,G3tensor(:,184))
  call loop_AV_Q(G0(:,:,:,1),wf(:,335),G0(:,:,:,111))
  call loop_A_Q(G0(:,:,:,111),Q(:,30),MB,G1(:,:,:,377))
  call loop_AV_Q(G1(:,:,:,377),wf(:,-5),G1(:,:,:,378))
  call loop_A_Q(G1(:,:,:,378),Q(:,62),MB,G2(:,:,:,579))
  call loop_AS_Q(G2(:,:,:,579),wf(:,0),G2(:,:,:,580),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,580),Q(:,63),MB,G3tensor(:,185))
  call loop_AV_Q(G0(:,:,:,1),wf(:,336),G0(:,:,:,112))
  call loop_A_Q(G0(:,:,:,112),Q(:,30),MB,G1(:,:,:,379))
  call loop_AV_Q(G1(:,:,:,379),wf(:,-5),G1(:,:,:,380))
  call loop_A_Q(G1(:,:,:,380),Q(:,62),MB,G2(:,:,:,581))
  call loop_AS_Q(G2(:,:,:,581),wf(:,0),G2(:,:,:,582),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,582),Q(:,63),MB,G3tensor(:,186))
  call loop_AV_Q(G0(:,:,:,1),wf(:,101),G0(:,:,:,113))
  call loop_A_Q(G0(:,:,:,113),Q(:,24),MT,G1(:,:,:,381))
  call loop_AV_Q(G1(:,:,:,381),wf(:,102),G1(:,:,:,382))
  call loop_A_Q(G1(:,:,:,382),Q(:,62),MT,G2(:,:,:,583))
  call loop_AS_Q(G2(:,:,:,583),wf(:,0),G2(:,:,:,584),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,584),Q(:,63),MT,G3tensor(:,187))
  call loop_AV_Q(G1(:,:,:,381),wf(:,104),G1(:,:,:,383))
  call loop_A_Q(G1(:,:,:,383),Q(:,62),MT,G2(:,:,:,585))
  call loop_AS_Q(G2(:,:,:,585),wf(:,0),G2(:,:,:,586),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,586),Q(:,63),MT,G3tensor(:,188))
  call loop_AV_Q(G1(:,:,:,381),wf(:,105),G1(:,:,:,384))
  call loop_A_Q(G1(:,:,:,384),Q(:,62),MT,G2(:,:,:,587))
  call loop_AS_Q(G2(:,:,:,587),wf(:,0),G2(:,:,:,588),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,588),Q(:,63),MT,G3tensor(:,189))
  call loop_AV_Q(G1(:,:,:,381),wf(:,167),G1(:,:,:,385))
  call loop_A_Q(G1(:,:,:,385),Q(:,62),MT,G2(:,:,:,589))
  call loop_AS_Q(G2(:,:,:,589),wf(:,0),G2(:,:,:,590),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,590),Q(:,63),MT,G3tensor(:,190))
  call loop_AV_Q(G1(:,:,:,381),wf(:,1),G1(:,:,:,386))
  call loop_A_Q(G1(:,:,:,386),Q(:,30),MT,G2(:,:,:,591))
  call loop_AV_Q(G2(:,:,:,591),wf(:,-5),G2(:,:,:,592))
  call loop_A_Q(G2(:,:,:,592),Q(:,62),MT,G3(:,:,:,255))
  call loop_AS_Q(G3(:,:,:,255),wf(:,0),G3(:,:,:,256),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,256),Q(:,63),MT,G4tensor(:,84))
  call loop_AV_Q(G1(:,:,:,381),wf(:,200),G1(:,:,:,387))
  call loop_A_Q(G1(:,:,:,387),Q(:,62),MT,G2(:,:,:,593))
  call loop_AS_Q(G2(:,:,:,593),wf(:,0),G2(:,:,:,594),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,594),Q(:,63),MT,G3tensor(:,191))
  call loop_AV_Q(G1(:,:,:,381),wf(:,-2),G1(:,:,:,388))
  call loop_A_Q(G1(:,:,:,388),Q(:,28),MT,G2(:,:,:,595))
  call loop_AV_Q(G2(:,:,:,595),wf(:,37),G2(:,:,:,596))
  call loop_A_Q(G2(:,:,:,596),Q(:,62),MT,G3(:,:,:,257))
  call loop_AS_Q(G3(:,:,:,257),wf(:,0),G3(:,:,:,258),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,258),Q(:,63),MT,G4tensor(:,85))
  call loop_AV_Q(G2(:,:,:,595),wf(:,-1),G2(:,:,:,597))
  call loop_A_Q(G2(:,:,:,597),Q(:,30),MT,G3(:,:,:,259))
  call loop_AV_Q(G3(:,:,:,259),wf(:,-5),G3(:,:,:,260))
  call loop_A_Q(G3(:,:,:,260),Q(:,62),MT,G4(:,:,:,89))
  call loop_AS_Q(G4(:,:,:,89),wf(:,0),G4(:,:,:,90),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,90),Q(:,63),MT,G5tensor(:,45))
  call loop_AV_Q(G1(:,:,:,381),wf(:,202),G1(:,:,:,389))
  call loop_A_Q(G1(:,:,:,389),Q(:,62),MT,G2(:,:,:,598))
  call loop_AS_Q(G2(:,:,:,598),wf(:,0),G2(:,:,:,599),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,599),Q(:,63),MT,G3tensor(:,192))
  call loop_AV_Q(G1(:,:,:,381),wf(:,-1),G1(:,:,:,390))
  call loop_A_Q(G1(:,:,:,390),Q(:,26),MT,G2(:,:,:,600))
  call loop_AV_Q(G2(:,:,:,600),wf(:,84),G2(:,:,:,601))
  call loop_A_Q(G2(:,:,:,601),Q(:,62),MT,G3(:,:,:,261))
  call loop_AS_Q(G3(:,:,:,261),wf(:,0),G3(:,:,:,262),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,262),Q(:,63),MT,G4tensor(:,86))
  call loop_AV_Q(G2(:,:,:,600),wf(:,-2),G2(:,:,:,602))
  call loop_A_Q(G2(:,:,:,602),Q(:,30),MT,G3(:,:,:,263))
  call loop_AV_Q(G3(:,:,:,263),wf(:,-5),G3(:,:,:,264))
  call loop_A_Q(G3(:,:,:,264),Q(:,62),MT,G4(:,:,:,91))
  call loop_AS_Q(G4(:,:,:,91),wf(:,0),G4(:,:,:,92),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,92),Q(:,63),MT,G5tensor(:,46))
  call loop_QV_A(G0(:,:,:,1),wf(:,101),G0(:,:,:,114))
  call loop_Q_A(G0(:,:,:,114),Q(:,24),MT,G1(:,:,:,391))
  call loop_QV_A(G1(:,:,:,391),wf(:,102),G1(:,:,:,392))
  call loop_Q_A(G1(:,:,:,392),Q(:,62),MT,G2(:,:,:,603))
  call loop_QS_A(G2(:,:,:,603),wf(:,0),G2(:,:,:,604),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,604),Q(:,63),MT,G3tensor(:,193))
  call loop_QV_A(G1(:,:,:,391),wf(:,104),G1(:,:,:,393))
  call loop_Q_A(G1(:,:,:,393),Q(:,62),MT,G2(:,:,:,605))
  call loop_QS_A(G2(:,:,:,605),wf(:,0),G2(:,:,:,606),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,606),Q(:,63),MT,G3tensor(:,194))
  call loop_QV_A(G1(:,:,:,391),wf(:,105),G1(:,:,:,394))
  call loop_Q_A(G1(:,:,:,394),Q(:,62),MT,G2(:,:,:,607))
  call loop_QS_A(G2(:,:,:,607),wf(:,0),G2(:,:,:,608),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,608),Q(:,63),MT,G3tensor(:,195))
  call loop_QV_A(G1(:,:,:,391),wf(:,167),G1(:,:,:,395))
  call loop_Q_A(G1(:,:,:,395),Q(:,62),MT,G2(:,:,:,609))
  call loop_QS_A(G2(:,:,:,609),wf(:,0),G2(:,:,:,610),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,610),Q(:,63),MT,G3tensor(:,196))
  call loop_QV_A(G1(:,:,:,391),wf(:,1),G1(:,:,:,396))
  call loop_Q_A(G1(:,:,:,396),Q(:,30),MT,G2(:,:,:,611))
  call loop_QV_A(G2(:,:,:,611),wf(:,-5),G2(:,:,:,612))
  call loop_Q_A(G2(:,:,:,612),Q(:,62),MT,G3(:,:,:,265))
  call loop_QS_A(G3(:,:,:,265),wf(:,0),G3(:,:,:,266),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,266),Q(:,63),MT,G4tensor(:,87))
  call loop_QV_A(G1(:,:,:,391),wf(:,200),G1(:,:,:,397))
  call loop_Q_A(G1(:,:,:,397),Q(:,62),MT,G2(:,:,:,613))
  call loop_QS_A(G2(:,:,:,613),wf(:,0),G2(:,:,:,614),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,614),Q(:,63),MT,G3tensor(:,197))
  call loop_QV_A(G1(:,:,:,391),wf(:,-2),G1(:,:,:,398))
  call loop_Q_A(G1(:,:,:,398),Q(:,28),MT,G2(:,:,:,615))
  call loop_QV_A(G2(:,:,:,615),wf(:,37),G2(:,:,:,616))
  call loop_Q_A(G2(:,:,:,616),Q(:,62),MT,G3(:,:,:,267))
  call loop_QS_A(G3(:,:,:,267),wf(:,0),G3(:,:,:,268),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,268),Q(:,63),MT,G4tensor(:,88))
  call loop_QV_A(G2(:,:,:,615),wf(:,-1),G2(:,:,:,617))
  call loop_Q_A(G2(:,:,:,617),Q(:,30),MT,G3(:,:,:,269))
  call loop_QV_A(G3(:,:,:,269),wf(:,-5),G3(:,:,:,270))
  call loop_Q_A(G3(:,:,:,270),Q(:,62),MT,G4(:,:,:,93))
  call loop_QS_A(G4(:,:,:,93),wf(:,0),G4(:,:,:,94),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,94),Q(:,63),MT,G5tensor(:,47))
  call loop_QV_A(G1(:,:,:,391),wf(:,202),G1(:,:,:,399))
  call loop_Q_A(G1(:,:,:,399),Q(:,62),MT,G2(:,:,:,618))
  call loop_QS_A(G2(:,:,:,618),wf(:,0),G2(:,:,:,619),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,619),Q(:,63),MT,G3tensor(:,198))
  call loop_QV_A(G1(:,:,:,391),wf(:,-1),G1(:,:,:,400))
  call loop_Q_A(G1(:,:,:,400),Q(:,26),MT,G2(:,:,:,620))
  call loop_QV_A(G2(:,:,:,620),wf(:,84),G2(:,:,:,621))
  call loop_Q_A(G2(:,:,:,621),Q(:,62),MT,G3(:,:,:,271))
  call loop_QS_A(G3(:,:,:,271),wf(:,0),G3(:,:,:,272),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,272),Q(:,63),MT,G4tensor(:,89))
  call loop_QV_A(G2(:,:,:,620),wf(:,-2),G2(:,:,:,622))
  call loop_Q_A(G2(:,:,:,622),Q(:,30),MT,G3(:,:,:,273))
  call loop_QV_A(G3(:,:,:,273),wf(:,-5),G3(:,:,:,274))
  call loop_Q_A(G3(:,:,:,274),Q(:,62),MT,G4(:,:,:,95))
  call loop_QS_A(G4(:,:,:,95),wf(:,0),G4(:,:,:,96),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,96),Q(:,63),MT,G5tensor(:,48))
  call loop_AV_Q(G0(:,:,:,1),wf(:,101),G0(:,:,:,115))
  call loop_A_Q(G0(:,:,:,115),Q(:,24),MB,G1(:,:,:,401))
  call loop_AV_Q(G1(:,:,:,401),wf(:,102),G1(:,:,:,402))
  call loop_A_Q(G1(:,:,:,402),Q(:,62),MB,G2(:,:,:,623))
  call loop_AS_Q(G2(:,:,:,623),wf(:,0),G2(:,:,:,624),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,624),Q(:,63),MB,G3tensor(:,199))
  call loop_AV_Q(G1(:,:,:,401),wf(:,104),G1(:,:,:,403))
  call loop_A_Q(G1(:,:,:,403),Q(:,62),MB,G2(:,:,:,625))
  call loop_AS_Q(G2(:,:,:,625),wf(:,0),G2(:,:,:,626),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,626),Q(:,63),MB,G3tensor(:,200))
  call loop_AV_Q(G1(:,:,:,401),wf(:,105),G1(:,:,:,404))
  call loop_A_Q(G1(:,:,:,404),Q(:,62),MB,G2(:,:,:,627))
  call loop_AS_Q(G2(:,:,:,627),wf(:,0),G2(:,:,:,628),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,628),Q(:,63),MB,G3tensor(:,201))
  call loop_AV_Q(G1(:,:,:,401),wf(:,167),G1(:,:,:,405))
  call loop_A_Q(G1(:,:,:,405),Q(:,62),MB,G2(:,:,:,629))
  call loop_AS_Q(G2(:,:,:,629),wf(:,0),G2(:,:,:,630),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,630),Q(:,63),MB,G3tensor(:,202))
  call loop_AV_Q(G1(:,:,:,401),wf(:,1),G1(:,:,:,406))
  call loop_A_Q(G1(:,:,:,406),Q(:,30),MB,G2(:,:,:,631))
  call loop_AV_Q(G2(:,:,:,631),wf(:,-5),G2(:,:,:,632))
  call loop_A_Q(G2(:,:,:,632),Q(:,62),MB,G3(:,:,:,275))
  call loop_AS_Q(G3(:,:,:,275),wf(:,0),G3(:,:,:,276),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,276),Q(:,63),MB,G4tensor(:,90))
  call loop_AV_Q(G1(:,:,:,401),wf(:,200),G1(:,:,:,407))
  call loop_A_Q(G1(:,:,:,407),Q(:,62),MB,G2(:,:,:,633))
  call loop_AS_Q(G2(:,:,:,633),wf(:,0),G2(:,:,:,634),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,634),Q(:,63),MB,G3tensor(:,203))
  call loop_AV_Q(G1(:,:,:,401),wf(:,-2),G1(:,:,:,408))
  call loop_A_Q(G1(:,:,:,408),Q(:,28),MB,G2(:,:,:,635))
  call loop_AV_Q(G2(:,:,:,635),wf(:,37),G2(:,:,:,636))
  call loop_A_Q(G2(:,:,:,636),Q(:,62),MB,G3(:,:,:,277))
  call loop_AS_Q(G3(:,:,:,277),wf(:,0),G3(:,:,:,278),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,278),Q(:,63),MB,G4tensor(:,91))
  call loop_AV_Q(G2(:,:,:,635),wf(:,-1),G2(:,:,:,637))
  call loop_A_Q(G2(:,:,:,637),Q(:,30),MB,G3(:,:,:,279))
  call loop_AV_Q(G3(:,:,:,279),wf(:,-5),G3(:,:,:,280))
  call loop_A_Q(G3(:,:,:,280),Q(:,62),MB,G4(:,:,:,97))
  call loop_AS_Q(G4(:,:,:,97),wf(:,0),G4(:,:,:,98),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,98),Q(:,63),MB,G5tensor(:,49))
  call loop_AV_Q(G1(:,:,:,401),wf(:,202),G1(:,:,:,409))
  call loop_A_Q(G1(:,:,:,409),Q(:,62),MB,G2(:,:,:,638))
  call loop_AS_Q(G2(:,:,:,638),wf(:,0),G2(:,:,:,639),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,639),Q(:,63),MB,G3tensor(:,204))
  call loop_AV_Q(G1(:,:,:,401),wf(:,-1),G1(:,:,:,410))
  call loop_A_Q(G1(:,:,:,410),Q(:,26),MB,G2(:,:,:,640))
  call loop_AV_Q(G2(:,:,:,640),wf(:,84),G2(:,:,:,641))
  call loop_A_Q(G2(:,:,:,641),Q(:,62),MB,G3(:,:,:,281))
  call loop_AS_Q(G3(:,:,:,281),wf(:,0),G3(:,:,:,282),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,282),Q(:,63),MB,G4tensor(:,92))
  call loop_AV_Q(G2(:,:,:,640),wf(:,-2),G2(:,:,:,642))
  call loop_A_Q(G2(:,:,:,642),Q(:,30),MB,G3(:,:,:,283))
  call loop_AV_Q(G3(:,:,:,283),wf(:,-5),G3(:,:,:,284))
  call loop_A_Q(G3(:,:,:,284),Q(:,62),MB,G4(:,:,:,99))
  call loop_AS_Q(G4(:,:,:,99),wf(:,0),G4(:,:,:,100),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,100),Q(:,63),MB,G5tensor(:,50))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(4) = M(4) + (-(CI*f(5)) * den(12)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,1),T3sum(1:35,13))
  M(7) = M(7) + (CI*f(5) * den(12)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,1),T3sum(1:35,13))
  M(9) = M(9) + (-(CI*f(5)) * den(12)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,1),T3sum(1:35,13))
  M(11) = M(11) + (-(CI*f(5)) * den(12)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,1),T3sum(1:35,13))
  M(12) = M(12) + (CI*f(5) * den(12)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,1),T3sum(1:35,13))
  M(14) = M(14) + (CI*f(5) * den(12)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,1),T3sum(1:35,13))
  M(20) = M(20) + (CI*f(5) * den(12)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,1),T3sum(1:35,13))
  M(23) = M(23) + (-(CI*f(5)) * den(12)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,1),T3sum(1:35,13))
  M(4) = M(4) + (CI*f(5) * den(12)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,2),T3sum(1:35,13))
  M(6) = M(6) + (-(CI*f(5)) * den(12)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,2),T3sum(1:35,13))
  M(7) = M(7) + (-(CI*f(5)) * den(12)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,2),T3sum(1:35,13))
  M(8) = M(8) + (CI*f(5) * den(12)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,2),T3sum(1:35,13))
  M(10) = M(10) + (CI*f(5) * den(12)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,2),T3sum(1:35,13))
  M(12) = M(12) + (-(CI*f(5)) * den(12)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,2),T3sum(1:35,13))
  M(17) = M(17) + (-(CI*f(5)) * den(12)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,2),T3sum(1:35,13))
  M(23) = M(23) + (CI*f(5) * den(12)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,2),T3sum(1:35,13))
  M(6) = M(6) + (CI*f(5) * den(12)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,3),T3sum(1:35,13))
  M(8) = M(8) + (-(CI*f(5)) * den(12)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,3),T3sum(1:35,13))
  M(9) = M(9) + (CI*f(5) * den(12)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,3),T3sum(1:35,13))
  M(10) = M(10) + (-(CI*f(5)) * den(12)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,3),T3sum(1:35,13))
  M(11) = M(11) + (CI*f(5) * den(12)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,3),T3sum(1:35,13))
  M(14) = M(14) + (-(CI*f(5)) * den(12)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,3),T3sum(1:35,13))
  M(17) = M(17) + (CI*f(5) * den(12)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,3),T3sum(1:35,13))
  M(20) = M(20) + (-(CI*f(5)) * den(12)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,3),T3sum(1:35,13))
  M(4) = M(4) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,7),T3sum(1:35,14))
  M(7) = M(7) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,7),T3sum(1:35,14))
  M(9) = M(9) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,7),T3sum(1:35,14))
  M(11) = M(11) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,7),T3sum(1:35,14))
  M(12) = M(12) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,7),T3sum(1:35,14))
  M(14) = M(14) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,7),T3sum(1:35,14))
  M(20) = M(20) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,7),T3sum(1:35,14))
  M(23) = M(23) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,7),T3sum(1:35,14))
  M(4) = M(4) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,8),T3sum(1:35,14))
  M(6) = M(6) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,8),T3sum(1:35,14))
  M(7) = M(7) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,8),T3sum(1:35,14))
  M(8) = M(8) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,8),T3sum(1:35,14))
  M(10) = M(10) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,8),T3sum(1:35,14))
  M(12) = M(12) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,8),T3sum(1:35,14))
  M(17) = M(17) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,8),T3sum(1:35,14))
  M(23) = M(23) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,8),T3sum(1:35,14))
  M(6) = M(6) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,9),T3sum(1:35,14))
  M(8) = M(8) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,9),T3sum(1:35,14))
  M(9) = M(9) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,9),T3sum(1:35,14))
  M(10) = M(10) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,9),T3sum(1:35,14))
  M(11) = M(11) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,9),T3sum(1:35,14))
  M(14) = M(14) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,9),T3sum(1:35,14))
  M(17) = M(17) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,9),T3sum(1:35,14))
  M(20) = M(20) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,9),T3sum(1:35,14))
  M(4) = M(4) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,13),T3sum(1:35,14))
  M(7) = M(7) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,13),T3sum(1:35,14))
  M(9) = M(9) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,13),T3sum(1:35,14))
  M(11) = M(11) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,13),T3sum(1:35,14))
  M(12) = M(12) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,13),T3sum(1:35,14))
  M(14) = M(14) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,13),T3sum(1:35,14))
  M(20) = M(20) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,13),T3sum(1:35,14))
  M(23) = M(23) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,13),T3sum(1:35,14))
  M(4) = M(4) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,14),T3sum(1:35,14))
  M(6) = M(6) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,14),T3sum(1:35,14))
  M(7) = M(7) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,14),T3sum(1:35,14))
  M(8) = M(8) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,14),T3sum(1:35,14))
  M(10) = M(10) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,14),T3sum(1:35,14))
  M(12) = M(12) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,14),T3sum(1:35,14))
  M(17) = M(17) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,14),T3sum(1:35,14))
  M(23) = M(23) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,14),T3sum(1:35,14))
  M(6) = M(6) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,15),T3sum(1:35,14))
  M(8) = M(8) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,15),T3sum(1:35,14))
  M(9) = M(9) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,15),T3sum(1:35,14))
  M(10) = M(10) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,15),T3sum(1:35,14))
  M(11) = M(11) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,15),T3sum(1:35,14))
  M(14) = M(14) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,15),T3sum(1:35,14))
  M(17) = M(17) + (CI*f(2) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,15),T3sum(1:35,14))
  M(20) = M(20) + (-(CI*f(2)) * den(12)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,15),T3sum(1:35,14))
  M(2) = M(2) + (CI*f(5) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,19),T3sum(1:35,5))
  M(8) = M(8) + (-(CI*f(5)) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,19),T3sum(1:35,5))
  M(13) = M(13) + (-(CI*f(5)) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,19),T3sum(1:35,5))
  M(15) = M(15) + (CI*f(5) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,19),T3sum(1:35,5))
  M(17) = M(17) + (CI*f(5) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,19),T3sum(1:35,5))
  M(18) = M(18) + (-(CI*f(5)) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,19),T3sum(1:35,5))
  M(19) = M(19) + (-(CI*f(5)) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,19),T3sum(1:35,5))
  M(21) = M(21) + (CI*f(5) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,19),T3sum(1:35,5))
  M(5) = M(5) + (-(CI*f(5)) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,20),T3sum(1:35,5))
  M(8) = M(8) + (CI*f(5) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,20),T3sum(1:35,5))
  M(11) = M(11) + (-(CI*f(5)) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,20),T3sum(1:35,5))
  M(14) = M(14) + (CI*f(5) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,20),T3sum(1:35,5))
  M(15) = M(15) + (-(CI*f(5)) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,20),T3sum(1:35,5))
  M(16) = M(16) + (CI*f(5) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,20),T3sum(1:35,5))
  M(17) = M(17) + (-(CI*f(5)) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,20),T3sum(1:35,5))
  M(19) = M(19) + (CI*f(5) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,20),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(5)) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,21),T3sum(1:35,5))
  M(5) = M(5) + (CI*f(5) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,21),T3sum(1:35,5))
  M(11) = M(11) + (CI*f(5) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,21),T3sum(1:35,5))
  M(13) = M(13) + (CI*f(5) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,21),T3sum(1:35,5))
  M(14) = M(14) + (-(CI*f(5)) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,21),T3sum(1:35,5))
  M(16) = M(16) + (-(CI*f(5)) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,21),T3sum(1:35,5))
  M(18) = M(18) + (CI*f(5) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,21),T3sum(1:35,5))
  M(21) = M(21) + (-(CI*f(5)) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,21),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(5) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,22),T3sum(1:35,5))
  M(8) = M(8) + (-(CI*f(5)) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,22),T3sum(1:35,5))
  M(13) = M(13) + (-(CI*f(5)) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,22),T3sum(1:35,5))
  M(15) = M(15) + (CI*f(5) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,22),T3sum(1:35,5))
  M(17) = M(17) + (CI*f(5) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,22),T3sum(1:35,5))
  M(18) = M(18) + (-(CI*f(5)) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,22),T3sum(1:35,5))
  M(19) = M(19) + (-(CI*f(5)) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,22),T3sum(1:35,5))
  M(21) = M(21) + (CI*f(5) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,22),T3sum(1:35,5))
  M(5) = M(5) + (-(CI*f(5)) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,23),T3sum(1:35,5))
  M(8) = M(8) + (CI*f(5) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,23),T3sum(1:35,5))
  M(11) = M(11) + (-(CI*f(5)) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,23),T3sum(1:35,5))
  M(14) = M(14) + (CI*f(5) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,23),T3sum(1:35,5))
  M(15) = M(15) + (-(CI*f(5)) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,23),T3sum(1:35,5))
  M(16) = M(16) + (CI*f(5) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,23),T3sum(1:35,5))
  M(17) = M(17) + (-(CI*f(5)) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,23),T3sum(1:35,5))
  M(19) = M(19) + (CI*f(5) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,23),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(5)) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,24),T3sum(1:35,5))
  M(5) = M(5) + (CI*f(5) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,24),T3sum(1:35,5))
  M(11) = M(11) + (CI*f(5) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,24),T3sum(1:35,5))
  M(13) = M(13) + (CI*f(5) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,24),T3sum(1:35,5))
  M(14) = M(14) + (-(CI*f(5)) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,24),T3sum(1:35,5))
  M(16) = M(16) + (-(CI*f(5)) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,24),T3sum(1:35,5))
  M(18) = M(18) + (CI*f(5) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,24),T3sum(1:35,5))
  M(21) = M(21) + (-(CI*f(5)) * den(269)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,24),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,25),T3sum(1:35,6))
  M(8) = M(8) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,25),T3sum(1:35,6))
  M(13) = M(13) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,25),T3sum(1:35,6))
  M(15) = M(15) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,25),T3sum(1:35,6))
  M(17) = M(17) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,25),T3sum(1:35,6))
  M(18) = M(18) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,25),T3sum(1:35,6))
  M(19) = M(19) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,25),T3sum(1:35,6))
  M(21) = M(21) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,25),T3sum(1:35,6))
  M(5) = M(5) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,26),T3sum(1:35,6))
  M(8) = M(8) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,26),T3sum(1:35,6))
  M(11) = M(11) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,26),T3sum(1:35,6))
  M(14) = M(14) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,26),T3sum(1:35,6))
  M(15) = M(15) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,26),T3sum(1:35,6))
  M(16) = M(16) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,26),T3sum(1:35,6))
  M(17) = M(17) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,26),T3sum(1:35,6))
  M(19) = M(19) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,26),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,27),T3sum(1:35,6))
  M(5) = M(5) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,27),T3sum(1:35,6))
  M(11) = M(11) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,27),T3sum(1:35,6))
  M(13) = M(13) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,27),T3sum(1:35,6))
  M(14) = M(14) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,27),T3sum(1:35,6))
  M(16) = M(16) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,27),T3sum(1:35,6))
  M(18) = M(18) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,27),T3sum(1:35,6))
  M(21) = M(21) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,27),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,28),T3sum(1:35,6))
  M(8) = M(8) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,28),T3sum(1:35,6))
  M(13) = M(13) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,28),T3sum(1:35,6))
  M(15) = M(15) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,28),T3sum(1:35,6))
  M(17) = M(17) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,28),T3sum(1:35,6))
  M(18) = M(18) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,28),T3sum(1:35,6))
  M(19) = M(19) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,28),T3sum(1:35,6))
  M(21) = M(21) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,28),T3sum(1:35,6))
  M(5) = M(5) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,29),T3sum(1:35,6))
  M(8) = M(8) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,29),T3sum(1:35,6))
  M(11) = M(11) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,29),T3sum(1:35,6))
  M(14) = M(14) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,29),T3sum(1:35,6))
  M(15) = M(15) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,29),T3sum(1:35,6))
  M(16) = M(16) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,29),T3sum(1:35,6))
  M(17) = M(17) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,29),T3sum(1:35,6))
  M(19) = M(19) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,29),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,30),T3sum(1:35,6))
  M(5) = M(5) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,30),T3sum(1:35,6))
  M(11) = M(11) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,30),T3sum(1:35,6))
  M(13) = M(13) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,30),T3sum(1:35,6))
  M(14) = M(14) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,30),T3sum(1:35,6))
  M(16) = M(16) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,30),T3sum(1:35,6))
  M(18) = M(18) + (CI*f(2) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,30),T3sum(1:35,6))
  M(21) = M(21) + (-(CI*f(2)) * den(269)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,30),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(5)) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,31),T3sum(1:35,15))
  M(8) = M(8) + (CI*f(5) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,31),T3sum(1:35,15))
  M(13) = M(13) + (CI*f(5) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,31),T3sum(1:35,15))
  M(15) = M(15) + (-(CI*f(5)) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,31),T3sum(1:35,15))
  M(17) = M(17) + (-(CI*f(5)) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,31),T3sum(1:35,15))
  M(18) = M(18) + (CI*f(5) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,31),T3sum(1:35,15))
  M(19) = M(19) + (CI*f(5) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,31),T3sum(1:35,15))
  M(21) = M(21) + (-(CI*f(5)) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,31),T3sum(1:35,15))
  M(2) = M(2) + (CI*f(5) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,32),T3sum(1:35,15))
  M(5) = M(5) + (-(CI*f(5)) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,32),T3sum(1:35,15))
  M(11) = M(11) + (-(CI*f(5)) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,32),T3sum(1:35,15))
  M(13) = M(13) + (-(CI*f(5)) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,32),T3sum(1:35,15))
  M(14) = M(14) + (CI*f(5) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,32),T3sum(1:35,15))
  M(16) = M(16) + (CI*f(5) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,32),T3sum(1:35,15))
  M(18) = M(18) + (-(CI*f(5)) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,32),T3sum(1:35,15))
  M(21) = M(21) + (CI*f(5) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,32),T3sum(1:35,15))
  M(5) = M(5) + (CI*f(5) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,33),T3sum(1:35,15))
  M(8) = M(8) + (-(CI*f(5)) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,33),T3sum(1:35,15))
  M(11) = M(11) + (CI*f(5) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,33),T3sum(1:35,15))
  M(14) = M(14) + (-(CI*f(5)) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,33),T3sum(1:35,15))
  M(15) = M(15) + (CI*f(5) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,33),T3sum(1:35,15))
  M(16) = M(16) + (-(CI*f(5)) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,33),T3sum(1:35,15))
  M(17) = M(17) + (CI*f(5) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,33),T3sum(1:35,15))
  M(19) = M(19) + (-(CI*f(5)) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,33),T3sum(1:35,15))
  M(2) = M(2) + (-(CI*f(5)) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,37),T3sum(1:35,15))
  M(8) = M(8) + (CI*f(5) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,37),T3sum(1:35,15))
  M(13) = M(13) + (CI*f(5) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,37),T3sum(1:35,15))
  M(15) = M(15) + (-(CI*f(5)) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,37),T3sum(1:35,15))
  M(17) = M(17) + (-(CI*f(5)) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,37),T3sum(1:35,15))
  M(18) = M(18) + (CI*f(5) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,37),T3sum(1:35,15))
  M(19) = M(19) + (CI*f(5) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,37),T3sum(1:35,15))
  M(21) = M(21) + (-(CI*f(5)) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,37),T3sum(1:35,15))
  M(2) = M(2) + (CI*f(5) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,38),T3sum(1:35,15))
  M(5) = M(5) + (-(CI*f(5)) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,38),T3sum(1:35,15))
  M(11) = M(11) + (-(CI*f(5)) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,38),T3sum(1:35,15))
  M(13) = M(13) + (-(CI*f(5)) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,38),T3sum(1:35,15))
  M(14) = M(14) + (CI*f(5) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,38),T3sum(1:35,15))
  M(16) = M(16) + (CI*f(5) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,38),T3sum(1:35,15))
  M(18) = M(18) + (-(CI*f(5)) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,38),T3sum(1:35,15))
  M(21) = M(21) + (CI*f(5) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,38),T3sum(1:35,15))
  M(5) = M(5) + (CI*f(5) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,39),T3sum(1:35,15))
  M(8) = M(8) + (-(CI*f(5)) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,39),T3sum(1:35,15))
  M(11) = M(11) + (CI*f(5) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,39),T3sum(1:35,15))
  M(14) = M(14) + (-(CI*f(5)) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,39),T3sum(1:35,15))
  M(15) = M(15) + (CI*f(5) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,39),T3sum(1:35,15))
  M(16) = M(16) + (-(CI*f(5)) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,39),T3sum(1:35,15))
  M(17) = M(17) + (CI*f(5) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,39),T3sum(1:35,15))
  M(19) = M(19) + (-(CI*f(5)) * den(17)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,39),T3sum(1:35,15))
  M(2) = M(2) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,43),T3sum(1:35,16))
  M(8) = M(8) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,43),T3sum(1:35,16))
  M(13) = M(13) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,43),T3sum(1:35,16))
  M(15) = M(15) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,43),T3sum(1:35,16))
  M(17) = M(17) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,43),T3sum(1:35,16))
  M(18) = M(18) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,43),T3sum(1:35,16))
  M(19) = M(19) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,43),T3sum(1:35,16))
  M(21) = M(21) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,43),T3sum(1:35,16))
  M(2) = M(2) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,44),T3sum(1:35,16))
  M(5) = M(5) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,44),T3sum(1:35,16))
  M(11) = M(11) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,44),T3sum(1:35,16))
  M(13) = M(13) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,44),T3sum(1:35,16))
  M(14) = M(14) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,44),T3sum(1:35,16))
  M(16) = M(16) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,44),T3sum(1:35,16))
  M(18) = M(18) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,44),T3sum(1:35,16))
  M(21) = M(21) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,44),T3sum(1:35,16))
  M(5) = M(5) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,45),T3sum(1:35,16))
  M(8) = M(8) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,45),T3sum(1:35,16))
  M(11) = M(11) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,45),T3sum(1:35,16))
  M(14) = M(14) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,45),T3sum(1:35,16))
  M(15) = M(15) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,45),T3sum(1:35,16))
  M(16) = M(16) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,45),T3sum(1:35,16))
  M(17) = M(17) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,45),T3sum(1:35,16))
  M(19) = M(19) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,45),T3sum(1:35,16))
  M(2) = M(2) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,49),T3sum(1:35,16))
  M(8) = M(8) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,49),T3sum(1:35,16))
  M(13) = M(13) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,49),T3sum(1:35,16))
  M(15) = M(15) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,49),T3sum(1:35,16))
  M(17) = M(17) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,49),T3sum(1:35,16))
  M(18) = M(18) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,49),T3sum(1:35,16))
  M(19) = M(19) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,49),T3sum(1:35,16))
  M(21) = M(21) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,49),T3sum(1:35,16))
  M(2) = M(2) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,50),T3sum(1:35,16))
  M(5) = M(5) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,50),T3sum(1:35,16))
  M(11) = M(11) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,50),T3sum(1:35,16))
  M(13) = M(13) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,50),T3sum(1:35,16))
  M(14) = M(14) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,50),T3sum(1:35,16))
  M(16) = M(16) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,50),T3sum(1:35,16))
  M(18) = M(18) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,50),T3sum(1:35,16))
  M(21) = M(21) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,50),T3sum(1:35,16))
  M(5) = M(5) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,51),T3sum(1:35,16))
  M(8) = M(8) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,51),T3sum(1:35,16))
  M(11) = M(11) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,51),T3sum(1:35,16))
  M(14) = M(14) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,51),T3sum(1:35,16))
  M(15) = M(15) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,51),T3sum(1:35,16))
  M(16) = M(16) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,51),T3sum(1:35,16))
  M(17) = M(17) + (CI*f(2) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,51),T3sum(1:35,16))
  M(19) = M(19) + (-(CI*f(2)) * den(17)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,51),T3sum(1:35,16))
  M(1) = M(1) + (-(CI*f(5)) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,55),T3sum(1:35,17))
  M(7) = M(7) + (CI*f(5) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,55),T3sum(1:35,17))
  M(13) = M(13) + (CI*f(5) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,55),T3sum(1:35,17))
  M(15) = M(15) + (-(CI*f(5)) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,55),T3sum(1:35,17))
  M(19) = M(19) + (CI*f(5) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,55),T3sum(1:35,17))
  M(21) = M(21) + (-(CI*f(5)) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,55),T3sum(1:35,17))
  M(23) = M(23) + (-(CI*f(5)) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,55),T3sum(1:35,17))
  M(24) = M(24) + (CI*f(5) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,55),T3sum(1:35,17))
  M(1) = M(1) + (CI*f(5) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,56),T3sum(1:35,17))
  M(3) = M(3) + (-(CI*f(5)) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,56),T3sum(1:35,17))
  M(9) = M(9) + (-(CI*f(5)) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,56),T3sum(1:35,17))
  M(15) = M(15) + (CI*f(5) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,56),T3sum(1:35,17))
  M(19) = M(19) + (-(CI*f(5)) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,56),T3sum(1:35,17))
  M(20) = M(20) + (CI*f(5) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,56),T3sum(1:35,17))
  M(22) = M(22) + (CI*f(5) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,56),T3sum(1:35,17))
  M(24) = M(24) + (-(CI*f(5)) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,56),T3sum(1:35,17))
  M(3) = M(3) + (CI*f(5) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,57),T3sum(1:35,17))
  M(7) = M(7) + (-(CI*f(5)) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,57),T3sum(1:35,17))
  M(9) = M(9) + (CI*f(5) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,57),T3sum(1:35,17))
  M(13) = M(13) + (-(CI*f(5)) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,57),T3sum(1:35,17))
  M(20) = M(20) + (-(CI*f(5)) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,57),T3sum(1:35,17))
  M(21) = M(21) + (CI*f(5) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,57),T3sum(1:35,17))
  M(22) = M(22) + (-(CI*f(5)) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,57),T3sum(1:35,17))
  M(23) = M(23) + (CI*f(5) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,57),T3sum(1:35,17))
  M(1) = M(1) + (-(CI*f(5)) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,58),T3sum(1:35,17))
  M(7) = M(7) + (CI*f(5) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,58),T3sum(1:35,17))
  M(13) = M(13) + (CI*f(5) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,58),T3sum(1:35,17))
  M(15) = M(15) + (-(CI*f(5)) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,58),T3sum(1:35,17))
  M(19) = M(19) + (CI*f(5) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,58),T3sum(1:35,17))
  M(21) = M(21) + (-(CI*f(5)) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,58),T3sum(1:35,17))
  M(23) = M(23) + (-(CI*f(5)) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,58),T3sum(1:35,17))
  M(24) = M(24) + (CI*f(5) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,58),T3sum(1:35,17))
  M(1) = M(1) + (CI*f(5) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,59),T3sum(1:35,17))
  M(3) = M(3) + (-(CI*f(5)) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,59),T3sum(1:35,17))
  M(9) = M(9) + (-(CI*f(5)) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,59),T3sum(1:35,17))
  M(15) = M(15) + (CI*f(5) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,59),T3sum(1:35,17))
  M(19) = M(19) + (-(CI*f(5)) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,59),T3sum(1:35,17))
  M(20) = M(20) + (CI*f(5) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,59),T3sum(1:35,17))
  M(22) = M(22) + (CI*f(5) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,59),T3sum(1:35,17))
  M(24) = M(24) + (-(CI*f(5)) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,59),T3sum(1:35,17))
  M(3) = M(3) + (CI*f(5) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,60),T3sum(1:35,17))
  M(7) = M(7) + (-(CI*f(5)) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,60),T3sum(1:35,17))
  M(9) = M(9) + (CI*f(5) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,60),T3sum(1:35,17))
  M(13) = M(13) + (-(CI*f(5)) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,60),T3sum(1:35,17))
  M(20) = M(20) + (-(CI*f(5)) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,60),T3sum(1:35,17))
  M(21) = M(21) + (CI*f(5) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,60),T3sum(1:35,17))
  M(22) = M(22) + (-(CI*f(5)) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,60),T3sum(1:35,17))
  M(23) = M(23) + (CI*f(5) * den(21)) * TI2_call(3,momenta_14,masses2_2,G3tensor(:,60),T3sum(1:35,17))
  M(1) = M(1) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,61),T3sum(1:35,18))
  M(7) = M(7) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,61),T3sum(1:35,18))
  M(13) = M(13) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,61),T3sum(1:35,18))
  M(15) = M(15) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,61),T3sum(1:35,18))
  M(19) = M(19) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,61),T3sum(1:35,18))
  M(21) = M(21) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,61),T3sum(1:35,18))
  M(23) = M(23) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,61),T3sum(1:35,18))
  M(24) = M(24) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,61),T3sum(1:35,18))
  M(1) = M(1) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,62),T3sum(1:35,18))
  M(3) = M(3) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,62),T3sum(1:35,18))
  M(9) = M(9) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,62),T3sum(1:35,18))
  M(15) = M(15) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,62),T3sum(1:35,18))
  M(19) = M(19) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,62),T3sum(1:35,18))
  M(20) = M(20) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,62),T3sum(1:35,18))
  M(22) = M(22) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,62),T3sum(1:35,18))
  M(24) = M(24) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,62),T3sum(1:35,18))
  M(3) = M(3) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,63),T3sum(1:35,18))
  M(7) = M(7) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,63),T3sum(1:35,18))
  M(9) = M(9) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,63),T3sum(1:35,18))
  M(13) = M(13) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,63),T3sum(1:35,18))
  M(20) = M(20) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,63),T3sum(1:35,18))
  M(21) = M(21) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,63),T3sum(1:35,18))
  M(22) = M(22) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,63),T3sum(1:35,18))
  M(23) = M(23) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,63),T3sum(1:35,18))
  M(1) = M(1) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,64),T3sum(1:35,18))
  M(7) = M(7) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,64),T3sum(1:35,18))
  M(13) = M(13) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,64),T3sum(1:35,18))
  M(15) = M(15) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,64),T3sum(1:35,18))
  M(19) = M(19) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,64),T3sum(1:35,18))
  M(21) = M(21) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,64),T3sum(1:35,18))
  M(23) = M(23) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,64),T3sum(1:35,18))
  M(24) = M(24) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,64),T3sum(1:35,18))
  M(1) = M(1) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,65),T3sum(1:35,18))
  M(3) = M(3) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,65),T3sum(1:35,18))
  M(9) = M(9) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,65),T3sum(1:35,18))
  M(15) = M(15) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,65),T3sum(1:35,18))
  M(19) = M(19) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,65),T3sum(1:35,18))
  M(20) = M(20) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,65),T3sum(1:35,18))
  M(22) = M(22) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,65),T3sum(1:35,18))
  M(24) = M(24) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,65),T3sum(1:35,18))
  M(3) = M(3) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,66),T3sum(1:35,18))
  M(7) = M(7) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,66),T3sum(1:35,18))
  M(9) = M(9) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,66),T3sum(1:35,18))
  M(13) = M(13) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,66),T3sum(1:35,18))
  M(20) = M(20) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,66),T3sum(1:35,18))
  M(21) = M(21) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,66),T3sum(1:35,18))
  M(22) = M(22) + (-(CI*f(2)) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,66),T3sum(1:35,18))
  M(23) = M(23) + (CI*f(2) * den(21)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,66),T3sum(1:35,18))
  M(1) = M(1) + (CI*f(5) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,67),T3sum(1:35,5))
  M(7) = M(7) + (-(CI*f(5)) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,67),T3sum(1:35,5))
  M(13) = M(13) + (-(CI*f(5)) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,67),T3sum(1:35,5))
  M(15) = M(15) + (CI*f(5) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,67),T3sum(1:35,5))
  M(19) = M(19) + (-(CI*f(5)) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,67),T3sum(1:35,5))
  M(21) = M(21) + (CI*f(5) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,67),T3sum(1:35,5))
  M(23) = M(23) + (CI*f(5) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,67),T3sum(1:35,5))
  M(24) = M(24) + (-(CI*f(5)) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,67),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(5)) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,68),T3sum(1:35,5))
  M(3) = M(3) + (CI*f(5) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,68),T3sum(1:35,5))
  M(9) = M(9) + (CI*f(5) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,68),T3sum(1:35,5))
  M(15) = M(15) + (-(CI*f(5)) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,68),T3sum(1:35,5))
  M(19) = M(19) + (CI*f(5) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,68),T3sum(1:35,5))
  M(20) = M(20) + (-(CI*f(5)) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,68),T3sum(1:35,5))
  M(22) = M(22) + (-(CI*f(5)) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,68),T3sum(1:35,5))
  M(24) = M(24) + (CI*f(5) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,68),T3sum(1:35,5))
  M(3) = M(3) + (-(CI*f(5)) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,69),T3sum(1:35,5))
  M(7) = M(7) + (CI*f(5) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,69),T3sum(1:35,5))
  M(9) = M(9) + (-(CI*f(5)) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,69),T3sum(1:35,5))
  M(13) = M(13) + (CI*f(5) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,69),T3sum(1:35,5))
  M(20) = M(20) + (CI*f(5) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,69),T3sum(1:35,5))
  M(21) = M(21) + (-(CI*f(5)) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,69),T3sum(1:35,5))
  M(22) = M(22) + (CI*f(5) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,69),T3sum(1:35,5))
  M(23) = M(23) + (-(CI*f(5)) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,69),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(5) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,70),T3sum(1:35,5))
  M(7) = M(7) + (-(CI*f(5)) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,70),T3sum(1:35,5))
  M(13) = M(13) + (-(CI*f(5)) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,70),T3sum(1:35,5))
  M(15) = M(15) + (CI*f(5) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,70),T3sum(1:35,5))
  M(19) = M(19) + (-(CI*f(5)) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,70),T3sum(1:35,5))
  M(21) = M(21) + (CI*f(5) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,70),T3sum(1:35,5))
  M(23) = M(23) + (CI*f(5) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,70),T3sum(1:35,5))
  M(24) = M(24) + (-(CI*f(5)) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,70),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(5)) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,71),T3sum(1:35,5))
  M(3) = M(3) + (CI*f(5) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,71),T3sum(1:35,5))
  M(9) = M(9) + (CI*f(5) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,71),T3sum(1:35,5))
  M(15) = M(15) + (-(CI*f(5)) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,71),T3sum(1:35,5))
  M(19) = M(19) + (CI*f(5) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,71),T3sum(1:35,5))
  M(20) = M(20) + (-(CI*f(5)) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,71),T3sum(1:35,5))
  M(22) = M(22) + (-(CI*f(5)) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,71),T3sum(1:35,5))
  M(24) = M(24) + (CI*f(5) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,71),T3sum(1:35,5))
  M(3) = M(3) + (-(CI*f(5)) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,72),T3sum(1:35,5))
  M(7) = M(7) + (CI*f(5) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,72),T3sum(1:35,5))
  M(9) = M(9) + (-(CI*f(5)) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,72),T3sum(1:35,5))
  M(13) = M(13) + (CI*f(5) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,72),T3sum(1:35,5))
  M(20) = M(20) + (CI*f(5) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,72),T3sum(1:35,5))
  M(21) = M(21) + (-(CI*f(5)) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,72),T3sum(1:35,5))
  M(22) = M(22) + (CI*f(5) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,72),T3sum(1:35,5))
  M(23) = M(23) + (-(CI*f(5)) * den(274)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,72),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,73),T3sum(1:35,6))
  M(7) = M(7) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,73),T3sum(1:35,6))
  M(13) = M(13) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,73),T3sum(1:35,6))
  M(15) = M(15) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,73),T3sum(1:35,6))
  M(19) = M(19) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,73),T3sum(1:35,6))
  M(21) = M(21) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,73),T3sum(1:35,6))
  M(23) = M(23) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,73),T3sum(1:35,6))
  M(24) = M(24) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,73),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,74),T3sum(1:35,6))
  M(3) = M(3) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,74),T3sum(1:35,6))
  M(9) = M(9) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,74),T3sum(1:35,6))
  M(15) = M(15) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,74),T3sum(1:35,6))
  M(19) = M(19) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,74),T3sum(1:35,6))
  M(20) = M(20) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,74),T3sum(1:35,6))
  M(22) = M(22) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,74),T3sum(1:35,6))
  M(24) = M(24) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,74),T3sum(1:35,6))
  M(3) = M(3) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,75),T3sum(1:35,6))
  M(7) = M(7) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,75),T3sum(1:35,6))
  M(9) = M(9) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,75),T3sum(1:35,6))
  M(13) = M(13) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,75),T3sum(1:35,6))
  M(20) = M(20) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,75),T3sum(1:35,6))
  M(21) = M(21) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,75),T3sum(1:35,6))
  M(22) = M(22) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,75),T3sum(1:35,6))
  M(23) = M(23) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,75),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,76),T3sum(1:35,6))
  M(7) = M(7) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,76),T3sum(1:35,6))
  M(13) = M(13) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,76),T3sum(1:35,6))
  M(15) = M(15) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,76),T3sum(1:35,6))
  M(19) = M(19) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,76),T3sum(1:35,6))
  M(21) = M(21) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,76),T3sum(1:35,6))
  M(23) = M(23) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,76),T3sum(1:35,6))
  M(24) = M(24) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,76),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,77),T3sum(1:35,6))
  M(3) = M(3) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,77),T3sum(1:35,6))
  M(9) = M(9) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,77),T3sum(1:35,6))
  M(15) = M(15) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,77),T3sum(1:35,6))
  M(19) = M(19) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,77),T3sum(1:35,6))
  M(20) = M(20) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,77),T3sum(1:35,6))
  M(22) = M(22) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,77),T3sum(1:35,6))
  M(24) = M(24) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,77),T3sum(1:35,6))
  M(3) = M(3) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,78),T3sum(1:35,6))
  M(7) = M(7) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,78),T3sum(1:35,6))
  M(9) = M(9) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,78),T3sum(1:35,6))
  M(13) = M(13) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,78),T3sum(1:35,6))
  M(20) = M(20) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,78),T3sum(1:35,6))
  M(21) = M(21) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,78),T3sum(1:35,6))
  M(22) = M(22) + (CI*f(2) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,78),T3sum(1:35,6))
  M(23) = M(23) + (-(CI*f(2)) * den(274)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,78),T3sum(1:35,6))
  M(1) = M(1) + (-f(6) * den(20)) * TI2_call(4,momenta_90,masses2_4,G4tensor(:,28),T4sum(1:70,23))
  M(7) = M(7) + (f(6) * den(20)) * TI2_call(4,momenta_90,masses2_4,G4tensor(:,28),T4sum(1:70,23))
  M(13) = M(13) + (f(6) * den(20)) * TI2_call(4,momenta_90,masses2_4,G4tensor(:,28),T4sum(1:70,23))
  M(15) = M(15) + (-f(6) * den(20)) * TI2_call(4,momenta_90,masses2_4,G4tensor(:,28),T4sum(1:70,23))
  M(1) = M(1) + (f(6) * den(20)) * TI2_call(4,momenta_90,masses2_4,G4tensor(:,29),T4sum(1:70,23))
  M(3) = M(3) + (-f(6) * den(20)) * TI2_call(4,momenta_90,masses2_4,G4tensor(:,29),T4sum(1:70,23))
  M(9) = M(9) + (-f(6) * den(20)) * TI2_call(4,momenta_90,masses2_4,G4tensor(:,29),T4sum(1:70,23))
  M(15) = M(15) + (f(6) * den(20)) * TI2_call(4,momenta_90,masses2_4,G4tensor(:,29),T4sum(1:70,23))
  M(3) = M(3) + (f(6) * den(20)) * TI2_call(4,momenta_90,masses2_4,G4tensor(:,30),T4sum(1:70,23))
  M(7) = M(7) + (-f(6) * den(20)) * TI2_call(4,momenta_90,masses2_4,G4tensor(:,30),T4sum(1:70,23))
  M(9) = M(9) + (f(6) * den(20)) * TI2_call(4,momenta_90,masses2_4,G4tensor(:,30),T4sum(1:70,23))
  M(13) = M(13) + (-f(6) * den(20)) * TI2_call(4,momenta_90,masses2_4,G4tensor(:,30),T4sum(1:70,23))
  M(19) = M(19) + (-f(6) * den(20)) * TI2_call(4,momenta_90,masses2_4,G4tensor(:,31),T4sum(1:70,23))
  M(21) = M(21) + (f(6) * den(20)) * TI2_call(4,momenta_90,masses2_4,G4tensor(:,31),T4sum(1:70,23))
  M(23) = M(23) + (f(6) * den(20)) * TI2_call(4,momenta_90,masses2_4,G4tensor(:,31),T4sum(1:70,23))
  M(24) = M(24) + (-f(6) * den(20)) * TI2_call(4,momenta_90,masses2_4,G4tensor(:,31),T4sum(1:70,23))
  M(19) = M(19) + (f(6) * den(20)) * TI2_call(4,momenta_90,masses2_4,G4tensor(:,32),T4sum(1:70,23))
  M(20) = M(20) + (-f(6) * den(20)) * TI2_call(4,momenta_90,masses2_4,G4tensor(:,32),T4sum(1:70,23))
  M(22) = M(22) + (-f(6) * den(20)) * TI2_call(4,momenta_90,masses2_4,G4tensor(:,32),T4sum(1:70,23))
  M(24) = M(24) + (f(6) * den(20)) * TI2_call(4,momenta_90,masses2_4,G4tensor(:,32),T4sum(1:70,23))
  M(20) = M(20) + (f(6) * den(20)) * TI2_call(4,momenta_90,masses2_4,G4tensor(:,33),T4sum(1:70,23))
  M(21) = M(21) + (-f(6) * den(20)) * TI2_call(4,momenta_90,masses2_4,G4tensor(:,33),T4sum(1:70,23))
  M(22) = M(22) + (f(6) * den(20)) * TI2_call(4,momenta_90,masses2_4,G4tensor(:,33),T4sum(1:70,23))
  M(23) = M(23) + (-f(6) * den(20)) * TI2_call(4,momenta_90,masses2_4,G4tensor(:,33),T4sum(1:70,23))
  M(1) = M(1) + (-f(3) * den(20)) * TI2_call(4,momenta_90,masses2_3,G4tensor(:,34),T4sum(1:70,24))
  M(7) = M(7) + (f(3) * den(20)) * TI2_call(4,momenta_90,masses2_3,G4tensor(:,34),T4sum(1:70,24))
  M(13) = M(13) + (f(3) * den(20)) * TI2_call(4,momenta_90,masses2_3,G4tensor(:,34),T4sum(1:70,24))
  M(15) = M(15) + (-f(3) * den(20)) * TI2_call(4,momenta_90,masses2_3,G4tensor(:,34),T4sum(1:70,24))
  M(1) = M(1) + (f(3) * den(20)) * TI2_call(4,momenta_90,masses2_3,G4tensor(:,35),T4sum(1:70,24))
  M(3) = M(3) + (-f(3) * den(20)) * TI2_call(4,momenta_90,masses2_3,G4tensor(:,35),T4sum(1:70,24))
  M(9) = M(9) + (-f(3) * den(20)) * TI2_call(4,momenta_90,masses2_3,G4tensor(:,35),T4sum(1:70,24))
  M(15) = M(15) + (f(3) * den(20)) * TI2_call(4,momenta_90,masses2_3,G4tensor(:,35),T4sum(1:70,24))
  M(3) = M(3) + (f(3) * den(20)) * TI2_call(4,momenta_90,masses2_3,G4tensor(:,36),T4sum(1:70,24))
  M(7) = M(7) + (-f(3) * den(20)) * TI2_call(4,momenta_90,masses2_3,G4tensor(:,36),T4sum(1:70,24))
  M(9) = M(9) + (f(3) * den(20)) * TI2_call(4,momenta_90,masses2_3,G4tensor(:,36),T4sum(1:70,24))
  M(13) = M(13) + (-f(3) * den(20)) * TI2_call(4,momenta_90,masses2_3,G4tensor(:,36),T4sum(1:70,24))
  M(19) = M(19) + (-f(3) * den(20)) * TI2_call(4,momenta_90,masses2_3,G4tensor(:,37),T4sum(1:70,24))
  M(21) = M(21) + (f(3) * den(20)) * TI2_call(4,momenta_90,masses2_3,G4tensor(:,37),T4sum(1:70,24))
  M(23) = M(23) + (f(3) * den(20)) * TI2_call(4,momenta_90,masses2_3,G4tensor(:,37),T4sum(1:70,24))
  M(24) = M(24) + (-f(3) * den(20)) * TI2_call(4,momenta_90,masses2_3,G4tensor(:,37),T4sum(1:70,24))
  M(19) = M(19) + (f(3) * den(20)) * TI2_call(4,momenta_90,masses2_3,G4tensor(:,38),T4sum(1:70,24))
  M(20) = M(20) + (-f(3) * den(20)) * TI2_call(4,momenta_90,masses2_3,G4tensor(:,38),T4sum(1:70,24))
  M(22) = M(22) + (-f(3) * den(20)) * TI2_call(4,momenta_90,masses2_3,G4tensor(:,38),T4sum(1:70,24))
  M(24) = M(24) + (f(3) * den(20)) * TI2_call(4,momenta_90,masses2_3,G4tensor(:,38),T4sum(1:70,24))
  M(20) = M(20) + (f(3) * den(20)) * TI2_call(4,momenta_90,masses2_3,G4tensor(:,39),T4sum(1:70,24))
  M(21) = M(21) + (-f(3) * den(20)) * TI2_call(4,momenta_90,masses2_3,G4tensor(:,39),T4sum(1:70,24))
  M(22) = M(22) + (f(3) * den(20)) * TI2_call(4,momenta_90,masses2_3,G4tensor(:,39),T4sum(1:70,24))
  M(23) = M(23) + (-f(3) * den(20)) * TI2_call(4,momenta_90,masses2_3,G4tensor(:,39),T4sum(1:70,24))
  M(1) = M(1) + (CI*f(5) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,79),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(5)) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,79),T3sum(1:35,5))
  M(7) = M(7) + (-(CI*f(5)) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,79),T3sum(1:35,5))
  M(8) = M(8) + (CI*f(5) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,79),T3sum(1:35,5))
  M(17) = M(17) + (-(CI*f(5)) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,79),T3sum(1:35,5))
  M(18) = M(18) + (CI*f(5) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,79),T3sum(1:35,5))
  M(23) = M(23) + (CI*f(5) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,79),T3sum(1:35,5))
  M(24) = M(24) + (-(CI*f(5)) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,79),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(5)) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,80),T3sum(1:35,5))
  M(7) = M(7) + (CI*f(5) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,80),T3sum(1:35,5))
  M(13) = M(13) + (CI*f(5) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,80),T3sum(1:35,5))
  M(15) = M(15) + (-(CI*f(5)) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,80),T3sum(1:35,5))
  M(19) = M(19) + (CI*f(5) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,80),T3sum(1:35,5))
  M(21) = M(21) + (-(CI*f(5)) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,80),T3sum(1:35,5))
  M(23) = M(23) + (-(CI*f(5)) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,80),T3sum(1:35,5))
  M(24) = M(24) + (CI*f(5) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,80),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(5) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,81),T3sum(1:35,5))
  M(8) = M(8) + (-(CI*f(5)) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,81),T3sum(1:35,5))
  M(13) = M(13) + (-(CI*f(5)) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,81),T3sum(1:35,5))
  M(15) = M(15) + (CI*f(5) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,81),T3sum(1:35,5))
  M(17) = M(17) + (CI*f(5) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,81),T3sum(1:35,5))
  M(18) = M(18) + (-(CI*f(5)) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,81),T3sum(1:35,5))
  M(19) = M(19) + (-(CI*f(5)) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,81),T3sum(1:35,5))
  M(21) = M(21) + (CI*f(5) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,81),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(5) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,82),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(5)) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,82),T3sum(1:35,5))
  M(7) = M(7) + (-(CI*f(5)) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,82),T3sum(1:35,5))
  M(8) = M(8) + (CI*f(5) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,82),T3sum(1:35,5))
  M(17) = M(17) + (-(CI*f(5)) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,82),T3sum(1:35,5))
  M(18) = M(18) + (CI*f(5) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,82),T3sum(1:35,5))
  M(23) = M(23) + (CI*f(5) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,82),T3sum(1:35,5))
  M(24) = M(24) + (-(CI*f(5)) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,82),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(5)) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,83),T3sum(1:35,5))
  M(7) = M(7) + (CI*f(5) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,83),T3sum(1:35,5))
  M(13) = M(13) + (CI*f(5) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,83),T3sum(1:35,5))
  M(15) = M(15) + (-(CI*f(5)) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,83),T3sum(1:35,5))
  M(19) = M(19) + (CI*f(5) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,83),T3sum(1:35,5))
  M(21) = M(21) + (-(CI*f(5)) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,83),T3sum(1:35,5))
  M(23) = M(23) + (-(CI*f(5)) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,83),T3sum(1:35,5))
  M(24) = M(24) + (CI*f(5) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,83),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(5) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,84),T3sum(1:35,5))
  M(8) = M(8) + (-(CI*f(5)) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,84),T3sum(1:35,5))
  M(13) = M(13) + (-(CI*f(5)) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,84),T3sum(1:35,5))
  M(15) = M(15) + (CI*f(5) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,84),T3sum(1:35,5))
  M(17) = M(17) + (CI*f(5) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,84),T3sum(1:35,5))
  M(18) = M(18) + (-(CI*f(5)) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,84),T3sum(1:35,5))
  M(19) = M(19) + (-(CI*f(5)) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,84),T3sum(1:35,5))
  M(21) = M(21) + (CI*f(5) * den(277)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,84),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,85),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,85),T3sum(1:35,6))
  M(7) = M(7) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,85),T3sum(1:35,6))
  M(8) = M(8) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,85),T3sum(1:35,6))
  M(17) = M(17) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,85),T3sum(1:35,6))
  M(18) = M(18) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,85),T3sum(1:35,6))
  M(23) = M(23) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,85),T3sum(1:35,6))
  M(24) = M(24) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,85),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,86),T3sum(1:35,6))
  M(7) = M(7) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,86),T3sum(1:35,6))
  M(13) = M(13) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,86),T3sum(1:35,6))
  M(15) = M(15) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,86),T3sum(1:35,6))
  M(19) = M(19) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,86),T3sum(1:35,6))
  M(21) = M(21) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,86),T3sum(1:35,6))
  M(23) = M(23) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,86),T3sum(1:35,6))
  M(24) = M(24) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,86),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,87),T3sum(1:35,6))
  M(8) = M(8) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,87),T3sum(1:35,6))
  M(13) = M(13) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,87),T3sum(1:35,6))
  M(15) = M(15) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,87),T3sum(1:35,6))
  M(17) = M(17) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,87),T3sum(1:35,6))
  M(18) = M(18) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,87),T3sum(1:35,6))
  M(19) = M(19) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,87),T3sum(1:35,6))
  M(21) = M(21) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,87),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,88),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,88),T3sum(1:35,6))
  M(7) = M(7) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,88),T3sum(1:35,6))
  M(8) = M(8) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,88),T3sum(1:35,6))
  M(17) = M(17) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,88),T3sum(1:35,6))
  M(18) = M(18) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,88),T3sum(1:35,6))
  M(23) = M(23) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,88),T3sum(1:35,6))
  M(24) = M(24) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,88),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,89),T3sum(1:35,6))
  M(7) = M(7) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,89),T3sum(1:35,6))
  M(13) = M(13) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,89),T3sum(1:35,6))
  M(15) = M(15) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,89),T3sum(1:35,6))
  M(19) = M(19) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,89),T3sum(1:35,6))
  M(21) = M(21) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,89),T3sum(1:35,6))
  M(23) = M(23) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,89),T3sum(1:35,6))
  M(24) = M(24) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,89),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,90),T3sum(1:35,6))
  M(8) = M(8) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,90),T3sum(1:35,6))
  M(13) = M(13) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,90),T3sum(1:35,6))
  M(15) = M(15) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,90),T3sum(1:35,6))
  M(17) = M(17) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,90),T3sum(1:35,6))
  M(18) = M(18) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,90),T3sum(1:35,6))
  M(19) = M(19) + (-(CI*f(2)) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,90),T3sum(1:35,6))
  M(21) = M(21) + (CI*f(2) * den(277)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,90),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(5) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,91),T3sum(1:35,19))
  M(8) = M(8) + (-(CI*f(5)) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,91),T3sum(1:35,19))
  M(13) = M(13) + (-(CI*f(5)) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,91),T3sum(1:35,19))
  M(15) = M(15) + (CI*f(5) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,91),T3sum(1:35,19))
  M(17) = M(17) + (CI*f(5) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,91),T3sum(1:35,19))
  M(18) = M(18) + (-(CI*f(5)) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,91),T3sum(1:35,19))
  M(19) = M(19) + (-(CI*f(5)) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,91),T3sum(1:35,19))
  M(21) = M(21) + (CI*f(5) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,91),T3sum(1:35,19))
  M(1) = M(1) + (CI*f(5) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,92),T3sum(1:35,19))
  M(2) = M(2) + (-(CI*f(5)) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,92),T3sum(1:35,19))
  M(7) = M(7) + (-(CI*f(5)) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,92),T3sum(1:35,19))
  M(8) = M(8) + (CI*f(5) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,92),T3sum(1:35,19))
  M(17) = M(17) + (-(CI*f(5)) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,92),T3sum(1:35,19))
  M(18) = M(18) + (CI*f(5) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,92),T3sum(1:35,19))
  M(23) = M(23) + (CI*f(5) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,92),T3sum(1:35,19))
  M(24) = M(24) + (-(CI*f(5)) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,92),T3sum(1:35,19))
  M(1) = M(1) + (-(CI*f(5)) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,93),T3sum(1:35,19))
  M(7) = M(7) + (CI*f(5) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,93),T3sum(1:35,19))
  M(13) = M(13) + (CI*f(5) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,93),T3sum(1:35,19))
  M(15) = M(15) + (-(CI*f(5)) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,93),T3sum(1:35,19))
  M(19) = M(19) + (CI*f(5) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,93),T3sum(1:35,19))
  M(21) = M(21) + (-(CI*f(5)) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,93),T3sum(1:35,19))
  M(23) = M(23) + (-(CI*f(5)) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,93),T3sum(1:35,19))
  M(24) = M(24) + (CI*f(5) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,93),T3sum(1:35,19))
  M(2) = M(2) + (CI*f(5) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,97),T3sum(1:35,19))
  M(8) = M(8) + (-(CI*f(5)) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,97),T3sum(1:35,19))
  M(13) = M(13) + (-(CI*f(5)) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,97),T3sum(1:35,19))
  M(15) = M(15) + (CI*f(5) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,97),T3sum(1:35,19))
  M(17) = M(17) + (CI*f(5) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,97),T3sum(1:35,19))
  M(18) = M(18) + (-(CI*f(5)) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,97),T3sum(1:35,19))
  M(19) = M(19) + (-(CI*f(5)) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,97),T3sum(1:35,19))
  M(21) = M(21) + (CI*f(5) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,97),T3sum(1:35,19))
  M(1) = M(1) + (CI*f(5) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,98),T3sum(1:35,19))
  M(2) = M(2) + (-(CI*f(5)) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,98),T3sum(1:35,19))
  M(7) = M(7) + (-(CI*f(5)) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,98),T3sum(1:35,19))
  M(8) = M(8) + (CI*f(5) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,98),T3sum(1:35,19))
  M(17) = M(17) + (-(CI*f(5)) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,98),T3sum(1:35,19))
  M(18) = M(18) + (CI*f(5) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,98),T3sum(1:35,19))
  M(23) = M(23) + (CI*f(5) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,98),T3sum(1:35,19))
  M(24) = M(24) + (-(CI*f(5)) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,98),T3sum(1:35,19))
  M(1) = M(1) + (-(CI*f(5)) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,99),T3sum(1:35,19))
  M(7) = M(7) + (CI*f(5) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,99),T3sum(1:35,19))
  M(13) = M(13) + (CI*f(5) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,99),T3sum(1:35,19))
  M(15) = M(15) + (-(CI*f(5)) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,99),T3sum(1:35,19))
  M(19) = M(19) + (CI*f(5) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,99),T3sum(1:35,19))
  M(21) = M(21) + (-(CI*f(5)) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,99),T3sum(1:35,19))
  M(23) = M(23) + (-(CI*f(5)) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,99),T3sum(1:35,19))
  M(24) = M(24) + (CI*f(5) * den(35)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,99),T3sum(1:35,19))
  M(2) = M(2) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,103),T3sum(1:35,20))
  M(8) = M(8) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,103),T3sum(1:35,20))
  M(13) = M(13) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,103),T3sum(1:35,20))
  M(15) = M(15) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,103),T3sum(1:35,20))
  M(17) = M(17) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,103),T3sum(1:35,20))
  M(18) = M(18) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,103),T3sum(1:35,20))
  M(19) = M(19) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,103),T3sum(1:35,20))
  M(21) = M(21) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,103),T3sum(1:35,20))
  M(1) = M(1) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,104),T3sum(1:35,20))
  M(2) = M(2) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,104),T3sum(1:35,20))
  M(7) = M(7) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,104),T3sum(1:35,20))
  M(8) = M(8) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,104),T3sum(1:35,20))
  M(17) = M(17) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,104),T3sum(1:35,20))
  M(18) = M(18) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,104),T3sum(1:35,20))
  M(23) = M(23) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,104),T3sum(1:35,20))
  M(24) = M(24) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,104),T3sum(1:35,20))
  M(1) = M(1) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,105),T3sum(1:35,20))
  M(7) = M(7) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,105),T3sum(1:35,20))
  M(13) = M(13) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,105),T3sum(1:35,20))
  M(15) = M(15) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,105),T3sum(1:35,20))
  M(19) = M(19) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,105),T3sum(1:35,20))
  M(21) = M(21) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,105),T3sum(1:35,20))
  M(23) = M(23) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,105),T3sum(1:35,20))
  M(24) = M(24) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,105),T3sum(1:35,20))
  M(2) = M(2) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,109),T3sum(1:35,20))
  M(8) = M(8) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,109),T3sum(1:35,20))
  M(13) = M(13) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,109),T3sum(1:35,20))
  M(15) = M(15) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,109),T3sum(1:35,20))
  M(17) = M(17) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,109),T3sum(1:35,20))
  M(18) = M(18) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,109),T3sum(1:35,20))
  M(19) = M(19) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,109),T3sum(1:35,20))
  M(21) = M(21) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,109),T3sum(1:35,20))
  M(1) = M(1) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,110),T3sum(1:35,20))
  M(2) = M(2) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,110),T3sum(1:35,20))
  M(7) = M(7) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,110),T3sum(1:35,20))
  M(8) = M(8) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,110),T3sum(1:35,20))
  M(17) = M(17) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,110),T3sum(1:35,20))
  M(18) = M(18) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,110),T3sum(1:35,20))
  M(23) = M(23) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,110),T3sum(1:35,20))
  M(24) = M(24) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,110),T3sum(1:35,20))
  M(1) = M(1) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,111),T3sum(1:35,20))
  M(7) = M(7) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,111),T3sum(1:35,20))
  M(13) = M(13) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,111),T3sum(1:35,20))
  M(15) = M(15) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,111),T3sum(1:35,20))
  M(19) = M(19) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,111),T3sum(1:35,20))
  M(21) = M(21) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,111),T3sum(1:35,20))
  M(23) = M(23) + (-(CI*f(2)) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,111),T3sum(1:35,20))
  M(24) = M(24) + (CI*f(2) * den(35)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,111),T3sum(1:35,20))
  M(4) = M(4) + (-(CI*f(5)) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,115),T3sum(1:35,5))
  M(7) = M(7) + (CI*f(5) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,115),T3sum(1:35,5))
  M(9) = M(9) + (-(CI*f(5)) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,115),T3sum(1:35,5))
  M(11) = M(11) + (-(CI*f(5)) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,115),T3sum(1:35,5))
  M(12) = M(12) + (CI*f(5) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,115),T3sum(1:35,5))
  M(14) = M(14) + (CI*f(5) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,115),T3sum(1:35,5))
  M(20) = M(20) + (CI*f(5) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,115),T3sum(1:35,5))
  M(23) = M(23) + (-(CI*f(5)) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,115),T3sum(1:35,5))
  M(3) = M(3) + (CI*f(5) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,116),T3sum(1:35,5))
  M(7) = M(7) + (-(CI*f(5)) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,116),T3sum(1:35,5))
  M(9) = M(9) + (CI*f(5) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,116),T3sum(1:35,5))
  M(13) = M(13) + (-(CI*f(5)) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,116),T3sum(1:35,5))
  M(20) = M(20) + (-(CI*f(5)) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,116),T3sum(1:35,5))
  M(21) = M(21) + (CI*f(5) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,116),T3sum(1:35,5))
  M(22) = M(22) + (-(CI*f(5)) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,116),T3sum(1:35,5))
  M(23) = M(23) + (CI*f(5) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,116),T3sum(1:35,5))
  M(3) = M(3) + (-(CI*f(5)) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,117),T3sum(1:35,5))
  M(4) = M(4) + (CI*f(5) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,117),T3sum(1:35,5))
  M(11) = M(11) + (CI*f(5) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,117),T3sum(1:35,5))
  M(12) = M(12) + (-(CI*f(5)) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,117),T3sum(1:35,5))
  M(13) = M(13) + (CI*f(5) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,117),T3sum(1:35,5))
  M(14) = M(14) + (-(CI*f(5)) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,117),T3sum(1:35,5))
  M(21) = M(21) + (-(CI*f(5)) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,117),T3sum(1:35,5))
  M(22) = M(22) + (CI*f(5) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,117),T3sum(1:35,5))
  M(4) = M(4) + (-(CI*f(5)) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,118),T3sum(1:35,5))
  M(7) = M(7) + (CI*f(5) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,118),T3sum(1:35,5))
  M(9) = M(9) + (-(CI*f(5)) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,118),T3sum(1:35,5))
  M(11) = M(11) + (-(CI*f(5)) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,118),T3sum(1:35,5))
  M(12) = M(12) + (CI*f(5) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,118),T3sum(1:35,5))
  M(14) = M(14) + (CI*f(5) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,118),T3sum(1:35,5))
  M(20) = M(20) + (CI*f(5) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,118),T3sum(1:35,5))
  M(23) = M(23) + (-(CI*f(5)) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,118),T3sum(1:35,5))
  M(3) = M(3) + (CI*f(5) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,119),T3sum(1:35,5))
  M(7) = M(7) + (-(CI*f(5)) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,119),T3sum(1:35,5))
  M(9) = M(9) + (CI*f(5) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,119),T3sum(1:35,5))
  M(13) = M(13) + (-(CI*f(5)) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,119),T3sum(1:35,5))
  M(20) = M(20) + (-(CI*f(5)) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,119),T3sum(1:35,5))
  M(21) = M(21) + (CI*f(5) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,119),T3sum(1:35,5))
  M(22) = M(22) + (-(CI*f(5)) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,119),T3sum(1:35,5))
  M(23) = M(23) + (CI*f(5) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,119),T3sum(1:35,5))
  M(3) = M(3) + (-(CI*f(5)) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,120),T3sum(1:35,5))
  M(4) = M(4) + (CI*f(5) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,120),T3sum(1:35,5))
  M(11) = M(11) + (CI*f(5) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,120),T3sum(1:35,5))
  M(12) = M(12) + (-(CI*f(5)) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,120),T3sum(1:35,5))
  M(13) = M(13) + (CI*f(5) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,120),T3sum(1:35,5))
  M(14) = M(14) + (-(CI*f(5)) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,120),T3sum(1:35,5))
  M(21) = M(21) + (-(CI*f(5)) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,120),T3sum(1:35,5))
  M(22) = M(22) + (CI*f(5) * den(284)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,120),T3sum(1:35,5))
  M(4) = M(4) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,121),T3sum(1:35,6))
  M(7) = M(7) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,121),T3sum(1:35,6))
  M(9) = M(9) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,121),T3sum(1:35,6))
  M(11) = M(11) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,121),T3sum(1:35,6))
  M(12) = M(12) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,121),T3sum(1:35,6))
  M(14) = M(14) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,121),T3sum(1:35,6))
  M(20) = M(20) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,121),T3sum(1:35,6))
  M(23) = M(23) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,121),T3sum(1:35,6))
  M(3) = M(3) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,122),T3sum(1:35,6))
  M(7) = M(7) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,122),T3sum(1:35,6))
  M(9) = M(9) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,122),T3sum(1:35,6))
  M(13) = M(13) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,122),T3sum(1:35,6))
  M(20) = M(20) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,122),T3sum(1:35,6))
  M(21) = M(21) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,122),T3sum(1:35,6))
  M(22) = M(22) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,122),T3sum(1:35,6))
  M(23) = M(23) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,122),T3sum(1:35,6))
  M(3) = M(3) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,123),T3sum(1:35,6))
  M(4) = M(4) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,123),T3sum(1:35,6))
  M(11) = M(11) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,123),T3sum(1:35,6))
  M(12) = M(12) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,123),T3sum(1:35,6))
  M(13) = M(13) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,123),T3sum(1:35,6))
  M(14) = M(14) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,123),T3sum(1:35,6))
  M(21) = M(21) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,123),T3sum(1:35,6))
  M(22) = M(22) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,123),T3sum(1:35,6))
  M(4) = M(4) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,124),T3sum(1:35,6))
  M(7) = M(7) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,124),T3sum(1:35,6))
  M(9) = M(9) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,124),T3sum(1:35,6))
  M(11) = M(11) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,124),T3sum(1:35,6))
  M(12) = M(12) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,124),T3sum(1:35,6))
  M(14) = M(14) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,124),T3sum(1:35,6))
  M(20) = M(20) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,124),T3sum(1:35,6))
  M(23) = M(23) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,124),T3sum(1:35,6))
  M(3) = M(3) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,125),T3sum(1:35,6))
  M(7) = M(7) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,125),T3sum(1:35,6))
  M(9) = M(9) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,125),T3sum(1:35,6))
  M(13) = M(13) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,125),T3sum(1:35,6))
  M(20) = M(20) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,125),T3sum(1:35,6))
  M(21) = M(21) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,125),T3sum(1:35,6))
  M(22) = M(22) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,125),T3sum(1:35,6))
  M(23) = M(23) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,125),T3sum(1:35,6))
  M(3) = M(3) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,126),T3sum(1:35,6))
  M(4) = M(4) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,126),T3sum(1:35,6))
  M(11) = M(11) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,126),T3sum(1:35,6))
  M(12) = M(12) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,126),T3sum(1:35,6))
  M(13) = M(13) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,126),T3sum(1:35,6))
  M(14) = M(14) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,126),T3sum(1:35,6))
  M(21) = M(21) + (-(CI*f(2)) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,126),T3sum(1:35,6))
  M(22) = M(22) + (CI*f(2) * den(284)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,126),T3sum(1:35,6))
  M(4) = M(4) + (CI*f(5) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,127),T3sum(1:35,21))
  M(7) = M(7) + (-(CI*f(5)) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,127),T3sum(1:35,21))
  M(9) = M(9) + (CI*f(5) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,127),T3sum(1:35,21))
  M(11) = M(11) + (CI*f(5) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,127),T3sum(1:35,21))
  M(12) = M(12) + (-(CI*f(5)) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,127),T3sum(1:35,21))
  M(14) = M(14) + (-(CI*f(5)) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,127),T3sum(1:35,21))
  M(20) = M(20) + (-(CI*f(5)) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,127),T3sum(1:35,21))
  M(23) = M(23) + (CI*f(5) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,127),T3sum(1:35,21))
  M(3) = M(3) + (CI*f(5) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,128),T3sum(1:35,21))
  M(4) = M(4) + (-(CI*f(5)) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,128),T3sum(1:35,21))
  M(11) = M(11) + (-(CI*f(5)) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,128),T3sum(1:35,21))
  M(12) = M(12) + (CI*f(5) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,128),T3sum(1:35,21))
  M(13) = M(13) + (-(CI*f(5)) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,128),T3sum(1:35,21))
  M(14) = M(14) + (CI*f(5) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,128),T3sum(1:35,21))
  M(21) = M(21) + (CI*f(5) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,128),T3sum(1:35,21))
  M(22) = M(22) + (-(CI*f(5)) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,128),T3sum(1:35,21))
  M(3) = M(3) + (-(CI*f(5)) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,129),T3sum(1:35,21))
  M(7) = M(7) + (CI*f(5) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,129),T3sum(1:35,21))
  M(9) = M(9) + (-(CI*f(5)) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,129),T3sum(1:35,21))
  M(13) = M(13) + (CI*f(5) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,129),T3sum(1:35,21))
  M(20) = M(20) + (CI*f(5) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,129),T3sum(1:35,21))
  M(21) = M(21) + (-(CI*f(5)) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,129),T3sum(1:35,21))
  M(22) = M(22) + (CI*f(5) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,129),T3sum(1:35,21))
  M(23) = M(23) + (-(CI*f(5)) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,129),T3sum(1:35,21))
  M(4) = M(4) + (CI*f(5) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,133),T3sum(1:35,21))
  M(7) = M(7) + (-(CI*f(5)) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,133),T3sum(1:35,21))
  M(9) = M(9) + (CI*f(5) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,133),T3sum(1:35,21))
  M(11) = M(11) + (CI*f(5) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,133),T3sum(1:35,21))
  M(12) = M(12) + (-(CI*f(5)) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,133),T3sum(1:35,21))
  M(14) = M(14) + (-(CI*f(5)) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,133),T3sum(1:35,21))
  M(20) = M(20) + (-(CI*f(5)) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,133),T3sum(1:35,21))
  M(23) = M(23) + (CI*f(5) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,133),T3sum(1:35,21))
  M(3) = M(3) + (CI*f(5) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,134),T3sum(1:35,21))
  M(4) = M(4) + (-(CI*f(5)) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,134),T3sum(1:35,21))
  M(11) = M(11) + (-(CI*f(5)) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,134),T3sum(1:35,21))
  M(12) = M(12) + (CI*f(5) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,134),T3sum(1:35,21))
  M(13) = M(13) + (-(CI*f(5)) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,134),T3sum(1:35,21))
  M(14) = M(14) + (CI*f(5) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,134),T3sum(1:35,21))
  M(21) = M(21) + (CI*f(5) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,134),T3sum(1:35,21))
  M(22) = M(22) + (-(CI*f(5)) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,134),T3sum(1:35,21))
  M(3) = M(3) + (-(CI*f(5)) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,135),T3sum(1:35,21))
  M(7) = M(7) + (CI*f(5) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,135),T3sum(1:35,21))
  M(9) = M(9) + (-(CI*f(5)) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,135),T3sum(1:35,21))
  M(13) = M(13) + (CI*f(5) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,135),T3sum(1:35,21))
  M(20) = M(20) + (CI*f(5) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,135),T3sum(1:35,21))
  M(21) = M(21) + (-(CI*f(5)) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,135),T3sum(1:35,21))
  M(22) = M(22) + (CI*f(5) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,135),T3sum(1:35,21))
  M(23) = M(23) + (-(CI*f(5)) * den(40)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,135),T3sum(1:35,21))
  M(4) = M(4) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,139),T3sum(1:35,22))
  M(7) = M(7) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,139),T3sum(1:35,22))
  M(9) = M(9) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,139),T3sum(1:35,22))
  M(11) = M(11) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,139),T3sum(1:35,22))
  M(12) = M(12) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,139),T3sum(1:35,22))
  M(14) = M(14) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,139),T3sum(1:35,22))
  M(20) = M(20) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,139),T3sum(1:35,22))
  M(23) = M(23) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,139),T3sum(1:35,22))
  M(3) = M(3) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,140),T3sum(1:35,22))
  M(4) = M(4) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,140),T3sum(1:35,22))
  M(11) = M(11) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,140),T3sum(1:35,22))
  M(12) = M(12) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,140),T3sum(1:35,22))
  M(13) = M(13) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,140),T3sum(1:35,22))
  M(14) = M(14) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,140),T3sum(1:35,22))
  M(21) = M(21) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,140),T3sum(1:35,22))
  M(22) = M(22) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,140),T3sum(1:35,22))
  M(3) = M(3) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,141),T3sum(1:35,22))
  M(7) = M(7) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,141),T3sum(1:35,22))
  M(9) = M(9) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,141),T3sum(1:35,22))
  M(13) = M(13) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,141),T3sum(1:35,22))
  M(20) = M(20) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,141),T3sum(1:35,22))
  M(21) = M(21) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,141),T3sum(1:35,22))
  M(22) = M(22) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,141),T3sum(1:35,22))
  M(23) = M(23) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,141),T3sum(1:35,22))
  M(4) = M(4) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,145),T3sum(1:35,22))
  M(7) = M(7) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,145),T3sum(1:35,22))
  M(9) = M(9) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,145),T3sum(1:35,22))
  M(11) = M(11) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,145),T3sum(1:35,22))
  M(12) = M(12) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,145),T3sum(1:35,22))
  M(14) = M(14) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,145),T3sum(1:35,22))
  M(20) = M(20) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,145),T3sum(1:35,22))
  M(23) = M(23) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,145),T3sum(1:35,22))
  M(3) = M(3) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,146),T3sum(1:35,22))
  M(4) = M(4) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,146),T3sum(1:35,22))
  M(11) = M(11) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,146),T3sum(1:35,22))
  M(12) = M(12) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,146),T3sum(1:35,22))
  M(13) = M(13) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,146),T3sum(1:35,22))
  M(14) = M(14) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,146),T3sum(1:35,22))
  M(21) = M(21) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,146),T3sum(1:35,22))
  M(22) = M(22) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,146),T3sum(1:35,22))
  M(3) = M(3) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,147),T3sum(1:35,22))
  M(7) = M(7) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,147),T3sum(1:35,22))
  M(9) = M(9) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,147),T3sum(1:35,22))
  M(13) = M(13) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,147),T3sum(1:35,22))
  M(20) = M(20) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,147),T3sum(1:35,22))
  M(21) = M(21) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,147),T3sum(1:35,22))
  M(22) = M(22) + (CI*f(2) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,147),T3sum(1:35,22))
  M(23) = M(23) + (-(CI*f(2)) * den(40)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,147),T3sum(1:35,22))
  M(6) = M(6) + (CI*f(5) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,151),T3sum(1:35,23))
  M(8) = M(8) + (-(CI*f(5)) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,151),T3sum(1:35,23))
  M(9) = M(9) + (CI*f(5) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,151),T3sum(1:35,23))
  M(10) = M(10) + (-(CI*f(5)) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,151),T3sum(1:35,23))
  M(11) = M(11) + (CI*f(5) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,151),T3sum(1:35,23))
  M(14) = M(14) + (-(CI*f(5)) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,151),T3sum(1:35,23))
  M(17) = M(17) + (CI*f(5) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,151),T3sum(1:35,23))
  M(20) = M(20) + (-(CI*f(5)) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,151),T3sum(1:35,23))
  M(5) = M(5) + (CI*f(5) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,152),T3sum(1:35,23))
  M(6) = M(6) + (-(CI*f(5)) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,152),T3sum(1:35,23))
  M(9) = M(9) + (-(CI*f(5)) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,152),T3sum(1:35,23))
  M(10) = M(10) + (CI*f(5) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,152),T3sum(1:35,23))
  M(15) = M(15) + (CI*f(5) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,152),T3sum(1:35,23))
  M(16) = M(16) + (-(CI*f(5)) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,152),T3sum(1:35,23))
  M(19) = M(19) + (-(CI*f(5)) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,152),T3sum(1:35,23))
  M(20) = M(20) + (CI*f(5) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,152),T3sum(1:35,23))
  M(5) = M(5) + (-(CI*f(5)) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,153),T3sum(1:35,23))
  M(8) = M(8) + (CI*f(5) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,153),T3sum(1:35,23))
  M(11) = M(11) + (-(CI*f(5)) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,153),T3sum(1:35,23))
  M(14) = M(14) + (CI*f(5) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,153),T3sum(1:35,23))
  M(15) = M(15) + (-(CI*f(5)) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,153),T3sum(1:35,23))
  M(16) = M(16) + (CI*f(5) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,153),T3sum(1:35,23))
  M(17) = M(17) + (-(CI*f(5)) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,153),T3sum(1:35,23))
  M(19) = M(19) + (CI*f(5) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,153),T3sum(1:35,23))
  M(6) = M(6) + (CI*f(5) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,154),T3sum(1:35,23))
  M(8) = M(8) + (-(CI*f(5)) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,154),T3sum(1:35,23))
  M(9) = M(9) + (CI*f(5) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,154),T3sum(1:35,23))
  M(10) = M(10) + (-(CI*f(5)) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,154),T3sum(1:35,23))
  M(11) = M(11) + (CI*f(5) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,154),T3sum(1:35,23))
  M(14) = M(14) + (-(CI*f(5)) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,154),T3sum(1:35,23))
  M(17) = M(17) + (CI*f(5) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,154),T3sum(1:35,23))
  M(20) = M(20) + (-(CI*f(5)) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,154),T3sum(1:35,23))
  M(5) = M(5) + (CI*f(5) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,155),T3sum(1:35,23))
  M(6) = M(6) + (-(CI*f(5)) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,155),T3sum(1:35,23))
  M(9) = M(9) + (-(CI*f(5)) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,155),T3sum(1:35,23))
  M(10) = M(10) + (CI*f(5) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,155),T3sum(1:35,23))
  M(15) = M(15) + (CI*f(5) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,155),T3sum(1:35,23))
  M(16) = M(16) + (-(CI*f(5)) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,155),T3sum(1:35,23))
  M(19) = M(19) + (-(CI*f(5)) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,155),T3sum(1:35,23))
  M(20) = M(20) + (CI*f(5) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,155),T3sum(1:35,23))
  M(5) = M(5) + (-(CI*f(5)) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,156),T3sum(1:35,23))
  M(8) = M(8) + (CI*f(5) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,156),T3sum(1:35,23))
  M(11) = M(11) + (-(CI*f(5)) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,156),T3sum(1:35,23))
  M(14) = M(14) + (CI*f(5) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,156),T3sum(1:35,23))
  M(15) = M(15) + (-(CI*f(5)) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,156),T3sum(1:35,23))
  M(16) = M(16) + (CI*f(5) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,156),T3sum(1:35,23))
  M(17) = M(17) + (-(CI*f(5)) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,156),T3sum(1:35,23))
  M(19) = M(19) + (CI*f(5) * den(44)) * TI2_call(3,momenta_13,masses2_2,G3tensor(:,156),T3sum(1:35,23))
  M(6) = M(6) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,157),T3sum(1:35,24))
  M(8) = M(8) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,157),T3sum(1:35,24))
  M(9) = M(9) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,157),T3sum(1:35,24))
  M(10) = M(10) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,157),T3sum(1:35,24))
  M(11) = M(11) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,157),T3sum(1:35,24))
  M(14) = M(14) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,157),T3sum(1:35,24))
  M(17) = M(17) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,157),T3sum(1:35,24))
  M(20) = M(20) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,157),T3sum(1:35,24))
  M(5) = M(5) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,158),T3sum(1:35,24))
  M(6) = M(6) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,158),T3sum(1:35,24))
  M(9) = M(9) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,158),T3sum(1:35,24))
  M(10) = M(10) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,158),T3sum(1:35,24))
  M(15) = M(15) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,158),T3sum(1:35,24))
  M(16) = M(16) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,158),T3sum(1:35,24))
  M(19) = M(19) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,158),T3sum(1:35,24))
  M(20) = M(20) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,158),T3sum(1:35,24))
  M(5) = M(5) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,159),T3sum(1:35,24))
  M(8) = M(8) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,159),T3sum(1:35,24))
  M(11) = M(11) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,159),T3sum(1:35,24))
  M(14) = M(14) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,159),T3sum(1:35,24))
  M(15) = M(15) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,159),T3sum(1:35,24))
  M(16) = M(16) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,159),T3sum(1:35,24))
  M(17) = M(17) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,159),T3sum(1:35,24))
  M(19) = M(19) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,159),T3sum(1:35,24))
  M(6) = M(6) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,160),T3sum(1:35,24))
  M(8) = M(8) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,160),T3sum(1:35,24))
  M(9) = M(9) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,160),T3sum(1:35,24))
  M(10) = M(10) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,160),T3sum(1:35,24))
  M(11) = M(11) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,160),T3sum(1:35,24))
  M(14) = M(14) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,160),T3sum(1:35,24))
  M(17) = M(17) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,160),T3sum(1:35,24))
  M(20) = M(20) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,160),T3sum(1:35,24))
  M(5) = M(5) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,161),T3sum(1:35,24))
  M(6) = M(6) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,161),T3sum(1:35,24))
  M(9) = M(9) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,161),T3sum(1:35,24))
  M(10) = M(10) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,161),T3sum(1:35,24))
  M(15) = M(15) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,161),T3sum(1:35,24))
  M(16) = M(16) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,161),T3sum(1:35,24))
  M(19) = M(19) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,161),T3sum(1:35,24))
  M(20) = M(20) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,161),T3sum(1:35,24))
  M(5) = M(5) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,162),T3sum(1:35,24))
  M(8) = M(8) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,162),T3sum(1:35,24))
  M(11) = M(11) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,162),T3sum(1:35,24))
  M(14) = M(14) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,162),T3sum(1:35,24))
  M(15) = M(15) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,162),T3sum(1:35,24))
  M(16) = M(16) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,162),T3sum(1:35,24))
  M(17) = M(17) + (-(CI*f(2)) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,162),T3sum(1:35,24))
  M(19) = M(19) + (CI*f(2) * den(44)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,162),T3sum(1:35,24))
  M(6) = M(6) + (-(CI*f(5)) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,163),T3sum(1:35,5))
  M(8) = M(8) + (CI*f(5) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,163),T3sum(1:35,5))
  M(9) = M(9) + (-(CI*f(5)) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,163),T3sum(1:35,5))
  M(10) = M(10) + (CI*f(5) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,163),T3sum(1:35,5))
  M(11) = M(11) + (-(CI*f(5)) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,163),T3sum(1:35,5))
  M(14) = M(14) + (CI*f(5) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,163),T3sum(1:35,5))
  M(17) = M(17) + (-(CI*f(5)) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,163),T3sum(1:35,5))
  M(20) = M(20) + (CI*f(5) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,163),T3sum(1:35,5))
  M(5) = M(5) + (-(CI*f(5)) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,164),T3sum(1:35,5))
  M(6) = M(6) + (CI*f(5) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,164),T3sum(1:35,5))
  M(9) = M(9) + (CI*f(5) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,164),T3sum(1:35,5))
  M(10) = M(10) + (-(CI*f(5)) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,164),T3sum(1:35,5))
  M(15) = M(15) + (-(CI*f(5)) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,164),T3sum(1:35,5))
  M(16) = M(16) + (CI*f(5) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,164),T3sum(1:35,5))
  M(19) = M(19) + (CI*f(5) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,164),T3sum(1:35,5))
  M(20) = M(20) + (-(CI*f(5)) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,164),T3sum(1:35,5))
  M(5) = M(5) + (CI*f(5) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,165),T3sum(1:35,5))
  M(8) = M(8) + (-(CI*f(5)) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,165),T3sum(1:35,5))
  M(11) = M(11) + (CI*f(5) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,165),T3sum(1:35,5))
  M(14) = M(14) + (-(CI*f(5)) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,165),T3sum(1:35,5))
  M(15) = M(15) + (CI*f(5) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,165),T3sum(1:35,5))
  M(16) = M(16) + (-(CI*f(5)) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,165),T3sum(1:35,5))
  M(17) = M(17) + (CI*f(5) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,165),T3sum(1:35,5))
  M(19) = M(19) + (-(CI*f(5)) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,165),T3sum(1:35,5))
  M(6) = M(6) + (-(CI*f(5)) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,166),T3sum(1:35,5))
  M(8) = M(8) + (CI*f(5) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,166),T3sum(1:35,5))
  M(9) = M(9) + (-(CI*f(5)) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,166),T3sum(1:35,5))
  M(10) = M(10) + (CI*f(5) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,166),T3sum(1:35,5))
  M(11) = M(11) + (-(CI*f(5)) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,166),T3sum(1:35,5))
  M(14) = M(14) + (CI*f(5) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,166),T3sum(1:35,5))
  M(17) = M(17) + (-(CI*f(5)) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,166),T3sum(1:35,5))
  M(20) = M(20) + (CI*f(5) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,166),T3sum(1:35,5))
  M(5) = M(5) + (-(CI*f(5)) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,167),T3sum(1:35,5))
  M(6) = M(6) + (CI*f(5) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,167),T3sum(1:35,5))
  M(9) = M(9) + (CI*f(5) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,167),T3sum(1:35,5))
  M(10) = M(10) + (-(CI*f(5)) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,167),T3sum(1:35,5))
  M(15) = M(15) + (-(CI*f(5)) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,167),T3sum(1:35,5))
  M(16) = M(16) + (CI*f(5) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,167),T3sum(1:35,5))
  M(19) = M(19) + (CI*f(5) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,167),T3sum(1:35,5))
  M(20) = M(20) + (-(CI*f(5)) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,167),T3sum(1:35,5))
  M(5) = M(5) + (CI*f(5) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,168),T3sum(1:35,5))
  M(8) = M(8) + (-(CI*f(5)) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,168),T3sum(1:35,5))
  M(11) = M(11) + (CI*f(5) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,168),T3sum(1:35,5))
  M(14) = M(14) + (-(CI*f(5)) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,168),T3sum(1:35,5))
  M(15) = M(15) + (CI*f(5) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,168),T3sum(1:35,5))
  M(16) = M(16) + (-(CI*f(5)) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,168),T3sum(1:35,5))
  M(17) = M(17) + (CI*f(5) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,168),T3sum(1:35,5))
  M(19) = M(19) + (-(CI*f(5)) * den(289)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,168),T3sum(1:35,5))
  M(6) = M(6) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,169),T3sum(1:35,6))
  M(8) = M(8) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,169),T3sum(1:35,6))
  M(9) = M(9) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,169),T3sum(1:35,6))
  M(10) = M(10) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,169),T3sum(1:35,6))
  M(11) = M(11) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,169),T3sum(1:35,6))
  M(14) = M(14) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,169),T3sum(1:35,6))
  M(17) = M(17) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,169),T3sum(1:35,6))
  M(20) = M(20) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,169),T3sum(1:35,6))
  M(5) = M(5) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,170),T3sum(1:35,6))
  M(6) = M(6) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,170),T3sum(1:35,6))
  M(9) = M(9) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,170),T3sum(1:35,6))
  M(10) = M(10) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,170),T3sum(1:35,6))
  M(15) = M(15) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,170),T3sum(1:35,6))
  M(16) = M(16) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,170),T3sum(1:35,6))
  M(19) = M(19) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,170),T3sum(1:35,6))
  M(20) = M(20) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,170),T3sum(1:35,6))
  M(5) = M(5) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,171),T3sum(1:35,6))
  M(8) = M(8) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,171),T3sum(1:35,6))
  M(11) = M(11) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,171),T3sum(1:35,6))
  M(14) = M(14) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,171),T3sum(1:35,6))
  M(15) = M(15) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,171),T3sum(1:35,6))
  M(16) = M(16) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,171),T3sum(1:35,6))
  M(17) = M(17) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,171),T3sum(1:35,6))
  M(19) = M(19) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,171),T3sum(1:35,6))
  M(6) = M(6) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,172),T3sum(1:35,6))
  M(8) = M(8) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,172),T3sum(1:35,6))
  M(9) = M(9) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,172),T3sum(1:35,6))
  M(10) = M(10) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,172),T3sum(1:35,6))
  M(11) = M(11) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,172),T3sum(1:35,6))
  M(14) = M(14) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,172),T3sum(1:35,6))
  M(17) = M(17) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,172),T3sum(1:35,6))
  M(20) = M(20) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,172),T3sum(1:35,6))
  M(5) = M(5) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,173),T3sum(1:35,6))
  M(6) = M(6) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,173),T3sum(1:35,6))
  M(9) = M(9) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,173),T3sum(1:35,6))
  M(10) = M(10) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,173),T3sum(1:35,6))
  M(15) = M(15) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,173),T3sum(1:35,6))
  M(16) = M(16) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,173),T3sum(1:35,6))
  M(19) = M(19) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,173),T3sum(1:35,6))
  M(20) = M(20) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,173),T3sum(1:35,6))
  M(5) = M(5) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,174),T3sum(1:35,6))
  M(8) = M(8) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,174),T3sum(1:35,6))
  M(11) = M(11) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,174),T3sum(1:35,6))
  M(14) = M(14) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,174),T3sum(1:35,6))
  M(15) = M(15) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,174),T3sum(1:35,6))
  M(16) = M(16) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,174),T3sum(1:35,6))
  M(17) = M(17) + (CI*f(2) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,174),T3sum(1:35,6))
  M(19) = M(19) + (-(CI*f(2)) * den(289)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,174),T3sum(1:35,6))
  M(10) = M(10) + (-f(6) * den(43)) * TI2_call(4,momenta_89,masses2_4,G4tensor(:,72),T4sum(1:70,41))
  M(11) = M(11) + (f(6) * den(43)) * TI2_call(4,momenta_89,masses2_4,G4tensor(:,72),T4sum(1:70,41))
  M(17) = M(17) + (f(6) * den(43)) * TI2_call(4,momenta_89,masses2_4,G4tensor(:,72),T4sum(1:70,41))
  M(20) = M(20) + (-f(6) * den(43)) * TI2_call(4,momenta_89,masses2_4,G4tensor(:,72),T4sum(1:70,41))
  M(10) = M(10) + (f(6) * den(43)) * TI2_call(4,momenta_89,masses2_4,G4tensor(:,73),T4sum(1:70,41))
  M(16) = M(16) + (-f(6) * den(43)) * TI2_call(4,momenta_89,masses2_4,G4tensor(:,73),T4sum(1:70,41))
  M(19) = M(19) + (-f(6) * den(43)) * TI2_call(4,momenta_89,masses2_4,G4tensor(:,73),T4sum(1:70,41))
  M(20) = M(20) + (f(6) * den(43)) * TI2_call(4,momenta_89,masses2_4,G4tensor(:,73),T4sum(1:70,41))
  M(11) = M(11) + (-f(6) * den(43)) * TI2_call(4,momenta_89,masses2_4,G4tensor(:,74),T4sum(1:70,41))
  M(16) = M(16) + (f(6) * den(43)) * TI2_call(4,momenta_89,masses2_4,G4tensor(:,74),T4sum(1:70,41))
  M(17) = M(17) + (-f(6) * den(43)) * TI2_call(4,momenta_89,masses2_4,G4tensor(:,74),T4sum(1:70,41))
  M(19) = M(19) + (f(6) * den(43)) * TI2_call(4,momenta_89,masses2_4,G4tensor(:,74),T4sum(1:70,41))
  M(6) = M(6) + (-f(6) * den(43)) * TI2_call(4,momenta_89,masses2_4,G4tensor(:,75),T4sum(1:70,41))
  M(8) = M(8) + (f(6) * den(43)) * TI2_call(4,momenta_89,masses2_4,G4tensor(:,75),T4sum(1:70,41))
  M(9) = M(9) + (-f(6) * den(43)) * TI2_call(4,momenta_89,masses2_4,G4tensor(:,75),T4sum(1:70,41))
  M(14) = M(14) + (f(6) * den(43)) * TI2_call(4,momenta_89,masses2_4,G4tensor(:,75),T4sum(1:70,41))
  M(5) = M(5) + (-f(6) * den(43)) * TI2_call(4,momenta_89,masses2_4,G4tensor(:,76),T4sum(1:70,41))
  M(6) = M(6) + (f(6) * den(43)) * TI2_call(4,momenta_89,masses2_4,G4tensor(:,76),T4sum(1:70,41))
  M(9) = M(9) + (f(6) * den(43)) * TI2_call(4,momenta_89,masses2_4,G4tensor(:,76),T4sum(1:70,41))
  M(15) = M(15) + (-f(6) * den(43)) * TI2_call(4,momenta_89,masses2_4,G4tensor(:,76),T4sum(1:70,41))
  M(5) = M(5) + (f(6) * den(43)) * TI2_call(4,momenta_89,masses2_4,G4tensor(:,77),T4sum(1:70,41))
  M(8) = M(8) + (-f(6) * den(43)) * TI2_call(4,momenta_89,masses2_4,G4tensor(:,77),T4sum(1:70,41))
  M(14) = M(14) + (-f(6) * den(43)) * TI2_call(4,momenta_89,masses2_4,G4tensor(:,77),T4sum(1:70,41))
  M(15) = M(15) + (f(6) * den(43)) * TI2_call(4,momenta_89,masses2_4,G4tensor(:,77),T4sum(1:70,41))
  M(10) = M(10) + (-f(3) * den(43)) * TI2_call(4,momenta_89,masses2_3,G4tensor(:,78),T4sum(1:70,42))
  M(11) = M(11) + (f(3) * den(43)) * TI2_call(4,momenta_89,masses2_3,G4tensor(:,78),T4sum(1:70,42))
  M(17) = M(17) + (f(3) * den(43)) * TI2_call(4,momenta_89,masses2_3,G4tensor(:,78),T4sum(1:70,42))
  M(20) = M(20) + (-f(3) * den(43)) * TI2_call(4,momenta_89,masses2_3,G4tensor(:,78),T4sum(1:70,42))
  M(10) = M(10) + (f(3) * den(43)) * TI2_call(4,momenta_89,masses2_3,G4tensor(:,79),T4sum(1:70,42))
  M(16) = M(16) + (-f(3) * den(43)) * TI2_call(4,momenta_89,masses2_3,G4tensor(:,79),T4sum(1:70,42))
  M(19) = M(19) + (-f(3) * den(43)) * TI2_call(4,momenta_89,masses2_3,G4tensor(:,79),T4sum(1:70,42))
  M(20) = M(20) + (f(3) * den(43)) * TI2_call(4,momenta_89,masses2_3,G4tensor(:,79),T4sum(1:70,42))
  M(11) = M(11) + (-f(3) * den(43)) * TI2_call(4,momenta_89,masses2_3,G4tensor(:,80),T4sum(1:70,42))
  M(16) = M(16) + (f(3) * den(43)) * TI2_call(4,momenta_89,masses2_3,G4tensor(:,80),T4sum(1:70,42))
  M(17) = M(17) + (-f(3) * den(43)) * TI2_call(4,momenta_89,masses2_3,G4tensor(:,80),T4sum(1:70,42))
  M(19) = M(19) + (f(3) * den(43)) * TI2_call(4,momenta_89,masses2_3,G4tensor(:,80),T4sum(1:70,42))
  M(6) = M(6) + (-f(3) * den(43)) * TI2_call(4,momenta_89,masses2_3,G4tensor(:,81),T4sum(1:70,42))
  M(8) = M(8) + (f(3) * den(43)) * TI2_call(4,momenta_89,masses2_3,G4tensor(:,81),T4sum(1:70,42))
  M(9) = M(9) + (-f(3) * den(43)) * TI2_call(4,momenta_89,masses2_3,G4tensor(:,81),T4sum(1:70,42))
  M(14) = M(14) + (f(3) * den(43)) * TI2_call(4,momenta_89,masses2_3,G4tensor(:,81),T4sum(1:70,42))
  M(5) = M(5) + (-f(3) * den(43)) * TI2_call(4,momenta_89,masses2_3,G4tensor(:,82),T4sum(1:70,42))
  M(6) = M(6) + (f(3) * den(43)) * TI2_call(4,momenta_89,masses2_3,G4tensor(:,82),T4sum(1:70,42))
  M(9) = M(9) + (f(3) * den(43)) * TI2_call(4,momenta_89,masses2_3,G4tensor(:,82),T4sum(1:70,42))
  M(15) = M(15) + (-f(3) * den(43)) * TI2_call(4,momenta_89,masses2_3,G4tensor(:,82),T4sum(1:70,42))
  M(5) = M(5) + (f(3) * den(43)) * TI2_call(4,momenta_89,masses2_3,G4tensor(:,83),T4sum(1:70,42))
  M(8) = M(8) + (-f(3) * den(43)) * TI2_call(4,momenta_89,masses2_3,G4tensor(:,83),T4sum(1:70,42))
  M(14) = M(14) + (-f(3) * den(43)) * TI2_call(4,momenta_89,masses2_3,G4tensor(:,83),T4sum(1:70,42))
  M(15) = M(15) + (f(3) * den(43)) * TI2_call(4,momenta_89,masses2_3,G4tensor(:,83),T4sum(1:70,42))
  M(1) = M(1) + (CI*f(5) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,175),T3sum(1:35,5))
  M(3) = M(3) + (-(CI*f(5)) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,175),T3sum(1:35,5))
  M(5) = M(5) + (-(CI*f(5)) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,175),T3sum(1:35,5))
  M(6) = M(6) + (CI*f(5) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,175),T3sum(1:35,5))
  M(10) = M(10) + (-(CI*f(5)) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,175),T3sum(1:35,5))
  M(16) = M(16) + (CI*f(5) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,175),T3sum(1:35,5))
  M(22) = M(22) + (CI*f(5) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,175),T3sum(1:35,5))
  M(24) = M(24) + (-(CI*f(5)) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,175),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(5)) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,176),T3sum(1:35,5))
  M(3) = M(3) + (CI*f(5) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,176),T3sum(1:35,5))
  M(9) = M(9) + (CI*f(5) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,176),T3sum(1:35,5))
  M(15) = M(15) + (-(CI*f(5)) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,176),T3sum(1:35,5))
  M(19) = M(19) + (CI*f(5) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,176),T3sum(1:35,5))
  M(20) = M(20) + (-(CI*f(5)) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,176),T3sum(1:35,5))
  M(22) = M(22) + (-(CI*f(5)) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,176),T3sum(1:35,5))
  M(24) = M(24) + (CI*f(5) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,176),T3sum(1:35,5))
  M(5) = M(5) + (CI*f(5) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,177),T3sum(1:35,5))
  M(6) = M(6) + (-(CI*f(5)) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,177),T3sum(1:35,5))
  M(9) = M(9) + (-(CI*f(5)) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,177),T3sum(1:35,5))
  M(10) = M(10) + (CI*f(5) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,177),T3sum(1:35,5))
  M(15) = M(15) + (CI*f(5) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,177),T3sum(1:35,5))
  M(16) = M(16) + (-(CI*f(5)) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,177),T3sum(1:35,5))
  M(19) = M(19) + (-(CI*f(5)) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,177),T3sum(1:35,5))
  M(20) = M(20) + (CI*f(5) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,177),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(5) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,178),T3sum(1:35,5))
  M(3) = M(3) + (-(CI*f(5)) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,178),T3sum(1:35,5))
  M(5) = M(5) + (-(CI*f(5)) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,178),T3sum(1:35,5))
  M(6) = M(6) + (CI*f(5) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,178),T3sum(1:35,5))
  M(10) = M(10) + (-(CI*f(5)) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,178),T3sum(1:35,5))
  M(16) = M(16) + (CI*f(5) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,178),T3sum(1:35,5))
  M(22) = M(22) + (CI*f(5) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,178),T3sum(1:35,5))
  M(24) = M(24) + (-(CI*f(5)) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,178),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(5)) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,179),T3sum(1:35,5))
  M(3) = M(3) + (CI*f(5) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,179),T3sum(1:35,5))
  M(9) = M(9) + (CI*f(5) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,179),T3sum(1:35,5))
  M(15) = M(15) + (-(CI*f(5)) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,179),T3sum(1:35,5))
  M(19) = M(19) + (CI*f(5) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,179),T3sum(1:35,5))
  M(20) = M(20) + (-(CI*f(5)) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,179),T3sum(1:35,5))
  M(22) = M(22) + (-(CI*f(5)) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,179),T3sum(1:35,5))
  M(24) = M(24) + (CI*f(5) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,179),T3sum(1:35,5))
  M(5) = M(5) + (CI*f(5) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,180),T3sum(1:35,5))
  M(6) = M(6) + (-(CI*f(5)) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,180),T3sum(1:35,5))
  M(9) = M(9) + (-(CI*f(5)) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,180),T3sum(1:35,5))
  M(10) = M(10) + (CI*f(5) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,180),T3sum(1:35,5))
  M(15) = M(15) + (CI*f(5) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,180),T3sum(1:35,5))
  M(16) = M(16) + (-(CI*f(5)) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,180),T3sum(1:35,5))
  M(19) = M(19) + (-(CI*f(5)) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,180),T3sum(1:35,5))
  M(20) = M(20) + (CI*f(5) * den(291)) * TI2_call(3,momenta_15,masses2_2,G3tensor(:,180),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,181),T3sum(1:35,6))
  M(3) = M(3) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,181),T3sum(1:35,6))
  M(5) = M(5) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,181),T3sum(1:35,6))
  M(6) = M(6) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,181),T3sum(1:35,6))
  M(10) = M(10) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,181),T3sum(1:35,6))
  M(16) = M(16) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,181),T3sum(1:35,6))
  M(22) = M(22) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,181),T3sum(1:35,6))
  M(24) = M(24) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,181),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,182),T3sum(1:35,6))
  M(3) = M(3) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,182),T3sum(1:35,6))
  M(9) = M(9) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,182),T3sum(1:35,6))
  M(15) = M(15) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,182),T3sum(1:35,6))
  M(19) = M(19) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,182),T3sum(1:35,6))
  M(20) = M(20) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,182),T3sum(1:35,6))
  M(22) = M(22) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,182),T3sum(1:35,6))
  M(24) = M(24) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,182),T3sum(1:35,6))
  M(5) = M(5) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,183),T3sum(1:35,6))
  M(6) = M(6) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,183),T3sum(1:35,6))
  M(9) = M(9) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,183),T3sum(1:35,6))
  M(10) = M(10) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,183),T3sum(1:35,6))
  M(15) = M(15) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,183),T3sum(1:35,6))
  M(16) = M(16) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,183),T3sum(1:35,6))
  M(19) = M(19) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,183),T3sum(1:35,6))
  M(20) = M(20) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,183),T3sum(1:35,6))
  M(1) = M(1) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,184),T3sum(1:35,6))
  M(3) = M(3) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,184),T3sum(1:35,6))
  M(5) = M(5) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,184),T3sum(1:35,6))
  M(6) = M(6) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,184),T3sum(1:35,6))
  M(10) = M(10) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,184),T3sum(1:35,6))
  M(16) = M(16) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,184),T3sum(1:35,6))
  M(22) = M(22) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,184),T3sum(1:35,6))
  M(24) = M(24) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,184),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,185),T3sum(1:35,6))
  M(3) = M(3) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,185),T3sum(1:35,6))
  M(9) = M(9) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,185),T3sum(1:35,6))
  M(15) = M(15) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,185),T3sum(1:35,6))
  M(19) = M(19) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,185),T3sum(1:35,6))
  M(20) = M(20) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,185),T3sum(1:35,6))
  M(22) = M(22) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,185),T3sum(1:35,6))
  M(24) = M(24) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,185),T3sum(1:35,6))
  M(5) = M(5) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,186),T3sum(1:35,6))
  M(6) = M(6) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,186),T3sum(1:35,6))
  M(9) = M(9) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,186),T3sum(1:35,6))
  M(10) = M(10) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,186),T3sum(1:35,6))
  M(15) = M(15) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,186),T3sum(1:35,6))
  M(16) = M(16) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,186),T3sum(1:35,6))
  M(19) = M(19) + (-(CI*f(2)) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,186),T3sum(1:35,6))
  M(20) = M(20) + (CI*f(2) * den(291)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,186),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(5)) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,187),T3sum(1:35,25))
  M(3) = M(3) + (CI*f(5) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,187),T3sum(1:35,25))
  M(5) = M(5) + (CI*f(5) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,187),T3sum(1:35,25))
  M(6) = M(6) + (-(CI*f(5)) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,187),T3sum(1:35,25))
  M(10) = M(10) + (CI*f(5) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,187),T3sum(1:35,25))
  M(16) = M(16) + (-(CI*f(5)) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,187),T3sum(1:35,25))
  M(22) = M(22) + (-(CI*f(5)) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,187),T3sum(1:35,25))
  M(24) = M(24) + (CI*f(5) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,187),T3sum(1:35,25))
  M(5) = M(5) + (-(CI*f(5)) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,188),T3sum(1:35,25))
  M(6) = M(6) + (CI*f(5) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,188),T3sum(1:35,25))
  M(9) = M(9) + (CI*f(5) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,188),T3sum(1:35,25))
  M(10) = M(10) + (-(CI*f(5)) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,188),T3sum(1:35,25))
  M(15) = M(15) + (-(CI*f(5)) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,188),T3sum(1:35,25))
  M(16) = M(16) + (CI*f(5) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,188),T3sum(1:35,25))
  M(19) = M(19) + (CI*f(5) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,188),T3sum(1:35,25))
  M(20) = M(20) + (-(CI*f(5)) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,188),T3sum(1:35,25))
  M(1) = M(1) + (CI*f(5) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,189),T3sum(1:35,25))
  M(3) = M(3) + (-(CI*f(5)) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,189),T3sum(1:35,25))
  M(9) = M(9) + (-(CI*f(5)) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,189),T3sum(1:35,25))
  M(15) = M(15) + (CI*f(5) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,189),T3sum(1:35,25))
  M(19) = M(19) + (-(CI*f(5)) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,189),T3sum(1:35,25))
  M(20) = M(20) + (CI*f(5) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,189),T3sum(1:35,25))
  M(22) = M(22) + (CI*f(5) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,189),T3sum(1:35,25))
  M(24) = M(24) + (-(CI*f(5)) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,189),T3sum(1:35,25))
  M(1) = M(1) + (-(CI*f(5)) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,193),T3sum(1:35,25))
  M(3) = M(3) + (CI*f(5) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,193),T3sum(1:35,25))
  M(5) = M(5) + (CI*f(5) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,193),T3sum(1:35,25))
  M(6) = M(6) + (-(CI*f(5)) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,193),T3sum(1:35,25))
  M(10) = M(10) + (CI*f(5) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,193),T3sum(1:35,25))
  M(16) = M(16) + (-(CI*f(5)) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,193),T3sum(1:35,25))
  M(22) = M(22) + (-(CI*f(5)) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,193),T3sum(1:35,25))
  M(24) = M(24) + (CI*f(5) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,193),T3sum(1:35,25))
  M(5) = M(5) + (-(CI*f(5)) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,194),T3sum(1:35,25))
  M(6) = M(6) + (CI*f(5) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,194),T3sum(1:35,25))
  M(9) = M(9) + (CI*f(5) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,194),T3sum(1:35,25))
  M(10) = M(10) + (-(CI*f(5)) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,194),T3sum(1:35,25))
  M(15) = M(15) + (-(CI*f(5)) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,194),T3sum(1:35,25))
  M(16) = M(16) + (CI*f(5) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,194),T3sum(1:35,25))
  M(19) = M(19) + (CI*f(5) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,194),T3sum(1:35,25))
  M(20) = M(20) + (-(CI*f(5)) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,194),T3sum(1:35,25))
  M(1) = M(1) + (CI*f(5) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,195),T3sum(1:35,25))
  M(3) = M(3) + (-(CI*f(5)) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,195),T3sum(1:35,25))
  M(9) = M(9) + (-(CI*f(5)) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,195),T3sum(1:35,25))
  M(15) = M(15) + (CI*f(5) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,195),T3sum(1:35,25))
  M(19) = M(19) + (-(CI*f(5)) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,195),T3sum(1:35,25))
  M(20) = M(20) + (CI*f(5) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,195),T3sum(1:35,25))
  M(22) = M(22) + (CI*f(5) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,195),T3sum(1:35,25))
  M(24) = M(24) + (-(CI*f(5)) * den(53)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,195),T3sum(1:35,25))
  M(1) = M(1) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,199),T3sum(1:35,26))
  M(3) = M(3) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,199),T3sum(1:35,26))
  M(5) = M(5) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,199),T3sum(1:35,26))
  M(6) = M(6) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,199),T3sum(1:35,26))
  M(10) = M(10) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,199),T3sum(1:35,26))
  M(16) = M(16) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,199),T3sum(1:35,26))
  M(22) = M(22) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,199),T3sum(1:35,26))
  M(24) = M(24) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,199),T3sum(1:35,26))
  M(5) = M(5) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,200),T3sum(1:35,26))
  M(6) = M(6) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,200),T3sum(1:35,26))
  M(9) = M(9) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,200),T3sum(1:35,26))
  M(10) = M(10) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,200),T3sum(1:35,26))
  M(15) = M(15) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,200),T3sum(1:35,26))
  M(16) = M(16) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,200),T3sum(1:35,26))
  M(19) = M(19) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,200),T3sum(1:35,26))
  M(20) = M(20) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,200),T3sum(1:35,26))
  M(1) = M(1) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,201),T3sum(1:35,26))
  M(3) = M(3) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,201),T3sum(1:35,26))
  M(9) = M(9) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,201),T3sum(1:35,26))
  M(15) = M(15) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,201),T3sum(1:35,26))
  M(19) = M(19) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,201),T3sum(1:35,26))
  M(20) = M(20) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,201),T3sum(1:35,26))
  M(22) = M(22) + (CI*f(2) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,201),T3sum(1:35,26))
  M(24) = M(24) + (-(CI*f(2)) * den(53)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,201),T3sum(1:35,26))
  M(1) = M(1) + (-(CI*f(5)) * den(89)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,190),T3sum(1:35,25))
  M(3) = M(3) + (CI*f(5) * den(89)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,190),T3sum(1:35,25))
  M(5) = M(5) + (CI*f(5) * den(89)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,190),T3sum(1:35,25))
  M(6) = M(6) + (-(CI*f(5)) * den(89)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,190),T3sum(1:35,25))
  M(10) = M(10) + (CI*f(5) * den(89)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,190),T3sum(1:35,25))
  M(16) = M(16) + (-(CI*f(5)) * den(89)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,190),T3sum(1:35,25))
  M(22) = M(22) + (-(CI*f(5)) * den(89)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,190),T3sum(1:35,25))
  M(24) = M(24) + (CI*f(5) * den(89)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,190),T3sum(1:35,25))
  M(1) = M(1) + (-(CI*f(5)) * den(89)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,196),T3sum(1:35,25))
  M(3) = M(3) + (CI*f(5) * den(89)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,196),T3sum(1:35,25))
  M(5) = M(5) + (CI*f(5) * den(89)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,196),T3sum(1:35,25))
  M(6) = M(6) + (-(CI*f(5)) * den(89)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,196),T3sum(1:35,25))
  M(10) = M(10) + (CI*f(5) * den(89)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,196),T3sum(1:35,25))
  M(16) = M(16) + (-(CI*f(5)) * den(89)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,196),T3sum(1:35,25))
  M(22) = M(22) + (-(CI*f(5)) * den(89)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,196),T3sum(1:35,25))
  M(24) = M(24) + (CI*f(5) * den(89)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,196),T3sum(1:35,25))
  M(1) = M(1) + (-(CI*f(2)) * den(89)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,202),T3sum(1:35,26))
  M(3) = M(3) + (CI*f(2) * den(89)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,202),T3sum(1:35,26))
  M(5) = M(5) + (CI*f(2) * den(89)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,202),T3sum(1:35,26))
  M(6) = M(6) + (-(CI*f(2)) * den(89)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,202),T3sum(1:35,26))
  M(10) = M(10) + (CI*f(2) * den(89)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,202),T3sum(1:35,26))
  M(16) = M(16) + (-(CI*f(2)) * den(89)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,202),T3sum(1:35,26))
  M(22) = M(22) + (-(CI*f(2)) * den(89)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,202),T3sum(1:35,26))
  M(24) = M(24) + (CI*f(2) * den(89)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,202),T3sum(1:35,26))
  M(1) = M(1) + (-f(6) * den(300)) * TI2_call(4,momenta_88,masses2_4,G4tensor(:,87),T4sum(1:70,63))
  M(3) = M(3) + (f(6) * den(300)) * TI2_call(4,momenta_88,masses2_4,G4tensor(:,87),T4sum(1:70,63))
  M(10) = M(10) + (f(6) * den(300)) * TI2_call(4,momenta_88,masses2_4,G4tensor(:,87),T4sum(1:70,63))
  M(16) = M(16) + (-f(6) * den(300)) * TI2_call(4,momenta_88,masses2_4,G4tensor(:,87),T4sum(1:70,63))
  M(5) = M(5) + (-f(6) * den(300)) * TI2_call(4,momenta_88,masses2_4,G4tensor(:,84),T4sum(1:70,63))
  M(6) = M(6) + (f(6) * den(300)) * TI2_call(4,momenta_88,masses2_4,G4tensor(:,84),T4sum(1:70,63))
  M(22) = M(22) + (f(6) * den(300)) * TI2_call(4,momenta_88,masses2_4,G4tensor(:,84),T4sum(1:70,63))
  M(24) = M(24) + (-f(6) * den(300)) * TI2_call(4,momenta_88,masses2_4,G4tensor(:,84),T4sum(1:70,63))
  M(5) = M(5) + (-f(3) * den(300)) * TI2_call(4,momenta_88,masses2_3,G4tensor(:,90),T4sum(1:70,64))
  M(6) = M(6) + (f(3) * den(300)) * TI2_call(4,momenta_88,masses2_3,G4tensor(:,90),T4sum(1:70,64))
  M(22) = M(22) + (f(3) * den(300)) * TI2_call(4,momenta_88,masses2_3,G4tensor(:,90),T4sum(1:70,64))
  M(24) = M(24) + (-f(3) * den(300)) * TI2_call(4,momenta_88,masses2_3,G4tensor(:,90),T4sum(1:70,64))
  M(4) = M(4) + (CI*f(5) * den(115)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,130),T3sum(1:35,21))
  M(7) = M(7) + (-(CI*f(5)) * den(115)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,130),T3sum(1:35,21))
  M(9) = M(9) + (CI*f(5) * den(115)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,130),T3sum(1:35,21))
  M(11) = M(11) + (CI*f(5) * den(115)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,130),T3sum(1:35,21))
  M(12) = M(12) + (-(CI*f(5)) * den(115)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,130),T3sum(1:35,21))
  M(14) = M(14) + (-(CI*f(5)) * den(115)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,130),T3sum(1:35,21))
  M(20) = M(20) + (-(CI*f(5)) * den(115)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,130),T3sum(1:35,21))
  M(23) = M(23) + (CI*f(5) * den(115)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,130),T3sum(1:35,21))
  M(4) = M(4) + (CI*f(5) * den(115)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,136),T3sum(1:35,21))
  M(7) = M(7) + (-(CI*f(5)) * den(115)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,136),T3sum(1:35,21))
  M(9) = M(9) + (CI*f(5) * den(115)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,136),T3sum(1:35,21))
  M(11) = M(11) + (CI*f(5) * den(115)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,136),T3sum(1:35,21))
  M(12) = M(12) + (-(CI*f(5)) * den(115)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,136),T3sum(1:35,21))
  M(14) = M(14) + (-(CI*f(5)) * den(115)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,136),T3sum(1:35,21))
  M(20) = M(20) + (-(CI*f(5)) * den(115)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,136),T3sum(1:35,21))
  M(23) = M(23) + (CI*f(5) * den(115)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,136),T3sum(1:35,21))
  M(4) = M(4) + (CI*f(2) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,142),T3sum(1:35,22))
  M(7) = M(7) + (-(CI*f(2)) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,142),T3sum(1:35,22))
  M(9) = M(9) + (CI*f(2) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,142),T3sum(1:35,22))
  M(11) = M(11) + (CI*f(2) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,142),T3sum(1:35,22))
  M(12) = M(12) + (-(CI*f(2)) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,142),T3sum(1:35,22))
  M(14) = M(14) + (-(CI*f(2)) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,142),T3sum(1:35,22))
  M(20) = M(20) + (-(CI*f(2)) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,142),T3sum(1:35,22))
  M(23) = M(23) + (CI*f(2) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,142),T3sum(1:35,22))
  M(4) = M(4) + (CI*f(2) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,148),T3sum(1:35,22))
  M(7) = M(7) + (-(CI*f(2)) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,148),T3sum(1:35,22))
  M(9) = M(9) + (CI*f(2) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,148),T3sum(1:35,22))
  M(11) = M(11) + (CI*f(2) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,148),T3sum(1:35,22))
  M(12) = M(12) + (-(CI*f(2)) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,148),T3sum(1:35,22))
  M(14) = M(14) + (-(CI*f(2)) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,148),T3sum(1:35,22))
  M(20) = M(20) + (-(CI*f(2)) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,148),T3sum(1:35,22))
  M(23) = M(23) + (CI*f(2) * den(115)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,148),T3sum(1:35,22))
  M(4) = M(4) + (-(CI*f(5)) * den(113)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,4),T3sum(1:35,13))
  M(7) = M(7) + (CI*f(5) * den(113)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,4),T3sum(1:35,13))
  M(9) = M(9) + (-(CI*f(5)) * den(113)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,4),T3sum(1:35,13))
  M(11) = M(11) + (-(CI*f(5)) * den(113)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,4),T3sum(1:35,13))
  M(12) = M(12) + (CI*f(5) * den(113)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,4),T3sum(1:35,13))
  M(14) = M(14) + (CI*f(5) * den(113)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,4),T3sum(1:35,13))
  M(20) = M(20) + (CI*f(5) * den(113)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,4),T3sum(1:35,13))
  M(23) = M(23) + (-(CI*f(5)) * den(113)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,4),T3sum(1:35,13))
  M(4) = M(4) + (-(CI*f(2)) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,10),T3sum(1:35,14))
  M(7) = M(7) + (CI*f(2) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,10),T3sum(1:35,14))
  M(9) = M(9) + (-(CI*f(2)) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,10),T3sum(1:35,14))
  M(11) = M(11) + (-(CI*f(2)) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,10),T3sum(1:35,14))
  M(12) = M(12) + (CI*f(2) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,10),T3sum(1:35,14))
  M(14) = M(14) + (CI*f(2) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,10),T3sum(1:35,14))
  M(20) = M(20) + (CI*f(2) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,10),T3sum(1:35,14))
  M(23) = M(23) + (-(CI*f(2)) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,10),T3sum(1:35,14))
  M(4) = M(4) + (-(CI*f(2)) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,16),T3sum(1:35,14))
  M(7) = M(7) + (CI*f(2) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,16),T3sum(1:35,14))
  M(9) = M(9) + (-(CI*f(2)) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,16),T3sum(1:35,14))
  M(11) = M(11) + (-(CI*f(2)) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,16),T3sum(1:35,14))
  M(12) = M(12) + (CI*f(2) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,16),T3sum(1:35,14))
  M(14) = M(14) + (CI*f(2) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,16),T3sum(1:35,14))
  M(20) = M(20) + (CI*f(2) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,16),T3sum(1:35,14))
  M(23) = M(23) + (-(CI*f(2)) * den(113)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,16),T3sum(1:35,14))
  M(11) = M(11) + (-f(6) * den(312)) * TI2_call(4,momenta_62,masses2_4,G4tensor(:,1),T4sum(1:70,79))
  M(12) = M(12) + (f(6) * den(312)) * TI2_call(4,momenta_62,masses2_4,G4tensor(:,1),T4sum(1:70,79))
  M(20) = M(20) + (f(6) * den(312)) * TI2_call(4,momenta_62,masses2_4,G4tensor(:,1),T4sum(1:70,79))
  M(23) = M(23) + (-f(6) * den(312)) * TI2_call(4,momenta_62,masses2_4,G4tensor(:,1),T4sum(1:70,79))
  M(11) = M(11) + (-f(3) * den(312)) * TI2_call(4,momenta_62,masses2_3,G4tensor(:,11),T4sum(1:70,80))
  M(12) = M(12) + (f(3) * den(312)) * TI2_call(4,momenta_62,masses2_3,G4tensor(:,11),T4sum(1:70,80))
  M(20) = M(20) + (f(3) * den(312)) * TI2_call(4,momenta_62,masses2_3,G4tensor(:,11),T4sum(1:70,80))
  M(23) = M(23) + (-f(3) * den(312)) * TI2_call(4,momenta_62,masses2_3,G4tensor(:,11),T4sum(1:70,80))
  M(4) = M(4) + (f(3) * den(312)) * TI2_call(4,momenta_62,masses2_3,G4tensor(:,6),T4sum(1:70,80))
  M(7) = M(7) + (-f(3) * den(312)) * TI2_call(4,momenta_62,masses2_3,G4tensor(:,6),T4sum(1:70,80))
  M(9) = M(9) + (f(3) * den(312)) * TI2_call(4,momenta_62,masses2_3,G4tensor(:,6),T4sum(1:70,80))
  M(14) = M(14) + (-f(3) * den(312)) * TI2_call(4,momenta_62,masses2_3,G4tensor(:,6),T4sum(1:70,80))
  M(4) = M(4) + (f(6) * den(312)) * TI2_call(4,momenta_84,masses2_4,G4tensor(:,63),T4sum(1:70,81))
  M(7) = M(7) + (-f(6) * den(312)) * TI2_call(4,momenta_84,masses2_4,G4tensor(:,63),T4sum(1:70,81))
  M(9) = M(9) + (f(6) * den(312)) * TI2_call(4,momenta_84,masses2_4,G4tensor(:,63),T4sum(1:70,81))
  M(14) = M(14) + (-f(6) * den(312)) * TI2_call(4,momenta_84,masses2_4,G4tensor(:,63),T4sum(1:70,81))
  M(11) = M(11) + (-f(6) * den(312)) * TI2_call(4,momenta_84,masses2_4,G4tensor(:,60),T4sum(1:70,81))
  M(12) = M(12) + (f(6) * den(312)) * TI2_call(4,momenta_84,masses2_4,G4tensor(:,60),T4sum(1:70,81))
  M(20) = M(20) + (f(6) * den(312)) * TI2_call(4,momenta_84,masses2_4,G4tensor(:,60),T4sum(1:70,81))
  M(23) = M(23) + (-f(6) * den(312)) * TI2_call(4,momenta_84,masses2_4,G4tensor(:,60),T4sum(1:70,81))
  M(4) = M(4) + (f(3) * den(312)) * TI2_call(4,momenta_84,masses2_3,G4tensor(:,69),T4sum(1:70,82))
  M(7) = M(7) + (-f(3) * den(312)) * TI2_call(4,momenta_84,masses2_3,G4tensor(:,69),T4sum(1:70,82))
  M(9) = M(9) + (f(3) * den(312)) * TI2_call(4,momenta_84,masses2_3,G4tensor(:,69),T4sum(1:70,82))
  M(14) = M(14) + (-f(3) * den(312)) * TI2_call(4,momenta_84,masses2_3,G4tensor(:,69),T4sum(1:70,82))
  M(11) = M(11) + (-f(3) * den(312)) * TI2_call(4,momenta_84,masses2_3,G4tensor(:,66),T4sum(1:70,82))
  M(12) = M(12) + (f(3) * den(312)) * TI2_call(4,momenta_84,masses2_3,G4tensor(:,66),T4sum(1:70,82))
  M(20) = M(20) + (f(3) * den(312)) * TI2_call(4,momenta_84,masses2_3,G4tensor(:,66),T4sum(1:70,82))
  M(23) = M(23) + (-f(3) * den(312)) * TI2_call(4,momenta_84,masses2_3,G4tensor(:,66),T4sum(1:70,82))
  M(4) = M(4) + (f(6) * den(312)) * TI2_call(4,momenta_63,masses2_4,G4tensor(:,2),T4sum(1:70,83))
  M(7) = M(7) + (-f(6) * den(312)) * TI2_call(4,momenta_63,masses2_4,G4tensor(:,2),T4sum(1:70,83))
  M(9) = M(9) + (f(6) * den(312)) * TI2_call(4,momenta_63,masses2_4,G4tensor(:,2),T4sum(1:70,83))
  M(14) = M(14) + (-f(6) * den(312)) * TI2_call(4,momenta_63,masses2_4,G4tensor(:,2),T4sum(1:70,83))
  M(11) = M(11) + (-f(3) * den(312)) * TI2_call(4,momenta_63,masses2_3,G4tensor(:,7),T4sum(1:70,84))
  M(12) = M(12) + (f(3) * den(312)) * TI2_call(4,momenta_63,masses2_3,G4tensor(:,7),T4sum(1:70,84))
  M(20) = M(20) + (f(3) * den(312)) * TI2_call(4,momenta_63,masses2_3,G4tensor(:,7),T4sum(1:70,84))
  M(23) = M(23) + (-f(3) * den(312)) * TI2_call(4,momenta_63,masses2_3,G4tensor(:,7),T4sum(1:70,84))
  M(4) = M(4) + (f(3) * den(312)) * TI2_call(4,momenta_63,masses2_3,G4tensor(:,12),T4sum(1:70,84))
  M(7) = M(7) + (-f(3) * den(312)) * TI2_call(4,momenta_63,masses2_3,G4tensor(:,12),T4sum(1:70,84))
  M(9) = M(9) + (f(3) * den(312)) * TI2_call(4,momenta_63,masses2_3,G4tensor(:,12),T4sum(1:70,84))
  M(14) = M(14) + (-f(3) * den(312)) * TI2_call(4,momenta_63,masses2_3,G4tensor(:,12),T4sum(1:70,84))
  M(6) = M(6) + (CI*f(5) * den(118)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,5),T3sum(1:35,13))
  M(8) = M(8) + (-(CI*f(5)) * den(118)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,5),T3sum(1:35,13))
  M(9) = M(9) + (CI*f(5) * den(118)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,5),T3sum(1:35,13))
  M(10) = M(10) + (-(CI*f(5)) * den(118)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,5),T3sum(1:35,13))
  M(11) = M(11) + (CI*f(5) * den(118)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,5),T3sum(1:35,13))
  M(14) = M(14) + (-(CI*f(5)) * den(118)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,5),T3sum(1:35,13))
  M(17) = M(17) + (CI*f(5) * den(118)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,5),T3sum(1:35,13))
  M(20) = M(20) + (-(CI*f(5)) * den(118)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,5),T3sum(1:35,13))
  M(6) = M(6) + (CI*f(2) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,11),T3sum(1:35,14))
  M(8) = M(8) + (-(CI*f(2)) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,11),T3sum(1:35,14))
  M(9) = M(9) + (CI*f(2) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,11),T3sum(1:35,14))
  M(10) = M(10) + (-(CI*f(2)) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,11),T3sum(1:35,14))
  M(11) = M(11) + (CI*f(2) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,11),T3sum(1:35,14))
  M(14) = M(14) + (-(CI*f(2)) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,11),T3sum(1:35,14))
  M(17) = M(17) + (CI*f(2) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,11),T3sum(1:35,14))
  M(20) = M(20) + (-(CI*f(2)) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,11),T3sum(1:35,14))
  M(6) = M(6) + (CI*f(2) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,17),T3sum(1:35,14))
  M(8) = M(8) + (-(CI*f(2)) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,17),T3sum(1:35,14))
  M(9) = M(9) + (CI*f(2) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,17),T3sum(1:35,14))
  M(10) = M(10) + (-(CI*f(2)) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,17),T3sum(1:35,14))
  M(11) = M(11) + (CI*f(2) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,17),T3sum(1:35,14))
  M(14) = M(14) + (-(CI*f(2)) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,17),T3sum(1:35,14))
  M(17) = M(17) + (CI*f(2) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,17),T3sum(1:35,14))
  M(20) = M(20) + (-(CI*f(2)) * den(118)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,17),T3sum(1:35,14))
  M(9) = M(9) + (-f(6) * den(314)) * TI2_call(4,momenta_64,masses2_4,G4tensor(:,3),T4sum(1:70,85))
  M(10) = M(10) + (f(6) * den(314)) * TI2_call(4,momenta_64,masses2_4,G4tensor(:,3),T4sum(1:70,85))
  M(14) = M(14) + (f(6) * den(314)) * TI2_call(4,momenta_64,masses2_4,G4tensor(:,3),T4sum(1:70,85))
  M(17) = M(17) + (-f(6) * den(314)) * TI2_call(4,momenta_64,masses2_4,G4tensor(:,3),T4sum(1:70,85))
  M(9) = M(9) + (-f(3) * den(314)) * TI2_call(4,momenta_64,masses2_3,G4tensor(:,13),T4sum(1:70,86))
  M(10) = M(10) + (f(3) * den(314)) * TI2_call(4,momenta_64,masses2_3,G4tensor(:,13),T4sum(1:70,86))
  M(14) = M(14) + (f(3) * den(314)) * TI2_call(4,momenta_64,masses2_3,G4tensor(:,13),T4sum(1:70,86))
  M(17) = M(17) + (-f(3) * den(314)) * TI2_call(4,momenta_64,masses2_3,G4tensor(:,13),T4sum(1:70,86))
  M(6) = M(6) + (f(3) * den(314)) * TI2_call(4,momenta_64,masses2_3,G4tensor(:,8),T4sum(1:70,86))
  M(8) = M(8) + (-f(3) * den(314)) * TI2_call(4,momenta_64,masses2_3,G4tensor(:,8),T4sum(1:70,86))
  M(11) = M(11) + (f(3) * den(314)) * TI2_call(4,momenta_64,masses2_3,G4tensor(:,8),T4sum(1:70,86))
  M(20) = M(20) + (-f(3) * den(314)) * TI2_call(4,momenta_64,masses2_3,G4tensor(:,8),T4sum(1:70,86))
  M(6) = M(6) + (f(6) * den(314)) * TI2_call(4,momenta_61,masses2_4,G4tensor(:,4),T4sum(1:70,89))
  M(8) = M(8) + (-f(6) * den(314)) * TI2_call(4,momenta_61,masses2_4,G4tensor(:,4),T4sum(1:70,89))
  M(11) = M(11) + (f(6) * den(314)) * TI2_call(4,momenta_61,masses2_4,G4tensor(:,4),T4sum(1:70,89))
  M(20) = M(20) + (-f(6) * den(314)) * TI2_call(4,momenta_61,masses2_4,G4tensor(:,4),T4sum(1:70,89))
  M(9) = M(9) + (-f(3) * den(314)) * TI2_call(4,momenta_61,masses2_3,G4tensor(:,9),T4sum(1:70,90))
  M(10) = M(10) + (f(3) * den(314)) * TI2_call(4,momenta_61,masses2_3,G4tensor(:,9),T4sum(1:70,90))
  M(14) = M(14) + (f(3) * den(314)) * TI2_call(4,momenta_61,masses2_3,G4tensor(:,9),T4sum(1:70,90))
  M(17) = M(17) + (-f(3) * den(314)) * TI2_call(4,momenta_61,masses2_3,G4tensor(:,9),T4sum(1:70,90))
  M(6) = M(6) + (f(3) * den(314)) * TI2_call(4,momenta_61,masses2_3,G4tensor(:,14),T4sum(1:70,90))
  M(8) = M(8) + (-f(3) * den(314)) * TI2_call(4,momenta_61,masses2_3,G4tensor(:,14),T4sum(1:70,90))
  M(11) = M(11) + (f(3) * den(314)) * TI2_call(4,momenta_61,masses2_3,G4tensor(:,14),T4sum(1:70,90))
  M(20) = M(20) + (-f(3) * den(314)) * TI2_call(4,momenta_61,masses2_3,G4tensor(:,14),T4sum(1:70,90))
  M(4) = M(4) + (-(CI*f(5)) * den(122)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,6),T3sum(1:35,13))
  M(6) = M(6) + (CI*f(5) * den(122)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,6),T3sum(1:35,13))
  M(7) = M(7) + (CI*f(5) * den(122)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,6),T3sum(1:35,13))
  M(8) = M(8) + (-(CI*f(5)) * den(122)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,6),T3sum(1:35,13))
  M(10) = M(10) + (-(CI*f(5)) * den(122)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,6),T3sum(1:35,13))
  M(12) = M(12) + (CI*f(5) * den(122)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,6),T3sum(1:35,13))
  M(17) = M(17) + (CI*f(5) * den(122)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,6),T3sum(1:35,13))
  M(23) = M(23) + (-(CI*f(5)) * den(122)) * TI2_call(3,momenta_5,masses2_2,G3tensor(:,6),T3sum(1:35,13))
  M(4) = M(4) + (-(CI*f(2)) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,12),T3sum(1:35,14))
  M(6) = M(6) + (CI*f(2) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,12),T3sum(1:35,14))
  M(7) = M(7) + (CI*f(2) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,12),T3sum(1:35,14))
  M(8) = M(8) + (-(CI*f(2)) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,12),T3sum(1:35,14))
  M(10) = M(10) + (-(CI*f(2)) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,12),T3sum(1:35,14))
  M(12) = M(12) + (CI*f(2) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,12),T3sum(1:35,14))
  M(17) = M(17) + (CI*f(2) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,12),T3sum(1:35,14))
  M(23) = M(23) + (-(CI*f(2)) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,12),T3sum(1:35,14))
  M(4) = M(4) + (-(CI*f(2)) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,18),T3sum(1:35,14))
  M(6) = M(6) + (CI*f(2) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,18),T3sum(1:35,14))
  M(7) = M(7) + (CI*f(2) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,18),T3sum(1:35,14))
  M(8) = M(8) + (-(CI*f(2)) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,18),T3sum(1:35,14))
  M(10) = M(10) + (-(CI*f(2)) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,18),T3sum(1:35,14))
  M(12) = M(12) + (CI*f(2) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,18),T3sum(1:35,14))
  M(17) = M(17) + (CI*f(2) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,18),T3sum(1:35,14))
  M(23) = M(23) + (-(CI*f(2)) * den(122)) * TI2_call(3,momenta_5,masses2_1,G3tensor(:,18),T3sum(1:35,14))
  M(10) = M(10) + (-f(6) * den(316)) * TI2_call(4,momenta_60,masses2_4,G4tensor(:,5),T4sum(1:70,95))
  M(12) = M(12) + (f(6) * den(316)) * TI2_call(4,momenta_60,masses2_4,G4tensor(:,5),T4sum(1:70,95))
  M(17) = M(17) + (f(6) * den(316)) * TI2_call(4,momenta_60,masses2_4,G4tensor(:,5),T4sum(1:70,95))
  M(23) = M(23) + (-f(6) * den(316)) * TI2_call(4,momenta_60,masses2_4,G4tensor(:,5),T4sum(1:70,95))
  M(4) = M(4) + (f(3) * den(316)) * TI2_call(4,momenta_60,masses2_3,G4tensor(:,10),T4sum(1:70,96))
  M(6) = M(6) + (-f(3) * den(316)) * TI2_call(4,momenta_60,masses2_3,G4tensor(:,10),T4sum(1:70,96))
  M(7) = M(7) + (-f(3) * den(316)) * TI2_call(4,momenta_60,masses2_3,G4tensor(:,10),T4sum(1:70,96))
  M(8) = M(8) + (f(3) * den(316)) * TI2_call(4,momenta_60,masses2_3,G4tensor(:,10),T4sum(1:70,96))
  M(10) = M(10) + (-f(3) * den(316)) * TI2_call(4,momenta_60,masses2_3,G4tensor(:,15),T4sum(1:70,96))
  M(12) = M(12) + (f(3) * den(316)) * TI2_call(4,momenta_60,masses2_3,G4tensor(:,15),T4sum(1:70,96))
  M(17) = M(17) + (f(3) * den(316)) * TI2_call(4,momenta_60,masses2_3,G4tensor(:,15),T4sum(1:70,96))
  M(23) = M(23) + (-f(3) * den(316)) * TI2_call(4,momenta_60,masses2_3,G4tensor(:,15),T4sum(1:70,96))
  M(9) = M(9) + (CI*f(5) * den(10)) * TI2_call(5,momenta_188,masses2_6,G5tensor(:,1),T5sum(1:126,41))
  M(14) = M(14) + (-(CI*f(5)) * den(10)) * TI2_call(5,momenta_188,masses2_6,G5tensor(:,1),T5sum(1:126,41))
  M(9) = M(9) + (CI*f(2) * den(10)) * TI2_call(5,momenta_188,masses2_5,G5tensor(:,9),T5sum(1:126,42))
  M(14) = M(14) + (-(CI*f(2)) * den(10)) * TI2_call(5,momenta_188,masses2_5,G5tensor(:,9),T5sum(1:126,42))
  M(11) = M(11) + (CI*f(2) * den(10)) * TI2_call(5,momenta_188,masses2_5,G5tensor(:,5),T5sum(1:126,42))
  M(20) = M(20) + (-(CI*f(2)) * den(10)) * TI2_call(5,momenta_188,masses2_5,G5tensor(:,5),T5sum(1:126,42))
  M(10) = M(10) + (CI*f(5) * den(10)) * TI2_call(5,momenta_186,masses2_6,G5tensor(:,3),T5sum(1:126,43))
  M(17) = M(17) + (-(CI*f(5)) * den(10)) * TI2_call(5,momenta_186,masses2_6,G5tensor(:,3),T5sum(1:126,43))
  M(10) = M(10) + (CI*f(2) * den(10)) * TI2_call(5,momenta_186,masses2_5,G5tensor(:,11),T5sum(1:126,44))
  M(17) = M(17) + (-(CI*f(2)) * den(10)) * TI2_call(5,momenta_186,masses2_5,G5tensor(:,11),T5sum(1:126,44))
  M(6) = M(6) + (-(CI*f(2)) * den(10)) * TI2_call(5,momenta_186,masses2_5,G5tensor(:,7),T5sum(1:126,44))
  M(8) = M(8) + (CI*f(2) * den(10)) * TI2_call(5,momenta_186,masses2_5,G5tensor(:,7),T5sum(1:126,44))
  M(11) = M(11) + (CI*f(5) * den(10)) * TI2_call(5,momenta_187,masses2_6,G5tensor(:,2),T5sum(1:126,45))
  M(20) = M(20) + (-(CI*f(5)) * den(10)) * TI2_call(5,momenta_187,masses2_6,G5tensor(:,2),T5sum(1:126,45))
  M(11) = M(11) + (CI*f(2) * den(10)) * TI2_call(5,momenta_187,masses2_5,G5tensor(:,10),T5sum(1:126,46))
  M(20) = M(20) + (-(CI*f(2)) * den(10)) * TI2_call(5,momenta_187,masses2_5,G5tensor(:,10),T5sum(1:126,46))
  M(9) = M(9) + (CI*f(2) * den(10)) * TI2_call(5,momenta_187,masses2_5,G5tensor(:,6),T5sum(1:126,46))
  M(14) = M(14) + (-(CI*f(2)) * den(10)) * TI2_call(5,momenta_187,masses2_5,G5tensor(:,6),T5sum(1:126,46))
  M(12) = M(12) + (CI*f(5) * den(10)) * TI2_call(5,momenta_185,masses2_6,G5tensor(:,4),T5sum(1:126,47))
  M(23) = M(23) + (-(CI*f(5)) * den(10)) * TI2_call(5,momenta_185,masses2_6,G5tensor(:,4),T5sum(1:126,47))
  M(12) = M(12) + (CI*f(2) * den(10)) * TI2_call(5,momenta_185,masses2_5,G5tensor(:,12),T5sum(1:126,48))
  M(23) = M(23) + (-(CI*f(2)) * den(10)) * TI2_call(5,momenta_185,masses2_5,G5tensor(:,12),T5sum(1:126,48))
  M(4) = M(4) + (-(CI*f(2)) * den(10)) * TI2_call(5,momenta_185,masses2_5,G5tensor(:,8),T5sum(1:126,48))
  M(7) = M(7) + (CI*f(2) * den(10)) * TI2_call(5,momenta_185,masses2_5,G5tensor(:,8),T5sum(1:126,48))
  M(2) = M(2) + (CI*f(5) * den(137)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,94),T3sum(1:35,19))
  M(8) = M(8) + (-(CI*f(5)) * den(137)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,94),T3sum(1:35,19))
  M(13) = M(13) + (-(CI*f(5)) * den(137)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,94),T3sum(1:35,19))
  M(15) = M(15) + (CI*f(5) * den(137)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,94),T3sum(1:35,19))
  M(17) = M(17) + (CI*f(5) * den(137)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,94),T3sum(1:35,19))
  M(18) = M(18) + (-(CI*f(5)) * den(137)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,94),T3sum(1:35,19))
  M(19) = M(19) + (-(CI*f(5)) * den(137)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,94),T3sum(1:35,19))
  M(21) = M(21) + (CI*f(5) * den(137)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,94),T3sum(1:35,19))
  M(2) = M(2) + (CI*f(5) * den(137)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,100),T3sum(1:35,19))
  M(8) = M(8) + (-(CI*f(5)) * den(137)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,100),T3sum(1:35,19))
  M(13) = M(13) + (-(CI*f(5)) * den(137)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,100),T3sum(1:35,19))
  M(15) = M(15) + (CI*f(5) * den(137)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,100),T3sum(1:35,19))
  M(17) = M(17) + (CI*f(5) * den(137)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,100),T3sum(1:35,19))
  M(18) = M(18) + (-(CI*f(5)) * den(137)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,100),T3sum(1:35,19))
  M(19) = M(19) + (-(CI*f(5)) * den(137)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,100),T3sum(1:35,19))
  M(21) = M(21) + (CI*f(5) * den(137)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,100),T3sum(1:35,19))
  M(2) = M(2) + (CI*f(2) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,106),T3sum(1:35,20))
  M(8) = M(8) + (-(CI*f(2)) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,106),T3sum(1:35,20))
  M(13) = M(13) + (-(CI*f(2)) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,106),T3sum(1:35,20))
  M(15) = M(15) + (CI*f(2) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,106),T3sum(1:35,20))
  M(17) = M(17) + (CI*f(2) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,106),T3sum(1:35,20))
  M(18) = M(18) + (-(CI*f(2)) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,106),T3sum(1:35,20))
  M(19) = M(19) + (-(CI*f(2)) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,106),T3sum(1:35,20))
  M(21) = M(21) + (CI*f(2) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,106),T3sum(1:35,20))
  M(2) = M(2) + (CI*f(2) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,112),T3sum(1:35,20))
  M(8) = M(8) + (-(CI*f(2)) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,112),T3sum(1:35,20))
  M(13) = M(13) + (-(CI*f(2)) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,112),T3sum(1:35,20))
  M(15) = M(15) + (CI*f(2) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,112),T3sum(1:35,20))
  M(17) = M(17) + (CI*f(2) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,112),T3sum(1:35,20))
  M(18) = M(18) + (-(CI*f(2)) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,112),T3sum(1:35,20))
  M(19) = M(19) + (-(CI*f(2)) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,112),T3sum(1:35,20))
  M(21) = M(21) + (CI*f(2) * den(137)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,112),T3sum(1:35,20))
  M(2) = M(2) + (-(CI*f(5)) * den(135)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,34),T3sum(1:35,15))
  M(8) = M(8) + (CI*f(5) * den(135)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,34),T3sum(1:35,15))
  M(13) = M(13) + (CI*f(5) * den(135)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,34),T3sum(1:35,15))
  M(15) = M(15) + (-(CI*f(5)) * den(135)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,34),T3sum(1:35,15))
  M(17) = M(17) + (-(CI*f(5)) * den(135)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,34),T3sum(1:35,15))
  M(18) = M(18) + (CI*f(5) * den(135)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,34),T3sum(1:35,15))
  M(19) = M(19) + (CI*f(5) * den(135)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,34),T3sum(1:35,15))
  M(21) = M(21) + (-(CI*f(5)) * den(135)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,34),T3sum(1:35,15))
  M(2) = M(2) + (-(CI*f(5)) * den(135)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,40),T3sum(1:35,15))
  M(8) = M(8) + (CI*f(5) * den(135)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,40),T3sum(1:35,15))
  M(13) = M(13) + (CI*f(5) * den(135)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,40),T3sum(1:35,15))
  M(15) = M(15) + (-(CI*f(5)) * den(135)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,40),T3sum(1:35,15))
  M(17) = M(17) + (-(CI*f(5)) * den(135)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,40),T3sum(1:35,15))
  M(18) = M(18) + (CI*f(5) * den(135)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,40),T3sum(1:35,15))
  M(19) = M(19) + (CI*f(5) * den(135)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,40),T3sum(1:35,15))
  M(21) = M(21) + (-(CI*f(5)) * den(135)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,40),T3sum(1:35,15))
  M(2) = M(2) + (-(CI*f(2)) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,46),T3sum(1:35,16))
  M(8) = M(8) + (CI*f(2) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,46),T3sum(1:35,16))
  M(13) = M(13) + (CI*f(2) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,46),T3sum(1:35,16))
  M(15) = M(15) + (-(CI*f(2)) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,46),T3sum(1:35,16))
  M(17) = M(17) + (-(CI*f(2)) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,46),T3sum(1:35,16))
  M(18) = M(18) + (CI*f(2) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,46),T3sum(1:35,16))
  M(19) = M(19) + (CI*f(2) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,46),T3sum(1:35,16))
  M(21) = M(21) + (-(CI*f(2)) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,46),T3sum(1:35,16))
  M(2) = M(2) + (-(CI*f(2)) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,52),T3sum(1:35,16))
  M(8) = M(8) + (CI*f(2) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,52),T3sum(1:35,16))
  M(13) = M(13) + (CI*f(2) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,52),T3sum(1:35,16))
  M(15) = M(15) + (-(CI*f(2)) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,52),T3sum(1:35,16))
  M(17) = M(17) + (-(CI*f(2)) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,52),T3sum(1:35,16))
  M(18) = M(18) + (CI*f(2) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,52),T3sum(1:35,16))
  M(19) = M(19) + (CI*f(2) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,52),T3sum(1:35,16))
  M(21) = M(21) + (-(CI*f(2)) * den(135)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,52),T3sum(1:35,16))
  M(17) = M(17) + (-f(6) * den(324)) * TI2_call(4,momenta_81,masses2_4,G4tensor(:,19),T4sum(1:70,97))
  M(18) = M(18) + (f(6) * den(324)) * TI2_call(4,momenta_81,masses2_4,G4tensor(:,19),T4sum(1:70,97))
  M(19) = M(19) + (f(6) * den(324)) * TI2_call(4,momenta_81,masses2_4,G4tensor(:,19),T4sum(1:70,97))
  M(21) = M(21) + (-f(6) * den(324)) * TI2_call(4,momenta_81,masses2_4,G4tensor(:,19),T4sum(1:70,97))
  M(2) = M(2) + (f(6) * den(324)) * TI2_call(4,momenta_81,masses2_4,G4tensor(:,16),T4sum(1:70,97))
  M(8) = M(8) + (-f(6) * den(324)) * TI2_call(4,momenta_81,masses2_4,G4tensor(:,16),T4sum(1:70,97))
  M(13) = M(13) + (-f(6) * den(324)) * TI2_call(4,momenta_81,masses2_4,G4tensor(:,16),T4sum(1:70,97))
  M(15) = M(15) + (f(6) * den(324)) * TI2_call(4,momenta_81,masses2_4,G4tensor(:,16),T4sum(1:70,97))
  M(17) = M(17) + (-f(3) * den(324)) * TI2_call(4,momenta_81,masses2_3,G4tensor(:,25),T4sum(1:70,98))
  M(18) = M(18) + (f(3) * den(324)) * TI2_call(4,momenta_81,masses2_3,G4tensor(:,25),T4sum(1:70,98))
  M(19) = M(19) + (f(3) * den(324)) * TI2_call(4,momenta_81,masses2_3,G4tensor(:,25),T4sum(1:70,98))
  M(21) = M(21) + (-f(3) * den(324)) * TI2_call(4,momenta_81,masses2_3,G4tensor(:,25),T4sum(1:70,98))
  M(2) = M(2) + (f(3) * den(324)) * TI2_call(4,momenta_81,masses2_3,G4tensor(:,22),T4sum(1:70,98))
  M(8) = M(8) + (-f(3) * den(324)) * TI2_call(4,momenta_81,masses2_3,G4tensor(:,22),T4sum(1:70,98))
  M(13) = M(13) + (-f(3) * den(324)) * TI2_call(4,momenta_81,masses2_3,G4tensor(:,22),T4sum(1:70,98))
  M(15) = M(15) + (f(3) * den(324)) * TI2_call(4,momenta_81,masses2_3,G4tensor(:,22),T4sum(1:70,98))
  M(2) = M(2) + (f(6) * den(324)) * TI2_call(4,momenta_67,masses2_4,G4tensor(:,45),T4sum(1:70,99))
  M(8) = M(8) + (-f(6) * den(324)) * TI2_call(4,momenta_67,masses2_4,G4tensor(:,45),T4sum(1:70,99))
  M(13) = M(13) + (-f(6) * den(324)) * TI2_call(4,momenta_67,masses2_4,G4tensor(:,45),T4sum(1:70,99))
  M(15) = M(15) + (f(6) * den(324)) * TI2_call(4,momenta_67,masses2_4,G4tensor(:,45),T4sum(1:70,99))
  M(17) = M(17) + (-f(6) * den(324)) * TI2_call(4,momenta_67,masses2_4,G4tensor(:,40),T4sum(1:70,99))
  M(18) = M(18) + (f(6) * den(324)) * TI2_call(4,momenta_67,masses2_4,G4tensor(:,40),T4sum(1:70,99))
  M(19) = M(19) + (f(6) * den(324)) * TI2_call(4,momenta_67,masses2_4,G4tensor(:,40),T4sum(1:70,99))
  M(21) = M(21) + (-f(6) * den(324)) * TI2_call(4,momenta_67,masses2_4,G4tensor(:,40),T4sum(1:70,99))
  M(2) = M(2) + (f(3) * den(324)) * TI2_call(4,momenta_67,masses2_3,G4tensor(:,55),T4sum(1:70,100))
  M(8) = M(8) + (-f(3) * den(324)) * TI2_call(4,momenta_67,masses2_3,G4tensor(:,55),T4sum(1:70,100))
  M(13) = M(13) + (-f(3) * den(324)) * TI2_call(4,momenta_67,masses2_3,G4tensor(:,55),T4sum(1:70,100))
  M(15) = M(15) + (f(3) * den(324)) * TI2_call(4,momenta_67,masses2_3,G4tensor(:,55),T4sum(1:70,100))
  M(17) = M(17) + (-f(3) * den(324)) * TI2_call(4,momenta_67,masses2_3,G4tensor(:,50),T4sum(1:70,100))
  M(18) = M(18) + (f(3) * den(324)) * TI2_call(4,momenta_67,masses2_3,G4tensor(:,50),T4sum(1:70,100))
  M(19) = M(19) + (f(3) * den(324)) * TI2_call(4,momenta_67,masses2_3,G4tensor(:,50),T4sum(1:70,100))
  M(21) = M(21) + (-f(3) * den(324)) * TI2_call(4,momenta_67,masses2_3,G4tensor(:,50),T4sum(1:70,100))
  M(17) = M(17) + (-f(6) * den(324)) * TI2_call(4,momenta_68,masses2_4,G4tensor(:,46),T4sum(1:70,101))
  M(18) = M(18) + (f(6) * den(324)) * TI2_call(4,momenta_68,masses2_4,G4tensor(:,46),T4sum(1:70,101))
  M(19) = M(19) + (f(6) * den(324)) * TI2_call(4,momenta_68,masses2_4,G4tensor(:,46),T4sum(1:70,101))
  M(21) = M(21) + (-f(6) * den(324)) * TI2_call(4,momenta_68,masses2_4,G4tensor(:,46),T4sum(1:70,101))
  M(2) = M(2) + (f(6) * den(324)) * TI2_call(4,momenta_68,masses2_4,G4tensor(:,41),T4sum(1:70,101))
  M(8) = M(8) + (-f(6) * den(324)) * TI2_call(4,momenta_68,masses2_4,G4tensor(:,41),T4sum(1:70,101))
  M(13) = M(13) + (-f(6) * den(324)) * TI2_call(4,momenta_68,masses2_4,G4tensor(:,41),T4sum(1:70,101))
  M(15) = M(15) + (f(6) * den(324)) * TI2_call(4,momenta_68,masses2_4,G4tensor(:,41),T4sum(1:70,101))
  M(17) = M(17) + (-f(3) * den(324)) * TI2_call(4,momenta_68,masses2_3,G4tensor(:,56),T4sum(1:70,102))
  M(18) = M(18) + (f(3) * den(324)) * TI2_call(4,momenta_68,masses2_3,G4tensor(:,56),T4sum(1:70,102))
  M(19) = M(19) + (f(3) * den(324)) * TI2_call(4,momenta_68,masses2_3,G4tensor(:,56),T4sum(1:70,102))
  M(21) = M(21) + (-f(3) * den(324)) * TI2_call(4,momenta_68,masses2_3,G4tensor(:,56),T4sum(1:70,102))
  M(2) = M(2) + (f(3) * den(324)) * TI2_call(4,momenta_68,masses2_3,G4tensor(:,51),T4sum(1:70,102))
  M(8) = M(8) + (-f(3) * den(324)) * TI2_call(4,momenta_68,masses2_3,G4tensor(:,51),T4sum(1:70,102))
  M(13) = M(13) + (-f(3) * den(324)) * TI2_call(4,momenta_68,masses2_3,G4tensor(:,51),T4sum(1:70,102))
  M(15) = M(15) + (f(3) * den(324)) * TI2_call(4,momenta_68,masses2_3,G4tensor(:,51),T4sum(1:70,102))
  M(1) = M(1) + (-(CI*f(5)) * den(142)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,95),T3sum(1:35,19))
  M(7) = M(7) + (CI*f(5) * den(142)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,95),T3sum(1:35,19))
  M(13) = M(13) + (CI*f(5) * den(142)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,95),T3sum(1:35,19))
  M(15) = M(15) + (-(CI*f(5)) * den(142)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,95),T3sum(1:35,19))
  M(19) = M(19) + (CI*f(5) * den(142)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,95),T3sum(1:35,19))
  M(21) = M(21) + (-(CI*f(5)) * den(142)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,95),T3sum(1:35,19))
  M(23) = M(23) + (-(CI*f(5)) * den(142)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,95),T3sum(1:35,19))
  M(24) = M(24) + (CI*f(5) * den(142)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,95),T3sum(1:35,19))
  M(1) = M(1) + (-(CI*f(5)) * den(142)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,101),T3sum(1:35,19))
  M(7) = M(7) + (CI*f(5) * den(142)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,101),T3sum(1:35,19))
  M(13) = M(13) + (CI*f(5) * den(142)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,101),T3sum(1:35,19))
  M(15) = M(15) + (-(CI*f(5)) * den(142)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,101),T3sum(1:35,19))
  M(19) = M(19) + (CI*f(5) * den(142)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,101),T3sum(1:35,19))
  M(21) = M(21) + (-(CI*f(5)) * den(142)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,101),T3sum(1:35,19))
  M(23) = M(23) + (-(CI*f(5)) * den(142)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,101),T3sum(1:35,19))
  M(24) = M(24) + (CI*f(5) * den(142)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,101),T3sum(1:35,19))
  M(1) = M(1) + (-(CI*f(2)) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,107),T3sum(1:35,20))
  M(7) = M(7) + (CI*f(2) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,107),T3sum(1:35,20))
  M(13) = M(13) + (CI*f(2) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,107),T3sum(1:35,20))
  M(15) = M(15) + (-(CI*f(2)) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,107),T3sum(1:35,20))
  M(19) = M(19) + (CI*f(2) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,107),T3sum(1:35,20))
  M(21) = M(21) + (-(CI*f(2)) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,107),T3sum(1:35,20))
  M(23) = M(23) + (-(CI*f(2)) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,107),T3sum(1:35,20))
  M(24) = M(24) + (CI*f(2) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,107),T3sum(1:35,20))
  M(1) = M(1) + (-(CI*f(2)) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,113),T3sum(1:35,20))
  M(7) = M(7) + (CI*f(2) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,113),T3sum(1:35,20))
  M(13) = M(13) + (CI*f(2) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,113),T3sum(1:35,20))
  M(15) = M(15) + (-(CI*f(2)) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,113),T3sum(1:35,20))
  M(19) = M(19) + (CI*f(2) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,113),T3sum(1:35,20))
  M(21) = M(21) + (-(CI*f(2)) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,113),T3sum(1:35,20))
  M(23) = M(23) + (-(CI*f(2)) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,113),T3sum(1:35,20))
  M(24) = M(24) + (CI*f(2) * den(142)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,113),T3sum(1:35,20))
  M(1) = M(1) + (f(6) * den(326)) * TI2_call(4,momenta_69,masses2_4,G4tensor(:,47),T4sum(1:70,105))
  M(7) = M(7) + (-f(6) * den(326)) * TI2_call(4,momenta_69,masses2_4,G4tensor(:,47),T4sum(1:70,105))
  M(19) = M(19) + (-f(6) * den(326)) * TI2_call(4,momenta_69,masses2_4,G4tensor(:,47),T4sum(1:70,105))
  M(21) = M(21) + (f(6) * den(326)) * TI2_call(4,momenta_69,masses2_4,G4tensor(:,47),T4sum(1:70,105))
  M(13) = M(13) + (f(6) * den(326)) * TI2_call(4,momenta_69,masses2_4,G4tensor(:,42),T4sum(1:70,105))
  M(15) = M(15) + (-f(6) * den(326)) * TI2_call(4,momenta_69,masses2_4,G4tensor(:,42),T4sum(1:70,105))
  M(23) = M(23) + (-f(6) * den(326)) * TI2_call(4,momenta_69,masses2_4,G4tensor(:,42),T4sum(1:70,105))
  M(24) = M(24) + (f(6) * den(326)) * TI2_call(4,momenta_69,masses2_4,G4tensor(:,42),T4sum(1:70,105))
  M(1) = M(1) + (f(3) * den(326)) * TI2_call(4,momenta_69,masses2_3,G4tensor(:,57),T4sum(1:70,106))
  M(7) = M(7) + (-f(3) * den(326)) * TI2_call(4,momenta_69,masses2_3,G4tensor(:,57),T4sum(1:70,106))
  M(19) = M(19) + (-f(3) * den(326)) * TI2_call(4,momenta_69,masses2_3,G4tensor(:,57),T4sum(1:70,106))
  M(21) = M(21) + (f(3) * den(326)) * TI2_call(4,momenta_69,masses2_3,G4tensor(:,57),T4sum(1:70,106))
  M(13) = M(13) + (f(3) * den(326)) * TI2_call(4,momenta_69,masses2_3,G4tensor(:,52),T4sum(1:70,106))
  M(15) = M(15) + (-f(3) * den(326)) * TI2_call(4,momenta_69,masses2_3,G4tensor(:,52),T4sum(1:70,106))
  M(23) = M(23) + (-f(3) * den(326)) * TI2_call(4,momenta_69,masses2_3,G4tensor(:,52),T4sum(1:70,106))
  M(24) = M(24) + (f(3) * den(326)) * TI2_call(4,momenta_69,masses2_3,G4tensor(:,52),T4sum(1:70,106))
  M(13) = M(13) + (f(6) * den(326)) * TI2_call(4,momenta_66,masses2_4,G4tensor(:,48),T4sum(1:70,107))
  M(15) = M(15) + (-f(6) * den(326)) * TI2_call(4,momenta_66,masses2_4,G4tensor(:,48),T4sum(1:70,107))
  M(23) = M(23) + (-f(6) * den(326)) * TI2_call(4,momenta_66,masses2_4,G4tensor(:,48),T4sum(1:70,107))
  M(24) = M(24) + (f(6) * den(326)) * TI2_call(4,momenta_66,masses2_4,G4tensor(:,48),T4sum(1:70,107))
  M(1) = M(1) + (f(6) * den(326)) * TI2_call(4,momenta_66,masses2_4,G4tensor(:,43),T4sum(1:70,107))
  M(7) = M(7) + (-f(6) * den(326)) * TI2_call(4,momenta_66,masses2_4,G4tensor(:,43),T4sum(1:70,107))
  M(19) = M(19) + (-f(6) * den(326)) * TI2_call(4,momenta_66,masses2_4,G4tensor(:,43),T4sum(1:70,107))
  M(21) = M(21) + (f(6) * den(326)) * TI2_call(4,momenta_66,masses2_4,G4tensor(:,43),T4sum(1:70,107))
  M(13) = M(13) + (f(3) * den(326)) * TI2_call(4,momenta_66,masses2_3,G4tensor(:,58),T4sum(1:70,108))
  M(15) = M(15) + (-f(3) * den(326)) * TI2_call(4,momenta_66,masses2_3,G4tensor(:,58),T4sum(1:70,108))
  M(23) = M(23) + (-f(3) * den(326)) * TI2_call(4,momenta_66,masses2_3,G4tensor(:,58),T4sum(1:70,108))
  M(24) = M(24) + (f(3) * den(326)) * TI2_call(4,momenta_66,masses2_3,G4tensor(:,58),T4sum(1:70,108))
  M(1) = M(1) + (f(3) * den(326)) * TI2_call(4,momenta_66,masses2_3,G4tensor(:,53),T4sum(1:70,108))
  M(7) = M(7) + (-f(3) * den(326)) * TI2_call(4,momenta_66,masses2_3,G4tensor(:,53),T4sum(1:70,108))
  M(19) = M(19) + (-f(3) * den(326)) * TI2_call(4,momenta_66,masses2_3,G4tensor(:,53),T4sum(1:70,108))
  M(21) = M(21) + (f(3) * den(326)) * TI2_call(4,momenta_66,masses2_3,G4tensor(:,53),T4sum(1:70,108))
  M(1) = M(1) + (-(CI*f(5)) * den(144)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,102),T3sum(1:35,19))
  M(2) = M(2) + (CI*f(5) * den(144)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,102),T3sum(1:35,19))
  M(7) = M(7) + (CI*f(5) * den(144)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,102),T3sum(1:35,19))
  M(8) = M(8) + (-(CI*f(5)) * den(144)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,102),T3sum(1:35,19))
  M(17) = M(17) + (CI*f(5) * den(144)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,102),T3sum(1:35,19))
  M(18) = M(18) + (-(CI*f(5)) * den(144)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,102),T3sum(1:35,19))
  M(23) = M(23) + (-(CI*f(5)) * den(144)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,102),T3sum(1:35,19))
  M(24) = M(24) + (CI*f(5) * den(144)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,102),T3sum(1:35,19))
  M(1) = M(1) + (-(CI*f(5)) * den(144)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,96),T3sum(1:35,19))
  M(2) = M(2) + (CI*f(5) * den(144)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,96),T3sum(1:35,19))
  M(7) = M(7) + (CI*f(5) * den(144)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,96),T3sum(1:35,19))
  M(8) = M(8) + (-(CI*f(5)) * den(144)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,96),T3sum(1:35,19))
  M(17) = M(17) + (CI*f(5) * den(144)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,96),T3sum(1:35,19))
  M(18) = M(18) + (-(CI*f(5)) * den(144)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,96),T3sum(1:35,19))
  M(23) = M(23) + (-(CI*f(5)) * den(144)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,96),T3sum(1:35,19))
  M(24) = M(24) + (CI*f(5) * den(144)) * TI2_call(3,momenta_6,masses2_2,G3tensor(:,96),T3sum(1:35,19))
  M(1) = M(1) + (-(CI*f(2)) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,114),T3sum(1:35,20))
  M(2) = M(2) + (CI*f(2) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,114),T3sum(1:35,20))
  M(7) = M(7) + (CI*f(2) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,114),T3sum(1:35,20))
  M(8) = M(8) + (-(CI*f(2)) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,114),T3sum(1:35,20))
  M(17) = M(17) + (CI*f(2) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,114),T3sum(1:35,20))
  M(18) = M(18) + (-(CI*f(2)) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,114),T3sum(1:35,20))
  M(23) = M(23) + (-(CI*f(2)) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,114),T3sum(1:35,20))
  M(24) = M(24) + (CI*f(2) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,114),T3sum(1:35,20))
  M(1) = M(1) + (-(CI*f(2)) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,108),T3sum(1:35,20))
  M(2) = M(2) + (CI*f(2) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,108),T3sum(1:35,20))
  M(7) = M(7) + (CI*f(2) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,108),T3sum(1:35,20))
  M(8) = M(8) + (-(CI*f(2)) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,108),T3sum(1:35,20))
  M(17) = M(17) + (CI*f(2) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,108),T3sum(1:35,20))
  M(18) = M(18) + (-(CI*f(2)) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,108),T3sum(1:35,20))
  M(23) = M(23) + (-(CI*f(2)) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,108),T3sum(1:35,20))
  M(24) = M(24) + (CI*f(2) * den(144)) * TI2_call(3,momenta_6,masses2_1,G3tensor(:,108),T3sum(1:35,20))
  M(17) = M(17) + (-f(6) * den(328)) * TI2_call(4,momenta_65,masses2_4,G4tensor(:,44),T4sum(1:70,113))
  M(18) = M(18) + (f(6) * den(328)) * TI2_call(4,momenta_65,masses2_4,G4tensor(:,44),T4sum(1:70,113))
  M(23) = M(23) + (f(6) * den(328)) * TI2_call(4,momenta_65,masses2_4,G4tensor(:,44),T4sum(1:70,113))
  M(24) = M(24) + (-f(6) * den(328)) * TI2_call(4,momenta_65,masses2_4,G4tensor(:,44),T4sum(1:70,113))
  M(1) = M(1) + (-f(6) * den(328)) * TI2_call(4,momenta_65,masses2_4,G4tensor(:,49),T4sum(1:70,113))
  M(2) = M(2) + (f(6) * den(328)) * TI2_call(4,momenta_65,masses2_4,G4tensor(:,49),T4sum(1:70,113))
  M(7) = M(7) + (f(6) * den(328)) * TI2_call(4,momenta_65,masses2_4,G4tensor(:,49),T4sum(1:70,113))
  M(8) = M(8) + (-f(6) * den(328)) * TI2_call(4,momenta_65,masses2_4,G4tensor(:,49),T4sum(1:70,113))
  M(17) = M(17) + (-f(3) * den(328)) * TI2_call(4,momenta_65,masses2_3,G4tensor(:,54),T4sum(1:70,114))
  M(18) = M(18) + (f(3) * den(328)) * TI2_call(4,momenta_65,masses2_3,G4tensor(:,54),T4sum(1:70,114))
  M(23) = M(23) + (f(3) * den(328)) * TI2_call(4,momenta_65,masses2_3,G4tensor(:,54),T4sum(1:70,114))
  M(24) = M(24) + (-f(3) * den(328)) * TI2_call(4,momenta_65,masses2_3,G4tensor(:,54),T4sum(1:70,114))
  M(1) = M(1) + (-f(3) * den(328)) * TI2_call(4,momenta_65,masses2_3,G4tensor(:,59),T4sum(1:70,114))
  M(2) = M(2) + (f(3) * den(328)) * TI2_call(4,momenta_65,masses2_3,G4tensor(:,59),T4sum(1:70,114))
  M(7) = M(7) + (f(3) * den(328)) * TI2_call(4,momenta_65,masses2_3,G4tensor(:,59),T4sum(1:70,114))
  M(8) = M(8) + (-f(3) * den(328)) * TI2_call(4,momenta_65,masses2_3,G4tensor(:,59),T4sum(1:70,114))
  M(19) = M(19) + (CI*f(5) * den(33)) * TI2_call(5,momenta_192,masses2_6,G5tensor(:,25),T5sum(1:126,65))
  M(21) = M(21) + (-(CI*f(5)) * den(33)) * TI2_call(5,momenta_192,masses2_6,G5tensor(:,25),T5sum(1:126,65))
  M(13) = M(13) + (CI*f(5) * den(33)) * TI2_call(5,momenta_192,masses2_6,G5tensor(:,21),T5sum(1:126,65))
  M(15) = M(15) + (-(CI*f(5)) * den(33)) * TI2_call(5,momenta_192,masses2_6,G5tensor(:,21),T5sum(1:126,65))
  M(19) = M(19) + (CI*f(2) * den(33)) * TI2_call(5,momenta_192,masses2_5,G5tensor(:,33),T5sum(1:126,66))
  M(21) = M(21) + (-(CI*f(2)) * den(33)) * TI2_call(5,momenta_192,masses2_5,G5tensor(:,33),T5sum(1:126,66))
  M(13) = M(13) + (CI*f(2) * den(33)) * TI2_call(5,momenta_192,masses2_5,G5tensor(:,29),T5sum(1:126,66))
  M(15) = M(15) + (-(CI*f(2)) * den(33)) * TI2_call(5,momenta_192,masses2_5,G5tensor(:,29),T5sum(1:126,66))
  M(1) = M(1) + (CI*f(5) * den(33)) * TI2_call(5,momenta_190,masses2_6,G5tensor(:,27),T5sum(1:126,67))
  M(7) = M(7) + (-(CI*f(5)) * den(33)) * TI2_call(5,momenta_190,masses2_6,G5tensor(:,27),T5sum(1:126,67))
  M(23) = M(23) + (CI*f(5) * den(33)) * TI2_call(5,momenta_190,masses2_6,G5tensor(:,23),T5sum(1:126,67))
  M(24) = M(24) + (-(CI*f(5)) * den(33)) * TI2_call(5,momenta_190,masses2_6,G5tensor(:,23),T5sum(1:126,67))
  M(1) = M(1) + (CI*f(2) * den(33)) * TI2_call(5,momenta_190,masses2_5,G5tensor(:,35),T5sum(1:126,68))
  M(7) = M(7) + (-(CI*f(2)) * den(33)) * TI2_call(5,momenta_190,masses2_5,G5tensor(:,35),T5sum(1:126,68))
  M(23) = M(23) + (CI*f(2) * den(33)) * TI2_call(5,momenta_190,masses2_5,G5tensor(:,31),T5sum(1:126,68))
  M(24) = M(24) + (-(CI*f(2)) * den(33)) * TI2_call(5,momenta_190,masses2_5,G5tensor(:,31),T5sum(1:126,68))
  M(13) = M(13) + (CI*f(5) * den(33)) * TI2_call(5,momenta_191,masses2_6,G5tensor(:,26),T5sum(1:126,69))
  M(15) = M(15) + (-(CI*f(5)) * den(33)) * TI2_call(5,momenta_191,masses2_6,G5tensor(:,26),T5sum(1:126,69))
  M(19) = M(19) + (CI*f(5) * den(33)) * TI2_call(5,momenta_191,masses2_6,G5tensor(:,22),T5sum(1:126,69))
  M(21) = M(21) + (-(CI*f(5)) * den(33)) * TI2_call(5,momenta_191,masses2_6,G5tensor(:,22),T5sum(1:126,69))
  M(13) = M(13) + (CI*f(2) * den(33)) * TI2_call(5,momenta_191,masses2_5,G5tensor(:,34),T5sum(1:126,70))
  M(15) = M(15) + (-(CI*f(2)) * den(33)) * TI2_call(5,momenta_191,masses2_5,G5tensor(:,34),T5sum(1:126,70))
  M(19) = M(19) + (CI*f(2) * den(33)) * TI2_call(5,momenta_191,masses2_5,G5tensor(:,30),T5sum(1:126,70))
  M(21) = M(21) + (-(CI*f(2)) * den(33)) * TI2_call(5,momenta_191,masses2_5,G5tensor(:,30),T5sum(1:126,70))
  M(2) = M(2) + (CI*f(5) * den(33)) * TI2_call(5,momenta_189,masses2_6,G5tensor(:,28),T5sum(1:126,71))
  M(8) = M(8) + (-(CI*f(5)) * den(33)) * TI2_call(5,momenta_189,masses2_6,G5tensor(:,28),T5sum(1:126,71))
  M(17) = M(17) + (CI*f(5) * den(33)) * TI2_call(5,momenta_189,masses2_6,G5tensor(:,24),T5sum(1:126,71))
  M(18) = M(18) + (-(CI*f(5)) * den(33)) * TI2_call(5,momenta_189,masses2_6,G5tensor(:,24),T5sum(1:126,71))
  M(2) = M(2) + (CI*f(2) * den(33)) * TI2_call(5,momenta_189,masses2_5,G5tensor(:,36),T5sum(1:126,72))
  M(8) = M(8) + (-(CI*f(2)) * den(33)) * TI2_call(5,momenta_189,masses2_5,G5tensor(:,36),T5sum(1:126,72))
  M(17) = M(17) + (CI*f(2) * den(33)) * TI2_call(5,momenta_189,masses2_5,G5tensor(:,32),T5sum(1:126,72))
  M(18) = M(18) + (-(CI*f(2)) * den(33)) * TI2_call(5,momenta_189,masses2_5,G5tensor(:,32),T5sum(1:126,72))
  M(5) = M(5) + (CI*f(5) * den(157)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,35),T3sum(1:35,15))
  M(8) = M(8) + (-(CI*f(5)) * den(157)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,35),T3sum(1:35,15))
  M(11) = M(11) + (CI*f(5) * den(157)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,35),T3sum(1:35,15))
  M(14) = M(14) + (-(CI*f(5)) * den(157)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,35),T3sum(1:35,15))
  M(15) = M(15) + (CI*f(5) * den(157)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,35),T3sum(1:35,15))
  M(16) = M(16) + (-(CI*f(5)) * den(157)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,35),T3sum(1:35,15))
  M(17) = M(17) + (CI*f(5) * den(157)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,35),T3sum(1:35,15))
  M(19) = M(19) + (-(CI*f(5)) * den(157)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,35),T3sum(1:35,15))
  M(5) = M(5) + (CI*f(5) * den(157)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,41),T3sum(1:35,15))
  M(8) = M(8) + (-(CI*f(5)) * den(157)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,41),T3sum(1:35,15))
  M(11) = M(11) + (CI*f(5) * den(157)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,41),T3sum(1:35,15))
  M(14) = M(14) + (-(CI*f(5)) * den(157)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,41),T3sum(1:35,15))
  M(15) = M(15) + (CI*f(5) * den(157)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,41),T3sum(1:35,15))
  M(16) = M(16) + (-(CI*f(5)) * den(157)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,41),T3sum(1:35,15))
  M(17) = M(17) + (CI*f(5) * den(157)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,41),T3sum(1:35,15))
  M(19) = M(19) + (-(CI*f(5)) * den(157)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,41),T3sum(1:35,15))
  M(5) = M(5) + (CI*f(2) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,47),T3sum(1:35,16))
  M(8) = M(8) + (-(CI*f(2)) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,47),T3sum(1:35,16))
  M(11) = M(11) + (CI*f(2) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,47),T3sum(1:35,16))
  M(14) = M(14) + (-(CI*f(2)) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,47),T3sum(1:35,16))
  M(15) = M(15) + (CI*f(2) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,47),T3sum(1:35,16))
  M(16) = M(16) + (-(CI*f(2)) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,47),T3sum(1:35,16))
  M(17) = M(17) + (CI*f(2) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,47),T3sum(1:35,16))
  M(19) = M(19) + (-(CI*f(2)) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,47),T3sum(1:35,16))
  M(5) = M(5) + (CI*f(2) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,53),T3sum(1:35,16))
  M(8) = M(8) + (-(CI*f(2)) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,53),T3sum(1:35,16))
  M(11) = M(11) + (CI*f(2) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,53),T3sum(1:35,16))
  M(14) = M(14) + (-(CI*f(2)) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,53),T3sum(1:35,16))
  M(15) = M(15) + (CI*f(2) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,53),T3sum(1:35,16))
  M(16) = M(16) + (-(CI*f(2)) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,53),T3sum(1:35,16))
  M(17) = M(17) + (CI*f(2) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,53),T3sum(1:35,16))
  M(19) = M(19) + (-(CI*f(2)) * den(157)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,53),T3sum(1:35,16))
  M(8) = M(8) + (f(6) * den(336)) * TI2_call(4,momenta_80,masses2_4,G4tensor(:,17),T4sum(1:70,119))
  M(11) = M(11) + (-f(6) * den(336)) * TI2_call(4,momenta_80,masses2_4,G4tensor(:,17),T4sum(1:70,119))
  M(15) = M(15) + (-f(6) * den(336)) * TI2_call(4,momenta_80,masses2_4,G4tensor(:,17),T4sum(1:70,119))
  M(16) = M(16) + (f(6) * den(336)) * TI2_call(4,momenta_80,masses2_4,G4tensor(:,17),T4sum(1:70,119))
  M(5) = M(5) + (f(6) * den(336)) * TI2_call(4,momenta_80,masses2_4,G4tensor(:,20),T4sum(1:70,119))
  M(14) = M(14) + (-f(6) * den(336)) * TI2_call(4,momenta_80,masses2_4,G4tensor(:,20),T4sum(1:70,119))
  M(17) = M(17) + (f(6) * den(336)) * TI2_call(4,momenta_80,masses2_4,G4tensor(:,20),T4sum(1:70,119))
  M(19) = M(19) + (-f(6) * den(336)) * TI2_call(4,momenta_80,masses2_4,G4tensor(:,20),T4sum(1:70,119))
  M(8) = M(8) + (f(3) * den(336)) * TI2_call(4,momenta_80,masses2_3,G4tensor(:,23),T4sum(1:70,120))
  M(11) = M(11) + (-f(3) * den(336)) * TI2_call(4,momenta_80,masses2_3,G4tensor(:,23),T4sum(1:70,120))
  M(15) = M(15) + (-f(3) * den(336)) * TI2_call(4,momenta_80,masses2_3,G4tensor(:,23),T4sum(1:70,120))
  M(16) = M(16) + (f(3) * den(336)) * TI2_call(4,momenta_80,masses2_3,G4tensor(:,23),T4sum(1:70,120))
  M(5) = M(5) + (f(3) * den(336)) * TI2_call(4,momenta_80,masses2_3,G4tensor(:,26),T4sum(1:70,120))
  M(14) = M(14) + (-f(3) * den(336)) * TI2_call(4,momenta_80,masses2_3,G4tensor(:,26),T4sum(1:70,120))
  M(17) = M(17) + (f(3) * den(336)) * TI2_call(4,momenta_80,masses2_3,G4tensor(:,26),T4sum(1:70,120))
  M(19) = M(19) + (-f(3) * den(336)) * TI2_call(4,momenta_80,masses2_3,G4tensor(:,26),T4sum(1:70,120))
  M(2) = M(2) + (-(CI*f(5)) * den(161)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,36),T3sum(1:35,15))
  M(5) = M(5) + (CI*f(5) * den(161)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,36),T3sum(1:35,15))
  M(11) = M(11) + (CI*f(5) * den(161)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,36),T3sum(1:35,15))
  M(13) = M(13) + (CI*f(5) * den(161)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,36),T3sum(1:35,15))
  M(14) = M(14) + (-(CI*f(5)) * den(161)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,36),T3sum(1:35,15))
  M(16) = M(16) + (-(CI*f(5)) * den(161)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,36),T3sum(1:35,15))
  M(18) = M(18) + (CI*f(5) * den(161)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,36),T3sum(1:35,15))
  M(21) = M(21) + (-(CI*f(5)) * den(161)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,36),T3sum(1:35,15))
  M(2) = M(2) + (-(CI*f(5)) * den(161)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,42),T3sum(1:35,15))
  M(5) = M(5) + (CI*f(5) * den(161)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,42),T3sum(1:35,15))
  M(11) = M(11) + (CI*f(5) * den(161)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,42),T3sum(1:35,15))
  M(13) = M(13) + (CI*f(5) * den(161)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,42),T3sum(1:35,15))
  M(14) = M(14) + (-(CI*f(5)) * den(161)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,42),T3sum(1:35,15))
  M(16) = M(16) + (-(CI*f(5)) * den(161)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,42),T3sum(1:35,15))
  M(18) = M(18) + (CI*f(5) * den(161)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,42),T3sum(1:35,15))
  M(21) = M(21) + (-(CI*f(5)) * den(161)) * TI2_call(3,momenta_9,masses2_2,G3tensor(:,42),T3sum(1:35,15))
  M(2) = M(2) + (-(CI*f(2)) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,48),T3sum(1:35,16))
  M(5) = M(5) + (CI*f(2) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,48),T3sum(1:35,16))
  M(11) = M(11) + (CI*f(2) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,48),T3sum(1:35,16))
  M(13) = M(13) + (CI*f(2) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,48),T3sum(1:35,16))
  M(14) = M(14) + (-(CI*f(2)) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,48),T3sum(1:35,16))
  M(16) = M(16) + (-(CI*f(2)) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,48),T3sum(1:35,16))
  M(18) = M(18) + (CI*f(2) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,48),T3sum(1:35,16))
  M(21) = M(21) + (-(CI*f(2)) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,48),T3sum(1:35,16))
  M(2) = M(2) + (-(CI*f(2)) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,54),T3sum(1:35,16))
  M(5) = M(5) + (CI*f(2) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,54),T3sum(1:35,16))
  M(11) = M(11) + (CI*f(2) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,54),T3sum(1:35,16))
  M(13) = M(13) + (CI*f(2) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,54),T3sum(1:35,16))
  M(14) = M(14) + (-(CI*f(2)) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,54),T3sum(1:35,16))
  M(16) = M(16) + (-(CI*f(2)) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,54),T3sum(1:35,16))
  M(18) = M(18) + (CI*f(2) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,54),T3sum(1:35,16))
  M(21) = M(21) + (-(CI*f(2)) * den(161)) * TI2_call(3,momenta_9,masses2_1,G3tensor(:,54),T3sum(1:35,16))
  M(2) = M(2) + (f(6) * den(338)) * TI2_call(4,momenta_79,masses2_4,G4tensor(:,18),T4sum(1:70,125))
  M(5) = M(5) + (-f(6) * den(338)) * TI2_call(4,momenta_79,masses2_4,G4tensor(:,18),T4sum(1:70,125))
  M(13) = M(13) + (-f(6) * den(338)) * TI2_call(4,momenta_79,masses2_4,G4tensor(:,18),T4sum(1:70,125))
  M(14) = M(14) + (f(6) * den(338)) * TI2_call(4,momenta_79,masses2_4,G4tensor(:,18),T4sum(1:70,125))
  M(11) = M(11) + (f(6) * den(338)) * TI2_call(4,momenta_79,masses2_4,G4tensor(:,21),T4sum(1:70,125))
  M(16) = M(16) + (-f(6) * den(338)) * TI2_call(4,momenta_79,masses2_4,G4tensor(:,21),T4sum(1:70,125))
  M(18) = M(18) + (f(6) * den(338)) * TI2_call(4,momenta_79,masses2_4,G4tensor(:,21),T4sum(1:70,125))
  M(21) = M(21) + (-f(6) * den(338)) * TI2_call(4,momenta_79,masses2_4,G4tensor(:,21),T4sum(1:70,125))
  M(2) = M(2) + (f(3) * den(338)) * TI2_call(4,momenta_79,masses2_3,G4tensor(:,24),T4sum(1:70,126))
  M(5) = M(5) + (-f(3) * den(338)) * TI2_call(4,momenta_79,masses2_3,G4tensor(:,24),T4sum(1:70,126))
  M(13) = M(13) + (-f(3) * den(338)) * TI2_call(4,momenta_79,masses2_3,G4tensor(:,24),T4sum(1:70,126))
  M(14) = M(14) + (f(3) * den(338)) * TI2_call(4,momenta_79,masses2_3,G4tensor(:,24),T4sum(1:70,126))
  M(11) = M(11) + (f(3) * den(338)) * TI2_call(4,momenta_79,masses2_3,G4tensor(:,27),T4sum(1:70,126))
  M(16) = M(16) + (-f(3) * den(338)) * TI2_call(4,momenta_79,masses2_3,G4tensor(:,27),T4sum(1:70,126))
  M(18) = M(18) + (f(3) * den(338)) * TI2_call(4,momenta_79,masses2_3,G4tensor(:,27),T4sum(1:70,126))
  M(21) = M(21) + (-f(3) * den(338)) * TI2_call(4,momenta_79,masses2_3,G4tensor(:,27),T4sum(1:70,126))
  M(17) = M(17) + (CI*f(5) * den(15)) * TI2_call(5,momenta_206,masses2_6,G5tensor(:,15),T5sum(1:126,93))
  M(19) = M(19) + (-(CI*f(5)) * den(15)) * TI2_call(5,momenta_206,masses2_6,G5tensor(:,15),T5sum(1:126,93))
  M(8) = M(8) + (-(CI*f(5)) * den(15)) * TI2_call(5,momenta_206,masses2_6,G5tensor(:,13),T5sum(1:126,93))
  M(15) = M(15) + (CI*f(5) * den(15)) * TI2_call(5,momenta_206,masses2_6,G5tensor(:,13),T5sum(1:126,93))
  M(17) = M(17) + (CI*f(2) * den(15)) * TI2_call(5,momenta_206,masses2_5,G5tensor(:,19),T5sum(1:126,94))
  M(19) = M(19) + (-(CI*f(2)) * den(15)) * TI2_call(5,momenta_206,masses2_5,G5tensor(:,19),T5sum(1:126,94))
  M(8) = M(8) + (-(CI*f(2)) * den(15)) * TI2_call(5,momenta_206,masses2_5,G5tensor(:,17),T5sum(1:126,94))
  M(15) = M(15) + (CI*f(2) * den(15)) * TI2_call(5,momenta_206,masses2_5,G5tensor(:,17),T5sum(1:126,94))
  M(18) = M(18) + (CI*f(5) * den(15)) * TI2_call(5,momenta_205,masses2_6,G5tensor(:,16),T5sum(1:126,95))
  M(21) = M(21) + (-(CI*f(5)) * den(15)) * TI2_call(5,momenta_205,masses2_6,G5tensor(:,16),T5sum(1:126,95))
  M(2) = M(2) + (-(CI*f(5)) * den(15)) * TI2_call(5,momenta_205,masses2_6,G5tensor(:,14),T5sum(1:126,95))
  M(13) = M(13) + (CI*f(5) * den(15)) * TI2_call(5,momenta_205,masses2_6,G5tensor(:,14),T5sum(1:126,95))
  M(18) = M(18) + (CI*f(2) * den(15)) * TI2_call(5,momenta_205,masses2_5,G5tensor(:,20),T5sum(1:126,96))
  M(21) = M(21) + (-(CI*f(2)) * den(15)) * TI2_call(5,momenta_205,masses2_5,G5tensor(:,20),T5sum(1:126,96))
  M(2) = M(2) + (-(CI*f(2)) * den(15)) * TI2_call(5,momenta_205,masses2_5,G5tensor(:,18),T5sum(1:126,96))
  M(13) = M(13) + (CI*f(2) * den(15)) * TI2_call(5,momenta_205,masses2_5,G5tensor(:,18),T5sum(1:126,96))
  M(3) = M(3) + (-(CI*f(5)) * den(169)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,131),T3sum(1:35,21))
  M(7) = M(7) + (CI*f(5) * den(169)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,131),T3sum(1:35,21))
  M(9) = M(9) + (-(CI*f(5)) * den(169)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,131),T3sum(1:35,21))
  M(13) = M(13) + (CI*f(5) * den(169)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,131),T3sum(1:35,21))
  M(20) = M(20) + (CI*f(5) * den(169)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,131),T3sum(1:35,21))
  M(21) = M(21) + (-(CI*f(5)) * den(169)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,131),T3sum(1:35,21))
  M(22) = M(22) + (CI*f(5) * den(169)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,131),T3sum(1:35,21))
  M(23) = M(23) + (-(CI*f(5)) * den(169)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,131),T3sum(1:35,21))
  M(3) = M(3) + (-(CI*f(5)) * den(169)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,137),T3sum(1:35,21))
  M(7) = M(7) + (CI*f(5) * den(169)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,137),T3sum(1:35,21))
  M(9) = M(9) + (-(CI*f(5)) * den(169)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,137),T3sum(1:35,21))
  M(13) = M(13) + (CI*f(5) * den(169)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,137),T3sum(1:35,21))
  M(20) = M(20) + (CI*f(5) * den(169)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,137),T3sum(1:35,21))
  M(21) = M(21) + (-(CI*f(5)) * den(169)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,137),T3sum(1:35,21))
  M(22) = M(22) + (CI*f(5) * den(169)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,137),T3sum(1:35,21))
  M(23) = M(23) + (-(CI*f(5)) * den(169)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,137),T3sum(1:35,21))
  M(3) = M(3) + (-(CI*f(2)) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,143),T3sum(1:35,22))
  M(7) = M(7) + (CI*f(2) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,143),T3sum(1:35,22))
  M(9) = M(9) + (-(CI*f(2)) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,143),T3sum(1:35,22))
  M(13) = M(13) + (CI*f(2) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,143),T3sum(1:35,22))
  M(20) = M(20) + (CI*f(2) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,143),T3sum(1:35,22))
  M(21) = M(21) + (-(CI*f(2)) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,143),T3sum(1:35,22))
  M(22) = M(22) + (CI*f(2) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,143),T3sum(1:35,22))
  M(23) = M(23) + (-(CI*f(2)) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,143),T3sum(1:35,22))
  M(3) = M(3) + (-(CI*f(2)) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,149),T3sum(1:35,22))
  M(7) = M(7) + (CI*f(2) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,149),T3sum(1:35,22))
  M(9) = M(9) + (-(CI*f(2)) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,149),T3sum(1:35,22))
  M(13) = M(13) + (CI*f(2) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,149),T3sum(1:35,22))
  M(20) = M(20) + (CI*f(2) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,149),T3sum(1:35,22))
  M(21) = M(21) + (-(CI*f(2)) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,149),T3sum(1:35,22))
  M(22) = M(22) + (CI*f(2) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,149),T3sum(1:35,22))
  M(23) = M(23) + (-(CI*f(2)) * den(169)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,149),T3sum(1:35,22))
  M(7) = M(7) + (f(6) * den(346)) * TI2_call(4,momenta_83,masses2_4,G4tensor(:,64),T4sum(1:70,131))
  M(9) = M(9) + (-f(6) * den(346)) * TI2_call(4,momenta_83,masses2_4,G4tensor(:,64),T4sum(1:70,131))
  M(21) = M(21) + (-f(6) * den(346)) * TI2_call(4,momenta_83,masses2_4,G4tensor(:,64),T4sum(1:70,131))
  M(22) = M(22) + (f(6) * den(346)) * TI2_call(4,momenta_83,masses2_4,G4tensor(:,64),T4sum(1:70,131))
  M(3) = M(3) + (f(6) * den(346)) * TI2_call(4,momenta_83,masses2_4,G4tensor(:,61),T4sum(1:70,131))
  M(13) = M(13) + (-f(6) * den(346)) * TI2_call(4,momenta_83,masses2_4,G4tensor(:,61),T4sum(1:70,131))
  M(20) = M(20) + (-f(6) * den(346)) * TI2_call(4,momenta_83,masses2_4,G4tensor(:,61),T4sum(1:70,131))
  M(23) = M(23) + (f(6) * den(346)) * TI2_call(4,momenta_83,masses2_4,G4tensor(:,61),T4sum(1:70,131))
  M(7) = M(7) + (f(3) * den(346)) * TI2_call(4,momenta_83,masses2_3,G4tensor(:,70),T4sum(1:70,132))
  M(9) = M(9) + (-f(3) * den(346)) * TI2_call(4,momenta_83,masses2_3,G4tensor(:,70),T4sum(1:70,132))
  M(21) = M(21) + (-f(3) * den(346)) * TI2_call(4,momenta_83,masses2_3,G4tensor(:,70),T4sum(1:70,132))
  M(22) = M(22) + (f(3) * den(346)) * TI2_call(4,momenta_83,masses2_3,G4tensor(:,70),T4sum(1:70,132))
  M(3) = M(3) + (f(3) * den(346)) * TI2_call(4,momenta_83,masses2_3,G4tensor(:,67),T4sum(1:70,132))
  M(13) = M(13) + (-f(3) * den(346)) * TI2_call(4,momenta_83,masses2_3,G4tensor(:,67),T4sum(1:70,132))
  M(20) = M(20) + (-f(3) * den(346)) * TI2_call(4,momenta_83,masses2_3,G4tensor(:,67),T4sum(1:70,132))
  M(23) = M(23) + (f(3) * den(346)) * TI2_call(4,momenta_83,masses2_3,G4tensor(:,67),T4sum(1:70,132))
  M(3) = M(3) + (-(CI*f(5)) * den(171)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,138),T3sum(1:35,21))
  M(4) = M(4) + (CI*f(5) * den(171)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,138),T3sum(1:35,21))
  M(11) = M(11) + (CI*f(5) * den(171)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,138),T3sum(1:35,21))
  M(12) = M(12) + (-(CI*f(5)) * den(171)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,138),T3sum(1:35,21))
  M(13) = M(13) + (CI*f(5) * den(171)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,138),T3sum(1:35,21))
  M(14) = M(14) + (-(CI*f(5)) * den(171)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,138),T3sum(1:35,21))
  M(21) = M(21) + (-(CI*f(5)) * den(171)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,138),T3sum(1:35,21))
  M(22) = M(22) + (CI*f(5) * den(171)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,138),T3sum(1:35,21))
  M(3) = M(3) + (-(CI*f(5)) * den(171)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,132),T3sum(1:35,21))
  M(4) = M(4) + (CI*f(5) * den(171)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,132),T3sum(1:35,21))
  M(11) = M(11) + (CI*f(5) * den(171)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,132),T3sum(1:35,21))
  M(12) = M(12) + (-(CI*f(5)) * den(171)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,132),T3sum(1:35,21))
  M(13) = M(13) + (CI*f(5) * den(171)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,132),T3sum(1:35,21))
  M(14) = M(14) + (-(CI*f(5)) * den(171)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,132),T3sum(1:35,21))
  M(21) = M(21) + (-(CI*f(5)) * den(171)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,132),T3sum(1:35,21))
  M(22) = M(22) + (CI*f(5) * den(171)) * TI2_call(3,momenta_10,masses2_2,G3tensor(:,132),T3sum(1:35,21))
  M(3) = M(3) + (-(CI*f(2)) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,150),T3sum(1:35,22))
  M(4) = M(4) + (CI*f(2) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,150),T3sum(1:35,22))
  M(11) = M(11) + (CI*f(2) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,150),T3sum(1:35,22))
  M(12) = M(12) + (-(CI*f(2)) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,150),T3sum(1:35,22))
  M(13) = M(13) + (CI*f(2) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,150),T3sum(1:35,22))
  M(14) = M(14) + (-(CI*f(2)) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,150),T3sum(1:35,22))
  M(21) = M(21) + (-(CI*f(2)) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,150),T3sum(1:35,22))
  M(22) = M(22) + (CI*f(2) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,150),T3sum(1:35,22))
  M(3) = M(3) + (-(CI*f(2)) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,144),T3sum(1:35,22))
  M(4) = M(4) + (CI*f(2) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,144),T3sum(1:35,22))
  M(11) = M(11) + (CI*f(2) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,144),T3sum(1:35,22))
  M(12) = M(12) + (-(CI*f(2)) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,144),T3sum(1:35,22))
  M(13) = M(13) + (CI*f(2) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,144),T3sum(1:35,22))
  M(14) = M(14) + (-(CI*f(2)) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,144),T3sum(1:35,22))
  M(21) = M(21) + (-(CI*f(2)) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,144),T3sum(1:35,22))
  M(22) = M(22) + (CI*f(2) * den(171)) * TI2_call(3,momenta_10,masses2_1,G3tensor(:,144),T3sum(1:35,22))
  M(11) = M(11) + (-f(6) * den(348)) * TI2_call(4,momenta_82,masses2_4,G4tensor(:,62),T4sum(1:70,137))
  M(12) = M(12) + (f(6) * den(348)) * TI2_call(4,momenta_82,masses2_4,G4tensor(:,62),T4sum(1:70,137))
  M(21) = M(21) + (f(6) * den(348)) * TI2_call(4,momenta_82,masses2_4,G4tensor(:,62),T4sum(1:70,137))
  M(22) = M(22) + (-f(6) * den(348)) * TI2_call(4,momenta_82,masses2_4,G4tensor(:,62),T4sum(1:70,137))
  M(3) = M(3) + (-f(6) * den(348)) * TI2_call(4,momenta_82,masses2_4,G4tensor(:,65),T4sum(1:70,137))
  M(4) = M(4) + (f(6) * den(348)) * TI2_call(4,momenta_82,masses2_4,G4tensor(:,65),T4sum(1:70,137))
  M(13) = M(13) + (f(6) * den(348)) * TI2_call(4,momenta_82,masses2_4,G4tensor(:,65),T4sum(1:70,137))
  M(14) = M(14) + (-f(6) * den(348)) * TI2_call(4,momenta_82,masses2_4,G4tensor(:,65),T4sum(1:70,137))
  M(11) = M(11) + (-f(3) * den(348)) * TI2_call(4,momenta_82,masses2_3,G4tensor(:,68),T4sum(1:70,138))
  M(12) = M(12) + (f(3) * den(348)) * TI2_call(4,momenta_82,masses2_3,G4tensor(:,68),T4sum(1:70,138))
  M(21) = M(21) + (f(3) * den(348)) * TI2_call(4,momenta_82,masses2_3,G4tensor(:,68),T4sum(1:70,138))
  M(22) = M(22) + (-f(3) * den(348)) * TI2_call(4,momenta_82,masses2_3,G4tensor(:,68),T4sum(1:70,138))
  M(3) = M(3) + (-f(3) * den(348)) * TI2_call(4,momenta_82,masses2_3,G4tensor(:,71),T4sum(1:70,138))
  M(4) = M(4) + (f(3) * den(348)) * TI2_call(4,momenta_82,masses2_3,G4tensor(:,71),T4sum(1:70,138))
  M(13) = M(13) + (f(3) * den(348)) * TI2_call(4,momenta_82,masses2_3,G4tensor(:,71),T4sum(1:70,138))
  M(14) = M(14) + (-f(3) * den(348)) * TI2_call(4,momenta_82,masses2_3,G4tensor(:,71),T4sum(1:70,138))
  M(7) = M(7) + (CI*f(5) * den(38)) * TI2_call(5,momenta_208,masses2_6,G5tensor(:,39),T5sum(1:126,117))
  M(9) = M(9) + (-(CI*f(5)) * den(38)) * TI2_call(5,momenta_208,masses2_6,G5tensor(:,39),T5sum(1:126,117))
  M(20) = M(20) + (CI*f(5) * den(38)) * TI2_call(5,momenta_208,masses2_6,G5tensor(:,37),T5sum(1:126,117))
  M(23) = M(23) + (-(CI*f(5)) * den(38)) * TI2_call(5,momenta_208,masses2_6,G5tensor(:,37),T5sum(1:126,117))
  M(7) = M(7) + (CI*f(2) * den(38)) * TI2_call(5,momenta_208,masses2_5,G5tensor(:,43),T5sum(1:126,118))
  M(9) = M(9) + (-(CI*f(2)) * den(38)) * TI2_call(5,momenta_208,masses2_5,G5tensor(:,43),T5sum(1:126,118))
  M(20) = M(20) + (CI*f(2) * den(38)) * TI2_call(5,momenta_208,masses2_5,G5tensor(:,41),T5sum(1:126,118))
  M(23) = M(23) + (-(CI*f(2)) * den(38)) * TI2_call(5,momenta_208,masses2_5,G5tensor(:,41),T5sum(1:126,118))
  M(4) = M(4) + (CI*f(5) * den(38)) * TI2_call(5,momenta_207,masses2_6,G5tensor(:,40),T5sum(1:126,119))
  M(14) = M(14) + (-(CI*f(5)) * den(38)) * TI2_call(5,momenta_207,masses2_6,G5tensor(:,40),T5sum(1:126,119))
  M(11) = M(11) + (CI*f(5) * den(38)) * TI2_call(5,momenta_207,masses2_6,G5tensor(:,38),T5sum(1:126,119))
  M(12) = M(12) + (-(CI*f(5)) * den(38)) * TI2_call(5,momenta_207,masses2_6,G5tensor(:,38),T5sum(1:126,119))
  M(4) = M(4) + (CI*f(2) * den(38)) * TI2_call(5,momenta_207,masses2_5,G5tensor(:,44),T5sum(1:126,120))
  M(14) = M(14) + (-(CI*f(2)) * den(38)) * TI2_call(5,momenta_207,masses2_5,G5tensor(:,44),T5sum(1:126,120))
  M(11) = M(11) + (CI*f(2) * den(38)) * TI2_call(5,momenta_207,masses2_5,G5tensor(:,42),T5sum(1:126,120))
  M(12) = M(12) + (-(CI*f(2)) * den(38)) * TI2_call(5,momenta_207,masses2_5,G5tensor(:,42),T5sum(1:126,120))
  M(1) = M(1) + (CI*f(5) * den(179)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,197),T3sum(1:35,25))
  M(3) = M(3) + (-(CI*f(5)) * den(179)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,197),T3sum(1:35,25))
  M(9) = M(9) + (-(CI*f(5)) * den(179)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,197),T3sum(1:35,25))
  M(15) = M(15) + (CI*f(5) * den(179)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,197),T3sum(1:35,25))
  M(19) = M(19) + (-(CI*f(5)) * den(179)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,197),T3sum(1:35,25))
  M(20) = M(20) + (CI*f(5) * den(179)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,197),T3sum(1:35,25))
  M(22) = M(22) + (CI*f(5) * den(179)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,197),T3sum(1:35,25))
  M(24) = M(24) + (-(CI*f(5)) * den(179)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,197),T3sum(1:35,25))
  M(1) = M(1) + (CI*f(5) * den(179)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,191),T3sum(1:35,25))
  M(3) = M(3) + (-(CI*f(5)) * den(179)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,191),T3sum(1:35,25))
  M(9) = M(9) + (-(CI*f(5)) * den(179)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,191),T3sum(1:35,25))
  M(15) = M(15) + (CI*f(5) * den(179)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,191),T3sum(1:35,25))
  M(19) = M(19) + (-(CI*f(5)) * den(179)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,191),T3sum(1:35,25))
  M(20) = M(20) + (CI*f(5) * den(179)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,191),T3sum(1:35,25))
  M(22) = M(22) + (CI*f(5) * den(179)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,191),T3sum(1:35,25))
  M(24) = M(24) + (-(CI*f(5)) * den(179)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,191),T3sum(1:35,25))
  M(1) = M(1) + (CI*f(2) * den(179)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,203),T3sum(1:35,26))
  M(3) = M(3) + (-(CI*f(2)) * den(179)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,203),T3sum(1:35,26))
  M(9) = M(9) + (-(CI*f(2)) * den(179)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,203),T3sum(1:35,26))
  M(15) = M(15) + (CI*f(2) * den(179)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,203),T3sum(1:35,26))
  M(19) = M(19) + (-(CI*f(2)) * den(179)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,203),T3sum(1:35,26))
  M(20) = M(20) + (CI*f(2) * den(179)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,203),T3sum(1:35,26))
  M(22) = M(22) + (CI*f(2) * den(179)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,203),T3sum(1:35,26))
  M(24) = M(24) + (-(CI*f(2)) * den(179)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,203),T3sum(1:35,26))
  M(1) = M(1) + (f(6) * den(356)) * TI2_call(4,momenta_87,masses2_4,G4tensor(:,88),T4sum(1:70,143))
  M(3) = M(3) + (-f(6) * den(356)) * TI2_call(4,momenta_87,masses2_4,G4tensor(:,88),T4sum(1:70,143))
  M(19) = M(19) + (-f(6) * den(356)) * TI2_call(4,momenta_87,masses2_4,G4tensor(:,88),T4sum(1:70,143))
  M(20) = M(20) + (f(6) * den(356)) * TI2_call(4,momenta_87,masses2_4,G4tensor(:,88),T4sum(1:70,143))
  M(9) = M(9) + (f(6) * den(356)) * TI2_call(4,momenta_87,masses2_4,G4tensor(:,85),T4sum(1:70,143))
  M(15) = M(15) + (-f(6) * den(356)) * TI2_call(4,momenta_87,masses2_4,G4tensor(:,85),T4sum(1:70,143))
  M(22) = M(22) + (-f(6) * den(356)) * TI2_call(4,momenta_87,masses2_4,G4tensor(:,85),T4sum(1:70,143))
  M(24) = M(24) + (f(6) * den(356)) * TI2_call(4,momenta_87,masses2_4,G4tensor(:,85),T4sum(1:70,143))
  M(9) = M(9) + (f(3) * den(356)) * TI2_call(4,momenta_87,masses2_3,G4tensor(:,91),T4sum(1:70,144))
  M(15) = M(15) + (-f(3) * den(356)) * TI2_call(4,momenta_87,masses2_3,G4tensor(:,91),T4sum(1:70,144))
  M(22) = M(22) + (-f(3) * den(356)) * TI2_call(4,momenta_87,masses2_3,G4tensor(:,91),T4sum(1:70,144))
  M(24) = M(24) + (f(3) * den(356)) * TI2_call(4,momenta_87,masses2_3,G4tensor(:,91),T4sum(1:70,144))
  M(5) = M(5) + (CI*f(5) * den(183)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,198),T3sum(1:35,25))
  M(6) = M(6) + (-(CI*f(5)) * den(183)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,198),T3sum(1:35,25))
  M(9) = M(9) + (-(CI*f(5)) * den(183)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,198),T3sum(1:35,25))
  M(10) = M(10) + (CI*f(5) * den(183)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,198),T3sum(1:35,25))
  M(15) = M(15) + (CI*f(5) * den(183)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,198),T3sum(1:35,25))
  M(16) = M(16) + (-(CI*f(5)) * den(183)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,198),T3sum(1:35,25))
  M(19) = M(19) + (-(CI*f(5)) * den(183)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,198),T3sum(1:35,25))
  M(20) = M(20) + (CI*f(5) * den(183)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,198),T3sum(1:35,25))
  M(5) = M(5) + (CI*f(5) * den(183)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,192),T3sum(1:35,25))
  M(6) = M(6) + (-(CI*f(5)) * den(183)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,192),T3sum(1:35,25))
  M(9) = M(9) + (-(CI*f(5)) * den(183)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,192),T3sum(1:35,25))
  M(10) = M(10) + (CI*f(5) * den(183)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,192),T3sum(1:35,25))
  M(15) = M(15) + (CI*f(5) * den(183)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,192),T3sum(1:35,25))
  M(16) = M(16) + (-(CI*f(5)) * den(183)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,192),T3sum(1:35,25))
  M(19) = M(19) + (-(CI*f(5)) * den(183)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,192),T3sum(1:35,25))
  M(20) = M(20) + (CI*f(5) * den(183)) * TI2_call(3,momenta_12,masses2_2,G3tensor(:,192),T3sum(1:35,25))
  M(5) = M(5) + (CI*f(2) * den(183)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,204),T3sum(1:35,26))
  M(6) = M(6) + (-(CI*f(2)) * den(183)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,204),T3sum(1:35,26))
  M(9) = M(9) + (-(CI*f(2)) * den(183)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,204),T3sum(1:35,26))
  M(10) = M(10) + (CI*f(2) * den(183)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,204),T3sum(1:35,26))
  M(15) = M(15) + (CI*f(2) * den(183)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,204),T3sum(1:35,26))
  M(16) = M(16) + (-(CI*f(2)) * den(183)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,204),T3sum(1:35,26))
  M(19) = M(19) + (-(CI*f(2)) * den(183)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,204),T3sum(1:35,26))
  M(20) = M(20) + (CI*f(2) * den(183)) * TI2_call(3,momenta_12,masses2_1,G3tensor(:,204),T3sum(1:35,26))
  M(9) = M(9) + (-f(6) * den(358)) * TI2_call(4,momenta_86,masses2_4,G4tensor(:,89),T4sum(1:70,149))
  M(10) = M(10) + (f(6) * den(358)) * TI2_call(4,momenta_86,masses2_4,G4tensor(:,89),T4sum(1:70,149))
  M(15) = M(15) + (f(6) * den(358)) * TI2_call(4,momenta_86,masses2_4,G4tensor(:,89),T4sum(1:70,149))
  M(16) = M(16) + (-f(6) * den(358)) * TI2_call(4,momenta_86,masses2_4,G4tensor(:,89),T4sum(1:70,149))
  M(5) = M(5) + (-f(6) * den(358)) * TI2_call(4,momenta_86,masses2_4,G4tensor(:,86),T4sum(1:70,149))
  M(6) = M(6) + (f(6) * den(358)) * TI2_call(4,momenta_86,masses2_4,G4tensor(:,86),T4sum(1:70,149))
  M(19) = M(19) + (f(6) * den(358)) * TI2_call(4,momenta_86,masses2_4,G4tensor(:,86),T4sum(1:70,149))
  M(20) = M(20) + (-f(6) * den(358)) * TI2_call(4,momenta_86,masses2_4,G4tensor(:,86),T4sum(1:70,149))
  M(5) = M(5) + (-f(3) * den(358)) * TI2_call(4,momenta_86,masses2_3,G4tensor(:,92),T4sum(1:70,150))
  M(6) = M(6) + (f(3) * den(358)) * TI2_call(4,momenta_86,masses2_3,G4tensor(:,92),T4sum(1:70,150))
  M(19) = M(19) + (f(3) * den(358)) * TI2_call(4,momenta_86,masses2_3,G4tensor(:,92),T4sum(1:70,150))
  M(20) = M(20) + (-f(3) * den(358)) * TI2_call(4,momenta_86,masses2_3,G4tensor(:,92),T4sum(1:70,150))
  M(1) = M(1) + (CI*f(5) * den(51)) * TI2_call(5,momenta_210,masses2_6,G5tensor(:,47),T5sum(1:126,141))
  M(3) = M(3) + (-(CI*f(5)) * den(51)) * TI2_call(5,momenta_210,masses2_6,G5tensor(:,47),T5sum(1:126,141))
  M(22) = M(22) + (CI*f(5) * den(51)) * TI2_call(5,momenta_210,masses2_6,G5tensor(:,45),T5sum(1:126,141))
  M(24) = M(24) + (-(CI*f(5)) * den(51)) * TI2_call(5,momenta_210,masses2_6,G5tensor(:,45),T5sum(1:126,141))
  M(22) = M(22) + (CI*f(2) * den(51)) * TI2_call(5,momenta_210,masses2_5,G5tensor(:,49),T5sum(1:126,142))
  M(24) = M(24) + (-(CI*f(2)) * den(51)) * TI2_call(5,momenta_210,masses2_5,G5tensor(:,49),T5sum(1:126,142))
  M(10) = M(10) + (CI*f(5) * den(51)) * TI2_call(5,momenta_209,masses2_6,G5tensor(:,48),T5sum(1:126,143))
  M(16) = M(16) + (-(CI*f(5)) * den(51)) * TI2_call(5,momenta_209,masses2_6,G5tensor(:,48),T5sum(1:126,143))
  M(5) = M(5) + (CI*f(5) * den(51)) * TI2_call(5,momenta_209,masses2_6,G5tensor(:,46),T5sum(1:126,143))
  M(6) = M(6) + (-(CI*f(5)) * den(51)) * TI2_call(5,momenta_209,masses2_6,G5tensor(:,46),T5sum(1:126,143))
  M(5) = M(5) + (CI*f(2) * den(51)) * TI2_call(5,momenta_209,masses2_5,G5tensor(:,50),T5sum(1:126,144))
  M(6) = M(6) + (-(CI*f(2)) * den(51)) * TI2_call(5,momenta_209,masses2_5,G5tensor(:,50),T5sum(1:126,144))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_8

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_8_pphjjj2_hggggg_2_/**/REALKIND
