
module ol_vamp_5_pphjjj2_hggggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_5(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphjjj2_hggggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphjjj2_hggggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphjjj2_hggggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphjjj2_hggggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(24)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,79) :: G0
  complex(REALKIND), dimension(4,5,4,204) :: G1
  complex(REALKIND), dimension(4,15,4,252) :: G2
  complex(REALKIND), dimension(4,35,4,96) :: G3
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,78,32))
    allocate(G4tensorhel(70,48,32))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,110),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,22),MT,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,109),G1(:,:,:,2))
  call loop_Q_A(G1(:,:,:,2),Q(:,62),MT,G2(:,:,:,1))
  call loop_QS_A(G2(:,:,:,1),wf(:,0),G2(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,2),Q(:,63),MT,G3tensor(:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,-3),G1(:,:,:,3))
  call loop_Q_A(G1(:,:,:,3),Q(:,30),MT,G2(:,:,:,3))
  call loop_QV_A(G2(:,:,:,3),wf(:,-5),G2(:,:,:,4))
  call loop_Q_A(G2(:,:,:,4),Q(:,62),MT,G3(:,:,:,1))
  call loop_QS_A(G3(:,:,:,1),wf(:,0),G3(:,:,:,2),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,2),Q(:,63),MT,G4tensor(:,1))
  call loop_QV_A(G0(:,:,:,1),wf(:,112),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,22),MT,G1(:,:,:,4))
  call loop_QV_A(G1(:,:,:,4),wf(:,109),G1(:,:,:,5))
  call loop_Q_A(G1(:,:,:,5),Q(:,62),MT,G2(:,:,:,5))
  call loop_QS_A(G2(:,:,:,5),wf(:,0),G2(:,:,:,6),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,6),Q(:,63),MT,G3tensor(:,2))
  call loop_QV_A(G1(:,:,:,4),wf(:,-3),G1(:,:,:,6))
  call loop_Q_A(G1(:,:,:,6),Q(:,30),MT,G2(:,:,:,7))
  call loop_QV_A(G2(:,:,:,7),wf(:,-5),G2(:,:,:,8))
  call loop_Q_A(G2(:,:,:,8),Q(:,62),MT,G3(:,:,:,3))
  call loop_QS_A(G3(:,:,:,3),wf(:,0),G3(:,:,:,4),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,4),Q(:,63),MT,G4tensor(:,2))
  call loop_QV_A(G0(:,:,:,1),wf(:,113),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,22),MT,G1(:,:,:,7))
  call loop_QV_A(G1(:,:,:,7),wf(:,109),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,62),MT,G2(:,:,:,9))
  call loop_QS_A(G2(:,:,:,9),wf(:,0),G2(:,:,:,10),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,10),Q(:,63),MT,G3tensor(:,3))
  call loop_QV_A(G1(:,:,:,7),wf(:,-3),G1(:,:,:,9))
  call loop_Q_A(G1(:,:,:,9),Q(:,30),MT,G2(:,:,:,11))
  call loop_QV_A(G2(:,:,:,11),wf(:,-5),G2(:,:,:,12))
  call loop_Q_A(G2(:,:,:,12),Q(:,62),MT,G3(:,:,:,5))
  call loop_QS_A(G3(:,:,:,5),wf(:,0),G3(:,:,:,6),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,6),Q(:,63),MT,G4tensor(:,3))
  call loop_AV_Q(G0(:,:,:,1),wf(:,110),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,22),MT,G1(:,:,:,10))
  call loop_AV_Q(G1(:,:,:,10),wf(:,109),G1(:,:,:,11))
  call loop_A_Q(G1(:,:,:,11),Q(:,62),MT,G2(:,:,:,13))
  call loop_AS_Q(G2(:,:,:,13),wf(:,0),G2(:,:,:,14),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,14),Q(:,63),MT,G3tensor(:,4))
  call loop_AV_Q(G1(:,:,:,10),wf(:,-3),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,30),MT,G2(:,:,:,15))
  call loop_AV_Q(G2(:,:,:,15),wf(:,-5),G2(:,:,:,16))
  call loop_A_Q(G2(:,:,:,16),Q(:,62),MT,G3(:,:,:,7))
  call loop_AS_Q(G3(:,:,:,7),wf(:,0),G3(:,:,:,8),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,63),MT,G4tensor(:,4))
  call loop_AV_Q(G0(:,:,:,1),wf(:,112),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,22),MT,G1(:,:,:,13))
  call loop_AV_Q(G1(:,:,:,13),wf(:,109),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,62),MT,G2(:,:,:,17))
  call loop_AS_Q(G2(:,:,:,17),wf(:,0),G2(:,:,:,18),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,18),Q(:,63),MT,G3tensor(:,5))
  call loop_AV_Q(G1(:,:,:,13),wf(:,-3),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,30),MT,G2(:,:,:,19))
  call loop_AV_Q(G2(:,:,:,19),wf(:,-5),G2(:,:,:,20))
  call loop_A_Q(G2(:,:,:,20),Q(:,62),MT,G3(:,:,:,9))
  call loop_AS_Q(G3(:,:,:,9),wf(:,0),G3(:,:,:,10),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,10),Q(:,63),MT,G4tensor(:,5))
  call loop_AV_Q(G0(:,:,:,1),wf(:,113),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,22),MT,G1(:,:,:,16))
  call loop_AV_Q(G1(:,:,:,16),wf(:,109),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,62),MT,G2(:,:,:,21))
  call loop_AS_Q(G2(:,:,:,21),wf(:,0),G2(:,:,:,22),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,22),Q(:,63),MT,G3tensor(:,6))
  call loop_AV_Q(G1(:,:,:,16),wf(:,-3),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,30),MT,G2(:,:,:,23))
  call loop_AV_Q(G2(:,:,:,23),wf(:,-5),G2(:,:,:,24))
  call loop_A_Q(G2(:,:,:,24),Q(:,62),MT,G3(:,:,:,11))
  call loop_AS_Q(G3(:,:,:,11),wf(:,0),G3(:,:,:,12),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,12),Q(:,63),MT,G4tensor(:,6))
  call loop_QV_A(G0(:,:,:,1),wf(:,349),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,30),MT,G1(:,:,:,19))
  call loop_QV_A(G1(:,:,:,19),wf(:,-5),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,62),MT,G2(:,:,:,25))
  call loop_QS_A(G2(:,:,:,25),wf(:,0),G2(:,:,:,26),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,26),Q(:,63),MT,G3tensor(:,7))
  call loop_QV_A(G0(:,:,:,1),wf(:,350),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,30),MT,G1(:,:,:,21))
  call loop_QV_A(G1(:,:,:,21),wf(:,-5),G1(:,:,:,22))
  call loop_Q_A(G1(:,:,:,22),Q(:,62),MT,G2(:,:,:,27))
  call loop_QS_A(G2(:,:,:,27),wf(:,0),G2(:,:,:,28),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,28),Q(:,63),MT,G3tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,351),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,30),MT,G1(:,:,:,23))
  call loop_QV_A(G1(:,:,:,23),wf(:,-5),G1(:,:,:,24))
  call loop_Q_A(G1(:,:,:,24),Q(:,62),MT,G2(:,:,:,29))
  call loop_QS_A(G2(:,:,:,29),wf(:,0),G2(:,:,:,30),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,30),Q(:,63),MT,G3tensor(:,9))
  call loop_AV_Q(G0(:,:,:,1),wf(:,349),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,30),MT,G1(:,:,:,25))
  call loop_AV_Q(G1(:,:,:,25),wf(:,-5),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,62),MT,G2(:,:,:,31))
  call loop_AS_Q(G2(:,:,:,31),wf(:,0),G2(:,:,:,32),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,32),Q(:,63),MT,G3tensor(:,10))
  call loop_AV_Q(G0(:,:,:,1),wf(:,350),G0(:,:,:,12))
  call loop_A_Q(G0(:,:,:,12),Q(:,30),MT,G1(:,:,:,27))
  call loop_AV_Q(G1(:,:,:,27),wf(:,-5),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,62),MT,G2(:,:,:,33))
  call loop_AS_Q(G2(:,:,:,33),wf(:,0),G2(:,:,:,34),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,34),Q(:,63),MT,G3tensor(:,11))
  call loop_AV_Q(G0(:,:,:,1),wf(:,351),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,30),MT,G1(:,:,:,29))
  call loop_AV_Q(G1(:,:,:,29),wf(:,-5),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,62),MT,G2(:,:,:,35))
  call loop_AS_Q(G2(:,:,:,35),wf(:,0),G2(:,:,:,36),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,36),Q(:,63),MT,G3tensor(:,12))
  call loop_QV_A(G0(:,:,:,1),wf(:,120),G0(:,:,:,14))
  call loop_Q_A(G0(:,:,:,14),Q(:,14),MT,G1(:,:,:,31))
  call loop_QV_A(G1(:,:,:,31),wf(:,119),G1(:,:,:,32))
  call loop_Q_A(G1(:,:,:,32),Q(:,62),MT,G2(:,:,:,37))
  call loop_QS_A(G2(:,:,:,37),wf(:,0),G2(:,:,:,38),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,38),Q(:,63),MT,G3tensor(:,13))
  call loop_QV_A(G1(:,:,:,31),wf(:,-5),G1(:,:,:,33))
  call loop_Q_A(G1(:,:,:,33),Q(:,46),MT,G2(:,:,:,39))
  call loop_QV_A(G2(:,:,:,39),wf(:,-4),G2(:,:,:,40))
  call loop_Q_A(G2(:,:,:,40),Q(:,62),MT,G3(:,:,:,13))
  call loop_QS_A(G3(:,:,:,13),wf(:,0),G3(:,:,:,14),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,14),Q(:,63),MT,G4tensor(:,7))
  call loop_QV_A(G1(:,:,:,31),wf(:,-4),G1(:,:,:,34))
  call loop_Q_A(G1(:,:,:,34),Q(:,30),MT,G2(:,:,:,41))
  call loop_QV_A(G2(:,:,:,41),wf(:,-5),G2(:,:,:,42))
  call loop_Q_A(G2(:,:,:,42),Q(:,62),MT,G3(:,:,:,15))
  call loop_QS_A(G3(:,:,:,15),wf(:,0),G3(:,:,:,16),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,16),Q(:,63),MT,G4tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,122),G0(:,:,:,15))
  call loop_Q_A(G0(:,:,:,15),Q(:,14),MT,G1(:,:,:,35))
  call loop_QV_A(G1(:,:,:,35),wf(:,119),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,62),MT,G2(:,:,:,43))
  call loop_QS_A(G2(:,:,:,43),wf(:,0),G2(:,:,:,44),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,44),Q(:,63),MT,G3tensor(:,14))
  call loop_QV_A(G1(:,:,:,35),wf(:,-5),G1(:,:,:,37))
  call loop_Q_A(G1(:,:,:,37),Q(:,46),MT,G2(:,:,:,45))
  call loop_QV_A(G2(:,:,:,45),wf(:,-4),G2(:,:,:,46))
  call loop_Q_A(G2(:,:,:,46),Q(:,62),MT,G3(:,:,:,17))
  call loop_QS_A(G3(:,:,:,17),wf(:,0),G3(:,:,:,18),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,18),Q(:,63),MT,G4tensor(:,9))
  call loop_QV_A(G1(:,:,:,35),wf(:,-4),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,30),MT,G2(:,:,:,47))
  call loop_QV_A(G2(:,:,:,47),wf(:,-5),G2(:,:,:,48))
  call loop_Q_A(G2(:,:,:,48),Q(:,62),MT,G3(:,:,:,19))
  call loop_QS_A(G3(:,:,:,19),wf(:,0),G3(:,:,:,20),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,20),Q(:,63),MT,G4tensor(:,10))
  call loop_QV_A(G0(:,:,:,1),wf(:,123),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,14),MT,G1(:,:,:,39))
  call loop_QV_A(G1(:,:,:,39),wf(:,119),G1(:,:,:,40))
  call loop_Q_A(G1(:,:,:,40),Q(:,62),MT,G2(:,:,:,49))
  call loop_QS_A(G2(:,:,:,49),wf(:,0),G2(:,:,:,50),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,50),Q(:,63),MT,G3tensor(:,15))
  call loop_QV_A(G1(:,:,:,39),wf(:,-5),G1(:,:,:,41))
  call loop_Q_A(G1(:,:,:,41),Q(:,46),MT,G2(:,:,:,51))
  call loop_QV_A(G2(:,:,:,51),wf(:,-4),G2(:,:,:,52))
  call loop_Q_A(G2(:,:,:,52),Q(:,62),MT,G3(:,:,:,21))
  call loop_QS_A(G3(:,:,:,21),wf(:,0),G3(:,:,:,22),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,22),Q(:,63),MT,G4tensor(:,11))
  call loop_QV_A(G1(:,:,:,39),wf(:,-4),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,30),MT,G2(:,:,:,53))
  call loop_QV_A(G2(:,:,:,53),wf(:,-5),G2(:,:,:,54))
  call loop_Q_A(G2(:,:,:,54),Q(:,62),MT,G3(:,:,:,23))
  call loop_QS_A(G3(:,:,:,23),wf(:,0),G3(:,:,:,24),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,24),Q(:,63),MT,G4tensor(:,12))
  call loop_AV_Q(G0(:,:,:,1),wf(:,120),G0(:,:,:,17))
  call loop_A_Q(G0(:,:,:,17),Q(:,14),MT,G1(:,:,:,43))
  call loop_AV_Q(G1(:,:,:,43),wf(:,119),G1(:,:,:,44))
  call loop_A_Q(G1(:,:,:,44),Q(:,62),MT,G2(:,:,:,55))
  call loop_AS_Q(G2(:,:,:,55),wf(:,0),G2(:,:,:,56),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,56),Q(:,63),MT,G3tensor(:,16))
  call loop_AV_Q(G1(:,:,:,43),wf(:,-5),G1(:,:,:,45))
  call loop_A_Q(G1(:,:,:,45),Q(:,46),MT,G2(:,:,:,57))
  call loop_AV_Q(G2(:,:,:,57),wf(:,-4),G2(:,:,:,58))
  call loop_A_Q(G2(:,:,:,58),Q(:,62),MT,G3(:,:,:,25))
  call loop_AS_Q(G3(:,:,:,25),wf(:,0),G3(:,:,:,26),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,26),Q(:,63),MT,G4tensor(:,13))
  call loop_AV_Q(G1(:,:,:,43),wf(:,-4),G1(:,:,:,46))
  call loop_A_Q(G1(:,:,:,46),Q(:,30),MT,G2(:,:,:,59))
  call loop_AV_Q(G2(:,:,:,59),wf(:,-5),G2(:,:,:,60))
  call loop_A_Q(G2(:,:,:,60),Q(:,62),MT,G3(:,:,:,27))
  call loop_AS_Q(G3(:,:,:,27),wf(:,0),G3(:,:,:,28),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,28),Q(:,63),MT,G4tensor(:,14))
  call loop_AV_Q(G0(:,:,:,1),wf(:,122),G0(:,:,:,18))
  call loop_A_Q(G0(:,:,:,18),Q(:,14),MT,G1(:,:,:,47))
  call loop_AV_Q(G1(:,:,:,47),wf(:,119),G1(:,:,:,48))
  call loop_A_Q(G1(:,:,:,48),Q(:,62),MT,G2(:,:,:,61))
  call loop_AS_Q(G2(:,:,:,61),wf(:,0),G2(:,:,:,62),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,62),Q(:,63),MT,G3tensor(:,17))
  call loop_AV_Q(G1(:,:,:,47),wf(:,-5),G1(:,:,:,49))
  call loop_A_Q(G1(:,:,:,49),Q(:,46),MT,G2(:,:,:,63))
  call loop_AV_Q(G2(:,:,:,63),wf(:,-4),G2(:,:,:,64))
  call loop_A_Q(G2(:,:,:,64),Q(:,62),MT,G3(:,:,:,29))
  call loop_AS_Q(G3(:,:,:,29),wf(:,0),G3(:,:,:,30),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,30),Q(:,63),MT,G4tensor(:,15))
  call loop_AV_Q(G1(:,:,:,47),wf(:,-4),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,30),MT,G2(:,:,:,65))
  call loop_AV_Q(G2(:,:,:,65),wf(:,-5),G2(:,:,:,66))
  call loop_A_Q(G2(:,:,:,66),Q(:,62),MT,G3(:,:,:,31))
  call loop_AS_Q(G3(:,:,:,31),wf(:,0),G3(:,:,:,32),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,32),Q(:,63),MT,G4tensor(:,16))
  call loop_AV_Q(G0(:,:,:,1),wf(:,123),G0(:,:,:,19))
  call loop_A_Q(G0(:,:,:,19),Q(:,14),MT,G1(:,:,:,51))
  call loop_AV_Q(G1(:,:,:,51),wf(:,119),G1(:,:,:,52))
  call loop_A_Q(G1(:,:,:,52),Q(:,62),MT,G2(:,:,:,67))
  call loop_AS_Q(G2(:,:,:,67),wf(:,0),G2(:,:,:,68),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,68),Q(:,63),MT,G3tensor(:,18))
  call loop_AV_Q(G1(:,:,:,51),wf(:,-5),G1(:,:,:,53))
  call loop_A_Q(G1(:,:,:,53),Q(:,46),MT,G2(:,:,:,69))
  call loop_AV_Q(G2(:,:,:,69),wf(:,-4),G2(:,:,:,70))
  call loop_A_Q(G2(:,:,:,70),Q(:,62),MT,G3(:,:,:,33))
  call loop_AS_Q(G3(:,:,:,33),wf(:,0),G3(:,:,:,34),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,34),Q(:,63),MT,G4tensor(:,17))
  call loop_AV_Q(G1(:,:,:,51),wf(:,-4),G1(:,:,:,54))
  call loop_A_Q(G1(:,:,:,54),Q(:,30),MT,G2(:,:,:,71))
  call loop_AV_Q(G2(:,:,:,71),wf(:,-5),G2(:,:,:,72))
  call loop_A_Q(G2(:,:,:,72),Q(:,62),MT,G3(:,:,:,35))
  call loop_AS_Q(G3(:,:,:,35),wf(:,0),G3(:,:,:,36),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,36),Q(:,63),MT,G4tensor(:,18))
  call loop_QV_A(G0(:,:,:,1),wf(:,355),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,30),MT,G1(:,:,:,55))
  call loop_QV_A(G1(:,:,:,55),wf(:,-5),G1(:,:,:,56))
  call loop_Q_A(G1(:,:,:,56),Q(:,62),MT,G2(:,:,:,73))
  call loop_QS_A(G2(:,:,:,73),wf(:,0),G2(:,:,:,74),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,74),Q(:,63),MT,G3tensor(:,19))
  call loop_QV_A(G0(:,:,:,1),wf(:,356),G0(:,:,:,21))
  call loop_Q_A(G0(:,:,:,21),Q(:,30),MT,G1(:,:,:,57))
  call loop_QV_A(G1(:,:,:,57),wf(:,-5),G1(:,:,:,58))
  call loop_Q_A(G1(:,:,:,58),Q(:,62),MT,G2(:,:,:,75))
  call loop_QS_A(G2(:,:,:,75),wf(:,0),G2(:,:,:,76),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,76),Q(:,63),MT,G3tensor(:,20))
  call loop_QV_A(G0(:,:,:,1),wf(:,357),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,30),MT,G1(:,:,:,59))
  call loop_QV_A(G1(:,:,:,59),wf(:,-5),G1(:,:,:,60))
  call loop_Q_A(G1(:,:,:,60),Q(:,62),MT,G2(:,:,:,77))
  call loop_QS_A(G2(:,:,:,77),wf(:,0),G2(:,:,:,78),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,78),Q(:,63),MT,G3tensor(:,21))
  call loop_AV_Q(G0(:,:,:,1),wf(:,355),G0(:,:,:,23))
  call loop_A_Q(G0(:,:,:,23),Q(:,30),MT,G1(:,:,:,61))
  call loop_AV_Q(G1(:,:,:,61),wf(:,-5),G1(:,:,:,62))
  call loop_A_Q(G1(:,:,:,62),Q(:,62),MT,G2(:,:,:,79))
  call loop_AS_Q(G2(:,:,:,79),wf(:,0),G2(:,:,:,80),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,80),Q(:,63),MT,G3tensor(:,22))
  call loop_AV_Q(G0(:,:,:,1),wf(:,356),G0(:,:,:,24))
  call loop_A_Q(G0(:,:,:,24),Q(:,30),MT,G1(:,:,:,63))
  call loop_AV_Q(G1(:,:,:,63),wf(:,-5),G1(:,:,:,64))
  call loop_A_Q(G1(:,:,:,64),Q(:,62),MT,G2(:,:,:,81))
  call loop_AS_Q(G2(:,:,:,81),wf(:,0),G2(:,:,:,82),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,82),Q(:,63),MT,G3tensor(:,23))
  call loop_AV_Q(G0(:,:,:,1),wf(:,357),G0(:,:,:,25))
  call loop_A_Q(G0(:,:,:,25),Q(:,30),MT,G1(:,:,:,65))
  call loop_AV_Q(G1(:,:,:,65),wf(:,-5),G1(:,:,:,66))
  call loop_A_Q(G1(:,:,:,66),Q(:,62),MT,G2(:,:,:,83))
  call loop_AS_Q(G2(:,:,:,83),wf(:,0),G2(:,:,:,84),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,84),Q(:,63),MT,G3tensor(:,24))
  call loop_QV_A(G0(:,:,:,1),wf(:,361),G0(:,:,:,26))
  call loop_Q_A(G0(:,:,:,26),Q(:,30),MT,G1(:,:,:,67))
  call loop_QV_A(G1(:,:,:,67),wf(:,-5),G1(:,:,:,68))
  call loop_Q_A(G1(:,:,:,68),Q(:,62),MT,G2(:,:,:,85))
  call loop_QS_A(G2(:,:,:,85),wf(:,0),G2(:,:,:,86),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,86),Q(:,63),MT,G3tensor(:,25))
  call loop_AV_Q(G0(:,:,:,1),wf(:,361),G0(:,:,:,27))
  call loop_A_Q(G0(:,:,:,27),Q(:,30),MT,G1(:,:,:,69))
  call loop_AV_Q(G1(:,:,:,69),wf(:,-5),G1(:,:,:,70))
  call loop_A_Q(G1(:,:,:,70),Q(:,62),MT,G2(:,:,:,87))
  call loop_AS_Q(G2(:,:,:,87),wf(:,0),G2(:,:,:,88),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,88),Q(:,63),MT,G3tensor(:,26))
  call loop_QV_A(G0(:,:,:,1),wf(:,170),G0(:,:,:,28))
  call loop_Q_A(G0(:,:,:,28),Q(:,22),MT,G1(:,:,:,71))
  call loop_QV_A(G1(:,:,:,71),wf(:,109),G1(:,:,:,72))
  call loop_Q_A(G1(:,:,:,72),Q(:,62),MT,G2(:,:,:,89))
  call loop_QS_A(G2(:,:,:,89),wf(:,0),G2(:,:,:,90),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,90),Q(:,63),MT,G3tensor(:,27))
  call loop_QV_A(G1(:,:,:,71),wf(:,-3),G1(:,:,:,73))
  call loop_Q_A(G1(:,:,:,73),Q(:,30),MT,G2(:,:,:,91))
  call loop_QV_A(G2(:,:,:,91),wf(:,-5),G2(:,:,:,92))
  call loop_Q_A(G2(:,:,:,92),Q(:,62),MT,G3(:,:,:,37))
  call loop_QS_A(G3(:,:,:,37),wf(:,0),G3(:,:,:,38),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,38),Q(:,63),MT,G4tensor(:,19))
  call loop_AV_Q(G0(:,:,:,1),wf(:,170),G0(:,:,:,29))
  call loop_A_Q(G0(:,:,:,29),Q(:,22),MT,G1(:,:,:,74))
  call loop_AV_Q(G1(:,:,:,74),wf(:,109),G1(:,:,:,75))
  call loop_A_Q(G1(:,:,:,75),Q(:,62),MT,G2(:,:,:,93))
  call loop_AS_Q(G2(:,:,:,93),wf(:,0),G2(:,:,:,94),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,94),Q(:,63),MT,G3tensor(:,28))
  call loop_AV_Q(G1(:,:,:,74),wf(:,-3),G1(:,:,:,76))
  call loop_A_Q(G1(:,:,:,76),Q(:,30),MT,G2(:,:,:,95))
  call loop_AV_Q(G2(:,:,:,95),wf(:,-5),G2(:,:,:,96))
  call loop_A_Q(G2(:,:,:,96),Q(:,62),MT,G3(:,:,:,39))
  call loop_AS_Q(G3(:,:,:,39),wf(:,0),G3(:,:,:,40),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,40),Q(:,63),MT,G4tensor(:,20))
  call loop_AV_Q(G0(:,:,:,1),wf(:,172),G0(:,:,:,30))
  call loop_A_Q(G0(:,:,:,30),Q(:,14),MT,G1(:,:,:,77))
  call loop_AV_Q(G1(:,:,:,77),wf(:,119),G1(:,:,:,78))
  call loop_A_Q(G1(:,:,:,78),Q(:,62),MT,G2(:,:,:,97))
  call loop_AS_Q(G2(:,:,:,97),wf(:,0),G2(:,:,:,98),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,98),Q(:,63),MT,G3tensor(:,29))
  call loop_AV_Q(G1(:,:,:,77),wf(:,-5),G1(:,:,:,79))
  call loop_A_Q(G1(:,:,:,79),Q(:,46),MT,G2(:,:,:,99))
  call loop_AV_Q(G2(:,:,:,99),wf(:,-4),G2(:,:,:,100))
  call loop_A_Q(G2(:,:,:,100),Q(:,62),MT,G3(:,:,:,41))
  call loop_AS_Q(G3(:,:,:,41),wf(:,0),G3(:,:,:,42),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,42),Q(:,63),MT,G4tensor(:,21))
  call loop_AV_Q(G1(:,:,:,77),wf(:,-4),G1(:,:,:,80))
  call loop_A_Q(G1(:,:,:,80),Q(:,30),MT,G2(:,:,:,101))
  call loop_AV_Q(G2(:,:,:,101),wf(:,-5),G2(:,:,:,102))
  call loop_A_Q(G2(:,:,:,102),Q(:,62),MT,G3(:,:,:,43))
  call loop_AS_Q(G3(:,:,:,43),wf(:,0),G3(:,:,:,44),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,44),Q(:,63),MT,G4tensor(:,22))
  call loop_QV_A(G0(:,:,:,1),wf(:,172),G0(:,:,:,31))
  call loop_Q_A(G0(:,:,:,31),Q(:,14),MT,G1(:,:,:,81))
  call loop_QV_A(G1(:,:,:,81),wf(:,119),G1(:,:,:,82))
  call loop_Q_A(G1(:,:,:,82),Q(:,62),MT,G2(:,:,:,103))
  call loop_QS_A(G2(:,:,:,103),wf(:,0),G2(:,:,:,104),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,104),Q(:,63),MT,G3tensor(:,30))
  call loop_QV_A(G1(:,:,:,81),wf(:,-5),G1(:,:,:,83))
  call loop_Q_A(G1(:,:,:,83),Q(:,46),MT,G2(:,:,:,105))
  call loop_QV_A(G2(:,:,:,105),wf(:,-4),G2(:,:,:,106))
  call loop_Q_A(G2(:,:,:,106),Q(:,62),MT,G3(:,:,:,45))
  call loop_QS_A(G3(:,:,:,45),wf(:,0),G3(:,:,:,46),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,46),Q(:,63),MT,G4tensor(:,23))
  call loop_QV_A(G1(:,:,:,81),wf(:,-4),G1(:,:,:,84))
  call loop_Q_A(G1(:,:,:,84),Q(:,30),MT,G2(:,:,:,107))
  call loop_QV_A(G2(:,:,:,107),wf(:,-5),G2(:,:,:,108))
  call loop_Q_A(G2(:,:,:,108),Q(:,62),MT,G3(:,:,:,47))
  call loop_QS_A(G3(:,:,:,47),wf(:,0),G3(:,:,:,48),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,48),Q(:,63),MT,G4tensor(:,24))
  call loop_QV_A(G0(:,:,:,1),wf(:,364),G0(:,:,:,32))
  call loop_Q_A(G0(:,:,:,32),Q(:,30),MT,G1(:,:,:,85))
  call loop_QV_A(G1(:,:,:,85),wf(:,-5),G1(:,:,:,86))
  call loop_Q_A(G1(:,:,:,86),Q(:,62),MT,G2(:,:,:,109))
  call loop_QS_A(G2(:,:,:,109),wf(:,0),G2(:,:,:,110),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,110),Q(:,63),MT,G3tensor(:,31))
  call loop_AV_Q(G0(:,:,:,1),wf(:,364),G0(:,:,:,33))
  call loop_A_Q(G0(:,:,:,33),Q(:,30),MT,G1(:,:,:,87))
  call loop_AV_Q(G1(:,:,:,87),wf(:,-5),G1(:,:,:,88))
  call loop_A_Q(G1(:,:,:,88),Q(:,62),MT,G2(:,:,:,111))
  call loop_AS_Q(G2(:,:,:,111),wf(:,0),G2(:,:,:,112),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,112),Q(:,63),MT,G3tensor(:,32))
  call loop_QV_A(G0(:,:,:,1),wf(:,366),G0(:,:,:,34))
  call loop_Q_A(G0(:,:,:,34),Q(:,30),MT,G1(:,:,:,89))
  call loop_QV_A(G1(:,:,:,89),wf(:,-5),G1(:,:,:,90))
  call loop_Q_A(G1(:,:,:,90),Q(:,62),MT,G2(:,:,:,113))
  call loop_QS_A(G2(:,:,:,113),wf(:,0),G2(:,:,:,114),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,114),Q(:,63),MT,G3tensor(:,33))
  call loop_AV_Q(G0(:,:,:,1),wf(:,366),G0(:,:,:,35))
  call loop_A_Q(G0(:,:,:,35),Q(:,30),MT,G1(:,:,:,91))
  call loop_AV_Q(G1(:,:,:,91),wf(:,-5),G1(:,:,:,92))
  call loop_A_Q(G1(:,:,:,92),Q(:,62),MT,G2(:,:,:,115))
  call loop_AS_Q(G2(:,:,:,115),wf(:,0),G2(:,:,:,116),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,116),Q(:,63),MT,G3tensor(:,34))
  call loop_QV_A(G0(:,:,:,1),wf(:,370),G0(:,:,:,36))
  call loop_Q_A(G0(:,:,:,36),Q(:,30),MT,G1(:,:,:,93))
  call loop_QV_A(G1(:,:,:,93),wf(:,-5),G1(:,:,:,94))
  call loop_Q_A(G1(:,:,:,94),Q(:,62),MT,G2(:,:,:,117))
  call loop_QS_A(G2(:,:,:,117),wf(:,0),G2(:,:,:,118),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,118),Q(:,63),MT,G3tensor(:,35))
  call loop_AV_Q(G0(:,:,:,1),wf(:,370),G0(:,:,:,37))
  call loop_A_Q(G0(:,:,:,37),Q(:,30),MT,G1(:,:,:,95))
  call loop_AV_Q(G1(:,:,:,95),wf(:,-5),G1(:,:,:,96))
  call loop_A_Q(G1(:,:,:,96),Q(:,62),MT,G2(:,:,:,119))
  call loop_AS_Q(G2(:,:,:,119),wf(:,0),G2(:,:,:,120),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,120),Q(:,63),MT,G3tensor(:,36))
  call loop_QV_A(G0(:,:,:,1),wf(:,179),G0(:,:,:,38))
  call loop_Q_A(G0(:,:,:,38),Q(:,26),MT,G1(:,:,:,97))
  call loop_QV_A(G1(:,:,:,97),wf(:,84),G1(:,:,:,98))
  call loop_Q_A(G1(:,:,:,98),Q(:,62),MT,G2(:,:,:,121))
  call loop_QS_A(G2(:,:,:,121),wf(:,0),G2(:,:,:,122),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,122),Q(:,63),MT,G3tensor(:,37))
  call loop_QV_A(G1(:,:,:,97),wf(:,-2),G1(:,:,:,99))
  call loop_Q_A(G1(:,:,:,99),Q(:,30),MT,G2(:,:,:,123))
  call loop_QV_A(G2(:,:,:,123),wf(:,-5),G2(:,:,:,124))
  call loop_Q_A(G2(:,:,:,124),Q(:,62),MT,G3(:,:,:,49))
  call loop_QS_A(G3(:,:,:,49),wf(:,0),G3(:,:,:,50),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,50),Q(:,63),MT,G4tensor(:,25))
  call loop_AV_Q(G0(:,:,:,1),wf(:,179),G0(:,:,:,39))
  call loop_A_Q(G0(:,:,:,39),Q(:,26),MT,G1(:,:,:,100))
  call loop_AV_Q(G1(:,:,:,100),wf(:,84),G1(:,:,:,101))
  call loop_A_Q(G1(:,:,:,101),Q(:,62),MT,G2(:,:,:,125))
  call loop_AS_Q(G2(:,:,:,125),wf(:,0),G2(:,:,:,126),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,126),Q(:,63),MT,G3tensor(:,38))
  call loop_AV_Q(G1(:,:,:,100),wf(:,-2),G1(:,:,:,102))
  call loop_A_Q(G1(:,:,:,102),Q(:,30),MT,G2(:,:,:,127))
  call loop_AV_Q(G2(:,:,:,127),wf(:,-5),G2(:,:,:,128))
  call loop_A_Q(G2(:,:,:,128),Q(:,62),MT,G3(:,:,:,51))
  call loop_AS_Q(G3(:,:,:,51),wf(:,0),G3(:,:,:,52),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,52),Q(:,63),MT,G4tensor(:,26))
  call loop_AV_Q(G0(:,:,:,1),wf(:,181),G0(:,:,:,40))
  call loop_A_Q(G0(:,:,:,40),Q(:,14),MT,G1(:,:,:,103))
  call loop_AV_Q(G1(:,:,:,103),wf(:,119),G1(:,:,:,104))
  call loop_A_Q(G1(:,:,:,104),Q(:,62),MT,G2(:,:,:,129))
  call loop_AS_Q(G2(:,:,:,129),wf(:,0),G2(:,:,:,130),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,130),Q(:,63),MT,G3tensor(:,39))
  call loop_AV_Q(G1(:,:,:,103),wf(:,-5),G1(:,:,:,105))
  call loop_A_Q(G1(:,:,:,105),Q(:,46),MT,G2(:,:,:,131))
  call loop_AV_Q(G2(:,:,:,131),wf(:,-4),G2(:,:,:,132))
  call loop_A_Q(G2(:,:,:,132),Q(:,62),MT,G3(:,:,:,53))
  call loop_AS_Q(G3(:,:,:,53),wf(:,0),G3(:,:,:,54),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,54),Q(:,63),MT,G4tensor(:,27))
  call loop_AV_Q(G1(:,:,:,103),wf(:,-4),G1(:,:,:,106))
  call loop_A_Q(G1(:,:,:,106),Q(:,30),MT,G2(:,:,:,133))
  call loop_AV_Q(G2(:,:,:,133),wf(:,-5),G2(:,:,:,134))
  call loop_A_Q(G2(:,:,:,134),Q(:,62),MT,G3(:,:,:,55))
  call loop_AS_Q(G3(:,:,:,55),wf(:,0),G3(:,:,:,56),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,56),Q(:,63),MT,G4tensor(:,28))
  call loop_QV_A(G0(:,:,:,1),wf(:,181),G0(:,:,:,41))
  call loop_Q_A(G0(:,:,:,41),Q(:,14),MT,G1(:,:,:,107))
  call loop_QV_A(G1(:,:,:,107),wf(:,119),G1(:,:,:,108))
  call loop_Q_A(G1(:,:,:,108),Q(:,62),MT,G2(:,:,:,135))
  call loop_QS_A(G2(:,:,:,135),wf(:,0),G2(:,:,:,136),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,136),Q(:,63),MT,G3tensor(:,40))
  call loop_QV_A(G1(:,:,:,107),wf(:,-5),G1(:,:,:,109))
  call loop_Q_A(G1(:,:,:,109),Q(:,46),MT,G2(:,:,:,137))
  call loop_QV_A(G2(:,:,:,137),wf(:,-4),G2(:,:,:,138))
  call loop_Q_A(G2(:,:,:,138),Q(:,62),MT,G3(:,:,:,57))
  call loop_QS_A(G3(:,:,:,57),wf(:,0),G3(:,:,:,58),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,58),Q(:,63),MT,G4tensor(:,29))
  call loop_QV_A(G1(:,:,:,107),wf(:,-4),G1(:,:,:,110))
  call loop_Q_A(G1(:,:,:,110),Q(:,30),MT,G2(:,:,:,139))
  call loop_QV_A(G2(:,:,:,139),wf(:,-5),G2(:,:,:,140))
  call loop_Q_A(G2(:,:,:,140),Q(:,62),MT,G3(:,:,:,59))
  call loop_QS_A(G3(:,:,:,59),wf(:,0),G3(:,:,:,60),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,60),Q(:,63),MT,G4tensor(:,30))
  call loop_QV_A(G0(:,:,:,1),wf(:,373),G0(:,:,:,42))
  call loop_Q_A(G0(:,:,:,42),Q(:,30),MT,G1(:,:,:,111))
  call loop_QV_A(G1(:,:,:,111),wf(:,-5),G1(:,:,:,112))
  call loop_Q_A(G1(:,:,:,112),Q(:,62),MT,G2(:,:,:,141))
  call loop_QS_A(G2(:,:,:,141),wf(:,0),G2(:,:,:,142),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,142),Q(:,63),MT,G3tensor(:,41))
  call loop_AV_Q(G0(:,:,:,1),wf(:,373),G0(:,:,:,43))
  call loop_A_Q(G0(:,:,:,43),Q(:,30),MT,G1(:,:,:,113))
  call loop_AV_Q(G1(:,:,:,113),wf(:,-5),G1(:,:,:,114))
  call loop_A_Q(G1(:,:,:,114),Q(:,62),MT,G2(:,:,:,143))
  call loop_AS_Q(G2(:,:,:,143),wf(:,0),G2(:,:,:,144),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,144),Q(:,63),MT,G3tensor(:,42))
  call loop_QV_A(G0(:,:,:,1),wf(:,375),G0(:,:,:,44))
  call loop_Q_A(G0(:,:,:,44),Q(:,30),MT,G1(:,:,:,115))
  call loop_QV_A(G1(:,:,:,115),wf(:,-5),G1(:,:,:,116))
  call loop_Q_A(G1(:,:,:,116),Q(:,62),MT,G2(:,:,:,145))
  call loop_QS_A(G2(:,:,:,145),wf(:,0),G2(:,:,:,146),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,146),Q(:,63),MT,G3tensor(:,43))
  call loop_AV_Q(G0(:,:,:,1),wf(:,375),G0(:,:,:,45))
  call loop_A_Q(G0(:,:,:,45),Q(:,30),MT,G1(:,:,:,117))
  call loop_AV_Q(G1(:,:,:,117),wf(:,-5),G1(:,:,:,118))
  call loop_A_Q(G1(:,:,:,118),Q(:,62),MT,G2(:,:,:,147))
  call loop_AS_Q(G2(:,:,:,147),wf(:,0),G2(:,:,:,148),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,148),Q(:,63),MT,G3tensor(:,44))
  call loop_QV_A(G0(:,:,:,1),wf(:,379),G0(:,:,:,46))
  call loop_Q_A(G0(:,:,:,46),Q(:,30),MT,G1(:,:,:,119))
  call loop_QV_A(G1(:,:,:,119),wf(:,-5),G1(:,:,:,120))
  call loop_Q_A(G1(:,:,:,120),Q(:,62),MT,G2(:,:,:,149))
  call loop_QS_A(G2(:,:,:,149),wf(:,0),G2(:,:,:,150),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,150),Q(:,63),MT,G3tensor(:,45))
  call loop_AV_Q(G0(:,:,:,1),wf(:,379),G0(:,:,:,47))
  call loop_A_Q(G0(:,:,:,47),Q(:,30),MT,G1(:,:,:,121))
  call loop_AV_Q(G1(:,:,:,121),wf(:,-5),G1(:,:,:,122))
  call loop_A_Q(G1(:,:,:,122),Q(:,62),MT,G2(:,:,:,151))
  call loop_AS_Q(G2(:,:,:,151),wf(:,0),G2(:,:,:,152),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,152),Q(:,63),MT,G3tensor(:,46))
  call loop_QV_A(G0(:,:,:,1),wf(:,186),G0(:,:,:,48))
  call loop_Q_A(G0(:,:,:,48),Q(:,28),MT,G1(:,:,:,123))
  call loop_QV_A(G1(:,:,:,123),wf(:,37),G1(:,:,:,124))
  call loop_Q_A(G1(:,:,:,124),Q(:,62),MT,G2(:,:,:,153))
  call loop_QS_A(G2(:,:,:,153),wf(:,0),G2(:,:,:,154),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,154),Q(:,63),MT,G3tensor(:,47))
  call loop_QV_A(G1(:,:,:,123),wf(:,-1),G1(:,:,:,125))
  call loop_Q_A(G1(:,:,:,125),Q(:,30),MT,G2(:,:,:,155))
  call loop_QV_A(G2(:,:,:,155),wf(:,-5),G2(:,:,:,156))
  call loop_Q_A(G2(:,:,:,156),Q(:,62),MT,G3(:,:,:,61))
  call loop_QS_A(G3(:,:,:,61),wf(:,0),G3(:,:,:,62),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,62),Q(:,63),MT,G4tensor(:,31))
  call loop_AV_Q(G0(:,:,:,1),wf(:,186),G0(:,:,:,49))
  call loop_A_Q(G0(:,:,:,49),Q(:,28),MT,G1(:,:,:,126))
  call loop_AV_Q(G1(:,:,:,126),wf(:,37),G1(:,:,:,127))
  call loop_A_Q(G1(:,:,:,127),Q(:,62),MT,G2(:,:,:,157))
  call loop_AS_Q(G2(:,:,:,157),wf(:,0),G2(:,:,:,158),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,158),Q(:,63),MT,G3tensor(:,48))
  call loop_AV_Q(G1(:,:,:,126),wf(:,-1),G1(:,:,:,128))
  call loop_A_Q(G1(:,:,:,128),Q(:,30),MT,G2(:,:,:,159))
  call loop_AV_Q(G2(:,:,:,159),wf(:,-5),G2(:,:,:,160))
  call loop_A_Q(G2(:,:,:,160),Q(:,62),MT,G3(:,:,:,63))
  call loop_AS_Q(G3(:,:,:,63),wf(:,0),G3(:,:,:,64),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,64),Q(:,63),MT,G4tensor(:,32))
  call loop_AV_Q(G0(:,:,:,1),wf(:,189),G0(:,:,:,50))
  call loop_A_Q(G0(:,:,:,50),Q(:,14),MT,G1(:,:,:,129))
  call loop_AV_Q(G1(:,:,:,129),wf(:,119),G1(:,:,:,130))
  call loop_A_Q(G1(:,:,:,130),Q(:,62),MT,G2(:,:,:,161))
  call loop_AS_Q(G2(:,:,:,161),wf(:,0),G2(:,:,:,162),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,162),Q(:,63),MT,G3tensor(:,49))
  call loop_AV_Q(G1(:,:,:,129),wf(:,-5),G1(:,:,:,131))
  call loop_A_Q(G1(:,:,:,131),Q(:,46),MT,G2(:,:,:,163))
  call loop_AV_Q(G2(:,:,:,163),wf(:,-4),G2(:,:,:,164))
  call loop_A_Q(G2(:,:,:,164),Q(:,62),MT,G3(:,:,:,65))
  call loop_AS_Q(G3(:,:,:,65),wf(:,0),G3(:,:,:,66),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,66),Q(:,63),MT,G4tensor(:,33))
  call loop_AV_Q(G1(:,:,:,129),wf(:,-4),G1(:,:,:,132))
  call loop_A_Q(G1(:,:,:,132),Q(:,30),MT,G2(:,:,:,165))
  call loop_AV_Q(G2(:,:,:,165),wf(:,-5),G2(:,:,:,166))
  call loop_A_Q(G2(:,:,:,166),Q(:,62),MT,G3(:,:,:,67))
  call loop_AS_Q(G3(:,:,:,67),wf(:,0),G3(:,:,:,68),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,68),Q(:,63),MT,G4tensor(:,34))
  call loop_QV_A(G0(:,:,:,1),wf(:,189),G0(:,:,:,51))
  call loop_Q_A(G0(:,:,:,51),Q(:,14),MT,G1(:,:,:,133))
  call loop_QV_A(G1(:,:,:,133),wf(:,119),G1(:,:,:,134))
  call loop_Q_A(G1(:,:,:,134),Q(:,62),MT,G2(:,:,:,167))
  call loop_QS_A(G2(:,:,:,167),wf(:,0),G2(:,:,:,168),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,168),Q(:,63),MT,G3tensor(:,50))
  call loop_QV_A(G1(:,:,:,133),wf(:,-5),G1(:,:,:,135))
  call loop_Q_A(G1(:,:,:,135),Q(:,46),MT,G2(:,:,:,169))
  call loop_QV_A(G2(:,:,:,169),wf(:,-4),G2(:,:,:,170))
  call loop_Q_A(G2(:,:,:,170),Q(:,62),MT,G3(:,:,:,69))
  call loop_QS_A(G3(:,:,:,69),wf(:,0),G3(:,:,:,70),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,70),Q(:,63),MT,G4tensor(:,35))
  call loop_QV_A(G1(:,:,:,133),wf(:,-4),G1(:,:,:,136))
  call loop_Q_A(G1(:,:,:,136),Q(:,30),MT,G2(:,:,:,171))
  call loop_QV_A(G2(:,:,:,171),wf(:,-5),G2(:,:,:,172))
  call loop_Q_A(G2(:,:,:,172),Q(:,62),MT,G3(:,:,:,71))
  call loop_QS_A(G3(:,:,:,71),wf(:,0),G3(:,:,:,72),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,72),Q(:,63),MT,G4tensor(:,36))
  call loop_QV_A(G0(:,:,:,1),wf(:,382),G0(:,:,:,52))
  call loop_Q_A(G0(:,:,:,52),Q(:,30),MT,G1(:,:,:,137))
  call loop_QV_A(G1(:,:,:,137),wf(:,-5),G1(:,:,:,138))
  call loop_Q_A(G1(:,:,:,138),Q(:,62),MT,G2(:,:,:,173))
  call loop_QS_A(G2(:,:,:,173),wf(:,0),G2(:,:,:,174),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,174),Q(:,63),MT,G3tensor(:,51))
  call loop_AV_Q(G0(:,:,:,1),wf(:,382),G0(:,:,:,53))
  call loop_A_Q(G0(:,:,:,53),Q(:,30),MT,G1(:,:,:,139))
  call loop_AV_Q(G1(:,:,:,139),wf(:,-5),G1(:,:,:,140))
  call loop_A_Q(G1(:,:,:,140),Q(:,62),MT,G2(:,:,:,175))
  call loop_AS_Q(G2(:,:,:,175),wf(:,0),G2(:,:,:,176),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,176),Q(:,63),MT,G3tensor(:,52))
  call loop_QV_A(G0(:,:,:,1),wf(:,384),G0(:,:,:,54))
  call loop_Q_A(G0(:,:,:,54),Q(:,30),MT,G1(:,:,:,141))
  call loop_QV_A(G1(:,:,:,141),wf(:,-5),G1(:,:,:,142))
  call loop_Q_A(G1(:,:,:,142),Q(:,62),MT,G2(:,:,:,177))
  call loop_QS_A(G2(:,:,:,177),wf(:,0),G2(:,:,:,178),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,178),Q(:,63),MT,G3tensor(:,53))
  call loop_AV_Q(G0(:,:,:,1),wf(:,384),G0(:,:,:,55))
  call loop_A_Q(G0(:,:,:,55),Q(:,30),MT,G1(:,:,:,143))
  call loop_AV_Q(G1(:,:,:,143),wf(:,-5),G1(:,:,:,144))
  call loop_A_Q(G1(:,:,:,144),Q(:,62),MT,G2(:,:,:,179))
  call loop_AS_Q(G2(:,:,:,179),wf(:,0),G2(:,:,:,180),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,180),Q(:,63),MT,G3tensor(:,54))
  call loop_QV_A(G0(:,:,:,1),wf(:,192),G0(:,:,:,56))
  call loop_Q_A(G0(:,:,:,56),Q(:,26),MT,G1(:,:,:,145))
  call loop_QV_A(G1(:,:,:,145),wf(:,84),G1(:,:,:,146))
  call loop_Q_A(G1(:,:,:,146),Q(:,62),MT,G2(:,:,:,181))
  call loop_QS_A(G2(:,:,:,181),wf(:,0),G2(:,:,:,182),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,182),Q(:,63),MT,G3tensor(:,55))
  call loop_QV_A(G1(:,:,:,145),wf(:,-2),G1(:,:,:,147))
  call loop_Q_A(G1(:,:,:,147),Q(:,30),MT,G2(:,:,:,183))
  call loop_QV_A(G2(:,:,:,183),wf(:,-5),G2(:,:,:,184))
  call loop_Q_A(G2(:,:,:,184),Q(:,62),MT,G3(:,:,:,73))
  call loop_QS_A(G3(:,:,:,73),wf(:,0),G3(:,:,:,74),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,74),Q(:,63),MT,G4tensor(:,37))
  call loop_AV_Q(G0(:,:,:,1),wf(:,192),G0(:,:,:,57))
  call loop_A_Q(G0(:,:,:,57),Q(:,26),MT,G1(:,:,:,148))
  call loop_AV_Q(G1(:,:,:,148),wf(:,84),G1(:,:,:,149))
  call loop_A_Q(G1(:,:,:,149),Q(:,62),MT,G2(:,:,:,185))
  call loop_AS_Q(G2(:,:,:,185),wf(:,0),G2(:,:,:,186),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,186),Q(:,63),MT,G3tensor(:,56))
  call loop_AV_Q(G1(:,:,:,148),wf(:,-2),G1(:,:,:,150))
  call loop_A_Q(G1(:,:,:,150),Q(:,30),MT,G2(:,:,:,187))
  call loop_AV_Q(G2(:,:,:,187),wf(:,-5),G2(:,:,:,188))
  call loop_A_Q(G2(:,:,:,188),Q(:,62),MT,G3(:,:,:,75))
  call loop_AS_Q(G3(:,:,:,75),wf(:,0),G3(:,:,:,76),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,76),Q(:,63),MT,G4tensor(:,38))
  call loop_AV_Q(G0(:,:,:,1),wf(:,194),G0(:,:,:,58))
  call loop_A_Q(G0(:,:,:,58),Q(:,22),MT,G1(:,:,:,151))
  call loop_AV_Q(G1(:,:,:,151),wf(:,109),G1(:,:,:,152))
  call loop_A_Q(G1(:,:,:,152),Q(:,62),MT,G2(:,:,:,189))
  call loop_AS_Q(G2(:,:,:,189),wf(:,0),G2(:,:,:,190),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,190),Q(:,63),MT,G3tensor(:,57))
  call loop_AV_Q(G1(:,:,:,151),wf(:,-3),G1(:,:,:,153))
  call loop_A_Q(G1(:,:,:,153),Q(:,30),MT,G2(:,:,:,191))
  call loop_AV_Q(G2(:,:,:,191),wf(:,-5),G2(:,:,:,192))
  call loop_A_Q(G2(:,:,:,192),Q(:,62),MT,G3(:,:,:,77))
  call loop_AS_Q(G3(:,:,:,77),wf(:,0),G3(:,:,:,78),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,78),Q(:,63),MT,G4tensor(:,39))
  call loop_QV_A(G0(:,:,:,1),wf(:,194),G0(:,:,:,59))
  call loop_Q_A(G0(:,:,:,59),Q(:,22),MT,G1(:,:,:,154))
  call loop_QV_A(G1(:,:,:,154),wf(:,109),G1(:,:,:,155))
  call loop_Q_A(G1(:,:,:,155),Q(:,62),MT,G2(:,:,:,193))
  call loop_QS_A(G2(:,:,:,193),wf(:,0),G2(:,:,:,194),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,194),Q(:,63),MT,G3tensor(:,58))
  call loop_QV_A(G1(:,:,:,154),wf(:,-3),G1(:,:,:,156))
  call loop_Q_A(G1(:,:,:,156),Q(:,30),MT,G2(:,:,:,195))
  call loop_QV_A(G2(:,:,:,195),wf(:,-5),G2(:,:,:,196))
  call loop_Q_A(G2(:,:,:,196),Q(:,62),MT,G3(:,:,:,79))
  call loop_QS_A(G3(:,:,:,79),wf(:,0),G3(:,:,:,80),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,80),Q(:,63),MT,G4tensor(:,40))
  call loop_QV_A(G0(:,:,:,1),wf(:,390),G0(:,:,:,60))
  call loop_Q_A(G0(:,:,:,60),Q(:,30),MT,G1(:,:,:,157))
  call loop_QV_A(G1(:,:,:,157),wf(:,-5),G1(:,:,:,158))
  call loop_Q_A(G1(:,:,:,158),Q(:,62),MT,G2(:,:,:,197))
  call loop_QS_A(G2(:,:,:,197),wf(:,0),G2(:,:,:,198),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,198),Q(:,63),MT,G3tensor(:,59))
  call loop_AV_Q(G0(:,:,:,1),wf(:,390),G0(:,:,:,61))
  call loop_A_Q(G0(:,:,:,61),Q(:,30),MT,G1(:,:,:,159))
  call loop_AV_Q(G1(:,:,:,159),wf(:,-5),G1(:,:,:,160))
  call loop_A_Q(G1(:,:,:,160),Q(:,62),MT,G2(:,:,:,199))
  call loop_AS_Q(G2(:,:,:,199),wf(:,0),G2(:,:,:,200),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,200),Q(:,63),MT,G3tensor(:,60))
  call loop_QV_A(G0(:,:,:,1),wf(:,392),G0(:,:,:,62))
  call loop_Q_A(G0(:,:,:,62),Q(:,30),MT,G1(:,:,:,161))
  call loop_QV_A(G1(:,:,:,161),wf(:,-5),G1(:,:,:,162))
  call loop_Q_A(G1(:,:,:,162),Q(:,62),MT,G2(:,:,:,201))
  call loop_QS_A(G2(:,:,:,201),wf(:,0),G2(:,:,:,202),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,202),Q(:,63),MT,G3tensor(:,61))
  call loop_AV_Q(G0(:,:,:,1),wf(:,392),G0(:,:,:,63))
  call loop_A_Q(G0(:,:,:,63),Q(:,30),MT,G1(:,:,:,163))
  call loop_AV_Q(G1(:,:,:,163),wf(:,-5),G1(:,:,:,164))
  call loop_A_Q(G1(:,:,:,164),Q(:,62),MT,G2(:,:,:,203))
  call loop_AS_Q(G2(:,:,:,203),wf(:,0),G2(:,:,:,204),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,204),Q(:,63),MT,G3tensor(:,62))
  call loop_QV_A(G0(:,:,:,1),wf(:,195),G0(:,:,:,64))
  call loop_Q_A(G0(:,:,:,64),Q(:,28),MT,G1(:,:,:,165))
  call loop_QV_A(G1(:,:,:,165),wf(:,37),G1(:,:,:,166))
  call loop_Q_A(G1(:,:,:,166),Q(:,62),MT,G2(:,:,:,205))
  call loop_QS_A(G2(:,:,:,205),wf(:,0),G2(:,:,:,206),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,206),Q(:,63),MT,G3tensor(:,63))
  call loop_QV_A(G1(:,:,:,165),wf(:,-1),G1(:,:,:,167))
  call loop_Q_A(G1(:,:,:,167),Q(:,30),MT,G2(:,:,:,207))
  call loop_QV_A(G2(:,:,:,207),wf(:,-5),G2(:,:,:,208))
  call loop_Q_A(G2(:,:,:,208),Q(:,62),MT,G3(:,:,:,81))
  call loop_QS_A(G3(:,:,:,81),wf(:,0),G3(:,:,:,82),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,82),Q(:,63),MT,G4tensor(:,41))
  call loop_AV_Q(G0(:,:,:,1),wf(:,195),G0(:,:,:,65))
  call loop_A_Q(G0(:,:,:,65),Q(:,28),MT,G1(:,:,:,168))
  call loop_AV_Q(G1(:,:,:,168),wf(:,37),G1(:,:,:,169))
  call loop_A_Q(G1(:,:,:,169),Q(:,62),MT,G2(:,:,:,209))
  call loop_AS_Q(G2(:,:,:,209),wf(:,0),G2(:,:,:,210),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,210),Q(:,63),MT,G3tensor(:,64))
  call loop_AV_Q(G1(:,:,:,168),wf(:,-1),G1(:,:,:,170))
  call loop_A_Q(G1(:,:,:,170),Q(:,30),MT,G2(:,:,:,211))
  call loop_AV_Q(G2(:,:,:,211),wf(:,-5),G2(:,:,:,212))
  call loop_A_Q(G2(:,:,:,212),Q(:,62),MT,G3(:,:,:,83))
  call loop_AS_Q(G3(:,:,:,83),wf(:,0),G3(:,:,:,84),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,84),Q(:,63),MT,G4tensor(:,42))
  call loop_AV_Q(G0(:,:,:,1),wf(:,198),G0(:,:,:,66))
  call loop_A_Q(G0(:,:,:,66),Q(:,22),MT,G1(:,:,:,171))
  call loop_AV_Q(G1(:,:,:,171),wf(:,109),G1(:,:,:,172))
  call loop_A_Q(G1(:,:,:,172),Q(:,62),MT,G2(:,:,:,213))
  call loop_AS_Q(G2(:,:,:,213),wf(:,0),G2(:,:,:,214),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,214),Q(:,63),MT,G3tensor(:,65))
  call loop_AV_Q(G1(:,:,:,171),wf(:,-3),G1(:,:,:,173))
  call loop_A_Q(G1(:,:,:,173),Q(:,30),MT,G2(:,:,:,215))
  call loop_AV_Q(G2(:,:,:,215),wf(:,-5),G2(:,:,:,216))
  call loop_A_Q(G2(:,:,:,216),Q(:,62),MT,G3(:,:,:,85))
  call loop_AS_Q(G3(:,:,:,85),wf(:,0),G3(:,:,:,86),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,86),Q(:,63),MT,G4tensor(:,43))
  call loop_QV_A(G0(:,:,:,1),wf(:,198),G0(:,:,:,67))
  call loop_Q_A(G0(:,:,:,67),Q(:,22),MT,G1(:,:,:,174))
  call loop_QV_A(G1(:,:,:,174),wf(:,109),G1(:,:,:,175))
  call loop_Q_A(G1(:,:,:,175),Q(:,62),MT,G2(:,:,:,217))
  call loop_QS_A(G2(:,:,:,217),wf(:,0),G2(:,:,:,218),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,218),Q(:,63),MT,G3tensor(:,66))
  call loop_QV_A(G1(:,:,:,174),wf(:,-3),G1(:,:,:,176))
  call loop_Q_A(G1(:,:,:,176),Q(:,30),MT,G2(:,:,:,219))
  call loop_QV_A(G2(:,:,:,219),wf(:,-5),G2(:,:,:,220))
  call loop_Q_A(G2(:,:,:,220),Q(:,62),MT,G3(:,:,:,87))
  call loop_QS_A(G3(:,:,:,87),wf(:,0),G3(:,:,:,88),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,88),Q(:,63),MT,G4tensor(:,44))
  call loop_QV_A(G0(:,:,:,1),wf(:,398),G0(:,:,:,68))
  call loop_Q_A(G0(:,:,:,68),Q(:,30),MT,G1(:,:,:,177))
  call loop_QV_A(G1(:,:,:,177),wf(:,-5),G1(:,:,:,178))
  call loop_Q_A(G1(:,:,:,178),Q(:,62),MT,G2(:,:,:,221))
  call loop_QS_A(G2(:,:,:,221),wf(:,0),G2(:,:,:,222),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,222),Q(:,63),MT,G3tensor(:,67))
  call loop_AV_Q(G0(:,:,:,1),wf(:,398),G0(:,:,:,69))
  call loop_A_Q(G0(:,:,:,69),Q(:,30),MT,G1(:,:,:,179))
  call loop_AV_Q(G1(:,:,:,179),wf(:,-5),G1(:,:,:,180))
  call loop_A_Q(G1(:,:,:,180),Q(:,62),MT,G2(:,:,:,223))
  call loop_AS_Q(G2(:,:,:,223),wf(:,0),G2(:,:,:,224),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,224),Q(:,63),MT,G3tensor(:,68))
  call loop_QV_A(G0(:,:,:,1),wf(:,400),G0(:,:,:,70))
  call loop_Q_A(G0(:,:,:,70),Q(:,30),MT,G1(:,:,:,181))
  call loop_QV_A(G1(:,:,:,181),wf(:,-5),G1(:,:,:,182))
  call loop_Q_A(G1(:,:,:,182),Q(:,62),MT,G2(:,:,:,225))
  call loop_QS_A(G2(:,:,:,225),wf(:,0),G2(:,:,:,226),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,226),Q(:,63),MT,G3tensor(:,69))
  call loop_AV_Q(G0(:,:,:,1),wf(:,400),G0(:,:,:,71))
  call loop_A_Q(G0(:,:,:,71),Q(:,30),MT,G1(:,:,:,183))
  call loop_AV_Q(G1(:,:,:,183),wf(:,-5),G1(:,:,:,184))
  call loop_A_Q(G1(:,:,:,184),Q(:,62),MT,G2(:,:,:,227))
  call loop_AS_Q(G2(:,:,:,227),wf(:,0),G2(:,:,:,228),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,228),Q(:,63),MT,G3tensor(:,70))
  call loop_QV_A(G0(:,:,:,1),wf(:,199),G0(:,:,:,72))
  call loop_Q_A(G0(:,:,:,72),Q(:,28),MT,G1(:,:,:,185))
  call loop_QV_A(G1(:,:,:,185),wf(:,37),G1(:,:,:,186))
  call loop_Q_A(G1(:,:,:,186),Q(:,62),MT,G2(:,:,:,229))
  call loop_QS_A(G2(:,:,:,229),wf(:,0),G2(:,:,:,230),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,230),Q(:,63),MT,G3tensor(:,71))
  call loop_QV_A(G1(:,:,:,185),wf(:,-1),G1(:,:,:,187))
  call loop_Q_A(G1(:,:,:,187),Q(:,30),MT,G2(:,:,:,231))
  call loop_QV_A(G2(:,:,:,231),wf(:,-5),G2(:,:,:,232))
  call loop_Q_A(G2(:,:,:,232),Q(:,62),MT,G3(:,:,:,89))
  call loop_QS_A(G3(:,:,:,89),wf(:,0),G3(:,:,:,90),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,90),Q(:,63),MT,G4tensor(:,45))
  call loop_AV_Q(G0(:,:,:,1),wf(:,199),G0(:,:,:,73))
  call loop_A_Q(G0(:,:,:,73),Q(:,28),MT,G1(:,:,:,188))
  call loop_AV_Q(G1(:,:,:,188),wf(:,37),G1(:,:,:,189))
  call loop_A_Q(G1(:,:,:,189),Q(:,62),MT,G2(:,:,:,233))
  call loop_AS_Q(G2(:,:,:,233),wf(:,0),G2(:,:,:,234),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,234),Q(:,63),MT,G3tensor(:,72))
  call loop_AV_Q(G1(:,:,:,188),wf(:,-1),G1(:,:,:,190))
  call loop_A_Q(G1(:,:,:,190),Q(:,30),MT,G2(:,:,:,235))
  call loop_AV_Q(G2(:,:,:,235),wf(:,-5),G2(:,:,:,236))
  call loop_A_Q(G2(:,:,:,236),Q(:,62),MT,G3(:,:,:,91))
  call loop_AS_Q(G3(:,:,:,91),wf(:,0),G3(:,:,:,92),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,92),Q(:,63),MT,G4tensor(:,46))
  call loop_AV_Q(G0(:,:,:,1),wf(:,201),G0(:,:,:,74))
  call loop_A_Q(G0(:,:,:,74),Q(:,26),MT,G1(:,:,:,191))
  call loop_AV_Q(G1(:,:,:,191),wf(:,84),G1(:,:,:,192))
  call loop_A_Q(G1(:,:,:,192),Q(:,62),MT,G2(:,:,:,237))
  call loop_AS_Q(G2(:,:,:,237),wf(:,0),G2(:,:,:,238),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,238),Q(:,63),MT,G3tensor(:,73))
  call loop_AV_Q(G1(:,:,:,191),wf(:,-2),G1(:,:,:,193))
  call loop_A_Q(G1(:,:,:,193),Q(:,30),MT,G2(:,:,:,239))
  call loop_AV_Q(G2(:,:,:,239),wf(:,-5),G2(:,:,:,240))
  call loop_A_Q(G2(:,:,:,240),Q(:,62),MT,G3(:,:,:,93))
  call loop_AS_Q(G3(:,:,:,93),wf(:,0),G3(:,:,:,94),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,94),Q(:,63),MT,G4tensor(:,47))
  call loop_QV_A(G0(:,:,:,1),wf(:,201),G0(:,:,:,75))
  call loop_Q_A(G0(:,:,:,75),Q(:,26),MT,G1(:,:,:,194))
  call loop_QV_A(G1(:,:,:,194),wf(:,84),G1(:,:,:,195))
  call loop_Q_A(G1(:,:,:,195),Q(:,62),MT,G2(:,:,:,241))
  call loop_QS_A(G2(:,:,:,241),wf(:,0),G2(:,:,:,242),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,242),Q(:,63),MT,G3tensor(:,74))
  call loop_QV_A(G1(:,:,:,194),wf(:,-2),G1(:,:,:,196))
  call loop_Q_A(G1(:,:,:,196),Q(:,30),MT,G2(:,:,:,243))
  call loop_QV_A(G2(:,:,:,243),wf(:,-5),G2(:,:,:,244))
  call loop_Q_A(G2(:,:,:,244),Q(:,62),MT,G3(:,:,:,95))
  call loop_QS_A(G3(:,:,:,95),wf(:,0),G3(:,:,:,96),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,96),Q(:,63),MT,G4tensor(:,48))
  call loop_QV_A(G0(:,:,:,1),wf(:,406),G0(:,:,:,76))
  call loop_Q_A(G0(:,:,:,76),Q(:,30),MT,G1(:,:,:,197))
  call loop_QV_A(G1(:,:,:,197),wf(:,-5),G1(:,:,:,198))
  call loop_Q_A(G1(:,:,:,198),Q(:,62),MT,G2(:,:,:,245))
  call loop_QS_A(G2(:,:,:,245),wf(:,0),G2(:,:,:,246),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,246),Q(:,63),MT,G3tensor(:,75))
  call loop_AV_Q(G0(:,:,:,1),wf(:,406),G0(:,:,:,77))
  call loop_A_Q(G0(:,:,:,77),Q(:,30),MT,G1(:,:,:,199))
  call loop_AV_Q(G1(:,:,:,199),wf(:,-5),G1(:,:,:,200))
  call loop_A_Q(G1(:,:,:,200),Q(:,62),MT,G2(:,:,:,247))
  call loop_AS_Q(G2(:,:,:,247),wf(:,0),G2(:,:,:,248),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,248),Q(:,63),MT,G3tensor(:,76))
  call loop_QV_A(G0(:,:,:,1),wf(:,407),G0(:,:,:,78))
  call loop_Q_A(G0(:,:,:,78),Q(:,30),MT,G1(:,:,:,201))
  call loop_QV_A(G1(:,:,:,201),wf(:,-5),G1(:,:,:,202))
  call loop_Q_A(G1(:,:,:,202),Q(:,62),MT,G2(:,:,:,249))
  call loop_QS_A(G2(:,:,:,249),wf(:,0),G2(:,:,:,250),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,250),Q(:,63),MT,G3tensor(:,77))
  call loop_AV_Q(G0(:,:,:,1),wf(:,407),G0(:,:,:,79))
  call loop_A_Q(G0(:,:,:,79),Q(:,30),MT,G1(:,:,:,203))
  call loop_AV_Q(G1(:,:,:,203),wf(:,-5),G1(:,:,:,204))
  call loop_A_Q(G1(:,:,:,204),Q(:,62),MT,G2(:,:,:,251))
  call loop_AS_Q(G2(:,:,:,251),wf(:,0),G2(:,:,:,252),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,252),Q(:,63),MT,G3tensor(:,78))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(2) = M(2) + (-(CI*f(2)) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,1),T3sum(1:35,14))
  M(3) = M(3) + (CI*f(2) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,1),T3sum(1:35,14))
  M(4) = M(4) + (-(CI*f(2)) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,1),T3sum(1:35,14))
  M(5) = M(5) + (CI*f(2) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,1),T3sum(1:35,14))
  M(12) = M(12) + (CI*f(2) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,1),T3sum(1:35,14))
  M(16) = M(16) + (-(CI*f(2)) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,1),T3sum(1:35,14))
  M(18) = M(18) + (CI*f(2) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,1),T3sum(1:35,14))
  M(22) = M(22) + (-(CI*f(2)) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,1),T3sum(1:35,14))
  M(3) = M(3) + (-(CI*f(2)) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,2),T3sum(1:35,14))
  M(4) = M(4) + (CI*f(2) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,2),T3sum(1:35,14))
  M(11) = M(11) + (CI*f(2) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,2),T3sum(1:35,14))
  M(12) = M(12) + (-(CI*f(2)) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,2),T3sum(1:35,14))
  M(13) = M(13) + (CI*f(2) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,2),T3sum(1:35,14))
  M(14) = M(14) + (-(CI*f(2)) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,2),T3sum(1:35,14))
  M(21) = M(21) + (-(CI*f(2)) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,2),T3sum(1:35,14))
  M(22) = M(22) + (CI*f(2) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,2),T3sum(1:35,14))
  M(2) = M(2) + (CI*f(2) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,3),T3sum(1:35,14))
  M(5) = M(5) + (-(CI*f(2)) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,3),T3sum(1:35,14))
  M(11) = M(11) + (-(CI*f(2)) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,3),T3sum(1:35,14))
  M(13) = M(13) + (-(CI*f(2)) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,3),T3sum(1:35,14))
  M(14) = M(14) + (CI*f(2) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,3),T3sum(1:35,14))
  M(16) = M(16) + (CI*f(2) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,3),T3sum(1:35,14))
  M(18) = M(18) + (-(CI*f(2)) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,3),T3sum(1:35,14))
  M(21) = M(21) + (CI*f(2) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,3),T3sum(1:35,14))
  M(2) = M(2) + (-(CI*f(2)) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,4),T3sum(1:35,14))
  M(3) = M(3) + (CI*f(2) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,4),T3sum(1:35,14))
  M(4) = M(4) + (-(CI*f(2)) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,4),T3sum(1:35,14))
  M(5) = M(5) + (CI*f(2) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,4),T3sum(1:35,14))
  M(12) = M(12) + (CI*f(2) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,4),T3sum(1:35,14))
  M(16) = M(16) + (-(CI*f(2)) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,4),T3sum(1:35,14))
  M(18) = M(18) + (CI*f(2) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,4),T3sum(1:35,14))
  M(22) = M(22) + (-(CI*f(2)) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,4),T3sum(1:35,14))
  M(3) = M(3) + (-(CI*f(2)) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,5),T3sum(1:35,14))
  M(4) = M(4) + (CI*f(2) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,5),T3sum(1:35,14))
  M(11) = M(11) + (CI*f(2) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,5),T3sum(1:35,14))
  M(12) = M(12) + (-(CI*f(2)) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,5),T3sum(1:35,14))
  M(13) = M(13) + (CI*f(2) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,5),T3sum(1:35,14))
  M(14) = M(14) + (-(CI*f(2)) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,5),T3sum(1:35,14))
  M(21) = M(21) + (-(CI*f(2)) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,5),T3sum(1:35,14))
  M(22) = M(22) + (CI*f(2) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,5),T3sum(1:35,14))
  M(2) = M(2) + (CI*f(2) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,6),T3sum(1:35,14))
  M(5) = M(5) + (-(CI*f(2)) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,6),T3sum(1:35,14))
  M(11) = M(11) + (-(CI*f(2)) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,6),T3sum(1:35,14))
  M(13) = M(13) + (-(CI*f(2)) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,6),T3sum(1:35,14))
  M(14) = M(14) + (CI*f(2) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,6),T3sum(1:35,14))
  M(16) = M(16) + (CI*f(2) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,6),T3sum(1:35,14))
  M(18) = M(18) + (-(CI*f(2)) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,6),T3sum(1:35,14))
  M(21) = M(21) + (CI*f(2) * den(57)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,6),T3sum(1:35,14))
  M(2) = M(2) + (CI*f(2) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,7),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(2)) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,7),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(2) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,7),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(2)) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,7),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(2)) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,7),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(2) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,7),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(2)) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,7),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(2) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,7),T3sum(1:35,3))
  M(3) = M(3) + (CI*f(2) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,8),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(2)) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,8),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(2)) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,8),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(2) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,8),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(2)) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,8),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(2) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,8),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(2) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,8),T3sum(1:35,3))
  M(22) = M(22) + (-(CI*f(2)) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,8),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(2)) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,9),T3sum(1:35,3))
  M(5) = M(5) + (CI*f(2) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,9),T3sum(1:35,3))
  M(11) = M(11) + (CI*f(2) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,9),T3sum(1:35,3))
  M(13) = M(13) + (CI*f(2) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,9),T3sum(1:35,3))
  M(14) = M(14) + (-(CI*f(2)) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,9),T3sum(1:35,3))
  M(16) = M(16) + (-(CI*f(2)) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,9),T3sum(1:35,3))
  M(18) = M(18) + (CI*f(2) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,9),T3sum(1:35,3))
  M(21) = M(21) + (-(CI*f(2)) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,9),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(2) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,10),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(2)) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,10),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(2) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,10),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(2)) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,10),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(2)) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,10),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(2) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,10),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(2)) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,10),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(2) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,10),T3sum(1:35,3))
  M(3) = M(3) + (CI*f(2) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,11),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(2)) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,11),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(2)) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,11),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(2) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,11),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(2)) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,11),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(2) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,11),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(2) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,11),T3sum(1:35,3))
  M(22) = M(22) + (-(CI*f(2)) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,11),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(2)) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,12),T3sum(1:35,3))
  M(5) = M(5) + (CI*f(2) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,12),T3sum(1:35,3))
  M(11) = M(11) + (CI*f(2) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,12),T3sum(1:35,3))
  M(13) = M(13) + (CI*f(2) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,12),T3sum(1:35,3))
  M(14) = M(14) + (-(CI*f(2)) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,12),T3sum(1:35,3))
  M(16) = M(16) + (-(CI*f(2)) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,12),T3sum(1:35,3))
  M(18) = M(18) + (CI*f(2) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,12),T3sum(1:35,3))
  M(21) = M(21) + (-(CI*f(2)) * den(296)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,12),T3sum(1:35,3))
  M(4) = M(4) + (-f(3) * den(56)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,1),T4sum(1:70,27))
  M(5) = M(5) + (f(3) * den(56)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,1),T4sum(1:70,27))
  M(18) = M(18) + (f(3) * den(56)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,1),T4sum(1:70,27))
  M(22) = M(22) + (-f(3) * den(56)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,1),T4sum(1:70,27))
  M(4) = M(4) + (f(3) * den(56)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,2),T4sum(1:70,27))
  M(14) = M(14) + (-f(3) * den(56)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,2),T4sum(1:70,27))
  M(21) = M(21) + (-f(3) * den(56)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,2),T4sum(1:70,27))
  M(22) = M(22) + (f(3) * den(56)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,2),T4sum(1:70,27))
  M(5) = M(5) + (-f(3) * den(56)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,3),T4sum(1:70,27))
  M(14) = M(14) + (f(3) * den(56)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,3),T4sum(1:70,27))
  M(18) = M(18) + (-f(3) * den(56)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,3),T4sum(1:70,27))
  M(21) = M(21) + (f(3) * den(56)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,3),T4sum(1:70,27))
  M(2) = M(2) + (f(3) * den(56)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,4),T4sum(1:70,27))
  M(3) = M(3) + (-f(3) * den(56)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,4),T4sum(1:70,27))
  M(12) = M(12) + (-f(3) * den(56)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,4),T4sum(1:70,27))
  M(16) = M(16) + (f(3) * den(56)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,4),T4sum(1:70,27))
  M(3) = M(3) + (f(3) * den(56)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,5),T4sum(1:70,27))
  M(11) = M(11) + (-f(3) * den(56)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,5),T4sum(1:70,27))
  M(12) = M(12) + (f(3) * den(56)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,5),T4sum(1:70,27))
  M(13) = M(13) + (-f(3) * den(56)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,5),T4sum(1:70,27))
  M(2) = M(2) + (-f(3) * den(56)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,6),T4sum(1:70,27))
  M(11) = M(11) + (f(3) * den(56)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,6),T4sum(1:70,27))
  M(13) = M(13) + (f(3) * den(56)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,6),T4sum(1:70,27))
  M(16) = M(16) + (-f(3) * den(56)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,6),T4sum(1:70,27))
  M(1) = M(1) + (CI*f(2) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,13),T3sum(1:35,15))
  M(2) = M(2) + (-(CI*f(2)) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,13),T3sum(1:35,15))
  M(4) = M(4) + (-(CI*f(2)) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,13),T3sum(1:35,15))
  M(6) = M(6) + (CI*f(2) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,13),T3sum(1:35,15))
  M(10) = M(10) + (-(CI*f(2)) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,13),T3sum(1:35,15))
  M(12) = M(12) + (CI*f(2) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,13),T3sum(1:35,15))
  M(18) = M(18) + (CI*f(2) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,13),T3sum(1:35,15))
  M(24) = M(24) + (-(CI*f(2)) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,13),T3sum(1:35,15))
  M(1) = M(1) + (-(CI*f(2)) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,14),T3sum(1:35,15))
  M(2) = M(2) + (CI*f(2) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,14),T3sum(1:35,15))
  M(7) = M(7) + (CI*f(2) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,14),T3sum(1:35,15))
  M(8) = M(8) + (-(CI*f(2)) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,14),T3sum(1:35,15))
  M(17) = M(17) + (CI*f(2) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,14),T3sum(1:35,15))
  M(18) = M(18) + (-(CI*f(2)) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,14),T3sum(1:35,15))
  M(23) = M(23) + (-(CI*f(2)) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,14),T3sum(1:35,15))
  M(24) = M(24) + (CI*f(2) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,14),T3sum(1:35,15))
  M(4) = M(4) + (CI*f(2) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,15),T3sum(1:35,15))
  M(6) = M(6) + (-(CI*f(2)) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,15),T3sum(1:35,15))
  M(7) = M(7) + (-(CI*f(2)) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,15),T3sum(1:35,15))
  M(8) = M(8) + (CI*f(2) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,15),T3sum(1:35,15))
  M(10) = M(10) + (CI*f(2) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,15),T3sum(1:35,15))
  M(12) = M(12) + (-(CI*f(2)) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,15),T3sum(1:35,15))
  M(17) = M(17) + (-(CI*f(2)) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,15),T3sum(1:35,15))
  M(23) = M(23) + (CI*f(2) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,15),T3sum(1:35,15))
  M(1) = M(1) + (CI*f(2) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,16),T3sum(1:35,15))
  M(2) = M(2) + (-(CI*f(2)) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,16),T3sum(1:35,15))
  M(4) = M(4) + (-(CI*f(2)) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,16),T3sum(1:35,15))
  M(6) = M(6) + (CI*f(2) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,16),T3sum(1:35,15))
  M(10) = M(10) + (-(CI*f(2)) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,16),T3sum(1:35,15))
  M(12) = M(12) + (CI*f(2) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,16),T3sum(1:35,15))
  M(18) = M(18) + (CI*f(2) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,16),T3sum(1:35,15))
  M(24) = M(24) + (-(CI*f(2)) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,16),T3sum(1:35,15))
  M(1) = M(1) + (-(CI*f(2)) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,17),T3sum(1:35,15))
  M(2) = M(2) + (CI*f(2) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,17),T3sum(1:35,15))
  M(7) = M(7) + (CI*f(2) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,17),T3sum(1:35,15))
  M(8) = M(8) + (-(CI*f(2)) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,17),T3sum(1:35,15))
  M(17) = M(17) + (CI*f(2) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,17),T3sum(1:35,15))
  M(18) = M(18) + (-(CI*f(2)) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,17),T3sum(1:35,15))
  M(23) = M(23) + (-(CI*f(2)) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,17),T3sum(1:35,15))
  M(24) = M(24) + (CI*f(2) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,17),T3sum(1:35,15))
  M(4) = M(4) + (CI*f(2) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,18),T3sum(1:35,15))
  M(6) = M(6) + (-(CI*f(2)) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,18),T3sum(1:35,15))
  M(7) = M(7) + (-(CI*f(2)) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,18),T3sum(1:35,15))
  M(8) = M(8) + (CI*f(2) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,18),T3sum(1:35,15))
  M(10) = M(10) + (CI*f(2) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,18),T3sum(1:35,15))
  M(12) = M(12) + (-(CI*f(2)) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,18),T3sum(1:35,15))
  M(17) = M(17) + (-(CI*f(2)) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,18),T3sum(1:35,15))
  M(23) = M(23) + (CI*f(2) * den(63)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,18),T3sum(1:35,15))
  M(1) = M(1) + (CI*f(2) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,19),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(2)) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,19),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(2)) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,19),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(2) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,19),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(2)) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,19),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(2) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,19),T3sum(1:35,3))
  M(18) = M(18) + (CI*f(2) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,19),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(2)) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,19),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(2)) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,20),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(2) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,20),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(2) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,20),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(2)) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,20),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(2) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,20),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(2)) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,20),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(2)) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,20),T3sum(1:35,3))
  M(24) = M(24) + (CI*f(2) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,20),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(2) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,21),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(2)) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,21),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(2)) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,21),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(2) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,21),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(2) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,21),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(2)) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,21),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(2)) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,21),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(2) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,21),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(2) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,22),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(2)) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,22),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(2)) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,22),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(2) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,22),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(2)) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,22),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(2) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,22),T3sum(1:35,3))
  M(18) = M(18) + (CI*f(2) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,22),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(2)) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,22),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(2)) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,23),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(2) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,23),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(2) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,23),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(2)) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,23),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(2) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,23),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(2)) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,23),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(2)) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,23),T3sum(1:35,3))
  M(24) = M(24) + (CI*f(2) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,23),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(2) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,24),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(2)) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,24),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(2)) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,24),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(2) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,24),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(2) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,24),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(2)) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,24),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(2)) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,24),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(2) * den(298)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,24),T3sum(1:35,3))
  M(1) = M(1) + (-f(3) * den(62)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,7),T4sum(1:70,29))
  M(4) = M(4) + (f(3) * den(62)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,7),T4sum(1:70,29))
  M(10) = M(10) + (f(3) * den(62)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,7),T4sum(1:70,29))
  M(18) = M(18) + (-f(3) * den(62)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,7),T4sum(1:70,29))
  M(1) = M(1) + (f(3) * den(62)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,9),T4sum(1:70,29))
  M(7) = M(7) + (-f(3) * den(62)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,9),T4sum(1:70,29))
  M(17) = M(17) + (-f(3) * den(62)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,9),T4sum(1:70,29))
  M(18) = M(18) + (f(3) * den(62)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,9),T4sum(1:70,29))
  M(4) = M(4) + (-f(3) * den(62)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,11),T4sum(1:70,29))
  M(7) = M(7) + (f(3) * den(62)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,11),T4sum(1:70,29))
  M(10) = M(10) + (-f(3) * den(62)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,11),T4sum(1:70,29))
  M(17) = M(17) + (f(3) * den(62)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,11),T4sum(1:70,29))
  M(2) = M(2) + (-f(3) * den(62)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,13),T4sum(1:70,29))
  M(6) = M(6) + (f(3) * den(62)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,13),T4sum(1:70,29))
  M(12) = M(12) + (f(3) * den(62)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,13),T4sum(1:70,29))
  M(24) = M(24) + (-f(3) * den(62)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,13),T4sum(1:70,29))
  M(2) = M(2) + (f(3) * den(62)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,15),T4sum(1:70,29))
  M(8) = M(8) + (-f(3) * den(62)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,15),T4sum(1:70,29))
  M(23) = M(23) + (-f(3) * den(62)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,15),T4sum(1:70,29))
  M(24) = M(24) + (f(3) * den(62)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,15),T4sum(1:70,29))
  M(6) = M(6) + (-f(3) * den(62)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,17),T4sum(1:70,29))
  M(8) = M(8) + (f(3) * den(62)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,17),T4sum(1:70,29))
  M(12) = M(12) + (-f(3) * den(62)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,17),T4sum(1:70,29))
  M(23) = M(23) + (f(3) * den(62)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,17),T4sum(1:70,29))
  M(2) = M(2) + (-f(3) * den(62)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,8),T4sum(1:70,30))
  M(6) = M(6) + (f(3) * den(62)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,8),T4sum(1:70,30))
  M(12) = M(12) + (f(3) * den(62)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,8),T4sum(1:70,30))
  M(24) = M(24) + (-f(3) * den(62)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,8),T4sum(1:70,30))
  M(2) = M(2) + (f(3) * den(62)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,10),T4sum(1:70,30))
  M(8) = M(8) + (-f(3) * den(62)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,10),T4sum(1:70,30))
  M(23) = M(23) + (-f(3) * den(62)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,10),T4sum(1:70,30))
  M(24) = M(24) + (f(3) * den(62)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,10),T4sum(1:70,30))
  M(6) = M(6) + (-f(3) * den(62)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,12),T4sum(1:70,30))
  M(8) = M(8) + (f(3) * den(62)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,12),T4sum(1:70,30))
  M(12) = M(12) + (-f(3) * den(62)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,12),T4sum(1:70,30))
  M(23) = M(23) + (f(3) * den(62)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,12),T4sum(1:70,30))
  M(1) = M(1) + (-f(3) * den(62)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,14),T4sum(1:70,30))
  M(4) = M(4) + (f(3) * den(62)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,14),T4sum(1:70,30))
  M(10) = M(10) + (f(3) * den(62)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,14),T4sum(1:70,30))
  M(18) = M(18) + (-f(3) * den(62)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,14),T4sum(1:70,30))
  M(1) = M(1) + (f(3) * den(62)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,16),T4sum(1:70,30))
  M(7) = M(7) + (-f(3) * den(62)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,16),T4sum(1:70,30))
  M(17) = M(17) + (-f(3) * den(62)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,16),T4sum(1:70,30))
  M(18) = M(18) + (f(3) * den(62)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,16),T4sum(1:70,30))
  M(4) = M(4) + (-f(3) * den(62)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,18),T4sum(1:70,30))
  M(7) = M(7) + (f(3) * den(62)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,18),T4sum(1:70,30))
  M(10) = M(10) + (-f(3) * den(62)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,18),T4sum(1:70,30))
  M(17) = M(17) + (f(3) * den(62)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,18),T4sum(1:70,30))
  M(1) = M(1) + (CI*f(2) * den(301)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,25),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(2)) * den(301)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,25),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(2)) * den(301)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,25),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(2) * den(301)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,25),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(2)) * den(301)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,25),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(2) * den(301)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,25),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(2) * den(301)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,25),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(2)) * den(301)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,25),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(2) * den(301)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,26),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(2)) * den(301)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,26),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(2)) * den(301)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,26),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(2) * den(301)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,26),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(2)) * den(301)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,26),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(2) * den(301)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,26),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(2) * den(301)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,26),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(2)) * den(301)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,26),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(2)) * den(94)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,27),T3sum(1:35,14))
  M(3) = M(3) + (CI*f(2) * den(94)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,27),T3sum(1:35,14))
  M(4) = M(4) + (-(CI*f(2)) * den(94)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,27),T3sum(1:35,14))
  M(5) = M(5) + (CI*f(2) * den(94)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,27),T3sum(1:35,14))
  M(12) = M(12) + (CI*f(2) * den(94)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,27),T3sum(1:35,14))
  M(16) = M(16) + (-(CI*f(2)) * den(94)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,27),T3sum(1:35,14))
  M(18) = M(18) + (CI*f(2) * den(94)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,27),T3sum(1:35,14))
  M(22) = M(22) + (-(CI*f(2)) * den(94)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,27),T3sum(1:35,14))
  M(2) = M(2) + (-(CI*f(2)) * den(94)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,28),T3sum(1:35,14))
  M(3) = M(3) + (CI*f(2) * den(94)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,28),T3sum(1:35,14))
  M(4) = M(4) + (-(CI*f(2)) * den(94)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,28),T3sum(1:35,14))
  M(5) = M(5) + (CI*f(2) * den(94)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,28),T3sum(1:35,14))
  M(12) = M(12) + (CI*f(2) * den(94)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,28),T3sum(1:35,14))
  M(16) = M(16) + (-(CI*f(2)) * den(94)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,28),T3sum(1:35,14))
  M(18) = M(18) + (CI*f(2) * den(94)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,28),T3sum(1:35,14))
  M(22) = M(22) + (-(CI*f(2)) * den(94)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,28),T3sum(1:35,14))
  M(1) = M(1) + (CI*f(2) * den(98)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,29),T3sum(1:35,15))
  M(2) = M(2) + (-(CI*f(2)) * den(98)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,29),T3sum(1:35,15))
  M(4) = M(4) + (-(CI*f(2)) * den(98)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,29),T3sum(1:35,15))
  M(6) = M(6) + (CI*f(2) * den(98)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,29),T3sum(1:35,15))
  M(10) = M(10) + (-(CI*f(2)) * den(98)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,29),T3sum(1:35,15))
  M(12) = M(12) + (CI*f(2) * den(98)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,29),T3sum(1:35,15))
  M(18) = M(18) + (CI*f(2) * den(98)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,29),T3sum(1:35,15))
  M(24) = M(24) + (-(CI*f(2)) * den(98)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,29),T3sum(1:35,15))
  M(1) = M(1) + (CI*f(2) * den(98)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,30),T3sum(1:35,15))
  M(2) = M(2) + (-(CI*f(2)) * den(98)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,30),T3sum(1:35,15))
  M(4) = M(4) + (-(CI*f(2)) * den(98)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,30),T3sum(1:35,15))
  M(6) = M(6) + (CI*f(2) * den(98)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,30),T3sum(1:35,15))
  M(10) = M(10) + (-(CI*f(2)) * den(98)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,30),T3sum(1:35,15))
  M(12) = M(12) + (CI*f(2) * den(98)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,30),T3sum(1:35,15))
  M(18) = M(18) + (CI*f(2) * den(98)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,30),T3sum(1:35,15))
  M(24) = M(24) + (-(CI*f(2)) * den(98)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,30),T3sum(1:35,15))
  M(1) = M(1) + (CI*f(2) * den(306)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,31),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(2)) * den(306)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,31),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(2)) * den(306)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,31),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(2) * den(306)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,31),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(2)) * den(306)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,31),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(2) * den(306)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,31),T3sum(1:35,3))
  M(18) = M(18) + (CI*f(2) * den(306)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,31),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(2)) * den(306)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,31),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(2) * den(306)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,32),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(2)) * den(306)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,32),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(2)) * den(306)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,32),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(2) * den(306)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,32),T3sum(1:35,3))
  M(10) = M(10) + (-(CI*f(2)) * den(306)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,32),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(2) * den(306)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,32),T3sum(1:35,3))
  M(18) = M(18) + (CI*f(2) * den(306)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,32),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(2)) * den(306)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,32),T3sum(1:35,3))
  M(1) = M(1) + (-f(3) * den(97)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,23),T4sum(1:70,29))
  M(4) = M(4) + (f(3) * den(97)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,23),T4sum(1:70,29))
  M(10) = M(10) + (f(3) * den(97)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,23),T4sum(1:70,29))
  M(18) = M(18) + (-f(3) * den(97)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,23),T4sum(1:70,29))
  M(2) = M(2) + (-f(3) * den(97)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,21),T4sum(1:70,29))
  M(6) = M(6) + (f(3) * den(97)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,21),T4sum(1:70,29))
  M(12) = M(12) + (f(3) * den(97)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,21),T4sum(1:70,29))
  M(24) = M(24) + (-f(3) * den(97)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,21),T4sum(1:70,29))
  M(2) = M(2) + (-f(3) * den(97)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,24),T4sum(1:70,30))
  M(6) = M(6) + (f(3) * den(97)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,24),T4sum(1:70,30))
  M(12) = M(12) + (f(3) * den(97)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,24),T4sum(1:70,30))
  M(24) = M(24) + (-f(3) * den(97)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,24),T4sum(1:70,30))
  M(1) = M(1) + (-f(3) * den(97)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,22),T4sum(1:70,30))
  M(4) = M(4) + (f(3) * den(97)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,22),T4sum(1:70,30))
  M(10) = M(10) + (f(3) * den(97)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,22),T4sum(1:70,30))
  M(18) = M(18) + (-f(3) * den(97)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,22),T4sum(1:70,30))
  M(2) = M(2) + (CI*f(2) * den(308)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,33),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(2)) * den(308)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,33),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(2) * den(308)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,33),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(2)) * den(308)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,33),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(2)) * den(308)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,33),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(2) * den(308)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,33),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(2)) * den(308)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,33),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(2) * den(308)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,33),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(2) * den(308)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,34),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(2)) * den(308)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,34),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(2) * den(308)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,34),T3sum(1:35,3))
  M(5) = M(5) + (-(CI*f(2)) * den(308)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,34),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(2)) * den(308)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,34),T3sum(1:35,3))
  M(16) = M(16) + (CI*f(2) * den(308)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,34),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(2)) * den(308)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,34),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(2) * den(308)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,34),T3sum(1:35,3))
  M(4) = M(4) + (-f(3) * den(93)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,19),T4sum(1:70,27))
  M(5) = M(5) + (f(3) * den(93)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,19),T4sum(1:70,27))
  M(18) = M(18) + (f(3) * den(93)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,19),T4sum(1:70,27))
  M(22) = M(22) + (-f(3) * den(93)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,19),T4sum(1:70,27))
  M(2) = M(2) + (f(3) * den(93)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,20),T4sum(1:70,27))
  M(3) = M(3) + (-f(3) * den(93)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,20),T4sum(1:70,27))
  M(12) = M(12) + (-f(3) * den(93)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,20),T4sum(1:70,27))
  M(16) = M(16) + (f(3) * den(93)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,20),T4sum(1:70,27))
  M(4) = M(4) + (-(CI*f(2)) * den(313)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,35),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(2) * den(313)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,35),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(2)) * den(313)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,35),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(2)) * den(313)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,35),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(2) * den(313)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,35),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(2) * den(313)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,35),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(2) * den(313)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,35),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(2)) * den(313)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,35),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(2)) * den(313)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,36),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(2) * den(313)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,36),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(2)) * den(313)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,36),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(2)) * den(313)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,36),T3sum(1:35,3))
  M(12) = M(12) + (CI*f(2) * den(313)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,36),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(2) * den(313)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,36),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(2) * den(313)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,36),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(2)) * den(313)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,36),T3sum(1:35,3))
  M(6) = M(6) + (CI*f(2) * den(120)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,37),T3sum(1:35,12))
  M(8) = M(8) + (-(CI*f(2)) * den(120)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,37),T3sum(1:35,12))
  M(9) = M(9) + (CI*f(2) * den(120)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,37),T3sum(1:35,12))
  M(10) = M(10) + (-(CI*f(2)) * den(120)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,37),T3sum(1:35,12))
  M(11) = M(11) + (CI*f(2) * den(120)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,37),T3sum(1:35,12))
  M(14) = M(14) + (-(CI*f(2)) * den(120)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,37),T3sum(1:35,12))
  M(17) = M(17) + (CI*f(2) * den(120)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,37),T3sum(1:35,12))
  M(20) = M(20) + (-(CI*f(2)) * den(120)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,37),T3sum(1:35,12))
  M(6) = M(6) + (CI*f(2) * den(120)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,38),T3sum(1:35,12))
  M(8) = M(8) + (-(CI*f(2)) * den(120)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,38),T3sum(1:35,12))
  M(9) = M(9) + (CI*f(2) * den(120)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,38),T3sum(1:35,12))
  M(10) = M(10) + (-(CI*f(2)) * den(120)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,38),T3sum(1:35,12))
  M(11) = M(11) + (CI*f(2) * den(120)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,38),T3sum(1:35,12))
  M(14) = M(14) + (-(CI*f(2)) * den(120)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,38),T3sum(1:35,12))
  M(17) = M(17) + (CI*f(2) * den(120)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,38),T3sum(1:35,12))
  M(20) = M(20) + (-(CI*f(2)) * den(120)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,38),T3sum(1:35,12))
  M(4) = M(4) + (CI*f(2) * den(124)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,39),T3sum(1:35,15))
  M(6) = M(6) + (-(CI*f(2)) * den(124)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,39),T3sum(1:35,15))
  M(7) = M(7) + (-(CI*f(2)) * den(124)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,39),T3sum(1:35,15))
  M(8) = M(8) + (CI*f(2) * den(124)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,39),T3sum(1:35,15))
  M(10) = M(10) + (CI*f(2) * den(124)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,39),T3sum(1:35,15))
  M(12) = M(12) + (-(CI*f(2)) * den(124)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,39),T3sum(1:35,15))
  M(17) = M(17) + (-(CI*f(2)) * den(124)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,39),T3sum(1:35,15))
  M(23) = M(23) + (CI*f(2) * den(124)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,39),T3sum(1:35,15))
  M(4) = M(4) + (CI*f(2) * den(124)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,40),T3sum(1:35,15))
  M(6) = M(6) + (-(CI*f(2)) * den(124)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,40),T3sum(1:35,15))
  M(7) = M(7) + (-(CI*f(2)) * den(124)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,40),T3sum(1:35,15))
  M(8) = M(8) + (CI*f(2) * den(124)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,40),T3sum(1:35,15))
  M(10) = M(10) + (CI*f(2) * den(124)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,40),T3sum(1:35,15))
  M(12) = M(12) + (-(CI*f(2)) * den(124)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,40),T3sum(1:35,15))
  M(17) = M(17) + (-(CI*f(2)) * den(124)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,40),T3sum(1:35,15))
  M(23) = M(23) + (CI*f(2) * den(124)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,40),T3sum(1:35,15))
  M(4) = M(4) + (CI*f(2) * den(318)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,41),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(2)) * den(318)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,41),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(2)) * den(318)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,41),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(2) * den(318)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,41),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(2) * den(318)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,41),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(2)) * den(318)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,41),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(2)) * den(318)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,41),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(2) * den(318)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,41),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(2) * den(318)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,42),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(2)) * den(318)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,42),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(2)) * den(318)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,42),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(2) * den(318)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,42),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(2) * den(318)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,42),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(2)) * den(318)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,42),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(2)) * den(318)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,42),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(2) * den(318)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,42),T3sum(1:35,3))
  M(4) = M(4) + (-f(3) * den(123)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,29),T4sum(1:70,29))
  M(7) = M(7) + (f(3) * den(123)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,29),T4sum(1:70,29))
  M(10) = M(10) + (-f(3) * den(123)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,29),T4sum(1:70,29))
  M(17) = M(17) + (f(3) * den(123)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,29),T4sum(1:70,29))
  M(6) = M(6) + (-f(3) * den(123)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,27),T4sum(1:70,29))
  M(8) = M(8) + (f(3) * den(123)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,27),T4sum(1:70,29))
  M(12) = M(12) + (-f(3) * den(123)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,27),T4sum(1:70,29))
  M(23) = M(23) + (f(3) * den(123)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,27),T4sum(1:70,29))
  M(6) = M(6) + (-f(3) * den(123)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,30),T4sum(1:70,30))
  M(8) = M(8) + (f(3) * den(123)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,30),T4sum(1:70,30))
  M(12) = M(12) + (-f(3) * den(123)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,30),T4sum(1:70,30))
  M(23) = M(23) + (f(3) * den(123)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,30),T4sum(1:70,30))
  M(4) = M(4) + (-f(3) * den(123)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,28),T4sum(1:70,30))
  M(7) = M(7) + (f(3) * den(123)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,28),T4sum(1:70,30))
  M(10) = M(10) + (-f(3) * den(123)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,28),T4sum(1:70,30))
  M(17) = M(17) + (f(3) * den(123)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,28),T4sum(1:70,30))
  M(6) = M(6) + (-(CI*f(2)) * den(320)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,43),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(2) * den(320)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,43),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(2)) * den(320)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,43),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(2) * den(320)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,43),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(2)) * den(320)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,43),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(2) * den(320)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,43),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(2)) * den(320)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,43),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(2) * den(320)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,43),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(2)) * den(320)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,44),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(2) * den(320)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,44),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(2)) * den(320)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,44),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(2) * den(320)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,44),T3sum(1:35,3))
  M(11) = M(11) + (-(CI*f(2)) * den(320)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,44),T3sum(1:35,3))
  M(14) = M(14) + (CI*f(2) * den(320)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,44),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(2)) * den(320)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,44),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(2) * den(320)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,44),T3sum(1:35,3))
  M(10) = M(10) + (-f(3) * den(119)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,25),T4sum(1:70,21))
  M(11) = M(11) + (f(3) * den(119)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,25),T4sum(1:70,21))
  M(17) = M(17) + (f(3) * den(119)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,25),T4sum(1:70,21))
  M(20) = M(20) + (-f(3) * den(119)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,25),T4sum(1:70,21))
  M(6) = M(6) + (-f(3) * den(119)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,26),T4sum(1:70,21))
  M(8) = M(8) + (f(3) * den(119)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,26),T4sum(1:70,21))
  M(9) = M(9) + (-f(3) * den(119)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,26),T4sum(1:70,21))
  M(14) = M(14) + (f(3) * den(119)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,26),T4sum(1:70,21))
  M(2) = M(2) + (CI*f(2) * den(325)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,45),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(2)) * den(325)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,45),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(2)) * den(325)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,45),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(2) * den(325)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,45),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(2) * den(325)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,45),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(2)) * den(325)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,45),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(2)) * den(325)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,45),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(2) * den(325)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,45),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(2) * den(325)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,46),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(2)) * den(325)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,46),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(2)) * den(325)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,46),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(2) * den(325)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,46),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(2) * den(325)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,46),T3sum(1:35,3))
  M(18) = M(18) + (-(CI*f(2)) * den(325)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,46),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(2)) * den(325)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,46),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(2) * den(325)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,46),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(2)) * den(140)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,47),T3sum(1:35,9))
  M(7) = M(7) + (CI*f(2) * den(140)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,47),T3sum(1:35,9))
  M(13) = M(13) + (CI*f(2) * den(140)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,47),T3sum(1:35,9))
  M(15) = M(15) + (-(CI*f(2)) * den(140)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,47),T3sum(1:35,9))
  M(19) = M(19) + (CI*f(2) * den(140)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,47),T3sum(1:35,9))
  M(21) = M(21) + (-(CI*f(2)) * den(140)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,47),T3sum(1:35,9))
  M(23) = M(23) + (-(CI*f(2)) * den(140)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,47),T3sum(1:35,9))
  M(24) = M(24) + (CI*f(2) * den(140)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,47),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(2)) * den(140)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,48),T3sum(1:35,9))
  M(7) = M(7) + (CI*f(2) * den(140)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,48),T3sum(1:35,9))
  M(13) = M(13) + (CI*f(2) * den(140)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,48),T3sum(1:35,9))
  M(15) = M(15) + (-(CI*f(2)) * den(140)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,48),T3sum(1:35,9))
  M(19) = M(19) + (CI*f(2) * den(140)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,48),T3sum(1:35,9))
  M(21) = M(21) + (-(CI*f(2)) * den(140)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,48),T3sum(1:35,9))
  M(23) = M(23) + (-(CI*f(2)) * den(140)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,48),T3sum(1:35,9))
  M(24) = M(24) + (CI*f(2) * den(140)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,48),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(2) * den(146)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,49),T3sum(1:35,15))
  M(2) = M(2) + (-(CI*f(2)) * den(146)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,49),T3sum(1:35,15))
  M(7) = M(7) + (-(CI*f(2)) * den(146)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,49),T3sum(1:35,15))
  M(8) = M(8) + (CI*f(2) * den(146)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,49),T3sum(1:35,15))
  M(17) = M(17) + (-(CI*f(2)) * den(146)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,49),T3sum(1:35,15))
  M(18) = M(18) + (CI*f(2) * den(146)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,49),T3sum(1:35,15))
  M(23) = M(23) + (CI*f(2) * den(146)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,49),T3sum(1:35,15))
  M(24) = M(24) + (-(CI*f(2)) * den(146)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,49),T3sum(1:35,15))
  M(1) = M(1) + (CI*f(2) * den(146)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,50),T3sum(1:35,15))
  M(2) = M(2) + (-(CI*f(2)) * den(146)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,50),T3sum(1:35,15))
  M(7) = M(7) + (-(CI*f(2)) * den(146)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,50),T3sum(1:35,15))
  M(8) = M(8) + (CI*f(2) * den(146)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,50),T3sum(1:35,15))
  M(17) = M(17) + (-(CI*f(2)) * den(146)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,50),T3sum(1:35,15))
  M(18) = M(18) + (CI*f(2) * den(146)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,50),T3sum(1:35,15))
  M(23) = M(23) + (CI*f(2) * den(146)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,50),T3sum(1:35,15))
  M(24) = M(24) + (-(CI*f(2)) * den(146)) * TI2_call(3,momenta_7,masses2_1,G3tensor(:,50),T3sum(1:35,15))
  M(1) = M(1) + (CI*f(2) * den(330)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,51),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(2)) * den(330)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,51),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(2)) * den(330)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,51),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(2) * den(330)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,51),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(2)) * den(330)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,51),T3sum(1:35,3))
  M(18) = M(18) + (CI*f(2) * den(330)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,51),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(2) * den(330)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,51),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(2)) * den(330)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,51),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(2) * den(330)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,52),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(2)) * den(330)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,52),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(2)) * den(330)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,52),T3sum(1:35,3))
  M(8) = M(8) + (CI*f(2) * den(330)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,52),T3sum(1:35,3))
  M(17) = M(17) + (-(CI*f(2)) * den(330)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,52),T3sum(1:35,3))
  M(18) = M(18) + (CI*f(2) * den(330)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,52),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(2) * den(330)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,52),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(2)) * den(330)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,52),T3sum(1:35,3))
  M(1) = M(1) + (-f(3) * den(145)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,35),T4sum(1:70,29))
  M(7) = M(7) + (f(3) * den(145)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,35),T4sum(1:70,29))
  M(17) = M(17) + (f(3) * den(145)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,35),T4sum(1:70,29))
  M(18) = M(18) + (-f(3) * den(145)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,35),T4sum(1:70,29))
  M(2) = M(2) + (-f(3) * den(145)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,33),T4sum(1:70,29))
  M(8) = M(8) + (f(3) * den(145)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,33),T4sum(1:70,29))
  M(23) = M(23) + (f(3) * den(145)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,33),T4sum(1:70,29))
  M(24) = M(24) + (-f(3) * den(145)) * TI2_call(4,momenta_71,masses2_2,G4tensor(:,33),T4sum(1:70,29))
  M(2) = M(2) + (-f(3) * den(145)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,36),T4sum(1:70,30))
  M(8) = M(8) + (f(3) * den(145)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,36),T4sum(1:70,30))
  M(23) = M(23) + (f(3) * den(145)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,36),T4sum(1:70,30))
  M(24) = M(24) + (-f(3) * den(145)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,36),T4sum(1:70,30))
  M(1) = M(1) + (-f(3) * den(145)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,34),T4sum(1:70,30))
  M(7) = M(7) + (f(3) * den(145)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,34),T4sum(1:70,30))
  M(17) = M(17) + (f(3) * den(145)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,34),T4sum(1:70,30))
  M(18) = M(18) + (-f(3) * den(145)) * TI2_call(4,momenta_70,masses2_2,G4tensor(:,34),T4sum(1:70,30))
  M(1) = M(1) + (CI*f(2) * den(332)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,53),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(2)) * den(332)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,53),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(2)) * den(332)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,53),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(2) * den(332)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,53),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(2)) * den(332)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,53),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(2) * den(332)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,53),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(2) * den(332)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,53),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(2)) * den(332)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,53),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(2) * den(332)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,54),T3sum(1:35,3))
  M(7) = M(7) + (-(CI*f(2)) * den(332)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,54),T3sum(1:35,3))
  M(13) = M(13) + (-(CI*f(2)) * den(332)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,54),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(2) * den(332)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,54),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(2)) * den(332)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,54),T3sum(1:35,3))
  M(21) = M(21) + (CI*f(2) * den(332)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,54),T3sum(1:35,3))
  M(23) = M(23) + (CI*f(2) * den(332)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,54),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(2)) * den(332)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,54),T3sum(1:35,3))
  M(1) = M(1) + (-f(3) * den(139)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,31),T4sum(1:70,12))
  M(7) = M(7) + (f(3) * den(139)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,31),T4sum(1:70,12))
  M(13) = M(13) + (f(3) * den(139)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,31),T4sum(1:70,12))
  M(15) = M(15) + (-f(3) * den(139)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,31),T4sum(1:70,12))
  M(19) = M(19) + (-f(3) * den(139)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,32),T4sum(1:70,12))
  M(21) = M(21) + (f(3) * den(139)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,32),T4sum(1:70,12))
  M(23) = M(23) + (f(3) * den(139)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,32),T4sum(1:70,12))
  M(24) = M(24) + (-f(3) * den(139)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,32),T4sum(1:70,12))
  M(5) = M(5) + (-(CI*f(2)) * den(159)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,55),T3sum(1:35,12))
  M(8) = M(8) + (CI*f(2) * den(159)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,55),T3sum(1:35,12))
  M(11) = M(11) + (-(CI*f(2)) * den(159)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,55),T3sum(1:35,12))
  M(14) = M(14) + (CI*f(2) * den(159)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,55),T3sum(1:35,12))
  M(15) = M(15) + (-(CI*f(2)) * den(159)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,55),T3sum(1:35,12))
  M(16) = M(16) + (CI*f(2) * den(159)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,55),T3sum(1:35,12))
  M(17) = M(17) + (-(CI*f(2)) * den(159)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,55),T3sum(1:35,12))
  M(19) = M(19) + (CI*f(2) * den(159)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,55),T3sum(1:35,12))
  M(5) = M(5) + (-(CI*f(2)) * den(159)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,56),T3sum(1:35,12))
  M(8) = M(8) + (CI*f(2) * den(159)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,56),T3sum(1:35,12))
  M(11) = M(11) + (-(CI*f(2)) * den(159)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,56),T3sum(1:35,12))
  M(14) = M(14) + (CI*f(2) * den(159)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,56),T3sum(1:35,12))
  M(15) = M(15) + (-(CI*f(2)) * den(159)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,56),T3sum(1:35,12))
  M(16) = M(16) + (CI*f(2) * den(159)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,56),T3sum(1:35,12))
  M(17) = M(17) + (-(CI*f(2)) * den(159)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,56),T3sum(1:35,12))
  M(19) = M(19) + (CI*f(2) * den(159)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,56),T3sum(1:35,12))
  M(2) = M(2) + (CI*f(2) * den(163)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,57),T3sum(1:35,14))
  M(5) = M(5) + (-(CI*f(2)) * den(163)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,57),T3sum(1:35,14))
  M(11) = M(11) + (-(CI*f(2)) * den(163)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,57),T3sum(1:35,14))
  M(13) = M(13) + (-(CI*f(2)) * den(163)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,57),T3sum(1:35,14))
  M(14) = M(14) + (CI*f(2) * den(163)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,57),T3sum(1:35,14))
  M(16) = M(16) + (CI*f(2) * den(163)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,57),T3sum(1:35,14))
  M(18) = M(18) + (-(CI*f(2)) * den(163)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,57),T3sum(1:35,14))
  M(21) = M(21) + (CI*f(2) * den(163)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,57),T3sum(1:35,14))
  M(2) = M(2) + (CI*f(2) * den(163)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,58),T3sum(1:35,14))
  M(5) = M(5) + (-(CI*f(2)) * den(163)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,58),T3sum(1:35,14))
  M(11) = M(11) + (-(CI*f(2)) * den(163)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,58),T3sum(1:35,14))
  M(13) = M(13) + (-(CI*f(2)) * den(163)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,58),T3sum(1:35,14))
  M(14) = M(14) + (CI*f(2) * den(163)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,58),T3sum(1:35,14))
  M(16) = M(16) + (CI*f(2) * den(163)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,58),T3sum(1:35,14))
  M(18) = M(18) + (-(CI*f(2)) * den(163)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,58),T3sum(1:35,14))
  M(21) = M(21) + (CI*f(2) * den(163)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,58),T3sum(1:35,14))
  M(2) = M(2) + (-(CI*f(2)) * den(340)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,59),T3sum(1:35,3))
  M(5) = M(5) + (CI*f(2) * den(340)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,59),T3sum(1:35,3))
  M(11) = M(11) + (CI*f(2) * den(340)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,59),T3sum(1:35,3))
  M(13) = M(13) + (CI*f(2) * den(340)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,59),T3sum(1:35,3))
  M(14) = M(14) + (-(CI*f(2)) * den(340)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,59),T3sum(1:35,3))
  M(16) = M(16) + (-(CI*f(2)) * den(340)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,59),T3sum(1:35,3))
  M(18) = M(18) + (CI*f(2) * den(340)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,59),T3sum(1:35,3))
  M(21) = M(21) + (-(CI*f(2)) * den(340)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,59),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(2)) * den(340)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,60),T3sum(1:35,3))
  M(5) = M(5) + (CI*f(2) * den(340)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,60),T3sum(1:35,3))
  M(11) = M(11) + (CI*f(2) * den(340)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,60),T3sum(1:35,3))
  M(13) = M(13) + (CI*f(2) * den(340)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,60),T3sum(1:35,3))
  M(14) = M(14) + (-(CI*f(2)) * den(340)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,60),T3sum(1:35,3))
  M(16) = M(16) + (-(CI*f(2)) * den(340)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,60),T3sum(1:35,3))
  M(18) = M(18) + (CI*f(2) * den(340)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,60),T3sum(1:35,3))
  M(21) = M(21) + (-(CI*f(2)) * den(340)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,60),T3sum(1:35,3))
  M(5) = M(5) + (-f(3) * den(162)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,40),T4sum(1:70,27))
  M(14) = M(14) + (f(3) * den(162)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,40),T4sum(1:70,27))
  M(18) = M(18) + (-f(3) * den(162)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,40),T4sum(1:70,27))
  M(21) = M(21) + (f(3) * den(162)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,40),T4sum(1:70,27))
  M(2) = M(2) + (-f(3) * den(162)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,39),T4sum(1:70,27))
  M(11) = M(11) + (f(3) * den(162)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,39),T4sum(1:70,27))
  M(13) = M(13) + (f(3) * den(162)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,39),T4sum(1:70,27))
  M(16) = M(16) + (-f(3) * den(162)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,39),T4sum(1:70,27))
  M(5) = M(5) + (CI*f(2) * den(342)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,61),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(2)) * den(342)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,61),T3sum(1:35,3))
  M(11) = M(11) + (CI*f(2) * den(342)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,61),T3sum(1:35,3))
  M(14) = M(14) + (-(CI*f(2)) * den(342)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,61),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(2) * den(342)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,61),T3sum(1:35,3))
  M(16) = M(16) + (-(CI*f(2)) * den(342)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,61),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(2) * den(342)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,61),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(2)) * den(342)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,61),T3sum(1:35,3))
  M(5) = M(5) + (CI*f(2) * den(342)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,62),T3sum(1:35,3))
  M(8) = M(8) + (-(CI*f(2)) * den(342)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,62),T3sum(1:35,3))
  M(11) = M(11) + (CI*f(2) * den(342)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,62),T3sum(1:35,3))
  M(14) = M(14) + (-(CI*f(2)) * den(342)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,62),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(2) * den(342)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,62),T3sum(1:35,3))
  M(16) = M(16) + (-(CI*f(2)) * den(342)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,62),T3sum(1:35,3))
  M(17) = M(17) + (CI*f(2) * den(342)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,62),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(2)) * den(342)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,62),T3sum(1:35,3))
  M(11) = M(11) + (-f(3) * den(158)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,37),T4sum(1:70,21))
  M(16) = M(16) + (f(3) * den(158)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,37),T4sum(1:70,21))
  M(17) = M(17) + (-f(3) * den(158)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,37),T4sum(1:70,21))
  M(19) = M(19) + (f(3) * den(158)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,37),T4sum(1:70,21))
  M(5) = M(5) + (f(3) * den(158)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,38),T4sum(1:70,21))
  M(8) = M(8) + (-f(3) * den(158)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,38),T4sum(1:70,21))
  M(14) = M(14) + (-f(3) * den(158)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,38),T4sum(1:70,21))
  M(15) = M(15) + (f(3) * den(158)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,38),T4sum(1:70,21))
  M(3) = M(3) + (CI*f(2) * den(167)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,63),T3sum(1:35,9))
  M(7) = M(7) + (-(CI*f(2)) * den(167)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,63),T3sum(1:35,9))
  M(9) = M(9) + (CI*f(2) * den(167)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,63),T3sum(1:35,9))
  M(13) = M(13) + (-(CI*f(2)) * den(167)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,63),T3sum(1:35,9))
  M(20) = M(20) + (-(CI*f(2)) * den(167)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,63),T3sum(1:35,9))
  M(21) = M(21) + (CI*f(2) * den(167)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,63),T3sum(1:35,9))
  M(22) = M(22) + (-(CI*f(2)) * den(167)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,63),T3sum(1:35,9))
  M(23) = M(23) + (CI*f(2) * den(167)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,63),T3sum(1:35,9))
  M(3) = M(3) + (CI*f(2) * den(167)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,64),T3sum(1:35,9))
  M(7) = M(7) + (-(CI*f(2)) * den(167)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,64),T3sum(1:35,9))
  M(9) = M(9) + (CI*f(2) * den(167)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,64),T3sum(1:35,9))
  M(13) = M(13) + (-(CI*f(2)) * den(167)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,64),T3sum(1:35,9))
  M(20) = M(20) + (-(CI*f(2)) * den(167)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,64),T3sum(1:35,9))
  M(21) = M(21) + (CI*f(2) * den(167)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,64),T3sum(1:35,9))
  M(22) = M(22) + (-(CI*f(2)) * den(167)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,64),T3sum(1:35,9))
  M(23) = M(23) + (CI*f(2) * den(167)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,64),T3sum(1:35,9))
  M(3) = M(3) + (CI*f(2) * den(173)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,65),T3sum(1:35,14))
  M(4) = M(4) + (-(CI*f(2)) * den(173)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,65),T3sum(1:35,14))
  M(11) = M(11) + (-(CI*f(2)) * den(173)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,65),T3sum(1:35,14))
  M(12) = M(12) + (CI*f(2) * den(173)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,65),T3sum(1:35,14))
  M(13) = M(13) + (-(CI*f(2)) * den(173)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,65),T3sum(1:35,14))
  M(14) = M(14) + (CI*f(2) * den(173)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,65),T3sum(1:35,14))
  M(21) = M(21) + (CI*f(2) * den(173)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,65),T3sum(1:35,14))
  M(22) = M(22) + (-(CI*f(2)) * den(173)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,65),T3sum(1:35,14))
  M(3) = M(3) + (CI*f(2) * den(173)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,66),T3sum(1:35,14))
  M(4) = M(4) + (-(CI*f(2)) * den(173)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,66),T3sum(1:35,14))
  M(11) = M(11) + (-(CI*f(2)) * den(173)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,66),T3sum(1:35,14))
  M(12) = M(12) + (CI*f(2) * den(173)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,66),T3sum(1:35,14))
  M(13) = M(13) + (-(CI*f(2)) * den(173)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,66),T3sum(1:35,14))
  M(14) = M(14) + (CI*f(2) * den(173)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,66),T3sum(1:35,14))
  M(21) = M(21) + (CI*f(2) * den(173)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,66),T3sum(1:35,14))
  M(22) = M(22) + (-(CI*f(2)) * den(173)) * TI2_call(3,momenta_11,masses2_1,G3tensor(:,66),T3sum(1:35,14))
  M(3) = M(3) + (-(CI*f(2)) * den(350)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,67),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(2) * den(350)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,67),T3sum(1:35,3))
  M(11) = M(11) + (CI*f(2) * den(350)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,67),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(2)) * den(350)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,67),T3sum(1:35,3))
  M(13) = M(13) + (CI*f(2) * den(350)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,67),T3sum(1:35,3))
  M(14) = M(14) + (-(CI*f(2)) * den(350)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,67),T3sum(1:35,3))
  M(21) = M(21) + (-(CI*f(2)) * den(350)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,67),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(2) * den(350)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,67),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(2)) * den(350)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,68),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(2) * den(350)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,68),T3sum(1:35,3))
  M(11) = M(11) + (CI*f(2) * den(350)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,68),T3sum(1:35,3))
  M(12) = M(12) + (-(CI*f(2)) * den(350)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,68),T3sum(1:35,3))
  M(13) = M(13) + (CI*f(2) * den(350)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,68),T3sum(1:35,3))
  M(14) = M(14) + (-(CI*f(2)) * den(350)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,68),T3sum(1:35,3))
  M(21) = M(21) + (-(CI*f(2)) * den(350)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,68),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(2) * den(350)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,68),T3sum(1:35,3))
  M(4) = M(4) + (-f(3) * den(172)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,44),T4sum(1:70,27))
  M(14) = M(14) + (f(3) * den(172)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,44),T4sum(1:70,27))
  M(21) = M(21) + (f(3) * den(172)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,44),T4sum(1:70,27))
  M(22) = M(22) + (-f(3) * den(172)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,44),T4sum(1:70,27))
  M(3) = M(3) + (-f(3) * den(172)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,43),T4sum(1:70,27))
  M(11) = M(11) + (f(3) * den(172)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,43),T4sum(1:70,27))
  M(12) = M(12) + (-f(3) * den(172)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,43),T4sum(1:70,27))
  M(13) = M(13) + (f(3) * den(172)) * TI2_call(4,momenta_85,masses2_2,G4tensor(:,43),T4sum(1:70,27))
  M(3) = M(3) + (-(CI*f(2)) * den(352)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,69),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(2) * den(352)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,69),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(2)) * den(352)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,69),T3sum(1:35,3))
  M(13) = M(13) + (CI*f(2) * den(352)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,69),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(2) * den(352)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,69),T3sum(1:35,3))
  M(21) = M(21) + (-(CI*f(2)) * den(352)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,69),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(2) * den(352)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,69),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(2)) * den(352)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,69),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(2)) * den(352)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,70),T3sum(1:35,3))
  M(7) = M(7) + (CI*f(2) * den(352)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,70),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(2)) * den(352)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,70),T3sum(1:35,3))
  M(13) = M(13) + (CI*f(2) * den(352)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,70),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(2) * den(352)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,70),T3sum(1:35,3))
  M(21) = M(21) + (-(CI*f(2)) * den(352)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,70),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(2) * den(352)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,70),T3sum(1:35,3))
  M(23) = M(23) + (-(CI*f(2)) * den(352)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,70),T3sum(1:35,3))
  M(3) = M(3) + (f(3) * den(166)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,41),T4sum(1:70,12))
  M(7) = M(7) + (-f(3) * den(166)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,41),T4sum(1:70,12))
  M(9) = M(9) + (f(3) * den(166)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,41),T4sum(1:70,12))
  M(13) = M(13) + (-f(3) * den(166)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,41),T4sum(1:70,12))
  M(20) = M(20) + (f(3) * den(166)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,42),T4sum(1:70,12))
  M(21) = M(21) + (-f(3) * den(166)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,42),T4sum(1:70,12))
  M(22) = M(22) + (f(3) * den(166)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,42),T4sum(1:70,12))
  M(23) = M(23) + (-f(3) * den(166)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,42),T4sum(1:70,12))
  M(1) = M(1) + (-(CI*f(2)) * den(177)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,71),T3sum(1:35,9))
  M(3) = M(3) + (CI*f(2) * den(177)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,71),T3sum(1:35,9))
  M(9) = M(9) + (CI*f(2) * den(177)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,71),T3sum(1:35,9))
  M(15) = M(15) + (-(CI*f(2)) * den(177)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,71),T3sum(1:35,9))
  M(19) = M(19) + (CI*f(2) * den(177)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,71),T3sum(1:35,9))
  M(20) = M(20) + (-(CI*f(2)) * den(177)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,71),T3sum(1:35,9))
  M(22) = M(22) + (-(CI*f(2)) * den(177)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,71),T3sum(1:35,9))
  M(24) = M(24) + (CI*f(2) * den(177)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,71),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(2)) * den(177)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,72),T3sum(1:35,9))
  M(3) = M(3) + (CI*f(2) * den(177)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,72),T3sum(1:35,9))
  M(9) = M(9) + (CI*f(2) * den(177)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,72),T3sum(1:35,9))
  M(15) = M(15) + (-(CI*f(2)) * den(177)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,72),T3sum(1:35,9))
  M(19) = M(19) + (CI*f(2) * den(177)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,72),T3sum(1:35,9))
  M(20) = M(20) + (-(CI*f(2)) * den(177)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,72),T3sum(1:35,9))
  M(22) = M(22) + (-(CI*f(2)) * den(177)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,72),T3sum(1:35,9))
  M(24) = M(24) + (CI*f(2) * den(177)) * TI2_call(3,momenta_14,masses2_1,G3tensor(:,72),T3sum(1:35,9))
  M(5) = M(5) + (-(CI*f(2)) * den(181)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,73),T3sum(1:35,12))
  M(6) = M(6) + (CI*f(2) * den(181)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,73),T3sum(1:35,12))
  M(9) = M(9) + (CI*f(2) * den(181)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,73),T3sum(1:35,12))
  M(10) = M(10) + (-(CI*f(2)) * den(181)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,73),T3sum(1:35,12))
  M(15) = M(15) + (-(CI*f(2)) * den(181)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,73),T3sum(1:35,12))
  M(16) = M(16) + (CI*f(2) * den(181)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,73),T3sum(1:35,12))
  M(19) = M(19) + (CI*f(2) * den(181)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,73),T3sum(1:35,12))
  M(20) = M(20) + (-(CI*f(2)) * den(181)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,73),T3sum(1:35,12))
  M(5) = M(5) + (-(CI*f(2)) * den(181)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,74),T3sum(1:35,12))
  M(6) = M(6) + (CI*f(2) * den(181)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,74),T3sum(1:35,12))
  M(9) = M(9) + (CI*f(2) * den(181)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,74),T3sum(1:35,12))
  M(10) = M(10) + (-(CI*f(2)) * den(181)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,74),T3sum(1:35,12))
  M(15) = M(15) + (-(CI*f(2)) * den(181)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,74),T3sum(1:35,12))
  M(16) = M(16) + (CI*f(2) * den(181)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,74),T3sum(1:35,12))
  M(19) = M(19) + (CI*f(2) * den(181)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,74),T3sum(1:35,12))
  M(20) = M(20) + (-(CI*f(2)) * den(181)) * TI2_call(3,momenta_13,masses2_1,G3tensor(:,74),T3sum(1:35,12))
  M(5) = M(5) + (CI*f(2) * den(360)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,75),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(2)) * den(360)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,75),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(2)) * den(360)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,75),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(2) * den(360)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,75),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(2) * den(360)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,75),T3sum(1:35,3))
  M(16) = M(16) + (-(CI*f(2)) * den(360)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,75),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(2)) * den(360)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,75),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(2) * den(360)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,75),T3sum(1:35,3))
  M(5) = M(5) + (CI*f(2) * den(360)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,76),T3sum(1:35,3))
  M(6) = M(6) + (-(CI*f(2)) * den(360)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,76),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(2)) * den(360)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,76),T3sum(1:35,3))
  M(10) = M(10) + (CI*f(2) * den(360)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,76),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(2) * den(360)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,76),T3sum(1:35,3))
  M(16) = M(16) + (-(CI*f(2)) * den(360)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,76),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(2)) * den(360)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,76),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(2) * den(360)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,76),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(2) * den(361)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,77),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(2)) * den(361)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,77),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(2)) * den(361)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,77),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(2) * den(361)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,77),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(2)) * den(361)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,77),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(2) * den(361)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,77),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(2) * den(361)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,77),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(2)) * den(361)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,77),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(2) * den(361)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,78),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(2)) * den(361)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,78),T3sum(1:35,3))
  M(9) = M(9) + (-(CI*f(2)) * den(361)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,78),T3sum(1:35,3))
  M(15) = M(15) + (CI*f(2) * den(361)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,78),T3sum(1:35,3))
  M(19) = M(19) + (-(CI*f(2)) * den(361)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,78),T3sum(1:35,3))
  M(20) = M(20) + (CI*f(2) * den(361)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,78),T3sum(1:35,3))
  M(22) = M(22) + (CI*f(2) * den(361)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,78),T3sum(1:35,3))
  M(24) = M(24) + (-(CI*f(2)) * den(361)) * TI2_call(3,momenta_15,masses2_1,G3tensor(:,78),T3sum(1:35,3))
  M(10) = M(10) + (-f(3) * den(180)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,48),T4sum(1:70,21))
  M(16) = M(16) + (f(3) * den(180)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,48),T4sum(1:70,21))
  M(19) = M(19) + (f(3) * den(180)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,48),T4sum(1:70,21))
  M(20) = M(20) + (-f(3) * den(180)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,48),T4sum(1:70,21))
  M(5) = M(5) + (f(3) * den(180)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,47),T4sum(1:70,21))
  M(6) = M(6) + (-f(3) * den(180)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,47),T4sum(1:70,21))
  M(9) = M(9) + (-f(3) * den(180)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,47),T4sum(1:70,21))
  M(15) = M(15) + (f(3) * den(180)) * TI2_call(4,momenta_89,masses2_2,G4tensor(:,47),T4sum(1:70,21))
  M(1) = M(1) + (-f(3) * den(176)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,45),T4sum(1:70,12))
  M(3) = M(3) + (f(3) * den(176)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,45),T4sum(1:70,12))
  M(9) = M(9) + (f(3) * den(176)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,45),T4sum(1:70,12))
  M(15) = M(15) + (-f(3) * den(176)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,45),T4sum(1:70,12))
  M(19) = M(19) + (-f(3) * den(176)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,46),T4sum(1:70,12))
  M(20) = M(20) + (f(3) * den(176)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,46),T4sum(1:70,12))
  M(22) = M(22) + (f(3) * den(176)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,46),T4sum(1:70,12))
  M(24) = M(24) + (-f(3) * den(176)) * TI2_call(4,momenta_90,masses2_2,G4tensor(:,46),T4sum(1:70,12))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_5

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_5_pphjjj2_hggggg_1_/**/REALKIND
