
module ol_vamp_5_pphjjj2_bbxhggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G1tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G2tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_5(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphjjj2_bbxhggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphjjj2_bbxhggg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphjjj2_bbxhggg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphjjj2_bbxhggg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(11)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,53) :: G0
  complex(REALKIND), dimension(4,5,4,219) :: G1
  complex(REALKIND), dimension(4,15,4,339) :: G2
  complex(REALKIND), dimension(4,35,4,137) :: G3
  complex(REALKIND), dimension(4,70,4,27) :: G4
  complex(REALKIND), pointer :: G1tensor(:,:)
  complex(REALKIND), pointer :: G2tensor(:,:)
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G1tensorhel(5,46,32))
    allocate(G2tensorhel(15,100,32))
    allocate(G3tensorhel(35,189,32))
    allocate(G4tensorhel(70,51,32))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G1tensor => G1tensorhel(:,:,hel)
  G2tensor => G2tensorhel(:,:,hel)
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,11),Q(:,48),G1(:,:,:,1))
  call loop_VA_Q(G1(:,:,:,1),wf(:,12),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,58),MB,G2(:,:,:,1))
  call check_last_AQ_V(l_switch,G2(:,:,:,1),wf(:,3),G2tensor(:,1))
  call loop_AS_Q(G2(:,:,:,1),wf(:,-2),G2(:,:,:,2),gH)
  call loop_A_Q(G2(:,:,:,2),Q(:,62),MB,G3(:,:,:,1))
  call check_last_AQ_V(l_switch,G3(:,:,:,1),wf(:,0),G3tensor(:,1))
  call loop_VQ_A(G1(:,:,:,1),wf(:,26),G1(:,:,:,3))
  call loop_Q_A(G1(:,:,:,3),Q(:,61),MB,G2(:,:,:,3))
  call check_last_QA_V(l_switch,G2(:,:,:,3),wf(:,-1),G2tensor(:,2))
  call loop_VQ_A(G1(:,:,:,1),wf(:,3),G1(:,:,:,4))
  call loop_Q_A(G1(:,:,:,4),Q(:,53),MB,G2(:,:,:,4))
  call loop_QV_A(G2(:,:,:,4),wf(:,-3),G2(:,:,:,5))
  call loop_Q_A(G2(:,:,:,5),Q(:,61),MB,G3(:,:,:,2))
  call check_last_QA_V(l_switch,G3(:,:,:,2),wf(:,-1),G3tensor(:,2))
  call loop_UV_W(G1(:,:,:,1),Q(:,48),wf(:,-3),Q(:,8),G2(:,:,:,6))
  call loop_VQ_A(G2(:,:,:,6),wf(:,3),G2(:,:,:,7))
  call loop_Q_A(G2(:,:,:,7),Q(:,61),MB,G3(:,:,:,3))
  call check_last_QA_V(l_switch,G3(:,:,:,3),wf(:,-1),G3tensor(:,3))
  call loop_VA_Q(G2(:,:,:,6),wf(:,8),G2(:,:,:,8))
  call loop_A_Q(G2(:,:,:,8),Q(:,62),MB,G3(:,:,:,4))
  call check_last_AQ_V(l_switch,G3(:,:,:,4),wf(:,0),G3tensor(:,4))
  call loop_VA_Q(G2(:,:,:,6),wf(:,-1),G2(:,:,:,9))
  call loop_A_Q(G2(:,:,:,9),Q(:,58),MB,G3(:,:,:,5))
  call loop_AS_Q(G3(:,:,:,5),wf(:,-2),G3(:,:,:,6),gH)
  call loop_A_Q(G3(:,:,:,6),Q(:,62),MB,G4(:,:,:,1))
  call check_last_AQ_V(l_switch,G4(:,:,:,1),wf(:,0),G4tensor(:,1))
  call loop_VQ_A(G1(:,:,:,1),wf(:,46),G1(:,:,:,5))
  call loop_Q_A(G1(:,:,:,5),Q(:,57),MB,G2(:,:,:,10))
  call check_last_QA_V(l_switch,G2(:,:,:,10),wf(:,8),G2tensor(:,3))
  call loop_QS_A(G2(:,:,:,10),wf(:,-2),G2(:,:,:,11),gH)
  call loop_Q_A(G2(:,:,:,11),Q(:,61),MB,G3(:,:,:,7))
  call check_last_QA_V(l_switch,G3(:,:,:,7),wf(:,-1),G3tensor(:,5))
  call loop_VA_Q(G1(:,:,:,1),wf(:,61),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,62),MB,G2(:,:,:,12))
  call check_last_AQ_V(l_switch,G2(:,:,:,12),wf(:,0),G2tensor(:,4))
  call loop_VA_Q(G1(:,:,:,1),wf(:,8),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,54),MB,G2(:,:,:,13))
  call loop_AV_Q(G2(:,:,:,13),wf(:,-3),G2(:,:,:,14))
  call loop_A_Q(G2(:,:,:,14),Q(:,62),MB,G3(:,:,:,8))
  call check_last_AQ_V(l_switch,G3(:,:,:,8),wf(:,0),G3tensor(:,6))
  call loop_VQ_A(G1(:,:,:,1),wf(:,75),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,61),MB,G2(:,:,:,15))
  call check_last_QA_V(l_switch,G2(:,:,:,15),wf(:,-1),G2tensor(:,5))
  call loop_VA_Q(G1(:,:,:,1),wf(:,83),G1(:,:,:,9))
  call loop_A_Q(G1(:,:,:,9),Q(:,62),MB,G2(:,:,:,16))
  call check_last_AQ_V(l_switch,G2(:,:,:,16),wf(:,0),G2tensor(:,6))
  call loop_VA_Q(G1(:,:,:,1),wf(:,-1),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,50),MB,G2(:,:,:,17))
  call loop_AV_Q(G2(:,:,:,17),wf(:,-3),G2(:,:,:,18))
  call loop_A_Q(G2(:,:,:,18),Q(:,58),MB,G3(:,:,:,9))
  call loop_AS_Q(G3(:,:,:,9),wf(:,-2),G3(:,:,:,10),gH)
  call loop_A_Q(G3(:,:,:,10),Q(:,62),MB,G4(:,:,:,2))
  call check_last_AQ_V(l_switch,G4(:,:,:,2),wf(:,0),G4tensor(:,2))
  call loop_AS_Q(G2(:,:,:,17),wf(:,-2),G2(:,:,:,19),gH)
  call loop_A_Q(G2(:,:,:,19),Q(:,54),MB,G3(:,:,:,11))
  call loop_AV_Q(G3(:,:,:,11),wf(:,-3),G3(:,:,:,12))
  call loop_A_Q(G3(:,:,:,12),Q(:,62),MB,G4(:,:,:,3))
  call check_last_AQ_V(l_switch,G4(:,:,:,3),wf(:,0),G4tensor(:,3))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,-3),wf(:,4),G1tensor(:,1))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,4),wf(:,-3),G1tensor(:,2))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,-3),wf(:,4),G1tensor(:,3))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,-3),wf(:,9),G1tensor(:,4))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,1),wf(:,9),wf(:,-3),G1tensor(:,5))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,1),wf(:,-3),wf(:,9),G1tensor(:,6))
  call check_last_UV_W(l_switch,G1(:,:,:,1),Q(:,48),wf(:,13),Q(:,15),G2tensor(:,7))
  call check_last_UV_W(l_switch,G1(:,:,:,1),Q(:,48),wf(:,405),Q(:,15),G2tensor(:,8))
  call check_last_UV_W(l_switch,G1(:,:,:,1),Q(:,48),wf(:,408),Q(:,15),G2tensor(:,9))
  call check_last_UV_W(l_switch,G1(:,:,:,1),Q(:,48),wf(:,47),Q(:,15),G2tensor(:,10))
  call check_last_UV_W(l_switch,G1(:,:,:,1),Q(:,48),wf(:,423),Q(:,15),G2tensor(:,11))
  call check_last_UV_W(l_switch,G1(:,:,:,1),Q(:,48),wf(:,426),Q(:,15),G2tensor(:,12))
  call check_last_UV_W(l_switch,G1(:,:,:,1),Q(:,48),wf(:,443),Q(:,15),G2tensor(:,13))
  call check_last_UV_W(l_switch,G1(:,:,:,1),Q(:,48),wf(:,460),Q(:,15),G2tensor(:,14))
  call loop_VQ_A(G0(:,:,:,1),wf(:,16),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,21),MB,G1(:,:,:,11))
  call loop_QV_A(G1(:,:,:,11),wf(:,-5),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,53),MB,G2(:,:,:,20))
  call check_last_QA_V(l_switch,G2(:,:,:,20),wf(:,12),G2tensor(:,15))
  call loop_QV_A(G2(:,:,:,20),wf(:,-3),G2(:,:,:,21))
  call loop_Q_A(G2(:,:,:,21),Q(:,61),MB,G3(:,:,:,13))
  call check_last_QA_V(l_switch,G3(:,:,:,13),wf(:,-1),G3tensor(:,7))
  call loop_QA_V(G1(:,:,:,11),wf(:,31),G1(:,:,:,13))
  call check_last_UV_W(l_switch,G1(:,:,:,13),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,16))
  call loop_QV_A(G1(:,:,:,11),wf(:,21),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,61),MB,G2(:,:,:,22))
  call check_last_QA_V(l_switch,G2(:,:,:,22),wf(:,-1),G2tensor(:,17))
  call loop_QV_A(G1(:,:,:,11),wf(:,-3),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,29),MB,G2(:,:,:,23))
  call loop_QV_A(G2(:,:,:,23),wf(:,-5),G2(:,:,:,24))
  call loop_Q_A(G2(:,:,:,24),Q(:,61),MB,G3(:,:,:,14))
  call check_last_QA_V(l_switch,G3(:,:,:,14),wf(:,-1),G3tensor(:,8))
  call loop_VQ_A(G0(:,:,:,1),wf(:,130),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,37),MB,G1(:,:,:,16))
  call loop_QV_A(G1(:,:,:,16),wf(:,-4),G1(:,:,:,17))
  call loop_Q_A(G1(:,:,:,17),Q(:,53),MB,G2(:,:,:,25))
  call check_last_QA_V(l_switch,G2(:,:,:,25),wf(:,12),G2tensor(:,18))
  call loop_QV_A(G2(:,:,:,25),wf(:,-3),G2(:,:,:,26))
  call loop_Q_A(G2(:,:,:,26),Q(:,61),MB,G3(:,:,:,15))
  call check_last_QA_V(l_switch,G3(:,:,:,15),wf(:,-1),G3tensor(:,9))
  call loop_QV_A(G1(:,:,:,16),wf(:,-3),G1(:,:,:,18))
  call loop_Q_A(G1(:,:,:,18),Q(:,45),MB,G2(:,:,:,27))
  call check_last_QA_V(l_switch,G2(:,:,:,27),wf(:,22),G2tensor(:,19))
  call loop_QV_A(G2(:,:,:,27),wf(:,-4),G2(:,:,:,28))
  call loop_Q_A(G2(:,:,:,28),Q(:,61),MB,G3(:,:,:,16))
  call check_last_QA_V(l_switch,G3(:,:,:,16),wf(:,-1),G3tensor(:,10))
  call loop_QV_A(G1(:,:,:,16),wf(:,30),G1(:,:,:,19))
  call loop_Q_A(G1(:,:,:,19),Q(:,61),MB,G2(:,:,:,29))
  call check_last_QA_V(l_switch,G2(:,:,:,29),wf(:,-1),G2tensor(:,20))
  call check_last_QA_V(l_switch,G1(:,:,:,16),wf(:,19),G1tensor(:,7))
  call check_last_QA_V(l_switch,G1(:,:,:,16),wf(:,28),G1tensor(:,8))
  call check_last_QA_V(l_switch,G1(:,:,:,16),wf(:,35),G1tensor(:,9))
  call loop_VA_Q(G0(:,:,:,1),wf(:,19),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,26),MB,G1(:,:,:,20))
  call loop_AV_Q(G1(:,:,:,20),wf(:,-5),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,58),MB,G2(:,:,:,30))
  call check_last_AQ_V(l_switch,G2(:,:,:,30),wf(:,3),G2tensor(:,21))
  call loop_AS_Q(G2(:,:,:,30),wf(:,-2),G2(:,:,:,31),gH)
  call loop_A_Q(G2(:,:,:,31),Q(:,62),MB,G3(:,:,:,17))
  call check_last_AQ_V(l_switch,G3(:,:,:,17),wf(:,0),G3tensor(:,11))
  call loop_AS_Q(G1(:,:,:,20),wf(:,-2),G1(:,:,:,22),gH)
  call loop_A_Q(G1(:,:,:,22),Q(:,30),MB,G2(:,:,:,32))
  call loop_AV_Q(G2(:,:,:,32),wf(:,-5),G2(:,:,:,33))
  call loop_A_Q(G2(:,:,:,33),Q(:,62),MB,G3(:,:,:,18))
  call check_last_AQ_V(l_switch,G3(:,:,:,18),wf(:,0),G3tensor(:,12))
  call loop_VA_Q(G0(:,:,:,1),wf(:,132),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,42),MB,G1(:,:,:,23))
  call loop_AV_Q(G1(:,:,:,23),wf(:,-4),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,58),MB,G2(:,:,:,34))
  call check_last_AQ_V(l_switch,G2(:,:,:,34),wf(:,3),G2tensor(:,22))
  call loop_AS_Q(G2(:,:,:,34),wf(:,-2),G2(:,:,:,35),gH)
  call loop_A_Q(G2(:,:,:,35),Q(:,62),MB,G3(:,:,:,19))
  call check_last_AQ_V(l_switch,G3(:,:,:,19),wf(:,0),G3tensor(:,13))
  call loop_AS_Q(G1(:,:,:,23),wf(:,-2),G1(:,:,:,25),gH)
  call loop_A_Q(G1(:,:,:,25),Q(:,46),MB,G2(:,:,:,36))
  call check_last_AQ_V(l_switch,G2(:,:,:,36),wf(:,55),G2tensor(:,23))
  call loop_AV_Q(G2(:,:,:,36),wf(:,-4),G2(:,:,:,37))
  call loop_A_Q(G2(:,:,:,37),Q(:,62),MB,G3(:,:,:,20))
  call check_last_AQ_V(l_switch,G3(:,:,:,20),wf(:,0),G3tensor(:,14))
  call check_last_AQ_V(l_switch,G1(:,:,:,23),wf(:,16),G1tensor(:,10))
  call check_last_AQ_V(l_switch,G1(:,:,:,23),wf(:,81),G1tensor(:,11))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,16),ZERO,G1(:,:,:,26))
  call loop_AV_Q(G1(:,:,:,26),wf(:,-5),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,48),ZERO,G2(:,:,:,38))
  call loop_AV_Q(G2(:,:,:,38),wf(:,13),G2(:,:,:,39))
  call check_last_A_Q(l_switch,G2(:,:,:,39),Q(:,63),ZERO,G3tensor(:,15))
  call loop_AV_Q(G2(:,:,:,38),wf(:,405),G2(:,:,:,40))
  call check_last_A_Q(l_switch,G2(:,:,:,40),Q(:,63),ZERO,G3tensor(:,16))
  call loop_AV_Q(G2(:,:,:,38),wf(:,408),G2(:,:,:,41))
  call check_last_A_Q(l_switch,G2(:,:,:,41),Q(:,63),ZERO,G3tensor(:,17))
  call loop_AV_Q(G2(:,:,:,38),wf(:,47),G2(:,:,:,42))
  call check_last_A_Q(l_switch,G2(:,:,:,42),Q(:,63),ZERO,G3tensor(:,18))
  call loop_AV_Q(G2(:,:,:,38),wf(:,423),G2(:,:,:,43))
  call check_last_A_Q(l_switch,G2(:,:,:,43),Q(:,63),ZERO,G3tensor(:,19))
  call loop_AV_Q(G2(:,:,:,38),wf(:,426),G2(:,:,:,44))
  call check_last_A_Q(l_switch,G2(:,:,:,44),Q(:,63),ZERO,G3tensor(:,20))
  call loop_AV_Q(G2(:,:,:,38),wf(:,443),G2(:,:,:,45))
  call check_last_A_Q(l_switch,G2(:,:,:,45),Q(:,63),ZERO,G3tensor(:,21))
  call loop_AV_Q(G2(:,:,:,38),wf(:,460),G2(:,:,:,46))
  call check_last_A_Q(l_switch,G2(:,:,:,46),Q(:,63),ZERO,G3tensor(:,22))
  call loop_AV_Q(G1(:,:,:,26),wf(:,32),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,55),ZERO,G2(:,:,:,47))
  call loop_AV_Q(G2(:,:,:,47),wf(:,-3),G2(:,:,:,48))
  call check_last_A_Q(l_switch,G2(:,:,:,48),Q(:,63),ZERO,G3tensor(:,23))
  call loop_AV_Q(G1(:,:,:,26),wf(:,21),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,56),ZERO,G2(:,:,:,49))
  call loop_AV_Q(G2(:,:,:,49),wf(:,4),G2(:,:,:,50))
  call check_last_A_Q(l_switch,G2(:,:,:,50),Q(:,63),ZERO,G3tensor(:,24))
  call loop_AV_Q(G2(:,:,:,49),wf(:,9),G2(:,:,:,51))
  call check_last_A_Q(l_switch,G2(:,:,:,51),Q(:,63),ZERO,G3tensor(:,25))
  call loop_AV_Q(G1(:,:,:,26),wf(:,407),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,55),ZERO,G2(:,:,:,52))
  call loop_AV_Q(G2(:,:,:,52),wf(:,-3),G2(:,:,:,53))
  call check_last_A_Q(l_switch,G2(:,:,:,53),Q(:,63),ZERO,G3tensor(:,26))
  call loop_AV_Q(G1(:,:,:,26),wf(:,-3),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,24),ZERO,G2(:,:,:,54))
  call loop_AV_Q(G2(:,:,:,54),wf(:,-5),G2(:,:,:,55))
  call loop_A_Q(G2(:,:,:,55),Q(:,56),ZERO,G3(:,:,:,21))
  call loop_AV_Q(G3(:,:,:,21),wf(:,4),G3(:,:,:,22))
  call check_last_A_Q(l_switch,G3(:,:,:,22),Q(:,63),ZERO,G4tensor(:,4))
  call loop_AV_Q(G3(:,:,:,21),wf(:,9),G3(:,:,:,23))
  call check_last_A_Q(l_switch,G3(:,:,:,23),Q(:,63),ZERO,G4tensor(:,5))
  call loop_AV_Q(G1(:,:,:,26),wf(:,418),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,55),ZERO,G2(:,:,:,56))
  call loop_AV_Q(G2(:,:,:,56),wf(:,-3),G2(:,:,:,57))
  call check_last_A_Q(l_switch,G2(:,:,:,57),Q(:,63),ZERO,G3tensor(:,27))
  call loop_AV_Q(G1(:,:,:,26),wf(:,64),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,55),ZERO,G2(:,:,:,58))
  call loop_AV_Q(G2(:,:,:,58),wf(:,-3),G2(:,:,:,59))
  call check_last_A_Q(l_switch,G2(:,:,:,59),Q(:,63),ZERO,G3tensor(:,28))
  call loop_AV_Q(G1(:,:,:,26),wf(:,425),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,55),ZERO,G2(:,:,:,60))
  call loop_AV_Q(G2(:,:,:,60),wf(:,-3),G2(:,:,:,61))
  call check_last_A_Q(l_switch,G2(:,:,:,61),Q(:,63),ZERO,G3tensor(:,29))
  call loop_AV_Q(G1(:,:,:,26),wf(:,428),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,55),ZERO,G2(:,:,:,62))
  call loop_AV_Q(G2(:,:,:,62),wf(:,-3),G2(:,:,:,63))
  call check_last_A_Q(l_switch,G2(:,:,:,63),Q(:,63),ZERO,G3tensor(:,30))
  call loop_AV_Q(G1(:,:,:,26),wf(:,525),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,55),ZERO,G2(:,:,:,64))
  call loop_AV_Q(G2(:,:,:,64),wf(:,-3),G2(:,:,:,65))
  call check_last_A_Q(l_switch,G2(:,:,:,65),Q(:,63),ZERO,G3tensor(:,31))
  call loop_AV_Q(G1(:,:,:,26),wf(:,542),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,55),ZERO,G2(:,:,:,66))
  call loop_AV_Q(G2(:,:,:,66),wf(:,-3),G2(:,:,:,67))
  call check_last_A_Q(l_switch,G2(:,:,:,67),Q(:,63),ZERO,G3tensor(:,32))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,16),ZERO,G1(:,:,:,38))
  call loop_QV_A(G1(:,:,:,38),wf(:,-5),G1(:,:,:,39))
  call loop_Q_A(G1(:,:,:,39),Q(:,48),ZERO,G2(:,:,:,68))
  call loop_QV_A(G2(:,:,:,68),wf(:,13),G2(:,:,:,69))
  call check_last_Q_A(l_switch,G2(:,:,:,69),Q(:,63),ZERO,G3tensor(:,33))
  call loop_QV_A(G2(:,:,:,68),wf(:,405),G2(:,:,:,70))
  call check_last_Q_A(l_switch,G2(:,:,:,70),Q(:,63),ZERO,G3tensor(:,34))
  call loop_QV_A(G2(:,:,:,68),wf(:,408),G2(:,:,:,71))
  call check_last_Q_A(l_switch,G2(:,:,:,71),Q(:,63),ZERO,G3tensor(:,35))
  call loop_QV_A(G2(:,:,:,68),wf(:,47),G2(:,:,:,72))
  call check_last_Q_A(l_switch,G2(:,:,:,72),Q(:,63),ZERO,G3tensor(:,36))
  call loop_QV_A(G2(:,:,:,68),wf(:,423),G2(:,:,:,73))
  call check_last_Q_A(l_switch,G2(:,:,:,73),Q(:,63),ZERO,G3tensor(:,37))
  call loop_QV_A(G2(:,:,:,68),wf(:,426),G2(:,:,:,74))
  call check_last_Q_A(l_switch,G2(:,:,:,74),Q(:,63),ZERO,G3tensor(:,38))
  call loop_QV_A(G2(:,:,:,68),wf(:,443),G2(:,:,:,75))
  call check_last_Q_A(l_switch,G2(:,:,:,75),Q(:,63),ZERO,G3tensor(:,39))
  call loop_QV_A(G2(:,:,:,68),wf(:,460),G2(:,:,:,76))
  call check_last_Q_A(l_switch,G2(:,:,:,76),Q(:,63),ZERO,G3tensor(:,40))
  call loop_QV_A(G1(:,:,:,38),wf(:,32),G1(:,:,:,40))
  call loop_Q_A(G1(:,:,:,40),Q(:,55),ZERO,G2(:,:,:,77))
  call loop_QV_A(G2(:,:,:,77),wf(:,-3),G2(:,:,:,78))
  call check_last_Q_A(l_switch,G2(:,:,:,78),Q(:,63),ZERO,G3tensor(:,41))
  call loop_QV_A(G1(:,:,:,38),wf(:,21),G1(:,:,:,41))
  call loop_Q_A(G1(:,:,:,41),Q(:,56),ZERO,G2(:,:,:,79))
  call loop_QV_A(G2(:,:,:,79),wf(:,4),G2(:,:,:,80))
  call check_last_Q_A(l_switch,G2(:,:,:,80),Q(:,63),ZERO,G3tensor(:,42))
  call loop_QV_A(G2(:,:,:,79),wf(:,9),G2(:,:,:,81))
  call check_last_Q_A(l_switch,G2(:,:,:,81),Q(:,63),ZERO,G3tensor(:,43))
  call loop_QV_A(G1(:,:,:,38),wf(:,407),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,55),ZERO,G2(:,:,:,82))
  call loop_QV_A(G2(:,:,:,82),wf(:,-3),G2(:,:,:,83))
  call check_last_Q_A(l_switch,G2(:,:,:,83),Q(:,63),ZERO,G3tensor(:,44))
  call loop_QV_A(G1(:,:,:,38),wf(:,-3),G1(:,:,:,43))
  call loop_Q_A(G1(:,:,:,43),Q(:,24),ZERO,G2(:,:,:,84))
  call loop_QV_A(G2(:,:,:,84),wf(:,-5),G2(:,:,:,85))
  call loop_Q_A(G2(:,:,:,85),Q(:,56),ZERO,G3(:,:,:,24))
  call loop_QV_A(G3(:,:,:,24),wf(:,4),G3(:,:,:,25))
  call check_last_Q_A(l_switch,G3(:,:,:,25),Q(:,63),ZERO,G4tensor(:,6))
  call loop_QV_A(G3(:,:,:,24),wf(:,9),G3(:,:,:,26))
  call check_last_Q_A(l_switch,G3(:,:,:,26),Q(:,63),ZERO,G4tensor(:,7))
  call loop_QV_A(G1(:,:,:,38),wf(:,418),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,55),ZERO,G2(:,:,:,86))
  call loop_QV_A(G2(:,:,:,86),wf(:,-3),G2(:,:,:,87))
  call check_last_Q_A(l_switch,G2(:,:,:,87),Q(:,63),ZERO,G3tensor(:,45))
  call loop_QV_A(G1(:,:,:,38),wf(:,64),G1(:,:,:,45))
  call loop_Q_A(G1(:,:,:,45),Q(:,55),ZERO,G2(:,:,:,88))
  call loop_QV_A(G2(:,:,:,88),wf(:,-3),G2(:,:,:,89))
  call check_last_Q_A(l_switch,G2(:,:,:,89),Q(:,63),ZERO,G3tensor(:,46))
  call loop_QV_A(G1(:,:,:,38),wf(:,425),G1(:,:,:,46))
  call loop_Q_A(G1(:,:,:,46),Q(:,55),ZERO,G2(:,:,:,90))
  call loop_QV_A(G2(:,:,:,90),wf(:,-3),G2(:,:,:,91))
  call check_last_Q_A(l_switch,G2(:,:,:,91),Q(:,63),ZERO,G3tensor(:,47))
  call loop_QV_A(G1(:,:,:,38),wf(:,428),G1(:,:,:,47))
  call loop_Q_A(G1(:,:,:,47),Q(:,55),ZERO,G2(:,:,:,92))
  call loop_QV_A(G2(:,:,:,92),wf(:,-3),G2(:,:,:,93))
  call check_last_Q_A(l_switch,G2(:,:,:,93),Q(:,63),ZERO,G3tensor(:,48))
  call loop_QV_A(G1(:,:,:,38),wf(:,525),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,55),ZERO,G2(:,:,:,94))
  call loop_QV_A(G2(:,:,:,94),wf(:,-3),G2(:,:,:,95))
  call check_last_Q_A(l_switch,G2(:,:,:,95),Q(:,63),ZERO,G3tensor(:,49))
  call loop_QV_A(G1(:,:,:,38),wf(:,542),G1(:,:,:,49))
  call loop_Q_A(G1(:,:,:,49),Q(:,55),ZERO,G2(:,:,:,96))
  call loop_QV_A(G2(:,:,:,96),wf(:,-3),G2(:,:,:,97))
  call check_last_Q_A(l_switch,G2(:,:,:,97),Q(:,63),ZERO,G3tensor(:,50))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,-4),G1(:,:,:,50))
  call loop_DV_C(G1(:,:,:,50),Q(:,16),wf(:,-5),G2(:,:,:,98))
  call check_last_DV_C(l_switch,G2(:,:,:,98),Q(:,48),wf(:,13),G3tensor(:,51))
  call check_last_DV_C(l_switch,G2(:,:,:,98),Q(:,48),wf(:,405),G3tensor(:,52))
  call check_last_DV_C(l_switch,G2(:,:,:,98),Q(:,48),wf(:,408),G3tensor(:,53))
  call check_last_DV_C(l_switch,G2(:,:,:,98),Q(:,48),wf(:,47),G3tensor(:,54))
  call check_last_DV_C(l_switch,G2(:,:,:,98),Q(:,48),wf(:,423),G3tensor(:,55))
  call check_last_DV_C(l_switch,G2(:,:,:,98),Q(:,48),wf(:,426),G3tensor(:,56))
  call check_last_DV_C(l_switch,G2(:,:,:,98),Q(:,48),wf(:,443),G3tensor(:,57))
  call check_last_DV_C(l_switch,G2(:,:,:,98),Q(:,48),wf(:,460),G3tensor(:,58))
  call loop_DV_C(G1(:,:,:,50),Q(:,16),wf(:,32),G2(:,:,:,99))
  call check_last_DV_C(l_switch,G2(:,:,:,99),Q(:,55),wf(:,-3),G3tensor(:,59))
  call loop_DV_C(G1(:,:,:,50),Q(:,16),wf(:,21),G2(:,:,:,100))
  call check_last_DV_C(l_switch,G2(:,:,:,100),Q(:,56),wf(:,4),G3tensor(:,60))
  call check_last_DV_C(l_switch,G2(:,:,:,100),Q(:,56),wf(:,9),G3tensor(:,61))
  call loop_DV_C(G1(:,:,:,50),Q(:,16),wf(:,407),G2(:,:,:,101))
  call check_last_DV_C(l_switch,G2(:,:,:,101),Q(:,55),wf(:,-3),G3tensor(:,62))
  call loop_DV_C(G1(:,:,:,50),Q(:,16),wf(:,-3),G2(:,:,:,102))
  call loop_DV_C(G2(:,:,:,102),Q(:,24),wf(:,-5),G3(:,:,:,27))
  call check_last_DV_C(l_switch,G3(:,:,:,27),Q(:,56),wf(:,4),G4tensor(:,8))
  call check_last_DV_C(l_switch,G3(:,:,:,27),Q(:,56),wf(:,9),G4tensor(:,9))
  call loop_DV_C(G1(:,:,:,50),Q(:,16),wf(:,418),G2(:,:,:,103))
  call check_last_DV_C(l_switch,G2(:,:,:,103),Q(:,55),wf(:,-3),G3tensor(:,63))
  call loop_DV_C(G1(:,:,:,50),Q(:,16),wf(:,64),G2(:,:,:,104))
  call check_last_DV_C(l_switch,G2(:,:,:,104),Q(:,55),wf(:,-3),G3tensor(:,64))
  call loop_DV_C(G1(:,:,:,50),Q(:,16),wf(:,425),G2(:,:,:,105))
  call check_last_DV_C(l_switch,G2(:,:,:,105),Q(:,55),wf(:,-3),G3tensor(:,65))
  call loop_DV_C(G1(:,:,:,50),Q(:,16),wf(:,428),G2(:,:,:,106))
  call check_last_DV_C(l_switch,G2(:,:,:,106),Q(:,55),wf(:,-3),G3tensor(:,66))
  call loop_DV_C(G1(:,:,:,50),Q(:,16),wf(:,525),G2(:,:,:,107))
  call check_last_DV_C(l_switch,G2(:,:,:,107),Q(:,55),wf(:,-3),G3tensor(:,67))
  call loop_DV_C(G1(:,:,:,50),Q(:,16),wf(:,542),G2(:,:,:,108))
  call check_last_DV_C(l_switch,G2(:,:,:,108),Q(:,55),wf(:,-3),G3tensor(:,68))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,-4),Q(:,16),G1(:,:,:,51))
  call loop_CV_D(G1(:,:,:,51),Q(:,16),wf(:,-5),Q(:,32),G2(:,:,:,109))
  call check_last_CV_D(l_switch,G2(:,:,:,109),Q(:,48),wf(:,13),Q(:,15),G3tensor(:,69))
  call check_last_CV_D(l_switch,G2(:,:,:,109),Q(:,48),wf(:,405),Q(:,15),G3tensor(:,70))
  call check_last_CV_D(l_switch,G2(:,:,:,109),Q(:,48),wf(:,408),Q(:,15),G3tensor(:,71))
  call check_last_CV_D(l_switch,G2(:,:,:,109),Q(:,48),wf(:,47),Q(:,15),G3tensor(:,72))
  call check_last_CV_D(l_switch,G2(:,:,:,109),Q(:,48),wf(:,423),Q(:,15),G3tensor(:,73))
  call check_last_CV_D(l_switch,G2(:,:,:,109),Q(:,48),wf(:,426),Q(:,15),G3tensor(:,74))
  call check_last_CV_D(l_switch,G2(:,:,:,109),Q(:,48),wf(:,443),Q(:,15),G3tensor(:,75))
  call check_last_CV_D(l_switch,G2(:,:,:,109),Q(:,48),wf(:,460),Q(:,15),G3tensor(:,76))
  call loop_CV_D(G1(:,:,:,51),Q(:,16),wf(:,32),Q(:,39),G2(:,:,:,110))
  call check_last_CV_D(l_switch,G2(:,:,:,110),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,77))
  call loop_CV_D(G1(:,:,:,51),Q(:,16),wf(:,21),Q(:,40),G2(:,:,:,111))
  call check_last_CV_D(l_switch,G2(:,:,:,111),Q(:,56),wf(:,4),Q(:,7),G3tensor(:,78))
  call check_last_CV_D(l_switch,G2(:,:,:,111),Q(:,56),wf(:,9),Q(:,7),G3tensor(:,79))
  call loop_CV_D(G1(:,:,:,51),Q(:,16),wf(:,407),Q(:,39),G2(:,:,:,112))
  call check_last_CV_D(l_switch,G2(:,:,:,112),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,80))
  call loop_CV_D(G1(:,:,:,51),Q(:,16),wf(:,-3),Q(:,8),G2(:,:,:,113))
  call loop_CV_D(G2(:,:,:,113),Q(:,24),wf(:,-5),Q(:,32),G3(:,:,:,28))
  call check_last_CV_D(l_switch,G3(:,:,:,28),Q(:,56),wf(:,4),Q(:,7),G4tensor(:,10))
  call check_last_CV_D(l_switch,G3(:,:,:,28),Q(:,56),wf(:,9),Q(:,7),G4tensor(:,11))
  call loop_CV_D(G1(:,:,:,51),Q(:,16),wf(:,418),Q(:,39),G2(:,:,:,114))
  call check_last_CV_D(l_switch,G2(:,:,:,114),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,81))
  call loop_CV_D(G1(:,:,:,51),Q(:,16),wf(:,64),Q(:,39),G2(:,:,:,115))
  call check_last_CV_D(l_switch,G2(:,:,:,115),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,82))
  call loop_CV_D(G1(:,:,:,51),Q(:,16),wf(:,425),Q(:,39),G2(:,:,:,116))
  call check_last_CV_D(l_switch,G2(:,:,:,116),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,83))
  call loop_CV_D(G1(:,:,:,51),Q(:,16),wf(:,428),Q(:,39),G2(:,:,:,117))
  call check_last_CV_D(l_switch,G2(:,:,:,117),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,84))
  call loop_CV_D(G1(:,:,:,51),Q(:,16),wf(:,525),Q(:,39),G2(:,:,:,118))
  call check_last_CV_D(l_switch,G2(:,:,:,118),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,85))
  call loop_CV_D(G1(:,:,:,51),Q(:,16),wf(:,542),Q(:,39),G2(:,:,:,119))
  call check_last_CV_D(l_switch,G2(:,:,:,119),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,86))
  call loop_VA_Q(G0(:,:,:,1),wf(:,22),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,18),MB,G1(:,:,:,52))
  call loop_AV_Q(G1(:,:,:,52),wf(:,21),G1(:,:,:,53))
  call loop_A_Q(G1(:,:,:,53),Q(:,58),MB,G2(:,:,:,120))
  call check_last_AQ_V(l_switch,G2(:,:,:,120),wf(:,3),G2tensor(:,24))
  call loop_AS_Q(G2(:,:,:,120),wf(:,-2),G2(:,:,:,121),gH)
  call loop_A_Q(G2(:,:,:,121),Q(:,62),MB,G3(:,:,:,29))
  call check_last_AQ_V(l_switch,G3(:,:,:,29),wf(:,0),G3tensor(:,87))
  call loop_AV_Q(G1(:,:,:,52),wf(:,-5),G1(:,:,:,54))
  call loop_A_Q(G1(:,:,:,54),Q(:,50),MB,G2(:,:,:,122))
  call check_last_AQ_V(l_switch,G2(:,:,:,122),wf(:,26),G2tensor(:,25))
  call loop_AV_Q(G2(:,:,:,122),wf(:,-3),G2(:,:,:,123))
  call loop_A_Q(G2(:,:,:,123),Q(:,58),MB,G3(:,:,:,30))
  call check_last_AQ_V(l_switch,G3(:,:,:,30),wf(:,3),G3tensor(:,88))
  call loop_AS_Q(G3(:,:,:,30),wf(:,-2),G3(:,:,:,31),gH)
  call loop_A_Q(G3(:,:,:,31),Q(:,62),MB,G4(:,:,:,4))
  call check_last_AQ_V(l_switch,G4(:,:,:,4),wf(:,0),G4tensor(:,12))
  call check_last_AQ_V(l_switch,G2(:,:,:,122),wf(:,75),G2tensor(:,26))
  call loop_AS_Q(G2(:,:,:,122),wf(:,-2),G2(:,:,:,124),gH)
  call loop_A_Q(G2(:,:,:,124),Q(:,54),MB,G3(:,:,:,32))
  call check_last_AQ_V(l_switch,G3(:,:,:,32),wf(:,46),G3tensor(:,89))
  call loop_AV_Q(G3(:,:,:,32),wf(:,-3),G3(:,:,:,33))
  call loop_A_Q(G3(:,:,:,33),Q(:,62),MB,G4(:,:,:,5))
  call check_last_AQ_V(l_switch,G4(:,:,:,5),wf(:,0),G4tensor(:,13))
  call loop_AQ_V(G1(:,:,:,52),wf(:,130),G1(:,:,:,55))
  call check_last_UV_W(l_switch,G1(:,:,:,55),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,27))
  call loop_AV_Q(G1(:,:,:,52),wf(:,-3),G1(:,:,:,56))
  call loop_A_Q(G1(:,:,:,56),Q(:,26),MB,G2(:,:,:,125))
  call loop_AV_Q(G2(:,:,:,125),wf(:,-5),G2(:,:,:,126))
  call loop_A_Q(G2(:,:,:,126),Q(:,58),MB,G3(:,:,:,34))
  call check_last_AQ_V(l_switch,G3(:,:,:,34),wf(:,3),G3tensor(:,90))
  call loop_AS_Q(G3(:,:,:,34),wf(:,-2),G3(:,:,:,35),gH)
  call loop_A_Q(G3(:,:,:,35),Q(:,62),MB,G4(:,:,:,6))
  call check_last_AQ_V(l_switch,G4(:,:,:,6),wf(:,0),G4tensor(:,14))
  call loop_AS_Q(G2(:,:,:,125),wf(:,-2),G2(:,:,:,127),gH)
  call loop_A_Q(G2(:,:,:,127),Q(:,30),MB,G3(:,:,:,36))
  call loop_AV_Q(G3(:,:,:,36),wf(:,-5),G3(:,:,:,37))
  call loop_A_Q(G3(:,:,:,37),Q(:,62),MB,G4(:,:,:,7))
  call check_last_AQ_V(l_switch,G4(:,:,:,7),wf(:,0),G4tensor(:,15))
  call loop_AS_Q(G1(:,:,:,52),wf(:,-2),G1(:,:,:,57),gH)
  call loop_A_Q(G1(:,:,:,57),Q(:,22),MB,G2(:,:,:,128))
  call loop_AV_Q(G2(:,:,:,128),wf(:,-5),G2(:,:,:,129))
  call loop_A_Q(G2(:,:,:,129),Q(:,54),MB,G3(:,:,:,38))
  call check_last_AQ_V(l_switch,G3(:,:,:,38),wf(:,46),G3tensor(:,91))
  call loop_AV_Q(G3(:,:,:,38),wf(:,-3),G3(:,:,:,39))
  call loop_A_Q(G3(:,:,:,39),Q(:,62),MB,G4(:,:,:,8))
  call check_last_AQ_V(l_switch,G4(:,:,:,8),wf(:,0),G4tensor(:,16))
  call loop_AQ_V(G2(:,:,:,128),wf(:,63),G2(:,:,:,130))
  call check_last_UV_W(l_switch,G2(:,:,:,130),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,92))
  call loop_AV_Q(G2(:,:,:,128),wf(:,21),G2(:,:,:,131))
  call loop_A_Q(G2(:,:,:,131),Q(:,62),MB,G3(:,:,:,40))
  call check_last_AQ_V(l_switch,G3(:,:,:,40),wf(:,0),G3tensor(:,93))
  call loop_AV_Q(G2(:,:,:,128),wf(:,-3),G2(:,:,:,132))
  call loop_A_Q(G2(:,:,:,132),Q(:,30),MB,G3(:,:,:,41))
  call loop_AV_Q(G3(:,:,:,41),wf(:,-5),G3(:,:,:,42))
  call loop_A_Q(G3(:,:,:,42),Q(:,62),MB,G4(:,:,:,9))
  call check_last_AQ_V(l_switch,G4(:,:,:,9),wf(:,0),G4tensor(:,17))
  call loop_AQ_V(G1(:,:,:,52),wf(:,85),G1(:,:,:,58))
  call check_last_UV_W(l_switch,G1(:,:,:,58),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,28))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,21),Q(:,40),G1(:,:,:,59))
  call loop_VA_Q(G1(:,:,:,59),wf(:,22),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,58),MB,G2(:,:,:,133))
  call check_last_AQ_V(l_switch,G2(:,:,:,133),wf(:,3),G2tensor(:,29))
  call loop_AS_Q(G2(:,:,:,133),wf(:,-2),G2(:,:,:,134),gH)
  call loop_A_Q(G2(:,:,:,134),Q(:,62),MB,G3(:,:,:,43))
  call check_last_AQ_V(l_switch,G3(:,:,:,43),wf(:,0),G3tensor(:,94))
  call loop_VQ_A(G1(:,:,:,59),wf(:,16),G1(:,:,:,61))
  call loop_Q_A(G1(:,:,:,61),Q(:,61),MB,G2(:,:,:,135))
  call check_last_QA_V(l_switch,G2(:,:,:,135),wf(:,-1),G2tensor(:,30))
  call loop_VQ_A(G1(:,:,:,59),wf(:,3),G1(:,:,:,62))
  call loop_Q_A(G1(:,:,:,62),Q(:,45),MB,G2(:,:,:,136))
  call loop_QV_A(G2(:,:,:,136),wf(:,-4),G2(:,:,:,137))
  call loop_Q_A(G2(:,:,:,137),Q(:,61),MB,G3(:,:,:,44))
  call check_last_QA_V(l_switch,G3(:,:,:,44),wf(:,-1),G3tensor(:,95))
  call loop_UV_W(G1(:,:,:,59),Q(:,40),wf(:,-4),Q(:,16),G2(:,:,:,138))
  call loop_VQ_A(G2(:,:,:,138),wf(:,3),G2(:,:,:,139))
  call loop_Q_A(G2(:,:,:,139),Q(:,61),MB,G3(:,:,:,45))
  call check_last_QA_V(l_switch,G3(:,:,:,45),wf(:,-1),G3tensor(:,96))
  call loop_VA_Q(G2(:,:,:,138),wf(:,8),G2(:,:,:,140))
  call loop_A_Q(G2(:,:,:,140),Q(:,62),MB,G3(:,:,:,46))
  call check_last_AQ_V(l_switch,G3(:,:,:,46),wf(:,0),G3tensor(:,97))
  call loop_VA_Q(G2(:,:,:,138),wf(:,-1),G2(:,:,:,141))
  call loop_A_Q(G2(:,:,:,141),Q(:,58),MB,G3(:,:,:,47))
  call loop_AS_Q(G3(:,:,:,47),wf(:,-2),G3(:,:,:,48),gH)
  call loop_A_Q(G3(:,:,:,48),Q(:,62),MB,G4(:,:,:,10))
  call check_last_AQ_V(l_switch,G4(:,:,:,10),wf(:,0),G4tensor(:,18))
  call loop_VQ_A(G1(:,:,:,59),wf(:,55),G1(:,:,:,63))
  call loop_Q_A(G1(:,:,:,63),Q(:,57),MB,G2(:,:,:,142))
  call check_last_QA_V(l_switch,G2(:,:,:,142),wf(:,8),G2tensor(:,31))
  call loop_QS_A(G2(:,:,:,142),wf(:,-2),G2(:,:,:,143),gH)
  call loop_Q_A(G2(:,:,:,143),Q(:,61),MB,G3(:,:,:,49))
  call check_last_QA_V(l_switch,G3(:,:,:,49),wf(:,-1),G3tensor(:,98))
  call loop_VA_Q(G1(:,:,:,59),wf(:,53),G1(:,:,:,64))
  call loop_A_Q(G1(:,:,:,64),Q(:,62),MB,G2(:,:,:,144))
  call check_last_AQ_V(l_switch,G2(:,:,:,144),wf(:,0),G2tensor(:,32))
  call loop_VA_Q(G1(:,:,:,59),wf(:,8),G1(:,:,:,65))
  call loop_A_Q(G1(:,:,:,65),Q(:,46),MB,G2(:,:,:,145))
  call loop_AV_Q(G2(:,:,:,145),wf(:,-4),G2(:,:,:,146))
  call loop_A_Q(G2(:,:,:,146),Q(:,62),MB,G3(:,:,:,50))
  call check_last_AQ_V(l_switch,G3(:,:,:,50),wf(:,0),G3tensor(:,99))
  call loop_VQ_A(G1(:,:,:,59),wf(:,81),G1(:,:,:,66))
  call loop_Q_A(G1(:,:,:,66),Q(:,61),MB,G2(:,:,:,147))
  call check_last_QA_V(l_switch,G2(:,:,:,147),wf(:,-1),G2tensor(:,33))
  call loop_VA_Q(G1(:,:,:,59),wf(:,77),G1(:,:,:,67))
  call loop_A_Q(G1(:,:,:,67),Q(:,62),MB,G2(:,:,:,148))
  call check_last_AQ_V(l_switch,G2(:,:,:,148),wf(:,0),G2tensor(:,34))
  call loop_VA_Q(G1(:,:,:,59),wf(:,-1),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,42),MB,G2(:,:,:,149))
  call loop_AV_Q(G2(:,:,:,149),wf(:,-4),G2(:,:,:,150))
  call loop_A_Q(G2(:,:,:,150),Q(:,58),MB,G3(:,:,:,51))
  call loop_AS_Q(G3(:,:,:,51),wf(:,-2),G3(:,:,:,52),gH)
  call loop_A_Q(G3(:,:,:,52),Q(:,62),MB,G4(:,:,:,11))
  call check_last_AQ_V(l_switch,G4(:,:,:,11),wf(:,0),G4tensor(:,19))
  call loop_AS_Q(G2(:,:,:,149),wf(:,-2),G2(:,:,:,151),gH)
  call loop_A_Q(G2(:,:,:,151),Q(:,46),MB,G3(:,:,:,53))
  call loop_AV_Q(G3(:,:,:,53),wf(:,-4),G3(:,:,:,54))
  call loop_A_Q(G3(:,:,:,54),Q(:,62),MB,G4(:,:,:,12))
  call check_last_AQ_V(l_switch,G4(:,:,:,12),wf(:,0),G4tensor(:,20))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,59),wf(:,-4),wf(:,4),G1tensor(:,12))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,59),wf(:,4),wf(:,-4),G1tensor(:,13))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,59),wf(:,-4),wf(:,4),G1tensor(:,14))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,59),wf(:,-4),wf(:,9),G1tensor(:,15))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,59),wf(:,9),wf(:,-4),G1tensor(:,16))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,59),wf(:,-4),wf(:,9),G1tensor(:,17))
  call check_last_UV_W(l_switch,G1(:,:,:,59),Q(:,40),wf(:,23),Q(:,23),G2tensor(:,35))
  call check_last_UV_W(l_switch,G1(:,:,:,59),Q(:,40),wf(:,406),Q(:,23),G2tensor(:,36))
  call check_last_UV_W(l_switch,G1(:,:,:,59),Q(:,40),wf(:,413),Q(:,23),G2tensor(:,37))
  call check_last_UV_W(l_switch,G1(:,:,:,59),Q(:,40),wf(:,56),Q(:,23),G2tensor(:,38))
  call check_last_UV_W(l_switch,G1(:,:,:,59),Q(:,40),wf(:,424),Q(:,23),G2tensor(:,39))
  call check_last_UV_W(l_switch,G1(:,:,:,59),Q(:,40),wf(:,427),Q(:,23),G2tensor(:,40))
  call check_last_UV_W(l_switch,G1(:,:,:,59),Q(:,40),wf(:,477),Q(:,23),G2tensor(:,41))
  call check_last_UV_W(l_switch,G1(:,:,:,59),Q(:,40),wf(:,494),Q(:,23),G2tensor(:,42))
  call loop_VA_Q(G0(:,:,:,1),wf(:,28),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,26),MB,G1(:,:,:,69))
  call loop_AV_Q(G1(:,:,:,69),wf(:,-5),G1(:,:,:,70))
  call loop_A_Q(G1(:,:,:,70),Q(:,58),MB,G2(:,:,:,152))
  call check_last_AQ_V(l_switch,G2(:,:,:,152),wf(:,3),G2tensor(:,43))
  call loop_AS_Q(G2(:,:,:,152),wf(:,-2),G2(:,:,:,153),gH)
  call loop_A_Q(G2(:,:,:,153),Q(:,62),MB,G3(:,:,:,55))
  call check_last_AQ_V(l_switch,G3(:,:,:,55),wf(:,0),G3tensor(:,100))
  call loop_AS_Q(G1(:,:,:,69),wf(:,-2),G1(:,:,:,71),gH)
  call loop_A_Q(G1(:,:,:,71),Q(:,30),MB,G2(:,:,:,154))
  call loop_AV_Q(G2(:,:,:,154),wf(:,-5),G2(:,:,:,155))
  call loop_A_Q(G2(:,:,:,155),Q(:,62),MB,G3(:,:,:,56))
  call check_last_AQ_V(l_switch,G3(:,:,:,56),wf(:,0),G3tensor(:,101))
  call loop_VA_Q(G0(:,:,:,1),wf(:,155),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,50),MB,G1(:,:,:,72))
  call loop_AV_Q(G1(:,:,:,72),wf(:,-3),G1(:,:,:,73))
  call loop_A_Q(G1(:,:,:,73),Q(:,58),MB,G2(:,:,:,156))
  call check_last_AQ_V(l_switch,G2(:,:,:,156),wf(:,3),G2tensor(:,44))
  call loop_AS_Q(G2(:,:,:,156),wf(:,-2),G2(:,:,:,157),gH)
  call loop_A_Q(G2(:,:,:,157),Q(:,62),MB,G3(:,:,:,57))
  call check_last_AQ_V(l_switch,G3(:,:,:,57),wf(:,0),G3tensor(:,102))
  call loop_AS_Q(G1(:,:,:,72),wf(:,-2),G1(:,:,:,74),gH)
  call loop_A_Q(G1(:,:,:,74),Q(:,54),MB,G2(:,:,:,158))
  call check_last_AQ_V(l_switch,G2(:,:,:,158),wf(:,46),G2tensor(:,45))
  call loop_AV_Q(G2(:,:,:,158),wf(:,-3),G2(:,:,:,159))
  call loop_A_Q(G2(:,:,:,159),Q(:,62),MB,G3(:,:,:,58))
  call check_last_AQ_V(l_switch,G3(:,:,:,58),wf(:,0),G3tensor(:,103))
  call check_last_AQ_V(l_switch,G1(:,:,:,72),wf(:,26),G1tensor(:,18))
  call check_last_AQ_V(l_switch,G1(:,:,:,72),wf(:,75),G1tensor(:,19))
  call loop_QV_A(G0(:,:,:,1),wf(:,23),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,23),ZERO,G1(:,:,:,75))
  call loop_QV_A(G1(:,:,:,75),wf(:,-5),G1(:,:,:,76))
  call loop_Q_A(G1(:,:,:,76),Q(:,55),ZERO,G2(:,:,:,160))
  call loop_QV_A(G2(:,:,:,160),wf(:,-3),G2(:,:,:,161))
  call check_last_Q_A(l_switch,G2(:,:,:,161),Q(:,63),ZERO,G3tensor(:,104))
  call loop_QV_A(G0(:,:,:,1),wf(:,23),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,23),MT,G1(:,:,:,77))
  call loop_QV_A(G1(:,:,:,77),wf(:,-5),G1(:,:,:,78))
  call loop_Q_A(G1(:,:,:,78),Q(:,55),MT,G2(:,:,:,162))
  call loop_QV_A(G2(:,:,:,162),wf(:,-3),G2(:,:,:,163))
  call check_last_Q_A(l_switch,G2(:,:,:,163),Q(:,63),MT,G3tensor(:,105))
  call loop_AV_Q(G0(:,:,:,1),wf(:,23),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,23),ZERO,G1(:,:,:,79))
  call loop_AV_Q(G1(:,:,:,79),wf(:,-5),G1(:,:,:,80))
  call loop_A_Q(G1(:,:,:,80),Q(:,55),ZERO,G2(:,:,:,164))
  call loop_AV_Q(G2(:,:,:,164),wf(:,-3),G2(:,:,:,165))
  call check_last_A_Q(l_switch,G2(:,:,:,165),Q(:,63),ZERO,G3tensor(:,106))
  call loop_AV_Q(G0(:,:,:,1),wf(:,23),G0(:,:,:,14))
  call loop_A_Q(G0(:,:,:,14),Q(:,23),MT,G1(:,:,:,81))
  call loop_AV_Q(G1(:,:,:,81),wf(:,-5),G1(:,:,:,82))
  call loop_A_Q(G1(:,:,:,82),Q(:,55),MT,G2(:,:,:,166))
  call loop_AV_Q(G2(:,:,:,166),wf(:,-3),G2(:,:,:,167))
  call check_last_A_Q(l_switch,G2(:,:,:,167),Q(:,63),MT,G3tensor(:,107))
  call loop_QV_A(G0(:,:,:,1),wf(:,23),G0(:,:,:,15))
  call loop_Q_A(G0(:,:,:,15),Q(:,23),MB,G1(:,:,:,83))
  call loop_QV_A(G1(:,:,:,83),wf(:,-5),G1(:,:,:,84))
  call loop_Q_A(G1(:,:,:,84),Q(:,55),MB,G2(:,:,:,168))
  call loop_QV_A(G2(:,:,:,168),wf(:,-3),G2(:,:,:,169))
  call check_last_Q_A(l_switch,G2(:,:,:,169),Q(:,63),MB,G3tensor(:,108))
  call loop_AV_Q(G0(:,:,:,1),wf(:,23),G0(:,:,:,16))
  call loop_A_Q(G0(:,:,:,16),Q(:,23),MB,G1(:,:,:,85))
  call loop_AV_Q(G1(:,:,:,85),wf(:,-5),G1(:,:,:,86))
  call loop_A_Q(G1(:,:,:,86),Q(:,55),MB,G2(:,:,:,170))
  call loop_AV_Q(G2(:,:,:,170),wf(:,-3),G2(:,:,:,171))
  call check_last_A_Q(l_switch,G2(:,:,:,171),Q(:,63),MB,G3tensor(:,109))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,23),Q(:,23),G1(:,:,:,87))
  call loop_CV_D(G1(:,:,:,87),Q(:,23),wf(:,-5),Q(:,32),G2(:,:,:,172))
  call check_last_CV_D(l_switch,G2(:,:,:,172),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,110))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,23),G1(:,:,:,88))
  call loop_DV_C(G1(:,:,:,88),Q(:,23),wf(:,-5),G2(:,:,:,173))
  call check_last_DV_C(l_switch,G2(:,:,:,173),Q(:,55),wf(:,-3),G3tensor(:,111))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,23),Q(:,23),G1(:,:,:,89))
  call loop_UV_W(G1(:,:,:,89),Q(:,23),wf(:,-5),Q(:,32),G2(:,:,:,174))
  call check_last_UV_W(l_switch,G2(:,:,:,174),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,112))
  call loop_VA_Q(G0(:,:,:,1),wf(:,31),G0(:,:,:,17))
  call loop_A_Q(G0(:,:,:,17),Q(:,34),MB,G1(:,:,:,90))
  call loop_AV_Q(G1(:,:,:,90),wf(:,30),G1(:,:,:,91))
  call loop_A_Q(G1(:,:,:,91),Q(:,58),MB,G2(:,:,:,175))
  call check_last_AQ_V(l_switch,G2(:,:,:,175),wf(:,3),G2tensor(:,46))
  call loop_AS_Q(G2(:,:,:,175),wf(:,-2),G2(:,:,:,176),gH)
  call loop_A_Q(G2(:,:,:,176),Q(:,62),MB,G3(:,:,:,59))
  call check_last_AQ_V(l_switch,G3(:,:,:,59),wf(:,0),G3tensor(:,113))
  call loop_AV_Q(G1(:,:,:,90),wf(:,-4),G1(:,:,:,92))
  call loop_A_Q(G1(:,:,:,92),Q(:,50),MB,G2(:,:,:,177))
  call check_last_AQ_V(l_switch,G2(:,:,:,177),wf(:,26),G2tensor(:,47))
  call loop_AV_Q(G2(:,:,:,177),wf(:,-3),G2(:,:,:,178))
  call loop_A_Q(G2(:,:,:,178),Q(:,58),MB,G3(:,:,:,60))
  call check_last_AQ_V(l_switch,G3(:,:,:,60),wf(:,3),G3tensor(:,114))
  call loop_AS_Q(G3(:,:,:,60),wf(:,-2),G3(:,:,:,61),gH)
  call loop_A_Q(G3(:,:,:,61),Q(:,62),MB,G4(:,:,:,13))
  call check_last_AQ_V(l_switch,G4(:,:,:,13),wf(:,0),G4tensor(:,21))
  call check_last_AQ_V(l_switch,G2(:,:,:,177),wf(:,75),G2tensor(:,48))
  call loop_AS_Q(G2(:,:,:,177),wf(:,-2),G2(:,:,:,179),gH)
  call loop_A_Q(G2(:,:,:,179),Q(:,54),MB,G3(:,:,:,62))
  call check_last_AQ_V(l_switch,G3(:,:,:,62),wf(:,46),G3tensor(:,115))
  call loop_AV_Q(G3(:,:,:,62),wf(:,-3),G3(:,:,:,63))
  call loop_A_Q(G3(:,:,:,63),Q(:,62),MB,G4(:,:,:,14))
  call check_last_AQ_V(l_switch,G4(:,:,:,14),wf(:,0),G4tensor(:,22))
  call loop_AV_Q(G1(:,:,:,90),wf(:,-3),G1(:,:,:,93))
  call loop_A_Q(G1(:,:,:,93),Q(:,42),MB,G2(:,:,:,180))
  call check_last_AQ_V(l_switch,G2(:,:,:,180),wf(:,16),G2tensor(:,49))
  call loop_AV_Q(G2(:,:,:,180),wf(:,-4),G2(:,:,:,181))
  call loop_A_Q(G2(:,:,:,181),Q(:,58),MB,G3(:,:,:,64))
  call check_last_AQ_V(l_switch,G3(:,:,:,64),wf(:,3),G3tensor(:,116))
  call loop_AS_Q(G3(:,:,:,64),wf(:,-2),G3(:,:,:,65),gH)
  call loop_A_Q(G3(:,:,:,65),Q(:,62),MB,G4(:,:,:,15))
  call check_last_AQ_V(l_switch,G4(:,:,:,15),wf(:,0),G4tensor(:,23))
  call check_last_AQ_V(l_switch,G2(:,:,:,180),wf(:,81),G2tensor(:,50))
  call loop_AS_Q(G2(:,:,:,180),wf(:,-2),G2(:,:,:,182),gH)
  call loop_A_Q(G2(:,:,:,182),Q(:,46),MB,G3(:,:,:,66))
  call check_last_AQ_V(l_switch,G3(:,:,:,66),wf(:,55),G3tensor(:,117))
  call loop_AV_Q(G3(:,:,:,66),wf(:,-4),G3(:,:,:,67))
  call loop_A_Q(G3(:,:,:,67),Q(:,62),MB,G4(:,:,:,16))
  call check_last_AQ_V(l_switch,G4(:,:,:,16),wf(:,0),G4tensor(:,24))
  call loop_AS_Q(G1(:,:,:,90),wf(:,-2),G1(:,:,:,94),gH)
  call loop_A_Q(G1(:,:,:,94),Q(:,38),MB,G2(:,:,:,183))
  call check_last_AQ_V(l_switch,G2(:,:,:,183),wf(:,50),G2tensor(:,51))
  call loop_AV_Q(G2(:,:,:,183),wf(:,-4),G2(:,:,:,184))
  call loop_A_Q(G2(:,:,:,184),Q(:,54),MB,G3(:,:,:,68))
  call check_last_AQ_V(l_switch,G3(:,:,:,68),wf(:,46),G3tensor(:,118))
  call loop_AV_Q(G3(:,:,:,68),wf(:,-3),G3(:,:,:,69))
  call loop_A_Q(G3(:,:,:,69),Q(:,62),MB,G4(:,:,:,17))
  call check_last_AQ_V(l_switch,G4(:,:,:,17),wf(:,0),G4tensor(:,25))
  call check_last_AQ_V(l_switch,G2(:,:,:,183),wf(:,58),G2tensor(:,52))
  call loop_AV_Q(G2(:,:,:,183),wf(:,-3),G2(:,:,:,185))
  call loop_A_Q(G2(:,:,:,185),Q(:,46),MB,G3(:,:,:,70))
  call check_last_AQ_V(l_switch,G3(:,:,:,70),wf(:,55),G3tensor(:,119))
  call loop_AV_Q(G3(:,:,:,70),wf(:,-4),G3(:,:,:,71))
  call loop_A_Q(G3(:,:,:,71),Q(:,62),MB,G4(:,:,:,18))
  call check_last_AQ_V(l_switch,G4(:,:,:,18),wf(:,0),G4tensor(:,26))
  call check_last_AQ_V(l_switch,G2(:,:,:,183),wf(:,66),G2tensor(:,53))
  call loop_AV_Q(G2(:,:,:,183),wf(:,30),G2(:,:,:,186))
  call loop_A_Q(G2(:,:,:,186),Q(:,62),MB,G3(:,:,:,72))
  call check_last_AQ_V(l_switch,G3(:,:,:,72),wf(:,0),G3tensor(:,120))
  call check_last_AQ_V(l_switch,G1(:,:,:,90),wf(:,326),G1tensor(:,20))
  call check_last_AQ_V(l_switch,G1(:,:,:,90),wf(:,410),G1tensor(:,21))
  call check_last_AQ_V(l_switch,G1(:,:,:,90),wf(:,415),G1tensor(:,22))
  call check_last_AQ_V(l_switch,G1(:,:,:,90),wf(:,445),G1tensor(:,23))
  call check_last_AQ_V(l_switch,G1(:,:,:,90),wf(:,450),G1tensor(:,24))
  call check_last_AQ_V(l_switch,G1(:,:,:,90),wf(:,479),G1tensor(:,25))
  call check_last_AQ_V(l_switch,G1(:,:,:,90),wf(:,484),G1tensor(:,26))
  call check_last_AQ_V(l_switch,G1(:,:,:,90),wf(:,512),G1tensor(:,27))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,30),Q(:,24),G1(:,:,:,95))
  call loop_VA_Q(G1(:,:,:,95),wf(:,31),G1(:,:,:,96))
  call loop_A_Q(G1(:,:,:,96),Q(:,58),MB,G2(:,:,:,187))
  call check_last_AQ_V(l_switch,G2(:,:,:,187),wf(:,3),G2tensor(:,54))
  call loop_AS_Q(G2(:,:,:,187),wf(:,-2),G2(:,:,:,188),gH)
  call loop_A_Q(G2(:,:,:,188),Q(:,62),MB,G3(:,:,:,73))
  call check_last_AQ_V(l_switch,G3(:,:,:,73),wf(:,0),G3tensor(:,121))
  call loop_UV_W(G1(:,:,:,95),Q(:,24),wf(:,-5),Q(:,32),G2(:,:,:,189))
  call check_last_UV_W(l_switch,G2(:,:,:,189),Q(:,56),wf(:,4),Q(:,7),G3tensor(:,122))
  call loop_VQ_A(G2(:,:,:,189),wf(:,3),G2(:,:,:,190))
  call loop_Q_A(G2(:,:,:,190),Q(:,61),MB,G3(:,:,:,74))
  call check_last_QA_V(l_switch,G3(:,:,:,74),wf(:,-1),G3tensor(:,123))
  call check_last_UV_W(l_switch,G2(:,:,:,189),Q(:,56),wf(:,9),Q(:,7),G3tensor(:,124))
  call loop_VA_Q(G2(:,:,:,189),wf(:,8),G2(:,:,:,191))
  call loop_A_Q(G2(:,:,:,191),Q(:,62),MB,G3(:,:,:,75))
  call check_last_AQ_V(l_switch,G3(:,:,:,75),wf(:,0),G3tensor(:,125))
  call loop_VA_Q(G2(:,:,:,189),wf(:,-1),G2(:,:,:,192))
  call loop_A_Q(G2(:,:,:,192),Q(:,58),MB,G3(:,:,:,76))
  call loop_AS_Q(G3(:,:,:,76),wf(:,-2),G3(:,:,:,77),gH)
  call loop_A_Q(G3(:,:,:,77),Q(:,62),MB,G4(:,:,:,19))
  call check_last_AQ_V(l_switch,G4(:,:,:,19),wf(:,0),G4tensor(:,27))
  call loop_VQ_A(G1(:,:,:,95),wf(:,130),G1(:,:,:,97))
  call loop_Q_A(G1(:,:,:,97),Q(:,61),MB,G2(:,:,:,193))
  call check_last_QA_V(l_switch,G2(:,:,:,193),wf(:,-1),G2tensor(:,55))
  call loop_VQ_A(G1(:,:,:,95),wf(:,3),G1(:,:,:,98))
  call loop_Q_A(G1(:,:,:,98),Q(:,29),MB,G2(:,:,:,194))
  call loop_QV_A(G2(:,:,:,194),wf(:,-5),G2(:,:,:,195))
  call loop_Q_A(G2(:,:,:,195),Q(:,61),MB,G3(:,:,:,78))
  call check_last_QA_V(l_switch,G3(:,:,:,78),wf(:,-1),G3tensor(:,126))
  call loop_VQ_A(G1(:,:,:,95),wf(:,63),G1(:,:,:,99))
  call loop_Q_A(G1(:,:,:,99),Q(:,57),MB,G2(:,:,:,196))
  call check_last_QA_V(l_switch,G2(:,:,:,196),wf(:,8),G2tensor(:,56))
  call loop_QS_A(G2(:,:,:,196),wf(:,-2),G2(:,:,:,197),gH)
  call loop_Q_A(G2(:,:,:,197),Q(:,61),MB,G3(:,:,:,79))
  call check_last_QA_V(l_switch,G3(:,:,:,79),wf(:,-1),G3tensor(:,127))
  call loop_VA_Q(G1(:,:,:,95),wf(:,173),G1(:,:,:,100))
  call loop_A_Q(G1(:,:,:,100),Q(:,62),MB,G2(:,:,:,198))
  call check_last_AQ_V(l_switch,G2(:,:,:,198),wf(:,0),G2tensor(:,57))
  call loop_VA_Q(G1(:,:,:,95),wf(:,8),G1(:,:,:,101))
  call loop_A_Q(G1(:,:,:,101),Q(:,30),MB,G2(:,:,:,199))
  call loop_AV_Q(G2(:,:,:,199),wf(:,-5),G2(:,:,:,200))
  call loop_A_Q(G2(:,:,:,200),Q(:,62),MB,G3(:,:,:,80))
  call check_last_AQ_V(l_switch,G3(:,:,:,80),wf(:,0),G3tensor(:,128))
  call loop_VQ_A(G1(:,:,:,95),wf(:,85),G1(:,:,:,102))
  call loop_Q_A(G1(:,:,:,102),Q(:,61),MB,G2(:,:,:,201))
  call check_last_QA_V(l_switch,G2(:,:,:,201),wf(:,-1),G2tensor(:,58))
  call loop_VA_Q(G1(:,:,:,95),wf(:,79),G1(:,:,:,103))
  call loop_A_Q(G1(:,:,:,103),Q(:,62),MB,G2(:,:,:,202))
  call check_last_AQ_V(l_switch,G2(:,:,:,202),wf(:,0),G2tensor(:,59))
  call loop_VA_Q(G1(:,:,:,95),wf(:,-1),G1(:,:,:,104))
  call loop_A_Q(G1(:,:,:,104),Q(:,26),MB,G2(:,:,:,203))
  call loop_AV_Q(G2(:,:,:,203),wf(:,-5),G2(:,:,:,204))
  call loop_A_Q(G2(:,:,:,204),Q(:,58),MB,G3(:,:,:,81))
  call loop_AS_Q(G3(:,:,:,81),wf(:,-2),G3(:,:,:,82),gH)
  call loop_A_Q(G3(:,:,:,82),Q(:,62),MB,G4(:,:,:,20))
  call check_last_AQ_V(l_switch,G4(:,:,:,20),wf(:,0),G4tensor(:,28))
  call loop_AS_Q(G2(:,:,:,203),wf(:,-2),G2(:,:,:,205),gH)
  call loop_A_Q(G2(:,:,:,205),Q(:,30),MB,G3(:,:,:,83))
  call loop_AV_Q(G3(:,:,:,83),wf(:,-5),G3(:,:,:,84))
  call loop_A_Q(G3(:,:,:,84),Q(:,62),MB,G4(:,:,:,21))
  call check_last_AQ_V(l_switch,G4(:,:,:,21),wf(:,0),G4tensor(:,29))
  call loop_AV_Q(G0(:,:,:,1),wf(:,30),G0(:,:,:,18))
  call loop_A_Q(G0(:,:,:,18),Q(:,24),ZERO,G1(:,:,:,105))
  call loop_AV_Q(G1(:,:,:,105),wf(:,-5),G1(:,:,:,106))
  call loop_A_Q(G1(:,:,:,106),Q(:,56),ZERO,G2(:,:,:,206))
  call loop_AV_Q(G2(:,:,:,206),wf(:,4),G2(:,:,:,207))
  call check_last_A_Q(l_switch,G2(:,:,:,207),Q(:,63),ZERO,G3tensor(:,129))
  call loop_AV_Q(G2(:,:,:,206),wf(:,9),G2(:,:,:,208))
  call check_last_A_Q(l_switch,G2(:,:,:,208),Q(:,63),ZERO,G3tensor(:,130))
  call loop_QV_A(G0(:,:,:,1),wf(:,30),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,24),ZERO,G1(:,:,:,107))
  call loop_QV_A(G1(:,:,:,107),wf(:,-5),G1(:,:,:,108))
  call loop_Q_A(G1(:,:,:,108),Q(:,56),ZERO,G2(:,:,:,209))
  call loop_QV_A(G2(:,:,:,209),wf(:,4),G2(:,:,:,210))
  call check_last_Q_A(l_switch,G2(:,:,:,210),Q(:,63),ZERO,G3tensor(:,131))
  call loop_QV_A(G2(:,:,:,209),wf(:,9),G2(:,:,:,211))
  call check_last_Q_A(l_switch,G2(:,:,:,211),Q(:,63),ZERO,G3tensor(:,132))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,30),G1(:,:,:,109))
  call loop_DV_C(G1(:,:,:,109),Q(:,24),wf(:,-5),G2(:,:,:,212))
  call check_last_DV_C(l_switch,G2(:,:,:,212),Q(:,56),wf(:,4),G3tensor(:,133))
  call check_last_DV_C(l_switch,G2(:,:,:,212),Q(:,56),wf(:,9),G3tensor(:,134))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,30),Q(:,24),G1(:,:,:,110))
  call loop_CV_D(G1(:,:,:,110),Q(:,24),wf(:,-5),Q(:,32),G2(:,:,:,213))
  call check_last_CV_D(l_switch,G2(:,:,:,213),Q(:,56),wf(:,4),Q(:,7),G3tensor(:,135))
  call check_last_CV_D(l_switch,G2(:,:,:,213),Q(:,56),wf(:,9),Q(:,7),G3tensor(:,136))
  call loop_VA_Q(G0(:,:,:,1),wf(:,35),G0(:,:,:,20))
  call loop_A_Q(G0(:,:,:,20),Q(:,26),MB,G1(:,:,:,111))
  call loop_AV_Q(G1(:,:,:,111),wf(:,-5),G1(:,:,:,112))
  call loop_A_Q(G1(:,:,:,112),Q(:,58),MB,G2(:,:,:,214))
  call check_last_AQ_V(l_switch,G2(:,:,:,214),wf(:,3),G2tensor(:,60))
  call loop_AS_Q(G2(:,:,:,214),wf(:,-2),G2(:,:,:,215),gH)
  call loop_A_Q(G2(:,:,:,215),Q(:,62),MB,G3(:,:,:,85))
  call check_last_AQ_V(l_switch,G3(:,:,:,85),wf(:,0),G3tensor(:,137))
  call loop_AS_Q(G1(:,:,:,111),wf(:,-2),G1(:,:,:,113),gH)
  call loop_A_Q(G1(:,:,:,113),Q(:,30),MB,G2(:,:,:,216))
  call loop_AV_Q(G2(:,:,:,216),wf(:,-5),G2(:,:,:,217))
  call loop_A_Q(G2(:,:,:,217),Q(:,62),MB,G3(:,:,:,86))
  call check_last_AQ_V(l_switch,G3(:,:,:,86),wf(:,0),G3tensor(:,138))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,33),Q(:,56),G1(:,:,:,114))
  call loop_VQ_A(G1(:,:,:,114),wf(:,3),G1(:,:,:,115))
  call loop_Q_A(G1(:,:,:,115),Q(:,61),MB,G2(:,:,:,218))
  call check_last_QA_V(l_switch,G2(:,:,:,218),wf(:,-1),G2tensor(:,61))
  call loop_VA_Q(G1(:,:,:,114),wf(:,8),G1(:,:,:,116))
  call loop_A_Q(G1(:,:,:,116),Q(:,62),MB,G2(:,:,:,219))
  call check_last_AQ_V(l_switch,G2(:,:,:,219),wf(:,0),G2tensor(:,62))
  call loop_VA_Q(G1(:,:,:,114),wf(:,-1),G1(:,:,:,117))
  call loop_A_Q(G1(:,:,:,117),Q(:,58),MB,G2(:,:,:,220))
  call loop_AS_Q(G2(:,:,:,220),wf(:,-2),G2(:,:,:,221),gH)
  call loop_A_Q(G2(:,:,:,221),Q(:,62),MB,G3(:,:,:,87))
  call check_last_AQ_V(l_switch,G3(:,:,:,87),wf(:,0),G3tensor(:,139))
  call check_last_UV_W(l_switch,G1(:,:,:,114),Q(:,56),wf(:,4),Q(:,7),G2tensor(:,63))
  call check_last_UV_W(l_switch,G1(:,:,:,114),Q(:,56),wf(:,9),Q(:,7),G2tensor(:,64))
  call loop_VQ_A(G0(:,:,:,1),wf(:,326),G0(:,:,:,21))
  call loop_Q_A(G0(:,:,:,21),Q(:,29),MB,G1(:,:,:,118))
  call loop_QV_A(G1(:,:,:,118),wf(:,-5),G1(:,:,:,119))
  call loop_Q_A(G1(:,:,:,119),Q(:,61),MB,G2(:,:,:,222))
  call check_last_QA_V(l_switch,G2(:,:,:,222),wf(:,-1),G2tensor(:,65))
  call loop_VA_Q(G0(:,:,:,1),wf(:,38),G0(:,:,:,22))
  call loop_A_Q(G0(:,:,:,22),Q(:,42),MB,G1(:,:,:,120))
  call loop_AV_Q(G1(:,:,:,120),wf(:,-4),G1(:,:,:,121))
  call loop_A_Q(G1(:,:,:,121),Q(:,58),MB,G2(:,:,:,223))
  call check_last_AQ_V(l_switch,G2(:,:,:,223),wf(:,3),G2tensor(:,66))
  call loop_AS_Q(G2(:,:,:,223),wf(:,-2),G2(:,:,:,224),gH)
  call loop_A_Q(G2(:,:,:,224),Q(:,62),MB,G3(:,:,:,88))
  call check_last_AQ_V(l_switch,G3(:,:,:,88),wf(:,0),G3tensor(:,140))
  call loop_AS_Q(G1(:,:,:,120),wf(:,-2),G1(:,:,:,122),gH)
  call loop_A_Q(G1(:,:,:,122),Q(:,46),MB,G2(:,:,:,225))
  call check_last_AQ_V(l_switch,G2(:,:,:,225),wf(:,55),G2tensor(:,67))
  call loop_AV_Q(G2(:,:,:,225),wf(:,-4),G2(:,:,:,226))
  call loop_A_Q(G2(:,:,:,226),Q(:,62),MB,G3(:,:,:,89))
  call check_last_AQ_V(l_switch,G3(:,:,:,89),wf(:,0),G3tensor(:,141))
  call check_last_AQ_V(l_switch,G1(:,:,:,120),wf(:,16),G1tensor(:,28))
  call check_last_AQ_V(l_switch,G1(:,:,:,120),wf(:,81),G1tensor(:,29))
  call loop_VA_Q(G0(:,:,:,1),wf(:,158),G0(:,:,:,23))
  call loop_A_Q(G0(:,:,:,23),Q(:,50),MB,G1(:,:,:,123))
  call loop_AV_Q(G1(:,:,:,123),wf(:,-3),G1(:,:,:,124))
  call loop_A_Q(G1(:,:,:,124),Q(:,58),MB,G2(:,:,:,227))
  call check_last_AQ_V(l_switch,G2(:,:,:,227),wf(:,3),G2tensor(:,68))
  call loop_AS_Q(G2(:,:,:,227),wf(:,-2),G2(:,:,:,228),gH)
  call loop_A_Q(G2(:,:,:,228),Q(:,62),MB,G3(:,:,:,90))
  call check_last_AQ_V(l_switch,G3(:,:,:,90),wf(:,0),G3tensor(:,142))
  call loop_AS_Q(G1(:,:,:,123),wf(:,-2),G1(:,:,:,125),gH)
  call loop_A_Q(G1(:,:,:,125),Q(:,54),MB,G2(:,:,:,229))
  call check_last_AQ_V(l_switch,G2(:,:,:,229),wf(:,46),G2tensor(:,69))
  call loop_AV_Q(G2(:,:,:,229),wf(:,-3),G2(:,:,:,230))
  call loop_A_Q(G2(:,:,:,230),Q(:,62),MB,G3(:,:,:,91))
  call check_last_AQ_V(l_switch,G3(:,:,:,91),wf(:,0),G3tensor(:,143))
  call check_last_AQ_V(l_switch,G1(:,:,:,123),wf(:,26),G1tensor(:,30))
  call check_last_AQ_V(l_switch,G1(:,:,:,123),wf(:,75),G1tensor(:,31))
  call loop_VA_Q(G0(:,:,:,1),wf(:,41),G0(:,:,:,24))
  call loop_A_Q(G0(:,:,:,24),Q(:,42),MB,G1(:,:,:,126))
  call loop_AV_Q(G1(:,:,:,126),wf(:,-4),G1(:,:,:,127))
  call loop_A_Q(G1(:,:,:,127),Q(:,58),MB,G2(:,:,:,231))
  call check_last_AQ_V(l_switch,G2(:,:,:,231),wf(:,3),G2tensor(:,70))
  call loop_AS_Q(G2(:,:,:,231),wf(:,-2),G2(:,:,:,232),gH)
  call loop_A_Q(G2(:,:,:,232),Q(:,62),MB,G3(:,:,:,92))
  call check_last_AQ_V(l_switch,G3(:,:,:,92),wf(:,0),G3tensor(:,144))
  call loop_AS_Q(G1(:,:,:,126),wf(:,-2),G1(:,:,:,128),gH)
  call loop_A_Q(G1(:,:,:,128),Q(:,46),MB,G2(:,:,:,233))
  call check_last_AQ_V(l_switch,G2(:,:,:,233),wf(:,55),G2tensor(:,71))
  call loop_AV_Q(G2(:,:,:,233),wf(:,-4),G2(:,:,:,234))
  call loop_A_Q(G2(:,:,:,234),Q(:,62),MB,G3(:,:,:,93))
  call check_last_AQ_V(l_switch,G3(:,:,:,93),wf(:,0),G3tensor(:,145))
  call check_last_AQ_V(l_switch,G1(:,:,:,126),wf(:,16),G1tensor(:,32))
  call check_last_AQ_V(l_switch,G1(:,:,:,126),wf(:,81),G1tensor(:,33))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,39),Q(:,56),G1(:,:,:,129))
  call loop_VQ_A(G1(:,:,:,129),wf(:,3),G1(:,:,:,130))
  call loop_Q_A(G1(:,:,:,130),Q(:,61),MB,G2(:,:,:,235))
  call check_last_QA_V(l_switch,G2(:,:,:,235),wf(:,-1),G2tensor(:,72))
  call loop_VA_Q(G1(:,:,:,129),wf(:,8),G1(:,:,:,131))
  call loop_A_Q(G1(:,:,:,131),Q(:,62),MB,G2(:,:,:,236))
  call check_last_AQ_V(l_switch,G2(:,:,:,236),wf(:,0),G2tensor(:,73))
  call loop_VA_Q(G1(:,:,:,129),wf(:,-1),G1(:,:,:,132))
  call loop_A_Q(G1(:,:,:,132),Q(:,58),MB,G2(:,:,:,237))
  call loop_AS_Q(G2(:,:,:,237),wf(:,-2),G2(:,:,:,238),gH)
  call loop_A_Q(G2(:,:,:,238),Q(:,62),MB,G3(:,:,:,94))
  call check_last_AQ_V(l_switch,G3(:,:,:,94),wf(:,0),G3tensor(:,146))
  call check_last_UV_W(l_switch,G1(:,:,:,129),Q(:,56),wf(:,4),Q(:,7),G2tensor(:,74))
  call check_last_UV_W(l_switch,G1(:,:,:,129),Q(:,56),wf(:,9),Q(:,7),G2tensor(:,75))
  call loop_VQ_A(G0(:,:,:,1),wf(:,314),G0(:,:,:,25))
  call loop_Q_A(G0(:,:,:,25),Q(:,45),MB,G1(:,:,:,133))
  call loop_QV_A(G1(:,:,:,133),wf(:,-4),G1(:,:,:,134))
  call loop_Q_A(G1(:,:,:,134),Q(:,61),MB,G2(:,:,:,239))
  call check_last_QA_V(l_switch,G2(:,:,:,239),wf(:,-1),G2tensor(:,76))
  call check_last_QA_V(l_switch,G1(:,:,:,133),wf(:,22),G1tensor(:,34))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,26))
  call loop_Q_A(G0(:,:,:,26),Q(:,8),ZERO,G1(:,:,:,135))
  call loop_QV_A(G1(:,:,:,135),wf(:,11),G1(:,:,:,136))
  call loop_Q_A(G1(:,:,:,136),Q(:,56),ZERO,G2(:,:,:,240))
  call loop_QV_A(G2(:,:,:,240),wf(:,4),G2(:,:,:,241))
  call check_last_Q_A(l_switch,G2(:,:,:,241),Q(:,63),ZERO,G3tensor(:,147))
  call loop_QV_A(G2(:,:,:,240),wf(:,9),G2(:,:,:,242))
  call check_last_Q_A(l_switch,G2(:,:,:,242),Q(:,63),ZERO,G3tensor(:,148))
  call loop_QV_A(G1(:,:,:,135),wf(:,-4),G1(:,:,:,137))
  call loop_Q_A(G1(:,:,:,137),Q(:,24),ZERO,G2(:,:,:,243))
  call loop_QV_A(G2(:,:,:,243),wf(:,-5),G2(:,:,:,244))
  call loop_Q_A(G2(:,:,:,244),Q(:,56),ZERO,G3(:,:,:,95))
  call loop_QV_A(G3(:,:,:,95),wf(:,4),G3(:,:,:,96))
  call check_last_Q_A(l_switch,G3(:,:,:,96),Q(:,63),ZERO,G4tensor(:,30))
  call loop_QV_A(G3(:,:,:,95),wf(:,9),G3(:,:,:,97))
  call check_last_Q_A(l_switch,G3(:,:,:,97),Q(:,63),ZERO,G4tensor(:,31))
  call loop_QV_A(G1(:,:,:,135),wf(:,-5),G1(:,:,:,138))
  call loop_Q_A(G1(:,:,:,138),Q(:,40),ZERO,G2(:,:,:,245))
  call loop_QV_A(G2(:,:,:,245),wf(:,-4),G2(:,:,:,246))
  call loop_Q_A(G2(:,:,:,246),Q(:,56),ZERO,G3(:,:,:,98))
  call loop_QV_A(G3(:,:,:,98),wf(:,4),G3(:,:,:,99))
  call check_last_Q_A(l_switch,G3(:,:,:,99),Q(:,63),ZERO,G4tensor(:,32))
  call loop_QV_A(G3(:,:,:,98),wf(:,9),G3(:,:,:,100))
  call check_last_Q_A(l_switch,G3(:,:,:,100),Q(:,63),ZERO,G4tensor(:,33))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,27))
  call loop_A_Q(G0(:,:,:,27),Q(:,8),ZERO,G1(:,:,:,139))
  call loop_AV_Q(G1(:,:,:,139),wf(:,11),G1(:,:,:,140))
  call loop_A_Q(G1(:,:,:,140),Q(:,56),ZERO,G2(:,:,:,247))
  call loop_AV_Q(G2(:,:,:,247),wf(:,4),G2(:,:,:,248))
  call check_last_A_Q(l_switch,G2(:,:,:,248),Q(:,63),ZERO,G3tensor(:,149))
  call loop_AV_Q(G2(:,:,:,247),wf(:,9),G2(:,:,:,249))
  call check_last_A_Q(l_switch,G2(:,:,:,249),Q(:,63),ZERO,G3tensor(:,150))
  call loop_AV_Q(G1(:,:,:,139),wf(:,-4),G1(:,:,:,141))
  call loop_A_Q(G1(:,:,:,141),Q(:,24),ZERO,G2(:,:,:,250))
  call loop_AV_Q(G2(:,:,:,250),wf(:,-5),G2(:,:,:,251))
  call loop_A_Q(G2(:,:,:,251),Q(:,56),ZERO,G3(:,:,:,101))
  call loop_AV_Q(G3(:,:,:,101),wf(:,4),G3(:,:,:,102))
  call check_last_A_Q(l_switch,G3(:,:,:,102),Q(:,63),ZERO,G4tensor(:,34))
  call loop_AV_Q(G3(:,:,:,101),wf(:,9),G3(:,:,:,103))
  call check_last_A_Q(l_switch,G3(:,:,:,103),Q(:,63),ZERO,G4tensor(:,35))
  call loop_AV_Q(G1(:,:,:,139),wf(:,-5),G1(:,:,:,142))
  call loop_A_Q(G1(:,:,:,142),Q(:,40),ZERO,G2(:,:,:,252))
  call loop_AV_Q(G2(:,:,:,252),wf(:,-4),G2(:,:,:,253))
  call loop_A_Q(G2(:,:,:,253),Q(:,56),ZERO,G3(:,:,:,104))
  call loop_AV_Q(G3(:,:,:,104),wf(:,4),G3(:,:,:,105))
  call check_last_A_Q(l_switch,G3(:,:,:,105),Q(:,63),ZERO,G4tensor(:,36))
  call loop_AV_Q(G3(:,:,:,104),wf(:,9),G3(:,:,:,106))
  call check_last_A_Q(l_switch,G3(:,:,:,106),Q(:,63),ZERO,G4tensor(:,37))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,-3),Q(:,8),G1(:,:,:,143))
  call loop_CV_D(G1(:,:,:,143),Q(:,8),wf(:,11),Q(:,48),G2(:,:,:,254))
  call check_last_CV_D(l_switch,G2(:,:,:,254),Q(:,56),wf(:,4),Q(:,7),G3tensor(:,151))
  call check_last_CV_D(l_switch,G2(:,:,:,254),Q(:,56),wf(:,9),Q(:,7),G3tensor(:,152))
  call loop_CV_D(G1(:,:,:,143),Q(:,8),wf(:,-4),Q(:,16),G2(:,:,:,255))
  call loop_CV_D(G2(:,:,:,255),Q(:,24),wf(:,-5),Q(:,32),G3(:,:,:,107))
  call check_last_CV_D(l_switch,G3(:,:,:,107),Q(:,56),wf(:,4),Q(:,7),G4tensor(:,38))
  call check_last_CV_D(l_switch,G3(:,:,:,107),Q(:,56),wf(:,9),Q(:,7),G4tensor(:,39))
  call loop_CV_D(G1(:,:,:,143),Q(:,8),wf(:,-5),Q(:,32),G2(:,:,:,256))
  call loop_CV_D(G2(:,:,:,256),Q(:,40),wf(:,-4),Q(:,16),G3(:,:,:,108))
  call check_last_CV_D(l_switch,G3(:,:,:,108),Q(:,56),wf(:,4),Q(:,7),G4tensor(:,40))
  call check_last_CV_D(l_switch,G3(:,:,:,108),Q(:,56),wf(:,9),Q(:,7),G4tensor(:,41))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,-3),G1(:,:,:,144))
  call loop_DV_C(G1(:,:,:,144),Q(:,8),wf(:,11),G2(:,:,:,257))
  call check_last_DV_C(l_switch,G2(:,:,:,257),Q(:,56),wf(:,4),G3tensor(:,153))
  call check_last_DV_C(l_switch,G2(:,:,:,257),Q(:,56),wf(:,9),G3tensor(:,154))
  call loop_DV_C(G1(:,:,:,144),Q(:,8),wf(:,-4),G2(:,:,:,258))
  call loop_DV_C(G2(:,:,:,258),Q(:,24),wf(:,-5),G3(:,:,:,109))
  call check_last_DV_C(l_switch,G3(:,:,:,109),Q(:,56),wf(:,4),G4tensor(:,42))
  call check_last_DV_C(l_switch,G3(:,:,:,109),Q(:,56),wf(:,9),G4tensor(:,43))
  call loop_DV_C(G1(:,:,:,144),Q(:,8),wf(:,-5),G2(:,:,:,259))
  call loop_DV_C(G2(:,:,:,259),Q(:,40),wf(:,-4),G3(:,:,:,110))
  call check_last_DV_C(l_switch,G3(:,:,:,110),Q(:,56),wf(:,4),G4tensor(:,44))
  call check_last_DV_C(l_switch,G3(:,:,:,110),Q(:,56),wf(:,9),G4tensor(:,45))
  call loop_VQ_A(G0(:,:,:,1),wf(:,26),G0(:,:,:,28))
  call loop_Q_A(G0(:,:,:,28),Q(:,13),MB,G1(:,:,:,145))
  call loop_QV_A(G1(:,:,:,145),wf(:,11),G1(:,:,:,146))
  call loop_Q_A(G1(:,:,:,146),Q(:,61),MB,G2(:,:,:,260))
  call check_last_QA_V(l_switch,G2(:,:,:,260),wf(:,-1),G2tensor(:,77))
  call loop_QV_A(G1(:,:,:,145),wf(:,-5),G1(:,:,:,147))
  call loop_Q_A(G1(:,:,:,147),Q(:,45),MB,G2(:,:,:,261))
  call loop_QV_A(G2(:,:,:,261),wf(:,-4),G2(:,:,:,262))
  call loop_Q_A(G2(:,:,:,262),Q(:,61),MB,G3(:,:,:,111))
  call check_last_QA_V(l_switch,G3(:,:,:,111),wf(:,-1),G3tensor(:,155))
  call loop_QV_A(G1(:,:,:,145),wf(:,-4),G1(:,:,:,148))
  call loop_Q_A(G1(:,:,:,148),Q(:,29),MB,G2(:,:,:,263))
  call loop_QV_A(G2(:,:,:,263),wf(:,-5),G2(:,:,:,264))
  call loop_Q_A(G2(:,:,:,264),Q(:,61),MB,G3(:,:,:,112))
  call check_last_QA_V(l_switch,G3(:,:,:,112),wf(:,-1),G3tensor(:,156))
  call loop_VA_Q(G0(:,:,:,1),wf(:,44),G0(:,:,:,29))
  call loop_A_Q(G0(:,:,:,29),Q(:,50),MB,G1(:,:,:,149))
  call loop_AV_Q(G1(:,:,:,149),wf(:,-3),G1(:,:,:,150))
  call loop_A_Q(G1(:,:,:,150),Q(:,58),MB,G2(:,:,:,265))
  call check_last_AQ_V(l_switch,G2(:,:,:,265),wf(:,3),G2tensor(:,78))
  call loop_AS_Q(G2(:,:,:,265),wf(:,-2),G2(:,:,:,266),gH)
  call loop_A_Q(G2(:,:,:,266),Q(:,62),MB,G3(:,:,:,113))
  call check_last_AQ_V(l_switch,G3(:,:,:,113),wf(:,0),G3tensor(:,157))
  call loop_AS_Q(G1(:,:,:,149),wf(:,-2),G1(:,:,:,151),gH)
  call loop_A_Q(G1(:,:,:,151),Q(:,54),MB,G2(:,:,:,267))
  call check_last_AQ_V(l_switch,G2(:,:,:,267),wf(:,46),G2tensor(:,79))
  call loop_AV_Q(G2(:,:,:,267),wf(:,-3),G2(:,:,:,268))
  call loop_A_Q(G2(:,:,:,268),Q(:,62),MB,G3(:,:,:,114))
  call check_last_AQ_V(l_switch,G3(:,:,:,114),wf(:,0),G3tensor(:,158))
  call check_last_AQ_V(l_switch,G1(:,:,:,149),wf(:,26),G1tensor(:,35))
  call check_last_AQ_V(l_switch,G1(:,:,:,149),wf(:,75),G1tensor(:,36))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,42),Q(:,56),G1(:,:,:,152))
  call loop_VQ_A(G1(:,:,:,152),wf(:,3),G1(:,:,:,153))
  call loop_Q_A(G1(:,:,:,153),Q(:,61),MB,G2(:,:,:,269))
  call check_last_QA_V(l_switch,G2(:,:,:,269),wf(:,-1),G2tensor(:,80))
  call loop_VA_Q(G1(:,:,:,152),wf(:,8),G1(:,:,:,154))
  call loop_A_Q(G1(:,:,:,154),Q(:,62),MB,G2(:,:,:,270))
  call check_last_AQ_V(l_switch,G2(:,:,:,270),wf(:,0),G2tensor(:,81))
  call loop_VA_Q(G1(:,:,:,152),wf(:,-1),G1(:,:,:,155))
  call loop_A_Q(G1(:,:,:,155),Q(:,58),MB,G2(:,:,:,271))
  call loop_AS_Q(G2(:,:,:,271),wf(:,-2),G2(:,:,:,272),gH)
  call loop_A_Q(G2(:,:,:,272),Q(:,62),MB,G3(:,:,:,115))
  call check_last_AQ_V(l_switch,G3(:,:,:,115),wf(:,0),G3tensor(:,159))
  call check_last_UV_W(l_switch,G1(:,:,:,152),Q(:,56),wf(:,4),Q(:,7),G2tensor(:,82))
  call check_last_UV_W(l_switch,G1(:,:,:,152),Q(:,56),wf(:,9),Q(:,7),G2tensor(:,83))
  call loop_VQ_A(G0(:,:,:,1),wf(:,300),G0(:,:,:,30))
  call loop_Q_A(G0(:,:,:,30),Q(:,53),MB,G1(:,:,:,156))
  call loop_QV_A(G1(:,:,:,156),wf(:,-3),G1(:,:,:,157))
  call loop_Q_A(G1(:,:,:,157),Q(:,61),MB,G2(:,:,:,273))
  call check_last_QA_V(l_switch,G2(:,:,:,273),wf(:,-1),G2tensor(:,84))
  call check_last_QA_V(l_switch,G1(:,:,:,156),wf(:,12),G1tensor(:,37))
  call loop_QV_A(G0(:,:,:,1),wf(:,406),G0(:,:,:,31))
  call loop_Q_A(G0(:,:,:,31),Q(:,23),ZERO,G1(:,:,:,158))
  call loop_QV_A(G1(:,:,:,158),wf(:,-5),G1(:,:,:,159))
  call loop_Q_A(G1(:,:,:,159),Q(:,55),ZERO,G2(:,:,:,274))
  call loop_QV_A(G2(:,:,:,274),wf(:,-3),G2(:,:,:,275))
  call check_last_Q_A(l_switch,G2(:,:,:,275),Q(:,63),ZERO,G3tensor(:,160))
  call loop_QV_A(G0(:,:,:,1),wf(:,406),G0(:,:,:,32))
  call loop_Q_A(G0(:,:,:,32),Q(:,23),MT,G1(:,:,:,160))
  call loop_QV_A(G1(:,:,:,160),wf(:,-5),G1(:,:,:,161))
  call loop_Q_A(G1(:,:,:,161),Q(:,55),MT,G2(:,:,:,276))
  call loop_QV_A(G2(:,:,:,276),wf(:,-3),G2(:,:,:,277))
  call check_last_Q_A(l_switch,G2(:,:,:,277),Q(:,63),MT,G3tensor(:,161))
  call loop_AV_Q(G0(:,:,:,1),wf(:,406),G0(:,:,:,33))
  call loop_A_Q(G0(:,:,:,33),Q(:,23),ZERO,G1(:,:,:,162))
  call loop_AV_Q(G1(:,:,:,162),wf(:,-5),G1(:,:,:,163))
  call loop_A_Q(G1(:,:,:,163),Q(:,55),ZERO,G2(:,:,:,278))
  call loop_AV_Q(G2(:,:,:,278),wf(:,-3),G2(:,:,:,279))
  call check_last_A_Q(l_switch,G2(:,:,:,279),Q(:,63),ZERO,G3tensor(:,162))
  call loop_AV_Q(G0(:,:,:,1),wf(:,406),G0(:,:,:,34))
  call loop_A_Q(G0(:,:,:,34),Q(:,23),MT,G1(:,:,:,164))
  call loop_AV_Q(G1(:,:,:,164),wf(:,-5),G1(:,:,:,165))
  call loop_A_Q(G1(:,:,:,165),Q(:,55),MT,G2(:,:,:,280))
  call loop_AV_Q(G2(:,:,:,280),wf(:,-3),G2(:,:,:,281))
  call check_last_A_Q(l_switch,G2(:,:,:,281),Q(:,63),MT,G3tensor(:,163))
  call loop_QV_A(G0(:,:,:,1),wf(:,406),G0(:,:,:,35))
  call loop_Q_A(G0(:,:,:,35),Q(:,23),MB,G1(:,:,:,166))
  call loop_QV_A(G1(:,:,:,166),wf(:,-5),G1(:,:,:,167))
  call loop_Q_A(G1(:,:,:,167),Q(:,55),MB,G2(:,:,:,282))
  call loop_QV_A(G2(:,:,:,282),wf(:,-3),G2(:,:,:,283))
  call check_last_Q_A(l_switch,G2(:,:,:,283),Q(:,63),MB,G3tensor(:,164))
  call loop_AV_Q(G0(:,:,:,1),wf(:,406),G0(:,:,:,36))
  call loop_A_Q(G0(:,:,:,36),Q(:,23),MB,G1(:,:,:,168))
  call loop_AV_Q(G1(:,:,:,168),wf(:,-5),G1(:,:,:,169))
  call loop_A_Q(G1(:,:,:,169),Q(:,55),MB,G2(:,:,:,284))
  call loop_AV_Q(G2(:,:,:,284),wf(:,-3),G2(:,:,:,285))
  call check_last_A_Q(l_switch,G2(:,:,:,285),Q(:,63),MB,G3tensor(:,165))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,406),Q(:,23),G1(:,:,:,170))
  call loop_CV_D(G1(:,:,:,170),Q(:,23),wf(:,-5),Q(:,32),G2(:,:,:,286))
  call check_last_CV_D(l_switch,G2(:,:,:,286),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,166))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,406),G1(:,:,:,171))
  call loop_DV_C(G1(:,:,:,171),Q(:,23),wf(:,-5),G2(:,:,:,287))
  call check_last_DV_C(l_switch,G2(:,:,:,287),Q(:,55),wf(:,-3),G3tensor(:,167))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,406),Q(:,23),G1(:,:,:,172))
  call loop_UV_W(G1(:,:,:,172),Q(:,23),wf(:,-5),Q(:,32),G2(:,:,:,288))
  call check_last_UV_W(l_switch,G2(:,:,:,288),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,168))
  call loop_VQ_A(G0(:,:,:,1),wf(:,410),G0(:,:,:,37))
  call loop_Q_A(G0(:,:,:,37),Q(:,29),MB,G1(:,:,:,173))
  call loop_QV_A(G1(:,:,:,173),wf(:,-5),G1(:,:,:,174))
  call loop_Q_A(G1(:,:,:,174),Q(:,61),MB,G2(:,:,:,289))
  call check_last_QA_V(l_switch,G2(:,:,:,289),wf(:,-1),G2tensor(:,85))
  call loop_VQ_A(G0(:,:,:,1),wf(:,412),G0(:,:,:,38))
  call loop_Q_A(G0(:,:,:,38),Q(:,45),MB,G1(:,:,:,175))
  call loop_QV_A(G1(:,:,:,175),wf(:,-4),G1(:,:,:,176))
  call loop_Q_A(G1(:,:,:,176),Q(:,61),MB,G2(:,:,:,290))
  call check_last_QA_V(l_switch,G2(:,:,:,290),wf(:,-1),G2tensor(:,86))
  call check_last_QA_V(l_switch,G1(:,:,:,175),wf(:,22),G1tensor(:,38))
  call loop_QV_A(G0(:,:,:,1),wf(:,413),G0(:,:,:,39))
  call loop_Q_A(G0(:,:,:,39),Q(:,23),ZERO,G1(:,:,:,177))
  call loop_QV_A(G1(:,:,:,177),wf(:,-5),G1(:,:,:,178))
  call loop_Q_A(G1(:,:,:,178),Q(:,55),ZERO,G2(:,:,:,291))
  call loop_QV_A(G2(:,:,:,291),wf(:,-3),G2(:,:,:,292))
  call check_last_Q_A(l_switch,G2(:,:,:,292),Q(:,63),ZERO,G3tensor(:,169))
  call loop_QV_A(G0(:,:,:,1),wf(:,413),G0(:,:,:,40))
  call loop_Q_A(G0(:,:,:,40),Q(:,23),MT,G1(:,:,:,179))
  call loop_QV_A(G1(:,:,:,179),wf(:,-5),G1(:,:,:,180))
  call loop_Q_A(G1(:,:,:,180),Q(:,55),MT,G2(:,:,:,293))
  call loop_QV_A(G2(:,:,:,293),wf(:,-3),G2(:,:,:,294))
  call check_last_Q_A(l_switch,G2(:,:,:,294),Q(:,63),MT,G3tensor(:,170))
  call loop_AV_Q(G0(:,:,:,1),wf(:,413),G0(:,:,:,41))
  call loop_A_Q(G0(:,:,:,41),Q(:,23),ZERO,G1(:,:,:,181))
  call loop_AV_Q(G1(:,:,:,181),wf(:,-5),G1(:,:,:,182))
  call loop_A_Q(G1(:,:,:,182),Q(:,55),ZERO,G2(:,:,:,295))
  call loop_AV_Q(G2(:,:,:,295),wf(:,-3),G2(:,:,:,296))
  call check_last_A_Q(l_switch,G2(:,:,:,296),Q(:,63),ZERO,G3tensor(:,171))
  call loop_AV_Q(G0(:,:,:,1),wf(:,413),G0(:,:,:,42))
  call loop_A_Q(G0(:,:,:,42),Q(:,23),MT,G1(:,:,:,183))
  call loop_AV_Q(G1(:,:,:,183),wf(:,-5),G1(:,:,:,184))
  call loop_A_Q(G1(:,:,:,184),Q(:,55),MT,G2(:,:,:,297))
  call loop_AV_Q(G2(:,:,:,297),wf(:,-3),G2(:,:,:,298))
  call check_last_A_Q(l_switch,G2(:,:,:,298),Q(:,63),MT,G3tensor(:,172))
  call loop_QV_A(G0(:,:,:,1),wf(:,413),G0(:,:,:,43))
  call loop_Q_A(G0(:,:,:,43),Q(:,23),MB,G1(:,:,:,185))
  call loop_QV_A(G1(:,:,:,185),wf(:,-5),G1(:,:,:,186))
  call loop_Q_A(G1(:,:,:,186),Q(:,55),MB,G2(:,:,:,299))
  call loop_QV_A(G2(:,:,:,299),wf(:,-3),G2(:,:,:,300))
  call check_last_Q_A(l_switch,G2(:,:,:,300),Q(:,63),MB,G3tensor(:,173))
  call loop_AV_Q(G0(:,:,:,1),wf(:,413),G0(:,:,:,44))
  call loop_A_Q(G0(:,:,:,44),Q(:,23),MB,G1(:,:,:,187))
  call loop_AV_Q(G1(:,:,:,187),wf(:,-5),G1(:,:,:,188))
  call loop_A_Q(G1(:,:,:,188),Q(:,55),MB,G2(:,:,:,301))
  call loop_AV_Q(G2(:,:,:,301),wf(:,-3),G2(:,:,:,302))
  call check_last_A_Q(l_switch,G2(:,:,:,302),Q(:,63),MB,G3tensor(:,174))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,413),Q(:,23),G1(:,:,:,189))
  call loop_CV_D(G1(:,:,:,189),Q(:,23),wf(:,-5),Q(:,32),G2(:,:,:,303))
  call check_last_CV_D(l_switch,G2(:,:,:,303),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,175))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,413),G1(:,:,:,190))
  call loop_DV_C(G1(:,:,:,190),Q(:,23),wf(:,-5),G2(:,:,:,304))
  call check_last_DV_C(l_switch,G2(:,:,:,304),Q(:,55),wf(:,-3),G3tensor(:,176))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,413),Q(:,23),G1(:,:,:,191))
  call loop_UV_W(G1(:,:,:,191),Q(:,23),wf(:,-5),Q(:,32),G2(:,:,:,305))
  call check_last_UV_W(l_switch,G2(:,:,:,305),Q(:,55),wf(:,-3),Q(:,8),G3tensor(:,177))
  call loop_VQ_A(G0(:,:,:,1),wf(:,415),G0(:,:,:,45))
  call loop_Q_A(G0(:,:,:,45),Q(:,29),MB,G1(:,:,:,192))
  call loop_QV_A(G1(:,:,:,192),wf(:,-5),G1(:,:,:,193))
  call loop_Q_A(G1(:,:,:,193),Q(:,61),MB,G2(:,:,:,306))
  call check_last_QA_V(l_switch,G2(:,:,:,306),wf(:,-1),G2tensor(:,87))
  call loop_VQ_A(G0(:,:,:,1),wf(:,417),G0(:,:,:,46))
  call loop_Q_A(G0(:,:,:,46),Q(:,53),MB,G1(:,:,:,194))
  call loop_QV_A(G1(:,:,:,194),wf(:,-3),G1(:,:,:,195))
  call loop_Q_A(G1(:,:,:,195),Q(:,61),MB,G2(:,:,:,307))
  call check_last_QA_V(l_switch,G2(:,:,:,307),wf(:,-1),G2tensor(:,88))
  call check_last_QA_V(l_switch,G1(:,:,:,194),wf(:,12),G1tensor(:,39))
  call loop_VQ_A(G0(:,:,:,1),wf(:,420),G0(:,:,:,47))
  call loop_Q_A(G0(:,:,:,47),Q(:,45),MB,G1(:,:,:,196))
  call loop_QV_A(G1(:,:,:,196),wf(:,-4),G1(:,:,:,197))
  call loop_Q_A(G1(:,:,:,197),Q(:,61),MB,G2(:,:,:,308))
  call check_last_QA_V(l_switch,G2(:,:,:,308),wf(:,-1),G2tensor(:,89))
  call check_last_QA_V(l_switch,G1(:,:,:,196),wf(:,22),G1tensor(:,40))
  call loop_VQ_A(G0(:,:,:,1),wf(:,422),G0(:,:,:,48))
  call loop_Q_A(G0(:,:,:,48),Q(:,53),MB,G1(:,:,:,198))
  call loop_QV_A(G1(:,:,:,198),wf(:,-3),G1(:,:,:,199))
  call loop_Q_A(G1(:,:,:,199),Q(:,61),MB,G2(:,:,:,309))
  call check_last_QA_V(l_switch,G2(:,:,:,309),wf(:,-1),G2tensor(:,90))
  call check_last_QA_V(l_switch,G1(:,:,:,198),wf(:,12),G1tensor(:,41))
  call loop_VQ_A(G0(:,:,:,1),wf(:,46),G0(:,:,:,49))
  call loop_Q_A(G0(:,:,:,49),Q(:,9),MB,G1(:,:,:,200))
  call loop_QV_A(G1(:,:,:,200),wf(:,11),G1(:,:,:,201))
  call loop_Q_A(G1(:,:,:,201),Q(:,57),MB,G2(:,:,:,310))
  call check_last_QA_V(l_switch,G2(:,:,:,310),wf(:,8),G2tensor(:,91))
  call loop_QS_A(G2(:,:,:,310),wf(:,-2),G2(:,:,:,311),gH)
  call loop_Q_A(G2(:,:,:,311),Q(:,61),MB,G3(:,:,:,116))
  call check_last_QA_V(l_switch,G3(:,:,:,116),wf(:,-1),G3tensor(:,178))
  call loop_QV_A(G1(:,:,:,200),wf(:,-4),G1(:,:,:,202))
  call loop_Q_A(G1(:,:,:,202),Q(:,25),MB,G2(:,:,:,312))
  call loop_QV_A(G2(:,:,:,312),wf(:,-5),G2(:,:,:,313))
  call loop_Q_A(G2(:,:,:,313),Q(:,57),MB,G3(:,:,:,117))
  call check_last_QA_V(l_switch,G3(:,:,:,117),wf(:,8),G3tensor(:,179))
  call loop_QS_A(G3(:,:,:,117),wf(:,-2),G3(:,:,:,118),gH)
  call loop_Q_A(G3(:,:,:,118),Q(:,61),MB,G4(:,:,:,22))
  call check_last_QA_V(l_switch,G4(:,:,:,22),wf(:,-1),G4tensor(:,46))
  call loop_QS_A(G2(:,:,:,312),wf(:,-2),G2(:,:,:,314),gH)
  call loop_Q_A(G2(:,:,:,314),Q(:,29),MB,G3(:,:,:,119))
  call loop_QV_A(G3(:,:,:,119),wf(:,-5),G3(:,:,:,120))
  call loop_Q_A(G3(:,:,:,120),Q(:,61),MB,G4(:,:,:,23))
  call check_last_QA_V(l_switch,G4(:,:,:,23),wf(:,-1),G4tensor(:,47))
  call loop_QV_A(G1(:,:,:,200),wf(:,-5),G1(:,:,:,203))
  call loop_Q_A(G1(:,:,:,203),Q(:,41),MB,G2(:,:,:,315))
  call loop_QV_A(G2(:,:,:,315),wf(:,-4),G2(:,:,:,316))
  call loop_Q_A(G2(:,:,:,316),Q(:,57),MB,G3(:,:,:,121))
  call check_last_QA_V(l_switch,G3(:,:,:,121),wf(:,8),G3tensor(:,180))
  call loop_QS_A(G3(:,:,:,121),wf(:,-2),G3(:,:,:,122),gH)
  call loop_Q_A(G3(:,:,:,122),Q(:,61),MB,G4(:,:,:,24))
  call check_last_QA_V(l_switch,G4(:,:,:,24),wf(:,-1),G4tensor(:,48))
  call loop_QS_A(G2(:,:,:,315),wf(:,-2),G2(:,:,:,317),gH)
  call loop_Q_A(G2(:,:,:,317),Q(:,45),MB,G3(:,:,:,123))
  call loop_QV_A(G3(:,:,:,123),wf(:,-4),G3(:,:,:,124))
  call loop_Q_A(G3(:,:,:,124),Q(:,61),MB,G4(:,:,:,25))
  call check_last_QA_V(l_switch,G4(:,:,:,25),wf(:,-1),G4tensor(:,49))
  call loop_QS_A(G1(:,:,:,200),wf(:,-2),G1(:,:,:,204),gH)
  call loop_Q_A(G1(:,:,:,204),Q(:,13),MB,G2(:,:,:,318))
  call loop_QV_A(G2(:,:,:,318),wf(:,11),G2(:,:,:,319))
  call loop_Q_A(G2(:,:,:,319),Q(:,61),MB,G3(:,:,:,125))
  call check_last_QA_V(l_switch,G3(:,:,:,125),wf(:,-1),G3tensor(:,181))
  call loop_QV_A(G2(:,:,:,318),wf(:,-5),G2(:,:,:,320))
  call loop_Q_A(G2(:,:,:,320),Q(:,45),MB,G3(:,:,:,126))
  call loop_QV_A(G3(:,:,:,126),wf(:,-4),G3(:,:,:,127))
  call loop_Q_A(G3(:,:,:,127),Q(:,61),MB,G4(:,:,:,26))
  call check_last_QA_V(l_switch,G4(:,:,:,26),wf(:,-1),G4tensor(:,50))
  call loop_QV_A(G2(:,:,:,318),wf(:,-4),G2(:,:,:,321))
  call loop_Q_A(G2(:,:,:,321),Q(:,29),MB,G3(:,:,:,128))
  call loop_QV_A(G3(:,:,:,128),wf(:,-5),G3(:,:,:,129))
  call loop_Q_A(G3(:,:,:,129),Q(:,61),MB,G4(:,:,:,27))
  call check_last_QA_V(l_switch,G4(:,:,:,27),wf(:,-1),G4tensor(:,51))
  call loop_VQ_A(G0(:,:,:,1),wf(:,50),G0(:,:,:,50))
  call loop_Q_A(G0(:,:,:,50),Q(:,25),MB,G1(:,:,:,205))
  call loop_QV_A(G1(:,:,:,205),wf(:,-5),G1(:,:,:,206))
  call loop_Q_A(G1(:,:,:,206),Q(:,57),MB,G2(:,:,:,322))
  call check_last_QA_V(l_switch,G2(:,:,:,322),wf(:,8),G2tensor(:,92))
  call loop_QS_A(G2(:,:,:,322),wf(:,-2),G2(:,:,:,323),gH)
  call loop_Q_A(G2(:,:,:,323),Q(:,61),MB,G3(:,:,:,130))
  call check_last_QA_V(l_switch,G3(:,:,:,130),wf(:,-1),G3tensor(:,182))
  call loop_QS_A(G1(:,:,:,205),wf(:,-2),G1(:,:,:,207),gH)
  call loop_Q_A(G1(:,:,:,207),Q(:,29),MB,G2(:,:,:,324))
  call loop_QV_A(G2(:,:,:,324),wf(:,-5),G2(:,:,:,325))
  call loop_Q_A(G2(:,:,:,325),Q(:,61),MB,G3(:,:,:,131))
  call check_last_QA_V(l_switch,G3(:,:,:,131),wf(:,-1),G3tensor(:,183))
  call loop_VQ_A(G0(:,:,:,1),wf(:,171),G0(:,:,:,51))
  call loop_Q_A(G0(:,:,:,51),Q(:,41),MB,G1(:,:,:,208))
  call loop_QV_A(G1(:,:,:,208),wf(:,-4),G1(:,:,:,209))
  call loop_Q_A(G1(:,:,:,209),Q(:,57),MB,G2(:,:,:,326))
  call check_last_QA_V(l_switch,G2(:,:,:,326),wf(:,8),G2tensor(:,93))
  call loop_QS_A(G2(:,:,:,326),wf(:,-2),G2(:,:,:,327),gH)
  call loop_Q_A(G2(:,:,:,327),Q(:,61),MB,G3(:,:,:,132))
  call check_last_QA_V(l_switch,G3(:,:,:,132),wf(:,-1),G3tensor(:,184))
  call loop_QS_A(G1(:,:,:,208),wf(:,-2),G1(:,:,:,210),gH)
  call loop_Q_A(G1(:,:,:,210),Q(:,45),MB,G2(:,:,:,328))
  call check_last_QA_V(l_switch,G2(:,:,:,328),wf(:,22),G2tensor(:,94))
  call loop_QV_A(G2(:,:,:,328),wf(:,-4),G2(:,:,:,329))
  call loop_Q_A(G2(:,:,:,329),Q(:,61),MB,G3(:,:,:,133))
  call check_last_QA_V(l_switch,G3(:,:,:,133),wf(:,-1),G3tensor(:,185))
  call check_last_QA_V(l_switch,G1(:,:,:,208),wf(:,53),G1tensor(:,42))
  call check_last_QA_V(l_switch,G1(:,:,:,208),wf(:,77),G1tensor(:,43))
  call loop_VA_Q(G0(:,:,:,1),wf(:,53),G0(:,:,:,52))
  call loop_A_Q(G0(:,:,:,52),Q(:,22),MB,G1(:,:,:,211))
  call loop_AV_Q(G1(:,:,:,211),wf(:,-5),G1(:,:,:,212))
  call loop_A_Q(G1(:,:,:,212),Q(:,54),MB,G2(:,:,:,330))
  call check_last_AQ_V(l_switch,G2(:,:,:,330),wf(:,46),G2tensor(:,95))
  call loop_AV_Q(G2(:,:,:,330),wf(:,-3),G2(:,:,:,331))
  call loop_A_Q(G2(:,:,:,331),Q(:,62),MB,G3(:,:,:,134))
  call check_last_AQ_V(l_switch,G3(:,:,:,134),wf(:,0),G3tensor(:,186))
  call loop_AQ_V(G1(:,:,:,211),wf(:,63),G1(:,:,:,213))
  call check_last_UV_W(l_switch,G1(:,:,:,213),Q(:,55),wf(:,-3),Q(:,8),G2tensor(:,96))
  call loop_AV_Q(G1(:,:,:,211),wf(:,21),G1(:,:,:,214))
  call loop_A_Q(G1(:,:,:,214),Q(:,62),MB,G2(:,:,:,332))
  call check_last_AQ_V(l_switch,G2(:,:,:,332),wf(:,0),G2tensor(:,97))
  call loop_AV_Q(G1(:,:,:,211),wf(:,-3),G1(:,:,:,215))
  call loop_A_Q(G1(:,:,:,215),Q(:,30),MB,G2(:,:,:,333))
  call loop_AV_Q(G2(:,:,:,333),wf(:,-5),G2(:,:,:,334))
  call loop_A_Q(G2(:,:,:,334),Q(:,62),MB,G3(:,:,:,135))
  call check_last_AQ_V(l_switch,G3(:,:,:,135),wf(:,0),G3tensor(:,187))
  call loop_VA_Q(G0(:,:,:,1),wf(:,173),G0(:,:,:,53))
  call loop_A_Q(G0(:,:,:,53),Q(:,38),MB,G1(:,:,:,216))
  call loop_AV_Q(G1(:,:,:,216),wf(:,-4),G1(:,:,:,217))
  call loop_A_Q(G1(:,:,:,217),Q(:,54),MB,G2(:,:,:,335))
  call check_last_AQ_V(l_switch,G2(:,:,:,335),wf(:,46),G2tensor(:,98))
  call loop_AV_Q(G2(:,:,:,335),wf(:,-3),G2(:,:,:,336))
  call loop_A_Q(G2(:,:,:,336),Q(:,62),MB,G3(:,:,:,136))
  call check_last_AQ_V(l_switch,G3(:,:,:,136),wf(:,0),G3tensor(:,188))
  call loop_AV_Q(G1(:,:,:,216),wf(:,-3),G1(:,:,:,218))
  call loop_A_Q(G1(:,:,:,218),Q(:,46),MB,G2(:,:,:,337))
  call check_last_AQ_V(l_switch,G2(:,:,:,337),wf(:,55),G2tensor(:,99))
  call loop_AV_Q(G2(:,:,:,337),wf(:,-4),G2(:,:,:,338))
  call loop_A_Q(G2(:,:,:,338),Q(:,62),MB,G3(:,:,:,137))
  call check_last_AQ_V(l_switch,G3(:,:,:,137),wf(:,0),G3tensor(:,189))
  call loop_AV_Q(G1(:,:,:,216),wf(:,30),G1(:,:,:,219))
  call loop_A_Q(G1(:,:,:,219),Q(:,62),MB,G2(:,:,:,339))
  call check_last_AQ_V(l_switch,G2(:,:,:,339),wf(:,0),G2tensor(:,100))
  call check_last_AQ_V(l_switch,G1(:,:,:,216),wf(:,50),G1tensor(:,44))
  call check_last_AQ_V(l_switch,G1(:,:,:,216),wf(:,58),G1tensor(:,45))
  call check_last_AQ_V(l_switch,G1(:,:,:,216),wf(:,66),G1tensor(:,46))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + ((-3*f(18))/2._/**/REALKIND * den(593)) * TI2_call(2,momenta_106,masses2_9,G2tensor(:,1),T2sum(1:15,1))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(593)) * TI2_call(2,momenta_106,masses2_9,G2tensor(:,1),T2sum(1:15,1))
  M(2) = M(2) + (-(f(18)/6._/**/REALKIND) * den(12)) * TI2_call(2,momenta_55,masses2_6,G2tensor(:,15),T2sum(1:15,20))
  M(1) = M(1) + (-(f(18)/6._/**/REALKIND) * den(144)) * TI2_call(2,momenta_90,masses2_6,G2tensor(:,18),T2sum(1:15,22))
  M(1) = M(1) + (-(f(18)/6._/**/REALKIND) * den(15)) * TI2_call(2,momenta_69,masses2_6,G2tensor(:,21),T2sum(1:15,24))
  M(2) = M(2) + (-(f(18)/6._/**/REALKIND) * den(146)) * TI2_call(2,momenta_102,masses2_6,G2tensor(:,22),T2sum(1:15,26))
  M(1) = M(1) + (-(f(22)/2._/**/REALKIND) * den(269)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,15),T3sum(1:35,15))
  M(9) = M(9) + (f(22)/6._/**/REALKIND * den(269)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,15),T3sum(1:35,15))
  M(2) = M(2) + (-(f(22)/2._/**/REALKIND) * den(269)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,33),T3sum(1:35,15))
  M(9) = M(9) + (f(22)/6._/**/REALKIND * den(269)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,33),T3sum(1:35,15))
  M(1) = M(1) + (-(f(22)/2._/**/REALKIND) * den(269)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,15),T3sum(1:35,15))
  M(9) = M(9) + (f(22)/6._/**/REALKIND * den(269)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,15),T3sum(1:35,15))
  M(2) = M(2) + (-(f(22)/2._/**/REALKIND) * den(269)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,33),T3sum(1:35,15))
  M(9) = M(9) + (f(22)/6._/**/REALKIND * den(269)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,33),T3sum(1:35,15))
  M(1) = M(1) + ((3*CI*f(16))/2._/**/REALKIND * den(269)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,51),T3sum(1:35,15))
  M(2) = M(2) + ((-3*CI*f(16))/2._/**/REALKIND * den(269)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,51),T3sum(1:35,15))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(269)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,69),T3sum(1:35,15))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(269)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,69),T3sum(1:35,15))
  M(3) = M(3) + ((CI*f(16))/6._/**/REALKIND * den(594)) * TI2_call(2,momenta_53,masses2_6,G2tensor(:,24),T2sum(1:15,28))
  M(4) = M(4) + (-(CI*f(16))/6._/**/REALKIND * den(594)) * TI2_call(2,momenta_53,masses2_6,G2tensor(:,24),T2sum(1:15,28))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(594)) * TI2_call(2,momenta_96,masses2_9,G2tensor(:,29),T2sum(1:15,4))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(594)) * TI2_call(2,momenta_96,masses2_9,G2tensor(:,29),T2sum(1:15,4))
  M(4) = M(4) + (-(f(18)/6._/**/REALKIND) * den(22)) * TI2_call(2,momenta_51,masses2_6,G2tensor(:,25),T2sum(1:15,29))
  M(3) = M(3) + (-(f(18)/6._/**/REALKIND) * den(151)) * TI2_call(2,momenta_89,masses2_6,G2tensor(:,19),T2sum(1:15,31))
  M(3) = M(3) + ((3*CI*f(16))/2._/**/REALKIND * den(151)) * TI2_call(2,momenta_52,masses2_7,G2tensor(:,27),T2sum(1:15,32))
  M(3) = M(3) + (-(f(18)/6._/**/REALKIND) * den(24)) * TI2_call(2,momenta_69,masses2_6,G2tensor(:,43),T2sum(1:15,24))
  M(4) = M(4) + (-(f(18)/6._/**/REALKIND) * den(153)) * TI2_call(2,momenta_112,masses2_6,G2tensor(:,44),T2sum(1:15,33))
  M(3) = M(3) + (-(f(22)/2._/**/REALKIND) * den(287)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,104),T3sum(1:35,10))
  M(8) = M(8) + (f(22)/6._/**/REALKIND * den(287)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,104),T3sum(1:35,10))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(287)) * TI2_call(3,momenta_61,masses2_8,G3tensor(:,105),T3sum(1:35,56))
  M(8) = M(8) + (f(21)/6._/**/REALKIND * den(287)) * TI2_call(3,momenta_61,masses2_8,G3tensor(:,105),T3sum(1:35,56))
  M(4) = M(4) + (-(f(22)/2._/**/REALKIND) * den(287)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,106),T3sum(1:35,10))
  M(8) = M(8) + (f(22)/6._/**/REALKIND * den(287)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,106),T3sum(1:35,10))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(287)) * TI2_call(3,momenta_61,masses2_8,G3tensor(:,107),T3sum(1:35,56))
  M(8) = M(8) + (f(21)/6._/**/REALKIND * den(287)) * TI2_call(3,momenta_61,masses2_8,G3tensor(:,107),T3sum(1:35,56))
  M(3) = M(3) + (-(f(22)/2._/**/REALKIND) * den(287)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,104),T3sum(1:35,10))
  M(8) = M(8) + (f(22)/6._/**/REALKIND * den(287)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,104),T3sum(1:35,10))
  M(3) = M(3) + (-(f(21)/2._/**/REALKIND) * den(287)) * TI2_call(3,momenta_61,masses2_5,G3tensor(:,108),T3sum(1:35,57))
  M(8) = M(8) + (f(21)/6._/**/REALKIND * den(287)) * TI2_call(3,momenta_61,masses2_5,G3tensor(:,108),T3sum(1:35,57))
  M(4) = M(4) + (-(f(22)/2._/**/REALKIND) * den(287)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,106),T3sum(1:35,10))
  M(8) = M(8) + (f(22)/6._/**/REALKIND * den(287)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,106),T3sum(1:35,10))
  M(4) = M(4) + (-(f(21)/2._/**/REALKIND) * den(287)) * TI2_call(3,momenta_61,masses2_5,G3tensor(:,109),T3sum(1:35,57))
  M(8) = M(8) + (f(21)/6._/**/REALKIND * den(287)) * TI2_call(3,momenta_61,masses2_5,G3tensor(:,109),T3sum(1:35,57))
  M(3) = M(3) + ((3*CI*f(16))/2._/**/REALKIND * den(287)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,110),T3sum(1:35,10))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(287)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,110),T3sum(1:35,10))
  M(3) = M(3) + ((-3*CI*f(16))/2._/**/REALKIND * den(287)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,111),T3sum(1:35,10))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND * den(287)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,111),T3sum(1:35,10))
  M(3) = M(3) + ((3*CI*f(16))/2._/**/REALKIND * den(287)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,112),T3sum(1:35,10))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(287)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,112),T3sum(1:35,10))
  M(4) = M(4) + (-(f(18)/6._/**/REALKIND) * den(18)) * TI2_call(3,momenta_222,masses2_12,G3tensor(:,88),T3sum(1:35,58))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(18)) * TI2_call(3,momenta_222,masses2_12,G3tensor(:,88),T3sum(1:35,58))
  M(3) = M(3) + (-(f(18)/6._/**/REALKIND) * den(18)) * TI2_call(3,momenta_220,masses2_12,G3tensor(:,90),T3sum(1:35,60))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(18)) * TI2_call(3,momenta_220,masses2_12,G3tensor(:,90),T3sum(1:35,60))
  M(5) = M(5) + ((CI*f(16))/6._/**/REALKIND * den(595)) * TI2_call(2,momenta_88,masses2_6,G2tensor(:,46),T2sum(1:15,35))
  M(6) = M(6) + (-(CI*f(16))/6._/**/REALKIND * den(595)) * TI2_call(2,momenta_88,masses2_6,G2tensor(:,46),T2sum(1:15,35))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(595)) * TI2_call(2,momenta_64,masses2_9,G2tensor(:,54),T2sum(1:15,6))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(595)) * TI2_call(2,momenta_64,masses2_9,G2tensor(:,54),T2sum(1:15,6))
  M(1) = M(1) + ((CI*f(20))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,129),T3sum(1:35,20))
  M(3) = M(3) + (-(CI*f(20))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,129),T3sum(1:35,20))
  M(10) = M(10) + (-(CI*f(20))/6._/**/REALKIND * den(31)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,129),T3sum(1:35,20))
  M(11) = M(11) + ((CI*f(20))/6._/**/REALKIND * den(31)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,129),T3sum(1:35,20))
  M(5) = M(5) + ((CI*f(20))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,131),T3sum(1:35,20))
  M(6) = M(6) + (-(CI*f(20))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,131),T3sum(1:35,20))
  M(10) = M(10) + (-(CI*f(20))/6._/**/REALKIND * den(31)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,131),T3sum(1:35,20))
  M(11) = M(11) + ((CI*f(20))/6._/**/REALKIND * den(31)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,131),T3sum(1:35,20))
  M(1) = M(1) + ((CI*f(20))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,129),T3sum(1:35,20))
  M(3) = M(3) + (-(CI*f(20))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,129),T3sum(1:35,20))
  M(10) = M(10) + (-(CI*f(20))/6._/**/REALKIND * den(31)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,129),T3sum(1:35,20))
  M(11) = M(11) + ((CI*f(20))/6._/**/REALKIND * den(31)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,129),T3sum(1:35,20))
  M(5) = M(5) + ((CI*f(20))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,131),T3sum(1:35,20))
  M(6) = M(6) + (-(CI*f(20))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,131),T3sum(1:35,20))
  M(10) = M(10) + (-(CI*f(20))/6._/**/REALKIND * den(31)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,131),T3sum(1:35,20))
  M(11) = M(11) + ((CI*f(20))/6._/**/REALKIND * den(31)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,131),T3sum(1:35,20))
  M(1) = M(1) + ((-3*f(18))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,133),T3sum(1:35,20))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,133),T3sum(1:35,20))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,133),T3sum(1:35,20))
  M(6) = M(6) + ((-3*f(18))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,133),T3sum(1:35,20))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,135),T3sum(1:35,20))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,135),T3sum(1:35,20))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,135),T3sum(1:35,20))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,135),T3sum(1:35,20))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,122),T3sum(1:35,20))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,122),T3sum(1:35,20))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,122),T3sum(1:35,20))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(31)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,122),T3sum(1:35,20))
  M(1) = M(1) + ((CI*f(16))/6._/**/REALKIND * den(243)) * TI2_call(2,momenta_91,masses2_6,G2tensor(:,20),T2sum(1:15,36))
  M(3) = M(3) + (-(CI*f(16))/6._/**/REALKIND * den(243)) * TI2_call(2,momenta_91,masses2_6,G2tensor(:,20),T2sum(1:15,36))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(243)) * TI2_call(2,momenta_66,masses2_9,G2tensor(:,55),T2sum(1:15,7))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(243)) * TI2_call(2,momenta_66,masses2_9,G2tensor(:,55),T2sum(1:15,7))
  M(1) = M(1) + ((CI*f(16))/6._/**/REALKIND * den(33)) * TI2_call(2,momenta_69,masses2_6,G2tensor(:,60),T2sum(1:15,24))
  M(3) = M(3) + (-(CI*f(16))/6._/**/REALKIND * den(33)) * TI2_call(2,momenta_69,masses2_6,G2tensor(:,60),T2sum(1:15,24))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(244)) * TI2_call(2,momenta_115,masses2_9,G2tensor(:,61),T2sum(1:15,2))
  M(3) = M(3) + ((3*CI*f(16))/2._/**/REALKIND * den(244)) * TI2_call(2,momenta_115,masses2_9,G2tensor(:,61),T2sum(1:15,2))
  M(5) = M(5) + ((3*CI*f(16))/2._/**/REALKIND * den(244)) * TI2_call(2,momenta_115,masses2_9,G2tensor(:,61),T2sum(1:15,2))
  M(6) = M(6) + ((-3*CI*f(16))/2._/**/REALKIND * den(244)) * TI2_call(2,momenta_115,masses2_9,G2tensor(:,61),T2sum(1:15,2))
  M(5) = M(5) + ((CI*f(16))/6._/**/REALKIND * den(301)) * TI2_call(2,momenta_71,masses2_6,G2tensor(:,65),T2sum(1:15,37))
  M(6) = M(6) + (-(CI*f(16))/6._/**/REALKIND * den(301)) * TI2_call(2,momenta_71,masses2_6,G2tensor(:,65),T2sum(1:15,37))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(299)) * TI2_call(3,momenta_230,masses2_15,G3tensor(:,126),T3sum(1:35,22))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(299)) * TI2_call(3,momenta_230,masses2_15,G3tensor(:,126),T3sum(1:35,22))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(299)) * TI2_call(3,momenta_232,masses2_16,G3tensor(:,123),T3sum(1:35,23))
  M(3) = M(3) + ((3*CI*f(16))/2._/**/REALKIND * den(299)) * TI2_call(3,momenta_232,masses2_16,G3tensor(:,123),T3sum(1:35,23))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(299)) * TI2_call(3,momenta_232,masses2_16,G3tensor(:,123),T3sum(1:35,23))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(299)) * TI2_call(3,momenta_232,masses2_16,G3tensor(:,123),T3sum(1:35,23))
  M(6) = M(6) + (-(f(18)/6._/**/REALKIND) * den(34)) * TI2_call(2,momenta_87,masses2_6,G2tensor(:,47),T2sum(1:15,39))
  M(5) = M(5) + (-(f(18)/6._/**/REALKIND) * den(154)) * TI2_call(2,momenta_86,masses2_6,G2tensor(:,49),T2sum(1:15,41))
  M(5) = M(5) + ((-3*CI*f(16))/2._/**/REALKIND * den(154)) * TI2_call(2,momenta_56,masses2_7,G2tensor(:,16),T2sum(1:15,42))
  M(5) = M(5) + (-(f(18)/6._/**/REALKIND) * den(37)) * TI2_call(2,momenta_102,masses2_6,G2tensor(:,66),T2sum(1:15,26))
  M(6) = M(6) + (-(f(18)/6._/**/REALKIND) * den(156)) * TI2_call(2,momenta_112,masses2_6,G2tensor(:,68),T2sum(1:15,33))
  M(5) = M(5) + (-(f(22)/2._/**/REALKIND) * den(304)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,23),T3sum(1:35,9))
  M(7) = M(7) + (f(22)/6._/**/REALKIND * den(304)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,23),T3sum(1:35,9))
  M(6) = M(6) + (-(f(22)/2._/**/REALKIND) * den(304)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,41),T3sum(1:35,9))
  M(7) = M(7) + (f(22)/6._/**/REALKIND * den(304)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,41),T3sum(1:35,9))
  M(5) = M(5) + (-(f(22)/2._/**/REALKIND) * den(304)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,23),T3sum(1:35,9))
  M(7) = M(7) + (f(22)/6._/**/REALKIND * den(304)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,23),T3sum(1:35,9))
  M(6) = M(6) + (-(f(22)/2._/**/REALKIND) * den(304)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,41),T3sum(1:35,9))
  M(7) = M(7) + (f(22)/6._/**/REALKIND * den(304)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,41),T3sum(1:35,9))
  M(5) = M(5) + ((3*CI*f(16))/2._/**/REALKIND * den(304)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,59),T3sum(1:35,9))
  M(6) = M(6) + ((-3*CI*f(16))/2._/**/REALKIND * den(304)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,59),T3sum(1:35,9))
  M(5) = M(5) + ((-3*CI*f(16))/2._/**/REALKIND * den(304)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,77),T3sum(1:35,9))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(304)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,77),T3sum(1:35,9))
  M(6) = M(6) + (-(f(18)/6._/**/REALKIND) * den(27)) * TI2_call(3,momenta_278,masses2_12,G3tensor(:,114),T3sum(1:35,71))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(27)) * TI2_call(3,momenta_278,masses2_12,G3tensor(:,114),T3sum(1:35,71))
  M(5) = M(5) + (-(f(18)/6._/**/REALKIND) * den(27)) * TI2_call(3,momenta_276,masses2_12,G3tensor(:,116),T3sum(1:35,73))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(27)) * TI2_call(3,momenta_276,masses2_12,G3tensor(:,116),T3sum(1:35,73))
  M(2) = M(2) + ((CI*f(20))/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,42),T3sum(1:35,16))
  M(5) = M(5) + (-(CI*f(20))/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,42),T3sum(1:35,16))
  M(10) = M(10) + ((CI*f(20))/6._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,42),T3sum(1:35,16))
  M(11) = M(11) + (-(CI*f(20))/6._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,42),T3sum(1:35,16))
  M(3) = M(3) + ((CI*f(20))/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,24),T3sum(1:35,16))
  M(4) = M(4) + (-(CI*f(20))/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,24),T3sum(1:35,16))
  M(10) = M(10) + ((CI*f(20))/6._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,24),T3sum(1:35,16))
  M(11) = M(11) + (-(CI*f(20))/6._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,24),T3sum(1:35,16))
  M(2) = M(2) + ((CI*f(20))/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,42),T3sum(1:35,16))
  M(5) = M(5) + (-(CI*f(20))/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,42),T3sum(1:35,16))
  M(10) = M(10) + ((CI*f(20))/6._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,42),T3sum(1:35,16))
  M(11) = M(11) + (-(CI*f(20))/6._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,42),T3sum(1:35,16))
  M(3) = M(3) + ((CI*f(20))/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,24),T3sum(1:35,16))
  M(4) = M(4) + (-(CI*f(20))/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,24),T3sum(1:35,16))
  M(10) = M(10) + ((CI*f(20))/6._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,24),T3sum(1:35,16))
  M(11) = M(11) + (-(CI*f(20))/6._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,24),T3sum(1:35,16))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,78),T3sum(1:35,16))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,78),T3sum(1:35,16))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,78),T3sum(1:35,16))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,78),T3sum(1:35,16))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,60),T3sum(1:35,16))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,60),T3sum(1:35,16))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,60),T3sum(1:35,16))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(38)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,60),T3sum(1:35,16))
  M(2) = M(2) + ((CI*f(16))/6._/**/REALKIND * den(245)) * TI2_call(2,momenta_57,masses2_6,G2tensor(:,17),T2sum(1:15,43))
  M(5) = M(5) + (-(CI*f(16))/6._/**/REALKIND * den(245)) * TI2_call(2,momenta_57,masses2_6,G2tensor(:,17),T2sum(1:15,43))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(245)) * TI2_call(2,momenta_97,masses2_9,G2tensor(:,30),T2sum(1:15,5))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(245)) * TI2_call(2,momenta_97,masses2_9,G2tensor(:,30),T2sum(1:15,5))
  M(2) = M(2) + ((CI*f(16))/6._/**/REALKIND * den(40)) * TI2_call(2,momenta_102,masses2_6,G2tensor(:,70),T2sum(1:15,26))
  M(5) = M(5) + (-(CI*f(16))/6._/**/REALKIND * den(40)) * TI2_call(2,momenta_102,masses2_6,G2tensor(:,70),T2sum(1:15,26))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(246)) * TI2_call(2,momenta_115,masses2_9,G2tensor(:,72),T2sum(1:15,2))
  M(3) = M(3) + ((-3*CI*f(16))/2._/**/REALKIND * den(246)) * TI2_call(2,momenta_115,masses2_9,G2tensor(:,72),T2sum(1:15,2))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND * den(246)) * TI2_call(2,momenta_115,masses2_9,G2tensor(:,72),T2sum(1:15,2))
  M(5) = M(5) + ((-3*CI*f(16))/2._/**/REALKIND * den(246)) * TI2_call(2,momenta_115,masses2_9,G2tensor(:,72),T2sum(1:15,2))
  M(3) = M(3) + ((CI*f(16))/6._/**/REALKIND * den(284)) * TI2_call(2,momenta_103,masses2_6,G2tensor(:,76),T2sum(1:15,44))
  M(4) = M(4) + (-(CI*f(16))/6._/**/REALKIND * den(284)) * TI2_call(2,momenta_103,masses2_6,G2tensor(:,76),T2sum(1:15,44))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(282)) * TI2_call(3,momenta_284,masses2_15,G3tensor(:,95),T3sum(1:35,18))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(282)) * TI2_call(3,momenta_284,masses2_15,G3tensor(:,95),T3sum(1:35,18))
  M(2) = M(2) + ((-3*CI*f(16))/2._/**/REALKIND * den(282)) * TI2_call(3,momenta_286,masses2_16,G3tensor(:,96),T3sum(1:35,19))
  M(5) = M(5) + ((3*CI*f(16))/2._/**/REALKIND * den(282)) * TI2_call(3,momenta_286,masses2_16,G3tensor(:,96),T3sum(1:35,19))
  M(10) = M(10) + ((CI*f(16))/2._/**/REALKIND * den(282)) * TI2_call(3,momenta_286,masses2_16,G3tensor(:,96),T3sum(1:35,19))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND * den(282)) * TI2_call(3,momenta_286,masses2_16,G3tensor(:,96),T3sum(1:35,19))
  M(4) = M(4) + ((CI*f(20))/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,147),T3sum(1:35,11))
  M(6) = M(6) + (-(CI*f(20))/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,147),T3sum(1:35,11))
  M(10) = M(10) + (-(CI*f(20))/6._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,147),T3sum(1:35,11))
  M(11) = M(11) + ((CI*f(20))/6._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,147),T3sum(1:35,11))
  M(1) = M(1) + ((CI*f(20))/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,149),T3sum(1:35,11))
  M(2) = M(2) + (-(CI*f(20))/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,149),T3sum(1:35,11))
  M(10) = M(10) + (-(CI*f(20))/6._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,149),T3sum(1:35,11))
  M(11) = M(11) + ((CI*f(20))/6._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,149),T3sum(1:35,11))
  M(4) = M(4) + ((CI*f(20))/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,147),T3sum(1:35,11))
  M(6) = M(6) + (-(CI*f(20))/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,147),T3sum(1:35,11))
  M(10) = M(10) + (-(CI*f(20))/6._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,147),T3sum(1:35,11))
  M(11) = M(11) + ((CI*f(20))/6._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,147),T3sum(1:35,11))
  M(1) = M(1) + ((CI*f(20))/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,149),T3sum(1:35,11))
  M(2) = M(2) + (-(CI*f(20))/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,149),T3sum(1:35,11))
  M(10) = M(10) + (-(CI*f(20))/6._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,149),T3sum(1:35,11))
  M(11) = M(11) + ((CI*f(20))/6._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,149),T3sum(1:35,11))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,151),T3sum(1:35,11))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,151),T3sum(1:35,11))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,151),T3sum(1:35,11))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,151),T3sum(1:35,11))
  M(1) = M(1) + ((-3*f(18))/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,153),T3sum(1:35,11))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,153),T3sum(1:35,11))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,153),T3sum(1:35,11))
  M(6) = M(6) + ((-3*f(18))/2._/**/REALKIND * den(41)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,153),T3sum(1:35,11))
  M(4) = M(4) + ((CI*f(16))/6._/**/REALKIND * den(247)) * TI2_call(2,momenta_34,masses2_6,G2tensor(:,77),T2sum(1:15,46))
  M(6) = M(6) + (-(CI*f(16))/6._/**/REALKIND * den(247)) * TI2_call(2,momenta_34,masses2_6,G2tensor(:,77),T2sum(1:15,46))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(247)) * TI2_call(2,momenta_107,masses2_9,G2tensor(:,2),T2sum(1:15,3))
  M(6) = M(6) + ((-3*f(18))/2._/**/REALKIND * den(247)) * TI2_call(2,momenta_107,masses2_9,G2tensor(:,2),T2sum(1:15,3))
  M(4) = M(4) + ((CI*f(16))/6._/**/REALKIND * den(44)) * TI2_call(2,momenta_112,masses2_6,G2tensor(:,78),T2sum(1:15,33))
  M(6) = M(6) + (-(CI*f(16))/6._/**/REALKIND * den(44)) * TI2_call(2,momenta_112,masses2_6,G2tensor(:,78),T2sum(1:15,33))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(248)) * TI2_call(2,momenta_115,masses2_9,G2tensor(:,80),T2sum(1:15,2))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(248)) * TI2_call(2,momenta_115,masses2_9,G2tensor(:,80),T2sum(1:15,2))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND * den(248)) * TI2_call(2,momenta_115,masses2_9,G2tensor(:,80),T2sum(1:15,2))
  M(6) = M(6) + ((-3*CI*f(16))/2._/**/REALKIND * den(248)) * TI2_call(2,momenta_115,masses2_9,G2tensor(:,80),T2sum(1:15,2))
  M(1) = M(1) + ((CI*f(16))/6._/**/REALKIND * den(266)) * TI2_call(2,momenta_113,masses2_6,G2tensor(:,84),T2sum(1:15,47))
  M(2) = M(2) + (-(CI*f(16))/6._/**/REALKIND * den(266)) * TI2_call(2,momenta_113,masses2_6,G2tensor(:,84),T2sum(1:15,47))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(264)) * TI2_call(3,momenta_294,masses2_15,G3tensor(:,2),T3sum(1:35,13))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(264)) * TI2_call(3,momenta_294,masses2_15,G3tensor(:,2),T3sum(1:35,13))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(264)) * TI2_call(3,momenta_296,masses2_16,G3tensor(:,3),T3sum(1:35,14))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(264)) * TI2_call(3,momenta_296,masses2_16,G3tensor(:,3),T3sum(1:35,14))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(264)) * TI2_call(3,momenta_296,masses2_16,G3tensor(:,3),T3sum(1:35,14))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(264)) * TI2_call(3,momenta_296,masses2_16,G3tensor(:,3),T3sum(1:35,14))
  M(1) = M(1) + ((CI*f(20))/2._/**/REALKIND * den(473)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,16),T3sum(1:35,15))
  M(4) = M(4) + (-(CI*f(20))/2._/**/REALKIND * den(473)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,16),T3sum(1:35,15))
  M(2) = M(2) + ((CI*f(20))/2._/**/REALKIND * den(473)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,34),T3sum(1:35,15))
  M(6) = M(6) + (-(CI*f(20))/2._/**/REALKIND * den(473)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,34),T3sum(1:35,15))
  M(1) = M(1) + ((CI*f(20))/2._/**/REALKIND * den(473)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,16),T3sum(1:35,15))
  M(4) = M(4) + (-(CI*f(20))/2._/**/REALKIND * den(473)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,16),T3sum(1:35,15))
  M(2) = M(2) + ((CI*f(20))/2._/**/REALKIND * den(473)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,34),T3sum(1:35,15))
  M(6) = M(6) + (-(CI*f(20))/2._/**/REALKIND * den(473)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,34),T3sum(1:35,15))
  M(1) = M(1) + ((-3*f(18))/2._/**/REALKIND * den(473)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,52),T3sum(1:35,15))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(473)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,52),T3sum(1:35,15))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(473)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,52),T3sum(1:35,15))
  M(6) = M(6) + ((-3*f(18))/2._/**/REALKIND * den(473)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,52),T3sum(1:35,15))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(473)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,70),T3sum(1:35,15))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(473)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,70),T3sum(1:35,15))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(473)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,70),T3sum(1:35,15))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(473)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,70),T3sum(1:35,15))
  M(2) = M(2) + (-(CI*f(20))/2._/**/REALKIND * den(474)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,160),T3sum(1:35,10))
  M(3) = M(3) + ((CI*f(20))/2._/**/REALKIND * den(474)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,160),T3sum(1:35,10))
  M(2) = M(2) + (-(CI*f(19))/2._/**/REALKIND * den(474)) * TI2_call(3,momenta_61,masses2_8,G3tensor(:,161),T3sum(1:35,56))
  M(3) = M(3) + ((CI*f(19))/2._/**/REALKIND * den(474)) * TI2_call(3,momenta_61,masses2_8,G3tensor(:,161),T3sum(1:35,56))
  M(4) = M(4) + ((CI*f(20))/2._/**/REALKIND * den(474)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,162),T3sum(1:35,10))
  M(5) = M(5) + (-(CI*f(20))/2._/**/REALKIND * den(474)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,162),T3sum(1:35,10))
  M(4) = M(4) + ((CI*f(19))/2._/**/REALKIND * den(474)) * TI2_call(3,momenta_61,masses2_8,G3tensor(:,163),T3sum(1:35,56))
  M(5) = M(5) + (-(CI*f(19))/2._/**/REALKIND * den(474)) * TI2_call(3,momenta_61,masses2_8,G3tensor(:,163),T3sum(1:35,56))
  M(2) = M(2) + (-(CI*f(20))/2._/**/REALKIND * den(474)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,160),T3sum(1:35,10))
  M(3) = M(3) + ((CI*f(20))/2._/**/REALKIND * den(474)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,160),T3sum(1:35,10))
  M(2) = M(2) + (-(CI*f(19))/2._/**/REALKIND * den(474)) * TI2_call(3,momenta_61,masses2_5,G3tensor(:,164),T3sum(1:35,57))
  M(3) = M(3) + ((CI*f(19))/2._/**/REALKIND * den(474)) * TI2_call(3,momenta_61,masses2_5,G3tensor(:,164),T3sum(1:35,57))
  M(4) = M(4) + ((CI*f(20))/2._/**/REALKIND * den(474)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,162),T3sum(1:35,10))
  M(5) = M(5) + (-(CI*f(20))/2._/**/REALKIND * den(474)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,162),T3sum(1:35,10))
  M(4) = M(4) + ((CI*f(19))/2._/**/REALKIND * den(474)) * TI2_call(3,momenta_61,masses2_5,G3tensor(:,165),T3sum(1:35,57))
  M(5) = M(5) + (-(CI*f(19))/2._/**/REALKIND * den(474)) * TI2_call(3,momenta_61,masses2_5,G3tensor(:,165),T3sum(1:35,57))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(474)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,166),T3sum(1:35,10))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(474)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,166),T3sum(1:35,10))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(474)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,166),T3sum(1:35,10))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(474)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,166),T3sum(1:35,10))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(474)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,167),T3sum(1:35,10))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(474)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,167),T3sum(1:35,10))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(474)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,167),T3sum(1:35,10))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(474)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,167),T3sum(1:35,10))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(474)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,168),T3sum(1:35,10))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(474)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,168),T3sum(1:35,10))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(474)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,168),T3sum(1:35,10))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(474)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,168),T3sum(1:35,10))
  M(1) = M(1) + (-(CI*f(20))/2._/**/REALKIND * den(475)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,26),T3sum(1:35,9))
  M(5) = M(5) + ((CI*f(20))/2._/**/REALKIND * den(475)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,26),T3sum(1:35,9))
  M(3) = M(3) + (-(CI*f(20))/2._/**/REALKIND * den(475)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,44),T3sum(1:35,9))
  M(6) = M(6) + ((CI*f(20))/2._/**/REALKIND * den(475)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,44),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(20))/2._/**/REALKIND * den(475)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,26),T3sum(1:35,9))
  M(5) = M(5) + ((CI*f(20))/2._/**/REALKIND * den(475)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,26),T3sum(1:35,9))
  M(3) = M(3) + (-(CI*f(20))/2._/**/REALKIND * den(475)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,44),T3sum(1:35,9))
  M(6) = M(6) + ((CI*f(20))/2._/**/REALKIND * den(475)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,44),T3sum(1:35,9))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(475)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,62),T3sum(1:35,9))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(475)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,62),T3sum(1:35,9))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(475)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,62),T3sum(1:35,9))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(475)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,62),T3sum(1:35,9))
  M(1) = M(1) + ((-3*f(18))/2._/**/REALKIND * den(475)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,80),T3sum(1:35,9))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(475)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,80),T3sum(1:35,9))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(475)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,80),T3sum(1:35,9))
  M(6) = M(6) + ((-3*f(18))/2._/**/REALKIND * den(475)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,80),T3sum(1:35,9))
  M(5) = M(5) + (-(f(22)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,6),T4sum(1:70,49))
  M(10) = M(10) + (f(22)/6._/**/REALKIND * den(30)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,6),T4sum(1:70,49))
  M(3) = M(3) + (-(f(22)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,4),T4sum(1:70,49))
  M(11) = M(11) + (f(22)/6._/**/REALKIND * den(30)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,4),T4sum(1:70,49))
  M(5) = M(5) + (-(f(22)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,6),T4sum(1:70,49))
  M(10) = M(10) + (f(22)/6._/**/REALKIND * den(30)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,6),T4sum(1:70,49))
  M(3) = M(3) + (-(f(22)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,4),T4sum(1:70,49))
  M(11) = M(11) + (f(22)/6._/**/REALKIND * den(30)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,4),T4sum(1:70,49))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,10),T4sum(1:70,49))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,10),T4sum(1:70,49))
  M(7) = M(7) + (-f(18) * den(30)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,10),T4sum(1:70,49))
  M(8) = M(8) + (-f(18) * den(30)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,10),T4sum(1:70,49))
  M(9) = M(9) + (-f(18) * den(30)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,10),T4sum(1:70,49))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,10),T4sum(1:70,49))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,10),T4sum(1:70,49))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,8),T4sum(1:70,49))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,8),T4sum(1:70,49))
  M(7) = M(7) + (-f(18) * den(30)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,8),T4sum(1:70,49))
  M(8) = M(8) + (-f(18) * den(30)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,8),T4sum(1:70,49))
  M(9) = M(9) + (-f(18) * den(30)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,8),T4sum(1:70,49))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,8),T4sum(1:70,49))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,8),T4sum(1:70,49))
  M(1) = M(1) + (-(f(22)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,34),T4sum(1:70,52))
  M(10) = M(10) + (f(22)/6._/**/REALKIND * den(30)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,34),T4sum(1:70,52))
  M(6) = M(6) + (-(f(22)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,30),T4sum(1:70,52))
  M(11) = M(11) + (f(22)/6._/**/REALKIND * den(30)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,30),T4sum(1:70,52))
  M(1) = M(1) + (-(f(22)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,34),T4sum(1:70,52))
  M(10) = M(10) + (f(22)/6._/**/REALKIND * den(30)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,34),T4sum(1:70,52))
  M(6) = M(6) + (-(f(22)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,30),T4sum(1:70,52))
  M(11) = M(11) + (f(22)/6._/**/REALKIND * den(30)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,30),T4sum(1:70,52))
  M(1) = M(1) + ((-3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,42),T4sum(1:70,52))
  M(6) = M(6) + ((-3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,42),T4sum(1:70,52))
  M(7) = M(7) + (-f(18) * den(30)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,42),T4sum(1:70,52))
  M(8) = M(8) + (-f(18) * den(30)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,42),T4sum(1:70,52))
  M(9) = M(9) + (-f(18) * den(30)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,42),T4sum(1:70,52))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,42),T4sum(1:70,52))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,42),T4sum(1:70,52))
  M(1) = M(1) + ((-3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,38),T4sum(1:70,52))
  M(6) = M(6) + ((-3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,38),T4sum(1:70,52))
  M(7) = M(7) + (-f(18) * den(30)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,38),T4sum(1:70,52))
  M(8) = M(8) + (-f(18) * den(30)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,38),T4sum(1:70,52))
  M(9) = M(9) + (-f(18) * den(30)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,38),T4sum(1:70,52))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,38),T4sum(1:70,52))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,38),T4sum(1:70,52))
  M(2) = M(2) + (-(f(22)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,36),T4sum(1:70,55))
  M(11) = M(11) + (f(22)/6._/**/REALKIND * den(30)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,36),T4sum(1:70,55))
  M(4) = M(4) + (-(f(22)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,32),T4sum(1:70,55))
  M(10) = M(10) + (f(22)/6._/**/REALKIND * den(30)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,32),T4sum(1:70,55))
  M(2) = M(2) + (-(f(22)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,36),T4sum(1:70,55))
  M(11) = M(11) + (f(22)/6._/**/REALKIND * den(30)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,36),T4sum(1:70,55))
  M(4) = M(4) + (-(f(22)/2._/**/REALKIND) * den(30)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,32),T4sum(1:70,55))
  M(10) = M(10) + (f(22)/6._/**/REALKIND * den(30)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,32),T4sum(1:70,55))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,44),T4sum(1:70,55))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,44),T4sum(1:70,55))
  M(7) = M(7) + (-f(18) * den(30)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,44),T4sum(1:70,55))
  M(8) = M(8) + (-f(18) * den(30)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,44),T4sum(1:70,55))
  M(9) = M(9) + (-f(18) * den(30)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,44),T4sum(1:70,55))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,44),T4sum(1:70,55))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,44),T4sum(1:70,55))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,40),T4sum(1:70,55))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,40),T4sum(1:70,55))
  M(7) = M(7) + (-f(18) * den(30)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,40),T4sum(1:70,55))
  M(8) = M(8) + (-f(18) * den(30)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,40),T4sum(1:70,55))
  M(9) = M(9) + (-f(18) * den(30)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,40),T4sum(1:70,55))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,40),T4sum(1:70,55))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(30)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,40),T4sum(1:70,55))
  M(4) = M(4) + (-(f(22)/2._/**/REALKIND) * den(476)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,17),T3sum(1:35,15))
  M(9) = M(9) + (f(22)/6._/**/REALKIND * den(476)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,17),T3sum(1:35,15))
  M(6) = M(6) + (-(f(22)/2._/**/REALKIND) * den(476)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,35),T3sum(1:35,15))
  M(9) = M(9) + (f(22)/6._/**/REALKIND * den(476)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,35),T3sum(1:35,15))
  M(4) = M(4) + (-(f(22)/2._/**/REALKIND) * den(476)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,17),T3sum(1:35,15))
  M(9) = M(9) + (f(22)/6._/**/REALKIND * den(476)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,17),T3sum(1:35,15))
  M(6) = M(6) + (-(f(22)/2._/**/REALKIND) * den(476)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,35),T3sum(1:35,15))
  M(9) = M(9) + (f(22)/6._/**/REALKIND * den(476)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,35),T3sum(1:35,15))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND * den(476)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,53),T3sum(1:35,15))
  M(6) = M(6) + ((-3*CI*f(16))/2._/**/REALKIND * den(476)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,53),T3sum(1:35,15))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(476)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,71),T3sum(1:35,15))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(476)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,71),T3sum(1:35,15))
  M(6) = M(6) + (-(f(18)/6._/**/REALKIND) * den(477)) * TI2_call(2,momenta_71,masses2_6,G2tensor(:,85),T2sum(1:15,37))
  M(4) = M(4) + (-(f(18)/6._/**/REALKIND) * den(478)) * TI2_call(2,momenta_103,masses2_6,G2tensor(:,86),T2sum(1:15,44))
  M(4) = M(4) + (-(f(18)/6._/**/REALKIND) * den(21)) * TI2_call(3,momenta_179,masses2_12,G3tensor(:,155),T3sum(1:35,89))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(21)) * TI2_call(3,momenta_179,masses2_12,G3tensor(:,155),T3sum(1:35,89))
  M(6) = M(6) + (-(f(18)/6._/**/REALKIND) * den(21)) * TI2_call(3,momenta_178,masses2_12,G3tensor(:,156),T3sum(1:35,91))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(21)) * TI2_call(3,momenta_178,masses2_12,G3tensor(:,156),T3sum(1:35,91))
  M(2) = M(2) + (-(f(22)/2._/**/REALKIND) * den(479)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,169),T3sum(1:35,10))
  M(8) = M(8) + (f(22)/6._/**/REALKIND * den(479)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,169),T3sum(1:35,10))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(479)) * TI2_call(3,momenta_61,masses2_8,G3tensor(:,170),T3sum(1:35,56))
  M(8) = M(8) + (f(21)/6._/**/REALKIND * den(479)) * TI2_call(3,momenta_61,masses2_8,G3tensor(:,170),T3sum(1:35,56))
  M(5) = M(5) + (-(f(22)/2._/**/REALKIND) * den(479)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,171),T3sum(1:35,10))
  M(8) = M(8) + (f(22)/6._/**/REALKIND * den(479)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,171),T3sum(1:35,10))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(479)) * TI2_call(3,momenta_61,masses2_8,G3tensor(:,172),T3sum(1:35,56))
  M(8) = M(8) + (f(21)/6._/**/REALKIND * den(479)) * TI2_call(3,momenta_61,masses2_8,G3tensor(:,172),T3sum(1:35,56))
  M(2) = M(2) + (-(f(22)/2._/**/REALKIND) * den(479)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,169),T3sum(1:35,10))
  M(8) = M(8) + (f(22)/6._/**/REALKIND * den(479)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,169),T3sum(1:35,10))
  M(2) = M(2) + (-(f(21)/2._/**/REALKIND) * den(479)) * TI2_call(3,momenta_61,masses2_5,G3tensor(:,173),T3sum(1:35,57))
  M(8) = M(8) + (f(21)/6._/**/REALKIND * den(479)) * TI2_call(3,momenta_61,masses2_5,G3tensor(:,173),T3sum(1:35,57))
  M(5) = M(5) + (-(f(22)/2._/**/REALKIND) * den(479)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,171),T3sum(1:35,10))
  M(8) = M(8) + (f(22)/6._/**/REALKIND * den(479)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,171),T3sum(1:35,10))
  M(5) = M(5) + (-(f(21)/2._/**/REALKIND) * den(479)) * TI2_call(3,momenta_61,masses2_5,G3tensor(:,174),T3sum(1:35,57))
  M(8) = M(8) + (f(21)/6._/**/REALKIND * den(479)) * TI2_call(3,momenta_61,masses2_5,G3tensor(:,174),T3sum(1:35,57))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(479)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,175),T3sum(1:35,10))
  M(5) = M(5) + ((-3*CI*f(16))/2._/**/REALKIND * den(479)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,175),T3sum(1:35,10))
  M(2) = M(2) + ((-3*CI*f(16))/2._/**/REALKIND * den(479)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,176),T3sum(1:35,10))
  M(5) = M(5) + ((3*CI*f(16))/2._/**/REALKIND * den(479)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,176),T3sum(1:35,10))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(479)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,177),T3sum(1:35,10))
  M(5) = M(5) + ((-3*CI*f(16))/2._/**/REALKIND * den(479)) * TI2_call(3,momenta_61,masses2_10,G3tensor(:,177),T3sum(1:35,10))
  M(5) = M(5) + (-(f(18)/6._/**/REALKIND) * den(480)) * TI2_call(2,momenta_71,masses2_6,G2tensor(:,87),T2sum(1:15,37))
  M(2) = M(2) + (-(f(18)/6._/**/REALKIND) * den(481)) * TI2_call(2,momenta_113,masses2_6,G2tensor(:,88),T2sum(1:15,47))
  M(2) = M(2) + (-(f(18)/6._/**/REALKIND) * den(11)) * TI2_call(3,momenta_226,masses2_12,G3tensor(:,7),T3sum(1:35,95))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(11)) * TI2_call(3,momenta_226,masses2_12,G3tensor(:,7),T3sum(1:35,95))
  M(5) = M(5) + (-(f(18)/6._/**/REALKIND) * den(11)) * TI2_call(3,momenta_225,masses2_12,G3tensor(:,8),T3sum(1:35,97))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(11)) * TI2_call(3,momenta_225,masses2_12,G3tensor(:,8),T3sum(1:35,97))
  M(1) = M(1) + (-(f(22)/2._/**/REALKIND) * den(482)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,27),T3sum(1:35,9))
  M(7) = M(7) + (f(22)/6._/**/REALKIND * den(482)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,27),T3sum(1:35,9))
  M(3) = M(3) + (-(f(22)/2._/**/REALKIND) * den(482)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,45),T3sum(1:35,9))
  M(7) = M(7) + (f(22)/6._/**/REALKIND * den(482)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,45),T3sum(1:35,9))
  M(1) = M(1) + (-(f(22)/2._/**/REALKIND) * den(482)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,27),T3sum(1:35,9))
  M(7) = M(7) + (f(22)/6._/**/REALKIND * den(482)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,27),T3sum(1:35,9))
  M(3) = M(3) + (-(f(22)/2._/**/REALKIND) * den(482)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,45),T3sum(1:35,9))
  M(7) = M(7) + (f(22)/6._/**/REALKIND * den(482)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,45),T3sum(1:35,9))
  M(1) = M(1) + ((3*CI*f(16))/2._/**/REALKIND * den(482)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,63),T3sum(1:35,9))
  M(3) = M(3) + ((-3*CI*f(16))/2._/**/REALKIND * den(482)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,63),T3sum(1:35,9))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(482)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,81),T3sum(1:35,9))
  M(3) = M(3) + ((3*CI*f(16))/2._/**/REALKIND * den(482)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,81),T3sum(1:35,9))
  M(3) = M(3) + (-(f(18)/6._/**/REALKIND) * den(483)) * TI2_call(2,momenta_103,masses2_6,G2tensor(:,89),T2sum(1:15,44))
  M(1) = M(1) + (-(f(18)/6._/**/REALKIND) * den(484)) * TI2_call(2,momenta_113,masses2_6,G2tensor(:,90),T2sum(1:15,47))
  M(1) = M(1) + (-(f(18)/6._/**/REALKIND) * den(143)) * TI2_call(3,momenta_281,masses2_12,G3tensor(:,9),T3sum(1:35,101))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(143)) * TI2_call(3,momenta_281,masses2_12,G3tensor(:,9),T3sum(1:35,101))
  M(3) = M(3) + (-(f(18)/6._/**/REALKIND) * den(143)) * TI2_call(3,momenta_280,masses2_12,G3tensor(:,10),T3sum(1:35,103))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(143)) * TI2_call(3,momenta_280,masses2_12,G3tensor(:,10),T3sum(1:35,103))
  M(4) = M(4) + ((CI*f(16))/6._/**/REALKIND * den(596)) * TI2_call(2,momenta_31,masses2_6,G2tensor(:,91),T2sum(1:15,49))
  M(6) = M(6) + (-(CI*f(16))/6._/**/REALKIND * den(596)) * TI2_call(2,momenta_31,masses2_6,G2tensor(:,91),T2sum(1:15,49))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(596)) * TI2_call(2,momenta_105,masses2_9,G2tensor(:,3),T2sum(1:15,9))
  M(6) = M(6) + ((-3*f(18))/2._/**/REALKIND * den(596)) * TI2_call(2,momenta_105,masses2_9,G2tensor(:,3),T2sum(1:15,9))
  M(6) = M(6) + (-(f(18)/6._/**/REALKIND) * den(50)) * TI2_call(2,momenta_68,masses2_6,G2tensor(:,92),T2sum(1:15,50))
  M(4) = M(4) + (-(f(18)/6._/**/REALKIND) * den(158)) * TI2_call(2,momenta_100,masses2_6,G2tensor(:,93),T2sum(1:15,52))
  M(4) = M(4) + (-(f(18)/6._/**/REALKIND) * den(53)) * TI2_call(2,momenta_58,masses2_6,G2tensor(:,95),T2sum(1:15,54))
  M(6) = M(6) + (-(f(18)/6._/**/REALKIND) * den(160)) * TI2_call(2,momenta_93,masses2_6,G2tensor(:,98),T2sum(1:15,56))
  M(4) = M(4) + (-(f(22)/2._/**/REALKIND) * den(341)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,18),T3sum(1:35,15))
  M(9) = M(9) + (f(22)/6._/**/REALKIND * den(341)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,18),T3sum(1:35,15))
  M(6) = M(6) + (-(f(22)/2._/**/REALKIND) * den(341)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,36),T3sum(1:35,15))
  M(9) = M(9) + (f(22)/6._/**/REALKIND * den(341)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,36),T3sum(1:35,15))
  M(4) = M(4) + (-(f(22)/2._/**/REALKIND) * den(341)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,18),T3sum(1:35,15))
  M(9) = M(9) + (f(22)/6._/**/REALKIND * den(341)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,18),T3sum(1:35,15))
  M(6) = M(6) + (-(f(22)/2._/**/REALKIND) * den(341)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,36),T3sum(1:35,15))
  M(9) = M(9) + (f(22)/6._/**/REALKIND * den(341)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,36),T3sum(1:35,15))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND * den(341)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,54),T3sum(1:35,15))
  M(6) = M(6) + ((-3*CI*f(16))/2._/**/REALKIND * den(341)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,54),T3sum(1:35,15))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(341)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,72),T3sum(1:35,15))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(341)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,72),T3sum(1:35,15))
  M(6) = M(6) + (-(f(18)/6._/**/REALKIND) * den(46)) * TI2_call(3,momenta_169,masses2_12,G3tensor(:,179),T3sum(1:35,105))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(46)) * TI2_call(3,momenta_169,masses2_12,G3tensor(:,179),T3sum(1:35,105))
  M(4) = M(4) + (-(f(18)/6._/**/REALKIND) * den(46)) * TI2_call(3,momenta_170,masses2_12,G3tensor(:,180),T3sum(1:35,107))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(46)) * TI2_call(3,momenta_170,masses2_12,G3tensor(:,180),T3sum(1:35,107))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(597)) * TI2_call(2,momenta_95,masses2_9,G2tensor(:,31),T2sum(1:15,12))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(597)) * TI2_call(2,momenta_95,masses2_9,G2tensor(:,31),T2sum(1:15,12))
  M(5) = M(5) + (-(f(18)/6._/**/REALKIND) * den(167)) * TI2_call(2,momenta_92,masses2_6,G2tensor(:,99),T2sum(1:15,63))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(598)) * TI2_call(2,momenta_63,masses2_9,G2tensor(:,56),T2sum(1:15,14))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(598)) * TI2_call(2,momenta_63,masses2_9,G2tensor(:,56),T2sum(1:15,14))
  M(1) = M(1) + ((CI*f(20))/2._/**/REALKIND * den(66)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,130),T3sum(1:35,20))
  M(3) = M(3) + (-(CI*f(20))/2._/**/REALKIND * den(66)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,130),T3sum(1:35,20))
  M(10) = M(10) + (-(CI*f(20))/6._/**/REALKIND * den(66)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,130),T3sum(1:35,20))
  M(11) = M(11) + ((CI*f(20))/6._/**/REALKIND * den(66)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,130),T3sum(1:35,20))
  M(5) = M(5) + ((CI*f(20))/2._/**/REALKIND * den(66)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,132),T3sum(1:35,20))
  M(6) = M(6) + (-(CI*f(20))/2._/**/REALKIND * den(66)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,132),T3sum(1:35,20))
  M(10) = M(10) + (-(CI*f(20))/6._/**/REALKIND * den(66)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,132),T3sum(1:35,20))
  M(11) = M(11) + ((CI*f(20))/6._/**/REALKIND * den(66)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,132),T3sum(1:35,20))
  M(1) = M(1) + ((CI*f(20))/2._/**/REALKIND * den(66)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,130),T3sum(1:35,20))
  M(3) = M(3) + (-(CI*f(20))/2._/**/REALKIND * den(66)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,130),T3sum(1:35,20))
  M(10) = M(10) + (-(CI*f(20))/6._/**/REALKIND * den(66)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,130),T3sum(1:35,20))
  M(11) = M(11) + ((CI*f(20))/6._/**/REALKIND * den(66)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,130),T3sum(1:35,20))
  M(5) = M(5) + ((CI*f(20))/2._/**/REALKIND * den(66)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,132),T3sum(1:35,20))
  M(6) = M(6) + (-(CI*f(20))/2._/**/REALKIND * den(66)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,132),T3sum(1:35,20))
  M(10) = M(10) + (-(CI*f(20))/6._/**/REALKIND * den(66)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,132),T3sum(1:35,20))
  M(11) = M(11) + ((CI*f(20))/6._/**/REALKIND * den(66)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,132),T3sum(1:35,20))
  M(1) = M(1) + ((-3*f(18))/2._/**/REALKIND * den(66)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,134),T3sum(1:35,20))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(66)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,134),T3sum(1:35,20))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(66)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,134),T3sum(1:35,20))
  M(6) = M(6) + ((-3*f(18))/2._/**/REALKIND * den(66)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,134),T3sum(1:35,20))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(66)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,136),T3sum(1:35,20))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(66)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,136),T3sum(1:35,20))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(66)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,136),T3sum(1:35,20))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(66)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,136),T3sum(1:35,20))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(66)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,124),T3sum(1:35,20))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(66)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,124),T3sum(1:35,20))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(66)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,124),T3sum(1:35,20))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(66)) * TI2_call(3,momenta_62,masses2_10,G3tensor(:,124),T3sum(1:35,20))
  M(5) = M(5) + ((CI*f(16))/6._/**/REALKIND * den(253)) * TI2_call(2,momenta_94,masses2_6,G2tensor(:,100),T2sum(1:15,66))
  M(6) = M(6) + (-(CI*f(16))/6._/**/REALKIND * den(253)) * TI2_call(2,momenta_94,masses2_6,G2tensor(:,100),T2sum(1:15,66))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(253)) * TI2_call(2,momenta_67,masses2_9,G2tensor(:,57),T2sum(1:15,15))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(253)) * TI2_call(2,momenta_67,masses2_9,G2tensor(:,57),T2sum(1:15,15))
  M(1) = M(1) + ((3*CI*f(16))/2._/**/REALKIND * den(252)) * TI2_call(2,momenta_116,masses2_9,G2tensor(:,62),T2sum(1:15,10))
  M(3) = M(3) + ((-3*CI*f(16))/2._/**/REALKIND * den(252)) * TI2_call(2,momenta_116,masses2_9,G2tensor(:,62),T2sum(1:15,10))
  M(5) = M(5) + ((-3*CI*f(16))/2._/**/REALKIND * den(252)) * TI2_call(2,momenta_116,masses2_9,G2tensor(:,62),T2sum(1:15,10))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(252)) * TI2_call(2,momenta_116,masses2_9,G2tensor(:,62),T2sum(1:15,10))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(367)) * TI2_call(3,momenta_231,masses2_15,G3tensor(:,128),T3sum(1:35,31))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(367)) * TI2_call(3,momenta_231,masses2_15,G3tensor(:,128),T3sum(1:35,31))
  M(5) = M(5) + ((-3*CI*f(16))/2._/**/REALKIND * den(367)) * TI2_call(3,momenta_233,masses2_16,G3tensor(:,125),T3sum(1:35,32))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(367)) * TI2_call(3,momenta_233,masses2_16,G3tensor(:,125),T3sum(1:35,32))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(367)) * TI2_call(3,momenta_233,masses2_16,G3tensor(:,125),T3sum(1:35,32))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(367)) * TI2_call(3,momenta_233,masses2_16,G3tensor(:,125),T3sum(1:35,32))
  M(3) = M(3) + ((3*CI*f(16))/2._/**/REALKIND * den(170)) * TI2_call(2,momenta_59,masses2_7,G2tensor(:,96),T2sum(1:15,72))
  M(1) = M(1) + (-(f(22)/2._/**/REALKIND) * den(374)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,28),T3sum(1:35,9))
  M(7) = M(7) + (f(22)/6._/**/REALKIND * den(374)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,28),T3sum(1:35,9))
  M(3) = M(3) + (-(f(22)/2._/**/REALKIND) * den(374)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,46),T3sum(1:35,9))
  M(7) = M(7) + (f(22)/6._/**/REALKIND * den(374)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,46),T3sum(1:35,9))
  M(1) = M(1) + (-(f(22)/2._/**/REALKIND) * den(374)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,28),T3sum(1:35,9))
  M(7) = M(7) + (f(22)/6._/**/REALKIND * den(374)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,28),T3sum(1:35,9))
  M(3) = M(3) + (-(f(22)/2._/**/REALKIND) * den(374)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,46),T3sum(1:35,9))
  M(7) = M(7) + (f(22)/6._/**/REALKIND * den(374)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,46),T3sum(1:35,9))
  M(1) = M(1) + ((3*CI*f(16))/2._/**/REALKIND * den(374)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,64),T3sum(1:35,9))
  M(3) = M(3) + ((-3*CI*f(16))/2._/**/REALKIND * den(374)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,64),T3sum(1:35,9))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(374)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,82),T3sum(1:35,9))
  M(3) = M(3) + ((3*CI*f(16))/2._/**/REALKIND * den(374)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,82),T3sum(1:35,9))
  M(2) = M(2) + ((CI*f(20))/2._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,43),T3sum(1:35,16))
  M(5) = M(5) + (-(CI*f(20))/2._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,43),T3sum(1:35,16))
  M(10) = M(10) + ((CI*f(20))/6._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,43),T3sum(1:35,16))
  M(11) = M(11) + (-(CI*f(20))/6._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,43),T3sum(1:35,16))
  M(3) = M(3) + ((CI*f(20))/2._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,25),T3sum(1:35,16))
  M(4) = M(4) + (-(CI*f(20))/2._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,25),T3sum(1:35,16))
  M(10) = M(10) + ((CI*f(20))/6._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,25),T3sum(1:35,16))
  M(11) = M(11) + (-(CI*f(20))/6._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,25),T3sum(1:35,16))
  M(2) = M(2) + ((CI*f(20))/2._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,43),T3sum(1:35,16))
  M(5) = M(5) + (-(CI*f(20))/2._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,43),T3sum(1:35,16))
  M(10) = M(10) + ((CI*f(20))/6._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,43),T3sum(1:35,16))
  M(11) = M(11) + (-(CI*f(20))/6._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,43),T3sum(1:35,16))
  M(3) = M(3) + ((CI*f(20))/2._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,25),T3sum(1:35,16))
  M(4) = M(4) + (-(CI*f(20))/2._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,25),T3sum(1:35,16))
  M(10) = M(10) + ((CI*f(20))/6._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,25),T3sum(1:35,16))
  M(11) = M(11) + (-(CI*f(20))/6._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,25),T3sum(1:35,16))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,79),T3sum(1:35,16))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,79),T3sum(1:35,16))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,79),T3sum(1:35,16))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,79),T3sum(1:35,16))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,61),T3sum(1:35,16))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,61),T3sum(1:35,16))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,61),T3sum(1:35,16))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(73)) * TI2_call(3,momenta_42,masses2_10,G3tensor(:,61),T3sum(1:35,16))
  M(3) = M(3) + ((CI*f(16))/6._/**/REALKIND * den(255)) * TI2_call(2,momenta_60,masses2_6,G2tensor(:,97),T2sum(1:15,73))
  M(4) = M(4) + (-(CI*f(16))/6._/**/REALKIND * den(255)) * TI2_call(2,momenta_60,masses2_6,G2tensor(:,97),T2sum(1:15,73))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(255)) * TI2_call(2,momenta_98,masses2_9,G2tensor(:,32),T2sum(1:15,13))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(255)) * TI2_call(2,momenta_98,masses2_9,G2tensor(:,32),T2sum(1:15,13))
  M(2) = M(2) + ((-3*CI*f(16))/2._/**/REALKIND * den(254)) * TI2_call(2,momenta_116,masses2_9,G2tensor(:,73),T2sum(1:15,10))
  M(3) = M(3) + ((3*CI*f(16))/2._/**/REALKIND * den(254)) * TI2_call(2,momenta_116,masses2_9,G2tensor(:,73),T2sum(1:15,10))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(254)) * TI2_call(2,momenta_116,masses2_9,G2tensor(:,73),T2sum(1:15,10))
  M(5) = M(5) + ((3*CI*f(16))/2._/**/REALKIND * den(254)) * TI2_call(2,momenta_116,masses2_9,G2tensor(:,73),T2sum(1:15,10))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(351)) * TI2_call(3,momenta_285,masses2_15,G3tensor(:,99),T3sum(1:35,28))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(351)) * TI2_call(3,momenta_285,masses2_15,G3tensor(:,99),T3sum(1:35,28))
  M(3) = M(3) + ((-3*CI*f(16))/2._/**/REALKIND * den(351)) * TI2_call(3,momenta_287,masses2_16,G3tensor(:,97),T3sum(1:35,29))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND * den(351)) * TI2_call(3,momenta_287,masses2_16,G3tensor(:,97),T3sum(1:35,29))
  M(10) = M(10) + ((CI*f(16))/2._/**/REALKIND * den(351)) * TI2_call(3,momenta_287,masses2_16,G3tensor(:,97),T3sum(1:35,29))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND * den(351)) * TI2_call(3,momenta_287,masses2_16,G3tensor(:,97),T3sum(1:35,29))
  M(4) = M(4) + ((CI*f(20))/2._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,148),T3sum(1:35,11))
  M(6) = M(6) + (-(CI*f(20))/2._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,148),T3sum(1:35,11))
  M(10) = M(10) + (-(CI*f(20))/6._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,148),T3sum(1:35,11))
  M(11) = M(11) + ((CI*f(20))/6._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,148),T3sum(1:35,11))
  M(1) = M(1) + ((CI*f(20))/2._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,150),T3sum(1:35,11))
  M(2) = M(2) + (-(CI*f(20))/2._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,150),T3sum(1:35,11))
  M(10) = M(10) + (-(CI*f(20))/6._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,150),T3sum(1:35,11))
  M(11) = M(11) + ((CI*f(20))/6._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,150),T3sum(1:35,11))
  M(4) = M(4) + ((CI*f(20))/2._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,148),T3sum(1:35,11))
  M(6) = M(6) + (-(CI*f(20))/2._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,148),T3sum(1:35,11))
  M(10) = M(10) + (-(CI*f(20))/6._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,148),T3sum(1:35,11))
  M(11) = M(11) + ((CI*f(20))/6._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,148),T3sum(1:35,11))
  M(1) = M(1) + ((CI*f(20))/2._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,150),T3sum(1:35,11))
  M(2) = M(2) + (-(CI*f(20))/2._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,150),T3sum(1:35,11))
  M(10) = M(10) + (-(CI*f(20))/6._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,150),T3sum(1:35,11))
  M(11) = M(11) + ((CI*f(20))/6._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,150),T3sum(1:35,11))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,152),T3sum(1:35,11))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,152),T3sum(1:35,11))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,152),T3sum(1:35,11))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,152),T3sum(1:35,11))
  M(1) = M(1) + ((-3*f(18))/2._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,154),T3sum(1:35,11))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,154),T3sum(1:35,11))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,154),T3sum(1:35,11))
  M(6) = M(6) + ((-3*f(18))/2._/**/REALKIND * den(76)) * TI2_call(3,momenta_25,masses2_10,G3tensor(:,154),T3sum(1:35,11))
  M(1) = M(1) + ((-3*f(18))/2._/**/REALKIND * den(257)) * TI2_call(2,momenta_108,masses2_9,G2tensor(:,4),T2sum(1:15,11))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(257)) * TI2_call(2,momenta_108,masses2_9,G2tensor(:,4),T2sum(1:15,11))
  M(1) = M(1) + ((3*CI*f(16))/2._/**/REALKIND * den(256)) * TI2_call(2,momenta_116,masses2_9,G2tensor(:,81),T2sum(1:15,10))
  M(2) = M(2) + ((-3*CI*f(16))/2._/**/REALKIND * den(256)) * TI2_call(2,momenta_116,masses2_9,G2tensor(:,81),T2sum(1:15,10))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(256)) * TI2_call(2,momenta_116,masses2_9,G2tensor(:,81),T2sum(1:15,10))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(256)) * TI2_call(2,momenta_116,masses2_9,G2tensor(:,81),T2sum(1:15,10))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(334)) * TI2_call(3,momenta_295,masses2_15,G3tensor(:,6),T3sum(1:35,25))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(334)) * TI2_call(3,momenta_295,masses2_15,G3tensor(:,6),T3sum(1:35,25))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(334)) * TI2_call(3,momenta_297,masses2_16,G3tensor(:,4),T3sum(1:35,26))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(334)) * TI2_call(3,momenta_297,masses2_16,G3tensor(:,4),T3sum(1:35,26))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(334)) * TI2_call(3,momenta_297,masses2_16,G3tensor(:,4),T3sum(1:35,26))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(334)) * TI2_call(3,momenta_297,masses2_16,G3tensor(:,4),T3sum(1:35,26))
  M(1) = M(1) + ((CI*f(20))/2._/**/REALKIND * den(485)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,19),T3sum(1:35,15))
  M(4) = M(4) + (-(CI*f(20))/2._/**/REALKIND * den(485)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,19),T3sum(1:35,15))
  M(2) = M(2) + ((CI*f(20))/2._/**/REALKIND * den(485)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,37),T3sum(1:35,15))
  M(6) = M(6) + (-(CI*f(20))/2._/**/REALKIND * den(485)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,37),T3sum(1:35,15))
  M(1) = M(1) + ((CI*f(20))/2._/**/REALKIND * den(485)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,19),T3sum(1:35,15))
  M(4) = M(4) + (-(CI*f(20))/2._/**/REALKIND * den(485)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,19),T3sum(1:35,15))
  M(2) = M(2) + ((CI*f(20))/2._/**/REALKIND * den(485)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,37),T3sum(1:35,15))
  M(6) = M(6) + (-(CI*f(20))/2._/**/REALKIND * den(485)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,37),T3sum(1:35,15))
  M(1) = M(1) + ((-3*f(18))/2._/**/REALKIND * den(485)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,55),T3sum(1:35,15))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(485)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,55),T3sum(1:35,15))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(485)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,55),T3sum(1:35,15))
  M(6) = M(6) + ((-3*f(18))/2._/**/REALKIND * den(485)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,55),T3sum(1:35,15))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(485)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,73),T3sum(1:35,15))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(485)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,73),T3sum(1:35,15))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(485)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,73),T3sum(1:35,15))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(485)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,73),T3sum(1:35,15))
  M(1) = M(1) + (-(CI*f(20))/2._/**/REALKIND * den(487)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,29),T3sum(1:35,9))
  M(5) = M(5) + ((CI*f(20))/2._/**/REALKIND * den(487)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,29),T3sum(1:35,9))
  M(3) = M(3) + (-(CI*f(20))/2._/**/REALKIND * den(487)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,47),T3sum(1:35,9))
  M(6) = M(6) + ((CI*f(20))/2._/**/REALKIND * den(487)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,47),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(20))/2._/**/REALKIND * den(487)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,29),T3sum(1:35,9))
  M(5) = M(5) + ((CI*f(20))/2._/**/REALKIND * den(487)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,29),T3sum(1:35,9))
  M(3) = M(3) + (-(CI*f(20))/2._/**/REALKIND * den(487)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,47),T3sum(1:35,9))
  M(6) = M(6) + ((CI*f(20))/2._/**/REALKIND * den(487)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,47),T3sum(1:35,9))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(487)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,65),T3sum(1:35,9))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(487)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,65),T3sum(1:35,9))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(487)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,65),T3sum(1:35,9))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(487)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,65),T3sum(1:35,9))
  M(1) = M(1) + ((-3*f(18))/2._/**/REALKIND * den(487)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,83),T3sum(1:35,9))
  M(3) = M(3) + ((3*f(18))/2._/**/REALKIND * den(487)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,83),T3sum(1:35,9))
  M(5) = M(5) + ((3*f(18))/2._/**/REALKIND * den(487)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,83),T3sum(1:35,9))
  M(6) = M(6) + ((-3*f(18))/2._/**/REALKIND * den(487)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,83),T3sum(1:35,9))
  M(5) = M(5) + (-(f(22)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,7),T4sum(1:70,49))
  M(10) = M(10) + (f(22)/6._/**/REALKIND * den(65)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,7),T4sum(1:70,49))
  M(3) = M(3) + (-(f(22)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,5),T4sum(1:70,49))
  M(11) = M(11) + (f(22)/6._/**/REALKIND * den(65)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,5),T4sum(1:70,49))
  M(5) = M(5) + (-(f(22)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,7),T4sum(1:70,49))
  M(10) = M(10) + (f(22)/6._/**/REALKIND * den(65)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,7),T4sum(1:70,49))
  M(3) = M(3) + (-(f(22)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,5),T4sum(1:70,49))
  M(11) = M(11) + (f(22)/6._/**/REALKIND * den(65)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,5),T4sum(1:70,49))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,11),T4sum(1:70,49))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,11),T4sum(1:70,49))
  M(7) = M(7) + (-f(18) * den(65)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,11),T4sum(1:70,49))
  M(8) = M(8) + (-f(18) * den(65)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,11),T4sum(1:70,49))
  M(9) = M(9) + (-f(18) * den(65)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,11),T4sum(1:70,49))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,11),T4sum(1:70,49))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,11),T4sum(1:70,49))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,9),T4sum(1:70,49))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,9),T4sum(1:70,49))
  M(7) = M(7) + (-f(18) * den(65)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,9),T4sum(1:70,49))
  M(8) = M(8) + (-f(18) * den(65)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,9),T4sum(1:70,49))
  M(9) = M(9) + (-f(18) * den(65)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,9),T4sum(1:70,49))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,9),T4sum(1:70,49))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_185,masses2_17,G4tensor(:,9),T4sum(1:70,49))
  M(1) = M(1) + (-(f(22)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,35),T4sum(1:70,52))
  M(10) = M(10) + (f(22)/6._/**/REALKIND * den(65)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,35),T4sum(1:70,52))
  M(6) = M(6) + (-(f(22)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,31),T4sum(1:70,52))
  M(11) = M(11) + (f(22)/6._/**/REALKIND * den(65)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,31),T4sum(1:70,52))
  M(1) = M(1) + (-(f(22)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,35),T4sum(1:70,52))
  M(10) = M(10) + (f(22)/6._/**/REALKIND * den(65)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,35),T4sum(1:70,52))
  M(6) = M(6) + (-(f(22)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,31),T4sum(1:70,52))
  M(11) = M(11) + (f(22)/6._/**/REALKIND * den(65)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,31),T4sum(1:70,52))
  M(1) = M(1) + ((-3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,43),T4sum(1:70,52))
  M(6) = M(6) + ((-3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,43),T4sum(1:70,52))
  M(7) = M(7) + (-f(18) * den(65)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,43),T4sum(1:70,52))
  M(8) = M(8) + (-f(18) * den(65)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,43),T4sum(1:70,52))
  M(9) = M(9) + (-f(18) * den(65)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,43),T4sum(1:70,52))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,43),T4sum(1:70,52))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,43),T4sum(1:70,52))
  M(1) = M(1) + ((-3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,39),T4sum(1:70,52))
  M(6) = M(6) + ((-3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,39),T4sum(1:70,52))
  M(7) = M(7) + (-f(18) * den(65)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,39),T4sum(1:70,52))
  M(8) = M(8) + (-f(18) * den(65)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,39),T4sum(1:70,52))
  M(9) = M(9) + (-f(18) * den(65)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,39),T4sum(1:70,52))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,39),T4sum(1:70,52))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_142,masses2_17,G4tensor(:,39),T4sum(1:70,52))
  M(2) = M(2) + (-(f(22)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,37),T4sum(1:70,55))
  M(11) = M(11) + (f(22)/6._/**/REALKIND * den(65)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,37),T4sum(1:70,55))
  M(4) = M(4) + (-(f(22)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,33),T4sum(1:70,55))
  M(10) = M(10) + (f(22)/6._/**/REALKIND * den(65)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,33),T4sum(1:70,55))
  M(2) = M(2) + (-(f(22)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,37),T4sum(1:70,55))
  M(11) = M(11) + (f(22)/6._/**/REALKIND * den(65)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,37),T4sum(1:70,55))
  M(4) = M(4) + (-(f(22)/2._/**/REALKIND) * den(65)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,33),T4sum(1:70,55))
  M(10) = M(10) + (f(22)/6._/**/REALKIND * den(65)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,33),T4sum(1:70,55))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,45),T4sum(1:70,55))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,45),T4sum(1:70,55))
  M(7) = M(7) + (-f(18) * den(65)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,45),T4sum(1:70,55))
  M(8) = M(8) + (-f(18) * den(65)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,45),T4sum(1:70,55))
  M(9) = M(9) + (-f(18) * den(65)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,45),T4sum(1:70,55))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,45),T4sum(1:70,55))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,45),T4sum(1:70,55))
  M(2) = M(2) + ((-3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,41),T4sum(1:70,55))
  M(4) = M(4) + ((-3*f(18))/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,41),T4sum(1:70,55))
  M(7) = M(7) + (-f(18) * den(65)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,41),T4sum(1:70,55))
  M(8) = M(8) + (-f(18) * den(65)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,41),T4sum(1:70,55))
  M(9) = M(9) + (-f(18) * den(65)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,41),T4sum(1:70,55))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,41),T4sum(1:70,55))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(65)) * TI2_call(4,momenta_153,masses2_17,G4tensor(:,41),T4sum(1:70,55))
  M(1) = M(1) + (-(f(22)/2._/**/REALKIND) * den(488)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,20),T3sum(1:35,15))
  M(9) = M(9) + (f(22)/6._/**/REALKIND * den(488)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,20),T3sum(1:35,15))
  M(2) = M(2) + (-(f(22)/2._/**/REALKIND) * den(488)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,38),T3sum(1:35,15))
  M(9) = M(9) + (f(22)/6._/**/REALKIND * den(488)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,38),T3sum(1:35,15))
  M(1) = M(1) + (-(f(22)/2._/**/REALKIND) * den(488)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,20),T3sum(1:35,15))
  M(9) = M(9) + (f(22)/6._/**/REALKIND * den(488)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,20),T3sum(1:35,15))
  M(2) = M(2) + (-(f(22)/2._/**/REALKIND) * den(488)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,38),T3sum(1:35,15))
  M(9) = M(9) + (f(22)/6._/**/REALKIND * den(488)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,38),T3sum(1:35,15))
  M(1) = M(1) + ((3*CI*f(16))/2._/**/REALKIND * den(488)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,56),T3sum(1:35,15))
  M(2) = M(2) + ((-3*CI*f(16))/2._/**/REALKIND * den(488)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,56),T3sum(1:35,15))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(488)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,74),T3sum(1:35,15))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(488)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,74),T3sum(1:35,15))
  M(5) = M(5) + (-(f(22)/2._/**/REALKIND) * den(490)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,30),T3sum(1:35,9))
  M(7) = M(7) + (f(22)/6._/**/REALKIND * den(490)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,30),T3sum(1:35,9))
  M(6) = M(6) + (-(f(22)/2._/**/REALKIND) * den(490)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,48),T3sum(1:35,9))
  M(7) = M(7) + (f(22)/6._/**/REALKIND * den(490)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,48),T3sum(1:35,9))
  M(5) = M(5) + (-(f(22)/2._/**/REALKIND) * den(490)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,30),T3sum(1:35,9))
  M(7) = M(7) + (f(22)/6._/**/REALKIND * den(490)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,30),T3sum(1:35,9))
  M(6) = M(6) + (-(f(22)/2._/**/REALKIND) * den(490)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,48),T3sum(1:35,9))
  M(7) = M(7) + (f(22)/6._/**/REALKIND * den(490)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,48),T3sum(1:35,9))
  M(5) = M(5) + ((3*CI*f(16))/2._/**/REALKIND * den(490)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,66),T3sum(1:35,9))
  M(6) = M(6) + ((-3*CI*f(16))/2._/**/REALKIND * den(490)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,66),T3sum(1:35,9))
  M(5) = M(5) + ((-3*CI*f(16))/2._/**/REALKIND * den(490)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,84),T3sum(1:35,9))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(490)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,84),T3sum(1:35,9))
  M(4) = M(4) + (-(f(18)/6._/**/REALKIND) * den(52)) * TI2_call(3,momenta_228,masses2_12,G3tensor(:,186),T3sum(1:35,140))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(52)) * TI2_call(3,momenta_228,masses2_12,G3tensor(:,186),T3sum(1:35,140))
  M(3) = M(3) + (-(f(18)/6._/**/REALKIND) * den(52)) * TI2_call(3,momenta_227,masses2_12,G3tensor(:,187),T3sum(1:35,142))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(52)) * TI2_call(3,momenta_227,masses2_12,G3tensor(:,187),T3sum(1:35,142))
  M(6) = M(6) + (-(f(18)/6._/**/REALKIND) * den(159)) * TI2_call(3,momenta_283,masses2_12,G3tensor(:,188),T3sum(1:35,146))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(159)) * TI2_call(3,momenta_283,masses2_12,G3tensor(:,188),T3sum(1:35,146))
  M(5) = M(5) + (-(f(18)/6._/**/REALKIND) * den(159)) * TI2_call(3,momenta_282,masses2_12,G3tensor(:,189),T3sum(1:35,148))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(159)) * TI2_call(3,momenta_282,masses2_12,G3tensor(:,189),T3sum(1:35,148))
  M(4) = M(4) + (-(f(18)/6._/**/REALKIND) * den(81)) * TI2_call(2,momenta_51,masses2_6,G2tensor(:,26),T2sum(1:15,29))
  M(4) = M(4) + ((4*f(18))/3._/**/REALKIND * den(171)) * TI2_call(2,momenta_99,masses2_6,G2tensor(:,94),T2sum(1:15,79))
  M(4) = M(4) + ((4*f(18))/3._/**/REALKIND * den(172)) * TI2_call(2,momenta_111,masses2_6,G2tensor(:,45),T2sum(1:15,80))
  M(4) = M(4) + (-(f(18)/6._/**/REALKIND) * den(173)) * TI2_call(3,momenta_221,masses2_12,G3tensor(:,89),T3sum(1:35,150))
  M(4) = M(4) + (-(f(18)/6._/**/REALKIND) * den(173)) * TI2_call(3,momenta_217,masses2_12,G3tensor(:,91),T3sum(1:35,151))
  M(6) = M(6) + (-(f(18)/6._/**/REALKIND) * den(84)) * TI2_call(2,momenta_87,masses2_6,G2tensor(:,48),T2sum(1:15,39))
  M(6) = M(6) + ((4*f(18))/3._/**/REALKIND * den(175)) * TI2_call(2,momenta_85,masses2_6,G2tensor(:,51),T2sum(1:15,81))
  M(6) = M(6) + ((4*f(18))/3._/**/REALKIND * den(176)) * TI2_call(2,momenta_111,masses2_6,G2tensor(:,69),T2sum(1:15,80))
  M(6) = M(6) + (-(f(18)/6._/**/REALKIND) * den(182)) * TI2_call(3,momenta_277,masses2_12,G3tensor(:,115),T3sum(1:35,153))
  M(6) = M(6) + (-(f(18)/6._/**/REALKIND) * den(182)) * TI2_call(3,momenta_273,masses2_12,G3tensor(:,118),T3sum(1:35,154))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(249)) * TI2_call(2,momenta_107,masses2_9,G2tensor(:,5),T2sum(1:15,3))
  M(6) = M(6) + ((-3*f(18))/2._/**/REALKIND * den(249)) * TI2_call(2,momenta_107,masses2_9,G2tensor(:,5),T2sum(1:15,3))
  M(4) = M(4) + ((-4*CI*f(16))/3._/**/REALKIND * den(88)) * TI2_call(2,momenta_111,masses2_6,G2tensor(:,79),T2sum(1:15,80))
  M(6) = M(6) + ((4*CI*f(16))/3._/**/REALKIND * den(88)) * TI2_call(2,momenta_111,masses2_6,G2tensor(:,79),T2sum(1:15,80))
  M(4) = M(4) + ((CI*f(16))/6._/**/REALKIND * den(338)) * TI2_call(3,momenta_171,masses2_12,G3tensor(:,178),T3sum(1:35,156))
  M(6) = M(6) + (-(CI*f(16))/6._/**/REALKIND * den(338)) * TI2_call(3,momenta_171,masses2_12,G3tensor(:,178),T3sum(1:35,156))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(338)) * TI2_call(3,momenta_298,masses2_15,G3tensor(:,5),T3sum(1:35,33))
  M(6) = M(6) + ((-3*f(18))/2._/**/REALKIND * den(338)) * TI2_call(3,momenta_298,masses2_15,G3tensor(:,5),T3sum(1:35,33))
  M(4) = M(4) + ((CI*f(16))/6._/**/REALKIND * den(338)) * TI2_call(3,momenta_168,masses2_12,G3tensor(:,181),T3sum(1:35,157))
  M(6) = M(6) + (-(CI*f(16))/6._/**/REALKIND * den(338)) * TI2_call(3,momenta_168,masses2_12,G3tensor(:,181),T3sum(1:35,157))
  M(4) = M(4) + (-(f(22)/2._/**/REALKIND) * den(501)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,21),T3sum(1:35,15))
  M(9) = M(9) + (f(22)/6._/**/REALKIND * den(501)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,21),T3sum(1:35,15))
  M(6) = M(6) + (-(f(22)/2._/**/REALKIND) * den(501)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,39),T3sum(1:35,15))
  M(9) = M(9) + (f(22)/6._/**/REALKIND * den(501)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,39),T3sum(1:35,15))
  M(4) = M(4) + (-(f(22)/2._/**/REALKIND) * den(501)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,21),T3sum(1:35,15))
  M(9) = M(9) + (f(22)/6._/**/REALKIND * den(501)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,21),T3sum(1:35,15))
  M(6) = M(6) + (-(f(22)/2._/**/REALKIND) * den(501)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,39),T3sum(1:35,15))
  M(9) = M(9) + (f(22)/6._/**/REALKIND * den(501)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,39),T3sum(1:35,15))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND * den(501)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,57),T3sum(1:35,15))
  M(6) = M(6) + ((-3*CI*f(16))/2._/**/REALKIND * den(501)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,57),T3sum(1:35,15))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(501)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,75),T3sum(1:35,15))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(501)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,75),T3sum(1:35,15))
  M(6) = M(6) + (-(f(18)/6._/**/REALKIND) * den(49)) * TI2_call(3,momenta_237,masses2_12,G3tensor(:,182),T3sum(1:35,159))
  M(6) = M(6) + (-(f(18)/6._/**/REALKIND) * den(49)) * TI2_call(3,momenta_236,masses2_12,G3tensor(:,183),T3sum(1:35,160))
  M(4) = M(4) + (-(f(18)/6._/**/REALKIND) * den(157)) * TI2_call(3,momenta_291,masses2_12,G3tensor(:,184),T3sum(1:35,162))
  M(4) = M(4) + (-(f(18)/6._/**/REALKIND) * den(157)) * TI2_call(3,momenta_290,masses2_12,G3tensor(:,185),T3sum(1:35,163))
  M(4) = M(4) + (-(f(18)/6._/**/REALKIND) * den(45)) * TI2_call(4,momenta_377,masses2_19,G4tensor(:,48),T4sum(1:70,110))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(45)) * TI2_call(4,momenta_377,masses2_19,G4tensor(:,48),T4sum(1:70,110))
  M(6) = M(6) + (-(f(18)/6._/**/REALKIND) * den(45)) * TI2_call(4,momenta_375,masses2_19,G4tensor(:,46),T4sum(1:70,111))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(45)) * TI2_call(4,momenta_375,masses2_19,G4tensor(:,46),T4sum(1:70,111))
  M(4) = M(4) + (-(f(18)/6._/**/REALKIND) * den(45)) * TI2_call(4,momenta_376,masses2_19,G4tensor(:,49),T4sum(1:70,114))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(45)) * TI2_call(4,momenta_376,masses2_19,G4tensor(:,49),T4sum(1:70,114))
  M(4) = M(4) + (-(f(18)/6._/**/REALKIND) * den(45)) * TI2_call(4,momenta_373,masses2_19,G4tensor(:,50),T4sum(1:70,115))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(45)) * TI2_call(4,momenta_373,masses2_19,G4tensor(:,50),T4sum(1:70,115))
  M(6) = M(6) + (-(f(18)/6._/**/REALKIND) * den(45)) * TI2_call(4,momenta_374,masses2_19,G4tensor(:,47),T4sum(1:70,116))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(45)) * TI2_call(4,momenta_374,masses2_19,G4tensor(:,47),T4sum(1:70,116))
  M(6) = M(6) + (-(f(18)/6._/**/REALKIND) * den(45)) * TI2_call(4,momenta_372,masses2_19,G4tensor(:,51),T4sum(1:70,117))
  M(9) = M(9) + (f(18)/2._/**/REALKIND * den(45)) * TI2_call(4,momenta_372,masses2_19,G4tensor(:,51),T4sum(1:70,117))
  M(2) = M(2) + ((4*f(18))/3._/**/REALKIND * den(188)) * TI2_call(2,momenta_101,masses2_6,G2tensor(:,23),T2sum(1:15,83))
  M(1) = M(1) + ((-3*f(18))/2._/**/REALKIND * den(258)) * TI2_call(2,momenta_108,masses2_9,G2tensor(:,6),T2sum(1:15,11))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(258)) * TI2_call(2,momenta_108,masses2_9,G2tensor(:,6),T2sum(1:15,11))
  M(1) = M(1) + ((-3*f(18))/2._/**/REALKIND * den(261)) * TI2_call(3,momenta_299,masses2_15,G3tensor(:,1),T3sum(1:35,34))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(261)) * TI2_call(3,momenta_299,masses2_15,G3tensor(:,1),T3sum(1:35,34))
  M(1) = M(1) + (-(f(22)/2._/**/REALKIND) * den(514)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,22),T3sum(1:35,15))
  M(9) = M(9) + (f(22)/6._/**/REALKIND * den(514)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,22),T3sum(1:35,15))
  M(2) = M(2) + (-(f(22)/2._/**/REALKIND) * den(514)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,40),T3sum(1:35,15))
  M(9) = M(9) + (f(22)/6._/**/REALKIND * den(514)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,40),T3sum(1:35,15))
  M(1) = M(1) + (-(f(22)/2._/**/REALKIND) * den(514)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,22),T3sum(1:35,15))
  M(9) = M(9) + (f(22)/6._/**/REALKIND * den(514)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,22),T3sum(1:35,15))
  M(2) = M(2) + (-(f(22)/2._/**/REALKIND) * den(514)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,40),T3sum(1:35,15))
  M(9) = M(9) + (f(22)/6._/**/REALKIND * den(514)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,40),T3sum(1:35,15))
  M(1) = M(1) + ((3*CI*f(16))/2._/**/REALKIND * den(514)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,58),T3sum(1:35,15))
  M(2) = M(2) + ((-3*CI*f(16))/2._/**/REALKIND * den(514)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,58),T3sum(1:35,15))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(514)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,76),T3sum(1:35,15))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(514)) * TI2_call(3,momenta_36,masses2_10,G3tensor(:,76),T3sum(1:35,15))
  M(1) = M(1) + (-(f(18)/6._/**/REALKIND) * den(14)) * TI2_call(3,momenta_239,masses2_12,G3tensor(:,11),T3sum(1:35,173))
  M(1) = M(1) + (-(f(18)/6._/**/REALKIND) * den(14)) * TI2_call(3,momenta_238,masses2_12,G3tensor(:,12),T3sum(1:35,174))
  M(2) = M(2) + (-(f(18)/6._/**/REALKIND) * den(145)) * TI2_call(3,momenta_293,masses2_12,G3tensor(:,13),T3sum(1:35,176))
  M(2) = M(2) + (-(f(18)/6._/**/REALKIND) * den(145)) * TI2_call(3,momenta_292,masses2_12,G3tensor(:,14),T3sum(1:35,177))
  M(5) = M(5) + (-(f(18)/6._/**/REALKIND) * den(98)) * TI2_call(2,momenta_86,masses2_6,G2tensor(:,50),T2sum(1:15,41))
  M(5) = M(5) + ((4*f(18))/3._/**/REALKIND * den(203)) * TI2_call(2,momenta_85,masses2_6,G2tensor(:,52),T2sum(1:15,81))
  M(5) = M(5) + ((4*f(18))/3._/**/REALKIND * den(204)) * TI2_call(2,momenta_101,masses2_6,G2tensor(:,67),T2sum(1:15,83))
  M(5) = M(5) + (-(f(18)/6._/**/REALKIND) * den(227)) * TI2_call(3,momenta_275,masses2_12,G3tensor(:,117),T3sum(1:35,178))
  M(5) = M(5) + (-(f(18)/6._/**/REALKIND) * den(227)) * TI2_call(3,momenta_272,masses2_12,G3tensor(:,119),T3sum(1:35,179))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(250)) * TI2_call(2,momenta_97,masses2_9,G2tensor(:,33),T2sum(1:15,5))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(250)) * TI2_call(2,momenta_97,masses2_9,G2tensor(:,33),T2sum(1:15,5))
  M(2) = M(2) + ((-4*CI*f(16))/3._/**/REALKIND * den(100)) * TI2_call(2,momenta_101,masses2_6,G2tensor(:,71),T2sum(1:15,83))
  M(5) = M(5) + ((4*CI*f(16))/3._/**/REALKIND * den(100)) * TI2_call(2,momenta_101,masses2_6,G2tensor(:,71),T2sum(1:15,83))
  M(2) = M(2) + ((3*f(18))/2._/**/REALKIND * den(355)) * TI2_call(3,momenta_288,masses2_15,G3tensor(:,98),T3sum(1:35,36))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(355)) * TI2_call(3,momenta_288,masses2_15,G3tensor(:,98),T3sum(1:35,36))
  M(3) = M(3) + ((3*CI*f(16))/2._/**/REALKIND * den(101)) * TI2_call(2,momenta_52,masses2_7,G2tensor(:,28),T2sum(1:15,32))
  M(3) = M(3) + ((3*CI*f(16))/2._/**/REALKIND * den(232)) * TI2_call(3,momenta_218,masses2_13,G3tensor(:,92),T3sum(1:35,188))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(259)) * TI2_call(2,momenta_98,masses2_9,G2tensor(:,34),T2sum(1:15,13))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(259)) * TI2_call(2,momenta_98,masses2_9,G2tensor(:,34),T2sum(1:15,13))
  M(3) = M(3) + ((CI*f(16))/6._/**/REALKIND * den(279)) * TI2_call(3,momenta_223,masses2_12,G3tensor(:,87),T3sum(1:35,189))
  M(4) = M(4) + (-(CI*f(16))/6._/**/REALKIND * den(279)) * TI2_call(3,momenta_223,masses2_12,G3tensor(:,87),T3sum(1:35,189))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(279)) * TI2_call(3,momenta_289,masses2_15,G3tensor(:,94),T3sum(1:35,37))
  M(4) = M(4) + ((3*f(18))/2._/**/REALKIND * den(279)) * TI2_call(3,momenta_289,masses2_15,G3tensor(:,94),T3sum(1:35,37))
  M(3) = M(3) + ((CI*f(16))/6._/**/REALKIND * den(279)) * TI2_call(3,momenta_219,masses2_12,G3tensor(:,93),T3sum(1:35,190))
  M(4) = M(4) + (-(CI*f(16))/6._/**/REALKIND * den(279)) * TI2_call(3,momenta_219,masses2_12,G3tensor(:,93),T3sum(1:35,190))
  M(3) = M(3) + (-(f(18)/6._/**/REALKIND) * den(23)) * TI2_call(3,momenta_239,masses2_12,G3tensor(:,100),T3sum(1:35,173))
  M(3) = M(3) + (-(f(18)/6._/**/REALKIND) * den(23)) * TI2_call(3,momenta_238,masses2_12,G3tensor(:,101),T3sum(1:35,174))
  M(4) = M(4) + (-(f(18)/6._/**/REALKIND) * den(152)) * TI2_call(3,momenta_303,masses2_12,G3tensor(:,102),T3sum(1:35,192))
  M(4) = M(4) + (-(f(18)/6._/**/REALKIND) * den(152)) * TI2_call(3,momenta_302,masses2_12,G3tensor(:,103),T3sum(1:35,193))
  M(4) = M(4) + (-(f(18)/6._/**/REALKIND) * den(16)) * TI2_call(4,momenta_424,masses2_19,G4tensor(:,12),T4sum(1:70,146))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(16)) * TI2_call(4,momenta_424,masses2_19,G4tensor(:,12),T4sum(1:70,146))
  M(3) = M(3) + (-(f(18)/6._/**/REALKIND) * den(16)) * TI2_call(4,momenta_422,masses2_19,G4tensor(:,14),T4sum(1:70,147))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(16)) * TI2_call(4,momenta_422,masses2_19,G4tensor(:,14),T4sum(1:70,147))
  M(4) = M(4) + (-(f(18)/6._/**/REALKIND) * den(16)) * TI2_call(4,momenta_423,masses2_19,G4tensor(:,13),T4sum(1:70,150))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(16)) * TI2_call(4,momenta_423,masses2_19,G4tensor(:,13),T4sum(1:70,150))
  M(4) = M(4) + (-(f(18)/6._/**/REALKIND) * den(16)) * TI2_call(4,momenta_420,masses2_19,G4tensor(:,16),T4sum(1:70,151))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(16)) * TI2_call(4,momenta_420,masses2_19,G4tensor(:,16),T4sum(1:70,151))
  M(3) = M(3) + (-(f(18)/6._/**/REALKIND) * den(16)) * TI2_call(4,momenta_421,masses2_19,G4tensor(:,15),T4sum(1:70,152))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(16)) * TI2_call(4,momenta_421,masses2_19,G4tensor(:,15),T4sum(1:70,152))
  M(3) = M(3) + (-(f(18)/6._/**/REALKIND) * den(16)) * TI2_call(4,momenta_419,masses2_19,G4tensor(:,17),T4sum(1:70,153))
  M(8) = M(8) + (f(18)/2._/**/REALKIND * den(16)) * TI2_call(4,momenta_419,masses2_19,G4tensor(:,17),T4sum(1:70,153))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(251)) * TI2_call(2,momenta_66,masses2_9,G2tensor(:,58),T2sum(1:15,7))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(251)) * TI2_call(2,momenta_66,masses2_9,G2tensor(:,58),T2sum(1:15,7))
  M(1) = M(1) + ((3*f(18))/2._/**/REALKIND * den(371)) * TI2_call(3,momenta_234,masses2_15,G3tensor(:,127),T3sum(1:35,38))
  M(3) = M(3) + ((-3*f(18))/2._/**/REALKIND * den(371)) * TI2_call(3,momenta_234,masses2_15,G3tensor(:,127),T3sum(1:35,38))
  M(5) = M(5) + ((-4*CI*f(16))/3._/**/REALKIND * den(105)) * TI2_call(2,momenta_85,masses2_6,G2tensor(:,53),T2sum(1:15,81))
  M(6) = M(6) + ((4*CI*f(16))/3._/**/REALKIND * den(105)) * TI2_call(2,momenta_85,masses2_6,G2tensor(:,53),T2sum(1:15,81))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(260)) * TI2_call(2,momenta_67,masses2_9,G2tensor(:,59),T2sum(1:15,15))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(260)) * TI2_call(2,momenta_67,masses2_9,G2tensor(:,59),T2sum(1:15,15))
  M(5) = M(5) + ((CI*f(16))/6._/**/REALKIND * den(296)) * TI2_call(3,momenta_279,masses2_12,G3tensor(:,113),T3sum(1:35,196))
  M(6) = M(6) + (-(CI*f(16))/6._/**/REALKIND * den(296)) * TI2_call(3,momenta_279,masses2_12,G3tensor(:,113),T3sum(1:35,196))
  M(5) = M(5) + ((-3*f(18))/2._/**/REALKIND * den(296)) * TI2_call(3,momenta_235,masses2_15,G3tensor(:,121),T3sum(1:35,39))
  M(6) = M(6) + ((3*f(18))/2._/**/REALKIND * den(296)) * TI2_call(3,momenta_235,masses2_15,G3tensor(:,121),T3sum(1:35,39))
  M(5) = M(5) + ((CI*f(16))/6._/**/REALKIND * den(296)) * TI2_call(3,momenta_274,masses2_12,G3tensor(:,120),T3sum(1:35,197))
  M(6) = M(6) + (-(CI*f(16))/6._/**/REALKIND * den(296)) * TI2_call(3,momenta_274,masses2_12,G3tensor(:,120),T3sum(1:35,197))
  M(1) = M(1) + ((CI*f(16))/6._/**/REALKIND * den(32)) * TI2_call(3,momenta_239,masses2_12,G3tensor(:,137),T3sum(1:35,173))
  M(3) = M(3) + (-(CI*f(16))/6._/**/REALKIND * den(32)) * TI2_call(3,momenta_239,masses2_12,G3tensor(:,137),T3sum(1:35,173))
  M(1) = M(1) + ((CI*f(16))/6._/**/REALKIND * den(32)) * TI2_call(3,momenta_238,masses2_12,G3tensor(:,138),T3sum(1:35,174))
  M(3) = M(3) + (-(CI*f(16))/6._/**/REALKIND * den(32)) * TI2_call(3,momenta_238,masses2_12,G3tensor(:,138),T3sum(1:35,174))
  M(1) = M(1) + ((3*CI*f(16))/2._/**/REALKIND * den(117)) * TI2_call(3,momenta_304,masses2_15,G3tensor(:,139),T3sum(1:35,35))
  M(3) = M(3) + ((-3*CI*f(16))/2._/**/REALKIND * den(117)) * TI2_call(3,momenta_304,masses2_15,G3tensor(:,139),T3sum(1:35,35))
  M(5) = M(5) + ((-3*CI*f(16))/2._/**/REALKIND * den(117)) * TI2_call(3,momenta_304,masses2_15,G3tensor(:,139),T3sum(1:35,35))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(117)) * TI2_call(3,momenta_304,masses2_15,G3tensor(:,139),T3sum(1:35,35))
  M(5) = M(5) + ((-3*CI*f(16))/2._/**/REALKIND * den(26)) * TI2_call(4,momenta_427,masses2_22,G4tensor(:,27),T4sum(1:70,10))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(26)) * TI2_call(4,momenta_427,masses2_22,G4tensor(:,27),T4sum(1:70,10))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(26)) * TI2_call(4,momenta_427,masses2_22,G4tensor(:,27),T4sum(1:70,10))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(26)) * TI2_call(4,momenta_427,masses2_22,G4tensor(:,27),T4sum(1:70,10))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(26)) * TI2_call(4,momenta_426,masses2_21,G4tensor(:,28),T4sum(1:70,11))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(26)) * TI2_call(4,momenta_426,masses2_21,G4tensor(:,28),T4sum(1:70,11))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(26)) * TI2_call(4,momenta_425,masses2_21,G4tensor(:,29),T4sum(1:70,12))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(26)) * TI2_call(4,momenta_425,masses2_21,G4tensor(:,29),T4sum(1:70,12))
  M(1) = M(1) + (-(f(22)/2._/**/REALKIND) * den(557)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,31),T3sum(1:35,9))
  M(7) = M(7) + (f(22)/6._/**/REALKIND * den(557)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,31),T3sum(1:35,9))
  M(3) = M(3) + (-(f(22)/2._/**/REALKIND) * den(557)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,49),T3sum(1:35,9))
  M(7) = M(7) + (f(22)/6._/**/REALKIND * den(557)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,49),T3sum(1:35,9))
  M(1) = M(1) + (-(f(22)/2._/**/REALKIND) * den(557)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,31),T3sum(1:35,9))
  M(7) = M(7) + (f(22)/6._/**/REALKIND * den(557)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,31),T3sum(1:35,9))
  M(3) = M(3) + (-(f(22)/2._/**/REALKIND) * den(557)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,49),T3sum(1:35,9))
  M(7) = M(7) + (f(22)/6._/**/REALKIND * den(557)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,49),T3sum(1:35,9))
  M(1) = M(1) + ((3*CI*f(16))/2._/**/REALKIND * den(557)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,67),T3sum(1:35,9))
  M(3) = M(3) + ((-3*CI*f(16))/2._/**/REALKIND * den(557)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,67),T3sum(1:35,9))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(557)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,85),T3sum(1:35,9))
  M(3) = M(3) + ((3*CI*f(16))/2._/**/REALKIND * den(557)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,85),T3sum(1:35,9))
  M(5) = M(5) + (-(f(22)/2._/**/REALKIND) * den(568)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,32),T3sum(1:35,9))
  M(7) = M(7) + (f(22)/6._/**/REALKIND * den(568)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,32),T3sum(1:35,9))
  M(6) = M(6) + (-(f(22)/2._/**/REALKIND) * den(568)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,50),T3sum(1:35,9))
  M(7) = M(7) + (f(22)/6._/**/REALKIND * den(568)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,50),T3sum(1:35,9))
  M(5) = M(5) + (-(f(22)/2._/**/REALKIND) * den(568)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,32),T3sum(1:35,9))
  M(7) = M(7) + (f(22)/6._/**/REALKIND * den(568)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,32),T3sum(1:35,9))
  M(6) = M(6) + (-(f(22)/2._/**/REALKIND) * den(568)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,50),T3sum(1:35,9))
  M(7) = M(7) + (f(22)/6._/**/REALKIND * den(568)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,50),T3sum(1:35,9))
  M(5) = M(5) + ((3*CI*f(16))/2._/**/REALKIND * den(568)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,68),T3sum(1:35,9))
  M(6) = M(6) + ((-3*CI*f(16))/2._/**/REALKIND * den(568)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,68),T3sum(1:35,9))
  M(5) = M(5) + ((-3*CI*f(16))/2._/**/REALKIND * den(568)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,86),T3sum(1:35,9))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(568)) * TI2_call(3,momenta_41,masses2_10,G3tensor(:,86),T3sum(1:35,9))
  M(5) = M(5) + (-(f(18)/6._/**/REALKIND) * den(36)) * TI2_call(3,momenta_293,masses2_12,G3tensor(:,140),T3sum(1:35,176))
  M(5) = M(5) + (-(f(18)/6._/**/REALKIND) * den(36)) * TI2_call(3,momenta_292,masses2_12,G3tensor(:,141),T3sum(1:35,177))
  M(6) = M(6) + (-(f(18)/6._/**/REALKIND) * den(155)) * TI2_call(3,momenta_303,masses2_12,G3tensor(:,142),T3sum(1:35,192))
  M(6) = M(6) + (-(f(18)/6._/**/REALKIND) * den(155)) * TI2_call(3,momenta_302,masses2_12,G3tensor(:,143),T3sum(1:35,193))
  M(6) = M(6) + (-(f(18)/6._/**/REALKIND) * den(25)) * TI2_call(4,momenta_466,masses2_19,G4tensor(:,21),T4sum(1:70,178))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_466,masses2_19,G4tensor(:,21),T4sum(1:70,178))
  M(5) = M(5) + (-(f(18)/6._/**/REALKIND) * den(25)) * TI2_call(4,momenta_464,masses2_19,G4tensor(:,23),T4sum(1:70,179))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_464,masses2_19,G4tensor(:,23),T4sum(1:70,179))
  M(6) = M(6) + (-(f(18)/6._/**/REALKIND) * den(25)) * TI2_call(4,momenta_465,masses2_19,G4tensor(:,22),T4sum(1:70,182))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_465,masses2_19,G4tensor(:,22),T4sum(1:70,182))
  M(6) = M(6) + (-(f(18)/6._/**/REALKIND) * den(25)) * TI2_call(4,momenta_462,masses2_19,G4tensor(:,25),T4sum(1:70,183))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_462,masses2_19,G4tensor(:,25),T4sum(1:70,183))
  M(5) = M(5) + (-(f(18)/6._/**/REALKIND) * den(25)) * TI2_call(4,momenta_463,masses2_19,G4tensor(:,24),T4sum(1:70,184))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_463,masses2_19,G4tensor(:,24),T4sum(1:70,184))
  M(5) = M(5) + (-(f(18)/6._/**/REALKIND) * den(25)) * TI2_call(4,momenta_461,masses2_19,G4tensor(:,26),T4sum(1:70,185))
  M(7) = M(7) + (f(18)/2._/**/REALKIND * den(25)) * TI2_call(4,momenta_461,masses2_19,G4tensor(:,26),T4sum(1:70,185))
  M(2) = M(2) + ((CI*f(16))/6._/**/REALKIND * den(39)) * TI2_call(3,momenta_293,masses2_12,G3tensor(:,144),T3sum(1:35,176))
  M(5) = M(5) + (-(CI*f(16))/6._/**/REALKIND * den(39)) * TI2_call(3,momenta_293,masses2_12,G3tensor(:,144),T3sum(1:35,176))
  M(2) = M(2) + ((CI*f(16))/6._/**/REALKIND * den(39)) * TI2_call(3,momenta_292,masses2_12,G3tensor(:,145),T3sum(1:35,177))
  M(5) = M(5) + (-(CI*f(16))/6._/**/REALKIND * den(39)) * TI2_call(3,momenta_292,masses2_12,G3tensor(:,145),T3sum(1:35,177))
  M(2) = M(2) + ((-3*CI*f(16))/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_304,masses2_15,G3tensor(:,146),T3sum(1:35,35))
  M(3) = M(3) + ((3*CI*f(16))/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_304,masses2_15,G3tensor(:,146),T3sum(1:35,35))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_304,masses2_15,G3tensor(:,146),T3sum(1:35,35))
  M(5) = M(5) + ((3*CI*f(16))/2._/**/REALKIND * den(123)) * TI2_call(3,momenta_304,masses2_15,G3tensor(:,146),T3sum(1:35,35))
  M(3) = M(3) + ((-3*CI*f(16))/2._/**/REALKIND * den(17)) * TI2_call(4,momenta_469,masses2_22,G4tensor(:,18),T4sum(1:70,6))
  M(4) = M(4) + ((3*CI*f(16))/2._/**/REALKIND * den(17)) * TI2_call(4,momenta_469,masses2_22,G4tensor(:,18),T4sum(1:70,6))
  M(10) = M(10) + ((CI*f(16))/2._/**/REALKIND * den(17)) * TI2_call(4,momenta_469,masses2_22,G4tensor(:,18),T4sum(1:70,6))
  M(11) = M(11) + (-(CI*f(16))/2._/**/REALKIND * den(17)) * TI2_call(4,momenta_469,masses2_22,G4tensor(:,18),T4sum(1:70,6))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(17)) * TI2_call(4,momenta_468,masses2_21,G4tensor(:,19),T4sum(1:70,7))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(17)) * TI2_call(4,momenta_468,masses2_21,G4tensor(:,19),T4sum(1:70,7))
  M(10) = M(10) + (-(f(18)/2._/**/REALKIND) * den(17)) * TI2_call(4,momenta_467,masses2_21,G4tensor(:,20),T4sum(1:70,8))
  M(11) = M(11) + (f(18)/2._/**/REALKIND * den(17)) * TI2_call(4,momenta_467,masses2_21,G4tensor(:,20),T4sum(1:70,8))
  M(4) = M(4) + ((CI*f(16))/6._/**/REALKIND * den(43)) * TI2_call(3,momenta_303,masses2_12,G3tensor(:,157),T3sum(1:35,192))
  M(6) = M(6) + (-(CI*f(16))/6._/**/REALKIND * den(43)) * TI2_call(3,momenta_303,masses2_12,G3tensor(:,157),T3sum(1:35,192))
  M(4) = M(4) + ((CI*f(16))/6._/**/REALKIND * den(43)) * TI2_call(3,momenta_302,masses2_12,G3tensor(:,158),T3sum(1:35,193))
  M(6) = M(6) + (-(CI*f(16))/6._/**/REALKIND * den(43)) * TI2_call(3,momenta_302,masses2_12,G3tensor(:,158),T3sum(1:35,193))
  M(1) = M(1) + ((3*CI*f(16))/2._/**/REALKIND * den(128)) * TI2_call(3,momenta_304,masses2_15,G3tensor(:,159),T3sum(1:35,35))
  M(2) = M(2) + ((-3*CI*f(16))/2._/**/REALKIND * den(128)) * TI2_call(3,momenta_304,masses2_15,G3tensor(:,159),T3sum(1:35,35))
  M(4) = M(4) + ((-3*CI*f(16))/2._/**/REALKIND * den(128)) * TI2_call(3,momenta_304,masses2_15,G3tensor(:,159),T3sum(1:35,35))
  M(6) = M(6) + ((3*CI*f(16))/2._/**/REALKIND * den(128)) * TI2_call(3,momenta_304,masses2_15,G3tensor(:,159),T3sum(1:35,35))
  M(1) = M(1) + ((-3*CI*f(16))/2._/**/REALKIND * den(7)) * TI2_call(4,momenta_472,masses2_22,G4tensor(:,1),T4sum(1:70,2))
  M(2) = M(2) + ((3*CI*f(16))/2._/**/REALKIND * den(7)) * TI2_call(4,momenta_472,masses2_22,G4tensor(:,1),T4sum(1:70,2))
  M(10) = M(10) + (-(CI*f(16))/2._/**/REALKIND * den(7)) * TI2_call(4,momenta_472,masses2_22,G4tensor(:,1),T4sum(1:70,2))
  M(11) = M(11) + ((CI*f(16))/2._/**/REALKIND * den(7)) * TI2_call(4,momenta_472,masses2_22,G4tensor(:,1),T4sum(1:70,2))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(7)) * TI2_call(4,momenta_471,masses2_21,G4tensor(:,2),T4sum(1:70,3))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(7)) * TI2_call(4,momenta_471,masses2_21,G4tensor(:,2),T4sum(1:70,3))
  M(10) = M(10) + (f(18)/2._/**/REALKIND * den(7)) * TI2_call(4,momenta_470,masses2_21,G4tensor(:,3),T4sum(1:70,4))
  M(11) = M(11) + (-(f(18)/2._/**/REALKIND) * den(7)) * TI2_call(4,momenta_470,masses2_21,G4tensor(:,3),T4sum(1:70,4))
  M(2) = M(2) + ((3*f(17))/2._/**/REALKIND * den(38)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,12),T2sum(1:5,86))
  M(3) = M(3) + ((-3*f(17))/2._/**/REALKIND * den(38)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,12),T2sum(1:5,86))
  M(4) = M(4) + ((3*f(17))/2._/**/REALKIND * den(38)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,12),T2sum(1:5,86))
  M(5) = M(5) + ((-3*f(17))/2._/**/REALKIND * den(38)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,12),T2sum(1:5,86))
  M(2) = M(2) + ((-3*f(17))/2._/**/REALKIND * den(38)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,13),T2sum(1:5,86))
  M(3) = M(3) + ((3*f(17))/2._/**/REALKIND * den(38)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,13),T2sum(1:5,86))
  M(4) = M(4) + ((-3*f(17))/2._/**/REALKIND * den(38)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,13),T2sum(1:5,86))
  M(5) = M(5) + ((3*f(17))/2._/**/REALKIND * den(38)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,13),T2sum(1:5,86))
  M(2) = M(2) + (-3*f(17) * den(38)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,14),T2sum(1:5,86))
  M(3) = M(3) + (3*f(17) * den(38)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,14),T2sum(1:5,86))
  M(4) = M(4) + (-3*f(17) * den(38)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,14),T2sum(1:5,86))
  M(5) = M(5) + (3*f(17) * den(38)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,14),T2sum(1:5,86))
  M(1) = M(1) + ((-3*f(17))/2._/**/REALKIND * den(41)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,1),T2sum(1:5,87))
  M(2) = M(2) + ((3*f(17))/2._/**/REALKIND * den(41)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,1),T2sum(1:5,87))
  M(4) = M(4) + ((3*f(17))/2._/**/REALKIND * den(41)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,1),T2sum(1:5,87))
  M(6) = M(6) + ((-3*f(17))/2._/**/REALKIND * den(41)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,1),T2sum(1:5,87))
  M(1) = M(1) + ((3*f(17))/2._/**/REALKIND * den(41)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,2),T2sum(1:5,87))
  M(2) = M(2) + ((-3*f(17))/2._/**/REALKIND * den(41)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,2),T2sum(1:5,87))
  M(4) = M(4) + ((-3*f(17))/2._/**/REALKIND * den(41)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,2),T2sum(1:5,87))
  M(6) = M(6) + ((3*f(17))/2._/**/REALKIND * den(41)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,2),T2sum(1:5,87))
  M(1) = M(1) + (3*f(17) * den(41)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,3),T2sum(1:5,87))
  M(2) = M(2) + (-3*f(17) * den(41)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,3),T2sum(1:5,87))
  M(4) = M(4) + (-3*f(17) * den(41)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,3),T2sum(1:5,87))
  M(6) = M(6) + (3*f(17) * den(41)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,3),T2sum(1:5,87))
  M(2) = M(2) + ((3*f(17))/2._/**/REALKIND * den(73)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,15),T2sum(1:5,86))
  M(3) = M(3) + ((-3*f(17))/2._/**/REALKIND * den(73)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,15),T2sum(1:5,86))
  M(4) = M(4) + ((3*f(17))/2._/**/REALKIND * den(73)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,15),T2sum(1:5,86))
  M(5) = M(5) + ((-3*f(17))/2._/**/REALKIND * den(73)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,15),T2sum(1:5,86))
  M(2) = M(2) + ((-3*f(17))/2._/**/REALKIND * den(73)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,16),T2sum(1:5,86))
  M(3) = M(3) + ((3*f(17))/2._/**/REALKIND * den(73)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,16),T2sum(1:5,86))
  M(4) = M(4) + ((-3*f(17))/2._/**/REALKIND * den(73)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,16),T2sum(1:5,86))
  M(5) = M(5) + ((3*f(17))/2._/**/REALKIND * den(73)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,16),T2sum(1:5,86))
  M(2) = M(2) + (-3*f(17) * den(73)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,17),T2sum(1:5,86))
  M(3) = M(3) + (3*f(17) * den(73)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,17),T2sum(1:5,86))
  M(4) = M(4) + (-3*f(17) * den(73)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,17),T2sum(1:5,86))
  M(5) = M(5) + (3*f(17) * den(73)) * TI2_call(1,momenta_7,masses2_4,G1tensor(:,17),T2sum(1:5,86))
  M(1) = M(1) + ((-3*f(17))/2._/**/REALKIND * den(76)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,4),T2sum(1:5,87))
  M(2) = M(2) + ((3*f(17))/2._/**/REALKIND * den(76)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,4),T2sum(1:5,87))
  M(4) = M(4) + ((3*f(17))/2._/**/REALKIND * den(76)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,4),T2sum(1:5,87))
  M(6) = M(6) + ((-3*f(17))/2._/**/REALKIND * den(76)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,4),T2sum(1:5,87))
  M(1) = M(1) + ((3*f(17))/2._/**/REALKIND * den(76)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,5),T2sum(1:5,87))
  M(2) = M(2) + ((-3*f(17))/2._/**/REALKIND * den(76)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,5),T2sum(1:5,87))
  M(4) = M(4) + ((-3*f(17))/2._/**/REALKIND * den(76)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,5),T2sum(1:5,87))
  M(6) = M(6) + ((3*f(17))/2._/**/REALKIND * den(76)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,5),T2sum(1:5,87))
  M(1) = M(1) + (3*f(17) * den(76)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,6),T2sum(1:5,87))
  M(2) = M(2) + (-3*f(17) * den(76)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,6),T2sum(1:5,87))
  M(4) = M(4) + (-3*f(17) * den(76)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,6),T2sum(1:5,87))
  M(6) = M(6) + (3*f(17) * den(76)) * TI2_call(1,momenta_13,masses2_4,G1tensor(:,6),T2sum(1:5,87))
  M(1) = M(1) + (-3*CI*f(15) * den(270)) * TI2_call(2,momenta_13,masses2_4,G2tensor(:,7),T2sum(1:15,87))
  M(2) = M(2) + (3*CI*f(15) * den(270)) * TI2_call(2,momenta_13,masses2_4,G2tensor(:,7),T2sum(1:15,87))
  M(1) = M(1) + ((-4*CI*f(16))/3._/**/REALKIND * den(267)) * TI2_call(1,momenta_16,masses2_2,G1tensor(:,37),T1sum(1:5,6))
  M(2) = M(2) + ((4*CI*f(16))/3._/**/REALKIND * den(267)) * TI2_call(1,momenta_16,masses2_2,G1tensor(:,37),T1sum(1:5,6))
  M(2) = M(2) + ((4*f(18))/3._/**/REALKIND * den(277)) * TI2_call(1,momenta_9,masses2_2,G1tensor(:,10),T1sum(1:5,7))
  M(2) = M(2) + ((4*f(18))/3._/**/REALKIND * den(599)) * TI2_call(1,momenta_16,masses2_2,G1tensor(:,39),T1sum(1:5,6))
  M(1) = M(1) + ((4*f(18))/3._/**/REALKIND * den(278)) * TI2_call(1,momenta_4,masses2_2,G1tensor(:,7),T1sum(1:5,8))
  M(1) = M(1) + ((4*f(18))/3._/**/REALKIND * den(600)) * TI2_call(1,momenta_16,masses2_2,G1tensor(:,41),T1sum(1:5,6))
  M(3) = M(3) + (-3*CI*f(15) * den(288)) * TI2_call(2,momenta_7,masses2_4,G2tensor(:,35),T2sum(1:15,86))
  M(4) = M(4) + (3*CI*f(15) * den(288)) * TI2_call(2,momenta_7,masses2_4,G2tensor(:,35),T2sum(1:15,86))
  M(3) = M(3) + ((-4*CI*f(16))/3._/**/REALKIND * den(285)) * TI2_call(1,momenta_10,masses2_2,G1tensor(:,34),T1sum(1:5,9))
  M(4) = M(4) + ((4*CI*f(16))/3._/**/REALKIND * den(285)) * TI2_call(1,momenta_10,masses2_2,G1tensor(:,34),T1sum(1:5,9))
  M(4) = M(4) + ((4*f(18))/3._/**/REALKIND * den(294)) * TI2_call(1,momenta_15,masses2_2,G1tensor(:,18),T1sum(1:5,10))
  M(4) = M(4) + ((4*f(18))/3._/**/REALKIND * den(603)) * TI2_call(1,momenta_10,masses2_2,G1tensor(:,38),T1sum(1:5,9))
  M(3) = M(3) + ((4*f(18))/3._/**/REALKIND * den(295)) * TI2_call(1,momenta_4,masses2_2,G1tensor(:,8),T1sum(1:5,8))
  M(3) = M(3) + ((4*f(18))/3._/**/REALKIND * den(604)) * TI2_call(1,momenta_10,masses2_2,G1tensor(:,40),T1sum(1:5,9))
  M(5) = M(5) + ((-4*CI*f(16))/3._/**/REALKIND * den(302)) * TI2_call(1,momenta_3,masses2_2,G1tensor(:,20),T1sum(1:5,11))
  M(6) = M(6) + ((4*CI*f(16))/3._/**/REALKIND * den(302)) * TI2_call(1,momenta_3,masses2_2,G1tensor(:,20),T1sum(1:5,11))
  M(1) = M(1) + (3*f(17) * den(310)) * TI2_call(2,momenta_19,masses2_4,G2tensor(:,63),T2sum(1:15,88))
  M(3) = M(3) + (-3*f(17) * den(310)) * TI2_call(2,momenta_19,masses2_4,G2tensor(:,63),T2sum(1:15,88))
  M(5) = M(5) + (-3*f(17) * den(310)) * TI2_call(2,momenta_19,masses2_4,G2tensor(:,63),T2sum(1:15,88))
  M(6) = M(6) + (3*f(17) * den(310)) * TI2_call(2,momenta_19,masses2_4,G2tensor(:,63),T2sum(1:15,88))
  M(1) = M(1) + ((-4*CI*f(16))/3._/**/REALKIND * den(311)) * TI2_call(1,momenta_4,masses2_2,G1tensor(:,9),T1sum(1:5,8))
  M(3) = M(3) + ((4*CI*f(16))/3._/**/REALKIND * den(311)) * TI2_call(1,momenta_4,masses2_2,G1tensor(:,9),T1sum(1:5,8))
  M(6) = M(6) + ((4*f(18))/3._/**/REALKIND * den(318)) * TI2_call(1,momenta_15,masses2_2,G1tensor(:,30),T1sum(1:5,10))
  M(6) = M(6) + ((4*f(18))/3._/**/REALKIND * den(611)) * TI2_call(1,momenta_3,masses2_2,G1tensor(:,21),T1sum(1:5,11))
  M(5) = M(5) + ((4*f(18))/3._/**/REALKIND * den(319)) * TI2_call(1,momenta_9,masses2_2,G1tensor(:,28),T1sum(1:5,7))
  M(5) = M(5) + ((4*f(18))/3._/**/REALKIND * den(612)) * TI2_call(1,momenta_3,masses2_2,G1tensor(:,22),T1sum(1:5,11))
  M(2) = M(2) + (-3*f(17) * den(615)) * TI2_call(2,momenta_7,masses2_4,G2tensor(:,36),T2sum(1:15,86))
  M(3) = M(3) + (3*f(17) * den(615)) * TI2_call(2,momenta_7,masses2_4,G2tensor(:,36),T2sum(1:15,86))
  M(4) = M(4) + (-3*f(17) * den(615)) * TI2_call(2,momenta_7,masses2_4,G2tensor(:,36),T2sum(1:15,86))
  M(5) = M(5) + (3*f(17) * den(615)) * TI2_call(2,momenta_7,masses2_4,G2tensor(:,36),T2sum(1:15,86))
  M(2) = M(2) + (-3*f(17) * den(324)) * TI2_call(2,momenta_19,masses2_4,G2tensor(:,74),T2sum(1:15,88))
  M(3) = M(3) + (3*f(17) * den(324)) * TI2_call(2,momenta_19,masses2_4,G2tensor(:,74),T2sum(1:15,88))
  M(4) = M(4) + (-3*f(17) * den(324)) * TI2_call(2,momenta_19,masses2_4,G2tensor(:,74),T2sum(1:15,88))
  M(5) = M(5) + (3*f(17) * den(324)) * TI2_call(2,momenta_19,masses2_4,G2tensor(:,74),T2sum(1:15,88))
  M(2) = M(2) + ((-4*CI*f(16))/3._/**/REALKIND * den(325)) * TI2_call(1,momenta_9,masses2_2,G1tensor(:,32),T1sum(1:5,7))
  M(5) = M(5) + ((4*CI*f(16))/3._/**/REALKIND * den(325)) * TI2_call(1,momenta_9,masses2_2,G1tensor(:,32),T1sum(1:5,7))
  M(2) = M(2) + (-3*CI*f(15) * den(616)) * TI2_call(2,momenta_7,masses2_4,G2tensor(:,37),T2sum(1:15,86))
  M(5) = M(5) + (3*CI*f(15) * den(616)) * TI2_call(2,momenta_7,masses2_4,G2tensor(:,37),T2sum(1:15,86))
  M(1) = M(1) + (3*f(17) * den(619)) * TI2_call(2,momenta_13,masses2_4,G2tensor(:,8),T2sum(1:15,87))
  M(2) = M(2) + (-3*f(17) * den(619)) * TI2_call(2,momenta_13,masses2_4,G2tensor(:,8),T2sum(1:15,87))
  M(4) = M(4) + (-3*f(17) * den(619)) * TI2_call(2,momenta_13,masses2_4,G2tensor(:,8),T2sum(1:15,87))
  M(6) = M(6) + (3*f(17) * den(619)) * TI2_call(2,momenta_13,masses2_4,G2tensor(:,8),T2sum(1:15,87))
  M(1) = M(1) + (3*f(17) * den(329)) * TI2_call(2,momenta_19,masses2_4,G2tensor(:,82),T2sum(1:15,88))
  M(2) = M(2) + (-3*f(17) * den(329)) * TI2_call(2,momenta_19,masses2_4,G2tensor(:,82),T2sum(1:15,88))
  M(4) = M(4) + (-3*f(17) * den(329)) * TI2_call(2,momenta_19,masses2_4,G2tensor(:,82),T2sum(1:15,88))
  M(6) = M(6) + (3*f(17) * den(329)) * TI2_call(2,momenta_19,masses2_4,G2tensor(:,82),T2sum(1:15,88))
  M(4) = M(4) + (-3*CI*f(15) * den(620)) * TI2_call(2,momenta_13,masses2_4,G2tensor(:,9),T2sum(1:15,87))
  M(6) = M(6) + (3*CI*f(15) * den(620)) * TI2_call(2,momenta_13,masses2_4,G2tensor(:,9),T2sum(1:15,87))
  M(4) = M(4) + ((-4*CI*f(16))/3._/**/REALKIND * den(330)) * TI2_call(1,momenta_15,masses2_2,G1tensor(:,35),T1sum(1:5,10))
  M(6) = M(6) + ((4*CI*f(16))/3._/**/REALKIND * den(330)) * TI2_call(1,momenta_15,masses2_2,G1tensor(:,35),T1sum(1:5,10))
  M(4) = M(4) + (-3*CI*f(15) * den(342)) * TI2_call(2,momenta_13,masses2_4,G2tensor(:,10),T2sum(1:15,87))
  M(6) = M(6) + (3*CI*f(15) * den(342)) * TI2_call(2,momenta_13,masses2_4,G2tensor(:,10),T2sum(1:15,87))
  M(6) = M(6) + ((4*f(18))/3._/**/REALKIND * den(349)) * TI2_call(1,momenta_5,masses2_2,G1tensor(:,44),T1sum(1:5,13))
  M(4) = M(4) + ((4*f(18))/3._/**/REALKIND * den(350)) * TI2_call(1,momenta_8,masses2_2,G1tensor(:,42),T1sum(1:5,14))
  M(2) = M(2) + (-3*CI*f(15) * den(359)) * TI2_call(2,momenta_7,masses2_4,G2tensor(:,38),T2sum(1:15,86))
  M(5) = M(5) + (3*CI*f(15) * den(359)) * TI2_call(2,momenta_7,masses2_4,G2tensor(:,38),T2sum(1:15,86))
  M(5) = M(5) + ((4*f(18))/3._/**/REALKIND * den(365)) * TI2_call(1,momenta_5,masses2_2,G1tensor(:,45),T1sum(1:5,13))
  M(1) = M(1) + (3*f(17) * den(378)) * TI2_call(2,momenta_19,masses2_4,G2tensor(:,64),T2sum(1:15,88))
  M(3) = M(3) + (-3*f(17) * den(378)) * TI2_call(2,momenta_19,masses2_4,G2tensor(:,64),T2sum(1:15,88))
  M(5) = M(5) + (-3*f(17) * den(378)) * TI2_call(2,momenta_19,masses2_4,G2tensor(:,64),T2sum(1:15,88))
  M(6) = M(6) + (3*f(17) * den(378)) * TI2_call(2,momenta_19,masses2_4,G2tensor(:,64),T2sum(1:15,88))
  M(5) = M(5) + ((-4*CI*f(16))/3._/**/REALKIND * den(379)) * TI2_call(1,momenta_5,masses2_2,G1tensor(:,46),T1sum(1:5,13))
  M(6) = M(6) + ((4*CI*f(16))/3._/**/REALKIND * den(379)) * TI2_call(1,momenta_5,masses2_2,G1tensor(:,46),T1sum(1:5,13))
  M(2) = M(2) + (-3*f(17) * den(639)) * TI2_call(2,momenta_7,masses2_4,G2tensor(:,39),T2sum(1:15,86))
  M(3) = M(3) + (3*f(17) * den(639)) * TI2_call(2,momenta_7,masses2_4,G2tensor(:,39),T2sum(1:15,86))
  M(4) = M(4) + (-3*f(17) * den(639)) * TI2_call(2,momenta_7,masses2_4,G2tensor(:,39),T2sum(1:15,86))
  M(5) = M(5) + (3*f(17) * den(639)) * TI2_call(2,momenta_7,masses2_4,G2tensor(:,39),T2sum(1:15,86))
  M(2) = M(2) + (-3*f(17) * den(391)) * TI2_call(2,momenta_19,masses2_4,G2tensor(:,75),T2sum(1:15,88))
  M(3) = M(3) + (3*f(17) * den(391)) * TI2_call(2,momenta_19,masses2_4,G2tensor(:,75),T2sum(1:15,88))
  M(4) = M(4) + (-3*f(17) * den(391)) * TI2_call(2,momenta_19,masses2_4,G2tensor(:,75),T2sum(1:15,88))
  M(5) = M(5) + (3*f(17) * den(391)) * TI2_call(2,momenta_19,masses2_4,G2tensor(:,75),T2sum(1:15,88))
  M(3) = M(3) + (-3*CI*f(15) * den(641)) * TI2_call(2,momenta_7,masses2_4,G2tensor(:,40),T2sum(1:15,86))
  M(4) = M(4) + (3*CI*f(15) * den(641)) * TI2_call(2,momenta_7,masses2_4,G2tensor(:,40),T2sum(1:15,86))
  M(1) = M(1) + (3*f(17) * den(643)) * TI2_call(2,momenta_13,masses2_4,G2tensor(:,11),T2sum(1:15,87))
  M(2) = M(2) + (-3*f(17) * den(643)) * TI2_call(2,momenta_13,masses2_4,G2tensor(:,11),T2sum(1:15,87))
  M(4) = M(4) + (-3*f(17) * den(643)) * TI2_call(2,momenta_13,masses2_4,G2tensor(:,11),T2sum(1:15,87))
  M(6) = M(6) + (3*f(17) * den(643)) * TI2_call(2,momenta_13,masses2_4,G2tensor(:,11),T2sum(1:15,87))
  M(1) = M(1) + (3*f(17) * den(396)) * TI2_call(2,momenta_19,masses2_4,G2tensor(:,83),T2sum(1:15,88))
  M(2) = M(2) + (-3*f(17) * den(396)) * TI2_call(2,momenta_19,masses2_4,G2tensor(:,83),T2sum(1:15,88))
  M(4) = M(4) + (-3*f(17) * den(396)) * TI2_call(2,momenta_19,masses2_4,G2tensor(:,83),T2sum(1:15,88))
  M(6) = M(6) + (3*f(17) * den(396)) * TI2_call(2,momenta_19,masses2_4,G2tensor(:,83),T2sum(1:15,88))
  M(1) = M(1) + (-3*CI*f(15) * den(645)) * TI2_call(2,momenta_13,masses2_4,G2tensor(:,12),T2sum(1:15,87))
  M(2) = M(2) + (3*CI*f(15) * den(645)) * TI2_call(2,momenta_13,masses2_4,G2tensor(:,12),T2sum(1:15,87))
  M(4) = M(4) + ((4*f(18))/3._/**/REALKIND * den(405)) * TI2_call(1,momenta_15,masses2_2,G1tensor(:,19),T1sum(1:5,10))
  M(4) = M(4) + ((4*f(18))/3._/**/REALKIND * den(406)) * TI2_call(1,momenta_8,masses2_2,G1tensor(:,43),T1sum(1:5,14))
  M(6) = M(6) + ((4*f(18))/3._/**/REALKIND * den(411)) * TI2_call(1,momenta_15,masses2_2,G1tensor(:,31),T1sum(1:5,10))
  M(6) = M(6) + ((4*f(18))/3._/**/REALKIND * den(651)) * TI2_call(1,momenta_3,masses2_2,G1tensor(:,23),T1sum(1:5,11))
  M(6) = M(6) + ((4*f(18))/3._/**/REALKIND * den(652)) * TI2_call(1,momenta_3,masses2_2,G1tensor(:,24),T1sum(1:5,11))
  M(4) = M(4) + (-3*CI*f(15) * den(655)) * TI2_call(2,momenta_13,masses2_4,G2tensor(:,13),T2sum(1:15,87))
  M(6) = M(6) + (3*CI*f(15) * den(655)) * TI2_call(2,momenta_13,masses2_4,G2tensor(:,13),T2sum(1:15,87))
  M(4) = M(4) + ((-4*CI*f(16))/3._/**/REALKIND * den(414)) * TI2_call(1,momenta_15,masses2_2,G1tensor(:,36),T1sum(1:5,10))
  M(6) = M(6) + ((4*CI*f(16))/3._/**/REALKIND * den(414)) * TI2_call(1,momenta_15,masses2_2,G1tensor(:,36),T1sum(1:5,10))
  M(2) = M(2) + ((4*f(18))/3._/**/REALKIND * den(420)) * TI2_call(1,momenta_9,masses2_2,G1tensor(:,11),T1sum(1:5,7))
  M(1) = M(1) + (-3*CI*f(15) * den(666)) * TI2_call(2,momenta_13,masses2_4,G2tensor(:,14),T2sum(1:15,87))
  M(2) = M(2) + (3*CI*f(15) * den(666)) * TI2_call(2,momenta_13,masses2_4,G2tensor(:,14),T2sum(1:15,87))
  M(5) = M(5) + ((4*f(18))/3._/**/REALKIND * den(435)) * TI2_call(1,momenta_9,masses2_2,G1tensor(:,29),T1sum(1:5,7))
  M(5) = M(5) + ((4*f(18))/3._/**/REALKIND * den(667)) * TI2_call(1,momenta_3,masses2_2,G1tensor(:,25),T1sum(1:5,11))
  M(5) = M(5) + ((4*f(18))/3._/**/REALKIND * den(668)) * TI2_call(1,momenta_3,masses2_2,G1tensor(:,26),T1sum(1:5,11))
  M(2) = M(2) + (-3*CI*f(15) * den(671)) * TI2_call(2,momenta_7,masses2_4,G2tensor(:,41),T2sum(1:15,86))
  M(5) = M(5) + (3*CI*f(15) * den(671)) * TI2_call(2,momenta_7,masses2_4,G2tensor(:,41),T2sum(1:15,86))
  M(2) = M(2) + ((-4*CI*f(16))/3._/**/REALKIND * den(438)) * TI2_call(1,momenta_9,masses2_2,G1tensor(:,33),T1sum(1:5,7))
  M(5) = M(5) + ((4*CI*f(16))/3._/**/REALKIND * den(438)) * TI2_call(1,momenta_9,masses2_2,G1tensor(:,33),T1sum(1:5,7))
  M(3) = M(3) + (-3*CI*f(15) * den(678)) * TI2_call(2,momenta_7,masses2_4,G2tensor(:,42),T2sum(1:15,86))
  M(4) = M(4) + (3*CI*f(15) * den(678)) * TI2_call(2,momenta_7,masses2_4,G2tensor(:,42),T2sum(1:15,86))
  M(5) = M(5) + ((-4*CI*f(16))/3._/**/REALKIND * den(681)) * TI2_call(1,momenta_3,masses2_2,G1tensor(:,27),T1sum(1:5,11))
  M(6) = M(6) + ((4*CI*f(16))/3._/**/REALKIND * den(681)) * TI2_call(1,momenta_3,masses2_2,G1tensor(:,27),T1sum(1:5,11))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_5

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G1tensorhel)
  deallocate(G2tensorhel)
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_5_pphjjj2_bbxhggg_1_/**/REALKIND
