
module ol_vamp_4_pphjjj2_hggggg_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G6tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_4(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pphjjj2_hggggg_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pphjjj2_hggggg_2.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pphjjj2_hggggg_2_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pphjjj2_hggggg_2_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(24)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,3) :: G0
  complex(REALKIND), dimension(4,5,4,148) :: G1
  complex(REALKIND), dimension(4,15,4,392) :: G2
  complex(REALKIND), dimension(4,35,4,348) :: G3
  complex(REALKIND), dimension(4,70,4,192) :: G4
  complex(REALKIND), dimension(4,126,4,72) :: G5
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
  complex(REALKIND), pointer :: G6tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,90,32))
    allocate(G4tensorhel(70,96,32))
    allocate(G5tensorhel(126,60,32))
    allocate(G6tensorhel(210,36,32))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)
  G6tensor => G6tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,4),MT,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,220),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,62),MT,G2(:,:,:,1))
  call loop_AS_Q(G2(:,:,:,1),wf(:,0),G2(:,:,:,2),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,63),MT,G3tensor(:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,221),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,62),MT,G2(:,:,:,3))
  call loop_AS_Q(G2(:,:,:,3),wf(:,0),G2(:,:,:,4),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,63),MT,G3tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,222),G1(:,:,:,4))
  call loop_A_Q(G1(:,:,:,4),Q(:,62),MT,G2(:,:,:,5))
  call loop_AS_Q(G2(:,:,:,5),wf(:,0),G2(:,:,:,6),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,63),MT,G3tensor(:,3))
  call loop_AV_Q(G1(:,:,:,1),wf(:,226),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,62),MT,G2(:,:,:,7))
  call loop_AS_Q(G2(:,:,:,7),wf(:,0),G2(:,:,:,8),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,8),Q(:,63),MT,G3tensor(:,4))
  call loop_AV_Q(G1(:,:,:,1),wf(:,227),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,62),MT,G2(:,:,:,9))
  call loop_AS_Q(G2(:,:,:,9),wf(:,0),G2(:,:,:,10),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,10),Q(:,63),MT,G3tensor(:,5))
  call loop_AV_Q(G1(:,:,:,1),wf(:,228),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,62),MT,G2(:,:,:,11))
  call loop_AS_Q(G2(:,:,:,11),wf(:,0),G2(:,:,:,12),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,12),Q(:,63),MT,G3tensor(:,6))
  call loop_AV_Q(G1(:,:,:,1),wf(:,232),G1(:,:,:,8))
  call loop_A_Q(G1(:,:,:,8),Q(:,62),MT,G2(:,:,:,13))
  call loop_AS_Q(G2(:,:,:,13),wf(:,0),G2(:,:,:,14),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,14),Q(:,63),MT,G3tensor(:,7))
  call loop_AV_Q(G1(:,:,:,1),wf(:,233),G1(:,:,:,9))
  call loop_A_Q(G1(:,:,:,9),Q(:,62),MT,G2(:,:,:,15))
  call loop_AS_Q(G2(:,:,:,15),wf(:,0),G2(:,:,:,16),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,16),Q(:,63),MT,G3tensor(:,8))
  call loop_AV_Q(G1(:,:,:,1),wf(:,234),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,62),MT,G2(:,:,:,17))
  call loop_AS_Q(G2(:,:,:,17),wf(:,0),G2(:,:,:,18),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,18),Q(:,63),MT,G3tensor(:,9))
  call loop_AV_Q(G1(:,:,:,1),wf(:,238),G1(:,:,:,11))
  call loop_A_Q(G1(:,:,:,11),Q(:,62),MT,G2(:,:,:,19))
  call loop_AS_Q(G2(:,:,:,19),wf(:,0),G2(:,:,:,20),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,20),Q(:,63),MT,G3tensor(:,10))
  call loop_AV_Q(G1(:,:,:,1),wf(:,239),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,62),MT,G2(:,:,:,21))
  call loop_AS_Q(G2(:,:,:,21),wf(:,0),G2(:,:,:,22),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,22),Q(:,63),MT,G3tensor(:,11))
  call loop_AV_Q(G1(:,:,:,1),wf(:,240),G1(:,:,:,13))
  call loop_A_Q(G1(:,:,:,13),Q(:,62),MT,G2(:,:,:,23))
  call loop_AS_Q(G2(:,:,:,23),wf(:,0),G2(:,:,:,24),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,24),Q(:,63),MT,G3tensor(:,12))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-1),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,6),MT,G2(:,:,:,25))
  call loop_AV_Q(G2(:,:,:,25),wf(:,2),G2(:,:,:,26))
  call loop_A_Q(G2(:,:,:,26),Q(:,62),MT,G3(:,:,:,1))
  call loop_AS_Q(G3(:,:,:,1),wf(:,0),G3(:,:,:,2),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,63),MT,G4tensor(:,1))
  call loop_AV_Q(G2(:,:,:,25),wf(:,4),G2(:,:,:,27))
  call loop_A_Q(G2(:,:,:,27),Q(:,62),MT,G3(:,:,:,3))
  call loop_AS_Q(G3(:,:,:,3),wf(:,0),G3(:,:,:,4),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,4),Q(:,63),MT,G4tensor(:,2))
  call loop_AV_Q(G2(:,:,:,25),wf(:,5),G2(:,:,:,28))
  call loop_A_Q(G2(:,:,:,28),Q(:,62),MT,G3(:,:,:,5))
  call loop_AS_Q(G3(:,:,:,5),wf(:,0),G3(:,:,:,6),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,6),Q(:,63),MT,G4tensor(:,3))
  call loop_AV_Q(G2(:,:,:,25),wf(:,166),G2(:,:,:,29))
  call loop_A_Q(G2(:,:,:,29),Q(:,62),MT,G3(:,:,:,7))
  call loop_AS_Q(G3(:,:,:,7),wf(:,0),G3(:,:,:,8),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,63),MT,G4tensor(:,4))
  call loop_AV_Q(G2(:,:,:,25),wf(:,101),G2(:,:,:,30))
  call loop_A_Q(G2(:,:,:,30),Q(:,30),MT,G3(:,:,:,9))
  call loop_AV_Q(G3(:,:,:,9),wf(:,-5),G3(:,:,:,10))
  call loop_A_Q(G3(:,:,:,10),Q(:,62),MT,G4(:,:,:,1))
  call loop_AS_Q(G4(:,:,:,1),wf(:,0),G4(:,:,:,2),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,63),MT,G5tensor(:,1))
  call loop_AV_Q(G2(:,:,:,25),wf(:,-5),G2(:,:,:,31))
  call loop_A_Q(G2(:,:,:,31),Q(:,38),MT,G3(:,:,:,11))
  call loop_AV_Q(G3(:,:,:,11),wf(:,101),G3(:,:,:,12))
  call loop_A_Q(G3(:,:,:,12),Q(:,62),MT,G4(:,:,:,3))
  call loop_AS_Q(G4(:,:,:,3),wf(:,0),G4(:,:,:,4),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,4),Q(:,63),MT,G5tensor(:,2))
  call loop_AV_Q(G3(:,:,:,11),wf(:,-4),G3(:,:,:,13))
  call loop_A_Q(G3(:,:,:,13),Q(:,54),MT,G4(:,:,:,5))
  call loop_AV_Q(G4(:,:,:,5),wf(:,-3),G4(:,:,:,6))
  call loop_A_Q(G4(:,:,:,6),Q(:,62),MT,G5(:,:,:,1))
  call loop_AS_Q(G5(:,:,:,1),wf(:,0),G5(:,:,:,2),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,2),Q(:,63),MT,G6tensor(:,1))
  call loop_AV_Q(G3(:,:,:,11),wf(:,-3),G3(:,:,:,14))
  call loop_A_Q(G3(:,:,:,14),Q(:,46),MT,G4(:,:,:,7))
  call loop_AV_Q(G4(:,:,:,7),wf(:,-4),G4(:,:,:,8))
  call loop_A_Q(G4(:,:,:,8),Q(:,62),MT,G5(:,:,:,3))
  call loop_AS_Q(G5(:,:,:,3),wf(:,0),G5(:,:,:,4),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,4),Q(:,63),MT,G6tensor(:,2))
  call loop_AV_Q(G2(:,:,:,25),wf(:,169),G2(:,:,:,32))
  call loop_A_Q(G2(:,:,:,32),Q(:,62),MT,G3(:,:,:,15))
  call loop_AS_Q(G3(:,:,:,15),wf(:,0),G3(:,:,:,16),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,16),Q(:,63),MT,G4tensor(:,5))
  call loop_AV_Q(G2(:,:,:,25),wf(:,109),G2(:,:,:,33))
  call loop_A_Q(G2(:,:,:,33),Q(:,46),MT,G3(:,:,:,17))
  call loop_AV_Q(G3(:,:,:,17),wf(:,-4),G3(:,:,:,18))
  call loop_A_Q(G3(:,:,:,18),Q(:,62),MT,G4(:,:,:,9))
  call loop_AS_Q(G4(:,:,:,9),wf(:,0),G4(:,:,:,10),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,10),Q(:,63),MT,G5tensor(:,3))
  call loop_AV_Q(G2(:,:,:,25),wf(:,-4),G2(:,:,:,34))
  call loop_A_Q(G2(:,:,:,34),Q(:,22),MT,G3(:,:,:,19))
  call loop_AV_Q(G3(:,:,:,19),wf(:,109),G3(:,:,:,20))
  call loop_A_Q(G3(:,:,:,20),Q(:,62),MT,G4(:,:,:,11))
  call loop_AS_Q(G4(:,:,:,11),wf(:,0),G4(:,:,:,12),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,12),Q(:,63),MT,G5tensor(:,4))
  call loop_AV_Q(G3(:,:,:,19),wf(:,-5),G3(:,:,:,21))
  call loop_A_Q(G3(:,:,:,21),Q(:,54),MT,G4(:,:,:,13))
  call loop_AV_Q(G4(:,:,:,13),wf(:,-3),G4(:,:,:,14))
  call loop_A_Q(G4(:,:,:,14),Q(:,62),MT,G5(:,:,:,5))
  call loop_AS_Q(G5(:,:,:,5),wf(:,0),G5(:,:,:,6),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,6),Q(:,63),MT,G6tensor(:,3))
  call loop_AV_Q(G3(:,:,:,19),wf(:,-3),G3(:,:,:,22))
  call loop_A_Q(G3(:,:,:,22),Q(:,30),MT,G4(:,:,:,15))
  call loop_AV_Q(G4(:,:,:,15),wf(:,-5),G4(:,:,:,16))
  call loop_A_Q(G4(:,:,:,16),Q(:,62),MT,G5(:,:,:,7))
  call loop_AS_Q(G5(:,:,:,7),wf(:,0),G5(:,:,:,8),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,8),Q(:,63),MT,G6tensor(:,4))
  call loop_AV_Q(G2(:,:,:,25),wf(:,171),G2(:,:,:,35))
  call loop_A_Q(G2(:,:,:,35),Q(:,62),MT,G3(:,:,:,23))
  call loop_AS_Q(G3(:,:,:,23),wf(:,0),G3(:,:,:,24),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,24),Q(:,63),MT,G4tensor(:,6))
  call loop_AV_Q(G2(:,:,:,25),wf(:,119),G2(:,:,:,36))
  call loop_A_Q(G2(:,:,:,36),Q(:,54),MT,G3(:,:,:,25))
  call loop_AV_Q(G3(:,:,:,25),wf(:,-3),G3(:,:,:,26))
  call loop_A_Q(G3(:,:,:,26),Q(:,62),MT,G4(:,:,:,17))
  call loop_AS_Q(G4(:,:,:,17),wf(:,0),G4(:,:,:,18),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,18),Q(:,63),MT,G5tensor(:,5))
  call loop_AV_Q(G2(:,:,:,25),wf(:,-3),G2(:,:,:,37))
  call loop_A_Q(G2(:,:,:,37),Q(:,14),MT,G3(:,:,:,27))
  call loop_AV_Q(G3(:,:,:,27),wf(:,119),G3(:,:,:,28))
  call loop_A_Q(G3(:,:,:,28),Q(:,62),MT,G4(:,:,:,19))
  call loop_AS_Q(G4(:,:,:,19),wf(:,0),G4(:,:,:,20),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,20),Q(:,63),MT,G5tensor(:,6))
  call loop_AV_Q(G3(:,:,:,27),wf(:,-5),G3(:,:,:,29))
  call loop_A_Q(G3(:,:,:,29),Q(:,46),MT,G4(:,:,:,21))
  call loop_AV_Q(G4(:,:,:,21),wf(:,-4),G4(:,:,:,22))
  call loop_A_Q(G4(:,:,:,22),Q(:,62),MT,G5(:,:,:,9))
  call loop_AS_Q(G5(:,:,:,9),wf(:,0),G5(:,:,:,10),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,10),Q(:,63),MT,G6tensor(:,5))
  call loop_AV_Q(G3(:,:,:,27),wf(:,-4),G3(:,:,:,30))
  call loop_A_Q(G3(:,:,:,30),Q(:,30),MT,G4(:,:,:,23))
  call loop_AV_Q(G4(:,:,:,23),wf(:,-5),G4(:,:,:,24))
  call loop_A_Q(G4(:,:,:,24),Q(:,62),MT,G5(:,:,:,11))
  call loop_AS_Q(G5(:,:,:,11),wf(:,0),G5(:,:,:,12),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,12),Q(:,63),MT,G6tensor(:,6))
  call loop_AV_Q(G1(:,:,:,1),wf(:,298),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,62),MT,G2(:,:,:,38))
  call loop_AS_Q(G2(:,:,:,38),wf(:,0),G2(:,:,:,39),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,39),Q(:,63),MT,G3tensor(:,13))
  call loop_AV_Q(G1(:,:,:,1),wf(:,299),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,62),MT,G2(:,:,:,40))
  call loop_AS_Q(G2(:,:,:,40),wf(:,0),G2(:,:,:,41),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,41),Q(:,63),MT,G3tensor(:,14))
  call loop_AV_Q(G1(:,:,:,1),wf(:,300),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,62),MT,G2(:,:,:,42))
  call loop_AS_Q(G2(:,:,:,42),wf(:,0),G2(:,:,:,43),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,43),Q(:,63),MT,G3tensor(:,15))
  call loop_AV_Q(G1(:,:,:,1),wf(:,304),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,62),MT,G2(:,:,:,44))
  call loop_AS_Q(G2(:,:,:,44),wf(:,0),G2(:,:,:,45),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,45),Q(:,63),MT,G3tensor(:,16))
  call loop_AV_Q(G1(:,:,:,1),wf(:,305),G1(:,:,:,19))
  call loop_A_Q(G1(:,:,:,19),Q(:,62),MT,G2(:,:,:,46))
  call loop_AS_Q(G2(:,:,:,46),wf(:,0),G2(:,:,:,47),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,47),Q(:,63),MT,G3tensor(:,17))
  call loop_AV_Q(G1(:,:,:,1),wf(:,306),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,62),MT,G2(:,:,:,48))
  call loop_AS_Q(G2(:,:,:,48),wf(:,0),G2(:,:,:,49),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,49),Q(:,63),MT,G3tensor(:,18))
  call loop_AV_Q(G1(:,:,:,1),wf(:,310),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,62),MT,G2(:,:,:,50))
  call loop_AS_Q(G2(:,:,:,50),wf(:,0),G2(:,:,:,51),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,51),Q(:,63),MT,G3tensor(:,19))
  call loop_AV_Q(G1(:,:,:,1),wf(:,311),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,62),MT,G2(:,:,:,52))
  call loop_AS_Q(G2(:,:,:,52),wf(:,0),G2(:,:,:,53),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,53),Q(:,63),MT,G3tensor(:,20))
  call loop_AV_Q(G1(:,:,:,1),wf(:,312),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,62),MT,G2(:,:,:,54))
  call loop_AS_Q(G2(:,:,:,54),wf(:,0),G2(:,:,:,55),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,55),Q(:,63),MT,G3tensor(:,21))
  call loop_AV_Q(G1(:,:,:,1),wf(:,66),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,54),MT,G2(:,:,:,56))
  call loop_AV_Q(G2(:,:,:,56),wf(:,-3),G2(:,:,:,57))
  call loop_A_Q(G2(:,:,:,57),Q(:,62),MT,G3(:,:,:,31))
  call loop_AS_Q(G3(:,:,:,31),wf(:,0),G3(:,:,:,32),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,32),Q(:,63),MT,G4tensor(:,7))
  call loop_AV_Q(G1(:,:,:,1),wf(:,68),G1(:,:,:,25))
  call loop_A_Q(G1(:,:,:,25),Q(:,54),MT,G2(:,:,:,58))
  call loop_AV_Q(G2(:,:,:,58),wf(:,-3),G2(:,:,:,59))
  call loop_A_Q(G2(:,:,:,59),Q(:,62),MT,G3(:,:,:,33))
  call loop_AS_Q(G3(:,:,:,33),wf(:,0),G3(:,:,:,34),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,34),Q(:,63),MT,G4tensor(:,8))
  call loop_AV_Q(G1(:,:,:,1),wf(:,69),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,54),MT,G2(:,:,:,60))
  call loop_AV_Q(G2(:,:,:,60),wf(:,-3),G2(:,:,:,61))
  call loop_A_Q(G2(:,:,:,61),Q(:,62),MT,G3(:,:,:,35))
  call loop_AS_Q(G3(:,:,:,35),wf(:,0),G3(:,:,:,36),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,36),Q(:,63),MT,G4tensor(:,9))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-3),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,12),MT,G2(:,:,:,62))
  call loop_AV_Q(G2(:,:,:,62),wf(:,66),G2(:,:,:,63))
  call loop_A_Q(G2(:,:,:,63),Q(:,62),MT,G3(:,:,:,37))
  call loop_AS_Q(G3(:,:,:,37),wf(:,0),G3(:,:,:,38),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,38),Q(:,63),MT,G4tensor(:,10))
  call loop_AV_Q(G2(:,:,:,62),wf(:,68),G2(:,:,:,64))
  call loop_A_Q(G2(:,:,:,64),Q(:,62),MT,G3(:,:,:,39))
  call loop_AS_Q(G3(:,:,:,39),wf(:,0),G3(:,:,:,40),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,40),Q(:,63),MT,G4tensor(:,11))
  call loop_AV_Q(G2(:,:,:,62),wf(:,69),G2(:,:,:,65))
  call loop_A_Q(G2(:,:,:,65),Q(:,62),MT,G3(:,:,:,41))
  call loop_AS_Q(G3(:,:,:,41),wf(:,0),G3(:,:,:,42),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,42),Q(:,63),MT,G4tensor(:,12))
  call loop_AV_Q(G2(:,:,:,62),wf(:,184),G2(:,:,:,66))
  call loop_A_Q(G2(:,:,:,66),Q(:,62),MT,G3(:,:,:,43))
  call loop_AS_Q(G3(:,:,:,43),wf(:,0),G3(:,:,:,44),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,44),Q(:,63),MT,G4tensor(:,13))
  call loop_AV_Q(G2(:,:,:,62),wf(:,29),G2(:,:,:,67))
  call loop_A_Q(G2(:,:,:,67),Q(:,30),MT,G3(:,:,:,45))
  call loop_AV_Q(G3(:,:,:,45),wf(:,-5),G3(:,:,:,46))
  call loop_A_Q(G3(:,:,:,46),Q(:,62),MT,G4(:,:,:,25))
  call loop_AS_Q(G4(:,:,:,25),wf(:,0),G4(:,:,:,26),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,26),Q(:,63),MT,G5tensor(:,7))
  call loop_AV_Q(G2(:,:,:,62),wf(:,-5),G2(:,:,:,68))
  call loop_A_Q(G2(:,:,:,68),Q(:,44),MT,G3(:,:,:,47))
  call loop_AV_Q(G3(:,:,:,47),wf(:,29),G3(:,:,:,48))
  call loop_A_Q(G3(:,:,:,48),Q(:,62),MT,G4(:,:,:,27))
  call loop_AS_Q(G4(:,:,:,27),wf(:,0),G4(:,:,:,28),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,28),Q(:,63),MT,G5tensor(:,8))
  call loop_AV_Q(G3(:,:,:,47),wf(:,-1),G3(:,:,:,49))
  call loop_A_Q(G3(:,:,:,49),Q(:,46),MT,G4(:,:,:,29))
  call loop_AV_Q(G4(:,:,:,29),wf(:,-4),G4(:,:,:,30))
  call loop_A_Q(G4(:,:,:,30),Q(:,62),MT,G5(:,:,:,13))
  call loop_AS_Q(G5(:,:,:,13),wf(:,0),G5(:,:,:,14),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,14),Q(:,63),MT,G6tensor(:,7))
  call loop_AV_Q(G2(:,:,:,62),wf(:,187),G2(:,:,:,69))
  call loop_A_Q(G2(:,:,:,69),Q(:,62),MT,G3(:,:,:,50))
  call loop_AS_Q(G3(:,:,:,50),wf(:,0),G3(:,:,:,51),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,51),Q(:,63),MT,G4tensor(:,14))
  call loop_AV_Q(G2(:,:,:,62),wf(:,37),G2(:,:,:,70))
  call loop_A_Q(G2(:,:,:,70),Q(:,46),MT,G3(:,:,:,52))
  call loop_AV_Q(G3(:,:,:,52),wf(:,-4),G3(:,:,:,53))
  call loop_A_Q(G3(:,:,:,53),Q(:,62),MT,G4(:,:,:,31))
  call loop_AS_Q(G4(:,:,:,31),wf(:,0),G4(:,:,:,32),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,32),Q(:,63),MT,G5tensor(:,9))
  call loop_AV_Q(G2(:,:,:,62),wf(:,-4),G2(:,:,:,71))
  call loop_A_Q(G2(:,:,:,71),Q(:,28),MT,G3(:,:,:,54))
  call loop_AV_Q(G3(:,:,:,54),wf(:,37),G3(:,:,:,55))
  call loop_A_Q(G3(:,:,:,55),Q(:,62),MT,G4(:,:,:,33))
  call loop_AS_Q(G4(:,:,:,33),wf(:,0),G4(:,:,:,34),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,34),Q(:,63),MT,G5tensor(:,10))
  call loop_AV_Q(G3(:,:,:,54),wf(:,-1),G3(:,:,:,56))
  call loop_A_Q(G3(:,:,:,56),Q(:,30),MT,G4(:,:,:,35))
  call loop_AV_Q(G4(:,:,:,35),wf(:,-5),G4(:,:,:,36))
  call loop_A_Q(G4(:,:,:,36),Q(:,62),MT,G5(:,:,:,15))
  call loop_AS_Q(G5(:,:,:,15),wf(:,0),G5(:,:,:,16),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,16),Q(:,63),MT,G6tensor(:,8))
  call loop_AV_Q(G2(:,:,:,62),wf(:,188),G2(:,:,:,72))
  call loop_A_Q(G2(:,:,:,72),Q(:,62),MT,G3(:,:,:,57))
  call loop_AS_Q(G3(:,:,:,57),wf(:,0),G3(:,:,:,58),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,58),Q(:,63),MT,G4tensor(:,15))
  call loop_AV_Q(G2(:,:,:,62),wf(:,-1),G2(:,:,:,73))
  call loop_A_Q(G2(:,:,:,73),Q(:,14),MT,G3(:,:,:,59))
  call loop_AV_Q(G3(:,:,:,59),wf(:,119),G3(:,:,:,60))
  call loop_A_Q(G3(:,:,:,60),Q(:,62),MT,G4(:,:,:,37))
  call loop_AS_Q(G4(:,:,:,37),wf(:,0),G4(:,:,:,38),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,38),Q(:,63),MT,G5tensor(:,11))
  call loop_AV_Q(G3(:,:,:,59),wf(:,-5),G3(:,:,:,61))
  call loop_A_Q(G3(:,:,:,61),Q(:,46),MT,G4(:,:,:,39))
  call loop_AV_Q(G4(:,:,:,39),wf(:,-4),G4(:,:,:,40))
  call loop_A_Q(G4(:,:,:,40),Q(:,62),MT,G5(:,:,:,17))
  call loop_AS_Q(G5(:,:,:,17),wf(:,0),G5(:,:,:,18),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,18),Q(:,63),MT,G6tensor(:,9))
  call loop_AV_Q(G3(:,:,:,59),wf(:,-4),G3(:,:,:,62))
  call loop_A_Q(G3(:,:,:,62),Q(:,30),MT,G4(:,:,:,41))
  call loop_AV_Q(G4(:,:,:,41),wf(:,-5),G4(:,:,:,42))
  call loop_A_Q(G4(:,:,:,42),Q(:,62),MT,G5(:,:,:,19))
  call loop_AS_Q(G5(:,:,:,19),wf(:,0),G5(:,:,:,20),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,20),Q(:,63),MT,G6tensor(:,10))
  call loop_AV_Q(G1(:,:,:,1),wf(:,319),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,62),MT,G2(:,:,:,74))
  call loop_AS_Q(G2(:,:,:,74),wf(:,0),G2(:,:,:,75),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,75),Q(:,63),MT,G3tensor(:,22))
  call loop_AV_Q(G1(:,:,:,1),wf(:,320),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,62),MT,G2(:,:,:,76))
  call loop_AS_Q(G2(:,:,:,76),wf(:,0),G2(:,:,:,77),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,77),Q(:,63),MT,G3tensor(:,23))
  call loop_AV_Q(G1(:,:,:,1),wf(:,321),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,62),MT,G2(:,:,:,78))
  call loop_AS_Q(G2(:,:,:,78),wf(:,0),G2(:,:,:,79),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,79),Q(:,63),MT,G3tensor(:,24))
  call loop_AV_Q(G1(:,:,:,1),wf(:,325),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,62),MT,G2(:,:,:,80))
  call loop_AS_Q(G2(:,:,:,80),wf(:,0),G2(:,:,:,81),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,81),Q(:,63),MT,G3tensor(:,25))
  call loop_AV_Q(G1(:,:,:,1),wf(:,326),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,62),MT,G2(:,:,:,82))
  call loop_AS_Q(G2(:,:,:,82),wf(:,0),G2(:,:,:,83),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,83),Q(:,63),MT,G3tensor(:,26))
  call loop_AV_Q(G1(:,:,:,1),wf(:,327),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,62),MT,G2(:,:,:,84))
  call loop_AS_Q(G2(:,:,:,84),wf(:,0),G2(:,:,:,85),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,85),Q(:,63),MT,G3tensor(:,27))
  call loop_AV_Q(G1(:,:,:,1),wf(:,77),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,46),MT,G2(:,:,:,86))
  call loop_AV_Q(G2(:,:,:,86),wf(:,-4),G2(:,:,:,87))
  call loop_A_Q(G2(:,:,:,87),Q(:,62),MT,G3(:,:,:,63))
  call loop_AS_Q(G3(:,:,:,63),wf(:,0),G3(:,:,:,64),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,64),Q(:,63),MT,G4tensor(:,16))
  call loop_AV_Q(G1(:,:,:,1),wf(:,79),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,46),MT,G2(:,:,:,88))
  call loop_AV_Q(G2(:,:,:,88),wf(:,-4),G2(:,:,:,89))
  call loop_A_Q(G2(:,:,:,89),Q(:,62),MT,G3(:,:,:,65))
  call loop_AS_Q(G3(:,:,:,65),wf(:,0),G3(:,:,:,66),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,66),Q(:,63),MT,G4tensor(:,17))
  call loop_AV_Q(G1(:,:,:,1),wf(:,80),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,46),MT,G2(:,:,:,90))
  call loop_AV_Q(G2(:,:,:,90),wf(:,-4),G2(:,:,:,91))
  call loop_A_Q(G2(:,:,:,91),Q(:,62),MT,G3(:,:,:,67))
  call loop_AS_Q(G3(:,:,:,67),wf(:,0),G3(:,:,:,68),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,68),Q(:,63),MT,G4tensor(:,18))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,20),MT,G2(:,:,:,92))
  call loop_AV_Q(G2(:,:,:,92),wf(:,77),G2(:,:,:,93))
  call loop_A_Q(G2(:,:,:,93),Q(:,62),MT,G3(:,:,:,69))
  call loop_AS_Q(G3(:,:,:,69),wf(:,0),G3(:,:,:,70),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,70),Q(:,63),MT,G4tensor(:,19))
  call loop_AV_Q(G2(:,:,:,92),wf(:,79),G2(:,:,:,94))
  call loop_A_Q(G2(:,:,:,94),Q(:,62),MT,G3(:,:,:,71))
  call loop_AS_Q(G3(:,:,:,71),wf(:,0),G3(:,:,:,72),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,72),Q(:,63),MT,G4tensor(:,20))
  call loop_AV_Q(G2(:,:,:,92),wf(:,80),G2(:,:,:,95))
  call loop_A_Q(G2(:,:,:,95),Q(:,62),MT,G3(:,:,:,73))
  call loop_AS_Q(G3(:,:,:,73),wf(:,0),G3(:,:,:,74),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,74),Q(:,63),MT,G4tensor(:,21))
  call loop_AV_Q(G2(:,:,:,92),wf(:,176),G2(:,:,:,96))
  call loop_A_Q(G2(:,:,:,96),Q(:,62),MT,G3(:,:,:,75))
  call loop_AS_Q(G3(:,:,:,75),wf(:,0),G3(:,:,:,76),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,76),Q(:,63),MT,G4tensor(:,22))
  call loop_AV_Q(G2(:,:,:,92),wf(:,18),G2(:,:,:,97))
  call loop_A_Q(G2(:,:,:,97),Q(:,30),MT,G3(:,:,:,77))
  call loop_AV_Q(G3(:,:,:,77),wf(:,-5),G3(:,:,:,78))
  call loop_A_Q(G3(:,:,:,78),Q(:,62),MT,G4(:,:,:,43))
  call loop_AS_Q(G4(:,:,:,43),wf(:,0),G4(:,:,:,44),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,44),Q(:,63),MT,G5tensor(:,12))
  call loop_AV_Q(G2(:,:,:,92),wf(:,-5),G2(:,:,:,98))
  call loop_A_Q(G2(:,:,:,98),Q(:,52),MT,G3(:,:,:,79))
  call loop_AV_Q(G3(:,:,:,79),wf(:,18),G3(:,:,:,80))
  call loop_A_Q(G3(:,:,:,80),Q(:,62),MT,G4(:,:,:,45))
  call loop_AS_Q(G4(:,:,:,45),wf(:,0),G4(:,:,:,46),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,46),Q(:,63),MT,G5tensor(:,13))
  call loop_AV_Q(G3(:,:,:,79),wf(:,-1),G3(:,:,:,81))
  call loop_A_Q(G3(:,:,:,81),Q(:,54),MT,G4(:,:,:,47))
  call loop_AV_Q(G4(:,:,:,47),wf(:,-3),G4(:,:,:,48))
  call loop_A_Q(G4(:,:,:,48),Q(:,62),MT,G5(:,:,:,21))
  call loop_AS_Q(G5(:,:,:,21),wf(:,0),G5(:,:,:,22),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,22),Q(:,63),MT,G6tensor(:,11))
  call loop_AV_Q(G2(:,:,:,92),wf(:,196),G2(:,:,:,99))
  call loop_A_Q(G2(:,:,:,99),Q(:,62),MT,G3(:,:,:,82))
  call loop_AS_Q(G3(:,:,:,82),wf(:,0),G3(:,:,:,83),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,83),Q(:,63),MT,G4tensor(:,23))
  call loop_AV_Q(G2(:,:,:,92),wf(:,37),G2(:,:,:,100))
  call loop_A_Q(G2(:,:,:,100),Q(:,54),MT,G3(:,:,:,84))
  call loop_AV_Q(G3(:,:,:,84),wf(:,-3),G3(:,:,:,85))
  call loop_A_Q(G3(:,:,:,85),Q(:,62),MT,G4(:,:,:,49))
  call loop_AS_Q(G4(:,:,:,49),wf(:,0),G4(:,:,:,50),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,50),Q(:,63),MT,G5tensor(:,14))
  call loop_AV_Q(G2(:,:,:,92),wf(:,-3),G2(:,:,:,101))
  call loop_A_Q(G2(:,:,:,101),Q(:,28),MT,G3(:,:,:,86))
  call loop_AV_Q(G3(:,:,:,86),wf(:,37),G3(:,:,:,87))
  call loop_A_Q(G3(:,:,:,87),Q(:,62),MT,G4(:,:,:,51))
  call loop_AS_Q(G4(:,:,:,51),wf(:,0),G4(:,:,:,52),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,52),Q(:,63),MT,G5tensor(:,15))
  call loop_AV_Q(G3(:,:,:,86),wf(:,-1),G3(:,:,:,88))
  call loop_A_Q(G3(:,:,:,88),Q(:,30),MT,G4(:,:,:,53))
  call loop_AV_Q(G4(:,:,:,53),wf(:,-5),G4(:,:,:,54))
  call loop_A_Q(G4(:,:,:,54),Q(:,62),MT,G5(:,:,:,23))
  call loop_AS_Q(G5(:,:,:,23),wf(:,0),G5(:,:,:,24),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,24),Q(:,63),MT,G6tensor(:,12))
  call loop_AV_Q(G2(:,:,:,92),wf(:,197),G2(:,:,:,102))
  call loop_A_Q(G2(:,:,:,102),Q(:,62),MT,G3(:,:,:,89))
  call loop_AS_Q(G3(:,:,:,89),wf(:,0),G3(:,:,:,90),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,90),Q(:,63),MT,G4tensor(:,24))
  call loop_AV_Q(G2(:,:,:,92),wf(:,-1),G2(:,:,:,103))
  call loop_A_Q(G2(:,:,:,103),Q(:,22),MT,G3(:,:,:,91))
  call loop_AV_Q(G3(:,:,:,91),wf(:,109),G3(:,:,:,92))
  call loop_A_Q(G3(:,:,:,92),Q(:,62),MT,G4(:,:,:,55))
  call loop_AS_Q(G4(:,:,:,55),wf(:,0),G4(:,:,:,56),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,56),Q(:,63),MT,G5tensor(:,16))
  call loop_AV_Q(G3(:,:,:,91),wf(:,-5),G3(:,:,:,93))
  call loop_A_Q(G3(:,:,:,93),Q(:,54),MT,G4(:,:,:,57))
  call loop_AV_Q(G4(:,:,:,57),wf(:,-3),G4(:,:,:,58))
  call loop_A_Q(G4(:,:,:,58),Q(:,62),MT,G5(:,:,:,25))
  call loop_AS_Q(G5(:,:,:,25),wf(:,0),G5(:,:,:,26),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,26),Q(:,63),MT,G6tensor(:,13))
  call loop_AV_Q(G3(:,:,:,91),wf(:,-3),G3(:,:,:,94))
  call loop_A_Q(G3(:,:,:,94),Q(:,30),MT,G4(:,:,:,59))
  call loop_AV_Q(G4(:,:,:,59),wf(:,-5),G4(:,:,:,60))
  call loop_A_Q(G4(:,:,:,60),Q(:,62),MT,G5(:,:,:,27))
  call loop_AS_Q(G5(:,:,:,27),wf(:,0),G5(:,:,:,28),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,28),Q(:,63),MT,G6tensor(:,14))
  call loop_AV_Q(G1(:,:,:,1),wf(:,331),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,62),MT,G2(:,:,:,104))
  call loop_AS_Q(G2(:,:,:,104),wf(:,0),G2(:,:,:,105),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,105),Q(:,63),MT,G3tensor(:,28))
  call loop_AV_Q(G1(:,:,:,1),wf(:,332),G1(:,:,:,39))
  call loop_A_Q(G1(:,:,:,39),Q(:,62),MT,G2(:,:,:,106))
  call loop_AS_Q(G2(:,:,:,106),wf(:,0),G2(:,:,:,107),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,107),Q(:,63),MT,G3tensor(:,29))
  call loop_AV_Q(G1(:,:,:,1),wf(:,333),G1(:,:,:,40))
  call loop_A_Q(G1(:,:,:,40),Q(:,62),MT,G2(:,:,:,108))
  call loop_AS_Q(G2(:,:,:,108),wf(:,0),G2(:,:,:,109),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,109),Q(:,63),MT,G3tensor(:,30))
  call loop_AV_Q(G1(:,:,:,1),wf(:,85),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,30),MT,G2(:,:,:,110))
  call loop_AV_Q(G2(:,:,:,110),wf(:,-5),G2(:,:,:,111))
  call loop_A_Q(G2(:,:,:,111),Q(:,62),MT,G3(:,:,:,95))
  call loop_AS_Q(G3(:,:,:,95),wf(:,0),G3(:,:,:,96),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,96),Q(:,63),MT,G4tensor(:,25))
  call loop_AV_Q(G1(:,:,:,1),wf(:,87),G1(:,:,:,42))
  call loop_A_Q(G1(:,:,:,42),Q(:,30),MT,G2(:,:,:,112))
  call loop_AV_Q(G2(:,:,:,112),wf(:,-5),G2(:,:,:,113))
  call loop_A_Q(G2(:,:,:,113),Q(:,62),MT,G3(:,:,:,97))
  call loop_AS_Q(G3(:,:,:,97),wf(:,0),G3(:,:,:,98),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,98),Q(:,63),MT,G4tensor(:,26))
  call loop_AV_Q(G1(:,:,:,1),wf(:,88),G1(:,:,:,43))
  call loop_A_Q(G1(:,:,:,43),Q(:,30),MT,G2(:,:,:,114))
  call loop_AV_Q(G2(:,:,:,114),wf(:,-5),G2(:,:,:,115))
  call loop_A_Q(G2(:,:,:,115),Q(:,62),MT,G3(:,:,:,99))
  call loop_AS_Q(G3(:,:,:,99),wf(:,0),G3(:,:,:,100),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,100),Q(:,63),MT,G4tensor(:,27))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-5),G1(:,:,:,44))
  call loop_A_Q(G1(:,:,:,44),Q(:,36),MT,G2(:,:,:,116))
  call loop_AV_Q(G2(:,:,:,116),wf(:,85),G2(:,:,:,117))
  call loop_A_Q(G2(:,:,:,117),Q(:,62),MT,G3(:,:,:,101))
  call loop_AS_Q(G3(:,:,:,101),wf(:,0),G3(:,:,:,102),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,102),Q(:,63),MT,G4tensor(:,28))
  call loop_AV_Q(G2(:,:,:,116),wf(:,87),G2(:,:,:,118))
  call loop_A_Q(G2(:,:,:,118),Q(:,62),MT,G3(:,:,:,103))
  call loop_AS_Q(G3(:,:,:,103),wf(:,0),G3(:,:,:,104),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,104),Q(:,63),MT,G4tensor(:,29))
  call loop_AV_Q(G2(:,:,:,116),wf(:,88),G2(:,:,:,119))
  call loop_A_Q(G2(:,:,:,119),Q(:,62),MT,G3(:,:,:,105))
  call loop_AS_Q(G3(:,:,:,105),wf(:,0),G3(:,:,:,106),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,106),Q(:,63),MT,G4tensor(:,30))
  call loop_AV_Q(G2(:,:,:,116),wf(:,179),G2(:,:,:,120))
  call loop_A_Q(G2(:,:,:,120),Q(:,62),MT,G3(:,:,:,107))
  call loop_AS_Q(G3(:,:,:,107),wf(:,0),G3(:,:,:,108),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,108),Q(:,63),MT,G4tensor(:,31))
  call loop_AV_Q(G2(:,:,:,116),wf(:,18),G2(:,:,:,121))
  call loop_A_Q(G2(:,:,:,121),Q(:,46),MT,G3(:,:,:,109))
  call loop_AV_Q(G3(:,:,:,109),wf(:,-4),G3(:,:,:,110))
  call loop_A_Q(G3(:,:,:,110),Q(:,62),MT,G4(:,:,:,61))
  call loop_AS_Q(G4(:,:,:,61),wf(:,0),G4(:,:,:,62),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,62),Q(:,63),MT,G5tensor(:,17))
  call loop_AV_Q(G2(:,:,:,116),wf(:,-4),G2(:,:,:,122))
  call loop_A_Q(G2(:,:,:,122),Q(:,52),MT,G3(:,:,:,111))
  call loop_AV_Q(G3(:,:,:,111),wf(:,18),G3(:,:,:,112))
  call loop_A_Q(G3(:,:,:,112),Q(:,62),MT,G4(:,:,:,63))
  call loop_AS_Q(G4(:,:,:,63),wf(:,0),G4(:,:,:,64),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,64),Q(:,63),MT,G5tensor(:,18))
  call loop_AV_Q(G3(:,:,:,111),wf(:,-1),G3(:,:,:,113))
  call loop_A_Q(G3(:,:,:,113),Q(:,54),MT,G4(:,:,:,65))
  call loop_AV_Q(G4(:,:,:,65),wf(:,-3),G4(:,:,:,66))
  call loop_A_Q(G4(:,:,:,66),Q(:,62),MT,G5(:,:,:,29))
  call loop_AS_Q(G5(:,:,:,29),wf(:,0),G5(:,:,:,30),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,30),Q(:,63),MT,G6tensor(:,15))
  call loop_AV_Q(G2(:,:,:,116),wf(:,192),G2(:,:,:,123))
  call loop_A_Q(G2(:,:,:,123),Q(:,62),MT,G3(:,:,:,114))
  call loop_AS_Q(G3(:,:,:,114),wf(:,0),G3(:,:,:,115),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,115),Q(:,63),MT,G4tensor(:,32))
  call loop_AV_Q(G2(:,:,:,116),wf(:,29),G2(:,:,:,124))
  call loop_A_Q(G2(:,:,:,124),Q(:,54),MT,G3(:,:,:,116))
  call loop_AV_Q(G3(:,:,:,116),wf(:,-3),G3(:,:,:,117))
  call loop_A_Q(G3(:,:,:,117),Q(:,62),MT,G4(:,:,:,67))
  call loop_AS_Q(G4(:,:,:,67),wf(:,0),G4(:,:,:,68),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,68),Q(:,63),MT,G5tensor(:,19))
  call loop_AV_Q(G2(:,:,:,116),wf(:,-3),G2(:,:,:,125))
  call loop_A_Q(G2(:,:,:,125),Q(:,44),MT,G3(:,:,:,118))
  call loop_AV_Q(G3(:,:,:,118),wf(:,29),G3(:,:,:,119))
  call loop_A_Q(G3(:,:,:,119),Q(:,62),MT,G4(:,:,:,69))
  call loop_AS_Q(G4(:,:,:,69),wf(:,0),G4(:,:,:,70),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,70),Q(:,63),MT,G5tensor(:,20))
  call loop_AV_Q(G3(:,:,:,118),wf(:,-1),G3(:,:,:,120))
  call loop_A_Q(G3(:,:,:,120),Q(:,46),MT,G4(:,:,:,71))
  call loop_AV_Q(G4(:,:,:,71),wf(:,-4),G4(:,:,:,72))
  call loop_A_Q(G4(:,:,:,72),Q(:,62),MT,G5(:,:,:,31))
  call loop_AS_Q(G5(:,:,:,31),wf(:,0),G5(:,:,:,32),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,32),Q(:,63),MT,G6tensor(:,16))
  call loop_AV_Q(G2(:,:,:,116),wf(:,201),G2(:,:,:,126))
  call loop_A_Q(G2(:,:,:,126),Q(:,62),MT,G3(:,:,:,121))
  call loop_AS_Q(G3(:,:,:,121),wf(:,0),G3(:,:,:,122),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,122),Q(:,63),MT,G4tensor(:,33))
  call loop_AV_Q(G2(:,:,:,116),wf(:,-1),G2(:,:,:,127))
  call loop_A_Q(G2(:,:,:,127),Q(:,38),MT,G3(:,:,:,123))
  call loop_AV_Q(G3(:,:,:,123),wf(:,101),G3(:,:,:,124))
  call loop_A_Q(G3(:,:,:,124),Q(:,62),MT,G4(:,:,:,73))
  call loop_AS_Q(G4(:,:,:,73),wf(:,0),G4(:,:,:,74),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,74),Q(:,63),MT,G5tensor(:,21))
  call loop_AV_Q(G3(:,:,:,123),wf(:,-4),G3(:,:,:,125))
  call loop_A_Q(G3(:,:,:,125),Q(:,54),MT,G4(:,:,:,75))
  call loop_AV_Q(G4(:,:,:,75),wf(:,-3),G4(:,:,:,76))
  call loop_A_Q(G4(:,:,:,76),Q(:,62),MT,G5(:,:,:,33))
  call loop_AS_Q(G5(:,:,:,33),wf(:,0),G5(:,:,:,34),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,34),Q(:,63),MT,G6tensor(:,17))
  call loop_AV_Q(G3(:,:,:,123),wf(:,-3),G3(:,:,:,126))
  call loop_A_Q(G3(:,:,:,126),Q(:,46),MT,G4(:,:,:,77))
  call loop_AV_Q(G4(:,:,:,77),wf(:,-4),G4(:,:,:,78))
  call loop_A_Q(G4(:,:,:,78),Q(:,62),MT,G5(:,:,:,35))
  call loop_AS_Q(G5(:,:,:,35),wf(:,0),G5(:,:,:,36),gH)
  call check_last_A_Q(l_switch,G5(:,:,:,36),Q(:,63),MT,G6tensor(:,18))
  call loop_AV_Q(G1(:,:,:,1),wf(:,372),G1(:,:,:,45))
  call loop_A_Q(G1(:,:,:,45),Q(:,62),MT,G2(:,:,:,128))
  call loop_AS_Q(G2(:,:,:,128),wf(:,0),G2(:,:,:,129),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,129),Q(:,63),MT,G3tensor(:,31))
  call loop_AV_Q(G1(:,:,:,1),wf(:,119),G1(:,:,:,46))
  call loop_A_Q(G1(:,:,:,46),Q(:,52),MT,G2(:,:,:,130))
  call loop_AV_Q(G2(:,:,:,130),wf(:,18),G2(:,:,:,131))
  call loop_A_Q(G2(:,:,:,131),Q(:,62),MT,G3(:,:,:,127))
  call loop_AS_Q(G3(:,:,:,127),wf(:,0),G3(:,:,:,128),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,128),Q(:,63),MT,G4tensor(:,34))
  call loop_AV_Q(G2(:,:,:,130),wf(:,-1),G2(:,:,:,132))
  call loop_A_Q(G2(:,:,:,132),Q(:,54),MT,G3(:,:,:,129))
  call loop_AV_Q(G3(:,:,:,129),wf(:,-3),G3(:,:,:,130))
  call loop_A_Q(G3(:,:,:,130),Q(:,62),MT,G4(:,:,:,79))
  call loop_AS_Q(G4(:,:,:,79),wf(:,0),G4(:,:,:,80),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,80),Q(:,63),MT,G5tensor(:,22))
  call loop_AV_Q(G1(:,:,:,1),wf(:,18),G1(:,:,:,47))
  call loop_A_Q(G1(:,:,:,47),Q(:,14),MT,G2(:,:,:,133))
  call loop_AV_Q(G2(:,:,:,133),wf(:,119),G2(:,:,:,134))
  call loop_A_Q(G2(:,:,:,134),Q(:,62),MT,G3(:,:,:,131))
  call loop_AS_Q(G3(:,:,:,131),wf(:,0),G3(:,:,:,132),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,132),Q(:,63),MT,G4tensor(:,35))
  call loop_AV_Q(G2(:,:,:,133),wf(:,-5),G2(:,:,:,135))
  call loop_A_Q(G2(:,:,:,135),Q(:,46),MT,G3(:,:,:,133))
  call loop_AV_Q(G3(:,:,:,133),wf(:,-4),G3(:,:,:,134))
  call loop_A_Q(G3(:,:,:,134),Q(:,62),MT,G4(:,:,:,81))
  call loop_AS_Q(G4(:,:,:,81),wf(:,0),G4(:,:,:,82),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,82),Q(:,63),MT,G5tensor(:,23))
  call loop_AV_Q(G2(:,:,:,133),wf(:,-4),G2(:,:,:,136))
  call loop_A_Q(G2(:,:,:,136),Q(:,30),MT,G3(:,:,:,135))
  call loop_AV_Q(G3(:,:,:,135),wf(:,-5),G3(:,:,:,136))
  call loop_A_Q(G3(:,:,:,136),Q(:,62),MT,G4(:,:,:,83))
  call loop_AS_Q(G4(:,:,:,83),wf(:,0),G4(:,:,:,84),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,84),Q(:,63),MT,G5tensor(:,24))
  call loop_AV_Q(G1(:,:,:,1),wf(:,376),G1(:,:,:,48))
  call loop_A_Q(G1(:,:,:,48),Q(:,62),MT,G2(:,:,:,137))
  call loop_AS_Q(G2(:,:,:,137),wf(:,0),G2(:,:,:,138),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,138),Q(:,63),MT,G3tensor(:,32))
  call loop_AV_Q(G1(:,:,:,1),wf(:,179),G1(:,:,:,49))
  call loop_A_Q(G1(:,:,:,49),Q(:,30),MT,G2(:,:,:,139))
  call loop_AV_Q(G2(:,:,:,139),wf(:,-5),G2(:,:,:,140))
  call loop_A_Q(G2(:,:,:,140),Q(:,62),MT,G3(:,:,:,137))
  call loop_AS_Q(G3(:,:,:,137),wf(:,0),G3(:,:,:,138),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,138),Q(:,63),MT,G4tensor(:,36))
  call loop_AV_Q(G1(:,:,:,1),wf(:,378),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,62),MT,G2(:,:,:,141))
  call loop_AS_Q(G2(:,:,:,141),wf(:,0),G2(:,:,:,142),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,142),Q(:,63),MT,G3tensor(:,33))
  call loop_AV_Q(G1(:,:,:,1),wf(:,176),G1(:,:,:,51))
  call loop_A_Q(G1(:,:,:,51),Q(:,46),MT,G2(:,:,:,143))
  call loop_AV_Q(G2(:,:,:,143),wf(:,-4),G2(:,:,:,144))
  call loop_A_Q(G2(:,:,:,144),Q(:,62),MT,G3(:,:,:,139))
  call loop_AS_Q(G3(:,:,:,139),wf(:,0),G3(:,:,:,140),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,140),Q(:,63),MT,G4tensor(:,37))
  call loop_AV_Q(G1(:,:,:,1),wf(:,389),G1(:,:,:,52))
  call loop_A_Q(G1(:,:,:,52),Q(:,62),MT,G2(:,:,:,145))
  call loop_AS_Q(G2(:,:,:,145),wf(:,0),G2(:,:,:,146),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,146),Q(:,63),MT,G3tensor(:,34))
  call loop_AV_Q(G1(:,:,:,1),wf(:,109),G1(:,:,:,53))
  call loop_A_Q(G1(:,:,:,53),Q(:,44),MT,G2(:,:,:,147))
  call loop_AV_Q(G2(:,:,:,147),wf(:,29),G2(:,:,:,148))
  call loop_A_Q(G2(:,:,:,148),Q(:,62),MT,G3(:,:,:,141))
  call loop_AS_Q(G3(:,:,:,141),wf(:,0),G3(:,:,:,142),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,142),Q(:,63),MT,G4tensor(:,38))
  call loop_AV_Q(G2(:,:,:,147),wf(:,-1),G2(:,:,:,149))
  call loop_A_Q(G2(:,:,:,149),Q(:,46),MT,G3(:,:,:,143))
  call loop_AV_Q(G3(:,:,:,143),wf(:,-4),G3(:,:,:,144))
  call loop_A_Q(G3(:,:,:,144),Q(:,62),MT,G4(:,:,:,85))
  call loop_AS_Q(G4(:,:,:,85),wf(:,0),G4(:,:,:,86),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,86),Q(:,63),MT,G5tensor(:,25))
  call loop_AV_Q(G1(:,:,:,1),wf(:,29),G1(:,:,:,54))
  call loop_A_Q(G1(:,:,:,54),Q(:,22),MT,G2(:,:,:,150))
  call loop_AV_Q(G2(:,:,:,150),wf(:,109),G2(:,:,:,151))
  call loop_A_Q(G2(:,:,:,151),Q(:,62),MT,G3(:,:,:,145))
  call loop_AS_Q(G3(:,:,:,145),wf(:,0),G3(:,:,:,146),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,146),Q(:,63),MT,G4tensor(:,39))
  call loop_AV_Q(G2(:,:,:,150),wf(:,-5),G2(:,:,:,152))
  call loop_A_Q(G2(:,:,:,152),Q(:,54),MT,G3(:,:,:,147))
  call loop_AV_Q(G3(:,:,:,147),wf(:,-3),G3(:,:,:,148))
  call loop_A_Q(G3(:,:,:,148),Q(:,62),MT,G4(:,:,:,87))
  call loop_AS_Q(G4(:,:,:,87),wf(:,0),G4(:,:,:,88),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,88),Q(:,63),MT,G5tensor(:,26))
  call loop_AV_Q(G2(:,:,:,150),wf(:,-3),G2(:,:,:,153))
  call loop_A_Q(G2(:,:,:,153),Q(:,30),MT,G3(:,:,:,149))
  call loop_AV_Q(G3(:,:,:,149),wf(:,-5),G3(:,:,:,150))
  call loop_A_Q(G3(:,:,:,150),Q(:,62),MT,G4(:,:,:,89))
  call loop_AS_Q(G4(:,:,:,89),wf(:,0),G4(:,:,:,90),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,90),Q(:,63),MT,G5tensor(:,27))
  call loop_AV_Q(G1(:,:,:,1),wf(:,393),G1(:,:,:,55))
  call loop_A_Q(G1(:,:,:,55),Q(:,62),MT,G2(:,:,:,154))
  call loop_AS_Q(G2(:,:,:,154),wf(:,0),G2(:,:,:,155),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,155),Q(:,63),MT,G3tensor(:,35))
  call loop_AV_Q(G1(:,:,:,1),wf(:,192),G1(:,:,:,56))
  call loop_A_Q(G1(:,:,:,56),Q(:,30),MT,G2(:,:,:,156))
  call loop_AV_Q(G2(:,:,:,156),wf(:,-5),G2(:,:,:,157))
  call loop_A_Q(G2(:,:,:,157),Q(:,62),MT,G3(:,:,:,151))
  call loop_AS_Q(G3(:,:,:,151),wf(:,0),G3(:,:,:,152),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,152),Q(:,63),MT,G4tensor(:,40))
  call loop_AV_Q(G1(:,:,:,1),wf(:,395),G1(:,:,:,57))
  call loop_A_Q(G1(:,:,:,57),Q(:,62),MT,G2(:,:,:,158))
  call loop_AS_Q(G2(:,:,:,158),wf(:,0),G2(:,:,:,159),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,159),Q(:,63),MT,G3tensor(:,36))
  call loop_AV_Q(G1(:,:,:,1),wf(:,184),G1(:,:,:,58))
  call loop_A_Q(G1(:,:,:,58),Q(:,54),MT,G2(:,:,:,160))
  call loop_AV_Q(G2(:,:,:,160),wf(:,-3),G2(:,:,:,161))
  call loop_A_Q(G2(:,:,:,161),Q(:,62),MT,G3(:,:,:,153))
  call loop_AS_Q(G3(:,:,:,153),wf(:,0),G3(:,:,:,154),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,154),Q(:,63),MT,G4tensor(:,41))
  call loop_AV_Q(G1(:,:,:,1),wf(:,404),G1(:,:,:,59))
  call loop_A_Q(G1(:,:,:,59),Q(:,62),MT,G2(:,:,:,162))
  call loop_AS_Q(G2(:,:,:,162),wf(:,0),G2(:,:,:,163),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,163),Q(:,63),MT,G3tensor(:,37))
  call loop_AV_Q(G1(:,:,:,1),wf(:,101),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,28),MT,G2(:,:,:,164))
  call loop_AV_Q(G2(:,:,:,164),wf(:,37),G2(:,:,:,165))
  call loop_A_Q(G2(:,:,:,165),Q(:,62),MT,G3(:,:,:,155))
  call loop_AS_Q(G3(:,:,:,155),wf(:,0),G3(:,:,:,156),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,156),Q(:,63),MT,G4tensor(:,42))
  call loop_AV_Q(G2(:,:,:,164),wf(:,-1),G2(:,:,:,166))
  call loop_A_Q(G2(:,:,:,166),Q(:,30),MT,G3(:,:,:,157))
  call loop_AV_Q(G3(:,:,:,157),wf(:,-5),G3(:,:,:,158))
  call loop_A_Q(G3(:,:,:,158),Q(:,62),MT,G4(:,:,:,91))
  call loop_AS_Q(G4(:,:,:,91),wf(:,0),G4(:,:,:,92),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,92),Q(:,63),MT,G5tensor(:,28))
  call loop_AV_Q(G1(:,:,:,1),wf(:,37),G1(:,:,:,61))
  call loop_A_Q(G1(:,:,:,61),Q(:,38),MT,G2(:,:,:,167))
  call loop_AV_Q(G2(:,:,:,167),wf(:,101),G2(:,:,:,168))
  call loop_A_Q(G2(:,:,:,168),Q(:,62),MT,G3(:,:,:,159))
  call loop_AS_Q(G3(:,:,:,159),wf(:,0),G3(:,:,:,160),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,160),Q(:,63),MT,G4tensor(:,43))
  call loop_AV_Q(G2(:,:,:,167),wf(:,-4),G2(:,:,:,169))
  call loop_A_Q(G2(:,:,:,169),Q(:,54),MT,G3(:,:,:,161))
  call loop_AV_Q(G3(:,:,:,161),wf(:,-3),G3(:,:,:,162))
  call loop_A_Q(G3(:,:,:,162),Q(:,62),MT,G4(:,:,:,93))
  call loop_AS_Q(G4(:,:,:,93),wf(:,0),G4(:,:,:,94),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,94),Q(:,63),MT,G5tensor(:,29))
  call loop_AV_Q(G2(:,:,:,167),wf(:,-3),G2(:,:,:,170))
  call loop_A_Q(G2(:,:,:,170),Q(:,46),MT,G3(:,:,:,163))
  call loop_AV_Q(G3(:,:,:,163),wf(:,-4),G3(:,:,:,164))
  call loop_A_Q(G3(:,:,:,164),Q(:,62),MT,G4(:,:,:,95))
  call loop_AS_Q(G4(:,:,:,95),wf(:,0),G4(:,:,:,96),gH)
  call check_last_A_Q(l_switch,G4(:,:,:,96),Q(:,63),MT,G5tensor(:,30))
  call loop_AV_Q(G1(:,:,:,1),wf(:,408),G1(:,:,:,62))
  call loop_A_Q(G1(:,:,:,62),Q(:,62),MT,G2(:,:,:,171))
  call loop_AS_Q(G2(:,:,:,171),wf(:,0),G2(:,:,:,172),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,172),Q(:,63),MT,G3tensor(:,38))
  call loop_AV_Q(G1(:,:,:,1),wf(:,201),G1(:,:,:,63))
  call loop_A_Q(G1(:,:,:,63),Q(:,30),MT,G2(:,:,:,173))
  call loop_AV_Q(G2(:,:,:,173),wf(:,-5),G2(:,:,:,174))
  call loop_A_Q(G2(:,:,:,174),Q(:,62),MT,G3(:,:,:,165))
  call loop_AS_Q(G3(:,:,:,165),wf(:,0),G3(:,:,:,166),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,166),Q(:,63),MT,G4tensor(:,44))
  call loop_AV_Q(G1(:,:,:,1),wf(:,409),G1(:,:,:,64))
  call loop_A_Q(G1(:,:,:,64),Q(:,62),MT,G2(:,:,:,175))
  call loop_AS_Q(G2(:,:,:,175),wf(:,0),G2(:,:,:,176),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,176),Q(:,63),MT,G3tensor(:,39))
  call loop_AV_Q(G1(:,:,:,1),wf(:,415),G1(:,:,:,65))
  call loop_A_Q(G1(:,:,:,65),Q(:,62),MT,G2(:,:,:,177))
  call loop_AS_Q(G2(:,:,:,177),wf(:,0),G2(:,:,:,178),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,178),Q(:,63),MT,G3tensor(:,40))
  call loop_AV_Q(G1(:,:,:,1),wf(:,196),G1(:,:,:,66))
  call loop_A_Q(G1(:,:,:,66),Q(:,46),MT,G2(:,:,:,179))
  call loop_AV_Q(G2(:,:,:,179),wf(:,-4),G2(:,:,:,180))
  call loop_A_Q(G2(:,:,:,180),Q(:,62),MT,G3(:,:,:,167))
  call loop_AS_Q(G3(:,:,:,167),wf(:,0),G3(:,:,:,168),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,168),Q(:,63),MT,G4tensor(:,45))
  call loop_AV_Q(G1(:,:,:,1),wf(:,417),G1(:,:,:,67))
  call loop_A_Q(G1(:,:,:,67),Q(:,62),MT,G2(:,:,:,181))
  call loop_AS_Q(G2(:,:,:,181),wf(:,0),G2(:,:,:,182),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,182),Q(:,63),MT,G3tensor(:,41))
  call loop_AV_Q(G1(:,:,:,1),wf(:,187),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,54),MT,G2(:,:,:,183))
  call loop_AV_Q(G2(:,:,:,183),wf(:,-3),G2(:,:,:,184))
  call loop_A_Q(G2(:,:,:,184),Q(:,62),MT,G3(:,:,:,169))
  call loop_AS_Q(G3(:,:,:,169),wf(:,0),G3(:,:,:,170),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,170),Q(:,63),MT,G4tensor(:,46))
  call loop_AV_Q(G1(:,:,:,1),wf(:,426),G1(:,:,:,69))
  call loop_A_Q(G1(:,:,:,69),Q(:,62),MT,G2(:,:,:,185))
  call loop_AS_Q(G2(:,:,:,185),wf(:,0),G2(:,:,:,186),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,186),Q(:,63),MT,G3tensor(:,42))
  call loop_AV_Q(G1(:,:,:,1),wf(:,197),G1(:,:,:,70))
  call loop_A_Q(G1(:,:,:,70),Q(:,46),MT,G2(:,:,:,187))
  call loop_AV_Q(G2(:,:,:,187),wf(:,-4),G2(:,:,:,188))
  call loop_A_Q(G2(:,:,:,188),Q(:,62),MT,G3(:,:,:,171))
  call loop_AS_Q(G3(:,:,:,171),wf(:,0),G3(:,:,:,172),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,172),Q(:,63),MT,G4tensor(:,47))
  call loop_AV_Q(G1(:,:,:,1),wf(:,427),G1(:,:,:,71))
  call loop_A_Q(G1(:,:,:,71),Q(:,62),MT,G2(:,:,:,189))
  call loop_AS_Q(G2(:,:,:,189),wf(:,0),G2(:,:,:,190),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,190),Q(:,63),MT,G3tensor(:,43))
  call loop_AV_Q(G1(:,:,:,1),wf(:,432),G1(:,:,:,72))
  call loop_A_Q(G1(:,:,:,72),Q(:,62),MT,G2(:,:,:,191))
  call loop_AS_Q(G2(:,:,:,191),wf(:,0),G2(:,:,:,192),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,192),Q(:,63),MT,G3tensor(:,44))
  call loop_AV_Q(G1(:,:,:,1),wf(:,433),G1(:,:,:,73))
  call loop_A_Q(G1(:,:,:,73),Q(:,62),MT,G2(:,:,:,193))
  call loop_AS_Q(G2(:,:,:,193),wf(:,0),G2(:,:,:,194),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,194),Q(:,63),MT,G3tensor(:,45))
  call loop_AV_Q(G1(:,:,:,1),wf(:,188),G1(:,:,:,74))
  call loop_A_Q(G1(:,:,:,74),Q(:,54),MT,G2(:,:,:,195))
  call loop_AV_Q(G2(:,:,:,195),wf(:,-3),G2(:,:,:,196))
  call loop_A_Q(G2(:,:,:,196),Q(:,62),MT,G3(:,:,:,173))
  call loop_AS_Q(G3(:,:,:,173),wf(:,0),G3(:,:,:,174),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,174),Q(:,63),MT,G4tensor(:,48))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,4),MT,G1(:,:,:,75))
  call loop_QV_A(G1(:,:,:,75),wf(:,220),G1(:,:,:,76))
  call loop_Q_A(G1(:,:,:,76),Q(:,62),MT,G2(:,:,:,197))
  call loop_QS_A(G2(:,:,:,197),wf(:,0),G2(:,:,:,198),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,198),Q(:,63),MT,G3tensor(:,46))
  call loop_QV_A(G1(:,:,:,75),wf(:,221),G1(:,:,:,77))
  call loop_Q_A(G1(:,:,:,77),Q(:,62),MT,G2(:,:,:,199))
  call loop_QS_A(G2(:,:,:,199),wf(:,0),G2(:,:,:,200),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,200),Q(:,63),MT,G3tensor(:,47))
  call loop_QV_A(G1(:,:,:,75),wf(:,222),G1(:,:,:,78))
  call loop_Q_A(G1(:,:,:,78),Q(:,62),MT,G2(:,:,:,201))
  call loop_QS_A(G2(:,:,:,201),wf(:,0),G2(:,:,:,202),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,202),Q(:,63),MT,G3tensor(:,48))
  call loop_QV_A(G1(:,:,:,75),wf(:,226),G1(:,:,:,79))
  call loop_Q_A(G1(:,:,:,79),Q(:,62),MT,G2(:,:,:,203))
  call loop_QS_A(G2(:,:,:,203),wf(:,0),G2(:,:,:,204),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,204),Q(:,63),MT,G3tensor(:,49))
  call loop_QV_A(G1(:,:,:,75),wf(:,227),G1(:,:,:,80))
  call loop_Q_A(G1(:,:,:,80),Q(:,62),MT,G2(:,:,:,205))
  call loop_QS_A(G2(:,:,:,205),wf(:,0),G2(:,:,:,206),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,206),Q(:,63),MT,G3tensor(:,50))
  call loop_QV_A(G1(:,:,:,75),wf(:,228),G1(:,:,:,81))
  call loop_Q_A(G1(:,:,:,81),Q(:,62),MT,G2(:,:,:,207))
  call loop_QS_A(G2(:,:,:,207),wf(:,0),G2(:,:,:,208),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,208),Q(:,63),MT,G3tensor(:,51))
  call loop_QV_A(G1(:,:,:,75),wf(:,232),G1(:,:,:,82))
  call loop_Q_A(G1(:,:,:,82),Q(:,62),MT,G2(:,:,:,209))
  call loop_QS_A(G2(:,:,:,209),wf(:,0),G2(:,:,:,210),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,210),Q(:,63),MT,G3tensor(:,52))
  call loop_QV_A(G1(:,:,:,75),wf(:,233),G1(:,:,:,83))
  call loop_Q_A(G1(:,:,:,83),Q(:,62),MT,G2(:,:,:,211))
  call loop_QS_A(G2(:,:,:,211),wf(:,0),G2(:,:,:,212),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,212),Q(:,63),MT,G3tensor(:,53))
  call loop_QV_A(G1(:,:,:,75),wf(:,234),G1(:,:,:,84))
  call loop_Q_A(G1(:,:,:,84),Q(:,62),MT,G2(:,:,:,213))
  call loop_QS_A(G2(:,:,:,213),wf(:,0),G2(:,:,:,214),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,214),Q(:,63),MT,G3tensor(:,54))
  call loop_QV_A(G1(:,:,:,75),wf(:,238),G1(:,:,:,85))
  call loop_Q_A(G1(:,:,:,85),Q(:,62),MT,G2(:,:,:,215))
  call loop_QS_A(G2(:,:,:,215),wf(:,0),G2(:,:,:,216),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,216),Q(:,63),MT,G3tensor(:,55))
  call loop_QV_A(G1(:,:,:,75),wf(:,239),G1(:,:,:,86))
  call loop_Q_A(G1(:,:,:,86),Q(:,62),MT,G2(:,:,:,217))
  call loop_QS_A(G2(:,:,:,217),wf(:,0),G2(:,:,:,218),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,218),Q(:,63),MT,G3tensor(:,56))
  call loop_QV_A(G1(:,:,:,75),wf(:,240),G1(:,:,:,87))
  call loop_Q_A(G1(:,:,:,87),Q(:,62),MT,G2(:,:,:,219))
  call loop_QS_A(G2(:,:,:,219),wf(:,0),G2(:,:,:,220),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,220),Q(:,63),MT,G3tensor(:,57))
  call loop_QV_A(G1(:,:,:,75),wf(:,-1),G1(:,:,:,88))
  call loop_Q_A(G1(:,:,:,88),Q(:,6),MT,G2(:,:,:,221))
  call loop_QV_A(G2(:,:,:,221),wf(:,2),G2(:,:,:,222))
  call loop_Q_A(G2(:,:,:,222),Q(:,62),MT,G3(:,:,:,175))
  call loop_QS_A(G3(:,:,:,175),wf(:,0),G3(:,:,:,176),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,176),Q(:,63),MT,G4tensor(:,49))
  call loop_QV_A(G2(:,:,:,221),wf(:,4),G2(:,:,:,223))
  call loop_Q_A(G2(:,:,:,223),Q(:,62),MT,G3(:,:,:,177))
  call loop_QS_A(G3(:,:,:,177),wf(:,0),G3(:,:,:,178),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,178),Q(:,63),MT,G4tensor(:,50))
  call loop_QV_A(G2(:,:,:,221),wf(:,5),G2(:,:,:,224))
  call loop_Q_A(G2(:,:,:,224),Q(:,62),MT,G3(:,:,:,179))
  call loop_QS_A(G3(:,:,:,179),wf(:,0),G3(:,:,:,180),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,180),Q(:,63),MT,G4tensor(:,51))
  call loop_QV_A(G2(:,:,:,221),wf(:,166),G2(:,:,:,225))
  call loop_Q_A(G2(:,:,:,225),Q(:,62),MT,G3(:,:,:,181))
  call loop_QS_A(G3(:,:,:,181),wf(:,0),G3(:,:,:,182),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,182),Q(:,63),MT,G4tensor(:,52))
  call loop_QV_A(G2(:,:,:,221),wf(:,101),G2(:,:,:,226))
  call loop_Q_A(G2(:,:,:,226),Q(:,30),MT,G3(:,:,:,183))
  call loop_QV_A(G3(:,:,:,183),wf(:,-5),G3(:,:,:,184))
  call loop_Q_A(G3(:,:,:,184),Q(:,62),MT,G4(:,:,:,97))
  call loop_QS_A(G4(:,:,:,97),wf(:,0),G4(:,:,:,98),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,98),Q(:,63),MT,G5tensor(:,31))
  call loop_QV_A(G2(:,:,:,221),wf(:,-5),G2(:,:,:,227))
  call loop_Q_A(G2(:,:,:,227),Q(:,38),MT,G3(:,:,:,185))
  call loop_QV_A(G3(:,:,:,185),wf(:,101),G3(:,:,:,186))
  call loop_Q_A(G3(:,:,:,186),Q(:,62),MT,G4(:,:,:,99))
  call loop_QS_A(G4(:,:,:,99),wf(:,0),G4(:,:,:,100),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,100),Q(:,63),MT,G5tensor(:,32))
  call loop_QV_A(G3(:,:,:,185),wf(:,-4),G3(:,:,:,187))
  call loop_Q_A(G3(:,:,:,187),Q(:,54),MT,G4(:,:,:,101))
  call loop_QV_A(G4(:,:,:,101),wf(:,-3),G4(:,:,:,102))
  call loop_Q_A(G4(:,:,:,102),Q(:,62),MT,G5(:,:,:,37))
  call loop_QS_A(G5(:,:,:,37),wf(:,0),G5(:,:,:,38),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,38),Q(:,63),MT,G6tensor(:,19))
  call loop_QV_A(G3(:,:,:,185),wf(:,-3),G3(:,:,:,188))
  call loop_Q_A(G3(:,:,:,188),Q(:,46),MT,G4(:,:,:,103))
  call loop_QV_A(G4(:,:,:,103),wf(:,-4),G4(:,:,:,104))
  call loop_Q_A(G4(:,:,:,104),Q(:,62),MT,G5(:,:,:,39))
  call loop_QS_A(G5(:,:,:,39),wf(:,0),G5(:,:,:,40),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,40),Q(:,63),MT,G6tensor(:,20))
  call loop_QV_A(G2(:,:,:,221),wf(:,169),G2(:,:,:,228))
  call loop_Q_A(G2(:,:,:,228),Q(:,62),MT,G3(:,:,:,189))
  call loop_QS_A(G3(:,:,:,189),wf(:,0),G3(:,:,:,190),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,190),Q(:,63),MT,G4tensor(:,53))
  call loop_QV_A(G2(:,:,:,221),wf(:,109),G2(:,:,:,229))
  call loop_Q_A(G2(:,:,:,229),Q(:,46),MT,G3(:,:,:,191))
  call loop_QV_A(G3(:,:,:,191),wf(:,-4),G3(:,:,:,192))
  call loop_Q_A(G3(:,:,:,192),Q(:,62),MT,G4(:,:,:,105))
  call loop_QS_A(G4(:,:,:,105),wf(:,0),G4(:,:,:,106),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,106),Q(:,63),MT,G5tensor(:,33))
  call loop_QV_A(G2(:,:,:,221),wf(:,-4),G2(:,:,:,230))
  call loop_Q_A(G2(:,:,:,230),Q(:,22),MT,G3(:,:,:,193))
  call loop_QV_A(G3(:,:,:,193),wf(:,109),G3(:,:,:,194))
  call loop_Q_A(G3(:,:,:,194),Q(:,62),MT,G4(:,:,:,107))
  call loop_QS_A(G4(:,:,:,107),wf(:,0),G4(:,:,:,108),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,108),Q(:,63),MT,G5tensor(:,34))
  call loop_QV_A(G3(:,:,:,193),wf(:,-5),G3(:,:,:,195))
  call loop_Q_A(G3(:,:,:,195),Q(:,54),MT,G4(:,:,:,109))
  call loop_QV_A(G4(:,:,:,109),wf(:,-3),G4(:,:,:,110))
  call loop_Q_A(G4(:,:,:,110),Q(:,62),MT,G5(:,:,:,41))
  call loop_QS_A(G5(:,:,:,41),wf(:,0),G5(:,:,:,42),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,42),Q(:,63),MT,G6tensor(:,21))
  call loop_QV_A(G3(:,:,:,193),wf(:,-3),G3(:,:,:,196))
  call loop_Q_A(G3(:,:,:,196),Q(:,30),MT,G4(:,:,:,111))
  call loop_QV_A(G4(:,:,:,111),wf(:,-5),G4(:,:,:,112))
  call loop_Q_A(G4(:,:,:,112),Q(:,62),MT,G5(:,:,:,43))
  call loop_QS_A(G5(:,:,:,43),wf(:,0),G5(:,:,:,44),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,44),Q(:,63),MT,G6tensor(:,22))
  call loop_QV_A(G2(:,:,:,221),wf(:,171),G2(:,:,:,231))
  call loop_Q_A(G2(:,:,:,231),Q(:,62),MT,G3(:,:,:,197))
  call loop_QS_A(G3(:,:,:,197),wf(:,0),G3(:,:,:,198),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,198),Q(:,63),MT,G4tensor(:,54))
  call loop_QV_A(G2(:,:,:,221),wf(:,119),G2(:,:,:,232))
  call loop_Q_A(G2(:,:,:,232),Q(:,54),MT,G3(:,:,:,199))
  call loop_QV_A(G3(:,:,:,199),wf(:,-3),G3(:,:,:,200))
  call loop_Q_A(G3(:,:,:,200),Q(:,62),MT,G4(:,:,:,113))
  call loop_QS_A(G4(:,:,:,113),wf(:,0),G4(:,:,:,114),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,114),Q(:,63),MT,G5tensor(:,35))
  call loop_QV_A(G2(:,:,:,221),wf(:,-3),G2(:,:,:,233))
  call loop_Q_A(G2(:,:,:,233),Q(:,14),MT,G3(:,:,:,201))
  call loop_QV_A(G3(:,:,:,201),wf(:,119),G3(:,:,:,202))
  call loop_Q_A(G3(:,:,:,202),Q(:,62),MT,G4(:,:,:,115))
  call loop_QS_A(G4(:,:,:,115),wf(:,0),G4(:,:,:,116),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,116),Q(:,63),MT,G5tensor(:,36))
  call loop_QV_A(G3(:,:,:,201),wf(:,-5),G3(:,:,:,203))
  call loop_Q_A(G3(:,:,:,203),Q(:,46),MT,G4(:,:,:,117))
  call loop_QV_A(G4(:,:,:,117),wf(:,-4),G4(:,:,:,118))
  call loop_Q_A(G4(:,:,:,118),Q(:,62),MT,G5(:,:,:,45))
  call loop_QS_A(G5(:,:,:,45),wf(:,0),G5(:,:,:,46),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,46),Q(:,63),MT,G6tensor(:,23))
  call loop_QV_A(G3(:,:,:,201),wf(:,-4),G3(:,:,:,204))
  call loop_Q_A(G3(:,:,:,204),Q(:,30),MT,G4(:,:,:,119))
  call loop_QV_A(G4(:,:,:,119),wf(:,-5),G4(:,:,:,120))
  call loop_Q_A(G4(:,:,:,120),Q(:,62),MT,G5(:,:,:,47))
  call loop_QS_A(G5(:,:,:,47),wf(:,0),G5(:,:,:,48),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,48),Q(:,63),MT,G6tensor(:,24))
  call loop_QV_A(G1(:,:,:,75),wf(:,298),G1(:,:,:,89))
  call loop_Q_A(G1(:,:,:,89),Q(:,62),MT,G2(:,:,:,234))
  call loop_QS_A(G2(:,:,:,234),wf(:,0),G2(:,:,:,235),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,235),Q(:,63),MT,G3tensor(:,58))
  call loop_QV_A(G1(:,:,:,75),wf(:,299),G1(:,:,:,90))
  call loop_Q_A(G1(:,:,:,90),Q(:,62),MT,G2(:,:,:,236))
  call loop_QS_A(G2(:,:,:,236),wf(:,0),G2(:,:,:,237),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,237),Q(:,63),MT,G3tensor(:,59))
  call loop_QV_A(G1(:,:,:,75),wf(:,300),G1(:,:,:,91))
  call loop_Q_A(G1(:,:,:,91),Q(:,62),MT,G2(:,:,:,238))
  call loop_QS_A(G2(:,:,:,238),wf(:,0),G2(:,:,:,239),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,239),Q(:,63),MT,G3tensor(:,60))
  call loop_QV_A(G1(:,:,:,75),wf(:,304),G1(:,:,:,92))
  call loop_Q_A(G1(:,:,:,92),Q(:,62),MT,G2(:,:,:,240))
  call loop_QS_A(G2(:,:,:,240),wf(:,0),G2(:,:,:,241),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,241),Q(:,63),MT,G3tensor(:,61))
  call loop_QV_A(G1(:,:,:,75),wf(:,305),G1(:,:,:,93))
  call loop_Q_A(G1(:,:,:,93),Q(:,62),MT,G2(:,:,:,242))
  call loop_QS_A(G2(:,:,:,242),wf(:,0),G2(:,:,:,243),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,243),Q(:,63),MT,G3tensor(:,62))
  call loop_QV_A(G1(:,:,:,75),wf(:,306),G1(:,:,:,94))
  call loop_Q_A(G1(:,:,:,94),Q(:,62),MT,G2(:,:,:,244))
  call loop_QS_A(G2(:,:,:,244),wf(:,0),G2(:,:,:,245),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,245),Q(:,63),MT,G3tensor(:,63))
  call loop_QV_A(G1(:,:,:,75),wf(:,310),G1(:,:,:,95))
  call loop_Q_A(G1(:,:,:,95),Q(:,62),MT,G2(:,:,:,246))
  call loop_QS_A(G2(:,:,:,246),wf(:,0),G2(:,:,:,247),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,247),Q(:,63),MT,G3tensor(:,64))
  call loop_QV_A(G1(:,:,:,75),wf(:,311),G1(:,:,:,96))
  call loop_Q_A(G1(:,:,:,96),Q(:,62),MT,G2(:,:,:,248))
  call loop_QS_A(G2(:,:,:,248),wf(:,0),G2(:,:,:,249),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,249),Q(:,63),MT,G3tensor(:,65))
  call loop_QV_A(G1(:,:,:,75),wf(:,312),G1(:,:,:,97))
  call loop_Q_A(G1(:,:,:,97),Q(:,62),MT,G2(:,:,:,250))
  call loop_QS_A(G2(:,:,:,250),wf(:,0),G2(:,:,:,251),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,251),Q(:,63),MT,G3tensor(:,66))
  call loop_QV_A(G1(:,:,:,75),wf(:,66),G1(:,:,:,98))
  call loop_Q_A(G1(:,:,:,98),Q(:,54),MT,G2(:,:,:,252))
  call loop_QV_A(G2(:,:,:,252),wf(:,-3),G2(:,:,:,253))
  call loop_Q_A(G2(:,:,:,253),Q(:,62),MT,G3(:,:,:,205))
  call loop_QS_A(G3(:,:,:,205),wf(:,0),G3(:,:,:,206),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,206),Q(:,63),MT,G4tensor(:,55))
  call loop_QV_A(G1(:,:,:,75),wf(:,68),G1(:,:,:,99))
  call loop_Q_A(G1(:,:,:,99),Q(:,54),MT,G2(:,:,:,254))
  call loop_QV_A(G2(:,:,:,254),wf(:,-3),G2(:,:,:,255))
  call loop_Q_A(G2(:,:,:,255),Q(:,62),MT,G3(:,:,:,207))
  call loop_QS_A(G3(:,:,:,207),wf(:,0),G3(:,:,:,208),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,208),Q(:,63),MT,G4tensor(:,56))
  call loop_QV_A(G1(:,:,:,75),wf(:,69),G1(:,:,:,100))
  call loop_Q_A(G1(:,:,:,100),Q(:,54),MT,G2(:,:,:,256))
  call loop_QV_A(G2(:,:,:,256),wf(:,-3),G2(:,:,:,257))
  call loop_Q_A(G2(:,:,:,257),Q(:,62),MT,G3(:,:,:,209))
  call loop_QS_A(G3(:,:,:,209),wf(:,0),G3(:,:,:,210),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,210),Q(:,63),MT,G4tensor(:,57))
  call loop_QV_A(G1(:,:,:,75),wf(:,-3),G1(:,:,:,101))
  call loop_Q_A(G1(:,:,:,101),Q(:,12),MT,G2(:,:,:,258))
  call loop_QV_A(G2(:,:,:,258),wf(:,66),G2(:,:,:,259))
  call loop_Q_A(G2(:,:,:,259),Q(:,62),MT,G3(:,:,:,211))
  call loop_QS_A(G3(:,:,:,211),wf(:,0),G3(:,:,:,212),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,212),Q(:,63),MT,G4tensor(:,58))
  call loop_QV_A(G2(:,:,:,258),wf(:,68),G2(:,:,:,260))
  call loop_Q_A(G2(:,:,:,260),Q(:,62),MT,G3(:,:,:,213))
  call loop_QS_A(G3(:,:,:,213),wf(:,0),G3(:,:,:,214),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,214),Q(:,63),MT,G4tensor(:,59))
  call loop_QV_A(G2(:,:,:,258),wf(:,69),G2(:,:,:,261))
  call loop_Q_A(G2(:,:,:,261),Q(:,62),MT,G3(:,:,:,215))
  call loop_QS_A(G3(:,:,:,215),wf(:,0),G3(:,:,:,216),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,216),Q(:,63),MT,G4tensor(:,60))
  call loop_QV_A(G2(:,:,:,258),wf(:,184),G2(:,:,:,262))
  call loop_Q_A(G2(:,:,:,262),Q(:,62),MT,G3(:,:,:,217))
  call loop_QS_A(G3(:,:,:,217),wf(:,0),G3(:,:,:,218),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,218),Q(:,63),MT,G4tensor(:,61))
  call loop_QV_A(G2(:,:,:,258),wf(:,29),G2(:,:,:,263))
  call loop_Q_A(G2(:,:,:,263),Q(:,30),MT,G3(:,:,:,219))
  call loop_QV_A(G3(:,:,:,219),wf(:,-5),G3(:,:,:,220))
  call loop_Q_A(G3(:,:,:,220),Q(:,62),MT,G4(:,:,:,121))
  call loop_QS_A(G4(:,:,:,121),wf(:,0),G4(:,:,:,122),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,122),Q(:,63),MT,G5tensor(:,37))
  call loop_QV_A(G2(:,:,:,258),wf(:,-5),G2(:,:,:,264))
  call loop_Q_A(G2(:,:,:,264),Q(:,44),MT,G3(:,:,:,221))
  call loop_QV_A(G3(:,:,:,221),wf(:,29),G3(:,:,:,222))
  call loop_Q_A(G3(:,:,:,222),Q(:,62),MT,G4(:,:,:,123))
  call loop_QS_A(G4(:,:,:,123),wf(:,0),G4(:,:,:,124),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,124),Q(:,63),MT,G5tensor(:,38))
  call loop_QV_A(G3(:,:,:,221),wf(:,-1),G3(:,:,:,223))
  call loop_Q_A(G3(:,:,:,223),Q(:,46),MT,G4(:,:,:,125))
  call loop_QV_A(G4(:,:,:,125),wf(:,-4),G4(:,:,:,126))
  call loop_Q_A(G4(:,:,:,126),Q(:,62),MT,G5(:,:,:,49))
  call loop_QS_A(G5(:,:,:,49),wf(:,0),G5(:,:,:,50),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,50),Q(:,63),MT,G6tensor(:,25))
  call loop_QV_A(G2(:,:,:,258),wf(:,187),G2(:,:,:,265))
  call loop_Q_A(G2(:,:,:,265),Q(:,62),MT,G3(:,:,:,224))
  call loop_QS_A(G3(:,:,:,224),wf(:,0),G3(:,:,:,225),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,225),Q(:,63),MT,G4tensor(:,62))
  call loop_QV_A(G2(:,:,:,258),wf(:,37),G2(:,:,:,266))
  call loop_Q_A(G2(:,:,:,266),Q(:,46),MT,G3(:,:,:,226))
  call loop_QV_A(G3(:,:,:,226),wf(:,-4),G3(:,:,:,227))
  call loop_Q_A(G3(:,:,:,227),Q(:,62),MT,G4(:,:,:,127))
  call loop_QS_A(G4(:,:,:,127),wf(:,0),G4(:,:,:,128),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,128),Q(:,63),MT,G5tensor(:,39))
  call loop_QV_A(G2(:,:,:,258),wf(:,-4),G2(:,:,:,267))
  call loop_Q_A(G2(:,:,:,267),Q(:,28),MT,G3(:,:,:,228))
  call loop_QV_A(G3(:,:,:,228),wf(:,37),G3(:,:,:,229))
  call loop_Q_A(G3(:,:,:,229),Q(:,62),MT,G4(:,:,:,129))
  call loop_QS_A(G4(:,:,:,129),wf(:,0),G4(:,:,:,130),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,130),Q(:,63),MT,G5tensor(:,40))
  call loop_QV_A(G3(:,:,:,228),wf(:,-1),G3(:,:,:,230))
  call loop_Q_A(G3(:,:,:,230),Q(:,30),MT,G4(:,:,:,131))
  call loop_QV_A(G4(:,:,:,131),wf(:,-5),G4(:,:,:,132))
  call loop_Q_A(G4(:,:,:,132),Q(:,62),MT,G5(:,:,:,51))
  call loop_QS_A(G5(:,:,:,51),wf(:,0),G5(:,:,:,52),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,52),Q(:,63),MT,G6tensor(:,26))
  call loop_QV_A(G2(:,:,:,258),wf(:,188),G2(:,:,:,268))
  call loop_Q_A(G2(:,:,:,268),Q(:,62),MT,G3(:,:,:,231))
  call loop_QS_A(G3(:,:,:,231),wf(:,0),G3(:,:,:,232),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,232),Q(:,63),MT,G4tensor(:,63))
  call loop_QV_A(G2(:,:,:,258),wf(:,-1),G2(:,:,:,269))
  call loop_Q_A(G2(:,:,:,269),Q(:,14),MT,G3(:,:,:,233))
  call loop_QV_A(G3(:,:,:,233),wf(:,119),G3(:,:,:,234))
  call loop_Q_A(G3(:,:,:,234),Q(:,62),MT,G4(:,:,:,133))
  call loop_QS_A(G4(:,:,:,133),wf(:,0),G4(:,:,:,134),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,134),Q(:,63),MT,G5tensor(:,41))
  call loop_QV_A(G3(:,:,:,233),wf(:,-5),G3(:,:,:,235))
  call loop_Q_A(G3(:,:,:,235),Q(:,46),MT,G4(:,:,:,135))
  call loop_QV_A(G4(:,:,:,135),wf(:,-4),G4(:,:,:,136))
  call loop_Q_A(G4(:,:,:,136),Q(:,62),MT,G5(:,:,:,53))
  call loop_QS_A(G5(:,:,:,53),wf(:,0),G5(:,:,:,54),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,54),Q(:,63),MT,G6tensor(:,27))
  call loop_QV_A(G3(:,:,:,233),wf(:,-4),G3(:,:,:,236))
  call loop_Q_A(G3(:,:,:,236),Q(:,30),MT,G4(:,:,:,137))
  call loop_QV_A(G4(:,:,:,137),wf(:,-5),G4(:,:,:,138))
  call loop_Q_A(G4(:,:,:,138),Q(:,62),MT,G5(:,:,:,55))
  call loop_QS_A(G5(:,:,:,55),wf(:,0),G5(:,:,:,56),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,56),Q(:,63),MT,G6tensor(:,28))
  call loop_QV_A(G1(:,:,:,75),wf(:,319),G1(:,:,:,102))
  call loop_Q_A(G1(:,:,:,102),Q(:,62),MT,G2(:,:,:,270))
  call loop_QS_A(G2(:,:,:,270),wf(:,0),G2(:,:,:,271),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,271),Q(:,63),MT,G3tensor(:,67))
  call loop_QV_A(G1(:,:,:,75),wf(:,320),G1(:,:,:,103))
  call loop_Q_A(G1(:,:,:,103),Q(:,62),MT,G2(:,:,:,272))
  call loop_QS_A(G2(:,:,:,272),wf(:,0),G2(:,:,:,273),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,273),Q(:,63),MT,G3tensor(:,68))
  call loop_QV_A(G1(:,:,:,75),wf(:,321),G1(:,:,:,104))
  call loop_Q_A(G1(:,:,:,104),Q(:,62),MT,G2(:,:,:,274))
  call loop_QS_A(G2(:,:,:,274),wf(:,0),G2(:,:,:,275),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,275),Q(:,63),MT,G3tensor(:,69))
  call loop_QV_A(G1(:,:,:,75),wf(:,325),G1(:,:,:,105))
  call loop_Q_A(G1(:,:,:,105),Q(:,62),MT,G2(:,:,:,276))
  call loop_QS_A(G2(:,:,:,276),wf(:,0),G2(:,:,:,277),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,277),Q(:,63),MT,G3tensor(:,70))
  call loop_QV_A(G1(:,:,:,75),wf(:,326),G1(:,:,:,106))
  call loop_Q_A(G1(:,:,:,106),Q(:,62),MT,G2(:,:,:,278))
  call loop_QS_A(G2(:,:,:,278),wf(:,0),G2(:,:,:,279),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,279),Q(:,63),MT,G3tensor(:,71))
  call loop_QV_A(G1(:,:,:,75),wf(:,327),G1(:,:,:,107))
  call loop_Q_A(G1(:,:,:,107),Q(:,62),MT,G2(:,:,:,280))
  call loop_QS_A(G2(:,:,:,280),wf(:,0),G2(:,:,:,281),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,281),Q(:,63),MT,G3tensor(:,72))
  call loop_QV_A(G1(:,:,:,75),wf(:,77),G1(:,:,:,108))
  call loop_Q_A(G1(:,:,:,108),Q(:,46),MT,G2(:,:,:,282))
  call loop_QV_A(G2(:,:,:,282),wf(:,-4),G2(:,:,:,283))
  call loop_Q_A(G2(:,:,:,283),Q(:,62),MT,G3(:,:,:,237))
  call loop_QS_A(G3(:,:,:,237),wf(:,0),G3(:,:,:,238),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,238),Q(:,63),MT,G4tensor(:,64))
  call loop_QV_A(G1(:,:,:,75),wf(:,79),G1(:,:,:,109))
  call loop_Q_A(G1(:,:,:,109),Q(:,46),MT,G2(:,:,:,284))
  call loop_QV_A(G2(:,:,:,284),wf(:,-4),G2(:,:,:,285))
  call loop_Q_A(G2(:,:,:,285),Q(:,62),MT,G3(:,:,:,239))
  call loop_QS_A(G3(:,:,:,239),wf(:,0),G3(:,:,:,240),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,240),Q(:,63),MT,G4tensor(:,65))
  call loop_QV_A(G1(:,:,:,75),wf(:,80),G1(:,:,:,110))
  call loop_Q_A(G1(:,:,:,110),Q(:,46),MT,G2(:,:,:,286))
  call loop_QV_A(G2(:,:,:,286),wf(:,-4),G2(:,:,:,287))
  call loop_Q_A(G2(:,:,:,287),Q(:,62),MT,G3(:,:,:,241))
  call loop_QS_A(G3(:,:,:,241),wf(:,0),G3(:,:,:,242),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,242),Q(:,63),MT,G4tensor(:,66))
  call loop_QV_A(G1(:,:,:,75),wf(:,-4),G1(:,:,:,111))
  call loop_Q_A(G1(:,:,:,111),Q(:,20),MT,G2(:,:,:,288))
  call loop_QV_A(G2(:,:,:,288),wf(:,77),G2(:,:,:,289))
  call loop_Q_A(G2(:,:,:,289),Q(:,62),MT,G3(:,:,:,243))
  call loop_QS_A(G3(:,:,:,243),wf(:,0),G3(:,:,:,244),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,244),Q(:,63),MT,G4tensor(:,67))
  call loop_QV_A(G2(:,:,:,288),wf(:,79),G2(:,:,:,290))
  call loop_Q_A(G2(:,:,:,290),Q(:,62),MT,G3(:,:,:,245))
  call loop_QS_A(G3(:,:,:,245),wf(:,0),G3(:,:,:,246),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,246),Q(:,63),MT,G4tensor(:,68))
  call loop_QV_A(G2(:,:,:,288),wf(:,80),G2(:,:,:,291))
  call loop_Q_A(G2(:,:,:,291),Q(:,62),MT,G3(:,:,:,247))
  call loop_QS_A(G3(:,:,:,247),wf(:,0),G3(:,:,:,248),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,248),Q(:,63),MT,G4tensor(:,69))
  call loop_QV_A(G2(:,:,:,288),wf(:,176),G2(:,:,:,292))
  call loop_Q_A(G2(:,:,:,292),Q(:,62),MT,G3(:,:,:,249))
  call loop_QS_A(G3(:,:,:,249),wf(:,0),G3(:,:,:,250),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,250),Q(:,63),MT,G4tensor(:,70))
  call loop_QV_A(G2(:,:,:,288),wf(:,18),G2(:,:,:,293))
  call loop_Q_A(G2(:,:,:,293),Q(:,30),MT,G3(:,:,:,251))
  call loop_QV_A(G3(:,:,:,251),wf(:,-5),G3(:,:,:,252))
  call loop_Q_A(G3(:,:,:,252),Q(:,62),MT,G4(:,:,:,139))
  call loop_QS_A(G4(:,:,:,139),wf(:,0),G4(:,:,:,140),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,140),Q(:,63),MT,G5tensor(:,42))
  call loop_QV_A(G2(:,:,:,288),wf(:,-5),G2(:,:,:,294))
  call loop_Q_A(G2(:,:,:,294),Q(:,52),MT,G3(:,:,:,253))
  call loop_QV_A(G3(:,:,:,253),wf(:,18),G3(:,:,:,254))
  call loop_Q_A(G3(:,:,:,254),Q(:,62),MT,G4(:,:,:,141))
  call loop_QS_A(G4(:,:,:,141),wf(:,0),G4(:,:,:,142),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,142),Q(:,63),MT,G5tensor(:,43))
  call loop_QV_A(G3(:,:,:,253),wf(:,-1),G3(:,:,:,255))
  call loop_Q_A(G3(:,:,:,255),Q(:,54),MT,G4(:,:,:,143))
  call loop_QV_A(G4(:,:,:,143),wf(:,-3),G4(:,:,:,144))
  call loop_Q_A(G4(:,:,:,144),Q(:,62),MT,G5(:,:,:,57))
  call loop_QS_A(G5(:,:,:,57),wf(:,0),G5(:,:,:,58),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,58),Q(:,63),MT,G6tensor(:,29))
  call loop_QV_A(G2(:,:,:,288),wf(:,196),G2(:,:,:,295))
  call loop_Q_A(G2(:,:,:,295),Q(:,62),MT,G3(:,:,:,256))
  call loop_QS_A(G3(:,:,:,256),wf(:,0),G3(:,:,:,257),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,257),Q(:,63),MT,G4tensor(:,71))
  call loop_QV_A(G2(:,:,:,288),wf(:,37),G2(:,:,:,296))
  call loop_Q_A(G2(:,:,:,296),Q(:,54),MT,G3(:,:,:,258))
  call loop_QV_A(G3(:,:,:,258),wf(:,-3),G3(:,:,:,259))
  call loop_Q_A(G3(:,:,:,259),Q(:,62),MT,G4(:,:,:,145))
  call loop_QS_A(G4(:,:,:,145),wf(:,0),G4(:,:,:,146),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,146),Q(:,63),MT,G5tensor(:,44))
  call loop_QV_A(G2(:,:,:,288),wf(:,-3),G2(:,:,:,297))
  call loop_Q_A(G2(:,:,:,297),Q(:,28),MT,G3(:,:,:,260))
  call loop_QV_A(G3(:,:,:,260),wf(:,37),G3(:,:,:,261))
  call loop_Q_A(G3(:,:,:,261),Q(:,62),MT,G4(:,:,:,147))
  call loop_QS_A(G4(:,:,:,147),wf(:,0),G4(:,:,:,148),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,148),Q(:,63),MT,G5tensor(:,45))
  call loop_QV_A(G3(:,:,:,260),wf(:,-1),G3(:,:,:,262))
  call loop_Q_A(G3(:,:,:,262),Q(:,30),MT,G4(:,:,:,149))
  call loop_QV_A(G4(:,:,:,149),wf(:,-5),G4(:,:,:,150))
  call loop_Q_A(G4(:,:,:,150),Q(:,62),MT,G5(:,:,:,59))
  call loop_QS_A(G5(:,:,:,59),wf(:,0),G5(:,:,:,60),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,60),Q(:,63),MT,G6tensor(:,30))
  call loop_QV_A(G2(:,:,:,288),wf(:,197),G2(:,:,:,298))
  call loop_Q_A(G2(:,:,:,298),Q(:,62),MT,G3(:,:,:,263))
  call loop_QS_A(G3(:,:,:,263),wf(:,0),G3(:,:,:,264),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,264),Q(:,63),MT,G4tensor(:,72))
  call loop_QV_A(G2(:,:,:,288),wf(:,-1),G2(:,:,:,299))
  call loop_Q_A(G2(:,:,:,299),Q(:,22),MT,G3(:,:,:,265))
  call loop_QV_A(G3(:,:,:,265),wf(:,109),G3(:,:,:,266))
  call loop_Q_A(G3(:,:,:,266),Q(:,62),MT,G4(:,:,:,151))
  call loop_QS_A(G4(:,:,:,151),wf(:,0),G4(:,:,:,152),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,152),Q(:,63),MT,G5tensor(:,46))
  call loop_QV_A(G3(:,:,:,265),wf(:,-5),G3(:,:,:,267))
  call loop_Q_A(G3(:,:,:,267),Q(:,54),MT,G4(:,:,:,153))
  call loop_QV_A(G4(:,:,:,153),wf(:,-3),G4(:,:,:,154))
  call loop_Q_A(G4(:,:,:,154),Q(:,62),MT,G5(:,:,:,61))
  call loop_QS_A(G5(:,:,:,61),wf(:,0),G5(:,:,:,62),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,62),Q(:,63),MT,G6tensor(:,31))
  call loop_QV_A(G3(:,:,:,265),wf(:,-3),G3(:,:,:,268))
  call loop_Q_A(G3(:,:,:,268),Q(:,30),MT,G4(:,:,:,155))
  call loop_QV_A(G4(:,:,:,155),wf(:,-5),G4(:,:,:,156))
  call loop_Q_A(G4(:,:,:,156),Q(:,62),MT,G5(:,:,:,63))
  call loop_QS_A(G5(:,:,:,63),wf(:,0),G5(:,:,:,64),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,64),Q(:,63),MT,G6tensor(:,32))
  call loop_QV_A(G1(:,:,:,75),wf(:,331),G1(:,:,:,112))
  call loop_Q_A(G1(:,:,:,112),Q(:,62),MT,G2(:,:,:,300))
  call loop_QS_A(G2(:,:,:,300),wf(:,0),G2(:,:,:,301),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,301),Q(:,63),MT,G3tensor(:,73))
  call loop_QV_A(G1(:,:,:,75),wf(:,332),G1(:,:,:,113))
  call loop_Q_A(G1(:,:,:,113),Q(:,62),MT,G2(:,:,:,302))
  call loop_QS_A(G2(:,:,:,302),wf(:,0),G2(:,:,:,303),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,303),Q(:,63),MT,G3tensor(:,74))
  call loop_QV_A(G1(:,:,:,75),wf(:,333),G1(:,:,:,114))
  call loop_Q_A(G1(:,:,:,114),Q(:,62),MT,G2(:,:,:,304))
  call loop_QS_A(G2(:,:,:,304),wf(:,0),G2(:,:,:,305),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,305),Q(:,63),MT,G3tensor(:,75))
  call loop_QV_A(G1(:,:,:,75),wf(:,85),G1(:,:,:,115))
  call loop_Q_A(G1(:,:,:,115),Q(:,30),MT,G2(:,:,:,306))
  call loop_QV_A(G2(:,:,:,306),wf(:,-5),G2(:,:,:,307))
  call loop_Q_A(G2(:,:,:,307),Q(:,62),MT,G3(:,:,:,269))
  call loop_QS_A(G3(:,:,:,269),wf(:,0),G3(:,:,:,270),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,270),Q(:,63),MT,G4tensor(:,73))
  call loop_QV_A(G1(:,:,:,75),wf(:,87),G1(:,:,:,116))
  call loop_Q_A(G1(:,:,:,116),Q(:,30),MT,G2(:,:,:,308))
  call loop_QV_A(G2(:,:,:,308),wf(:,-5),G2(:,:,:,309))
  call loop_Q_A(G2(:,:,:,309),Q(:,62),MT,G3(:,:,:,271))
  call loop_QS_A(G3(:,:,:,271),wf(:,0),G3(:,:,:,272),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,272),Q(:,63),MT,G4tensor(:,74))
  call loop_QV_A(G1(:,:,:,75),wf(:,88),G1(:,:,:,117))
  call loop_Q_A(G1(:,:,:,117),Q(:,30),MT,G2(:,:,:,310))
  call loop_QV_A(G2(:,:,:,310),wf(:,-5),G2(:,:,:,311))
  call loop_Q_A(G2(:,:,:,311),Q(:,62),MT,G3(:,:,:,273))
  call loop_QS_A(G3(:,:,:,273),wf(:,0),G3(:,:,:,274),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,274),Q(:,63),MT,G4tensor(:,75))
  call loop_QV_A(G1(:,:,:,75),wf(:,-5),G1(:,:,:,118))
  call loop_Q_A(G1(:,:,:,118),Q(:,36),MT,G2(:,:,:,312))
  call loop_QV_A(G2(:,:,:,312),wf(:,85),G2(:,:,:,313))
  call loop_Q_A(G2(:,:,:,313),Q(:,62),MT,G3(:,:,:,275))
  call loop_QS_A(G3(:,:,:,275),wf(:,0),G3(:,:,:,276),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,276),Q(:,63),MT,G4tensor(:,76))
  call loop_QV_A(G2(:,:,:,312),wf(:,87),G2(:,:,:,314))
  call loop_Q_A(G2(:,:,:,314),Q(:,62),MT,G3(:,:,:,277))
  call loop_QS_A(G3(:,:,:,277),wf(:,0),G3(:,:,:,278),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,278),Q(:,63),MT,G4tensor(:,77))
  call loop_QV_A(G2(:,:,:,312),wf(:,88),G2(:,:,:,315))
  call loop_Q_A(G2(:,:,:,315),Q(:,62),MT,G3(:,:,:,279))
  call loop_QS_A(G3(:,:,:,279),wf(:,0),G3(:,:,:,280),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,280),Q(:,63),MT,G4tensor(:,78))
  call loop_QV_A(G2(:,:,:,312),wf(:,179),G2(:,:,:,316))
  call loop_Q_A(G2(:,:,:,316),Q(:,62),MT,G3(:,:,:,281))
  call loop_QS_A(G3(:,:,:,281),wf(:,0),G3(:,:,:,282),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,282),Q(:,63),MT,G4tensor(:,79))
  call loop_QV_A(G2(:,:,:,312),wf(:,18),G2(:,:,:,317))
  call loop_Q_A(G2(:,:,:,317),Q(:,46),MT,G3(:,:,:,283))
  call loop_QV_A(G3(:,:,:,283),wf(:,-4),G3(:,:,:,284))
  call loop_Q_A(G3(:,:,:,284),Q(:,62),MT,G4(:,:,:,157))
  call loop_QS_A(G4(:,:,:,157),wf(:,0),G4(:,:,:,158),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,158),Q(:,63),MT,G5tensor(:,47))
  call loop_QV_A(G2(:,:,:,312),wf(:,-4),G2(:,:,:,318))
  call loop_Q_A(G2(:,:,:,318),Q(:,52),MT,G3(:,:,:,285))
  call loop_QV_A(G3(:,:,:,285),wf(:,18),G3(:,:,:,286))
  call loop_Q_A(G3(:,:,:,286),Q(:,62),MT,G4(:,:,:,159))
  call loop_QS_A(G4(:,:,:,159),wf(:,0),G4(:,:,:,160),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,160),Q(:,63),MT,G5tensor(:,48))
  call loop_QV_A(G3(:,:,:,285),wf(:,-1),G3(:,:,:,287))
  call loop_Q_A(G3(:,:,:,287),Q(:,54),MT,G4(:,:,:,161))
  call loop_QV_A(G4(:,:,:,161),wf(:,-3),G4(:,:,:,162))
  call loop_Q_A(G4(:,:,:,162),Q(:,62),MT,G5(:,:,:,65))
  call loop_QS_A(G5(:,:,:,65),wf(:,0),G5(:,:,:,66),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,66),Q(:,63),MT,G6tensor(:,33))
  call loop_QV_A(G2(:,:,:,312),wf(:,192),G2(:,:,:,319))
  call loop_Q_A(G2(:,:,:,319),Q(:,62),MT,G3(:,:,:,288))
  call loop_QS_A(G3(:,:,:,288),wf(:,0),G3(:,:,:,289),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,289),Q(:,63),MT,G4tensor(:,80))
  call loop_QV_A(G2(:,:,:,312),wf(:,29),G2(:,:,:,320))
  call loop_Q_A(G2(:,:,:,320),Q(:,54),MT,G3(:,:,:,290))
  call loop_QV_A(G3(:,:,:,290),wf(:,-3),G3(:,:,:,291))
  call loop_Q_A(G3(:,:,:,291),Q(:,62),MT,G4(:,:,:,163))
  call loop_QS_A(G4(:,:,:,163),wf(:,0),G4(:,:,:,164),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,164),Q(:,63),MT,G5tensor(:,49))
  call loop_QV_A(G2(:,:,:,312),wf(:,-3),G2(:,:,:,321))
  call loop_Q_A(G2(:,:,:,321),Q(:,44),MT,G3(:,:,:,292))
  call loop_QV_A(G3(:,:,:,292),wf(:,29),G3(:,:,:,293))
  call loop_Q_A(G3(:,:,:,293),Q(:,62),MT,G4(:,:,:,165))
  call loop_QS_A(G4(:,:,:,165),wf(:,0),G4(:,:,:,166),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,166),Q(:,63),MT,G5tensor(:,50))
  call loop_QV_A(G3(:,:,:,292),wf(:,-1),G3(:,:,:,294))
  call loop_Q_A(G3(:,:,:,294),Q(:,46),MT,G4(:,:,:,167))
  call loop_QV_A(G4(:,:,:,167),wf(:,-4),G4(:,:,:,168))
  call loop_Q_A(G4(:,:,:,168),Q(:,62),MT,G5(:,:,:,67))
  call loop_QS_A(G5(:,:,:,67),wf(:,0),G5(:,:,:,68),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,68),Q(:,63),MT,G6tensor(:,34))
  call loop_QV_A(G2(:,:,:,312),wf(:,201),G2(:,:,:,322))
  call loop_Q_A(G2(:,:,:,322),Q(:,62),MT,G3(:,:,:,295))
  call loop_QS_A(G3(:,:,:,295),wf(:,0),G3(:,:,:,296),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,296),Q(:,63),MT,G4tensor(:,81))
  call loop_QV_A(G2(:,:,:,312),wf(:,-1),G2(:,:,:,323))
  call loop_Q_A(G2(:,:,:,323),Q(:,38),MT,G3(:,:,:,297))
  call loop_QV_A(G3(:,:,:,297),wf(:,101),G3(:,:,:,298))
  call loop_Q_A(G3(:,:,:,298),Q(:,62),MT,G4(:,:,:,169))
  call loop_QS_A(G4(:,:,:,169),wf(:,0),G4(:,:,:,170),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,170),Q(:,63),MT,G5tensor(:,51))
  call loop_QV_A(G3(:,:,:,297),wf(:,-4),G3(:,:,:,299))
  call loop_Q_A(G3(:,:,:,299),Q(:,54),MT,G4(:,:,:,171))
  call loop_QV_A(G4(:,:,:,171),wf(:,-3),G4(:,:,:,172))
  call loop_Q_A(G4(:,:,:,172),Q(:,62),MT,G5(:,:,:,69))
  call loop_QS_A(G5(:,:,:,69),wf(:,0),G5(:,:,:,70),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,70),Q(:,63),MT,G6tensor(:,35))
  call loop_QV_A(G3(:,:,:,297),wf(:,-3),G3(:,:,:,300))
  call loop_Q_A(G3(:,:,:,300),Q(:,46),MT,G4(:,:,:,173))
  call loop_QV_A(G4(:,:,:,173),wf(:,-4),G4(:,:,:,174))
  call loop_Q_A(G4(:,:,:,174),Q(:,62),MT,G5(:,:,:,71))
  call loop_QS_A(G5(:,:,:,71),wf(:,0),G5(:,:,:,72),gH)
  call check_last_Q_A(l_switch,G5(:,:,:,72),Q(:,63),MT,G6tensor(:,36))
  call loop_QV_A(G1(:,:,:,75),wf(:,372),G1(:,:,:,119))
  call loop_Q_A(G1(:,:,:,119),Q(:,62),MT,G2(:,:,:,324))
  call loop_QS_A(G2(:,:,:,324),wf(:,0),G2(:,:,:,325),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,325),Q(:,63),MT,G3tensor(:,76))
  call loop_QV_A(G1(:,:,:,75),wf(:,119),G1(:,:,:,120))
  call loop_Q_A(G1(:,:,:,120),Q(:,52),MT,G2(:,:,:,326))
  call loop_QV_A(G2(:,:,:,326),wf(:,18),G2(:,:,:,327))
  call loop_Q_A(G2(:,:,:,327),Q(:,62),MT,G3(:,:,:,301))
  call loop_QS_A(G3(:,:,:,301),wf(:,0),G3(:,:,:,302),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,302),Q(:,63),MT,G4tensor(:,82))
  call loop_QV_A(G2(:,:,:,326),wf(:,-1),G2(:,:,:,328))
  call loop_Q_A(G2(:,:,:,328),Q(:,54),MT,G3(:,:,:,303))
  call loop_QV_A(G3(:,:,:,303),wf(:,-3),G3(:,:,:,304))
  call loop_Q_A(G3(:,:,:,304),Q(:,62),MT,G4(:,:,:,175))
  call loop_QS_A(G4(:,:,:,175),wf(:,0),G4(:,:,:,176),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,176),Q(:,63),MT,G5tensor(:,52))
  call loop_QV_A(G1(:,:,:,75),wf(:,18),G1(:,:,:,121))
  call loop_Q_A(G1(:,:,:,121),Q(:,14),MT,G2(:,:,:,329))
  call loop_QV_A(G2(:,:,:,329),wf(:,119),G2(:,:,:,330))
  call loop_Q_A(G2(:,:,:,330),Q(:,62),MT,G3(:,:,:,305))
  call loop_QS_A(G3(:,:,:,305),wf(:,0),G3(:,:,:,306),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,306),Q(:,63),MT,G4tensor(:,83))
  call loop_QV_A(G2(:,:,:,329),wf(:,-5),G2(:,:,:,331))
  call loop_Q_A(G2(:,:,:,331),Q(:,46),MT,G3(:,:,:,307))
  call loop_QV_A(G3(:,:,:,307),wf(:,-4),G3(:,:,:,308))
  call loop_Q_A(G3(:,:,:,308),Q(:,62),MT,G4(:,:,:,177))
  call loop_QS_A(G4(:,:,:,177),wf(:,0),G4(:,:,:,178),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,178),Q(:,63),MT,G5tensor(:,53))
  call loop_QV_A(G2(:,:,:,329),wf(:,-4),G2(:,:,:,332))
  call loop_Q_A(G2(:,:,:,332),Q(:,30),MT,G3(:,:,:,309))
  call loop_QV_A(G3(:,:,:,309),wf(:,-5),G3(:,:,:,310))
  call loop_Q_A(G3(:,:,:,310),Q(:,62),MT,G4(:,:,:,179))
  call loop_QS_A(G4(:,:,:,179),wf(:,0),G4(:,:,:,180),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,180),Q(:,63),MT,G5tensor(:,54))
  call loop_QV_A(G1(:,:,:,75),wf(:,376),G1(:,:,:,122))
  call loop_Q_A(G1(:,:,:,122),Q(:,62),MT,G2(:,:,:,333))
  call loop_QS_A(G2(:,:,:,333),wf(:,0),G2(:,:,:,334),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,334),Q(:,63),MT,G3tensor(:,77))
  call loop_QV_A(G1(:,:,:,75),wf(:,179),G1(:,:,:,123))
  call loop_Q_A(G1(:,:,:,123),Q(:,30),MT,G2(:,:,:,335))
  call loop_QV_A(G2(:,:,:,335),wf(:,-5),G2(:,:,:,336))
  call loop_Q_A(G2(:,:,:,336),Q(:,62),MT,G3(:,:,:,311))
  call loop_QS_A(G3(:,:,:,311),wf(:,0),G3(:,:,:,312),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,312),Q(:,63),MT,G4tensor(:,84))
  call loop_QV_A(G1(:,:,:,75),wf(:,378),G1(:,:,:,124))
  call loop_Q_A(G1(:,:,:,124),Q(:,62),MT,G2(:,:,:,337))
  call loop_QS_A(G2(:,:,:,337),wf(:,0),G2(:,:,:,338),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,338),Q(:,63),MT,G3tensor(:,78))
  call loop_QV_A(G1(:,:,:,75),wf(:,176),G1(:,:,:,125))
  call loop_Q_A(G1(:,:,:,125),Q(:,46),MT,G2(:,:,:,339))
  call loop_QV_A(G2(:,:,:,339),wf(:,-4),G2(:,:,:,340))
  call loop_Q_A(G2(:,:,:,340),Q(:,62),MT,G3(:,:,:,313))
  call loop_QS_A(G3(:,:,:,313),wf(:,0),G3(:,:,:,314),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,314),Q(:,63),MT,G4tensor(:,85))
  call loop_QV_A(G1(:,:,:,75),wf(:,389),G1(:,:,:,126))
  call loop_Q_A(G1(:,:,:,126),Q(:,62),MT,G2(:,:,:,341))
  call loop_QS_A(G2(:,:,:,341),wf(:,0),G2(:,:,:,342),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,342),Q(:,63),MT,G3tensor(:,79))
  call loop_QV_A(G1(:,:,:,75),wf(:,109),G1(:,:,:,127))
  call loop_Q_A(G1(:,:,:,127),Q(:,44),MT,G2(:,:,:,343))
  call loop_QV_A(G2(:,:,:,343),wf(:,29),G2(:,:,:,344))
  call loop_Q_A(G2(:,:,:,344),Q(:,62),MT,G3(:,:,:,315))
  call loop_QS_A(G3(:,:,:,315),wf(:,0),G3(:,:,:,316),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,316),Q(:,63),MT,G4tensor(:,86))
  call loop_QV_A(G2(:,:,:,343),wf(:,-1),G2(:,:,:,345))
  call loop_Q_A(G2(:,:,:,345),Q(:,46),MT,G3(:,:,:,317))
  call loop_QV_A(G3(:,:,:,317),wf(:,-4),G3(:,:,:,318))
  call loop_Q_A(G3(:,:,:,318),Q(:,62),MT,G4(:,:,:,181))
  call loop_QS_A(G4(:,:,:,181),wf(:,0),G4(:,:,:,182),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,182),Q(:,63),MT,G5tensor(:,55))
  call loop_QV_A(G1(:,:,:,75),wf(:,29),G1(:,:,:,128))
  call loop_Q_A(G1(:,:,:,128),Q(:,22),MT,G2(:,:,:,346))
  call loop_QV_A(G2(:,:,:,346),wf(:,109),G2(:,:,:,347))
  call loop_Q_A(G2(:,:,:,347),Q(:,62),MT,G3(:,:,:,319))
  call loop_QS_A(G3(:,:,:,319),wf(:,0),G3(:,:,:,320),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,320),Q(:,63),MT,G4tensor(:,87))
  call loop_QV_A(G2(:,:,:,346),wf(:,-5),G2(:,:,:,348))
  call loop_Q_A(G2(:,:,:,348),Q(:,54),MT,G3(:,:,:,321))
  call loop_QV_A(G3(:,:,:,321),wf(:,-3),G3(:,:,:,322))
  call loop_Q_A(G3(:,:,:,322),Q(:,62),MT,G4(:,:,:,183))
  call loop_QS_A(G4(:,:,:,183),wf(:,0),G4(:,:,:,184),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,184),Q(:,63),MT,G5tensor(:,56))
  call loop_QV_A(G2(:,:,:,346),wf(:,-3),G2(:,:,:,349))
  call loop_Q_A(G2(:,:,:,349),Q(:,30),MT,G3(:,:,:,323))
  call loop_QV_A(G3(:,:,:,323),wf(:,-5),G3(:,:,:,324))
  call loop_Q_A(G3(:,:,:,324),Q(:,62),MT,G4(:,:,:,185))
  call loop_QS_A(G4(:,:,:,185),wf(:,0),G4(:,:,:,186),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,186),Q(:,63),MT,G5tensor(:,57))
  call loop_QV_A(G1(:,:,:,75),wf(:,393),G1(:,:,:,129))
  call loop_Q_A(G1(:,:,:,129),Q(:,62),MT,G2(:,:,:,350))
  call loop_QS_A(G2(:,:,:,350),wf(:,0),G2(:,:,:,351),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,351),Q(:,63),MT,G3tensor(:,80))
  call loop_QV_A(G1(:,:,:,75),wf(:,192),G1(:,:,:,130))
  call loop_Q_A(G1(:,:,:,130),Q(:,30),MT,G2(:,:,:,352))
  call loop_QV_A(G2(:,:,:,352),wf(:,-5),G2(:,:,:,353))
  call loop_Q_A(G2(:,:,:,353),Q(:,62),MT,G3(:,:,:,325))
  call loop_QS_A(G3(:,:,:,325),wf(:,0),G3(:,:,:,326),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,326),Q(:,63),MT,G4tensor(:,88))
  call loop_QV_A(G1(:,:,:,75),wf(:,395),G1(:,:,:,131))
  call loop_Q_A(G1(:,:,:,131),Q(:,62),MT,G2(:,:,:,354))
  call loop_QS_A(G2(:,:,:,354),wf(:,0),G2(:,:,:,355),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,355),Q(:,63),MT,G3tensor(:,81))
  call loop_QV_A(G1(:,:,:,75),wf(:,184),G1(:,:,:,132))
  call loop_Q_A(G1(:,:,:,132),Q(:,54),MT,G2(:,:,:,356))
  call loop_QV_A(G2(:,:,:,356),wf(:,-3),G2(:,:,:,357))
  call loop_Q_A(G2(:,:,:,357),Q(:,62),MT,G3(:,:,:,327))
  call loop_QS_A(G3(:,:,:,327),wf(:,0),G3(:,:,:,328),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,328),Q(:,63),MT,G4tensor(:,89))
  call loop_QV_A(G1(:,:,:,75),wf(:,404),G1(:,:,:,133))
  call loop_Q_A(G1(:,:,:,133),Q(:,62),MT,G2(:,:,:,358))
  call loop_QS_A(G2(:,:,:,358),wf(:,0),G2(:,:,:,359),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,359),Q(:,63),MT,G3tensor(:,82))
  call loop_QV_A(G1(:,:,:,75),wf(:,101),G1(:,:,:,134))
  call loop_Q_A(G1(:,:,:,134),Q(:,28),MT,G2(:,:,:,360))
  call loop_QV_A(G2(:,:,:,360),wf(:,37),G2(:,:,:,361))
  call loop_Q_A(G2(:,:,:,361),Q(:,62),MT,G3(:,:,:,329))
  call loop_QS_A(G3(:,:,:,329),wf(:,0),G3(:,:,:,330),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,330),Q(:,63),MT,G4tensor(:,90))
  call loop_QV_A(G2(:,:,:,360),wf(:,-1),G2(:,:,:,362))
  call loop_Q_A(G2(:,:,:,362),Q(:,30),MT,G3(:,:,:,331))
  call loop_QV_A(G3(:,:,:,331),wf(:,-5),G3(:,:,:,332))
  call loop_Q_A(G3(:,:,:,332),Q(:,62),MT,G4(:,:,:,187))
  call loop_QS_A(G4(:,:,:,187),wf(:,0),G4(:,:,:,188),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,188),Q(:,63),MT,G5tensor(:,58))
  call loop_QV_A(G1(:,:,:,75),wf(:,37),G1(:,:,:,135))
  call loop_Q_A(G1(:,:,:,135),Q(:,38),MT,G2(:,:,:,363))
  call loop_QV_A(G2(:,:,:,363),wf(:,101),G2(:,:,:,364))
  call loop_Q_A(G2(:,:,:,364),Q(:,62),MT,G3(:,:,:,333))
  call loop_QS_A(G3(:,:,:,333),wf(:,0),G3(:,:,:,334),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,334),Q(:,63),MT,G4tensor(:,91))
  call loop_QV_A(G2(:,:,:,363),wf(:,-4),G2(:,:,:,365))
  call loop_Q_A(G2(:,:,:,365),Q(:,54),MT,G3(:,:,:,335))
  call loop_QV_A(G3(:,:,:,335),wf(:,-3),G3(:,:,:,336))
  call loop_Q_A(G3(:,:,:,336),Q(:,62),MT,G4(:,:,:,189))
  call loop_QS_A(G4(:,:,:,189),wf(:,0),G4(:,:,:,190),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,190),Q(:,63),MT,G5tensor(:,59))
  call loop_QV_A(G2(:,:,:,363),wf(:,-3),G2(:,:,:,366))
  call loop_Q_A(G2(:,:,:,366),Q(:,46),MT,G3(:,:,:,337))
  call loop_QV_A(G3(:,:,:,337),wf(:,-4),G3(:,:,:,338))
  call loop_Q_A(G3(:,:,:,338),Q(:,62),MT,G4(:,:,:,191))
  call loop_QS_A(G4(:,:,:,191),wf(:,0),G4(:,:,:,192),gH)
  call check_last_Q_A(l_switch,G4(:,:,:,192),Q(:,63),MT,G5tensor(:,60))
  call loop_QV_A(G1(:,:,:,75),wf(:,408),G1(:,:,:,136))
  call loop_Q_A(G1(:,:,:,136),Q(:,62),MT,G2(:,:,:,367))
  call loop_QS_A(G2(:,:,:,367),wf(:,0),G2(:,:,:,368),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,368),Q(:,63),MT,G3tensor(:,83))
  call loop_QV_A(G1(:,:,:,75),wf(:,201),G1(:,:,:,137))
  call loop_Q_A(G1(:,:,:,137),Q(:,30),MT,G2(:,:,:,369))
  call loop_QV_A(G2(:,:,:,369),wf(:,-5),G2(:,:,:,370))
  call loop_Q_A(G2(:,:,:,370),Q(:,62),MT,G3(:,:,:,339))
  call loop_QS_A(G3(:,:,:,339),wf(:,0),G3(:,:,:,340),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,340),Q(:,63),MT,G4tensor(:,92))
  call loop_QV_A(G1(:,:,:,75),wf(:,409),G1(:,:,:,138))
  call loop_Q_A(G1(:,:,:,138),Q(:,62),MT,G2(:,:,:,371))
  call loop_QS_A(G2(:,:,:,371),wf(:,0),G2(:,:,:,372),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,372),Q(:,63),MT,G3tensor(:,84))
  call loop_QV_A(G1(:,:,:,75),wf(:,415),G1(:,:,:,139))
  call loop_Q_A(G1(:,:,:,139),Q(:,62),MT,G2(:,:,:,373))
  call loop_QS_A(G2(:,:,:,373),wf(:,0),G2(:,:,:,374),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,374),Q(:,63),MT,G3tensor(:,85))
  call loop_QV_A(G1(:,:,:,75),wf(:,196),G1(:,:,:,140))
  call loop_Q_A(G1(:,:,:,140),Q(:,46),MT,G2(:,:,:,375))
  call loop_QV_A(G2(:,:,:,375),wf(:,-4),G2(:,:,:,376))
  call loop_Q_A(G2(:,:,:,376),Q(:,62),MT,G3(:,:,:,341))
  call loop_QS_A(G3(:,:,:,341),wf(:,0),G3(:,:,:,342),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,342),Q(:,63),MT,G4tensor(:,93))
  call loop_QV_A(G1(:,:,:,75),wf(:,417),G1(:,:,:,141))
  call loop_Q_A(G1(:,:,:,141),Q(:,62),MT,G2(:,:,:,377))
  call loop_QS_A(G2(:,:,:,377),wf(:,0),G2(:,:,:,378),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,378),Q(:,63),MT,G3tensor(:,86))
  call loop_QV_A(G1(:,:,:,75),wf(:,187),G1(:,:,:,142))
  call loop_Q_A(G1(:,:,:,142),Q(:,54),MT,G2(:,:,:,379))
  call loop_QV_A(G2(:,:,:,379),wf(:,-3),G2(:,:,:,380))
  call loop_Q_A(G2(:,:,:,380),Q(:,62),MT,G3(:,:,:,343))
  call loop_QS_A(G3(:,:,:,343),wf(:,0),G3(:,:,:,344),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,344),Q(:,63),MT,G4tensor(:,94))
  call loop_QV_A(G1(:,:,:,75),wf(:,426),G1(:,:,:,143))
  call loop_Q_A(G1(:,:,:,143),Q(:,62),MT,G2(:,:,:,381))
  call loop_QS_A(G2(:,:,:,381),wf(:,0),G2(:,:,:,382),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,382),Q(:,63),MT,G3tensor(:,87))
  call loop_QV_A(G1(:,:,:,75),wf(:,197),G1(:,:,:,144))
  call loop_Q_A(G1(:,:,:,144),Q(:,46),MT,G2(:,:,:,383))
  call loop_QV_A(G2(:,:,:,383),wf(:,-4),G2(:,:,:,384))
  call loop_Q_A(G2(:,:,:,384),Q(:,62),MT,G3(:,:,:,345))
  call loop_QS_A(G3(:,:,:,345),wf(:,0),G3(:,:,:,346),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,346),Q(:,63),MT,G4tensor(:,95))
  call loop_QV_A(G1(:,:,:,75),wf(:,427),G1(:,:,:,145))
  call loop_Q_A(G1(:,:,:,145),Q(:,62),MT,G2(:,:,:,385))
  call loop_QS_A(G2(:,:,:,385),wf(:,0),G2(:,:,:,386),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,386),Q(:,63),MT,G3tensor(:,88))
  call loop_QV_A(G1(:,:,:,75),wf(:,432),G1(:,:,:,146))
  call loop_Q_A(G1(:,:,:,146),Q(:,62),MT,G2(:,:,:,387))
  call loop_QS_A(G2(:,:,:,387),wf(:,0),G2(:,:,:,388),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,388),Q(:,63),MT,G3tensor(:,89))
  call loop_QV_A(G1(:,:,:,75),wf(:,433),G1(:,:,:,147))
  call loop_Q_A(G1(:,:,:,147),Q(:,62),MT,G2(:,:,:,389))
  call loop_QS_A(G2(:,:,:,389),wf(:,0),G2(:,:,:,390),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,390),Q(:,63),MT,G3tensor(:,90))
  call loop_QV_A(G1(:,:,:,75),wf(:,188),G1(:,:,:,148))
  call loop_Q_A(G1(:,:,:,148),Q(:,54),MT,G2(:,:,:,391))
  call loop_QV_A(G2(:,:,:,391),wf(:,-3),G2(:,:,:,392))
  call loop_Q_A(G2(:,:,:,392),Q(:,62),MT,G3(:,:,:,347))
  call loop_QS_A(G3(:,:,:,347),wf(:,0),G3(:,:,:,348),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,348),Q(:,63),MT,G4tensor(:,96))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(6) = M(6) + (-(CI*f(5)) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,1),T3sum(1:35,9))
  M(8) = M(8) + (CI*f(5) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,1),T3sum(1:35,9))
  M(9) = M(9) + (-(CI*f(5)) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,1),T3sum(1:35,9))
  M(10) = M(10) + (CI*f(5) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,1),T3sum(1:35,9))
  M(11) = M(11) + (-(CI*f(5)) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,1),T3sum(1:35,9))
  M(14) = M(14) + (CI*f(5) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,1),T3sum(1:35,9))
  M(17) = M(17) + (-(CI*f(5)) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,1),T3sum(1:35,9))
  M(20) = M(20) + (CI*f(5) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,1),T3sum(1:35,9))
  M(4) = M(4) + (-(CI*f(5)) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,2),T3sum(1:35,9))
  M(6) = M(6) + (CI*f(5) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,2),T3sum(1:35,9))
  M(7) = M(7) + (CI*f(5) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,2),T3sum(1:35,9))
  M(8) = M(8) + (-(CI*f(5)) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,2),T3sum(1:35,9))
  M(10) = M(10) + (-(CI*f(5)) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,2),T3sum(1:35,9))
  M(12) = M(12) + (CI*f(5) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,2),T3sum(1:35,9))
  M(17) = M(17) + (CI*f(5) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,2),T3sum(1:35,9))
  M(23) = M(23) + (-(CI*f(5)) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,2),T3sum(1:35,9))
  M(4) = M(4) + (CI*f(5) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,3),T3sum(1:35,9))
  M(7) = M(7) + (-(CI*f(5)) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,3),T3sum(1:35,9))
  M(9) = M(9) + (CI*f(5) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,3),T3sum(1:35,9))
  M(11) = M(11) + (CI*f(5) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,3),T3sum(1:35,9))
  M(12) = M(12) + (-(CI*f(5)) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,3),T3sum(1:35,9))
  M(14) = M(14) + (-(CI*f(5)) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,3),T3sum(1:35,9))
  M(20) = M(20) + (-(CI*f(5)) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,3),T3sum(1:35,9))
  M(23) = M(23) + (CI*f(5) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,3),T3sum(1:35,9))
  M(6) = M(6) + (-(CI*f(5)) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,46),T3sum(1:35,9))
  M(8) = M(8) + (CI*f(5) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,46),T3sum(1:35,9))
  M(9) = M(9) + (-(CI*f(5)) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,46),T3sum(1:35,9))
  M(10) = M(10) + (CI*f(5) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,46),T3sum(1:35,9))
  M(11) = M(11) + (-(CI*f(5)) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,46),T3sum(1:35,9))
  M(14) = M(14) + (CI*f(5) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,46),T3sum(1:35,9))
  M(17) = M(17) + (-(CI*f(5)) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,46),T3sum(1:35,9))
  M(20) = M(20) + (CI*f(5) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,46),T3sum(1:35,9))
  M(4) = M(4) + (-(CI*f(5)) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,47),T3sum(1:35,9))
  M(6) = M(6) + (CI*f(5) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,47),T3sum(1:35,9))
  M(7) = M(7) + (CI*f(5) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,47),T3sum(1:35,9))
  M(8) = M(8) + (-(CI*f(5)) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,47),T3sum(1:35,9))
  M(10) = M(10) + (-(CI*f(5)) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,47),T3sum(1:35,9))
  M(12) = M(12) + (CI*f(5) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,47),T3sum(1:35,9))
  M(17) = M(17) + (CI*f(5) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,47),T3sum(1:35,9))
  M(23) = M(23) + (-(CI*f(5)) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,47),T3sum(1:35,9))
  M(4) = M(4) + (CI*f(5) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,48),T3sum(1:35,9))
  M(7) = M(7) + (-(CI*f(5)) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,48),T3sum(1:35,9))
  M(9) = M(9) + (CI*f(5) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,48),T3sum(1:35,9))
  M(11) = M(11) + (CI*f(5) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,48),T3sum(1:35,9))
  M(12) = M(12) + (-(CI*f(5)) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,48),T3sum(1:35,9))
  M(14) = M(14) + (-(CI*f(5)) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,48),T3sum(1:35,9))
  M(20) = M(20) + (-(CI*f(5)) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,48),T3sum(1:35,9))
  M(23) = M(23) + (CI*f(5) * den(252)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,48),T3sum(1:35,9))
  M(5) = M(5) + (CI*f(5) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,4),T3sum(1:35,9))
  M(8) = M(8) + (-(CI*f(5)) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,4),T3sum(1:35,9))
  M(11) = M(11) + (CI*f(5) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,4),T3sum(1:35,9))
  M(14) = M(14) + (-(CI*f(5)) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,4),T3sum(1:35,9))
  M(15) = M(15) + (CI*f(5) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,4),T3sum(1:35,9))
  M(16) = M(16) + (-(CI*f(5)) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,4),T3sum(1:35,9))
  M(17) = M(17) + (CI*f(5) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,4),T3sum(1:35,9))
  M(19) = M(19) + (-(CI*f(5)) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,4),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(5)) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,5),T3sum(1:35,9))
  M(8) = M(8) + (CI*f(5) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,5),T3sum(1:35,9))
  M(13) = M(13) + (CI*f(5) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,5),T3sum(1:35,9))
  M(15) = M(15) + (-(CI*f(5)) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,5),T3sum(1:35,9))
  M(17) = M(17) + (-(CI*f(5)) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,5),T3sum(1:35,9))
  M(18) = M(18) + (CI*f(5) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,5),T3sum(1:35,9))
  M(19) = M(19) + (CI*f(5) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,5),T3sum(1:35,9))
  M(21) = M(21) + (-(CI*f(5)) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,5),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(5) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,6),T3sum(1:35,9))
  M(5) = M(5) + (-(CI*f(5)) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,6),T3sum(1:35,9))
  M(11) = M(11) + (-(CI*f(5)) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,6),T3sum(1:35,9))
  M(13) = M(13) + (-(CI*f(5)) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,6),T3sum(1:35,9))
  M(14) = M(14) + (CI*f(5) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,6),T3sum(1:35,9))
  M(16) = M(16) + (CI*f(5) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,6),T3sum(1:35,9))
  M(18) = M(18) + (-(CI*f(5)) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,6),T3sum(1:35,9))
  M(21) = M(21) + (CI*f(5) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,6),T3sum(1:35,9))
  M(5) = M(5) + (CI*f(5) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,49),T3sum(1:35,9))
  M(8) = M(8) + (-(CI*f(5)) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,49),T3sum(1:35,9))
  M(11) = M(11) + (CI*f(5) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,49),T3sum(1:35,9))
  M(14) = M(14) + (-(CI*f(5)) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,49),T3sum(1:35,9))
  M(15) = M(15) + (CI*f(5) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,49),T3sum(1:35,9))
  M(16) = M(16) + (-(CI*f(5)) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,49),T3sum(1:35,9))
  M(17) = M(17) + (CI*f(5) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,49),T3sum(1:35,9))
  M(19) = M(19) + (-(CI*f(5)) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,49),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(5)) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,50),T3sum(1:35,9))
  M(8) = M(8) + (CI*f(5) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,50),T3sum(1:35,9))
  M(13) = M(13) + (CI*f(5) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,50),T3sum(1:35,9))
  M(15) = M(15) + (-(CI*f(5)) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,50),T3sum(1:35,9))
  M(17) = M(17) + (-(CI*f(5)) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,50),T3sum(1:35,9))
  M(18) = M(18) + (CI*f(5) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,50),T3sum(1:35,9))
  M(19) = M(19) + (CI*f(5) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,50),T3sum(1:35,9))
  M(21) = M(21) + (-(CI*f(5)) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,50),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(5) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,51),T3sum(1:35,9))
  M(5) = M(5) + (-(CI*f(5)) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,51),T3sum(1:35,9))
  M(11) = M(11) + (-(CI*f(5)) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,51),T3sum(1:35,9))
  M(13) = M(13) + (-(CI*f(5)) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,51),T3sum(1:35,9))
  M(14) = M(14) + (CI*f(5) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,51),T3sum(1:35,9))
  M(16) = M(16) + (CI*f(5) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,51),T3sum(1:35,9))
  M(18) = M(18) + (-(CI*f(5)) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,51),T3sum(1:35,9))
  M(21) = M(21) + (CI*f(5) * den(255)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,51),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,7),T3sum(1:35,9))
  M(3) = M(3) + (CI*f(5) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,7),T3sum(1:35,9))
  M(9) = M(9) + (CI*f(5) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,7),T3sum(1:35,9))
  M(15) = M(15) + (-(CI*f(5)) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,7),T3sum(1:35,9))
  M(19) = M(19) + (CI*f(5) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,7),T3sum(1:35,9))
  M(20) = M(20) + (-(CI*f(5)) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,7),T3sum(1:35,9))
  M(22) = M(22) + (-(CI*f(5)) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,7),T3sum(1:35,9))
  M(24) = M(24) + (CI*f(5) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,7),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,8),T3sum(1:35,9))
  M(7) = M(7) + (-(CI*f(5)) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,8),T3sum(1:35,9))
  M(13) = M(13) + (-(CI*f(5)) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,8),T3sum(1:35,9))
  M(15) = M(15) + (CI*f(5) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,8),T3sum(1:35,9))
  M(19) = M(19) + (-(CI*f(5)) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,8),T3sum(1:35,9))
  M(21) = M(21) + (CI*f(5) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,8),T3sum(1:35,9))
  M(23) = M(23) + (CI*f(5) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,8),T3sum(1:35,9))
  M(24) = M(24) + (-(CI*f(5)) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,8),T3sum(1:35,9))
  M(3) = M(3) + (-(CI*f(5)) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,9),T3sum(1:35,9))
  M(7) = M(7) + (CI*f(5) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,9),T3sum(1:35,9))
  M(9) = M(9) + (-(CI*f(5)) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,9),T3sum(1:35,9))
  M(13) = M(13) + (CI*f(5) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,9),T3sum(1:35,9))
  M(20) = M(20) + (CI*f(5) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,9),T3sum(1:35,9))
  M(21) = M(21) + (-(CI*f(5)) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,9),T3sum(1:35,9))
  M(22) = M(22) + (CI*f(5) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,9),T3sum(1:35,9))
  M(23) = M(23) + (-(CI*f(5)) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,9),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,52),T3sum(1:35,9))
  M(3) = M(3) + (CI*f(5) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,52),T3sum(1:35,9))
  M(9) = M(9) + (CI*f(5) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,52),T3sum(1:35,9))
  M(15) = M(15) + (-(CI*f(5)) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,52),T3sum(1:35,9))
  M(19) = M(19) + (CI*f(5) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,52),T3sum(1:35,9))
  M(20) = M(20) + (-(CI*f(5)) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,52),T3sum(1:35,9))
  M(22) = M(22) + (-(CI*f(5)) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,52),T3sum(1:35,9))
  M(24) = M(24) + (CI*f(5) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,52),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,53),T3sum(1:35,9))
  M(7) = M(7) + (-(CI*f(5)) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,53),T3sum(1:35,9))
  M(13) = M(13) + (-(CI*f(5)) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,53),T3sum(1:35,9))
  M(15) = M(15) + (CI*f(5) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,53),T3sum(1:35,9))
  M(19) = M(19) + (-(CI*f(5)) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,53),T3sum(1:35,9))
  M(21) = M(21) + (CI*f(5) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,53),T3sum(1:35,9))
  M(23) = M(23) + (CI*f(5) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,53),T3sum(1:35,9))
  M(24) = M(24) + (-(CI*f(5)) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,53),T3sum(1:35,9))
  M(3) = M(3) + (-(CI*f(5)) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,54),T3sum(1:35,9))
  M(7) = M(7) + (CI*f(5) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,54),T3sum(1:35,9))
  M(9) = M(9) + (-(CI*f(5)) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,54),T3sum(1:35,9))
  M(13) = M(13) + (CI*f(5) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,54),T3sum(1:35,9))
  M(20) = M(20) + (CI*f(5) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,54),T3sum(1:35,9))
  M(21) = M(21) + (-(CI*f(5)) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,54),T3sum(1:35,9))
  M(22) = M(22) + (CI*f(5) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,54),T3sum(1:35,9))
  M(23) = M(23) + (-(CI*f(5)) * den(257)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,54),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,10),T3sum(1:35,9))
  M(3) = M(3) + (CI*f(5) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,10),T3sum(1:35,9))
  M(5) = M(5) + (CI*f(5) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,10),T3sum(1:35,9))
  M(6) = M(6) + (-(CI*f(5)) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,10),T3sum(1:35,9))
  M(10) = M(10) + (CI*f(5) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,10),T3sum(1:35,9))
  M(16) = M(16) + (-(CI*f(5)) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,10),T3sum(1:35,9))
  M(22) = M(22) + (-(CI*f(5)) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,10),T3sum(1:35,9))
  M(24) = M(24) + (CI*f(5) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,10),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,11),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(5)) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,11),T3sum(1:35,9))
  M(4) = M(4) + (-(CI*f(5)) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,11),T3sum(1:35,9))
  M(6) = M(6) + (CI*f(5) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,11),T3sum(1:35,9))
  M(10) = M(10) + (-(CI*f(5)) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,11),T3sum(1:35,9))
  M(12) = M(12) + (CI*f(5) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,11),T3sum(1:35,9))
  M(18) = M(18) + (CI*f(5) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,11),T3sum(1:35,9))
  M(24) = M(24) + (-(CI*f(5)) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,11),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(5) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,12),T3sum(1:35,9))
  M(3) = M(3) + (-(CI*f(5)) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,12),T3sum(1:35,9))
  M(4) = M(4) + (CI*f(5) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,12),T3sum(1:35,9))
  M(5) = M(5) + (-(CI*f(5)) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,12),T3sum(1:35,9))
  M(12) = M(12) + (-(CI*f(5)) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,12),T3sum(1:35,9))
  M(16) = M(16) + (CI*f(5) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,12),T3sum(1:35,9))
  M(18) = M(18) + (-(CI*f(5)) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,12),T3sum(1:35,9))
  M(22) = M(22) + (CI*f(5) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,12),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,55),T3sum(1:35,9))
  M(3) = M(3) + (CI*f(5) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,55),T3sum(1:35,9))
  M(5) = M(5) + (CI*f(5) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,55),T3sum(1:35,9))
  M(6) = M(6) + (-(CI*f(5)) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,55),T3sum(1:35,9))
  M(10) = M(10) + (CI*f(5) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,55),T3sum(1:35,9))
  M(16) = M(16) + (-(CI*f(5)) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,55),T3sum(1:35,9))
  M(22) = M(22) + (-(CI*f(5)) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,55),T3sum(1:35,9))
  M(24) = M(24) + (CI*f(5) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,55),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,56),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(5)) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,56),T3sum(1:35,9))
  M(4) = M(4) + (-(CI*f(5)) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,56),T3sum(1:35,9))
  M(6) = M(6) + (CI*f(5) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,56),T3sum(1:35,9))
  M(10) = M(10) + (-(CI*f(5)) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,56),T3sum(1:35,9))
  M(12) = M(12) + (CI*f(5) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,56),T3sum(1:35,9))
  M(18) = M(18) + (CI*f(5) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,56),T3sum(1:35,9))
  M(24) = M(24) + (-(CI*f(5)) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,56),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(5) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,57),T3sum(1:35,9))
  M(3) = M(3) + (-(CI*f(5)) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,57),T3sum(1:35,9))
  M(4) = M(4) + (CI*f(5) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,57),T3sum(1:35,9))
  M(5) = M(5) + (-(CI*f(5)) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,57),T3sum(1:35,9))
  M(12) = M(12) + (-(CI*f(5)) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,57),T3sum(1:35,9))
  M(16) = M(16) + (CI*f(5) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,57),T3sum(1:35,9))
  M(18) = M(18) + (-(CI*f(5)) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,57),T3sum(1:35,9))
  M(22) = M(22) + (CI*f(5) * den(259)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,57),T3sum(1:35,9))
  M(10) = M(10) + (-f(6) * den(2)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,1),T4sum(1:70,5))
  M(16) = M(16) + (f(6) * den(2)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,1),T4sum(1:70,5))
  M(22) = M(22) + (f(6) * den(2)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,1),T4sum(1:70,5))
  M(24) = M(24) + (-f(6) * den(2)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,1),T4sum(1:70,5))
  M(10) = M(10) + (f(6) * den(2)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,2),T4sum(1:70,5))
  M(12) = M(12) + (-f(6) * den(2)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,2),T4sum(1:70,5))
  M(18) = M(18) + (-f(6) * den(2)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,2),T4sum(1:70,5))
  M(24) = M(24) + (f(6) * den(2)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,2),T4sum(1:70,5))
  M(12) = M(12) + (f(6) * den(2)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,3),T4sum(1:70,5))
  M(16) = M(16) + (-f(6) * den(2)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,3),T4sum(1:70,5))
  M(18) = M(18) + (f(6) * den(2)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,3),T4sum(1:70,5))
  M(22) = M(22) + (-f(6) * den(2)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,3),T4sum(1:70,5))
  M(1) = M(1) + (-f(6) * den(2)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,49),T4sum(1:70,5))
  M(3) = M(3) + (f(6) * den(2)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,49),T4sum(1:70,5))
  M(5) = M(5) + (f(6) * den(2)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,49),T4sum(1:70,5))
  M(6) = M(6) + (-f(6) * den(2)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,49),T4sum(1:70,5))
  M(1) = M(1) + (f(6) * den(2)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,50),T4sum(1:70,5))
  M(2) = M(2) + (-f(6) * den(2)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,50),T4sum(1:70,5))
  M(4) = M(4) + (-f(6) * den(2)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,50),T4sum(1:70,5))
  M(6) = M(6) + (f(6) * den(2)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,50),T4sum(1:70,5))
  M(2) = M(2) + (f(6) * den(2)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,51),T4sum(1:70,5))
  M(3) = M(3) + (-f(6) * den(2)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,51),T4sum(1:70,5))
  M(4) = M(4) + (f(6) * den(2)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,51),T4sum(1:70,5))
  M(5) = M(5) + (-f(6) * den(2)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,51),T4sum(1:70,5))
  M(5) = M(5) + (CI*f(5) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,13),T3sum(1:35,9))
  M(6) = M(6) + (-(CI*f(5)) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,13),T3sum(1:35,9))
  M(9) = M(9) + (-(CI*f(5)) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,13),T3sum(1:35,9))
  M(10) = M(10) + (CI*f(5) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,13),T3sum(1:35,9))
  M(15) = M(15) + (CI*f(5) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,13),T3sum(1:35,9))
  M(16) = M(16) + (-(CI*f(5)) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,13),T3sum(1:35,9))
  M(19) = M(19) + (-(CI*f(5)) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,13),T3sum(1:35,9))
  M(20) = M(20) + (CI*f(5) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,13),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,14),T3sum(1:35,9))
  M(3) = M(3) + (-(CI*f(5)) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,14),T3sum(1:35,9))
  M(5) = M(5) + (-(CI*f(5)) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,14),T3sum(1:35,9))
  M(6) = M(6) + (CI*f(5) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,14),T3sum(1:35,9))
  M(10) = M(10) + (-(CI*f(5)) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,14),T3sum(1:35,9))
  M(16) = M(16) + (CI*f(5) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,14),T3sum(1:35,9))
  M(22) = M(22) + (CI*f(5) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,14),T3sum(1:35,9))
  M(24) = M(24) + (-(CI*f(5)) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,14),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,15),T3sum(1:35,9))
  M(3) = M(3) + (CI*f(5) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,15),T3sum(1:35,9))
  M(9) = M(9) + (CI*f(5) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,15),T3sum(1:35,9))
  M(15) = M(15) + (-(CI*f(5)) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,15),T3sum(1:35,9))
  M(19) = M(19) + (CI*f(5) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,15),T3sum(1:35,9))
  M(20) = M(20) + (-(CI*f(5)) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,15),T3sum(1:35,9))
  M(22) = M(22) + (-(CI*f(5)) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,15),T3sum(1:35,9))
  M(24) = M(24) + (CI*f(5) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,15),T3sum(1:35,9))
  M(5) = M(5) + (CI*f(5) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,58),T3sum(1:35,9))
  M(6) = M(6) + (-(CI*f(5)) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,58),T3sum(1:35,9))
  M(9) = M(9) + (-(CI*f(5)) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,58),T3sum(1:35,9))
  M(10) = M(10) + (CI*f(5) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,58),T3sum(1:35,9))
  M(15) = M(15) + (CI*f(5) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,58),T3sum(1:35,9))
  M(16) = M(16) + (-(CI*f(5)) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,58),T3sum(1:35,9))
  M(19) = M(19) + (-(CI*f(5)) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,58),T3sum(1:35,9))
  M(20) = M(20) + (CI*f(5) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,58),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,59),T3sum(1:35,9))
  M(3) = M(3) + (-(CI*f(5)) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,59),T3sum(1:35,9))
  M(5) = M(5) + (-(CI*f(5)) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,59),T3sum(1:35,9))
  M(6) = M(6) + (CI*f(5) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,59),T3sum(1:35,9))
  M(10) = M(10) + (-(CI*f(5)) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,59),T3sum(1:35,9))
  M(16) = M(16) + (CI*f(5) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,59),T3sum(1:35,9))
  M(22) = M(22) + (CI*f(5) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,59),T3sum(1:35,9))
  M(24) = M(24) + (-(CI*f(5)) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,59),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,60),T3sum(1:35,9))
  M(3) = M(3) + (CI*f(5) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,60),T3sum(1:35,9))
  M(9) = M(9) + (CI*f(5) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,60),T3sum(1:35,9))
  M(15) = M(15) + (-(CI*f(5)) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,60),T3sum(1:35,9))
  M(19) = M(19) + (CI*f(5) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,60),T3sum(1:35,9))
  M(20) = M(20) + (-(CI*f(5)) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,60),T3sum(1:35,9))
  M(22) = M(22) + (-(CI*f(5)) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,60),T3sum(1:35,9))
  M(24) = M(24) + (CI*f(5) * den(279)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,60),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(5) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,16),T3sum(1:35,9))
  M(5) = M(5) + (-(CI*f(5)) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,16),T3sum(1:35,9))
  M(11) = M(11) + (-(CI*f(5)) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,16),T3sum(1:35,9))
  M(13) = M(13) + (-(CI*f(5)) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,16),T3sum(1:35,9))
  M(14) = M(14) + (CI*f(5) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,16),T3sum(1:35,9))
  M(16) = M(16) + (CI*f(5) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,16),T3sum(1:35,9))
  M(18) = M(18) + (-(CI*f(5)) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,16),T3sum(1:35,9))
  M(21) = M(21) + (CI*f(5) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,16),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(5)) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,17),T3sum(1:35,9))
  M(3) = M(3) + (CI*f(5) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,17),T3sum(1:35,9))
  M(4) = M(4) + (-(CI*f(5)) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,17),T3sum(1:35,9))
  M(5) = M(5) + (CI*f(5) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,17),T3sum(1:35,9))
  M(12) = M(12) + (CI*f(5) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,17),T3sum(1:35,9))
  M(16) = M(16) + (-(CI*f(5)) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,17),T3sum(1:35,9))
  M(18) = M(18) + (CI*f(5) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,17),T3sum(1:35,9))
  M(22) = M(22) + (-(CI*f(5)) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,17),T3sum(1:35,9))
  M(3) = M(3) + (-(CI*f(5)) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,18),T3sum(1:35,9))
  M(4) = M(4) + (CI*f(5) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,18),T3sum(1:35,9))
  M(11) = M(11) + (CI*f(5) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,18),T3sum(1:35,9))
  M(12) = M(12) + (-(CI*f(5)) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,18),T3sum(1:35,9))
  M(13) = M(13) + (CI*f(5) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,18),T3sum(1:35,9))
  M(14) = M(14) + (-(CI*f(5)) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,18),T3sum(1:35,9))
  M(21) = M(21) + (-(CI*f(5)) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,18),T3sum(1:35,9))
  M(22) = M(22) + (CI*f(5) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,18),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(5) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,61),T3sum(1:35,9))
  M(5) = M(5) + (-(CI*f(5)) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,61),T3sum(1:35,9))
  M(11) = M(11) + (-(CI*f(5)) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,61),T3sum(1:35,9))
  M(13) = M(13) + (-(CI*f(5)) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,61),T3sum(1:35,9))
  M(14) = M(14) + (CI*f(5) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,61),T3sum(1:35,9))
  M(16) = M(16) + (CI*f(5) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,61),T3sum(1:35,9))
  M(18) = M(18) + (-(CI*f(5)) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,61),T3sum(1:35,9))
  M(21) = M(21) + (CI*f(5) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,61),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(5)) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,62),T3sum(1:35,9))
  M(3) = M(3) + (CI*f(5) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,62),T3sum(1:35,9))
  M(4) = M(4) + (-(CI*f(5)) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,62),T3sum(1:35,9))
  M(5) = M(5) + (CI*f(5) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,62),T3sum(1:35,9))
  M(12) = M(12) + (CI*f(5) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,62),T3sum(1:35,9))
  M(16) = M(16) + (-(CI*f(5)) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,62),T3sum(1:35,9))
  M(18) = M(18) + (CI*f(5) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,62),T3sum(1:35,9))
  M(22) = M(22) + (-(CI*f(5)) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,62),T3sum(1:35,9))
  M(3) = M(3) + (-(CI*f(5)) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,63),T3sum(1:35,9))
  M(4) = M(4) + (CI*f(5) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,63),T3sum(1:35,9))
  M(11) = M(11) + (CI*f(5) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,63),T3sum(1:35,9))
  M(12) = M(12) + (-(CI*f(5)) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,63),T3sum(1:35,9))
  M(13) = M(13) + (CI*f(5) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,63),T3sum(1:35,9))
  M(14) = M(14) + (-(CI*f(5)) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,63),T3sum(1:35,9))
  M(21) = M(21) + (-(CI*f(5)) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,63),T3sum(1:35,9))
  M(22) = M(22) + (CI*f(5) * den(281)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,63),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(5) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,19),T3sum(1:35,9))
  M(8) = M(8) + (-(CI*f(5)) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,19),T3sum(1:35,9))
  M(13) = M(13) + (-(CI*f(5)) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,19),T3sum(1:35,9))
  M(15) = M(15) + (CI*f(5) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,19),T3sum(1:35,9))
  M(17) = M(17) + (CI*f(5) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,19),T3sum(1:35,9))
  M(18) = M(18) + (-(CI*f(5)) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,19),T3sum(1:35,9))
  M(19) = M(19) + (-(CI*f(5)) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,19),T3sum(1:35,9))
  M(21) = M(21) + (CI*f(5) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,19),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,20),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(5)) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,20),T3sum(1:35,9))
  M(7) = M(7) + (-(CI*f(5)) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,20),T3sum(1:35,9))
  M(8) = M(8) + (CI*f(5) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,20),T3sum(1:35,9))
  M(17) = M(17) + (-(CI*f(5)) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,20),T3sum(1:35,9))
  M(18) = M(18) + (CI*f(5) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,20),T3sum(1:35,9))
  M(23) = M(23) + (CI*f(5) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,20),T3sum(1:35,9))
  M(24) = M(24) + (-(CI*f(5)) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,20),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,21),T3sum(1:35,9))
  M(7) = M(7) + (CI*f(5) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,21),T3sum(1:35,9))
  M(13) = M(13) + (CI*f(5) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,21),T3sum(1:35,9))
  M(15) = M(15) + (-(CI*f(5)) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,21),T3sum(1:35,9))
  M(19) = M(19) + (CI*f(5) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,21),T3sum(1:35,9))
  M(21) = M(21) + (-(CI*f(5)) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,21),T3sum(1:35,9))
  M(23) = M(23) + (-(CI*f(5)) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,21),T3sum(1:35,9))
  M(24) = M(24) + (CI*f(5) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,21),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(5) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,64),T3sum(1:35,9))
  M(8) = M(8) + (-(CI*f(5)) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,64),T3sum(1:35,9))
  M(13) = M(13) + (-(CI*f(5)) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,64),T3sum(1:35,9))
  M(15) = M(15) + (CI*f(5) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,64),T3sum(1:35,9))
  M(17) = M(17) + (CI*f(5) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,64),T3sum(1:35,9))
  M(18) = M(18) + (-(CI*f(5)) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,64),T3sum(1:35,9))
  M(19) = M(19) + (-(CI*f(5)) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,64),T3sum(1:35,9))
  M(21) = M(21) + (CI*f(5) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,64),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,65),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(5)) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,65),T3sum(1:35,9))
  M(7) = M(7) + (-(CI*f(5)) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,65),T3sum(1:35,9))
  M(8) = M(8) + (CI*f(5) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,65),T3sum(1:35,9))
  M(17) = M(17) + (-(CI*f(5)) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,65),T3sum(1:35,9))
  M(18) = M(18) + (CI*f(5) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,65),T3sum(1:35,9))
  M(23) = M(23) + (CI*f(5) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,65),T3sum(1:35,9))
  M(24) = M(24) + (-(CI*f(5)) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,65),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,66),T3sum(1:35,9))
  M(7) = M(7) + (CI*f(5) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,66),T3sum(1:35,9))
  M(13) = M(13) + (CI*f(5) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,66),T3sum(1:35,9))
  M(15) = M(15) + (-(CI*f(5)) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,66),T3sum(1:35,9))
  M(19) = M(19) + (CI*f(5) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,66),T3sum(1:35,9))
  M(21) = M(21) + (-(CI*f(5)) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,66),T3sum(1:35,9))
  M(23) = M(23) + (-(CI*f(5)) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,66),T3sum(1:35,9))
  M(24) = M(24) + (CI*f(5) * den(283)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,66),T3sum(1:35,9))
  M(8) = M(8) + (-f(6) * den(34)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,7),T4sum(1:70,25))
  M(15) = M(15) + (f(6) * den(34)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,7),T4sum(1:70,25))
  M(18) = M(18) + (-f(6) * den(34)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,7),T4sum(1:70,25))
  M(21) = M(21) + (f(6) * den(34)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,7),T4sum(1:70,25))
  M(7) = M(7) + (-f(6) * den(34)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,8),T4sum(1:70,25))
  M(8) = M(8) + (f(6) * den(34)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,8),T4sum(1:70,25))
  M(18) = M(18) + (f(6) * den(34)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,8),T4sum(1:70,25))
  M(24) = M(24) + (-f(6) * den(34)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,8),T4sum(1:70,25))
  M(7) = M(7) + (f(6) * den(34)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,9),T4sum(1:70,25))
  M(15) = M(15) + (-f(6) * den(34)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,9),T4sum(1:70,25))
  M(21) = M(21) + (-f(6) * den(34)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,9),T4sum(1:70,25))
  M(24) = M(24) + (f(6) * den(34)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,9),T4sum(1:70,25))
  M(2) = M(2) + (-f(6) * den(34)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,55),T4sum(1:70,25))
  M(13) = M(13) + (f(6) * den(34)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,55),T4sum(1:70,25))
  M(17) = M(17) + (-f(6) * den(34)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,55),T4sum(1:70,25))
  M(19) = M(19) + (f(6) * den(34)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,55),T4sum(1:70,25))
  M(1) = M(1) + (-f(6) * den(34)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,56),T4sum(1:70,25))
  M(2) = M(2) + (f(6) * den(34)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,56),T4sum(1:70,25))
  M(17) = M(17) + (f(6) * den(34)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,56),T4sum(1:70,25))
  M(23) = M(23) + (-f(6) * den(34)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,56),T4sum(1:70,25))
  M(1) = M(1) + (f(6) * den(34)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,57),T4sum(1:70,25))
  M(13) = M(13) + (-f(6) * den(34)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,57),T4sum(1:70,25))
  M(19) = M(19) + (-f(6) * den(34)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,57),T4sum(1:70,25))
  M(23) = M(23) + (f(6) * den(34)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,57),T4sum(1:70,25))
  M(2) = M(2) + (-f(6) * den(34)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,10),T4sum(1:70,27))
  M(13) = M(13) + (f(6) * den(34)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,10),T4sum(1:70,27))
  M(17) = M(17) + (-f(6) * den(34)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,10),T4sum(1:70,27))
  M(19) = M(19) + (f(6) * den(34)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,10),T4sum(1:70,27))
  M(1) = M(1) + (-f(6) * den(34)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,11),T4sum(1:70,27))
  M(2) = M(2) + (f(6) * den(34)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,11),T4sum(1:70,27))
  M(17) = M(17) + (f(6) * den(34)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,11),T4sum(1:70,27))
  M(23) = M(23) + (-f(6) * den(34)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,11),T4sum(1:70,27))
  M(1) = M(1) + (f(6) * den(34)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,12),T4sum(1:70,27))
  M(13) = M(13) + (-f(6) * den(34)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,12),T4sum(1:70,27))
  M(19) = M(19) + (-f(6) * den(34)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,12),T4sum(1:70,27))
  M(23) = M(23) + (f(6) * den(34)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,12),T4sum(1:70,27))
  M(8) = M(8) + (-f(6) * den(34)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,58),T4sum(1:70,27))
  M(15) = M(15) + (f(6) * den(34)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,58),T4sum(1:70,27))
  M(18) = M(18) + (-f(6) * den(34)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,58),T4sum(1:70,27))
  M(21) = M(21) + (f(6) * den(34)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,58),T4sum(1:70,27))
  M(7) = M(7) + (-f(6) * den(34)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,59),T4sum(1:70,27))
  M(8) = M(8) + (f(6) * den(34)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,59),T4sum(1:70,27))
  M(18) = M(18) + (f(6) * den(34)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,59),T4sum(1:70,27))
  M(24) = M(24) + (-f(6) * den(34)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,59),T4sum(1:70,27))
  M(7) = M(7) + (f(6) * den(34)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,60),T4sum(1:70,27))
  M(15) = M(15) + (-f(6) * den(34)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,60),T4sum(1:70,27))
  M(21) = M(21) + (-f(6) * den(34)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,60),T4sum(1:70,27))
  M(24) = M(24) + (f(6) * den(34)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,60),T4sum(1:70,27))
  M(4) = M(4) + (CI*f(5) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,22),T3sum(1:35,9))
  M(6) = M(6) + (-(CI*f(5)) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,22),T3sum(1:35,9))
  M(7) = M(7) + (-(CI*f(5)) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,22),T3sum(1:35,9))
  M(8) = M(8) + (CI*f(5) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,22),T3sum(1:35,9))
  M(10) = M(10) + (CI*f(5) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,22),T3sum(1:35,9))
  M(12) = M(12) + (-(CI*f(5)) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,22),T3sum(1:35,9))
  M(17) = M(17) + (-(CI*f(5)) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,22),T3sum(1:35,9))
  M(23) = M(23) + (CI*f(5) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,22),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,23),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(5)) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,23),T3sum(1:35,9))
  M(4) = M(4) + (-(CI*f(5)) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,23),T3sum(1:35,9))
  M(6) = M(6) + (CI*f(5) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,23),T3sum(1:35,9))
  M(10) = M(10) + (-(CI*f(5)) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,23),T3sum(1:35,9))
  M(12) = M(12) + (CI*f(5) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,23),T3sum(1:35,9))
  M(18) = M(18) + (CI*f(5) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,23),T3sum(1:35,9))
  M(24) = M(24) + (-(CI*f(5)) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,23),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,24),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(5) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,24),T3sum(1:35,9))
  M(7) = M(7) + (CI*f(5) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,24),T3sum(1:35,9))
  M(8) = M(8) + (-(CI*f(5)) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,24),T3sum(1:35,9))
  M(17) = M(17) + (CI*f(5) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,24),T3sum(1:35,9))
  M(18) = M(18) + (-(CI*f(5)) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,24),T3sum(1:35,9))
  M(23) = M(23) + (-(CI*f(5)) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,24),T3sum(1:35,9))
  M(24) = M(24) + (CI*f(5) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,24),T3sum(1:35,9))
  M(4) = M(4) + (CI*f(5) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,67),T3sum(1:35,9))
  M(6) = M(6) + (-(CI*f(5)) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,67),T3sum(1:35,9))
  M(7) = M(7) + (-(CI*f(5)) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,67),T3sum(1:35,9))
  M(8) = M(8) + (CI*f(5) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,67),T3sum(1:35,9))
  M(10) = M(10) + (CI*f(5) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,67),T3sum(1:35,9))
  M(12) = M(12) + (-(CI*f(5)) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,67),T3sum(1:35,9))
  M(17) = M(17) + (-(CI*f(5)) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,67),T3sum(1:35,9))
  M(23) = M(23) + (CI*f(5) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,67),T3sum(1:35,9))
  M(1) = M(1) + (CI*f(5) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,68),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(5)) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,68),T3sum(1:35,9))
  M(4) = M(4) + (-(CI*f(5)) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,68),T3sum(1:35,9))
  M(6) = M(6) + (CI*f(5) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,68),T3sum(1:35,9))
  M(10) = M(10) + (-(CI*f(5)) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,68),T3sum(1:35,9))
  M(12) = M(12) + (CI*f(5) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,68),T3sum(1:35,9))
  M(18) = M(18) + (CI*f(5) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,68),T3sum(1:35,9))
  M(24) = M(24) + (-(CI*f(5)) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,68),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,69),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(5) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,69),T3sum(1:35,9))
  M(7) = M(7) + (CI*f(5) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,69),T3sum(1:35,9))
  M(8) = M(8) + (-(CI*f(5)) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,69),T3sum(1:35,9))
  M(17) = M(17) + (CI*f(5) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,69),T3sum(1:35,9))
  M(18) = M(18) + (-(CI*f(5)) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,69),T3sum(1:35,9))
  M(23) = M(23) + (-(CI*f(5)) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,69),T3sum(1:35,9))
  M(24) = M(24) + (CI*f(5) * den(286)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,69),T3sum(1:35,9))
  M(4) = M(4) + (CI*f(5) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,25),T3sum(1:35,9))
  M(7) = M(7) + (-(CI*f(5)) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,25),T3sum(1:35,9))
  M(9) = M(9) + (CI*f(5) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,25),T3sum(1:35,9))
  M(11) = M(11) + (CI*f(5) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,25),T3sum(1:35,9))
  M(12) = M(12) + (-(CI*f(5)) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,25),T3sum(1:35,9))
  M(14) = M(14) + (-(CI*f(5)) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,25),T3sum(1:35,9))
  M(20) = M(20) + (-(CI*f(5)) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,25),T3sum(1:35,9))
  M(23) = M(23) + (CI*f(5) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,25),T3sum(1:35,9))
  M(3) = M(3) + (CI*f(5) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,26),T3sum(1:35,9))
  M(4) = M(4) + (-(CI*f(5)) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,26),T3sum(1:35,9))
  M(11) = M(11) + (-(CI*f(5)) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,26),T3sum(1:35,9))
  M(12) = M(12) + (CI*f(5) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,26),T3sum(1:35,9))
  M(13) = M(13) + (-(CI*f(5)) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,26),T3sum(1:35,9))
  M(14) = M(14) + (CI*f(5) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,26),T3sum(1:35,9))
  M(21) = M(21) + (CI*f(5) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,26),T3sum(1:35,9))
  M(22) = M(22) + (-(CI*f(5)) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,26),T3sum(1:35,9))
  M(3) = M(3) + (-(CI*f(5)) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,27),T3sum(1:35,9))
  M(7) = M(7) + (CI*f(5) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,27),T3sum(1:35,9))
  M(9) = M(9) + (-(CI*f(5)) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,27),T3sum(1:35,9))
  M(13) = M(13) + (CI*f(5) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,27),T3sum(1:35,9))
  M(20) = M(20) + (CI*f(5) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,27),T3sum(1:35,9))
  M(21) = M(21) + (-(CI*f(5)) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,27),T3sum(1:35,9))
  M(22) = M(22) + (CI*f(5) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,27),T3sum(1:35,9))
  M(23) = M(23) + (-(CI*f(5)) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,27),T3sum(1:35,9))
  M(4) = M(4) + (CI*f(5) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,70),T3sum(1:35,9))
  M(7) = M(7) + (-(CI*f(5)) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,70),T3sum(1:35,9))
  M(9) = M(9) + (CI*f(5) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,70),T3sum(1:35,9))
  M(11) = M(11) + (CI*f(5) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,70),T3sum(1:35,9))
  M(12) = M(12) + (-(CI*f(5)) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,70),T3sum(1:35,9))
  M(14) = M(14) + (-(CI*f(5)) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,70),T3sum(1:35,9))
  M(20) = M(20) + (-(CI*f(5)) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,70),T3sum(1:35,9))
  M(23) = M(23) + (CI*f(5) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,70),T3sum(1:35,9))
  M(3) = M(3) + (CI*f(5) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,71),T3sum(1:35,9))
  M(4) = M(4) + (-(CI*f(5)) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,71),T3sum(1:35,9))
  M(11) = M(11) + (-(CI*f(5)) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,71),T3sum(1:35,9))
  M(12) = M(12) + (CI*f(5) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,71),T3sum(1:35,9))
  M(13) = M(13) + (-(CI*f(5)) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,71),T3sum(1:35,9))
  M(14) = M(14) + (CI*f(5) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,71),T3sum(1:35,9))
  M(21) = M(21) + (CI*f(5) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,71),T3sum(1:35,9))
  M(22) = M(22) + (-(CI*f(5)) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,71),T3sum(1:35,9))
  M(3) = M(3) + (-(CI*f(5)) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,72),T3sum(1:35,9))
  M(7) = M(7) + (CI*f(5) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,72),T3sum(1:35,9))
  M(9) = M(9) + (-(CI*f(5)) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,72),T3sum(1:35,9))
  M(13) = M(13) + (CI*f(5) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,72),T3sum(1:35,9))
  M(20) = M(20) + (CI*f(5) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,72),T3sum(1:35,9))
  M(21) = M(21) + (-(CI*f(5)) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,72),T3sum(1:35,9))
  M(22) = M(22) + (CI*f(5) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,72),T3sum(1:35,9))
  M(23) = M(23) + (-(CI*f(5)) * den(288)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,72),T3sum(1:35,9))
  M(9) = M(9) + (f(6) * den(39)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,16),T4sum(1:70,31))
  M(12) = M(12) + (-f(6) * den(39)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,16),T4sum(1:70,31))
  M(14) = M(14) + (-f(6) * den(39)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,16),T4sum(1:70,31))
  M(23) = M(23) + (f(6) * den(39)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,16),T4sum(1:70,31))
  M(12) = M(12) + (f(6) * den(39)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,17),T4sum(1:70,31))
  M(13) = M(13) + (-f(6) * den(39)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,17),T4sum(1:70,31))
  M(14) = M(14) + (f(6) * den(39)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,17),T4sum(1:70,31))
  M(22) = M(22) + (-f(6) * den(39)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,17),T4sum(1:70,31))
  M(9) = M(9) + (-f(6) * den(39)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,18),T4sum(1:70,31))
  M(13) = M(13) + (f(6) * den(39)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,18),T4sum(1:70,31))
  M(22) = M(22) + (f(6) * den(39)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,18),T4sum(1:70,31))
  M(23) = M(23) + (-f(6) * den(39)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,18),T4sum(1:70,31))
  M(4) = M(4) + (-f(6) * den(39)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,64),T4sum(1:70,31))
  M(7) = M(7) + (f(6) * den(39)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,64),T4sum(1:70,31))
  M(11) = M(11) + (-f(6) * den(39)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,64),T4sum(1:70,31))
  M(20) = M(20) + (f(6) * den(39)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,64),T4sum(1:70,31))
  M(3) = M(3) + (-f(6) * den(39)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,65),T4sum(1:70,31))
  M(4) = M(4) + (f(6) * den(39)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,65),T4sum(1:70,31))
  M(11) = M(11) + (f(6) * den(39)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,65),T4sum(1:70,31))
  M(21) = M(21) + (-f(6) * den(39)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,65),T4sum(1:70,31))
  M(3) = M(3) + (f(6) * den(39)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,66),T4sum(1:70,31))
  M(7) = M(7) + (-f(6) * den(39)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,66),T4sum(1:70,31))
  M(20) = M(20) + (-f(6) * den(39)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,66),T4sum(1:70,31))
  M(21) = M(21) + (f(6) * den(39)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,66),T4sum(1:70,31))
  M(4) = M(4) + (-f(6) * den(39)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,19),T4sum(1:70,33))
  M(7) = M(7) + (f(6) * den(39)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,19),T4sum(1:70,33))
  M(11) = M(11) + (-f(6) * den(39)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,19),T4sum(1:70,33))
  M(20) = M(20) + (f(6) * den(39)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,19),T4sum(1:70,33))
  M(3) = M(3) + (-f(6) * den(39)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,20),T4sum(1:70,33))
  M(4) = M(4) + (f(6) * den(39)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,20),T4sum(1:70,33))
  M(11) = M(11) + (f(6) * den(39)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,20),T4sum(1:70,33))
  M(21) = M(21) + (-f(6) * den(39)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,20),T4sum(1:70,33))
  M(3) = M(3) + (f(6) * den(39)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,21),T4sum(1:70,33))
  M(7) = M(7) + (-f(6) * den(39)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,21),T4sum(1:70,33))
  M(20) = M(20) + (-f(6) * den(39)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,21),T4sum(1:70,33))
  M(21) = M(21) + (f(6) * den(39)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,21),T4sum(1:70,33))
  M(9) = M(9) + (f(6) * den(39)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,67),T4sum(1:70,33))
  M(12) = M(12) + (-f(6) * den(39)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,67),T4sum(1:70,33))
  M(14) = M(14) + (-f(6) * den(39)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,67),T4sum(1:70,33))
  M(23) = M(23) + (f(6) * den(39)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,67),T4sum(1:70,33))
  M(12) = M(12) + (f(6) * den(39)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,68),T4sum(1:70,33))
  M(13) = M(13) + (-f(6) * den(39)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,68),T4sum(1:70,33))
  M(14) = M(14) + (f(6) * den(39)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,68),T4sum(1:70,33))
  M(22) = M(22) + (-f(6) * den(39)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,68),T4sum(1:70,33))
  M(9) = M(9) + (-f(6) * den(39)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,69),T4sum(1:70,33))
  M(13) = M(13) + (f(6) * den(39)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,69),T4sum(1:70,33))
  M(22) = M(22) + (f(6) * den(39)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,69),T4sum(1:70,33))
  M(23) = M(23) + (-f(6) * den(39)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,69),T4sum(1:70,33))
  M(6) = M(6) + (-(CI*f(5)) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,28),T3sum(1:35,9))
  M(8) = M(8) + (CI*f(5) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,28),T3sum(1:35,9))
  M(9) = M(9) + (-(CI*f(5)) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,28),T3sum(1:35,9))
  M(10) = M(10) + (CI*f(5) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,28),T3sum(1:35,9))
  M(11) = M(11) + (-(CI*f(5)) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,28),T3sum(1:35,9))
  M(14) = M(14) + (CI*f(5) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,28),T3sum(1:35,9))
  M(17) = M(17) + (-(CI*f(5)) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,28),T3sum(1:35,9))
  M(20) = M(20) + (CI*f(5) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,28),T3sum(1:35,9))
  M(5) = M(5) + (-(CI*f(5)) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,29),T3sum(1:35,9))
  M(6) = M(6) + (CI*f(5) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,29),T3sum(1:35,9))
  M(9) = M(9) + (CI*f(5) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,29),T3sum(1:35,9))
  M(10) = M(10) + (-(CI*f(5)) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,29),T3sum(1:35,9))
  M(15) = M(15) + (-(CI*f(5)) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,29),T3sum(1:35,9))
  M(16) = M(16) + (CI*f(5) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,29),T3sum(1:35,9))
  M(19) = M(19) + (CI*f(5) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,29),T3sum(1:35,9))
  M(20) = M(20) + (-(CI*f(5)) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,29),T3sum(1:35,9))
  M(5) = M(5) + (CI*f(5) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,30),T3sum(1:35,9))
  M(8) = M(8) + (-(CI*f(5)) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,30),T3sum(1:35,9))
  M(11) = M(11) + (CI*f(5) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,30),T3sum(1:35,9))
  M(14) = M(14) + (-(CI*f(5)) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,30),T3sum(1:35,9))
  M(15) = M(15) + (CI*f(5) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,30),T3sum(1:35,9))
  M(16) = M(16) + (-(CI*f(5)) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,30),T3sum(1:35,9))
  M(17) = M(17) + (CI*f(5) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,30),T3sum(1:35,9))
  M(19) = M(19) + (-(CI*f(5)) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,30),T3sum(1:35,9))
  M(6) = M(6) + (-(CI*f(5)) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,73),T3sum(1:35,9))
  M(8) = M(8) + (CI*f(5) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,73),T3sum(1:35,9))
  M(9) = M(9) + (-(CI*f(5)) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,73),T3sum(1:35,9))
  M(10) = M(10) + (CI*f(5) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,73),T3sum(1:35,9))
  M(11) = M(11) + (-(CI*f(5)) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,73),T3sum(1:35,9))
  M(14) = M(14) + (CI*f(5) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,73),T3sum(1:35,9))
  M(17) = M(17) + (-(CI*f(5)) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,73),T3sum(1:35,9))
  M(20) = M(20) + (CI*f(5) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,73),T3sum(1:35,9))
  M(5) = M(5) + (-(CI*f(5)) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,74),T3sum(1:35,9))
  M(6) = M(6) + (CI*f(5) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,74),T3sum(1:35,9))
  M(9) = M(9) + (CI*f(5) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,74),T3sum(1:35,9))
  M(10) = M(10) + (-(CI*f(5)) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,74),T3sum(1:35,9))
  M(15) = M(15) + (-(CI*f(5)) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,74),T3sum(1:35,9))
  M(16) = M(16) + (CI*f(5) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,74),T3sum(1:35,9))
  M(19) = M(19) + (CI*f(5) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,74),T3sum(1:35,9))
  M(20) = M(20) + (-(CI*f(5)) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,74),T3sum(1:35,9))
  M(5) = M(5) + (CI*f(5) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,75),T3sum(1:35,9))
  M(8) = M(8) + (-(CI*f(5)) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,75),T3sum(1:35,9))
  M(11) = M(11) + (CI*f(5) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,75),T3sum(1:35,9))
  M(14) = M(14) + (-(CI*f(5)) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,75),T3sum(1:35,9))
  M(15) = M(15) + (CI*f(5) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,75),T3sum(1:35,9))
  M(16) = M(16) + (-(CI*f(5)) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,75),T3sum(1:35,9))
  M(17) = M(17) + (CI*f(5) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,75),T3sum(1:35,9))
  M(19) = M(19) + (-(CI*f(5)) * den(290)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,75),T3sum(1:35,9))
  M(10) = M(10) + (-f(6) * den(43)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,25),T4sum(1:70,37))
  M(11) = M(11) + (f(6) * den(43)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,25),T4sum(1:70,37))
  M(17) = M(17) + (f(6) * den(43)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,25),T4sum(1:70,37))
  M(20) = M(20) + (-f(6) * den(43)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,25),T4sum(1:70,37))
  M(10) = M(10) + (f(6) * den(43)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,26),T4sum(1:70,37))
  M(16) = M(16) + (-f(6) * den(43)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,26),T4sum(1:70,37))
  M(19) = M(19) + (-f(6) * den(43)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,26),T4sum(1:70,37))
  M(20) = M(20) + (f(6) * den(43)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,26),T4sum(1:70,37))
  M(11) = M(11) + (-f(6) * den(43)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,27),T4sum(1:70,37))
  M(16) = M(16) + (f(6) * den(43)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,27),T4sum(1:70,37))
  M(17) = M(17) + (-f(6) * den(43)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,27),T4sum(1:70,37))
  M(19) = M(19) + (f(6) * den(43)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,27),T4sum(1:70,37))
  M(6) = M(6) + (-f(6) * den(43)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,73),T4sum(1:70,37))
  M(8) = M(8) + (f(6) * den(43)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,73),T4sum(1:70,37))
  M(9) = M(9) + (-f(6) * den(43)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,73),T4sum(1:70,37))
  M(14) = M(14) + (f(6) * den(43)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,73),T4sum(1:70,37))
  M(5) = M(5) + (-f(6) * den(43)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,74),T4sum(1:70,37))
  M(6) = M(6) + (f(6) * den(43)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,74),T4sum(1:70,37))
  M(9) = M(9) + (f(6) * den(43)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,74),T4sum(1:70,37))
  M(15) = M(15) + (-f(6) * den(43)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,74),T4sum(1:70,37))
  M(5) = M(5) + (f(6) * den(43)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,75),T4sum(1:70,37))
  M(8) = M(8) + (-f(6) * den(43)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,75),T4sum(1:70,37))
  M(14) = M(14) + (-f(6) * den(43)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,75),T4sum(1:70,37))
  M(15) = M(15) + (f(6) * den(43)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,75),T4sum(1:70,37))
  M(6) = M(6) + (-f(6) * den(43)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,28),T4sum(1:70,39))
  M(8) = M(8) + (f(6) * den(43)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,28),T4sum(1:70,39))
  M(9) = M(9) + (-f(6) * den(43)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,28),T4sum(1:70,39))
  M(14) = M(14) + (f(6) * den(43)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,28),T4sum(1:70,39))
  M(5) = M(5) + (-f(6) * den(43)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,29),T4sum(1:70,39))
  M(6) = M(6) + (f(6) * den(43)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,29),T4sum(1:70,39))
  M(9) = M(9) + (f(6) * den(43)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,29),T4sum(1:70,39))
  M(15) = M(15) + (-f(6) * den(43)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,29),T4sum(1:70,39))
  M(5) = M(5) + (f(6) * den(43)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,30),T4sum(1:70,39))
  M(8) = M(8) + (-f(6) * den(43)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,30),T4sum(1:70,39))
  M(14) = M(14) + (-f(6) * den(43)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,30),T4sum(1:70,39))
  M(15) = M(15) + (f(6) * den(43)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,30),T4sum(1:70,39))
  M(10) = M(10) + (-f(6) * den(43)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,76),T4sum(1:70,39))
  M(11) = M(11) + (f(6) * den(43)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,76),T4sum(1:70,39))
  M(17) = M(17) + (f(6) * den(43)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,76),T4sum(1:70,39))
  M(20) = M(20) + (-f(6) * den(43)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,76),T4sum(1:70,39))
  M(10) = M(10) + (f(6) * den(43)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,77),T4sum(1:70,39))
  M(16) = M(16) + (-f(6) * den(43)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,77),T4sum(1:70,39))
  M(19) = M(19) + (-f(6) * den(43)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,77),T4sum(1:70,39))
  M(20) = M(20) + (f(6) * den(43)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,77),T4sum(1:70,39))
  M(11) = M(11) + (-f(6) * den(43)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,78),T4sum(1:70,39))
  M(16) = M(16) + (f(6) * den(43)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,78),T4sum(1:70,39))
  M(17) = M(17) + (-f(6) * den(43)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,78),T4sum(1:70,39))
  M(19) = M(19) + (f(6) * den(43)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,78),T4sum(1:70,39))
  M(4) = M(4) + (CI*f(5) * den(317)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,31),T3sum(1:35,9))
  M(6) = M(6) + (-(CI*f(5)) * den(317)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,31),T3sum(1:35,9))
  M(7) = M(7) + (-(CI*f(5)) * den(317)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,31),T3sum(1:35,9))
  M(8) = M(8) + (CI*f(5) * den(317)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,31),T3sum(1:35,9))
  M(10) = M(10) + (CI*f(5) * den(317)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,31),T3sum(1:35,9))
  M(12) = M(12) + (-(CI*f(5)) * den(317)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,31),T3sum(1:35,9))
  M(17) = M(17) + (-(CI*f(5)) * den(317)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,31),T3sum(1:35,9))
  M(23) = M(23) + (CI*f(5) * den(317)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,31),T3sum(1:35,9))
  M(4) = M(4) + (CI*f(5) * den(317)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,76),T3sum(1:35,9))
  M(6) = M(6) + (-(CI*f(5)) * den(317)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,76),T3sum(1:35,9))
  M(7) = M(7) + (-(CI*f(5)) * den(317)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,76),T3sum(1:35,9))
  M(8) = M(8) + (CI*f(5) * den(317)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,76),T3sum(1:35,9))
  M(10) = M(10) + (CI*f(5) * den(317)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,76),T3sum(1:35,9))
  M(12) = M(12) + (-(CI*f(5)) * den(317)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,76),T3sum(1:35,9))
  M(17) = M(17) + (-(CI*f(5)) * den(317)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,76),T3sum(1:35,9))
  M(23) = M(23) + (CI*f(5) * den(317)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,76),T3sum(1:35,9))
  M(4) = M(4) + (f(6) * den(316)) * TI2_call(4,momenta_41,masses2_4,G4tensor(:,34),T4sum(1:70,91))
  M(6) = M(6) + (-f(6) * den(316)) * TI2_call(4,momenta_41,masses2_4,G4tensor(:,34),T4sum(1:70,91))
  M(7) = M(7) + (-f(6) * den(316)) * TI2_call(4,momenta_41,masses2_4,G4tensor(:,34),T4sum(1:70,91))
  M(8) = M(8) + (f(6) * den(316)) * TI2_call(4,momenta_41,masses2_4,G4tensor(:,34),T4sum(1:70,91))
  M(10) = M(10) + (-f(6) * den(316)) * TI2_call(4,momenta_41,masses2_4,G4tensor(:,82),T4sum(1:70,91))
  M(12) = M(12) + (f(6) * den(316)) * TI2_call(4,momenta_41,masses2_4,G4tensor(:,82),T4sum(1:70,91))
  M(17) = M(17) + (f(6) * den(316)) * TI2_call(4,momenta_41,masses2_4,G4tensor(:,82),T4sum(1:70,91))
  M(23) = M(23) + (-f(6) * den(316)) * TI2_call(4,momenta_41,masses2_4,G4tensor(:,82),T4sum(1:70,91))
  M(10) = M(10) + (-f(6) * den(316)) * TI2_call(4,momenta_32,masses2_4,G4tensor(:,35),T4sum(1:70,93))
  M(12) = M(12) + (f(6) * den(316)) * TI2_call(4,momenta_32,masses2_4,G4tensor(:,35),T4sum(1:70,93))
  M(17) = M(17) + (f(6) * den(316)) * TI2_call(4,momenta_32,masses2_4,G4tensor(:,35),T4sum(1:70,93))
  M(23) = M(23) + (-f(6) * den(316)) * TI2_call(4,momenta_32,masses2_4,G4tensor(:,35),T4sum(1:70,93))
  M(4) = M(4) + (f(6) * den(316)) * TI2_call(4,momenta_32,masses2_4,G4tensor(:,83),T4sum(1:70,93))
  M(6) = M(6) + (-f(6) * den(316)) * TI2_call(4,momenta_32,masses2_4,G4tensor(:,83),T4sum(1:70,93))
  M(7) = M(7) + (-f(6) * den(316)) * TI2_call(4,momenta_32,masses2_4,G4tensor(:,83),T4sum(1:70,93))
  M(8) = M(8) + (f(6) * den(316)) * TI2_call(4,momenta_32,masses2_4,G4tensor(:,83),T4sum(1:70,93))
  M(6) = M(6) + (-(CI*f(5)) * den(321)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,32),T3sum(1:35,9))
  M(8) = M(8) + (CI*f(5) * den(321)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,32),T3sum(1:35,9))
  M(9) = M(9) + (-(CI*f(5)) * den(321)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,32),T3sum(1:35,9))
  M(10) = M(10) + (CI*f(5) * den(321)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,32),T3sum(1:35,9))
  M(11) = M(11) + (-(CI*f(5)) * den(321)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,32),T3sum(1:35,9))
  M(14) = M(14) + (CI*f(5) * den(321)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,32),T3sum(1:35,9))
  M(17) = M(17) + (-(CI*f(5)) * den(321)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,32),T3sum(1:35,9))
  M(20) = M(20) + (CI*f(5) * den(321)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,32),T3sum(1:35,9))
  M(6) = M(6) + (-(CI*f(5)) * den(321)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,77),T3sum(1:35,9))
  M(8) = M(8) + (CI*f(5) * den(321)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,77),T3sum(1:35,9))
  M(9) = M(9) + (-(CI*f(5)) * den(321)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,77),T3sum(1:35,9))
  M(10) = M(10) + (CI*f(5) * den(321)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,77),T3sum(1:35,9))
  M(11) = M(11) + (-(CI*f(5)) * den(321)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,77),T3sum(1:35,9))
  M(14) = M(14) + (CI*f(5) * den(321)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,77),T3sum(1:35,9))
  M(17) = M(17) + (-(CI*f(5)) * den(321)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,77),T3sum(1:35,9))
  M(20) = M(20) + (CI*f(5) * den(321)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,77),T3sum(1:35,9))
  M(10) = M(10) + (-f(6) * den(119)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,36),T4sum(1:70,37))
  M(11) = M(11) + (f(6) * den(119)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,36),T4sum(1:70,37))
  M(17) = M(17) + (f(6) * den(119)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,36),T4sum(1:70,37))
  M(20) = M(20) + (-f(6) * den(119)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,36),T4sum(1:70,37))
  M(6) = M(6) + (-f(6) * den(119)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,84),T4sum(1:70,37))
  M(8) = M(8) + (f(6) * den(119)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,84),T4sum(1:70,37))
  M(9) = M(9) + (-f(6) * den(119)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,84),T4sum(1:70,37))
  M(14) = M(14) + (f(6) * den(119)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,84),T4sum(1:70,37))
  M(6) = M(6) + (-f(6) * den(119)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,31),T4sum(1:70,39))
  M(8) = M(8) + (f(6) * den(119)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,31),T4sum(1:70,39))
  M(9) = M(9) + (-f(6) * den(119)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,31),T4sum(1:70,39))
  M(14) = M(14) + (f(6) * den(119)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,31),T4sum(1:70,39))
  M(10) = M(10) + (-f(6) * den(119)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,79),T4sum(1:70,39))
  M(11) = M(11) + (f(6) * den(119)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,79),T4sum(1:70,39))
  M(17) = M(17) + (f(6) * den(119)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,79),T4sum(1:70,39))
  M(20) = M(20) + (-f(6) * den(119)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,79),T4sum(1:70,39))
  M(4) = M(4) + (CI*f(5) * den(323)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,33),T3sum(1:35,9))
  M(7) = M(7) + (-(CI*f(5)) * den(323)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,33),T3sum(1:35,9))
  M(9) = M(9) + (CI*f(5) * den(323)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,33),T3sum(1:35,9))
  M(11) = M(11) + (CI*f(5) * den(323)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,33),T3sum(1:35,9))
  M(12) = M(12) + (-(CI*f(5)) * den(323)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,33),T3sum(1:35,9))
  M(14) = M(14) + (-(CI*f(5)) * den(323)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,33),T3sum(1:35,9))
  M(20) = M(20) + (-(CI*f(5)) * den(323)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,33),T3sum(1:35,9))
  M(23) = M(23) + (CI*f(5) * den(323)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,33),T3sum(1:35,9))
  M(4) = M(4) + (CI*f(5) * den(323)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,78),T3sum(1:35,9))
  M(7) = M(7) + (-(CI*f(5)) * den(323)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,78),T3sum(1:35,9))
  M(9) = M(9) + (CI*f(5) * den(323)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,78),T3sum(1:35,9))
  M(11) = M(11) + (CI*f(5) * den(323)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,78),T3sum(1:35,9))
  M(12) = M(12) + (-(CI*f(5)) * den(323)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,78),T3sum(1:35,9))
  M(14) = M(14) + (-(CI*f(5)) * den(323)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,78),T3sum(1:35,9))
  M(20) = M(20) + (-(CI*f(5)) * den(323)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,78),T3sum(1:35,9))
  M(23) = M(23) + (CI*f(5) * den(323)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,78),T3sum(1:35,9))
  M(9) = M(9) + (f(6) * den(114)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,37),T4sum(1:70,31))
  M(12) = M(12) + (-f(6) * den(114)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,37),T4sum(1:70,31))
  M(14) = M(14) + (-f(6) * den(114)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,37),T4sum(1:70,31))
  M(23) = M(23) + (f(6) * den(114)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,37),T4sum(1:70,31))
  M(4) = M(4) + (-f(6) * den(114)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,85),T4sum(1:70,31))
  M(7) = M(7) + (f(6) * den(114)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,85),T4sum(1:70,31))
  M(11) = M(11) + (-f(6) * den(114)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,85),T4sum(1:70,31))
  M(20) = M(20) + (f(6) * den(114)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,85),T4sum(1:70,31))
  M(4) = M(4) + (-f(6) * den(114)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,22),T4sum(1:70,33))
  M(7) = M(7) + (f(6) * den(114)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,22),T4sum(1:70,33))
  M(11) = M(11) + (-f(6) * den(114)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,22),T4sum(1:70,33))
  M(20) = M(20) + (f(6) * den(114)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,22),T4sum(1:70,33))
  M(9) = M(9) + (f(6) * den(114)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,70),T4sum(1:70,33))
  M(12) = M(12) + (-f(6) * den(114)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,70),T4sum(1:70,33))
  M(14) = M(14) + (-f(6) * den(114)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,70),T4sum(1:70,33))
  M(23) = M(23) + (f(6) * den(114)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,70),T4sum(1:70,33))
  M(9) = M(9) + (CI*f(5) * den(10)) * TI2_call(5,momenta_150,masses2_6,G5tensor(:,17),T5sum(1:126,25))
  M(14) = M(14) + (-(CI*f(5)) * den(10)) * TI2_call(5,momenta_150,masses2_6,G5tensor(:,17),T5sum(1:126,25))
  M(11) = M(11) + (CI*f(5) * den(10)) * TI2_call(5,momenta_150,masses2_6,G5tensor(:,47),T5sum(1:126,25))
  M(20) = M(20) + (-(CI*f(5)) * den(10)) * TI2_call(5,momenta_150,masses2_6,G5tensor(:,47),T5sum(1:126,25))
  M(12) = M(12) + (CI*f(5) * den(10)) * TI2_call(5,momenta_139,masses2_6,G5tensor(:,23),T5sum(1:126,27))
  M(23) = M(23) + (-(CI*f(5)) * den(10)) * TI2_call(5,momenta_139,masses2_6,G5tensor(:,23),T5sum(1:126,27))
  M(4) = M(4) + (-(CI*f(5)) * den(10)) * TI2_call(5,momenta_139,masses2_6,G5tensor(:,53),T5sum(1:126,27))
  M(7) = M(7) + (CI*f(5) * den(10)) * TI2_call(5,momenta_139,masses2_6,G5tensor(:,53),T5sum(1:126,27))
  M(11) = M(11) + (CI*f(5) * den(10)) * TI2_call(5,momenta_142,masses2_6,G5tensor(:,12),T5sum(1:126,29))
  M(20) = M(20) + (-(CI*f(5)) * den(10)) * TI2_call(5,momenta_142,masses2_6,G5tensor(:,12),T5sum(1:126,29))
  M(9) = M(9) + (CI*f(5) * den(10)) * TI2_call(5,momenta_142,masses2_6,G5tensor(:,42),T5sum(1:126,29))
  M(14) = M(14) + (-(CI*f(5)) * den(10)) * TI2_call(5,momenta_142,masses2_6,G5tensor(:,42),T5sum(1:126,29))
  M(10) = M(10) + (CI*f(5) * den(10)) * TI2_call(5,momenta_138,masses2_6,G5tensor(:,24),T5sum(1:126,31))
  M(17) = M(17) + (-(CI*f(5)) * den(10)) * TI2_call(5,momenta_138,masses2_6,G5tensor(:,24),T5sum(1:126,31))
  M(6) = M(6) + (-(CI*f(5)) * den(10)) * TI2_call(5,momenta_138,masses2_6,G5tensor(:,54),T5sum(1:126,31))
  M(8) = M(8) + (CI*f(5) * den(10)) * TI2_call(5,momenta_138,masses2_6,G5tensor(:,54),T5sum(1:126,31))
  M(4) = M(4) + (-(CI*f(5)) * den(10)) * TI2_call(5,momenta_143,masses2_6,G5tensor(:,13),T5sum(1:126,33))
  M(7) = M(7) + (CI*f(5) * den(10)) * TI2_call(5,momenta_143,masses2_6,G5tensor(:,13),T5sum(1:126,33))
  M(12) = M(12) + (CI*f(5) * den(10)) * TI2_call(5,momenta_143,masses2_6,G5tensor(:,43),T5sum(1:126,33))
  M(23) = M(23) + (-(CI*f(5)) * den(10)) * TI2_call(5,momenta_143,masses2_6,G5tensor(:,43),T5sum(1:126,33))
  M(6) = M(6) + (-(CI*f(5)) * den(10)) * TI2_call(5,momenta_151,masses2_6,G5tensor(:,18),T5sum(1:126,35))
  M(8) = M(8) + (CI*f(5) * den(10)) * TI2_call(5,momenta_151,masses2_6,G5tensor(:,18),T5sum(1:126,35))
  M(10) = M(10) + (CI*f(5) * den(10)) * TI2_call(5,momenta_151,masses2_6,G5tensor(:,48),T5sum(1:126,35))
  M(17) = M(17) + (-(CI*f(5)) * den(10)) * TI2_call(5,momenta_151,masses2_6,G5tensor(:,48),T5sum(1:126,35))
  M(2) = M(2) + (CI*f(5) * den(339)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,34),T3sum(1:35,9))
  M(5) = M(5) + (-(CI*f(5)) * den(339)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,34),T3sum(1:35,9))
  M(11) = M(11) + (-(CI*f(5)) * den(339)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,34),T3sum(1:35,9))
  M(13) = M(13) + (-(CI*f(5)) * den(339)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,34),T3sum(1:35,9))
  M(14) = M(14) + (CI*f(5) * den(339)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,34),T3sum(1:35,9))
  M(16) = M(16) + (CI*f(5) * den(339)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,34),T3sum(1:35,9))
  M(18) = M(18) + (-(CI*f(5)) * den(339)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,34),T3sum(1:35,9))
  M(21) = M(21) + (CI*f(5) * den(339)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,34),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(5) * den(339)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,79),T3sum(1:35,9))
  M(5) = M(5) + (-(CI*f(5)) * den(339)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,79),T3sum(1:35,9))
  M(11) = M(11) + (-(CI*f(5)) * den(339)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,79),T3sum(1:35,9))
  M(13) = M(13) + (-(CI*f(5)) * den(339)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,79),T3sum(1:35,9))
  M(14) = M(14) + (CI*f(5) * den(339)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,79),T3sum(1:35,9))
  M(16) = M(16) + (CI*f(5) * den(339)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,79),T3sum(1:35,9))
  M(18) = M(18) + (-(CI*f(5)) * den(339)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,79),T3sum(1:35,9))
  M(21) = M(21) + (CI*f(5) * den(339)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,79),T3sum(1:35,9))
  M(2) = M(2) + (f(6) * den(338)) * TI2_call(4,momenta_39,masses2_4,G4tensor(:,38),T4sum(1:70,121))
  M(5) = M(5) + (-f(6) * den(338)) * TI2_call(4,momenta_39,masses2_4,G4tensor(:,38),T4sum(1:70,121))
  M(13) = M(13) + (-f(6) * den(338)) * TI2_call(4,momenta_39,masses2_4,G4tensor(:,38),T4sum(1:70,121))
  M(14) = M(14) + (f(6) * den(338)) * TI2_call(4,momenta_39,masses2_4,G4tensor(:,38),T4sum(1:70,121))
  M(11) = M(11) + (f(6) * den(338)) * TI2_call(4,momenta_39,masses2_4,G4tensor(:,86),T4sum(1:70,121))
  M(16) = M(16) + (-f(6) * den(338)) * TI2_call(4,momenta_39,masses2_4,G4tensor(:,86),T4sum(1:70,121))
  M(18) = M(18) + (f(6) * den(338)) * TI2_call(4,momenta_39,masses2_4,G4tensor(:,86),T4sum(1:70,121))
  M(21) = M(21) + (-f(6) * den(338)) * TI2_call(4,momenta_39,masses2_4,G4tensor(:,86),T4sum(1:70,121))
  M(11) = M(11) + (f(6) * den(338)) * TI2_call(4,momenta_34,masses2_4,G4tensor(:,39),T4sum(1:70,123))
  M(16) = M(16) + (-f(6) * den(338)) * TI2_call(4,momenta_34,masses2_4,G4tensor(:,39),T4sum(1:70,123))
  M(18) = M(18) + (f(6) * den(338)) * TI2_call(4,momenta_34,masses2_4,G4tensor(:,39),T4sum(1:70,123))
  M(21) = M(21) + (-f(6) * den(338)) * TI2_call(4,momenta_34,masses2_4,G4tensor(:,39),T4sum(1:70,123))
  M(2) = M(2) + (f(6) * den(338)) * TI2_call(4,momenta_34,masses2_4,G4tensor(:,87),T4sum(1:70,123))
  M(5) = M(5) + (-f(6) * den(338)) * TI2_call(4,momenta_34,masses2_4,G4tensor(:,87),T4sum(1:70,123))
  M(13) = M(13) + (-f(6) * den(338)) * TI2_call(4,momenta_34,masses2_4,G4tensor(:,87),T4sum(1:70,123))
  M(14) = M(14) + (f(6) * den(338)) * TI2_call(4,momenta_34,masses2_4,G4tensor(:,87),T4sum(1:70,123))
  M(5) = M(5) + (CI*f(5) * den(343)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,35),T3sum(1:35,9))
  M(8) = M(8) + (-(CI*f(5)) * den(343)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,35),T3sum(1:35,9))
  M(11) = M(11) + (CI*f(5) * den(343)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,35),T3sum(1:35,9))
  M(14) = M(14) + (-(CI*f(5)) * den(343)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,35),T3sum(1:35,9))
  M(15) = M(15) + (CI*f(5) * den(343)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,35),T3sum(1:35,9))
  M(16) = M(16) + (-(CI*f(5)) * den(343)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,35),T3sum(1:35,9))
  M(17) = M(17) + (CI*f(5) * den(343)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,35),T3sum(1:35,9))
  M(19) = M(19) + (-(CI*f(5)) * den(343)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,35),T3sum(1:35,9))
  M(5) = M(5) + (CI*f(5) * den(343)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,80),T3sum(1:35,9))
  M(8) = M(8) + (-(CI*f(5)) * den(343)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,80),T3sum(1:35,9))
  M(11) = M(11) + (CI*f(5) * den(343)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,80),T3sum(1:35,9))
  M(14) = M(14) + (-(CI*f(5)) * den(343)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,80),T3sum(1:35,9))
  M(15) = M(15) + (CI*f(5) * den(343)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,80),T3sum(1:35,9))
  M(16) = M(16) + (-(CI*f(5)) * den(343)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,80),T3sum(1:35,9))
  M(17) = M(17) + (CI*f(5) * den(343)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,80),T3sum(1:35,9))
  M(19) = M(19) + (-(CI*f(5)) * den(343)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,80),T3sum(1:35,9))
  M(11) = M(11) + (-f(6) * den(158)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,40),T4sum(1:70,37))
  M(16) = M(16) + (f(6) * den(158)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,40),T4sum(1:70,37))
  M(17) = M(17) + (-f(6) * den(158)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,40),T4sum(1:70,37))
  M(19) = M(19) + (f(6) * den(158)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,40),T4sum(1:70,37))
  M(5) = M(5) + (f(6) * den(158)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,88),T4sum(1:70,37))
  M(8) = M(8) + (-f(6) * den(158)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,88),T4sum(1:70,37))
  M(14) = M(14) + (-f(6) * den(158)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,88),T4sum(1:70,37))
  M(15) = M(15) + (f(6) * den(158)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,88),T4sum(1:70,37))
  M(5) = M(5) + (f(6) * den(158)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,32),T4sum(1:70,39))
  M(8) = M(8) + (-f(6) * den(158)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,32),T4sum(1:70,39))
  M(14) = M(14) + (-f(6) * den(158)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,32),T4sum(1:70,39))
  M(15) = M(15) + (f(6) * den(158)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,32),T4sum(1:70,39))
  M(11) = M(11) + (-f(6) * den(158)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,80),T4sum(1:70,39))
  M(16) = M(16) + (f(6) * den(158)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,80),T4sum(1:70,39))
  M(17) = M(17) + (-f(6) * den(158)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,80),T4sum(1:70,39))
  M(19) = M(19) + (f(6) * den(158)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,80),T4sum(1:70,39))
  M(2) = M(2) + (CI*f(5) * den(345)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,36),T3sum(1:35,9))
  M(8) = M(8) + (-(CI*f(5)) * den(345)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,36),T3sum(1:35,9))
  M(13) = M(13) + (-(CI*f(5)) * den(345)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,36),T3sum(1:35,9))
  M(15) = M(15) + (CI*f(5) * den(345)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,36),T3sum(1:35,9))
  M(17) = M(17) + (CI*f(5) * den(345)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,36),T3sum(1:35,9))
  M(18) = M(18) + (-(CI*f(5)) * den(345)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,36),T3sum(1:35,9))
  M(19) = M(19) + (-(CI*f(5)) * den(345)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,36),T3sum(1:35,9))
  M(21) = M(21) + (CI*f(5) * den(345)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,36),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(5) * den(345)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,81),T3sum(1:35,9))
  M(8) = M(8) + (-(CI*f(5)) * den(345)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,81),T3sum(1:35,9))
  M(13) = M(13) + (-(CI*f(5)) * den(345)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,81),T3sum(1:35,9))
  M(15) = M(15) + (CI*f(5) * den(345)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,81),T3sum(1:35,9))
  M(17) = M(17) + (CI*f(5) * den(345)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,81),T3sum(1:35,9))
  M(18) = M(18) + (-(CI*f(5)) * den(345)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,81),T3sum(1:35,9))
  M(19) = M(19) + (-(CI*f(5)) * den(345)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,81),T3sum(1:35,9))
  M(21) = M(21) + (CI*f(5) * den(345)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,81),T3sum(1:35,9))
  M(8) = M(8) + (-f(6) * den(136)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,41),T4sum(1:70,25))
  M(15) = M(15) + (f(6) * den(136)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,41),T4sum(1:70,25))
  M(18) = M(18) + (-f(6) * den(136)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,41),T4sum(1:70,25))
  M(21) = M(21) + (f(6) * den(136)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,41),T4sum(1:70,25))
  M(2) = M(2) + (-f(6) * den(136)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,89),T4sum(1:70,25))
  M(13) = M(13) + (f(6) * den(136)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,89),T4sum(1:70,25))
  M(17) = M(17) + (-f(6) * den(136)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,89),T4sum(1:70,25))
  M(19) = M(19) + (f(6) * den(136)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,89),T4sum(1:70,25))
  M(2) = M(2) + (-f(6) * den(136)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,13),T4sum(1:70,27))
  M(13) = M(13) + (f(6) * den(136)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,13),T4sum(1:70,27))
  M(17) = M(17) + (-f(6) * den(136)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,13),T4sum(1:70,27))
  M(19) = M(19) + (f(6) * den(136)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,13),T4sum(1:70,27))
  M(8) = M(8) + (-f(6) * den(136)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,61),T4sum(1:70,27))
  M(15) = M(15) + (f(6) * den(136)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,61),T4sum(1:70,27))
  M(18) = M(18) + (-f(6) * den(136)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,61),T4sum(1:70,27))
  M(21) = M(21) + (f(6) * den(136)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,61),T4sum(1:70,27))
  M(8) = M(8) + (-(CI*f(5)) * den(15)) * TI2_call(5,momenta_152,masses2_6,G5tensor(:,19),T5sum(1:126,73))
  M(15) = M(15) + (CI*f(5) * den(15)) * TI2_call(5,momenta_152,masses2_6,G5tensor(:,19),T5sum(1:126,73))
  M(17) = M(17) + (CI*f(5) * den(15)) * TI2_call(5,momenta_152,masses2_6,G5tensor(:,49),T5sum(1:126,73))
  M(19) = M(19) + (-(CI*f(5)) * den(15)) * TI2_call(5,momenta_152,masses2_6,G5tensor(:,49),T5sum(1:126,73))
  M(18) = M(18) + (CI*f(5) * den(15)) * TI2_call(5,momenta_146,masses2_6,G5tensor(:,26),T5sum(1:126,75))
  M(21) = M(21) + (-(CI*f(5)) * den(15)) * TI2_call(5,momenta_146,masses2_6,G5tensor(:,26),T5sum(1:126,75))
  M(2) = M(2) + (-(CI*f(5)) * den(15)) * TI2_call(5,momenta_146,masses2_6,G5tensor(:,56),T5sum(1:126,75))
  M(13) = M(13) + (CI*f(5) * den(15)) * TI2_call(5,momenta_146,masses2_6,G5tensor(:,56),T5sum(1:126,75))
  M(17) = M(17) + (CI*f(5) * den(15)) * TI2_call(5,momenta_135,masses2_6,G5tensor(:,7),T5sum(1:126,77))
  M(19) = M(19) + (-(CI*f(5)) * den(15)) * TI2_call(5,momenta_135,masses2_6,G5tensor(:,7),T5sum(1:126,77))
  M(8) = M(8) + (-(CI*f(5)) * den(15)) * TI2_call(5,momenta_135,masses2_6,G5tensor(:,37),T5sum(1:126,77))
  M(15) = M(15) + (CI*f(5) * den(15)) * TI2_call(5,momenta_135,masses2_6,G5tensor(:,37),T5sum(1:126,77))
  M(11) = M(11) + (-(CI*f(5)) * den(15)) * TI2_call(5,momenta_145,masses2_6,G5tensor(:,27),T5sum(1:126,79))
  M(16) = M(16) + (CI*f(5) * den(15)) * TI2_call(5,momenta_145,masses2_6,G5tensor(:,27),T5sum(1:126,79))
  M(5) = M(5) + (-(CI*f(5)) * den(15)) * TI2_call(5,momenta_145,masses2_6,G5tensor(:,57),T5sum(1:126,79))
  M(14) = M(14) + (CI*f(5) * den(15)) * TI2_call(5,momenta_145,masses2_6,G5tensor(:,57),T5sum(1:126,79))
  M(2) = M(2) + (-(CI*f(5)) * den(15)) * TI2_call(5,momenta_136,masses2_6,G5tensor(:,8),T5sum(1:126,81))
  M(13) = M(13) + (CI*f(5) * den(15)) * TI2_call(5,momenta_136,masses2_6,G5tensor(:,8),T5sum(1:126,81))
  M(18) = M(18) + (CI*f(5) * den(15)) * TI2_call(5,momenta_136,masses2_6,G5tensor(:,38),T5sum(1:126,81))
  M(21) = M(21) + (-(CI*f(5)) * den(15)) * TI2_call(5,momenta_136,masses2_6,G5tensor(:,38),T5sum(1:126,81))
  M(5) = M(5) + (-(CI*f(5)) * den(15)) * TI2_call(5,momenta_149,masses2_6,G5tensor(:,20),T5sum(1:126,83))
  M(14) = M(14) + (CI*f(5) * den(15)) * TI2_call(5,momenta_149,masses2_6,G5tensor(:,20),T5sum(1:126,83))
  M(11) = M(11) + (-(CI*f(5)) * den(15)) * TI2_call(5,momenta_149,masses2_6,G5tensor(:,50),T5sum(1:126,83))
  M(16) = M(16) + (CI*f(5) * den(15)) * TI2_call(5,momenta_149,masses2_6,G5tensor(:,50),T5sum(1:126,83))
  M(1) = M(1) + (-(CI*f(5)) * den(357)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,37),T3sum(1:35,9))
  M(3) = M(3) + (CI*f(5) * den(357)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,37),T3sum(1:35,9))
  M(9) = M(9) + (CI*f(5) * den(357)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,37),T3sum(1:35,9))
  M(15) = M(15) + (-(CI*f(5)) * den(357)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,37),T3sum(1:35,9))
  M(19) = M(19) + (CI*f(5) * den(357)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,37),T3sum(1:35,9))
  M(20) = M(20) + (-(CI*f(5)) * den(357)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,37),T3sum(1:35,9))
  M(22) = M(22) + (-(CI*f(5)) * den(357)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,37),T3sum(1:35,9))
  M(24) = M(24) + (CI*f(5) * den(357)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,37),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(357)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,82),T3sum(1:35,9))
  M(3) = M(3) + (CI*f(5) * den(357)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,82),T3sum(1:35,9))
  M(9) = M(9) + (CI*f(5) * den(357)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,82),T3sum(1:35,9))
  M(15) = M(15) + (-(CI*f(5)) * den(357)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,82),T3sum(1:35,9))
  M(19) = M(19) + (CI*f(5) * den(357)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,82),T3sum(1:35,9))
  M(20) = M(20) + (-(CI*f(5)) * den(357)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,82),T3sum(1:35,9))
  M(22) = M(22) + (-(CI*f(5)) * den(357)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,82),T3sum(1:35,9))
  M(24) = M(24) + (CI*f(5) * den(357)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,82),T3sum(1:35,9))
  M(1) = M(1) + (f(6) * den(356)) * TI2_call(4,momenta_35,masses2_4,G4tensor(:,42),T4sum(1:70,139))
  M(3) = M(3) + (-f(6) * den(356)) * TI2_call(4,momenta_35,masses2_4,G4tensor(:,42),T4sum(1:70,139))
  M(19) = M(19) + (-f(6) * den(356)) * TI2_call(4,momenta_35,masses2_4,G4tensor(:,42),T4sum(1:70,139))
  M(20) = M(20) + (f(6) * den(356)) * TI2_call(4,momenta_35,masses2_4,G4tensor(:,42),T4sum(1:70,139))
  M(9) = M(9) + (f(6) * den(356)) * TI2_call(4,momenta_35,masses2_4,G4tensor(:,90),T4sum(1:70,139))
  M(15) = M(15) + (-f(6) * den(356)) * TI2_call(4,momenta_35,masses2_4,G4tensor(:,90),T4sum(1:70,139))
  M(22) = M(22) + (-f(6) * den(356)) * TI2_call(4,momenta_35,masses2_4,G4tensor(:,90),T4sum(1:70,139))
  M(24) = M(24) + (f(6) * den(356)) * TI2_call(4,momenta_35,masses2_4,G4tensor(:,90),T4sum(1:70,139))
  M(9) = M(9) + (f(6) * den(356)) * TI2_call(4,momenta_38,masses2_4,G4tensor(:,43),T4sum(1:70,141))
  M(15) = M(15) + (-f(6) * den(356)) * TI2_call(4,momenta_38,masses2_4,G4tensor(:,43),T4sum(1:70,141))
  M(22) = M(22) + (-f(6) * den(356)) * TI2_call(4,momenta_38,masses2_4,G4tensor(:,43),T4sum(1:70,141))
  M(24) = M(24) + (f(6) * den(356)) * TI2_call(4,momenta_38,masses2_4,G4tensor(:,43),T4sum(1:70,141))
  M(1) = M(1) + (f(6) * den(356)) * TI2_call(4,momenta_38,masses2_4,G4tensor(:,91),T4sum(1:70,141))
  M(3) = M(3) + (-f(6) * den(356)) * TI2_call(4,momenta_38,masses2_4,G4tensor(:,91),T4sum(1:70,141))
  M(19) = M(19) + (-f(6) * den(356)) * TI2_call(4,momenta_38,masses2_4,G4tensor(:,91),T4sum(1:70,141))
  M(20) = M(20) + (f(6) * den(356)) * TI2_call(4,momenta_38,masses2_4,G4tensor(:,91),T4sum(1:70,141))
  M(5) = M(5) + (CI*f(5) * den(362)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,38),T3sum(1:35,9))
  M(6) = M(6) + (-(CI*f(5)) * den(362)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,38),T3sum(1:35,9))
  M(9) = M(9) + (-(CI*f(5)) * den(362)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,38),T3sum(1:35,9))
  M(10) = M(10) + (CI*f(5) * den(362)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,38),T3sum(1:35,9))
  M(15) = M(15) + (CI*f(5) * den(362)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,38),T3sum(1:35,9))
  M(16) = M(16) + (-(CI*f(5)) * den(362)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,38),T3sum(1:35,9))
  M(19) = M(19) + (-(CI*f(5)) * den(362)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,38),T3sum(1:35,9))
  M(20) = M(20) + (CI*f(5) * den(362)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,38),T3sum(1:35,9))
  M(5) = M(5) + (CI*f(5) * den(362)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,83),T3sum(1:35,9))
  M(6) = M(6) + (-(CI*f(5)) * den(362)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,83),T3sum(1:35,9))
  M(9) = M(9) + (-(CI*f(5)) * den(362)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,83),T3sum(1:35,9))
  M(10) = M(10) + (CI*f(5) * den(362)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,83),T3sum(1:35,9))
  M(15) = M(15) + (CI*f(5) * den(362)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,83),T3sum(1:35,9))
  M(16) = M(16) + (-(CI*f(5)) * den(362)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,83),T3sum(1:35,9))
  M(19) = M(19) + (-(CI*f(5)) * den(362)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,83),T3sum(1:35,9))
  M(20) = M(20) + (CI*f(5) * den(362)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,83),T3sum(1:35,9))
  M(10) = M(10) + (-f(6) * den(180)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,44),T4sum(1:70,37))
  M(16) = M(16) + (f(6) * den(180)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,44),T4sum(1:70,37))
  M(19) = M(19) + (f(6) * den(180)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,44),T4sum(1:70,37))
  M(20) = M(20) + (-f(6) * den(180)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,44),T4sum(1:70,37))
  M(5) = M(5) + (f(6) * den(180)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,92),T4sum(1:70,37))
  M(6) = M(6) + (-f(6) * den(180)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,92),T4sum(1:70,37))
  M(9) = M(9) + (-f(6) * den(180)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,92),T4sum(1:70,37))
  M(15) = M(15) + (f(6) * den(180)) * TI2_call(4,momenta_36,masses2_4,G4tensor(:,92),T4sum(1:70,37))
  M(5) = M(5) + (f(6) * den(180)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,33),T4sum(1:70,39))
  M(6) = M(6) + (-f(6) * den(180)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,33),T4sum(1:70,39))
  M(9) = M(9) + (-f(6) * den(180)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,33),T4sum(1:70,39))
  M(15) = M(15) + (f(6) * den(180)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,33),T4sum(1:70,39))
  M(10) = M(10) + (-f(6) * den(180)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,81),T4sum(1:70,39))
  M(16) = M(16) + (f(6) * den(180)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,81),T4sum(1:70,39))
  M(19) = M(19) + (f(6) * den(180)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,81),T4sum(1:70,39))
  M(20) = M(20) + (-f(6) * den(180)) * TI2_call(4,momenta_37,masses2_4,G4tensor(:,81),T4sum(1:70,39))
  M(1) = M(1) + (-(CI*f(5)) * den(363)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,39),T3sum(1:35,9))
  M(3) = M(3) + (CI*f(5) * den(363)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,39),T3sum(1:35,9))
  M(5) = M(5) + (CI*f(5) * den(363)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,39),T3sum(1:35,9))
  M(6) = M(6) + (-(CI*f(5)) * den(363)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,39),T3sum(1:35,9))
  M(10) = M(10) + (CI*f(5) * den(363)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,39),T3sum(1:35,9))
  M(16) = M(16) + (-(CI*f(5)) * den(363)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,39),T3sum(1:35,9))
  M(22) = M(22) + (-(CI*f(5)) * den(363)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,39),T3sum(1:35,9))
  M(24) = M(24) + (CI*f(5) * den(363)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,39),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(363)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,84),T3sum(1:35,9))
  M(3) = M(3) + (CI*f(5) * den(363)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,84),T3sum(1:35,9))
  M(5) = M(5) + (CI*f(5) * den(363)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,84),T3sum(1:35,9))
  M(6) = M(6) + (-(CI*f(5)) * den(363)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,84),T3sum(1:35,9))
  M(10) = M(10) + (CI*f(5) * den(363)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,84),T3sum(1:35,9))
  M(16) = M(16) + (-(CI*f(5)) * den(363)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,84),T3sum(1:35,9))
  M(22) = M(22) + (-(CI*f(5)) * den(363)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,84),T3sum(1:35,9))
  M(24) = M(24) + (CI*f(5) * den(363)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,84),T3sum(1:35,9))
  M(10) = M(10) + (-f(6) * den(86)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,4),T4sum(1:70,5))
  M(16) = M(16) + (f(6) * den(86)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,4),T4sum(1:70,5))
  M(22) = M(22) + (f(6) * den(86)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,4),T4sum(1:70,5))
  M(24) = M(24) + (-f(6) * den(86)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,4),T4sum(1:70,5))
  M(1) = M(1) + (-f(6) * den(86)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,52),T4sum(1:70,5))
  M(3) = M(3) + (f(6) * den(86)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,52),T4sum(1:70,5))
  M(5) = M(5) + (f(6) * den(86)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,52),T4sum(1:70,5))
  M(6) = M(6) + (-f(6) * den(86)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,52),T4sum(1:70,5))
  M(10) = M(10) + (CI*f(5) * den(51)) * TI2_call(5,momenta_129,masses2_6,G5tensor(:,1),T5sum(1:126,133))
  M(16) = M(16) + (-(CI*f(5)) * den(51)) * TI2_call(5,momenta_129,masses2_6,G5tensor(:,1),T5sum(1:126,133))
  M(5) = M(5) + (CI*f(5) * den(51)) * TI2_call(5,momenta_129,masses2_6,G5tensor(:,31),T5sum(1:126,133))
  M(6) = M(6) + (-(CI*f(5)) * den(51)) * TI2_call(5,momenta_129,masses2_6,G5tensor(:,31),T5sum(1:126,133))
  M(19) = M(19) + (CI*f(5) * den(51)) * TI2_call(5,momenta_147,masses2_6,G5tensor(:,28),T5sum(1:126,135))
  M(20) = M(20) + (-(CI*f(5)) * den(51)) * TI2_call(5,momenta_147,masses2_6,G5tensor(:,28),T5sum(1:126,135))
  M(9) = M(9) + (CI*f(5) * den(51)) * TI2_call(5,momenta_147,masses2_6,G5tensor(:,58),T5sum(1:126,135))
  M(15) = M(15) + (-(CI*f(5)) * den(51)) * TI2_call(5,momenta_147,masses2_6,G5tensor(:,58),T5sum(1:126,135))
  M(22) = M(22) + (CI*f(5) * den(51)) * TI2_call(5,momenta_130,masses2_6,G5tensor(:,2),T5sum(1:126,137))
  M(24) = M(24) + (-(CI*f(5)) * den(51)) * TI2_call(5,momenta_130,masses2_6,G5tensor(:,2),T5sum(1:126,137))
  M(1) = M(1) + (CI*f(5) * den(51)) * TI2_call(5,momenta_130,masses2_6,G5tensor(:,32),T5sum(1:126,137))
  M(3) = M(3) + (-(CI*f(5)) * den(51)) * TI2_call(5,momenta_130,masses2_6,G5tensor(:,32),T5sum(1:126,137))
  M(9) = M(9) + (CI*f(5) * den(51)) * TI2_call(5,momenta_148,masses2_6,G5tensor(:,21),T5sum(1:126,139))
  M(15) = M(15) + (-(CI*f(5)) * den(51)) * TI2_call(5,momenta_148,masses2_6,G5tensor(:,21),T5sum(1:126,139))
  M(19) = M(19) + (CI*f(5) * den(51)) * TI2_call(5,momenta_148,masses2_6,G5tensor(:,51),T5sum(1:126,139))
  M(20) = M(20) + (-(CI*f(5)) * den(51)) * TI2_call(5,momenta_148,masses2_6,G5tensor(:,51),T5sum(1:126,139))
  M(3) = M(3) + (-(CI*f(5)) * den(369)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,40),T3sum(1:35,9))
  M(7) = M(7) + (CI*f(5) * den(369)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,40),T3sum(1:35,9))
  M(9) = M(9) + (-(CI*f(5)) * den(369)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,40),T3sum(1:35,9))
  M(13) = M(13) + (CI*f(5) * den(369)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,40),T3sum(1:35,9))
  M(20) = M(20) + (CI*f(5) * den(369)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,40),T3sum(1:35,9))
  M(21) = M(21) + (-(CI*f(5)) * den(369)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,40),T3sum(1:35,9))
  M(22) = M(22) + (CI*f(5) * den(369)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,40),T3sum(1:35,9))
  M(23) = M(23) + (-(CI*f(5)) * den(369)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,40),T3sum(1:35,9))
  M(3) = M(3) + (-(CI*f(5)) * den(369)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,85),T3sum(1:35,9))
  M(7) = M(7) + (CI*f(5) * den(369)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,85),T3sum(1:35,9))
  M(9) = M(9) + (-(CI*f(5)) * den(369)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,85),T3sum(1:35,9))
  M(13) = M(13) + (CI*f(5) * den(369)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,85),T3sum(1:35,9))
  M(20) = M(20) + (CI*f(5) * den(369)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,85),T3sum(1:35,9))
  M(21) = M(21) + (-(CI*f(5)) * den(369)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,85),T3sum(1:35,9))
  M(22) = M(22) + (CI*f(5) * den(369)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,85),T3sum(1:35,9))
  M(23) = M(23) + (-(CI*f(5)) * den(369)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,85),T3sum(1:35,9))
  M(9) = M(9) + (-f(6) * den(168)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,45),T4sum(1:70,31))
  M(13) = M(13) + (f(6) * den(168)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,45),T4sum(1:70,31))
  M(22) = M(22) + (f(6) * den(168)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,45),T4sum(1:70,31))
  M(23) = M(23) + (-f(6) * den(168)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,45),T4sum(1:70,31))
  M(3) = M(3) + (f(6) * den(168)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,93),T4sum(1:70,31))
  M(7) = M(7) + (-f(6) * den(168)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,93),T4sum(1:70,31))
  M(20) = M(20) + (-f(6) * den(168)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,93),T4sum(1:70,31))
  M(21) = M(21) + (f(6) * den(168)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,93),T4sum(1:70,31))
  M(3) = M(3) + (f(6) * den(168)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,23),T4sum(1:70,33))
  M(7) = M(7) + (-f(6) * den(168)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,23),T4sum(1:70,33))
  M(20) = M(20) + (-f(6) * den(168)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,23),T4sum(1:70,33))
  M(21) = M(21) + (f(6) * den(168)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,23),T4sum(1:70,33))
  M(9) = M(9) + (-f(6) * den(168)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,71),T4sum(1:70,33))
  M(13) = M(13) + (f(6) * den(168)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,71),T4sum(1:70,33))
  M(22) = M(22) + (f(6) * den(168)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,71),T4sum(1:70,33))
  M(23) = M(23) + (-f(6) * den(168)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,71),T4sum(1:70,33))
  M(1) = M(1) + (-(CI*f(5)) * den(371)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,41),T3sum(1:35,9))
  M(7) = M(7) + (CI*f(5) * den(371)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,41),T3sum(1:35,9))
  M(13) = M(13) + (CI*f(5) * den(371)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,41),T3sum(1:35,9))
  M(15) = M(15) + (-(CI*f(5)) * den(371)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,41),T3sum(1:35,9))
  M(19) = M(19) + (CI*f(5) * den(371)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,41),T3sum(1:35,9))
  M(21) = M(21) + (-(CI*f(5)) * den(371)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,41),T3sum(1:35,9))
  M(23) = M(23) + (-(CI*f(5)) * den(371)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,41),T3sum(1:35,9))
  M(24) = M(24) + (CI*f(5) * den(371)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,41),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(371)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,86),T3sum(1:35,9))
  M(7) = M(7) + (CI*f(5) * den(371)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,86),T3sum(1:35,9))
  M(13) = M(13) + (CI*f(5) * den(371)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,86),T3sum(1:35,9))
  M(15) = M(15) + (-(CI*f(5)) * den(371)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,86),T3sum(1:35,9))
  M(19) = M(19) + (CI*f(5) * den(371)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,86),T3sum(1:35,9))
  M(21) = M(21) + (-(CI*f(5)) * den(371)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,86),T3sum(1:35,9))
  M(23) = M(23) + (-(CI*f(5)) * den(371)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,86),T3sum(1:35,9))
  M(24) = M(24) + (CI*f(5) * den(371)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,86),T3sum(1:35,9))
  M(7) = M(7) + (f(6) * den(141)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,46),T4sum(1:70,25))
  M(15) = M(15) + (-f(6) * den(141)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,46),T4sum(1:70,25))
  M(21) = M(21) + (-f(6) * den(141)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,46),T4sum(1:70,25))
  M(24) = M(24) + (f(6) * den(141)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,46),T4sum(1:70,25))
  M(1) = M(1) + (f(6) * den(141)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,94),T4sum(1:70,25))
  M(13) = M(13) + (-f(6) * den(141)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,94),T4sum(1:70,25))
  M(19) = M(19) + (-f(6) * den(141)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,94),T4sum(1:70,25))
  M(23) = M(23) + (f(6) * den(141)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,94),T4sum(1:70,25))
  M(1) = M(1) + (f(6) * den(141)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,14),T4sum(1:70,27))
  M(13) = M(13) + (-f(6) * den(141)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,14),T4sum(1:70,27))
  M(19) = M(19) + (-f(6) * den(141)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,14),T4sum(1:70,27))
  M(23) = M(23) + (f(6) * den(141)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,14),T4sum(1:70,27))
  M(7) = M(7) + (f(6) * den(141)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,62),T4sum(1:70,27))
  M(15) = M(15) + (-f(6) * den(141)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,62),T4sum(1:70,27))
  M(21) = M(21) + (-f(6) * den(141)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,62),T4sum(1:70,27))
  M(24) = M(24) + (f(6) * den(141)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,62),T4sum(1:70,27))
  M(7) = M(7) + (-(CI*f(5)) * den(19)) * TI2_call(5,momenta_144,masses2_6,G5tensor(:,14),T5sum(1:126,145))
  M(21) = M(21) + (CI*f(5) * den(19)) * TI2_call(5,momenta_144,masses2_6,G5tensor(:,14),T5sum(1:126,145))
  M(13) = M(13) + (-(CI*f(5)) * den(19)) * TI2_call(5,momenta_144,masses2_6,G5tensor(:,44),T5sum(1:126,145))
  M(23) = M(23) + (CI*f(5) * den(19)) * TI2_call(5,momenta_144,masses2_6,G5tensor(:,44),T5sum(1:126,145))
  M(15) = M(15) + (-(CI*f(5)) * den(19)) * TI2_call(5,momenta_154,masses2_6,G5tensor(:,29),T5sum(1:126,147))
  M(24) = M(24) + (CI*f(5) * den(19)) * TI2_call(5,momenta_154,masses2_6,G5tensor(:,29),T5sum(1:126,147))
  M(1) = M(1) + (-(CI*f(5)) * den(19)) * TI2_call(5,momenta_154,masses2_6,G5tensor(:,59),T5sum(1:126,147))
  M(19) = M(19) + (CI*f(5) * den(19)) * TI2_call(5,momenta_154,masses2_6,G5tensor(:,59),T5sum(1:126,147))
  M(13) = M(13) + (-(CI*f(5)) * den(19)) * TI2_call(5,momenta_137,masses2_6,G5tensor(:,9),T5sum(1:126,149))
  M(23) = M(23) + (CI*f(5) * den(19)) * TI2_call(5,momenta_137,masses2_6,G5tensor(:,9),T5sum(1:126,149))
  M(7) = M(7) + (-(CI*f(5)) * den(19)) * TI2_call(5,momenta_137,masses2_6,G5tensor(:,39),T5sum(1:126,149))
  M(21) = M(21) + (CI*f(5) * den(19)) * TI2_call(5,momenta_137,masses2_6,G5tensor(:,39),T5sum(1:126,149))
  M(9) = M(9) + (-(CI*f(5)) * den(19)) * TI2_call(5,momenta_153,masses2_6,G5tensor(:,30),T5sum(1:126,151))
  M(22) = M(22) + (CI*f(5) * den(19)) * TI2_call(5,momenta_153,masses2_6,G5tensor(:,30),T5sum(1:126,151))
  M(3) = M(3) + (-(CI*f(5)) * den(19)) * TI2_call(5,momenta_153,masses2_6,G5tensor(:,60),T5sum(1:126,151))
  M(20) = M(20) + (CI*f(5) * den(19)) * TI2_call(5,momenta_153,masses2_6,G5tensor(:,60),T5sum(1:126,151))
  M(1) = M(1) + (-(CI*f(5)) * den(19)) * TI2_call(5,momenta_134,masses2_6,G5tensor(:,10),T5sum(1:126,153))
  M(19) = M(19) + (CI*f(5) * den(19)) * TI2_call(5,momenta_134,masses2_6,G5tensor(:,10),T5sum(1:126,153))
  M(15) = M(15) + (-(CI*f(5)) * den(19)) * TI2_call(5,momenta_134,masses2_6,G5tensor(:,40),T5sum(1:126,153))
  M(24) = M(24) + (CI*f(5) * den(19)) * TI2_call(5,momenta_134,masses2_6,G5tensor(:,40),T5sum(1:126,153))
  M(3) = M(3) + (-(CI*f(5)) * den(19)) * TI2_call(5,momenta_141,masses2_6,G5tensor(:,15),T5sum(1:126,155))
  M(20) = M(20) + (CI*f(5) * den(19)) * TI2_call(5,momenta_141,masses2_6,G5tensor(:,15),T5sum(1:126,155))
  M(9) = M(9) + (-(CI*f(5)) * den(19)) * TI2_call(5,momenta_141,masses2_6,G5tensor(:,45),T5sum(1:126,155))
  M(22) = M(22) + (CI*f(5) * den(19)) * TI2_call(5,momenta_141,masses2_6,G5tensor(:,45),T5sum(1:126,155))
  M(3) = M(3) + (-(CI*f(5)) * den(380)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,42),T3sum(1:35,9))
  M(4) = M(4) + (CI*f(5) * den(380)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,42),T3sum(1:35,9))
  M(11) = M(11) + (CI*f(5) * den(380)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,42),T3sum(1:35,9))
  M(12) = M(12) + (-(CI*f(5)) * den(380)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,42),T3sum(1:35,9))
  M(13) = M(13) + (CI*f(5) * den(380)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,42),T3sum(1:35,9))
  M(14) = M(14) + (-(CI*f(5)) * den(380)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,42),T3sum(1:35,9))
  M(21) = M(21) + (-(CI*f(5)) * den(380)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,42),T3sum(1:35,9))
  M(22) = M(22) + (CI*f(5) * den(380)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,42),T3sum(1:35,9))
  M(3) = M(3) + (-(CI*f(5)) * den(380)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,87),T3sum(1:35,9))
  M(4) = M(4) + (CI*f(5) * den(380)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,87),T3sum(1:35,9))
  M(11) = M(11) + (CI*f(5) * den(380)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,87),T3sum(1:35,9))
  M(12) = M(12) + (-(CI*f(5)) * den(380)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,87),T3sum(1:35,9))
  M(13) = M(13) + (CI*f(5) * den(380)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,87),T3sum(1:35,9))
  M(14) = M(14) + (-(CI*f(5)) * den(380)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,87),T3sum(1:35,9))
  M(21) = M(21) + (-(CI*f(5)) * den(380)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,87),T3sum(1:35,9))
  M(22) = M(22) + (CI*f(5) * den(380)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,87),T3sum(1:35,9))
  M(12) = M(12) + (-f(6) * den(170)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,47),T4sum(1:70,31))
  M(13) = M(13) + (f(6) * den(170)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,47),T4sum(1:70,31))
  M(14) = M(14) + (-f(6) * den(170)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,47),T4sum(1:70,31))
  M(22) = M(22) + (f(6) * den(170)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,47),T4sum(1:70,31))
  M(3) = M(3) + (f(6) * den(170)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,95),T4sum(1:70,31))
  M(4) = M(4) + (-f(6) * den(170)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,95),T4sum(1:70,31))
  M(11) = M(11) + (-f(6) * den(170)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,95),T4sum(1:70,31))
  M(21) = M(21) + (f(6) * den(170)) * TI2_call(4,momenta_40,masses2_4,G4tensor(:,95),T4sum(1:70,31))
  M(3) = M(3) + (f(6) * den(170)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,24),T4sum(1:70,33))
  M(4) = M(4) + (-f(6) * den(170)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,24),T4sum(1:70,33))
  M(11) = M(11) + (-f(6) * den(170)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,24),T4sum(1:70,33))
  M(21) = M(21) + (f(6) * den(170)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,24),T4sum(1:70,33))
  M(12) = M(12) + (-f(6) * den(170)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,72),T4sum(1:70,33))
  M(13) = M(13) + (f(6) * den(170)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,72),T4sum(1:70,33))
  M(14) = M(14) + (-f(6) * den(170)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,72),T4sum(1:70,33))
  M(22) = M(22) + (f(6) * den(170)) * TI2_call(4,momenta_33,masses2_4,G4tensor(:,72),T4sum(1:70,33))
  M(2) = M(2) + (CI*f(5) * den(381)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,43),T3sum(1:35,9))
  M(3) = M(3) + (-(CI*f(5)) * den(381)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,43),T3sum(1:35,9))
  M(4) = M(4) + (CI*f(5) * den(381)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,43),T3sum(1:35,9))
  M(5) = M(5) + (-(CI*f(5)) * den(381)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,43),T3sum(1:35,9))
  M(12) = M(12) + (-(CI*f(5)) * den(381)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,43),T3sum(1:35,9))
  M(16) = M(16) + (CI*f(5) * den(381)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,43),T3sum(1:35,9))
  M(18) = M(18) + (-(CI*f(5)) * den(381)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,43),T3sum(1:35,9))
  M(22) = M(22) + (CI*f(5) * den(381)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,43),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(5) * den(381)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,88),T3sum(1:35,9))
  M(3) = M(3) + (-(CI*f(5)) * den(381)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,88),T3sum(1:35,9))
  M(4) = M(4) + (CI*f(5) * den(381)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,88),T3sum(1:35,9))
  M(5) = M(5) + (-(CI*f(5)) * den(381)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,88),T3sum(1:35,9))
  M(12) = M(12) + (-(CI*f(5)) * den(381)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,88),T3sum(1:35,9))
  M(16) = M(16) + (CI*f(5) * den(381)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,88),T3sum(1:35,9))
  M(18) = M(18) + (-(CI*f(5)) * den(381)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,88),T3sum(1:35,9))
  M(22) = M(22) + (CI*f(5) * den(381)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,88),T3sum(1:35,9))
  M(12) = M(12) + (f(6) * den(91)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,5),T4sum(1:70,5))
  M(16) = M(16) + (-f(6) * den(91)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,5),T4sum(1:70,5))
  M(18) = M(18) + (f(6) * den(91)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,5),T4sum(1:70,5))
  M(22) = M(22) + (-f(6) * den(91)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,5),T4sum(1:70,5))
  M(2) = M(2) + (f(6) * den(91)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,53),T4sum(1:70,5))
  M(3) = M(3) + (-f(6) * den(91)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,53),T4sum(1:70,5))
  M(4) = M(4) + (f(6) * den(91)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,53),T4sum(1:70,5))
  M(5) = M(5) + (-f(6) * den(91)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,53),T4sum(1:70,5))
  M(12) = M(12) + (CI*f(5) * den(55)) * TI2_call(5,momenta_131,masses2_6,G5tensor(:,3),T5sum(1:126,205))
  M(22) = M(22) + (-(CI*f(5)) * den(55)) * TI2_call(5,momenta_131,masses2_6,G5tensor(:,3),T5sum(1:126,205))
  M(3) = M(3) + (CI*f(5) * den(55)) * TI2_call(5,momenta_131,masses2_6,G5tensor(:,33),T5sum(1:126,205))
  M(4) = M(4) + (-(CI*f(5)) * den(55)) * TI2_call(5,momenta_131,masses2_6,G5tensor(:,33),T5sum(1:126,205))
  M(13) = M(13) + (CI*f(5) * den(55)) * TI2_call(5,momenta_155,masses2_6,G5tensor(:,25),T5sum(1:126,207))
  M(14) = M(14) + (-(CI*f(5)) * den(55)) * TI2_call(5,momenta_155,masses2_6,G5tensor(:,25),T5sum(1:126,207))
  M(11) = M(11) + (CI*f(5) * den(55)) * TI2_call(5,momenta_155,masses2_6,G5tensor(:,55),T5sum(1:126,207))
  M(21) = M(21) + (-(CI*f(5)) * den(55)) * TI2_call(5,momenta_155,masses2_6,G5tensor(:,55),T5sum(1:126,207))
  M(16) = M(16) + (CI*f(5) * den(55)) * TI2_call(5,momenta_128,masses2_6,G5tensor(:,4),T5sum(1:126,209))
  M(18) = M(18) + (-(CI*f(5)) * den(55)) * TI2_call(5,momenta_128,masses2_6,G5tensor(:,4),T5sum(1:126,209))
  M(2) = M(2) + (CI*f(5) * den(55)) * TI2_call(5,momenta_128,masses2_6,G5tensor(:,34),T5sum(1:126,209))
  M(5) = M(5) + (-(CI*f(5)) * den(55)) * TI2_call(5,momenta_128,masses2_6,G5tensor(:,34),T5sum(1:126,209))
  M(11) = M(11) + (CI*f(5) * den(55)) * TI2_call(5,momenta_140,masses2_6,G5tensor(:,16),T5sum(1:126,211))
  M(21) = M(21) + (-(CI*f(5)) * den(55)) * TI2_call(5,momenta_140,masses2_6,G5tensor(:,16),T5sum(1:126,211))
  M(13) = M(13) + (CI*f(5) * den(55)) * TI2_call(5,momenta_140,masses2_6,G5tensor(:,46),T5sum(1:126,211))
  M(14) = M(14) + (-(CI*f(5)) * den(55)) * TI2_call(5,momenta_140,masses2_6,G5tensor(:,46),T5sum(1:126,211))
  M(1) = M(1) + (-(CI*f(5)) * den(386)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,44),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(5) * den(386)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,44),T3sum(1:35,9))
  M(7) = M(7) + (CI*f(5) * den(386)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,44),T3sum(1:35,9))
  M(8) = M(8) + (-(CI*f(5)) * den(386)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,44),T3sum(1:35,9))
  M(17) = M(17) + (CI*f(5) * den(386)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,44),T3sum(1:35,9))
  M(18) = M(18) + (-(CI*f(5)) * den(386)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,44),T3sum(1:35,9))
  M(23) = M(23) + (-(CI*f(5)) * den(386)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,44),T3sum(1:35,9))
  M(24) = M(24) + (CI*f(5) * den(386)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,44),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(386)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,89),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(5) * den(386)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,89),T3sum(1:35,9))
  M(7) = M(7) + (CI*f(5) * den(386)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,89),T3sum(1:35,9))
  M(8) = M(8) + (-(CI*f(5)) * den(386)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,89),T3sum(1:35,9))
  M(17) = M(17) + (CI*f(5) * den(386)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,89),T3sum(1:35,9))
  M(18) = M(18) + (-(CI*f(5)) * den(386)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,89),T3sum(1:35,9))
  M(23) = M(23) + (-(CI*f(5)) * den(386)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,89),T3sum(1:35,9))
  M(24) = M(24) + (CI*f(5) * den(386)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,89),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(387)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,45),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(5) * den(387)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,45),T3sum(1:35,9))
  M(4) = M(4) + (CI*f(5) * den(387)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,45),T3sum(1:35,9))
  M(6) = M(6) + (-(CI*f(5)) * den(387)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,45),T3sum(1:35,9))
  M(10) = M(10) + (CI*f(5) * den(387)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,45),T3sum(1:35,9))
  M(12) = M(12) + (-(CI*f(5)) * den(387)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,45),T3sum(1:35,9))
  M(18) = M(18) + (-(CI*f(5)) * den(387)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,45),T3sum(1:35,9))
  M(24) = M(24) + (CI*f(5) * den(387)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,45),T3sum(1:35,9))
  M(1) = M(1) + (-(CI*f(5)) * den(387)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,90),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(5) * den(387)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,90),T3sum(1:35,9))
  M(4) = M(4) + (CI*f(5) * den(387)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,90),T3sum(1:35,9))
  M(6) = M(6) + (-(CI*f(5)) * den(387)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,90),T3sum(1:35,9))
  M(10) = M(10) + (CI*f(5) * den(387)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,90),T3sum(1:35,9))
  M(12) = M(12) + (-(CI*f(5)) * den(387)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,90),T3sum(1:35,9))
  M(18) = M(18) + (-(CI*f(5)) * den(387)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,90),T3sum(1:35,9))
  M(24) = M(24) + (CI*f(5) * den(387)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,90),T3sum(1:35,9))
  M(7) = M(7) + (f(6) * den(143)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,48),T4sum(1:70,25))
  M(8) = M(8) + (-f(6) * den(143)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,48),T4sum(1:70,25))
  M(18) = M(18) + (-f(6) * den(143)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,48),T4sum(1:70,25))
  M(24) = M(24) + (f(6) * den(143)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,48),T4sum(1:70,25))
  M(1) = M(1) + (f(6) * den(143)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,96),T4sum(1:70,25))
  M(2) = M(2) + (-f(6) * den(143)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,96),T4sum(1:70,25))
  M(17) = M(17) + (-f(6) * den(143)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,96),T4sum(1:70,25))
  M(23) = M(23) + (f(6) * den(143)) * TI2_call(4,momenta_42,masses2_4,G4tensor(:,96),T4sum(1:70,25))
  M(1) = M(1) + (f(6) * den(143)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,15),T4sum(1:70,27))
  M(2) = M(2) + (-f(6) * den(143)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,15),T4sum(1:70,27))
  M(17) = M(17) + (-f(6) * den(143)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,15),T4sum(1:70,27))
  M(23) = M(23) + (f(6) * den(143)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,15),T4sum(1:70,27))
  M(7) = M(7) + (f(6) * den(143)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,63),T4sum(1:70,27))
  M(8) = M(8) + (-f(6) * den(143)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,63),T4sum(1:70,27))
  M(18) = M(18) + (-f(6) * den(143)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,63),T4sum(1:70,27))
  M(24) = M(24) + (f(6) * den(143)) * TI2_call(4,momenta_31,masses2_4,G4tensor(:,63),T4sum(1:70,27))
  M(10) = M(10) + (-f(6) * den(95)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,6),T4sum(1:70,5))
  M(12) = M(12) + (f(6) * den(95)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,6),T4sum(1:70,5))
  M(18) = M(18) + (f(6) * den(95)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,6),T4sum(1:70,5))
  M(24) = M(24) + (-f(6) * den(95)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,6),T4sum(1:70,5))
  M(1) = M(1) + (-f(6) * den(95)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,54),T4sum(1:70,5))
  M(2) = M(2) + (f(6) * den(95)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,54),T4sum(1:70,5))
  M(4) = M(4) + (f(6) * den(95)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,54),T4sum(1:70,5))
  M(6) = M(6) + (-f(6) * den(95)) * TI2_call(4,momenta_30,masses2_4,G4tensor(:,54),T4sum(1:70,5))
  M(18) = M(18) + (CI*f(5) * den(61)) * TI2_call(5,momenta_132,masses2_6,G5tensor(:,5),T5sum(1:126,229))
  M(24) = M(24) + (-(CI*f(5)) * den(61)) * TI2_call(5,momenta_132,masses2_6,G5tensor(:,5),T5sum(1:126,229))
  M(1) = M(1) + (CI*f(5) * den(61)) * TI2_call(5,momenta_132,masses2_6,G5tensor(:,35),T5sum(1:126,229))
  M(2) = M(2) + (-(CI*f(5)) * den(61)) * TI2_call(5,momenta_132,masses2_6,G5tensor(:,35),T5sum(1:126,229))
  M(7) = M(7) + (CI*f(5) * den(61)) * TI2_call(5,momenta_156,masses2_6,G5tensor(:,22),T5sum(1:126,231))
  M(8) = M(8) + (-(CI*f(5)) * den(61)) * TI2_call(5,momenta_156,masses2_6,G5tensor(:,22),T5sum(1:126,231))
  M(17) = M(17) + (CI*f(5) * den(61)) * TI2_call(5,momenta_156,masses2_6,G5tensor(:,52),T5sum(1:126,231))
  M(23) = M(23) + (-(CI*f(5)) * den(61)) * TI2_call(5,momenta_156,masses2_6,G5tensor(:,52),T5sum(1:126,231))
  M(10) = M(10) + (CI*f(5) * den(61)) * TI2_call(5,momenta_127,masses2_6,G5tensor(:,6),T5sum(1:126,233))
  M(12) = M(12) + (-(CI*f(5)) * den(61)) * TI2_call(5,momenta_127,masses2_6,G5tensor(:,6),T5sum(1:126,233))
  M(4) = M(4) + (CI*f(5) * den(61)) * TI2_call(5,momenta_127,masses2_6,G5tensor(:,36),T5sum(1:126,233))
  M(6) = M(6) + (-(CI*f(5)) * den(61)) * TI2_call(5,momenta_127,masses2_6,G5tensor(:,36),T5sum(1:126,233))
  M(17) = M(17) + (CI*f(5) * den(61)) * TI2_call(5,momenta_133,masses2_6,G5tensor(:,11),T5sum(1:126,235))
  M(23) = M(23) + (-(CI*f(5)) * den(61)) * TI2_call(5,momenta_133,masses2_6,G5tensor(:,11),T5sum(1:126,235))
  M(7) = M(7) + (CI*f(5) * den(61)) * TI2_call(5,momenta_133,masses2_6,G5tensor(:,41),T5sum(1:126,235))
  M(8) = M(8) + (-(CI*f(5)) * den(61)) * TI2_call(5,momenta_133,masses2_6,G5tensor(:,41),T5sum(1:126,235))
  M(18) = M(18) + (-f(6)) * TI2_call(6,momenta_238,masses2_8,G6tensor(:,3),T6sum(1:210,49))
  M(2) = M(2) + (-f(6)) * TI2_call(6,momenta_238,masses2_8,G6tensor(:,21),T6sum(1:210,49))
  M(24) = M(24) + (-f(6)) * TI2_call(6,momenta_240,masses2_8,G6tensor(:,1),T6sum(1:210,51))
  M(1) = M(1) + (-f(6)) * TI2_call(6,momenta_240,masses2_8,G6tensor(:,19),T6sum(1:210,51))
  M(8) = M(8) + (-f(6)) * TI2_call(6,momenta_252,masses2_8,G6tensor(:,15),T6sum(1:210,53))
  M(17) = M(17) + (-f(6)) * TI2_call(6,momenta_252,masses2_8,G6tensor(:,33),T6sum(1:210,53))
  M(7) = M(7) + (-f(6)) * TI2_call(6,momenta_248,masses2_8,G6tensor(:,11),T6sum(1:210,55))
  M(23) = M(23) + (-f(6)) * TI2_call(6,momenta_248,masses2_8,G6tensor(:,29),T6sum(1:210,55))
  M(21) = M(21) + (-f(6)) * TI2_call(6,momenta_246,masses2_8,G6tensor(:,13),T6sum(1:210,57))
  M(13) = M(13) + (-f(6)) * TI2_call(6,momenta_246,masses2_8,G6tensor(:,31),T6sum(1:210,57))
  M(15) = M(15) + (-f(6)) * TI2_call(6,momenta_250,masses2_8,G6tensor(:,17),T6sum(1:210,59))
  M(19) = M(19) + (-f(6)) * TI2_call(6,momenta_250,masses2_8,G6tensor(:,35),T6sum(1:210,59))
  M(12) = M(12) + (-f(6)) * TI2_call(6,momenta_236,masses2_8,G6tensor(:,5),T6sum(1:210,61))
  M(4) = M(4) + (-f(6)) * TI2_call(6,momenta_236,masses2_8,G6tensor(:,23),T6sum(1:210,61))
  M(22) = M(22) + (-f(6)) * TI2_call(6,momenta_239,masses2_8,G6tensor(:,2),T6sum(1:210,63))
  M(3) = M(3) + (-f(6)) * TI2_call(6,momenta_239,masses2_8,G6tensor(:,20),T6sum(1:210,63))
  M(14) = M(14) + (-f(6)) * TI2_call(6,momenta_251,masses2_8,G6tensor(:,16),T6sum(1:210,65))
  M(11) = M(11) + (-f(6)) * TI2_call(6,momenta_251,masses2_8,G6tensor(:,34),T6sum(1:210,65))
  M(23) = M(23) + (-f(6)) * TI2_call(6,momenta_242,masses2_8,G6tensor(:,9),T6sum(1:210,67))
  M(7) = M(7) + (-f(6)) * TI2_call(6,momenta_242,masses2_8,G6tensor(:,27),T6sum(1:210,67))
  M(9) = M(9) + (-f(6)) * TI2_call(6,momenta_249,masses2_8,G6tensor(:,18),T6sum(1:210,69))
  M(20) = M(20) + (-f(6)) * TI2_call(6,momenta_249,masses2_8,G6tensor(:,36),T6sum(1:210,69))
  M(13) = M(13) + (-f(6)) * TI2_call(6,momenta_244,masses2_8,G6tensor(:,7),T6sum(1:210,71))
  M(21) = M(21) + (-f(6)) * TI2_call(6,momenta_244,masses2_8,G6tensor(:,25),T6sum(1:210,71))
  M(10) = M(10) + (-f(6)) * TI2_call(6,momenta_235,masses2_8,G6tensor(:,6),T6sum(1:210,73))
  M(6) = M(6) + (-f(6)) * TI2_call(6,momenta_235,masses2_8,G6tensor(:,24),T6sum(1:210,73))
  M(16) = M(16) + (-f(6)) * TI2_call(6,momenta_237,masses2_8,G6tensor(:,4),T6sum(1:210,75))
  M(5) = M(5) + (-f(6)) * TI2_call(6,momenta_237,masses2_8,G6tensor(:,22),T6sum(1:210,75))
  M(17) = M(17) + (-f(6)) * TI2_call(6,momenta_241,masses2_8,G6tensor(:,10),T6sum(1:210,77))
  M(8) = M(8) + (-f(6)) * TI2_call(6,momenta_241,masses2_8,G6tensor(:,28),T6sum(1:210,77))
  M(11) = M(11) + (-f(6)) * TI2_call(6,momenta_245,masses2_8,G6tensor(:,14),T6sum(1:210,79))
  M(14) = M(14) + (-f(6)) * TI2_call(6,momenta_245,masses2_8,G6tensor(:,32),T6sum(1:210,79))
  M(20) = M(20) + (-f(6)) * TI2_call(6,momenta_247,masses2_8,G6tensor(:,12),T6sum(1:210,81))
  M(9) = M(9) + (-f(6)) * TI2_call(6,momenta_247,masses2_8,G6tensor(:,30),T6sum(1:210,81))
  M(19) = M(19) + (-f(6)) * TI2_call(6,momenta_243,masses2_8,G6tensor(:,8),T6sum(1:210,83))
  M(15) = M(15) + (-f(6)) * TI2_call(6,momenta_243,masses2_8,G6tensor(:,26),T6sum(1:210,83))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_4

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)
  deallocate(G6tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_4_pphjjj2_hggggg_2_/**/REALKIND
